
module ol_vamp_1_ppwttj_ew_uxttxdwxg_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwttj_ew_uxttxdwxg_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwttj_ew_uxttxdwxg_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwttj_ew_uxttxdwxg_3_/**/DREALKIND
  use ol_tensor_sum_storage_ppwttj_ew_uxttxdwxg_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwttj_ew_uxttxdwxg_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwttj_ew_uxttxdwxg_3_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(6,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(105)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1),h0tab(:,1),[32,4,8,1,2,16],[nMT,0,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,1),heltab2x96(:,:,1))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(1),n2h48(1))
  Gcoeff(:)%j = (c(109)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2),h0tab(:,2),[32,4,8,1,2,16],[nMT,nMZ,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,2),heltab2x96(:,:,2))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(2),n2h48(2))
  Gcoeff(:)%j = (c(113)*M(1,:)%j-c(112)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(3),h0tab(:,3),[32,4,8,1,2,16],[nMT,0,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,3),heltab2x96(:,:,3))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(3),n2h48(3))
  Gcoeff(:)%j = (c(110)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4),h0tab(:,4),[32,4,16,2,1,8],[0,nMT,nMB,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(4),m3h2x48(:,4),heltab2x96(:,:,4))
  Gcoeff(:)%j = (-(c(105)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5),h0tab(:,5),[32,2,1,8,4,16],[nMB,nMW,0,0,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,5),heltab2x96(:,:,5))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(5),n2h48(4))
  Gcoeff(:)%j = (c(109)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(6),h0tab(:,6),[32,2,1,8,4,16],[nMB,nMW,0,nMZ,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,6),heltab2x96(:,:,6))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(6),n2h48(5))
  Gcoeff(:)%j = (c(113)*M(1,:)%j-c(112)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(7),h0tab(:,7),[32,2,1,8,4,16],[nMB,nMW,0,0,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,7),heltab2x96(:,:,7))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(7),n2h48(6))
  Gcoeff(:)%j = (-(c(77)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(8),h0tab(:,8),[32,2,1,8,16,4],[nMT,0,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,8),heltab2x96(:,:,8))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(8),n2h48(7))
  Gcoeff(:)%j = (-(c(106)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(9),h0tab(:,9),[32,2,1,8,16,4],[nMB,nMW,0,0,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,9),heltab2x96(:,:,9))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(9),n2h48(8))
  Gcoeff(:)%j = (-(c(80)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(10),h0tab(:,10),[32,2,1,8,16,4],[nMT,nMZ,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,10),heltab2x96(:,:,10))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(10),n2h48(9))
  Gcoeff(:)%j = (-(c(142)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(11),h0tab(:,11),[32,2,1,8,16,4],[nMB,nMW,0,nMZ,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,11),heltab2x96(:,:,11))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(11),n2h48(10))
  Gcoeff(:)%j = (c(85)*M(4,:)%j-c(86)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(12),h0tab(:,12),[32,2,1,8,16,4],[nMT,0,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,12),heltab2x96(:,:,12))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(12),n2h48(11))
  Gcoeff(:)%j = (c(151)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(13),h0tab(:,13),[32,2,1,8,16,4],[nMT,0,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,13),heltab2x96(:,:,13))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(13),n2h48(12))
  Gcoeff(:)%j = (c(129)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(14),h0tab(:,14),[32,2,1,8,16,4],[nMT,0,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,14),heltab2x96(:,:,14))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(14),n2h48(13))
  Gcoeff(:)%j = (c(154)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(15),h0tab(:,15),[32,2,1,8,16,4],[nMT,nMZ,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,15),heltab2x96(:,:,15))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(15),n2h48(14))
  Gcoeff(:)%j = (c(131)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(16),h0tab(:,16),[32,2,1,8,16,4],[nMT,nMZ,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,16),heltab2x96(:,:,16))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(16),n2h48(15))
  Gcoeff(:)%j = (-(c(106)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(17),h0tab(:,17),[32,2,1,8,16,4],[nMB,nMW,0,0,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,17),heltab2x96(:,:,17))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(17),n2h48(16))
  Gcoeff(:)%j = (c(63)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(18),h0tab(:,18),[32,2,1,8,16,4],[nMB,nMW,0,nMZ,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,18),heltab2x96(:,:,18))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(18),n2h48(17))
  Gcoeff(:)%j = (-(c(176)*M(4,:)%j)+c(177)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(19),h0tab(:,19),[32,2,1,8,16,4],[nMT,0,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,19),heltab2x96(:,:,19))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(19),n2h48(18))
  Gcoeff(:)%j = (-(c(134)*M(4,:)%j)+c(135)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(20),h0tab(:,20),[32,2,1,8,16,4],[nMT,0,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,20),heltab2x96(:,:,20))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(20),n2h48(19))
  Gcoeff(:)%j = (-(c(146)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(21),h0tab(:,21),[32,8,4,2,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,21),heltab2x96(:,:,21))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(21),n2h48(20))
  Gcoeff(:)%j = (c(153)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(22),h0tab(:,22),[32,8,4,2,1,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,22),heltab2x96(:,:,22))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(22),n2h48(21))
  Gcoeff(:)%j = (-(c(150)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(23),h0tab(:,23),[32,8,4,2,1,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,23),heltab2x96(:,:,23))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(23),n2h48(22))
  Gcoeff(:)%j = (c(155)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(24),h0tab(:,24),[32,8,4,2,1,16],[0,nMZ,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,24),heltab2x96(:,:,24))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(24),n2h48(23))
  Gcoeff(:)%j = (c(174)*M(1,:)%j-c(173)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(25),h0tab(:,25),[32,8,4,2,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,25),heltab2x96(:,:,25))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(25),n2h48(24))
  Gcoeff(:)%j = (c(168)*M(2,:)%j-c(169)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(26),h0tab(:,26),[32,8,4,2,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,26),heltab2x96(:,:,26))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(26),n2h48(25))
  Gcoeff(:)%j = (c(180)*M(1,:)%j-c(179)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(27),h0tab(:,27),[32,8,4,2,1,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,27),heltab2x96(:,:,27))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(27),n2h48(26))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)+c(180)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(28),h0tab(:,28),[32,8,4,2,1,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,28),heltab2x96(:,:,28))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(28),n2h48(27))
  Gcoeff(:)%j = (c(160)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(29),h0tab(:,29),[32,4,2,1,16,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(29),m3h2x48(:,29),heltab2x96(:,:,29))
  Gcoeff(:)%j = (c(164)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(30),h0tab(:,30),[32,4,2,1,16,8],[0,nMT,nMZ,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(30),m3h2x48(:,30),heltab2x96(:,:,30))
  Gcoeff(:)%j = (-(c(146)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(31),h0tab(:,31),[32,2,1,16,8,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,31),heltab2x96(:,:,31))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(31),n2h48(28))
  Gcoeff(:)%j = (c(153)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(32),h0tab(:,32),[32,2,1,16,8,4],[nMT,0,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,32),heltab2x96(:,:,32))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(32),n2h48(29))
  Gcoeff(:)%j = (-(c(150)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(33),h0tab(:,33),[32,2,1,16,8,4],[nMT,nMZ,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,33),heltab2x96(:,:,33))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(33),n2h48(30))
  Gcoeff(:)%j = (c(155)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(34),h0tab(:,34),[32,2,1,16,8,4],[nMT,nMZ,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,34),heltab2x96(:,:,34))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(34),n2h48(31))
  Gcoeff(:)%j = (c(174)*M(1,:)%j-c(173)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(35),h0tab(:,35),[32,2,1,16,8,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,35),heltab2x96(:,:,35))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(35),n2h48(32))
  Gcoeff(:)%j = (c(168)*M(4,:)%j-c(169)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(36),h0tab(:,36),[32,2,1,16,8,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,36),heltab2x96(:,:,36))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(36),n2h48(33))
  Gcoeff(:)%j = (c(180)*M(1,:)%j-c(179)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(37),h0tab(:,37),[32,2,1,16,8,4],[nMT,nMZ,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,37),heltab2x96(:,:,37))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(37),n2h48(34))
  Gcoeff(:)%j = (-(c(179)*M(4,:)%j)+c(180)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(38),h0tab(:,38),[32,2,1,16,8,4],[nMT,0,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,38),heltab2x96(:,:,38))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(38),n2h48(35))
  Gcoeff(:)%j = (-(c(146)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(39),h0tab(:,39),[32,1,2,4,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,39),heltab2x96(:,:,39))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(39),n2h48(36))
  Gcoeff(:)%j = (c(153)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(40),h0tab(:,40),[32,1,2,4,8,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,40),heltab2x96(:,:,40))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(40),n2h48(37))
  Gcoeff(:)%j = (-(c(150)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(41),h0tab(:,41),[32,1,2,4,8,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,41),heltab2x96(:,:,41))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(41),n2h48(38))
  Gcoeff(:)%j = (c(155)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(42),h0tab(:,42),[32,1,2,4,8,16],[0,nMZ,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,42),heltab2x96(:,:,42))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(42),n2h48(39))
  Gcoeff(:)%j = (c(174)*M(1,:)%j-c(173)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(43),h0tab(:,43),[32,1,2,4,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,43),heltab2x96(:,:,43))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(43),n2h48(40))
  Gcoeff(:)%j = (c(168)*M(2,:)%j-c(169)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(44),h0tab(:,44),[32,1,2,4,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,44),heltab2x96(:,:,44))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(44),n2h48(41))
  Gcoeff(:)%j = (c(180)*M(1,:)%j-c(179)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(45),h0tab(:,45),[32,1,2,4,8,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,45),heltab2x96(:,:,45))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(45),n2h48(42))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)+c(180)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(46),h0tab(:,46),[32,1,2,4,8,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,46),heltab2x96(:,:,46))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(46),n2h48(43))
  Gcoeff(:)%j = (-(c(77)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(47),h0tab(:,47),[32,1,2,4,16,8],[0,0,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,47),heltab2x96(:,:,47))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(47),n2h48(44))
  Gcoeff(:)%j = (-(c(106)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(48),h0tab(:,48),[32,1,2,4,16,8],[0,nMW,nMB,nMW,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,48),heltab2x96(:,:,48))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(48),n2h48(45))
  Gcoeff(:)%j = (-(c(80)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(49),h0tab(:,49),[32,1,2,4,16,8],[0,nMZ,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,49),heltab2x96(:,:,49))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(49),n2h48(46))
  Gcoeff(:)%j = (-(c(142)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(50),h0tab(:,50),[32,1,2,4,16,8],[0,nMW,nMB,nMW,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,50),heltab2x96(:,:,50))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(50),n2h48(47))
  Gcoeff(:)%j = (c(85)*M(2,:)%j-c(86)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(51),h0tab(:,51),[32,1,2,4,16,8],[0,0,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,51),heltab2x96(:,:,51))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(51),n2h48(48))
  Gcoeff(:)%j = (c(151)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(52),h0tab(:,52),[32,1,2,4,16,8],[0,0,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,52),heltab2x96(:,:,52))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(52),n2h48(49))
  Gcoeff(:)%j = (c(129)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(53),h0tab(:,53),[32,1,2,4,16,8],[0,0,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,53),heltab2x96(:,:,53))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(53),n2h48(50))
  Gcoeff(:)%j = (c(154)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(54),h0tab(:,54),[32,1,2,4,16,8],[0,nMZ,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,54),heltab2x96(:,:,54))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(54),n2h48(51))
  Gcoeff(:)%j = (c(131)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(55),h0tab(:,55),[32,1,2,4,16,8],[0,nMZ,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,55),heltab2x96(:,:,55))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(55),n2h48(52))
  Gcoeff(:)%j = (-(c(106)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(56),h0tab(:,56),[32,1,2,4,16,8],[0,nMW,nMB,nMW,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,56),heltab2x96(:,:,56))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(56),n2h48(53))
  Gcoeff(:)%j = (c(63)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(57),h0tab(:,57),[32,1,2,4,16,8],[0,nMW,nMB,nMW,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,57),heltab2x96(:,:,57))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(57),n2h48(54))
  Gcoeff(:)%j = (-(c(176)*M(2,:)%j)+c(177)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(58),h0tab(:,58),[32,1,2,4,16,8],[0,0,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,58),heltab2x96(:,:,58))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(58),n2h48(55))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)+c(135)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(59),h0tab(:,59),[32,1,2,4,16,8],[0,0,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,59),heltab2x96(:,:,59))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(59),n2h48(56))
  Gcoeff(:)%j = (-(c(105)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(60),h0tab(:,60),[32,1,2,16,4,8],[0,nMW,nMB,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,60),heltab2x96(:,:,60))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(60),n2h48(57))
  Gcoeff(:)%j = (c(109)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(61),h0tab(:,61),[32,1,2,16,4,8],[0,nMW,nMB,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,61),heltab2x96(:,:,61))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(61),n2h48(58))
  Gcoeff(:)%j = (c(113)*M(1,:)%j-c(112)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(62),h0tab(:,62),[32,1,2,16,4,8],[0,nMW,nMB,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,62),heltab2x96(:,:,62))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(62),n2h48(59))
  Gcoeff(:)%j = (c(107)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(63),h0tab(:,63),[32,4,1,8,2,16],[nMT,0,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,63),heltab2x96(:,:,63))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(63),n2h48(60))
  Gcoeff(:)%j = (c(109)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(64),h0tab(:,64),[32,4,1,8,2,16],[nMT,nMZ,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,64),heltab2x96(:,:,64))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(64),n2h48(61))
  Gcoeff(:)%j = (c(113)*M(1,:)%j-c(112)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(65),h0tab(:,65),[32,4,1,8,2,16],[nMT,0,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,65),heltab2x96(:,:,65))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(65),n2h48(62))
  Gcoeff(:)%j = (c(107)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(66),h0tab(:,66),[32,2,8,1,4,16],[nMB,nMW,0,0,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,66),heltab2x96(:,:,66))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(66),n2h48(63))
  Gcoeff(:)%j = (c(109)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(67),h0tab(:,67),[32,2,8,1,4,16],[nMB,nMW,0,nMZ,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,67),heltab2x96(:,:,67))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(67),n2h48(64))
  Gcoeff(:)%j = (c(113)*M(1,:)%j-c(112)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(68),h0tab(:,68),[32,2,8,1,4,16],[nMB,nMW,0,0,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,68),heltab2x96(:,:,68))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(68),n2h48(65))
  Gcoeff(:)%j = (-(c(77)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(69),h0tab(:,69),[32,2,16,8,1,4],[nMT,nMH,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,69),heltab2x96(:,:,69))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(69),n2h48(66))
  Gcoeff(:)%j = (-(c(80)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(70),h0tab(:,70),[32,2,16,8,1,4],[nMT,nMH,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,70),heltab2x96(:,:,70))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(70),n2h48(67))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)+c(85)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(71),h0tab(:,71),[32,2,16,8,1,4],[nMT,nMH,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,71),heltab2x96(:,:,71))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(71),n2h48(68))
  Gcoeff(:)%j = (c(151)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(72),h0tab(:,72),[32,2,16,8,1,4],[nMT,0,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,72),heltab2x96(:,:,72))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(72),n2h48(69))
  Gcoeff(:)%j = (c(129)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(73),h0tab(:,73),[32,2,16,8,1,4],[nMT,nMZ,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,73),heltab2x96(:,:,73))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(73),n2h48(70))
  Gcoeff(:)%j = (c(154)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(74),h0tab(:,74),[32,2,16,8,1,4],[nMT,0,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,74),heltab2x96(:,:,74))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(74),n2h48(71))
  Gcoeff(:)%j = (c(131)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(75),h0tab(:,75),[32,2,16,8,1,4],[nMT,nMZ,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,75),heltab2x96(:,:,75))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(75),n2h48(72))
  Gcoeff(:)%j = (c(177)*M(1,:)%j-c(176)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(76),h0tab(:,76),[32,2,16,8,1,4],[nMT,0,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,76),heltab2x96(:,:,76))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(76),n2h48(73))
  Gcoeff(:)%j = (c(135)*M(1,:)%j-c(134)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(77),h0tab(:,77),[32,2,16,8,1,4],[nMT,nMZ,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,77),heltab2x96(:,:,77))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(77),n2h48(74))
  Gcoeff(:)%j = (-(c(146)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(78),h0tab(:,78),[32,8,2,4,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,78),heltab2x96(:,:,78))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(78),n2h48(75))
  Gcoeff(:)%j = (c(153)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(79),h0tab(:,79),[32,8,2,4,1,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,79),heltab2x96(:,:,79))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(79),n2h48(76))
  Gcoeff(:)%j = (-(c(150)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(80),h0tab(:,80),[32,8,2,4,1,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,80),heltab2x96(:,:,80))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(80),n2h48(77))
  Gcoeff(:)%j = (c(155)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(81),h0tab(:,81),[32,8,2,4,1,16],[0,nMZ,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,81),heltab2x96(:,:,81))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(81),n2h48(78))
  Gcoeff(:)%j = (c(174)*M(1,:)%j-c(173)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(82),h0tab(:,82),[32,8,2,4,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,82),heltab2x96(:,:,82))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(82),n2h48(79))
  Gcoeff(:)%j = (c(168)*M(2,:)%j-c(169)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(83),h0tab(:,83),[32,8,2,4,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,83),heltab2x96(:,:,83))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(83),n2h48(80))
  Gcoeff(:)%j = (c(180)*M(1,:)%j-c(179)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(84),h0tab(:,84),[32,8,2,4,1,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,84),heltab2x96(:,:,84))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(84),n2h48(81))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)+c(180)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(85),h0tab(:,85),[32,8,2,4,1,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,85),heltab2x96(:,:,85))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(85),n2h48(82))
  Gcoeff(:)%j = (c(160)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(86),h0tab(:,86),[32,2,4,1,16,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(86),m3h2x48(:,86),heltab2x96(:,:,86))
  Gcoeff(:)%j = (c(164)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(87),h0tab(:,87),[32,2,4,1,16,8],[0,nMT,nMZ,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(87),m3h2x48(:,87),heltab2x96(:,:,87))
  Gcoeff(:)%j = (-(c(146)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(88),h0tab(:,88),[32,2,8,16,1,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,88),heltab2x96(:,:,88))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(88),n2h48(83))
  Gcoeff(:)%j = (c(153)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(89),h0tab(:,89),[32,2,8,16,1,4],[nMT,nMZ,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,89),heltab2x96(:,:,89))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(89),n2h48(84))
  Gcoeff(:)%j = (-(c(150)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(90),h0tab(:,90),[32,2,8,16,1,4],[nMT,0,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,90),heltab2x96(:,:,90))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(90),n2h48(85))
  Gcoeff(:)%j = (c(155)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(91),h0tab(:,91),[32,2,8,16,1,4],[nMT,nMZ,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,91),heltab2x96(:,:,91))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(91),n2h48(86))
  Gcoeff(:)%j = (-(c(173)*M(4,:)%j)+c(174)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(92),h0tab(:,92),[32,2,8,16,1,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,92),heltab2x96(:,:,92))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(92),n2h48(87))
  Gcoeff(:)%j = (-(c(169)*M(1,:)%j)+c(168)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(93),h0tab(:,93),[32,2,8,16,1,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,93),heltab2x96(:,:,93))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(93),n2h48(88))
  Gcoeff(:)%j = (-(c(179)*M(4,:)%j)+c(180)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(94),h0tab(:,94),[32,2,8,16,1,4],[nMT,0,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,94),heltab2x96(:,:,94))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(94),n2h48(89))
  Gcoeff(:)%j = (c(180)*M(1,:)%j-c(179)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(95),h0tab(:,95),[32,2,8,16,1,4],[nMT,nMZ,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,95),heltab2x96(:,:,95))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(95),n2h48(90))
  Gcoeff(:)%j = (-(c(146)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(96),h0tab(:,96),[32,1,4,2,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,96),heltab2x96(:,:,96))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(96),n2h48(91))
  Gcoeff(:)%j = (c(153)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(97),h0tab(:,97),[32,1,4,2,8,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,97),heltab2x96(:,:,97))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(97),n2h48(92))
  Gcoeff(:)%j = (-(c(150)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(98),h0tab(:,98),[32,1,4,2,8,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,98),heltab2x96(:,:,98))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(98),n2h48(93))
  Gcoeff(:)%j = (c(155)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(99),h0tab(:,99),[32,1,4,2,8,16],[0,nMZ,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,99),heltab2x96(:,:,99))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(99),n2h48(94))
  Gcoeff(:)%j = (c(174)*M(1,:)%j-c(173)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(100),h0tab(:,100),[32,1,4,2,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,100),heltab2x96(:,:,100))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(100),n2h48(95))
  Gcoeff(:)%j = (c(168)*M(2,:)%j-c(169)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(101),h0tab(:,101),[32,1,4,2,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,101),heltab2x96(:,:,101))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(101),n2h48(96))
  Gcoeff(:)%j = (c(180)*M(1,:)%j-c(179)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(102),h0tab(:,102),[32,1,4,2,8,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,102),heltab2x96(:,:,102))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(102),n2h48(97))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)+c(180)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(103),h0tab(:,103),[32,1,4,2,8,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,103),heltab2x96(:,:,103))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(103),n2h48(98))
  Gcoeff(:)%j = (-(c(77)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(104),h0tab(:,104),[32,1,4,2,16,8],[0,0,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,104),heltab2x96(:,:,104))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(104),n2h48(99))
  Gcoeff(:)%j = (-(c(80)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(105),h0tab(:,105),[32,1,4,2,16,8],[0,nMZ,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,105),heltab2x96(:,:,105))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(105),n2h48(100))
  Gcoeff(:)%j = (c(85)*M(2,:)%j-c(86)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(106),h0tab(:,106),[32,1,4,2,16,8],[0,0,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,106),heltab2x96(:,:,106))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(106),n2h48(101))
  Gcoeff(:)%j = (c(151)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(107),h0tab(:,107),[32,1,4,2,16,8],[0,0,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,107),heltab2x96(:,:,107))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(107),n2h48(102))
  Gcoeff(:)%j = (c(129)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(108),h0tab(:,108),[32,1,4,2,16,8],[0,0,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,108),heltab2x96(:,:,108))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(108),n2h48(103))
  Gcoeff(:)%j = (c(154)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(109),h0tab(:,109),[32,1,4,2,16,8],[0,nMZ,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,109),heltab2x96(:,:,109))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(109),n2h48(104))
  Gcoeff(:)%j = (c(131)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(110),h0tab(:,110),[32,1,4,2,16,8],[0,nMZ,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,110),heltab2x96(:,:,110))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(110),n2h48(105))
  Gcoeff(:)%j = (-(c(176)*M(2,:)%j)+c(177)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(111),h0tab(:,111),[32,1,4,2,16,8],[0,0,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,111),heltab2x96(:,:,111))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(111),n2h48(106))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)+c(135)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(112),h0tab(:,112),[32,1,4,2,16,8],[0,0,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,112),heltab2x96(:,:,112))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(112),n2h48(107))
  Gcoeff(:)%j = (c(107)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(113),h0tab(:,113),[32,1,4,16,2,8],[0,0,nMT,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,113),heltab2x96(:,:,113))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(113),n2h48(108))
  Gcoeff(:)%j = (c(109)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(114),h0tab(:,114),[32,1,4,16,2,8],[0,nMZ,nMT,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,114),heltab2x96(:,:,114))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(114),n2h48(109))
  Gcoeff(:)%j = (-(c(112)*M(2,:)%j)+c(113)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(115),h0tab(:,115),[32,1,4,16,2,8],[0,0,nMT,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,115),heltab2x96(:,:,115))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(115),n2h48(110))
  Gcoeff(:)%j = (c(83)*(M(1,:)%j-M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(116),h0tab(:,116),[32,4,2,16,1,8],[0,nMT,nMH,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(116),m3h2x48(:,116),heltab2x96(:,:,116))
  Gcoeff(:)%j = (c(162)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(117),h0tab(:,117),[32,4,2,16,1,8],[0,nMT,0,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(117),m3h2x48(:,117),heltab2x96(:,:,117))
  Gcoeff(:)%j = (c(132)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(118),h0tab(:,118),[32,4,2,16,1,8],[0,nMT,nMZ,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(118),m3h2x48(:,118),heltab2x96(:,:,118))
  Gcoeff(:)%j = (c(83)*(M(1,:)%j-M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(119),h0tab(:,119),[32,2,4,16,1,8],[0,nMT,nMH,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(119),m3h2x48(:,119),heltab2x96(:,:,119))
  Gcoeff(:)%j = (c(162)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(120),h0tab(:,120),[32,2,4,16,1,8],[0,nMT,0,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(120),m3h2x48(:,120),heltab2x96(:,:,120))
  Gcoeff(:)%j = (c(132)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(121),h0tab(:,121),[32,2,4,16,1,8],[0,nMT,nMZ,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(121),m3h2x48(:,121),heltab2x96(:,:,121))
  Gcoeff(:)%j = (c(75)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(122),h0tab(:,122),[32,2,8,1,16,4],[nMT,0,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,122),heltab2x96(:,:,122))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(122),n2h48(111))
  Gcoeff(:)%j = (c(108)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(123),h0tab(:,123),[32,2,8,1,16,4],[nMB,nMW,0,0,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,123),heltab2x96(:,:,123))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(123),n2h48(112))
  Gcoeff(:)%j = (-(c(80)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(124),h0tab(:,124),[32,2,8,1,16,4],[nMT,nMZ,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,124),heltab2x96(:,:,124))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(124),n2h48(113))
  Gcoeff(:)%j = (-(c(142)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(125),h0tab(:,125),[32,2,8,1,16,4],[nMB,nMW,0,nMZ,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,125),heltab2x96(:,:,125))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(125),n2h48(114))
  Gcoeff(:)%j = (c(85)*M(4,:)%j-c(86)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(126),h0tab(:,126),[32,2,8,1,16,4],[nMT,0,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,126),heltab2x96(:,:,126))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(126),n2h48(115))
  Gcoeff(:)%j = (-(c(148)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(127),h0tab(:,127),[32,2,8,1,16,4],[nMT,0,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,127),heltab2x96(:,:,127))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(127),n2h48(116))
  Gcoeff(:)%j = (-(c(127)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(128),h0tab(:,128),[32,2,8,1,16,4],[nMT,0,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,128),heltab2x96(:,:,128))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(128),n2h48(117))
  Gcoeff(:)%j = (c(154)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(129),h0tab(:,129),[32,2,8,1,16,4],[nMT,nMZ,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,129),heltab2x96(:,:,129))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(129),n2h48(118))
  Gcoeff(:)%j = (c(131)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(130),h0tab(:,130),[32,2,8,1,16,4],[nMT,nMZ,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,130),heltab2x96(:,:,130))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(130),n2h48(119))
  Gcoeff(:)%j = (c(108)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(131),h0tab(:,131),[32,2,8,1,16,4],[nMB,nMW,0,0,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,131),heltab2x96(:,:,131))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(131),n2h48(120))
  Gcoeff(:)%j = (c(63)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(132),h0tab(:,132),[32,2,8,1,16,4],[nMB,nMW,0,nMZ,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,132),heltab2x96(:,:,132))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(132),n2h48(121))
  Gcoeff(:)%j = (-(c(176)*M(4,:)%j)+c(177)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(133),h0tab(:,133),[32,2,8,1,16,4],[nMT,0,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,133),heltab2x96(:,:,133))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(133),n2h48(122))
  Gcoeff(:)%j = (-(c(134)*M(4,:)%j)+c(135)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(134),h0tab(:,134),[32,2,8,1,16,4],[nMT,0,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,134),heltab2x96(:,:,134))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(134),n2h48(123))
  Gcoeff(:)%j = (c(75)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(135),h0tab(:,135),[32,2,16,1,8,4],[nMT,nMH,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,135),heltab2x96(:,:,135))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(135),n2h48(124))
  Gcoeff(:)%j = (-(c(80)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(136),h0tab(:,136),[32,2,16,1,8,4],[nMT,nMH,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,136),heltab2x96(:,:,136))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(136),n2h48(125))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)+c(85)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(137),h0tab(:,137),[32,2,16,1,8,4],[nMT,nMH,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,137),heltab2x96(:,:,137))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(137),n2h48(126))
  Gcoeff(:)%j = (-(c(148)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(138),h0tab(:,138),[32,2,16,1,8,4],[nMT,0,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,138),heltab2x96(:,:,138))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(138),n2h48(127))
  Gcoeff(:)%j = (c(154)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(139),h0tab(:,139),[32,2,16,1,8,4],[nMT,0,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,139),heltab2x96(:,:,139))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(139),n2h48(128))
  Gcoeff(:)%j = (-(c(127)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(140),h0tab(:,140),[32,2,16,1,8,4],[nMT,nMZ,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,140),heltab2x96(:,:,140))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(140),n2h48(129))
  Gcoeff(:)%j = (c(131)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(141),h0tab(:,141),[32,2,16,1,8,4],[nMT,nMZ,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,141),heltab2x96(:,:,141))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(141),n2h48(130))
  Gcoeff(:)%j = (c(177)*M(1,:)%j-c(176)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(142),h0tab(:,142),[32,2,16,1,8,4],[nMT,0,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,142),heltab2x96(:,:,142))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(142),n2h48(131))
  Gcoeff(:)%j = (c(135)*M(1,:)%j-c(134)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(143),h0tab(:,143),[32,2,16,1,8,4],[nMT,nMZ,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,143),heltab2x96(:,:,143))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(143),n2h48(132))
  Gcoeff(:)%j = (c(83)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(144),h0tab(:,144),[32,1,8,16,2,4],[0,0,nMW,nMH,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(144),m3h2x48(:,144),heltab2x96(:,:,144))
  Gcoeff(:)%j = (c(162)*(M(1,:)%j-M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(145),h0tab(:,145),[32,1,8,16,2,4],[0,0,nMW,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(145),m3h2x48(:,145),heltab2x96(:,:,145))
  Gcoeff(:)%j = (c(132)*(M(1,:)%j-M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(146),h0tab(:,146),[32,1,8,16,2,4],[0,0,nMW,nMZ,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(146),m3h2x48(:,146),heltab2x96(:,:,146))
  Gcoeff(:)%j = (c(83)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(147),h0tab(:,147),[32,1,8,16,4,2],[0,0,nMW,nMH,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(147),m3h2x48(:,147),heltab2x96(:,:,147))
  Gcoeff(:)%j = (c(162)*(M(1,:)%j-M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(148),h0tab(:,148),[32,1,8,16,4,2],[0,0,nMW,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(148),m3h2x48(:,148),heltab2x96(:,:,148))
  Gcoeff(:)%j = (c(132)*(M(1,:)%j-M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(149),h0tab(:,149),[32,1,8,16,4,2],[0,0,nMW,nMZ,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(149),m3h2x48(:,149),heltab2x96(:,:,149))
  Gcoeff(:)%j = (c(110)*(M(1,:)%j-M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(150),h0tab(:,150),[32,1,8,2,16,4],[0,0,nMW,nMB,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(150),m3h2x48(:,150),heltab2x96(:,:,150))
  Gcoeff(:)%j = (c(75)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(151),h0tab(:,151),[32,1,16,4,2,8],[0,nMW,nMH,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,151),heltab2x96(:,:,151))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(151),n2h48(133))
  Gcoeff(:)%j = (c(108)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(152),h0tab(:,152),[32,1,16,4,2,8],[0,0,nMW,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,152),heltab2x96(:,:,152))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(152),n2h48(134))
  Gcoeff(:)%j = (-(c(80)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(153),h0tab(:,153),[32,1,16,4,2,8],[0,nMW,nMH,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,153),heltab2x96(:,:,153))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(153),n2h48(135))
  Gcoeff(:)%j = (-(c(142)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(154),h0tab(:,154),[32,1,16,4,2,8],[0,nMZ,nMW,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,154),heltab2x96(:,:,154))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(154),n2h48(136))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)+c(85)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(155),h0tab(:,155),[32,1,16,4,2,8],[0,nMW,nMH,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,155),heltab2x96(:,:,155))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(155),n2h48(137))
  Gcoeff(:)%j = (-(c(148)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(156),h0tab(:,156),[32,1,16,4,2,8],[0,nMW,0,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,156),heltab2x96(:,:,156))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(156),n2h48(138))
  Gcoeff(:)%j = (-(c(127)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(157),h0tab(:,157),[32,1,16,4,2,8],[0,nMW,nMZ,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,157),heltab2x96(:,:,157))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(157),n2h48(139))
  Gcoeff(:)%j = (c(154)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(158),h0tab(:,158),[32,1,16,4,2,8],[0,nMW,0,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,158),heltab2x96(:,:,158))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(158),n2h48(140))
  Gcoeff(:)%j = (c(131)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(159),h0tab(:,159),[32,1,16,4,2,8],[0,nMW,nMZ,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,159),heltab2x96(:,:,159))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(159),n2h48(141))
  Gcoeff(:)%j = (c(108)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(160),h0tab(:,160),[32,1,16,4,2,8],[0,0,nMW,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,160),heltab2x96(:,:,160))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(160),n2h48(142))
  Gcoeff(:)%j = (c(63)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(161),h0tab(:,161),[32,1,16,4,2,8],[0,nMZ,nMW,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,161),heltab2x96(:,:,161))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(161),n2h48(143))
  Gcoeff(:)%j = (c(177)*M(1,:)%j-c(176)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(162),h0tab(:,162),[32,1,16,4,2,8],[0,nMW,0,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,162),heltab2x96(:,:,162))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(162),n2h48(144))
  Gcoeff(:)%j = (c(135)*M(1,:)%j-c(134)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(163),h0tab(:,163),[32,1,16,4,2,8],[0,nMW,nMZ,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,163),heltab2x96(:,:,163))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(163),n2h48(145))
  Gcoeff(:)%j = (c(157)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(164),h0tab(:,164),[32,1,16,8,2,4],[0,0,0,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(164),m3h2x48(:,164),heltab2x96(:,:,164))
  Gcoeff(:)%j = (c(164)*(M(1,:)%j-M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(165),h0tab(:,165),[32,1,16,8,2,4],[0,0,0,nMZ,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(165),m3h2x48(:,165),heltab2x96(:,:,165))
  Gcoeff(:)%j = (c(75)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(166),h0tab(:,166),[32,1,16,2,4,8],[0,nMW,nMH,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,166),heltab2x96(:,:,166))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(166),n2h48(146))
  Gcoeff(:)%j = (-(c(80)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(167),h0tab(:,167),[32,1,16,2,4,8],[0,nMW,nMH,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,167),heltab2x96(:,:,167))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(167),n2h48(147))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)+c(85)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(168),h0tab(:,168),[32,1,16,2,4,8],[0,nMW,nMH,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,168),heltab2x96(:,:,168))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(168),n2h48(148))
  Gcoeff(:)%j = (-(c(148)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(169),h0tab(:,169),[32,1,16,2,4,8],[0,nMW,0,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,169),heltab2x96(:,:,169))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(169),n2h48(149))
  Gcoeff(:)%j = (c(154)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(170),h0tab(:,170),[32,1,16,2,4,8],[0,nMW,0,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,170),heltab2x96(:,:,170))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(170),n2h48(150))
  Gcoeff(:)%j = (-(c(127)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(171),h0tab(:,171),[32,1,16,2,4,8],[0,nMW,nMZ,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,171),heltab2x96(:,:,171))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(171),n2h48(151))
  Gcoeff(:)%j = (c(131)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(172),h0tab(:,172),[32,1,16,2,4,8],[0,nMW,nMZ,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,172),heltab2x96(:,:,172))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(172),n2h48(152))
  Gcoeff(:)%j = (c(177)*M(1,:)%j-c(176)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(173),h0tab(:,173),[32,1,16,2,4,8],[0,nMW,0,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,173),heltab2x96(:,:,173))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(173),n2h48(153))
  Gcoeff(:)%j = (c(135)*M(1,:)%j-c(134)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(174),h0tab(:,174),[32,1,16,2,4,8],[0,nMW,nMZ,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,174),heltab2x96(:,:,174))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(174),n2h48(154))
  Gcoeff(:)%j = (c(157)*(-M(1,:)%j+M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(175),h0tab(:,175),[32,1,16,8,4,2],[0,0,0,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(175),m3h2x48(:,175),heltab2x96(:,:,175))
  Gcoeff(:)%j = (c(164)*(M(1,:)%j-M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(176),h0tab(:,176),[32,1,16,8,4,2],[0,0,0,nMZ,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(176),m3h2x48(:,176),heltab2x96(:,:,176))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(3),[G1H48(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(7),[G1H48(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(12),[G1H48(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(19),[G1H48(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(20),[G1H48(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(26),[G1H48(25),G1H48(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(28),[G1H48(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(27),[G1H48(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(36),[G1H48(35),G1H48(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(38),[G1H48(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(37),[G1H48(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(44),[G1H48(43),G1H48(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(46),[G1H48(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(45),[G1H48(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(51),[G1H48(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(58),[G1H48(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(59),[G1H48(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(62),[G1H48(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(65),[G1H48(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(68),[G1H48(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(71),[G1H48(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(76),[G1H48(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(77),[G1H48(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(83),[G1H48(82),G1H48(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(85),[G1H48(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(84),[G1H48(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(93),[G1H48(92),G1H48(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(95),[G1H48(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(94),[G1H48(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(101),[G1H48(100),G1H48(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(103),[G1H48(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(102),[G1H48(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(106),[G1H48(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(111),[G1H48(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(112),[G1H48(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(115),[G1H48(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(126),[G1H48(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(133),[G1H48(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(134),[G1H48(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(137),[G1H48(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(142),[G1H48(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(143),[G1H48(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(155),[G1H48(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(162),[G1H48(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(163),[G1H48(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(168),[G1H48(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(173),[G1H48(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(174),[G1H48(171)])
  call Hloop_QA_V(ntryL,G1H48(3),ex3(:),G1H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_QA_Z(ntryL,G1H48(2),ex3(:),G1H24(2),ngZu,m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_VA_Q(ntryL,G1H48(4),ex3(:),G1H24(3),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_A_Q(ntryL,G1H24(3),36,nMT,G2H24(1),n2h24(1))
  call Hloop_AQ_W(ntryL,G1H48(7),ex2(:),G1H24(3),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_AQ_W(ntryL,G1H48(6),ex2(:),G1H24(4),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_AQ_V(ntryL,G1H48(12),ex2(:),G1H24(5),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_AQ_W(ntryL,G1H48(9),ex2(:),G1H24(6),m3h2x24(:,7),heltab2x48(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H48(10),ex2(:),G1H24(7),ngZu,m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_AQ_W(ntryL,G1H48(11),ex2(:),G1H24(8),m3h2x24(:,9),heltab2x48(:,:,9))
  call Hloop_AQ_V(ntryL,G1H48(19),ex2(:),G1H24(9),m3h2x24(:,10),heltab2x48(:,:,10))
  call Hloop_AQ_V(ntryL,G1H48(20),ex2(:),G1H24(10),m3h2x24(:,11),heltab2x48(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H48(15),ex2(:),G1H24(11),ngZu,m3h2x24(:,12),heltab2x48(:,:,12))
  call Hloop_AQ_Z(ntryL,G1H48(16),ex2(:),G1H24(12),ngZu,m3h2x24(:,13),heltab2x48(:,:,13))
  call Hloop_AQ_W(ntryL,G1H48(17),ex2(:),G1H24(13),m3h2x24(:,14),heltab2x48(:,:,14))
  call Hloop_AQ_W(ntryL,G1H48(18),ex2(:),G1H24(14),m3h2x24(:,15),heltab2x48(:,:,15))
  call Hloop_AQ_V(ntryL,G1H48(26),ex4(:),G1H24(15),m3h2x24(:,16),heltab2x48(:,:,16))
  call Hloop_AQ_Z(ntryL,G1H48(28),ex4(:),G1H24(16),ngZd,m3h2x24(:,17),heltab2x48(:,:,17))
  call Hloop_AQ_V(ntryL,G1H48(27),ex4(:),G1H24(17),m3h2x24(:,18),heltab2x48(:,:,18))
  call Hloop_AQ_Z(ntryL,G1H48(24),ex4(:),G1H24(18),ngZd,m3h2x24(:,19),heltab2x48(:,:,19))
  call Hloop_VA_Q(ntryL,G1H48(29),ex3(:),G1H24(19),m3h2x24(:,20),heltab2x48(:,:,20))
  call Hloop_A_Q(ntryL,G1H24(19),36,nMT,G2H24(2),n2h24(2))
  call Hloop_VA_Q(ntryL,G1H48(30),ex3(:),G1H24(19),m3h2x24(:,21),heltab2x48(:,:,21))
  call Hloop_A_Q(ntryL,G1H24(19),36,nMT,G2H24(3),n2h24(3))
  call Hloop_AQ_V(ntryL,G1H48(36),ex2(:),G1H24(19),m3h2x24(:,22),heltab2x48(:,:,22))
  call Hloop_AQ_V(ntryL,G1H48(38),ex2(:),G1H24(20),m3h2x24(:,23),heltab2x48(:,:,23))
  call Hloop_AQ_Z(ntryL,G1H48(37),ex2(:),G1H24(21),ngZu,m3h2x24(:,24),heltab2x48(:,:,24))
  call Hloop_AQ_Z(ntryL,G1H48(34),ex2(:),G1H24(22),ngZu,m3h2x24(:,25),heltab2x48(:,:,25))
  call Hloop_QA_V(ntryL,G1H48(44),ex1(:),G1H24(23),m3h2x24(:,26),heltab2x48(:,:,26))
  call Hloop_QA_V(ntryL,G1H48(46),ex1(:),G1H24(24),m3h2x24(:,27),heltab2x48(:,:,27))
  call Hloop_QA_Z(ntryL,G1H48(45),ex1(:),G1H24(25),ngZu,m3h2x24(:,28),heltab2x48(:,:,28))
  call Hloop_QA_Z(ntryL,G1H48(42),ex1(:),G1H24(26),ngZu,m3h2x24(:,29),heltab2x48(:,:,29))
  call Hloop_QA_V(ntryL,G1H48(51),ex1(:),G1H24(27),m3h2x24(:,30),heltab2x48(:,:,30))
  call Hloop_QA_W(ntryL,G1H48(48),ex1(:),G1H24(28),m3h2x24(:,31),heltab2x48(:,:,31))
  call Hloop_QA_Z(ntryL,G1H48(49),ex1(:),G1H24(29),ngZu,m3h2x24(:,32),heltab2x48(:,:,32))
  call Hloop_QA_W(ntryL,G1H48(50),ex1(:),G1H24(30),m3h2x24(:,33),heltab2x48(:,:,33))
  call Hloop_QA_V(ntryL,G1H48(58),ex1(:),G1H24(31),m3h2x24(:,34),heltab2x48(:,:,34))
  call Hloop_QA_V(ntryL,G1H48(59),ex1(:),G1H24(32),m3h2x24(:,35),heltab2x48(:,:,35))
  call Hloop_QA_Z(ntryL,G1H48(54),ex1(:),G1H24(33),ngZu,m3h2x24(:,36),heltab2x48(:,:,36))
  call Hloop_QA_Z(ntryL,G1H48(55),ex1(:),G1H24(34),ngZu,m3h2x24(:,37),heltab2x48(:,:,37))
  call Hloop_QA_W(ntryL,G1H48(56),ex1(:),G1H24(35),m3h2x24(:,38),heltab2x48(:,:,38))
  call Hloop_QA_W(ntryL,G1H48(57),ex1(:),G1H24(36),m3h2x24(:,39),heltab2x48(:,:,39))
  call Hloop_QA_W(ntryL,G1H48(62),ex1(:),G1H24(37),m3h2x24(:,40),heltab2x48(:,:,40))
  call Hloop_QA_W(ntryL,G1H48(61),ex1(:),G1H24(38),m3h2x24(:,41),heltab2x48(:,:,41))
  call Hloop_QA_V(ntryL,G1H48(65),ex3(:),G1H24(39),m3h2x24(:,42),heltab2x48(:,:,42))
  call Hloop_QA_Z(ntryL,G1H48(64),ex3(:),G1H24(40),ngZu,m3h2x24(:,43),heltab2x48(:,:,43))
  call Hloop_AQ_W(ntryL,G1H48(68),ex2(:),G1H24(41),m3h2x24(:,44),heltab2x48(:,:,44))
  call Hloop_AQ_W(ntryL,G1H48(67),ex2(:),G1H24(42),m3h2x24(:,45),heltab2x48(:,:,45))
  call Hloop_AQ_S(ntryL,G1H48(71),ex2(:),G1H24(43),ngH,m3h2x24(:,46),heltab2x48(:,:,46))
  call Hloop_AQ_S(ntryL,G1H48(70),ex2(:),G1H24(44),ngH,m3h2x24(:,47),heltab2x48(:,:,47))
  call Hloop_AQ_V(ntryL,G1H48(76),ex2(:),G1H24(45),m3h2x24(:,48),heltab2x48(:,:,48))
  call Hloop_AQ_Z(ntryL,G1H48(77),ex2(:),G1H24(46),ngZu,m3h2x24(:,49),heltab2x48(:,:,49))
  call Hloop_AQ_V(ntryL,G1H48(74),ex2(:),G1H24(47),m3h2x24(:,50),heltab2x48(:,:,50))
  call Hloop_AQ_Z(ntryL,G1H48(75),ex2(:),G1H24(48),ngZu,m3h2x24(:,51),heltab2x48(:,:,51))
  call Hloop_AQ_V(ntryL,G1H48(83),ex4(:),G1H24(49),m3h2x24(:,52),heltab2x48(:,:,52))
  call Hloop_AQ_Z(ntryL,G1H48(85),ex4(:),G1H24(50),ngZd,m3h2x24(:,53),heltab2x48(:,:,53))
  call Hloop_AQ_V(ntryL,G1H48(84),ex4(:),G1H24(51),m3h2x24(:,54),heltab2x48(:,:,54))
  call Hloop_AQ_Z(ntryL,G1H48(81),ex4(:),G1H24(52),ngZd,m3h2x24(:,55),heltab2x48(:,:,55))
  call Hloop_VQ_A(ntryL,G1H48(86),ex2(:),G1H24(53),m3h2x24(:,56),heltab2x48(:,:,56))
  call Hloop_Q_A(ntryL,G1H24(53),34,nMT,G2H24(4),n2h24(4))
  call Hloop_VQ_A(ntryL,G1H48(87),ex2(:),G1H24(53),m3h2x24(:,57),heltab2x48(:,:,57))
  call Hloop_Q_A(ntryL,G1H24(53),34,nMT,G2H24(5),n2h24(5))
  call Hloop_AQ_V(ntryL,G1H48(93),ex2(:),G1H24(53),m3h2x24(:,58),heltab2x48(:,:,58))
  call Hloop_AQ_Z(ntryL,G1H48(95),ex2(:),G1H24(54),ngZu,m3h2x24(:,59),heltab2x48(:,:,59))
  call Hloop_AQ_V(ntryL,G1H48(94),ex2(:),G1H24(55),m3h2x24(:,60),heltab2x48(:,:,60))
  call Hloop_AQ_Z(ntryL,G1H48(91),ex2(:),G1H24(56),ngZu,m3h2x24(:,61),heltab2x48(:,:,61))
  call Hloop_QA_V(ntryL,G1H48(101),ex1(:),G1H24(57),m3h2x24(:,62),heltab2x48(:,:,62))
  call Hloop_QA_V(ntryL,G1H48(103),ex1(:),G1H24(58),m3h2x24(:,63),heltab2x48(:,:,63))
  call Hloop_QA_Z(ntryL,G1H48(102),ex1(:),G1H24(59),ngZu,m3h2x24(:,64),heltab2x48(:,:,64))
  call Hloop_QA_Z(ntryL,G1H48(99),ex1(:),G1H24(60),ngZu,m3h2x24(:,65),heltab2x48(:,:,65))
  call Hloop_QA_V(ntryL,G1H48(106),ex1(:),G1H24(61),m3h2x24(:,66),heltab2x48(:,:,66))
  call Hloop_QA_Z(ntryL,G1H48(105),ex1(:),G1H24(62),ngZu,m3h2x24(:,67),heltab2x48(:,:,67))
  call Hloop_QA_V(ntryL,G1H48(111),ex1(:),G1H24(63),m3h2x24(:,68),heltab2x48(:,:,68))
  call Hloop_QA_V(ntryL,G1H48(112),ex1(:),G1H24(64),m3h2x24(:,69),heltab2x48(:,:,69))
  call Hloop_QA_Z(ntryL,G1H48(109),ex1(:),G1H24(65),ngZu,m3h2x24(:,70),heltab2x48(:,:,70))
  call Hloop_QA_Z(ntryL,G1H48(110),ex1(:),G1H24(66),ngZu,m3h2x24(:,71),heltab2x48(:,:,71))
  call Hloop_QA_V(ntryL,G1H48(115),ex1(:),G1H24(67),m3h2x24(:,72),heltab2x48(:,:,72))
  call Hloop_QA_Z(ntryL,G1H48(114),ex1(:),G1H24(68),ngZu,m3h2x24(:,73),heltab2x48(:,:,73))
  call Hloop_VA_Q(ntryL,G1H48(116),ex3(:),G1H24(69),m3h2x24(:,74),heltab2x48(:,:,74))
  call Hloop_A_Q(ntryL,G1H24(69),36,nMT,G2H24(6),n2h24(6))
  call Hloop_VA_Q(ntryL,G1H48(117),ex3(:),G1H24(69),m3h2x24(:,75),heltab2x48(:,:,75))
  call Hloop_A_Q(ntryL,G1H24(69),36,nMT,G2H24(7),n2h24(7))
  call Hloop_VA_Q(ntryL,G1H48(118),ex3(:),G1H24(69),m3h2x24(:,76),heltab2x48(:,:,76))
  call Hloop_A_Q(ntryL,G1H24(69),36,nMT,G2H24(8),n2h24(8))
  call Hloop_VQ_A(ntryL,G1H48(119),ex2(:),G1H24(69),m3h2x24(:,77),heltab2x48(:,:,77))
  call Hloop_Q_A(ntryL,G1H24(69),34,nMT,G2H24(9),n2h24(9))
  call Hloop_VQ_A(ntryL,G1H48(120),ex2(:),G1H24(69),m3h2x24(:,78),heltab2x48(:,:,78))
  call Hloop_Q_A(ntryL,G1H24(69),34,nMT,G2H24(10),n2h24(10))
  call Hloop_VQ_A(ntryL,G1H48(121),ex2(:),G1H24(69),m3h2x24(:,79),heltab2x48(:,:,79))
  call Hloop_Q_A(ntryL,G1H24(69),34,nMT,G2H24(11),n2h24(11))
  call Hloop_AQ_V(ntryL,G1H48(126),ex2(:),G1H24(69),m3h2x24(:,80),heltab2x48(:,:,80))
  call Hloop_AQ_W(ntryL,G1H48(123),ex2(:),G1H24(70),m3h2x24(:,81),heltab2x48(:,:,81))
  call Hloop_AQ_Z(ntryL,G1H48(124),ex2(:),G1H24(71),ngZu,m3h2x24(:,82),heltab2x48(:,:,82))
  call Hloop_AQ_W(ntryL,G1H48(125),ex2(:),G1H24(72),m3h2x24(:,83),heltab2x48(:,:,83))
  call Hloop_AQ_V(ntryL,G1H48(133),ex2(:),G1H24(73),m3h2x24(:,84),heltab2x48(:,:,84))
  call Hloop_AQ_V(ntryL,G1H48(134),ex2(:),G1H24(74),m3h2x24(:,85),heltab2x48(:,:,85))
  call Hloop_AQ_Z(ntryL,G1H48(129),ex2(:),G1H24(75),ngZu,m3h2x24(:,86),heltab2x48(:,:,86))
  call Hloop_AQ_Z(ntryL,G1H48(130),ex2(:),G1H24(76),ngZu,m3h2x24(:,87),heltab2x48(:,:,87))
  call Hloop_AQ_W(ntryL,G1H48(131),ex2(:),G1H24(77),m3h2x24(:,88),heltab2x48(:,:,88))
  call Hloop_AQ_W(ntryL,G1H48(132),ex2(:),G1H24(78),m3h2x24(:,89),heltab2x48(:,:,89))
  call Hloop_AQ_S(ntryL,G1H48(137),ex2(:),G1H24(79),ngH,m3h2x24(:,90),heltab2x48(:,:,90))
  call Hloop_AQ_S(ntryL,G1H48(136),ex2(:),G1H24(80),ngH,m3h2x24(:,91),heltab2x48(:,:,91))
  call Hloop_AQ_V(ntryL,G1H48(142),ex2(:),G1H24(81),m3h2x24(:,92),heltab2x48(:,:,92))
  call Hloop_AQ_V(ntryL,G1H48(139),ex2(:),G1H24(82),m3h2x24(:,93),heltab2x48(:,:,93))
  call Hloop_AQ_Z(ntryL,G1H48(143),ex2(:),G1H24(83),ngZu,m3h2x24(:,94),heltab2x48(:,:,94))
  call Hloop_AQ_Z(ntryL,G1H48(141),ex2(:),G1H24(84),ngZu,m3h2x24(:,95),heltab2x48(:,:,95))
  call Hloop_VA_Q(ntryL,G1H48(144),ex1(:),G1H24(85),m3h2x24(:,96),heltab2x48(:,:,96))
  call Hloop_A_Q(ntryL,G1H24(85),33,0,G2H24(12),n2h24(12))
  call Hloop_VA_Q(ntryL,G1H48(145),ex1(:),G1H24(85),m3h2x24(:,97),heltab2x48(:,:,97))
  call Hloop_A_Q(ntryL,G1H24(85),33,0,G2H24(13),n2h24(13))
  call Hloop_VA_Q(ntryL,G1H48(146),ex1(:),G1H24(85),m3h2x24(:,98),heltab2x48(:,:,98))
  call Hloop_A_Q(ntryL,G1H24(85),33,0,G2H24(14),n2h24(14))
  call Hloop_VA_Q(ntryL,G1H48(147),ex1(:),G1H24(85),m3h2x24(:,99),heltab2x48(:,:,99))
  call Hloop_A_Q(ntryL,G1H24(85),33,0,G2H24(15),n2h24(15))
  call Hloop_VA_Q(ntryL,G1H48(148),ex1(:),G1H24(85),m3h2x24(:,100),heltab2x48(:,:,100))
  call Hloop_A_Q(ntryL,G1H24(85),33,0,G2H24(16),n2h24(16))
  call Hloop_VA_Q(ntryL,G1H48(149),ex1(:),G1H24(85),m3h2x24(:,101),heltab2x48(:,:,101))
  call Hloop_A_Q(ntryL,G1H24(85),33,0,G2H24(17),n2h24(17))
  call Hloop_VA_Q(ntryL,G1H48(150),ex1(:),G1H24(85),m3h2x24(:,102),heltab2x48(:,:,102))
  call Hloop_A_Q(ntryL,G1H24(85),33,0,G2H24(18),n2h24(18))
  call Hloop_QA_W(ntryL,G1H48(155),ex1(:),G1H24(85),m3h2x24(:,103),heltab2x48(:,:,103))
  call Hloop_QA_V(ntryL,G1H48(152),ex1(:),G1H24(86),m3h2x24(:,104),heltab2x48(:,:,104))
  call Hloop_QA_W(ntryL,G1H48(153),ex1(:),G1H24(87),m3h2x24(:,105),heltab2x48(:,:,105))
  call Hloop_QA_Z(ntryL,G1H48(154),ex1(:),G1H24(88),ngZu,m3h2x24(:,106),heltab2x48(:,:,106))
  call Hloop_QA_W(ntryL,G1H48(162),ex1(:),G1H24(89),m3h2x24(:,107),heltab2x48(:,:,107))
  call Hloop_QA_W(ntryL,G1H48(163),ex1(:),G1H24(90),m3h2x24(:,108),heltab2x48(:,:,108))
  call Hloop_QA_W(ntryL,G1H48(158),ex1(:),G1H24(91),m3h2x24(:,109),heltab2x48(:,:,109))
  call Hloop_QA_W(ntryL,G1H48(159),ex1(:),G1H24(92),m3h2x24(:,110),heltab2x48(:,:,110))
  call Hloop_QA_V(ntryL,G1H48(160),ex1(:),G1H24(93),m3h2x24(:,111),heltab2x48(:,:,111))
  call Hloop_QA_Z(ntryL,G1H48(161),ex1(:),G1H24(94),ngZu,m3h2x24(:,112),heltab2x48(:,:,112))
  call Hloop_VA_Q(ntryL,G1H48(164),ex1(:),G1H24(95),m3h2x24(:,113),heltab2x48(:,:,113))
  call Hloop_A_Q(ntryL,G1H24(95),33,0,G2H24(19),n2h24(19))
  call Hloop_VA_Q(ntryL,G1H48(165),ex1(:),G1H24(95),m3h2x24(:,114),heltab2x48(:,:,114))
  call Hloop_A_Q(ntryL,G1H24(95),33,0,G2H24(20),n2h24(20))
  call Hloop_QA_W(ntryL,G1H48(168),ex1(:),G1H24(95),m3h2x24(:,115),heltab2x48(:,:,115))
  call Hloop_QA_W(ntryL,G1H48(167),ex1(:),G1H24(96),m3h2x24(:,116),heltab2x48(:,:,116))
  call Hloop_QA_W(ntryL,G1H48(173),ex1(:),G1H24(97),m3h2x24(:,117),heltab2x48(:,:,117))
  call Hloop_QA_W(ntryL,G1H48(170),ex1(:),G1H24(98),m3h2x24(:,118),heltab2x48(:,:,118))
  call Hloop_QA_W(ntryL,G1H48(174),ex1(:),G1H24(99),m3h2x24(:,119),heltab2x48(:,:,119))
  call Hloop_QA_W(ntryL,G1H48(172),ex1(:),G1H24(100),m3h2x24(:,120),heltab2x48(:,:,120))
  call Hloop_VA_Q(ntryL,G1H48(175),ex1(:),G1H24(101),m3h2x24(:,121),heltab2x48(:,:,121))
  call Hloop_A_Q(ntryL,G1H24(101),33,0,G2H24(21),n2h24(21))
  call Hloop_VA_Q(ntryL,G1H48(176),ex1(:),G1H24(101),m3h2x24(:,122),heltab2x48(:,:,122))
  call Hloop_A_Q(ntryL,G1H24(101),33,0,G2H24(22),n2h24(22))
  call Hloop_VQ_A(ntryL,G1H24(1),ex4(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_Q_A(ntryL,G1H12(1),44,0,G2H12(1),n2h12(1))
  call Hloop_ZQ_A(ntryL,G1H24(2),ex4(:),G1H12(1),ngZd,m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_Q_A(ntryL,G1H12(1),44,0,G2H12(2),n2h12(2))
  call Hotf_5pt_reduction(G2H24(1),RedSet_5(1),mass5set(:,1),  & 
G1H24(101),G1H24(1),G1H24(2),G1H24(102),G1H24(103),G1H24(104),24)
  call HG1shiftOLR(G1H24(1),8,24)
  call Hloop_WA_Q(ntryL,G1H24(3),ex1(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(3),n2h12(3))
  call Hloop_WA_Q(ntryL,G1H24(4),ex1(:),G1H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(4),n2h12(4))
  call Hloop_VA_Q(ntryL,G1H24(5),ex1(:),G1H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(5),n2h12(5))
  call Hloop_WA_Q(ntryL,G1H24(6),ex1(:),G1H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(6),n2h12(6))
  call Hloop_ZA_Q(ntryL,G1H24(7),ex1(:),G1H12(1),ngZu,m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(7),n2h12(7))
  call Hloop_WA_Q(ntryL,G1H24(8),ex1(:),G1H12(1),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(8),n2h12(8))
  call Hloop_VA_Q(ntryL,G1H24(9),ex1(:),G1H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(9),n2h12(9))
  call Hloop_VA_Q(ntryL,G1H24(10),ex1(:),G1H12(1),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(10),n2h12(10))
  call Hloop_ZA_Q(ntryL,G1H24(11),ex1(:),G1H12(1),ngZu,m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(11),n2h12(11))
  call Hloop_ZA_Q(ntryL,G1H24(12),ex1(:),G1H12(1),ngZu,m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(12),n2h12(12))
  call Hloop_WA_Q(ntryL,G1H24(13),ex1(:),G1H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(13),n2h12(13))
  call Hloop_WA_Q(ntryL,G1H24(14),ex1(:),G1H12(1),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(14),n2h12(14))
  call Hloop_VA_Q(ntryL,G1H24(15),ex3(:),G1H12(1),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(15),n2h12(15))
  call Hloop_ZA_Q(ntryL,G1H24(16),ex3(:),G1H12(1),ngZu,m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(16),n2h12(16))
  call Hloop_VA_Q(ntryL,G1H24(17),ex3(:),G1H12(1),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(17),n2h12(17))
  call Hloop_ZA_Q(ntryL,G1H24(18),ex3(:),G1H12(1),ngZu,m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(18),n2h12(18))
  call Hloop_AQ_V(ntryL,G2H24(2),ex2(:),G2H12(19),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_AQ_Z(ntryL,G2H24(3),ex2(:),G2H12(20),ngZu,m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_VA_Q(ntryL,G1H24(19),ex1(:),G1H12(1),m3h2x12(:,21),heltab2x24(:,:,21))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(21),n2h12(19))
  call Hloop_VA_Q(ntryL,G1H24(20),ex1(:),G1H12(1),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(22),n2h12(20))
  call Hloop_ZA_Q(ntryL,G1H24(21),ex1(:),G1H12(1),ngZu,m3h2x12(:,23),heltab2x24(:,:,23))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(23),n2h12(21))
  call Hloop_ZA_Q(ntryL,G1H24(22),ex1(:),G1H12(1),ngZu,m3h2x12(:,24),heltab2x24(:,:,24))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(24),n2h12(22))
  call Hloop_VQ_A(ntryL,G1H24(23),ex2(:),G1H12(1),m3h2x12(:,25),heltab2x24(:,:,25))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(25),n2h12(23))
  call Hloop_VQ_A(ntryL,G1H24(24),ex2(:),G1H12(1),m3h2x12(:,26),heltab2x24(:,:,26))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(26),n2h12(24))
  call Hloop_ZQ_A(ntryL,G1H24(25),ex2(:),G1H12(1),ngZu,m3h2x12(:,27),heltab2x24(:,:,27))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(27),n2h12(25))
  call Hloop_ZQ_A(ntryL,G1H24(26),ex2(:),G1H12(1),ngZu,m3h2x12(:,28),heltab2x24(:,:,28))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(28),n2h12(26))
  call Hloop_VQ_A(ntryL,G1H24(27),ex2(:),G1H12(1),m3h2x12(:,29),heltab2x24(:,:,29))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(29),n2h12(27))
  call Hloop_WQ_A(ntryL,G1H24(28),ex2(:),G1H12(1),m3h2x12(:,30),heltab2x24(:,:,30))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(30),n2h12(28))
  call Hloop_ZQ_A(ntryL,G1H24(29),ex2(:),G1H12(1),ngZu,m3h2x12(:,31),heltab2x24(:,:,31))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(31),n2h12(29))
  call Hloop_WQ_A(ntryL,G1H24(30),ex2(:),G1H12(1),m3h2x12(:,32),heltab2x24(:,:,32))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(32),n2h12(30))
  call Hloop_VQ_A(ntryL,G1H24(31),ex2(:),G1H12(1),m3h2x12(:,33),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(33),n2h12(31))
  call Hloop_VQ_A(ntryL,G1H24(32),ex2(:),G1H12(1),m3h2x12(:,34),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(34),n2h12(32))
  call Hloop_ZQ_A(ntryL,G1H24(33),ex2(:),G1H12(1),ngZu,m3h2x12(:,35),heltab2x24(:,:,35))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(35),n2h12(33))
  call Hloop_ZQ_A(ntryL,G1H24(34),ex2(:),G1H12(1),ngZu,m3h2x12(:,36),heltab2x24(:,:,36))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(36),n2h12(34))
  call Hloop_WQ_A(ntryL,G1H24(35),ex2(:),G1H12(1),m3h2x12(:,37),heltab2x24(:,:,37))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(37),n2h12(35))
  call Hloop_WQ_A(ntryL,G1H24(36),ex2(:),G1H12(1),m3h2x12(:,38),heltab2x24(:,:,38))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(38),n2h12(36))
  call Hloop_WQ_A(ntryL,G1H24(37),ex2(:),G1H12(1),m3h2x12(:,39),heltab2x24(:,:,39))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(39),n2h12(37))
  call Hloop_WQ_A(ntryL,G1H24(38),ex2(:),G1H12(1),m3h2x12(:,40),heltab2x24(:,:,40))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(40),n2h12(38))
  call Hloop_VA_Q(ntryL,G1H24(39),ex1(:),G1H12(1),m3h2x12(:,41),heltab2x24(:,:,41))
  call Hloop_A_Q(ntryL,G1H12(1),37,0,G2H12(41),n2h12(39))
  call Hloop_ZA_Q(ntryL,G1H24(40),ex1(:),G1H12(1),ngZu,m3h2x12(:,42),heltab2x24(:,:,42))
  call Hloop_A_Q(ntryL,G1H12(1),37,0,G2H12(42),n2h12(40))
  call Hloop_WQ_A(ntryL,G1H24(41),ex4(:),G1H12(1),m3h2x12(:,43),heltab2x24(:,:,43))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(43),n2h12(41))
  call Hloop_WQ_A(ntryL,G1H24(42),ex4(:),G1H12(1),m3h2x12(:,44),heltab2x24(:,:,44))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(44),n2h12(42))
  call Hloop_SV_V(ntryL,G1H24(43),ex5(:),G1H8(1),m3h3x8(:,1),heltab2x24(:,:,45))
  call Hloop_SV_V(ntryL,G1H24(44),ex5(:),G1H8(2),m3h3x8(:,2),heltab2x24(:,:,46))
  call Hloop_UV_W(ntryL,G1H24(45),34,ex5(:),16,G2H8(1),m3h3x8(:,3),heltab2x24(:,:,47))
  call Hloop_UV_W(ntryL,G1H24(46),34,ex5(:),16,G2H8(2),m3h3x8(:,4),heltab2x24(:,:,48))
  call Hloop_UV_W(ntryL,G1H24(47),34,ex5(:),16,G2H8(3),m3h3x8(:,5),heltab2x24(:,:,49))
  call Hloop_UV_W(ntryL,G1H24(48),34,ex5(:),16,G2H8(4),m3h3x8(:,6),heltab2x24(:,:,50))
  call Hloop_VQ_A(ntryL,G1H24(49),ex2(:),G1H12(1),m3h2x12(:,45),heltab2x24(:,:,51))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(45),n2h12(43))
  call Hloop_ZQ_A(ntryL,G1H24(50),ex2(:),G1H12(1),ngZu,m3h2x12(:,46),heltab2x24(:,:,52))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(46),n2h12(44))
  call Hloop_VQ_A(ntryL,G1H24(51),ex2(:),G1H12(1),m3h2x12(:,47),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(47),n2h12(45))
  call Hloop_ZQ_A(ntryL,G1H24(52),ex2(:),G1H12(1),ngZu,m3h2x12(:,48),heltab2x24(:,:,54))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(48),n2h12(46))
  call Hloop_QA_V(ntryL,G2H24(4),ex3(:),G2H12(49),m3h2x12(:,49),heltab2x24(:,:,55))
  call Hloop_QA_Z(ntryL,G2H24(5),ex3(:),G2H12(50),ngZu,m3h2x12(:,50),heltab2x24(:,:,56))
  call Hloop_VQ_A(ntryL,G1H24(53),ex4(:),G1H12(1),m3h2x12(:,51),heltab2x24(:,:,57))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(51),n2h12(47))
  call Hloop_ZQ_A(ntryL,G1H24(54),ex4(:),G1H12(1),ngZd,m3h2x12(:,52),heltab2x24(:,:,58))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(52),n2h12(48))
  call Hloop_VQ_A(ntryL,G1H24(55),ex4(:),G1H12(1),m3h2x12(:,53),heltab2x24(:,:,59))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(53),n2h12(49))
  call Hloop_ZQ_A(ntryL,G1H24(56),ex4(:),G1H12(1),ngZd,m3h2x12(:,54),heltab2x24(:,:,60))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(54),n2h12(50))
  call Hloop_VA_Q(ntryL,G1H24(57),ex3(:),G1H12(1),m3h2x12(:,55),heltab2x24(:,:,61))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(55),n2h12(51))
  call Hloop_VA_Q(ntryL,G1H24(58),ex3(:),G1H12(1),m3h2x12(:,56),heltab2x24(:,:,62))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(56),n2h12(52))
  call Hloop_ZA_Q(ntryL,G1H24(59),ex3(:),G1H12(1),ngZu,m3h2x12(:,57),heltab2x24(:,:,63))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(57),n2h12(53))
  call Hloop_ZA_Q(ntryL,G1H24(60),ex3(:),G1H12(1),ngZu,m3h2x12(:,58),heltab2x24(:,:,64))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(58),n2h12(54))
  call Hloop_VA_Q(ntryL,G1H24(61),ex3(:),G1H12(1),m3h2x12(:,59),heltab2x24(:,:,65))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(59),n2h12(55))
  call Hloop_ZA_Q(ntryL,G1H24(62),ex3(:),G1H12(1),ngZu,m3h2x12(:,60),heltab2x24(:,:,66))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(60),n2h12(56))
  call Hloop_VA_Q(ntryL,G1H24(63),ex3(:),G1H12(1),m3h2x12(:,61),heltab2x24(:,:,67))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(61),n2h12(57))
  call Hloop_VA_Q(ntryL,G1H24(64),ex3(:),G1H12(1),m3h2x12(:,62),heltab2x24(:,:,68))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(62),n2h12(58))
  call Hloop_ZA_Q(ntryL,G1H24(65),ex3(:),G1H12(1),ngZu,m3h2x12(:,63),heltab2x24(:,:,69))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(63),n2h12(59))
  call Hloop_ZA_Q(ntryL,G1H24(66),ex3(:),G1H12(1),ngZu,m3h2x12(:,64),heltab2x24(:,:,70))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(64),n2h12(60))
  call Hloop_VA_Q(ntryL,G1H24(67),ex3(:),G1H12(1),m3h2x12(:,65),heltab2x24(:,:,71))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(65),n2h12(61))
  call Hloop_ZA_Q(ntryL,G1H24(68),ex3(:),G1H12(1),ngZu,m3h2x12(:,66),heltab2x24(:,:,72))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(66),n2h12(62))
  call Hloop_AQ_S(ntryL,G2H24(6),ex2(:),G2H12(67),ngH,m3h2x12(:,67),heltab2x24(:,:,73))
  call Hloop_AQ_V(ntryL,G2H24(7),ex2(:),G2H12(68),m3h2x12(:,68),heltab2x24(:,:,74))
  call Hloop_AQ_Z(ntryL,G2H24(8),ex2(:),G2H12(69),ngZu,m3h2x12(:,69),heltab2x24(:,:,75))
  call Hloop_QA_S(ntryL,G2H24(9),ex3(:),G2H12(70),ngH,m3h2x12(:,70),heltab2x24(:,:,76))
  call Hloop_QA_V(ntryL,G2H24(10),ex3(:),G2H12(71),m3h2x12(:,71),heltab2x24(:,:,77))
  call Hloop_QA_Z(ntryL,G2H24(11),ex3(:),G2H12(72),ngZu,m3h2x12(:,72),heltab2x24(:,:,78))
  call Hloop_VQ_A(ntryL,G1H24(69),ex4(:),G1H12(1),m3h2x12(:,73),heltab2x24(:,:,79))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(73),n2h12(63))
  call Hloop_WQ_A(ntryL,G1H24(70),ex4(:),G1H12(1),m3h2x12(:,74),heltab2x24(:,:,80))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(74),n2h12(64))
  call Hloop_ZQ_A(ntryL,G1H24(71),ex4(:),G1H12(1),ngZd,m3h2x12(:,75),heltab2x24(:,:,81))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(75),n2h12(65))
  call Hloop_WQ_A(ntryL,G1H24(72),ex4(:),G1H12(1),m3h2x12(:,76),heltab2x24(:,:,82))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(76),n2h12(66))
  call Hloop_VQ_A(ntryL,G1H24(73),ex4(:),G1H12(1),m3h2x12(:,77),heltab2x24(:,:,83))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(77),n2h12(67))
  call Hloop_VQ_A(ntryL,G1H24(74),ex4(:),G1H12(1),m3h2x12(:,78),heltab2x24(:,:,84))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(78),n2h12(68))
  call Hloop_ZQ_A(ntryL,G1H24(75),ex4(:),G1H12(1),ngZd,m3h2x12(:,79),heltab2x24(:,:,85))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(79),n2h12(69))
  call Hloop_ZQ_A(ntryL,G1H24(76),ex4(:),G1H12(1),ngZd,m3h2x12(:,80),heltab2x24(:,:,86))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(80),n2h12(70))
  call Hloop_WQ_A(ntryL,G1H24(77),ex4(:),G1H12(1),m3h2x12(:,81),heltab2x24(:,:,87))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(81),n2h12(71))
  call Hloop_WQ_A(ntryL,G1H24(78),ex4(:),G1H12(1),m3h2x12(:,82),heltab2x24(:,:,88))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(82),n2h12(72))
  call Hloop_SV_V(ntryL,G1H24(79),ex5(:),G1H8(3),m3h3x8(:,7),heltab2x24(:,:,89))
  call Hloop_SV_V(ntryL,G1H24(80),ex5(:),G1H8(4),m3h3x8(:,8),heltab2x24(:,:,90))
  call Hloop_UV_W(ntryL,G1H24(81),34,ex5(:),16,G2H8(5),m3h3x8(:,9),heltab2x24(:,:,91))
  call Hloop_UV_W(ntryL,G1H24(82),34,ex5(:),16,G2H8(6),m3h3x8(:,10),heltab2x24(:,:,92))
  call Hloop_UV_W(ntryL,G1H24(83),34,ex5(:),16,G2H8(7),m3h3x8(:,11),heltab2x24(:,:,93))
  call Hloop_UV_W(ntryL,G1H24(84),34,ex5(:),16,G2H8(8),m3h3x8(:,12),heltab2x24(:,:,94))
  call Hloop_AQ_W(ntryL,G2H24(12),ex4(:),G2H12(83),m3h2x12(:,83),heltab2x24(:,:,95))
  call Hloop_AQ_W(ntryL,G2H24(13),ex4(:),G2H12(84),m3h2x12(:,84),heltab2x24(:,:,96))
  call Hloop_AQ_W(ntryL,G2H24(14),ex4(:),G2H12(85),m3h2x12(:,85),heltab2x24(:,:,97))
  call Hloop_AQ_W(ntryL,G2H24(15),ex4(:),G2H12(86),m3h2x12(:,86),heltab2x24(:,:,98))
  call Hloop_AQ_W(ntryL,G2H24(16),ex4(:),G2H12(87),m3h2x12(:,87),heltab2x24(:,:,99))
  call Hloop_AQ_W(ntryL,G2H24(17),ex4(:),G2H12(88),m3h2x12(:,88),heltab2x24(:,:,100))
  call Hloop_AQ_W(ntryL,G2H24(18),ex4(:),G2H12(89),m3h2x12(:,89),heltab2x24(:,:,101))
  call Hloop_VV_S(ntryL,G1H24(85),ex5(:),G1H8(5),m3h3x8(:,13),heltab2x24(:,:,102))
  call Hloop_VV_S(ntryL,G1H24(86),ex5(:),G1H8(6),m3h3x8(:,14),heltab2x24(:,:,103))
  call Hloop_VV_S(ntryL,G1H24(87),ex5(:),G1H8(7),m3h3x8(:,15),heltab2x24(:,:,104))
  call Hloop_VV_S(ntryL,G1H24(88),ex5(:),G1H8(8),m3h3x8(:,16),heltab2x24(:,:,105))
  call Hloop_UW_V(ntryL,G1H24(89),33,ex5(:),16,G2H8(9),m3h3x8(:,17),heltab2x24(:,:,106))
  call Hloop_UW_V(ntryL,G1H24(90),33,ex5(:),16,G2H8(10),m3h3x8(:,18),heltab2x24(:,:,107))
  call Hloop_UW_V(ntryL,G1H24(91),33,ex5(:),16,G2H8(11),m3h3x8(:,19),heltab2x24(:,:,108))
  call Hloop_UW_V(ntryL,G1H24(92),33,ex5(:),16,G2H8(12),m3h3x8(:,20),heltab2x24(:,:,109))
  call Hloop_UV_W(ntryL,G1H24(93),33,ex5(:),16,G2H8(13),m3h3x8(:,21),heltab2x24(:,:,110))
  call Hloop_UV_W(ntryL,G1H24(94),33,ex5(:),16,G2H8(14),m3h3x8(:,22),heltab2x24(:,:,111))
  call Hotf_5pt_reduction(G2H24(19),RedSet_5(2),mass5set(:,2),  & 
G1H24(3),G1H24(4),G1H24(5),G1H24(6),G1H24(7),G1H24(8),24)
  call HG1shiftOLR(G1H24(4),4,24)
  call Hotf_5pt_reduction(G2H24(20),RedSet_5(2),mass5set(:,3),  & 
G1H24(9),G1H24(10),G1H24(11),G1H24(12),G1H24(13),G1H24(14),24)
  call HG1shiftOLR(G1H24(10),4,24)
  call Hloop_VV_S(ntryL,G1H24(95),ex5(:),G1H8(9),m3h3x8(:,23),heltab2x24(:,:,112))
  call Hloop_VV_S(ntryL,G1H24(96),ex5(:),G1H8(10),m3h3x8(:,24),heltab2x24(:,:,113))
  call Hloop_UW_V(ntryL,G1H24(97),33,ex5(:),16,G2H8(15),m3h3x8(:,25),heltab2x24(:,:,114))
  call Hloop_UW_V(ntryL,G1H24(98),33,ex5(:),16,G2H8(16),m3h3x8(:,26),heltab2x24(:,:,115))
  call Hloop_UW_V(ntryL,G1H24(99),33,ex5(:),16,G2H8(17),m3h3x8(:,27),heltab2x24(:,:,116))
  call Hloop_UW_V(ntryL,G1H24(100),33,ex5(:),16,G2H8(18),m3h3x8(:,28),heltab2x24(:,:,117))
  call Hotf_5pt_reduction(G2H24(21),RedSet_5(2),mass5set(:,2),  & 
G1H24(15),G1H24(16),G1H24(17),G1H24(18),G1H24(19),G1H24(20),24)
  call HG1shiftOLR(G1H24(16),2,24)
  call Hotf_5pt_reduction(G2H24(22),RedSet_5(2),mass5set(:,3),  & 
G1H24(21),G1H24(22),G1H24(23),G1H24(24),G1H24(25),G1H24(26),24)
  call HG1shiftOLR(G1H24(22),2,24)
  call Hloop_AW_Q(ntryL,G1H24(101),ex5(:),G1H8(11),m3h3x8(:,29),heltab2x24(:,:,118))
  call Hloop_A_Q(ntryL,G1H8(11),52,nMB,G2H8(19),n2h8(1))
call HGT_raise_alpha_OLR(G1H24(1),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(1),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(1),ex4(:),G1H12(1),m3h2x12(:,90),heltab2x24(:,:,119))
  call Hloop_AW_Q(ntryL,G1H24(102),ex5(:),G1H8(11),m3h3x8(:,30),heltab2x24(:,:,120))
  call Hloop_A_Q(ntryL,G1H8(11),52,nMB,G2H8(20),n2h8(2))
  call Hloop_AW_Q(ntryL,G1H24(103),ex5(:),G1H8(11),m3h3x8(:,31),heltab2x24(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(11),52,nMB,G2H8(21),n2h8(3))
  call Hloop_AW_Q(ntryL,G1H24(104),ex5(:),G1H8(11),m3h3x8(:,32),heltab2x24(:,:,122))
  call Hloop_A_Q(ntryL,G1H8(11),52,nMB,G2H8(22),n2h8(4))
  call Hloop_AW_Q(ntryL,G1H24(3),ex5(:),G1H8(11),m3h3x8(:,33),heltab2x24(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(23),n2h8(5))
call HGT_raise_alpha_OLR(G1H24(4),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(4),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(4),ex3(:),G1H12(2),m3h2x12(:,91),heltab2x24(:,:,124))
  call Hloop_AW_Q(ntryL,G1H24(6),ex5(:),G1H8(11),m3h3x8(:,34),heltab2x24(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(24),n2h8(6))
  call Hloop_AW_Q(ntryL,G1H24(7),ex5(:),G1H8(11),m3h3x8(:,35),heltab2x24(:,:,126))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(25),n2h8(7))
  call Hloop_AW_Q(ntryL,G1H24(8),ex5(:),G1H8(11),m3h3x8(:,36),heltab2x24(:,:,127))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(26),n2h8(8))
  call Hloop_AW_Q(ntryL,G1H24(9),ex5(:),G1H8(11),m3h3x8(:,37),heltab2x24(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(27),n2h8(9))
call HGT_raise_alpha_OLR(G1H24(10),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(10),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(10),ex3(:),G1H12(3),m3h2x12(:,92),heltab2x24(:,:,129))
  call Hloop_AW_Q(ntryL,G1H24(12),ex5(:),G1H8(11),m3h3x8(:,38),heltab2x24(:,:,130))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(28),n2h8(10))
  call Hloop_AW_Q(ntryL,G1H24(13),ex5(:),G1H8(11),m3h3x8(:,39),heltab2x24(:,:,131))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(29),n2h8(11))
  call Hloop_AW_Q(ntryL,G1H24(14),ex5(:),G1H8(11),m3h3x8(:,40),heltab2x24(:,:,132))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(30),n2h8(12))
  call Hloop_AW_Q(ntryL,G1H24(15),ex5(:),G1H8(11),m3h3x8(:,41),heltab2x24(:,:,133))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(31),n2h8(13))
call HGT_raise_alpha_OLR(G1H24(16),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(16),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(16),ex2(:),G1H12(4),m3h2x12(:,93),heltab2x24(:,:,134))
  call Hloop_AW_Q(ntryL,G1H24(18),ex5(:),G1H8(11),m3h3x8(:,42),heltab2x24(:,:,135))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(32),n2h8(14))
  call Hloop_AW_Q(ntryL,G1H24(19),ex5(:),G1H8(11),m3h3x8(:,43),heltab2x24(:,:,136))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(33),n2h8(15))
  call Hloop_AW_Q(ntryL,G1H24(20),ex5(:),G1H8(11),m3h3x8(:,44),heltab2x24(:,:,137))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(34),n2h8(16))
  call Hloop_AW_Q(ntryL,G1H24(21),ex5(:),G1H8(11),m3h3x8(:,45),heltab2x24(:,:,138))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(35),n2h8(17))
call HGT_raise_alpha_OLR(G1H24(22),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(22),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(22),ex2(:),G1H12(5),m3h2x12(:,94),heltab2x24(:,:,139))
  call Hloop_AW_Q(ntryL,G1H24(24),ex5(:),G1H8(11),m3h3x8(:,46),heltab2x24(:,:,140))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(36),n2h8(18))
  call Hloop_AW_Q(ntryL,G1H24(25),ex5(:),G1H8(11),m3h3x8(:,47),heltab2x24(:,:,141))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(37),n2h8(19))
  call Hloop_AW_Q(ntryL,G1H24(26),ex5(:),G1H8(11),m3h3x8(:,48),heltab2x24(:,:,142))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(38),n2h8(20))
  call Hloop_QA_W(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_QA_W(ntryL,G2H12(2),ex1(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_AQ_V(ntryL,G2H12(3),ex4(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H12(4),ex4(:),G2H6(4),ngZd,m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_AQ_W(ntryL,G2H12(5),ex4(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_AQ_V(ntryL,G2H12(6),ex4(:),G2H6(6),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_AQ_W(ntryL,G2H12(7),ex4(:),G2H6(7),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_AQ_Z(ntryL,G2H12(8),ex4(:),G2H6(8),ngZd,m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_AQ_W(ntryL,G2H12(9),ex4(:),G2H6(9),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_AQ_W(ntryL,G2H12(10),ex4(:),G2H6(10),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_AQ_W(ntryL,G2H12(11),ex4(:),G2H6(11),m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_AQ_W(ntryL,G2H12(12),ex4(:),G2H6(12),m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_AQ_V(ntryL,G2H12(13),ex4(:),G2H6(13),m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_AQ_Z(ntryL,G2H12(14),ex4(:),G2H6(14),ngZd,m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_AQ_V(ntryL,G2H12(15),ex2(:),G2H6(15),m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_AQ_V(ntryL,G2H12(16),ex2(:),G2H6(16),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_AQ_Z(ntryL,G2H12(17),ex2(:),G2H6(17),ngZu,m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_AQ_Z(ntryL,G2H12(18),ex2(:),G2H6(18),ngZu,m3h2x6(:,18),heltab2x12(:,:,18))
  call Hotf_5pt_reduction(G2H12(19),RedSet_5(3),mass5set(:,4),  & 
G1H12(6),G1H12(7),G1H12(8),G1H12(9),G1H12(10),G1H12(11),12)
  call HG1shiftOLR(G1H12(7),8,12)
  call Hotf_5pt_reduction(G2H12(20),RedSet_5(3),mass5set(:,5),  & 
G1H12(12),G1H12(13),G1H12(14),G1H12(15),G1H12(16),G1H12(17),12)
  call HG1shiftOLR(G1H12(13),8,12)
  call Hotf_5pt_reduction(G2H12(21),RedSet_5(4),mass5set(:,6),  & 
G1H12(18),G1H12(19),G1H12(20),G1H12(21),G1H12(22),G1H12(23),12)
  call HG1shiftOLR(G1H12(19),4,12)
  call Hotf_5pt_reduction(G2H12(22),RedSet_5(4),mass5set(:,6),  & 
G1H12(24),G1H12(25),G1H12(26),G1H12(27),G1H12(28),G1H12(29),12)
  call HG1shiftOLR(G1H12(25),4,12)
  call Hotf_5pt_reduction(G2H12(23),RedSet_5(4),mass5set(:,7),  & 
G1H12(30),G1H12(31),G1H12(32),G1H12(33),G1H12(34),G1H12(35),12)
  call HG1shiftOLR(G1H12(31),4,12)
  call Hotf_5pt_reduction(G2H12(24),RedSet_5(4),mass5set(:,7),  & 
G1H12(36),G1H12(37),G1H12(38),G1H12(39),G1H12(40),G1H12(41),12)
  call HG1shiftOLR(G1H12(37),4,12)
  call Hloop_QA_V(ntryL,G2H12(25),ex3(:),G2H6(19),m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_QA_Z(ntryL,G2H12(26),ex3(:),G2H6(20),ngZu,m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_QA_V(ntryL,G2H12(27),ex3(:),G2H6(21),m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_QA_Z(ntryL,G2H12(28),ex3(:),G2H6(22),ngZu,m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_QA_S(ntryL,G2H12(29),ex3(:),G2H6(23),ngH,m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_QA_S(ntryL,G2H12(30),ex3(:),G2H6(24),ngPtb,m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_QA_S(ntryL,G2H12(31),ex3(:),G2H6(25),ngH,m3h2x6(:,25),heltab2x12(:,:,25))
  call Hloop_QA_S(ntryL,G2H12(32),ex3(:),G2H6(26),ngPtb,m3h2x6(:,26),heltab2x12(:,:,26))
  call Hloop_QA_V(ntryL,G2H12(33),ex3(:),G2H6(27),m3h2x6(:,27),heltab2x12(:,:,27))
  call Hloop_QA_Z(ntryL,G2H12(34),ex3(:),G2H6(28),ngZu,m3h2x6(:,28),heltab2x12(:,:,28))
  call Hloop_QA_V(ntryL,G2H12(35),ex3(:),G2H6(29),m3h2x6(:,29),heltab2x12(:,:,29))
  call Hloop_QA_Z(ntryL,G2H12(36),ex3(:),G2H6(30),ngZu,m3h2x6(:,30),heltab2x12(:,:,30))
  call Hloop_QA_W(ntryL,G2H12(37),ex3(:),G2H6(31),m3h2x6(:,31),heltab2x12(:,:,31))
  call Hloop_QA_W(ntryL,G2H12(38),ex3(:),G2H6(32),m3h2x6(:,32),heltab2x12(:,:,32))
  call Hotf_5pt_reduction(G2H12(39),RedSet_5(5),mass5set(:,8),  & 
G1H12(42),G1H12(43),G1H12(44),G1H12(45),G1H12(46),G1H12(47),12)
  call HG1shiftOLR(G1H12(43),8,12)
  call Hotf_5pt_reduction(G2H12(40),RedSet_5(5),mass5set(:,8),  & 
G1H12(48),G1H12(49),G1H12(50),G1H12(51),G1H12(52),G1H12(53),12)
  call HG1shiftOLR(G1H12(49),8,12)
  call Hloop_AQ_W(ntryL,G2H12(41),ex4(:),G2H6(33),m3h2x6(:,33),heltab2x12(:,:,33))
  call Hloop_AQ_W(ntryL,G2H12(42),ex4(:),G2H6(34),m3h2x6(:,34),heltab2x12(:,:,34))
  call Hloop_QA_V(ntryL,G2H12(43),ex1(:),G2H6(35),m3h2x6(:,35),heltab2x12(:,:,35))
  call Hloop_QA_Z(ntryL,G2H12(44),ex1(:),G2H6(36),ngZu,m3h2x6(:,36),heltab2x12(:,:,36))
  call Hloop_WQ_A(ntryL,G1H8(1),ex4(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(1),n2h4(1))
  call Hloop_WQ_A(ntryL,G1H8(2),ex4(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(2),n2h4(2))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(6),mass5set(:,9),  & 
G1H8(11),G1H8(1),G1H8(2),G1H8(12),G1H8(13),G1H8(14),8)
  call HG1shiftOLR(G1H8(1),4,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(6),mass5set(:,10),  & 
G1H8(15),G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
  call HG1shiftOLR(G1H8(16),4,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(6),mass5set(:,9),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(22),4,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(6),mass5set(:,10),  & 
G1H8(27),G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
  call HG1shiftOLR(G1H8(28),4,8)
  call Hloop_QA_V(ntryL,G2H12(45),ex3(:),G2H6(37),m3h2x6(:,37),heltab2x12(:,:,37))
  call Hloop_QA_V(ntryL,G2H12(46),ex3(:),G2H6(38),m3h2x6(:,38),heltab2x12(:,:,38))
  call Hloop_QA_Z(ntryL,G2H12(47),ex3(:),G2H6(39),ngZu,m3h2x6(:,39),heltab2x12(:,:,39))
  call Hloop_QA_Z(ntryL,G2H12(48),ex3(:),G2H6(40),ngZu,m3h2x6(:,40),heltab2x12(:,:,40))
  call Hotf_5pt_reduction(G2H12(49),RedSet_5(7),mass5set(:,4),  & 
G1H12(54),G1H12(55),G1H12(56),G1H12(57),G1H12(58),G1H12(59),12)
  call HG1shiftOLR(G1H12(55),8,12)
  call Hotf_5pt_reduction(G2H12(50),RedSet_5(7),mass5set(:,5),  & 
G1H12(60),G1H12(61),G1H12(62),G1H12(63),G1H12(64),G1H12(65),12)
  call HG1shiftOLR(G1H12(61),8,12)
  call Hotf_5pt_reduction(G2H12(51),RedSet_5(8),mass5set(:,6),  & 
G1H12(66),G1H12(67),G1H12(68),G1H12(69),G1H12(70),G1H12(71),12)
  call HG1shiftOLR(G1H12(67),4,12)
  call Hotf_5pt_reduction(G2H12(52),RedSet_5(8),mass5set(:,7),  & 
G1H12(72),G1H12(73),G1H12(74),G1H12(75),G1H12(76),G1H12(77),12)
  call HG1shiftOLR(G1H12(73),4,12)
  call Hotf_5pt_reduction(G2H12(53),RedSet_5(8),mass5set(:,6),  & 
G1H12(78),G1H12(79),G1H12(80),G1H12(81),G1H12(82),G1H12(83),12)
  call HG1shiftOLR(G1H12(79),4,12)
  call Hotf_5pt_reduction(G2H12(54),RedSet_5(8),mass5set(:,7),  & 
G1H12(84),G1H12(85),G1H12(86),G1H12(87),G1H12(88),G1H12(89),12)
  call HG1shiftOLR(G1H12(85),4,12)
  call Hloop_AQ_V(ntryL,G2H12(55),ex2(:),G2H6(41),m3h2x6(:,41),heltab2x12(:,:,41))
  call Hloop_AQ_Z(ntryL,G2H12(56),ex2(:),G2H6(42),ngZu,m3h2x6(:,42),heltab2x12(:,:,42))
  call Hloop_AQ_V(ntryL,G2H12(57),ex2(:),G2H6(43),m3h2x6(:,43),heltab2x12(:,:,43))
  call Hloop_AQ_Z(ntryL,G2H12(58),ex2(:),G2H6(44),ngZu,m3h2x6(:,44),heltab2x12(:,:,44))
  call Hloop_AQ_S(ntryL,G2H12(59),ex2(:),G2H6(45),ngH,m3h2x6(:,45),heltab2x12(:,:,45))
  call Hloop_AQ_S(ntryL,G2H12(60),ex2(:),G2H6(46),ngH,m3h2x6(:,46),heltab2x12(:,:,46))
  call Hloop_AQ_V(ntryL,G2H12(61),ex2(:),G2H6(47),m3h2x6(:,47),heltab2x12(:,:,47))
  call Hloop_AQ_Z(ntryL,G2H12(62),ex2(:),G2H6(48),ngZu,m3h2x6(:,48),heltab2x12(:,:,48))
  call Hloop_AQ_V(ntryL,G2H12(63),ex2(:),G2H6(49),m3h2x6(:,49),heltab2x12(:,:,49))
  call Hloop_AQ_Z(ntryL,G2H12(64),ex2(:),G2H6(50),ngZu,m3h2x6(:,50),heltab2x12(:,:,50))
  call Hotf_5pt_reduction(G2H12(65),RedSet_5(9),mass5set(:,11),  & 
G1H12(90),G1H12(91),G1H12(92),G1H12(93),G1H12(94),G1H12(95),12)
  call HG1shiftOLR(G1H12(91),8,12)
  call Hotf_5pt_reduction(G2H12(66),RedSet_5(9),mass5set(:,12),  & 
G1H12(96),G1H12(97),G1H12(98),G1H12(99),G1H12(100),G1H12(101),12)
  call HG1shiftOLR(G1H12(97),8,12)
  call Hloop_SV_V(ntryL,G2H12(67),ex5(:),G2H4(3),m3h3x4(:,1),heltab2x12(:,:,51))
  call Hotf_5pt_reduction(G2H12(68),RedSet_5(10),mass5set(:,13),  & 
G1H12(102),G1H12(103),G1H12(104),G1H12(105),G1H12(106),G1H12(107),12)
  call HG1shiftOLR(G1H12(103),8,12)
  call Hotf_5pt_reduction(G2H12(69),RedSet_5(10),mass5set(:,14),  & 
G1H12(108),G1H12(109),G1H12(110),G1H12(111),G1H12(112),G1H12(113),12)
  call HG1shiftOLR(G1H12(109),8,12)
  call Hloop_SV_V(ntryL,G2H12(70),ex5(:),G2H4(4),m3h3x4(:,2),heltab2x12(:,:,52))
  call Hotf_5pt_reduction(G2H12(71),RedSet_5(11),mass5set(:,13),  & 
G1H12(114),G1H12(115),G1H12(116),G1H12(117),G1H12(118),G1H12(119),12)
  call HG1shiftOLR(G1H12(115),8,12)
  call Hotf_5pt_reduction(G2H12(72),RedSet_5(11),mass5set(:,14),  & 
G1H12(120),G1H12(121),G1H12(122),G1H12(123),G1H12(124),G1H12(125),12)
  call HG1shiftOLR(G1H12(121),8,12)
  call Hloop_QA_W(ntryL,G2H12(73),ex1(:),G2H6(51),m3h2x6(:,51),heltab2x12(:,:,53))
  call Hloop_QA_V(ntryL,G2H12(74),ex1(:),G2H6(52),m3h2x6(:,52),heltab2x12(:,:,54))
  call Hloop_QA_W(ntryL,G2H12(75),ex1(:),G2H6(53),m3h2x6(:,53),heltab2x12(:,:,55))
  call Hloop_QA_Z(ntryL,G2H12(76),ex1(:),G2H6(54),ngZu,m3h2x6(:,54),heltab2x12(:,:,56))
  call Hloop_QA_W(ntryL,G2H12(77),ex1(:),G2H6(55),m3h2x6(:,55),heltab2x12(:,:,57))
  call Hloop_QA_W(ntryL,G2H12(78),ex1(:),G2H6(56),m3h2x6(:,56),heltab2x12(:,:,58))
  call Hloop_QA_W(ntryL,G2H12(79),ex1(:),G2H6(57),m3h2x6(:,57),heltab2x12(:,:,59))
  call Hloop_QA_W(ntryL,G2H12(80),ex1(:),G2H6(58),m3h2x6(:,58),heltab2x12(:,:,60))
  call Hloop_QA_V(ntryL,G2H12(81),ex1(:),G2H6(59),m3h2x6(:,59),heltab2x12(:,:,61))
  call Hloop_QA_Z(ntryL,G2H12(82),ex1(:),G2H6(60),ngZu,m3h2x6(:,60),heltab2x12(:,:,62))
  call Hloop_WA_Q(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(5),n2h4(3))
  call Hloop_WA_Q(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(6),n2h4(4))
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(12),mass5set(:,9),  & 
G1H8(3),G1H8(4),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(4),4,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(12),mass5set(:,9),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),4,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(12),mass5set(:,10),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),4,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(12),mass5set(:,10),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),4,8)
  call Hloop_VV_S(ntryL,G2H12(83),ex5(:),G2H4(7),m3h3x4(:,3),heltab2x12(:,:,63))
  call Hotf_5pt_reduction(G2H12(84),RedSet_5(13),mass5set(:,15),  & 
G1H12(126),G1H12(127),G1H12(128),G1H12(129),G1H12(130),G1H12(131),12)
  call HG1shiftOLR(G1H12(127),4,12)
  call Hotf_5pt_reduction(G2H12(85),RedSet_5(13),mass5set(:,16),  & 
G1H12(132),G1H12(133),G1H12(134),G1H12(135),G1H12(136),G1H12(137),12)
  call HG1shiftOLR(G1H12(133),4,12)
  call Hloop_VV_S(ntryL,G2H12(86),ex5(:),G2H4(8),m3h3x4(:,4),heltab2x12(:,:,64))
  call Hotf_5pt_reduction(G2H12(87),RedSet_5(13),mass5set(:,15),  & 
G1H12(138),G1H12(139),G1H12(140),G1H12(141),G1H12(142),G1H12(143),12)
  call HG1shiftOLR(G1H12(139),2,12)
  call Hotf_5pt_reduction(G2H12(88),RedSet_5(13),mass5set(:,16),  & 
G1H12(144),G1H12(145),G1H12(146),G1H12(147),G1H12(148),G1H12(149),12)
  call HG1shiftOLR(G1H12(145),2,12)
  call Hotf_5pt_reduction(G2H12(89),RedSet_5(14),mass5set(:,17),  & 
G1H12(150),G1H12(151),G1H12(152),G1H12(153),G1H12(154),G1H12(155),12)
  call HG1shiftOLR(G1H12(151),4,12)
  call Hloop_SA_Q(ntryL,G1H8(5),ex3(:),G1H4(1),ngH,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(9),n2h4(5))
  call Hloop_SA_Q(ntryL,G1H8(6),ex3(:),G1H4(1),ngPtb,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(10),n2h4(6))
  call Hloop_SA_Q(ntryL,G1H8(7),ex3(:),G1H4(1),ngH,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(11),n2h4(7))
  call Hloop_SA_Q(ntryL,G1H8(8),ex3(:),G1H4(1),ngPtb,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(12),n2h4(8))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(15),mass5set(:,18),  & 
G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(55),G1H8(56),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(15),mass5set(:,19),  & 
G1H8(57),G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(58),8,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(15),mass5set(:,18),  & 
G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
  call HG1shiftOLR(G1H8(64),8,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(15),mass5set(:,19),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
  call HG1shiftOLR(G1H8(70),8,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(15),mass5set(:,17),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(76),8,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(15),mass5set(:,20),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(82),8,8)
  call Hloop_SQ_A(ntryL,G1H8(9),ex2(:),G1H4(1),ngH,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(13),n2h4(9))
  call Hloop_SQ_A(ntryL,G1H8(10),ex2(:),G1H4(1),ngH,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(14),n2h4(10))
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(16),mass5set(:,18),  & 
G1H8(9),G1H8(10),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(10),8,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(16),mass5set(:,18),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),8,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(16),mass5set(:,19),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),8,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(16),mass5set(:,19),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hloop_AQ_W(ntryL,G2H8(19),ex2(:),G2H4(15),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_W(ntryL,G2H8(21),ex2(:),G2H4(16),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_W(ntryL,G2H8(22),ex2(:),G2H4(17),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_V(ntryL,G2H8(23),ex4(:),G2H4(18),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_AQ_V(ntryL,G2H8(25),ex4(:),G2H4(19),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_V(ntryL,G2H8(26),ex4(:),G2H4(20),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_Z(ntryL,G2H8(27),ex4(:),G2H4(21),ngZd,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_Z(ntryL,G2H8(29),ex4(:),G2H4(22),ngZd,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_Z(ntryL,G2H8(30),ex4(:),G2H4(23),ngZd,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_V(ntryL,G2H8(31),ex4(:),G2H4(24),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_V(ntryL,G2H8(33),ex4(:),G2H4(25),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_V(ntryL,G2H8(34),ex4(:),G2H4(26),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AQ_Z(ntryL,G2H8(35),ex4(:),G2H4(27),ngZd,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_Z(ntryL,G2H8(37),ex4(:),G2H4(28),ngZd,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_AQ_Z(ntryL,G2H8(38),ex4(:),G2H4(29),ngZd,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_VA_Q(ntryL,G1H12(6),ex1(:),G1H6(1),m3h2x6(:,61),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(61),n2h6(1))
call HGT_raise_alpha_OLR(G1H12(7),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(7),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(7),ex4(:),G1H6(1),m3h2x6(:,62),heltab2x12(:,:,66))
  call Hloop_VA_Q(ntryL,G1H12(10),ex1(:),G1H6(2),m3h2x6(:,63),heltab2x12(:,:,67))
  call Hloop_A_Q(ntryL,G1H6(2),39,0,G2H6(62),n2h6(2))
  call Hloop_VA_Q(ntryL,G1H12(11),ex1(:),G1H6(2),m3h2x6(:,64),heltab2x12(:,:,68))
  call Hloop_A_Q(ntryL,G1H6(2),39,0,G2H6(63),n2h6(3))
  call Hloop_ZA_Q(ntryL,G1H12(12),ex1(:),G1H6(2),ngZu,m3h2x6(:,65),heltab2x12(:,:,69))
  call Hloop_A_Q(ntryL,G1H6(2),39,0,G2H6(64),n2h6(4))
call HGT_raise_alpha_OLR(G1H12(13),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(13),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(13),ex4(:),G1H6(2),m3h2x6(:,66),heltab2x12(:,:,70))
  call Hloop_ZA_Q(ntryL,G1H12(16),ex1(:),G1H6(3),ngZu,m3h2x6(:,67),heltab2x12(:,:,71))
  call Hloop_A_Q(ntryL,G1H6(3),39,0,G2H6(65),n2h6(5))
  call Hloop_ZA_Q(ntryL,G1H12(17),ex1(:),G1H6(3),ngZu,m3h2x6(:,68),heltab2x12(:,:,72))
  call Hloop_A_Q(ntryL,G1H6(3),39,0,G2H6(66),n2h6(6))
  call Hloop_AW_Q(ntryL,G1H12(18),ex5(:),G1H4(1),m3h3x4(:,5),heltab2x12(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(30),n2h4(11))
call HGT_OLR(G1H12(19),1,1,12)
call HGT_invQ_OLR(G1H12(19),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(19),-4,nMT,G2H12(1),n2h12(75))
  call Hloop_QA_V(ntryL,G2H12(1),ex3(:),G2H6(67),m3h2x6(:,69),heltab2x12(:,:,74))
  call Hloop_AW_Q(ntryL,G1H12(22),ex5(:),G1H4(1),m3h3x4(:,6),heltab2x12(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(31),n2h4(12))
  call Hloop_AW_Q(ntryL,G1H12(23),ex5(:),G1H4(1),m3h3x4(:,7),heltab2x12(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(32),n2h4(13))
  call Hloop_AW_Q(ntryL,G1H12(24),ex5(:),G1H4(1),m3h3x4(:,8),heltab2x12(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(33),n2h4(14))
call HGT_OLR(G1H12(25),1,1,12)
call HGT_invQ_OLR(G1H12(25),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(25),-4,nMT,G2H12(2),n2h12(76))
  call Hloop_QA_Z(ntryL,G2H12(2),ex3(:),G2H6(68),ngZu,m3h2x6(:,70),heltab2x12(:,:,78))
  call Hloop_AW_Q(ntryL,G1H12(28),ex5(:),G1H4(1),m3h3x4(:,9),heltab2x12(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(34),n2h4(15))
  call Hloop_AW_Q(ntryL,G1H12(29),ex5(:),G1H4(1),m3h3x4(:,10),heltab2x12(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(35),n2h4(16))
  call Hloop_AW_Q(ntryL,G1H12(30),ex5(:),G1H4(1),m3h3x4(:,11),heltab2x12(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(36),n2h4(17))
call HGT_OLR(G1H12(31),1,1,12)
call HGT_invQ_OLR(G1H12(31),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(31),-4,nMT,G2H12(3),n2h12(77))
  call Hloop_QA_V(ntryL,G2H12(3),ex3(:),G2H6(69),m3h2x6(:,71),heltab2x12(:,:,82))
  call Hloop_AW_Q(ntryL,G1H12(34),ex5(:),G1H4(1),m3h3x4(:,12),heltab2x12(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(37),n2h4(18))
  call Hloop_AW_Q(ntryL,G1H12(35),ex5(:),G1H4(1),m3h3x4(:,13),heltab2x12(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(38),n2h4(19))
  call Hloop_AW_Q(ntryL,G1H12(36),ex5(:),G1H4(1),m3h3x4(:,14),heltab2x12(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(39),n2h4(20))
call HGT_OLR(G1H12(37),1,1,12)
call HGT_invQ_OLR(G1H12(37),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(37),-4,nMT,G2H12(4),n2h12(78))
  call Hloop_QA_Z(ntryL,G2H12(4),ex3(:),G2H6(70),ngZu,m3h2x6(:,72),heltab2x12(:,:,86))
  call Hloop_AW_Q(ntryL,G1H12(40),ex5(:),G1H4(1),m3h3x4(:,15),heltab2x12(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(40),n2h4(21))
  call Hloop_AW_Q(ntryL,G1H12(41),ex5(:),G1H4(1),m3h3x4(:,16),heltab2x12(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(41),n2h4(22))
  call Hloop_QW_A(ntryL,G1H12(42),ex5(:),G1H4(1),m3h3x4(:,17),heltab2x12(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(42),n2h4(23))
call HGT_OLR(G1H12(43),1,1,12)
call HGT_invQ_OLR(G1H12(43),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(43),-8,0,G2H12(5),n2h12(79))
  call Hloop_AQ_V(ntryL,G2H12(5),ex4(:),G2H6(71),m3h2x6(:,73),heltab2x12(:,:,90))
  call Hloop_QW_A(ntryL,G1H12(46),ex5(:),G1H4(1),m3h3x4(:,18),heltab2x12(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(43),n2h4(24))
  call Hloop_QW_A(ntryL,G1H12(47),ex5(:),G1H4(1),m3h3x4(:,19),heltab2x12(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(44),n2h4(25))
  call Hloop_QW_A(ntryL,G1H12(48),ex5(:),G1H4(1),m3h3x4(:,20),heltab2x12(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(45),n2h4(26))
call HGT_OLR(G1H12(49),1,1,12)
call HGT_invQ_OLR(G1H12(49),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(49),-8,0,G2H12(6),n2h12(80))
  call Hloop_AQ_Z(ntryL,G2H12(6),ex4(:),G2H6(72),ngZd,m3h2x6(:,74),heltab2x12(:,:,94))
  call Hloop_QW_A(ntryL,G1H12(52),ex5(:),G1H4(1),m3h3x4(:,21),heltab2x12(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(46),n2h4(27))
  call Hloop_QW_A(ntryL,G1H12(53),ex5(:),G1H4(1),m3h3x4(:,22),heltab2x12(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(47),n2h4(28))
  call Hloop_WQ_A(ntryL,G1H8(11),ex4(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(48),n2h4(29))
call HGT_OLR(G1H8(1),1,1,8)
call HGT_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1),-4,nMT,G2H8(1),n2h8(21))
  call Hloop_QA_V(ntryL,G2H8(1),ex3(:),G2H4(49),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_WQ_A(ntryL,G1H8(13),ex4(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(50),n2h4(30))
  call Hloop_WQ_A(ntryL,G1H8(14),ex4(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(51),n2h4(31))
  call Hloop_WQ_A(ntryL,G1H8(15),ex4(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(52),n2h4(32))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(16),-4,nMT,G2H8(2),n2h8(22))
  call Hloop_QA_V(ntryL,G2H8(2),ex3(:),G2H4(53),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_WQ_A(ntryL,G1H8(19),ex4(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(54),n2h4(33))
  call Hloop_WQ_A(ntryL,G1H8(20),ex4(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(55),n2h4(34))
  call Hloop_WQ_A(ntryL,G1H8(21),ex4(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(56),n2h4(35))
call HGT_OLR(G1H8(22),1,1,8)
call HGT_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(22),-4,nMT,G2H8(3),n2h8(23))
  call Hloop_QA_Z(ntryL,G2H8(3),ex3(:),G2H4(57),ngZu,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_WQ_A(ntryL,G1H8(25),ex4(:),G1H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(58),n2h4(36))
  call Hloop_WQ_A(ntryL,G1H8(26),ex4(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(59),n2h4(37))
  call Hloop_WQ_A(ntryL,G1H8(27),ex4(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(60),n2h4(38))
call HGT_OLR(G1H8(28),1,1,8)
call HGT_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(28),-4,nMT,G2H8(4),n2h8(24))
  call Hloop_QA_Z(ntryL,G2H8(4),ex3(:),G2H4(61),ngZu,m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_WQ_A(ntryL,G1H8(31),ex4(:),G1H4(1),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(62),n2h4(39))
  call Hloop_WQ_A(ntryL,G1H8(32),ex4(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(63),n2h4(40))
  call Hloop_VA_Q(ntryL,G1H12(54),ex1(:),G1H6(3),m3h2x6(:,75),heltab2x12(:,:,97))
  call Hloop_A_Q(ntryL,G1H6(3),39,0,G2H6(73),n2h6(7))
call HGT_raise_alpha_OLR(G1H12(55),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(55),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(55),ex4(:),G1H6(3),m3h2x6(:,76),heltab2x12(:,:,98))
  call Hloop_VA_Q(ntryL,G1H12(58),ex1(:),G1H6(4),m3h2x6(:,77),heltab2x12(:,:,99))
  call Hloop_A_Q(ntryL,G1H6(4),39,0,G2H6(74),n2h6(8))
  call Hloop_VA_Q(ntryL,G1H12(59),ex1(:),G1H6(4),m3h2x6(:,78),heltab2x12(:,:,100))
  call Hloop_A_Q(ntryL,G1H6(4),39,0,G2H6(75),n2h6(9))
  call Hloop_ZA_Q(ntryL,G1H12(60),ex1(:),G1H6(4),ngZu,m3h2x6(:,79),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G1H6(4),39,0,G2H6(76),n2h6(10))
call HGT_raise_alpha_OLR(G1H12(61),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(61),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(61),ex4(:),G1H6(4),m3h2x6(:,80),heltab2x12(:,:,102))
  call Hloop_ZA_Q(ntryL,G1H12(64),ex1(:),G1H6(5),ngZu,m3h2x6(:,81),heltab2x12(:,:,103))
  call Hloop_A_Q(ntryL,G1H6(5),39,0,G2H6(77),n2h6(11))
  call Hloop_ZA_Q(ntryL,G1H12(65),ex1(:),G1H6(5),ngZu,m3h2x6(:,82),heltab2x12(:,:,104))
  call Hloop_A_Q(ntryL,G1H6(5),39,0,G2H6(78),n2h6(12))
  call Hloop_QW_A(ntryL,G1H12(66),ex5(:),G1H4(1),m3h3x4(:,23),heltab2x12(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(64),n2h4(41))
call HGT_OLR(G1H12(67),1,1,12)
call HGT_invQ_OLR(G1H12(67),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(67),-4,nMT,G2H12(7),n2h12(83))
  call Hloop_QA_V(ntryL,G2H12(7),ex3(:),G2H6(79),m3h2x6(:,83),heltab2x12(:,:,106))
  call Hloop_QW_A(ntryL,G1H12(70),ex5(:),G1H4(1),m3h3x4(:,24),heltab2x12(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(65),n2h4(42))
  call Hloop_QW_A(ntryL,G1H12(71),ex5(:),G1H4(1),m3h3x4(:,25),heltab2x12(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(66),n2h4(43))
  call Hloop_QW_A(ntryL,G1H12(72),ex5(:),G1H4(1),m3h3x4(:,26),heltab2x12(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(67),n2h4(44))
call HGT_OLR(G1H12(73),1,1,12)
call HGT_invQ_OLR(G1H12(73),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(73),-4,nMT,G2H12(8),n2h12(84))
  call Hloop_QA_V(ntryL,G2H12(8),ex3(:),G2H6(80),m3h2x6(:,84),heltab2x12(:,:,110))
  call Hloop_QW_A(ntryL,G1H12(76),ex5(:),G1H4(1),m3h3x4(:,27),heltab2x12(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(68),n2h4(45))
  call Hloop_QW_A(ntryL,G1H12(77),ex5(:),G1H4(1),m3h3x4(:,28),heltab2x12(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(69),n2h4(46))
  call Hloop_QW_A(ntryL,G1H12(78),ex5(:),G1H4(1),m3h3x4(:,29),heltab2x12(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(70),n2h4(47))
call HGT_OLR(G1H12(79),1,1,12)
call HGT_invQ_OLR(G1H12(79),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(79),-4,nMT,G2H12(9),n2h12(85))
  call Hloop_QA_Z(ntryL,G2H12(9),ex3(:),G2H6(81),ngZu,m3h2x6(:,85),heltab2x12(:,:,114))
  call Hloop_QW_A(ntryL,G1H12(82),ex5(:),G1H4(1),m3h3x4(:,30),heltab2x12(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(71),n2h4(48))
  call Hloop_QW_A(ntryL,G1H12(83),ex5(:),G1H4(1),m3h3x4(:,31),heltab2x12(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(72),n2h4(49))
  call Hloop_QW_A(ntryL,G1H12(84),ex5(:),G1H4(1),m3h3x4(:,32),heltab2x12(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(73),n2h4(50))
call HGT_OLR(G1H12(85),1,1,12)
call HGT_invQ_OLR(G1H12(85),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(85),-4,nMT,G2H12(10),n2h12(86))
  call Hloop_QA_Z(ntryL,G2H12(10),ex3(:),G2H6(82),ngZu,m3h2x6(:,86),heltab2x12(:,:,118))
  call Hloop_QW_A(ntryL,G1H12(88),ex5(:),G1H4(1),m3h3x4(:,33),heltab2x12(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(74),n2h4(51))
  call Hloop_QW_A(ntryL,G1H12(89),ex5(:),G1H4(1),m3h3x4(:,34),heltab2x12(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(75),n2h4(52))
  call Hloop_AW_Q(ntryL,G1H12(90),ex5(:),G1H4(1),m3h3x4(:,35),heltab2x12(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(76),n2h4(53))
call HGT_OLR(G1H12(91),1,1,12)
call HGT_invQ_OLR(G1H12(91),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(91),-8,0,G2H12(11),n2h12(87))
  call Hloop_AQ_W(ntryL,G2H12(11),ex4(:),G2H6(83),m3h2x6(:,87),heltab2x12(:,:,122))
  call Hloop_AW_Q(ntryL,G1H12(94),ex5(:),G1H4(1),m3h3x4(:,36),heltab2x12(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(77),n2h4(54))
  call Hloop_AW_Q(ntryL,G1H12(95),ex5(:),G1H4(1),m3h3x4(:,37),heltab2x12(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(78),n2h4(55))
  call Hloop_AW_Q(ntryL,G1H12(96),ex5(:),G1H4(1),m3h3x4(:,38),heltab2x12(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(79),n2h4(56))
call HGT_OLR(G1H12(97),1,1,12)
call HGT_invQ_OLR(G1H12(97),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(97),-8,0,G2H12(12),n2h12(88))
  call Hloop_AQ_W(ntryL,G2H12(12),ex4(:),G2H6(84),m3h2x6(:,88),heltab2x12(:,:,126))
  call Hloop_AW_Q(ntryL,G1H12(100),ex5(:),G1H4(1),m3h3x4(:,39),heltab2x12(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(80),n2h4(57))
  call Hloop_AW_Q(ntryL,G1H12(101),ex5(:),G1H4(1),m3h3x4(:,40),heltab2x12(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(81),n2h4(58))
  call Hloop_UV_W(ntryL,G1H12(102),38,ex5(:),16,G2H4(82),m3h3x4(:,41),heltab2x12(:,:,129))
call HGT_raise_alpha_OLR(G1H12(103),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(103),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(103),ex4(:),G1H6(5),m3h2x6(:,89),heltab2x12(:,:,130))
  call Hloop_UV_W(ntryL,G1H12(106),38,ex5(:),16,G2H4(83),m3h3x4(:,42),heltab2x12(:,:,131))
  call Hloop_UV_W(ntryL,G1H12(107),38,ex5(:),16,G2H4(84),m3h3x4(:,43),heltab2x12(:,:,132))
  call Hloop_UV_W(ntryL,G1H12(108),38,ex5(:),16,G2H4(85),m3h3x4(:,44),heltab2x12(:,:,133))
call HGT_raise_alpha_OLR(G1H12(109),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(109),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(109),ex4(:),G1H6(6),m3h2x6(:,90),heltab2x12(:,:,134))
  call Hloop_UV_W(ntryL,G1H12(112),38,ex5(:),16,G2H4(86),m3h3x4(:,45),heltab2x12(:,:,135))
  call Hloop_UV_W(ntryL,G1H12(113),38,ex5(:),16,G2H4(87),m3h3x4(:,46),heltab2x12(:,:,136))
  call Hloop_UV_W(ntryL,G1H12(114),38,ex5(:),16,G2H4(88),m3h3x4(:,47),heltab2x12(:,:,137))
call HGT_raise_alpha_OLR(G1H12(115),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(115),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(115),ex4(:),G1H6(7),m3h2x6(:,91),heltab2x12(:,:,138))
  call Hloop_UV_W(ntryL,G1H12(118),38,ex5(:),16,G2H4(89),m3h3x4(:,48),heltab2x12(:,:,139))
  call Hloop_UV_W(ntryL,G1H12(119),38,ex5(:),16,G2H4(90),m3h3x4(:,49),heltab2x12(:,:,140))
  call Hloop_UV_W(ntryL,G1H12(120),38,ex5(:),16,G2H4(91),m3h3x4(:,50),heltab2x12(:,:,141))
call HGT_raise_alpha_OLR(G1H12(121),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(121),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(121),ex4(:),G1H6(8),m3h2x6(:,92),heltab2x12(:,:,142))
  call Hloop_UV_W(ntryL,G1H12(124),38,ex5(:),16,G2H4(92),m3h3x4(:,51),heltab2x12(:,:,143))
  call Hloop_UV_W(ntryL,G1H12(125),38,ex5(:),16,G2H4(93),m3h3x4(:,52),heltab2x12(:,:,144))
  call Hloop_WA_Q(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(94),n2h4(59))
call HGT_OLR(G1H8(4),1,1,8)
call HGT_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(4),-4,nMT,G2H8(5),n2h8(25))
  call Hloop_QA_V(ntryL,G2H8(5),ex3(:),G2H4(95),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_WA_Q(ntryL,G1H8(35),ex1(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(96),n2h4(60))
  call Hloop_WA_Q(ntryL,G1H8(36),ex1(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(97),n2h4(61))
  call Hloop_WA_Q(ntryL,G1H8(37),ex1(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(98),n2h4(62))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-4,nMT,G2H8(6),n2h8(26))
  call Hloop_QA_Z(ntryL,G2H8(6),ex3(:),G2H4(99),ngZu,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_WA_Q(ntryL,G1H8(41),ex1(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(100),n2h4(63))
  call Hloop_WA_Q(ntryL,G1H8(42),ex1(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(101),n2h4(64))
  call Hloop_WA_Q(ntryL,G1H8(43),ex1(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(102),n2h4(65))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(44),-4,nMT,G2H8(7),n2h8(27))
  call Hloop_QA_V(ntryL,G2H8(7),ex3(:),G2H4(103),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_WA_Q(ntryL,G1H8(47),ex1(:),G1H4(1),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(104),n2h4(66))
  call Hloop_WA_Q(ntryL,G1H8(48),ex1(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(105),n2h4(67))
  call Hloop_WA_Q(ntryL,G1H8(49),ex1(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(106),n2h4(68))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(50),-4,nMT,G2H8(8),n2h8(28))
  call Hloop_QA_Z(ntryL,G2H8(8),ex3(:),G2H4(107),ngZu,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_WA_Q(ntryL,G1H8(53),ex1(:),G1H4(1),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(108),n2h4(69))
  call Hloop_WA_Q(ntryL,G1H8(54),ex1(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(109),n2h4(70))
  call Hloop_UW_V(ntryL,G1H12(126),41,ex5(:),16,G2H4(110),m3h3x4(:,53),heltab2x12(:,:,145))
call HGT_raise_alpha_OLR(G1H12(127),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(127),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(127),ex3(:),G1H6(9),m3h2x6(:,93),heltab2x12(:,:,146))
  call Hloop_UW_V(ntryL,G1H12(130),41,ex5(:),16,G2H4(111),m3h3x4(:,54),heltab2x12(:,:,147))
  call Hloop_UW_V(ntryL,G1H12(131),41,ex5(:),16,G2H4(112),m3h3x4(:,55),heltab2x12(:,:,148))
  call Hloop_UW_V(ntryL,G1H12(132),41,ex5(:),16,G2H4(113),m3h3x4(:,56),heltab2x12(:,:,149))
call HGT_raise_alpha_OLR(G1H12(133),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(133),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(133),ex3(:),G1H6(10),m3h2x6(:,94),heltab2x12(:,:,150))
  call Hloop_UW_V(ntryL,G1H12(136),41,ex5(:),16,G2H4(114),m3h3x4(:,57),heltab2x12(:,:,151))
  call Hloop_UW_V(ntryL,G1H12(137),41,ex5(:),16,G2H4(115),m3h3x4(:,58),heltab2x12(:,:,152))
  call Hloop_UW_V(ntryL,G1H12(138),41,ex5(:),16,G2H4(116),m3h3x4(:,59),heltab2x12(:,:,153))
call HGT_raise_alpha_OLR(G1H12(139),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(139),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(139),ex2(:),G1H6(11),m3h2x6(:,95),heltab2x12(:,:,154))
  call Hloop_UW_V(ntryL,G1H12(142),41,ex5(:),16,G2H4(117),m3h3x4(:,60),heltab2x12(:,:,155))
  call Hloop_UW_V(ntryL,G1H12(143),41,ex5(:),16,G2H4(118),m3h3x4(:,61),heltab2x12(:,:,156))
  call Hloop_UW_V(ntryL,G1H12(144),41,ex5(:),16,G2H4(119),m3h3x4(:,62),heltab2x12(:,:,157))
call HGT_raise_alpha_OLR(G1H12(145),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(145),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(145),ex2(:),G1H6(12),m3h2x6(:,96),heltab2x12(:,:,158))
  call Hloop_UW_V(ntryL,G1H12(148),41,ex5(:),16,G2H4(120),m3h3x4(:,63),heltab2x12(:,:,159))
  call Hloop_UW_V(ntryL,G1H12(149),41,ex5(:),16,G2H4(121),m3h3x4(:,64),heltab2x12(:,:,160))
  call Hloop_WQ_A(ntryL,G1H12(150),ex2(:),G1H6(13),m3h2x6(:,97),heltab2x12(:,:,161))
  call Hloop_Q_A(ntryL,G1H6(13),43,nMB,G2H6(85),n2h6(13))
call HGT_raise_alpha_OLR(G1H12(151),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(151),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(151),ex3(:),G1H6(13),m3h2x6(:,98),heltab2x12(:,:,162))
  call Hloop_WQ_A(ntryL,G1H12(154),ex2(:),G1H6(14),m3h2x6(:,99),heltab2x12(:,:,163))
  call Hloop_Q_A(ntryL,G1H6(14),43,nMB,G2H6(86),n2h6(14))
  call Hloop_WQ_A(ntryL,G1H12(155),ex2(:),G1H6(14),m3h2x6(:,100),heltab2x12(:,:,164))
  call Hloop_Q_A(ntryL,G1H6(14),43,nMB,G2H6(87),n2h6(15))
  call Hloop_VA_Q(ntryL,G1H8(5),ex3(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(122),n2h4(71))
call HGT_OLR(G1H8(6),1,1,8)
call HGT_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(6),-8,0,G2H8(9),n2h8(29))
  call Hloop_AQ_V(ntryL,G2H8(9),ex4(:),G2H4(123),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_VA_Q(ntryL,G1H8(55),ex3(:),G1H4(1),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(124),n2h4(72))
  call Hloop_VA_Q(ntryL,G1H8(56),ex3(:),G1H4(1),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(125),n2h4(73))
  call Hloop_ZA_Q(ntryL,G1H8(57),ex3(:),G1H4(1),ngZu,m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(126),n2h4(74))
call HGT_OLR(G1H8(58),1,1,8)
call HGT_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(58),-8,0,G2H8(10),n2h8(30))
  call Hloop_AQ_V(ntryL,G2H8(10),ex4(:),G2H4(127),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_ZA_Q(ntryL,G1H8(61),ex3(:),G1H4(1),ngZu,m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(128),n2h4(75))
  call Hloop_ZA_Q(ntryL,G1H8(62),ex3(:),G1H4(1),ngZu,m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(129),n2h4(76))
  call Hloop_VA_Q(ntryL,G1H8(63),ex3(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(130),n2h4(77))
call HGT_OLR(G1H8(64),1,1,8)
call HGT_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(64),-8,0,G2H8(11),n2h8(31))
  call Hloop_AQ_Z(ntryL,G2H8(11),ex4(:),G2H4(131),ngZd,m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_VA_Q(ntryL,G1H8(67),ex3(:),G1H4(1),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(132),n2h4(78))
  call Hloop_VA_Q(ntryL,G1H8(68),ex3(:),G1H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(133),n2h4(79))
  call Hloop_ZA_Q(ntryL,G1H8(69),ex3(:),G1H4(1),ngZu,m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(134),n2h4(80))
call HGT_OLR(G1H8(70),1,1,8)
call HGT_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(70),-8,0,G2H8(12),n2h8(32))
  call Hloop_AQ_Z(ntryL,G2H8(12),ex4(:),G2H4(135),ngZd,m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_ZA_Q(ntryL,G1H8(73),ex3(:),G1H4(1),ngZu,m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(136),n2h4(81))
  call Hloop_ZA_Q(ntryL,G1H8(74),ex3(:),G1H4(1),ngZu,m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(137),n2h4(82))
  call Hloop_WA_Q(ntryL,G1H8(75),ex3(:),G1H4(1),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(138),n2h4(83))
call HGT_OLR(G1H8(76),1,1,8)
call HGT_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(76),-8,0,G2H8(13),n2h8(33))
  call Hloop_AQ_W(ntryL,G2H8(13),ex4(:),G2H4(139),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_WA_Q(ntryL,G1H8(79),ex3(:),G1H4(1),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(140),n2h4(84))
  call Hloop_WA_Q(ntryL,G1H8(80),ex3(:),G1H4(1),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(141),n2h4(85))
  call Hloop_WA_Q(ntryL,G1H8(81),ex3(:),G1H4(1),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(142),n2h4(86))
call HGT_OLR(G1H8(82),1,1,8)
call HGT_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(82),-8,0,G2H8(14),n2h8(34))
  call Hloop_AQ_W(ntryL,G2H8(14),ex4(:),G2H4(143),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_WA_Q(ntryL,G1H8(85),ex3(:),G1H4(1),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(144),n2h4(87))
  call Hloop_WA_Q(ntryL,G1H8(86),ex3(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(145),n2h4(88))
  call Hloop_VQ_A(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(146),n2h4(89))
call HGT_OLR(G1H8(10),1,1,8)
call HGT_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(10),-8,0,G2H8(15),n2h8(35))
  call Hloop_AQ_V(ntryL,G2H8(15),ex4(:),G2H4(147),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_VQ_A(ntryL,G1H8(89),ex2(:),G1H4(1),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(148),n2h4(90))
  call Hloop_VQ_A(ntryL,G1H8(90),ex2(:),G1H4(1),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(149),n2h4(91))
  call Hloop_VQ_A(ntryL,G1H8(91),ex2(:),G1H4(1),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(150),n2h4(92))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(92),-8,0,G2H8(16),n2h8(36))
  call Hloop_AQ_Z(ntryL,G2H8(16),ex4(:),G2H4(151),ngZd,m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_VQ_A(ntryL,G1H8(95),ex2(:),G1H4(1),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(152),n2h4(93))
  call Hloop_VQ_A(ntryL,G1H8(96),ex2(:),G1H4(1),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(153),n2h4(94))
  call Hloop_ZQ_A(ntryL,G1H8(97),ex2(:),G1H4(1),ngZu,m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(154),n2h4(95))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(98),-8,0,G2H8(17),n2h8(37))
  call Hloop_AQ_V(ntryL,G2H8(17),ex4(:),G2H4(155),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_ZQ_A(ntryL,G1H8(101),ex2(:),G1H4(1),ngZu,m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(156),n2h4(96))
  call Hloop_ZQ_A(ntryL,G1H8(102),ex2(:),G1H4(1),ngZu,m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(157),n2h4(97))
  call Hloop_ZQ_A(ntryL,G1H8(103),ex2(:),G1H4(1),ngZu,m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(158),n2h4(98))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(104),-8,0,G2H8(18),n2h8(38))
  call Hloop_AQ_Z(ntryL,G2H8(18),ex4(:),G2H4(159),ngZd,m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_ZQ_A(ntryL,G1H8(107),ex2(:),G1H4(1),ngZu,m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(160),n2h4(99))
  call Hloop_ZQ_A(ntryL,G1H8(108),ex2(:),G1H4(1),ngZu,m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(161),n2h4(100))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(138),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(142),[G2H4(12)])
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(17),mass5set(:,21),  & 
G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),G1H6(19),6)
  call HG1shiftOLR(G1H6(15),16,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(17),mass5set(:,22),  & 
G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),G1H6(25),6)
  call HG1shiftOLR(G1H6(21),16,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(18),mass5set(:,23),  & 
G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),G1H6(31),6)
  call HG1shiftOLR(G1H6(27),16,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(18),mass5set(:,24),  & 
G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),G1H6(37),6)
  call HG1shiftOLR(G1H6(33),16,6)
  call Hloop_VV_S(ntryL,G2H6(5),ex5(:),G2H2(1),m3h3x2(:,1),heltab2x6(:,:,1))
  call Hloop_VV_S(ntryL,G2H6(6),ex5(:),G2H2(2),m3h3x2(:,2),heltab2x6(:,:,2))
  call Hloop_VV_S(ntryL,G2H6(7),ex5(:),G2H2(3),m3h3x2(:,3),heltab2x6(:,:,3))
  call Hloop_VV_S(ntryL,G2H6(8),ex5(:),G2H2(4),m3h3x2(:,4),heltab2x6(:,:,4))
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(18),mass5set(:,21),  & 
G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),G1H6(43),6)
  call HG1shiftOLR(G1H6(39),4,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(18),mass5set(:,21),  & 
G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),G1H6(49),6)
  call HG1shiftOLR(G1H6(45),4,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(18),mass5set(:,22),  & 
G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),G1H6(55),6)
  call HG1shiftOLR(G1H6(51),4,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(18),mass5set(:,22),  & 
G1H6(56),G1H6(57),G1H6(58),G1H6(59),G1H6(60),G1H6(61),6)
  call HG1shiftOLR(G1H6(57),4,6)
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(18),mass5set(:,23),  & 
G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),G1H6(67),6)
  call HG1shiftOLR(G1H6(63),4,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(18),mass5set(:,24),  & 
G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),G1H6(73),6)
  call HG1shiftOLR(G1H6(69),4,6)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(19),mass5set(:,25),  & 
G1H6(74),G1H6(75),G1H6(76),G1H6(77),G1H6(78),G1H6(79),6)
  call HG1shiftOLR(G1H6(75),16,6)
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(19),mass5set(:,26),  & 
G1H6(80),G1H6(81),G1H6(82),G1H6(83),G1H6(84),G1H6(85),6)
  call HG1shiftOLR(G1H6(81),16,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(19),mass5set(:,27),  & 
G1H6(86),G1H6(87),G1H6(88),G1H6(89),G1H6(90),G1H6(91),6)
  call HG1shiftOLR(G1H6(87),16,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(19),mass5set(:,28),  & 
G1H6(92),G1H6(93),G1H6(94),G1H6(95),G1H6(96),G1H6(97),6)
  call HG1shiftOLR(G1H6(93),16,6)
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(20),mass5set(:,25),  & 
G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),G1H6(103),6)
  call HG1shiftOLR(G1H6(99),16,6)
  call Hotf_5pt_reduction(G2H6(20),RedSet_5(20),mass5set(:,27),  & 
G1H6(104),G1H6(105),G1H6(106),G1H6(107),G1H6(108),G1H6(109),6)
  call HG1shiftOLR(G1H6(105),16,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(20),mass5set(:,26),  & 
G1H6(110),G1H6(111),G1H6(112),G1H6(113),G1H6(114),G1H6(115),6)
  call HG1shiftOLR(G1H6(111),16,6)
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(20),mass5set(:,28),  & 
G1H6(116),G1H6(117),G1H6(118),G1H6(119),G1H6(120),G1H6(121),6)
  call HG1shiftOLR(G1H6(117),16,6)
  call Hloop_SV_V(ntryL,G2H6(23),ex5(:),G2H2(5),m3h3x2(:,5),heltab2x6(:,:,5))
  call Hloop_SV_V(ntryL,G2H6(24),ex5(:),G2H2(6),m3h3x2(:,6),heltab2x6(:,:,6))
  call Hloop_SV_V(ntryL,G2H6(25),ex5(:),G2H2(7),m3h3x2(:,7),heltab2x6(:,:,7))
  call Hloop_SV_V(ntryL,G2H6(26),ex5(:),G2H2(8),m3h3x2(:,8),heltab2x6(:,:,8))
  call Hotf_5pt_reduction(G2H6(27),RedSet_5(20),mass5set(:,25),  & 
G1H6(122),G1H6(123),G1H6(124),G1H6(125),G1H6(126),G1H6(127),6)
  call HG1shiftOLR(G1H6(123),8,6)
  call Hotf_5pt_reduction(G2H6(28),RedSet_5(20),mass5set(:,27),  & 
G1H6(128),G1H6(129),G1H6(130),G1H6(131),G1H6(132),G1H6(133),6)
  call HG1shiftOLR(G1H6(129),8,6)
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(20),mass5set(:,26),  & 
G1H6(134),G1H6(135),G1H6(136),G1H6(137),G1H6(138),G1H6(139),6)
  call HG1shiftOLR(G1H6(135),8,6)
  call Hotf_5pt_reduction(G2H6(30),RedSet_5(20),mass5set(:,28),  & 
G1H6(140),G1H6(141),G1H6(142),G1H6(143),G1H6(144),G1H6(145),6)
  call HG1shiftOLR(G1H6(141),8,6)
  call Hotf_5pt_reduction(G2H6(31),RedSet_5(20),mass5set(:,29),  & 
G1H6(146),G1H6(147),G1H6(148),G1H6(149),G1H6(150),G1H6(151),6)
  call HG1shiftOLR(G1H6(147),8,6)
  call Hotf_5pt_reduction(G2H6(32),RedSet_5(20),mass5set(:,29),  & 
G1H6(152),G1H6(153),G1H6(154),G1H6(155),G1H6(156),G1H6(157),6)
  call HG1shiftOLR(G1H6(153),8,6)
  call Hotf_5pt_reduction(G2H6(33),RedSet_5(21),mass5set(:,21),  & 
G1H6(158),G1H6(159),G1H6(160),G1H6(161),G1H6(162),G1H6(163),6)
  call HG1shiftOLR(G1H6(159),16,6)
  call Hotf_5pt_reduction(G2H6(34),RedSet_5(21),mass5set(:,22),  & 
G1H6(164),G1H6(165),G1H6(166),G1H6(167),G1H6(168),G1H6(169),6)
  call HG1shiftOLR(G1H6(165),16,6)
  call Hotf_5pt_reduction(G2H6(35),RedSet_5(22),mass5set(:,23),  & 
G1H6(170),G1H6(171),G1H6(172),G1H6(173),G1H6(174),G1H6(175),6)
  call HG1shiftOLR(G1H6(171),16,6)
  call Hotf_5pt_reduction(G2H6(36),RedSet_5(22),mass5set(:,24),  & 
G1H6(176),G1H6(177),G1H6(178),G1H6(179),G1H6(180),G1H6(181),6)
  call HG1shiftOLR(G1H6(177),16,6)
  call Hloop_QA_V(ntryL,G2H4(1),ex1(:),G2H2(9),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_Z(ntryL,G2H4(2),ex1(:),G2H2(10),ngZu,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H6(37),RedSet_5(23),mass5set(:,25),  & 
G1H6(182),G1H6(183),G1H6(184),G1H6(185),G1H6(186),G1H6(187),6)
  call HG1shiftOLR(G1H6(183),16,6)
  call Hotf_5pt_reduction(G2H6(38),RedSet_5(23),mass5set(:,26),  & 
G1H6(188),G1H6(189),G1H6(190),G1H6(191),G1H6(192),G1H6(193),6)
  call HG1shiftOLR(G1H6(189),16,6)
  call Hotf_5pt_reduction(G2H6(39),RedSet_5(23),mass5set(:,27),  & 
G1H6(194),G1H6(195),G1H6(196),G1H6(197),G1H6(198),G1H6(199),6)
  call HG1shiftOLR(G1H6(195),16,6)
  call Hotf_5pt_reduction(G2H6(40),RedSet_5(23),mass5set(:,28),  & 
G1H6(200),G1H6(201),G1H6(202),G1H6(203),G1H6(204),G1H6(205),6)
  call HG1shiftOLR(G1H6(201),16,6)
  call Hotf_5pt_reduction(G2H6(41),RedSet_5(24),mass5set(:,25),  & 
G1H6(206),G1H6(207),G1H6(208),G1H6(209),G1H6(210),G1H6(211),6)
  call HG1shiftOLR(G1H6(207),16,6)
  call Hotf_5pt_reduction(G2H6(42),RedSet_5(24),mass5set(:,27),  & 
G1H6(212),G1H6(213),G1H6(214),G1H6(215),G1H6(216),G1H6(217),6)
  call HG1shiftOLR(G1H6(213),16,6)
  call Hotf_5pt_reduction(G2H6(43),RedSet_5(24),mass5set(:,26),  & 
G1H6(218),G1H6(219),G1H6(220),G1H6(221),G1H6(222),G1H6(223),6)
  call HG1shiftOLR(G1H6(219),16,6)
  call Hotf_5pt_reduction(G2H6(44),RedSet_5(24),mass5set(:,28),  & 
G1H6(224),G1H6(225),G1H6(226),G1H6(227),G1H6(228),G1H6(229),6)
  call HG1shiftOLR(G1H6(225),16,6)
  call Hloop_SV_V(ntryL,G2H6(45),ex5(:),G2H2(11),m3h3x2(:,9),heltab2x6(:,:,9))
  call Hloop_SV_V(ntryL,G2H6(46),ex5(:),G2H2(12),m3h3x2(:,10),heltab2x6(:,:,10))
  call Hotf_5pt_reduction(G2H6(47),RedSet_5(24),mass5set(:,25),  & 
G1H6(230),G1H6(231),G1H6(232),G1H6(233),G1H6(234),G1H6(235),6)
  call HG1shiftOLR(G1H6(231),8,6)
  call Hotf_5pt_reduction(G2H6(48),RedSet_5(24),mass5set(:,27),  & 
G1H6(236),G1H6(237),G1H6(238),G1H6(239),G1H6(240),G1H6(241),6)
  call HG1shiftOLR(G1H6(237),8,6)
  call Hotf_5pt_reduction(G2H6(49),RedSet_5(24),mass5set(:,26),  & 
G1H6(242),G1H6(243),G1H6(244),G1H6(245),G1H6(246),G1H6(247),6)
  call HG1shiftOLR(G1H6(243),8,6)
  call Hotf_5pt_reduction(G2H6(50),RedSet_5(24),mass5set(:,28),  & 
G1H6(248),G1H6(249),G1H6(250),G1H6(251),G1H6(252),G1H6(253),6)
  call HG1shiftOLR(G1H6(249),8,6)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(10),mass5set(:,30),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(11),mass5set(:,30),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hloop_VV_S(ntryL,G2H6(51),ex5(:),G2H2(13),m3h3x2(:,11),heltab2x6(:,:,11))
  call Hloop_VV_S(ntryL,G2H6(52),ex5(:),G2H2(14),m3h3x2(:,12),heltab2x6(:,:,12))
  call Hloop_VV_S(ntryL,G2H6(53),ex5(:),G2H2(15),m3h3x2(:,13),heltab2x6(:,:,13))
  call Hloop_VV_S(ntryL,G2H6(54),ex5(:),G2H2(16),m3h3x2(:,14),heltab2x6(:,:,14))
  call Hotf_5pt_reduction(G2H6(55),RedSet_5(22),mass5set(:,21),  & 
G1H6(254),G1H6(255),G1H6(256),G1H6(257),G1H6(258),G1H6(259),6)
  call HG1shiftOLR(G1H6(255),4,6)
  call Hotf_5pt_reduction(G2H6(56),RedSet_5(22),mass5set(:,21),  & 
G1H6(260),G1H6(261),G1H6(262),G1H6(263),G1H6(264),G1H6(265),6)
  call HG1shiftOLR(G1H6(261),4,6)
  call Hotf_5pt_reduction(G2H6(57),RedSet_5(22),mass5set(:,22),  & 
G1H6(266),G1H6(267),G1H6(268),G1H6(269),G1H6(270),G1H6(271),6)
  call HG1shiftOLR(G1H6(267),4,6)
  call Hotf_5pt_reduction(G2H6(58),RedSet_5(22),mass5set(:,22),  & 
G1H6(272),G1H6(273),G1H6(274),G1H6(275),G1H6(276),G1H6(277),6)
  call HG1shiftOLR(G1H6(273),4,6)
  call Hotf_5pt_reduction(G2H6(59),RedSet_5(22),mass5set(:,23),  & 
G1H6(278),G1H6(279),G1H6(280),G1H6(281),G1H6(282),G1H6(283),6)
  call HG1shiftOLR(G1H6(279),4,6)
  call Hotf_5pt_reduction(G2H6(60),RedSet_5(22),mass5set(:,24),  & 
G1H6(284),G1H6(285),G1H6(286),G1H6(287),G1H6(288),G1H6(289),6)
  call HG1shiftOLR(G1H6(285),4,6)
  call Hloop_AQ_V(ntryL,G2H4(5),ex4(:),G2H2(17),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H4(6),ex4(:),G2H2(18),ngZd,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(13),mass5set(:,31),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),4,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(13),mass5set(:,31),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),2,4)
  call Hloop_AQ_V(ntryL,G2H4(9),ex2(:),G2H2(19),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_W(ntryL,G2H4(138),ex2(:),G2H2(20),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_Z(ntryL,G2H4(11),ex2(:),G2H2(21),ngZu,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_W(ntryL,G2H4(142),ex2(:),G2H2(22),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(13),ex3(:),G2H2(23),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_Z(ntryL,G2H4(14),ex3(:),G2H2(24),ngZu,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(1),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(25),mass5set(:,32),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(2),mass5set(:,2),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),4,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(26),mass5set(:,33),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),4,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(2),mass5set(:,3),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),4,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(26),mass5set(:,33),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),4,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(2),mass5set(:,2),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),2,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(27),mass5set(:,33),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),2,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(2),mass5set(:,3),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),2,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(27),mass5set(:,33),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),2,4)
  call Hotf_5pt_reduction(G2H6(61),RedSet_5(3),mass5set(:,4),  & 
G1H6(290),G1H6(291),G1H6(292),G1H6(293),G1H6(294),G1H6(295),6)
  call HG1shiftOLR(G1H6(291),8,6)
  call Hotf_5pt_reduction(G2H6(63),RedSet_5(28),mass5set(:,4),  & 
G1H6(296),G1H6(297),G1H6(298),G1H6(299),G1H6(300),G1H6(301),6)
  call HG1shiftOLR(G1H6(297),8,6)
  call Hotf_5pt_reduction(G2H6(64),RedSet_5(3),mass5set(:,5),  & 
G1H6(302),G1H6(303),G1H6(304),G1H6(305),G1H6(306),G1H6(307),6)
  call HG1shiftOLR(G1H6(303),8,6)
  call Hotf_5pt_reduction(G2H6(66),RedSet_5(28),mass5set(:,5),  & 
G1H6(308),G1H6(309),G1H6(310),G1H6(311),G1H6(312),G1H6(313),6)
  call HG1shiftOLR(G1H6(309),8,6)
  call Hloop_AQ_V(ntryL,G2H4(30),ex4(:),G2H2(25),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(32),ex4(:),G2H2(26),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_Z(ntryL,G2H4(33),ex4(:),G2H2(27),ngZd,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_Z(ntryL,G2H4(35),ex4(:),G2H2(28),ngZd,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(36),ex4(:),G2H2(29),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_V(ntryL,G2H4(38),ex4(:),G2H2(30),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_Z(ntryL,G2H4(39),ex4(:),G2H2(31),ngZd,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_Z(ntryL,G2H4(41),ex4(:),G2H2(32),ngZd,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_V(ntryL,G2H4(42),ex3(:),G2H2(33),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_V(ntryL,G2H4(44),ex3(:),G2H2(34),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_Z(ntryL,G2H4(45),ex3(:),G2H2(35),ngZu,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_Z(ntryL,G2H4(47),ex3(:),G2H2(36),ngZu,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_V(ntryL,G2H4(48),ex1(:),G2H2(37),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_V(ntryL,G2H4(51),ex1(:),G2H2(38),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(52),ex1(:),G2H2(39),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(55),ex1(:),G2H2(40),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_Z(ntryL,G2H4(56),ex1(:),G2H2(41),ngZu,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_Z(ntryL,G2H4(59),ex1(:),G2H2(42),ngZu,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_Z(ntryL,G2H4(60),ex1(:),G2H2(43),ngZu,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_Z(ntryL,G2H4(63),ex1(:),G2H2(44),ngZu,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hotf_5pt_reduction(G2H6(73),RedSet_5(7),mass5set(:,4),  & 
G1H6(314),G1H6(315),G1H6(316),G1H6(317),G1H6(318),G1H6(319),6)
  call HG1shiftOLR(G1H6(315),8,6)
  call Hotf_5pt_reduction(G2H6(75),RedSet_5(29),mass5set(:,4),  & 
G1H6(320),G1H6(321),G1H6(322),G1H6(323),G1H6(324),G1H6(325),6)
  call HG1shiftOLR(G1H6(321),8,6)
  call Hotf_5pt_reduction(G2H6(76),RedSet_5(7),mass5set(:,5),  & 
G1H6(326),G1H6(327),G1H6(328),G1H6(329),G1H6(330),G1H6(331),6)
  call HG1shiftOLR(G1H6(327),8,6)
  call Hotf_5pt_reduction(G2H6(78),RedSet_5(29),mass5set(:,5),  & 
G1H6(332),G1H6(333),G1H6(334),G1H6(335),G1H6(336),G1H6(337),6)
  call HG1shiftOLR(G1H6(333),8,6)
  call Hloop_QA_V(ntryL,G2H4(64),ex1(:),G2H2(45),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_V(ntryL,G2H4(66),ex1(:),G2H2(46),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QA_V(ntryL,G2H4(67),ex1(:),G2H2(47),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_QA_V(ntryL,G2H4(69),ex1(:),G2H2(48),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QA_Z(ntryL,G2H4(70),ex1(:),G2H2(49),ngZu,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QA_Z(ntryL,G2H4(72),ex1(:),G2H2(50),ngZu,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QA_Z(ntryL,G2H4(73),ex1(:),G2H2(51),ngZu,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QA_Z(ntryL,G2H4(75),ex1(:),G2H2(52),ngZu,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_W(ntryL,G2H4(76),ex2(:),G2H2(53),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AQ_W(ntryL,G2H4(78),ex2(:),G2H2(54),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_AQ_W(ntryL,G2H4(79),ex2(:),G2H2(55),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AQ_W(ntryL,G2H4(81),ex2(:),G2H2(56),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hotf_5pt_reduction(G2H4(82),RedSet_5(10),mass5set(:,13),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),8,4)
  call Hotf_5pt_reduction(G2H4(84),RedSet_5(28),mass5set(:,4),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),8,4)
  call Hotf_5pt_reduction(G2H4(85),RedSet_5(10),mass5set(:,14),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(28),mass5set(:,5),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),8,4)
  call Hotf_5pt_reduction(G2H4(88),RedSet_5(11),mass5set(:,13),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),8,4)
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(29),mass5set(:,4),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),8,4)
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(11),mass5set(:,14),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),8,4)
  call Hotf_5pt_reduction(G2H4(93),RedSet_5(29),mass5set(:,5),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),8,4)
  call Hloop_AQ_V(ntryL,G2H4(94),ex4(:),G2H2(57),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_AQ_V(ntryL,G2H4(97),ex4(:),G2H2(58),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AQ_Z(ntryL,G2H4(98),ex4(:),G2H2(59),ngZd,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AQ_Z(ntryL,G2H4(101),ex4(:),G2H2(60),ngZd,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_AQ_V(ntryL,G2H4(102),ex4(:),G2H2(61),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AQ_V(ntryL,G2H4(105),ex4(:),G2H2(62),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_Z(ntryL,G2H4(106),ex4(:),G2H2(63),ngZd,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AQ_Z(ntryL,G2H4(109),ex4(:),G2H2(64),ngZd,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hotf_5pt_reduction(G2H4(110),RedSet_5(13),mass5set(:,15),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),4,4)
  call Hotf_5pt_reduction(G2H4(112),RedSet_5(30),mass5set(:,34),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),4,4)
  call Hotf_5pt_reduction(G2H4(113),RedSet_5(13),mass5set(:,16),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),4,4)
  call Hotf_5pt_reduction(G2H4(115),RedSet_5(30),mass5set(:,34),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),4,4)
  call Hotf_5pt_reduction(G2H4(116),RedSet_5(13),mass5set(:,15),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),2,4)
  call Hotf_5pt_reduction(G2H4(118),RedSet_5(31),mass5set(:,34),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),2,4)
  call Hotf_5pt_reduction(G2H4(119),RedSet_5(13),mass5set(:,16),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),2,4)
  call Hotf_5pt_reduction(G2H4(121),RedSet_5(31),mass5set(:,34),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),2,4)
  call Hotf_5pt_reduction(G2H6(85),RedSet_5(14),mass5set(:,17),  & 
G1H6(338),G1H6(339),G1H6(340),G1H6(341),G1H6(342),G1H6(343),6)
  call HG1shiftOLR(G1H6(339),4,6)
  call Hotf_5pt_reduction(G2H6(87),RedSet_5(30),mass5set(:,34),  & 
G1H6(344),G1H6(345),G1H6(346),G1H6(347),G1H6(348),G1H6(349),6)
  call HG1shiftOLR(G1H6(345),4,6)
  call Hloop_AQ_V(ntryL,G2H4(122),ex2(:),G2H2(65),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AQ_V(ntryL,G2H4(125),ex2(:),G2H2(66),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AQ_V(ntryL,G2H4(126),ex2(:),G2H2(67),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_AQ_V(ntryL,G2H4(129),ex2(:),G2H2(68),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_AQ_Z(ntryL,G2H4(130),ex2(:),G2H2(69),ngZu,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_AQ_Z(ntryL,G2H4(133),ex2(:),G2H2(70),ngZu,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AQ_Z(ntryL,G2H4(134),ex2(:),G2H2(71),ngZu,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_AQ_Z(ntryL,G2H4(137),ex2(:),G2H2(72),ngZu,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_AQ_W(ntryL,G2H4(141),ex2(:),G2H2(73),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AQ_W(ntryL,G2H4(145),ex2(:),G2H2(74),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_QA_V(ntryL,G2H4(146),ex3(:),G2H2(75),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_QA_V(ntryL,G2H4(149),ex3(:),G2H2(76),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_QA_Z(ntryL,G2H4(150),ex3(:),G2H2(77),ngZu,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_QA_Z(ntryL,G2H4(153),ex3(:),G2H2(78),ngZu,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QA_V(ntryL,G2H4(154),ex3(:),G2H2(79),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_QA_V(ntryL,G2H4(157),ex3(:),G2H2(80),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_QA_Z(ntryL,G2H4(158),ex3(:),G2H2(81),ngZu,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_QA_Z(ntryL,G2H4(161),ex3(:),G2H2(82),ngZu,m3h2x2(:,68),heltab2x4(:,:,68))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(296),[G1H6(295)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(308),[G1H6(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(320),[G1H6(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(332),[G1H6(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(151),[G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G1H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(175),[G1H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(344),[G1H6(343)])
  call Hloop_WQ_A(ntryL,G1H6(14),ex2(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,15))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(15),1,1,6)
call HGT_invQ_OLR(G1H6(15),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(15),-16,nMT,G2H6(1),n2h6(16))
  call Hloop_AW_Q(ntryL,G2H6(1),ex5(:),G2H2(83),m3h3x2(:,15),heltab2x6(:,:,16))
  call Hloop_WQ_A(ntryL,G1H6(19),ex2(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,17))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(2),n2h3(2))
  call Hloop_WQ_A(ntryL,G1H6(20),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,18))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(3),n2h3(3))
call HGT_OLR(G1H6(21),1,1,6)
call HGT_invQ_OLR(G1H6(21),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(21),-16,nMT,G2H6(2),n2h6(17))
  call Hloop_AW_Q(ntryL,G2H6(2),ex5(:),G2H2(84),m3h3x2(:,16),heltab2x6(:,:,19))
  call Hloop_WQ_A(ntryL,G1H6(25),ex2(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,20))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(4),n2h3(4))
  call Hloop_VA_Q(ntryL,G1H6(26),ex3(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(5),n2h3(5))
call HGT_OLR(G1H6(27),1,1,6)
call HGT_invQ_OLR(G1H6(27),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(27),-16,nMB,G2H6(3),n2h6(18))
  call Hloop_QW_A(ntryL,G2H6(3),ex5(:),G2H2(85),m3h3x2(:,17),heltab2x6(:,:,22))
  call Hloop_VA_Q(ntryL,G1H6(31),ex3(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(6),n2h3(6))
  call Hloop_ZA_Q(ntryL,G1H6(32),ex3(:),G1H3(1),ngZu,m3h2x3(:,7),heltab2x6(:,:,24))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(7),n2h3(7))
call HGT_OLR(G1H6(33),1,1,6)
call HGT_invQ_OLR(G1H6(33),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(33),-16,nMB,G2H6(4),n2h6(19))
  call Hloop_QW_A(ntryL,G2H6(4),ex5(:),G2H2(86),m3h3x2(:,18),heltab2x6(:,:,25))
  call Hloop_ZA_Q(ntryL,G1H6(37),ex3(:),G1H3(1),ngZu,m3h2x3(:,8),heltab2x6(:,:,26))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(8),n2h3(8))
  call Hloop_UW_V(ntryL,G1H6(38),43,ex5(:),16,G2H2(87),m3h3x2(:,19),heltab2x6(:,:,27))
call HGT_OLR(G1H6(39),1,1,6)
call HGT_invQ_OLR(G1H6(39),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(39),-4,nMT,G2H6(5),n2h6(20))
  call Hloop_QA_V(ntryL,G2H6(5),ex3(:),G2H3(9),m3h2x3(:,9),heltab2x6(:,:,28))
  call Hloop_UW_V(ntryL,G1H6(43),43,ex5(:),16,G2H2(88),m3h3x2(:,20),heltab2x6(:,:,29))
  call Hloop_UW_V(ntryL,G1H6(44),43,ex5(:),16,G2H2(89),m3h3x2(:,21),heltab2x6(:,:,30))
call HGT_OLR(G1H6(45),1,1,6)
call HGT_invQ_OLR(G1H6(45),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(45),-4,nMT,G2H6(6),n2h6(21))
  call Hloop_QA_Z(ntryL,G2H6(6),ex3(:),G2H3(10),ngZu,m3h2x3(:,10),heltab2x6(:,:,31))
  call Hloop_UW_V(ntryL,G1H6(49),43,ex5(:),16,G2H2(90),m3h3x2(:,22),heltab2x6(:,:,32))
  call Hloop_UW_V(ntryL,G1H6(50),43,ex5(:),16,G2H2(91),m3h3x2(:,23),heltab2x6(:,:,33))
call HGT_OLR(G1H6(51),1,1,6)
call HGT_invQ_OLR(G1H6(51),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(51),-4,nMT,G2H6(7),n2h6(22))
  call Hloop_QA_V(ntryL,G2H6(7),ex3(:),G2H3(11),m3h2x3(:,11),heltab2x6(:,:,34))
  call Hloop_UW_V(ntryL,G1H6(55),43,ex5(:),16,G2H2(92),m3h3x2(:,24),heltab2x6(:,:,35))
  call Hloop_UW_V(ntryL,G1H6(56),43,ex5(:),16,G2H2(93),m3h3x2(:,25),heltab2x6(:,:,36))
call HGT_OLR(G1H6(57),1,1,6)
call HGT_invQ_OLR(G1H6(57),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(57),-4,nMT,G2H6(8),n2h6(23))
  call Hloop_QA_Z(ntryL,G2H6(8),ex3(:),G2H3(12),ngZu,m3h2x3(:,12),heltab2x6(:,:,37))
  call Hloop_UW_V(ntryL,G1H6(61),43,ex5(:),16,G2H2(94),m3h3x2(:,26),heltab2x6(:,:,38))
  call Hloop_UV_W(ntryL,G1H6(62),43,ex5(:),16,G2H2(95),m3h3x2(:,27),heltab2x6(:,:,39))
call HGT_OLR(G1H6(63),1,1,6)
call HGT_invQ_OLR(G1H6(63),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(63),-4,nMB,G2H6(9),n2h6(24))
  call Hloop_QA_W(ntryL,G2H6(9),ex3(:),G2H3(13),m3h2x3(:,13),heltab2x6(:,:,40))
  call Hloop_UV_W(ntryL,G1H6(67),43,ex5(:),16,G2H2(96),m3h3x2(:,28),heltab2x6(:,:,41))
  call Hloop_UV_W(ntryL,G1H6(68),43,ex5(:),16,G2H2(97),m3h3x2(:,29),heltab2x6(:,:,42))
call HGT_OLR(G1H6(69),1,1,6)
call HGT_invQ_OLR(G1H6(69),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(69),-4,nMB,G2H6(10),n2h6(25))
  call Hloop_QA_W(ntryL,G2H6(10),ex3(:),G2H3(14),m3h2x3(:,14),heltab2x6(:,:,43))
  call Hloop_UV_W(ntryL,G1H6(73),43,ex5(:),16,G2H2(98),m3h3x2(:,30),heltab2x6(:,:,44))
  call Hloop_VA_Q(ntryL,G1H6(74),ex1(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,45))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(15),n2h3(9))
call HGT_OLR(G1H6(75),1,1,6)
call HGT_invQ_OLR(G1H6(75),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(75),-16,0,G2H6(11),n2h6(26))
  call Hloop_QW_A(ntryL,G2H6(11),ex5(:),G2H2(99),m3h3x2(:,31),heltab2x6(:,:,46))
  call Hloop_VA_Q(ntryL,G1H6(79),ex1(:),G1H3(1),m3h2x3(:,16),heltab2x6(:,:,47))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(16),n2h3(10))
  call Hloop_VA_Q(ntryL,G1H6(80),ex1(:),G1H3(1),m3h2x3(:,17),heltab2x6(:,:,48))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(17),n2h3(11))
call HGT_OLR(G1H6(81),1,1,6)
call HGT_invQ_OLR(G1H6(81),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(81),-16,0,G2H6(12),n2h6(27))
  call Hloop_QW_A(ntryL,G2H6(12),ex5(:),G2H2(100),m3h3x2(:,32),heltab2x6(:,:,49))
  call Hloop_VA_Q(ntryL,G1H6(85),ex1(:),G1H3(1),m3h2x3(:,18),heltab2x6(:,:,50))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(18),n2h3(12))
  call Hloop_ZA_Q(ntryL,G1H6(86),ex1(:),G1H3(1),ngZu,m3h2x3(:,19),heltab2x6(:,:,51))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(19),n2h3(13))
call HGT_OLR(G1H6(87),1,1,6)
call HGT_invQ_OLR(G1H6(87),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(87),-16,0,G2H6(13),n2h6(28))
  call Hloop_QW_A(ntryL,G2H6(13),ex5(:),G2H2(101),m3h3x2(:,33),heltab2x6(:,:,52))
  call Hloop_ZA_Q(ntryL,G1H6(91),ex1(:),G1H3(1),ngZu,m3h2x3(:,20),heltab2x6(:,:,53))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(20),n2h3(14))
  call Hloop_ZA_Q(ntryL,G1H6(92),ex1(:),G1H3(1),ngZu,m3h2x3(:,21),heltab2x6(:,:,54))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(21),n2h3(15))
call HGT_OLR(G1H6(93),1,1,6)
call HGT_invQ_OLR(G1H6(93),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(93),-16,0,G2H6(14),n2h6(29))
  call Hloop_QW_A(ntryL,G2H6(14),ex5(:),G2H2(102),m3h3x2(:,34),heltab2x6(:,:,55))
  call Hloop_ZA_Q(ntryL,G1H6(97),ex1(:),G1H3(1),ngZu,m3h2x3(:,22),heltab2x6(:,:,56))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(22),n2h3(16))
  call Hloop_VQ_A(ntryL,G1H6(98),ex4(:),G1H3(1),m3h2x3(:,23),heltab2x6(:,:,57))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(23),n2h3(17))
call HGT_OLR(G1H6(99),1,1,6)
call HGT_invQ_OLR(G1H6(99),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(99),-16,0,G2H6(15),n2h6(30))
  call Hloop_AW_Q(ntryL,G2H6(15),ex5(:),G2H2(103),m3h3x2(:,35),heltab2x6(:,:,58))
  call Hloop_VQ_A(ntryL,G1H6(103),ex4(:),G1H3(1),m3h2x3(:,24),heltab2x6(:,:,59))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(24),n2h3(18))
  call Hloop_ZQ_A(ntryL,G1H6(104),ex4(:),G1H3(1),ngZd,m3h2x3(:,25),heltab2x6(:,:,60))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(25),n2h3(19))
call HGT_OLR(G1H6(105),1,1,6)
call HGT_invQ_OLR(G1H6(105),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(105),-16,0,G2H6(16),n2h6(31))
  call Hloop_AW_Q(ntryL,G2H6(16),ex5(:),G2H2(104),m3h3x2(:,36),heltab2x6(:,:,61))
  call Hloop_ZQ_A(ntryL,G1H6(109),ex4(:),G1H3(1),ngZd,m3h2x3(:,26),heltab2x6(:,:,62))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(26),n2h3(20))
  call Hloop_VQ_A(ntryL,G1H6(110),ex4(:),G1H3(1),m3h2x3(:,27),heltab2x6(:,:,63))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(27),n2h3(21))
call HGT_OLR(G1H6(111),1,1,6)
call HGT_invQ_OLR(G1H6(111),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(111),-16,0,G2H6(17),n2h6(32))
  call Hloop_AW_Q(ntryL,G2H6(17),ex5(:),G2H2(105),m3h3x2(:,37),heltab2x6(:,:,64))
  call Hloop_VQ_A(ntryL,G1H6(115),ex4(:),G1H3(1),m3h2x3(:,28),heltab2x6(:,:,65))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(28),n2h3(22))
  call Hloop_ZQ_A(ntryL,G1H6(116),ex4(:),G1H3(1),ngZd,m3h2x3(:,29),heltab2x6(:,:,66))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(29),n2h3(23))
call HGT_OLR(G1H6(117),1,1,6)
call HGT_invQ_OLR(G1H6(117),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(117),-16,0,G2H6(18),n2h6(33))
  call Hloop_AW_Q(ntryL,G2H6(18),ex5(:),G2H2(106),m3h3x2(:,38),heltab2x6(:,:,67))
  call Hloop_ZQ_A(ntryL,G1H6(121),ex4(:),G1H3(1),ngZd,m3h2x3(:,30),heltab2x6(:,:,68))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(30),n2h3(24))
  call Hloop_UV_W(ntryL,G1H6(122),39,ex5(:),16,G2H2(107),m3h3x2(:,39),heltab2x6(:,:,69))
call HGT_OLR(G1H6(123),1,1,6)
call HGT_invQ_OLR(G1H6(123),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(123),-8,0,G2H6(19),n2h6(34))
  call Hloop_AQ_W(ntryL,G2H6(19),ex4(:),G2H3(31),m3h2x3(:,31),heltab2x6(:,:,70))
  call Hloop_UV_W(ntryL,G1H6(127),39,ex5(:),16,G2H2(108),m3h3x2(:,40),heltab2x6(:,:,71))
  call Hloop_UV_W(ntryL,G1H6(128),39,ex5(:),16,G2H2(109),m3h3x2(:,41),heltab2x6(:,:,72))
call HGT_OLR(G1H6(129),1,1,6)
call HGT_invQ_OLR(G1H6(129),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(129),-8,0,G2H6(20),n2h6(35))
  call Hloop_AQ_W(ntryL,G2H6(20),ex4(:),G2H3(32),m3h2x3(:,32),heltab2x6(:,:,73))
  call Hloop_UV_W(ntryL,G1H6(133),39,ex5(:),16,G2H2(110),m3h3x2(:,42),heltab2x6(:,:,74))
  call Hloop_UV_W(ntryL,G1H6(134),39,ex5(:),16,G2H2(111),m3h3x2(:,43),heltab2x6(:,:,75))
call HGT_OLR(G1H6(135),1,1,6)
call HGT_invQ_OLR(G1H6(135),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(135),-8,0,G2H6(21),n2h6(36))
  call Hloop_AQ_W(ntryL,G2H6(21),ex4(:),G2H3(33),m3h2x3(:,33),heltab2x6(:,:,76))
  call Hloop_UV_W(ntryL,G1H6(139),39,ex5(:),16,G2H2(112),m3h3x2(:,44),heltab2x6(:,:,77))
  call Hloop_UV_W(ntryL,G1H6(140),39,ex5(:),16,G2H2(113),m3h3x2(:,45),heltab2x6(:,:,78))
call HGT_OLR(G1H6(141),1,1,6)
call HGT_invQ_OLR(G1H6(141),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(141),-8,0,G2H6(22),n2h6(37))
  call Hloop_AQ_W(ntryL,G2H6(22),ex4(:),G2H3(34),m3h2x3(:,34),heltab2x6(:,:,79))
  call Hloop_UV_W(ntryL,G1H6(145),39,ex5(:),16,G2H2(114),m3h3x2(:,46),heltab2x6(:,:,80))
  call Hloop_UW_V(ntryL,G1H6(146),39,ex5(:),16,G2H2(115),m3h3x2(:,47),heltab2x6(:,:,81))
call HGT_OLR(G1H6(147),1,1,6)
call HGT_invQ_OLR(G1H6(147),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(147),-8,0,G2H6(23),n2h6(38))
  call Hloop_AQ_V(ntryL,G2H6(23),ex4(:),G2H3(35),m3h2x3(:,35),heltab2x6(:,:,82))
  call Hloop_UW_V(ntryL,G1H6(151),39,ex5(:),16,G2H2(116),m3h3x2(:,48),heltab2x6(:,:,83))
  call Hloop_UW_V(ntryL,G1H6(152),39,ex5(:),16,G2H2(117),m3h3x2(:,49),heltab2x6(:,:,84))
call HGT_OLR(G1H6(153),1,1,6)
call HGT_invQ_OLR(G1H6(153),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(153),-8,0,G2H6(24),n2h6(39))
  call Hloop_AQ_Z(ntryL,G2H6(24),ex4(:),G2H3(36),ngZd,m3h2x3(:,36),heltab2x6(:,:,85))
  call Hloop_UW_V(ntryL,G1H6(157),39,ex5(:),16,G2H2(118),m3h3x2(:,50),heltab2x6(:,:,86))
  call Hloop_WQ_A(ntryL,G1H6(158),ex2(:),G1H3(1),m3h2x3(:,37),heltab2x6(:,:,87))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(37),n2h3(25))
call HGT_OLR(G1H6(159),1,1,6)
call HGT_invQ_OLR(G1H6(159),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(159),-16,nMT,G2H6(25),n2h6(40))
  call Hloop_AW_Q(ntryL,G2H6(25),ex5(:),G2H2(119),m3h3x2(:,51),heltab2x6(:,:,88))
  call Hloop_WQ_A(ntryL,G1H6(163),ex2(:),G1H3(1),m3h2x3(:,38),heltab2x6(:,:,89))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(38),n2h3(26))
  call Hloop_WQ_A(ntryL,G1H6(164),ex2(:),G1H3(1),m3h2x3(:,39),heltab2x6(:,:,90))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(39),n2h3(27))
call HGT_OLR(G1H6(165),1,1,6)
call HGT_invQ_OLR(G1H6(165),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(165),-16,nMT,G2H6(26),n2h6(41))
  call Hloop_AW_Q(ntryL,G2H6(26),ex5(:),G2H2(120),m3h3x2(:,52),heltab2x6(:,:,91))
  call Hloop_WQ_A(ntryL,G1H6(169),ex2(:),G1H3(1),m3h2x3(:,40),heltab2x6(:,:,92))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(40),n2h3(28))
  call Hloop_VA_Q(ntryL,G1H6(170),ex3(:),G1H3(1),m3h2x3(:,41),heltab2x6(:,:,93))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(41),n2h3(29))
call HGT_OLR(G1H6(171),1,1,6)
call HGT_invQ_OLR(G1H6(171),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(171),-16,nMB,G2H6(27),n2h6(42))
  call Hloop_QW_A(ntryL,G2H6(27),ex5(:),G2H2(121),m3h3x2(:,53),heltab2x6(:,:,94))
  call Hloop_VA_Q(ntryL,G1H6(175),ex3(:),G1H3(1),m3h2x3(:,42),heltab2x6(:,:,95))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(42),n2h3(30))
  call Hloop_ZA_Q(ntryL,G1H6(176),ex3(:),G1H3(1),ngZu,m3h2x3(:,43),heltab2x6(:,:,96))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(43),n2h3(31))
call HGT_OLR(G1H6(177),1,1,6)
call HGT_invQ_OLR(G1H6(177),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(177),-16,nMB,G2H6(28),n2h6(43))
  call Hloop_QW_A(ntryL,G2H6(28),ex5(:),G2H2(122),m3h3x2(:,54),heltab2x6(:,:,97))
  call Hloop_ZA_Q(ntryL,G1H6(181),ex3(:),G1H3(1),ngZu,m3h2x3(:,44),heltab2x6(:,:,98))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(44),n2h3(32))
  call Hloop_VA_Q(ntryL,G1H6(182),ex1(:),G1H3(1),m3h2x3(:,45),heltab2x6(:,:,99))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(45),n2h3(33))
call HGT_OLR(G1H6(183),1,1,6)
call HGT_invQ_OLR(G1H6(183),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(183),-16,0,G2H6(29),n2h6(44))
  call Hloop_QW_A(ntryL,G2H6(29),ex5(:),G2H2(123),m3h3x2(:,55),heltab2x6(:,:,100))
  call Hloop_VA_Q(ntryL,G1H6(187),ex1(:),G1H3(1),m3h2x3(:,46),heltab2x6(:,:,101))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(46),n2h3(34))
  call Hloop_VA_Q(ntryL,G1H6(188),ex1(:),G1H3(1),m3h2x3(:,47),heltab2x6(:,:,102))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(47),n2h3(35))
call HGT_OLR(G1H6(189),1,1,6)
call HGT_invQ_OLR(G1H6(189),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(189),-16,0,G2H6(30),n2h6(45))
  call Hloop_QW_A(ntryL,G2H6(30),ex5(:),G2H2(124),m3h3x2(:,56),heltab2x6(:,:,103))
  call Hloop_VA_Q(ntryL,G1H6(193),ex1(:),G1H3(1),m3h2x3(:,48),heltab2x6(:,:,104))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(48),n2h3(36))
  call Hloop_ZA_Q(ntryL,G1H6(194),ex1(:),G1H3(1),ngZu,m3h2x3(:,49),heltab2x6(:,:,105))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(49),n2h3(37))
call HGT_OLR(G1H6(195),1,1,6)
call HGT_invQ_OLR(G1H6(195),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(195),-16,0,G2H6(31),n2h6(46))
  call Hloop_QW_A(ntryL,G2H6(31),ex5(:),G2H2(125),m3h3x2(:,57),heltab2x6(:,:,106))
  call Hloop_ZA_Q(ntryL,G1H6(199),ex1(:),G1H3(1),ngZu,m3h2x3(:,50),heltab2x6(:,:,107))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(50),n2h3(38))
  call Hloop_ZA_Q(ntryL,G1H6(200),ex1(:),G1H3(1),ngZu,m3h2x3(:,51),heltab2x6(:,:,108))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(51),n2h3(39))
call HGT_OLR(G1H6(201),1,1,6)
call HGT_invQ_OLR(G1H6(201),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(201),-16,0,G2H6(32),n2h6(47))
  call Hloop_QW_A(ntryL,G2H6(32),ex5(:),G2H2(126),m3h3x2(:,58),heltab2x6(:,:,109))
  call Hloop_ZA_Q(ntryL,G1H6(205),ex1(:),G1H3(1),ngZu,m3h2x3(:,52),heltab2x6(:,:,110))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(52),n2h3(40))
  call Hloop_VQ_A(ntryL,G1H6(206),ex4(:),G1H3(1),m3h2x3(:,53),heltab2x6(:,:,111))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(53),n2h3(41))
call HGT_OLR(G1H6(207),1,1,6)
call HGT_invQ_OLR(G1H6(207),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(207),-16,0,G2H6(33),n2h6(48))
  call Hloop_AW_Q(ntryL,G2H6(33),ex5(:),G2H2(127),m3h3x2(:,59),heltab2x6(:,:,112))
  call Hloop_VQ_A(ntryL,G1H6(211),ex4(:),G1H3(1),m3h2x3(:,54),heltab2x6(:,:,113))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(54),n2h3(42))
  call Hloop_ZQ_A(ntryL,G1H6(212),ex4(:),G1H3(1),ngZd,m3h2x3(:,55),heltab2x6(:,:,114))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(55),n2h3(43))
call HGT_OLR(G1H6(213),1,1,6)
call HGT_invQ_OLR(G1H6(213),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(213),-16,0,G2H6(34),n2h6(49))
  call Hloop_AW_Q(ntryL,G2H6(34),ex5(:),G2H2(128),m3h3x2(:,60),heltab2x6(:,:,115))
  call Hloop_ZQ_A(ntryL,G1H6(217),ex4(:),G1H3(1),ngZd,m3h2x3(:,56),heltab2x6(:,:,116))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(56),n2h3(44))
  call Hloop_VQ_A(ntryL,G1H6(218),ex4(:),G1H3(1),m3h2x3(:,57),heltab2x6(:,:,117))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(57),n2h3(45))
call HGT_OLR(G1H6(219),1,1,6)
call HGT_invQ_OLR(G1H6(219),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(219),-16,0,G2H6(35),n2h6(50))
  call Hloop_AW_Q(ntryL,G2H6(35),ex5(:),G2H2(129),m3h3x2(:,61),heltab2x6(:,:,118))
  call Hloop_VQ_A(ntryL,G1H6(223),ex4(:),G1H3(1),m3h2x3(:,58),heltab2x6(:,:,119))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(58),n2h3(46))
  call Hloop_ZQ_A(ntryL,G1H6(224),ex4(:),G1H3(1),ngZd,m3h2x3(:,59),heltab2x6(:,:,120))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(59),n2h3(47))
call HGT_OLR(G1H6(225),1,1,6)
call HGT_invQ_OLR(G1H6(225),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(225),-16,0,G2H6(36),n2h6(51))
  call Hloop_AW_Q(ntryL,G2H6(36),ex5(:),G2H2(130),m3h3x2(:,62),heltab2x6(:,:,121))



end subroutine vamp_1

end module ol_vamp_1_ppwttj_ew_uxttxdwxg_3_/**/REALKIND
