
module ol_vamp_1_ppwttj_ew_uxttxdwxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwttj_ew_uxttxdwxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwttj_ew_uxttxdwxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwttj_ew_uxttxdwxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwttj_ew_uxttxdwxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwttj_ew_uxttxdwxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwttj_ew_uxttxdwxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(8,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(11)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1),h0tab(:,1),[32,4,8,1,2,16],[nMT,0,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,1),heltab2x96(:,:,1))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(1),n2h48(1))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2),h0tab(:,2),[32,4,16,2,1,8],[0,nMT,nMB,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(2),m3h2x48(:,2),heltab2x96(:,:,2))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(11)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(3),h0tab(:,3),[32,2,1,8,4,16],[nMB,nMW,0,0,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,3),heltab2x96(:,:,3))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(3),n2h48(2))
  Gcoeff(:)%j = (c(3)*M(5,:)%j-c(4)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4),h0tab(:,4),[32,2,1,8,16,4],[nMT,0,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,4),heltab2x96(:,:,4))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(4),n2h48(3))
  Gcoeff(:)%j = (-(c(42)*M(5,:)%j)+c(43)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5),h0tab(:,5),[32,2,1,8,16,4],[nMT,0,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,5),heltab2x96(:,:,5))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(5),n2h48(4))
  Gcoeff(:)%j = (-(c(19)*M(5,:)%j)+c(20)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(6),h0tab(:,6),[32,2,1,8,16,4],[nMT,0,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,6),heltab2x96(:,:,6))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(6),n2h48(5))
  Gcoeff(:)%j = (c(40)*M(1,:)%j-c(39)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(7),h0tab(:,7),[32,8,4,2,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,7),heltab2x96(:,:,7))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(7),n2h48(6))
  Gcoeff(:)%j = (c(34)*M(4,:)%j-c(35)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(8),h0tab(:,8),[32,8,4,2,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,8),heltab2x96(:,:,8))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(8),n2h48(7))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(9),h0tab(:,9),[32,8,4,2,1,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,9),heltab2x96(:,:,9))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(9),n2h48(8))
  Gcoeff(:)%j = (-(c(45)*M(4,:)%j)+c(46)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(10),h0tab(:,10),[32,8,4,2,1,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,10),heltab2x96(:,:,10))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(10),n2h48(9))
  Gcoeff(:)%j = (c(57)*M(3,:)%j+c(58)*(-M(2,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(11),h0tab(:,11),[32,8,4,2,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,11),heltab2x96(:,:,11))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(11),n2h48(10))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(12),h0tab(:,12),[32,4,2,1,16,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(12),m3h2x48(:,12),heltab2x96(:,:,12))
  Gcoeff(:)%j = (c(30)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(13),h0tab(:,13),[32,4,2,1,16,8],[0,nMT,nMZ,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(13),m3h2x48(:,13),heltab2x96(:,:,13))
  Gcoeff(:)%j = (c(50)*M(2,:)%j+c(52)*M(8,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(14),h0tab(:,14),[32,4,2,1,16,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(14),m3h2x48(:,14),heltab2x96(:,:,14))
  Gcoeff(:)%j = (c(40)*M(1,:)%j-c(39)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(15),h0tab(:,15),[32,2,1,16,8,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,15),heltab2x96(:,:,15))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(15),n2h48(11))
  Gcoeff(:)%j = (c(34)*M(5,:)%j-c(35)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(16),h0tab(:,16),[32,2,1,16,8,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,16),heltab2x96(:,:,16))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(16),n2h48(12))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(17),h0tab(:,17),[32,2,1,16,8,4],[nMT,nMZ,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,17),heltab2x96(:,:,17))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(17),n2h48(13))
  Gcoeff(:)%j = (-(c(45)*M(5,:)%j)+c(46)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(18),h0tab(:,18),[32,2,1,16,8,4],[nMT,0,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,18),heltab2x96(:,:,18))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(18),n2h48(14))
  Gcoeff(:)%j = (c(57)*M(6,:)%j+c(58)*(-M(2,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(19),h0tab(:,19),[32,2,1,16,8,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,19),heltab2x96(:,:,19))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(19),n2h48(15))
  Gcoeff(:)%j = (c(40)*M(1,:)%j-c(39)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(20),h0tab(:,20),[32,1,2,4,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,20),heltab2x96(:,:,20))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(20),n2h48(16))
  Gcoeff(:)%j = (c(34)*M(4,:)%j-c(35)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(21),h0tab(:,21),[32,1,2,4,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,21),heltab2x96(:,:,21))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(21),n2h48(17))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(22),h0tab(:,22),[32,1,2,4,8,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,22),heltab2x96(:,:,22))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(22),n2h48(18))
  Gcoeff(:)%j = (-(c(45)*M(4,:)%j)+c(46)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(23),h0tab(:,23),[32,1,2,4,8,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,23),heltab2x96(:,:,23))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(23),n2h48(19))
  Gcoeff(:)%j = (c(57)*M(3,:)%j+c(58)*(-M(2,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(24),h0tab(:,24),[32,1,2,4,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,24),heltab2x96(:,:,24))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(24),n2h48(20))
  Gcoeff(:)%j = (c(3)*M(4,:)%j-c(4)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(25),h0tab(:,25),[32,1,2,4,16,8],[0,0,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,25),heltab2x96(:,:,25))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(25),n2h48(21))
  Gcoeff(:)%j = (-(c(42)*M(4,:)%j)+c(43)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(26),h0tab(:,26),[32,1,2,4,16,8],[0,0,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,26),heltab2x96(:,:,26))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(26),n2h48(22))
  Gcoeff(:)%j = (-(c(19)*M(4,:)%j)+c(20)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(27),h0tab(:,27),[32,1,2,4,16,8],[0,0,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,27),heltab2x96(:,:,27))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(27),n2h48(23))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(11)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(28),h0tab(:,28),[32,1,2,16,4,8],[0,nMW,nMB,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,28),heltab2x96(:,:,28))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(28),n2h48(24))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(11)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(29),h0tab(:,29),[32,4,1,8,2,16],[nMT,0,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,29),heltab2x96(:,:,29))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(29),n2h48(25))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(11)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(30),h0tab(:,30),[32,2,8,1,4,16],[nMB,nMW,0,0,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,30),heltab2x96(:,:,30))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(30),n2h48(26))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(31),h0tab(:,31),[32,2,16,8,1,4],[nMT,nMH,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,31),heltab2x96(:,:,31))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(31),n2h48(27))
  Gcoeff(:)%j = (c(43)*M(1,:)%j-c(42)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(32),h0tab(:,32),[32,2,16,8,1,4],[nMT,0,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,32),heltab2x96(:,:,32))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(32),n2h48(28))
  Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(33),h0tab(:,33),[32,2,16,8,1,4],[nMT,nMZ,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,33),heltab2x96(:,:,33))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(33),n2h48(29))
  Gcoeff(:)%j = (c(40)*M(1,:)%j-c(39)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(34),h0tab(:,34),[32,8,2,4,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,34),heltab2x96(:,:,34))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(34),n2h48(30))
  Gcoeff(:)%j = (c(34)*M(4,:)%j-c(35)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(35),h0tab(:,35),[32,8,2,4,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,35),heltab2x96(:,:,35))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(35),n2h48(31))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(36),h0tab(:,36),[32,8,2,4,1,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,36),heltab2x96(:,:,36))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(36),n2h48(32))
  Gcoeff(:)%j = (-(c(45)*M(4,:)%j)+c(46)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(37),h0tab(:,37),[32,8,2,4,1,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,37),heltab2x96(:,:,37))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(37),n2h48(33))
  Gcoeff(:)%j = (c(57)*M(3,:)%j+c(61)*M(6,:)%j+c(58)*(-M(2,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(38),h0tab(:,38),[32,8,2,4,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,38),heltab2x96(:,:,38))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(38),n2h48(34))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(39),h0tab(:,39),[32,2,4,1,16,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(39),m3h2x48(:,39),heltab2x96(:,:,39))
  Gcoeff(:)%j = (c(30)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(40),h0tab(:,40),[32,2,4,1,16,8],[0,nMT,nMZ,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(40),m3h2x48(:,40),heltab2x96(:,:,40))
  Gcoeff(:)%j = (c(51)*(M(3,:)%j-M(6,:)%j)+c(50)*(M(2,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(41),h0tab(:,41),[32,2,4,1,16,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(41),m3h2x48(:,41),heltab2x96(:,:,41))
  Gcoeff(:)%j = (-(c(39)*M(5,:)%j)+c(40)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(42),h0tab(:,42),[32,2,8,16,1,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,42),heltab2x96(:,:,42))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(42),n2h48(35))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)+c(34)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(43),h0tab(:,43),[32,2,8,16,1,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,43),heltab2x96(:,:,43))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(43),n2h48(36))
  Gcoeff(:)%j = (-(c(45)*M(5,:)%j)+c(46)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(44),h0tab(:,44),[32,2,8,16,1,4],[nMT,0,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,44),heltab2x96(:,:,44))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(44),n2h48(37))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(45),h0tab(:,45),[32,2,8,16,1,4],[nMT,nMZ,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,45),heltab2x96(:,:,45))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(45),n2h48(38))
  Gcoeff(:)%j = (c(61)*M(3,:)%j+c(57)*M(6,:)%j+c(58)*(-M(2,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(46),h0tab(:,46),[32,2,8,16,1,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,46),heltab2x96(:,:,46))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(46),n2h48(39))
  Gcoeff(:)%j = (c(40)*M(1,:)%j-c(39)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(47),h0tab(:,47),[32,1,4,2,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,47),heltab2x96(:,:,47))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(47),n2h48(40))
  Gcoeff(:)%j = (c(34)*M(4,:)%j-c(35)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(48),h0tab(:,48),[32,1,4,2,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,48),heltab2x96(:,:,48))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(48),n2h48(41))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(49),h0tab(:,49),[32,1,4,2,8,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,49),heltab2x96(:,:,49))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(49),n2h48(42))
  Gcoeff(:)%j = (-(c(45)*M(4,:)%j)+c(46)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(50),h0tab(:,50),[32,1,4,2,8,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,50),heltab2x96(:,:,50))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(50),n2h48(43))
  Gcoeff(:)%j = (c(57)*M(3,:)%j+c(61)*M(6,:)%j+c(58)*(-M(2,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(51),h0tab(:,51),[32,1,4,2,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,51),heltab2x96(:,:,51))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(51),n2h48(44))
  Gcoeff(:)%j = (c(3)*M(4,:)%j-c(4)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(52),h0tab(:,52),[32,1,4,2,16,8],[0,0,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,52),heltab2x96(:,:,52))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(52),n2h48(45))
  Gcoeff(:)%j = (-(c(42)*M(4,:)%j)+c(43)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(53),h0tab(:,53),[32,1,4,2,16,8],[0,0,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,53),heltab2x96(:,:,53))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(53),n2h48(46))
  Gcoeff(:)%j = (-(c(19)*M(4,:)%j)+c(20)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(54),h0tab(:,54),[32,1,4,2,16,8],[0,0,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,54),heltab2x96(:,:,54))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(54),n2h48(47))
  Gcoeff(:)%j = (-(c(11)*M(4,:)%j)+c(12)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(55),h0tab(:,55),[32,1,4,16,2,8],[0,0,nMT,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,55),heltab2x96(:,:,55))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(55),n2h48(48))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(56),h0tab(:,56),[32,4,2,16,1,8],[0,nMT,nMH,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(56),m3h2x48(:,56),heltab2x96(:,:,56))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(57),h0tab(:,57),[32,4,2,16,1,8],[0,nMT,0,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(57),m3h2x48(:,57),heltab2x96(:,:,57))
  Gcoeff(:)%j = (c(17)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(58),h0tab(:,58),[32,4,2,16,1,8],[0,nMT,nMZ,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(58),m3h2x48(:,58),heltab2x96(:,:,58))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(59),h0tab(:,59),[32,2,4,16,1,8],[0,nMT,nMH,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(59),m3h2x48(:,59),heltab2x96(:,:,59))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(60),h0tab(:,60),[32,2,4,16,1,8],[0,nMT,0,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(60),m3h2x48(:,60),heltab2x96(:,:,60))
  Gcoeff(:)%j = (c(17)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(61),h0tab(:,61),[32,2,4,16,1,8],[0,nMT,nMZ,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(61),m3h2x48(:,61),heltab2x96(:,:,61))
  Gcoeff(:)%j = (c(3)*M(5,:)%j-c(4)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(62),h0tab(:,62),[32,2,8,1,16,4],[nMT,0,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,62),heltab2x96(:,:,62))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(62),n2h48(49))
  Gcoeff(:)%j = (-(c(42)*M(5,:)%j)+c(43)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(63),h0tab(:,63),[32,2,8,1,16,4],[nMT,0,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,63),heltab2x96(:,:,63))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(63),n2h48(50))
  Gcoeff(:)%j = (-(c(19)*M(5,:)%j)+c(20)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(64),h0tab(:,64),[32,2,8,1,16,4],[nMT,0,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,64),heltab2x96(:,:,64))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(64),n2h48(51))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(65),h0tab(:,65),[32,2,16,1,8,4],[nMT,nMH,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,65),heltab2x96(:,:,65))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(65),n2h48(52))
  Gcoeff(:)%j = (c(43)*M(1,:)%j-c(42)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(66),h0tab(:,66),[32,2,16,1,8,4],[nMT,0,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,66),heltab2x96(:,:,66))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(66),n2h48(53))
  Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(67),h0tab(:,67),[32,2,16,1,8,4],[nMT,nMZ,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,67),heltab2x96(:,:,67))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(67),n2h48(54))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(68),h0tab(:,68),[32,1,8,16,2,4],[0,0,nMW,nMH,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(68),m3h2x48(:,68),heltab2x96(:,:,68))
  Gcoeff(:)%j = (c(28)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(69),h0tab(:,69),[32,1,8,16,2,4],[0,0,nMW,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(69),m3h2x48(:,69),heltab2x96(:,:,69))
  Gcoeff(:)%j = (c(17)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(70),h0tab(:,70),[32,1,8,16,2,4],[0,0,nMW,nMZ,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(70),m3h2x48(:,70),heltab2x96(:,:,70))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(71),h0tab(:,71),[32,1,8,16,4,2],[0,0,nMW,nMH,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(71),m3h2x48(:,71),heltab2x96(:,:,71))
  Gcoeff(:)%j = (c(28)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(72),h0tab(:,72),[32,1,8,16,4,2],[0,0,nMW,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(72),m3h2x48(:,72),heltab2x96(:,:,72))
  Gcoeff(:)%j = (c(17)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(73),h0tab(:,73),[32,1,8,16,4,2],[0,0,nMW,nMZ,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(73),m3h2x48(:,73),heltab2x96(:,:,73))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(74),h0tab(:,74),[32,1,8,2,16,4],[0,0,nMW,nMB,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(74),m3h2x48(:,74),heltab2x96(:,:,74))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(75),h0tab(:,75),[32,1,16,4,2,8],[0,nMW,nMH,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,75),heltab2x96(:,:,75))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(75),n2h48(55))
  Gcoeff(:)%j = (c(43)*M(1,:)%j-c(42)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(76),h0tab(:,76),[32,1,16,4,2,8],[0,nMW,0,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,76),heltab2x96(:,:,76))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(76),n2h48(56))
  Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(77),h0tab(:,77),[32,1,16,4,2,8],[0,nMW,nMZ,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,77),heltab2x96(:,:,77))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(77),n2h48(57))
  Gcoeff(:)%j = (c(23)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(78),h0tab(:,78),[32,1,16,8,2,4],[0,0,0,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(78),m3h2x48(:,78),heltab2x96(:,:,78))
  Gcoeff(:)%j = (c(30)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(79),h0tab(:,79),[32,1,16,8,2,4],[0,0,0,nMZ,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(79),m3h2x48(:,79),heltab2x96(:,:,79))
  Gcoeff(:)%j = (c(51)*(M(3,:)%j-M(6,:)%j)+c(50)*(-M(2,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(80),h0tab(:,80),[32,1,16,8,2,4],[0,0,0,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(80),m3h2x48(:,80),heltab2x96(:,:,80))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(81),h0tab(:,81),[32,1,16,2,4,8],[0,nMW,nMH,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,81),heltab2x96(:,:,81))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(81),n2h48(58))
  Gcoeff(:)%j = (c(43)*M(1,:)%j-c(42)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(82),h0tab(:,82),[32,1,16,2,4,8],[0,nMW,0,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,82),heltab2x96(:,:,82))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(82),n2h48(59))
  Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(83),h0tab(:,83),[32,1,16,2,4,8],[0,nMW,nMZ,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,83),heltab2x96(:,:,83))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(83),n2h48(60))
  Gcoeff(:)%j = (c(23)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(84),h0tab(:,84),[32,1,16,8,4,2],[0,0,0,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(84),m3h2x48(:,84),heltab2x96(:,:,84))
  Gcoeff(:)%j = (c(30)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(85),h0tab(:,85),[32,1,16,8,4,2],[0,0,0,nMZ,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(85),m3h2x48(:,85),heltab2x96(:,:,85))
  Gcoeff(:)%j = (c(52)*M(2,:)%j+c(50)*M(8,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(86),h0tab(:,86),[32,1,16,8,4,2],[0,0,0,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(86),m3h2x48(:,86),heltab2x96(:,:,86))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(11),[G1H48(8),G1H48(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(14),[G1H48(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(19),[G1H48(16),G1H48(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(24),[G1H48(21),G1H48(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(38),[G1H48(35),G1H48(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(41),[G1H48(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(46),[G1H48(43),G1H48(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(51),[G1H48(48),G1H48(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(80),[G1H48(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(86),[G1H48(84)])
  call Hloop_QA_V(ntryL,G1H48(1),ex3(:),G1H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_VA_Q(ntryL,G1H48(2),ex3(:),G1H24(2),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_A_Q(ntryL,G1H24(2),36,nMT,G2H24(1),n2h24(1))
  call Hloop_AQ_W(ntryL,G1H48(3),ex2(:),G1H24(2),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_AQ_V(ntryL,G1H48(4),ex2(:),G1H24(3),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_AQ_V(ntryL,G1H48(5),ex2(:),G1H24(4),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_AQ_V(ntryL,G1H48(6),ex2(:),G1H24(5),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_AQ_V(ntryL,G1H48(11),ex4(:),G1H24(6),m3h2x24(:,7),heltab2x48(:,:,7))
  call Hloop_AQ_V(ntryL,G1H48(9),ex4(:),G1H24(7),m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_AQ_Z(ntryL,G1H48(10),ex4(:),G1H24(8),ngZd,m3h2x24(:,9),heltab2x48(:,:,9))
  call Hloop_VA_Q(ntryL,G1H48(14),ex3(:),G1H24(9),m3h2x24(:,10),heltab2x48(:,:,10))
  call Hloop_A_Q(ntryL,G1H24(9),36,nMT,G2H24(2),n2h24(2))
  call Hloop_VA_Q(ntryL,G1H48(13),ex3(:),G1H24(9),m3h2x24(:,11),heltab2x48(:,:,11))
  call Hloop_A_Q(ntryL,G1H24(9),36,nMT,G2H24(3),n2h24(3))
  call Hloop_AQ_V(ntryL,G1H48(19),ex2(:),G1H24(9),m3h2x24(:,12),heltab2x48(:,:,12))
  call Hloop_AQ_Z(ntryL,G1H48(17),ex2(:),G1H24(10),ngZu,m3h2x24(:,13),heltab2x48(:,:,13))
  call Hloop_AQ_V(ntryL,G1H48(18),ex2(:),G1H24(11),m3h2x24(:,14),heltab2x48(:,:,14))
  call Hloop_QA_V(ntryL,G1H48(24),ex1(:),G1H24(12),m3h2x24(:,15),heltab2x48(:,:,15))
  call Hloop_QA_Z(ntryL,G1H48(22),ex1(:),G1H24(13),ngZu,m3h2x24(:,16),heltab2x48(:,:,16))
  call Hloop_QA_V(ntryL,G1H48(23),ex1(:),G1H24(14),m3h2x24(:,17),heltab2x48(:,:,17))
  call Hloop_QA_V(ntryL,G1H48(25),ex1(:),G1H24(15),m3h2x24(:,18),heltab2x48(:,:,18))
  call Hloop_QA_V(ntryL,G1H48(26),ex1(:),G1H24(16),m3h2x24(:,19),heltab2x48(:,:,19))
  call Hloop_QA_V(ntryL,G1H48(27),ex1(:),G1H24(17),m3h2x24(:,20),heltab2x48(:,:,20))
  call Hloop_QA_W(ntryL,G1H48(28),ex1(:),G1H24(18),m3h2x24(:,21),heltab2x48(:,:,21))
  call Hloop_QA_V(ntryL,G1H48(29),ex3(:),G1H24(19),m3h2x24(:,22),heltab2x48(:,:,22))
  call Hloop_AQ_W(ntryL,G1H48(30),ex2(:),G1H24(20),m3h2x24(:,23),heltab2x48(:,:,23))
  call Hloop_AQ_S(ntryL,G1H48(31),ex2(:),G1H24(21),ngH,m3h2x24(:,24),heltab2x48(:,:,24))
  call Hloop_AQ_V(ntryL,G1H48(32),ex2(:),G1H24(22),m3h2x24(:,25),heltab2x48(:,:,25))
  call Hloop_AQ_Z(ntryL,G1H48(33),ex2(:),G1H24(23),ngZu,m3h2x24(:,26),heltab2x48(:,:,26))
  call Hloop_AQ_V(ntryL,G1H48(38),ex4(:),G1H24(24),m3h2x24(:,27),heltab2x48(:,:,27))
  call Hloop_AQ_V(ntryL,G1H48(36),ex4(:),G1H24(25),m3h2x24(:,28),heltab2x48(:,:,28))
  call Hloop_AQ_Z(ntryL,G1H48(37),ex4(:),G1H24(26),ngZd,m3h2x24(:,29),heltab2x48(:,:,29))
  call Hloop_VQ_A(ntryL,G1H48(41),ex2(:),G1H24(27),m3h2x24(:,30),heltab2x48(:,:,30))
  call Hloop_Q_A(ntryL,G1H24(27),34,nMT,G2H24(4),n2h24(4))
  call Hloop_VQ_A(ntryL,G1H48(40),ex2(:),G1H24(27),m3h2x24(:,31),heltab2x48(:,:,31))
  call Hloop_Q_A(ntryL,G1H24(27),34,nMT,G2H24(5),n2h24(5))
  call Hloop_AQ_V(ntryL,G1H48(46),ex2(:),G1H24(27),m3h2x24(:,32),heltab2x48(:,:,32))
  call Hloop_AQ_V(ntryL,G1H48(44),ex2(:),G1H24(28),m3h2x24(:,33),heltab2x48(:,:,33))
  call Hloop_AQ_Z(ntryL,G1H48(45),ex2(:),G1H24(29),ngZu,m3h2x24(:,34),heltab2x48(:,:,34))
  call Hloop_QA_V(ntryL,G1H48(51),ex1(:),G1H24(30),m3h2x24(:,35),heltab2x48(:,:,35))
  call Hloop_QA_Z(ntryL,G1H48(49),ex1(:),G1H24(31),ngZu,m3h2x24(:,36),heltab2x48(:,:,36))
  call Hloop_QA_V(ntryL,G1H48(50),ex1(:),G1H24(32),m3h2x24(:,37),heltab2x48(:,:,37))
  call Hloop_QA_V(ntryL,G1H48(52),ex1(:),G1H24(33),m3h2x24(:,38),heltab2x48(:,:,38))
  call Hloop_QA_V(ntryL,G1H48(53),ex1(:),G1H24(34),m3h2x24(:,39),heltab2x48(:,:,39))
  call Hloop_QA_V(ntryL,G1H48(54),ex1(:),G1H24(35),m3h2x24(:,40),heltab2x48(:,:,40))
  call Hloop_QA_V(ntryL,G1H48(55),ex1(:),G1H24(36),m3h2x24(:,41),heltab2x48(:,:,41))
  call Hloop_VA_Q(ntryL,G1H48(56),ex3(:),G1H24(37),m3h2x24(:,42),heltab2x48(:,:,42))
  call Hloop_A_Q(ntryL,G1H24(37),36,nMT,G2H24(6),n2h24(6))
  call Hloop_VA_Q(ntryL,G1H48(57),ex3(:),G1H24(37),m3h2x24(:,43),heltab2x48(:,:,43))
  call Hloop_A_Q(ntryL,G1H24(37),36,nMT,G2H24(7),n2h24(7))
  call Hloop_VA_Q(ntryL,G1H48(58),ex3(:),G1H24(37),m3h2x24(:,44),heltab2x48(:,:,44))
  call Hloop_A_Q(ntryL,G1H24(37),36,nMT,G2H24(8),n2h24(8))
  call Hloop_VQ_A(ntryL,G1H48(59),ex2(:),G1H24(37),m3h2x24(:,45),heltab2x48(:,:,45))
  call Hloop_Q_A(ntryL,G1H24(37),34,nMT,G2H24(9),n2h24(9))
  call Hloop_VQ_A(ntryL,G1H48(60),ex2(:),G1H24(37),m3h2x24(:,46),heltab2x48(:,:,46))
  call Hloop_Q_A(ntryL,G1H24(37),34,nMT,G2H24(10),n2h24(10))
  call Hloop_VQ_A(ntryL,G1H48(61),ex2(:),G1H24(37),m3h2x24(:,47),heltab2x48(:,:,47))
  call Hloop_Q_A(ntryL,G1H24(37),34,nMT,G2H24(11),n2h24(11))
  call Hloop_AQ_V(ntryL,G1H48(62),ex2(:),G1H24(37),m3h2x24(:,48),heltab2x48(:,:,48))
  call Hloop_AQ_V(ntryL,G1H48(63),ex2(:),G1H24(38),m3h2x24(:,49),heltab2x48(:,:,49))
  call Hloop_AQ_V(ntryL,G1H48(64),ex2(:),G1H24(39),m3h2x24(:,50),heltab2x48(:,:,50))
  call Hloop_AQ_S(ntryL,G1H48(65),ex2(:),G1H24(40),ngH,m3h2x24(:,51),heltab2x48(:,:,51))
  call Hloop_AQ_V(ntryL,G1H48(66),ex2(:),G1H24(41),m3h2x24(:,52),heltab2x48(:,:,52))
  call Hloop_AQ_Z(ntryL,G1H48(67),ex2(:),G1H24(42),ngZu,m3h2x24(:,53),heltab2x48(:,:,53))
  call Hloop_VA_Q(ntryL,G1H48(68),ex1(:),G1H24(43),m3h2x24(:,54),heltab2x48(:,:,54))
  call Hloop_A_Q(ntryL,G1H24(43),33,0,G2H24(12),n2h24(12))
  call Hloop_VA_Q(ntryL,G1H48(69),ex1(:),G1H24(43),m3h2x24(:,55),heltab2x48(:,:,55))
  call Hloop_A_Q(ntryL,G1H24(43),33,0,G2H24(13),n2h24(13))
  call Hloop_VA_Q(ntryL,G1H48(70),ex1(:),G1H24(43),m3h2x24(:,56),heltab2x48(:,:,56))
  call Hloop_A_Q(ntryL,G1H24(43),33,0,G2H24(14),n2h24(14))
  call Hloop_VA_Q(ntryL,G1H48(71),ex1(:),G1H24(43),m3h2x24(:,57),heltab2x48(:,:,57))
  call Hloop_A_Q(ntryL,G1H24(43),33,0,G2H24(15),n2h24(15))
  call Hloop_VA_Q(ntryL,G1H48(72),ex1(:),G1H24(43),m3h2x24(:,58),heltab2x48(:,:,58))
  call Hloop_A_Q(ntryL,G1H24(43),33,0,G2H24(16),n2h24(16))
  call Hloop_VA_Q(ntryL,G1H48(73),ex1(:),G1H24(43),m3h2x24(:,59),heltab2x48(:,:,59))
  call Hloop_A_Q(ntryL,G1H24(43),33,0,G2H24(17),n2h24(17))
  call Hloop_VA_Q(ntryL,G1H48(74),ex1(:),G1H24(43),m3h2x24(:,60),heltab2x48(:,:,60))
  call Hloop_A_Q(ntryL,G1H24(43),33,0,G2H24(18),n2h24(18))
  call Hloop_QA_W(ntryL,G1H48(75),ex1(:),G1H24(43),m3h2x24(:,61),heltab2x48(:,:,61))
  call Hloop_QA_W(ntryL,G1H48(76),ex1(:),G1H24(44),m3h2x24(:,62),heltab2x48(:,:,62))
  call Hloop_QA_W(ntryL,G1H48(77),ex1(:),G1H24(45),m3h2x24(:,63),heltab2x48(:,:,63))
  call Hloop_VA_Q(ntryL,G1H48(80),ex1(:),G1H24(46),m3h2x24(:,64),heltab2x48(:,:,64))
  call Hloop_A_Q(ntryL,G1H24(46),33,0,G2H24(19),n2h24(19))
  call Hloop_VA_Q(ntryL,G1H48(79),ex1(:),G1H24(46),m3h2x24(:,65),heltab2x48(:,:,65))
  call Hloop_A_Q(ntryL,G1H24(46),33,0,G2H24(20),n2h24(20))
  call Hloop_QA_W(ntryL,G1H48(81),ex1(:),G1H24(46),m3h2x24(:,66),heltab2x48(:,:,66))
  call Hloop_QA_W(ntryL,G1H48(82),ex1(:),G1H24(47),m3h2x24(:,67),heltab2x48(:,:,67))
  call Hloop_QA_W(ntryL,G1H48(83),ex1(:),G1H24(48),m3h2x24(:,68),heltab2x48(:,:,68))
  call Hloop_VA_Q(ntryL,G1H48(86),ex1(:),G1H24(49),m3h2x24(:,69),heltab2x48(:,:,69))
  call Hloop_A_Q(ntryL,G1H24(49),33,0,G2H24(21),n2h24(21))
  call Hloop_VA_Q(ntryL,G1H48(85),ex1(:),G1H24(49),m3h2x24(:,70),heltab2x48(:,:,70))
  call Hloop_A_Q(ntryL,G1H24(49),33,0,G2H24(22),n2h24(22))
  call Hloop_VQ_A(ntryL,G1H24(1),ex4(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_Q_A(ntryL,G1H12(1),44,0,G2H12(1),n2h12(1))
  call Hotf_5pt_reduction(G2H24(1),RedSet_5(1),mass5set(:,1),  & 
G1H24(49),G1H24(1),G1H24(50),G1H24(51),G1H24(52),G1H24(53),24)
  call HG1shiftOLR(G1H24(1),8,24)
  call Hloop_WA_Q(ntryL,G1H24(2),ex1(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(2),n2h12(2))
  call Hloop_VA_Q(ntryL,G1H24(3),ex1(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(3),n2h12(3))
  call Hloop_VA_Q(ntryL,G1H24(4),ex1(:),G1H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(4),n2h12(4))
  call Hloop_VA_Q(ntryL,G1H24(5),ex1(:),G1H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(5),n2h12(5))
  call Hloop_VA_Q(ntryL,G1H24(6),ex3(:),G1H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(6),n2h12(6))
  call Hloop_VA_Q(ntryL,G1H24(7),ex3(:),G1H12(1),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(7),n2h12(7))
  call Hloop_ZA_Q(ntryL,G1H24(8),ex3(:),G1H12(1),ngZu,m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(8),n2h12(8))
  call Hloop_AQ_V(ntryL,G2H24(2),ex2(:),G2H12(9),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_AQ_Z(ntryL,G2H24(3),ex2(:),G2H12(10),ngZu,m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_VA_Q(ntryL,G1H24(9),ex1(:),G1H12(1),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(11),n2h12(9))
  call Hloop_ZA_Q(ntryL,G1H24(10),ex1(:),G1H12(1),ngZu,m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(12),n2h12(10))
  call Hloop_VA_Q(ntryL,G1H24(11),ex1(:),G1H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(13),n2h12(11))
  call Hloop_VQ_A(ntryL,G1H24(12),ex2(:),G1H12(1),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(14),n2h12(12))
  call Hloop_ZQ_A(ntryL,G1H24(13),ex2(:),G1H12(1),ngZu,m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(15),n2h12(13))
  call Hloop_VQ_A(ntryL,G1H24(14),ex2(:),G1H12(1),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(16),n2h12(14))
  call Hloop_VQ_A(ntryL,G1H24(15),ex2(:),G1H12(1),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(17),n2h12(15))
  call Hloop_VQ_A(ntryL,G1H24(16),ex2(:),G1H12(1),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(18),n2h12(16))
  call Hloop_VQ_A(ntryL,G1H24(17),ex2(:),G1H12(1),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(19),n2h12(17))
  call Hloop_WQ_A(ntryL,G1H24(18),ex2(:),G1H12(1),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(20),n2h12(18))
  call Hloop_VA_Q(ntryL,G1H24(19),ex1(:),G1H12(1),m3h2x12(:,21),heltab2x24(:,:,21))
  call Hloop_A_Q(ntryL,G1H12(1),37,0,G2H12(21),n2h12(19))
  call Hloop_WQ_A(ntryL,G1H24(20),ex4(:),G1H12(1),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(22),n2h12(20))
  call Hloop_SV_V(ntryL,G1H24(21),ex5(:),G1H8(1),m3h3x8(:,1),heltab2x24(:,:,23))
  call Hloop_UV_W(ntryL,G1H24(22),34,ex5(:),16,G2H8(1),m3h3x8(:,2),heltab2x24(:,:,24))
  call Hloop_UV_W(ntryL,G1H24(23),34,ex5(:),16,G2H8(2),m3h3x8(:,3),heltab2x24(:,:,25))
  call Hloop_VQ_A(ntryL,G1H24(24),ex2(:),G1H12(1),m3h2x12(:,23),heltab2x24(:,:,26))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(23),n2h12(21))
  call Hloop_VQ_A(ntryL,G1H24(25),ex2(:),G1H12(1),m3h2x12(:,24),heltab2x24(:,:,27))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(24),n2h12(22))
  call Hloop_ZQ_A(ntryL,G1H24(26),ex2(:),G1H12(1),ngZu,m3h2x12(:,25),heltab2x24(:,:,28))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(25),n2h12(23))
  call Hloop_QA_V(ntryL,G2H24(4),ex3(:),G2H12(26),m3h2x12(:,26),heltab2x24(:,:,29))
  call Hloop_QA_Z(ntryL,G2H24(5),ex3(:),G2H12(27),ngZu,m3h2x12(:,27),heltab2x24(:,:,30))
  call Hloop_VQ_A(ntryL,G1H24(27),ex4(:),G1H12(1),m3h2x12(:,28),heltab2x24(:,:,31))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(28),n2h12(24))
  call Hloop_VQ_A(ntryL,G1H24(28),ex4(:),G1H12(1),m3h2x12(:,29),heltab2x24(:,:,32))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(29),n2h12(25))
  call Hloop_ZQ_A(ntryL,G1H24(29),ex4(:),G1H12(1),ngZd,m3h2x12(:,30),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(30),n2h12(26))
  call Hloop_VA_Q(ntryL,G1H24(30),ex3(:),G1H12(1),m3h2x12(:,31),heltab2x24(:,:,34))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(31),n2h12(27))
  call Hloop_ZA_Q(ntryL,G1H24(31),ex3(:),G1H12(1),ngZu,m3h2x12(:,32),heltab2x24(:,:,35))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(32),n2h12(28))
  call Hloop_VA_Q(ntryL,G1H24(32),ex3(:),G1H12(1),m3h2x12(:,33),heltab2x24(:,:,36))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(33),n2h12(29))
  call Hloop_VA_Q(ntryL,G1H24(33),ex3(:),G1H12(1),m3h2x12(:,34),heltab2x24(:,:,37))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(34),n2h12(30))
  call Hloop_VA_Q(ntryL,G1H24(34),ex3(:),G1H12(1),m3h2x12(:,35),heltab2x24(:,:,38))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(35),n2h12(31))
  call Hloop_VA_Q(ntryL,G1H24(35),ex3(:),G1H12(1),m3h2x12(:,36),heltab2x24(:,:,39))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(36),n2h12(32))
  call Hloop_VA_Q(ntryL,G1H24(36),ex3(:),G1H12(1),m3h2x12(:,37),heltab2x24(:,:,40))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(37),n2h12(33))
  call Hloop_AQ_S(ntryL,G2H24(6),ex2(:),G2H12(38),ngH,m3h2x12(:,38),heltab2x24(:,:,41))
  call Hloop_AQ_V(ntryL,G2H24(7),ex2(:),G2H12(39),m3h2x12(:,39),heltab2x24(:,:,42))
  call Hloop_AQ_Z(ntryL,G2H24(8),ex2(:),G2H12(40),ngZu,m3h2x12(:,40),heltab2x24(:,:,43))
  call Hloop_QA_S(ntryL,G2H24(9),ex3(:),G2H12(41),ngH,m3h2x12(:,41),heltab2x24(:,:,44))
  call Hloop_QA_V(ntryL,G2H24(10),ex3(:),G2H12(42),m3h2x12(:,42),heltab2x24(:,:,45))
  call Hloop_QA_Z(ntryL,G2H24(11),ex3(:),G2H12(43),ngZu,m3h2x12(:,43),heltab2x24(:,:,46))
  call Hloop_VQ_A(ntryL,G1H24(37),ex4(:),G1H12(1),m3h2x12(:,44),heltab2x24(:,:,47))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(44),n2h12(34))
  call Hloop_VQ_A(ntryL,G1H24(38),ex4(:),G1H12(1),m3h2x12(:,45),heltab2x24(:,:,48))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(45),n2h12(35))
  call Hloop_VQ_A(ntryL,G1H24(39),ex4(:),G1H12(1),m3h2x12(:,46),heltab2x24(:,:,49))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(46),n2h12(36))
  call Hloop_SV_V(ntryL,G1H24(40),ex5(:),G1H8(2),m3h3x8(:,4),heltab2x24(:,:,50))
  call Hloop_UV_W(ntryL,G1H24(41),34,ex5(:),16,G2H8(3),m3h3x8(:,5),heltab2x24(:,:,51))
  call Hloop_UV_W(ntryL,G1H24(42),34,ex5(:),16,G2H8(4),m3h3x8(:,6),heltab2x24(:,:,52))
  call Hloop_AQ_W(ntryL,G2H24(12),ex4(:),G2H12(47),m3h2x12(:,47),heltab2x24(:,:,53))
  call Hloop_AQ_W(ntryL,G2H24(13),ex4(:),G2H12(48),m3h2x12(:,48),heltab2x24(:,:,54))
  call Hloop_AQ_W(ntryL,G2H24(14),ex4(:),G2H12(49),m3h2x12(:,49),heltab2x24(:,:,55))
  call Hloop_AQ_W(ntryL,G2H24(15),ex4(:),G2H12(50),m3h2x12(:,50),heltab2x24(:,:,56))
  call Hloop_AQ_W(ntryL,G2H24(16),ex4(:),G2H12(51),m3h2x12(:,51),heltab2x24(:,:,57))
  call Hloop_AQ_W(ntryL,G2H24(17),ex4(:),G2H12(52),m3h2x12(:,52),heltab2x24(:,:,58))
  call Hloop_AQ_W(ntryL,G2H24(18),ex4(:),G2H12(53),m3h2x12(:,53),heltab2x24(:,:,59))
  call Hloop_VV_S(ntryL,G1H24(43),ex5(:),G1H8(3),m3h3x8(:,7),heltab2x24(:,:,60))
  call Hloop_UW_V(ntryL,G1H24(44),33,ex5(:),16,G2H8(5),m3h3x8(:,8),heltab2x24(:,:,61))
  call Hloop_UW_V(ntryL,G1H24(45),33,ex5(:),16,G2H8(6),m3h3x8(:,9),heltab2x24(:,:,62))
  call Hotf_5pt_reduction(G2H24(19),RedSet_5(2),mass5set(:,2),  & 
G1H24(2),G1H24(3),G1H24(4),G1H24(5),G1H24(6),G1H24(7),24)
  call HG1shiftOLR(G1H24(3),4,24)
  call Hotf_5pt_reduction(G2H24(20),RedSet_5(2),mass5set(:,3),  & 
G1H24(8),G1H24(9),G1H24(10),G1H24(11),G1H24(12),G1H24(13),24)
  call HG1shiftOLR(G1H24(9),4,24)
  call Hloop_VV_S(ntryL,G1H24(46),ex5(:),G1H8(4),m3h3x8(:,10),heltab2x24(:,:,63))
  call Hloop_UW_V(ntryL,G1H24(47),33,ex5(:),16,G2H8(7),m3h3x8(:,11),heltab2x24(:,:,64))
  call Hloop_UW_V(ntryL,G1H24(48),33,ex5(:),16,G2H8(8),m3h3x8(:,12),heltab2x24(:,:,65))
  call Hotf_5pt_reduction(G2H24(21),RedSet_5(2),mass5set(:,2),  & 
G1H24(14),G1H24(15),G1H24(16),G1H24(17),G1H24(18),G1H24(19),24)
  call HG1shiftOLR(G1H24(15),2,24)
  call Hotf_5pt_reduction(G2H24(22),RedSet_5(2),mass5set(:,3),  & 
G1H24(20),G1H24(21),G1H24(22),G1H24(23),G1H24(24),G1H24(25),24)
  call HG1shiftOLR(G1H24(21),2,24)
  call Hloop_AW_Q(ntryL,G1H24(49),ex5(:),G1H8(5),m3h3x8(:,13),heltab2x24(:,:,66))
  call Hloop_A_Q(ntryL,G1H8(5),52,nMB,G2H8(9),n2h8(1))
call HGT_raise_alpha_OLR(G1H24(1),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(1),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(1),ex4(:),G1H12(1),m3h2x12(:,54),heltab2x24(:,:,67))
  call Hloop_AW_Q(ntryL,G1H24(51),ex5(:),G1H8(5),m3h3x8(:,14),heltab2x24(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(5),52,nMB,G2H8(10),n2h8(2))
  call Hloop_AW_Q(ntryL,G1H24(52),ex5(:),G1H8(5),m3h3x8(:,15),heltab2x24(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(5),52,nMB,G2H8(11),n2h8(3))
  call Hloop_AW_Q(ntryL,G1H24(53),ex5(:),G1H8(5),m3h3x8(:,16),heltab2x24(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(5),52,nMB,G2H8(12),n2h8(4))
  call Hloop_AW_Q(ntryL,G1H24(2),ex5(:),G1H8(5),m3h3x8(:,17),heltab2x24(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(13),n2h8(5))
call HGT_raise_alpha_OLR(G1H24(3),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(3),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(3),ex3(:),G1H12(2),m3h2x12(:,55),heltab2x24(:,:,72))
  call Hloop_AW_Q(ntryL,G1H24(5),ex5(:),G1H8(5),m3h3x8(:,18),heltab2x24(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(14),n2h8(6))
  call Hloop_AW_Q(ntryL,G1H24(6),ex5(:),G1H8(5),m3h3x8(:,19),heltab2x24(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(15),n2h8(7))
  call Hloop_AW_Q(ntryL,G1H24(7),ex5(:),G1H8(5),m3h3x8(:,20),heltab2x24(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(16),n2h8(8))
  call Hloop_AW_Q(ntryL,G1H24(8),ex5(:),G1H8(5),m3h3x8(:,21),heltab2x24(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(17),n2h8(9))
call HGT_raise_alpha_OLR(G1H24(9),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(9),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(9),ex3(:),G1H12(3),m3h2x12(:,56),heltab2x24(:,:,77))
  call Hloop_AW_Q(ntryL,G1H24(11),ex5(:),G1H8(5),m3h3x8(:,22),heltab2x24(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(18),n2h8(10))
  call Hloop_AW_Q(ntryL,G1H24(12),ex5(:),G1H8(5),m3h3x8(:,23),heltab2x24(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(19),n2h8(11))
  call Hloop_AW_Q(ntryL,G1H24(13),ex5(:),G1H8(5),m3h3x8(:,24),heltab2x24(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(20),n2h8(12))
  call Hloop_AW_Q(ntryL,G1H24(14),ex5(:),G1H8(5),m3h3x8(:,25),heltab2x24(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(21),n2h8(13))
call HGT_raise_alpha_OLR(G1H24(15),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(15),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(15),ex2(:),G1H12(4),m3h2x12(:,57),heltab2x24(:,:,82))
  call Hloop_AW_Q(ntryL,G1H24(17),ex5(:),G1H8(5),m3h3x8(:,26),heltab2x24(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(22),n2h8(14))
  call Hloop_AW_Q(ntryL,G1H24(18),ex5(:),G1H8(5),m3h3x8(:,27),heltab2x24(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(23),n2h8(15))
  call Hloop_AW_Q(ntryL,G1H24(19),ex5(:),G1H8(5),m3h3x8(:,28),heltab2x24(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(24),n2h8(16))
  call Hloop_AW_Q(ntryL,G1H24(20),ex5(:),G1H8(5),m3h3x8(:,29),heltab2x24(:,:,86))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(25),n2h8(17))
call HGT_raise_alpha_OLR(G1H24(21),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(21),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(21),ex2(:),G1H12(5),m3h2x12(:,58),heltab2x24(:,:,87))
  call Hloop_AW_Q(ntryL,G1H24(23),ex5(:),G1H8(5),m3h3x8(:,30),heltab2x24(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(26),n2h8(18))
  call Hloop_AW_Q(ntryL,G1H24(24),ex5(:),G1H8(5),m3h3x8(:,31),heltab2x24(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(27),n2h8(19))
  call Hloop_AW_Q(ntryL,G1H24(25),ex5(:),G1H8(5),m3h3x8(:,32),heltab2x24(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(28),n2h8(20))
  call Hloop_QA_W(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_V(ntryL,G2H12(2),ex4(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_AQ_W(ntryL,G2H12(3),ex4(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_AQ_W(ntryL,G2H12(4),ex4(:),G2H6(4),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_AQ_W(ntryL,G2H12(5),ex4(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_AQ_V(ntryL,G2H12(6),ex2(:),G2H6(6),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_AQ_Z(ntryL,G2H12(7),ex2(:),G2H6(7),ngZu,m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_AQ_V(ntryL,G2H12(8),ex2(:),G2H6(8),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hotf_5pt_reduction(G2H12(9),RedSet_5(3),mass5set(:,4),  & 
G1H12(6),G1H12(7),G1H12(8),G1H12(9),G1H12(10),G1H12(11),12)
  call HG1shiftOLR(G1H12(7),8,12)
  call Hotf_5pt_reduction(G2H12(10),RedSet_5(3),mass5set(:,5),  & 
G1H12(12),G1H12(13),G1H12(14),G1H12(15),G1H12(16),G1H12(17),12)
  call HG1shiftOLR(G1H12(13),8,12)
  call Hotf_5pt_reduction(G2H12(11),RedSet_5(4),mass5set(:,6),  & 
G1H12(18),G1H12(19),G1H12(20),G1H12(21),G1H12(22),G1H12(23),12)
  call HG1shiftOLR(G1H12(19),4,12)
  call Hotf_5pt_reduction(G2H12(12),RedSet_5(4),mass5set(:,7),  & 
G1H12(24),G1H12(25),G1H12(26),G1H12(27),G1H12(28),G1H12(29),12)
  call HG1shiftOLR(G1H12(25),4,12)
  call Hotf_5pt_reduction(G2H12(13),RedSet_5(4),mass5set(:,6),  & 
G1H12(30),G1H12(31),G1H12(32),G1H12(33),G1H12(34),G1H12(35),12)
  call HG1shiftOLR(G1H12(31),4,12)
  call Hloop_QA_V(ntryL,G2H12(14),ex3(:),G2H6(9),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_QA_V(ntryL,G2H12(15),ex3(:),G2H6(10),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_QA_Z(ntryL,G2H12(16),ex3(:),G2H6(11),ngZu,m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_QA_S(ntryL,G2H12(17),ex3(:),G2H6(12),ngH,m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_QA_V(ntryL,G2H12(18),ex3(:),G2H6(13),m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_QA_Z(ntryL,G2H12(19),ex3(:),G2H6(14),ngZu,m3h2x6(:,14),heltab2x12(:,:,14))
  call Hotf_5pt_reduction(G2H12(20),RedSet_5(5),mass5set(:,8),  & 
G1H12(36),G1H12(37),G1H12(38),G1H12(39),G1H12(40),G1H12(41),12)
  call HG1shiftOLR(G1H12(37),8,12)
  call Hloop_AQ_W(ntryL,G2H12(21),ex4(:),G2H6(15),m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_QA_V(ntryL,G2H12(22),ex1(:),G2H6(16),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_WQ_A(ntryL,G1H8(1),ex4(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(1),n2h4(1))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(6),mass5set(:,9),  & 
G1H8(5),G1H8(1),G1H8(6),G1H8(7),G1H8(8),G1H8(9),8)
  call HG1shiftOLR(G1H8(1),4,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(6),mass5set(:,10),  & 
G1H8(10),G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
  call HG1shiftOLR(G1H8(11),4,8)
  call Hloop_QA_V(ntryL,G2H12(23),ex3(:),G2H6(17),m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_QA_Z(ntryL,G2H12(24),ex3(:),G2H6(18),ngZu,m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_QA_V(ntryL,G2H12(25),ex3(:),G2H6(19),m3h2x6(:,19),heltab2x12(:,:,19))
  call Hotf_5pt_reduction(G2H12(26),RedSet_5(7),mass5set(:,4),  & 
G1H12(42),G1H12(43),G1H12(44),G1H12(45),G1H12(46),G1H12(47),12)
  call HG1shiftOLR(G1H12(43),8,12)
  call Hotf_5pt_reduction(G2H12(27),RedSet_5(7),mass5set(:,5),  & 
G1H12(48),G1H12(49),G1H12(50),G1H12(51),G1H12(52),G1H12(53),12)
  call HG1shiftOLR(G1H12(49),8,12)
  call Hotf_5pt_reduction(G2H12(28),RedSet_5(8),mass5set(:,6),  & 
G1H12(54),G1H12(55),G1H12(56),G1H12(57),G1H12(58),G1H12(59),12)
  call HG1shiftOLR(G1H12(55),4,12)
  call Hotf_5pt_reduction(G2H12(29),RedSet_5(8),mass5set(:,6),  & 
G1H12(60),G1H12(61),G1H12(62),G1H12(63),G1H12(64),G1H12(65),12)
  call HG1shiftOLR(G1H12(61),4,12)
  call Hotf_5pt_reduction(G2H12(30),RedSet_5(8),mass5set(:,7),  & 
G1H12(66),G1H12(67),G1H12(68),G1H12(69),G1H12(70),G1H12(71),12)
  call HG1shiftOLR(G1H12(67),4,12)
  call Hloop_AQ_V(ntryL,G2H12(31),ex2(:),G2H6(20),m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_AQ_V(ntryL,G2H12(32),ex2(:),G2H6(21),m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_AQ_Z(ntryL,G2H12(33),ex2(:),G2H6(22),ngZu,m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_AQ_S(ntryL,G2H12(34),ex2(:),G2H6(23),ngH,m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_AQ_V(ntryL,G2H12(35),ex2(:),G2H6(24),m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_AQ_Z(ntryL,G2H12(36),ex2(:),G2H6(25),ngZu,m3h2x6(:,25),heltab2x12(:,:,25))
  call Hotf_5pt_reduction(G2H12(37),RedSet_5(9),mass5set(:,11),  & 
G1H12(72),G1H12(73),G1H12(74),G1H12(75),G1H12(76),G1H12(77),12)
  call HG1shiftOLR(G1H12(73),8,12)
  call Hloop_SV_V(ntryL,G2H12(38),ex5(:),G2H4(2),m3h3x4(:,1),heltab2x12(:,:,26))
  call Hotf_5pt_reduction(G2H12(39),RedSet_5(10),mass5set(:,12),  & 
G1H12(78),G1H12(79),G1H12(80),G1H12(81),G1H12(82),G1H12(83),12)
  call HG1shiftOLR(G1H12(79),8,12)
  call Hotf_5pt_reduction(G2H12(40),RedSet_5(10),mass5set(:,13),  & 
G1H12(84),G1H12(85),G1H12(86),G1H12(87),G1H12(88),G1H12(89),12)
  call HG1shiftOLR(G1H12(85),8,12)
  call Hloop_SV_V(ntryL,G2H12(41),ex5(:),G2H4(3),m3h3x4(:,2),heltab2x12(:,:,27))
  call Hotf_5pt_reduction(G2H12(42),RedSet_5(11),mass5set(:,12),  & 
G1H12(90),G1H12(91),G1H12(92),G1H12(93),G1H12(94),G1H12(95),12)
  call HG1shiftOLR(G1H12(91),8,12)
  call Hotf_5pt_reduction(G2H12(43),RedSet_5(11),mass5set(:,13),  & 
G1H12(96),G1H12(97),G1H12(98),G1H12(99),G1H12(100),G1H12(101),12)
  call HG1shiftOLR(G1H12(97),8,12)
  call Hloop_QA_W(ntryL,G2H12(44),ex1(:),G2H6(26),m3h2x6(:,26),heltab2x12(:,:,28))
  call Hloop_QA_W(ntryL,G2H12(45),ex1(:),G2H6(27),m3h2x6(:,27),heltab2x12(:,:,29))
  call Hloop_QA_W(ntryL,G2H12(46),ex1(:),G2H6(28),m3h2x6(:,28),heltab2x12(:,:,30))
  call Hloop_WA_Q(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(4),n2h4(2))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(12),mass5set(:,9),  & 
G1H8(2),G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
  call HG1shiftOLR(G1H8(16),4,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(12),mass5set(:,10),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(22),4,8)
  call Hloop_VV_S(ntryL,G2H12(47),ex5(:),G2H4(5),m3h3x4(:,3),heltab2x12(:,:,31))
  call Hotf_5pt_reduction(G2H12(48),RedSet_5(13),mass5set(:,14),  & 
G1H12(102),G1H12(103),G1H12(104),G1H12(105),G1H12(106),G1H12(107),12)
  call HG1shiftOLR(G1H12(103),4,12)
  call Hotf_5pt_reduction(G2H12(49),RedSet_5(13),mass5set(:,15),  & 
G1H12(108),G1H12(109),G1H12(110),G1H12(111),G1H12(112),G1H12(113),12)
  call HG1shiftOLR(G1H12(109),4,12)
  call Hloop_VV_S(ntryL,G2H12(50),ex5(:),G2H4(6),m3h3x4(:,4),heltab2x12(:,:,32))
  call Hotf_5pt_reduction(G2H12(51),RedSet_5(13),mass5set(:,14),  & 
G1H12(114),G1H12(115),G1H12(116),G1H12(117),G1H12(118),G1H12(119),12)
  call HG1shiftOLR(G1H12(115),2,12)
  call Hotf_5pt_reduction(G2H12(52),RedSet_5(13),mass5set(:,15),  & 
G1H12(120),G1H12(121),G1H12(122),G1H12(123),G1H12(124),G1H12(125),12)
  call HG1shiftOLR(G1H12(121),2,12)
  call Hotf_5pt_reduction(G2H12(53),RedSet_5(14),mass5set(:,16),  & 
G1H12(126),G1H12(127),G1H12(128),G1H12(129),G1H12(130),G1H12(131),12)
  call HG1shiftOLR(G1H12(127),4,12)
  call Hloop_SA_Q(ntryL,G1H8(3),ex3(:),G1H4(1),ngH,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(7),n2h4(3))
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(15),mass5set(:,17),  & 
G1H8(3),G1H8(27),G1H8(28),G1H8(29),G1H8(30),G1H8(31),8)
  call HG1shiftOLR(G1H8(27),8,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(15),mass5set(:,18),  & 
G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),G1H8(37),8)
  call HG1shiftOLR(G1H8(33),8,8)
  call Hloop_SQ_A(ntryL,G1H8(4),ex2(:),G1H4(1),ngH,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(8),n2h4(4))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(16),mass5set(:,17),  & 
G1H8(4),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(16),mass5set(:,18),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),8,8)
  call Hloop_AQ_W(ntryL,G2H8(9),ex2(:),G2H4(9),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_W(ntryL,G2H8(11),ex2(:),G2H4(10),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_W(ntryL,G2H8(12),ex2(:),G2H4(11),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_V(ntryL,G2H8(13),ex4(:),G2H4(12),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_V(ntryL,G2H8(15),ex4(:),G2H4(13),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G2H8(16),ex4(:),G2H4(14),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_Z(ntryL,G2H8(17),ex4(:),G2H4(15),ngZd,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_Z(ntryL,G2H8(19),ex4(:),G2H4(16),ngZd,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_Z(ntryL,G2H8(20),ex4(:),G2H4(17),ngZd,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_V(ntryL,G2H8(21),ex4(:),G2H4(18),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_AQ_V(ntryL,G2H8(23),ex4(:),G2H4(19),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_V(ntryL,G2H8(24),ex4(:),G2H4(20),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_Z(ntryL,G2H8(25),ex4(:),G2H4(21),ngZd,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_Z(ntryL,G2H8(27),ex4(:),G2H4(22),ngZd,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_Z(ntryL,G2H8(28),ex4(:),G2H4(23),ngZd,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_VA_Q(ntryL,G1H12(6),ex1(:),G1H6(1),m3h2x6(:,29),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(29),n2h6(1))
call HGT_raise_alpha_OLR(G1H12(7),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(7),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(7),ex4(:),G1H6(1),m3h2x6(:,30),heltab2x12(:,:,34))
  call Hloop_VA_Q(ntryL,G1H12(10),ex1(:),G1H6(2),m3h2x6(:,31),heltab2x12(:,:,35))
  call Hloop_A_Q(ntryL,G1H6(2),39,0,G2H6(30),n2h6(2))
  call Hloop_VA_Q(ntryL,G1H12(11),ex1(:),G1H6(2),m3h2x6(:,32),heltab2x12(:,:,36))
  call Hloop_A_Q(ntryL,G1H6(2),39,0,G2H6(31),n2h6(3))
  call Hloop_ZA_Q(ntryL,G1H12(12),ex1(:),G1H6(2),ngZu,m3h2x6(:,33),heltab2x12(:,:,37))
  call Hloop_A_Q(ntryL,G1H6(2),39,0,G2H6(32),n2h6(4))
call HGT_raise_alpha_OLR(G1H12(13),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(13),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(13),ex4(:),G1H6(2),m3h2x6(:,34),heltab2x12(:,:,38))
  call Hloop_ZA_Q(ntryL,G1H12(16),ex1(:),G1H6(3),ngZu,m3h2x6(:,35),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H6(3),39,0,G2H6(33),n2h6(5))
  call Hloop_ZA_Q(ntryL,G1H12(17),ex1(:),G1H6(3),ngZu,m3h2x6(:,36),heltab2x12(:,:,40))
  call Hloop_A_Q(ntryL,G1H6(3),39,0,G2H6(34),n2h6(6))
  call Hloop_AW_Q(ntryL,G1H12(18),ex5(:),G1H4(1),m3h3x4(:,5),heltab2x12(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(24),n2h4(5))
call HGT_OLR(G1H12(19),1,1,12)
call HGT_invQ_OLR(G1H12(19),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(19),-4,nMT,G2H12(1),n2h12(39))
  call Hloop_QA_V(ntryL,G2H12(1),ex3(:),G2H6(35),m3h2x6(:,37),heltab2x12(:,:,42))
  call Hloop_AW_Q(ntryL,G1H12(22),ex5(:),G1H4(1),m3h3x4(:,6),heltab2x12(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(25),n2h4(6))
  call Hloop_AW_Q(ntryL,G1H12(23),ex5(:),G1H4(1),m3h3x4(:,7),heltab2x12(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(26),n2h4(7))
  call Hloop_AW_Q(ntryL,G1H12(24),ex5(:),G1H4(1),m3h3x4(:,8),heltab2x12(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(27),n2h4(8))
call HGT_OLR(G1H12(25),1,1,12)
call HGT_invQ_OLR(G1H12(25),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(25),-4,nMT,G2H12(2),n2h12(40))
  call Hloop_QA_V(ntryL,G2H12(2),ex3(:),G2H6(36),m3h2x6(:,38),heltab2x12(:,:,46))
  call Hloop_AW_Q(ntryL,G1H12(28),ex5(:),G1H4(1),m3h3x4(:,9),heltab2x12(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(28),n2h4(9))
  call Hloop_AW_Q(ntryL,G1H12(29),ex5(:),G1H4(1),m3h3x4(:,10),heltab2x12(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(29),n2h4(10))
  call Hloop_AW_Q(ntryL,G1H12(30),ex5(:),G1H4(1),m3h3x4(:,11),heltab2x12(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(30),n2h4(11))
call HGT_OLR(G1H12(31),1,1,12)
call HGT_invQ_OLR(G1H12(31),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(31),-4,nMT,G2H12(3),n2h12(41))
  call Hloop_QA_Z(ntryL,G2H12(3),ex3(:),G2H6(37),ngZu,m3h2x6(:,39),heltab2x12(:,:,50))
  call Hloop_AW_Q(ntryL,G1H12(34),ex5(:),G1H4(1),m3h3x4(:,12),heltab2x12(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(31),n2h4(12))
  call Hloop_AW_Q(ntryL,G1H12(35),ex5(:),G1H4(1),m3h3x4(:,13),heltab2x12(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(32),n2h4(13))
  call Hloop_QW_A(ntryL,G1H12(36),ex5(:),G1H4(1),m3h3x4(:,14),heltab2x12(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(33),n2h4(14))
call HGT_OLR(G1H12(37),1,1,12)
call HGT_invQ_OLR(G1H12(37),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(37),-8,0,G2H12(4),n2h12(42))
  call Hloop_AQ_V(ntryL,G2H12(4),ex4(:),G2H6(38),m3h2x6(:,40),heltab2x12(:,:,54))
  call Hloop_QW_A(ntryL,G1H12(40),ex5(:),G1H4(1),m3h3x4(:,15),heltab2x12(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(34),n2h4(15))
  call Hloop_QW_A(ntryL,G1H12(41),ex5(:),G1H4(1),m3h3x4(:,16),heltab2x12(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(35),n2h4(16))
  call Hloop_WQ_A(ntryL,G1H8(5),ex4(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(36),n2h4(17))
call HGT_OLR(G1H8(1),1,1,8)
call HGT_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1),-4,nMT,G2H8(1),n2h8(21))
  call Hloop_QA_V(ntryL,G2H8(1),ex3(:),G2H4(37),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_WQ_A(ntryL,G1H8(8),ex4(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(38),n2h4(18))
  call Hloop_WQ_A(ntryL,G1H8(9),ex4(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(39),n2h4(19))
  call Hloop_WQ_A(ntryL,G1H8(10),ex4(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(40),n2h4(20))
call HGT_OLR(G1H8(11),1,1,8)
call HGT_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(11),-4,nMT,G2H8(2),n2h8(22))
  call Hloop_QA_V(ntryL,G2H8(2),ex3(:),G2H4(41),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_WQ_A(ntryL,G1H8(14),ex4(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(42),n2h4(21))
  call Hloop_WQ_A(ntryL,G1H8(15),ex4(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(43),n2h4(22))
  call Hloop_VA_Q(ntryL,G1H12(42),ex1(:),G1H6(3),m3h2x6(:,41),heltab2x12(:,:,57))
  call Hloop_A_Q(ntryL,G1H6(3),39,0,G2H6(39),n2h6(7))
call HGT_raise_alpha_OLR(G1H12(43),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(43),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(43),ex4(:),G1H6(3),m3h2x6(:,42),heltab2x12(:,:,58))
  call Hloop_VA_Q(ntryL,G1H12(46),ex1(:),G1H6(4),m3h2x6(:,43),heltab2x12(:,:,59))
  call Hloop_A_Q(ntryL,G1H6(4),39,0,G2H6(40),n2h6(8))
  call Hloop_VA_Q(ntryL,G1H12(47),ex1(:),G1H6(4),m3h2x6(:,44),heltab2x12(:,:,60))
  call Hloop_A_Q(ntryL,G1H6(4),39,0,G2H6(41),n2h6(9))
  call Hloop_ZA_Q(ntryL,G1H12(48),ex1(:),G1H6(4),ngZu,m3h2x6(:,45),heltab2x12(:,:,61))
  call Hloop_A_Q(ntryL,G1H6(4),39,0,G2H6(42),n2h6(10))
call HGT_raise_alpha_OLR(G1H12(49),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(49),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(49),ex4(:),G1H6(4),m3h2x6(:,46),heltab2x12(:,:,62))
  call Hloop_ZA_Q(ntryL,G1H12(52),ex1(:),G1H6(5),ngZu,m3h2x6(:,47),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H6(5),39,0,G2H6(43),n2h6(11))
  call Hloop_ZA_Q(ntryL,G1H12(53),ex1(:),G1H6(5),ngZu,m3h2x6(:,48),heltab2x12(:,:,64))
  call Hloop_A_Q(ntryL,G1H6(5),39,0,G2H6(44),n2h6(12))
  call Hloop_QW_A(ntryL,G1H12(54),ex5(:),G1H4(1),m3h3x4(:,17),heltab2x12(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(44),n2h4(23))
call HGT_OLR(G1H12(55),1,1,12)
call HGT_invQ_OLR(G1H12(55),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(55),-4,nMT,G2H12(5),n2h12(45))
  call Hloop_QA_V(ntryL,G2H12(5),ex3(:),G2H6(45),m3h2x6(:,49),heltab2x12(:,:,66))
  call Hloop_QW_A(ntryL,G1H12(58),ex5(:),G1H4(1),m3h3x4(:,18),heltab2x12(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(45),n2h4(24))
  call Hloop_QW_A(ntryL,G1H12(59),ex5(:),G1H4(1),m3h3x4(:,19),heltab2x12(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(46),n2h4(25))
  call Hloop_QW_A(ntryL,G1H12(60),ex5(:),G1H4(1),m3h3x4(:,20),heltab2x12(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(47),n2h4(26))
call HGT_OLR(G1H12(61),1,1,12)
call HGT_invQ_OLR(G1H12(61),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(61),-4,nMT,G2H12(6),n2h12(46))
  call Hloop_QA_Z(ntryL,G2H12(6),ex3(:),G2H6(46),ngZu,m3h2x6(:,50),heltab2x12(:,:,70))
  call Hloop_QW_A(ntryL,G1H12(64),ex5(:),G1H4(1),m3h3x4(:,21),heltab2x12(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(48),n2h4(27))
  call Hloop_QW_A(ntryL,G1H12(65),ex5(:),G1H4(1),m3h3x4(:,22),heltab2x12(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(49),n2h4(28))
  call Hloop_QW_A(ntryL,G1H12(66),ex5(:),G1H4(1),m3h3x4(:,23),heltab2x12(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(50),n2h4(29))
call HGT_OLR(G1H12(67),1,1,12)
call HGT_invQ_OLR(G1H12(67),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(67),-4,nMT,G2H12(7),n2h12(47))
  call Hloop_QA_V(ntryL,G2H12(7),ex3(:),G2H6(47),m3h2x6(:,51),heltab2x12(:,:,74))
  call Hloop_QW_A(ntryL,G1H12(70),ex5(:),G1H4(1),m3h3x4(:,24),heltab2x12(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(51),n2h4(30))
  call Hloop_QW_A(ntryL,G1H12(71),ex5(:),G1H4(1),m3h3x4(:,25),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(52),n2h4(31))
  call Hloop_AW_Q(ntryL,G1H12(72),ex5(:),G1H4(1),m3h3x4(:,26),heltab2x12(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(53),n2h4(32))
call HGT_OLR(G1H12(73),1,1,12)
call HGT_invQ_OLR(G1H12(73),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(73),-8,0,G2H12(8),n2h12(48))
  call Hloop_AQ_W(ntryL,G2H12(8),ex4(:),G2H6(48),m3h2x6(:,52),heltab2x12(:,:,78))
  call Hloop_AW_Q(ntryL,G1H12(76),ex5(:),G1H4(1),m3h3x4(:,27),heltab2x12(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(54),n2h4(33))
  call Hloop_AW_Q(ntryL,G1H12(77),ex5(:),G1H4(1),m3h3x4(:,28),heltab2x12(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(55),n2h4(34))
  call Hloop_UV_W(ntryL,G1H12(78),38,ex5(:),16,G2H4(56),m3h3x4(:,29),heltab2x12(:,:,81))
call HGT_raise_alpha_OLR(G1H12(79),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(79),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(79),ex4(:),G1H6(5),m3h2x6(:,53),heltab2x12(:,:,82))
  call Hloop_UV_W(ntryL,G1H12(82),38,ex5(:),16,G2H4(57),m3h3x4(:,30),heltab2x12(:,:,83))
  call Hloop_UV_W(ntryL,G1H12(83),38,ex5(:),16,G2H4(58),m3h3x4(:,31),heltab2x12(:,:,84))
  call Hloop_UV_W(ntryL,G1H12(84),38,ex5(:),16,G2H4(59),m3h3x4(:,32),heltab2x12(:,:,85))
call HGT_raise_alpha_OLR(G1H12(85),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(85),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(85),ex4(:),G1H6(6),m3h2x6(:,54),heltab2x12(:,:,86))
  call Hloop_UV_W(ntryL,G1H12(88),38,ex5(:),16,G2H4(60),m3h3x4(:,33),heltab2x12(:,:,87))
  call Hloop_UV_W(ntryL,G1H12(89),38,ex5(:),16,G2H4(61),m3h3x4(:,34),heltab2x12(:,:,88))
  call Hloop_UV_W(ntryL,G1H12(90),38,ex5(:),16,G2H4(62),m3h3x4(:,35),heltab2x12(:,:,89))
call HGT_raise_alpha_OLR(G1H12(91),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(91),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(91),ex4(:),G1H6(7),m3h2x6(:,55),heltab2x12(:,:,90))
  call Hloop_UV_W(ntryL,G1H12(94),38,ex5(:),16,G2H4(63),m3h3x4(:,36),heltab2x12(:,:,91))
  call Hloop_UV_W(ntryL,G1H12(95),38,ex5(:),16,G2H4(64),m3h3x4(:,37),heltab2x12(:,:,92))
  call Hloop_UV_W(ntryL,G1H12(96),38,ex5(:),16,G2H4(65),m3h3x4(:,38),heltab2x12(:,:,93))
call HGT_raise_alpha_OLR(G1H12(97),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(97),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(97),ex4(:),G1H6(8),m3h2x6(:,56),heltab2x12(:,:,94))
  call Hloop_UV_W(ntryL,G1H12(100),38,ex5(:),16,G2H4(66),m3h3x4(:,39),heltab2x12(:,:,95))
  call Hloop_UV_W(ntryL,G1H12(101),38,ex5(:),16,G2H4(67),m3h3x4(:,40),heltab2x12(:,:,96))
  call Hloop_WA_Q(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(68),n2h4(35))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(16),-4,nMT,G2H8(3),n2h8(23))
  call Hloop_QA_V(ntryL,G2H8(3),ex3(:),G2H4(69),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_WA_Q(ntryL,G1H8(19),ex1(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(70),n2h4(36))
  call Hloop_WA_Q(ntryL,G1H8(20),ex1(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(71),n2h4(37))
  call Hloop_WA_Q(ntryL,G1H8(21),ex1(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(72),n2h4(38))
call HGT_OLR(G1H8(22),1,1,8)
call HGT_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(22),-4,nMT,G2H8(4),n2h8(24))
  call Hloop_QA_V(ntryL,G2H8(4),ex3(:),G2H4(73),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_WA_Q(ntryL,G1H8(25),ex1(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(74),n2h4(39))
  call Hloop_WA_Q(ntryL,G1H8(26),ex1(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(75),n2h4(40))
  call Hloop_UW_V(ntryL,G1H12(102),41,ex5(:),16,G2H4(76),m3h3x4(:,41),heltab2x12(:,:,97))
call HGT_raise_alpha_OLR(G1H12(103),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(103),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(103),ex3(:),G1H6(9),m3h2x6(:,57),heltab2x12(:,:,98))
  call Hloop_UW_V(ntryL,G1H12(106),41,ex5(:),16,G2H4(77),m3h3x4(:,42),heltab2x12(:,:,99))
  call Hloop_UW_V(ntryL,G1H12(107),41,ex5(:),16,G2H4(78),m3h3x4(:,43),heltab2x12(:,:,100))
  call Hloop_UW_V(ntryL,G1H12(108),41,ex5(:),16,G2H4(79),m3h3x4(:,44),heltab2x12(:,:,101))
call HGT_raise_alpha_OLR(G1H12(109),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(109),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(109),ex3(:),G1H6(10),m3h2x6(:,58),heltab2x12(:,:,102))
  call Hloop_UW_V(ntryL,G1H12(112),41,ex5(:),16,G2H4(80),m3h3x4(:,45),heltab2x12(:,:,103))
  call Hloop_UW_V(ntryL,G1H12(113),41,ex5(:),16,G2H4(81),m3h3x4(:,46),heltab2x12(:,:,104))
  call Hloop_UW_V(ntryL,G1H12(114),41,ex5(:),16,G2H4(82),m3h3x4(:,47),heltab2x12(:,:,105))
call HGT_raise_alpha_OLR(G1H12(115),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(115),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(115),ex2(:),G1H6(11),m3h2x6(:,59),heltab2x12(:,:,106))
  call Hloop_UW_V(ntryL,G1H12(118),41,ex5(:),16,G2H4(83),m3h3x4(:,48),heltab2x12(:,:,107))
  call Hloop_UW_V(ntryL,G1H12(119),41,ex5(:),16,G2H4(84),m3h3x4(:,49),heltab2x12(:,:,108))
  call Hloop_UW_V(ntryL,G1H12(120),41,ex5(:),16,G2H4(85),m3h3x4(:,50),heltab2x12(:,:,109))
call HGT_raise_alpha_OLR(G1H12(121),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(121),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(121),ex2(:),G1H6(12),m3h2x6(:,60),heltab2x12(:,:,110))
  call Hloop_UW_V(ntryL,G1H12(124),41,ex5(:),16,G2H4(86),m3h3x4(:,51),heltab2x12(:,:,111))
  call Hloop_UW_V(ntryL,G1H12(125),41,ex5(:),16,G2H4(87),m3h3x4(:,52),heltab2x12(:,:,112))
  call Hloop_WQ_A(ntryL,G1H12(126),ex2(:),G1H6(13),m3h2x6(:,61),heltab2x12(:,:,113))
  call Hloop_Q_A(ntryL,G1H6(13),43,nMB,G2H6(49),n2h6(13))
call HGT_raise_alpha_OLR(G1H12(127),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(127),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(127),ex3(:),G1H6(13),m3h2x6(:,62),heltab2x12(:,:,114))
  call Hloop_WQ_A(ntryL,G1H12(130),ex2(:),G1H6(14),m3h2x6(:,63),heltab2x12(:,:,115))
  call Hloop_Q_A(ntryL,G1H6(14),43,nMB,G2H6(50),n2h6(14))
  call Hloop_WQ_A(ntryL,G1H12(131),ex2(:),G1H6(14),m3h2x6(:,64),heltab2x12(:,:,116))
  call Hloop_Q_A(ntryL,G1H6(14),43,nMB,G2H6(51),n2h6(15))
  call Hloop_VA_Q(ntryL,G1H8(3),ex3(:),G1H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(88),n2h4(41))
call HGT_OLR(G1H8(27),1,1,8)
call HGT_invQ_OLR(G1H8(27),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(27),-8,0,G2H8(5),n2h8(25))
  call Hloop_AQ_V(ntryL,G2H8(5),ex4(:),G2H4(89),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_VA_Q(ntryL,G1H8(30),ex3(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(90),n2h4(42))
  call Hloop_VA_Q(ntryL,G1H8(31),ex3(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(91),n2h4(43))
  call Hloop_ZA_Q(ntryL,G1H8(32),ex3(:),G1H4(1),ngZu,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(92),n2h4(44))
call HGT_OLR(G1H8(33),1,1,8)
call HGT_invQ_OLR(G1H8(33),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(33),-8,0,G2H8(6),n2h8(26))
  call Hloop_AQ_V(ntryL,G2H8(6),ex4(:),G2H4(93),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_ZA_Q(ntryL,G1H8(36),ex3(:),G1H4(1),ngZu,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(94),n2h4(45))
  call Hloop_ZA_Q(ntryL,G1H8(37),ex3(:),G1H4(1),ngZu,m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(95),n2h4(46))
  call Hloop_VQ_A(ntryL,G1H8(4),ex2(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(96),n2h4(47))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-8,0,G2H8(7),n2h8(27))
  call Hloop_AQ_V(ntryL,G2H8(7),ex4(:),G2H4(97),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_VQ_A(ntryL,G1H8(41),ex2(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(98),n2h4(48))
  call Hloop_VQ_A(ntryL,G1H8(42),ex2(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(99),n2h4(49))
  call Hloop_ZQ_A(ntryL,G1H8(43),ex2(:),G1H4(1),ngZu,m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(100),n2h4(50))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(44),-8,0,G2H8(8),n2h8(28))
  call Hloop_AQ_V(ntryL,G2H8(8),ex4(:),G2H4(101),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_ZQ_A(ntryL,G1H8(47),ex2(:),G1H4(1),ngZu,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(102),n2h4(51))
  call Hloop_ZQ_A(ntryL,G1H8(48),ex2(:),G1H4(1),ngZu,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(103),n2h4(52))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(17),mass5set(:,19),  & 
G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),G1H6(19),6)
  call HG1shiftOLR(G1H6(15),16,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(18),mass5set(:,20),  & 
G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),G1H6(25),6)
  call HG1shiftOLR(G1H6(21),16,6)
  call Hloop_VV_S(ntryL,G2H6(3),ex5(:),G2H2(1),m3h3x2(:,1),heltab2x6(:,:,1))
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(18),mass5set(:,19),  & 
G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),G1H6(31),6)
  call HG1shiftOLR(G1H6(27),4,6)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(18),mass5set(:,19),  & 
G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),G1H6(37),6)
  call HG1shiftOLR(G1H6(33),4,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(19),mass5set(:,21),  & 
G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),G1H6(43),6)
  call HG1shiftOLR(G1H6(39),16,6)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(19),mass5set(:,22),  & 
G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),G1H6(49),6)
  call HG1shiftOLR(G1H6(45),16,6)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(19),mass5set(:,23),  & 
G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),G1H6(55),6)
  call HG1shiftOLR(G1H6(51),16,6)
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(20),mass5set(:,21),  & 
G1H6(56),G1H6(57),G1H6(58),G1H6(59),G1H6(60),G1H6(61),6)
  call HG1shiftOLR(G1H6(57),16,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(20),mass5set(:,23),  & 
G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),G1H6(67),6)
  call HG1shiftOLR(G1H6(63),16,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(20),mass5set(:,22),  & 
G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),G1H6(73),6)
  call HG1shiftOLR(G1H6(69),16,6)
  call Hloop_SV_V(ntryL,G2H6(12),ex5(:),G2H2(2),m3h3x2(:,2),heltab2x6(:,:,2))
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(20),mass5set(:,21),  & 
G1H6(74),G1H6(75),G1H6(76),G1H6(77),G1H6(78),G1H6(79),6)
  call HG1shiftOLR(G1H6(75),8,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(20),mass5set(:,22),  & 
G1H6(80),G1H6(81),G1H6(82),G1H6(83),G1H6(84),G1H6(85),6)
  call HG1shiftOLR(G1H6(81),8,6)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(21),mass5set(:,19),  & 
G1H6(86),G1H6(87),G1H6(88),G1H6(89),G1H6(90),G1H6(91),6)
  call HG1shiftOLR(G1H6(87),16,6)
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(22),mass5set(:,20),  & 
G1H6(92),G1H6(93),G1H6(94),G1H6(95),G1H6(96),G1H6(97),6)
  call HG1shiftOLR(G1H6(93),16,6)
  call Hloop_QA_V(ntryL,G2H4(1),ex1(:),G2H2(3),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(23),mass5set(:,21),  & 
G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),G1H6(103),6)
  call HG1shiftOLR(G1H6(99),16,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(23),mass5set(:,22),  & 
G1H6(104),G1H6(105),G1H6(106),G1H6(107),G1H6(108),G1H6(109),6)
  call HG1shiftOLR(G1H6(105),16,6)
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(23),mass5set(:,23),  & 
G1H6(110),G1H6(111),G1H6(112),G1H6(113),G1H6(114),G1H6(115),6)
  call HG1shiftOLR(G1H6(111),16,6)
  call Hotf_5pt_reduction(G2H6(20),RedSet_5(24),mass5set(:,21),  & 
G1H6(116),G1H6(117),G1H6(118),G1H6(119),G1H6(120),G1H6(121),6)
  call HG1shiftOLR(G1H6(117),16,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(24),mass5set(:,23),  & 
G1H6(122),G1H6(123),G1H6(124),G1H6(125),G1H6(126),G1H6(127),6)
  call HG1shiftOLR(G1H6(123),16,6)
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(24),mass5set(:,22),  & 
G1H6(128),G1H6(129),G1H6(130),G1H6(131),G1H6(132),G1H6(133),6)
  call HG1shiftOLR(G1H6(129),16,6)
  call Hloop_SV_V(ntryL,G2H6(23),ex5(:),G2H2(4),m3h3x2(:,3),heltab2x6(:,:,3))
  call Hotf_5pt_reduction(G2H6(24),RedSet_5(24),mass5set(:,21),  & 
G1H6(134),G1H6(135),G1H6(136),G1H6(137),G1H6(138),G1H6(139),6)
  call HG1shiftOLR(G1H6(135),8,6)
  call Hotf_5pt_reduction(G2H6(25),RedSet_5(24),mass5set(:,22),  & 
G1H6(140),G1H6(141),G1H6(142),G1H6(143),G1H6(144),G1H6(145),6)
  call HG1shiftOLR(G1H6(141),8,6)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(10),mass5set(:,24),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(11),mass5set(:,24),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hloop_VV_S(ntryL,G2H6(26),ex5(:),G2H2(5),m3h3x2(:,4),heltab2x6(:,:,4))
  call Hotf_5pt_reduction(G2H6(27),RedSet_5(22),mass5set(:,19),  & 
G1H6(146),G1H6(147),G1H6(148),G1H6(149),G1H6(150),G1H6(151),6)
  call HG1shiftOLR(G1H6(147),4,6)
  call Hotf_5pt_reduction(G2H6(28),RedSet_5(22),mass5set(:,19),  & 
G1H6(152),G1H6(153),G1H6(154),G1H6(155),G1H6(156),G1H6(157),6)
  call HG1shiftOLR(G1H6(153),4,6)
  call Hloop_AQ_V(ntryL,G2H4(4),ex4(:),G2H2(6),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(13),mass5set(:,25),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),4,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(13),mass5set(:,25),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),2,4)
  call Hloop_AQ_V(ntryL,G2H4(7),ex2(:),G2H2(7),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(8),ex3(:),G2H2(8),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(1),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(25),mass5set(:,26),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(2),mass5set(:,2),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),4,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(26),mass5set(:,27),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),4,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(2),mass5set(:,3),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),4,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(26),mass5set(:,27),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),4,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(2),mass5set(:,2),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),2,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(27),mass5set(:,27),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),2,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(2),mass5set(:,3),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),2,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(27),mass5set(:,27),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),2,4)
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(3),mass5set(:,4),  & 
G1H6(158),G1H6(159),G1H6(160),G1H6(161),G1H6(162),G1H6(163),6)
  call HG1shiftOLR(G1H6(159),8,6)
  call Hotf_5pt_reduction(G2H6(31),RedSet_5(28),mass5set(:,4),  & 
G1H6(164),G1H6(165),G1H6(166),G1H6(167),G1H6(168),G1H6(169),6)
  call HG1shiftOLR(G1H6(165),8,6)
  call Hotf_5pt_reduction(G2H6(32),RedSet_5(3),mass5set(:,5),  & 
G1H6(170),G1H6(171),G1H6(172),G1H6(173),G1H6(174),G1H6(175),6)
  call HG1shiftOLR(G1H6(171),8,6)
  call Hotf_5pt_reduction(G2H6(34),RedSet_5(28),mass5set(:,5),  & 
G1H6(176),G1H6(177),G1H6(178),G1H6(179),G1H6(180),G1H6(181),6)
  call HG1shiftOLR(G1H6(177),8,6)
  call Hloop_AQ_V(ntryL,G2H4(24),ex4(:),G2H2(9),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(26),ex4(:),G2H2(10),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(27),ex4(:),G2H2(11),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(29),ex4(:),G2H2(12),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_Z(ntryL,G2H4(30),ex4(:),G2H2(13),ngZd,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_Z(ntryL,G2H4(32),ex4(:),G2H2(14),ngZd,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(33),ex3(:),G2H2(15),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(35),ex3(:),G2H2(16),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_V(ntryL,G2H4(36),ex1(:),G2H2(17),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(39),ex1(:),G2H2(18),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(40),ex1(:),G2H2(19),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(43),ex1(:),G2H2(20),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hotf_5pt_reduction(G2H6(39),RedSet_5(7),mass5set(:,4),  & 
G1H6(182),G1H6(183),G1H6(184),G1H6(185),G1H6(186),G1H6(187),6)
  call HG1shiftOLR(G1H6(183),8,6)
  call Hotf_5pt_reduction(G2H6(41),RedSet_5(29),mass5set(:,4),  & 
G1H6(188),G1H6(189),G1H6(190),G1H6(191),G1H6(192),G1H6(193),6)
  call HG1shiftOLR(G1H6(189),8,6)
  call Hotf_5pt_reduction(G2H6(42),RedSet_5(7),mass5set(:,5),  & 
G1H6(194),G1H6(195),G1H6(196),G1H6(197),G1H6(198),G1H6(199),6)
  call HG1shiftOLR(G1H6(195),8,6)
  call Hotf_5pt_reduction(G2H6(44),RedSet_5(29),mass5set(:,5),  & 
G1H6(200),G1H6(201),G1H6(202),G1H6(203),G1H6(204),G1H6(205),6)
  call HG1shiftOLR(G1H6(201),8,6)
  call Hloop_QA_V(ntryL,G2H4(44),ex1(:),G2H2(21),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(46),ex1(:),G2H2(22),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_Z(ntryL,G2H4(47),ex1(:),G2H2(23),ngZu,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_Z(ntryL,G2H4(49),ex1(:),G2H2(24),ngZu,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_V(ntryL,G2H4(50),ex1(:),G2H2(25),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_V(ntryL,G2H4(52),ex1(:),G2H2(26),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_W(ntryL,G2H4(53),ex2(:),G2H2(27),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_W(ntryL,G2H4(55),ex2(:),G2H2(28),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(10),mass5set(:,12),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),8,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(28),mass5set(:,4),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),8,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(10),mass5set(:,13),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hotf_5pt_reduction(G2H4(61),RedSet_5(28),mass5set(:,5),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),8,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(11),mass5set(:,12),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),8,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(29),mass5set(:,4),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),8,4)
  call Hotf_5pt_reduction(G2H4(65),RedSet_5(11),mass5set(:,13),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),8,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(29),mass5set(:,5),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),8,4)
  call Hloop_AQ_V(ntryL,G2H4(68),ex4(:),G2H2(29),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_V(ntryL,G2H4(71),ex4(:),G2H2(30),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_V(ntryL,G2H4(72),ex4(:),G2H2(31),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_AQ_V(ntryL,G2H4(75),ex4(:),G2H2(32),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hotf_5pt_reduction(G2H4(76),RedSet_5(13),mass5set(:,14),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),4,4)
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(30),mass5set(:,28),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),4,4)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(13),mass5set(:,15),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),4,4)
  call Hotf_5pt_reduction(G2H4(81),RedSet_5(30),mass5set(:,28),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),4,4)
  call Hotf_5pt_reduction(G2H4(82),RedSet_5(13),mass5set(:,14),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),2,4)
  call Hotf_5pt_reduction(G2H4(84),RedSet_5(31),mass5set(:,28),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),2,4)
  call Hotf_5pt_reduction(G2H4(85),RedSet_5(13),mass5set(:,15),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),2,4)
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(31),mass5set(:,28),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),2,4)
  call Hotf_5pt_reduction(G2H6(49),RedSet_5(14),mass5set(:,16),  & 
G1H6(206),G1H6(207),G1H6(208),G1H6(209),G1H6(210),G1H6(211),6)
  call HG1shiftOLR(G1H6(207),4,6)
  call Hotf_5pt_reduction(G2H6(51),RedSet_5(30),mass5set(:,28),  & 
G1H6(212),G1H6(213),G1H6(214),G1H6(215),G1H6(216),G1H6(217),6)
  call HG1shiftOLR(G1H6(213),4,6)
  call Hloop_AQ_V(ntryL,G2H4(88),ex2(:),G2H2(33),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_AQ_V(ntryL,G2H4(91),ex2(:),G2H2(34),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_AQ_V(ntryL,G2H4(92),ex2(:),G2H2(35),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_AQ_V(ntryL,G2H4(95),ex2(:),G2H2(36),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QA_V(ntryL,G2H4(96),ex3(:),G2H2(37),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_QA_V(ntryL,G2H4(99),ex3(:),G2H2(38),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QA_V(ntryL,G2H4(100),ex3(:),G2H2(39),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QA_V(ntryL,G2H4(103),ex3(:),G2H2(40),m3h2x2(:,36),heltab2x4(:,:,36))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(164),[G1H6(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(176),[G1H6(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(188),[G1H6(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(200),[G1H6(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(151),[G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G1H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(175),[G1H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(212),[G1H6(211)])
  call Hloop_WQ_A(ntryL,G1H6(14),ex2(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(15),1,1,6)
call HGT_invQ_OLR(G1H6(15),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(15),-16,nMT,G2H6(1),n2h6(16))
  call Hloop_AW_Q(ntryL,G2H6(1),ex5(:),G2H2(41),m3h3x2(:,5),heltab2x6(:,:,6))
  call Hloop_WQ_A(ntryL,G1H6(19),ex2(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(2),n2h3(2))
  call Hloop_VA_Q(ntryL,G1H6(20),ex3(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,8))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(3),n2h3(3))
call HGT_OLR(G1H6(21),1,1,6)
call HGT_invQ_OLR(G1H6(21),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(21),-16,nMB,G2H6(2),n2h6(17))
  call Hloop_QW_A(ntryL,G2H6(2),ex5(:),G2H2(42),m3h3x2(:,6),heltab2x6(:,:,9))
  call Hloop_VA_Q(ntryL,G1H6(25),ex3(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,10))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(4),n2h3(4))
  call Hloop_UW_V(ntryL,G1H6(26),43,ex5(:),16,G2H2(43),m3h3x2(:,7),heltab2x6(:,:,11))
call HGT_OLR(G1H6(27),1,1,6)
call HGT_invQ_OLR(G1H6(27),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(27),-4,nMT,G2H6(3),n2h6(18))
  call Hloop_QA_V(ntryL,G2H6(3),ex3(:),G2H3(5),m3h2x3(:,5),heltab2x6(:,:,12))
  call Hloop_UW_V(ntryL,G1H6(31),43,ex5(:),16,G2H2(44),m3h3x2(:,8),heltab2x6(:,:,13))
  call Hloop_UW_V(ntryL,G1H6(32),43,ex5(:),16,G2H2(45),m3h3x2(:,9),heltab2x6(:,:,14))
call HGT_OLR(G1H6(33),1,1,6)
call HGT_invQ_OLR(G1H6(33),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(33),-4,nMT,G2H6(4),n2h6(19))
  call Hloop_QA_Z(ntryL,G2H6(4),ex3(:),G2H3(6),ngZu,m3h2x3(:,6),heltab2x6(:,:,15))
  call Hloop_UW_V(ntryL,G1H6(37),43,ex5(:),16,G2H2(46),m3h3x2(:,10),heltab2x6(:,:,16))
  call Hloop_VA_Q(ntryL,G1H6(38),ex1(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,17))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(7),n2h3(5))
call HGT_OLR(G1H6(39),1,1,6)
call HGT_invQ_OLR(G1H6(39),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(39),-16,0,G2H6(5),n2h6(20))
  call Hloop_QW_A(ntryL,G2H6(5),ex5(:),G2H2(47),m3h3x2(:,11),heltab2x6(:,:,18))
  call Hloop_VA_Q(ntryL,G1H6(43),ex1(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,19))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(8),n2h3(6))
  call Hloop_ZA_Q(ntryL,G1H6(44),ex1(:),G1H3(1),ngZu,m3h2x3(:,9),heltab2x6(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(9),n2h3(7))
call HGT_OLR(G1H6(45),1,1,6)
call HGT_invQ_OLR(G1H6(45),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(45),-16,0,G2H6(6),n2h6(21))
  call Hloop_QW_A(ntryL,G2H6(6),ex5(:),G2H2(48),m3h3x2(:,12),heltab2x6(:,:,21))
  call Hloop_ZA_Q(ntryL,G1H6(49),ex1(:),G1H3(1),ngZu,m3h2x3(:,10),heltab2x6(:,:,22))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(10),n2h3(8))
  call Hloop_VA_Q(ntryL,G1H6(50),ex1(:),G1H3(1),m3h2x3(:,11),heltab2x6(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(11),n2h3(9))
call HGT_OLR(G1H6(51),1,1,6)
call HGT_invQ_OLR(G1H6(51),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(51),-16,0,G2H6(7),n2h6(22))
  call Hloop_QW_A(ntryL,G2H6(7),ex5(:),G2H2(49),m3h3x2(:,13),heltab2x6(:,:,24))
  call Hloop_VA_Q(ntryL,G1H6(55),ex1(:),G1H3(1),m3h2x3(:,12),heltab2x6(:,:,25))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(12),n2h3(10))
  call Hloop_VQ_A(ntryL,G1H6(56),ex4(:),G1H3(1),m3h2x3(:,13),heltab2x6(:,:,26))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(13),n2h3(11))
call HGT_OLR(G1H6(57),1,1,6)
call HGT_invQ_OLR(G1H6(57),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(57),-16,0,G2H6(8),n2h6(23))
  call Hloop_AW_Q(ntryL,G2H6(8),ex5(:),G2H2(50),m3h3x2(:,14),heltab2x6(:,:,27))
  call Hloop_VQ_A(ntryL,G1H6(61),ex4(:),G1H3(1),m3h2x3(:,14),heltab2x6(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(14),n2h3(12))
  call Hloop_VQ_A(ntryL,G1H6(62),ex4(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,29))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(15),n2h3(13))
call HGT_OLR(G1H6(63),1,1,6)
call HGT_invQ_OLR(G1H6(63),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(63),-16,0,G2H6(9),n2h6(24))
  call Hloop_AW_Q(ntryL,G2H6(9),ex5(:),G2H2(51),m3h3x2(:,15),heltab2x6(:,:,30))
  call Hloop_VQ_A(ntryL,G1H6(67),ex4(:),G1H3(1),m3h2x3(:,16),heltab2x6(:,:,31))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(16),n2h3(14))
  call Hloop_ZQ_A(ntryL,G1H6(68),ex4(:),G1H3(1),ngZd,m3h2x3(:,17),heltab2x6(:,:,32))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(17),n2h3(15))
call HGT_OLR(G1H6(69),1,1,6)
call HGT_invQ_OLR(G1H6(69),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(69),-16,0,G2H6(10),n2h6(25))
  call Hloop_AW_Q(ntryL,G2H6(10),ex5(:),G2H2(52),m3h3x2(:,16),heltab2x6(:,:,33))
  call Hloop_ZQ_A(ntryL,G1H6(73),ex4(:),G1H3(1),ngZd,m3h2x3(:,18),heltab2x6(:,:,34))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(18),n2h3(16))
  call Hloop_UV_W(ntryL,G1H6(74),39,ex5(:),16,G2H2(53),m3h3x2(:,17),heltab2x6(:,:,35))
call HGT_OLR(G1H6(75),1,1,6)
call HGT_invQ_OLR(G1H6(75),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(75),-8,0,G2H6(11),n2h6(26))
  call Hloop_AQ_W(ntryL,G2H6(11),ex4(:),G2H3(19),m3h2x3(:,19),heltab2x6(:,:,36))
  call Hloop_UV_W(ntryL,G1H6(79),39,ex5(:),16,G2H2(54),m3h3x2(:,18),heltab2x6(:,:,37))
  call Hloop_UV_W(ntryL,G1H6(80),39,ex5(:),16,G2H2(55),m3h3x2(:,19),heltab2x6(:,:,38))
call HGT_OLR(G1H6(81),1,1,6)
call HGT_invQ_OLR(G1H6(81),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(81),-8,0,G2H6(12),n2h6(27))
  call Hloop_AQ_W(ntryL,G2H6(12),ex4(:),G2H3(20),m3h2x3(:,20),heltab2x6(:,:,39))
  call Hloop_UV_W(ntryL,G1H6(85),39,ex5(:),16,G2H2(56),m3h3x2(:,20),heltab2x6(:,:,40))
  call Hloop_WQ_A(ntryL,G1H6(86),ex2(:),G1H3(1),m3h2x3(:,21),heltab2x6(:,:,41))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(21),n2h3(17))
call HGT_OLR(G1H6(87),1,1,6)
call HGT_invQ_OLR(G1H6(87),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(87),-16,nMT,G2H6(13),n2h6(28))
  call Hloop_AW_Q(ntryL,G2H6(13),ex5(:),G2H2(57),m3h3x2(:,21),heltab2x6(:,:,42))
  call Hloop_WQ_A(ntryL,G1H6(91),ex2(:),G1H3(1),m3h2x3(:,22),heltab2x6(:,:,43))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(22),n2h3(18))
  call Hloop_VA_Q(ntryL,G1H6(92),ex3(:),G1H3(1),m3h2x3(:,23),heltab2x6(:,:,44))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(23),n2h3(19))
call HGT_OLR(G1H6(93),1,1,6)
call HGT_invQ_OLR(G1H6(93),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(93),-16,nMB,G2H6(14),n2h6(29))
  call Hloop_QW_A(ntryL,G2H6(14),ex5(:),G2H2(58),m3h3x2(:,22),heltab2x6(:,:,45))
  call Hloop_VA_Q(ntryL,G1H6(97),ex3(:),G1H3(1),m3h2x3(:,24),heltab2x6(:,:,46))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(24),n2h3(20))
  call Hloop_VA_Q(ntryL,G1H6(98),ex1(:),G1H3(1),m3h2x3(:,25),heltab2x6(:,:,47))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(25),n2h3(21))
call HGT_OLR(G1H6(99),1,1,6)
call HGT_invQ_OLR(G1H6(99),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(99),-16,0,G2H6(15),n2h6(30))
  call Hloop_QW_A(ntryL,G2H6(15),ex5(:),G2H2(59),m3h3x2(:,23),heltab2x6(:,:,48))
  call Hloop_VA_Q(ntryL,G1H6(103),ex1(:),G1H3(1),m3h2x3(:,26),heltab2x6(:,:,49))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(26),n2h3(22))
  call Hloop_ZA_Q(ntryL,G1H6(104),ex1(:),G1H3(1),ngZu,m3h2x3(:,27),heltab2x6(:,:,50))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(27),n2h3(23))
call HGT_OLR(G1H6(105),1,1,6)
call HGT_invQ_OLR(G1H6(105),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(105),-16,0,G2H6(16),n2h6(31))
  call Hloop_QW_A(ntryL,G2H6(16),ex5(:),G2H2(60),m3h3x2(:,24),heltab2x6(:,:,51))
  call Hloop_ZA_Q(ntryL,G1H6(109),ex1(:),G1H3(1),ngZu,m3h2x3(:,28),heltab2x6(:,:,52))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(28),n2h3(24))
  call Hloop_VA_Q(ntryL,G1H6(110),ex1(:),G1H3(1),m3h2x3(:,29),heltab2x6(:,:,53))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(29),n2h3(25))
call HGT_OLR(G1H6(111),1,1,6)
call HGT_invQ_OLR(G1H6(111),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(111),-16,0,G2H6(17),n2h6(32))
  call Hloop_QW_A(ntryL,G2H6(17),ex5(:),G2H2(61),m3h3x2(:,25),heltab2x6(:,:,54))
  call Hloop_VA_Q(ntryL,G1H6(115),ex1(:),G1H3(1),m3h2x3(:,30),heltab2x6(:,:,55))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(30),n2h3(26))
  call Hloop_VQ_A(ntryL,G1H6(116),ex4(:),G1H3(1),m3h2x3(:,31),heltab2x6(:,:,56))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(31),n2h3(27))
call HGT_OLR(G1H6(117),1,1,6)
call HGT_invQ_OLR(G1H6(117),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(117),-16,0,G2H6(18),n2h6(33))
  call Hloop_AW_Q(ntryL,G2H6(18),ex5(:),G2H2(62),m3h3x2(:,26),heltab2x6(:,:,57))
  call Hloop_VQ_A(ntryL,G1H6(121),ex4(:),G1H3(1),m3h2x3(:,32),heltab2x6(:,:,58))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(32),n2h3(28))
  call Hloop_VQ_A(ntryL,G1H6(122),ex4(:),G1H3(1),m3h2x3(:,33),heltab2x6(:,:,59))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(33),n2h3(29))
call HGT_OLR(G1H6(123),1,1,6)
call HGT_invQ_OLR(G1H6(123),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(123),-16,0,G2H6(19),n2h6(34))
  call Hloop_AW_Q(ntryL,G2H6(19),ex5(:),G2H2(63),m3h3x2(:,27),heltab2x6(:,:,60))
  call Hloop_VQ_A(ntryL,G1H6(127),ex4(:),G1H3(1),m3h2x3(:,34),heltab2x6(:,:,61))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(34),n2h3(30))
  call Hloop_ZQ_A(ntryL,G1H6(128),ex4(:),G1H3(1),ngZd,m3h2x3(:,35),heltab2x6(:,:,62))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(35),n2h3(31))
call HGT_OLR(G1H6(129),1,1,6)
call HGT_invQ_OLR(G1H6(129),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(129),-16,0,G2H6(20),n2h6(35))
  call Hloop_AW_Q(ntryL,G2H6(20),ex5(:),G2H2(64),m3h3x2(:,28),heltab2x6(:,:,63))
  call Hloop_ZQ_A(ntryL,G1H6(133),ex4(:),G1H3(1),ngZd,m3h2x3(:,36),heltab2x6(:,:,64))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(36),n2h3(32))
  call Hloop_UV_W(ntryL,G1H6(134),39,ex5(:),16,G2H2(65),m3h3x2(:,29),heltab2x6(:,:,65))
call HGT_OLR(G1H6(135),1,1,6)
call HGT_invQ_OLR(G1H6(135),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(135),-8,0,G2H6(21),n2h6(36))
  call Hloop_AQ_W(ntryL,G2H6(21),ex4(:),G2H3(37),m3h2x3(:,37),heltab2x6(:,:,66))
  call Hloop_UV_W(ntryL,G1H6(139),39,ex5(:),16,G2H2(66),m3h3x2(:,30),heltab2x6(:,:,67))
  call Hloop_UV_W(ntryL,G1H6(140),39,ex5(:),16,G2H2(67),m3h3x2(:,31),heltab2x6(:,:,68))
call HGT_OLR(G1H6(141),1,1,6)
call HGT_invQ_OLR(G1H6(141),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(141),-8,0,G2H6(22),n2h6(37))
  call Hloop_AQ_W(ntryL,G2H6(22),ex4(:),G2H3(38),m3h2x3(:,38),heltab2x6(:,:,69))
  call Hloop_UV_W(ntryL,G1H6(145),39,ex5(:),16,G2H2(68),m3h3x2(:,32),heltab2x6(:,:,70))
  call Hloop_WA_Q(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(69),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(2),ex4(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_WA_Q(ntryL,G1H4(6),ex1(:),G1H2(2),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(2),55,0,G2H2(70),n2h2(2))
  call Hloop_WA_Q(ntryL,G1H4(7),ex1(:),G1H2(2),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(2),55,0,G2H2(71),n2h2(3))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(8),ex4(:),G1H2(2),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_WA_Q(ntryL,G1H4(12),ex1(:),G1H2(3),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(3),55,0,G2H2(72),n2h2(4))
  call Hloop_UW_V(ntryL,G1H6(146),43,ex5(:),16,G2H2(73),m3h3x2(:,33),heltab2x6(:,:,71))
call HGT_OLR(G1H6(147),1,1,6)
call HGT_invQ_OLR(G1H6(147),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(147),-4,nMT,G2H6(23),n2h6(38))
  call Hloop_QA_V(ntryL,G2H6(23),ex3(:),G2H3(39),m3h2x3(:,39),heltab2x6(:,:,72))
  call Hloop_UW_V(ntryL,G1H6(151),43,ex5(:),16,G2H2(74),m3h3x2(:,34),heltab2x6(:,:,73))
  call Hloop_UW_V(ntryL,G1H6(152),43,ex5(:),16,G2H2(75),m3h3x2(:,35),heltab2x6(:,:,74))
call HGT_OLR(G1H6(153),1,1,6)
call HGT_invQ_OLR(G1H6(153),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(153),-4,nMT,G2H6(24),n2h6(39))
  call Hloop_QA_Z(ntryL,G2H6(24),ex3(:),G2H3(40),ngZu,m3h2x3(:,40),heltab2x6(:,:,75))
  call Hloop_UW_V(ntryL,G1H6(157),43,ex5(:),16,G2H2(76),m3h3x2(:,36),heltab2x6(:,:,76))
  call Hloop_SQ_A(ntryL,G1H4(13),ex2(:),G1H2(3),ngH,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(3),59,nMT,G2H2(77),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex3(:),G1H2(3),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_SQ_A(ntryL,G1H4(18),ex2(:),G1H2(4),ngH,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(4),59,nMT,G2H2(78),n2h2(6))
  call Hloop_SA_Q(ntryL,G1H4(19),ex3(:),G1H2(4),ngH,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(4),61,nMT,G2H2(79),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(20),ex2(:),G1H2(4),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_SA_Q(ntryL,G1H4(24),ex3(:),G1H2(5),ngH,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(5),61,nMT,G2H2(80),n2h2(8))
  call Hloop_WA_Q(ntryL,G1H4(25),ex1(:),G1H2(5),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(5),55,0,G2H2(81),n2h2(9))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(26),ex4(:),G1H2(5),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_WA_Q(ntryL,G1H4(31),ex1(:),G1H2(6),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(6),55,0,G2H2(82),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(32),ex4(:),G1H2(6),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_WA_Q(ntryL,G1H4(36),ex1(:),G1H2(7),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(7),55,0,G2H2(83),n2h2(11))
  call Hloop_VQ_A(ntryL,G1H4(37),ex2(:),G1H2(7),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(7),59,nMT,G2H2(84),n2h2(12))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(38),ex3(:),G1H2(7),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_VQ_A(ntryL,G1H4(43),ex2(:),G1H2(8),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(8),59,nMT,G2H2(85),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(44),ex3(:),G1H2(8),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_VQ_A(ntryL,G1H4(48),ex2(:),G1H2(9),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(9),59,nMT,G2H2(86),n2h2(14))
  call Hloop_ZQ_A(ntryL,G1H4(49),ex2(:),G1H2(9),ngZu,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(9),59,nMT,G2H2(87),n2h2(15))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(50),ex3(:),G1H2(9),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_ZQ_A(ntryL,G1H4(55),ex2(:),G1H2(10),ngZu,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(10),59,nMT,G2H2(88),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(56),ex3(:),G1H2(10),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_ZQ_A(ntryL,G1H4(60),ex2(:),G1H2(11),ngZu,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(11),59,nMT,G2H2(89),n2h2(17))
  call Hloop_VA_Q(ntryL,G1H4(61),ex3(:),G1H2(11),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(11),61,nMT,G2H2(90),n2h2(18))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(62),ex2(:),G1H2(11),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_VA_Q(ntryL,G1H4(67),ex3(:),G1H2(12),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(12),61,nMT,G2H2(91),n2h2(19))
call HGT_raise_alpha_OLR(G1H4(68),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(68),ex2(:),G1H2(12),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_VA_Q(ntryL,G1H4(72),ex3(:),G1H2(13),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(13),61,nMT,G2H2(92),n2h2(20))
  call Hloop_ZA_Q(ntryL,G1H4(73),ex3(:),G1H2(13),ngZu,m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(13),61,nMT,G2H2(93),n2h2(21))
call HGT_raise_alpha_OLR(G1H4(74),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(74),ex2(:),G1H2(13),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_ZA_Q(ntryL,G1H4(79),ex3(:),G1H2(14),ngZu,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(14),61,nMT,G2H2(94),n2h2(22))
call HGT_raise_alpha_OLR(G1H4(80),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(80),ex2(:),G1H2(14),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_ZA_Q(ntryL,G1H4(84),ex3(:),G1H2(15),ngZu,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(15),61,nMT,G2H2(95),n2h2(23))
  call Hloop_AW_Q(ntryL,G1H6(158),ex5(:),G1H2(15),m3h3x2(:,37),heltab2x6(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(96),n2h2(24))
call HGT_raise_alpha_OLR(G1H6(159),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(159),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(159),ex4(:),G1H3(1),m3h2x3(:,41),heltab2x6(:,:,78))
  call Hloop_AW_Q(ntryL,G1H6(164),ex5(:),G1H2(15),m3h3x2(:,38),heltab2x6(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(97),n2h2(25))
call HGT_raise_alpha_OLR(G1H6(165),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(165),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(165),ex4(:),G1H3(2),m3h2x3(:,42),heltab2x6(:,:,80))
  call Hloop_AW_Q(ntryL,G1H6(169),ex5(:),G1H2(15),m3h3x2(:,39),heltab2x6(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(98),n2h2(26))
  call Hloop_AW_Q(ntryL,G1H6(170),ex5(:),G1H2(15),m3h3x2(:,40),heltab2x6(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(99),n2h2(27))
call HGT_raise_alpha_OLR(G1H6(171),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(171),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(171),ex4(:),G1H3(3),m3h2x3(:,43),heltab2x6(:,:,83))
  call Hloop_AW_Q(ntryL,G1H6(176),ex5(:),G1H2(15),m3h3x2(:,41),heltab2x6(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(100),n2h2(28))
call HGT_raise_alpha_OLR(G1H6(177),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(177),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(177),ex4(:),G1H3(4),m3h2x3(:,44),heltab2x6(:,:,85))
  call Hloop_AW_Q(ntryL,G1H6(181),ex5(:),G1H2(15),m3h3x2(:,42),heltab2x6(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(101),n2h2(29))
  call Hloop_AW_Q(ntryL,G1H6(182),ex5(:),G1H2(15),m3h3x2(:,43),heltab2x6(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(102),n2h2(30))
call HGT_raise_alpha_OLR(G1H6(183),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(183),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(183),ex4(:),G1H3(5),m3h2x3(:,45),heltab2x6(:,:,88))
  call Hloop_AW_Q(ntryL,G1H6(188),ex5(:),G1H2(15),m3h3x2(:,44),heltab2x6(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(103),n2h2(31))
call HGT_raise_alpha_OLR(G1H6(189),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(189),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(189),ex4(:),G1H3(6),m3h2x3(:,46),heltab2x6(:,:,90))
  call Hloop_AW_Q(ntryL,G1H6(193),ex5(:),G1H2(15),m3h3x2(:,45),heltab2x6(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(104),n2h2(32))
  call Hloop_AW_Q(ntryL,G1H6(194),ex5(:),G1H2(15),m3h3x2(:,46),heltab2x6(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(105),n2h2(33))
call HGT_raise_alpha_OLR(G1H6(195),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(195),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(195),ex4(:),G1H3(7),m3h2x3(:,47),heltab2x6(:,:,93))
  call Hloop_AW_Q(ntryL,G1H6(200),ex5(:),G1H2(15),m3h3x2(:,47),heltab2x6(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(106),n2h2(34))
call HGT_raise_alpha_OLR(G1H6(201),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(201),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(201),ex4(:),G1H3(8),m3h2x3(:,48),heltab2x6(:,:,95))
  call Hloop_AW_Q(ntryL,G1H6(205),ex5(:),G1H2(15),m3h3x2(:,48),heltab2x6(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(107),n2h2(35))
  call Hloop_WA_Q(ntryL,G1H4(85),ex1(:),G1H2(15),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(15),55,0,G2H2(108),n2h2(36))
call HGT_raise_alpha_OLR(G1H4(86),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(86),ex4(:),G1H2(15),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_WA_Q(ntryL,G1H4(91),ex1(:),G1H2(16),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(16),55,0,G2H2(109),n2h2(37))
call HGT_raise_alpha_OLR(G1H4(92),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(92),ex4(:),G1H2(16),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_WA_Q(ntryL,G1H4(96),ex1(:),G1H2(17),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(17),55,0,G2H2(110),n2h2(38))
  call Hloop_WA_Q(ntryL,G1H4(97),ex1(:),G1H2(17),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(17),55,0,G2H2(111),n2h2(39))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(98),ex4(:),G1H2(17),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_WA_Q(ntryL,G1H4(103),ex1(:),G1H2(18),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(18),55,0,G2H2(112),n2h2(40))
call HGT_raise_alpha_OLR(G1H4(104),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(104),ex4(:),G1H2(18),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_WA_Q(ntryL,G1H4(108),ex1(:),G1H2(19),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(19),55,0,G2H2(113),n2h2(41))
  call Hloop_WA_Q(ntryL,G1H4(109),ex1(:),G1H2(19),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(19),55,0,G2H2(114),n2h2(42))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(110),ex4(:),G1H2(19),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_WA_Q(ntryL,G1H4(115),ex1(:),G1H2(20),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(20),55,0,G2H2(115),n2h2(43))
call HGT_raise_alpha_OLR(G1H4(116),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(116),ex4(:),G1H2(20),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_WA_Q(ntryL,G1H4(120),ex1(:),G1H2(21),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(21),55,0,G2H2(116),n2h2(44))
  call Hloop_WA_Q(ntryL,G1H4(121),ex1(:),G1H2(21),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(21),55,0,G2H2(117),n2h2(45))
call HGT_raise_alpha_OLR(G1H4(122),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(122),ex4(:),G1H2(21),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_WA_Q(ntryL,G1H4(127),ex1(:),G1H2(22),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(22),55,0,G2H2(118),n2h2(46))
call HGT_raise_alpha_OLR(G1H4(128),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(128),ex4(:),G1H2(22),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_WA_Q(ntryL,G1H4(132),ex1(:),G1H2(23),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(23),55,0,G2H2(119),n2h2(47))
  call Hloop_VQ_A(ntryL,G1H4(133),ex2(:),G1H2(23),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(23),59,nMT,G2H2(120),n2h2(48))
call HGT_raise_alpha_OLR(G1H4(134),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(134),ex3(:),G1H2(23),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_VQ_A(ntryL,G1H4(139),ex2(:),G1H2(24),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(24),59,nMT,G2H2(121),n2h2(49))
call HGT_raise_alpha_OLR(G1H4(140),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(140),ex3(:),G1H2(24),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_VQ_A(ntryL,G1H4(144),ex2(:),G1H2(25),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(25),59,nMT,G2H2(122),n2h2(50))
  call Hloop_ZQ_A(ntryL,G1H4(145),ex2(:),G1H2(25),ngZu,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(25),59,nMT,G2H2(123),n2h2(51))
call HGT_raise_alpha_OLR(G1H4(146),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(146),ex3(:),G1H2(25),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_ZQ_A(ntryL,G1H4(151),ex2(:),G1H2(26),ngZu,m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(26),59,nMT,G2H2(124),n2h2(52))
call HGT_raise_alpha_OLR(G1H4(152),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(152),ex3(:),G1H2(26),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_ZQ_A(ntryL,G1H4(156),ex2(:),G1H2(27),ngZu,m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(27),59,nMT,G2H2(125),n2h2(53))
  call Hloop_VA_Q(ntryL,G1H4(157),ex3(:),G1H2(27),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(27),61,nMT,G2H2(126),n2h2(54))
call HGT_raise_alpha_OLR(G1H4(158),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(158),ex2(:),G1H2(27),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_VA_Q(ntryL,G1H4(163),ex3(:),G1H2(28),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(28),61,nMT,G2H2(127),n2h2(55))
call HGT_raise_alpha_OLR(G1H4(164),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(164),ex2(:),G1H2(28),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_VA_Q(ntryL,G1H4(168),ex3(:),G1H2(29),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(29),61,nMT,G2H2(128),n2h2(56))
  call Hloop_ZA_Q(ntryL,G1H4(169),ex3(:),G1H2(29),ngZu,m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(29),61,nMT,G2H2(129),n2h2(57))
call HGT_raise_alpha_OLR(G1H4(170),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(170),ex2(:),G1H2(29),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_ZA_Q(ntryL,G1H4(175),ex3(:),G1H2(30),ngZu,m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(30),61,nMT,G2H2(130),n2h2(58))
call HGT_raise_alpha_OLR(G1H4(176),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(176),ex2(:),G1H2(30),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_ZA_Q(ntryL,G1H4(180),ex3(:),G1H2(31),ngZu,m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(31),61,nMT,G2H2(131),n2h2(59))
  call Hloop_QW_A(ntryL,G1H6(206),ex5(:),G1H2(31),m3h3x2(:,49),heltab2x6(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(31),59,nMT,G2H2(132),n2h2(60))
call HGT_raise_alpha_OLR(G1H6(207),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(207),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(207),ex3(:),G1H3(9),m3h2x3(:,49),heltab2x6(:,:,98))
  call Hloop_QW_A(ntryL,G1H6(212),ex5(:),G1H2(31),m3h3x2(:,50),heltab2x6(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(31),59,nMT,G2H2(133),n2h2(61))
call HGT_raise_alpha_OLR(G1H6(213),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(213),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(213),ex3(:),G1H3(10),m3h2x3(:,50),heltab2x6(:,:,100))
  call Hloop_QW_A(ntryL,G1H6(217),ex5(:),G1H2(31),m3h3x2(:,51),heltab2x6(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(31),59,nMT,G2H2(134),n2h2(62))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(18),mass5set(:,19),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),4,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(20),mass5set(:,29),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(6),mass5set(:,30),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),4,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(24),mass5set(:,29),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(22),mass5set(:,19),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),4,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(12),mass5set(:,30),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),4,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(15),mass5set(:,31),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(16),mass5set(:,31),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(4),mass5set(:,6),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),4,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(4),mass5set(:,7),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),4,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(4),mass5set(:,6),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),4,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(5),mass5set(:,8),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),8,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(6),mass5set(:,9),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),4,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(6),mass5set(:,10),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),4,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(8),mass5set(:,6),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),4,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(8),mass5set(:,6),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),4,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(8),mass5set(:,7),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),4,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(9),mass5set(:,11),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(12),mass5set(:,9),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),4,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(12),mass5set(:,10),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),4,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(15),mass5set(:,17),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),8,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(15),mass5set(:,18),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),8,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(16),mass5set(:,17),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),8,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(16),mass5set(:,18),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),8,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(17),mass5set(:,19),  & 
G1H3(11),G1H3(12),G1H3(13),G1H3(14),G1H3(15),G1H3(16),3)
  call HG1shiftOLR(G1H3(12),16,3)
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(18),mass5set(:,20),  & 
G1H3(17),G1H3(18),G1H3(19),G1H3(20),G1H3(21),G1H3(22),3)
  call HG1shiftOLR(G1H3(18),16,3)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(18),mass5set(:,19),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),4,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(18),mass5set(:,19),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),4,2)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(19),mass5set(:,21),  & 
G1H3(23),G1H3(24),G1H3(25),G1H3(26),G1H3(27),G1H3(28),3)
  call HG1shiftOLR(G1H3(24),16,3)
  call Hotf_5pt_reduction(G2H3(9),RedSet_5(19),mass5set(:,22),  & 
G1H3(29),G1H3(30),G1H3(31),G1H3(32),G1H3(33),G1H3(34),3)
  call HG1shiftOLR(G1H3(30),16,3)
  call Hotf_5pt_reduction(G2H3(11),RedSet_5(19),mass5set(:,23),  & 
G1H3(35),G1H3(36),G1H3(37),G1H3(38),G1H3(39),G1H3(40),3)
  call HG1shiftOLR(G1H3(36),16,3)
  call Hotf_5pt_reduction(G2H3(13),RedSet_5(20),mass5set(:,21),  & 
G1H3(41),G1H3(42),G1H3(43),G1H3(44),G1H3(45),G1H3(46),3)
  call HG1shiftOLR(G1H3(42),16,3)
  call Hotf_5pt_reduction(G2H3(15),RedSet_5(20),mass5set(:,23),  & 
G1H3(47),G1H3(48),G1H3(49),G1H3(50),G1H3(51),G1H3(52),3)
  call HG1shiftOLR(G1H3(48),16,3)
  call Hotf_5pt_reduction(G2H3(17),RedSet_5(20),mass5set(:,22),  & 
G1H3(53),G1H3(54),G1H3(55),G1H3(56),G1H3(57),G1H3(58),3)
  call HG1shiftOLR(G1H3(54),16,3)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(20),mass5set(:,21),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(188),8,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(20),mass5set(:,22),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),8,2)
  call Hotf_5pt_reduction(G2H3(21),RedSet_5(21),mass5set(:,19),  & 
G1H3(59),G1H3(60),G1H3(61),G1H3(62),G1H3(63),G1H3(64),3)
  call HG1shiftOLR(G1H3(60),16,3)
  call Hotf_5pt_reduction(G2H3(23),RedSet_5(22),mass5set(:,20),  & 
G1H3(65),G1H3(66),G1H3(67),G1H3(68),G1H3(69),G1H3(70),3)
  call HG1shiftOLR(G1H3(66),16,3)
  call Hotf_5pt_reduction(G2H3(25),RedSet_5(23),mass5set(:,21),  & 
G1H3(71),G1H3(72),G1H3(73),G1H3(74),G1H3(75),G1H3(76),3)
  call HG1shiftOLR(G1H3(72),16,3)
  call Hotf_5pt_reduction(G2H3(27),RedSet_5(23),mass5set(:,22),  & 
G1H3(77),G1H3(78),G1H3(79),G1H3(80),G1H3(81),G1H3(82),3)
  call HG1shiftOLR(G1H3(78),16,3)
  call Hotf_5pt_reduction(G2H3(29),RedSet_5(23),mass5set(:,23),  & 
G1H3(83),G1H3(84),G1H3(85),G1H3(86),G1H3(87),G1H3(88),3)
  call HG1shiftOLR(G1H3(84),16,3)
  call Hotf_5pt_reduction(G2H3(31),RedSet_5(24),mass5set(:,21),  & 
G1H3(89),G1H3(90),G1H3(91),G1H3(92),G1H3(93),G1H3(94),3)
  call HG1shiftOLR(G1H3(90),16,3)
  call Hotf_5pt_reduction(G2H3(33),RedSet_5(24),mass5set(:,23),  & 
G1H3(95),G1H3(96),G1H3(97),G1H3(98),G1H3(99),G1H3(100),3)
  call HG1shiftOLR(G1H3(96),16,3)
  call Hotf_5pt_reduction(G2H3(35),RedSet_5(24),mass5set(:,22),  & 
G1H3(101),G1H3(102),G1H3(103),G1H3(104),G1H3(105),G1H3(106),3)
  call HG1shiftOLR(G1H3(102),16,3)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(24),mass5set(:,21),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),8,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(24),mass5set(:,22),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),8,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(69),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(71),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(22),mass5set(:,19),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),4,2)
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(22),mass5set(:,19),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(77),ex3(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(79),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(81),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(84),ex3(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(87),ex3(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(90),ex2(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(93),ex2(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(96),ex4(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(99),ex4(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(102),ex4(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(105),ex4(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(108),ex4(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(111),ex4(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(114),ex4(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(117),ex4(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(120),ex3(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(123),ex3(:),G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(126),ex2(:),G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(129),ex2(:),G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(132),ex3(:),G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hloop_SA_Q(ntryL,G1H2(31),ex3(:),G1H1(1),ngH,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(23),n2h1(1))
  call Hloop_SA_Q(ntryL,G1H2(32),ex3(:),G1H1(1),ngH,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(24),n2h1(2))
  call Hloop_WQ_A(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(3))
  call Hloop_WQ_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(26),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(43),ex3(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(27),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(28),n2h1(6))
  call Hloop_WQ_A(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(7))
  call Hloop_WQ_A(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(30),n2h1(8))
  call Hloop_SA_Q(ntryL,G1H2(55),ex3(:),G1H1(1),ngH,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(31),n2h1(9))
  call Hloop_SA_Q(ntryL,G1H2(56),ex3(:),G1H1(1),ngH,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(32),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(61),ex3(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(33),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(62),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(34),n2h1(12))
  call Hloop_VQ_A(ntryL,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(13))
  call Hloop_VQ_A(ntryL,G1H2(68),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(36),n2h1(14))
  call Hloop_VQ_A(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(38),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(79),ex3(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(39),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(80),ex3(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(40),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(85),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(41),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(86),ex3(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(42),n2h1(20))
  call Hloop_ZA_Q(ntryL,G1H2(91),ex3(:),G1H1(1),ngZu,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(43),n2h1(21))
  call Hloop_ZA_Q(ntryL,G1H2(92),ex3(:),G1H1(1),ngZu,m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(44),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H2(97),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(46),n2h1(24))
  call Hloop_VA_Q(ntryL,G1H2(103),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(47),n2h1(25))
  call Hloop_VA_Q(ntryL,G1H2(104),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(48),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H2(109),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(49),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(110),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(50),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(115),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(51),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(116),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(52),n2h1(30))
  call Hloop_ZA_Q(ntryL,G1H2(121),ex3(:),G1H1(1),ngZu,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(53),n2h1(31))
  call Hloop_ZA_Q(ntryL,G1H2(122),ex3(:),G1H1(1),ngZu,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(54),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(55),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(128),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(56),n2h1(34))
  call Hloop_WQ_A(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(35))
  call Hloop_WQ_A(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(58),n2h1(36))
  call Hloop_VA_Q(ntryL,G1H2(139),ex3(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(59),n2h1(37))
  call Hloop_VA_Q(ntryL,G1H2(140),ex3(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(60),n2h1(38))
  call Hloop_VA_Q(ntryL,G1H2(145),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(61),n2h1(39))
  call Hloop_VA_Q(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(62),n2h1(40))
  call Hloop_VQ_A(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(41))
  call Hloop_VQ_A(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(64),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H2(157),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(158),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(66),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(164),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(68),n2h1(46))
  call Hloop_VQ_A(ntryL,G1H2(169),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(47))
  call Hloop_VQ_A(ntryL,G1H2(170),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(70),n2h1(48))
  call Hloop_QW_A(ntryL,G1H3(11),ex5(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(71),n2h1(49))
  call Hloop_QW_A(ntryL,G1H3(12),ex5(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(72),n2h1(50))
  call Hloop_AW_Q(ntryL,G1H3(17),ex5(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(73),n2h1(51))
  call Hloop_AW_Q(ntryL,G1H3(18),ex5(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(74),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(175),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(75),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H2(176),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(76),n2h1(54))
  call Hloop_ZA_Q(ntryL,G1H2(181),ex3(:),G1H1(1),ngZu,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(77),n2h1(55))
  call Hloop_ZA_Q(ntryL,G1H2(182),ex3(:),G1H1(1),ngZu,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(78),n2h1(56))
  call Hloop_AW_Q(ntryL,G1H3(23),ex5(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(57))
  call Hloop_AW_Q(ntryL,G1H3(24),ex5(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(80),n2h1(58))
  call Hloop_AW_Q(ntryL,G1H3(29),ex5(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(59))
  call Hloop_AW_Q(ntryL,G1H3(30),ex5(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(82),n2h1(60))
  call Hloop_AW_Q(ntryL,G1H3(35),ex5(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(61))
  call Hloop_AW_Q(ntryL,G1H3(36),ex5(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(84),n2h1(62))
  call Hloop_QW_A(ntryL,G1H3(41),ex5(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(63))
  call Hloop_QW_A(ntryL,G1H3(42),ex5(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(86),n2h1(64))
  call Hloop_QW_A(ntryL,G1H3(47),ex5(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(65))
  call Hloop_QW_A(ntryL,G1H3(48),ex5(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(88),n2h1(66))
  call Hloop_QW_A(ntryL,G1H3(53),ex5(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(67))
  call Hloop_QW_A(ntryL,G1H3(54),ex5(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(90),n2h1(68))
  call Hloop_WQ_A(ntryL,G1H2(187),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(69))
  call Hloop_WQ_A(ntryL,G1H2(188),ex4(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(92),n2h1(70))
  call Hloop_WQ_A(ntryL,G1H2(193),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(71))
  call Hloop_WQ_A(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(94),n2h1(72))
  call Hloop_QW_A(ntryL,G1H3(59),ex5(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(95),n2h1(73))
  call Hloop_QW_A(ntryL,G1H3(60),ex5(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(96),n2h1(74))
  call Hloop_AW_Q(ntryL,G1H3(65),ex5(:),G1H1(1),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(97),n2h1(75))
  call Hloop_AW_Q(ntryL,G1H3(66),ex5(:),G1H1(1),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(98),n2h1(76))
  call Hloop_AW_Q(ntryL,G1H3(71),ex5(:),G1H1(1),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(77))
  call Hloop_AW_Q(ntryL,G1H3(72),ex5(:),G1H1(1),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(100),n2h1(78))
  call Hloop_AW_Q(ntryL,G1H3(77),ex5(:),G1H1(1),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(79))
  call Hloop_AW_Q(ntryL,G1H3(78),ex5(:),G1H1(1),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(102),n2h1(80))
  call Hloop_AW_Q(ntryL,G1H3(83),ex5(:),G1H1(1),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(81))
  call Hloop_AW_Q(ntryL,G1H3(84),ex5(:),G1H1(1),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(104),n2h1(82))
  call Hloop_QW_A(ntryL,G1H3(89),ex5(:),G1H1(1),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(83))
  call Hloop_QW_A(ntryL,G1H3(90),ex5(:),G1H1(1),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(106),n2h1(84))
  call Hloop_QW_A(ntryL,G1H3(95),ex5(:),G1H1(1),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(85))
  call Hloop_QW_A(ntryL,G1H3(96),ex5(:),G1H1(1),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(108),n2h1(86))
  call Hloop_QW_A(ntryL,G1H3(101),ex5(:),G1H1(1),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(87))
  call Hloop_QW_A(ntryL,G1H3(102),ex5(:),G1H1(1),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(110),n2h1(88))
  call Hloop_WQ_A(ntryL,G1H2(199),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(89))
  call Hloop_WQ_A(ntryL,G1H2(200),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(112),n2h1(90))
  call Hloop_WQ_A(ntryL,G1H2(205),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(91))
  call Hloop_WQ_A(ntryL,G1H2(206),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(114),n2h1(92))
  call Hloop_VA_Q(ntryL,G1H2(211),ex3(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(115),n2h1(93))
  call Hloop_VA_Q(ntryL,G1H2(212),ex3(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(116),n2h1(94))
  call Hloop_ZA_Q(ntryL,G1H2(217),ex3(:),G1H1(1),ngZu,m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(117),n2h1(95))
  call Hloop_ZA_Q(ntryL,G1H2(218),ex3(:),G1H1(1),ngZu,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(118),n2h1(96))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(10),mass5set(:,24),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(11),mass5set(:,24),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(13),mass5set(:,25),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),4)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(13),mass5set(:,25),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),2)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(2),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(2),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),4)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(2),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),2)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,3),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),2)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(3),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(3),mass5set(:,5),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(7),mass5set(:,4),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(7),mass5set(:,5),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(10),mass5set(:,12),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(10),mass5set(:,13),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(11),mass5set(:,12),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(11),mass5set(:,13),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(13),mass5set(:,14),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(13),mass5set(:,15),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),4)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(13),mass5set(:,14),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),2)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(13),mass5set(:,15),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),2)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(14),mass5set(:,16),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(18),mass5set(:,19),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(20),mass5set(:,29),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(6),mass5set(:,30),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(24),mass5set(:,29),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(22),mass5set(:,19),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),4)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(12),mass5set(:,30),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(15),mass5set(:,31),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(16),mass5set(:,31),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(4),mass5set(:,6),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(4),mass5set(:,7),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(4),mass5set(:,6),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),4)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(5),mass5set(:,8),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(6),mass5set(:,9),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),4)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(6),mass5set(:,10),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(8),mass5set(:,6),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),4)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(8),mass5set(:,6),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(8),mass5set(:,7),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),4)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(9),mass5set(:,11),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),8)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(12),mass5set(:,9),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),4)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(12),mass5set(:,10),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(15),mass5set(:,17),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),8)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(15),mass5set(:,18),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(16),mass5set(:,17),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(16),mass5set(:,18),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),8)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(17),mass5set(:,19),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(18),mass5set(:,20),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),16)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(18),mass5set(:,19),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),4)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(18),mass5set(:,19),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),4)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(19),mass5set(:,21),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),16)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(19),mass5set(:,22),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),16)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(19),mass5set(:,23),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(20),mass5set(:,21),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),16)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(20),mass5set(:,23),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),16)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(20),mass5set(:,22),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),16)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(20),mass5set(:,21),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),8)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(20),mass5set(:,22),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),8)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(21),mass5set(:,19),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),16)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(22),mass5set(:,20),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),16)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(23),mass5set(:,21),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),16)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(23),mass5set(:,22),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),16)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(23),mass5set(:,23),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(24),mass5set(:,21),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),16)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(24),mass5set(:,23),  & 
G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(386),16)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(24),mass5set(:,22),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(392),16)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(24),mass5set(:,21),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(398),8)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(24),mass5set(:,22),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408))
  call G_TensorShift(G1tensor(404),8)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(22),mass5set(:,19),  & 
G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414))
  call G_TensorShift(G1tensor(410),4)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(22),mass5set(:,19),  & 
G1tensor(415),G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(416),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  call ol_merge_tensors(T1sum(43),[G1tensor(253)])
  call ol_merge_tensors(T1sum(44),[G1tensor(259)])
  call ol_merge_tensors(T1sum(45),[G1tensor(265)])
  call ol_merge_tensors(T1sum(46),[G1tensor(271)])
  call ol_merge_tensors(T1sum(47),[G1tensor(277)])
  call ol_merge_tensors(T1sum(48),[G1tensor(283)])
  call ol_merge_tensors(T1sum(49),[G1tensor(289)])
  call ol_merge_tensors(T1sum(50),[G1tensor(295)])
  call ol_merge_tensors(T1sum(51),[G1tensor(301)])
  call ol_merge_tensors(T1sum(52),[G1tensor(307)])
  call ol_merge_tensors(T1sum(53),[G1tensor(313)])
  call ol_merge_tensors(T1sum(54),[G1tensor(319)])
  call ol_merge_tensors(T1sum(55),[G1tensor(325)])
  call ol_merge_tensors(T1sum(56),[G1tensor(331)])
  call ol_merge_tensors(T1sum(57),[G1tensor(337)])
  call ol_merge_tensors(T1sum(58),[G1tensor(343)])
  call ol_merge_tensors(T1sum(59),[G1tensor(349)])
  call ol_merge_tensors(T1sum(60),[G1tensor(355)])
  call ol_merge_tensors(T1sum(61),[G1tensor(361)])
  call ol_merge_tensors(T1sum(62),[G1tensor(367)])
  call ol_merge_tensors(T1sum(63),[G1tensor(373)])
  call ol_merge_tensors(T1sum(64),[G1tensor(379)])
  call ol_merge_tensors(T1sum(65),[G1tensor(385)])
  call ol_merge_tensors(T1sum(66),[G1tensor(391)])
  call ol_merge_tensors(T1sum(67),[G1tensor(397)])
  call ol_merge_tensors(T1sum(68),[G1tensor(403)])
  call ol_merge_tensors(T1sum(69),[G1tensor(409)])
  call ol_merge_tensors(T1sum(70),[G1tensor(415)])
  Gcoeff(:)%j = (c(34)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(87),h0tab(:,87),[32,6,16,1,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,87),heltab2x96(:,:,87))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(8),n2h48(61))
  Gcoeff(:)%j = (-(c(45)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(88),h0tab(:,88),[32,6,16,1,8],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,88),heltab2x96(:,:,88))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(7),n2h48(62))
  Gcoeff(:)%j = (c(34)*M(4,:)%j-c(35)*M(7,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(89),h0tab(:,89),[32,6,16,1,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,89),heltab2x96(:,:,89))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(12),n2h48(63))
  Gcoeff(:)%j = (-(c(45)*M(4,:)%j)+c(46)*M(7,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(90),h0tab(:,90),[32,6,16,1,8],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,90),heltab2x96(:,:,90))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(16),n2h48(64))
  Gcoeff(:)%j = (c(57)*M(3,:)%j+c(61)*M(6,:)%j-c(58)*M(8,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(91),h0tab(:,91),[32,6,16,1,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,91),heltab2x96(:,:,91))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(15),n2h48(65))
  Gcoeff(:)%j = (c(34)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(92),h0tab(:,92),[32,6,8,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,92),heltab2x96(:,:,92))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(21),n2h48(66))
  Gcoeff(:)%j = (-(c(45)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(93),h0tab(:,93),[32,6,8,1,16],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,93),heltab2x96(:,:,93))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(20),n2h48(67))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)+c(34)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(94),h0tab(:,94),[32,6,8,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,94),heltab2x96(:,:,94))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(35),n2h48(68))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(95),h0tab(:,95),[32,6,8,1,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,95),heltab2x96(:,:,95))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(34),n2h48(69))
  Gcoeff(:)%j = (-(c(58)*M(2,:)%j)+c(57)*M(3,:)%j+c(61)*M(6,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(96),h0tab(:,96),[32,6,8,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,96),heltab2x96(:,:,96))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(39),n2h48(70))
  Gcoeff(:)%j = (-(c(39)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(97),h0tab(:,97),[32,1,8,16,6],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,97),heltab2x96(:,:,97))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(43),n2h48(71))
  Gcoeff(:)%j = (-(c(45)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(98),h0tab(:,98),[32,1,8,16,6],[0,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,98),heltab2x96(:,:,98))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(42),n2h48(72))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)+c(34)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(99),h0tab(:,99),[32,1,8,16,6],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,99),heltab2x96(:,:,99))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(48),n2h48(73))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(100),h0tab(:,100),[32,1,8,16,6],[0,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,100),heltab2x96(:,:,100))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(47),n2h48(74))
  Gcoeff(:)%j = (-(c(58)*M(2,:)%j)+c(57)*M(3,:)%j+c(61)*M(6,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(101),h0tab(:,101),[32,1,8,16,6],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,101),heltab2x96(:,:,101))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(78),n2h48(75))
  Gcoeff(:)%j = (c(34)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(102),h0tab(:,102),[32,1,8,6,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,102),heltab2x96(:,:,102))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(84),n2h48(76))



end subroutine vamp_1

end module ol_vamp_1_ppwttj_ew_uxttxdwxg_1_/**/REALKIND
