
module ol_vamp_15_ppwttj_ew_uttxdxwg_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_15(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwttj_ew_uttxdxwg_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwttj_ew_uttxdxwg_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwttj_ew_uttxdxwg_4_/**/DREALKIND
  use ol_tensor_sum_storage_ppwttj_ew_uttxdxwg_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwttj_ew_uttxdxwg_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwttj_ew_uttxdxwg_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1633),h0tab(:,1633),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(101),m3h8x12(:,289),heltab2x96(:,:,1601))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1634),h0tab(:,1634),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(107),m3h8x12(:,290),heltab2x96(:,:,1602))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1635),h0tab(:,1635),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,25))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,9),G1H12(118),m3h8x12(:,291),heltab2x96(:,:,1603))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1636),h0tab(:,1636),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,25))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,9),G1H12(108),m3h8x12(:,292),heltab2x96(:,:,1604))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1637),h0tab(:,1637),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,25))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(142),m3h8x12(:,293),heltab2x96(:,:,1605))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1638),h0tab(:,1638),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,25))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(117),m3h8x12(:,294),heltab2x96(:,:,1606))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1639),h0tab(:,1639),[41,6,16],[nMZ,nMZ,nMW],3,2,wf8(:,9),wf4(:,7))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(123),m3h8x12(:,295),heltab2x96(:,:,1607))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1640),h0tab(:,1640),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(285),m3h8x12(:,296),heltab2x96(:,:,1608))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1641),h0tab(:,1641),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(129),m3h8x12(:,297),heltab2x96(:,:,1609))
  Gcoeff(:)%j = (c(81)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1642),h0tab(:,1642),[41,6,16],[nMZ,nMZ,nMW],3,2,wf8(:,9),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,9),G0H12(10),m3h8x12(:,298),heltab2x96(:,:,1610))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1643),h0tab(:,1643),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,9),G0H12(11),m3h8x12(:,299),heltab2x96(:,:,1611))
  Gcoeff(:)%j = (-(c(81)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1644),h0tab(:,1644),[41,6,16],[nMZ,nMH,nMW],3,2,wf8(:,9),wf4(:,25))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,9),G0H12(12),m3h8x12(:,300),heltab2x96(:,:,1612))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1645),h0tab(:,1645),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,25))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,9),G0H12(13),m3h8x12(:,301),heltab2x96(:,:,1613))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1646),h0tab(:,1646),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(14),m3h8x12(:,302),heltab2x96(:,:,1614))
  Gcoeff(:)%j = (-(c(136)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1647),h0tab(:,1647),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(15),m3h8x12(:,303),heltab2x96(:,:,1615))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1648),h0tab(:,1648),[41,6,16],[nMH,nMH,nMW],3,2,wf8(:,9),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(16),m3h8x12(:,304),heltab2x96(:,:,1616))
  Gcoeff(:)%j = (c(81)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1649),h0tab(:,1649),[41,6,16],[nMZ,nMZ,nMW],3,2,wf8(:,9),wf4(:,7))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(22),m3h8x12(:,305),heltab2x96(:,:,1617))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1650),h0tab(:,1650),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(46),m3h8x12(:,306),heltab2x96(:,:,1618))
  Gcoeff(:)%j = (c(81)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1651),h0tab(:,1651),[41,6,16],[nMH,nMZ,nMW],3,2,wf8(:,9),wf4(:,25))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(42),m3h8x12(:,307),heltab2x96(:,:,1619))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1652),h0tab(:,1652),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,25))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(41),m3h8x12(:,308),heltab2x96(:,:,1620))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1653),h0tab(:,1653),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(159),m3h8x12(:,309),heltab2x96(:,:,1621))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1654),h0tab(:,1654),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(161),m3h8x12(:,310),heltab2x96(:,:,1622))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1655),h0tab(:,1655),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,25))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(6),m3h8x12(:,311),heltab2x96(:,:,1623))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1656),h0tab(:,1656),[41,6,16],[nMZ,nMH,nMW],3,2,wf8(:,9),wf4(:,25))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(162),m3h8x12(:,312),heltab2x96(:,:,1624))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1657),h0tab(:,1657),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,25))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(193),m3h8x12(:,313),heltab2x96(:,:,1625))
  Gcoeff(:)%j = (-(c(140)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1658),h0tab(:,1658),[41,6,16],[nMZ,nMZ,nMW],3,2,wf8(:,9),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,9),G0H12(17),m3h8x12(:,314),heltab2x96(:,:,1626))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1659),h0tab(:,1659),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,9),G0H12(18),m3h8x12(:,315),heltab2x96(:,:,1627))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1660),h0tab(:,1660),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(19),m3h8x12(:,316),heltab2x96(:,:,1628))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1661),h0tab(:,1661),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(20),m3h8x12(:,317),heltab2x96(:,:,1629))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1662),h0tab(:,1662),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,25))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(21),m3h8x12(:,318),heltab2x96(:,:,1630))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1663),h0tab(:,1663),[41,6,16],[nMH,nMZ,nMW],3,2,wf8(:,9),wf4(:,25))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(22),m3h8x12(:,319),heltab2x96(:,:,1631))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1664),h0tab(:,1664),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,25))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(23),m3h8x12(:,320),heltab2x96(:,:,1632))
  Gcoeff(:)%j = (-(c(225)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1665),h0tab(:,1665),[41,6,16],[nME,nME,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,9),G0H12(24),m3h8x12(:,321),heltab2x96(:,:,1633))
  call Hloop_A_Q(ntryL,G0H12(24),41,nME,G1H12(191),n2h12(508))
  Gcoeff(:)%j = (-(c(225)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1666),h0tab(:,1666),[41,6,16],[nMM,nMM,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,9),G0H12(25),m3h8x12(:,322),heltab2x96(:,:,1634))
  call Hloop_A_Q(ntryL,G0H12(25),41,nMM,G1H12(78),n2h12(509))
  Gcoeff(:)%j = (-(c(225)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1667),h0tab(:,1667),[41,6,16],[nML,nML,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,9),G0H12(26),m3h8x12(:,323),heltab2x96(:,:,1635))
  call Hloop_A_Q(ntryL,G0H12(26),41,nML,G1H12(96),n2h12(510))
  Gcoeff(:)%j = (c(227)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1668),h0tab(:,1668),[41,6,16],[0,0,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,9),G0H12(27),m3h8x12(:,324),heltab2x96(:,:,1636))
  call Hloop_Q_A(ntryL,G0H12(27),41,0,G1H12(252),n2h12(511))
  Gcoeff(:)%j = (c(224)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1669),h0tab(:,1669),[41,6,16],[nMT,nMT,nMB],3,2,wf8(:,9),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,9),G0H12(28),m3h8x12(:,325),heltab2x96(:,:,1637))
  call Hloop_Q_A(ntryL,G0H12(28),41,nMT,G1H12(251),n2h12(512))
  Gcoeff(:)%j = (-(c(224)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1670),h0tab(:,1670),[41,6,16],[0,0,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,9),G0H12(29),m3h8x12(:,326),heltab2x96(:,:,1638))
  call Hloop_A_Q(ntryL,G0H12(29),41,0,G1H12(141),n2h12(513))
  Gcoeff(:)%j = (-(c(223)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1671),h0tab(:,1671),[41,6,16],[nMB,nMB,nMT],3,2,wf8(:,9),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,9),G0H12(30),m3h8x12(:,327),heltab2x96(:,:,1639))
  call Hloop_A_Q(ntryL,G0H12(30),41,nMB,G1H12(124),n2h12(514))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1672),h0tab(:,1672),[41,6,16],[0,0,nME],3,2,wf8(:,9),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,9),G0H12(31),m3h8x12(:,328),heltab2x96(:,:,1640))
  call Hloop_Q_A(ntryL,G0H12(31),41,0,G1H12(150),n2h12(515))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1673),h0tab(:,1673),[41,6,16],[0,0,nMM],3,2,wf8(:,9),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,9),G0H12(54),m3h8x12(:,329),heltab2x96(:,:,1641))
  call Hloop_Q_A(ntryL,G0H12(54),41,0,G1H12(130),n2h12(516))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1674),h0tab(:,1674),[41,6,16],[0,0,nML],3,2,wf8(:,9),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,9),G0H12(52),m3h8x12(:,330),heltab2x96(:,:,1642))
  call Hloop_Q_A(ntryL,G0H12(52),41,0,G1H12(151),n2h12(517))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1675),h0tab(:,1675),[41,6,16],[nME,nME,0],3,2,wf8(:,9),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,9),G0H12(37),m3h8x12(:,331),heltab2x96(:,:,1643))
  call Hloop_A_Q(ntryL,G0H12(37),41,nME,G1H12(152),n2h12(518))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1676),h0tab(:,1676),[41,6,16],[nMM,nMM,0],3,2,wf8(:,9),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,9),G0H12(35),m3h8x12(:,332),heltab2x96(:,:,1644))
  call Hloop_A_Q(ntryL,G0H12(35),41,nMM,G1H12(155),n2h12(519))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1677),h0tab(:,1677),[41,6,16],[nML,nML,0],3,2,wf8(:,9),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,9),G0H12(56),m3h8x12(:,333),heltab2x96(:,:,1645))
  call Hloop_A_Q(ntryL,G0H12(56),41,nML,G1H12(156),n2h12(520))
  Gcoeff(:)%j = (c(231)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1678),h0tab(:,1678),[41,6,16],[0,0,0],3,2,wf8(:,9),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,9),G0H12(53),m3h8x12(:,334),heltab2x96(:,:,1646))
  call Hloop_Q_A(ntryL,G0H12(53),41,0,G1H12(157),n2h12(521))
  Gcoeff(:)%j = (c(229)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1679),h0tab(:,1679),[41,6,16],[nMT,nMT,nMB],3,2,wf8(:,9),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,9),G0H12(39),m3h8x12(:,335),heltab2x96(:,:,1647))
  call Hloop_Q_A(ntryL,G0H12(39),41,nMT,G1H12(164),n2h12(522))
  Gcoeff(:)%j = (c(231)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1680),h0tab(:,1680),[41,6,16],[0,0,0],3,2,wf8(:,9),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,9),G0H12(36),m3h8x12(:,336),heltab2x96(:,:,1648))
  call Hloop_A_Q(ntryL,G0H12(36),41,0,G1H12(165),n2h12(523))
  Gcoeff(:)%j = (c(229)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1681),h0tab(:,1681),[41,6,16],[nMB,nMB,nMT],3,2,wf8(:,9),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,9),G0H12(55),m3h8x12(:,337),heltab2x96(:,:,1649))
  call Hloop_A_Q(ntryL,G0H12(55),41,nMB,G1H12(166),n2h12(524))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1682),h0tab(:,1682),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(169),m3h8x12(:,338),heltab2x96(:,:,1650))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1683),h0tab(:,1683),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(170),m3h8x12(:,339),heltab2x96(:,:,1651))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1684),h0tab(:,1684),[41,6,16],[nMZ,nMH,nMW],3,2,wf8(:,9),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(171),m3h8x12(:,340),heltab2x96(:,:,1652))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1685),h0tab(:,1685),[41,6,16],[nMH,nMZ,nMW],3,2,wf8(:,9),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(174),m3h8x12(:,341),heltab2x96(:,:,1653))
  Gcoeff(:)%j = (-(c(150)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1686),h0tab(:,1686),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(175),m3h8x12(:,342),heltab2x96(:,:,1654))
  Gcoeff(:)%j = (-(c(150)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1687),h0tab(:,1687),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(176),m3h8x12(:,343),heltab2x96(:,:,1655))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1688),h0tab(:,1688),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,9),G1H12(179),m3h8x12(:,344),heltab2x96(:,:,1656))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1689),h0tab(:,1689),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,9),G1H12(180),m3h8x12(:,345),heltab2x96(:,:,1657))
  Gcoeff(:)%j = (c(133)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1690),h0tab(:,1690),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(181),m3h8x12(:,346),heltab2x96(:,:,1658))
  Gcoeff(:)%j = (c(69)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1691),h0tab(:,1691),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(184),m3h8x12(:,347),heltab2x96(:,:,1659))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1692),h0tab(:,1692),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,4))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,9),G1H12(58),m3h8x12(:,348),heltab2x96(:,:,1660))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1693),h0tab(:,1693),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,4))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,9),G1H12(187),m3h8x12(:,349),heltab2x96(:,:,1661))
  Gcoeff(:)%j = (c(115)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1694),h0tab(:,1694),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(189),m3h8x12(:,350),heltab2x96(:,:,1662))
  Gcoeff(:)%j = (c(50)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1695),h0tab(:,1695),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(186),m3h8x12(:,351),heltab2x96(:,:,1663))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1696),h0tab(:,1696),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(188),m3h8x12(:,352),heltab2x96(:,:,1664))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1697),h0tab(:,1697),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(194),m3h8x12(:,353),heltab2x96(:,:,1665))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1698),h0tab(:,1698),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(53),m3h8x12(:,354),heltab2x96(:,:,1666))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1699),h0tab(:,1699),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(197),m3h8x12(:,355),heltab2x96(:,:,1667))
  Gcoeff(:)%j = (c(91)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1700),h0tab(:,1700),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,9),G0H12(38),m3h8x12(:,356),heltab2x96(:,:,1668))
  Gcoeff(:)%j = (-(c(118)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1701),h0tab(:,1701),[41,6,16],[nMZ,nMH,nMW],3,2,wf8(:,9),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,9),G0H12(32),m3h8x12(:,357),heltab2x96(:,:,1669))
  Gcoeff(:)%j = (-(c(119)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1702),h0tab(:,1702),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,9),G0H12(50),m3h8x12(:,358),heltab2x96(:,:,1670))
  Gcoeff(:)%j = (c(139)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1703),h0tab(:,1703),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(33),m3h8x12(:,359),heltab2x96(:,:,1671))
  Gcoeff(:)%j = (c(144)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1704),h0tab(:,1704),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(51),m3h8x12(:,360),heltab2x96(:,:,1672))
  Gcoeff(:)%j = (c(158)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1705),h0tab(:,1705),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(34),m3h8x12(:,361),heltab2x96(:,:,1673))
  Gcoeff(:)%j = (-(c(166)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1706),h0tab(:,1706),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(62),m3h8x12(:,362),heltab2x96(:,:,1674))
  Gcoeff(:)%j = (-(c(91)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1707),h0tab(:,1707),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(192),m3h8x12(:,363),heltab2x96(:,:,1675))
  Gcoeff(:)%j = (c(118)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1708),h0tab(:,1708),[41,6,16],[nMH,nMZ,nMW],3,2,wf8(:,9),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(190),m3h8x12(:,364),heltab2x96(:,:,1676))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1709),h0tab(:,1709),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(200),m3h8x12(:,365),heltab2x96(:,:,1677))
  Gcoeff(:)%j = (c(139)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1710),h0tab(:,1710),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(4),m3h8x12(:,366),heltab2x96(:,:,1678))
  Gcoeff(:)%j = (-(c(139)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1711),h0tab(:,1711),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(199),m3h8x12(:,367),heltab2x96(:,:,1679))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1712),h0tab(:,1712),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(3),m3h8x12(:,368),heltab2x96(:,:,1680))
  Gcoeff(:)%j = (c(60)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1713),h0tab(:,1713),[41,6,16],[nMZ,nMH,nMW],3,2,wf8(:,9),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(28),m3h8x12(:,369),heltab2x96(:,:,1681))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1714),h0tab(:,1714),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,9),41,G1H12(73),m3h8x12(:,370),heltab2x96(:,:,1682))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1715),h0tab(:,1715),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,9),G0H12(60),m3h8x12(:,371),heltab2x96(:,:,1683))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1716),h0tab(:,1716),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,9),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,9),G0H12(45),m3h8x12(:,372),heltab2x96(:,:,1684))
  Gcoeff(:)%j = (c(139)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1717),h0tab(:,1717),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(43),m3h8x12(:,373),heltab2x96(:,:,1685))
  Gcoeff(:)%j = (-(c(139)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1718),h0tab(:,1718),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(64),m3h8x12(:,374),heltab2x96(:,:,1686))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1719),h0tab(:,1719),[41,6,16],[nMW,nMW,0],3,2,wf8(:,9),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(61),m3h8x12(:,375),heltab2x96(:,:,1687))
  Gcoeff(:)%j = (c(60)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1720),h0tab(:,1720),[41,6,16],[nMH,nMZ,nMW],3,2,wf8(:,9),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(47),m3h8x12(:,376),heltab2x96(:,:,1688))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1721),h0tab(:,1721),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,9),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,9),G0H12(44),m3h8x12(:,377),heltab2x96(:,:,1689))
  Gcoeff(:)%j = (c(82)*M(2,:)%j) * den(384)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1722),h0tab(:,1722),[49,6,8],[nMZ,nMZ,0],3,2,wf12(:,25),wf4(:,7))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf12(:,25),G0H8(20),ngZd,m3h12x8(:,73),heltab2x96(:,:,1690))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(384)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1723),h0tab(:,1723),[49,6,8],[nMW,nMW,0],3,2,wf12(:,25),wf4(:,7))
  call Hloop_AQ_W(ntryL,G0H96(1),wf12(:,25),G0H8(21),m3h12x8(:,74),heltab2x96(:,:,1691))
  Gcoeff(:)%j = (c(122)*M(2,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1724),h0tab(:,1724),[49,6,8],[0,0,0],3,2,wf12(:,25),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,25),G0H8(22),m3h12x8(:,75),heltab2x96(:,:,1692))
  call Hloop_Q_A(ntryL,G0H8(22),49,0,G1H8(185),n2h8(91))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1725),h0tab(:,1725),[49,6,8],[0,0,nMZ],3,2,wf12(:,25),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,25),G0H8(23),ngZd,m3h12x8(:,76),heltab2x96(:,:,1693))
  call Hloop_Q_A(ntryL,G0H8(23),49,0,G1H8(186),n2h8(92))
  Gcoeff(:)%j = (-(c(99)*M(2,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1726),h0tab(:,1726),[49,6,8],[0,0,nMW],3,2,wf12(:,25),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,25),G0H8(24),m3h12x8(:,77),heltab2x96(:,:,1694))
  call Hloop_Q_A(ntryL,G0H8(24),49,0,G1H8(187),n2h8(93))
  Gcoeff(:)%j = (-(c(126)*M(2,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1727),h0tab(:,1727),[49,6,8],[0,0,0],3,2,wf12(:,25),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,25),G0H8(25),m3h12x8(:,78),heltab2x96(:,:,1695))
  call Hloop_Q_A(ntryL,G0H8(25),49,0,G1H8(188),n2h8(94))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1728),h0tab(:,1728),[49,6,8],[0,0,nMZ],3,2,wf12(:,25),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,25),G0H8(26),ngZd,m3h12x8(:,79),heltab2x96(:,:,1696))
  call Hloop_Q_A(ntryL,G0H8(26),49,0,G1H8(191),n2h8(95))
  Gcoeff(:)%j = (-(c(101)*M(2,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1729),h0tab(:,1729),[49,6,8],[0,0,nMW],3,2,wf12(:,25),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,25),G0H8(2),m3h12x8(:,80),heltab2x96(:,:,1697))
  call Hloop_Q_A(ntryL,G0H8(2),49,0,G1H8(192),n2h8(96))
  Gcoeff(:)%j = (-(c(100)*M(2,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1730),h0tab(:,1730),[49,6,8],[nMW,nMW,0],3,2,wf12(:,25),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H96(1),wf12(:,25),G0H8(3),m3h12x8(:,81),heltab2x96(:,:,1698))
  Gcoeff(:)%j = (-(c(63)*M(2,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1731),h0tab(:,1731),[49,6,8],[nMW,nMW,0],3,2,wf12(:,25),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H96(1),wf12(:,25),G0H8(4),m3h12x8(:,82),heltab2x96(:,:,1699))
  Gcoeff(:)%j = (-(c(123)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1732),h0tab(:,1732),[33,14,16],[0,0,0],3,2,wf4(:,6),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(25),m3h4x24(:,575),heltab2x96(:,:,1700))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1733),h0tab(:,1733),[33,14,16],[nMZ,0,0],3,2,wf4(:,6),wf8(:,2))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(35),ngZu,m3h4x24(:,576),heltab2x96(:,:,1701))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1734),h0tab(:,1734),[33,14,16],[0,0,0],3,2,wf4(:,6),wf8(:,4))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(36),m3h4x24(:,577),heltab2x96(:,:,1702))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1735),h0tab(:,1735),[33,14,16],[nMZ,0,0],3,2,wf4(:,6),wf8(:,4))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(55),ngZu,m3h4x24(:,578),heltab2x96(:,:,1703))
  Gcoeff(:)%j = (c(127)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1736),h0tab(:,1736),[33,14,16],[0,nMW,0],3,2,wf4(:,6),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(27),m3h4x24(:,579),heltab2x96(:,:,1704))
  call Hloop_Q_A(ntryL,G0H24(27),33,0,G1H24(235),n2h24(403))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1737),h0tab(:,1737),[33,14,16],[0,0,nMW],3,2,wf4(:,6),wf8(:,2))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(34),m3h4x24(:,580),heltab2x96(:,:,1705))
  call Hloop_Q_A(ntryL,G0H24(34),33,0,G1H24(236),n2h24(404))
  Gcoeff(:)%j = (c(111)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1738),h0tab(:,1738),[33,14,16],[0,nMW,nMZ],3,2,wf4(:,6),wf8(:,2))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(37),ngZu,m3h4x24(:,581),heltab2x96(:,:,1706))
  call Hloop_Q_A(ntryL,G0H24(37),33,0,G1H24(237),n2h24(405))
  Gcoeff(:)%j = (c(111)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1739),h0tab(:,1739),[33,14,16],[0,nMZ,nMW],3,2,wf4(:,6),wf8(:,2))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(48),m3h4x24(:,582),heltab2x96(:,:,1707))
  call Hloop_Q_A(ntryL,G0H24(48),33,0,G1H24(238),n2h24(406))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1740),h0tab(:,1740),[33,14,16],[0,nMW,0],3,2,wf4(:,6),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(49),m3h4x24(:,583),heltab2x96(:,:,1708))
  call Hloop_Q_A(ntryL,G0H24(49),33,0,G1H24(239),n2h24(407))
  Gcoeff(:)%j = (c(131)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1741),h0tab(:,1741),[33,14,16],[0,0,nMW],3,2,wf4(:,6),wf8(:,4))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(54),m3h4x24(:,584),heltab2x96(:,:,1709))
  call Hloop_Q_A(ntryL,G0H24(54),33,0,G1H24(240),n2h24(408))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1742),h0tab(:,1742),[33,14,16],[0,nMW,nMZ],3,2,wf4(:,6),wf8(:,4))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(58),ngZu,m3h4x24(:,585),heltab2x96(:,:,1710))
  call Hloop_Q_A(ntryL,G0H24(58),33,0,G1H24(241),n2h24(409))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1743),h0tab(:,1743),[33,14,16],[0,nMZ,nMW],3,2,wf4(:,6),wf8(:,4))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(11),m3h4x24(:,586),heltab2x96(:,:,1711))
  call Hloop_Q_A(ntryL,G0H24(11),33,0,G1H24(242),n2h24(410))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1744),h0tab(:,1744),[33,8,22],[0,nMW,0],3,2,wf4(:,6),wf12(:,65))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(22),m3h4x24(:,587),heltab2x96(:,:,1712))
  call Hloop_Q_A(ntryL,G0H24(22),33,0,G1H24(243),n2h24(411))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1745),h0tab(:,1745),[33,8,22],[0,0,nMW],3,2,wf4(:,6),wf12(:,65))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(26),m3h4x24(:,588),heltab2x96(:,:,1713))
  call Hloop_Q_A(ntryL,G0H24(26),33,0,G1H24(244),n2h24(412))
  Gcoeff(:)%j = (-(c(117)*M(2,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1746),h0tab(:,1746),[33,8,22],[0,nMW,nMZ],3,2,wf4(:,6),wf12(:,65))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(32),ngZu,m3h4x24(:,589),heltab2x96(:,:,1714))
  call Hloop_Q_A(ntryL,G0H24(32),33,0,G1H24(245),n2h24(413))
  Gcoeff(:)%j = (-(c(117)*M(2,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1747),h0tab(:,1747),[33,8,22],[0,nMZ,nMW],3,2,wf4(:,6),wf12(:,65))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(33),m3h4x24(:,590),heltab2x96(:,:,1715))
  call Hloop_Q_A(ntryL,G0H24(33),33,0,G1H24(246),n2h24(414))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1748),h0tab(:,1748),[33,8,22],[0,nMW,0],3,2,wf4(:,6),wf12(:,66))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(31),m3h4x24(:,591),heltab2x96(:,:,1716))
  call Hloop_Q_A(ntryL,G0H24(31),33,0,G1H24(247),n2h24(415))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1749),h0tab(:,1749),[33,8,22],[0,0,nMW],3,2,wf4(:,6),wf12(:,66))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(70),m3h4x24(:,592),heltab2x96(:,:,1717))
  call Hloop_Q_A(ntryL,G0H24(70),33,0,G1H24(248),n2h24(416))
  Gcoeff(:)%j = (-(c(117)*M(2,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1750),h0tab(:,1750),[33,8,22],[0,nMW,nMZ],3,2,wf4(:,6),wf12(:,66))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(71),ngZu,m3h4x24(:,593),heltab2x96(:,:,1718))
  call Hloop_Q_A(ntryL,G0H24(71),33,0,G1H24(249),n2h24(417))
  Gcoeff(:)%j = (-(c(117)*M(2,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1751),h0tab(:,1751),[33,8,22],[0,nMZ,nMW],3,2,wf4(:,6),wf12(:,66))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(72),m3h4x24(:,594),heltab2x96(:,:,1719))
  call Hloop_Q_A(ntryL,G0H24(72),33,0,G1H24(250),n2h24(418))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1752),h0tab(:,1752),[33,8,22],[0,0,0],3,2,wf4(:,6),wf12(:,3))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(73),m3h4x24(:,595),heltab2x96(:,:,1720))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1753),h0tab(:,1753),[33,8,22],[nMZ,0,0],3,2,wf4(:,6),wf12(:,3))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(74),ngZu,m3h4x24(:,596),heltab2x96(:,:,1721))
  Gcoeff(:)%j = (c(79)*M(2,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1754),h0tab(:,1754),[33,8,22],[0,nMW,0],3,2,wf4(:,6),wf12(:,3))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(75),m3h4x24(:,597),heltab2x96(:,:,1722))
  call Hloop_Q_A(ntryL,G0H24(75),33,0,G1H24(251),n2h24(419))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1755),h0tab(:,1755),[33,8,22],[0,0,nMW],3,2,wf4(:,6),wf12(:,3))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(76),m3h4x24(:,598),heltab2x96(:,:,1723))
  call Hloop_Q_A(ntryL,G0H24(76),33,0,G1H24(252),n2h24(420))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1756),h0tab(:,1756),[33,8,22],[0,nMW,nMZ],3,2,wf4(:,6),wf12(:,3))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(77),ngZu,m3h4x24(:,599),heltab2x96(:,:,1724))
  call Hloop_Q_A(ntryL,G0H24(77),33,0,G1H24(253),n2h24(421))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1757),h0tab(:,1757),[33,8,22],[0,nMZ,nMW],3,2,wf4(:,6),wf12(:,3))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(78),m3h4x24(:,600),heltab2x96(:,:,1725))
  call Hloop_Q_A(ntryL,G0H24(78),33,0,G1H24(254),n2h24(422))
  Gcoeff(:)%j = (c(138)*M(2,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1758),h0tab(:,1758),[33,8,22],[0,nMW,0],3,2,wf4(:,6),wf12(:,67))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(79),m3h4x24(:,601),heltab2x96(:,:,1726))
  call Hloop_Q_A(ntryL,G0H24(79),33,0,G1H24(255),n2h24(423))
  Gcoeff(:)%j = (-(c(137)*M(2,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1759),h0tab(:,1759),[33,8,22],[0,0,nMW],3,2,wf4(:,6),wf12(:,67))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(80),m3h4x24(:,602),heltab2x96(:,:,1727))
  call Hloop_Q_A(ntryL,G0H24(80),33,0,G1H24(256),n2h24(424))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1760),h0tab(:,1760),[33,8,22],[0,nMW,nMZ],3,2,wf4(:,6),wf12(:,67))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(81),ngZu,m3h4x24(:,603),heltab2x96(:,:,1728))
  call Hloop_Q_A(ntryL,G0H24(81),33,0,G1H24(257),n2h24(425))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1761),h0tab(:,1761),[33,8,22],[0,nMZ,nMW],3,2,wf4(:,6),wf12(:,67))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(82),m3h4x24(:,604),heltab2x96(:,:,1729))
  call Hloop_Q_A(ntryL,G0H24(82),33,0,G1H24(258),n2h24(426))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1762),h0tab(:,1762),[33,8,22],[0,nMW,0],3,2,wf4(:,6),wf12(:,68))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(83),m3h4x24(:,605),heltab2x96(:,:,1730))
  call Hloop_Q_A(ntryL,G0H24(83),33,0,G1H24(259),n2h24(427))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1763),h0tab(:,1763),[33,8,22],[0,0,nMW],3,2,wf4(:,6),wf12(:,68))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(84),m3h4x24(:,606),heltab2x96(:,:,1731))
  call Hloop_Q_A(ntryL,G0H24(84),33,0,G1H24(260),n2h24(428))
  Gcoeff(:)%j = (c(145)*M(2,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1764),h0tab(:,1764),[33,8,22],[0,nMW,nMZ],3,2,wf4(:,6),wf12(:,68))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(85),ngZu,m3h4x24(:,607),heltab2x96(:,:,1732))
  call Hloop_Q_A(ntryL,G0H24(85),33,0,G1H24(261),n2h24(429))
  Gcoeff(:)%j = (c(145)*M(2,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1765),h0tab(:,1765),[33,8,22],[0,nMZ,nMW],3,2,wf4(:,6),wf12(:,68))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(86),m3h4x24(:,608),heltab2x96(:,:,1733))
  call Hloop_Q_A(ntryL,G0H24(86),33,0,G1H24(262),n2h24(430))
  Gcoeff(:)%j = (c(127)*M(2,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1766),h0tab(:,1766),[33,8,22],[0,0,0],3,2,wf4(:,6),wf12(:,4))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(87),m3h4x24(:,609),heltab2x96(:,:,1734))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1767),h0tab(:,1767),[33,8,22],[nMZ,0,0],3,2,wf4(:,6),wf12(:,4))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(88),ngZu,m3h4x24(:,610),heltab2x96(:,:,1735))
  Gcoeff(:)%j = (c(111)*M(2,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1768),h0tab(:,1768),[33,8,22],[0,0,0],3,2,wf4(:,6),wf12(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(89),m3h4x24(:,611),heltab2x96(:,:,1736))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1769),h0tab(:,1769),[33,8,22],[nMZ,0,0],3,2,wf4(:,6),wf12(:,5))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(90),ngZu,m3h4x24(:,612),heltab2x96(:,:,1737))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1770),h0tab(:,1770),[33,8,22],[0,nMW,0],3,2,wf4(:,6),wf12(:,4))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(91),m3h4x24(:,613),heltab2x96(:,:,1738))
  call Hloop_Q_A(ntryL,G0H24(91),33,0,G1H24(263),n2h24(431))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1771),h0tab(:,1771),[33,8,22],[0,0,nMW],3,2,wf4(:,6),wf12(:,4))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(92),m3h4x24(:,614),heltab2x96(:,:,1739))
  call Hloop_Q_A(ntryL,G0H24(92),33,0,G1H24(264),n2h24(432))
  Gcoeff(:)%j = (-(c(114)*M(2,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1772),h0tab(:,1772),[33,8,22],[0,nMW,nMZ],3,2,wf4(:,6),wf12(:,4))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(93),ngZu,m3h4x24(:,615),heltab2x96(:,:,1740))
  call Hloop_Q_A(ntryL,G0H24(93),33,0,G1H24(265),n2h24(433))
  Gcoeff(:)%j = (-(c(114)*M(2,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1773),h0tab(:,1773),[33,8,22],[0,nMZ,nMW],3,2,wf4(:,6),wf12(:,4))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(94),m3h4x24(:,616),heltab2x96(:,:,1741))
  call Hloop_Q_A(ntryL,G0H24(94),33,0,G1H24(266),n2h24(434))
  Gcoeff(:)%j = (-(c(114)*M(2,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1774),h0tab(:,1774),[33,8,22],[0,nMW,0],3,2,wf4(:,6),wf12(:,5))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(95),m3h4x24(:,617),heltab2x96(:,:,1742))
  call Hloop_Q_A(ntryL,G0H24(95),33,0,G1H24(267),n2h24(435))
  Gcoeff(:)%j = (c(112)*M(2,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1775),h0tab(:,1775),[33,8,22],[0,0,nMW],3,2,wf4(:,6),wf12(:,5))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(96),m3h4x24(:,618),heltab2x96(:,:,1743))
  call Hloop_Q_A(ntryL,G0H24(96),33,0,G1H24(268),n2h24(436))
  Gcoeff(:)%j = (-(c(70)*M(2,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1776),h0tab(:,1776),[33,8,22],[0,nMW,nMZ],3,2,wf4(:,6),wf12(:,5))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(69),ngZu,m3h4x24(:,619),heltab2x96(:,:,1744))
  call Hloop_Q_A(ntryL,G0H24(69),33,0,G1H24(269),n2h24(437))
  Gcoeff(:)%j = (-(c(70)*M(2,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1777),h0tab(:,1777),[33,8,22],[0,nMZ,nMW],3,2,wf4(:,6),wf12(:,5))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(1),m3h4x24(:,620),heltab2x96(:,:,1745))
  call Hloop_Q_A(ntryL,G0H24(1),33,0,G1H24(270),n2h24(438))
  Gcoeff(:)%j = (c(125)*M(2,:)%j) * den(177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1778),h0tab(:,1778),[39,8,16],[0,0,0],3,1,wf16(:,13))
  call Hloop_AQ_V(ntryL,G0H96(1),wf16(:,13),G0H6(17),m3h16x6(:,1),heltab2x96(:,:,1746))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1779),h0tab(:,1779),[39,8,16],[nMZ,0,0],3,1,wf16(:,13))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf16(:,13),G0H6(15),ngZu,m3h16x6(:,2),heltab2x96(:,:,1747))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1780),h0tab(:,1780),[39,8,16],[0,0,0],3,1,wf16(:,14))
  call Hloop_AQ_V(ntryL,G0H96(1),wf16(:,14),G0H6(16),m3h16x6(:,3),heltab2x96(:,:,1748))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1781),h0tab(:,1781),[39,8,16],[nMZ,0,0],3,1,wf16(:,14))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf16(:,14),G0H6(2),ngZu,m3h16x6(:,4),heltab2x96(:,:,1749))
  Gcoeff(:)%j = (-(c(130)*M(2,:)%j)) * den(177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1782),h0tab(:,1782),[39,8,16],[0,nMW,0],3,1,wf16(:,13))
  call Hloop_VQ_A(ntryL,G0H96(1),wf16(:,13),G0H6(3),m3h16x6(:,5),heltab2x96(:,:,1750))
  call Hloop_Q_A(ntryL,G0H6(3),39,0,G1H6(15),n2h6(318))
  Gcoeff(:)%j = (c(127)*M(2,:)%j) * den(177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1783),h0tab(:,1783),[39,8,16],[0,0,nMW],3,1,wf16(:,13))
  call Hloop_WQ_A(ntryL,G0H96(1),wf16(:,13),G0H6(14),m3h16x6(:,6),heltab2x96(:,:,1751))
  call Hloop_Q_A(ntryL,G0H6(14),39,0,G1H6(53),n2h6(319))
  Gcoeff(:)%j = (-(c(113)*M(2,:)%j)) * den(177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1784),h0tab(:,1784),[39,8,16],[0,nMW,nMZ],3,1,wf16(:,13))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf16(:,13),G0H6(12),ngZu,m3h16x6(:,7),heltab2x96(:,:,1752))
  call Hloop_Q_A(ntryL,G0H6(12),39,0,G1H6(142),n2h6(320))
  Gcoeff(:)%j = (-(c(113)*M(2,:)%j)) * den(177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1785),h0tab(:,1785),[39,8,16],[0,nMZ,nMW],3,1,wf16(:,13))
  call Hloop_WQ_A(ntryL,G0H96(1),wf16(:,13),G0H6(6),m3h16x6(:,8),heltab2x96(:,:,1753))
  call Hloop_Q_A(ntryL,G0H6(6),39,0,G1H6(57),n2h6(321))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1786),h0tab(:,1786),[39,8,16],[0,nMW,0],3,1,wf16(:,14))
  call Hloop_VQ_A(ntryL,G0H96(1),wf16(:,14),G0H6(4),m3h16x6(:,9),heltab2x96(:,:,1754))
  call Hloop_Q_A(ntryL,G0H6(4),39,0,G1H6(257),n2h6(322))
  Gcoeff(:)%j = (c(131)*M(2,:)%j) * den(179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1787),h0tab(:,1787),[39,8,16],[0,0,nMW],3,1,wf16(:,14))
  call Hloop_WQ_A(ntryL,G0H96(1),wf16(:,14),G0H6(8),m3h16x6(:,10),heltab2x96(:,:,1755))
  call Hloop_Q_A(ntryL,G0H6(8),39,0,G1H6(195),n2h6(323))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1788),h0tab(:,1788),[39,8,16],[0,nMW,nMZ],3,1,wf16(:,14))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf16(:,14),G0H6(5),ngZu,m3h16x6(:,11),heltab2x96(:,:,1756))
  call Hloop_Q_A(ntryL,G0H6(5),39,0,G1H6(283),n2h6(324))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1789),h0tab(:,1789),[39,8,16],[0,nMZ,nMW],3,1,wf16(:,14))
  call Hloop_WQ_A(ntryL,G0H96(1),wf16(:,14),G0H6(7),m3h16x6(:,12),heltab2x96(:,:,1757))
  call Hloop_Q_A(ntryL,G0H6(7),39,0,G1H6(78),n2h6(325))
  Gcoeff(:)%j = (c(125)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1790),h0tab(:,1790),[40,7,16],[0,0,0],3,2,wf4(:,3),wf8(:,6))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(2),m3h4x24(:,621),heltab2x96(:,:,1758))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1791),h0tab(:,1791),[40,7,16],[nMZ,0,0],3,2,wf4(:,3),wf8(:,6))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,3),G0H24(3),ngZd,m3h4x24(:,622),heltab2x96(:,:,1759))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1792),h0tab(:,1792),[40,7,16],[0,0,0],3,2,wf4(:,3),wf8(:,8))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(4),m3h4x24(:,623),heltab2x96(:,:,1760))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1793),h0tab(:,1793),[40,7,16],[nMZ,0,0],3,2,wf4(:,3),wf8(:,8))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,3),G0H24(5),ngZd,m3h4x24(:,624),heltab2x96(:,:,1761))
  Gcoeff(:)%j = (-(c(130)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1794),h0tab(:,1794),[40,7,16],[0,0,nMW],3,2,wf4(:,3),wf8(:,6))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(6),m3h4x24(:,625),heltab2x96(:,:,1762))
  call Hloop_A_Q(ntryL,G0H24(6),40,0,G1H24(271),n2h24(439))
  Gcoeff(:)%j = (c(127)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1795),h0tab(:,1795),[40,7,16],[0,nMW,0],3,2,wf4(:,3),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(7),m3h4x24(:,626),heltab2x96(:,:,1763))
  call Hloop_A_Q(ntryL,G0H24(7),40,0,G1H24(272),n2h24(440))
  Gcoeff(:)%j = (-(c(113)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1796),h0tab(:,1796),[40,7,16],[0,nMZ,nMW],3,2,wf4(:,3),wf8(:,6))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(12),m3h4x24(:,627),heltab2x96(:,:,1764))
  call Hloop_A_Q(ntryL,G0H24(12),40,0,G1H24(273),n2h24(441))
  Gcoeff(:)%j = (-(c(113)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1797),h0tab(:,1797),[40,7,16],[0,nMW,nMZ],3,2,wf4(:,3),wf8(:,6))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(13),ngZd,m3h4x24(:,628),heltab2x96(:,:,1765))
  call Hloop_A_Q(ntryL,G0H24(13),40,0,G1H24(274),n2h24(442))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1798),h0tab(:,1798),[40,7,16],[0,0,nMW],3,2,wf4(:,3),wf8(:,8))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(14),m3h4x24(:,629),heltab2x96(:,:,1766))
  call Hloop_A_Q(ntryL,G0H24(14),40,0,G1H24(275),n2h24(443))
  Gcoeff(:)%j = (c(131)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1799),h0tab(:,1799),[40,7,16],[0,nMW,0],3,2,wf4(:,3),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(15),m3h4x24(:,630),heltab2x96(:,:,1767))
  call Hloop_A_Q(ntryL,G0H24(15),40,0,G1H24(276),n2h24(444))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1800),h0tab(:,1800),[40,7,16],[0,nMZ,nMW],3,2,wf4(:,3),wf8(:,8))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(16),m3h4x24(:,631),heltab2x96(:,:,1768))
  call Hloop_A_Q(ntryL,G0H24(16),40,0,G1H24(277),n2h24(445))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1801),h0tab(:,1801),[40,7,16],[0,nMW,nMZ],3,2,wf4(:,3),wf8(:,8))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(17),ngZd,m3h4x24(:,632),heltab2x96(:,:,1769))
  call Hloop_A_Q(ntryL,G0H24(17),40,0,G1H24(278),n2h24(446))
  Gcoeff(:)%j = (-(c(184)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1802),h0tab(:,1802),[41,6,16],[nME,nME,0],3,2,wf8(:,10),wf4(:,7))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(63),m3h8x12(:,378),heltab2x96(:,:,1770))
  call Hloop_A_Q(ntryL,G0H12(63),41,nME,G1H12(74),n2h12(525))
  Gcoeff(:)%j = (-(c(186)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1803),h0tab(:,1803),[41,6,16],[nMM,nMM,0],3,2,wf8(:,10),wf4(:,7))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(46),m3h8x12(:,379),heltab2x96(:,:,1771))
  call Hloop_A_Q(ntryL,G0H12(46),41,nMM,G1H12(79),n2h12(526))
  Gcoeff(:)%j = (-(c(185)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1804),h0tab(:,1804),[41,6,16],[nML,nML,0],3,2,wf8(:,10),wf4(:,7))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(40),m3h8x12(:,380),heltab2x96(:,:,1772))
  call Hloop_A_Q(ntryL,G0H12(40),41,nML,G1H12(80),n2h12(527))
  Gcoeff(:)%j = (-(c(187)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1805),h0tab(:,1805),[41,6,16],[nMT,nMT,nMB],3,2,wf8(:,10),wf4(:,7))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(58),m3h8x12(:,381),heltab2x96(:,:,1773))
  call Hloop_Q_A(ntryL,G0H12(58),41,nMT,G1H12(81),n2h12(528))
  Gcoeff(:)%j = (-(c(183)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1806),h0tab(:,1806),[41,6,16],[nMB,nMB,nMT],3,2,wf8(:,10),wf4(:,7))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(41),m3h8x12(:,382),heltab2x96(:,:,1774))
  call Hloop_A_Q(ntryL,G0H12(41),41,nMB,G1H12(86),n2h12(529))
  Gcoeff(:)%j = (-(c(184)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1807),h0tab(:,1807),[41,6,16],[nME,nME,0],3,2,wf8(:,10),wf4(:,25))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(59),m3h8x12(:,383),heltab2x96(:,:,1775))
  call Hloop_A_Q(ntryL,G0H12(59),41,nME,G1H12(87),n2h12(530))
  Gcoeff(:)%j = (-(c(186)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1808),h0tab(:,1808),[41,6,16],[nMM,nMM,0],3,2,wf8(:,10),wf4(:,25))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(42),m3h8x12(:,384),heltab2x96(:,:,1776))
  call Hloop_A_Q(ntryL,G0H12(42),41,nMM,G1H12(88),n2h12(531))
  Gcoeff(:)%j = (-(c(185)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1809),h0tab(:,1809),[41,6,16],[nML,nML,0],3,2,wf8(:,10),wf4(:,25))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(48),m3h8x12(:,385),heltab2x96(:,:,1777))
  call Hloop_A_Q(ntryL,G0H12(48),41,nML,G1H12(27),n2h12(532))
  Gcoeff(:)%j = (c(187)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1810),h0tab(:,1810),[41,6,16],[nMT,nMT,nMB],3,2,wf8(:,10),wf4(:,25))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(66),m3h8x12(:,386),heltab2x96(:,:,1778))
  call Hloop_Q_A(ntryL,G0H12(66),41,nMT,G1H12(15),n2h12(533))
  Gcoeff(:)%j = (-(c(183)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1811),h0tab(:,1811),[41,6,16],[nMB,nMB,nMT],3,2,wf8(:,10),wf4(:,25))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(67),m3h8x12(:,387),heltab2x96(:,:,1779))
  call Hloop_A_Q(ntryL,G0H12(67),41,nMB,G1H12(34),n2h12(534))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1812),h0tab(:,1812),[41,6,16],[nMH,nMH,nMW],3,2,wf8(:,10),wf4(:,7))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(32),m3h8x12(:,388),heltab2x96(:,:,1780))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1813),h0tab(:,1813),[41,6,16],[nMZ,nMZ,nMW],3,2,wf8(:,10),wf4(:,7))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(110),m3h8x12(:,389),heltab2x96(:,:,1781))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1814),h0tab(:,1814),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(19),m3h8x12(:,390),heltab2x96(:,:,1782))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1815),h0tab(:,1815),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(20),m3h8x12(:,391),heltab2x96(:,:,1783))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1816),h0tab(:,1816),[41,6,16],[nMZ,nMH,nMW],3,2,wf8(:,10),wf4(:,25))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(51),m3h8x12(:,392),heltab2x96(:,:,1784))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1817),h0tab(:,1817),[41,6,16],[nMH,nMZ,nMW],3,2,wf8(:,10),wf4(:,25))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(31),m3h8x12(:,393),heltab2x96(:,:,1785))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1818),h0tab(:,1818),[41,6,16],[nMZ,nMZ,nMW],3,2,wf8(:,10),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(133),m3h8x12(:,394),heltab2x96(:,:,1786))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1819),h0tab(:,1819),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,7))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(134),m3h8x12(:,395),heltab2x96(:,:,1787))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1820),h0tab(:,1820),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,7))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(135),m3h8x12(:,396),heltab2x96(:,:,1788))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1821),h0tab(:,1821),[41,6,16],[nMZ,nMZ,nMW],3,2,wf8(:,10),wf4(:,7))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(138),m3h8x12(:,397),heltab2x96(:,:,1789))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1822),h0tab(:,1822),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(139),m3h8x12(:,398),heltab2x96(:,:,1790))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1823),h0tab(:,1823),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(140),m3h8x12(:,399),heltab2x96(:,:,1791))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1824),h0tab(:,1824),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,25))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(145),m3h8x12(:,400),heltab2x96(:,:,1792))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1825),h0tab(:,1825),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,25))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(146),m3h8x12(:,401),heltab2x96(:,:,1793))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1826),h0tab(:,1826),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,25))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(147),m3h8x12(:,402),heltab2x96(:,:,1794))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1827),h0tab(:,1827),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,25))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(63),m3h8x12(:,403),heltab2x96(:,:,1795))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1828),h0tab(:,1828),[41,6,16],[nMZ,nMZ,nMW],3,2,wf8(:,10),wf4(:,7))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(40),m3h8x12(:,404),heltab2x96(:,:,1796))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1829),h0tab(:,1829),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(71),m3h8x12(:,405),heltab2x96(:,:,1797))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1830),h0tab(:,1830),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(217),m3h8x12(:,406),heltab2x96(:,:,1798))
  Gcoeff(:)%j = (c(81)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1831),h0tab(:,1831),[41,6,16],[nMZ,nMZ,nMW],3,2,wf8(:,10),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(68),m3h8x12(:,407),heltab2x96(:,:,1799))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1832),h0tab(:,1832),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(69),m3h8x12(:,408),heltab2x96(:,:,1800))
  Gcoeff(:)%j = (-(c(81)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1833),h0tab(:,1833),[41,6,16],[nMZ,nMH,nMW],3,2,wf8(:,10),wf4(:,25))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(70),m3h8x12(:,409),heltab2x96(:,:,1801))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1834),h0tab(:,1834),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,25))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(71),m3h8x12(:,410),heltab2x96(:,:,1802))
  Gcoeff(:)%j = (c(81)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1835),h0tab(:,1835),[41,6,16],[nMZ,nMZ,nMW],3,2,wf8(:,10),wf4(:,7))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(218),m3h8x12(:,411),heltab2x96(:,:,1803))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1836),h0tab(:,1836),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(219),m3h8x12(:,412),heltab2x96(:,:,1804))
  Gcoeff(:)%j = (c(81)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1837),h0tab(:,1837),[41,6,16],[nMH,nMZ,nMW],3,2,wf8(:,10),wf4(:,25))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(222),m3h8x12(:,413),heltab2x96(:,:,1805))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1838),h0tab(:,1838),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,25))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(223),m3h8x12(:,414),heltab2x96(:,:,1806))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1839),h0tab(:,1839),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(72),m3h8x12(:,415),heltab2x96(:,:,1807))
  Gcoeff(:)%j = (-(c(136)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1840),h0tab(:,1840),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(73),m3h8x12(:,416),heltab2x96(:,:,1808))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1841),h0tab(:,1841),[41,6,16],[nMH,nMH,nMW],3,2,wf8(:,10),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(74),m3h8x12(:,417),heltab2x96(:,:,1809))
  Gcoeff(:)%j = (-(c(140)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1842),h0tab(:,1842),[41,6,16],[nMZ,nMZ,nMW],3,2,wf8(:,10),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(75),m3h8x12(:,418),heltab2x96(:,:,1810))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1843),h0tab(:,1843),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(76),m3h8x12(:,419),heltab2x96(:,:,1811))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1844),h0tab(:,1844),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(224),m3h8x12(:,420),heltab2x96(:,:,1812))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1845),h0tab(:,1845),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(227),m3h8x12(:,421),heltab2x96(:,:,1813))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1846),h0tab(:,1846),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,25))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(228),m3h8x12(:,422),heltab2x96(:,:,1814))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1847),h0tab(:,1847),[41,6,16],[nMZ,nMH,nMW],3,2,wf8(:,10),wf4(:,25))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(229),m3h8x12(:,423),heltab2x96(:,:,1815))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1848),h0tab(:,1848),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,25))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(232),m3h8x12(:,424),heltab2x96(:,:,1816))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1849),h0tab(:,1849),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(77),m3h8x12(:,425),heltab2x96(:,:,1817))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1850),h0tab(:,1850),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(78),m3h8x12(:,426),heltab2x96(:,:,1818))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1851),h0tab(:,1851),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,25))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(79),m3h8x12(:,427),heltab2x96(:,:,1819))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1852),h0tab(:,1852),[41,6,16],[nMH,nMZ,nMW],3,2,wf8(:,10),wf4(:,25))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(80),m3h8x12(:,428),heltab2x96(:,:,1820))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1853),h0tab(:,1853),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,25))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(81),m3h8x12(:,429),heltab2x96(:,:,1821))
  Gcoeff(:)%j = (-(c(225)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1854),h0tab(:,1854),[41,6,16],[nME,nME,0],3,2,wf8(:,10),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(82),m3h8x12(:,430),heltab2x96(:,:,1822))
  call Hloop_A_Q(ntryL,G0H12(82),41,nME,G1H12(233),n2h12(535))
  Gcoeff(:)%j = (-(c(225)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1855),h0tab(:,1855),[41,6,16],[nMM,nMM,0],3,2,wf8(:,10),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(83),m3h8x12(:,431),heltab2x96(:,:,1823))
  call Hloop_A_Q(ntryL,G0H12(83),41,nMM,G1H12(234),n2h12(536))
  Gcoeff(:)%j = (-(c(225)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1856),h0tab(:,1856),[41,6,16],[nML,nML,0],3,2,wf8(:,10),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(84),m3h8x12(:,432),heltab2x96(:,:,1824))
  call Hloop_A_Q(ntryL,G0H12(84),41,nML,G1H12(237),n2h12(537))
  Gcoeff(:)%j = (c(227)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1857),h0tab(:,1857),[41,6,16],[0,0,0],3,2,wf8(:,10),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(85),m3h8x12(:,433),heltab2x96(:,:,1825))
  call Hloop_Q_A(ntryL,G0H12(85),41,0,G1H12(238),n2h12(538))
  Gcoeff(:)%j = (c(224)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1858),h0tab(:,1858),[41,6,16],[nMT,nMT,nMB],3,2,wf8(:,10),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(86),m3h8x12(:,434),heltab2x96(:,:,1826))
  call Hloop_Q_A(ntryL,G0H12(86),41,nMT,G1H12(239),n2h12(539))
  Gcoeff(:)%j = (-(c(224)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1859),h0tab(:,1859),[41,6,16],[0,0,0],3,2,wf8(:,10),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(87),m3h8x12(:,435),heltab2x96(:,:,1827))
  call Hloop_A_Q(ntryL,G0H12(87),41,0,G1H12(242),n2h12(540))
  Gcoeff(:)%j = (-(c(223)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1860),h0tab(:,1860),[41,6,16],[nMB,nMB,nMT],3,2,wf8(:,10),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(88),m3h8x12(:,436),heltab2x96(:,:,1828))
  call Hloop_A_Q(ntryL,G0H12(88),41,nMB,G1H12(245),n2h12(541))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1861),h0tab(:,1861),[41,6,16],[0,0,nME],3,2,wf8(:,10),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(89),m3h8x12(:,437),heltab2x96(:,:,1829))
  call Hloop_Q_A(ntryL,G0H12(89),41,0,G1H12(246),n2h12(542))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1862),h0tab(:,1862),[41,6,16],[0,0,nMM],3,2,wf8(:,10),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(90),m3h8x12(:,438),heltab2x96(:,:,1830))
  call Hloop_Q_A(ntryL,G0H12(90),41,0,G1H12(249),n2h12(543))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1863),h0tab(:,1863),[41,6,16],[0,0,nML],3,2,wf8(:,10),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(91),m3h8x12(:,439),heltab2x96(:,:,1831))
  call Hloop_Q_A(ntryL,G0H12(91),41,0,G1H12(250),n2h12(544))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1864),h0tab(:,1864),[41,6,16],[nME,nME,0],3,2,wf8(:,10),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(92),m3h8x12(:,440),heltab2x96(:,:,1832))
  call Hloop_A_Q(ntryL,G0H12(92),41,nME,G1H12(253),n2h12(545))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1865),h0tab(:,1865),[41,6,16],[nMM,nMM,0],3,2,wf8(:,10),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(93),m3h8x12(:,441),heltab2x96(:,:,1833))
  call Hloop_A_Q(ntryL,G0H12(93),41,nMM,G1H12(256),n2h12(546))
  Gcoeff(:)%j = (c(228)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1866),h0tab(:,1866),[41,6,16],[nML,nML,0],3,2,wf8(:,10),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(94),m3h8x12(:,442),heltab2x96(:,:,1834))
  call Hloop_A_Q(ntryL,G0H12(94),41,nML,G1H12(257),n2h12(547))
  Gcoeff(:)%j = (c(231)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1867),h0tab(:,1867),[41,6,16],[0,0,0],3,2,wf8(:,10),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(95),m3h8x12(:,443),heltab2x96(:,:,1835))
  call Hloop_Q_A(ntryL,G0H12(95),41,0,G1H12(258),n2h12(548))
  Gcoeff(:)%j = (c(229)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1868),h0tab(:,1868),[41,6,16],[nMT,nMT,nMB],3,2,wf8(:,10),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(96),m3h8x12(:,444),heltab2x96(:,:,1836))
  call Hloop_Q_A(ntryL,G0H12(96),41,nMT,G1H12(261),n2h12(549))
  Gcoeff(:)%j = (c(231)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1869),h0tab(:,1869),[41,6,16],[0,0,0],3,2,wf8(:,10),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(49),m3h8x12(:,445),heltab2x96(:,:,1837))
  call Hloop_A_Q(ntryL,G0H12(49),41,0,G1H12(262),n2h12(550))
  Gcoeff(:)%j = (c(229)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1870),h0tab(:,1870),[41,6,16],[nMB,nMB,nMT],3,2,wf8(:,10),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H96(1),wf8(:,10),G0H12(57),m3h8x12(:,446),heltab2x96(:,:,1838))
  call Hloop_A_Q(ntryL,G0H12(57),41,nMB,G1H12(263),n2h12(551))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1871),h0tab(:,1871),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(266),m3h8x12(:,447),heltab2x96(:,:,1839))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1872),h0tab(:,1872),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(267),m3h8x12(:,448),heltab2x96(:,:,1840))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1873),h0tab(:,1873),[41,6,16],[nMZ,nMH,nMW],3,2,wf8(:,10),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(268),m3h8x12(:,449),heltab2x96(:,:,1841))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1874),h0tab(:,1874),[41,6,16],[nMH,nMZ,nMW],3,2,wf8(:,10),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(271),m3h8x12(:,450),heltab2x96(:,:,1842))
  Gcoeff(:)%j = (-(c(150)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1875),h0tab(:,1875),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(272),m3h8x12(:,451),heltab2x96(:,:,1843))
  Gcoeff(:)%j = (-(c(150)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1876),h0tab(:,1876),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(273),m3h8x12(:,452),heltab2x96(:,:,1844))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1877),h0tab(:,1877),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(276),m3h8x12(:,453),heltab2x96(:,:,1845))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1878),h0tab(:,1878),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(277),m3h8x12(:,454),heltab2x96(:,:,1846))
  Gcoeff(:)%j = (c(133)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1879),h0tab(:,1879),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(278),m3h8x12(:,455),heltab2x96(:,:,1847))
  Gcoeff(:)%j = (c(69)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1880),h0tab(:,1880),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(281),m3h8x12(:,456),heltab2x96(:,:,1848))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1881),h0tab(:,1881),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,4))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(282),m3h8x12(:,457),heltab2x96(:,:,1849))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1882),h0tab(:,1882),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,4))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(283),m3h8x12(:,458),heltab2x96(:,:,1850))
  Gcoeff(:)%j = (c(115)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1883),h0tab(:,1883),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(287),m3h8x12(:,459),heltab2x96(:,:,1851))
  Gcoeff(:)%j = (c(50)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1884),h0tab(:,1884),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(288),m3h8x12(:,460),heltab2x96(:,:,1852))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1885),h0tab(:,1885),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(289),m3h8x12(:,461),heltab2x96(:,:,1853))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1886),h0tab(:,1886),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(293),m3h8x12(:,462),heltab2x96(:,:,1854))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1887),h0tab(:,1887),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(294),m3h8x12(:,463),heltab2x96(:,:,1855))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1888),h0tab(:,1888),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(295),m3h8x12(:,464),heltab2x96(:,:,1856))
  Gcoeff(:)%j = (c(91)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1889),h0tab(:,1889),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(65),m3h8x12(:,465),heltab2x96(:,:,1857))
  Gcoeff(:)%j = (-(c(118)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1890),h0tab(:,1890),[41,6,16],[nMZ,nMH,nMW],3,2,wf8(:,10),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(97),m3h8x12(:,466),heltab2x96(:,:,1858))
  Gcoeff(:)%j = (-(c(119)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1891),h0tab(:,1891),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(1),m3h8x12(:,467),heltab2x96(:,:,1859))
  Gcoeff(:)%j = (-(c(91)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1892),h0tab(:,1892),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(298),m3h8x12(:,468),heltab2x96(:,:,1860))
  Gcoeff(:)%j = (c(118)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1893),h0tab(:,1893),[41,6,16],[nMH,nMZ,nMW],3,2,wf8(:,10),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(299),m3h8x12(:,469),heltab2x96(:,:,1861))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1894),h0tab(:,1894),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(300),m3h8x12(:,470),heltab2x96(:,:,1862))
  Gcoeff(:)%j = (c(139)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1895),h0tab(:,1895),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(2),m3h8x12(:,471),heltab2x96(:,:,1863))
  Gcoeff(:)%j = (c(144)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1896),h0tab(:,1896),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(3),m3h8x12(:,472),heltab2x96(:,:,1864))
  Gcoeff(:)%j = (c(158)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1897),h0tab(:,1897),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(4),m3h8x12(:,473),heltab2x96(:,:,1865))
  Gcoeff(:)%j = (-(c(166)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1898),h0tab(:,1898),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(5),m3h8x12(:,474),heltab2x96(:,:,1866))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1899),h0tab(:,1899),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(6),m3h8x12(:,475),heltab2x96(:,:,1867))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1900),h0tab(:,1900),[41,6,16],[nMW,nMW,nMH],3,2,wf8(:,10),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(7),m3h8x12(:,476),heltab2x96(:,:,1868))
  Gcoeff(:)%j = (c(139)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1901),h0tab(:,1901),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(303),m3h8x12(:,477),heltab2x96(:,:,1869))
  Gcoeff(:)%j = (-(c(139)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1902),h0tab(:,1902),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(304),m3h8x12(:,478),heltab2x96(:,:,1870))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1903),h0tab(:,1903),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(305),m3h8x12(:,479),heltab2x96(:,:,1871))
  Gcoeff(:)%j = (c(60)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1904),h0tab(:,1904),[41,6,16],[nMZ,nMH,nMW],3,2,wf8(:,10),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(308),m3h8x12(:,480),heltab2x96(:,:,1872))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1905),h0tab(:,1905),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(309),m3h8x12(:,481),heltab2x96(:,:,1873))
  Gcoeff(:)%j = (c(139)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1906),h0tab(:,1906),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(8),m3h8x12(:,482),heltab2x96(:,:,1874))
  Gcoeff(:)%j = (-(c(139)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1907),h0tab(:,1907),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(9),m3h8x12(:,483),heltab2x96(:,:,1875))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1908),h0tab(:,1908),[41,6,16],[nMW,nMW,0],3,2,wf8(:,10),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(24),m3h8x12(:,484),heltab2x96(:,:,1876))
  Gcoeff(:)%j = (c(60)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1909),h0tab(:,1909),[41,6,16],[nMH,nMZ,nMW],3,2,wf8(:,10),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(25),m3h8x12(:,485),heltab2x96(:,:,1877))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1910),h0tab(:,1910),[41,6,16],[nMW,nMW,nMZ],3,2,wf8(:,10),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,10),G0H12(26),m3h8x12(:,486),heltab2x96(:,:,1878))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1911),h0tab(:,1911),[40,1,22],[0,0,nMW],3,2,wf4(:,3),wf12(:,65))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(18),m3h4x24(:,633),heltab2x96(:,:,1879))
  call Hloop_A_Q(ntryL,G0H24(18),40,0,G1H24(279),n2h24(447))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1912),h0tab(:,1912),[40,1,22],[0,nMW,0],3,2,wf4(:,3),wf12(:,65))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(19),m3h4x24(:,634),heltab2x96(:,:,1880))
  call Hloop_A_Q(ntryL,G0H24(19),40,0,G1H24(280),n2h24(448))
  Gcoeff(:)%j = (-(c(117)*M(2,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1913),h0tab(:,1913),[40,1,22],[0,nMZ,nMW],3,2,wf4(:,3),wf12(:,65))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(20),m3h4x24(:,635),heltab2x96(:,:,1881))
  call Hloop_A_Q(ntryL,G0H24(20),40,0,G1H24(281),n2h24(449))
  Gcoeff(:)%j = (-(c(117)*M(2,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1914),h0tab(:,1914),[40,1,22],[0,nMW,nMZ],3,2,wf4(:,3),wf12(:,65))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(21),ngZd,m3h4x24(:,636),heltab2x96(:,:,1882))
  call Hloop_A_Q(ntryL,G0H24(21),40,0,G1H24(282),n2h24(450))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1915),h0tab(:,1915),[40,1,22],[0,0,nMW],3,2,wf4(:,3),wf12(:,66))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(38),m3h4x24(:,637),heltab2x96(:,:,1883))
  call Hloop_A_Q(ntryL,G0H24(38),40,0,G1H24(283),n2h24(451))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1916),h0tab(:,1916),[40,1,22],[0,nMW,0],3,2,wf4(:,3),wf12(:,66))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(39),m3h4x24(:,638),heltab2x96(:,:,1884))
  call Hloop_A_Q(ntryL,G0H24(39),40,0,G1H24(284),n2h24(452))
  Gcoeff(:)%j = (-(c(117)*M(2,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1917),h0tab(:,1917),[40,1,22],[0,nMZ,nMW],3,2,wf4(:,3),wf12(:,66))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(40),m3h4x24(:,639),heltab2x96(:,:,1885))
  call Hloop_A_Q(ntryL,G0H24(40),40,0,G1H24(285),n2h24(453))
  Gcoeff(:)%j = (-(c(117)*M(2,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1918),h0tab(:,1918),[40,1,22],[0,nMW,nMZ],3,2,wf4(:,3),wf12(:,66))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(41),ngZd,m3h4x24(:,640),heltab2x96(:,:,1886))
  call Hloop_A_Q(ntryL,G0H24(41),40,0,G1H24(286),n2h24(454))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1919),h0tab(:,1919),[40,1,22],[0,0,0],3,2,wf4(:,3),wf12(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(51),m3h4x24(:,641),heltab2x96(:,:,1887))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1920),h0tab(:,1920),[40,1,22],[nMZ,0,0],3,2,wf4(:,3),wf12(:,3))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,3),G0H24(68),ngZd,m3h4x24(:,642),heltab2x96(:,:,1888))
  Gcoeff(:)%j = (c(79)*M(2,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1921),h0tab(:,1921),[40,1,22],[0,0,nMW],3,2,wf4(:,3),wf12(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(8),m3h4x24(:,643),heltab2x96(:,:,1889))
  call Hloop_A_Q(ntryL,G0H24(8),40,0,G1H24(287),n2h24(455))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1922),h0tab(:,1922),[40,1,22],[0,nMW,0],3,2,wf4(:,3),wf12(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(9),m3h4x24(:,644),heltab2x96(:,:,1890))
  call Hloop_A_Q(ntryL,G0H24(9),40,0,G1H24(288),n2h24(456))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1923),h0tab(:,1923),[40,1,22],[0,nMZ,nMW],3,2,wf4(:,3),wf12(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(10),m3h4x24(:,645),heltab2x96(:,:,1891))
  call Hloop_A_Q(ntryL,G0H24(10),40,0,G1H24(289),n2h24(457))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1924),h0tab(:,1924),[40,1,22],[0,nMW,nMZ],3,2,wf4(:,3),wf12(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(42),ngZd,m3h4x24(:,646),heltab2x96(:,:,1892))
  call Hloop_A_Q(ntryL,G0H24(42),40,0,G1H24(290),n2h24(458))
  Gcoeff(:)%j = (c(138)*M(2,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1925),h0tab(:,1925),[40,1,22],[0,0,nMW],3,2,wf4(:,3),wf12(:,67))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(43),m3h4x24(:,647),heltab2x96(:,:,1893))
  call Hloop_A_Q(ntryL,G0H24(43),40,0,G1H24(291),n2h24(459))
  Gcoeff(:)%j = (-(c(137)*M(2,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1926),h0tab(:,1926),[40,1,22],[0,nMW,0],3,2,wf4(:,3),wf12(:,67))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(44),m3h4x24(:,648),heltab2x96(:,:,1894))
  call Hloop_A_Q(ntryL,G0H24(44),40,0,G1H24(292),n2h24(460))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1927),h0tab(:,1927),[40,1,22],[0,nMZ,nMW],3,2,wf4(:,3),wf12(:,67))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(45),m3h4x24(:,649),heltab2x96(:,:,1895))
  call Hloop_A_Q(ntryL,G0H24(45),40,0,G1H24(293),n2h24(461))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1928),h0tab(:,1928),[40,1,22],[0,nMW,nMZ],3,2,wf4(:,3),wf12(:,67))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(56),ngZd,m3h4x24(:,650),heltab2x96(:,:,1896))
  call Hloop_A_Q(ntryL,G0H24(56),40,0,G1H24(294),n2h24(462))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1929),h0tab(:,1929),[40,1,22],[0,0,nMW],3,2,wf4(:,3),wf12(:,68))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(61),m3h4x24(:,651),heltab2x96(:,:,1897))
  call Hloop_A_Q(ntryL,G0H24(61),40,0,G1H24(295),n2h24(463))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1930),h0tab(:,1930),[40,1,22],[0,nMW,0],3,2,wf4(:,3),wf12(:,68))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(62),m3h4x24(:,652),heltab2x96(:,:,1898))
  call Hloop_A_Q(ntryL,G0H24(62),40,0,G1H24(296),n2h24(464))
  Gcoeff(:)%j = (c(145)*M(2,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1931),h0tab(:,1931),[40,1,22],[0,nMZ,nMW],3,2,wf4(:,3),wf12(:,68))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(66),m3h4x24(:,653),heltab2x96(:,:,1899))
  call Hloop_A_Q(ntryL,G0H24(66),40,0,G1H24(297),n2h24(465))
  Gcoeff(:)%j = (c(145)*M(2,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1932),h0tab(:,1932),[40,1,22],[0,nMW,nMZ],3,2,wf4(:,3),wf12(:,68))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(67),ngZd,m3h4x24(:,654),heltab2x96(:,:,1900))
  call Hloop_A_Q(ntryL,G0H24(67),40,0,G1H24(298),n2h24(466))
  Gcoeff(:)%j = (c(127)*M(2,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1933),h0tab(:,1933),[40,1,22],[0,0,0],3,2,wf4(:,3),wf12(:,4))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(23),m3h4x24(:,655),heltab2x96(:,:,1901))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1934),h0tab(:,1934),[40,1,22],[nMZ,0,0],3,2,wf4(:,3),wf12(:,4))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,3),G0H24(28),ngZd,m3h4x24(:,656),heltab2x96(:,:,1902))
  Gcoeff(:)%j = (c(111)*M(2,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1935),h0tab(:,1935),[40,1,22],[0,0,0],3,2,wf4(:,3),wf12(:,5))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(46),m3h4x24(:,657),heltab2x96(:,:,1903))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1936),h0tab(:,1936),[40,1,22],[nMZ,0,0],3,2,wf4(:,3),wf12(:,5))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,3),G0H24(47),ngZd,m3h4x24(:,658),heltab2x96(:,:,1904))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1937),h0tab(:,1937),[40,1,22],[0,0,nMW],3,2,wf4(:,3),wf12(:,4))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(50),m3h4x24(:,659),heltab2x96(:,:,1905))
  call Hloop_A_Q(ntryL,G0H24(50),40,0,G1H24(299),n2h24(467))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1938),h0tab(:,1938),[40,1,22],[0,nMW,0],3,2,wf4(:,3),wf12(:,4))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(52),m3h4x24(:,660),heltab2x96(:,:,1906))
  call Hloop_A_Q(ntryL,G0H24(52),40,0,G1H24(300),n2h24(468))
  Gcoeff(:)%j = (-(c(114)*M(2,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1939),h0tab(:,1939),[40,1,22],[0,nMZ,nMW],3,2,wf4(:,3),wf12(:,4))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(53),m3h4x24(:,661),heltab2x96(:,:,1907))
  call Hloop_A_Q(ntryL,G0H24(53),40,0,G1H24(301),n2h24(469))
  Gcoeff(:)%j = (-(c(114)*M(2,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1940),h0tab(:,1940),[40,1,22],[0,nMW,nMZ],3,2,wf4(:,3),wf12(:,4))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(59),ngZd,m3h4x24(:,662),heltab2x96(:,:,1908))
  call Hloop_A_Q(ntryL,G0H24(59),40,0,G1H24(302),n2h24(470))
  Gcoeff(:)%j = (-(c(114)*M(2,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1941),h0tab(:,1941),[40,1,22],[0,0,nMW],3,2,wf4(:,3),wf12(:,5))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(27),m3h4x24(:,663),heltab2x96(:,:,1909))
  call Hloop_A_Q(ntryL,G0H24(27),40,0,G1H24(303),n2h24(471))
  Gcoeff(:)%j = (c(112)*M(2,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1942),h0tab(:,1942),[40,1,22],[0,nMW,0],3,2,wf4(:,3),wf12(:,5))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(34),m3h4x24(:,664),heltab2x96(:,:,1910))
  call Hloop_A_Q(ntryL,G0H24(34),40,0,G1H24(304),n2h24(472))
  Gcoeff(:)%j = (-(c(70)*M(2,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1943),h0tab(:,1943),[40,1,22],[0,nMZ,nMW],3,2,wf4(:,3),wf12(:,5))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(37),m3h4x24(:,665),heltab2x96(:,:,1911))
  call Hloop_A_Q(ntryL,G0H24(37),40,0,G1H24(305),n2h24(473))
  Gcoeff(:)%j = (-(c(70)*M(2,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1944),h0tab(:,1944),[40,1,22],[0,nMW,nMZ],3,2,wf4(:,3),wf12(:,5))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(48),ngZd,m3h4x24(:,666),heltab2x96(:,:,1912))
  call Hloop_A_Q(ntryL,G0H24(48),40,0,G1H24(306),n2h24(474))
  Gcoeff(:)%j = (c(82)*M(2,:)%j) * den(386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1945),h0tab(:,1945),[56,1,6],[0,nMZ,nMZ],3,2,wf12(:,46),wf4(:,7))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf12(:,46),G0H8(5),ngZu,m3h12x8(:,83),heltab2x96(:,:,1913))
  call Hloop_A_Q(ntryL,G0H8(5),56,0,G1H8(56),n2h8(97))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1946),h0tab(:,1946),[56,1,6],[0,nMW,nMW],3,2,wf12(:,46),wf4(:,7))
  call Hloop_WA_Q(ntryL,G0H96(1),wf12(:,46),G0H8(6),m3h12x8(:,84),heltab2x96(:,:,1914))
  call Hloop_A_Q(ntryL,G0H8(6),56,0,G1H8(59),n2h8(98))
  Gcoeff(:)%j = (-(c(128)*M(2,:)%j)) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1947),h0tab(:,1947),[56,1,6],[0,0,0],3,2,wf12(:,46),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,46),G0H8(7),m3h12x8(:,85),heltab2x96(:,:,1915))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1948),h0tab(:,1948),[56,1,6],[nMZ,0,0],3,2,wf12(:,46),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H96(1),wf12(:,46),G0H8(10),ngZu,m3h12x8(:,86),heltab2x96(:,:,1916))
  Gcoeff(:)%j = (c(97)*M(2,:)%j) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1949),h0tab(:,1949),[56,1,6],[nMW,0,0],3,2,wf12(:,46),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H96(1),wf12(:,46),G0H8(11),m3h12x8(:,87),heltab2x96(:,:,1917))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1950),h0tab(:,1950),[56,1,6],[0,0,0],3,2,wf12(:,46),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,46),G0H8(18),m3h12x8(:,88),heltab2x96(:,:,1918))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1951),h0tab(:,1951),[56,1,6],[nMZ,0,0],3,2,wf12(:,46),wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H96(1),wf12(:,46),G0H8(19),ngZu,m3h12x8(:,89),heltab2x96(:,:,1919))
  Gcoeff(:)%j = (-(c(101)*M(2,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1952),h0tab(:,1952),[56,1,6],[nMW,0,0],3,2,wf12(:,46),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H96(1),wf12(:,46),G0H8(22),m3h12x8(:,90),heltab2x96(:,:,1920))
  Gcoeff(:)%j = (-(c(100)*M(2,:)%j)) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1953),h0tab(:,1953),[56,1,6],[0,nMW,nMW],3,2,wf12(:,46),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H96(1),wf12(:,46),G0H8(23),m3h12x8(:,91),heltab2x96(:,:,1921))
  call Hloop_A_Q(ntryL,G0H8(23),56,0,G1H8(62),n2h8(99))
  Gcoeff(:)%j = (-(c(63)*M(2,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1954),h0tab(:,1954),[56,1,6],[0,nMW,nMW],3,2,wf12(:,46),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H96(1),wf12(:,46),G0H8(24),m3h12x8(:,92),heltab2x96(:,:,1922))
  call Hloop_A_Q(ntryL,G0H8(24),56,0,G1H8(65),n2h8(100))
  Gcoeff(:)%j = (-(c(123)*M(2,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1955),h0tab(:,1955),[46,1,16],[0,0,0],3,1,wf16(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,10),G0H6(1),m3h16x6(:,13),heltab2x96(:,:,1923))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1956),h0tab(:,1956),[46,1,16],[nMZ,0,0],3,1,wf16(:,10))
  call Hloop_QA_Z(ntryL,G0H96(1),wf16(:,10),G0H6(9),ngZd,m3h16x6(:,14),heltab2x96(:,:,1924))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1957),h0tab(:,1957),[46,1,16],[0,0,0],3,1,wf16(:,12))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,12),G0H6(10),m3h16x6(:,15),heltab2x96(:,:,1925))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1958),h0tab(:,1958),[46,1,16],[nMZ,0,0],3,1,wf16(:,12))
  call Hloop_QA_Z(ntryL,G0H96(1),wf16(:,12),G0H6(11),ngZd,m3h16x6(:,16),heltab2x96(:,:,1926))
  Gcoeff(:)%j = (c(127)*M(2,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1959),h0tab(:,1959),[46,1,16],[0,0,nMW],3,1,wf16(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,10),G0H6(13),m3h16x6(:,17),heltab2x96(:,:,1927))
  call Hloop_A_Q(ntryL,G0H6(13),46,0,G1H6(238),n2h6(326))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1960),h0tab(:,1960),[46,1,16],[0,nMW,0],3,1,wf16(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,10),G0H6(3),m3h16x6(:,18),heltab2x96(:,:,1928))
  call Hloop_A_Q(ntryL,G0H6(3),46,0,G1H6(14),n2h6(327))
  Gcoeff(:)%j = (c(111)*M(2,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1961),h0tab(:,1961),[46,1,16],[0,nMZ,nMW],3,1,wf16(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,10),G0H6(14),m3h16x6(:,19),heltab2x96(:,:,1929))
  call Hloop_A_Q(ntryL,G0H6(14),46,0,G1H6(293),n2h6(328))
  Gcoeff(:)%j = (c(111)*M(2,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1962),h0tab(:,1962),[46,1,16],[0,nMW,nMZ],3,1,wf16(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf16(:,10),G0H6(12),ngZd,m3h16x6(:,20),heltab2x96(:,:,1930))
  call Hloop_A_Q(ntryL,G0H6(12),46,0,G1H6(20),n2h6(329))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1963),h0tab(:,1963),[46,1,16],[0,0,nMW],3,1,wf16(:,12))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,12),G0H6(6),m3h16x6(:,21),heltab2x96(:,:,1931))
  call Hloop_A_Q(ntryL,G0H6(6),46,0,G1H6(155),n2h6(330))
  Gcoeff(:)%j = (c(131)*M(2,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1964),h0tab(:,1964),[46,1,16],[0,nMW,0],3,1,wf16(:,12))
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,12),G0H6(4),m3h16x6(:,22),heltab2x96(:,:,1932))
  call Hloop_A_Q(ntryL,G0H6(4),46,0,G1H6(115),n2h6(331))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1965),h0tab(:,1965),[46,1,16],[0,nMZ,nMW],3,1,wf16(:,12))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,12),G0H6(8),m3h16x6(:,23),heltab2x96(:,:,1933))
  call Hloop_A_Q(ntryL,G0H6(8),46,0,G1H6(284),n2h6(332))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1966),h0tab(:,1966),[46,1,16],[0,nMW,nMZ],3,1,wf16(:,12))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf16(:,12),G0H6(5),ngZd,m3h16x6(:,24),heltab2x96(:,:,1934))
  call Hloop_A_Q(ntryL,G0H6(5),46,0,G1H6(88),n2h6(333))
  Gcoeff(:)%j = (-(c(123)*M(2,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1967),h0tab(:,1967),[32,8,23],[0,0,0],3,1,wf24(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,667),heltab2x96(:,:,1935))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(21),n2h48(667))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1968),h0tab(:,1968),[32,8,23],[0,nMZ,0],3,1,wf24(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,668),heltab2x96(:,:,1936))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(22),n2h48(668))
  Gcoeff(:)%j = (-(c(99)*M(2,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1969),h0tab(:,1969),[32,8,23],[0,nMW,0],3,1,wf24(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,669),heltab2x96(:,:,1937))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(23),n2h48(669))
  Gcoeff(:)%j = (-(c(126)*M(2,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1970),h0tab(:,1970),[32,8,23],[0,0,0],3,1,wf24(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,670),heltab2x96(:,:,1938))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(24),n2h48(670))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1971),h0tab(:,1971),[32,8,23],[0,nMZ,0],3,1,wf24(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,671),heltab2x96(:,:,1939))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(25),n2h48(671))
  Gcoeff(:)%j = (-(c(101)*M(2,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1972),h0tab(:,1972),[32,8,23],[0,nMW,0],3,1,wf24(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,672),heltab2x96(:,:,1940))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(26),n2h48(672))
  Gcoeff(:)%j = (c(125)*M(2,:)%j) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1973),h0tab(:,1973),[39,8,16],[0,0,0],3,1,wf16(:,18))
  call Hloop_AQ_V(ntryL,G0H96(1),wf16(:,18),G0H6(7),m3h16x6(:,25),heltab2x96(:,:,1941))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1974),h0tab(:,1974),[39,8,16],[nMZ,0,0],3,1,wf16(:,18))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf16(:,18),G0H6(13),ngZu,m3h16x6(:,26),heltab2x96(:,:,1942))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1975),h0tab(:,1975),[39,8,16],[0,0,0],3,1,wf16(:,20))
  call Hloop_AQ_V(ntryL,G0H96(1),wf16(:,20),G0H6(3),m3h16x6(:,27),heltab2x96(:,:,1943))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1976),h0tab(:,1976),[39,8,16],[nMZ,0,0],3,1,wf16(:,20))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf16(:,20),G0H6(14),ngZu,m3h16x6(:,28),heltab2x96(:,:,1944))
  Gcoeff(:)%j = (-(c(130)*M(2,:)%j)) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1977),h0tab(:,1977),[39,8,16],[0,nMW,0],3,1,wf16(:,18))
  call Hloop_VQ_A(ntryL,G0H96(1),wf16(:,18),G0H6(12),m3h16x6(:,29),heltab2x96(:,:,1945))
  call Hloop_Q_A(ntryL,G0H6(12),39,0,G1H6(120),n2h6(334))
  Gcoeff(:)%j = (c(127)*M(2,:)%j) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1978),h0tab(:,1978),[39,8,16],[0,0,nMW],3,1,wf16(:,18))
  call Hloop_WQ_A(ntryL,G0H96(1),wf16(:,18),G0H6(6),m3h16x6(:,30),heltab2x96(:,:,1946))
  call Hloop_Q_A(ntryL,G0H6(6),39,0,G1H6(197),n2h6(335))
  Gcoeff(:)%j = (-(c(113)*M(2,:)%j)) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1979),h0tab(:,1979),[39,8,16],[0,nMW,nMZ],3,1,wf16(:,18))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf16(:,18),G0H6(4),ngZu,m3h16x6(:,31),heltab2x96(:,:,1947))
  call Hloop_Q_A(ntryL,G0H6(4),39,0,G1H6(231),n2h6(336))
  Gcoeff(:)%j = (-(c(113)*M(2,:)%j)) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1980),h0tab(:,1980),[39,8,16],[0,nMZ,nMW],3,1,wf16(:,18))
  call Hloop_WQ_A(ntryL,G0H96(1),wf16(:,18),G0H6(8),m3h16x6(:,32),heltab2x96(:,:,1948))
  call Hloop_Q_A(ntryL,G0H6(8),39,0,G1H6(128),n2h6(337))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1981),h0tab(:,1981),[39,8,16],[0,nMW,0],3,1,wf16(:,20))
  call Hloop_VQ_A(ntryL,G0H96(1),wf16(:,20),G0H6(5),m3h16x6(:,33),heltab2x96(:,:,1949))
  call Hloop_Q_A(ntryL,G0H6(5),39,0,G1H6(133),n2h6(338))
  Gcoeff(:)%j = (c(131)*M(2,:)%j) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1982),h0tab(:,1982),[39,8,16],[0,0,nMW],3,1,wf16(:,20))
  call Hloop_WQ_A(ntryL,G0H96(1),wf16(:,20),G0H6(12),m3h16x6(:,34),heltab2x96(:,:,1950))
  call Hloop_Q_A(ntryL,G0H6(12),39,0,G1H6(87),n2h6(339))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1983),h0tab(:,1983),[39,8,16],[0,nMW,nMZ],3,1,wf16(:,20))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf16(:,20),G0H6(6),ngZu,m3h16x6(:,35),heltab2x96(:,:,1951))
  call Hloop_Q_A(ntryL,G0H6(6),39,0,G1H6(89),n2h6(340))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1984),h0tab(:,1984),[39,8,16],[0,nMZ,nMW],3,1,wf16(:,20))
  call Hloop_WQ_A(ntryL,G0H96(1),wf16(:,20),G0H6(4),m3h16x6(:,36),heltab2x96(:,:,1952))
  call Hloop_Q_A(ntryL,G0H6(4),39,0,G1H6(93),n2h6(341))
  Gcoeff(:)%j = (c(73)*M(2,:)%j) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1985),h0tab(:,1985),[32,8,23],[0,0,0],3,1,wf24(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,673),heltab2x96(:,:,1953))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(27),n2h48(673))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1986),h0tab(:,1986),[32,8,23],[0,nMZ,0],3,1,wf24(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,674),heltab2x96(:,:,1954))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(28),n2h48(674))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1987),h0tab(:,1987),[32,8,23],[0,nMW,0],3,1,wf24(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,675),heltab2x96(:,:,1955))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(29),n2h48(675))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1988),h0tab(:,1988),[32,8,23],[0,0,0],3,1,wf24(:,33))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,676),heltab2x96(:,:,1956))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(30),n2h48(676))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1989),h0tab(:,1989),[32,8,23],[0,nMZ,0],3,1,wf24(:,33))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,677),heltab2x96(:,:,1957))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(31),n2h48(677))
  Gcoeff(:)%j = (-(c(100)*M(2,:)%j)) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1990),h0tab(:,1990),[32,8,23],[0,nMW,0],3,1,wf24(:,33))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,678),heltab2x96(:,:,1958))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(32),n2h48(678))
  Gcoeff(:)%j = (-(c(110)*M(2,:)%j)) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1991),h0tab(:,1991),[32,8,23],[0,0,0],3,1,wf24(:,35))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,679),heltab2x96(:,:,1959))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(33),n2h48(679))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1992),h0tab(:,1992),[32,8,23],[0,nMZ,0],3,1,wf24(:,35))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,680),heltab2x96(:,:,1960))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(34),n2h48(680))
  Gcoeff(:)%j = (-(c(63)*M(2,:)%j)) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1993),h0tab(:,1993),[32,8,23],[0,nMW,0],3,1,wf24(:,35))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,681),heltab2x96(:,:,1961))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(35),n2h48(681))
  Gcoeff(:)%j = (c(125)*M(2,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1994),h0tab(:,1994),[32,1,30],[0,0,0],3,1,wf24(:,37))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,682),heltab2x96(:,:,1962))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(36),n2h48(682))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1995),h0tab(:,1995),[32,1,30],[0,nMZ,0],3,1,wf24(:,37))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,683),heltab2x96(:,:,1963))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(37),n2h48(683))
  Gcoeff(:)%j = (c(97)*M(2,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1996),h0tab(:,1996),[32,1,30],[0,nMW,0],3,1,wf24(:,37))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,684),heltab2x96(:,:,1964))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(38),n2h48(684))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(315)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1997),h0tab(:,1997),[32,1,30],[0,0,0],3,1,wf24(:,39))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,685),heltab2x96(:,:,1965))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(39),n2h48(685))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(315)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1998),h0tab(:,1998),[32,1,30],[0,nMZ,0],3,1,wf24(:,39))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,686),heltab2x96(:,:,1966))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(40),n2h48(686))
  Gcoeff(:)%j = (-(c(101)*M(2,:)%j)) * den(315)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1999),h0tab(:,1999),[32,1,30],[0,nMW,0],3,1,wf24(:,39))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,687),heltab2x96(:,:,1967))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(41),n2h48(687))
  Gcoeff(:)%j = (-(c(123)*M(2,:)%j)) * den(316)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2000),h0tab(:,2000),[46,1,16],[0,0,0],3,1,wf16(:,22))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,22),G0H6(8),m3h16x6(:,37),heltab2x96(:,:,1968))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(316)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2001),h0tab(:,2001),[46,1,16],[nMZ,0,0],3,1,wf16(:,22))
  call Hloop_QA_Z(ntryL,G0H96(1),wf16(:,22),G0H6(5),ngZd,m3h16x6(:,38),heltab2x96(:,:,1969))
  Gcoeff(:)%j = (c(129)*M(2,:)%j) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2002),h0tab(:,2002),[46,1,16],[0,0,0],3,1,wf16(:,24))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,24),G0H6(12),m3h16x6(:,39),heltab2x96(:,:,1970))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2003),h0tab(:,2003),[46,1,16],[nMZ,0,0],3,1,wf16(:,24))
  call Hloop_QA_Z(ntryL,G0H96(1),wf16(:,24),G0H6(6),ngZd,m3h16x6(:,40),heltab2x96(:,:,1971))
  Gcoeff(:)%j = (c(127)*M(2,:)%j) * den(316)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2004),h0tab(:,2004),[46,1,16],[0,0,nMW],3,1,wf16(:,22))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,22),G0H6(4),m3h16x6(:,41),heltab2x96(:,:,1972))
  call Hloop_A_Q(ntryL,G0H6(4),46,0,G1H6(227),n2h6(342))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(316)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2005),h0tab(:,2005),[46,1,16],[0,nMW,0],3,1,wf16(:,22))
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,22),G0H6(4),m3h16x6(:,42),heltab2x96(:,:,1973))
  call Hloop_A_Q(ntryL,G0H6(4),46,0,G1H6(8),n2h6(343))
  Gcoeff(:)%j = (c(111)*M(2,:)%j) * den(316)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2006),h0tab(:,2006),[46,1,16],[0,nMZ,nMW],3,1,wf16(:,22))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,22),G0H6(4),m3h16x6(:,43),heltab2x96(:,:,1974))
  call Hloop_A_Q(ntryL,G0H6(4),46,0,G1H6(44),n2h6(344))
  Gcoeff(:)%j = (c(111)*M(2,:)%j) * den(316)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2007),h0tab(:,2007),[46,1,16],[0,nMW,nMZ],3,1,wf16(:,22))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf16(:,22),G0H6(4),ngZd,m3h16x6(:,44),heltab2x96(:,:,1975))
  call Hloop_A_Q(ntryL,G0H6(4),46,0,G1H6(187),n2h6(345))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2008),h0tab(:,2008),[46,1,16],[0,0,nMW],3,1,wf16(:,24))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,24),G0H6(4),m3h16x6(:,45),heltab2x96(:,:,1976))
  call Hloop_A_Q(ntryL,G0H6(4),46,0,G1H6(140),n2h6(346))
  Gcoeff(:)%j = (c(131)*M(2,:)%j) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2009),h0tab(:,2009),[46,1,16],[0,nMW,0],3,1,wf16(:,24))
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,24),G0H6(4),m3h16x6(:,46),heltab2x96(:,:,1977))
  call Hloop_A_Q(ntryL,G0H6(4),46,0,G1H6(103),n2h6(347))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2010),h0tab(:,2010),[46,1,16],[0,nMZ,nMW],3,1,wf16(:,24))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,24),G0H6(4),m3h16x6(:,47),heltab2x96(:,:,1978))
  call Hloop_A_Q(ntryL,G0H6(4),46,0,G1H6(110),n2h6(348))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2011),h0tab(:,2011),[46,1,16],[0,nMW,nMZ],3,1,wf16(:,24))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf16(:,24),G0H6(4),ngZd,m3h16x6(:,48),heltab2x96(:,:,1979))
  call Hloop_A_Q(ntryL,G0H6(4),46,0,G1H6(255),n2h6(349))
  Gcoeff(:)%j = (c(77)*M(2,:)%j) * den(318)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2012),h0tab(:,2012),[32,1,30],[0,0,0],3,1,wf24(:,41))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,688),heltab2x96(:,:,1980))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(42),n2h48(688))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(318)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2013),h0tab(:,2013),[32,1,30],[0,nMZ,0],3,1,wf24(:,41))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,689),heltab2x96(:,:,1981))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(43),n2h48(689))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(318)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2014),h0tab(:,2014),[32,1,30],[0,nMW,0],3,1,wf24(:,41))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,690),heltab2x96(:,:,1982))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(44),n2h48(690))
  Gcoeff(:)%j = (-(c(130)*M(2,:)%j)) * den(319)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2015),h0tab(:,2015),[32,1,30],[0,0,0],3,1,wf24(:,43))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,691),heltab2x96(:,:,1983))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(45),n2h48(691))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(319)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2016),h0tab(:,2016),[32,1,30],[0,nMZ,0],3,1,wf24(:,43))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,692),heltab2x96(:,:,1984))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(46),n2h48(692))
  Gcoeff(:)%j = (-(c(100)*M(2,:)%j)) * den(319)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2017),h0tab(:,2017),[32,1,30],[0,nMW,0],3,1,wf24(:,43))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,693),heltab2x96(:,:,1985))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(47),n2h48(693))
  Gcoeff(:)%j = (-(c(113)*M(2,:)%j)) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2018),h0tab(:,2018),[32,1,30],[0,0,0],3,1,wf24(:,45))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,694),heltab2x96(:,:,1986))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(48),n2h48(694))
  Gcoeff(:)%j = (-(c(115)*M(2,:)%j)) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2019),h0tab(:,2019),[32,1,30],[0,nMZ,0],3,1,wf24(:,45))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,695),heltab2x96(:,:,1987))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(49),n2h48(695))
  Gcoeff(:)%j = (-(c(63)*M(2,:)%j)) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2020),h0tab(:,2020),[32,1,30],[0,nMW,0],3,1,wf24(:,45))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,696),heltab2x96(:,:,1988))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(50),n2h48(696))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2021),h0tab(:,2021),[36,9,18],[nMT,nMB,nMH],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(49),ngH,m3h4x24(:,667),heltab2x96(:,:,1989))
  call Hloop_A_Q(ntryL,G0H24(49),36,nMT,G1H24(307),n2h24(475))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2022),h0tab(:,2022),[36,9,18],[nMT,nMB,nMZ],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(54),ngX,m3h4x24(:,668),heltab2x96(:,:,1990))
  call Hloop_A_Q(ntryL,G0H24(54),36,nMT,G1H24(308),n2h24(476))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2023),h0tab(:,2023),[36,9,18],[nMH,nMW,nMT],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(58),ngH,m3h4x24(:,669),heltab2x96(:,:,1991))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2024),h0tab(:,2024),[36,9,18],[nMW,nMH,nMB],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(11),ngPtb,m3h4x24(:,670),heltab2x96(:,:,1992))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2025),h0tab(:,2025),[36,9,18],[nMZ,nMW,nMT],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(22),ngX,m3h4x24(:,671),heltab2x96(:,:,1993))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2026),h0tab(:,2026),[36,9,18],[nMW,nMZ,nMB],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(26),ngPtb,m3h4x24(:,672),heltab2x96(:,:,1994))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2027),h0tab(:,2027),[36,9,18],[nMT,nMB,0],3,3,wf4(:,10),wf4(:,8),wf6(:,6))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(32),m3h4x24(:,673),heltab2x96(:,:,1995))
  call Hloop_A_Q(ntryL,G0H24(32),36,nMT,G1H24(309),n2h24(477))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2028),h0tab(:,2028),[36,9,18],[nMT,nMB,nMZ],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(33),ngZu,m3h4x24(:,674),heltab2x96(:,:,1996))
  call Hloop_A_Q(ntryL,G0H24(33),36,nMT,G1H24(310),n2h24(478))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2029),h0tab(:,2029),[36,9,18],[0,nMW,nMT],3,3,wf4(:,10),wf4(:,8),wf6(:,6))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(31),m3h4x24(:,675),heltab2x96(:,:,1997))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2030),h0tab(:,2030),[36,9,18],[nMZ,nMW,nMT],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,10),G0H24(70),ngZu,m3h4x24(:,676),heltab2x96(:,:,1998))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2031),h0tab(:,2031),[36,9,18],[nMW,nMH,nMB],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,677),heltab2x96(:,:,1999))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2032),h0tab(:,2032),[36,9,18],[nMW,0,nMB],3,3,wf4(:,10),wf4(:,8),wf6(:,6))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(72),ngPtb,m3h4x24(:,678),heltab2x96(:,:,2000))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2033),h0tab(:,2033),[36,9,18],[nMW,nMZ,nMB],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(75),ngPtb,m3h4x24(:,679),heltab2x96(:,:,2001))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2034),h0tab(:,2034),[36,9,18],[nMH,nMW,nMT],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(76),ngH,m3h4x24(:,680),heltab2x96(:,:,2002))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2035),h0tab(:,2035),[36,9,18],[0,nMW,nMT],3,3,wf4(:,10),wf4(:,8),wf6(:,6))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(77),m3h4x24(:,681),heltab2x96(:,:,2003))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2036),h0tab(:,2036),[36,9,18],[nMW,0,nMB],3,3,wf4(:,10),wf4(:,8),wf6(:,6))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(78),m3h4x24(:,682),heltab2x96(:,:,2004))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2037),h0tab(:,2037),[36,9,18],[nMZ,nMW,nMT],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,10),G0H24(79),ngZu,m3h4x24(:,683),heltab2x96(:,:,2005))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2038),h0tab(:,2038),[36,9,18],[nMW,nMZ,nMB],3,3,wf4(:,10),wf4(:,8),wf6(: &
    ,6))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(80),m3h4x24(:,684),heltab2x96(:,:,2006))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2039),h0tab(:,2039),[32,13,18],[nMB,nMH,nMB],3,2,wf8(:,12),wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,697),heltab2x96(:,:,2007))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(51),n2h48(697))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2040),h0tab(:,2040),[32,13,18],[nMB,nMZ,nMB],3,2,wf8(:,12),wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,698),heltab2x96(:,:,2008))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(52),n2h48(698))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2041),h0tab(:,2041),[32,13,18],[nMT,nMW,nMT],3,2,wf8(:,12),wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,699),heltab2x96(:,:,2009))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(53),n2h48(699))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2042),h0tab(:,2042),[32,13,18],[nMB,0,nMB],3,2,wf8(:,12),wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,700),heltab2x96(:,:,2010))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(54),n2h48(700))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2043),h0tab(:,2043),[32,13,18],[nMB,nMZ,nMB],3,2,wf8(:,12),wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,701),heltab2x96(:,:,2011))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(55),n2h48(701))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2044),h0tab(:,2044),[32,13,18],[nMT,nMW,nMT],3,2,wf8(:,12),wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,702),heltab2x96(:,:,2012))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(56),n2h48(702))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2045),h0tab(:,2045),[50,4,9],[nMH,nMT,nMB],3,2,wf12(:,36),wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H96(1),wf12(:,36),G0H8(25),ngH,m3h12x8(:,93),heltab2x96(:,:,2013))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2046),h0tab(:,2046),[50,4,9],[nMZ,nMT,nMB],3,2,wf12(:,36),wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H96(1),wf12(:,36),G0H8(26),ngX,m3h12x8(:,94),heltab2x96(:,:,2014))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2047),h0tab(:,2047),[50,4,9],[nMT,nMH,nMW],3,2,wf12(:,36),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(2),ngPtb,m3h12x8(:,95),heltab2x96(:,:,2015))
  call Hloop_Q_A(ntryL,G0H8(2),50,nMT,G1H8(66),n2h8(101))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2048),h0tab(:,2048),[50,4,9],[nMB,nMW,nMH],3,2,wf12(:,36),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(5),ngH,m3h12x8(:,96),heltab2x96(:,:,2016))
  call Hloop_Q_A(ntryL,G0H8(5),50,nMB,G1H8(67),n2h8(102))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2049),h0tab(:,2049),[50,4,9],[nMT,nMZ,nMW],3,2,wf12(:,36),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(6),ngPtb,m3h12x8(:,97),heltab2x96(:,:,2017))
  call Hloop_Q_A(ntryL,G0H8(6),50,nMT,G1H8(72),n2h8(103))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2050),h0tab(:,2050),[50,4,9],[nMB,nMW,nMZ],3,2,wf12(:,36),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(23),ngX,m3h12x8(:,98),heltab2x96(:,:,2018))
  call Hloop_Q_A(ntryL,G0H8(23),50,nMB,G1H8(73),n2h8(104))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2051),h0tab(:,2051),[50,4,9],[0,nMT,nMB],3,2,wf12(:,36),wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,36),G0H8(24),m3h12x8(:,99),heltab2x96(:,:,2019))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2052),h0tab(:,2052),[50,4,9],[nMZ,nMT,nMB],3,2,wf12(:,36),wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf12(:,36),G0H8(2),ngZd,m3h12x8(:,100),heltab2x96(:,:,2020))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2053),h0tab(:,2053),[50,4,9],[nMB,nMW,0],3,2,wf12(:,36),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(5),m3h12x8(:,101),heltab2x96(:,:,2021))
  call Hloop_Q_A(ntryL,G0H8(5),50,nMB,G1H8(74),n2h8(105))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2054),h0tab(:,2054),[50,4,9],[nMB,nMW,nMZ],3,2,wf12(:,36),wf4(:,8))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(6),ngZd,m3h12x8(:,102),heltab2x96(:,:,2022))
  call Hloop_Q_A(ntryL,G0H8(6),50,nMB,G1H8(77),n2h8(106))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2055),h0tab(:,2055),[50,4,9],[nMT,nMH,nMW],3,2,wf12(:,36),wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(23),m3h12x8(:,103),heltab2x96(:,:,2023))
  call Hloop_Q_A(ntryL,G0H8(23),50,nMT,G1H8(10),n2h8(107))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2056),h0tab(:,2056),[50,4,9],[nMT,0,nMW],3,2,wf12(:,36),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(5),ngPtb,m3h12x8(:,104),heltab2x96(:,:,2024))
  call Hloop_Q_A(ntryL,G0H8(5),50,nMT,G1H8(81),n2h8(108))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2057),h0tab(:,2057),[50,4,9],[nMT,nMZ,nMW],3,2,wf12(:,36),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(6),ngPtb,m3h12x8(:,105),heltab2x96(:,:,2025))
  call Hloop_Q_A(ntryL,G0H8(6),50,nMT,G1H8(82),n2h8(109))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2058),h0tab(:,2058),[50,4,9],[nMB,nMW,nMH],3,2,wf12(:,36),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(23),ngH,m3h12x8(:,106),heltab2x96(:,:,2026))
  call Hloop_Q_A(ntryL,G0H8(23),50,nMB,G1H8(83),n2h8(110))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2059),h0tab(:,2059),[50,4,9],[nMT,0,nMW],3,2,wf12(:,36),wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(5),m3h12x8(:,107),heltab2x96(:,:,2027))
  call Hloop_Q_A(ntryL,G0H8(5),50,nMT,G1H8(88),n2h8(111))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2060),h0tab(:,2060),[50,4,9],[nMB,nMW,0],3,2,wf12(:,36),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(6),m3h12x8(:,108),heltab2x96(:,:,2028))
  call Hloop_Q_A(ntryL,G0H8(6),50,nMB,G1H8(89),n2h8(112))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2061),h0tab(:,2061),[50,4,9],[nMT,nMZ,nMW],3,2,wf12(:,36),wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(23),m3h12x8(:,109),heltab2x96(:,:,2029))
  call Hloop_Q_A(ntryL,G0H8(23),50,nMT,G1H8(90),n2h8(113))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2062),h0tab(:,2062),[50,4,9],[nMB,nMW,nMZ],3,2,wf12(:,36),wf4(:,8))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,36),G0H8(5),ngZd,m3h12x8(:,110),heltab2x96(:,:,2030))
  call Hloop_Q_A(ntryL,G0H8(5),50,nMB,G1H8(93),n2h8(114))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2063),h0tab(:,2063),[32,4,27],[nMT,nMH,nMT],3,1,wf24(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,703),heltab2x96(:,:,2031))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(57),n2h48(703))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2064),h0tab(:,2064),[32,4,27],[nMT,nMZ,nMT],3,1,wf24(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,704),heltab2x96(:,:,2032))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(58),n2h48(704))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2065),h0tab(:,2065),[32,4,27],[nMB,nMW,nMB],3,1,wf24(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,705),heltab2x96(:,:,2033))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(59),n2h48(705))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2066),h0tab(:,2066),[32,4,27],[nMT,0,nMT],3,1,wf24(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,706),heltab2x96(:,:,2034))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(60),n2h48(706))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2067),h0tab(:,2067),[32,4,27],[nMT,nMZ,nMT],3,1,wf24(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,707),heltab2x96(:,:,2035))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(61),n2h48(707))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2068),h0tab(:,2068),[32,4,27],[nMB,nMW,nMB],3,1,wf24(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,708),heltab2x96(:,:,2036))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(62),n2h48(708))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2069),h0tab(:,2069),[34,13,16],[nMH,nMB,nMT],3,2,wf4(:,12),wf8(:,12))
  call Hloop_AQ_S(ntryL,G0H96(1),wf4(:,12),G0H24(81),ngH,m3h4x24(:,685),heltab2x96(:,:,2037))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2070),h0tab(:,2070),[34,13,16],[nMZ,nMB,nMT],3,2,wf4(:,12),wf8(:,12))
  call Hloop_AQ_S(ntryL,G0H96(1),wf4(:,12),G0H24(82),ngX,m3h4x24(:,686),heltab2x96(:,:,2038))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2071),h0tab(:,2071),[34,13,16],[nMT,nMW,nMH],3,2,wf4(:,12),wf8(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(83),ngH,m3h4x24(:,687),heltab2x96(:,:,2039))
  call Hloop_Q_A(ntryL,G0H24(83),34,nMT,G1H24(311),n2h24(479))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2072),h0tab(:,2072),[34,13,16],[nMB,nMH,nMW],3,2,wf4(:,12),wf8(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(84),ngPbt,m3h4x24(:,688),heltab2x96(:,:,2040))
  call Hloop_Q_A(ntryL,G0H24(84),34,nMB,G1H24(312),n2h24(480))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2073),h0tab(:,2073),[34,13,16],[nMT,nMW,nMZ],3,2,wf4(:,12),wf8(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(85),ngX,m3h4x24(:,689),heltab2x96(:,:,2041))
  call Hloop_Q_A(ntryL,G0H24(85),34,nMT,G1H24(313),n2h24(481))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2074),h0tab(:,2074),[34,13,16],[nMB,nMZ,nMW],3,2,wf4(:,12),wf8(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(86),ngPbt,m3h4x24(:,690),heltab2x96(:,:,2042))
  call Hloop_Q_A(ntryL,G0H24(86),34,nMB,G1H24(314),n2h24(482))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2075),h0tab(:,2075),[34,13,16],[0,nMB,nMT],3,2,wf4(:,12),wf8(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(91),m3h4x24(:,691),heltab2x96(:,:,2043))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2076),h0tab(:,2076),[34,13,16],[nMZ,nMB,nMT],3,2,wf4(:,12),wf8(:,12))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(92),ngZu,m3h4x24(:,692),heltab2x96(:,:,2044))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2077),h0tab(:,2077),[34,13,16],[nMB,0,nMW],3,2,wf4(:,12),wf8(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(93),ngPbt,m3h4x24(:,693),heltab2x96(:,:,2045))
  call Hloop_Q_A(ntryL,G0H24(93),34,nMB,G1H24(315),n2h24(483))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2078),h0tab(:,2078),[34,13,16],[nMB,nMZ,nMW],3,2,wf4(:,12),wf8(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(94),ngPbt,m3h4x24(:,694),heltab2x96(:,:,2046))
  call Hloop_Q_A(ntryL,G0H24(94),34,nMB,G1H24(316),n2h24(484))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2079),h0tab(:,2079),[34,13,16],[nMT,nMW,nMH],3,2,wf4(:,12),wf8(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(95),ngH,m3h4x24(:,695),heltab2x96(:,:,2047))
  call Hloop_Q_A(ntryL,G0H24(95),34,nMT,G1H24(317),n2h24(485))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2080),h0tab(:,2080),[34,13,16],[nMT,nMW,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(96),m3h4x24(:,696),heltab2x96(:,:,2048))
  call Hloop_Q_A(ntryL,G0H24(96),34,nMT,G1H24(318),n2h24(486))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2081),h0tab(:,2081),[34,13,16],[nMT,nMW,nMZ],3,2,wf4(:,12),wf8(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(69),ngZu,m3h4x24(:,697),heltab2x96(:,:,2049))
  call Hloop_Q_A(ntryL,G0H24(69),34,nMT,G1H24(319),n2h24(487))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2082),h0tab(:,2082),[34,13,16],[nMB,nMH,nMW],3,2,wf4(:,12),wf8(:,12))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(1),m3h4x24(:,698),heltab2x96(:,:,2050))
  call Hloop_Q_A(ntryL,G0H24(1),34,nMB,G1H24(1),n2h24(488))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2083),h0tab(:,2083),[34,13,16],[nMT,nMW,0],3,2,wf4(:,12),wf8(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(6),m3h4x24(:,699),heltab2x96(:,:,2051))
  call Hloop_Q_A(ntryL,G0H24(6),34,nMT,G1H24(2),n2h24(489))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2084),h0tab(:,2084),[34,13,16],[nMB,0,nMW],3,2,wf4(:,12),wf8(:,12))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(7),m3h4x24(:,700),heltab2x96(:,:,2052))
  call Hloop_Q_A(ntryL,G0H24(7),34,nMB,G1H24(3),n2h24(490))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2085),h0tab(:,2085),[34,13,16],[nMT,nMW,nMZ],3,2,wf4(:,12),wf8(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(12),ngZu,m3h4x24(:,701),heltab2x96(:,:,2053))
  call Hloop_Q_A(ntryL,G0H24(12),34,nMT,G1H24(4),n2h24(491))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2086),h0tab(:,2086),[34,13,16],[nMB,nMZ,nMW],3,2,wf4(:,12),wf8(:,12))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(13),m3h4x24(:,702),heltab2x96(:,:,2054))
  call Hloop_Q_A(ntryL,G0H24(13),34,nMB,G1H24(5),n2h24(492))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2087),h0tab(:,2087),[34,4,25],[nMH,nMT,nMT],3,2,wf4(:,12),wf12(:,10))
  call Hloop_AQ_S(ntryL,G0H96(1),wf4(:,12),G0H24(14),ngH,m3h4x24(:,703),heltab2x96(:,:,2055))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2088),h0tab(:,2088),[34,4,25],[nMZ,nMT,nMT],3,2,wf4(:,12),wf12(:,10))
  call Hloop_AQ_S(ntryL,G0H96(1),wf4(:,12),G0H24(15),ngX,m3h4x24(:,704),heltab2x96(:,:,2056))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2089),h0tab(:,2089),[34,4,25],[nMW,nMB,nMB],3,2,wf4(:,12),wf12(:,10))
  call Hloop_AQ_S(ntryL,G0H96(1),wf4(:,12),G0H24(16),ngPbt,m3h4x24(:,705),heltab2x96(:,:,2057))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2090),h0tab(:,2090),[34,4,25],[nMT,nMH,nMH],3,2,wf4(:,12),wf12(:,10))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(17),ngH,m3h4x24(:,706),heltab2x96(:,:,2058))
  call Hloop_Q_A(ntryL,G0H24(17),34,nMT,G1H24(6),n2h24(493))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2091),h0tab(:,2091),[34,4,25],[nMT,nMZ,nMZ],3,2,wf4(:,12),wf12(:,10))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(18),ngX,m3h4x24(:,707),heltab2x96(:,:,2059))
  call Hloop_Q_A(ntryL,G0H24(18),34,nMT,G1H24(7),n2h24(494))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2092),h0tab(:,2092),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,10))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(19),ngPbt,m3h4x24(:,708),heltab2x96(:,:,2060))
  call Hloop_Q_A(ntryL,G0H24(19),34,nMB,G1H24(8),n2h24(495))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2093),h0tab(:,2093),[34,4,25],[0,nMT,nMT],3,2,wf4(:,12),wf12(:,10))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(20),m3h4x24(:,709),heltab2x96(:,:,2061))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2094),h0tab(:,2094),[34,4,25],[nMZ,nMT,nMT],3,2,wf4(:,12),wf12(:,10))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(21),ngZu,m3h4x24(:,710),heltab2x96(:,:,2062))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2095),h0tab(:,2095),[34,4,25],[nMW,nMB,nMB],3,2,wf4(:,12),wf12(:,10))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,12),G0H24(38),m3h4x24(:,711),heltab2x96(:,:,2063))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2096),h0tab(:,2096),[34,4,25],[nMT,nMZ,nMZ],3,2,wf4(:,12),wf12(:,10))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(39),ngZu,m3h4x24(:,712),heltab2x96(:,:,2064))
  call Hloop_Q_A(ntryL,G0H24(39),34,nMT,G1H24(9),n2h24(496))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2097),h0tab(:,2097),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,10))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(40),m3h4x24(:,713),heltab2x96(:,:,2065))
  call Hloop_Q_A(ntryL,G0H24(40),34,nMB,G1H24(10),n2h24(497))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2098),h0tab(:,2098),[34,4,25],[nMT,nMZ,nMZ],3,2,wf4(:,12),wf12(:,10))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(41),ngX,m3h4x24(:,714),heltab2x96(:,:,2066))
  call Hloop_Q_A(ntryL,G0H24(41),34,nMT,G1H24(11),n2h24(498))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2099),h0tab(:,2099),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,10))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(8),ngPbt,m3h4x24(:,715),heltab2x96(:,:,2067))
  call Hloop_Q_A(ntryL,G0H24(8),34,nMB,G1H24(12),n2h24(499))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2100),h0tab(:,2100),[34,4,25],[nMT,nMZ,nMZ],3,2,wf4(:,12),wf12(:,10))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(9),ngZu,m3h4x24(:,716),heltab2x96(:,:,2068))
  call Hloop_Q_A(ntryL,G0H24(9),34,nMT,G1H24(13),n2h24(500))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2101),h0tab(:,2101),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,10))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(10),m3h4x24(:,717),heltab2x96(:,:,2069))
  call Hloop_Q_A(ntryL,G0H24(10),34,nMB,G1H24(14),n2h24(501))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2102),h0tab(:,2102),[34,4,25],[nMH,nMT,nMT],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_S(ntryL,G0H96(1),wf4(:,12),G0H24(42),ngH,m3h4x24(:,718),heltab2x96(:,:,2070))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2103),h0tab(:,2103),[34,4,25],[nMZ,nMT,nMT],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_S(ntryL,G0H96(1),wf4(:,12),G0H24(43),ngX,m3h4x24(:,719),heltab2x96(:,:,2071))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2104),h0tab(:,2104),[34,4,25],[nMW,nMB,nMB],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_S(ntryL,G0H96(1),wf4(:,12),G0H24(44),ngPbt,m3h4x24(:,720),heltab2x96(:,:,2072))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2105),h0tab(:,2105),[34,4,25],[nMH,nMT,nMT],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_S(ntryL,G0H96(1),wf4(:,12),G0H24(45),ngH,m3h4x24(:,721),heltab2x96(:,:,2073))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2106),h0tab(:,2106),[34,4,25],[nMZ,nMT,nMT],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_S(ntryL,G0H96(1),wf4(:,12),G0H24(56),ngX,m3h4x24(:,722),heltab2x96(:,:,2074))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2107),h0tab(:,2107),[34,4,25],[nMW,nMB,nMB],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_S(ntryL,G0H96(1),wf4(:,12),G0H24(61),ngPbt,m3h4x24(:,723),heltab2x96(:,:,2075))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2108),h0tab(:,2108),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,11))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(62),ngPbt,m3h4x24(:,724),heltab2x96(:,:,2076))
  call Hloop_Q_A(ntryL,G0H24(62),34,nMB,G1H24(15),n2h24(502))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2109),h0tab(:,2109),[34,4,25],[nMT,nMH,nMZ],3,2,wf4(:,12),wf12(:,11))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(66),ngX,m3h4x24(:,725),heltab2x96(:,:,2077))
  call Hloop_Q_A(ntryL,G0H24(66),34,nMT,G1H24(16),n2h24(503))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2110),h0tab(:,2110),[34,4,25],[nMT,nMZ,nMH],3,2,wf4(:,12),wf12(:,11))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(67),ngH,m3h4x24(:,726),heltab2x96(:,:,2078))
  call Hloop_Q_A(ntryL,G0H24(67),34,nMT,G1H24(17),n2h24(504))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2111),h0tab(:,2111),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,11))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(50),ngPbt,m3h4x24(:,727),heltab2x96(:,:,2079))
  call Hloop_Q_A(ntryL,G0H24(50),34,nMB,G1H24(18),n2h24(505))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2112),h0tab(:,2112),[34,4,25],[0,nMT,nMT],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(52),m3h4x24(:,728),heltab2x96(:,:,2080))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2113),h0tab(:,2113),[34,4,25],[nMZ,nMT,nMT],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(53),ngZu,m3h4x24(:,729),heltab2x96(:,:,2081))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2114),h0tab(:,2114),[34,4,25],[nMW,nMB,nMB],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,12),G0H24(59),m3h4x24(:,730),heltab2x96(:,:,2082))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2115),h0tab(:,2115),[34,4,25],[0,nMT,nMT],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(27),m3h4x24(:,731),heltab2x96(:,:,2083))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2116),h0tab(:,2116),[34,4,25],[nMZ,nMT,nMT],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(34),ngZu,m3h4x24(:,732),heltab2x96(:,:,2084))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2117),h0tab(:,2117),[34,4,25],[nMW,nMB,nMB],3,2,wf4(:,12),wf12(:,11))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,12),G0H24(37),m3h4x24(:,733),heltab2x96(:,:,2085))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2118),h0tab(:,2118),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,11))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,734),heltab2x96(:,:,2086))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMB,G1H24(19),n2h24(506))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2119),h0tab(:,2119),[34,4,25],[nMT,nMH,nMZ],3,2,wf4(:,12),wf12(:,11))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(49),ngZu,m3h4x24(:,735),heltab2x96(:,:,2087))
  call Hloop_Q_A(ntryL,G0H24(49),34,nMT,G1H24(20),n2h24(507))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2120),h0tab(:,2120),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,11))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(54),m3h4x24(:,736),heltab2x96(:,:,2088))
  call Hloop_Q_A(ntryL,G0H24(54),34,nMB,G1H24(21),n2h24(508))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2121),h0tab(:,2121),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,11))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(32),ngPbt,m3h4x24(:,737),heltab2x96(:,:,2089))
  call Hloop_Q_A(ntryL,G0H24(32),34,nMB,G1H24(22),n2h24(509))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2122),h0tab(:,2122),[34,4,25],[nMT,nMZ,nMH],3,2,wf4(:,12),wf12(:,11))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(33),ngH,m3h4x24(:,738),heltab2x96(:,:,2090))
  call Hloop_Q_A(ntryL,G0H24(33),34,nMT,G1H24(23),n2h24(510))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2123),h0tab(:,2123),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,11))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(83),ngPbt,m3h4x24(:,739),heltab2x96(:,:,2091))
  call Hloop_Q_A(ntryL,G0H24(83),34,nMB,G1H24(24),n2h24(511))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2124),h0tab(:,2124),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,11))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(84),m3h4x24(:,740),heltab2x96(:,:,2092))
  call Hloop_Q_A(ntryL,G0H24(84),34,nMB,G1H24(25),n2h24(512))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2125),h0tab(:,2125),[34,4,25],[nMB,nMW,nMW],3,2,wf4(:,12),wf12(:,11))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(85),m3h4x24(:,741),heltab2x96(:,:,2093))
  call Hloop_Q_A(ntryL,G0H24(85),34,nMB,G1H24(26),n2h24(513))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2126),h0tab(:,2126),[38,9,16],[nME,0,nME],3,2,wf8(:,13),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,13),G0H12(27),ngH,m3h8x12(:,487),heltab2x96(:,:,2094))
  call Hloop_Q_A(ntryL,G0H12(27),38,nME,G1H12(310),n2h12(552))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2127),h0tab(:,2127),[38,9,16],[nMM,0,nMM],3,2,wf8(:,13),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,13),G0H12(28),ngH,m3h8x12(:,488),heltab2x96(:,:,2095))
  call Hloop_Q_A(ntryL,G0H12(28),38,nMM,G1H12(92),n2h12(553))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2128),h0tab(:,2128),[38,9,16],[nML,0,nML],3,2,wf8(:,13),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,13),G0H12(29),ngH,m3h8x12(:,489),heltab2x96(:,:,2096))
  call Hloop_Q_A(ntryL,G0H12(29),38,nML,G1H12(93),n2h12(554))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2129),h0tab(:,2129),[38,9,16],[nMT,nMB,nMT],3,2,wf8(:,13),wf4(:,8))
  call Hloop_AS_Q(ntryL,G0H96(1),wf8(:,13),G0H12(30),ngH,m3h8x12(:,490),heltab2x96(:,:,2097))
  call Hloop_A_Q(ntryL,G0H12(30),38,nMT,G1H12(94),n2h12(555))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2130),h0tab(:,2130),[38,9,16],[nMB,nMT,nMB],3,2,wf8(:,13),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,13),G0H12(31),ngH,m3h8x12(:,491),heltab2x96(:,:,2098))
  call Hloop_Q_A(ntryL,G0H12(31),38,nMB,G1H12(99),n2h12(556))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2131),h0tab(:,2131),[38,9,16],[nME,0,nME],3,2,wf8(:,75),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,75),G0H12(54),ngX,m3h8x12(:,492),heltab2x96(:,:,2099))
  call Hloop_Q_A(ntryL,G0H12(54),38,nME,G1H12(100),n2h12(557))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2132),h0tab(:,2132),[38,9,16],[nMM,0,nMM],3,2,wf8(:,75),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,75),G0H12(52),ngX,m3h8x12(:,493),heltab2x96(:,:,2100))
  call Hloop_Q_A(ntryL,G0H12(52),38,nMM,G1H12(103),n2h12(558))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2133),h0tab(:,2133),[38,9,16],[nML,0,nML],3,2,wf8(:,75),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,75),G0H12(37),ngX,m3h8x12(:,494),heltab2x96(:,:,2101))
  call Hloop_Q_A(ntryL,G0H12(37),38,nML,G1H12(106),n2h12(559))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2134),h0tab(:,2134),[38,9,16],[nMT,nMB,nMT],3,2,wf8(:,75),wf4(:,8))
  call Hloop_AS_Q(ntryL,G0H96(1),wf8(:,75),G0H12(35),ngX,m3h8x12(:,495),heltab2x96(:,:,2102))
  call Hloop_A_Q(ntryL,G0H12(35),38,nMT,G1H12(113),n2h12(560))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2135),h0tab(:,2135),[38,9,16],[nMB,nMT,nMB],3,2,wf8(:,75),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,75),G0H12(56),ngX,m3h8x12(:,496),heltab2x96(:,:,2103))
  call Hloop_Q_A(ntryL,G0H12(56),38,nMB,G1H12(114),n2h12(561))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2136),h0tab(:,2136),[38,9,16],[nMH,nMW,nMH],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(53),m3h8x12(:,497),heltab2x96(:,:,2104))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2137),h0tab(:,2137),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(39),m3h8x12(:,498),heltab2x96(:,:,2105))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2138),h0tab(:,2138),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(36),m3h8x12(:,499),heltab2x96(:,:,2106))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2139),h0tab(:,2139),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(55),m3h8x12(:,500),heltab2x96(:,:,2107))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2140),h0tab(:,2140),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,75),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,75),G0H12(63),m3h8x12(:,501),heltab2x96(:,:,2108))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2141),h0tab(:,2141),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,75),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,75),G0H12(46),m3h8x12(:,502),heltab2x96(:,:,2109))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2142),h0tab(:,2142),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(40),m3h8x12(:,503),heltab2x96(:,:,2110))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2143),h0tab(:,2143),[38,9,16],[nMW,0,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(58),m3h8x12(:,504),heltab2x96(:,:,2111))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2144),h0tab(:,2144),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(41),m3h8x12(:,505),heltab2x96(:,:,2112))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2145),h0tab(:,2145),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(59),m3h8x12(:,506),heltab2x96(:,:,2113))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2146),h0tab(:,2146),[38,9,16],[nMW,0,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(42),m3h8x12(:,507),heltab2x96(:,:,2114))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2147),h0tab(:,2147),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(48),m3h8x12(:,508),heltab2x96(:,:,2115))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2148),h0tab(:,2148),[38,9,16],[nMW,0,nMW],3,2,wf8(:,75),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,75),G0H12(66),m3h8x12(:,509),heltab2x96(:,:,2116))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2149),h0tab(:,2149),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,75),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,75),G0H12(67),m3h8x12(:,510),heltab2x96(:,:,2117))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2150),h0tab(:,2150),[38,9,16],[nMW,0,nMW],3,2,wf8(:,75),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,75),G0H12(82),m3h8x12(:,511),heltab2x96(:,:,2118))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2151),h0tab(:,2151),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,75),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,75),G0H12(83),m3h8x12(:,512),heltab2x96(:,:,2119))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2152),h0tab(:,2152),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,13),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H96(1),wf8(:,13),G0H12(84),m3h8x12(:,513),heltab2x96(:,:,2120))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2153),h0tab(:,2153),[38,9,16],[nMW,0,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H96(1),wf8(:,13),G0H12(85),m3h8x12(:,514),heltab2x96(:,:,2121))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2154),h0tab(:,2154),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H96(1),wf8(:,13),G0H12(86),m3h8x12(:,515),heltab2x96(:,:,2122))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2155),h0tab(:,2155),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,13),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,13),38,G1H12(119),m3h8x12(:,516),heltab2x96(:,:,2123))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2156),h0tab(:,2156),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,13),38,G1H12(120),m3h8x12(:,517),heltab2x96(:,:,2124))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2157),h0tab(:,2157),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,75),wf4(:,8))
  call Hloop_TS_V(ntryL,G0H96(1),0,wf8(:,75),38,G1H12(121),m3h8x12(:,518),heltab2x96(:,:,2125))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2158),h0tab(:,2158),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,75),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,75),38,G1H12(126),m3h8x12(:,519),heltab2x96(:,:,2126))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2159),h0tab(:,2159),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,13),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,13),38,G1H12(127),m3h8x12(:,520),heltab2x96(:,:,2127))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2160),h0tab(:,2160),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,13),38,G1H12(128),m3h8x12(:,521),heltab2x96(:,:,2128))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2161),h0tab(:,2161),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,75),wf4(:,8))
  call Hloop_VS_T(ntryL,G0H96(1),0,wf8(:,75),38,G1H12(201),m3h8x12(:,522),heltab2x96(:,:,2129))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2162),h0tab(:,2162),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,75),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,75),38,G1H12(202),m3h8x12(:,523),heltab2x96(:,:,2130))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2163),h0tab(:,2163),[38,9,16],[nMW,0,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(87),m3h8x12(:,524),heltab2x96(:,:,2131))
  Gcoeff(:)%j = (-(c(136)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2164),h0tab(:,2164),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(88),m3h8x12(:,525),heltab2x96(:,:,2132))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2165),h0tab(:,2165),[38,9,16],[nMH,nMW,nMH],3,2,wf8(:,13),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,13),G0H12(89),m3h8x12(:,526),heltab2x96(:,:,2133))
  Gcoeff(:)%j = (-(c(140)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2166),h0tab(:,2166),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,13),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H96(1),wf8(:,13),G0H12(90),m3h8x12(:,527),heltab2x96(:,:,2134))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2167),h0tab(:,2167),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H96(1),wf8(:,13),G0H12(91),m3h8x12(:,528),heltab2x96(:,:,2135))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2168),h0tab(:,2168),[38,9,16],[nMW,0,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,13),38,G1H12(203),m3h8x12(:,529),heltab2x96(:,:,2136))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2169),h0tab(:,2169),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,13),38,G1H12(206),m3h8x12(:,530),heltab2x96(:,:,2137))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2170),h0tab(:,2170),[38,9,16],[nMW,0,nMW],3,2,wf8(:,75),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,75),38,G1H12(207),m3h8x12(:,531),heltab2x96(:,:,2138))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2171),h0tab(:,2171),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,75),wf4(:,8))
  call Hloop_TS_V(ntryL,G0H96(1),0,wf8(:,75),38,G1H12(208),m3h8x12(:,532),heltab2x96(:,:,2139))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2172),h0tab(:,2172),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,75),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,75),38,G1H12(312),m3h8x12(:,533),heltab2x96(:,:,2140))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2173),h0tab(:,2173),[38,9,16],[nMW,0,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,13),38,G1H12(313),m3h8x12(:,534),heltab2x96(:,:,2141))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2174),h0tab(:,2174),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,13),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,13),38,G1H12(314),m3h8x12(:,535),heltab2x96(:,:,2142))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2175),h0tab(:,2175),[38,9,16],[nMW,0,nMW],3,2,wf8(:,75),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,75),38,G1H12(317),m3h8x12(:,536),heltab2x96(:,:,2143))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2176),h0tab(:,2176),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,75),wf4(:,8))
  call Hloop_VS_T(ntryL,G0H96(1),0,wf8(:,75),38,G1H12(318),m3h8x12(:,537),heltab2x96(:,:,2144))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2177),h0tab(:,2177),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,75),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,75),38,G1H12(319),m3h8x12(:,538),heltab2x96(:,:,2145))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2178),h0tab(:,2178),[38,9,16],[nME,0,nME],3,2,wf8(:,14),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,14),G0H12(92),m3h8x12(:,539),heltab2x96(:,:,2146))
  call Hloop_Q_A(ntryL,G0H12(92),38,nME,G1H12(322),n2h12(562))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2179),h0tab(:,2179),[38,9,16],[nMM,0,nMM],3,2,wf8(:,14),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,14),G0H12(93),m3h8x12(:,540),heltab2x96(:,:,2147))
  call Hloop_Q_A(ntryL,G0H12(93),38,nMM,G1H12(323),n2h12(563))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2180),h0tab(:,2180),[38,9,16],[nML,0,nML],3,2,wf8(:,14),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,14),G0H12(94),m3h8x12(:,541),heltab2x96(:,:,2148))
  call Hloop_Q_A(ntryL,G0H12(94),38,nML,G1H12(324),n2h12(564))
  Gcoeff(:)%j = (c(227)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2181),h0tab(:,2181),[38,9,16],[0,0,0],3,2,wf8(:,14),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,14),G0H12(95),m3h8x12(:,542),heltab2x96(:,:,2149))
  call Hloop_A_Q(ntryL,G0H12(95),38,0,G1H12(327),n2h12(565))
  Gcoeff(:)%j = (c(224)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2182),h0tab(:,2182),[38,9,16],[nMT,nMB,nMT],3,2,wf8(:,14),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,14),G0H12(96),m3h8x12(:,543),heltab2x96(:,:,2150))
  call Hloop_A_Q(ntryL,G0H12(96),38,nMT,G1H12(328),n2h12(566))
  Gcoeff(:)%j = (-(c(224)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2183),h0tab(:,2183),[38,9,16],[0,0,0],3,2,wf8(:,14),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,14),G0H12(49),m3h8x12(:,544),heltab2x96(:,:,2151))
  call Hloop_Q_A(ntryL,G0H12(49),38,0,G1H12(329),n2h12(567))
  Gcoeff(:)%j = (-(c(223)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2184),h0tab(:,2184),[38,9,16],[nMB,nMT,nMB],3,2,wf8(:,14),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,14),G0H12(57),m3h8x12(:,545),heltab2x96(:,:,2152))
  call Hloop_Q_A(ntryL,G0H12(57),38,nMB,G1H12(332),n2h12(568))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2185),h0tab(:,2185),[38,9,16],[0,nME,0],3,2,wf8(:,15),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H96(1),wf8(:,15),G0H12(27),ngZn,m3h8x12(:,546),heltab2x96(:,:,2153))
  call Hloop_A_Q(ntryL,G0H12(27),38,0,G1H12(333),n2h12(569))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2186),h0tab(:,2186),[38,9,16],[0,nMM,0],3,2,wf8(:,15),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H96(1),wf8(:,15),G0H12(28),ngZn,m3h8x12(:,547),heltab2x96(:,:,2154))
  call Hloop_A_Q(ntryL,G0H12(28),38,0,G1H12(334),n2h12(570))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2187),h0tab(:,2187),[38,9,16],[0,nML,0],3,2,wf8(:,15),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H96(1),wf8(:,15),G0H12(29),ngZn,m3h8x12(:,548),heltab2x96(:,:,2155))
  call Hloop_A_Q(ntryL,G0H12(29),38,0,G1H12(337),n2h12(571))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2188),h0tab(:,2188),[38,9,16],[nME,0,nME],3,2,wf8(:,15),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H96(1),wf8(:,15),G0H12(30),ngZl,m3h8x12(:,549),heltab2x96(:,:,2156))
  call Hloop_Q_A(ntryL,G0H12(30),38,nME,G1H12(338),n2h12(572))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2189),h0tab(:,2189),[38,9,16],[nMM,0,nMM],3,2,wf8(:,15),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H96(1),wf8(:,15),G0H12(31),ngZl,m3h8x12(:,550),heltab2x96(:,:,2157))
  call Hloop_Q_A(ntryL,G0H12(31),38,nMM,G1H12(211),n2h12(573))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2190),h0tab(:,2190),[38,9,16],[nML,0,nML],3,2,wf8(:,15),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H96(1),wf8(:,15),G0H12(54),ngZl,m3h8x12(:,551),heltab2x96(:,:,2158))
  call Hloop_Q_A(ntryL,G0H12(54),38,nML,G1H12(214),n2h12(574))
  Gcoeff(:)%j = (c(231)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2191),h0tab(:,2191),[38,9,16],[0,0,0],3,2,wf8(:,15),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H96(1),wf8(:,15),G0H12(52),ngZu,m3h8x12(:,552),heltab2x96(:,:,2159))
  call Hloop_A_Q(ntryL,G0H12(52),38,0,G1H12(30),n2h12(575))
  Gcoeff(:)%j = (c(229)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2192),h0tab(:,2192),[38,9,16],[nMT,nMB,nMT],3,2,wf8(:,15),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H96(1),wf8(:,15),G0H12(37),ngZu,m3h8x12(:,553),heltab2x96(:,:,2160))
  call Hloop_A_Q(ntryL,G0H12(37),38,nMT,G1H12(69),n2h12(576))
  Gcoeff(:)%j = (c(231)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2193),h0tab(:,2193),[38,9,16],[0,0,0],3,2,wf8(:,15),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H96(1),wf8(:,15),G0H12(35),ngZd,m3h8x12(:,554),heltab2x96(:,:,2161))
  call Hloop_Q_A(ntryL,G0H12(35),38,0,G1H12(55),n2h12(577))
  Gcoeff(:)%j = (c(229)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2194),h0tab(:,2194),[38,9,16],[nMB,nMT,nMB],3,2,wf8(:,15),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H96(1),wf8(:,15),G0H12(56),ngZd,m3h8x12(:,555),heltab2x96(:,:,2162))
  call Hloop_Q_A(ntryL,G0H12(56),38,nMB,G1H12(44),n2h12(578))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2195),h0tab(:,2195),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,14),38,G1H12(47),m3h8x12(:,556),heltab2x96(:,:,2163))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2196),h0tab(:,2196),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,14),38,G1H12(65),m3h8x12(:,557),heltab2x96(:,:,2164))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2197),h0tab(:,2197),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,15),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,15),38,G1H12(11),m3h8x12(:,558),heltab2x96(:,:,2165))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2198),h0tab(:,2198),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,15),wf4(:,8))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,15),38,G1H12(12),m3h8x12(:,559),heltab2x96(:,:,2166))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2199),h0tab(:,2199),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,15),38,G1H12(25),m3h8x12(:,560),heltab2x96(:,:,2167))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2200),h0tab(:,2200),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,15),38,G1H12(26),m3h8x12(:,561),heltab2x96(:,:,2168))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2201),h0tab(:,2201),[38,9,16],[nMW,0,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,14),38,G1H12(35),m3h8x12(:,562),heltab2x96(:,:,2169))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2202),h0tab(:,2202),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,14),38,G1H12(64),m3h8x12(:,563),heltab2x96(:,:,2170))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2203),h0tab(:,2203),[38,9,16],[nMW,0,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,14),G1H12(339),m3h8x12(:,564),heltab2x96(:,:,2171))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2204),h0tab(:,2204),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,14),G1H12(340),m3h8x12(:,565),heltab2x96(:,:,2172))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2205),h0tab(:,2205),[38,9,16],[nMW,0,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,15),38,G1H12(343),m3h8x12(:,566),heltab2x96(:,:,2173))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2206),h0tab(:,2206),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,15),38,G1H12(344),m3h8x12(:,567),heltab2x96(:,:,2174))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2207),h0tab(:,2207),[38,9,16],[nMW,0,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,15),G1H12(345),m3h8x12(:,568),heltab2x96(:,:,2175))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2208),h0tab(:,2208),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,15),G1H12(348),m3h8x12(:,569),heltab2x96(:,:,2176))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2209),h0tab(:,2209),[38,9,16],[nMW,0,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,14),38,G1H12(349),m3h8x12(:,570),heltab2x96(:,:,2177))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2210),h0tab(:,2210),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,14),38,G1H12(350),m3h8x12(:,571),heltab2x96(:,:,2178))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2211),h0tab(:,2211),[38,9,16],[nMW,0,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,15),38,G1H12(353),m3h8x12(:,572),heltab2x96(:,:,2179))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2212),h0tab(:,2212),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,15),38,G1H12(354),m3h8x12(:,573),heltab2x96(:,:,2180))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2213),h0tab(:,2213),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,14),G0H12(92),m3h8x12(:,574),heltab2x96(:,:,2181))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2214),h0tab(:,2214),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,15),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,15),G0H12(93),m3h8x12(:,575),heltab2x96(:,:,2182))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2215),h0tab(:,2215),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,15),G0H12(94),m3h8x12(:,576),heltab2x96(:,:,2183))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2216),h0tab(:,2216),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,14),G0H12(95),m3h8x12(:,577),heltab2x96(:,:,2184))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2217),h0tab(:,2217),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,15),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,15),G0H12(96),m3h8x12(:,578),heltab2x96(:,:,2185))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2218),h0tab(:,2218),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,15),G0H12(49),m3h8x12(:,579),heltab2x96(:,:,2186))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2219),h0tab(:,2219),[38,9,16],[nMW,0,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,14),38,G1H12(355),m3h8x12(:,580),heltab2x96(:,:,2187))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2220),h0tab(:,2220),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,14),38,G1H12(358),m3h8x12(:,581),heltab2x96(:,:,2188))
  Gcoeff(:)%j = (c(158)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2221),h0tab(:,2221),[38,9,16],[nMW,0,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,15),38,G1H12(359),m3h8x12(:,582),heltab2x96(:,:,2189))
  Gcoeff(:)%j = (-(c(166)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2222),h0tab(:,2222),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,15),38,G1H12(360),m3h8x12(:,583),heltab2x96(:,:,2190))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2223),h0tab(:,2223),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,14),38,G1H12(49),m3h8x12(:,584),heltab2x96(:,:,2191))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2224),h0tab(:,2224),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,15),38,G1H12(50),m3h8x12(:,585),heltab2x96(:,:,2192))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2225),h0tab(:,2225),[38,9,16],[nMW,0,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,14),G0H12(57),m3h8x12(:,586),heltab2x96(:,:,2193))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2226),h0tab(:,2226),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,14),G0H12(27),m3h8x12(:,587),heltab2x96(:,:,2194))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2227),h0tab(:,2227),[38,9,16],[nMW,0,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,15),G0H12(28),m3h8x12(:,588),heltab2x96(:,:,2195))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2228),h0tab(:,2228),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,15),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,15),G0H12(29),m3h8x12(:,589),heltab2x96(:,:,2196))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2229),h0tab(:,2229),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,15),G0H12(30),m3h8x12(:,590),heltab2x96(:,:,2197))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2230),h0tab(:,2230),[38,9,16],[nMW,0,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,14),G0H12(31),m3h8x12(:,591),heltab2x96(:,:,2198))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2231),h0tab(:,2231),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,14),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,14),G0H12(54),m3h8x12(:,592),heltab2x96(:,:,2199))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2232),h0tab(:,2232),[38,9,16],[nMW,0,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,15),G0H12(52),m3h8x12(:,593),heltab2x96(:,:,2200))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2233),h0tab(:,2233),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,15),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,15),G0H12(37),m3h8x12(:,594),heltab2x96(:,:,2201))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2234),h0tab(:,2234),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,15),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,15),G0H12(35),m3h8x12(:,595),heltab2x96(:,:,2202))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2235),h0tab(:,2235),[50,4,9],[nMH,nMT,nMB],3,2,wf12(:,37),wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H96(1),wf12(:,37),G0H8(6),ngH,m3h12x8(:,111),heltab2x96(:,:,2203))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2236),h0tab(:,2236),[50,4,9],[nMZ,nMT,nMB],3,2,wf12(:,37),wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H96(1),wf12(:,37),G0H8(23),ngX,m3h12x8(:,112),heltab2x96(:,:,2204))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2237),h0tab(:,2237),[50,4,9],[nMT,nMH,nMW],3,2,wf12(:,37),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(5),ngPtb,m3h12x8(:,113),heltab2x96(:,:,2205))
  call Hloop_Q_A(ntryL,G0H8(5),50,nMT,G1H8(96),n2h8(115))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2238),h0tab(:,2238),[50,4,9],[nMB,nMW,nMH],3,2,wf12(:,37),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(5),ngH,m3h12x8(:,114),heltab2x96(:,:,2206))
  call Hloop_Q_A(ntryL,G0H8(5),50,nMB,G1H8(99),n2h8(116))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2239),h0tab(:,2239),[50,4,9],[nMT,nMZ,nMW],3,2,wf12(:,37),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(5),ngPtb,m3h12x8(:,115),heltab2x96(:,:,2207))
  call Hloop_Q_A(ntryL,G0H8(5),50,nMT,G1H8(100),n2h8(117))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2240),h0tab(:,2240),[50,4,9],[nMB,nMW,nMZ],3,2,wf12(:,37),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(5),ngX,m3h12x8(:,116),heltab2x96(:,:,2208))
  call Hloop_Q_A(ntryL,G0H8(5),50,nMB,G1H8(11),n2h8(118))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2241),h0tab(:,2241),[50,4,9],[0,nMT,nMB],3,2,wf12(:,37),wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,37),G0H8(5),m3h12x8(:,117),heltab2x96(:,:,2209))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2242),h0tab(:,2242),[50,4,9],[nMZ,nMT,nMB],3,2,wf12(:,37),wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf12(:,37),G0H8(28),ngZd,m3h12x8(:,118),heltab2x96(:,:,2210))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2243),h0tab(:,2243),[50,4,9],[nMB,nMW,0],3,2,wf12(:,37),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(29),m3h12x8(:,119),heltab2x96(:,:,2211))
  call Hloop_Q_A(ntryL,G0H8(29),50,nMB,G1H8(102),n2h8(119))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2244),h0tab(:,2244),[50,4,9],[nMB,nMW,nMZ],3,2,wf12(:,37),wf4(:,8))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(29),ngZd,m3h12x8(:,120),heltab2x96(:,:,2212))
  call Hloop_Q_A(ntryL,G0H8(29),50,nMB,G1H8(103),n2h8(120))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2245),h0tab(:,2245),[50,4,9],[nMT,nMH,nMW],3,2,wf12(:,37),wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(29),m3h12x8(:,121),heltab2x96(:,:,2213))
  call Hloop_Q_A(ntryL,G0H8(29),50,nMT,G1H8(104),n2h8(121))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2246),h0tab(:,2246),[50,4,9],[nMT,0,nMW],3,2,wf12(:,37),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(29),ngPtb,m3h12x8(:,122),heltab2x96(:,:,2214))
  call Hloop_Q_A(ntryL,G0H8(29),50,nMT,G1H8(107),n2h8(122))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2247),h0tab(:,2247),[50,4,9],[nMT,nMZ,nMW],3,2,wf12(:,37),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(29),ngPtb,m3h12x8(:,123),heltab2x96(:,:,2215))
  call Hloop_Q_A(ntryL,G0H8(29),50,nMT,G1H8(61),n2h8(123))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2248),h0tab(:,2248),[50,4,9],[nMB,nMW,nMH],3,2,wf12(:,37),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(29),ngH,m3h12x8(:,124),heltab2x96(:,:,2216))
  call Hloop_Q_A(ntryL,G0H8(29),50,nMB,G1H8(95),n2h8(124))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2249),h0tab(:,2249),[50,4,9],[nMT,0,nMW],3,2,wf12(:,37),wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(29),m3h12x8(:,125),heltab2x96(:,:,2217))
  call Hloop_Q_A(ntryL,G0H8(29),50,nMT,G1H8(127),n2h8(125))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2250),h0tab(:,2250),[50,4,9],[nMB,nMW,0],3,2,wf12(:,37),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(29),m3h12x8(:,126),heltab2x96(:,:,2218))
  call Hloop_Q_A(ntryL,G0H8(29),50,nMB,G1H8(18),n2h8(126))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2251),h0tab(:,2251),[50,4,9],[nMT,nMZ,nMW],3,2,wf12(:,37),wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(29),m3h12x8(:,127),heltab2x96(:,:,2219))
  call Hloop_Q_A(ntryL,G0H8(29),50,nMT,G1H8(27),n2h8(127))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2252),h0tab(:,2252),[50,4,9],[nMB,nMW,nMZ],3,2,wf12(:,37),wf4(:,8))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,37),G0H8(29),ngZd,m3h12x8(:,128),heltab2x96(:,:,2220))
  call Hloop_Q_A(ntryL,G0H8(29),50,nMB,G1H8(28),n2h8(128))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2253),h0tab(:,2253),[36,2,25],[nMH,nMT,nMT],3,2,wf4(:,10),wf12(:,10))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(86),ngH,m3h4x24(:,742),heltab2x96(:,:,2221))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2254),h0tab(:,2254),[36,2,25],[nMZ,nMT,nMT],3,2,wf4(:,10),wf12(:,10))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(93),ngX,m3h4x24(:,743),heltab2x96(:,:,2222))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2255),h0tab(:,2255),[36,2,25],[nMW,nMB,nMB],3,2,wf4(:,10),wf12(:,10))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(94),ngPtb,m3h4x24(:,744),heltab2x96(:,:,2223))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2256),h0tab(:,2256),[36,2,25],[nMT,nMH,nMH],3,2,wf4(:,10),wf12(:,10))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(95),ngH,m3h4x24(:,745),heltab2x96(:,:,2224))
  call Hloop_A_Q(ntryL,G0H24(95),36,nMT,G1H24(27),n2h24(514))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2257),h0tab(:,2257),[36,2,25],[nMT,nMZ,nMZ],3,2,wf4(:,10),wf12(:,10))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(96),ngX,m3h4x24(:,746),heltab2x96(:,:,2225))
  call Hloop_A_Q(ntryL,G0H24(96),36,nMT,G1H24(28),n2h24(515))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2258),h0tab(:,2258),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,10))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(69),ngPtb,m3h4x24(:,747),heltab2x96(:,:,2226))
  call Hloop_A_Q(ntryL,G0H24(69),36,nMB,G1H24(29),n2h24(516))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2259),h0tab(:,2259),[36,2,25],[0,nMT,nMT],3,2,wf4(:,10),wf12(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(1),m3h4x24(:,748),heltab2x96(:,:,2227))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2260),h0tab(:,2260),[36,2,25],[nMZ,nMT,nMT],3,2,wf4(:,10),wf12(:,10))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,10),G0H24(6),ngZu,m3h4x24(:,749),heltab2x96(:,:,2228))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2261),h0tab(:,2261),[36,2,25],[nMW,nMB,nMB],3,2,wf4(:,10),wf12(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(7),m3h4x24(:,750),heltab2x96(:,:,2229))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2262),h0tab(:,2262),[36,2,25],[nMT,nMZ,nMZ],3,2,wf4(:,10),wf12(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(12),ngZu,m3h4x24(:,751),heltab2x96(:,:,2230))
  call Hloop_A_Q(ntryL,G0H24(12),36,nMT,G1H24(30),n2h24(517))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2263),h0tab(:,2263),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(13),m3h4x24(:,752),heltab2x96(:,:,2231))
  call Hloop_A_Q(ntryL,G0H24(13),36,nMB,G1H24(31),n2h24(518))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2264),h0tab(:,2264),[36,2,25],[nMT,nMZ,nMZ],3,2,wf4(:,10),wf12(:,10))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(17),ngX,m3h4x24(:,753),heltab2x96(:,:,2232))
  call Hloop_A_Q(ntryL,G0H24(17),36,nMT,G1H24(32),n2h24(519))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2265),h0tab(:,2265),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,10))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(18),ngPtb,m3h4x24(:,754),heltab2x96(:,:,2233))
  call Hloop_A_Q(ntryL,G0H24(18),36,nMB,G1H24(33),n2h24(520))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2266),h0tab(:,2266),[36,2,25],[nMT,nMZ,nMZ],3,2,wf4(:,10),wf12(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(19),ngZu,m3h4x24(:,755),heltab2x96(:,:,2234))
  call Hloop_A_Q(ntryL,G0H24(19),36,nMT,G1H24(34),n2h24(521))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2267),h0tab(:,2267),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(39),m3h4x24(:,756),heltab2x96(:,:,2235))
  call Hloop_A_Q(ntryL,G0H24(39),36,nMB,G1H24(35),n2h24(522))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2268),h0tab(:,2268),[36,2,25],[nMH,nMT,nMT],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(40),ngH,m3h4x24(:,757),heltab2x96(:,:,2236))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2269),h0tab(:,2269),[36,2,25],[nMZ,nMT,nMT],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(41),ngX,m3h4x24(:,758),heltab2x96(:,:,2237))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2270),h0tab(:,2270),[36,2,25],[nMW,nMB,nMB],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(8),ngPtb,m3h4x24(:,759),heltab2x96(:,:,2238))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2271),h0tab(:,2271),[36,2,25],[nMH,nMT,nMT],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(9),ngH,m3h4x24(:,760),heltab2x96(:,:,2239))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2272),h0tab(:,2272),[36,2,25],[nMZ,nMT,nMT],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(10),ngX,m3h4x24(:,761),heltab2x96(:,:,2240))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2273),h0tab(:,2273),[36,2,25],[nMW,nMB,nMB],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_S(ntryL,G0H96(1),wf4(:,10),G0H24(62),ngPtb,m3h4x24(:,762),heltab2x96(:,:,2241))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2274),h0tab(:,2274),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,11))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(66),ngPtb,m3h4x24(:,763),heltab2x96(:,:,2242))
  call Hloop_A_Q(ntryL,G0H24(66),36,nMB,G1H24(36),n2h24(523))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2275),h0tab(:,2275),[36,2,25],[nMT,nMH,nMZ],3,2,wf4(:,10),wf12(:,11))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(67),ngX,m3h4x24(:,764),heltab2x96(:,:,2243))
  call Hloop_A_Q(ntryL,G0H24(67),36,nMT,G1H24(37),n2h24(524))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2276),h0tab(:,2276),[36,2,25],[nMT,nMZ,nMH],3,2,wf4(:,10),wf12(:,11))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(50),ngH,m3h4x24(:,765),heltab2x96(:,:,2244))
  call Hloop_A_Q(ntryL,G0H24(50),36,nMT,G1H24(38),n2h24(525))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2277),h0tab(:,2277),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,11))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(48),ngPtb,m3h4x24(:,766),heltab2x96(:,:,2245))
  call Hloop_A_Q(ntryL,G0H24(48),36,nMB,G1H24(39),n2h24(526))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2278),h0tab(:,2278),[36,2,25],[0,nMT,nMT],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(49),m3h4x24(:,767),heltab2x96(:,:,2246))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2279),h0tab(:,2279),[36,2,25],[nMZ,nMT,nMT],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,10),G0H24(54),ngZu,m3h4x24(:,768),heltab2x96(:,:,2247))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2280),h0tab(:,2280),[36,2,25],[nMW,nMB,nMB],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(32),m3h4x24(:,769),heltab2x96(:,:,2248))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2281),h0tab(:,2281),[36,2,25],[0,nMT,nMT],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(33),m3h4x24(:,770),heltab2x96(:,:,2249))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2282),h0tab(:,2282),[36,2,25],[nMZ,nMT,nMT],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,10),G0H24(83),ngZu,m3h4x24(:,771),heltab2x96(:,:,2250))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2283),h0tab(:,2283),[36,2,25],[nMW,nMB,nMB],3,2,wf4(:,10),wf12(:,11))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(84),m3h4x24(:,772),heltab2x96(:,:,2251))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2284),h0tab(:,2284),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,11))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(85),m3h4x24(:,773),heltab2x96(:,:,2252))
  call Hloop_A_Q(ntryL,G0H24(85),36,nMB,G1H24(40),n2h24(527))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2285),h0tab(:,2285),[36,2,25],[nMT,nMH,nMZ],3,2,wf4(:,10),wf12(:,11))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(95),ngZu,m3h4x24(:,774),heltab2x96(:,:,2253))
  call Hloop_A_Q(ntryL,G0H24(95),36,nMT,G1H24(41),n2h24(528))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2286),h0tab(:,2286),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,11))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(96),m3h4x24(:,775),heltab2x96(:,:,2254))
  call Hloop_A_Q(ntryL,G0H24(96),36,nMB,G1H24(42),n2h24(529))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2287),h0tab(:,2287),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,11))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(69),ngPtb,m3h4x24(:,776),heltab2x96(:,:,2255))
  call Hloop_A_Q(ntryL,G0H24(69),36,nMB,G1H24(43),n2h24(530))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2288),h0tab(:,2288),[36,2,25],[nMT,nMZ,nMH],3,2,wf4(:,10),wf12(:,11))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(12),ngH,m3h4x24(:,777),heltab2x96(:,:,2256))
  call Hloop_A_Q(ntryL,G0H24(12),36,nMT,G1H24(44),n2h24(531))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2289),h0tab(:,2289),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,11))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(13),ngPtb,m3h4x24(:,778),heltab2x96(:,:,2257))
  call Hloop_A_Q(ntryL,G0H24(13),36,nMB,G1H24(45),n2h24(532))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2290),h0tab(:,2290),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,11))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(17),m3h4x24(:,779),heltab2x96(:,:,2258))
  call Hloop_A_Q(ntryL,G0H24(17),36,nMB,G1H24(46),n2h24(533))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2291),h0tab(:,2291),[36,2,25],[nMB,nMW,nMW],3,2,wf4(:,10),wf12(:,11))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(18),m3h4x24(:,780),heltab2x96(:,:,2259))
  call Hloop_A_Q(ntryL,G0H24(18),36,nMB,G1H24(47),n2h24(534))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2292),h0tab(:,2292),[38,9,16],[nME,0,nME],3,2,wf8(:,16),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,16),G0H12(56),ngH,m3h8x12(:,596),heltab2x96(:,:,2260))
  call Hloop_Q_A(ntryL,G0H12(56),38,nME,G1H12(59),n2h12(579))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2293),h0tab(:,2293),[38,9,16],[nMM,0,nMM],3,2,wf8(:,16),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,16),G0H12(56),ngH,m3h8x12(:,597),heltab2x96(:,:,2261))
  call Hloop_Q_A(ntryL,G0H12(56),38,nMM,G1H12(364),n2h12(580))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2294),h0tab(:,2294),[38,9,16],[nML,0,nML],3,2,wf8(:,16),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,16),G0H12(56),ngH,m3h8x12(:,598),heltab2x96(:,:,2262))
  call Hloop_Q_A(ntryL,G0H12(56),38,nML,G1H12(365),n2h12(581))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2295),h0tab(:,2295),[38,9,16],[nMT,nMB,nMT],3,2,wf8(:,16),wf4(:,8))
  call Hloop_AS_Q(ntryL,G0H96(1),wf8(:,16),G0H12(56),ngH,m3h8x12(:,599),heltab2x96(:,:,2263))
  call Hloop_A_Q(ntryL,G0H12(56),38,nMT,G1H12(366),n2h12(582))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2296),h0tab(:,2296),[38,9,16],[nMB,nMT,nMB],3,2,wf8(:,16),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,16),G0H12(56),ngH,m3h8x12(:,600),heltab2x96(:,:,2264))
  call Hloop_Q_A(ntryL,G0H12(56),38,nMB,G1H12(369),n2h12(583))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2297),h0tab(:,2297),[38,9,16],[nME,0,nME],3,2,wf8(:,86),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,86),G0H12(56),ngX,m3h8x12(:,601),heltab2x96(:,:,2265))
  call Hloop_Q_A(ntryL,G0H12(56),38,nME,G1H12(370),n2h12(584))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2298),h0tab(:,2298),[38,9,16],[nMM,0,nMM],3,2,wf8(:,86),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,86),G0H12(56),ngX,m3h8x12(:,602),heltab2x96(:,:,2266))
  call Hloop_Q_A(ntryL,G0H12(56),38,nMM,G1H12(371),n2h12(585))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2299),h0tab(:,2299),[38,9,16],[nML,0,nML],3,2,wf8(:,86),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,86),G0H12(56),ngX,m3h8x12(:,603),heltab2x96(:,:,2267))
  call Hloop_Q_A(ntryL,G0H12(56),38,nML,G1H12(374),n2h12(586))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2300),h0tab(:,2300),[38,9,16],[nMT,nMB,nMT],3,2,wf8(:,86),wf4(:,8))
  call Hloop_AS_Q(ntryL,G0H96(1),wf8(:,86),G0H12(56),ngX,m3h8x12(:,604),heltab2x96(:,:,2268))
  call Hloop_A_Q(ntryL,G0H12(56),38,nMT,G1H12(375),n2h12(587))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2301),h0tab(:,2301),[38,9,16],[nMB,nMT,nMB],3,2,wf8(:,86),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H96(1),wf8(:,86),G0H12(56),ngX,m3h8x12(:,605),heltab2x96(:,:,2269))
  call Hloop_Q_A(ntryL,G0H12(56),38,nMB,G1H12(376),n2h12(588))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2302),h0tab(:,2302),[38,9,16],[nMH,nMW,nMH],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(56),m3h8x12(:,606),heltab2x96(:,:,2270))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2303),h0tab(:,2303),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(98),m3h8x12(:,607),heltab2x96(:,:,2271))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2304),h0tab(:,2304),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(99),m3h8x12(:,608),heltab2x96(:,:,2272))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2305),h0tab(:,2305),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(100),m3h8x12(:,609),heltab2x96(:,:,2273))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2306),h0tab(:,2306),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,86),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,86),G0H12(101),m3h8x12(:,610),heltab2x96(:,:,2274))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2307),h0tab(:,2307),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,86),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,86),G0H12(102),m3h8x12(:,611),heltab2x96(:,:,2275))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2308),h0tab(:,2308),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(103),m3h8x12(:,612),heltab2x96(:,:,2276))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2309),h0tab(:,2309),[38,9,16],[nMW,0,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(104),m3h8x12(:,613),heltab2x96(:,:,2277))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2310),h0tab(:,2310),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(105),m3h8x12(:,614),heltab2x96(:,:,2278))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2311),h0tab(:,2311),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(106),m3h8x12(:,615),heltab2x96(:,:,2279))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2312),h0tab(:,2312),[38,9,16],[nMW,0,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(107),m3h8x12(:,616),heltab2x96(:,:,2280))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2313),h0tab(:,2313),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(108),m3h8x12(:,617),heltab2x96(:,:,2281))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2314),h0tab(:,2314),[38,9,16],[nMW,0,nMW],3,2,wf8(:,86),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,86),G0H12(109),m3h8x12(:,618),heltab2x96(:,:,2282))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2315),h0tab(:,2315),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,86),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,86),G0H12(110),m3h8x12(:,619),heltab2x96(:,:,2283))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2316),h0tab(:,2316),[38,9,16],[nMW,0,nMW],3,2,wf8(:,86),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,86),G0H12(111),m3h8x12(:,620),heltab2x96(:,:,2284))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2317),h0tab(:,2317),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,86),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,86),G0H12(112),m3h8x12(:,621),heltab2x96(:,:,2285))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2318),h0tab(:,2318),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,16),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H96(1),wf8(:,16),G0H12(113),m3h8x12(:,622),heltab2x96(:,:,2286))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2319),h0tab(:,2319),[38,9,16],[nMW,0,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H96(1),wf8(:,16),G0H12(114),m3h8x12(:,623),heltab2x96(:,:,2287))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2320),h0tab(:,2320),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H96(1),wf8(:,16),G0H12(115),m3h8x12(:,624),heltab2x96(:,:,2288))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2321),h0tab(:,2321),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,16),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,16),38,G1H12(379),m3h8x12(:,625),heltab2x96(:,:,2289))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2322),h0tab(:,2322),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,16),38,G1H12(380),m3h8x12(:,626),heltab2x96(:,:,2290))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2323),h0tab(:,2323),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,86),wf4(:,8))
  call Hloop_TS_V(ntryL,G0H96(1),0,wf8(:,86),38,G1H12(381),m3h8x12(:,627),heltab2x96(:,:,2291))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2324),h0tab(:,2324),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,86),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,86),38,G1H12(384),m3h8x12(:,628),heltab2x96(:,:,2292))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2325),h0tab(:,2325),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,16),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,16),38,G1H12(390),m3h8x12(:,629),heltab2x96(:,:,2293))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2326),h0tab(:,2326),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,16),38,G1H12(391),m3h8x12(:,630),heltab2x96(:,:,2294))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2327),h0tab(:,2327),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,86),wf4(:,8))
  call Hloop_VS_T(ntryL,G0H96(1),0,wf8(:,86),38,G1H12(392),m3h8x12(:,631),heltab2x96(:,:,2295))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2328),h0tab(:,2328),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,86),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,86),38,G1H12(393),m3h8x12(:,632),heltab2x96(:,:,2296))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2329),h0tab(:,2329),[38,9,16],[nMW,0,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(116),m3h8x12(:,633),heltab2x96(:,:,2297))
  Gcoeff(:)%j = (-(c(136)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2330),h0tab(:,2330),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(117),m3h8x12(:,634),heltab2x96(:,:,2298))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2331),h0tab(:,2331),[38,9,16],[nMH,nMW,nMH],3,2,wf8(:,16),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H96(1),wf8(:,16),G0H12(118),m3h8x12(:,635),heltab2x96(:,:,2299))
  Gcoeff(:)%j = (-(c(140)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2332),h0tab(:,2332),[38,9,16],[nMZ,nMW,nMZ],3,2,wf8(:,16),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H96(1),wf8(:,16),G0H12(119),m3h8x12(:,636),heltab2x96(:,:,2300))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2333),h0tab(:,2333),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H96(1),wf8(:,16),G0H12(120),m3h8x12(:,637),heltab2x96(:,:,2301))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2334),h0tab(:,2334),[38,9,16],[nMW,0,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,16),38,G1H12(394),m3h8x12(:,638),heltab2x96(:,:,2302))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2335),h0tab(:,2335),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,16),38,G1H12(395),m3h8x12(:,639),heltab2x96(:,:,2303))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2336),h0tab(:,2336),[38,9,16],[nMW,0,nMW],3,2,wf8(:,86),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,86),38,G1H12(396),m3h8x12(:,640),heltab2x96(:,:,2304))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2337),h0tab(:,2337),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,86),wf4(:,8))
  call Hloop_TS_V(ntryL,G0H96(1),0,wf8(:,86),38,G1H12(397),m3h8x12(:,641),heltab2x96(:,:,2305))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2338),h0tab(:,2338),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,86),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H96(1),0,wf8(:,86),38,G1H12(398),m3h8x12(:,642),heltab2x96(:,:,2306))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2339),h0tab(:,2339),[38,9,16],[nMW,0,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,16),38,G1H12(399),m3h8x12(:,643),heltab2x96(:,:,2307))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2340),h0tab(:,2340),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,16),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,16),38,G1H12(400),m3h8x12(:,644),heltab2x96(:,:,2308))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2341),h0tab(:,2341),[38,9,16],[nMW,0,nMW],3,2,wf8(:,86),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,86),38,G1H12(401),m3h8x12(:,645),heltab2x96(:,:,2309))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2342),h0tab(:,2342),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,86),wf4(:,8))
  call Hloop_VS_T(ntryL,G0H96(1),0,wf8(:,86),38,G1H12(402),m3h8x12(:,646),heltab2x96(:,:,2310))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2343),h0tab(:,2343),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,86),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf8(:,86),38,G1H12(403),m3h8x12(:,647),heltab2x96(:,:,2311))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2344),h0tab(:,2344),[38,9,16],[nME,0,nME],3,2,wf8(:,17),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,17),G0H12(121),m3h8x12(:,648),heltab2x96(:,:,2312))
  call Hloop_Q_A(ntryL,G0H12(121),38,nME,G1H12(404),n2h12(589))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2345),h0tab(:,2345),[38,9,16],[nMM,0,nMM],3,2,wf8(:,17),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,17),G0H12(121),m3h8x12(:,649),heltab2x96(:,:,2313))
  call Hloop_Q_A(ntryL,G0H12(121),38,nMM,G1H12(405),n2h12(590))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2346),h0tab(:,2346),[38,9,16],[nML,0,nML],3,2,wf8(:,17),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,17),G0H12(121),m3h8x12(:,650),heltab2x96(:,:,2314))
  call Hloop_Q_A(ntryL,G0H12(121),38,nML,G1H12(406),n2h12(591))
  Gcoeff(:)%j = (c(227)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2347),h0tab(:,2347),[38,9,16],[0,0,0],3,2,wf8(:,17),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,17),G0H12(121),m3h8x12(:,651),heltab2x96(:,:,2315))
  call Hloop_A_Q(ntryL,G0H12(121),38,0,G1H12(407),n2h12(592))
  Gcoeff(:)%j = (c(224)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2348),h0tab(:,2348),[38,9,16],[nMT,nMB,nMT],3,2,wf8(:,17),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,17),G0H12(121),m3h8x12(:,652),heltab2x96(:,:,2316))
  call Hloop_A_Q(ntryL,G0H12(121),38,nMT,G1H12(408),n2h12(593))
  Gcoeff(:)%j = (-(c(224)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2349),h0tab(:,2349),[38,9,16],[0,0,0],3,2,wf8(:,17),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,17),G0H12(121),m3h8x12(:,653),heltab2x96(:,:,2317))
  call Hloop_Q_A(ntryL,G0H12(121),38,0,G1H12(409),n2h12(594))
  Gcoeff(:)%j = (-(c(223)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2350),h0tab(:,2350),[38,9,16],[nMB,nMT,nMB],3,2,wf8(:,17),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,17),G0H12(121),m3h8x12(:,654),heltab2x96(:,:,2318))
  call Hloop_Q_A(ntryL,G0H12(121),38,nMB,G1H12(410),n2h12(595))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2351),h0tab(:,2351),[38,9,16],[0,nME,0],3,2,wf8(:,18),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H96(1),wf8(:,18),G0H12(121),ngZn,m3h8x12(:,655),heltab2x96(:,:,2319))
  call Hloop_A_Q(ntryL,G0H12(121),38,0,G1H12(411),n2h12(596))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2352),h0tab(:,2352),[38,9,16],[0,nMM,0],3,2,wf8(:,18),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H96(1),wf8(:,18),G0H12(121),ngZn,m3h8x12(:,656),heltab2x96(:,:,2320))
  call Hloop_A_Q(ntryL,G0H12(121),38,0,G1H12(412),n2h12(597))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2353),h0tab(:,2353),[38,9,16],[0,nML,0],3,2,wf8(:,18),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H96(1),wf8(:,18),G0H12(121),ngZn,m3h8x12(:,657),heltab2x96(:,:,2321))
  call Hloop_A_Q(ntryL,G0H12(121),38,0,G1H12(413),n2h12(598))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2354),h0tab(:,2354),[38,9,16],[nME,0,nME],3,2,wf8(:,18),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H96(1),wf8(:,18),G0H12(121),ngZl,m3h8x12(:,658),heltab2x96(:,:,2322))
  call Hloop_Q_A(ntryL,G0H12(121),38,nME,G1H12(414),n2h12(599))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2355),h0tab(:,2355),[38,9,16],[nMM,0,nMM],3,2,wf8(:,18),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H96(1),wf8(:,18),G0H12(121),ngZl,m3h8x12(:,659),heltab2x96(:,:,2323))
  call Hloop_Q_A(ntryL,G0H12(121),38,nMM,G1H12(415),n2h12(600))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2356),h0tab(:,2356),[38,9,16],[nML,0,nML],3,2,wf8(:,18),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H96(1),wf8(:,18),G0H12(121),ngZl,m3h8x12(:,660),heltab2x96(:,:,2324))
  call Hloop_Q_A(ntryL,G0H12(121),38,nML,G1H12(416),n2h12(601))
  Gcoeff(:)%j = (c(231)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2357),h0tab(:,2357),[38,9,16],[0,0,0],3,2,wf8(:,18),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H96(1),wf8(:,18),G0H12(121),ngZu,m3h8x12(:,661),heltab2x96(:,:,2325))
  call Hloop_A_Q(ntryL,G0H12(121),38,0,G1H12(417),n2h12(602))
  Gcoeff(:)%j = (c(229)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2358),h0tab(:,2358),[38,9,16],[nMT,nMB,nMT],3,2,wf8(:,18),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H96(1),wf8(:,18),G0H12(121),ngZu,m3h8x12(:,662),heltab2x96(:,:,2326))
  call Hloop_A_Q(ntryL,G0H12(121),38,nMT,G1H12(418),n2h12(603))
  Gcoeff(:)%j = (c(231)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2359),h0tab(:,2359),[38,9,16],[0,0,0],3,2,wf8(:,18),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H96(1),wf8(:,18),G0H12(121),ngZd,m3h8x12(:,663),heltab2x96(:,:,2327))
  call Hloop_Q_A(ntryL,G0H12(121),38,0,G1H12(419),n2h12(604))
  Gcoeff(:)%j = (c(229)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2360),h0tab(:,2360),[38,9,16],[nMB,nMT,nMB],3,2,wf8(:,18),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H96(1),wf8(:,18),G0H12(121),ngZd,m3h8x12(:,664),heltab2x96(:,:,2328))
  call Hloop_Q_A(ntryL,G0H12(121),38,nMB,G1H12(420),n2h12(605))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2361),h0tab(:,2361),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,17),38,G1H12(421),m3h8x12(:,665),heltab2x96(:,:,2329))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2362),h0tab(:,2362),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,17),38,G1H12(422),m3h8x12(:,666),heltab2x96(:,:,2330))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2363),h0tab(:,2363),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,18),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,18),38,G1H12(423),m3h8x12(:,667),heltab2x96(:,:,2331))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2364),h0tab(:,2364),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,18),wf4(:,8))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf8(:,18),38,G1H12(424),m3h8x12(:,668),heltab2x96(:,:,2332))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2365),h0tab(:,2365),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,18),38,G1H12(425),m3h8x12(:,669),heltab2x96(:,:,2333))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2366),h0tab(:,2366),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,18),38,G1H12(426),m3h8x12(:,670),heltab2x96(:,:,2334))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2367),h0tab(:,2367),[38,9,16],[nMW,0,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,17),38,G1H12(427),m3h8x12(:,671),heltab2x96(:,:,2335))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2368),h0tab(:,2368),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,17),38,G1H12(428),m3h8x12(:,672),heltab2x96(:,:,2336))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2369),h0tab(:,2369),[38,9,16],[nMW,0,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,17),G1H12(429),m3h8x12(:,673),heltab2x96(:,:,2337))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2370),h0tab(:,2370),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,17),G1H12(430),m3h8x12(:,674),heltab2x96(:,:,2338))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2371),h0tab(:,2371),[38,9,16],[nMW,0,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,18),38,G1H12(431),m3h8x12(:,675),heltab2x96(:,:,2339))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2372),h0tab(:,2372),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,18),38,G1H12(432),m3h8x12(:,676),heltab2x96(:,:,2340))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2373),h0tab(:,2373),[38,9,16],[nMW,0,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,18),G1H12(433),m3h8x12(:,677),heltab2x96(:,:,2341))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2374),h0tab(:,2374),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,18),G1H12(434),m3h8x12(:,678),heltab2x96(:,:,2342))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2375),h0tab(:,2375),[38,9,16],[nMW,0,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,17),38,G1H12(435),m3h8x12(:,679),heltab2x96(:,:,2343))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2376),h0tab(:,2376),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,17),38,G1H12(436),m3h8x12(:,680),heltab2x96(:,:,2344))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2377),h0tab(:,2377),[38,9,16],[nMW,0,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,18),38,G1H12(437),m3h8x12(:,681),heltab2x96(:,:,2345))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2378),h0tab(:,2378),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,18),38,G1H12(438),m3h8x12(:,682),heltab2x96(:,:,2346))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2379),h0tab(:,2379),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,17),G0H12(121),m3h8x12(:,683),heltab2x96(:,:,2347))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2380),h0tab(:,2380),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,18),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,18),G0H12(122),m3h8x12(:,684),heltab2x96(:,:,2348))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2381),h0tab(:,2381),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,18),G0H12(123),m3h8x12(:,685),heltab2x96(:,:,2349))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2382),h0tab(:,2382),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,17),G0H12(124),m3h8x12(:,686),heltab2x96(:,:,2350))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2383),h0tab(:,2383),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,18),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,18),G0H12(125),m3h8x12(:,687),heltab2x96(:,:,2351))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2384),h0tab(:,2384),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,18),G0H12(126),m3h8x12(:,688),heltab2x96(:,:,2352))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2385),h0tab(:,2385),[38,9,16],[nMW,0,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,17),38,G1H12(439),m3h8x12(:,689),heltab2x96(:,:,2353))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2386),h0tab(:,2386),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,17),38,G1H12(440),m3h8x12(:,690),heltab2x96(:,:,2354))
  Gcoeff(:)%j = (c(158)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2387),h0tab(:,2387),[38,9,16],[nMW,0,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,18),38,G1H12(441),m3h8x12(:,691),heltab2x96(:,:,2355))
  Gcoeff(:)%j = (-(c(166)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2388),h0tab(:,2388),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,18),38,G1H12(442),m3h8x12(:,692),heltab2x96(:,:,2356))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2389),h0tab(:,2389),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,17),38,G1H12(443),m3h8x12(:,693),heltab2x96(:,:,2357))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2390),h0tab(:,2390),[38,9,16],[nMW,nMH,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,18),38,G1H12(444),m3h8x12(:,694),heltab2x96(:,:,2358))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2391),h0tab(:,2391),[38,9,16],[nMW,0,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,17),G0H12(127),m3h8x12(:,695),heltab2x96(:,:,2359))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2392),h0tab(:,2392),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,17),G0H12(128),m3h8x12(:,696),heltab2x96(:,:,2360))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2393),h0tab(:,2393),[38,9,16],[nMW,0,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,18),G0H12(129),m3h8x12(:,697),heltab2x96(:,:,2361))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2394),h0tab(:,2394),[38,9,16],[nMZ,nMW,nMH],3,2,wf8(:,18),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,18),G0H12(130),m3h8x12(:,698),heltab2x96(:,:,2362))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2395),h0tab(:,2395),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,18),G0H12(131),m3h8x12(:,699),heltab2x96(:,:,2363))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2396),h0tab(:,2396),[38,9,16],[nMW,0,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,17),G0H12(132),m3h8x12(:,700),heltab2x96(:,:,2364))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2397),h0tab(:,2397),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,17),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,17),G0H12(133),m3h8x12(:,701),heltab2x96(:,:,2365))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2398),h0tab(:,2398),[38,9,16],[nMW,0,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,18),G0H12(134),m3h8x12(:,702),heltab2x96(:,:,2366))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2399),h0tab(:,2399),[38,9,16],[nMH,nMW,nMZ],3,2,wf8(:,18),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,18),G0H12(135),m3h8x12(:,703),heltab2x96(:,:,2367))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2400),h0tab(:,2400),[38,9,16],[nMW,nMZ,nMW],3,2,wf8(:,18),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H96(1),wf8(:,18),G0H12(136),m3h8x12(:,704),heltab2x96(:,:,2368))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2401),h0tab(:,2401),[45,2,16],[nMH,nMT,nMB],3,1,wf16(:,16))
  call Hloop_QA_S(ntryL,G0H96(1),wf16(:,16),G0H6(4),ngH,m3h16x6(:,49),heltab2x96(:,:,2369))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2402),h0tab(:,2402),[45,2,16],[nMZ,nMT,nMB],3,1,wf16(:,16))
  call Hloop_QA_S(ntryL,G0H96(1),wf16(:,16),G0H6(18),ngX,m3h16x6(:,50),heltab2x96(:,:,2370))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2403),h0tab(:,2403),[45,2,16],[nMT,nMH,nMW],3,1,wf16(:,16))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(19),ngPbt,m3h16x6(:,51),heltab2x96(:,:,2371))
  call Hloop_A_Q(ntryL,G0H6(19),45,nMT,G1H6(256),n2h6(350))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2404),h0tab(:,2404),[45,2,16],[nMB,nMW,nMH],3,1,wf16(:,16))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(19),ngH,m3h16x6(:,52),heltab2x96(:,:,2372))
  call Hloop_A_Q(ntryL,G0H6(19),45,nMB,G1H6(267),n2h6(351))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2405),h0tab(:,2405),[45,2,16],[nMT,nMZ,nMW],3,1,wf16(:,16))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(19),ngPbt,m3h16x6(:,53),heltab2x96(:,:,2373))
  call Hloop_A_Q(ntryL,G0H6(19),45,nMT,G1H6(268),n2h6(352))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2406),h0tab(:,2406),[45,2,16],[nMB,nMW,nMZ],3,1,wf16(:,16))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(19),ngX,m3h16x6(:,54),heltab2x96(:,:,2374))
  call Hloop_A_Q(ntryL,G0H6(19),45,nMB,G1H6(30),n2h6(353))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2407),h0tab(:,2407),[45,2,16],[0,nMT,nMB],3,1,wf16(:,16))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,16),G0H6(19),m3h16x6(:,55),heltab2x96(:,:,2375))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2408),h0tab(:,2408),[45,2,16],[nMZ,nMT,nMB],3,1,wf16(:,16))
  call Hloop_QA_Z(ntryL,G0H96(1),wf16(:,16),G0H6(20),ngZd,m3h16x6(:,56),heltab2x96(:,:,2376))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2409),h0tab(:,2409),[45,2,16],[nMB,nMW,0],3,1,wf16(:,16))
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(21),m3h16x6(:,57),heltab2x96(:,:,2377))
  call Hloop_A_Q(ntryL,G0H6(21),45,nMB,G1H6(38),n2h6(354))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2410),h0tab(:,2410),[45,2,16],[nMB,nMW,nMZ],3,1,wf16(:,16))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(21),ngZd,m3h16x6(:,58),heltab2x96(:,:,2378))
  call Hloop_A_Q(ntryL,G0H6(21),45,nMB,G1H6(42),n2h6(355))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2411),h0tab(:,2411),[45,2,16],[nMT,nMH,nMW],3,1,wf16(:,16))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(21),m3h16x6(:,59),heltab2x96(:,:,2379))
  call Hloop_A_Q(ntryL,G0H6(21),45,nMT,G1H6(43),n2h6(356))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2412),h0tab(:,2412),[45,2,16],[nMT,0,nMW],3,1,wf16(:,16))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(21),ngPbt,m3h16x6(:,60),heltab2x96(:,:,2380))
  call Hloop_A_Q(ntryL,G0H6(21),45,nMT,G1H6(192),n2h6(357))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2413),h0tab(:,2413),[45,2,16],[nMT,nMZ,nMW],3,1,wf16(:,16))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(21),ngPbt,m3h16x6(:,61),heltab2x96(:,:,2381))
  call Hloop_A_Q(ntryL,G0H6(21),45,nMT,G1H6(193),n2h6(358))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2414),h0tab(:,2414),[45,2,16],[nMB,nMW,nMH],3,1,wf16(:,16))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(21),ngH,m3h16x6(:,62),heltab2x96(:,:,2382))
  call Hloop_A_Q(ntryL,G0H6(21),45,nMB,G1H6(248),n2h6(359))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2415),h0tab(:,2415),[45,2,16],[nMT,0,nMW],3,1,wf16(:,16))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(21),m3h16x6(:,63),heltab2x96(:,:,2383))
  call Hloop_A_Q(ntryL,G0H6(21),45,nMT,G1H6(175),n2h6(360))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2416),h0tab(:,2416),[45,2,16],[nMB,nMW,0],3,1,wf16(:,16))
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(21),m3h16x6(:,64),heltab2x96(:,:,2384))
  call Hloop_A_Q(ntryL,G0H6(21),45,nMB,G1H6(216),n2h6(361))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2417),h0tab(:,2417),[45,2,16],[nMT,nMZ,nMW],3,1,wf16(:,16))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(21),m3h16x6(:,65),heltab2x96(:,:,2385))
  call Hloop_A_Q(ntryL,G0H6(21),45,nMT,G1H6(85),n2h6(362))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2418),h0tab(:,2418),[45,2,16],[nMB,nMW,nMZ],3,1,wf16(:,16))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf16(:,16),G0H6(21),ngZd,m3h16x6(:,66),heltab2x96(:,:,2386))
  call Hloop_A_Q(ntryL,G0H6(21),45,nMB,G1H6(51),n2h6(363))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2419),h0tab(:,2419),[32,2,29],[nMT,nMH,nMT],3,1,wf24(:,47))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,709),heltab2x96(:,:,2387))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(63),n2h48(709))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2420),h0tab(:,2420),[32,2,29],[nMT,nMZ,nMT],3,1,wf24(:,47))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,710),heltab2x96(:,:,2388))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(64),n2h48(710))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2421),h0tab(:,2421),[32,2,29],[nMB,nMW,nMB],3,1,wf24(:,47))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,711),heltab2x96(:,:,2389))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(65),n2h48(711))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2422),h0tab(:,2422),[32,2,29],[nMT,0,nMT],3,1,wf24(:,47))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,712),heltab2x96(:,:,2390))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(66),n2h48(712))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2423),h0tab(:,2423),[32,2,29],[nMT,nMZ,nMT],3,1,wf24(:,47))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,713),heltab2x96(:,:,2391))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(67),n2h48(713))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2424),h0tab(:,2424),[32,2,29],[nMB,nMW,nMB],3,1,wf24(:,47))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,714),heltab2x96(:,:,2392))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(68),n2h48(714))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2425),h0tab(:,2425),[45,2,16],[nMH,nMT,nMB],3,1,wf16(:,26))
  call Hloop_QA_S(ntryL,G0H96(1),wf16(:,26),G0H6(21),ngH,m3h16x6(:,67),heltab2x96(:,:,2393))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2426),h0tab(:,2426),[45,2,16],[nMZ,nMT,nMB],3,1,wf16(:,26))
  call Hloop_QA_S(ntryL,G0H96(1),wf16(:,26),G0H6(22),ngX,m3h16x6(:,68),heltab2x96(:,:,2394))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2427),h0tab(:,2427),[45,2,16],[nMT,nMH,nMW],3,1,wf16(:,26))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,26),G0H6(23),ngPbt,m3h16x6(:,69),heltab2x96(:,:,2395))
  call Hloop_A_Q(ntryL,G0H6(23),45,nMT,G1H6(58),n2h6(364))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2428),h0tab(:,2428),[45,2,16],[nMB,nMW,nMH],3,1,wf16(:,26))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,26),G0H6(23),ngH,m3h16x6(:,70),heltab2x96(:,:,2396))
  call Hloop_A_Q(ntryL,G0H6(23),45,nMB,G1H6(149),n2h6(365))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2429),h0tab(:,2429),[45,2,16],[nMT,nMZ,nMW],3,1,wf16(:,26))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,26),G0H6(23),ngPbt,m3h16x6(:,71),heltab2x96(:,:,2397))
  call Hloop_A_Q(ntryL,G0H6(23),45,nMT,G1H6(1),n2h6(366))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2430),h0tab(:,2430),[45,2,16],[nMB,nMW,nMZ],3,1,wf16(:,26))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,26),G0H6(23),ngX,m3h16x6(:,72),heltab2x96(:,:,2398))
  call Hloop_A_Q(ntryL,G0H6(23),45,nMB,G1H6(173),n2h6(367))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2431),h0tab(:,2431),[45,2,16],[0,nMT,nMB],3,1,wf16(:,26))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,26),G0H6(23),m3h16x6(:,73),heltab2x96(:,:,2399))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2432),h0tab(:,2432),[45,2,16],[nMZ,nMT,nMB],3,1,wf16(:,26))
  call Hloop_QA_Z(ntryL,G0H96(1),wf16(:,26),G0H6(24),ngZd,m3h16x6(:,74),heltab2x96(:,:,2400))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2433),h0tab(:,2433),[45,2,16],[nMB,nMW,0],3,1,wf16(:,26))
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,26),G0H6(25),m3h16x6(:,75),heltab2x96(:,:,2401))
  call Hloop_A_Q(ntryL,G0H6(25),45,nMB,G1H6(116),n2h6(368))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2434),h0tab(:,2434),[45,2,16],[nMB,nMW,nMZ],3,1,wf16(:,26))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf16(:,26),G0H6(25),ngZd,m3h16x6(:,76),heltab2x96(:,:,2402))
  call Hloop_A_Q(ntryL,G0H6(25),45,nMB,G1H6(127),n2h6(369))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2435),h0tab(:,2435),[45,2,16],[nMT,nMH,nMW],3,1,wf16(:,26))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,26),G0H6(25),m3h16x6(:,77),heltab2x96(:,:,2403))
  call Hloop_A_Q(ntryL,G0H6(25),45,nMT,G1H6(209),n2h6(370))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2436),h0tab(:,2436),[45,2,16],[nMT,0,nMW],3,1,wf16(:,26))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,26),G0H6(25),ngPbt,m3h16x6(:,78),heltab2x96(:,:,2404))
  call Hloop_A_Q(ntryL,G0H6(25),45,nMT,G1H6(240),n2h6(371))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2437),h0tab(:,2437),[45,2,16],[nMT,nMZ,nMW],3,1,wf16(:,26))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,26),G0H6(25),ngPbt,m3h16x6(:,79),heltab2x96(:,:,2405))
  call Hloop_A_Q(ntryL,G0H6(25),45,nMT,G1H6(154),n2h6(372))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2438),h0tab(:,2438),[45,2,16],[nMB,nMW,nMH],3,1,wf16(:,26))
  call Hloop_SA_Q(ntryL,G0H96(1),wf16(:,26),G0H6(25),ngH,m3h16x6(:,80),heltab2x96(:,:,2406))
  call Hloop_A_Q(ntryL,G0H6(25),45,nMB,G1H6(144),n2h6(373))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2439),h0tab(:,2439),[45,2,16],[nMT,0,nMW],3,1,wf16(:,26))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,26),G0H6(25),m3h16x6(:,81),heltab2x96(:,:,2407))
  call Hloop_A_Q(ntryL,G0H6(25),45,nMT,G1H6(73),n2h6(374))



end subroutine vamp_15

end module ol_vamp_15_ppwttj_ew_uttxdxwg_4_/**/REALKIND
