
module ol_colourmatrix_ppwttj_ew_uttxdxwg_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(138,6), K2(6,6), KL(6,6), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [   0,   0,   0,   0,   0,   0]
  K1(  2,:) = [   0,  12,   0,   0,   0,   0]
  K1(  3,:) = [   0,   0,   0,   0,   0,   0]
  K1(  4,:) = [   0,   0,   0,   0,   0,   0]
  K1(  5,:) = [   0,   0,   0,   0,  12,   0]
  K1(  6,:) = [   0,   0,   0,   0,   0,   0]
  K1(  7,:) = [   0,   0,   0,   0,   0,   0]
  K1(  8,:) = [   0,  16,   0,   0,   0,   0]
  K1(  9,:) = [   0,   0,   0,   0,   0,   0]
  K1( 10,:) = [   0,   0,   0,   0,   0,   0]
  K1( 11,:) = [   0,   0,   0,   0,  16,   0]
  K1( 12,:) = [   0,   0,   0,   0,   0,   0]
  K1( 13,:) = [   0,   0,   0,   0,   0,   0]
  K1( 14,:) = [   0,   0,   0,   0,   2,   0]
  K1( 15,:) = [   0,   0,   0,   0,   0,   0]
  K1( 16,:) = [   0,   0,   0,   0,   0,   0]
  K1( 17,:) = [   0,   2,   0,   0,   0,   0]
  K1( 18,:) = [   0,   0,   0,   0,   0,   0]
  K1( 19,:) = [   0,   0,   0,   0,   0,   0]
  K1( 20,:) = [   0,  16,   0,   0,   0,   0]
  K1( 21,:) = [   0,   0,   0,   0,   0,   0]
  K1( 22,:) = [   0,   0,   0,   0,   0,   0]
  K1( 23,:) = [   0,   0,   0,   0,  16,   0]
  K1( 24,:) = [   0,   0,   0,   0,   0,   0]
  K1( 25,:) = [   0,   0,   0,   0,   0,   0]
  K1( 26,:) = [   0,   0,   0,   0,  -2,   0]
  K1( 27,:) = [   0,   0,   0,   0,   0,   0]
  K1( 28,:) = [   0,   0,   0,   0,   0,   0]
  K1( 29,:) = [   0,  -2,   0,   0,   0,   0]
  K1( 30,:) = [   0,   0,   0,   0,   0,   0]
  K1( 31,:) = [   0,   0,   0,   0,   0,   0]
  K1( 32,:) = [   0,   2,   0,   0,   0,   0]
  K1( 33,:) = [   0,   0,   0,   0,   0,   0]
  K1( 34,:) = [   0,   0,   0,   0,   0,   0]
  K1( 35,:) = [   0,   0,   0,   0, -16,   0]
  K1( 36,:) = [   0,   0,   0,   0,   0,   0]
  K1( 37,:) = [   0,   0,   0,   0,   0,   0]
  K1( 38,:) = [   0,  16,   0,   0,   0,   0]
  K1( 39,:) = [   0,   0,   0,   0,   0,   0]
  K1( 40,:) = [   0,   0,   0,   0,   0,   0]
  K1( 41,:) = [   0,   0,   0,   0,  16,   0]
  K1( 42,:) = [   0,   0,   0,   0,   0,   0]
  K1( 43,:) = [   0,   0,   0,   0,   0,   0]
  K1( 44,:) = [   0, -16,   0,   0,   0,   0]
  K1( 45,:) = [   0,   0,   0,   0,   0,   0]
  K1( 46,:) = [   0,   0,   0,   0,   0,   0]
  K1( 47,:) = [   0,   0,   0,   0,   2,   0]
  K1( 48,:) = [   0,   0,   0,   0,   0,   0]
  K1( 49,:) = [   0,   0,   0,   0,   0,   0]
  K1( 50,:) = [   0,   0,   0,   0,  -2,   0]
  K1( 51,:) = [   0,   0,   0,   0,   0,   0]
  K1( 52,:) = [   0,   0,   0,   0,   0,   0]
  K1( 53,:) = [   0,  -2,   0,   0,   0,   0]
  K1( 54,:) = [   0,   0,   0,   0,   0,   0]
  K1( 55,:) = [   0,   0,   0,   0,   0,   0]
  K1( 56,:) = [   0,   0,   0,   0,   2,   0]
  K1( 57,:) = [   0,   0,   0,   0,   0,   0]
  K1( 58,:) = [   0,   0,   0,   0,   0,   0]
  K1( 59,:) = [   0,   2,   0,   0,   0,   0]
  K1( 60,:) = [   0,   0,   0,   0,   0,   0]
  K1( 61,:) = [   0,   0,   0,   0,   0,   0]
  K1( 62,:) = [   0,  16,   0,   0,   0,   0]
  K1( 63,:) = [   0,   0,   0,   0,   0,   0]
  K1( 64,:) = [   0,   0,   0,   0,   0,   0]
  K1( 65,:) = [   0,   0,   0,   0,  16,   0]
  K1( 66,:) = [   0,   0,   0,   0,   0,   0]
  K1( 67,:) = [   0,   0,   0,   0,   0,   0]
  K1( 68,:) = [   0,   0,   0,   0,   0,   0]
  K1( 69,:) = [   0,   0,   0,   0,   0,   0]
  K1( 70,:) = [   0,   0,   0,   0,   0,   0]
  K1( 71,:) = [   0,   0,   0,   0,   0,   0]
  K1( 72,:) = [   0,   0,   0,   0,   0,   0]
  K1( 73,:) = [   0,   0,   0,   0,   0,   0]
  K1( 74,:) = [   0,   0,   0,   0,   0,   0]
  K1( 75,:) = [   0,   0,   0,   0,   0,   0]
  K1( 76,:) = [   0,   0,   0,   0,   0,   0]
  K1( 77,:) = [   0,   0,   0,   0,   0,   0]
  K1( 78,:) = [   0,   0,   0,   0,   0,   0]
  K1( 79,:) = [   0,   0,   0,   0,   0,   0]
  K1( 80,:) = [   0,   0,   0,   0,   0,   0]
  K1( 81,:) = [   0,   0,   0,   0,   0,   0]
  K1( 82,:) = [   0,   0,   0,   0,   0,   0]
  K1( 83,:) = [   0,   0,   0,   0,   0,   0]
  K1( 84,:) = [   0,   0,   0,   0,   0,   0]
  K1( 85,:) = [   0,   0,   0,   0,   0,   0]
  K1( 86,:) = [   0,   0,   0,   0,   0,   0]
  K1( 87,:) = [   0,   0,   0,   0,   0,   0]
  K1( 88,:) = [   0,   0,   0,   0,   0,   0]
  K1( 89,:) = [   0,   0,   0,   0,   0,   0]
  K1( 90,:) = [   0,   0,   0,   0,   0,   0]
  K1( 91,:) = [   0,   0,   0,   0,   0,   0]
  K1( 92,:) = [   0,   0,   0,   0,   0,   0]
  K1( 93,:) = [   0,   0,   0,   0,   0,   0]
  K1( 94,:) = [   0,   0,   0,   0,   0,   0]
  K1( 95,:) = [   0,   0,   0,   0,   0,   0]
  K1( 96,:) = [   0,   0,   0,   0,   0,   0]
  K1( 97,:) = [   0,   0,   0,   0,   0,   0]
  K1( 98,:) = [   0,   0,   0,   0,   0,   0]
  K1( 99,:) = [   0,   0,   0,   0,   0,   0]
  K1(100,:) = [   0,   0,   0,   0,   0,   0]
  K1(101,:) = [   0,   0,   0,   0, -18,   0]
  K1(102,:) = [   0,   0,   0,   0,   0,   0]
  K1(103,:) = [   0,   0,   0,   0,   0,   0]
  K1(104,:) = [   0, -18,   0,   0,   0,   0]
  K1(105,:) = [   0,   0,   0,   0,   0,   0]
  K1(106,:) = [   0,   0,   0,   0,   0,   0]
  K1(107,:) = [   0,   0,   0,   0,   0,   0]
  K1(108,:) = [   0,   0,   0,   0,   0,   0]
  K1(109,:) = [   0,   0,   0,   0,   0,   0]
  K1(110,:) = [   0, -18,   0,   0,   0,   0]
  K1(111,:) = [   0,   0,   0,   0,   0,   0]
  K1(112,:) = [   0,   0,   0,   0,   0,   0]
  K1(113,:) = [   0,   0,   0,   0,   0,   0]
  K1(114,:) = [   0,   0,   0,   0,   0,   0]
  K1(115,:) = [   0,   0,   0,   0,   0,   0]
  K1(116,:) = [   0,   0,   0,   0,   0,   0]
  K1(117,:) = [   0,   0,   0,   0,   0,   0]
  K1(118,:) = [   0,   0,   0,   0,   0,   0]
  K1(119,:) = [   0,   0,   0,   0, -18,   0]
  K1(120,:) = [   0,   0,   0,   0,   0,   0]
  K1(121,:) = [   0,   0,   0,   0,   0,   0]
  K1(122,:) = [   0,   0,   0,   0,   0,   0]
  K1(123,:) = [   0,   0,   0,   0,   0,   0]
  K1(124,:) = [   0,   0,   0,   0,   0,   0]
  K1(125,:) = [   0,   0,   0,   0,   0,   0]
  K1(126,:) = [   0,   0,   0,   0,   0,   0]
  K1(127,:) = [   0,   0,   0,   0,   0,   0]
  K1(128,:) = [   0,  36,   0,   0,   0,   0]
  K1(129,:) = [   0,   0,   0,   0,   0,   0]
  K1(130,:) = [   0,   0,   0,   0,   0,   0]
  K1(131,:) = [   0,   0,   0,   0,  36,   0]
  K1(132,:) = [   0,   0,   0,   0,   0,   0]
  K1(133,:) = [   0,   4,   0,   0,   4,   0]
  K1(134,:) = [   4,   0,  12,   0,   0,   4]
  K1(135,:) = [   0,  12,   0,   0,   0,   0]
  K1(136,:) = [   0,   0,   0,   0,  12,   0]
  K1(137,:) = [   4,   0,   0,  12,   0,   4]
  K1(138,:) = [   0,   4,   0,   0,   4,   0]

  K2(1,:) = [  0,  4,  0,  0,  4,  0]
  K2(2,:) = [  4,  0, 12,  0,  0,  4]
  K2(3,:) = [  0, 12,  0,  0,  0,  0]
  K2(4,:) = [  0,  0,  0,  0, 12,  0]
  K2(5,:) = [  4,  0,  0, 12,  0,  4]
  K2(6,:) = [  0,  4,  0,  0,  4,  0]

  KL(1,:) = [  0,  0,  4,  0,  4,  0]
  KL(2,:) = [  4, 12,  0,  0,  0,  4]
  KL(3,:) = [  0,  0, 12,  0,  0,  0]
  KL(4,:) = [  0,  0,  0,  0, 12,  0]
  KL(5,:) = [  4,  0,  0, 12,  0,  4]
  KL(6,:) = [  0,  0,  4,  0,  4,  0]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+6*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppwttj_ew_uttxdxwg_3_/**/REALKIND



module ol_forced_parameters_ppwttj_ew_uttxdxwg_3_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppwttj_ew_uttxdxwg_3_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppwttj_ew_uttxdxwg_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 96 ! number of helicity configurations
  integer(intkind2), save :: nhel = 96 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 96 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(96) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(533)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(3), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,63), wf6(6,24), wf8(8,153), wf12(12,117), wf16(16,58), wf24(24,119), wf96(96,681)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(385), c(334)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppwttj_ew_uttxdxwg_3_/**/REALKIND






! **********************************************************************
module ol_loop_ppwttj_ew_uttxdxwg_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppwttj_ew_uttxdxwg_3_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**3)/(cw*sqrt2)
    f(  2) = (CI*countertermnorm*eQED**5*gQCD*MW)/(cw*sqrt2)
    f(  3) = (CI*eQED**3*gQCD*MT)/(2._/**/REALKIND*sqrt2*sw**3)
    f(  4) = (CI*countertermnorm*eQED**5*gQCD*MT)/(2._/**/REALKIND*sqrt2*sw**3)
    f(  5) = (CI*countertermnorm*eQED**5*EWctVdu*gQCD*MT)/(2._/**/REALKIND*sqrt2*sw**3)
    f(  6) = (CI*countertermnorm*eQED**3*gQCD**3*MT)/(2._/**/REALKIND*sqrt2*sw**3)
    f(  7) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3*MT)/(2._/**/REALKIND*sqrt2*sw**3)
    f(  8) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*MT)/(2._/**/REALKIND*sqrt2*sw**3)
    f(  9) = (CI*countertermnorm*ctStt*eQED**3*gQCD**3*MT)/(2._/**/REALKIND*sqrt2*sw**3)
    f( 10) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3*MT)/(2._/**/REALKIND*sqrt2*sw**3)
    f( 11) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW**2*sqrt2*sw**3)
    f( 12) = (CI*countertermnorm*eQED**5*gQCD*MT)/(4._/**/REALKIND*MW*sqrt2*sw**3)
    f( 13) = (countertermnorm*cw*eQED**5*gQCD*MT)/(MW*sqrt2*sw**3*2._/**/REALKIND)
    f( 14) = (CI*eQED**3*gQCD*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 15) = (CI*countertermnorm*eQED**5*gQCD*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 16) = (CI*countertermnorm*eQED**5*EWctVbt*gQCD*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 17) = (CI*countertermnorm*eQED**5*EWctVdu*gQCD*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 18) = (CI*countertermnorm*eQED**5*EWctVtb*gQCD*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 19) = (CI*countertermnorm*eQED**3*gQCD**3*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 20) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 21) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 22) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 23) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**3*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 24) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 25) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**3*sqrt2)/(4._/**/REALKIND*MW**2*sw**3)
    f( 26) = (CI*countertermnorm*eQED**5*gQCD*sqrt2)/(4._/**/REALKIND*MW*sw**3)
    f( 27) = (CI*cw*eQED**3*gQCD)/(sqrt2*sw**2)
    f( 28) = (2*CI*countertermnorm*cw*eQED**5*gQCD)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 29) = (CI*countertermnorm*cw*eQED**5*gQCD)/(sqrt2*sw**2)
    f( 30) = (CI*countertermnorm*cw*eQED**5*EWctVdu*gQCD)/(sqrt2*sw**2)
    f( 31) = (CI*countertermnorm*cw*eQED**3*gQCD**3)/(sqrt2*sw**2)
    f( 32) = (CI*countertermnorm*ctGqq*cw*eQED**3*gQCD**3)/(sqrt2*sw**2)
    f( 33) = (CI*countertermnorm*ctGtt*cw*eQED**3*gQCD**3)/(sqrt2*sw**2)
    f( 34) = (CI*countertermnorm*ctVqq*cw*eQED**3*gQCD**3)/(sqrt2*sw**2)
    f( 35) = (CI*countertermnorm*ctVtt*cw*eQED**3*gQCD**3)/(sqrt2*sw**2)
    f( 36) = (countertermnorm*ctZGG*cw*eQED**3*gQCD**3)/(sqrt2*sw**2)
    f( 37) = (CI*countertermnorm*eQED**5*gQCD*MT)/(sqrt2*sw**2)
    f( 38) = (countertermnorm*eQED**5*gQCD*MT)/(MW*sqrt2*sw**2*6._/**/REALKIND)
    f( 39) = (countertermnorm*eQED**5*gQCD*MT)/(MW*sqrt2*sw**2*3._/**/REALKIND)
    f( 40) = (countertermnorm*eQED**5*gQCD*MT)/(MW*sqrt2*sw**2*2._/**/REALKIND)
    f( 41) = (CI*countertermnorm*eQED**5*EWctHWW*gQCD*MT)/(2._/**/REALKIND*MW*sqrt2*sw**2)
    f( 42) = (CI*countertermnorm*ctHGG*eQED**3*gQCD**3*MT)/(2._/**/REALKIND*MW*sqrt2*sw**2)
    f( 43) = (CI*countertermnorm*ctHGG*eQED**3*gQCD**3*MW)/(sqrt2*sw**2)
    f( 44) = (2*CI*eQED**3*gQCD)/(9._/**/REALKIND*sqrt2*sw)
    f( 45) = (4*CI*eQED**3*gQCD)/(9._/**/REALKIND*sqrt2*sw)
    f( 46) = (2*CI*eQED**3*gQCD)/(3._/**/REALKIND*sqrt2*sw)
    f( 47) = (CI*eQED**3*gQCD)/(sqrt2*sw)
    f( 48) = (2*CI*countertermnorm*eQED**5*gQCD)/(9._/**/REALKIND*sqrt2*sw)
    f( 49) = (CI*countertermnorm*eQED**5*gQCD)/(3._/**/REALKIND*sqrt2*sw)
    f( 50) = (4*CI*countertermnorm*eQED**5*gQCD)/(9._/**/REALKIND*sqrt2*sw)
    f( 51) = (2*CI*countertermnorm*eQED**5*gQCD)/(3._/**/REALKIND*sqrt2*sw)
    f( 52) = (CI*countertermnorm*eQED**5*gQCD)/(sqrt2*sw)
    f( 53) = (2*CI*countertermnorm*eQED**5*EWctAWW*gQCD)/(3._/**/REALKIND*sqrt2*sw)
    f( 54) = (2*CI*countertermnorm*eQED**5*EWctVdu*gQCD)/(9._/**/REALKIND*sqrt2*sw)
    f( 55) = (4*CI*countertermnorm*eQED**5*EWctVdu*gQCD)/(9._/**/REALKIND*sqrt2*sw)
    f( 56) = (2*CI*countertermnorm*eQED**5*EWctVdu*gQCD)/(3._/**/REALKIND*sqrt2*sw)
    f( 57) = (CI*countertermnorm*eQED**5*EWctVdu*gQCD)/(sqrt2*sw)
    f( 58) = (CI*countertermnorm*eQED**5*EWctZWW*gQCD)/(sqrt2*sw)
    f( 59) = (CI*eQED*gQCD**3)/(sqrt2*sw)
    f( 60) = (eQED*gQCD**3)/(sqrt2*sw)
    f( 61) = (2*CI*countertermnorm*eQED**3*gQCD**3)/(9._/**/REALKIND*sqrt2*sw)
    f( 62) = (4*CI*countertermnorm*eQED**3*gQCD**3)/(9._/**/REALKIND*sqrt2*sw)
    f( 63) = (2*CI*countertermnorm*eQED**3*gQCD**3)/(3._/**/REALKIND*sqrt2*sw)
    f( 64) = (CI*countertermnorm*eQED**3*gQCD**3)/(sqrt2*sw)
    f( 65) = (countertermnorm*eQED**3*gQCD**3)/(sqrt2*sw)
    f( 66) = (2*CI*countertermnorm*ctGqq*eQED**3*gQCD**3)/(9._/**/REALKIND*sqrt2*sw)
    f( 67) = (4*CI*countertermnorm*ctGqq*eQED**3*gQCD**3)/(9._/**/REALKIND*sqrt2*sw)
    f( 68) = (2*CI*countertermnorm*ctGqq*eQED**3*gQCD**3)/(3._/**/REALKIND*sqrt2*sw)
    f( 69) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3)/(sqrt2*sw)
    f( 70) = (2*CI*countertermnorm*ctGtt*eQED**3*gQCD**3)/(9._/**/REALKIND*sqrt2*sw)
    f( 71) = (4*CI*countertermnorm*ctGtt*eQED**3*gQCD**3)/(9._/**/REALKIND*sqrt2*sw)
    f( 72) = (2*CI*countertermnorm*ctGtt*eQED**3*gQCD**3)/(3._/**/REALKIND*sqrt2*sw)
    f( 73) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3)/(sqrt2*sw)
    f( 74) = (2*CI*countertermnorm*ctSqq*eQED**3*gQCD**3)/(3._/**/REALKIND*sqrt2*sw)
    f( 75) = (2*CI*countertermnorm*ctVqq*eQED**3*gQCD**3)/(9._/**/REALKIND*sqrt2*sw)
    f( 76) = (4*CI*countertermnorm*ctVqq*eQED**3*gQCD**3)/(9._/**/REALKIND*sqrt2*sw)
    f( 77) = (2*CI*countertermnorm*ctVqq*eQED**3*gQCD**3)/(3._/**/REALKIND*sqrt2*sw)
    f( 78) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3)/(sqrt2*sw)
    f( 79) = (2*CI*countertermnorm*ctVtt*eQED**3*gQCD**3)/(9._/**/REALKIND*sqrt2*sw)
    f( 80) = (4*CI*countertermnorm*ctVtt*eQED**3*gQCD**3)/(9._/**/REALKIND*sqrt2*sw)
    f( 81) = (2*CI*countertermnorm*ctVtt*eQED**3*gQCD**3)/(3._/**/REALKIND*sqrt2*sw)
    f( 82) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**3)/(sqrt2*sw)
    f( 83) = (CI*countertermnorm*ctWWGG*eQED**3*gQCD**3)/(sqrt2*sw)
    f( 84) = (countertermnorm*ctZGG*eQED**3*gQCD**3)/(sqrt2*sw)
    f( 85) = (CI*countertermnorm*eQED**3*EWctVdu*gQCD**3)/(sqrt2*sw)
    f( 86) = (countertermnorm*eQED**3*EWctVdu*gQCD**3)/(sqrt2*sw)
    f( 87) = (2*CI*countertermnorm*eQED**5*gQCD*MW)/(3._/**/REALKIND*sqrt2*sw)
    f( 88) = (eQED**5*gQCD*integralnorm*MW**2*SwB)/(cw*sqrt2*3._/**/REALKIND)
    f( 89) = (2*eQED**5*gQCD*integralnorm*MW**2*SwB)/(cw*sqrt2*3._/**/REALKIND)
    f( 90) = (eQED**5*gQCD*integralnorm*MW**2*SwB)/(cw*sqrt2)
    f( 91) = (eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**5*8._/**/REALKIND)
    f( 92) = (eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**5*4._/**/REALKIND)
    f( 93) = (eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**5*2._/**/REALKIND)
    f( 94) = (eQED**5*gQCD*integralnorm*MT*SwB)/(cw**2*sqrt2*sw**5*8._/**/REALKIND)
    f( 95) = (eQED**5*gQCD*integralnorm*MT*SwB)/(cw**2*sqrt2*sw**5*4._/**/REALKIND)
    f( 96) = (cw**2*eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**5*4._/**/REALKIND)
    f( 97) = (cw**2*eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**5*2._/**/REALKIND)
    f( 98) = (3*eQED**5*gQCD*integralnorm*lambdaHHH*MH**2*MT*SwB)/(sqrt2*sw**5*4._/**/REALKIND)
    f( 99) = (eQED**5*gQCD*integralnorm*MT**2*SwB)/(sqrt2*sw**5*4._/**/REALKIND)
    f(100) = (eQED**5*gQCD*integralnorm*MH**2*MT*SwB)/(MW**2*sqrt2*sw**5*16._/**/REALKIND)
    f(101) = (eQED**5*gQCD*integralnorm*MH**2*MT*SwB)/(MW**2*sqrt2*sw**5*8._/**/REALKIND)
    f(102) = (3*eQED**5*gQCD*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW**2*sqrt2*sw**5*16._/**/REALKIND)
    f(103) = (eQED**5*gQCD*integralnorm*MH**4*MT*SwB)/(MW**2*sqrt2*sw**5*16._/**/REALKIND)
    f(104) = (eQED**5*gQCD*integralnorm*MH**4*MT*SwB)/(MW**2*sqrt2*sw**5*8._/**/REALKIND)
    f(105) = (9*eQED**5*gQCD*integralnorm*lambdaHHH**2*MH**4*MT*SwB)/(MW**2*sqrt2*sw**5*16._/**/REALKIND)
    f(106) = (eQED**5*gQCD*integralnorm*MT**2*SwB)/(MW**2*sqrt2*sw**5*16._/**/REALKIND)
    f(107) = (eQED**5*gQCD*integralnorm*MT**2*SwB)/(MW**2*sqrt2*sw**5*8._/**/REALKIND)
    f(108) = (eQED**5*gQCD*integralnorm*MH**2*MT**2*SwB)/(MW**2*sqrt2*sw**5*8._/**/REALKIND)
    f(109) = (3*eQED**5*gQCD*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**2*sqrt2*sw**5*8._/**/REALKIND)
    f(110) = (eQED**5*gQCD*integralnorm*MT**3*SwB)/(MW**2*sqrt2*sw**5*8._/**/REALKIND)
    f(111) = (eQED**5*gQCD*integralnorm*MT*MW**2*SwB)/(sqrt2*sw**5*8._/**/REALKIND)
    f(112) = (eQED**5*gQCD*integralnorm*MT*MW**2*SwB)/(sqrt2*sw**5*2._/**/REALKIND)
    f(113) = (eQED**5*gQCD*integralnorm*MT*MW**2*SwB)/(cw**4*sqrt2*sw**5*8._/**/REALKIND)
    f(114) = (eQED**5*gQCD*integralnorm*MT*MW**2*SwB)/(cw**4*sqrt2*sw**5*4._/**/REALKIND)
    f(115) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(sw**5*16._/**/REALKIND)
    f(116) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(sw**5*8._/**/REALKIND)
    f(117) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(sw**5*4._/**/REALKIND)
    f(118) = (cw**2*eQED**5*gQCD*integralnorm*sqrt2*SwB)/(sw**5*4._/**/REALKIND)
    f(119) = (eQED**5*gQCD*integralnorm*MB*sqrt2*SwB)/(sw**5*8._/**/REALKIND)
    f(120) = (eQED**5*gQCD*integralnorm*MT*sqrt2*SwB)/(sw**5*8._/**/REALKIND)
    f(121) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(122) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(123) = (eQED**5*gQCD*integralnorm*MB*sqrt2*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(124) = (eQED**5*gQCD*integralnorm*MB*sqrt2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(125) = (eQED**5*gQCD*integralnorm*MB**2*sqrt2*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(126) = (eQED**5*gQCD*integralnorm*MH**2*sqrt2*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(127) = (eQED**5*gQCD*integralnorm*MH**2*sqrt2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(128) = (eQED**5*gQCD*integralnorm*MT*sqrt2*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(129) = (eQED**5*gQCD*integralnorm*MT*sqrt2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(130) = (eQED**5*gQCD*integralnorm*MB*MT*sqrt2*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(131) = (eQED**5*gQCD*integralnorm*MT**2*sqrt2*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(132) = (eQED**5*gQCD*integralnorm*MW**2*sqrt2*SwB)/(sw**5*4._/**/REALKIND)
    f(133) = (eQED**5*gQCD*integralnorm*SwB)/(cw*sqrt2*sw**4*8._/**/REALKIND)
    f(134) = (eQED**5*gQCD*integralnorm*SwB)/(cw*sqrt2*sw**4*4._/**/REALKIND)
    f(135) = (cw*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**4*4._/**/REALKIND)
    f(136) = (cw*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**4)
    f(137) = (cw**3*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**4)
    f(138) = (eQED**5*gQCD*integralnorm*MT*SwB)/(cw**3*sqrt2*sw**4*4._/**/REALKIND)
    f(139) = (eQED**5*gQCD*integralnorm*MT*SwB)/(cw*sqrt2*sw**4*4._/**/REALKIND)
    f(140) = (eQED**5*gQCD*integralnorm*MT*SwB)/(cw*sqrt2*sw**4*2._/**/REALKIND)
    f(141) = (cw*eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**4*4._/**/REALKIND)
    f(142) = (cw*eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**4*2._/**/REALKIND)
    f(143) = (eQED**5*gQCD*integralnorm*MH**2*MT*SwB)/(cw*MW**2*sqrt2*sw**4*8._/**/REALKIND)
    f(144) = (eQED**5*gQCD*integralnorm*MT**2*SwB)/(cw*MW**2*sqrt2*sw**4*8._/**/REALKIND)
    f(145) = (cw*eQED**5*gQCD*integralnorm*MT**2*SwB)/(MW**2*sqrt2*sw**4*4._/**/REALKIND)
    f(146) = (eQED**5*gQCD*integralnorm*MW**2*SwB)/(cw**3*sqrt2*sw**4)
    f(147) = (eQED**5*gQCD*integralnorm*MW**2*SwB)/(cw*sqrt2*sw**4)
    f(148) = (cw*eQED**5*gQCD*integralnorm*MW**2*SwB)/(sqrt2*sw**4*2._/**/REALKIND)
    f(149) = (cw*eQED**5*gQCD*integralnorm*MW**2*SwB)/(sqrt2*sw**4)
    f(150) = (cw*eQED**5*gQCD*integralnorm*sqrt2*SwB)/(sw**4*4._/**/REALKIND)
    f(151) = (cw*eQED**5*gQCD*integralnorm*sqrt2*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(152) = (eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**3*6._/**/REALKIND)
    f(153) = (eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(154) = (2*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(155) = (eQED**5*gQCD*integralnorm*SwB)/(cw**2*sqrt2*sw**3*4._/**/REALKIND)
    f(156) = (2*cw**2*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(157) = (cw**2*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**3)
    f(158) = (eQED**5*gQCD*integralnorm*MH**2*SwB)/(sqrt2*sw**3*6._/**/REALKIND)
    f(159) = (eQED**5*gQCD*integralnorm*MH**2*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(160) = (eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**3*18._/**/REALKIND)
    f(161) = (eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**3*12._/**/REALKIND)
    f(162) = (eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**3*9._/**/REALKIND)
    f(163) = (eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**3*6._/**/REALKIND)
    f(164) = (2*eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**3*9._/**/REALKIND)
    f(165) = (eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**3*4._/**/REALKIND)
    f(166) = (eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(167) = (eQED**5*gQCD*integralnorm*MT*SwB)/(sqrt2*sw**3*2._/**/REALKIND)
    f(168) = (eQED**5*gQCD*integralnorm*MT*SwB)/(cw**2*sqrt2*sw**3*8._/**/REALKIND)
    f(169) = (eQED**5*gQCD*integralnorm*MT*SwB)/(cw**2*sqrt2*sw**3*2._/**/REALKIND)
    f(170) = (CI*eQED**3*gQCD**3*integralnorm*MT*SwB)/(2._/**/REALKIND*sqrt2*sw**3)
    f(171) = (eQED**3*gQCD**3*integralnorm*MT*SwB)/(sqrt2*sw**3*2._/**/REALKIND)
    f(172) = (eQED**5*gQCD*integralnorm*MH**2*MT*SwB)/(sqrt2*sw**3*4._/**/REALKIND)
    f(173) = (eQED**5*gQCD*integralnorm*MH**2*MT*SwB)/(MW**2*sqrt2*sw**3*12._/**/REALKIND)
    f(174) = (eQED**5*gQCD*integralnorm*MH**2*MT*SwB)/(MW**2*sqrt2*sw**3*6._/**/REALKIND)
    f(175) = (eQED**5*gQCD*integralnorm*MH**2*MT*SwB)/(MW**2*sqrt2*sw**3*4._/**/REALKIND)
    f(176) = (eQED**5*gQCD*integralnorm*MT**2*SwB)/(MW**2*sqrt2*sw**3*18._/**/REALKIND)
    f(177) = (eQED**5*gQCD*integralnorm*MT**2*SwB)/(MW**2*sqrt2*sw**3*9._/**/REALKIND)
    f(178) = (eQED**5*gQCD*integralnorm*MT**2*SwB)/(MW**2*sqrt2*sw**3*6._/**/REALKIND)
    f(179) = (eQED**5*gQCD*integralnorm*MT**2*SwB)/(MW**2*sqrt2*sw**3*4._/**/REALKIND)
    f(180) = (CI*eQED**3*gQCD**3*integralnorm*MT**2*SwB)/(4._/**/REALKIND*MW**2*sqrt2*sw**3)
    f(181) = (eQED**3*gQCD**3*integralnorm*MT**2*SwB)/(MW**2*sqrt2*sw**3*4._/**/REALKIND)
    f(182) = (eQED**5*gQCD*integralnorm*MW**2*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(183) = (2*eQED**5*gQCD*integralnorm*MW**2*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(184) = (eQED**5*gQCD*integralnorm*MW**2*SwB)/(cw**4*sqrt2*sw**3)
    f(185) = (eQED**5*gQCD*integralnorm*MW**2*SwB)/(cw**2*sqrt2*sw**3)
    f(186) = (eQED**5*gQCD*integralnorm*MT*MW**2*SwB)/(sqrt2*sw**3*2._/**/REALKIND)
    f(187) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(sw**3*36._/**/REALKIND)
    f(188) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(sw**3*18._/**/REALKIND)
    f(189) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(sw**3*12._/**/REALKIND)
    f(190) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(sw**3*9._/**/REALKIND)
    f(191) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(sw**3*6._/**/REALKIND)
    f(192) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(sw**3*4._/**/REALKIND)
    f(193) = (CI*eQED**3*gQCD**3*integralnorm*sqrt2*SwB)/(4._/**/REALKIND*sw**3)
    f(194) = (eQED**3*gQCD**3*integralnorm*sqrt2*SwB)/(sw**3*4._/**/REALKIND)
    f(195) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(MW**2*sw**3*36._/**/REALKIND)
    f(196) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(MW**2*sw**3*18._/**/REALKIND)
    f(197) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(MW**2*sw**3*12._/**/REALKIND)
    f(198) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(MW**2*sw**3*9._/**/REALKIND)
    f(199) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(MW**2*sw**3*6._/**/REALKIND)
    f(200) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(MW**2*sw**3*4._/**/REALKIND)
    f(201) = (CI*eQED**3*gQCD**3*integralnorm*sqrt2*SwB)/(4._/**/REALKIND*MW**2*sw**3)
    f(202) = (eQED**3*gQCD**3*integralnorm*sqrt2*SwB)/(MW**2*sw**3*4._/**/REALKIND)
    f(203) = (eQED**5*gQCD*integralnorm*MW**2*sqrt2*SwB)/(sw**3*4._/**/REALKIND)
    f(204) = (eQED**5*gQCD*integralnorm*SwB)/(cw*sqrt2*sw**2*4._/**/REALKIND)
    f(205) = (cw*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**2*9._/**/REALKIND)
    f(206) = (2*cw*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**2*9._/**/REALKIND)
    f(207) = (cw*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(208) = (4*cw*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**2*9._/**/REALKIND)
    f(209) = (2*cw*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(210) = (cw*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw**2)
    f(211) = (CI*cw*eQED**3*gQCD**3*integralnorm*SwB)/(sqrt2*sw**2)
    f(212) = (cw*eQED**3*gQCD**3*integralnorm*SwB)/(sqrt2*sw**2)
    f(213) = (eQED**5*gQCD*integralnorm*MH**2*SwB)/(cw*sqrt2*sw**2*4._/**/REALKIND)
    f(214) = (eQED**5*gQCD*integralnorm*MT*SwB)/(cw*sqrt2*sw**2*4._/**/REALKIND)
    f(215) = (eQED**5*gQCD*integralnorm*MW**2*SwB)/(cw**3*sqrt2*sw**2*2._/**/REALKIND)
    f(216) = (eQED**5*gQCD*integralnorm*MW**2*SwB)/(cw*sqrt2*sw**2*2._/**/REALKIND)
    f(217) = (cw*eQED**5*gQCD*integralnorm*MW**2*SwB)/(sqrt2*sw**2)
    f(218) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(219) = (2*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*81._/**/REALKIND)
    f(220) = (4*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*81._/**/REALKIND)
    f(221) = (2*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*27._/**/REALKIND)
    f(222) = (8*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*81._/**/REALKIND)
    f(223) = (eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(224) = (4*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*27._/**/REALKIND)
    f(225) = (16*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*81._/**/REALKIND)
    f(226) = (2*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(227) = (8*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*27._/**/REALKIND)
    f(228) = (eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(229) = (4*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(230) = (2*eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(231) = (eQED**5*gQCD*integralnorm*SwB)/(sqrt2*sw)
    f(232) = (CI*eQED**3*gQCD**3*integralnorm*SwB)/(9._/**/REALKIND*sqrt2*sw)
    f(233) = (2*CI*eQED**3*gQCD**3*integralnorm*SwB)/(9._/**/REALKIND*sqrt2*sw)
    f(234) = (CI*eQED**3*gQCD**3*integralnorm*SwB)/(3._/**/REALKIND*sqrt2*sw)
    f(235) = (4*CI*eQED**3*gQCD**3*integralnorm*SwB)/(9._/**/REALKIND*sqrt2*sw)
    f(236) = (2*CI*eQED**3*gQCD**3*integralnorm*SwB)/(3._/**/REALKIND*sqrt2*sw)
    f(237) = (CI*eQED**3*gQCD**3*integralnorm*SwB)/(sqrt2*sw)
    f(238) = (eQED**3*gQCD**3*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(239) = (2*eQED**3*gQCD**3*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(240) = (eQED**3*gQCD**3*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(241) = (4*eQED**3*gQCD**3*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(242) = (2*eQED**3*gQCD**3*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(243) = (eQED**3*gQCD**3*integralnorm*SwB)/(sqrt2*sw)
    f(244) = (eQED**5*gQCD*integralnorm*MT*SwB)/(cw**2*sqrt2*sw*4._/**/REALKIND)
    f(245) = (eQED**5*gQCD*integralnorm*MH**2*MT*SwB)/(cw**2*sqrt2*sw*4._/**/REALKIND)
    f(246) = (2*eQED**5*gQCD*integralnorm*MW**2*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(247) = (4*eQED**5*gQCD*integralnorm*MW**2*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(248) = (2*eQED**5*gQCD*integralnorm*MW**2*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(249) = (eQED**5*gQCD*integralnorm*MT*MW**2*SwB)/(cw**4*sqrt2*sw*2._/**/REALKIND)
    f(250) = (eQED**5*gQCD*integralnorm*MT*MW**2*SwB)/(cw**2*sqrt2*sw*2._/**/REALKIND)
    f(251) = (eQED**5*gQCD*integralnorm*sqrt2*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(252) = (eQED**5*gQCD*integralnorm*MW**2*sqrt2*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(253) = (2*eQED**5*gQCD*integralnorm*MW**2*sw*SwB)/(cw**2*sqrt2*3._/**/REALKIND)
    f(254) = (eQED**5*gQCD*integralnorm*MW**2*sw*SwB)/(cw**2*sqrt2)
    f(255) = -((eQED**5*gQCD*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**5*8._/**/REALKIND))
    f(256) = -((eQED**5*gQCD*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(MW**2*sqrt2*sw**5*8._/**/REALKIND))
    f(257) = -((eQED**5*gQCD*integralnorm*sqrt2*(cw - sw)*(cw + sw)*SwB)/(sw**5*8._/**/REALKIND))
    f(258) = -((eQED**5*gQCD*integralnorm*sqrt2*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**5*8._/**/REALKIND))
    f(259) = -((eQED**5*gQCD*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**4*8._/**/REALKIND))
    f(260) = -((eQED**5*gQCD*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**4*4._/**/REALKIND))
    f(261) = (eQED**5*gQCD*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**2*6._/**/REALKIND)
    f(262) = (eQED**5*gQCD*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**2*3._/**/REALKIND)
    f(263) = (eQED**5*gQCD*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**2*2._/**/REALKIND)
    f(264) = -((eQED**5*gQCD*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw*sqrt2*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(265) = -((eQED**5*gQCD*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**4*4._/**/REALKIND))
    f(266) = -((eQED**5*gQCD*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sqrt2*sw**4*8._/**/REALKIND))
    f(267) = (eQED**5*gQCD*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**2*2._/**/REALKIND)
    f(268) = -((eQED**5*gQCD*integralnorm*sqrt2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**4*8._/**/REALKIND))
    f(269) = -((eQED**5*gQCD*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**3*3._/**/REALKIND))
    f(270) = (eQED**5*gQCD*integralnorm*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw**3*8._/**/REALKIND)
    f(271) = -((eQED**5*gQCD*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**3*3._/**/REALKIND))
    f(272) = (eQED**5*gQCD*integralnorm*sqrt2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(273) = (eQED**5*gQCD*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sqrt2*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(274) = (eQED**5*gQCD*integralnorm*MW**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw*3._/**/REALKIND)
    f(275) = -((eQED**5*gQCD*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sqrt2*2._/**/REALKIND))
    f(276) = (eQED**5*gQCD*integralnorm*MB**2*MT*SwF)/(MW**2*sqrt2*sw**5*8._/**/REALKIND)
    f(277) = (eQED**5*gQCD*integralnorm*ME**2*MT*SwF)/(MW**2*sqrt2*sw**5*8._/**/REALKIND)
    f(278) = (eQED**5*gQCD*integralnorm*ML**2*MT*SwF)/(MW**2*sqrt2*sw**5*8._/**/REALKIND)
    f(279) = (eQED**5*gQCD*integralnorm*MM**2*MT*SwF)/(MW**2*sqrt2*sw**5*8._/**/REALKIND)
    f(280) = (eQED**5*gQCD*integralnorm*MT**3*SwF)/(MW**2*sqrt2*sw**5*8._/**/REALKIND)
    f(281) = (eQED**5*gQCD*integralnorm*sqrt2*SwF)/(sw**5*8._/**/REALKIND)
    f(282) = (eQED**5*gQCD*integralnorm*sqrt2*SwF)/(sw**5*4._/**/REALKIND)
    f(283) = (eQED**5*gQCD*integralnorm*MT*sqrt2*SwF)/(sw**5*8._/**/REALKIND)
    f(284) = (eQED**5*gQCD*integralnorm*MT*sqrt2*SwF)/(sw**5*4._/**/REALKIND)
    f(285) = (eQED**5*gQCD*integralnorm*sqrt2*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(286) = (eQED**5*gQCD*integralnorm*ME*sqrt2*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(287) = (eQED**5*gQCD*integralnorm*ML*sqrt2*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(288) = (eQED**5*gQCD*integralnorm*MM*sqrt2*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(289) = (eQED**5*gQCD*integralnorm*MT*sqrt2*SwF)/(MW**2*sw**5*16._/**/REALKIND)
    f(290) = (eQED**5*gQCD*integralnorm*MB*MT*sqrt2*SwF)/(MW**2*sw**5*16._/**/REALKIND)
    f(291) = (eQED**5*gQCD*integralnorm*ME*MT*sqrt2*SwF)/(MW**2*sw**5*16._/**/REALKIND)
    f(292) = (eQED**5*gQCD*integralnorm*ML*MT*sqrt2*SwF)/(MW**2*sw**5*16._/**/REALKIND)
    f(293) = (eQED**5*gQCD*integralnorm*MM*MT*sqrt2*SwF)/(MW**2*sw**5*16._/**/REALKIND)
    f(294) = (eQED**5*gQCD*integralnorm*MT**2*sqrt2*SwF)/(MW**2*sw**5*16._/**/REALKIND)
    f(295) = (cw*eQED**5*gQCD*integralnorm*MB*MT*SwF)/(MW**2*sqrt2*sw**4*4._/**/REALKIND)
    f(296) = (cw*eQED**5*gQCD*integralnorm*ME*MT*SwF)/(MW**2*sqrt2*sw**4*4._/**/REALKIND)
    f(297) = (cw*eQED**5*gQCD*integralnorm*ML*MT*SwF)/(MW**2*sqrt2*sw**4*4._/**/REALKIND)
    f(298) = (cw*eQED**5*gQCD*integralnorm*MM*MT*SwF)/(MW**2*sqrt2*sw**4*4._/**/REALKIND)
    f(299) = (cw*eQED**5*gQCD*integralnorm*MT**2*SwF)/(MW**2*sqrt2*sw**4*4._/**/REALKIND)
    f(300) = (cw*eQED**5*gQCD*integralnorm*sqrt2*SwF)/(sw**4*4._/**/REALKIND)
    f(301) = (cw*eQED**5*gQCD*integralnorm*sqrt2*SwF)/(sw**4*2._/**/REALKIND)
    f(302) = (eQED**5*gQCD*integralnorm*MB*SwF)/(sqrt2*sw**3*9._/**/REALKIND)
    f(303) = (eQED**5*gQCD*integralnorm*MB*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(304) = (eQED**3*gQCD**3*integralnorm*MB*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(305) = (eQED**5*gQCD*integralnorm*ME*SwF)/(sqrt2*sw**3*3._/**/REALKIND)
    f(306) = (eQED**5*gQCD*integralnorm*ME*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(307) = (eQED**5*gQCD*integralnorm*ML*SwF)/(sqrt2*sw**3*3._/**/REALKIND)
    f(308) = (eQED**5*gQCD*integralnorm*ML*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(309) = (eQED**5*gQCD*integralnorm*MM*SwF)/(sqrt2*sw**3*3._/**/REALKIND)
    f(310) = (eQED**5*gQCD*integralnorm*MM*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(311) = (2*eQED**5*gQCD*integralnorm*MT*SwF)/(sqrt2*sw**3*9._/**/REALKIND)
    f(312) = (eQED**5*gQCD*integralnorm*MT*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(313) = (eQED**3*gQCD**3*integralnorm*MT*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(314) = (eQED**5*gQCD*integralnorm*MB*MT*SwF)/(MW**2*sqrt2*sw**3*36._/**/REALKIND)
    f(315) = (eQED**5*gQCD*integralnorm*MB*MT*SwF)/(MW**2*sqrt2*sw**3*18._/**/REALKIND)
    f(316) = (eQED**5*gQCD*integralnorm*MB*MT*SwF)/(MW**2*sqrt2*sw**3*12._/**/REALKIND)
    f(317) = (eQED**5*gQCD*integralnorm*MB*MT*SwF)/(MW**2*sqrt2*sw**3*4._/**/REALKIND)
    f(318) = (eQED**3*gQCD**3*integralnorm*MB*MT*SwF)/(MW**2*sqrt2*sw**3*4._/**/REALKIND)
    f(319) = (eQED**5*gQCD*integralnorm*ME*MT*SwF)/(MW**2*sqrt2*sw**3*12._/**/REALKIND)
    f(320) = (eQED**5*gQCD*integralnorm*ME*MT*SwF)/(MW**2*sqrt2*sw**3*6._/**/REALKIND)
    f(321) = (eQED**5*gQCD*integralnorm*ME*MT*SwF)/(MW**2*sqrt2*sw**3*4._/**/REALKIND)
    f(322) = (eQED**5*gQCD*integralnorm*ML*MT*SwF)/(MW**2*sqrt2*sw**3*12._/**/REALKIND)
    f(323) = (eQED**5*gQCD*integralnorm*ML*MT*SwF)/(MW**2*sqrt2*sw**3*6._/**/REALKIND)
    f(324) = (eQED**5*gQCD*integralnorm*ML*MT*SwF)/(MW**2*sqrt2*sw**3*4._/**/REALKIND)
    f(325) = (eQED**5*gQCD*integralnorm*MM*MT*SwF)/(MW**2*sqrt2*sw**3*12._/**/REALKIND)
    f(326) = (eQED**5*gQCD*integralnorm*MM*MT*SwF)/(MW**2*sqrt2*sw**3*6._/**/REALKIND)
    f(327) = (eQED**5*gQCD*integralnorm*MM*MT*SwF)/(MW**2*sqrt2*sw**3*4._/**/REALKIND)
    f(328) = (eQED**5*gQCD*integralnorm*MT**2*SwF)/(MW**2*sqrt2*sw**3*18._/**/REALKIND)
    f(329) = (eQED**5*gQCD*integralnorm*MT**2*SwF)/(MW**2*sqrt2*sw**3*9._/**/REALKIND)
    f(330) = (eQED**5*gQCD*integralnorm*MT**2*SwF)/(MW**2*sqrt2*sw**3*6._/**/REALKIND)
    f(331) = (eQED**5*gQCD*integralnorm*MT**2*SwF)/(MW**2*sqrt2*sw**3*4._/**/REALKIND)
    f(332) = (eQED**3*gQCD**3*integralnorm*MT**2*SwF)/(MW**2*sqrt2*sw**3*4._/**/REALKIND)
    f(333) = (eQED**5*gQCD*integralnorm*sqrt2*SwF)/(sw**3*18._/**/REALKIND)
    f(334) = (eQED**5*gQCD*integralnorm*sqrt2*SwF)/(sw**3*9._/**/REALKIND)
    f(335) = (eQED**5*gQCD*integralnorm*sqrt2*SwF)/(sw**3*6._/**/REALKIND)
    f(336) = (2*eQED**5*gQCD*integralnorm*sqrt2*SwF)/(sw**3*9._/**/REALKIND)
    f(337) = (eQED**5*gQCD*integralnorm*sqrt2*SwF)/(sw**3*4._/**/REALKIND)
    f(338) = (eQED**5*gQCD*integralnorm*sqrt2*SwF)/(sw**3*3._/**/REALKIND)
    f(339) = (eQED**5*gQCD*integralnorm*sqrt2*SwF)/(sw**3*2._/**/REALKIND)
    f(340) = (eQED**3*gQCD**3*integralnorm*sqrt2*SwF)/(sw**3*4._/**/REALKIND)
    f(341) = (eQED**3*gQCD**3*integralnorm*sqrt2*SwF)/(sw**3*2._/**/REALKIND)
    f(342) = (eQED**5*gQCD*integralnorm*ME*sqrt2*SwF)/(sw**3*6._/**/REALKIND)
    f(343) = (eQED**5*gQCD*integralnorm*ML*sqrt2*SwF)/(sw**3*6._/**/REALKIND)
    f(344) = (eQED**5*gQCD*integralnorm*MM*sqrt2*SwF)/(sw**3*6._/**/REALKIND)
    f(345) = (2*cw*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw**2*9._/**/REALKIND)
    f(346) = (4*cw*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw**2*9._/**/REALKIND)
    f(347) = (2*cw*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw**2*3._/**/REALKIND)
    f(348) = (8*cw*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw**2*9._/**/REALKIND)
    f(349) = (cw*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw**2)
    f(350) = (2*cw*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw**2)
    f(351) = (3*cw*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw**2)
    f(352) = (cw*eQED**3*gQCD**3*integralnorm*SwF)/(sqrt2*sw**2)
    f(353) = (2*cw*eQED**3*gQCD**3*integralnorm*SwF)/(sqrt2*sw**2)
    f(354) = (eQED**5*gQCD*integralnorm*sqrt2*SwF)/(cw*sw**2*4._/**/REALKIND)
    f(355) = (eQED**5*gQCD*integralnorm*ME*sqrt2*SwF)/(cw*sw**2*4._/**/REALKIND)
    f(356) = (eQED**5*gQCD*integralnorm*ML*sqrt2*SwF)/(cw*sw**2*4._/**/REALKIND)
    f(357) = (eQED**5*gQCD*integralnorm*MM*sqrt2*SwF)/(cw*sw**2*4._/**/REALKIND)
    f(358) = (2*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*81._/**/REALKIND)
    f(359) = (4*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*81._/**/REALKIND)
    f(360) = (2*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*27._/**/REALKIND)
    f(361) = (8*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*81._/**/REALKIND)
    f(362) = (eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(363) = (4*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*27._/**/REALKIND)
    f(364) = (16*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*81._/**/REALKIND)
    f(365) = (2*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(366) = (8*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*27._/**/REALKIND)
    f(367) = (eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(368) = (32*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*81._/**/REALKIND)
    f(369) = (4*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(370) = (16*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*27._/**/REALKIND)
    f(371) = (2*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(372) = (8*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(373) = (eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw)
    f(374) = (4*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(375) = (2*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw)
    f(376) = (3*eQED**5*gQCD*integralnorm*SwF)/(sqrt2*sw)
    f(377) = (eQED**3*gQCD**3*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(378) = (2*eQED**3*gQCD**3*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(379) = (eQED**3*gQCD**3*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(380) = (4*eQED**3*gQCD**3*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(381) = (2*eQED**3*gQCD**3*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(382) = (8*eQED**3*gQCD**3*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(383) = (eQED**3*gQCD**3*integralnorm*SwF)/(sqrt2*sw)
    f(384) = (4*eQED**3*gQCD**3*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(385) = (2*eQED**3*gQCD**3*integralnorm*SwF)/(sqrt2*sw)

  c = [ 6*f(88), 6*f(89), 6*f(90), 6*f(91), 6*f(92), 6*f(93), 6*f(94), 6*f(95), 6*f(96), 6*f(97), 6*f(98), 6*f(99), 6*f(100) &
    , 6*f(101), 6*f(102), 6*f(103), 6*f(104), 6*f(105), 6*f(106), 6*f(107), 6*f(108), 6*f(109), 6*f(110), 6*f(111), 6*f(112) &
    , 6*f(113), 6*f(114), 6*f(115), 6*f(116), 6*f(117), 6*f(118), 6*f(119), 6*f(120), 6*f(121), 6*f(122), 6*f(123), 6*f(124) &
    , 6*f(125), 6*f(126), 6*f(127), 6*f(128), 6*f(129), 6*f(130), 6*f(131), 6*f(132), 6*f(133), 6*f(134), 6*f(135), 6*f(136) &
    , 6*f(137), 6*f(138), 6*f(139), 6*f(140), 6*f(141), 6*f(142), 6*f(143), 6*f(144), 6*f(145), 6*f(146), 6*f(147), 6*f(148) &
    , 6*f(149), 6*f(150), 6*f(151), 6*f(152), 6*f(153), 6*f(154), 6*f(155), 6*f(156), 6*f(157), 6*f(158), 6*f(159), 6*f(160) &
    , 6*f(161), 6*f(162), 6*f(163), 6*f(164), 6*f(165), 6*f(166), 6*f(167), 6*f(168), 6*f(169), 3*CI*f(170), 9*CI*f(170), f(171) &
    , 3*f(171), 8*f(171), 6*f(172), 6*f(173), 6*f(174), 6*f(175), 6*f(176), 6*f(177), 6*f(178), 6*f(179), 3*CI*f(180), f(181) &
    , 3*f(181), 6*f(182), 6*f(183), 6*f(184), 6*f(185), 6*f(186), 6*f(187), 6*f(188), 6*f(189), 6*f(190), 6*f(191), 6*f(192) &
    , 3*CI*f(193), 9*CI*f(193), f(194), 3*f(194), 8*f(194), 6*f(195), 6*f(196), 6*f(197), 6*f(198), 6*f(199), 6*f(200) &
    , 3*CI*f(201), f(202), 3*f(202), 6*f(203), 6*f(204), 6*f(205), 6*f(206), 6*f(207), 6*f(208), 6*f(209), 6*f(210), 3*CI*f(211) &
    , 9*CI*f(211), f(212), 3*f(212), 8*f(212), 6*f(213), 6*f(214), 6*f(215), 6*f(216), 6*f(217), 6*f(218), 6*f(219), 6*f(220) &
    , 6*f(221), 6*f(222), 6*f(223), 6*f(224), 6*f(225), 6*f(226), 6*f(227), 6*f(228), 6*f(229), 6*f(230), 6*f(231), 3*CI*f(232) &
    , 3*CI*f(233), 9*CI*f(233), 3*CI*f(234), 3*CI*f(235), 9*CI*f(235), 3*CI*f(236), 9*CI*f(236), 3*CI*f(237), 9*CI*f(237), f(238) &
    , 3*f(238), f(239), 3*f(239), 8*f(239), f(240), 3*f(240), f(241), 3*f(241), 8*f(241), f(242), 3*f(242), 8*f(242), f(243) &
    , 3*f(243), 8*f(243), 6*f(244), 6*f(245), 6*f(246), 6*f(247), 6*f(248), 6*f(249), 6*f(250), 6*f(251), 6*f(252), 6*f(253) &
    , 6*f(254), 6*f(255), 6*f(256), 6*f(257), 6*f(258), 6*f(259), 6*f(260), 6*f(261), 6*f(262), 6*f(263), 6*f(264), 6*f(265) &
    , 6*f(266), 6*f(267), 6*f(268), 6*f(269), 6*f(270), 6*f(271), 6*f(272), 6*f(273), 6*f(274), 6*f(275), 18*f(276), 6*f(277) &
    , 6*f(278), 6*f(279), 18*f(280), 6*f(281), 18*f(281), 18*f(282), 6*f(283), 18*f(283), 18*f(284), 18*f(285), 6*f(286), 6*f(287) &
    , 6*f(288), 18*f(289), 18*f(290), 6*f(291), 6*f(292), 6*f(293), 18*f(294), 18*f(295), 6*f(296), 6*f(297), 6*f(298), 18*f(299) &
    , 6*f(300), 18*f(300), 18*f(301), 18*f(302), 18*f(303), 3*f(304), 6*f(305), 6*f(306), 6*f(307), 6*f(308), 6*f(309), 6*f(310) &
    , 18*f(311), 18*f(312), 3*f(313), 18*f(314), 18*f(315), 18*f(316), 18*f(317), 3*f(318), 6*f(319), 6*f(320), 6*f(321), 6*f(322) &
    , 6*f(323), 6*f(324), 6*f(325), 6*f(326), 6*f(327), 18*f(328), 18*f(329), 18*f(330), 18*f(331), 3*f(332), 18*f(333), 18*f(334) &
    , 6*f(335), 18*f(335), 18*f(336), 6*f(337), 18*f(337), 18*f(338), 18*f(339), 3*f(340), 3*f(341), 6*f(342), 6*f(343), 6*f(344) &
    , 18*f(345), 18*f(346), 6*f(347), 18*f(348), 6*f(349), 18*f(349), 18*f(350), 6*f(351), 3*f(352), 3*f(353), 18*f(354), 6*f(355) &
    , 6*f(356), 6*f(357), 18*f(358), 18*f(359), 18*f(360), 18*f(361), 18*f(362), 18*f(363), 18*f(364), 6*f(365), 18*f(365) &
    , 18*f(366), 6*f(367), 18*f(367), 18*f(368), 6*f(369), 18*f(369), 18*f(370), 6*f(371), 18*f(371), 18*f(372), 6*f(373) &
    , 18*f(373), 18*f(374), 18*f(375), 6*f(376), 3*f(377), 3*f(378), 3*f(379), 3*f(380), 3*f(381), 3*f(382), 3*f(383), 3*f(384) &
    , 3*f(385) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,17))+L(6,17))
  den(2) = 1 /((L(5,6))+L(6,6))
  den(3) = 1 /((L(5,40))+L(6,40))
  den(6) = 1 /((L(5,6) - MZ2)+L(6,6))
  den(9) = 1 /((L(5,25))+L(6,25))
  den(12) = 1 /((L(5,14))+L(6,14))
  den(17) = 1 /((L(5,33))+L(6,33))
  den(18) = 1 /((L(5,24))+L(6,24))
  den(23) = 1 /((L(5,7))+L(6,7))
  den(30) = 1 /((L(5,6) - MH2)+L(6,6))
  den(31) = 1 /((L(5,41) - MW2)+L(6,41))
  den(44) = 1 /((L(5,9) - MW2)+L(6,9))
  den(45) = 1 /((L(5,18) - MB2)+L(6,18))
  den(46) = 1 /((L(5,36) - MT2)+L(6,36))
  den(49) = 1 /((L(5,13) - MB2)+L(6,13))
  den(52) = 1 /((L(5,34) - MT2)+L(6,34))
  den(54) = 1 /((L(5,38) - MH2)+L(6,38))
  den(57) = 1 /((L(5,38))+L(6,38))
  den(60) = 1 /((L(5,38) - MZ2)+L(6,38))
  den(73) = 1 /((L(5,22) - MW2)+L(6,22))
  den(78) = 1 /((L(5,25) - MZ2)+L(6,25))
  den(84) = 1 /((L(5,25) - MH2)+L(6,25))
  den(96) = 1 /((L(5,49))+L(6,49))
  den(111) = 1 /((L(5,50) - MB2)+L(6,50))
  den(128) = 1 /((L(5,56))+L(6,56))
  den(145) = 1 /((L(5,46))+L(6,46))
  den(152) = 1 /((L(5,57))+L(6,57))
  den(155) = 1 /((L(5,57) - MZ2)+L(6,57))
  den(160) = 1 /((L(5,23))+L(6,23))
  den(178) = 1 /((L(5,30))+L(6,30))
  den(191) = 1 /((L(5,39))+L(6,39))
  den(243) = 1 /((L(5,54) - MW2)+L(6,54))
  den(247) = 1 /((L(5,45) - MB2)+L(6,45))
  den(250) = 1 /((L(5,27) - MT2)+L(6,27))
  den(339) = 1 /((L(5,29) - MT2)+L(6,29))
  den(366) = 1 /((L(5,57) - MH2)+L(6,57))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(3)*den(7)
  den(10) = den(1)*den(9)
  den(11) = den(2)*den(10)
  den(13) = den(2)*den(12)
  den(14) = den(1)*den(13)
  den(15) = den(6)*den(12)
  den(16) = den(1)*den(15)
  den(19) = den(2)*den(17)
  den(20) = den(18)*den(19)
  den(21) = den(6)*den(17)
  den(22) = den(18)*den(21)
  den(24) = den(2)*den(23)
  den(25) = den(18)*den(24)
  den(26) = den(6)*den(23)
  den(27) = den(18)*den(26)
  den(28) = den(9)*den(18)
  den(29) = den(2)*den(28)
  den(32) = den(17)*den(31)
  den(33) = den(30)*den(32)
  den(34) = den(2)*den(32)
  den(35) = den(6)*den(32)
  den(36) = den(13)*den(17)
  den(37) = den(15)*den(17)
  den(38) = den(3)*den(24)
  den(39) = den(3)*den(26)
  den(40) = den(3)*den(31)
  den(41) = den(30)*den(40)
  den(42) = den(2)*den(40)
  den(43) = den(6)*den(40)
  den(47) = den(44)*den(45)
  den(48) = den(46)*den(47)
  den(50) = den(44)*den(49)
  den(51) = den(45)*den(50)
  den(53) = den(50)*den(52)
  den(55) = den(52)*den(54)
  den(56) = den(44)*den(55)
  den(58) = den(52)*den(57)
  den(59) = den(44)*den(58)
  den(61) = den(52)*den(60)
  den(62) = den(44)*den(61)
  den(63) = den(46)*den(54)
  den(64) = den(44)*den(63)
  den(65) = den(46)*den(57)
  den(66) = den(44)*den(65)
  den(67) = den(46)*den(60)
  den(68) = den(44)*den(67)
  den(69) = den(1)*den(58)
  den(70) = den(1)*den(61)
  den(71) = den(1)*den(65)
  den(72) = den(1)*den(67)
  den(74) = den(45)*den(73)
  den(75) = den(17)*den(74)
  den(76) = den(40)*den(45)
  den(77) = den(28)*den(52)
  den(79) = den(18)*den(78)
  den(80) = den(52)*den(79)
  den(81) = den(28)*den(46)
  den(82) = den(46)*den(79)
  den(83) = den(2)*den(44)
  den(85) = den(44)*den(84)
  den(86) = den(2)*den(85)
  den(87) = den(44)*den(78)
  den(88) = den(2)*den(87)
  den(89) = den(10)*den(30)
  den(90) = den(6)*den(10)
  den(91) = den(1)*den(78)
  den(92) = den(2)*den(91)
  den(93) = den(28)*den(30)
  den(94) = den(2)*den(79)
  den(95) = den(6)*den(28)
  den(97) = den(1)*den(96)
  den(98) = den(2)*den(97)
  den(99) = den(6)*den(97)
  den(100) = den(2)*den(57)
  den(101) = den(1)*den(100)
  den(102) = den(17)*den(96)
  den(103) = den(2)*den(102)
  den(104) = den(6)*den(102)
  den(105) = den(30)*den(73)
  den(106) = den(17)*den(105)
  den(107) = den(6)*den(73)
  den(108) = den(17)*den(107)
  den(109) = den(2)*den(73)
  den(110) = den(17)*den(109)
  den(112) = den(45)*den(111)
  den(113) = den(44)*den(112)
  den(114) = den(52)*den(85)
  den(115) = den(9)*den(44)
  den(116) = den(52)*den(115)
  den(117) = den(52)*den(87)
  den(118) = den(52)*den(111)
  den(119) = den(44)*den(118)
  den(120) = den(10)*den(52)
  den(121) = den(52)*den(91)
  den(122) = den(32)*den(45)
  den(123) = den(46)*den(85)
  den(124) = den(46)*den(115)
  den(125) = den(46)*den(87)
  den(126) = den(10)*den(46)
  den(127) = den(46)*den(91)
  den(129) = den(18)*den(128)
  den(130) = den(2)*den(129)
  den(131) = den(6)*den(129)
  den(132) = den(18)*den(100)
  den(133) = den(3)*den(128)
  den(134) = den(2)*den(133)
  den(135) = den(6)*den(133)
  den(136) = den(3)*den(105)
  den(137) = den(3)*den(107)
  den(138) = den(3)*den(109)
  den(139) = den(3)*den(74)
  den(140) = den(18)*den(58)
  den(141) = den(18)*den(61)
  den(142) = den(18)*den(65)
  den(143) = den(18)*den(67)
  den(144) = den(2)*den(3)
  den(146) = den(144)*den(145)
  den(147) = den(1)*den(146)
  den(148) = den(3)*den(6)
  den(149) = den(145)*den(148)
  den(150) = den(1)*den(149)
  den(151) = den(1)*den(3)
  den(153) = den(151)*den(152)
  den(154) = den(6)*den(153)
  den(156) = den(151)*den(155)
  den(157) = den(6)*den(156)
  den(158) = den(2)*den(153)
  den(159) = den(2)*den(156)
  den(161) = den(4)*den(160)
  den(162) = den(3)*den(161)
  den(163) = den(7)*den(160)
  den(164) = den(3)*den(163)
  den(165) = den(1)**2
  den(166) = den(100)*den(165)
  den(167) = den(13)*den(165)
  den(168) = den(15)*den(165)
  den(169) = den(2)*den(6)
  den(170) = den(97)*den(169)
  den(171) = den(6)**2
  den(172) = den(97)*den(171)
  den(173) = den(2)**2
  den(174) = den(97)*den(173)
  den(175) = den(13)*den(97)
  den(176) = den(15)*den(97)
  den(177) = den(2)*den(18)
  den(179) = den(177)*den(178)
  den(180) = den(17)*den(179)
  den(181) = den(6)*den(18)
  den(182) = den(178)*den(181)
  den(183) = den(17)*den(182)
  den(184) = den(17)*den(18)
  den(185) = den(152)*den(184)
  den(186) = den(6)*den(185)
  den(187) = den(155)*den(184)
  den(188) = den(6)*den(187)
  den(189) = den(2)*den(185)
  den(190) = den(2)*den(187)
  den(192) = den(19)*den(191)
  den(193) = den(18)*den(192)
  den(194) = den(21)*den(191)
  den(195) = den(18)*den(194)
  den(196) = den(129)*den(169)
  den(197) = den(129)*den(171)
  den(198) = den(129)*den(173)
  den(199) = den(18)**2
  den(200) = den(100)*den(199)
  den(201) = den(24)*den(129)
  den(202) = den(26)*den(129)
  den(203) = den(24)*den(199)
  den(204) = den(26)*den(199)
  den(205) = den(17)**2
  den(206) = den(105)*den(205)
  den(207) = den(109)*den(205)
  den(208) = den(107)*den(205)
  den(209) = den(13)*den(205)
  den(210) = den(15)*den(205)
  den(211) = den(102)*den(169)
  den(212) = den(102)*den(171)
  den(213) = den(102)*den(173)
  den(214) = den(30)**2
  den(215) = den(32)*den(214)
  den(216) = den(32)*den(169)
  den(217) = den(32)*den(171)
  den(218) = den(32)*den(173)
  den(219) = den(32)*den(105)
  den(220) = den(32)*den(107)
  den(221) = den(32)*den(109)
  den(222) = den(13)*den(102)
  den(223) = den(15)*den(102)
  den(224) = den(133)*den(169)
  den(225) = den(133)*den(171)
  den(226) = den(133)*den(173)
  den(227) = den(3)**2
  den(228) = den(105)*den(227)
  den(229) = den(109)*den(227)
  den(230) = den(107)*den(227)
  den(231) = den(24)*den(133)
  den(232) = den(26)*den(133)
  den(233) = den(40)*den(105)
  den(234) = den(40)*den(107)
  den(235) = den(40)*den(109)
  den(236) = den(40)*den(214)
  den(237) = den(40)*den(169)
  den(238) = den(40)*den(171)
  den(239) = den(40)*den(173)
  den(240) = den(24)*den(227)
  den(241) = den(26)*den(227)
  den(242) = den(45)*den(46)
  den(244) = den(242)*den(243)
  den(245) = den(44)*den(244)
  den(246) = den(44)*den(46)
  den(248) = den(246)*den(247)
  den(249) = den(45)*den(248)
  den(251) = den(47)*den(250)
  den(252) = den(46)*den(251)
  den(253) = den(44)**2
  den(254) = den(112)*den(253)
  den(255) = den(45)**2
  den(256) = den(50)*den(255)
  den(257) = den(50)*den(112)
  den(258) = den(118)*den(253)
  den(259) = den(55)*den(253)
  den(260) = den(61)*den(253)
  den(261) = den(58)*den(253)
  den(262) = den(52)**2
  den(263) = den(85)*den(262)
  den(264) = den(115)*den(262)
  den(265) = den(87)*den(262)
  den(266) = den(50)*den(262)
  den(267) = den(50)*den(118)
  den(268) = den(55)*den(85)
  den(269) = den(61)*den(115)
  den(270) = den(61)*den(87)
  den(271) = den(58)*den(115)
  den(272) = den(58)*den(87)
  den(273) = den(63)*den(253)
  den(274) = den(67)*den(253)
  den(275) = den(65)*den(253)
  den(276) = den(46)**2
  den(277) = den(85)*den(276)
  den(278) = den(115)*den(276)
  den(279) = den(87)*den(276)
  den(280) = den(63)*den(85)
  den(281) = den(67)*den(115)
  den(282) = den(67)*den(87)
  den(283) = den(65)*den(115)
  den(284) = den(65)*den(87)
  den(285) = den(58)*den(165)
  den(286) = den(61)*den(165)
  den(287) = den(10)*den(262)
  den(288) = den(91)*den(262)
  den(289) = den(10)*den(61)
  den(290) = den(61)*den(91)
  den(291) = den(10)*den(58)
  den(292) = den(58)*den(91)
  den(293) = den(65)*den(165)
  den(294) = den(67)*den(165)
  den(295) = den(10)*den(276)
  den(296) = den(91)*den(276)
  den(297) = den(10)*den(67)
  den(298) = den(67)*den(91)
  den(299) = den(10)*den(65)
  den(300) = den(65)*den(91)
  den(301) = den(74)*den(205)
  den(302) = den(32)*den(255)
  den(303) = den(32)*den(74)
  den(304) = den(40)*den(74)
  den(305) = den(74)*den(227)
  den(306) = den(40)*den(255)
  den(307) = den(28)*den(61)
  den(308) = den(61)*den(79)
  den(309) = den(28)*den(58)
  den(310) = den(58)*den(79)
  den(311) = den(58)*den(199)
  den(312) = den(61)*den(199)
  den(313) = den(28)*den(262)
  den(314) = den(79)*den(262)
  den(315) = den(28)*den(67)
  den(316) = den(67)*den(79)
  den(317) = den(28)*den(65)
  den(318) = den(65)*den(79)
  den(319) = den(65)*den(199)
  den(320) = den(67)*den(199)
  den(321) = den(28)*den(276)
  den(322) = den(79)*den(276)
  den(323) = den(24)*den(160)
  den(324) = den(26)*den(160)
  den(325) = den(24)*den(191)
  den(326) = den(26)*den(191)
  den(327) = den(105)*den(160)
  den(328) = den(109)*den(160)
  den(329) = den(107)*den(160)
  den(330) = den(100)*den(191)
  den(331) = den(13)*den(178)
  den(332) = den(15)*den(178)
  den(333) = den(13)*den(145)
  den(334) = den(15)*den(145)
  den(335) = den(105)*den(178)
  den(336) = den(109)*den(178)
  den(337) = den(107)*den(178)
  den(338) = den(100)*den(145)
  den(340) = den(50)*den(339)
  den(341) = den(50)*den(247)
  den(342) = den(85)*den(250)
  den(343) = den(115)*den(250)
  den(344) = den(87)*den(250)
  den(345) = den(85)*den(339)
  den(346) = den(115)*den(339)
  den(347) = den(87)*den(339)
  den(348) = den(10)*den(250)
  den(349) = den(91)*den(250)
  den(350) = den(10)*den(339)
  den(351) = den(91)*den(339)
  den(352) = den(10)*den(152)
  den(353) = den(97)*den(152)
  den(354) = den(97)*den(155)
  den(355) = den(74)*den(160)
  den(356) = den(74)*den(178)
  den(357) = den(112)*den(243)
  den(358) = den(28)*den(250)
  den(359) = den(79)*den(250)
  den(360) = den(28)*den(339)
  den(361) = den(79)*den(339)
  den(362) = den(28)*den(152)
  den(363) = den(129)*den(152)
  den(364) = den(129)*den(155)
  den(365) = den(32)*den(247)
  den(367) = den(32)*den(366)
  den(368) = den(32)*den(152)
  den(369) = den(32)*den(155)
  den(370) = den(102)*den(152)
  den(371) = den(102)*den(155)
  den(372) = den(58)*den(191)
  den(373) = den(61)*den(191)
  den(374) = den(58)*den(145)
  den(375) = den(61)*den(145)
  den(376) = den(55)*den(243)
  den(377) = den(61)*den(243)
  den(378) = den(58)*den(243)
  den(379) = den(118)*den(243)
  den(380) = den(65)*den(191)
  den(381) = den(67)*den(191)
  den(382) = den(65)*den(145)
  den(383) = den(67)*den(145)
  den(384) = den(63)*den(243)
  den(385) = den(67)*den(243)
  den(386) = den(65)*den(243)
  den(387) = den(40)*den(247)
  den(388) = den(40)*den(366)
  den(389) = den(40)*den(152)
  den(390) = den(40)*den(155)
  den(391) = den(133)*den(152)
  den(392) = den(133)*den(155)
  den(393) = den(44)*den(52)
  den(394) = den(2)*den(115)
  den(395) = den(1)*den(3)*den(30)
  den(396) = den(1)*den(2)*den(3)
  den(397) = den(1)*den(3)*den(6)
  den(398) = den(30)*den(97)
  den(399) = den(1)*den(30)
  den(400) = den(17)*den(18)*den(30)
  den(401) = den(2)*den(17)*den(18)
  den(402) = den(6)*den(17)*den(18)
  den(403) = den(30)*den(129)
  den(404) = den(18)*den(30)
  den(405) = den(30)*den(102)
  den(406) = den(17)*den(30)
  den(407) = den(30)*den(133)
  den(408) = den(3)*den(30)
  den(409) = den(44)*den(45)*den(46)
  den(410) = den(1)*den(55)
  den(411) = den(1)*den(52)
  den(412) = den(1)*den(63)
  den(413) = den(1)*den(46)
  den(414) = den(17)*den(45)
  den(415) = den(3)*den(45)
  den(416) = den(18)*den(55)
  den(417) = den(18)*den(52)
  den(418) = den(18)*den(63)
  den(419) = den(18)*den(46)
  den(420) = den(30)*den(153)
  den(421) = den(30)*den(156)
  den(422) = den(30)*den(353)
  den(423) = den(30)*den(354)
  den(424) = den(6)*den(353)
  den(425) = den(6)*den(354)
  den(426) = den(2)*den(353)
  den(427) = den(2)*den(354)
  den(428) = den(1)*den(333)
  den(429) = den(1)*den(334)
  den(430) = den(1)*den(338)
  den(431) = den(30)*den(185)
  den(432) = den(30)*den(187)
  den(433) = den(18)*den(325)
  den(434) = den(18)*den(326)
  den(435) = den(18)*den(330)
  den(436) = den(30)*den(363)
  den(437) = den(6)*den(363)
  den(438) = den(30)*den(364)
  den(439) = den(6)*den(364)
  den(440) = den(2)*den(363)
  den(441) = den(2)*den(364)
  den(442) = den(30)*den(367)
  den(443) = den(6)*den(367)
  den(444) = den(30)*den(368)
  den(445) = den(30)*den(369)
  den(446) = den(6)*den(368)
  den(447) = den(6)*den(369)
  den(448) = den(2)*den(367)
  den(449) = den(2)*den(368)
  den(450) = den(2)*den(369)
  den(451) = den(30)*den(370)
  den(452) = den(30)*den(371)
  den(453) = den(6)*den(370)
  den(454) = den(6)*den(371)
  den(455) = den(2)*den(370)
  den(456) = den(2)*den(371)
  den(457) = den(17)*den(331)
  den(458) = den(17)*den(332)
  den(459) = den(17)*den(335)
  den(460) = den(17)*den(336)
  den(461) = den(17)*den(337)
  den(462) = den(3)*den(323)
  den(463) = den(3)*den(324)
  den(464) = den(30)*den(388)
  den(465) = den(6)*den(388)
  den(466) = den(30)*den(389)
  den(467) = den(30)*den(390)
  den(468) = den(6)*den(389)
  den(469) = den(6)*den(390)
  den(470) = den(2)*den(388)
  den(471) = den(2)*den(389)
  den(472) = den(2)*den(390)
  den(473) = den(3)*den(327)
  den(474) = den(3)*den(328)
  den(475) = den(3)*den(329)
  den(476) = den(30)*den(391)
  den(477) = den(6)*den(391)
  den(478) = den(30)*den(392)
  den(479) = den(6)*den(392)
  den(480) = den(2)*den(391)
  den(481) = den(2)*den(392)
  den(482) = den(45)*den(341)
  den(483) = den(44)*den(357)
  den(484) = den(52)*den(340)
  den(485) = den(61)*den(85)
  den(486) = den(55)*den(115)
  den(487) = den(55)*den(87)
  den(488) = den(58)*den(85)
  den(489) = den(52)*den(345)
  den(490) = den(52)*den(346)
  den(491) = den(52)*den(347)
  den(492) = den(44)*den(376)
  den(493) = den(44)*den(377)
  den(494) = den(44)*den(378)
  den(495) = den(44)*den(379)
  den(496) = den(67)*den(85)
  den(497) = den(63)*den(115)
  den(498) = den(63)*den(87)
  den(499) = den(65)*den(85)
  den(500) = den(46)*den(342)
  den(501) = den(46)*den(343)
  den(502) = den(46)*den(344)
  den(503) = den(44)*den(384)
  den(504) = den(44)*den(385)
  den(505) = den(44)*den(386)
  den(506) = den(10)*den(55)
  den(507) = den(55)*den(91)
  den(508) = den(52)*den(350)
  den(509) = den(52)*den(351)
  den(510) = den(1)*den(374)
  den(511) = den(1)*den(375)
  den(512) = den(10)*den(63)
  den(513) = den(63)*den(91)
  den(514) = den(46)*den(348)
  den(515) = den(46)*den(349)
  den(516) = den(1)*den(382)
  den(517) = den(1)*den(383)
  den(518) = den(45)*den(365)
  den(519) = den(17)*den(356)
  den(520) = den(45)*den(387)
  den(521) = den(3)*den(355)
  den(522) = den(52)*den(360)
  den(523) = den(52)*den(361)
  den(524) = den(18)*den(372)
  den(525) = den(18)*den(373)
  den(526) = den(28)*den(55)
  den(527) = den(55)*den(79)
  den(528) = den(46)*den(358)
  den(529) = den(46)*den(359)
  den(530) = den(18)*den(380)
  den(531) = den(18)*den(381)
  den(532) = den(28)*den(63)
  den(533) = den(63)*den(79)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppwttj_ew_uttxdxwg_3_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,681))
  allocate(M1helarray(6,hel_states))
  allocate(M1helarray_ct(6,hel_states))
  allocate(M0_col1_helarray(6,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(6,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppwttj_ew_uttxdxwg_3_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up top anti-top anti-down W- glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppwttj_ew_uttxdxwg_3, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppwttj_ew_uttxdxwg_3, only: &
    & external_perm_ppwttj_ew_uttxdxwg_3, &
    & external_perm_inv_ppwttj_ew_uttxdxwg_3, &
    & extcomb_perm_ppwttj_ew_uttxdxwg_3, &
    & average_factor_ppwttj_ew_uttxdxwg_3
  use ol_external_ppwttj_ew_uttxdxwg_3, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppwttj_ew_uttxdxwg_3_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppwttj_ew_uttxdxwg_3_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppwttj_ew_uttxdxwg_3
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(22)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(22)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(6), M2(6)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,681))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, nMT, nMT, 0, nMW, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppwttj_ew_uttxdxwg_3, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rMT, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMW, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_WQ_A(ntry, ex5(:), ex1(:), wf6(:,1), n3(:,1), t3x6(:,:,1))
  call vert_QA_V(ntry, ex2(:), ex3(:), wf4(:,1), n3(:,2), t3x4(:,:,1))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,2), n3(:,3), t3x4(:,:,2))
  call prop_Q_A(ntry, wf6(:,1), 17, ZERO, 0_intkind1, wf6(:,2), n2(1))
  call prop_A_Q(ntry, wf4(:,2), 40, ZERO, 0_intkind1, wf4(:,3), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf6(:,2), wf24(:,1), n3(:,4), t3x24(:,:,1))
  call vert_QA_Z(gZu,ntry, ex2(:), ex3(:), wf4(:,4), n3(:,5), t3x4(:,:,3))
  call vert_ZQ_A(gZd,ntry, wf4(:,4), wf6(:,2), wf24(:,2), n3(:,6), t3x24(:,:,2))
  call vert_QA_V(ntry, wf6(:,2), ex4(:), wf12(:,1), n3(:,7), t3x12(:,:,1))
  call vert_UV_W(ntry, wf4(:,1), 6, ex6(:), 32, wf8(:,1), n3(:,8), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,2), n3(:,9), t3x8(:,:,2))
  call vert_VQ_A(ntry, ex6(:), wf6(:,2), wf12(:,2), n3(:,10), t3x12(:,:,2))
  call prop_A_Q(ntry, wf8(:,2), 14, ZERO, 0_intkind1, wf8(:,3), n2(3))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,4), wf8(:,4), n3(:,11), t3x8(:,:,3))
  call prop_A_Q(ntry, wf8(:,4), 14, ZERO, 0_intkind1, wf8(:,5), n2(4))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,5), n3(:,12), t3x4(:,:,4))
  call vert_AW_Q(ntry, ex4(:), ex5(:), wf6(:,3), n3(:,13), t3x6(:,:,2))
  call prop_Q_A(ntry, wf4(:,5), 33, ZERO, 0_intkind1, wf4(:,6), n2(5))
  call prop_A_Q(ntry, wf6(:,3), 24, ZERO, 0_intkind1, wf6(:,4), n2(6))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,6), wf16(:,1), n3(:,14), t3x16(:,:,1))
  call vert_ZQ_A(gZu,ntry, wf4(:,4), wf4(:,6), wf16(:,2), n3(:,15), t3x16(:,:,2))
  call vert_VQ_A(ntry, wf4(:,1), ex1(:), wf8(:,6), n3(:,16), t3x8(:,:,4))
  call vert_AV_Q(ntry, wf6(:,4), ex6(:), wf12(:,3), n3(:,17), t3x12(:,:,3))
  call prop_Q_A(ntry, wf8(:,6), 7, ZERO, 0_intkind1, wf8(:,7), n2(7))
  call vert_ZQ_A(gZu,ntry, wf4(:,4), ex1(:), wf8(:,8), n3(:,18), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,8), 7, ZERO, 0_intkind1, wf8(:,9), n2(8))
  call vert_QA_V(ntry, ex1(:), wf6(:,4), wf12(:,4), n3(:,19), t3x12(:,:,4))
  call vert_AQ_S(gH,ntry, ex3(:), ex2(:), wf4(:,7), n3(:,20), t3x4(:,:,5))
  call vert_QA_W(ntry, wf4(:,6), ex4(:), wf8(:,10), n3(:,21), t3x8(:,:,6))
  call vert_SV_V(ntry, wf4(:,7), ex5(:), wf12(:,5), n3(:,22), t3x12(:,:,5))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,1), 6, wf12(:,6), n3(:,23), t3x12(:,:,6))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,4), 6, wf12(:,7), n3(:,24), t3x12(:,:,7))
  call vert_WQ_A(ntry, ex5(:), wf4(:,6), wf12(:,8), n3(:,25), t3x12(:,:,8))
  call vert_AW_Q(ntry, wf4(:,3), ex5(:), wf12(:,9), n3(:,26), t3x12(:,:,9))
  call vert_QA_W(ntry, ex1(:), wf4(:,3), wf8(:,11), n3(:,27), t3x8(:,:,7))
  call vert_QA_W(ntry, ex1(:), ex4(:), wf4(:,8), n3(:,28), t3x4(:,:,6))
  call vert_WQ_A(ntry, ex5(:), ex2(:), wf6(:,5), n3(:,29), t3x6(:,:,3))
  call vert_AV_Q(ntry, ex3(:), ex6(:), wf4(:,9), n3(:,30), t3x4(:,:,7))
  call prop_Q_A(ntry, wf6(:,5), 18, MB, 1_intkind1, wf6(:,6), n2(9))
  call prop_A_Q(ntry, wf4(:,9), 36, MT, 1_intkind1, wf4(:,10), n2(10))
  call vert_WQ_A(ntry, wf4(:,8), wf6(:,6), wf24(:,3), n3(:,31), t3x24(:,:,3))
  call vert_AW_Q(ntry, ex3(:), wf4(:,8), wf8(:,12), n3(:,32), t3x8(:,:,8))
  call vert_VQ_A(ntry, ex6(:), wf6(:,6), wf12(:,10), n3(:,33), t3x12(:,:,10))
  call prop_A_Q(ntry, wf8(:,12), 13, MB, 1_intkind1, wf8(:,13), n2(11))
  call vert_VQ_A(ntry, ex6(:), ex2(:), wf4(:,11), n3(:,34), t3x4(:,:,8))
  call prop_Q_A(ntry, wf4(:,11), 34, MT, 1_intkind1, wf4(:,12), n2(12))
  call vert_WQ_A(ntry, ex5(:), wf4(:,12), wf12(:,11), n3(:,35), t3x12(:,:,11))
  call vert_AQ_S(gH,ntry, ex3(:), wf4(:,12), wf8(:,14), n3(:,36), t3x8(:,:,9))
  call vert_VV_S(ntry, wf4(:,8), ex5(:), wf12(:,12), n3(:,37), t3x12(:,:,12))
  call vert_QA_V(ntry, wf4(:,12), ex3(:), wf8(:,15), n3(:,38), t3x8(:,:,10))
  call vert_UV_W(ntry, wf4(:,8), 9, ex5(:), 16, wf12(:,13), n3(:,39), t3x12(:,:,13))
  call vert_QA_Z(gZu,ntry, wf4(:,12), ex3(:), wf8(:,16), n3(:,40), t3x8(:,:,11))
  call vert_AQ_S(gH,ntry, wf4(:,10), ex2(:), wf8(:,17), n3(:,41), t3x8(:,:,12))
  call vert_QA_V(ntry, ex2(:), wf4(:,10), wf8(:,18), n3(:,42), t3x8(:,:,13))
  call vert_QA_Z(gZu,ntry, ex2(:), wf4(:,10), wf8(:,19), n3(:,43), t3x8(:,:,14))
  call vert_QA_Z(gZd,ntry, wf6(:,2), ex4(:), wf12(:,14), n3(:,44), t3x12(:,:,14))
  call vert_QA_W(ntry, wf6(:,6), ex3(:), wf12(:,15), n3(:,45), t3x12(:,:,15))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,4), wf12(:,16), n3(:,46), t3x12(:,:,16))
  call counter_VVG_G(ntry, wf4(:,8), ex5(:), ex6(:), wf24(:,4), n4(:,1), t4x24(:,:,1))
  call counter_GG_S(ntry, wf4(:,1), ex6(:), wf8(:,20), n3(:,47), t3x8(:,:,15))
  call counter_GG_V(ntry, wf4(:,1), 6, ex6(:), 32, wf8(:,21), n3(:,48), t3x8(:,:,16))
  call counter_VQ_A(ntry, wf4(:,1), wf6(:,2), wf24(:,5), n3(:,49), t3x24(:,:,4))
  call counter_VQ_A_LR(EWctAdd,ntry, wf4(:,1), wf6(:,2), wf24(:,6), n3(:,50), t3x24(:,:,5))
  call counter_ZQ_A(gZd,ntry, wf4(:,4), wf6(:,2), wf24(:,7), n3(:,51), t3x24(:,:,6))
  call counter_ZQ_A(EWctVdd,ntry, wf4(:,4), wf6(:,2), wf24(:,8), n3(:,52), t3x24(:,:,7))
  call counter_VQ_A_LR(EWctGdd,ntry, wf4(:,1), wf6(:,2), wf24(:,9), n3(:,53), t3x24(:,:,8))
  call counter_SG_G(ntry, wf4(:,7), ex6(:), wf8(:,22), n3(:,54), t3x8(:,:,17))
  call counter_VG_G(ntry, wf4(:,4), ex6(:), 32, wf8(:,23), 38, n3(:,55), t3x8(:,:,18))
  call counter_VQ_A(ntry, ex6(:), wf6(:,2), wf12(:,17), n3(:,56), t3x12(:,:,17))
  call counter_VQ_A_LR(EWctGdd,ntry, ex6(:), wf6(:,2), wf12(:,18), n3(:,57), t3x12(:,:,18))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,6), wf16(:,3), n3(:,58), t3x16(:,:,3))
  call counter_VQ_A_LR(EWctAuu,ntry, wf4(:,1), wf4(:,6), wf16(:,4), n3(:,59), t3x16(:,:,4))
  call counter_ZQ_A(gZu,ntry, wf4(:,4), wf4(:,6), wf16(:,5), n3(:,60), t3x16(:,:,5))
  call counter_ZQ_A(EWctVuu,ntry, wf4(:,4), wf4(:,6), wf16(:,6), n3(:,61), t3x16(:,:,6))
  call counter_VQ_A_LR(EWctGuu,ntry, wf4(:,1), wf4(:,6), wf16(:,7), n3(:,62), t3x16(:,:,7))
  call counter_AV_Q(ntry, wf6(:,4), ex6(:), wf12(:,19), n3(:,63), t3x12(:,:,19))
  call counter_AV_Q_LR(EWctGuu,ntry, wf6(:,4), ex6(:), wf12(:,20), n3(:,64), t3x12(:,:,20))
  call counter_SV_V(ntry, wf4(:,7), ex5(:), wf12(:,21), n3(:,65), t3x12(:,:,21))
  call counter_UV_W(ntry, ex5(:), 16, wf4(:,1), 6, wf12(:,22), n3(:,66), t3x12(:,:,22))
  call counter_UV_W(ntry, ex5(:), 16, wf4(:,4), 6, wf12(:,23), n3(:,67), t3x12(:,:,23))
  call counter_WQ_A(ntry, ex5(:), wf4(:,6), wf12(:,24), n3(:,68), t3x12(:,:,24))
  call counter_AW_Q(ntry, wf4(:,3), ex5(:), wf12(:,25), n3(:,69), t3x12(:,:,25))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,24), n3(:,70), t3x8(:,:,19))
  call prop_Q_A(ntry, wf12(:,2), 49, ZERO, 0_intkind1, wf12(:,26), n2(13))
  call counter_AV_Q_LR(EWctAdd,ntry, ex4(:), wf4(:,1), wf8(:,25), n3(:,71), t3x8(:,:,20))
  call counter_AZ_Q(gZd,ntry, ex4(:), wf4(:,4), wf8(:,26), n3(:,72), t3x8(:,:,21))
  call counter_AZ_Q(EWctVdd,ntry, ex4(:), wf4(:,4), wf8(:,27), n3(:,73), t3x8(:,:,22))
  call counter_AV_Q_LR(EWctGdd,ntry, ex4(:), wf4(:,1), wf8(:,28), n3(:,74), t3x8(:,:,23))
  call counter_QA_V_LR(EWctGdd,ntry, wf6(:,2), ex4(:), wf12(:,27), n3(:,75), t3x12(:,:,26))
  call counter_AV_Q(ntry, ex4(:), ex6(:), wf4(:,13), n3(:,76), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,13), 40, ZERO, 0_intkind1, wf4(:,14), n2(14))
  call counter_AV_Q_LR(EWctGdd,ntry, ex4(:), ex6(:), wf4(:,15), n3(:,77), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,15), 40, ZERO, 0_intkind1, wf4(:,16), n2(15))
  call prop_Q_A(ntry, wf12(:,8), 49, ZERO, 0_intkind1, wf12(:,28), n2(16))
  call vert_TV_S(ntry, wf4(:,7), 6, ex5(:), 16, wf12(:,29), n3(:,78), t3x12(:,:,27))
  call counter_AQ_S(gPdu,ntry, ex4(:), wf4(:,6), wf8(:,29), n3(:,79), t3x8(:,:,24))
  call vert_AQ_S(gX,ntry, ex3(:), ex2(:), wf4(:,17), n3(:,80), t3x4(:,:,11))
  call vert_TV_S(ntry, wf4(:,17), 6, ex5(:), 16, wf12(:,30), n3(:,81), t3x12(:,:,28))
  call counter_QA_W(ntry, wf4(:,6), ex4(:), wf8(:,30), n3(:,82), t3x8(:,:,25))
  call vert_VV_S(ntry, wf4(:,1), ex5(:), wf12(:,31), n3(:,83), t3x12(:,:,29))
  call vert_VV_S(ntry, wf4(:,4), ex5(:), wf12(:,32), n3(:,84), t3x12(:,:,30))
  call vert_AW_Q(ntry, wf4(:,14), ex5(:), wf12(:,33), n3(:,85), t3x12(:,:,31))
  call vert_AW_Q(ntry, wf4(:,16), ex5(:), wf12(:,34), n3(:,86), t3x12(:,:,32))
  call vert_QA_W(ntry, ex1(:), wf4(:,14), wf8(:,31), n3(:,87), t3x8(:,:,26))
  call vert_QA_W(ntry, ex1(:), wf4(:,16), wf8(:,32), n3(:,88), t3x8(:,:,27))
  call counter_AW_Q(ntry, ex4(:), ex5(:), wf6(:,7), n3(:,89), t3x6(:,:,4))
  call prop_A_Q(ntry, wf6(:,7), 24, ZERO, 0_intkind1, wf6(:,8), n2(17))
  call vert_AV_Q(ntry, wf6(:,8), ex6(:), wf12(:,35), n3(:,90), t3x12(:,:,33))
  call vert_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,36), n3(:,91), t3x12(:,:,34))
  call counter_WQ_A(ntry, wf4(:,8), wf6(:,6), wf24(:,10), n3(:,92), t3x24(:,:,9))
  call counter_VQ_A(ntry, ex6(:), wf6(:,6), wf12(:,37), n3(:,93), t3x12(:,:,35))
  call counter_VQ_A_LR(EWctGbb,ntry, ex6(:), wf6(:,6), wf12(:,38), n3(:,94), t3x12(:,:,36))
  call counter_WQ_A(ntry, ex5(:), wf4(:,12), wf12(:,39), n3(:,95), t3x12(:,:,37))
  call counter_VV_S(ntry, wf4(:,8), ex5(:), wf12(:,40), n3(:,96), t3x12(:,:,38))
  call counter_UV_W(ntry, wf4(:,8), 9, ex5(:), 16, wf12(:,41), n3(:,97), t3x12(:,:,39))
  call counter_QA_V(ntry, wf6(:,2), ex4(:), wf12(:,42), n3(:,98), t3x12(:,:,40))
  call counter_QA_V_LR(EWctAdd,ntry, wf6(:,2), ex4(:), wf12(:,43), n3(:,99), t3x12(:,:,41))
  call counter_QA_Z(gZd,ntry, wf6(:,2), ex4(:), wf12(:,44), n3(:,100), t3x12(:,:,42))
  call counter_QA_Z(EWctVdd,ntry, wf6(:,2), ex4(:), wf12(:,45), n3(:,101), t3x12(:,:,43))
  call vert_AQ_S(gPtb,ntry, ex3(:), wf6(:,6), wf12(:,46), n3(:,102), t3x12(:,:,44))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,8), wf12(:,47), n3(:,103), t3x12(:,:,45))
  call counter_AW_Q(ntry, ex3(:), wf4(:,8), wf8(:,33), n3(:,104), t3x8(:,:,28))
  call prop_Q_A(ntry, wf12(:,10), 50, MB, 1_intkind1, wf12(:,48), n2(18))
  call counter_AV_Q(ntry, ex3(:), ex6(:), wf4(:,18), n3(:,105), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,18), 36, MT, 1_intkind1, wf4(:,19), n2(19))
  call counter_AV_Q_LR(EWctGtt,ntry, ex3(:), ex6(:), wf4(:,20), n3(:,106), t3x4(:,:,13))
  call prop_A_Q(ntry, wf4(:,20), 36, MT, 1_intkind1, wf4(:,21), n2(20))
  call counter_AQ_S(gH,ntry, ex3(:), wf4(:,12), wf8(:,34), n3(:,107), t3x8(:,:,29))
  call counter_AQ_S(EWctHtt,ntry, ex3(:), wf4(:,12), wf8(:,35), n3(:,108), t3x8(:,:,30))
  call counter_QA_V(ntry, wf4(:,12), ex3(:), wf8(:,36), n3(:,109), t3x8(:,:,31))
  call counter_QA_V_LR(EWctAtt,ntry, wf4(:,12), ex3(:), wf8(:,37), n3(:,110), t3x8(:,:,32))
  call counter_QA_Z(gZu,ntry, wf4(:,12), ex3(:), wf8(:,38), n3(:,111), t3x8(:,:,33))
  call counter_QA_Z(EWctVtt,ntry, wf4(:,12), ex3(:), wf8(:,39), n3(:,112), t3x8(:,:,34))
  call prop_Q_A(ntry, wf12(:,11), 50, MB, 1_intkind1, wf12(:,49), n2(21))
  call vert_AQ_S(gH,ntry, wf4(:,19), ex2(:), wf8(:,40), n3(:,113), t3x8(:,:,35))
  call vert_AQ_S(gH,ntry, wf4(:,21), ex2(:), wf8(:,41), n3(:,114), t3x8(:,:,36))
  call vert_QA_V(ntry, ex2(:), wf4(:,19), wf8(:,42), n3(:,115), t3x8(:,:,37))
  call vert_QA_V(ntry, ex2(:), wf4(:,21), wf8(:,43), n3(:,116), t3x8(:,:,38))
  call vert_QA_Z(gZu,ntry, ex2(:), wf4(:,19), wf8(:,44), n3(:,117), t3x8(:,:,39))
  call vert_QA_Z(gZu,ntry, ex2(:), wf4(:,21), wf8(:,45), n3(:,118), t3x8(:,:,40))
  call counter_QA_V_LR(EWctGtt,ntry, wf4(:,12), ex3(:), wf8(:,46), n3(:,119), t3x8(:,:,41))
  call counter_QA_W(ntry, wf6(:,6), ex3(:), wf12(:,50), n3(:,120), t3x12(:,:,46))
  call counter_AQ_S(gH,ntry, wf4(:,10), ex2(:), wf8(:,47), n3(:,121), t3x8(:,:,42))
  call counter_AQ_S(EWctHtt,ntry, wf4(:,10), ex2(:), wf8(:,48), n3(:,122), t3x8(:,:,43))
  call counter_QA_V(ntry, ex2(:), wf4(:,10), wf8(:,49), n3(:,123), t3x8(:,:,44))
  call counter_QA_V_LR(EWctAtt,ntry, ex2(:), wf4(:,10), wf8(:,50), n3(:,124), t3x8(:,:,45))
  call counter_QA_Z(gZu,ntry, ex2(:), wf4(:,10), wf8(:,51), n3(:,125), t3x8(:,:,46))
  call counter_QA_Z(EWctVtt,ntry, ex2(:), wf4(:,10), wf8(:,52), n3(:,126), t3x8(:,:,47))
  call counter_VQ_A(ntry, ex6(:), ex2(:), wf4(:,22), n3(:,127), t3x4(:,:,14))
  call prop_Q_A(ntry, wf4(:,22), 34, MT, 1_intkind1, wf4(:,23), n2(22))
  call vert_WQ_A(ntry, ex5(:), wf4(:,23), wf12(:,51), n3(:,128), t3x12(:,:,47))
  call counter_VQ_A_LR(EWctGtt,ntry, ex6(:), ex2(:), wf4(:,24), n3(:,129), t3x4(:,:,15))
  call prop_Q_A(ntry, wf4(:,24), 34, MT, 1_intkind1, wf4(:,25), n2(23))
  call vert_WQ_A(ntry, ex5(:), wf4(:,25), wf12(:,52), n3(:,130), t3x12(:,:,48))
  call vert_AQ_S(gH,ntry, ex3(:), wf4(:,23), wf8(:,53), n3(:,131), t3x8(:,:,48))
  call vert_AQ_S(gH,ntry, ex3(:), wf4(:,25), wf8(:,54), n3(:,132), t3x8(:,:,49))
  call vert_QA_V(ntry, wf4(:,23), ex3(:), wf8(:,55), n3(:,133), t3x8(:,:,50))
  call vert_QA_V(ntry, wf4(:,25), ex3(:), wf8(:,56), n3(:,134), t3x8(:,:,51))
  call vert_QA_Z(gZu,ntry, wf4(:,23), ex3(:), wf8(:,57), n3(:,135), t3x8(:,:,52))
  call vert_QA_Z(gZu,ntry, wf4(:,25), ex3(:), wf8(:,58), n3(:,136), t3x8(:,:,53))
  call counter_WQ_A(ntry, ex5(:), ex2(:), wf6(:,9), n3(:,137), t3x6(:,:,5))
  call prop_Q_A(ntry, wf6(:,9), 18, MB, 1_intkind1, wf6(:,10), n2(24))
  call vert_WQ_A(ntry, wf4(:,8), wf6(:,10), wf24(:,11), n3(:,138), t3x24(:,:,10))
  call vert_VQ_A(ntry, ex6(:), wf6(:,10), wf12(:,53), n3(:,139), t3x12(:,:,49))
  call counter_QA_V_LR(EWctGtt,ntry, ex2(:), wf4(:,10), wf8(:,59), n3(:,140), t3x8(:,:,54))
  call vert_QA_W(ntry, wf6(:,10), ex3(:), wf12(:,54), n3(:,141), t3x12(:,:,50))
  call counter_QA_V(ntry, ex2(:), ex3(:), wf4(:,26), n3(:,142), t3x4(:,:,16))
  call vert_VQ_A(ntry, wf4(:,26), wf6(:,2), wf24(:,12), n3(:,143), t3x24(:,:,11))
  call counter_QA_V_LR(EWctAtt,ntry, ex2(:), ex3(:), wf4(:,27), n3(:,144), t3x4(:,:,17))
  call vert_VQ_A(ntry, wf4(:,27), wf6(:,2), wf24(:,13), n3(:,145), t3x24(:,:,12))
  call counter_QA_Z(gZu,ntry, ex2(:), ex3(:), wf4(:,28), n3(:,146), t3x4(:,:,18))
  call vert_ZQ_A(gZd,ntry, wf4(:,28), wf6(:,2), wf24(:,14), n3(:,147), t3x24(:,:,13))
  call counter_QA_Z(EWctVtt,ntry, ex2(:), ex3(:), wf4(:,29), n3(:,148), t3x4(:,:,19))
  call vert_ZQ_A(gZd,ntry, wf4(:,29), wf6(:,2), wf24(:,15), n3(:,149), t3x24(:,:,14))
  call counter_QA_V_LR(EWctGtt,ntry, ex2(:), ex3(:), wf4(:,30), n3(:,150), t3x4(:,:,20))
  call vert_VQ_A(ntry, wf4(:,30), wf6(:,2), wf24(:,16), n3(:,151), t3x24(:,:,15))
  call vert_UV_W(ntry, wf4(:,30), 6, ex6(:), 32, wf8(:,60), n3(:,152), t3x8(:,:,55))
  call vert_AV_Q(ntry, ex4(:), wf4(:,26), wf8(:,61), n3(:,153), t3x8(:,:,56))
  call prop_A_Q(ntry, wf8(:,61), 14, ZERO, 0_intkind1, wf8(:,62), n2(25))
  call vert_AV_Q(ntry, ex4(:), wf4(:,27), wf8(:,63), n3(:,154), t3x8(:,:,57))
  call prop_A_Q(ntry, wf8(:,63), 14, ZERO, 0_intkind1, wf8(:,64), n2(26))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,28), wf8(:,65), n3(:,155), t3x8(:,:,58))
  call prop_A_Q(ntry, wf8(:,65), 14, ZERO, 0_intkind1, wf8(:,66), n2(27))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,29), wf8(:,67), n3(:,156), t3x8(:,:,59))
  call prop_A_Q(ntry, wf8(:,67), 14, ZERO, 0_intkind1, wf8(:,68), n2(28))
  call vert_AV_Q(ntry, ex4(:), wf4(:,30), wf8(:,69), n3(:,157), t3x8(:,:,60))
  call prop_A_Q(ntry, wf8(:,69), 14, ZERO, 0_intkind1, wf8(:,70), n2(29))
  call vert_VQ_A(ntry, wf4(:,26), wf4(:,6), wf16(:,8), n3(:,158), t3x16(:,:,8))
  call vert_VQ_A(ntry, wf4(:,27), wf4(:,6), wf16(:,9), n3(:,159), t3x16(:,:,9))
  call vert_ZQ_A(gZu,ntry, wf4(:,28), wf4(:,6), wf16(:,10), n3(:,160), t3x16(:,:,10))
  call vert_ZQ_A(gZu,ntry, wf4(:,29), wf4(:,6), wf16(:,11), n3(:,161), t3x16(:,:,11))
  call vert_VQ_A(ntry, wf4(:,30), wf4(:,6), wf16(:,12), n3(:,162), t3x16(:,:,12))
  call vert_VQ_A(ntry, wf4(:,26), ex1(:), wf8(:,71), n3(:,163), t3x8(:,:,61))
  call prop_Q_A(ntry, wf8(:,71), 7, ZERO, 0_intkind1, wf8(:,72), n2(30))
  call vert_VQ_A(ntry, wf4(:,27), ex1(:), wf8(:,73), n3(:,164), t3x8(:,:,62))
  call prop_Q_A(ntry, wf8(:,73), 7, ZERO, 0_intkind1, wf8(:,74), n2(31))
  call vert_ZQ_A(gZu,ntry, wf4(:,28), ex1(:), wf8(:,75), n3(:,165), t3x8(:,:,63))
  call prop_Q_A(ntry, wf8(:,75), 7, ZERO, 0_intkind1, wf8(:,76), n2(32))
  call vert_ZQ_A(gZu,ntry, wf4(:,29), ex1(:), wf8(:,77), n3(:,166), t3x8(:,:,64))
  call prop_Q_A(ntry, wf8(:,77), 7, ZERO, 0_intkind1, wf8(:,78), n2(33))
  call vert_VQ_A(ntry, wf4(:,30), ex1(:), wf8(:,79), n3(:,167), t3x8(:,:,65))
  call prop_Q_A(ntry, wf8(:,79), 7, ZERO, 0_intkind1, wf8(:,80), n2(34))
  call counter_AQ_S(gH,ntry, ex3(:), ex2(:), wf4(:,31), n3(:,168), t3x4(:,:,21))
  call vert_SV_V(ntry, wf4(:,31), ex5(:), wf12(:,55), n3(:,169), t3x12(:,:,51))
  call counter_AQ_S(EWctHtt,ntry, ex3(:), ex2(:), wf4(:,32), n3(:,170), t3x4(:,:,22))
  call vert_SV_V(ntry, wf4(:,32), ex5(:), wf12(:,56), n3(:,171), t3x12(:,:,52))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,26), 6, wf12(:,57), n3(:,172), t3x12(:,:,53))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,27), 6, wf12(:,58), n3(:,173), t3x12(:,:,54))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,28), 6, wf12(:,59), n3(:,174), t3x12(:,:,55))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,29), 6, wf12(:,60), n3(:,175), t3x12(:,:,56))
  call counter_VQ_A(ntry, wf4(:,1), ex1(:), wf8(:,81), n3(:,176), t3x8(:,:,66))
  call prop_A_Q(ntry, wf12(:,3), 56, ZERO, 0_intkind1, wf12(:,61), n2(35))
  call counter_VQ_A_LR(EWctAuu,ntry, wf4(:,1), ex1(:), wf8(:,82), n3(:,177), t3x8(:,:,67))
  call counter_ZQ_A(gZu,ntry, wf4(:,4), ex1(:), wf8(:,83), n3(:,178), t3x8(:,:,68))
  call counter_ZQ_A(EWctVuu,ntry, wf4(:,4), ex1(:), wf8(:,84), n3(:,179), t3x8(:,:,69))
  call counter_VQ_A_LR(EWctGuu,ntry, wf4(:,1), ex1(:), wf8(:,85), n3(:,180), t3x8(:,:,70))
  call counter_QA_V_LR(EWctGuu,ntry, ex1(:), wf6(:,4), wf12(:,62), n3(:,181), t3x12(:,:,57))
  call counter_VQ_A(ntry, ex6(:), ex1(:), wf4(:,33), n3(:,182), t3x4(:,:,23))
  call prop_Q_A(ntry, wf4(:,33), 33, ZERO, 0_intkind1, wf4(:,34), n2(36))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,34), wf16(:,13), n3(:,183), t3x16(:,:,13))
  call counter_VQ_A_LR(EWctGuu,ntry, ex6(:), ex1(:), wf4(:,35), n3(:,184), t3x4(:,:,24))
  call prop_Q_A(ntry, wf4(:,35), 33, ZERO, 0_intkind1, wf4(:,36), n2(37))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,36), wf16(:,14), n3(:,185), t3x16(:,:,14))
  call vert_ZQ_A(gZu,ntry, wf4(:,4), wf4(:,34), wf16(:,15), n3(:,186), t3x16(:,:,15))
  call vert_ZQ_A(gZu,ntry, wf4(:,4), wf4(:,36), wf16(:,16), n3(:,187), t3x16(:,:,16))
  call prop_A_Q(ntry, wf12(:,9), 56, ZERO, 0_intkind1, wf12(:,63), n2(38))
  call counter_AQ_S(gPdu,ntry, wf4(:,3), ex1(:), wf8(:,86), n3(:,188), t3x8(:,:,71))
  call counter_QA_W(ntry, ex1(:), wf4(:,3), wf8(:,87), n3(:,189), t3x8(:,:,72))
  call vert_QA_W(ntry, wf4(:,34), ex4(:), wf8(:,88), n3(:,190), t3x8(:,:,73))
  call vert_QA_W(ntry, wf4(:,36), ex4(:), wf8(:,89), n3(:,191), t3x8(:,:,74))
  call vert_WQ_A(ntry, ex5(:), wf4(:,34), wf12(:,64), n3(:,192), t3x12(:,:,58))
  call vert_WQ_A(ntry, ex5(:), wf4(:,36), wf12(:,65), n3(:,193), t3x12(:,:,59))
  call counter_WQ_A(ntry, ex5(:), ex1(:), wf6(:,11), n3(:,194), t3x6(:,:,6))
  call prop_Q_A(ntry, wf6(:,11), 17, ZERO, 0_intkind1, wf6(:,12), n2(39))
  call vert_VQ_A(ntry, wf4(:,1), wf6(:,12), wf24(:,17), n3(:,195), t3x24(:,:,16))
  call vert_ZQ_A(gZd,ntry, wf4(:,4), wf6(:,12), wf24(:,18), n3(:,196), t3x24(:,:,17))
  call vert_QA_V(ntry, wf6(:,12), ex4(:), wf12(:,66), n3(:,197), t3x12(:,:,60))
  call vert_VQ_A(ntry, ex6(:), wf6(:,12), wf12(:,67), n3(:,198), t3x12(:,:,61))
  call counter_QA_V(ntry, ex1(:), wf6(:,4), wf12(:,68), n3(:,199), t3x12(:,:,62))
  call counter_QA_V_LR(EWctAuu,ntry, ex1(:), wf6(:,4), wf12(:,69), n3(:,200), t3x12(:,:,63))
  call counter_QA_Z(gZu,ntry, ex1(:), wf6(:,4), wf12(:,70), n3(:,201), t3x12(:,:,64))
  call counter_QA_Z(EWctVuu,ntry, ex1(:), wf6(:,4), wf12(:,71), n3(:,202), t3x12(:,:,65))
  call vert_QA_Z(gZd,ntry, wf6(:,12), ex4(:), wf12(:,72), n3(:,203), t3x12(:,:,66))
  call counter_AQ_S(gPdu,ntry, ex4(:), ex1(:), wf4(:,37), n3(:,204), t3x4(:,:,25))
  call vert_QS_A(gPtb,ntry, wf6(:,6), wf4(:,37), wf24(:,19), n3(:,205), t3x24(:,:,18))
  call counter_QA_W(ntry, ex1(:), ex4(:), wf4(:,38), n3(:,206), t3x4(:,:,26))
  call vert_WQ_A(ntry, wf4(:,38), wf6(:,6), wf24(:,20), n3(:,207), t3x24(:,:,19))
  call vert_SA_Q(gPtb,ntry, wf4(:,37), ex3(:), wf8(:,90), n3(:,208), t3x8(:,:,75))
  call prop_A_Q(ntry, wf8(:,90), 13, MB, 1_intkind1, wf8(:,91), n2(40))
  call vert_AW_Q(ntry, ex3(:), wf4(:,38), wf8(:,92), n3(:,209), t3x8(:,:,76))
  call prop_A_Q(ntry, wf8(:,92), 13, MB, 1_intkind1, wf8(:,93), n2(41))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,37), 9, wf12(:,73), n3(:,210), t3x12(:,:,67))
  call vert_AQ_S(gX,ntry, ex3(:), wf4(:,12), wf8(:,94), n3(:,211), t3x8(:,:,77))
  call vert_SV_V(ntry, wf4(:,37), ex5(:), wf12(:,74), n3(:,212), t3x12(:,:,68))
  call vert_VV_S(ntry, wf4(:,38), ex5(:), wf12(:,75), n3(:,213), t3x12(:,:,69))
  call vert_UV_W(ntry, wf4(:,38), 9, ex5(:), 16, wf12(:,76), n3(:,214), t3x12(:,:,70))
  call vert_AQ_S(gX,ntry, wf4(:,10), ex2(:), wf8(:,95), n3(:,215), t3x8(:,:,78))
  call vert_AV_Q(ntry, wf4(:,3), wf4(:,1), wf16(:,17), n3(:,216), t3x16(:,:,17))
  call counter_Q_A(ctqq,1,ntry, wf6(:,2), 17, wf6(:,13), n2(42))
  call prop_A_Q(ntry, wf16(:,17), 46, ZERO, 0_intkind1, wf16(:,18), n2(43))
  call counter_Q_A_LR(EWctdd,ntry, wf6(:,2), 17, wf6(:,14), n2(44))
  call vert_AZ_Q(gZd,ntry, wf4(:,3), wf4(:,4), wf16(:,19), n3(:,217), t3x16(:,:,18))
  call prop_A_Q(ntry, wf16(:,19), 46, ZERO, 0_intkind1, wf16(:,20), n2(45))
  call vert_QA_V(ntry, wf6(:,2), wf4(:,3), wf24(:,21), n3(:,218), t3x24(:,:,20))
  call counter_S_V(EWctXA,ntry, wf4(:,17), 6, wf4(:,39), n2(46))
  call vert_QA_Z(gZd,ntry, wf6(:,2), wf4(:,3), wf24(:,22), n3(:,219), t3x24(:,:,21))
  call counter_S_V(EWctXZ,ntry, wf4(:,17), 6, wf4(:,40), n2(47))
  call counter_V_V(EWctAA,ntry, wf4(:,1), 6, wf4(:,41), n2(48))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 6, wf4(:,42), n2(49))
  call counter_V_V(EWctAZ,ntry, wf4(:,4), 6, wf4(:,43), n2(50))
  call counter_V_V(EWctZZ,ntry, wf4(:,4), 6, wf4(:,44), n2(51))
  call counter_A_Q(ctqq,1,ntry, wf4(:,3), 40, wf4(:,45), n2(52))
  call prop_Q_A(ntry, wf24(:,1), 23, ZERO, 0_intkind1, wf24(:,23), n2(53))
  call counter_A_Q_LR(EWctdd,ntry, wf4(:,3), 40, wf4(:,46), n2(54))
  call prop_Q_A(ntry, wf24(:,2), 23, ZERO, 0_intkind1, wf24(:,24), n2(55))
  call prop_Q_A(ntry, wf6(:,14), 17, ZERO, 0_intkind1, wf6(:,15), n2(56))
  call vert_QA_V(ntry, wf6(:,15), ex4(:), wf12(:,77), n3(:,220), t3x12(:,:,71))
  call prop_Q_A(ntry, wf6(:,13), 17, ZERO, 0_intkind1, wf6(:,16), n2(57))
  call vert_VQ_A(ntry, ex6(:), wf6(:,16), wf12(:,78), n3(:,221), t3x12(:,:,72))
  call vert_VQ_A(ntry, ex6(:), wf6(:,15), wf12(:,79), n3(:,222), t3x12(:,:,73))
  call vert_AV_Q(ntry, ex4(:), wf4(:,39), wf8(:,96), n3(:,223), t3x8(:,:,79))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,40), wf8(:,97), n3(:,224), t3x8(:,:,80))
  call vert_AV_Q(ntry, ex4(:), wf4(:,41), wf8(:,98), n3(:,225), t3x8(:,:,81))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,42), wf8(:,99), n3(:,226), t3x8(:,:,82))
  call vert_AV_Q(ntry, ex4(:), wf4(:,43), wf8(:,100), n3(:,227), t3x8(:,:,83))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,44), wf8(:,101), n3(:,228), t3x8(:,:,84))
  call counter_A_Q(ctqq,1,ntry, wf8(:,3), 14, wf8(:,102), n2(58))
  call counter_A_Q_LR(EWctdd,ntry, wf8(:,3), 14, wf8(:,103), n2(59))
  call counter_A_Q(ctqq,1,ntry, wf8(:,5), 14, wf8(:,104), n2(60))
  call counter_A_Q_LR(EWctdd,ntry, wf8(:,5), 14, wf8(:,105), n2(61))
  call vert_AV_Q(ntry, wf6(:,4), wf4(:,1), wf24(:,25), n3(:,229), t3x24(:,:,22))
  call counter_Q_A(ctqq,2,ntry, wf4(:,6), 33, wf4(:,47), n2(62))
  call prop_A_Q(ntry, wf24(:,25), 30, ZERO, 0_intkind1, wf24(:,26), n2(63))
  call counter_Q_A_LR(EWctuu,ntry, wf4(:,6), 33, wf4(:,48), n2(64))
  call vert_AZ_Q(gZu,ntry, wf6(:,4), wf4(:,4), wf24(:,27), n3(:,230), t3x24(:,:,23))
  call prop_A_Q(ntry, wf24(:,27), 30, ZERO, 0_intkind1, wf24(:,28), n2(65))
  call vert_QA_V(ntry, wf4(:,6), wf6(:,4), wf24(:,29), n3(:,231), t3x24(:,:,24))
  call vert_QA_Z(gZu,ntry, wf4(:,6), wf6(:,4), wf24(:,30), n3(:,232), t3x24(:,:,25))
  call counter_A_Q(ctqq,2,ntry, wf6(:,4), 24, wf6(:,17), n2(66))
  call prop_Q_A(ntry, wf16(:,1), 39, ZERO, 0_intkind1, wf16(:,21), n2(67))
  call counter_A_Q_LR(EWctuu,ntry, wf6(:,4), 24, wf6(:,18), n2(68))
  call prop_Q_A(ntry, wf16(:,2), 39, ZERO, 0_intkind1, wf16(:,22), n2(69))
  call vert_VQ_A(ntry, wf4(:,39), ex1(:), wf8(:,106), n3(:,233), t3x8(:,:,85))
  call vert_ZQ_A(gZu,ntry, wf4(:,40), ex1(:), wf8(:,107), n3(:,234), t3x8(:,:,86))
  call vert_VQ_A(ntry, wf4(:,41), ex1(:), wf8(:,108), n3(:,235), t3x8(:,:,87))
  call vert_VQ_A(ntry, wf4(:,43), ex1(:), wf8(:,109), n3(:,236), t3x8(:,:,88))
  call vert_ZQ_A(gZu,ntry, wf4(:,42), ex1(:), wf8(:,110), n3(:,237), t3x8(:,:,89))
  call vert_ZQ_A(gZu,ntry, wf4(:,44), ex1(:), wf8(:,111), n3(:,238), t3x8(:,:,90))
  call prop_A_Q(ntry, wf6(:,18), 24, ZERO, 0_intkind1, wf6(:,19), n2(70))
  call vert_QA_V(ntry, ex1(:), wf6(:,19), wf12(:,80), n3(:,239), t3x12(:,:,74))
  call counter_Q_A(ctqq,2,ntry, wf8(:,7), 7, wf8(:,112), n2(71))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,7), 7, wf8(:,113), n2(72))
  call counter_Q_A(ctqq,2,ntry, wf8(:,9), 7, wf8(:,114), n2(73))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,9), 7, wf8(:,115), n2(74))
  call prop_A_Q(ntry, wf6(:,17), 24, ZERO, 0_intkind1, wf6(:,20), n2(75))
  call vert_AV_Q(ntry, wf6(:,20), ex6(:), wf12(:,81), n3(:,240), t3x12(:,:,75))
  call vert_AV_Q(ntry, wf6(:,19), ex6(:), wf12(:,82), n3(:,241), t3x12(:,:,76))
  call prop_Q_A(ntry, wf4(:,47), 33, ZERO, 0_intkind1, wf4(:,49), n2(76))
  call vert_QA_W(ntry, wf4(:,49), ex4(:), wf8(:,116), n3(:,242), t3x8(:,:,91))
  call prop_Q_A(ntry, wf4(:,48), 33, ZERO, 0_intkind1, wf4(:,50), n2(77))
  call vert_QA_W(ntry, wf4(:,50), ex4(:), wf8(:,117), n3(:,243), t3x8(:,:,92))
  call vert_WQ_A(ntry, ex5(:), wf4(:,49), wf12(:,83), n3(:,244), t3x12(:,:,77))
  call vert_WQ_A(ntry, ex5(:), wf4(:,50), wf12(:,84), n3(:,245), t3x12(:,:,78))
  call counter_S_S(EWctHH,ntry, wf4(:,7), 6, wf4(:,51), n2(78))
  call vert_SV_V(ntry, wf4(:,51), ex5(:), wf12(:,85), n3(:,246), t3x12(:,:,79))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,39), 6, wf12(:,86), n3(:,247), t3x12(:,:,80))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,40), 6, wf12(:,87), n3(:,248), t3x12(:,:,81))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,41), 6, wf12(:,88), n3(:,249), t3x12(:,:,82))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,42), 6, wf12(:,89), n3(:,250), t3x12(:,:,83))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,43), 6, wf12(:,90), n3(:,251), t3x12(:,:,84))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,44), 6, wf12(:,91), n3(:,252), t3x12(:,:,85))
  call counter_V_S(EWctPW,ntry, wf8(:,10), 41, wf8(:,118), n2(79))
  call counter_V_V(EWctWW,ntry, wf8(:,10), 41, wf8(:,119), n2(80))
  call prop_A_Q(ntry, wf4(:,45), 40, ZERO, 0_intkind1, wf4(:,52), n2(81))
  call vert_QA_W(ntry, ex1(:), wf4(:,52), wf8(:,120), n3(:,253), t3x8(:,:,93))
  call prop_A_Q(ntry, wf4(:,46), 40, ZERO, 0_intkind1, wf4(:,53), n2(82))
  call vert_QA_W(ntry, ex1(:), wf4(:,53), wf8(:,121), n3(:,254), t3x8(:,:,94))
  call counter_V_S(EWctPW,ntry, wf8(:,11), 41, wf8(:,122), n2(83))
  call counter_V_V(EWctWW,ntry, wf8(:,11), 41, wf8(:,123), n2(84))
  call vert_AW_Q(ntry, wf4(:,52), ex5(:), wf12(:,92), n3(:,255), t3x12(:,:,86))
  call vert_AW_Q(ntry, wf4(:,53), ex5(:), wf12(:,93), n3(:,256), t3x12(:,:,87))
  call vert_AQ_S(gPtb,ntry, wf4(:,10), wf6(:,6), wf24(:,31), n3(:,257), t3x24(:,:,26))
  call counter_V_S(EWctPW,ntry, wf4(:,8), 9, wf4(:,54), n2(85))
  call vert_QA_W(ntry, wf6(:,6), wf4(:,10), wf24(:,32), n3(:,258), t3x24(:,:,27))
  call counter_V_V(EWctWW,ntry, wf4(:,8), 9, wf4(:,55), n2(86))
  call vert_AW_Q(ntry, wf4(:,10), wf4(:,8), wf16(:,23), n3(:,259), t3x16(:,:,19))
  call counter_Q_A(ctbb,5,ntry, wf6(:,6), 18, wf6(:,21), n2(87))
  call prop_A_Q(ntry, wf16(:,23), 45, MB, 1_intkind1, wf16(:,24), n2(88))
  call counter_Q_A_LR(EWctbb,ntry, wf6(:,6), 18, wf6(:,22), n2(89))
  call counter_A_Q(cttt,6,ntry, wf4(:,10), 36, wf4(:,56), n2(90))
  call prop_Q_A(ntry, wf24(:,3), 27, MT, 1_intkind1, wf24(:,33), n2(91))
  call counter_A_Q_LR(EWcttt,ntry, wf4(:,10), 36, wf4(:,57), n2(92))
  call vert_SA_Q(gPtb,ntry, wf4(:,54), ex3(:), wf8(:,124), n3(:,260), t3x8(:,:,95))
  call vert_AW_Q(ntry, ex3(:), wf4(:,55), wf8(:,125), n3(:,261), t3x8(:,:,96))
  call prop_Q_A(ntry, wf6(:,21), 18, MB, 1_intkind1, wf6(:,23), n2(93))
  call vert_VQ_A(ntry, ex6(:), wf6(:,23), wf12(:,94), n3(:,262), t3x12(:,:,88))
  call prop_Q_A(ntry, wf6(:,22), 18, MB, 1_intkind1, wf6(:,24), n2(94))
  call vert_VQ_A(ntry, ex6(:), wf6(:,24), wf12(:,95), n3(:,263), t3x12(:,:,89))
  call counter_A_Q(ctbb,5,ntry, wf8(:,13), 13, wf8(:,126), n2(95))
  call counter_A_Q_LR(EWctbb,ntry, wf8(:,13), 13, wf8(:,127), n2(96))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,54), 9, wf12(:,96), n3(:,264), t3x12(:,:,90))
  call vert_SV_V(ntry, wf4(:,54), ex5(:), wf12(:,97), n3(:,265), t3x12(:,:,91))
  call vert_VV_S(ntry, wf4(:,55), ex5(:), wf12(:,98), n3(:,266), t3x12(:,:,92))
  call vert_UV_W(ntry, wf4(:,55), 9, ex5(:), 16, wf12(:,99), n3(:,267), t3x12(:,:,93))
  call counter_Q_A(cttt,6,ntry, wf4(:,12), 34, wf4(:,58), n2(97))
  call prop_Q_A(ntry, wf4(:,58), 34, MT, 1_intkind1, wf4(:,59), n2(98))
  call vert_AQ_S(gH,ntry, ex3(:), wf4(:,59), wf8(:,128), n3(:,268), t3x8(:,:,97))
  call counter_Q_A_LR(EWcttt,ntry, wf4(:,12), 34, wf4(:,60), n2(99))
  call prop_Q_A(ntry, wf4(:,60), 34, MT, 1_intkind1, wf4(:,61), n2(100))
  call vert_AQ_S(gH,ntry, ex3(:), wf4(:,61), wf8(:,129), n3(:,269), t3x8(:,:,98))
  call vert_QA_V(ntry, wf4(:,59), ex3(:), wf8(:,130), n3(:,270), t3x8(:,:,99))
  call vert_QA_V(ntry, wf4(:,61), ex3(:), wf8(:,131), n3(:,271), t3x8(:,:,100))
  call vert_QA_Z(gZu,ntry, wf4(:,59), ex3(:), wf8(:,132), n3(:,272), t3x8(:,:,101))
  call vert_QA_Z(gZu,ntry, wf4(:,61), ex3(:), wf8(:,133), n3(:,273), t3x8(:,:,102))
  call vert_WQ_A(ntry, ex5(:), wf4(:,59), wf12(:,100), n3(:,274), t3x12(:,:,94))
  call vert_WQ_A(ntry, ex5(:), wf4(:,61), wf12(:,101), n3(:,275), t3x12(:,:,95))
  call counter_S_S(EWctHH,ntry, wf8(:,14), 38, wf8(:,134), n2(101))
  call counter_S_V(EWctXA,ntry, wf8(:,94), 38, wf8(:,135), n2(102))
  call counter_S_V(EWctXZ,ntry, wf8(:,94), 38, wf8(:,136), n2(103))
  call counter_V_V(EWctAA,ntry, wf8(:,15), 38, wf8(:,137), n2(104))
  call counter_V_V(EWctAZ,ntry, wf8(:,15), 38, wf8(:,138), n2(105))
  call counter_V_V(EWctAZ,ntry, wf8(:,16), 38, wf8(:,139), n2(106))
  call counter_V_V(EWctZZ,ntry, wf8(:,16), 38, wf8(:,140), n2(107))
  call prop_A_Q(ntry, wf4(:,56), 36, MT, 1_intkind1, wf4(:,62), n2(108))
  call vert_AQ_S(gH,ntry, wf4(:,62), ex2(:), wf8(:,141), n3(:,276), t3x8(:,:,103))
  call prop_A_Q(ntry, wf4(:,57), 36, MT, 1_intkind1, wf4(:,63), n2(109))
  call vert_AQ_S(gH,ntry, wf4(:,63), ex2(:), wf8(:,142), n3(:,277), t3x8(:,:,104))
  call vert_QA_V(ntry, ex2(:), wf4(:,62), wf8(:,143), n3(:,278), t3x8(:,:,105))
  call vert_QA_V(ntry, ex2(:), wf4(:,63), wf8(:,144), n3(:,279), t3x8(:,:,106))
  call vert_QA_Z(gZu,ntry, ex2(:), wf4(:,62), wf8(:,145), n3(:,280), t3x8(:,:,107))
  call vert_QA_Z(gZu,ntry, ex2(:), wf4(:,63), wf8(:,146), n3(:,281), t3x8(:,:,108))
  call counter_S_S(EWctHH,ntry, wf8(:,17), 38, wf8(:,147), n2(110))
  call counter_S_V(EWctXA,ntry, wf8(:,95), 38, wf8(:,148), n2(111))
  call counter_S_V(EWctXZ,ntry, wf8(:,95), 38, wf8(:,149), n2(112))
  call counter_V_V(EWctAA,ntry, wf8(:,18), 38, wf8(:,150), n2(113))
  call counter_V_V(EWctAZ,ntry, wf8(:,18), 38, wf8(:,151), n2(114))
  call counter_V_V(EWctAZ,ntry, wf8(:,19), 38, wf8(:,152), n2(115))
  call counter_V_V(EWctZZ,ntry, wf8(:,19), 38, wf8(:,153), n2(116))
  call vert_QA_V(ntry, wf6(:,16), ex4(:), wf12(:,102), n3(:,282), t3x12(:,:,96))
  call vert_QA_Z(gZd,ntry, wf6(:,16), ex4(:), wf12(:,103), n3(:,283), t3x12(:,:,97))
  call vert_QA_Z(gZd,ntry, wf6(:,15), ex4(:), wf12(:,104), n3(:,284), t3x12(:,:,98))
  call vert_QA_W(ntry, wf6(:,23), ex3(:), wf12(:,105), n3(:,285), t3x12(:,:,99))
  call vert_QA_W(ntry, wf6(:,24), ex3(:), wf12(:,106), n3(:,286), t3x12(:,:,100))
  call counter_S_V(EWctPW,ntry, wf12(:,46), 22, wf12(:,107), n2(117))
  call counter_V_V(EWctWW,ntry, wf12(:,15), 22, wf12(:,108), n2(118))
  call counter_V_S(EWctXA,ntry, wf12(:,4), 25, wf12(:,109), n2(119))
  call counter_V_S(EWctXZ,ntry, wf12(:,16), 25, wf12(:,110), n2(120))
  call counter_V_V(EWctAA,ntry, wf12(:,4), 25, wf12(:,111), n2(121))
  call counter_V_V(EWctAZ,ntry, wf12(:,4), 25, wf12(:,112), n2(122))
  call counter_V_V(EWctAZ,ntry, wf12(:,16), 25, wf12(:,113), n2(123))
  call counter_V_V(EWctZZ,ntry, wf12(:,16), 25, wf12(:,114), n2(124))
  call vert_QA_V(ntry, ex1(:), wf6(:,20), wf12(:,115), n3(:,287), t3x12(:,:,101))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,20), wf12(:,116), n3(:,288), t3x12(:,:,102))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,19), wf12(:,117), n3(:,289), t3x12(:,:,103))
  call vert_WQ_A(ntry, ex5(:), wf8(:,7), wf24(:,34), n3(:,290), t3x24(:,:,28))
  call prop_Q_A(ntry, wf24(:,34), 23, ZERO, 0_intkind1, wf24(:,35), n2(125))
  call vert_WQ_A(ntry, ex5(:), wf8(:,9), wf24(:,36), n3(:,291), t3x24(:,:,29))
  call prop_Q_A(ntry, wf24(:,36), 23, ZERO, 0_intkind1, wf24(:,37), n2(126))
  call vert_VQ_A(ntry, ex6(:), wf8(:,7), wf16(:,25), n3(:,292), t3x16(:,:,20))
  call prop_Q_A(ntry, wf16(:,25), 39, ZERO, 0_intkind1, wf16(:,26), n2(127))
  call vert_VQ_A(ntry, ex6(:), wf8(:,9), wf16(:,27), n3(:,293), t3x16(:,:,21))
  call prop_Q_A(ntry, wf16(:,27), 39, ZERO, 0_intkind1, wf16(:,28), n2(128))
  call vert_WQ_A(ntry, wf12(:,5), ex1(:), wf24(:,38), n3(:,294), t3x24(:,:,30))
  call prop_Q_A(ntry, wf24(:,38), 23, ZERO, 0_intkind1, wf24(:,39), n2(129))
  call vert_WQ_A(ntry, wf12(:,6), ex1(:), wf24(:,40), n3(:,295), t3x24(:,:,31))
  call prop_Q_A(ntry, wf24(:,40), 23, ZERO, 0_intkind1, wf24(:,41), n2(130))
  call vert_WQ_A(ntry, wf12(:,7), ex1(:), wf24(:,42), n3(:,296), t3x24(:,:,32))
  call prop_Q_A(ntry, wf24(:,42), 23, ZERO, 0_intkind1, wf24(:,43), n2(131))
  call vert_VQ_A(ntry, wf8(:,1), ex1(:), wf16(:,29), n3(:,297), t3x16(:,:,22))
  call prop_Q_A(ntry, wf16(:,29), 39, ZERO, 0_intkind1, wf16(:,30), n2(132))
  call vert_AW_Q(ntry, wf8(:,3), ex5(:), wf24(:,44), n3(:,298), t3x24(:,:,33))
  call prop_A_Q(ntry, wf24(:,44), 30, ZERO, 0_intkind1, wf24(:,45), n2(133))
  call vert_AW_Q(ntry, wf8(:,5), ex5(:), wf24(:,46), n3(:,299), t3x24(:,:,34))
  call prop_A_Q(ntry, wf24(:,46), 30, ZERO, 0_intkind1, wf24(:,47), n2(134))
  call vert_AV_Q(ntry, wf8(:,3), ex6(:), wf16(:,31), n3(:,300), t3x16(:,:,23))
  call prop_A_Q(ntry, wf16(:,31), 46, ZERO, 0_intkind1, wf16(:,32), n2(135))
  call vert_AV_Q(ntry, wf8(:,5), ex6(:), wf16(:,33), n3(:,301), t3x16(:,:,24))
  call prop_A_Q(ntry, wf16(:,33), 46, ZERO, 0_intkind1, wf16(:,34), n2(136))
  call vert_AW_Q(ntry, ex4(:), wf12(:,5), wf24(:,48), n3(:,302), t3x24(:,:,35))
  call prop_A_Q(ntry, wf24(:,48), 30, ZERO, 0_intkind1, wf24(:,49), n2(137))
  call vert_AW_Q(ntry, ex4(:), wf12(:,6), wf24(:,50), n3(:,303), t3x24(:,:,36))
  call prop_A_Q(ntry, wf24(:,50), 30, ZERO, 0_intkind1, wf24(:,51), n2(138))
  call vert_AW_Q(ntry, ex4(:), wf12(:,7), wf24(:,52), n3(:,304), t3x24(:,:,37))
  call prop_A_Q(ntry, wf24(:,52), 30, ZERO, 0_intkind1, wf24(:,53), n2(139))
  call vert_AV_Q(ntry, ex4(:), wf8(:,1), wf16(:,35), n3(:,305), t3x16(:,:,25))
  call prop_A_Q(ntry, wf16(:,35), 46, ZERO, 0_intkind1, wf16(:,36), n2(140))
  call vert_AW_Q(ntry, wf8(:,13), ex5(:), wf24(:,54), n3(:,306), t3x24(:,:,38))
  call prop_A_Q(ntry, wf24(:,54), 29, MT, 1_intkind1, wf24(:,55), n2(141))
  call vert_AV_Q(ntry, wf8(:,13), ex6(:), wf16(:,37), n3(:,307), t3x16(:,:,26))
  call prop_A_Q(ntry, wf16(:,37), 45, MB, 1_intkind1, wf16(:,38), n2(142))
  call vert_QS_A(gH,ntry, ex2(:), wf12(:,12), wf24(:,56), n3(:,308), t3x24(:,:,39))
  call prop_Q_A(ntry, wf24(:,56), 27, MT, 1_intkind1, wf24(:,57), n2(143))
  call vert_VQ_A(ntry, wf12(:,13), ex2(:), wf24(:,58), n3(:,309), t3x24(:,:,40))
  call prop_Q_A(ntry, wf24(:,58), 27, MT, 1_intkind1, wf24(:,59), n2(144))
  call vert_ZQ_A(gZu,ntry, wf12(:,13), ex2(:), wf24(:,60), n3(:,310), t3x24(:,:,41))
  call prop_Q_A(ntry, wf24(:,60), 27, MT, 1_intkind1, wf24(:,61), n2(145))
  call vert_SA_Q(gH,ntry, wf12(:,12), ex3(:), wf24(:,62), n3(:,311), t3x24(:,:,42))
  call prop_A_Q(ntry, wf24(:,62), 29, MT, 1_intkind1, wf24(:,63), n2(146))
  call vert_AV_Q(ntry, ex3(:), wf12(:,13), wf24(:,64), n3(:,312), t3x24(:,:,43))
  call prop_A_Q(ntry, wf24(:,64), 29, MT, 1_intkind1, wf24(:,65), n2(147))
  call vert_AZ_Q(gZu,ntry, ex3(:), wf12(:,13), wf24(:,66), n3(:,313), t3x24(:,:,44))
  call prop_A_Q(ntry, wf24(:,66), 29, MT, 1_intkind1, wf24(:,67), n2(148))
  call vert_VQ_A(ntry, wf12(:,1), ex2(:), wf24(:,68), n3(:,314), t3x24(:,:,45))
  call prop_Q_A(ntry, wf24(:,68), 27, MT, 1_intkind1, wf24(:,69), n2(149))
  call vert_ZQ_A(gZu,ntry, wf12(:,14), ex2(:), wf24(:,70), n3(:,315), t3x24(:,:,46))
  call prop_Q_A(ntry, wf24(:,70), 27, MT, 1_intkind1, wf24(:,71), n2(150))
  call vert_AV_Q(ntry, ex3(:), wf12(:,1), wf24(:,72), n3(:,316), t3x24(:,:,47))
  call prop_A_Q(ntry, wf24(:,72), 29, MT, 1_intkind1, wf24(:,73), n2(151))
  call vert_AZ_Q(gZu,ntry, ex3(:), wf12(:,14), wf24(:,74), n3(:,317), t3x24(:,:,48))
  call prop_A_Q(ntry, wf24(:,74), 29, MT, 1_intkind1, wf24(:,75), n2(152))
  call vert_UV_W(ntry, wf12(:,1), 25, ex6(:), 32, wf24(:,76), n3(:,318), t3x24(:,:,49))
  call vert_QA_V(ntry, wf12(:,26), ex4(:), wf24(:,77), n3(:,319), t3x24(:,:,50))
  call vert_QA_Z(gZd,ntry, wf12(:,26), ex4(:), wf24(:,78), n3(:,320), t3x24(:,:,51))
  call vert_WQ_A(ntry, wf12(:,15), ex1(:), wf24(:,79), n3(:,321), t3x24(:,:,52))
  call prop_Q_A(ntry, wf24(:,79), 23, ZERO, 0_intkind1, wf24(:,80), n2(153))
  call vert_AW_Q(ntry, ex4(:), wf12(:,15), wf24(:,81), n3(:,322), t3x24(:,:,53))
  call prop_A_Q(ntry, wf24(:,81), 30, ZERO, 0_intkind1, wf24(:,82), n2(154))
  call vert_AQ_S(gPtb,ntry, ex3(:), wf12(:,48), wf24(:,83), n3(:,323), t3x24(:,:,54))
  call vert_QA_W(ntry, wf12(:,48), ex3(:), wf24(:,84), n3(:,324), t3x24(:,:,55))
  call vert_VQ_A(ntry, wf12(:,4), ex2(:), wf24(:,85), n3(:,325), t3x24(:,:,56))
  call prop_Q_A(ntry, wf24(:,85), 27, MT, 1_intkind1, wf24(:,86), n2(155))
  call vert_ZQ_A(gZu,ntry, wf12(:,16), ex2(:), wf24(:,87), n3(:,326), t3x24(:,:,57))
  call prop_Q_A(ntry, wf24(:,87), 27, MT, 1_intkind1, wf24(:,88), n2(156))
  call vert_AV_Q(ntry, ex3(:), wf12(:,4), wf24(:,89), n3(:,327), t3x24(:,:,58))
  call prop_A_Q(ntry, wf24(:,89), 29, MT, 1_intkind1, wf24(:,90), n2(157))
  call vert_AZ_Q(gZu,ntry, ex3(:), wf12(:,16), wf24(:,91), n3(:,328), t3x24(:,:,59))
  call prop_A_Q(ntry, wf24(:,91), 29, MT, 1_intkind1, wf24(:,92), n2(158))
  call vert_UV_W(ntry, wf12(:,4), 25, ex6(:), 32, wf24(:,93), n3(:,329), t3x24(:,:,60))
  call vert_QA_V(ntry, ex1(:), wf12(:,61), wf24(:,94), n3(:,330), t3x24(:,:,61))
  call vert_QA_Z(gZu,ntry, ex1(:), wf12(:,61), wf24(:,95), n3(:,331), t3x24(:,:,62))
  call vert_AW_Q(ntry, ex3(:), wf8(:,10), wf16(:,39), n3(:,332), t3x16(:,:,27))
  call prop_A_Q(ntry, wf16(:,39), 45, MB, 1_intkind1, wf16(:,40), n2(159))
  call vert_VV_S(ntry, ex5(:), wf8(:,10), wf24(:,96), n3(:,333), t3x24(:,:,63))
  call vert_UV_W(ntry, wf8(:,10), 41, ex5(:), 16, wf24(:,97), n3(:,334), t3x24(:,:,64))
  call vert_QA_V(ntry, wf12(:,28), ex4(:), wf24(:,98), n3(:,335), t3x24(:,:,65))
  call vert_QA_Z(gZd,ntry, wf12(:,28), ex4(:), wf24(:,99), n3(:,336), t3x24(:,:,66))
  call vert_VQ_A(ntry, wf8(:,15), ex1(:), wf16(:,41), n3(:,337), t3x16(:,:,28))
  call prop_Q_A(ntry, wf16(:,41), 39, ZERO, 0_intkind1, wf16(:,42), n2(160))
  call vert_ZQ_A(gZu,ntry, wf8(:,16), ex1(:), wf16(:,43), n3(:,338), t3x16(:,:,29))
  call prop_Q_A(ntry, wf16(:,43), 39, ZERO, 0_intkind1, wf16(:,44), n2(161))
  call vert_AV_Q(ntry, ex4(:), wf8(:,15), wf16(:,45), n3(:,339), t3x16(:,:,30))
  call prop_A_Q(ntry, wf16(:,45), 46, ZERO, 0_intkind1, wf16(:,46), n2(162))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf8(:,16), wf16(:,47), n3(:,340), t3x16(:,:,31))
  call prop_A_Q(ntry, wf16(:,47), 46, ZERO, 0_intkind1, wf16(:,48), n2(163))
  call vert_TV_S(ntry, wf8(:,14), 38, ex5(:), 16, wf24(:,100), n3(:,341), t3x24(:,:,67))
  call vert_TV_S(ntry, wf8(:,94), 38, ex5(:), 16, wf24(:,101), n3(:,342), t3x24(:,:,68))
  call vert_SV_V(ntry, wf8(:,14), ex5(:), wf24(:,102), n3(:,343), t3x24(:,:,69))
  call vert_VV_S(ntry, ex5(:), wf8(:,15), wf24(:,103), n3(:,344), t3x24(:,:,70))
  call vert_VV_S(ntry, ex5(:), wf8(:,16), wf24(:,104), n3(:,345), t3x24(:,:,71))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,15), 38, wf24(:,105), n3(:,346), t3x24(:,:,72))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,16), 38, wf24(:,106), n3(:,347), t3x24(:,:,73))
  call vert_AQ_S(gPtb,ntry, ex3(:), wf12(:,49), wf24(:,107), n3(:,348), t3x24(:,:,74))
  call vert_QA_W(ntry, wf12(:,49), ex3(:), wf24(:,108), n3(:,349), t3x24(:,:,75))
  call vert_VQ_A(ntry, wf8(:,18), ex1(:), wf16(:,49), n3(:,350), t3x16(:,:,32))
  call prop_Q_A(ntry, wf16(:,49), 39, ZERO, 0_intkind1, wf16(:,50), n2(164))
  call vert_ZQ_A(gZu,ntry, wf8(:,19), ex1(:), wf16(:,51), n3(:,351), t3x16(:,:,33))
  call prop_Q_A(ntry, wf16(:,51), 39, ZERO, 0_intkind1, wf16(:,52), n2(165))
  call vert_AV_Q(ntry, ex4(:), wf8(:,18), wf16(:,53), n3(:,352), t3x16(:,:,34))
  call prop_A_Q(ntry, wf16(:,53), 46, ZERO, 0_intkind1, wf16(:,54), n2(166))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf8(:,19), wf16(:,55), n3(:,353), t3x16(:,:,35))
  call prop_A_Q(ntry, wf16(:,55), 46, ZERO, 0_intkind1, wf16(:,56), n2(167))
  call vert_TV_S(ntry, wf8(:,17), 38, ex5(:), 16, wf24(:,109), n3(:,354), t3x24(:,:,76))
  call vert_TV_S(ntry, wf8(:,95), 38, ex5(:), 16, wf24(:,110), n3(:,355), t3x24(:,:,77))
  call vert_SV_V(ntry, wf8(:,17), ex5(:), wf24(:,111), n3(:,356), t3x24(:,:,78))
  call vert_VV_S(ntry, ex5(:), wf8(:,18), wf24(:,112), n3(:,357), t3x24(:,:,79))
  call vert_VV_S(ntry, ex5(:), wf8(:,19), wf24(:,113), n3(:,358), t3x24(:,:,80))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,18), 38, wf24(:,114), n3(:,359), t3x24(:,:,81))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,19), 38, wf24(:,115), n3(:,360), t3x24(:,:,82))
  call vert_AW_Q(ntry, ex3(:), wf8(:,11), wf16(:,57), n3(:,361), t3x16(:,:,36))
  call prop_A_Q(ntry, wf16(:,57), 45, MB, 1_intkind1, wf16(:,58), n2(168))
  call vert_VV_S(ntry, ex5(:), wf8(:,11), wf24(:,116), n3(:,362), t3x24(:,:,83))
  call vert_UV_W(ntry, wf8(:,11), 41, ex5(:), 16, wf24(:,117), n3(:,363), t3x24(:,:,84))
  call vert_QA_V(ntry, ex1(:), wf12(:,63), wf24(:,118), n3(:,364), t3x24(:,:,85))
  call vert_QA_Z(gZu,ntry, ex1(:), wf12(:,63), wf24(:,119), n3(:,365), t3x24(:,:,86))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 6 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 9
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 3
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,3), wf24(:,1), A(:,1), n3(:,366), t3x96(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,2), A(:,2), n3(:,367), t3x96(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,1), A(:,3), n3(:,368), t3x96(:,:,3), nhel, den(5))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,1), A(:,4), n3(:,369), t3x96(:,:,4), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,3), A(:,5), n3(:,370), t3x96(:,:,5), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,5), A(:,6), n3(:,371), t3x96(:,:,6), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,3), A(:,7), n3(:,372), t3x96(:,:,7), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,1), A(:,8), n3(:,373), t3x96(:,:,8), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,2), A(:,9), n3(:,374), t3x96(:,:,9), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,1), A(:,10), n3(:,375), t3x96(:,:,10), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,7), A(:,11), n3(:,376), t3x96(:,:,11), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,9), A(:,12), n3(:,377), t3x96(:,:,12), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,7), A(:,13), n3(:,378), t3x96(:,:,13), nhel, den(25))
    call Hcont_VV(nsync, wf8(:,1), wf12(:,4), A(:,14), n3(:,379), t3x96(:,:,14), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,5), A(:,15), n3(:,380), t3x96(:,:,15), nhel, den(33))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,6), A(:,16), n3(:,381), t3x96(:,:,16), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,7), A(:,17), n3(:,382), t3x96(:,:,17), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,8), A(:,18), n3(:,383), t3x96(:,:,18), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,8), A(:,19), n3(:,384), t3x96(:,:,19), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,8), A(:,20), n3(:,385), t3x96(:,:,20), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,9), A(:,21), n3(:,386), t3x96(:,:,21), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,9), A(:,22), n3(:,387), t3x96(:,:,22), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,9), A(:,23), n3(:,388), t3x96(:,:,23), nhel, den(38))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,11), A(:,24), n3(:,389), t3x96(:,:,24), nhel, den(41))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,11), A(:,25), n3(:,390), t3x96(:,:,25), nhel, den(42))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,11), A(:,26), n3(:,391), t3x96(:,:,26), nhel, den(43))
    call Hcont_QA(nsync, wf4(:,10), wf24(:,3), A(:,27), n3(:,392), t3x96(:,:,27), nhel, den(48))
    call Hcont_QA(nsync, wf12(:,10), wf8(:,13), A(:,28), n3(:,393), t3x96(:,:,28), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,11), A(:,29), n3(:,394), t3x96(:,:,29), nhel, den(53))
    call Hcont_SS(nsync, wf8(:,14), wf12(:,12), A(:,30), n3(:,395), t3x96(:,:,30), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,13), A(:,31), n3(:,396), t3x96(:,:,31), nhel, den(59))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,16), A(:,32), n3(:,397), t3x96(:,:,32), nhel, den(62))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,17), A(:,33), n3(:,398), t3x96(:,:,33), nhel, den(64))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,18), A(:,34), n3(:,399), t3x96(:,:,34), nhel, den(66))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,19), A(:,35), n3(:,400), t3x96(:,:,35), nhel, den(68))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,15), A(:,36), n3(:,401), t3x96(:,:,36), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,14), A(:,37), n3(:,402), t3x96(:,:,37), nhel, den(70))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,15), A(:,38), n3(:,403), t3x96(:,:,38), nhel, den(69))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,18), A(:,39), n3(:,404), t3x96(:,:,39), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,14), A(:,40), n3(:,405), t3x96(:,:,40), nhel, den(72))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,18), A(:,41), n3(:,406), t3x96(:,:,41), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,15), A(:,42), n3(:,407), t3x96(:,:,42), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,15), A(:,43), n3(:,408), t3x96(:,:,43), nhel, den(76))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,15), A(:,44), n3(:,409), t3x96(:,:,44), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,16), A(:,45), n3(:,410), t3x96(:,:,45), nhel, den(80))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,15), A(:,46), n3(:,411), t3x96(:,:,46), nhel, den(77))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,18), A(:,47), n3(:,412), t3x96(:,:,47), nhel, den(81))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,16), A(:,48), n3(:,413), t3x96(:,:,48), nhel, den(82))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,18), A(:,49), n3(:,414), t3x96(:,:,49), nhel, den(81))

    call Hcont_VV(nsync, wf4(:,1), wf24(:,4), A(:,50), n3(:,415), t3x96(:,:,50), nhel, den(83))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,20), A(:,51), n3(:,416), t3x96(:,:,51), nhel, den(86))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,21), A(:,52), n3(:,417), t3x96(:,:,52), nhel, den(88))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,5), A(:,53), n3(:,418), t3x96(:,:,53), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,6), A(:,54), n3(:,419), t3x96(:,:,54), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,7), A(:,55), n3(:,420), t3x96(:,:,55), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,8), A(:,56), n3(:,421), t3x96(:,:,56), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,9), A(:,57), n3(:,422), t3x96(:,:,57), nhel, den(5))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,22), A(:,58), n3(:,423), t3x96(:,:,58), nhel, den(89))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,23), A(:,59), n3(:,424), t3x96(:,:,59), nhel, den(90))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,21), A(:,60), n3(:,425), t3x96(:,:,60), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,17), A(:,61), n3(:,426), t3x96(:,:,61), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,18), A(:,62), n3(:,427), t3x96(:,:,62), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,17), A(:,63), n3(:,428), t3x96(:,:,63), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,18), A(:,64), n3(:,429), t3x96(:,:,64), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,18), A(:,65), n3(:,430), t3x96(:,:,65), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,3), A(:,66), n3(:,431), t3x96(:,:,66), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,4), A(:,67), n3(:,432), t3x96(:,:,67), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,5), A(:,68), n3(:,433), t3x96(:,:,68), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,6), A(:,69), n3(:,434), t3x96(:,:,69), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,7), A(:,70), n3(:,435), t3x96(:,:,70), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,19), A(:,71), n3(:,436), t3x96(:,:,71), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,20), A(:,72), n3(:,437), t3x96(:,:,72), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,19), A(:,73), n3(:,438), t3x96(:,:,73), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,20), A(:,74), n3(:,439), t3x96(:,:,74), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,20), A(:,75), n3(:,440), t3x96(:,:,75), nhel, den(25))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,22), A(:,76), n3(:,441), t3x96(:,:,76), nhel, den(93))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,21), A(:,77), n3(:,442), t3x96(:,:,77), nhel, den(94))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,23), A(:,78), n3(:,443), t3x96(:,:,78), nhel, den(95))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,21), A(:,79), n3(:,444), t3x96(:,:,79), nhel, den(33))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,22), A(:,80), n3(:,445), t3x96(:,:,80), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,23), A(:,81), n3(:,446), t3x96(:,:,81), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,24), A(:,82), n3(:,447), t3x96(:,:,82), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,24), A(:,83), n3(:,448), t3x96(:,:,83), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,24), A(:,84), n3(:,449), t3x96(:,:,84), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,24), A(:,85), n3(:,450), t3x96(:,:,85), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,24), A(:,86), n3(:,451), t3x96(:,:,86), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,25), A(:,87), n3(:,452), t3x96(:,:,87), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,25), A(:,88), n3(:,453), t3x96(:,:,88), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,25), A(:,89), n3(:,454), t3x96(:,:,89), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,25), A(:,90), n3(:,455), t3x96(:,:,90), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,25), A(:,91), n3(:,456), t3x96(:,:,91), nhel, den(38))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,21), A(:,92), n3(:,457), t3x96(:,:,92), nhel, den(41))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,22), A(:,93), n3(:,458), t3x96(:,:,93), nhel, den(42))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,23), A(:,94), n3(:,459), t3x96(:,:,94), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,24), wf12(:,26), A(:,95), n3(:,460), t3x96(:,:,95), nhel, den(98))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,25), A(:,96), n3(:,461), t3x96(:,:,96), nhel, den(98))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,26), A(:,97), n3(:,462), t3x96(:,:,97), nhel, den(99))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,27), A(:,98), n3(:,463), t3x96(:,:,98), nhel, den(99))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,28), A(:,99), n3(:,464), t3x96(:,:,99), nhel, den(98))
    call Hcont_VV(nsync, wf8(:,1), wf12(:,27), A(:,100), n3(:,465), t3x96(:,:,100), nhel, den(101))
    call Hcont_QA(nsync, wf24(:,1), wf4(:,14), A(:,101), n3(:,466), t3x96(:,:,101), nhel, den(5))
    call Hcont_QA(nsync, wf24(:,1), wf4(:,16), A(:,102), n3(:,467), t3x96(:,:,102), nhel, den(5))
    call Hcont_QA(nsync, wf24(:,2), wf4(:,14), A(:,103), n3(:,468), t3x96(:,:,103), nhel, den(8))
    call Hcont_QA(nsync, wf24(:,2), wf4(:,16), A(:,104), n3(:,469), t3x96(:,:,104), nhel, den(8))
    call Hcont_QA(nsync, wf24(:,1), wf4(:,16), A(:,105), n3(:,470), t3x96(:,:,105), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,24), wf12(:,28), A(:,106), n3(:,471), t3x96(:,:,106), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,25), wf12(:,28), A(:,107), n3(:,472), t3x96(:,:,107), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,26), wf12(:,28), A(:,108), n3(:,473), t3x96(:,:,108), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,27), wf12(:,28), A(:,109), n3(:,474), t3x96(:,:,109), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,28), wf12(:,28), A(:,110), n3(:,475), t3x96(:,:,110), nhel, den(103))
    call Hcont_SS(nsync, wf12(:,29), wf8(:,29), A(:,111), n3(:,476), t3x96(:,:,111), nhel, den(106))
    call Hcont_SS(nsync, wf8(:,29), wf12(:,30), A(:,112), n3(:,477), t3x96(:,:,112), nhel, den(108))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,30), A(:,113), n3(:,478), t3x96(:,:,113), nhel, den(106))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,30), A(:,114), n3(:,479), t3x96(:,:,114), nhel, den(106))
    call Hcont_SS(nsync, wf8(:,29), wf12(:,31), A(:,115), n3(:,480), t3x96(:,:,115), nhel, den(110))
    call Hcont_SS(nsync, wf8(:,29), wf12(:,32), A(:,116), n3(:,481), t3x96(:,:,116), nhel, den(108))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,30), A(:,117), n3(:,482), t3x96(:,:,117), nhel, den(110))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,30), A(:,118), n3(:,483), t3x96(:,:,118), nhel, den(110))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,30), A(:,119), n3(:,484), t3x96(:,:,119), nhel, den(108))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,30), A(:,120), n3(:,485), t3x96(:,:,120), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,33), A(:,121), n3(:,486), t3x96(:,:,121), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,34), A(:,122), n3(:,487), t3x96(:,:,122), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,33), A(:,123), n3(:,488), t3x96(:,:,123), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,34), A(:,124), n3(:,489), t3x96(:,:,124), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,34), A(:,125), n3(:,490), t3x96(:,:,125), nhel, den(38))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,31), A(:,126), n3(:,491), t3x96(:,:,126), nhel, den(41))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,32), A(:,127), n3(:,492), t3x96(:,:,127), nhel, den(41))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,31), A(:,128), n3(:,493), t3x96(:,:,128), nhel, den(42))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,32), A(:,129), n3(:,494), t3x96(:,:,129), nhel, den(42))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,31), A(:,130), n3(:,495), t3x96(:,:,130), nhel, den(43))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,32), A(:,131), n3(:,496), t3x96(:,:,131), nhel, den(43))
    call Hcont_QA(nsync, wf16(:,1), wf6(:,8), A(:,132), n3(:,497), t3x96(:,:,132), nhel, den(20))
    call Hcont_QA(nsync, wf16(:,1), wf6(:,8), A(:,133), n3(:,498), t3x96(:,:,133), nhel, den(20))
    call Hcont_QA(nsync, wf16(:,2), wf6(:,8), A(:,134), n3(:,499), t3x96(:,:,134), nhel, den(22))
    call Hcont_QA(nsync, wf16(:,2), wf6(:,8), A(:,135), n3(:,500), t3x96(:,:,135), nhel, den(22))
    call Hcont_QA(nsync, wf16(:,1), wf6(:,8), A(:,136), n3(:,501), t3x96(:,:,136), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,35), A(:,137), n3(:,502), t3x96(:,:,137), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,35), A(:,138), n3(:,503), t3x96(:,:,138), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,35), A(:,139), n3(:,504), t3x96(:,:,139), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,35), A(:,140), n3(:,505), t3x96(:,:,140), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,35), A(:,141), n3(:,506), t3x96(:,:,141), nhel, den(25))
    call Hcont_VV(nsync, wf8(:,1), wf12(:,36), A(:,142), n3(:,507), t3x96(:,:,142), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,10), wf24(:,10), A(:,143), n3(:,508), t3x96(:,:,143), nhel, den(48))
    call Hcont_QA(nsync, wf4(:,10), wf24(:,10), A(:,144), n3(:,509), t3x96(:,:,144), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,37), A(:,145), n3(:,510), t3x96(:,:,145), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,38), A(:,146), n3(:,511), t3x96(:,:,146), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,39), A(:,147), n3(:,512), t3x96(:,:,147), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,39), A(:,148), n3(:,513), t3x96(:,:,148), nhel, den(53))
    call Hcont_SS(nsync, wf8(:,14), wf12(:,40), A(:,149), n3(:,514), t3x96(:,:,149), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,41), A(:,150), n3(:,515), t3x96(:,:,150), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,41), A(:,151), n3(:,516), t3x96(:,:,151), nhel, den(62))
    call Hcont_SS(nsync, wf8(:,17), wf12(:,40), A(:,152), n3(:,517), t3x96(:,:,152), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,41), A(:,153), n3(:,518), t3x96(:,:,153), nhel, den(66))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,41), A(:,154), n3(:,519), t3x96(:,:,154), nhel, den(68))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,42), A(:,155), n3(:,520), t3x96(:,:,155), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,43), A(:,156), n3(:,521), t3x96(:,:,156), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,44), A(:,157), n3(:,522), t3x96(:,:,157), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,45), A(:,158), n3(:,523), t3x96(:,:,158), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,27), A(:,159), n3(:,524), t3x96(:,:,159), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,42), A(:,160), n3(:,525), t3x96(:,:,160), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,43), A(:,161), n3(:,526), t3x96(:,:,161), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,44), A(:,162), n3(:,527), t3x96(:,:,162), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,45), A(:,163), n3(:,528), t3x96(:,:,163), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,27), A(:,164), n3(:,529), t3x96(:,:,164), nhel, den(71))
    call Hcont_SS(nsync, wf8(:,29), wf12(:,46), A(:,165), n3(:,530), t3x96(:,:,165), nhel, den(75))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,30), A(:,166), n3(:,531), t3x96(:,:,166), nhel, den(75))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,30), A(:,167), n3(:,532), t3x96(:,:,167), nhel, den(75))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,31), A(:,168), n3(:,533), t3x96(:,:,168), nhel, den(76))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,32), A(:,169), n3(:,534), t3x96(:,:,169), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,36), A(:,170), n3(:,535), t3x96(:,:,170), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,36), A(:,171), n3(:,536), t3x96(:,:,171), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,47), A(:,172), n3(:,537), t3x96(:,:,172), nhel, den(80))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,47), A(:,173), n3(:,538), t3x96(:,:,173), nhel, den(80))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,36), A(:,174), n3(:,539), t3x96(:,:,174), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,36), A(:,175), n3(:,540), t3x96(:,:,175), nhel, den(81))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,36), A(:,176), n3(:,541), t3x96(:,:,176), nhel, den(81))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,47), A(:,177), n3(:,542), t3x96(:,:,177), nhel, den(82))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,47), A(:,178), n3(:,543), t3x96(:,:,178), nhel, den(82))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,36), A(:,179), n3(:,544), t3x96(:,:,179), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,33), wf12(:,48), A(:,180), n3(:,545), t3x96(:,:,180), nhel, den(113))
    call Hcont_QA(nsync, wf8(:,33), wf12(:,48), A(:,181), n3(:,546), t3x96(:,:,181), nhel, den(113))
    call Hcont_QA(nsync, wf24(:,3), wf4(:,19), A(:,182), n3(:,547), t3x96(:,:,182), nhel, den(48))
    call Hcont_QA(nsync, wf24(:,3), wf4(:,21), A(:,183), n3(:,548), t3x96(:,:,183), nhel, den(48))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,34), A(:,184), n3(:,549), t3x96(:,:,184), nhel, den(114))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,35), A(:,185), n3(:,550), t3x96(:,:,185), nhel, den(114))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,36), A(:,186), n3(:,551), t3x96(:,:,186), nhel, den(116))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,37), A(:,187), n3(:,552), t3x96(:,:,187), nhel, den(116))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,38), A(:,188), n3(:,553), t3x96(:,:,188), nhel, den(117))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,39), A(:,189), n3(:,554), t3x96(:,:,189), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,33), wf12(:,49), A(:,190), n3(:,555), t3x96(:,:,190), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,33), wf12(:,49), A(:,191), n3(:,556), t3x96(:,:,191), nhel, den(119))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,40), A(:,192), n3(:,557), t3x96(:,:,192), nhel, den(64))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,41), A(:,193), n3(:,558), t3x96(:,:,193), nhel, den(64))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,42), A(:,194), n3(:,559), t3x96(:,:,194), nhel, den(66))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,43), A(:,195), n3(:,560), t3x96(:,:,195), nhel, den(66))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,44), A(:,196), n3(:,561), t3x96(:,:,196), nhel, den(68))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,45), A(:,197), n3(:,562), t3x96(:,:,197), nhel, den(68))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,36), A(:,198), n3(:,563), t3x96(:,:,198), nhel, den(120))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,37), A(:,199), n3(:,564), t3x96(:,:,199), nhel, den(120))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,38), A(:,200), n3(:,565), t3x96(:,:,200), nhel, den(121))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,39), A(:,201), n3(:,566), t3x96(:,:,201), nhel, den(121))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,46), A(:,202), n3(:,567), t3x96(:,:,202), nhel, den(120))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,42), A(:,203), n3(:,568), t3x96(:,:,203), nhel, den(71))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,43), A(:,204), n3(:,569), t3x96(:,:,204), nhel, den(71))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,44), A(:,205), n3(:,570), t3x96(:,:,205), nhel, den(72))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,45), A(:,206), n3(:,571), t3x96(:,:,206), nhel, den(72))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,43), A(:,207), n3(:,572), t3x96(:,:,207), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,50), A(:,208), n3(:,573), t3x96(:,:,208), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,50), A(:,209), n3(:,574), t3x96(:,:,209), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,50), A(:,210), n3(:,575), t3x96(:,:,210), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,50), A(:,211), n3(:,576), t3x96(:,:,211), nhel, den(76))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,36), A(:,212), n3(:,577), t3x96(:,:,212), nhel, den(77))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,37), A(:,213), n3(:,578), t3x96(:,:,213), nhel, den(77))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,38), A(:,214), n3(:,579), t3x96(:,:,214), nhel, den(80))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,39), A(:,215), n3(:,580), t3x96(:,:,215), nhel, den(80))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,46), A(:,216), n3(:,581), t3x96(:,:,216), nhel, den(77))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,42), A(:,217), n3(:,582), t3x96(:,:,217), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,43), A(:,218), n3(:,583), t3x96(:,:,218), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,44), A(:,219), n3(:,584), t3x96(:,:,219), nhel, den(82))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,45), A(:,220), n3(:,585), t3x96(:,:,220), nhel, den(82))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,43), A(:,221), n3(:,586), t3x96(:,:,221), nhel, den(81))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,47), A(:,222), n3(:,587), t3x96(:,:,222), nhel, den(123))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,48), A(:,223), n3(:,588), t3x96(:,:,223), nhel, den(123))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,49), A(:,224), n3(:,589), t3x96(:,:,224), nhel, den(124))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,50), A(:,225), n3(:,590), t3x96(:,:,225), nhel, den(124))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,51), A(:,226), n3(:,591), t3x96(:,:,226), nhel, den(125))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,52), A(:,227), n3(:,592), t3x96(:,:,227), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,51), A(:,228), n3(:,593), t3x96(:,:,228), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,52), A(:,229), n3(:,594), t3x96(:,:,229), nhel, den(53))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,53), A(:,230), n3(:,595), t3x96(:,:,230), nhel, den(56))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,54), A(:,231), n3(:,596), t3x96(:,:,231), nhel, den(56))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,55), A(:,232), n3(:,597), t3x96(:,:,232), nhel, den(59))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,56), A(:,233), n3(:,598), t3x96(:,:,233), nhel, den(59))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,57), A(:,234), n3(:,599), t3x96(:,:,234), nhel, den(62))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,58), A(:,235), n3(:,600), t3x96(:,:,235), nhel, den(62))
    call Hcont_QA(nsync, wf4(:,10), wf24(:,11), A(:,236), n3(:,601), t3x96(:,:,236), nhel, den(48))
    call Hcont_QA(nsync, wf4(:,10), wf24(:,11), A(:,237), n3(:,602), t3x96(:,:,237), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,53), A(:,238), n3(:,603), t3x96(:,:,238), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,53), A(:,239), n3(:,604), t3x96(:,:,239), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,49), A(:,240), n3(:,605), t3x96(:,:,240), nhel, den(126))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,50), A(:,241), n3(:,606), t3x96(:,:,241), nhel, den(126))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,51), A(:,242), n3(:,607), t3x96(:,:,242), nhel, den(127))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,52), A(:,243), n3(:,608), t3x96(:,:,243), nhel, den(127))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,59), A(:,244), n3(:,609), t3x96(:,:,244), nhel, den(126))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,55), A(:,245), n3(:,610), t3x96(:,:,245), nhel, den(69))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,56), A(:,246), n3(:,611), t3x96(:,:,246), nhel, den(69))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,57), A(:,247), n3(:,612), t3x96(:,:,247), nhel, den(70))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,58), A(:,248), n3(:,613), t3x96(:,:,248), nhel, den(70))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,56), A(:,249), n3(:,614), t3x96(:,:,249), nhel, den(69))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,49), A(:,250), n3(:,615), t3x96(:,:,250), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,50), A(:,251), n3(:,616), t3x96(:,:,251), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,51), A(:,252), n3(:,617), t3x96(:,:,252), nhel, den(82))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,52), A(:,253), n3(:,618), t3x96(:,:,253), nhel, den(82))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,59), A(:,254), n3(:,619), t3x96(:,:,254), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,55), A(:,255), n3(:,620), t3x96(:,:,255), nhel, den(77))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,56), A(:,256), n3(:,621), t3x96(:,:,256), nhel, den(77))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,57), A(:,257), n3(:,622), t3x96(:,:,257), nhel, den(80))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,58), A(:,258), n3(:,623), t3x96(:,:,258), nhel, den(80))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,56), A(:,259), n3(:,624), t3x96(:,:,259), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,54), A(:,260), n3(:,625), t3x96(:,:,260), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,54), A(:,261), n3(:,626), t3x96(:,:,261), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,54), A(:,262), n3(:,627), t3x96(:,:,262), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,54), A(:,263), n3(:,628), t3x96(:,:,263), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,12), A(:,264), n3(:,629), t3x96(:,:,264), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,13), A(:,265), n3(:,630), t3x96(:,:,265), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,14), A(:,266), n3(:,631), t3x96(:,:,266), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,15), A(:,267), n3(:,632), t3x96(:,:,267), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,16), A(:,268), n3(:,633), t3x96(:,:,268), nhel, den(5))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,60), A(:,269), n3(:,634), t3x96(:,:,269), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,62), A(:,270), n3(:,635), t3x96(:,:,270), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,64), A(:,271), n3(:,636), t3x96(:,:,271), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,66), A(:,272), n3(:,637), t3x96(:,:,272), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,68), A(:,273), n3(:,638), t3x96(:,:,273), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,70), A(:,274), n3(:,639), t3x96(:,:,274), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,8), A(:,275), n3(:,640), t3x96(:,:,275), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,9), A(:,276), n3(:,641), t3x96(:,:,276), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,10), A(:,277), n3(:,642), t3x96(:,:,277), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,11), A(:,278), n3(:,643), t3x96(:,:,278), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,12), A(:,279), n3(:,644), t3x96(:,:,279), nhel, den(20))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,60), A(:,280), n3(:,645), t3x96(:,:,280), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,72), A(:,281), n3(:,646), t3x96(:,:,281), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,74), A(:,282), n3(:,647), t3x96(:,:,282), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,76), A(:,283), n3(:,648), t3x96(:,:,283), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,78), A(:,284), n3(:,649), t3x96(:,:,284), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,80), A(:,285), n3(:,650), t3x96(:,:,285), nhel, den(25))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,55), A(:,286), n3(:,651), t3x96(:,:,286), nhel, den(33))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,56), A(:,287), n3(:,652), t3x96(:,:,287), nhel, den(33))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,57), A(:,288), n3(:,653), t3x96(:,:,288), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,58), A(:,289), n3(:,654), t3x96(:,:,289), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,59), A(:,290), n3(:,655), t3x96(:,:,290), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,60), A(:,291), n3(:,656), t3x96(:,:,291), nhel, den(35))
    call Hcont_QA(nsync, wf12(:,8), wf8(:,62), A(:,292), n3(:,657), t3x96(:,:,292), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,8), wf8(:,64), A(:,293), n3(:,658), t3x96(:,:,293), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,8), wf8(:,66), A(:,294), n3(:,659), t3x96(:,:,294), nhel, den(37))
    call Hcont_QA(nsync, wf12(:,8), wf8(:,68), A(:,295), n3(:,660), t3x96(:,:,295), nhel, den(37))
    call Hcont_QA(nsync, wf12(:,8), wf8(:,70), A(:,296), n3(:,661), t3x96(:,:,296), nhel, den(36))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,55), A(:,297), n3(:,662), t3x96(:,:,297), nhel, den(41))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,56), A(:,298), n3(:,663), t3x96(:,:,298), nhel, den(41))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,57), A(:,299), n3(:,664), t3x96(:,:,299), nhel, den(42))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,58), A(:,300), n3(:,665), t3x96(:,:,300), nhel, den(42))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,59), A(:,301), n3(:,666), t3x96(:,:,301), nhel, den(43))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,60), A(:,302), n3(:,667), t3x96(:,:,302), nhel, den(43))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,72), A(:,303), n3(:,668), t3x96(:,:,303), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,74), A(:,304), n3(:,669), t3x96(:,:,304), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,76), A(:,305), n3(:,670), t3x96(:,:,305), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,78), A(:,306), n3(:,671), t3x96(:,:,306), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,80), A(:,307), n3(:,672), t3x96(:,:,307), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,81), wf12(:,61), A(:,308), n3(:,673), t3x96(:,:,308), nhel, den(130))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,82), A(:,309), n3(:,674), t3x96(:,:,309), nhel, den(130))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,83), A(:,310), n3(:,675), t3x96(:,:,310), nhel, den(131))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,84), A(:,311), n3(:,676), t3x96(:,:,311), nhel, den(131))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,85), A(:,312), n3(:,677), t3x96(:,:,312), nhel, den(130))
    call Hcont_VV(nsync, wf8(:,1), wf12(:,62), A(:,313), n3(:,678), t3x96(:,:,313), nhel, den(132))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,13), A(:,314), n3(:,679), t3x96(:,:,314), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,14), A(:,315), n3(:,680), t3x96(:,:,315), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,15), A(:,316), n3(:,681), t3x96(:,:,316), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,16), A(:,317), n3(:,682), t3x96(:,:,317), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,14), A(:,318), n3(:,683), t3x96(:,:,318), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,81), wf12(:,63), A(:,319), n3(:,684), t3x96(:,:,319), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,82), wf12(:,63), A(:,320), n3(:,685), t3x96(:,:,320), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,83), wf12(:,63), A(:,321), n3(:,686), t3x96(:,:,321), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,84), wf12(:,63), A(:,322), n3(:,687), t3x96(:,:,322), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,85), wf12(:,63), A(:,323), n3(:,688), t3x96(:,:,323), nhel, den(134))
    call Hcont_SS(nsync, wf12(:,29), wf8(:,86), A(:,324), n3(:,689), t3x96(:,:,324), nhel, den(136))
    call Hcont_SS(nsync, wf12(:,30), wf8(:,86), A(:,325), n3(:,690), t3x96(:,:,325), nhel, den(137))
    call Hcont_SS(nsync, wf12(:,31), wf8(:,86), A(:,326), n3(:,691), t3x96(:,:,326), nhel, den(138))
    call Hcont_SS(nsync, wf12(:,32), wf8(:,86), A(:,327), n3(:,692), t3x96(:,:,327), nhel, den(137))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,87), A(:,328), n3(:,693), t3x96(:,:,328), nhel, den(136))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,87), A(:,329), n3(:,694), t3x96(:,:,329), nhel, den(136))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,87), A(:,330), n3(:,695), t3x96(:,:,330), nhel, den(138))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,87), A(:,331), n3(:,696), t3x96(:,:,331), nhel, den(138))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,87), A(:,332), n3(:,697), t3x96(:,:,332), nhel, den(137))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,87), A(:,333), n3(:,698), t3x96(:,:,333), nhel, den(137))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,88), A(:,334), n3(:,699), t3x96(:,:,334), nhel, den(33))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,89), A(:,335), n3(:,700), t3x96(:,:,335), nhel, den(33))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,88), A(:,336), n3(:,701), t3x96(:,:,336), nhel, den(34))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,89), A(:,337), n3(:,702), t3x96(:,:,337), nhel, den(34))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,88), A(:,338), n3(:,703), t3x96(:,:,338), nhel, den(35))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,89), A(:,339), n3(:,704), t3x96(:,:,339), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,64), A(:,340), n3(:,705), t3x96(:,:,340), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,65), A(:,341), n3(:,706), t3x96(:,:,341), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,64), A(:,342), n3(:,707), t3x96(:,:,342), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,65), A(:,343), n3(:,708), t3x96(:,:,343), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,65), A(:,344), n3(:,709), t3x96(:,:,344), nhel, den(36))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,17), A(:,345), n3(:,710), t3x96(:,:,345), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,17), A(:,346), n3(:,711), t3x96(:,:,346), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,18), A(:,347), n3(:,712), t3x96(:,:,347), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,18), A(:,348), n3(:,713), t3x96(:,:,348), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,17), A(:,349), n3(:,714), t3x96(:,:,349), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,1), wf12(:,66), A(:,350), n3(:,715), t3x96(:,:,350), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,67), A(:,351), n3(:,716), t3x96(:,:,351), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,67), A(:,352), n3(:,717), t3x96(:,:,352), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,67), A(:,353), n3(:,718), t3x96(:,:,353), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,67), A(:,354), n3(:,719), t3x96(:,:,354), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,67), A(:,355), n3(:,720), t3x96(:,:,355), nhel, den(14))
    call Hcont_SS(nsync, wf12(:,46), wf8(:,86), A(:,356), n3(:,721), t3x96(:,:,356), nhel, den(139))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,87), A(:,357), n3(:,722), t3x96(:,:,357), nhel, den(139))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,87), A(:,358), n3(:,723), t3x96(:,:,358), nhel, den(139))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,88), A(:,359), n3(:,724), t3x96(:,:,359), nhel, den(75))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,89), A(:,360), n3(:,725), t3x96(:,:,360), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,68), A(:,361), n3(:,726), t3x96(:,:,361), nhel, den(140))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,69), A(:,362), n3(:,727), t3x96(:,:,362), nhel, den(140))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,70), A(:,363), n3(:,728), t3x96(:,:,363), nhel, den(141))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,71), A(:,364), n3(:,729), t3x96(:,:,364), nhel, den(141))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,62), A(:,365), n3(:,730), t3x96(:,:,365), nhel, den(140))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,68), A(:,366), n3(:,731), t3x96(:,:,366), nhel, den(142))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,69), A(:,367), n3(:,732), t3x96(:,:,367), nhel, den(142))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,70), A(:,368), n3(:,733), t3x96(:,:,368), nhel, den(143))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,71), A(:,369), n3(:,734), t3x96(:,:,369), nhel, den(143))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,62), A(:,370), n3(:,735), t3x96(:,:,370), nhel, den(142))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,66), A(:,371), n3(:,736), t3x96(:,:,371), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,66), A(:,372), n3(:,737), t3x96(:,:,372), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,72), A(:,373), n3(:,738), t3x96(:,:,373), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,72), A(:,374), n3(:,739), t3x96(:,:,374), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,66), A(:,375), n3(:,740), t3x96(:,:,375), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,66), A(:,376), n3(:,741), t3x96(:,:,376), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,66), A(:,377), n3(:,742), t3x96(:,:,377), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,72), A(:,378), n3(:,743), t3x96(:,:,378), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,72), A(:,379), n3(:,744), t3x96(:,:,379), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,66), A(:,380), n3(:,745), t3x96(:,:,380), nhel, den(71))
    call Hcont_QA(nsync, wf4(:,10), wf24(:,19), A(:,381), n3(:,746), t3x96(:,:,381), nhel, den(48))
    call Hcont_QA(nsync, wf4(:,10), wf24(:,20), A(:,382), n3(:,747), t3x96(:,:,382), nhel, den(48))
    call Hcont_QA(nsync, wf4(:,10), wf24(:,20), A(:,383), n3(:,748), t3x96(:,:,383), nhel, den(48))
    call Hcont_QA(nsync, wf12(:,10), wf8(:,91), A(:,384), n3(:,749), t3x96(:,:,384), nhel, den(51))
    call Hcont_QA(nsync, wf12(:,10), wf8(:,93), A(:,385), n3(:,750), t3x96(:,:,385), nhel, den(51))
    call Hcont_QA(nsync, wf12(:,10), wf8(:,93), A(:,386), n3(:,751), t3x96(:,:,386), nhel, den(51))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,91), A(:,387), n3(:,752), t3x96(:,:,387), nhel, den(53))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,93), A(:,388), n3(:,753), t3x96(:,:,388), nhel, den(53))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,93), A(:,389), n3(:,754), t3x96(:,:,389), nhel, den(53))
    call Hcont_SS(nsync, wf8(:,14), wf12(:,73), A(:,390), n3(:,755), t3x96(:,:,390), nhel, den(56))
    call Hcont_SS(nsync, wf12(:,73), wf8(:,94), A(:,391), n3(:,756), t3x96(:,:,391), nhel, den(62))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,74), A(:,392), n3(:,757), t3x96(:,:,392), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,74), A(:,393), n3(:,758), t3x96(:,:,393), nhel, den(62))
    call Hcont_SS(nsync, wf8(:,14), wf12(:,75), A(:,394), n3(:,759), t3x96(:,:,394), nhel, den(56))
    call Hcont_SS(nsync, wf8(:,14), wf12(:,75), A(:,395), n3(:,760), t3x96(:,:,395), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,76), A(:,396), n3(:,761), t3x96(:,:,396), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,76), A(:,397), n3(:,762), t3x96(:,:,397), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,76), A(:,398), n3(:,763), t3x96(:,:,398), nhel, den(62))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,76), A(:,399), n3(:,764), t3x96(:,:,399), nhel, den(62))
    call Hcont_SS(nsync, wf8(:,17), wf12(:,73), A(:,400), n3(:,765), t3x96(:,:,400), nhel, den(64))
    call Hcont_SS(nsync, wf12(:,73), wf8(:,95), A(:,401), n3(:,766), t3x96(:,:,401), nhel, den(68))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,74), A(:,402), n3(:,767), t3x96(:,:,402), nhel, den(66))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,74), A(:,403), n3(:,768), t3x96(:,:,403), nhel, den(68))
    call Hcont_SS(nsync, wf8(:,17), wf12(:,75), A(:,404), n3(:,769), t3x96(:,:,404), nhel, den(64))
    call Hcont_SS(nsync, wf8(:,17), wf12(:,75), A(:,405), n3(:,770), t3x96(:,:,405), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,76), A(:,406), n3(:,771), t3x96(:,:,406), nhel, den(66))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,76), A(:,407), n3(:,772), t3x96(:,:,407), nhel, den(66))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,76), A(:,408), n3(:,773), t3x96(:,:,408), nhel, den(68))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,76), A(:,409), n3(:,774), t3x96(:,:,409), nhel, den(68))
    call Hcont_QA(nsync, wf6(:,13), wf16(:,18), A(:,410), n3(:,775), t3x96(:,:,410), nhel, den(147))
    call Hcont_QA(nsync, wf16(:,18), wf6(:,14), A(:,411), n3(:,776), t3x96(:,:,411), nhel, den(147))
    call Hcont_QA(nsync, wf6(:,13), wf16(:,20), A(:,412), n3(:,777), t3x96(:,:,412), nhel, den(150))
    call Hcont_QA(nsync, wf6(:,14), wf16(:,20), A(:,413), n3(:,778), t3x96(:,:,413), nhel, den(150))
    call Hcont_QA(nsync, wf16(:,18), wf6(:,14), A(:,414), n3(:,779), t3x96(:,:,414), nhel, den(147))
    call Hcont_VV(nsync, wf24(:,21), wf4(:,39), A(:,415), n3(:,780), t3x96(:,:,415), nhel, den(154))
    call Hcont_VV(nsync, wf24(:,22), wf4(:,40), A(:,416), n3(:,781), t3x96(:,:,416), nhel, den(157))
    call Hcont_VV(nsync, wf24(:,21), wf4(:,41), A(:,417), n3(:,782), t3x96(:,:,417), nhel, den(158))
    call Hcont_VV(nsync, wf24(:,22), wf4(:,42), A(:,418), n3(:,783), t3x96(:,:,418), nhel, den(159))
    call Hcont_VV(nsync, wf24(:,21), wf4(:,43), A(:,419), n3(:,784), t3x96(:,:,419), nhel, den(154))
    call Hcont_VV(nsync, wf24(:,22), wf4(:,44), A(:,420), n3(:,785), t3x96(:,:,420), nhel, den(157))
    call Hcont_QA(nsync, wf4(:,45), wf24(:,23), A(:,421), n3(:,786), t3x96(:,:,421), nhel, den(162))
    call Hcont_QA(nsync, wf24(:,23), wf4(:,46), A(:,422), n3(:,787), t3x96(:,:,422), nhel, den(162))
    call Hcont_QA(nsync, wf4(:,45), wf24(:,24), A(:,423), n3(:,788), t3x96(:,:,423), nhel, den(164))
    call Hcont_QA(nsync, wf4(:,46), wf24(:,24), A(:,424), n3(:,789), t3x96(:,:,424), nhel, den(164))
    call Hcont_QA(nsync, wf24(:,23), wf4(:,46), A(:,425), n3(:,790), t3x96(:,:,425), nhel, den(162))
    call Hcont_VV(nsync, wf8(:,1), wf12(:,77), A(:,426), n3(:,791), t3x96(:,:,426), nhel, den(166))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,78), A(:,427), n3(:,792), t3x96(:,:,427), nhel, den(167))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,79), A(:,428), n3(:,793), t3x96(:,:,428), nhel, den(167))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,78), A(:,429), n3(:,794), t3x96(:,:,429), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,79), A(:,430), n3(:,795), t3x96(:,:,430), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,79), A(:,431), n3(:,796), t3x96(:,:,431), nhel, den(167))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,96), A(:,432), n3(:,797), t3x96(:,:,432), nhel, den(170))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,97), A(:,433), n3(:,798), t3x96(:,:,433), nhel, den(172))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,98), A(:,434), n3(:,799), t3x96(:,:,434), nhel, den(174))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,99), A(:,435), n3(:,800), t3x96(:,:,435), nhel, den(170))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,100), A(:,436), n3(:,801), t3x96(:,:,436), nhel, den(170))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,101), A(:,437), n3(:,802), t3x96(:,:,437), nhel, den(172))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,102), A(:,438), n3(:,803), t3x96(:,:,438), nhel, den(175))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,103), A(:,439), n3(:,804), t3x96(:,:,439), nhel, den(175))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,104), A(:,440), n3(:,805), t3x96(:,:,440), nhel, den(176))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,105), A(:,441), n3(:,806), t3x96(:,:,441), nhel, den(176))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,103), A(:,442), n3(:,807), t3x96(:,:,442), nhel, den(175))
    call Hcont_QA(nsync, wf4(:,47), wf24(:,26), A(:,443), n3(:,808), t3x96(:,:,443), nhel, den(180))
    call Hcont_QA(nsync, wf24(:,26), wf4(:,48), A(:,444), n3(:,809), t3x96(:,:,444), nhel, den(180))
    call Hcont_QA(nsync, wf4(:,47), wf24(:,28), A(:,445), n3(:,810), t3x96(:,:,445), nhel, den(183))
    call Hcont_QA(nsync, wf4(:,48), wf24(:,28), A(:,446), n3(:,811), t3x96(:,:,446), nhel, den(183))
    call Hcont_QA(nsync, wf24(:,26), wf4(:,48), A(:,447), n3(:,812), t3x96(:,:,447), nhel, den(180))
    call Hcont_VV(nsync, wf4(:,39), wf24(:,29), A(:,448), n3(:,813), t3x96(:,:,448), nhel, den(186))
    call Hcont_VV(nsync, wf4(:,40), wf24(:,30), A(:,449), n3(:,814), t3x96(:,:,449), nhel, den(188))
    call Hcont_VV(nsync, wf4(:,41), wf24(:,29), A(:,450), n3(:,815), t3x96(:,:,450), nhel, den(189))
    call Hcont_VV(nsync, wf4(:,42), wf24(:,30), A(:,451), n3(:,816), t3x96(:,:,451), nhel, den(190))
    call Hcont_VV(nsync, wf4(:,43), wf24(:,29), A(:,452), n3(:,817), t3x96(:,:,452), nhel, den(186))
    call Hcont_VV(nsync, wf4(:,44), wf24(:,30), A(:,453), n3(:,818), t3x96(:,:,453), nhel, den(188))
    call Hcont_QA(nsync, wf6(:,17), wf16(:,21), A(:,454), n3(:,819), t3x96(:,:,454), nhel, den(193))
    call Hcont_QA(nsync, wf16(:,21), wf6(:,18), A(:,455), n3(:,820), t3x96(:,:,455), nhel, den(193))
    call Hcont_QA(nsync, wf6(:,17), wf16(:,22), A(:,456), n3(:,821), t3x96(:,:,456), nhel, den(195))
    call Hcont_QA(nsync, wf6(:,18), wf16(:,22), A(:,457), n3(:,822), t3x96(:,:,457), nhel, den(195))
    call Hcont_QA(nsync, wf16(:,21), wf6(:,18), A(:,458), n3(:,823), t3x96(:,:,458), nhel, den(193))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,106), A(:,459), n3(:,824), t3x96(:,:,459), nhel, den(196))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,107), A(:,460), n3(:,825), t3x96(:,:,460), nhel, den(197))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,108), A(:,461), n3(:,826), t3x96(:,:,461), nhel, den(198))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,109), A(:,462), n3(:,827), t3x96(:,:,462), nhel, den(196))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,110), A(:,463), n3(:,828), t3x96(:,:,463), nhel, den(196))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,111), A(:,464), n3(:,829), t3x96(:,:,464), nhel, den(197))
    call Hcont_VV(nsync, wf8(:,1), wf12(:,80), A(:,465), n3(:,830), t3x96(:,:,465), nhel, den(200))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,112), A(:,466), n3(:,831), t3x96(:,:,466), nhel, den(201))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,113), A(:,467), n3(:,832), t3x96(:,:,467), nhel, den(201))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,114), A(:,468), n3(:,833), t3x96(:,:,468), nhel, den(202))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,115), A(:,469), n3(:,834), t3x96(:,:,469), nhel, den(202))
    call Hcont_QA(nsync, wf12(:,61), wf8(:,113), A(:,470), n3(:,835), t3x96(:,:,470), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,81), A(:,471), n3(:,836), t3x96(:,:,471), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,82), A(:,472), n3(:,837), t3x96(:,:,472), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,81), A(:,473), n3(:,838), t3x96(:,:,473), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,82), A(:,474), n3(:,839), t3x96(:,:,474), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,82), A(:,475), n3(:,840), t3x96(:,:,475), nhel, den(203))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,116), A(:,476), n3(:,841), t3x96(:,:,476), nhel, den(206))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,117), A(:,477), n3(:,842), t3x96(:,:,477), nhel, den(206))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,116), A(:,478), n3(:,843), t3x96(:,:,478), nhel, den(207))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,117), A(:,479), n3(:,844), t3x96(:,:,479), nhel, den(207))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,116), A(:,480), n3(:,845), t3x96(:,:,480), nhel, den(208))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,117), A(:,481), n3(:,846), t3x96(:,:,481), nhel, den(208))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,83), A(:,482), n3(:,847), t3x96(:,:,482), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,84), A(:,483), n3(:,848), t3x96(:,:,483), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,83), A(:,484), n3(:,849), t3x96(:,:,484), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,84), A(:,485), n3(:,850), t3x96(:,:,485), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,84), A(:,486), n3(:,851), t3x96(:,:,486), nhel, den(209))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,96), A(:,487), n3(:,852), t3x96(:,:,487), nhel, den(211))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,97), A(:,488), n3(:,853), t3x96(:,:,488), nhel, den(212))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,98), A(:,489), n3(:,854), t3x96(:,:,489), nhel, den(213))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,99), A(:,490), n3(:,855), t3x96(:,:,490), nhel, den(211))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,100), A(:,491), n3(:,856), t3x96(:,:,491), nhel, den(211))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,101), A(:,492), n3(:,857), t3x96(:,:,492), nhel, den(212))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,85), A(:,493), n3(:,858), t3x96(:,:,493), nhel, den(215))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,86), A(:,494), n3(:,859), t3x96(:,:,494), nhel, den(216))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,87), A(:,495), n3(:,860), t3x96(:,:,495), nhel, den(217))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,88), A(:,496), n3(:,861), t3x96(:,:,496), nhel, den(218))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,89), A(:,497), n3(:,862), t3x96(:,:,497), nhel, den(216))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,90), A(:,498), n3(:,863), t3x96(:,:,498), nhel, den(216))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,91), A(:,499), n3(:,864), t3x96(:,:,499), nhel, den(217))
    call Hcont_SS(nsync, wf12(:,29), wf8(:,118), A(:,500), n3(:,865), t3x96(:,:,500), nhel, den(219))
    call Hcont_SS(nsync, wf12(:,30), wf8(:,118), A(:,501), n3(:,866), t3x96(:,:,501), nhel, den(220))
    call Hcont_SS(nsync, wf12(:,31), wf8(:,118), A(:,502), n3(:,867), t3x96(:,:,502), nhel, den(221))
    call Hcont_SS(nsync, wf12(:,32), wf8(:,118), A(:,503), n3(:,868), t3x96(:,:,503), nhel, den(220))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,119), A(:,504), n3(:,869), t3x96(:,:,504), nhel, den(219))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,119), A(:,505), n3(:,870), t3x96(:,:,505), nhel, den(221))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,119), A(:,506), n3(:,871), t3x96(:,:,506), nhel, den(220))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,102), A(:,507), n3(:,872), t3x96(:,:,507), nhel, den(222))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,103), A(:,508), n3(:,873), t3x96(:,:,508), nhel, den(222))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,104), A(:,509), n3(:,874), t3x96(:,:,509), nhel, den(223))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,105), A(:,510), n3(:,875), t3x96(:,:,510), nhel, den(223))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,103), A(:,511), n3(:,876), t3x96(:,:,511), nhel, den(222))
    call Hcont_QA(nsync, wf12(:,63), wf8(:,106), A(:,512), n3(:,877), t3x96(:,:,512), nhel, den(224))
    call Hcont_QA(nsync, wf12(:,63), wf8(:,107), A(:,513), n3(:,878), t3x96(:,:,513), nhel, den(225))
    call Hcont_QA(nsync, wf12(:,63), wf8(:,108), A(:,514), n3(:,879), t3x96(:,:,514), nhel, den(226))
    call Hcont_QA(nsync, wf12(:,63), wf8(:,109), A(:,515), n3(:,880), t3x96(:,:,515), nhel, den(224))
    call Hcont_QA(nsync, wf12(:,63), wf8(:,110), A(:,516), n3(:,881), t3x96(:,:,516), nhel, den(224))
    call Hcont_QA(nsync, wf12(:,63), wf8(:,111), A(:,517), n3(:,882), t3x96(:,:,517), nhel, den(225))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,120), A(:,518), n3(:,883), t3x96(:,:,518), nhel, den(228))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,121), A(:,519), n3(:,884), t3x96(:,:,519), nhel, den(228))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,120), A(:,520), n3(:,885), t3x96(:,:,520), nhel, den(229))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,121), A(:,521), n3(:,886), t3x96(:,:,521), nhel, den(229))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,120), A(:,522), n3(:,887), t3x96(:,:,522), nhel, den(230))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,121), A(:,523), n3(:,888), t3x96(:,:,523), nhel, den(230))
    call Hcont_QA(nsync, wf12(:,63), wf8(:,112), A(:,524), n3(:,889), t3x96(:,:,524), nhel, den(231))
    call Hcont_QA(nsync, wf12(:,63), wf8(:,113), A(:,525), n3(:,890), t3x96(:,:,525), nhel, den(231))
    call Hcont_QA(nsync, wf12(:,63), wf8(:,114), A(:,526), n3(:,891), t3x96(:,:,526), nhel, den(232))
    call Hcont_QA(nsync, wf12(:,63), wf8(:,115), A(:,527), n3(:,892), t3x96(:,:,527), nhel, den(232))
    call Hcont_QA(nsync, wf12(:,63), wf8(:,113), A(:,528), n3(:,893), t3x96(:,:,528), nhel, den(231))
    call Hcont_SS(nsync, wf12(:,29), wf8(:,122), A(:,529), n3(:,894), t3x96(:,:,529), nhel, den(233))
    call Hcont_SS(nsync, wf12(:,30), wf8(:,122), A(:,530), n3(:,895), t3x96(:,:,530), nhel, den(234))
    call Hcont_SS(nsync, wf12(:,31), wf8(:,122), A(:,531), n3(:,896), t3x96(:,:,531), nhel, den(235))
    call Hcont_SS(nsync, wf12(:,32), wf8(:,122), A(:,532), n3(:,897), t3x96(:,:,532), nhel, den(234))
    call Hcont_VV(nsync, wf12(:,5), wf8(:,123), A(:,533), n3(:,898), t3x96(:,:,533), nhel, den(233))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,123), A(:,534), n3(:,899), t3x96(:,:,534), nhel, den(235))
    call Hcont_VV(nsync, wf12(:,7), wf8(:,123), A(:,535), n3(:,900), t3x96(:,:,535), nhel, den(234))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,85), A(:,536), n3(:,901), t3x96(:,:,536), nhel, den(236))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,86), A(:,537), n3(:,902), t3x96(:,:,537), nhel, den(237))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,87), A(:,538), n3(:,903), t3x96(:,:,538), nhel, den(238))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,88), A(:,539), n3(:,904), t3x96(:,:,539), nhel, den(239))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,89), A(:,540), n3(:,905), t3x96(:,:,540), nhel, den(237))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,90), A(:,541), n3(:,906), t3x96(:,:,541), nhel, den(237))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,91), A(:,542), n3(:,907), t3x96(:,:,542), nhel, den(238))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,92), A(:,543), n3(:,908), t3x96(:,:,543), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,93), A(:,544), n3(:,909), t3x96(:,:,544), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,92), A(:,545), n3(:,910), t3x96(:,:,545), nhel, den(241))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,93), A(:,546), n3(:,911), t3x96(:,:,546), nhel, den(241))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,93), A(:,547), n3(:,912), t3x96(:,:,547), nhel, den(240))
    call Hcont_SS(nsync, wf24(:,31), wf4(:,54), A(:,548), n3(:,913), t3x96(:,:,548), nhel, den(245))
    call Hcont_VV(nsync, wf24(:,32), wf4(:,55), A(:,549), n3(:,914), t3x96(:,:,549), nhel, den(245))
    call Hcont_QA(nsync, wf6(:,21), wf16(:,24), A(:,550), n3(:,915), t3x96(:,:,550), nhel, den(249))
    call Hcont_QA(nsync, wf16(:,24), wf6(:,22), A(:,551), n3(:,916), t3x96(:,:,551), nhel, den(249))
    call Hcont_QA(nsync, wf4(:,56), wf24(:,33), A(:,552), n3(:,917), t3x96(:,:,552), nhel, den(252))
    call Hcont_QA(nsync, wf24(:,33), wf4(:,57), A(:,553), n3(:,918), t3x96(:,:,553), nhel, den(252))
    call Hcont_QA(nsync, wf12(:,48), wf8(:,124), A(:,554), n3(:,919), t3x96(:,:,554), nhel, den(254))
    call Hcont_QA(nsync, wf12(:,48), wf8(:,125), A(:,555), n3(:,920), t3x96(:,:,555), nhel, den(254))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,94), A(:,556), n3(:,921), t3x96(:,:,556), nhel, den(256))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,95), A(:,557), n3(:,922), t3x96(:,:,557), nhel, den(256))
    call Hcont_QA(nsync, wf12(:,48), wf8(:,126), A(:,558), n3(:,923), t3x96(:,:,558), nhel, den(257))
    call Hcont_QA(nsync, wf12(:,48), wf8(:,127), A(:,559), n3(:,924), t3x96(:,:,559), nhel, den(257))
    call Hcont_QA(nsync, wf12(:,49), wf8(:,124), A(:,560), n3(:,925), t3x96(:,:,560), nhel, den(258))
    call Hcont_QA(nsync, wf12(:,49), wf8(:,125), A(:,561), n3(:,926), t3x96(:,:,561), nhel, den(258))
    call Hcont_SS(nsync, wf8(:,14), wf12(:,96), A(:,562), n3(:,927), t3x96(:,:,562), nhel, den(259))
    call Hcont_SS(nsync, wf8(:,94), wf12(:,96), A(:,563), n3(:,928), t3x96(:,:,563), nhel, den(260))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,97), A(:,564), n3(:,929), t3x96(:,:,564), nhel, den(261))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,97), A(:,565), n3(:,930), t3x96(:,:,565), nhel, den(260))
    call Hcont_SS(nsync, wf8(:,14), wf12(:,98), A(:,566), n3(:,931), t3x96(:,:,566), nhel, den(259))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,99), A(:,567), n3(:,932), t3x96(:,:,567), nhel, den(261))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,99), A(:,568), n3(:,933), t3x96(:,:,568), nhel, den(260))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,128), A(:,569), n3(:,934), t3x96(:,:,569), nhel, den(263))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,129), A(:,570), n3(:,935), t3x96(:,:,570), nhel, den(263))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,130), A(:,571), n3(:,936), t3x96(:,:,571), nhel, den(264))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,131), A(:,572), n3(:,937), t3x96(:,:,572), nhel, den(264))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,132), A(:,573), n3(:,938), t3x96(:,:,573), nhel, den(265))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,133), A(:,574), n3(:,939), t3x96(:,:,574), nhel, den(265))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,100), A(:,575), n3(:,940), t3x96(:,:,575), nhel, den(266))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,101), A(:,576), n3(:,941), t3x96(:,:,576), nhel, den(266))
    call Hcont_QA(nsync, wf12(:,49), wf8(:,126), A(:,577), n3(:,942), t3x96(:,:,577), nhel, den(267))
    call Hcont_QA(nsync, wf12(:,49), wf8(:,127), A(:,578), n3(:,943), t3x96(:,:,578), nhel, den(267))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,134), A(:,579), n3(:,944), t3x96(:,:,579), nhel, den(268))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,135), A(:,580), n3(:,945), t3x96(:,:,580), nhel, den(269))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,136), A(:,581), n3(:,946), t3x96(:,:,581), nhel, den(270))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,137), A(:,582), n3(:,947), t3x96(:,:,582), nhel, den(271))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,138), A(:,583), n3(:,948), t3x96(:,:,583), nhel, den(272))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,139), A(:,584), n3(:,949), t3x96(:,:,584), nhel, den(269))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,140), A(:,585), n3(:,950), t3x96(:,:,585), nhel, den(270))
    call Hcont_SS(nsync, wf8(:,17), wf12(:,96), A(:,586), n3(:,951), t3x96(:,:,586), nhel, den(273))
    call Hcont_SS(nsync, wf8(:,95), wf12(:,96), A(:,587), n3(:,952), t3x96(:,:,587), nhel, den(274))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,97), A(:,588), n3(:,953), t3x96(:,:,588), nhel, den(275))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,97), A(:,589), n3(:,954), t3x96(:,:,589), nhel, den(274))
    call Hcont_SS(nsync, wf8(:,17), wf12(:,98), A(:,590), n3(:,955), t3x96(:,:,590), nhel, den(273))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,99), A(:,591), n3(:,956), t3x96(:,:,591), nhel, den(275))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,99), A(:,592), n3(:,957), t3x96(:,:,592), nhel, den(274))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,141), A(:,593), n3(:,958), t3x96(:,:,593), nhel, den(277))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,142), A(:,594), n3(:,959), t3x96(:,:,594), nhel, den(277))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,143), A(:,595), n3(:,960), t3x96(:,:,595), nhel, den(278))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,144), A(:,596), n3(:,961), t3x96(:,:,596), nhel, den(278))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,145), A(:,597), n3(:,962), t3x96(:,:,597), nhel, den(279))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,146), A(:,598), n3(:,963), t3x96(:,:,598), nhel, den(279))
    call Hcont_SS(nsync, wf12(:,12), wf8(:,147), A(:,599), n3(:,964), t3x96(:,:,599), nhel, den(280))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,148), A(:,600), n3(:,965), t3x96(:,:,600), nhel, den(281))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,149), A(:,601), n3(:,966), t3x96(:,:,601), nhel, den(282))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,150), A(:,602), n3(:,967), t3x96(:,:,602), nhel, den(283))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,151), A(:,603), n3(:,968), t3x96(:,:,603), nhel, den(284))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,152), A(:,604), n3(:,969), t3x96(:,:,604), nhel, den(281))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,153), A(:,605), n3(:,970), t3x96(:,:,605), nhel, den(282))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,102), A(:,606), n3(:,971), t3x96(:,:,606), nhel, den(285))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,77), A(:,607), n3(:,972), t3x96(:,:,607), nhel, den(285))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,103), A(:,608), n3(:,973), t3x96(:,:,608), nhel, den(286))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,104), A(:,609), n3(:,974), t3x96(:,:,609), nhel, den(286))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,77), A(:,610), n3(:,975), t3x96(:,:,610), nhel, den(285))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,130), A(:,611), n3(:,976), t3x96(:,:,611), nhel, den(287))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,131), A(:,612), n3(:,977), t3x96(:,:,612), nhel, den(287))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,132), A(:,613), n3(:,978), t3x96(:,:,613), nhel, den(288))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,133), A(:,614), n3(:,979), t3x96(:,:,614), nhel, den(288))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,131), A(:,615), n3(:,980), t3x96(:,:,615), nhel, den(287))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,135), A(:,616), n3(:,981), t3x96(:,:,616), nhel, den(289))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,136), A(:,617), n3(:,982), t3x96(:,:,617), nhel, den(290))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,137), A(:,618), n3(:,983), t3x96(:,:,618), nhel, den(291))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,138), A(:,619), n3(:,984), t3x96(:,:,619), nhel, den(292))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,139), A(:,620), n3(:,985), t3x96(:,:,620), nhel, den(289))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,140), A(:,621), n3(:,986), t3x96(:,:,621), nhel, den(290))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,102), A(:,622), n3(:,987), t3x96(:,:,622), nhel, den(293))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,77), A(:,623), n3(:,988), t3x96(:,:,623), nhel, den(293))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,103), A(:,624), n3(:,989), t3x96(:,:,624), nhel, den(294))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,104), A(:,625), n3(:,990), t3x96(:,:,625), nhel, den(294))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,77), A(:,626), n3(:,991), t3x96(:,:,626), nhel, den(293))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,143), A(:,627), n3(:,992), t3x96(:,:,627), nhel, den(295))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,144), A(:,628), n3(:,993), t3x96(:,:,628), nhel, den(295))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,145), A(:,629), n3(:,994), t3x96(:,:,629), nhel, den(296))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,146), A(:,630), n3(:,995), t3x96(:,:,630), nhel, den(296))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,144), A(:,631), n3(:,996), t3x96(:,:,631), nhel, den(295))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,148), A(:,632), n3(:,997), t3x96(:,:,632), nhel, den(297))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,149), A(:,633), n3(:,998), t3x96(:,:,633), nhel, den(298))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,150), A(:,634), n3(:,999), t3x96(:,:,634), nhel, den(299))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,151), A(:,635), n3(:,1000), t3x96(:,:,635), nhel, den(300))
    call Hcont_VV(nsync, wf12(:,1), wf8(:,152), A(:,636), n3(:,1001), t3x96(:,:,636), nhel, den(297))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,153), A(:,637), n3(:,1002), t3x96(:,:,637), nhel, den(298))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,116), A(:,638), n3(:,1003), t3x96(:,:,638), nhel, den(301))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,117), A(:,639), n3(:,1004), t3x96(:,:,639), nhel, den(301))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,105), A(:,640), n3(:,1005), t3x96(:,:,640), nhel, den(302))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,106), A(:,641), n3(:,1006), t3x96(:,:,641), nhel, den(302))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,107), A(:,642), n3(:,1007), t3x96(:,:,642), nhel, den(303))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,108), A(:,643), n3(:,1008), t3x96(:,:,643), nhel, den(303))
    call Hcont_SS(nsync, wf12(:,46), wf8(:,122), A(:,644), n3(:,1009), t3x96(:,:,644), nhel, den(304))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,123), A(:,645), n3(:,1010), t3x96(:,:,645), nhel, den(304))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,120), A(:,646), n3(:,1011), t3x96(:,:,646), nhel, den(305))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,121), A(:,647), n3(:,1012), t3x96(:,:,647), nhel, den(305))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,105), A(:,648), n3(:,1013), t3x96(:,:,648), nhel, den(306))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,106), A(:,649), n3(:,1014), t3x96(:,:,649), nhel, den(306))
    call Hcont_SS(nsync, wf8(:,94), wf12(:,109), A(:,650), n3(:,1015), t3x96(:,:,650), nhel, den(307))
    call Hcont_SS(nsync, wf8(:,94), wf12(:,110), A(:,651), n3(:,1016), t3x96(:,:,651), nhel, den(308))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,111), A(:,652), n3(:,1017), t3x96(:,:,652), nhel, den(309))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,112), A(:,653), n3(:,1018), t3x96(:,:,653), nhel, den(307))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,113), A(:,654), n3(:,1019), t3x96(:,:,654), nhel, den(310))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,114), A(:,655), n3(:,1020), t3x96(:,:,655), nhel, den(308))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,115), A(:,656), n3(:,1021), t3x96(:,:,656), nhel, den(311))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,80), A(:,657), n3(:,1022), t3x96(:,:,657), nhel, den(311))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,116), A(:,658), n3(:,1023), t3x96(:,:,658), nhel, den(312))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,117), A(:,659), n3(:,1024), t3x96(:,:,659), nhel, den(312))
    call Hcont_VV(nsync, wf8(:,15), wf12(:,80), A(:,660), n3(:,1025), t3x96(:,:,660), nhel, den(311))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,130), A(:,661), n3(:,1026), t3x96(:,:,661), nhel, den(313))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,131), A(:,662), n3(:,1027), t3x96(:,:,662), nhel, den(313))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,132), A(:,663), n3(:,1028), t3x96(:,:,663), nhel, den(314))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,133), A(:,664), n3(:,1029), t3x96(:,:,664), nhel, den(314))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,131), A(:,665), n3(:,1030), t3x96(:,:,665), nhel, den(313))
    call Hcont_SS(nsync, wf8(:,95), wf12(:,109), A(:,666), n3(:,1031), t3x96(:,:,666), nhel, den(315))
    call Hcont_SS(nsync, wf8(:,95), wf12(:,110), A(:,667), n3(:,1032), t3x96(:,:,667), nhel, den(316))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,111), A(:,668), n3(:,1033), t3x96(:,:,668), nhel, den(317))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,112), A(:,669), n3(:,1034), t3x96(:,:,669), nhel, den(315))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,113), A(:,670), n3(:,1035), t3x96(:,:,670), nhel, den(318))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,114), A(:,671), n3(:,1036), t3x96(:,:,671), nhel, den(316))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,115), A(:,672), n3(:,1037), t3x96(:,:,672), nhel, den(319))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,80), A(:,673), n3(:,1038), t3x96(:,:,673), nhel, den(319))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,116), A(:,674), n3(:,1039), t3x96(:,:,674), nhel, den(320))
    call Hcont_VV(nsync, wf8(:,19), wf12(:,117), A(:,675), n3(:,1040), t3x96(:,:,675), nhel, den(320))
    call Hcont_VV(nsync, wf8(:,18), wf12(:,80), A(:,676), n3(:,1041), t3x96(:,:,676), nhel, den(319))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,143), A(:,677), n3(:,1042), t3x96(:,:,677), nhel, den(321))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,144), A(:,678), n3(:,1043), t3x96(:,:,678), nhel, den(321))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,145), A(:,679), n3(:,1044), t3x96(:,:,679), nhel, den(322))
    call Hcont_VV(nsync, wf12(:,16), wf8(:,146), A(:,680), n3(:,1045), t3x96(:,:,680), nhel, den(322))
    call Hcont_VV(nsync, wf12(:,4), wf8(:,144), A(:,681), n3(:,1046), t3x96(:,:,681), nhel, den(321))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(6), M2(6) ! M1helarray(6,nhel)
  integer :: empty(0), i

  M1(1)%j = ((-A(j,7)%j-A(j,10)%j-A(j,20)%j-A(j,41)%j-A(j,49)%j)*f(59))/2._/**/REALKIND+(CI*(-A(j,4)%j &
       -A(j,14)%j)*f(60))/2._/**/REALKIND
  M1(2)%j = (A(j,30)%j+A(j,33)%j)*f(3)+(-A(j,27)%j-A(j,28)%j-A(j,29)%j)*f(14)+(-A(j,32)%j-A(j,35)%j)*f(27)+(A(j,36)%j &
       +A(j,39)%j)*f(44)+(-A(j,44)%j-A(j,47)%j)*f(45)+(-A(j,31)%j-A(j,34)%j)*f(46)+(-A(j,37)%j-A(j,40)%j-A(j,45)%j &
       -A(j,48)%j)*f(47)
  M1(3)%j = ((A(j,38)%j+A(j,41)%j+A(j,46)%j+A(j,49)%j)*f(59))/6._/**/REALKIND
  M1(4)%j = ((A(j,3)%j+A(j,7)%j+A(j,10)%j+A(j,13)%j+A(j,20)%j+A(j,23)%j)*f(59))/6._/**/REALKIND
  M1(5)%j = (A(j,15)%j+A(j,24)%j)*f(3)+(-A(j,42)%j-A(j,43)%j)*f(14)+(-A(j,17)%j-A(j,26)%j)*f(27)+(A(j,1)%j+A(j,5)%j &
       +A(j,18)%j)*f(44)+(-A(j,8)%j-A(j,11)%j-A(j,21)%j)*f(45)+(-A(j,16)%j-A(j,25)%j)*f(46)+(-A(j,2)%j-A(j,6)%j-A(j,9)%j-A(j,12)%j &
       -A(j,19)%j-A(j,22)%j)*f(47)
  M1(6)%j = ((-A(j,3)%j-A(j,13)%j-A(j,23)%j-A(j,38)%j-A(j,46)%j)*f(59))/2._/**/REALKIND+(CI*(A(j,4)%j &
       +A(j,14)%j)*f(60))/2._/**/REALKIND

  M2(1)%j = ((-A(j,65)%j-A(j,70)%j-A(j,99)%j-A(j,110)%j-A(j,164)%j-A(j,207)%j-A(j,221)%j-A(j,244)%j-A(j,254)%j-A(j,274)%j &
       -A(j,279)%j-A(j,296)%j-A(j,318)%j-A(j,344)%j-A(j,370)%j+A(j,431)%j+A(j,442)%j+A(j,447)%j+A(j,458)%j+A(j,486)%j+A(j,511)%j &
       +A(j,626)%j+A(j,631)%j+A(j,676)%j+A(j,681)%j)*f(64))/2._/**/REALKIND+(CI*(-A(j,100)%j-A(j,269)%j-A(j,280)%j-A(j,313)%j &
       +A(j,426)%j+A(j,465)%j)*f(65))/2._/**/REALKIND+((-A(j,86)%j-A(j,136)%j-A(j,179)%j-A(j,355)%j &
       -A(j,380)%j)*f(85))/2._/**/REALKIND+(CI*(-A(j,142)%j-A(j,350)%j)*f(86))/2._/**/REALKIND
  M2(2)%j = (A(j,565)%j+A(j,589)%j)*f(2)+(A(j,193)%j+A(j,231)%j-A(j,566)%j-A(j,570)%j-A(j,579)%j-A(j,590)%j-A(j,594)%j &
       -A(j,599)%j)*f(4)+(A(j,395)%j+A(j,405)%j)*f(5)+(-A(j,562)%j-A(j,563)%j-A(j,586)%j-A(j,587)%j)*f(12)+(A(j,581)%j &
       +A(j,601)%j)*f(13)+(-A(j,146)%j-A(j,183)%j-A(j,229)%j+A(j,549)%j+A(j,551)%j+A(j,553)%j+A(j,555)%j+A(j,557)%j+A(j,559)%j &
       +A(j,561)%j+A(j,576)%j+A(j,578)%j)*f(15)+(-A(j,148)%j-A(j,237)%j-A(j,239)%j)*f(16)+(-A(j,383)%j-A(j,386)%j &
       -A(j,389)%j)*f(17)+(-A(j,144)%j-A(j,181)%j-A(j,191)%j)*f(18)+(A(j,548)%j+A(j,554)%j+A(j,560)%j)*f(26)+(-A(j,583)%j &
       -A(j,603)%j)*f(28)+(-A(j,189)%j-A(j,197)%j-A(j,227)%j-A(j,235)%j+A(j,568)%j+A(j,574)%j+A(j,585)%j+A(j,592)%j+A(j,598)%j &
       +A(j,605)%j)*f(29)+(-A(j,399)%j-A(j,409)%j)*f(30)+(-A(j,185)%j-A(j,223)%j)*f(37)+(A(j,616)%j+A(j,632)%j)*f(38)+(-A(j,650)%j &
       -A(j,666)%j)*f(39)+(-A(j,580)%j-A(j,600)%j+A(j,617)%j+A(j,633)%j+A(j,651)%j+A(j,667)%j)*f(40)+(A(j,149)%j+A(j,152)%j)*f(41) &
       +(A(j,204)%j+A(j,246)%j-A(j,607)%j-A(j,612)%j-A(j,618)%j-A(j,623)%j-A(j,628)%j-A(j,634)%j)*f(48)+(-A(j,199)%j-A(j,241)%j &
       +A(j,620)%j+A(j,636)%j)*f(49)+(-A(j,218)%j-A(j,256)%j+A(j,652)%j+A(j,657)%j+A(j,662)%j+A(j,668)%j+A(j,673)%j &
       +A(j,678)%j)*f(50)+(A(j,156)%j+A(j,161)%j-A(j,195)%j+A(j,213)%j-A(j,233)%j+A(j,251)%j+A(j,362)%j+A(j,367)%j+A(j,567)%j &
       +A(j,572)%j+A(j,582)%j+A(j,591)%j+A(j,596)%j+A(j,602)%j-A(j,619)%j-A(j,635)%j-A(j,653)%j-A(j,654)%j-A(j,669)%j &
       -A(j,670)%j)*f(51)+(-A(j,158)%j-A(j,163)%j+A(j,187)%j-A(j,201)%j-A(j,206)%j-A(j,215)%j-A(j,220)%j+A(j,225)%j-A(j,243)%j &
       -A(j,248)%j-A(j,253)%j-A(j,258)%j-A(j,364)%j-A(j,369)%j-A(j,584)%j-A(j,604)%j+A(j,609)%j+A(j,614)%j+A(j,621)%j+A(j,625)%j &
       +A(j,630)%j+A(j,637)%j+A(j,655)%j+A(j,659)%j+A(j,664)%j+A(j,671)%j+A(j,675)%j+A(j,680)%j)*f(52)+(-A(j,150)%j &
       -A(j,153)%j)*f(53)+(A(j,372)%j+A(j,377)%j)*f(54)+(-A(j,171)%j-A(j,176)%j)*f(55)+(-A(j,397)%j-A(j,407)%j)*f(56)+(-A(j,173)%j &
       -A(j,178)%j-A(j,374)%j-A(j,379)%j)*f(57)+(A(j,151)%j+A(j,154)%j)*f(58)+(-A(j,564)%j-A(j,588)%j)*f(87)
  M2(3)%j = (-A(j,393)%j-A(j,403)%j)*f(1)+(-A(j,569)%j-A(j,593)%j)*f(6)+(A(j,192)%j+A(j,230)%j)*f(8)+(A(j,184)%j+A(j,222)%j)*f(9) &
       +(A(j,394)%j+A(j,404)%j)*f(10)+(A(j,390)%j+A(j,391)%j+A(j,400)%j+A(j,401)%j)*f(11)+(A(j,550)%j+A(j,552)%j+A(j,556)%j &
       +A(j,558)%j+A(j,575)%j+A(j,577)%j)*f(19)-A(j,145)%j*f(20)+(-A(j,182)%j-A(j,228)%j)*f(22)+(-A(j,143)%j-A(j,147)%j-A(j,180)%j &
       -A(j,190)%j-A(j,236)%j-A(j,238)%j)*f(23)+(-A(j,382)%j-A(j,385)%j-A(j,388)%j)*f(24)+(-A(j,381)%j-A(j,384)%j &
       -A(j,387)%j)*f(25)+(A(j,573)%j+A(j,597)%j)*f(31)+(-A(j,196)%j-A(j,234)%j)*f(33)+(-A(j,398)%j-A(j,408)%j)*f(34)+(-A(j,188)%j &
       -A(j,226)%j)*f(35)+A(j,52)%j*f(36)+A(j,51)%j*f(43)+(-A(j,606)%j-A(j,611)%j-A(j,622)%j-A(j,627)%j)*f(61)+(A(j,656)%j &
       +A(j,661)%j+A(j,672)%j+A(j,677)%j)*f(62)+(A(j,571)%j+A(j,595)%j)*f(63)+(A(j,608)%j+A(j,613)%j+A(j,624)%j+A(j,629)%j &
       +A(j,658)%j+A(j,663)%j+A(j,674)%j+A(j,679)%j)*f(64)+((A(j,159)%j+A(j,164)%j+A(j,202)%j+A(j,207)%j+A(j,216)%j+A(j,221)%j &
       +A(j,244)%j+A(j,249)%j+A(j,254)%j+A(j,259)%j+A(j,365)%j+A(j,370)%j-A(j,610)%j-A(j,615)%j-A(j,626)%j-A(j,631)%j-A(j,660)%j &
       -A(j,665)%j-A(j,676)%j-A(j,681)%j)*f(64))/6._/**/REALKIND+(A(j,203)%j+A(j,245)%j)*f(70)+(-A(j,217)%j-A(j,255)%j)*f(71)+( &
       -A(j,194)%j-A(j,232)%j)*f(72)+(-A(j,205)%j-A(j,219)%j-A(j,247)%j-A(j,257)%j)*f(73)+(A(j,392)%j+A(j,402)%j)*f(74) &
       +(A(j,155)%j+A(j,160)%j+A(j,371)%j+A(j,376)%j)*f(75)+(-A(j,170)%j-A(j,175)%j-A(j,361)%j-A(j,366)%j)*f(76)+(-A(j,396)%j &
       -A(j,406)%j)*f(77)+(-A(j,157)%j-A(j,162)%j-A(j,172)%j-A(j,177)%j-A(j,363)%j-A(j,368)%j-A(j,373)%j-A(j,378)%j)*f(78) &
       +(A(j,198)%j+A(j,240)%j)*f(79)+(-A(j,212)%j-A(j,250)%j)*f(80)+(-A(j,186)%j-A(j,224)%j)*f(81)+(-A(j,200)%j-A(j,214)%j &
       -A(j,242)%j-A(j,252)%j)*f(82)-A(j,50)%j*f(83)+(A(j,60)%j+A(j,77)%j)*f(84)+((A(j,174)%j+A(j,179)%j+A(j,375)%j &
       +A(j,380)%j)*f(85))/6._/**/REALKIND
  M2(4)%j = (-A(j,116)%j-A(j,327)%j)*f(1)+(-A(j,476)%j-A(j,518)%j)*f(6)+(A(j,126)%j+A(j,334)%j)*f(7)+(A(j,286)%j+A(j,297)%j)*f(9) &
       +(A(j,113)%j+A(j,328)%j)*f(10)+(A(j,111)%j+A(j,112)%j+A(j,324)%j+A(j,325)%j)*f(11)+(A(j,638)%j+A(j,640)%j+A(j,646)%j &
       +A(j,648)%j)*f(19)+(-A(j,168)%j-A(j,359)%j)*f(21)+(-A(j,208)%j-A(j,210)%j-A(j,260)%j-A(j,262)%j)*f(23)+(-A(j,166)%j &
       -A(j,357)%j)*f(24)+(-A(j,165)%j-A(j,356)%j)*f(25)+(A(j,480)%j+A(j,522)%j)*f(31)+(-A(j,130)%j-A(j,338)%j)*f(32)+(-A(j,119)%j &
       -A(j,332)%j)*f(34)+(-A(j,290)%j-A(j,301)%j)*f(35)+(A(j,58)%j+A(j,76)%j)*f(42)+(-A(j,410)%j-A(j,421)%j-A(j,427)%j-A(j,438)%j &
       -A(j,482)%j-A(j,507)%j)*f(61)+(A(j,443)%j+A(j,454)%j+A(j,466)%j+A(j,471)%j+A(j,524)%j+A(j,543)%j)*f(62)+(A(j,478)%j &
       +A(j,520)%j)*f(63)+(A(j,412)%j+A(j,423)%j+A(j,429)%j+A(j,440)%j+A(j,445)%j+A(j,456)%j+A(j,468)%j+A(j,473)%j+A(j,484)%j &
       +A(j,509)%j+A(j,526)%j+A(j,545)%j)*f(64)+((A(j,57)%j+A(j,65)%j+A(j,70)%j+A(j,75)%j+A(j,99)%j+A(j,105)%j+A(j,110)%j &
       +A(j,125)%j+A(j,268)%j+A(j,274)%j+A(j,279)%j+A(j,285)%j+A(j,296)%j+A(j,307)%j+A(j,312)%j+A(j,318)%j+A(j,323)%j+A(j,344)%j &
       -A(j,414)%j-A(j,425)%j-A(j,431)%j-A(j,442)%j-A(j,447)%j-A(j,458)%j-A(j,470)%j-A(j,475)%j-A(j,486)%j-A(j,511)%j-A(j,528)%j &
       -A(j,547)%j)*f(64))/6._/**/REALKIND+(A(j,61)%j+A(j,101)%j+A(j,340)%j)*f(66)+(-A(j,71)%j-A(j,121)%j-A(j,314)%j)*f(67)+( &
       -A(j,128)%j-A(j,336)%j)*f(68)+(-A(j,63)%j-A(j,73)%j-A(j,103)%j-A(j,123)%j-A(j,316)%j-A(j,342)%j)*f(69)+(A(j,115)%j &
       +A(j,326)%j)*f(74)+(A(j,53)%j+A(j,82)%j+A(j,95)%j+A(j,106)%j+A(j,345)%j+A(j,351)%j)*f(75)+(-A(j,66)%j-A(j,87)%j-A(j,132)%j &
       -A(j,137)%j-A(j,308)%j-A(j,319)%j)*f(76)+(-A(j,117)%j-A(j,330)%j)*f(77)+(-A(j,55)%j-A(j,68)%j-A(j,84)%j-A(j,89)%j-A(j,97)%j &
       -A(j,108)%j-A(j,134)%j-A(j,139)%j-A(j,310)%j-A(j,321)%j-A(j,347)%j-A(j,353)%j)*f(78)+(A(j,264)%j+A(j,270)%j &
       +A(j,292)%j)*f(79)+(-A(j,275)%j-A(j,281)%j-A(j,303)%j)*f(80)+(-A(j,288)%j-A(j,299)%j)*f(81)+(-A(j,266)%j-A(j,272)%j &
       -A(j,277)%j-A(j,283)%j-A(j,294)%j-A(j,305)%j)*f(82)+(A(j,59)%j+A(j,78)%j)*f(84)+((A(j,86)%j+A(j,91)%j+A(j,136)%j+A(j,141)%j &
       +A(j,349)%j+A(j,355)%j)*f(85))/6._/**/REALKIND
  M2(5)%j = (A(j,503)%j+A(j,532)%j)*f(2)+(A(j,127)%j+A(j,335)%j-A(j,477)%j-A(j,493)%j-A(j,504)%j-A(j,519)%j-A(j,533)%j &
       -A(j,536)%j)*f(4)+(A(j,114)%j+A(j,329)%j)*f(5)+(-A(j,500)%j-A(j,501)%j-A(j,529)%j-A(j,530)%j)*f(12)+(A(j,495)%j &
       +A(j,538)%j)*f(13)+(-A(j,169)%j-A(j,360)%j+A(j,639)%j+A(j,641)%j+A(j,643)%j+A(j,645)%j+A(j,647)%j+A(j,649)%j)*f(15)+( &
       -A(j,261)%j-A(j,263)%j)*f(16)+(-A(j,167)%j-A(j,358)%j)*f(17)+(-A(j,209)%j-A(j,211)%j)*f(18)+(A(j,642)%j+A(j,644)%j)*f(26)+( &
       -A(j,497)%j-A(j,540)%j)*f(28)+(-A(j,131)%j-A(j,291)%j-A(j,302)%j-A(j,339)%j+A(j,481)%j+A(j,499)%j+A(j,506)%j+A(j,523)%j &
       +A(j,535)%j+A(j,542)%j)*f(29)+(-A(j,120)%j-A(j,333)%j)*f(30)+(-A(j,287)%j-A(j,298)%j)*f(37)+(A(j,415)%j+A(j,432)%j &
       +A(j,487)%j)*f(38)+(-A(j,448)%j-A(j,459)%j-A(j,512)%j)*f(39)+(A(j,416)%j+A(j,433)%j+A(j,449)%j+A(j,460)%j+A(j,488)%j &
       -A(j,494)%j+A(j,513)%j-A(j,537)%j)*f(40)+(A(j,79)%j+A(j,92)%j)*f(41)+(A(j,62)%j+A(j,102)%j+A(j,341)%j-A(j,411)%j-A(j,417)%j &
       -A(j,422)%j-A(j,428)%j-A(j,434)%j-A(j,439)%j-A(j,483)%j-A(j,489)%j-A(j,508)%j)*f(48)+(-A(j,265)%j-A(j,271)%j-A(j,293)%j &
       +A(j,419)%j+A(j,436)%j+A(j,491)%j)*f(49)+(-A(j,72)%j-A(j,122)%j-A(j,315)%j+A(j,444)%j+A(j,450)%j+A(j,455)%j+A(j,461)%j &
       +A(j,467)%j+A(j,472)%j+A(j,514)%j+A(j,525)%j+A(j,544)%j)*f(50)+(A(j,54)%j+A(j,67)%j+A(j,96)%j+A(j,107)%j-A(j,129)%j &
       +A(j,276)%j+A(j,282)%j+A(j,304)%j+A(j,309)%j+A(j,320)%j-A(j,337)%j-A(j,418)%j-A(j,435)%j-A(j,451)%j-A(j,452)%j-A(j,462)%j &
       -A(j,463)%j+A(j,479)%j-A(j,490)%j+A(j,496)%j+A(j,505)%j-A(j,515)%j-A(j,516)%j+A(j,521)%j+A(j,534)%j+A(j,539)%j)*f(51)+( &
       -A(j,56)%j-A(j,64)%j-A(j,69)%j-A(j,74)%j-A(j,98)%j-A(j,104)%j-A(j,109)%j-A(j,124)%j-A(j,267)%j-A(j,273)%j-A(j,278)%j &
       -A(j,284)%j+A(j,289)%j-A(j,295)%j+A(j,300)%j-A(j,306)%j-A(j,311)%j-A(j,317)%j-A(j,322)%j-A(j,343)%j+A(j,413)%j+A(j,420)%j &
       +A(j,424)%j+A(j,430)%j+A(j,437)%j+A(j,441)%j+A(j,446)%j+A(j,453)%j+A(j,457)%j+A(j,464)%j+A(j,469)%j+A(j,474)%j+A(j,485)%j &
       +A(j,492)%j-A(j,498)%j+A(j,510)%j+A(j,517)%j+A(j,527)%j-A(j,541)%j+A(j,546)%j)*f(52)+(-A(j,80)%j-A(j,93)%j)*f(53) &
       +(A(j,83)%j+A(j,346)%j+A(j,352)%j)*f(54)+(-A(j,88)%j-A(j,133)%j-A(j,138)%j)*f(55)+(-A(j,118)%j-A(j,331)%j)*f(56)+( &
       -A(j,85)%j-A(j,90)%j-A(j,135)%j-A(j,140)%j-A(j,348)%j-A(j,354)%j)*f(57)+(A(j,81)%j+A(j,94)%j)*f(58)+(-A(j,502)%j &
       -A(j,531)%j)*f(87)
  M2(6)%j = ((-A(j,57)%j-A(j,75)%j-A(j,105)%j-A(j,125)%j-A(j,159)%j-A(j,202)%j-A(j,216)%j-A(j,249)%j-A(j,259)%j-A(j,268)%j &
       -A(j,285)%j-A(j,307)%j-A(j,312)%j-A(j,323)%j-A(j,365)%j+A(j,414)%j+A(j,425)%j+A(j,470)%j+A(j,475)%j+A(j,528)%j+A(j,547)%j &
       +A(j,610)%j+A(j,615)%j+A(j,660)%j+A(j,665)%j)*f(64))/2._/**/REALKIND+(CI*(A(j,100)%j+A(j,269)%j+A(j,280)%j+A(j,313)%j &
       -A(j,426)%j-A(j,465)%j)*f(65))/2._/**/REALKIND+((-A(j,91)%j-A(j,141)%j-A(j,174)%j-A(j,349)%j &
       -A(j,375)%j)*f(85))/2._/**/REALKIND+(CI*(A(j,142)%j+A(j,350)%j)*f(86))/2._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwttj_ew_uttxdxwg_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 6
      do j = 1, 6
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwttj_ew_uttxdxwg_3_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(6), Mct(6)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 6
    do j = 1, 6
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+6*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppwttj_ew_uttxdxwg_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 6*k
    do i = 1, 6
      do j = 1, 6
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwttj_ew_uttxdxwg_3_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(6)
  complex(REALKIND), intent(in)  :: M2(6)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 6
    do j = 1, 6
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppwttj_ew_uttxdxwg_3_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(6)
  type(Hpolcont), intent(out)  :: M0_col(6)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 6 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 6 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+6*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppwttj_ew_uttxdxwg_3_/**/REALKIND
