
module ol_external_ppwttj_ew_uxttxdwxg_3
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_ppwttj_ew_uxttxdwxg_3(6) = &
                     [ (dummy_counter, dummy_counter = 1, 6) ]
  integer, save :: external_perm_inv_ppwttj_ew_uxttxdwxg_3(6) = &
                     [ (dummy_counter, dummy_counter = 1, 6) ]
  integer, save :: extcomb_perm_ppwttj_ew_uxttxdwxg_3(0:22) = &
                     [ (dummy_counter, dummy_counter = 0, 22) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_ppwttj_ew_uxttxdwxg_3(6) = &
                     [ 1, 2, 3, 4, 5, 6 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_ppwttj_ew_uxttxdwxg_3(6) = &
                     [ 6, 6, 6, 6, 3, 16 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_ppwttj_ew_uxttxdwxg_3 = &
                     36
  integer, save :: channel_number_ppwttj_ew_uxttxdwxg_3 = -1
  ! external particle helicities
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(6,96) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(96,6)
  integer, save :: POLSEL(6) = 0
  integer, save :: photonid_ppwttj_ew_uxttxdwxg_3(6) = 0

  contains

  subroutine n_external(n) &
      & bind(c,name="ol_f_n_external_ppwttj_ew_uxttxdwxg_3")
    ! Return the number of external particles
    implicit none
    integer, intent(out) :: n
    n = 6
  end subroutine n_external


  subroutine n_external_c(n) &
      & bind(c,name="ol_n_external_ppwttj_ew_uxttxdwxg_3")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int) :: n
    n = 6
  end subroutine n_external_c


  subroutine set_permutation(perm) &
      & bind(c,name="ol_f_set_permutation_ppwttj_ew_uxttxdwxg_3")
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_external_decl_/**/DREALKIND, only: n_scatt
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(6)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_ppwttj_ew_uxttxdwxg_3(6)
    external_perm_ppwttj_ew_uxttxdwxg_3 = perm
    do i = 1, 6
      external_perm_inv_ppwttj_ew_uxttxdwxg_3( &
        external_perm_ppwttj_ew_uxttxdwxg_3(i)) = i
      particle_types_perm_ppwttj_ew_uxttxdwxg_3(i) = &
        particle_types_ppwttj_ew_uxttxdwxg_3( &
        external_perm_ppwttj_ew_uxttxdwxg_3(i))
    end do
    do i = 1, 6
      do j = 1, i
        if (external_perm_ppwttj_ew_uxttxdwxg_3(i) >= &
          external_perm_ppwttj_ew_uxttxdwxg_3(j)) then
          ii = external_perm_ppwttj_ew_uxttxdwxg_3(i)
          jj = external_perm_ppwttj_ew_uxttxdwxg_3(j)
        else
          ii = external_perm_ppwttj_ew_uxttxdwxg_3(j)
          jj = external_perm_ppwttj_ew_uxttxdwxg_3(i)
        end if
        extcomb_perm_ppwttj_ew_uxttxdwxg_3((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_ppwttj_ew_uxttxdwxg_3 = 1
    do i = 1, n_scatt
      average_factor_ppwttj_ew_uxttxdwxg_3 = &
        average_factor_ppwttj_ew_uxttxdwxg_3 &
        * average_factors_ppwttj_ew_uxttxdwxg_3( &
        external_perm_ppwttj_ew_uxttxdwxg_3(i))
    end do
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 6
        average_factor_ppwttj_ew_uxttxdwxg_3 = &
          average_factor_ppwttj_ew_uxttxdwxg_3 &
          * factorial(count(particle_types_perm_ppwttj_ew_uxttxdwxg_3(n_scatt+1:6) == i))
      end do
    end if
  end subroutine set_permutation


  subroutine set_permutation_c(perm) &
      & bind(c,name="ol_set_permutation_ppwttj_ew_uxttxdwxg_3")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int), intent(in) :: perm(6)
    integer :: f_perm(6)
    f_perm = perm
    call set_permutation(f_perm)
  end subroutine set_permutation_c


  subroutine get_masses(m_ex) &
      & bind(c,name="ol_f_get_masses_ppwttj_ew_uxttxdwxg_3")
    ! Return the masses of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: m_ex(6)
    integer        :: i
    real(DREALKIND) :: m_ex_orig(6)
    ! External particle masses for in the identity permutation
    m_ex_orig = [ rZERO, rMT_unscaled, rMT_unscaled, rZERO, rMW_unscaled, rZERO ]
    do i = 1, 6
      m_ex(i) = m_ex_orig(external_perm_ppwttj_ew_uxttxdwxg_3(i))
    end do
  end subroutine get_masses


  subroutine get_masses_c(m_ex) &
      & bind(c,name="ol_get_masses_ppwttj_ew_uxttxdwxg_3")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: m_ex(6)
    real(DREALKIND) :: f_m_ex(6)
    call get_masses(f_m_ex)
    m_ex = f_m_ex
  end subroutine get_masses_c


  subroutine rambo(sqrt_s, p_rambo) &
      & bind(c,name="ol_f_rambo_ppwttj_ew_uxttxdwxg_3")
    use KIND_TYPES, only: DREALKIND
    use ol_kinematics_/**/DREALKIND, only: rambo_generic => rambo
    implicit none
    real(DREALKIND), intent(in) :: sqrt_s
    real(DREALKIND), intent(out) :: p_rambo(0:3,6)
    real(DREALKIND) :: m_ex(6)
    call get_masses(m_ex)
    call rambo_generic(sqrt_s, m_ex, p_rambo)
  end subroutine rambo


  subroutine rambo_c(sqrt_s, p_rambo) &
      & bind(c,name="ol_rambo_ppwttj_ew_uxttxdwxg_3")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in) :: sqrt_s
    real(c_double), intent(out) :: p_rambo(0:3,6)
    real(DREALKIND) :: f_sqrt_s
    real(DREALKIND) :: f_p_rambo(0:3,6)
    f_sqrt_s = sqrt_s
    call rambo(f_sqrt_s, f_p_rambo)
    p_rambo = f_p_rambo
  end subroutine rambo_c


  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:, 1) = [ -1, -1, -1, -1, -1, -1 ]
  H(:, 2) = [ -1, -1, -1, -1, -1,  1 ]
  H(:, 3) = [ -1, -1, -1, -1,  0, -1 ]
  H(:, 4) = [ -1, -1, -1, -1,  0,  1 ]
  H(:, 5) = [ -1, -1, -1, -1,  1, -1 ]
  H(:, 6) = [ -1, -1, -1, -1,  1,  1 ]
  H(:, 7) = [ -1, -1, -1,  1, -1, -1 ]
  H(:, 8) = [ -1, -1, -1,  1, -1,  1 ]
  H(:, 9) = [ -1, -1, -1,  1,  0, -1 ]
  H(:,10) = [ -1, -1, -1,  1,  0,  1 ]
  H(:,11) = [ -1, -1, -1,  1,  1, -1 ]
  H(:,12) = [ -1, -1, -1,  1,  1,  1 ]
  H(:,13) = [ -1, -1,  1, -1, -1, -1 ]
  H(:,14) = [ -1, -1,  1, -1, -1,  1 ]
  H(:,15) = [ -1, -1,  1, -1,  0, -1 ]
  H(:,16) = [ -1, -1,  1, -1,  0,  1 ]
  H(:,17) = [ -1, -1,  1, -1,  1, -1 ]
  H(:,18) = [ -1, -1,  1, -1,  1,  1 ]
  H(:,19) = [ -1, -1,  1,  1, -1, -1 ]
  H(:,20) = [ -1, -1,  1,  1, -1,  1 ]
  H(:,21) = [ -1, -1,  1,  1,  0, -1 ]
  H(:,22) = [ -1, -1,  1,  1,  0,  1 ]
  H(:,23) = [ -1, -1,  1,  1,  1, -1 ]
  H(:,24) = [ -1, -1,  1,  1,  1,  1 ]
  H(:,25) = [ -1,  1, -1, -1, -1, -1 ]
  H(:,26) = [ -1,  1, -1, -1, -1,  1 ]
  H(:,27) = [ -1,  1, -1, -1,  0, -1 ]
  H(:,28) = [ -1,  1, -1, -1,  0,  1 ]
  H(:,29) = [ -1,  1, -1, -1,  1, -1 ]
  H(:,30) = [ -1,  1, -1, -1,  1,  1 ]
  H(:,31) = [ -1,  1, -1,  1, -1, -1 ]
  H(:,32) = [ -1,  1, -1,  1, -1,  1 ]
  H(:,33) = [ -1,  1, -1,  1,  0, -1 ]
  H(:,34) = [ -1,  1, -1,  1,  0,  1 ]
  H(:,35) = [ -1,  1, -1,  1,  1, -1 ]
  H(:,36) = [ -1,  1, -1,  1,  1,  1 ]
  H(:,37) = [ -1,  1,  1, -1, -1, -1 ]
  H(:,38) = [ -1,  1,  1, -1, -1,  1 ]
  H(:,39) = [ -1,  1,  1, -1,  0, -1 ]
  H(:,40) = [ -1,  1,  1, -1,  0,  1 ]
  H(:,41) = [ -1,  1,  1, -1,  1, -1 ]
  H(:,42) = [ -1,  1,  1, -1,  1,  1 ]
  H(:,43) = [ -1,  1,  1,  1, -1, -1 ]
  H(:,44) = [ -1,  1,  1,  1, -1,  1 ]
  H(:,45) = [ -1,  1,  1,  1,  0, -1 ]
  H(:,46) = [ -1,  1,  1,  1,  0,  1 ]
  H(:,47) = [ -1,  1,  1,  1,  1, -1 ]
  H(:,48) = [ -1,  1,  1,  1,  1,  1 ]
  H(:,49) = [  1, -1, -1, -1, -1, -1 ]
  H(:,50) = [  1, -1, -1, -1, -1,  1 ]
  H(:,51) = [  1, -1, -1, -1,  0, -1 ]
  H(:,52) = [  1, -1, -1, -1,  0,  1 ]
  H(:,53) = [  1, -1, -1, -1,  1, -1 ]
  H(:,54) = [  1, -1, -1, -1,  1,  1 ]
  H(:,55) = [  1, -1, -1,  1, -1, -1 ]
  H(:,56) = [  1, -1, -1,  1, -1,  1 ]
  H(:,57) = [  1, -1, -1,  1,  0, -1 ]
  H(:,58) = [  1, -1, -1,  1,  0,  1 ]
  H(:,59) = [  1, -1, -1,  1,  1, -1 ]
  H(:,60) = [  1, -1, -1,  1,  1,  1 ]
  H(:,61) = [  1, -1,  1, -1, -1, -1 ]
  H(:,62) = [  1, -1,  1, -1, -1,  1 ]
  H(:,63) = [  1, -1,  1, -1,  0, -1 ]
  H(:,64) = [  1, -1,  1, -1,  0,  1 ]
  H(:,65) = [  1, -1,  1, -1,  1, -1 ]
  H(:,66) = [  1, -1,  1, -1,  1,  1 ]
  H(:,67) = [  1, -1,  1,  1, -1, -1 ]
  H(:,68) = [  1, -1,  1,  1, -1,  1 ]
  H(:,69) = [  1, -1,  1,  1,  0, -1 ]
  H(:,70) = [  1, -1,  1,  1,  0,  1 ]
  H(:,71) = [  1, -1,  1,  1,  1, -1 ]
  H(:,72) = [  1, -1,  1,  1,  1,  1 ]
  H(:,73) = [  1,  1, -1, -1, -1, -1 ]
  H(:,74) = [  1,  1, -1, -1, -1,  1 ]
  H(:,75) = [  1,  1, -1, -1,  0, -1 ]
  H(:,76) = [  1,  1, -1, -1,  0,  1 ]
  H(:,77) = [  1,  1, -1, -1,  1, -1 ]
  H(:,78) = [  1,  1, -1, -1,  1,  1 ]
  H(:,79) = [  1,  1, -1,  1, -1, -1 ]
  H(:,80) = [  1,  1, -1,  1, -1,  1 ]
  H(:,81) = [  1,  1, -1,  1,  0, -1 ]
  H(:,82) = [  1,  1, -1,  1,  0,  1 ]
  H(:,83) = [  1,  1, -1,  1,  1, -1 ]
  H(:,84) = [  1,  1, -1,  1,  1,  1 ]
  H(:,85) = [  1,  1,  1, -1, -1, -1 ]
  H(:,86) = [  1,  1,  1, -1, -1,  1 ]
  H(:,87) = [  1,  1,  1, -1,  0, -1 ]
  H(:,88) = [  1,  1,  1, -1,  0,  1 ]
  H(:,89) = [  1,  1,  1, -1,  1, -1 ]
  H(:,90) = [  1,  1,  1, -1,  1,  1 ]
  H(:,91) = [  1,  1,  1,  1, -1, -1 ]
  H(:,92) = [  1,  1,  1,  1, -1,  1 ]
  H(:,93) = [  1,  1,  1,  1,  0, -1 ]
  H(:,94) = [  1,  1,  1,  1,  0,  1 ]
  H(:,95) = [  1,  1,  1,  1,  1, -1 ]
  H(:,96) = [  1,  1,  1,  1,  1,  1 ]

  H_HC(:,6) = [ ((((2*(binco-1)+flip)*1+binpos, flip = 0, 1), binpos = 1, 1), binco = 1, 96/1/2) ]
  end subroutine hel_init


  subroutine pol_init(pol) &
      & bind(c,name="ol_f_pol_init_ppwttj_ew_uxttxdwxg_3")
    implicit none
    integer, intent(in) :: pol(6)
    POLSEL = pol
  end subroutine pol_init


  subroutine set_photons(photon_id) &
      & bind(c,name="ol_f_set_photons_ppwttj_ew_uxttxdwxg_3")
    implicit none
    integer, intent(in) :: photon_id(6)
    photonid_ppwttj_ew_uxttxdwxg_3 = photon_id
  end subroutine set_photons


end module ol_external_ppwttj_ew_uxttxdwxg_3


module ol_settings_ppwttj_ew_uxttxdwxg_3
  implicit none
  ! Activates optimized helicity bookkeeping. Default=false
    logical, save :: hel_mem_opt = .false.
  ! Calculate loop correlators
    logical, save :: loopcc = .false.

  contains

  subroutine set_hel_mem_opt(set) &
      & bind(c,name="ol_hel_mem_opt_ppwttj_ew_uxttxdwxg_3")
    implicit none
    logical, intent(in) :: set
    hel_mem_opt = set
  end subroutine set_hel_mem_opt

  subroutine set_loopcc(set,was) &
      & bind(c,name="ol_loopcc_ppwttj_ew_uxttxdwxg_3")
    implicit none
    logical, intent(in) :: set
    logical :: was
    was = loopcc
    loopcc = set
  end subroutine set_loopcc

end module ol_settings_ppwttj_ew_uxttxdwxg_3

module colour_basis_ppwttj_ew_uxttxdwxg_3
  implicit none
  ! tree colour basis
  integer, save :: extcolours(6) = [1,1,1,1,0,2]
  contains

  pure subroutine tree_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_tree_colbasis_dim_ppwttj_ew_uxttxdwxg_3")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(6)
    ! number of tree colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 6
    ncoupl = 1
    maxpows = 1
    nhel = 96
  end subroutine tree_colbasis_dim

  subroutine tree_colbasis(basis, powers) &
    & bind(c, name="ol_tree_colbasis_ppwttj_ew_uxttxdwxg_3")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,6)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([6], [1,1])
#endif
#if 6 > 0
    ! tree colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
    basis = reshape( &
      [1,97,1,1,102,1,1,102,3,1,111,3,1,111,1,1,113,1], &
      [3,6])
#endif
  end subroutine tree_colbasis

end module colour_basis_ppwttj_ew_uxttxdwxg_3

! **********************************************************************
module ol_heltables_OLR_ppwttj_ew_uxttxdwxg_3
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(3) = [-1,0,1], &
    H6(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(168), n3(3,1047), n4(4,1)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x6(2,6,6), t3x4(2,4,26), t3x16(2,16,41), t3x24(2,24,82), t3x12(2,12,103), t3x8(2,8,108), &
    t3x96(2,96,681), t4x24(3,24,1)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(96,6)
  integer,           save :: exthel(96,6)
  integer,           save :: firstpol(6)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,3,6], n3(:,1), t3x6(:,:,1))
  call heltable([2,2,4], n3(:,2), t3x4(:,:,1))
  call heltable([2,2,4], n3(:,3), t3x4(:,:,2))
  n2(1) = 6
  n2(2) = 4
  call heltable([6,4,24], n3(:,4), t3x24(:,:,1))
  call heltable([2,2,4], n3(:,5), t3x4(:,:,3))
  call heltable([6,4,24], n3(:,6), t3x24(:,:,2))
  call heltable([2,6,12], n3(:,7), t3x12(:,:,1))
  call heltable([4,2,8], n3(:,8), t3x8(:,:,1))
  call heltable([4,2,8], n3(:,9), t3x8(:,:,2))
  call heltable([6,2,12], n3(:,10), t3x12(:,:,2))
  n2(3) = 8
  call heltable([4,2,8], n3(:,11), t3x8(:,:,3))
  n2(4) = 8
  call heltable([2,2,4], n3(:,12), t3x4(:,:,4))
  call heltable([3,2,6], n3(:,13), t3x6(:,:,2))
  n2(5) = 4
  n2(6) = 6
  call heltable([4,4,16], n3(:,14), t3x16(:,:,1))
  call heltable([4,4,16], n3(:,15), t3x16(:,:,2))
  call heltable([2,4,8], n3(:,16), t3x8(:,:,4))
  call heltable([2,6,12], n3(:,17), t3x12(:,:,3))
  n2(7) = 8
  call heltable([2,4,8], n3(:,18), t3x8(:,:,5))
  n2(8) = 8
  call heltable([6,2,12], n3(:,19), t3x12(:,:,4))
  call heltable([2,2,4], n3(:,20), t3x4(:,:,5))
  call heltable([2,4,8], n3(:,21), t3x8(:,:,6))
  call heltable([4,3,12], n3(:,22), t3x12(:,:,5))
  call heltable([4,3,12], n3(:,23), t3x12(:,:,6))
  call heltable([4,3,12], n3(:,24), t3x12(:,:,7))
  call heltable([4,3,12], n3(:,25), t3x12(:,:,8))
  call heltable([3,4,12], n3(:,26), t3x12(:,:,9))
  call heltable([4,2,8], n3(:,27), t3x8(:,:,7))
  call heltable([2,2,4], n3(:,28), t3x4(:,:,6))
  call heltable([2,2,4], n3(:,29), t3x4(:,:,7))
  call heltable([2,3,6], n3(:,30), t3x6(:,:,3))
  n2(9) = 4
  n2(10) = 6
  call heltable([4,4,16], n3(:,31), t3x16(:,:,3))
  call heltable([4,2,8], n3(:,32), t3x8(:,:,8))
  call heltable([6,2,12], n3(:,33), t3x12(:,:,10))
  n2(11) = 8
  call heltable([2,4,8], n3(:,34), t3x8(:,:,9))
  call heltable([4,3,12], n3(:,35), t3x12(:,:,11))
  call heltable([4,2,8], n3(:,36), t3x8(:,:,10))
  call heltable([3,4,12], n3(:,37), t3x12(:,:,12))
  call heltable([4,2,8], n3(:,38), t3x8(:,:,11))
  call heltable([2,2,4], n3(:,39), t3x4(:,:,8))
  n2(12) = 4
  call heltable([4,3,12], n3(:,40), t3x12(:,:,13))
  call heltable([4,2,8], n3(:,41), t3x8(:,:,12))
  call heltable([2,4,8], n3(:,42), t3x8(:,:,13))
  call heltable([2,4,8], n3(:,43), t3x8(:,:,14))
  call heltable([2,6,12], n3(:,44), t3x12(:,:,14))
  call heltable([2,6,12], n3(:,45), t3x12(:,:,15))
  call heltable([6,2,12], n3(:,46), t3x12(:,:,16))
  call heltable([4,3,2,24], n4(:,1), t4x24(:,:,1))
  call heltable([4,2,8], n3(:,47), t3x8(:,:,15))
  call heltable([4,2,8], n3(:,48), t3x8(:,:,16))
  call heltable([6,4,24], n3(:,49), t3x24(:,:,3))
  call heltable([6,4,24], n3(:,50), t3x24(:,:,4))
  call heltable([6,4,24], n3(:,51), t3x24(:,:,5))
  call heltable([6,4,24], n3(:,52), t3x24(:,:,6))
  call heltable([6,4,24], n3(:,53), t3x24(:,:,7))
  call heltable([4,2,8], n3(:,54), t3x8(:,:,17))
  call heltable([4,2,8], n3(:,55), t3x8(:,:,18))
  call heltable([6,2,12], n3(:,56), t3x12(:,:,17))
  call heltable([6,2,12], n3(:,57), t3x12(:,:,18))
  call heltable([4,4,16], n3(:,58), t3x16(:,:,4))
  call heltable([4,4,16], n3(:,59), t3x16(:,:,5))
  call heltable([4,4,16], n3(:,60), t3x16(:,:,6))
  call heltable([4,4,16], n3(:,61), t3x16(:,:,7))
  call heltable([4,4,16], n3(:,62), t3x16(:,:,8))
  call heltable([2,6,12], n3(:,63), t3x12(:,:,19))
  call heltable([2,6,12], n3(:,64), t3x12(:,:,20))
  call heltable([4,3,12], n3(:,65), t3x12(:,:,21))
  call heltable([4,3,12], n3(:,66), t3x12(:,:,22))
  call heltable([4,3,12], n3(:,67), t3x12(:,:,23))
  call heltable([4,3,12], n3(:,68), t3x12(:,:,24))
  call heltable([3,4,12], n3(:,69), t3x12(:,:,25))
  call heltable([4,2,8], n3(:,70), t3x8(:,:,19))
  n2(13) = 12
  call heltable([4,2,8], n3(:,71), t3x8(:,:,20))
  call heltable([4,2,8], n3(:,72), t3x8(:,:,21))
  call heltable([4,2,8], n3(:,73), t3x8(:,:,22))
  call heltable([4,2,8], n3(:,74), t3x8(:,:,23))
  call heltable([2,6,12], n3(:,75), t3x12(:,:,26))
  call heltable([2,2,4], n3(:,76), t3x4(:,:,9))
  n2(14) = 4
  call heltable([2,2,4], n3(:,77), t3x4(:,:,10))
  n2(15) = 4
  n2(16) = 12
  call heltable([4,3,12], n3(:,78), t3x12(:,:,27))
  call heltable([4,2,8], n3(:,79), t3x8(:,:,24))
  call heltable([2,2,4], n3(:,80), t3x4(:,:,11))
  call heltable([4,3,12], n3(:,81), t3x12(:,:,28))
  call heltable([2,4,8], n3(:,82), t3x8(:,:,25))
  call heltable([4,3,12], n3(:,83), t3x12(:,:,29))
  call heltable([4,3,12], n3(:,84), t3x12(:,:,30))
  call heltable([3,4,12], n3(:,85), t3x12(:,:,31))
  call heltable([3,4,12], n3(:,86), t3x12(:,:,32))
  call heltable([4,2,8], n3(:,87), t3x8(:,:,26))
  call heltable([4,2,8], n3(:,88), t3x8(:,:,27))
  call heltable([3,2,6], n3(:,89), t3x6(:,:,4))
  n2(17) = 6
  call heltable([2,6,12], n3(:,90), t3x12(:,:,33))
  call heltable([6,2,12], n3(:,91), t3x12(:,:,34))
  call heltable([4,4,16], n3(:,92), t3x16(:,:,9))
  call heltable([6,2,12], n3(:,93), t3x12(:,:,35))
  call heltable([6,2,12], n3(:,94), t3x12(:,:,36))
  call heltable([4,3,12], n3(:,95), t3x12(:,:,37))
  call heltable([3,4,12], n3(:,96), t3x12(:,:,38))
  call heltable([4,3,12], n3(:,97), t3x12(:,:,39))
  call heltable([2,6,12], n3(:,98), t3x12(:,:,40))
  call heltable([2,6,12], n3(:,99), t3x12(:,:,41))
  call heltable([2,6,12], n3(:,100), t3x12(:,:,42))
  call heltable([2,6,12], n3(:,101), t3x12(:,:,43))
  call heltable([6,2,12], n3(:,102), t3x12(:,:,44))
  call heltable([6,2,12], n3(:,103), t3x12(:,:,45))
  call heltable([2,4,8], n3(:,104), t3x8(:,:,28))
  call heltable([2,4,8], n3(:,105), t3x8(:,:,29))
  call heltable([4,2,8], n3(:,106), t3x8(:,:,30))
  call heltable([4,2,8], n3(:,107), t3x8(:,:,31))
  call heltable([4,2,8], n3(:,108), t3x8(:,:,32))
  call heltable([4,2,8], n3(:,109), t3x8(:,:,33))
  call heltable([2,2,4], n3(:,110), t3x4(:,:,12))
  n2(18) = 4
  call heltable([4,3,12], n3(:,111), t3x12(:,:,46))
  call heltable([2,2,4], n3(:,112), t3x4(:,:,13))
  n2(19) = 4
  call heltable([4,3,12], n3(:,113), t3x12(:,:,47))
  call heltable([4,2,8], n3(:,114), t3x8(:,:,34))
  call heltable([4,2,8], n3(:,115), t3x8(:,:,35))
  call heltable([2,4,8], n3(:,116), t3x8(:,:,36))
  call heltable([2,4,8], n3(:,117), t3x8(:,:,37))
  call heltable([2,4,8], n3(:,118), t3x8(:,:,38))
  call heltable([2,4,8], n3(:,119), t3x8(:,:,39))
  call heltable([2,3,6], n3(:,120), t3x6(:,:,5))
  n2(20) = 6
  call heltable([6,2,12], n3(:,121), t3x12(:,:,48))
  call heltable([4,2,8], n3(:,122), t3x8(:,:,40))
  call heltable([2,6,12], n3(:,123), t3x12(:,:,49))
  call heltable([4,2,8], n3(:,124), t3x8(:,:,41))
  n2(21) = 12
  call heltable([2,2,4], n3(:,125), t3x4(:,:,14))
  n2(22) = 4
  call heltable([4,4,16], n3(:,126), t3x16(:,:,10))
  call heltable([2,2,4], n3(:,127), t3x4(:,:,15))
  n2(23) = 4
  call heltable([4,4,16], n3(:,128), t3x16(:,:,11))
  call heltable([4,2,8], n3(:,129), t3x8(:,:,42))
  call heltable([4,2,8], n3(:,130), t3x8(:,:,43))
  call heltable([2,4,8], n3(:,131), t3x8(:,:,44))
  call heltable([2,4,8], n3(:,132), t3x8(:,:,45))
  call heltable([2,4,8], n3(:,133), t3x8(:,:,46))
  call heltable([2,4,8], n3(:,134), t3x8(:,:,47))
  n2(24) = 12
  call heltable([2,4,8], n3(:,135), t3x8(:,:,48))
  call heltable([2,4,8], n3(:,136), t3x8(:,:,49))
  call heltable([4,2,8], n3(:,137), t3x8(:,:,50))
  call heltable([4,2,8], n3(:,138), t3x8(:,:,51))
  call heltable([4,2,8], n3(:,139), t3x8(:,:,52))
  call heltable([4,2,8], n3(:,140), t3x8(:,:,53))
  call heltable([2,4,8], n3(:,141), t3x8(:,:,54))
  call heltable([2,6,12], n3(:,142), t3x12(:,:,50))
  call heltable([2,2,4], n3(:,143), t3x4(:,:,16))
  call heltable([6,4,24], n3(:,144), t3x24(:,:,8))
  call heltable([2,2,4], n3(:,145), t3x4(:,:,17))
  call heltable([6,4,24], n3(:,146), t3x24(:,:,9))
  call heltable([2,2,4], n3(:,147), t3x4(:,:,18))
  call heltable([6,4,24], n3(:,148), t3x24(:,:,10))
  call heltable([2,2,4], n3(:,149), t3x4(:,:,19))
  call heltable([6,4,24], n3(:,150), t3x24(:,:,11))
  call heltable([2,2,4], n3(:,151), t3x4(:,:,20))
  call heltable([6,4,24], n3(:,152), t3x24(:,:,12))
  call heltable([4,2,8], n3(:,153), t3x8(:,:,55))
  call heltable([4,2,8], n3(:,154), t3x8(:,:,56))
  n2(25) = 8
  call heltable([4,2,8], n3(:,155), t3x8(:,:,57))
  n2(26) = 8
  call heltable([4,2,8], n3(:,156), t3x8(:,:,58))
  n2(27) = 8
  call heltable([4,2,8], n3(:,157), t3x8(:,:,59))
  n2(28) = 8
  call heltable([4,2,8], n3(:,158), t3x8(:,:,60))
  n2(29) = 8
  call heltable([4,4,16], n3(:,159), t3x16(:,:,12))
  call heltable([4,4,16], n3(:,160), t3x16(:,:,13))
  call heltable([4,4,16], n3(:,161), t3x16(:,:,14))
  call heltable([4,4,16], n3(:,162), t3x16(:,:,15))
  call heltable([4,4,16], n3(:,163), t3x16(:,:,16))
  call heltable([2,4,8], n3(:,164), t3x8(:,:,61))
  n2(30) = 8
  call heltable([2,4,8], n3(:,165), t3x8(:,:,62))
  n2(31) = 8
  call heltable([2,4,8], n3(:,166), t3x8(:,:,63))
  n2(32) = 8
  call heltable([2,4,8], n3(:,167), t3x8(:,:,64))
  n2(33) = 8
  call heltable([2,4,8], n3(:,168), t3x8(:,:,65))
  n2(34) = 8
  call heltable([2,2,4], n3(:,169), t3x4(:,:,21))
  call heltable([4,3,12], n3(:,170), t3x12(:,:,51))
  call heltable([2,2,4], n3(:,171), t3x4(:,:,22))
  call heltable([4,3,12], n3(:,172), t3x12(:,:,52))
  call heltable([4,3,12], n3(:,173), t3x12(:,:,53))
  call heltable([4,3,12], n3(:,174), t3x12(:,:,54))
  call heltable([4,3,12], n3(:,175), t3x12(:,:,55))
  call heltable([4,3,12], n3(:,176), t3x12(:,:,56))
  call heltable([2,4,8], n3(:,177), t3x8(:,:,66))
  n2(35) = 12
  call heltable([2,4,8], n3(:,178), t3x8(:,:,67))
  call heltable([2,4,8], n3(:,179), t3x8(:,:,68))
  call heltable([2,4,8], n3(:,180), t3x8(:,:,69))
  call heltable([2,4,8], n3(:,181), t3x8(:,:,70))
  call heltable([6,2,12], n3(:,182), t3x12(:,:,57))
  call heltable([2,2,4], n3(:,183), t3x4(:,:,23))
  n2(36) = 4
  call heltable([4,4,16], n3(:,184), t3x16(:,:,17))
  call heltable([2,2,4], n3(:,185), t3x4(:,:,24))
  n2(37) = 4
  call heltable([4,4,16], n3(:,186), t3x16(:,:,18))
  call heltable([4,4,16], n3(:,187), t3x16(:,:,19))
  call heltable([4,4,16], n3(:,188), t3x16(:,:,20))
  n2(38) = 12
  call heltable([2,4,8], n3(:,189), t3x8(:,:,71))
  call heltable([4,2,8], n3(:,190), t3x8(:,:,72))
  call heltable([2,4,8], n3(:,191), t3x8(:,:,73))
  call heltable([2,4,8], n3(:,192), t3x8(:,:,74))
  call heltable([4,3,12], n3(:,193), t3x12(:,:,58))
  call heltable([4,3,12], n3(:,194), t3x12(:,:,59))
  call heltable([2,3,6], n3(:,195), t3x6(:,:,6))
  n2(39) = 6
  call heltable([6,4,24], n3(:,196), t3x24(:,:,13))
  call heltable([6,4,24], n3(:,197), t3x24(:,:,14))
  call heltable([2,6,12], n3(:,198), t3x12(:,:,60))
  call heltable([6,2,12], n3(:,199), t3x12(:,:,61))
  call heltable([6,2,12], n3(:,200), t3x12(:,:,62))
  call heltable([6,2,12], n3(:,201), t3x12(:,:,63))
  call heltable([6,2,12], n3(:,202), t3x12(:,:,64))
  call heltable([6,2,12], n3(:,203), t3x12(:,:,65))
  call heltable([2,6,12], n3(:,204), t3x12(:,:,66))
  call heltable([2,2,4], n3(:,205), t3x4(:,:,25))
  call heltable([4,4,16], n3(:,206), t3x16(:,:,21))
  call heltable([2,2,4], n3(:,207), t3x4(:,:,26))
  call heltable([4,4,16], n3(:,208), t3x16(:,:,22))
  call heltable([2,4,8], n3(:,209), t3x8(:,:,75))
  n2(40) = 8
  call heltable([4,2,8], n3(:,210), t3x8(:,:,76))
  n2(41) = 8
  call heltable([3,4,12], n3(:,211), t3x12(:,:,67))
  call heltable([2,4,8], n3(:,212), t3x8(:,:,77))
  call heltable([4,3,12], n3(:,213), t3x12(:,:,68))
  call heltable([4,3,12], n3(:,214), t3x12(:,:,69))
  call heltable([3,4,12], n3(:,215), t3x12(:,:,70))
  call heltable([4,2,8], n3(:,216), t3x8(:,:,78))
  call heltable([4,4,16], n3(:,217), t3x16(:,:,23))
  n2(42) = 6
  n2(43) = 16
  n2(44) = 6
  call heltable([4,4,16], n3(:,218), t3x16(:,:,24))
  n2(45) = 16
  call heltable([4,6,24], n3(:,219), t3x24(:,:,15))
  n2(46) = 4
  call heltable([4,6,24], n3(:,220), t3x24(:,:,16))
  n2(47) = 4
  n2(48) = 4
  n2(49) = 4
  n2(50) = 4
  n2(51) = 4
  n2(52) = 4
  n2(53) = 24
  n2(54) = 4
  n2(55) = 24
  n2(56) = 6
  call heltable([2,6,12], n3(:,221), t3x12(:,:,71))
  n2(57) = 6
  call heltable([6,2,12], n3(:,222), t3x12(:,:,72))
  call heltable([6,2,12], n3(:,223), t3x12(:,:,73))
  call heltable([4,2,8], n3(:,224), t3x8(:,:,79))
  call heltable([4,2,8], n3(:,225), t3x8(:,:,80))
  call heltable([4,2,8], n3(:,226), t3x8(:,:,81))
  call heltable([4,2,8], n3(:,227), t3x8(:,:,82))
  call heltable([4,2,8], n3(:,228), t3x8(:,:,83))
  call heltable([4,2,8], n3(:,229), t3x8(:,:,84))
  n2(58) = 8
  n2(59) = 8
  n2(60) = 8
  n2(61) = 8
  call heltable([4,6,24], n3(:,230), t3x24(:,:,17))
  n2(62) = 4
  n2(63) = 24
  n2(64) = 4
  call heltable([4,6,24], n3(:,231), t3x24(:,:,18))
  n2(65) = 24
  call heltable([6,4,24], n3(:,232), t3x24(:,:,19))
  call heltable([6,4,24], n3(:,233), t3x24(:,:,20))
  n2(66) = 6
  n2(67) = 16
  n2(68) = 6
  n2(69) = 16
  call heltable([2,4,8], n3(:,234), t3x8(:,:,85))
  call heltable([2,4,8], n3(:,235), t3x8(:,:,86))
  call heltable([2,4,8], n3(:,236), t3x8(:,:,87))
  call heltable([2,4,8], n3(:,237), t3x8(:,:,88))
  call heltable([2,4,8], n3(:,238), t3x8(:,:,89))
  call heltable([2,4,8], n3(:,239), t3x8(:,:,90))
  n2(70) = 6
  call heltable([6,2,12], n3(:,240), t3x12(:,:,74))
  n2(71) = 8
  n2(72) = 8
  n2(73) = 8
  n2(74) = 8
  n2(75) = 6
  call heltable([2,6,12], n3(:,241), t3x12(:,:,75))
  call heltable([2,6,12], n3(:,242), t3x12(:,:,76))
  n2(76) = 4
  call heltable([2,4,8], n3(:,243), t3x8(:,:,91))
  n2(77) = 4
  call heltable([2,4,8], n3(:,244), t3x8(:,:,92))
  call heltable([4,3,12], n3(:,245), t3x12(:,:,77))
  call heltable([4,3,12], n3(:,246), t3x12(:,:,78))
  n2(78) = 4
  call heltable([4,3,12], n3(:,247), t3x12(:,:,79))
  call heltable([4,3,12], n3(:,248), t3x12(:,:,80))
  call heltable([4,3,12], n3(:,249), t3x12(:,:,81))
  call heltable([4,3,12], n3(:,250), t3x12(:,:,82))
  call heltable([4,3,12], n3(:,251), t3x12(:,:,83))
  call heltable([4,3,12], n3(:,252), t3x12(:,:,84))
  call heltable([4,3,12], n3(:,253), t3x12(:,:,85))
  n2(79) = 8
  n2(80) = 8
  n2(81) = 4
  call heltable([4,2,8], n3(:,254), t3x8(:,:,93))
  n2(82) = 4
  call heltable([4,2,8], n3(:,255), t3x8(:,:,94))
  n2(83) = 8
  n2(84) = 8
  call heltable([3,4,12], n3(:,256), t3x12(:,:,86))
  call heltable([3,4,12], n3(:,257), t3x12(:,:,87))
  call heltable([6,4,24], n3(:,258), t3x24(:,:,21))
  n2(85) = 4
  call heltable([4,6,24], n3(:,259), t3x24(:,:,22))
  n2(86) = 4
  call heltable([6,4,24], n3(:,260), t3x24(:,:,23))
  n2(87) = 4
  n2(88) = 24
  n2(89) = 4
  n2(90) = 6
  n2(91) = 16
  n2(92) = 6
  call heltable([2,4,8], n3(:,261), t3x8(:,:,95))
  call heltable([4,2,8], n3(:,262), t3x8(:,:,96))
  n2(93) = 8
  n2(94) = 8
  n2(95) = 6
  call heltable([6,2,12], n3(:,263), t3x12(:,:,88))
  n2(96) = 6
  call heltable([6,2,12], n3(:,264), t3x12(:,:,89))
  call heltable([3,4,12], n3(:,265), t3x12(:,:,90))
  call heltable([4,3,12], n3(:,266), t3x12(:,:,91))
  call heltable([4,3,12], n3(:,267), t3x12(:,:,92))
  call heltable([3,4,12], n3(:,268), t3x12(:,:,93))
  n2(97) = 4
  call heltable([2,4,8], n3(:,269), t3x8(:,:,97))
  n2(98) = 4
  call heltable([2,4,8], n3(:,270), t3x8(:,:,98))
  call heltable([4,2,8], n3(:,271), t3x8(:,:,99))
  call heltable([4,2,8], n3(:,272), t3x8(:,:,100))
  call heltable([4,2,8], n3(:,273), t3x8(:,:,101))
  call heltable([4,2,8], n3(:,274), t3x8(:,:,102))
  n2(99) = 8
  n2(100) = 8
  n2(101) = 8
  n2(102) = 8
  n2(103) = 8
  n2(104) = 8
  n2(105) = 8
  n2(106) = 4
  n2(107) = 4
  call heltable([4,2,8], n3(:,275), t3x8(:,:,103))
  n2(108) = 4
  n2(109) = 4
  call heltable([4,2,8], n3(:,276), t3x8(:,:,104))
  call heltable([2,4,8], n3(:,277), t3x8(:,:,105))
  call heltable([2,4,8], n3(:,278), t3x8(:,:,106))
  call heltable([2,4,8], n3(:,279), t3x8(:,:,107))
  call heltable([2,4,8], n3(:,280), t3x8(:,:,108))
  n2(110) = 8
  n2(111) = 8
  n2(112) = 8
  n2(113) = 8
  n2(114) = 8
  n2(115) = 8
  n2(116) = 8
  call heltable([4,3,12], n3(:,281), t3x12(:,:,94))
  call heltable([4,3,12], n3(:,282), t3x12(:,:,95))
  call heltable([2,6,12], n3(:,283), t3x12(:,:,96))
  call heltable([2,6,12], n3(:,284), t3x12(:,:,97))
  call heltable([2,6,12], n3(:,285), t3x12(:,:,98))
  call heltable([2,6,12], n3(:,286), t3x12(:,:,99))
  call heltable([2,6,12], n3(:,287), t3x12(:,:,100))
  n2(117) = 12
  n2(118) = 12
  n2(119) = 12
  n2(120) = 12
  n2(121) = 12
  n2(122) = 12
  n2(123) = 12
  n2(124) = 12
  call heltable([6,2,12], n3(:,288), t3x12(:,:,101))
  call heltable([6,2,12], n3(:,289), t3x12(:,:,102))
  call heltable([6,2,12], n3(:,290), t3x12(:,:,103))
  call heltable([8,3,24], n3(:,291), t3x24(:,:,24))
  n2(125) = 24
  call heltable([8,3,24], n3(:,292), t3x24(:,:,25))
  n2(126) = 24
  call heltable([8,2,16], n3(:,293), t3x16(:,:,25))
  n2(127) = 16
  call heltable([8,2,16], n3(:,294), t3x16(:,:,26))
  n2(128) = 16
  call heltable([2,12,24], n3(:,295), t3x24(:,:,26))
  n2(129) = 24
  call heltable([2,12,24], n3(:,296), t3x24(:,:,27))
  n2(130) = 24
  call heltable([2,12,24], n3(:,297), t3x24(:,:,28))
  n2(131) = 24
  call heltable([2,8,16], n3(:,298), t3x16(:,:,27))
  n2(132) = 16
  call heltable([3,8,24], n3(:,299), t3x24(:,:,29))
  n2(133) = 24
  call heltable([3,8,24], n3(:,300), t3x24(:,:,30))
  n2(134) = 24
  call heltable([2,8,16], n3(:,301), t3x16(:,:,28))
  n2(135) = 16
  call heltable([2,8,16], n3(:,302), t3x16(:,:,29))
  n2(136) = 16
  call heltable([12,2,24], n3(:,303), t3x24(:,:,31))
  n2(137) = 24
  call heltable([12,2,24], n3(:,304), t3x24(:,:,32))
  n2(138) = 24
  call heltable([12,2,24], n3(:,305), t3x24(:,:,33))
  n2(139) = 24
  call heltable([8,2,16], n3(:,306), t3x16(:,:,30))
  n2(140) = 16
  call heltable([3,8,24], n3(:,307), t3x24(:,:,34))
  n2(141) = 24
  call heltable([2,8,16], n3(:,308), t3x16(:,:,31))
  n2(142) = 16
  call heltable([2,12,24], n3(:,309), t3x24(:,:,35))
  n2(143) = 24
  call heltable([12,2,24], n3(:,310), t3x24(:,:,36))
  n2(144) = 24
  call heltable([12,2,24], n3(:,311), t3x24(:,:,37))
  n2(145) = 24
  call heltable([12,2,24], n3(:,312), t3x24(:,:,38))
  n2(146) = 24
  call heltable([2,12,24], n3(:,313), t3x24(:,:,39))
  n2(147) = 24
  call heltable([2,12,24], n3(:,314), t3x24(:,:,40))
  n2(148) = 24
  call heltable([12,2,24], n3(:,315), t3x24(:,:,41))
  n2(149) = 24
  call heltable([12,2,24], n3(:,316), t3x24(:,:,42))
  n2(150) = 24
  call heltable([2,12,24], n3(:,317), t3x24(:,:,43))
  n2(151) = 24
  call heltable([2,12,24], n3(:,318), t3x24(:,:,44))
  n2(152) = 24
  call heltable([12,2,24], n3(:,319), t3x24(:,:,45))
  call heltable([2,12,24], n3(:,320), t3x24(:,:,46))
  call heltable([2,12,24], n3(:,321), t3x24(:,:,47))
  call heltable([2,12,24], n3(:,322), t3x24(:,:,48))
  n2(153) = 24
  call heltable([12,2,24], n3(:,323), t3x24(:,:,49))
  n2(154) = 24
  call heltable([12,2,24], n3(:,324), t3x24(:,:,50))
  call heltable([2,12,24], n3(:,325), t3x24(:,:,51))
  call heltable([12,2,24], n3(:,326), t3x24(:,:,52))
  n2(155) = 24
  call heltable([12,2,24], n3(:,327), t3x24(:,:,53))
  n2(156) = 24
  call heltable([2,12,24], n3(:,328), t3x24(:,:,54))
  n2(157) = 24
  call heltable([2,12,24], n3(:,329), t3x24(:,:,55))
  n2(158) = 24
  call heltable([12,2,24], n3(:,330), t3x24(:,:,56))
  call heltable([12,2,24], n3(:,331), t3x24(:,:,57))
  call heltable([12,2,24], n3(:,332), t3x24(:,:,58))
  call heltable([8,2,16], n3(:,333), t3x16(:,:,32))
  n2(159) = 16
  call heltable([3,8,24], n3(:,334), t3x24(:,:,59))
  call heltable([3,8,24], n3(:,335), t3x24(:,:,60))
  call heltable([2,12,24], n3(:,336), t3x24(:,:,61))
  call heltable([2,12,24], n3(:,337), t3x24(:,:,62))
  call heltable([2,8,16], n3(:,338), t3x16(:,:,33))
  n2(160) = 16
  call heltable([2,8,16], n3(:,339), t3x16(:,:,34))
  n2(161) = 16
  call heltable([8,2,16], n3(:,340), t3x16(:,:,35))
  n2(162) = 16
  call heltable([8,2,16], n3(:,341), t3x16(:,:,36))
  n2(163) = 16
  call heltable([8,3,24], n3(:,342), t3x24(:,:,63))
  call heltable([8,3,24], n3(:,343), t3x24(:,:,64))
  call heltable([8,3,24], n3(:,344), t3x24(:,:,65))
  call heltable([3,8,24], n3(:,345), t3x24(:,:,66))
  call heltable([3,8,24], n3(:,346), t3x24(:,:,67))
  call heltable([8,3,24], n3(:,347), t3x24(:,:,68))
  call heltable([8,3,24], n3(:,348), t3x24(:,:,69))
  call heltable([2,8,16], n3(:,349), t3x16(:,:,37))
  n2(164) = 16
  call heltable([2,8,16], n3(:,350), t3x16(:,:,38))
  n2(165) = 16
  call heltable([8,2,16], n3(:,351), t3x16(:,:,39))
  n2(166) = 16
  call heltable([8,2,16], n3(:,352), t3x16(:,:,40))
  n2(167) = 16
  call heltable([8,3,24], n3(:,353), t3x24(:,:,70))
  call heltable([8,3,24], n3(:,354), t3x24(:,:,71))
  call heltable([8,3,24], n3(:,355), t3x24(:,:,72))
  call heltable([3,8,24], n3(:,356), t3x24(:,:,73))
  call heltable([3,8,24], n3(:,357), t3x24(:,:,74))
  call heltable([8,3,24], n3(:,358), t3x24(:,:,75))
  call heltable([8,3,24], n3(:,359), t3x24(:,:,76))
  call heltable([12,2,24], n3(:,360), t3x24(:,:,77))
  call heltable([2,12,24], n3(:,361), t3x24(:,:,78))
  call heltable([8,2,16], n3(:,362), t3x16(:,:,41))
  n2(168) = 16
  call heltable([3,8,24], n3(:,363), t3x24(:,:,79))
  call heltable([3,8,24], n3(:,364), t3x24(:,:,80))
  call heltable([12,2,24], n3(:,365), t3x24(:,:,81))
  call heltable([12,2,24], n3(:,366), t3x24(:,:,82))
  call heltable([4,24,96], n3(:,367), t3x96(:,:,1))
  call heltable([4,24,96], n3(:,368), t3x96(:,:,2))
  call heltable([4,24,96], n3(:,369), t3x96(:,:,3))
  call heltable([12,8,96], n3(:,370), t3x96(:,:,4))
  call heltable([12,8,96], n3(:,371), t3x96(:,:,5))
  call heltable([12,8,96], n3(:,372), t3x96(:,:,6))
  call heltable([12,8,96], n3(:,373), t3x96(:,:,7))
  call heltable([6,16,96], n3(:,374), t3x96(:,:,8))
  call heltable([6,16,96], n3(:,375), t3x96(:,:,9))
  call heltable([6,16,96], n3(:,376), t3x96(:,:,10))
  call heltable([12,8,96], n3(:,377), t3x96(:,:,11))
  call heltable([12,8,96], n3(:,378), t3x96(:,:,12))
  call heltable([12,8,96], n3(:,379), t3x96(:,:,13))
  call heltable([8,12,96], n3(:,380), t3x96(:,:,14))
  call heltable([8,12,96], n3(:,381), t3x96(:,:,15))
  call heltable([8,12,96], n3(:,382), t3x96(:,:,16))
  call heltable([8,12,96], n3(:,383), t3x96(:,:,17))
  call heltable([8,12,96], n3(:,384), t3x96(:,:,18))
  call heltable([8,12,96], n3(:,385), t3x96(:,:,19))
  call heltable([8,12,96], n3(:,386), t3x96(:,:,20))
  call heltable([8,12,96], n3(:,387), t3x96(:,:,21))
  call heltable([8,12,96], n3(:,388), t3x96(:,:,22))
  call heltable([8,12,96], n3(:,389), t3x96(:,:,23))
  call heltable([12,8,96], n3(:,390), t3x96(:,:,24))
  call heltable([12,8,96], n3(:,391), t3x96(:,:,25))
  call heltable([12,8,96], n3(:,392), t3x96(:,:,26))
  call heltable([6,16,96], n3(:,393), t3x96(:,:,27))
  call heltable([12,8,96], n3(:,394), t3x96(:,:,28))
  call heltable([8,12,96], n3(:,395), t3x96(:,:,29))
  call heltable([8,12,96], n3(:,396), t3x96(:,:,30))
  call heltable([12,8,96], n3(:,397), t3x96(:,:,31))
  call heltable([8,12,96], n3(:,398), t3x96(:,:,32))
  call heltable([12,8,96], n3(:,399), t3x96(:,:,33))
  call heltable([12,8,96], n3(:,400), t3x96(:,:,34))
  call heltable([12,8,96], n3(:,401), t3x96(:,:,35))
  call heltable([12,8,96], n3(:,402), t3x96(:,:,36))
  call heltable([8,12,96], n3(:,403), t3x96(:,:,37))
  call heltable([12,8,96], n3(:,404), t3x96(:,:,38))
  call heltable([12,8,96], n3(:,405), t3x96(:,:,39))
  call heltable([8,12,96], n3(:,406), t3x96(:,:,40))
  call heltable([12,8,96], n3(:,407), t3x96(:,:,41))
  call heltable([8,12,96], n3(:,408), t3x96(:,:,42))
  call heltable([8,12,96], n3(:,409), t3x96(:,:,43))
  call heltable([12,8,96], n3(:,410), t3x96(:,:,44))
  call heltable([8,12,96], n3(:,411), t3x96(:,:,45))
  call heltable([12,8,96], n3(:,412), t3x96(:,:,46))
  call heltable([12,8,96], n3(:,413), t3x96(:,:,47))
  call heltable([8,12,96], n3(:,414), t3x96(:,:,48))
  call heltable([12,8,96], n3(:,415), t3x96(:,:,49))
  call heltable([4,24,96], n3(:,416), t3x96(:,:,50))
  call heltable([12,8,96], n3(:,417), t3x96(:,:,51))
  call heltable([12,8,96], n3(:,418), t3x96(:,:,52))
  call heltable([4,24,96], n3(:,419), t3x96(:,:,53))
  call heltable([4,24,96], n3(:,420), t3x96(:,:,54))
  call heltable([4,24,96], n3(:,421), t3x96(:,:,55))
  call heltable([4,24,96], n3(:,422), t3x96(:,:,56))
  call heltable([4,24,96], n3(:,423), t3x96(:,:,57))
  call heltable([12,8,96], n3(:,424), t3x96(:,:,58))
  call heltable([12,8,96], n3(:,425), t3x96(:,:,59))
  call heltable([12,8,96], n3(:,426), t3x96(:,:,60))
  call heltable([8,12,96], n3(:,427), t3x96(:,:,61))
  call heltable([8,12,96], n3(:,428), t3x96(:,:,62))
  call heltable([8,12,96], n3(:,429), t3x96(:,:,63))
  call heltable([8,12,96], n3(:,430), t3x96(:,:,64))
  call heltable([8,12,96], n3(:,431), t3x96(:,:,65))
  call heltable([6,16,96], n3(:,432), t3x96(:,:,66))
  call heltable([6,16,96], n3(:,433), t3x96(:,:,67))
  call heltable([6,16,96], n3(:,434), t3x96(:,:,68))
  call heltable([6,16,96], n3(:,435), t3x96(:,:,69))
  call heltable([6,16,96], n3(:,436), t3x96(:,:,70))
  call heltable([8,12,96], n3(:,437), t3x96(:,:,71))
  call heltable([8,12,96], n3(:,438), t3x96(:,:,72))
  call heltable([8,12,96], n3(:,439), t3x96(:,:,73))
  call heltable([8,12,96], n3(:,440), t3x96(:,:,74))
  call heltable([8,12,96], n3(:,441), t3x96(:,:,75))
  call heltable([12,8,96], n3(:,442), t3x96(:,:,76))
  call heltable([12,8,96], n3(:,443), t3x96(:,:,77))
  call heltable([12,8,96], n3(:,444), t3x96(:,:,78))
  call heltable([8,12,96], n3(:,445), t3x96(:,:,79))
  call heltable([8,12,96], n3(:,446), t3x96(:,:,80))
  call heltable([8,12,96], n3(:,447), t3x96(:,:,81))
  call heltable([8,12,96], n3(:,448), t3x96(:,:,82))
  call heltable([8,12,96], n3(:,449), t3x96(:,:,83))
  call heltable([8,12,96], n3(:,450), t3x96(:,:,84))
  call heltable([8,12,96], n3(:,451), t3x96(:,:,85))
  call heltable([8,12,96], n3(:,452), t3x96(:,:,86))
  call heltable([8,12,96], n3(:,453), t3x96(:,:,87))
  call heltable([8,12,96], n3(:,454), t3x96(:,:,88))
  call heltable([8,12,96], n3(:,455), t3x96(:,:,89))
  call heltable([8,12,96], n3(:,456), t3x96(:,:,90))
  call heltable([8,12,96], n3(:,457), t3x96(:,:,91))
  call heltable([8,12,96], n3(:,458), t3x96(:,:,92))
  call heltable([8,12,96], n3(:,459), t3x96(:,:,93))
  call heltable([8,12,96], n3(:,460), t3x96(:,:,94))
  call heltable([8,12,96], n3(:,461), t3x96(:,:,95))
  call heltable([12,8,96], n3(:,462), t3x96(:,:,96))
  call heltable([12,8,96], n3(:,463), t3x96(:,:,97))
  call heltable([12,8,96], n3(:,464), t3x96(:,:,98))
  call heltable([12,8,96], n3(:,465), t3x96(:,:,99))
  call heltable([8,12,96], n3(:,466), t3x96(:,:,100))
  call heltable([24,4,96], n3(:,467), t3x96(:,:,101))
  call heltable([24,4,96], n3(:,468), t3x96(:,:,102))
  call heltable([24,4,96], n3(:,469), t3x96(:,:,103))
  call heltable([24,4,96], n3(:,470), t3x96(:,:,104))
  call heltable([24,4,96], n3(:,471), t3x96(:,:,105))
  call heltable([8,12,96], n3(:,472), t3x96(:,:,106))
  call heltable([8,12,96], n3(:,473), t3x96(:,:,107))
  call heltable([8,12,96], n3(:,474), t3x96(:,:,108))
  call heltable([8,12,96], n3(:,475), t3x96(:,:,109))
  call heltable([8,12,96], n3(:,476), t3x96(:,:,110))
  call heltable([12,8,96], n3(:,477), t3x96(:,:,111))
  call heltable([8,12,96], n3(:,478), t3x96(:,:,112))
  call heltable([12,8,96], n3(:,479), t3x96(:,:,113))
  call heltable([12,8,96], n3(:,480), t3x96(:,:,114))
  call heltable([8,12,96], n3(:,481), t3x96(:,:,115))
  call heltable([8,12,96], n3(:,482), t3x96(:,:,116))
  call heltable([12,8,96], n3(:,483), t3x96(:,:,117))
  call heltable([12,8,96], n3(:,484), t3x96(:,:,118))
  call heltable([12,8,96], n3(:,485), t3x96(:,:,119))
  call heltable([12,8,96], n3(:,486), t3x96(:,:,120))
  call heltable([8,12,96], n3(:,487), t3x96(:,:,121))
  call heltable([8,12,96], n3(:,488), t3x96(:,:,122))
  call heltable([8,12,96], n3(:,489), t3x96(:,:,123))
  call heltable([8,12,96], n3(:,490), t3x96(:,:,124))
  call heltable([8,12,96], n3(:,491), t3x96(:,:,125))
  call heltable([12,8,96], n3(:,492), t3x96(:,:,126))
  call heltable([12,8,96], n3(:,493), t3x96(:,:,127))
  call heltable([12,8,96], n3(:,494), t3x96(:,:,128))
  call heltable([12,8,96], n3(:,495), t3x96(:,:,129))
  call heltable([12,8,96], n3(:,496), t3x96(:,:,130))
  call heltable([12,8,96], n3(:,497), t3x96(:,:,131))
  call heltable([16,6,96], n3(:,498), t3x96(:,:,132))
  call heltable([16,6,96], n3(:,499), t3x96(:,:,133))
  call heltable([16,6,96], n3(:,500), t3x96(:,:,134))
  call heltable([16,6,96], n3(:,501), t3x96(:,:,135))
  call heltable([16,6,96], n3(:,502), t3x96(:,:,136))
  call heltable([8,12,96], n3(:,503), t3x96(:,:,137))
  call heltable([8,12,96], n3(:,504), t3x96(:,:,138))
  call heltable([8,12,96], n3(:,505), t3x96(:,:,139))
  call heltable([8,12,96], n3(:,506), t3x96(:,:,140))
  call heltable([8,12,96], n3(:,507), t3x96(:,:,141))
  call heltable([8,12,96], n3(:,508), t3x96(:,:,142))
  call heltable([6,16,96], n3(:,509), t3x96(:,:,143))
  call heltable([6,16,96], n3(:,510), t3x96(:,:,144))
  call heltable([8,12,96], n3(:,511), t3x96(:,:,145))
  call heltable([8,12,96], n3(:,512), t3x96(:,:,146))
  call heltable([8,12,96], n3(:,513), t3x96(:,:,147))
  call heltable([8,12,96], n3(:,514), t3x96(:,:,148))
  call heltable([8,12,96], n3(:,515), t3x96(:,:,149))
  call heltable([8,12,96], n3(:,516), t3x96(:,:,150))
  call heltable([8,12,96], n3(:,517), t3x96(:,:,151))
  call heltable([8,12,96], n3(:,518), t3x96(:,:,152))
  call heltable([8,12,96], n3(:,519), t3x96(:,:,153))
  call heltable([8,12,96], n3(:,520), t3x96(:,:,154))
  call heltable([8,12,96], n3(:,521), t3x96(:,:,155))
  call heltable([8,12,96], n3(:,522), t3x96(:,:,156))
  call heltable([8,12,96], n3(:,523), t3x96(:,:,157))
  call heltable([8,12,96], n3(:,524), t3x96(:,:,158))
  call heltable([8,12,96], n3(:,525), t3x96(:,:,159))
  call heltable([8,12,96], n3(:,526), t3x96(:,:,160))
  call heltable([8,12,96], n3(:,527), t3x96(:,:,161))
  call heltable([8,12,96], n3(:,528), t3x96(:,:,162))
  call heltable([8,12,96], n3(:,529), t3x96(:,:,163))
  call heltable([8,12,96], n3(:,530), t3x96(:,:,164))
  call heltable([8,12,96], n3(:,531), t3x96(:,:,165))
  call heltable([12,8,96], n3(:,532), t3x96(:,:,166))
  call heltable([12,8,96], n3(:,533), t3x96(:,:,167))
  call heltable([12,8,96], n3(:,534), t3x96(:,:,168))
  call heltable([12,8,96], n3(:,535), t3x96(:,:,169))
  call heltable([8,12,96], n3(:,536), t3x96(:,:,170))
  call heltable([8,12,96], n3(:,537), t3x96(:,:,171))
  call heltable([8,12,96], n3(:,538), t3x96(:,:,172))
  call heltable([8,12,96], n3(:,539), t3x96(:,:,173))
  call heltable([8,12,96], n3(:,540), t3x96(:,:,174))
  call heltable([8,12,96], n3(:,541), t3x96(:,:,175))
  call heltable([8,12,96], n3(:,542), t3x96(:,:,176))
  call heltable([8,12,96], n3(:,543), t3x96(:,:,177))
  call heltable([8,12,96], n3(:,544), t3x96(:,:,178))
  call heltable([8,12,96], n3(:,545), t3x96(:,:,179))
  call heltable([12,8,96], n3(:,546), t3x96(:,:,180))
  call heltable([12,8,96], n3(:,547), t3x96(:,:,181))
  call heltable([12,8,96], n3(:,548), t3x96(:,:,182))
  call heltable([12,8,96], n3(:,549), t3x96(:,:,183))
  call heltable([12,8,96], n3(:,550), t3x96(:,:,184))
  call heltable([12,8,96], n3(:,551), t3x96(:,:,185))
  call heltable([8,12,96], n3(:,552), t3x96(:,:,186))
  call heltable([8,12,96], n3(:,553), t3x96(:,:,187))
  call heltable([12,8,96], n3(:,554), t3x96(:,:,188))
  call heltable([12,8,96], n3(:,555), t3x96(:,:,189))
  call heltable([12,8,96], n3(:,556), t3x96(:,:,190))
  call heltable([12,8,96], n3(:,557), t3x96(:,:,191))
  call heltable([12,8,96], n3(:,558), t3x96(:,:,192))
  call heltable([12,8,96], n3(:,559), t3x96(:,:,193))
  call heltable([16,6,96], n3(:,560), t3x96(:,:,194))
  call heltable([16,6,96], n3(:,561), t3x96(:,:,195))
  call heltable([8,12,96], n3(:,562), t3x96(:,:,196))
  call heltable([8,12,96], n3(:,563), t3x96(:,:,197))
  call heltable([12,8,96], n3(:,564), t3x96(:,:,198))
  call heltable([12,8,96], n3(:,565), t3x96(:,:,199))
  call heltable([12,8,96], n3(:,566), t3x96(:,:,200))
  call heltable([12,8,96], n3(:,567), t3x96(:,:,201))
  call heltable([12,8,96], n3(:,568), t3x96(:,:,202))
  call heltable([12,8,96], n3(:,569), t3x96(:,:,203))
  call heltable([12,8,96], n3(:,570), t3x96(:,:,204))
  call heltable([12,8,96], n3(:,571), t3x96(:,:,205))
  call heltable([12,8,96], n3(:,572), t3x96(:,:,206))
  call heltable([12,8,96], n3(:,573), t3x96(:,:,207))
  call heltable([12,8,96], n3(:,574), t3x96(:,:,208))
  call heltable([12,8,96], n3(:,575), t3x96(:,:,209))
  call heltable([12,8,96], n3(:,576), t3x96(:,:,210))
  call heltable([12,8,96], n3(:,577), t3x96(:,:,211))
  call heltable([12,8,96], n3(:,578), t3x96(:,:,212))
  call heltable([12,8,96], n3(:,579), t3x96(:,:,213))
  call heltable([12,8,96], n3(:,580), t3x96(:,:,214))
  call heltable([12,8,96], n3(:,581), t3x96(:,:,215))
  call heltable([12,8,96], n3(:,582), t3x96(:,:,216))
  call heltable([12,8,96], n3(:,583), t3x96(:,:,217))
  call heltable([8,12,96], n3(:,584), t3x96(:,:,218))
  call heltable([8,12,96], n3(:,585), t3x96(:,:,219))
  call heltable([8,12,96], n3(:,586), t3x96(:,:,220))
  call heltable([8,12,96], n3(:,587), t3x96(:,:,221))
  call heltable([8,12,96], n3(:,588), t3x96(:,:,222))
  call heltable([8,12,96], n3(:,589), t3x96(:,:,223))
  call heltable([6,16,96], n3(:,590), t3x96(:,:,224))
  call heltable([6,16,96], n3(:,591), t3x96(:,:,225))
  call heltable([12,8,96], n3(:,592), t3x96(:,:,226))
  call heltable([12,8,96], n3(:,593), t3x96(:,:,227))
  call heltable([12,8,96], n3(:,594), t3x96(:,:,228))
  call heltable([12,8,96], n3(:,595), t3x96(:,:,229))
  call heltable([12,8,96], n3(:,596), t3x96(:,:,230))
  call heltable([12,8,96], n3(:,597), t3x96(:,:,231))
  call heltable([8,12,96], n3(:,598), t3x96(:,:,232))
  call heltable([8,12,96], n3(:,599), t3x96(:,:,233))
  call heltable([12,8,96], n3(:,600), t3x96(:,:,234))
  call heltable([12,8,96], n3(:,601), t3x96(:,:,235))
  call heltable([12,8,96], n3(:,602), t3x96(:,:,236))
  call heltable([12,8,96], n3(:,603), t3x96(:,:,237))
  call heltable([12,8,96], n3(:,604), t3x96(:,:,238))
  call heltable([12,8,96], n3(:,605), t3x96(:,:,239))
  call heltable([12,8,96], n3(:,606), t3x96(:,:,240))
  call heltable([12,8,96], n3(:,607), t3x96(:,:,241))
  call heltable([12,8,96], n3(:,608), t3x96(:,:,242))
  call heltable([12,8,96], n3(:,609), t3x96(:,:,243))
  call heltable([12,8,96], n3(:,610), t3x96(:,:,244))
  call heltable([12,8,96], n3(:,611), t3x96(:,:,245))
  call heltable([12,8,96], n3(:,612), t3x96(:,:,246))
  call heltable([12,8,96], n3(:,613), t3x96(:,:,247))
  call heltable([12,8,96], n3(:,614), t3x96(:,:,248))
  call heltable([12,8,96], n3(:,615), t3x96(:,:,249))
  call heltable([8,12,96], n3(:,616), t3x96(:,:,250))
  call heltable([8,12,96], n3(:,617), t3x96(:,:,251))
  call heltable([8,12,96], n3(:,618), t3x96(:,:,252))
  call heltable([8,12,96], n3(:,619), t3x96(:,:,253))
  call heltable([12,8,96], n3(:,620), t3x96(:,:,254))
  call heltable([12,8,96], n3(:,621), t3x96(:,:,255))
  call heltable([12,8,96], n3(:,622), t3x96(:,:,256))
  call heltable([12,8,96], n3(:,623), t3x96(:,:,257))
  call heltable([12,8,96], n3(:,624), t3x96(:,:,258))
  call heltable([12,8,96], n3(:,625), t3x96(:,:,259))
  call heltable([12,8,96], n3(:,626), t3x96(:,:,260))
  call heltable([12,8,96], n3(:,627), t3x96(:,:,261))
  call heltable([12,8,96], n3(:,628), t3x96(:,:,262))
  call heltable([12,8,96], n3(:,629), t3x96(:,:,263))
  call heltable([4,24,96], n3(:,630), t3x96(:,:,264))
  call heltable([4,24,96], n3(:,631), t3x96(:,:,265))
  call heltable([4,24,96], n3(:,632), t3x96(:,:,266))
  call heltable([4,24,96], n3(:,633), t3x96(:,:,267))
  call heltable([4,24,96], n3(:,634), t3x96(:,:,268))
  call heltable([12,8,96], n3(:,635), t3x96(:,:,269))
  call heltable([12,8,96], n3(:,636), t3x96(:,:,270))
  call heltable([12,8,96], n3(:,637), t3x96(:,:,271))
  call heltable([12,8,96], n3(:,638), t3x96(:,:,272))
  call heltable([12,8,96], n3(:,639), t3x96(:,:,273))
  call heltable([12,8,96], n3(:,640), t3x96(:,:,274))
  call heltable([6,16,96], n3(:,641), t3x96(:,:,275))
  call heltable([6,16,96], n3(:,642), t3x96(:,:,276))
  call heltable([6,16,96], n3(:,643), t3x96(:,:,277))
  call heltable([6,16,96], n3(:,644), t3x96(:,:,278))
  call heltable([6,16,96], n3(:,645), t3x96(:,:,279))
  call heltable([12,8,96], n3(:,646), t3x96(:,:,280))
  call heltable([12,8,96], n3(:,647), t3x96(:,:,281))
  call heltable([12,8,96], n3(:,648), t3x96(:,:,282))
  call heltable([12,8,96], n3(:,649), t3x96(:,:,283))
  call heltable([12,8,96], n3(:,650), t3x96(:,:,284))
  call heltable([12,8,96], n3(:,651), t3x96(:,:,285))
  call heltable([8,12,96], n3(:,652), t3x96(:,:,286))
  call heltable([8,12,96], n3(:,653), t3x96(:,:,287))
  call heltable([8,12,96], n3(:,654), t3x96(:,:,288))
  call heltable([8,12,96], n3(:,655), t3x96(:,:,289))
  call heltable([8,12,96], n3(:,656), t3x96(:,:,290))
  call heltable([8,12,96], n3(:,657), t3x96(:,:,291))
  call heltable([12,8,96], n3(:,658), t3x96(:,:,292))
  call heltable([12,8,96], n3(:,659), t3x96(:,:,293))
  call heltable([12,8,96], n3(:,660), t3x96(:,:,294))
  call heltable([12,8,96], n3(:,661), t3x96(:,:,295))
  call heltable([12,8,96], n3(:,662), t3x96(:,:,296))
  call heltable([8,12,96], n3(:,663), t3x96(:,:,297))
  call heltable([8,12,96], n3(:,664), t3x96(:,:,298))
  call heltable([8,12,96], n3(:,665), t3x96(:,:,299))
  call heltable([8,12,96], n3(:,666), t3x96(:,:,300))
  call heltable([8,12,96], n3(:,667), t3x96(:,:,301))
  call heltable([8,12,96], n3(:,668), t3x96(:,:,302))
  call heltable([12,8,96], n3(:,669), t3x96(:,:,303))
  call heltable([12,8,96], n3(:,670), t3x96(:,:,304))
  call heltable([12,8,96], n3(:,671), t3x96(:,:,305))
  call heltable([12,8,96], n3(:,672), t3x96(:,:,306))
  call heltable([12,8,96], n3(:,673), t3x96(:,:,307))
  call heltable([8,12,96], n3(:,674), t3x96(:,:,308))
  call heltable([12,8,96], n3(:,675), t3x96(:,:,309))
  call heltable([12,8,96], n3(:,676), t3x96(:,:,310))
  call heltable([12,8,96], n3(:,677), t3x96(:,:,311))
  call heltable([12,8,96], n3(:,678), t3x96(:,:,312))
  call heltable([8,12,96], n3(:,679), t3x96(:,:,313))
  call heltable([6,16,96], n3(:,680), t3x96(:,:,314))
  call heltable([6,16,96], n3(:,681), t3x96(:,:,315))
  call heltable([6,16,96], n3(:,682), t3x96(:,:,316))
  call heltable([6,16,96], n3(:,683), t3x96(:,:,317))
  call heltable([6,16,96], n3(:,684), t3x96(:,:,318))
  call heltable([8,12,96], n3(:,685), t3x96(:,:,319))
  call heltable([8,12,96], n3(:,686), t3x96(:,:,320))
  call heltable([8,12,96], n3(:,687), t3x96(:,:,321))
  call heltable([8,12,96], n3(:,688), t3x96(:,:,322))
  call heltable([8,12,96], n3(:,689), t3x96(:,:,323))
  call heltable([12,8,96], n3(:,690), t3x96(:,:,324))
  call heltable([12,8,96], n3(:,691), t3x96(:,:,325))
  call heltable([12,8,96], n3(:,692), t3x96(:,:,326))
  call heltable([12,8,96], n3(:,693), t3x96(:,:,327))
  call heltable([12,8,96], n3(:,694), t3x96(:,:,328))
  call heltable([12,8,96], n3(:,695), t3x96(:,:,329))
  call heltable([12,8,96], n3(:,696), t3x96(:,:,330))
  call heltable([12,8,96], n3(:,697), t3x96(:,:,331))
  call heltable([12,8,96], n3(:,698), t3x96(:,:,332))
  call heltable([12,8,96], n3(:,699), t3x96(:,:,333))
  call heltable([12,8,96], n3(:,700), t3x96(:,:,334))
  call heltable([12,8,96], n3(:,701), t3x96(:,:,335))
  call heltable([12,8,96], n3(:,702), t3x96(:,:,336))
  call heltable([12,8,96], n3(:,703), t3x96(:,:,337))
  call heltable([12,8,96], n3(:,704), t3x96(:,:,338))
  call heltable([12,8,96], n3(:,705), t3x96(:,:,339))
  call heltable([8,12,96], n3(:,706), t3x96(:,:,340))
  call heltable([8,12,96], n3(:,707), t3x96(:,:,341))
  call heltable([8,12,96], n3(:,708), t3x96(:,:,342))
  call heltable([8,12,96], n3(:,709), t3x96(:,:,343))
  call heltable([8,12,96], n3(:,710), t3x96(:,:,344))
  call heltable([4,24,96], n3(:,711), t3x96(:,:,345))
  call heltable([4,24,96], n3(:,712), t3x96(:,:,346))
  call heltable([4,24,96], n3(:,713), t3x96(:,:,347))
  call heltable([4,24,96], n3(:,714), t3x96(:,:,348))
  call heltable([4,24,96], n3(:,715), t3x96(:,:,349))
  call heltable([8,12,96], n3(:,716), t3x96(:,:,350))
  call heltable([8,12,96], n3(:,717), t3x96(:,:,351))
  call heltable([8,12,96], n3(:,718), t3x96(:,:,352))
  call heltable([8,12,96], n3(:,719), t3x96(:,:,353))
  call heltable([8,12,96], n3(:,720), t3x96(:,:,354))
  call heltable([8,12,96], n3(:,721), t3x96(:,:,355))
  call heltable([12,8,96], n3(:,722), t3x96(:,:,356))
  call heltable([12,8,96], n3(:,723), t3x96(:,:,357))
  call heltable([12,8,96], n3(:,724), t3x96(:,:,358))
  call heltable([12,8,96], n3(:,725), t3x96(:,:,359))
  call heltable([12,8,96], n3(:,726), t3x96(:,:,360))
  call heltable([8,12,96], n3(:,727), t3x96(:,:,361))
  call heltable([8,12,96], n3(:,728), t3x96(:,:,362))
  call heltable([8,12,96], n3(:,729), t3x96(:,:,363))
  call heltable([8,12,96], n3(:,730), t3x96(:,:,364))
  call heltable([8,12,96], n3(:,731), t3x96(:,:,365))
  call heltable([8,12,96], n3(:,732), t3x96(:,:,366))
  call heltable([8,12,96], n3(:,733), t3x96(:,:,367))
  call heltable([8,12,96], n3(:,734), t3x96(:,:,368))
  call heltable([8,12,96], n3(:,735), t3x96(:,:,369))
  call heltable([8,12,96], n3(:,736), t3x96(:,:,370))
  call heltable([8,12,96], n3(:,737), t3x96(:,:,371))
  call heltable([8,12,96], n3(:,738), t3x96(:,:,372))
  call heltable([8,12,96], n3(:,739), t3x96(:,:,373))
  call heltable([8,12,96], n3(:,740), t3x96(:,:,374))
  call heltable([8,12,96], n3(:,741), t3x96(:,:,375))
  call heltable([8,12,96], n3(:,742), t3x96(:,:,376))
  call heltable([8,12,96], n3(:,743), t3x96(:,:,377))
  call heltable([8,12,96], n3(:,744), t3x96(:,:,378))
  call heltable([8,12,96], n3(:,745), t3x96(:,:,379))
  call heltable([8,12,96], n3(:,746), t3x96(:,:,380))
  call heltable([6,16,96], n3(:,747), t3x96(:,:,381))
  call heltable([6,16,96], n3(:,748), t3x96(:,:,382))
  call heltable([6,16,96], n3(:,749), t3x96(:,:,383))
  call heltable([12,8,96], n3(:,750), t3x96(:,:,384))
  call heltable([12,8,96], n3(:,751), t3x96(:,:,385))
  call heltable([12,8,96], n3(:,752), t3x96(:,:,386))
  call heltable([8,12,96], n3(:,753), t3x96(:,:,387))
  call heltable([12,8,96], n3(:,754), t3x96(:,:,388))
  call heltable([8,12,96], n3(:,755), t3x96(:,:,389))
  call heltable([8,12,96], n3(:,756), t3x96(:,:,390))
  call heltable([8,12,96], n3(:,757), t3x96(:,:,391))
  call heltable([8,12,96], n3(:,758), t3x96(:,:,392))
  call heltable([8,12,96], n3(:,759), t3x96(:,:,393))
  call heltable([8,12,96], n3(:,760), t3x96(:,:,394))
  call heltable([8,12,96], n3(:,761), t3x96(:,:,395))
  call heltable([8,12,96], n3(:,762), t3x96(:,:,396))
  call heltable([12,8,96], n3(:,763), t3x96(:,:,397))
  call heltable([12,8,96], n3(:,764), t3x96(:,:,398))
  call heltable([12,8,96], n3(:,765), t3x96(:,:,399))
  call heltable([8,12,96], n3(:,766), t3x96(:,:,400))
  call heltable([12,8,96], n3(:,767), t3x96(:,:,401))
  call heltable([8,12,96], n3(:,768), t3x96(:,:,402))
  call heltable([8,12,96], n3(:,769), t3x96(:,:,403))
  call heltable([8,12,96], n3(:,770), t3x96(:,:,404))
  call heltable([8,12,96], n3(:,771), t3x96(:,:,405))
  call heltable([8,12,96], n3(:,772), t3x96(:,:,406))
  call heltable([8,12,96], n3(:,773), t3x96(:,:,407))
  call heltable([8,12,96], n3(:,774), t3x96(:,:,408))
  call heltable([8,12,96], n3(:,775), t3x96(:,:,409))
  call heltable([6,16,96], n3(:,776), t3x96(:,:,410))
  call heltable([16,6,96], n3(:,777), t3x96(:,:,411))
  call heltable([6,16,96], n3(:,778), t3x96(:,:,412))
  call heltable([6,16,96], n3(:,779), t3x96(:,:,413))
  call heltable([16,6,96], n3(:,780), t3x96(:,:,414))
  call heltable([24,4,96], n3(:,781), t3x96(:,:,415))
  call heltable([24,4,96], n3(:,782), t3x96(:,:,416))
  call heltable([24,4,96], n3(:,783), t3x96(:,:,417))
  call heltable([24,4,96], n3(:,784), t3x96(:,:,418))
  call heltable([24,4,96], n3(:,785), t3x96(:,:,419))
  call heltable([24,4,96], n3(:,786), t3x96(:,:,420))
  call heltable([4,24,96], n3(:,787), t3x96(:,:,421))
  call heltable([24,4,96], n3(:,788), t3x96(:,:,422))
  call heltable([4,24,96], n3(:,789), t3x96(:,:,423))
  call heltable([4,24,96], n3(:,790), t3x96(:,:,424))
  call heltable([24,4,96], n3(:,791), t3x96(:,:,425))
  call heltable([8,12,96], n3(:,792), t3x96(:,:,426))
  call heltable([8,12,96], n3(:,793), t3x96(:,:,427))
  call heltable([8,12,96], n3(:,794), t3x96(:,:,428))
  call heltable([8,12,96], n3(:,795), t3x96(:,:,429))
  call heltable([8,12,96], n3(:,796), t3x96(:,:,430))
  call heltable([8,12,96], n3(:,797), t3x96(:,:,431))
  call heltable([12,8,96], n3(:,798), t3x96(:,:,432))
  call heltable([12,8,96], n3(:,799), t3x96(:,:,433))
  call heltable([12,8,96], n3(:,800), t3x96(:,:,434))
  call heltable([12,8,96], n3(:,801), t3x96(:,:,435))
  call heltable([12,8,96], n3(:,802), t3x96(:,:,436))
  call heltable([12,8,96], n3(:,803), t3x96(:,:,437))
  call heltable([12,8,96], n3(:,804), t3x96(:,:,438))
  call heltable([12,8,96], n3(:,805), t3x96(:,:,439))
  call heltable([12,8,96], n3(:,806), t3x96(:,:,440))
  call heltable([12,8,96], n3(:,807), t3x96(:,:,441))
  call heltable([12,8,96], n3(:,808), t3x96(:,:,442))
  call heltable([4,24,96], n3(:,809), t3x96(:,:,443))
  call heltable([24,4,96], n3(:,810), t3x96(:,:,444))
  call heltable([4,24,96], n3(:,811), t3x96(:,:,445))
  call heltable([4,24,96], n3(:,812), t3x96(:,:,446))
  call heltable([24,4,96], n3(:,813), t3x96(:,:,447))
  call heltable([4,24,96], n3(:,814), t3x96(:,:,448))
  call heltable([4,24,96], n3(:,815), t3x96(:,:,449))
  call heltable([4,24,96], n3(:,816), t3x96(:,:,450))
  call heltable([4,24,96], n3(:,817), t3x96(:,:,451))
  call heltable([4,24,96], n3(:,818), t3x96(:,:,452))
  call heltable([4,24,96], n3(:,819), t3x96(:,:,453))
  call heltable([6,16,96], n3(:,820), t3x96(:,:,454))
  call heltable([16,6,96], n3(:,821), t3x96(:,:,455))
  call heltable([6,16,96], n3(:,822), t3x96(:,:,456))
  call heltable([6,16,96], n3(:,823), t3x96(:,:,457))
  call heltable([16,6,96], n3(:,824), t3x96(:,:,458))
  call heltable([12,8,96], n3(:,825), t3x96(:,:,459))
  call heltable([12,8,96], n3(:,826), t3x96(:,:,460))
  call heltable([12,8,96], n3(:,827), t3x96(:,:,461))
  call heltable([12,8,96], n3(:,828), t3x96(:,:,462))
  call heltable([12,8,96], n3(:,829), t3x96(:,:,463))
  call heltable([12,8,96], n3(:,830), t3x96(:,:,464))
  call heltable([8,12,96], n3(:,831), t3x96(:,:,465))
  call heltable([12,8,96], n3(:,832), t3x96(:,:,466))
  call heltable([12,8,96], n3(:,833), t3x96(:,:,467))
  call heltable([12,8,96], n3(:,834), t3x96(:,:,468))
  call heltable([12,8,96], n3(:,835), t3x96(:,:,469))
  call heltable([12,8,96], n3(:,836), t3x96(:,:,470))
  call heltable([8,12,96], n3(:,837), t3x96(:,:,471))
  call heltable([8,12,96], n3(:,838), t3x96(:,:,472))
  call heltable([8,12,96], n3(:,839), t3x96(:,:,473))
  call heltable([8,12,96], n3(:,840), t3x96(:,:,474))
  call heltable([8,12,96], n3(:,841), t3x96(:,:,475))
  call heltable([12,8,96], n3(:,842), t3x96(:,:,476))
  call heltable([12,8,96], n3(:,843), t3x96(:,:,477))
  call heltable([12,8,96], n3(:,844), t3x96(:,:,478))
  call heltable([12,8,96], n3(:,845), t3x96(:,:,479))
  call heltable([12,8,96], n3(:,846), t3x96(:,:,480))
  call heltable([12,8,96], n3(:,847), t3x96(:,:,481))
  call heltable([8,12,96], n3(:,848), t3x96(:,:,482))
  call heltable([8,12,96], n3(:,849), t3x96(:,:,483))
  call heltable([8,12,96], n3(:,850), t3x96(:,:,484))
  call heltable([8,12,96], n3(:,851), t3x96(:,:,485))
  call heltable([8,12,96], n3(:,852), t3x96(:,:,486))
  call heltable([12,8,96], n3(:,853), t3x96(:,:,487))
  call heltable([12,8,96], n3(:,854), t3x96(:,:,488))
  call heltable([12,8,96], n3(:,855), t3x96(:,:,489))
  call heltable([12,8,96], n3(:,856), t3x96(:,:,490))
  call heltable([12,8,96], n3(:,857), t3x96(:,:,491))
  call heltable([12,8,96], n3(:,858), t3x96(:,:,492))
  call heltable([8,12,96], n3(:,859), t3x96(:,:,493))
  call heltable([8,12,96], n3(:,860), t3x96(:,:,494))
  call heltable([8,12,96], n3(:,861), t3x96(:,:,495))
  call heltable([8,12,96], n3(:,862), t3x96(:,:,496))
  call heltable([8,12,96], n3(:,863), t3x96(:,:,497))
  call heltable([8,12,96], n3(:,864), t3x96(:,:,498))
  call heltable([8,12,96], n3(:,865), t3x96(:,:,499))
  call heltable([12,8,96], n3(:,866), t3x96(:,:,500))
  call heltable([12,8,96], n3(:,867), t3x96(:,:,501))
  call heltable([12,8,96], n3(:,868), t3x96(:,:,502))
  call heltable([12,8,96], n3(:,869), t3x96(:,:,503))
  call heltable([12,8,96], n3(:,870), t3x96(:,:,504))
  call heltable([12,8,96], n3(:,871), t3x96(:,:,505))
  call heltable([12,8,96], n3(:,872), t3x96(:,:,506))
  call heltable([12,8,96], n3(:,873), t3x96(:,:,507))
  call heltable([12,8,96], n3(:,874), t3x96(:,:,508))
  call heltable([12,8,96], n3(:,875), t3x96(:,:,509))
  call heltable([12,8,96], n3(:,876), t3x96(:,:,510))
  call heltable([12,8,96], n3(:,877), t3x96(:,:,511))
  call heltable([12,8,96], n3(:,878), t3x96(:,:,512))
  call heltable([12,8,96], n3(:,879), t3x96(:,:,513))
  call heltable([12,8,96], n3(:,880), t3x96(:,:,514))
  call heltable([12,8,96], n3(:,881), t3x96(:,:,515))
  call heltable([12,8,96], n3(:,882), t3x96(:,:,516))
  call heltable([12,8,96], n3(:,883), t3x96(:,:,517))
  call heltable([12,8,96], n3(:,884), t3x96(:,:,518))
  call heltable([12,8,96], n3(:,885), t3x96(:,:,519))
  call heltable([12,8,96], n3(:,886), t3x96(:,:,520))
  call heltable([12,8,96], n3(:,887), t3x96(:,:,521))
  call heltable([12,8,96], n3(:,888), t3x96(:,:,522))
  call heltable([12,8,96], n3(:,889), t3x96(:,:,523))
  call heltable([12,8,96], n3(:,890), t3x96(:,:,524))
  call heltable([12,8,96], n3(:,891), t3x96(:,:,525))
  call heltable([12,8,96], n3(:,892), t3x96(:,:,526))
  call heltable([12,8,96], n3(:,893), t3x96(:,:,527))
  call heltable([12,8,96], n3(:,894), t3x96(:,:,528))
  call heltable([12,8,96], n3(:,895), t3x96(:,:,529))
  call heltable([12,8,96], n3(:,896), t3x96(:,:,530))
  call heltable([12,8,96], n3(:,897), t3x96(:,:,531))
  call heltable([12,8,96], n3(:,898), t3x96(:,:,532))
  call heltable([12,8,96], n3(:,899), t3x96(:,:,533))
  call heltable([12,8,96], n3(:,900), t3x96(:,:,534))
  call heltable([12,8,96], n3(:,901), t3x96(:,:,535))
  call heltable([8,12,96], n3(:,902), t3x96(:,:,536))
  call heltable([8,12,96], n3(:,903), t3x96(:,:,537))
  call heltable([8,12,96], n3(:,904), t3x96(:,:,538))
  call heltable([8,12,96], n3(:,905), t3x96(:,:,539))
  call heltable([8,12,96], n3(:,906), t3x96(:,:,540))
  call heltable([8,12,96], n3(:,907), t3x96(:,:,541))
  call heltable([8,12,96], n3(:,908), t3x96(:,:,542))
  call heltable([8,12,96], n3(:,909), t3x96(:,:,543))
  call heltable([8,12,96], n3(:,910), t3x96(:,:,544))
  call heltable([8,12,96], n3(:,911), t3x96(:,:,545))
  call heltable([8,12,96], n3(:,912), t3x96(:,:,546))
  call heltable([8,12,96], n3(:,913), t3x96(:,:,547))
  call heltable([24,4,96], n3(:,914), t3x96(:,:,548))
  call heltable([24,4,96], n3(:,915), t3x96(:,:,549))
  call heltable([4,24,96], n3(:,916), t3x96(:,:,550))
  call heltable([24,4,96], n3(:,917), t3x96(:,:,551))
  call heltable([6,16,96], n3(:,918), t3x96(:,:,552))
  call heltable([16,6,96], n3(:,919), t3x96(:,:,553))
  call heltable([12,8,96], n3(:,920), t3x96(:,:,554))
  call heltable([12,8,96], n3(:,921), t3x96(:,:,555))
  call heltable([12,8,96], n3(:,922), t3x96(:,:,556))
  call heltable([12,8,96], n3(:,923), t3x96(:,:,557))
  call heltable([8,12,96], n3(:,924), t3x96(:,:,558))
  call heltable([8,12,96], n3(:,925), t3x96(:,:,559))
  call heltable([8,12,96], n3(:,926), t3x96(:,:,560))
  call heltable([8,12,96], n3(:,927), t3x96(:,:,561))
  call heltable([8,12,96], n3(:,928), t3x96(:,:,562))
  call heltable([8,12,96], n3(:,929), t3x96(:,:,563))
  call heltable([8,12,96], n3(:,930), t3x96(:,:,564))
  call heltable([8,12,96], n3(:,931), t3x96(:,:,565))
  call heltable([8,12,96], n3(:,932), t3x96(:,:,566))
  call heltable([12,8,96], n3(:,933), t3x96(:,:,567))
  call heltable([12,8,96], n3(:,934), t3x96(:,:,568))
  call heltable([12,8,96], n3(:,935), t3x96(:,:,569))
  call heltable([12,8,96], n3(:,936), t3x96(:,:,570))
  call heltable([12,8,96], n3(:,937), t3x96(:,:,571))
  call heltable([12,8,96], n3(:,938), t3x96(:,:,572))
  call heltable([12,8,96], n3(:,939), t3x96(:,:,573))
  call heltable([12,8,96], n3(:,940), t3x96(:,:,574))
  call heltable([12,8,96], n3(:,941), t3x96(:,:,575))
  call heltable([12,8,96], n3(:,942), t3x96(:,:,576))
  call heltable([12,8,96], n3(:,943), t3x96(:,:,577))
  call heltable([12,8,96], n3(:,944), t3x96(:,:,578))
  call heltable([12,8,96], n3(:,945), t3x96(:,:,579))
  call heltable([12,8,96], n3(:,946), t3x96(:,:,580))
  call heltable([12,8,96], n3(:,947), t3x96(:,:,581))
  call heltable([8,12,96], n3(:,948), t3x96(:,:,582))
  call heltable([8,12,96], n3(:,949), t3x96(:,:,583))
  call heltable([8,12,96], n3(:,950), t3x96(:,:,584))
  call heltable([8,12,96], n3(:,951), t3x96(:,:,585))
  call heltable([8,12,96], n3(:,952), t3x96(:,:,586))
  call heltable([8,12,96], n3(:,953), t3x96(:,:,587))
  call heltable([8,12,96], n3(:,954), t3x96(:,:,588))
  call heltable([12,8,96], n3(:,955), t3x96(:,:,589))
  call heltable([12,8,96], n3(:,956), t3x96(:,:,590))
  call heltable([12,8,96], n3(:,957), t3x96(:,:,591))
  call heltable([12,8,96], n3(:,958), t3x96(:,:,592))
  call heltable([12,8,96], n3(:,959), t3x96(:,:,593))
  call heltable([12,8,96], n3(:,960), t3x96(:,:,594))
  call heltable([12,8,96], n3(:,961), t3x96(:,:,595))
  call heltable([12,8,96], n3(:,962), t3x96(:,:,596))
  call heltable([12,8,96], n3(:,963), t3x96(:,:,597))
  call heltable([12,8,96], n3(:,964), t3x96(:,:,598))
  call heltable([12,8,96], n3(:,965), t3x96(:,:,599))
  call heltable([12,8,96], n3(:,966), t3x96(:,:,600))
  call heltable([12,8,96], n3(:,967), t3x96(:,:,601))
  call heltable([12,8,96], n3(:,968), t3x96(:,:,602))
  call heltable([12,8,96], n3(:,969), t3x96(:,:,603))
  call heltable([8,12,96], n3(:,970), t3x96(:,:,604))
  call heltable([8,12,96], n3(:,971), t3x96(:,:,605))
  call heltable([8,12,96], n3(:,972), t3x96(:,:,606))
  call heltable([8,12,96], n3(:,973), t3x96(:,:,607))
  call heltable([8,12,96], n3(:,974), t3x96(:,:,608))
  call heltable([8,12,96], n3(:,975), t3x96(:,:,609))
  call heltable([8,12,96], n3(:,976), t3x96(:,:,610))
  call heltable([12,8,96], n3(:,977), t3x96(:,:,611))
  call heltable([12,8,96], n3(:,978), t3x96(:,:,612))
  call heltable([12,8,96], n3(:,979), t3x96(:,:,613))
  call heltable([12,8,96], n3(:,980), t3x96(:,:,614))
  call heltable([12,8,96], n3(:,981), t3x96(:,:,615))
  call heltable([12,8,96], n3(:,982), t3x96(:,:,616))
  call heltable([12,8,96], n3(:,983), t3x96(:,:,617))
  call heltable([12,8,96], n3(:,984), t3x96(:,:,618))
  call heltable([12,8,96], n3(:,985), t3x96(:,:,619))
  call heltable([12,8,96], n3(:,986), t3x96(:,:,620))
  call heltable([12,8,96], n3(:,987), t3x96(:,:,621))
  call heltable([8,12,96], n3(:,988), t3x96(:,:,622))
  call heltable([8,12,96], n3(:,989), t3x96(:,:,623))
  call heltable([8,12,96], n3(:,990), t3x96(:,:,624))
  call heltable([8,12,96], n3(:,991), t3x96(:,:,625))
  call heltable([8,12,96], n3(:,992), t3x96(:,:,626))
  call heltable([12,8,96], n3(:,993), t3x96(:,:,627))
  call heltable([12,8,96], n3(:,994), t3x96(:,:,628))
  call heltable([12,8,96], n3(:,995), t3x96(:,:,629))
  call heltable([12,8,96], n3(:,996), t3x96(:,:,630))
  call heltable([12,8,96], n3(:,997), t3x96(:,:,631))
  call heltable([12,8,96], n3(:,998), t3x96(:,:,632))
  call heltable([12,8,96], n3(:,999), t3x96(:,:,633))
  call heltable([12,8,96], n3(:,1000), t3x96(:,:,634))
  call heltable([12,8,96], n3(:,1001), t3x96(:,:,635))
  call heltable([12,8,96], n3(:,1002), t3x96(:,:,636))
  call heltable([12,8,96], n3(:,1003), t3x96(:,:,637))
  call heltable([12,8,96], n3(:,1004), t3x96(:,:,638))
  call heltable([12,8,96], n3(:,1005), t3x96(:,:,639))
  call heltable([8,12,96], n3(:,1006), t3x96(:,:,640))
  call heltable([8,12,96], n3(:,1007), t3x96(:,:,641))
  call heltable([8,12,96], n3(:,1008), t3x96(:,:,642))
  call heltable([8,12,96], n3(:,1009), t3x96(:,:,643))
  call heltable([12,8,96], n3(:,1010), t3x96(:,:,644))
  call heltable([12,8,96], n3(:,1011), t3x96(:,:,645))
  call heltable([12,8,96], n3(:,1012), t3x96(:,:,646))
  call heltable([12,8,96], n3(:,1013), t3x96(:,:,647))
  call heltable([8,12,96], n3(:,1014), t3x96(:,:,648))
  call heltable([8,12,96], n3(:,1015), t3x96(:,:,649))
  call heltable([8,12,96], n3(:,1016), t3x96(:,:,650))
  call heltable([8,12,96], n3(:,1017), t3x96(:,:,651))
  call heltable([8,12,96], n3(:,1018), t3x96(:,:,652))
  call heltable([8,12,96], n3(:,1019), t3x96(:,:,653))
  call heltable([8,12,96], n3(:,1020), t3x96(:,:,654))
  call heltable([8,12,96], n3(:,1021), t3x96(:,:,655))
  call heltable([8,12,96], n3(:,1022), t3x96(:,:,656))
  call heltable([8,12,96], n3(:,1023), t3x96(:,:,657))
  call heltable([8,12,96], n3(:,1024), t3x96(:,:,658))
  call heltable([8,12,96], n3(:,1025), t3x96(:,:,659))
  call heltable([8,12,96], n3(:,1026), t3x96(:,:,660))
  call heltable([12,8,96], n3(:,1027), t3x96(:,:,661))
  call heltable([12,8,96], n3(:,1028), t3x96(:,:,662))
  call heltable([12,8,96], n3(:,1029), t3x96(:,:,663))
  call heltable([12,8,96], n3(:,1030), t3x96(:,:,664))
  call heltable([12,8,96], n3(:,1031), t3x96(:,:,665))
  call heltable([8,12,96], n3(:,1032), t3x96(:,:,666))
  call heltable([8,12,96], n3(:,1033), t3x96(:,:,667))
  call heltable([8,12,96], n3(:,1034), t3x96(:,:,668))
  call heltable([8,12,96], n3(:,1035), t3x96(:,:,669))
  call heltable([8,12,96], n3(:,1036), t3x96(:,:,670))
  call heltable([8,12,96], n3(:,1037), t3x96(:,:,671))
  call heltable([8,12,96], n3(:,1038), t3x96(:,:,672))
  call heltable([8,12,96], n3(:,1039), t3x96(:,:,673))
  call heltable([8,12,96], n3(:,1040), t3x96(:,:,674))
  call heltable([8,12,96], n3(:,1041), t3x96(:,:,675))
  call heltable([8,12,96], n3(:,1042), t3x96(:,:,676))
  call heltable([12,8,96], n3(:,1043), t3x96(:,:,677))
  call heltable([12,8,96], n3(:,1044), t3x96(:,:,678))
  call heltable([12,8,96], n3(:,1045), t3x96(:,:,679))
  call heltable([12,8,96], n3(:,1046), t3x96(:,:,680))
  call heltable([12,8,96], n3(:,1047), t3x96(:,:,681))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_OLR_ppwttj_ew_uxttxdwxg_3
