
module ol_vamp_3_ppwttj_uxttxdwxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwttj_uxttxdwxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwttj_uxttxdwxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwttj_uxttxdwxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwttj_uxttxdwxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwttj_uxttxdwxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwttj_uxttxdwxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(4,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(40),m3h2x48(:,108),heltab2x96(:,:,199))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(3,:)%j) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(215),h0tab(:,215),[32,2,29],[nMT,0,nMT],3,1,wf24(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,109),heltab2x96(:,:,200))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(41),n2h48(64))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(4)*M(3,:)%j) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(216),h0tab(:,216),[32,2,29],[0,nMT,0],3,1,wf24(:,23))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(42),m3h2x48(:,110),heltab2x96(:,:,201))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(4,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(217),h0tab(:,217),[57,2,4],[nMT,0,nMT],3,1,wf24(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,24),G0H4(7),m3h24x4(:,9),heltab2x96(:,:,202))
  call Hloop_A_Q(ntryL,G0H4(7),57,nMT,G1H4(31),n2h4(42))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(4,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(218),h0tab(:,218),[57,2,4],[0,nMT,0],3,1,wf24(:,24))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,24),57,G1H4(37),m3h24x4(:,10),heltab2x96(:,:,203))
  Gcoeff(:)%j = (c(10)*M(2,:)%j-c(11)*M(4,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(219),h0tab(:,219),[57,2,4],[nMT,0,nMT],3,1,wf24(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,25),G0H4(7),m3h24x4(:,11),heltab2x96(:,:,204))
  call Hloop_A_Q(ntryL,G0H4(7),57,nMT,G1H4(27),n2h4(43))
  Gcoeff(:)%j = (c(4)*M(2,:)%j-c(6)*M(4,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(220),h0tab(:,220),[57,2,4],[0,nMT,0],3,1,wf24(:,25))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,25),57,G1H4(15),m3h24x4(:,12),heltab2x96(:,:,205))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(10)*M(2,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(221),h0tab(:,221),[57,2,4],[nMT,0,nMT],3,1,wf24(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,26),G0H4(7),m3h24x4(:,13),heltab2x96(:,:,206))
  call Hloop_A_Q(ntryL,G0H4(7),57,nMT,G1H4(29),n2h4(44))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(4)*M(2,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(222),h0tab(:,222),[57,2,4],[0,nMT,0],3,1,wf24(:,26))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,26),57,G1H4(23),m3h24x4(:,14),heltab2x96(:,:,207))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(3,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(223),h0tab(:,223),[39,8,16],[0,0,0],3,1,wf16(:,17))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,17),G0H6(7),m3h16x6(:,7),heltab2x96(:,:,208))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(3,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(224),h0tab(:,224),[46,1,16],[0,0,0],3,1,wf16(:,19))
  call Hloop_AQ_V(ntryL,G0H96(1),wf16(:,19),G0H6(8),m3h16x6(:,8),heltab2x96(:,:,209))
  Gcoeff(:)%j = (-(c(13)*M(3,:)%j)+c(18)*M(4,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(225),h0tab(:,225),[39,8,16],[0,0,0],3,1,wf16(:,21))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,21),G0H6(9),m3h16x6(:,9),heltab2x96(:,:,210))
  Gcoeff(:)%j = (-(c(13)*M(3,:)%j)+c(18)*M(4,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(226),h0tab(:,226),[46,1,16],[0,0,0],3,1,wf16(:,23))
  call Hloop_AQ_V(ntryL,G0H96(1),wf16(:,23),G0H6(10),m3h16x6(:,10),heltab2x96(:,:,211))
  Gcoeff(:)%j = (c(10)*M(2,:)%j-c(11)*M(4,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(227),h0tab(:,227),[57,2,4],[nMT,0,nMT],3,1,wf24(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,27),G0H4(7),m3h24x4(:,15),heltab2x96(:,:,212))
  call Hloop_A_Q(ntryL,G0H4(7),57,nMT,G1H4(7),n2h4(45))
  Gcoeff(:)%j = (c(4)*M(2,:)%j-c(6)*M(4,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(228),h0tab(:,228),[57,2,4],[0,nMT,0],3,1,wf24(:,27))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,27),57,G1H4(20),m3h24x4(:,16),heltab2x96(:,:,213))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(22),[G1H6(71),G1H6(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(10),G1H8(12),G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(58),[G1H12(53),G1H12(46),G1H12(48),G0H12(1),G0H12(2) &
    ,G0H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(6),[G1H12(14),G1H12(51),G1H12(12),G0H12(6),G0H12(5) &
    ,G0H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(24),[G1H24(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(19),[G1H24(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(23),G1H4(15),G1H4(37),G1H4(8),G1H4(3),G1H4(18) &
    ,G1H4(39),G0H4(6),G0H4(5),G0H4(4),G0H4(3),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(5),[G1H48(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(7),[G1H48(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(5),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(54),[G1H12(52),G1H12(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(22),[G1H48(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(24),[G1H48(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(22),[G1H12(23),G1H12(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(3),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(9),[G0H6(7),G0H6(4),G0H6(3),G0H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(10),[G0H6(8),G0H6(6),G0H6(5),G0H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(29),G1H4(27),G1H4(31),G1H4(11),G1H4(1),G1H4(21) &
    ,G1H4(38)])
  call Hloop_AW_Q(ntryL,G1H6(22),ex5(:),G1H2(4),m3h3x2(:,66),heltab2x6(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(4),55,0,G2H2(92),n2h2(128))
  call Hloop_QW_A(ntryL,G1H6(44),ex5(:),G1H2(58),m3h3x2(:,67),heltab2x6(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(58),62,0,G2H2(9),n2h2(129))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,1),G1H2(16),m3h4x2(:,16),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(16),55,0,G2H2(12),n2h2(130))
  call Hloop_VQ_A(ntryL,G1H12(58),ex4(:),G1H6(31),m3h2x6(:,67),heltab2x12(:,:,148))
  call Hloop_Q_A(ntryL,G1H6(31),46,0,G2H6(7),n2h6(75))
  call Hloop_VA_Q(ntryL,G1H12(57),wf6(:,2),G1H2(59),m3h6x2(:,23),heltab2x12(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(59),55,0,G2H2(15),n2h2(131))
  call Hloop_VA_Q(ntryL,G1H12(6),ex1(:),G1H6(65),m3h2x6(:,68),heltab2x12(:,:,150))
  call Hloop_A_Q(ntryL,G1H6(65),39,0,G2H6(14),n2h6(76))
  call Hloop_QV_A(ntryL,G1H24(24),wf4(:,1),G1H6(59),m3h4x6(:,19),heltab2x24(:,:,121))
  call Hloop_Q_A(ntryL,G1H6(59),46,0,G2H6(20),n2h6(77))
  call Hloop_AV_Q(ntryL,G1H24(19),wf4(:,1),G1H6(62),m3h4x6(:,20),heltab2x24(:,:,122))
  call Hloop_A_Q(ntryL,G1H6(62),39,0,G2H6(2),n2h6(78))
  call Hloop_AW_Q(ntryL,G1H24(13),ex5(:),G1H8(11),m3h3x8(:,24),heltab2x24(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(11),49,0,G2H8(3),n2h8(37))
  call Hloop_QV_A(ntryL,G1H24(16),wf12(:,1),G1H2(29),m3h12x2(:,9),heltab2x24(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(29),59,nMT,G2H2(18),n2h2(132))
  call Hloop_QV_A(ntryL,G1H24(22),wf12(:,4),G1H2(41),m3h12x2(:,10),heltab2x24(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(41),59,nMT,G2H2(21),n2h2(133))
  call Hloop_VQ_A(ntryL,G1H4(20),ex2(:),G1H2(35),m3h2x2(:,67),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(35),59,nMT,G2H2(22),n2h2(134))
  call Hloop_UV_W(ntryL,G0H24(3),40,wf4(:,1),6,G1H6(24),m3h4x6(:,21),heltab2x24(:,:,126))
  call Hloop_AV_Q(ntryL,G1H48(5),wf4(:,1),G1H12(10),m3h4x12(:,11),heltab2x48(:,:,69))
  call Hloop_A_Q(ntryL,G1H12(10),38,0,G2H12(7),n2h12(71))
  call Hloop_AV_Q(ntryL,G1H48(2),wf4(:,1),G1H12(16),m3h4x12(:,12),heltab2x48(:,:,70))
  call Hloop_A_Q(ntryL,G1H12(16),38,nMT,G2H12(8),n2h12(72))
  call Hloop_QV_A(ntryL,G1H48(7),wf4(:,1),G1H12(19),m3h4x12(:,13),heltab2x48(:,:,71))
  call Hloop_Q_A(ntryL,G1H12(19),38,0,G2H12(3),n2h12(73))
  call Hloop_QV_A(ntryL,G1H48(4),wf4(:,1),G1H12(27),m3h4x12(:,14),heltab2x48(:,:,72))
  call Hloop_Q_A(ntryL,G1H12(27),38,nMT,G2H12(2),n2h12(74))
  call Hloop_AV_Q(ntryL,G1H48(6),wf4(:,1),G1H12(8),m3h4x12(:,15),heltab2x48(:,:,73))
  call Hloop_A_Q(ntryL,G1H12(8),38,nMB,G2H12(5),n2h12(75))
  call Hloop_QV_A(ntryL,G1H48(8),wf4(:,1),G1H12(13),m3h4x12(:,16),heltab2x48(:,:,74))
  call Hloop_Q_A(ntryL,G1H12(13),38,nMB,G2H12(1),n2h12(76))
  call Hloop_DV_C(ntryL,G1H48(9),32,wf4(:,1),G2H12(6),m3h4x12(:,17),heltab2x48(:,:,75))
  call Hloop_CV_D(ntryL,G1H48(10),32,wf4(:,1),6,G2H12(4),m3h4x12(:,18),heltab2x48(:,:,76))
  call Hloop_UV_W(ntryL,G1H48(11),32,wf4(:,1),6,G2H12(9),m3h4x12(:,19),heltab2x48(:,:,77))
  call Hloop_UV_W(ntryL,G0H8(5),49,wf4(:,1),6,G1H2(47),m3h4x2(:,17),heltab2x8(:,:,43))
  call Hloop_AQ_V(ntryL,G1H48(12),wf8(:,3),G1H6(81),m3h8x6(:,4),heltab2x48(:,:,78))
  call Hloop_VQ_A(ntryL,G1H48(13),wf8(:,3),G1H6(66),m3h8x6(:,5),heltab2x48(:,:,79))
  call Hloop_Q_A(ntryL,G1H6(66),46,0,G2H6(17),n2h6(79))
  call Hloop_AQ_V(ntryL,G1H12(54),ex4(:),G1H6(4),m3h2x6(:,69),heltab2x12(:,:,151))
  call Hloop_AQ_V(ntryL,G1H48(14),ex4(:),G1H24(11),m3h2x24(:,56),heltab2x48(:,:,80))
  call Hloop_VQ_A(ntryL,G1H48(15),ex4(:),G1H24(6),m3h2x24(:,57),heltab2x48(:,:,81))
  call Hloop_Q_A(ntryL,G1H24(6),40,0,G2H24(11),n2h24(51))
  call Hloop_UV_W(ntryL,G0H24(5),33,wf4(:,1),6,G1H6(78),m3h4x6(:,22),heltab2x24(:,:,127))
  call Hloop_QA_V(ntryL,G1H48(16),wf8(:,5),G1H6(83),m3h8x6(:,6),heltab2x48(:,:,82))
  call Hloop_VA_Q(ntryL,G1H48(17),wf8(:,5),G1H6(79),m3h8x6(:,7),heltab2x48(:,:,83))
  call Hloop_A_Q(ntryL,G1H6(79),39,0,G2H6(12),n2h6(80))
  call Hloop_QV_A(ntryL,G1H48(22),wf4(:,1),G1H12(31),m3h4x12(:,20),heltab2x48(:,:,84))
  call Hloop_Q_A(ntryL,G1H12(31),38,0,G2H12(10),n2h12(77))
  call Hloop_QV_A(ntryL,G1H48(19),wf4(:,1),G1H12(37),m3h4x12(:,21),heltab2x48(:,:,85))
  call Hloop_Q_A(ntryL,G1H12(37),38,nMT,G2H12(11),n2h12(78))
  call Hloop_AV_Q(ntryL,G1H48(24),wf4(:,1),G1H12(44),m3h4x12(:,22),heltab2x48(:,:,86))
  call Hloop_A_Q(ntryL,G1H12(44),38,0,G2H12(12),n2h12(79))
  call Hloop_AV_Q(ntryL,G1H48(21),wf4(:,1),G1H12(49),m3h4x12(:,23),heltab2x48(:,:,87))
  call Hloop_A_Q(ntryL,G1H12(49),38,nMT,G2H12(13),n2h12(80))
  call Hloop_QV_A(ntryL,G1H48(23),wf4(:,1),G1H12(56),m3h4x12(:,24),heltab2x48(:,:,88))
  call Hloop_Q_A(ntryL,G1H12(56),38,nMB,G2H12(14),n2h12(81))
  call Hloop_AV_Q(ntryL,G1H48(25),wf4(:,1),G1H12(50),m3h4x12(:,25),heltab2x48(:,:,89))
  call Hloop_A_Q(ntryL,G1H12(50),38,nMB,G2H12(15),n2h12(82))
  call Hloop_CV_D(ntryL,G1H48(26),32,wf4(:,1),6,G2H12(16),m3h4x12(:,26),heltab2x48(:,:,90))
  call Hloop_DV_C(ntryL,G1H48(27),32,wf4(:,1),G2H12(17),m3h4x12(:,27),heltab2x48(:,:,91))
  call Hloop_UV_W(ntryL,G1H48(28),32,wf4(:,1),6,G2H12(18),m3h4x12(:,28),heltab2x48(:,:,92))
  call Hloop_QA_V(ntryL,G1H12(22),ex1(:),G1H6(82),m3h2x6(:,70),heltab2x12(:,:,152))
  call Hloop_VA_Q(ntryL,G0H8(3),ex1(:),G0H4(7),m3h2x4(:,25),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G0H4(7),57,0,G1H4(32),n2h4(46))
  call Hloop_QA_V(ntryL,G1H8(8),ex1(:),G1H4(19),m3h2x4(:,26),heltab2x8(:,:,45))
  call Hloop_QA_V(ntryL,G1H48(29),ex1(:),G1H24(21),m3h2x24(:,58),heltab2x48(:,:,93))
  call Hloop_VA_Q(ntryL,G1H48(30),ex1(:),G1H24(10),m3h2x24(:,59),heltab2x48(:,:,94))
  call Hloop_A_Q(ntryL,G1H24(10),33,0,G2H24(1),n2h24(52))
  call Hloop_VQ_A(ntryL,G0H24(6),wf8(:,3),G0H3(1),m3h8x3(:,4),heltab2x24(:,:,128))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(58),n2h3(47))
  call Hloop_VQ_A(ntryL,G0H6(9),ex4(:),G0H3(1),m3h2x3(:,54),heltab2x6(:,:,177))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(25),n2h3(48))
  call Hloop_VA_Q(ntryL,G0H24(1),wf8(:,5),G0H3(1),m3h8x3(:,5),heltab2x24(:,:,129))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(7),n2h3(49))
  call Hloop_VA_Q(ntryL,G0H6(10),ex1(:),G0H3(1),m3h2x3(:,55),heltab2x6(:,:,178))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(121),n2h3(50))
  call Hloop_AQ_V(ntryL,G1H48(31),ex4(:),G1H24(25),m3h2x24(:,60),heltab2x48(:,:,95))
  call Hloop_VQ_A(ntryL,G1H48(32),ex4(:),G1H24(2),m3h2x24(:,61),heltab2x48(:,:,96))
  call Hloop_Q_A(ntryL,G1H24(2),40,0,G2H24(2),n2h24(53))
  call Hloop_QA_V(ntryL,G1H48(33),ex1(:),G1H24(27),m3h2x24(:,62),heltab2x48(:,:,97))
  call Hloop_VA_Q(ntryL,G1H48(34),ex1(:),G1H24(1),m3h2x24(:,63),heltab2x48(:,:,98))
  call Hloop_A_Q(ntryL,G1H24(1),33,0,G2H24(3),n2h24(54))
  call Hloop_VA_Q(ntryL,G0H24(7),ex3(:),G0H12(7),m3h2x12(:,61),heltab2x24(:,:,130))
  call Hloop_A_Q(ntryL,G0H12(7),38,nMT,G1H12(18),n2h12(83))
  call Hloop_QA_V(ntryL,G1H24(15),ex3(:),G1H12(1),m3h2x12(:,62),heltab2x24(:,:,131))
  call Hloop_VQ_A(ntryL,G0H24(9),ex2(:),G0H12(1),m3h2x12(:,63),heltab2x24(:,:,132))
  call Hloop_Q_A(ntryL,G0H12(1),38,nMT,G1H12(2),n2h12(84))
  call Hloop_AQ_V(ntryL,G1H24(7),ex2(:),G1H12(26),m3h2x12(:,64),heltab2x24(:,:,133))
  call Hloop_AQ_V(ntryL,G1H4(7),ex2(:),G1H2(51),m3h2x2(:,68),heltab2x4(:,:,111))
  call Hloop_QA_V(ntryL,G1H48(35),ex3(:),G1H24(12),m3h2x24(:,64),heltab2x48(:,:,99))
  call Hloop_VA_Q(ntryL,G1H48(36),ex3(:),G1H24(14),m3h2x24(:,65),heltab2x48(:,:,100))
  call Hloop_A_Q(ntryL,G1H24(14),36,nMT,G2H24(4),n2h24(55))
  call Hloop_AQ_V(ntryL,G1H48(37),ex2(:),G1H24(3),m3h2x24(:,66),heltab2x48(:,:,101))
  call Hloop_VQ_A(ntryL,G1H48(38),ex2(:),G1H24(5),m3h2x24(:,67),heltab2x48(:,:,102))
  call Hloop_Q_A(ntryL,G1H24(5),34,nMT,G2H24(5),n2h24(56))
  call Hloop_VA_Q(ntryL,G0H24(11),ex3(:),G0H12(2),m3h2x12(:,65),heltab2x24(:,:,134))
  call Hloop_A_Q(ntryL,G0H12(2),38,nMT,G1H12(30),n2h12(85))
  call Hloop_QA_V(ntryL,G1H24(17),ex3(:),G1H12(28),m3h2x12(:,66),heltab2x24(:,:,135))
  call Hloop_VQ_A(ntryL,G0H24(4),ex2(:),G0H12(3),m3h2x12(:,67),heltab2x24(:,:,136))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMT,G1H12(42),n2h12(86))
  call Hloop_AQ_V(ntryL,G1H24(9),ex2(:),G1H12(40),m3h2x12(:,68),heltab2x24(:,:,137))
  call Hloop_QA_V(ntryL,G1H48(39),ex3(:),G1H24(18),m3h2x24(:,68),heltab2x48(:,:,103))
  call Hloop_VA_Q(ntryL,G1H48(40),ex3(:),G1H24(20),m3h2x24(:,69),heltab2x48(:,:,104))
  call Hloop_A_Q(ntryL,G1H24(20),36,nMT,G2H24(6),n2h24(57))
  call Hloop_AQ_V(ntryL,G1H48(41),ex2(:),G1H24(23),m3h2x24(:,70),heltab2x48(:,:,105))
  call Hloop_VQ_A(ntryL,G1H48(42),ex2(:),G1H24(26),m3h2x24(:,71),heltab2x48(:,:,106))
  call Hloop_Q_A(ntryL,G1H24(26),34,nMT,G2H24(7),n2h24(58))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G2H2(48),G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(52),G2H2(39),G2H2(81),G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(63),G2H2(80),G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(7),[G1H3(106),G1H3(60),G1H3(39)])
call HGT_w2_OLR(G1H3(14),1,1,3)
call HGT_w2_invQ_OLR(G1H3(14),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(14),[G1H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(42),[G1H3(1)])
call HGT_w2_OLR(G1H3(27),1,1,3)
call HGT_w2_invQ_OLR(G1H3(27),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(27),[G1H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(33),[G1H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(121),[G1H3(122),G1H3(117),G1H3(96)])
call HGT_w2_OLR(G1H3(33),1,1,3)
call HGT_w2_invQ_OLR(G1H3(33),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(33),[G1H3(121)])
call HGT_w2_OLR(G1H4(30),1,1,4)
call HGT_w2_invQ_OLR(G1H4(30),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(47),[G1H2(66)])
call HGT_w2_OLR(G1H2(89),1,1,2)
call HGT_w2_invQ_OLR(G1H2(89),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(89),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(17),[G2H6(6),G2H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(24),[G1H6(2)])
call HGT_w2_OLR(G1H6(51),1,1,6)
call HGT_w2_invQ_OLR(G1H6(51),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(51),[G1H6(24)])
call HGT_w2_OLR(G1H2(94),1,1,2)
call HGT_w2_invQ_OLR(G1H2(94),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(94),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G2H6(23),G2H6(8)])
call HGT_w2_OLR(G1H4(34),1,1,4)
call HGT_w2_invQ_OLR(G1H4(34),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(86),[G1H3(102)])
call HGT_w2_OLR(G1H3(32),1,1,3)
call HGT_w2_invQ_OLR(G1H3(32),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(32),[G1H3(86)])
call HGT_w2_OLR(G1H4(35),1,1,4)
call HGT_w2_invQ_OLR(G1H4(35),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(5)])
call HGT_w2_OLR(G1H4(22),1,1,4)
call HGT_w2_invQ_OLR(G1H4(22),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(38)])
call HGT_w2_OLR(G1H12(3),1,1,12)
call HGT_w2_invQ_OLR(G1H12(3),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(3),[G1H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(42),[G1H12(35)])
call HGT_w2_OLR(G1H12(4),1,1,12)
call HGT_w2_invQ_OLR(G1H12(4),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G1H12(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(93),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(78),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(92),[G1H3(118),G1H3(71),G1H3(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(90),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(58),[G1H3(19),G1H3(134),G1H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(40),[G1H3(146),G1H3(90),G1H3(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(133),[G1H3(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(25),[G1H3(145),G1H3(129),G1H3(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(89),[G1H3(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(25),G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(81),[G1H6(63),G1H6(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(78),[G1H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(83),[G1H6(54),G1H6(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(4),[G1H6(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(82),[G1H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(18),[G1H12(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G1H12(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(1),[G1H12(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(9),[G1H12(24),G1H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(2),[G1H12(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(26),[G1H12(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(30),[G1H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(13),[G1H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(28),[G1H12(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(18),[G1H12(45),G1H12(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(11),[G1H12(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(40),[G1H12(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(18)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex4(:),G2tensor(2),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(59),ex4(:),G2tensor(154),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(68),ex4(:),G2tensor(52),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hloop_AW_Q(ntryL,G1H3(14),ex5(:),G1H1(1),m3h3x1(:,141),heltab2x3(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(318))
  call Hloop_QW_A(ntryL,G1H3(27),ex5(:),G1H1(1),m3h3x1(:,142),heltab2x3(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(319))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(43),ex1(:),G2tensor(5),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hloop_AW_Q(ntryL,G1H3(33),ex5(:),G1H1(1),m3h3x1(:,143),heltab2x3(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(320))
  call Hloop_AV_Q(ntryL,G1H4(30),wf4(:,1),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(321))
  call Hloop_VQ_A(ntryL,G1H2(89),ex4(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(353),n2h1(322))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(17),wf6(:,2),G2tensor(48),m3h6x1(:,57),heltab2x6(:,:,179))
  call Hloop_VA_Q(ntryL,G1H6(51),wf6(:,2),G1H1(1),m3h6x1(:,58),heltab2x6(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(44),n2h1(323))
  call Hloop_VA_Q(ntryL,G1H2(94),ex1(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(324))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(12),wf6(:,4),G2tensor(96),m3h6x1(:,59),heltab2x6(:,:,181))
  call Hloop_AV_Q(ntryL,G1H4(34),wf4(:,1),G1H1(1),m3h4x1(:,45),heltab2x4(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(325))
  call Hloop_AW_Q(ntryL,G1H3(32),ex5(:),G1H1(1),m3h3x1(:,144),heltab2x3(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(347),n2h1(326))
  call Hloop_QV_A(ntryL,G1H4(35),wf4(:,1),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(50),n2h1(327))
  call Hloop_AV_Q(ntryL,G1H4(22),wf4(:,1),G1H1(1),m3h4x1(:,47),heltab2x4(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(46),n2h1(328))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(2),wf8(:,3),G2tensor(18),m3h8x1(:,3),heltab2x8(:,:,46))
  call Hloop_QV_A(ntryL,G1H12(3),wf12(:,1),G1H1(1),m3h12x1(:,25),heltab2x12(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(242),n2h1(329))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(87),ex3(:),G2tensor(22),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hloop_QV_A(ntryL,G1H12(4),wf12(:,4),G1H1(1),m3h12x1(:,26),heltab2x12(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(20),n2h1(330))
  call Hloop_VQ_A(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(331))
  call Hloop_VQ_A(ntryL,G1H2(93),ex4(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(56),n2h1(332))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(2),57,wf4(:,1),6,G2tensor(26),m3h4x1(:,48),heltab2x4(:,:,116))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(44),57,wf4(:,1),6,G2tensor(28),m3h4x1(:,49),heltab2x4(:,:,117))
  call Hloop_VA_Q(ntryL,G1H2(78),ex1(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(333))
  call Hloop_AW_Q(ntryL,G1H3(92),ex5(:),G1H1(1),m3h3x1(:,145),heltab2x3(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(334))
  call Hloop_VQ_A(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(335))
  call Hloop_QW_A(ntryL,G1H3(58),ex5(:),G1H1(1),m3h3x1(:,146),heltab2x3(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(336))
  call Hloop_QW_A(ntryL,G1H3(40),ex5(:),G1H1(1),m3h3x1(:,147),heltab2x3(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(337))
  call Hloop_VA_Q(ntryL,G1H2(77),ex1(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(338))
  call Hloop_AW_Q(ntryL,G1H3(133),ex5(:),G1H1(1),m3h3x1(:,148),heltab2x3(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(227),n2h1(339))
  call Hloop_QW_A(ntryL,G1H3(25),ex5(:),G1H1(1),m3h3x1(:,149),heltab2x3(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(172),n2h1(340))
  call Hloop_QW_A(ntryL,G1H3(89),ex5(:),G1H1(1),m3h3x1(:,150),heltab2x3(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(40),n2h1(341))
  call Hloop_QV_A(ntryL,G1H4(46),wf4(:,1),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(342))
  call Hloop_QV_A(ntryL,G1H4(51),wf4(:,1),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(233),n2h1(343))
  call Hloop_QV_A(ntryL,G1H4(17),wf4(:,1),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(344))
  call Hloop_VQ_A(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(345))
  call Hloop_AV_Q(ntryL,G1H4(33),wf4(:,1),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(140),n2h1(346))
  call Hloop_VA_Q(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(62),n2h1(347))
  call Hloop_VA_Q(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(63),n2h1(348))
  call Hloop_VA_Q(ntryL,G1H6(81),wf6(:,2),G1H1(1),m3h6x1(:,60),heltab2x6(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(349))
  call Hloop_VQ_A(ntryL,G1H6(78),wf6(:,4),G1H1(1),m3h6x1(:,61),heltab2x6(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(350))
  call Hloop_VQ_A(ntryL,G1H6(83),wf6(:,4),G1H1(1),m3h6x1(:,62),heltab2x6(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(351))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(43),57,wf4(:,1),6,G2tensor(69),m3h4x1(:,54),heltab2x4(:,:,122))
  call Hloop_QV_A(ntryL,G1H4(50),wf4(:,1),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(352))
  call Hloop_VA_Q(ntryL,G1H6(4),wf6(:,2),G1H1(1),m3h6x1(:,63),heltab2x6(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(137),n2h1(353))
  call Hloop_VQ_A(ntryL,G1H6(82),wf6(:,4),G1H1(1),m3h6x1(:,64),heltab2x6(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(74),n2h1(354))
  call Hloop_AV_Q(ntryL,G1H12(18),wf12(:,1),G1H1(1),m3h12x1(:,27),heltab2x12(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(75),n2h1(355))
  call Hloop_AV_Q(ntryL,G2H12(8),wf12(:,1),G2H1(1),m3h12x1(:,28),heltab2x12(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(1),n2h1(356))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(1),38,wf12(:,1),25,G2tensor(78),m3h12x1(:,29),heltab2x12(:,:,157))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H12(9),38,wf12(:,1),25,G3tensor(2),m3h12x1(:,30),heltab2x12(:,:,158))
  call Hloop_QV_A(ntryL,G2H12(2),wf12(:,1),G2H1(1),m3h12x1(:,31),heltab2x12(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(3),n2h1(357))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(26),38,wf12(:,1),25,G2tensor(146),m3h12x1(:,32),heltab2x12(:,:,160))
  call Hloop_AV_Q(ntryL,G1H12(30),wf12(:,4),G1H1(1),m3h12x1(:,33),heltab2x12(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(80),n2h1(358))
  call Hloop_AV_Q(ntryL,G2H12(13),wf12(:,4),G2H1(1),m3h12x1(:,34),heltab2x12(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(4),n2h1(359))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(28),38,wf12(:,4),25,G2tensor(81),m3h12x1(:,35),heltab2x12(:,:,163))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H12(18),38,wf12(:,4),25,G3tensor(5),m3h12x1(:,36),heltab2x12(:,:,164))
  call Hloop_QV_A(ntryL,G2H12(11),wf12(:,4),G2H1(1),m3h12x1(:,37),heltab2x12(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(6),n2h1(360))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(40),38,wf12(:,4),25,G2tensor(84),m3h12x1(:,38),heltab2x12(:,:,166))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(92),ex4(:),G2tensor(153),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(9),ex1(:),G2tensor(89),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(86),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(7),wf6(:,2),G2tensor(92),m3h6x1(:,65),heltab2x6(:,:,187))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(14),wf6(:,4),G2tensor(95),m3h6x1(:,66),heltab2x6(:,:,188))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(20),wf6(:,2),G2tensor(98),m3h6x1(:,67),heltab2x6(:,:,189))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(2),wf6(:,4),G2tensor(101),m3h6x1(:,68),heltab2x6(:,:,190))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(3),wf8(:,3),G2tensor(104),m3h8x1(:,4),heltab2x8(:,:,47))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(21),ex3(:),G2tensor(107),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(22),ex3(:),G2tensor(110),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hloop_AV_Q(ntryL,G2H12(7),wf12(:,1),G2H1(1),m3h12x1(:,39),heltab2x12(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(7),n2h1(361))
  call Hloop_QV_A(ntryL,G2H12(3),wf12(:,1),G2H1(1),m3h12x1(:,40),heltab2x12(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(8),n2h1(362))
  call Hloop_AV_Q(ntryL,G2H12(5),wf12(:,1),G2H1(1),m3h12x1(:,41),heltab2x12(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(9),n2h1(363))
  call Hloop_QV_A(ntryL,G2H12(1),wf12(:,1),G2H1(1),m3h12x1(:,42),heltab2x12(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(10),n2h1(364))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H12(6),38,wf12(:,1),G3tensor(11),m3h12x1(:,43),heltab2x12(:,:,171))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H12(4),38,wf12(:,1),25,G3tensor(12),m3h12x1(:,44),heltab2x12(:,:,172))
  call Hloop_VA_Q(ntryL,G1H24(11),wf24(:,6),G1H1(1),m3h24x1(:,1),heltab2x24(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(365))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H24(11),wf24(:,6),G2tensor(114),m3h24x1(:,2),heltab2x24(:,:,139))
  call Hloop_QV_A(ntryL,G2H12(10),wf12(:,4),G2H1(1),m3h12x1(:,45),heltab2x12(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(13),n2h1(366))
  call Hloop_AV_Q(ntryL,G2H12(12),wf12(:,4),G2H1(1),m3h12x1(:,46),heltab2x12(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(14),n2h1(367))
  call Hloop_QV_A(ntryL,G2H12(14),wf12(:,4),G2H1(1),m3h12x1(:,47),heltab2x12(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(15),n2h1(368))
  call Hloop_AV_Q(ntryL,G2H12(15),wf12(:,4),G2H1(1),m3h12x1(:,48),heltab2x12(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(16),n2h1(369))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H12(16),38,wf12(:,4),25,G3tensor(17),m3h12x1(:,49),heltab2x12(:,:,177))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H12(17),38,wf12(:,4),G3tensor(18),m3h12x1(:,50),heltab2x12(:,:,178))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(19),57,wf4(:,1),6,G2tensor(116),m3h4x1(:,56),heltab2x4(:,:,124))
  call Hloop_VQ_A(ntryL,G1H24(21),wf24(:,8),G1H1(1),m3h24x1(:,3),heltab2x24(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(231),n2h1(370))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H24(1),wf24(:,8),G2tensor(117),m3h24x1(:,4),heltab2x24(:,:,141))
  call Hloop_VA_Q(ntryL,G1H24(25),wf24(:,11),G1H1(1),m3h24x1(:,5),heltab2x24(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(119),n2h1(371))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H24(2),wf24(:,11),G2tensor(120),m3h24x1(:,6),heltab2x24(:,:,143))
  call Hloop_VQ_A(ntryL,G1H24(27),wf24(:,13),G1H1(1),m3h24x1(:,7),heltab2x24(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(122),n2h1(372))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H24(3),wf24(:,13),G2tensor(123),m3h24x1(:,8),heltab2x24(:,:,145))
  call Hloop_VA_Q(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(125),n2h1(373))
  call Hloop_VQ_A(ntryL,G1H24(12),wf24(:,15),G1H1(1),m3h24x1(:,9),heltab2x24(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(128),n2h1(374))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H24(4),wf24(:,15),G2tensor(129),m3h24x1(:,10),heltab2x24(:,:,147))
  call Hloop_VA_Q(ntryL,G1H24(3),wf24(:,17),G1H1(1),m3h24x1(:,11),heltab2x24(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(131),n2h1(375))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H24(5),wf24(:,17),G2tensor(132),m3h24x1(:,12),heltab2x24(:,:,149))
  call Hloop_VQ_A(ntryL,G1H24(18),wf24(:,21),G1H1(1),m3h24x1(:,13),heltab2x24(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(134),n2h1(376))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H24(6),wf24(:,21),G2tensor(135),m3h24x1(:,14),heltab2x24(:,:,151))
  call Hloop_VA_Q(ntryL,G1H24(23),wf24(:,23),G1H1(1),m3h24x1(:,15),heltab2x24(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(149),n2h1(377))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H24(7),wf24(:,23),G2tensor(159),m3h24x1(:,16),heltab2x24(:,:,153))
  call ol_merge_tensors(G2tensor(347),[G2tensor(3),G2tensor(151),G1tensor(668),G1tensor(663),G1tensor(627),G1tensor(623) &
    ,G1tensor(167),G1tensor(171),G0tensor(668),G0tensor(663),G0tensor(627),G0tensor(623),G0tensor(302),G0tensor(297)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(285),G2tensor(64),G2tensor(155),G1tensor(643),G1tensor(602),G1tensor(528) &
    ,G1tensor(463),G1tensor(438),G1tensor(357),G1tensor(152),G1tensor(67),G1tensor(21),G1tensor(37),G0tensor(643),G0tensor(602) &
    ,G0tensor(528),G0tensor(463),G0tensor(438),G0tensor(348),G0tensor(157),G0tensor(12),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(50),G2tensor(330),G2tensor(303),G2tensor(246),G2tensor(156),G1tensor(662) &
    ,G1tensor(226),G1tensor(64),G1tensor(36),G1tensor(10),G1tensor(47),G1tensor(72),G1tensor(330),G0tensor(662),G0tensor(328) &
    ,G0tensor(237),G0tensor(232),G0tensor(130),G0tensor(100),G0tensor(68),G0tensor(63)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(46),G2tensor(306),G2tensor(288),G2tensor(252),G2tensor(121),G2tensor(157) &
    ,G1tensor(622),G1tensor(256),G1tensor(104),G1tensor(23),G1tensor(75),G1tensor(329),G0tensor(622),G0tensor(338),G0tensor(262) &
    ,G0tensor(145),G0tensor(115),G0tensor(82)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(353),G2tensor(339),G2tensor(297),G2tensor(261),G2tensor(161),G1tensor(613) &
    ,G1tensor(608),G1tensor(547),G1tensor(191),G1tensor(334),G1tensor(123),G1tensor(100),G1tensor(153),G0tensor(613),G0tensor(608) &
    ,G0tensor(547),G0tensor(312),G0tensor(307),G0tensor(279),G0tensor(263),G0tensor(244)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(273),G2tensor(267),G2tensor(169),G2tensor(165),G1tensor(638),G1tensor(633) &
    ,G1tensor(221),G1tensor(214),G1tensor(225),G1tensor(213),G0tensor(638),G0tensor(633),G0tensor(333),G0tensor(327),G0tensor(322) &
    ,G0tensor(317)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(342),G2tensor(276),G2tensor(258),G2tensor(109),G2tensor(173),G1tensor(437) &
    ,G1tensor(227),G1tensor(63),G1tensor(180),G1tensor(170),G1tensor(276),G0tensor(437),G0tensor(332),G0tensor(233),G0tensor(169) &
    ,G0tensor(164),G0tensor(72)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(321),G2tensor(282),G2tensor(177),G1tensor(642),G1tensor(269),G1tensor(245) &
    ,G1tensor(232),G0tensor(642),G0tensor(342),G0tensor(337),G0tensor(308)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(44),G2tensor(259),G2tensor(240),G2tensor(222),G2tensor(91),G1tensor(452) &
    ,G1tensor(440),G1tensor(166),G1tensor(59),G1tensor(169),G1tensor(109),G0tensor(452),G0tensor(440),G0tensor(300),G0tensor(238) &
    ,G0tensor(29),G0tensor(19)])
  call ol_merge_tensors(G3tensor(18),[G3tensor(17),G3tensor(14),G3tensor(13),G3tensor(12),G3tensor(11),G3tensor(8),G3tensor(7) &
    ,G3tensor(5),G3tensor(2),G2tensor(343),G2tensor(340),G2tensor(280),G2tensor(265),G2tensor(241),G2tensor(228),G2tensor(226) &
    ,G2tensor(197),G2tensor(190),G2tensor(180),G2tensor(39),G1tensor(650),G1tensor(455),G1tensor(203),G1tensor(184),G1tensor(297) &
    ,G1tensor(199),G1tensor(139),G0tensor(650),G0tensor(455),G0tensor(315),G0tensor(305),G0tensor(75),G0tensor(34),G0tensor(24)])
  call ol_merge_tensors(G2tensor(289),[G2tensor(286),G2tensor(118),G2tensor(112),G1tensor(625),G1tensor(617),G1tensor(605) &
    ,G1tensor(284),G0tensor(625),G0tensor(617),G0tensor(605),G0tensor(343)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(122),G2tensor(117),G2tensor(231),G2tensor(307),G2tensor(271),G2tensor(256) &
    ,G2tensor(244),G2tensor(236),G2tensor(234),G2tensor(193),G2tensor(188),G2tensor(183),G2tensor(115),G1tensor(620),G1tensor(570) &
    ,G1tensor(435),G1tensor(395),G1tensor(250),G1tensor(19),G1tensor(312),G1tensor(275),G1tensor(235),G1tensor(48),G0tensor(620) &
    ,G0tensor(570),G0tensor(435),G0tensor(395),G0tensor(325),G0tensor(155),G0tensor(125),G0tensor(85),G0tensor(40),G0tensor(10)])
  call ol_merge_tensors(G2tensor(310),[G2tensor(178),G1tensor(635),G1tensor(178),G0tensor(635),G0tensor(303)])
  call ol_merge_tensors(G2tensor(313),[G2tensor(179),G1tensor(640),G1tensor(172),G0tensor(640),G0tensor(304)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(316),G2tensor(215),G2tensor(181),G1tensor(610),G1tensor(420),G1tensor(380) &
    ,G1tensor(96),G1tensor(33),G0tensor(610),G0tensor(420),G0tensor(380),G0tensor(65),G0tensor(8)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(319),G2tensor(216),G2tensor(182),G1tensor(615),G1tensor(430),G1tensor(390) &
    ,G1tensor(116),G1tensor(41),G0tensor(615),G0tensor(430),G0tensor(390),G0tensor(70),G0tensor(9)])
  call ol_merge_tensors(G2tensor(66),[G2tensor(48),G2tensor(295),G2tensor(184),G1tensor(599),G1tensor(589),G1tensor(530) &
    ,G1tensor(239),G1tensor(107),G1tensor(65),G1tensor(52),G0tensor(599),G0tensor(589),G0tensor(530),G0tensor(314),G0tensor(274) &
    ,G0tensor(239),G0tensor(229)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(119),G2tensor(114),G2tensor(113),G2tensor(304),G2tensor(250),G2tensor(232) &
    ,G2tensor(185),G1tensor(540),G1tensor(286),G1tensor(58),G1tensor(258),G1tensor(222),G0tensor(540),G0tensor(345),G0tensor(240) &
    ,G0tensor(140),G0tensor(110)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(143),G2tensor(298),G2tensor(217),G2tensor(186),G1tensor(630),G1tensor(550) &
    ,G1tensor(130),G1tensor(71),G1tensor(90),G0tensor(630),G0tensor(550),G0tensor(284),G0tensor(249),G0tensor(83)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(96),G2tensor(301),G2tensor(214),G2tensor(187),G1tensor(560),G1tensor(450) &
    ,G1tensor(179),G1tensor(89),G1tensor(60),G1tensor(120),G1tensor(319),G1tensor(259),G0tensor(560),G0tensor(450),G0tensor(294) &
    ,G0tensor(259),G0tensor(84),G0tensor(74),G0tensor(54),G0tensor(44)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(137),G2tensor(322),G2tensor(189),G1tensor(645),G1tensor(593),G1tensor(512) &
    ,G1tensor(359),G1tensor(234),G1tensor(343),G0tensor(645),G0tensor(593),G0tensor(512),G0tensor(313),G0tensor(195) &
    ,G0tensor(58)])
  call ol_merge_tensors(G2tensor(331),[G2tensor(325),G2tensor(194),G2tensor(191),G1tensor(665),G1tensor(655),G1tensor(209) &
    ,G0tensor(665),G0tensor(655),G0tensor(323)])
  call ol_merge_tensors(G2tensor(337),[G2tensor(334),G2tensor(328),G2tensor(198),G2tensor(195),G2tensor(192),G1tensor(670) &
    ,G1tensor(660),G1tensor(285),G1tensor(352),G0tensor(670),G0tensor(660),G0tensor(344),G0tensor(324)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(74),G2tensor(270),G2tensor(268),G2tensor(243),G2tensor(213),G2tensor(196) &
    ,G1tensor(407),G1tensor(367),G1tensor(219),G1tensor(156),G1tensor(282),G1tensor(264),G1tensor(283),G1tensor(217),G0tensor(407) &
    ,G0tensor(367),G0tensor(320),G0tensor(160),G0tensor(78),G0tensor(73),G0tensor(48),G0tensor(37)])
  call ol_merge_tensors(G2tensor(159),[G2tensor(132),G2tensor(361),G2tensor(349),G2tensor(238),G1tensor(675),G1tensor(600) &
    ,G1tensor(485),G1tensor(325),G1tensor(205),G0tensor(675),G0tensor(600),G0tensor(485),G0tensor(55),G0tensor(35)])
  call ol_merge_tensors(G2tensor(283),[G2tensor(249),G2tensor(247),G1tensor(537),G1tensor(263),G1tensor(57),G1tensor(314) &
    ,G1tensor(279),G0tensor(537),G0tensor(340),G0tensor(235),G0tensor(135),G0tensor(105)])
  call ol_merge_tensors(G2tensor(274),[G2tensor(255),G2tensor(253),G1tensor(567),G1tensor(347),G1tensor(110),G1tensor(278) &
    ,G1tensor(204),G0tensor(567),G0tensor(330),G0tensor(265),G0tensor(150),G0tensor(120)])
  call ol_merge_tensors(G2tensor(279),[G2tensor(277),G2tensor(264),G2tensor(262),G1tensor(647),G1tensor(233),G1tensor(190) &
    ,G0tensor(647),G0tensor(335),G0tensor(310)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(146),G2tensor(291),G1tensor(497),G1tensor(344),G1tensor(212),G1tensor(355) &
    ,G1tensor(295),G1tensor(133),G0tensor(497),G0tensor(215),G0tensor(185),G0tensor(60),G0tensor(50),G0tensor(23)])
  call ol_merge_tensors(G2tensor(149),[G2tensor(131),G2tensor(358),G2tensor(346),G2tensor(292),G1tensor(680),G1tensor(500) &
    ,G1tensor(99),G1tensor(51),G1tensor(327),G1tensor(281),G0tensor(680),G0tensor(500),G0tensor(220),G0tensor(190),G0tensor(95) &
    ,G0tensor(90)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(294),G1tensor(527),G1tensor(196),G1tensor(112),G1tensor(40),G1tensor(43) &
    ,G0tensor(527),G0tensor(309),G0tensor(269),G0tensor(234),G0tensor(224)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(300),G1tensor(557),G1tensor(238),G1tensor(154),G1tensor(201),G1tensor(88) &
    ,G0tensor(557),G0tensor(334),G0tensor(289),G0tensor(264),G0tensor(254)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(309),G1tensor(632),G1tensor(502),G1tensor(165),G1tensor(316),G1tensor(12) &
    ,G0tensor(632),G0tensor(502),G0tensor(298),G0tensor(203),G0tensor(193)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(312),G1tensor(637),G1tensor(177),G0tensor(637),G0tensor(299)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(315),G1tensor(628),G1tensor(473),G1tensor(448),G1tensor(397),G1tensor(340) &
    ,G1tensor(192),G1tensor(117),G1tensor(30),G0tensor(628),G0tensor(473),G0tensor(448),G0tensor(397),G0tensor(357),G0tensor(173) &
    ,G0tensor(158),G0tensor(62)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(2),G2tensor(318),G1tensor(634),G1tensor(478),G1tensor(453),G1tensor(402) &
    ,G1tensor(362),G1tensor(309),G1tensor(25),G1tensor(92),G0tensor(634),G0tensor(478),G0tensor(453),G0tensor(402),G0tensor(362) &
    ,G0tensor(183),G0tensor(159),G0tensor(67)])
  call ol_merge_tensors(G2tensor(172),[G2tensor(324),G1tensor(652),G1tensor(558),G1tensor(548),G1tensor(543),G1tensor(333) &
    ,G1tensor(207),G1tensor(242),G1tensor(230),G0tensor(652),G0tensor(558),G0tensor(548),G0tensor(543),G0tensor(353),G0tensor(318) &
    ,G0tensor(197),G0tensor(192)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(227),G2tensor(327),G1tensor(657),G1tensor(648),G1tensor(644),G1tensor(244) &
    ,G0tensor(657),G0tensor(648),G0tensor(644),G0tensor(319)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(126),G2tensor(336),G2tensor(333),G1tensor(667),G1tensor(251),G1tensor(215) &
    ,G0tensor(667),G0tensor(339),G0tensor(329)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(357),G2tensor(345),G1tensor(677),G0tensor(677)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(360),G2tensor(348),G1tensor(383),G1tensor(373),G1tensor(159),G1tensor(74) &
    ,G1tensor(176),G1tensor(45),G1tensor(302),G1tensor(187),G1tensor(157),G0tensor(383),G0tensor(373),G0tensor(247),G0tensor(242) &
    ,G0tensor(167),G0tensor(128),G0tensor(113),G0tensor(32),G0tensor(27)])
  call ol_merge_tensors(G2tensor(363),[G2tensor(351),G1tensor(682),G0tensor(682)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(128),G2tensor(364),G2tensor(352),G1tensor(685),G0tensor(685)])
  call ol_merge_tensors(G2tensor(366),[G2tensor(354),G1tensor(423),G1tensor(413),G1tensor(125),G1tensor(231),G1tensor(49) &
    ,G1tensor(105),G1tensor(328),G1tensor(127),G1tensor(97),G0tensor(423),G0tensor(413),G0tensor(282),G0tensor(277),G0tensor(162) &
    ,G0tensor(143),G0tensor(98),G0tensor(22),G0tensor(17)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(129),G2tensor(367),G2tensor(355),G1tensor(590),G1tensor(460),G1tensor(265) &
    ,G1tensor(145),G0tensor(590),G0tensor(460),G0tensor(45),G0tensor(25)])
  call ol_merge_tensors(G1tensor(377),[G1tensor(346),G1tensor(32),G0tensor(377),G0tensor(360),G0tensor(3)])
  call ol_merge_tensors(G1tensor(387),[G1tensor(365),G1tensor(3),G0tensor(387),G0tensor(365),G0tensor(4)])
  call ol_merge_tensors(G1tensor(392),[G1tensor(370),G1tensor(9),G0tensor(392),G0tensor(370),G0tensor(5)])
  call ol_merge_tensors(G1tensor(417),[G1tensor(400),G1tensor(299),G1tensor(73),G0tensor(417),G0tensor(400),G0tensor(178) &
    ,G0tensor(13)])
  call ol_merge_tensors(G1tensor(427),[G1tensor(405),G1tensor(216),G1tensor(79),G0tensor(427),G0tensor(405),G0tensor(188) &
    ,G0tensor(14)])
  call ol_merge_tensors(G1tensor(432),[G1tensor(410),G1tensor(158),G1tensor(85),G0tensor(432),G0tensor(410),G0tensor(88) &
    ,G0tensor(15)])
  call ol_merge_tensors(G1tensor(291),[G1tensor(28),G1tensor(310),G1tensor(5),G1tensor(103),G0tensor(350),G0tensor(228) &
    ,G0tensor(187),G0tensor(182),G0tensor(18)])
  call ol_merge_tensors(G1tensor(457),[G1tensor(445),G1tensor(311),G1tensor(115),G0tensor(457),G0tensor(445),G0tensor(108) &
    ,G0tensor(20)])
  call ol_merge_tensors(G1tensor(477),[G1tensor(465),G1tensor(118),G1tensor(163),G0tensor(477),G0tensor(465),G0tensor(273) &
    ,G0tensor(28)])
  call ol_merge_tensors(G1tensor(482),[G1tensor(470),G1tensor(20),G1tensor(175),G0tensor(482),G0tensor(470),G0tensor(138) &
    ,G0tensor(30)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(78),G1tensor(595),G1tensor(480),G1tensor(144),G1tensor(193),G0tensor(595) &
    ,G0tensor(480),G0tensor(80),G0tensor(33)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(26),G1tensor(654),G1tensor(415),G1tensor(375),G1tensor(288),G1tensor(223) &
    ,G0tensor(654),G0tensor(415),G0tensor(375),G0tensor(64),G0tensor(38)])
  call ol_merge_tensors(G2tensor(233),[G2tensor(28),G1tensor(659),G1tensor(425),G1tensor(385),G1tensor(303),G1tensor(229) &
    ,G0tensor(659),G0tensor(425),G0tensor(385),G0tensor(69),G0tensor(39)])
  call ol_merge_tensors(G1tensor(442),[G1tensor(55),G1tensor(274),G1tensor(247),G0tensor(442),G0tensor(165),G0tensor(103) &
    ,G0tensor(42)])
  call ol_merge_tensors(G1tensor(492),[G1tensor(39),G1tensor(289),G1tensor(253),G0tensor(492),G0tensor(175),G0tensor(49) &
    ,G0tensor(43)])
  call ol_merge_tensors(G1tensor(287),[G1tensor(243),G1tensor(168),G1tensor(273),G1tensor(277),G0tensor(347),G0tensor(223) &
    ,G0tensor(163),G0tensor(87),G0tensor(47)])
  call ol_merge_tensors(G1tensor(467),[G1tensor(188),G1tensor(300),G1tensor(307),G0tensor(467),G0tensor(170),G0tensor(133) &
    ,G0tensor(52)])
  call ol_merge_tensors(G1tensor(475),[G1tensor(270),G1tensor(313),G0tensor(475),G0tensor(79),G0tensor(53)])
  call ol_merge_tensors(G1tensor(322),[G1tensor(137),G1tensor(128),G1tensor(261),G1tensor(337),G0tensor(352),G0tensor(288) &
    ,G0tensor(278),G0tensor(92),G0tensor(57)])
  call ol_merge_tensors(G1tensor(588),[G1tensor(522),G1tensor(320),G1tensor(349),G0tensor(588),G0tensor(522),G0tensor(205) &
    ,G0tensor(59)])
  call ol_merge_tensors(G1tensor(462),[G1tensor(136),G1tensor(26),G1tensor(126),G0tensor(462),G0tensor(268),G0tensor(168) &
    ,G0tensor(77)])
  call ol_merge_tensors(G1tensor(495),[G1tensor(266),G1tensor(31),G0tensor(495),G0tensor(180),G0tensor(89)])
  call ol_merge_tensors(G1tensor(515),[G1tensor(246),G1tensor(182),G0tensor(515),G0tensor(200),G0tensor(93)])
  call ol_merge_tensors(G1tensor(525),[G1tensor(262),G1tensor(15),G0tensor(525),G0tensor(210),G0tensor(94)])
  call ol_merge_tensors(G1tensor(488),[G1tensor(403),G1tensor(398),G1tensor(317),G1tensor(280),G1tensor(53),G0tensor(488) &
    ,G0tensor(403),G0tensor(398),G0tensor(107),G0tensor(102),G0tensor(97)])
  call ol_merge_tensors(G1tensor(428),[G1tensor(418),G1tensor(42),G1tensor(249),G1tensor(84),G0tensor(428),G0tensor(418) &
    ,G0tensor(227),G0tensor(222),G0tensor(99)])
  call ol_merge_tensors(G1tensor(532),[G1tensor(34),G1tensor(108),G0tensor(532),G0tensor(225),G0tensor(104)])
  call ol_merge_tensors(G1tensor(535),[G1tensor(29),G1tensor(294),G0tensor(535),G0tensor(230),G0tensor(109)])
  call ol_merge_tensors(G1tensor(4),[G1tensor(200),G1tensor(186),G0tensor(122),G0tensor(117),G0tensor(112)])
  call ol_merge_tensors(G1tensor(83),[G1tensor(93),G1tensor(81),G0tensor(257),G0tensor(252),G0tensor(114)])
  call ol_merge_tensors(G1tensor(597),[G1tensor(552),G1tensor(80),G1tensor(2),G0tensor(597),G0tensor(552),G0tensor(245) &
    ,G0tensor(118)])
  call ol_merge_tensors(G1tensor(562),[G1tensor(82),G1tensor(306),G0tensor(562),G0tensor(255),G0tensor(119)])
  call ol_merge_tensors(G1tensor(555),[G1tensor(87),G1tensor(224),G0tensor(555),G0tensor(250),G0tensor(123)])
  call ol_merge_tensors(G1tensor(565),[G1tensor(195),G1tensor(8),G0tensor(565),G0tensor(260),G0tensor(124)])
  call ol_merge_tensors(G1tensor(363),[G1tensor(345),G1tensor(254),G1tensor(14),G1tensor(296),G0tensor(363),G0tensor(358) &
    ,G0tensor(137),G0tensor(132),G0tensor(127)])
  call ol_merge_tensors(G1tensor(388),[G1tensor(378),G1tensor(142),G1tensor(292),G1tensor(35),G0tensor(388),G0tensor(378) &
    ,G0tensor(272),G0tensor(267),G0tensor(129)])
  call ol_merge_tensors(G1tensor(572),[G1tensor(106),G1tensor(240),G0tensor(572),G0tensor(270),G0tensor(134)])
  call ol_merge_tensors(G1tensor(575),[G1tensor(119),G1tensor(318),G0tensor(575),G0tensor(275),G0tensor(139)])
  call ol_merge_tensors(G1tensor(518),[G1tensor(508),G1tensor(503),G1tensor(11),G1tensor(272),G1tensor(129),G0tensor(518) &
    ,G0tensor(508),G0tensor(503),G0tensor(152),G0tensor(147),G0tensor(142)])
  call ol_merge_tensors(G1tensor(149),[G1tensor(143),G1tensor(68),G0tensor(292),G0tensor(287),G0tensor(144)])
  call ol_merge_tensors(G1tensor(587),[G1tensor(577),G1tensor(237),G1tensor(98),G0tensor(587),G0tensor(577),G0tensor(280) &
    ,G0tensor(148)])
  call ol_merge_tensors(G1tensor(582),[G1tensor(148),G1tensor(44),G0tensor(582),G0tensor(290),G0tensor(149)])
  call ol_merge_tensors(G1tensor(580),[G1tensor(141),G1tensor(146),G0tensor(580),G0tensor(285),G0tensor(153)])
  call ol_merge_tensors(G1tensor(585),[G1tensor(161),G1tensor(111),G0tensor(585),G0tensor(295),G0tensor(154)])
  call ol_merge_tensors(G1tensor(533),[G1tensor(443),G1tensor(290),G1tensor(305),G1tensor(304),G0tensor(533),G0tensor(443) &
    ,G0tensor(349),G0tensor(177),G0tensor(172)])
  call ol_merge_tensors(G1tensor(487),[G1tensor(458),G1tensor(210),G1tensor(194),G0tensor(487),G0tensor(458),G0tensor(184) &
    ,G0tensor(174)])
  call ol_merge_tensors(G1tensor(490),[G1tensor(218),G1tensor(198),G0tensor(490),G0tensor(189),G0tensor(179)])
  call ol_merge_tensors(G1tensor(507),[G1tensor(348),G1tensor(298),G0tensor(507),G0tensor(213),G0tensor(194)])
  call ol_merge_tensors(G1tensor(505),[G1tensor(336),G1tensor(17),G0tensor(505),G0tensor(208),G0tensor(198)])
  call ol_merge_tensors(G1tensor(510),[G1tensor(360),G1tensor(315),G0tensor(510),G0tensor(218),G0tensor(199)])
  call ol_merge_tensors(G1tensor(583),[G1tensor(578),G1tensor(353),G1tensor(332),G1tensor(18),G0tensor(583),G0tensor(578) &
    ,G0tensor(354),G0tensor(207),G0tensor(202)])
  call ol_merge_tensors(G1tensor(517),[G1tensor(342),G1tensor(252),G0tensor(517),G0tensor(214),G0tensor(204)])
  call ol_merge_tensors(G1tensor(520),[G1tensor(189),G1tensor(268),G0tensor(520),G0tensor(219),G0tensor(209)])
  call ol_merge_tensors(G1tensor(335),[G1tensor(185),G1tensor(135),G1tensor(356),G1tensor(338),G0tensor(355),G0tensor(293) &
    ,G0tensor(283),G0tensor(217),G0tensor(212)])
  call ol_merge_tensors(G1tensor(592),[G1tensor(542),G1tensor(77),G1tensor(69),G0tensor(592),G0tensor(542),G0tensor(253) &
    ,G0tensor(243)])
  call ol_merge_tensors(G1tensor(545),[G1tensor(95),G1tensor(86),G0tensor(545),G0tensor(258),G0tensor(248)])
  call ol_merge_tensors(G1tensor(372),[G1tensor(368),G1tensor(358),G0tensor(372),G0tensor(368),G0tensor(359)])
  call ol_merge_tensors(G1tensor(382),[G1tensor(369),G1tensor(364),G0tensor(382),G0tensor(369),G0tensor(364)])
  call ol_merge_tensors(G1tensor(393),[G1tensor(379),G1tensor(374),G0tensor(393),G0tensor(379),G0tensor(374)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(674),G1tensor(394),G1tensor(389),G1tensor(384),G0tensor(674),G0tensor(394) &
    ,G0tensor(389),G0tensor(384)])
  call ol_merge_tensors(G1tensor(493),[G1tensor(412),G1tensor(408),G1tensor(399),G0tensor(493),G0tensor(412),G0tensor(408) &
    ,G0tensor(399)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(514),G1tensor(509),G1tensor(498),G1tensor(422),G1tensor(409),G1tensor(404) &
    ,G0tensor(514),G0tensor(509),G0tensor(498),G0tensor(422),G0tensor(409),G0tensor(404)])
  call ol_merge_tensors(G1tensor(433),[G1tensor(419),G1tensor(414),G0tensor(433),G0tensor(419),G0tensor(414)])
  call ol_merge_tensors(G1tensor(434),[G1tensor(429),G1tensor(424),G0tensor(434),G0tensor(429),G0tensor(424)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(624),G1tensor(538),G1tensor(469),G1tensor(447),G1tensor(444),G1tensor(439) &
    ,G0tensor(624),G0tensor(538),G0tensor(469),G0tensor(447),G0tensor(444),G0tensor(439)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(154),G1tensor(639),G1tensor(619),G1tensor(614),G1tensor(484),G1tensor(459) &
    ,G1tensor(454),G1tensor(449),G0tensor(639),G0tensor(619),G0tensor(614),G0tensor(484),G0tensor(459),G0tensor(454) &
    ,G0tensor(449)])
  call ol_merge_tensors(G1tensor(573),[G1tensor(472),G1tensor(468),G1tensor(464),G0tensor(573),G0tensor(472),G0tensor(468) &
    ,G0tensor(464)])
  call ol_merge_tensors(G1tensor(483),[G1tensor(479),G1tensor(474),G0tensor(483),G0tensor(479),G0tensor(474)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(524),G1tensor(519),G1tensor(499),G1tensor(494),G1tensor(489),G0tensor(524) &
    ,G0tensor(519),G0tensor(499),G0tensor(494),G0tensor(489)])
  call ol_merge_tensors(G1tensor(523),[G1tensor(513),G1tensor(504),G0tensor(523),G0tensor(513),G0tensor(504)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(30),G1tensor(669),G1tensor(649),G1tensor(584),G1tensor(574),G1tensor(569) &
    ,G1tensor(564),G1tensor(559),G1tensor(539),G1tensor(534),G1tensor(529),G0tensor(669),G0tensor(649),G0tensor(584),G0tensor(574) &
    ,G0tensor(569),G0tensor(564),G0tensor(559),G0tensor(539),G0tensor(534),G0tensor(529)])
  call ol_merge_tensors(G1tensor(563),[G1tensor(553),G1tensor(544),G0tensor(563),G0tensor(553),G0tensor(544)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(664),G1tensor(579),G1tensor(568),G1tensor(554),G1tensor(549),G0tensor(664) &
    ,G0tensor(579),G0tensor(568),G0tensor(554),G0tensor(549)])
  call ol_merge_tensors(G1tensor(598),[G1tensor(594),G0tensor(598),G0tensor(594)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(17),G1tensor(658),G1tensor(653),G1tensor(607),G1tensor(603),G0tensor(658) &
    ,G0tensor(653),G0tensor(607),G0tensor(603)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(612),G1tensor(604),G0tensor(612),G0tensor(604)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(629),G1tensor(618),G1tensor(609),G0tensor(629),G0tensor(618),G0tensor(609)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(242),G1tensor(683),G1tensor(672),G0tensor(683),G0tensor(672)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(673),G0tensor(673)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(75),G1tensor(678),G0tensor(678)])
  call ol_merge_tensors(G3tensor(6),[G3tensor(4),G3tensor(3),G3tensor(1),G1tensor(684),G1tensor(679),G0tensor(684) &
    ,G0tensor(679)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(15),G3tensor(10),G3tensor(9)])
  call TI_triangle_red(G2tensor(347),RedBasis(142),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(93),RedBasis(99),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(69),RedBasis(6),mass3set(:,1),G0tensor(41),G0tensor(46),G0tensor(51),G0tensor(56),M2L1R1)
  call TI_triangle_red(G2tensor(116),RedBasis(181),mass3set(:,1),G0tensor(61),G0tensor(66),G0tensor(71),G0tensor(76),M2L1R1)
  call TI_triangle_red(G2tensor(86),RedBasis(132),mass3set(:,1),G0tensor(81),G0tensor(86),G0tensor(91),G0tensor(96),M2L1R1)
  call TI_triangle_red(G2tensor(54),RedBasis(130),mass3set(:,1),G0tensor(101),G0tensor(106),G0tensor(111),G0tensor(116),M2L1R1)
  call TI_triangle_red(G2tensor(13),RedBasis(149),mass3set(:,1),G0tensor(121),G0tensor(126),G0tensor(131),G0tensor(136),M2L1R1)
  call TI_triangle_red(G2tensor(34),RedBasis(179),mass3set(:,1),G0tensor(141),G0tensor(146),G0tensor(151),G0tensor(156),M2L1R1)
  call TI_triangle_red(G2tensor(98),RedBasis(30),mass3set(:,1),G0tensor(161),G0tensor(166),G0tensor(171),G0tensor(176),M2L1R1)
  call TI_triangle_red(G3tensor(18),RedBasis(8),mass3set(:,1),G0tensor(181),G0tensor(186),G0tensor(191),G0tensor(196),M2L1R1)
  call TI_triangle_red(G2tensor(289),RedBasis(143),mass3set(:,1),G0tensor(201),G0tensor(206),G0tensor(211),G0tensor(216),M2L1R1)
  call TI_triangle_red(G2tensor(123),RedBasis(1),mass3set(:,1),G0tensor(221),G0tensor(226),G0tensor(231),G0tensor(236),M2L1R1)
  call TI_triangle_red(G2tensor(310),RedBasis(129),mass3set(:,1),G0tensor(241),G0tensor(246),G0tensor(251),G0tensor(256),M2L1R1)
  call TI_triangle_red(G2tensor(313),RedBasis(128),mass3set(:,1),G0tensor(261),G0tensor(266),G0tensor(271),G0tensor(276),M2L1R1)
  call TI_triangle_red(G2tensor(104),RedBasis(4),mass3set(:,1),G0tensor(281),G0tensor(286),G0tensor(291),G0tensor(296),M2L1R1)
  call TI_triangle_red(G2tensor(18),RedBasis(2),mass3set(:,1),G0tensor(301),G0tensor(306),G0tensor(311),G0tensor(316),M2L1R1)
  call TI_triangle_red(G2tensor(66),RedBasis(28),mass3set(:,1),G0tensor(321),G0tensor(326),G0tensor(331),G0tensor(336),M2L1R1)
  call TI_triangle_red(G2tensor(120),RedBasis(26),mass3set(:,1),G0tensor(341),G0tensor(346),G0tensor(351),G0tensor(356),M2L1R1)
  call TI_triangle_red(G2tensor(101),RedBasis(33),mass3set(:,1),G0tensor(361),G0tensor(366),G0tensor(371),G0tensor(376),M2L1R1)
  call TI_triangle_red(G2tensor(68),RedBasis(9),mass3set(:,1),G0tensor(381),G0tensor(386),G0tensor(391),G0tensor(396),M2L1R1)
  call TI_triangle_red(G2tensor(92),RedBasis(135),mass3set(:,1),G0tensor(401),G0tensor(406),G0tensor(411),G0tensor(416),M2L1R1)
  call TI_triangle_red(G2tensor(331),RedBasis(140),mass3set(:,1),G0tensor(421),G0tensor(426),G0tensor(431),G0tensor(436),M2L1R1)
  call TI_triangle_red(G2tensor(337),RedBasis(139),mass3set(:,1),G0tensor(441),G0tensor(446),G0tensor(451),G0tensor(456),M2L1R1)
  call TI_triangle_red(G2tensor(95),RedBasis(12),mass3set(:,1),G0tensor(461),G0tensor(466),G0tensor(471),G0tensor(476),M2L1R1)
  call TI_triangle_red(G2tensor(159),RedBasis(13),mass3set(:,2),G0tensor(481),G0tensor(486),G0tensor(491), &
    G0tensor(496),M2L1R1,[nMT],G0tensor(501))
  call TI_triangle_red(G2tensor(283),RedBasis(145),mass3set(:,1),G0tensor(506),G0tensor(511),G0tensor(516),G0tensor(521),M2L1R1)
  call TI_triangle_red(G2tensor(274),RedBasis(151),mass3set(:,1),G0tensor(526),G0tensor(531),G0tensor(536),G0tensor(541),M2L1R1)
  call TI_triangle_red(G2tensor(279),RedBasis(178),mass3set(:,1),G0tensor(546),G0tensor(551),G0tensor(556),G0tensor(561),M2L1R1)
  call TI_triangle_red(G2tensor(84),RedBasis(10),mass3set(:,3),G0tensor(566),G0tensor(571),G0tensor(576), &
    G0tensor(581),M2L1R1,[nMT],G0tensor(586))
  call TI_triangle_red(G2tensor(149),RedBasis(13),mass3set(:,4),G0tensor(591),G0tensor(596),G0tensor(601), &
    G0tensor(606),M2L1R1,[nMT],G0tensor(611))
  call TI_triangle_red(G2tensor(59),RedBasis(147),mass3set(:,1),G0tensor(616),G0tensor(621),G0tensor(626),G0tensor(631),M2L1R1)
  call TI_triangle_red(G2tensor(36),RedBasis(153),mass3set(:,1),G0tensor(636),G0tensor(641),G0tensor(646),G0tensor(651),M2L1R1)
  call TI_triangle_red(G2tensor(89),RedBasis(137),mass3set(:,1),G0tensor(656),G0tensor(661),G0tensor(666),G0tensor(671),M2L1R1)
  call TI_triangle_red(G2tensor(5),RedBasis(177),mass3set(:,1),G0tensor(676),G0tensor(681),G0tensor(668),G0tensor(663),M2L1R1)
  call TI_triangle_red(G2tensor(153),RedBasis(66),mass3set(:,1),G0tensor(627),G0tensor(623),G0tensor(302),G0tensor(297),M2L1R1)
  call TI_triangle_red(G2tensor(24),RedBasis(48),mass3set(:,1),G0tensor(643),G0tensor(602),G0tensor(528),G0tensor(463),M2L1R1)
  call TI_triangle_red(G2tensor(172),RedBasis(109),mass3set(:,1),G0tensor(438),G0tensor(348),G0tensor(157),G0tensor(12),M2L1R1)
  call TI_triangle_red(G2tensor(40),RedBasis(138),mass3set(:,1),G0tensor(7),G0tensor(2),G0tensor(662),G0tensor(328),M2L1R1)
  call TI_triangle_red(G2tensor(140),RedBasis(180),mass3set(:,1),G0tensor(237),G0tensor(232),G0tensor(130),G0tensor(100),M2L1R1)
  call TI_triangle_red(G2tensor(125),RedBasis(50),mass3set(:,4),G0tensor(68),G0tensor(63),G0tensor(622), &
    G0tensor(338),M2L1R1,[nMT],G0tensor(262))
  call TI_triangle_red(G2tensor(110),RedBasis(50),mass3set(:,2),G0tensor(145),G0tensor(115),G0tensor(82), &
    G0tensor(613),M2L1R1,[nMT],G0tensor(608))
  call TI_triangle_red(G2tensor(363),RedBasis(60),mass3set(:,4),G0tensor(547),G0tensor(312),G0tensor(307), &
    G0tensor(279),M2L1R1,[nMT],G0tensor(263))
  call TI_triangle_red(G2tensor(134),RedBasis(7),mass3set(:,4),G0tensor(244),G0tensor(638),G0tensor(633), &
    G0tensor(333),M2L1R1,[nMT],G0tensor(327))
  call TI_triangle_red(G2tensor(366),RedBasis(60),mass3set(:,2),G0tensor(322),G0tensor(317),G0tensor(437), &
    G0tensor(332),M2L1R1,[nMT],G0tensor(233))
  call TI_triangle_red(G2tensor(135),RedBasis(7),mass3set(:,2),G0tensor(169),G0tensor(164),G0tensor(72), &
    G0tensor(642),M2L1R1,[nMT],G0tensor(342))
  call TI_triangle_red(G2tensor(81),RedBasis(19),mass3set(:,3),G0tensor(337),G0tensor(308),G0tensor(452), &
    G0tensor(440),M2L1R1,[nMT],G0tensor(300))
  call TI_triangle_red(G2tensor(42),RedBasis(5),mass3set(:,1),G0tensor(238),G0tensor(29),G0tensor(19),G0tensor(650),M2L1R1)
  call TI_triangle_red(G2tensor(233),RedBasis(3),mass3set(:,1),G0tensor(455),G0tensor(315),G0tensor(305),G0tensor(75),M2L1R1)
  call TI_triangle_red(G2tensor(22),RedBasis(40),mass3set(:,2),G0tensor(34),G0tensor(24),G0tensor(625),G0tensor(617),M2L1R1,[nMT], &
    G0tensor(605))
  call TI_triangle_red(G2tensor(62),RedBasis(84),mass3set(:,5),G0tensor(343),G0tensor(620),G0tensor(570), &
    G0tensor(435),M2L1R1,[nMT],G0tensor(395))
  call TI_triangle_red(G2tensor(7),RedBasis(100),mass3set(:,1),G0tensor(325),G0tensor(155),G0tensor(125),G0tensor(85),M2L1R1)
  call TI_triangle_red(G2tensor(56),RedBasis(46),mass3set(:,1),G0tensor(40),G0tensor(10),G0tensor(635),G0tensor(303),M2L1R1)
  call TI_triangle_red(G2tensor(63),RedBasis(40),mass3set(:,4),G0tensor(640),G0tensor(304),G0tensor(610), &
    G0tensor(420),M2L1R1,[nMT],G0tensor(380))
  call TI_triangle_red(G2tensor(38),RedBasis(101),mass3set(:,1),G0tensor(65),G0tensor(8),G0tensor(615),G0tensor(430),M2L1R1)
  call TI_triangle_red(G2tensor(32),RedBasis(110),mass3set(:,1),G0tensor(390),G0tensor(70),G0tensor(9),G0tensor(599),M2L1R1)
  call TI_triangle_red(G2tensor(72),RedBasis(141),mass3set(:,1),G0tensor(589),G0tensor(530),G0tensor(314),G0tensor(274),M2L1R1)
  call TI_triangle_red(G2tensor(11),RedBasis(182),mass3set(:,1),G0tensor(239),G0tensor(229),G0tensor(540),G0tensor(345),M2L1R1)
  call TI_triangle_red(G2tensor(52),RedBasis(131),mass3set(:,1),G0tensor(240),G0tensor(140),G0tensor(110),G0tensor(630),M2L1R1)
  call TI_triangle_red(G2tensor(20),RedBasis(10),mass3set(:,6),G0tensor(550),G0tensor(284),G0tensor(249), &
    G0tensor(83),M2L1R1,[nMT],G0tensor(560))
  call TI_triangle_red(G2tensor(107),RedBasis(84),mass3set(:,7),G0tensor(450),G0tensor(294),G0tensor(259), &
    G0tensor(84),M2L1R1,[nMT],G0tensor(74))
  call TI_triangle_red(G2tensor(80),RedBasis(19),mass3set(:,6),G0tensor(54),G0tensor(44),G0tensor(645),G0tensor(593),M2L1R1,[nMT], &
    G0tensor(512))
  call TI_triangle_red(G3tensor(6),RedBasis(8),mass3set(:,8),G0tensor(313),G0tensor(195),G0tensor(58),G0tensor(665),M2L1R1,[nMT], &
    G0tensor(655))
  call TI_triangle_red(G3tensor(16),RedBasis(8),mass3set(:,9),G0tensor(323),G0tensor(670),G0tensor(660), &
    G0tensor(344),M2L1R1,[nMB],G0tensor(324))
  call TI_triangle_red(G1tensor(377),RedBasis(165),mass3set(:,5),G0tensor(407),G0tensor(367),G0tensor(320), &
    G0tensor(160),M2L1R1,[nMT],G0tensor(78))
  call TI_triangle_red(G1tensor(387),RedBasis(163),mass3set(:,5),G0tensor(73),G0tensor(48),G0tensor(37), &
    G0tensor(675),M2L1R1,[nMT],G0tensor(600))
  call TI_triangle_red(G1tensor(392),RedBasis(162),mass3set(:,5),G0tensor(485),G0tensor(55),G0tensor(35), &
    G0tensor(537),M2L1R1,[nMT],G0tensor(340))
  call TI_triangle_red(G1tensor(417),RedBasis(18),mass3set(:,5),G0tensor(235),G0tensor(135),G0tensor(105), &
    G0tensor(567),M2L1R1,[nMT],G0tensor(330))
  call TI_triangle_red(G1tensor(427),RedBasis(17),mass3set(:,5),G0tensor(265),G0tensor(150),G0tensor(120), &
    G0tensor(647),M2L1R1,[nMT],G0tensor(335))
  call TI_triangle_red(G1tensor(432),RedBasis(16),mass3set(:,5),G0tensor(310),G0tensor(497),G0tensor(215), &
    G0tensor(185),M2L1R1,[nMT],G0tensor(60))
  call TI_triangle_red(G1tensor(291),RedBasis(31),mass3set(:,3),G0tensor(50),G0tensor(23),G0tensor(680), &
    G0tensor(500),M2L1R1,[nMT],G0tensor(220))
  call TI_triangle_red(G1tensor(457),RedBasis(29),mass3set(:,2),G0tensor(190),G0tensor(95),G0tensor(90), &
    G0tensor(527),M2L1R1,[nMT],G0tensor(309))
  call TI_triangle_red(G1tensor(477),RedBasis(36),mass3set(:,3),G0tensor(269),G0tensor(234),G0tensor(224), &
    G0tensor(557),M2L1R1,[nMT],G0tensor(334))
  call TI_triangle_red(G1tensor(482),RedBasis(35),mass3set(:,2),G0tensor(289),G0tensor(264),G0tensor(254), &
    G0tensor(632),M2L1R1,[nMT],G0tensor(502))
  call TI_triangle_red(G1tensor(442),RedBasis(148),mass3set(:,2),G0tensor(298),G0tensor(203),G0tensor(193), &
    G0tensor(637),M2L1R1,[nMT],G0tensor(299))
  call TI_triangle_red(G1tensor(492),RedBasis(11),mass3set(:,3),G0tensor(628),G0tensor(473),G0tensor(448), &
    G0tensor(397),M2L1R1,[nMT],G0tensor(357))
  call TI_triangle_red(G1tensor(287),RedBasis(150),mass3set(:,3),G0tensor(173),G0tensor(158),G0tensor(62), &
    G0tensor(634),M2L1R1,[nMT],G0tensor(478))
  call TI_triangle_red(G1tensor(467),RedBasis(157),mass3set(:,2),G0tensor(453),G0tensor(402),G0tensor(362), &
    G0tensor(183),M2L1R1,[nMT],G0tensor(159))
  call TI_triangle_red(G1tensor(475),RedBasis(20),mass3set(:,3),G0tensor(67),G0tensor(652),G0tensor(558), &
    G0tensor(548),M2L1R1,[nMT],G0tensor(543))
  call TI_triangle_red(G1tensor(322),RedBasis(161),mass3set(:,3),G0tensor(353),G0tensor(318),G0tensor(197), &
    G0tensor(192),M2L1R1,[nMT],G0tensor(657))
  call TI_triangle_red(G1tensor(588),RedBasis(133),mass3set(:,3),G0tensor(648),G0tensor(644),G0tensor(319), &
    G0tensor(667),M2L1R1,[nMT],G0tensor(339))
  call TI_triangle_red(G1tensor(462),RedBasis(158),mass3set(:,3),G0tensor(329),G0tensor(677),G0tensor(383), &
    G0tensor(373),M2L1R1,[nMT],G0tensor(247))
  call TI_triangle_red(G1tensor(495),RedBasis(14),mass3set(:,4),G0tensor(242),G0tensor(167),G0tensor(128), &
    G0tensor(113),M2L1R1,[nMT],G0tensor(32))
  call TI_triangle_red(G1tensor(515),RedBasis(23),mass3set(:,5),G0tensor(27),G0tensor(682),G0tensor(685), &
    G0tensor(423),M2L1R1,[nMT],G0tensor(413))
  call TI_triangle_red(G1tensor(525),RedBasis(21),mass3set(:,4),G0tensor(282),G0tensor(277),G0tensor(162), &
    G0tensor(143),M2L1R1,[nMT],G0tensor(98))
  call TI_triangle_red(G1tensor(488),RedBasis(83),mass3set(:,5),G0tensor(22),G0tensor(17),G0tensor(590), &
    G0tensor(460),M2L1R1,[nMT],G0tensor(45))
  call TI_triangle_red(G1tensor(428),RedBasis(45),mass3set(:,2),G0tensor(25),G0tensor(377),G0tensor(360),G0tensor(3),M2L1R1,[nMT], &
    G0tensor(387))
  call TI_triangle_red(G1tensor(532),RedBasis(146),mass3set(:,2),G0tensor(365),G0tensor(4),G0tensor(392), &
    G0tensor(370),M2L1R1,[nMT],G0tensor(5))
  call TI_triangle_red(G1tensor(535),RedBasis(27),mass3set(:,2),G0tensor(417),G0tensor(400),G0tensor(178), &
    G0tensor(13),M2L1R1,[nMT],G0tensor(427))
  call TI_triangle_red(G1tensor(4),RedBasis(185),mass3set(:,5),G0tensor(405),G0tensor(188),G0tensor(14), &
    G0tensor(432),M2L1R1,[nMT],G0tensor(410))
  call TI_triangle_red(G1tensor(83),RedBasis(183),mass3set(:,2),G0tensor(88),G0tensor(15),G0tensor(350), &
    G0tensor(228),M2L1R1,[nMT],G0tensor(187))
  call TI_triangle_red(G1tensor(597),RedBasis(154),mass3set(:,2),G0tensor(182),G0tensor(18),G0tensor(457), &
    G0tensor(445),M2L1R1,[nMT],G0tensor(108))
  call TI_triangle_red(G1tensor(562),RedBasis(152),mass3set(:,2),G0tensor(20),G0tensor(477),G0tensor(465), &
    G0tensor(273),M2L1R1,[nMT],G0tensor(28))
  call TI_triangle_red(G1tensor(555),RedBasis(32),mass3set(:,2),G0tensor(482),G0tensor(470),G0tensor(138), &
    G0tensor(30),M2L1R1,[nMT],G0tensor(595))
  call TI_triangle_red(G1tensor(565),RedBasis(14),mass3set(:,2),G0tensor(480),G0tensor(80),G0tensor(33), &
    G0tensor(654),M2L1R1,[nMT],G0tensor(415))
  call TI_triangle_red(G1tensor(363),RedBasis(167),mass3set(:,5),G0tensor(375),G0tensor(64),G0tensor(38), &
    G0tensor(659),M2L1R1,[nMT],G0tensor(425))
  call TI_triangle_red(G1tensor(388),RedBasis(42),mass3set(:,2),G0tensor(385),G0tensor(69),G0tensor(39), &
    G0tensor(442),M2L1R1,[nMT],G0tensor(165))
  call TI_triangle_red(G1tensor(572),RedBasis(156),mass3set(:,2),G0tensor(103),G0tensor(42),G0tensor(492), &
    G0tensor(175),M2L1R1,[nMT],G0tensor(49))
  call TI_triangle_red(G1tensor(575),RedBasis(21),mass3set(:,2),G0tensor(43),G0tensor(347),G0tensor(223), &
    G0tensor(163),M2L1R1,[nMT],G0tensor(87))
  call TI_triangle_red(G1tensor(518),RedBasis(89),mass3set(:,5),G0tensor(47),G0tensor(467),G0tensor(170), &
    G0tensor(133),M2L1R1,[nMT],G0tensor(52))
  call TI_triangle_red(G1tensor(149),RedBasis(184),mass3set(:,2),G0tensor(475),G0tensor(79),G0tensor(53), &
    G0tensor(352),M2L1R1,[nMT],G0tensor(288))
  call TI_triangle_red(G1tensor(587),RedBasis(160),mass3set(:,2),G0tensor(278),G0tensor(92),G0tensor(57), &
    G0tensor(588),M2L1R1,[nMT],G0tensor(522))
  call TI_triangle_red(G1tensor(582),RedBasis(159),mass3set(:,2),G0tensor(205),G0tensor(59),G0tensor(462), &
    G0tensor(268),M2L1R1,[nMT],G0tensor(168))
  call TI_triangle_red(G1tensor(580),RedBasis(38),mass3set(:,2),G0tensor(77),G0tensor(495),G0tensor(180), &
    G0tensor(89),M2L1R1,[nMT],G0tensor(515))
  call TI_triangle_red(G1tensor(585),RedBasis(37),mass3set(:,2),G0tensor(200),G0tensor(93),G0tensor(525), &
    G0tensor(210),M2L1R1,[nMT],G0tensor(94))
  call TI_triangle_red(G1tensor(533),RedBasis(98),mass3set(:,3),G0tensor(488),G0tensor(403),G0tensor(398), &
    G0tensor(107),M2L1R1,[nMT],G0tensor(102))
  call TI_triangle_red(G1tensor(487),RedBasis(47),mass3set(:,3),G0tensor(97),G0tensor(428),G0tensor(418), &
    G0tensor(227),M2L1R1,[nMT],G0tensor(222))
  call TI_triangle_red(G1tensor(490),RedBasis(15),mass3set(:,4),G0tensor(99),G0tensor(532),G0tensor(225), &
    G0tensor(104),M2L1R1,[nMT],G0tensor(535))
  call TI_triangle_red(G1tensor(507),RedBasis(136),mass3set(:,1),G0tensor(230),G0tensor(109),G0tensor(122),G0tensor(117),M2L1R1)
  call TI_triangle_red(G1tensor(505),RedBasis(25),mass3set(:,5),G0tensor(112),G0tensor(257),G0tensor(252), &
    G0tensor(114),M2L1R1,[nMT],G0tensor(597))
  call TI_triangle_red(G1tensor(510),RedBasis(24),mass3set(:,5),G0tensor(552),G0tensor(245),G0tensor(118), &
    G0tensor(562),M2L1R1,[nMT],G0tensor(255))
  call TI_triangle_red(G1tensor(583),RedBasis(123),mass3set(:,3),G0tensor(119),G0tensor(555),G0tensor(250), &
    G0tensor(123),M2L1R1,[nMT],G0tensor(565))
  call TI_triangle_red(G1tensor(517),RedBasis(134),mass3set(:,3),G0tensor(260),G0tensor(124),G0tensor(363), &
    G0tensor(358),M2L1R1,[nMT],G0tensor(137))
  call TI_triangle_red(G1tensor(520),RedBasis(22),mass3set(:,4),G0tensor(132),G0tensor(127),G0tensor(388), &
    G0tensor(378),M2L1R1,[nMT],G0tensor(272))
  call TI_triangle_red(G1tensor(335),RedBasis(39),mass3set(:,3),G0tensor(267),G0tensor(129),G0tensor(572), &
    G0tensor(270),M2L1R1,[nMT],G0tensor(134))
  call TI_triangle_red(G1tensor(592),RedBasis(155),mass3set(:,3),G0tensor(575),G0tensor(275),G0tensor(139), &
    G0tensor(518),M2L1R1,[nMT],G0tensor(508))
  call TI_triangle_red(G1tensor(545),RedBasis(34),mass3set(:,3),G0tensor(503),G0tensor(152),G0tensor(147), &
    G0tensor(142),M2L1R1,[nMT],G0tensor(292))
  call TI_triangle_red(G1tensor(372),RedBasis(166),mass3set(:,5),G0tensor(287),G0tensor(144),G0tensor(587), &
    G0tensor(577),M2L1R1,[nMT],G0tensor(280))
  call TI_triangle_red(G1tensor(382),RedBasis(164),mass3set(:,5),G0tensor(148),G0tensor(582),G0tensor(290), &
    G0tensor(149),M2L1R1,[nMT],G0tensor(580))
  call TI_triangle_red(G1tensor(393),RedBasis(41),mass3set(:,2),G0tensor(285),G0tensor(153),G0tensor(585), &
    G0tensor(295),M2L1R1,[nMT],G0tensor(154))
  call TI_triangle_red(G1tensor(493),RedBasis(82),mass3set(:,5),G0tensor(533),G0tensor(443),G0tensor(349), &
    G0tensor(177),M2L1R1,[nMT],G0tensor(172))
  call TI_triangle_red(G1tensor(433),RedBasis(44),mass3set(:,2),G0tensor(487),G0tensor(458),G0tensor(184), &
    G0tensor(174),M2L1R1,[nMT],G0tensor(490))
  call TI_triangle_red(G1tensor(434),RedBasis(43),mass3set(:,2),G0tensor(189),G0tensor(179),G0tensor(507), &
    G0tensor(213),M2L1R1,[nMT],G0tensor(194))
  call TI_triangle_red(G1tensor(573),RedBasis(119),mass3set(:,3),G0tensor(505),G0tensor(208),G0tensor(198), &
    G0tensor(510),M2L1R1,[nMT],G0tensor(218))
  call TI_triangle_red(G1tensor(483),RedBasis(49),mass3set(:,3),G0tensor(199),G0tensor(583),G0tensor(578), &
    G0tensor(354),M2L1R1,[nMT],G0tensor(207))
  call TI_triangle_red(G1tensor(523),RedBasis(88),mass3set(:,5),G0tensor(202),G0tensor(517),G0tensor(214), &
    G0tensor(204),M2L1R1,[nMT],G0tensor(520))
  call TI_triangle_red(G1tensor(563),RedBasis(108),mass3set(:,3),G0tensor(219),G0tensor(209),G0tensor(355), &
    G0tensor(293),M2L1R1,[nMT],G0tensor(283))
  call TI_triangle_red(G1tensor(598),RedBasis(144),mass3set(:,3),G0tensor(217),G0tensor(212),G0tensor(592), &
    G0tensor(542),M2L1R1,[nMT],G0tensor(253))
  call ol_merge_tensors(T0sum(138),[G0tensor(1)])
  call ol_merge_tensors(T0sum(139),[G0tensor(21)])
  call ol_merge_tensors(T0sum(140),[G0tensor(41)])
  call ol_merge_tensors(T0sum(141),[G0tensor(61)])
  call ol_merge_tensors(T0sum(142),[G0tensor(81)])
  call ol_merge_tensors(T0sum(143),[G0tensor(101)])
  call ol_merge_tensors(T0sum(144),[G0tensor(121)])
  call ol_merge_tensors(T0sum(145),[G0tensor(141)])
  call ol_merge_tensors(T0sum(146),[G0tensor(161)])
  call ol_merge_tensors(T0sum(147),[G0tensor(181)])
  call ol_merge_tensors(T0sum(148),[G0tensor(201)])
  call ol_merge_tensors(T0sum(149),[G0tensor(221)])
  call ol_merge_tensors(T0sum(150),[G0tensor(241)])
  call ol_merge_tensors(T0sum(151),[G0tensor(261)])
  call ol_merge_tensors(T0sum(152),[G0tensor(281)])
  call ol_merge_tensors(T0sum(153),[G0tensor(301)])
  call ol_merge_tensors(T0sum(154),[G0tensor(321)])
  call ol_merge_tensors(T0sum(155),[G0tensor(341)])
  call ol_merge_tensors(T0sum(156),[G0tensor(361)])
  call ol_merge_tensors(T0sum(157),[G0tensor(381)])
  call ol_merge_tensors(T0sum(158),[G0tensor(401)])
  call ol_merge_tensors(T0sum(159),[G0tensor(421)])
  call ol_merge_tensors(T0sum(160),[G0tensor(441)])
  call ol_merge_tensors(T0sum(161),[G0tensor(461)])
  call ol_merge_tensors(T0sum(162),[G0tensor(481)])
  call ol_merge_tensors(T0sum(163),[G0tensor(506)])
  call ol_merge_tensors(T0sum(164),[G0tensor(526)])
  call ol_merge_tensors(T0sum(165),[G0tensor(546)])
  call ol_merge_tensors(T0sum(166),[G0tensor(566)])
  call ol_merge_tensors(T0sum(167),[G0tensor(591)])
  call ol_merge_tensors(T0sum(168),[G0tensor(616)])
  call ol_merge_tensors(T0sum(169),[G0tensor(636)])
  call ol_merge_tensors(T0sum(170),[G0tensor(656)])
  call ol_merge_tensors(T0sum(171),[G0tensor(676)])
  call ol_merge_tensors(T0sum(172),[G0tensor(627)])
  call ol_merge_tensors(T0sum(173),[G0tensor(643)])
  call ol_merge_tensors(T0sum(174),[G0tensor(438)])
  call ol_merge_tensors(T0sum(175),[G0tensor(7)])
  call ol_merge_tensors(T0sum(176),[G0tensor(237)])
  call ol_merge_tensors(T0sum(177),[G0tensor(68)])
  call ol_merge_tensors(T0sum(178),[G0tensor(145)])
  call ol_merge_tensors(T0sum(179),[G0tensor(547)])
  call ol_merge_tensors(T0sum(180),[G0tensor(244)])
  call ol_merge_tensors(T0sum(181),[G0tensor(322)])
  call ol_merge_tensors(T0sum(182),[G0tensor(169)])
  call ol_merge_tensors(T0sum(183),[G0tensor(407)])
  call ol_merge_tensors(T0sum(184),[G0tensor(73)])
  call ol_merge_tensors(T0sum(185),[G0tensor(485)])
  call ol_merge_tensors(T0sum(186),[G0tensor(235)])
  call ol_merge_tensors(T0sum(187),[G0tensor(265)])
  call ol_merge_tensors(T0sum(188),[G0tensor(310)])
  call ol_merge_tensors(T0sum(189),[G0tensor(50)])
  call ol_merge_tensors(T0sum(190),[G0tensor(190)])
  call ol_merge_tensors(T0sum(191),[G0tensor(269)])
  call ol_merge_tensors(T0sum(192),[G0tensor(289)])
  call ol_merge_tensors(T0sum(193),[G0tensor(337)])
  call ol_merge_tensors(T0sum(194),[G0tensor(238)])
  call ol_merge_tensors(T0sum(195),[G0tensor(455)])
  call ol_merge_tensors(T0sum(196),[G0tensor(298)])
  call ol_merge_tensors(T0sum(197),[G0tensor(628)])
  call ol_merge_tensors(T0sum(198),[G0tensor(173)])
  call ol_merge_tensors(T0sum(199),[G0tensor(453)])
  call ol_merge_tensors(T0sum(200),[G0tensor(67)])
  call ol_merge_tensors(T0sum(201),[G0tensor(353)])
  call ol_merge_tensors(T0sum(202),[G0tensor(648)])
  call ol_merge_tensors(T0sum(203),[G0tensor(329)])
  call ol_merge_tensors(T0sum(204),[G0tensor(242)])
  call ol_merge_tensors(T0sum(205),[G0tensor(27)])
  call ol_merge_tensors(T0sum(206),[G0tensor(282)])
  call ol_merge_tensors(T0sum(207),[G0tensor(22)])
  call ol_merge_tensors(T0sum(208),[G0tensor(25)])
  call ol_merge_tensors(T0sum(209),[G0tensor(365)])
  call ol_merge_tensors(T0sum(210),[G0tensor(417)])
  call ol_merge_tensors(T0sum(211),[G0tensor(405)])
  call ol_merge_tensors(T0sum(212),[G0tensor(88)])
  call ol_merge_tensors(T0sum(213),[G0tensor(182)])
  call ol_merge_tensors(T0sum(214),[G0tensor(20)])
  call ol_merge_tensors(T0sum(215),[G0tensor(482)])
  call ol_merge_tensors(T0sum(216),[G0tensor(480)])
  call ol_merge_tensors(T0sum(217),[G0tensor(375)])
  call ol_merge_tensors(T0sum(218),[G0tensor(385)])
  call ol_merge_tensors(T0sum(219),[G0tensor(103)])
  call ol_merge_tensors(T0sum(220),[G0tensor(43)])
  call ol_merge_tensors(T0sum(221),[G0tensor(47)])
  call ol_merge_tensors(T0sum(222),[G0tensor(475)])
  call ol_merge_tensors(T0sum(223),[G0tensor(278)])
  call ol_merge_tensors(T0sum(224),[G0tensor(205)])
  call ol_merge_tensors(T0sum(225),[G0tensor(77)])
  call ol_merge_tensors(T0sum(226),[G0tensor(200)])
  call ol_merge_tensors(T0sum(227),[G0tensor(488)])
  call ol_merge_tensors(T0sum(228),[G0tensor(97)])
  call ol_merge_tensors(T0sum(229),[G0tensor(99)])
  call ol_merge_tensors(T0sum(230),[G0tensor(230)])
  call ol_merge_tensors(T0sum(231),[G0tensor(112)])
  call ol_merge_tensors(T0sum(232),[G0tensor(552)])
  call ol_merge_tensors(T0sum(233),[G0tensor(119)])
  call ol_merge_tensors(T0sum(234),[G0tensor(260)])
  call ol_merge_tensors(T0sum(235),[G0tensor(132)])
  call ol_merge_tensors(T0sum(236),[G0tensor(267)])
  call ol_merge_tensors(T0sum(237),[G0tensor(575)])
  call ol_merge_tensors(T0sum(238),[G0tensor(503)])
  call ol_merge_tensors(T0sum(239),[G0tensor(287)])
  call ol_merge_tensors(T0sum(240),[G0tensor(148)])
  call ol_merge_tensors(T0sum(241),[G0tensor(285)])
  call ol_merge_tensors(T0sum(242),[G0tensor(34)])
  call ol_merge_tensors(T0sum(243),[G0tensor(533)])
  call ol_merge_tensors(T0sum(244),[G0tensor(343)])
  call ol_merge_tensors(T0sum(245),[G0tensor(487)])
  call ol_merge_tensors(T0sum(246),[G0tensor(189)])
  call ol_merge_tensors(T0sum(247),[G0tensor(325)])
  call ol_merge_tensors(T0sum(248),[G0tensor(40)])
  call ol_merge_tensors(T0sum(249),[G0tensor(505)])
  call ol_merge_tensors(T0sum(250),[G0tensor(199)])
  call ol_merge_tensors(T0sum(251),[G0tensor(640)])
  call ol_merge_tensors(T0sum(252),[G0tensor(202)])
  call ol_merge_tensors(T0sum(253),[G0tensor(65)])
  call ol_merge_tensors(T0sum(254),[G0tensor(219)])
  call ol_merge_tensors(T0sum(255),[G0tensor(390)])
  call ol_merge_tensors(T0sum(256),[G0tensor(217)])
  call ol_merge_tensors(T0sum(257),[G0tensor(589)])
  call ol_merge_tensors(T0sum(258),[G0tensor(239)])
  call ol_merge_tensors(T0sum(259),[G0tensor(240)])
  call ol_merge_tensors(T0sum(260),[G0tensor(550)])
  call ol_merge_tensors(T0sum(261),[G0tensor(450)])
  call ol_merge_tensors(T0sum(262),[G0tensor(54)])
  call ol_merge_tensors(T0sum(263),[G0tensor(313)])
  call ol_merge_tensors(T0sum(264),[G0tensor(323)])
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(229),h0tab(:,229),[32,31],[0,0],3,2,wf4(:,1),wf12(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(1),m3h2x48(:,111),heltab2x96(:,:,214))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(230),h0tab(:,230),[32,31],[0,0],3,2,wf12(:,1),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(3),m3h2x48(:,112),heltab2x96(:,:,215))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(231),h0tab(:,231),[32,31],[0,0],3,2,wf4(:,1),wf12(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(18),m3h2x48(:,113),heltab2x96(:,:,216))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(232),h0tab(:,232),[57,6],[0,0],3,2,wf12(:,1),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H96(1),ex6(:),wf12(:,1),G0H4(6),m4h2x12x4(:,5),heltab3x96(:,:,16))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(233),h0tab(:,233),[57,6],[0,0],3,2,wf12(:,1),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H96(1),wf12(:,1),ex6(:),G0H4(5),m4h12x2x4(:,3),heltab3x96(:,:,17))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(234),h0tab(:,234),[57,6],[0,0],3,2,wf12(:,1),wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H96(1),ex6(:),wf12(:,1),G0H4(4),m4h2x12x4(:,6),heltab3x96(:,:,18))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(235),h0tab(:,235),[38,25],[0,0],3,2,wf4(:,1),wf12(:,1))
  call Hloop_GGG_G_12(ntryL,G0H96(1),ex6(:),wf4(:,1),G0H12(6),m4h2x4x12(:,7),heltab3x96(:,:,19))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(236),h0tab(:,236),[38,25],[0,0],3,2,wf4(:,1),wf12(:,1))
  call Hloop_GGG_G_12(ntryL,G0H96(1),wf4(:,1),ex6(:),G0H12(5),m4h4x2x12(:,4),heltab3x96(:,:,20))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(237),h0tab(:,237),[38,25],[0,0],3,2,wf4(:,1),wf12(:,1))
  call Hloop_GGG_G_23(ntryL,G0H96(1),ex6(:),wf4(:,1),G0H12(4),m4h2x4x12(:,8),heltab3x96(:,:,21))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(238),h0tab(:,238),[32,31],[0,0],3,2,wf4(:,1),wf12(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(20),m3h2x48(:,114),heltab2x96(:,:,217))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(239),h0tab(:,239),[32,31],[0,0],3,2,wf12(:,4),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(5),m3h2x48(:,115),heltab2x96(:,:,218))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(240),h0tab(:,240),[32,31],[0,0],3,2,wf4(:,1),wf12(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(2),m3h2x48(:,116),heltab2x96(:,:,219))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(241),h0tab(:,241),[38,25],[0,0],3,2,wf4(:,1),wf12(:,4))
  call Hloop_GGG_G_12(ntryL,G0H96(1),ex6(:),wf4(:,1),G0H12(7),m4h2x4x12(:,9),heltab3x96(:,:,22))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(242),h0tab(:,242),[38,25],[0,0],3,2,wf4(:,1),wf12(:,4))
  call Hloop_GGG_G_12(ntryL,G0H96(1),wf4(:,1),ex6(:),G0H12(1),m4h4x2x12(:,5),heltab3x96(:,:,23))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(243),h0tab(:,243),[38,25],[0,0],3,2,wf4(:,1),wf12(:,4))
  call Hloop_GGG_G_23(ntryL,G0H96(1),ex6(:),wf4(:,1),G0H12(2),m4h2x4x12(:,10),heltab3x96(:,:,24))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(244),h0tab(:,244),[57,6],[0,0],3,2,wf12(:,4),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H96(1),ex6(:),wf12(:,4),G0H4(3),m4h2x12x4(:,7),heltab3x96(:,:,25))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(245),h0tab(:,245),[57,6],[0,0],3,2,wf12(:,4),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H96(1),wf12(:,4),ex6(:),G0H4(2),m4h12x2x4(:,4),heltab3x96(:,:,26))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(4,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(246),h0tab(:,246),[57,6],[0,0],3,2,wf12(:,4),wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H96(1),ex6(:),wf12(:,4),G0H4(1),m4h2x12x4(:,8),heltab3x96(:,:,27))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)+c(18)*M(4,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(247),h0tab(:,247),[40,23],[0,0],2,2,wf4(:,3),wf24(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,3),G0H24(10),m3h4x24(:,41),heltab2x96(:,:,220))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(248),h0tab(:,248),[57,6],[0,0],2,2,wf24(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,5),G0H4(7),m3h24x4(:,17),heltab2x96(:,:,221))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(9),n2h4(47))
  Gcoeff(:)%j = (c(23)*M(2,:)%j-c(24)*M(4,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(249),h0tab(:,249),[57,6],[nMT,nMT],2,2,wf24(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,5),G0H4(7),m3h24x4(:,18),heltab2x96(:,:,222))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMT,G1H4(10),n2h4(48))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(250),h0tab(:,250),[57,6],[0,0],2,2,wf24(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,5),G0H4(7),m3h24x4(:,19),heltab2x96(:,:,223))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(40),n2h4(49))
  Gcoeff(:)%j = (c(23)*M(2,:)%j-c(24)*M(4,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(251),h0tab(:,251),[57,6],[nMB,nMB],2,2,wf24(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,5),G0H4(7),m3h24x4(:,20),heltab2x96(:,:,224))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMB,G1H4(41),n2h4(50))
  Gcoeff(:)%j = (c(16)*M(2,:)%j-c(20)*M(4,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(252),h0tab(:,252),[57,6],[0,0],2,2,wf24(:,5),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,5),57,G1H4(42),m3h24x4(:,21),heltab2x96(:,:,225))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(4,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(253),h0tab(:,253),[57,6],[0,0],2,2,wf24(:,5),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,5),57,G1H4(45),m3h24x4(:,22),heltab2x96(:,:,226))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)+c(18)*M(4,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(254),h0tab(:,254),[46,17],[0,0],2,2,wf16(:,6),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf16(:,6),G0H6(7),m3h16x6(:,11),heltab2x96(:,:,227))
  call Hloop_Q_A(ntryL,G0H6(7),46,0,G1H6(69),n2h6(81))
  Gcoeff(:)%j = (c(22)*(-M(1,:)%j+M(4,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(255),h0tab(:,255),[38,25],[0,0],2,2,wf8(:,1),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,1),G0H12(3),m3h8x12(:,22),heltab2x96(:,:,228))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(34),n2h12(87))
  Gcoeff(:)%j = (c(21)*(-M(1,:)%j+M(4,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(256),h0tab(:,256),[38,25],[nMT,nMT],2,2,wf8(:,1),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,1),G0H12(3),m3h8x12(:,23),heltab2x96(:,:,229))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMT,G1H12(20),n2h12(88))
  Gcoeff(:)%j = (c(22)*(-M(1,:)%j+M(4,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(257),h0tab(:,257),[38,25],[0,0],2,2,wf8(:,1),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,1),G0H12(3),m3h8x12(:,24),heltab2x96(:,:,230))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(36),n2h12(89))
  Gcoeff(:)%j = (c(21)*(-M(1,:)%j+M(4,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(258),h0tab(:,258),[38,25],[nMB,nMB],2,2,wf8(:,1),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,1),G0H12(3),m3h8x12(:,25),heltab2x96(:,:,231))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMB,G1H12(39),n2h12(90))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(4,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(259),h0tab(:,259),[38,25],[0,0],2,2,wf8(:,1),wf12(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,1),38,G1H12(15),m3h8x12(:,26),heltab2x96(:,:,232))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(260),h0tab(:,260),[38,25],[0,0],2,2,wf8(:,1),wf12(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,1),38,G1H12(53),m3h8x12(:,27),heltab2x96(:,:,233))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(4,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(261),h0tab(:,261),[57,6],[0,0],2,2,wf24(:,18),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,18),G0H4(7),m3h24x4(:,23),heltab2x96(:,:,234))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(16),n2h4(51))
  Gcoeff(:)%j = (c(21)*(M(1,:)%j-M(4,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(262),h0tab(:,262),[57,6],[nMT,nMT],2,2,wf24(:,18),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,18),G0H4(7),m3h24x4(:,24),heltab2x96(:,:,235))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMT,G1H4(25),n2h4(52))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(4,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(263),h0tab(:,263),[57,6],[0,0],2,2,wf24(:,18),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,18),G0H4(7),m3h24x4(:,25),heltab2x96(:,:,236))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(47),n2h4(53))
  Gcoeff(:)%j = (c(21)*(M(1,:)%j-M(4,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(264),h0tab(:,264),[57,6],[nMB,nMB],2,2,wf24(:,18),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,18),G0H4(7),m3h24x4(:,26),heltab2x96(:,:,237))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMB,G1H4(48),n2h4(54))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(4,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(265),h0tab(:,265),[57,6],[0,0],2,2,wf24(:,18),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,18),57,G1H4(49),m3h24x4(:,27),heltab2x96(:,:,238))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(4,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(266),h0tab(:,266),[57,6],[0,0],2,2,wf24(:,18),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,18),57,G1H4(52),m3h24x4(:,28),heltab2x96(:,:,239))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(267),h0tab(:,267),[49,14],[0,0],2,2,wf12(:,11),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,11),G0H8(4),m3h12x8(:,17),heltab2x96(:,:,240))
  call Hloop_A_Q(ntryL,G0H8(4),49,0,G1H8(16),n2h8(38))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(268),h0tab(:,268),[57,6],[0,0],2,2,wf24(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,19),G0H4(7),m3h24x4(:,29),heltab2x96(:,:,241))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(23),n2h4(55))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(23)*M(2,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(269),h0tab(:,269),[57,6],[nMT,nMT],2,2,wf24(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,19),G0H4(7),m3h24x4(:,30),heltab2x96(:,:,242))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMT,G1H4(15),n2h4(56))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(270),h0tab(:,270),[57,6],[0,0],2,2,wf24(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,19),G0H4(7),m3h24x4(:,31),heltab2x96(:,:,243))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(37),n2h4(57))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(23)*M(2,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(271),h0tab(:,271),[57,6],[nMB,nMB],2,2,wf24(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,19),G0H4(7),m3h24x4(:,32),heltab2x96(:,:,244))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMB,G1H4(8),n2h4(58))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(16)*M(2,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(272),h0tab(:,272),[57,6],[0,0],2,2,wf24(:,19),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,19),57,G1H4(3),m3h24x4(:,33),heltab2x96(:,:,245))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(2,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(273),h0tab(:,273),[57,6],[0,0],2,2,wf24(:,19),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,19),57,G1H4(18),m3h24x4(:,34),heltab2x96(:,:,246))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(2,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(274),h0tab(:,274),[46,17],[0,0],2,2,wf16(:,13),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf16(:,13),G0H6(4),m3h16x6(:,12),heltab2x96(:,:,247))
  call Hloop_Q_A(ntryL,G0H6(4),46,0,G1H6(86),n2h6(82))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(275),h0tab(:,275),[46,17],[0,0],2,2,wf16(:,15),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf16(:,15),G0H6(3),m3h16x6(:,13),heltab2x96(:,:,248))
  call Hloop_Q_A(ntryL,G0H6(3),46,0,G1H6(80),n2h6(83))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(276),h0tab(:,276),[39,24],[0,0],2,2,wf16(:,7),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,7),G0H6(1),m3h16x6(:,14),heltab2x96(:,:,249))
  call Hloop_A_Q(ntryL,G0H6(1),39,0,G1H6(85),n2h6(84))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(277),h0tab(:,277),[57,6],[0,0],2,2,wf24(:,9),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,9),G0H4(7),m3h24x4(:,35),heltab2x96(:,:,250))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(39),n2h4(59))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(23)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(278),h0tab(:,278),[57,6],[nMT,nMT],2,2,wf24(:,9),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,9),G0H4(7),m3h24x4(:,36),heltab2x96(:,:,251))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMT,G1H4(29),n2h4(60))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(279),h0tab(:,279),[57,6],[0,0],2,2,wf24(:,9),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,9),G0H4(7),m3h24x4(:,37),heltab2x96(:,:,252))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(27),n2h4(61))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(23)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(280),h0tab(:,280),[57,6],[nMB,nMB],2,2,wf24(:,9),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,9),G0H4(7),m3h24x4(:,38),heltab2x96(:,:,253))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMB,G1H4(31),n2h4(62))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(16)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(281),h0tab(:,281),[57,6],[0,0],2,2,wf24(:,9),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,9),57,G1H4(11),m3h24x4(:,39),heltab2x96(:,:,254))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(282),h0tab(:,282),[57,6],[0,0],2,2,wf24(:,9),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,9),57,G1H4(1),m3h24x4(:,40),heltab2x96(:,:,255))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(283),h0tab(:,283),[33,30],[0,0],2,2,wf4(:,5),wf24(:,8))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,5),G0H24(2),m3h4x24(:,42),heltab2x96(:,:,256))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)+c(18)*M(4,:)%j) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(284),h0tab(:,284),[39,24],[0,0],2,2,wf16(:,9),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,9),G0H6(8),m3h16x6(:,15),heltab2x96(:,:,257))
  call Hloop_A_Q(ntryL,G0H6(8),39,0,G1H6(12),n2h6(85))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)+c(18)*M(4,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(285),h0tab(:,285),[56,7],[0,0],2,2,wf12(:,17),wf8(:,5))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,17),G0H8(1),m3h12x8(:,18),heltab2x96(:,:,258))
  call Hloop_Q_A(ntryL,G0H8(1),56,0,G1H8(5),n2h8(39))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(4,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(286),h0tab(:,286),[57,6],[0,0],2,2,wf24(:,24),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,24),G0H4(7),m3h24x4(:,41),heltab2x96(:,:,259))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(21),n2h4(63))
  Gcoeff(:)%j = (c(21)*(M(1,:)%j-M(4,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(287),h0tab(:,287),[57,6],[nMT,nMT],2,2,wf24(:,24),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,24),G0H4(7),m3h24x4(:,42),heltab2x96(:,:,260))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMT,G1H4(38),n2h4(64))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(4,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(288),h0tab(:,288),[57,6],[0,0],2,2,wf24(:,24),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,24),G0H4(7),m3h24x4(:,43),heltab2x96(:,:,261))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(20),n2h4(65))
  Gcoeff(:)%j = (c(21)*(M(1,:)%j-M(4,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(289),h0tab(:,289),[57,6],[nMB,nMB],2,2,wf24(:,24),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,24),G0H4(7),m3h24x4(:,44),heltab2x96(:,:,262))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMB,G1H4(7),n2h4(66))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(4,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(290),h0tab(:,290),[57,6],[0,0],2,2,wf24(:,24),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,24),57,G1H4(12),m3h24x4(:,45),heltab2x96(:,:,263))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(4,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(291),h0tab(:,291),[57,6],[0,0],2,2,wf24(:,24),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,24),57,G1H4(24),m3h24x4(:,46),heltab2x96(:,:,264))
  Gcoeff(:)%j = (c(22)*(-M(1,:)%j+M(4,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(292),h0tab(:,292),[38,25],[0,0],2,2,wf8(:,1),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,1),G0H12(3),m3h8x12(:,28),heltab2x96(:,:,265))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(46),n2h12(91))
  Gcoeff(:)%j = (c(21)*(-M(1,:)%j+M(4,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(293),h0tab(:,293),[38,25],[nMT,nMT],2,2,wf8(:,1),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,1),G0H12(3),m3h8x12(:,29),heltab2x96(:,:,266))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMT,G1H12(48),n2h12(92))
  Gcoeff(:)%j = (c(22)*(-M(1,:)%j+M(4,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(294),h0tab(:,294),[38,25],[0,0],2,2,wf8(:,1),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,1),G0H12(3),m3h8x12(:,30),heltab2x96(:,:,267))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(14),n2h12(93))
  Gcoeff(:)%j = (c(21)*(-M(1,:)%j+M(4,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(295),h0tab(:,295),[38,25],[nMB,nMB],2,2,wf8(:,1),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,1),G0H12(3),m3h8x12(:,31),heltab2x96(:,:,268))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMB,G1H12(51),n2h12(94))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(4,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(296),h0tab(:,296),[38,25],[0,0],2,2,wf8(:,1),wf12(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,1),38,G1H12(12),m3h8x12(:,32),heltab2x96(:,:,269))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(4,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(297),h0tab(:,297),[38,25],[0,0],2,2,wf8(:,1),wf12(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,1),38,G1H12(52),m3h8x12(:,33),heltab2x96(:,:,270))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j)) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(298),h0tab(:,298),[39,24],[0,0],2,2,wf16(:,11),wf6(:,4))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,11),G0H6(6),m3h16x6(:,16),heltab2x96(:,:,271))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(299),h0tab(:,299),[57,6],[0,0],2,2,wf24(:,25),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,25),G0H4(7),m3h24x4(:,47),heltab2x96(:,:,272))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(36),n2h4(67))
  Gcoeff(:)%j = (c(23)*M(2,:)%j-c(24)*M(4,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(300),h0tab(:,300),[57,6],[nMT,nMT],2,2,wf24(:,25),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,25),G0H4(7),m3h24x4(:,48),heltab2x96(:,:,273))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMT,G1H4(5),n2h4(68))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(301),h0tab(:,301),[57,6],[0,0],2,2,wf24(:,25),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,25),G0H4(7),m3h24x4(:,49),heltab2x96(:,:,274))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(32),n2h4(69))
  Gcoeff(:)%j = (c(23)*M(2,:)%j-c(24)*M(4,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(302),h0tab(:,302),[57,6],[nMB,nMB],2,2,wf24(:,25),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,25),G0H4(7),m3h24x4(:,50),heltab2x96(:,:,275))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMB,G1H4(13),n2h4(70))
  Gcoeff(:)%j = (c(16)*M(2,:)%j-c(20)*M(4,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(303),h0tab(:,303),[57,6],[0,0],2,2,wf24(:,25),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,25),57,G1H4(14),m3h24x4(:,51),heltab2x96(:,:,276))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(4,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(304),h0tab(:,304),[57,6],[0,0],2,2,wf24(:,25),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,25),57,G1H4(4),m3h24x4(:,52),heltab2x96(:,:,277))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(2,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(305),h0tab(:,305),[49,14],[0,0],2,2,wf12(:,13),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,13),G0H8(2),m3h12x8(:,19),heltab2x96(:,:,278))
  call Hloop_A_Q(ntryL,G0H8(2),49,0,G1H8(6),n2h8(40))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(306),h0tab(:,306),[57,6],[0,0],2,2,wf24(:,26),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,26),G0H4(7),m3h24x4(:,53),heltab2x96(:,:,279))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(28),n2h4(71))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(23)*M(2,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(307),h0tab(:,307),[57,6],[nMT,nMT],2,2,wf24(:,26),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,26),G0H4(7),m3h24x4(:,54),heltab2x96(:,:,280))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMT,G1H4(6),n2h4(72))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(308),h0tab(:,308),[57,6],[0,0],2,2,wf24(:,26),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,26),G0H4(7),m3h24x4(:,55),heltab2x96(:,:,281))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(26),n2h4(73))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(23)*M(2,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(309),h0tab(:,309),[57,6],[nMB,nMB],2,2,wf24(:,26),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,26),G0H4(7),m3h24x4(:,56),heltab2x96(:,:,282))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMB,G1H4(30),n2h4(74))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(16)*M(2,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(310),h0tab(:,310),[57,6],[0,0],2,2,wf24(:,26),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,26),57,G1H4(34),m3h24x4(:,57),heltab2x96(:,:,283))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(2,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(311),h0tab(:,311),[57,6],[0,0],2,2,wf24(:,26),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,26),57,G1H4(35),m3h24x4(:,58),heltab2x96(:,:,284))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(2,:)%j) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(312),h0tab(:,312),[33,30],[0,0],2,2,wf4(:,5),wf24(:,13))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,5),G0H24(8),m3h4x24(:,43),heltab2x96(:,:,285))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)+c(18)*M(4,:)%j) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(313),h0tab(:,313),[40,23],[0,0],2,2,wf4(:,3),wf24(:,11))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,3),G0H24(3),m3h4x24(:,44),heltab2x96(:,:,286))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)+c(18)*M(4,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(314),h0tab(:,314),[56,7],[0,0],2,2,wf12(:,19),wf8(:,5))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,19),G0H8(5),m3h12x8(:,20),heltab2x96(:,:,287))
  call Hloop_Q_A(ntryL,G0H8(5),56,0,G1H8(7),n2h8(41))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(315),h0tab(:,315),[57,6],[0,0],2,2,wf24(:,27),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,27),G0H4(7),m3h24x4(:,59),heltab2x96(:,:,288))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(22),n2h4(75))
  Gcoeff(:)%j = (c(23)*M(2,:)%j-c(24)*M(4,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(316),h0tab(:,316),[57,6],[nMT,nMT],2,2,wf24(:,27),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,27),G0H4(7),m3h24x4(:,60),heltab2x96(:,:,289))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMT,G1H4(2),n2h4(76))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(317),h0tab(:,317),[57,6],[0,0],2,2,wf24(:,27),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,27),G0H4(7),m3h24x4(:,61),heltab2x96(:,:,290))
  call Hloop_Q_A(ntryL,G0H4(7),57,0,G1H4(44),n2h4(77))
  Gcoeff(:)%j = (c(23)*M(2,:)%j-c(24)*M(4,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(318),h0tab(:,318),[57,6],[nMB,nMB],2,2,wf24(:,27),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,27),G0H4(7),m3h24x4(:,62),heltab2x96(:,:,291))
  call Hloop_Q_A(ntryL,G0H4(7),57,nMB,G1H4(46),n2h4(78))
  Gcoeff(:)%j = (c(16)*M(2,:)%j-c(20)*M(4,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(319),h0tab(:,319),[57,6],[0,0],2,2,wf24(:,27),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,27),57,G1H4(51),m3h24x4(:,63),heltab2x96(:,:,292))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(4,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(320),h0tab(:,320),[57,6],[0,0],2,2,wf24(:,27),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,27),57,G1H4(17),m3h24x4(:,64),heltab2x96(:,:,293))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(3,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(321),h0tab(:,321),[38,25],[0,0],2,2,wf8(:,6),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,6),G0H12(3),m3h8x12(:,34),heltab2x96(:,:,294))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(21),n2h12(95))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(23)*M(3,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(322),h0tab(:,322),[38,25],[nMT,nMT],2,2,wf8(:,6),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,6),G0H12(3),m3h8x12(:,35),heltab2x96(:,:,295))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMT,G1H12(23),n2h12(96))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(3,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(323),h0tab(:,323),[38,25],[0,0],2,2,wf8(:,6),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,6),G0H12(3),m3h8x12(:,36),heltab2x96(:,:,296))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(47),n2h12(97))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(23)*M(3,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(324),h0tab(:,324),[38,25],[nMB,nMB],2,2,wf8(:,6),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,6),G0H12(3),m3h8x12(:,37),heltab2x96(:,:,297))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMB,G1H12(58),n2h12(98))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(16)*M(3,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(325),h0tab(:,325),[38,25],[0,0],2,2,wf8(:,6),wf12(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,6),38,G1H12(57),m3h8x12(:,38),heltab2x96(:,:,298))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(326),h0tab(:,326),[38,25],[0,0],2,2,wf8(:,6),wf12(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,6),38,G1H12(6),m3h8x12(:,39),heltab2x96(:,:,299))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(3,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(327),h0tab(:,327),[34,29],[0,nMT],2,2,wf4(:,7),wf24(:,17))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,7),G0H24(5),m3h4x24(:,45),heltab2x96(:,:,300))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(3,:)%j) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(328),h0tab(:,328),[46,17],[0,0],2,2,wf16(:,19),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf16(:,19),G0H6(5),m3h16x6(:,17),heltab2x96(:,:,301))
  call Hloop_Q_A(ntryL,G0H6(5),46,0,G1H6(76),n2h6(86))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(26)*M(4,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(329),h0tab(:,329),[38,25],[0,0],2,2,wf8(:,7),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,7),G0H12(3),m3h8x12(:,40),heltab2x96(:,:,302))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(10),n2h12(99))
  Gcoeff(:)%j = (c(23)*M(3,:)%j-c(24)*M(4,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(330),h0tab(:,330),[38,25],[nMT,nMT],2,2,wf8(:,7),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,7),G0H12(3),m3h8x12(:,41),heltab2x96(:,:,303))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMT,G1H12(16),n2h12(100))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(26)*M(4,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(331),h0tab(:,331),[38,25],[0,0],2,2,wf8(:,7),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,7),G0H12(3),m3h8x12(:,42),heltab2x96(:,:,304))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(19),n2h12(101))
  Gcoeff(:)%j = (c(23)*M(3,:)%j-c(24)*M(4,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(332),h0tab(:,332),[38,25],[nMB,nMB],2,2,wf8(:,7),wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,7),G0H12(3),m3h8x12(:,43),heltab2x96(:,:,305))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMB,G1H12(27),n2h12(102))
  Gcoeff(:)%j = (c(16)*M(3,:)%j-c(20)*M(4,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(333),h0tab(:,333),[38,25],[0,0],2,2,wf8(:,7),wf12(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,7),38,G1H12(8),m3h8x12(:,44),heltab2x96(:,:,306))
  Gcoeff(:)%j = (-(c(8)*M(3,:)%j)+c(9)*M(4,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(334),h0tab(:,334),[38,25],[0,0],2,2,wf8(:,7),wf12(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,7),38,G1H12(13),m3h8x12(:,45),heltab2x96(:,:,307))
  Gcoeff(:)%j = (-(c(13)*M(3,:)%j)+c(18)*M(4,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(335),h0tab(:,335),[36,27],[nMT,0],2,2,wf4(:,9),wf24(:,15))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,9),G0H24(6),m3h4x24(:,46),heltab2x96(:,:,308))
  call Hloop_A_Q(ntryL,G0H24(6),36,nMT,G1H24(4),n2h24(59))
  Gcoeff(:)%j = (-(c(13)*M(3,:)%j)+c(18)*M(4,:)%j) * den(150)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(336),h0tab(:,336),[46,17],[0,0],2,2,wf16(:,23),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf16(:,23),G0H6(2),m3h16x6(:,18),heltab2x96(:,:,309))
  call Hloop_Q_A(ntryL,G0H6(2),46,0,G1H6(28),n2h6(87))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(3,:)%j) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(337),h0tab(:,337),[34,29],[0,nMT],2,2,wf4(:,7),wf24(:,23))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,7),G0H24(1),m3h4x24(:,47),heltab2x96(:,:,310))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(13)*M(3,:)%j) * den(152)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(338),h0tab(:,338),[39,24],[0,0],2,2,wf16(:,17),wf6(:,4))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,17),G0H6(9),m3h16x6(:,19),heltab2x96(:,:,311))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(3,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(339),h0tab(:,339),[38,25],[0,0],2,2,wf8(:,6),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,6),G0H12(3),m3h8x12(:,46),heltab2x96(:,:,312))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(54),n2h12(103))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(23)*M(3,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(340),h0tab(:,340),[38,25],[nMT,nMT],2,2,wf8(:,6),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,6),G0H12(3),m3h8x12(:,47),heltab2x96(:,:,313))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMT,G1H12(31),n2h12(104))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(3,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(341),h0tab(:,341),[38,25],[0,0],2,2,wf8(:,6),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,6),G0H12(3),m3h8x12(:,48),heltab2x96(:,:,314))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(37),n2h12(105))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(23)*M(3,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(342),h0tab(:,342),[38,25],[nMB,nMB],2,2,wf8(:,6),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,6),G0H12(3),m3h8x12(:,49),heltab2x96(:,:,315))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMB,G1H12(44),n2h12(106))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(16)*M(3,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(343),h0tab(:,343),[38,25],[0,0],2,2,wf8(:,6),wf12(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,6),38,G1H12(49),m3h8x12(:,50),heltab2x96(:,:,316))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(344),h0tab(:,344),[38,25],[0,0],2,2,wf8(:,6),wf12(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,6),38,G1H12(56),m3h8x12(:,51),heltab2x96(:,:,317))
  Gcoeff(:)%j = (-(c(13)*M(3,:)%j)+c(18)*M(4,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(345),h0tab(:,345),[36,27],[nMT,0],2,2,wf4(:,9),wf24(:,21))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,9),G0H24(7),m3h4x24(:,48),heltab2x96(:,:,318))
  call Hloop_A_Q(ntryL,G0H24(7),36,nMT,G1H24(8),n2h24(60))
  Gcoeff(:)%j = (-(c(13)*M(3,:)%j)+c(18)*M(4,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(346),h0tab(:,346),[39,24],[0,0],2,2,wf16(:,21),wf6(:,4))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,21),G0H6(10),m3h16x6(:,20),heltab2x96(:,:,319))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(26)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(347),h0tab(:,347),[38,25],[0,0],2,2,wf8(:,7),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,7),G0H12(3),m3h8x12(:,52),heltab2x96(:,:,320))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(50),n2h12(107))
  Gcoeff(:)%j = (c(23)*M(3,:)%j-c(24)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(348),h0tab(:,348),[38,25],[nMT,nMT],2,2,wf8(:,7),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,7),G0H12(3),m3h8x12(:,53),heltab2x96(:,:,321))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMT,G1H12(22),n2h12(108))
  Gcoeff(:)%j = (c(25)*M(3,:)%j-c(26)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(349),h0tab(:,349),[38,25],[0,0],2,2,wf8(:,7),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,7),G0H12(3),m3h8x12(:,54),heltab2x96(:,:,322))
  call Hloop_Q_A(ntryL,G0H12(3),38,0,G1H12(38),n2h12(109))
  Gcoeff(:)%j = (c(23)*M(3,:)%j-c(24)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(350),h0tab(:,350),[38,25],[nMB,nMB],2,2,wf8(:,7),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,7),G0H12(3),m3h8x12(:,55),heltab2x96(:,:,323))
  call Hloop_Q_A(ntryL,G0H12(3),38,nMB,G1H12(2),n2h12(110))
  Gcoeff(:)%j = (c(16)*M(3,:)%j-c(20)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(351),h0tab(:,351),[38,25],[0,0],2,2,wf8(:,7),wf12(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,7),38,G1H12(35),m3h8x12(:,56),heltab2x96(:,:,324))
  Gcoeff(:)%j = (-(c(8)*M(3,:)%j)+c(9)*M(4,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(352),h0tab(:,352),[38,25],[0,0],2,2,wf8(:,7),wf12(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,7),38,G1H12(42),m3h8x12(:,57),heltab2x96(:,:,325))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(35),G1H4(4),G1H4(24),G1H4(1),G1H4(18),G1H4(52) &
    ,G1H4(45),G0H4(1),G0H4(2),G0H4(3),G0H4(4),G0H4(5),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(13),[G1H12(6),G1H12(53),G0H12(4),G0H12(5),G0H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(42),[G1H12(56),G1H12(52),G0H12(2),G0H12(1),G0H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(22),G1H4(26),G1H4(28),G1H4(32),G1H4(36) &
    ,G1H4(20),G1H4(21),G1H4(27),G1H4(39),G1H4(37),G1H4(23),G1H4(47),G1H4(16),G1H4(40),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(6),G1H4(5),G1H4(38),G1H4(29),G1H4(15),G1H4(25) &
    ,G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(30),G1H4(13),G1H4(7),G1H4(31),G1H4(8),G1H4(48) &
    ,G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(34),G1H4(14),G1H4(12),G1H4(11),G1H4(3),G1H4(49) &
    ,G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(28),[G1H6(76),G1H6(80),G1H6(86),G1H6(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(19),[G1H12(10),G1H12(47),G1H12(21),G1H12(36) &
    ,G1H12(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(16),[G1H12(23),G1H12(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(27),[G1H12(58),G1H12(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(8),[G1H12(57),G1H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(12),[G1H6(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(38),[G1H12(50),G1H12(37),G1H12(54),G1H12(14) &
    ,G1H12(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(22),[G1H12(31),G1H12(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(44),G1H12(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(35),[G1H12(49),G1H12(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(10),[G0H6(9),G0H6(6)])
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H48(1),wf4(:,1),wf12(:,1),G1tensor(1),m4h4x12x1(:,1),heltab3x48(:,:,1))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H48(3),wf12(:,1),wf4(:,1),G1tensor(22),m4h12x4x1(:,1),heltab3x48(:,:,2))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H48(18),wf4(:,1),wf12(:,1),G1tensor(61),m4h4x12x1(:,2),heltab3x48(:,:,3))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(17),57,wf4(:,1),6,G2tensor(225),m3h4x1(:,57),heltab2x4(:,:,125))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(13),38,wf12(:,1),25,G2tensor(160),m3h12x1(:,51),heltab2x12(:,:,179))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H48(20),wf4(:,1),wf12(:,4),G1tensor(91),m4h4x12x1(:,3),heltab3x48(:,:,4))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H48(5),wf12(:,4),wf4(:,1),G1tensor(121),m4h12x4x1(:,2),heltab3x48(:,:,5))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H48(2),wf4(:,1),wf12(:,4),G1tensor(151),m4h4x12x1(:,4),heltab3x48(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(42),38,wf12(:,4),25,G2tensor(163),m3h12x1(:,52),heltab2x12(:,:,180))
  call Hloop_VA_Q(ntryL,G0H24(10),wf24(:,6),G0H1(1),m3h24x1(:,17),heltab2x24(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,0,G1tensor(181),n2h1(378))
  call Hloop_QV_A(ntryL,G1H4(44),wf4(:,1),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(164),n2h1(379))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,1),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(167),n2h1(380))
  call Hloop_QV_A(ntryL,G1H4(46),wf4(:,1),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(171),n2h1(381))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(51),57,wf4(:,1),6,G2tensor(175),m3h4x1(:,61),heltab2x4(:,:,129))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(28),wf6(:,2),G1tensor(211),m3h6x1(:,69),heltab2x6(:,:,191))
  call Hloop_QV_A(ntryL,G1H12(19),wf12(:,1),G1H1(1),m3h12x1(:,53),heltab2x12(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(4),n2h1(382))
  call Hloop_QV_A(ntryL,G1H12(16),wf12(:,1),G1H1(1),m3h12x1(:,54),heltab2x12(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(263),n2h1(383))
  call Hloop_QV_A(ntryL,G1H12(27),wf12(:,1),G1H1(1),m3h12x1(:,55),heltab2x12(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(332),n2h1(384))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(8),38,wf12(:,1),25,G2tensor(344),m3h12x1(:,56),heltab2x12(:,:,184))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(6),wf8(:,3),G1tensor(241),m3h8x1(:,5),heltab2x8(:,:,48))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(12),wf6(:,4),G1tensor(271),m3h6x1(:,70),heltab2x6(:,:,192))
  call Hloop_VQ_A(ntryL,G0H24(2),wf24(:,8),G0H1(1),m3h24x1(:,18),heltab2x24(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(301),n2h1(385))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(7),wf8(:,5),G1tensor(331),m3h8x1(:,6),heltab2x8(:,:,49))
  call Hloop_QV_A(ntryL,G1H12(38),wf12(:,4),G1H1(1),m3h12x1(:,57),heltab2x12(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(350),n2h1(386))
  call Hloop_QV_A(ntryL,G1H12(22),wf12(:,4),G1H1(1),m3h12x1(:,58),heltab2x12(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(87),n2h1(387))
  call Hloop_QV_A(ntryL,G1H12(2),wf12(:,4),G1H1(1),m3h12x1(:,59),heltab2x12(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(235),n2h1(388))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(35),38,wf12(:,4),25,G2tensor(90),m3h12x1(:,60),heltab2x12(:,:,188))
  call Hloop_VQ_A(ntryL,G0H6(10),wf6(:,4),G0H1(1),m3h6x1(:,71),heltab2x6(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(62),n2h1(389))
  call Hloop_VQ_A(ntryL,G0H24(8),wf24(:,13),G0H1(1),m3h24x1(:,19),heltab2x24(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(66),n2h1(390))
  call Hloop_VA_Q(ntryL,G0H24(3),wf24(:,11),G0H1(1),m3h24x1(:,20),heltab2x24(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,0,G1tensor(102),n2h1(391))
  call Hloop_VA_Q(ntryL,G0H24(5),wf24(:,17),G0H1(1),m3h24x1(:,21),heltab2x24(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(140),n2h1(392))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H24(4),wf24(:,15),G1tensor(341),m3h24x1(:,22),heltab2x24(:,:,159))
  call Hloop_VA_Q(ntryL,G0H24(1),wf24(:,23),G0H1(1),m3h24x1(:,23),heltab2x24(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(114),n2h1(393))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H24(8),wf24(:,21),G1tensor(138),m3h24x1(:,24),heltab2x24(:,:,161))
  call ol_merge_tensors(G2tensor(175),[G2tensor(164),G2tensor(225),G0tensor(540),G0tensor(314),G0tensor(305),G0tensor(19) &
    ,G0tensor(332),G0tensor(613),G0tensor(130),G0tensor(551),G0tensor(366),G0tensor(186),G0tensor(166),G0tensor(126),G0tensor(86) &
    ,G0tensor(71),G0tensor(51),G0tensor(6)])
  call ol_merge_tensors(G0tensor(355),[G0tensor(198),G0tensor(250),G0tensor(257),G0tensor(398),G0tensor(135),G0tensor(367) &
    ,G0tensor(530),G0tensor(9),G0tensor(615),G0tensor(125),G0tensor(662),G0tensor(157),G0tensor(623),G0tensor(661),G0tensor(286) &
    ,G0tensor(246),G0tensor(31),G0tensor(11)])
  call ol_merge_tensors(G0tensor(140),[G0tensor(274),G0tensor(681),G0tensor(451),G0tensor(431),G0tensor(266),G0tensor(211) &
    ,G0tensor(16)])
  call ol_merge_tensors(G0tensor(363),[G0tensor(122),G0tensor(467),G0tensor(188),G0tensor(383),G0tensor(62),G0tensor(497) &
    ,G0tensor(55),G0tensor(668),G0tensor(666),G0tensor(626),G0tensor(531),G0tensor(466),G0tensor(226),G0tensor(206),G0tensor(151) &
    ,G0tensor(131),G0tensor(106),G0tensor(66),G0tensor(26)])
  call ol_merge_tensors(G1tensor(211),[G0tensor(592),G0tensor(517),G0tensor(319),G0tensor(224),G0tensor(680),G0tensor(150) &
    ,G0tensor(48),G0tensor(229),G0tensor(602),G0tensor(671),G0tensor(411),G0tensor(331),G0tensor(306),G0tensor(171) &
    ,G0tensor(36)])
  call ol_merge_tensors(G0tensor(578),[G0tensor(139),G0tensor(418),G0tensor(64),G0tensor(17),G0tensor(682),G0tensor(197) &
    ,G0tensor(110),G0tensor(635),G0tensor(348),G0tensor(528),G0tensor(302),G0tensor(646),G0tensor(511),G0tensor(426),G0tensor(406) &
    ,G0tensor(346),G0tensor(146),G0tensor(111),G0tensor(91),G0tensor(46)])
  call ol_merge_tensors(G1tensor(241),[G0tensor(588),G0tensor(442),G0tensor(445),G0tensor(3),G0tensor(70),G0tensor(621) &
    ,G0tensor(536),G0tensor(326),G0tensor(311),G0tensor(291),G0tensor(96),G0tensor(56)])
  call ol_merge_tensors(G1tensor(331),[G0tensor(352),G0tensor(228),G0tensor(183),G0tensor(637),G0tensor(155),G0tensor(641) &
    ,G0tensor(516),G0tensor(386),G0tensor(136),G0tensor(76)])
  call ol_merge_tensors(G0tensor(232),[G0tensor(2),G0tensor(556),G0tensor(446),G0tensor(271),G0tensor(251),G0tensor(156) &
    ,G0tensor(116)])
  call ol_merge_tensors(G1tensor(102),[G1tensor(181),G0tensor(632),G0tensor(527),G0tensor(345),G0tensor(10),G0tensor(85) &
    ,G0tensor(663),G0tensor(351),G0tensor(216),G0tensor(176)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(350),G2tensor(344),G2tensor(4),G2tensor(163),G2tensor(160),G0tensor(582) &
    ,G0tensor(117),G0tensor(620),G0tensor(315),G0tensor(452),G0tensor(328),G0tensor(463),G0tensor(576),G0tensor(476),G0tensor(416) &
    ,G0tensor(256),G0tensor(191)])
  call ol_merge_tensors(G1tensor(151),[G1tensor(121),G1tensor(91),G1tensor(61),G1tensor(22),G1tensor(1),G0tensor(213) &
    ,G0tensor(210),G0tensor(163),G0tensor(654),G0tensor(13),G0tensor(430),G0tensor(303),G0tensor(617),G0tensor(75),G0tensor(642) &
    ,G0tensor(496),G0tensor(456),G0tensor(396),G0tensor(356),G0tensor(336),G0tensor(316),G0tensor(276),G0tensor(236) &
    ,G0tensor(196)])
  call ol_merge_tensors(G1tensor(66),[G1tensor(301),G0tensor(174),G0tensor(295),G0tensor(89),G0tensor(30),G0tensor(630) &
    ,G0tensor(599),G0tensor(650),G0tensor(436),G0tensor(376),G0tensor(296),G0tensor(231)])
  call ol_merge_tensors(G1tensor(62),[G1tensor(271),G0tensor(443),G0tensor(144),G0tensor(147),G0tensor(572),G0tensor(245) &
    ,G0tensor(109),G0tensor(558),G0tensor(448),G0tensor(29),G0tensor(12),G0tensor(297),G0tensor(471),G0tensor(391) &
    ,G0tensor(371)])
  call ol_merge_tensors(G0tensor(290),[G0tensor(587),G0tensor(38),G0tensor(470),G0tensor(18),G0tensor(14),G0tensor(402) &
    ,G0tensor(264),G0tensor(284),G0tensor(307),G0tensor(115),G0tensor(486)])
  call ol_merge_tensors(G0tensor(542),[G0tensor(354),G0tensor(548),G0tensor(84),G0tensor(440),G0tensor(491)])
  call ol_merge_tensors(G0tensor(253),[G0tensor(283),G0tensor(520),G0tensor(207),G0tensor(218),G0tensor(194),G0tensor(490) &
    ,G0tensor(172),G0tensor(154),G0tensor(580),G0tensor(280),G0tensor(292),G0tensor(508),G0tensor(134),G0tensor(272),G0tensor(137) &
    ,G0tensor(565),G0tensor(255),G0tensor(597),G0tensor(535),G0tensor(222),G0tensor(102),G0tensor(94),G0tensor(515),G0tensor(168) &
    ,G0tensor(522),G0tensor(288),G0tensor(52),G0tensor(87),G0tensor(49),G0tensor(165),G0tensor(425),G0tensor(415),G0tensor(595) &
    ,G0tensor(28),G0tensor(108),G0tensor(187),G0tensor(410),G0tensor(427),G0tensor(5),G0tensor(387),G0tensor(45),G0tensor(98) &
    ,G0tensor(413),G0tensor(32),G0tensor(247),G0tensor(339),G0tensor(657),G0tensor(543),G0tensor(159),G0tensor(478),G0tensor(357) &
    ,G0tensor(299),G0tensor(502),G0tensor(334),G0tensor(309),G0tensor(220),G0tensor(60),G0tensor(335),G0tensor(330),G0tensor(340) &
    ,G0tensor(600),G0tensor(78),G0tensor(655),G0tensor(512),G0tensor(74),G0tensor(560),G0tensor(380),G0tensor(395),G0tensor(605) &
    ,G0tensor(300),G0tensor(342),G0tensor(233),G0tensor(327),G0tensor(263),G0tensor(608),G0tensor(262),G0tensor(611),G0tensor(586) &
    ,G0tensor(501)])
  call ol_merge_tensors(G0tensor(268),[G0tensor(175),G0tensor(273),G0tensor(370),G0tensor(8),G0tensor(100),G0tensor(651) &
    ,G0tensor(631),G0tensor(561),G0tensor(541),G0tensor(521)])
  call ol_merge_tensors(G0tensor(507),[G0tensor(184),G0tensor(129),G0tensor(53),G0tensor(360),G0tensor(318),G0tensor(158) &
    ,G0tensor(23),G0tensor(437),G0tensor(63),G0tensor(596),G0tensor(571)])
  call ol_merge_tensors(G1tensor(138),[G1tensor(341),G0tensor(358),G0tensor(227),G0tensor(667),G0tensor(397),G0tensor(304) &
    ,G0tensor(72),G0tensor(581)])
  call ol_merge_tensors(G1tensor(114),[G1tensor(140),G0tensor(179),G0tensor(562),G0tensor(423),G0tensor(185),G0tensor(647) &
    ,G0tensor(593),G0tensor(435),G0tensor(601)])
  call ol_merge_tensors(G0tensor(378),[G0tensor(104),G0tensor(143),G0tensor(113),G0tensor(665),G0tensor(420),G0tensor(333) &
    ,G0tensor(606)])
  call ol_merge_tensors(G0tensor(214),[G0tensor(349),G0tensor(495),G0tensor(92),G0tensor(170),G0tensor(590),G0tensor(203) &
    ,G0tensor(95),G0tensor(44),G0tensor(610),G0tensor(570),G0tensor(164),G0tensor(317),G0tensor(622)])
  call ol_merge_tensors(G2tensor(167),[G0tensor(195),G0tensor(279),G0tensor(338)])
  call ol_merge_tensors(G0tensor(585),[G0tensor(152),G0tensor(275),G0tensor(39),G0tensor(350),G0tensor(677),G0tensor(234) &
    ,G0tensor(259),G0tensor(625),G0tensor(308),G0tensor(638),G0tensor(312),G0tensor(82)])
  call ol_merge_tensors(G0tensor(149),[G0tensor(537),G0tensor(675),G0tensor(83),G0tensor(24),G0tensor(633)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(263),G0tensor(58),G0tensor(645),G0tensor(294),G0tensor(249)])
  call ol_merge_tensors(G2tensor(171),[G0tensor(670)])
  call ol_merge_tensors(G2tensor(235),[G2tensor(332),G0tensor(660)])
  call ol_merge_tensors(G0tensor(347),[G0tensor(42),G0tensor(69),G0tensor(659),G0tensor(37),G0tensor(320)])
  call ol_merge_tensors(G0tensor(153),[G0tensor(577),G0tensor(35),G0tensor(160)])
  call ol_merge_tensors(G0tensor(225),[G0tensor(400),G0tensor(4),G0tensor(377),G0tensor(460),G0tensor(120),G0tensor(105)])
  call ol_merge_tensors(G0tensor(458),[G0tensor(177),G0tensor(128),G0tensor(215),G0tensor(567)])
  call ol_merge_tensors(G0tensor(532),[G0tensor(428),G0tensor(107),G0tensor(178),G0tensor(90),G0tensor(500)])
  call ol_merge_tensors(G0tensor(583),[G0tensor(510),G0tensor(223),G0tensor(254),G0tensor(557)])
  call ol_merge_tensors(G0tensor(403),[G0tensor(392),G0tensor(167),G0tensor(634),G0tensor(473),G0tensor(193)])
  call ol_merge_tensors(G0tensor(208),[G0tensor(492),G0tensor(373),G0tensor(652),G0tensor(362)])
  call ol_merge_tensors(G0tensor(555),[G0tensor(462),G0tensor(57),G0tensor(277),G0tensor(644),G0tensor(192)])
  call ol_merge_tensors(G0tensor(204),[G0tensor(114),G0tensor(162),G0tensor(685)])
  call ol_merge_tensors(G0tensor(80),[G0tensor(477),G0tensor(15),G0tensor(432)])
  call ol_merge_tensors(G0tensor(212),[G0tensor(209),G0tensor(518),G0tensor(465),G0tensor(457)])
  call ol_merge_tensors(G0tensor(293),[G0tensor(142),G0tensor(33),G0tensor(138)])
  call ol_merge_tensors(G0tensor(388),[G0tensor(118),G0tensor(252),G0tensor(93),G0tensor(59),G0tensor(79),G0tensor(133)])
  call ol_merge_tensors(G0tensor(270),[G0tensor(127),G0tensor(124),G0tensor(123),G0tensor(525),G0tensor(180)])
call TI_bubble_red(G2tensor(175),57,mass2set(:,1),G0tensor(243),M2L1R1)
call TI_bubble_red(G2tensor(90),38,mass2set(:,1),G0tensor(545),M2L1R1)
call TI_bubble_red(G2tensor(167),57,mass2set(:,2),G0tensor(258),M2L1R1,G0tensor(248))
call TI_bubble_red(G2tensor(87),38,mass2set(:,2),G0tensor(372),M2L1R1,G0tensor(368))
call TI_bubble_red(G2tensor(171),57,mass2set(:,3),G0tensor(359),M2L1R1,G0tensor(382))
call TI_bubble_red(G2tensor(235),38,mass2set(:,3),G0tensor(369),M2L1R1,G0tensor(364))
  call ol_merge_tensors(G0tensor(368),[G0tensor(248),G0tensor(253)])
  call ol_merge_tensors(G0tensor(324),[G0tensor(364),G0tensor(382)])
call TI_bubble_red(G1tensor(211),46,mass2set(:,1),G0tensor(393),M2L1R1)
call TI_bubble_red(G1tensor(241),49,mass2set(:,1),G0tensor(379),M2L1R1)
call TI_bubble_red(G1tensor(331),56,mass2set(:,1),G0tensor(374),M2L1R1)
call TI_bubble_red(G1tensor(102),40,mass2set(:,1),G0tensor(674),M2L1R1)
call TI_bubble_red(G1tensor(151),32,mass2set(:,1),G0tensor(394),M2L1R1)
call TI_bubble_red(G1tensor(66),33,mass2set(:,1),G0tensor(389),M2L1R1)
call TI_bubble_red(G1tensor(62),39,mass2set(:,1),G0tensor(384),M2L1R1)
call TI_bubble_red(G1tensor(138),36,mass2set(:,4),G0tensor(493),M2L1R1,G0tensor(412))
call TI_bubble_red(G1tensor(114),34,mass2set(:,5),G0tensor(408),M2L1R1,G0tensor(399))
  call ol_merge_tensors(G0tensor(399),[G0tensor(412),G0tensor(368)])
  call ol_merge_tensors(T0sum(265),[G0tensor(243)])
  call ol_merge_tensors(T0sum(266),[G0tensor(355)])
  call ol_merge_tensors(T0sum(267),[G0tensor(140)])
  call ol_merge_tensors(T0sum(268),[G0tensor(363)])
  call ol_merge_tensors(T0sum(269),[G0tensor(393)])
  call ol_merge_tensors(T0sum(270),[G0tensor(578)])
  call ol_merge_tensors(T0sum(271),[G0tensor(379)])
  call ol_merge_tensors(T0sum(272),[G0tensor(374)])
  call ol_merge_tensors(T0sum(273),[G0tensor(232)])
  call ol_merge_tensors(T0sum(274),[G0tensor(674)])
  call ol_merge_tensors(T0sum(275),[G0tensor(545)])
  call ol_merge_tensors(T0sum(276),[G0tensor(394)])
  call ol_merge_tensors(T0sum(277),[G0tensor(389)])
  call ol_merge_tensors(T0sum(278),[G0tensor(384)])
  call ol_merge_tensors(T0sum(279),[G0tensor(290)])
  call ol_merge_tensors(T0sum(280),[G0tensor(542)])
  call ol_merge_tensors(T0sum(281),[G0tensor(399)])
  call ol_merge_tensors(T0sum(282),[G0tensor(268)])
  call ol_merge_tensors(T0sum(283),[G0tensor(507)])
  call ol_merge_tensors(T0sum(284),[G0tensor(493)])
  call ol_merge_tensors(T0sum(285),[G0tensor(408)])
  call ol_merge_tensors(T0sum(286),[G0tensor(378)])
  call ol_merge_tensors(T0sum(287),[G0tensor(214)])
  call ol_merge_tensors(T0sum(288),[G0tensor(258)])
  call ol_merge_tensors(T0sum(289),[G0tensor(585)])
  call ol_merge_tensors(T0sum(290),[G0tensor(149)])
  call ol_merge_tensors(T0sum(291),[G0tensor(372)])
  call ol_merge_tensors(T0sum(292),[G0tensor(359)])
  call ol_merge_tensors(T0sum(293),[G0tensor(324)])
  call ol_merge_tensors(T0sum(294),[G0tensor(369)])
  call ol_merge_tensors(T0sum(295),[G0tensor(344)])
  call ol_merge_tensors(T0sum(296),[G0tensor(347)])
  call ol_merge_tensors(T0sum(297),[G0tensor(153)])
  call ol_merge_tensors(T0sum(298),[G0tensor(225)])
  call ol_merge_tensors(T0sum(299),[G0tensor(458)])
  call ol_merge_tensors(T0sum(300),[G0tensor(532)])
  call ol_merge_tensors(T0sum(301),[G0tensor(583)])
  call ol_merge_tensors(T0sum(302),[G0tensor(403)])
  call ol_merge_tensors(T0sum(303),[G0tensor(208)])
  call ol_merge_tensors(T0sum(304),[G0tensor(555)])
  call ol_merge_tensors(T0sum(305),[G0tensor(204)])
  call ol_merge_tensors(T0sum(306),[G0tensor(80)])
  call ol_merge_tensors(T0sum(307),[G0tensor(212)])
  call ol_merge_tensors(T0sum(308),[G0tensor(293)])
  call ol_merge_tensors(T0sum(309),[G0tensor(388)])
  call ol_merge_tensors(T0sum(310),[G0tensor(270)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 49, 57, 59 ],masses2_18,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 33, 57, 59 ],masses2_18,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 33, 49, 59 ],masses2_18,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 33, 49, 57 ],masses2_16,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 16, 24, 26 ],masses2_18,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 32, 57, 59 ],masses2_18,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 32, 49, 59 ],masses2_18,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 32, 49, 57 ],masses2_16,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 17, 25, 27 ],masses2_18,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 32, 33, 59 ],masses2_18,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 32, 33, 57 ],masses2_16,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 1, 25, 27 ],masses2_18,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 32, 33, 49 ],masses2_16,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 1, 17, 27 ],masses2_18,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 1, 17, 25 ],masses2_16,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 49, 57, 61 ],masses2_18,RedSet_4(16),ScalarBoxes(16))
  call compute_scalar_box([ 33, 57, 61 ],masses2_18,RedSet_4(17),ScalarBoxes(17))
  call compute_scalar_box([ 33, 49, 61 ],masses2_18,RedSet_4(18),ScalarBoxes(18))
  call compute_scalar_box([ 16, 24, 28 ],masses2_18,RedSet_4(19),ScalarBoxes(19))
  call compute_scalar_box([ 32, 57, 61 ],masses2_18,RedSet_4(20),ScalarBoxes(20))
  call compute_scalar_box([ 32, 49, 61 ],masses2_18,RedSet_4(21),ScalarBoxes(21))
  call compute_scalar_box([ 17, 25, 29 ],masses2_18,RedSet_4(22),ScalarBoxes(22))
  call compute_scalar_box([ 32, 33, 61 ],masses2_18,RedSet_4(23),ScalarBoxes(23))
  call compute_scalar_box([ 1, 25, 29 ],masses2_18,RedSet_4(24),ScalarBoxes(24))
  call compute_scalar_box([ 1, 17, 29 ],masses2_18,RedSet_4(25),ScalarBoxes(25))
  call compute_scalar_box([ 38, 39, 55 ],masses2_16,RedSet_4(26),ScalarBoxes(26))
  call compute_scalar_box([ 36, 39, 55 ],masses2_21,RedSet_4(27),ScalarBoxes(27))
  call compute_scalar_box([ 36, 38, 55 ],masses2_21,RedSet_4(28),ScalarBoxes(28))
  call compute_scalar_box([ 36, 38, 39 ],masses2_21,RedSet_4(29),ScalarBoxes(29))
  call compute_scalar_box([ 2, 3, 19 ],masses2_17,RedSet_4(30),ScalarBoxes(30))
  call compute_scalar_box([ 32, 39, 55 ],masses2_16,RedSet_4(31),ScalarBoxes(31))
  call compute_scalar_box([ 32, 38, 55 ],masses2_16,RedSet_4(32),ScalarBoxes(32))
  call compute_scalar_box([ 32, 38, 39 ],masses2_16,RedSet_4(33),ScalarBoxes(33))
  call compute_scalar_box([ 6, 7, 23 ],masses2_16,RedSet_4(34),ScalarBoxes(34))
  call compute_scalar_box([ 32, 36, 55 ],masses2_19,RedSet_4(35),ScalarBoxes(35))
  call compute_scalar_box([ 32, 36, 39 ],masses2_19,RedSet_4(36),ScalarBoxes(36))
  call compute_scalar_box([ 4, 7, 23 ],masses2_21,RedSet_4(37),ScalarBoxes(37))
  call compute_scalar_box([ 32, 36, 38 ],masses2_19,RedSet_4(38),ScalarBoxes(38))
  call compute_scalar_box([ 4, 6, 23 ],masses2_21,RedSet_4(39),ScalarBoxes(39))
  call compute_scalar_box([ 4, 6, 7 ],masses2_21,RedSet_4(40),ScalarBoxes(40))
  call compute_scalar_box([ 34, 39, 55 ],masses2_21,RedSet_4(41),ScalarBoxes(41))
  call compute_scalar_box([ 34, 38, 55 ],masses2_21,RedSet_4(42),ScalarBoxes(42))
  call compute_scalar_box([ 34, 38, 39 ],masses2_21,RedSet_4(43),ScalarBoxes(43))
  call compute_scalar_box([ 4, 5, 21 ],masses2_17,RedSet_4(44),ScalarBoxes(44))
  call compute_scalar_box([ 32, 34, 55 ],masses2_19,RedSet_4(45),ScalarBoxes(45))
  call compute_scalar_box([ 32, 34, 39 ],masses2_19,RedSet_4(46),ScalarBoxes(46))
  call compute_scalar_box([ 2, 7, 23 ],masses2_21,RedSet_4(47),ScalarBoxes(47))
  call compute_scalar_box([ 32, 34, 38 ],masses2_19,RedSet_4(48),ScalarBoxes(48))
  call compute_scalar_box([ 2, 6, 23 ],masses2_21,RedSet_4(49),ScalarBoxes(49))
  call compute_scalar_box([ 2, 6, 7 ],masses2_21,RedSet_4(50),ScalarBoxes(50))
  call compute_scalar_box([ 35, 51, 59 ],masses2_17,RedSet_4(51),ScalarBoxes(51))
  call compute_scalar_box([ 34, 51, 59 ],masses2_17,RedSet_4(52),ScalarBoxes(52))
  call compute_scalar_box([ 34, 35, 59 ],masses2_17,RedSet_4(53),ScalarBoxes(53))
  call compute_scalar_box([ 34, 35, 51 ],masses2_17,RedSet_4(54),ScalarBoxes(54))
  call compute_scalar_box([ 32, 51, 59 ],masses2_22,RedSet_4(55),ScalarBoxes(55))
  call compute_scalar_box([ 32, 35, 59 ],masses2_22,RedSet_4(56),ScalarBoxes(56))
  call compute_scalar_box([ 32, 35, 51 ],masses2_22,RedSet_4(57),ScalarBoxes(57))
  call compute_scalar_box([ 3, 19, 27 ],masses2_17,RedSet_4(58),ScalarBoxes(58))
  call compute_scalar_box([ 32, 34, 59 ],masses2_22,RedSet_4(59),ScalarBoxes(59))
  call compute_scalar_box([ 32, 34, 51 ],masses2_22,RedSet_4(60),ScalarBoxes(60))
  call compute_scalar_box([ 2, 19, 27 ],masses2_17,RedSet_4(61),ScalarBoxes(61))
  call compute_scalar_box([ 32, 34, 35 ],masses2_22,RedSet_4(62),ScalarBoxes(62))
  call compute_scalar_box([ 2, 3, 27 ],masses2_17,RedSet_4(63),ScalarBoxes(63))
  call compute_scalar_box([ 42, 58, 59 ],masses2_17,RedSet_4(64),ScalarBoxes(64))
  call compute_scalar_box([ 34, 58, 59 ],masses2_17,RedSet_4(65),ScalarBoxes(65))
  call compute_scalar_box([ 34, 42, 59 ],masses2_17,RedSet_4(66),ScalarBoxes(66))
  call compute_scalar_box([ 34, 42, 58 ],masses2_17,RedSet_4(67),ScalarBoxes(67))
  call compute_scalar_box([ 8, 24, 25 ],masses2_16,RedSet_4(68),ScalarBoxes(68))
  call compute_scalar_box([ 32, 58, 59 ],masses2_22,RedSet_4(69),ScalarBoxes(69))
  call compute_scalar_box([ 32, 42, 59 ],masses2_22,RedSet_4(70),ScalarBoxes(70))
  call compute_scalar_box([ 32, 42, 58 ],masses2_22,RedSet_4(71),ScalarBoxes(71))
  call compute_scalar_box([ 10, 26, 27 ],masses2_17,RedSet_4(72),ScalarBoxes(72))
  call compute_scalar_box([ 32, 34, 58 ],masses2_22,RedSet_4(73),ScalarBoxes(73))
  call compute_scalar_box([ 2, 26, 27 ],masses2_17,RedSet_4(74),ScalarBoxes(74))
  call compute_scalar_box([ 32, 34, 42 ],masses2_22,RedSet_4(75),ScalarBoxes(75))
  call compute_scalar_box([ 2, 10, 27 ],masses2_17,RedSet_4(76),ScalarBoxes(76))
  call compute_scalar_box([ 2, 10, 26 ],masses2_17,RedSet_4(77),ScalarBoxes(77))
  call compute_scalar_box([ 44, 46, 47 ],masses2_21,RedSet_4(78),ScalarBoxes(78))
  call compute_scalar_box([ 40, 46, 47 ],masses2_16,RedSet_4(79),ScalarBoxes(79))
  call compute_scalar_box([ 40, 44, 47 ],masses2_19,RedSet_4(80),ScalarBoxes(80))
  call compute_scalar_box([ 40, 44, 46 ],masses2_19,RedSet_4(81),ScalarBoxes(81))
  call compute_scalar_box([ 32, 46, 47 ],masses2_16,RedSet_4(82),ScalarBoxes(82))
  call compute_scalar_box([ 32, 44, 47 ],masses2_19,RedSet_4(83),ScalarBoxes(83))
  call compute_scalar_box([ 32, 44, 46 ],masses2_19,RedSet_4(84),ScalarBoxes(84))
  call compute_scalar_box([ 12, 14, 15 ],masses2_21,RedSet_4(85),ScalarBoxes(85))
  call compute_scalar_box([ 32, 40, 47 ],masses2_16,RedSet_4(86),ScalarBoxes(86))
  call compute_scalar_box([ 32, 40, 46 ],masses2_16,RedSet_4(87),ScalarBoxes(87))
  call compute_scalar_box([ 8, 14, 15 ],masses2_16,RedSet_4(88),ScalarBoxes(88))
  call compute_scalar_box([ 32, 40, 44 ],masses2_18,RedSet_4(89),ScalarBoxes(89))
  call compute_scalar_box([ 8, 12, 15 ],masses2_19,RedSet_4(90),ScalarBoxes(90))
  call compute_scalar_box([ 8, 12, 14 ],masses2_19,RedSet_4(91),ScalarBoxes(91))
  call compute_scalar_box([ 35, 39, 47 ],masses2_21,RedSet_4(92),ScalarBoxes(92))
  call compute_scalar_box([ 33, 39, 47 ],masses2_16,RedSet_4(93),ScalarBoxes(93))
  call compute_scalar_box([ 33, 35, 47 ],masses2_19,RedSet_4(94),ScalarBoxes(94))
  call compute_scalar_box([ 33, 35, 39 ],masses2_19,RedSet_4(95),ScalarBoxes(95))
  call compute_scalar_box([ 2, 6, 14 ],masses2_21,RedSet_4(96),ScalarBoxes(96))
  call compute_scalar_box([ 32, 39, 47 ],masses2_16,RedSet_4(97),ScalarBoxes(97))
  call compute_scalar_box([ 32, 35, 47 ],masses2_19,RedSet_4(98),ScalarBoxes(98))
  call compute_scalar_box([ 32, 35, 39 ],masses2_19,RedSet_4(99),ScalarBoxes(99))
  call compute_scalar_box([ 3, 7, 15 ],masses2_21,RedSet_4(100),ScalarBoxes(100))
  call compute_scalar_box([ 32, 33, 47 ],masses2_16,RedSet_4(101),ScalarBoxes(101))
  call compute_scalar_box([ 32, 33, 39 ],masses2_16,RedSet_4(102),ScalarBoxes(102))
  call compute_scalar_box([ 1, 7, 15 ],masses2_16,RedSet_4(103),ScalarBoxes(103))
  call compute_scalar_box([ 32, 33, 35 ],masses2_18,RedSet_4(104),ScalarBoxes(104))
  call compute_scalar_box([ 1, 3, 15 ],masses2_19,RedSet_4(105),ScalarBoxes(105))
  call compute_scalar_box([ 1, 3, 7 ],masses2_19,RedSet_4(106),ScalarBoxes(106))
  call compute_scalar_box([ 42, 46, 47 ],masses2_21,RedSet_4(107),ScalarBoxes(107))
  call compute_scalar_box([ 40, 42, 47 ],masses2_19,RedSet_4(108),ScalarBoxes(108))
  call compute_scalar_box([ 40, 42, 46 ],masses2_19,RedSet_4(109),ScalarBoxes(109))
  call compute_scalar_box([ 32, 42, 47 ],masses2_19,RedSet_4(110),ScalarBoxes(110))
  call compute_scalar_box([ 32, 42, 46 ],masses2_19,RedSet_4(111),ScalarBoxes(111))
  call compute_scalar_box([ 10, 14, 15 ],masses2_21,RedSet_4(112),ScalarBoxes(112))
  call compute_scalar_box([ 32, 40, 42 ],masses2_18,RedSet_4(113),ScalarBoxes(113))
  call compute_scalar_box([ 8, 10, 15 ],masses2_19,RedSet_4(114),ScalarBoxes(114))
  call compute_scalar_box([ 8, 10, 14 ],masses2_19,RedSet_4(115),ScalarBoxes(115))
  call compute_scalar_box([ 37, 39, 47 ],masses2_21,RedSet_4(116),ScalarBoxes(116))
  call compute_scalar_box([ 33, 37, 47 ],masses2_19,RedSet_4(117),ScalarBoxes(117))
  call compute_scalar_box([ 33, 37, 39 ],masses2_19,RedSet_4(118),ScalarBoxes(118))
  call compute_scalar_box([ 4, 6, 14 ],masses2_21,RedSet_4(119),ScalarBoxes(119))
  call compute_scalar_box([ 32, 37, 47 ],masses2_19,RedSet_4(120),ScalarBoxes(120))
  call compute_scalar_box([ 32, 37, 39 ],masses2_19,RedSet_4(121),ScalarBoxes(121))
  call compute_scalar_box([ 5, 7, 15 ],masses2_21,RedSet_4(122),ScalarBoxes(122))
  call compute_scalar_box([ 32, 33, 37 ],masses2_18,RedSet_4(123),ScalarBoxes(123))
  call compute_scalar_box([ 1, 5, 15 ],masses2_19,RedSet_4(124),ScalarBoxes(124))
  call compute_scalar_box([ 1, 5, 7 ],masses2_19,RedSet_4(125),ScalarBoxes(125))
  call compute_scalar_box([ 38, 46, 62 ],masses2_16,RedSet_4(131),ScalarBoxes(126))
  call compute_scalar_box([ 36, 46, 62 ],masses2_21,RedSet_4(132),ScalarBoxes(127))
  call compute_scalar_box([ 36, 38, 62 ],masses2_21,RedSet_4(133),ScalarBoxes(128))
  call compute_scalar_box([ 36, 38, 46 ],masses2_21,RedSet_4(134),ScalarBoxes(129))
  call compute_scalar_box([ 56, 60, 62 ],masses2_19,RedSet_4(135),ScalarBoxes(130))
  call compute_scalar_box([ 48, 60, 62 ],masses2_19,RedSet_4(136),ScalarBoxes(131))
  call compute_scalar_box([ 48, 56, 62 ],masses2_16,RedSet_4(137),ScalarBoxes(132))
  call compute_scalar_box([ 48, 56, 60 ],masses2_18,RedSet_4(138),ScalarBoxes(133))
  call compute_scalar_box([ 49, 51, 55 ],masses2_19,RedSet_4(139),ScalarBoxes(134))
  call compute_scalar_box([ 48, 51, 55 ],masses2_19,RedSet_4(140),ScalarBoxes(135))
  call compute_scalar_box([ 48, 49, 55 ],masses2_16,RedSet_4(141),ScalarBoxes(136))
  call compute_scalar_box([ 48, 49, 51 ],masses2_18,RedSet_4(142),ScalarBoxes(137))
  call compute_scalar_box([ 56, 58, 62 ],masses2_19,RedSet_4(143),ScalarBoxes(138))
  call compute_scalar_box([ 48, 58, 62 ],masses2_19,RedSet_4(144),ScalarBoxes(139))
  call compute_scalar_box([ 48, 56, 58 ],masses2_18,RedSet_4(145),ScalarBoxes(140))
  call compute_scalar_box([ 49, 53, 55 ],masses2_19,RedSet_4(146),ScalarBoxes(141))
  call compute_scalar_box([ 48, 53, 55 ],masses2_19,RedSet_4(147),ScalarBoxes(142))
  call compute_scalar_box([ 48, 49, 53 ],masses2_18,RedSet_4(148),ScalarBoxes(143))
  call compute_scalar_box([ 37, 53, 61 ],masses2_17,RedSet_4(149),ScalarBoxes(144))
  call compute_scalar_box([ 36, 53, 61 ],masses2_17,RedSet_4(150),ScalarBoxes(145))
  call compute_scalar_box([ 36, 37, 61 ],masses2_17,RedSet_4(151),ScalarBoxes(146))
  call compute_scalar_box([ 36, 37, 53 ],masses2_17,RedSet_4(152),ScalarBoxes(147))
  call compute_scalar_box([ 32, 38, 46 ],masses2_16,RedSet_4(128),ScalarBoxes(148))
  call compute_scalar_box([ 32, 36, 46 ],masses2_19,RedSet_4(153),ScalarBoxes(149))
  call compute_scalar_box([ 34, 38, 46 ],masses2_21,RedSet_4(154),ScalarBoxes(150))
  call compute_scalar_box([ 32, 34, 46 ],masses2_19,RedSet_4(155),ScalarBoxes(151))
  call compute_scalar_box([ 33, 49, 55 ],masses2_16,RedSet_4(156),ScalarBoxes(152))
  call compute_scalar_box([ 32, 49, 55 ],masses2_16,RedSet_4(157),ScalarBoxes(153))
  call compute_scalar_box([ 32, 33, 55 ],masses2_16,RedSet_4(126),ScalarBoxes(154))
  call compute_scalar_box([ 1, 17, 23 ],masses2_16,RedSet_4(158),ScalarBoxes(155))
  call compute_scalar_box([ 33, 39, 55 ],masses2_16,RedSet_4(159),ScalarBoxes(156))
  call compute_scalar_box([ 1, 7, 23 ],masses2_16,RedSet_4(160),ScalarBoxes(157))
  call compute_scalar_box([ 38, 54, 55 ],masses2_16,RedSet_4(161),ScalarBoxes(158))
  call compute_scalar_box([ 32, 54, 55 ],masses2_16,RedSet_4(162),ScalarBoxes(159))
  call compute_scalar_box([ 32, 38, 54 ],masses2_16,RedSet_4(127),ScalarBoxes(160))
  call compute_scalar_box([ 6, 22, 23 ],masses2_16,RedSet_4(163),ScalarBoxes(161))
  call compute_scalar_box([ 38, 46, 47 ],masses2_16,RedSet_4(164),ScalarBoxes(162))
  call compute_scalar_box([ 32, 38, 47 ],masses2_16,RedSet_4(165),ScalarBoxes(163))
  call compute_scalar_box([ 6, 14, 15 ],masses2_16,RedSet_4(166),ScalarBoxes(164))
  call compute_scalar_box([ 33, 41, 57 ],masses2_16,RedSet_4(167),ScalarBoxes(165))
  call compute_scalar_box([ 32, 41, 57 ],masses2_16,RedSet_4(168),ScalarBoxes(166))
  call compute_scalar_box([ 32, 33, 41 ],masses2_16,RedSet_4(129),ScalarBoxes(167))
  call compute_scalar_box([ 1, 9, 25 ],masses2_16,RedSet_4(169),ScalarBoxes(168))
  call compute_scalar_box([ 33, 41, 47 ],masses2_16,RedSet_4(170),ScalarBoxes(169))
  call compute_scalar_box([ 32, 41, 47 ],masses2_16,RedSet_4(171),ScalarBoxes(170))
  call compute_scalar_box([ 1, 9, 15 ],masses2_16,RedSet_4(172),ScalarBoxes(171))
  call compute_scalar_box([ 38, 39, 47 ],masses2_16,RedSet_4(173),ScalarBoxes(172))
  call compute_scalar_box([ 6, 7, 15 ],masses2_16,RedSet_4(174),ScalarBoxes(173))
  call compute_scalar_box([ 40, 41, 47 ],masses2_16,RedSet_4(175),ScalarBoxes(174))
  call compute_scalar_box([ 32, 40, 41 ],masses2_16,RedSet_4(130),ScalarBoxes(175))
  call compute_scalar_box([ 8, 9, 15 ],masses2_16,RedSet_4(176),ScalarBoxes(176))
! end of process


end subroutine vamp_3

end module ol_vamp_3_ppwttj_uxttxdwxg_1_/**/REALKIND
