
module ol_vamp_1_ppwttj_uttxdxwg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwttj_uttxdxwg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwttj_uttxdxwg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwttj_uttxdxwg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwttj_uttxdxwg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwttj_uttxdxwg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwttj_uttxdxwg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(4,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1),h0tab(:,1),[32,8,4,2,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,1),heltab2x96(:,:,1))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(1),n2h48(1))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2),h0tab(:,2),[32,4,2,1,16,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(2),m3h2x48(:,2),heltab2x96(:,:,2))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(14)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(3),h0tab(:,3),[32,2,1,16,8,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,3),heltab2x96(:,:,3))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(3),n2h48(2))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4),h0tab(:,4),[32,1,2,4,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,4),heltab2x96(:,:,4))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(4),n2h48(3))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5),h0tab(:,5),[32,8,2,4,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,5),heltab2x96(:,:,5))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(5),n2h48(4))
  Gcoeff(:)%j = (c(3)*M(1,:)%j+c(5)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(6),h0tab(:,6),[32,2,4,1,16,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(6),m3h2x48(:,6),heltab2x96(:,:,6))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(7),h0tab(:,7),[32,2,8,16,1,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,7),heltab2x96(:,:,7))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(7),n2h48(5))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(8),h0tab(:,8),[32,1,4,2,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,8),heltab2x96(:,:,8))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(8),n2h48(6))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(3)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(9),h0tab(:,9),[32,1,16,8,2,4],[0,0,0,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(9),m3h2x48(:,9),heltab2x96(:,:,9))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(10),h0tab(:,10),[32,1,16,8,4,2],[0,0,0,0,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(10),m3h2x48(:,10),heltab2x96(:,:,10))
  call Hloop_QA_V(ntryL,G1H48(1),ex4(:),G1H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_VA_Q(ntryL,G1H48(2),ex3(:),G1H24(2),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_A_Q(ntryL,G1H24(2),36,nMT,G2H24(1),n2h24(1))
  call Hloop_AQ_V(ntryL,G1H48(3),ex2(:),G1H24(2),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_AQ_V(ntryL,G1H48(4),ex1(:),G1H24(3),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_QA_V(ntryL,G1H48(5),ex4(:),G1H24(4),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_VQ_A(ntryL,G1H48(6),ex2(:),G1H24(5),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_Q_A(ntryL,G1H24(5),34,nMT,G2H24(2),n2h24(2))
  call Hloop_AQ_V(ntryL,G1H48(7),ex2(:),G1H24(5),m3h2x24(:,7),heltab2x48(:,:,7))
  call Hloop_AQ_V(ntryL,G1H48(8),ex1(:),G1H24(6),m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_VQ_A(ntryL,G1H48(9),ex1(:),G1H24(7),m3h2x24(:,9),heltab2x48(:,:,9))
  call Hloop_Q_A(ntryL,G1H24(7),33,0,G2H24(3),n2h24(3))
  call Hloop_VQ_A(ntryL,G1H48(10),ex1(:),G1H24(7),m3h2x24(:,10),heltab2x48(:,:,10))
  call Hloop_Q_A(ntryL,G1H24(7),33,0,G2H24(4),n2h24(4))
  call Hloop_VA_Q(ntryL,G1H24(1),ex3(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(1),n2h12(1))
  call Hloop_AQ_V(ntryL,G2H24(1),ex2(:),G2H12(2),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_VQ_A(ntryL,G1H24(2),ex1(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_Q_A(ntryL,G1H12(1),35,0,G2H12(3),n2h12(2))
  call Hloop_VQ_A(ntryL,G1H24(3),ex2(:),G1H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(4),n2h12(3))
  call Hloop_VQ_A(ntryL,G1H24(4),ex2(:),G1H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(5),n2h12(4))
  call Hloop_QA_V(ntryL,G2H24(2),ex3(:),G2H12(6),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_VA_Q(ntryL,G1H24(5),ex4(:),G1H12(1),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G1H12(1),42,0,G2H12(7),n2h12(5))
  call Hloop_VA_Q(ntryL,G1H24(6),ex3(:),G1H12(1),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(8),n2h12(6))
  call Hotf_5pt_reduction(G2H24(3),RedSet_5(1),mass5set(:,1),  & 
G1H24(7),G1H24(1),G1H24(2),G1H24(3),G1H24(4),G1H24(5),24)
  call HG1shiftOLR(G1H24(1),4,24)
  call Hotf_5pt_reduction(G2H24(4),RedSet_5(1),mass5set(:,1),  & 
G1H24(6),G1H24(8),G1H24(9),G1H24(10),G1H24(11),G1H24(12),24)
  call HG1shiftOLR(G1H24(8),2,24)
  call Hloop_QW_A(ntryL,G1H24(7),ex5(:),G1H8(1),m3h3x8(:,1),heltab2x24(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(1),n2h8(1))
call HGT_raise_alpha_OLR(G1H24(1),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(1),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(1),ex3(:),G1H12(1),m3h2x12(:,9),heltab2x24(:,:,10))
  call Hloop_QW_A(ntryL,G1H24(3),ex5(:),G1H8(1),m3h3x8(:,2),heltab2x24(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(2),n2h8(2))
  call Hloop_QW_A(ntryL,G1H24(4),ex5(:),G1H8(1),m3h3x8(:,3),heltab2x24(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(3),n2h8(3))
  call Hloop_QW_A(ntryL,G1H24(5),ex5(:),G1H8(1),m3h3x8(:,4),heltab2x24(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(4),n2h8(4))
  call Hloop_QW_A(ntryL,G1H24(6),ex5(:),G1H8(1),m3h3x8(:,5),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(5),n2h8(5))
call HGT_raise_alpha_OLR(G1H24(8),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(8),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(8),ex2(:),G1H12(2),m3h2x12(:,10),heltab2x24(:,:,15))
  call Hloop_QW_A(ntryL,G1H24(10),ex5(:),G1H8(1),m3h3x8(:,6),heltab2x24(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(6),n2h8(6))
  call Hloop_QW_A(ntryL,G1H24(11),ex5(:),G1H8(1),m3h3x8(:,7),heltab2x24(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(7),n2h8(7))
  call Hloop_QW_A(ntryL,G1H24(12),ex5(:),G1H8(1),m3h3x8(:,8),heltab2x24(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(8),n2h8(8))
  call Hloop_AQ_V(ntryL,G2H12(1),ex2(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(2),mass5set(:,2),  & 
G1H12(3),G1H12(4),G1H12(5),G1H12(6),G1H12(7),G1H12(8),12)
  call HG1shiftOLR(G1H12(4),8,12)
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(3),mass5set(:,3),  & 
G1H12(9),G1H12(10),G1H12(11),G1H12(12),G1H12(13),G1H12(14),12)
  call HG1shiftOLR(G1H12(10),4,12)
  call Hloop_QA_V(ntryL,G2H12(4),ex3(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_QA_V(ntryL,G2H12(5),ex3(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hotf_5pt_reduction(G2H12(6),RedSet_5(4),mass5set(:,2),  & 
G1H12(15),G1H12(16),G1H12(17),G1H12(18),G1H12(19),G1H12(20),12)
  call HG1shiftOLR(G1H12(16),8,12)
  call Hotf_5pt_reduction(G2H12(7),RedSet_5(5),mass5set(:,3),  & 
G1H12(21),G1H12(22),G1H12(23),G1H12(24),G1H12(25),G1H12(26),12)
  call HG1shiftOLR(G1H12(22),4,12)
  call Hloop_AQ_V(ntryL,G2H12(8),ex2(:),G2H6(4),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_QA_V(ntryL,G2H8(1),ex4(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_V(ntryL,G2H8(3),ex4(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_QA_V(ntryL,G2H8(4),ex4(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_V(ntryL,G2H8(5),ex4(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_V(ntryL,G2H8(7),ex4(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G2H8(8),ex4(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_VQ_A(ntryL,G1H12(3),ex1(:),G1H6(1),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(5),n2h6(1))
call HGT_raise_alpha_OLR(G1H12(4),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(4),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(4),ex4(:),G1H6(1),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_VQ_A(ntryL,G1H12(7),ex1(:),G1H6(2),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(2),39,0,G2H6(6),n2h6(2))
  call Hloop_VQ_A(ntryL,G1H12(8),ex1(:),G1H6(2),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_Q_A(ntryL,G1H6(2),39,0,G2H6(7),n2h6(3))
  call Hloop_QW_A(ntryL,G1H12(9),ex5(:),G1H4(1),m3h3x4(:,1),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(7),n2h4(1))
call HGT_OLR(G1H12(10),1,1,12)
call HGT_invQ_OLR(G1H12(10),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(10),-4,nMT,G2H12(1),n2h12(8))
  call Hloop_QA_V(ntryL,G2H12(1),ex3(:),G2H6(8),m3h2x6(:,9),heltab2x12(:,:,10))
  call Hloop_QW_A(ntryL,G1H12(13),ex5(:),G1H4(1),m3h3x4(:,2),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(8),n2h4(2))
  call Hloop_QW_A(ntryL,G1H12(14),ex5(:),G1H4(1),m3h3x4(:,3),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(9),n2h4(3))
  call Hloop_VQ_A(ntryL,G1H12(15),ex1(:),G1H6(2),m3h2x6(:,10),heltab2x12(:,:,13))
  call Hloop_Q_A(ntryL,G1H6(2),39,0,G2H6(9),n2h6(4))
call HGT_raise_alpha_OLR(G1H12(16),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(16),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(16),ex4(:),G1H6(2),m3h2x6(:,11),heltab2x12(:,:,14))
  call Hloop_VQ_A(ntryL,G1H12(19),ex1(:),G1H6(3),m3h2x6(:,12),heltab2x12(:,:,15))
  call Hloop_Q_A(ntryL,G1H6(3),39,0,G2H6(10),n2h6(5))
  call Hloop_VQ_A(ntryL,G1H12(20),ex1(:),G1H6(3),m3h2x6(:,13),heltab2x12(:,:,16))
  call Hloop_Q_A(ntryL,G1H6(3),39,0,G2H6(11),n2h6(6))
  call Hloop_AW_Q(ntryL,G1H12(21),ex5(:),G1H4(1),m3h3x4(:,4),heltab2x12(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(10),n2h4(4))
call HGT_OLR(G1H12(22),1,1,12)
call HGT_invQ_OLR(G1H12(22),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(22),-4,nMT,G2H12(2),n2h12(10))
  call Hloop_QA_V(ntryL,G2H12(2),ex3(:),G2H6(12),m3h2x6(:,14),heltab2x12(:,:,18))
  call Hloop_AW_Q(ntryL,G1H12(25),ex5(:),G1H4(1),m3h3x4(:,5),heltab2x12(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(11),n2h4(5))
  call Hloop_AW_Q(ntryL,G1H12(26),ex5(:),G1H4(1),m3h3x4(:,6),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(12),n2h4(6))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(6),mass5set(:,4),  & 
G1H6(3),G1H6(4),G1H6(5),G1H6(6),G1H6(7),G1H6(8),6)
  call HG1shiftOLR(G1H6(4),16,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(7),mass5set(:,4),  & 
G1H6(9),G1H6(10),G1H6(11),G1H6(12),G1H6(13),G1H6(14),6)
  call HG1shiftOLR(G1H6(10),16,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(8),mass5set(:,4),  & 
G1H6(15),G1H6(16),G1H6(17),G1H6(18),G1H6(19),G1H6(20),6)
  call HG1shiftOLR(G1H6(16),16,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(9),mass5set(:,4),  & 
G1H6(21),G1H6(22),G1H6(23),G1H6(24),G1H6(25),G1H6(26),6)
  call HG1shiftOLR(G1H6(22),16,6)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),4,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(10),mass5set(:,5),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),2,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(11),mass5set(:,5),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),2,4)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(2),mass5set(:,2),  & 
G1H6(27),G1H6(28),G1H6(29),G1H6(30),G1H6(31),G1H6(32),6)
  call HG1shiftOLR(G1H6(28),8,6)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(12),mass5set(:,2),  & 
G1H6(33),G1H6(34),G1H6(35),G1H6(36),G1H6(37),G1H6(38),6)
  call HG1shiftOLR(G1H6(34),8,6)
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(9),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(4),mass5set(:,2),  & 
G1H6(39),G1H6(40),G1H6(41),G1H6(42),G1H6(43),G1H6(44),6)
  call HG1shiftOLR(G1H6(40),8,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(13),mass5set(:,2),  & 
G1H6(45),G1H6(46),G1H6(47),G1H6(48),G1H6(49),G1H6(50),6)
  call HG1shiftOLR(G1H6(46),8,6)
  call Hloop_AQ_V(ntryL,G2H4(10),ex1(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(12),ex1(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(33),[G1H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(45),[G1H6(44)])
  call Hloop_VQ_A(ntryL,G1H6(3),ex1(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(4),1,1,6)
call HGT_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(4),-16,0,G2H6(1),n2h6(7))
  call Hloop_AW_Q(ntryL,G2H6(1),ex5(:),G2H2(5),m3h3x2(:,1),heltab2x6(:,:,2))
  call Hloop_VQ_A(ntryL,G1H6(8),ex1(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(2),n2h3(2))
  call Hloop_VA_Q(ntryL,G1H6(9),ex4(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,4))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(3),n2h3(3))
call HGT_OLR(G1H6(10),1,1,6)
call HGT_invQ_OLR(G1H6(10),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(10),-16,0,G2H6(2),n2h6(8))
  call Hloop_QW_A(ntryL,G2H6(2),ex5(:),G2H2(6),m3h3x2(:,2),heltab2x6(:,:,5))
  call Hloop_VA_Q(ntryL,G1H6(14),ex4(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,6))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(4),n2h3(4))
  call Hloop_VQ_A(ntryL,G1H6(15),ex1(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(5),n2h3(5))
call HGT_OLR(G1H6(16),1,1,6)
call HGT_invQ_OLR(G1H6(16),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(16),-16,0,G2H6(3),n2h6(9))
  call Hloop_AW_Q(ntryL,G2H6(3),ex5(:),G2H2(7),m3h3x2(:,3),heltab2x6(:,:,8))
  call Hloop_VQ_A(ntryL,G1H6(20),ex1(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(6),n2h3(6))
  call Hloop_VA_Q(ntryL,G1H6(21),ex4(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,10))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(7),n2h3(7))
call HGT_OLR(G1H6(22),1,1,6)
call HGT_invQ_OLR(G1H6(22),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(22),-16,0,G2H6(4),n2h6(10))
  call Hloop_QW_A(ntryL,G2H6(4),ex5(:),G2H2(8),m3h3x2(:,4),heltab2x6(:,:,11))
  call Hloop_VA_Q(ntryL,G1H6(26),ex4(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,12))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(8),n2h3(8))
  call Hloop_VQ_A(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMT,G2H2(9),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex3(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VQ_A(ntryL,G1H4(7),ex2(:),G1H2(2),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(2),59,nMT,G2H2(10),n2h2(2))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex3(:),G1H2(2),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_VQ_A(ntryL,G1H4(12),ex2(:),G1H2(3),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(3),59,nMT,G2H2(11),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(13),ex3(:),G1H2(3),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(3),61,nMT,G2H2(12),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(14),ex2(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_VA_Q(ntryL,G1H4(19),ex3(:),G1H2(4),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(4),61,nMT,G2H2(13),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(20),ex2(:),G1H2(4),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_VA_Q(ntryL,G1H4(24),ex3(:),G1H2(5),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(5),61,nMT,G2H2(14),n2h2(6))
  call Hloop_QW_A(ntryL,G1H6(27),ex5(:),G1H2(5),m3h3x2(:,5),heltab2x6(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(15),n2h2(7))
call HGT_raise_alpha_OLR(G1H6(28),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(28),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(28),ex4(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,14))
  call Hloop_QW_A(ntryL,G1H6(33),ex5(:),G1H2(5),m3h3x2(:,6),heltab2x6(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(16),n2h2(8))
call HGT_raise_alpha_OLR(G1H6(34),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(34),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(34),ex4(:),G1H3(2),m3h2x3(:,10),heltab2x6(:,:,16))
  call Hloop_QW_A(ntryL,G1H6(38),ex5(:),G1H2(5),m3h3x2(:,7),heltab2x6(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(17),n2h2(9))
  call Hloop_QW_A(ntryL,G1H6(39),ex5(:),G1H2(5),m3h3x2(:,8),heltab2x6(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(18),n2h2(10))
call HGT_raise_alpha_OLR(G1H6(40),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(40),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(40),ex4(:),G1H3(3),m3h2x3(:,11),heltab2x6(:,:,19))
  call Hloop_QW_A(ntryL,G1H6(45),ex5(:),G1H2(5),m3h3x2(:,9),heltab2x6(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(19),n2h2(11))
call HGT_raise_alpha_OLR(G1H6(46),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(46),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(46),ex4(:),G1H3(4),m3h2x3(:,12),heltab2x6(:,:,21))
  call Hloop_QW_A(ntryL,G1H6(50),ex5(:),G1H2(5),m3h3x2(:,10),heltab2x6(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(20),n2h2(12))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,3),  & 
G1H2(5),G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
  call HG1shiftOLR(G1H2(6),4,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(5),mass5set(:,3),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),2)
  call HG1shiftOLR(G1H2(12),4,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(6),mass5set(:,4),  & 
G1H3(5),G1H3(6),G1H3(7),G1H3(8),G1H3(9),G1H3(10),3)
  call HG1shiftOLR(G1H3(6),16,3)
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(7),mass5set(:,4),  & 
G1H3(11),G1H3(12),G1H3(13),G1H3(14),G1H3(15),G1H3(16),3)
  call HG1shiftOLR(G1H3(12),16,3)
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(8),mass5set(:,4),  & 
G1H3(17),G1H3(18),G1H3(19),G1H3(20),G1H3(21),G1H3(22),3)
  call HG1shiftOLR(G1H3(18),16,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(9),mass5set(:,4),  & 
G1H3(23),G1H3(24),G1H3(25),G1H3(26),G1H3(27),G1H3(28),3)
  call HG1shiftOLR(G1H3(24),16,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(12),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(15),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_VA_Q(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(5),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(6),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(7),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(8),n2h1(4))
  call Hloop_QW_A(ntryL,G1H3(5),ex5(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(5))
  call Hloop_QW_A(ntryL,G1H3(6),ex5(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(10),n2h1(6))
  call Hloop_AW_Q(ntryL,G1H3(11),ex5(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(7))
  call Hloop_AW_Q(ntryL,G1H3(12),ex5(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(12),n2h1(8))
  call Hloop_QW_A(ntryL,G1H3(17),ex5(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(9))
  call Hloop_QW_A(ntryL,G1H3(18),ex5(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(14),n2h1(10))
  call Hloop_AW_Q(ntryL,G1H3(23),ex5(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(11))
  call Hloop_AW_Q(ntryL,G1H3(24),ex5(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(16),n2h1(12))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(4),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),4)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(5),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(6),mass5set(:,4),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(7),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(8),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(9),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(11),h0tab(:,11),[32,6,16,1,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,11),heltab2x96(:,:,11))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(1),n2h48(7))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(14)*M(2,:)%j-c(10)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(12),h0tab(:,12),[32,6,8,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,12),heltab2x96(:,:,12))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(2),n2h48(8))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(14)*M(2,:)%j-c(10)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(13),h0tab(:,13),[32,1,8,16,6],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,13),heltab2x96(:,:,13))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(3),n2h48(9))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(14)*M(2,:)%j-c(10)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(14),h0tab(:,14),[32,1,8,6,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,14),heltab2x96(:,:,14))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(4),n2h48(10))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(15),h0tab(:,15),[32,6,1,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,15),heltab2x96(:,:,15))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(5),n2h48(11))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(16),h0tab(:,16),[32,8,1,6,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,16),heltab2x96(:,:,16))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(6),n2h48(12))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(17),h0tab(:,17),[32,1,16,8,6],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(7),m3h2x48(:,17),heltab2x96(:,:,17))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(18),h0tab(:,18),[32,1,16,6,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(8),m3h2x48(:,18),heltab2x96(:,:,18))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)-c(19)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(19),h0tab(:,19),[32,6,1,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(9),m3h2x48(:,19),heltab2x96(:,:,19))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(20),h0tab(:,20),[32,8,6,1,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,20),heltab2x96(:,:,20))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(10),n2h48(13))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(21),h0tab(:,21),[32,1,6,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(11),m3h2x48(:,21),heltab2x96(:,:,21))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(22),h0tab(:,22),[32,1,6,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,22),heltab2x96(:,:,22))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(12),n2h48(14))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(3)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(23),h0tab(:,23),[32,4,2,8,17],[0,nMT,0,0,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(13),m3h2x48(:,23),heltab2x96(:,:,23))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(24),h0tab(:,24),[32,8,2,4,17],[0,0,nMT,0,0],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,24),heltab2x96(:,:,24))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(14),n2h48(15))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(25),h0tab(:,25),[32,2,4,8,17],[0,nMT,0,0,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(15),m3h2x48(:,25),heltab2x96(:,:,25))
  Gcoeff(:)%j = (c(3)*M(1,:)%j+c(5)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(26),h0tab(:,26),[32,2,4,17,8],[0,nMT,0,0,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(16),m3h2x48(:,26),heltab2x96(:,:,26))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(27),h0tab(:,27),[32,8,4,2,17],[0,0,nMT,0,0],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,27),heltab2x96(:,:,27))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(17),n2h48(16))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(28),h0tab(:,28),[32,4,2,17,8],[0,nMT,0,0,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(18),m3h2x48(:,28),heltab2x96(:,:,28))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(29),h0tab(:,29),[32,2,8,17,4],[nMT,0,0,0,nMT],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,29),heltab2x96(:,:,29))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(19),n2h48(17))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(14)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(30),h0tab(:,30),[32,2,17,8,4],[nMT,0,0,0,nMT],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,30),heltab2x96(:,:,30))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(20),n2h48(18))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(31),h0tab(:,31),[32,1,2,4,24],[0,0,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,31),heltab2x96(:,:,31))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(21),n2h48(19))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(32),h0tab(:,32),[32,4,2,1,24],[0,nMT,0,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(22),m3h2x48(:,32),heltab2x96(:,:,32))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(14)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(33),h0tab(:,33),[32,2,1,24,4],[nMT,0,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,33),heltab2x96(:,:,33))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(23),n2h48(20))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(34),h0tab(:,34),[32,1,4,2,24],[0,0,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,34),heltab2x96(:,:,34))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(24),n2h48(21))
  Gcoeff(:)%j = (c(3)*M(1,:)%j+c(5)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(35),h0tab(:,35),[32,2,4,1,24],[0,nMT,0,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(25),m3h2x48(:,35),heltab2x96(:,:,35))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(36),h0tab(:,36),[32,2,24,1,4],[nMT,0,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,36),heltab2x96(:,:,36))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(26),n2h48(22))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(-M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(37),h0tab(:,37),[32,1,24,4,2],[0,0,0,nMT,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(27),m3h2x48(:,37),heltab2x96(:,:,37))
  Gcoeff(:)%j = (c(5)*M(1,:)%j+c(3)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(38),h0tab(:,38),[32,1,24,2,4],[0,0,0,nMT,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(28),m3h2x48(:,38),heltab2x96(:,:,38))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(39),h0tab(:,39),[33,4,2,8,16],[0,nMT,0,0,0],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(1),m3h4x24(:,1),heltab2x96(:,:,39))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(40),h0tab(:,40),[33,2,4,8,16],[0,nMT,0,0,0],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(2),m3h4x24(:,2),heltab2x96(:,:,40))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(17)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(41),h0tab(:,41),[34,4,1,16,8],[nMT,0,0,0,0],5,1,wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,7),G0H24(3),m3h4x24(:,3),heltab2x96(:,:,41))
  call Hloop_Q_A(ntryL,G0H24(3),34,nMT,G1H24(7),n2h24(7))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(42),h0tab(:,42),[34,1,16,8,4],[0,0,0,0,nMT],5,1,wf4(:,7))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,7),G0H24(3),m3h4x24(:,4),heltab2x96(:,:,42))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(43),h0tab(:,43),[36,2,1,16,8],[nMT,0,0,0,0],5,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,9),G0H24(4),m3h4x24(:,5),heltab2x96(:,:,43))
  call Hloop_A_Q(ntryL,G0H24(4),36,nMT,G1H24(1),n2h24(8))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(44),h0tab(:,44),[36,1,16,8,2],[0,0,0,0,nMT],5,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,9),G0H24(4),m3h4x24(:,6),heltab2x96(:,:,44))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(45),h0tab(:,45),[40,4,2,1,16],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(5),m3h4x24(:,7),heltab2x96(:,:,45))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)-c(17)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(46),h0tab(:,46),[40,2,4,1,16],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(6),m3h4x24(:,8),heltab2x96(:,:,46))
  call Hloop_QW_A(ntryL,G1H24(2),ex5(:),G1H8(1),m3h3x8(:,9),heltab2x24(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(1),n2h8(9))
  call Hloop_QW_A(ntryL,G1H24(9),ex5(:),G1H8(1),m3h3x8(:,10),heltab2x24(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(3),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H48(1),wf4(:,1),G1H12(3),m3h4x12(:,1),heltab2x48(:,:,11))
  call Hloop_A_Q(ntryL,G1H12(3),38,0,G2H12(3),n2h12(11))
  call Hloop_QV_A(ntryL,G1H48(2),wf4(:,1),G1H12(4),m3h4x12(:,2),heltab2x48(:,:,12))
  call Hloop_Q_A(ntryL,G1H12(4),38,0,G2H12(4),n2h12(12))
  call Hloop_AQ_V(ntryL,G1H48(3),ex1(:),G1H24(3),m3h2x24(:,11),heltab2x48(:,:,13))
  call Hloop_AQ_V(ntryL,G1H48(4),ex1(:),G1H24(4),m3h2x24(:,12),heltab2x48(:,:,14))
  call Hloop_AV_Q(ntryL,G1H48(5),wf4(:,1),G1H12(7),m3h4x12(:,3),heltab2x48(:,:,15))
  call Hloop_A_Q(ntryL,G1H12(7),38,0,G2H12(5),n2h12(13))
  call Hloop_QA_V(ntryL,G1H48(6),ex4(:),G1H24(5),m3h2x24(:,13),heltab2x48(:,:,16))
  call Hloop_VQ_A(ntryL,G1H48(7),ex1(:),G1H24(6),m3h2x24(:,14),heltab2x48(:,:,17))
  call Hloop_Q_A(ntryL,G1H24(6),33,0,G2H24(1),n2h24(9))
  call Hloop_VQ_A(ntryL,G1H48(8),ex1(:),G1H24(8),m3h2x24(:,15),heltab2x48(:,:,18))
  call Hloop_Q_A(ntryL,G1H24(8),33,0,G2H24(2),n2h24(10))
  call Hloop_UV_W(ntryL,G1H48(9),32,wf4(:,1),6,G2H12(6),m3h4x12(:,4),heltab2x48(:,:,19))
  call Hloop_QA_V(ntryL,G1H48(10),ex4(:),G1H24(10),m3h2x24(:,16),heltab2x48(:,:,20))
  call Hloop_VQ_A(ntryL,G1H48(11),ex1(:),G1H24(11),m3h2x24(:,17),heltab2x48(:,:,21))
  call Hloop_Q_A(ntryL,G1H24(11),33,0,G2H24(3),n2h24(11))
  call Hloop_AQ_V(ntryL,G1H48(12),ex1(:),G1H24(12),m3h2x24(:,18),heltab2x48(:,:,22))
  call Hloop_VA_Q(ntryL,G1H48(13),ex3(:),G1H24(2),m3h2x24(:,19),heltab2x48(:,:,23))
  call Hloop_A_Q(ntryL,G1H24(2),36,nMT,G2H24(4),n2h24(12))
  call Hloop_QA_V(ntryL,G1H48(14),ex4(:),G1H24(9),m3h2x24(:,20),heltab2x48(:,:,24))
  call Hloop_VQ_A(ntryL,G1H48(15),ex2(:),G1H24(6),m3h2x24(:,21),heltab2x48(:,:,25))
  call Hloop_Q_A(ntryL,G1H24(6),34,nMT,G2H24(5),n2h24(13))
  call Hloop_VQ_A(ntryL,G1H48(16),ex2(:),G1H24(8),m3h2x24(:,22),heltab2x48(:,:,26))
  call Hloop_Q_A(ntryL,G1H24(8),34,nMT,G2H24(6),n2h24(14))
  call Hloop_QA_V(ntryL,G1H48(17),ex4(:),G1H24(11),m3h2x24(:,23),heltab2x48(:,:,27))
  call Hloop_VA_Q(ntryL,G1H48(18),ex3(:),G1H24(2),m3h2x24(:,24),heltab2x48(:,:,28))
  call Hloop_A_Q(ntryL,G1H24(2),36,nMT,G2H24(7),n2h24(15))
  call Hloop_AQ_V(ntryL,G1H48(19),ex2(:),G1H24(6),m3h2x24(:,25),heltab2x48(:,:,29))
  call Hloop_AQ_V(ntryL,G1H48(20),ex2(:),G1H24(8),m3h2x24(:,26),heltab2x48(:,:,30))
  call Hloop_AQ_V(ntryL,G1H48(21),ex1(:),G1H24(2),m3h2x24(:,27),heltab2x48(:,:,31))
  call Hloop_VA_Q(ntryL,G1H48(22),ex3(:),G1H24(13),m3h2x24(:,28),heltab2x48(:,:,32))
  call Hloop_A_Q(ntryL,G1H24(13),36,nMT,G2H24(8),n2h24(16))
  call Hloop_AQ_V(ntryL,G1H48(23),ex2(:),G1H24(13),m3h2x24(:,29),heltab2x48(:,:,33))
  call Hloop_AQ_V(ntryL,G1H48(24),ex1(:),G1H24(14),m3h2x24(:,30),heltab2x48(:,:,34))
  call Hloop_VQ_A(ntryL,G1H48(25),ex2(:),G1H24(15),m3h2x24(:,31),heltab2x48(:,:,35))
  call Hloop_Q_A(ntryL,G1H24(15),34,nMT,G2H24(9),n2h24(17))
  call Hloop_AQ_V(ntryL,G1H48(26),ex2(:),G1H24(15),m3h2x24(:,32),heltab2x48(:,:,36))
  call Hloop_VQ_A(ntryL,G1H48(27),ex1(:),G1H24(16),m3h2x24(:,33),heltab2x48(:,:,37))
  call Hloop_Q_A(ntryL,G1H24(16),33,0,G2H24(10),n2h24(18))
  call Hloop_VQ_A(ntryL,G1H48(28),ex1(:),G1H24(16),m3h2x24(:,34),heltab2x48(:,:,38))
  call Hloop_Q_A(ntryL,G1H24(16),33,0,G2H24(11),n2h24(19))
  call Hloop_VA_Q(ntryL,G0H24(1),ex3(:),G0H12(1),m3h2x12(:,11),heltab2x24(:,:,21))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMT,G1H12(8),n2h12(14))
  call Hloop_VQ_A(ntryL,G0H24(2),ex2(:),G0H12(1),m3h2x12(:,12),heltab2x24(:,:,22))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(9),n2h12(15))
  call Hloop_QA_V(ntryL,G1H24(7),ex3(:),G1H12(10),m3h2x12(:,13),heltab2x24(:,:,23))
  call Hloop_VQ_A(ntryL,G0H24(3),ex1(:),G0H12(1),m3h2x12(:,14),heltab2x24(:,:,24))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(13),n2h12(16))
  call Hloop_AQ_V(ntryL,G1H24(1),ex2(:),G1H12(14),m3h2x12(:,15),heltab2x24(:,:,25))
  call Hloop_VQ_A(ntryL,G0H24(4),ex1(:),G0H12(1),m3h2x12(:,16),heltab2x24(:,:,26))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(15),n2h12(17))
  call Hloop_VA_Q(ntryL,G0H24(5),ex3(:),G0H12(1),m3h2x12(:,17),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G0H12(1),44,nMT,G1H12(16),n2h12(18))
  call Hloop_VQ_A(ntryL,G0H24(6),ex2(:),G0H12(1),m3h2x12(:,18),heltab2x24(:,:,28))
  call Hloop_Q_A(ntryL,G0H12(1),42,nMT,G1H12(19),n2h12(19))
call HGT_w2_OLR(G1H12(1),1,1,12)
call HGT_w2_invQ_OLR(G1H12(1),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(1),[G1H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(13),[G1H12(11)])
call HGT_w2_OLR(G1H12(2),1,1,12)
call HGT_w2_invQ_OLR(G1H12(2),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(14),[G1H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(6),[G1H12(18),G1H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(10),[G1H12(17)])
  call Hloop_QW_A(ntryL,G1H12(1),ex5(:),G1H4(6),m3h3x4(:,7),heltab2x12(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(6),53,0,G2H4(1),n2h4(11))
  call Hloop_QA_V(ntryL,G2H8(2),ex4(:),G2H4(3),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QW_A(ntryL,G1H12(2),ex5(:),G1H4(18),m3h3x4(:,8),heltab2x12(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(18),51,0,G2H4(4),n2h4(12))
  call Hloop_QA_V(ntryL,G2H8(6),ex4(:),G2H4(6),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_VQ_A(ntryL,G1H12(14),ex1(:),G1H6(32),m3h2x6(:,15),heltab2x12(:,:,23))
  call Hloop_Q_A(ntryL,G1H6(32),39,0,G2H6(5),n2h6(15))
  call Hotf_5pt_reduction(G2H12(6),RedSet_5(14),mass5set(:,1),  & 
G1H12(20),G1H12(21),G1H12(22),G1H12(25),G1H12(26),G1H12(3),12)
  call HG1shiftOLR(G1H12(21),8,12)
  call Hloop_QW_A(ntryL,G1H12(12),ex5(:),G1H4(1),m3h3x4(:,9),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(7),n2h4(13))
  call Hloop_VQ_A(ntryL,G1H12(10),ex1(:),G1H6(44),m3h2x6(:,16),heltab2x12(:,:,25))
  call Hloop_Q_A(ntryL,G1H6(44),39,0,G2H6(7),n2h6(16))
  call Hloop_AW_Q(ntryL,G1H12(23),ex5(:),G1H4(2),m3h3x4(:,10),heltab2x12(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(2),58,0,G2H4(9),n2h4(14))
  call Hloop_AW_Q(ntryL,G1H12(24),ex5(:),G1H4(7),m3h3x4(:,11),heltab2x12(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(7),58,0,G2H4(10),n2h4(15))
  call Hloop_QA_V(ntryL,G2H8(1),ex4(:),G2H4(12),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(3),ex4(:),G2H4(13),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(15),mass5set(:,1),  & 
G1H12(4),G1H12(7),G1H12(15),G1H12(11),G1H12(13),G1H12(5),12)
  call HG1shiftOLR(G1H12(7),8,12)
  call Hloop_QA_V(ntryL,G2H12(4),ex4(:),G2H6(9),m3h2x6(:,17),heltab2x12(:,:,28))
  call Hloop_VA_Q(ntryL,G1H24(3),ex4(:),G1H12(18),m3h2x12(:,19),heltab2x24(:,:,29))
  call Hloop_A_Q(ntryL,G1H12(18),41,0,G2H12(7),n2h12(20))
  call Hloop_VA_Q(ntryL,G1H24(4),ex4(:),G1H12(6),m3h2x12(:,20),heltab2x24(:,:,30))
  call Hloop_A_Q(ntryL,G1H12(6),41,0,G2H12(8),n2h12(21))
  call Hloop_AQ_V(ntryL,G2H12(5),ex1(:),G2H6(11),m3h2x6(:,18),heltab2x12(:,:,29))
  call Hloop_VQ_A(ntryL,G1H24(5),ex1(:),G1H12(17),m3h2x12(:,21),heltab2x24(:,:,31))
  call Hloop_Q_A(ntryL,G1H12(17),41,0,G2H12(1),n2h12(22))
  call Hotf_5pt_reduction(G2H24(1),RedSet_5(1),mass5set(:,1),  & 
G1H24(16),G1H24(7),G1H24(1),G1H24(3),G1H24(4),G1H24(5),24)
  call HG1shiftOLR(G1H24(7),6,24)
  call Hotf_5pt_reduction(G2H24(2),RedSet_5(16),mass5set(:,1),  & 
G1H24(17),G1H24(18),G1H24(19),G1H24(20),G1H24(21),G1H24(22),24)
  call HG1shiftOLR(G1H24(18),8,24)
  call Hloop_UV_W(ntryL,G1H24(10),40,wf4(:,1),6,G2H6(1),m3h4x6(:,1),heltab2x24(:,:,32))
  call Hotf_5pt_reduction(G2H24(3),RedSet_5(17),mass5set(:,1),  & 
G1H24(10),G1H24(23),G1H24(24),G1H24(25),G1H24(26),G1H24(27),24)
  call HG1shiftOLR(G1H24(23),8,24)
  call Hloop_UV_W(ntryL,G1H24(12),33,wf4(:,1),6,G2H6(2),m3h4x6(:,2),heltab2x24(:,:,33))
  call Hloop_AQ_V(ntryL,G2H24(4),ex2(:),G2H12(2),m3h2x12(:,22),heltab2x24(:,:,34))
  call Hloop_VQ_A(ntryL,G1H24(9),ex2(:),G1H12(1),m3h2x12(:,23),heltab2x24(:,:,35))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(6),n2h12(23))
  call Hloop_QA_V(ntryL,G2H24(5),ex3(:),G2H12(3),m3h2x12(:,24),heltab2x24(:,:,36))
  call Hloop_QA_V(ntryL,G2H24(6),ex3(:),G2H12(4),m3h2x12(:,25),heltab2x24(:,:,37))
  call Hloop_VA_Q(ntryL,G1H24(11),ex3(:),G1H12(2),m3h2x12(:,26),heltab2x24(:,:,38))
  call Hloop_A_Q(ntryL,G1H12(2),44,nMT,G2H12(5),n2h12(24))
  call Hloop_AQ_V(ntryL,G2H24(7),ex2(:),G2H12(9),m3h2x12(:,27),heltab2x24(:,:,39))
  call Hloop_VA_Q(ntryL,G1H24(6),ex4(:),G1H12(14),m3h2x12(:,28),heltab2x24(:,:,40))
  call Hloop_A_Q(ntryL,G1H12(14),42,0,G2H12(10),n2h12(25))
  call Hloop_VQ_A(ntryL,G1H24(8),wf6(:,2),G1H4(8),m3h6x4(:,1),heltab2x24(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(8),51,0,G2H4(14),n2h4(16))
  call Hloop_VQ_A(ntryL,G1H24(2),ex2(:),G1H12(12),m3h2x12(:,29),heltab2x24(:,:,42))
  call Hloop_Q_A(ntryL,G1H12(12),35,nMT,G2H12(11),n2h12(26))
  call Hloop_AQ_V(ntryL,G2H24(8),ex2(:),G2H12(12),m3h2x12(:,30),heltab2x24(:,:,43))
  call Hloop_VQ_A(ntryL,G1H24(13),ex1(:),G1H12(10),m3h2x12(:,31),heltab2x24(:,:,44))
  call Hloop_Q_A(ntryL,G1H12(10),35,0,G2H12(13),n2h12(27))
  call Hloop_VA_Q(ntryL,G1H24(14),ex3(:),G1H12(23),m3h2x12(:,32),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G1H12(23),37,nMT,G2H12(14),n2h12(28))
  call Hloop_QA_V(ntryL,G2H24(9),ex3(:),G2H12(15),m3h2x12(:,33),heltab2x24(:,:,46))
  call Hloop_VA_Q(ntryL,G1H24(15),wf6(:,4),G1H4(12),m3h6x4(:,2),heltab2x24(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(12),58,0,G2H4(15),n2h4(17))
  call Hloop_QA_V(ntryL,G2H24(10),wf6(:,4),G2H4(16),m3h6x4(:,3),heltab2x24(:,:,48))
  call Hloop_QA_V(ntryL,G2H24(11),wf6(:,4),G2H4(17),m3h6x4(:,4),heltab2x24(:,:,49))
  call Hloop_AQ_V(ntryL,G1H12(8),ex2(:),G1H6(3),m3h2x6(:,19),heltab2x12(:,:,30))
  call Hloop_QA_V(ntryL,G1H12(9),ex3(:),G1H6(4),m3h2x6(:,20),heltab2x12(:,:,31))
  call Hloop_AQ_V(ntryL,G1H12(16),ex2(:),G1H6(8),m3h2x6(:,21),heltab2x12(:,:,32))
  call Hloop_QA_V(ntryL,G1H12(19),ex3(:),G1H6(9),m3h2x6(:,22),heltab2x12(:,:,33))
  call Hloop_VQ_A(ntryL,G1H12(20),ex1(:),G1H6(10),m3h2x6(:,23),heltab2x12(:,:,34))
  call Hloop_Q_A(ntryL,G1H6(10),39,0,G2H6(3),n2h6(17))
call HGT_raise_alpha_OLR(G1H12(21),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(21),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(21),ex4(:),G1H6(14),m3h2x6(:,24),heltab2x12(:,:,35))
  call Hloop_VQ_A(ntryL,G1H12(25),ex1(:),G1H6(15),m3h2x6(:,25),heltab2x12(:,:,36))
  call Hloop_Q_A(ntryL,G1H6(15),39,0,G2H6(4),n2h6(18))
  call Hloop_VQ_A(ntryL,G1H12(26),ex1(:),G1H6(16),m3h2x6(:,26),heltab2x12(:,:,37))
  call Hloop_Q_A(ntryL,G1H6(16),39,0,G2H6(13),n2h6(19))
  call Hloop_VQ_A(ntryL,G1H12(3),ex1(:),G1H6(20),m3h2x6(:,27),heltab2x12(:,:,38))
  call Hloop_Q_A(ntryL,G1H6(20),39,0,G2H6(14),n2h6(20))
  call Hloop_AW_Q(ntryL,G1H12(4),ex5(:),G1H4(13),m3h3x4(:,12),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(13),54,0,G2H4(18),n2h4(18))
call HGT_OLR(G1H12(7),1,1,12)
call HGT_invQ_OLR(G1H12(7),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(7),-8,0,G2H12(16),n2h12(30))
  call Hloop_QA_V(ntryL,G2H12(16),ex4(:),G2H6(15),m3h2x6(:,28),heltab2x12(:,:,40))
  call Hloop_AW_Q(ntryL,G1H12(11),ex5(:),G1H4(14),m3h3x4(:,13),heltab2x12(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(14),54,0,G2H4(19),n2h4(19))
  call Hloop_AW_Q(ntryL,G1H12(13),ex5(:),G1H4(19),m3h3x4(:,14),heltab2x12(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(19),54,0,G2H4(20),n2h4(20))
  call Hloop_AW_Q(ntryL,G1H12(5),ex5(:),G1H4(20),m3h3x4(:,15),heltab2x12(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(20),54,0,G2H4(21),n2h4(21))
  call Hloop_QW_A(ntryL,G1H24(16),ex5(:),G1H8(1),m3h3x8(:,11),heltab2x24(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(4),n2h8(11))
call HGT_raise_alpha_OLR(G1H24(7),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(7),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(7),-6,wf4(:,1),6,G2H6(16),m3h4x6(:,3),heltab2x24(:,:,51))
call signflip_OLR(G2H6(16))
  call Hloop_QW_A(ntryL,G1H24(3),ex5(:),G1H8(1),m3h3x8(:,12),heltab2x24(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(5),n2h8(12))
  call Hloop_QW_A(ntryL,G1H24(4),ex5(:),G1H8(1),m3h3x8(:,13),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(7),n2h8(13))
  call Hloop_QW_A(ntryL,G1H24(5),ex5(:),G1H8(1),m3h3x8(:,14),heltab2x24(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(8),n2h8(14))
  call Hloop_QW_A(ntryL,G1H24(17),ex5(:),G1H8(1),m3h3x8(:,15),heltab2x24(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(2),n2h8(15))
call HGT_raise_alpha_OLR(G1H24(18),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(18),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(18),ex4(:),G1H12(24),m3h2x12(:,34),heltab2x24(:,:,56))
  call Hloop_QW_A(ntryL,G1H24(20),ex5(:),G1H8(1),m3h3x8(:,16),heltab2x24(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(6),n2h8(16))
  call Hloop_QW_A(ntryL,G1H24(21),ex5(:),G1H8(1),m3h3x8(:,17),heltab2x24(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(1),n2h8(17))
  call Hloop_QW_A(ntryL,G1H24(22),ex5(:),G1H8(1),m3h3x8(:,18),heltab2x24(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(3),n2h8(18))
  call Hloop_QV_A(ntryL,G1H24(10),wf4(:,1),G1H6(21),m3h4x6(:,4),heltab2x24(:,:,60))
  call Hloop_Q_A(ntryL,G1H6(21),39,0,G2H6(17),n2h6(21))
call HGT_raise_alpha_OLR(G1H24(23),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(23),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(23),ex4(:),G1H12(18),m3h2x12(:,35),heltab2x24(:,:,61))
  call Hloop_QV_A(ntryL,G1H24(25),wf4(:,1),G1H6(22),m3h4x6(:,5),heltab2x24(:,:,62))
  call Hloop_Q_A(ntryL,G1H6(22),39,0,G2H6(18),n2h6(22))
  call Hloop_QV_A(ntryL,G1H24(26),wf4(:,1),G1H6(26),m3h4x6(:,6),heltab2x24(:,:,63))
  call Hloop_Q_A(ntryL,G1H6(26),39,0,G2H6(19),n2h6(23))
  call Hloop_QV_A(ntryL,G1H24(27),wf4(:,1),G1H6(27),m3h4x6(:,7),heltab2x24(:,:,64))
  call Hloop_Q_A(ntryL,G1H6(27),39,0,G2H6(20),n2h6(24))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(2),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(5),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(8),[G1H6(5)])
call HGT_w2_OLR(G1H6(1),1,1,6)
call HGT_w2_invQ_OLR(G1H6(1),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(6),[G1H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(5),[G1H6(29)])
call HGT_lower_alpha_w2_OLR(G2H6(8),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(8),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(8),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(8),[G2H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(9),[G1H6(17)])
call HGT_w2_OLR(G1H6(2),1,1,6)
call HGT_w2_invQ_OLR(G1H6(2),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(2),[G1H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G1H6(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(1),[G1H6(19),G1H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(4),[G1H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(2),[G1H6(25),G1H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(3),[G1H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(3),[G1H6(42),G1H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(13),[G1H6(48),G1H6(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(7),[G1H6(41)])
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(18),mass5set(:,5),  & 
G1H4(24),G1H4(6),G1H4(18),G1H4(1),G1H4(2),G1H4(7),4)
  call HG1shiftOLR(G1H4(6),4,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(19),mass5set(:,5),  & 
G1H4(8),G1H4(12),G1H4(13),G1H4(14),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(12),2,4)
  call Hloop_VQ_A(ntryL,G1H6(1),ex1(:),G1H3(5),m3h2x3(:,13),heltab2x6(:,:,23))
  call Hloop_Q_A(ntryL,G1H3(5),47,0,G2H3(1),n2h3(9))
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(20),mass5set(:,2),  & 
G1H6(28),G1H6(33),G1H6(34),G1H6(38),G1H6(39),G1H6(40),6)
  call HG1shiftOLR(G1H6(33),8,6)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(21),mass5set(:,6),  & 
G1H6(45),G1H6(46),G1H6(50),G1H6(32),G1H6(44),G1H6(10),6)
  call HG1shiftOLR(G1H6(46),8,6)
  call Hloop_QA_V(ntryL,G2H4(14),ex4(:),G2H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_VQ_A(ntryL,G1H6(2),ex1(:),G1H3(6),m3h2x3(:,14),heltab2x6(:,:,24))
  call Hloop_Q_A(ntryL,G1H3(6),47,0,G2H3(3),n2h3(10))
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(22),mass5set(:,2),  & 
G1H6(15),G1H6(16),G1H6(20),G1H6(21),G1H6(22),G1H6(26),6)
  call HG1shiftOLR(G1H6(16),8,6)
call HGT_lower_alpha_w2_OLR(G2H6(12),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(12),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(12),6,15,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(23),mass5set(:,6),  & 
G1H6(27),G1H6(5),G1H6(8),G1H6(31),G1H6(29),G1H6(17),6)
  call HG1shiftOLR(G1H6(5),1,6)
  call Hloop_AQ_V(ntryL,G2H4(15),ex1(:),G2H2(3),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VQ_A(ntryL,G1H6(6),ex1(:),G1H3(11),m3h2x3(:,15),heltab2x6(:,:,25))
  call Hloop_Q_A(ntryL,G1H3(11),47,0,G2H3(5),n2h3(11))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(24),mass5set(:,1),  & 
G1H6(9),G1H6(43),G1H6(19),G1H6(7),G1H6(11),G1H6(25),6)
  call HG1shiftOLR(G1H6(43),16,6)
  call Hloop_VA_Q(ntryL,G1H6(4),ex4(:),G1H3(12),m3h2x3(:,16),heltab2x6(:,:,26))
  call Hloop_A_Q(ntryL,G1H3(12),47,0,G2H3(7),n2h3(12))
  call Hloop_VA_Q(ntryL,G1H6(12),ex4(:),G1H3(17),m3h2x3(:,17),heltab2x6(:,:,27))
  call Hloop_A_Q(ntryL,G1H3(17),47,0,G2H3(9),n2h3(13))
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(25),mass5set(:,1),  & 
G1H6(13),G1H6(23),G1H6(42),G1H6(30),G1H6(48),G1H6(36),6)
  call HG1shiftOLR(G1H6(23),16,6)
  call Hloop_VQ_A(ntryL,G1H6(18),ex1(:),G1H3(18),m3h2x3(:,18),heltab2x6(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(18),47,0,G2H3(10),n2h3(14))
  call Hloop_VA_Q(ntryL,G1H6(3),ex4(:),G1H3(23),m3h2x3(:,19),heltab2x6(:,:,29))
  call Hloop_A_Q(ntryL,G1H3(23),47,0,G2H3(11),n2h3(15))
  call Hloop_VA_Q(ntryL,G1H6(24),ex4(:),G1H3(24),m3h2x3(:,20),heltab2x6(:,:,30))
  call Hloop_A_Q(ntryL,G1H3(24),47,0,G2H3(12),n2h3(16))
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(26),mass5set(:,5),  & 
G1H4(5),G1H4(17),G1H4(3),G1H4(4),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(17),4,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(27),mass5set(:,5),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),4,4)
  call Hloop_VQ_A(ntryL,G1H4(9),ex2(:),G1H2(5),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(5),59,nMT,G2H2(9),n2h2(13))
  call Hloop_VQ_A(ntryL,G1H4(10),ex2(:),G1H2(6),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(6),59,nMT,G2H2(12),n2h2(14))
  call Hloop_VQ_A(ntryL,G1H4(11),ex2(:),G1H2(11),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(11),59,nMT,G2H2(15),n2h2(15))
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(28),mass5set(:,5),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(31),G1H4(32),G1H4(33),4)
  call HG1shiftOLR(G1H4(10),2,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(29),mass5set(:,5),  & 
G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),4)
  call HG1shiftOLR(G1H4(35),2,4)
  call Hloop_VA_Q(ntryL,G1H4(21),ex3(:),G1H2(12),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(12),61,nMT,G2H2(18),n2h2(16))
  call Hloop_VA_Q(ntryL,G1H4(22),ex3(:),G1H2(5),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(5),61,nMT,G2H2(21),n2h2(17))
  call Hloop_VA_Q(ntryL,G1H4(23),ex3(:),G1H2(6),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(6),61,nMT,G2H2(22),n2h2(18))
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(14),mass5set(:,1),  & 
G1H6(41),G1H6(1),G1H6(2),G1H6(6),G1H6(4),G1H6(12),6)
  call HG1shiftOLR(G1H6(1),8,6)
  call Hloop_QW_A(ntryL,G1H6(35),ex5(:),G1H2(11),m3h3x2(:,11),heltab2x6(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(11),55,0,G2H2(23),n2h2(19))
  call Hotf_4pt_reduction(G2H6(13),RedSet_4(32),mass4set(:,1),  & 
G1H6(18),G1H6(3),G1H6(24),G1H6(35),G1H6(51),6)
  call HG1shiftOLR(G1H6(3),8,6)
  call Hloop_QW_A(ntryL,G1H6(37),ex5(:),G1H2(12),m3h3x2(:,12),heltab2x6(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(12),55,0,G2H2(24),n2h2(20))
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(30),mass5set(:,6),  & 
G1H6(37),G1H6(52),G1H6(53),G1H6(54),G1H6(55),G1H6(56),6)
  call HG1shiftOLR(G1H6(52),8,6)
  call Hloop_QW_A(ntryL,G1H6(47),ex5(:),G1H2(5),m3h3x2(:,13),heltab2x6(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(25),n2h2(21))
  call Hloop_QW_A(ntryL,G1H6(49),ex5(:),G1H2(6),m3h3x2(:,14),heltab2x6(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(6),55,0,G2H2(26),n2h2(22))
  call Hloop_QA_V(ntryL,G2H4(1),ex4(:),G2H2(27),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_V(ntryL,G2H4(4),ex4(:),G2H2(28),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(29),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_V(ntryL,G2H4(9),ex1(:),G2H2(30),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_V(ntryL,G2H4(10),ex1(:),G2H2(31),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(31),mass5set(:,1),  & 
G1H6(47),G1H6(49),G1H6(57),G1H6(58),G1H6(59),G1H6(60),6)
  call HG1shiftOLR(G1H6(49),16,6)
  call Hotf_5pt_reduction(G2H12(7),RedSet_5(32),mass5set(:,1),  & 
G1H12(6),G1H12(17),G1H12(1),G1H12(2),G1H12(14),G1H12(12),12)
  call HG1shiftOLR(G1H12(17),6,12)
  call Hotf_5pt_reduction(G2H12(8),RedSet_5(33),mass5set(:,1),  & 
G1H12(10),G1H12(23),G1H12(8),G1H12(9),G1H12(16),G1H12(19),12)
  call HG1shiftOLR(G1H12(23),16,12)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(34),mass5set(:,1),  & 
G1H6(61),G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),6)
  call HG1shiftOLR(G1H6(62),16,6)
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(35),mass5set(:,1),  & 
G1H12(20),G1H12(21),G1H12(25),G1H12(26),G1H12(3),G1H12(4),12)
  call HG1shiftOLR(G1H12(21),16,12)
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(36),mass5set(:,2),  & 
G1H12(7),G1H12(11),G1H12(13),G1H12(5),G1H12(27),G1H12(28),12)
  call HG1shiftOLR(G1H12(11),17,12)
  call Hloop_QA_V(ntryL,G2H12(6),ex3(:),G2H6(5),m3h2x6(:,29),heltab2x12(:,:,44))
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(37),mass5set(:,2),  & 
G1H12(29),G1H12(30),G1H12(31),G1H12(32),G1H12(33),G1H12(34),12)
  call HG1shiftOLR(G1H12(30),17,12)
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(13),mass5set(:,2),  & 
G1H12(35),G1H12(36),G1H12(37),G1H12(38),G1H12(39),G1H12(40),12)
  call HG1shiftOLR(G1H12(36),8,12)
  call Hloop_AQ_V(ntryL,G2H12(5),ex2(:),G2H6(6),m3h2x6(:,30),heltab2x12(:,:,45))
  call Hotf_5pt_reduction(G2H12(9),RedSet_5(12),mass5set(:,2),  & 
G1H12(41),G1H12(42),G1H12(43),G1H12(44),G1H12(45),G1H12(46),12)
  call HG1shiftOLR(G1H12(42),8,12)
  call Hloop_AQ_V(ntryL,G2H12(10),wf6(:,2),G2H2(32),m3h6x2(:,1),heltab2x12(:,:,46))
  call Hloop_QA_V(ntryL,G2H12(11),ex3(:),G2H6(8),m3h2x6(:,31),heltab2x12(:,:,47))
  call Hotf_5pt_reduction(G2H12(12),RedSet_5(2),mass5set(:,2),  & 
G1H12(47),G1H12(48),G1H12(49),G1H12(50),G1H12(51),G1H12(52),12)
  call HG1shiftOLR(G1H12(48),24,12)
  call Hloop_QA_V(ntryL,G2H12(13),wf6(:,4),G2H2(33),m3h6x2(:,2),heltab2x12(:,:,48))
  call Hloop_AQ_V(ntryL,G2H12(14),ex2(:),G2H6(10),m3h2x6(:,32),heltab2x12(:,:,49))
  call Hotf_5pt_reduction(G2H12(15),RedSet_5(4),mass5set(:,2),  & 
G1H12(53),G1H12(54),G1H12(55),G1H12(56),G1H12(57),G1H12(58),12)
  call HG1shiftOLR(G1H12(54),24,12)
  call Hotf_4pt_reduction(G2H6(14),RedSet_4(33),mass4set(:,1),  & 
G1H6(67),G1H6(68),G1H6(69),G1H6(70),G1H6(71),6)
  call HG1shiftOLR(G1H6(68),24,6)
  call Hloop_AQ_V(ntryL,G2H4(18),ex1(:),G2H2(34),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_AQ_V(ntryL,G2H4(20),ex1(:),G2H2(35),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_AQ_V(ntryL,G2H4(21),ex1(:),G2H2(36),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_V(ntryL,G2H8(4),ex4(:),G2H4(2),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(7),ex4(:),G2H4(5),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_V(ntryL,G2H8(8),ex4(:),G2H4(8),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(16),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(126),mass4set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),8)
  call HG1shiftOLR(G1H8(8),8,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(13),mass4set(:,1),  & 
G1H8(12),G1H8(13),G1H8(14),G1H8(15),G1H8(16),8)
  call HG1shiftOLR(G1H8(13),14,8)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(17),mass5set(:,1),  & 
G1H6(72),G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),6)
  call HG1shiftOLR(G1H6(73),8,6)
  call Hotf_4pt_reduction(G2H6(19),RedSet_4(126),mass4set(:,1),  & 
G1H6(78),G1H6(79),G1H6(80),G1H6(81),G1H6(82),6)
  call HG1shiftOLR(G1H6(79),8,6)
  call Hotf_4pt_reduction(G2H6(20),RedSet_4(102),mass4set(:,1),  & 
G1H6(83),G1H6(84),G1H6(85),G1H6(86),G1H6(87),6)
  call HG1shiftOLR(G1H6(84),24,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(18),[G1H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(67),[G1H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(78),[G1H6(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(83),[G1H6(77)])
  call Hloop_VQ_A(ntryL,G1H4(24),ex2(:),G1H2(11),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(11),59,nMT,G2H2(37),n2h2(23))
call HGT_raise_alpha_OLR(G1H4(6),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(6),ex3(:),G1H2(12),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_VQ_A(ntryL,G1H4(2),ex2(:),G1H2(5),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(5),59,nMT,G2H2(38),n2h2(24))
  call Hloop_VQ_A(ntryL,G1H4(7),ex2(:),G1H2(6),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(6),59,nMT,G2H2(39),n2h2(25))
  call Hloop_VA_Q(ntryL,G1H4(8),ex3(:),G1H2(11),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(11),61,nMT,G2H2(40),n2h2(26))
call HGT_raise_alpha_OLR(G1H4(12),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(12),ex2(:),G1H2(5),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_VA_Q(ntryL,G1H4(19),ex3(:),G1H2(6),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(6),61,nMT,G2H2(41),n2h2(27))
  call Hloop_VA_Q(ntryL,G1H4(20),ex3(:),G1H2(11),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(11),61,nMT,G2H2(42),n2h2(28))
  call Hloop_QW_A(ntryL,G1H6(28),ex5(:),G1H2(6),m3h3x2(:,15),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(6),55,0,G2H2(43),n2h2(29))
call HGT_raise_alpha_OLR(G1H6(33),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(33),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(33),ex4(:),G1H3(5),m3h2x3(:,21),heltab2x6(:,:,36))
  call Hloop_QW_A(ntryL,G1H6(39),ex5(:),G1H2(11),m3h3x2(:,16),heltab2x6(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(11),55,0,G2H2(44),n2h2(30))
  call Hloop_QW_A(ntryL,G1H6(40),ex5(:),G1H2(6),m3h3x2(:,17),heltab2x6(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(6),55,0,G2H2(45),n2h2(31))
  call Hloop_QW_A(ntryL,G1H6(45),ex5(:),G1H2(11),m3h3x2(:,18),heltab2x6(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(11),55,0,G2H2(46),n2h2(32))
call HGT_raise_alpha_OLR(G1H6(46),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(46),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(46),ex4(:),G1H3(6),m3h2x3(:,22),heltab2x6(:,:,40))
  call Hloop_QW_A(ntryL,G1H6(44),ex5(:),G1H2(6),m3h3x2(:,19),heltab2x6(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(6),55,0,G2H2(47),n2h2(33))
  call Hloop_QW_A(ntryL,G1H6(10),ex5(:),G1H2(11),m3h3x2(:,20),heltab2x6(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(11),55,0,G2H2(48),n2h2(34))
  call Hloop_QW_A(ntryL,G1H6(15),ex5(:),G1H2(6),m3h3x2(:,21),heltab2x6(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(6),55,0,G2H2(49),n2h2(35))
call HGT_raise_alpha_OLR(G1H6(16),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(16),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(16),ex4(:),G1H3(11),m3h2x3(:,23),heltab2x6(:,:,44))
  call Hloop_QW_A(ntryL,G1H6(22),ex5(:),G1H2(11),m3h3x2(:,22),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(11),55,0,G2H2(50),n2h2(36))
  call Hloop_QW_A(ntryL,G1H6(26),ex5(:),G1H2(6),m3h3x2(:,23),heltab2x6(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(6),55,0,G2H2(51),n2h2(37))
  call Hloop_AW_Q(ntryL,G1H6(27),ex5(:),G1H2(11),m3h3x2(:,24),heltab2x6(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(11),62,0,G2H2(52),n2h2(38))
call HGT_raise_alpha_OLR(G1H6(5),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(5),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(5),ex1(:),G1H3(12),m3h2x3(:,24),heltab2x6(:,:,48))
  call Hloop_AW_Q(ntryL,G1H6(29),ex5(:),G1H2(6),m3h3x2(:,25),heltab2x6(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(6),62,0,G2H2(53),n2h2(39))
  call Hloop_AW_Q(ntryL,G1H6(17),ex5(:),G1H2(11),m3h3x2(:,26),heltab2x6(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(11),62,0,G2H2(54),n2h2(40))
  call Hloop_VQ_A(ntryL,G1H6(9),ex1(:),G1H3(17),m3h2x3(:,25),heltab2x6(:,:,51))
  call Hloop_Q_A(ntryL,G1H3(17),47,0,G2H3(13),n2h3(17))
call HGT_OLR(G1H6(43),1,1,6)
call HGT_invQ_OLR(G1H6(43),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(43),-16,0,G2H6(12),n2h6(29))
  call Hloop_AW_Q(ntryL,G2H6(12),ex5(:),G2H2(55),m3h3x2(:,27),heltab2x6(:,:,52))
  call Hloop_VQ_A(ntryL,G1H6(11),ex1(:),G1H3(18),m3h2x3(:,26),heltab2x6(:,:,53))
  call Hloop_Q_A(ntryL,G1H3(18),47,0,G2H3(14),n2h3(18))
  call Hloop_VQ_A(ntryL,G1H6(25),ex1(:),G1H3(23),m3h2x3(:,27),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H3(23),47,0,G2H3(15),n2h3(19))
  call Hloop_VA_Q(ntryL,G1H6(13),ex4(:),G1H3(24),m3h2x3(:,28),heltab2x6(:,:,55))
  call Hloop_A_Q(ntryL,G1H3(24),47,0,G2H3(16),n2h3(20))
call HGT_OLR(G1H6(23),1,1,6)
call HGT_invQ_OLR(G1H6(23),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(23),-16,0,G2H6(1),n2h6(30))
  call Hloop_QW_A(ntryL,G2H6(1),ex5(:),G2H2(56),m3h3x2(:,28),heltab2x6(:,:,56))
  call Hloop_VA_Q(ntryL,G1H6(48),ex4(:),G1H3(17),m3h2x3(:,29),heltab2x6(:,:,57))
  call Hloop_A_Q(ntryL,G1H3(17),47,0,G2H3(17),n2h3(21))
  call Hloop_VA_Q(ntryL,G1H6(36),ex4(:),G1H3(18),m3h2x3(:,30),heltab2x6(:,:,58))
  call Hloop_A_Q(ntryL,G1H3(18),47,0,G2H3(18),n2h3(22))
  call Hloop_VQ_A(ntryL,G1H4(5),ex2(:),G1H2(6),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(6),59,nMT,G2H2(57),n2h2(41))
call HGT_raise_alpha_OLR(G1H4(17),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(17),ex3(:),G1H2(11),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_VQ_A(ntryL,G1H4(15),ex2(:),G1H2(6),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(6),59,nMT,G2H2(58),n2h2(42))
  call Hloop_VQ_A(ntryL,G1H4(16),ex2(:),G1H2(6),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(6),59,nMT,G2H2(59),n2h2(43))
  call Hloop_VQ_A(ntryL,G1H4(25),ex2(:),G1H2(6),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(6),59,nMT,G2H2(60),n2h2(44))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex3(:),G1H2(6),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_VQ_A(ntryL,G1H4(29),ex2(:),G1H2(17),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(17),59,nMT,G2H2(61),n2h2(45))
  call Hloop_VQ_A(ntryL,G1H4(30),ex2(:),G1H2(17),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(17),59,nMT,G2H2(62),n2h2(46))
  call Hloop_VA_Q(ntryL,G1H4(9),ex3(:),G1H2(17),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(17),61,nMT,G2H2(63),n2h2(47))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(10),ex2(:),G1H2(17),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_VA_Q(ntryL,G1H4(32),ex3(:),G1H2(18),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(18),61,nMT,G2H2(64),n2h2(48))
  call Hloop_VA_Q(ntryL,G1H4(33),ex3(:),G1H2(18),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(18),61,nMT,G2H2(65),n2h2(49))
  call Hloop_VA_Q(ntryL,G1H4(34),ex3(:),G1H2(18),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(18),61,nMT,G2H2(66),n2h2(50))
call HGT_raise_alpha_OLR(G1H4(35),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(35),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(35),ex2(:),G1H2(18),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_VA_Q(ntryL,G1H4(38),ex3(:),G1H2(19),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(19),61,nMT,G2H2(67),n2h2(51))
  call Hloop_VA_Q(ntryL,G1H4(39),ex3(:),G1H2(19),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(19),61,nMT,G2H2(68),n2h2(52))
  call Hloop_QW_A(ntryL,G1H6(41),ex5(:),G1H2(19),m3h3x2(:,29),heltab2x6(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(69),n2h2(53))
call HGT_raise_alpha_OLR(G1H6(1),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(1),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(1),ex4(:),G1H3(23),m3h2x3(:,31),heltab2x6(:,:,60))
  call Hloop_QW_A(ntryL,G1H6(18),ex5(:),G1H2(19),m3h3x2(:,30),heltab2x6(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(70),n2h2(54))
  call Hloop_QW_A(ntryL,G1H6(67),ex5(:),G1H2(19),m3h3x2(:,31),heltab2x6(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(71),n2h2(55))
call HGT_raise_alpha_OLR(G1H6(3),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(3),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(3),ex4(:),G1H3(24),m3h2x3(:,32),heltab2x6(:,:,63))
  call Hloop_QW_A(ntryL,G1H6(51),ex5(:),G1H2(19),m3h3x2(:,32),heltab2x6(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(72),n2h2(56))
  call Hloop_QW_A(ntryL,G1H6(37),ex5(:),G1H2(19),m3h3x2(:,33),heltab2x6(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(73),n2h2(57))
call HGT_raise_alpha_OLR(G1H6(52),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(52),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(52),ex4(:),G1H3(17),m3h2x3(:,33),heltab2x6(:,:,66))
  call Hloop_QW_A(ntryL,G1H6(55),ex5(:),G1H2(19),m3h3x2(:,34),heltab2x6(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(74),n2h2(58))
  call Hloop_QW_A(ntryL,G1H6(56),ex5(:),G1H2(19),m3h3x2(:,35),heltab2x6(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(75),n2h2(59))
  call Hloop_VQ_A(ntryL,G1H6(47),ex1(:),G1H3(18),m3h2x3(:,34),heltab2x6(:,:,69))
  call Hloop_Q_A(ntryL,G1H3(18),47,0,G2H3(19),n2h3(23))
call HGT_OLR(G1H6(49),1,1,6)
call HGT_invQ_OLR(G1H6(49),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(49),-16,0,G2H6(2),n2h6(34))
  call Hloop_AW_Q(ntryL,G2H6(2),ex5(:),G2H2(76),m3h3x2(:,36),heltab2x6(:,:,70))
  call Hloop_VQ_A(ntryL,G1H6(59),ex1(:),G1H3(18),m3h2x3(:,35),heltab2x6(:,:,71))
  call Hloop_Q_A(ntryL,G1H3(18),47,0,G2H3(20),n2h3(24))
  call Hloop_VQ_A(ntryL,G1H6(60),ex1(:),G1H3(18),m3h2x3(:,36),heltab2x6(:,:,72))
  call Hloop_Q_A(ntryL,G1H3(18),47,0,G2H3(21),n2h3(25))
  call Hloop_AW_Q(ntryL,G1H12(6),ex5(:),G1H4(21),m3h3x4(:,16),heltab2x12(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(21),57,0,G2H4(11),n2h4(28))
call HGT_OLR(G1H12(17),1,1,12)
call HGT_invQ_OLR(G1H12(17),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(17),-6,0,G2H12(16),n2h12(31))
  call Hloop_QV_A(ntryL,G2H12(16),wf4(:,1),G2H3(22),m3h4x3(:,1),heltab2x12(:,:,51))
  call Hloop_AW_Q(ntryL,G1H12(14),ex5(:),G1H4(22),m3h3x4(:,17),heltab2x12(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(22),57,0,G2H4(17),n2h4(29))
  call Hloop_AW_Q(ntryL,G1H12(12),ex5(:),G1H4(23),m3h3x4(:,18),heltab2x12(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(23),57,0,G2H4(16),n2h4(30))
  call Hloop_AV_Q(ntryL,G1H12(10),wf4(:,1),G1H3(18),m3h4x3(:,2),heltab2x12(:,:,54))
  call Hloop_A_Q(ntryL,G1H3(18),47,0,G2H3(23),n2h3(26))
call HGT_OLR(G1H12(23),1,1,12)
call HGT_invQ_OLR(G1H12(23),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(23),-16,0,G2H12(7),n2h12(32))
  call Hloop_QW_A(ntryL,G2H12(7),ex5(:),G2H4(14),m3h3x4(:,19),heltab2x12(:,:,55))
  call Hloop_AV_Q(ntryL,G1H12(16),wf4(:,1),G1H3(18),m3h4x3(:,3),heltab2x12(:,:,56))
  call Hloop_A_Q(ntryL,G1H3(18),47,0,G2H3(24),n2h3(27))
  call Hloop_AV_Q(ntryL,G1H12(19),wf4(:,1),G1H3(18),m3h4x3(:,4),heltab2x12(:,:,57))
  call Hloop_A_Q(ntryL,G1H3(18),47,0,G2H3(25),n2h3(28))
  call Hloop_VA_Q(ntryL,G1H6(61),ex4(:),G1H3(18),m3h2x3(:,37),heltab2x6(:,:,73))
  call Hloop_A_Q(ntryL,G1H3(18),47,0,G2H3(26),n2h3(29))
call HGT_OLR(G1H6(62),1,1,6)
call HGT_invQ_OLR(G1H6(62),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(62),-16,0,G2H6(3),n2h6(35))
  call Hloop_QW_A(ntryL,G2H6(3),ex5(:),G2H2(77),m3h3x2(:,37),heltab2x6(:,:,74))
  call Hloop_VA_Q(ntryL,G1H6(65),ex4(:),G1H3(18),m3h2x3(:,38),heltab2x6(:,:,75))
  call Hloop_A_Q(ntryL,G1H3(18),47,0,G2H3(27),n2h3(30))
  call Hloop_VA_Q(ntryL,G1H6(66),ex4(:),G1H3(18),m3h2x3(:,39),heltab2x6(:,:,76))
  call Hloop_A_Q(ntryL,G1H3(18),47,0,G2H3(28),n2h3(31))
  call Hloop_QV_A(ntryL,G1H12(20),wf4(:,1),G1H3(18),m3h4x3(:,5),heltab2x12(:,:,58))
  call Hloop_Q_A(ntryL,G1H3(18),47,0,G2H3(29),n2h3(32))
call HGT_OLR(G1H12(21),1,1,12)
call HGT_invQ_OLR(G1H12(21),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(21),-16,0,G2H12(8),n2h12(33))
  call Hloop_AW_Q(ntryL,G2H12(8),ex5(:),G2H4(15),m3h3x4(:,20),heltab2x12(:,:,59))
  call Hloop_QV_A(ntryL,G1H12(3),wf4(:,1),G1H3(18),m3h4x3(:,6),heltab2x12(:,:,60))
  call Hloop_Q_A(ntryL,G1H3(18),47,0,G2H3(30),n2h3(33))
  call Hloop_QV_A(ntryL,G1H12(4),wf4(:,1),G1H3(18),m3h4x3(:,7),heltab2x12(:,:,61))
  call Hloop_Q_A(ntryL,G1H3(18),47,0,G2H3(31),n2h3(34))
  call Hloop_VA_Q(ntryL,G1H12(7),ex4(:),G1H6(4),m3h2x6(:,33),heltab2x12(:,:,62))
  call Hloop_A_Q(ntryL,G1H6(4),46,0,G2H6(13),n2h6(36))
call HGT_raise_alpha_OLR(G1H12(11),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(11),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(11),wf6(:,2),G1H2(19),m3h6x2(:,3),heltab2x12(:,:,63))
  call Hloop_VA_Q(ntryL,G1H12(27),ex4(:),G1H6(12),m3h2x6(:,34),heltab2x12(:,:,64))
  call Hloop_A_Q(ntryL,G1H6(12),46,0,G2H6(7),n2h6(37))
  call Hloop_VA_Q(ntryL,G1H12(28),ex4(:),G1H6(76),m3h2x6(:,35),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G1H6(76),46,0,G2H6(9),n2h6(38))
  call Hloop_VA_Q(ntryL,G1H12(29),ex4(:),G1H6(77),m3h2x6(:,36),heltab2x12(:,:,66))
  call Hloop_A_Q(ntryL,G1H6(77),46,0,G2H6(11),n2h6(39))
call HGT_raise_alpha_OLR(G1H12(30),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(30),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(30),wf6(:,2),G1H2(20),m3h6x2(:,4),heltab2x12(:,:,67))
  call Hloop_VA_Q(ntryL,G1H12(33),ex4(:),G1H6(28),m3h2x6(:,37),heltab2x12(:,:,68))
  call Hloop_A_Q(ntryL,G1H6(28),46,0,G2H6(14),n2h6(40))
  call Hloop_VA_Q(ntryL,G1H12(34),ex4(:),G1H6(33),m3h2x6(:,38),heltab2x12(:,:,69))
  call Hloop_A_Q(ntryL,G1H6(33),46,0,G2H6(17),n2h6(41))
  call Hloop_VQ_A(ntryL,G1H12(35),wf6(:,2),G1H2(21),m3h6x2(:,5),heltab2x12(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(21),55,0,G2H2(78),n2h2(60))
call HGT_raise_alpha_OLR(G1H12(36),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(36),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(36),ex4(:),G1H6(39),m3h2x6(:,39),heltab2x12(:,:,71))
  call Hloop_VQ_A(ntryL,G1H12(39),wf6(:,2),G1H2(21),m3h6x2(:,6),heltab2x12(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(21),55,0,G2H2(79),n2h2(61))
  call Hloop_VQ_A(ntryL,G1H12(40),wf6(:,2),G1H2(21),m3h6x2(:,7),heltab2x12(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(21),55,0,G2H2(80),n2h2(62))
  call Hloop_VQ_A(ntryL,G1H12(41),wf6(:,2),G1H2(21),m3h6x2(:,8),heltab2x12(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(21),55,0,G2H2(81),n2h2(63))
call HGT_raise_alpha_OLR(G1H12(42),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(42),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(42),ex4(:),G1H6(40),m3h2x6(:,40),heltab2x12(:,:,75))
  call Hloop_VQ_A(ntryL,G1H12(45),wf6(:,2),G1H2(21),m3h6x2(:,9),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(21),55,0,G2H2(82),n2h2(64))
  call Hloop_VQ_A(ntryL,G1H12(46),wf6(:,2),G1H2(21),m3h6x2(:,10),heltab2x12(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(21),55,0,G2H2(83),n2h2(65))
  call Hloop_VQ_A(ntryL,G1H12(47),ex1(:),G1H6(45),m3h2x6(:,41),heltab2x12(:,:,78))
  call Hloop_Q_A(ntryL,G1H6(45),39,0,G2H6(19),n2h6(42))
call HGT_raise_alpha_OLR(G1H12(48),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(48),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(48),wf6(:,4),G1H2(21),m3h6x2(:,11),heltab2x12(:,:,79))
  call Hloop_VQ_A(ntryL,G1H12(51),ex1(:),G1H6(46),m3h2x6(:,42),heltab2x12(:,:,80))
  call Hloop_Q_A(ntryL,G1H6(46),39,0,G2H6(20),n2h6(43))
  call Hloop_VQ_A(ntryL,G1H12(52),ex1(:),G1H6(44),m3h2x6(:,43),heltab2x12(:,:,81))
  call Hloop_Q_A(ntryL,G1H6(44),39,0,G2H6(12),n2h6(44))
  call Hloop_VQ_A(ntryL,G1H12(53),ex1(:),G1H6(10),m3h2x6(:,44),heltab2x12(:,:,82))
  call Hloop_Q_A(ntryL,G1H6(10),39,0,G2H6(1),n2h6(45))
call HGT_raise_alpha_OLR(G1H12(54),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(54),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(54),wf6(:,4),G1H2(22),m3h6x2(:,12),heltab2x12(:,:,83))
  call Hloop_VQ_A(ntryL,G1H12(57),ex1(:),G1H6(15),m3h2x6(:,45),heltab2x12(:,:,84))
  call Hloop_Q_A(ntryL,G1H6(15),39,0,G2H6(2),n2h6(46))
  call Hloop_VQ_A(ntryL,G1H12(58),ex1(:),G1H6(16),m3h2x6(:,46),heltab2x12(:,:,85))
  call Hloop_Q_A(ntryL,G1H6(16),39,0,G2H6(3),n2h6(47))
call HGT_raise_alpha_OLR(G1H6(68),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(68),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(68),ex4(:),G1H3(18),m3h2x3(:,40),heltab2x6(:,:,77))
  call Hloop_QW_A(ntryL,G1H6(71),ex5(:),G1H2(23),m3h3x2(:,38),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(84),n2h2(66))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,1),G1H2(23),m3h4x2(:,1),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(85),n2h2(67))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(2),ex4(:),G1H4(24),m3h2x4(:,14),heltab2x8(:,:,15))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,1),G1H2(23),m3h4x2(:,2),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(86),n2h2(68))
  call Hloop_QV_A(ntryL,G1H8(12),wf4(:,1),G1H2(23),m3h4x2(:,3),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(87),n2h2(69))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex4(:),G1H4(6),m3h2x4(:,15),heltab2x8(:,:,18))
  call Hloop_QV_A(ntryL,G1H8(11),wf4(:,1),G1H2(23),m3h4x2(:,4),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(88),n2h2(70))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(13),ex4(:),G1H4(2),m3h2x4(:,16),heltab2x8(:,:,20))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,1),G1H2(23),m3h4x2(:,5),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(89),n2h2(71))
  call Hloop_QW_A(ntryL,G1H6(72),ex5(:),G1H2(23),m3h3x2(:,39),heltab2x6(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(90),n2h2(72))
call HGT_raise_alpha_OLR(G1H6(73),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(73),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(73),ex4(:),G1H3(29),m3h2x3(:,41),heltab2x6(:,:,80))
  call Hloop_QW_A(ntryL,G1H6(78),ex5(:),G1H2(23),m3h3x2(:,40),heltab2x6(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(91),n2h2(73))
  call Hloop_QW_A(ntryL,G1H6(83),ex5(:),G1H2(23),m3h3x2(:,41),heltab2x6(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(92),n2h2(74))
call HGT_raise_alpha_OLR(G1H6(79),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(79),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(79),ex4(:),G1H3(30),m3h2x3(:,42),heltab2x6(:,:,83))
  call Hloop_QW_A(ntryL,G1H6(82),ex5(:),G1H2(23),m3h3x2(:,42),heltab2x6(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(93),n2h2(75))
call HGT_raise_alpha_OLR(G1H6(84),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(84),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(84),ex4(:),G1H3(31),m3h2x3(:,43),heltab2x6(:,:,85))
  call Hloop_QW_A(ntryL,G1H6(87),ex5(:),G1H2(23),m3h3x2(:,43),heltab2x6(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(94),n2h2(76))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G2H2(2),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(4),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G1H3(28)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(7)])
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(7)])
call HGT_w2_OLR(G1H3(1),1,1,3)
call HGT_w2_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(19)])
call HGT_w2_OLR(G1H3(3),1,1,3)
call HGT_w2_invQ_OLR(G1H3(3),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G1H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G1H3(21),G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G1H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G1H3(27),G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G1H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G1H3(26)])
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(38),mass5set(:,3),  & 
G1H2(23),G1H2(10),G1H2(16),G1H2(1),G1H2(7),G1H2(3),2)
  call HG1shiftOLR(G1H2(10),4,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(39),mass5set(:,3),  & 
G1H2(8),G1H2(9),G1H2(13),G1H2(14),G1H2(15),G1H2(24),2)
  call HG1shiftOLR(G1H2(9),4,2)
call HGT_OLR(G2H2(5),1,1,2)
call HGT_invQ_OLR(G2H2(5),2,5,2)
call HGT_OLR(G2H2(5),6,15,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(40),mass5set(:,4),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),1,2)
  call Hotf_5pt_reduction(G2H3(2),RedSet_5(41),mass5set(:,4),  & 
G1H3(10),G1H3(16),G1H3(22),G1H3(28),G1H3(7),G1H3(1),3)
  call HG1shiftOLR(G1H3(16),16,3)
call HGT_OLR(G2H2(6),1,1,2)
call HGT_invQ_OLR(G2H2(6),2,5,2)
call HGT_OLR(G2H2(6),6,15,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(42),mass5set(:,4),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(43),mass5set(:,4),  & 
G1H3(19),G1H3(3),G1H3(8),G1H3(21),G1H3(9),G1H3(13),3)
  call HG1shiftOLR(G1H3(3),16,3)
call HGT_OLR(G2H2(7),1,1,2)
call HGT_invQ_OLR(G2H2(7),2,5,2)
call HGT_OLR(G2H2(7),6,15,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(44),mass5set(:,4),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),1,2)
  call Hotf_5pt_reduction(G2H3(6),RedSet_5(45),mass5set(:,4),  & 
G1H3(14),G1H3(27),G1H3(15),G1H3(20),G1H3(25),G1H3(26),3)
  call HG1shiftOLR(G1H3(27),16,3)
call HGT_OLR(G2H2(8),1,1,2)
call HGT_invQ_OLR(G2H2(8),2,5,2)
call HGT_OLR(G2H2(8),6,15,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(46),mass5set(:,4),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_5pt_reduction(G2H3(8),RedSet_5(47),mass5set(:,4),  & 
G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),G1H3(37),3)
  call HG1shiftOLR(G1H3(33),16,3)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(48),mass5set(:,7),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),2,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(1),m3h2x1(:,9),heltab2x2(:,:,9))
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(2),n2h1(13))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(3),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(49),mass5set(:,7),  & 
G1H2(2),G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),2)
  call HG1shiftOLR(G1H2(55),4,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(13),ex2(:),G2tensor(4),m3h2x1(:,12),heltab2x2(:,:,12))
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(5),n2h1(14))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(14),ex2(:),G2tensor(7),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(50),mass5set(:,2),  & 
G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),G1H3(43),3)
  call HG1shiftOLR(G1H3(39),16,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(81),ex4(:),G2tensor(9),m3h2x1(:,15),heltab2x2(:,:,15))
call HGT_w2_OLR(G1H3(2),1,1,3)
call HGT_w2_invQ_OLR(G1H3(2),2,5,3)
  call Hloop_QW_A(ntryL,G1H3(2),ex5(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(15))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(83),ex4(:),G2tensor(13),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(51),mass5set(:,2),  & 
G1H3(2),G1H3(44),G1H3(45),G1H3(46),G1H3(47),G1H3(48),3)
  call HG1shiftOLR(G1H3(44),16,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(78),ex4(:),G2tensor(15),m3h2x1(:,17),heltab2x2(:,:,17))
call HGT_w2_OLR(G1H3(4),1,1,3)
call HGT_w2_invQ_OLR(G1H3(4),2,5,3)
  call Hloop_QW_A(ntryL,G1H3(4),ex5(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(16))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(80),ex4(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(52),mass5set(:,3),  & 
G1H2(4),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(60),4,2)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(53),mass5set(:,3),  & 
G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),G1H2(70),2)
  call HG1shiftOLR(G1H2(66),4,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(54),mass5set(:,7),  & 
G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(72),4,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(55),mass5set(:,3),  & 
G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),2)
  call HG1shiftOLR(G1H2(78),4,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(56),mass5set(:,3),  & 
G1H2(83),G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(84),4,2)
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(57),mass5set(:,2),  & 
G1H3(4),G1H3(49),G1H3(50),G1H3(51),G1H3(52),G1H3(53),3)
  call HG1shiftOLR(G1H3(49),16,3)
  call Hotf_5pt_reduction(G2H3(13),RedSet_5(24),mass5set(:,1),  & 
G1H3(54),G1H3(55),G1H3(56),G1H3(57),G1H3(58),G1H3(59),3)
  call HG1shiftOLR(G1H3(55),16,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(58),mass5set(:,2),  & 
G1H3(60),G1H3(61),G1H3(62),G1H3(63),G1H3(64),G1H3(65),3)
  call HG1shiftOLR(G1H3(61),16,3)
  call Hotf_5pt_reduction(G2H3(9),RedSet_5(59),mass5set(:,2),  & 
G1H3(66),G1H3(67),G1H3(68),G1H3(69),G1H3(70),G1H3(71),3)
  call HG1shiftOLR(G1H3(67),16,3)
  call Hotf_5pt_reduction(G2H3(16),RedSet_5(25),mass5set(:,1),  & 
G1H3(72),G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),3)
  call HG1shiftOLR(G1H3(73),16,3)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(60),mass5set(:,2),  & 
G1H3(78),G1H3(79),G1H3(80),G1H3(81),G1H3(82),G1H3(83),3)
  call HG1shiftOLR(G1H3(79),16,3)
  call Hotf_5pt_reduction(G2H3(11),RedSet_5(61),mass5set(:,2),  & 
G1H3(84),G1H3(85),G1H3(86),G1H3(87),G1H3(88),G1H3(89),3)
  call HG1shiftOLR(G1H3(85),16,3)
  call Hotf_5pt_reduction(G2H3(12),RedSet_5(62),mass5set(:,2),  & 
G1H3(90),G1H3(91),G1H3(92),G1H3(93),G1H3(94),G1H3(95),3)
  call HG1shiftOLR(G1H3(91),16,3)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(8),mass5set(:,4),  & 
G1H6(22),G1H6(26),G1H6(27),G1H6(5),G1H6(29),G1H6(17),6)
  call HG1shiftOLR(G1H6(26),17,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(6),mass5set(:,4),  & 
G1H6(9),G1H6(43),G1H6(11),G1H6(25),G1H6(13),G1H6(23),6)
  call HG1shiftOLR(G1H6(43),17,6)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(7),mass5set(:,4),  & 
G1H6(48),G1H6(36),G1H6(41),G1H6(1),G1H6(18),G1H6(67),6)
  call HG1shiftOLR(G1H6(36),24,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(9),mass5set(:,4),  & 
G1H6(3),G1H6(51),G1H6(37),G1H6(52),G1H6(55),G1H6(56),6)
  call HG1shiftOLR(G1H6(51),24,6)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(15),mass5set(:,1),  & 
G1H2(89),G1H2(90),G1H2(91),G1H2(92),G1H2(93),G1H2(94),2)
  call HG1shiftOLR(G1H2(90),8,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(127),mass4set(:,1),  & 
G1H2(95),G1H2(96),G1H2(97),G1H2(98),G1H2(99),2)
  call HG1shiftOLR(G1H2(96),9,2)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(12),G1H4(19),G1H4(20),G1H4(5),4)
  call HG1shiftOLR(G1H4(8),6,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(13),mass4set(:,1),  & 
G1H4(17),G1H4(15),G1H4(16),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(15),14,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex3(:),G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex3(:),G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(40),ex2(:),G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(42),ex2(:),G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(43),ex4(:),G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),ex4(:),G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(46),ex4(:),G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(48),ex4(:),G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex4(:),G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(51),ex4(:),G2tensor(28),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(52),ex1(:),G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(54),ex1(:),G2tensor(30),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(87),mass4set(:,1),  & 
G1H3(96),G1H3(97),G1H3(98),G1H3(99),G1H3(100),3)
  call HG1shiftOLR(G1H3(97),17,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(102),mass4set(:,1),  & 
G1H3(101),G1H3(102),G1H3(103),G1H3(104),G1H3(105),3)
  call HG1shiftOLR(G1H3(102),24,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(57),ex3(:),G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(59),ex3(:),G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(60),ex3(:),G2tensor(33),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(62),ex3(:),G2tensor(34),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(63),ex2(:),G2tensor(35),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(65),ex2(:),G2tensor(36),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(66),ex2(:),G2tensor(37),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(68),ex2(:),G2tensor(38),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(69),ex4(:),G2tensor(39),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(71),ex4(:),G2tensor(40),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(73),ex4(:),G2tensor(41),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(75),ex4(:),G2tensor(42),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hotf_5pt_reduction(G2H3(19),RedSet_5(31),mass5set(:,1),  & 
G1H3(106),G1H3(107),G1H3(108),G1H3(109),G1H3(110),G1H3(111),3)
  call HG1shiftOLR(G1H3(107),16,3)
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(128),mass4set(:,1),  & 
G1H3(112),G1H3(113),G1H3(114),G1H3(115),G1H3(116),3)
  call HG1shiftOLR(G1H3(113),17,3)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(32),mass5set(:,1),  & 
G1H4(29),G1H4(30),G1H4(9),G1H4(10),G1H4(32),G1H4(33),4)
  call HG1shiftOLR(G1H4(30),6,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(129),mass4set(:,1),  & 
G1H4(34),G1H4(35),G1H4(38),G1H4(39),G1H4(21),4)
  call HG1shiftOLR(G1H4(35),22,4)
  call Hotf_5pt_reduction(G2H3(23),RedSet_5(33),mass5set(:,1),  & 
G1H3(117),G1H3(118),G1H3(119),G1H3(120),G1H3(121),G1H3(122),3)
  call HG1shiftOLR(G1H3(118),16,3)
  call Hotf_4pt_reduction(G2H3(25),RedSet_4(129),mass4set(:,1),  & 
G1H3(123),G1H3(124),G1H3(125),G1H3(126),G1H3(127),3)
  call HG1shiftOLR(G1H3(124),22,3)
  call Hotf_5pt_reduction(G2H3(26),RedSet_5(34),mass5set(:,1),  & 
G1H3(128),G1H3(129),G1H3(130),G1H3(131),G1H3(132),G1H3(133),3)
  call HG1shiftOLR(G1H3(129),16,3)
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(33),mass4set(:,1),  & 
G1H3(134),G1H3(135),G1H3(136),G1H3(137),G1H3(138),3)
  call HG1shiftOLR(G1H3(135),24,3)
  call Hotf_5pt_reduction(G2H3(29),RedSet_5(35),mass5set(:,1),  & 
G1H3(139),G1H3(140),G1H3(141),G1H3(142),G1H3(143),G1H3(144),3)
  call HG1shiftOLR(G1H3(140),16,3)
  call Hotf_4pt_reduction(G2H3(31),RedSet_4(130),mass4set(:,1),  & 
G1H3(145),G1H3(146),G1H3(147),G1H3(148),G1H3(149),3)
  call HG1shiftOLR(G1H3(146),22,3)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(13),wf6(:,2),G2tensor(43),m3h6x1(:,1),heltab2x6(:,:,87))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(9),wf6(:,2),G2tensor(44),m3h6x1(:,2),heltab2x6(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(11),wf6(:,2),G2tensor(45),m3h6x1(:,3),heltab2x6(:,:,89))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(17),wf6(:,2),G2tensor(46),m3h6x1(:,4),heltab2x6(:,:,90))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(19),wf6(:,4),G2tensor(47),m3h6x1(:,5),heltab2x6(:,:,91))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(12),wf6(:,4),G2tensor(48),m3h6x1(:,6),heltab2x6(:,:,92))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(1),wf6(:,4),G2tensor(49),m3h6x1(:,7),heltab2x6(:,:,93))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(3),wf6(:,4),G2tensor(50),m3h6x1(:,8),heltab2x6(:,:,94))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(85),ex4(:),G2tensor(51),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(87),ex4(:),G2tensor(52),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(90),ex4(:),G2tensor(53),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(92),ex4(:),G2tensor(54),m3h2x1(:,46),heltab2x2(:,:,46))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(96),[G1H3(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(101),[G1H3(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(95),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(112),[G1H3(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(123),[G1H3(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(134),[G1H3(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(145),[G1H3(144)])
  call Hloop_VA_Q(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(55),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(56),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(57),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(58),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(59),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(60),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H2(25),ex1(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(26),ex1(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(62),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(30),ex1(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(25))
  call Hloop_QW_A(ntryL,G1H3(10),ex5(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(26))
  call Hloop_QW_A(ntryL,G1H3(16),ex5(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(65),n2h1(27))
  call Hloop_QW_A(ntryL,G1H3(1),ex5(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(68),n2h1(30))
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(31))
  call Hloop_AW_Q(ntryL,G1H3(19),ex5(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(32))
  call Hloop_AW_Q(ntryL,G1H3(3),ex5(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(71),n2h1(33))
  call Hloop_AW_Q(ntryL,G1H3(13),ex5(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(37),ex1(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(38),ex1(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(74),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(42),ex1(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(37))
  call Hloop_QW_A(ntryL,G1H3(14),ex5(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(76),n2h1(38))
  call Hloop_QW_A(ntryL,G1H3(27),ex5(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(77),n2h1(39))
  call Hloop_QW_A(ntryL,G1H3(26),ex5(:),G1H1(1),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(40))
  call Hloop_VA_Q(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(41))
  call Hloop_VA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(80),n2h1(42))
  call Hloop_VA_Q(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(43))
  call Hloop_AW_Q(ntryL,G1H3(32),ex5(:),G1H1(1),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(82),n2h1(44))
  call Hloop_AW_Q(ntryL,G1H3(33),ex5(:),G1H1(1),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(83),n2h1(45))
  call Hloop_AW_Q(ntryL,G1H3(37),ex5(:),G1H1(1),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(46))
  call Hloop_VQ_A(ntryL,G1H2(49),ex2(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(85),n2h1(47))
  call Hloop_VQ_A(ntryL,G1H2(50),ex2(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(86),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(54),ex2(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(87),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(88),n2h1(50))
  call Hloop_VA_Q(ntryL,G1H2(55),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(89),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(59),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(90),n2h1(52))
  call Hloop_QW_A(ntryL,G1H3(38),ex5(:),G1H1(1),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(53))
  call Hloop_QW_A(ntryL,G1H3(39),ex5(:),G1H1(1),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(92),n2h1(54))
  call Hloop_QW_A(ntryL,G1H3(43),ex5(:),G1H1(1),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(55))
  call Hloop_QW_A(ntryL,G1H3(2),ex5(:),G1H1(1),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(94),n2h1(56))
  call Hloop_QW_A(ntryL,G1H3(44),ex5(:),G1H1(1),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(95),n2h1(57))
  call Hloop_QW_A(ntryL,G1H3(48),ex5(:),G1H1(1),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(58))
  call Hloop_VA_Q(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(97),n2h1(59))
  call Hloop_VA_Q(ntryL,G1H2(60),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(98),n2h1(60))
  call Hloop_VA_Q(ntryL,G1H2(64),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(99),n2h1(61))
  call Hloop_VA_Q(ntryL,G1H2(65),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(100),n2h1(62))
  call Hloop_VA_Q(ntryL,G1H2(66),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(101),n2h1(63))
  call Hloop_VA_Q(ntryL,G1H2(70),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(102),n2h1(64))
  call Hloop_VA_Q(ntryL,G1H2(71),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(103),n2h1(65))
  call Hloop_VA_Q(ntryL,G1H2(72),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(104),n2h1(66))
  call Hloop_VA_Q(ntryL,G1H2(76),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(105),n2h1(67))
  call Hloop_VA_Q(ntryL,G1H2(77),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(106),n2h1(68))
  call Hloop_VA_Q(ntryL,G1H2(78),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(107),n2h1(69))
  call Hloop_VA_Q(ntryL,G1H2(82),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(108),n2h1(70))
  call Hloop_VA_Q(ntryL,G1H2(83),ex3(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(109),n2h1(71))
  call Hloop_VA_Q(ntryL,G1H2(84),ex3(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(110),n2h1(72))
  call Hloop_VA_Q(ntryL,G1H2(88),ex3(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(111),n2h1(73))
  call Hloop_QW_A(ntryL,G1H3(4),ex5(:),G1H1(1),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(112),n2h1(74))
  call Hloop_QW_A(ntryL,G1H3(49),ex5(:),G1H1(1),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(113),n2h1(75))
  call Hloop_QW_A(ntryL,G1H3(53),ex5(:),G1H1(1),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(76))
  call Hloop_QW_A(ntryL,G1H3(54),ex5(:),G1H1(1),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(115),n2h1(77))
  call Hloop_QW_A(ntryL,G1H3(55),ex5(:),G1H1(1),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(116),n2h1(78))
  call Hloop_QW_A(ntryL,G1H3(96),ex5(:),G1H1(1),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(79))
  call Hloop_AW_Q(ntryL,G1H3(60),ex5(:),G1H1(1),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(118),n2h1(80))
  call Hloop_AW_Q(ntryL,G1H3(61),ex5(:),G1H1(1),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(119),n2h1(81))
  call Hloop_AW_Q(ntryL,G1H3(65),ex5(:),G1H1(1),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(82))
  call Hloop_AW_Q(ntryL,G1H3(66),ex5(:),G1H1(1),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(121),n2h1(83))
  call Hloop_AW_Q(ntryL,G1H3(67),ex5(:),G1H1(1),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(122),n2h1(84))
  call Hloop_AW_Q(ntryL,G1H3(71),ex5(:),G1H1(1),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(85))
  call Hloop_AW_Q(ntryL,G1H3(72),ex5(:),G1H1(1),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(124),n2h1(86))
  call Hloop_AW_Q(ntryL,G1H3(73),ex5(:),G1H1(1),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(125),n2h1(87))
  call Hloop_AW_Q(ntryL,G1H3(101),ex5(:),G1H1(1),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(88))
  call Hloop_QW_A(ntryL,G1H3(78),ex5(:),G1H1(1),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(127),n2h1(89))
  call Hloop_QW_A(ntryL,G1H3(79),ex5(:),G1H1(1),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(128),n2h1(90))
  call Hloop_QW_A(ntryL,G1H3(83),ex5(:),G1H1(1),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(91))
  call Hloop_AW_Q(ntryL,G1H3(84),ex5(:),G1H1(1),m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(130),n2h1(92))
  call Hloop_AW_Q(ntryL,G1H3(85),ex5(:),G1H1(1),m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(131),n2h1(93))
  call Hloop_AW_Q(ntryL,G1H3(89),ex5(:),G1H1(1),m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(94))
  call Hloop_AW_Q(ntryL,G1H3(90),ex5(:),G1H1(1),m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(133),n2h1(95))
  call Hloop_AW_Q(ntryL,G1H3(91),ex5(:),G1H1(1),m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(134),n2h1(96))
  call Hloop_AW_Q(ntryL,G1H3(95),ex5(:),G1H1(1),m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(97))
  call Hloop_VQ_A(ntryL,G1H6(22),wf6(:,2),G1H1(1),m3h6x1(:,9),heltab2x6(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(136),n2h1(98))
  call Hloop_VQ_A(ntryL,G1H6(26),wf6(:,2),G1H1(1),m3h6x1(:,10),heltab2x6(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(137),n2h1(99))
  call Hloop_VQ_A(ntryL,G1H6(17),wf6(:,2),G1H1(1),m3h6x1(:,11),heltab2x6(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(100))
  call Hloop_VQ_A(ntryL,G1H6(9),wf6(:,2),G1H1(1),m3h6x1(:,12),heltab2x6(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(101))
  call Hloop_VQ_A(ntryL,G1H6(43),wf6(:,2),G1H1(1),m3h6x1(:,13),heltab2x6(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(140),n2h1(102))
  call Hloop_VQ_A(ntryL,G1H6(23),wf6(:,2),G1H1(1),m3h6x1(:,14),heltab2x6(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(103))
  call Hloop_VA_Q(ntryL,G1H6(48),wf6(:,4),G1H1(1),m3h6x1(:,15),heltab2x6(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(104))
  call Hloop_VA_Q(ntryL,G1H6(36),wf6(:,4),G1H1(1),m3h6x1(:,16),heltab2x6(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(143),n2h1(105))
  call Hloop_VA_Q(ntryL,G1H6(67),wf6(:,4),G1H1(1),m3h6x1(:,17),heltab2x6(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(106))
  call Hloop_VA_Q(ntryL,G1H6(3),wf6(:,4),G1H1(1),m3h6x1(:,18),heltab2x6(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(107))
  call Hloop_VA_Q(ntryL,G1H6(51),wf6(:,4),G1H1(1),m3h6x1(:,19),heltab2x6(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(146),n2h1(108))
  call Hloop_VA_Q(ntryL,G1H6(56),wf6(:,4),G1H1(1),m3h6x1(:,20),heltab2x6(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(109))
  call Hloop_VA_Q(ntryL,G1H2(89),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(148),n2h1(110))
  call Hloop_VA_Q(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(149),n2h1(111))
  call Hloop_VA_Q(ntryL,G1H2(95),ex4(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(112))
  call Hloop_VA_Q(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(151),n2h1(113))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(7),57,wf4(:,1),6,G2tensor(152),m3h4x1(:,1),heltab2x4(:,:,55))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(8),0,wf4(:,1),6,G2tensor(153),m3h4x1(:,2),heltab2x4(:,:,56))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(17),57,wf4(:,1),6,G2tensor(154),m3h4x1(:,3),heltab2x4(:,:,57))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(15),8,wf4(:,1),6,G2tensor(155),m3h4x1(:,4),heltab2x4(:,:,58))
  call Hloop_QW_A(ntryL,G1H3(97),ex5(:),G1H1(1),m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(156),n2h1(116))
  call Hloop_AW_Q(ntryL,G1H3(102),ex5(:),G1H1(1),m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(157),n2h1(117))
  call Hloop_QW_A(ntryL,G1H3(106),ex5(:),G1H1(1),m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(158),n2h1(118))
  call Hloop_QW_A(ntryL,G1H3(107),ex5(:),G1H1(1),m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(159),n2h1(119))
  call Hloop_QW_A(ntryL,G1H3(112),ex5(:),G1H1(1),m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(160),n2h1(120))
  call Hloop_QW_A(ntryL,G1H3(113),ex5(:),G1H1(1),m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(161),n2h1(121))
  call Hloop_AV_Q(ntryL,G1H4(29),wf4(:,1),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(122))
  call Hloop_AV_Q(ntryL,G1H4(30),wf4(:,1),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(163),n2h1(123))
  call Hloop_AV_Q(ntryL,G1H4(34),wf4(:,1),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(164),n2h1(124))
  call Hloop_AV_Q(ntryL,G1H4(35),wf4(:,1),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,0,G2tensor(165),n2h1(125))
  call Hloop_AW_Q(ntryL,G1H3(117),ex5(:),G1H1(1),m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(166),n2h1(126))
  call Hloop_AW_Q(ntryL,G1H3(118),ex5(:),G1H1(1),m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(167),n2h1(127))
  call Hloop_AW_Q(ntryL,G1H3(123),ex5(:),G1H1(1),m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(168),n2h1(128))
  call Hloop_AW_Q(ntryL,G1H3(124),ex5(:),G1H1(1),m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,0,G2tensor(169),n2h1(129))
  call Hloop_AW_Q(ntryL,G1H3(128),ex5(:),G1H1(1),m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(170),n2h1(130))
  call Hloop_AW_Q(ntryL,G1H3(129),ex5(:),G1H1(1),m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(171),n2h1(131))
  call Hloop_AW_Q(ntryL,G1H3(134),ex5(:),G1H1(1),m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(172),n2h1(132))
  call Hloop_AW_Q(ntryL,G1H3(135),ex5(:),G1H1(1),m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(173),n2h1(133))
  call Hloop_QW_A(ntryL,G1H3(139),ex5(:),G1H1(1),m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(174),n2h1(134))
  call Hloop_QW_A(ntryL,G1H3(140),ex5(:),G1H1(1),m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(175),n2h1(135))
  call Hloop_QW_A(ntryL,G1H3(145),ex5(:),G1H1(1),m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(176),n2h1(136))
  call Hloop_QW_A(ntryL,G1H3(146),ex5(:),G1H1(1),m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),22,0,G2tensor(177),n2h1(137))
  call ol_merge_tensors(G2tensor(25),[G2tensor(6),G1tensor(26),G1tensor(15)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(8),G1tensor(32)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(10),G1tensor(38)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(12),G1tensor(44)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(14),G1tensor(50)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(16),G1tensor(56)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(27),G1tensor(8)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(39),G1tensor(14)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(22),G1tensor(16)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(51),G1tensor(20)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(53),G1tensor(41)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(121),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(124),[G1tensor(59),G1tensor(47)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(48)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(130),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(58)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(60)])
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(21),mass5set(:,6),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(23),mass5set(:,6),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(26),G1tensor(15))
  call G_TensorShift(G1tensor(43),1)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(40),mass5set(:,4),  & 
G1tensor(32),G1tensor(38),G1tensor(44),G1tensor(50),G1tensor(56),G1tensor(2))
  call G_TensorShift(G1tensor(38),1)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(42),mass5set(:,4),  & 
G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6),G1tensor(27),G1tensor(8))
  call G_TensorShift(G1tensor(4),8)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(44),mass5set(:,4),  & 
G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12),G1tensor(39),G1tensor(14))
  call G_TensorShift(G1tensor(10),1)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(46),mass5set(:,4),  & 
G1tensor(22),G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(51),G1tensor(20))
  call G_TensorShift(G1tensor(16),8)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(48),mass5set(:,7),  & 
G1tensor(21),G1tensor(23),G1tensor(24),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(23),2)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(26),mass5set(:,5),  & 
G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36),G1tensor(40),G1tensor(53))
  call G_TensorShift(G1tensor(34),4)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(27),mass5set(:,5),  & 
G1tensor(41),G1tensor(42),G1tensor(45),G1tensor(46),G1tensor(59),G1tensor(47))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(18),mass5set(:,5),  & 
G1tensor(48),G1tensor(52),G1tensor(54),G1tensor(57),G1tensor(58),G1tensor(60))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(10),mass5set(:,5),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_5pt_reduction_last(G2tensor(88),RedSet_5(49),mass5set(:,7),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(28),mass5set(:,5),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),2)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(29),mass5set(:,5),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),2)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(19),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),2)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(11),mass5set(:,5),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(50),mass5set(:,2),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(14),mass5set(:,1),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(20),mass5set(:,2),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(12),mass5set(:,2),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(94),RedSet_5(51),mass5set(:,2),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(30),mass5set(:,6),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(22),mass5set(:,2),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(13),mass5set(:,2),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(52),mass5set(:,3),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(100),RedSet_5(53),mass5set(:,3),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),4)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(38),mass5set(:,3),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),4)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(54),mass5set(:,7),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_5pt_reduction_last(G2tensor(106),RedSet_5(55),mass5set(:,3),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),4)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(56),mass5set(:,3),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),4)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(39),mass5set(:,3),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(57),mass5set(:,2),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),16)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(24),mass5set(:,1),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(41),mass5set(:,4),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),16)
  call Hotf_5pt_reduction_last(G2tensor(118),RedSet_5(58),mass5set(:,2),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(59),mass5set(:,2),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(124),RedSet_5(25),mass5set(:,1),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(70),RedSet_5(43),mass5set(:,4),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(60),mass5set(:,2),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(45),mass5set(:,4),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call Hotf_5pt_reduction_last(G2tensor(130),RedSet_5(61),mass5set(:,2),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(62),mass5set(:,2),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),16)
  call Hotf_5pt_reduction_last(G2tensor(82),RedSet_5(47),mass5set(:,4),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(36),mass5set(:,2),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),17)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(37),mass5set(:,2),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),17)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(2),mass5set(:,2),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),24)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(4),mass5set(:,2),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),24)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(16),mass5set(:,1),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),8)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(17),mass5set(:,1),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),8)
  call Hotf_5pt_reduction_last(G2tensor(136),RedSet_5(8),mass5set(:,4),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),17)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(6),mass5set(:,4),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),17)
  call Hotf_5pt_reduction_last(G2tensor(142),RedSet_5(7),mass5set(:,4),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),24)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(9),mass5set(:,4),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),24)
  call Hotf_5pt_reduction_last(G2tensor(148),RedSet_5(15),mass5set(:,1),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),8)
  call Hotf_5pt_reduction_last(G2tensor(152),RedSet_5(1),mass5set(:,1),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),6)
  call Hotf_5pt_reduction_last(G2tensor(158),RedSet_5(31),mass5set(:,1),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),16)
  call Hotf_5pt_reduction_last(G2tensor(162),RedSet_5(32),mass5set(:,1),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),6)
  call Hotf_5pt_reduction_last(G2tensor(166),RedSet_5(33),mass5set(:,1),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),16)
  call Hotf_5pt_reduction_last(G2tensor(170),RedSet_5(34),mass5set(:,1),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),16)
  call Hotf_5pt_reduction_last(G2tensor(174),RedSet_5(35),mass5set(:,1),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),16)
  call ol_merge_tensors(T1sum(11),[G1tensor(1)])
  call ol_merge_tensors(T1sum(12),[G1tensor(37)])
  call ol_merge_tensors(T1sum(13),[G1tensor(32)])
  call ol_merge_tensors(T1sum(14),[G1tensor(3)])
  call ol_merge_tensors(T1sum(15),[G1tensor(9)])
  call ol_merge_tensors(T1sum(16),[G1tensor(22)])
  call ol_merge_tensors(T1sum(17),[G1tensor(21)])
  call ol_merge_tensors(T1sum(18),[G1tensor(33)])
  call ol_merge_tensors(T1sum(19),[G1tensor(41)])
  call ol_merge_tensors(T1sum(20),[G1tensor(48)])
  call ol_merge_tensors(T1sum(21),[G1tensor(61)])
  call ol_merge_tensors(T1sum(22),[G1tensor(67)])
  call ol_merge_tensors(T1sum(23),[G1tensor(73)])
  call ol_merge_tensors(T1sum(24),[G1tensor(79)])
  call ol_merge_tensors(T1sum(25),[G1tensor(85)])
  call ol_merge_tensors(T1sum(26),[G1tensor(91)])
  call ol_merge_tensors(T1sum(27),[G1tensor(97)])
  call ol_merge_tensors(T1sum(28),[G1tensor(103)])
  call ol_merge_tensors(T1sum(29),[G1tensor(109)])
  call ol_merge_tensors(T1sum(30),[G1tensor(115)])
  call ol_merge_tensors(T1sum(31),[G1tensor(121)])
  call ol_merge_tensors(T1sum(32),[G1tensor(127)])
  call ol_merge_tensors(T1sum(33),[G1tensor(133)])
  call ol_merge_tensors(T1sum(34),[G1tensor(139)])
  call ol_merge_tensors(T1sum(35),[G1tensor(145)])
  call ol_merge_tensors(T1sum(36),[G1tensor(151)])
  call ol_merge_tensors(T1sum(37),[G1tensor(157)])
  call ol_merge_tensors(T1sum(38),[G1tensor(163)])
  call ol_merge_tensors(T1sum(39),[G1tensor(169)])
  call ol_merge_tensors(T1sum(40),[G1tensor(175)])
  call ol_merge_tensors(T1sum(41),[G1tensor(181)])
  call ol_merge_tensors(T1sum(42),[G1tensor(187)])
  call ol_merge_tensors(T1sum(43),[G1tensor(193)])
  call ol_merge_tensors(T1sum(44),[G1tensor(199)])
  call ol_merge_tensors(T1sum(45),[G1tensor(205)])
  call ol_merge_tensors(T1sum(46),[G1tensor(211)])
  call ol_merge_tensors(T1sum(47),[G1tensor(217)])
  call ol_merge_tensors(T1sum(48),[G1tensor(223)])
  call ol_merge_tensors(T1sum(49),[G1tensor(229)])
  call ol_merge_tensors(T1sum(50),[G1tensor(235)])
  call ol_merge_tensors(T1sum(51),[G1tensor(241)])
  call ol_merge_tensors(T1sum(52),[G1tensor(247)])
  call ol_merge_tensors(T1sum(53),[G1tensor(253)])
  call ol_merge_tensors(T1sum(54),[G1tensor(259)])
  call ol_merge_tensors(T1sum(55),[G1tensor(265)])
  call ol_merge_tensors(T1sum(56),[G1tensor(271)])
  call ol_merge_tensors(T1sum(57),[G1tensor(277)])
  call ol_merge_tensors(T1sum(58),[G1tensor(283)])
  call ol_merge_tensors(T1sum(59),[G1tensor(289)])
  call ol_merge_tensors(T1sum(60),[G1tensor(295)])
  call ol_merge_tensors(T1sum(61),[G1tensor(301)])
  call ol_merge_tensors(T1sum(62),[G1tensor(307)])
  call ol_merge_tensors(T1sum(63),[G1tensor(313)])
  call ol_merge_tensors(T1sum(64),[G1tensor(319)])
  call ol_merge_tensors(T1sum(65),[G1tensor(325)])
  call ol_merge_tensors(T1sum(66),[G1tensor(331)])
  call ol_merge_tensors(T1sum(67),[G1tensor(337)])
  call ol_merge_tensors(T1sum(68),[G1tensor(343)])
  call ol_merge_tensors(T1sum(69),[G1tensor(349)])
  call ol_merge_tensors(T1sum(70),[G1tensor(355)])
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)-c(19)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(47),h0tab(:,47),[38,1,16,8],[0,0,0,0],5,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H96(1),ex6(:),wf4(:,1),G0H12(1),m4h2x4x12(:,1),heltab3x96(:,:,1))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(48),h0tab(:,48),[38,1,16,8],[0,0,0,0],5,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H96(1),wf4(:,1),ex6(:),G0H12(2),m4h4x2x12(:,1),heltab3x96(:,:,2))
  Gcoeff(:)%j = (c(19)*(-M(1,:)%j+M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(49),h0tab(:,49),[38,1,16,8],[0,0,0,0],5,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H96(1),ex6(:),wf4(:,1),G0H12(3),m4h2x4x12(:,2),heltab3x96(:,:,3))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(50),h0tab(:,50),[32,6,17,8],[0,0,0,0],4,2,wf4(:,1),wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,39),heltab2x96(:,:,47))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(1),n2h48(23))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)-c(19)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(51),h0tab(:,51),[32,6,17,8],[0,0,0,0],4,2,wf4(:,1),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(2),m3h2x48(:,40),heltab2x96(:,:,48))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(52),h0tab(:,52),[32,8,6,17],[0,0,0,0],4,2,wf4(:,1),wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,41),heltab2x96(:,:,49))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(3),n2h48(24))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(53),h0tab(:,53),[32,8,6,17],[0,0,0,0],4,2,wf4(:,1),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(4),m3h2x48(:,42),heltab2x96(:,:,50))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(14)*M(2,:)%j-c(10)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(54),h0tab(:,54),[32,6,8,17],[0,0,0,0],4,2,wf4(:,1),wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,43),heltab2x96(:,:,51))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(5),n2h48(25))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(55),h0tab(:,55),[32,6,8,17],[0,0,0,0],4,2,wf4(:,1),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(6),m3h2x48(:,44),heltab2x96(:,:,52))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(56),h0tab(:,56),[32,1,6,24],[0,0,0,0],4,2,wf4(:,1),wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,45),heltab2x96(:,:,53))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(7),n2h48(26))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(57),h0tab(:,57),[32,1,6,24],[0,0,0,0],4,2,wf4(:,1),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(8),m3h2x48(:,46),heltab2x96(:,:,54))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(14)*M(2,:)%j-c(10)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(58),h0tab(:,58),[32,1,24,6],[0,0,0,0],4,2,wf6(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,47),heltab2x96(:,:,55))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(9),n2h48(27))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(59),h0tab(:,59),[32,1,24,6],[0,0,0,0],4,2,wf6(:,4),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(10),m3h2x48(:,48),heltab2x96(:,:,56))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*M(4,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(60),h0tab(:,60),[32,6,1,24],[0,0,0,0],4,2,wf4(:,1),wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,49),heltab2x96(:,:,57))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(11),n2h48(28))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)-c(19)*M(4,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(61),h0tab(:,61),[32,6,1,24],[0,0,0,0],4,2,wf4(:,1),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(12),m3h2x48(:,50),heltab2x96(:,:,58))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(62),h0tab(:,62),[33,6,16,8],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,5),G0H24(1),m3h4x24(:,9),heltab2x96(:,:,59))
  call Hloop_Q_A(ntryL,G0H24(1),33,0,G1H24(12),n2h24(23))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(4)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(63),h0tab(:,63),[33,6,8,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(2),m3h4x24(:,10),heltab2x96(:,:,60))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(64),h0tab(:,64),[33,8,6,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(3),m3h4x24(:,11),heltab2x96(:,:,61))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)+c(6)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(65),h0tab(:,65),[40,6,1,16],[0,0,0,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(4),m3h4x24(:,12),heltab2x96(:,:,62))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(66),h0tab(:,66),[40,1,16,6],[0,0,0,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(5),m3h4x24(:,13),heltab2x96(:,:,63))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(67),h0tab(:,67),[40,1,6,16],[0,0,0,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(6),m3h4x24(:,14),heltab2x96(:,:,64))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)+c(6)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(68),h0tab(:,68),[32,7,16,8],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(13),m3h2x48(:,51),heltab2x96(:,:,65))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(69),h0tab(:,69),[32,7,8,16],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,52),heltab2x96(:,:,66))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(14),n2h48(29))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(70),h0tab(:,70),[32,8,7,16],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,53),heltab2x96(:,:,67))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(15),n2h48(30))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(4)*M(3,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(71),h0tab(:,71),[32,1,16,14],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(16),m3h2x48(:,54),heltab2x96(:,:,68))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(3,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(72),h0tab(:,72),[32,14,1,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,55),heltab2x96(:,:,69))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(17),n2h48(31))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(3,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(73),h0tab(:,73),[32,1,14,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,56),heltab2x96(:,:,70))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(18),n2h48(32))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(4,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(74),h0tab(:,74),[38,8,1,16],[0,0,0,0],4,1,wf8(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,1),G0H12(4),m3h8x12(:,1),heltab2x96(:,:,71))
  call Hloop_Q_A(ntryL,G0H12(4),38,0,G1H12(6),n2h12(40))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(4,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(75),h0tab(:,75),[38,1,8,16],[0,0,0,0],4,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,1),G0H12(4),m3h8x12(:,2),heltab2x96(:,:,72))
  call Hloop_A_Q(ntryL,G0H12(4),38,0,G1H12(17),n2h12(41))
  Gcoeff(:)%j = (c(19)*(-M(1,:)%j+M(4,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(76),h0tab(:,76),[38,1,16,8],[0,0,0,0],4,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,1),38,G1H12(14),m3h8x12(:,3),heltab2x96(:,:,73))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*M(4,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(77),h0tab(:,77),[34,4,8,17],[nMT,0,0,0],4,2,wf4(:,7),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,7),G0H24(1),m3h4x24(:,15),heltab2x96(:,:,74))
  call Hloop_Q_A(ntryL,G0H24(1),34,nMT,G1H24(9),n2h24(24))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(17)*M(4,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(78),h0tab(:,78),[34,4,17,8],[nMT,0,0,0],4,2,wf4(:,7),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,7),G0H24(1),m3h4x24(:,16),heltab2x96(:,:,75))
  call Hloop_Q_A(ntryL,G0H24(1),34,nMT,G1H24(11),n2h24(25))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(2,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(79),h0tab(:,79),[36,2,8,17],[nMT,0,0,0],4,2,wf4(:,9),wf6(:,2))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,9),G0H24(1),m3h4x24(:,17),heltab2x96(:,:,76))
  call Hloop_A_Q(ntryL,G0H24(1),36,nMT,G1H24(6),n2h24(26))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(2,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(80),h0tab(:,80),[36,2,17,8],[nMT,0,0,0],4,2,wf4(:,9),wf6(:,2))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,9),G0H24(1),m3h4x24(:,18),heltab2x96(:,:,77))
  call Hloop_A_Q(ntryL,G0H24(1),36,nMT,G1H24(8),n2h24(27))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*M(4,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(81),h0tab(:,81),[40,4,2,17],[0,nMT,0,0],4,2,wf4(:,3),wf6(:,2))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(1),m3h4x24(:,19),heltab2x96(:,:,78))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)-c(17)*M(4,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(82),h0tab(:,82),[40,2,4,17],[0,nMT,0,0],4,2,wf4(:,3),wf6(:,2))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(7),m3h4x24(:,20),heltab2x96(:,:,79))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(14)*M(3,:)%j+c(11)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(83),h0tab(:,83),[32,2,4,25],[nMT,0,nMT,nMT],4,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,57),heltab2x96(:,:,80))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(19),n2h48(33))
  Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(3,:)%j)-c(19)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(84),h0tab(:,84),[32,2,4,25],[0,nMT,0,0],4,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(20),m3h2x48(:,58),heltab2x96(:,:,81))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(2,:)%j-c(14)*M(3,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(85),h0tab(:,85),[32,4,2,25],[nMT,0,nMT,nMT],4,1,wf12(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,59),heltab2x96(:,:,82))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(21),n2h48(34))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(M(2,:)%j-M(3,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(86),h0tab(:,86),[32,4,2,25],[0,nMT,0,0],4,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(22),m3h2x48(:,60),heltab2x96(:,:,83))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(87),h0tab(:,87),[32,2,25,4],[nMT,0,0,nMT],4,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,61),heltab2x96(:,:,84))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(23),n2h48(35))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(88),h0tab(:,88),[32,2,25,4],[0,nMT,nMT,0],4,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(24),m3h2x48(:,62),heltab2x96(:,:,85))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(89),h0tab(:,89),[49,4,2,8],[0,nMT,0,0],4,1,wf12(:,11))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,11),G0H8(1),m3h12x8(:,1),heltab2x96(:,:,86))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(3,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(90),h0tab(:,90),[49,2,4,8],[0,nMT,0,0],4,1,wf12(:,11))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,11),G0H8(2),m3h12x8(:,2),heltab2x96(:,:,87))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(3,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(91),h0tab(:,91),[33,2,4,24],[0,nMT,0,0],4,2,wf4(:,5),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(8),m3h4x24(:,21),heltab2x96(:,:,88))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(3,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(92),h0tab(:,92),[33,4,2,24],[0,nMT,0,0],4,2,wf4(:,5),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(9),m3h4x24(:,22),heltab2x96(:,:,89))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(17)*M(4,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(93),h0tab(:,93),[34,4,1,24],[nMT,0,0,0],4,2,wf4(:,7),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,7),G0H24(10),m3h4x24(:,23),heltab2x96(:,:,90))
  call Hloop_Q_A(ntryL,G0H24(10),34,nMT,G1H24(2),n2h24(28))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*M(4,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(94),h0tab(:,94),[34,1,24,4],[0,0,0,nMT],4,2,wf4(:,7),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,7),G0H24(10),m3h4x24(:,24),heltab2x96(:,:,91))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(2,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(95),h0tab(:,95),[36,2,1,24],[nMT,0,0,0],4,2,wf4(:,9),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,9),G0H24(11),m3h4x24(:,25),heltab2x96(:,:,92))
  call Hloop_A_Q(ntryL,G0H24(11),36,nMT,G1H24(13),n2h24(29))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(2,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(96),h0tab(:,96),[36,1,24,2],[0,0,0,nMT],4,2,wf4(:,9),wf6(:,4))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,9),G0H24(11),m3h4x24(:,26),heltab2x96(:,:,93))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(14)*M(3,:)%j+c(11)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(97),h0tab(:,97),[32,2,4,25],[nMT,0,nMT,nMT],4,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,63),heltab2x96(:,:,94))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(25),n2h48(36))
  Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(3,:)%j)-c(19)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(98),h0tab(:,98),[32,2,4,25],[0,nMT,0,0],4,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(26),m3h2x48(:,64),heltab2x96(:,:,95))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(2,:)%j-c(14)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(99),h0tab(:,99),[32,4,2,25],[nMT,0,nMT,nMT],4,1,wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,65),heltab2x96(:,:,96))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(27),n2h48(37))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(M(2,:)%j-M(3,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(100),h0tab(:,100),[32,4,2,25],[0,nMT,0,0],4,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(28),m3h2x48(:,66),heltab2x96(:,:,97))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(101),h0tab(:,101),[32,2,25,4],[nMT,0,0,nMT],4,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,67),heltab2x96(:,:,98))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(29),n2h48(38))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(102),h0tab(:,102),[32,2,25,4],[0,nMT,nMT,0],4,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(30),m3h2x48(:,68),heltab2x96(:,:,99))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*M(4,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(103),h0tab(:,103),[56,1,2,4],[0,0,nMT,0],4,1,wf12(:,17))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,17),G0H8(3),m3h12x8(:,3),heltab2x96(:,:,100))
  call Hloop_A_Q(ntryL,G0H8(3),56,0,G1H8(5),n2h8(22))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)-c(17)*M(4,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(104),h0tab(:,104),[56,1,4,2],[0,0,nMT,0],4,1,wf12(:,17))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,17),G0H8(3),m3h12x8(:,4),heltab2x96(:,:,101))
  call Hloop_A_Q(ntryL,G0H8(3),56,0,G1H8(6),n2h8(23))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(3,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(105),h0tab(:,105),[49,4,2,8],[0,nMT,0,0],4,1,wf12(:,13))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,13),G0H8(3),m3h12x8(:,5),heltab2x96(:,:,102))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(3,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(106),h0tab(:,106),[49,2,4,8],[0,nMT,0,0],4,1,wf12(:,13))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,13),G0H8(4),m3h12x8(:,6),heltab2x96(:,:,103))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(11)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(107),h0tab(:,107),[38,8,1,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,6),G0H12(4),m3h8x12(:,4),heltab2x96(:,:,104))
  call Hloop_Q_A(ntryL,G0H12(4),38,0,G1H12(12),n2h12(42))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(11)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(108),h0tab(:,108),[38,1,8,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,6),G0H12(4),m3h8x12(:,5),heltab2x96(:,:,105))
  call Hloop_A_Q(ntryL,G0H12(4),38,0,G1H12(10),n2h12(43))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(6)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(109),h0tab(:,109),[38,1,16,8],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,6),38,G1H12(23),m3h8x12(:,6),heltab2x96(:,:,106))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(110),h0tab(:,110),[38,8,1,16],[0,0,0,0],4,1,wf8(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,7),G0H12(4),m3h8x12(:,7),heltab2x96(:,:,107))
  call Hloop_Q_A(ntryL,G0H12(4),38,0,G1H12(16),n2h12(44))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(111),h0tab(:,111),[38,1,8,16],[0,0,0,0],4,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,7),G0H12(4),m3h8x12(:,8),heltab2x96(:,:,108))
  call Hloop_A_Q(ntryL,G0H12(4),38,0,G1H12(19),n2h12(45))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(4)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(112),h0tab(:,112),[38,1,16,8],[0,0,0,0],4,1,wf8(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf8(:,7),38,G1H12(20),m3h8x12(:,9),heltab2x96(:,:,109))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*M(4,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(113),h0tab(:,113),[56,1,2,4],[0,0,nMT,0],4,1,wf12(:,19))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,19),G0H8(5),m3h12x8(:,7),heltab2x96(:,:,110))
  call Hloop_A_Q(ntryL,G0H8(5),56,0,G1H8(1),n2h8(24))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)-c(17)*M(4,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(114),h0tab(:,114),[56,1,4,2],[0,0,nMT,0],4,1,wf12(:,19))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,19),G0H8(5),m3h12x8(:,8),heltab2x96(:,:,111))
  call Hloop_A_Q(ntryL,G0H8(5),56,0,G1H8(2),n2h8(25))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(20),[G1H12(23),G1H12(14),G1H12(22),G0H12(3),G0H12(2) &
    ,G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(12),[G1H24(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(16),[G1H12(12),G1H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(19),[G1H12(10),G1H12(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(3),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(4),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(6)])
  call Hloop_VQ_A(ntryL,G1H12(20),ex1(:),G1H6(47),m3h2x6(:,47),heltab2x12(:,:,86))
  call Hloop_Q_A(ntryL,G1H6(47),39,0,G2H6(5),n2h6(52))
  call Hloop_AW_Q(ntryL,G1H12(15),ex5(:),G1H4(22),m3h3x4(:,21),heltab2x12(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(22),54,0,G2H4(12),n2h4(31))
  call Hloop_QW_A(ntryL,G1H24(1),ex5(:),G1H8(7),m3h3x8(:,19),heltab2x24(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(4),n2h8(26))
  call Hloop_QW_A(ntryL,G1H24(19),ex5(:),G1H8(12),m3h3x8(:,20),heltab2x24(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(12),49,0,G2H8(7),n2h8(27))
  call Hloop_QV_A(ntryL,G1H24(12),wf4(:,1),G1H6(49),m3h4x6(:,8),heltab2x24(:,:,67))
  call Hloop_Q_A(ntryL,G1H6(49),39,0,G2H6(6),n2h6(53))
  call Hloop_AV_Q(ntryL,G1H48(1),wf4(:,1),G1H12(21),m3h4x12(:,5),heltab2x48(:,:,39))
  call Hloop_A_Q(ntryL,G1H12(21),38,0,G2H12(1),n2h12(46))
  call Hloop_UV_W(ntryL,G1H48(2),32,wf4(:,1),6,G2H12(2),m3h4x12(:,6),heltab2x48(:,:,40))
  call Hloop_QA_V(ntryL,G1H48(3),ex4(:),G1H24(14),m3h2x24(:,35),heltab2x48(:,:,41))
  call Hloop_VA_Q(ntryL,G1H48(4),ex4(:),G1H24(15),m3h2x24(:,36),heltab2x48(:,:,42))
  call Hloop_A_Q(ntryL,G1H24(15),40,0,G2H24(1),n2h24(30))
  call Hloop_QV_A(ntryL,G1H48(5),wf4(:,1),G1H12(3),m3h4x12(:,7),heltab2x48(:,:,43))
  call Hloop_Q_A(ntryL,G1H12(3),38,0,G2H12(6),n2h12(47))
  call Hloop_UV_W(ntryL,G1H48(6),32,wf4(:,1),6,G2H12(3),m3h4x12(:,8),heltab2x48(:,:,44))
  call Hloop_AQ_V(ntryL,G1H48(7),ex1(:),G1H24(16),m3h2x24(:,37),heltab2x48(:,:,45))
  call Hloop_VQ_A(ntryL,G1H48(8),ex1(:),G1H24(7),m3h2x24(:,38),heltab2x48(:,:,46))
  call Hloop_Q_A(ntryL,G1H24(7),33,0,G2H24(2),n2h24(31))
  call Hloop_AQ_V(ntryL,G1H48(9),ex1(:),G1H24(3),m3h2x24(:,39),heltab2x48(:,:,47))
  call Hloop_VQ_A(ntryL,G1H48(10),ex1(:),G1H24(4),m3h2x24(:,40),heltab2x48(:,:,48))
  call Hloop_Q_A(ntryL,G1H24(4),33,0,G2H24(3),n2h24(32))
  call Hloop_AV_Q(ntryL,G1H48(11),wf4(:,1),G1H12(4),m3h4x12(:,9),heltab2x48(:,:,49))
  call Hloop_A_Q(ntryL,G1H12(4),38,0,G2H12(4),n2h12(48))
  call Hloop_UV_W(ntryL,G1H48(12),32,wf4(:,1),6,G2H12(5),m3h4x12(:,10),heltab2x48(:,:,50))
  call Hloop_UV_W(ntryL,G0H24(2),33,wf4(:,1),6,G1H6(59),m3h4x6(:,9),heltab2x24(:,:,68))
  call Hloop_VA_Q(ntryL,G0H24(3),ex4(:),G0H12(4),m3h2x12(:,36),heltab2x24(:,:,69))
  call Hloop_A_Q(ntryL,G0H12(4),41,0,G1H12(7),n2h12(49))
  call Hloop_UV_W(ntryL,G0H24(4),40,wf4(:,1),6,G1H6(60),m3h4x6(:,10),heltab2x24(:,:,70))
  call Hloop_VQ_A(ntryL,G0H24(5),ex1(:),G0H12(3),m3h2x12(:,37),heltab2x24(:,:,71))
  call Hloop_Q_A(ntryL,G0H12(3),41,0,G1H12(11),n2h12(50))
  call Hloop_VQ_A(ntryL,G0H24(6),ex1(:),G0H12(2),m3h2x12(:,38),heltab2x24(:,:,72))
  call Hloop_Q_A(ntryL,G0H12(2),41,0,G1H12(27),n2h12(51))
  call Hloop_VQ_A(ntryL,G1H48(13),wf8(:,5),G1H6(61),m3h8x6(:,1),heltab2x48(:,:,51))
  call Hloop_Q_A(ntryL,G1H6(61),39,0,G2H6(8),n2h6(54))
  call Hloop_AQ_V(ntryL,G1H48(14),wf8(:,5),G1H6(62),m3h8x6(:,2),heltab2x48(:,:,52))
  call Hloop_QA_V(ntryL,G1H48(15),ex4(:),G1H24(5),m3h2x24(:,41),heltab2x48(:,:,53))
  call Hloop_VQ_A(ntryL,G1H48(16),ex1(:),G1H24(17),m3h2x24(:,42),heltab2x48(:,:,54))
  call Hloop_Q_A(ntryL,G1H24(17),33,0,G2H24(4),n2h24(33))
  call Hloop_QA_V(ntryL,G1H48(17),wf8(:,3),G1H6(65),m3h8x6(:,3),heltab2x48(:,:,55))
  call Hloop_AQ_V(ntryL,G1H48(18),ex1(:),G1H24(18),m3h2x24(:,43),heltab2x48(:,:,56))
  call Hloop_QA_V(ntryL,G1H12(16),ex4(:),G1H6(66),m3h2x6(:,48),heltab2x12(:,:,88))
  call Hloop_AQ_V(ntryL,G1H12(19),ex1(:),G1H6(4),m3h2x6(:,49),heltab2x12(:,:,89))
  call Hloop_QA_V(ntryL,G1H24(9),ex3(:),G1H12(28),m3h2x12(:,39),heltab2x24(:,:,73))
  call Hloop_QA_V(ntryL,G1H24(11),ex3(:),G1H12(29),m3h2x12(:,40),heltab2x24(:,:,74))
  call Hloop_AQ_V(ntryL,G1H24(6),ex2(:),G1H12(30),m3h2x12(:,41),heltab2x24(:,:,75))
  call Hloop_AQ_V(ntryL,G1H24(8),ex2(:),G1H12(33),m3h2x12(:,42),heltab2x24(:,:,76))
  call Hloop_VA_Q(ntryL,G0H24(1),ex3(:),G0H12(1),m3h2x12(:,43),heltab2x24(:,:,77))
  call Hloop_A_Q(ntryL,G0H12(1),44,nMT,G1H12(34),n2h12(52))
  call Hloop_VQ_A(ntryL,G0H24(7),ex2(:),G0H12(4),m3h2x12(:,44),heltab2x24(:,:,78))
  call Hloop_Q_A(ntryL,G0H12(4),42,nMT,G1H12(35),n2h12(53))
  call Hloop_AQ_V(ntryL,G1H48(19),ex2(:),G1H24(20),m3h2x24(:,44),heltab2x48(:,:,57))
  call Hloop_VQ_A(ntryL,G1H48(20),ex2(:),G1H24(21),m3h2x24(:,45),heltab2x48(:,:,58))
  call Hloop_Q_A(ntryL,G1H24(21),34,nMT,G2H24(5),n2h24(34))
  call Hloop_QA_V(ntryL,G1H48(21),ex3(:),G1H24(22),m3h2x24(:,46),heltab2x48(:,:,59))
  call Hloop_VA_Q(ntryL,G1H48(22),ex3(:),G1H24(10),m3h2x24(:,47),heltab2x48(:,:,60))
  call Hloop_A_Q(ntryL,G1H24(10),36,nMT,G2H24(6),n2h24(35))
  call Hloop_AQ_V(ntryL,G1H48(23),ex2(:),G1H24(23),m3h2x24(:,48),heltab2x48(:,:,61))
  call Hloop_VQ_A(ntryL,G1H48(24),ex2(:),G1H24(25),m3h2x24(:,49),heltab2x48(:,:,62))
  call Hloop_Q_A(ntryL,G1H24(25),34,nMT,G2H24(7),n2h24(36))
  call Hloop_VA_Q(ntryL,G0H8(3),ex3(:),G0H4(1),m3h2x4(:,17),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G0H4(1),53,nMT,G1H4(23),n2h4(32))
  call Hloop_VQ_A(ntryL,G0H8(4),ex2(:),G0H4(1),m3h2x4(:,18),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(5),n2h4(33))
  call Hloop_VQ_A(ntryL,G0H24(8),ex2(:),G0H12(3),m3h2x12(:,45),heltab2x24(:,:,79))
  call Hloop_Q_A(ntryL,G0H12(3),35,nMT,G1H12(36),n2h12(54))
  call Hloop_VA_Q(ntryL,G0H24(9),ex3(:),G0H12(2),m3h2x12(:,46),heltab2x24(:,:,80))
  call Hloop_A_Q(ntryL,G0H12(2),37,nMT,G1H12(39),n2h12(55))
  call Hloop_QA_V(ntryL,G1H24(2),ex3(:),G1H12(40),m3h2x12(:,47),heltab2x24(:,:,81))
  call Hloop_VQ_A(ntryL,G0H24(10),ex1(:),G0H12(1),m3h2x12(:,48),heltab2x24(:,:,82))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(41),n2h12(56))
  call Hloop_AQ_V(ntryL,G1H24(13),ex2(:),G1H12(42),m3h2x12(:,49),heltab2x24(:,:,83))
  call Hloop_VQ_A(ntryL,G0H24(11),ex1(:),G0H12(4),m3h2x12(:,50),heltab2x24(:,:,84))
  call Hloop_Q_A(ntryL,G0H12(4),37,0,G1H12(45),n2h12(57))
  call Hloop_AQ_V(ntryL,G1H48(25),ex2(:),G1H24(26),m3h2x24(:,50),heltab2x48(:,:,63))
  call Hloop_VQ_A(ntryL,G1H48(26),ex2(:),G1H24(27),m3h2x24(:,51),heltab2x48(:,:,64))
  call Hloop_Q_A(ntryL,G1H24(27),34,nMT,G2H24(8),n2h24(37))
  call Hloop_QA_V(ntryL,G1H48(27),ex3(:),G1H24(24),m3h2x24(:,52),heltab2x48(:,:,65))
  call Hloop_VA_Q(ntryL,G1H48(28),ex3(:),G1H24(1),m3h2x24(:,53),heltab2x48(:,:,66))
  call Hloop_A_Q(ntryL,G1H24(1),36,nMT,G2H24(9),n2h24(38))
  call Hloop_AQ_V(ntryL,G1H48(29),ex2(:),G1H24(19),m3h2x24(:,54),heltab2x48(:,:,67))
  call Hloop_VQ_A(ntryL,G1H48(30),ex2(:),G1H24(12),m3h2x24(:,55),heltab2x48(:,:,68))
  call Hloop_Q_A(ntryL,G1H24(12),34,nMT,G2H24(10),n2h24(39))
  call Hloop_AQ_V(ntryL,G1H8(1),ex1(:),G1H4(33),m3h2x4(:,19),heltab2x8(:,:,24))
  call Hloop_AQ_V(ntryL,G1H8(2),ex1(:),G1H4(7),m3h2x4(:,20),heltab2x8(:,:,25))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(60),[G1H6(19)])
call HGT_w2_OLR(G1H6(14),1,1,6)
call HGT_w2_invQ_OLR(G1H6(14),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(14),[G1H6(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(8),[G2H6(18),G2H6(4),G1H6(75),G1H6(6),G1H6(21) &
    ,G1H6(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(5),[G1H6(53),G1H6(2),G1H6(50)])
call HGT_lower_alpha_OLR(G2H6(16),1,1,6)
call HGT_lower_alpha_invQ_OLR(G2H6(16),2,5,6)
call HGT_lower_alpha_OLR(G2H6(16),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(16),[G2H6(5)])
call HGT_w2_OLR(G1H12(24),1,1,12)
call HGT_w2_invQ_OLR(G1H12(24),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(24),[G1H12(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(27),[G1H12(25)])
call HGT_w2_OLR(G1H12(18),1,1,12)
call HGT_w2_invQ_OLR(G1H12(18),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(18),[G1H12(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(32),[G1H6(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(54),[G1H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(65),[G1H6(58),G1H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(59),[G1H6(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(62),[G1H6(64),G1H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(81),[G1H6(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(66),[G1H6(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(7),[G1H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(4),[G1H6(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(30),[G1H12(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(3),[G1H12(32),G1H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(28),[G1H12(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(29),[G1H12(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(2),[G1H12(44),G1H12(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(33),[G1H12(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(42),[G1H12(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(5),[G1H12(56),G1H12(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(40),[G1H12(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(86),[G1H6(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(6),[G1H6(74)])
  call Hloop_VQ_A(ntryL,G1H6(14),ex1(:),G1H3(59),m3h2x3(:,44),heltab2x6(:,:,107))
  call Hloop_Q_A(ntryL,G1H3(59),47,0,G2H3(2),n2h3(35))
  call Hotf_4pt_reduction(G2H6(8),RedSet_4(31),mass4set(:,1),  & 
G1H6(12),G1H6(76),G1H6(77),G1H6(28),G1H6(33),6)
  call HG1shiftOLR(G1H6(76),8,6)
call HGT_lower_alpha_w2_OLR(G2H6(15),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(15),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(15),6,15,6)
  call Hotf_4pt_reduction(G2H6(15),RedSet_4(177),mass4set(:,1),  & 
G1H6(45),G1H6(46),G1H6(44),G1H6(10),G1H6(15),6)
  call HG1shiftOLR(G1H6(46),1,6)
  call Hloop_AQ_V(ntryL,G2H4(19),ex1(:),G2H2(2),m3h2x2(:,55),heltab2x4(:,:,63))
  call Hotf_4pt_reduction(G2H6(16),RedSet_4(26),mass4set(:,1),  & 
G1H6(16),G1H6(68),G1H6(71),G1H6(72),G1H6(73),6)
  call HG1shiftOLR(G1H6(68),8,6)
  call Hloop_QA_V(ntryL,G2H8(5),ex4(:),G2H4(3),m3h2x4(:,21),heltab2x8(:,:,26))



end subroutine vamp_1

end module ol_vamp_1_ppwttj_uttxdxwg_1_/**/REALKIND
