
module ol_vamp_1_ppwtt_ew_uxttxdwx_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwtt_ew_uxttxdwx_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwtt_ew_uxttxdwx_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwtt_ew_uxttxdwx_4_/**/DREALKIND
  use ol_tensor_sum_storage_ppwtt_ew_uxttxdwx_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwtt_ew_uxttxdwx_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwtt_ew_uxttxdwx_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(75)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(1),h0tab(:,1),[16,4,2,1,8],[nMH,nMT,0,0,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,1),heltab2x48(:,:,1))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(2),h0tab(:,2),[16,4,2,1,8],[nMW,nMB,nMW,0,0],5,0)
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(2),m3h3x16(:,2),heltab2x48(:,:,2))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(3),h0tab(:,3),[16,4,2,1,8],[nMH,nMT,nMZ,0,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(3),m3h3x16(:,3),heltab2x48(:,:,3))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(4),h0tab(:,4),[16,4,2,1,8],[nMW,nMB,nMW,0,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(4),m3h3x16(:,4),heltab2x48(:,:,4))
  Gcoeff(:)%j = (c(126)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(5),h0tab(:,5),[16,4,2,1,8],[0,nMT,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(1),m3h3x16(:,5),heltab2x48(:,:,5))
  Gcoeff(:)%j = (c(109)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(6),h0tab(:,6),[16,4,2,1,8],[nMZ,nMT,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(2),m3h3x16(:,6),heltab2x48(:,:,6))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(7),h0tab(:,7),[16,4,2,1,8],[0,nMT,nMZ,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(3),m3h3x16(:,7),heltab2x48(:,:,7))
  Gcoeff(:)%j = (c(111)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(8),h0tab(:,8),[16,4,2,1,8],[nMZ,nMT,nMZ,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(4),m3h3x16(:,8),heltab2x48(:,:,8))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[nMW,nMB,nMW,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(5),m3h3x16(:,9),heltab2x48(:,:,9))
  Gcoeff(:)%j = (c(62)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(10),h0tab(:,10),[16,4,2,1,8],[nMW,nMB,nMW,0,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(6),m3h3x16(:,10),heltab2x48(:,:,10))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(11),h0tab(:,11),[16,2,1,8,4],[nMB,nMW,0,0,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(5),m3h3x16(:,11),heltab2x48(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(7),n2h16(1))
  Gcoeff(:)%j = (c(99)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(12),h0tab(:,12),[16,2,1,8,4],[nMB,nMW,0,nMZ,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(5),m3h3x16(:,12),heltab2x48(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(8),n2h16(2))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(13),h0tab(:,13),[16,1,2,4,8],[0,0,nMT,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(5),m3h3x16(:,13),heltab2x48(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(9),n2h16(3))
  Gcoeff(:)%j = (c(128)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(14),h0tab(:,14),[16,1,2,4,8],[0,0,nMT,nMZ,0],5,0)
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(5),m3h3x16(:,14),heltab2x48(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(10),n2h16(4))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(15),h0tab(:,15),[16,1,2,4,8],[0,nMZ,nMT,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(5),m3h3x16(:,15),heltab2x48(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(11),n2h16(5))
  Gcoeff(:)%j = (c(130)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(16),h0tab(:,16),[16,1,2,4,8],[0,nMZ,nMT,nMZ,0],5,0)
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(5),m3h3x16(:,16),heltab2x48(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(12),n2h16(6))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(17),h0tab(:,17),[16,2,4,1,8],[nMH,nMT,0,0,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(5),m3h3x16(:,17),heltab2x48(:,:,17))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(18),h0tab(:,18),[16,2,4,1,8],[nMH,nMT,nMZ,0,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(6),m3h3x16(:,18),heltab2x48(:,:,18))
  Gcoeff(:)%j = (c(126)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(19),h0tab(:,19),[16,2,4,1,8],[0,nMT,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(13),m3h3x16(:,19),heltab2x48(:,:,19))
  Gcoeff(:)%j = (c(109)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(20),h0tab(:,20),[16,2,4,1,8],[nMZ,nMT,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(14),m3h3x16(:,20),heltab2x48(:,:,20))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(21),h0tab(:,21),[16,2,4,1,8],[0,nMT,nMZ,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(15),m3h3x16(:,21),heltab2x48(:,:,21))
  Gcoeff(:)%j = (c(111)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(22),h0tab(:,22),[16,2,4,1,8],[nMZ,nMT,nMZ,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(16),m3h3x16(:,22),heltab2x48(:,:,22))
  Gcoeff(:)%j = (c(97)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(23),h0tab(:,23),[16,2,8,1,4],[nMB,nMW,0,0,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(7),m3h3x16(:,23),heltab2x48(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMB,G1H16(17),n2h16(7))
  Gcoeff(:)%j = (c(99)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(24),h0tab(:,24),[16,2,8,1,4],[nMB,nMW,0,nMZ,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(7),m3h3x16(:,24),heltab2x48(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMB,G1H16(18),n2h16(8))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(25),h0tab(:,25),[16,1,4,2,8],[0,0,nMT,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(7),m3h3x16(:,25),heltab2x48(:,:,25))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(19),n2h16(9))
  Gcoeff(:)%j = (c(128)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(26),h0tab(:,26),[16,1,4,2,8],[0,0,nMT,nMZ,0],5,0)
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(7),m3h3x16(:,26),heltab2x48(:,:,26))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(20),n2h16(10))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(27),h0tab(:,27),[16,1,4,2,8],[0,nMZ,nMT,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(7),m3h3x16(:,27),heltab2x48(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(21),n2h16(11))
  Gcoeff(:)%j = (c(130)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(28),h0tab(:,28),[16,1,4,2,8],[0,nMZ,nMT,nMZ,0],5,0)
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(7),m3h3x16(:,28),heltab2x48(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(22),n2h16(12))
  Gcoeff(:)%j = (c(73)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(29),h0tab(:,29),[16,1,8,2,4],[nMW,0,0,nMT,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(7),m3h3x16(:,29),heltab2x48(:,:,29))
  Gcoeff(:)%j = (c(98)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(30),h0tab(:,30),[16,1,8,2,4],[0,0,nMW,nMB,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(8),m3h3x16(:,30),heltab2x48(:,:,30))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(31),h0tab(:,31),[16,1,8,2,4],[nMW,0,nMZ,nMT,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(9),m3h3x16(:,31),heltab2x48(:,:,31))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(32),h0tab(:,32),[16,1,8,2,4],[nMZ,0,nMW,nMB,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(10),m3h3x16(:,32),heltab2x48(:,:,32))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(33),h0tab(:,33),[16,1,8,2,4],[nMW,0,0,nMT,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(23),m3h3x16(:,33),heltab2x48(:,:,33))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(34),h0tab(:,34),[16,1,8,2,4],[nMW,0,0,nMT,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(24),m3h3x16(:,34),heltab2x48(:,:,34))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(35),h0tab(:,35),[16,1,8,2,4],[nMW,0,nMZ,nMT,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(25),m3h3x16(:,35),heltab2x48(:,:,35))
  Gcoeff(:)%j = (c(111)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(36),h0tab(:,36),[16,1,8,2,4],[nMW,0,nMZ,nMT,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(26),m3h3x16(:,36),heltab2x48(:,:,36))
  Gcoeff(:)%j = (c(98)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(37),h0tab(:,37),[16,1,8,2,4],[0,0,nMW,nMB,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(27),m3h3x16(:,37),heltab2x48(:,:,37))
  Gcoeff(:)%j = (c(62)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(38),h0tab(:,38),[16,1,8,2,4],[nMZ,0,nMW,nMB,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(28),m3h3x16(:,38),heltab2x48(:,:,38))
  Gcoeff(:)%j = (c(73)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(39),h0tab(:,39),[16,1,8,4,2],[nMW,0,0,nMT,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(11),m3h3x16(:,39),heltab2x48(:,:,39))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(40),h0tab(:,40),[16,1,8,4,2],[nMW,0,nMZ,nMT,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(12),m3h3x16(:,40),heltab2x48(:,:,40))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(41),h0tab(:,41),[16,1,8,4,2],[nMW,0,0,nMT,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(29),m3h3x16(:,41),heltab2x48(:,:,41))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(42),h0tab(:,42),[16,1,8,4,2],[nMW,0,nMZ,nMT,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(30),m3h3x16(:,42),heltab2x48(:,:,42))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(43),h0tab(:,43),[16,1,8,4,2],[nMW,0,0,nMT,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(31),m3h3x16(:,43),heltab2x48(:,:,43))
  Gcoeff(:)%j = (c(111)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(44),h0tab(:,44),[16,1,8,4,2],[nMW,0,nMZ,nMT,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(32),m3h3x16(:,44),heltab2x48(:,:,44))
  call Hloop_SA_Q(ntryL,G0H16(1),ex3(:),G0H8(1),ngH,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G0H8(1),20,nMT,G1H8(1),n2h8(1))
  call Hloop_SA_Q(ntryL,G0H16(2),ex3(:),G0H8(1),ngPtb,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G0H8(1),20,nMB,G1H8(2),n2h8(2))
  call Hloop_SA_Q(ntryL,G0H16(3),ex3(:),G0H8(1),ngH,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H8(1),20,nMT,G1H8(3),n2h8(3))
  call Hloop_SA_Q(ntryL,G0H16(4),ex3(:),G0H8(1),ngPtb,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G0H8(1),20,nMB,G1H8(4),n2h8(4))
  call Hloop_VA_Q(ntryL,G1H16(1),ex3(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(5),20,nMT,G2H8(1),n2h8(5))
  call Hloop_ZA_Q(ntryL,G1H16(2),ex3(:),G1H8(5),ngZu,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(5),20,nMT,G2H8(2),n2h8(6))
  call Hloop_VA_Q(ntryL,G1H16(3),ex3(:),G1H8(5),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(5),20,nMT,G2H8(3),n2h8(7))
  call Hloop_ZA_Q(ntryL,G1H16(4),ex3(:),G1H8(5),ngZu,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(5),20,nMT,G2H8(4),n2h8(8))
  call Hloop_WA_Q(ntryL,G1H16(5),ex3(:),G1H8(5),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(5),20,nMB,G2H8(5),n2h8(9))
  call Hloop_WA_Q(ntryL,G1H16(6),ex3(:),G1H8(5),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(5),20,nMB,G2H8(6),n2h8(10))
  call Hloop_AQ_W(ntryL,G1H16(7),ex2(:),G1H8(5),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_W(ntryL,G1H16(8),ex2(:),G1H8(6),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_QA_V(ntryL,G1H16(9),ex1(:),G1H8(7),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_QA_V(ntryL,G1H16(10),ex1(:),G1H8(8),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_QA_Z(ntryL,G1H16(11),ex1(:),G1H8(9),ngZu,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_QA_Z(ntryL,G1H16(12),ex1(:),G1H8(10),ngZu,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_SQ_A(ntryL,G0H16(5),ex2(:),G0H8(1),ngH,m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G0H8(1),18,nMT,G1H8(11),n2h8(11))
  call Hloop_SQ_A(ntryL,G0H16(6),ex2(:),G0H8(1),ngH,m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G0H8(1),18,nMT,G1H8(12),n2h8(12))
  call Hloop_VQ_A(ntryL,G1H16(13),ex2(:),G1H8(13),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(13),18,nMT,G2H8(7),n2h8(13))
  call Hloop_ZQ_A(ntryL,G1H16(14),ex2(:),G1H8(13),ngZu,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(13),18,nMT,G2H8(8),n2h8(14))
  call Hloop_VQ_A(ntryL,G1H16(15),ex2(:),G1H8(13),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(13),18,nMT,G2H8(9),n2h8(15))
  call Hloop_ZQ_A(ntryL,G1H16(16),ex2(:),G1H8(13),ngZu,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(13),18,nMT,G2H8(10),n2h8(16))
  call Hloop_AQ_W(ntryL,G1H16(17),ex2(:),G1H8(13),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_AQ_W(ntryL,G1H16(18),ex2(:),G1H8(14),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_QA_V(ntryL,G1H16(19),ex1(:),G1H8(15),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_QA_V(ntryL,G1H16(20),ex1(:),G1H8(16),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_QA_Z(ntryL,G1H16(21),ex1(:),G1H8(17),ngZu,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_QA_Z(ntryL,G1H16(22),ex1(:),G1H8(18),ngZu,m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_WA_Q(ntryL,G0H16(7),ex1(:),G0H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(19),n2h8(17))
  call Hloop_VA_Q(ntryL,G0H16(8),ex1(:),G0H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(20),n2h8(18))
  call Hloop_WA_Q(ntryL,G0H16(9),ex1(:),G0H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(21),n2h8(19))
  call Hloop_ZA_Q(ntryL,G0H16(10),ex1(:),G0H8(1),ngZu,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(22),n2h8(20))
  call Hloop_WA_Q(ntryL,G1H16(23),ex1(:),G1H8(23),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(23),17,0,G2H8(11),n2h8(21))
  call Hloop_WA_Q(ntryL,G1H16(24),ex1(:),G1H8(23),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(23),17,0,G2H8(12),n2h8(22))
  call Hloop_WA_Q(ntryL,G1H16(25),ex1(:),G1H8(23),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(23),17,0,G2H8(13),n2h8(23))
  call Hloop_WA_Q(ntryL,G1H16(26),ex1(:),G1H8(23),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(23),17,0,G2H8(14),n2h8(24))
  call Hloop_VA_Q(ntryL,G1H16(27),ex1(:),G1H8(23),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(23),17,0,G2H8(15),n2h8(25))
  call Hloop_ZA_Q(ntryL,G1H16(28),ex1(:),G1H8(23),ngZu,m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(23),17,0,G2H8(16),n2h8(26))
  call Hloop_WA_Q(ntryL,G0H16(11),ex1(:),G0H8(1),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(23),n2h8(27))
  call Hloop_WA_Q(ntryL,G0H16(12),ex1(:),G0H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(24),n2h8(28))
  call Hloop_WA_Q(ntryL,G1H16(29),ex1(:),G1H8(25),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(25),17,0,G2H8(17),n2h8(29))
  call Hloop_WA_Q(ntryL,G1H16(30),ex1(:),G1H8(25),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(25),17,0,G2H8(18),n2h8(30))
  call Hloop_WA_Q(ntryL,G1H16(31),ex1(:),G1H8(25),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(25),17,0,G2H8(19),n2h8(31))
  call Hloop_WA_Q(ntryL,G1H16(32),ex1(:),G1H8(25),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(25),17,0,G2H8(20),n2h8(32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(4)])
  call Hloop_AQ_V(ntryL,G1H8(1),ex2(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_W(ntryL,G2H8(5),ex2(:),G2H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H8(3),ex2(:),G1H4(2),ngZu,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_W(ntryL,G2H8(6),ex2(:),G2H4(2),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(1),ex2(:),G2H4(3),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(2),ex2(:),G2H4(4),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_Z(ntryL,G2H8(3),ex2(:),G2H4(5),ngZu,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_Z(ntryL,G2H8(4),ex2(:),G2H4(6),ngZu,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_WA_Q(ntryL,G1H8(5),ex1(:),G1H4(3),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(3),19,0,G2H4(7),n2h4(1))
  call Hloop_WA_Q(ntryL,G1H8(6),ex1(:),G1H4(3),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(3),19,0,G2H4(8),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(7),ex2(:),G1H4(3),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(3),19,nMT,G2H4(9),n2h4(3))
  call Hloop_VQ_A(ntryL,G1H8(8),ex2(:),G1H4(3),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(3),19,nMT,G2H4(10),n2h4(4))
  call Hloop_ZQ_A(ntryL,G1H8(9),ex2(:),G1H4(3),ngZu,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(3),19,nMT,G2H4(11),n2h4(5))
  call Hloop_ZQ_A(ntryL,G1H8(10),ex2(:),G1H4(3),ngZu,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(3),19,nMT,G2H4(12),n2h4(6))
  call Hloop_QA_V(ntryL,G1H8(11),ex3(:),G1H4(3),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_QA_Z(ntryL,G1H8(12),ex3(:),G1H4(4),ngZu,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_QA_V(ntryL,G2H8(7),ex3(:),G2H4(13),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_QA_V(ntryL,G2H8(8),ex3(:),G2H4(14),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_QA_Z(ntryL,G2H8(9),ex3(:),G2H4(15),ngZu,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_Z(ntryL,G2H8(10),ex3(:),G2H4(16),ngZu,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_WQ_A(ntryL,G1H8(13),ex4(:),G1H4(5),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(5),26,0,G2H4(17),n2h4(7))
  call Hloop_WQ_A(ntryL,G1H8(14),ex4(:),G1H4(5),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(5),26,0,G2H4(18),n2h4(8))
  call Hloop_VA_Q(ntryL,G1H8(15),ex3(:),G1H4(5),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(5),21,nMT,G2H4(19),n2h4(9))
  call Hloop_VA_Q(ntryL,G1H8(16),ex3(:),G1H4(5),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(5),21,nMT,G2H4(20),n2h4(10))
  call Hloop_ZA_Q(ntryL,G1H8(17),ex3(:),G1H4(5),ngZu,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(5),21,nMT,G2H4(21),n2h4(11))
  call Hloop_ZA_Q(ntryL,G1H8(18),ex3(:),G1H4(5),ngZu,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(5),21,nMT,G2H4(22),n2h4(12))
  call Hloop_AQ_V(ntryL,G1H8(19),ex4(:),G1H4(5),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_AQ_W(ntryL,G1H8(20),ex4(:),G1H4(6),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_AQ_Z(ntryL,G1H8(21),ex4(:),G1H4(7),ngZd,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_AQ_W(ntryL,G1H8(22),ex4(:),G1H4(8),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_AQ_V(ntryL,G2H8(11),ex4(:),G2H4(23),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_AQ_V(ntryL,G2H8(12),ex4(:),G2H4(24),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_AQ_Z(ntryL,G2H8(13),ex4(:),G2H4(25),ngZd,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_AQ_Z(ntryL,G2H8(14),ex4(:),G2H4(26),ngZd,m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AQ_W(ntryL,G2H8(15),ex4(:),G2H4(27),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_AQ_W(ntryL,G2H8(16),ex4(:),G2H4(28),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_AQ_V(ntryL,G1H8(23),ex4(:),G1H4(9),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_AQ_Z(ntryL,G1H8(24),ex4(:),G1H4(10),ngZd,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_AQ_V(ntryL,G2H8(17),ex4(:),G2H4(29),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_AQ_Z(ntryL,G2H8(18),ex4(:),G2H4(30),ngZd,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_AQ_V(ntryL,G2H8(19),ex4(:),G2H4(31),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_AQ_Z(ntryL,G2H8(20),ex4(:),G2H4(32),ngZd,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_VA_Q(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(1),n2h2(1))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),4)
  call HG1shiftOLR(G1H4(11),8,4)
  call Hloop_ZA_Q(ntryL,G1H4(2),ex1(:),G1H2(1),ngZu,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(2),n2h2(2))
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,2),  & 
G1H4(2),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,3),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,4),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(1),mass5set(:,5),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(1),mass5set(:,6),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),8,4)
  call Hloop_AQ_V(ntryL,G2H4(7),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H4(8),ex4(:),G2H2(4),ngZd,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(9),ex3(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_Z(ntryL,G2H4(10),ex3(:),G2H2(6),ngZu,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(11),ex3(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_Z(ntryL,G2H4(12),ex3(:),G2H2(8),ngZu,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_VA_Q(ntryL,G1H4(3),ex1(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(9),n2h2(3))
  call Hloop_ZA_Q(ntryL,G1H4(4),ex1(:),G1H2(1),ngZu,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(10),n2h2(4))
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(2),mass5set(:,3),  & 
G1H4(3),G1H4(4),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(4),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(2),mass5set(:,4),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(2),mass5set(:,5),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(2),mass5set(:,6),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hloop_QA_V(ntryL,G2H4(17),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_Z(ntryL,G2H4(18),ex1(:),G2H2(12),ngZu,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_V(ntryL,G2H4(19),ex2(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_Z(ntryL,G2H4(20),ex2(:),G2H2(14),ngZu,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(21),ex2(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_Z(ntryL,G2H4(22),ex2(:),G2H2(16),ngZu,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VQ_A(ntryL,G1H4(5),ex2(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(17),n2h2(5))
  call Hloop_WQ_A(ntryL,G1H4(6),ex2(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(18),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex2(:),G1H2(1),ngZu,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(19),n2h2(7))
  call Hloop_WQ_A(ntryL,G1H4(8),ex2(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(20),n2h2(8))
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(3),mass5set(:,7),  & 
G1H4(5),G1H4(6),G1H4(7),G1H4(8),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(6),4,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(3),mass5set(:,8),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
  call HG1shiftOLR(G1H4(70),4,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(3),mass5set(:,9),  & 
G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
  call HG1shiftOLR(G1H4(76),4,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(3),mass5set(:,10),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),4,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(3),mass5set(:,11),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(88),4,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(3),mass5set(:,12),  & 
G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(94),4,4)
  call Hloop_VA_Q(ntryL,G1H4(9),ex3(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),29,nMT,G2H2(21),n2h2(9))
  call Hloop_ZA_Q(ntryL,G1H4(10),ex3(:),G1H2(1),ngZu,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),29,nMT,G2H2(22),n2h2(10))
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(4),mass5set(:,7),  & 
G1H4(9),G1H4(10),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(10),2,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(4),mass5set(:,9),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),2,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(4),mass5set(:,8),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),2,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(4),mass5set(:,10),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),2,4)
  call Hloop_WA_Q(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(23),n2h2(11))
call HGT_raise_alpha_OLR(G1H4(11),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(11),ex4(:),G1H2(1),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_WA_Q(ntryL,G1H4(14),ex1(:),G1H2(2),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(2),23,0,G2H2(24),n2h2(12))
  call Hloop_WA_Q(ntryL,G1H4(15),ex1(:),G1H2(2),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(2),23,0,G2H2(25),n2h2(13))
  call Hloop_WA_Q(ntryL,G1H4(2),ex1(:),G1H2(2),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(2),23,0,G2H2(26),n2h2(14))
call HGT_raise_alpha_OLR(G1H4(16),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(16),ex4(:),G1H2(2),ngZd,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_WA_Q(ntryL,G1H4(19),ex1(:),G1H2(3),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(27),n2h2(15))
  call Hloop_WA_Q(ntryL,G1H4(20),ex1(:),G1H2(3),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(28),n2h2(16))
  call Hloop_VA_Q(ntryL,G1H4(21),ex1(:),G1H2(3),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(29),n2h2(17))
call HGT_raise_alpha_OLR(G1H4(22),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(22),ex4(:),G1H2(3),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_VA_Q(ntryL,G1H4(25),ex1(:),G1H2(4),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(4),23,0,G2H2(30),n2h2(18))
  call Hloop_VA_Q(ntryL,G1H4(26),ex1(:),G1H2(4),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(4),23,0,G2H2(31),n2h2(19))
  call Hloop_VA_Q(ntryL,G1H4(27),ex1(:),G1H2(4),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(4),23,0,G2H2(32),n2h2(20))
call HGT_raise_alpha_OLR(G1H4(28),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(28),ex4(:),G1H2(4),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_VA_Q(ntryL,G1H4(31),ex1(:),G1H2(5),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(33),n2h2(21))
  call Hloop_VA_Q(ntryL,G1H4(32),ex1(:),G1H2(5),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(34),n2h2(22))
  call Hloop_ZA_Q(ntryL,G1H4(33),ex1(:),G1H2(5),ngZu,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(35),n2h2(23))
call HGT_raise_alpha_OLR(G1H4(34),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(34),ex4(:),G1H2(5),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_ZA_Q(ntryL,G1H4(37),ex1(:),G1H2(6),ngZu,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(6),23,0,G2H2(36),n2h2(24))
  call Hloop_ZA_Q(ntryL,G1H4(38),ex1(:),G1H2(6),ngZu,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(6),23,0,G2H2(37),n2h2(25))
  call Hloop_ZA_Q(ntryL,G1H4(39),ex1(:),G1H2(6),ngZu,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(6),23,0,G2H2(38),n2h2(26))
call HGT_raise_alpha_OLR(G1H4(40),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(40),ex4(:),G1H2(6),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_ZA_Q(ntryL,G1H4(43),ex1(:),G1H2(7),ngZu,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(7),23,0,G2H2(39),n2h2(27))
  call Hloop_ZA_Q(ntryL,G1H4(44),ex1(:),G1H2(7),ngZu,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(7),23,0,G2H2(40),n2h2(28))
  call Hloop_VA_Q(ntryL,G1H4(3),ex1(:),G1H2(7),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(7),23,0,G2H2(41),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(4),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(4),ex4(:),G1H2(7),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_VA_Q(ntryL,G1H4(47),ex1(:),G1H2(8),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(8),23,0,G2H2(42),n2h2(30))
  call Hloop_VA_Q(ntryL,G1H4(48),ex1(:),G1H2(8),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(8),23,0,G2H2(43),n2h2(31))
  call Hloop_VA_Q(ntryL,G1H4(49),ex1(:),G1H2(8),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(8),23,0,G2H2(44),n2h2(32))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(50),ex4(:),G1H2(8),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_VA_Q(ntryL,G1H4(53),ex1(:),G1H2(9),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(9),23,0,G2H2(45),n2h2(33))
  call Hloop_VA_Q(ntryL,G1H4(54),ex1(:),G1H2(9),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(9),23,0,G2H2(46),n2h2(34))
  call Hloop_ZA_Q(ntryL,G1H4(55),ex1(:),G1H2(9),ngZu,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(9),23,0,G2H2(47),n2h2(35))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(56),ex4(:),G1H2(9),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_ZA_Q(ntryL,G1H4(59),ex1(:),G1H2(10),ngZu,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(10),23,0,G2H2(48),n2h2(36))
  call Hloop_ZA_Q(ntryL,G1H4(60),ex1(:),G1H2(10),ngZu,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(10),23,0,G2H2(49),n2h2(37))
  call Hloop_ZA_Q(ntryL,G1H4(61),ex1(:),G1H2(10),ngZu,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(10),23,0,G2H2(50),n2h2(38))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(62),ex4(:),G1H2(10),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_ZA_Q(ntryL,G1H4(65),ex1(:),G1H2(11),ngZu,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(11),23,0,G2H2(51),n2h2(39))
  call Hloop_ZA_Q(ntryL,G1H4(66),ex1(:),G1H2(11),ngZu,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(11),23,0,G2H2(52),n2h2(40))
  call Hloop_VQ_A(ntryL,G1H4(5),ex2(:),G1H2(11),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(11),27,nMT,G2H2(53),n2h2(41))
call HGT_raise_alpha_OLR(G1H4(6),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(6),ex3(:),G1H2(11),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_VQ_A(ntryL,G1H4(67),ex2(:),G1H2(12),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(12),27,nMT,G2H2(54),n2h2(42))
  call Hloop_VQ_A(ntryL,G1H4(68),ex2(:),G1H2(12),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(12),27,nMT,G2H2(55),n2h2(43))
  call Hloop_VQ_A(ntryL,G1H4(69),ex2(:),G1H2(12),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(12),27,nMT,G2H2(56),n2h2(44))
call HGT_raise_alpha_OLR(G1H4(70),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(70),ex3(:),G1H2(12),ngZu,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_VQ_A(ntryL,G1H4(73),ex2(:),G1H2(13),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(13),27,nMT,G2H2(57),n2h2(45))
  call Hloop_VQ_A(ntryL,G1H4(74),ex2(:),G1H2(13),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(13),27,nMT,G2H2(58),n2h2(46))
  call Hloop_ZQ_A(ntryL,G1H4(75),ex2(:),G1H2(13),ngZu,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(13),27,nMT,G2H2(59),n2h2(47))
call HGT_raise_alpha_OLR(G1H4(76),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(76),ex3(:),G1H2(13),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_ZQ_A(ntryL,G1H4(79),ex2(:),G1H2(14),ngZu,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(14),27,nMT,G2H2(60),n2h2(48))
  call Hloop_ZQ_A(ntryL,G1H4(80),ex2(:),G1H2(14),ngZu,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(14),27,nMT,G2H2(61),n2h2(49))
  call Hloop_ZQ_A(ntryL,G1H4(81),ex2(:),G1H2(14),ngZu,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(14),27,nMT,G2H2(62),n2h2(50))
call HGT_raise_alpha_OLR(G1H4(82),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(82),ex3(:),G1H2(14),ngZu,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_ZQ_A(ntryL,G1H4(85),ex2(:),G1H2(15),ngZu,m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(15),27,nMT,G2H2(63),n2h2(51))
  call Hloop_ZQ_A(ntryL,G1H4(86),ex2(:),G1H2(15),ngZu,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(15),27,nMT,G2H2(64),n2h2(52))
  call Hloop_WQ_A(ntryL,G1H4(87),ex2(:),G1H2(15),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(15),27,nMB,G2H2(65),n2h2(53))
call HGT_raise_alpha_OLR(G1H4(88),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(88),ex3(:),G1H2(15),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_WQ_A(ntryL,G1H4(91),ex2(:),G1H2(16),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(16),27,nMB,G2H2(66),n2h2(54))
  call Hloop_WQ_A(ntryL,G1H4(92),ex2(:),G1H2(16),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(16),27,nMB,G2H2(67),n2h2(55))
  call Hloop_WQ_A(ntryL,G1H4(93),ex2(:),G1H2(16),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(16),27,nMB,G2H2(68),n2h2(56))
call HGT_raise_alpha_OLR(G1H4(94),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(94),ex3(:),G1H2(16),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_WQ_A(ntryL,G1H4(97),ex2(:),G1H2(17),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(17),27,nMB,G2H2(69),n2h2(57))
  call Hloop_WQ_A(ntryL,G1H4(98),ex2(:),G1H2(17),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(17),27,nMB,G2H2(70),n2h2(58))
  call Hloop_VA_Q(ntryL,G1H4(9),ex3(:),G1H2(17),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(17),29,nMT,G2H2(71),n2h2(59))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(10),ex2(:),G1H2(17),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_VA_Q(ntryL,G1H4(101),ex3(:),G1H2(18),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(18),29,nMT,G2H2(72),n2h2(60))
  call Hloop_VA_Q(ntryL,G1H4(102),ex3(:),G1H2(18),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(18),29,nMT,G2H2(73),n2h2(61))
  call Hloop_ZA_Q(ntryL,G1H4(103),ex3(:),G1H2(18),ngZu,m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(18),29,nMT,G2H2(74),n2h2(62))
call HGT_raise_alpha_OLR(G1H4(104),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(104),ex2(:),G1H2(18),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_ZA_Q(ntryL,G1H4(107),ex3(:),G1H2(19),ngZu,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(19),29,nMT,G2H2(75),n2h2(63))
  call Hloop_ZA_Q(ntryL,G1H4(108),ex3(:),G1H2(19),ngZu,m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(19),29,nMT,G2H2(76),n2h2(64))
  call Hloop_VA_Q(ntryL,G1H4(109),ex3(:),G1H2(19),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(19),29,nMT,G2H2(77),n2h2(65))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(110),ex2(:),G1H2(19),ngZu,m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_VA_Q(ntryL,G1H4(113),ex3(:),G1H2(20),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(20),29,nMT,G2H2(78),n2h2(66))
  call Hloop_VA_Q(ntryL,G1H4(114),ex3(:),G1H2(20),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(20),29,nMT,G2H2(79),n2h2(67))
  call Hloop_ZA_Q(ntryL,G1H4(115),ex3(:),G1H2(20),ngZu,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(20),29,nMT,G2H2(80),n2h2(68))
call HGT_raise_alpha_OLR(G1H4(116),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(116),ex2(:),G1H2(20),ngZu,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_ZA_Q(ntryL,G1H4(119),ex3(:),G1H2(21),ngZu,m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(21),29,nMT,G2H2(81),n2h2(69))
  call Hloop_ZA_Q(ntryL,G1H4(120),ex3(:),G1H2(21),ngZu,m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(21),29,nMT,G2H2(82),n2h2(70))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(5),mass5set(:,13),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),4,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(5),mass5set(:,14),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),4,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(6),mass5set(:,15),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(34),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(6),mass5set(:,16),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(6),mass5set(:,17),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(6),mass5set(:,18),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(52),8,2)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(10),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(7),mass5set(:,13),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),4,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(7),mass5set(:,14),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),4,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(8),mass5set(:,15),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(8),mass5set(:,16),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(76),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(8),mass5set(:,17),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(82),8,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(8),mass5set(:,18),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),G1H2(92),2)
  call HG1shiftOLR(G1H2(88),8,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(5),ngH,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(6),ngPtb,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(7),ngH,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(20),ex3(:),G2tensor(8),ngPtb,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(21),ex2(:),G2tensor(9),ngH,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(22),ex2(:),G2tensor(10),ngH,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(23),ex4(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(25),ex4(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(26),ex4(:),G2tensor(13),ngZd,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(28),ex4(:),G2tensor(14),ngZd,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(29),ex4(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(31),ex4(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(32),ex4(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(38),ex4(:),G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(41),ex4(:),G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(43),ex4(:),G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(44),ex4(:),G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(46),ex4(:),G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(47),ex4(:),G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(49),ex4(:),G2tensor(28),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(52),ex4(:),G2tensor(30),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(53),ex3(:),G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(55),ex3(:),G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(56),ex3(:),G2tensor(33),ngZu,m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(58),ex3(:),G2tensor(34),ngZu,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(59),ex3(:),G2tensor(35),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(61),ex3(:),G2tensor(36),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(62),ex3(:),G2tensor(37),ngZu,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(64),ex3(:),G2tensor(38),ngZu,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(65),ex3(:),G2tensor(39),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(67),ex3(:),G2tensor(40),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(68),ex3(:),G2tensor(41),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(70),ex3(:),G2tensor(42),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(71),ex2(:),G2tensor(43),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(73),ex2(:),G2tensor(44),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(74),ex2(:),G2tensor(45),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(76),ex2(:),G2tensor(46),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(77),ex2(:),G2tensor(47),ngZu,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(79),ex2(:),G2tensor(48),ngZu,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(80),ex2(:),G2tensor(49),ngZu,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(82),ex2(:),G2tensor(50),ngZu,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hloop_VA_Q(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(51),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(52),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(26),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(53),n2h1(3))
  call Hloop_ZA_Q(ntryL,G1H2(27),ex3(:),G1H1(1),ngZu,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(54),n2h1(4))
  call Hloop_ZA_Q(ntryL,G1H2(28),ex3(:),G1H1(1),ngZu,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(55),n2h1(5))
  call Hloop_ZA_Q(ntryL,G1H2(32),ex3(:),G1H1(1),ngZu,m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(56),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(58),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(9))
  call Hloop_ZQ_A(ntryL,G1H2(39),ex4(:),G1H1(1),ngZd,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(60),n2h1(10))
  call Hloop_ZQ_A(ntryL,G1H2(40),ex4(:),G1H1(1),ngZd,m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(61),n2h1(11))
  call Hloop_ZQ_A(ntryL,G1H2(44),ex4(:),G1H1(1),ngZd,m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(12))
  call Hloop_VQ_A(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(13))
  call Hloop_VQ_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(64),n2h1(14))
  call Hloop_VQ_A(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(15))
  call Hloop_ZQ_A(ntryL,G1H2(51),ex4(:),G1H1(1),ngZd,m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(66),n2h1(16))
  call Hloop_ZQ_A(ntryL,G1H2(52),ex4(:),G1H1(1),ngZd,m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(67),n2h1(17))
  call Hloop_ZQ_A(ntryL,G1H2(56),ex4(:),G1H1(1),ngZd,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(57),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(69),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(58),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(70),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(62),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(71),n2h1(21))
  call Hloop_ZA_Q(ntryL,G1H2(63),ex3(:),G1H1(1),ngZu,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(72),n2h1(22))
  call Hloop_ZA_Q(ntryL,G1H2(64),ex3(:),G1H1(1),ngZu,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(73),n2h1(23))
  call Hloop_ZA_Q(ntryL,G1H2(68),ex3(:),G1H1(1),ngZu,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(74),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(76),n2h1(26))
  call Hloop_VQ_A(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(27))
  call Hloop_ZQ_A(ntryL,G1H2(75),ex4(:),G1H1(1),ngZd,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(78),n2h1(28))
  call Hloop_ZQ_A(ntryL,G1H2(76),ex4(:),G1H1(1),ngZd,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(79),n2h1(29))
  call Hloop_ZQ_A(ntryL,G1H2(80),ex4(:),G1H1(1),ngZd,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(80),n2h1(30))
  call Hloop_VQ_A(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(31))
  call Hloop_VQ_A(ntryL,G1H2(82),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(82),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(33))
  call Hloop_ZQ_A(ntryL,G1H2(87),ex4(:),G1H1(1),ngZd,m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(84),n2h1(34))
  call Hloop_ZQ_A(ntryL,G1H2(88),ex4(:),G1H1(1),ngZd,m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(85),n2h1(35))
  call Hloop_ZQ_A(ntryL,G1H2(92),ex4(:),G1H1(1),ngZd,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(86),n2h1(36))
  call ol_merge_tensors(G2tensor(39),[G2tensor(6)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(8)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,19),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,20),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,19),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,20),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,21),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),4)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(3),mass5set(:,11),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(3),mass5set(:,22),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),4)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(3),mass5set(:,12),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,21),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),2)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(4),mass5set(:,22),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),2)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(1),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(1),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(1),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(1),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(1),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(1),mass5set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(2),mass5set(:,3),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(2),mass5set(:,4),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(2),mass5set(:,5),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(2),mass5set(:,6),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(3),mass5set(:,7),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),4)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(3),mass5set(:,8),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(3),mass5set(:,9),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(3),mass5set(:,10),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(4),mass5set(:,7),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),2)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(4),mass5set(:,9),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),2)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(4),mass5set(:,8),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),2)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(4),mass5set(:,10),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),2)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(5),mass5set(:,13),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),4)
  call Hotf_5pt_reduction_last(G2tensor(54),RedSet_5(5),mass5set(:,14),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),4)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(6),mass5set(:,15),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(6),mass5set(:,16),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(6),mass5set(:,17),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(66),RedSet_5(6),mass5set(:,18),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(7),mass5set(:,13),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),4)
  call Hotf_5pt_reduction_last(G2tensor(72),RedSet_5(7),mass5set(:,14),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(8),mass5set(:,15),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),8)
  call Hotf_5pt_reduction_last(G2tensor(78),RedSet_5(8),mass5set(:,16),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),8)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(8),mass5set(:,17),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(84),RedSet_5(8),mass5set(:,18),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),8)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(45),h0tab(:,45),[16,1,8,6],[0,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,45),heltab2x48(:,:,45))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(46),h0tab(:,46),[16,1,8,6],[nMZ,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(2),m3h3x16(:,46),heltab2x48(:,:,46))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(47),h0tab(:,47),[16,1,8,6],[0,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(3),m3h3x16(:,47),heltab2x48(:,:,47))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(48),h0tab(:,48),[16,1,8,6],[nMW,0,nMZ,nMH],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(4),m3h3x16(:,48),heltab2x48(:,:,48))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(49),h0tab(:,49),[16,1,8,6],[nMZ,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(5),m3h3x16(:,49),heltab2x48(:,:,49))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(50),h0tab(:,50),[16,1,8,6],[nMW,0,nMZ,nMZ],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(1),m3h3x16(:,50),heltab2x48(:,:,50))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(51),h0tab(:,51),[16,1,8,6],[0,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(2),m3h3x16(:,51),heltab2x48(:,:,51))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(52),h0tab(:,52),[16,1,8,6],[nMZ,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(3),m3h3x16(:,52),heltab2x48(:,:,52))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(53),h0tab(:,53),[16,1,8,6],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(6),m3h3x16(:,53),heltab2x48(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(6),16,0,G1H16(4),n2h16(13))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(54),h0tab(:,54),[16,1,8,6],[0,nMZ,0,0],4,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(7),m3h3x16(:,54),heltab2x48(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(5),n2h16(14))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(55),h0tab(:,55),[16,1,8,6],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(8),m3h3x16(:,55),heltab2x48(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(8),16,0,G1H16(6),n2h16(15))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(56),h0tab(:,56),[16,1,8,6],[0,nMZ,0,0],4,1,wf4(:,4))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(9),m3h3x16(:,56),heltab2x48(:,:,56))
  call Hloop_Q_A(ntryL,G0H16(9),16,0,G1H16(7),n2h16(16))
  Gcoeff(:)%j = (-(c(134)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(57),h0tab(:,57),[16,1,8,6],[0,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(10),m3h3x16(:,57),heltab2x48(:,:,57))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(58),h0tab(:,58),[16,1,8,6],[nMZ,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(11),m3h3x16(:,58),heltab2x48(:,:,58))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(59),h0tab(:,59),[16,1,8,6],[0,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(12),m3h3x16(:,59),heltab2x48(:,:,59))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(60),h0tab(:,60),[16,1,8,6],[nMW,0,nMZ,nMH],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(6),m3h3x16(:,60),heltab2x48(:,:,60))
  Gcoeff(:)%j = (-(c(141)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(61),h0tab(:,61),[16,1,8,6],[nMZ,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(7),m3h3x16(:,61),heltab2x48(:,:,61))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(62),h0tab(:,62),[16,1,8,6],[0,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(8),m3h3x16(:,62),heltab2x48(:,:,62))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(63),h0tab(:,63),[16,1,8,6],[nMZ,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(9),m3h3x16(:,63),heltab2x48(:,:,63))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(64),h0tab(:,64),[16,1,8,6],[0,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(10),m3h3x16(:,64),heltab2x48(:,:,64))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(65),h0tab(:,65),[16,1,8,6],[nMZ,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(11),m3h3x16(:,65),heltab2x48(:,:,65))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(66),h0tab(:,66),[16,6,1,8],[nMW,nMW,0,0],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(8),m3h3x16(:,66),heltab2x48(:,:,66))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(67),h0tab(:,67),[16,6,1,8],[nMW,nMW,0,nMZ],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(9),m3h3x16(:,67),heltab2x48(:,:,67))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(68),h0tab(:,68),[16,6,1,8],[nMW,nMW,0,0],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(13),m3h3x16(:,68),heltab2x48(:,:,68))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(69),h0tab(:,69),[16,6,1,8],[nMH,nMZ,0,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(14),m3h3x16(:,69),heltab2x48(:,:,69))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(70),h0tab(:,70),[16,6,1,8],[nMW,nMW,0,nMZ],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(15),m3h3x16(:,70),heltab2x48(:,:,70))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(71),h0tab(:,71),[16,6,1,8],[nMZ,nMZ,0,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(12),m3h3x16(:,71),heltab2x48(:,:,71))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(72),h0tab(:,72),[16,6,1,8],[nMW,nMW,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(13),m3h3x16(:,72),heltab2x48(:,:,72))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(73),h0tab(:,73),[16,6,1,8],[nMW,nMW,0,nMZ],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(14),m3h3x16(:,73),heltab2x48(:,:,73))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(74),h0tab(:,74),[16,6,1,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(16),m3h3x16(:,74),heltab2x48(:,:,74))
  call Hloop_Q_A(ntryL,G0H16(16),16,0,G1H16(15),n2h16(17))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(75),h0tab(:,75),[16,6,1,8],[0,0,nMZ,0],4,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(16),m3h3x16(:,75),heltab2x48(:,:,75))
  call Hloop_Q_A(ntryL,G0H16(16),16,0,G1H16(16),n2h16(18))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(76),h0tab(:,76),[16,6,1,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(16),m3h3x16(:,76),heltab2x48(:,:,76))
  call Hloop_Q_A(ntryL,G0H16(16),16,0,G1H16(17),n2h16(19))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(77),h0tab(:,77),[16,6,1,8],[0,0,nMZ,0],4,1,wf4(:,4))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(16),m3h3x16(:,77),heltab2x48(:,:,77))
  call Hloop_Q_A(ntryL,G0H16(16),16,0,G1H16(18),n2h16(20))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(78),h0tab(:,78),[16,6,1,8],[nMW,nMW,0,0],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(16),m3h3x16(:,78),heltab2x48(:,:,78))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(79),h0tab(:,79),[16,6,1,8],[nMW,nMW,0,nMZ],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(17),m3h3x16(:,79),heltab2x48(:,:,79))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(80),h0tab(:,80),[16,6,1,8],[nMW,nMW,0,0],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(18),m3h3x16(:,80),heltab2x48(:,:,80))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(81),h0tab(:,81),[16,6,1,8],[nMH,nMZ,0,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(19),m3h3x16(:,81),heltab2x48(:,:,81))
  Gcoeff(:)%j = (-(c(141)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(82),h0tab(:,82),[16,6,1,8],[nMW,nMW,0,nMZ],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(20),m3h3x16(:,82),heltab2x48(:,:,82))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(83),h0tab(:,83),[16,6,1,8],[nMW,nMW,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(19),m3h3x16(:,83),heltab2x48(:,:,83))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(84),h0tab(:,84),[16,6,1,8],[nMW,nMW,0,nMZ],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(20),m3h3x16(:,84),heltab2x48(:,:,84))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(85),h0tab(:,85),[16,6,1,8],[nMW,nMW,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(21),m3h3x16(:,85),heltab2x48(:,:,85))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(86),h0tab(:,86),[16,6,1,8],[nMW,nMW,0,nMZ],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(22),m3h3x16(:,86),heltab2x48(:,:,86))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(87),h0tab(:,87),[16,1,6,8],[0,nMZ,nMZ,0],4,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(21),m3h3x16(:,87),heltab2x48(:,:,87))
  call Hloop_Q_A(ntryL,G0H16(21),16,0,G1H16(23),n2h16(21))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(88),h0tab(:,88),[16,1,6,8],[0,0,0,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(24),m3h3x16(:,88),heltab2x48(:,:,88))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(89),h0tab(:,89),[16,1,6,8],[nMW,0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(25),m3h3x16(:,89),heltab2x48(:,:,89))
  Gcoeff(:)%j = (c(109)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(90),h0tab(:,90),[16,1,6,8],[nMZ,0,0,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(26),m3h3x16(:,90),heltab2x48(:,:,90))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(91),h0tab(:,91),[16,1,6,8],[nMW,0,0,nMZ],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(27),m3h3x16(:,91),heltab2x48(:,:,91))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(92),h0tab(:,92),[16,1,6,8],[0,0,0,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(28),m3h3x16(:,92),heltab2x48(:,:,92))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(93),h0tab(:,93),[16,1,6,8],[nMW,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(29),m3h3x16(:,93),heltab2x48(:,:,93))
  Gcoeff(:)%j = (c(111)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(94),h0tab(:,94),[16,1,6,8],[nMZ,0,0,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(30),m3h3x16(:,94),heltab2x48(:,:,94))
  Gcoeff(:)%j = (c(111)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(95),h0tab(:,95),[16,1,6,8],[nMW,0,0,nMZ],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(31),m3h3x16(:,95),heltab2x48(:,:,95))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(96),h0tab(:,96),[16,2,4,9],[nMB,nMW,nMB,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(21),m3h3x16(:,96),heltab2x48(:,:,96))
  call Hloop_A_Q(ntryL,G0H16(21),16,nMB,G1H16(32),n2h16(22))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(97),h0tab(:,97),[16,2,4,9],[nMH,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(33),m3h3x16(:,97),heltab2x48(:,:,97))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(98),h0tab(:,98),[16,2,4,9],[nMH,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(34),m3h3x16(:,98),heltab2x48(:,:,98))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(99),h0tab(:,99),[16,2,4,9],[nMZ,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(35),m3h3x16(:,99),heltab2x48(:,:,99))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(100),h0tab(:,100),[16,2,4,9],[nMZ,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(36),m3h3x16(:,100),heltab2x48(:,:,100))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(101),h0tab(:,101),[16,2,4,9],[nMB,nMW,nMB,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(21),m3h3x16(:,101),heltab2x48(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(21),16,nMB,G1H16(37),n2h16(23))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(102),h0tab(:,102),[16,2,4,9],[nMH,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(21),m3h3x16(:,102),heltab2x48(:,:,102))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(103),h0tab(:,103),[16,2,4,9],[nMH,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(38),m3h3x16(:,103),heltab2x48(:,:,103))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(104),h0tab(:,104),[16,2,4,9],[nMZ,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(39),m3h3x16(:,104),heltab2x48(:,:,104))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(105),h0tab(:,105),[16,2,4,9],[nMH,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(40),m3h3x16(:,105),heltab2x48(:,:,105))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(106),h0tab(:,106),[16,2,4,9],[nMZ,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(41),m3h3x16(:,106),heltab2x48(:,:,106))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(107),h0tab(:,107),[16,2,4,9],[0,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(22),m3h3x16(:,107),heltab2x48(:,:,107))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(108),h0tab(:,108),[16,2,4,9],[0,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(23),m3h3x16(:,108),heltab2x48(:,:,108))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(109),h0tab(:,109),[16,2,4,9],[nMZ,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(24),m3h3x16(:,109),heltab2x48(:,:,109))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(110),h0tab(:,110),[16,2,4,9],[nMZ,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(25),m3h3x16(:,110),heltab2x48(:,:,110))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(111),h0tab(:,111),[16,2,4,9],[nMH,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(26),m3h3x16(:,111),heltab2x48(:,:,111))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(112),h0tab(:,112),[16,2,4,9],[nMH,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(27),m3h3x16(:,112),heltab2x48(:,:,112))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(113),h0tab(:,113),[16,2,4,9],[0,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(42),m3h3x16(:,113),heltab2x48(:,:,113))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(114),h0tab(:,114),[16,2,4,9],[nMZ,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(43),m3h3x16(:,114),heltab2x48(:,:,114))
  Gcoeff(:)%j = (-(c(134)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(115),h0tab(:,115),[16,2,4,9],[0,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(28),m3h3x16(:,115),heltab2x48(:,:,115))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(116),h0tab(:,116),[16,2,4,9],[0,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(29),m3h3x16(:,116),heltab2x48(:,:,116))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(117),h0tab(:,117),[16,2,4,9],[nMZ,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(30),m3h3x16(:,117),heltab2x48(:,:,117))
  Gcoeff(:)%j = (-(c(141)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(118),h0tab(:,118),[16,2,4,9],[nMZ,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(31),m3h3x16(:,118),heltab2x48(:,:,118))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(119),h0tab(:,119),[16,2,4,9],[0,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(44),m3h3x16(:,119),heltab2x48(:,:,119))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(120),h0tab(:,120),[16,2,4,9],[0,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(45),m3h3x16(:,120),heltab2x48(:,:,120))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(121),h0tab(:,121),[16,2,4,9],[nMZ,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(46),m3h3x16(:,121),heltab2x48(:,:,121))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(122),h0tab(:,122),[16,2,4,9],[nMZ,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(47),m3h3x16(:,122),heltab2x48(:,:,122))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(123),h0tab(:,123),[16,4,2,9],[nMT,nMH,nMT,nMB],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(32),m3h3x16(:,123),heltab2x48(:,:,123))
  call Hloop_Q_A(ntryL,G0H16(32),16,nMT,G1H16(48),n2h16(24))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(124),h0tab(:,124),[16,4,2,9],[nMT,nMZ,nMT,nMB],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(32),m3h3x16(:,124),heltab2x48(:,:,124))
  call Hloop_Q_A(ntryL,G0H16(32),16,nMT,G1H16(49),n2h16(25))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(125),h0tab(:,125),[16,4,2,9],[nMH,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(50),m3h3x16(:,125),heltab2x48(:,:,125))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(126),h0tab(:,126),[16,4,2,9],[nMZ,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(51),m3h3x16(:,126),heltab2x48(:,:,126))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(127),h0tab(:,127),[16,4,2,9],[nMH,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(52),m3h3x16(:,127),heltab2x48(:,:,127))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(128),h0tab(:,128),[16,4,2,9],[nMZ,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(53),m3h3x16(:,128),heltab2x48(:,:,128))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(129),h0tab(:,129),[16,4,2,9],[nMW,nMB,nMW,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H48(1),0,ex5(:),16,G1H16(54),m3h3x16(:,129),heltab2x48(:,:,129))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(130),h0tab(:,130),[16,4,2,9],[nMW,nMB,nMW,nMZ],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H48(1),0,ex5(:),16,G1H16(55),m3h3x16(:,130),heltab2x48(:,:,130))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(131),h0tab(:,131),[16,4,2,9],[nMT,0,nMT,nMB],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(32),m3h3x16(:,131),heltab2x48(:,:,131))
  call Hloop_Q_A(ntryL,G0H16(32),16,nMT,G1H16(56),n2h16(26))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(132),h0tab(:,132),[16,4,2,9],[nMT,nMZ,nMT,nMB],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H48(1),ex5(:),G0H16(32),m3h3x16(:,132),heltab2x48(:,:,132))
  call Hloop_Q_A(ntryL,G0H16(32),16,nMT,G1H16(57),n2h16(27))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(133),h0tab(:,133),[16,4,2,9],[nMW,nMB,nMW,0],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(32),m3h3x16(:,133),heltab2x48(:,:,133))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(134),h0tab(:,134),[16,4,2,9],[nMW,nMB,nMW,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(33),m3h3x16(:,134),heltab2x48(:,:,134))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(135),h0tab(:,135),[16,4,2,9],[nMH,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(34),m3h3x16(:,135),heltab2x48(:,:,135))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(136),h0tab(:,136),[16,4,2,9],[0,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(35),m3h3x16(:,136),heltab2x48(:,:,136))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(137),h0tab(:,137),[16,4,2,9],[0,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(36),m3h3x16(:,137),heltab2x48(:,:,137))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(138),h0tab(:,138),[16,4,2,9],[nMZ,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(37),m3h3x16(:,138),heltab2x48(:,:,138))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(139),h0tab(:,139),[16,4,2,9],[nMZ,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(38),m3h3x16(:,139),heltab2x48(:,:,139))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(140),h0tab(:,140),[16,4,2,9],[nMW,nMB,nMW,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(39),m3h3x16(:,140),heltab2x48(:,:,140))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(141),h0tab(:,141),[16,4,2,9],[nMH,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(58),m3h3x16(:,141),heltab2x48(:,:,141))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(142),h0tab(:,142),[16,4,2,9],[nMZ,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(59),m3h3x16(:,142),heltab2x48(:,:,142))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(143),h0tab(:,143),[16,4,2,9],[nMH,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(60),m3h3x16(:,143),heltab2x48(:,:,143))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(144),h0tab(:,144),[16,4,2,9],[nMZ,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(61),m3h3x16(:,144),heltab2x48(:,:,144))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(145),h0tab(:,145),[16,4,2,9],[nMW,nMB,nMW,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H48(1),0,ex5(:),16,G1H16(62),m3h3x16(:,145),heltab2x48(:,:,145))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(146),h0tab(:,146),[16,4,2,9],[0,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(63),m3h3x16(:,146),heltab2x48(:,:,146))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(147),h0tab(:,147),[16,4,2,9],[nMW,nMB,nMW,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(64),m3h3x16(:,147),heltab2x48(:,:,147))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(148),h0tab(:,148),[16,4,2,9],[nMZ,nMT,nMH,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(65),m3h3x16(:,148),heltab2x48(:,:,148))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(149),h0tab(:,149),[16,4,2,9],[nMW,nMB,nMW,nMZ],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(66),m3h3x16(:,149),heltab2x48(:,:,149))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(150),h0tab(:,150),[16,4,2,9],[nMH,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(40),m3h3x16(:,150),heltab2x48(:,:,150))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(151),h0tab(:,151),[16,4,2,9],[nMW,nMB,nMW,0],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(41),m3h3x16(:,151),heltab2x48(:,:,151))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(152),h0tab(:,152),[16,4,2,9],[nMH,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(42),m3h3x16(:,152),heltab2x48(:,:,152))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(153),h0tab(:,153),[16,4,2,9],[nMW,nMB,nMW,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(43),m3h3x16(:,153),heltab2x48(:,:,153))
  Gcoeff(:)%j = (-(c(134)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(154),h0tab(:,154),[16,4,2,9],[0,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(44),m3h3x16(:,154),heltab2x48(:,:,154))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(155),h0tab(:,155),[16,4,2,9],[nMZ,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(45),m3h3x16(:,155),heltab2x48(:,:,155))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(156),h0tab(:,156),[16,4,2,9],[0,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(46),m3h3x16(:,156),heltab2x48(:,:,156))
  Gcoeff(:)%j = (-(c(141)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(157),h0tab(:,157),[16,4,2,9],[nMZ,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(47),m3h3x16(:,157),heltab2x48(:,:,157))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(158),h0tab(:,158),[16,4,2,9],[nMW,nMB,nMW,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(48),m3h3x16(:,158),heltab2x48(:,:,158))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(159),h0tab(:,159),[16,4,2,9],[0,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(67),m3h3x16(:,159),heltab2x48(:,:,159))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(160),h0tab(:,160),[16,4,2,9],[nMZ,nMT,0,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(68),m3h3x16(:,160),heltab2x48(:,:,160))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(161),h0tab(:,161),[16,4,2,9],[0,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(69),m3h3x16(:,161),heltab2x48(:,:,161))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(162),h0tab(:,162),[16,4,2,9],[nMZ,nMT,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(70),m3h3x16(:,162),heltab2x48(:,:,162))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(163),h0tab(:,163),[16,4,2,9],[nMW,nMB,nMW,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(71),m3h3x16(:,163),heltab2x48(:,:,163))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(164),h0tab(:,164),[16,4,2,9],[nMW,nMB,nMW,nMZ],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(72),m3h3x16(:,164),heltab2x48(:,:,164))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(165),h0tab(:,165),[16,2,9,4],[nMB,nMW,nMH,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(49),m3h3x16(:,165),heltab2x48(:,:,165))
  call Hloop_A_Q(ntryL,G0H16(49),16,nMB,G1H16(73),n2h16(28))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(166),h0tab(:,166),[16,2,9,4],[nMB,nMW,nMZ,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(49),m3h3x16(:,166),heltab2x48(:,:,166))
  call Hloop_A_Q(ntryL,G0H16(49),16,nMB,G1H16(74),n2h16(29))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(167),h0tab(:,167),[16,2,9,4],[nMH,nMT,nMB,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(75),m3h3x16(:,167),heltab2x48(:,:,167))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(168),h0tab(:,168),[16,2,9,4],[nMZ,nMT,nMB,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(76),m3h3x16(:,168),heltab2x48(:,:,168))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(169),h0tab(:,169),[16,2,9,4],[nMB,nMW,0,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(49),m3h3x16(:,169),heltab2x48(:,:,169))
  call Hloop_A_Q(ntryL,G0H16(49),16,nMB,G1H16(77),n2h16(30))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(170),h0tab(:,170),[16,2,9,4],[nMB,nMW,nMZ,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(49),m3h3x16(:,170),heltab2x48(:,:,170))
  call Hloop_A_Q(ntryL,G0H16(49),16,nMB,G1H16(78),n2h16(31))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(171),h0tab(:,171),[16,2,9,4],[nMB,nMW,nMH,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(49),m3h3x16(:,171),heltab2x48(:,:,171))
  call Hloop_A_Q(ntryL,G0H16(49),16,nMB,G1H16(79),n2h16(32))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(172),h0tab(:,172),[16,2,9,4],[nMH,nMT,nMB,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(49),m3h3x16(:,172),heltab2x48(:,:,172))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(173),h0tab(:,173),[16,2,9,4],[0,nMT,nMB,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(50),m3h3x16(:,173),heltab2x48(:,:,173))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(174),h0tab(:,174),[16,2,9,4],[nMZ,nMT,nMB,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(51),m3h3x16(:,174),heltab2x48(:,:,174))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(175),h0tab(:,175),[16,2,9,4],[nMB,nMW,0,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(52),m3h3x16(:,175),heltab2x48(:,:,175))
  call Hloop_A_Q(ntryL,G0H16(52),16,nMB,G1H16(80),n2h16(33))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(176),h0tab(:,176),[16,2,9,4],[nMB,nMW,nMZ,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(52),m3h3x16(:,176),heltab2x48(:,:,176))
  call Hloop_A_Q(ntryL,G0H16(52),16,nMB,G1H16(81),n2h16(34))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(177),h0tab(:,177),[16,2,9,4],[0,nMT,nMB,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(82),m3h3x16(:,177),heltab2x48(:,:,177))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(178),h0tab(:,178),[16,2,9,4],[nMZ,nMT,nMB,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(83),m3h3x16(:,178),heltab2x48(:,:,178))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(179),h0tab(:,179),[17,4,2,8],[0,nMT,0,0],4,1,wf6(:,2))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,2),G0H8(1),m3h6x8(:,1),heltab2x48(:,:,179))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(180),h0tab(:,180),[17,4,2,8],[nMZ,nMT,0,0],4,1,wf6(:,2))
  call Hloop_QA_Z(ntryL,G0H48(1),wf6(:,2),G0H8(2),ngZd,m3h6x8(:,2),heltab2x48(:,:,180))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(181),h0tab(:,181),[17,4,2,8],[0,nMT,nMZ,0],4,1,wf6(:,2))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,2),G0H8(3),m3h6x8(:,3),heltab2x48(:,:,181))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(182),h0tab(:,182),[17,4,2,8],[nMZ,nMT,nMZ,0],4,1,wf6(:,2))
  call Hloop_QA_Z(ntryL,G0H48(1),wf6(:,2),G0H8(4),ngZd,m3h6x8(:,4),heltab2x48(:,:,182))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(183),h0tab(:,183),[17,4,2,8],[nMW,nMB,nMW,0],4,1,wf6(:,2))
  call Hloop_QA_W(ntryL,G0H48(1),wf6(:,2),G0H8(5),m3h6x8(:,5),heltab2x48(:,:,183))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(184),h0tab(:,184),[17,2,4,8],[0,nMT,0,0],4,1,wf6(:,2))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,2),G0H8(6),m3h6x8(:,6),heltab2x48(:,:,184))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(185),h0tab(:,185),[17,2,4,8],[0,nMT,nMZ,0],4,1,wf6(:,2))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,2),G0H8(7),m3h6x8(:,7),heltab2x48(:,:,185))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(186),h0tab(:,186),[17,2,4,8],[nMZ,nMT,0,0],4,1,wf6(:,2))
  call Hloop_QA_Z(ntryL,G0H48(1),wf6(:,2),G0H8(8),ngZd,m3h6x8(:,8),heltab2x48(:,:,186))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(187),h0tab(:,187),[17,2,4,8],[nMZ,nMT,nMZ,0],4,1,wf6(:,2))
  call Hloop_QA_Z(ntryL,G0H48(1),wf6(:,2),G0H8(9),ngZd,m3h6x8(:,9),heltab2x48(:,:,187))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(188),h0tab(:,188),[20,2,1,8],[nMT,0,0,nMW],4,1,wf6(:,6))
  call Hloop_WA_Q(ntryL,G0H48(1),wf6(:,6),G0H8(10),m3h6x8(:,10),heltab2x48(:,:,188))
  call Hloop_A_Q(ntryL,G0H8(10),20,nMT,G1H8(25),n2h8(33))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(189),h0tab(:,189),[20,2,1,8],[nMB,nMW,0,0],4,1,wf6(:,6))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,6),G0H8(10),m3h6x8(:,11),heltab2x48(:,:,189))
  call Hloop_A_Q(ntryL,G0H8(10),20,nMB,G1H8(2),n2h8(34))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(190),h0tab(:,190),[20,2,1,8],[nMT,nMZ,0,nMW],4,1,wf6(:,6))
  call Hloop_WA_Q(ntryL,G0H48(1),wf6(:,6),G0H8(10),m3h6x8(:,12),heltab2x48(:,:,190))
  call Hloop_A_Q(ntryL,G0H8(10),20,nMT,G1H8(4),n2h8(35))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(191),h0tab(:,191),[20,2,1,8],[nMB,nMW,0,nMZ],4,1,wf6(:,6))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf6(:,6),G0H8(10),ngZd,m3h6x8(:,13),heltab2x48(:,:,191))
  call Hloop_A_Q(ntryL,G0H8(10),20,nMB,G1H8(1),n2h8(36))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(192),h0tab(:,192),[20,1,8,2],[0,0,nMW,nMB],4,1,wf6(:,6))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,6),G0H8(10),m3h6x8(:,14),heltab2x48(:,:,192))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(193),h0tab(:,193),[20,1,8,2],[nMW,0,0,nMT],4,1,wf6(:,6))
  call Hloop_QA_W(ntryL,G0H48(1),wf6(:,6),G0H8(11),m3h6x8(:,15),heltab2x48(:,:,193))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(194),h0tab(:,194),[20,1,8,2],[nMZ,0,nMW,nMB],4,1,wf6(:,6))
  call Hloop_QA_Z(ntryL,G0H48(1),wf6(:,6),G0H8(12),ngZd,m3h6x8(:,16),heltab2x48(:,:,194))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(195),h0tab(:,195),[20,1,8,2],[nMW,0,nMZ,nMT],4,1,wf6(:,6))
  call Hloop_QA_W(ntryL,G0H48(1),wf6(:,6),G0H8(13),m3h6x8(:,17),heltab2x48(:,:,195))
  Gcoeff(:)%j = (c(124)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(196),h0tab(:,196),[24,1,2,4],[0,0,nMT,0],4,1,wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,4),G0H8(14),m3h6x8(:,18),heltab2x48(:,:,196))
  call Hloop_Q_A(ntryL,G0H8(14),24,0,G1H8(3),n2h8(37))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(197),h0tab(:,197),[24,1,2,4],[0,0,nMT,nMZ],4,1,wf6(:,4))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf6(:,4),G0H8(14),ngZu,m3h6x8(:,19),heltab2x48(:,:,197))
  call Hloop_Q_A(ntryL,G0H8(14),24,0,G1H8(5),n2h8(38))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(198),h0tab(:,198),[24,1,2,4],[0,nMZ,nMT,0],4,1,wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,4),G0H8(14),m3h6x8(:,20),heltab2x48(:,:,198))
  call Hloop_Q_A(ntryL,G0H8(14),24,0,G1H8(6),n2h8(39))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(199),h0tab(:,199),[24,1,2,4],[0,nMZ,nMT,nMZ],4,1,wf6(:,4))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf6(:,4),G0H8(14),ngZu,m3h6x8(:,21),heltab2x48(:,:,199))
  call Hloop_Q_A(ntryL,G0H8(14),24,0,G1H8(7),n2h8(40))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(200),h0tab(:,200),[24,1,2,4],[0,nMW,nMB,nMW],4,1,wf6(:,4))
  call Hloop_WQ_A(ntryL,G0H48(1),wf6(:,4),G0H8(14),m3h6x8(:,22),heltab2x48(:,:,200))
  call Hloop_Q_A(ntryL,G0H8(14),24,0,G1H8(8),n2h8(41))
  Gcoeff(:)%j = (c(124)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(201),h0tab(:,201),[24,1,4,2],[0,0,nMT,0],4,1,wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,4),G0H8(14),m3h6x8(:,23),heltab2x48(:,:,201))
  call Hloop_Q_A(ntryL,G0H8(14),24,0,G1H8(9),n2h8(42))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(202),h0tab(:,202),[24,1,4,2],[0,0,nMT,nMZ],4,1,wf6(:,4))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf6(:,4),G0H8(14),ngZu,m3h6x8(:,24),heltab2x48(:,:,202))
  call Hloop_Q_A(ntryL,G0H8(14),24,0,G1H8(10),n2h8(43))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(203),h0tab(:,203),[24,1,4,2],[0,nMZ,nMT,0],4,1,wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,4),G0H8(14),m3h6x8(:,25),heltab2x48(:,:,203))
  call Hloop_Q_A(ntryL,G0H8(14),24,0,G1H8(11),n2h8(44))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(204),h0tab(:,204),[24,1,4,2],[0,nMZ,nMT,nMZ],4,1,wf6(:,4))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf6(:,4),G0H8(14),ngZu,m3h6x8(:,26),heltab2x48(:,:,204))
  call Hloop_Q_A(ntryL,G0H8(14),24,0,G1H8(12),n2h8(45))
  call Hloop_VA_Q(ntryL,G0H16(1),ex1(:),G0H8(14),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G0H8(14),17,0,G1H8(13),n2h8(46))
  call Hloop_ZA_Q(ntryL,G0H16(2),ex1(:),G0H8(14),ngZu,m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G0H8(14),17,0,G1H8(14),n2h8(47))
  call Hloop_VA_Q(ntryL,G0H16(3),ex1(:),G0H8(14),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G0H8(14),17,0,G1H8(15),n2h8(48))
  call Hloop_WA_Q(ntryL,G0H16(4),ex1(:),G0H8(14),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G0H8(14),17,0,G1H8(16),n2h8(49))
  call Hloop_ZA_Q(ntryL,G0H16(5),ex1(:),G0H8(14),ngZu,m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G0H8(14),17,0,G1H8(17),n2h8(50))
  call Hloop_WA_Q(ntryL,G1H16(1),ex1(:),G1H8(18),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(18),17,0,G2H8(5),n2h8(51))
  call Hloop_VA_Q(ntryL,G1H16(2),ex1(:),G1H8(19),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H8(19),17,0,G2H8(6),n2h8(52))
  call Hloop_ZA_Q(ntryL,G1H16(3),ex1(:),G1H8(20),ngZu,m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(20),17,0,G2H8(1),n2h8(53))
  call Hloop_QA_V(ntryL,G1H16(4),ex1(:),G1H8(21),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_QA_Z(ntryL,G1H16(5),ex1(:),G1H8(22),ngZu,m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_QA_V(ntryL,G1H16(6),ex1(:),G1H8(23),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_QA_Z(ntryL,G1H16(7),ex1(:),G1H8(24),ngZu,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_VA_Q(ntryL,G0H16(10),ex1(:),G0H8(14),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G0H8(14),17,0,G1H8(18),n2h8(54))
  call Hloop_ZA_Q(ntryL,G0H16(11),ex1(:),G0H8(14),ngZu,m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G0H8(14),17,0,G1H8(19),n2h8(55))
  call Hloop_VA_Q(ntryL,G0H16(12),ex1(:),G0H8(14),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G0H8(14),17,0,G1H8(20),n2h8(56))
  call Hloop_WA_Q(ntryL,G0H16(6),ex1(:),G0H8(14),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(14),17,0,G1H8(26),n2h8(57))
  call Hloop_ZA_Q(ntryL,G0H16(7),ex1(:),G0H8(14),ngZu,m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G0H8(14),17,0,G1H8(27),n2h8(58))
  call Hloop_VA_Q(ntryL,G1H16(8),ex1(:),G1H8(28),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(28),17,0,G2H8(2),n2h8(59))
  call Hloop_ZA_Q(ntryL,G1H16(9),ex1(:),G1H8(28),ngZu,m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(28),17,0,G2H8(3),n2h8(60))
  call Hloop_VA_Q(ntryL,G1H16(10),ex1(:),G1H8(28),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(28),17,0,G2H8(4),n2h8(61))
  call Hloop_ZA_Q(ntryL,G1H16(11),ex1(:),G1H8(28),ngZu,m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(28),17,0,G2H8(7),n2h8(62))
  call Hloop_ST_V(ntryL,G0H16(8),16,wf4(:,2),6,G1H4(1),m3h4x4(:,1),heltab2x16(:,:,66))
  call Hloop_ST_V(ntryL,G0H16(9),16,wf4(:,2),6,G1H4(11),m3h4x4(:,2),heltab2x16(:,:,67))
  call Hloop_ST_V(ntryL,G0H16(13),16,wf4(:,10),6,G1H4(14),m3h4x4(:,3),heltab2x16(:,:,68))
  call Hloop_TS_V(ntryL,G0H16(14),16,wf4(:,10),6,G1H4(15),m3h4x4(:,4),heltab2x16(:,:,69))
  call Hloop_ST_V(ntryL,G0H16(15),16,wf4(:,10),6,G1H4(2),m3h4x4(:,5),heltab2x16(:,:,70))
  call Hloop_VS_V(ntryL,G1H16(12),wf4(:,2),G1H4(16),m3h4x4(:,6),heltab2x16(:,:,71))
  call Hloop_VS_V(ntryL,G1H16(13),wf4(:,2),G1H4(19),m3h4x4(:,7),heltab2x16(:,:,72))
  call Hloop_VS_V(ntryL,G1H16(14),wf4(:,2),G1H4(20),m3h4x4(:,8),heltab2x16(:,:,73))
  call Hloop_QV_A(ntryL,G1H16(15),wf4(:,3),G1H4(21),m3h4x4(:,9),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(21),22,0,G2H4(1),n2h4(33))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,3),G1H4(22),m3h4x4(:,10),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(22),22,0,G2H4(2),n2h4(34))
  call Hloop_QZ_A(ntryL,G1H16(17),wf4(:,4),G1H4(25),ngZu,m3h4x4(:,11),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(25),22,0,G2H4(3),n2h4(35))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,4),G1H4(26),ngZu,m3h4x4(:,12),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(26),22,0,G2H4(4),n2h4(36))
  call Hloop_SV_V(ntryL,G0H16(16),wf4(:,3),G0H4(1),m3h4x4(:,13),heltab2x16(:,:,78))
  call Hloop_SV_V(ntryL,G0H16(17),wf4(:,3),G0H4(2),m3h4x4(:,14),heltab2x16(:,:,79))
  call Hloop_SV_V(ntryL,G0H16(18),wf4(:,4),G0H4(3),m3h4x4(:,15),heltab2x16(:,:,80))
  call Hloop_SV_V(ntryL,G0H16(19),wf4(:,4),G0H4(4),m3h4x4(:,16),heltab2x16(:,:,81))
  call Hloop_SV_V(ntryL,G0H16(20),wf4(:,4),G0H4(5),m3h4x4(:,17),heltab2x16(:,:,82))
  call Hloop_UW_V(ntryL,G1H16(19),16,wf4(:,3),6,G2H4(5),m3h4x4(:,18),heltab2x16(:,:,83))
  call Hloop_UW_V(ntryL,G1H16(20),16,wf4(:,3),6,G2H4(6),m3h4x4(:,19),heltab2x16(:,:,84))
  call Hloop_UW_V(ntryL,G1H16(21),16,wf4(:,4),6,G2H4(7),m3h4x4(:,20),heltab2x16(:,:,85))
  call Hloop_UW_V(ntryL,G1H16(22),16,wf4(:,4),6,G2H4(8),m3h4x4(:,21),heltab2x16(:,:,86))
  call Hloop_QA_Z(ntryL,G1H16(23),ex1(:),G1H8(28),ngZu,m3h2x8(:,66),heltab2x16(:,:,87))
  call Hloop_VA_Q(ntryL,G1H16(24),ex1(:),G1H8(29),m3h2x8(:,67),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(29),17,0,G2H8(8),n2h8(63))
  call Hloop_WA_Q(ntryL,G1H16(25),ex1(:),G1H8(29),m3h2x8(:,68),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(29),17,0,G2H8(9),n2h8(64))
  call Hloop_ZA_Q(ntryL,G1H16(26),ex1(:),G1H8(29),ngZu,m3h2x8(:,69),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(29),17,0,G2H8(10),n2h8(65))
  call Hloop_WA_Q(ntryL,G1H16(27),ex1(:),G1H8(29),m3h2x8(:,70),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(29),17,0,G2H8(11),n2h8(66))
  call Hloop_VA_Q(ntryL,G1H16(28),ex1(:),G1H8(29),m3h2x8(:,71),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(29),17,0,G2H8(12),n2h8(67))
  call Hloop_WA_Q(ntryL,G1H16(29),ex1(:),G1H8(29),m3h2x8(:,72),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(29),17,0,G2H8(13),n2h8(68))
  call Hloop_ZA_Q(ntryL,G1H16(30),ex1(:),G1H8(29),ngZu,m3h2x8(:,73),heltab2x16(:,:,94))
  call Hloop_A_Q(ntryL,G1H8(29),17,0,G2H8(14),n2h8(69))
  call Hloop_WA_Q(ntryL,G1H16(31),ex1(:),G1H8(29),m3h2x8(:,74),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H8(29),17,0,G2H8(15),n2h8(70))
  call Hloop_AQ_S(ntryL,G1H16(32),ex2(:),G1H8(29),ngPbt,m3h2x8(:,75),heltab2x16(:,:,96))
  call Hloop_SQ_A(ntryL,G1H16(33),ex2(:),G1H8(30),ngH,m3h2x8(:,76),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(30),18,nMT,G2H8(16),n2h8(71))
  call Hloop_SQ_A(ntryL,G1H16(34),ex2(:),G1H8(30),ngH,m3h2x8(:,77),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(30),18,nMT,G2H8(17),n2h8(72))
  call Hloop_SQ_A(ntryL,G1H16(35),ex2(:),G1H8(30),ngX,m3h2x8(:,78),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(30),18,nMT,G2H8(18),n2h8(73))
  call Hloop_SQ_A(ntryL,G1H16(36),ex2(:),G1H8(30),ngX,m3h2x8(:,79),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(30),18,nMT,G2H8(19),n2h8(74))
  call Hloop_AQ_W(ntryL,G1H16(37),ex2(:),G1H8(30),m3h2x8(:,80),heltab2x16(:,:,101))
  call Hloop_SQ_A(ntryL,G0H16(21),ex2(:),G0H8(14),ngH,m3h2x8(:,81),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(31),n2h8(75))
  call Hloop_SQ_A(ntryL,G1H16(38),ex2(:),G1H8(32),ngH,m3h2x8(:,82),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(32),18,nMT,G2H8(20),n2h8(76))
  call Hloop_SQ_A(ntryL,G1H16(39),ex2(:),G1H8(32),ngX,m3h2x8(:,83),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(32),18,nMT,G2H8(21),n2h8(77))
  call Hloop_SQ_A(ntryL,G1H16(40),ex2(:),G1H8(32),ngH,m3h2x8(:,84),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(32),18,nMT,G2H8(22),n2h8(78))
  call Hloop_SQ_A(ntryL,G1H16(41),ex2(:),G1H8(32),ngX,m3h2x8(:,85),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H8(32),18,nMT,G2H8(23),n2h8(79))
  call Hloop_VQ_A(ntryL,G0H16(22),ex2(:),G0H8(14),m3h2x8(:,86),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(32),n2h8(80))
  call Hloop_VQ_A(ntryL,G0H16(23),ex2(:),G0H8(14),m3h2x8(:,87),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(33),n2h8(81))
  call Hloop_ZQ_A(ntryL,G0H16(24),ex2(:),G0H8(14),ngZu,m3h2x8(:,88),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(34),n2h8(82))
  call Hloop_ZQ_A(ntryL,G0H16(25),ex2(:),G0H8(14),ngZu,m3h2x8(:,89),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(35),n2h8(83))
  call Hloop_SQ_A(ntryL,G0H16(26),ex2(:),G0H8(14),ngH,m3h2x8(:,90),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(36),n2h8(84))
  call Hloop_SQ_A(ntryL,G0H16(27),ex2(:),G0H8(14),ngH,m3h2x8(:,91),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(37),n2h8(85))
  call Hloop_VQ_A(ntryL,G1H16(42),ex2(:),G1H8(38),m3h2x8(:,92),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(38),18,nMT,G2H8(24),n2h8(86))
  call Hloop_ZQ_A(ntryL,G1H16(43),ex2(:),G1H8(38),ngZu,m3h2x8(:,93),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G1H8(38),18,nMT,G2H8(25),n2h8(87))
  call Hloop_VQ_A(ntryL,G0H16(28),ex2(:),G0H8(14),m3h2x8(:,94),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(38),n2h8(88))
  call Hloop_VQ_A(ntryL,G0H16(29),ex2(:),G0H8(14),m3h2x8(:,95),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(39),n2h8(89))
  call Hloop_ZQ_A(ntryL,G0H16(30),ex2(:),G0H8(14),ngZu,m3h2x8(:,96),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(40),n2h8(90))
  call Hloop_ZQ_A(ntryL,G0H16(31),ex2(:),G0H8(14),ngZu,m3h2x8(:,97),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(41),n2h8(91))
  call Hloop_VQ_A(ntryL,G1H16(44),ex2(:),G1H8(42),m3h2x8(:,98),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H8(42),18,nMT,G2H8(26),n2h8(92))
  call Hloop_VQ_A(ntryL,G1H16(45),ex2(:),G1H8(42),m3h2x8(:,99),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(42),18,nMT,G2H8(27),n2h8(93))
  call Hloop_ZQ_A(ntryL,G1H16(46),ex2(:),G1H8(42),ngZu,m3h2x8(:,100),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G1H8(42),18,nMT,G2H8(28),n2h8(94))
  call Hloop_ZQ_A(ntryL,G1H16(47),ex2(:),G1H8(42),ngZu,m3h2x8(:,101),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G1H8(42),18,nMT,G2H8(29),n2h8(95))
  call Hloop_QA_S(ntryL,G1H16(48),ex3(:),G1H8(42),ngH,m3h2x8(:,102),heltab2x16(:,:,123))
  call Hloop_QA_S(ntryL,G1H16(49),ex3(:),G1H8(43),ngX,m3h2x8(:,103),heltab2x16(:,:,124))
  call Hloop_SA_Q(ntryL,G1H16(50),ex3(:),G1H8(44),ngH,m3h2x8(:,104),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(44),20,nMT,G2H8(30),n2h8(96))
  call Hloop_SA_Q(ntryL,G1H16(51),ex3(:),G1H8(44),ngX,m3h2x8(:,105),heltab2x16(:,:,126))
  call Hloop_A_Q(ntryL,G1H8(44),20,nMT,G2H8(31),n2h8(97))
  call Hloop_SA_Q(ntryL,G1H16(52),ex3(:),G1H8(44),ngH,m3h2x8(:,106),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G1H8(44),20,nMT,G2H8(32),n2h8(98))
  call Hloop_SA_Q(ntryL,G1H16(53),ex3(:),G1H8(44),ngX,m3h2x8(:,107),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(44),20,nMT,G2H8(33),n2h8(99))
  call Hloop_SA_Q(ntryL,G1H16(54),ex3(:),G1H8(44),ngPtb,m3h2x8(:,108),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G1H8(44),20,nMB,G2H8(34),n2h8(100))
  call Hloop_SA_Q(ntryL,G1H16(55),ex3(:),G1H8(44),ngPtb,m3h2x8(:,109),heltab2x16(:,:,130))
  call Hloop_A_Q(ntryL,G1H8(44),20,nMB,G2H8(35),n2h8(101))
  call Hloop_QA_V(ntryL,G1H16(56),ex3(:),G1H8(44),m3h2x8(:,110),heltab2x16(:,:,131))
  call Hloop_QA_Z(ntryL,G1H16(57),ex3(:),G1H8(45),ngZu,m3h2x8(:,111),heltab2x16(:,:,132))
  call Hloop_SA_Q(ntryL,G0H16(32),ex3(:),G0H8(14),ngPtb,m3h2x8(:,112),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMB,G1H8(46),n2h8(102))
  call Hloop_SA_Q(ntryL,G0H16(33),ex3(:),G0H8(14),ngPtb,m3h2x8(:,113),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMB,G1H8(47),n2h8(103))
  call Hloop_SA_Q(ntryL,G0H16(34),ex3(:),G0H8(14),ngH,m3h2x8(:,114),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(48),n2h8(104))
  call Hloop_VA_Q(ntryL,G0H16(35),ex3(:),G0H8(14),m3h2x8(:,115),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(49),n2h8(105))
  call Hloop_VA_Q(ntryL,G0H16(36),ex3(:),G0H8(14),m3h2x8(:,116),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(50),n2h8(106))
  call Hloop_ZA_Q(ntryL,G0H16(37),ex3(:),G0H8(14),ngZu,m3h2x8(:,117),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(51),n2h8(107))
  call Hloop_ZA_Q(ntryL,G0H16(38),ex3(:),G0H8(14),ngZu,m3h2x8(:,118),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(52),n2h8(108))
  call Hloop_WA_Q(ntryL,G0H16(39),ex3(:),G0H8(14),m3h2x8(:,119),heltab2x16(:,:,140))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMB,G1H8(53),n2h8(109))
  call Hloop_SA_Q(ntryL,G1H16(58),ex3(:),G1H8(54),ngH,m3h2x8(:,120),heltab2x16(:,:,141))
  call Hloop_A_Q(ntryL,G1H8(54),20,nMT,G2H8(36),n2h8(110))
  call Hloop_SA_Q(ntryL,G1H16(59),ex3(:),G1H8(54),ngX,m3h2x8(:,121),heltab2x16(:,:,142))
  call Hloop_A_Q(ntryL,G1H8(54),20,nMT,G2H8(37),n2h8(111))
  call Hloop_SA_Q(ntryL,G1H16(60),ex3(:),G1H8(54),ngH,m3h2x8(:,122),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G1H8(54),20,nMT,G2H8(38),n2h8(112))
  call Hloop_SA_Q(ntryL,G1H16(61),ex3(:),G1H8(54),ngX,m3h2x8(:,123),heltab2x16(:,:,144))
  call Hloop_A_Q(ntryL,G1H8(54),20,nMT,G2H8(39),n2h8(113))
  call Hloop_SA_Q(ntryL,G1H16(62),ex3(:),G1H8(54),ngPtb,m3h2x8(:,124),heltab2x16(:,:,145))
  call Hloop_A_Q(ntryL,G1H8(54),20,nMB,G2H8(40),n2h8(114))
  call Hloop_VA_Q(ntryL,G1H16(63),ex3(:),G1H8(54),m3h2x8(:,125),heltab2x16(:,:,146))
  call Hloop_A_Q(ntryL,G1H8(54),20,nMT,G2H8(41),n2h8(115))
  call Hloop_WA_Q(ntryL,G1H16(64),ex3(:),G1H8(54),m3h2x8(:,126),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H8(54),20,nMB,G2H8(42),n2h8(116))
  call Hloop_ZA_Q(ntryL,G1H16(65),ex3(:),G1H8(54),ngZu,m3h2x8(:,127),heltab2x16(:,:,148))
  call Hloop_A_Q(ntryL,G1H8(54),20,nMT,G2H8(43),n2h8(117))
  call Hloop_WA_Q(ntryL,G1H16(66),ex3(:),G1H8(54),m3h2x8(:,128),heltab2x16(:,:,149))
  call Hloop_A_Q(ntryL,G1H8(54),20,nMB,G2H8(44),n2h8(118))
  call Hloop_SA_Q(ntryL,G0H16(40),ex3(:),G0H8(14),ngH,m3h2x8(:,129),heltab2x16(:,:,150))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(54),n2h8(119))
  call Hloop_SA_Q(ntryL,G0H16(41),ex3(:),G0H8(14),ngPtb,m3h2x8(:,130),heltab2x16(:,:,151))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMB,G1H8(55),n2h8(120))
  call Hloop_SA_Q(ntryL,G0H16(42),ex3(:),G0H8(14),ngH,m3h2x8(:,131),heltab2x16(:,:,152))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(56),n2h8(121))
  call Hloop_SA_Q(ntryL,G0H16(43),ex3(:),G0H8(14),ngPtb,m3h2x8(:,132),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMB,G1H8(57),n2h8(122))
  call Hloop_VA_Q(ntryL,G0H16(44),ex3(:),G0H8(14),m3h2x8(:,133),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(58),n2h8(123))
  call Hloop_ZA_Q(ntryL,G0H16(45),ex3(:),G0H8(14),ngZu,m3h2x8(:,134),heltab2x16(:,:,155))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(59),n2h8(124))
  call Hloop_VA_Q(ntryL,G0H16(46),ex3(:),G0H8(14),m3h2x8(:,135),heltab2x16(:,:,156))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(60),n2h8(125))
  call Hloop_ZA_Q(ntryL,G0H16(47),ex3(:),G0H8(14),ngZu,m3h2x8(:,136),heltab2x16(:,:,157))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(61),n2h8(126))
  call Hloop_WA_Q(ntryL,G0H16(48),ex3(:),G0H8(14),m3h2x8(:,137),heltab2x16(:,:,158))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMB,G1H8(62),n2h8(127))
  call Hloop_VA_Q(ntryL,G1H16(67),ex3(:),G1H8(63),m3h2x8(:,138),heltab2x16(:,:,159))
  call Hloop_A_Q(ntryL,G1H8(63),20,nMT,G2H8(45),n2h8(128))
  call Hloop_ZA_Q(ntryL,G1H16(68),ex3(:),G1H8(63),ngZu,m3h2x8(:,139),heltab2x16(:,:,160))
  call Hloop_A_Q(ntryL,G1H8(63),20,nMT,G2H8(46),n2h8(129))
  call Hloop_VA_Q(ntryL,G1H16(69),ex3(:),G1H8(63),m3h2x8(:,140),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G1H8(63),20,nMT,G2H8(47),n2h8(130))
  call Hloop_ZA_Q(ntryL,G1H16(70),ex3(:),G1H8(63),ngZu,m3h2x8(:,141),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G1H8(63),20,nMT,G2H8(48),n2h8(131))
  call Hloop_WA_Q(ntryL,G1H16(71),ex3(:),G1H8(63),m3h2x8(:,142),heltab2x16(:,:,163))
  call Hloop_A_Q(ntryL,G1H8(63),20,nMB,G2H8(49),n2h8(132))
  call Hloop_WA_Q(ntryL,G1H16(72),ex3(:),G1H8(63),m3h2x8(:,143),heltab2x16(:,:,164))
  call Hloop_A_Q(ntryL,G1H8(63),20,nMB,G2H8(50),n2h8(133))
  call Hloop_AQ_S(ntryL,G1H16(73),ex2(:),G1H8(63),ngPbt,m3h2x8(:,144),heltab2x16(:,:,165))
  call Hloop_AQ_S(ntryL,G1H16(74),ex2(:),G1H8(64),ngPbt,m3h2x8(:,145),heltab2x16(:,:,166))
  call Hloop_SQ_A(ntryL,G1H16(75),ex2(:),G1H8(65),ngH,m3h2x8(:,146),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G1H8(65),18,nMT,G2H8(51),n2h8(134))
  call Hloop_SQ_A(ntryL,G1H16(76),ex2(:),G1H8(65),ngX,m3h2x8(:,147),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H8(65),18,nMT,G2H8(52),n2h8(135))
  call Hloop_AQ_S(ntryL,G1H16(77),ex2(:),G1H8(65),ngPbt,m3h2x8(:,148),heltab2x16(:,:,169))
  call Hloop_AQ_S(ntryL,G1H16(78),ex2(:),G1H8(66),ngPbt,m3h2x8(:,149),heltab2x16(:,:,170))
  call Hloop_AQ_W(ntryL,G1H16(79),ex2(:),G1H8(67),m3h2x8(:,150),heltab2x16(:,:,171))
  call Hloop_SQ_A(ntryL,G0H16(49),ex2(:),G0H8(14),ngH,m3h2x8(:,151),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(68),n2h8(136))
  call Hloop_VQ_A(ntryL,G0H16(50),ex2(:),G0H8(14),m3h2x8(:,152),heltab2x16(:,:,173))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(69),n2h8(137))
  call Hloop_ZQ_A(ntryL,G0H16(51),ex2(:),G0H8(14),ngZu,m3h2x8(:,153),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G0H8(14),18,nMT,G1H8(70),n2h8(138))
  call Hloop_AQ_W(ntryL,G1H16(80),ex2(:),G1H8(71),m3h2x8(:,154),heltab2x16(:,:,175))
  call Hloop_AQ_W(ntryL,G1H16(81),ex2(:),G1H8(72),m3h2x8(:,155),heltab2x16(:,:,176))
  call Hloop_VQ_A(ntryL,G1H16(82),ex2(:),G1H8(73),m3h2x8(:,156),heltab2x16(:,:,177))
  call Hloop_Q_A(ntryL,G1H8(73),18,nMT,G2H8(53),n2h8(139))
  call Hloop_ZQ_A(ntryL,G1H16(83),ex2(:),G1H8(73),ngZu,m3h2x8(:,157),heltab2x16(:,:,178))
  call Hloop_Q_A(ntryL,G1H8(73),18,nMT,G2H8(54),n2h8(140))
  call Hloop_VA_Q(ntryL,G0H8(1),ex3(:),G0H4(6),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(6),21,nMT,G1H4(27),n2h4(37))
  call Hloop_ZA_Q(ntryL,G0H8(2),ex3(:),G0H4(6),ngZu,m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G0H4(6),21,nMT,G1H4(28),n2h4(38))
  call Hloop_VA_Q(ntryL,G0H8(3),ex3(:),G0H4(6),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G0H4(6),21,nMT,G1H4(31),n2h4(39))
  call Hloop_ZA_Q(ntryL,G0H8(4),ex3(:),G0H4(6),ngZu,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G0H4(6),21,nMT,G1H4(32),n2h4(40))
  call Hloop_WA_Q(ntryL,G0H8(5),ex3(:),G0H4(6),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G0H4(6),21,nMB,G1H4(33),n2h4(41))
  call Hloop_VQ_A(ntryL,G0H8(6),ex2(:),G0H4(6),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G0H4(6),19,nMT,G1H4(34),n2h4(42))
  call Hloop_VQ_A(ntryL,G0H8(7),ex2(:),G0H4(6),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G0H4(6),19,nMT,G1H4(37),n2h4(43))
  call Hloop_ZQ_A(ntryL,G0H8(8),ex2(:),G0H4(6),ngZu,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G0H4(6),19,nMT,G1H4(38),n2h4(44))
  call Hloop_ZQ_A(ntryL,G0H8(9),ex2(:),G0H4(6),ngZu,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G0H4(6),19,nMT,G1H4(39),n2h4(45))
  call Hloop_AQ_V(ntryL,G1H8(25),ex2(:),G1H4(40),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_AQ_W(ntryL,G1H8(2),ex2(:),G1H4(43),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_AQ_Z(ntryL,G1H8(4),ex2(:),G1H4(44),ngZu,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_AQ_W(ntryL,G1H8(1),ex2(:),G1H4(3),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_VA_Q(ntryL,G0H8(10),ex1(:),G0H4(6),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G0H4(6),21,0,G1H4(4),n2h4(46))
  call Hloop_WA_Q(ntryL,G0H8(11),ex1(:),G0H4(6),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G0H4(6),21,0,G1H4(47),n2h4(47))
  call Hloop_ZA_Q(ntryL,G0H8(12),ex1(:),G0H4(6),ngZu,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G0H4(6),21,0,G1H4(48),n2h4(48))
  call Hloop_WA_Q(ntryL,G0H8(13),ex1(:),G0H4(6),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G0H4(6),21,0,G1H4(49),n2h4(49))
  call Hloop_QA_V(ntryL,G1H8(3),ex1(:),G1H4(50),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QA_V(ntryL,G1H8(5),ex1(:),G1H4(53),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_QA_Z(ntryL,G1H8(6),ex1(:),G1H4(54),ngZu,m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_QA_Z(ntryL,G1H8(7),ex1(:),G1H4(55),ngZu,m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_QA_W(ntryL,G1H8(8),ex1(:),G1H4(56),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_QA_V(ntryL,G1H8(9),ex1(:),G1H4(59),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_QA_V(ntryL,G1H8(10),ex1(:),G1H4(60),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_QA_Z(ntryL,G1H8(11),ex1(:),G1H4(61),ngZu,m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_QA_Z(ntryL,G1H8(12),ex1(:),G1H4(62),ngZu,m3h2x4(:,68),heltab2x8(:,:,68))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(5),G1H4(19),G1H4(14),G1H4(1),G1H4(13),G0H4(3) &
    ,G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(6),G1H4(20),G1H4(2),G1H4(11),G1H4(18),G0H4(5) &
    ,G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(29),G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(41),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(64),G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(33),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(34),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(44),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G1H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G1H8(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G1H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(50),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(52),[G1H8(70)])
  call Hloop_WA_Q(ntryL,G1H4(43),ex1(:),G1H2(21),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(21),23,0,G2H2(1),n2h2(71))
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(2),mass4set(:,1),  & 
G1H4(65),G1H4(66),G1H4(5),G1H4(6),G1H4(67),4)
  call HG1shiftOLR(G1H4(66),8,4)
  call Hloop_WA_Q(ntryL,G1H4(3),ex1(:),G1H2(22),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(22),23,0,G2H2(2),n2h2(72))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(2),mass4set(:,2),  & 
G1H4(68),G1H4(69),G1H4(70),G1H4(73),G1H4(74),4)
  call HG1shiftOLR(G1H4(69),8,4)
  call Hloop_VA_Q(ntryL,G1H4(40),ex1(:),G1H2(26),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(26),23,0,G2H2(3),n2h2(73))
  call Hloop_VA_Q(ntryL,G1H4(46),ex1(:),G1H2(27),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(27),23,0,G2H2(4),n2h2(74))
  call Hloop_VA_Q(ntryL,G1H4(52),ex1(:),G1H2(28),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(28),23,0,G2H2(5),n2h2(75))
  call Hloop_ZA_Q(ntryL,G1H4(44),ex1(:),G1H2(32),ngZu,m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(32),23,0,G2H2(6),n2h2(76))
  call Hloop_ZA_Q(ntryL,G1H4(58),ex1(:),G1H2(33),ngZu,m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(33),23,0,G2H2(7),n2h2(77))
  call Hloop_ZA_Q(ntryL,G1H4(16),ex1(:),G1H2(34),ngZu,m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(34),23,0,G2H2(8),n2h2(78))
  call Hloop_VA_Q(ntryL,G1H4(51),ex1(:),G1H2(38),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(38),23,0,G2H2(9),n2h2(79))
  call Hloop_ZA_Q(ntryL,G1H4(63),ex1(:),G1H2(39),ngZu,m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(39),23,0,G2H2(10),n2h2(80))
  call Hloop_VQ_A(ntryL,G1H4(7),ex2(:),G1H2(40),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(40),27,nMT,G2H2(11),n2h2(81))
  call Hloop_VQ_A(ntryL,G1H4(8),ex2(:),G1H2(44),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(44),27,nMT,G2H2(12),n2h2(82))
  call Hloop_VQ_A(ntryL,G1H4(71),ex2(:),G1H2(45),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(45),27,nMT,G2H2(13),n2h2(83))
  call Hloop_VQ_A(ntryL,G1H4(72),ex2(:),G1H2(46),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(46),27,nMT,G2H2(14),n2h2(84))
  call Hloop_ZQ_A(ntryL,G1H4(77),ex2(:),G1H2(50),ngZu,m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(50),27,nMT,G2H2(15),n2h2(85))
  call Hloop_ZQ_A(ntryL,G1H4(78),ex2(:),G1H2(51),ngZu,m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(51),27,nMT,G2H2(16),n2h2(86))
  call Hloop_ZQ_A(ntryL,G1H4(83),ex2(:),G1H2(52),ngZu,m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(52),27,nMT,G2H2(17),n2h2(87))
  call Hloop_ZQ_A(ntryL,G1H4(84),ex2(:),G1H2(56),ngZu,m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(56),27,nMT,G2H2(18),n2h2(88))
  call Hloop_WQ_A(ntryL,G1H4(95),ex2(:),G1H2(57),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(57),27,nMB,G2H2(19),n2h2(89))
  call Hloop_WQ_A(ntryL,G1H4(90),ex2(:),G1H2(58),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(58),27,nMB,G2H2(20),n2h2(90))
  call Hloop_WQ_A(ntryL,G1H4(96),ex2(:),G1H2(62),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(62),27,nMB,G2H2(21),n2h2(91))
  call Hloop_VA_Q(ntryL,G1H4(99),ex3(:),G1H2(63),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(63),29,nMT,G2H2(22),n2h2(92))
  call Hloop_VA_Q(ntryL,G1H4(100),ex3(:),G1H2(64),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(64),29,nMT,G2H2(23),n2h2(93))
  call Hloop_ZA_Q(ntryL,G1H4(105),ex3(:),G1H2(68),ngZu,m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(68),29,nMT,G2H2(25),n2h2(94))
  call Hloop_ZA_Q(ntryL,G1H4(106),ex3(:),G1H2(69),ngZu,m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(69),29,nMT,G2H2(26),n2h2(95))
  call Hloop_VA_Q(ntryL,G1H4(111),ex3(:),G1H2(70),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(70),29,nMT,G2H2(28),n2h2(96))
  call Hloop_VA_Q(ntryL,G1H4(112),ex3(:),G1H2(74),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(74),29,nMT,G2H2(29),n2h2(97))
  call Hloop_ZA_Q(ntryL,G1H4(117),ex3(:),G1H2(75),ngZu,m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_A_Q(ntryL,G1H2(75),29,nMT,G2H2(31),n2h2(98))
  call Hloop_ZA_Q(ntryL,G1H4(118),ex3(:),G1H2(76),ngZu,m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(76),29,nMT,G2H2(32),n2h2(99))
  call Hloop_AQ_W(ntryL,G1H8(13),ex4(:),G1H4(75),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_AQ_W(ntryL,G1H8(14),ex4(:),G1H4(76),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_AQ_W(ntryL,G1H8(15),ex4(:),G1H4(79),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_AQ_Z(ntryL,G1H8(16),ex4(:),G1H4(80),ngZd,m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_AQ_W(ntryL,G1H8(17),ex4(:),G1H4(81),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex4(:),G2H4(9),ngZd,m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_AQ_W(ntryL,G2H8(6),ex4(:),G2H4(10),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_AQ_W(ntryL,G2H8(1),ex4(:),G2H4(11),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_VQ_A(ntryL,G1H8(21),ex4(:),G1H4(82),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(82),25,0,G2H4(12),n2h4(50))
  call Hloop_ZQ_A(ntryL,G1H8(22),ex4(:),G1H4(85),ngZd,m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(85),25,0,G2H4(13),n2h4(51))
  call Hloop_VQ_A(ntryL,G1H8(23),ex4(:),G1H4(86),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(86),25,0,G2H4(14),n2h4(52))
  call Hloop_ZQ_A(ntryL,G1H8(24),ex4(:),G1H4(87),ngZd,m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(87),25,0,G2H4(15),n2h4(53))
  call Hloop_AQ_W(ntryL,G1H8(18),ex4(:),G1H4(88),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_AQ_W(ntryL,G1H8(19),ex4(:),G1H4(91),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_AQ_W(ntryL,G1H8(20),ex4(:),G1H4(92),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_AQ_Z(ntryL,G1H8(26),ex4(:),G1H4(93),ngZd,m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_AQ_W(ntryL,G1H8(27),ex4(:),G1H4(94),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_AQ_W(ntryL,G2H8(2),ex4(:),G2H4(16),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_AQ_W(ntryL,G2H8(3),ex4(:),G2H4(17),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_AQ_W(ntryL,G2H8(4),ex4(:),G2H4(18),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_AQ_W(ntryL,G2H8(7),ex4(:),G2H4(19),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_ZA_Q(ntryL,G1H4(15),ex1(:),G1H2(80),ngZu,m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(80),23,0,G2H2(34),n2h2(100))
  call Hloop_QA_V(ntryL,G2H4(3),ex1(:),G2H2(35),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_QA_Z(ntryL,G2H4(4),ex1(:),G2H2(37),ngZu,m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_VS_V(ntryL,G1H8(28),wf4(:,2),G1H2(81),m3h4x2(:,1),heltab2x8(:,:,90))
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(26),mass4set(:,3),  & 
G1H8(73),G1H8(25),G1H8(2),G1H8(4),G1H8(1),8)
  call HG1shiftOLR(G1H8(25),8,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(26),mass4set(:,4),  & 
G1H8(3),G1H8(5),G1H8(6),G1H8(7),G1H8(8),8)
  call HG1shiftOLR(G1H8(5),8,8)
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(26),mass4set(:,5),  & 
G1H8(9),G1H8(10),G1H8(11),G1H8(12),G1H8(34),8)
  call HG1shiftOLR(G1H8(10),8,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(26),mass4set(:,6),  & 
G1H8(35),G1H8(40),G1H8(41),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(40),8,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(26),mass4set(:,3),  & 
G1H8(53),G1H8(46),G1H8(47),G1H8(59),G1H8(61),8)
  call HG1shiftOLR(G1H8(46),8,8)
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(26),mass4set(:,4),  & 
G1H8(62),G1H8(55),G1H8(57),G1H8(70),G1H8(13),8)
  call HG1shiftOLR(G1H8(55),8,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(26),mass4set(:,5),  & 
G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(21),8)
  call HG1shiftOLR(G1H8(15),8,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(26),mass4set(:,6),  & 
G1H8(22),G1H8(23),G1H8(24),G1H8(18),G1H8(19),8)
  call HG1shiftOLR(G1H8(23),8,8)
  call Hloop_SA_Q(ntryL,G1H8(29),ex3(:),G1H4(97),ngPtb,m3h2x4(:,90),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(97),22,nMB,G2H4(20),n2h4(54))
  call Hloop_QA_S(ntryL,G2H8(16),ex3(:),G2H4(21),ngH,m3h2x4(:,91),heltab2x8(:,:,92))
  call Hloop_QA_S(ntryL,G2H8(17),ex3(:),G2H4(22),ngX,m3h2x4(:,92),heltab2x8(:,:,93))
  call Hloop_QA_S(ntryL,G2H8(18),ex3(:),G2H4(23),ngH,m3h2x4(:,93),heltab2x8(:,:,94))
  call Hloop_QA_S(ntryL,G2H8(19),ex3(:),G2H4(24),ngX,m3h2x4(:,94),heltab2x8(:,:,95))
  call Hloop_WA_Q(ntryL,G1H8(30),ex3(:),G1H4(98),m3h2x4(:,95),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(98),22,nMB,G2H4(25),n2h4(55))
  call Hloop_QA_S(ntryL,G1H8(31),ex3(:),G1H4(9),ngH,m3h2x4(:,96),heltab2x8(:,:,97))
  call Hloop_QA_V(ntryL,G2H8(20),ex3(:),G2H4(26),m3h2x4(:,97),heltab2x8(:,:,98))
  call Hloop_QA_V(ntryL,G2H8(21),ex3(:),G2H4(27),m3h2x4(:,98),heltab2x8(:,:,99))
  call Hloop_QA_Z(ntryL,G2H8(22),ex3(:),G2H4(28),ngZu,m3h2x4(:,99),heltab2x8(:,:,100))
  call Hloop_QA_Z(ntryL,G2H8(23),ex3(:),G2H4(29),ngZu,m3h2x4(:,100),heltab2x8(:,:,101))
  call Hloop_QA_S(ntryL,G1H8(32),ex3(:),G1H4(10),ngH,m3h2x4(:,101),heltab2x8(:,:,102))
  call Hloop_QA_S(ntryL,G1H8(33),ex3(:),G1H4(101),ngX,m3h2x4(:,102),heltab2x8(:,:,103))
  call Hloop_QA_V(ntryL,G1H8(36),ex3(:),G1H4(102),m3h2x4(:,103),heltab2x8(:,:,104))
  call Hloop_QA_Z(ntryL,G1H8(37),ex3(:),G1H4(103),ngZu,m3h2x4(:,104),heltab2x8(:,:,105))
  call Hloop_QA_S(ntryL,G2H8(24),ex3(:),G2H4(30),ngH,m3h2x4(:,105),heltab2x8(:,:,106))
  call Hloop_QA_S(ntryL,G2H8(25),ex3(:),G2H4(31),ngH,m3h2x4(:,106),heltab2x8(:,:,107))
  call Hloop_QA_V(ntryL,G1H8(38),ex3(:),G1H4(104),m3h2x4(:,107),heltab2x8(:,:,108))
  call Hloop_QA_Z(ntryL,G1H8(39),ex3(:),G1H4(107),ngZu,m3h2x4(:,108),heltab2x8(:,:,109))
  call Hloop_QA_V(ntryL,G2H8(26),ex3(:),G2H4(32),m3h2x4(:,109),heltab2x8(:,:,110))
  call Hloop_QA_Z(ntryL,G2H8(27),ex3(:),G2H4(5),ngZu,m3h2x4(:,110),heltab2x8(:,:,111))
  call Hloop_QA_V(ntryL,G2H8(28),ex3(:),G2H4(6),m3h2x4(:,111),heltab2x8(:,:,112))
  call Hloop_QA_Z(ntryL,G2H8(29),ex3(:),G2H4(1),ngZu,m3h2x4(:,112),heltab2x8(:,:,113))
  call Hloop_SQ_A(ntryL,G1H8(42),ex2(:),G1H4(108),ngH,m3h2x4(:,113),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(108),22,nMT,G2H4(2),n2h4(56))
  call Hloop_SQ_A(ntryL,G1H8(43),ex2(:),G1H4(109),ngX,m3h2x4(:,114),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(109),22,nMT,G2H4(7),n2h4(57))
  call Hloop_AQ_S(ntryL,G2H8(30),ex2(:),G2H4(8),ngH,m3h2x4(:,115),heltab2x8(:,:,116))
  call Hloop_AQ_S(ntryL,G2H8(31),ex2(:),G2H4(3),ngH,m3h2x4(:,116),heltab2x8(:,:,117))
  call Hloop_AQ_S(ntryL,G2H8(32),ex2(:),G2H4(4),ngX,m3h2x4(:,117),heltab2x8(:,:,118))
  call Hloop_AQ_S(ntryL,G2H8(33),ex2(:),G2H4(33),ngX,m3h2x4(:,118),heltab2x8(:,:,119))
  call Hloop_AQ_S(ntryL,G2H8(34),ex2(:),G2H4(34),ngPbt,m3h2x4(:,119),heltab2x8(:,:,120))
  call Hloop_AQ_S(ntryL,G2H8(35),ex2(:),G2H4(35),ngPbt,m3h2x4(:,120),heltab2x8(:,:,121))
  call Hloop_VQ_A(ntryL,G1H8(44),ex2(:),G1H4(110),m3h2x4(:,121),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(110),22,nMT,G2H4(36),n2h4(58))
  call Hloop_ZQ_A(ntryL,G1H8(45),ex2(:),G1H4(113),ngZu,m3h2x4(:,122),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(113),22,nMT,G2H4(37),n2h4(59))
  call Hloop_AQ_S(ntryL,G2H8(42),ex2(:),G2H4(38),ngPbt,m3h2x4(:,123),heltab2x8(:,:,124))
  call Hloop_AQ_S(ntryL,G2H8(44),ex2(:),G2H4(39),ngPbt,m3h2x4(:,124),heltab2x8(:,:,125))
  call Hloop_AQ_S(ntryL,G1H8(48),ex2(:),G1H4(114),ngH,m3h2x4(:,125),heltab2x8(:,:,126))
  call Hloop_AQ_S(ntryL,G1H8(49),ex2(:),G1H4(115),ngH,m3h2x4(:,126),heltab2x8(:,:,127))
  call Hloop_AQ_S(ntryL,G1H8(50),ex2(:),G1H4(116),ngX,m3h2x4(:,127),heltab2x8(:,:,128))
  call Hloop_AQ_V(ntryL,G2H8(36),ex2(:),G2H4(40),m3h2x4(:,128),heltab2x8(:,:,129))
  call Hloop_AQ_V(ntryL,G2H8(37),ex2(:),G2H4(41),m3h2x4(:,129),heltab2x8(:,:,130))
  call Hloop_AQ_Z(ntryL,G2H8(38),ex2(:),G2H4(42),ngZu,m3h2x4(:,130),heltab2x8(:,:,131))
  call Hloop_AQ_Z(ntryL,G2H8(39),ex2(:),G2H4(43),ngZu,m3h2x4(:,131),heltab2x8(:,:,132))
  call Hloop_AQ_W(ntryL,G2H8(40),ex2(:),G2H4(44),m3h2x4(:,132),heltab2x8(:,:,133))
  call Hloop_AQ_S(ntryL,G2H8(41),ex2(:),G2H4(45),ngH,m3h2x4(:,133),heltab2x8(:,:,134))
  call Hloop_AQ_S(ntryL,G2H8(43),ex2(:),G2H4(46),ngH,m3h2x4(:,134),heltab2x8(:,:,135))
  call Hloop_AQ_V(ntryL,G1H8(54),ex2(:),G1H4(119),m3h2x4(:,135),heltab2x8(:,:,136))
  call Hloop_AQ_W(ntryL,G2H8(49),ex2(:),G2H4(47),m3h2x4(:,136),heltab2x8(:,:,137))
  call Hloop_AQ_Z(ntryL,G1H8(56),ex2(:),G1H4(120),ngZu,m3h2x4(:,137),heltab2x8(:,:,138))
  call Hloop_AQ_W(ntryL,G2H8(50),ex2(:),G2H4(48),m3h2x4(:,138),heltab2x8(:,:,139))
  call Hloop_AQ_V(ntryL,G1H8(58),ex2(:),G1H4(21),m3h2x4(:,139),heltab2x8(:,:,140))
  call Hloop_AQ_Z(ntryL,G1H8(60),ex2(:),G1H4(22),ngZu,m3h2x4(:,140),heltab2x8(:,:,141))
  call Hloop_AQ_V(ntryL,G2H8(45),ex2(:),G2H4(49),m3h2x4(:,141),heltab2x8(:,:,142))
  call Hloop_AQ_V(ntryL,G2H8(46),ex2(:),G2H4(50),m3h2x4(:,142),heltab2x8(:,:,143))
  call Hloop_AQ_Z(ntryL,G2H8(47),ex2(:),G2H4(51),ngZu,m3h2x4(:,143),heltab2x8(:,:,144))
  call Hloop_AQ_Z(ntryL,G2H8(48),ex2(:),G2H4(52),ngZu,m3h2x4(:,144),heltab2x8(:,:,145))
  call Hloop_SV_T(ntryL,G1H8(63),18,wf4(:,1),9,G2H2(38),m3h4x2(:,2),heltab2x8(:,:,146))
  call Hloop_SV_T(ntryL,G1H8(64),18,wf4(:,1),9,G2H2(40),m3h4x2(:,3),heltab2x8(:,:,147))
  call Hotf_4pt_reduction(G2H8(51),RedSet_4(21),mass4set(:,7),  & 
G1H8(20),G1H8(26),G1H8(27),G1H8(28),G1H8(29),8)
  call HG1shiftOLR(G1H8(26),4,8)
  call Hotf_4pt_reduction(G2H8(52),RedSet_4(21),mass4set(:,8),  & 
G1H8(30),G1H8(31),G1H8(32),G1H8(33),G1H8(36),8)
  call HG1shiftOLR(G1H8(31),4,8)
  call Hloop_SV_V(ntryL,G1H8(65),wf4(:,1),G1H2(82),m3h4x2(:,4),heltab2x8(:,:,148))
  call Hloop_SV_V(ntryL,G1H8(66),wf4(:,1),G1H2(86),m3h4x2(:,5),heltab2x8(:,:,149))
  call Hloop_VV_S(ntryL,G1H8(67),wf4(:,1),G1H2(87),m3h4x2(:,6),heltab2x8(:,:,150))
  call Hloop_QW_A(ntryL,G1H8(68),wf4(:,1),G1H2(88),m3h4x2(:,7),heltab2x8(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(88),27,nMB,G2H2(41),n2h2(101))
  call Hloop_QW_A(ntryL,G1H8(69),wf4(:,1),G1H2(92),m3h4x2(:,8),heltab2x8(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(92),27,nMB,G2H2(43),n2h2(102))
  call Hloop_UV_W(ntryL,G1H8(71),18,wf4(:,1),9,G2H2(44),m3h4x2(:,9),heltab2x8(:,:,153))
  call Hloop_UV_W(ntryL,G1H8(72),18,wf4(:,1),9,G2H2(46),m3h4x2(:,10),heltab2x8(:,:,154))
  call Hotf_4pt_reduction(G2H8(53),RedSet_4(21),mass4set(:,9),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(42),G1H8(43),8)
  call HG1shiftOLR(G1H8(38),4,8)
  call Hotf_4pt_reduction(G2H8(54),RedSet_4(21),mass4set(:,8),  & 
G1H8(44),G1H8(45),G1H8(48),G1H8(49),G1H8(50),8)
  call HG1shiftOLR(G1H8(45),4,8)
  call Hloop_AQ_V(ntryL,G1H4(27),ex2(:),G1H2(21),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_AQ_V(ntryL,G1H4(28),ex2(:),G1H2(22),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_AQ_Z(ntryL,G1H4(31),ex2(:),G1H2(26),ngZu,m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_AQ_Z(ntryL,G1H4(32),ex2(:),G1H2(27),ngZu,m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_AQ_W(ntryL,G1H4(33),ex2(:),G1H2(28),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_QA_V(ntryL,G1H4(34),ex3(:),G1H2(32),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_QA_Z(ntryL,G1H4(37),ex3(:),G1H2(33),ngZu,m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_QA_V(ntryL,G1H4(38),ex3(:),G1H2(34),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_QA_Z(ntryL,G1H4(39),ex3(:),G1H2(38),ngZu,m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_AQ_W(ntryL,G1H4(4),ex4(:),G1H2(39),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_AQ_V(ntryL,G1H4(47),ex4(:),G1H2(40),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_AQ_W(ntryL,G1H4(48),ex4(:),G1H2(44),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_AQ_Z(ntryL,G1H4(49),ex4(:),G1H2(45),ngZd,m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_VQ_A(ntryL,G1H4(50),ex2(:),G1H2(46),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(46),27,nMT,G2H2(47),n2h2(103))
  call Hloop_VQ_A(ntryL,G1H4(53),ex2(:),G1H2(50),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(50),27,nMT,G2H2(49),n2h2(104))
  call Hloop_ZQ_A(ntryL,G1H4(54),ex2(:),G1H2(51),ngZu,m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(51),27,nMT,G2H2(50),n2h2(105))
  call Hloop_ZQ_A(ntryL,G1H4(55),ex2(:),G1H2(52),ngZu,m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(52),27,nMT,G2H2(52),n2h2(106))
  call Hloop_WQ_A(ntryL,G1H4(56),ex2(:),G1H2(56),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(56),27,nMB,G2H2(53),n2h2(107))
  call Hloop_VA_Q(ntryL,G1H4(59),ex3(:),G1H2(57),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(57),29,nMT,G2H2(55),n2h2(108))
  call Hloop_VA_Q(ntryL,G1H4(60),ex3(:),G1H2(58),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(58),29,nMT,G2H2(56),n2h2(109))
  call Hloop_ZA_Q(ntryL,G1H4(61),ex3(:),G1H2(62),ngZu,m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(62),29,nMT,G2H2(58),n2h2(110))
  call Hloop_ZA_Q(ntryL,G1H4(62),ex3(:),G1H2(63),ngZu,m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(63),29,nMT,G2H2(59),n2h2(111))
  call Hloop_WA_Q(ntryL,G1H4(65),ex1(:),G1H2(64),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(64),23,0,G2H2(61),n2h2(112))
call HGT_raise_alpha_OLR(G1H4(66),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(66),ex4(:),G1H2(68),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_WA_Q(ntryL,G1H4(6),ex1(:),G1H2(69),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(69),23,0,G2H2(62),n2h2(113))
  call Hloop_WA_Q(ntryL,G1H4(67),ex1(:),G1H2(70),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(70),23,0,G2H2(64),n2h2(114))
  call Hloop_WA_Q(ntryL,G1H4(68),ex1(:),G1H2(74),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(74),23,0,G2H2(65),n2h2(115))
call HGT_raise_alpha_OLR(G1H4(69),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(69),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(69),ex4(:),G1H2(75),ngZd,m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_WA_Q(ntryL,G1H4(73),ex1(:),G1H2(76),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(76),23,0,G2H2(67),n2h2(116))
  call Hloop_WA_Q(ntryL,G1H4(74),ex1(:),G1H2(80),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(80),23,0,G2H2(68),n2h2(117))
  call Hloop_AV_Q(ntryL,G1H8(73),wf4(:,3),G1H2(88),m3h4x2(:,11),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(88),23,0,G2H2(70),n2h2(118))
call HGT_raise_alpha_OLR(G1H8(25),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(25),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(25),ex4(:),G1H4(25),m3h2x4(:,145),heltab2x8(:,:,156))
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,3),G1H2(92),m3h4x2(:,12),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(92),23,0,G2H2(71),n2h2(119))
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,3),G1H2(46),m3h4x2(:,13),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(46),23,0,G2H2(73),n2h2(120))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,3),G1H2(50),m3h4x2(:,14),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(50),23,0,G2H2(74),n2h2(121))
call HGT_raise_alpha_OLR(G1H8(5),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(5),ex4(:),G1H4(26),m3h2x4(:,146),heltab2x8(:,:,160))
  call Hloop_AV_Q(ntryL,G1H8(7),wf4(:,3),G1H2(51),m3h4x2(:,15),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(51),23,0,G2H2(76),n2h2(122))
  call Hloop_AV_Q(ntryL,G1H8(8),wf4(:,3),G1H2(52),m3h4x2(:,16),heltab2x8(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(52),23,0,G2H2(77),n2h2(123))
  call Hloop_AV_Q(ntryL,G1H8(9),wf4(:,3),G1H2(56),m3h4x2(:,17),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(56),23,0,G2H2(79),n2h2(124))
call HGT_raise_alpha_OLR(G1H8(10),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(10),ex4(:),G1H4(12),m3h2x4(:,147),heltab2x8(:,:,164))
  call Hloop_AV_Q(ntryL,G1H8(12),wf4(:,3),G1H2(57),m3h4x2(:,18),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(57),23,0,G2H2(80),n2h2(125))
  call Hloop_AV_Q(ntryL,G1H8(34),wf4(:,3),G1H2(58),m3h4x2(:,19),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G1H2(58),23,0,G2H2(82),n2h2(126))
  call Hloop_AV_Q(ntryL,G1H8(35),wf4(:,3),G1H2(62),m3h4x2(:,20),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(62),23,0,G2H2(83),n2h2(127))
call HGT_raise_alpha_OLR(G1H8(40),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(40),ex4(:),G1H4(19),ngZd,m3h2x4(:,148),heltab2x8(:,:,168))
  call Hloop_AV_Q(ntryL,G1H8(51),wf4(:,3),G1H2(63),m3h4x2(:,21),heltab2x8(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(63),23,0,G2H2(84),n2h2(128))
  call Hloop_AV_Q(ntryL,G1H8(52),wf4(:,3),G1H2(64),m3h4x2(:,22),heltab2x8(:,:,170))
  call Hloop_A_Q(ntryL,G1H2(64),23,0,G2H2(85),n2h2(129))
  call Hloop_AZ_Q(ntryL,G1H8(53),wf4(:,4),G1H2(69),ngZu,m3h4x2(:,23),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(69),23,0,G2H2(86),n2h2(130))
call HGT_raise_alpha_OLR(G1H8(46),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(46),ex4(:),G1H4(14),m3h2x4(:,149),heltab2x8(:,:,172))
  call Hloop_AZ_Q(ntryL,G1H8(59),wf4(:,4),G1H2(70),ngZu,m3h4x2(:,24),heltab2x8(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(70),23,0,G2H2(87),n2h2(131))
  call Hloop_AZ_Q(ntryL,G1H8(61),wf4(:,4),G1H2(74),ngZu,m3h4x2(:,25),heltab2x8(:,:,174))
  call Hloop_A_Q(ntryL,G1H2(74),23,0,G2H2(88),n2h2(132))
  call Hloop_AZ_Q(ntryL,G1H8(62),wf4(:,4),G1H2(76),ngZd,m3h4x2(:,26),heltab2x8(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(76),23,0,G2H2(89),n2h2(133))
call HGT_raise_alpha_OLR(G1H8(55),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(55),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(55),ex4(:),G1H4(1),m3h2x4(:,150),heltab2x8(:,:,176))
  call Hloop_AZ_Q(ntryL,G1H8(70),wf4(:,4),G1H2(80),ngZd,m3h4x2(:,27),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(80),23,0,G2H2(90),n2h2(134))
  call Hloop_AZ_Q(ntryL,G1H8(13),wf4(:,4),G1H2(88),ngZd,m3h4x2(:,28),heltab2x8(:,:,178))
  call Hloop_A_Q(ntryL,G1H2(88),23,0,G2H2(91),n2h2(135))
  call Hloop_AZ_Q(ntryL,G1H8(14),wf4(:,4),G1H2(92),ngZu,m3h4x2(:,29),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(92),23,0,G2H2(92),n2h2(136))
call HGT_raise_alpha_OLR(G1H8(15),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(15),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(15),ex4(:),G1H4(13),m3h2x4(:,151),heltab2x8(:,:,180))
  call Hloop_AZ_Q(ntryL,G1H8(17),wf4(:,4),G1H2(46),ngZu,m3h4x2(:,30),heltab2x8(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(46),23,0,G2H2(93),n2h2(137))
  call Hloop_AZ_Q(ntryL,G1H8(21),wf4(:,4),G1H2(50),ngZu,m3h4x2(:,31),heltab2x8(:,:,182))
  call Hloop_A_Q(ntryL,G1H2(50),23,0,G2H2(94),n2h2(138))
  call Hloop_AZ_Q(ntryL,G1H8(22),wf4(:,4),G1H2(51),ngZd,m3h4x2(:,32),heltab2x8(:,:,183))
  call Hloop_A_Q(ntryL,G1H2(51),23,0,G2H2(95),n2h2(139))
call HGT_raise_alpha_OLR(G1H8(23),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(23),ex4(:),G1H4(17),ngZd,m3h2x4(:,152),heltab2x8(:,:,184))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,4),G1H2(52),ngZd,m3h4x2(:,33),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(52),23,0,G2H2(96),n2h2(140))
  call Hloop_AZ_Q(ntryL,G1H8(19),wf4(:,4),G1H2(56),ngZd,m3h4x2(:,34),heltab2x8(:,:,186))
  call Hloop_A_Q(ntryL,G1H2(56),23,0,G2H2(97),n2h2(141))
  call Hloop_QW_A(ntryL,G1H8(20),wf4(:,1),G1H2(57),m3h4x2(:,35),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(57),27,nMB,G2H2(98),n2h2(142))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(26),ex3(:),G1H4(20),ngPtb,m3h2x4(:,153),heltab2x8(:,:,188))
  call Hloop_QW_A(ntryL,G1H8(28),wf4(:,1),G1H2(58),m3h4x2(:,36),heltab2x8(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(58),27,nMB,G2H2(99),n2h2(143))
  call Hloop_QW_A(ntryL,G1H8(29),wf4(:,1),G1H2(62),m3h4x2(:,37),heltab2x8(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(62),27,nMB,G2H2(100),n2h2(144))
  call Hloop_QW_A(ntryL,G1H8(30),wf4(:,1),G1H2(63),m3h4x2(:,38),heltab2x8(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(63),27,nMB,G2H2(101),n2h2(145))
call HGT_OLR(G1H8(31),1,1,8)
call HGT_invQ_OLR(G1H8(31),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(31),ex3(:),G1H4(2),ngPtb,m3h2x4(:,154),heltab2x8(:,:,192))
  call Hloop_QW_A(ntryL,G1H8(33),wf4(:,1),G1H2(64),m3h4x2(:,39),heltab2x8(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(64),27,nMB,G2H2(102),n2h2(146))
  call Hloop_QW_A(ntryL,G1H8(36),wf4(:,1),G1H2(69),m3h4x2(:,40),heltab2x8(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(69),27,nMB,G2H2(103),n2h2(147))
  call Hloop_QW_A(ntryL,G1H8(37),wf4(:,1),G1H2(70),m3h4x2(:,41),heltab2x8(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(70),27,nMB,G2H2(104),n2h2(148))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(38),ex3(:),G1H4(11),m3h2x4(:,155),heltab2x8(:,:,196))
  call Hloop_QW_A(ntryL,G1H8(42),wf4(:,1),G1H2(74),m3h4x2(:,42),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(74),27,nMB,G2H2(105),n2h2(149))
  call Hloop_QW_A(ntryL,G1H8(43),wf4(:,1),G1H2(76),m3h4x2(:,43),heltab2x8(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(76),27,nMB,G2H2(106),n2h2(150))
  call Hloop_QW_A(ntryL,G1H8(44),wf4(:,1),G1H2(80),m3h4x2(:,44),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(80),27,nMB,G2H2(107),n2h2(151))
call HGT_raise_alpha_OLR(G1H8(45),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(45),ex3(:),G1H4(18),m3h2x4(:,156),heltab2x8(:,:,200))
  call Hloop_QW_A(ntryL,G1H8(49),wf4(:,1),G1H2(88),m3h4x2(:,45),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(88),27,nMB,G2H2(108),n2h2(152))
  call Hloop_QW_A(ntryL,G1H8(50),wf4(:,1),G1H2(92),m3h4x2(:,46),heltab2x8(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(92),27,nMB,G2H2(109),n2h2(153))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G2H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(11)])
call HGT_w2_OLR(G1H2(12),1,1,2)
call HGT_w2_invQ_OLR(G1H2(12),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G2H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(13)])
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(45)])
call HGT_w2_OLR(G1H2(15),1,1,2)
call HGT_w2_invQ_OLR(G1H2(15),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(39)])
call HGT_w2_OLR(G1H2(16),1,1,2)
call HGT_w2_invQ_OLR(G1H2(16),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(16),[G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(17)])
call HGT_w2_OLR(G1H2(19),1,1,2)
call HGT_w2_invQ_OLR(G1H2(19),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G2H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(20),[G1H2(18)])
call HGT_w2_OLR(G1H2(20),1,1,2)
call HGT_w2_invQ_OLR(G1H2(20),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(20),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G2H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(82),G1H2(61),G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(86),G1H2(67),G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(32),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(73),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(54),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(79),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(34),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(85),[G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(81),[G1H2(91),G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(90),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(27),[G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(86),[G2H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G2H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(85)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(2),ex1(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(37))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(24),ex4(:),G2tensor(8),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(27),ex4(:),G2tensor(1),ngZd,m3h2x1(:,89),heltab2x2(:,:,89))
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(3),ex1(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(2),n2h1(38))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(3),m3h2x1(:,91),heltab2x2(:,:,91))
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(4),ex1(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(39))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(5),m3h2x1(:,93),heltab2x2(:,:,93))
call HGT_w2_OLR(G1H2(5),1,1,2)
call HGT_w2_invQ_OLR(G1H2(5),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(5),ex1(:),G1H1(1),ngZu,m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(40))
call HGT_w2_OLR(G1H2(6),1,1,2)
call HGT_w2_invQ_OLR(G1H2(6),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(6),ex1(:),G1H1(1),ngZu,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(41))
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(7),ex1(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(42))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(48),ex4(:),G2tensor(9),m3h2x1(:,97),heltab2x2(:,:,97))
call HGT_w2_OLR(G1H2(8),1,1,2)
call HGT_w2_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(8),ex1(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(43))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(51),ex4(:),G2tensor(11),m3h2x1(:,99),heltab2x2(:,:,99))
call HGT_w2_OLR(G1H2(9),1,1,2)
call HGT_w2_invQ_OLR(G1H2(9),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(9),ex1(:),G1H1(1),ngZu,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(44))
call HGT_w2_OLR(G1H2(10),1,1,2)
call HGT_w2_invQ_OLR(G1H2(10),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(10),ex1(:),G1H1(1),ngZu,m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(12),ex2(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(17),n2h1(46))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(60),ex3(:),G2tensor(19),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(63),ex3(:),G2tensor(21),ngZu,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hloop_ZQ_A(ntryL,G1H2(14),ex2(:),G1H1(1),ngZu,m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(23),n2h1(47))
  call Hloop_WQ_A(ntryL,G1H2(15),ex2(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(25),n2h1(48))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(66),ex3(:),G2tensor(27),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hloop_WQ_A(ntryL,G1H2(16),ex2(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(29),n2h1(49))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(69),ex3(:),G2tensor(31),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hloop_VA_Q(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(33),n2h1(50))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(75),ex2(:),G2tensor(35),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hloop_ZA_Q(ntryL,G1H2(20),ex3(:),G1H1(1),ngZu,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(37),n2h1(51))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(81),ex2(:),G2tensor(43),ngZu,m3h2x1(:,113),heltab2x2(:,:,113))
  call Hloop_VA_Q(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(45),n2h1(52))
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(21),mass4set(:,10),  & 
G1H2(46),G1H2(50),G1H2(51),G1H2(52),G1H2(56),2)
  call HG1shiftOLR(G1H2(50),4,2)
  call Hloop_ZA_Q(ntryL,G1H2(30),ex3(:),G1H1(1),ngZu,m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(47),n2h1(53))
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(21),mass4set(:,11),  & 
G1H2(57),G1H2(58),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(58),4,2)
  call Hloop_VQ_A(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(54))
  call Hloop_VQ_A(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(55))
  call Hloop_VQ_A(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(54),n2h1(56))
  call Hloop_ZQ_A(ntryL,G1H2(33),ex4(:),G1H1(1),ngZd,m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(57))
  call Hloop_ZQ_A(ntryL,G1H2(54),ex4(:),G1H1(1),ngZd,m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(60),n2h1(58))
  call Hloop_ZQ_A(ntryL,G1H2(79),ex4(:),G1H1(1),ngZd,m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(59))
  call Hloop_VQ_A(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(66),n2h1(60))
  call Hloop_VQ_A(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(61))
  call Hloop_ZQ_A(ntryL,G1H2(38),ex4(:),G1H1(1),ngZd,m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(72),n2h1(62))
  call Hloop_ZQ_A(ntryL,G1H2(81),ex4(:),G1H1(1),ngZd,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(63))
  call Hloop_VA_Q(ntryL,G1H2(59),ex3(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(78),n2h1(64))
  call Hloop_VA_Q(ntryL,G1H2(60),ex3(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(65))
  call Hloop_ZA_Q(ntryL,G1H2(65),ex3(:),G1H1(1),ngZu,m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(84),n2h1(66))
  call Hloop_ZA_Q(ntryL,G1H2(66),ex3(:),G1H1(1),ngZu,m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(87),n2h1(67))
  call Hloop_VQ_A(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(88),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(69))
  call Hloop_ZQ_A(ntryL,G1H2(26),ex4(:),G1H1(1),ngZd,m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(90),n2h1(70))
  call Hloop_ZQ_A(ntryL,G1H2(90),ex4(:),G1H1(1),ngZd,m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(71))
  call Hloop_VQ_A(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(72))
  call Hloop_ZQ_A(ntryL,G1H2(27),ex4(:),G1H1(1),ngZd,m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(73))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(94),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(95),ngZd,m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(96),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(97),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(98),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(99),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(100),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(8),ex4(:),G2tensor(101),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(102),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(10),ex4(:),G2tensor(103),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(104),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex3(:),G2tensor(105),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(106),ngZu,m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(107),ngZu,m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(108),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(109),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(110),ngZu,m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(111),ngZu,m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(112),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(20),ex3(:),G2tensor(113),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(21),ex3(:),G2tensor(114),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex2(:),G2tensor(115),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(23),ex2(:),G2tensor(116),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(25),ex2(:),G2tensor(117),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex2(:),G2tensor(118),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(28),ex2(:),G2tensor(119),ngZu,m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(29),ex2(:),G2tensor(120),ngZu,m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(31),ex2(:),G2tensor(121),ngZu,m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(32),ex2(:),G2tensor(122),ngZu,m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(75),25,wf4(:,2),6,G2tensor(123),m3h4x1(:,1),heltab2x4(:,:,165))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(76),25,wf4(:,2),6,G2tensor(124),m3h4x1(:,2),heltab2x4(:,:,166))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(79),25,wf4(:,10),6,G2tensor(125),m3h4x1(:,3),heltab2x4(:,:,167))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H4(80),25,wf4(:,10),6,G2tensor(126),m3h4x1(:,4),heltab2x4(:,:,168))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(81),25,wf4(:,10),6,G2tensor(127),m3h4x1(:,5),heltab2x4(:,:,169))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H4(9),wf4(:,2),G2tensor(128),m3h4x1(:,6),heltab2x4(:,:,170))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H4(10),wf4(:,2),G2tensor(129),m3h4x1(:,7),heltab2x4(:,:,171))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H4(11),wf4(:,2),G2tensor(130),m3h4x1(:,8),heltab2x4(:,:,172))
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(13),mass4set(:,12),  & 
G1H4(29),G1H4(23),G1H4(24),G1H4(30),G1H4(41),4)
  call HG1shiftOLR(G1H4(23),6,4)
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(13),mass4set(:,13),  & 
G1H4(35),G1H4(36),G1H4(64),G1H4(42),G1H4(45),4)
  call HG1shiftOLR(G1H4(36),6,4)
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(13),mass4set(:,12),  & 
G1H4(57),G1H4(89),G1H4(43),G1H4(3),G1H4(40),4)
  call HG1shiftOLR(G1H4(89),6,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(13),mass4set(:,13),  & 
G1H4(46),G1H4(52),G1H4(44),G1H4(58),G1H4(16),4)
  call HG1shiftOLR(G1H4(52),6,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(88),wf4(:,3),G1tensor(1),m3h4x1(:,9),heltab2x4(:,:,173))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(91),wf4(:,3),G1tensor(7),m3h4x1(:,10),heltab2x4(:,:,174))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(92),wf4(:,4),G1tensor(13),m3h4x1(:,11),heltab2x4(:,:,175))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(93),wf4(:,4),G1tensor(19),m3h4x1(:,12),heltab2x4(:,:,176))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(94),wf4(:,4),G1tensor(25),m3h4x1(:,13),heltab2x4(:,:,177))
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(13),mass4set(:,14),  & 
G1H4(51),G1H4(63),G1H4(7),G1H4(8),G1H4(71),4)
  call HG1shiftOLR(G1H4(63),6,4)
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(13),mass4set(:,15),  & 
G1H4(72),G1H4(77),G1H4(78),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(77),6,4)
  call Hotf_4pt_reduction(G2H4(18),RedSet_4(13),mass4set(:,14),  & 
G1H4(95),G1H4(90),G1H4(96),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(90),6,4)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(13),mass4set(:,15),  & 
G1H4(105),G1H4(106),G1H4(111),G1H4(112),G1H4(117),4)
  call HG1shiftOLR(G1H4(106),6,4)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(131),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(2),mass4set(:,12),  & 
G1H2(69),G1H2(70),G1H2(74),G1H2(76),G1H2(80),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(2),mass4set(:,16),  & 
G1H2(88),G1H2(92),G1H2(1),G1H2(11),G1H2(40),2)
  call HG1shiftOLR(G1H2(92),8,2)
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(8),mass4set(:,17),  & 
G1H4(118),G1H4(82),G1H4(85),G1H4(86),G1H4(87),4)
  call HG1shiftOLR(G1H4(82),9,4)
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(8),mass4set(:,18),  & 
G1H4(15),G1H4(97),G1H4(98),G1H4(108),G1H4(109),4)
  call HG1shiftOLR(G1H4(97),9,4)
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(8),mass4set(:,19),  & 
G1H4(110),G1H4(113),G1H4(27),G1H4(28),G1H4(31),4)
  call HG1shiftOLR(G1H4(113),9,4)
  call Hotf_4pt_reduction(G2H4(23),RedSet_4(8),mass4set(:,20),  & 
G1H4(32),G1H4(33),G1H4(34),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(33),9,4)
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(8),mass4set(:,21),  & 
G1H4(39),G1H4(4),G1H4(47),G1H4(48),G1H4(49),4)
  call HG1shiftOLR(G1H4(4),9,4)
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(9),wf4(:,1),G1tensor(31),m3h4x1(:,14),heltab2x4(:,:,178))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(26),wf4(:,1),G2tensor(132),m3h4x1(:,15),heltab2x4(:,:,179))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(27),wf4(:,1),G2tensor(133),m3h4x1(:,16),heltab2x4(:,:,180))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(28),wf4(:,1),G2tensor(134),m3h4x1(:,17),heltab2x4(:,:,181))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(29),wf4(:,1),G2tensor(135),m3h4x1(:,18),heltab2x4(:,:,182))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(10),22,wf4(:,1),9,G2tensor(136),m3h4x1(:,19),heltab2x4(:,:,183))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(101),22,wf4(:,1),9,G2tensor(137),m3h4x1(:,20),heltab2x4(:,:,184))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(102),22,wf4(:,1),9,G2tensor(138),m3h4x1(:,21),heltab2x4(:,:,185))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(103),22,wf4(:,1),9,G2tensor(139),m3h4x1(:,22),heltab2x4(:,:,186))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(30),wf4(:,1),G2tensor(140),m3h4x1(:,23),heltab2x4(:,:,187))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(31),wf4(:,1),G2tensor(141),m3h4x1(:,24),heltab2x4(:,:,188))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(104),wf4(:,1),G1tensor(37),m3h4x1(:,25),heltab2x4(:,:,189))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(107),wf4(:,1),G1tensor(43),m3h4x1(:,26),heltab2x4(:,:,190))
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(8),mass4set(:,22),  & 
G1H4(50),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(53),9,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(8),mass4set(:,23),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(65),4)
  call HG1shiftOLR(G1H4(60),9,4)



end subroutine vamp_1

end module ol_vamp_1_ppwtt_ew_uxttxdwx_4_/**/REALKIND
