
module ol_vamp_2_ppwjj_uxdwxgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwjj_uxdwxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwjj_uxdwxgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwjj_uxdwxgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwjj_uxdwxgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwjj_uxdwxgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwjj_uxdwxgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call TI_triangle_red(G2tensor(115),RedBasis(15),mass3set(:,1),G0tensor(10),G0tensor(5),G0tensor(130),G0tensor(18),M2L1R1)
  call TI_triangle_red(G2tensor(157),RedBasis(56),mass3set(:,1),G0tensor(135),G0tensor(54),G0tensor(19),G0tensor(175),M2L1R1)
  call TI_triangle_red(G2tensor(151),RedBasis(59),mass3set(:,1),G0tensor(140),G0tensor(85),G0tensor(45),G0tensor(20),M2L1R1)
  call TI_triangle_red(G2tensor(107),RedBasis(61),mass3set(:,1),G0tensor(145),G0tensor(100),G0tensor(3),G0tensor(150),M2L1R1)
  call TI_triangle_red(G2tensor(85),RedBasis(57),mass3set(:,1),G0tensor(105),G0tensor(34),G0tensor(4),G0tensor(187),M2L1R1)
  call TI_triangle_red(G2tensor(77),RedBasis(60),mass3set(:,1),G0tensor(90),G0tensor(75),G0tensor(33),G0tensor(160),M2L1R1)
  call TI_triangle_red(G2tensor(94),RedBasis(63),mass3set(:,1),G0tensor(55),G0tensor(35),G0tensor(170),G0tensor(165),M2L1R1)
  call TI_triangle_red(G2tensor(148),RedBasis(20),mass3set(:,1),G0tensor(69),G0tensor(44),G0tensor(172),G0tensor(80),M2L1R1)
  call TI_triangle_red(G2tensor(190),RedBasis(66),mass3set(:,1),G0tensor(60),G0tensor(53),G0tensor(185),G0tensor(180),M2L1R1)
  call TI_triangle_red(G2tensor(69),RedBasis(65),mass3set(:,1),G0tensor(68),G0tensor(195),G0tensor(83),G0tensor(200),M2L1R1)
  call TI_triangle_red(G2tensor(75),RedBasis(14),mass3set(:,1),G0tensor(84),G0tensor(205),G0tensor(120),G0tensor(8),M2L1R1)
  call TI_triangle_red(G2tensor(71),RedBasis(67),mass3set(:,1),G0tensor(210),G0tensor(125),G0tensor(9),G0tensor(137),M2L1R1)
  call TI_triangle_red(G2tensor(97),RedBasis(23),mass3set(:,1),G0tensor(40),G0tensor(15),G0tensor(152),G0tensor(65),M2L1R1)
  call TI_triangle_red(G2tensor(31),RedBasis(5),mass3set(:,1),G0tensor(25),G0tensor(157),G0tensor(50),G0tensor(30),M2L1R1)
  call TI_triangle_red(G2tensor(11),RedBasis(13),mass3set(:,1),G0tensor(132),G0tensor(49),G0tensor(14),G0tensor(147),M2L1R1)
  call TI_triangle_red(G2tensor(2),RedBasis(12),mass3set(:,1),G0tensor(29),G0tensor(24),G0tensor(162),G0tensor(64),M2L1R1)
  call TI_triangle_red(G2tensor(27),RedBasis(27),mass3set(:,1),G0tensor(39),G0tensor(167),G0tensor(158),G0tensor(74),M2L1R1)
  call TI_triangle_red(G2tensor(10),RedBasis(26),mass3set(:,1),G0tensor(59),G0tensor(192),G0tensor(78),G0tensor(197),M2L1R1)
  call TI_triangle_red(G3tensor(9),RedBasis(3),mass3set(:,1),G0tensor(79),G0tensor(202),G0tensor(103),G0tensor(98),M2L1R1)
  call TI_triangle_red(G2tensor(154),RedBasis(10),mass3set(:,1),G0tensor(88),G0tensor(207),G0tensor(89),G0tensor(178),M2L1R1)
  call TI_triangle_red(G2tensor(83),RedBasis(25),mass3set(:,1),G0tensor(163),G0tensor(97),G0tensor(93),G0tensor(138),M2L1R1)
  call TI_triangle_red(G2tensor(160),RedBasis(29),mass3set(:,1),G0tensor(129),G0tensor(102),G0tensor(94),G0tensor(119),M2L1R1)
  call TI_triangle_red(G3tensor(5),RedBasis(3),mass3set(:,2),G0tensor(108),G0tensor(99),G0tensor(124),G0tensor(109),M2L1R1,[nMT], &
    G0tensor(104))
  call TI_triangle_red(G3tensor(7),RedBasis(3),mass3set(:,3),G0tensor(183),G0tensor(168),G0tensor(117),G0tensor(113),M2L1R1,[nMB], &
    G0tensor(194))
  call ol_merge_tensors(T0sum(43),[G0tensor(1)])
  call ol_merge_tensors(T0sum(44),[G0tensor(21)])
  call ol_merge_tensors(T0sum(45),[G0tensor(41)])
  call ol_merge_tensors(T0sum(46),[G0tensor(61)])
  call ol_merge_tensors(T0sum(47),[G0tensor(81)])
  call ol_merge_tensors(T0sum(48),[G0tensor(101)])
  call ol_merge_tensors(T0sum(49),[G0tensor(121)])
  call ol_merge_tensors(T0sum(50),[G0tensor(141)])
  call ol_merge_tensors(T0sum(51),[G0tensor(161)])
  call ol_merge_tensors(T0sum(52),[G0tensor(181)])
  call ol_merge_tensors(T0sum(53),[G0tensor(201)])
  call ol_merge_tensors(T0sum(54),[G0tensor(177)])
  call ol_merge_tensors(T0sum(55),[G0tensor(198)])
  call ol_merge_tensors(T0sum(56),[G0tensor(22)])
  call ol_merge_tensors(T0sum(57),[G0tensor(27)])
  call ol_merge_tensors(T0sum(58),[G0tensor(42)])
  call ol_merge_tensors(T0sum(59),[G0tensor(118)])
  call ol_merge_tensors(T0sum(60),[G0tensor(72)])
  call ol_merge_tensors(T0sum(61),[G0tensor(182)])
  call ol_merge_tensors(T0sum(62),[G0tensor(77)])
  call ol_merge_tensors(T0sum(63),[G0tensor(112)])
  call ol_merge_tensors(T0sum(64),[G0tensor(115)])
  call ol_merge_tensors(T0sum(65),[G0tensor(190)])
  call ol_merge_tensors(T0sum(66),[G0tensor(10)])
  call ol_merge_tensors(T0sum(67),[G0tensor(135)])
  call ol_merge_tensors(T0sum(68),[G0tensor(140)])
  call ol_merge_tensors(T0sum(69),[G0tensor(145)])
  call ol_merge_tensors(T0sum(70),[G0tensor(105)])
  call ol_merge_tensors(T0sum(71),[G0tensor(90)])
  call ol_merge_tensors(T0sum(72),[G0tensor(55)])
  call ol_merge_tensors(T0sum(73),[G0tensor(69)])
  call ol_merge_tensors(T0sum(74),[G0tensor(60)])
  call ol_merge_tensors(T0sum(75),[G0tensor(68)])
  call ol_merge_tensors(T0sum(76),[G0tensor(84)])
  call ol_merge_tensors(T0sum(77),[G0tensor(210)])
  call ol_merge_tensors(T0sum(78),[G0tensor(40)])
  call ol_merge_tensors(T0sum(79),[G0tensor(25)])
  call ol_merge_tensors(T0sum(80),[G0tensor(132)])
  call ol_merge_tensors(T0sum(81),[G0tensor(29)])
  call ol_merge_tensors(T0sum(82),[G0tensor(39)])
  call ol_merge_tensors(T0sum(83),[G0tensor(59)])
  call ol_merge_tensors(T0sum(84),[G0tensor(79)])
  call ol_merge_tensors(T0sum(85),[G0tensor(88)])
  call ol_merge_tensors(T0sum(86),[G0tensor(163)])
  call ol_merge_tensors(T0sum(87),[G0tensor(129)])
  call ol_merge_tensors(T0sum(88),[G0tensor(108)])
  call ol_merge_tensors(T0sum(89),[G0tensor(183)])
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(107),h0tab(:,107),[23,8],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex5(:),wf12(:,3),G0H2(1),m4h2x12x2(:,1),heltab3x48(:,:,10))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(108),h0tab(:,108),[23,8],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_12(ntryL,G0H48(1),wf12(:,3),ex5(:),G0H2(2),m4h12x2x2(:,1),heltab3x48(:,:,11))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(109),h0tab(:,109),[23,8],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_23(ntryL,G0H48(1),ex5(:),wf12(:,3),G0H2(3),m4h2x12x2(:,2),heltab3x48(:,:,12))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(110),h0tab(:,110),[16,15],[0,0],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(3),m3h2x24(:,65),heltab2x48(:,:,98))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(111),h0tab(:,111),[16,15],[0,0],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(5),m3h2x24(:,66),heltab2x48(:,:,99))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(112),h0tab(:,112),[16,15],[0,0],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(18),m3h2x24(:,67),heltab2x48(:,:,100))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(113),h0tab(:,113),[24,7],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(9),m4h2x2x12(:,10),heltab3x48(:,:,13))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(114),h0tab(:,114),[24,7],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex4(:),ex5(:),G0H12(2),m4h2x2x12(:,11),heltab3x48(:,:,14))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(115),h0tab(:,115),[24,7],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_23(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(3),m4h2x2x12(:,12),heltab3x48(:,:,15))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(116),h0tab(:,116),[23,8],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex5(:),wf12(:,4),G0H2(4),m4h2x12x2(:,3),heltab3x48(:,:,16))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(117),h0tab(:,117),[23,8],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_12(ntryL,G0H48(1),wf12(:,4),ex5(:),G0H2(5),m4h12x2x2(:,2),heltab3x48(:,:,17))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(118),h0tab(:,118),[23,8],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_23(ntryL,G0H48(1),ex5(:),wf12(:,4),G0H2(6),m4h2x12x2(:,4),heltab3x48(:,:,18))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(119),h0tab(:,119),[16,15],[0,0],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(20),m3h2x24(:,68),heltab2x48(:,:,101))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(120),h0tab(:,120),[16,15],[0,0],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(1),m3h2x24(:,69),heltab2x48(:,:,102))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(121),h0tab(:,121),[16,15],[0,0],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(2),m3h2x24(:,70),heltab2x48(:,:,103))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(122),h0tab(:,122),[24,7],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(8),m4h2x2x12(:,13),heltab3x48(:,:,19))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(123),h0tab(:,123),[24,7],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex4(:),ex5(:),G0H12(5),m4h2x2x12(:,14),heltab3x48(:,:,20))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(124),h0tab(:,124),[24,7],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_23(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(4),m4h2x2x12(:,15),heltab3x48(:,:,21))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(125),h0tab(:,125),[21,10],[0,0],2,2,wf12(:,19),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,19),G0H4(5),m3h12x4(:,9),heltab2x48(:,:,104))
  call Hloop_A_Q(ntryL,G0H4(5),21,0,G1H4(28),n2h4(39))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(126),h0tab(:,126),[26,5],[0,0],2,2,wf8(:,8),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf8(:,8),G0H6(3),m3h8x6(:,7),heltab2x48(:,:,105))
  call Hloop_Q_A(ntryL,G0H6(3),26,0,G1H6(4),n2h6(38))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(127),h0tab(:,127),[18,13],[0,0],2,2,wf4(:,4),wf12(:,20))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,4),G0H12(1),m3h4x12(:,20),heltab2x48(:,:,106))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(128),h0tab(:,128),[26,5],[0,0],2,2,wf8(:,10),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf8(:,10),G0H6(1),m3h8x6(:,8),heltab2x48(:,:,107))
  call Hloop_Q_A(ntryL,G0H6(1),26,0,G1H6(24),n2h6(39))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(129),h0tab(:,129),[24,7],[0,0],2,2,wf4(:,5),wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(6),m3h4x12(:,21),heltab2x48(:,:,108))
  call Hloop_Q_A(ntryL,G0H12(6),24,0,G1H12(6),n2h12(33))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(130),h0tab(:,130),[24,7],[nMT,nMT],2,2,wf4(:,5),wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,22),heltab2x48(:,:,109))
  call Hloop_Q_A(ntryL,G0H12(7),24,nMT,G1H12(3),n2h12(34))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(131),h0tab(:,131),[24,7],[0,0],2,2,wf4(:,5),wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(6),m3h4x12(:,23),heltab2x48(:,:,110))
  call Hloop_Q_A(ntryL,G0H12(6),24,0,G1H12(9),n2h12(35))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(132),h0tab(:,132),[24,7],[nMB,nMB],2,2,wf4(:,5),wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,24),heltab2x48(:,:,111))
  call Hloop_Q_A(ntryL,G0H12(7),24,nMB,G1H12(11),n2h12(36))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(133),h0tab(:,133),[24,7],[0,0],2,2,wf4(:,5),wf12(:,3))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf4(:,5),24,G1H12(13),m3h4x12(:,25),heltab2x48(:,:,112))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(134),h0tab(:,134),[24,7],[0,0],2,2,wf4(:,5),wf12(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf4(:,5),24,G1H12(4),m3h4x12(:,26),heltab2x48(:,:,113))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(135),h0tab(:,135),[26,5],[0,0],2,2,wf8(:,12),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf8(:,12),G0H6(4),m3h8x6(:,9),heltab2x48(:,:,114))
  call Hloop_Q_A(ntryL,G0H6(4),26,0,G1H6(29),n2h6(40))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(136),h0tab(:,136),[25,6],[0,0],2,2,wf8(:,13),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf8(:,13),G0H6(2),m3h8x6(:,10),heltab2x48(:,:,115))
  call Hloop_A_Q(ntryL,G0H6(2),25,0,G1H6(30),n2h6(41))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(137),h0tab(:,137),[22,9],[0,0],2,2,wf12(:,22),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,22),G0H4(1),m3h12x4(:,10),heltab2x48(:,:,116))
  call Hloop_Q_A(ntryL,G0H4(1),22,0,G1H4(17),n2h4(40))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(138),h0tab(:,138),[25,6],[0,0],2,2,wf8(:,14),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf8(:,14),G0H6(5),m3h8x6(:,11),heltab2x48(:,:,117))
  call Hloop_A_Q(ntryL,G0H6(5),25,0,G1H6(35),n2h6(42))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(139),h0tab(:,139),[17,14],[0,0],2,2,wf4(:,9),wf12(:,24))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,9),G0H12(6),m3h4x12(:,27),heltab2x48(:,:,118))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(140),h0tab(:,140),[24,7],[0,0],2,2,wf4(:,5),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,28),heltab2x48(:,:,119))
  call Hloop_Q_A(ntryL,G0H12(7),24,0,G1H12(24),n2h12(37))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(141),h0tab(:,141),[24,7],[nMT,nMT],2,2,wf4(:,5),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,29),heltab2x48(:,:,120))
  call Hloop_Q_A(ntryL,G0H12(7),24,nMT,G1H12(16),n2h12(38))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(142),h0tab(:,142),[24,7],[0,0],2,2,wf4(:,5),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,30),heltab2x48(:,:,121))
  call Hloop_Q_A(ntryL,G0H12(7),24,0,G1H12(2),n2h12(39))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(143),h0tab(:,143),[24,7],[nMB,nMB],2,2,wf4(:,5),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,31),heltab2x48(:,:,122))
  call Hloop_Q_A(ntryL,G0H12(7),24,nMB,G1H12(10),n2h12(40))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(144),h0tab(:,144),[24,7],[0,0],2,2,wf4(:,5),wf12(:,4))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf4(:,5),24,G1H12(19),m3h4x12(:,32),heltab2x48(:,:,123))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(145),h0tab(:,145),[24,7],[0,0],2,2,wf4(:,5),wf12(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf4(:,5),24,G1H12(23),m3h4x12(:,33),heltab2x48(:,:,124))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(146),h0tab(:,146),[25,6],[0,0],2,2,wf8(:,16),wf6(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf8(:,16),G0H6(6),m3h8x6(:,12),heltab2x48(:,:,125))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(147),h0tab(:,147),[18,13],[0,0],2,2,wf4(:,4),wf12(:,27))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,4),G0H12(7),m3h4x12(:,34),heltab2x48(:,:,126))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(148),h0tab(:,148),[22,9],[0,0],2,2,wf12(:,26),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,26),G0H4(2),m3h12x4(:,11),heltab2x48(:,:,127))
  call Hloop_Q_A(ntryL,G0H4(2),22,0,G1H4(18),n2h4(41))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(149),h0tab(:,149),[21,10],[0,0],2,2,wf12(:,30),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,30),G0H4(3),m3h12x4(:,12),heltab2x48(:,:,128))
  call Hloop_A_Q(ntryL,G0H4(3),21,0,G1H4(1),n2h4(42))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(150),h0tab(:,150),[17,14],[0,0],2,2,wf4(:,9),wf12(:,29))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,9),G0H12(10),m3h4x12(:,35),heltab2x48(:,:,129))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(6),[G0H2(5),G0H2(4),G0H2(3),G0H2(2),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G0H12(3),G0H12(2),G0H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(23),[G0H12(4),G0H12(5),G0H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(29),[G1H6(24),G1H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(9),[G1H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(35),[G1H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(24)])
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(6),23,ex4(:),8,G1tensor(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H24(3),ex4(:),wf12(:,3),G1tensor(31),m4h2x12x1(:,1),heltab3x24(:,:,1))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H24(5),wf12(:,3),ex4(:),G1tensor(61),m4h12x2x1(:,1),heltab3x24(:,:,2))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H24(18),ex4(:),wf12(:,3),G1tensor(12),m4h2x12x1(:,2),heltab3x24(:,:,3))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(4),24,wf12(:,3),7,G2tensor(169),m3h12x1(:,9),heltab2x12(:,:,82))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H24(20),ex4(:),wf12(:,4),G1tensor(30),m4h2x12x1(:,3),heltab3x24(:,:,4))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H24(1),wf12(:,4),ex4(:),G1tensor(42),m4h12x2x1(:,2),heltab3x24(:,:,5))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H24(2),ex4(:),wf12(:,4),G1tensor(54),m4h2x12x1(:,4),heltab3x24(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(23),24,wf12(:,4),7,G2tensor(124),m3h12x1(:,10),heltab2x12(:,:,83))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(1),wf4(:,2),G1tensor(68),m3h4x1(:,19),heltab2x4(:,:,66))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(29),wf6(:,2),G1tensor(11),m3h6x1(:,23),heltab2x6(:,:,93))
  call Hloop_VA_Q(ntryL,G0H12(1),wf12(:,20),G0H1(1),m3h12x1(:,11),heltab2x12(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(10),n2h1(209))
  call Hloop_QV_A(ntryL,G1H12(9),wf12(:,3),G1H1(1),m3h12x1(:,12),heltab2x12(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(175),n2h1(210))
  call Hloop_QV_A(ntryL,G1H12(3),wf12(:,3),G1H1(1),m3h12x1(:,13),heltab2x12(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(178),n2h1(211))
  call Hloop_QV_A(ntryL,G1H12(11),wf12(:,3),G1H1(1),m3h12x1(:,14),heltab2x12(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(181),n2h1(212))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(13),24,wf12(:,3),7,G2tensor(184),m3h12x1(:,15),heltab2x12(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(35),wf6(:,4),G1tensor(17),m3h6x1(:,24),heltab2x6(:,:,94))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(18),wf4(:,7),G1tensor(23),m3h4x1(:,20),heltab2x4(:,:,67))
  call Hloop_VQ_A(ntryL,G0H12(6),wf12(:,24),G0H1(1),m3h12x1(:,16),heltab2x12(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(58),n2h1(213))
  call Hloop_QV_A(ntryL,G1H12(2),wf12(:,4),G1H1(1),m3h12x1(:,17),heltab2x12(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(164),n2h1(214))
  call Hloop_QV_A(ntryL,G1H12(16),wf12(:,4),G1H1(1),m3h12x1(:,18),heltab2x12(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(8),n2h1(215))
  call Hloop_QV_A(ntryL,G1H12(10),wf12(:,4),G1H1(1),m3h12x1(:,19),heltab2x12(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(134),n2h1(216))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(19),24,wf12(:,4),7,G2tensor(9),m3h12x1(:,20),heltab2x12(:,:,93))
  call Hloop_VQ_A(ntryL,G0H6(6),wf6(:,4),G0H1(1),m3h6x1(:,25),heltab2x6(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(57),n2h1(217))
  call Hloop_VA_Q(ntryL,G0H12(7),wf12(:,27),G0H1(1),m3h12x1(:,21),heltab2x12(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(69),n2h1(218))
  call Hloop_VQ_A(ntryL,G0H12(10),wf12(:,29),G0H1(1),m3h12x1(:,22),heltab2x12(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(76),n2h1(219))
  call ol_merge_tensors(G0tensor(162),[G0tensor(14),G0tensor(9),G0tensor(120),G0tensor(33),G0tensor(54),G0tensor(73),G0tensor(148) &
    ,G0tensor(193),G0tensor(126),G0tensor(111),G0tensor(91),G0tensor(66),G0tensor(6)])
  call ol_merge_tensors(G0tensor(94),[G0tensor(93),G0tensor(78),G0tensor(158),G0tensor(15),G0tensor(170),G0tensor(100) &
    ,G0tensor(52),G0tensor(2),G0tensor(206),G0tensor(86),G0tensor(46),G0tensor(31),G0tensor(11)])
  call ol_merge_tensors(G1tensor(57),[G1tensor(17),G0tensor(207),G0tensor(34),G0tensor(45),G0tensor(130),G0tensor(110) &
    ,G0tensor(63),G0tensor(96),G0tensor(16)])
  call ol_merge_tensors(G0tensor(83),[G0tensor(185),G0tensor(4),G0tensor(85),G0tensor(37),G0tensor(186),G0tensor(166) &
    ,G0tensor(146),G0tensor(106),G0tensor(71),G0tensor(51),G0tensor(26)])
  call ol_merge_tensors(G1tensor(11),[G0tensor(157),G0tensor(75),G0tensor(19),G0tensor(95),G0tensor(58),G0tensor(13),G0tensor(56) &
    ,G0tensor(36)])
  call ol_merge_tensors(G0tensor(44),[G0tensor(35),G0tensor(3),G0tensor(67),G0tensor(116),G0tensor(76)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(89),G0tensor(103),G0tensor(167),G0tensor(50),G0tensor(152),G0tensor(205) &
    ,G0tensor(53),G0tensor(172),G0tensor(155),G0tensor(87),G0tensor(151),G0tensor(131)])
  call ol_merge_tensors(G1tensor(68),[G0tensor(102),G0tensor(8),G0tensor(195),G0tensor(107),G0tensor(142),G0tensor(57) &
    ,G0tensor(127),G0tensor(136)])
  call ol_merge_tensors(G1tensor(23),[G0tensor(192),G0tensor(125),G0tensor(180),G0tensor(5),G0tensor(143),G0tensor(17) &
    ,G0tensor(208),G0tensor(156)])
  call ol_merge_tensors(G0tensor(74),[G0tensor(49),G0tensor(65),G0tensor(133),G0tensor(62),G0tensor(171)])
  call ol_merge_tensors(G1tensor(69),[G1tensor(10),G0tensor(197),G0tensor(24),G0tensor(30),G0tensor(7),G0tensor(92),G0tensor(203) &
    ,G0tensor(176)])
  call ol_merge_tensors(G1tensor(76),[G1tensor(58),G0tensor(119),G0tensor(178),G0tensor(147),G0tensor(70),G0tensor(128) &
    ,G0tensor(32),G0tensor(191)])
  call ol_merge_tensors(G1tensor(54),[G1tensor(42),G1tensor(30),G1tensor(12),G1tensor(61),G1tensor(31),G0tensor(138),G0tensor(98) &
    ,G0tensor(64),G0tensor(18),G0tensor(43),G0tensor(28),G0tensor(23),G0tensor(48),G0tensor(38),G0tensor(12),G0tensor(196)])
  call ol_merge_tensors(G0tensor(97),[G0tensor(137),G0tensor(200),G0tensor(80),G0tensor(82),G0tensor(47),G0tensor(123)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(164),G2tensor(184),G2tensor(175),G2tensor(124),G2tensor(169),G0tensor(202) &
    ,G0tensor(165),G0tensor(160),G0tensor(187),G0tensor(150),G0tensor(20),G0tensor(175)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(178),G0tensor(99)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(181),G0tensor(168)])
call TI_bubble_red(G2tensor(9),24,mass2set(:,1),G0tensor(173),M2L1R1)
call TI_bubble_red(G2tensor(8),24,mass2set(:,2),G0tensor(122),M2L1R1,G0tensor(114))
call TI_bubble_red(G2tensor(134),24,mass2set(:,3),G0tensor(164),M2L1R1,G0tensor(159))
  call ol_merge_tensors(G0tensor(104),[G0tensor(114)])
  call ol_merge_tensors(G0tensor(194),[G0tensor(159)])
call TI_bubble_red(G1tensor(57),25,mass2set(:,1),G0tensor(154),M2L1R1)
call TI_bubble_red(G1tensor(11),26,mass2set(:,1),G0tensor(149),M2L1R1)
call TI_bubble_red(G1tensor(1),23,mass2set(:,1),G0tensor(139),M2L1R1)
call TI_bubble_red(G1tensor(68),21,mass2set(:,1),G0tensor(134),M2L1R1)
call TI_bubble_red(G1tensor(23),22,mass2set(:,1),G0tensor(179),M2L1R1)
call TI_bubble_red(G1tensor(69),18,mass2set(:,1),G0tensor(153),M2L1R1)
call TI_bubble_red(G1tensor(76),17,mass2set(:,1),G0tensor(144),M2L1R1)
call TI_bubble_red(G1tensor(54),16,mass2set(:,1),G0tensor(209),M2L1R1)
  call ol_merge_tensors(T0sum(90),[G0tensor(162)])
  call ol_merge_tensors(T0sum(91),[G0tensor(94)])
  call ol_merge_tensors(T0sum(92),[G0tensor(154)])
  call ol_merge_tensors(T0sum(93),[G0tensor(83)])
  call ol_merge_tensors(T0sum(94),[G0tensor(149)])
  call ol_merge_tensors(T0sum(95),[G0tensor(44)])
  call ol_merge_tensors(T0sum(96),[G0tensor(139)])
  call ol_merge_tensors(T0sum(97),[G0tensor(134)])
  call ol_merge_tensors(T0sum(98),[G0tensor(179)])
  call ol_merge_tensors(T0sum(99),[G0tensor(74)])
  call ol_merge_tensors(T0sum(100),[G0tensor(153)])
  call ol_merge_tensors(T0sum(101),[G0tensor(144)])
  call ol_merge_tensors(T0sum(102),[G0tensor(209)])
  call ol_merge_tensors(T0sum(103),[G0tensor(97)])
  call ol_merge_tensors(T0sum(104),[G0tensor(173)])
  call ol_merge_tensors(T0sum(105),[G0tensor(122)])
  call ol_merge_tensors(T0sum(106),[G0tensor(104)])
  call ol_merge_tensors(T0sum(107),[G0tensor(124)])
  call ol_merge_tensors(T0sum(108),[G0tensor(109)])
  call ol_merge_tensors(T0sum(109),[G0tensor(164)])
  call ol_merge_tensors(T0sum(110),[G0tensor(194)])
  call ol_merge_tensors(T0sum(111),[G0tensor(117)])
  call ol_merge_tensors(T0sum(112),[G0tensor(113)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 17, 21, 29 ],masses2_9,RedSet_4(10),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 29 ],masses2_9,RedSet_4(11),ScalarBoxes(2))
  call compute_scalar_box([ 16, 17, 29 ],masses2_9,RedSet_4(1),ScalarBoxes(3))
  call compute_scalar_box([ 16, 17, 21 ],masses2_9,RedSet_4(2),ScalarBoxes(4))
  call compute_scalar_box([ 1, 5, 13 ],masses2_9,RedSet_4(12),ScalarBoxes(5))
  call compute_scalar_box([ 17, 25, 29 ],masses2_9,RedSet_4(13),ScalarBoxes(6))
  call compute_scalar_box([ 16, 25, 29 ],masses2_9,RedSet_4(14),ScalarBoxes(7))
  call compute_scalar_box([ 16, 17, 25 ],masses2_9,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 1, 9, 13 ],masses2_9,RedSet_4(15),ScalarBoxes(9))
  call compute_scalar_box([ 18, 22, 23 ],masses2_9,RedSet_4(16),ScalarBoxes(10))
  call compute_scalar_box([ 16, 22, 23 ],masses2_9,RedSet_4(17),ScalarBoxes(11))
  call compute_scalar_box([ 16, 18, 23 ],masses2_9,RedSet_4(18),ScalarBoxes(12))
  call compute_scalar_box([ 16, 18, 22 ],masses2_9,RedSet_4(4),ScalarBoxes(13))
  call compute_scalar_box([ 2, 6, 7 ],masses2_9,RedSet_4(19),ScalarBoxes(14))
  call compute_scalar_box([ 17, 21, 23 ],masses2_9,RedSet_4(20),ScalarBoxes(15))
  call compute_scalar_box([ 16, 21, 23 ],masses2_9,RedSet_4(21),ScalarBoxes(16))
  call compute_scalar_box([ 16, 17, 23 ],masses2_9,RedSet_4(22),ScalarBoxes(17))
  call compute_scalar_box([ 1, 5, 7 ],masses2_9,RedSet_4(23),ScalarBoxes(18))
  call compute_scalar_box([ 20, 21, 23 ],masses2_9,RedSet_4(24),ScalarBoxes(19))
  call compute_scalar_box([ 16, 20, 23 ],masses2_9,RedSet_4(25),ScalarBoxes(20))
  call compute_scalar_box([ 16, 20, 21 ],masses2_9,RedSet_4(5),ScalarBoxes(21))
  call compute_scalar_box([ 4, 5, 7 ],masses2_9,RedSet_4(26),ScalarBoxes(22))
  call compute_scalar_box([ 18, 19, 23 ],masses2_9,RedSet_4(27),ScalarBoxes(23))
  call compute_scalar_box([ 16, 19, 23 ],masses2_9,RedSet_4(28),ScalarBoxes(24))
  call compute_scalar_box([ 16, 18, 19 ],masses2_9,RedSet_4(6),ScalarBoxes(25))
  call compute_scalar_box([ 2, 3, 7 ],masses2_9,RedSet_4(29),ScalarBoxes(26))
  call compute_scalar_box([ 20, 22, 23 ],masses2_9,RedSet_4(30),ScalarBoxes(27))
  call compute_scalar_box([ 16, 20, 22 ],masses2_9,RedSet_4(7),ScalarBoxes(28))
  call compute_scalar_box([ 4, 6, 7 ],masses2_9,RedSet_4(31),ScalarBoxes(29))
  call compute_scalar_box([ 18, 19, 27 ],masses2_9,RedSet_4(32),ScalarBoxes(30))
  call compute_scalar_box([ 16, 19, 27 ],masses2_9,RedSet_4(33),ScalarBoxes(31))
  call compute_scalar_box([ 16, 18, 27 ],masses2_9,RedSet_4(34),ScalarBoxes(32))
  call compute_scalar_box([ 2, 3, 11 ],masses2_9,RedSet_4(35),ScalarBoxes(33))
  call compute_scalar_box([ 17, 19, 23 ],masses2_9,RedSet_4(36),ScalarBoxes(34))
  call compute_scalar_box([ 16, 17, 19 ],masses2_9,RedSet_4(8),ScalarBoxes(35))
  call compute_scalar_box([ 1, 3, 7 ],masses2_9,RedSet_4(37),ScalarBoxes(36))
  call compute_scalar_box([ 17, 19, 27 ],masses2_9,RedSet_4(38),ScalarBoxes(37))
  call compute_scalar_box([ 16, 17, 27 ],masses2_9,RedSet_4(39),ScalarBoxes(38))
  call compute_scalar_box([ 1, 3, 11 ],masses2_9,RedSet_4(40),ScalarBoxes(39))
  call compute_scalar_box([ 18, 26, 27 ],masses2_9,RedSet_4(41),ScalarBoxes(40))
  call compute_scalar_box([ 16, 26, 27 ],masses2_9,RedSet_4(42),ScalarBoxes(41))
  call compute_scalar_box([ 16, 18, 26 ],masses2_9,RedSet_4(9),ScalarBoxes(42))
  call compute_scalar_box([ 2, 10, 11 ],masses2_9,RedSet_4(43),ScalarBoxes(43))
  call compute_scalar_box([ 17, 25, 27 ],masses2_9,RedSet_4(44),ScalarBoxes(44))
  call compute_scalar_box([ 16, 25, 27 ],masses2_9,RedSet_4(45),ScalarBoxes(45))
  call compute_scalar_box([ 1, 9, 11 ],masses2_9,RedSet_4(46),ScalarBoxes(46))
! end of process


end subroutine vamp_2

end module ol_vamp_2_ppwjj_uxdwxgg_1_/**/REALKIND
