
module ol_colourmatrix_ppwjj_uuxuxdwx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(34,2), K2(34,2), KL(34,2), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   3]
  K1( 2,:) = [   3,   9]
  K1( 3,:) = [  12,   4]
  K1( 4,:) = [   4,  12]
  K1( 5,:) = [   0,  -4]
  K1( 6,:) = [  -4, -12]
  K1( 7,:) = [  12,   4]
  K1( 8,:) = [   4,  12]
  K1( 9,:) = [ -12,  -4]
  K1(10,:) = [  -4,   0]
  K1(11,:) = [   0,   4]
  K1(12,:) = [   4,   0]
  K1(13,:) = [  12,   4]
  K1(14,:) = [   4,  12]
  K1(15,:) = [   0,   4]
  K1(16,:) = [   4,   0]
  K1(17,:) = [ -12,  -4]
  K1(18,:) = [  -4,   0]
  K1(19,:) = [   0,  -4]
  K1(20,:) = [  -4, -12]
  K1(21,:) = [  12,   4]
  K1(22,:) = [   4,  12]
  K1(23,:) = [   0,   0]
  K1(24,:) = [   0,   0]
  K1(25,:) = [   0,   0]
  K1(26,:) = [   0,   0]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [   0,   0]
  K1(32,:) = [   0,   0]
  K1(33,:) = [   0,   0]
  K1(34,:) = [   0,   0]

  K2( 1,:) = [   9,   3]
  K2( 2,:) = [   3,   9]
  K2( 3,:) = [  12,   4]
  K2( 4,:) = [   4,  12]
  K2( 5,:) = [   0,  -4]
  K2( 6,:) = [  -4, -12]
  K2( 7,:) = [  12,   4]
  K2( 8,:) = [   4,  12]
  K2( 9,:) = [ -12,  -4]
  K2(10,:) = [  -4,   0]
  K2(11,:) = [   0,   4]
  K2(12,:) = [   4,   0]
  K2(13,:) = [  12,   4]
  K2(14,:) = [   4,  12]
  K2(15,:) = [   0,   4]
  K2(16,:) = [   4,   0]
  K2(17,:) = [ -12,  -4]
  K2(18,:) = [  -4,   0]
  K2(19,:) = [   0,  -4]
  K2(20,:) = [  -4, -12]
  K2(21,:) = [  12,   4]
  K2(22,:) = [   4,  12]
  K2(23,:) = [   0,   0]
  K2(24,:) = [   0,   0]
  K2(25,:) = [   0,   0]
  K2(26,:) = [   0,   0]
  K2(27,:) = [   0,   0]
  K2(28,:) = [   0,   0]
  K2(29,:) = [   0,   0]
  K2(30,:) = [   0,   0]
  K2(31,:) = [   0,   0]
  K2(32,:) = [   0,   0]
  K2(33,:) = [   0,   0]
  K2(34,:) = [   0,   0]

  KL( 1,:) = [   9,   3]
  KL( 2,:) = [   3,   9]
  KL( 3,:) = [  12,   4]
  KL( 4,:) = [   4,  12]
  KL( 5,:) = [   0,  -4]
  KL( 6,:) = [  -4, -12]
  KL( 7,:) = [  12,   4]
  KL( 8,:) = [   4,  12]
  KL( 9,:) = [ -12,  -4]
  KL(10,:) = [  -4,   0]
  KL(11,:) = [   0,   4]
  KL(12,:) = [   4,   0]
  KL(13,:) = [  12,   4]
  KL(14,:) = [   4,  12]
  KL(15,:) = [   0,   4]
  KL(16,:) = [   4,   0]
  KL(17,:) = [ -12,  -4]
  KL(18,:) = [  -4,   0]
  KL(19,:) = [   0,  -4]
  KL(20,:) = [  -4, -12]
  KL(21,:) = [  12,   4]
  KL(22,:) = [   4,  12]
  KL(23,:) = [   0,   0]
  KL(24,:) = [   0,   0]
  KL(25,:) = [   0,   0]
  KL(26,:) = [   0,   0]
  KL(27,:) = [   0,   0]
  KL(28,:) = [   0,   0]
  KL(29,:) = [   0,   0]
  KL(30,:) = [   0,   0]
  KL(31,:) = [   0,   0]
  KL(32,:) = [   0,   0]
  KL(33,:) = [   0,   0]
  KL(34,:) = [   0,   0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+2*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppwjj_uuxuxdwx_1_/**/REALKIND



module ol_forced_parameters_ppwjj_uuxuxdwx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppwjj_uuxuxdwx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppwjj_uuxuxdwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 48 ! number of helicity configurations
  integer(intkind2), save :: nhel = 48 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 48 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(48) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(30)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,6), wf6(6,15), wf8(8,16), wf12(12,4), wf48(48,24)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(9), c(17)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppwjj_uuxuxdwx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppwjj_uuxuxdwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppwjj_uuxuxdwx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(1) = (CI*eQED*gQCD**2)/(sqrt2*sw)
    f(2) = (CI*countertermnorm*eQED*gQCD**4)/(sqrt2*sw)
    f(3) = (CI*countertermnorm*ctGqq*eQED*gQCD**4)/(sqrt2*sw)
    f(4) = (CI*countertermnorm*ctVqq*eQED*gQCD**4)/(sqrt2*sw)
    f(5) = (CI*eQED*gQCD**4*integralnorm*SwB)/(sqrt2*sw)
    f(6) = (eQED*gQCD**4*integralnorm*SwB)/(sqrt2*sw*2._/**/REALKIND)
    f(7) = (eQED*gQCD**4*integralnorm*SwB)/(sqrt2*sw)
    f(8) = (eQED*gQCD**4*integralnorm*SwF)/(sqrt2*sw)
    f(9) = (2*eQED*gQCD**4*integralnorm*SwF)/(sqrt2*sw)

  c = [ 9*CI*f(5), 27*CI*f(5), 18*f(6), 54*f(6), f(7), 3*f(7), 6*f(7), 8*f(7), 10*f(7), 18*f(7), 21*f(7), 24*f(7), 54*f(7), 3*f(8) &
    , 9*f(8), 3*f(9), 9*f(9) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,20))+L(6,20))
  den(4) = 1 /((L(5,24))+L(6,24))
  den(6) = 1 /((L(5,5))+L(6,5))
  den(7) = 1 /((L(5,18))+L(6,18))
  den(10) = 1 /((L(5,28))+L(6,28))
  den(13) = 1 /((L(5,11))+L(6,11))
  den(18) = 1 /((L(5,7))+L(6,7))
  den(21) = 1 /((L(5,26))+L(6,26))
  den(24) = 1 /((L(5,13))+L(6,13))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(8) = den(6)*den(7)
  den(9) = den(4)*den(6)
  den(11) = den(2)*den(10)
  den(12) = den(1)*den(11)
  den(14) = den(1)*den(13)
  den(15) = den(2)*den(14)
  den(16) = den(4)*den(10)
  den(17) = den(1)*den(16)
  den(19) = den(1)*den(18)
  den(20) = den(4)*den(19)
  den(22) = den(7)*den(21)
  den(23) = den(6)*den(22)
  den(25) = den(6)*den(24)
  den(26) = den(7)*den(25)
  den(27) = den(4)*den(21)
  den(28) = den(6)*den(27)
  den(29) = den(6)*den(18)
  den(30) = den(4)*den(29)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppwjj_uuxuxdwx_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,24))
  allocate(M1helarray(2,hel_states))
  allocate(M1helarray_ct(2,hel_states))
  allocate(M0_col1_helarray(2,hel_states))
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(2,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppwjj_uuxuxdwx_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-up anti-up down W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppwjj_uuxuxdwx_1, only: hel_mem_opt
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppwjj_uuxuxdwx_1, only: &
    & external_perm_ppwjj_uuxuxdwx_1, &
    & external_perm_inv_ppwjj_uuxuxdwx_1, &
    & extcomb_perm_ppwjj_uuxuxdwx_1, &
    & average_factor_ppwjj_uuxuxdwx_1, &
    & photonid_ppwjj_uuxuxdwx_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppwjj_uuxuxdwx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppwjj_uuxuxdwx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppwjj_uuxuxdwx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppwjj_uuxuxdwx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(2), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(24)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,24))
  end if

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppwjj_uuxuxdwx_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_Q(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMW, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AW_Q(ntry, ex3(:), ex5(:), wf6(:,1), n3(:,2), t3x6(:,:,1))
  call prop_A_Q(ntry, wf6(:,1), 20, ZERO, 0_intkind1, wf6(:,2), n2(1))
  call vert_VQ_A(ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_WQ_A(ntry, ex5(:), ex4(:), wf6(:,3), n3(:,4), t3x6(:,:,2))
  call prop_Q_A(ntry, wf6(:,3), 24, ZERO, 0_intkind1, wf6(:,4), n2(2))
  call vert_AV_Q(ntry, ex3(:), wf4(:,1), wf8(:,2), n3(:,5), t3x8(:,:,2))
  call vert_QA_V(ntry, ex1(:), ex3(:), wf4(:,2), n3(:,6), t3x4(:,:,2))
  call vert_AW_Q(ntry, ex2(:), ex5(:), wf6(:,5), n3(:,7), t3x6(:,:,3))
  call prop_A_Q(ntry, wf6(:,5), 18, ZERO, 0_intkind1, wf6(:,6), n2(3))
  call vert_VQ_A(ntry, wf4(:,2), ex4(:), wf8(:,3), n3(:,8), t3x8(:,:,3))
  call vert_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,4), n3(:,9), t3x8(:,:,4))
  call counter_VQ_A(ntry, wf4(:,1), ex4(:), wf8(:,5), n3(:,10), t3x8(:,:,5))
  call counter_WQ_A(ntry, ex5(:), ex4(:), wf6(:,7), n3(:,11), t3x6(:,:,4))
  call prop_Q_A(ntry, wf6(:,7), 24, ZERO, 0_intkind1, wf6(:,8), n2(4))
  call counter_AV_Q(ntry, ex3(:), wf4(:,1), wf8(:,6), n3(:,12), t3x8(:,:,6))
  call counter_AW_Q(ntry, ex3(:), ex5(:), wf6(:,9), n3(:,13), t3x6(:,:,5))
  call prop_A_Q(ntry, wf6(:,9), 20, ZERO, 0_intkind1, wf6(:,10), n2(5))
  call counter_VQ_A(ntry, wf4(:,2), ex4(:), wf8(:,7), n3(:,14), t3x8(:,:,7))
  call counter_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,8), n3(:,15), t3x8(:,:,8))
  call counter_AW_Q(ntry, ex2(:), ex5(:), wf6(:,11), n3(:,16), t3x6(:,:,6))
  call prop_A_Q(ntry, wf6(:,11), 18, ZERO, 0_intkind1, wf6(:,12), n2(6))
  call counter_QA_V(ntry, ex1(:), ex3(:), wf4(:,3), n3(:,17), t3x4(:,:,3))
  call vert_VQ_A(ntry, wf4(:,3), ex4(:), wf8(:,9), n3(:,18), t3x8(:,:,9))
  call vert_AV_Q(ntry, ex2(:), wf4(:,3), wf8(:,10), n3(:,19), t3x8(:,:,10))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,4), n3(:,20), t3x4(:,:,4))
  call vert_VQ_A(ntry, wf4(:,4), ex4(:), wf8(:,11), n3(:,21), t3x8(:,:,11))
  call vert_AV_Q(ntry, ex3(:), wf4(:,4), wf8(:,12), n3(:,22), t3x8(:,:,12))
  call vert_QA_V(ntry, ex4(:), wf6(:,2), wf12(:,1), n3(:,23), t3x12(:,:,1))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 3, wf4(:,5), n2(7))
  call counter_A_Q(ctqq,1,ntry, wf6(:,2), 20, wf6(:,13), n2(8))
  call prop_Q_A(ntry, wf8(:,1), 11, ZERO, 0_intkind1, wf8(:,13), n2(9))
  call vert_QA_V(ntry, wf6(:,4), ex3(:), wf12(:,2), n3(:,24), t3x12(:,:,2))
  call counter_Q_A(ctqq,2,ntry, wf6(:,4), 24, wf6(:,14), n2(10))
  call prop_A_Q(ntry, wf8(:,2), 7, ZERO, 0_intkind1, wf8(:,14), n2(11))
  call vert_QA_V(ntry, ex4(:), wf6(:,6), wf12(:,3), n3(:,25), t3x12(:,:,3))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 5, wf4(:,6), n2(12))
  call counter_A_Q(ctqq,1,ntry, wf6(:,6), 18, wf6(:,15), n2(13))
  call prop_Q_A(ntry, wf8(:,3), 13, ZERO, 0_intkind1, wf8(:,15), n2(14))
  call vert_QA_V(ntry, wf6(:,4), ex2(:), wf12(:,4), n3(:,26), t3x12(:,:,4))
  call prop_A_Q(ntry, wf8(:,4), 7, ZERO, 0_intkind1, wf8(:,16), n2(15))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppwjj_uuxuxdwx_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

#if 1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
  ind_cc_comb = [8,12,9,13,14]
  M0M1_hel_cc(:,:,:)%j = 0
  M2ctcc = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf6(:,2), wf8(:,1), A(:,1), n3(:,27), t3x48(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,2), A(:,2), n3(:,28), t3x48(:,:,2), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,6), wf8(:,3), A(:,3), n3(:,29), t3x48(:,:,3), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,4), A(:,4), n3(:,30), t3x48(:,:,4), nhel, den(9))

    call Hcont_QA(nsync, wf6(:,2), wf8(:,5), A(:,5), n3(:,31), t3x48(:,:,5), nhel, den(3))
    call Hcont_QA(nsync, wf8(:,2), wf6(:,8), A(:,6), n3(:,32), t3x48(:,:,6), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,6), A(:,7), n3(:,33), t3x48(:,:,7), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,1), wf6(:,10), A(:,8), n3(:,34), t3x48(:,:,8), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,6), wf8(:,7), A(:,9), n3(:,35), t3x48(:,:,9), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf6(:,8), A(:,10), n3(:,36), t3x48(:,:,10), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,8), A(:,11), n3(:,37), t3x48(:,:,11), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,12), A(:,12), n3(:,38), t3x48(:,:,12), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,6), wf8(:,9), A(:,13), n3(:,39), t3x48(:,:,13), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,10), A(:,14), n3(:,40), t3x48(:,:,14), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,11), A(:,15), n3(:,41), t3x48(:,:,15), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,12), A(:,16), n3(:,42), t3x48(:,:,16), nhel, den(5))
    call Hcont_VV(nsync, wf12(:,1), wf4(:,5), A(:,17), n3(:,43), t3x48(:,:,17), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,13), wf8(:,13), A(:,18), n3(:,44), t3x48(:,:,18), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,2), A(:,19), n3(:,45), t3x48(:,:,19), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,14), wf8(:,14), A(:,20), n3(:,46), t3x48(:,:,20), nhel, den(20))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,6), A(:,21), n3(:,47), t3x48(:,:,21), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,15), wf8(:,15), A(:,22), n3(:,48), t3x48(:,:,22), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,6), wf12(:,4), A(:,23), n3(:,49), t3x48(:,:,23), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,14), wf8(:,16), A(:,24), n3(:,50), t3x48(:,:,24), nhel, den(30))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(2) ! M1helarray(2,nhel)
  integer :: empty(0), i

  M1(1)%j = ((A(j,1)%j+A(j,2)%j)*f(1))/2._/**/REALKIND+((A(j,3)%j+A(j,4)%j)*f(1))/6._/**/REALKIND
  M1(2)%j = ((-A(j,1)%j-A(j,2)%j)*f(1))/6._/**/REALKIND+((-A(j,3)%j-A(j,4)%j)*f(1))/2._/**/REALKIND

  M2(1)%j = ((-A(j,17)%j-A(j,18)%j-A(j,19)%j-A(j,20)%j)*f(2))/2._/**/REALKIND+((-A(j,21)%j-A(j,22)%j-A(j,23)%j &
       -A(j,24)%j)*f(2))/6._/**/REALKIND+((A(j,9)%j+A(j,11)%j+A(j,13)%j+A(j,14)%j)*f(3))/6._/**/REALKIND+((A(j,5)%j+A(j,7)%j &
       +A(j,15)%j+A(j,16)%j)*f(3))/2._/**/REALKIND+((A(j,6)%j+A(j,8)%j)*f(4))/2._/**/REALKIND+((A(j,10)%j &
       +A(j,12)%j)*f(4))/6._/**/REALKIND
  M2(2)%j = ((A(j,17)%j+A(j,18)%j+A(j,19)%j+A(j,20)%j)*f(2))/6._/**/REALKIND+((A(j,21)%j+A(j,22)%j+A(j,23)%j &
       +A(j,24)%j)*f(2))/2._/**/REALKIND+((-A(j,9)%j-A(j,11)%j-A(j,13)%j-A(j,14)%j)*f(3))/2._/**/REALKIND+((-A(j,5)%j-A(j,7)%j &
       -A(j,15)%j-A(j,16)%j)*f(3))/6._/**/REALKIND+((-A(j,6)%j-A(j,8)%j)*f(4))/6._/**/REALKIND+((-A(j,10)%j &
       -A(j,12)%j)*f(4))/2._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwjj_uuxuxdwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwjj_uuxuxdwx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(2), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 2
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+2*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppwjj_uuxuxdwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwjj_uuxuxdwx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppwjj_uuxuxdwx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+2*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppwjj_uuxuxdwx_1_/**/REALKIND
