
module ol_vamp_3_ppwajj_uxdawxgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwajj_uxdawxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwajj_uxdawxgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwajj_uxdawxgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwajj_uxdawxgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwajj_uxdawxgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwajj_uxdawxgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(133),n2h2(99))
  call Hloop_QV_A(ntryL,G1H4(76),ex3(:),G1H2(92),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(92),47,0,G2H2(134),n2h2(100))
  call Hloop_QV_A(ntryL,G1H4(77),ex3(:),G1H2(97),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(97),47,0,G2H2(135),n2h2(101))
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(159),mass5set(:,1),  & 
G1H6(82),G1H6(83),G1H6(338),G1H6(339),G1H6(340),G1H6(341),6)
  call HG1shiftOLR(G1H6(83),16,6)
  call Hloop_AW_Q(ntryL,G1H6(93),ex4(:),G1H2(98),m3h3x2(:,64),heltab2x6(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(98),47,0,G2H2(136),n2h2(102))
  call Hloop_AW_Q(ntryL,G1H6(94),ex4(:),G1H2(103),m3h3x2(:,65),heltab2x6(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(103),47,0,G2H2(137),n2h2(103))
  call Hloop_AW_Q(ntryL,G1H6(95),ex4(:),G1H2(104),m3h3x2(:,66),heltab2x6(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(104),47,0,G2H2(138),n2h2(104))
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(160),mass5set(:,1),  & 
G1H4(75),G1H4(76),G1H4(77),G1H4(276),G1H4(277),G1H4(278),4)
  call HG1shiftOLR(G1H4(76),16,4)
  call Hloop_AV_Q(ntryL,G1H4(88),ex3(:),G1H2(109),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(109),47,0,G2H2(139),n2h2(105))
  call Hloop_AV_Q(ntryL,G1H4(89),ex3(:),G1H2(110),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(110),47,0,G2H2(140),n2h2(106))
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(161),mass5set(:,1),  & 
G1H4(88),G1H4(89),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(89),4,4)
  call Hloop_AV_Q(ntryL,G1H4(100),ex5(:),G1H2(115),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(115),59,0,G2H2(141),n2h2(107))
  call Hloop_AV_Q(ntryL,G1H4(101),ex5(:),G1H2(116),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(116),59,0,G2H2(142),n2h2(108))
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(162),mass5set(:,1),  & 
G1H6(93),G1H6(94),G1H6(95),G1H6(342),G1H6(343),G1H6(344),6)
  call HG1shiftOLR(G1H6(94),8,6)
  call Hloop_AV_Q(ntryL,G1H6(105),ex5(:),G1H3(50),m3h2x3(:,74),heltab2x6(:,:,140))
  call Hloop_A_Q(ntryL,G1H3(50),55,0,G2H3(56),n2h3(52))
  call Hloop_AV_Q(ntryL,G1H6(106),ex5(:),G1H3(55),m3h2x3(:,75),heltab2x6(:,:,141))
  call Hloop_A_Q(ntryL,G1H3(55),55,0,G2H3(57),n2h3(53))
  call Hloop_AV_Q(ntryL,G1H6(107),ex5(:),G1H3(56),m3h2x3(:,76),heltab2x6(:,:,142))
  call Hloop_A_Q(ntryL,G1H3(56),55,0,G2H3(58),n2h3(54))
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(163),mass5set(:,1),  & 
G1H6(105),G1H6(106),G1H6(107),G1H6(345),G1H6(346),G1H6(347),6)
  call HG1shiftOLR(G1H6(106),8,6)
  call Hloop_AV_Q(ntryL,G1H6(118),ex3(:),G1H3(61),m3h2x3(:,77),heltab2x6(:,:,143))
  call Hloop_A_Q(ntryL,G1H3(61),55,0,G2H3(59),n2h3(55))
  call Hloop_AV_Q(ntryL,G1H6(203),ex3(:),G1H3(62),m3h2x3(:,78),heltab2x6(:,:,144))
  call Hloop_A_Q(ntryL,G1H3(62),55,0,G2H3(60),n2h3(56))
  call Hotf_5pt_reduction(G2H6(20),RedSet_5(164),mass5set(:,1),  & 
G1H6(118),G1H6(203),G1H6(348),G1H6(349),G1H6(350),G1H6(351),6)
  call HG1shiftOLR(G1H6(203),4,6)
  call Hloop_AW_Q(ntryL,G1H6(130),ex4(:),G1H2(121),m3h3x2(:,67),heltab2x6(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(121),59,0,G2H2(143),n2h2(109))
  call Hloop_AW_Q(ntryL,G1H6(227),ex4(:),G1H2(122),m3h3x2(:,68),heltab2x6(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(122),59,0,G2H2(144),n2h2(110))
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(165),mass5set(:,1),  & 
G1H6(130),G1H6(227),G1H6(352),G1H6(353),G1H6(354),G1H6(355),6)
  call HG1shiftOLR(G1H6(227),16,6)
  call Hotf_5pt_reduction(G2H6(24),RedSet_5(156),mass5set(:,1),  & 
G1H6(356),G1H6(357),G1H6(358),G1H6(359),G1H6(360),G1H6(361),6)
  call HG1shiftOLR(G1H6(357),16,6)
  call Hloop_QW_A(ntryL,G1H6(141),ex4(:),G1H2(127),m3h3x2(:,69),heltab2x6(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(127),47,0,G2H2(145),n2h2(111))
  call Hloop_QW_A(ntryL,G1H6(142),ex4(:),G1H2(128),m3h3x2(:,70),heltab2x6(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(128),47,0,G2H2(146),n2h2(112))
  call Hloop_QW_A(ntryL,G1H6(143),ex4(:),G1H2(133),m3h3x2(:,71),heltab2x6(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(133),47,0,G2H2(147),n2h2(113))
  call Hotf_5pt_reduction(G2H6(27),RedSet_5(166),mass5set(:,1),  & 
G1H6(141),G1H6(142),G1H6(143),G1H6(362),G1H6(363),G1H6(364),6)
  call HG1shiftOLR(G1H6(142),8,6)
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(157),mass5set(:,1),  & 
G1H6(365),G1H6(366),G1H6(367),G1H6(368),G1H6(369),G1H6(370),6)
  call HG1shiftOLR(G1H6(366),8,6)
  call Hloop_QV_A(ntryL,G1H6(153),ex5(:),G1H3(67),m3h2x3(:,79),heltab2x6(:,:,150))
  call Hloop_Q_A(ntryL,G1H3(67),55,0,G2H3(61),n2h3(57))
  call Hloop_QV_A(ntryL,G1H6(154),ex5(:),G1H3(68),m3h2x3(:,80),heltab2x6(:,:,151))
  call Hloop_Q_A(ntryL,G1H3(68),55,0,G2H3(62),n2h3(58))
  call Hloop_QV_A(ntryL,G1H6(155),ex5(:),G1H3(73),m3h2x3(:,81),heltab2x6(:,:,152))
  call Hloop_Q_A(ntryL,G1H3(73),55,0,G2H3(63),n2h3(59))
  call Hotf_5pt_reduction(G2H4(69),RedSet_5(167),mass5set(:,1),  & 
G1H4(100),G1H4(101),G1H4(283),G1H4(284),G1H4(285),G1H4(286),4)
  call HG1shiftOLR(G1H4(101),16,4)
  call Hotf_5pt_reduction(G2H4(73),RedSet_5(160),mass5set(:,1),  & 
G1H4(287),G1H4(288),G1H4(289),G1H4(290),G1H4(291),G1H4(292),4)
  call HG1shiftOLR(G1H4(288),16,4)
  call Hloop_QV_A(ntryL,G1H4(111),ex3(:),G1H2(134),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(134),47,0,G2H2(148),n2h2(114))
  call Hloop_QV_A(ntryL,G1H4(112),ex3(:),G1H2(139),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(139),47,0,G2H2(149),n2h2(115))
  call Hloop_QV_A(ntryL,G1H4(113),ex3(:),G1H2(140),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(140),47,0,G2H2(150),n2h2(116))
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(168),mass5set(:,1),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(293),G1H4(294),G1H4(295),4)
  call HG1shiftOLR(G1H4(112),4,4)
  call Hotf_5pt_reduction(G2H4(77),RedSet_5(161),mass5set(:,1),  & 
G1H4(296),G1H4(297),G1H4(298),G1H4(299),G1H4(300),G1H4(301),4)
  call HG1shiftOLR(G1H4(297),4,4)
  call Hloop_QV_A(ntryL,G1H4(123),ex5(:),G1H2(13),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(13),59,0,G2H2(151),n2h2(117))
  call Hloop_QV_A(ntryL,G1H4(124),ex5(:),G1H2(14),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(14),59,0,G2H2(152),n2h2(118))
  call Hloop_QV_A(ntryL,G1H4(125),ex5(:),G1H2(19),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(19),59,0,G2H2(153),n2h2(119))
  call Hotf_5pt_reduction(G2H6(30),RedSet_5(169),mass5set(:,1),  & 
G1H6(153),G1H6(154),G1H6(155),G1H6(371),G1H6(372),G1H6(373),6)
  call HG1shiftOLR(G1H6(154),8,6)
  call Hotf_5pt_reduction(G2H6(32),RedSet_5(163),mass5set(:,1),  & 
G1H6(374),G1H6(375),G1H6(376),G1H6(377),G1H6(378),G1H6(379),6)
  call HG1shiftOLR(G1H6(375),8,6)
  call Hloop_QV_A(ntryL,G1H6(165),ex3(:),G1H3(74),m3h2x3(:,82),heltab2x6(:,:,153))
  call Hloop_Q_A(ntryL,G1H3(74),55,0,G2H3(64),n2h3(60))
  call Hloop_QV_A(ntryL,G1H6(166),ex3(:),G1H3(7),m3h2x3(:,83),heltab2x6(:,:,154))
  call Hloop_Q_A(ntryL,G1H3(7),55,0,G2H3(65),n2h3(61))
  call Hloop_QV_A(ntryL,G1H6(239),ex3(:),G1H3(8),m3h2x3(:,84),heltab2x6(:,:,155))
  call Hloop_Q_A(ntryL,G1H3(8),55,0,G2H3(66),n2h3(62))
  call Hotf_5pt_reduction(G2H6(33),RedSet_5(170),mass5set(:,1),  & 
G1H6(165),G1H6(166),G1H6(239),G1H6(380),G1H6(381),G1H6(382),6)
  call HG1shiftOLR(G1H6(166),4,6)
  call Hotf_5pt_reduction(G2H6(36),RedSet_5(164),mass5set(:,1),  & 
G1H6(383),G1H6(384),G1H6(385),G1H6(386),G1H6(387),G1H6(388),6)
  call HG1shiftOLR(G1H6(384),4,6)
  call Hloop_QW_A(ntryL,G1H6(177),ex4(:),G1H2(20),m3h3x2(:,72),heltab2x6(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(20),59,0,G2H2(154),n2h2(120))
  call Hloop_QW_A(ntryL,G1H6(178),ex4(:),G1H2(25),m3h3x2(:,73),heltab2x6(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(25),59,0,G2H2(155),n2h2(121))
  call Hloop_QW_A(ntryL,G1H6(251),ex4(:),G1H2(26),m3h3x2(:,74),heltab2x6(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(26),59,0,G2H2(156),n2h2(122))
  call Hotf_5pt_reduction(G2H6(40),RedSet_5(171),mass5set(:,1),  & 
G1H6(177),G1H6(178),G1H6(251),G1H6(389),G1H6(390),G1H6(391),6)
  call HG1shiftOLR(G1H6(178),8,6)
  call Hloop_VQ_A(ntryL,G1H6(189),ex2(:),G1H3(13),m3h2x3(:,85),heltab2x6(:,:,159))
  call Hloop_Q_A(ntryL,G1H3(13),55,0,G2H3(67),n2h3(63))
  call Hloop_VQ_A(ntryL,G1H6(190),ex2(:),G1H3(14),m3h2x3(:,86),heltab2x6(:,:,160))
  call Hloop_Q_A(ntryL,G1H3(14),55,0,G2H3(68),n2h3(64))
  call Hotf_5pt_reduction(G2H6(41),RedSet_5(172),mass5set(:,1),  & 
G1H6(189),G1H6(190),G1H6(392),G1H6(393),G1H6(394),G1H6(395),6)
  call HG1shiftOLR(G1H6(190),8,6)
  call Hotf_5pt_reduction(G2H6(43),RedSet_5(173),mass5set(:,1),  & 
G1H6(396),G1H6(397),G1H6(398),G1H6(399),G1H6(400),G1H6(401),6)
  call HG1shiftOLR(G1H6(397),8,6)
  call Hloop_AV_Q(ntryL,G1H6(201),ex3(:),G1H3(19),m3h2x3(:,87),heltab2x6(:,:,161))
  call Hloop_A_Q(ntryL,G1H3(19),55,0,G2H3(69),n2h3(65))
  call Hloop_AV_Q(ntryL,G1H6(202),ex3(:),G1H3(20),m3h2x3(:,88),heltab2x6(:,:,162))
  call Hloop_A_Q(ntryL,G1H3(20),55,0,G2H3(70),n2h3(66))
  call Hotf_5pt_reduction(G2H6(48),RedSet_5(174),mass5set(:,1),  & 
G1H6(201),G1H6(202),G1H6(402),G1H6(403),G1H6(404),G1H6(405),6)
  call HG1shiftOLR(G1H6(202),8,6)
  call Hloop_VA_Q(ntryL,G1H6(213),ex1(:),G1H3(25),m3h2x3(:,89),heltab2x6(:,:,163))
  call Hloop_A_Q(ntryL,G1H3(25),55,0,G2H3(71),n2h3(67))
  call Hloop_VA_Q(ntryL,G1H6(214),ex1(:),G1H3(26),m3h2x3(:,90),heltab2x6(:,:,164))
  call Hloop_A_Q(ntryL,G1H3(26),55,0,G2H3(72),n2h3(68))
  call Hotf_5pt_reduction(G2H6(49),RedSet_5(175),mass5set(:,1),  & 
G1H6(213),G1H6(214),G1H6(406),G1H6(407),G1H6(408),G1H6(409),6)
  call HG1shiftOLR(G1H6(214),4,6)
  call Hotf_5pt_reduction(G2H6(52),RedSet_5(176),mass5set(:,1),  & 
G1H6(410),G1H6(411),G1H6(412),G1H6(413),G1H6(414),G1H6(415),6)
  call HG1shiftOLR(G1H6(411),4,6)
  call Hloop_AW_Q(ntryL,G1H6(225),ex4(:),G1H2(31),m3h3x2(:,75),heltab2x6(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(31),59,0,G2H2(157),n2h2(123))
  call Hloop_AW_Q(ntryL,G1H6(226),ex4(:),G1H2(32),m3h3x2(:,76),heltab2x6(:,:,166))
  call Hloop_A_Q(ntryL,G1H2(32),59,0,G2H2(158),n2h2(124))
  call Hotf_5pt_reduction(G2H6(53),RedSet_5(177),mass5set(:,1),  & 
G1H6(225),G1H6(226),G1H6(416),G1H6(417),G1H6(418),G1H6(419),6)
  call HG1shiftOLR(G1H6(226),8,6)
  call Hotf_5pt_reduction(G2H6(55),RedSet_5(178),mass5set(:,1),  & 
G1H6(420),G1H6(421),G1H6(422),G1H6(423),G1H6(424),G1H6(425),6)
  call HG1shiftOLR(G1H6(421),8,6)
  call Hloop_QV_A(ntryL,G1H6(237),ex3(:),G1H3(31),m3h2x3(:,91),heltab2x6(:,:,167))
  call Hloop_Q_A(ntryL,G1H3(31),55,0,G2H3(73),n2h3(69))
  call Hloop_QV_A(ntryL,G1H6(238),ex3(:),G1H3(32),m3h2x3(:,92),heltab2x6(:,:,168))
  call Hloop_Q_A(ntryL,G1H3(32),55,0,G2H3(74),n2h3(70))
  call Hotf_5pt_reduction(G2H6(56),RedSet_5(179),mass5set(:,1),  & 
G1H6(237),G1H6(238),G1H6(426),G1H6(427),G1H6(428),G1H6(429),6)
  call HG1shiftOLR(G1H6(238),4,6)
  call Hotf_5pt_reduction(G2H6(58),RedSet_5(180),mass5set(:,1),  & 
G1H6(430),G1H6(431),G1H6(432),G1H6(433),G1H6(434),G1H6(435),6)
  call HG1shiftOLR(G1H6(431),4,6)
  call Hloop_QW_A(ntryL,G1H6(249),ex4(:),G1H2(37),m3h3x2(:,77),heltab2x6(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(37),59,0,G2H2(159),n2h2(125))
  call Hloop_QW_A(ntryL,G1H6(250),ex4(:),G1H2(38),m3h3x2(:,78),heltab2x6(:,:,170))
  call Hloop_Q_A(ntryL,G1H2(38),59,0,G2H2(160),n2h2(126))
  call Hotf_5pt_reduction(G2H6(132),RedSet_5(82),mass5set(:,1),  & 
G1H6(249),G1H6(250),G1H6(436),G1H6(437),G1H6(438),G1H6(439),6)
  call HG1shiftOLR(G1H6(250),2,6)
  call Hotf_5pt_reduction(G2H6(118),RedSet_5(70),mass5set(:,1),  & 
G1H6(440),G1H6(441),G1H6(442),G1H6(443),G1H6(444),G1H6(445),6)
  call HG1shiftOLR(G1H6(441),2,6)
  call Hotf_4pt_reduction(G2H6(134),RedSet_4(6),mass4set(:,1),  & 
G1H6(446),G1H6(447),G1H6(448),G1H6(449),G1H6(450),6)
  call HG1shiftOLR(G1H6(447),2,6)
  call Hotf_4pt_reduction(G2H6(120),RedSet_4(10),mass4set(:,1),  & 
G1H6(451),G1H6(452),G1H6(453),G1H6(454),G1H6(455),6)
  call HG1shiftOLR(G1H6(452),2,6)
  call Hloop_AW_Q(ntryL,G1H6(267),ex4(:),G1H2(43),m3h3x2(:,79),heltab2x6(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(43),61,0,G2H2(161),n2h2(127))
  call Hloop_AW_Q(ntryL,G1H6(268),ex4(:),G1H2(44),m3h3x2(:,80),heltab2x6(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(44),61,0,G2H2(162),n2h2(128))
  call Hloop_AW_Q(ntryL,G1H6(286),ex4(:),G1H2(49),m3h3x2(:,81),heltab2x6(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(49),61,0,G2H2(163),n2h2(129))
  call Hotf_5pt_reduction(G2H4(198),RedSet_5(83),mass5set(:,1),  & 
G1H4(123),G1H4(124),G1H4(125),G1H4(302),G1H4(303),G1H4(304),4)
  call HG1shiftOLR(G1H4(124),2,4)
  call Hotf_5pt_reduction(G2H4(160),RedSet_5(71),mass5set(:,1),  & 
G1H4(305),G1H4(306),G1H4(307),G1H4(308),G1H4(309),G1H4(310),4)
  call HG1shiftOLR(G1H4(306),2,4)
  call Hotf_4pt_reduction(G2H4(200),RedSet_4(6),mass4set(:,1),  & 
G1H4(311),G1H4(312),G1H4(313),G1H4(314),G1H4(315),4)
  call HG1shiftOLR(G1H4(312),2,4)
  call Hotf_4pt_reduction(G2H4(162),RedSet_4(10),mass4set(:,1),  & 
G1H4(316),G1H4(317),G1H4(318),G1H4(319),G1H4(320),4)
  call HG1shiftOLR(G1H4(317),2,4)
  call Hloop_AV_Q(ntryL,G1H4(141),ex5(:),G1H2(50),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(50),61,0,G2H2(164),n2h2(130))
  call Hloop_AV_Q(ntryL,G1H4(142),ex5(:),G1H2(55),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(55),61,0,G2H2(165),n2h2(131))
  call Hloop_AV_Q(ntryL,G1H4(177),ex5(:),G1H2(56),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(56),61,0,G2H2(166),n2h2(132))
  call Hotf_5pt_reduction(G2H4(211),RedSet_5(86),mass5set(:,1),  & 
G1H4(141),G1H4(142),G1H4(177),G1H4(321),G1H4(322),G1H4(323),4)
  call HG1shiftOLR(G1H4(142),2,4)
  call Hotf_5pt_reduction(G2H4(177),RedSet_5(76),mass5set(:,1),  & 
G1H4(324),G1H4(325),G1H4(326),G1H4(327),G1H4(328),G1H4(329),4)
  call HG1shiftOLR(G1H4(325),2,4)
  call Hotf_4pt_reduction(G2H4(213),RedSet_4(30),mass4set(:,1),  & 
G1H4(330),G1H4(331),G1H4(332),G1H4(333),G1H4(334),4)
  call HG1shiftOLR(G1H4(331),2,4)
  call Hotf_4pt_reduction(G2H4(179),RedSet_4(34),mass4set(:,1),  & 
G1H4(335),G1H4(336),G1H4(337),G1H4(338),G1H4(339),4)
  call HG1shiftOLR(G1H4(336),2,4)
  call Hloop_AV_Q(ntryL,G1H4(158),ex3(:),G1H2(61),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(61),61,0,G2H2(167),n2h2(133))
  call Hloop_AV_Q(ntryL,G1H4(159),ex3(:),G1H2(62),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(62),61,0,G2H2(168),n2h2(134))
  call Hloop_AV_Q(ntryL,G1H4(194),ex3(:),G1H2(67),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(67),61,0,G2H2(169),n2h2(135))
  call Hotf_5pt_reduction(G2H4(215),RedSet_5(87),mass5set(:,1),  & 
G1H4(158),G1H4(159),G1H4(194),G1H4(340),G1H4(341),G1H4(342),4)
  call HG1shiftOLR(G1H4(159),2,4)
  call Hotf_5pt_reduction(G2H4(181),RedSet_5(77),mass5set(:,1),  & 
G1H4(343),G1H4(344),G1H4(345),G1H4(346),G1H4(347),G1H4(348),4)
  call HG1shiftOLR(G1H4(344),2,4)
  call Hotf_4pt_reduction(G2H4(217),RedSet_4(30),mass4set(:,1),  & 
G1H4(349),G1H4(350),G1H4(351),G1H4(352),G1H4(353),4)
  call HG1shiftOLR(G1H4(350),2,4)
  call Hotf_4pt_reduction(G2H4(183),RedSet_4(34),mass4set(:,1),  & 
G1H4(354),G1H4(355),G1H4(356),G1H4(357),G1H4(358),4)
  call HG1shiftOLR(G1H4(355),2,4)
  call Hloop_AV_Q(ntryL,G1H4(175),ex5(:),G1H2(68),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(68),61,0,G2H2(170),n2h2(136))
  call Hloop_AV_Q(ntryL,G1H4(176),ex5(:),G1H2(73),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_A_Q(ntryL,G1H2(73),61,0,G2H2(171),n2h2(137))
  call Hotf_5pt_reduction(G2H4(219),RedSet_5(88),mass5set(:,1),  & 
G1H4(175),G1H4(176),G1H4(359),G1H4(360),G1H4(361),G1H4(362),4)
  call HG1shiftOLR(G1H4(176),2,4)
  call Hotf_5pt_reduction(G2H4(185),RedSet_5(78),mass5set(:,1),  & 
G1H4(363),G1H4(364),G1H4(365),G1H4(366),G1H4(367),G1H4(368),4)
  call HG1shiftOLR(G1H4(364),2,4)
  call Hotf_4pt_reduction(G2H4(221),RedSet_4(48),mass4set(:,1),  & 
G1H4(369),G1H4(370),G1H4(371),G1H4(372),G1H4(373),4)
  call HG1shiftOLR(G1H4(370),2,4)
  call Hotf_4pt_reduction(G2H4(187),RedSet_4(51),mass4set(:,1),  & 
G1H4(374),G1H4(375),G1H4(376),G1H4(377),G1H4(378),4)
  call HG1shiftOLR(G1H4(375),2,4)
  call Hloop_AV_Q(ntryL,G1H4(192),ex3(:),G1H2(74),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(74),61,0,G2H2(172),n2h2(138))
  call Hloop_AV_Q(ntryL,G1H4(193),ex3(:),G1H2(79),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(79),61,0,G2H2(173),n2h2(139))
  call Hotf_5pt_reduction(G2H6(137),RedSet_5(89),mass5set(:,1),  & 
G1H6(267),G1H6(268),G1H6(286),G1H6(456),G1H6(457),G1H6(458),6)
  call HG1shiftOLR(G1H6(268),2,6)
  call Hotf_5pt_reduction(G2H6(127),RedSet_5(79),mass5set(:,1),  & 
G1H6(459),G1H6(460),G1H6(461),G1H6(462),G1H6(463),G1H6(464),6)
  call HG1shiftOLR(G1H6(460),2,6)
  call Hotf_4pt_reduction(G2H6(139),RedSet_4(48),mass4set(:,1),  & 
G1H6(465),G1H6(466),G1H6(467),G1H6(468),G1H6(469),6)
  call HG1shiftOLR(G1H6(466),2,6)
  call Hotf_4pt_reduction(G2H6(129),RedSet_4(51),mass4set(:,1),  & 
G1H6(470),G1H6(471),G1H6(472),G1H6(473),G1H6(474),6)
  call HG1shiftOLR(G1H6(471),2,6)
  call Hloop_AW_Q(ntryL,G1H6(284),ex4(:),G1H2(80),m3h3x2(:,82),heltab2x6(:,:,174))
  call Hloop_A_Q(ntryL,G1H2(80),61,0,G2H2(174),n2h2(140))
  call Hloop_AW_Q(ntryL,G1H6(285),ex4(:),G1H2(85),m3h3x2(:,83),heltab2x6(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(85),61,0,G2H2(175),n2h2(141))
  call Hloop_QA_V(ntryL,G2H4(192),ex1(:),G2H2(176),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_QA_V(ntryL,G2H4(154),ex1(:),G2H2(177),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_AQ_V(ntryL,G2H4(196),ex2(:),G2H2(178),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_AQ_V(ntryL,G2H4(158),ex2(:),G2H2(179),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_QA_V(ntryL,G2H4(204),ex1(:),G2H2(180),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_QA_V(ntryL,G2H4(166),ex1(:),G2H2(181),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_AQ_V(ntryL,G2H4(209),ex2(:),G2H2(182),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_AQ_V(ntryL,G2H4(175),ex2(:),G2H2(183),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(44),mass5set(:,1),  & 
G1H8(73),G1H8(79),G1H8(74),G1H8(77),G1H8(80),G1H8(83),8)
  call HG1shiftOLR(G1H8(79),16,8)
  call Hotf_5pt_reduction(G2H12(46),RedSet_5(56),mass5set(:,1),  & 
G1H12(106),G1H12(118),G1H12(141),G1H12(159),G1H12(177),G1H12(195),12)
  call HG1shiftOLR(G1H12(118),8,12)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(49),mass5set(:,1),  & 
G1H8(84),G1H8(17),G1H8(18),G1H8(36),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(17),16,8)
  call Hotf_5pt_reduction(G2H12(47),RedSet_5(58),mass5set(:,1),  & 
G1H12(213),G1H12(231),G1H12(1),G1H12(2),G1H12(3),G1H12(4),12)
  call HG1shiftOLR(G1H12(231),8,12)
  call Hotf_5pt_reduction(G2H12(50),RedSet_5(27),mass5set(:,1),  & 
G1H12(5),G1H12(6),G1H12(9),G1H12(7),G1H12(15),G1H12(8),12)
  call HG1shiftOLR(G1H12(6),9,12)
  call Hotf_5pt_reduction(G2H12(51),RedSet_5(50),mass5set(:,1),  & 
G1H12(22),G1H12(28),G1H12(33),G1H12(13),G1H12(40),G1H12(46),12)
  call HG1shiftOLR(G1H12(28),16,12)
  call Hotf_5pt_reduction(G2H12(53),RedSet_5(57),mass5set(:,1),  & 
G1H12(51),G1H12(14),G1H12(58),G1H12(64),G1H12(17),G1H12(70),12)
  call HG1shiftOLR(G1H12(14),4,12)
  call Hotf_5pt_reduction(G2H12(55),RedSet_5(25),mass5set(:,1),  & 
G1H12(18),G1H12(76),G1H12(19),G1H12(82),G1H12(20),G1H12(88),12)
  call HG1shiftOLR(G1H12(76),10,12)
  call Hotf_5pt_reduction(G2H12(56),RedSet_5(45),mass5set(:,1),  & 
G1H12(23),G1H12(94),G1H12(24),G1H12(100),G1H12(105),G1H12(233),12)
  call HG1shiftOLR(G1H12(94),16,12)
  call Hotf_5pt_reduction(G2H12(57),RedSet_5(59),mass5set(:,1),  & 
G1H12(111),G1H12(112),G1H12(117),G1H12(11),G1H12(123),G1H12(124),12)
  call HG1shiftOLR(G1H12(112),4,12)
  call Hotf_5pt_reduction(G2H12(59),RedSet_5(21),mass5set(:,1),  & 
G1H12(129),G1H12(130),G1H12(135),G1H12(136),G1H12(147),G1H12(148),12)
  call HG1shiftOLR(G1H12(130),12,12)
  call Hotf_5pt_reduction(G2H12(60),RedSet_5(24),mass5set(:,1),  & 
G1H12(153),G1H12(154),G1H12(165),G1H12(166),G1H12(171),G1H12(172),12)
  call HG1shiftOLR(G1H12(154),12,12)
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(53),mass5set(:,1),  & 
G1H12(183),G1H12(184),G1H12(189),G1H12(190),G1H12(201),G1H12(202),12)
  call HG1shiftOLR(G1H12(184),16,12)
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(47),mass5set(:,1),  & 
G1H12(207),G1H12(208),G1H12(219),G1H12(220),G1H12(225),G1H12(226),12)
  call HG1shiftOLR(G1H12(208),16,12)
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(28),mass5set(:,1),  & 
G1H12(237),G1H12(238),G1H12(243),G1H12(244),G1H12(218),G1H12(221),12)
  call HG1shiftOLR(G1H12(238),12,12)
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(26),mass5set(:,1),  & 
G1H12(222),G1H12(224),G1H12(36),G1H12(38),G1H12(41),G1H12(42),12)
  call HG1shiftOLR(G1H12(224),12,12)
  call Hotf_5pt_reduction(G2H12(5),RedSet_5(52),mass5set(:,1),  & 
G1H12(43),G1H12(44),G1H12(48),G1H12(49),G1H12(50),G1H12(53),12)
  call HG1shiftOLR(G1H12(44),8,12)
  call Hotf_5pt_reduction(G2H12(6),RedSet_5(46),mass5set(:,1),  & 
G1H12(54),G1H12(56),G1H12(59),G1H12(60),G1H12(61),G1H12(62),12)
  call HG1shiftOLR(G1H12(56),8,12)
  call Hloop_QA_V(ntryL,G2H4(119),ex1(:),G2H2(184),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_QA_V(ntryL,G2H4(122),ex1(:),G2H2(185),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_QA_V(ntryL,G2H4(123),ex1(:),G2H2(186),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_QA_V(ntryL,G2H4(124),ex1(:),G2H2(187),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_QA_V(ntryL,G2H4(126),ex1(:),G2H2(188),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_QA_V(ntryL,G2H4(127),ex1(:),G2H2(189),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_AQ_V(ntryL,G2H4(128),ex2(:),G2H2(190),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_AQ_V(ntryL,G2H4(131),ex2(:),G2H2(191),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_AQ_V(ntryL,G2H4(132),ex2(:),G2H2(192),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_AQ_V(ntryL,G2H4(133),ex2(:),G2H2(193),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_AQ_V(ntryL,G2H4(136),ex2(:),G2H2(194),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_AQ_V(ntryL,G2H4(137),ex2(:),G2H2(195),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_AQ_V(ntryL,G2H4(138),ex2(:),G2H2(196),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_AQ_V(ntryL,G2H4(140),ex2(:),G2H2(197),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_AQ_V(ntryL,G2H4(141),ex2(:),G2H2(198),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_QA_V(ntryL,G2H4(142),ex1(:),G2H2(199),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_QA_V(ntryL,G2H4(145),ex1(:),G2H2(200),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_QA_V(ntryL,G2H4(146),ex1(:),G2H2(201),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_QA_V(ntryL,G2H4(151),ex1(:),G2H2(202),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_QA_V(ntryL,G2H4(155),ex1(:),G2H2(203),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_AQ_V(ntryL,G2H4(156),ex2(:),G2H2(204),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_AQ_V(ntryL,G2H4(159),ex2(:),G2H2(205),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hotf_4pt_reduction(G2H6(121),RedSet_4(11),mass4set(:,1),  & 
G1H6(284),G1H6(285),G1H6(475),G1H6(476),G1H6(477),6)
  call HG1shiftOLR(G1H6(285),10,6)
  call Hotf_4pt_reduction(G2H4(163),RedSet_4(23),mass4set(:,1),  & 
G1H4(192),G1H4(193),G1H4(379),G1H4(380),G1H4(381),4)
  call HG1shiftOLR(G1H4(193),18,4)
  call Hloop_QA_V(ntryL,G2H4(164),ex1(:),G2H2(206),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_QA_V(ntryL,G2H4(167),ex1(:),G2H2(207),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_AQ_V(ntryL,G2H4(172),ex2(:),G2H2(208),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_AQ_V(ntryL,G2H4(176),ex2(:),G2H2(209),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hotf_4pt_reduction(G2H4(180),RedSet_4(35),mass4set(:,1),  & 
G1H4(382),G1H4(383),G1H4(384),G1H4(385),G1H4(386),4)
  call HG1shiftOLR(G1H4(383),6,4)
  call Hotf_4pt_reduction(G2H4(184),RedSet_4(44),mass4set(:,1),  & 
G1H4(387),G1H4(388),G1H4(389),G1H4(390),G1H4(391),4)
  call HG1shiftOLR(G1H4(388),18,4)
  call Hotf_4pt_reduction(G2H4(188),RedSet_4(52),mass4set(:,1),  & 
G1H4(392),G1H4(393),G1H4(394),G1H4(395),G1H4(396),4)
  call HG1shiftOLR(G1H4(393),6,4)
  call Hotf_4pt_reduction(G2H6(130),RedSet_4(59),mass4set(:,1),  & 
G1H6(478),G1H6(479),G1H6(480),G1H6(481),G1H6(482),6)
  call HG1shiftOLR(G1H6(479),10,6)
  call Hloop_QA_V(ntryL,G2H4(189),ex1(:),G2H2(210),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_QA_V(ntryL,G2H4(193),ex1(:),G2H2(211),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_AQ_V(ntryL,G2H4(194),ex2(:),G2H2(212),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_AQ_V(ntryL,G2H4(197),ex2(:),G2H2(213),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hotf_4pt_reduction(G2H6(135),RedSet_4(7),mass4set(:,1),  & 
G1H6(483),G1H6(484),G1H6(485),G1H6(486),G1H6(487),6)
  call HG1shiftOLR(G1H6(484),10,6)
  call Hotf_4pt_reduction(G2H4(201),RedSet_4(20),mass4set(:,1),  & 
G1H4(397),G1H4(398),G1H4(399),G1H4(400),G1H4(401),4)
  call HG1shiftOLR(G1H4(398),18,4)
  call Hloop_QA_V(ntryL,G2H4(202),ex1(:),G2H2(214),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_QA_V(ntryL,G2H4(205),ex1(:),G2H2(215),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_AQ_V(ntryL,G2H4(206),ex2(:),G2H2(216),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_AQ_V(ntryL,G2H4(210),ex2(:),G2H2(217),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hotf_4pt_reduction(G2H4(214),RedSet_4(31),mass4set(:,1),  & 
G1H4(402),G1H4(403),G1H4(404),G1H4(405),G1H4(406),4)
  call HG1shiftOLR(G1H4(403),6,4)
  call Hotf_4pt_reduction(G2H4(218),RedSet_4(42),mass4set(:,1),  & 
G1H4(407),G1H4(408),G1H4(409),G1H4(410),G1H4(411),4)
  call HG1shiftOLR(G1H4(408),18,4)
  call Hotf_4pt_reduction(G2H4(222),RedSet_4(49),mass4set(:,1),  & 
G1H4(412),G1H4(413),G1H4(414),G1H4(415),G1H4(416),4)
  call HG1shiftOLR(G1H4(413),6,4)
  call Hotf_4pt_reduction(G2H6(140),RedSet_4(57),mass4set(:,1),  & 
G1H6(488),G1H6(489),G1H6(490),G1H6(491),G1H6(492),6)
  call HG1shiftOLR(G1H6(489),10,6)
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(90),mass5set(:,1),  & 
G1H8(71),G1H8(72),G1H8(5),G1H8(7),G1H8(8),G1H8(16),8)
  call HG1shiftOLR(G1H8(72),5,8)
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(343),mass4set(:,1),  & 
G1H8(34),G1H8(70),G1H8(4),G1H8(10),G1H8(15),8)
  call HG1shiftOLR(G1H8(70),5,8)
  call Hotf_4pt_reduction(G2H8(35),RedSet_4(74),mass4set(:,1),  & 
G1H8(33),G1H8(69),G1H8(3),G1H8(6),G1H8(9),8)
  call HG1shiftOLR(G1H8(69),21,8)
  call Hloop_QA_V(ntryL,G2H8(37),wf4(:,3),G2H2(218),m3h4x2(:,1),heltab2x8(:,:,147))
  call Hloop_QA_V(ntryL,G2H8(1),wf4(:,3),G2H2(219),m3h4x2(:,2),heltab2x8(:,:,148))
  call Hloop_QA_V(ntryL,G2H8(2),wf4(:,3),G2H2(220),m3h4x2(:,3),heltab2x8(:,:,149))
  call Hotf_5pt_reduction(G2H12(10),RedSet_5(91),mass5set(:,1),  & 
G1H12(66),G1H12(67),G1H12(68),G1H12(71),G1H12(72),G1H12(74),12)
  call HG1shiftOLR(G1H12(67),5,12)
  call Hotf_4pt_reduction(G2H12(12),RedSet_4(343),mass4set(:,1),  & 
G1H12(77),G1H12(78),G1H12(79),G1H12(80),G1H12(84),12)
  call HG1shiftOLR(G1H12(78),5,12)
  call Hotf_4pt_reduction(G2H12(13),RedSet_4(309),mass4set(:,1),  & 
G1H12(85),G1H12(86),G1H12(89),G1H12(90),G1H12(92),12)
  call HG1shiftOLR(G1H12(86),13,12)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(12),mass5set(:,1),  & 
G1H8(2),G1H8(22),G1H8(27),G1H8(28),G1H8(39),G1H8(40),8)
  call HG1shiftOLR(G1H8(22),6,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(37),mass4set(:,1),  & 
G1H8(45),G1H8(46),G1H8(57),G1H8(58),G1H8(63),8)
  call HG1shiftOLR(G1H8(46),6,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(2),mass4set(:,1),  & 
G1H8(64),G1H8(75),G1H8(76),G1H8(81),G1H8(82),8)
  call HG1shiftOLR(G1H8(75),22,8)
  call Hloop_AQ_V(ntryL,G2H8(24),wf4(:,9),G2H2(221),m3h4x2(:,4),heltab2x8(:,:,150))
  call Hloop_AQ_V(ntryL,G2H8(4),wf4(:,9),G2H2(222),m3h4x2(:,5),heltab2x8(:,:,151))
  call Hloop_AQ_V(ntryL,G2H8(21),wf4(:,9),G2H2(223),m3h4x2(:,6),heltab2x8(:,:,152))
  call Hotf_5pt_reduction(G2H12(15),RedSet_5(13),mass5set(:,1),  & 
G1H12(95),G1H12(96),G1H12(97),G1H12(98),G1H12(102),G1H12(103),12)
  call HG1shiftOLR(G1H12(96),6,12)
  call Hotf_4pt_reduction(G2H12(17),RedSet_4(37),mass4set(:,1),  & 
G1H12(104),G1H12(107),G1H12(108),G1H12(110),G1H12(113),12)
  call HG1shiftOLR(G1H12(107),6,12)
  call Hotf_4pt_reduction(G2H12(18),RedSet_4(3),mass4set(:,1),  & 
G1H12(114),G1H12(115),G1H12(116),G1H12(120),G1H12(121),12)
  call HG1shiftOLR(G1H12(115),14,12)
  call Hotf_5pt_reduction(G2H12(19),RedSet_5(92),mass5set(:,1),  & 
G1H12(122),G1H12(125),G1H12(126),G1H12(128),G1H12(131),G1H12(132),12)
  call HG1shiftOLR(G1H12(125),9,12)
  call Hotf_4pt_reduction(G2H12(21),RedSet_4(344),mass4set(:,1),  & 
G1H12(133),G1H12(134),G1H12(138),G1H12(139),G1H12(140),12)
  call HG1shiftOLR(G1H12(134),9,12)
  call Hotf_4pt_reduction(G2H12(22),RedSet_4(94),mass4set(:,1),  & 
G1H12(145),G1H12(151),G1H12(149),G1H12(150),G1H12(152),12)
  call HG1shiftOLR(G1H12(151),25,12)
  call Hloop_QA_V(ntryL,G2H12(38),wf6(:,4),G2H2(224),m3h6x2(:,1),heltab2x12(:,:,323))
  call Hloop_QA_V(ntryL,G2H12(39),wf6(:,4),G2H2(225),m3h6x2(:,2),heltab2x12(:,:,324))
  call Hloop_QA_V(ntryL,G2H12(23),wf6(:,4),G2H2(226),m3h6x2(:,3),heltab2x12(:,:,325))
  call Hotf_5pt_reduction(G2H12(25),RedSet_5(93),mass5set(:,1),  & 
G1H12(155),G1H12(156),G1H12(158),G1H12(163),G1H12(169),G1H12(164),12)
  call HG1shiftOLR(G1H12(156),9,12)
  call Hotf_4pt_reduction(G2H12(30),RedSet_4(344),mass4set(:,1),  & 
G1H12(167),G1H12(170),G1H12(173),G1H12(174),G1H12(175),12)
  call HG1shiftOLR(G1H12(170),9,12)
  call Hotf_4pt_reduction(G2H12(33),RedSet_4(309),mass4set(:,1),  & 
G1H12(176),G1H12(187),G1H12(182),G1H12(185),G1H12(186),12)
  call HG1shiftOLR(G1H12(187),13,12)
  call Hloop_AQ_V(ntryL,G2H12(35),ex2(:),G2H6(60),m3h2x6(:,201),heltab2x12(:,:,326))
  call Hloop_AQ_V(ntryL,G2H12(40),ex2(:),G2H6(2),m3h2x6(:,202),heltab2x12(:,:,327))
  call Hloop_AQ_V(ntryL,G2H12(44),ex2(:),G2H6(54),m3h2x6(:,203),heltab2x12(:,:,328))
  call Hotf_5pt_reduction(G2H12(48),RedSet_5(9),mass5set(:,1),  & 
G1H12(188),G1H12(192),G1H12(193),G1H12(194),G1H12(199),G1H12(205),12)
  call HG1shiftOLR(G1H12(192),10,12)
  call Hotf_4pt_reduction(G2H12(52),RedSet_4(14),mass4set(:,1),  & 
G1H12(203),G1H12(204),G1H12(206),G1H12(209),G1H12(210),12)
  call HG1shiftOLR(G1H12(204),10,12)
  call Hotf_4pt_reduction(G2H12(54),RedSet_4(1),mass4set(:,1),  & 
G1H12(212),G1H12(217),G1H12(223),G1H12(227),G1H12(228),12)
  call HG1shiftOLR(G1H12(217),26,12)
  call Hloop_AQ_V(ntryL,G2H12(58),wf6(:,2),G2H2(227),m3h6x2(:,4),heltab2x12(:,:,329))
  call Hloop_AQ_V(ntryL,G2H12(31),wf6(:,2),G2H2(228),m3h6x2(:,5),heltab2x12(:,:,330))
  call Hloop_AQ_V(ntryL,G2H12(32),wf6(:,2),G2H2(229),m3h6x2(:,6),heltab2x12(:,:,331))
  call Hotf_5pt_reduction(G2H12(34),RedSet_5(14),mass5set(:,1),  & 
G1H12(229),G1H12(230),G1H12(235),G1H12(241),G1H12(236),G1H12(239),12)
  call HG1shiftOLR(G1H12(230),10,12)
  call Hotf_4pt_reduction(G2H12(24),RedSet_4(14),mass4set(:,1),  & 
G1H12(240),G1H12(242),G1H12(245),G1H12(246),G1H12(143),12)
  call HG1shiftOLR(G1H12(242),10,12)
  call Hotf_4pt_reduction(G2H12(26),RedSet_4(3),mass4set(:,1),  & 
G1H12(144),G1H12(161),G1H12(162),G1H12(179),G1H12(180),12)
  call HG1shiftOLR(G1H12(161),14,12)
  call Hloop_QA_V(ntryL,G2H12(43),ex1(:),G2H6(5),m3h2x6(:,204),heltab2x12(:,:,332))
  call Hloop_QA_V(ntryL,G2H12(7),ex1(:),G2H6(105),m3h2x6(:,205),heltab2x12(:,:,333))
  call Hloop_QA_V(ntryL,G2H12(8),ex1(:),G2H6(106),m3h2x6(:,206),heltab2x12(:,:,334))
  call Hotf_5pt_reduction(G2H12(61),RedSet_5(40),mass5set(:,1),  & 
G1H12(197),G1H12(198),G1H12(215),G1H12(216),G1H12(234),G1H12(12),12)
  call HG1shiftOLR(G1H12(198),2,12)
  call Hotf_4pt_reduction(G2H12(63),RedSet_4(13),mass4set(:,1),  & 
G1H12(35),G1H12(37),G1H12(142),G1H12(27),G1H12(26),12)
  call HG1shiftOLR(G1H12(37),2,12)
  call Hotf_4pt_reduction(G2H12(64),RedSet_4(3),mass4set(:,1),  & 
G1H12(160),G1H12(21),G1H12(25),G1H12(178),G1H12(196),12)
  call HG1shiftOLR(G1H12(21),14,12)
  call Hotf_5pt_reduction(G2H12(67),RedSet_5(10),mass5set(:,1),  & 
G1H12(45),G1H12(30),G1H12(39),G1H12(29),G1H12(63),G1H12(32),12)
  call HG1shiftOLR(G1H12(30),17,12)
  call Hotf_4pt_reduction(G2H12(69),RedSet_4(72),mass4set(:,1),  & 
G1H12(214),G1H12(31),G1H12(232),G1H12(10),G1H12(34),12)
  call HG1shiftOLR(G1H12(31),17,12)
  call Hotf_4pt_reduction(G2H12(70),RedSet_4(94),mass4set(:,1),  & 
G1H12(52),G1H12(69),G1H12(75),G1H12(81),G1H12(87),12)
  call HG1shiftOLR(G1H12(69),25,12)
  call Hloop_AQ_V(ntryL,G2H8(12),ex2(:),G2H4(2),m3h2x4(:,147),heltab2x8(:,:,153))
  call Hloop_AQ_V(ntryL,G2H8(20),ex2(:),G2H4(5),m3h2x4(:,148),heltab2x8(:,:,154))
  call Hloop_AQ_V(ntryL,G2H8(22),ex2(:),G2H4(8),m3h2x4(:,149),heltab2x8(:,:,155))
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(7),mass5set(:,1),  & 
G1H8(11),G1H8(12),G1H8(14),G1H8(19),G1H8(25),G1H8(20),8)
  call HG1shiftOLR(G1H8(12),17,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(72),mass4set(:,1),  & 
G1H8(23),G1H8(26),G1H8(29),G1H8(30),G1H8(31),8)
  call HG1shiftOLR(G1H8(26),17,8)
  call Hotf_4pt_reduction(G2H8(36),RedSet_4(74),mass4set(:,1),  & 
G1H8(32),G1H8(43),G1H8(38),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(43),21,8)
  call Hloop_AQ_V(ntryL,G2H8(10),ex2(:),G2H4(11),m3h2x4(:,150),heltab2x8(:,:,156))
  call Hloop_AQ_V(ntryL,G2H8(13),ex2(:),G2H4(107),m3h2x4(:,151),heltab2x8(:,:,157))
  call Hloop_AQ_V(ntryL,G2H8(16),ex2(:),G2H4(55),m3h2x4(:,152),heltab2x8(:,:,158))
  call Hotf_5pt_reduction(G2H12(71),RedSet_5(8),mass5set(:,1),  & 
G1H12(93),G1H12(99),G1H12(247),G1H12(248),G1H12(249),G1H12(250),12)
  call HG1shiftOLR(G1H12(99),18,12)
  call Hotf_4pt_reduction(G2H12(73),RedSet_4(25),mass4set(:,1),  & 
G1H12(251),G1H12(252),G1H12(253),G1H12(254),G1H12(255),12)
  call HG1shiftOLR(G1H12(252),18,12)
  call Hotf_4pt_reduction(G2H12(74),RedSet_4(1),mass4set(:,1),  & 
G1H12(256),G1H12(257),G1H12(258),G1H12(259),G1H12(260),12)
  call HG1shiftOLR(G1H12(257),26,12)
  call Hloop_QA_V(ntryL,G2H8(3),ex1(:),G2H4(24),m3h2x4(:,153),heltab2x8(:,:,159))
  call Hloop_QA_V(ntryL,G2H8(7),ex1(:),G2H4(27),m3h2x4(:,154),heltab2x8(:,:,160))
  call Hloop_QA_V(ntryL,G2H8(8),ex1(:),G2H4(109),m3h2x4(:,155),heltab2x8(:,:,161))
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(11),mass5set(:,1),  & 
G1H8(44),G1H8(48),G1H8(49),G1H8(50),G1H8(55),G1H8(61),8)
  call HG1shiftOLR(G1H8(48),18,8)
  call Hotf_4pt_reduction(G2H8(29),RedSet_4(25),mass4set(:,1),  & 
G1H8(59),G1H8(60),G1H8(62),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(60),18,8)
  call Hotf_4pt_reduction(G2H8(30),RedSet_4(2),mass4set(:,1),  & 
G1H8(68),G1H8(85),G1H8(86),G1H8(87),G1H8(88),8)
  call HG1shiftOLR(G1H8(85),22,8)
  call Hloop_QA_V(ntryL,G2H8(39),ex1(:),G2H4(60),m3h2x4(:,156),heltab2x8(:,:,162))
  call Hloop_QA_V(ntryL,G2H8(41),ex1(:),G2H4(33),m3h2x4(:,157),heltab2x8(:,:,163))
  call Hloop_QA_V(ntryL,G2H8(42),ex1(:),G2H4(36),m3h2x4(:,158),heltab2x8(:,:,164))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G1H4(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(28),[G1H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(76),[G1H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(184),[G1H6(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(220),[G1H6(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(203),[G1H4(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(208),[G1H4(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(6),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(291),[G1H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(219),[G1H4(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(224),[G1H4(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(245),[G1H4(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(446),[G1H6(438)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(483),[G1H6(439)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(451),[G1H6(444)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(284),[G1H6(445)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(311),[G1H4(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(397),[G1H4(304)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(316),[G1H4(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(192),[G1H4(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(330),[G1H4(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(402),[G1H4(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(335),[G1H4(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(382),[G1H4(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(349),[G1H4(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(407),[G1H4(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(354),[G1H4(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(387),[G1H4(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(369),[G1H4(361)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(412),[G1H4(362)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(374),[G1H4(367)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(392),[G1H4(368)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(465),[G1H6(457)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(488),[G1H6(458)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(470),[G1H6(463)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(478),[G1H6(464)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(33),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(77),[G1H12(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(85),[G1H12(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(64),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(104),[G1H12(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(114),[G1H12(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(133),[G1H12(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(145),[G1H12(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(167),[G1H12(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(176),[G1H12(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(203),[G1H12(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(212),[G1H12(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(240),[G1H12(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(144),[G1H12(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(35),[G1H12(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(160),[G1H12(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(214),[G1H12(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(52),[G1H12(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(251),[G1H12(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(256),[G1H12(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(59),[G1H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(68),[G1H8(61)])
  call Hloop_VQ_A(ntryL,G1H4(139),ex2(:),G1H2(86),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(86),47,0,G2H2(230),n2h2(142))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(140),-16,0,G2H4(147),n2h4(263))
  call Hloop_AV_Q(ntryL,G2H4(147),ex5(:),G2H2(231),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_VQ_A(ntryL,G1H4(150),ex2(:),G1H2(91),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(232),n2h2(143))
  call Hloop_VQ_A(ntryL,G1H4(151),ex2(:),G1H2(92),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(92),47,0,G2H2(233),n2h2(144))
  call Hloop_VQ_A(ntryL,G1H4(156),ex2(:),G1H2(97),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(97),47,0,G2H2(234),n2h2(145))
call HGT_OLR(G1H4(157),1,1,4)
call HGT_invQ_OLR(G1H4(157),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(157),-16,0,G2H4(68),n2h4(264))
  call Hloop_AV_Q(ntryL,G2H4(68),ex5(:),G2H2(235),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_VQ_A(ntryL,G1H4(167),ex2(:),G1H2(98),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(98),47,0,G2H2(236),n2h2(146))
  call Hloop_VQ_A(ntryL,G1H4(168),ex2(:),G1H2(103),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_Q_A(ntryL,G1H2(103),47,0,G2H2(237),n2h2(147))
  call Hloop_VA_Q(ntryL,G1H6(187),ex1(:),G1H3(37),m3h2x3(:,93),heltab2x6(:,:,176))
  call Hloop_A_Q(ntryL,G1H3(37),55,0,G2H3(75),n2h3(71))
call HGT_OLR(G1H6(188),1,1,6)
call HGT_invQ_OLR(G1H6(188),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(188),-8,0,G2H6(16),n2h6(185))
  call Hloop_QW_A(ntryL,G2H6(16),ex4(:),G2H2(238),m3h3x2(:,84),heltab2x6(:,:,177))
  call Hloop_VA_Q(ntryL,G1H6(194),ex1(:),G1H3(38),m3h2x3(:,94),heltab2x6(:,:,178))
  call Hloop_A_Q(ntryL,G1H3(38),55,0,G2H3(76),n2h3(72))
  call Hloop_VA_Q(ntryL,G1H6(199),ex1(:),G1H3(43),m3h2x3(:,95),heltab2x6(:,:,179))
  call Hloop_A_Q(ntryL,G1H3(43),55,0,G2H3(77),n2h3(73))
  call Hloop_VA_Q(ntryL,G1H4(173),ex1(:),G1H2(104),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_A_Q(ntryL,G1H2(104),47,0,G2H2(239),n2h2(148))
call HGT_OLR(G1H4(174),1,1,4)
call HGT_invQ_OLR(G1H4(174),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(174),-16,0,G2H4(45),n2h4(265))
  call Hloop_QV_A(ntryL,G2H4(45),ex5(:),G2H2(240),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_VA_Q(ntryL,G1H4(184),ex1(:),G1H2(109),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(109),47,0,G2H2(241),n2h2(149))
  call Hloop_VA_Q(ntryL,G1H4(185),ex1(:),G1H2(110),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_A_Q(ntryL,G1H2(110),47,0,G2H2(242),n2h2(150))
  call Hloop_VA_Q(ntryL,G1H4(190),ex1(:),G1H2(115),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_A_Q(ntryL,G1H2(115),47,0,G2H2(243),n2h2(151))
call HGT_OLR(G1H4(191),1,1,4)
call HGT_invQ_OLR(G1H4(191),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(191),-16,0,G2H4(149),n2h4(266))
  call Hloop_QV_A(ntryL,G2H4(149),ex5(:),G2H2(244),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_VA_Q(ntryL,G1H4(36),ex1(:),G1H2(116),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(116),47,0,G2H2(245),n2h2(152))
  call Hloop_VA_Q(ntryL,G1H4(48),ex1(:),G1H2(121),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(121),47,0,G2H2(246),n2h2(153))
  call Hloop_VQ_A(ntryL,G1H6(200),ex2(:),G1H3(44),m3h2x3(:,96),heltab2x6(:,:,180))
  call Hloop_Q_A(ntryL,G1H3(44),55,0,G2H3(78),n2h3(74))
call HGT_OLR(G1H6(204),1,1,6)
call HGT_invQ_OLR(G1H6(204),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(204),-8,0,G2H6(19),n2h6(186))
  call Hloop_AW_Q(ntryL,G2H6(19),ex4(:),G2H2(247),m3h3x2(:,85),heltab2x6(:,:,181))
  call Hloop_VQ_A(ntryL,G1H6(211),ex2(:),G1H3(49),m3h2x3(:,97),heltab2x6(:,:,182))
  call Hloop_Q_A(ntryL,G1H3(49),55,0,G2H3(79),n2h3(75))
  call Hloop_VQ_A(ntryL,G1H6(212),ex2(:),G1H3(50),m3h2x3(:,98),heltab2x6(:,:,183))
  call Hloop_Q_A(ntryL,G1H3(50),55,0,G2H3(80),n2h3(76))
  call Hloop_VA_Q(ntryL,G1H4(60),ex1(:),G1H2(122),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(122),59,0,G2H2(248),n2h2(154))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(72),-4,0,G2H4(72),n2h4(267))
  call Hloop_QV_A(ntryL,G2H4(72),ex3(:),G2H2(249),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_VA_Q(ntryL,G1H4(108),ex1(:),G1H2(127),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(127),59,0,G2H2(250),n2h2(155))
  call Hloop_VA_Q(ntryL,G1H4(132),ex1(:),G1H2(128),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_A_Q(ntryL,G1H2(128),59,0,G2H2(251),n2h2(156))
  call Hloop_AV_Q(ntryL,G1H4(138),ex3(:),G1H2(133),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_A_Q(ntryL,G1H2(133),47,0,G2H2(252),n2h2(157))
call HGT_OLR(G1H4(149),1,1,4)
call HGT_invQ_OLR(G1H4(149),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(149),-16,0,G2H4(70),n2h4(268))
  call Hloop_QV_A(ntryL,G2H4(70),ex5(:),G2H2(253),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_AV_Q(ntryL,G1H4(183),ex3(:),G1H2(134),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_A_Q(ntryL,G1H2(134),47,0,G2H2(254),n2h2(158))
  call Hloop_AV_Q(ntryL,G1H4(189),ex3(:),G1H2(139),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_A_Q(ntryL,G1H2(139),47,0,G2H2(255),n2h2(159))
  call Hloop_VQ_A(ntryL,G1H6(216),ex2(:),G1H3(55),m3h2x3(:,99),heltab2x6(:,:,184))
  call Hloop_Q_A(ntryL,G1H3(55),55,0,G2H3(81),n2h3(77))
call HGT_OLR(G1H6(217),1,1,6)
call HGT_invQ_OLR(G1H6(217),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(217),-8,0,G2H6(107),n2h6(187))
  call Hloop_AW_Q(ntryL,G2H6(107),ex4(:),G2H2(256),m3h3x2(:,86),heltab2x6(:,:,185))
  call Hloop_VQ_A(ntryL,G1H6(224),ex2(:),G1H3(56),m3h2x3(:,100),heltab2x6(:,:,186))
  call Hloop_Q_A(ntryL,G1H3(56),55,0,G2H3(82),n2h3(78))
  call Hloop_VQ_A(ntryL,G1H6(228),ex2(:),G1H3(61),m3h2x3(:,101),heltab2x6(:,:,187))
  call Hloop_Q_A(ntryL,G1H3(61),55,0,G2H3(83),n2h3(79))
  call Hloop_QW_A(ntryL,G1H6(229),ex4(:),G1H2(140),m3h3x2(:,87),heltab2x6(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(140),47,0,G2H2(257),n2h2(160))
call HGT_OLR(G1H6(230),1,1,6)
call HGT_invQ_OLR(G1H6(230),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(230),-16,0,G2H6(108),n2h6(188))
  call Hloop_AV_Q(ntryL,G2H6(108),ex5(:),G2H3(84),m3h2x3(:,102),heltab2x6(:,:,189))
  call Hloop_QW_A(ntryL,G1H6(240),ex4(:),G1H2(13),m3h3x2(:,88),heltab2x6(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(258),n2h2(161))
  call Hloop_QW_A(ntryL,G1H6(241),ex4(:),G1H2(14),m3h3x2(:,89),heltab2x6(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(259),n2h2(162))
  call Hloop_VQ_A(ntryL,G1H4(7),ex2(:),G1H2(19),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(260),n2h2(163))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-16,0,G2H4(51),n2h4(269))
  call Hloop_AV_Q(ntryL,G2H4(51),ex5(:),G2H2(261),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_VQ_A(ntryL,G1H4(18),ex2(:),G1H2(20),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(262),n2h2(164))
  call Hloop_VQ_A(ntryL,G1H4(19),ex2(:),G1H2(25),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(263),n2h2(165))
  call Hloop_QV_A(ntryL,G1H6(242),ex5(:),G1H3(62),m3h2x3(:,103),heltab2x6(:,:,192))
  call Hloop_Q_A(ntryL,G1H3(62),55,0,G2H3(85),n2h3(80))
call HGT_OLR(G1H6(247),1,1,6)
call HGT_invQ_OLR(G1H6(247),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(247),-8,0,G2H6(11),n2h6(189))
  call Hloop_AW_Q(ntryL,G2H6(11),ex4(:),G2H2(264),m3h3x2(:,90),heltab2x6(:,:,193))
  call Hloop_QV_A(ntryL,G1H6(253),ex5(:),G1H3(67),m3h2x3(:,104),heltab2x6(:,:,194))
  call Hloop_Q_A(ntryL,G1H3(67),55,0,G2H3(86),n2h3(81))
  call Hloop_QV_A(ntryL,G1H6(254),ex5(:),G1H3(68),m3h2x3(:,105),heltab2x6(:,:,195))
  call Hloop_Q_A(ntryL,G1H3(68),55,0,G2H3(87),n2h3(82))
  call Hloop_AV_Q(ntryL,G1H6(259),ex3(:),G1H3(73),m3h2x3(:,106),heltab2x6(:,:,196))
  call Hloop_A_Q(ntryL,G1H3(73),55,0,G2H3(88),n2h3(83))
call HGT_OLR(G1H6(260),1,1,6)
call HGT_invQ_OLR(G1H6(260),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(260),-8,0,G2H6(57),n2h6(190))
  call Hloop_QW_A(ntryL,G2H6(57),ex4(:),G2H2(265),m3h3x2(:,91),heltab2x6(:,:,197))
  call Hloop_AV_Q(ntryL,G1H6(270),ex3(:),G1H3(74),m3h2x3(:,107),heltab2x6(:,:,198))
  call Hloop_A_Q(ntryL,G1H3(74),55,0,G2H3(89),n2h3(84))
  call Hloop_AV_Q(ntryL,G1H6(271),ex3(:),G1H3(7),m3h2x3(:,108),heltab2x6(:,:,199))
  call Hloop_A_Q(ntryL,G1H3(7),55,0,G2H3(90),n2h3(85))
  call Hloop_AW_Q(ntryL,G1H6(276),ex4(:),G1H2(26),m3h3x2(:,92),heltab2x6(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(26),47,0,G2H2(266),n2h2(166))
call HGT_OLR(G1H6(277),1,1,6)
call HGT_invQ_OLR(G1H6(277),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(277),-16,0,G2H6(31),n2h6(191))
  call Hloop_QV_A(ntryL,G2H6(31),ex5(:),G2H3(91),m3h2x3(:,109),heltab2x6(:,:,201))
  call Hloop_AW_Q(ntryL,G1H6(18),ex4(:),G1H2(31),m3h3x2(:,93),heltab2x6(:,:,202))
  call Hloop_A_Q(ntryL,G1H2(31),47,0,G2H2(267),n2h2(167))
  call Hloop_AW_Q(ntryL,G1H6(30),ex4(:),G1H2(32),m3h3x2(:,94),heltab2x6(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(32),47,0,G2H2(268),n2h2(168))
  call Hloop_AV_Q(ntryL,G1H4(20),ex3(:),G1H2(37),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(37),47,0,G2H2(269),n2h2(169))
call HGT_OLR(G1H4(25),1,1,4)
call HGT_invQ_OLR(G1H4(25),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(25),-16,0,G2H4(48),n2h4(270))
  call Hloop_QV_A(ntryL,G2H4(48),ex5(:),G2H2(270),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_AV_Q(ntryL,G1H4(31),ex3(:),G1H2(38),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(271),n2h2(170))
  call Hloop_AV_Q(ntryL,G1H4(32),ex3(:),G1H2(43),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_A_Q(ntryL,G1H2(43),47,0,G2H2(272),n2h2(171))
  call Hloop_AV_Q(ntryL,G1H6(42),ex5(:),G1H3(8),m3h2x3(:,110),heltab2x6(:,:,204))
  call Hloop_A_Q(ntryL,G1H3(8),55,0,G2H3(92),n2h3(86))
call HGT_OLR(G1H6(54),1,1,6)
call HGT_invQ_OLR(G1H6(54),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(54),-8,0,G2H6(14),n2h6(192))
  call Hloop_QW_A(ntryL,G2H6(14),ex4(:),G2H2(273),m3h3x2(:,95),heltab2x6(:,:,205))
  call Hloop_AV_Q(ntryL,G1H6(90),ex5(:),G1H3(13),m3h2x3(:,111),heltab2x6(:,:,206))
  call Hloop_A_Q(ntryL,G1H3(13),55,0,G2H3(93),n2h3(87))
  call Hloop_AV_Q(ntryL,G1H6(102),ex5(:),G1H3(14),m3h2x3(:,112),heltab2x6(:,:,207))
  call Hloop_A_Q(ntryL,G1H3(14),55,0,G2H3(94),n2h3(88))
  call Hloop_VQ_A(ntryL,G1H4(37),ex2(:),G1H2(44),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(44),59,0,G2H2(274),n2h2(172))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(38),-4,0,G2H4(71),n2h4(271))
  call Hloop_AV_Q(ntryL,G2H4(71),ex3(:),G2H2(275),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_VQ_A(ntryL,G1H4(44),ex2(:),G1H2(49),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(49),59,0,G2H2(276),n2h2(173))
  call Hloop_VQ_A(ntryL,G1H4(49),ex2(:),G1H2(50),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(50),59,0,G2H2(277),n2h2(174))
  call Hloop_QV_A(ntryL,G1H4(50),ex3(:),G1H2(55),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(55),47,0,G2H2(278),n2h2(175))
call HGT_OLR(G1H4(54),1,1,4)
call HGT_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(54),-16,0,G2H4(49),n2h4(272))
  call Hloop_AV_Q(ntryL,G2H4(49),ex5(:),G2H2(279),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_QV_A(ntryL,G1H4(61),ex3(:),G1H2(56),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(56),47,0,G2H2(280),n2h2(176))
  call Hloop_QV_A(ntryL,G1H4(62),ex3(:),G1H2(61),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_Q_A(ntryL,G1H2(61),47,0,G2H2(281),n2h2(177))
  call Hloop_VA_Q(ntryL,G1H6(114),ex1(:),G1H3(19),m3h2x3(:,113),heltab2x6(:,:,208))
  call Hloop_A_Q(ntryL,G1H3(19),55,0,G2H3(95),n2h3(89))
call HGT_OLR(G1H6(126),1,1,6)
call HGT_invQ_OLR(G1H6(126),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(126),-8,0,G2H6(64),n2h6(193))
  call Hloop_QW_A(ntryL,G2H6(64),ex4(:),G2H2(282),m3h3x2(:,96),heltab2x6(:,:,209))
  call Hloop_VA_Q(ntryL,G1H6(162),ex1(:),G1H3(20),m3h2x3(:,114),heltab2x6(:,:,210))
  call Hloop_A_Q(ntryL,G1H3(20),55,0,G2H3(96),n2h3(90))
  call Hloop_VA_Q(ntryL,G1H6(174),ex1(:),G1H3(25),m3h2x3(:,115),heltab2x6(:,:,211))
  call Hloop_A_Q(ntryL,G1H3(25),55,0,G2H3(97),n2h3(91))
  call Hloop_AW_Q(ntryL,G1H6(186),ex4(:),G1H2(62),m3h3x2(:,97),heltab2x6(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(62),47,0,G2H2(283),n2h2(178))
call HGT_OLR(G1H6(198),1,1,6)
call HGT_invQ_OLR(G1H6(198),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(198),-16,0,G2H6(35),n2h6(194))
  call Hloop_QV_A(ntryL,G2H6(35),ex5(:),G2H3(98),m3h2x3(:,116),heltab2x6(:,:,213))
  call Hloop_AW_Q(ntryL,G1H6(234),ex4(:),G1H2(67),m3h3x2(:,98),heltab2x6(:,:,214))
  call Hloop_A_Q(ntryL,G1H2(67),47,0,G2H2(284),n2h2(179))
  call Hloop_AW_Q(ntryL,G1H6(246),ex4(:),G1H2(68),m3h3x2(:,99),heltab2x6(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(68),47,0,G2H2(285),n2h2(180))
  call Hloop_AW_Q(ntryL,G1H6(258),ex4(:),G1H2(73),m3h3x2(:,100),heltab2x6(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(73),59,0,G2H2(286),n2h2(181))
call HGT_OLR(G1H6(264),1,1,6)
call HGT_invQ_OLR(G1H6(264),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(264),-4,0,G2H6(109),n2h6(195))
  call Hloop_QV_A(ntryL,G2H6(109),ex3(:),G2H3(99),m3h2x3(:,117),heltab2x6(:,:,217))
  call Hloop_AW_Q(ntryL,G1H6(13),ex4(:),G1H2(74),m3h3x2(:,101),heltab2x6(:,:,218))
  call Hloop_A_Q(ntryL,G1H2(74),59,0,G2H2(287),n2h2(182))
  call Hloop_AW_Q(ntryL,G1H6(14),ex4(:),G1H2(79),m3h3x2(:,102),heltab2x6(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(79),59,0,G2H2(288),n2h2(183))
  call Hloop_AV_Q(ntryL,G1H4(66),ex3(:),G1H2(80),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(80),47,0,G2H2(289),n2h2(184))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(68),-16,0,G2H4(150),n2h4(273))
  call Hloop_QV_A(ntryL,G2H4(150),ex5(:),G2H2(290),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_AV_Q(ntryL,G1H4(78),ex3(:),G1H2(85),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_A_Q(ntryL,G1H2(85),47,0,G2H2(291),n2h2(185))
  call Hloop_AV_Q(ntryL,G1H4(80),ex3(:),G1H2(86),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_A_Q(ntryL,G1H2(86),47,0,G2H2(292),n2h2(186))
  call Hloop_AW_Q(ntryL,G1H6(19),ex4(:),G1H2(91),m3h3x2(:,103),heltab2x6(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(293),n2h2(187))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(20),-16,0,G2H6(39),n2h6(196))
  call Hloop_QV_A(ntryL,G2H6(39),ex5(:),G2H3(100),m3h2x3(:,118),heltab2x6(:,:,221))
  call Hloop_AW_Q(ntryL,G1H6(26),ex4(:),G1H2(92),m3h3x2(:,104),heltab2x6(:,:,222))
  call Hloop_A_Q(ntryL,G1H2(92),47,0,G2H2(294),n2h2(188))
  call Hloop_AW_Q(ntryL,G1H6(31),ex4(:),G1H2(97),m3h3x2(:,105),heltab2x6(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(97),47,0,G2H2(295),n2h2(189))
  call Hloop_AV_Q(ntryL,G1H4(85),ex5(:),G1H2(98),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(98),59,0,G2H2(296),n2h2(190))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(86),-4,0,G2H4(76),n2h4(274))
  call Hloop_QV_A(ntryL,G2H4(76),ex3(:),G2H2(297),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_AV_Q(ntryL,G1H4(92),ex5(:),G1H2(103),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(103),59,0,G2H2(298),n2h2(191))
  call Hloop_AV_Q(ntryL,G1H4(97),ex5(:),G1H2(104),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_A_Q(ntryL,G1H2(104),59,0,G2H2(299),n2h2(192))
  call Hloop_VA_Q(ntryL,G1H4(109),ex1(:),G1H2(109),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(109),47,0,G2H2(300),n2h2(193))
call HGT_OLR(G1H4(110),1,1,4)
call HGT_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(110),-16,0,G2H4(54),n2h4(275))
  call Hloop_QV_A(ntryL,G2H4(54),ex5(:),G2H2(301),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_VA_Q(ntryL,G1H4(116),ex1(:),G1H2(110),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_A_Q(ntryL,G1H2(110),47,0,G2H2(302),n2h2(194))
  call Hloop_VA_Q(ntryL,G1H4(121),ex1(:),G1H2(115),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_A_Q(ntryL,G1H2(115),47,0,G2H2(303),n2h2(195))
  call Hloop_AV_Q(ntryL,G1H6(32),ex5(:),G1H3(26),m3h2x3(:,119),heltab2x6(:,:,224))
  call Hloop_A_Q(ntryL,G1H3(26),55,0,G2H3(101),n2h3(92))
call HGT_OLR(G1H6(36),1,1,6)
call HGT_invQ_OLR(G1H6(36),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(36),-8,0,G2H6(42),n2h6(197))
  call Hloop_QW_A(ntryL,G2H6(42),ex4(:),G2H2(304),m3h3x2(:,106),heltab2x6(:,:,225))
  call Hloop_AV_Q(ntryL,G1H6(43),ex5(:),G1H3(31),m3h2x3(:,120),heltab2x6(:,:,226))
  call Hloop_A_Q(ntryL,G1H3(31),55,0,G2H3(102),n2h3(93))
  call Hloop_AV_Q(ntryL,G1H6(44),ex5(:),G1H3(32),m3h2x3(:,121),heltab2x6(:,:,227))
  call Hloop_A_Q(ntryL,G1H3(32),55,0,G2H3(103),n2h3(94))
  call Hloop_AV_Q(ntryL,G1H4(122),ex5(:),G1H2(116),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_A_Q(ntryL,G1H2(116),59,0,G2H2(305),n2h2(196))
call HGT_OLR(G1H4(126),1,1,4)
call HGT_invQ_OLR(G1H4(126),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(126),-4,0,G2H4(82),n2h4(276))
  call Hloop_QV_A(ntryL,G2H4(82),ex3(:),G2H2(306),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_AV_Q(ntryL,G1H4(133),ex5(:),G1H2(121),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_A_Q(ntryL,G1H2(121),59,0,G2H2(307),n2h2(197))
  call Hloop_AV_Q(ntryL,G1H4(134),ex5(:),G1H2(122),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_A_Q(ntryL,G1H2(122),59,0,G2H2(308),n2h2(198))
  call Hloop_AV_Q(ntryL,G1H6(48),ex3(:),G1H3(37),m3h2x3(:,122),heltab2x6(:,:,228))
  call Hloop_A_Q(ntryL,G1H3(37),55,0,G2H3(104),n2h3(95))
call HGT_OLR(G1H6(49),1,1,6)
call HGT_invQ_OLR(G1H6(49),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(49),-8,0,G2H6(110),n2h6(198))
  call Hloop_QW_A(ntryL,G2H6(110),ex4(:),G2H2(309),m3h3x2(:,107),heltab2x6(:,:,229))
  call Hloop_AV_Q(ntryL,G1H6(56),ex3(:),G1H3(38),m3h2x3(:,123),heltab2x6(:,:,230))
  call Hloop_A_Q(ntryL,G1H3(38),55,0,G2H3(105),n2h3(96))
  call Hloop_AV_Q(ntryL,G1H6(60),ex3(:),G1H3(43),m3h2x3(:,124),heltab2x6(:,:,231))
  call Hloop_A_Q(ntryL,G1H3(43),55,0,G2H3(106),n2h3(97))
  call Hloop_AV_Q(ntryL,G1H6(61),ex5(:),G1H3(44),m3h2x3(:,125),heltab2x6(:,:,232))
  call Hloop_A_Q(ntryL,G1H3(44),55,0,G2H3(107),n2h3(98))
call HGT_OLR(G1H6(62),1,1,6)
call HGT_invQ_OLR(G1H6(62),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(62),-8,0,G2H6(1),n2h6(199))
  call Hloop_QW_A(ntryL,G2H6(1),ex4(:),G2H2(310),m3h3x2(:,108),heltab2x6(:,:,233))
  call Hloop_AV_Q(ntryL,G1H6(72),ex5(:),G1H3(49),m3h2x3(:,126),heltab2x6(:,:,234))
  call Hloop_A_Q(ntryL,G1H3(49),55,0,G2H3(108),n2h3(99))
  call Hloop_AV_Q(ntryL,G1H6(73),ex5(:),G1H3(50),m3h2x3(:,127),heltab2x6(:,:,235))
  call Hloop_A_Q(ntryL,G1H3(50),55,0,G2H3(109),n2h3(100))
  call Hloop_AW_Q(ntryL,G1H6(74),ex4(:),G1H2(127),m3h3x2(:,109),heltab2x6(:,:,236))
  call Hloop_A_Q(ntryL,G1H2(127),59,0,G2H2(311),n2h2(199))
call HGT_OLR(G1H6(79),1,1,6)
call HGT_invQ_OLR(G1H6(79),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(79),-4,0,G2H6(67),n2h6(200))
  call Hloop_QV_A(ntryL,G2H6(67),ex3(:),G2H3(110),m3h2x3(:,128),heltab2x6(:,:,237))
  call Hloop_AW_Q(ntryL,G1H6(91),ex4(:),G1H2(128),m3h3x2(:,110),heltab2x6(:,:,238))
  call Hloop_A_Q(ntryL,G1H2(128),59,0,G2H2(312),n2h2(200))
  call Hloop_AW_Q(ntryL,G1H6(92),ex4(:),G1H2(133),m3h3x2(:,111),heltab2x6(:,:,239))
  call Hloop_A_Q(ntryL,G1H2(133),59,0,G2H2(313),n2h2(201))
  call Hloop_QV_A(ntryL,G1H6(96),ex3(:),G1H3(55),m3h2x3(:,129),heltab2x6(:,:,240))
  call Hloop_Q_A(ntryL,G1H3(55),55,0,G2H3(111),n2h3(101))
call HGT_OLR(G1H6(98),1,1,6)
call HGT_invQ_OLR(G1H6(98),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(98),-8,0,G2H6(47),n2h6(201))
  call Hloop_AW_Q(ntryL,G2H6(47),ex4(:),G2H2(314),m3h3x2(:,112),heltab2x6(:,:,241))
  call Hloop_QV_A(ntryL,G1H6(109),ex3(:),G1H3(56),m3h2x3(:,130),heltab2x6(:,:,242))
  call Hloop_Q_A(ntryL,G1H3(56),55,0,G2H3(112),n2h3(102))
  call Hloop_QV_A(ntryL,G1H6(115),ex3(:),G1H3(61),m3h2x3(:,131),heltab2x6(:,:,243))
  call Hloop_Q_A(ntryL,G1H3(61),55,0,G2H3(113),n2h3(103))
  call Hloop_QW_A(ntryL,G1H6(116),ex4(:),G1H2(134),m3h3x2(:,113),heltab2x6(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(134),47,0,G2H2(315),n2h2(202))
call HGT_OLR(G1H6(120),1,1,6)
call HGT_invQ_OLR(G1H6(120),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(120),-16,0,G2H6(4),n2h6(202))
  call Hloop_AV_Q(ntryL,G2H6(4),ex5(:),G2H3(114),m3h2x3(:,132),heltab2x6(:,:,245))
  call Hloop_QW_A(ntryL,G1H6(133),ex4(:),G1H2(139),m3h3x2(:,114),heltab2x6(:,:,246))
  call Hloop_Q_A(ntryL,G1H2(139),47,0,G2H2(316),n2h2(203))
  call Hloop_QW_A(ntryL,G1H6(134),ex4(:),G1H2(140),m3h3x2(:,115),heltab2x6(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(140),47,0,G2H2(317),n2h2(204))
  call Hloop_QV_A(ntryL,G1H4(11),ex3(:),G1H2(13),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(318),n2h2(205))
call HGT_OLR(G1H4(23),1,1,4)
call HGT_invQ_OLR(G1H4(23),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(23),-16,0,G2H4(79),n2h4(277))
  call Hloop_AV_Q(ntryL,G2H4(79),ex5(:),G2H2(319),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_QV_A(ntryL,G1H4(59),ex3(:),G1H2(14),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(320),n2h2(206))
  call Hloop_QV_A(ntryL,G1H4(9),ex3(:),G1H2(19),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(321),n2h2(207))
  call Hloop_QV_A(ntryL,G1H6(139),ex5(:),G1H3(62),m3h2x3(:,133),heltab2x6(:,:,248))
  call Hloop_Q_A(ntryL,G1H3(62),55,0,G2H3(115),n2h3(104))
call HGT_OLR(G1H6(144),1,1,6)
call HGT_invQ_OLR(G1H6(144),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(144),-8,0,G2H6(71),n2h6(203))
  call Hloop_AW_Q(ntryL,G2H6(71),ex4(:),G2H2(322),m3h3x2(:,116),heltab2x6(:,:,249))
  call Hloop_QV_A(ntryL,G1H6(156),ex5(:),G1H3(67),m3h2x3(:,134),heltab2x6(:,:,250))
  call Hloop_Q_A(ntryL,G1H3(67),55,0,G2H3(116),n2h3(105))
  call Hloop_QV_A(ntryL,G1H6(158),ex5(:),G1H3(68),m3h2x3(:,135),heltab2x6(:,:,251))
  call Hloop_Q_A(ntryL,G1H3(68),55,0,G2H3(117),n2h3(106))
  call Hloop_QW_A(ntryL,G1H6(163),ex4(:),G1H2(20),m3h3x2(:,117),heltab2x6(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(20),59,0,G2H2(323),n2h2(208))
call HGT_OLR(G1H6(164),1,1,6)
call HGT_invQ_OLR(G1H6(164),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(164),-4,0,G2H6(51),n2h6(204))
  call Hloop_AV_Q(ntryL,G2H6(51),ex3(:),G2H3(118),m3h2x3(:,136),heltab2x6(:,:,253))
  call Hloop_QW_A(ntryL,G1H6(185),ex4(:),G1H2(25),m3h3x2(:,118),heltab2x6(:,:,254))
  call Hloop_Q_A(ntryL,G1H2(25),59,0,G2H2(324),n2h2(209))
  call Hloop_QW_A(ntryL,G1H6(29),ex4(:),G1H2(26),m3h3x2(:,119),heltab2x6(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(26),59,0,G2H2(325),n2h2(210))
  call Hloop_QV_A(ntryL,G1H4(57),ex3(:),G1H2(31),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(326),n2h2(211))
call HGT_OLR(G1H4(71),1,1,4)
call HGT_invQ_OLR(G1H4(71),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(71),-16,0,G2H4(58),n2h4(278))
  call Hloop_AV_Q(ntryL,G2H4(58),ex5(:),G2H2(327),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_QV_A(ntryL,G1H4(33),ex3(:),G1H2(32),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(32),47,0,G2H2(328),n2h2(212))
  call Hloop_QV_A(ntryL,G1H4(69),ex3(:),G1H2(37),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(329),n2h2(213))
  call Hloop_QW_A(ntryL,G1H6(41),ex4(:),G1H2(38),m3h3x2(:,120),heltab2x6(:,:,256))
  call Hloop_Q_A(ntryL,G1H2(38),47,0,G2H2(330),n2h2(214))
call HGT_OLR(G1H6(53),1,1,6)
call HGT_invQ_OLR(G1H6(53),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(53),-16,0,G2H6(46),n2h6(205))
  call Hloop_AV_Q(ntryL,G2H6(46),ex5(:),G2H3(119),m3h2x3(:,137),heltab2x6(:,:,257))
  call Hloop_QW_A(ntryL,G1H6(89),ex4(:),G1H2(43),m3h3x2(:,121),heltab2x6(:,:,258))
  call Hloop_Q_A(ntryL,G1H2(43),47,0,G2H2(331),n2h2(215))
  call Hloop_QW_A(ntryL,G1H6(87),ex4(:),G1H2(44),m3h3x2(:,122),heltab2x6(:,:,259))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(332),n2h2(216))
  call Hloop_QV_A(ntryL,G1H4(107),ex5(:),G1H2(49),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(49),59,0,G2H2(333),n2h2(217))
call HGT_OLR(G1H4(119),1,1,4)
call HGT_invQ_OLR(G1H4(119),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(119),-4,0,G2H4(56),n2h4(279))
  call Hloop_AV_Q(ntryL,G2H4(56),ex3(:),G2H2(334),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_QV_A(ntryL,G1H4(171),ex5(:),G1H2(50),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(50),59,0,G2H2(335),n2h2(218))
  call Hloop_QV_A(ntryL,G1H4(137),ex5(:),G1H2(55),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(55),59,0,G2H2(336),n2h2(219))
  call Hloop_QV_A(ntryL,G1H4(93),ex5(:),G1H2(56),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_Q_A(ntryL,G1H2(56),59,0,G2H2(337),n2h2(220))
call HGT_OLR(G1H4(1),1,1,4)
call HGT_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1),-4,0,G2H4(80),n2h4(280))
  call Hloop_AV_Q(ntryL,G2H4(80),ex3(:),G2H2(338),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_QV_A(ntryL,G1H4(99),ex5(:),G1H2(61),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(61),59,0,G2H2(339),n2h2(221))
  call Hloop_QV_A(ntryL,G1H4(188),ex5(:),G1H2(62),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_Q_A(ntryL,G1H2(62),59,0,G2H2(340),n2h2(222))
  call Hloop_QV_A(ntryL,G1H6(101),ex3(:),G1H3(73),m3h2x3(:,138),heltab2x6(:,:,260))
  call Hloop_Q_A(ntryL,G1H3(73),55,0,G2H3(120),n2h3(107))
call HGT_OLR(G1H6(197),1,1,6)
call HGT_invQ_OLR(G1H6(197),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(197),-8,0,G2H6(37),n2h6(206))
  call Hloop_AW_Q(ntryL,G2H6(37),ex4(:),G2H2(341),m3h3x2(:,123),heltab2x6(:,:,261))
  call Hloop_QV_A(ntryL,G1H6(221),ex3(:),G1H3(74),m3h2x3(:,139),heltab2x6(:,:,262))
  call Hloop_Q_A(ntryL,G1H3(74),55,0,G2H3(121),n2h3(108))
  call Hloop_QV_A(ntryL,G1H6(125),ex3(:),G1H3(7),m3h2x3(:,140),heltab2x6(:,:,263))
  call Hloop_Q_A(ntryL,G1H3(7),55,0,G2H3(122),n2h3(109))
  call Hloop_QV_A(ntryL,G1H6(137),ex5(:),G1H3(8),m3h2x3(:,141),heltab2x6(:,:,264))
  call Hloop_Q_A(ntryL,G1H3(8),55,0,G2H3(123),n2h3(110))
call HGT_OLR(G1H6(149),1,1,6)
call HGT_invQ_OLR(G1H6(149),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(149),-8,0,G2H6(113),n2h6(207))
  call Hloop_AW_Q(ntryL,G2H6(113),ex4(:),G2H2(342),m3h3x2(:,124),heltab2x6(:,:,265))
  call Hloop_QV_A(ntryL,G1H6(161),ex5(:),G1H3(13),m3h2x3(:,142),heltab2x6(:,:,266))
  call Hloop_Q_A(ntryL,G1H3(13),55,0,G2H3(124),n2h3(111))
  call Hloop_QV_A(ntryL,G1H6(51),ex5(:),G1H3(14),m3h2x3(:,143),heltab2x6(:,:,267))
  call Hloop_Q_A(ntryL,G1H3(14),55,0,G2H3(125),n2h3(112))
  call Hloop_QW_A(ntryL,G1H6(245),ex4(:),G1H2(67),m3h3x2(:,125),heltab2x6(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(67),59,0,G2H2(343),n2h2(223))
call HGT_OLR(G1H6(173),1,1,6)
call HGT_invQ_OLR(G1H6(173),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(173),-4,0,G2H6(115),n2h6(208))
  call Hloop_AV_Q(ntryL,G2H6(115),ex3(:),G2H3(126),m3h2x3(:,144),heltab2x6(:,:,269))
  call Hloop_QW_A(ntryL,G1H6(75),ex4(:),G1H2(68),m3h3x2(:,126),heltab2x6(:,:,270))
  call Hloop_Q_A(ntryL,G1H2(68),59,0,G2H2(344),n2h2(224))
  call Hloop_QW_A(ntryL,G1H6(1),ex4(:),G1H2(73),m3h3x2(:,127),heltab2x6(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(73),59,0,G2H2(345),n2h2(225))
  call Hloop_UV_W(ntryL,G1H4(154),45,ex5(:),16,G2H2(346),m3h2x2(:,247),heltab2x4(:,:,247))
call HGT_OLR(G1H4(81),1,1,4)
call HGT_invQ_OLR(G1H4(81),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(81),-2,0,G2H4(57),n2h4(281))
  call Hloop_AQ_V(ntryL,G2H4(57),ex2(:),G2H2(347),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_UV_W(ntryL,G1H4(22),45,ex5(:),16,G2H2(348),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_UV_W(ntryL,G1H4(10),45,ex5(:),16,G2H2(349),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_VA_Q(ntryL,G1H4(16),ex1(:),G1H2(74),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_A_Q(ntryL,G1H2(74),59,0,G2H2(350),n2h2(226))
call HGT_OLR(G1H4(21),1,1,4)
call HGT_invQ_OLR(G1H4(21),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(21),-4,0,G2H4(92),n2h4(282))
  call Hloop_QV_A(ntryL,G2H4(92),ex3(:),G2H2(351),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_VA_Q(ntryL,G1H4(40),ex1(:),G1H2(79),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_A_Q(ntryL,G1H2(79),59,0,G2H2(352),n2h2(227))
  call Hloop_VA_Q(ntryL,G1H4(45),ex1(:),G1H2(80),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_A_Q(ntryL,G1H2(80),59,0,G2H2(353),n2h2(228))
  call Hloop_UV_W(ntryL,G1H4(58),46,ex5(:),16,G2H2(354),m3h2x2(:,255),heltab2x4(:,:,255))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(70),-1,0,G2H4(61),n2h4(283))
  call Hloop_QA_V(ntryL,G2H4(61),ex1(:),G2H2(355),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_UV_W(ntryL,G1H4(105),46,ex5(:),16,G2H2(356),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_UV_W(ntryL,G1H4(106),46,ex5(:),16,G2H2(357),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_VA_Q(ntryL,G1H6(274),ex1(:),G1H3(19),m3h2x3(:,145),heltab2x6(:,:,272))
  call Hloop_A_Q(ntryL,G1H3(19),55,0,G2H3(127),n2h3(113))
call HGT_OLR(G1H6(257),1,1,6)
call HGT_invQ_OLR(G1H6(257),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(257),-8,0,G2H6(116),n2h6(209))
  call Hloop_QW_A(ntryL,G2H6(116),ex4(:),G2H2(358),m3h3x2(:,128),heltab2x6(:,:,273))
  call Hloop_VA_Q(ntryL,G1H6(263),ex1(:),G1H3(20),m3h2x3(:,146),heltab2x6(:,:,274))
  call Hloop_A_Q(ntryL,G1H3(20),55,0,G2H3(128),n2h3(114))
  call Hloop_VA_Q(ntryL,G1H6(63),ex1(:),G1H3(25),m3h2x3(:,147),heltab2x6(:,:,275))
  call Hloop_A_Q(ntryL,G1H3(25),55,0,G2H3(129),n2h3(115))
  call Hloop_VQ_A(ntryL,G1H4(117),ex2(:),G1H2(85),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_Q_A(ntryL,G1H2(85),59,0,G2H2(359),n2h2(229))
call HGT_OLR(G1H4(118),1,1,4)
call HGT_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(118),-4,0,G2H4(96),n2h4(284))
  call Hloop_AV_Q(ntryL,G2H4(96),ex3(:),G2H2(360),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_VQ_A(ntryL,G1H4(135),ex2(:),G1H2(86),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_Q_A(ntryL,G1H2(86),59,0,G2H2(361),n2h2(230))
  call Hloop_VQ_A(ntryL,G1H4(136),ex2(:),G1H2(91),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_Q_A(ntryL,G1H2(91),59,0,G2H2(362),n2h2(231))
  call Hloop_VQ_A(ntryL,G1H6(4),ex2(:),G1H3(26),m3h2x3(:,148),heltab2x6(:,:,276))
  call Hloop_Q_A(ntryL,G1H3(26),55,0,G2H3(130),n2h3(116))
call HGT_OLR(G1H6(69),1,1,6)
call HGT_invQ_OLR(G1H6(69),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(69),-8,0,G2H6(77),n2h6(210))
  call Hloop_AW_Q(ntryL,G2H6(77),ex4(:),G2H2(363),m3h3x2(:,129),heltab2x6(:,:,277))
  call Hloop_VQ_A(ntryL,G1H6(129),ex2(:),G1H3(31),m3h2x3(:,149),heltab2x6(:,:,278))
  call Hloop_Q_A(ntryL,G1H3(31),55,0,G2H3(131),n2h3(117))
  call Hloop_VQ_A(ntryL,G1H6(111),ex2(:),G1H3(32),m3h2x3(:,150),heltab2x6(:,:,279))
  call Hloop_Q_A(ntryL,G1H3(32),55,0,G2H3(132),n2h3(118))
  call Hloop_QV_A(ntryL,G1H4(143),ex3(:),G1H2(92),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(92),62,0,G2H2(364),n2h2(232))
call HGT_raise_alpha_OLR(G1H4(146),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(146),ex1(:),G1H2(97),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_QV_A(ntryL,G1H4(163),ex3(:),G1H2(98),m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(98),62,0,G2H2(365),n2h2(233))
  call Hloop_QV_A(ntryL,G1H4(181),ex3(:),G1H2(103),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_Q_A(ntryL,G1H2(103),62,0,G2H2(366),n2h2(234))
call HGT_raise_alpha_OLR(G1H4(164),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(164),ex1(:),G1H2(104),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_QV_A(ntryL,G1H4(180),ex3(:),G1H2(109),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(109),62,0,G2H2(367),n2h2(235))
call HGT_raise_alpha_OLR(G1H4(186),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(186),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(186),ex1(:),G1H2(110),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_QV_A(ntryL,G1H4(196),ex3(:),G1H2(115),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_Q_A(ntryL,G1H2(115),62,0,G2H2(368),n2h2(236))
  call Hloop_AW_Q(ntryL,G1H6(10),ex4(:),G1H2(116),m3h3x2(:,130),heltab2x6(:,:,280))
  call Hloop_A_Q(ntryL,G1H2(116),61,0,G2H2(369),n2h2(237))
call HGT_raise_alpha_OLR(G1H6(117),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(117),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(117),ex2(:),G1H3(37),m3h2x3(:,151),heltab2x6(:,:,281))
  call Hloop_AW_Q(ntryL,G1H6(28),ex4(:),G1H2(121),m3h3x2(:,131),heltab2x6(:,:,282))
  call Hloop_A_Q(ntryL,G1H2(121),61,0,G2H2(370),n2h2(238))
  call Hloop_AW_Q(ntryL,G1H6(76),ex4(:),G1H2(122),m3h3x2(:,132),heltab2x6(:,:,283))
  call Hloop_A_Q(ntryL,G1H2(122),61,0,G2H2(371),n2h2(239))
call HGT_raise_alpha_OLR(G1H6(35),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(35),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(35),ex2(:),G1H3(38),m3h2x3(:,152),heltab2x6(:,:,284))
  call Hloop_AW_Q(ntryL,G1H6(64),ex4(:),G1H2(127),m3h3x2(:,133),heltab2x6(:,:,285))
  call Hloop_A_Q(ntryL,G1H2(127),61,0,G2H2(372),n2h2(240))
call HGT_raise_alpha_OLR(G1H6(88),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(88),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(88),ex2(:),G1H3(43),m3h2x3(:,153),heltab2x6(:,:,286))
  call Hloop_AW_Q(ntryL,G1H6(119),ex4(:),G1H2(128),m3h3x2(:,134),heltab2x6(:,:,287))
  call Hloop_A_Q(ntryL,G1H2(128),61,0,G2H2(373),n2h2(241))
  call Hloop_AV_Q(ntryL,G1H6(124),ex5(:),G1H3(44),m3h2x3(:,154),heltab2x6(:,:,288))
  call Hloop_A_Q(ntryL,G1H3(44),55,0,G2H3(133),n2h3(119))
call HGT_OLR(G1H6(131),1,1,6)
call HGT_invQ_OLR(G1H6(131),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(131),-8,0,G2H6(89),n2h6(214))
  call Hloop_QW_A(ntryL,G2H6(89),ex4(:),G2H2(374),m3h3x2(:,135),heltab2x6(:,:,289))
  call Hloop_AV_Q(ntryL,G1H6(147),ex5(:),G1H3(49),m3h2x3(:,155),heltab2x6(:,:,290))
  call Hloop_A_Q(ntryL,G1H3(49),55,0,G2H3(134),n2h3(120))
  call Hloop_AV_Q(ntryL,G1H6(148),ex5(:),G1H3(50),m3h2x3(:,156),heltab2x6(:,:,291))
  call Hloop_A_Q(ntryL,G1H3(50),55,0,G2H3(135),n2h3(121))
  call Hloop_AW_Q(ntryL,G1H6(159),ex4(:),G1H2(133),m3h3x2(:,136),heltab2x6(:,:,292))
  call Hloop_A_Q(ntryL,G1H2(133),61,0,G2H2(375),n2h2(242))
call HGT_raise_alpha_OLR(G1H6(160),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(160),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(160),ex2(:),G1H3(55),m3h2x3(:,157),heltab2x6(:,:,293))
  call Hloop_AW_Q(ntryL,G1H6(184),ex4(:),G1H2(134),m3h3x2(:,137),heltab2x6(:,:,294))
  call Hloop_A_Q(ntryL,G1H2(134),61,0,G2H2(376),n2h2(243))
  call Hloop_AW_Q(ntryL,G1H6(220),ex4(:),G1H2(139),m3h3x2(:,138),heltab2x6(:,:,295))
  call Hloop_A_Q(ntryL,G1H2(139),61,0,G2H2(377),n2h2(244))
call HGT_raise_alpha_OLR(G1H6(195),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(195),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(195),ex2(:),G1H3(56),m3h2x3(:,158),heltab2x6(:,:,296))
  call Hloop_AW_Q(ntryL,G1H6(219),ex4(:),G1H2(140),m3h3x2(:,139),heltab2x6(:,:,297))
  call Hloop_A_Q(ntryL,G1H2(140),61,0,G2H2(378),n2h2(245))
call HGT_raise_alpha_OLR(G1H6(231),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(231),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(231),ex2(:),G1H3(61),m3h2x3(:,159),heltab2x6(:,:,298))
  call Hloop_AW_Q(ntryL,G1H6(244),ex4(:),G1H2(13),m3h3x2(:,140),heltab2x6(:,:,299))
  call Hloop_A_Q(ntryL,G1H2(13),61,0,G2H2(379),n2h2(246))
  call Hloop_AW_Q(ntryL,G1H6(255),ex4(:),G1H2(14),m3h3x2(:,141),heltab2x6(:,:,300))
  call Hloop_A_Q(ntryL,G1H2(14),47,0,G2H2(380),n2h2(247))
call HGT_OLR(G1H6(256),1,1,6)
call HGT_invQ_OLR(G1H6(256),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(256),-16,0,G2H6(81),n2h6(218))
  call Hloop_QV_A(ntryL,G2H6(81),ex5(:),G2H3(136),m3h2x3(:,160),heltab2x6(:,:,301))
  call Hloop_AW_Q(ntryL,G1H6(269),ex4(:),G1H2(19),m3h3x2(:,142),heltab2x6(:,:,302))
  call Hloop_A_Q(ntryL,G1H2(19),47,0,G2H2(381),n2h2(248))
  call Hloop_AW_Q(ntryL,G1H6(272),ex4(:),G1H2(20),m3h3x2(:,143),heltab2x6(:,:,303))
  call Hloop_A_Q(ntryL,G1H2(20),47,0,G2H2(382),n2h2(249))
  call Hloop_AV_Q(ntryL,G1H4(197),ex5(:),G1H2(25),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_A_Q(ntryL,G1H2(25),61,0,G2H2(383),n2h2(250))
call HGT_raise_alpha_OLR(G1H4(198),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(198),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(198),ex2(:),G1H2(26),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_AV_Q(ntryL,G1H4(203),ex5(:),G1H2(31),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_A_Q(ntryL,G1H2(31),61,0,G2H2(384),n2h2(251))
  call Hloop_AV_Q(ntryL,G1H4(208),ex5(:),G1H2(32),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_A_Q(ntryL,G1H2(32),61,0,G2H2(385),n2h2(252))
call HGT_raise_alpha_OLR(G1H4(204),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(204),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(204),ex2(:),G1H2(37),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_AV_Q(ntryL,G1H4(207),ex5(:),G1H2(38),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_A_Q(ntryL,G1H2(38),61,0,G2H2(386),n2h2(253))
call HGT_raise_alpha_OLR(G1H4(209),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(209),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(209),ex2(:),G1H2(43),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_AV_Q(ntryL,G1H4(212),ex5(:),G1H2(44),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_A_Q(ntryL,G1H2(44),61,0,G2H2(387),n2h2(254))
  call Hloop_QW_A(ntryL,G1H6(273),ex4(:),G1H2(49),m3h3x2(:,144),heltab2x6(:,:,304))
  call Hloop_Q_A(ntryL,G1H2(49),62,0,G2H2(388),n2h2(255))
call HGT_raise_alpha_OLR(G1H6(278),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(278),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(278),ex1(:),G1H3(62),m3h2x3(:,161),heltab2x6(:,:,305))
  call Hloop_QW_A(ntryL,G1H6(6),ex4(:),G1H2(50),m3h3x2(:,145),heltab2x6(:,:,306))
  call Hloop_Q_A(ntryL,G1H2(50),62,0,G2H2(389),n2h2(256))
  call Hloop_QW_A(ntryL,G1H6(291),ex4(:),G1H2(55),m3h3x2(:,146),heltab2x6(:,:,307))
  call Hloop_Q_A(ntryL,G1H2(55),62,0,G2H2(390),n2h2(257))
call HGT_raise_alpha_OLR(G1H6(287),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(287),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(287),ex1(:),G1H3(67),m3h2x3(:,162),heltab2x6(:,:,308))
  call Hloop_QW_A(ntryL,G1H6(290),ex4(:),G1H2(56),m3h3x2(:,147),heltab2x6(:,:,309))
  call Hloop_Q_A(ntryL,G1H2(56),62,0,G2H2(391),n2h2(258))
call HGT_raise_alpha_OLR(G1H6(292),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(292),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(292),ex1(:),G1H3(68),m3h2x3(:,163),heltab2x6(:,:,310))
  call Hloop_QW_A(ntryL,G1H6(295),ex4(:),G1H2(61),m3h3x2(:,148),heltab2x6(:,:,311))
  call Hloop_Q_A(ntryL,G1H2(61),62,0,G2H2(392),n2h2(259))
  call Hloop_AV_Q(ntryL,G1H4(213),ex3(:),G1H2(62),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_A_Q(ntryL,G1H2(62),61,0,G2H2(393),n2h2(260))
call HGT_raise_alpha_OLR(G1H4(214),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(214),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(214),ex2(:),G1H2(67),m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_AV_Q(ntryL,G1H4(219),ex3(:),G1H2(68),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_A_Q(ntryL,G1H2(68),61,0,G2H2(394),n2h2(261))
  call Hloop_AV_Q(ntryL,G1H4(224),ex3(:),G1H2(73),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_A_Q(ntryL,G1H2(73),61,0,G2H2(395),n2h2(262))
call HGT_raise_alpha_OLR(G1H4(220),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(220),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(220),ex2(:),G1H2(74),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_AV_Q(ntryL,G1H4(223),ex3(:),G1H2(79),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_A_Q(ntryL,G1H2(79),61,0,G2H2(396),n2h2(263))
call HGT_raise_alpha_OLR(G1H4(225),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(225),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(225),ex2(:),G1H2(80),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_AV_Q(ntryL,G1H4(228),ex3(:),G1H2(85),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_A_Q(ntryL,G1H2(85),61,0,G2H2(397),n2h2(264))
  call Hloop_AV_Q(ntryL,G1H4(229),ex5(:),G1H2(86),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_A_Q(ntryL,G1H2(86),59,0,G2H2(398),n2h2(265))
call HGT_OLR(G1H4(230),1,1,4)
call HGT_invQ_OLR(G1H4(230),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(230),-4,0,G2H4(94),n2h4(294))
  call Hloop_QV_A(ntryL,G2H4(94),ex3(:),G2H2(399),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_AV_Q(ntryL,G1H4(233),ex5(:),G1H2(91),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_A_Q(ntryL,G1H2(91),59,0,G2H2(400),n2h2(266))
  call Hloop_AV_Q(ntryL,G1H4(234),ex5(:),G1H2(92),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_A_Q(ntryL,G1H2(92),59,0,G2H2(401),n2h2(267))
  call Hloop_AV_Q(ntryL,G1H4(235),ex3(:),G1H2(98),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_A_Q(ntryL,G1H2(98),61,0,G2H2(402),n2h2(268))
call HGT_raise_alpha_OLR(G1H4(236),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(236),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(236),ex2(:),G1H2(103),m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_AV_Q(ntryL,G1H4(2),ex3(:),G1H2(109),m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_A_Q(ntryL,G1H2(109),61,0,G2H2(403),n2h2(269))
  call Hloop_AV_Q(ntryL,G1H4(245),ex3(:),G1H2(115),m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_A_Q(ntryL,G1H2(115),61,0,G2H2(404),n2h2(270))
call HGT_raise_alpha_OLR(G1H4(241),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(241),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(241),ex2(:),G1H2(116),m3h2x2(:,295),heltab2x4(:,:,295))
  call Hloop_AV_Q(ntryL,G1H4(244),ex3(:),G1H2(121),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_A_Q(ntryL,G1H2(121),61,0,G2H2(405),n2h2(271))
call HGT_raise_alpha_OLR(G1H4(246),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(246),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(246),ex2(:),G1H2(122),m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_AV_Q(ntryL,G1H4(249),ex3(:),G1H2(127),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_A_Q(ntryL,G1H2(127),61,0,G2H2(406),n2h2(272))
  call Hloop_AV_Q(ntryL,G1H4(3),ex3(:),G1H2(128),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_A_Q(ntryL,G1H2(128),47,0,G2H2(407),n2h2(273))
call HGT_OLR(G1H4(250),1,1,4)
call HGT_invQ_OLR(G1H4(250),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(250),-16,0,G2H4(65),n2h4(298))
  call Hloop_QV_A(ntryL,G2H4(65),ex5(:),G2H2(408),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_AV_Q(ntryL,G1H4(253),ex3(:),G1H2(133),m3h2x2(:,301),heltab2x4(:,:,301))
  call Hloop_A_Q(ntryL,G1H2(133),47,0,G2H2(409),n2h2(274))
  call Hloop_AV_Q(ntryL,G1H4(254),ex3(:),G1H2(134),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_A_Q(ntryL,G1H2(134),47,0,G2H2(410),n2h2(275))
  call Hloop_AW_Q(ntryL,G1H6(296),ex4(:),G1H2(139),m3h3x2(:,149),heltab2x6(:,:,312))
  call Hloop_A_Q(ntryL,G1H2(139),59,0,G2H2(411),n2h2(276))
call HGT_OLR(G1H6(297),1,1,6)
call HGT_invQ_OLR(G1H6(297),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(297),-4,0,G2H6(79),n2h6(222))
  call Hloop_QV_A(ntryL,G2H6(79),ex3(:),G2H3(137),m3h2x3(:,164),heltab2x6(:,:,313))
  call Hloop_AW_Q(ntryL,G1H6(300),ex4(:),G1H2(140),m3h3x2(:,150),heltab2x6(:,:,314))
  call Hloop_A_Q(ntryL,G1H2(140),59,0,G2H2(412),n2h2(277))
  call Hloop_AW_Q(ntryL,G1H6(301),ex4(:),G1H2(13),m3h3x2(:,151),heltab2x6(:,:,315))
  call Hloop_A_Q(ntryL,G1H2(13),59,0,G2H2(413),n2h2(278))
  call Hloop_AV_Q(ntryL,G1H6(8),ex3(:),G1H3(73),m3h2x3(:,165),heltab2x6(:,:,316))
  call Hloop_A_Q(ntryL,G1H3(73),55,0,G2H3(138),n2h3(122))
call HGT_OLR(G1H6(9),1,1,6)
call HGT_invQ_OLR(G1H6(9),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(9),-8,0,G2H6(80),n2h6(223))
  call Hloop_QW_A(ntryL,G2H6(80),ex4(:),G2H2(414),m3h3x2(:,152),heltab2x6(:,:,317))
  call Hloop_AV_Q(ntryL,G1H6(304),ex3(:),G1H3(74),m3h2x3(:,166),heltab2x6(:,:,318))
  call Hloop_A_Q(ntryL,G1H3(74),55,0,G2H3(139),n2h3(123))
  call Hloop_AV_Q(ntryL,G1H6(305),ex3(:),G1H3(7),m3h2x3(:,167),heltab2x6(:,:,319))
  call Hloop_A_Q(ntryL,G1H3(7),55,0,G2H3(140),n2h3(124))
  call Hloop_VQ_A(ntryL,G1H4(5),ex2(:),G1H2(14),m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(415),n2h2(279))
call HGT_OLR(G1H4(6),1,1,4)
call HGT_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(6),-16,0,G2H4(63),n2h4(299))
  call Hloop_AV_Q(ntryL,G2H4(63),ex5(:),G2H2(416),m3h2x2(:,304),heltab2x4(:,:,304))
  call Hloop_VQ_A(ntryL,G1H4(257),ex2(:),G1H2(19),m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(417),n2h2(280))
  call Hloop_VQ_A(ntryL,G1H4(258),ex2(:),G1H2(20),m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(418),n2h2(281))
  call Hloop_VQ_A(ntryL,G1H4(15),ex2(:),G1H2(25),m3h2x2(:,307),heltab2x4(:,:,307))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(419),n2h2(282))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(28),-16,0,G2H4(95),n2h4(300))
  call Hloop_AV_Q(ntryL,G2H4(95),ex5(:),G2H2(420),m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_VQ_A(ntryL,G1H4(260),ex2(:),G1H2(31),m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(421),n2h2(283))
  call Hloop_VQ_A(ntryL,G1H4(261),ex2(:),G1H2(32),m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_Q_A(ntryL,G1H2(32),47,0,G2H2(422),n2h2(284))
  call Hloop_VA_Q(ntryL,G1H6(11),ex1(:),G1H3(8),m3h2x3(:,168),heltab2x6(:,:,320))
  call Hloop_A_Q(ntryL,G1H3(8),55,0,G2H3(141),n2h3(125))
call HGT_OLR(G1H6(12),1,1,6)
call HGT_invQ_OLR(G1H6(12),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(12),-8,0,G2H6(122),n2h6(224))
  call Hloop_QW_A(ntryL,G2H6(122),ex4(:),G2H2(423),m3h3x2(:,153),heltab2x6(:,:,321))
  call Hloop_VA_Q(ntryL,G1H6(308),ex1(:),G1H3(13),m3h2x3(:,169),heltab2x6(:,:,322))
  call Hloop_A_Q(ntryL,G1H3(13),55,0,G2H3(142),n2h3(126))
  call Hloop_VA_Q(ntryL,G1H6(309),ex1(:),G1H3(14),m3h2x3(:,170),heltab2x6(:,:,323))
  call Hloop_A_Q(ntryL,G1H3(14),55,0,G2H3(143),n2h3(127))
  call Hloop_VA_Q(ntryL,G1H6(310),ex1(:),G1H3(19),m3h2x3(:,171),heltab2x6(:,:,324))
  call Hloop_A_Q(ntryL,G1H3(19),55,0,G2H3(144),n2h3(128))
call HGT_OLR(G1H6(311),1,1,6)
call HGT_invQ_OLR(G1H6(311),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(311),-8,0,G2H6(124),n2h6(225))
  call Hloop_QW_A(ntryL,G2H6(124),ex4(:),G2H2(424),m3h3x2(:,154),heltab2x6(:,:,325))
  call Hloop_VA_Q(ntryL,G1H6(314),ex1(:),G1H3(20),m3h2x3(:,172),heltab2x6(:,:,326))
  call Hloop_A_Q(ntryL,G1H3(20),55,0,G2H3(145),n2h3(129))
  call Hloop_VA_Q(ntryL,G1H6(315),ex1(:),G1H3(25),m3h2x3(:,173),heltab2x6(:,:,327))
  call Hloop_A_Q(ntryL,G1H3(25),55,0,G2H3(146),n2h3(130))
  call Hloop_VA_Q(ntryL,G1H4(27),ex1(:),G1H2(38),m3h2x2(:,311),heltab2x4(:,:,311))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(425),n2h2(285))
call HGT_OLR(G1H4(29),1,1,4)
call HGT_invQ_OLR(G1H4(29),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(29),-16,0,G2H4(64),n2h4(301))
  call Hloop_QV_A(ntryL,G2H4(64),ex5(:),G2H2(426),m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_VA_Q(ntryL,G1H4(264),ex1(:),G1H2(44),m3h2x2(:,313),heltab2x4(:,:,313))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(427),n2h2(286))
  call Hloop_VA_Q(ntryL,G1H4(265),ex1(:),G1H2(49),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_A_Q(ntryL,G1H2(49),47,0,G2H2(428),n2h2(287))
  call Hloop_VA_Q(ntryL,G1H4(39),ex1(:),G1H2(50),m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_A_Q(ntryL,G1H2(50),47,0,G2H2(429),n2h2(288))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(52),-16,0,G2H4(168),n2h4(302))
  call Hloop_QV_A(ntryL,G2H4(168),ex5(:),G2H2(430),m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_VA_Q(ntryL,G1H4(267),ex1(:),G1H2(55),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_A_Q(ntryL,G1H2(55),47,0,G2H2(431),n2h2(289))
  call Hloop_VA_Q(ntryL,G1H4(268),ex1(:),G1H2(56),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_A_Q(ntryL,G1H2(56),47,0,G2H2(432),n2h2(290))
  call Hloop_VQ_A(ntryL,G1H6(21),ex2(:),G1H3(26),m3h2x3(:,174),heltab2x6(:,:,328))
  call Hloop_Q_A(ntryL,G1H3(26),55,0,G2H3(147),n2h3(131))
call HGT_OLR(G1H6(22),1,1,6)
call HGT_invQ_OLR(G1H6(22),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(22),-8,0,G2H6(125),n2h6(226))
  call Hloop_AW_Q(ntryL,G2H6(125),ex4(:),G2H2(433),m3h3x2(:,155),heltab2x6(:,:,329))
  call Hloop_VQ_A(ntryL,G1H6(317),ex2(:),G1H3(31),m3h2x3(:,175),heltab2x6(:,:,330))
  call Hloop_Q_A(ntryL,G1H3(31),55,0,G2H3(148),n2h3(132))
  call Hloop_VQ_A(ntryL,G1H6(318),ex2(:),G1H3(32),m3h2x3(:,176),heltab2x6(:,:,331))
  call Hloop_Q_A(ntryL,G1H3(32),55,0,G2H3(149),n2h3(133))
  call Hloop_VQ_A(ntryL,G1H6(319),ex2(:),G1H3(44),m3h2x3(:,177),heltab2x6(:,:,332))
  call Hloop_Q_A(ntryL,G1H3(44),55,0,G2H3(150),n2h3(134))
call HGT_OLR(G1H6(320),1,1,6)
call HGT_invQ_OLR(G1H6(320),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(320),-8,0,G2H6(62),n2h6(227))
  call Hloop_AW_Q(ntryL,G2H6(62),ex4(:),G2H2(434),m3h3x2(:,156),heltab2x6(:,:,333))
  call Hloop_VQ_A(ntryL,G1H6(323),ex2(:),G1H3(49),m3h2x3(:,178),heltab2x6(:,:,334))
  call Hloop_Q_A(ntryL,G1H3(49),55,0,G2H3(151),n2h3(135))
  call Hloop_VQ_A(ntryL,G1H6(324),ex2(:),G1H3(50),m3h2x3(:,179),heltab2x6(:,:,335))
  call Hloop_Q_A(ntryL,G1H3(50),55,0,G2H3(152),n2h3(136))
  call Hloop_AV_Q(ntryL,G1H4(51),ex3(:),G1H2(61),m3h2x2(:,319),heltab2x4(:,:,319))
  call Hloop_A_Q(ntryL,G1H2(61),47,0,G2H2(435),n2h2(291))
call HGT_OLR(G1H4(53),1,1,4)
call HGT_invQ_OLR(G1H4(53),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(53),-16,0,G2H4(170),n2h4(303))
  call Hloop_QV_A(ntryL,G2H4(170),ex5(:),G2H2(436),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_AV_Q(ntryL,G1H4(271),ex3(:),G1H2(62),m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_A_Q(ntryL,G1H2(62),47,0,G2H2(437),n2h2(292))
  call Hloop_AV_Q(ntryL,G1H4(272),ex3(:),G1H2(68),m3h2x2(:,322),heltab2x4(:,:,322))
  call Hloop_A_Q(ntryL,G1H2(68),47,0,G2H2(438),n2h2(293))
  call Hloop_QW_A(ntryL,G1H6(33),ex4(:),G1H2(73),m3h3x2(:,157),heltab2x6(:,:,336))
  call Hloop_Q_A(ntryL,G1H2(73),47,0,G2H2(439),n2h2(294))
call HGT_OLR(G1H6(34),1,1,6)
call HGT_invQ_OLR(G1H6(34),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(34),-16,0,G2H6(65),n2h6(228))
  call Hloop_AV_Q(ntryL,G2H6(65),ex5(:),G2H3(153),m3h2x3(:,180),heltab2x6(:,:,337))
  call Hloop_QW_A(ntryL,G1H6(326),ex4(:),G1H2(79),m3h3x2(:,158),heltab2x6(:,:,338))
  call Hloop_Q_A(ntryL,G1H2(79),47,0,G2H2(440),n2h2(295))
  call Hloop_QW_A(ntryL,G1H6(327),ex4(:),G1H2(85),m3h3x2(:,159),heltab2x6(:,:,339))
  call Hloop_Q_A(ntryL,G1H2(85),47,0,G2H2(441),n2h2(296))
  call Hloop_QV_A(ntryL,G1H6(45),ex5(:),G1H3(73),m3h2x3(:,181),heltab2x6(:,:,340))
  call Hloop_Q_A(ntryL,G1H3(73),55,0,G2H3(154),n2h3(137))
call HGT_OLR(G1H6(46),1,1,6)
call HGT_invQ_OLR(G1H6(46),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(46),-8,0,G2H6(69),n2h6(229))
  call Hloop_AW_Q(ntryL,G2H6(69),ex4(:),G2H2(442),m3h3x2(:,160),heltab2x6(:,:,341))
  call Hloop_QV_A(ntryL,G1H6(329),ex5(:),G1H3(74),m3h2x3(:,182),heltab2x6(:,:,342))
  call Hloop_Q_A(ntryL,G1H3(74),55,0,G2H3(155),n2h3(138))
  call Hloop_QV_A(ntryL,G1H6(330),ex5(:),G1H3(7),m3h2x3(:,183),heltab2x6(:,:,343))
  call Hloop_Q_A(ntryL,G1H3(7),55,0,G2H3(156),n2h3(139))
  call Hloop_AW_Q(ntryL,G1H6(57),ex4(:),G1H2(86),m3h3x2(:,161),heltab2x6(:,:,344))
  call Hloop_A_Q(ntryL,G1H2(86),47,0,G2H2(443),n2h2(297))
call HGT_OLR(G1H6(58),1,1,6)
call HGT_invQ_OLR(G1H6(58),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(58),-16,0,G2H6(72),n2h6(230))
  call Hloop_QV_A(ntryL,G2H6(72),ex5(:),G2H3(157),m3h2x3(:,184),heltab2x6(:,:,345))
  call Hloop_AW_Q(ntryL,G1H6(332),ex4(:),G1H2(91),m3h3x2(:,162),heltab2x6(:,:,346))
  call Hloop_A_Q(ntryL,G1H2(91),47,0,G2H2(444),n2h2(298))
  call Hloop_AW_Q(ntryL,G1H6(333),ex4(:),G1H2(92),m3h3x2(:,163),heltab2x6(:,:,347))
  call Hloop_A_Q(ntryL,G1H2(92),47,0,G2H2(445),n2h2(299))
  call Hloop_AV_Q(ntryL,G1H6(70),ex5(:),G1H3(8),m3h2x3(:,185),heltab2x6(:,:,348))
  call Hloop_A_Q(ntryL,G1H3(8),55,0,G2H3(158),n2h3(140))
call HGT_OLR(G1H6(71),1,1,6)
call HGT_invQ_OLR(G1H6(71),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(71),-8,0,G2H6(102),n2h6(231))
  call Hloop_QW_A(ntryL,G2H6(102),ex4(:),G2H2(446),m3h3x2(:,164),heltab2x6(:,:,349))
  call Hloop_AV_Q(ntryL,G1H6(336),ex5(:),G1H3(13),m3h2x3(:,186),heltab2x6(:,:,350))
  call Hloop_A_Q(ntryL,G1H3(13),55,0,G2H3(159),n2h3(141))
  call Hloop_AV_Q(ntryL,G1H6(337),ex5(:),G1H3(14),m3h2x3(:,187),heltab2x6(:,:,351))
  call Hloop_A_Q(ntryL,G1H3(14),55,0,G2H3(160),n2h3(142))
  call Hloop_QV_A(ntryL,G1H4(63),ex3(:),G1H2(98),m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_Q_A(ntryL,G1H2(98),47,0,G2H2(447),n2h2(300))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(64),-16,0,G2H4(171),n2h4(304))
  call Hloop_AV_Q(ntryL,G2H4(171),ex5(:),G2H2(448),m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_QV_A(ntryL,G1H4(274),ex3(:),G1H2(109),m3h2x2(:,325),heltab2x4(:,:,325))
  call Hloop_Q_A(ntryL,G1H2(109),47,0,G2H2(449),n2h2(301))
  call Hloop_QV_A(ntryL,G1H4(275),ex3(:),G1H2(115),m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_Q_A(ntryL,G1H2(115),47,0,G2H2(450),n2h2(302))
  call Hloop_AW_Q(ntryL,G1H6(82),ex4(:),G1H2(121),m3h3x2(:,165),heltab2x6(:,:,352))
  call Hloop_A_Q(ntryL,G1H2(121),47,0,G2H2(451),n2h2(303))
call HGT_OLR(G1H6(83),1,1,6)
call HGT_invQ_OLR(G1H6(83),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(83),-16,0,G2H6(99),n2h6(232))
  call Hloop_QV_A(ntryL,G2H6(99),ex5(:),G2H3(161),m3h2x3(:,188),heltab2x6(:,:,353))
  call Hloop_AW_Q(ntryL,G1H6(340),ex4(:),G1H2(127),m3h3x2(:,166),heltab2x6(:,:,354))
  call Hloop_A_Q(ntryL,G1H2(127),47,0,G2H2(452),n2h2(304))
  call Hloop_AW_Q(ntryL,G1H6(341),ex4(:),G1H2(128),m3h3x2(:,167),heltab2x6(:,:,355))
  call Hloop_A_Q(ntryL,G1H2(128),47,0,G2H2(453),n2h2(305))
  call Hloop_AV_Q(ntryL,G1H4(75),ex3(:),G1H2(133),m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_A_Q(ntryL,G1H2(133),47,0,G2H2(454),n2h2(306))
call HGT_OLR(G1H4(76),1,1,4)
call HGT_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(76),-16,0,G2H4(85),n2h4(305))
  call Hloop_QV_A(ntryL,G2H4(85),ex5(:),G2H2(455),m3h2x2(:,328),heltab2x4(:,:,328))
  call Hloop_AV_Q(ntryL,G1H4(277),ex3(:),G1H2(134),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_A_Q(ntryL,G1H2(134),47,0,G2H2(456),n2h2(307))
  call Hloop_AV_Q(ntryL,G1H4(278),ex3(:),G1H2(139),m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_A_Q(ntryL,G1H2(139),47,0,G2H2(457),n2h2(308))
  call Hloop_AV_Q(ntryL,G1H4(88),ex5(:),G1H2(140),m3h2x2(:,331),heltab2x4(:,:,331))
  call Hloop_A_Q(ntryL,G1H2(140),59,0,G2H2(458),n2h2(309))
call HGT_OLR(G1H4(89),1,1,4)
call HGT_invQ_OLR(G1H4(89),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(89),-4,0,G2H4(101),n2h4(306))
  call Hloop_QV_A(ntryL,G2H4(101),ex3(:),G2H2(459),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_AV_Q(ntryL,G1H4(281),ex5(:),G1H2(13),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_A_Q(ntryL,G1H2(13),59,0,G2H2(460),n2h2(310))
  call Hloop_AV_Q(ntryL,G1H4(282),ex5(:),G1H2(14),m3h2x2(:,334),heltab2x4(:,:,334))
  call Hloop_A_Q(ntryL,G1H2(14),59,0,G2H2(461),n2h2(311))
  call Hloop_AV_Q(ntryL,G1H6(93),ex5(:),G1H3(19),m3h2x3(:,189),heltab2x6(:,:,356))
  call Hloop_A_Q(ntryL,G1H3(19),55,0,G2H3(162),n2h3(143))
call HGT_OLR(G1H6(94),1,1,6)
call HGT_invQ_OLR(G1H6(94),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(94),-8,0,G2H6(8),n2h6(233))
  call Hloop_QW_A(ntryL,G2H6(8),ex4(:),G2H2(462),m3h3x2(:,168),heltab2x6(:,:,357))
  call Hloop_AV_Q(ntryL,G1H6(343),ex5(:),G1H3(20),m3h2x3(:,190),heltab2x6(:,:,358))
  call Hloop_A_Q(ntryL,G1H3(20),55,0,G2H3(163),n2h3(144))
  call Hloop_AV_Q(ntryL,G1H6(344),ex5(:),G1H3(25),m3h2x3(:,191),heltab2x6(:,:,359))
  call Hloop_A_Q(ntryL,G1H3(25),55,0,G2H3(164),n2h3(145))
  call Hloop_AV_Q(ntryL,G1H6(105),ex3(:),G1H3(26),m3h2x3(:,192),heltab2x6(:,:,360))
  call Hloop_A_Q(ntryL,G1H3(26),55,0,G2H3(165),n2h3(146))
call HGT_OLR(G1H6(106),1,1,6)
call HGT_invQ_OLR(G1H6(106),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(106),-8,0,G2H6(9),n2h6(234))
  call Hloop_QW_A(ntryL,G2H6(9),ex4(:),G2H2(463),m3h3x2(:,169),heltab2x6(:,:,361))
  call Hloop_AV_Q(ntryL,G1H6(346),ex3(:),G1H3(31),m3h2x3(:,193),heltab2x6(:,:,362))
  call Hloop_A_Q(ntryL,G1H3(31),55,0,G2H3(166),n2h3(147))
  call Hloop_AV_Q(ntryL,G1H6(347),ex3(:),G1H3(32),m3h2x3(:,194),heltab2x6(:,:,363))
  call Hloop_A_Q(ntryL,G1H3(32),55,0,G2H3(167),n2h3(148))
  call Hloop_AW_Q(ntryL,G1H6(118),ex4(:),G1H2(19),m3h3x2(:,170),heltab2x6(:,:,364))
  call Hloop_A_Q(ntryL,G1H2(19),59,0,G2H2(464),n2h2(312))
call HGT_OLR(G1H6(203),1,1,6)
call HGT_invQ_OLR(G1H6(203),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(203),-4,0,G2H6(12),n2h6(235))
  call Hloop_QV_A(ntryL,G2H6(12),ex3(:),G2H3(168),m3h2x3(:,195),heltab2x6(:,:,365))
  call Hloop_AW_Q(ntryL,G1H6(350),ex4(:),G1H2(20),m3h3x2(:,171),heltab2x6(:,:,366))
  call Hloop_A_Q(ntryL,G1H2(20),59,0,G2H2(465),n2h2(313))
  call Hloop_AW_Q(ntryL,G1H6(351),ex4(:),G1H2(25),m3h3x2(:,172),heltab2x6(:,:,367))
  call Hloop_A_Q(ntryL,G1H2(25),59,0,G2H2(466),n2h2(314))
  call Hloop_QW_A(ntryL,G1H6(130),ex4(:),G1H2(31),m3h3x2(:,173),heltab2x6(:,:,368))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(467),n2h2(315))
call HGT_OLR(G1H6(227),1,1,6)
call HGT_invQ_OLR(G1H6(227),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(227),-16,0,G2H6(15),n2h6(236))
  call Hloop_AV_Q(ntryL,G2H6(15),ex5(:),G2H3(169),m3h2x3(:,196),heltab2x6(:,:,369))
  call Hloop_QW_A(ntryL,G1H6(354),ex4(:),G1H2(32),m3h3x2(:,174),heltab2x6(:,:,370))
  call Hloop_Q_A(ntryL,G1H2(32),47,0,G2H2(468),n2h2(316))
  call Hloop_QW_A(ntryL,G1H6(355),ex4(:),G1H2(38),m3h3x2(:,175),heltab2x6(:,:,371))
  call Hloop_Q_A(ntryL,G1H2(38),47,0,G2H2(469),n2h2(317))
  call Hloop_QW_A(ntryL,G1H6(356),ex4(:),G1H2(44),m3h3x2(:,176),heltab2x6(:,:,372))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(470),n2h2(318))
call HGT_OLR(G1H6(357),1,1,6)
call HGT_invQ_OLR(G1H6(357),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(357),-16,0,G2H6(96),n2h6(237))
  call Hloop_AV_Q(ntryL,G2H6(96),ex5(:),G2H3(170),m3h2x3(:,197),heltab2x6(:,:,373))
  call Hloop_QW_A(ntryL,G1H6(360),ex4(:),G1H2(49),m3h3x2(:,177),heltab2x6(:,:,374))
  call Hloop_Q_A(ntryL,G1H2(49),47,0,G2H2(471),n2h2(319))
  call Hloop_QW_A(ntryL,G1H6(361),ex4(:),G1H2(50),m3h3x2(:,178),heltab2x6(:,:,375))
  call Hloop_Q_A(ntryL,G1H2(50),47,0,G2H2(472),n2h2(320))
  call Hloop_QV_A(ntryL,G1H6(141),ex5(:),G1H3(44),m3h2x3(:,198),heltab2x6(:,:,376))
  call Hloop_Q_A(ntryL,G1H3(44),55,0,G2H3(171),n2h3(149))
call HGT_OLR(G1H6(142),1,1,6)
call HGT_invQ_OLR(G1H6(142),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(142),-8,0,G2H6(95),n2h6(238))
  call Hloop_AW_Q(ntryL,G2H6(95),ex4(:),G2H2(473),m3h3x2(:,179),heltab2x6(:,:,377))
  call Hloop_QV_A(ntryL,G1H6(363),ex5(:),G1H3(49),m3h2x3(:,199),heltab2x6(:,:,378))
  call Hloop_Q_A(ntryL,G1H3(49),55,0,G2H3(172),n2h3(150))
  call Hloop_QV_A(ntryL,G1H6(364),ex5(:),G1H3(50),m3h2x3(:,200),heltab2x6(:,:,379))
  call Hloop_Q_A(ntryL,G1H3(50),55,0,G2H3(173),n2h3(151))
  call Hloop_QV_A(ntryL,G1H6(365),ex5(:),G1H3(73),m3h2x3(:,201),heltab2x6(:,:,380))
  call Hloop_Q_A(ntryL,G1H3(73),55,0,G2H3(174),n2h3(152))
call HGT_OLR(G1H6(366),1,1,6)
call HGT_invQ_OLR(G1H6(366),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(366),-8,0,G2H6(22),n2h6(239))
  call Hloop_AW_Q(ntryL,G2H6(22),ex4(:),G2H2(474),m3h3x2(:,180),heltab2x6(:,:,381))
  call Hloop_QV_A(ntryL,G1H6(369),ex5(:),G1H3(74),m3h2x3(:,202),heltab2x6(:,:,382))
  call Hloop_Q_A(ntryL,G1H3(74),55,0,G2H3(175),n2h3(153))
  call Hloop_QV_A(ntryL,G1H6(370),ex5(:),G1H3(7),m3h2x3(:,203),heltab2x6(:,:,383))
  call Hloop_Q_A(ntryL,G1H3(7),55,0,G2H3(176),n2h3(154))
  call Hloop_QV_A(ntryL,G1H4(100),ex3(:),G1H2(55),m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_Q_A(ntryL,G1H2(55),47,0,G2H2(475),n2h2(321))
call HGT_OLR(G1H4(101),1,1,4)
call HGT_invQ_OLR(G1H4(101),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(101),-16,0,G2H4(89),n2h4(307))
  call Hloop_AV_Q(ntryL,G2H4(89),ex5(:),G2H2(476),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_QV_A(ntryL,G1H4(285),ex3(:),G1H2(56),m3h2x2(:,337),heltab2x4(:,:,337))
  call Hloop_Q_A(ntryL,G1H2(56),47,0,G2H2(477),n2h2(322))
  call Hloop_QV_A(ntryL,G1H4(286),ex3(:),G1H2(61),m3h2x2(:,338),heltab2x4(:,:,338))
  call Hloop_Q_A(ntryL,G1H2(61),47,0,G2H2(478),n2h2(323))
  call Hloop_QV_A(ntryL,G1H4(287),ex3(:),G1H2(62),m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_Q_A(ntryL,G1H2(62),47,0,G2H2(479),n2h2(324))
call HGT_OLR(G1H4(288),1,1,4)
call HGT_invQ_OLR(G1H4(288),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(288),-16,0,G2H4(87),n2h4(308))
  call Hloop_AV_Q(ntryL,G2H4(87),ex5(:),G2H2(480),m3h2x2(:,340),heltab2x4(:,:,340))
  call Hloop_QV_A(ntryL,G1H4(291),ex3(:),G1H2(68),m3h2x2(:,341),heltab2x4(:,:,341))
  call Hloop_Q_A(ntryL,G1H2(68),47,0,G2H2(481),n2h2(325))
  call Hloop_QV_A(ntryL,G1H4(292),ex3(:),G1H2(73),m3h2x2(:,342),heltab2x4(:,:,342))
  call Hloop_Q_A(ntryL,G1H2(73),47,0,G2H2(482),n2h2(326))
  call Hloop_QV_A(ntryL,G1H4(111),ex5(:),G1H2(79),m3h2x2(:,343),heltab2x4(:,:,343))
  call Hloop_Q_A(ntryL,G1H2(79),59,0,G2H2(483),n2h2(327))
call HGT_OLR(G1H4(112),1,1,4)
call HGT_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(112),-4,0,G2H4(88),n2h4(309))
  call Hloop_AV_Q(ntryL,G2H4(88),ex3(:),G2H2(484),m3h2x2(:,344),heltab2x4(:,:,344))
  call Hloop_QV_A(ntryL,G1H4(294),ex5(:),G1H2(85),m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_Q_A(ntryL,G1H2(85),59,0,G2H2(485),n2h2(328))
  call Hloop_QV_A(ntryL,G1H4(295),ex5(:),G1H2(86),m3h2x2(:,346),heltab2x4(:,:,346))
  call Hloop_Q_A(ntryL,G1H2(86),59,0,G2H2(486),n2h2(329))
  call Hloop_QV_A(ntryL,G1H4(296),ex5(:),G1H2(91),m3h2x2(:,347),heltab2x4(:,:,347))
  call Hloop_Q_A(ntryL,G1H2(91),59,0,G2H2(487),n2h2(330))
call HGT_OLR(G1H4(297),1,1,4)
call HGT_invQ_OLR(G1H4(297),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(297),-4,0,G2H4(1),n2h4(310))
  call Hloop_AV_Q(ntryL,G2H4(1),ex3(:),G2H2(488),m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_QV_A(ntryL,G1H4(300),ex5(:),G1H2(92),m3h2x2(:,349),heltab2x4(:,:,349))
  call Hloop_Q_A(ntryL,G1H2(92),59,0,G2H2(489),n2h2(331))
  call Hloop_QV_A(ntryL,G1H4(301),ex5(:),G1H2(98),m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_Q_A(ntryL,G1H2(98),59,0,G2H2(490),n2h2(332))
  call Hloop_QV_A(ntryL,G1H6(153),ex3(:),G1H3(8),m3h2x3(:,204),heltab2x6(:,:,384))
  call Hloop_Q_A(ntryL,G1H3(8),55,0,G2H3(177),n2h3(155))
call HGT_OLR(G1H6(154),1,1,6)
call HGT_invQ_OLR(G1H6(154),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(154),-8,0,G2H6(23),n2h6(240))
  call Hloop_AW_Q(ntryL,G2H6(23),ex4(:),G2H2(491),m3h3x2(:,181),heltab2x6(:,:,385))
  call Hloop_QV_A(ntryL,G1H6(372),ex3(:),G1H3(13),m3h2x3(:,205),heltab2x6(:,:,386))
  call Hloop_Q_A(ntryL,G1H3(13),55,0,G2H3(178),n2h3(156))
  call Hloop_QV_A(ntryL,G1H6(373),ex3(:),G1H3(14),m3h2x3(:,206),heltab2x6(:,:,387))
  call Hloop_Q_A(ntryL,G1H3(14),55,0,G2H3(179),n2h3(157))
  call Hloop_QV_A(ntryL,G1H6(374),ex3(:),G1H3(19),m3h2x3(:,207),heltab2x6(:,:,388))
  call Hloop_Q_A(ntryL,G1H3(19),55,0,G2H3(180),n2h3(158))
call HGT_OLR(G1H6(375),1,1,6)
call HGT_invQ_OLR(G1H6(375),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(375),-8,0,G2H6(25),n2h6(241))
  call Hloop_AW_Q(ntryL,G2H6(25),ex4(:),G2H2(492),m3h3x2(:,182),heltab2x6(:,:,389))
  call Hloop_QV_A(ntryL,G1H6(378),ex3(:),G1H3(20),m3h2x3(:,208),heltab2x6(:,:,390))
  call Hloop_Q_A(ntryL,G1H3(20),55,0,G2H3(181),n2h3(159))
  call Hloop_QV_A(ntryL,G1H6(379),ex3(:),G1H3(25),m3h2x3(:,209),heltab2x6(:,:,391))
  call Hloop_Q_A(ntryL,G1H3(25),55,0,G2H3(182),n2h3(160))
  call Hloop_QW_A(ntryL,G1H6(165),ex4(:),G1H2(109),m3h3x2(:,183),heltab2x6(:,:,392))
  call Hloop_Q_A(ntryL,G1H2(109),59,0,G2H2(493),n2h2(333))
call HGT_OLR(G1H6(166),1,1,6)
call HGT_invQ_OLR(G1H6(166),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(166),-4,0,G2H6(26),n2h6(242))
  call Hloop_AV_Q(ntryL,G2H6(26),ex3(:),G2H3(183),m3h2x3(:,210),heltab2x6(:,:,393))
  call Hloop_QW_A(ntryL,G1H6(381),ex4(:),G1H2(115),m3h3x2(:,184),heltab2x6(:,:,394))
  call Hloop_Q_A(ntryL,G1H2(115),59,0,G2H2(494),n2h2(334))
  call Hloop_QW_A(ntryL,G1H6(382),ex4(:),G1H2(121),m3h3x2(:,185),heltab2x6(:,:,395))
  call Hloop_Q_A(ntryL,G1H2(121),59,0,G2H2(495),n2h2(335))
  call Hloop_QW_A(ntryL,G1H6(383),ex4(:),G1H2(127),m3h3x2(:,186),heltab2x6(:,:,396))
  call Hloop_Q_A(ntryL,G1H2(127),59,0,G2H2(496),n2h2(336))
call HGT_OLR(G1H6(384),1,1,6)
call HGT_invQ_OLR(G1H6(384),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(384),-4,0,G2H6(28),n2h6(243))
  call Hloop_AV_Q(ntryL,G2H6(28),ex3(:),G2H3(184),m3h2x3(:,211),heltab2x6(:,:,397))
  call Hloop_QW_A(ntryL,G1H6(387),ex4(:),G1H2(128),m3h3x2(:,187),heltab2x6(:,:,398))
  call Hloop_Q_A(ntryL,G1H2(128),59,0,G2H2(497),n2h2(337))
  call Hloop_QW_A(ntryL,G1H6(388),ex4(:),G1H2(133),m3h3x2(:,188),heltab2x6(:,:,399))
  call Hloop_Q_A(ntryL,G1H2(133),59,0,G2H2(498),n2h2(338))
  call Hloop_VQ_A(ntryL,G1H6(177),ex2(:),G1H3(26),m3h2x3(:,212),heltab2x6(:,:,400))
  call Hloop_Q_A(ntryL,G1H3(26),55,0,G2H3(185),n2h3(161))
call HGT_OLR(G1H6(178),1,1,6)
call HGT_invQ_OLR(G1H6(178),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(178),-8,0,G2H6(101),n2h6(244))
  call Hloop_AW_Q(ntryL,G2H6(101),ex4(:),G2H2(499),m3h3x2(:,189),heltab2x6(:,:,401))
  call Hloop_VQ_A(ntryL,G1H6(390),ex2(:),G1H3(31),m3h2x3(:,213),heltab2x6(:,:,402))
  call Hloop_Q_A(ntryL,G1H3(31),55,0,G2H3(186),n2h3(162))
  call Hloop_VQ_A(ntryL,G1H6(391),ex2(:),G1H3(32),m3h2x3(:,214),heltab2x6(:,:,403))
  call Hloop_Q_A(ntryL,G1H3(32),55,0,G2H3(187),n2h3(163))
  call Hloop_AV_Q(ntryL,G1H6(189),ex3(:),G1H3(44),m3h2x3(:,215),heltab2x6(:,:,404))
  call Hloop_A_Q(ntryL,G1H3(44),55,0,G2H3(188),n2h3(164))
call HGT_OLR(G1H6(190),1,1,6)
call HGT_invQ_OLR(G1H6(190),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(190),-8,0,G2H6(34),n2h6(245))
  call Hloop_QW_A(ntryL,G2H6(34),ex4(:),G2H2(500),m3h3x2(:,190),heltab2x6(:,:,405))
  call Hloop_AV_Q(ntryL,G1H6(394),ex3(:),G1H3(49),m3h2x3(:,216),heltab2x6(:,:,406))
  call Hloop_A_Q(ntryL,G1H3(49),55,0,G2H3(189),n2h3(165))
  call Hloop_AV_Q(ntryL,G1H6(395),ex3(:),G1H3(50),m3h2x3(:,217),heltab2x6(:,:,407))
  call Hloop_A_Q(ntryL,G1H3(50),55,0,G2H3(190),n2h3(166))
  call Hloop_AV_Q(ntryL,G1H6(396),ex3(:),G1H3(73),m3h2x3(:,218),heltab2x6(:,:,408))
  call Hloop_A_Q(ntryL,G1H3(73),55,0,G2H3(191),n2h3(167))
call HGT_OLR(G1H6(397),1,1,6)
call HGT_invQ_OLR(G1H6(397),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(397),-8,0,G2H6(100),n2h6(246))
  call Hloop_QW_A(ntryL,G2H6(100),ex4(:),G2H2(501),m3h3x2(:,191),heltab2x6(:,:,409))
  call Hloop_AV_Q(ntryL,G1H6(400),ex3(:),G1H3(74),m3h2x3(:,219),heltab2x6(:,:,410))
  call Hloop_A_Q(ntryL,G1H3(74),55,0,G2H3(192),n2h3(168))
  call Hloop_AV_Q(ntryL,G1H6(401),ex3(:),G1H3(7),m3h2x3(:,220),heltab2x6(:,:,411))
  call Hloop_A_Q(ntryL,G1H3(7),55,0,G2H3(193),n2h3(169))
  call Hloop_VA_Q(ntryL,G1H6(201),ex1(:),G1H3(8),m3h2x3(:,221),heltab2x6(:,:,412))
  call Hloop_A_Q(ntryL,G1H3(8),55,0,G2H3(194),n2h3(170))
call HGT_OLR(G1H6(202),1,1,6)
call HGT_invQ_OLR(G1H6(202),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(202),-8,0,G2H6(38),n2h6(247))
  call Hloop_QW_A(ntryL,G2H6(38),ex4(:),G2H2(502),m3h3x2(:,192),heltab2x6(:,:,413))
  call Hloop_VA_Q(ntryL,G1H6(404),ex1(:),G1H3(13),m3h2x3(:,222),heltab2x6(:,:,414))
  call Hloop_A_Q(ntryL,G1H3(13),55,0,G2H3(195),n2h3(171))
  call Hloop_VA_Q(ntryL,G1H6(405),ex1(:),G1H3(14),m3h2x3(:,223),heltab2x6(:,:,415))
  call Hloop_A_Q(ntryL,G1H3(14),55,0,G2H3(196),n2h3(172))
  call Hloop_AW_Q(ntryL,G1H6(213),ex4(:),G1H2(134),m3h3x2(:,193),heltab2x6(:,:,416))
  call Hloop_A_Q(ntryL,G1H2(134),59,0,G2H2(503),n2h2(339))
call HGT_OLR(G1H6(214),1,1,6)
call HGT_invQ_OLR(G1H6(214),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(214),-4,0,G2H6(98),n2h6(248))
  call Hloop_QV_A(ntryL,G2H6(98),ex3(:),G2H3(197),m3h2x3(:,224),heltab2x6(:,:,417))
  call Hloop_AW_Q(ntryL,G1H6(408),ex4(:),G1H2(139),m3h3x2(:,194),heltab2x6(:,:,418))
  call Hloop_A_Q(ntryL,G1H2(139),59,0,G2H2(504),n2h2(340))
  call Hloop_AW_Q(ntryL,G1H6(409),ex4(:),G1H2(140),m3h3x2(:,195),heltab2x6(:,:,419))
  call Hloop_A_Q(ntryL,G1H2(140),59,0,G2H2(505),n2h2(341))
  call Hloop_AW_Q(ntryL,G1H6(410),ex4(:),G1H2(13),m3h3x2(:,196),heltab2x6(:,:,420))
  call Hloop_A_Q(ntryL,G1H2(13),59,0,G2H2(506),n2h2(342))
call HGT_OLR(G1H6(411),1,1,6)
call HGT_invQ_OLR(G1H6(411),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(411),-4,0,G2H6(97),n2h6(249))
  call Hloop_QV_A(ntryL,G2H6(97),ex3(:),G2H3(198),m3h2x3(:,225),heltab2x6(:,:,421))
  call Hloop_AW_Q(ntryL,G1H6(414),ex4(:),G1H2(14),m3h3x2(:,197),heltab2x6(:,:,422))
  call Hloop_A_Q(ntryL,G1H2(14),59,0,G2H2(507),n2h2(343))
  call Hloop_AW_Q(ntryL,G1H6(415),ex4(:),G1H2(19),m3h3x2(:,198),heltab2x6(:,:,423))
  call Hloop_A_Q(ntryL,G1H2(19),59,0,G2H2(508),n2h2(344))
  call Hloop_QV_A(ntryL,G1H6(225),ex3(:),G1H3(19),m3h2x3(:,226),heltab2x6(:,:,424))
  call Hloop_Q_A(ntryL,G1H3(19),55,0,G2H3(199),n2h3(173))
call HGT_OLR(G1H6(226),1,1,6)
call HGT_invQ_OLR(G1H6(226),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(226),-8,0,G2H6(44),n2h6(250))
  call Hloop_AW_Q(ntryL,G2H6(44),ex4(:),G2H2(509),m3h3x2(:,199),heltab2x6(:,:,425))
  call Hloop_QV_A(ntryL,G1H6(418),ex3(:),G1H3(20),m3h2x3(:,227),heltab2x6(:,:,426))
  call Hloop_Q_A(ntryL,G1H3(20),55,0,G2H3(200),n2h3(174))
  call Hloop_QV_A(ntryL,G1H6(419),ex3(:),G1H3(25),m3h2x3(:,228),heltab2x6(:,:,427))
  call Hloop_Q_A(ntryL,G1H3(25),55,0,G2H3(201),n2h3(175))
  call Hloop_QV_A(ntryL,G1H6(420),ex3(:),G1H3(26),m3h2x3(:,229),heltab2x6(:,:,428))
  call Hloop_Q_A(ntryL,G1H3(26),55,0,G2H3(202),n2h3(176))
call HGT_OLR(G1H6(421),1,1,6)
call HGT_invQ_OLR(G1H6(421),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(421),-8,0,G2H6(45),n2h6(251))
  call Hloop_AW_Q(ntryL,G2H6(45),ex4(:),G2H2(510),m3h3x2(:,200),heltab2x6(:,:,429))
  call Hloop_QV_A(ntryL,G1H6(424),ex3(:),G1H3(31),m3h2x3(:,230),heltab2x6(:,:,430))
  call Hloop_Q_A(ntryL,G1H3(31),55,0,G2H3(203),n2h3(177))
  call Hloop_QV_A(ntryL,G1H6(425),ex3(:),G1H3(32),m3h2x3(:,231),heltab2x6(:,:,431))
  call Hloop_Q_A(ntryL,G1H3(32),55,0,G2H3(204),n2h3(178))
  call Hloop_QW_A(ntryL,G1H6(237),ex4(:),G1H2(20),m3h3x2(:,201),heltab2x6(:,:,432))
  call Hloop_Q_A(ntryL,G1H2(20),59,0,G2H2(511),n2h2(345))
call HGT_OLR(G1H6(238),1,1,6)
call HGT_invQ_OLR(G1H6(238),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(238),-4,0,G2H6(104),n2h6(252))
  call Hloop_AV_Q(ntryL,G2H6(104),ex3(:),G2H3(205),m3h2x3(:,232),heltab2x6(:,:,433))
  call Hloop_QW_A(ntryL,G1H6(428),ex4(:),G1H2(25),m3h3x2(:,202),heltab2x6(:,:,434))
  call Hloop_Q_A(ntryL,G1H2(25),59,0,G2H2(512),n2h2(346))
  call Hloop_QW_A(ntryL,G1H6(429),ex4(:),G1H2(31),m3h3x2(:,203),heltab2x6(:,:,435))
  call Hloop_Q_A(ntryL,G1H2(31),59,0,G2H2(513),n2h2(347))
  call Hloop_QW_A(ntryL,G1H6(430),ex4(:),G1H2(32),m3h3x2(:,204),heltab2x6(:,:,436))
  call Hloop_Q_A(ntryL,G1H2(32),59,0,G2H2(514),n2h2(348))
call HGT_OLR(G1H6(431),1,1,6)
call HGT_invQ_OLR(G1H6(431),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(431),-4,0,G2H6(50),n2h6(253))
  call Hloop_AV_Q(ntryL,G2H6(50),ex3(:),G2H3(206),m3h2x3(:,233),heltab2x6(:,:,437))
  call Hloop_QW_A(ntryL,G1H6(434),ex4(:),G1H2(38),m3h3x2(:,205),heltab2x6(:,:,438))
  call Hloop_Q_A(ntryL,G1H2(38),59,0,G2H2(515),n2h2(349))
  call Hloop_QW_A(ntryL,G1H6(435),ex4(:),G1H2(44),m3h3x2(:,206),heltab2x6(:,:,439))
  call Hloop_Q_A(ntryL,G1H2(44),59,0,G2H2(516),n2h2(350))
  call Hloop_AW_Q(ntryL,G1H6(249),ex4(:),G1H2(49),m3h3x2(:,207),heltab2x6(:,:,440))
  call Hloop_A_Q(ntryL,G1H2(49),61,0,G2H2(517),n2h2(351))
call HGT_raise_alpha_OLR(G1H6(250),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(250),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(250),ex2(:),G1H3(44),m3h2x3(:,234),heltab2x6(:,:,441))
  call Hloop_AW_Q(ntryL,G1H6(446),ex4(:),G1H2(50),m3h3x2(:,208),heltab2x6(:,:,442))
  call Hloop_A_Q(ntryL,G1H2(50),61,0,G2H2(518),n2h2(352))
  call Hloop_AW_Q(ntryL,G1H6(483),ex4(:),G1H2(55),m3h3x2(:,209),heltab2x6(:,:,443))
  call Hloop_A_Q(ntryL,G1H2(55),61,0,G2H2(519),n2h2(353))
  call Hloop_AW_Q(ntryL,G1H6(440),ex4(:),G1H2(56),m3h3x2(:,210),heltab2x6(:,:,444))
  call Hloop_A_Q(ntryL,G1H2(56),61,0,G2H2(520),n2h2(354))
call HGT_raise_alpha_OLR(G1H6(441),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(441),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(441),ex2(:),G1H3(49),m3h2x3(:,235),heltab2x6(:,:,445))
  call Hloop_AW_Q(ntryL,G1H6(451),ex4(:),G1H2(61),m3h3x2(:,211),heltab2x6(:,:,446))
  call Hloop_A_Q(ntryL,G1H2(61),61,0,G2H2(521),n2h2(355))
  call Hloop_AW_Q(ntryL,G1H6(284),ex4(:),G1H2(62),m3h3x2(:,212),heltab2x6(:,:,447))
  call Hloop_A_Q(ntryL,G1H2(62),61,0,G2H2(522),n2h2(356))
call HGT_raise_alpha_OLR(G1H6(447),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(447),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(447),ex2(:),G1H3(50),m3h2x3(:,236),heltab2x6(:,:,448))
  call Hloop_AW_Q(ntryL,G1H6(450),ex4(:),G1H2(68),m3h3x2(:,213),heltab2x6(:,:,449))
  call Hloop_A_Q(ntryL,G1H2(68),61,0,G2H2(523),n2h2(357))
call HGT_raise_alpha_OLR(G1H6(452),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(452),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(452),ex2(:),G1H3(73),m3h2x3(:,237),heltab2x6(:,:,450))
  call Hloop_AW_Q(ntryL,G1H6(455),ex4(:),G1H2(73),m3h3x2(:,214),heltab2x6(:,:,451))
  call Hloop_A_Q(ntryL,G1H2(73),61,0,G2H2(524),n2h2(358))
  call Hloop_AV_Q(ntryL,G1H4(123),ex5(:),G1H2(79),m3h2x2(:,351),heltab2x4(:,:,351))
  call Hloop_A_Q(ntryL,G1H2(79),61,0,G2H2(525),n2h2(359))
call HGT_raise_alpha_OLR(G1H4(124),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(124),ex2(:),G1H2(85),m3h2x2(:,352),heltab2x4(:,:,352))
  call Hloop_AV_Q(ntryL,G1H4(311),ex5(:),G1H2(86),m3h2x2(:,353),heltab2x4(:,:,353))
  call Hloop_A_Q(ntryL,G1H2(86),61,0,G2H2(526),n2h2(360))
  call Hloop_AV_Q(ntryL,G1H4(397),ex5(:),G1H2(91),m3h2x2(:,354),heltab2x4(:,:,354))
  call Hloop_A_Q(ntryL,G1H2(91),61,0,G2H2(527),n2h2(361))
  call Hloop_AV_Q(ntryL,G1H4(305),ex5(:),G1H2(92),m3h2x2(:,355),heltab2x4(:,:,355))
  call Hloop_A_Q(ntryL,G1H2(92),61,0,G2H2(528),n2h2(362))
call HGT_raise_alpha_OLR(G1H4(306),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(306),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(306),ex2(:),G1H2(98),m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_AV_Q(ntryL,G1H4(316),ex5(:),G1H2(109),m3h2x2(:,357),heltab2x4(:,:,357))
  call Hloop_A_Q(ntryL,G1H2(109),61,0,G2H2(529),n2h2(363))
  call Hloop_AV_Q(ntryL,G1H4(192),ex5(:),G1H2(115),m3h2x2(:,358),heltab2x4(:,:,358))
  call Hloop_A_Q(ntryL,G1H2(115),61,0,G2H2(530),n2h2(364))
call HGT_raise_alpha_OLR(G1H4(312),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(312),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(312),ex2(:),G1H2(121),m3h2x2(:,359),heltab2x4(:,:,359))
  call Hloop_AV_Q(ntryL,G1H4(315),ex5(:),G1H2(127),m3h2x2(:,360),heltab2x4(:,:,360))
  call Hloop_A_Q(ntryL,G1H2(127),61,0,G2H2(531),n2h2(365))
call HGT_raise_alpha_OLR(G1H4(317),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(317),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(317),ex2(:),G1H2(128),m3h2x2(:,361),heltab2x4(:,:,361))
  call Hloop_AV_Q(ntryL,G1H4(320),ex5(:),G1H2(133),m3h2x2(:,362),heltab2x4(:,:,362))
  call Hloop_A_Q(ntryL,G1H2(133),61,0,G2H2(532),n2h2(366))
  call Hloop_AV_Q(ntryL,G1H4(141),ex3(:),G1H2(134),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_A_Q(ntryL,G1H2(134),61,0,G2H2(533),n2h2(367))
call HGT_raise_alpha_OLR(G1H4(142),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(142),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(142),ex2(:),G1H2(139),m3h2x2(:,364),heltab2x4(:,:,364))
  call Hloop_AV_Q(ntryL,G1H4(330),ex3(:),G1H2(140),m3h2x2(:,365),heltab2x4(:,:,365))
  call Hloop_A_Q(ntryL,G1H2(140),61,0,G2H2(534),n2h2(368))
  call Hloop_AV_Q(ntryL,G1H4(402),ex3(:),G1H2(13),m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_A_Q(ntryL,G1H2(13),61,0,G2H2(535),n2h2(369))
  call Hloop_AV_Q(ntryL,G1H4(324),ex3(:),G1H2(14),m3h2x2(:,367),heltab2x4(:,:,367))
  call Hloop_A_Q(ntryL,G1H2(14),61,0,G2H2(536),n2h2(370))
call HGT_raise_alpha_OLR(G1H4(325),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(325),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(325),ex2(:),G1H2(19),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_AV_Q(ntryL,G1H4(335),ex3(:),G1H2(20),m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_A_Q(ntryL,G1H2(20),61,0,G2H2(537),n2h2(371))
  call Hloop_AV_Q(ntryL,G1H4(382),ex3(:),G1H2(25),m3h2x2(:,370),heltab2x4(:,:,370))
  call Hloop_A_Q(ntryL,G1H2(25),61,0,G2H2(538),n2h2(372))
call HGT_raise_alpha_OLR(G1H4(331),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(331),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(331),ex2(:),G1H2(31),m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_AV_Q(ntryL,G1H4(334),ex3(:),G1H2(32),m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_A_Q(ntryL,G1H2(32),61,0,G2H2(539),n2h2(373))
call HGT_raise_alpha_OLR(G1H4(336),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(336),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(336),ex2(:),G1H2(38),m3h2x2(:,373),heltab2x4(:,:,373))
  call Hloop_AV_Q(ntryL,G1H4(339),ex3(:),G1H2(44),m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(44),61,0,G2H2(540),n2h2(374))
  call Hloop_AV_Q(ntryL,G1H4(158),ex5(:),G1H2(49),m3h2x2(:,375),heltab2x4(:,:,375))
  call Hloop_A_Q(ntryL,G1H2(49),61,0,G2H2(541),n2h2(375))
call HGT_raise_alpha_OLR(G1H4(159),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(159),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(159),ex2(:),G1H2(50),m3h2x2(:,376),heltab2x4(:,:,376))
  call Hloop_AV_Q(ntryL,G1H4(349),ex5(:),G1H2(55),m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_A_Q(ntryL,G1H2(55),61,0,G2H2(542),n2h2(376))
  call Hloop_AV_Q(ntryL,G1H4(407),ex5(:),G1H2(56),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_A_Q(ntryL,G1H2(56),61,0,G2H2(543),n2h2(377))
  call Hloop_AV_Q(ntryL,G1H4(343),ex5(:),G1H2(61),m3h2x2(:,379),heltab2x4(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(61),61,0,G2H2(544),n2h2(378))
call HGT_raise_alpha_OLR(G1H4(344),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(344),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(344),ex2(:),G1H2(62),m3h2x2(:,380),heltab2x4(:,:,380))
  call Hloop_AV_Q(ntryL,G1H4(354),ex5(:),G1H2(68),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_A_Q(ntryL,G1H2(68),61,0,G2H2(545),n2h2(379))
  call Hloop_AV_Q(ntryL,G1H4(387),ex5(:),G1H2(73),m3h2x2(:,382),heltab2x4(:,:,382))
  call Hloop_A_Q(ntryL,G1H2(73),61,0,G2H2(546),n2h2(380))
call HGT_raise_alpha_OLR(G1H4(350),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(350),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(350),ex2(:),G1H2(79),m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_AV_Q(ntryL,G1H4(353),ex5(:),G1H2(86),m3h2x2(:,384),heltab2x4(:,:,384))
  call Hloop_A_Q(ntryL,G1H2(86),61,0,G2H2(547),n2h2(381))
call HGT_raise_alpha_OLR(G1H4(355),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(355),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(355),ex2(:),G1H2(91),m3h2x2(:,385),heltab2x4(:,:,385))
  call Hloop_AV_Q(ntryL,G1H4(358),ex5(:),G1H2(92),m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_A_Q(ntryL,G1H2(92),61,0,G2H2(548),n2h2(382))
  call Hloop_AV_Q(ntryL,G1H4(175),ex3(:),G1H2(109),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hloop_A_Q(ntryL,G1H2(109),61,0,G2H2(549),n2h2(383))
call HGT_raise_alpha_OLR(G1H4(176),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(176),ex2(:),G1H2(115),m3h2x2(:,388),heltab2x4(:,:,388))
  call Hloop_AV_Q(ntryL,G1H4(369),ex3(:),G1H2(127),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hloop_A_Q(ntryL,G1H2(127),61,0,G2H2(550),n2h2(384))
  call Hloop_AV_Q(ntryL,G1H4(412),ex3(:),G1H2(133),m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_A_Q(ntryL,G1H2(133),61,0,G2H2(551),n2h2(385))
  call Hloop_AV_Q(ntryL,G1H4(363),ex3(:),G1H2(134),m3h2x2(:,391),heltab2x4(:,:,391))
  call Hloop_A_Q(ntryL,G1H2(134),61,0,G2H2(552),n2h2(386))
call HGT_raise_alpha_OLR(G1H4(364),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(364),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(364),ex2(:),G1H2(140),m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_AV_Q(ntryL,G1H4(374),ex3(:),G1H2(13),m3h2x2(:,393),heltab2x4(:,:,393))
  call Hloop_A_Q(ntryL,G1H2(13),61,0,G2H2(553),n2h2(387))
  call Hloop_AV_Q(ntryL,G1H4(392),ex3(:),G1H2(14),m3h2x2(:,394),heltab2x4(:,:,394))
  call Hloop_A_Q(ntryL,G1H2(14),61,0,G2H2(554),n2h2(388))
call HGT_raise_alpha_OLR(G1H4(370),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(370),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(370),ex2(:),G1H2(20),m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_AV_Q(ntryL,G1H4(373),ex3(:),G1H2(25),m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_A_Q(ntryL,G1H2(25),61,0,G2H2(555),n2h2(389))
call HGT_raise_alpha_OLR(G1H4(375),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(375),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(375),ex2(:),G1H2(32),m3h2x2(:,397),heltab2x4(:,:,397))
  call Hloop_AV_Q(ntryL,G1H4(378),ex3(:),G1H2(44),m3h2x2(:,398),heltab2x4(:,:,398))
  call Hloop_A_Q(ntryL,G1H2(44),61,0,G2H2(556),n2h2(390))
  call Hloop_AW_Q(ntryL,G1H6(267),ex4(:),G1H2(49),m3h3x2(:,215),heltab2x6(:,:,452))
  call Hloop_A_Q(ntryL,G1H2(49),61,0,G2H2(557),n2h2(391))
call HGT_raise_alpha_OLR(G1H6(268),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(268),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(268),ex2(:),G1H3(74),m3h2x3(:,238),heltab2x6(:,:,453))
  call Hloop_AW_Q(ntryL,G1H6(465),ex4(:),G1H2(55),m3h3x2(:,216),heltab2x6(:,:,454))
  call Hloop_A_Q(ntryL,G1H2(55),61,0,G2H2(558),n2h2(392))
  call Hloop_AW_Q(ntryL,G1H6(488),ex4(:),G1H2(56),m3h3x2(:,217),heltab2x6(:,:,455))
  call Hloop_A_Q(ntryL,G1H2(56),61,0,G2H2(559),n2h2(393))
  call Hloop_AW_Q(ntryL,G1H6(459),ex4(:),G1H2(61),m3h3x2(:,218),heltab2x6(:,:,456))
  call Hloop_A_Q(ntryL,G1H2(61),61,0,G2H2(560),n2h2(394))
call HGT_raise_alpha_OLR(G1H6(460),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(460),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(460),ex2(:),G1H3(7),m3h2x3(:,239),heltab2x6(:,:,457))
  call Hloop_AW_Q(ntryL,G1H6(470),ex4(:),G1H2(68),m3h3x2(:,219),heltab2x6(:,:,458))
  call Hloop_A_Q(ntryL,G1H2(68),61,0,G2H2(561),n2h2(395))
  call Hloop_AW_Q(ntryL,G1H6(478),ex4(:),G1H2(73),m3h3x2(:,220),heltab2x6(:,:,459))
  call Hloop_A_Q(ntryL,G1H2(73),61,0,G2H2(562),n2h2(396))
call HGT_raise_alpha_OLR(G1H6(466),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(466),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(466),ex2(:),G1H3(8),m3h2x3(:,240),heltab2x6(:,:,460))
  call Hloop_AW_Q(ntryL,G1H6(469),ex4(:),G1H2(86),m3h3x2(:,221),heltab2x6(:,:,461))
  call Hloop_A_Q(ntryL,G1H2(86),61,0,G2H2(563),n2h2(397))
call HGT_raise_alpha_OLR(G1H6(471),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(471),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(471),ex2(:),G1H3(13),m3h2x3(:,241),heltab2x6(:,:,462))
  call Hloop_AW_Q(ntryL,G1H6(474),ex4(:),G1H2(92),m3h3x2(:,222),heltab2x6(:,:,463))
  call Hloop_A_Q(ntryL,G1H2(92),61,0,G2H2(564),n2h2(398))
  call Hloop_VA_Q(ntryL,G1H8(73),wf4(:,3),G1H2(109),m3h4x2(:,7),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(109),47,0,G2H2(565),n2h2(399))
call HGT_OLR(G1H8(79),1,1,8)
call HGT_invQ_OLR(G1H8(79),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(79),-16,0,G2H8(23),n2h8(111))
  call Hloop_QV_A(ntryL,G2H8(23),ex5(:),G2H4(3),m3h2x4(:,159),heltab2x8(:,:,166))
  call Hloop_VA_Q(ntryL,G1H8(80),wf4(:,3),G1H2(127),m3h4x2(:,8),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(127),47,0,G2H2(566),n2h2(400))
  call Hloop_VA_Q(ntryL,G1H8(83),wf4(:,3),G1H2(133),m3h4x2(:,9),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(133),47,0,G2H2(567),n2h2(401))
  call Hloop_VA_Q(ntryL,G1H12(106),wf4(:,3),G1H3(14),m3h4x3(:,1),heltab2x12(:,:,335))
  call Hloop_A_Q(ntryL,G1H3(14),55,0,G2H3(207),n2h3(179))
call HGT_OLR(G1H12(118),1,1,12)
call HGT_invQ_OLR(G1H12(118),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(118),-8,0,G2H12(46),n2h12(185))
  call Hloop_QW_A(ntryL,G2H12(46),ex4(:),G2H4(23),m3h3x4(:,123),heltab2x12(:,:,336))
  call Hloop_VA_Q(ntryL,G1H12(177),wf4(:,3),G1H3(19),m3h4x3(:,2),heltab2x12(:,:,337))
  call Hloop_A_Q(ntryL,G1H3(19),55,0,G2H3(208),n2h3(180))
  call Hloop_VA_Q(ntryL,G1H12(195),wf4(:,3),G1H3(20),m3h4x3(:,3),heltab2x12(:,:,338))
  call Hloop_A_Q(ntryL,G1H3(20),55,0,G2H3(209),n2h3(181))
  call Hloop_VQ_A(ntryL,G1H8(84),wf4(:,9),G1H2(134),m3h4x2(:,10),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(134),47,0,G2H2(568),n2h2(402))
call HGT_OLR(G1H8(17),1,1,8)
call HGT_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(17),-16,0,G2H8(25),n2h8(112))
  call Hloop_AV_Q(ntryL,G2H8(25),ex5(:),G2H4(25),m3h2x4(:,160),heltab2x8(:,:,170))
  call Hloop_VQ_A(ntryL,G1H8(53),wf4(:,9),G1H2(13),m3h4x2(:,11),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(569),n2h2(403))
  call Hloop_VQ_A(ntryL,G1H8(54),wf4(:,9),G1H2(14),m3h4x2(:,12),heltab2x8(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(570),n2h2(404))
  call Hloop_VQ_A(ntryL,G1H12(213),wf4(:,9),G1H3(25),m3h4x3(:,4),heltab2x12(:,:,339))
  call Hloop_Q_A(ntryL,G1H3(25),55,0,G2H3(210),n2h3(182))
call HGT_OLR(G1H12(231),1,1,12)
call HGT_invQ_OLR(G1H12(231),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(231),-8,0,G2H12(47),n2h12(186))
  call Hloop_AW_Q(ntryL,G2H12(47),ex4(:),G2H4(32),m3h3x4(:,124),heltab2x12(:,:,340))
  call Hloop_VQ_A(ntryL,G1H12(3),wf4(:,9),G1H3(26),m3h4x3(:,5),heltab2x12(:,:,341))
  call Hloop_Q_A(ntryL,G1H3(26),55,0,G2H3(211),n2h3(183))
  call Hloop_VQ_A(ntryL,G1H12(4),wf4(:,9),G1H3(31),m3h4x3(:,6),heltab2x12(:,:,342))
  call Hloop_Q_A(ntryL,G1H3(31),55,0,G2H3(212),n2h3(184))
  call Hloop_UV_W(ntryL,G1H12(5),38,ex5(:),16,G2H6(103),m3h2x6(:,207),heltab2x12(:,:,343))
call HGT_OLR(G1H12(6),1,1,12)
call HGT_invQ_OLR(G1H12(6),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(6),-9,0,G2H12(50),n2h12(187))
  call Hloop_QA_V(ntryL,G2H12(50),wf6(:,4),G2H2(571),m3h6x2(:,7),heltab2x12(:,:,344))
  call Hloop_UV_W(ntryL,G1H12(15),38,ex5(:),16,G2H6(63),m3h2x6(:,208),heltab2x12(:,:,345))
  call Hloop_UV_W(ntryL,G1H12(8),38,ex5(:),16,G2H6(70),m3h2x6(:,209),heltab2x12(:,:,346))
  call Hloop_VA_Q(ntryL,G1H12(22),wf6(:,4),G1H2(25),m3h6x2(:,8),heltab2x12(:,:,347))
  call Hloop_A_Q(ntryL,G1H2(25),47,0,G2H2(572),n2h2(405))
call HGT_OLR(G1H12(28),1,1,12)
call HGT_invQ_OLR(G1H12(28),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(28),-16,0,G2H12(51),n2h12(188))
  call Hloop_QV_A(ntryL,G2H12(51),ex5(:),G2H6(73),m3h2x6(:,210),heltab2x12(:,:,348))
  call Hloop_VA_Q(ntryL,G1H12(40),wf6(:,4),G1H2(44),m3h6x2(:,9),heltab2x12(:,:,349))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(573),n2h2(406))
  call Hloop_VA_Q(ntryL,G1H12(46),wf6(:,4),G1H2(49),m3h6x2(:,10),heltab2x12(:,:,350))
  call Hloop_A_Q(ntryL,G1H2(49),47,0,G2H2(574),n2h2(407))
  call Hloop_VA_Q(ntryL,G1H12(51),wf6(:,4),G1H2(55),m3h6x2(:,11),heltab2x12(:,:,351))
  call Hloop_A_Q(ntryL,G1H2(55),59,0,G2H2(575),n2h2(408))
call HGT_OLR(G1H12(14),1,1,12)
call HGT_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(14),-4,0,G2H12(53),n2h12(189))
  call Hloop_QV_A(ntryL,G2H12(53),ex3(:),G2H6(74),m3h2x6(:,211),heltab2x12(:,:,352))
  call Hloop_VA_Q(ntryL,G1H12(17),wf6(:,4),G1H2(56),m3h6x2(:,12),heltab2x12(:,:,353))
  call Hloop_A_Q(ntryL,G1H2(56),59,0,G2H2(576),n2h2(409))
  call Hloop_VA_Q(ntryL,G1H12(70),wf6(:,4),G1H2(61),m3h6x2(:,13),heltab2x12(:,:,354))
  call Hloop_A_Q(ntryL,G1H2(61),59,0,G2H2(577),n2h2(410))
  call Hloop_UV_W(ntryL,G1H12(18),37,ex5(:),16,G2H6(75),m3h2x6(:,212),heltab2x12(:,:,355))
call HGT_OLR(G1H12(76),1,1,12)
call HGT_invQ_OLR(G1H12(76),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(76),-10,0,G2H12(55),n2h12(190))
  call Hloop_AQ_V(ntryL,G2H12(55),wf6(:,2),G2H2(578),m3h6x2(:,14),heltab2x12(:,:,356))
  call Hloop_UV_W(ntryL,G1H12(20),37,ex5(:),16,G2H6(82),m3h2x6(:,213),heltab2x12(:,:,357))
  call Hloop_UV_W(ntryL,G1H12(88),37,ex5(:),16,G2H6(87),m3h2x6(:,214),heltab2x12(:,:,358))
  call Hloop_VQ_A(ntryL,G1H12(23),wf6(:,2),G1H2(68),m3h6x2(:,15),heltab2x12(:,:,359))
  call Hloop_Q_A(ntryL,G1H2(68),47,0,G2H2(579),n2h2(411))
call HGT_OLR(G1H12(94),1,1,12)
call HGT_invQ_OLR(G1H12(94),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(94),-16,0,G2H12(56),n2h12(191))
  call Hloop_AV_Q(ntryL,G2H12(56),ex5(:),G2H6(91),m3h2x6(:,215),heltab2x12(:,:,360))
  call Hloop_VQ_A(ntryL,G1H12(105),wf6(:,2),G1H2(73),m3h6x2(:,16),heltab2x12(:,:,361))
  call Hloop_Q_A(ntryL,G1H2(73),47,0,G2H2(580),n2h2(412))
  call Hloop_VQ_A(ntryL,G1H12(233),wf6(:,2),G1H2(86),m3h6x2(:,17),heltab2x12(:,:,362))
  call Hloop_Q_A(ntryL,G1H2(86),47,0,G2H2(581),n2h2(413))
  call Hloop_VQ_A(ntryL,G1H12(111),wf6(:,2),G1H2(92),m3h6x2(:,18),heltab2x12(:,:,363))
  call Hloop_Q_A(ntryL,G1H2(92),59,0,G2H2(582),n2h2(414))
call HGT_OLR(G1H12(112),1,1,12)
call HGT_invQ_OLR(G1H12(112),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(112),-4,0,G2H12(57),n2h12(192))
  call Hloop_AV_Q(ntryL,G2H12(57),ex3(:),G2H6(90),m3h2x6(:,216),heltab2x12(:,:,364))
  call Hloop_VQ_A(ntryL,G1H12(123),wf6(:,2),G1H2(109),m3h6x2(:,19),heltab2x12(:,:,365))
  call Hloop_Q_A(ntryL,G1H2(109),59,0,G2H2(583),n2h2(415))
  call Hloop_VQ_A(ntryL,G1H12(124),wf6(:,2),G1H2(127),m3h6x2(:,20),heltab2x12(:,:,366))
  call Hloop_Q_A(ntryL,G1H2(127),59,0,G2H2(584),n2h2(416))
  call Hloop_AV_Q(ntryL,G1H12(129),ex5(:),G1H6(23),m3h2x6(:,217),heltab2x12(:,:,367))
  call Hloop_A_Q(ntryL,G1H6(23),51,0,G2H6(86),n2h6(262))
call HGT_OLR(G1H12(130),1,1,12)
call HGT_invQ_OLR(G1H12(130),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(130),-12,0,G2H12(59),n2h12(193))
  call Hloop_QW_A(ntryL,G2H12(59),wf6(:,6),G2H2(585),m3h6x2(:,21),heltab2x12(:,:,368))
  call Hloop_AV_Q(ntryL,G1H12(147),ex5(:),G1H6(27),m3h2x6(:,218),heltab2x12(:,:,369))
  call Hloop_A_Q(ntryL,G1H6(27),51,0,G2H6(83),n2h6(263))
  call Hloop_AV_Q(ntryL,G1H12(148),ex5(:),G1H6(172),m3h2x6(:,219),heltab2x12(:,:,370))
  call Hloop_A_Q(ntryL,G1H6(172),51,0,G2H6(84),n2h6(264))
  call Hloop_QV_A(ntryL,G1H12(153),ex5(:),G1H6(179),m3h2x6(:,220),heltab2x12(:,:,371))
  call Hloop_Q_A(ntryL,G1H6(179),51,0,G2H6(85),n2h6(265))
call HGT_OLR(G1H12(154),1,1,12)
call HGT_invQ_OLR(G1H12(154),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(154),-12,0,G2H12(60),n2h12(194))
  call Hloop_AW_Q(ntryL,G2H12(60),wf6(:,6),G2H2(586),m3h6x2(:,22),heltab2x12(:,:,372))
  call Hloop_QV_A(ntryL,G1H12(171),ex5(:),G1H6(3),m3h2x6(:,221),heltab2x12(:,:,373))
  call Hloop_Q_A(ntryL,G1H6(3),51,0,G2H6(88),n2h6(266))
  call Hloop_QV_A(ntryL,G1H12(172),ex5(:),G1H6(5),m3h2x6(:,222),heltab2x12(:,:,374))
  call Hloop_Q_A(ntryL,G1H6(5),51,0,G2H6(92),n2h6(267))
  call Hloop_QW_A(ntryL,G1H12(183),wf6(:,6),G1H2(133),m3h6x2(:,23),heltab2x12(:,:,375))
  call Hloop_Q_A(ntryL,G1H2(133),47,0,G2H2(587),n2h2(417))
call HGT_OLR(G1H12(184),1,1,12)
call HGT_invQ_OLR(G1H12(184),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(184),-16,0,G2H12(1),n2h12(195))
  call Hloop_AV_Q(ntryL,G2H12(1),ex5(:),G2H6(93),m3h2x6(:,223),heltab2x12(:,:,376))
  call Hloop_QW_A(ntryL,G1H12(201),wf6(:,6),G1H2(134),m3h6x2(:,24),heltab2x12(:,:,377))
  call Hloop_Q_A(ntryL,G1H2(134),47,0,G2H2(588),n2h2(418))
  call Hloop_QW_A(ntryL,G1H12(202),wf6(:,6),G1H2(13),m3h6x2(:,25),heltab2x12(:,:,378))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(589),n2h2(419))
  call Hloop_AW_Q(ntryL,G1H12(207),wf6(:,6),G1H2(14),m3h6x2(:,26),heltab2x12(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(14),47,0,G2H2(590),n2h2(420))
call HGT_OLR(G1H12(208),1,1,12)
call HGT_invQ_OLR(G1H12(208),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(208),-16,0,G2H12(2),n2h12(196))
  call Hloop_QV_A(ntryL,G2H12(2),ex5(:),G2H6(76),m3h2x6(:,224),heltab2x12(:,:,380))
  call Hloop_AW_Q(ntryL,G1H12(225),wf6(:,6),G1H2(25),m3h6x2(:,27),heltab2x12(:,:,381))
  call Hloop_A_Q(ntryL,G1H2(25),47,0,G2H2(591),n2h2(421))
  call Hloop_AW_Q(ntryL,G1H12(226),wf6(:,6),G1H2(44),m3h6x2(:,28),heltab2x12(:,:,382))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(592),n2h2(422))
  call Hloop_VQ_A(ntryL,G1H12(237),ex2(:),G1H6(438),m3h2x6(:,225),heltab2x12(:,:,383))
  call Hloop_Q_A(ntryL,G1H6(438),51,0,G2H6(94),n2h6(268))
call HGT_OLR(G1H12(238),1,1,12)
call HGT_invQ_OLR(G1H12(238),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(238),-12,0,G2H12(3),n2h12(197))
  call Hloop_AW_Q(ntryL,G2H12(3),wf6(:,6),G2H2(593),m3h6x2(:,29),heltab2x12(:,:,384))
  call Hloop_VQ_A(ntryL,G1H12(218),ex2(:),G1H6(439),m3h2x6(:,226),heltab2x12(:,:,385))
  call Hloop_Q_A(ntryL,G1H6(439),51,0,G2H6(78),n2h6(269))
  call Hloop_VQ_A(ntryL,G1H12(221),ex2(:),G1H6(444),m3h2x6(:,227),heltab2x12(:,:,386))
  call Hloop_Q_A(ntryL,G1H6(444),51,0,G2H6(3),n2h6(270))
  call Hloop_VA_Q(ntryL,G1H12(222),ex1(:),G1H6(445),m3h2x6(:,228),heltab2x12(:,:,387))
  call Hloop_A_Q(ntryL,G1H6(445),51,0,G2H6(6),n2h6(271))
call HGT_OLR(G1H12(224),1,1,12)
call HGT_invQ_OLR(G1H12(224),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(224),-12,0,G2H12(4),n2h12(198))
  call Hloop_QW_A(ntryL,G2H12(4),wf6(:,6),G2H2(594),m3h6x2(:,30),heltab2x12(:,:,388))
  call Hloop_VA_Q(ntryL,G1H12(41),ex1(:),G1H6(457),m3h2x6(:,229),heltab2x12(:,:,389))
  call Hloop_A_Q(ntryL,G1H6(457),51,0,G2H6(7),n2h6(272))
  call Hloop_VA_Q(ntryL,G1H12(42),ex1(:),G1H6(458),m3h2x6(:,230),heltab2x12(:,:,390))
  call Hloop_A_Q(ntryL,G1H6(458),51,0,G2H6(10),n2h6(273))
  call Hloop_VA_Q(ntryL,G1H12(43),wf4(:,11),G1H3(32),m3h4x3(:,7),heltab2x12(:,:,391))
  call Hloop_A_Q(ntryL,G1H3(32),55,0,G2H3(213),n2h3(185))
call HGT_OLR(G1H12(44),1,1,12)
call HGT_invQ_OLR(G1H12(44),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(44),-8,0,G2H12(5),n2h12(199))
  call Hloop_QW_A(ntryL,G2H12(5),ex4(:),G2H4(34),m3h3x4(:,125),heltab2x12(:,:,392))
  call Hloop_VA_Q(ntryL,G1H12(50),wf4(:,11),G1H3(14),m3h4x3(:,8),heltab2x12(:,:,393))
  call Hloop_A_Q(ntryL,G1H3(14),55,0,G2H3(214),n2h3(186))
  call Hloop_VA_Q(ntryL,G1H12(53),wf4(:,11),G1H3(19),m3h4x3(:,9),heltab2x12(:,:,394))
  call Hloop_A_Q(ntryL,G1H3(19),55,0,G2H3(215),n2h3(187))
  call Hloop_VQ_A(ntryL,G1H12(54),wf4(:,5),G1H3(20),m3h4x3(:,10),heltab2x12(:,:,395))
  call Hloop_Q_A(ntryL,G1H3(20),55,0,G2H3(216),n2h3(188))
call HGT_OLR(G1H12(56),1,1,12)
call HGT_invQ_OLR(G1H12(56),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(56),-8,0,G2H12(6),n2h12(200))
  call Hloop_AW_Q(ntryL,G2H12(6),ex4(:),G2H4(105),m3h3x4(:,126),heltab2x12(:,:,396))
  call Hloop_VQ_A(ntryL,G1H12(61),wf4(:,5),G1H3(25),m3h4x3(:,11),heltab2x12(:,:,397))
  call Hloop_Q_A(ntryL,G1H3(25),55,0,G2H3(217),n2h3(189))
  call Hloop_VQ_A(ntryL,G1H12(62),wf4(:,5),G1H3(26),m3h4x3(:,12),heltab2x12(:,:,398))
  call Hloop_Q_A(ntryL,G1H3(26),55,0,G2H3(218),n2h3(190))
call HGT_raise_alpha_OLR(G1H6(285),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(285),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(285),ex2(:),G1H3(31),m3h2x3(:,242),heltab2x6(:,:,464))
  call Hloop_AW_Q(ntryL,G1H6(477),ex4(:),G1H2(49),m3h3x2(:,223),heltab2x6(:,:,465))
  call Hloop_A_Q(ntryL,G1H2(49),61,0,G2H2(595),n2h2(423))
call HGT_raise_alpha_OLR(G1H4(193),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(193),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(193),ex2(:),G1H2(55),m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_AV_Q(ntryL,G1H4(381),ex5(:),G1H2(56),m3h2x2(:,400),heltab2x4(:,:,400))
  call Hloop_A_Q(ntryL,G1H2(56),61,0,G2H2(596),n2h2(424))
call HGT_raise_alpha_OLR(G1H4(383),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(383),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(383),ex2(:),G1H2(61),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_AV_Q(ntryL,G1H4(386),ex3(:),G1H2(68),m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_A_Q(ntryL,G1H2(68),61,0,G2H2(597),n2h2(425))
call HGT_raise_alpha_OLR(G1H4(388),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(388),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(388),ex2(:),G1H2(73),m3h2x2(:,403),heltab2x4(:,:,403))
  call Hloop_AV_Q(ntryL,G1H4(391),ex5(:),G1H2(86),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hloop_A_Q(ntryL,G1H2(86),61,0,G2H2(598),n2h2(426))
call HGT_raise_alpha_OLR(G1H4(393),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(393),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(393),ex2(:),G1H2(92),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_AV_Q(ntryL,G1H4(396),ex3(:),G1H2(109),m3h2x2(:,406),heltab2x4(:,:,406))
  call Hloop_A_Q(ntryL,G1H2(109),61,0,G2H2(599),n2h2(427))
call HGT_raise_alpha_OLR(G1H6(479),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(479),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(479),ex2(:),G1H3(32),m3h2x3(:,243),heltab2x6(:,:,466))
  call Hloop_AW_Q(ntryL,G1H6(482),ex4(:),G1H2(127),m3h3x2(:,224),heltab2x6(:,:,467))
  call Hloop_A_Q(ntryL,G1H2(127),61,0,G2H2(600),n2h2(428))
call HGT_raise_alpha_OLR(G1H6(484),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(484),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(484),ex2(:),G1H3(14),m3h2x3(:,244),heltab2x6(:,:,468))
  call Hloop_AW_Q(ntryL,G1H6(487),ex4(:),G1H2(133),m3h3x2(:,225),heltab2x6(:,:,469))
  call Hloop_A_Q(ntryL,G1H2(133),61,0,G2H2(601),n2h2(429))
call HGT_raise_alpha_OLR(G1H4(398),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(398),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(398),ex2(:),G1H2(134),m3h2x2(:,407),heltab2x4(:,:,407))
  call Hloop_AV_Q(ntryL,G1H4(401),ex5(:),G1H2(13),m3h2x2(:,408),heltab2x4(:,:,408))
  call Hloop_A_Q(ntryL,G1H2(13),61,0,G2H2(602),n2h2(430))
call HGT_raise_alpha_OLR(G1H4(403),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(403),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(403),ex2(:),G1H2(14),m3h2x2(:,409),heltab2x4(:,:,409))
  call Hloop_AV_Q(ntryL,G1H4(406),ex3(:),G1H2(25),m3h2x2(:,410),heltab2x4(:,:,410))
  call Hloop_A_Q(ntryL,G1H2(25),61,0,G2H2(603),n2h2(431))
call HGT_raise_alpha_OLR(G1H4(408),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(408),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(408),ex2(:),G1H2(44),m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_AV_Q(ntryL,G1H4(411),ex5(:),G1H2(49),m3h2x2(:,412),heltab2x4(:,:,412))
  call Hloop_A_Q(ntryL,G1H2(49),61,0,G2H2(604),n2h2(432))
call HGT_raise_alpha_OLR(G1H4(413),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(413),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(413),ex2(:),G1H2(56),m3h2x2(:,413),heltab2x4(:,:,413))
  call Hloop_AV_Q(ntryL,G1H4(416),ex3(:),G1H2(68),m3h2x2(:,414),heltab2x4(:,:,414))
  call Hloop_A_Q(ntryL,G1H2(68),61,0,G2H2(605),n2h2(433))
call HGT_raise_alpha_OLR(G1H6(489),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(489),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(489),ex2(:),G1H3(19),m3h2x3(:,245),heltab2x6(:,:,470))
  call Hloop_AW_Q(ntryL,G1H6(492),ex4(:),G1H2(86),m3h3x2(:,226),heltab2x6(:,:,471))
  call Hloop_A_Q(ntryL,G1H2(86),61,0,G2H2(606),n2h2(434))
  call Hloop_QV_A(ntryL,G1H8(71),ex5(:),G1H4(153),m3h2x4(:,161),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(153),58,0,G2H4(106),n2h4(335))
call HGT_raise_alpha_OLR(G1H8(72),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(72),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(72),wf4(:,3),G1H2(109),m3h4x2(:,13),heltab2x8(:,:,174))
  call Hloop_QV_A(ntryL,G1H8(34),ex5(:),G1H4(160),m3h2x4(:,162),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(160),58,0,G2H4(86),n2h4(336))
  call Hloop_QV_A(ntryL,G1H8(33),ex5(:),G1H4(201),m3h2x4(:,163),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(201),58,0,G2H4(90),n2h4(337))
call HGT_raise_alpha_OLR(G1H8(70),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(70),wf4(:,3),G1H2(127),m3h4x2(:,14),heltab2x8(:,:,177))
  call Hloop_QV_A(ntryL,G1H8(15),ex5(:),G1H4(202),m3h2x4(:,164),heltab2x8(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(202),58,0,G2H4(97),n2h4(338))
call HGT_raise_alpha_OLR(G1H8(69),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(69),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(69),wf4(:,3),G1H2(133),m3h4x2(:,15),heltab2x8(:,:,179))
  call Hloop_QV_A(ntryL,G1H8(9),ex5(:),G1H4(217),m3h2x4(:,165),heltab2x8(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(217),58,0,G2H4(98),n2h4(339))
  call Hloop_QW_A(ntryL,G1H12(66),ex4(:),G1H4(218),m3h3x4(:,127),heltab2x12(:,:,399))
  call Hloop_Q_A(ntryL,G1H4(218),58,0,G2H4(7),n2h4(340))
call HGT_raise_alpha_OLR(G1H12(67),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(67),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(67),wf4(:,3),G1H3(20),m3h4x3(:,13),heltab2x12(:,:,400))
  call Hloop_QW_A(ntryL,G1H12(77),ex4(:),G1H4(239),m3h3x4(:,128),heltab2x12(:,:,401))
  call Hloop_Q_A(ntryL,G1H4(239),58,0,G2H4(9),n2h4(341))
  call Hloop_QW_A(ntryL,G1H12(85),ex4(:),G1H4(240),m3h3x4(:,129),heltab2x12(:,:,402))
  call Hloop_Q_A(ntryL,G1H4(240),58,0,G2H4(13),n2h4(342))
call HGT_raise_alpha_OLR(G1H12(78),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(78),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(78),wf4(:,3),G1H3(25),m3h4x3(:,14),heltab2x12(:,:,403))
  call Hloop_QW_A(ntryL,G1H12(84),ex4(:),G1H4(303),m3h3x4(:,130),heltab2x12(:,:,404))
  call Hloop_Q_A(ntryL,G1H4(303),58,0,G2H4(16),n2h4(343))
call HGT_raise_alpha_OLR(G1H12(86),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(86),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(86),wf4(:,3),G1H3(26),m3h4x3(:,15),heltab2x12(:,:,405))
  call Hloop_QW_A(ntryL,G1H12(92),ex4(:),G1H4(304),m3h3x4(:,131),heltab2x12(:,:,406))
  call Hloop_Q_A(ntryL,G1H4(304),58,0,G2H4(111),n2h4(344))
  call Hloop_AV_Q(ntryL,G1H8(2),ex5(:),G1H4(309),m3h2x4(:,166),heltab2x8(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(309),57,0,G2H4(113),n2h4(345))
call HGT_raise_alpha_OLR(G1H8(22),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(22),wf4(:,9),G1H2(13),m3h4x2(:,16),heltab2x8(:,:,182))
  call Hloop_AV_Q(ntryL,G1H8(45),ex5(:),G1H4(310),m3h2x4(:,167),heltab2x8(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(310),57,0,G2H4(112),n2h4(346))
  call Hloop_AV_Q(ntryL,G1H8(64),ex5(:),G1H4(322),m3h2x4(:,168),heltab2x8(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(322),57,0,G2H4(116),n2h4(347))
call HGT_raise_alpha_OLR(G1H8(46),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(46),wf4(:,9),G1H2(25),m3h4x2(:,17),heltab2x8(:,:,185))
  call Hloop_AV_Q(ntryL,G1H8(63),ex5(:),G1H4(323),m3h2x4(:,169),heltab2x8(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(323),57,0,G2H4(14),n2h4(348))
call HGT_raise_alpha_OLR(G1H8(75),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(75),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(75),wf4(:,9),G1H2(49),m3h4x2(:,18),heltab2x8(:,:,187))
  call Hloop_AV_Q(ntryL,G1H8(82),ex5(:),G1H4(328),m3h2x4(:,170),heltab2x8(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(328),57,0,G2H4(15),n2h4(349))
  call Hloop_AW_Q(ntryL,G1H12(95),ex4(:),G1H4(329),m3h3x4(:,132),heltab2x12(:,:,407))
  call Hloop_A_Q(ntryL,G1H4(329),57,0,G2H4(17),n2h4(350))
call HGT_raise_alpha_OLR(G1H12(96),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(96),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(96),wf4(:,9),G1H3(79),m3h4x3(:,16),heltab2x12(:,:,408))
  call Hloop_AW_Q(ntryL,G1H12(104),ex4(:),G1H4(341),m3h3x4(:,133),heltab2x12(:,:,409))
  call Hloop_A_Q(ntryL,G1H4(341),57,0,G2H4(18),n2h4(351))
  call Hloop_AW_Q(ntryL,G1H12(114),ex4(:),G1H4(342),m3h3x4(:,134),heltab2x12(:,:,410))
  call Hloop_A_Q(ntryL,G1H4(342),57,0,G2H4(20),n2h4(352))
call HGT_raise_alpha_OLR(G1H12(107),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(107),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(107),wf4(:,9),G1H3(80),m3h4x3(:,17),heltab2x12(:,:,411))
  call Hloop_AW_Q(ntryL,G1H12(113),ex4(:),G1H4(347),m3h3x4(:,135),heltab2x12(:,:,412))
  call Hloop_A_Q(ntryL,G1H4(347),57,0,G2H4(21),n2h4(353))
call HGT_raise_alpha_OLR(G1H12(115),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(115),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(115),wf4(:,9),G1H3(81),m3h4x3(:,18),heltab2x12(:,:,413))
  call Hloop_AW_Q(ntryL,G1H12(121),ex4(:),G1H4(348),m3h3x4(:,136),heltab2x12(:,:,414))
  call Hloop_A_Q(ntryL,G1H4(348),57,0,G2H4(115),n2h4(354))
  call Hloop_QV_A(ntryL,G1H12(122),ex5(:),G1H6(463),m3h2x6(:,231),heltab2x12(:,:,415))
  call Hloop_Q_A(ntryL,G1H6(463),54,0,G2H6(13),n2h6(278))
call HGT_raise_alpha_OLR(G1H12(125),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(125),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(125),wf6(:,4),G1H2(68),m3h6x2(:,31),heltab2x12(:,:,416))
  call Hloop_QV_A(ntryL,G1H12(133),ex5(:),G1H6(464),m3h2x6(:,232),heltab2x12(:,:,417))
  call Hloop_Q_A(ntryL,G1H6(464),54,0,G2H6(17),n2h6(279))
  call Hloop_QV_A(ntryL,G1H12(145),ex5(:),G1H6(187),m3h2x6(:,233),heltab2x12(:,:,418))
  call Hloop_Q_A(ntryL,G1H6(187),54,0,G2H6(18),n2h6(280))
call HGT_raise_alpha_OLR(G1H12(134),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(134),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(134),wf6(:,4),G1H2(86),m3h6x2(:,32),heltab2x12(:,:,419))
  call Hloop_QV_A(ntryL,G1H12(140),ex5(:),G1H6(188),m3h2x6(:,234),heltab2x12(:,:,420))
  call Hloop_Q_A(ntryL,G1H6(188),54,0,G2H6(20),n2h6(281))
call HGT_raise_alpha_OLR(G1H12(151),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(151),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(151),wf6(:,4),G1H2(145),m3h6x2(:,33),heltab2x12(:,:,421))
  call Hloop_QV_A(ntryL,G1H12(152),ex5(:),G1H6(194),m3h2x6(:,235),heltab2x12(:,:,422))
  call Hloop_Q_A(ntryL,G1H6(194),54,0,G2H6(21),n2h6(282))
  call Hloop_QV_A(ntryL,G1H12(155),ex3(:),G1H6(199),m3h2x6(:,236),heltab2x12(:,:,423))
  call Hloop_Q_A(ntryL,G1H6(199),54,0,G2H6(24),n2h6(283))
call HGT_raise_alpha_OLR(G1H12(156),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(156),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(156),wf6(:,4),G1H2(146),m3h6x2(:,34),heltab2x12(:,:,424))
  call Hloop_QV_A(ntryL,G1H12(167),ex3(:),G1H6(200),m3h2x6(:,237),heltab2x12(:,:,425))
  call Hloop_Q_A(ntryL,G1H6(200),54,0,G2H6(27),n2h6(284))
  call Hloop_QV_A(ntryL,G1H12(176),ex3(:),G1H6(204),m3h2x6(:,238),heltab2x12(:,:,426))
  call Hloop_Q_A(ntryL,G1H6(204),54,0,G2H6(29),n2h6(285))
call HGT_raise_alpha_OLR(G1H12(170),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(170),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(170),wf6(:,4),G1H2(147),m3h6x2(:,35),heltab2x12(:,:,427))
  call Hloop_QV_A(ntryL,G1H12(175),ex3(:),G1H6(211),m3h2x6(:,239),heltab2x12(:,:,428))
  call Hloop_Q_A(ntryL,G1H6(211),54,0,G2H6(30),n2h6(286))
call HGT_raise_alpha_OLR(G1H12(187),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(187),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(187),wf6(:,4),G1H2(148),m3h6x2(:,36),heltab2x12(:,:,429))
  call Hloop_QV_A(ntryL,G1H12(186),ex3(:),G1H6(212),m3h2x6(:,240),heltab2x12(:,:,430))
  call Hloop_Q_A(ntryL,G1H6(212),54,0,G2H6(32),n2h6(287))
  call Hloop_AV_Q(ntryL,G1H12(188),ex5(:),G1H6(216),m3h2x6(:,241),heltab2x12(:,:,431))
  call Hloop_A_Q(ntryL,G1H6(216),53,0,G2H6(33),n2h6(288))
call HGT_raise_alpha_OLR(G1H12(192),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(192),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(192),wf6(:,2),G1H2(149),m3h6x2(:,37),heltab2x12(:,:,432))
  call Hloop_AV_Q(ntryL,G1H12(203),ex5(:),G1H6(217),m3h2x6(:,242),heltab2x12(:,:,433))
  call Hloop_A_Q(ntryL,G1H6(217),53,0,G2H6(36),n2h6(289))
  call Hloop_AV_Q(ntryL,G1H12(212),ex5(:),G1H6(224),m3h2x6(:,243),heltab2x12(:,:,434))
  call Hloop_A_Q(ntryL,G1H6(224),53,0,G2H6(40),n2h6(290))
call HGT_raise_alpha_OLR(G1H12(204),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(204),2,5,12)



end subroutine vamp_3

end module ol_vamp_3_ppwajj_uxdawxgg_1_/**/REALKIND
