
module ol_vamp_2_ppwajj_uuxuxdawx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwajj_uuxuxdawx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwajj_uuxuxdawx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwajj_uuxuxdawx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwajj_uuxuxdawx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwajj_uuxuxdawx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwajj_uuxuxdawx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(24),n2h32(68))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(115),h0tab(:,115),[32,8,2,21],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_AW_Q(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,69),heltab2x96(:,:,115))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(25),n2h32(69))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(116),h0tab(:,116),[32,2,21,8],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_QW_A(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,70),heltab2x96(:,:,116))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(26),n2h32(70))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(24)*M(2,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(117),h0tab(:,117),[36,8,1,18],[0,0,0,0],4,2,wf6(:,4),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H96(1),wf6(:,4),G0H16(8),m3h6x16(:,47),heltab2x96(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(8),36,0,G1H16(15),n2h16(20))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(20)*M(2,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(118),h0tab(:,118),[36,1,18,8],[0,0,0,0],4,2,wf6(:,4),wf4(:,8))
  call Hloop_QA_V(ntryL,G0H96(1),wf6(:,4),G0H16(15),m3h6x16(:,48),heltab2x96(:,:,118))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)-c(26)*M(2,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(119),h0tab(:,119),[40,4,1,18],[0,0,0,0],4,2,wf6(:,2),wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,2),G0H16(1),m3h6x16(:,49),heltab2x96(:,:,119))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(20)*M(2,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(120),h0tab(:,120),[40,4,1,18],[0,0,0,0],4,2,wf6(:,2),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H96(1),wf6(:,2),G0H16(6),m3h6x16(:,50),heltab2x96(:,:,120))
  call Hloop_Q_A(ntryL,G0H16(6),40,0,G1H16(16),n2h16(21))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(22)*M(2,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(121),h0tab(:,121),[40,1,4,18],[0,0,0,0],4,2,wf6(:,2),wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,2),G0H16(8),m3h6x16(:,51),heltab2x96(:,:,121))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(24)*M(2,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(122),h0tab(:,122),[40,1,18,4],[0,0,0,0],4,2,wf6(:,2),wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,2),G0H16(6),m3h6x16(:,52),heltab2x96(:,:,122))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(123),h0tab(:,123),[32,4,8,19],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_QW_A(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,71),heltab2x96(:,:,123))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(27),n2h32(71))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(124),h0tab(:,124),[32,8,4,19],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_AW_Q(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,72),heltab2x96(:,:,124))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(28),n2h32(72))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(125),h0tab(:,125),[32,4,19,8],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_QW_A(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,73),heltab2x96(:,:,125))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(29),n2h32(73))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(22)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(126),h0tab(:,126),[50,4,1,8],[0,0,0,0],4,1,wf12(:,33))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,33),G0H8(1),m3h12x8(:,1),heltab2x96(:,:,126))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)-c(26)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(127),h0tab(:,127),[50,1,4,8],[0,0,0,0],4,1,wf12(:,33))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,33),G0H8(2),m3h12x8(:,2),heltab2x96(:,:,127))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(22)*M(2,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(128),h0tab(:,128),[34,8,1,20],[0,0,0,0],4,2,wf6(:,8),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf6(:,8),G0H16(17),m3h6x16(:,53),heltab2x96(:,:,128))
  call Hloop_A_Q(ntryL,G0H16(17),34,0,G1H16(17),n2h16(22))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)-c(26)*M(2,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(129),h0tab(:,129),[34,1,20,8],[0,0,0,0],4,2,wf6(:,8),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf6(:,8),G0H16(17),m3h6x16(:,54),heltab2x96(:,:,129))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(20)*M(2,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(130),h0tab(:,130),[40,2,1,20],[0,0,0,0],4,2,wf6(:,2),wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,2),G0H16(18),m3h6x16(:,55),heltab2x96(:,:,130))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)-c(26)*M(2,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(131),h0tab(:,131),[40,2,1,20],[0,0,0,0],4,2,wf6(:,2),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H96(1),wf6(:,2),G0H16(19),m3h6x16(:,56),heltab2x96(:,:,131))
  call Hloop_Q_A(ntryL,G0H16(19),40,0,G1H16(18),n2h16(23))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(24)*M(2,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(132),h0tab(:,132),[40,1,2,20],[0,0,0,0],4,2,wf6(:,2),wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,2),G0H16(19),m3h6x16(:,57),heltab2x96(:,:,132))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(22)*M(2,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(133),h0tab(:,133),[40,1,20,2],[0,0,0,0],4,2,wf6(:,2),wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,2),G0H16(20),m3h6x16(:,58),heltab2x96(:,:,133))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(134),h0tab(:,134),[32,2,8,21],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_QW_A(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,74),heltab2x96(:,:,134))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(30),n2h32(74))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(135),h0tab(:,135),[32,8,2,21],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_AW_Q(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,75),heltab2x96(:,:,135))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(31),n2h32(75))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(136),h0tab(:,136),[32,2,21,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_QW_A(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,76),heltab2x96(:,:,136))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(32),n2h32(76))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(24)*M(2,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(137),h0tab(:,137),[52,2,1,8],[0,0,0,0],4,1,wf12(:,20))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,20),G0H8(3),m3h12x8(:,3),heltab2x96(:,:,137))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(20)*M(2,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(138),h0tab(:,138),[52,1,2,8],[0,0,0,0],4,1,wf12(:,20))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,20),G0H8(4),m3h12x8(:,4),heltab2x96(:,:,138))
  Gcoeff(:)%j = (c(9)*M(1,:)%j+c(15)*M(2,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(139),h0tab(:,139),[34,1,4,24],[0,0,0,0],4,2,wf6(:,8),wf4(:,5))
  call Hloop_QA_V(ntryL,G0H96(1),wf6(:,8),G0H16(21),m3h6x16(:,59),heltab2x96(:,:,139))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(11)*M(2,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(140),h0tab(:,140),[34,4,1,24],[0,0,0,0],4,2,wf6(:,8),wf4(:,5))
  call Hloop_QA_V(ntryL,G0H96(1),wf6(:,8),G0H16(22),m3h6x16(:,60),heltab2x96(:,:,140))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)-c(9)*M(2,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(141),h0tab(:,141),[36,1,2,24],[0,0,0,0],4,2,wf6(:,4),wf4(:,5))
  call Hloop_QA_V(ntryL,G0H96(1),wf6(:,4),G0H16(23),m3h6x16(:,61),heltab2x96(:,:,141))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(13)*M(2,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(142),h0tab(:,142),[36,2,1,24],[0,0,0,0],4,2,wf6(:,4),wf4(:,5))
  call Hloop_QA_V(ntryL,G0H96(1),wf6(:,4),G0H16(24),m3h6x16(:,62),heltab2x96(:,:,142))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)-c(9)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(143),h0tab(:,143),[56,2,1,4],[0,0,0,0],4,1,wf12(:,25))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,25),G0H8(5),m3h12x8(:,5),heltab2x96(:,:,143))
  Gcoeff(:)%j = (c(9)*M(1,:)%j+c(15)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(144),h0tab(:,144),[56,2,1,4],[0,0,0,0],4,1,wf12(:,25))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,25),G0H8(6),m3h12x8(:,6),heltab2x96(:,:,144))
  call Hloop_Q_A(ntryL,G0H8(6),56,0,G1H8(33),n2h8(64))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(13)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(145),h0tab(:,145),[56,1,2,4],[0,0,0,0],4,1,wf12(:,25))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,25),G0H8(6),m3h12x8(:,7),heltab2x96(:,:,145))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(11)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(146),h0tab(:,146),[56,1,4,2],[0,0,0,0],4,1,wf12(:,25))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,25),G0H8(7),m3h12x8(:,8),heltab2x96(:,:,146))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(147),h0tab(:,147),[42,4,1,16],[0,0,0,0],4,1,wf12(:,12))
  call Hloop_QV_A(ntryL,G0H96(1),wf12(:,12),G0H8(8),m3h12x8(:,9),heltab2x96(:,:,147))
  call Hloop_Q_A(ntryL,G0H8(8),42,0,G1H8(34),n2h8(65))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(148),h0tab(:,148),[42,1,4,16],[0,0,0,0],4,1,wf12(:,12))
  call Hloop_AV_Q(ntryL,G0H96(1),wf12(:,12),G0H8(8),m3h12x8(:,10),heltab2x96(:,:,148))
  call Hloop_A_Q(ntryL,G0H8(8),42,0,G1H8(35),n2h8(66))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(149),h0tab(:,149),[42,1,16,4],[0,0,0,0],4,1,wf12(:,12))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf12(:,12),42,G1H8(12),m3h12x8(:,11),heltab2x96(:,:,149))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(11)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(150),h0tab(:,150),[50,4,1,8],[0,0,0,0],4,1,wf12(:,34))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,34),G0H8(8),m3h12x8(:,12),heltab2x96(:,:,150))
  Gcoeff(:)%j = (c(9)*M(1,:)%j+c(15)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(151),h0tab(:,151),[50,1,4,8],[0,0,0,0],4,1,wf12(:,34))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,34),G0H8(9),m3h12x8(:,13),heltab2x96(:,:,151))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(152),h0tab(:,152),[44,2,1,16],[0,0,0,0],4,1,wf12(:,13))
  call Hloop_QV_A(ntryL,G0H96(1),wf12(:,13),G0H8(10),m3h12x8(:,14),heltab2x96(:,:,152))
  call Hloop_Q_A(ntryL,G0H8(10),44,0,G1H8(19),n2h8(67))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(153),h0tab(:,153),[44,1,2,16],[0,0,0,0],4,1,wf12(:,13))
  call Hloop_AV_Q(ntryL,G0H96(1),wf12(:,13),G0H8(10),m3h12x8(:,15),heltab2x96(:,:,153))
  call Hloop_A_Q(ntryL,G0H8(10),44,0,G1H8(24),n2h8(68))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(154),h0tab(:,154),[44,1,16,2],[0,0,0,0],4,1,wf12(:,13))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf12(:,13),44,G1H8(1),m3h12x8(:,16),heltab2x96(:,:,154))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(13)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(155),h0tab(:,155),[52,2,1,8],[0,0,0,0],4,1,wf12(:,21))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,21),G0H8(10),m3h12x8(:,17),heltab2x96(:,:,155))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)-c(9)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(156),h0tab(:,156),[52,1,2,8],[0,0,0,0],4,1,wf12(:,21))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,21),G0H8(11),m3h12x8(:,18),heltab2x96(:,:,156))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(157),h0tab(:,157),[42,4,1,16],[0,0,0,0],4,1,wf12(:,15))
  call Hloop_QV_A(ntryL,G0H96(1),wf12(:,15),G0H8(12),m3h12x8(:,19),heltab2x96(:,:,157))
  call Hloop_Q_A(ntryL,G0H8(12),42,0,G1H8(2),n2h8(69))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(158),h0tab(:,158),[42,1,4,16],[0,0,0,0],4,1,wf12(:,15))
  call Hloop_AV_Q(ntryL,G0H96(1),wf12(:,15),G0H8(12),m3h12x8(:,20),heltab2x96(:,:,158))
  call Hloop_A_Q(ntryL,G0H8(12),42,0,G1H8(7),n2h8(70))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(159),h0tab(:,159),[42,1,16,4],[0,0,0,0],4,1,wf12(:,15))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf12(:,15),42,G1H8(8),m3h12x8(:,21),heltab2x96(:,:,159))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(160),h0tab(:,160),[44,2,1,16],[0,0,0,0],4,1,wf12(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf12(:,14),G0H8(12),m3h12x8(:,22),heltab2x96(:,:,160))
  call Hloop_Q_A(ntryL,G0H8(12),44,0,G1H8(11),n2h8(71))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(161),h0tab(:,161),[44,1,2,16],[0,0,0,0],4,1,wf12(:,14))
  call Hloop_AV_Q(ntryL,G0H96(1),wf12(:,14),G0H8(12),m3h12x8(:,23),heltab2x96(:,:,161))
  call Hloop_A_Q(ntryL,G0H8(12),44,0,G1H8(25),n2h8(72))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(162),h0tab(:,162),[44,1,16,2],[0,0,0,0],4,1,wf12(:,14))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf12(:,14),44,G1H8(28),m3h12x8(:,24),heltab2x96(:,:,162))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(20)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(163),h0tab(:,163),[56,2,1,4],[0,0,0,0],4,1,wf12(:,26))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,26),G0H8(12),m3h12x8(:,25),heltab2x96(:,:,163))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)-c(26)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(164),h0tab(:,164),[56,2,1,4],[0,0,0,0],4,1,wf12(:,26))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,26),G0H8(13),m3h12x8(:,26),heltab2x96(:,:,164))
  call Hloop_Q_A(ntryL,G0H8(13),56,0,G1H8(3),n2h8(73))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(24)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(165),h0tab(:,165),[56,1,2,4],[0,0,0,0],4,1,wf12(:,26))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,26),G0H8(13),m3h12x8(:,27),heltab2x96(:,:,165))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(22)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(166),h0tab(:,166),[56,1,4,2],[0,0,0,0],4,1,wf12(:,26))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,26),G0H8(14),m3h12x8(:,28),heltab2x96(:,:,166))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(167),h0tab(:,167),[50,4,1,8],[0,0,0,0],4,1,wf12(:,11))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,11),G0H8(15),m3h12x8(:,29),heltab2x96(:,:,167))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(168),h0tab(:,168),[50,1,4,8],[0,0,0,0],4,1,wf12(:,11))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,11),G0H8(16),m3h12x8(:,30),heltab2x96(:,:,168))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(169),h0tab(:,169),[52,2,1,8],[0,0,0,0],4,1,wf12(:,7))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,7),G0H8(17),m3h12x8(:,31),heltab2x96(:,:,169))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(170),h0tab(:,170),[52,1,2,8],[0,0,0,0],4,1,wf12(:,7))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,7),G0H8(18),m3h12x8(:,32),heltab2x96(:,:,170))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(171),h0tab(:,171),[56,2,1,4],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,28),G0H8(19),m3h12x8(:,33),heltab2x96(:,:,171))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(172),h0tab(:,172),[56,2,1,4],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,28),G0H8(20),m3h12x8(:,34),heltab2x96(:,:,172))
  call Hloop_Q_A(ntryL,G0H8(20),56,0,G1H8(4),n2h8(74))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(173),h0tab(:,173),[56,1,2,4],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,28),G0H8(20),m3h12x8(:,35),heltab2x96(:,:,173))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(174),h0tab(:,174),[56,1,4,2],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,28),G0H8(21),m3h12x8(:,36),heltab2x96(:,:,174))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(15),[G0H8(8),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(16),[G0H8(9),G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(17),[G0H8(10),G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(11),G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(19),[G0H8(12),G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(3),G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(20),[G0H8(13),G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(21),[G0H8(14),G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(1)])
  call Hloop_QV_A(ntryL,G1H8(9),ex5(:),G1H4(78),m3h2x4(:,80),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(78),51,0,G2H4(17),n2h4(65))
  call Hloop_QV_A(ntryL,G1H8(23),ex5(:),G1H4(6),m3h2x4(:,81),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(6),53,0,G2H4(20),n2h4(66))
  call Hloop_AV_Q(ntryL,G1H8(14),ex5(:),G1H4(7),m3h2x4(:,82),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(7),51,0,G2H4(2),n2h4(67))
  call Hloop_AQ_V(ntryL,G1H32(1),ex4(:),G1H16(19),m3h2x16(:,38),heltab2x32(:,:,45))
  call Hloop_QV_A(ntryL,G1H32(2),wf4(:,1),G1H8(10),m3h4x8(:,8),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(10),35,0,G2H8(4),n2h8(75))
  call Hloop_AV_Q(ntryL,G1H32(3),wf4(:,1),G1H8(21),m3h4x8(:,9),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(21),35,0,G2H8(5),n2h8(76))
  call Hloop_QA_V(ntryL,G1H32(4),ex3(:),G1H16(20),m3h2x16(:,39),heltab2x32(:,:,48))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,1),G1H8(17),m3h4x8(:,10),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(17),35,0,G2H8(9),n2h8(77))
  call Hloop_QV_A(ntryL,G1H32(6),wf4(:,1),G1H8(29),m3h4x8(:,11),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(29),35,0,G2H8(6),n2h8(78))
  call Hloop_UV_W(ntryL,G0H16(16),36,wf4(:,1),3,G1H4(31),m3h4x4(:,9),heltab2x16(:,:,58))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,1),G1H4(36),m3h4x4(:,10),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(36),39,0,G2H4(27),n2h4(68))
  call Hloop_VQ_A(ntryL,G0H16(2),ex4(:),G0H8(8),m3h2x8(:,50),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G0H8(8),44,0,G1H8(30),n2h8(79))
  call Hloop_UV_W(ntryL,G0H16(3),40,wf4(:,1),3,G1H4(3),m3h4x4(:,11),heltab2x16(:,:,61))
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,1),G1H4(11),m3h4x4(:,12),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(11),43,0,G2H4(28),n2h4(69))
  call Hloop_VA_Q(ntryL,G0H16(5),ex3(:),G0H8(1),m3h2x8(:,51),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(22),n2h8(80))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,1),G1H4(15),m3h4x4(:,13),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(15),51,0,G2H4(29),n2h4(70))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,1),G1H4(41),m3h4x4(:,14),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(41),51,0,G2H4(30),n2h4(71))
  call Hloop_QA_V(ntryL,G1H16(5),ex3(:),G1H8(32),m3h2x8(:,52),heltab2x16(:,:,66))
  call Hloop_QA_V(ntryL,G1H32(7),wf8(:,4),G1H4(27),m3h8x4(:,1),heltab2x32(:,:,51))
  call Hloop_AQ_V(ntryL,G1H32(8),ex4(:),G1H16(21),m3h2x16(:,40),heltab2x32(:,:,52))
  call Hloop_AQ_V(ntryL,G1H32(9),wf8(:,2),G1H4(33),m3h8x4(:,2),heltab2x32(:,:,53))
  call Hloop_QA_V(ntryL,G1H32(10),ex3(:),G1H16(22),m3h2x16(:,41),heltab2x32(:,:,54))
  call Hloop_AQ_V(ntryL,G1H32(11),ex4(:),G1H16(23),m3h2x16(:,42),heltab2x32(:,:,55))
  call Hloop_QV_A(ntryL,G1H32(12),wf4(:,6),G1H8(3),m3h4x8(:,12),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(3),37,0,G2H8(7),n2h8(81))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,6),G1H8(33),m3h4x8(:,13),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(33),37,0,G2H8(8),n2h8(82))
  call Hloop_QA_V(ntryL,G1H32(14),ex2(:),G1H16(24),m3h2x16(:,43),heltab2x32(:,:,58))
  call Hloop_QA_V(ntryL,G1H32(15),ex2(:),G1H16(25),m3h2x16(:,44),heltab2x32(:,:,59))
  call Hloop_QV_A(ntryL,G1H32(16),wf4(:,6),G1H8(34),m3h4x8(:,14),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(34),37,0,G2H8(10),n2h8(83))
  call Hloop_UV_W(ntryL,G0H16(9),34,wf4(:,6),5,G1H4(45),m3h4x4(:,15),heltab2x16(:,:,67))
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,6),G1H4(51),m3h4x4(:,16),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(51),39,0,G2H4(31),n2h4(72))
  call Hloop_VQ_A(ntryL,G0H16(11),ex4(:),G0H8(9),m3h2x8(:,53),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G0H8(9),42,0,G1H8(35),n2h8(84))
  call Hloop_UV_W(ntryL,G0H16(12),40,wf4(:,6),5,G1H4(52),m3h4x4(:,17),heltab2x16(:,:,70))
  call Hloop_VA_Q(ntryL,G0H16(13),ex2(:),G0H8(2),m3h2x8(:,54),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G0H8(2),42,0,G1H8(12),n2h8(85))
  call Hloop_VA_Q(ntryL,G0H16(14),ex2(:),G0H8(10),m3h2x8(:,55),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G0H8(10),42,0,G1H8(19),n2h8(86))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,6),G1H4(26),m3h4x4(:,18),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(26),53,0,G2H4(32),n2h4(73))
  call Hloop_QA_V(ntryL,G1H16(8),ex2(:),G1H8(24),m3h2x8(:,56),heltab2x16(:,:,74))
  call Hloop_QA_V(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,57),heltab2x16(:,:,75))
  call Hloop_QA_V(ntryL,G1H32(17),wf8(:,8),G1H4(20),m3h8x4(:,3),heltab2x32(:,:,61))
  call Hloop_AQ_V(ntryL,G1H32(18),ex4(:),G1H16(26),m3h2x16(:,45),heltab2x32(:,:,62))
  call Hloop_AQ_V(ntryL,G1H32(19),wf8(:,6),G1H4(57),m3h8x4(:,4),heltab2x32(:,:,63))
  call Hloop_QA_V(ntryL,G1H32(20),ex2(:),G1H16(27),m3h2x16(:,46),heltab2x32(:,:,64))
  call Hloop_AQ_V(ntryL,G1H16(10),ex4(:),G1H8(9),m3h2x8(:,58),heltab2x16(:,:,76))
  call Hloop_VA_Q(ntryL,G0H16(7),ex3(:),G0H8(3),m3h2x8(:,59),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G0H8(3),38,0,G1H8(23),n2h8(87))
  call Hloop_AQ_V(ntryL,G1H16(11),ex4(:),G1H8(14),m3h2x8(:,60),heltab2x16(:,:,78))
  call Hloop_VA_Q(ntryL,G0H16(10),ex2(:),G0H8(11),m3h2x8(:,61),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H8(11),38,0,G1H8(10),n2h8(88))
  call Hloop_QA_V(ntryL,G1H16(12),ex3(:),G1H8(21),m3h2x8(:,62),heltab2x16(:,:,80))
  call Hloop_QA_V(ntryL,G1H16(13),ex2(:),G1H8(17),m3h2x8(:,63),heltab2x16(:,:,81))
  call Hloop_VA_Q(ntryL,G0H16(4),ex2(:),G0H8(4),m3h2x8(:,64),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G0H8(4),42,0,G1H8(29),n2h8(89))
  call Hloop_QA_V(ntryL,G1H16(14),ex2(:),G1H8(3),m3h2x8(:,65),heltab2x16(:,:,83))
  call Hloop_QA_V(ntryL,G1H32(21),ex3(:),G1H16(28),m3h2x16(:,47),heltab2x32(:,:,65))
  call Hloop_AQ_V(ntryL,G1H32(22),ex4(:),G1H16(29),m3h2x16(:,48),heltab2x32(:,:,66))
  call Hloop_QA_V(ntryL,G1H32(23),ex3(:),G1H16(30),m3h2x16(:,49),heltab2x32(:,:,67))
  call Hloop_QA_V(ntryL,G1H32(24),ex2(:),G1H16(1),m3h2x16(:,50),heltab2x32(:,:,68))
  call Hloop_AQ_V(ntryL,G1H32(25),ex4(:),G1H16(2),m3h2x16(:,51),heltab2x32(:,:,69))
  call Hloop_QA_V(ntryL,G1H32(26),ex2(:),G1H16(3),m3h2x16(:,52),heltab2x32(:,:,70))
  call Hloop_AQ_V(ntryL,G1H16(15),ex4(:),G1H8(33),m3h2x8(:,66),heltab2x16(:,:,84))
  call Hloop_VQ_A(ntryL,G0H16(15),ex1(:),G0H8(12),m3h2x8(:,67),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G0H8(12),37,0,G1H8(34),n2h8(90))
  call Hloop_VA_Q(ntryL,G0H16(1),ex3(:),G0H8(5),m3h2x8(:,68),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G0H8(5),44,0,G1H8(36),n2h8(91))
  call Hloop_QA_V(ntryL,G1H16(16),ex3(:),G1H8(37),m3h2x8(:,69),heltab2x16(:,:,87))
  call Hloop_VQ_A(ntryL,G0H16(8),ex1(:),G0H8(13),m3h2x8(:,70),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G0H8(13),41,0,G1H8(38),n2h8(92))
  call Hloop_VQ_A(ntryL,G0H16(6),ex1(:),G0H8(6),m3h2x8(:,71),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G0H8(6),41,0,G1H8(39),n2h8(93))
  call Hloop_QA_V(ntryL,G1H32(27),ex3(:),G1H16(4),m3h2x16(:,53),heltab2x32(:,:,71))
  call Hloop_AQ_V(ntryL,G1H32(28),ex4(:),G1H16(5),m3h2x16(:,54),heltab2x32(:,:,72))
  call Hloop_QA_V(ntryL,G1H32(29),ex3(:),G1H16(6),m3h2x16(:,55),heltab2x32(:,:,73))
  call Hloop_VA_Q(ntryL,G0H8(15),ex3(:),G0H4(1),m3h2x4(:,83),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G0H4(1),54,0,G1H4(60),n2h4(74))
  call Hloop_VQ_A(ntryL,G0H8(16),ex1(:),G0H4(1),m3h2x4(:,84),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(66),n2h4(75))
  call Hloop_AQ_V(ntryL,G1H16(17),ex4(:),G1H8(40),m3h2x8(:,72),heltab2x16(:,:,90))
  call Hloop_VQ_A(ntryL,G0H16(17),ex1(:),G0H8(14),m3h2x8(:,73),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G0H8(14),35,0,G1H8(41),n2h8(94))
  call Hloop_VA_Q(ntryL,G0H16(18),ex2(:),G0H8(7),m3h2x8(:,74),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G0H8(7),42,0,G1H8(42),n2h8(95))
  call Hloop_QA_V(ntryL,G1H16(18),ex2(:),G1H8(43),m3h2x8(:,75),heltab2x16(:,:,93))
  call Hloop_VQ_A(ntryL,G0H16(19),ex1(:),G0H8(8),m3h2x8(:,76),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H8(8),41,0,G1H8(44),n2h8(96))
  call Hloop_VQ_A(ntryL,G0H16(20),ex1(:),G0H8(1),m3h2x8(:,77),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(45),n2h8(97))
  call Hloop_QA_V(ntryL,G1H32(30),ex2(:),G1H16(7),m3h2x16(:,56),heltab2x32(:,:,74))
  call Hloop_AQ_V(ntryL,G1H32(31),ex4(:),G1H16(8),m3h2x16(:,57),heltab2x32(:,:,75))
  call Hloop_QA_V(ntryL,G1H32(32),ex2(:),G1H16(9),m3h2x16(:,58),heltab2x32(:,:,76))
  call Hloop_VA_Q(ntryL,G0H8(17),ex2(:),G0H4(1),m3h2x4(:,85),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G0H4(1),54,0,G1H4(67),n2h4(76))
  call Hloop_VQ_A(ntryL,G0H8(18),ex1(:),G0H4(1),m3h2x4(:,86),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G0H4(1),53,0,G1H4(32),n2h4(77))
  call Hloop_VQ_A(ntryL,G0H16(21),ex1(:),G0H8(9),m3h2x8(:,78),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G0H8(9),35,0,G1H8(46),n2h8(98))
  call Hloop_VA_Q(ntryL,G0H16(22),ex3(:),G0H8(2),m3h2x8(:,79),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G0H8(2),38,0,G1H8(47),n2h8(99))
  call Hloop_VQ_A(ntryL,G0H16(23),ex1(:),G0H8(10),m3h2x8(:,80),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G0H8(10),37,0,G1H8(48),n2h8(100))
  call Hloop_VA_Q(ntryL,G0H16(24),ex2(:),G0H8(3),m3h2x8(:,81),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G0H8(3),38,0,G1H8(49),n2h8(101))
  call Hloop_VA_Q(ntryL,G0H8(19),ex2(:),G0H4(1),m3h2x4(:,87),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G0H4(1),58,0,G1H4(19),n2h4(78))
  call Hloop_QA_V(ntryL,G1H8(4),ex2(:),G1H4(68),m3h2x4(:,88),heltab2x8(:,:,105))
  call Hloop_VQ_A(ntryL,G0H8(20),ex1(:),G0H4(1),m3h2x4(:,89),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G0H4(1),57,0,G1H4(71),n2h4(79))
  call Hloop_VQ_A(ntryL,G0H8(21),ex1(:),G0H4(1),m3h2x4(:,90),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G0H4(1),57,0,G1H4(2),n2h4(80))
  call Hloop_QA_V(ntryL,G1H8(2),ex3(:),G1H4(73),m3h2x4(:,91),heltab2x8(:,:,108))
  call Hloop_AQ_V(ntryL,G1H8(7),ex1(:),G1H4(74),m3h2x4(:,92),heltab2x8(:,:,109))
  call Hloop_VQ_A(ntryL,G1H8(8),ex1(:),G1H4(79),m3h2x4(:,93),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(79),43,0,G2H4(33),n2h4(81))
  call Hloop_QA_V(ntryL,G1H8(11),ex2(:),G1H4(80),m3h2x4(:,94),heltab2x8(:,:,111))
  call Hloop_AQ_V(ntryL,G1H8(25),ex1(:),G1H4(78),m3h2x4(:,95),heltab2x8(:,:,112))
  call Hloop_VQ_A(ntryL,G1H8(28),ex1(:),G1H4(6),m3h2x4(:,96),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(6),45,0,G2H4(34),n2h4(82))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G1H4(1)])
call HGT_lower_alpha_w2_OLR(G2H4(35),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(35),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(35),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G2H4(28)])
call HGT_lower_alpha_w2_OLR(G2H4(40),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(40),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(40),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(13)])
call HGT_lower_alpha_w2_OLR(G2H4(45),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(45),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(45),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(46),G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(27),G1H4(65),G1H4(59),G1H4(50),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(70),G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(31)])
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(143),mass4set(:,1),  & 
G1H4(7),G1H4(36),G1H4(11),G1H4(15),G1H4(41),4)
  call HG1shiftOLR(G1H4(36),4,4)
  call Hloop_QA_V(ntryL,G2H4(36),ex3(:),G2H2(2),m3h2x2(:,119),heltab2x4(:,:,147))
  call Hotf_4pt_reduction(G2H4(40),RedSet_4(146),mass4set(:,1),  & 
G1H4(51),G1H4(26),G1H4(79),G1H4(6),G1H4(1),4)
  call HG1shiftOLR(G1H4(26),2,4)
  call Hloop_QA_V(ntryL,G2H4(41),ex2(:),G2H2(4),m3h2x2(:,120),heltab2x4(:,:,148))
  call Hotf_4pt_reduction(G2H4(45),RedSet_4(207),mass4set(:,1),  & 
G1H4(13),G1H4(48),G1H4(12),G1H4(42),G1H4(21),4)
  call HG1shiftOLR(G1H4(48),8,4)
  call Hloop_AQ_V(ntryL,G2H4(46),ex4(:),G2H2(6),m3h2x2(:,121),heltab2x4(:,:,149))
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(142),mass4set(:,1),  & 
G1H4(46),G1H4(22),G1H4(27),G1H4(65),G1H4(59),4)
  call HG1shiftOLR(G1H4(22),4,4)
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(145),mass4set(:,1),  & 
G1H4(50),G1H4(39),G1H4(49),G1H4(53),G1H4(70),4)
  call HG1shiftOLR(G1H4(39),2,4)
  call Hloop_AV_Q(ntryL,G1H4(38),ex5(:),G1H2(9),m3h2x2(:,122),heltab2x4(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(9),62,0,G2H2(8),n2h2(78))
  call Hloop_AV_Q(ntryL,G1H4(35),ex5(:),G1H2(47),m3h2x2(:,123),heltab2x4(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(47),62,0,G2H2(11),n2h2(79))
  call Hloop_AV_Q(ntryL,G1H4(10),ex5(:),G1H2(130),m3h2x2(:,124),heltab2x4(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(130),62,0,G2H2(50),n2h2(80))
  call Hloop_VA_Q(ntryL,G1H4(3),ex3(:),G1H2(148),m3h2x2(:,125),heltab2x4(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(148),47,0,G2H2(17),n2h2(81))
  call Hloop_VA_Q(ntryL,G1H4(33),ex3(:),G1H2(202),m3h2x2(:,126),heltab2x4(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(202),47,0,G2H2(51),n2h2(82))
  call Hloop_VQ_A(ntryL,G1H4(34),ex4(:),G1H2(214),m3h2x2(:,127),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(214),47,0,G2H2(23),n2h2(83))
  call Hloop_VQ_A(ntryL,G1H4(20),ex4(:),G1H2(220),m3h2x2(:,128),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(220),47,0,G2H2(52),n2h2(84))
  call Hloop_VQ_A(ntryL,G1H4(31),ex4(:),G1H2(238),m3h2x2(:,129),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(238),47,0,G2H2(53),n2h2(85))
  call Hloop_VA_Q(ntryL,G1H4(52),ex2(:),G1H2(250),m3h2x2(:,130),heltab2x4(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(250),47,0,G2H2(46),n2h2(86))
  call Hloop_VA_Q(ntryL,G1H4(57),ex2(:),G1H2(256),m3h2x2(:,131),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(256),47,0,G2H2(45),n2h2(87))
  call Hloop_VQ_A(ntryL,G1H4(58),ex4(:),G1H2(332),m3h2x2(:,132),heltab2x4(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(332),47,0,G2H2(44),n2h2(88))
  call Hloop_VQ_A(ntryL,G1H4(45),ex4(:),G1H2(373),m3h2x2(:,133),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(373),47,0,G2H2(43),n2h2(89))
  call Hloop_VA_Q(ntryL,G1H4(24),ex3(:),G1H2(384),m3h2x2(:,134),heltab2x4(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(384),47,0,G2H2(10),n2h2(90))
  call Hloop_QV_A(ntryL,G1H8(30),wf4(:,1),G1H2(400),m3h4x2(:,18),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(400),47,0,G2H2(117),n2h2(91))
  call Hloop_QV_A(ntryL,G1H8(18),wf4(:,1),G1H2(411),m3h4x2(:,19),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(411),47,0,G2H2(13),n2h2(92))
  call Hloop_AV_Q(ntryL,G1H8(22),wf4(:,1),G1H2(1),m3h4x2(:,20),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(14),n2h2(93))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,1),G1H2(2),m3h4x2(:,21),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(2),47,0,G2H2(16),n2h2(94))
  call Hloop_VA_Q(ntryL,G1H4(69),ex2(:),G1H2(19),m3h2x2(:,135),heltab2x4(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(19),47,0,G2H2(106),n2h2(95))
  call Hloop_QV_A(ntryL,G1H8(26),ex5(:),G1H4(54),m3h2x4(:,97),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G1H4(54),58,0,G2H4(37),n2h4(83))
  call Hloop_QV_A(ntryL,G1H8(27),ex5(:),G1H4(64),m3h2x4(:,98),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(64),58,0,G2H4(38),n2h4(84))
  call Hloop_QV_A(ntryL,G1H8(35),wf4(:,6),G1H2(20),m3h4x2(:,22),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(19),n2h2(96))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,6),G1H2(25),m3h4x2(:,23),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(20),n2h2(97))
  call Hloop_AV_Q(ntryL,G1H8(19),wf4(:,6),G1H2(37),m3h4x2(:,24),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(37),47,0,G2H2(22),n2h2(98))
  call Hloop_AV_Q(ntryL,G1H8(20),wf4(:,6),G1H2(38),m3h4x2(:,25),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(29),n2h2(99))
  call Hloop_QA_V(ntryL,G2H4(17),ex3(:),G2H2(25),m3h2x2(:,136),heltab2x4(:,:,164))
  call Hloop_QA_V(ntryL,G2H4(20),ex2(:),G2H2(26),m3h2x2(:,137),heltab2x4(:,:,165))
  call Hloop_AQ_V(ntryL,G2H4(2),ex4(:),G2H2(28),m3h2x2(:,138),heltab2x4(:,:,166))
  call Hloop_UV_W(ntryL,G1H16(19),40,wf4(:,1),3,G2H4(39),m3h4x4(:,19),heltab2x16(:,:,100))
  call Hloop_QA_V(ntryL,G2H8(4),wf4(:,3),G2H2(31),m3h4x2(:,26),heltab2x8(:,:,124))
  call Hloop_AQ_V(ntryL,G2H8(5),ex4(:),G2H4(42),m3h2x4(:,99),heltab2x8(:,:,125))
  call Hloop_UV_W(ntryL,G1H16(20),36,wf4(:,1),3,G2H4(43),m3h4x4(:,20),heltab2x16(:,:,101))
  call Hloop_AQ_V(ntryL,G2H8(9),wf4(:,5),G2H2(32),m3h4x2(:,27),heltab2x8(:,:,126))
  call Hloop_QA_V(ntryL,G2H8(6),ex3(:),G2H4(44),m3h2x4(:,100),heltab2x8(:,:,127))
  call Hloop_QA_V(ntryL,G2H4(29),ex3(:),G2H2(38),m3h2x2(:,139),heltab2x4(:,:,167))
  call Hloop_AQ_V(ntryL,G2H4(30),ex4(:),G2H2(54),m3h2x2(:,140),heltab2x4(:,:,168))
  call Hloop_UV_W(ntryL,G1H8(32),52,wf4(:,1),3,G2H2(1),m3h4x2(:,28),heltab2x8(:,:,128))
  call Hloop_VA_Q(ntryL,G1H16(21),wf8(:,4),G1H2(44),m3h8x2(:,1),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(39),n2h2(100))
  call Hloop_VQ_A(ntryL,G1H16(22),wf8(:,2),G1H2(61),m3h8x2(:,2),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(61),47,0,G2H2(57),n2h2(101))
  call Hloop_UV_W(ntryL,G1H16(23),40,wf4(:,6),5,G2H4(47),m3h4x4(:,21),heltab2x16(:,:,104))
  call Hloop_QA_V(ntryL,G2H8(7),wf4(:,8),G2H2(3),m3h4x2(:,29),heltab2x8(:,:,129))
  call Hloop_AQ_V(ntryL,G2H8(8),ex4(:),G2H4(48),m3h2x4(:,101),heltab2x8(:,:,130))
  call Hloop_UV_W(ntryL,G1H16(24),34,wf4(:,6),5,G2H4(6),m3h4x4(:,22),heltab2x16(:,:,105))
  call Hloop_VQ_A(ntryL,G1H16(25),wf4(:,5),G1H4(38),m3h4x4(:,23),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(38),58,0,G2H4(18),n2h4(85))
  call Hloop_QA_V(ntryL,G2H8(10),ex2(:),G2H4(8),m3h2x4(:,102),heltab2x8(:,:,131))
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(208),mass4set(:,1),  & 
G1H4(35),G1H4(10),G1H4(3),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(10),8,4)
  call Hloop_AV_Q(ntryL,G1H8(12),ex5(:),G1H4(20),m3h2x4(:,103),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(20),58,0,G2H4(22),n2h4(86))
  call Hloop_QA_V(ntryL,G2H4(32),ex2(:),G2H2(40),m3h2x2(:,141),heltab2x4(:,:,169))
  call Hloop_VQ_A(ntryL,G1H8(24),ex4(:),G1H4(31),m3h2x4(:,104),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(31),58,0,G2H4(25),n2h4(87))
  call Hloop_UV_W(ntryL,G1H8(1),50,wf4(:,6),5,G2H2(41),m3h4x2(:,30),heltab2x8(:,:,134))
  call Hloop_VA_Q(ntryL,G1H16(26),wf8(:,8),G1H2(62),m3h8x2(:,3),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(62),47,0,G2H2(5),n2h2(102))
  call Hloop_VQ_A(ntryL,G1H16(27),wf8(:,6),G1H2(68),m3h8x2(:,4),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(68),47,0,G2H2(42),n2h2(103))
  call Hloop_VA_Q(ntryL,G1H8(9),ex3(:),G1H4(52),m3h2x4(:,105),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(52),46,0,G2H4(24),n2h4(88))
  call Hloop_AQ_V(ntryL,G1H8(23),wf4(:,10),G1H2(24),m3h4x2(:,31),heltab2x8(:,:,136))
  call Hloop_VA_Q(ntryL,G1H8(14),ex2(:),G1H4(57),m3h2x4(:,106),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(57),46,0,G2H4(3),n2h4(89))
  call Hloop_AQ_V(ntryL,G1H8(10),wf4(:,10),G1H2(30),m3h4x2(:,32),heltab2x8(:,:,138))
  call Hloop_VA_Q(ntryL,G1H8(21),ex2(:),G1H4(58),m3h2x4(:,107),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(58),46,0,G2H4(21),n2h4(90))
  call Hloop_VA_Q(ntryL,G1H8(17),ex3(:),G1H4(45),m3h2x4(:,108),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(45),46,0,G2H4(26),n2h4(91))
  call Hloop_AQ_V(ntryL,G1H8(29),wf4(:,10),G1H2(36),m3h4x2(:,33),heltab2x8(:,:,141))
  call Hloop_VQ_A(ntryL,G1H8(3),wf4(:,10),G1H2(54),m3h4x2(:,34),heltab2x8(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(54),59,0,G2H2(7),n2h2(104))
  call Hloop_VQ_A(ntryL,G1H16(28),ex4(:),G1H8(4),m3h2x8(:,82),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(4),44,0,G2H8(11),n2h8(102))
  call Hloop_VA_Q(ntryL,G1H16(29),ex3(:),G1H8(2),m3h2x8(:,83),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G1H8(2),44,0,G2H8(13),n2h8(103))
  call Hloop_UV_W(ntryL,G1H16(30),36,wf8(:,10),19,G2H2(9),m3h8x2(:,5),heltab2x16(:,:,111))
  call Hloop_VQ_A(ntryL,G1H16(1),ex4(:),G1H8(7),m3h2x8(:,84),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(7),42,0,G2H8(14),n2h8(104))
  call Hloop_VA_Q(ntryL,G1H16(2),ex2(:),G1H8(8),m3h2x8(:,85),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H8(8),42,0,G2H8(15),n2h8(105))
  call Hloop_UV_W(ntryL,G1H16(3),34,wf8(:,9),21,G2H2(12),m3h8x2(:,6),heltab2x16(:,:,114))
  call Hloop_VQ_A(ntryL,G1H8(33),ex1(:),G1H4(24),m3h2x4(:,109),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(24),45,0,G2H4(11),n2h4(92))
  call Hloop_QA_V(ntryL,G1H8(34),wf4(:,8),G1H2(60),m3h4x2(:,35),heltab2x8(:,:,144))
  call Hloop_AQ_V(ntryL,G1H8(36),ex1(:),G1H4(69),m3h2x4(:,110),heltab2x8(:,:,145))
  call Hloop_VQ_A(ntryL,G1H8(37),ex1(:),G1H4(54),m3h2x4(:,111),heltab2x8(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(54),45,0,G2H4(15),n2h4(93))
  call Hloop_QA_V(ntryL,G1H8(38),ex3(:),G1H4(64),m3h2x4(:,112),heltab2x8(:,:,147))
  call Hloop_QA_V(ntryL,G1H8(39),wf4(:,8),G1H2(72),m3h4x2(:,36),heltab2x8(:,:,148))
  call Hloop_VQ_A(ntryL,G1H16(4),ex4(:),G1H8(11),m3h2x8(:,86),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(11),44,0,G2H8(16),n2h8(106))
  call Hloop_VA_Q(ntryL,G1H16(5),ex3(:),G1H8(25),m3h2x8(:,87),heltab2x16(:,:,116))
  call Hloop_A_Q(ntryL,G1H8(25),44,0,G2H8(17),n2h8(107))
  call Hloop_UV_W(ntryL,G1H16(6),36,wf8(:,11),19,G2H2(75),m3h8x2(:,7),heltab2x16(:,:,117))
  call Hloop_AQ_V(ntryL,G1H4(60),ex1(:),G1H2(417),m3h2x2(:,142),heltab2x4(:,:,170))
  call Hloop_QA_V(ntryL,G1H4(66),ex3(:),G1H2(10),m3h2x2(:,143),heltab2x4(:,:,171))
  call Hloop_VQ_A(ntryL,G1H8(40),ex1(:),G1H4(38),m3h2x4(:,113),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(38),43,0,G2H4(19),n2h4(94))
  call Hloop_QA_V(ntryL,G1H8(41),wf4(:,3),G1H2(11),m3h4x2(:,37),heltab2x8(:,:,150))
  call Hloop_AQ_V(ntryL,G1H8(42),ex1(:),G1H4(20),m3h2x4(:,114),heltab2x8(:,:,151))
  call Hloop_VQ_A(ntryL,G1H8(43),ex1(:),G1H4(31),m3h2x4(:,115),heltab2x8(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(31),43,0,G2H4(23),n2h4(95))
  call Hloop_QA_V(ntryL,G1H8(44),ex2(:),G1H4(52),m3h2x4(:,116),heltab2x8(:,:,153))
  call Hloop_QA_V(ntryL,G1H8(45),wf4(:,3),G1H2(17),m3h4x2(:,38),heltab2x8(:,:,154))
  call Hloop_VQ_A(ntryL,G1H16(7),ex4(:),G1H8(28),m3h2x8(:,88),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(28),42,0,G2H8(18),n2h8(108))
  call Hloop_VA_Q(ntryL,G1H16(8),ex2(:),G1H8(13),m3h2x8(:,89),heltab2x16(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(13),42,0,G2H8(12),n2h8(109))
  call Hloop_UV_W(ntryL,G1H16(9),34,wf8(:,12),21,G2H2(15),m3h8x2(:,8),heltab2x16(:,:,120))
  call Hloop_AQ_V(ntryL,G1H4(67),ex1(:),G1H2(21),m3h2x2(:,144),heltab2x4(:,:,172))
  call Hloop_QA_V(ntryL,G1H4(32),ex2(:),G1H2(23),m3h2x2(:,145),heltab2x4(:,:,173))
  call Hloop_QA_V(ntryL,G1H8(46),ex3(:),G1H4(57),m3h2x4(:,117),heltab2x8(:,:,155))
  call Hloop_AQ_V(ntryL,G1H8(47),ex1(:),G1H4(58),m3h2x4(:,118),heltab2x8(:,:,156))
  call Hloop_QA_V(ntryL,G1H8(48),ex2(:),G1H4(45),m3h2x4(:,119),heltab2x8(:,:,157))
  call Hloop_AQ_V(ntryL,G1H8(49),ex1(:),G1H4(24),m3h2x4(:,120),heltab2x8(:,:,158))
  call Hloop_AQ_V(ntryL,G1H4(19),ex1(:),G1H2(29),m3h2x2(:,146),heltab2x4(:,:,174))
  call Hloop_VQ_A(ntryL,G1H4(68),ex1(:),G1H2(33),m3h2x2(:,147),heltab2x4(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(33),59,0,G2H2(79),n2h2(105))
  call Hloop_QA_V(ntryL,G1H4(71),ex2(:),G1H2(34),m3h2x2(:,148),heltab2x4(:,:,176))
  call Hloop_QA_V(ntryL,G1H4(2),ex3(:),G1H2(40),m3h2x2(:,149),heltab2x4(:,:,177))
  call Hloop_VQ_A(ntryL,G1H4(73),ex1(:),G1H2(65),m3h2x2(:,150),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(65),47,0,G2H2(83),n2h2(106))
  call Hloop_VA_Q(ntryL,G1H4(74),ex3(:),G1H2(41),m3h2x2(:,151),heltab2x4(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(41),47,0,G2H2(18),n2h2(107))
  call Hloop_VQ_A(ntryL,G1H4(80),ex1(:),G1H2(390),m3h2x2(:,152),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(390),47,0,G2H2(21),n2h2(108))
  call Hloop_VA_Q(ntryL,G1H4(78),ex2(:),G1H2(51),m3h2x2(:,153),heltab2x4(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(51),47,0,G2H2(87),n2h2(109))
  call Hloop_QV_A(ntryL,G1H4(7),ex5(:),G1H2(52),m3h2x2(:,154),heltab2x4(:,:,182))
  call Hloop_Q_A(ntryL,G1H2(52),59,0,G2H2(24),n2h2(110))
call HGT_raise_alpha_OLR(G1H4(36),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(36),ex3(:),G1H2(63),m3h2x2(:,155),heltab2x4(:,:,183))
  call Hloop_QV_A(ntryL,G1H4(15),ex5(:),G1H2(64),m3h2x2(:,156),heltab2x4(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(64),59,0,G2H2(91),n2h2(111))
  call Hloop_QV_A(ntryL,G1H4(41),ex5(:),G1H2(69),m3h2x2(:,157),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(69),59,0,G2H2(95),n2h2(112))
  call Hloop_QV_A(ntryL,G1H4(51),ex5(:),G1H2(76),m3h2x2(:,158),heltab2x4(:,:,186))
  call Hloop_Q_A(ntryL,G1H2(76),61,0,G2H2(27),n2h2(113))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex2(:),G1H2(77),m3h2x2(:,159),heltab2x4(:,:,187))
  call Hloop_QV_A(ntryL,G1H4(6),ex5(:),G1H2(78),m3h2x2(:,160),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(78),61,0,G2H2(30),n2h2(114))
  call Hloop_QV_A(ntryL,G1H4(1),ex5(:),G1H2(82),m3h2x2(:,161),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(82),61,0,G2H2(33),n2h2(115))
  call Hloop_AV_Q(ntryL,G1H4(13),ex5(:),G1H2(83),m3h2x2(:,162),heltab2x4(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(83),55,0,G2H2(34),n2h2(116))
call HGT_raise_alpha_OLR(G1H4(48),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(48),ex4(:),G1H2(84),m3h2x2(:,163),heltab2x4(:,:,191))
  call Hloop_AV_Q(ntryL,G1H4(42),ex5(:),G1H2(88),m3h2x2(:,164),heltab2x4(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(88),55,0,G2H2(35),n2h2(117))
  call Hloop_AV_Q(ntryL,G1H4(21),ex5(:),G1H2(89),m3h2x2(:,165),heltab2x4(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(89),55,0,G2H2(36),n2h2(118))
  call Hloop_QV_A(ntryL,G1H4(46),ex5(:),G1H2(90),m3h2x2(:,166),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(90),59,0,G2H2(37),n2h2(119))
call HGT_raise_alpha_OLR(G1H4(22),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(22),ex3(:),G1H2(94),m3h2x2(:,167),heltab2x4(:,:,195))
  call Hloop_QV_A(ntryL,G1H4(65),ex5(:),G1H2(95),m3h2x2(:,168),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(95),59,0,G2H2(47),n2h2(120))
  call Hloop_QV_A(ntryL,G1H4(59),ex5(:),G1H2(96),m3h2x2(:,169),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(96),59,0,G2H2(48),n2h2(121))
  call Hloop_QV_A(ntryL,G1H4(50),ex5(:),G1H2(100),m3h2x2(:,170),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(100),61,0,G2H2(49),n2h2(122))
call HGT_raise_alpha_OLR(G1H4(39),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(39),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(39),ex2(:),G1H2(101),m3h2x2(:,171),heltab2x4(:,:,199))
  call Hloop_QV_A(ntryL,G1H4(53),ex5(:),G1H2(102),m3h2x2(:,172),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(102),61,0,G2H2(56),n2h2(123))
  call Hloop_QV_A(ntryL,G1H4(70),ex5(:),G1H2(106),m3h2x2(:,173),heltab2x4(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(106),61,0,G2H2(59),n2h2(124))
  call Hloop_AV_Q(ntryL,G1H4(35),ex5(:),G1H2(107),m3h2x2(:,174),heltab2x4(:,:,202))
  call Hloop_A_Q(ntryL,G1H2(107),55,0,G2H2(60),n2h2(125))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(10),ex4(:),G1H2(108),m3h2x2(:,175),heltab2x4(:,:,203))
  call Hloop_AV_Q(ntryL,G1H4(33),ex5(:),G1H2(112),m3h2x2(:,176),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(112),55,0,G2H2(62),n2h2(126))
  call Hloop_AV_Q(ntryL,G1H4(34),ex5(:),G1H2(113),m3h2x2(:,177),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(113),55,0,G2H2(63),n2h2(127))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(55),G1H2(129),G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(58),G1H2(147),G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(61),G1H2(331)])
call HGT_w2_OLR(G1H2(43),1,1,2)
call HGT_w2_invQ_OLR(G1H2(43),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(64)])
call HGT_w2_OLR(G1H2(55),1,1,2)
call HGT_w2_invQ_OLR(G1H2(55),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(289),[G1H2(283)])
call HGT_w2_OLR(G1H2(67),1,1,2)
call HGT_w2_invQ_OLR(G1H2(67),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(67),[G1H2(289)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(265),[G1H2(259)])
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(81),[G1H2(66)])
call HGT_OLR(G2H2(76),1,1,2)
call HGT_invQ_OLR(G2H2(76),2,5,2)
call HGT_OLR(G2H2(76),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G2H2(39),G2H2(118),G2H2(107),G2H2(89),G2H2(77) &
    ,G1H2(237),G1H2(201),G1H2(87),G1H2(71),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(22)])
call HGT_OLR(G2H2(80),1,1,2)
call HGT_invQ_OLR(G2H2(80),2,5,2)
call HGT_OLR(G2H2(80),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G1H2(213),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(93),G1H2(16)])
call HGT_OLR(G2H2(84),1,1,2)
call HGT_invQ_OLR(G2H2(84),2,5,2)
call HGT_OLR(G2H2(84),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(104),G2H2(85),G1H2(383),G1H2(219),G1H2(99) &
    ,G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(39)])
call HGT_OLR(G2H2(88),1,1,2)
call HGT_invQ_OLR(G2H2(88),2,5,2)
call HGT_OLR(G2H2(88),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(70)])
call HGT_OLR(G2H2(92),1,1,2)
call HGT_invQ_OLR(G2H2(92),2,5,2)
call HGT_OLR(G2H2(92),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(249),G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(111),G1H2(58)])
call HGT_OLR(G2H2(96),1,1,2)
call HGT_invQ_OLR(G2H2(96),2,5,2)
call HGT_OLR(G2H2(96),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G2H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(115),G2H2(97),G1H2(410),G1H2(255),G1H2(117) &
    ,G1H2(75)])
call HGT_OLR(G2H2(100),1,1,2)
call HGT_invQ_OLR(G2H2(100),2,5,2)
call HGT_OLR(G2H2(100),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G2H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G1H2(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(111),[G1H2(399)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(211),G1H2(205)])
call HGT_OLR(G2H2(113),1,1,2)
call HGT_invQ_OLR(G2H2(113),2,5,2)
call HGT_OLR(G2H2(113),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(9),G1H4(77)])
call HGT_OLR(G2H4(13),1,1,4)
call HGT_invQ_OLR(G2H4(13),2,5,4)
call HGT_OLR(G2H4(13),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(123),G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G2H2(12),G1H2(183),G1H2(135),G1H2(18),G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(60),[G1H2(141),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G2H2(9),G1H2(171),G1H2(153),G1H2(56),G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(159),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(165),[G1H2(12),G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(177),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G1H2(189),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(195),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(207),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(225),G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(231),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(34),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(285),[G1H2(261),G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(291),[G1H2(267),G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(110),[G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(273),[G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(279),[G1H2(116),G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(417),[G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(297),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(127),G1H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(133),[G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(134),G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(145),G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(151),[G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(152),G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(175),[G1H2(163),G1H2(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(169),[G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(182),[G1H2(170),G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(181),[G1H2(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(193),G1H2(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(260),G1H2(199),G1H2(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(371),G1H2(266),G1H2(200),G1H2(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(272),G1H2(217),G1H2(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G1H2(278),G1H2(254),G1H2(248),G1H2(218),G1H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G1H2(229),G1H2(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(284),G1H2(235),G1H2(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(398),G1H2(290),G1H2(236),G1H2(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(247),G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(296),G1H2(253),G1H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(295),[G1H2(277),G1H2(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G1H4(9),G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(25),G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(44),G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(40),G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(377),[G1H2(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(421),[G1H2(394),G1H2(357),G1H2(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(366),[G1H2(361),G1H2(351),G1H2(346)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(389),[G1H2(352)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(404),[G1H2(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(416),[G1H2(367)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(370)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G1H2(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G1H2(397)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(409)])
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(7),mass4set(:,1),  & 
G1H2(114),G1H2(118),G1H2(119),G1H2(120),G1H2(124),2)
  call HG1shiftOLR(G1H2(118),8,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(22),mass4set(:,1),  & 
G1H2(125),G1H2(126),G1H2(317),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(126),8,2)
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(193),mass4set(:,1),  & 
G1H2(136),G1H2(137),G1H2(138),G1H2(142),G1H2(143),2)
  call HG1shiftOLR(G1H2(137),4,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(209),mass4set(:,1),  & 
G1H2(144),G1H2(322),G1H2(149),G1H2(150),G1H2(154),2)
  call HG1shiftOLR(G1H2(322),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(2),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hotf_4pt_reduction(G2H2(83),RedSet_4(210),mass4set(:,1),  & 
G1H2(155),G1H2(156),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(156),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(67),ex2(:),G2tensor(4),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hloop_AV_Q(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(239))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(70),ex1(:),G2tensor(8),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hloop_AV_Q(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(240))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(73),ex1(:),G2tensor(12),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(157),mass4set(:,1),  & 
G1H2(166),G1H2(167),G1H2(168),G1H2(172),G1H2(173),2)
  call HG1shiftOLR(G1H2(167),4,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(63),mass4set(:,1),  & 
G1H2(174),G1H2(178),G1H2(179),G1H2(180),G1H2(184),2)
  call HG1shiftOLR(G1H2(178),16,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(160),mass4set(:,1),  & 
G1H2(185),G1H2(186),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(186),8,2)
  call Hotf_4pt_reduction(G2H2(81),RedSet_4(75),mass4set(:,1),  & 
G1H2(196),G1H2(197),G1H2(198),G1H2(338),G1H2(203),2)
  call HG1shiftOLR(G1H2(197),16,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(161),mass4set(:,1),  & 
G1H2(204),G1H2(208),G1H2(209),G1H2(210),G1H2(343),2)
  call HG1shiftOLR(G1H2(208),8,2)
  call Hotf_4pt_reduction(G2H2(57),RedSet_4(78),mass4set(:,1),  & 
G1H2(215),G1H2(216),G1H2(348),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(216),16,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(165),mass4set(:,1),  & 
G1H2(226),G1H2(227),G1H2(228),G1H2(232),G1H2(233),2)
  call HG1shiftOLR(G1H2(227),2,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(168),mass4set(:,1),  & 
G1H2(234),G1H2(353),G1H2(239),G1H2(240),G1H2(244),2)
  call HG1shiftOLR(G1H2(353),8,2)
  call Hotf_4pt_reduction(G2H2(93),RedSet_4(101),mass4set(:,1),  & 
G1H2(245),G1H2(246),G1H2(358),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(246),16,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(169),mass4set(:,1),  & 
G1H2(363),G1H2(257),G1H2(258),G1H2(262),G1H2(263),2)
  call HG1shiftOLR(G1H2(257),8,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(104),mass4set(:,1),  & 
G1H2(264),G1H2(268),G1H2(269),G1H2(270),G1H2(274),2)
  call HG1shiftOLR(G1H2(268),16,2)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(211),mass4set(:,1),  & 
G1H2(275),G1H2(276),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(276),4,2)
  call Hotf_4pt_reduction(G2H2(101),RedSet_4(101),mass4set(:,1),  & 
G1H2(286),G1H2(287),G1H2(288),G1H2(292),G1H2(293),2)
  call HG1shiftOLR(G1H2(287),16,2)
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(212),mass4set(:,1),  & 
G1H4(54),G1H4(60),G1H4(66),G1H4(38),G1H4(31),4)
  call HG1shiftOLR(G1H4(60),3,4)
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(166),mass4set(:,1),  & 
G1H4(67),G1H4(32),G1H4(19),G1H4(68),G1H4(71),4)
  call HG1shiftOLR(G1H4(32),3,4)
call HGT_OLR(G2H2(110),1,1,2)
call HGT_invQ_OLR(G2H2(110),2,5,2)
call HGT_OLR(G2H2(110),6,15,2)
  call Hotf_4pt_reduction(G2H2(110),RedSet_4(213),mass4set(:,1),  & 
G1H2(294),G1H2(298),G1H2(299),G1H2(300),G1H2(304),2)
  call HG1shiftOLR(G1H2(298),2,2)
  call Hotf_4pt_reduction(G2H2(111),RedSet_4(75),mass4set(:,1),  & 
G1H2(305),G1H2(306),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(306),16,2)
  call Hotf_4pt_reduction(G2H2(113),RedSet_4(69),mass4set(:,1),  & 
G1H2(316),G1H2(318),G1H2(323),G1H2(327),G1H2(328),2)
  call HG1shiftOLR(G1H2(318),16,2)
  call Hotf_4pt_reduction(G2H4(18),RedSet_4(203),mass4set(:,1),  & 
G1H4(2),G1H4(73),G1H4(74),G1H4(80),G1H4(78),4)
  call HG1shiftOLR(G1H4(73),5,4)
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(214),mass4set(:,1),  & 
G1H4(7),G1H4(36),G1H4(15),G1H4(41),G1H4(51),4)
  call HG1shiftOLR(G1H4(36),5,4)
call HGT_OLR(G2H4(16),1,1,4)
call HGT_invQ_OLR(G2H4(16),2,5,4)
call HGT_OLR(G2H4(16),6,15,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(158),mass4set(:,1),  & 
G1H4(26),G1H4(6),G1H4(1),G1H4(13),G1H4(48),4)
  call HG1shiftOLR(G1H4(6),5,4)
  call Hloop_VQ_A(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(241))
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(10),mass4set(:,1),  & 
G1H2(333),G1H2(334),G1H2(339),G1H2(344),G1H2(349),2)
  call HG1shiftOLR(G1H2(334),8,2)
  call Hloop_VQ_A(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(16),n2h1(242))
  call Hotf_4pt_reduction(G2H2(75),RedSet_4(25),mass4set(:,1),  & 
G1H2(354),G1H2(359),G1H2(364),G1H2(368),G1H2(369),2)
  call HG1shiftOLR(G1H2(359),8,2)
  call Hloop_VQ_A(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(18),n2h1(243))
  call Hloop_VQ_A(ntryL,G1H2(165),ex4(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(20),n2h1(244))
  call Hloop_VQ_A(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(245))
  call Hloop_VA_Q(ntryL,G1H2(29),ex3(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(246))
  call Hloop_VA_Q(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(247))
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(56),mass4set(:,1),  & 
G1H2(374),G1H2(375),G1H2(379),G1H2(380),G1H2(385),2)
  call HG1shiftOLR(G1H2(375),16,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(60),mass4set(:,1),  & 
G1H2(386),G1H2(391),G1H2(395),G1H2(396),G1H2(401),2)
  call HG1shiftOLR(G1H2(391),16,2)
  call Hloop_VQ_A(ntryL,G1H2(23),ex4(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(248))
  call Hloop_QV_A(ntryL,G1H2(207),ex5(:),G1H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(249))
  call Hloop_VA_Q(ntryL,G1H2(59),ex2(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(250))
  call Hloop_VA_Q(ntryL,G1H2(35),ex2(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(251))
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(85),mass4set(:,1),  & 
G1H2(402),G1H2(406),G1H2(407),G1H2(412),G1H2(413),2)
  call HG1shiftOLR(G1H2(406),16,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(88),mass4set(:,1),  & 
G1H2(418),G1H2(9),G1H2(47),G1H2(130),G1H2(148),2)
  call HG1shiftOLR(G1H2(9),16,2)
  call Hloop_VQ_A(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(252))
  call Hloop_QV_A(ntryL,G1H2(243),ex5(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(253))
  call Hloop_VA_Q(ntryL,G1H2(34),ex3(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(254))
  call Hloop_VA_Q(ntryL,G1H2(80),ex3(:),G1H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(255))
  call Hloop_AV_Q(ntryL,G1H2(285),ex5(:),G1H1(1),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(256))
  call Hloop_AV_Q(ntryL,G1H2(291),ex5(:),G1H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(257))
  call Hloop_VQ_A(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(258))
  call Hloop_VQ_A(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(259))
  call Hloop_QV_A(ntryL,G1H2(273),ex5(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(260))
  call Hloop_QV_A(ntryL,G1H2(279),ex5(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(261))
  call Hloop_VA_Q(ntryL,G1H2(40),ex2(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(262))
  call Hloop_VA_Q(ntryL,G1H2(104),ex2(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(263))
  call Hloop_VQ_A(ntryL,G1H2(417),ex4(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(264))
  call Hloop_QV_A(ntryL,G1H2(297),ex5(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(265))
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(1),mass4set(:,1),  & 
G1H2(202),G1H2(214),G1H2(220),G1H2(238),G1H2(250),2)
  call HG1shiftOLR(G1H2(214),8,2)
  call Hloop_VQ_A(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(266))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(6),mass4set(:,1),  & 
G1H2(256),G1H2(332),G1H2(373),G1H2(384),G1H2(400),2)
  call HG1shiftOLR(G1H2(332),8,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(16),mass4set(:,1),  & 
G1H2(411),G1H2(1),G1H2(2),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hloop_VQ_A(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(267))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(21),mass4set(:,1),  & 
G1H2(25),G1H2(37),G1H2(38),G1H2(44),G1H2(61),2)
  call HG1shiftOLR(G1H2(37),8,2)
  call Hloop_VQ_A(ntryL,G1H2(175),ex4(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(268))
  call Hloop_VQ_A(ntryL,G1H2(169),ex4(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(269))
  call Hloop_VQ_A(ntryL,G1H2(182),ex4(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(270))
  call Hloop_VQ_A(ntryL,G1H2(181),ex4(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(271))
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(54),mass4set(:,1),  & 
G1H2(62),G1H2(68),G1H2(54),G1H2(33),G1H2(65),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(55),mass4set(:,1),  & 
G1H2(41),G1H2(390),G1H2(51),G1H2(52),G1H2(64),2)
  call HG1shiftOLR(G1H2(390),16,2)
  call Hotf_4pt_reduction(G2H2(51),RedSet_4(59),mass4set(:,1),  & 
G1H2(69),G1H2(76),G1H2(78),G1H2(82),G1H2(83),2)
  call HG1shiftOLR(G1H2(76),16,2)
  call Hotf_4pt_reduction(G2H2(53),RedSet_4(70),mass4set(:,1),  & 
G1H2(88),G1H2(89),G1H2(90),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(89),16,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(74),mass4set(:,1),  & 
G1H2(100),G1H2(102),G1H2(106),G1H2(107),G1H2(112),2)
  call HG1shiftOLR(G1H2(102),16,2)
  call Hotf_4pt_reduction(G2H2(87),RedSet_4(83),mass4set(:,1),  & 
G1H2(113),G1H2(129),G1H2(13),G1H2(147),G1H2(31),2)
  call HG1shiftOLR(G1H2(129),16,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(84),mass4set(:,1),  & 
G1H2(331),G1H2(43),G1H2(55),G1H2(283),G1H2(289),2)
  call HG1shiftOLR(G1H2(43),16,2)
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(87),mass4set(:,1),  & 
G1H2(259),G1H2(265),G1H2(66),G1H2(81),G1H2(237),2)
  call HG1shiftOLR(G1H2(265),16,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(96),mass4set(:,1),  & 
G1H2(201),G1H2(87),G1H2(71),G1H2(5),G1H2(22),2)
  call HG1shiftOLR(G1H2(87),16,2)
  call Hotf_4pt_reduction(G2H2(43),RedSet_4(97),mass4set(:,1),  & 
G1H2(213),G1H2(28),G1H2(93),G1H2(16),G1H2(383),2)
  call HG1shiftOLR(G1H2(28),16,2)
  call Hloop_QV_A(ntryL,G1H2(295),ex5(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(108),n2h1(272))
  call Hloop_VA_Q(ntryL,G1H4(64),wf4(:,8),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(273))
  call Hloop_VA_Q(ntryL,G1H4(14),wf4(:,8),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(274))
  call Hotf_4pt_reduction(G2H4(47),RedSet_4(91),mass4set(:,1),  & 
G1H4(42),G1H4(21),G1H4(46),G1H4(22),G1H4(65),4)
  call HG1shiftOLR(G1H4(21),18,4)
  call Hloop_VA_Q(ntryL,G1H4(69),wf4(:,8),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(275))
  call Hloop_VA_Q(ntryL,G1H4(5),wf4(:,8),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(276))
  call Hloop_VA_Q(ntryL,G1H4(52),wf4(:,3),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(277))
  call Hloop_VA_Q(ntryL,G1H4(47),wf4(:,3),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(278))
  call Hotf_4pt_reduction(G2H4(39),RedSet_4(64),mass4set(:,1),  & 
G1H4(59),G1H4(50),G1H4(39),G1H4(53),G1H4(70),4)
  call HG1shiftOLR(G1H4(50),20,4)
  call Hloop_VA_Q(ntryL,G1H4(20),wf4(:,3),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(279))
  call Hloop_VA_Q(ntryL,G1H4(4),wf4(:,3),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(280))
  call Hloop_VQ_A(ntryL,G1H4(57),wf4(:,5),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,214))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(281))
  call Hotf_4pt_reduction(G2H4(44),RedSet_4(102),mass4set(:,1),  & 
G1H4(35),G1H4(10),G1H4(33),G1H4(34),G1H4(77),4)
  call HG1shiftOLR(G1H4(10),24,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(105),mass4set(:,1),  & 
G1H4(8),G1H4(9),G1H4(18),G1H4(29),G1H4(17),4)
  call HG1shiftOLR(G1H4(9),24,4)
  call Hloop_VQ_A(ntryL,G1H4(45),wf4(:,5),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(282))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(76),mass4set(:,1),  & 
G1H4(25),G1H4(23),G1H4(30),G1H4(16),G1H4(55),4)
  call HG1shiftOLR(G1H4(23),24,4)
  call Hotf_4pt_reduction(G2H4(43),RedSet_4(79),mass4set(:,1),  & 
G1H4(44),G1H4(56),G1H4(61),G1H4(62),G1H4(40),4)
  call HG1shiftOLR(G1H4(56),24,4)
  call Hloop_VQ_A(ntryL,G1H4(24),wf4(:,5),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,216))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(283))
  call Hloop_VQ_A(ntryL,G1H4(43),wf4(:,5),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(284))
  call Hloop_VQ_A(ntryL,G1H4(58),wf4(:,5),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,218))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(48),n2h1(285))
  call Hloop_VA_Q(ntryL,G1H2(301),ex3(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(286))
  call Hloop_VA_Q(ntryL,G1H2(302),ex3(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(287))
  call Hloop_VA_Q(ntryL,G1H2(36),ex3(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(288))
  call Hloop_VA_Q(ntryL,G1H2(307),ex3(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(289))
  call Hloop_VA_Q(ntryL,G1H2(308),ex3(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(290))
  call Hloop_VA_Q(ntryL,G1H2(72),ex3(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(291))
  call Hloop_VA_Q(ntryL,G1H2(313),ex2(:),G1H1(1),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(292))
  call Hloop_VA_Q(ntryL,G1H2(314),ex2(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(293))
  call Hloop_VA_Q(ntryL,G1H2(17),ex2(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(156),n2h1(294))
  call Hloop_VQ_A(ntryL,G1H2(319),ex4(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(295))
  call Hloop_VQ_A(ntryL,G1H2(320),ex4(:),G1H1(1),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(296))
  call Hloop_VQ_A(ntryL,G1H2(321),ex4(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(297))
  call Hloop_VQ_A(ntryL,G1H2(324),ex4(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(165),n2h1(298))
  call Hloop_VQ_A(ntryL,G1H2(325),ex4(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(299))
  call Hloop_VQ_A(ntryL,G1H2(326),ex4(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(168),n2h1(300))
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(191),mass4set(:,1),  & 
G1H2(219),G1H2(99),G1H2(53),G1H2(39),G1H2(105),2)
  call HG1shiftOLR(G1H2(99),4,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(192),mass4set(:,1),  & 
G1H2(70),G1H2(249),G1H2(74),G1H2(111),G1H2(58),2)
  call HG1shiftOLR(G1H2(249),4,2)
  call Hloop_VA_Q(ntryL,G1H2(335),ex3(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(171),n2h1(301))
  call Hloop_VA_Q(ntryL,G1H2(336),ex3(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(174),n2h1(302))
  call Hloop_VA_Q(ntryL,G1H2(337),ex3(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(303))
  call Hloop_AV_Q(ntryL,G1H2(340),ex5(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(180),n2h1(304))
  call Hloop_AV_Q(ntryL,G1H2(377),ex5(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(183),n2h1(305))
  call Hloop_AV_Q(ntryL,G1H2(421),ex5(:),G1H1(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(186),n2h1(306))
  call Hloop_QV_A(ntryL,G1H2(345),ex5(:),G1H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(189),n2h1(307))
  call Hloop_QV_A(ntryL,G1H2(366),ex5(:),G1H1(1),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(192),n2h1(308))
  call Hloop_QV_A(ntryL,G1H2(347),ex5(:),G1H1(1),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(195),n2h1(309))
  call Hloop_QV_A(ntryL,G1H2(350),ex5(:),G1H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(198),n2h1(310))
  call Hloop_QV_A(ntryL,G1H2(389),ex5(:),G1H1(1),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(203),n2h1(311))
  call Hloop_AV_Q(ntryL,G1H2(355),ex5(:),G1H1(1),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(213),n2h1(312))
  call Hloop_AV_Q(ntryL,G1H2(404),ex5(:),G1H1(1),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(217),n2h1(313))
  call Hloop_QV_A(ntryL,G1H2(360),ex5(:),G1H1(1),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(222),n2h1(314))
  call Hloop_QV_A(ntryL,G1H2(362),ex5(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(226),n2h1(315))
  call Hloop_QV_A(ntryL,G1H2(365),ex5(:),G1H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(230),n2h1(316))
  call Hloop_QV_A(ntryL,G1H2(416),ex5(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(235),n2h1(317))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(195),mass4set(:,1),  & 
G1H2(410),G1H2(255),G1H2(117),G1H2(75),G1H2(372),2)
  call HG1shiftOLR(G1H2(255),16,2)
  call Hloop_AV_Q(ntryL,G1H2(376),ex5(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(236),n2h1(318))
  call Hloop_AV_Q(ntryL,G1H2(378),ex5(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(237),n2h1(319))
  call Hotf_4pt_reduction(G2H2(117),RedSet_4(197),mass4set(:,1),  & 
G1H2(399),G1H2(211),G1H2(205),G1H2(123),G1H2(8),2)
  call HG1shiftOLR(G1H2(211),16,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(88),mass4set(:,1),  & 
G1H2(183),G1H2(135),G1H2(18),G1H2(14),G1H2(141),2)
  call HG1shiftOLR(G1H2(135),16,2)
  call Hloop_QV_A(ntryL,G1H2(387),ex5(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(238),n2h1(320))
  call Hloop_QV_A(ntryL,G1H2(388),ex5(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(239),n2h1(321))
  call Hloop_AV_Q(ntryL,G1H2(392),ex5(:),G1H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(240),n2h1(322))
  call Hloop_AV_Q(ntryL,G1H2(393),ex5(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(241),n2h1(323))
  call Hotf_4pt_reduction(G2H2(106),RedSet_4(199),mass4set(:,1),  & 
G1H2(26),G1H2(171),G1H2(153),G1H2(56),G1H2(32),2)
  call HG1shiftOLR(G1H2(171),16,2)
  call Hloop_AV_Q(ntryL,G1H2(403),ex5(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(242),n2h1(324))
  call Hloop_AV_Q(ntryL,G1H2(405),ex5(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(243),n2h1(325))
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(201),mass4set(:,1),  & 
G1H4(63),G1H4(28),G1H4(37),G1H4(72),G1H4(75),4)
  call HG1shiftOLR(G1H4(28),5,4)
  call Hotf_4pt_reduction(G2H4(38),RedSet_4(202),mass4set(:,1),  & 
G1H4(76),G1H4(64),G1H4(14),G1H4(69),G1H4(5),4)
  call HG1shiftOLR(G1H4(64),5,4)
  call Hloop_QV_A(ntryL,G1H4(81),wf4(:,6),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(244),n2h1(326))
  call Hloop_QV_A(ntryL,G1H4(82),wf4(:,6),G1H1(1),m3h4x1(:,43),heltab2x4(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(245),n2h1(327))
  call Hloop_QV_A(ntryL,G1H4(83),wf4(:,6),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(246),n2h1(328))
  call Hotf_4pt_reduction(G2H2(19),RedSet_4(205),mass4set(:,1),  & 
G1H2(159),G1H2(49),G1H2(12),G1H2(50),G1H2(177),2)
  call HG1shiftOLR(G1H2(49),16,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(60),mass4set(:,1),  & 
G1H2(6),G1H2(42),G1H2(189),G1H2(3),G1H2(195),2)
  call HG1shiftOLR(G1H2(42),16,2)
  call Hloop_QV_A(ntryL,G1H2(414),ex5(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(247),n2h1(329))
  call Hloop_QV_A(ntryL,G1H2(415),ex5(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(248),n2h1(330))
  call Hloop_AV_Q(ntryL,G1H2(419),ex5(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(249),n2h1(331))
  call Hloop_AV_Q(ntryL,G1H2(420),ex5(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(250),n2h1(332))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex1(:),G2tensor(251),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex1(:),G2tensor(252),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(50),ex1(:),G2tensor(253),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hotf_4pt_reduction(G2H4(42),RedSet_4(138),mass4set(:,1),  & 
G1H4(52),G1H4(47),G1H4(20),G1H4(4),G1H4(57),4)
  call HG1shiftOLR(G1H4(47),20,4)
  call Hotf_4pt_reduction(G2H4(48),RedSet_4(140),mass4set(:,1),  & 
G1H4(45),G1H4(24),G1H4(43),G1H4(58),G1H4(81),4)
  call HG1shiftOLR(G1H4(24),18,4)
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(183),mass4set(:,1),  & 
G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(83),5,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(24),wf4(:,10),G2tensor(254),m3h4x1(:,45),heltab2x4(:,:,222))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(3),wf4(:,10),G2tensor(255),m3h4x1(:,46),heltab2x4(:,:,223))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(21),wf4(:,10),G2tensor(256),m3h4x1(:,47),heltab2x4(:,:,224))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(26),wf4(:,10),G2tensor(257),m3h4x1(:,48),heltab2x4(:,:,225))
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(139),mass4set(:,1),  & 
G1H8(5),G1H8(15),G1H8(31),G1H8(30),G1H8(18),8)
  call HG1shiftOLR(G1H8(15),19,8)
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(93),mass4set(:,1),  & 
G1H8(22),G1H8(6),G1H8(26),G1H8(27),G1H8(35),8)
  call HG1shiftOLR(G1H8(6),19,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(141),mass4set(:,1),  & 
G1H8(16),G1H8(19),G1H8(20),G1H8(32),G1H8(12),8)
  call HG1shiftOLR(G1H8(19),21,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(66),mass4set(:,1),  & 
G1H8(24),G1H8(1),G1H8(9),G1H8(23),G1H8(14),8)
  call HG1shiftOLR(G1H8(1),21,8)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(11),wf4(:,8),G2tensor(258),m3h4x1(:,49),heltab2x4(:,:,226))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(15),wf4(:,8),G2tensor(259),m3h4x1(:,50),heltab2x4(:,:,227))
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(139),mass4set(:,1),  & 
G1H8(10),G1H8(21),G1H8(17),G1H8(29),G1H8(3),8)
  call HG1shiftOLR(G1H8(21),19,8)
  call Hotf_4pt_reduction(G2H8(17),RedSet_4(93),mass4set(:,1),  & 
G1H8(4),G1H8(2),G1H8(7),G1H8(8),G1H8(33),8)
  call HG1shiftOLR(G1H8(2),19,8)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(19),wf4(:,3),G2tensor(260),m3h4x1(:,51),heltab2x4(:,:,228))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(23),wf4(:,3),G2tensor(261),m3h4x1(:,52),heltab2x4(:,:,229))
  call Hotf_4pt_reduction(G2H8(18),RedSet_4(141),mass4set(:,1),  & 
G1H8(34),G1H8(36),G1H8(37),G1H8(38),G1H8(39),8)
  call HG1shiftOLR(G1H8(36),21,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(66),mass4set(:,1),  & 
G1H8(11),G1H8(25),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(25),21,8)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(79),ex3(:),G2tensor(262),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(24),ex3(:),G2tensor(263),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(95),ex3(:),G2tensor(264),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(27),ex2(:),G2tensor(265),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex2(:),G2tensor(266),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(267),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(268),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex3(:),G2tensor(269),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(48),ex3(:),G2tensor(270),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex2(:),G2tensor(271),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(59),ex2(:),G2tensor(272),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(60),ex4(:),G2tensor(273),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(63),ex4(:),G2tensor(274),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hloop_VQ_A(ntryL,G1H2(114),ex4(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(275),n2h1(333))
  call Hloop_VQ_A(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(276),n2h1(334))
  call Hloop_VQ_A(ntryL,G1H2(124),ex4(:),G1H1(1),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(277),n2h1(335))
  call Hloop_VQ_A(ntryL,G1H2(125),ex4(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(278),n2h1(336))
  call Hloop_VQ_A(ntryL,G1H2(126),ex4(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(279),n2h1(337))
  call Hloop_VQ_A(ntryL,G1H2(132),ex4(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(280),n2h1(338))
  call Hloop_VA_Q(ntryL,G1H2(136),ex3(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(281),n2h1(339))
  call Hloop_VA_Q(ntryL,G1H2(137),ex3(:),G1H1(1),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(282),n2h1(340))
  call Hloop_VA_Q(ntryL,G1H2(143),ex3(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(283),n2h1(341))
  call Hloop_QV_A(ntryL,G1H2(144),ex5(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(284),n2h1(342))
  call Hloop_QV_A(ntryL,G1H2(322),ex5(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(285),n2h1(343))
  call Hloop_QV_A(ntryL,G1H2(154),ex5(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(286),n2h1(344))
  call Hloop_QV_A(ntryL,G1H2(155),ex5(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(287),n2h1(345))
  call Hloop_QV_A(ntryL,G1H2(156),ex5(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(288),n2h1(346))
  call Hloop_QV_A(ntryL,G1H2(162),ex5(:),G1H1(1),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(289),n2h1(347))
  call Hloop_VA_Q(ntryL,G1H2(166),ex3(:),G1H1(1),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(290),n2h1(348))
  call Hloop_VA_Q(ntryL,G1H2(167),ex3(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(291),n2h1(349))
  call Hloop_VA_Q(ntryL,G1H2(173),ex3(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(292),n2h1(350))
  call Hloop_AV_Q(ntryL,G1H2(174),ex5(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(293),n2h1(351))
  call Hloop_AV_Q(ntryL,G1H2(178),ex5(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(294),n2h1(352))
  call Hloop_AV_Q(ntryL,G1H2(184),ex5(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(295),n2h1(353))
  call Hloop_VQ_A(ntryL,G1H2(185),ex4(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(296),n2h1(354))
  call Hloop_VQ_A(ntryL,G1H2(186),ex4(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(297),n2h1(355))
  call Hloop_VQ_A(ntryL,G1H2(192),ex4(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(298),n2h1(356))
  call Hloop_QV_A(ntryL,G1H2(196),ex5(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(299),n2h1(357))
  call Hloop_QV_A(ntryL,G1H2(197),ex5(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(300),n2h1(358))
  call Hloop_QV_A(ntryL,G1H2(203),ex5(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(301),n2h1(359))
  call Hloop_VQ_A(ntryL,G1H2(204),ex4(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(302),n2h1(360))
  call Hloop_VQ_A(ntryL,G1H2(208),ex4(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(303),n2h1(361))
  call Hloop_VQ_A(ntryL,G1H2(343),ex4(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(304),n2h1(362))
  call Hloop_QV_A(ntryL,G1H2(215),ex5(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(305),n2h1(363))
  call Hloop_QV_A(ntryL,G1H2(216),ex5(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(306),n2h1(364))
  call Hloop_QV_A(ntryL,G1H2(222),ex5(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(307),n2h1(365))
  call Hloop_VA_Q(ntryL,G1H2(226),ex2(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(308),n2h1(366))
  call Hloop_VA_Q(ntryL,G1H2(227),ex2(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(309),n2h1(367))
  call Hloop_VA_Q(ntryL,G1H2(233),ex2(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(310),n2h1(368))
  call Hloop_VQ_A(ntryL,G1H2(234),ex4(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(311),n2h1(369))
  call Hloop_VQ_A(ntryL,G1H2(353),ex4(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(312),n2h1(370))
  call Hloop_VQ_A(ntryL,G1H2(244),ex4(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(313),n2h1(371))
  call Hloop_QV_A(ntryL,G1H2(245),ex5(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(314),n2h1(372))
  call Hloop_QV_A(ntryL,G1H2(246),ex5(:),G1H1(1),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(315),n2h1(373))
  call Hloop_QV_A(ntryL,G1H2(252),ex5(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(316),n2h1(374))
  call Hloop_VQ_A(ntryL,G1H2(363),ex4(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(317),n2h1(375))
  call Hloop_VQ_A(ntryL,G1H2(257),ex4(:),G1H1(1),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(318),n2h1(376))
  call Hloop_VQ_A(ntryL,G1H2(263),ex4(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(319),n2h1(377))
  call Hloop_QV_A(ntryL,G1H2(264),ex5(:),G1H1(1),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(320),n2h1(378))
  call Hloop_QV_A(ntryL,G1H2(268),ex5(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(321),n2h1(379))
  call Hloop_QV_A(ntryL,G1H2(274),ex5(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(322),n2h1(380))
  call Hloop_VA_Q(ntryL,G1H2(275),ex3(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(323),n2h1(381))
  call Hloop_VA_Q(ntryL,G1H2(276),ex3(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(324),n2h1(382))
  call Hloop_VA_Q(ntryL,G1H2(282),ex3(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(325),n2h1(383))
  call Hloop_AV_Q(ntryL,G1H2(286),ex5(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(326),n2h1(384))
  call Hloop_AV_Q(ntryL,G1H2(287),ex5(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(327),n2h1(385))
  call Hloop_AV_Q(ntryL,G1H2(293),ex5(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(328),n2h1(386))
  call Hloop_QV_A(ntryL,G1H4(54),wf4(:,1),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(329),n2h1(387))
  call Hloop_QV_A(ntryL,G1H4(60),wf4(:,1),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,231))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(330),n2h1(388))
  call Hloop_QV_A(ntryL,G1H4(31),wf4(:,1),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(331),n2h1(389))
  call Hloop_AV_Q(ntryL,G1H4(67),wf4(:,1),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(332),n2h1(390))
  call Hloop_AV_Q(ntryL,G1H4(32),wf4(:,1),G1H1(1),m3h4x1(:,57),heltab2x4(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,0,G2tensor(333),n2h1(391))
  call Hloop_AV_Q(ntryL,G1H4(71),wf4(:,1),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(334),n2h1(392))
  call Hloop_VA_Q(ntryL,G1H2(294),ex2(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(335),n2h1(393))
  call Hloop_VA_Q(ntryL,G1H2(298),ex2(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(336),n2h1(394))
  call Hloop_VA_Q(ntryL,G1H2(304),ex2(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(337),n2h1(395))
  call Hloop_AV_Q(ntryL,G1H2(305),ex5(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(338),n2h1(396))
  call Hloop_AV_Q(ntryL,G1H2(306),ex5(:),G1H1(1),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(339),n2h1(397))
  call Hloop_AV_Q(ntryL,G1H2(312),ex5(:),G1H1(1),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(340),n2h1(398))
  call Hloop_QV_A(ntryL,G1H2(316),ex5(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(341),n2h1(399))
  call Hloop_QV_A(ntryL,G1H2(318),ex5(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(342),n2h1(400))
  call Hloop_QV_A(ntryL,G1H2(328),ex5(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(343),n2h1(401))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,6),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(344),n2h1(402))
  call Hloop_QV_A(ntryL,G1H4(73),wf4(:,6),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(345),n2h1(403))
  call Hloop_QV_A(ntryL,G1H4(78),wf4(:,6),G1H1(1),m3h4x1(:,61),heltab2x4(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(346),n2h1(404))
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,6),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(347),n2h1(405))
  call Hloop_QV_A(ntryL,G1H4(36),wf4(:,6),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(348),n2h1(406))
  call Hloop_QV_A(ntryL,G1H4(51),wf4(:,6),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(349),n2h1(407))
  call Hloop_AV_Q(ntryL,G1H4(26),wf4(:,6),G1H1(1),m3h4x1(:,65),heltab2x4(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(350),n2h1(408))
  call Hloop_AV_Q(ntryL,G1H4(6),wf4(:,6),G1H1(1),m3h4x1(:,66),heltab2x4(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(351),n2h1(409))
  call Hloop_AV_Q(ntryL,G1H4(48),wf4(:,6),G1H1(1),m3h4x1(:,67),heltab2x4(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(352),n2h1(410))
  call Hloop_VQ_A(ntryL,G1H2(333),ex4(:),G1H1(1),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(353),n2h1(411))
  call Hloop_VQ_A(ntryL,G1H2(334),ex4(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(354),n2h1(412))
  call Hloop_VQ_A(ntryL,G1H2(349),ex4(:),G1H1(1),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(355),n2h1(413))
  call Hloop_VQ_A(ntryL,G1H2(354),ex4(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(356),n2h1(414))
  call Hloop_VQ_A(ntryL,G1H2(359),ex4(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(357),n2h1(415))
  call Hloop_VQ_A(ntryL,G1H2(369),ex4(:),G1H1(1),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(358),n2h1(416))
  call Hloop_AV_Q(ntryL,G1H2(374),ex5(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(359),n2h1(417))
  call Hloop_AV_Q(ntryL,G1H2(375),ex5(:),G1H1(1),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(360),n2h1(418))
  call Hloop_AV_Q(ntryL,G1H2(385),ex5(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(361),n2h1(419))
  call Hloop_AV_Q(ntryL,G1H2(386),ex5(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(362),n2h1(420))
  call Hloop_AV_Q(ntryL,G1H2(391),ex5(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(363),n2h1(421))
  call Hloop_AV_Q(ntryL,G1H2(401),ex5(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(364),n2h1(422))
  call Hloop_AV_Q(ntryL,G1H2(402),ex5(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(365),n2h1(423))
  call Hloop_AV_Q(ntryL,G1H2(406),ex5(:),G1H1(1),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(366),n2h1(424))
  call Hloop_AV_Q(ntryL,G1H2(413),ex5(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(367),n2h1(425))
  call Hloop_AV_Q(ntryL,G1H2(418),ex5(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(368),n2h1(426))
  call Hloop_AV_Q(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(369),n2h1(427))
  call Hloop_AV_Q(ntryL,G1H2(148),ex5(:),G1H1(1),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(370),n2h1(428))
  call Hloop_VQ_A(ntryL,G1H2(202),ex4(:),G1H1(1),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(371),n2h1(429))
  call Hloop_VQ_A(ntryL,G1H2(214),ex4(:),G1H1(1),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(372),n2h1(430))
  call Hloop_VQ_A(ntryL,G1H2(250),ex4(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(373),n2h1(431))
  call Hloop_VQ_A(ntryL,G1H2(256),ex4(:),G1H1(1),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(374),n2h1(432))
  call Hloop_VQ_A(ntryL,G1H2(332),ex4(:),G1H1(1),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(375),n2h1(433))
  call Hloop_VQ_A(ntryL,G1H2(400),ex4(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(376),n2h1(434))
  call Hloop_VQ_A(ntryL,G1H2(411),ex4(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(377),n2h1(435))
  call Hloop_VQ_A(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(378),n2h1(436))
  call Hloop_VQ_A(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(379),n2h1(437))
  call Hloop_VQ_A(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(380),n2h1(438))
  call Hloop_VQ_A(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(381),n2h1(439))
  call Hloop_VQ_A(ntryL,G1H2(61),ex4(:),G1H1(1),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(382),n2h1(440))
  call Hloop_AV_Q(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(383),n2h1(441))
  call Hloop_AV_Q(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(384),n2h1(442))
  call Hloop_AV_Q(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(385),n2h1(443))
  call Hloop_AV_Q(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(386),n2h1(444))
  call Hloop_AV_Q(ntryL,G1H2(390),ex5(:),G1H1(1),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(387),n2h1(445))
  call Hloop_AV_Q(ntryL,G1H2(64),ex5(:),G1H1(1),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(388),n2h1(446))
  call Hloop_AV_Q(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(389),n2h1(447))
  call Hloop_AV_Q(ntryL,G1H2(76),ex5(:),G1H1(1),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(390),n2h1(448))
  call Hloop_AV_Q(ntryL,G1H2(83),ex5(:),G1H1(1),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(391),n2h1(449))
  call Hloop_QV_A(ntryL,G1H2(88),ex5(:),G1H1(1),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(392),n2h1(450))
  call Hloop_QV_A(ntryL,G1H2(89),ex5(:),G1H1(1),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(393),n2h1(451))
  call Hloop_QV_A(ntryL,G1H2(96),ex5(:),G1H1(1),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(394),n2h1(452))
  call Hloop_QV_A(ntryL,G1H2(100),ex5(:),G1H1(1),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(395),n2h1(453))
  call Hloop_QV_A(ntryL,G1H2(102),ex5(:),G1H1(1),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(396),n2h1(454))
  call Hloop_QV_A(ntryL,G1H2(112),ex5(:),G1H1(1),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(397),n2h1(455))
  call Hloop_AV_Q(ntryL,G1H2(113),ex5(:),G1H1(1),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(398),n2h1(456))
  call Hloop_AV_Q(ntryL,G1H2(129),ex5(:),G1H1(1),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(399),n2h1(457))
  call Hloop_AV_Q(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(400),n2h1(458))
  call Hloop_AV_Q(ntryL,G1H2(331),ex5(:),G1H1(1),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(401),n2h1(459))
  call Hloop_AV_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(402),n2h1(460))
  call Hloop_AV_Q(ntryL,G1H2(289),ex5(:),G1H1(1),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(403),n2h1(461))
  call Hloop_AV_Q(ntryL,G1H2(259),ex5(:),G1H1(1),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(404),n2h1(462))
  call Hloop_AV_Q(ntryL,G1H2(265),ex5(:),G1H1(1),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(405),n2h1(463))
  call Hloop_AV_Q(ntryL,G1H2(237),ex5(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(406),n2h1(464))
  call Hloop_QV_A(ntryL,G1H2(201),ex5(:),G1H1(1),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(407),n2h1(465))
  call Hloop_QV_A(ntryL,G1H2(87),ex5(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(408),n2h1(466))
  call Hloop_QV_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(409),n2h1(467))
  call Hloop_QV_A(ntryL,G1H2(213),ex5(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(410),n2h1(468))
  call Hloop_QV_A(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(411),n2h1(469))
  call Hloop_QV_A(ntryL,G1H2(383),ex5(:),G1H1(1),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(412),n2h1(470))
  call Hloop_VA_Q(ntryL,G1H4(42),wf4(:,8),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(413),n2h1(471))
  call Hloop_VA_Q(ntryL,G1H4(21),wf4(:,8),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(414),n2h1(472))
  call Hloop_VA_Q(ntryL,G1H4(65),wf4(:,8),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(415),n2h1(473))
  call Hloop_VA_Q(ntryL,G1H4(59),wf4(:,3),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(416),n2h1(474))
  call Hloop_VA_Q(ntryL,G1H4(50),wf4(:,3),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,249))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(417),n2h1(475))
  call Hloop_VA_Q(ntryL,G1H4(70),wf4(:,3),G1H1(1),m3h4x1(:,73),heltab2x4(:,:,250))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(418),n2h1(476))
  call Hloop_VQ_A(ntryL,G1H4(35),wf4(:,5),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(419),n2h1(477))
  call Hloop_VQ_A(ntryL,G1H4(10),wf4(:,5),G1H1(1),m3h4x1(:,75),heltab2x4(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(420),n2h1(478))
  call Hloop_VQ_A(ntryL,G1H4(77),wf4(:,5),G1H1(1),m3h4x1(:,76),heltab2x4(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(421),n2h1(479))
  call Hloop_VQ_A(ntryL,G1H4(8),wf4(:,5),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(422),n2h1(480))
  call Hloop_VQ_A(ntryL,G1H4(9),wf4(:,5),G1H1(1),m3h4x1(:,78),heltab2x4(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(423),n2h1(481))
  call Hloop_VQ_A(ntryL,G1H4(17),wf4(:,5),G1H1(1),m3h4x1(:,79),heltab2x4(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(424),n2h1(482))
  call Hloop_VQ_A(ntryL,G1H4(25),wf4(:,5),G1H1(1),m3h4x1(:,80),heltab2x4(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(425),n2h1(483))
  call Hloop_VQ_A(ntryL,G1H4(23),wf4(:,5),G1H1(1),m3h4x1(:,81),heltab2x4(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(426),n2h1(484))
  call Hloop_VQ_A(ntryL,G1H4(55),wf4(:,5),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(427),n2h1(485))
  call Hloop_VQ_A(ntryL,G1H4(44),wf4(:,5),G1H1(1),m3h4x1(:,83),heltab2x4(:,:,260))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(428),n2h1(486))
  call Hloop_VQ_A(ntryL,G1H4(56),wf4(:,5),G1H1(1),m3h4x1(:,84),heltab2x4(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(429),n2h1(487))
  call Hloop_VQ_A(ntryL,G1H4(40),wf4(:,5),G1H1(1),m3h4x1(:,85),heltab2x4(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(430),n2h1(488))
  call Hloop_VA_Q(ntryL,G1H2(219),ex3(:),G1H1(1),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(431),n2h1(489))
  call Hloop_VA_Q(ntryL,G1H2(99),ex3(:),G1H1(1),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(432),n2h1(490))
  call Hloop_VA_Q(ntryL,G1H2(105),ex3(:),G1H1(1),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(433),n2h1(491))
  call Hloop_VA_Q(ntryL,G1H2(70),ex3(:),G1H1(1),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(434),n2h1(492))
  call Hloop_VA_Q(ntryL,G1H2(249),ex3(:),G1H1(1),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(435),n2h1(493))
  call Hloop_VA_Q(ntryL,G1H2(58),ex3(:),G1H1(1),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(436),n2h1(494))
  call Hloop_AV_Q(ntryL,G1H2(410),ex5(:),G1H1(1),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(437),n2h1(495))
  call Hloop_AV_Q(ntryL,G1H2(255),ex5(:),G1H1(1),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(438),n2h1(496))
  call Hloop_AV_Q(ntryL,G1H2(372),ex5(:),G1H1(1),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(439),n2h1(497))
  call Hloop_QV_A(ntryL,G1H2(399),ex5(:),G1H1(1),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(440),n2h1(498))
  call Hloop_QV_A(ntryL,G1H2(211),ex5(:),G1H1(1),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(441),n2h1(499))
  call Hloop_QV_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(442),n2h1(500))
  call Hloop_QV_A(ntryL,G1H2(183),ex5(:),G1H1(1),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(443),n2h1(501))
  call Hloop_QV_A(ntryL,G1H2(135),ex5(:),G1H1(1),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(444),n2h1(502))
  call Hloop_QV_A(ntryL,G1H2(141),ex5(:),G1H1(1),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(445),n2h1(503))
  call Hloop_AV_Q(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(446),n2h1(504))
  call Hloop_AV_Q(ntryL,G1H2(171),ex5(:),G1H1(1),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(447),n2h1(505))
  call Hloop_AV_Q(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(448),n2h1(506))
  call Hloop_QV_A(ntryL,G1H4(63),wf4(:,6),G1H1(1),m3h4x1(:,86),heltab2x4(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(449),n2h1(507))
  call Hloop_QV_A(ntryL,G1H4(28),wf4(:,6),G1H1(1),m3h4x1(:,87),heltab2x4(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(450),n2h1(508))
  call Hloop_QV_A(ntryL,G1H4(75),wf4(:,6),G1H1(1),m3h4x1(:,88),heltab2x4(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(451),n2h1(509))
  call Hloop_QV_A(ntryL,G1H4(76),wf4(:,6),G1H1(1),m3h4x1(:,89),heltab2x4(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(452),n2h1(510))
  call Hloop_QV_A(ntryL,G1H4(64),wf4(:,6),G1H1(1),m3h4x1(:,90),heltab2x4(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(453),n2h1(511))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,6),G1H1(1),m3h4x1(:,91),heltab2x4(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(454),n2h1(512))
  call Hloop_QV_A(ntryL,G1H2(159),ex5(:),G1H1(1),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(455),n2h1(513))
  call Hloop_QV_A(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(456),n2h1(514))
  call Hloop_QV_A(ntryL,G1H2(177),ex5(:),G1H1(1),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(457),n2h1(515))
  call Hloop_QV_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(458),n2h1(516))
  call Hloop_QV_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(459),n2h1(517))
  call Hloop_QV_A(ntryL,G1H2(195),ex5(:),G1H1(1),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(460),n2h1(518))
  call Hloop_VA_Q(ntryL,G1H4(52),wf4(:,3),G1H1(1),m3h4x1(:,92),heltab2x4(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(461),n2h1(519))
  call Hloop_VA_Q(ntryL,G1H4(47),wf4(:,3),G1H1(1),m3h4x1(:,93),heltab2x4(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(462),n2h1(520))
  call Hloop_VA_Q(ntryL,G1H4(57),wf4(:,3),G1H1(1),m3h4x1(:,94),heltab2x4(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(463),n2h1(521))
  call Hloop_VA_Q(ntryL,G1H4(45),wf4(:,8),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(464),n2h1(522))
  call Hloop_VA_Q(ntryL,G1H4(24),wf4(:,8),G1H1(1),m3h4x1(:,96),heltab2x4(:,:,273))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,0,G2tensor(465),n2h1(523))
  call Hloop_VA_Q(ntryL,G1H4(81),wf4(:,8),G1H1(1),m3h4x1(:,97),heltab2x4(:,:,274))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(466),n2h1(524))
  call Hloop_AV_Q(ntryL,G1H4(82),wf4(:,6),G1H1(1),m3h4x1(:,98),heltab2x4(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(467),n2h1(525))
  call Hloop_AV_Q(ntryL,G1H4(83),wf4(:,6),G1H1(1),m3h4x1(:,99),heltab2x4(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(468),n2h1(526))
  call Hloop_AV_Q(ntryL,G1H4(86),wf4(:,6),G1H1(1),m3h4x1(:,100),heltab2x4(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(469),n2h1(527))
  call Hloop_QV_A(ntryL,G1H8(5),wf8(:,10),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(470),n2h1(528))
  call Hloop_QV_A(ntryL,G1H8(15),wf8(:,10),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(471),n2h1(529))
  call Hloop_QV_A(ntryL,G1H8(18),wf8(:,10),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(472),n2h1(530))
  call Hloop_AV_Q(ntryL,G1H8(22),wf8(:,10),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(473),n2h1(531))
  call Hloop_AV_Q(ntryL,G1H8(6),wf8(:,10),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(474),n2h1(532))
  call Hloop_AV_Q(ntryL,G1H8(35),wf8(:,10),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(475),n2h1(533))
  call Hloop_QV_A(ntryL,G1H8(16),wf8(:,9),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(476),n2h1(534))
  call Hloop_QV_A(ntryL,G1H8(19),wf8(:,9),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,0,G2tensor(477),n2h1(535))
  call Hloop_QV_A(ntryL,G1H8(12),wf8(:,9),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(478),n2h1(536))
  call Hloop_AV_Q(ntryL,G1H8(24),wf8(:,9),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(479),n2h1(537))
  call Hloop_AV_Q(ntryL,G1H8(1),wf8(:,9),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),21,0,G2tensor(480),n2h1(538))
  call Hloop_AV_Q(ntryL,G1H8(14),wf8(:,9),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(481),n2h1(539))
  call Hloop_QV_A(ntryL,G1H8(10),wf8(:,11),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(482),n2h1(540))
  call Hloop_QV_A(ntryL,G1H8(21),wf8(:,11),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(483),n2h1(541))
  call Hloop_QV_A(ntryL,G1H8(3),wf8(:,11),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(484),n2h1(542))
  call Hloop_AV_Q(ntryL,G1H8(4),wf8(:,11),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(485),n2h1(543))
  call Hloop_AV_Q(ntryL,G1H8(2),wf8(:,11),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(486),n2h1(544))
  call Hloop_AV_Q(ntryL,G1H8(33),wf8(:,11),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(487),n2h1(545))
  call Hloop_QV_A(ntryL,G1H8(34),wf8(:,12),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(488),n2h1(546))
  call Hloop_QV_A(ntryL,G1H8(36),wf8(:,12),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,0,G2tensor(489),n2h1(547))
  call Hloop_QV_A(ntryL,G1H8(39),wf8(:,12),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(490),n2h1(548))
  call Hloop_AV_Q(ntryL,G1H8(11),wf8(:,12),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(491),n2h1(549))
  call Hloop_AV_Q(ntryL,G1H8(25),wf8(:,12),G1H1(1),m3h8x1(:,23),heltab2x8(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),21,0,G2tensor(492),n2h1(550))
  call Hloop_AV_Q(ntryL,G1H8(42),wf8(:,12),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(493),n2h1(551))
  call ol_merge_tensors(G2tensor(261),[G2tensor(123),G2tensor(113),G2tensor(19),G2tensor(3),G1tensor(339),G1tensor(168) &
    ,G1tensor(92),G1tensor(31)])
  call ol_merge_tensors(G2tensor(259),[G2tensor(114),G2tensor(131),G2tensor(25),G2tensor(7),G1tensor(327),G1tensor(216) &
    ,G1tensor(116),G1tensor(67)])
  call ol_merge_tensors(G2tensor(256),[G2tensor(28),G2tensor(11),G1tensor(140),G1tensor(32)])
  call ol_merge_tensors(G2tensor(257),[G2tensor(31),G2tensor(15),G1tensor(158),G1tensor(68)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(56),G2tensor(21),G1tensor(348),G1tensor(258),G1tensor(96)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(44),G2tensor(26),G1tensor(354),G1tensor(210),G1tensor(120)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(68),G2tensor(29),G1tensor(360),G1tensor(294),G1tensor(144)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(77),G2tensor(32),G1tensor(366),G1tensor(318),G1tensor(162)])
  call ol_merge_tensors(G2tensor(178),[G2tensor(34),G1tensor(338),G1tensor(4)])
  call ol_merge_tensors(G2tensor(350),[G2tensor(37),G2tensor(35),G1tensor(182),G1tensor(10)])
  call ol_merge_tensors(G2tensor(491),[G2tensor(479),G2tensor(179),G2tensor(38),G1tensor(342),G1tensor(186)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(184),G2tensor(130),G2tensor(40),G1tensor(350),G1tensor(212),G1tensor(23) &
    ,G1tensor(12)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(41),G1tensor(206),G1tensor(17)])
  call ol_merge_tensors(G2tensor(172),[G2tensor(46),G1tensor(326),G1tensor(21)])
  call ol_merge_tensors(G2tensor(332),[G2tensor(49),G2tensor(47),G1tensor(230),G1tensor(28)])
  call ol_merge_tensors(G2tensor(485),[G2tensor(473),G2tensor(173),G2tensor(50),G1tensor(330),G1tensor(234)])
  call ol_merge_tensors(G2tensor(262),[G2tensor(24),G2tensor(181),G2tensor(112),G2tensor(52),G1tensor(344),G1tensor(164) &
    ,G1tensor(29),G1tensor(5)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(53),G1tensor(254),G1tensor(59)])
  call ol_merge_tensors(G2tensor(175),[G2tensor(58),G1tensor(332),G1tensor(36)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(61),G2tensor(59),G1tensor(272),G1tensor(70),G1tensor(41)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(170),G2tensor(62),G1tensor(336),G1tensor(324),G1tensor(276)])
  call ol_merge_tensors(G2tensor(187),[G2tensor(64),G1tensor(356),G1tensor(45)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(65),G1tensor(290),G1tensor(48)])
  call ol_merge_tensors(G2tensor(169),[G2tensor(70),G1tensor(320),G1tensor(52)])
  call ol_merge_tensors(G2tensor(190),[G2tensor(73),G1tensor(362),G1tensor(60)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(74),G1tensor(314),G1tensor(72)])
  call ol_merge_tensors(G2tensor(269),[G2tensor(199),G2tensor(79),G1tensor(380),G1tensor(74),G1tensor(13)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(263),[G2tensor(82),G1tensor(80),G1tensor(19)])
  call ol_merge_tensors(G2tensor(205),[G2tensor(83),G1tensor(390),G1tensor(84)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(2),G2tensor(85),G1tensor(371),G1tensor(86),G1tensor(25)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(90)])
  call ol_merge_tensors(G2tensor(271),[G2tensor(196),G2tensor(88),G1tensor(374),G1tensor(98),G1tensor(49)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(102)])
  call ol_merge_tensors(G2tensor(265),[G2tensor(91),G1tensor(104),G1tensor(55)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(108)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(94),G1tensor(110),G1tensor(61)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(114)])
  call ol_merge_tensors(G2tensor(251),[G2tensor(193),G2tensor(97),G1tensor(368),G1tensor(122),G1tensor(14)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(126)])
  call ol_merge_tensors(G2tensor(252),[G2tensor(100),G1tensor(128),G1tensor(56),G1tensor(20)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(132)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(103),G1tensor(134),G1tensor(26)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(138)])
  call ol_merge_tensors(G2tensor(253),[G2tensor(106),G1tensor(146),G1tensor(50)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(150)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(109),G1tensor(152),G1tensor(62)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(156)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(115),G1tensor(170),G1tensor(6)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(116),G1tensor(340),G1tensor(174)])
  call ol_merge_tensors(G2tensor(290),[G2tensor(118),G1tensor(176),G1tensor(65),G1tensor(9)])
  call ol_merge_tensors(G2tensor(416),[G2tensor(119),G1tensor(341),G1tensor(335),G1tensor(180)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(121),G1tensor(188),G1tensor(15)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(122),G1tensor(351),G1tensor(192)])
  call ol_merge_tensors(G2tensor(296),[G2tensor(124),G1tensor(194),G1tensor(22)])
  call ol_merge_tensors(G2tensor(425),[G2tensor(125),G1tensor(352),G1tensor(198)])
  call ol_merge_tensors(G2tensor(302),[G2tensor(127),G1tensor(200),G1tensor(47),G1tensor(16)])
  call ol_merge_tensors(G2tensor(428),[G2tensor(128),G1tensor(359),G1tensor(353),G1tensor(204)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(133),G1tensor(218),G1tensor(24)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(134),G1tensor(328),G1tensor(222)])
  call ol_merge_tensors(G2tensor(308),[G2tensor(136),G1tensor(224),G1tensor(57),G1tensor(27)])
  call ol_merge_tensors(G2tensor(413),[G2tensor(137),G1tensor(329),G1tensor(323),G1tensor(228)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(139),G1tensor(236),G1tensor(30)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(140),G1tensor(345),G1tensor(240)])
  call ol_merge_tensors(G2tensor(311),[G2tensor(142),G1tensor(242),G1tensor(33)])
  call ol_merge_tensors(G2tensor(419),[G2tensor(143),G1tensor(346),G1tensor(246)])
  call ol_merge_tensors(G2tensor(317),[G2tensor(145),G1tensor(248),G1tensor(69),G1tensor(34)])
  call ol_merge_tensors(G2tensor(422),[G2tensor(146),G1tensor(365),G1tensor(347),G1tensor(252)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(148),G1tensor(260),G1tensor(39)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(149),G1tensor(333),G1tensor(264)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(151),G1tensor(266),G1tensor(40)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(152),G1tensor(334),G1tensor(270)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(154),G1tensor(278),G1tensor(46)])
  call ol_merge_tensors(G2tensor(132),[G2tensor(155),G1tensor(357),G1tensor(282)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(157),G1tensor(284),G1tensor(64),G1tensor(71)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(158),G1tensor(364),G1tensor(358),G1tensor(288)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(160),G1tensor(296),G1tensor(66)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(161),G1tensor(321),G1tensor(300)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(163),G1tensor(302),G1tensor(54)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(164),G1tensor(322),G1tensor(306)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(166),G1tensor(308),G1tensor(63)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(167),G1tensor(363),G1tensor(312)])
  call ol_merge_tensors(G2tensor(467),[G2tensor(194),G1tensor(372)])
  call ol_merge_tensors(G2tensor(200),[G2tensor(197),G1tensor(384),G1tensor(378)])
  call ol_merge_tensors(G2tensor(267),[G2tensor(204),G1tensor(386)])
  call ol_merge_tensors(G2tensor(323),[G2tensor(214),G1tensor(392)])
  call ol_merge_tensors(G2tensor(461),[G2tensor(215),G1tensor(396)])
  call ol_merge_tensors(G2tensor(329),[G2tensor(218),G1tensor(398)])
  call ol_merge_tensors(G2tensor(482),[G2tensor(470),G2tensor(219),G1tensor(402)])
  call ol_merge_tensors(G2tensor(335),[G2tensor(223),G1tensor(404)])
  call ol_merge_tensors(G2tensor(464),[G2tensor(224),G1tensor(408)])
  call ol_merge_tensors(G2tensor(341),[G2tensor(227),G1tensor(410),G1tensor(195),G1tensor(189)])
  call ol_merge_tensors(G2tensor(488),[G2tensor(476),G2tensor(232),G2tensor(228),G1tensor(420),G1tensor(414)])
  call ol_merge_tensors(G2tensor(347),[G2tensor(231),G1tensor(416)])
  call ol_merge_tensors(G2tensor(284),[G1tensor(7)])
  call ol_merge_tensors(G2tensor(287),[G1tensor(43)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(303),G1tensor(297),G1tensor(8)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(267),G1tensor(261),G1tensor(44)])
  call ol_merge_tensors(G2tensor(371),[G1tensor(81),G1tensor(75)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(87),G1tensor(76)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(93),G1tensor(77)])
  call ol_merge_tensors(G2tensor(374),[G1tensor(88),G1tensor(82)])
  call ol_merge_tensors(G2tensor(275),[G1tensor(94),G1tensor(83)])
  call ol_merge_tensors(G2tensor(353),[G1tensor(161),G1tensor(155),G1tensor(95),G1tensor(89)])
  call ol_merge_tensors(G2tensor(377),[G1tensor(105),G1tensor(99)])
  call ol_merge_tensors(G2tensor(96),[G1tensor(111),G1tensor(100)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(117),G1tensor(101)])
  call ol_merge_tensors(G2tensor(380),[G1tensor(112),G1tensor(106)])
  call ol_merge_tensors(G2tensor(278),[G1tensor(118),G1tensor(107)])
  call ol_merge_tensors(G2tensor(356),[G1tensor(143),G1tensor(137),G1tensor(119),G1tensor(113)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(147),G1tensor(129),G1tensor(123)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(135),G1tensor(124)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(141),G1tensor(125)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(154),G1tensor(136),G1tensor(130)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(160),G1tensor(142),G1tensor(131)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(153),G1tensor(148)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(159),G1tensor(149)])
  call ol_merge_tensors(G2tensor(383),[G1tensor(171),G1tensor(165)])
  call ol_merge_tensors(G2tensor(386),[G1tensor(262),G1tensor(177),G1tensor(166)])
  call ol_merge_tensors(G2tensor(359),[G1tensor(183),G1tensor(167)])
  call ol_merge_tensors(G2tensor(389),[G1tensor(394),G1tensor(268),G1tensor(178),G1tensor(172)])
  call ol_merge_tensors(G2tensor(458),[G2tensor(362),G1tensor(418),G1tensor(184),G1tensor(173)])
  call ol_merge_tensors(G2tensor(293),[G1tensor(275),G1tensor(233),G1tensor(227),G1tensor(185),G1tensor(179)])
  call ol_merge_tensors(G2tensor(392),[G1tensor(280),G1tensor(201),G1tensor(190)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(207),G1tensor(191)])
  call ol_merge_tensors(G2tensor(395),[G1tensor(286),G1tensor(250),G1tensor(244),G1tensor(202),G1tensor(196)])
  call ol_merge_tensors(G2tensor(338),[G2tensor(299),G1tensor(407),G1tensor(208),G1tensor(197)])
  call ol_merge_tensors(G2tensor(305),[G1tensor(401),G1tensor(293),G1tensor(209),G1tensor(203)])
  call ol_merge_tensors(G2tensor(398),[G1tensor(219),G1tensor(213)])
  call ol_merge_tensors(G2tensor(401),[G1tensor(298),G1tensor(225),G1tensor(214)])
  call ol_merge_tensors(G2tensor(365),[G1tensor(231),G1tensor(215)])
  call ol_merge_tensors(G2tensor(404),[G1tensor(406),G1tensor(304),G1tensor(226),G1tensor(220)])
  call ol_merge_tensors(G2tensor(443),[G2tensor(368),G1tensor(400),G1tensor(232),G1tensor(221)])
  call ol_merge_tensors(G2tensor(407),[G1tensor(243),G1tensor(237)])
  call ol_merge_tensors(G2tensor(410),[G1tensor(310),G1tensor(249),G1tensor(238)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(255),G1tensor(239)])
  call ol_merge_tensors(G2tensor(326),[G2tensor(314),G1tensor(395),G1tensor(256),G1tensor(245)])
  call ol_merge_tensors(G2tensor(320),[G1tensor(419),G1tensor(317),G1tensor(257),G1tensor(251)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(299),G1tensor(273),G1tensor(263)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(305),G1tensor(274),G1tensor(269)])
  call ol_merge_tensors(G2tensor(108),[G1tensor(309),G1tensor(285),G1tensor(279)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(291),G1tensor(281)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(316),G1tensor(292),G1tensor(287)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(315),G1tensor(311)])
  call ol_merge_tensors(G2tensor(138),[G1tensor(369)])
  call ol_merge_tensors(G2tensor(141),[G1tensor(370)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(375)])
  call ol_merge_tensors(G2tensor(147),[G1tensor(376)])
  call ol_merge_tensors(G2tensor(150),[G1tensor(377)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(381)])
  call ol_merge_tensors(G2tensor(153),[G1tensor(382)])
  call ol_merge_tensors(G2tensor(156),[G1tensor(383)])
  call ol_merge_tensors(G2tensor(431),[G1tensor(387)])
  call ol_merge_tensors(G2tensor(434),[G1tensor(388)])
  call ol_merge_tensors(G2tensor(281),[G1tensor(389)])
  call ol_merge_tensors(G2tensor(437),[G1tensor(393)])
  call ol_merge_tensors(G2tensor(440),[G1tensor(399)])
  call ol_merge_tensors(G2tensor(446),[G1tensor(405)])
  call ol_merge_tensors(G2tensor(449),[G1tensor(411)])
  call ol_merge_tensors(G2tensor(452),[G1tensor(412)])
  call ol_merge_tensors(G2tensor(344),[G1tensor(413)])
  call ol_merge_tensors(G2tensor(455),[G1tensor(417)])
  call Hotf_4pt_reduction_last(G2tensor(261),RedSet_4(57),mass4set(:,1),  & 
G1tensor(1),G1tensor(37),G1tensor(2),G1tensor(38),G1tensor(3))
  call G_TensorShift(G1tensor(37),20)
  call Hotf_4pt_reduction_last(G2tensor(259),RedSet_4(86),mass4set(:,1),  & 
G1tensor(11),G1tensor(18),G1tensor(53),G1tensor(35),G1tensor(42))
  call G_TensorShift(G1tensor(18),18)
  call Hotf_4pt_reduction_last(G2tensor(256),RedSet_4(151),mass4set(:,1),  & 
G1tensor(51),G1tensor(58),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(58),17)
  call Hotf_4pt_reduction_last(G2tensor(257),RedSet_4(154),mass4set(:,1),  & 
G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109),G1tensor(115))
  call G_TensorShift(G1tensor(97),17)
  call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(13),mass4set(:,1),  & 
G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139),G1tensor(145))
  call G_TensorShift(G1tensor(127),28)
  call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(28),mass4set(:,1),  & 
G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(157),26)
  call Hotf_4pt_reduction_last(G2tensor(188),RedSet_4(42),mass4set(:,1),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205))
  call G_TensorShift(G1tensor(187),25)
  call Hotf_4pt_reduction_last(G2tensor(191),RedSet_4(51),mass4set(:,1),  & 
G1tensor(211),G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235))
  call G_TensorShift(G1tensor(217),25)
  call Hotf_4pt_reduction_last(G2tensor(178),RedSet_4(215),mass4set(:,1),  & 
G1tensor(241),G1tensor(247),G1tensor(253),G1tensor(259),G1tensor(265))
  call G_TensorShift(G1tensor(247),1)
  call Hotf_4pt_reduction_last(G2tensor(350),RedSet_4(158),mass4set(:,1),  & 
G1tensor(271),G1tensor(277),G1tensor(283),G1tensor(289),G1tensor(295))
  call G_TensorShift(G1tensor(277),5)
  call Hotf_4pt_reduction_last(G2tensor(491),RedSet_4(66),mass4set(:,1),  & 
G1tensor(301),G1tensor(307),G1tensor(313),G1tensor(319),G1tensor(325))
  call G_TensorShift(G1tensor(307),21)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(163),mass4set(:,1),  & 
G1tensor(331),G1tensor(337),G1tensor(343),G1tensor(349),G1tensor(355))
  call G_TensorShift(G1tensor(337),2)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(162),mass4set(:,1),  & 
G1tensor(361),G1tensor(367),G1tensor(373),G1tensor(379),G1tensor(385))
  call G_TensorShift(G1tensor(367),10)
  call Hotf_4pt_reduction_last(G2tensor(172),RedSet_4(216),mass4set(:,1),  & 
G1tensor(391),G1tensor(397),G1tensor(403),G1tensor(409),G1tensor(415))
  call G_TensorShift(G1tensor(397),1)
  call Hotf_4pt_reduction_last(G2tensor(332),RedSet_4(166),mass4set(:,1),  & 
G1tensor(339),G1tensor(168),G1tensor(92),G1tensor(31),G1tensor(327))
  call G_TensorShift(G1tensor(168),3)
  call Hotf_4pt_reduction_last(G2tensor(485),RedSet_4(93),mass4set(:,1),  & 
G1tensor(216),G1tensor(116),G1tensor(67),G1tensor(140),G1tensor(32))
  call G_TensorShift(G1tensor(116),19)
  call Hotf_4pt_reduction_last(G2tensor(262),RedSet_4(155),mass4set(:,1),  & 
G1tensor(158),G1tensor(68),G1tensor(348),G1tensor(258),G1tensor(96))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(170),mass4set(:,1),  & 
G1tensor(354),G1tensor(210),G1tensor(120),G1tensor(360),G1tensor(294))
  call G_TensorShift(G1tensor(210),12)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(217),mass4set(:,1),  & 
G1tensor(144),G1tensor(366),G1tensor(318),G1tensor(162),G1tensor(338))
  call G_TensorShift(G1tensor(366),2)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(173),mass4set(:,1),  & 
G1tensor(4),G1tensor(182),G1tensor(10),G1tensor(342),G1tensor(186))
  call G_TensorShift(G1tensor(182),6)
  call Hotf_4pt_reduction_last(G2tensor(176),RedSet_4(115),mass4set(:,1),  & 
G1tensor(350),G1tensor(212),G1tensor(23),G1tensor(12),G1tensor(206))
  call G_TensorShift(G1tensor(212),22)
  call Hotf_4pt_reduction_last(G2tensor(187),RedSet_4(218),mass4set(:,1),  & 
G1tensor(17),G1tensor(326),G1tensor(21),G1tensor(230),G1tensor(28))
  call G_TensorShift(G1tensor(326),1)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(176),mass4set(:,1),  & 
G1tensor(330),G1tensor(234),G1tensor(344),G1tensor(164),G1tensor(29))
  call G_TensorShift(G1tensor(234),9)
  call Hotf_4pt_reduction_last(G2tensor(169),RedSet_4(219),mass4set(:,1),  & 
G1tensor(5),G1tensor(254),G1tensor(59),G1tensor(332),G1tensor(36))
  call G_TensorShift(G1tensor(254),4)
  call Hotf_4pt_reduction_last(G2tensor(190),RedSet_4(220),mass4set(:,1),  & 
G1tensor(272),G1tensor(70),G1tensor(41),G1tensor(336),G1tensor(324))
  call G_TensorShift(G1tensor(70),1)
  call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(180),mass4set(:,1),  & 
G1tensor(276),G1tensor(356),G1tensor(45),G1tensor(290),G1tensor(48))
  call G_TensorShift(G1tensor(356),9)
  call Hotf_4pt_reduction_last(G2tensor(269),RedSet_4(142),mass4set(:,1),  & 
G1tensor(320),G1tensor(52),G1tensor(362),G1tensor(60),G1tensor(314))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(4),mass4set(:,1),  & 
G1tensor(72),G1tensor(380),G1tensor(74),G1tensor(13),G1tensor(78))
  call G_TensorShift(G1tensor(380),12)
  call Hotf_4pt_reduction_last(G2tensor(263),RedSet_4(143),mass4set(:,1),  & 
G1tensor(80),G1tensor(19),G1tensor(390),G1tensor(84),G1tensor(371))
  call G_TensorShift(G1tensor(19),4)
  call Hotf_4pt_reduction_last(G2tensor(205),RedSet_4(8),mass4set(:,1),  & 
G1tensor(86),G1tensor(25),G1tensor(90),G1tensor(374),G1tensor(98))
  call G_TensorShift(G1tensor(25),12)
  call Hotf_4pt_reduction_last(G2tensor(144),RedSet_4(144),mass4set(:,1),  & 
G1tensor(49),G1tensor(102),G1tensor(104),G1tensor(55),G1tensor(108))
  call G_TensorShift(G1tensor(102),4)
  call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(11),mass4set(:,1),  & 
G1tensor(110),G1tensor(61),G1tensor(114),G1tensor(368),G1tensor(122))
  call G_TensorShift(G1tensor(61),12)
  call Hotf_4pt_reduction_last(G2tensor(271),RedSet_4(145),mass4set(:,1),  & 
G1tensor(14),G1tensor(126),G1tensor(128),G1tensor(56),G1tensor(20))
  call G_TensorShift(G1tensor(126),2)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(19),mass4set(:,1),  & 
G1tensor(132),G1tensor(134),G1tensor(26),G1tensor(138),G1tensor(146))
  call G_TensorShift(G1tensor(134),10)
  call Hotf_4pt_reduction_last(G2tensor(265),RedSet_4(146),mass4set(:,1),  & 
G1tensor(50),G1tensor(150),G1tensor(152),G1tensor(62),G1tensor(156))
  call G_TensorShift(G1tensor(150),2)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(23),mass4set(:,1),  & 
G1tensor(170),G1tensor(6),G1tensor(340),G1tensor(174),G1tensor(176))
  call G_TensorShift(G1tensor(6),10)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(147),mass4set(:,1),  & 
G1tensor(65),G1tensor(9),G1tensor(341),G1tensor(335),G1tensor(180))
  call G_TensorShift(G1tensor(9),2)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(26),mass4set(:,1),  & 
G1tensor(188),G1tensor(15),G1tensor(351),G1tensor(192),G1tensor(194))
  call G_TensorShift(G1tensor(15),10)
  call Hotf_4pt_reduction_last(G2tensor(251),RedSet_4(148),mass4set(:,1),  & 
G1tensor(22),G1tensor(352),G1tensor(198),G1tensor(200),G1tensor(47))
  call G_TensorShift(G1tensor(352),1)
  call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(34),mass4set(:,1),  & 
G1tensor(16),G1tensor(359),G1tensor(353),G1tensor(204),G1tensor(218))
  call G_TensorShift(G1tensor(359),9)
  call Hotf_4pt_reduction_last(G2tensor(252),RedSet_4(149),mass4set(:,1),  & 
G1tensor(24),G1tensor(328),G1tensor(222),G1tensor(224),G1tensor(57))
  call G_TensorShift(G1tensor(328),1)
  call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(38),mass4set(:,1),  & 
G1tensor(27),G1tensor(329),G1tensor(323),G1tensor(228),G1tensor(236))
  call G_TensorShift(G1tensor(329),9)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(150),mass4set(:,1),  & 
G1tensor(30),G1tensor(345),G1tensor(240),G1tensor(242),G1tensor(33))
  call G_TensorShift(G1tensor(345),1)
  call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(40),mass4set(:,1),  & 
G1tensor(346),G1tensor(246),G1tensor(248),G1tensor(69),G1tensor(34))
  call G_TensorShift(G1tensor(246),9)
  call Hotf_4pt_reduction_last(G2tensor(253),RedSet_4(152),mass4set(:,1),  & 
G1tensor(365),G1tensor(347),G1tensor(252),G1tensor(260),G1tensor(39))
  call G_TensorShift(G1tensor(347),1)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(47),mass4set(:,1),  & 
G1tensor(333),G1tensor(264),G1tensor(266),G1tensor(40),G1tensor(334))
  call G_TensorShift(G1tensor(264),9)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(153),mass4set(:,1),  & 
G1tensor(270),G1tensor(278),G1tensor(46),G1tensor(357),G1tensor(282))
  call G_TensorShift(G1tensor(278),1)
  call Hotf_4pt_reduction_last(G2tensor(110),RedSet_4(49),mass4set(:,1),  & 
G1tensor(284),G1tensor(64),G1tensor(71),G1tensor(364),G1tensor(358))
  call G_TensorShift(G1tensor(64),9)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(156),mass4set(:,1),  & 
G1tensor(288),G1tensor(296),G1tensor(66),G1tensor(321),G1tensor(300))
  call G_TensorShift(G1tensor(296),4)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(61),mass4set(:,1),  & 
G1tensor(302),G1tensor(54),G1tensor(322),G1tensor(306),G1tensor(308))
  call G_TensorShift(G1tensor(54),20)
  call Hotf_4pt_reduction_last(G2tensor(290),RedSet_4(157),mass4set(:,1),  & 
G1tensor(63),G1tensor(363),G1tensor(312),G1tensor(372),G1tensor(384))
  call G_TensorShift(G1tensor(363),4)
  call Hotf_4pt_reduction_last(G2tensor(416),RedSet_4(64),mass4set(:,1),  & 
G1tensor(378),G1tensor(386),G1tensor(392),G1tensor(396),G1tensor(398))
  call G_TensorShift(G1tensor(386),20)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(159),mass4set(:,1),  & 
G1tensor(402),G1tensor(404),G1tensor(408),G1tensor(410),G1tensor(195))
  call G_TensorShift(G1tensor(404),8)
  call Hotf_4pt_reduction_last(G2tensor(129),RedSet_4(72),mass4set(:,1),  & 
G1tensor(189),G1tensor(420),G1tensor(414),G1tensor(416),G1tensor(7))
  call G_TensorShift(G1tensor(420),24)
  call Hotf_4pt_reduction_last(G2tensor(296),RedSet_4(160),mass4set(:,1),  & 
G1tensor(43),G1tensor(303),G1tensor(297),G1tensor(8),G1tensor(267))
  call G_TensorShift(G1tensor(303),8)
  call Hotf_4pt_reduction_last(G2tensor(425),RedSet_4(76),mass4set(:,1),  & 
G1tensor(261),G1tensor(44),G1tensor(81),G1tensor(75),G1tensor(87))
  call G_TensorShift(G1tensor(44),24)
  call Hotf_4pt_reduction_last(G2tensor(302),RedSet_4(161),mass4set(:,1),  & 
G1tensor(76),G1tensor(93),G1tensor(77),G1tensor(88),G1tensor(82))
  call G_TensorShift(G1tensor(93),8)
  call Hotf_4pt_reduction_last(G2tensor(428),RedSet_4(79),mass4set(:,1),  & 
G1tensor(94),G1tensor(83),G1tensor(161),G1tensor(155),G1tensor(95))
  call G_TensorShift(G1tensor(83),24)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(164),mass4set(:,1),  & 
G1tensor(89),G1tensor(105),G1tensor(99),G1tensor(111),G1tensor(100))
  call G_TensorShift(G1tensor(105),2)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(89),mass4set(:,1),  & 
G1tensor(117),G1tensor(101),G1tensor(112),G1tensor(106),G1tensor(118))
  call G_TensorShift(G1tensor(101),18)
  call Hotf_4pt_reduction_last(G2tensor(308),RedSet_4(165),mass4set(:,1),  & 
G1tensor(107),G1tensor(143),G1tensor(137),G1tensor(119),G1tensor(113))
  call G_TensorShift(G1tensor(143),2)
  call Hotf_4pt_reduction_last(G2tensor(413),RedSet_4(91),mass4set(:,1),  & 
G1tensor(147),G1tensor(129),G1tensor(123),G1tensor(135),G1tensor(124))
  call G_TensorShift(G1tensor(129),18)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(167),mass4set(:,1),  & 
G1tensor(141),G1tensor(125),G1tensor(154),G1tensor(136),G1tensor(130))
  call G_TensorShift(G1tensor(125),8)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(99),mass4set(:,1),  & 
G1tensor(160),G1tensor(142),G1tensor(131),G1tensor(153),G1tensor(148))
  call G_TensorShift(G1tensor(142),24)
  call Hotf_4pt_reduction_last(G2tensor(311),RedSet_4(168),mass4set(:,1),  & 
G1tensor(159),G1tensor(149),G1tensor(171),G1tensor(165),G1tensor(262))
  call G_TensorShift(G1tensor(149),8)
  call Hotf_4pt_reduction_last(G2tensor(419),RedSet_4(102),mass4set(:,1),  & 
G1tensor(177),G1tensor(166),G1tensor(183),G1tensor(167),G1tensor(394))
  call G_TensorShift(G1tensor(166),24)
  call Hotf_4pt_reduction_last(G2tensor(317),RedSet_4(169),mass4set(:,1),  & 
G1tensor(268),G1tensor(178),G1tensor(172),G1tensor(418),G1tensor(184))
  call G_TensorShift(G1tensor(178),8)
  call Hotf_4pt_reduction_last(G2tensor(422),RedSet_4(105),mass4set(:,1),  & 
G1tensor(173),G1tensor(275),G1tensor(233),G1tensor(227),G1tensor(185))
  call G_TensorShift(G1tensor(275),24)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(171),mass4set(:,1),  & 
G1tensor(179),G1tensor(280),G1tensor(201),G1tensor(190),G1tensor(207))
  call G_TensorShift(G1tensor(280),4)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(110),mass4set(:,1),  & 
G1tensor(191),G1tensor(286),G1tensor(250),G1tensor(244),G1tensor(202))
  call G_TensorShift(G1tensor(286),20)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(172),mass4set(:,1),  & 
G1tensor(196),G1tensor(407),G1tensor(208),G1tensor(197),G1tensor(401))
  call G_TensorShift(G1tensor(407),4)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(113),mass4set(:,1),  & 
G1tensor(293),G1tensor(209),G1tensor(203),G1tensor(219),G1tensor(213))
  call G_TensorShift(G1tensor(209),20)
  call Hotf_4pt_reduction_last(G2tensor(72),RedSet_4(174),mass4set(:,1),  & 
G1tensor(298),G1tensor(225),G1tensor(214),G1tensor(231),G1tensor(215))
  call G_TensorShift(G1tensor(225),8)
  call Hotf_4pt_reduction_last(G2tensor(132),RedSet_4(120),mass4set(:,1),  & 
G1tensor(406),G1tensor(304),G1tensor(226),G1tensor(220),G1tensor(400))
  call G_TensorShift(G1tensor(304),24)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(175),mass4set(:,1),  & 
G1tensor(232),G1tensor(221),G1tensor(243),G1tensor(237),G1tensor(310))
  call G_TensorShift(G1tensor(221),8)
  call Hotf_4pt_reduction_last(G2tensor(135),RedSet_4(123),mass4set(:,1),  & 
G1tensor(249),G1tensor(238),G1tensor(255),G1tensor(239),G1tensor(395))
  call G_TensorShift(G1tensor(238),24)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(177),mass4set(:,1),  & 
G1tensor(256),G1tensor(245),G1tensor(419),G1tensor(317),G1tensor(257))
  call G_TensorShift(G1tensor(245),2)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(128),mass4set(:,1),  & 
G1tensor(251),G1tensor(299),G1tensor(273),G1tensor(263),G1tensor(305))
  call G_TensorShift(G1tensor(299),18)
  call Hotf_4pt_reduction_last(G2tensor(87),RedSet_4(178),mass4set(:,1),  & 
G1tensor(274),G1tensor(269),G1tensor(309),G1tensor(285),G1tensor(279))
  call G_TensorShift(G1tensor(269),2)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(130),mass4set(:,1),  & 
G1tensor(291),G1tensor(281),G1tensor(316),G1tensor(292),G1tensor(287))
  call G_TensorShift(G1tensor(281),18)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(179),mass4set(:,1),  & 
G1tensor(315),G1tensor(311),G1tensor(369),G1tensor(370),G1tensor(375))
  call G_TensorShift(G1tensor(311),8)
  call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(134),mass4set(:,1),  & 
G1tensor(376),G1tensor(377),G1tensor(381),G1tensor(382),G1tensor(383))
  call G_TensorShift(G1tensor(377),24)
  call Hotf_4pt_reduction_last(G2tensor(467),RedSet_4(183),mass4set(:,1),  & 
G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(393),G1tensor(399))
  call G_TensorShift(G1tensor(388),5)
  call Hotf_4pt_reduction_last(G2tensor(200),RedSet_4(187),mass4set(:,1),  & 
G1tensor(405),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(417))
  call G_TensorShift(G1tensor(411),6)
  call Hotf_4pt_reduction_last(G2tensor(267),RedSet_4(207),mass4set(:,1),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425))
  call G_TensorShift(G1tensor(422),8)
  call Hotf_4pt_reduction_last(G2tensor(323),RedSet_4(211),mass4set(:,1),  & 
G1tensor(426),G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430))
  call G_TensorShift(G1tensor(427),4)
  call Hotf_4pt_reduction_last(G2tensor(461),RedSet_4(138),mass4set(:,1),  & 
G1tensor(431),G1tensor(432),G1tensor(433),G1tensor(434),G1tensor(435))
  call G_TensorShift(G1tensor(432),20)
  call Hotf_4pt_reduction_last(G2tensor(329),RedSet_4(212),mass4set(:,1),  & 
G1tensor(436),G1tensor(437),G1tensor(438),G1tensor(439),G1tensor(440))
  call G_TensorShift(G1tensor(437),3)
  call Hotf_4pt_reduction_last(G2tensor(482),RedSet_4(139),mass4set(:,1),  & 
G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444),G1tensor(445))
  call G_TensorShift(G1tensor(442),19)
  call Hotf_4pt_reduction_last(G2tensor(335),RedSet_4(213),mass4set(:,1),  & 
G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(447),2)
  call Hotf_4pt_reduction_last(G2tensor(464),RedSet_4(140),mass4set(:,1),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455))
  call G_TensorShift(G1tensor(452),18)
  call Hotf_4pt_reduction_last(G2tensor(341),RedSet_4(69),mass4set(:,1),  & 
G1tensor(456),G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460))
  call G_TensorShift(G1tensor(457),16)
  call Hotf_4pt_reduction_last(G2tensor(488),RedSet_4(141),mass4set(:,1),  & 
G1tensor(461),G1tensor(462),G1tensor(463),G1tensor(464),G1tensor(465))
  call G_TensorShift(G1tensor(462),21)
  call Hotf_4pt_reduction_last(G2tensor(347),RedSet_4(214),mass4set(:,1),  & 
G1tensor(466),G1tensor(467),G1tensor(468),G1tensor(469),G1tensor(470))
  call G_TensorShift(G1tensor(467),5)
  call Hotf_4pt_reduction_last(G2tensor(284),RedSet_4(209),mass4set(:,1),  & 
G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474),G1tensor(475))
  call G_TensorShift(G1tensor(472),16)
  call Hotf_4pt_reduction_last(G2tensor(287),RedSet_4(210),mass4set(:,1),  & 
G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(477),16)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(127),mass4set(:,1),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485))
  call G_TensorShift(G1tensor(482),16)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(108),mass4set(:,1),  & 
G1tensor(486),G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490))
  call G_TensorShift(G1tensor(487),16)
  call Hotf_4pt_reduction_last(G2tensor(371),RedSet_4(1),mass4set(:,1),  & 
G1tensor(491),G1tensor(492),G1tensor(493),G1tensor(494),G1tensor(495))
  call G_TensorShift(G1tensor(492),8)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(2),mass4set(:,1),  & 
G1tensor(496),G1tensor(497),G1tensor(498),G1tensor(499),G1tensor(500))
  call G_TensorShift(G1tensor(497),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(3),mass4set(:,1),  & 
G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504),G1tensor(505))
  call G_TensorShift(G1tensor(502),8)
  call Hotf_4pt_reduction_last(G2tensor(374),RedSet_4(6),mass4set(:,1),  & 
G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(507),8)
  call Hotf_4pt_reduction_last(G2tensor(275),RedSet_4(7),mass4set(:,1),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515))
  call G_TensorShift(G1tensor(512),8)
  call Hotf_4pt_reduction_last(G2tensor(353),RedSet_4(10),mass4set(:,1),  & 
G1tensor(516),G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520))
  call G_TensorShift(G1tensor(517),8)
  call Hotf_4pt_reduction_last(G2tensor(377),RedSet_4(16),mass4set(:,1),  & 
G1tensor(521),G1tensor(522),G1tensor(523),G1tensor(524),G1tensor(525))
  call G_TensorShift(G1tensor(522),8)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(17),mass4set(:,1),  & 
G1tensor(526),G1tensor(527),G1tensor(528),G1tensor(529),G1tensor(530))
  call G_TensorShift(G1tensor(527),8)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(18),mass4set(:,1),  & 
G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534),G1tensor(535))
  call G_TensorShift(G1tensor(532),8)
  call Hotf_4pt_reduction_last(G2tensor(380),RedSet_4(21),mass4set(:,1),  & 
G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(537),8)
  call Hotf_4pt_reduction_last(G2tensor(278),RedSet_4(22),mass4set(:,1),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545))
  call G_TensorShift(G1tensor(542),8)
  call Hotf_4pt_reduction_last(G2tensor(356),RedSet_4(25),mass4set(:,1),  & 
G1tensor(546),G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550))
  call G_TensorShift(G1tensor(547),8)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(31),mass4set(:,1),  & 
G1tensor(551),G1tensor(552),G1tensor(553),G1tensor(554),G1tensor(555))
  call G_TensorShift(G1tensor(552),8)
  call Hotf_4pt_reduction_last(G2tensor(102),RedSet_4(32),mass4set(:,1),  & 
G1tensor(556),G1tensor(557),G1tensor(558),G1tensor(559),G1tensor(560))
  call G_TensorShift(G1tensor(557),8)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(33),mass4set(:,1),  & 
G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564),G1tensor(565))
  call G_TensorShift(G1tensor(562),8)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(36),mass4set(:,1),  & 
G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(567),8)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(37),mass4set(:,1),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575))
  call G_TensorShift(G1tensor(572),8)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(45),mass4set(:,1),  & 
G1tensor(576),G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580))
  call G_TensorShift(G1tensor(577),8)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(46),mass4set(:,1),  & 
G1tensor(581),G1tensor(582),G1tensor(583),G1tensor(584),G1tensor(585))
  call G_TensorShift(G1tensor(582),8)
  call Hotf_4pt_reduction_last(G2tensor(383),RedSet_4(54),mass4set(:,1),  & 
G1tensor(586),G1tensor(587),G1tensor(588),G1tensor(589),G1tensor(590))
  call G_TensorShift(G1tensor(587),16)
  call Hotf_4pt_reduction_last(G2tensor(386),RedSet_4(55),mass4set(:,1),  & 
G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594),G1tensor(595))
  call G_TensorShift(G1tensor(592),16)
  call Hotf_4pt_reduction_last(G2tensor(359),RedSet_4(56),mass4set(:,1),  & 
G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(597),16)
  call Hotf_4pt_reduction_last(G2tensor(389),RedSet_4(59),mass4set(:,1),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605))
  call G_TensorShift(G1tensor(602),16)
  call Hotf_4pt_reduction_last(G2tensor(458),RedSet_4(60),mass4set(:,1),  & 
G1tensor(606),G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610))
  call G_TensorShift(G1tensor(607),16)
  call Hotf_4pt_reduction_last(G2tensor(293),RedSet_4(63),mass4set(:,1),  & 
G1tensor(611),G1tensor(612),G1tensor(613),G1tensor(614),G1tensor(615))
  call G_TensorShift(G1tensor(612),16)
  call Hotf_4pt_reduction_last(G2tensor(392),RedSet_4(70),mass4set(:,1),  & 
G1tensor(616),G1tensor(617),G1tensor(618),G1tensor(619),G1tensor(620))
  call G_TensorShift(G1tensor(617),16)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(71),mass4set(:,1),  & 
G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624),G1tensor(625))
  call G_TensorShift(G1tensor(622),16)
  call Hotf_4pt_reduction_last(G2tensor(395),RedSet_4(74),mass4set(:,1),  & 
G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(627),16)
  call Hotf_4pt_reduction_last(G2tensor(338),RedSet_4(75),mass4set(:,1),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635))
  call G_TensorShift(G1tensor(632),16)
  call Hotf_4pt_reduction_last(G2tensor(305),RedSet_4(78),mass4set(:,1),  & 
G1tensor(636),G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640))
  call G_TensorShift(G1tensor(637),16)
  call Hotf_4pt_reduction_last(G2tensor(398),RedSet_4(83),mass4set(:,1),  & 
G1tensor(641),G1tensor(642),G1tensor(643),G1tensor(644),G1tensor(645))
  call G_TensorShift(G1tensor(642),16)
  call Hotf_4pt_reduction_last(G2tensor(401),RedSet_4(84),mass4set(:,1),  & 
G1tensor(646),G1tensor(647),G1tensor(648),G1tensor(649),G1tensor(650))
  call G_TensorShift(G1tensor(647),16)
  call Hotf_4pt_reduction_last(G2tensor(365),RedSet_4(85),mass4set(:,1),  & 
G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654),G1tensor(655))
  call G_TensorShift(G1tensor(652),16)
  call Hotf_4pt_reduction_last(G2tensor(404),RedSet_4(87),mass4set(:,1),  & 
G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(657),16)
  call Hotf_4pt_reduction_last(G2tensor(443),RedSet_4(88),mass4set(:,1),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665))
  call G_TensorShift(G1tensor(662),16)
  call Hotf_4pt_reduction_last(G2tensor(407),RedSet_4(96),mass4set(:,1),  & 
G1tensor(666),G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670))
  call G_TensorShift(G1tensor(667),16)
  call Hotf_4pt_reduction_last(G2tensor(410),RedSet_4(97),mass4set(:,1),  & 
G1tensor(671),G1tensor(672),G1tensor(673),G1tensor(674),G1tensor(675))
  call G_TensorShift(G1tensor(672),16)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(98),mass4set(:,1),  & 
G1tensor(676),G1tensor(677),G1tensor(678),G1tensor(679),G1tensor(680))
  call G_TensorShift(G1tensor(677),16)
  call Hotf_4pt_reduction_last(G2tensor(326),RedSet_4(101),mass4set(:,1),  & 
G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684),G1tensor(685))
  call G_TensorShift(G1tensor(682),16)
  call Hotf_4pt_reduction_last(G2tensor(320),RedSet_4(104),mass4set(:,1),  & 
G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(687),16)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(109),mass4set(:,1),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695))
  call G_TensorShift(G1tensor(692),16)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(112),mass4set(:,1),  & 
G1tensor(696),G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700))
  call G_TensorShift(G1tensor(697),16)
  call Hotf_4pt_reduction_last(G2tensor(108),RedSet_4(118),mass4set(:,1),  & 
G1tensor(701),G1tensor(702),G1tensor(703),G1tensor(704),G1tensor(705))
  call G_TensorShift(G1tensor(702),16)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(119),mass4set(:,1),  & 
G1tensor(706),G1tensor(707),G1tensor(708),G1tensor(709),G1tensor(710))
  call G_TensorShift(G1tensor(707),16)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(122),mass4set(:,1),  & 
G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714),G1tensor(715))
  call G_TensorShift(G1tensor(712),16)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(133),mass4set(:,1),  & 
G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(717),16)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(181),mass4set(:,1),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725))
  call G_TensorShift(G1tensor(722),4)
  call Hotf_4pt_reduction_last(G2tensor(141),RedSet_4(182),mass4set(:,1),  & 
G1tensor(726),G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730))
  call G_TensorShift(G1tensor(727),4)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(184),mass4set(:,1),  & 
G1tensor(731),G1tensor(732),G1tensor(733),G1tensor(734),G1tensor(735))
  call G_TensorShift(G1tensor(732),4)
  call Hotf_4pt_reduction_last(G2tensor(147),RedSet_4(185),mass4set(:,1),  & 
G1tensor(736),G1tensor(737),G1tensor(738),G1tensor(739),G1tensor(740))
  call G_TensorShift(G1tensor(737),4)
  call Hotf_4pt_reduction_last(G2tensor(150),RedSet_4(186),mass4set(:,1),  & 
G1tensor(741),G1tensor(742),G1tensor(743),G1tensor(744),G1tensor(745))
  call G_TensorShift(G1tensor(742),4)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(188),mass4set(:,1),  & 
G1tensor(746),G1tensor(747),G1tensor(748),G1tensor(749),G1tensor(750))
  call G_TensorShift(G1tensor(747),2)
  call Hotf_4pt_reduction_last(G2tensor(153),RedSet_4(189),mass4set(:,1),  & 
G1tensor(751),G1tensor(752),G1tensor(753),G1tensor(754),G1tensor(755))
  call G_TensorShift(G1tensor(752),2)
  call Hotf_4pt_reduction_last(G2tensor(156),RedSet_4(190),mass4set(:,1),  & 
G1tensor(756),G1tensor(757),G1tensor(758),G1tensor(759),G1tensor(760))
  call G_TensorShift(G1tensor(757),2)
  call Hotf_4pt_reduction_last(G2tensor(431),RedSet_4(191),mass4set(:,1),  & 
G1tensor(761),G1tensor(762),G1tensor(763),G1tensor(764),G1tensor(765))
  call G_TensorShift(G1tensor(762),4)
  call Hotf_4pt_reduction_last(G2tensor(434),RedSet_4(192),mass4set(:,1),  & 
G1tensor(766),G1tensor(767),G1tensor(768),G1tensor(769),G1tensor(770))
  call G_TensorShift(G1tensor(767),4)
  call Hotf_4pt_reduction_last(G2tensor(281),RedSet_4(193),mass4set(:,1),  & 
G1tensor(771),G1tensor(772),G1tensor(773),G1tensor(774),G1tensor(775))
  call G_TensorShift(G1tensor(772),4)
  call Hotf_4pt_reduction_last(G2tensor(437),RedSet_4(195),mass4set(:,1),  & 
G1tensor(776),G1tensor(777),G1tensor(778),G1tensor(779),G1tensor(780))
  call G_TensorShift(G1tensor(777),16)
  call Hotf_4pt_reduction_last(G2tensor(440),RedSet_4(197),mass4set(:,1),  & 
G1tensor(781),G1tensor(782),G1tensor(783),G1tensor(784),G1tensor(785))
  call G_TensorShift(G1tensor(782),16)
  call Hotf_4pt_reduction_last(G2tensor(446),RedSet_4(199),mass4set(:,1),  & 
G1tensor(786),G1tensor(787),G1tensor(788),G1tensor(789),G1tensor(790))
  call G_TensorShift(G1tensor(787),16)
  call Hotf_4pt_reduction_last(G2tensor(449),RedSet_4(201),mass4set(:,1),  & 
G1tensor(791),G1tensor(792),G1tensor(793),G1tensor(794),G1tensor(795))
  call G_TensorShift(G1tensor(792),5)
  call Hotf_4pt_reduction_last(G2tensor(452),RedSet_4(202),mass4set(:,1),  & 
G1tensor(796),G1tensor(797),G1tensor(798),G1tensor(799),G1tensor(800))
  call G_TensorShift(G1tensor(797),5)
  call Hotf_4pt_reduction_last(G2tensor(344),RedSet_4(203),mass4set(:,1),  & 
G1tensor(801),G1tensor(802),G1tensor(803),G1tensor(804),G1tensor(805))
  call G_TensorShift(G1tensor(802),5)
  call Hotf_4pt_reduction_last(G2tensor(455),RedSet_4(205),mass4set(:,1),  & 
G1tensor(806),G1tensor(807),G1tensor(808),G1tensor(809),G1tensor(810))
  call G_TensorShift(G1tensor(807),16)
  call Hotf_4pt_reduction_last(G2tensor(254),RedSet_4(221),mass4set(:,1),  & 
G1tensor(811),G1tensor(812),G1tensor(813),G1tensor(814),G1tensor(815))
  call G_TensorShift(G1tensor(812),17)
  call Hotf_4pt_reduction_last(G2tensor(255),RedSet_4(222),mass4set(:,1),  & 
G1tensor(816),G1tensor(817),G1tensor(818),G1tensor(819),G1tensor(820))
  call G_TensorShift(G1tensor(817),17)
  call Hotf_4pt_reduction_last(G2tensor(258),RedSet_4(223),mass4set(:,1),  & 
G1tensor(821),G1tensor(822),G1tensor(823),G1tensor(824),G1tensor(825))
  call G_TensorShift(G1tensor(822),18)
  call Hotf_4pt_reduction_last(G2tensor(260),RedSet_4(224),mass4set(:,1),  & 
G1tensor(826),G1tensor(827),G1tensor(828),G1tensor(829),G1tensor(830))
  call G_TensorShift(G1tensor(827),20)
  call Hotf_4pt_reduction_last(G2tensor(273),RedSet_4(208),mass4set(:,1),  & 
G1tensor(831),G1tensor(832),G1tensor(833),G1tensor(834),G1tensor(835))
  call G_TensorShift(G1tensor(832),8)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(57),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(86),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(151),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(154),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(13),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(28),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(42),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(51),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(215),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(158),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(66),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(163),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(162),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(216),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(339),RedSet_4(166),mass4set(:,1),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))



end subroutine vamp_2

end module ol_vamp_2_ppwajj_uuxuxdawx_1_/**/REALKIND
