
module ol_vamp_2_ppwajj_uuuxdxaw_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwajj_uuuxdxaw_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwajj_uuuxdxaw_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwajj_uuuxdxaw_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwajj_uuuxdxaw_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwajj_uuuxdxaw_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwajj_uuuxdxaw_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(22)*M(2,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(126),h0tab(:,126),[33,2,20,8],[0,0,0,0],4,2,wf6(:,8),wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,8),G0H16(17),m3h6x16(:,52),heltab2x96(:,:,126))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(20)*M(2,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(127),h0tab(:,127),[34,8,1,20],[0,0,0,0],4,2,wf6(:,4),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H96(1),wf6(:,4),G0H16(18),m3h6x16(:,53),heltab2x96(:,:,127))
  call Hloop_Q_A(ntryL,G0H16(18),34,0,G1H16(16),n2h16(23))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(24)*M(2,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(128),h0tab(:,128),[34,1,20,8],[0,0,0,0],4,2,wf6(:,4),wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,4),G0H16(18),m3h6x16(:,54),heltab2x96(:,:,128))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(24)*M(2,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(129),h0tab(:,129),[40,2,1,20],[0,0,0,0],4,2,wf6(:,2),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf6(:,2),G0H16(19),m3h6x16(:,55),heltab2x96(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(19),40,0,G1H16(17),n2h16(24))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(22)*M(2,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(130),h0tab(:,130),[40,1,2,20],[0,0,0,0],4,2,wf6(:,2),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf6(:,2),G0H16(19),m3h6x16(:,56),heltab2x96(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(19),40,0,G1H16(18),n2h16(25))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(20)*M(2,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(131),h0tab(:,131),[40,1,20,2],[0,0,0,0],4,2,wf6(:,2),wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf6(:,2),G0H16(19),m3h6x16(:,57),heltab2x96(:,:,131))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)-c(26)*M(2,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(132),h0tab(:,132),[40,1,20,2],[0,0,0,0],4,2,wf6(:,2),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf6(:,2),G0H16(20),m3h6x16(:,58),heltab2x96(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(20),40,0,G1H16(19),n2h16(26))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(133),h0tab(:,133),[32,2,8,21],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_AW_Q(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,71),heltab2x96(:,:,133))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(27),n2h32(71))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(134),h0tab(:,134),[32,8,2,21],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_QW_A(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,72),heltab2x96(:,:,134))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(28),n2h32(72))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(3)*M(2,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(135),h0tab(:,135),[32,2,21,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_AW_Q(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,73),heltab2x96(:,:,135))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(29),n2h32(73))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(136),h0tab(:,136),[32,1,8,22],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_AW_Q(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,74),heltab2x96(:,:,136))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(30),n2h32(74))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(137),h0tab(:,137),[32,8,1,22],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_QW_A(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,75),heltab2x96(:,:,137))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(31),n2h32(75))
  Gcoeff(:)%j = (c(3)*M(1,:)%j-c(4)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(138),h0tab(:,138),[32,1,22,8],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_AW_Q(ntryL,G0H96(1),ex6(:),G0H32(1),m3h3x32(:,76),heltab2x96(:,:,138))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(32),n2h32(76))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(11)*M(2,:)%j) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(139),h0tab(:,139),[33,2,4,24],[0,0,0,0],4,2,wf6(:,8),wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,8),G0H16(20),m3h6x16(:,59),heltab2x96(:,:,139))
  Gcoeff(:)%j = (c(9)*M(1,:)%j+c(15)*M(2,:)%j) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(140),h0tab(:,140),[33,4,2,24],[0,0,0,0],4,2,wf6(:,8),wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,8),G0H16(21),m3h6x16(:,60),heltab2x96(:,:,140))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(13)*M(2,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(141),h0tab(:,141),[34,1,4,24],[0,0,0,0],4,2,wf6(:,4),wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,4),G0H16(22),m3h6x16(:,61),heltab2x96(:,:,141))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)-c(9)*M(2,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(142),h0tab(:,142),[34,4,1,24],[0,0,0,0],4,2,wf6(:,4),wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf6(:,4),G0H16(23),m3h6x16(:,62),heltab2x96(:,:,142))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(13)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(143),h0tab(:,143),[56,2,1,4],[0,0,0,0],4,1,wf12(:,33))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,33),G0H8(5),m3h12x8(:,5),heltab2x96(:,:,143))
  call Hloop_A_Q(ntryL,G0H8(5),56,0,G1H8(29),n2h8(62))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(11)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(144),h0tab(:,144),[56,1,2,4],[0,0,0,0],4,1,wf12(:,33))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,33),G0H8(5),m3h12x8(:,6),heltab2x96(:,:,144))
  call Hloop_A_Q(ntryL,G0H8(5),56,0,G1H8(11),n2h8(63))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)-c(9)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(145),h0tab(:,145),[56,1,4,2],[0,0,0,0],4,1,wf12(:,33))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,33),G0H8(5),m3h12x8(:,7),heltab2x96(:,:,145))
  Gcoeff(:)%j = (c(9)*M(1,:)%j+c(15)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(146),h0tab(:,146),[56,1,4,2],[0,0,0,0],4,1,wf12(:,33))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,33),G0H8(6),m3h12x8(:,8),heltab2x96(:,:,146))
  call Hloop_A_Q(ntryL,G0H8(6),56,0,G1H8(18),n2h8(64))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(147),h0tab(:,147),[41,4,2,16],[0,0,0,0],4,1,wf12(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf12(:,14),G0H8(6),m3h12x8(:,9),heltab2x96(:,:,147))
  call Hloop_Q_A(ntryL,G0H8(6),41,0,G1H8(23),n2h8(65))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(148),h0tab(:,148),[41,2,4,16],[0,0,0,0],4,1,wf12(:,14))
  call Hloop_AV_Q(ntryL,G0H96(1),wf12(:,14),G0H8(6),m3h12x8(:,10),heltab2x96(:,:,148))
  call Hloop_A_Q(ntryL,G0H8(6),41,0,G1H8(24),n2h8(66))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(149),h0tab(:,149),[41,2,16,4],[0,0,0,0],4,1,wf12(:,14))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf12(:,14),41,G1H8(1),m3h12x8(:,11),heltab2x96(:,:,149))
  Gcoeff(:)%j = (c(9)*M(1,:)%j+c(15)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(150),h0tab(:,150),[49,4,2,8],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,28),G0H8(6),m3h12x8(:,12),heltab2x96(:,:,150))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(11)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(151),h0tab(:,151),[49,2,4,8],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,28),G0H8(7),m3h12x8(:,13),heltab2x96(:,:,151))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(152),h0tab(:,152),[42,4,1,16],[0,0,0,0],4,1,wf12(:,12))
  call Hloop_QV_A(ntryL,G0H96(1),wf12(:,12),G0H8(8),m3h12x8(:,14),heltab2x96(:,:,152))
  call Hloop_Q_A(ntryL,G0H8(8),42,0,G1H8(6),n2h8(67))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(153),h0tab(:,153),[42,1,4,16],[0,0,0,0],4,1,wf12(:,12))
  call Hloop_AV_Q(ntryL,G0H96(1),wf12(:,12),G0H8(8),m3h12x8(:,15),heltab2x96(:,:,153))
  call Hloop_A_Q(ntryL,G0H8(8),42,0,G1H8(7),n2h8(68))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(154),h0tab(:,154),[42,1,16,4],[0,0,0,0],4,1,wf12(:,12))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf12(:,12),42,G1H8(8),m3h12x8(:,16),heltab2x96(:,:,154))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)-c(9)*M(2,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(155),h0tab(:,155),[50,4,1,8],[0,0,0,0],4,1,wf12(:,21))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,21),G0H8(8),m3h12x8(:,17),heltab2x96(:,:,155))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(13)*M(2,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(156),h0tab(:,156),[50,1,4,8],[0,0,0,0],4,1,wf12(:,21))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,21),G0H8(9),m3h12x8(:,18),heltab2x96(:,:,156))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(157),h0tab(:,157),[41,4,2,16],[0,0,0,0],4,1,wf12(:,15))
  call Hloop_QV_A(ntryL,G0H96(1),wf12(:,15),G0H8(10),m3h12x8(:,19),heltab2x96(:,:,157))
  call Hloop_Q_A(ntryL,G0H8(10),41,0,G1H8(25),n2h8(69))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(158),h0tab(:,158),[41,2,4,16],[0,0,0,0],4,1,wf12(:,15))
  call Hloop_AV_Q(ntryL,G0H96(1),wf12(:,15),G0H8(10),m3h12x8(:,20),heltab2x96(:,:,158))
  call Hloop_A_Q(ntryL,G0H8(10),41,0,G1H8(28),n2h8(70))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(159),h0tab(:,159),[41,2,16,4],[0,0,0,0],4,1,wf12(:,15))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf12(:,15),41,G1H8(3),m3h12x8(:,21),heltab2x96(:,:,159))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(160),h0tab(:,160),[42,4,1,16],[0,0,0,0],4,1,wf12(:,13))
  call Hloop_QV_A(ntryL,G0H96(1),wf12(:,13),G0H8(10),m3h12x8(:,22),heltab2x96(:,:,160))
  call Hloop_Q_A(ntryL,G0H8(10),42,0,G1H8(4),n2h8(71))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(2,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(161),h0tab(:,161),[42,1,4,16],[0,0,0,0],4,1,wf12(:,13))
  call Hloop_AV_Q(ntryL,G0H96(1),wf12(:,13),G0H8(10),m3h12x8(:,23),heltab2x96(:,:,161))
  call Hloop_A_Q(ntryL,G0H8(10),42,0,G1H8(15),n2h8(72))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(162),h0tab(:,162),[42,1,16,4],[0,0,0,0],4,1,wf12(:,13))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf12(:,13),42,G1H8(22),m3h12x8(:,24),heltab2x96(:,:,162))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(24)*M(2,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(163),h0tab(:,163),[56,2,1,4],[0,0,0,0],4,1,wf12(:,34))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,34),G0H8(10),m3h12x8(:,25),heltab2x96(:,:,163))
  call Hloop_A_Q(ntryL,G0H8(10),56,0,G1H8(20),n2h8(73))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)+c(22)*M(2,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(164),h0tab(:,164),[56,1,2,4],[0,0,0,0],4,1,wf12(:,34))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,34),G0H8(10),m3h12x8(:,26),heltab2x96(:,:,164))
  call Hloop_A_Q(ntryL,G0H8(10),56,0,G1H8(14),n2h8(74))
  Gcoeff(:)%j = (c(26)*M(1,:)%j+c(20)*M(2,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(165),h0tab(:,165),[56,1,4,2],[0,0,0,0],4,1,wf12(:,34))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,34),G0H8(10),m3h12x8(:,27),heltab2x96(:,:,165))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)-c(26)*M(2,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(166),h0tab(:,166),[56,1,4,2],[0,0,0,0],4,1,wf12(:,34))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,34),G0H8(11),m3h12x8(:,28),heltab2x96(:,:,166))
  call Hloop_A_Q(ntryL,G0H8(11),56,0,G1H8(13),n2h8(75))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(167),h0tab(:,167),[49,4,2,8],[0,0,0,0],4,1,wf12(:,11))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,11),G0H8(11),m3h12x8(:,29),heltab2x96(:,:,167))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(168),h0tab(:,168),[49,2,4,8],[0,0,0,0],4,1,wf12(:,11))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,11),G0H8(12),m3h12x8(:,30),heltab2x96(:,:,168))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(169),h0tab(:,169),[50,4,1,8],[0,0,0,0],4,1,wf12(:,7))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,7),G0H8(13),m3h12x8(:,31),heltab2x96(:,:,169))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(170),h0tab(:,170),[50,1,4,8],[0,0,0,0],4,1,wf12(:,7))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,7),G0H8(14),m3h12x8(:,32),heltab2x96(:,:,170))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(171),h0tab(:,171),[56,2,1,4],[0,0,0,0],4,1,wf12(:,36))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,36),G0H8(15),m3h12x8(:,33),heltab2x96(:,:,171))
  call Hloop_A_Q(ntryL,G0H8(15),56,0,G1H8(31),n2h8(76))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(172),h0tab(:,172),[56,1,2,4],[0,0,0,0],4,1,wf12(:,36))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,36),G0H8(15),m3h12x8(:,34),heltab2x96(:,:,172))
  call Hloop_A_Q(ntryL,G0H8(15),56,0,G1H8(32),n2h8(77))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(173),h0tab(:,173),[56,1,4,2],[0,0,0,0],4,1,wf12(:,36))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,36),G0H8(15),m3h12x8(:,35),heltab2x96(:,:,173))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(174),h0tab(:,174),[56,1,4,2],[0,0,0,0],4,1,wf12(:,36))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,36),G0H8(16),m3h12x8(:,36),heltab2x96(:,:,174))
  call Hloop_A_Q(ntryL,G0H8(16),56,0,G1H8(33),n2h8(78))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(11),[G0H8(6),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(12),[G0H8(7),G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(13),[G0H8(8),G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(14),[G0H8(9),G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(20),G1H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(14),G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(15),[G0H8(10),G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(33),[G1H8(13),G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(8)])
  call Hloop_AV_Q(ntryL,G1H8(9),ex5(:),G1H4(78),m3h2x4(:,78),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(78),53,0,G2H4(20),n2h4(64))
  call Hloop_AV_Q(ntryL,G1H8(10),ex5(:),G1H4(89),m3h2x4(:,79),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(89),54,0,G2H4(2),n2h4(65))
  call Hloop_QA_V(ntryL,G1H32(1),ex4(:),G1H16(20),m3h2x16(:,39),heltab2x32(:,:,45))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,1),G1H8(34),m3h4x8(:,7),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(34),37,0,G2H8(4),n2h8(79))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,1),G1H8(37),m3h4x8(:,8),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(37),37,0,G2H8(5),n2h8(80))
  call Hloop_AQ_V(ntryL,G1H32(4),ex2(:),G1H16(21),m3h2x16(:,40),heltab2x32(:,:,48))
  call Hloop_AQ_V(ntryL,G1H32(5),ex2(:),G1H16(22),m3h2x16(:,41),heltab2x32(:,:,49))
  call Hloop_AV_Q(ntryL,G1H32(6),wf4(:,1),G1H8(38),m3h4x8(:,9),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(38),37,0,G2H8(8),n2h8(81))
  call Hloop_UV_W(ntryL,G0H16(14),34,wf4(:,1),5,G1H4(7),m3h4x4(:,9),heltab2x16(:,:,59))
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,1),G1H4(8),m3h4x4(:,10),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(8),39,0,G2H4(29),n2h4(66))
  call Hloop_VA_Q(ntryL,G0H16(2),ex4(:),G0H8(16),m3h2x8(:,51),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G0H8(16),42,0,G1H8(20),n2h8(82))
  call Hloop_UV_W(ntryL,G0H16(3),40,wf4(:,1),5,G1H4(29),m3h4x4(:,11),heltab2x16(:,:,62))
  call Hloop_VQ_A(ntryL,G0H16(4),ex2(:),G0H8(6),m3h2x8(:,52),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G0H8(6),42,0,G1H8(29),n2h8(83))
  call Hloop_VQ_A(ntryL,G0H16(5),ex2(:),G0H8(1),m3h2x8(:,53),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G0H8(1),42,0,G1H8(14),n2h8(84))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,1),G1H4(5),m3h4x4(:,12),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(5),53,0,G2H4(30),n2h4(67))
  call Hloop_AQ_V(ntryL,G1H16(3),ex2(:),G1H8(11),m3h2x8(:,54),heltab2x16(:,:,66))
  call Hloop_AQ_V(ntryL,G1H16(4),ex2(:),G1H8(13),m3h2x8(:,55),heltab2x16(:,:,67))
  call Hloop_AQ_V(ntryL,G1H32(7),wf8(:,4),G1H4(9),m3h8x4(:,1),heltab2x32(:,:,51))
  call Hloop_QA_V(ntryL,G1H32(8),ex4(:),G1H16(23),m3h2x16(:,42),heltab2x32(:,:,52))
  call Hloop_QA_V(ntryL,G1H32(9),wf8(:,2),G1H4(17),m3h8x4(:,2),heltab2x32(:,:,53))
  call Hloop_AQ_V(ntryL,G1H32(10),ex2(:),G1H16(24),m3h2x16(:,43),heltab2x32(:,:,54))
  call Hloop_AV_Q(ntryL,G1H32(11),wf4(:,7),G1H8(18),m3h4x8(:,10),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(18),38,0,G2H8(6),n2h8(85))
  call Hloop_QA_V(ntryL,G1H32(12),ex4(:),G1H16(25),m3h2x16(:,44),heltab2x32(:,:,56))
  call Hloop_QV_A(ntryL,G1H32(13),wf4(:,7),G1H8(23),m3h4x8(:,11),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(23),38,0,G2H8(7),n2h8(86))
  call Hloop_AQ_V(ntryL,G1H32(14),ex1(:),G1H16(26),m3h2x16(:,45),heltab2x32(:,:,58))
  call Hloop_AQ_V(ntryL,G1H32(15),ex1(:),G1H16(27),m3h2x16(:,46),heltab2x32(:,:,59))
  call Hloop_AV_Q(ntryL,G1H32(16),wf4(:,7),G1H8(24),m3h4x8(:,12),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(24),38,0,G2H8(9),n2h8(87))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,7),G1H4(23),m3h4x4(:,13),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(23),39,0,G2H4(31),n2h4(68))
  call Hloop_UV_W(ntryL,G0H16(10),33,wf4(:,7),6,G1H4(27),m3h4x4(:,14),heltab2x16(:,:,69))
  call Hloop_VA_Q(ntryL,G0H16(11),ex4(:),G0H8(7),m3h2x8(:,56),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G0H8(7),41,0,G1H8(1),n2h8(88))
  call Hloop_UV_W(ntryL,G0H16(12),40,wf4(:,7),6,G1H4(26),m3h4x4(:,15),heltab2x16(:,:,71))
  call Hloop_VQ_A(ntryL,G0H16(13),ex1(:),G0H8(2),m3h2x8(:,57),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G0H8(2),41,0,G1H8(6),n2h8(89))
  call Hloop_VQ_A(ntryL,G0H16(1),ex1(:),G0H8(8),m3h2x8(:,58),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G0H8(8),41,0,G1H8(7),n2h8(90))
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,7),G1H4(4),m3h4x4(:,16),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(4),54,0,G2H4(32),n2h4(69))
  call Hloop_AQ_V(ntryL,G1H16(7),ex1(:),G1H8(8),m3h2x8(:,59),heltab2x16(:,:,75))
  call Hloop_AQ_V(ntryL,G1H16(8),ex1(:),G1H8(9),m3h2x8(:,60),heltab2x16(:,:,76))
  call Hloop_AQ_V(ntryL,G1H32(17),wf8(:,8),G1H4(25),m3h8x4(:,3),heltab2x32(:,:,61))
  call Hloop_QA_V(ntryL,G1H32(18),ex4(:),G1H16(28),m3h2x16(:,47),heltab2x32(:,:,62))
  call Hloop_QA_V(ntryL,G1H32(19),wf8(:,6),G1H4(50),m3h8x4(:,4),heltab2x32(:,:,63))
  call Hloop_AQ_V(ntryL,G1H32(20),ex1(:),G1H16(29),m3h2x16(:,48),heltab2x32(:,:,64))
  call Hloop_QA_V(ntryL,G1H16(9),ex4(:),G1H8(10),m3h2x8(:,61),heltab2x16(:,:,77))
  call Hloop_VA_Q(ntryL,G0H16(6),ex3(:),G0H8(3),m3h2x8(:,62),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G0H8(3),38,0,G1H8(34),n2h8(91))
  call Hloop_VA_Q(ntryL,G0H16(7),ex3(:),G0H8(9),m3h2x8(:,63),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H8(9),44,0,G1H8(37),n2h8(92))
  call Hloop_VQ_A(ntryL,G0H16(8),ex2(:),G0H8(4),m3h2x8(:,64),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G0H8(4),42,0,G1H8(38),n2h8(93))
  call Hloop_AQ_V(ntryL,G1H16(10),ex2(:),G1H8(18),m3h2x8(:,65),heltab2x16(:,:,81))
  call Hloop_AQ_V(ntryL,G1H16(11),ex2(:),G1H8(23),m3h2x8(:,66),heltab2x16(:,:,82))
  call Hloop_AQ_V(ntryL,G1H32(21),ex2(:),G1H16(30),m3h2x16(:,49),heltab2x32(:,:,65))
  call Hloop_QA_V(ntryL,G1H32(22),ex4(:),G1H16(31),m3h2x16(:,50),heltab2x32(:,:,66))
  call Hloop_AQ_V(ntryL,G1H32(23),ex2(:),G1H16(32),m3h2x16(:,51),heltab2x32(:,:,67))
  call Hloop_VA_Q(ntryL,G0H8(11),ex3(:),G0H4(1),m3h2x4(:,80),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G0H4(1),53,0,G1H4(53),n2h4(70))
  call Hloop_VQ_A(ntryL,G0H8(12),ex2(:),G0H4(1),m3h2x4(:,81),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(54),n2h4(71))
  call Hloop_QA_V(ntryL,G1H16(12),ex4(:),G1H8(24),m3h2x8(:,67),heltab2x16(:,:,83))
  call Hloop_VA_Q(ntryL,G0H16(9),ex3(:),G0H8(10),m3h2x8(:,68),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G0H8(10),37,0,G1H8(39),n2h8(94))
  call Hloop_VA_Q(ntryL,G0H16(15),ex3(:),G0H8(5),m3h2x8(:,69),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G0H8(5),44,0,G1H8(40),n2h8(95))
  call Hloop_VQ_A(ntryL,G0H16(16),ex1(:),G0H8(16),m3h2x8(:,70),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G0H8(16),41,0,G1H8(41),n2h8(96))
  call Hloop_AQ_V(ntryL,G1H16(13),ex1(:),G1H8(42),m3h2x8(:,71),heltab2x16(:,:,87))
  call Hloop_AQ_V(ntryL,G1H16(14),ex1(:),G1H8(43),m3h2x8(:,72),heltab2x16(:,:,88))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(33),m3h2x16(:,52),heltab2x32(:,:,68))
  call Hloop_QA_V(ntryL,G1H32(25),ex4(:),G1H16(1),m3h2x16(:,53),heltab2x32(:,:,69))
  call Hloop_AQ_V(ntryL,G1H32(26),ex1(:),G1H16(2),m3h2x16(:,54),heltab2x32(:,:,70))
  call Hloop_VA_Q(ntryL,G0H8(13),ex3(:),G0H4(1),m3h2x4(:,82),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G0H4(1),54,0,G1H4(57),n2h4(72))
  call Hloop_VQ_A(ntryL,G0H8(14),ex1(:),G0H4(1),m3h2x4(:,83),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(36),n2h4(73))
  call Hloop_QA_V(ntryL,G1H16(15),ex4(:),G1H8(44),m3h2x8(:,73),heltab2x16(:,:,89))
  call Hloop_VQ_A(ntryL,G0H16(17),ex2(:),G0H8(6),m3h2x8(:,74),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G0H8(6),35,0,G1H8(45),n2h8(97))
  call Hloop_QA_V(ntryL,G1H16(16),ex4(:),G1H8(46),m3h2x8(:,75),heltab2x16(:,:,91))
  call Hloop_VQ_A(ntryL,G0H16(18),ex1(:),G0H8(1),m3h2x8(:,76),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G0H8(1),35,0,G1H8(47),n2h8(98))
  call Hloop_AQ_V(ntryL,G1H16(17),ex2(:),G1H8(48),m3h2x8(:,77),heltab2x16(:,:,93))
  call Hloop_AQ_V(ntryL,G1H16(18),ex1(:),G1H8(49),m3h2x8(:,78),heltab2x16(:,:,94))
  call Hloop_VQ_A(ntryL,G0H16(19),ex1(:),G0H8(7),m3h2x8(:,79),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G0H8(7),41,0,G1H8(50),n2h8(99))
  call Hloop_AQ_V(ntryL,G1H16(19),ex1(:),G1H8(51),m3h2x8(:,80),heltab2x16(:,:,96))
  call Hloop_AQ_V(ntryL,G1H32(27),ex2(:),G1H16(3),m3h2x16(:,55),heltab2x32(:,:,71))
  call Hloop_QA_V(ntryL,G1H32(28),ex4(:),G1H16(4),m3h2x16(:,56),heltab2x32(:,:,72))
  call Hloop_AQ_V(ntryL,G1H32(29),ex2(:),G1H16(5),m3h2x16(:,57),heltab2x32(:,:,73))
  call Hloop_AQ_V(ntryL,G1H32(30),ex1(:),G1H16(6),m3h2x16(:,58),heltab2x32(:,:,74))
  call Hloop_QA_V(ntryL,G1H32(31),ex4(:),G1H16(7),m3h2x16(:,59),heltab2x32(:,:,75))
  call Hloop_AQ_V(ntryL,G1H32(32),ex1(:),G1H16(8),m3h2x16(:,60),heltab2x32(:,:,76))
  call Hloop_VQ_A(ntryL,G0H16(20),ex2(:),G0H8(2),m3h2x8(:,81),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G0H8(2),35,0,G1H8(52),n2h8(100))
  call Hloop_VA_Q(ntryL,G0H16(21),ex3(:),G0H8(8),m3h2x8(:,82),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G0H8(8),37,0,G1H8(53),n2h8(101))
  call Hloop_VQ_A(ntryL,G0H16(22),ex1(:),G0H8(3),m3h2x8(:,83),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G0H8(3),35,0,G1H8(54),n2h8(102))
  call Hloop_VA_Q(ntryL,G0H16(23),ex3(:),G0H8(9),m3h2x8(:,84),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G0H8(9),38,0,G1H8(55),n2h8(103))
  call Hloop_AQ_V(ntryL,G1H8(31),ex2(:),G1H4(40),m3h2x4(:,84),heltab2x8(:,:,102))
  call Hloop_AQ_V(ntryL,G1H8(32),ex1(:),G1H4(62),m3h2x4(:,85),heltab2x8(:,:,103))
  call Hloop_VQ_A(ntryL,G0H8(15),ex1(:),G0H4(1),m3h2x4(:,86),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G0H4(1),57,0,G1H4(65),n2h4(74))
  call Hloop_AQ_V(ntryL,G1H8(33),ex1(:),G1H4(66),m3h2x4(:,87),heltab2x8(:,:,105))
  call Hloop_QA_V(ntryL,G1H8(25),ex3(:),G1H4(67),m3h2x4(:,88),heltab2x8(:,:,106))
  call Hloop_AQ_V(ntryL,G1H8(28),ex2(:),G1H4(68),m3h2x4(:,89),heltab2x8(:,:,107))
  call Hloop_VQ_A(ntryL,G1H8(3),ex2(:),G1H4(71),m3h2x4(:,90),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(71),43,0,G2H4(33),n2h4(75))
  call Hloop_QA_V(ntryL,G1H8(4),ex3(:),G1H4(1),m3h2x4(:,91),heltab2x8(:,:,109))
  call Hloop_AQ_V(ntryL,G1H8(15),ex1(:),G1H4(73),m3h2x4(:,92),heltab2x8(:,:,110))
  call Hloop_VQ_A(ntryL,G1H8(22),ex1(:),G1H4(74),m3h2x4(:,93),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(74),43,0,G2H4(34),n2h4(76))
call HGT_lower_alpha_w2_OLR(G2H4(35),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(35),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(35),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G1H4(18)])
call HGT_lower_alpha_w2_OLR(G2H4(40),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(40),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(40),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(64),G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(9),G1H4(58),G1H4(55),G1H4(52),G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(70),G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(35)])
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(150),mass4set(:,1),  & 
G1H4(79),G1H4(80),G1H4(84),G1H4(85),G1H4(90),4)
  call HG1shiftOLR(G1H4(80),2,4)
  call Hloop_AQ_V(ntryL,G2H4(36),ex2(:),G2H2(2),m3h2x2(:,114),heltab2x4(:,:,146))
  call Hotf_4pt_reduction(G2H4(40),RedSet_4(153),mass4set(:,1),  & 
G1H4(91),G1H4(78),G1H4(89),G1H4(8),G1H4(5),4)
  call HG1shiftOLR(G1H4(78),1,4)
  call Hloop_AQ_V(ntryL,G2H4(41),ex1(:),G2H2(4),m3h2x2(:,115),heltab2x4(:,:,147))
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(142),mass4set(:,1),  & 
G1H4(23),G1H4(4),G1H4(71),G1H4(74),G1H4(18),4)
  call HG1shiftOLR(G1H4(4),4,4)
  call Hloop_QV_A(ntryL,G1H4(6),ex5(:),G1H2(82),m3h2x2(:,116),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(82),59,0,G2H2(6),n2h2(78))
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(146),mass4set(:,1),  & 
G1H4(35),G1H4(38),G1H4(42),G1H4(2),G1H4(21),4)
  call HG1shiftOLR(G1H4(38),4,4)
  call Hloop_AV_Q(ntryL,G1H4(14),ex5(:),G1H2(106),m3h2x2(:,117),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(106),61,0,G2H2(8),n2h2(79))
  call Hloop_AV_Q(ntryL,G1H4(10),ex5(:),G1H2(160),m3h2x2(:,118),heltab2x4(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(160),62,0,G2H2(11),n2h2(80))
  call Hloop_VQ_A(ntryL,G1H4(29),ex2(:),G1H2(178),m3h2x2(:,119),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(178),47,0,G2H2(48),n2h2(81))
  call Hloop_VQ_A(ntryL,G1H4(17),ex2(:),G1H2(202),m3h2x2(:,120),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(202),47,0,G2H2(49),n2h2(82))
  call Hloop_VA_Q(ntryL,G1H4(7),ex4(:),G1H2(220),m3h2x2(:,121),heltab2x4(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(220),47,0,G2H2(23),n2h2(83))
  call Hloop_VA_Q(ntryL,G1H4(25),ex4(:),G1H2(238),m3h2x2(:,122),heltab2x4(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(238),47,0,G2H2(50),n2h2(84))
  call Hloop_VQ_A(ntryL,G1H4(26),ex1(:),G1H2(250),m3h2x2(:,123),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(250),47,0,G2H2(29),n2h2(85))
  call Hloop_VQ_A(ntryL,G1H4(50),ex1(:),G1H2(274),m3h2x2(:,124),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(274),47,0,G2H2(51),n2h2(86))
  call Hloop_VA_Q(ntryL,G1H4(27),ex4(:),G1H2(298),m3h2x2(:,125),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(298),47,0,G2H2(46),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H4(24),ex4(:),G1H2(350),m3h2x2(:,126),heltab2x4(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(350),47,0,G2H2(45),n2h2(88))
  call Hloop_VA_Q(ntryL,G1H4(19),ex4(:),G1H2(361),m3h2x2(:,127),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(361),47,0,G2H2(44),n2h2(89))
  call Hloop_VQ_A(ntryL,G1H4(63),ex2(:),G1H2(377),m3h2x2(:,128),heltab2x4(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(377),47,0,G2H2(43),n2h2(90))
  call Hloop_AV_Q(ntryL,G1H8(12),ex5(:),G1H4(64),m3h2x4(:,94),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(64),58,0,G2H4(37),n2h4(77))
  call Hloop_AV_Q(ntryL,G1H8(17),ex5(:),G1H4(47),m3h2x4(:,95),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(47),58,0,G2H4(38),n2h4(78))
  call Hloop_AV_Q(ntryL,G1H8(20),wf4(:,1),G1H2(388),m3h4x2(:,19),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(388),47,0,G2H2(10),n2h2(91))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,1),G1H2(1),m3h4x2(:,20),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(17),n2h2(92))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,1),G1H2(2),m3h4x2(:,21),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(13),n2h2(93))
  call Hloop_QV_A(ntryL,G1H8(27),wf4(:,1),G1H2(19),m3h4x2(:,22),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(14),n2h2(94))
  call Hloop_VQ_A(ntryL,G1H4(69),ex1(:),G1H2(20),m3h2x2(:,129),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(16),n2h2(95))
  call Hloop_AV_Q(ntryL,G1H8(16),ex5(:),G1H4(39),m3h2x4(:,96),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(39),57,0,G2H4(39),n2h4(79))
  call Hloop_AV_Q(ntryL,G1H8(21),ex5(:),G1H4(9),m3h2x4(:,97),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H4(9),57,0,G2H4(42),n2h4(80))
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,7),G1H2(25),m3h4x2(:,23),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(25),47,0,G2H2(19),n2h2(96))
  call Hloop_AV_Q(ntryL,G1H8(30),wf4(:,7),G1H2(37),m3h4x2(:,24),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(37),47,0,G2H2(20),n2h2(97))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,7),G1H2(38),m3h4x2(:,25),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(38),47,0,G2H2(22),n2h2(98))
  call Hloop_QV_A(ntryL,G1H8(36),wf4(:,7),G1H2(44),m3h4x2(:,26),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(113),n2h2(99))
  call Hloop_AQ_V(ntryL,G2H4(20),ex2(:),G2H2(25),m3h2x2(:,130),heltab2x4(:,:,162))
  call Hloop_AQ_V(ntryL,G2H4(2),ex1(:),G2H2(26),m3h2x2(:,131),heltab2x4(:,:,163))
  call Hloop_UV_W(ntryL,G1H16(20),40,wf4(:,1),5,G2H4(43),m3h4x4(:,17),heltab2x16(:,:,101))
  call Hloop_AQ_V(ntryL,G2H8(4),wf4(:,3),G2H2(28),m3h4x2(:,27),heltab2x8(:,:,124))
  call Hloop_QA_V(ntryL,G2H8(5),ex4(:),G2H4(6),m3h2x4(:,98),heltab2x8(:,:,125))
  call Hloop_UV_W(ntryL,G1H16(21),34,wf4(:,1),5,G2H4(14),m3h4x4(:,18),heltab2x16(:,:,102))
  call Hloop_VA_Q(ntryL,G1H16(22),wf4(:,5),G1H4(58),m3h4x4(:,19),heltab2x16(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(58),58,0,G2H4(7),n2h4(81))
  call Hloop_AQ_V(ntryL,G2H8(8),ex2(:),G2H4(18),m3h2x4(:,99),heltab2x8(:,:,126))
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(200),mass4set(:,1),  & 
G1H4(55),G1H4(52),G1H4(45),G1H4(22),G1H4(70),4)
  call HG1shiftOLR(G1H4(52),8,4)
  call Hloop_QV_A(ntryL,G1H8(29),ex5(:),G1H4(30),m3h2x4(:,100),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(30),58,0,G2H4(25),n2h4(82))
  call Hloop_AQ_V(ntryL,G2H4(30),ex2(:),G2H2(102),m3h2x2(:,132),heltab2x4(:,:,164))
  call Hloop_VA_Q(ntryL,G1H8(11),ex4(:),G1H4(51),m3h2x4(:,101),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(51),58,0,G2H4(22),n2h4(83))
  call Hloop_UV_W(ntryL,G1H8(13),50,wf4(:,1),5,G2H2(31),m3h4x2(:,28),heltab2x8(:,:,129))
  call Hloop_VQ_A(ntryL,G1H16(23),wf8(:,4),G1H2(61),m3h8x2(:,1),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(61),47,0,G2H2(32),n2h2(100))
  call Hloop_VA_Q(ntryL,G1H16(24),wf8(:,2),G1H2(62),m3h8x2(:,2),heltab2x16(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(62),47,0,G2H2(38),n2h2(101))
  call Hloop_AQ_V(ntryL,G2H8(6),wf4(:,8),G2H2(39),m3h4x2(:,29),heltab2x8(:,:,130))
  call Hloop_UV_W(ntryL,G1H16(25),40,wf4(:,7),6,G2H4(8),m3h4x4(:,20),heltab2x16(:,:,106))
  call Hloop_QA_V(ntryL,G2H8(7),ex4(:),G2H4(21),m3h2x4(:,102),heltab2x8(:,:,131))
  call Hloop_UV_W(ntryL,G1H16(26),33,wf4(:,7),6,G2H4(26),m3h4x4(:,21),heltab2x16(:,:,107))
  call Hloop_VA_Q(ntryL,G1H16(27),wf4(:,5),G1H4(6),m3h4x4(:,22),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(6),57,0,G2H4(11),n2h4(84))
  call Hloop_AQ_V(ntryL,G2H8(9),ex1(:),G2H4(27),m3h2x4(:,103),heltab2x8(:,:,132))
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(201),mass4set(:,1),  & 
G1H4(14),G1H4(10),G1H4(29),G1H4(17),G1H4(7),4)
  call HG1shiftOLR(G1H4(10),8,4)
  call Hloop_QV_A(ntryL,G1H8(6),ex5(:),G1H4(25),m3h2x4(:,104),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(25),57,0,G2H4(15),n2h4(85))
  call Hloop_AQ_V(ntryL,G2H4(32),ex1(:),G2H2(1),m3h2x2(:,133),heltab2x4(:,:,165))
  call Hloop_VA_Q(ntryL,G1H8(8),ex4(:),G1H4(26),m3h2x4(:,105),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(26),57,0,G2H4(28),n2h4(86))
  call Hloop_UV_W(ntryL,G1H8(9),49,wf4(:,7),6,G2H2(40),m3h4x2(:,30),heltab2x8(:,:,135))
  call Hloop_VQ_A(ntryL,G1H16(28),wf8(:,8),G1H2(68),m3h8x2(:,3),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(68),47,0,G2H2(3),n2h2(102))
  call Hloop_VA_Q(ntryL,G1H16(29),wf8(:,6),G1H2(24),m3h8x2(:,4),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(24),47,0,G2H2(41),n2h2(103))
  call Hloop_VA_Q(ntryL,G1H8(10),ex3(:),G1H4(50),m3h2x4(:,106),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(50),46,0,G2H4(19),n2h4(87))
  call Hloop_AQ_V(ntryL,G1H8(34),wf4(:,8),G1H2(42),m3h4x2(:,31),heltab2x8(:,:,137))
  call Hloop_AQ_V(ntryL,G1H8(37),ex2(:),G1H4(27),m3h2x4(:,107),heltab2x8(:,:,138))
  call Hloop_QA_V(ntryL,G1H8(38),ex3(:),G1H4(24),m3h2x4(:,108),heltab2x8(:,:,139))
  call Hloop_VA_Q(ntryL,G1H8(18),ex3(:),G1H4(19),m3h2x4(:,109),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(19),46,0,G2H4(23),n2h4(88))
  call Hloop_VQ_A(ntryL,G1H8(23),wf4(:,8),G1H2(30),m3h4x2(:,32),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(30),59,0,G2H2(52),n2h2(104))
  call Hloop_VA_Q(ntryL,G1H16(30),ex4(:),G1H8(31),m3h2x8(:,85),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(31),42,0,G2H8(10),n2h8(104))
  call Hloop_VQ_A(ntryL,G1H16(31),ex2(:),G1H8(32),m3h2x8(:,86),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(32),42,0,G2H8(13),n2h8(105))
  call Hloop_UV_W(ntryL,G1H16(32),34,wf8(:,9),21,G2H2(5),m3h8x2(:,5),heltab2x16(:,:,113))
  call Hloop_AQ_V(ntryL,G1H4(53),ex2(:),G1H2(60),m3h2x2(:,134),heltab2x4(:,:,166))
  call Hloop_QA_V(ntryL,G1H4(54),ex3(:),G1H2(66),m3h2x2(:,135),heltab2x4(:,:,167))
  call Hloop_VA_Q(ntryL,G1H8(24),ex3(:),G1H4(63),m3h2x4(:,110),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G1H4(63),45,0,G2H4(10),n2h4(89))
  call Hloop_AQ_V(ntryL,G1H8(39),wf4(:,3),G1H2(72),m3h4x2(:,33),heltab2x8(:,:,143))
  call Hloop_AQ_V(ntryL,G1H8(40),ex1(:),G1H4(64),m3h2x4(:,111),heltab2x8(:,:,144))
  call Hloop_QA_V(ntryL,G1H8(41),ex3(:),G1H4(47),m3h2x4(:,112),heltab2x8(:,:,145))
  call Hloop_VA_Q(ntryL,G1H8(42),ex3(:),G1H4(69),m3h2x4(:,113),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(69),45,0,G2H4(24),n2h4(90))
  call Hloop_VQ_A(ntryL,G1H8(43),wf4(:,3),G1H2(5),m3h4x2(:,34),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(5),59,0,G2H2(42),n2h2(105))
  call Hloop_VA_Q(ntryL,G1H16(33),ex4(:),G1H8(33),m3h2x8(:,87),heltab2x16(:,:,114))
  call Hloop_A_Q(ntryL,G1H8(33),41,0,G2H8(14),n2h8(106))
  call Hloop_VQ_A(ntryL,G1H16(1),ex1(:),G1H8(25),m3h2x8(:,88),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(25),41,0,G2H8(15),n2h8(107))
  call Hloop_UV_W(ntryL,G1H16(2),33,wf8(:,10),22,G2H2(55),m3h8x2(:,6),heltab2x16(:,:,116))
  call Hloop_AQ_V(ntryL,G1H4(57),ex1(:),G1H2(9),m3h2x2(:,136),heltab2x4(:,:,168))
  call Hloop_QA_V(ntryL,G1H4(36),ex3(:),G1H2(11),m3h2x2(:,137),heltab2x4(:,:,169))
  call Hloop_VQ_A(ntryL,G1H8(44),ex2(:),G1H4(39),m3h2x4(:,114),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(39),43,0,G2H4(4),n2h4(91))
  call Hloop_QA_V(ntryL,G1H8(45),wf4(:,10),G1H2(21),m3h4x2(:,35),heltab2x8(:,:,149))
  call Hloop_VQ_A(ntryL,G1H8(46),ex1(:),G1H4(9),m3h2x4(:,115),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(9),43,0,G2H4(9),n2h4(92))
  call Hloop_QA_V(ntryL,G1H8(47),wf4(:,10),G1H2(22),m3h4x2(:,36),heltab2x8(:,:,151))
  call Hloop_VQ_A(ntryL,G1H8(48),ex1(:),G1H4(58),m3h2x4(:,116),heltab2x8(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(58),43,0,G2H4(13),n2h4(93))
  call Hloop_VQ_A(ntryL,G1H8(49),ex2(:),G1H4(30),m3h2x4(:,117),heltab2x8(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(30),43,0,G2H4(35),n2h4(94))
  call Hloop_QA_V(ntryL,G1H8(50),wf4(:,10),G1H2(23),m3h4x2(:,37),heltab2x8(:,:,154))
  call Hloop_VA_Q(ntryL,G1H8(51),wf4(:,10),G1H2(29),m3h4x2(:,38),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(29),61,0,G2H2(7),n2h2(106))
  call Hloop_VA_Q(ntryL,G1H16(3),ex4(:),G1H8(28),m3h2x8(:,89),heltab2x16(:,:,117))
  call Hloop_A_Q(ntryL,G1H8(28),42,0,G2H8(16),n2h8(108))
  call Hloop_VQ_A(ntryL,G1H16(4),ex2(:),G1H8(3),m3h2x8(:,90),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(3),42,0,G2H8(17),n2h8(109))
  call Hloop_UV_W(ntryL,G1H16(5),34,wf8(:,12),21,G2H2(9),m3h8x2(:,7),heltab2x16(:,:,119))
  call Hloop_VA_Q(ntryL,G1H16(6),ex4(:),G1H8(4),m3h2x8(:,91),heltab2x16(:,:,120))
  call Hloop_A_Q(ntryL,G1H8(4),41,0,G2H8(18),n2h8(110))
  call Hloop_VQ_A(ntryL,G1H16(7),ex1(:),G1H8(15),m3h2x8(:,92),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G1H8(15),41,0,G2H8(19),n2h8(111))
  call Hloop_UV_W(ntryL,G1H16(8),33,wf8(:,11),22,G2H2(12),m3h8x2(:,8),heltab2x16(:,:,122))
  call Hloop_QA_V(ntryL,G1H8(52),ex3(:),G1H4(51),m3h2x4(:,118),heltab2x8(:,:,156))
  call Hloop_AQ_V(ntryL,G1H8(53),ex2(:),G1H4(6),m3h2x4(:,119),heltab2x8(:,:,157))
  call Hloop_QA_V(ntryL,G1H8(54),ex3(:),G1H4(25),m3h2x4(:,120),heltab2x8(:,:,158))
  call Hloop_AQ_V(ntryL,G1H8(55),ex1(:),G1H4(26),m3h2x4(:,121),heltab2x8(:,:,159))
  call Hloop_VQ_A(ntryL,G1H4(40),ex1(:),G1H2(33),m3h2x2(:,138),heltab2x4(:,:,170))
  call Hloop_Q_A(ntryL,G1H2(33),59,0,G2H2(70),n2h2(107))
  call Hloop_VQ_A(ntryL,G1H4(62),ex2(:),G1H2(46),m3h2x2(:,139),heltab2x4(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(46),59,0,G2H2(15),n2h2(108))
  call Hloop_QA_V(ntryL,G1H4(65),ex3(:),G1H2(39),m3h2x2(:,140),heltab2x4(:,:,172))
  call Hloop_VA_Q(ntryL,G1H4(66),ex3(:),G1H2(40),m3h2x2(:,141),heltab2x4(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(40),61,0,G2H2(18),n2h2(109))
  call Hloop_VQ_A(ntryL,G1H4(67),ex2(:),G1H2(65),m3h2x2(:,142),heltab2x4(:,:,174))
  call Hloop_Q_A(ntryL,G1H2(65),47,0,G2H2(74),n2h2(110))
  call Hloop_VA_Q(ntryL,G1H4(68),ex3(:),G1H2(47),m3h2x2(:,143),heltab2x4(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(47),47,0,G2H2(21),n2h2(111))
  call Hloop_VQ_A(ntryL,G1H4(1),ex1(:),G1H2(51),m3h2x2(:,144),heltab2x4(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(51),47,0,G2H2(24),n2h2(112))
  call Hloop_VA_Q(ntryL,G1H4(73),ex3(:),G1H2(52),m3h2x2(:,145),heltab2x4(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(52),47,0,G2H2(78),n2h2(113))
  call Hloop_AV_Q(ntryL,G1H4(79),ex5(:),G1H2(64),m3h2x2(:,146),heltab2x4(:,:,178))
  call Hloop_A_Q(ntryL,G1H2(64),61,0,G2H2(27),n2h2(114))
call HGT_raise_alpha_OLR(G1H4(80),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(80),ex2(:),G1H2(69),m3h2x2(:,147),heltab2x4(:,:,179))
  call Hloop_AV_Q(ntryL,G1H4(85),ex5(:),G1H2(70),m3h2x2(:,148),heltab2x4(:,:,180))
  call Hloop_A_Q(ntryL,G1H2(70),61,0,G2H2(82),n2h2(115))
  call Hloop_AV_Q(ntryL,G1H4(90),ex5(:),G1H2(76),m3h2x2(:,149),heltab2x4(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(76),61,0,G2H2(30),n2h2(116))
  call Hloop_AV_Q(ntryL,G1H4(91),ex5(:),G1H2(77),m3h2x2(:,150),heltab2x4(:,:,182))
  call Hloop_A_Q(ntryL,G1H2(77),62,0,G2H2(33),n2h2(117))
call HGT_raise_alpha_OLR(G1H4(78),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(78),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(78),ex1(:),G1H2(78),m3h2x2(:,151),heltab2x4(:,:,183))
  call Hloop_AV_Q(ntryL,G1H4(8),ex5(:),G1H2(394),m3h2x2(:,152),heltab2x4(:,:,184))
  call Hloop_A_Q(ntryL,G1H2(394),62,0,G2H2(34),n2h2(118))
  call Hloop_AV_Q(ntryL,G1H4(5),ex5(:),G1H2(83),m3h2x2(:,153),heltab2x4(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(83),62,0,G2H2(86),n2h2(119))
  call Hloop_QV_A(ntryL,G1H4(23),ex5(:),G1H2(84),m3h2x2(:,154),heltab2x4(:,:,186))
  call Hloop_Q_A(ntryL,G1H2(84),59,0,G2H2(35),n2h2(120))
call HGT_raise_alpha_OLR(G1H4(4),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(4),ex3(:),G1H2(88),m3h2x2(:,155),heltab2x4(:,:,187))
  call Hloop_QV_A(ntryL,G1H4(74),ex5(:),G1H2(89),m3h2x2(:,156),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(89),59,0,G2H2(36),n2h2(121))
  call Hloop_QV_A(ntryL,G1H4(18),ex5(:),G1H2(90),m3h2x2(:,157),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(90),59,0,G2H2(37),n2h2(122))
  call Hloop_QV_A(ntryL,G1H4(35),ex5(:),G1H2(94),m3h2x2(:,158),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(94),59,0,G2H2(90),n2h2(123))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(38),ex3(:),G1H2(95),m3h2x2(:,159),heltab2x4(:,:,191))
  call Hloop_QV_A(ntryL,G1H4(2),ex5(:),G1H2(96),m3h2x2(:,160),heltab2x4(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(96),59,0,G2H2(47),n2h2(124))
  call Hloop_QV_A(ntryL,G1H4(21),ex5(:),G1H2(100),m3h2x2(:,161),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(100),59,0,G2H2(54),n2h2(125))
  call Hloop_QV_A(ntryL,G1H4(55),ex5(:),G1H2(101),m3h2x2(:,162),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(101),55,0,G2H2(57),n2h2(126))
call HGT_raise_alpha_OLR(G1H4(52),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(52),ex4(:),G1H2(102),m3h2x2(:,163),heltab2x4(:,:,195))
  call Hloop_QV_A(ntryL,G1H4(22),ex5(:),G1H2(367),m3h2x2(:,164),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(367),55,0,G2H2(58),n2h2(127))
  call Hloop_QV_A(ntryL,G1H4(70),ex5(:),G1H2(107),m3h2x2(:,165),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(107),55,0,G2H2(60),n2h2(128))
  call Hloop_QV_A(ntryL,G1H4(14),ex5(:),G1H2(108),m3h2x2(:,166),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(108),55,0,G2H2(61),n2h2(129))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(10),ex4(:),G1H2(112),m3h2x2(:,167),heltab2x4(:,:,199))
  call Hloop_QV_A(ntryL,G1H4(17),ex5(:),G1H2(113),m3h2x2(:,168),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(113),55,0,G2H2(63),n2h2(130))
  call Hloop_QV_A(ntryL,G1H4(7),ex5(:),G1H2(114),m3h2x2(:,169),heltab2x4(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(114),55,0,G2H2(64),n2h2(131))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(53),G1H2(159),G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(56),G1H2(177),G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(229),[G1H2(223)])
call HGT_w2_OLR(G1H2(43),1,1,2)
call HGT_w2_invQ_OLR(G1H2(43),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(193),[G1H2(187)])
call HGT_w2_OLR(G1H2(55),1,1,2)
call HGT_w2_invQ_OLR(G1H2(55),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(55),[G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(62)])
call HGT_w2_OLR(G1H2(67),1,1,2)
call HGT_w2_invQ_OLR(G1H2(67),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(65)])
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(54)])
call HGT_OLR(G2H2(71),1,1,2)
call HGT_invQ_OLR(G2H2(71),2,5,2)
call HGT_OLR(G2H2(71),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(32),G2H2(114),G2H2(103),G2H2(80),G2H2(72) &
    ,G1H2(237),G1H2(201),G1H2(105),G1H2(81),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(87),G1H2(17)])
call HGT_OLR(G2H2(75),1,1,2)
call HGT_invQ_OLR(G2H2(75),2,5,2)
call HGT_OLR(G2H2(75),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(100),G2H2(76),G1H2(360),G1H2(219),G1H2(93) &
    ,G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(99),[G1H2(35)])
call HGT_OLR(G2H2(79),1,1,2)
call HGT_invQ_OLR(G2H2(79),2,5,2)
call HGT_OLR(G2H2(79),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(111),G1H2(71)])
call HGT_OLR(G2H2(83),1,1,2)
call HGT_invQ_OLR(G2H2(83),2,5,2)
call HGT_OLR(G2H2(83),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(111),G2H2(84),G1H2(387),G1H2(249),G1H2(117) &
    ,G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(86)])
call HGT_OLR(G2H2(87),1,1,2)
call HGT_invQ_OLR(G2H2(87),2,5,2)
call HGT_OLR(G2H2(87),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G1H2(273),G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G1H2(110)])
call HGT_OLR(G2H2(91),1,1,2)
call HGT_invQ_OLR(G2H2(91),2,5,2)
call HGT_OLR(G2H2(91),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G2H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G1H2(297),G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G1H2(349)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(295),G1H2(289)])
call HGT_OLR(G2H2(98),1,1,2)
call HGT_invQ_OLR(G2H2(98),2,5,2)
call HGT_OLR(G2H2(98),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(1),G1H4(77)])
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G1H2(376)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(271),G1H2(265)])
call HGT_OLR(G2H2(109),1,1,2)
call HGT_invQ_OLR(G2H2(109),2,5,2)
call HGT_OLR(G2H2(109),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(12),G1H4(88)])
call HGT_OLR(G2H4(16),1,1,4)
call HGT_invQ_OLR(G2H4(16),2,5,4)
call HGT_OLR(G2H4(16),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(123),G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(129),[G1H2(31),G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G2H2(5),G1H2(183),G1H2(135),G1H2(18),G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(141),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(55),G1H2(165),G1H2(147),G1H2(56),G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(153),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(171),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(225),[G1H2(189),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(231),[G1H2(195),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(207),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(213),[G1H2(58),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(66),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(39),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G1H2(255),G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G1H2(261),G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(267),[G1H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(279),G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(285),G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(60),[G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(291),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(139),[G1H2(127),G1H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(133),[G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(146),[G1H2(134),G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(145),[G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(157),G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(163),[G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(164),G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(175),G1H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(181),[G1H2(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(182),G1H2(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(254),G1H2(199),G1H2(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G1H2(348),G1H2(260),G1H2(200),G1H2(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(241),[G1H2(211),G1H2(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(266),G1H2(217),G1H2(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G1H2(296),G1H2(272),G1H2(248),G1H2(218),G1H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(278),G1H2(235),G1H2(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(375),G1H2(284),G1H2(236),G1H2(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(290),G1H2(247),G1H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G1H2(259),G1H2(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(283),G1H2(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(41),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(20),G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(48),G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(43),G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(354),[G1H2(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(398),[G1H2(371),G1H2(329),G1H2(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(343),[G1H2(338),G1H2(333),G1H2(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(366),[G1H2(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(381),[G1H2(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(393),[G1H2(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(385)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(386)])
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(32),mass4set(:,1),  & 
G1H2(118),G1H2(119),G1H2(120),G1H2(124),G1H2(125),2)
  call HG1shiftOLR(G1H2(119),8,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(46),mass4set(:,1),  & 
G1H2(126),G1H2(130),G1H2(131),G1H2(132),G1H2(136),2)
  call HG1shiftOLR(G1H2(130),8,2)
  call Hloop_QV_A(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(233))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(52),ex3(:),G2tensor(4),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hloop_QV_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(234))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(42),ex3(:),G2tensor(8),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(202),mass4set(:,1),  & 
G1H2(137),G1H2(138),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(138),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(10),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(203),mass4set(:,1),  & 
G1H2(148),G1H2(149),G1H2(150),G1H2(154),G1H2(155),2)
  call HG1shiftOLR(G1H2(149),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(68),ex1(:),G2tensor(12),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hotf_4pt_reduction(G2H2(71),RedSet_4(157),mass4set(:,1),  & 
G1H2(156),G1H2(305),G1H2(161),G1H2(162),G1H2(166),2)
  call HG1shiftOLR(G1H2(305),2,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(63),mass4set(:,1),  & 
G1H2(167),G1H2(168),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(168),16,2)
  call Hotf_4pt_reduction(G2H2(75),RedSet_4(161),mass4set(:,1),  & 
G1H2(310),G1H2(179),G1H2(180),G1H2(184),G1H2(185),2)
  call HG1shiftOLR(G1H2(179),8,2)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(78),mass4set(:,1),  & 
G1H2(186),G1H2(190),G1H2(191),G1H2(192),G1H2(196),2)
  call HG1shiftOLR(G1H2(190),16,2)
  call Hotf_4pt_reduction(G2H2(79),RedSet_4(165),mass4set(:,1),  & 
G1H2(197),G1H2(198),G1H2(315),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(198),1,2)
  call Hotf_4pt_reduction(G2H2(83),RedSet_4(167),mass4set(:,1),  & 
G1H2(208),G1H2(209),G1H2(210),G1H2(214),G1H2(215),2)
  call HG1shiftOLR(G1H2(209),8,2)
  call Hotf_4pt_reduction(G2H2(41),RedSet_4(97),mass4set(:,1),  & 
G1H2(216),G1H2(320),G1H2(221),G1H2(222),G1H2(226),2)
  call HG1shiftOLR(G1H2(320),16,2)
  call Hotf_4pt_reduction(G2H2(87),RedSet_4(173),mass4set(:,1),  & 
G1H2(227),G1H2(228),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(228),8,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(116),mass4set(:,1),  & 
G1H2(325),G1H2(239),G1H2(240),G1H2(244),G1H2(245),2)
  call HG1shiftOLR(G1H2(239),16,2)
  call Hotf_4pt_reduction(G2H2(91),RedSet_4(179),mass4set(:,1),  & 
G1H2(246),G1H2(330),G1H2(251),G1H2(252),G1H2(256),2)
  call HG1shiftOLR(G1H2(330),8,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(134),mass4set(:,1),  & 
G1H2(257),G1H2(258),G1H2(262),G1H2(263),G1H2(264),2)
  call HG1shiftOLR(G1H2(258),16,2)
call HGT_OLR(G2H2(95),1,1,2)
call HGT_invQ_OLR(G2H2(95),2,5,2)
call HGT_OLR(G2H2(95),6,15,2)
  call Hotf_4pt_reduction(G2H2(95),RedSet_4(204),mass4set(:,1),  & 
G1H2(268),G1H2(269),G1H2(270),G1H2(335),G1H2(275),2)
  call HG1shiftOLR(G1H2(269),2,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(134),mass4set(:,1),  & 
G1H2(276),G1H2(280),G1H2(281),G1H2(282),G1H2(286),2)
  call HG1shiftOLR(G1H2(280),16,2)
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(130),mass4set(:,1),  & 
G1H2(287),G1H2(288),G1H2(292),G1H2(293),G1H2(294),2)
  call HG1shiftOLR(G1H2(288),16,2)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(188),mass4set(:,1),  & 
G1H4(50),G1H4(19),G1H4(53),G1H4(54),G1H4(63),4)
  call HG1shiftOLR(G1H4(19),5,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(205),mass4set(:,1),  & 
G1H4(69),G1H4(57),G1H4(36),G1H4(39),G1H4(9),4)
  call HG1shiftOLR(G1H4(57),5,4)
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(177),mass4set(:,1),  & 
G1H4(58),G1H4(30),G1H4(40),G1H4(62),G1H4(65),4)
  call HG1shiftOLR(G1H4(30),5,4)
call HGT_OLR(G2H2(106),1,1,2)
call HGT_invQ_OLR(G2H2(106),2,5,2)
call HGT_OLR(G2H2(106),6,15,2)
  call Hotf_4pt_reduction(G2H2(106),RedSet_4(206),mass4set(:,1),  & 
G1H2(340),G1H2(299),G1H2(300),G1H2(304),G1H2(306),2)
  call HG1shiftOLR(G1H2(299),1,2)
  call Hotf_4pt_reduction(G2H2(107),RedSet_4(116),mass4set(:,1),  & 
G1H2(311),G1H2(316),G1H2(321),G1H2(326),G1H2(331),2)
  call HG1shiftOLR(G1H2(316),16,2)
  call Hotf_4pt_reduction(G2H2(109),RedSet_4(112),mass4set(:,1),  & 
G1H2(336),G1H2(341),G1H2(345),G1H2(346),G1H2(351),2)
  call HG1shiftOLR(G1H2(341),16,2)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(196),mass4set(:,1),  & 
G1H4(66),G1H4(67),G1H4(68),G1H4(1),G1H4(73),4)
  call HG1shiftOLR(G1H4(67),6,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(207),mass4set(:,1),  & 
G1H4(79),G1H4(80),G1H4(85),G1H4(90),G1H4(91),4)
  call HG1shiftOLR(G1H4(80),6,4)
call HGT_OLR(G2H4(17),1,1,4)
call HGT_invQ_OLR(G2H4(17),2,5,4)
call HGT_OLR(G2H4(17),6,15,4)
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(171),mass4set(:,1),  & 
G1H4(78),G1H4(8),G1H4(5),G1H4(23),G1H4(4),4)
  call HG1shiftOLR(G1H4(8),6,4)
  call Hloop_VA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(235))
  call Hloop_VA_Q(ntryL,G1H2(129),ex4(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(16),n2h1(236))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(10),mass4set(:,1),  & 
G1H2(352),G1H2(356),G1H2(357),G1H2(362),G1H2(363),2)
  call HG1shiftOLR(G1H2(356),8,2)
  call Hloop_VA_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(18),n2h1(237))
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(20),mass4set(:,1),  & 
G1H2(368),G1H2(372),G1H2(373),G1H2(378),G1H2(379),2)
  call HG1shiftOLR(G1H2(372),8,2)
  call Hloop_VA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(20),n2h1(238))
  call Hloop_VA_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(239))
  call Hloop_VQ_A(ntryL,G1H2(36),ex2(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(240))
  call Hloop_VQ_A(ntryL,G1H2(48),ex2(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(241))
  call Hloop_QV_A(ntryL,G1H2(225),ex5(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(242))
  call Hloop_QV_A(ntryL,G1H2(231),ex5(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(243))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(244))
  call Hloop_VA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(245))
  call Hloop_AV_Q(ntryL,G1H2(207),ex5(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(246))
  call Hloop_AV_Q(ntryL,G1H2(213),ex5(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(247))
  call Hloop_VQ_A(ntryL,G1H2(34),ex1(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(48),n2h1(248))
  call Hloop_VQ_A(ntryL,G1H2(59),ex1(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(249))
  call Hloop_VA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(250))
  call Hloop_AV_Q(ntryL,G1H2(243),ex5(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(251))
  call Hloop_VQ_A(ntryL,G1H2(39),ex2(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(252))
  call Hloop_VQ_A(ntryL,G1H2(74),ex2(:),G1H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(253))
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(103),mass4set(:,1),  & 
G1H2(383),G1H2(384),G1H2(389),G1H2(390),G1H2(395),2)
  call HG1shiftOLR(G1H2(384),16,2)
  call Hotf_4pt_reduction(G2H2(113),RedSet_4(106),mass4set(:,1),  & 
G1H2(82),G1H2(106),G1H2(160),G1H2(178),G1H2(202),2)
  call HG1shiftOLR(G1H2(106),16,2)
  call Hloop_VA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(254))
  call Hloop_AV_Q(ntryL,G1H2(267),ex5(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(255))
  call Hloop_VQ_A(ntryL,G1H2(97),ex1(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(256))
  call Hloop_VQ_A(ntryL,G1H2(98),ex1(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(257))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(122),mass4set(:,1),  & 
G1H2(220),G1H2(238),G1H2(250),G1H2(274),G1H2(298),2)
  call HG1shiftOLR(G1H2(238),16,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(124),mass4set(:,1),  & 
G1H2(350),G1H2(361),G1H2(377),G1H2(388),G1H2(1),2)
  call HG1shiftOLR(G1H2(361),16,2)
  call Hloop_VA_Q(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(258))
  call Hloop_AV_Q(ntryL,G1H2(291),ex5(:),G1H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(259))
  call Hloop_VA_Q(ntryL,G1H2(139),ex4(:),G1H1(1),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(260))
  call Hloop_VA_Q(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(261))
  call Hloop_VA_Q(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(262))
  call Hloop_VA_Q(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(263))
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(26),mass4set(:,1),  & 
G1H2(2),G1H2(19),G1H2(20),G1H2(25),G1H2(37),2)
  call HG1shiftOLR(G1H2(19),8,2)
  call Hloop_VA_Q(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(264))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(31),mass4set(:,1),  & 
G1H2(38),G1H2(44),G1H2(61),G1H2(62),G1H2(68),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(40),mass4set(:,1),  & 
G1H2(24),G1H2(30),G1H2(5),G1H2(29),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hloop_VA_Q(ntryL,G1H2(181),ex4(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(265))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(45),mass4set(:,1),  & 
G1H2(46),G1H2(40),G1H2(65),G1H2(47),G1H2(51),2)
  call HG1shiftOLR(G1H2(40),8,2)
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(55),mass4set(:,1),  & 
G1H2(52),G1H2(64),G1H2(70),G1H2(76),G1H2(77),2)
  call HG1shiftOLR(G1H2(64),16,2)
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(59),mass4set(:,1),  & 
G1H2(394),G1H2(83),G1H2(84),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(83),16,2)
  call Hloop_AV_Q(ntryL,G1H2(241),ex5(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(108),n2h1(266))
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(70),mass4set(:,1),  & 
G1H2(94),G1H2(96),G1H2(100),G1H2(101),G1H2(367),2)
  call HG1shiftOLR(G1H2(96),16,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(74),mass4set(:,1),  & 
G1H2(107),G1H2(108),G1H2(113),G1H2(114),G1H2(159),2)
  call HG1shiftOLR(G1H2(108),16,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(84),mass4set(:,1),  & 
G1H2(50),G1H2(177),G1H2(12),G1H2(223),G1H2(229),2)
  call HG1shiftOLR(G1H2(177),16,2)
  call Hotf_4pt_reduction(G2H2(51),RedSet_4(87),mass4set(:,1),  & 
G1H2(187),G1H2(193),G1H2(67),G1H2(7),G1H2(54),2)
  call HG1shiftOLR(G1H2(193),16,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(93),mass4set(:,1),  & 
G1H2(75),G1H2(237),G1H2(201),G1H2(105),G1H2(81),2)
  call HG1shiftOLR(G1H2(237),16,2)
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(102),mass4set(:,1),  & 
G1H2(4),G1H2(87),G1H2(17),G1H2(360),G1H2(219),2)
  call HG1shiftOLR(G1H2(87),16,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(121),mass4set(:,1),  & 
G1H2(93),G1H2(53),G1H2(35),G1H2(99),G1H2(111),2)
  call HG1shiftOLR(G1H2(53),16,2)
  call Hloop_VQ_A(ntryL,G1H4(24),wf4(:,8),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(267))
  call Hloop_VQ_A(ntryL,G1H4(13),wf4(:,8),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(268))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(90),mass4set(:,1),  & 
G1H4(74),G1H4(18),G1H4(35),G1H4(38),G1H4(2),4)
  call HG1shiftOLR(G1H4(18),17,4)
  call Hloop_VQ_A(ntryL,G1H4(27),wf4(:,8),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(269))
  call Hloop_VQ_A(ntryL,G1H4(15),wf4(:,8),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(270))
  call Hloop_VQ_A(ntryL,G1H4(47),wf4(:,3),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(271))
  call Hloop_VQ_A(ntryL,G1H4(34),wf4(:,3),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,207))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(272))
  call Hotf_4pt_reduction(G2H4(43),RedSet_4(64),mass4set(:,1),  & 
G1H4(21),G1H4(55),G1H4(52),G1H4(22),G1H4(70),4)
  call HG1shiftOLR(G1H4(55),18,4)
  call Hloop_VQ_A(ntryL,G1H4(64),wf4(:,3),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(273))
  call Hloop_VQ_A(ntryL,G1H4(49),wf4(:,3),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(274))
  call Hloop_VA_Q(ntryL,G1H4(25),wf4(:,5),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(275))
  call Hloop_VA_Q(ntryL,G1H4(60),wf4(:,5),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(276))
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(79),mass4set(:,1),  & 
G1H4(14),G1H4(10),G1H4(17),G1H4(7),G1H4(77),4)
  call HG1shiftOLR(G1H4(10),24,4)
  call Hloop_VA_Q(ntryL,G1H4(51),wf4(:,5),G1H1(1),m3h4x1(:,43),heltab2x4(:,:,212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(277))
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(98),mass4set(:,1),  & 
G1H4(88),G1H4(12),G1H4(41),G1H4(3),G1H4(11),4)
  call HG1shiftOLR(G1H4(12),24,4)
  call Hloop_VA_Q(ntryL,G1H4(6),wf4(:,5),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(278))
  call Hotf_4pt_reduction(G2H4(18),RedSet_4(135),mass4set(:,1),  & 
G1H4(33),G1H4(20),G1H4(46),G1H4(16),G1H4(37),4)
  call HG1shiftOLR(G1H4(20),24,4)
  call Hloop_VA_Q(ntryL,G1H4(26),wf4(:,5),G1H1(1),m3h4x1(:,45),heltab2x4(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(279))
  call Hotf_4pt_reduction(G2H4(27),RedSet_4(117),mass4set(:,1),  & 
G1H4(28),G1H4(48),G1H4(56),G1H4(59),G1H4(43),4)
  call HG1shiftOLR(G1H4(48),24,4)
  call Hloop_VQ_A(ntryL,G1H2(301),ex2(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(280))
  call Hloop_VQ_A(ntryL,G1H2(302),ex2(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(281))
  call Hloop_VQ_A(ntryL,G1H2(23),ex2(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(282))
  call Hloop_VA_Q(ntryL,G1H2(307),ex4(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(283))
  call Hloop_VA_Q(ntryL,G1H2(308),ex4(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(284))
  call Hloop_VA_Q(ntryL,G1H2(309),ex4(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(285))
  call Hloop_VA_Q(ntryL,G1H2(312),ex4(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(286))
  call Hloop_VA_Q(ntryL,G1H2(313),ex4(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(287))
  call Hloop_VA_Q(ntryL,G1H2(314),ex4(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(156),n2h1(288))
  call Hloop_QV_A(ntryL,G1H2(317),ex5(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(289))
  call Hloop_QV_A(ntryL,G1H2(354),ex5(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(290))
  call Hloop_QV_A(ntryL,G1H2(398),ex5(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(291))
  call Hloop_AV_Q(ntryL,G1H2(322),ex5(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(165),n2h1(292))
  call Hloop_AV_Q(ntryL,G1H2(343),ex5(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(293))
  call Hloop_AV_Q(ntryL,G1H2(366),ex5(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(168),n2h1(294))
  call Hloop_QV_A(ntryL,G1H2(327),ex5(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(171),n2h1(295))
  call Hloop_QV_A(ntryL,G1H2(381),ex5(:),G1H1(1),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(174),n2h1(296))
  call Hloop_AV_Q(ntryL,G1H2(332),ex5(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(297))
  call Hloop_AV_Q(ntryL,G1H2(393),ex5(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(180),n2h1(298))
  call Hloop_AV_Q(ntryL,G1H2(337),ex5(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(183),n2h1(299))
  call Hloop_AV_Q(ntryL,G1H2(339),ex5(:),G1H1(1),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(186),n2h1(300))
  call Hloop_AV_Q(ntryL,G1H2(342),ex5(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(189),n2h1(301))
  call Hloop_AV_Q(ntryL,G1H2(344),ex5(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(192),n2h1(302))
  call Hotf_4pt_reduction(G2H2(43),RedSet_4(184),mass4set(:,1),  & 
G1H2(71),G1H2(387),G1H2(249),G1H2(117),G1H2(63),2)
  call HG1shiftOLR(G1H2(387),16,2)
  call Hloop_QV_A(ntryL,G1H2(353),ex5(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(203),n2h1(303))
  call Hloop_QV_A(ntryL,G1H2(355),ex5(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(207),n2h1(304))
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(186),mass4set(:,1),  & 
G1H4(61),G1H4(31),G1H4(32),G1H4(72),G1H4(44),4)
  call HG1shiftOLR(G1H4(31),5,4)
  call Hotf_4pt_reduction(G2H4(38),RedSet_4(187),mass4set(:,1),  & 
G1H4(75),G1H4(76),G1H4(86),G1H4(87),G1H4(24),4)
  call HG1shiftOLR(G1H4(76),5,4)
  call Hloop_AV_Q(ntryL,G1H4(81),wf4(:,1),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(211),n2h1(305))
  call Hloop_AV_Q(ntryL,G1H4(82),wf4(:,1),G1H1(1),m3h4x1(:,47),heltab2x4(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(216),n2h1(306))
  call Hloop_AV_Q(ntryL,G1H4(83),wf4(:,1),G1H1(1),m3h4x1(:,48),heltab2x4(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(220),n2h1(307))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(190),mass4set(:,1),  & 
G1H2(86),G1H2(273),G1H2(92),G1H2(110),G1H2(297),2)
  call HG1shiftOLR(G1H2(273),16,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(124),mass4set(:,1),  & 
G1H2(116),G1H2(349),G1H2(295),G1H2(289),G1H2(376),2)
  call HG1shiftOLR(G1H2(349),16,2)
  call Hloop_AV_Q(ntryL,G1H2(364),ex5(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(224),n2h1(308))
  call Hloop_AV_Q(ntryL,G1H2(365),ex5(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(229),n2h1(309))
  call Hloop_QV_A(ntryL,G1H2(369),ex5(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(230),n2h1(310))
  call Hloop_QV_A(ntryL,G1H2(370),ex5(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(231),n2h1(311))
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(192),mass4set(:,1),  & 
G1H2(271),G1H2(265),G1H2(123),G1H2(8),G1H2(31),2)
  call HG1shiftOLR(G1H2(265),16,2)
  call Hloop_QV_A(ntryL,G1H2(380),ex5(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(232),n2h1(312))
  call Hloop_QV_A(ntryL,G1H2(382),ex5(:),G1H1(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(233),n2h1(313))
  call Hotf_4pt_reduction(G2H4(39),RedSet_4(194),mass4set(:,1),  & 
G1H4(13),G1H4(27),G1H4(15),G1H4(47),G1H4(34),4)
  call HG1shiftOLR(G1H4(27),6,4)
  call Hotf_4pt_reduction(G2H4(42),RedSet_4(195),mass4set(:,1),  & 
G1H4(64),G1H4(49),G1H4(25),G1H4(60),G1H4(51),4)
  call HG1shiftOLR(G1H4(49),6,4)
  call Hloop_AV_Q(ntryL,G1H4(92),wf4(:,7),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(234),n2h1(314))
  call Hloop_AV_Q(ntryL,G1H4(93),wf4(:,7),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(235),n2h1(315))
  call Hloop_AV_Q(ntryL,G1H4(94),wf4(:,7),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(236),n2h1(316))
  call Hotf_4pt_reduction(G2H2(19),RedSet_4(198),mass4set(:,1),  & 
G1H2(13),G1H2(183),G1H2(135),G1H2(18),G1H2(14),2)
  call HG1shiftOLR(G1H2(183),16,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(106),mass4set(:,1),  & 
G1H2(141),G1H2(26),G1H2(165),G1H2(147),G1H2(56),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hloop_AV_Q(ntryL,G1H2(391),ex5(:),G1H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(237),n2h1(317))
  call Hloop_AV_Q(ntryL,G1H2(392),ex5(:),G1H1(1),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(238),n2h1(318))
  call Hloop_QV_A(ntryL,G1H2(396),ex5(:),G1H1(1),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(239),n2h1(319))
  call Hloop_QV_A(ntryL,G1H2(397),ex5(:),G1H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(240),n2h1(320))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(241),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(242),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex1(:),G2tensor(243),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(138),mass4set(:,1),  & 
G1H4(6),G1H4(26),G1H4(81),G1H4(82),G1H4(83),4)
  call HG1shiftOLR(G1H4(26),18,4)
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(208),mass4set(:,1),  & 
G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(93),5,4)
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(140),mass4set(:,1),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),4)
  call HG1shiftOLR(G1H4(98),17,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(183),mass4set(:,1),  & 
G1H4(102),G1H4(103),G1H4(104),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(103),6,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(19),wf4(:,8),G2tensor(244),m3h4x1(:,52),heltab2x4(:,:,221))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(23),wf4(:,8),G2tensor(245),m3h4x1(:,53),heltab2x4(:,:,222))
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(139),mass4set(:,1),  & 
G1H8(22),G1H8(2),G1H8(26),G1H8(19),G1H8(35),8)
  call HG1shiftOLR(G1H8(2),21,8)
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(127),mass4set(:,1),  & 
G1H8(12),G1H8(17),G1H8(20),G1H8(5),G1H8(14),8)
  call HG1shiftOLR(G1H8(17),21,8)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(10),wf4(:,3),G2tensor(246),m3h4x1(:,54),heltab2x4(:,:,223))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(24),wf4(:,3),G2tensor(247),m3h4x1(:,55),heltab2x4(:,:,224))
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(141),mass4set(:,1),  & 
G1H8(27),G1H8(16),G1H8(21),G1H8(1),G1H8(30),8)
  call HG1shiftOLR(G1H8(16),22,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(109),mass4set(:,1),  & 
G1H8(7),G1H8(36),G1H8(29),G1H8(11),G1H8(13),8)
  call HG1shiftOLR(G1H8(36),22,8)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(4),wf4(:,10),G2tensor(248),m3h4x1(:,56),heltab2x4(:,:,225))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(9),wf4(:,10),G2tensor(249),m3h4x1(:,57),heltab2x4(:,:,226))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(13),wf4(:,10),G2tensor(250),m3h4x1(:,58),heltab2x4(:,:,227))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(35),wf4(:,10),G2tensor(251),m3h4x1(:,59),heltab2x4(:,:,228))
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(139),mass4set(:,1),  & 
G1H8(6),G1H8(8),G1H8(9),G1H8(10),G1H8(34),8)
  call HG1shiftOLR(G1H8(8),21,8)
  call Hotf_4pt_reduction(G2H8(17),RedSet_4(127),mass4set(:,1),  & 
G1H8(37),G1H8(38),G1H8(18),G1H8(23),G1H8(31),8)
  call HG1shiftOLR(G1H8(38),21,8)
  call Hotf_4pt_reduction(G2H8(18),RedSet_4(141),mass4set(:,1),  & 
G1H8(32),G1H8(24),G1H8(39),G1H8(40),G1H8(41),8)
  call HG1shiftOLR(G1H8(24),22,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(109),mass4set(:,1),  & 
G1H8(42),G1H8(43),G1H8(33),G1H8(25),G1H8(44),8)
  call HG1shiftOLR(G1H8(43),22,8)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(70),ex3(:),G2tensor(252),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(253),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(18),ex2(:),G2tensor(254),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(27),ex2(:),G2tensor(255),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(30),ex2(:),G2tensor(256),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(33),ex1(:),G2tensor(257),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(86),ex1(:),G2tensor(258),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(35),ex3(:),G2tensor(259),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex3(:),G2tensor(260),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(90),ex3(:),G2tensor(261),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(54),ex3(:),G2tensor(262),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(57),ex4(:),G2tensor(263),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(60),ex4(:),G2tensor(264),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(61),ex4(:),G2tensor(265),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(64),ex4(:),G2tensor(266),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hloop_VA_Q(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(267),n2h1(321))
  call Hloop_VA_Q(ntryL,G1H2(119),ex4(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(268),n2h1(322))
  call Hloop_VA_Q(ntryL,G1H2(125),ex4(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(269),n2h1(323))
  call Hloop_VA_Q(ntryL,G1H2(126),ex4(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(270),n2h1(324))
  call Hloop_VA_Q(ntryL,G1H2(130),ex4(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(271),n2h1(325))
  call Hloop_VA_Q(ntryL,G1H2(136),ex4(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(272),n2h1(326))
  call Hloop_AV_Q(ntryL,G1H2(137),ex5(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(273),n2h1(327))
  call Hloop_AV_Q(ntryL,G1H2(138),ex5(:),G1H1(1),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(274),n2h1(328))
  call Hloop_AV_Q(ntryL,G1H2(144),ex5(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(275),n2h1(329))
  call Hloop_AV_Q(ntryL,G1H2(148),ex5(:),G1H1(1),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(276),n2h1(330))
  call Hloop_AV_Q(ntryL,G1H2(149),ex5(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(277),n2h1(331))
  call Hloop_AV_Q(ntryL,G1H2(155),ex5(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(278),n2h1(332))
  call Hloop_VQ_A(ntryL,G1H2(156),ex2(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(279),n2h1(333))
  call Hloop_VQ_A(ntryL,G1H2(305),ex2(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(280),n2h1(334))
  call Hloop_VQ_A(ntryL,G1H2(166),ex2(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(281),n2h1(335))
  call Hloop_QV_A(ntryL,G1H2(167),ex5(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(282),n2h1(336))
  call Hloop_QV_A(ntryL,G1H2(168),ex5(:),G1H1(1),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(283),n2h1(337))
  call Hloop_QV_A(ntryL,G1H2(174),ex5(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(284),n2h1(338))
  call Hloop_VA_Q(ntryL,G1H2(310),ex4(:),G1H1(1),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(285),n2h1(339))
  call Hloop_VA_Q(ntryL,G1H2(179),ex4(:),G1H1(1),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(286),n2h1(340))
  call Hloop_VA_Q(ntryL,G1H2(185),ex4(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(287),n2h1(341))
  call Hloop_AV_Q(ntryL,G1H2(186),ex5(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(288),n2h1(342))
  call Hloop_AV_Q(ntryL,G1H2(190),ex5(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(289),n2h1(343))
  call Hloop_AV_Q(ntryL,G1H2(196),ex5(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(290),n2h1(344))
  call Hloop_VQ_A(ntryL,G1H2(197),ex1(:),G1H1(1),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(291),n2h1(345))
  call Hloop_VQ_A(ntryL,G1H2(198),ex1(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(292),n2h1(346))
  call Hloop_VQ_A(ntryL,G1H2(204),ex1(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(293),n2h1(347))
  call Hloop_VA_Q(ntryL,G1H2(208),ex4(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(294),n2h1(348))
  call Hloop_VA_Q(ntryL,G1H2(209),ex4(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(295),n2h1(349))
  call Hloop_VA_Q(ntryL,G1H2(215),ex4(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(296),n2h1(350))
  call Hloop_AV_Q(ntryL,G1H2(216),ex5(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(297),n2h1(351))
  call Hloop_AV_Q(ntryL,G1H2(320),ex5(:),G1H1(1),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(298),n2h1(352))
  call Hloop_AV_Q(ntryL,G1H2(226),ex5(:),G1H1(1),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(299),n2h1(353))
  call Hloop_VA_Q(ntryL,G1H2(227),ex4(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(300),n2h1(354))
  call Hloop_VA_Q(ntryL,G1H2(228),ex4(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(301),n2h1(355))
  call Hloop_VA_Q(ntryL,G1H2(234),ex4(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(302),n2h1(356))
  call Hloop_AV_Q(ntryL,G1H2(325),ex5(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(303),n2h1(357))
  call Hloop_AV_Q(ntryL,G1H2(239),ex5(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(304),n2h1(358))
  call Hloop_AV_Q(ntryL,G1H2(245),ex5(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(305),n2h1(359))
  call Hloop_VA_Q(ntryL,G1H2(246),ex4(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(306),n2h1(360))
  call Hloop_VA_Q(ntryL,G1H2(330),ex4(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(307),n2h1(361))
  call Hloop_VA_Q(ntryL,G1H2(256),ex4(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(308),n2h1(362))
  call Hloop_AV_Q(ntryL,G1H2(257),ex5(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(309),n2h1(363))
  call Hloop_AV_Q(ntryL,G1H2(258),ex5(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(310),n2h1(364))
  call Hloop_AV_Q(ntryL,G1H2(264),ex5(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(311),n2h1(365))
  call Hloop_VQ_A(ntryL,G1H2(268),ex2(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(312),n2h1(366))
  call Hloop_VQ_A(ntryL,G1H2(269),ex2(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(313),n2h1(367))
  call Hloop_VQ_A(ntryL,G1H2(275),ex2(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(314),n2h1(368))
  call Hloop_QV_A(ntryL,G1H2(276),ex5(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(315),n2h1(369))
  call Hloop_QV_A(ntryL,G1H2(280),ex5(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(316),n2h1(370))
  call Hloop_QV_A(ntryL,G1H2(286),ex5(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(317),n2h1(371))
  call Hloop_AV_Q(ntryL,G1H2(287),ex5(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(318),n2h1(372))
  call Hloop_AV_Q(ntryL,G1H2(288),ex5(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(319),n2h1(373))
  call Hloop_AV_Q(ntryL,G1H2(294),ex5(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(320),n2h1(374))
  call Hloop_AV_Q(ntryL,G1H4(50),wf4(:,1),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(321),n2h1(375))
  call Hloop_AV_Q(ntryL,G1H4(19),wf4(:,1),G1H1(1),m3h4x1(:,61),heltab2x4(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(322),n2h1(376))
  call Hloop_AV_Q(ntryL,G1H4(63),wf4(:,1),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(323),n2h1(377))
  call Hloop_AV_Q(ntryL,G1H4(69),wf4(:,1),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(324),n2h1(378))
  call Hloop_AV_Q(ntryL,G1H4(57),wf4(:,1),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(325),n2h1(379))
  call Hloop_AV_Q(ntryL,G1H4(9),wf4(:,1),G1H1(1),m3h4x1(:,65),heltab2x4(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(326),n2h1(380))
  call Hloop_QV_A(ntryL,G1H4(58),wf4(:,1),G1H1(1),m3h4x1(:,66),heltab2x4(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(327),n2h1(381))
  call Hloop_QV_A(ntryL,G1H4(30),wf4(:,1),G1H1(1),m3h4x1(:,67),heltab2x4(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(328),n2h1(382))
  call Hloop_QV_A(ntryL,G1H4(65),wf4(:,1),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(329),n2h1(383))
  call Hloop_VQ_A(ntryL,G1H2(340),ex1(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(330),n2h1(384))
  call Hloop_VQ_A(ntryL,G1H2(299),ex1(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(331),n2h1(385))
  call Hloop_VQ_A(ntryL,G1H2(306),ex1(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(332),n2h1(386))
  call Hloop_QV_A(ntryL,G1H2(311),ex5(:),G1H1(1),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(333),n2h1(387))
  call Hloop_QV_A(ntryL,G1H2(316),ex5(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(334),n2h1(388))
  call Hloop_QV_A(ntryL,G1H2(331),ex5(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(335),n2h1(389))
  call Hloop_AV_Q(ntryL,G1H2(336),ex5(:),G1H1(1),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(336),n2h1(390))
  call Hloop_AV_Q(ntryL,G1H2(341),ex5(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(337),n2h1(391))
  call Hloop_AV_Q(ntryL,G1H2(351),ex5(:),G1H1(1),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(338),n2h1(392))
  call Hloop_AV_Q(ntryL,G1H4(66),wf4(:,7),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(339),n2h1(393))
  call Hloop_AV_Q(ntryL,G1H4(67),wf4(:,7),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(340),n2h1(394))
  call Hloop_AV_Q(ntryL,G1H4(73),wf4(:,7),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(341),n2h1(395))
  call Hloop_AV_Q(ntryL,G1H4(79),wf4(:,7),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,241))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(342),n2h1(396))
  call Hloop_AV_Q(ntryL,G1H4(80),wf4(:,7),G1H1(1),m3h4x1(:,73),heltab2x4(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(343),n2h1(397))
  call Hloop_AV_Q(ntryL,G1H4(91),wf4(:,7),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(344),n2h1(398))
  call Hloop_QV_A(ntryL,G1H4(78),wf4(:,7),G1H1(1),m3h4x1(:,75),heltab2x4(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(345),n2h1(399))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,7),G1H1(1),m3h4x1(:,76),heltab2x4(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(346),n2h1(400))
  call Hloop_QV_A(ntryL,G1H4(4),wf4(:,7),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(347),n2h1(401))
  call Hloop_VA_Q(ntryL,G1H2(352),ex4(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(348),n2h1(402))
  call Hloop_VA_Q(ntryL,G1H2(356),ex4(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(349),n2h1(403))
  call Hloop_VA_Q(ntryL,G1H2(363),ex4(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(350),n2h1(404))
  call Hloop_VA_Q(ntryL,G1H2(368),ex4(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(351),n2h1(405))
  call Hloop_VA_Q(ntryL,G1H2(372),ex4(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(352),n2h1(406))
  call Hloop_VA_Q(ntryL,G1H2(379),ex4(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(353),n2h1(407))
  call Hloop_QV_A(ntryL,G1H2(383),ex5(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(354),n2h1(408))
  call Hloop_QV_A(ntryL,G1H2(384),ex5(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(355),n2h1(409))
  call Hloop_QV_A(ntryL,G1H2(395),ex5(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(356),n2h1(410))
  call Hloop_QV_A(ntryL,G1H2(82),ex5(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(357),n2h1(411))
  call Hloop_QV_A(ntryL,G1H2(106),ex5(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(358),n2h1(412))
  call Hloop_QV_A(ntryL,G1H2(202),ex5(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(359),n2h1(413))
  call Hloop_QV_A(ntryL,G1H2(220),ex5(:),G1H1(1),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(360),n2h1(414))
  call Hloop_QV_A(ntryL,G1H2(238),ex5(:),G1H1(1),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(361),n2h1(415))
  call Hloop_QV_A(ntryL,G1H2(298),ex5(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(362),n2h1(416))
  call Hloop_QV_A(ntryL,G1H2(350),ex5(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(363),n2h1(417))
  call Hloop_QV_A(ntryL,G1H2(361),ex5(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(364),n2h1(418))
  call Hloop_QV_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(365),n2h1(419))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(366),n2h1(420))
  call Hloop_VA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(367),n2h1(421))
  call Hloop_VA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(368),n2h1(422))
  call Hloop_VA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(369),n2h1(423))
  call Hloop_VA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(370),n2h1(424))
  call Hloop_VA_Q(ntryL,G1H2(68),ex4(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(371),n2h1(425))
  call Hloop_VA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(372),n2h1(426))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(373),n2h1(427))
  call Hloop_VA_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(374),n2h1(428))
  call Hloop_VA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(375),n2h1(429))
  call Hloop_VA_Q(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(376),n2h1(430))
  call Hloop_VA_Q(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(377),n2h1(431))
  call Hloop_QV_A(ntryL,G1H2(52),ex5(:),G1H1(1),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(378),n2h1(432))
  call Hloop_QV_A(ntryL,G1H2(64),ex5(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(379),n2h1(433))
  call Hloop_QV_A(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(380),n2h1(434))
  call Hloop_QV_A(ntryL,G1H2(394),ex5(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(381),n2h1(435))
  call Hloop_QV_A(ntryL,G1H2(83),ex5(:),G1H1(1),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(382),n2h1(436))
  call Hloop_QV_A(ntryL,G1H2(90),ex5(:),G1H1(1),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(383),n2h1(437))
  call Hloop_AV_Q(ntryL,G1H2(94),ex5(:),G1H1(1),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(384),n2h1(438))
  call Hloop_AV_Q(ntryL,G1H2(96),ex5(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(385),n2h1(439))
  call Hloop_AV_Q(ntryL,G1H2(367),ex5(:),G1H1(1),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(386),n2h1(440))
  call Hloop_AV_Q(ntryL,G1H2(107),ex5(:),G1H1(1),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(387),n2h1(441))
  call Hloop_AV_Q(ntryL,G1H2(108),ex5(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(388),n2h1(442))
  call Hloop_AV_Q(ntryL,G1H2(159),ex5(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(389),n2h1(443))
  call Hloop_QV_A(ntryL,G1H2(50),ex5(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(390),n2h1(444))
  call Hloop_QV_A(ntryL,G1H2(177),ex5(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(391),n2h1(445))
  call Hloop_QV_A(ntryL,G1H2(229),ex5(:),G1H1(1),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(392),n2h1(446))
  call Hloop_QV_A(ntryL,G1H2(187),ex5(:),G1H1(1),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(393),n2h1(447))
  call Hloop_QV_A(ntryL,G1H2(193),ex5(:),G1H1(1),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(394),n2h1(448))
  call Hloop_QV_A(ntryL,G1H2(54),ex5(:),G1H1(1),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(395),n2h1(449))
  call Hloop_AV_Q(ntryL,G1H2(75),ex5(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(396),n2h1(450))
  call Hloop_AV_Q(ntryL,G1H2(237),ex5(:),G1H1(1),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(397),n2h1(451))
  call Hloop_AV_Q(ntryL,G1H2(81),ex5(:),G1H1(1),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(398),n2h1(452))
  call Hloop_QV_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(399),n2h1(453))
  call Hloop_QV_A(ntryL,G1H2(87),ex5(:),G1H1(1),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(400),n2h1(454))
  call Hloop_QV_A(ntryL,G1H2(219),ex5(:),G1H1(1),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(401),n2h1(455))
  call Hloop_QV_A(ntryL,G1H2(93),ex5(:),G1H1(1),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(402),n2h1(456))
  call Hloop_QV_A(ntryL,G1H2(53),ex5(:),G1H1(1),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(403),n2h1(457))
  call Hloop_QV_A(ntryL,G1H2(111),ex5(:),G1H1(1),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(404),n2h1(458))
  call Hloop_VQ_A(ntryL,G1H4(74),wf4(:,8),G1H1(1),m3h4x1(:,78),heltab2x4(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(405),n2h1(459))
  call Hloop_VQ_A(ntryL,G1H4(18),wf4(:,8),G1H1(1),m3h4x1(:,79),heltab2x4(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(406),n2h1(460))
  call Hloop_VQ_A(ntryL,G1H4(2),wf4(:,8),G1H1(1),m3h4x1(:,80),heltab2x4(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(407),n2h1(461))
  call Hloop_VQ_A(ntryL,G1H4(21),wf4(:,3),G1H1(1),m3h4x1(:,81),heltab2x4(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(408),n2h1(462))
  call Hloop_VQ_A(ntryL,G1H4(55),wf4(:,3),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),18,0,G2tensor(409),n2h1(463))
  call Hloop_VQ_A(ntryL,G1H4(70),wf4(:,3),G1H1(1),m3h4x1(:,83),heltab2x4(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(410),n2h1(464))
  call Hloop_VA_Q(ntryL,G1H4(14),wf4(:,5),G1H1(1),m3h4x1(:,84),heltab2x4(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(411),n2h1(465))
  call Hloop_VA_Q(ntryL,G1H4(10),wf4(:,5),G1H1(1),m3h4x1(:,85),heltab2x4(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(412),n2h1(466))
  call Hloop_VA_Q(ntryL,G1H4(77),wf4(:,5),G1H1(1),m3h4x1(:,86),heltab2x4(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(413),n2h1(467))
  call Hloop_VA_Q(ntryL,G1H4(88),wf4(:,5),G1H1(1),m3h4x1(:,87),heltab2x4(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(414),n2h1(468))
  call Hloop_VA_Q(ntryL,G1H4(12),wf4(:,5),G1H1(1),m3h4x1(:,88),heltab2x4(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(415),n2h1(469))
  call Hloop_VA_Q(ntryL,G1H4(11),wf4(:,5),G1H1(1),m3h4x1(:,89),heltab2x4(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(416),n2h1(470))
  call Hloop_VA_Q(ntryL,G1H4(33),wf4(:,5),G1H1(1),m3h4x1(:,90),heltab2x4(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(417),n2h1(471))
  call Hloop_VA_Q(ntryL,G1H4(20),wf4(:,5),G1H1(1),m3h4x1(:,91),heltab2x4(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(418),n2h1(472))
  call Hloop_VA_Q(ntryL,G1H4(37),wf4(:,5),G1H1(1),m3h4x1(:,92),heltab2x4(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(419),n2h1(473))
  call Hloop_VA_Q(ntryL,G1H4(28),wf4(:,5),G1H1(1),m3h4x1(:,93),heltab2x4(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(420),n2h1(474))
  call Hloop_VA_Q(ntryL,G1H4(48),wf4(:,5),G1H1(1),m3h4x1(:,94),heltab2x4(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(421),n2h1(475))
  call Hloop_VA_Q(ntryL,G1H4(43),wf4(:,5),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(422),n2h1(476))
  call Hloop_QV_A(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(423),n2h1(477))
  call Hloop_QV_A(ntryL,G1H2(387),ex5(:),G1H1(1),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(424),n2h1(478))
  call Hloop_QV_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(425),n2h1(479))
  call Hloop_AV_Q(ntryL,G1H4(61),wf4(:,1),G1H1(1),m3h4x1(:,96),heltab2x4(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(426),n2h1(480))
  call Hloop_AV_Q(ntryL,G1H4(31),wf4(:,1),G1H1(1),m3h4x1(:,97),heltab2x4(:,:,266))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(427),n2h1(481))
  call Hloop_AV_Q(ntryL,G1H4(44),wf4(:,1),G1H1(1),m3h4x1(:,98),heltab2x4(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(428),n2h1(482))
  call Hloop_AV_Q(ntryL,G1H4(75),wf4(:,1),G1H1(1),m3h4x1(:,99),heltab2x4(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(429),n2h1(483))
  call Hloop_AV_Q(ntryL,G1H4(76),wf4(:,1),G1H1(1),m3h4x1(:,100),heltab2x4(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(430),n2h1(484))
  call Hloop_AV_Q(ntryL,G1H4(24),wf4(:,1),G1H1(1),m3h4x1(:,101),heltab2x4(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(431),n2h1(485))
  call Hloop_AV_Q(ntryL,G1H2(86),ex5(:),G1H1(1),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(432),n2h1(486))
  call Hloop_AV_Q(ntryL,G1H2(273),ex5(:),G1H1(1),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(433),n2h1(487))
  call Hloop_AV_Q(ntryL,G1H2(297),ex5(:),G1H1(1),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(434),n2h1(488))
  call Hloop_AV_Q(ntryL,G1H2(116),ex5(:),G1H1(1),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(435),n2h1(489))
  call Hloop_AV_Q(ntryL,G1H2(349),ex5(:),G1H1(1),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(436),n2h1(490))
  call Hloop_AV_Q(ntryL,G1H2(376),ex5(:),G1H1(1),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(437),n2h1(491))
  call Hloop_QV_A(ntryL,G1H2(271),ex5(:),G1H1(1),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(438),n2h1(492))
  call Hloop_QV_A(ntryL,G1H2(265),ex5(:),G1H1(1),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(439),n2h1(493))
  call Hloop_QV_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(440),n2h1(494))
  call Hloop_AV_Q(ntryL,G1H4(13),wf4(:,7),G1H1(1),m3h4x1(:,102),heltab2x4(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(441),n2h1(495))
  call Hloop_AV_Q(ntryL,G1H4(27),wf4(:,7),G1H1(1),m3h4x1(:,103),heltab2x4(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(442),n2h1(496))
  call Hloop_AV_Q(ntryL,G1H4(34),wf4(:,7),G1H1(1),m3h4x1(:,104),heltab2x4(:,:,273))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(443),n2h1(497))
  call Hloop_AV_Q(ntryL,G1H4(64),wf4(:,7),G1H1(1),m3h4x1(:,105),heltab2x4(:,:,274))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(444),n2h1(498))
  call Hloop_AV_Q(ntryL,G1H4(49),wf4(:,7),G1H1(1),m3h4x1(:,106),heltab2x4(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(445),n2h1(499))
  call Hloop_AV_Q(ntryL,G1H4(51),wf4(:,7),G1H1(1),m3h4x1(:,107),heltab2x4(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(446),n2h1(500))
  call Hloop_AV_Q(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(447),n2h1(501))
  call Hloop_AV_Q(ntryL,G1H2(183),ex5(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(448),n2h1(502))
  call Hloop_AV_Q(ntryL,G1H2(14),ex5(:),G1H1(1),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(449),n2h1(503))
  call Hloop_AV_Q(ntryL,G1H2(141),ex5(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(450),n2h1(504))
  call Hloop_AV_Q(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(451),n2h1(505))
  call Hloop_AV_Q(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(452),n2h1(506))
  call Hloop_VQ_A(ntryL,G1H4(6),wf4(:,3),G1H1(1),m3h4x1(:,108),heltab2x4(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(453),n2h1(507))
  call Hloop_VQ_A(ntryL,G1H4(26),wf4(:,3),G1H1(1),m3h4x1(:,109),heltab2x4(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),18,0,G2tensor(454),n2h1(508))
  call Hloop_VQ_A(ntryL,G1H4(83),wf4(:,3),G1H1(1),m3h4x1(:,110),heltab2x4(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(455),n2h1(509))
  call Hloop_QV_A(ntryL,G1H4(92),wf4(:,1),G1H1(1),m3h4x1(:,111),heltab2x4(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(456),n2h1(510))
  call Hloop_QV_A(ntryL,G1H4(93),wf4(:,1),G1H1(1),m3h4x1(:,112),heltab2x4(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(457),n2h1(511))
  call Hloop_QV_A(ntryL,G1H4(96),wf4(:,1),G1H1(1),m3h4x1(:,113),heltab2x4(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(458),n2h1(512))
  call Hloop_VQ_A(ntryL,G1H4(97),wf4(:,8),G1H1(1),m3h4x1(:,114),heltab2x4(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(459),n2h1(513))
  call Hloop_VQ_A(ntryL,G1H4(98),wf4(:,8),G1H1(1),m3h4x1(:,115),heltab2x4(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,0,G2tensor(460),n2h1(514))
  call Hloop_VQ_A(ntryL,G1H4(101),wf4(:,8),G1H1(1),m3h4x1(:,116),heltab2x4(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(461),n2h1(515))
  call Hloop_QV_A(ntryL,G1H4(102),wf4(:,7),G1H1(1),m3h4x1(:,117),heltab2x4(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(462),n2h1(516))
  call Hloop_QV_A(ntryL,G1H4(103),wf4(:,7),G1H1(1),m3h4x1(:,118),heltab2x4(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(463),n2h1(517))
  call Hloop_QV_A(ntryL,G1H4(106),wf4(:,7),G1H1(1),m3h4x1(:,119),heltab2x4(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(464),n2h1(518))
  call Hloop_AV_Q(ntryL,G1H8(22),wf8(:,9),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(465),n2h1(519))
  call Hloop_AV_Q(ntryL,G1H8(2),wf8(:,9),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),21,0,G2tensor(466),n2h1(520))
  call Hloop_AV_Q(ntryL,G1H8(35),wf8(:,9),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(467),n2h1(521))
  call Hloop_QV_A(ntryL,G1H8(12),wf8(:,9),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(468),n2h1(522))
  call Hloop_QV_A(ntryL,G1H8(17),wf8(:,9),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,0,G2tensor(469),n2h1(523))
  call Hloop_QV_A(ntryL,G1H8(14),wf8(:,9),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(470),n2h1(524))
  call Hloop_AV_Q(ntryL,G1H8(27),wf8(:,10),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(471),n2h1(525))
  call Hloop_AV_Q(ntryL,G1H8(16),wf8(:,10),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,0,G2tensor(472),n2h1(526))
  call Hloop_AV_Q(ntryL,G1H8(30),wf8(:,10),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(473),n2h1(527))
  call Hloop_QV_A(ntryL,G1H8(7),wf8(:,10),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(474),n2h1(528))
  call Hloop_QV_A(ntryL,G1H8(36),wf8(:,10),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),22,0,G2tensor(475),n2h1(529))
  call Hloop_QV_A(ntryL,G1H8(13),wf8(:,10),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(476),n2h1(530))
  call Hloop_AV_Q(ntryL,G1H8(6),wf8(:,12),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(477),n2h1(531))
  call Hloop_AV_Q(ntryL,G1H8(8),wf8(:,12),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),21,0,G2tensor(478),n2h1(532))
  call Hloop_AV_Q(ntryL,G1H8(34),wf8(:,12),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(479),n2h1(533))
  call Hloop_QV_A(ntryL,G1H8(37),wf8(:,12),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(480),n2h1(534))
  call Hloop_QV_A(ntryL,G1H8(38),wf8(:,12),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,0,G2tensor(481),n2h1(535))
  call Hloop_QV_A(ntryL,G1H8(31),wf8(:,12),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(482),n2h1(536))
  call Hloop_AV_Q(ntryL,G1H8(32),wf8(:,11),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(483),n2h1(537))
  call Hloop_AV_Q(ntryL,G1H8(24),wf8(:,11),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,0,G2tensor(484),n2h1(538))
  call Hloop_AV_Q(ntryL,G1H8(41),wf8(:,11),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(485),n2h1(539))
  call Hloop_QV_A(ntryL,G1H8(42),wf8(:,11),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(486),n2h1(540))
  call Hloop_QV_A(ntryL,G1H8(43),wf8(:,11),G1H1(1),m3h8x1(:,23),heltab2x8(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),22,0,G2tensor(487),n2h1(541))
  call Hloop_QV_A(ntryL,G1H8(44),wf8(:,11),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(488),n2h1(542))
  call ol_merge_tensors(G2tensor(250),[G2tensor(19),G2tensor(3),G1tensor(92),G1tensor(31)])
  call ol_merge_tensors(G2tensor(251),[G2tensor(25),G2tensor(7),G1tensor(110),G1tensor(67)])
  call ol_merge_tensors(G2tensor(247),[G2tensor(36),G2tensor(146),G2tensor(28),G2tensor(11),G1tensor(333),G1tensor(252) &
    ,G1tensor(134),G1tensor(32)])
  call ol_merge_tensors(G2tensor(245),[G2tensor(30),G2tensor(158),G2tensor(31),G2tensor(15),G1tensor(321),G1tensor(288) &
    ,G1tensor(158),G1tensor(68)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(44),G2tensor(21),G1tensor(348),G1tensor(210),G1tensor(96)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(53),G2tensor(26),G1tensor(354),G1tensor(246),G1tensor(114)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(77),G2tensor(29),G1tensor(360),G1tensor(318),G1tensor(138)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(65),G2tensor(32),G1tensor(366),G1tensor(282),G1tensor(162)])
  call ol_merge_tensors(G2tensor(178),[G2tensor(34),G1tensor(338),G1tensor(10)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(37),G2tensor(35),G1tensor(182),G1tensor(28),G1tensor(9)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(173),G2tensor(38),G1tensor(342),G1tensor(330),G1tensor(186)])
  call ol_merge_tensors(G2tensor(252),[G2tensor(181),G2tensor(40),G1tensor(344),G1tensor(12)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(41),G1tensor(206),G1tensor(18)])
  call ol_merge_tensors(G2tensor(172),[G2tensor(46),G1tensor(326),G1tensor(22)])
  call ol_merge_tensors(G2tensor(253),[G2tensor(184),G2tensor(49),G1tensor(350),G1tensor(29)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(50),G1tensor(242),G1tensor(46)])
  call ol_merge_tensors(G2tensor(175),[G2tensor(55),G1tensor(332),G1tensor(59)])
  call ol_merge_tensors(G2tensor(345),[G2tensor(58),G2tensor(56),G1tensor(260),G1tensor(40)])
  call ol_merge_tensors(G2tensor(486),[G2tensor(474),G2tensor(176),G2tensor(59),G1tensor(336),G1tensor(264)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(190),G2tensor(157),G2tensor(61),G1tensor(362),G1tensor(284),G1tensor(54) &
    ,G1tensor(41)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(62),G1tensor(278),G1tensor(48)])
  call ol_merge_tensors(G2tensor(169),[G2tensor(67),G1tensor(320),G1tensor(52)])
  call ol_merge_tensors(G2tensor(327),[G2tensor(70),G2tensor(68),G1tensor(296),G1tensor(60)])
  call ol_merge_tensors(G2tensor(480),[G2tensor(468),G2tensor(170),G2tensor(71),G1tensor(324),G1tensor(300)])
  call ol_merge_tensors(G2tensor(254),[G2tensor(72),G2tensor(187),G2tensor(145),G2tensor(73),G1tensor(356),G1tensor(248) &
    ,G1tensor(64),G1tensor(35)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(74),G1tensor(314),G1tensor(72)])
  call ol_merge_tensors(G2tensor(259),[G2tensor(193),G2tensor(79),G1tensor(368),G1tensor(74),G1tensor(13)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(241),[G2tensor(82),G1tensor(80),G1tensor(55),G1tensor(19)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(84)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(85),G1tensor(86),G1tensor(25)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(90)])
  call ol_merge_tensors(G2tensor(261),[G2tensor(88),G1tensor(98),G1tensor(49)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(102)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(91),G1tensor(104),G1tensor(61)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(108)])
  call ol_merge_tensors(G2tensor(242),[G2tensor(94),G1tensor(116),G1tensor(14)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(120)])
  call ol_merge_tensors(G2tensor(255),[G2tensor(97),G1tensor(122),G1tensor(20)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(126)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(10),G2tensor(100),G1tensor(371),G1tensor(128),G1tensor(26)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(132)])
  call ol_merge_tensors(G2tensor(243),[G2tensor(103),G1tensor(140),G1tensor(50)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(144)])
  call ol_merge_tensors(G2tensor(257),[G2tensor(106),G1tensor(146),G1tensor(56)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(150)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(109),G1tensor(152),G1tensor(62)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(156)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(112),G1tensor(164),G1tensor(4)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(113),G1tensor(339),G1tensor(168)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(115),G1tensor(170),G1tensor(5)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(116),G1tensor(340),G1tensor(174)])
  call ol_merge_tensors(G2tensor(279),[G2tensor(118),G1tensor(176),G1tensor(39),G1tensor(6)])
  call ol_merge_tensors(G2tensor(408),[G2tensor(119),G1tensor(341),G1tensor(335),G1tensor(180)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(121),G1tensor(188),G1tensor(15)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(122),G1tensor(345),G1tensor(192)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(124),G1tensor(194),G1tensor(30),G1tensor(16)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(125),G1tensor(352),G1tensor(346),G1tensor(198)])
  call ol_merge_tensors(G2tensor(285),[G2tensor(127),G1tensor(200),G1tensor(47),G1tensor(17)])
  call ol_merge_tensors(G2tensor(411),[G2tensor(128),G1tensor(365),G1tensor(347),G1tensor(204)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(130),G1tensor(212),G1tensor(23)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(131),G1tensor(327),G1tensor(216)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(133),G1tensor(218),G1tensor(24)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(134),G1tensor(328),G1tensor(222)])
  call ol_merge_tensors(G2tensor(291),[G2tensor(136),G1tensor(224),G1tensor(58),G1tensor(27)])
  call ol_merge_tensors(G2tensor(405),[G2tensor(137),G1tensor(329),G1tensor(323),G1tensor(228)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(139),G1tensor(230),G1tensor(42)])
  call ol_merge_tensors(G2tensor(132),[G2tensor(140),G1tensor(351),G1tensor(234)])
  call ol_merge_tensors(G2tensor(294),[G2tensor(142),G1tensor(236),G1tensor(70),G1tensor(33)])
  call ol_merge_tensors(G2tensor(414),[G2tensor(143),G1tensor(359),G1tensor(353),G1tensor(240)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(148),G1tensor(254),G1tensor(36)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(149),G1tensor(334),G1tensor(258)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(151),G1tensor(266),G1tensor(45)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(152),G1tensor(363),G1tensor(270)])
  call ol_merge_tensors(G2tensor(300),[G2tensor(154),G1tensor(272),G1tensor(71)])
  call ol_merge_tensors(G2tensor(420),[G2tensor(155),G1tensor(364),G1tensor(276)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(160),G1tensor(290),G1tensor(57)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(161),G1tensor(322),G1tensor(294)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(163),G1tensor(302),G1tensor(66)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(164),G1tensor(357),G1tensor(306)])
  call ol_merge_tensors(G2tensor(306),[G2tensor(166),G1tensor(308),G1tensor(69)])
  call ol_merge_tensors(G2tensor(417),[G2tensor(167),G1tensor(358),G1tensor(312)])
  call ol_merge_tensors(G2tensor(462),[G2tensor(194),G1tensor(372)])
  call ol_merge_tensors(G2tensor(312),[G2tensor(204),G1tensor(374)])
  call ol_merge_tensors(G2tensor(453),[G2tensor(205),G1tensor(378)])
  call ol_merge_tensors(G2tensor(318),[G2tensor(208),G1tensor(380),G1tensor(309),G1tensor(303)])
  call ol_merge_tensors(G2tensor(477),[G2tensor(465),G2tensor(213),G2tensor(209),G1tensor(390),G1tensor(384)])
  call ol_merge_tensors(G2tensor(324),[G2tensor(212),G1tensor(386)])
  call ol_merge_tensors(G2tensor(330),[G2tensor(217),G1tensor(392)])
  call ol_merge_tensors(G2tensor(459),[G2tensor(218),G1tensor(396)])
  call ol_merge_tensors(G2tensor(336),[G2tensor(221),G1tensor(398),G1tensor(273),G1tensor(267)])
  call ol_merge_tensors(G2tensor(483),[G2tensor(471),G2tensor(226),G2tensor(222),G1tensor(408),G1tensor(402)])
  call ol_merge_tensors(G2tensor(342),[G2tensor(225),G1tensor(404)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(219),G1tensor(213),G1tensor(7)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(171),G1tensor(165),G1tensor(43)])
  call ol_merge_tensors(G2tensor(273),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(276),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(99),G1tensor(81),G1tensor(75)])
  call ol_merge_tensors(G2tensor(96),[G1tensor(87),G1tensor(76)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(93),G1tensor(77)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(106),G1tensor(88),G1tensor(82)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(112),G1tensor(94),G1tensor(83)])
  call ol_merge_tensors(G2tensor(348),[G1tensor(161),G1tensor(155),G1tensor(95),G1tensor(89)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(105),G1tensor(100)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(111),G1tensor(101)])
  call ol_merge_tensors(G2tensor(351),[G1tensor(137),G1tensor(131),G1tensor(113),G1tensor(107)])
  call ol_merge_tensors(G2tensor(366),[G1tensor(123),G1tensor(117)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(129),G1tensor(118)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(135),G1tensor(119)])
  call ol_merge_tensors(G2tensor(369),[G1tensor(130),G1tensor(124)])
  call ol_merge_tensors(G2tensor(267),[G1tensor(136),G1tensor(125)])
  call ol_merge_tensors(G2tensor(372),[G1tensor(147),G1tensor(141)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(153),G1tensor(142)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(159),G1tensor(143)])
  call ol_merge_tensors(G2tensor(375),[G1tensor(154),G1tensor(148)])
  call ol_merge_tensors(G2tensor(270),[G1tensor(160),G1tensor(149)])
  call ol_merge_tensors(G2tensor(378),[G1tensor(250),G1tensor(177),G1tensor(166)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(215),G1tensor(183),G1tensor(167)])
  call ol_merge_tensors(G2tensor(381),[G1tensor(376),G1tensor(256),G1tensor(178),G1tensor(172)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(221),G1tensor(184),G1tensor(173)])
  call ol_merge_tensors(G2tensor(282),[G1tensor(299),G1tensor(263),G1tensor(227),G1tensor(185),G1tensor(179)])
  call ol_merge_tensors(G2tensor(108),[G1tensor(231),G1tensor(195),G1tensor(189)])
  call ol_merge_tensors(G2tensor(384),[G1tensor(268),G1tensor(201),G1tensor(190)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(207),G1tensor(191)])
  call ol_merge_tensors(G2tensor(387),[G1tensor(310),G1tensor(274),G1tensor(238),G1tensor(202),G1tensor(196)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(244),G1tensor(208),G1tensor(197)])
  call ol_merge_tensors(G2tensor(288),[G1tensor(389),G1tensor(281),G1tensor(209),G1tensor(203)])
  call ol_merge_tensors(G2tensor(390),[G1tensor(286),G1tensor(225),G1tensor(214)])
  call ol_merge_tensors(G2tensor(393),[G1tensor(394),G1tensor(292),G1tensor(226),G1tensor(220)])
  call ol_merge_tensors(G2tensor(396),[G1tensor(304),G1tensor(237),G1tensor(232)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(243),G1tensor(233)])
  call ol_merge_tensors(G2tensor(297),[G1tensor(407),G1tensor(317),G1tensor(245),G1tensor(239)])
  call ol_merge_tensors(G2tensor(399),[G1tensor(255),G1tensor(249)])
  call ol_merge_tensors(G2tensor(354),[G1tensor(261),G1tensor(251)])
  call ol_merge_tensors(G2tensor(450),[G2tensor(357),G1tensor(406),G1tensor(262),G1tensor(257)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(279),G1tensor(269)])
  call ol_merge_tensors(G2tensor(333),[G2tensor(303),G1tensor(395),G1tensor(280),G1tensor(275)])
  call ol_merge_tensors(G2tensor(402),[G1tensor(291),G1tensor(285)])
  call ol_merge_tensors(G2tensor(360),[G1tensor(297),G1tensor(287)])
  call ol_merge_tensors(G2tensor(435),[G2tensor(363),G1tensor(388),G1tensor(298),G1tensor(293)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(315),G1tensor(305)])
  call ol_merge_tensors(G2tensor(315),[G2tensor(309),G1tensor(377),G1tensor(316),G1tensor(311)])
  call ol_merge_tensors(G2tensor(141),[G1tensor(369)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(370)])
  call ol_merge_tensors(G2tensor(423),[G1tensor(375)])
  call ol_merge_tensors(G2tensor(426),[G1tensor(381)])
  call ol_merge_tensors(G2tensor(429),[G1tensor(382)])
  call ol_merge_tensors(G2tensor(321),[G1tensor(383)])
  call ol_merge_tensors(G2tensor(432),[G1tensor(387)])
  call ol_merge_tensors(G2tensor(438),[G1tensor(393)])
  call ol_merge_tensors(G2tensor(441),[G1tensor(399)])
  call ol_merge_tensors(G2tensor(444),[G1tensor(400)])
  call ol_merge_tensors(G2tensor(339),[G1tensor(401)])
  call ol_merge_tensors(G2tensor(447),[G1tensor(405)])
  call Hotf_4pt_reduction_last(G2tensor(250),RedSet_4(145),mass4set(:,1),  & 
G1tensor(1),G1tensor(37),G1tensor(2),G1tensor(38),G1tensor(3))
  call G_TensorShift(G1tensor(37),20)
  call Hotf_4pt_reduction_last(G2tensor(251),RedSet_4(148),mass4set(:,1),  & 
G1tensor(11),G1tensor(21),G1tensor(53),G1tensor(34),G1tensor(65))
  call G_TensorShift(G1tensor(21),20)
  call Hotf_4pt_reduction_last(G2tensor(247),RedSet_4(104),mass4set(:,1),  & 
G1tensor(51),G1tensor(63),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(63),18)
  call Hotf_4pt_reduction_last(G2tensor(245),RedSet_4(123),mass4set(:,1),  & 
G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109),G1tensor(115))
  call G_TensorShift(G1tensor(97),17)
  call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(13),mass4set(:,1),  & 
G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139),G1tensor(145))
  call G_TensorShift(G1tensor(127),28)
  call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(23),mass4set(:,1),  & 
G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(157),28)
  call Hotf_4pt_reduction_last(G2tensor(188),RedSet_4(37),mass4set(:,1),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205))
  call G_TensorShift(G1tensor(187),26)
  call Hotf_4pt_reduction_last(G2tensor(191),RedSet_4(51),mass4set(:,1),  & 
G1tensor(211),G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235))
  call G_TensorShift(G1tensor(217),25)
  call Hotf_4pt_reduction_last(G2tensor(178),RedSet_4(209),mass4set(:,1),  & 
G1tensor(241),G1tensor(247),G1tensor(253),G1tensor(259),G1tensor(265))
  call G_TensorShift(G1tensor(247),1)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(158),mass4set(:,1),  & 
G1tensor(271),G1tensor(277),G1tensor(283),G1tensor(289),G1tensor(295))
  call G_TensorShift(G1tensor(277),3)
  call Hotf_4pt_reduction_last(G2tensor(179),RedSet_4(66),mass4set(:,1),  & 
G1tensor(301),G1tensor(307),G1tensor(313),G1tensor(319),G1tensor(325))
  call G_TensorShift(G1tensor(307),19)
  call Hotf_4pt_reduction_last(G2tensor(252),RedSet_4(210),mass4set(:,1),  & 
G1tensor(331),G1tensor(337),G1tensor(343),G1tensor(349),G1tensor(355))
  call G_TensorShift(G1tensor(337),4)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(162),mass4set(:,1),  & 
G1tensor(361),G1tensor(367),G1tensor(373),G1tensor(379),G1tensor(385))
  call G_TensorShift(G1tensor(367),12)
  call Hotf_4pt_reduction_last(G2tensor(172),RedSet_4(211),mass4set(:,1),  & 
G1tensor(391),G1tensor(397),G1tensor(403),G1tensor(92),G1tensor(31))
  call G_TensorShift(G1tensor(397),2)
  call Hotf_4pt_reduction_last(G2tensor(253),RedSet_4(212),mass4set(:,1),  & 
G1tensor(110),G1tensor(67),G1tensor(333),G1tensor(252),G1tensor(134))
  call G_TensorShift(G1tensor(67),4)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(168),mass4set(:,1),  & 
G1tensor(32),G1tensor(321),G1tensor(288),G1tensor(158),G1tensor(68))
  call G_TensorShift(G1tensor(321),12)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(213),mass4set(:,1),  & 
G1tensor(348),G1tensor(210),G1tensor(96),G1tensor(354),G1tensor(246))
  call G_TensorShift(G1tensor(210),4)
  call Hotf_4pt_reduction_last(G2tensor(345),RedSet_4(171),mass4set(:,1),  & 
G1tensor(114),G1tensor(360),G1tensor(318),G1tensor(138),G1tensor(366))
  call G_TensorShift(G1tensor(360),6)
  call Hotf_4pt_reduction_last(G2tensor(486),RedSet_4(109),mass4set(:,1),  & 
G1tensor(282),G1tensor(162),G1tensor(338),G1tensor(10),G1tensor(182))
  call G_TensorShift(G1tensor(162),22)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(175),mass4set(:,1),  & 
G1tensor(28),G1tensor(9),G1tensor(342),G1tensor(330),G1tensor(186))
  call G_TensorShift(G1tensor(9),1)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(174),mass4set(:,1),  & 
G1tensor(344),G1tensor(12),G1tensor(206),G1tensor(18),G1tensor(326))
  call G_TensorShift(G1tensor(12),9)
  call Hotf_4pt_reduction_last(G2tensor(169),RedSet_4(214),mass4set(:,1),  & 
G1tensor(22),G1tensor(350),G1tensor(29),G1tensor(242),G1tensor(46))
  call G_TensorShift(G1tensor(350),4)
  call Hotf_4pt_reduction_last(G2tensor(327),RedSet_4(177),mass4set(:,1),  & 
G1tensor(332),G1tensor(59),G1tensor(260),G1tensor(40),G1tensor(336))
  call G_TensorShift(G1tensor(59),5)
  call Hotf_4pt_reduction_last(G2tensor(480),RedSet_4(127),mass4set(:,1),  & 
G1tensor(264),G1tensor(362),G1tensor(284),G1tensor(54),G1tensor(41))
  call G_TensorShift(G1tensor(362),21)
  call Hotf_4pt_reduction_last(G2tensor(254),RedSet_4(169),mass4set(:,1),  & 
G1tensor(278),G1tensor(48),G1tensor(320),G1tensor(52),G1tensor(296))
  call G_TensorShift(G1tensor(48),2)
  call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(180),mass4set(:,1),  & 
G1tensor(60),G1tensor(324),G1tensor(300),G1tensor(356),G1tensor(248))
  call G_TensorShift(G1tensor(324),10)
  call Hotf_4pt_reduction_last(G2tensor(259),RedSet_4(142),mass4set(:,1),  & 
G1tensor(64),G1tensor(35),G1tensor(314),G1tensor(72),G1tensor(368))
  call G_TensorShift(G1tensor(35),4)
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(4),mass4set(:,1),  & 
G1tensor(74),G1tensor(13),G1tensor(78),G1tensor(80),G1tensor(55))
  call G_TensorShift(G1tensor(13),12)
  call Hotf_4pt_reduction_last(G2tensor(241),RedSet_4(143),mass4set(:,1),  & 
G1tensor(19),G1tensor(84),G1tensor(86),G1tensor(25),G1tensor(90))
  call G_TensorShift(G1tensor(84),4)
  call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(8),mass4set(:,1),  & 
G1tensor(98),G1tensor(49),G1tensor(102),G1tensor(104),G1tensor(61))
  call G_TensorShift(G1tensor(49),12)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(144),mass4set(:,1),  & 
G1tensor(108),G1tensor(116),G1tensor(14),G1tensor(120),G1tensor(122))
  call G_TensorShift(G1tensor(116),4)
  call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(11),mass4set(:,1),  & 
G1tensor(20),G1tensor(126),G1tensor(371),G1tensor(128),G1tensor(26))
  call G_TensorShift(G1tensor(126),12)
  call Hotf_4pt_reduction_last(G2tensor(261),RedSet_4(146),mass4set(:,1),  & 
G1tensor(132),G1tensor(140),G1tensor(50),G1tensor(144),G1tensor(146))
  call G_TensorShift(G1tensor(140),4)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(18),mass4set(:,1),  & 
G1tensor(56),G1tensor(150),G1tensor(152),G1tensor(62),G1tensor(156))
  call G_TensorShift(G1tensor(150),12)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(147),mass4set(:,1),  & 
G1tensor(164),G1tensor(4),G1tensor(339),G1tensor(168),G1tensor(170))
  call G_TensorShift(G1tensor(4),4)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(21),mass4set(:,1),  & 
G1tensor(5),G1tensor(340),G1tensor(174),G1tensor(176),G1tensor(39))
  call G_TensorShift(G1tensor(340),12)
  call Hotf_4pt_reduction_last(G2tensor(242),RedSet_4(149),mass4set(:,1),  & 
G1tensor(6),G1tensor(341),G1tensor(335),G1tensor(180),G1tensor(188))
  call G_TensorShift(G1tensor(341),2)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(29),mass4set(:,1),  & 
G1tensor(15),G1tensor(345),G1tensor(192),G1tensor(194),G1tensor(30))
  call G_TensorShift(G1tensor(345),10)
  call Hotf_4pt_reduction_last(G2tensor(255),RedSet_4(150),mass4set(:,1),  & 
G1tensor(16),G1tensor(352),G1tensor(346),G1tensor(198),G1tensor(200))
  call G_TensorShift(G1tensor(352),2)
  call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(33),mass4set(:,1),  & 
G1tensor(47),G1tensor(17),G1tensor(365),G1tensor(347),G1tensor(204))
  call G_TensorShift(G1tensor(17),10)
  call Hotf_4pt_reduction_last(G2tensor(144),RedSet_4(151),mass4set(:,1),  & 
G1tensor(212),G1tensor(23),G1tensor(327),G1tensor(216),G1tensor(218))
  call G_TensorShift(G1tensor(23),2)
  call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(35),mass4set(:,1),  & 
G1tensor(24),G1tensor(328),G1tensor(222),G1tensor(224),G1tensor(58))
  call G_TensorShift(G1tensor(328),10)
  call Hotf_4pt_reduction_last(G2tensor(243),RedSet_4(152),mass4set(:,1),  & 
G1tensor(27),G1tensor(329),G1tensor(323),G1tensor(228),G1tensor(230))
  call G_TensorShift(G1tensor(329),1)
  call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(43),mass4set(:,1),  & 
G1tensor(42),G1tensor(351),G1tensor(234),G1tensor(236),G1tensor(70))
  call G_TensorShift(G1tensor(351),9)
  call Hotf_4pt_reduction_last(G2tensor(257),RedSet_4(153),mass4set(:,1),  & 
G1tensor(33),G1tensor(359),G1tensor(353),G1tensor(240),G1tensor(254))
  call G_TensorShift(G1tensor(359),1)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(47),mass4set(:,1),  & 
G1tensor(36),G1tensor(334),G1tensor(258),G1tensor(266),G1tensor(45))
  call G_TensorShift(G1tensor(334),9)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(154),mass4set(:,1),  & 
G1tensor(363),G1tensor(270),G1tensor(272),G1tensor(71),G1tensor(364))
  call G_TensorShift(G1tensor(270),1)
  call Hotf_4pt_reduction_last(G2tensor(110),RedSet_4(49),mass4set(:,1),  & 
G1tensor(276),G1tensor(290),G1tensor(57),G1tensor(322),G1tensor(294))
  call G_TensorShift(G1tensor(290),9)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(155),mass4set(:,1),  & 
G1tensor(302),G1tensor(66),G1tensor(357),G1tensor(306),G1tensor(308))
  call G_TensorShift(G1tensor(66),2)
  call Hotf_4pt_reduction_last(G2tensor(123),RedSet_4(57),mass4set(:,1),  & 
G1tensor(69),G1tensor(358),G1tensor(312),G1tensor(372),G1tensor(374))
  call G_TensorShift(G1tensor(358),18)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(156),mass4set(:,1),  & 
G1tensor(378),G1tensor(380),G1tensor(309),G1tensor(303),G1tensor(390))
  call G_TensorShift(G1tensor(380),2)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(61),mass4set(:,1),  & 
G1tensor(384),G1tensor(386),G1tensor(392),G1tensor(396),G1tensor(398))
  call G_TensorShift(G1tensor(386),18)
  call Hotf_4pt_reduction_last(G2tensor(279),RedSet_4(157),mass4set(:,1),  & 
G1tensor(273),G1tensor(267),G1tensor(408),G1tensor(402),G1tensor(404))
  call G_TensorShift(G1tensor(267),2)
  call Hotf_4pt_reduction_last(G2tensor(408),RedSet_4(64),mass4set(:,1),  & 
G1tensor(219),G1tensor(213),G1tensor(7),G1tensor(171),G1tensor(165))
  call G_TensorShift(G1tensor(213),18)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(159),mass4set(:,1),  & 
G1tensor(43),G1tensor(8),G1tensor(44),G1tensor(99),G1tensor(81))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(72),mass4set(:,1),  & 
G1tensor(75),G1tensor(87),G1tensor(76),G1tensor(93),G1tensor(77))
  call G_TensorShift(G1tensor(87),24)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(160),mass4set(:,1),  & 
G1tensor(106),G1tensor(88),G1tensor(82),G1tensor(112),G1tensor(94))
  call G_TensorShift(G1tensor(88),8)
  call Hotf_4pt_reduction_last(G2tensor(129),RedSet_4(76),mass4set(:,1),  & 
G1tensor(83),G1tensor(161),G1tensor(155),G1tensor(95),G1tensor(89))
  call G_TensorShift(G1tensor(161),24)
  call Hotf_4pt_reduction_last(G2tensor(285),RedSet_4(161),mass4set(:,1),  & 
G1tensor(105),G1tensor(100),G1tensor(111),G1tensor(101),G1tensor(137))
  call G_TensorShift(G1tensor(100),8)
  call Hotf_4pt_reduction_last(G2tensor(411),RedSet_4(79),mass4set(:,1),  & 
G1tensor(131),G1tensor(113),G1tensor(107),G1tensor(123),G1tensor(117))
  call G_TensorShift(G1tensor(113),24)
  call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(163),mass4set(:,1),  & 
G1tensor(129),G1tensor(118),G1tensor(135),G1tensor(119),G1tensor(130))
  call G_TensorShift(G1tensor(118),1)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(85),mass4set(:,1),  & 
G1tensor(124),G1tensor(136),G1tensor(125),G1tensor(147),G1tensor(141))
  call G_TensorShift(G1tensor(136),17)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(164),mass4set(:,1),  & 
G1tensor(153),G1tensor(142),G1tensor(159),G1tensor(143),G1tensor(154))
  call G_TensorShift(G1tensor(142),1)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(88),mass4set(:,1),  & 
G1tensor(148),G1tensor(160),G1tensor(149),G1tensor(250),G1tensor(177))
  call G_TensorShift(G1tensor(160),17)
  call Hotf_4pt_reduction_last(G2tensor(291),RedSet_4(165),mass4set(:,1),  & 
G1tensor(166),G1tensor(215),G1tensor(183),G1tensor(167),G1tensor(376))
  call G_TensorShift(G1tensor(215),1)
  call Hotf_4pt_reduction_last(G2tensor(405),RedSet_4(90),mass4set(:,1),  & 
G1tensor(256),G1tensor(178),G1tensor(172),G1tensor(221),G1tensor(184))
  call G_TensorShift(G1tensor(178),17)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(166),mass4set(:,1),  & 
G1tensor(173),G1tensor(299),G1tensor(263),G1tensor(227),G1tensor(185))
  call G_TensorShift(G1tensor(299),8)
  call Hotf_4pt_reduction_last(G2tensor(132),RedSet_4(95),mass4set(:,1),  & 
G1tensor(179),G1tensor(231),G1tensor(195),G1tensor(189),G1tensor(268))
  call G_TensorShift(G1tensor(231),24)
  call Hotf_4pt_reduction_last(G2tensor(294),RedSet_4(167),mass4set(:,1),  & 
G1tensor(201),G1tensor(190),G1tensor(207),G1tensor(191),G1tensor(310))
  call G_TensorShift(G1tensor(190),8)
  call Hotf_4pt_reduction_last(G2tensor(414),RedSet_4(98),mass4set(:,1),  & 
G1tensor(274),G1tensor(238),G1tensor(202),G1tensor(196),G1tensor(244))
  call G_TensorShift(G1tensor(238),24)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(170),mass4set(:,1),  & 
G1tensor(208),G1tensor(197),G1tensor(389),G1tensor(281),G1tensor(209))
  call G_TensorShift(G1tensor(197),2)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(107),mass4set(:,1),  & 
G1tensor(203),G1tensor(286),G1tensor(225),G1tensor(214),G1tensor(394))
  call G_TensorShift(G1tensor(286),18)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(172),mass4set(:,1),  & 
G1tensor(292),G1tensor(226),G1tensor(220),G1tensor(304),G1tensor(237))
  call G_TensorShift(G1tensor(226),8)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(114),mass4set(:,1),  & 
G1tensor(232),G1tensor(243),G1tensor(233),G1tensor(407),G1tensor(317))
  call G_TensorShift(G1tensor(243),24)
  call Hotf_4pt_reduction_last(G2tensor(300),RedSet_4(173),mass4set(:,1),  & 
G1tensor(245),G1tensor(239),G1tensor(255),G1tensor(249),G1tensor(261))
  call G_TensorShift(G1tensor(239),8)
  call Hotf_4pt_reduction_last(G2tensor(420),RedSet_4(117),mass4set(:,1),  & 
G1tensor(251),G1tensor(406),G1tensor(262),G1tensor(257),G1tensor(279))
  call G_TensorShift(G1tensor(406),24)
  call Hotf_4pt_reduction_last(G2tensor(87),RedSet_4(176),mass4set(:,1),  & 
G1tensor(269),G1tensor(395),G1tensor(280),G1tensor(275),G1tensor(291))
  call G_TensorShift(G1tensor(395),1)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(125),mass4set(:,1),  & 
G1tensor(285),G1tensor(297),G1tensor(287),G1tensor(388),G1tensor(298))
  call G_TensorShift(G1tensor(297),17)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(178),mass4set(:,1),  & 
G1tensor(293),G1tensor(315),G1tensor(305),G1tensor(377),G1tensor(316))
  call G_TensorShift(G1tensor(315),8)
  call Hotf_4pt_reduction_last(G2tensor(135),RedSet_4(132),mass4set(:,1),  & 
G1tensor(311),G1tensor(369),G1tensor(370),G1tensor(375),G1tensor(381))
  call G_TensorShift(G1tensor(369),24)
  call Hotf_4pt_reduction_last(G2tensor(306),RedSet_4(179),mass4set(:,1),  & 
G1tensor(382),G1tensor(383),G1tensor(387),G1tensor(393),G1tensor(399))
  call G_TensorShift(G1tensor(383),8)
  call Hotf_4pt_reduction_last(G2tensor(417),RedSet_4(135),mass4set(:,1),  & 
G1tensor(400),G1tensor(401),G1tensor(405),G1tensor(409),G1tensor(410))
  call G_TensorShift(G1tensor(401),24)
  call Hotf_4pt_reduction_last(G2tensor(462),RedSet_4(183),mass4set(:,1),  & 
G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414),G1tensor(415))
  call G_TensorShift(G1tensor(412),6)
  call Hotf_4pt_reduction_last(G2tensor(312),RedSet_4(204),mass4set(:,1),  & 
G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(417),2)
  call Hotf_4pt_reduction_last(G2tensor(453),RedSet_4(138),mass4set(:,1),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425))
  call G_TensorShift(G1tensor(422),18)
  call Hotf_4pt_reduction_last(G2tensor(318),RedSet_4(130),mass4set(:,1),  & 
G1tensor(426),G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430))
  call G_TensorShift(G1tensor(427),16)
  call Hotf_4pt_reduction_last(G2tensor(477),RedSet_4(139),mass4set(:,1),  & 
G1tensor(431),G1tensor(432),G1tensor(433),G1tensor(434),G1tensor(435))
  call G_TensorShift(G1tensor(432),21)
  call Hotf_4pt_reduction_last(G2tensor(324),RedSet_4(205),mass4set(:,1),  & 
G1tensor(436),G1tensor(437),G1tensor(438),G1tensor(439),G1tensor(440))
  call G_TensorShift(G1tensor(437),5)
  call Hotf_4pt_reduction_last(G2tensor(330),RedSet_4(206),mass4set(:,1),  & 
G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444),G1tensor(445))
  call G_TensorShift(G1tensor(442),1)
  call Hotf_4pt_reduction_last(G2tensor(459),RedSet_4(140),mass4set(:,1),  & 
G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(447),17)
  call Hotf_4pt_reduction_last(G2tensor(336),RedSet_4(112),mass4set(:,1),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455))
  call G_TensorShift(G1tensor(452),16)
  call Hotf_4pt_reduction_last(G2tensor(483),RedSet_4(141),mass4set(:,1),  & 
G1tensor(456),G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460))
  call G_TensorShift(G1tensor(457),22)
  call Hotf_4pt_reduction_last(G2tensor(342),RedSet_4(207),mass4set(:,1),  & 
G1tensor(461),G1tensor(462),G1tensor(463),G1tensor(464),G1tensor(465))
  call G_TensorShift(G1tensor(462),6)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(83),mass4set(:,1),  & 
G1tensor(466),G1tensor(467),G1tensor(468),G1tensor(469),G1tensor(470))
  call G_TensorShift(G1tensor(467),16)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(54),mass4set(:,1),  & 
G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474),G1tensor(475))
  call G_TensorShift(G1tensor(472),16)
  call Hotf_4pt_reduction_last(G2tensor(273),RedSet_4(202),mass4set(:,1),  & 
G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(477),16)
  call Hotf_4pt_reduction_last(G2tensor(276),RedSet_4(203),mass4set(:,1),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485))
  call G_TensorShift(G1tensor(482),16)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(1),mass4set(:,1),  & 
G1tensor(486),G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490))
  call G_TensorShift(G1tensor(487),8)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(2),mass4set(:,1),  & 
G1tensor(491),G1tensor(492),G1tensor(493),G1tensor(494),G1tensor(495))
  call G_TensorShift(G1tensor(492),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(3),mass4set(:,1),  & 
G1tensor(496),G1tensor(497),G1tensor(498),G1tensor(499),G1tensor(500))
  call G_TensorShift(G1tensor(497),8)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(6),mass4set(:,1),  & 
G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504),G1tensor(505))
  call G_TensorShift(G1tensor(502),8)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(7),mass4set(:,1),  & 
G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(507),8)
  call Hotf_4pt_reduction_last(G2tensor(348),RedSet_4(10),mass4set(:,1),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515))
  call G_TensorShift(G1tensor(512),8)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(16),mass4set(:,1),  & 
G1tensor(516),G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520))
  call G_TensorShift(G1tensor(517),8)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(17),mass4set(:,1),  & 
G1tensor(521),G1tensor(522),G1tensor(523),G1tensor(524),G1tensor(525))
  call G_TensorShift(G1tensor(522),8)
  call Hotf_4pt_reduction_last(G2tensor(351),RedSet_4(20),mass4set(:,1),  & 
G1tensor(526),G1tensor(527),G1tensor(528),G1tensor(529),G1tensor(530))
  call G_TensorShift(G1tensor(527),8)
  call Hotf_4pt_reduction_last(G2tensor(366),RedSet_4(26),mass4set(:,1),  & 
G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534),G1tensor(535))
  call G_TensorShift(G1tensor(532),8)
  call Hotf_4pt_reduction_last(G2tensor(102),RedSet_4(27),mass4set(:,1),  & 
G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(537),8)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(28),mass4set(:,1),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545))
  call G_TensorShift(G1tensor(542),8)
  call Hotf_4pt_reduction_last(G2tensor(369),RedSet_4(31),mass4set(:,1),  & 
G1tensor(546),G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550))
  call G_TensorShift(G1tensor(547),8)
  call Hotf_4pt_reduction_last(G2tensor(267),RedSet_4(32),mass4set(:,1),  & 
G1tensor(551),G1tensor(552),G1tensor(553),G1tensor(554),G1tensor(555))
  call G_TensorShift(G1tensor(552),8)
  call Hotf_4pt_reduction_last(G2tensor(372),RedSet_4(40),mass4set(:,1),  & 
G1tensor(556),G1tensor(557),G1tensor(558),G1tensor(559),G1tensor(560))
  call G_TensorShift(G1tensor(557),8)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(41),mass4set(:,1),  & 
G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564),G1tensor(565))
  call G_TensorShift(G1tensor(562),8)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(42),mass4set(:,1),  & 
G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(567),8)
  call Hotf_4pt_reduction_last(G2tensor(375),RedSet_4(45),mass4set(:,1),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575))
  call G_TensorShift(G1tensor(572),8)
  call Hotf_4pt_reduction_last(G2tensor(270),RedSet_4(46),mass4set(:,1),  & 
G1tensor(576),G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580))
  call G_TensorShift(G1tensor(577),8)
  call Hotf_4pt_reduction_last(G2tensor(378),RedSet_4(55),mass4set(:,1),  & 
G1tensor(581),G1tensor(582),G1tensor(583),G1tensor(584),G1tensor(585))
  call G_TensorShift(G1tensor(582),16)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(56),mass4set(:,1),  & 
G1tensor(586),G1tensor(587),G1tensor(588),G1tensor(589),G1tensor(590))
  call G_TensorShift(G1tensor(587),16)
  call Hotf_4pt_reduction_last(G2tensor(381),RedSet_4(59),mass4set(:,1),  & 
G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594),G1tensor(595))
  call G_TensorShift(G1tensor(592),16)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(60),mass4set(:,1),  & 
G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(597),16)
  call Hotf_4pt_reduction_last(G2tensor(282),RedSet_4(63),mass4set(:,1),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605))
  call G_TensorShift(G1tensor(602),16)
  call Hotf_4pt_reduction_last(G2tensor(108),RedSet_4(69),mass4set(:,1),  & 
G1tensor(606),G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610))
  call G_TensorShift(G1tensor(607),16)
  call Hotf_4pt_reduction_last(G2tensor(384),RedSet_4(70),mass4set(:,1),  & 
G1tensor(611),G1tensor(612),G1tensor(613),G1tensor(614),G1tensor(615))
  call G_TensorShift(G1tensor(612),16)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(71),mass4set(:,1),  & 
G1tensor(616),G1tensor(617),G1tensor(618),G1tensor(619),G1tensor(620))
  call G_TensorShift(G1tensor(617),16)
  call Hotf_4pt_reduction_last(G2tensor(387),RedSet_4(74),mass4set(:,1),  & 
G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624),G1tensor(625))
  call G_TensorShift(G1tensor(622),16)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(75),mass4set(:,1),  & 
G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(627),16)
  call Hotf_4pt_reduction_last(G2tensor(288),RedSet_4(78),mass4set(:,1),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635))
  call G_TensorShift(G1tensor(632),16)
  call Hotf_4pt_reduction_last(G2tensor(390),RedSet_4(84),mass4set(:,1),  & 
G1tensor(636),G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640))
  call G_TensorShift(G1tensor(637),16)
  call Hotf_4pt_reduction_last(G2tensor(393),RedSet_4(87),mass4set(:,1),  & 
G1tensor(641),G1tensor(642),G1tensor(643),G1tensor(644),G1tensor(645))
  call G_TensorShift(G1tensor(642),16)
  call Hotf_4pt_reduction_last(G2tensor(396),RedSet_4(93),mass4set(:,1),  & 
G1tensor(646),G1tensor(647),G1tensor(648),G1tensor(649),G1tensor(650))
  call G_TensorShift(G1tensor(647),16)
  call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(94),mass4set(:,1),  & 
G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654),G1tensor(655))
  call G_TensorShift(G1tensor(652),16)
  call Hotf_4pt_reduction_last(G2tensor(297),RedSet_4(97),mass4set(:,1),  & 
G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(657),16)
  call Hotf_4pt_reduction_last(G2tensor(399),RedSet_4(102),mass4set(:,1),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665))
  call G_TensorShift(G1tensor(662),16)
  call Hotf_4pt_reduction_last(G2tensor(354),RedSet_4(103),mass4set(:,1),  & 
G1tensor(666),G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670))
  call G_TensorShift(G1tensor(667),16)
  call Hotf_4pt_reduction_last(G2tensor(450),RedSet_4(106),mass4set(:,1),  & 
G1tensor(671),G1tensor(672),G1tensor(673),G1tensor(674),G1tensor(675))
  call G_TensorShift(G1tensor(672),16)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(113),mass4set(:,1),  & 
G1tensor(676),G1tensor(677),G1tensor(678),G1tensor(679),G1tensor(680))
  call G_TensorShift(G1tensor(677),16)
  call Hotf_4pt_reduction_last(G2tensor(333),RedSet_4(116),mass4set(:,1),  & 
G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684),G1tensor(685))
  call G_TensorShift(G1tensor(682),16)
  call Hotf_4pt_reduction_last(G2tensor(402),RedSet_4(121),mass4set(:,1),  & 
G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(687),16)
  call Hotf_4pt_reduction_last(G2tensor(360),RedSet_4(122),mass4set(:,1),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695))
  call G_TensorShift(G1tensor(692),16)
  call Hotf_4pt_reduction_last(G2tensor(435),RedSet_4(124),mass4set(:,1),  & 
G1tensor(696),G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700))
  call G_TensorShift(G1tensor(697),16)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(131),mass4set(:,1),  & 
G1tensor(701),G1tensor(702),G1tensor(703),G1tensor(704),G1tensor(705))
  call G_TensorShift(G1tensor(702),16)
  call Hotf_4pt_reduction_last(G2tensor(315),RedSet_4(134),mass4set(:,1),  & 
G1tensor(706),G1tensor(707),G1tensor(708),G1tensor(709),G1tensor(710))
  call G_TensorShift(G1tensor(707),16)
  call Hotf_4pt_reduction_last(G2tensor(141),RedSet_4(181),mass4set(:,1),  & 
G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714),G1tensor(715))
  call G_TensorShift(G1tensor(712),2)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(182),mass4set(:,1),  & 
G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(717),2)
  call Hotf_4pt_reduction_last(G2tensor(423),RedSet_4(184),mass4set(:,1),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725))
  call G_TensorShift(G1tensor(722),16)
  call Hotf_4pt_reduction_last(G2tensor(426),RedSet_4(186),mass4set(:,1),  & 
G1tensor(726),G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730))
  call G_TensorShift(G1tensor(727),5)
  call Hotf_4pt_reduction_last(G2tensor(429),RedSet_4(187),mass4set(:,1),  & 
G1tensor(731),G1tensor(732),G1tensor(733),G1tensor(734),G1tensor(735))
  call G_TensorShift(G1tensor(732),5)
  call Hotf_4pt_reduction_last(G2tensor(321),RedSet_4(188),mass4set(:,1),  & 
G1tensor(736),G1tensor(737),G1tensor(738),G1tensor(739),G1tensor(740))
  call G_TensorShift(G1tensor(737),5)
  call Hotf_4pt_reduction_last(G2tensor(432),RedSet_4(190),mass4set(:,1),  & 
G1tensor(741),G1tensor(742),G1tensor(743),G1tensor(744),G1tensor(745))
  call G_TensorShift(G1tensor(742),16)
  call Hotf_4pt_reduction_last(G2tensor(438),RedSet_4(192),mass4set(:,1),  & 
G1tensor(746),G1tensor(747),G1tensor(748),G1tensor(749),G1tensor(750))
  call G_TensorShift(G1tensor(747),16)
  call Hotf_4pt_reduction_last(G2tensor(441),RedSet_4(194),mass4set(:,1),  & 
G1tensor(751),G1tensor(752),G1tensor(753),G1tensor(754),G1tensor(755))
  call G_TensorShift(G1tensor(752),6)
  call Hotf_4pt_reduction_last(G2tensor(444),RedSet_4(195),mass4set(:,1),  & 
G1tensor(756),G1tensor(757),G1tensor(758),G1tensor(759),G1tensor(760))
  call G_TensorShift(G1tensor(757),6)
  call Hotf_4pt_reduction_last(G2tensor(339),RedSet_4(196),mass4set(:,1),  & 
G1tensor(761),G1tensor(762),G1tensor(763),G1tensor(764),G1tensor(765))
  call G_TensorShift(G1tensor(762),6)
  call Hotf_4pt_reduction_last(G2tensor(447),RedSet_4(198),mass4set(:,1),  & 
G1tensor(766),G1tensor(767),G1tensor(768),G1tensor(769),G1tensor(770))
  call G_TensorShift(G1tensor(767),16)
  call Hotf_4pt_reduction_last(G2tensor(244),RedSet_4(215),mass4set(:,1),  & 
G1tensor(771),G1tensor(772),G1tensor(773),G1tensor(774),G1tensor(775))
  call G_TensorShift(G1tensor(772),17)
  call Hotf_4pt_reduction_last(G2tensor(246),RedSet_4(216),mass4set(:,1),  & 
G1tensor(776),G1tensor(777),G1tensor(778),G1tensor(779),G1tensor(780))
  call G_TensorShift(G1tensor(777),18)
  call Hotf_4pt_reduction_last(G2tensor(248),RedSet_4(217),mass4set(:,1),  & 
G1tensor(781),G1tensor(782),G1tensor(783),G1tensor(784),G1tensor(785))
  call G_TensorShift(G1tensor(782),20)
  call Hotf_4pt_reduction_last(G2tensor(249),RedSet_4(218),mass4set(:,1),  & 
G1tensor(786),G1tensor(787),G1tensor(788),G1tensor(789),G1tensor(790))
  call G_TensorShift(G1tensor(787),20)
  call Hotf_4pt_reduction_last(G2tensor(263),RedSet_4(200),mass4set(:,1),  & 
G1tensor(791),G1tensor(792),G1tensor(793),G1tensor(794),G1tensor(795))
  call G_TensorShift(G1tensor(792),8)
  call Hotf_4pt_reduction_last(G2tensor(265),RedSet_4(201),mass4set(:,1),  & 
G1tensor(796),G1tensor(797),G1tensor(798),G1tensor(799),G1tensor(800))
  call G_TensorShift(G1tensor(797),8)
  call Hotf_4pt_reduction_last(G2tensor(456),RedSet_4(208),mass4set(:,1),  & 
G1tensor(801),G1tensor(802),G1tensor(803),G1tensor(804),G1tensor(805))
  call G_TensorShift(G1tensor(802),5)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(145),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(148),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(104),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(123),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(13),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(23),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(37),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(51),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(209),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(158),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(66),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(210),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(162),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(211),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(110),RedSet_4(212),mass4set(:,1),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(32),RedSet_4(168),mass4set(:,1),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(348),RedSet_4(213),mass4set(:,1),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(114),RedSet_4(171),mass4set(:,1),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(282),RedSet_4(109),mass4set(:,1),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(175),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(344),RedSet_4(174),mass4set(:,1),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(214),mass4set(:,1),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(332),RedSet_4(177),mass4set(:,1),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(264),RedSet_4(127),mass4set(:,1),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(278),RedSet_4(169),mass4set(:,1),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(60),RedSet_4(180),mass4set(:,1),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(64),RedSet_4(142),mass4set(:,1),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(74),RedSet_4(4),mass4set(:,1),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(19),RedSet_4(143),mass4set(:,1),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(98),RedSet_4(8),mass4set(:,1),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(108),RedSet_4(144),mass4set(:,1),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(11),mass4set(:,1),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(132),RedSet_4(146),mass4set(:,1),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(18),mass4set(:,1),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(164),RedSet_4(147),mass4set(:,1),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(21),mass4set(:,1),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))



end subroutine vamp_2

end module ol_vamp_2_ppwajj_uuuxdxaw_1_/**/REALKIND
