
module ol_vamp_2_ppwajj_udxawgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwajj_udxawgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwajj_udxawgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwajj_udxawgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwajj_udxawgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwajj_udxawgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwajj_udxawgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  Gcoeff(:)%j = (c(23)*(M(1,:)%j-M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(46),h0tab(:,46),[48,1,8,4,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H96(1),ex6(:),ex5(:),G0H24(6),m4h2x2x24(:,6),heltab3x96(:,:,6))
  Gcoeff(:)%j = (c(11)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(47),h0tab(:,47),[32,5,16,2,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,41),heltab2x96(:,:,41))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(1),n2h48(31))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)-c(25)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(48),h0tab(:,48),[32,5,8,2,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(2),m3h2x48(:,42),heltab2x96(:,:,42))
  Gcoeff(:)%j = (c(11)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(49),h0tab(:,49),[32,2,8,16,5],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(3),m3h2x48(:,43),heltab2x96(:,:,43))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)-c(25)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(50),h0tab(:,50),[32,2,8,5,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(4),m3h2x48(:,44),heltab2x96(:,:,44))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(51),h0tab(:,51),[32,5,2,8,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,45),heltab2x96(:,:,45))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(5),n2h48(32))
  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(52),h0tab(:,52),[32,8,2,5,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,46),heltab2x96(:,:,46))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(6),n2h48(33))
  Gcoeff(:)%j = (c(11)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(53),h0tab(:,53),[32,2,16,8,5],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(7),m3h2x48(:,47),heltab2x96(:,:,47))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(54),h0tab(:,54),[32,2,16,5,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,48),heltab2x96(:,:,48))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(8),n2h48(34))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(55),h0tab(:,55),[32,5,2,16,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,49),heltab2x96(:,:,49))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(9),n2h48(35))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(56),h0tab(:,56),[32,8,5,2,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,50),heltab2x96(:,:,50))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(10),n2h48(36))
  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(57),h0tab(:,57),[32,2,5,16,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,51),heltab2x96(:,:,51))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(11),n2h48(37))
  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(58),h0tab(:,58),[32,2,5,8,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,52),heltab2x96(:,:,52))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(12),n2h48(38))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(59),h0tab(:,59),[32,6,16,1,8],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,53),heltab2x96(:,:,53))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(13),n2h48(39))
  Gcoeff(:)%j = (c(23)*M(2,:)%j+c(21)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(60),h0tab(:,60),[32,6,8,1,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(14),m3h2x48(:,54),heltab2x96(:,:,54))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(61),h0tab(:,61),[32,1,8,16,6],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(15),m3h2x48(:,55),heltab2x96(:,:,55))
  Gcoeff(:)%j = (c(23)*M(1,:)%j+c(21)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(62),h0tab(:,62),[32,1,8,6,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(16),m3h2x48(:,56),heltab2x96(:,:,56))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(63),h0tab(:,63),[32,6,1,8,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,57),heltab2x96(:,:,57))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(17),n2h48(40))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(64),h0tab(:,64),[32,8,1,6,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,58),heltab2x96(:,:,58))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(18),n2h48(41))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(65),h0tab(:,65),[32,1,16,8,6],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(19),m3h2x48(:,59),heltab2x96(:,:,59))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(66),h0tab(:,66),[32,1,16,6,8],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,60),heltab2x96(:,:,60))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(20),n2h48(42))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(67),h0tab(:,67),[32,6,1,16,8],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,61),heltab2x96(:,:,61))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(21),n2h48(43))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(68),h0tab(:,68),[32,8,6,1,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,62),heltab2x96(:,:,62))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(22),n2h48(44))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(69),h0tab(:,69),[32,1,6,16,8],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,63),heltab2x96(:,:,63))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(23),n2h48(45))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(70),h0tab(:,70),[32,1,6,8,16],[0,0,0,0,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,64),heltab2x96(:,:,64))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(24),n2h48(46))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(71),h0tab(:,71),[32,4,2,16,9],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,65),heltab2x96(:,:,65))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(25),n2h48(47))
  Gcoeff(:)%j = (c(23)*M(1,:)%j+c(21)*M(3,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(72),h0tab(:,72),[32,9,4,2,16],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(26),m3h2x48(:,66),heltab2x96(:,:,66))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(73),h0tab(:,73),[32,2,4,16,9],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(27),m3h2x48(:,67),heltab2x96(:,:,67))
  Gcoeff(:)%j = (c(23)*M(2,:)%j+c(21)*M(3,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(74),h0tab(:,74),[32,2,4,9,16],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(28),m3h2x48(:,68),heltab2x96(:,:,68))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(75),h0tab(:,75),[32,9,2,4,16],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,69),heltab2x96(:,:,69))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(29),n2h48(48))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(76),h0tab(:,76),[32,4,2,9,16],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,70),heltab2x96(:,:,70))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(30),n2h48(49))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(77),h0tab(:,77),[32,2,16,4,9],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(31),m3h2x48(:,71),heltab2x96(:,:,71))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(78),h0tab(:,78),[32,2,16,9,4],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,72),heltab2x96(:,:,72))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(32),n2h48(50))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(79),h0tab(:,79),[32,4,16,2,9],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,73),heltab2x96(:,:,73))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(33),n2h48(51))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(80),h0tab(:,80),[32,4,9,2,16],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,74),heltab2x96(:,:,74))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(34),n2h48(52))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(81),h0tab(:,81),[32,2,9,16,4],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,75),heltab2x96(:,:,75))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(35),n2h48(53))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(82),h0tab(:,82),[32,2,9,4,16],[0,0,0,0,0],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,76),heltab2x96(:,:,76))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(36),n2h48(54))
  Gcoeff(:)%j = (c(11)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(83),h0tab(:,83),[32,4,1,16,10],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,77),heltab2x96(:,:,77))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(37),n2h48(55))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)-c(25)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(84),h0tab(:,84),[32,10,4,1,16],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(38),m3h2x48(:,78),heltab2x96(:,:,78))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(85),h0tab(:,85),[32,1,4,16,10],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(39),m3h2x48(:,79),heltab2x96(:,:,79))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)-c(25)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(86),h0tab(:,86),[32,1,4,10,16],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(40),m3h2x48(:,80),heltab2x96(:,:,80))
  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(87),h0tab(:,87),[32,10,1,4,16],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,81),heltab2x96(:,:,81))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(41),n2h48(56))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(88),h0tab(:,88),[32,4,1,10,16],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,82),heltab2x96(:,:,82))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(42),n2h48(57))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(89),h0tab(:,89),[32,1,16,4,10],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(43),m3h2x48(:,83),heltab2x96(:,:,83))
  Gcoeff(:)%j = (c(11)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(90),h0tab(:,90),[32,1,16,10,4],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,84),heltab2x96(:,:,84))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(44),n2h48(58))
  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(91),h0tab(:,91),[32,4,16,1,10],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,85),heltab2x96(:,:,85))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(45),n2h48(59))
  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(92),h0tab(:,92),[32,4,10,1,16],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,86),heltab2x96(:,:,86))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(46),n2h48(60))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(93),h0tab(:,93),[32,1,10,16,4],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,87),heltab2x96(:,:,87))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(47),n2h48(61))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(94),h0tab(:,94),[32,1,10,4,16],[0,0,0,0,0],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,88),heltab2x96(:,:,88))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(48),n2h48(62))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(95),h0tab(:,95),[32,2,1,16,12],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,89),heltab2x96(:,:,89))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(49),n2h48(63))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(96),h0tab(:,96),[32,12,2,1,16],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,90),heltab2x96(:,:,90))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(50),n2h48(64))
  Gcoeff(:)%j = (c(28)*M(1,:)%j-c(29)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(97),h0tab(:,97),[32,1,2,16,12],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,91),heltab2x96(:,:,91))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(51),n2h48(65))
  Gcoeff(:)%j = (c(28)*M(1,:)%j-c(29)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(98),h0tab(:,98),[32,1,2,12,16],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,92),heltab2x96(:,:,92))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(52),n2h48(66))
  Gcoeff(:)%j = (c(28)*M(1,:)%j-c(29)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(99),h0tab(:,99),[32,12,1,2,16],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,93),heltab2x96(:,:,93))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(53),n2h48(67))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(100),h0tab(:,100),[32,2,1,12,16],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,94),heltab2x96(:,:,94))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(54),n2h48(68))
  Gcoeff(:)%j = (c(16)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(101),h0tab(:,101),[32,1,16,2,12],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,95),heltab2x96(:,:,95))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(55),n2h48(69))
  Gcoeff(:)%j = (-(c(16)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(102),h0tab(:,102),[32,1,16,12,2],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(56),m3h2x48(:,96),heltab2x96(:,:,96))
  Gcoeff(:)%j = (-(c(16)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(103),h0tab(:,103),[32,2,16,1,12],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,97),heltab2x96(:,:,97))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(57),n2h48(70))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)-c(29)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(104),h0tab(:,104),[32,2,12,1,16],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(58),m3h2x48(:,98),heltab2x96(:,:,98))
  Gcoeff(:)%j = (-(c(16)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(105),h0tab(:,105),[32,1,12,16,2],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(59),m3h2x48(:,99),heltab2x96(:,:,99))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)-c(29)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(106),h0tab(:,106),[32,1,12,2,16],[0,0,0,0,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(60),m3h2x48(:,100),heltab2x96(:,:,100))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(107),h0tab(:,107),[32,2,4,8,17],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(61),m3h2x48(:,101),heltab2x96(:,:,101))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(108),h0tab(:,108),[32,8,4,2,17],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,102),heltab2x96(:,:,102))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(62),n2h48(71))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(109),h0tab(:,109),[32,4,2,17,8],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,103),heltab2x96(:,:,103))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(63),n2h48(72))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(110),h0tab(:,110),[32,2,8,4,17],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(64),m3h2x48(:,104),heltab2x96(:,:,104))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(111),h0tab(:,111),[32,4,8,2,17],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,105),heltab2x96(:,:,105))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(65),n2h48(73))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(112),h0tab(:,112),[32,4,17,2,8],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,106),heltab2x96(:,:,106))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(66),n2h48(74))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(113),h0tab(:,113),[32,2,17,8,4],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,107),heltab2x96(:,:,107))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(67),n2h48(75))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(114),h0tab(:,114),[32,2,17,4,8],[0,0,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,108),heltab2x96(:,:,108))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(68),n2h48(76))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(115),h0tab(:,115),[32,1,4,8,18],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(69),m3h2x48(:,109),heltab2x96(:,:,109))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(116),h0tab(:,116),[32,8,4,1,18],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,110),heltab2x96(:,:,110))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(70),n2h48(77))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(117),h0tab(:,117),[32,4,1,18,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,111),heltab2x96(:,:,111))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(71),n2h48(78))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(118),h0tab(:,118),[32,1,8,4,18],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(72),m3h2x48(:,112),heltab2x96(:,:,112))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(119),h0tab(:,119),[32,4,8,1,18],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,113),heltab2x96(:,:,113))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(73),n2h48(79))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(120),h0tab(:,120),[32,4,18,1,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,114),heltab2x96(:,:,114))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(74),n2h48(80))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(121),h0tab(:,121),[32,1,18,8,4],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,115),heltab2x96(:,:,115))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(75),n2h48(81))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(122),h0tab(:,122),[32,1,18,4,8],[0,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,116),heltab2x96(:,:,116))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(76),n2h48(82))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(123),h0tab(:,123),[33,8,4,2,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(7),m3h4x24(:,1),heltab2x96(:,:,117))
  call Hloop_Q_A(ntryL,G0H24(7),33,0,G1H24(17),n2h24(35))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(124),h0tab(:,124),[33,2,4,8,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,13),G0H24(7),m3h4x24(:,2),heltab2x96(:,:,118))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(125),h0tab(:,125),[33,2,4,16,8],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,13),G0H24(8),m3h4x24(:,3),heltab2x96(:,:,119))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(126),h0tab(:,126),[33,4,8,2,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(9),m3h4x24(:,4),heltab2x96(:,:,120))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(1),n2h24(36))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(127),h0tab(:,127),[33,2,8,4,16],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,13),G0H24(9),m3h4x24(:,5),heltab2x96(:,:,121))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(128),h0tab(:,128),[33,2,8,16,4],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,13),G0H24(10),m3h4x24(:,6),heltab2x96(:,:,122))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(129),h0tab(:,129),[33,2,16,4,8],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,13),G0H24(11),m3h4x24(:,7),heltab2x96(:,:,123))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(130),h0tab(:,130),[33,2,16,8,4],[0,0,0,0,0],5,1,wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,13),G0H24(12),m3h4x24(:,8),heltab2x96(:,:,124))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(131),h0tab(:,131),[34,8,4,1,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,7),G0H24(13),m3h4x24(:,9),heltab2x96(:,:,125))
  call Hloop_A_Q(ntryL,G0H24(13),34,0,G1H24(18),n2h24(37))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(132),h0tab(:,132),[34,1,4,8,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,7),G0H24(13),m3h4x24(:,10),heltab2x96(:,:,126))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(133),h0tab(:,133),[34,1,4,16,8],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,7),G0H24(14),m3h4x24(:,11),heltab2x96(:,:,127))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(134),h0tab(:,134),[34,4,8,1,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,7),G0H24(15),m3h4x24(:,12),heltab2x96(:,:,128))
  call Hloop_A_Q(ntryL,G0H24(15),34,0,G1H24(19),n2h24(38))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(135),h0tab(:,135),[34,1,8,4,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,7),G0H24(15),m3h4x24(:,13),heltab2x96(:,:,129))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(136),h0tab(:,136),[34,1,8,16,4],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,7),G0H24(16),m3h4x24(:,14),heltab2x96(:,:,130))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(137),h0tab(:,137),[34,1,16,4,8],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,7),G0H24(17),m3h4x24(:,15),heltab2x96(:,:,131))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(138),h0tab(:,138),[34,1,16,8,4],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,7),G0H24(18),m3h4x24(:,16),heltab2x96(:,:,132))
  Gcoeff(:)%j = (c(10)*(-M(1,:)%j+M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(139),h0tab(:,139),[48,4,1,2,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(19),m3h4x24(:,17),heltab2x96(:,:,133))
  call Hloop_A_Q(ntryL,G0H24(19),48,0,G1H24(20),n2h24(39))
  Gcoeff(:)%j = (c(10)*(-M(1,:)%j+M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(140),h0tab(:,140),[48,2,1,4,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(19),m3h4x24(:,18),heltab2x96(:,:,134))
  call Hloop_Q_A(ntryL,G0H24(19),48,0,G1H24(21),n2h24(40))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(141),h0tab(:,141),[48,4,2,1,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(19),m3h4x24(:,19),heltab2x96(:,:,135))
  call Hloop_Q_A(ntryL,G0H24(19),48,0,G1H24(22),n2h24(41))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(142),h0tab(:,142),[48,2,1,8,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(19),m3h4x24(:,20),heltab2x96(:,:,136))
  call Hloop_Q_A(ntryL,G0H24(19),48,0,G1H24(24),n2h24(42))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(143),h0tab(:,143),[48,1,2,4,8],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(19),m3h4x24(:,21),heltab2x96(:,:,137))
  call Hloop_A_Q(ntryL,G0H24(19),48,0,G1H24(25),n2h24(43))
  Gcoeff(:)%j = (c(10)*(-M(1,:)%j+M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(144),h0tab(:,144),[48,1,2,8,4],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(19),m3h4x24(:,22),heltab2x96(:,:,138))
  call Hloop_A_Q(ntryL,G0H24(19),48,0,G1H24(26),n2h24(44))
  Gcoeff(:)%j = (c(27)*(-M(1,:)%j+M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(145),h0tab(:,145),[48,1,4,8,2],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf4(:,2),48,G1H24(3),m3h4x24(:,23),heltab2x96(:,:,139))
  Gcoeff(:)%j = (c(23)*(M(1,:)%j-M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(146),h0tab(:,146),[48,1,8,4,2],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf4(:,2),48,G1H24(4),m3h4x24(:,24),heltab2x96(:,:,140))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(18),[G1H24(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(1),[G1H24(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(19),[G1H24(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(17),[G1H24(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(3),[G0H24(3),G0H24(2),G0H24(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(4),[G0H24(6),G0H24(5),G0H24(4)])
  call Hloop_AV_Q(ntryL,G1H16(3),ex3(:),G1H8(17),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(17),44,0,G2H8(3),n2h8(47))
  call Hloop_AW_Q(ntryL,G1H24(2),ex4(:),G1H8(18),m3h3x8(:,27),heltab2x24(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(18),44,0,G2H8(6),n2h8(48))
  call Hloop_QV_A(ntryL,G1H24(23),ex5(:),G1H12(143),m3h2x12(:,67),heltab2x24(:,:,94))
  call Hloop_Q_A(ntryL,G1H12(143),52,0,G2H12(24),n2h12(85))
  call Hloop_QV_A(ntryL,G1H16(9),ex3(:),G1H8(35),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(35),44,0,G2H8(7),n2h8(49))
  call Hloop_QW_A(ntryL,G1H24(27),ex4(:),G1H8(36),m3h3x8(:,28),heltab2x24(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(36),44,0,G2H8(8),n2h8(50))
  call Hloop_AV_Q(ntryL,G1H24(33),ex5(:),G1H12(144),m3h2x12(:,68),heltab2x24(:,:,96))
  call Hloop_A_Q(ntryL,G1H12(144),52,0,G2H12(26),n2h12(86))
  call Hloop_AW_Q(ntryL,G1H24(18),ex4(:),G1H8(53),m3h3x8(:,29),heltab2x24(:,:,97))
  call Hloop_A_Q(ntryL,G1H8(53),42,0,G2H8(10),n2h8(51))
  call Hloop_QV_A(ntryL,G1H24(1),ex3(:),G1H12(161),m3h2x12(:,69),heltab2x24(:,:,98))
  call Hloop_Q_A(ntryL,G1H12(161),37,0,G2H12(27),n2h12(87))
  call Hloop_QV_A(ntryL,G1H24(42),ex3(:),G1H12(162),m3h2x12(:,70),heltab2x24(:,:,99))
  call Hloop_Q_A(ntryL,G1H12(162),37,0,G2H12(29),n2h12(88))
  call Hloop_QV_A(ntryL,G1H24(48),ex3(:),G1H12(179),m3h2x12(:,71),heltab2x24(:,:,100))
  call Hloop_Q_A(ntryL,G1H12(179),37,0,G2H12(31),n2h12(89))
  call Hloop_AV_Q(ntryL,G1H24(19),ex3(:),G1H12(180),m3h2x12(:,72),heltab2x24(:,:,101))
  call Hloop_A_Q(ntryL,G1H12(180),38,0,G2H12(32),n2h12(90))
  call Hloop_QW_A(ntryL,G1H24(17),ex4(:),G1H8(54),m3h3x8(:,30),heltab2x24(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(54),41,0,G2H8(11),n2h8(52))
  call Hloop_QW_A(ntryL,G1H24(65),ex4(:),G1H8(71),m3h3x8(:,31),heltab2x24(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(71),41,0,G2H8(13),n2h8(53))
  call Hloop_QW_A(ntryL,G1H24(71),ex4(:),G1H8(72),m3h3x8(:,32),heltab2x24(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(72),41,0,G2H8(16),n2h8(54))
  call Hloop_QV_A(ntryL,G1H24(76),ex5(:),G1H12(197),m3h2x12(:,73),heltab2x24(:,:,105))
  call Hloop_Q_A(ntryL,G1H12(197),49,0,G2H12(34),n2h12(91))
  call Hloop_QV_A(ntryL,G1H24(81),ex5(:),G1H12(198),m3h2x12(:,74),heltab2x24(:,:,106))
  call Hloop_Q_A(ntryL,G1H12(198),49,0,G2H12(37),n2h12(92))
  call Hloop_VQ_A(ntryL,G1H24(3),ex1(:),G1H12(215),m3h2x12(:,75),heltab2x24(:,:,107))
  call Hloop_Q_A(ntryL,G1H12(215),49,0,G2H12(38),n2h12(93))
  call Hloop_VQ_A(ntryL,G1H24(4),ex1(:),G1H12(216),m3h2x12(:,76),heltab2x24(:,:,108))
  call Hloop_Q_A(ntryL,G1H12(216),49,0,G2H12(39),n2h12(94))
  call Hloop_AQ_V(ntryL,G1H48(1),wf4(:,3),G1H12(233),m3h4x12(:,1),heltab2x48(:,:,41))
  call Hloop_VQ_A(ntryL,G1H48(2),wf4(:,3),G1H12(234),m3h4x12(:,2),heltab2x48(:,:,42))
  call Hloop_Q_A(ntryL,G1H12(234),37,0,G2H12(41),n2h12(95))
  call Hloop_VA_Q(ntryL,G1H48(3),ex2(:),G1H24(28),m3h2x24(:,37),heltab2x48(:,:,43))
  call Hloop_A_Q(ntryL,G1H24(28),34,0,G2H24(5),n2h24(45))
  call Hloop_VA_Q(ntryL,G1H48(4),ex2(:),G1H24(29),m3h2x24(:,38),heltab2x48(:,:,44))
  call Hloop_A_Q(ntryL,G1H24(29),34,0,G2H24(6),n2h24(46))
  call Hloop_AQ_V(ntryL,G1H48(5),wf4(:,3),G1H12(7),m3h4x12(:,3),heltab2x48(:,:,45))
  call Hloop_QW_A(ntryL,G1H48(6),ex4(:),G1H16(1),m3h3x16(:,5),heltab2x48(:,:,46))
  call Hloop_Q_A(ntryL,G1H16(1),40,0,G2H16(3),n2h16(7))
  call Hloop_VA_Q(ntryL,G1H48(7),ex2(:),G1H24(30),m3h2x24(:,39),heltab2x48(:,:,47))
  call Hloop_A_Q(ntryL,G1H24(30),34,0,G2H24(7),n2h24(47))
  call Hloop_QA_V(ntryL,G1H48(8),ex2(:),G1H24(31),m3h2x24(:,40),heltab2x48(:,:,48))
  call Hloop_AQ_V(ntryL,G1H48(9),wf4(:,3),G1H12(8),m3h4x12(:,4),heltab2x48(:,:,49))
  call Hloop_AW_Q(ntryL,G1H48(10),ex4(:),G1H16(2),m3h3x16(:,6),heltab2x48(:,:,50))
  call Hloop_A_Q(ntryL,G1H16(2),40,0,G2H16(4),n2h16(8))
  call Hloop_QA_V(ntryL,G1H48(11),ex2(:),G1H24(32),m3h2x24(:,41),heltab2x48(:,:,51))
  call Hloop_QA_V(ntryL,G1H48(12),ex2(:),G1H24(34),m3h2x24(:,42),heltab2x48(:,:,52))
  call Hloop_QA_V(ntryL,G1H48(13),wf4(:,9),G1H12(11),m3h4x12(:,5),heltab2x48(:,:,53))
  call Hloop_VA_Q(ntryL,G1H48(14),wf4(:,9),G1H12(12),m3h4x12(:,6),heltab2x48(:,:,54))
  call Hloop_A_Q(ntryL,G1H12(12),38,0,G2H12(42),n2h12(96))
  call Hloop_VQ_A(ntryL,G1H48(15),ex1(:),G1H24(35),m3h2x24(:,43),heltab2x48(:,:,55))
  call Hloop_Q_A(ntryL,G1H24(35),33,0,G2H24(8),n2h24(48))
  call Hloop_VQ_A(ntryL,G1H48(16),ex1(:),G1H24(36),m3h2x24(:,44),heltab2x48(:,:,56))
  call Hloop_Q_A(ntryL,G1H24(36),33,0,G2H24(9),n2h24(49))
  call Hloop_QA_V(ntryL,G1H48(17),wf4(:,9),G1H12(13),m3h4x12(:,7),heltab2x48(:,:,57))
  call Hloop_AW_Q(ntryL,G1H48(18),ex4(:),G1H16(4),m3h3x16(:,7),heltab2x48(:,:,58))
  call Hloop_A_Q(ntryL,G1H16(4),40,0,G2H16(1),n2h16(9))
  call Hloop_VQ_A(ntryL,G1H48(19),ex1(:),G1H24(5),m3h2x24(:,45),heltab2x48(:,:,59))
  call Hloop_Q_A(ntryL,G1H24(5),33,0,G2H24(10),n2h24(50))
  call Hloop_AQ_V(ntryL,G1H48(20),ex1(:),G1H24(6),m3h2x24(:,46),heltab2x48(:,:,60))
  call Hloop_QA_V(ntryL,G1H48(21),wf4(:,9),G1H12(14),m3h4x12(:,8),heltab2x48(:,:,61))
  call Hloop_QW_A(ntryL,G1H48(22),ex4(:),G1H16(5),m3h3x16(:,8),heltab2x48(:,:,62))
  call Hloop_Q_A(ntryL,G1H16(5),40,0,G2H16(2),n2h16(10))
  call Hloop_AQ_V(ntryL,G1H48(23),ex1(:),G1H24(8),m3h2x24(:,47),heltab2x48(:,:,63))
  call Hloop_AQ_V(ntryL,G1H48(24),ex1(:),G1H24(9),m3h2x24(:,48),heltab2x48(:,:,64))
  call Hloop_QV_A(ntryL,G1H48(25),ex3(:),G1H24(10),m3h2x24(:,49),heltab2x48(:,:,65))
  call Hloop_Q_A(ntryL,G1H24(10),36,0,G2H24(11),n2h24(51))
  call Hloop_VQ_A(ntryL,G1H48(26),wf6(:,4),G1H8(1),m3h6x8(:,1),heltab2x48(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(17),n2h8(55))
  call Hloop_VA_Q(ntryL,G1H48(27),ex2(:),G1H24(11),m3h2x24(:,50),heltab2x48(:,:,67))
  call Hloop_A_Q(ntryL,G1H24(11),34,0,G2H24(12),n2h24(52))
  call Hloop_VA_Q(ntryL,G1H48(28),ex2(:),G1H24(12),m3h2x24(:,51),heltab2x48(:,:,68))
  call Hloop_A_Q(ntryL,G1H24(12),34,0,G2H24(13),n2h24(53))
  call Hloop_AQ_V(ntryL,G1H48(29),wf6(:,4),G1H8(2),m3h6x8(:,2),heltab2x48(:,:,69))
  call Hloop_QV_A(ntryL,G1H48(30),ex3(:),G1H24(37),m3h2x24(:,52),heltab2x48(:,:,70))
  call Hloop_Q_A(ntryL,G1H24(37),36,0,G2H24(14),n2h24(54))
  call Hloop_VA_Q(ntryL,G1H48(31),ex2(:),G1H24(38),m3h2x24(:,53),heltab2x48(:,:,71))
  call Hloop_A_Q(ntryL,G1H24(38),34,0,G2H24(15),n2h24(55))
  call Hloop_QA_V(ntryL,G1H48(32),ex2(:),G1H24(39),m3h2x24(:,54),heltab2x48(:,:,72))
  call Hloop_QV_A(ntryL,G1H48(33),ex3(:),G1H24(40),m3h2x24(:,55),heltab2x48(:,:,73))
  call Hloop_Q_A(ntryL,G1H24(40),36,0,G2H24(16),n2h24(56))
  call Hloop_AV_Q(ntryL,G1H48(34),ex3(:),G1H24(41),m3h2x24(:,56),heltab2x48(:,:,74))
  call Hloop_A_Q(ntryL,G1H24(41),36,0,G2H24(17),n2h24(57))
  call Hloop_QA_V(ntryL,G1H48(35),ex2(:),G1H24(43),m3h2x24(:,57),heltab2x48(:,:,75))
  call Hloop_QA_V(ntryL,G1H48(36),ex2(:),G1H24(44),m3h2x24(:,58),heltab2x48(:,:,76))
  call Hloop_AV_Q(ntryL,G1H48(37),ex3(:),G1H24(45),m3h2x24(:,59),heltab2x48(:,:,77))
  call Hloop_A_Q(ntryL,G1H24(45),36,0,G2H24(18),n2h24(58))
  call Hloop_VA_Q(ntryL,G1H48(38),wf6(:,2),G1H8(5),m3h6x8(:,3),heltab2x48(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(5),42,0,G2H8(18),n2h8(56))
  call Hloop_VQ_A(ntryL,G1H48(39),ex1(:),G1H24(46),m3h2x24(:,60),heltab2x48(:,:,79))
  call Hloop_Q_A(ntryL,G1H24(46),33,0,G2H24(19),n2h24(59))
  call Hloop_VQ_A(ntryL,G1H48(40),ex1(:),G1H24(47),m3h2x24(:,61),heltab2x48(:,:,80))
  call Hloop_Q_A(ntryL,G1H24(47),33,0,G2H24(20),n2h24(60))
  call Hloop_QA_V(ntryL,G1H48(41),wf6(:,2),G1H8(6),m3h6x8(:,4),heltab2x48(:,:,81))
  call Hloop_AV_Q(ntryL,G1H48(42),ex3(:),G1H24(49),m3h2x24(:,62),heltab2x48(:,:,82))
  call Hloop_A_Q(ntryL,G1H24(49),36,0,G2H24(1),n2h24(61))
  call Hloop_VQ_A(ntryL,G1H48(43),ex1(:),G1H24(50),m3h2x24(:,63),heltab2x48(:,:,83))
  call Hloop_Q_A(ntryL,G1H24(50),33,0,G2H24(2),n2h24(62))
  call Hloop_AQ_V(ntryL,G1H48(44),ex1(:),G1H24(51),m3h2x24(:,64),heltab2x48(:,:,84))
  call Hloop_AV_Q(ntryL,G1H48(45),ex3(:),G1H24(52),m3h2x24(:,65),heltab2x48(:,:,85))
  call Hloop_A_Q(ntryL,G1H24(52),36,0,G2H24(3),n2h24(63))
  call Hloop_QV_A(ntryL,G1H48(46),ex3(:),G1H24(53),m3h2x24(:,66),heltab2x48(:,:,86))
  call Hloop_Q_A(ntryL,G1H24(53),36,0,G2H24(4),n2h24(64))
  call Hloop_AQ_V(ntryL,G1H48(47),ex1(:),G1H24(55),m3h2x24(:,67),heltab2x48(:,:,87))
  call Hloop_AQ_V(ntryL,G1H48(48),ex1(:),G1H24(56),m3h2x24(:,68),heltab2x48(:,:,88))
  call Hloop_QA_V(ntryL,G1H48(49),ex2(:),G1H24(57),m3h2x24(:,69),heltab2x48(:,:,89))
  call Hloop_QW_A(ntryL,G1H48(50),wf6(:,6),G1H8(7),m3h6x8(:,5),heltab2x48(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(7),44,0,G2H8(20),n2h8(57))
  call Hloop_AQ_V(ntryL,G1H48(51),ex1(:),G1H24(14),m3h2x24(:,70),heltab2x48(:,:,91))
  call Hloop_AQ_V(ntryL,G1H48(52),ex1(:),G1H24(58),m3h2x24(:,71),heltab2x48(:,:,92))
  call Hloop_AW_Q(ntryL,G1H48(53),wf6(:,6),G1H8(8),m3h6x8(:,6),heltab2x48(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(8),44,0,G2H8(21),n2h8(58))
  call Hloop_QA_V(ntryL,G1H48(54),ex2(:),G1H24(60),m3h2x24(:,72),heltab2x48(:,:,94))
  call Hloop_AQ_V(ntryL,G1H48(55),ex1(:),G1H24(61),m3h2x24(:,73),heltab2x48(:,:,95))
  call Hloop_VQ_A(ntryL,G1H48(56),ex1(:),G1H24(62),m3h2x24(:,74),heltab2x48(:,:,96))
  call Hloop_Q_A(ntryL,G1H24(62),33,0,G2H24(21),n2h24(65))
  call Hloop_QA_V(ntryL,G1H48(57),ex2(:),G1H24(63),m3h2x24(:,75),heltab2x48(:,:,97))
  call Hloop_VA_Q(ntryL,G1H48(58),ex2(:),G1H24(64),m3h2x24(:,76),heltab2x48(:,:,98))
  call Hloop_A_Q(ntryL,G1H24(64),34,0,G2H24(22),n2h24(66))
  call Hloop_VQ_A(ntryL,G1H48(59),ex1(:),G1H24(66),m3h2x24(:,77),heltab2x48(:,:,99))
  call Hloop_Q_A(ntryL,G1H24(66),33,0,G2H24(23),n2h24(67))
  call Hloop_VQ_A(ntryL,G1H48(60),ex1(:),G1H24(67),m3h2x24(:,78),heltab2x48(:,:,100))
  call Hloop_Q_A(ntryL,G1H24(67),33,0,G2H24(24),n2h24(68))
  call Hloop_VA_Q(ntryL,G1H48(61),ex2(:),G1H24(68),m3h2x24(:,79),heltab2x48(:,:,101))
  call Hloop_A_Q(ntryL,G1H24(68),34,0,G2H24(25),n2h24(69))
  call Hloop_QW_A(ntryL,G1H48(62),ex4(:),G1H16(6),m3h3x16(:,9),heltab2x48(:,:,102))
  call Hloop_Q_A(ntryL,G1H16(6),40,0,G2H16(5),n2h16(11))
  call Hloop_QV_A(ntryL,G1H48(63),ex3(:),G1H24(69),m3h2x24(:,80),heltab2x48(:,:,103))
  call Hloop_Q_A(ntryL,G1H24(69),36,0,G2H24(26),n2h24(70))
  call Hloop_VA_Q(ntryL,G1H48(64),ex2(:),G1H24(70),m3h2x24(:,81),heltab2x48(:,:,104))
  call Hloop_A_Q(ntryL,G1H24(70),34,0,G2H24(27),n2h24(71))
  call Hloop_QV_A(ntryL,G1H48(65),ex3(:),G1H24(72),m3h2x24(:,82),heltab2x48(:,:,105))
  call Hloop_Q_A(ntryL,G1H24(72),36,0,G2H24(28),n2h24(72))
  call Hloop_AV_Q(ntryL,G1H48(66),ex3(:),G1H24(73),m3h2x24(:,83),heltab2x48(:,:,106))
  call Hloop_A_Q(ntryL,G1H24(73),36,0,G2H24(29),n2h24(73))
  call Hloop_QA_V(ntryL,G1H48(67),ex2(:),G1H24(74),m3h2x24(:,84),heltab2x48(:,:,107))
  call Hloop_QA_V(ntryL,G1H48(68),ex2(:),G1H24(15),m3h2x24(:,85),heltab2x48(:,:,108))
  call Hloop_VQ_A(ntryL,G1H48(69),ex1(:),G1H24(75),m3h2x24(:,86),heltab2x48(:,:,109))
  call Hloop_Q_A(ntryL,G1H24(75),33,0,G2H24(30),n2h24(74))
  call Hloop_AW_Q(ntryL,G1H48(70),ex4(:),G1H16(7),m3h3x16(:,10),heltab2x48(:,:,110))
  call Hloop_A_Q(ntryL,G1H16(7),40,0,G2H16(6),n2h16(12))
  call Hloop_AV_Q(ntryL,G1H48(71),ex3(:),G1H24(77),m3h2x24(:,87),heltab2x48(:,:,111))
  call Hloop_A_Q(ntryL,G1H24(77),36,0,G2H24(31),n2h24(75))
  call Hloop_VQ_A(ntryL,G1H48(72),ex1(:),G1H24(78),m3h2x24(:,88),heltab2x48(:,:,112))
  call Hloop_Q_A(ntryL,G1H24(78),33,0,G2H24(32),n2h24(76))
  call Hloop_AV_Q(ntryL,G1H48(73),ex3(:),G1H24(79),m3h2x24(:,89),heltab2x48(:,:,113))
  call Hloop_A_Q(ntryL,G1H24(79),36,0,G2H24(33),n2h24(77))
  call Hloop_QV_A(ntryL,G1H48(74),ex3(:),G1H24(16),m3h2x24(:,90),heltab2x48(:,:,114))
  call Hloop_Q_A(ntryL,G1H24(16),36,0,G2H24(34),n2h24(78))
  call Hloop_AQ_V(ntryL,G1H48(75),ex1(:),G1H24(80),m3h2x24(:,91),heltab2x48(:,:,115))
  call Hloop_AQ_V(ntryL,G1H48(76),ex1(:),G1H24(82),m3h2x24(:,92),heltab2x48(:,:,116))
  call Hloop_VA_Q(ntryL,G0H24(7),ex2(:),G0H12(1),m3h2x12(:,77),heltab2x24(:,:,109))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(17),n2h12(97))
  call Hloop_VA_Q(ntryL,G0H24(8),ex2(:),G0H12(1),m3h2x12(:,78),heltab2x24(:,:,110))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(18),n2h12(98))
  call Hloop_VA_Q(ntryL,G0H24(9),ex2(:),G0H12(1),m3h2x12(:,79),heltab2x24(:,:,111))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(19),n2h12(99))
  call Hloop_VA_Q(ntryL,G0H24(10),ex2(:),G0H12(1),m3h2x12(:,80),heltab2x24(:,:,112))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(20),n2h12(100))
  call Hloop_VA_Q(ntryL,G0H24(11),ex2(:),G0H12(1),m3h2x12(:,81),heltab2x24(:,:,113))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(23),n2h12(101))
  call Hloop_VA_Q(ntryL,G0H24(12),ex2(:),G0H12(1),m3h2x12(:,82),heltab2x24(:,:,114))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(24),n2h12(102))
  call Hloop_VQ_A(ntryL,G0H24(13),ex1(:),G0H12(1),m3h2x12(:,83),heltab2x24(:,:,115))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(25),n2h12(103))
  call Hloop_VQ_A(ntryL,G0H24(14),ex1(:),G0H12(1),m3h2x12(:,84),heltab2x24(:,:,116))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(26),n2h12(104))
  call Hloop_VQ_A(ntryL,G0H24(15),ex1(:),G0H12(1),m3h2x12(:,85),heltab2x24(:,:,117))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(29),n2h12(105))
  call Hloop_VQ_A(ntryL,G0H24(16),ex1(:),G0H12(1),m3h2x12(:,86),heltab2x24(:,:,118))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(30),n2h12(106))
  call Hloop_VQ_A(ntryL,G0H24(17),ex1(:),G0H12(1),m3h2x12(:,87),heltab2x24(:,:,119))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(31),n2h12(107))
  call Hloop_VQ_A(ntryL,G0H24(18),ex1(:),G0H12(1),m3h2x12(:,88),heltab2x24(:,:,120))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(32),n2h12(108))
  call Hloop_AV_Q(ntryL,G1H24(20),ex3(:),G1H12(35),m3h2x12(:,89),heltab2x24(:,:,121))
  call Hloop_A_Q(ntryL,G1H12(35),52,0,G2H12(43),n2h12(109))
  call Hloop_QA_V(ntryL,G1H24(21),ex2(:),G1H12(36),m3h2x12(:,90),heltab2x24(:,:,122))
  call Hloop_QV_A(ntryL,G1H24(22),ex3(:),G1H12(37),m3h2x12(:,91),heltab2x24(:,:,123))
  call Hloop_Q_A(ntryL,G1H12(37),52,0,G2H12(45),n2h12(110))
  call Hloop_QA_V(ntryL,G1H24(24),ex2(:),G1H12(38),m3h2x12(:,92),heltab2x24(:,:,124))
  call Hloop_AQ_V(ntryL,G1H24(25),ex1(:),G1H12(41),m3h2x12(:,93),heltab2x24(:,:,125))
  call Hloop_AQ_V(ntryL,G1H24(26),ex1(:),G1H12(42),m3h2x12(:,94),heltab2x24(:,:,126))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G2H8(9),G2H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G2H8(19),G2H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G2H8(24),G1H8(16)])
call HGT_lower_alpha_OLR(G2H12(35),1,1,12)
call HGT_lower_alpha_invQ_OLR(G2H12(35),2,5,12)
call HGT_lower_alpha_OLR(G2H12(35),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(35),[G2H12(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(41),[G2H12(36),G1H12(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(26),[G1H12(27)])
call HGT_w2_OLR(G1H12(1),1,1,12)
call HGT_w2_invQ_OLR(G1H12(1),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(1),[G1H12(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(40),[G1H12(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(25),[G1H12(21)])
call HGT_w2_OLR(G1H12(2),1,1,12)
call HGT_w2_invQ_OLR(G1H12(2),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(44),[G1H12(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(42),[G2H12(49),G1H12(196)])
call HGT_lower_alpha_OLR(G2H12(52),1,1,12)
call HGT_lower_alpha_invQ_OLR(G2H12(52),2,5,12)
call HGT_lower_alpha_OLR(G2H12(52),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(52),[G2H12(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G2H8(28),G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(30),[G1H12(45)])
call HGT_w2_OLR(G1H12(3),1,1,12)
call HGT_w2_invQ_OLR(G1H12(3),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(3),[G1H12(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(29),[G1H12(39)])
call HGT_w2_OLR(G1H12(4),1,1,12)
call HGT_w2_invQ_OLR(G1H12(4),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G1H12(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(36),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(32),[G1H12(63)])
call HGT_w2_OLR(G1H12(5),1,1,12)
call HGT_w2_invQ_OLR(G1H12(5),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(5),[G1H12(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(54),[G1H12(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(31),[G1H12(57)])
call HGT_w2_OLR(G1H12(6),1,1,12)
call HGT_w2_invQ_OLR(G1H12(6),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(6),[G1H12(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(58),[G1H12(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(7),[G1H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(8),[G1H12(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(13),[G1H12(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(14),[G1H12(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(17),[G1H12(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(18),[G1H12(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(19),[G1H12(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(20),[G1H12(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(23),[G1H12(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(24),[G1H12(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(233),[G1H12(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(11),[G1H12(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(27),[G1H12(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(29),[G1H12(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(31),[G1H12(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(32),[G1H12(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(34),[G1H12(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(37),[G1H12(231)])
call HGT_OLR(G2H8(4),1,1,8)
call HGT_invQ_OLR(G2H8(4),2,5,8)
call HGT_OLR(G2H8(4),6,15,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(60),mass5set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(19),G1H8(25),8)
  call HG1shiftOLR(G1H8(12),2,8)
  call Hloop_AQ_V(ntryL,G2H8(21),ex1(:),G2H4(43),m3h2x4(:,61),heltab2x8(:,:,61))
call HGT_OLR(G2H12(23),1,1,12)
call HGT_invQ_OLR(G2H12(23),2,5,12)
call HGT_OLR(G2H12(23),6,15,12)
  call Hotf_5pt_reduction(G2H12(23),RedSet_5(61),mass5set(:,1),  & 
G1H12(43),G1H12(44),G1H12(47),G1H12(48),G1H12(49),G1H12(50),12)
  call HG1shiftOLR(G1H12(44),2,12)
call HGT_OLR(G2H8(12),1,1,8)
call HGT_invQ_OLR(G2H8(12),2,5,8)
call HGT_OLR(G2H8(12),6,15,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(62),mass5set(:,1),  & 
G1H8(20),G1H8(23),G1H8(24),G1H8(26),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(23),1,8)
  call Hloop_QA_V(ntryL,G2H12(25),ex2(:),G2H6(76),m3h2x6(:,105),heltab2x12(:,:,155))
call HGT_OLR(G2H8(14),1,1,8)
call HGT_invQ_OLR(G2H8(14),2,5,8)
call HGT_OLR(G2H8(14),6,15,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(63),mass5set(:,1),  & 
G1H8(31),G1H8(32),G1H8(37),G1H8(43),G1H8(38),G1H8(41),8)
  call HG1shiftOLR(G1H8(32),1,8)
  call Hloop_QA_V(ntryL,G2H8(20),ex2(:),G2H4(46),m3h2x4(:,62),heltab2x8(:,:,62))
call HGT_OLR(G2H12(28),1,1,12)
call HGT_invQ_OLR(G2H12(28),2,5,12)
call HGT_OLR(G2H12(28),6,15,12)
  call Hotf_5pt_reduction(G2H12(28),RedSet_5(64),mass5set(:,1),  & 
G1H12(53),G1H12(54),G1H12(55),G1H12(56),G1H12(59),G1H12(60),12)
  call HG1shiftOLR(G1H12(54),1,12)
call HGT_OLR(G2H8(22),1,1,8)
call HGT_invQ_OLR(G2H8(22),2,5,8)
call HGT_OLR(G2H8(22),6,15,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(65),mass5set(:,1),  & 
G1H8(42),G1H8(44),G1H8(47),G1H8(48),G1H8(49),G1H8(50),8)
  call HG1shiftOLR(G1H8(44),2,8)
  call Hloop_AQ_V(ntryL,G2H12(30),ex1(:),G2H6(78),m3h2x6(:,106),heltab2x12(:,:,156))
call HGT_lower_alpha_OLR(G2H12(33),1,1,12)
call HGT_lower_alpha_invQ_OLR(G2H12(33),2,5,12)
call HGT_lower_alpha_OLR(G2H12(33),6,15,12)
  call Hotf_5pt_reduction(G2H12(33),RedSet_5(66),mass5set(:,1),  & 
G1H12(61),G1H12(62),G1H12(65),G1H12(66),G1H12(67),G1H12(68),12)
  call HG1shiftOLR(G1H12(62),1,12)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(67),mass5set(:,1),  & 
G1H8(55),G1H8(61),G1H8(56),G1H8(59),G1H8(60),G1H8(62),8)
  call HG1shiftOLR(G1H8(61),16,8)
  call Hotf_5pt_reduction(G2H12(35),RedSet_5(68),mass5set(:,1),  & 
G1H12(71),G1H12(72),G1H12(73),G1H12(74),G1H12(77),G1H12(78),12)
  call HG1shiftOLR(G1H12(72),2,12)
  call Hotf_5pt_reduction(G2H12(41),RedSet_5(69),mass5set(:,1),  & 
G1H12(79),G1H12(80),G1H12(83),G1H12(84),G1H12(85),G1H12(86),12)
  call HG1shiftOLR(G1H12(80),16,12)
  call Hloop_QV_A(ntryL,G1H12(1),ex3(:),G1H6(18),m3h2x6(:,107),heltab2x12(:,:,157))
  call Hloop_Q_A(ntryL,G1H6(18),39,0,G2H6(82),n2h6(109))
  call Hotf_5pt_reduction(G2H12(40),RedSet_5(70),mass5set(:,1),  & 
G1H12(89),G1H12(90),G1H12(91),G1H12(92),G1H12(95),G1H12(96),12)
  call HG1shiftOLR(G1H12(90),2,12)
  call Hloop_QV_A(ntryL,G1H12(2),ex3(:),G1H6(30),m3h2x6(:,108),heltab2x12(:,:,158))
  call Hloop_Q_A(ntryL,G1H6(30),39,0,G2H6(86),n2h6(110))
  call Hotf_5pt_reduction(G2H12(44),RedSet_5(71),mass5set(:,1),  & 
G1H12(97),G1H12(98),G1H12(101),G1H12(102),G1H12(103),G1H12(104),12)
  call HG1shiftOLR(G1H12(98),2,12)
call HGT_lower_alpha_OLR(G2H12(48),1,1,12)
call HGT_lower_alpha_invQ_OLR(G2H12(48),2,5,12)
call HGT_lower_alpha_OLR(G2H12(48),6,15,12)
  call Hotf_5pt_reduction(G2H12(48),RedSet_5(72),mass5set(:,1),  & 
G1H12(107),G1H12(108),G1H12(109),G1H12(110),G1H12(113),G1H12(114),12)
  call HG1shiftOLR(G1H12(108),1,12)
  call Hotf_5pt_reduction(G2H12(42),RedSet_5(73),mass5set(:,1),  & 
G1H12(115),G1H12(116),G1H12(119),G1H12(120),G1H12(121),G1H12(122),12)
  call HG1shiftOLR(G1H12(116),16,12)
  call Hotf_5pt_reduction(G2H12(52),RedSet_5(74),mass5set(:,1),  & 
G1H12(125),G1H12(126),G1H12(127),G1H12(128),G1H12(131),G1H12(132),12)
  call HG1shiftOLR(G1H12(126),2,12)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(75),mass5set(:,1),  & 
G1H8(65),G1H8(66),G1H8(67),G1H8(68),G1H8(73),G1H8(79),8)
  call HG1shiftOLR(G1H8(66),16,8)
  call Hloop_QW_A(ntryL,G1H12(3),ex4(:),G1H4(12),m3h3x4(:,51),heltab2x12(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(12),43,0,G2H4(52),n2h4(107))
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(76),mass5set(:,1),  & 
G1H8(74),G1H8(77),G1H8(78),G1H8(80),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(77),2,8)
  call Hloop_QW_A(ntryL,G1H12(4),ex4(:),G1H4(24),m3h3x4(:,52),heltab2x12(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(24),43,0,G2H4(53),n2h4(108))
  call Hotf_5pt_reduction(G2H8(36),RedSet_5(77),mass5set(:,1),  & 
G1H8(17),G1H8(18),G1H8(35),G1H8(36),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(18),2,8)
  call Hloop_QV_A(ntryL,G1H12(5),ex5(:),G1H6(42),m3h2x6(:,109),heltab2x12(:,:,161))
  call Hloop_Q_A(ntryL,G1H6(42),51,0,G2H6(88),n2h6(111))
  call Hotf_5pt_reduction(G2H12(54),RedSet_5(78),mass5set(:,1),  & 
G1H12(133),G1H12(134),G1H12(137),G1H12(138),G1H12(139),G1H12(140),12)
  call HG1shiftOLR(G1H12(134),2,12)
  call Hloop_QV_A(ntryL,G1H12(6),ex5(:),G1H6(54),m3h2x6(:,110),heltab2x12(:,:,162))
  call Hloop_Q_A(ntryL,G1H6(54),51,0,G2H6(92),n2h6(112))
  call Hotf_5pt_reduction(G2H12(58),RedSet_5(79),mass5set(:,1),  & 
G1H12(145),G1H12(151),G1H12(146),G1H12(149),G1H12(150),G1H12(152),12)
  call HG1shiftOLR(G1H12(151),2,12)
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(36),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(36),43,0,G2H4(55),n2h4(109))
  call Hloop_VQ_A(ntryL,G1H8(6),ex1(:),G1H4(48),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(48),43,0,G2H4(59),n2h4(110))
  call Hloop_VA_Q(ntryL,G1H12(9),ex2(:),G1H6(66),m3h2x6(:,111),heltab2x12(:,:,163))
  call Hloop_A_Q(ntryL,G1H6(66),39,0,G2H6(1),n2h6(113))
  call Hloop_VA_Q(ntryL,G1H12(7),ex2(:),G1H6(78),m3h2x6(:,112),heltab2x12(:,:,164))
  call Hloop_A_Q(ntryL,G1H6(78),39,0,G2H6(3),n2h6(114))
  call Hloop_VA_Q(ntryL,G1H12(15),ex2(:),G1H6(90),m3h2x6(:,113),heltab2x12(:,:,165))
  call Hloop_A_Q(ntryL,G1H6(90),39,0,G2H6(4),n2h6(115))
  call Hloop_VA_Q(ntryL,G1H12(8),ex2(:),G1H6(102),m3h2x6(:,114),heltab2x12(:,:,166))
  call Hloop_A_Q(ntryL,G1H6(102),39,0,G2H6(6),n2h6(116))
  call Hloop_QV_A(ntryL,G1H12(22),ex3(:),G1H6(114),m3h2x6(:,115),heltab2x12(:,:,167))
  call Hloop_Q_A(ntryL,G1H6(114),39,0,G2H6(7),n2h6(117))
  call Hloop_QV_A(ntryL,G1H12(28),ex3(:),G1H6(126),m3h2x6(:,116),heltab2x12(:,:,168))
  call Hloop_Q_A(ntryL,G1H6(126),39,0,G2H6(10),n2h6(118))
  call Hloop_VA_Q(ntryL,G1H8(9),ex2(:),G1H4(60),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(60),43,0,G2H4(60),n2h4(111))
  call Hloop_VA_Q(ntryL,G1H8(2),ex2(:),G1H4(72),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(72),43,0,G2H4(62),n2h4(112))
  call Hloop_VQ_A(ntryL,G1H12(33),ex1(:),G1H6(138),m3h2x6(:,117),heltab2x12(:,:,169))
  call Hloop_Q_A(ntryL,G1H6(138),39,0,G2H6(11),n2h6(119))
  call Hloop_VQ_A(ntryL,G1H12(13),ex1(:),G1H6(150),m3h2x6(:,118),heltab2x12(:,:,170))
  call Hloop_Q_A(ntryL,G1H6(150),39,0,G2H6(13),n2h6(120))
  call Hloop_QW_A(ntryL,G1H12(40),ex4(:),G1H4(84),m3h3x4(:,53),heltab2x12(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(84),43,0,G2H4(66),n2h4(113))
  call Hloop_QW_A(ntryL,G1H12(46),ex4(:),G1H4(96),m3h3x4(:,54),heltab2x12(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(96),43,0,G2H4(67),n2h4(114))
  call Hloop_VQ_A(ntryL,G1H12(51),ex1(:),G1H6(162),m3h2x6(:,119),heltab2x12(:,:,173))
  call Hloop_Q_A(ntryL,G1H6(162),39,0,G2H6(14),n2h6(121))
  call Hloop_VQ_A(ntryL,G1H12(14),ex1(:),G1H6(174),m3h2x6(:,120),heltab2x12(:,:,174))
  call Hloop_Q_A(ntryL,G1H6(174),39,0,G2H6(17),n2h6(122))
  call Hloop_QV_A(ntryL,G1H12(58),ex5(:),G1H6(186),m3h2x6(:,121),heltab2x12(:,:,175))
  call Hloop_Q_A(ntryL,G1H6(186),51,0,G2H6(18),n2h6(123))
  call Hloop_QV_A(ntryL,G1H12(64),ex5(:),G1H6(198),m3h2x6(:,122),heltab2x12(:,:,176))
  call Hloop_Q_A(ntryL,G1H6(198),51,0,G2H6(20),n2h6(124))
  call Hloop_AV_Q(ntryL,G1H12(17),ex3(:),G1H6(210),m3h2x6(:,123),heltab2x12(:,:,177))
  call Hloop_A_Q(ntryL,G1H6(210),39,0,G2H6(21),n2h6(125))
  call Hloop_AV_Q(ntryL,G1H12(70),ex3(:),G1H6(222),m3h2x6(:,124),heltab2x12(:,:,178))
  call Hloop_A_Q(ntryL,G1H6(222),39,0,G2H6(24),n2h6(126))
  call Hloop_AV_Q(ntryL,G1H12(18),ex3(:),G1H6(234),m3h2x6(:,125),heltab2x12(:,:,179))
  call Hloop_A_Q(ntryL,G1H6(234),39,0,G2H6(27),n2h6(127))
  call Hloop_AV_Q(ntryL,G1H12(76),ex3(:),G1H6(246),m3h2x6(:,126),heltab2x12(:,:,180))
  call Hloop_A_Q(ntryL,G1H6(246),39,0,G2H6(29),n2h6(128))
  call Hloop_AW_Q(ntryL,G1H12(19),ex4(:),G1H4(108),m3h3x4(:,55),heltab2x12(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(108),43,0,G2H4(69),n2h4(115))
  call Hloop_AW_Q(ntryL,G1H12(82),ex4(:),G1H4(120),m3h3x4(:,56),heltab2x12(:,:,182))
  call Hloop_A_Q(ntryL,G1H4(120),43,0,G2H4(73),n2h4(116))
  call Hloop_AW_Q(ntryL,G1H12(20),ex4(:),G1H4(132),m3h3x4(:,57),heltab2x12(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(132),43,0,G2H4(74),n2h4(117))
  call Hloop_AW_Q(ntryL,G1H12(88),ex4(:),G1H4(138),m3h3x4(:,58),heltab2x12(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(138),43,0,G2H4(77),n2h4(118))
  call Hloop_AV_Q(ntryL,G1H12(23),ex5(:),G1H6(258),m3h2x6(:,127),heltab2x12(:,:,185))
  call Hloop_A_Q(ntryL,G1H6(258),51,0,G2H6(30),n2h6(129))
  call Hloop_AV_Q(ntryL,G1H12(94),ex5(:),G1H6(264),m3h2x6(:,128),heltab2x12(:,:,186))
  call Hloop_A_Q(ntryL,G1H6(264),51,0,G2H6(32),n2h6(130))
  call Hloop_AV_Q(ntryL,G1H12(24),ex5(:),G1H6(275),m3h2x6(:,129),heltab2x12(:,:,187))
  call Hloop_A_Q(ntryL,G1H6(275),51,0,G2H6(33),n2h6(131))
  call Hloop_AV_Q(ntryL,G1H12(100),ex5(:),G1H6(281),m3h2x6(:,130),heltab2x12(:,:,188))
  call Hloop_A_Q(ntryL,G1H6(281),51,0,G2H6(36),n2h6(132))
  call Hloop_UV_W(ntryL,G1H12(105),37,ex5(:),16,G2H6(37),m3h2x6(:,131),heltab2x12(:,:,189))
  call Hloop_UV_W(ntryL,G1H12(233),37,ex5(:),16,G2H6(40),m3h2x6(:,132),heltab2x12(:,:,190))
  call Hloop_VQ_A(ntryL,G1H12(111),ex1(:),G1H6(13),m3h2x6(:,133),heltab2x12(:,:,191))
  call Hloop_Q_A(ntryL,G1H6(13),51,0,G2H6(41),n2h6(133))
  call Hloop_VQ_A(ntryL,G1H12(112),ex1(:),G1H6(14),m3h2x6(:,134),heltab2x12(:,:,192))
  call Hloop_Q_A(ntryL,G1H6(14),51,0,G2H6(43),n2h6(134))
  call Hloop_UV_W(ntryL,G1H12(117),38,ex5(:),16,G2H6(46),m3h2x6(:,135),heltab2x12(:,:,193))
  call Hloop_UV_W(ntryL,G1H12(11),38,ex5(:),16,G2H6(48),m3h2x6(:,136),heltab2x12(:,:,194))
  call Hloop_VQ_A(ntryL,G1H12(123),ex1(:),G1H6(19),m3h2x6(:,137),heltab2x12(:,:,195))
  call Hloop_Q_A(ntryL,G1H6(19),51,0,G2H6(49),n2h6(135))
  call Hloop_VQ_A(ntryL,G1H12(124),ex1(:),G1H6(20),m3h2x6(:,138),heltab2x12(:,:,196))
  call Hloop_Q_A(ntryL,G1H6(20),51,0,G2H6(52),n2h6(136))
  call Hloop_VA_Q(ntryL,G1H12(129),ex2(:),G1H6(24),m3h2x6(:,139),heltab2x12(:,:,197))
  call Hloop_A_Q(ntryL,G1H6(24),51,0,G2H6(53),n2h6(137))
  call Hloop_VA_Q(ntryL,G1H12(130),ex2(:),G1H6(25),m3h2x6(:,140),heltab2x12(:,:,198))
  call Hloop_A_Q(ntryL,G1H6(25),51,0,G2H6(55),n2h6(138))
  call Hloop_VA_Q(ntryL,G1H12(135),ex2(:),G1H6(26),m3h2x6(:,141),heltab2x12(:,:,199))
  call Hloop_A_Q(ntryL,G1H6(26),51,0,G2H6(56),n2h6(139))
  call Hloop_VA_Q(ntryL,G1H12(136),ex2(:),G1H6(31),m3h2x6(:,142),heltab2x12(:,:,200))
  call Hloop_A_Q(ntryL,G1H6(31),51,0,G2H6(58),n2h6(140))
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(80),mass5set(:,1),  & 
G1H8(71),G1H8(72),G1H8(1),G1H8(5),G1H8(7),G1H8(8),8)
  call HG1shiftOLR(G1H8(72),16,8)
  call Hloop_AV_Q(ntryL,G1H8(21),ex3(:),G1H4(149),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(149),46,0,G2H4(83),n2h4(119))
  call Hloop_AV_Q(ntryL,G1H8(22),ex3(:),G1H4(155),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(155),46,0,G2H4(84),n2h4(120))
  call Hloop_AV_Q(ntryL,G1H8(27),ex3(:),G1H4(166),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(166),46,0,G2H4(86),n2h4(121))
  call Hloop_AV_Q(ntryL,G1H8(28),ex3(:),G1H4(172),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(172),46,0,G2H4(90),n2h4(122))
  call Hotf_5pt_reduction(G2H12(27),RedSet_5(81),mass5set(:,1),  & 
G1H12(155),G1H12(156),G1H12(157),G1H12(158),G1H12(163),G1H12(169),12)
  call HG1shiftOLR(G1H12(156),16,12)
  call Hloop_QW_A(ntryL,G1H12(147),ex4(:),G1H4(183),m3h3x4(:,59),heltab2x12(:,:,201))
  call Hloop_Q_A(ntryL,G1H4(183),45,0,G2H4(91),n2h4(123))
  call Hloop_QW_A(ntryL,G1H12(148),ex4(:),G1H4(189),m3h3x4(:,60),heltab2x12(:,:,202))
  call Hloop_Q_A(ntryL,G1H4(189),45,0,G2H4(93),n2h4(124))
  call Hloop_QW_A(ntryL,G1H12(153),ex4(:),G1H4(7),m3h3x4(:,61),heltab2x12(:,:,203))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(97),n2h4(125))
  call Hloop_QW_A(ntryL,G1H12(154),ex4(:),G1H4(8),m3h3x4(:,62),heltab2x12(:,:,204))
  call Hloop_Q_A(ntryL,G1H4(8),45,0,G2H4(98),n2h4(126))
  call Hotf_5pt_reduction(G2H12(29),RedSet_5(82),mass5set(:,1),  & 
G1H12(164),G1H12(167),G1H12(168),G1H12(170),G1H12(173),G1H12(174),12)
  call HG1shiftOLR(G1H12(167),2,12)
  call Hloop_QV_A(ntryL,G1H12(165),ex5(:),G1H6(32),m3h2x6(:,143),heltab2x12(:,:,205))
  call Hloop_Q_A(ntryL,G1H6(32),53,0,G2H6(59),n2h6(141))
  call Hloop_QV_A(ntryL,G1H12(166),ex5(:),G1H6(36),m3h2x6(:,144),heltab2x12(:,:,206))
  call Hloop_Q_A(ntryL,G1H6(36),53,0,G2H6(61),n2h6(142))
  call Hloop_QV_A(ntryL,G1H12(171),ex5(:),G1H6(37),m3h2x6(:,145),heltab2x12(:,:,207))
  call Hloop_Q_A(ntryL,G1H6(37),53,0,G2H6(62),n2h6(143))
  call Hloop_QV_A(ntryL,G1H12(172),ex5(:),G1H6(38),m3h2x6(:,146),heltab2x12(:,:,208))
  call Hloop_Q_A(ntryL,G1H6(38),53,0,G2H6(65),n2h6(144))
  call Hotf_5pt_reduction(G2H12(31),RedSet_5(83),mass5set(:,1),  & 
G1H12(175),G1H12(176),G1H12(181),G1H12(187),G1H12(182),G1H12(185),12)
  call HG1shiftOLR(G1H12(176),2,12)
  call Hloop_QW_A(ntryL,G1H12(183),ex4(:),G1H4(13),m3h3x4(:,63),heltab2x12(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(13),45,0,G2H4(100),n2h4(127))
  call Hloop_QW_A(ntryL,G1H12(184),ex4(:),G1H4(14),m3h3x4(:,64),heltab2x12(:,:,210))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(104),n2h4(128))
  call Hloop_QW_A(ntryL,G1H12(189),ex4(:),G1H4(18),m3h3x4(:,65),heltab2x12(:,:,211))
  call Hloop_Q_A(ntryL,G1H4(18),45,0,G2H4(1),n2h4(129))
  call Hloop_QW_A(ntryL,G1H12(190),ex4(:),G1H4(19),m3h3x4(:,66),heltab2x12(:,:,212))
  call Hloop_Q_A(ntryL,G1H4(19),45,0,G2H4(3),n2h4(130))
  call Hotf_5pt_reduction(G2H12(32),RedSet_5(84),mass5set(:,1),  & 
G1H12(186),G1H12(188),G1H12(191),G1H12(192),G1H12(193),G1H12(194),12)
  call HG1shiftOLR(G1H12(188),16,12)
  call Hloop_AW_Q(ntryL,G1H12(201),ex4(:),G1H4(20),m3h3x4(:,67),heltab2x12(:,:,213))
  call Hloop_A_Q(ntryL,G1H4(20),46,0,G2H4(4),n2h4(131))
  call Hloop_AW_Q(ntryL,G1H12(202),ex4(:),G1H4(25),m3h3x4(:,68),heltab2x12(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(25),46,0,G2H4(6),n2h4(132))
  call Hloop_AW_Q(ntryL,G1H12(207),ex4(:),G1H4(26),m3h3x4(:,69),heltab2x12(:,:,215))
  call Hloop_A_Q(ntryL,G1H4(26),46,0,G2H4(7),n2h4(133))
  call Hloop_AW_Q(ntryL,G1H12(208),ex4(:),G1H4(30),m3h3x4(:,70),heltab2x12(:,:,216))
  call Hloop_A_Q(ntryL,G1H4(30),46,0,G2H4(9),n2h4(134))
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(85),mass5set(:,1),  & 
G1H8(16),G1H8(34),G1H8(52),G1H8(70),G1H8(4),G1H8(10),8)
  call HG1shiftOLR(G1H8(34),16,8)
  call Hloop_QV_A(ntryL,G1H8(39),ex3(:),G1H4(31),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(31),45,0,G2H4(10),n2h4(135))
  call Hloop_QV_A(ntryL,G1H8(40),ex3(:),G1H4(32),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(32),45,0,G2H4(12),n2h4(136))
  call Hloop_QV_A(ntryL,G1H8(45),ex3(:),G1H4(37),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(37),45,0,G2H4(13),n2h4(137))
  call Hloop_QV_A(ntryL,G1H8(46),ex3(:),G1H4(38),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(38),45,0,G2H4(16),n2h4(138))
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(86),mass5set(:,1),  & 
G1H8(15),G1H8(33),G1H8(51),G1H8(69),G1H8(3),G1H8(6),8)
  call HG1shiftOLR(G1H8(33),2,8)
  call Hloop_QV_A(ntryL,G1H8(57),ex5(:),G1H4(42),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(42),57,0,G2H4(19),n2h4(139))
  call Hloop_QV_A(ntryL,G1H8(58),ex5(:),G1H4(43),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(43),57,0,G2H4(22),n2h4(140))
  call Hloop_QV_A(ntryL,G1H8(63),ex5(:),G1H4(44),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(44),57,0,G2H4(23),n2h4(141))
  call Hloop_QV_A(ntryL,G1H8(64),ex5(:),G1H4(49),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(49),57,0,G2H4(25),n2h4(142))
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(87),mass5set(:,1),  & 
G1H8(9),G1H8(2),G1H8(21),G1H8(22),G1H8(27),G1H8(28),8)
  call HG1shiftOLR(G1H8(2),2,8)
  call Hloop_QV_A(ntryL,G1H8(75),ex3(:),G1H4(50),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(50),45,0,G2H4(26),n2h4(143))
  call Hloop_QV_A(ntryL,G1H8(76),ex3(:),G1H4(54),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(54),45,0,G2H4(28),n2h4(144))
  call Hloop_QV_A(ntryL,G1H8(81),ex3(:),G1H4(55),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(55),45,0,G2H4(32),n2h4(145))
  call Hloop_QV_A(ntryL,G1H8(82),ex3(:),G1H4(56),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(56),45,0,G2H4(34),n2h4(146))
  call Hotf_5pt_reduction(G2H12(34),RedSet_5(88),mass5set(:,1),  & 
G1H12(199),G1H12(205),G1H12(200),G1H12(203),G1H12(204),G1H12(206),12)
  call HG1shiftOLR(G1H12(205),2,12)
  call Hloop_QW_A(ntryL,G1H12(219),ex4(:),G1H4(61),m3h3x4(:,71),heltab2x12(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(61),57,0,G2H4(35),n2h4(147))
  call Hloop_QW_A(ntryL,G1H12(220),ex4(:),G1H4(62),m3h3x4(:,72),heltab2x12(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(62),57,0,G2H4(37),n2h4(148))
  call Hloop_QW_A(ntryL,G1H12(225),ex4(:),G1H4(66),m3h3x4(:,73),heltab2x12(:,:,219))
  call Hloop_Q_A(ntryL,G1H4(66),57,0,G2H4(105),n2h4(149))
  call Hloop_QW_A(ntryL,G1H12(226),ex4(:),G1H4(67),m3h3x4(:,74),heltab2x12(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(67),57,0,G2H4(106),n2h4(150))
  call Hotf_5pt_reduction(G2H12(37),RedSet_5(89),mass5set(:,1),  & 
G1H12(209),G1H12(210),G1H12(211),G1H12(212),G1H12(217),G1H12(223),12)
  call HG1shiftOLR(G1H12(210),2,12)
  call Hloop_QV_A(ntryL,G1H12(237),ex3(:),G1H6(43),m3h2x6(:,147),heltab2x12(:,:,221))
  call Hloop_Q_A(ntryL,G1H6(43),53,0,G2H6(66),n2h6(145))
  call Hloop_QV_A(ntryL,G1H12(238),ex3(:),G1H6(44),m3h2x6(:,148),heltab2x12(:,:,222))
  call Hloop_Q_A(ntryL,G1H6(44),53,0,G2H6(68),n2h6(146))
  call Hloop_QV_A(ntryL,G1H12(243),ex3(:),G1H6(48),m3h2x6(:,149),heltab2x12(:,:,223))
  call Hloop_Q_A(ntryL,G1H6(48),53,0,G2H6(69),n2h6(147))
  call Hloop_QV_A(ntryL,G1H12(244),ex3(:),G1H6(49),m3h2x6(:,150),heltab2x12(:,:,224))
  call Hloop_Q_A(ntryL,G1H6(49),53,0,G2H6(72),n2h6(148))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(107),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_AQ_V(ntryL,G2H8(6),ex1(:),G2H4(108),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_QA_V(ntryL,G2H12(24),ex2(:),G2H6(93),m3h2x6(:,151),heltab2x12(:,:,225))
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(109),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_QA_V(ntryL,G2H8(8),ex2(:),G2H4(110),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_AQ_V(ntryL,G2H12(26),ex1(:),G2H6(94),m3h2x6(:,152),heltab2x12(:,:,226))
  call Hotf_5pt_reduction(G2H24(5),RedSet_5(90),mass5set(:,1),  & 
G1H24(83),G1H24(84),G1H24(7),G1H24(13),G1H24(54),G1H24(59),24)
  call HG1shiftOLR(G1H24(84),5,24)
  call Hotf_5pt_reduction(G2H24(6),RedSet_5(30),mass5set(:,1),  & 
G1H24(2),G1H24(23),G1H24(27),G1H24(33),G1H24(18),G1H24(1),24)
  call HG1shiftOLR(G1H24(23),16,24)
  call Hloop_QA_V(ntryL,G2H16(3),ex2(:),G2H8(23),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hotf_5pt_reduction(G2H24(7),RedSet_5(91),mass5set(:,1),  & 
G1H24(42),G1H24(48),G1H24(19),G1H24(17),G1H24(65),G1H24(71),24)
  call HG1shiftOLR(G1H24(48),5,24)
  call Hloop_UV_W(ntryL,G1H24(31),34,ex5(:),16,G2H12(46),m3h2x12(:,95),heltab2x24(:,:,127))
  call Hloop_AQ_V(ntryL,G2H16(4),wf4(:,3),G2H4(111),m3h4x4(:,1),heltab2x16(:,:,16))
  call Hloop_VQ_A(ntryL,G1H24(32),wf4(:,3),G1H6(50),m3h4x6(:,1),heltab2x24(:,:,128))
  call Hloop_Q_A(ntryL,G1H6(50),39,0,G2H6(95),n2h6(149))
  call Hloop_VQ_A(ntryL,G1H24(34),wf4(:,3),G1H6(55),m3h4x6(:,2),heltab2x24(:,:,129))
  call Hloop_Q_A(ntryL,G1H6(55),39,0,G2H6(96),n2h6(150))
  call Hotf_5pt_reduction(G2H24(8),RedSet_5(12),mass5set(:,1),  & 
G1H24(76),G1H24(81),G1H24(3),G1H24(4),G1H24(28),G1H24(29),24)
  call HG1shiftOLR(G1H24(81),6,24)
  call Hotf_5pt_reduction(G2H24(9),RedSet_5(37),mass5set(:,1),  & 
G1H24(30),G1H24(35),G1H24(36),G1H24(5),G1H24(10),G1H24(11),24)
  call HG1shiftOLR(G1H24(35),16,24)
  call Hloop_AQ_V(ntryL,G2H16(1),ex1(:),G2H8(25),m3h2x8(:,16),heltab2x16(:,:,17))
  call Hotf_5pt_reduction(G2H24(10),RedSet_5(13),mass5set(:,1),  & 
G1H24(12),G1H24(37),G1H24(38),G1H24(40),G1H24(41),G1H24(45),24)
  call HG1shiftOLR(G1H24(37),6,24)
  call Hloop_UV_W(ntryL,G1H24(6),33,ex5(:),16,G2H12(47),m3h2x12(:,96),heltab2x24(:,:,130))
  call Hloop_QA_V(ntryL,G2H16(2),wf4(:,9),G2H4(112),m3h4x4(:,2),heltab2x16(:,:,18))
  call Hloop_VA_Q(ntryL,G1H24(8),wf4(:,9),G1H6(56),m3h4x6(:,3),heltab2x24(:,:,131))
  call Hloop_A_Q(ntryL,G1H6(56),39,0,G2H6(97),n2h6(151))
  call Hloop_VA_Q(ntryL,G1H24(9),wf4(:,9),G1H6(60),m3h4x6(:,4),heltab2x24(:,:,132))
  call Hloop_A_Q(ntryL,G1H6(60),39,0,G2H6(98),n2h6(152))
  call Hloop_QA_V(ntryL,G2H24(11),ex2(:),G2H12(50),m3h2x12(:,97),heltab2x24(:,:,133))
  call Hotf_5pt_reduction(G2H24(12),RedSet_5(92),mass5set(:,1),  & 
G1H24(46),G1H24(47),G1H24(49),G1H24(50),G1H24(52),G1H24(53),24)
  call HG1shiftOLR(G1H24(47),9,24)
  call Hotf_5pt_reduction(G2H24(13),RedSet_5(36),mass5set(:,1),  & 
G1H24(62),G1H24(64),G1H24(66),G1H24(67),G1H24(68),G1H24(69),24)
  call HG1shiftOLR(G1H24(64),16,24)
  call Hloop_QA_V(ntryL,G2H24(14),ex2(:),G2H12(51),m3h2x12(:,98),heltab2x24(:,:,134))
  call Hotf_5pt_reduction(G2H24(15),RedSet_5(93),mass5set(:,1),  & 
G1H24(70),G1H24(72),G1H24(73),G1H24(75),G1H24(77),G1H24(78),24)
  call HG1shiftOLR(G1H24(72),9,24)
  call Hloop_UV_W(ntryL,G1H24(39),34,ex5(:),16,G2H12(53),m3h2x12(:,99),heltab2x24(:,:,135))
  call Hotf_5pt_reduction(G2H24(16),RedSet_5(3),mass5set(:,1),  & 
G1H24(79),G1H24(16),G1H24(20),G1H24(21),G1H24(22),G1H24(24),24)
  call HG1shiftOLR(G1H24(16),9,24)
  call Hloop_AQ_V(ntryL,G2H24(17),wf6(:,4),G2H4(113),m3h6x4(:,1),heltab2x24(:,:,136))
  call Hloop_VQ_A(ntryL,G1H24(43),wf6(:,4),G1H4(68),m3h6x4(:,2),heltab2x24(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(68),43,0,G2H4(114),n2h4(151))
  call Hloop_VQ_A(ntryL,G1H24(44),wf6(:,4),G1H4(73),m3h6x4(:,3),heltab2x24(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(73),43,0,G2H4(115),n2h4(152))
  call Hloop_AQ_V(ntryL,G2H24(18),ex1(:),G2H12(55),m3h2x12(:,100),heltab2x24(:,:,139))
  call Hotf_5pt_reduction(G2H24(19),RedSet_5(9),mass5set(:,1),  & 
G1H24(25),G1H24(26),G1H24(31),G1H24(32),G1H24(34),G1H24(6),24)
  call HG1shiftOLR(G1H24(26),10,24)
  call Hotf_5pt_reduction(G2H24(20),RedSet_5(32),mass5set(:,1),  & 
G1H24(8),G1H24(9),G1H24(39),G1H24(43),G1H24(44),G1H24(85),24)
  call HG1shiftOLR(G1H24(9),16,24)
  call Hloop_AQ_V(ntryL,G2H24(1),ex1(:),G2H12(56),m3h2x12(:,101),heltab2x24(:,:,140))
  call Hotf_5pt_reduction(G2H24(2),RedSet_5(14),mass5set(:,1),  & 
G1H24(86),G1H24(87),G1H24(88),G1H24(89),G1H24(90),G1H24(91),24)
  call HG1shiftOLR(G1H24(87),10,24)
  call Hloop_UV_W(ntryL,G1H24(51),33,ex5(:),16,G2H12(57),m3h2x12(:,102),heltab2x24(:,:,141))
  call Hotf_5pt_reduction(G2H24(3),RedSet_5(6),mass5set(:,1),  & 
G1H24(51),G1H24(92),G1H24(93),G1H24(94),G1H24(95),G1H24(96),24)
  call HG1shiftOLR(G1H24(92),10,24)
  call Hloop_QA_V(ntryL,G2H24(4),wf6(:,2),G2H4(116),m3h6x4(:,4),heltab2x24(:,:,142))
  call Hloop_VA_Q(ntryL,G1H24(55),wf6(:,2),G1H4(74),m3h6x4(:,5),heltab2x24(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(74),43,0,G2H4(117),n2h4(153))
  call Hloop_VA_Q(ntryL,G1H24(56),wf6(:,2),G1H4(78),m3h6x4(:,6),heltab2x24(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(78),43,0,G2H4(118),n2h4(154))
  call Hloop_VQ_A(ntryL,G1H24(57),ex1(:),G1H12(218),m3h2x12(:,103),heltab2x24(:,:,145))
  call Hloop_Q_A(ntryL,G1H12(218),35,0,G2H12(59),n2h12(111))
  call Hloop_VA_Q(ntryL,G1H24(14),ex2(:),G1H12(221),m3h2x12(:,104),heltab2x24(:,:,146))
  call Hloop_A_Q(ntryL,G1H12(221),35,0,G2H12(60),n2h12(112))
  call Hloop_VA_Q(ntryL,G1H24(58),ex2(:),G1H12(222),m3h2x12(:,105),heltab2x24(:,:,147))
  call Hloop_A_Q(ntryL,G1H12(222),35,0,G2H12(1),n2h12(113))
  call Hloop_VQ_A(ntryL,G1H24(60),ex1(:),G1H12(224),m3h2x12(:,106),heltab2x24(:,:,148))
  call Hloop_Q_A(ntryL,G1H12(224),35,0,G2H12(2),n2h12(114))
  call Hloop_UV_W(ntryL,G1H24(61),33,ex5(:),16,G2H12(3),m3h2x12(:,107),heltab2x24(:,:,149))
  call Hotf_5pt_reduction(G2H24(21),RedSet_5(40),mass5set(:,1),  & 
G1H24(55),G1H24(56),G1H24(57),G1H24(14),G1H24(58),G1H24(60),24)
  call HG1shiftOLR(G1H24(56),2,24)
  call Hloop_UV_W(ntryL,G1H24(63),34,ex5(:),16,G2H12(4),m3h2x12(:,108),heltab2x24(:,:,150))
  call Hotf_5pt_reduction(G2H24(22),RedSet_5(29),mass5set(:,1),  & 
G1H24(61),G1H24(63),G1H24(97),G1H24(98),G1H24(99),G1H24(100),24)
  call HG1shiftOLR(G1H24(63),16,24)
  call Hotf_5pt_reduction(G2H24(23),RedSet_5(35),mass5set(:,1),  & 
G1H24(101),G1H24(102),G1H24(103),G1H24(104),G1H24(105),G1H24(106),24)
  call HG1shiftOLR(G1H24(102),2,24)
  call Hotf_5pt_reduction(G2H24(24),RedSet_5(31),mass5set(:,1),  & 
G1H24(107),G1H24(108),G1H24(109),G1H24(110),G1H24(111),G1H24(112),24)
  call HG1shiftOLR(G1H24(108),16,24)
  call Hotf_5pt_reduction(G2H24(25),RedSet_5(10),mass5set(:,1),  & 
G1H24(113),G1H24(114),G1H24(115),G1H24(116),G1H24(117),G1H24(118),24)
  call HG1shiftOLR(G1H24(114),17,24)
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(4),mass5set(:,1),  & 
G1H16(8),G1H16(10),G1H16(11),G1H16(12),G1H16(3),G1H16(9),16)
  call HG1shiftOLR(G1H16(10),17,16)
  call Hloop_QA_V(ntryL,G2H24(26),ex2(:),G2H12(5),m3h2x12(:,109),heltab2x24(:,:,151))
  call Hotf_5pt_reduction(G2H24(27),RedSet_5(7),mass5set(:,1),  & 
G1H24(119),G1H24(120),G1H24(121),G1H24(122),G1H24(123),G1H24(124),24)
  call HG1shiftOLR(G1H24(120),17,24)
  call Hotf_5pt_reduction(G2H24(28),RedSet_5(5),mass5set(:,1),  & 
G1H24(125),G1H24(126),G1H24(127),G1H24(128),G1H24(129),G1H24(130),24)
  call HG1shiftOLR(G1H24(126),17,24)
  call Hloop_AQ_V(ntryL,G2H24(29),wf4(:,11),G2H6(99),m3h4x6(:,5),heltab2x24(:,:,152))
  call Hloop_VQ_A(ntryL,G1H24(74),wf4(:,11),G1H6(61),m3h4x6(:,6),heltab2x24(:,:,153))
  call Hloop_Q_A(ntryL,G1H6(61),51,0,G2H6(100),n2h6(153))
  call Hloop_VQ_A(ntryL,G1H24(15),wf4(:,11),G1H6(62),m3h4x6(:,7),heltab2x24(:,:,154))
  call Hloop_Q_A(ntryL,G1H6(62),51,0,G2H6(101),n2h6(154))
  call Hotf_5pt_reduction(G2H24(30),RedSet_5(8),mass5set(:,1),  & 
G1H24(74),G1H24(15),G1H24(131),G1H24(132),G1H24(133),G1H24(134),24)
  call HG1shiftOLR(G1H24(15),18,24)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(4),G1H16(5),G1H16(6),G1H16(7),16)
  call HG1shiftOLR(G1H16(2),18,16)
  call Hloop_AQ_V(ntryL,G2H24(31),ex1(:),G2H12(6),m3h2x12(:,110),heltab2x24(:,:,155))
  call Hotf_5pt_reduction(G2H24(32),RedSet_5(11),mass5set(:,1),  & 
G1H24(135),G1H24(136),G1H24(137),G1H24(138),G1H24(139),G1H24(140),24)
  call HG1shiftOLR(G1H24(136),18,24)
  call Hotf_5pt_reduction(G2H24(33),RedSet_5(2),mass5set(:,1),  & 
G1H24(141),G1H24(142),G1H24(143),G1H24(144),G1H24(145),G1H24(146),24)
  call HG1shiftOLR(G1H24(142),18,24)
  call Hloop_QA_V(ntryL,G2H24(34),wf4(:,5),G2H6(102),m3h4x6(:,8),heltab2x24(:,:,156))
  call Hloop_VA_Q(ntryL,G1H24(80),wf4(:,5),G1H6(67),m3h4x6(:,9),heltab2x24(:,:,157))
  call Hloop_A_Q(ntryL,G1H6(67),51,0,G2H6(103),n2h6(155))
  call Hloop_VA_Q(ntryL,G1H24(82),wf4(:,5),G1H6(68),m3h4x6(:,10),heltab2x24(:,:,158))
  call Hloop_A_Q(ntryL,G1H6(68),51,0,G2H6(104),n2h6(156))
  call Hloop_AQ_V(ntryL,G2H12(43),ex1(:),G2H6(105),m3h2x6(:,153),heltab2x12(:,:,227))
  call Hloop_VQ_A(ntryL,G1H12(36),ex1(:),G1H6(72),m3h2x6(:,154),heltab2x12(:,:,228))
  call Hloop_Q_A(ntryL,G1H6(72),51,0,G2H6(106),n2h6(157))
  call Hloop_QA_V(ntryL,G2H12(45),ex2(:),G2H6(107),m3h2x6(:,155),heltab2x12(:,:,229))
  call Hloop_VQ_A(ntryL,G1H12(38),ex1(:),G1H6(73),m3h2x6(:,156),heltab2x12(:,:,230))
  call Hloop_Q_A(ntryL,G1H6(73),51,0,G2H6(108),n2h6(158))
  call Hloop_VA_Q(ntryL,G1H12(41),ex2(:),G1H6(74),m3h2x6(:,157),heltab2x12(:,:,231))
  call Hloop_A_Q(ntryL,G1H6(74),51,0,G2H6(109),n2h6(159))
  call Hloop_VA_Q(ntryL,G1H12(42),ex2(:),G1H6(79),m3h2x6(:,158),heltab2x12(:,:,232))
  call Hloop_A_Q(ntryL,G1H6(79),51,0,G2H6(110),n2h6(160))
  call Hloop_AV_Q(ntryL,G1H8(11),ex3(:),G1H4(79),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(79),60,0,G2H4(119),n2h4(155))
call HGT_OLR(G1H8(12),1,1,8)
call HGT_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(12),-2,0,G2H8(26),n2h8(59))
  call Hloop_QA_V(ntryL,G2H8(26),ex2(:),G2H4(120),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_AV_Q(ntryL,G1H8(14),ex3(:),G1H4(80),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(80),60,0,G2H4(121),n2h4(156))
  call Hloop_AV_Q(ntryL,G1H8(19),ex3(:),G1H4(85),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(85),60,0,G2H4(122),n2h4(157))
  call Hloop_AV_Q(ntryL,G1H8(25),ex3(:),G1H4(86),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(86),60,0,G2H4(123),n2h4(158))
  call Hloop_AW_Q(ntryL,G1H12(43),ex4(:),G1H4(90),m3h3x4(:,75),heltab2x12(:,:,233))
  call Hloop_A_Q(ntryL,G1H4(90),60,0,G2H4(124),n2h4(159))
call HGT_OLR(G1H12(44),1,1,12)
call HGT_invQ_OLR(G1H12(44),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(44),-2,0,G2H12(7),n2h12(115))
  call Hloop_QA_V(ntryL,G2H12(7),ex2(:),G2H6(111),m3h2x6(:,159),heltab2x12(:,:,234))
  call Hloop_AW_Q(ntryL,G1H12(48),ex4(:),G1H4(91),m3h3x4(:,76),heltab2x12(:,:,235))
  call Hloop_A_Q(ntryL,G1H4(91),60,0,G2H4(125),n2h4(160))
  call Hloop_AW_Q(ntryL,G1H12(49),ex4(:),G1H4(92),m3h3x4(:,77),heltab2x12(:,:,236))
  call Hloop_A_Q(ntryL,G1H4(92),60,0,G2H4(126),n2h4(161))
  call Hloop_AW_Q(ntryL,G1H12(50),ex4(:),G1H4(97),m3h3x4(:,78),heltab2x12(:,:,237))
  call Hloop_A_Q(ntryL,G1H4(97),60,0,G2H4(127),n2h4(162))
  call Hloop_QV_A(ntryL,G1H8(20),ex5(:),G1H4(98),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(98),60,0,G2H4(128),n2h4(163))
call HGT_OLR(G1H8(23),1,1,8)
call HGT_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(23),-1,0,G2H8(27),n2h8(60))
  call Hloop_AQ_V(ntryL,G2H8(27),ex1(:),G2H4(129),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_QV_A(ntryL,G1H8(26),ex5(:),G1H4(102),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(102),60,0,G2H4(130),n2h4(164))
  call Hloop_QV_A(ntryL,G1H8(29),ex5(:),G1H4(103),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(103),60,0,G2H4(131),n2h4(165))
  call Hloop_QV_A(ntryL,G1H8(30),ex5(:),G1H4(104),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(104),60,0,G2H4(132),n2h4(166))
  call Hloop_QV_A(ntryL,G1H8(31),ex3(:),G1H4(109),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(109),60,0,G2H4(133),n2h4(167))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-1,0,G2H8(29),n2h8(61))
  call Hloop_AQ_V(ntryL,G2H8(29),ex1(:),G2H4(134),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_QV_A(ntryL,G1H8(43),ex3(:),G1H4(110),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H4(110),60,0,G2H4(135),n2h4(168))
  call Hloop_QV_A(ntryL,G1H8(38),ex3(:),G1H4(114),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(114),60,0,G2H4(136),n2h4(169))
  call Hloop_QV_A(ntryL,G1H8(41),ex3(:),G1H4(115),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(115),60,0,G2H4(137),n2h4(170))
  call Hloop_QW_A(ntryL,G1H12(53),ex4(:),G1H4(116),m3h3x4(:,79),heltab2x12(:,:,238))
  call Hloop_Q_A(ntryL,G1H4(116),60,0,G2H4(138),n2h4(171))
call HGT_OLR(G1H12(54),1,1,12)
call HGT_invQ_OLR(G1H12(54),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(54),-1,0,G2H12(8),n2h12(116))
  call Hloop_AQ_V(ntryL,G2H12(8),ex1(:),G2H6(112),m3h2x6(:,160),heltab2x12(:,:,239))
  call Hloop_QW_A(ntryL,G1H12(56),ex4(:),G1H4(121),m3h3x4(:,80),heltab2x12(:,:,240))
  call Hloop_Q_A(ntryL,G1H4(121),60,0,G2H4(139),n2h4(172))
  call Hloop_QW_A(ntryL,G1H12(59),ex4(:),G1H4(122),m3h3x4(:,81),heltab2x12(:,:,241))
  call Hloop_Q_A(ntryL,G1H4(122),60,0,G2H4(140),n2h4(173))
  call Hloop_QW_A(ntryL,G1H12(60),ex4(:),G1H4(126),m3h3x4(:,82),heltab2x12(:,:,242))
  call Hloop_Q_A(ntryL,G1H4(126),60,0,G2H4(141),n2h4(174))
  call Hloop_AV_Q(ntryL,G1H8(42),ex5(:),G1H4(127),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(127),60,0,G2H4(142),n2h4(175))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(44),-2,0,G2H8(30),n2h8(62))
  call Hloop_QA_V(ntryL,G2H8(30),ex2(:),G2H4(143),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_AV_Q(ntryL,G1H8(48),ex5(:),G1H4(128),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(128),60,0,G2H4(144),n2h4(176))
  call Hloop_AV_Q(ntryL,G1H8(49),ex5(:),G1H4(133),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(133),60,0,G2H4(145),n2h4(177))
  call Hloop_AV_Q(ntryL,G1H8(50),ex5(:),G1H4(134),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H4(134),60,0,G2H4(146),n2h4(178))
  call Hloop_AW_Q(ntryL,G1H12(61),ex4(:),G1H4(139),m3h3x4(:,83),heltab2x12(:,:,243))
  call Hloop_A_Q(ntryL,G1H4(139),58,0,G2H4(147),n2h4(179))
call HGT_raise_alpha_OLR(G1H12(62),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(62),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(62),ex1(:),G1H6(80),m3h2x6(:,161),heltab2x12(:,:,244))
  call Hloop_AW_Q(ntryL,G1H12(66),ex4(:),G1H4(140),m3h3x4(:,84),heltab2x12(:,:,245))
  call Hloop_A_Q(ntryL,G1H4(140),58,0,G2H4(148),n2h4(180))
  call Hloop_AW_Q(ntryL,G1H12(67),ex4(:),G1H4(144),m3h3x4(:,85),heltab2x12(:,:,246))
  call Hloop_A_Q(ntryL,G1H4(144),58,0,G2H4(149),n2h4(181))
  call Hloop_AW_Q(ntryL,G1H12(68),ex4(:),G1H4(145),m3h3x4(:,86),heltab2x12(:,:,247))
  call Hloop_A_Q(ntryL,G1H4(145),58,0,G2H4(150),n2h4(182))
  call Hloop_AV_Q(ntryL,G1H8(55),ex3(:),G1H4(150),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(150),46,0,G2H4(151),n2h4(183))
call HGT_raise_alpha_OLR(G1H8(61),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(61),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(61),-16,ex5(:),16,G2H4(152),m3h2x4(:,108),heltab2x8(:,:,108))
call signflip_OLR(G2H4(152))
  call Hloop_AV_Q(ntryL,G1H8(59),ex3(:),G1H4(151),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(151),46,0,G2H4(153),n2h4(184))
  call Hloop_AV_Q(ntryL,G1H8(60),ex3(:),G1H4(156),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(156),46,0,G2H4(154),n2h4(185))
  call Hloop_AV_Q(ntryL,G1H8(62),ex3(:),G1H4(157),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(157),46,0,G2H4(155),n2h4(186))
  call Hloop_QV_A(ntryL,G1H12(71),ex3(:),G1H6(84),m3h2x6(:,162),heltab2x12(:,:,248))
  call Hloop_Q_A(ntryL,G1H6(84),53,0,G2H6(113),n2h6(161))
call HGT_raise_alpha_OLR(G1H12(72),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(72),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(72),ex2(:),G1H6(85),m3h2x6(:,163),heltab2x12(:,:,249))
  call Hloop_QV_A(ntryL,G1H12(74),ex3(:),G1H6(86),m3h2x6(:,164),heltab2x12(:,:,250))
  call Hloop_Q_A(ntryL,G1H6(86),53,0,G2H6(114),n2h6(162))
  call Hloop_QV_A(ntryL,G1H12(77),ex3(:),G1H6(91),m3h2x6(:,165),heltab2x12(:,:,251))
  call Hloop_Q_A(ntryL,G1H6(91),53,0,G2H6(115),n2h6(163))
  call Hloop_QV_A(ntryL,G1H12(78),ex3(:),G1H6(92),m3h2x6(:,166),heltab2x12(:,:,252))
  call Hloop_Q_A(ntryL,G1H6(92),53,0,G2H6(116),n2h6(164))
  call Hloop_QW_A(ntryL,G1H12(79),ex4(:),G1H4(161),m3h3x4(:,87),heltab2x12(:,:,253))
  call Hloop_Q_A(ntryL,G1H4(161),45,0,G2H4(156),n2h4(187))
call HGT_raise_alpha_OLR(G1H12(80),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(80),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(80),-16,ex5(:),16,G2H6(117),m3h2x6(:,167),heltab2x12(:,:,254))
call signflip_OLR(G2H6(117))
  call Hloop_QW_A(ntryL,G1H12(84),ex4(:),G1H4(162),m3h3x4(:,88),heltab2x12(:,:,255))
  call Hloop_Q_A(ntryL,G1H4(162),45,0,G2H4(157),n2h4(188))
  call Hloop_QW_A(ntryL,G1H12(85),ex4(:),G1H4(167),m3h3x4(:,89),heltab2x12(:,:,256))
  call Hloop_Q_A(ntryL,G1H4(167),45,0,G2H4(158),n2h4(189))
  call Hloop_QW_A(ntryL,G1H12(86),ex4(:),G1H4(168),m3h3x4(:,90),heltab2x12(:,:,257))
  call Hloop_Q_A(ntryL,G1H4(168),45,0,G2H4(159),n2h4(190))
  call Hloop_QV_A(ntryL,G1H12(89),ex5(:),G1H6(96),m3h2x6(:,168),heltab2x12(:,:,258))
  call Hloop_Q_A(ntryL,G1H6(96),53,0,G2H6(118),n2h6(165))
call HGT_raise_alpha_OLR(G1H12(90),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(90),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(90),ex2(:),G1H6(97),m3h2x6(:,169),heltab2x12(:,:,259))
  call Hloop_QV_A(ntryL,G1H12(92),ex5(:),G1H6(98),m3h2x6(:,170),heltab2x12(:,:,260))
  call Hloop_Q_A(ntryL,G1H6(98),53,0,G2H6(119),n2h6(166))
  call Hloop_QV_A(ntryL,G1H12(95),ex5(:),G1H6(103),m3h2x6(:,171),heltab2x12(:,:,261))
  call Hloop_Q_A(ntryL,G1H6(103),53,0,G2H6(120),n2h6(167))
  call Hloop_QV_A(ntryL,G1H12(96),ex5(:),G1H6(104),m3h2x6(:,172),heltab2x12(:,:,262))
  call Hloop_Q_A(ntryL,G1H6(104),53,0,G2H6(121),n2h6(168))
  call Hloop_QW_A(ntryL,G1H12(97),ex4(:),G1H4(173),m3h3x4(:,91),heltab2x12(:,:,263))
  call Hloop_Q_A(ntryL,G1H4(173),45,0,G2H4(160),n2h4(191))
call HGT_raise_alpha_OLR(G1H12(98),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(98),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(98),ex2(:),G1H6(108),m3h2x6(:,173),heltab2x12(:,:,264))
  call Hloop_QW_A(ntryL,G1H12(102),ex4(:),G1H4(174),m3h3x4(:,92),heltab2x12(:,:,265))
  call Hloop_Q_A(ntryL,G1H4(174),45,0,G2H4(161),n2h4(192))
  call Hloop_QW_A(ntryL,G1H12(103),ex4(:),G1H4(178),m3h3x4(:,93),heltab2x12(:,:,266))
  call Hloop_Q_A(ntryL,G1H4(178),45,0,G2H4(162),n2h4(193))
  call Hloop_QW_A(ntryL,G1H12(104),ex4(:),G1H4(179),m3h3x4(:,94),heltab2x12(:,:,267))
  call Hloop_Q_A(ntryL,G1H4(179),45,0,G2H4(163),n2h4(194))
  call Hloop_AV_Q(ntryL,G1H12(107),ex3(:),G1H6(109),m3h2x6(:,174),heltab2x12(:,:,268))
  call Hloop_A_Q(ntryL,G1H6(109),54,0,G2H6(122),n2h6(169))
call HGT_raise_alpha_OLR(G1H12(108),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(108),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(108),ex1(:),G1H6(110),m3h2x6(:,175),heltab2x12(:,:,269))
  call Hloop_AV_Q(ntryL,G1H12(110),ex3(:),G1H6(115),m3h2x6(:,176),heltab2x12(:,:,270))
  call Hloop_A_Q(ntryL,G1H6(115),54,0,G2H6(123),n2h6(170))
  call Hloop_AV_Q(ntryL,G1H12(113),ex3(:),G1H6(116),m3h2x6(:,177),heltab2x12(:,:,271))
  call Hloop_A_Q(ntryL,G1H6(116),54,0,G2H6(124),n2h6(171))
  call Hloop_AV_Q(ntryL,G1H12(114),ex3(:),G1H6(120),m3h2x6(:,178),heltab2x12(:,:,272))
  call Hloop_A_Q(ntryL,G1H6(120),54,0,G2H6(125),n2h6(172))
  call Hloop_AW_Q(ntryL,G1H12(115),ex4(:),G1H4(184),m3h3x4(:,95),heltab2x12(:,:,273))
  call Hloop_A_Q(ntryL,G1H4(184),46,0,G2H4(164),n2h4(195))
call HGT_raise_alpha_OLR(G1H12(116),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(116),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(116),-16,ex5(:),16,G2H6(126),m3h2x6(:,179),heltab2x12(:,:,274))
call signflip_OLR(G2H6(126))
  call Hloop_AW_Q(ntryL,G1H12(120),ex4(:),G1H4(185),m3h3x4(:,96),heltab2x12(:,:,275))
  call Hloop_A_Q(ntryL,G1H4(185),46,0,G2H4(165),n2h4(196))
  call Hloop_AW_Q(ntryL,G1H12(121),ex4(:),G1H4(190),m3h3x4(:,97),heltab2x12(:,:,276))
  call Hloop_A_Q(ntryL,G1H4(190),46,0,G2H4(166),n2h4(197))
  call Hloop_AW_Q(ntryL,G1H12(122),ex4(:),G1H4(191),m3h3x4(:,98),heltab2x12(:,:,277))
  call Hloop_A_Q(ntryL,G1H4(191),46,0,G2H4(167),n2h4(198))
  call Hloop_QW_A(ntryL,G1H12(125),ex4(:),G1H4(12),m3h3x4(:,99),heltab2x12(:,:,278))
  call Hloop_Q_A(ntryL,G1H4(12),57,0,G2H4(168),n2h4(199))
call HGT_raise_alpha_OLR(G1H12(126),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(126),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(126),ex2(:),G1H6(121),m3h2x6(:,180),heltab2x12(:,:,279))
  call Hloop_QW_A(ntryL,G1H12(128),ex4(:),G1H4(24),m3h3x4(:,100),heltab2x12(:,:,280))
  call Hloop_Q_A(ntryL,G1H4(24),57,0,G2H4(169),n2h4(200))
  call Hloop_QW_A(ntryL,G1H12(131),ex4(:),G1H4(36),m3h3x4(:,101),heltab2x12(:,:,281))
  call Hloop_Q_A(ntryL,G1H4(36),57,0,G2H4(170),n2h4(201))
  call Hloop_QW_A(ntryL,G1H12(132),ex4(:),G1H4(48),m3h3x4(:,102),heltab2x12(:,:,282))
  call Hloop_Q_A(ntryL,G1H4(48),57,0,G2H4(171),n2h4(202))
  call Hloop_QV_A(ntryL,G1H8(65),ex3(:),G1H4(60),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(60),45,0,G2H4(172),n2h4(203))
call HGT_raise_alpha_OLR(G1H8(66),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(66),-16,ex5(:),16,G2H4(173),m3h2x4(:,113),heltab2x8(:,:,113))
call signflip_OLR(G2H4(173))
  call Hloop_QV_A(ntryL,G1H8(68),ex3(:),G1H4(72),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(72),45,0,G2H4(174),n2h4(204))
  call Hloop_QV_A(ntryL,G1H8(73),ex3(:),G1H4(84),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(84),45,0,G2H4(175),n2h4(205))
  call Hloop_QV_A(ntryL,G1H8(79),ex3(:),G1H4(96),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(96),45,0,G2H4(176),n2h4(206))
  call Hloop_QV_A(ntryL,G1H8(74),ex5(:),G1H4(108),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(108),57,0,G2H4(177),n2h4(207))
call HGT_raise_alpha_OLR(G1H8(77),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(77),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(77),ex2(:),G1H4(120),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_QV_A(ntryL,G1H8(80),ex5(:),G1H4(132),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(132),57,0,G2H4(178),n2h4(208))
  call Hloop_QV_A(ntryL,G1H8(83),ex5(:),G1H4(138),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(138),57,0,G2H4(179),n2h4(209))
  call Hloop_QV_A(ntryL,G1H8(84),ex5(:),G1H4(149),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(149),57,0,G2H4(180),n2h4(210))
  call Hloop_QV_A(ntryL,G1H8(17),ex3(:),G1H4(155),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(155),45,0,G2H4(181),n2h4(211))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(18),ex2(:),G1H4(166),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_QV_A(ntryL,G1H8(36),ex3(:),G1H4(172),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(172),45,0,G2H4(182),n2h4(212))
  call Hloop_QV_A(ntryL,G1H8(53),ex3(:),G1H4(183),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(183),45,0,G2H4(183),n2h4(213))
  call Hloop_QV_A(ntryL,G1H8(54),ex3(:),G1H4(189),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(189),45,0,G2H4(184),n2h4(214))
  call Hloop_QW_A(ntryL,G1H12(133),ex4(:),G1H4(7),m3h3x4(:,103),heltab2x12(:,:,283))
  call Hloop_Q_A(ntryL,G1H4(7),57,0,G2H4(185),n2h4(215))
call HGT_raise_alpha_OLR(G1H12(134),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(134),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(134),ex2(:),G1H6(122),m3h2x6(:,181),heltab2x12(:,:,284))
  call Hloop_QW_A(ntryL,G1H12(138),ex4(:),G1H4(8),m3h3x4(:,104),heltab2x12(:,:,285))
  call Hloop_Q_A(ntryL,G1H4(8),57,0,G2H4(186),n2h4(216))
  call Hloop_QW_A(ntryL,G1H12(139),ex4(:),G1H4(13),m3h3x4(:,105),heltab2x12(:,:,286))
  call Hloop_Q_A(ntryL,G1H4(13),57,0,G2H4(187),n2h4(217))
  call Hloop_QW_A(ntryL,G1H12(140),ex4(:),G1H4(14),m3h3x4(:,106),heltab2x12(:,:,287))
  call Hloop_Q_A(ntryL,G1H4(14),57,0,G2H4(188),n2h4(218))
  call Hloop_QV_A(ntryL,G1H12(145),ex3(:),G1H6(127),m3h2x6(:,182),heltab2x12(:,:,288))
  call Hloop_Q_A(ntryL,G1H6(127),53,0,G2H6(127),n2h6(173))
call HGT_raise_alpha_OLR(G1H12(151),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(151),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(151),ex2(:),G1H6(128),m3h2x6(:,183),heltab2x12(:,:,289))
  call Hloop_QV_A(ntryL,G1H12(149),ex3(:),G1H6(132),m3h2x6(:,184),heltab2x12(:,:,290))
  call Hloop_Q_A(ntryL,G1H6(132),53,0,G2H6(128),n2h6(174))
  call Hloop_QV_A(ntryL,G1H12(150),ex3(:),G1H6(133),m3h2x6(:,185),heltab2x12(:,:,291))
  call Hloop_Q_A(ntryL,G1H6(133),53,0,G2H6(129),n2h6(175))
  call Hloop_QV_A(ntryL,G1H12(152),ex3(:),G1H6(134),m3h2x6(:,186),heltab2x12(:,:,292))
  call Hloop_Q_A(ntryL,G1H6(134),53,0,G2H6(130),n2h6(176))
  call Hloop_AV_Q(ntryL,G1H8(71),ex3(:),G1H4(18),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(18),46,0,G2H4(189),n2h4(219))
call HGT_raise_alpha_OLR(G1H8(72),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(72),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(72),-16,ex5(:),16,G2H4(190),m3h2x4(:,128),heltab2x8(:,:,128))
call signflip_OLR(G2H4(190))
  call Hloop_AV_Q(ntryL,G1H8(5),ex3(:),G1H4(19),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(19),46,0,G2H4(191),n2h4(220))
  call Hloop_AV_Q(ntryL,G1H8(7),ex3(:),G1H4(20),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(20),46,0,G2H4(192),n2h4(221))
  call Hloop_AV_Q(ntryL,G1H8(8),ex3(:),G1H4(25),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(25),46,0,G2H4(193),n2h4(222))
  call Hloop_QW_A(ntryL,G1H12(155),ex4(:),G1H4(26),m3h3x4(:,107),heltab2x12(:,:,293))
  call Hloop_Q_A(ntryL,G1H4(26),45,0,G2H4(194),n2h4(223))
call HGT_raise_alpha_OLR(G1H12(156),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(156),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(156),-16,ex5(:),16,G2H6(131),m3h2x6(:,187),heltab2x12(:,:,294))
call signflip_OLR(G2H6(131))
  call Hloop_QW_A(ntryL,G1H12(158),ex4(:),G1H4(30),m3h3x4(:,108),heltab2x12(:,:,295))
  call Hloop_Q_A(ntryL,G1H4(30),45,0,G2H4(195),n2h4(224))
  call Hloop_QW_A(ntryL,G1H12(163),ex4(:),G1H4(31),m3h3x4(:,109),heltab2x12(:,:,296))
  call Hloop_Q_A(ntryL,G1H4(31),45,0,G2H4(196),n2h4(225))
  call Hloop_QW_A(ntryL,G1H12(169),ex4(:),G1H4(32),m3h3x4(:,110),heltab2x12(:,:,297))
  call Hloop_Q_A(ntryL,G1H4(32),45,0,G2H4(197),n2h4(226))
  call Hloop_QV_A(ntryL,G1H12(164),ex5(:),G1H6(139),m3h2x6(:,188),heltab2x12(:,:,298))
  call Hloop_Q_A(ntryL,G1H6(139),53,0,G2H6(132),n2h6(177))
call HGT_raise_alpha_OLR(G1H12(167),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(167),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(167),ex2(:),G1H6(140),m3h2x6(:,189),heltab2x12(:,:,299))
  call Hloop_QV_A(ntryL,G1H12(170),ex5(:),G1H6(144),m3h2x6(:,190),heltab2x12(:,:,300))
  call Hloop_Q_A(ntryL,G1H6(144),53,0,G2H6(133),n2h6(178))
  call Hloop_QV_A(ntryL,G1H12(173),ex5(:),G1H6(145),m3h2x6(:,191),heltab2x12(:,:,301))
  call Hloop_Q_A(ntryL,G1H6(145),53,0,G2H6(134),n2h6(179))
  call Hloop_QV_A(ntryL,G1H12(174),ex5(:),G1H6(146),m3h2x6(:,192),heltab2x12(:,:,302))
  call Hloop_Q_A(ntryL,G1H6(146),53,0,G2H6(135),n2h6(180))
  call Hloop_QW_A(ntryL,G1H12(175),ex4(:),G1H4(37),m3h3x4(:,111),heltab2x12(:,:,303))
  call Hloop_Q_A(ntryL,G1H4(37),45,0,G2H4(198),n2h4(227))
call HGT_raise_alpha_OLR(G1H12(176),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(176),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(176),ex2(:),G1H6(151),m3h2x6(:,193),heltab2x12(:,:,304))
  call Hloop_QW_A(ntryL,G1H12(187),ex4(:),G1H4(38),m3h3x4(:,112),heltab2x12(:,:,305))
  call Hloop_Q_A(ntryL,G1H4(38),45,0,G2H4(199),n2h4(228))
  call Hloop_QW_A(ntryL,G1H12(182),ex4(:),G1H4(42),m3h3x4(:,113),heltab2x12(:,:,306))
  call Hloop_Q_A(ntryL,G1H4(42),45,0,G2H4(200),n2h4(229))
  call Hloop_QW_A(ntryL,G1H12(185),ex4(:),G1H4(43),m3h3x4(:,114),heltab2x12(:,:,307))
  call Hloop_Q_A(ntryL,G1H4(43),45,0,G2H4(201),n2h4(230))
  call Hloop_AW_Q(ntryL,G1H12(186),ex4(:),G1H4(44),m3h3x4(:,115),heltab2x12(:,:,308))
  call Hloop_A_Q(ntryL,G1H4(44),46,0,G2H4(202),n2h4(231))
call HGT_raise_alpha_OLR(G1H12(188),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(188),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(188),-16,ex5(:),16,G2H6(136),m3h2x6(:,194),heltab2x12(:,:,309))
call signflip_OLR(G2H6(136))
  call Hloop_AW_Q(ntryL,G1H12(192),ex4(:),G1H4(49),m3h3x4(:,116),heltab2x12(:,:,310))
  call Hloop_A_Q(ntryL,G1H4(49),46,0,G2H4(203),n2h4(232))
  call Hloop_AW_Q(ntryL,G1H12(193),ex4(:),G1H4(50),m3h3x4(:,117),heltab2x12(:,:,311))
  call Hloop_A_Q(ntryL,G1H4(50),46,0,G2H4(204),n2h4(233))
  call Hloop_AW_Q(ntryL,G1H12(194),ex4(:),G1H4(54),m3h3x4(:,118),heltab2x12(:,:,312))
  call Hloop_A_Q(ntryL,G1H4(54),46,0,G2H4(205),n2h4(234))
  call Hloop_QV_A(ntryL,G1H8(16),ex3(:),G1H4(55),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(55),45,0,G2H4(206),n2h4(235))
call HGT_raise_alpha_OLR(G1H8(34),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(34),-16,ex5(:),16,G2H4(207),m3h2x4(:,133),heltab2x8(:,:,133))
call signflip_OLR(G2H4(207))
  call Hloop_QV_A(ntryL,G1H8(70),ex3(:),G1H4(56),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(56),45,0,G2H4(208),n2h4(236))
  call Hloop_QV_A(ntryL,G1H8(4),ex3(:),G1H4(61),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(61),45,0,G2H4(209),n2h4(237))
  call Hloop_QV_A(ntryL,G1H8(10),ex3(:),G1H4(62),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(62),45,0,G2H4(210),n2h4(238))
  call Hloop_QV_A(ntryL,G1H8(15),ex5(:),G1H4(66),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(66),57,0,G2H4(211),n2h4(239))
call HGT_raise_alpha_OLR(G1H8(33),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(33),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(33),ex2(:),G1H4(67),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_QV_A(ntryL,G1H8(69),ex5(:),G1H4(68),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(68),57,0,G2H4(212),n2h4(240))
  call Hloop_QV_A(ntryL,G1H8(3),ex5(:),G1H4(73),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(73),57,0,G2H4(213),n2h4(241))
  call Hloop_QV_A(ntryL,G1H8(6),ex5(:),G1H4(74),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(74),57,0,G2H4(214),n2h4(242))
  call Hloop_QV_A(ntryL,G1H8(9),ex3(:),G1H4(78),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(78),45,0,G2H4(215),n2h4(243))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(2),ex2(:),G1H4(79),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_QV_A(ntryL,G1H8(22),ex3(:),G1H4(80),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(80),45,0,G2H4(216),n2h4(244))
  call Hloop_QV_A(ntryL,G1H8(27),ex3(:),G1H4(85),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(85),45,0,G2H4(217),n2h4(245))
  call Hloop_QV_A(ntryL,G1H8(28),ex3(:),G1H4(86),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(86),45,0,G2H4(218),n2h4(246))
  call Hloop_QW_A(ntryL,G1H12(199),ex4(:),G1H4(90),m3h3x4(:,119),heltab2x12(:,:,313))
  call Hloop_Q_A(ntryL,G1H4(90),57,0,G2H4(219),n2h4(247))
call HGT_raise_alpha_OLR(G1H12(205),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(205),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(205),ex2(:),G1H6(152),m3h2x6(:,195),heltab2x12(:,:,314))
  call Hloop_QW_A(ntryL,G1H12(203),ex4(:),G1H4(91),m3h3x4(:,120),heltab2x12(:,:,315))
  call Hloop_Q_A(ntryL,G1H4(91),57,0,G2H4(220),n2h4(248))
  call Hloop_QW_A(ntryL,G1H12(204),ex4(:),G1H4(92),m3h3x4(:,121),heltab2x12(:,:,316))
  call Hloop_Q_A(ntryL,G1H4(92),57,0,G2H4(221),n2h4(249))
  call Hloop_QW_A(ntryL,G1H12(206),ex4(:),G1H4(97),m3h3x4(:,122),heltab2x12(:,:,317))
  call Hloop_Q_A(ntryL,G1H4(97),57,0,G2H4(222),n2h4(250))
  call Hloop_QV_A(ntryL,G1H12(209),ex3(:),G1H6(156),m3h2x6(:,196),heltab2x12(:,:,318))
  call Hloop_Q_A(ntryL,G1H6(156),53,0,G2H6(137),n2h6(181))
call HGT_raise_alpha_OLR(G1H12(210),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(210),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(210),ex2(:),G1H6(157),m3h2x6(:,197),heltab2x12(:,:,319))
  call Hloop_QV_A(ntryL,G1H12(212),ex3(:),G1H6(158),m3h2x6(:,198),heltab2x12(:,:,320))
  call Hloop_Q_A(ntryL,G1H6(158),53,0,G2H6(138),n2h6(182))
  call Hloop_QV_A(ntryL,G1H12(217),ex3(:),G1H6(163),m3h2x6(:,199),heltab2x12(:,:,321))
  call Hloop_Q_A(ntryL,G1H6(163),53,0,G2H6(139),n2h6(183))
  call Hloop_QV_A(ntryL,G1H12(223),ex3(:),G1H6(164),m3h2x6(:,200),heltab2x12(:,:,322))
  call Hloop_Q_A(ntryL,G1H6(164),53,0,G2H6(140),n2h6(184))
  call Hloop_AW_Q(ntryL,G1H24(83),ex4(:),G1H8(39),m3h3x8(:,33),heltab2x24(:,:,159))
  call Hloop_A_Q(ntryL,G1H8(39),42,0,G2H8(31),n2h8(71))
call HGT_raise_alpha_OLR(G1H24(84),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(84),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(84),wf4(:,3),G1H6(168),m3h4x6(:,11),heltab2x24(:,:,160))
  call Hloop_AW_Q(ntryL,G1H24(13),ex4(:),G1H8(40),m3h3x8(:,34),heltab2x24(:,:,161))
  call Hloop_A_Q(ntryL,G1H8(40),42,0,G2H8(33),n2h8(72))
  call Hloop_AW_Q(ntryL,G1H24(54),ex4(:),G1H8(45),m3h3x8(:,35),heltab2x24(:,:,162))
  call Hloop_A_Q(ntryL,G1H8(45),42,0,G2H8(34),n2h8(73))
  call Hloop_AW_Q(ntryL,G1H24(59),ex4(:),G1H8(46),m3h3x8(:,36),heltab2x24(:,:,163))
  call Hloop_A_Q(ntryL,G1H8(46),42,0,G2H8(35),n2h8(74))
  call Hloop_AW_Q(ntryL,G1H24(2),ex4(:),G1H8(57),m3h3x8(:,37),heltab2x24(:,:,164))
  call Hloop_A_Q(ntryL,G1H8(57),42,0,G2H8(37),n2h8(75))
call HGT_raise_alpha_OLR(G1H24(23),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(23),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(23),-16,ex5(:),16,G2H12(9),m3h2x12(:,111),heltab2x24(:,:,165))
call signflip_OLR(G2H12(9))
  call Hloop_AW_Q(ntryL,G1H24(33),ex4(:),G1H8(58),m3h3x8(:,38),heltab2x24(:,:,166))
  call Hloop_A_Q(ntryL,G1H8(58),42,0,G2H8(38),n2h8(76))
  call Hloop_AW_Q(ntryL,G1H24(18),ex4(:),G1H8(63),m3h3x8(:,39),heltab2x24(:,:,167))
  call Hloop_A_Q(ntryL,G1H8(63),42,0,G2H8(1),n2h8(77))
  call Hloop_AW_Q(ntryL,G1H24(1),ex4(:),G1H8(64),m3h3x8(:,40),heltab2x24(:,:,168))
  call Hloop_A_Q(ntryL,G1H8(64),42,0,G2H8(2),n2h8(78))
  call Hloop_AV_Q(ntryL,G1H24(42),ex5(:),G1H12(227),m3h2x12(:,112),heltab2x24(:,:,169))
  call Hloop_A_Q(ntryL,G1H12(227),50,0,G2H12(10),n2h12(133))
call HGT_raise_alpha_OLR(G1H24(48),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(48),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(48),wf4(:,3),G1H6(169),m3h4x6(:,12),heltab2x24(:,:,170))
  call Hloop_AV_Q(ntryL,G1H24(17),ex5(:),G1H12(228),m3h2x12(:,113),heltab2x24(:,:,171))
  call Hloop_A_Q(ntryL,G1H12(228),50,0,G2H12(11),n2h12(134))
  call Hloop_AV_Q(ntryL,G1H24(65),ex5(:),G1H12(229),m3h2x12(:,114),heltab2x24(:,:,172))
  call Hloop_A_Q(ntryL,G1H12(229),50,0,G2H12(12),n2h12(135))
  call Hloop_AV_Q(ntryL,G1H24(71),ex5(:),G1H12(230),m3h2x12(:,115),heltab2x24(:,:,173))
  call Hloop_A_Q(ntryL,G1H12(230),50,0,G2H12(13),n2h12(136))
  call Hloop_QW_A(ntryL,G1H24(76),ex4(:),G1H8(75),m3h3x8(:,41),heltab2x24(:,:,174))
  call Hloop_Q_A(ntryL,G1H8(75),41,0,G2H8(9),n2h8(79))
call HGT_raise_alpha_OLR(G1H24(81),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(81),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(81),wf4(:,9),G1H6(170),m3h4x6(:,13),heltab2x24(:,:,175))
  call Hloop_QW_A(ntryL,G1H24(4),ex4(:),G1H8(76),m3h3x8(:,42),heltab2x24(:,:,176))
  call Hloop_Q_A(ntryL,G1H8(76),41,0,G2H8(5),n2h8(80))
  call Hloop_QW_A(ntryL,G1H24(28),ex4(:),G1H8(81),m3h3x8(:,43),heltab2x24(:,:,177))
  call Hloop_Q_A(ntryL,G1H8(81),41,0,G2H8(19),n2h8(81))
  call Hloop_QW_A(ntryL,G1H24(29),ex4(:),G1H8(82),m3h3x8(:,44),heltab2x24(:,:,178))
  call Hloop_Q_A(ntryL,G1H8(82),41,0,G2H8(15),n2h8(82))
  call Hloop_QW_A(ntryL,G1H24(30),ex4(:),G1H8(11),m3h3x8(:,45),heltab2x24(:,:,179))
  call Hloop_Q_A(ntryL,G1H8(11),41,0,G2H8(24),n2h8(83))
call HGT_raise_alpha_OLR(G1H24(35),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(35),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(35),-16,ex5(:),16,G2H12(14),m3h2x12(:,116),heltab2x24(:,:,180))
call signflip_OLR(G2H12(14))
  call Hloop_QW_A(ntryL,G1H24(5),ex4(:),G1H8(12),m3h3x8(:,46),heltab2x24(:,:,181))
  call Hloop_Q_A(ntryL,G1H8(12),41,0,G2H8(28),n2h8(84))
  call Hloop_QW_A(ntryL,G1H24(10),ex4(:),G1H8(14),m3h3x8(:,47),heltab2x24(:,:,182))
  call Hloop_Q_A(ntryL,G1H8(14),41,0,G2H8(4),n2h8(85))
  call Hloop_QW_A(ntryL,G1H24(11),ex4(:),G1H8(19),m3h3x8(:,48),heltab2x24(:,:,183))
  call Hloop_Q_A(ntryL,G1H8(19),41,0,G2H8(21),n2h8(86))
  call Hloop_QV_A(ntryL,G1H24(12),ex5(:),G1H12(235),m3h2x12(:,117),heltab2x24(:,:,184))
  call Hloop_Q_A(ntryL,G1H12(235),49,0,G2H12(15),n2h12(137))
call HGT_raise_alpha_OLR(G1H24(37),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(37),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(37),wf4(:,9),G1H6(175),m3h4x6(:,14),heltab2x24(:,:,185))
  call Hloop_QV_A(ntryL,G1H24(40),ex5(:),G1H12(241),m3h2x12(:,118),heltab2x24(:,:,186))
  call Hloop_Q_A(ntryL,G1H12(241),49,0,G2H12(16),n2h12(138))
  call Hloop_QV_A(ntryL,G1H24(41),ex5(:),G1H12(236),m3h2x12(:,119),heltab2x24(:,:,187))
  call Hloop_Q_A(ntryL,G1H12(236),49,0,G2H12(17),n2h12(139))
  call Hloop_QV_A(ntryL,G1H24(45),ex5(:),G1H12(239),m3h2x12(:,120),heltab2x24(:,:,188))
  call Hloop_Q_A(ntryL,G1H12(239),49,0,G2H12(18),n2h12(140))
  call Hloop_AV_Q(ntryL,G1H24(46),ex3(:),G1H12(240),m3h2x12(:,121),heltab2x24(:,:,189))
  call Hloop_A_Q(ntryL,G1H12(240),38,0,G2H12(19),n2h12(141))
call HGT_raise_alpha_OLR(G1H24(47),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(47),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(47),wf6(:,4),G1H4(98),m3h6x4(:,7),heltab2x24(:,:,190))
  call Hloop_AV_Q(ntryL,G1H24(50),ex3(:),G1H12(242),m3h2x12(:,122),heltab2x24(:,:,191))
  call Hloop_A_Q(ntryL,G1H12(242),38,0,G2H12(20),n2h12(142))
  call Hloop_AV_Q(ntryL,G1H24(52),ex3(:),G1H12(245),m3h2x12(:,123),heltab2x24(:,:,192))
  call Hloop_A_Q(ntryL,G1H12(245),38,0,G2H12(21),n2h12(143))
  call Hloop_AV_Q(ntryL,G1H24(53),ex3(:),G1H12(246),m3h2x12(:,124),heltab2x24(:,:,193))
  call Hloop_A_Q(ntryL,G1H12(246),38,0,G2H12(22),n2h12(144))
  call Hloop_AV_Q(ntryL,G1H24(62),ex3(:),G1H12(143),m3h2x12(:,125),heltab2x24(:,:,194))
  call Hloop_A_Q(ntryL,G1H12(143),38,0,G2H12(38),n2h12(145))
call HGT_raise_alpha_OLR(G1H24(64),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(64),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(64),-16,ex5(:),16,G2H12(36),m3h2x12(:,126),heltab2x24(:,:,195))
call signflip_OLR(G2H12(36))
  call Hloop_AV_Q(ntryL,G1H24(67),ex3(:),G1H12(144),m3h2x12(:,127),heltab2x24(:,:,196))
  call Hloop_A_Q(ntryL,G1H12(144),38,0,G2H12(49),n2h12(146))
  call Hloop_AV_Q(ntryL,G1H24(68),ex3(:),G1H12(161),m3h2x12(:,128),heltab2x24(:,:,197))
  call Hloop_A_Q(ntryL,G1H12(161),38,0,G2H12(39),n2h12(147))
  call Hloop_AV_Q(ntryL,G1H24(69),ex3(:),G1H12(162),m3h2x12(:,129),heltab2x24(:,:,198))
  call Hloop_A_Q(ntryL,G1H12(162),38,0,G2H12(23),n2h12(148))
  call Hloop_AV_Q(ntryL,G1H24(70),ex5(:),G1H12(179),m3h2x12(:,130),heltab2x24(:,:,199))
  call Hloop_A_Q(ntryL,G1H12(179),50,0,G2H12(25),n2h12(149))
call HGT_raise_alpha_OLR(G1H24(72),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(72),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(72),wf6(:,4),G1H4(102),m3h6x4(:,8),heltab2x24(:,:,200))
  call Hloop_AV_Q(ntryL,G1H24(75),ex5(:),G1H12(180),m3h2x12(:,131),heltab2x24(:,:,201))
  call Hloop_A_Q(ntryL,G1H12(180),50,0,G2H12(28),n2h12(150))
  call Hloop_AV_Q(ntryL,G1H24(77),ex5(:),G1H12(197),m3h2x12(:,132),heltab2x24(:,:,202))
  call Hloop_A_Q(ntryL,G1H12(197),50,0,G2H12(30),n2h12(151))
  call Hloop_AV_Q(ntryL,G1H24(78),ex5(:),G1H12(198),m3h2x12(:,133),heltab2x24(:,:,203))
  call Hloop_A_Q(ntryL,G1H12(198),50,0,G2H12(33),n2h12(152))
  call Hloop_QV_A(ntryL,G1H24(79),ex5(:),G1H12(215),m3h2x12(:,134),heltab2x24(:,:,204))
  call Hloop_Q_A(ntryL,G1H12(215),52,0,G2H12(35),n2h12(153))
call HGT_OLR(G1H24(16),1,1,24)
call HGT_invQ_OLR(G1H24(16),2,5,24)
  call Hloop_A_Q(ntryL,G1H24(16),-9,0,G2H24(5),n2h24(88))
  call Hloop_AQ_V(ntryL,G2H24(5),wf6(:,4),G2H4(223),m3h6x4(:,9),heltab2x24(:,:,205))
  call Hloop_QV_A(ntryL,G1H24(21),ex5(:),G1H12(216),m3h2x12(:,135),heltab2x24(:,:,206))
  call Hloop_Q_A(ntryL,G1H12(216),52,0,G2H12(41),n2h12(154))
  call Hloop_QV_A(ntryL,G1H24(22),ex5(:),G1H12(234),m3h2x12(:,136),heltab2x24(:,:,207))
  call Hloop_Q_A(ntryL,G1H12(234),52,0,G2H12(40),n2h12(155))
  call Hloop_QV_A(ntryL,G1H24(24),ex5(:),G1H12(12),m3h2x12(:,137),heltab2x24(:,:,208))
  call Hloop_Q_A(ntryL,G1H12(12),52,0,G2H12(44),n2h12(156))
  call Hloop_QV_A(ntryL,G1H24(25),ex3(:),G1H12(35),m3h2x12(:,138),heltab2x24(:,:,209))
  call Hloop_Q_A(ntryL,G1H12(35),37,0,G2H12(48),n2h12(157))
call HGT_raise_alpha_OLR(G1H24(26),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(26),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(26),wf6(:,2),G1H4(103),m3h6x4(:,10),heltab2x24(:,:,210))
  call Hloop_QV_A(ntryL,G1H24(32),ex3(:),G1H12(37),m3h2x12(:,139),heltab2x24(:,:,211))
  call Hloop_Q_A(ntryL,G1H12(37),37,0,G2H12(42),n2h12(158))
  call Hloop_QV_A(ntryL,G1H24(34),ex3(:),G1H12(142),m3h2x12(:,140),heltab2x24(:,:,212))
  call Hloop_Q_A(ntryL,G1H12(142),37,0,G2H12(52),n2h12(159))
  call Hloop_QV_A(ntryL,G1H24(6),ex3(:),G1H12(27),m3h2x12(:,141),heltab2x24(:,:,213))
  call Hloop_Q_A(ntryL,G1H12(27),37,0,G2H12(54),n2h12(160))
  call Hloop_QV_A(ntryL,G1H24(8),ex3(:),G1H12(26),m3h2x12(:,142),heltab2x24(:,:,214))
  call Hloop_Q_A(ntryL,G1H12(26),37,0,G2H12(58),n2h12(161))
call HGT_raise_alpha_OLR(G1H24(9),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(9),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(9),-16,ex5(:),16,G2H12(27),m3h2x12(:,143),heltab2x24(:,:,215))
call signflip_OLR(G2H12(27))
  call Hloop_QV_A(ntryL,G1H24(43),ex3(:),G1H12(160),m3h2x12(:,144),heltab2x24(:,:,216))
  call Hloop_Q_A(ntryL,G1H12(160),37,0,G2H12(29),n2h12(162))
  call Hloop_QV_A(ntryL,G1H24(44),ex3(:),G1H12(21),m3h2x12(:,145),heltab2x24(:,:,217))
  call Hloop_Q_A(ntryL,G1H12(21),37,0,G2H12(31),n2h12(163))
  call Hloop_QV_A(ntryL,G1H24(85),ex3(:),G1H12(25),m3h2x12(:,146),heltab2x24(:,:,218))
  call Hloop_Q_A(ntryL,G1H12(25),37,0,G2H12(32),n2h12(164))
  call Hloop_QV_A(ntryL,G1H24(86),ex5(:),G1H12(178),m3h2x12(:,147),heltab2x24(:,:,219))
  call Hloop_Q_A(ntryL,G1H12(178),49,0,G2H12(34),n2h12(165))
call HGT_raise_alpha_OLR(G1H24(87),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(87),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(87),wf6(:,2),G1H4(104),m3h6x4(:,11),heltab2x24(:,:,220))
  call Hloop_QV_A(ntryL,G1H24(89),ex5(:),G1H12(196),m3h2x12(:,148),heltab2x24(:,:,221))
  call Hloop_Q_A(ntryL,G1H12(196),49,0,G2H12(37),n2h12(166))
  call Hloop_QV_A(ntryL,G1H24(90),ex5(:),G1H12(45),m3h2x12(:,149),heltab2x24(:,:,222))
  call Hloop_Q_A(ntryL,G1H12(45),49,0,G2H12(24),n2h12(167))
  call Hloop_QV_A(ntryL,G1H24(91),ex5(:),G1H12(30),m3h2x12(:,150),heltab2x24(:,:,223))
  call Hloop_Q_A(ntryL,G1H12(30),49,0,G2H12(26),n2h12(168))
  call Hloop_AV_Q(ntryL,G1H24(51),ex5(:),G1H12(39),m3h2x12(:,151),heltab2x24(:,:,224))
  call Hloop_A_Q(ntryL,G1H12(39),52,0,G2H12(43),n2h12(169))
call HGT_OLR(G1H24(92),1,1,24)
call HGT_invQ_OLR(G1H24(92),2,5,24)
  call Hloop_Q_A(ntryL,G1H24(92),-10,0,G2H24(6),n2h24(92))
  call Hloop_QA_V(ntryL,G2H24(6),wf6(:,2),G2H4(224),m3h6x4(:,12),heltab2x24(:,:,225))
  call Hloop_AV_Q(ntryL,G1H24(94),ex5(:),G1H12(29),m3h2x12(:,152),heltab2x24(:,:,226))
  call Hloop_A_Q(ntryL,G1H12(29),52,0,G2H12(45),n2h12(170))
  call Hloop_AV_Q(ntryL,G1H24(95),ex5(:),G1H12(63),m3h2x12(:,153),heltab2x24(:,:,227))
  call Hloop_A_Q(ntryL,G1H12(63),52,0,G2H12(7),n2h12(171))
  call Hloop_AV_Q(ntryL,G1H24(96),ex5(:),G1H12(32),m3h2x12(:,154),heltab2x24(:,:,228))
  call Hloop_A_Q(ntryL,G1H12(32),52,0,G2H12(8),n2h12(172))
  call Hloop_QV_A(ntryL,G1H24(55),ex5(:),G1H12(214),m3h2x12(:,155),heltab2x24(:,:,229))
  call Hloop_Q_A(ntryL,G1H12(214),49,0,G2H12(61),n2h12(173))
call HGT_raise_alpha_OLR(G1H24(56),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(56),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(56),ex2(:),G1H12(57),m3h2x12(:,156),heltab2x24(:,:,230))
  call Hloop_QV_A(ntryL,G1H24(14),ex5(:),G1H12(31),m3h2x12(:,157),heltab2x24(:,:,231))
  call Hloop_Q_A(ntryL,G1H12(31),49,0,G2H12(62),n2h12(174))
  call Hloop_QV_A(ntryL,G1H24(58),ex5(:),G1H12(232),m3h2x12(:,158),heltab2x24(:,:,232))
  call Hloop_Q_A(ntryL,G1H12(232),49,0,G2H12(63),n2h12(175))
  call Hloop_QV_A(ntryL,G1H24(60),ex5(:),G1H12(10),m3h2x12(:,159),heltab2x24(:,:,233))
  call Hloop_Q_A(ntryL,G1H12(10),49,0,G2H12(64),n2h12(176))
  call Hloop_AW_Q(ntryL,G1H24(61),wf6(:,6),G1H4(109),m3h6x4(:,13),heltab2x24(:,:,234))
  call Hloop_A_Q(ntryL,G1H4(109),46,0,G2H4(225),n2h4(251))
call HGT_raise_alpha_OLR(G1H24(63),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(63),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(63),-16,ex5(:),16,G2H12(65),m3h2x12(:,160),heltab2x24(:,:,235))
call signflip_OLR(G2H12(65))
  call Hloop_AW_Q(ntryL,G1H24(98),wf6(:,6),G1H4(110),m3h6x4(:,14),heltab2x24(:,:,236))
  call Hloop_A_Q(ntryL,G1H4(110),46,0,G2H4(226),n2h4(252))
  call Hloop_AW_Q(ntryL,G1H24(99),wf6(:,6),G1H4(114),m3h6x4(:,15),heltab2x24(:,:,237))
  call Hloop_A_Q(ntryL,G1H4(114),46,0,G2H4(227),n2h4(253))
  call Hloop_AW_Q(ntryL,G1H24(100),wf6(:,6),G1H4(115),m3h6x4(:,16),heltab2x24(:,:,238))
  call Hloop_A_Q(ntryL,G1H4(115),46,0,G2H4(228),n2h4(254))
  call Hloop_QW_A(ntryL,G1H24(101),wf6(:,6),G1H4(116),m3h6x4(:,17),heltab2x24(:,:,239))
  call Hloop_Q_A(ntryL,G1H4(116),45,0,G2H4(229),n2h4(255))
call HGT_raise_alpha_OLR(G1H24(102),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(102),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(102),ex2(:),G1H12(16),m3h2x12(:,161),heltab2x24(:,:,240))
  call Hloop_QW_A(ntryL,G1H24(104),wf6(:,6),G1H4(121),m3h6x4(:,18),heltab2x24(:,:,241))
  call Hloop_Q_A(ntryL,G1H4(121),45,0,G2H4(230),n2h4(256))
  call Hloop_QW_A(ntryL,G1H24(105),wf6(:,6),G1H4(122),m3h6x4(:,19),heltab2x24(:,:,242))
  call Hloop_Q_A(ntryL,G1H4(122),45,0,G2H4(231),n2h4(257))
  call Hloop_QW_A(ntryL,G1H24(106),wf6(:,6),G1H4(126),m3h6x4(:,20),heltab2x24(:,:,243))
  call Hloop_Q_A(ntryL,G1H4(126),45,0,G2H4(232),n2h4(258))
  call Hloop_QW_A(ntryL,G1H24(107),wf6(:,6),G1H4(127),m3h6x4(:,21),heltab2x24(:,:,244))
  call Hloop_Q_A(ntryL,G1H4(127),45,0,G2H4(233),n2h4(259))
call HGT_raise_alpha_OLR(G1H24(108),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(108),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(108),-16,ex5(:),16,G2H12(66),m3h2x12(:,162),heltab2x24(:,:,245))
call signflip_OLR(G2H12(66))
  call Hloop_QW_A(ntryL,G1H24(110),wf6(:,6),G1H4(128),m3h6x4(:,22),heltab2x24(:,:,246))
  call Hloop_Q_A(ntryL,G1H4(128),45,0,G2H4(234),n2h4(260))
  call Hloop_QW_A(ntryL,G1H24(111),wf6(:,6),G1H4(133),m3h6x4(:,23),heltab2x24(:,:,247))
  call Hloop_Q_A(ntryL,G1H4(133),45,0,G2H4(235),n2h4(261))
  call Hloop_QW_A(ntryL,G1H24(112),wf6(:,6),G1H4(134),m3h6x4(:,24),heltab2x24(:,:,248))
  call Hloop_Q_A(ntryL,G1H4(134),45,0,G2H4(236),n2h4(262))
  call Hloop_AV_Q(ntryL,G1H24(113),ex3(:),G1H12(34),m3h2x12(:,163),heltab2x24(:,:,249))
  call Hloop_A_Q(ntryL,G1H12(34),38,0,G2H12(67),n2h12(177))
call HGT_raise_alpha_OLR(G1H24(114),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(114),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(114),wf4(:,11),G1H6(176),m3h4x6(:,15),heltab2x24(:,:,250))
  call Hloop_AV_Q(ntryL,G1H24(116),ex3(:),G1H12(52),m3h2x12(:,164),heltab2x24(:,:,251))
  call Hloop_A_Q(ntryL,G1H12(52),38,0,G2H12(68),n2h12(178))
  call Hloop_AV_Q(ntryL,G1H24(117),ex3(:),G1H12(69),m3h2x12(:,165),heltab2x24(:,:,252))
  call Hloop_A_Q(ntryL,G1H12(69),38,0,G2H12(69),n2h12(179))
  call Hloop_AV_Q(ntryL,G1H24(118),ex3(:),G1H12(75),m3h2x12(:,166),heltab2x24(:,:,253))
  call Hloop_A_Q(ntryL,G1H12(75),38,0,G2H12(70),n2h12(180))
  call Hloop_QV_A(ntryL,G1H16(8),ex3(:),G1H8(25),m3h2x8(:,17),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(25),44,0,G2H8(12),n2h8(87))
call HGT_OLR(G1H16(10),1,1,16)
call HGT_invQ_OLR(G1H16(10),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(10),-17,0,G2H16(3),n2h16(13))
  call Hloop_AQ_V(ntryL,G2H16(3),wf4(:,11),G2H4(237),m3h4x4(:,3),heltab2x16(:,:,20))
  call Hloop_QV_A(ntryL,G1H16(12),ex3(:),G1H8(20),m3h2x8(:,18),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(20),44,0,G2H8(14),n2h8(88))
  call Hloop_QV_A(ntryL,G1H16(3),ex3(:),G1H8(23),m3h2x8(:,19),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(23),44,0,G2H8(20),n2h8(89))
  call Hloop_QV_A(ntryL,G1H16(9),ex3(:),G1H8(26),m3h2x8(:,20),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(26),44,0,G2H8(22),n2h8(90))
  call Hloop_AW_Q(ntryL,G1H24(119),ex4(:),G1H8(29),m3h3x8(:,49),heltab2x24(:,:,254))
  call Hloop_A_Q(ntryL,G1H8(29),42,0,G2H8(18),n2h8(91))
call HGT_raise_alpha_OLR(G1H24(120),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(120),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(120),wf4(:,11),G1H6(180),m3h4x6(:,16),heltab2x24(:,:,255))
  call Hloop_AW_Q(ntryL,G1H24(122),ex4(:),G1H8(30),m3h3x8(:,50),heltab2x24(:,:,256))
  call Hloop_A_Q(ntryL,G1H8(30),42,0,G2H8(17),n2h8(92))
  call Hloop_AW_Q(ntryL,G1H24(123),ex4(:),G1H8(31),m3h3x8(:,51),heltab2x24(:,:,257))
  call Hloop_A_Q(ntryL,G1H8(31),42,0,G2H8(32),n2h8(93))
  call Hloop_AW_Q(ntryL,G1H24(124),ex4(:),G1H8(32),m3h3x8(:,52),heltab2x24(:,:,258))
  call Hloop_A_Q(ntryL,G1H8(32),42,0,G2H8(36),n2h8(94))
  call Hloop_QW_A(ntryL,G1H24(125),ex4(:),G1H8(43),m3h3x8(:,53),heltab2x24(:,:,259))
  call Hloop_Q_A(ntryL,G1H8(43),44,0,G2H8(10),n2h8(95))
call HGT_OLR(G1H24(126),1,1,24)
call HGT_invQ_OLR(G1H24(126),2,5,24)
  call Hloop_A_Q(ntryL,G1H24(126),-17,0,G2H24(7),n2h24(99))
  call Hloop_AQ_V(ntryL,G2H24(7),wf4(:,11),G2H6(141),m3h4x6(:,17),heltab2x24(:,:,260))
  call Hloop_QW_A(ntryL,G1H24(128),ex4(:),G1H8(38),m3h3x8(:,54),heltab2x24(:,:,261))
  call Hloop_Q_A(ntryL,G1H8(38),44,0,G2H8(11),n2h8(96))
  call Hloop_QW_A(ntryL,G1H24(129),ex4(:),G1H8(41),m3h3x8(:,55),heltab2x24(:,:,262))
  call Hloop_Q_A(ntryL,G1H8(41),44,0,G2H8(13),n2h8(97))
  call Hloop_QW_A(ntryL,G1H24(130),ex4(:),G1H8(42),m3h3x8(:,56),heltab2x24(:,:,263))
  call Hloop_Q_A(ntryL,G1H8(42),44,0,G2H8(16),n2h8(98))
  call Hloop_QV_A(ntryL,G1H24(74),ex3(:),G1H12(81),m3h2x12(:,167),heltab2x24(:,:,264))
  call Hloop_Q_A(ntryL,G1H12(81),37,0,G2H12(71),n2h12(181))
call HGT_raise_alpha_OLR(G1H24(15),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(15),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(15),wf4(:,5),G1H6(181),m3h4x6(:,18),heltab2x24(:,:,265))
  call Hloop_QV_A(ntryL,G1H24(132),ex3(:),G1H12(87),m3h2x12(:,168),heltab2x24(:,:,266))
  call Hloop_Q_A(ntryL,G1H12(87),37,0,G2H12(72),n2h12(182))
  call Hloop_QV_A(ntryL,G1H24(133),ex3(:),G1H12(93),m3h2x12(:,169),heltab2x24(:,:,267))
  call Hloop_Q_A(ntryL,G1H12(93),37,0,G2H12(73),n2h12(183))
  call Hloop_QV_A(ntryL,G1H24(134),ex3(:),G1H12(99),m3h2x12(:,170),heltab2x24(:,:,268))
  call Hloop_Q_A(ntryL,G1H12(99),37,0,G2H12(74),n2h12(184))
  call Hloop_AV_Q(ntryL,G1H16(1),ex3(:),G1H8(44),m3h2x8(:,21),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(44),44,0,G2H8(3),n2h8(99))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-18,0,G2H16(4),n2h16(14))
  call Hloop_QA_V(ntryL,G2H16(4),wf4(:,5),G2H4(238),m3h4x4(:,4),heltab2x16(:,:,25))
  call Hloop_AV_Q(ntryL,G1H16(5),ex3(:),G1H8(48),m3h2x8(:,22),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(48),44,0,G2H8(6),n2h8(100))
  call Hloop_AV_Q(ntryL,G1H16(6),ex3(:),G1H8(49),m3h2x8(:,23),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(49),44,0,G2H8(7),n2h8(101))
  call Hloop_AV_Q(ntryL,G1H16(7),ex3(:),G1H8(50),m3h2x8(:,24),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(50),44,0,G2H8(8),n2h8(102))
  call Hloop_QW_A(ntryL,G1H24(135),ex4(:),G1H8(55),m3h3x8(:,57),heltab2x24(:,:,269))
  call Hloop_Q_A(ntryL,G1H8(55),41,0,G2H8(26),n2h8(103))
call HGT_raise_alpha_OLR(G1H24(136),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(136),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(136),wf4(:,5),G1H6(182),m3h4x6(:,19),heltab2x24(:,:,270))
  call Hloop_QW_A(ntryL,G1H24(138),ex4(:),G1H8(61),m3h3x8(:,58),heltab2x24(:,:,271))
  call Hloop_Q_A(ntryL,G1H8(61),41,0,G2H8(27),n2h8(104))
  call Hloop_QW_A(ntryL,G1H24(139),ex4(:),G1H8(59),m3h3x8(:,59),heltab2x24(:,:,272))
  call Hloop_Q_A(ntryL,G1H8(59),41,0,G2H8(29),n2h8(105))
  call Hloop_QW_A(ntryL,G1H24(140),ex4(:),G1H8(60),m3h3x8(:,60),heltab2x24(:,:,273))
  call Hloop_Q_A(ntryL,G1H8(60),41,0,G2H8(30),n2h8(106))
  call Hloop_AW_Q(ntryL,G1H24(141),ex4(:),G1H8(62),m3h3x8(:,61),heltab2x24(:,:,274))
  call Hloop_A_Q(ntryL,G1H8(62),44,0,G2H8(39),n2h8(107))
call HGT_OLR(G1H24(142),1,1,24)
call HGT_invQ_OLR(G1H24(142),2,5,24)
  call Hloop_Q_A(ntryL,G1H24(142),-18,0,G2H24(8),n2h24(102))
  call Hloop_QA_V(ntryL,G2H24(8),wf4(:,5),G2H6(142),m3h4x6(:,20),heltab2x24(:,:,275))
  call Hloop_AW_Q(ntryL,G1H24(144),ex4(:),G1H8(65),m3h3x8(:,62),heltab2x24(:,:,276))
  call Hloop_A_Q(ntryL,G1H8(65),44,0,G2H8(40),n2h8(108))
  call Hloop_AW_Q(ntryL,G1H24(145),ex4(:),G1H8(66),m3h3x8(:,63),heltab2x24(:,:,277))
  call Hloop_A_Q(ntryL,G1H8(66),44,0,G2H8(41),n2h8(109))
  call Hloop_AW_Q(ntryL,G1H24(146),ex4(:),G1H8(68),m3h3x8(:,64),heltab2x24(:,:,278))
  call Hloop_A_Q(ntryL,G1H8(68),44,0,G2H8(42),n2h8(110))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(111),[G2H4(2),G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(113),[G2H4(5),G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(102),[G2H6(60),G2H6(2),G1H6(209),G1H6(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(112),[G2H4(8),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(116),[G2H4(11),G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(99),[G2H6(54),G2H6(5),G1H6(185),G1H6(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(59)])
call HGT_OLR(G2H6(8),1,1,6)
call HGT_invQ_OLR(G2H6(8),2,5,6)
call HGT_OLR(G2H6(8),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(8),[G2H6(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(9),[G1H6(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(107),[G1H4(9)])
call HGT_OLR(G2H4(17),1,1,4)
call HGT_invQ_OLR(G2H4(17),2,5,4)
call HGT_OLR(G2H4(17),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G1H6(53)])
call HGT_OLR(G2H6(15),1,1,6)
call HGT_invQ_OLR(G2H6(15),2,5,6)
call HGT_OLR(G2H6(15),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(15),[G2H6(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(96),[G2H6(16),G1H6(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G1H4(57)])
call HGT_OLR(G2H4(18),1,1,4)
call HGT_invQ_OLR(G2H4(18),2,5,4)
call HGT_OLR(G2H4(18),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(95),[G2H6(19),G1H6(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(71)])
call HGT_OLR(G2H6(22),1,1,6)
call HGT_invQ_OLR(G2H6(22),2,5,6)
call HGT_OLR(G2H6(22),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(22),[G2H6(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(23),[G1H6(89)])
call HGT_OLR(G2H6(25),1,1,6)
call HGT_invQ_OLR(G2H6(25),2,5,6)
call HGT_OLR(G2H6(25),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(25),[G2H6(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(115),[G2H4(24),G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(11),[G1H6(87)])
call HGT_OLR(G2H6(26),1,1,6)
call HGT_invQ_OLR(G2H6(26),2,5,6)
call HGT_OLR(G2H6(26),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(26),[G2H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(114),[G2H4(27),G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(109),[G1H4(33)])
call HGT_OLR(G2H4(29),1,1,4)
call HGT_invQ_OLR(G2H4(29),2,5,4)
call HGT_OLR(G2H4(29),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(28),[G1H6(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(101),[G2H6(57),G2H6(31),G1H6(197),G1H6(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(14),[G1H6(99)])
call HGT_OLR(G2H6(34),1,1,6)
call HGT_invQ_OLR(G2H6(34),2,5,6)
call HGT_OLR(G2H6(34),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(34),[G2H6(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(100),[G2H6(64),G2H6(35),G1H6(221),G1H6(125)])
call HGT_OLR(G2H6(38),1,1,6)
call HGT_invQ_OLR(G2H6(38),2,5,6)
call HGT_OLR(G2H6(38),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(38),[G2H6(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(98),[G2H6(39),G1H6(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G1H4(69)])
call HGT_OLR(G2H4(31),1,1,4)
call HGT_invQ_OLR(G2H4(31),2,5,4)
call HGT_OLR(G2H4(31),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(97),[G2H6(42),G1H6(149)])
call HGT_OLR(G2H6(44),1,1,6)
call HGT_invQ_OLR(G2H6(44),2,5,6)
call HGT_OLR(G2H6(44),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(44),[G2H6(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(118),[G2H4(33),G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(1),[G1H6(39)])
call HGT_OLR(G2H6(45),1,1,6)
call HGT_invQ_OLR(G2H6(45),2,5,6)
call HGT_OLR(G2H6(45),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(45),[G2H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(117),[G2H4(36),G1H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(104),[G2H6(67),G2H6(47),G1H6(233),G1H6(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(4),[G1H6(51)])
call HGT_OLR(G2H6(50),1,1,6)
call HGT_invQ_OLR(G2H6(50),2,5,6)
call HGT_OLR(G2H6(50),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(50),[G2H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(103),[G2H6(71),G2H6(51),G1H6(245),G1H6(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(46),[G1H6(207)])
call HGT_OLR(G2H6(63),1,1,6)
call HGT_invQ_OLR(G2H6(63),2,5,6)
call HGT_OLR(G2H6(63),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(63),[G2H6(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(37),[G1H6(183)])
call HGT_OLR(G2H6(70),1,1,6)
call HGT_invQ_OLR(G2H6(70),2,5,6)
call HGT_OLR(G2H6(70),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(70),[G2H6(37)])
call HGT_lower_alpha_OLR(G2H4(44),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(44),2,5,4)
call HGT_lower_alpha_OLR(G2H4(44),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(225),[G2H4(68),G2H4(45)])
call HGT_lower_alpha_OLR(G2H4(47),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(47),2,5,4)
call HGT_lower_alpha_OLR(G2H4(47),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(227),[G2H4(72),G2H4(70),G2H4(51),G2H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(228),[G2H4(71),G2H4(49)])
call HGT_lower_alpha_OLR(G2H4(50),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(50),2,5,4)
call HGT_lower_alpha_OLR(G2H4(50),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(150)])
call HGT_lower_alpha_OLR(G2H6(73),1,1,6)
call HGT_lower_alpha_invQ_OLR(G2H6(73),2,5,6)
call HGT_lower_alpha_OLR(G2H6(73),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(73),[G2H6(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(233),[G2H4(76),G2H4(54)])
call HGT_lower_alpha_OLR(G2H6(74),1,1,6)
call HGT_lower_alpha_invQ_OLR(G2H6(74),2,5,6)
call HGT_lower_alpha_OLR(G2H6(74),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(74),[G2H6(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(235),[G2H4(82),G2H4(79),G2H4(58),G2H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(236),[G2H4(80),G2H4(57)])
call HGT_lower_alpha_OLR(G2H6(75),1,1,6)
call HGT_lower_alpha_invQ_OLR(G2H6(75),2,5,6)
call HGT_lower_alpha_OLR(G2H6(75),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(75),[G2H6(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(82),[G1H6(75)])
call HGT_w2_OLR(G1H6(1),1,1,6)
call HGT_w2_invQ_OLR(G1H6(1),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(82),[G1H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(87),[G2H6(77),G1H6(274),G1H6(257)])
call HGT_w2_OLR(G1H6(2),1,1,6)
call HGT_w2_invQ_OLR(G1H6(2),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(2),[G1H6(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(91),[G2H6(89),G2H6(81),G2H6(79),G1H6(280),G1H6(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(90),[G2H6(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(86),[G1H6(63)])
call HGT_w2_OLR(G1H6(4),1,1,6)
call HGT_w2_invQ_OLR(G1H6(4),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(86),[G1H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(229),[G2H4(92),G2H4(61),G1H4(165),G1H4(131)])
call HGT_w2_OLR(G1H6(5),1,1,6)
call HGT_w2_invQ_OLR(G1H6(5),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(5),[G1H6(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(231),[G2H4(96),G2H4(94),G2H4(65),G2H4(63),G1H4(171) &
    ,G1H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(232),[G2H4(95),G2H4(64)])
call HGT_lower_alpha_OLR(G2H6(83),1,1,6)
call HGT_lower_alpha_invQ_OLR(G2H6(83),2,5,6)
call HGT_lower_alpha_OLR(G2H6(83),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(83),[G2H6(122)])
call HGT_lower_alpha_OLR(G2H6(84),1,1,6)
call HGT_lower_alpha_invQ_OLR(G2H6(84),2,5,6)
call HGT_lower_alpha_OLR(G2H6(84),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(84),[G2H6(124)])
call HGT_lower_alpha_OLR(G2H6(85),1,1,6)
call HGT_lower_alpha_invQ_OLR(G2H6(85),2,5,6)
call HGT_lower_alpha_OLR(G2H6(85),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(85),[G2H6(125)])
call HGT_lower_alpha_OLR(G2H4(75),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(75),2,5,4)
call HGT_lower_alpha_OLR(G2H4(75),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G2H4(168)])
call HGT_lower_alpha_OLR(G2H4(78),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(78),2,5,4)
call HGT_lower_alpha_OLR(G2H4(78),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G2H4(170)])
call HGT_lower_alpha_OLR(G2H4(81),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(81),2,5,4)
call HGT_lower_alpha_OLR(G2H4(81),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(81),[G2H4(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G1H4(93)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(99),[G2H4(85),G1H4(182),G1H4(148)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(103),[G2H4(101),G2H4(89),G2H4(87),G1H4(188),G1H4(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(102),[G2H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G1H4(81)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G1H4(4)])
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(88),[G1H6(123)])
call HGT_w2_OLR(G1H6(7),1,1,6)
call HGT_w2_invQ_OLR(G1H6(7),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(88),[G1H6(7)])
call HGT_w2_OLR(G1H6(8),1,1,6)
call HGT_w2_invQ_OLR(G1H6(8),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(8),[G1H6(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(92),[G1H6(111)])
call HGT_w2_OLR(G1H6(10),1,1,6)
call HGT_w2_invQ_OLR(G1H6(10),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(92),[G1H6(10)])
call HGT_w2_OLR(G1H6(11),1,1,6)
call HGT_w2_invQ_OLR(G1H6(11),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(11),[G1H6(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(22),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(108),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(93),[G1H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(76),[G1H6(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(215),[G1H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G1H4(46),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(110),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(94),[G1H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(78),[G1H6(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(191),[G1H6(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(3),[G1H6(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(6),[G1H6(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(7),[G1H6(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G1H6(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(13),[G1H6(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(17),[G1H6(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(18),[G1H6(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(203),[G1H6(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(20),[G1H6(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(227),[G1H6(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(21),[G1H6(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(24),[G1H6(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(27),[G1H6(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(29),[G1H6(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(69),[G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(73),[G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(77),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(30),[G1H6(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(32),[G1H6(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(239),[G1H6(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(33),[G1H6(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(36),[G1H6(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(251),[G1H6(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(40),[G1H6(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(41),[G1H6(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(43),[G1H6(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(48),[G1H6(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(49),[G1H6(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(52),[G1H6(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(53),[G1H6(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(55),[G1H6(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(56),[G1H6(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(58),[G1H6(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(132),[G1H6(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(118),[G1H6(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(134),[G2H6(62),G1H6(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(120),[G2H6(65),G1H6(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(286),[G1H6(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(198),[G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(160),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(200),[G2H4(1),G1H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(162),[G2H4(3),G1H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(177),[G1H4(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(211),[G1H4(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(177),[G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(213),[G2H4(23),G1H4(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(179),[G2H4(25),G1H4(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(194),[G1H4(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(215),[G1H4(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(181),[G1H4(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(217),[G2H4(32),G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(183),[G2H4(34),G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(219),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(185),[G1H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(221),[G2H4(105),G1H4(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(187),[G2H4(106),G1H4(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(137),[G1H6(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(127),[G1H6(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(139),[G2H6(69),G1H6(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(129),[G2H6(72),G1H6(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(192),[G2H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(154),[G2H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(196),[G2H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(158),[G2H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(204),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(166),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(209),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(175),[G2H4(16)])
  call Hotf_5pt_reduction(G2H4(111),RedSet_5(94),mass5set(:,1),  & 
G1H4(139),G1H4(140),G1H4(144),G1H4(145),G1H4(150),G1H4(151),4)
  call HG1shiftOLR(G1H4(140),16,4)
  call Hotf_5pt_reduction(G2H4(113),RedSet_5(95),mass5set(:,1),  & 
G1H4(156),G1H4(157),G1H4(161),G1H4(162),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(157),16,4)
  call Hotf_5pt_reduction(G2H6(102),RedSet_5(96),mass5set(:,1),  & 
G1H6(187),G1H6(188),G1H6(192),G1H6(193),G1H6(194),G1H6(199),6)
  call HG1shiftOLR(G1H6(188),8,6)
  call Hotf_5pt_reduction(G2H4(112),RedSet_5(97),mass5set(:,1),  & 
G1H4(173),G1H4(174),G1H4(178),G1H4(179),G1H4(184),G1H4(185),4)
  call HG1shiftOLR(G1H4(174),16,4)
  call Hotf_5pt_reduction(G2H4(116),RedSet_5(98),mass5set(:,1),  & 
G1H4(190),G1H4(191),G1H4(12),G1H4(24),G1H4(36),G1H4(48),4)
  call HG1shiftOLR(G1H4(191),16,4)
  call Hotf_5pt_reduction(G2H6(99),RedSet_5(99),mass5set(:,1),  & 
G1H6(200),G1H6(204),G1H6(205),G1H6(206),G1H6(211),G1H6(212),6)
  call HG1shiftOLR(G1H6(204),8,6)
call HGT_OLR(G2H4(14),1,1,4)
call HGT_invQ_OLR(G2H4(14),2,5,4)
call HGT_OLR(G2H4(14),6,15,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(100),mass5set(:,1),  & 
G1H4(60),G1H4(72),G1H4(84),G1H4(96),G1H4(108),G1H4(132),4)
  call HG1shiftOLR(G1H4(72),4,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(101),mass5set(:,1),  & 
G1H4(138),G1H4(149),G1H4(155),G1H4(172),G1H4(183),G1H4(189),4)
  call HG1shiftOLR(G1H4(149),16,4)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(102),mass5set(:,1),  & 
G1H6(216),G1H6(217),G1H6(218),G1H6(223),G1H6(224),G1H6(228),6)
  call HG1shiftOLR(G1H6(217),8,6)
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(103),mass5set(:,1),  & 
G1H6(229),G1H6(230),G1H6(235),G1H6(236),G1H6(240),G1H6(241),6)
  call HG1shiftOLR(G1H6(230),16,6)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(104),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(13),G1H4(14),G1H4(18),G1H4(19),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(105),mass5set(:,1),  & 
G1H6(242),G1H6(247),G1H6(248),G1H6(252),G1H6(253),G1H6(254),6)
  call HG1shiftOLR(G1H6(247),8,6)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(106),mass5set(:,1),  & 
G1H6(259),G1H6(260),G1H6(265),G1H6(266),G1H6(270),G1H6(271),6)
  call HG1shiftOLR(G1H6(260),8,6)
  call Hotf_5pt_reduction(G2H6(96),RedSet_5(107),mass5set(:,1),  & 
G1H6(276),G1H6(277),G1H6(282),G1H6(283),G1H6(18),G1H6(30),6)
  call HG1shiftOLR(G1H6(277),16,6)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(108),mass5set(:,1),  & 
G1H4(20),G1H4(25),G1H4(26),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(25),16,4)
  call Hotf_5pt_reduction(G2H6(95),RedSet_5(109),mass5set(:,1),  & 
G1H6(42),G1H6(54),G1H6(66),G1H6(78),G1H6(90),G1H6(102),6)
  call HG1shiftOLR(G1H6(54),8,6)
call HGT_OLR(G2H4(20),1,1,4)
call HGT_invQ_OLR(G2H4(20),2,5,4)
call HGT_OLR(G2H4(20),6,15,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(110),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(42),G1H4(43),G1H4(44),G1H4(49),4)
  call HG1shiftOLR(G1H4(38),4,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(101),mass5set(:,1),  & 
G1H4(50),G1H4(54),G1H4(55),G1H4(56),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(54),16,4)
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(111),mass5set(:,1),  & 
G1H6(114),G1H6(126),G1H6(138),G1H6(150),G1H6(162),G1H6(174),6)
  call HG1shiftOLR(G1H6(126),8,6)
  call Hotf_5pt_reduction(G2H6(23),RedSet_5(103),mass5set(:,1),  & 
G1H6(186),G1H6(198),G1H6(210),G1H6(222),G1H6(234),G1H6(246),6)
  call HG1shiftOLR(G1H6(198),16,6)
  call Hotf_5pt_reduction(G2H6(25),RedSet_5(112),mass5set(:,1),  & 
G1H6(258),G1H6(264),G1H6(275),G1H6(281),G1H6(13),G1H6(14),6)
  call HG1shiftOLR(G1H6(264),4,6)
  call Hotf_5pt_reduction(G2H4(115),RedSet_5(113),mass5set(:,1),  & 
G1H4(66),G1H4(68),G1H4(73),G1H4(74),G1H4(78),G1H4(80),4)
  call HG1shiftOLR(G1H4(68),16,4)
  call Hotf_5pt_reduction(G2H6(26),RedSet_5(114),mass5set(:,1),  & 
G1H6(19),G1H6(20),G1H6(24),G1H6(25),G1H6(26),G1H6(31),6)
  call HG1shiftOLR(G1H6(20),16,6)
  call Hotf_5pt_reduction(G2H4(114),RedSet_5(115),mass5set(:,1),  & 
G1H4(85),G1H4(86),G1H4(90),G1H4(91),G1H4(92),G1H4(97),4)
  call HG1shiftOLR(G1H4(86),4,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(116),mass5set(:,1),  & 
G1H4(109),G1H4(110),G1H4(114),G1H4(115),G1H4(116),G1H4(121),4)
  call HG1shiftOLR(G1H4(110),16,4)
  call Hotf_5pt_reduction(G2H6(28),RedSet_5(105),mass5set(:,1),  & 
G1H6(32),G1H6(36),G1H6(37),G1H6(38),G1H6(43),G1H6(44),6)
  call HG1shiftOLR(G1H6(36),8,6)
call HGT_OLR(G2H4(30),1,1,4)
call HGT_invQ_OLR(G2H4(30),2,5,4)
call HGT_OLR(G2H4(30),6,15,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(117),mass5set(:,1),  & 
G1H4(122),G1H4(126),G1H4(127),G1H4(128),G1H4(133),G1H4(134),4)
  call HG1shiftOLR(G1H4(126),4,4)
  call Hotf_5pt_reduction(G2H6(101),RedSet_5(118),mass5set(:,1),  & 
G1H6(48),G1H6(49),G1H6(50),G1H6(55),G1H6(56),G1H6(60),6)
  call HG1shiftOLR(G1H6(49),8,6)
  call Hotf_5pt_reduction(G2H6(34),RedSet_5(119),mass5set(:,1),  & 
G1H6(61),G1H6(62),G1H6(67),G1H6(68),G1H6(72),G1H6(73),6)
  call HG1shiftOLR(G1H6(62),8,6)
  call Hotf_5pt_reduction(G2H6(100),RedSet_5(120),mass5set(:,1),  & 
G1H6(74),G1H6(79),G1H6(84),G1H6(86),G1H6(91),G1H6(92),6)
  call HG1shiftOLR(G1H6(79),4,6)
  call Hotf_5pt_reduction(G2H6(38),RedSet_5(121),mass5set(:,1),  & 
G1H6(96),G1H6(98),G1H6(103),G1H6(104),G1H6(109),G1H6(115),6)
  call HG1shiftOLR(G1H6(98),8,6)
  call Hotf_5pt_reduction(G2H6(98),RedSet_5(122),mass5set(:,1),  & 
G1H6(116),G1H6(120),G1H6(127),G1H6(132),G1H6(133),G1H6(134),6)
  call HG1shiftOLR(G1H6(120),16,6)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(123),mass5set(:,1),  & 
G1H4(11),G1H4(23),G1H4(35),G1H4(47),G1H4(59),G1H4(9),4)
  call HG1shiftOLR(G1H4(23),16,4)
  call Hotf_5pt_reduction(G2H6(97),RedSet_5(124),mass5set(:,1),  & 
G1H6(139),G1H6(144),G1H6(145),G1H6(146),G1H6(156),G1H6(158),6)
  call HG1shiftOLR(G1H6(144),8,6)
  call Hotf_5pt_reduction(G2H6(44),RedSet_5(125),mass5set(:,1),  & 
G1H6(163),G1H6(164),G1H6(209),G1H6(17),G1H6(185),G1H6(29),6)
  call HG1shiftOLR(G1H6(164),4,6)
  call Hotf_5pt_reduction(G2H4(118),RedSet_5(126),mass5set(:,1),  & 
G1H4(57),G1H4(71),G1H4(83),G1H4(95),G1H4(33),G1H4(69),4)
  call HG1shiftOLR(G1H4(71),16,4)
  call Hotf_5pt_reduction(G2H6(45),RedSet_5(127),mass5set(:,1),  & 
G1H6(41),G1H6(53),G1H6(65),G1H6(77),G1H6(89),G1H6(87),6)
  call HG1shiftOLR(G1H6(53),16,6)
  call Hotf_5pt_reduction(G2H4(117),RedSet_5(128),mass5set(:,1),  & 
G1H4(107),G1H4(119),G1H4(165),G1H4(131),G1H4(171),G1H4(137),4)
  call HG1shiftOLR(G1H4(119),4,4)
call HGT_OLR(G2H4(38),1,1,4)
call HGT_invQ_OLR(G2H4(38),2,5,4)
call HGT_OLR(G2H4(38),6,15,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(129),mass5set(:,1),  & 
G1H4(93),G1H4(1),G1H4(182),G1H4(148),G1H4(99),G1H4(188),4)
  call HG1shiftOLR(G1H4(1),4,4)
  call Hotf_5pt_reduction(G2H6(104),RedSet_5(130),mass5set(:,1),  & 
G1H6(101),G1H6(197),G1H6(113),G1H6(99),G1H6(221),G1H6(125),6)
  call HG1shiftOLR(G1H6(197),8,6)
  call Hotf_5pt_reduction(G2H6(50),RedSet_5(131),mass5set(:,1),  & 
G1H6(137),G1H6(149),G1H6(39),G1H6(233),G1H6(161),G1H6(51),6)
  call HG1shiftOLR(G1H6(149),8,6)
  call Hotf_5pt_reduction(G2H6(103),RedSet_5(132),mass5set(:,1),  & 
G1H6(245),G1H6(173),G1H6(207),G1H6(183),G1H6(75),G1H6(1),6)
  call HG1shiftOLR(G1H6(173),4,6)
call HGT_OLR(G2H4(39),1,1,4)
call HGT_invQ_OLR(G2H4(39),2,5,4)
call HGT_OLR(G2H4(39),6,15,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(133),mass5set(:,1),  & 
G1H4(154),G1H4(81),G1H4(4),G1H4(87),G1H4(22),G1H4(10),4)
  call HG1shiftOLR(G1H4(81),2,4)
call HGT_OLR(G2H4(40),1,1,4)
call HGT_invQ_OLR(G2H4(40),2,5,4)
call HGT_OLR(G2H4(40),6,15,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(134),mass5set(:,1),  & 
G1H4(16),G1H4(21),G1H4(46),G1H4(34),G1H4(40),G1H4(45),4)
  call HG1shiftOLR(G1H4(21),4,4)
call HGT_OLR(G2H4(41),1,1,4)
call HGT_invQ_OLR(G2H4(41),2,5,4)
call HGT_OLR(G2H4(41),6,15,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(135),mass5set(:,1),  & 
G1H4(58),G1H4(70),G1H4(82),G1H4(94),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(70),1,4)
  call Hotf_5pt_reduction(G2H6(63),RedSet_5(136),mass5set(:,1),  & 
G1H6(274),G1H6(257),G1H6(81),G1H6(280),G1H6(263),G1H6(63),6)
  call HG1shiftOLR(G1H6(257),8,6)
call HGT_OLR(G2H4(42),1,1,4)
call HGT_invQ_OLR(G2H4(42),2,5,4)
call HGT_OLR(G2H4(42),6,15,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(137),mass5set(:,1),  & 
G1H4(117),G1H4(118),G1H4(129),G1H4(130),G1H4(135),G1H4(136),4)
  call HG1shiftOLR(G1H4(118),4,4)
  call Hotf_5pt_reduction(G2H6(70),RedSet_5(138),mass5set(:,1),  & 
G1H6(4),G1H6(69),G1H6(123),G1H6(7),G1H6(129),G1H6(111),6)
  call HG1shiftOLR(G1H6(69),8,6)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(66),mass5set(:,1),  & 
G1H4(143),G1H4(146),G1H4(147),G1H4(152),G1H4(153),G1H4(160),4)
  call HG1shiftOLR(G1H4(146),1,4)
  call Hloop_AQ_V(ntryL,G2H4(225),ex1(:),G2H2(1),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hotf_4pt_reduction(G2H4(47),RedSet_4(337),mass4set(:,1),  & 
G1H4(163),G1H4(164),G1H4(169),G1H4(170),G1H4(180),4)
  call HG1shiftOLR(G1H4(164),1,4)
  call Hloop_AQ_V(ntryL,G2H4(227),ex1(:),G2H2(4),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_AQ_V(ntryL,G2H4(228),ex1(:),G2H2(7),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hotf_4pt_reduction(G2H4(50),RedSet_4(338),mass4set(:,1),  & 
G1H4(181),G1H4(186),G1H4(187),G1H4(195),G1H4(196),4)
  call HG1shiftOLR(G1H4(186),5,4)
  call Hotf_5pt_reduction(G2H6(73),RedSet_5(68),mass5set(:,1),  & 
G1H6(10),G1H6(117),G1H6(15),G1H6(16),G1H6(23),G1H6(27),6)
  call HG1shiftOLR(G1H6(117),2,6)
  call Hloop_QA_V(ntryL,G2H4(233),ex2(:),G2H2(10),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hotf_4pt_reduction(G2H6(74),RedSet_4(339),mass4set(:,1),  & 
G1H6(28),G1H6(35),G1H6(40),G1H6(52),G1H6(64),6)
  call HG1shiftOLR(G1H6(35),2,6)
  call Hloop_QA_V(ntryL,G2H4(235),ex2(:),G2H2(13),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_QA_V(ntryL,G2H4(236),ex2(:),G2H2(18),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hotf_4pt_reduction(G2H6(75),RedSet_4(340),mass4set(:,1),  & 
G1H6(76),G1H6(88),G1H6(100),G1H6(112),G1H6(119),6)
  call HG1shiftOLR(G1H6(88),10,6)
  call Hotf_5pt_reduction(G2H6(82),RedSet_5(139),mass5set(:,1),  & 
G1H6(124),G1H6(131),G1H6(135),G1H6(136),G1H6(147),G1H6(148),6)
  call HG1shiftOLR(G1H6(131),8,6)
  call Hotf_5pt_reduction(G2H6(87),RedSet_5(33),mass5set(:,1),  & 
G1H6(159),G1H6(160),G1H6(167),G1H6(171),G1H6(172),G1H6(179),6)
  call HG1shiftOLR(G1H6(160),2,6)
  call Hloop_QV_A(ntryL,G1H6(2),ex5(:),G1H3(7),m3h2x3(:,59),heltab2x6(:,:,113))
  call Hloop_Q_A(ntryL,G1H3(7),55,0,G2H3(1),n2h3(37))
  call Hotf_4pt_reduction(G2H6(91),RedSet_4(13),mass4set(:,1),  & 
G1H6(184),G1H6(195),G1H6(196),G1H6(208),G1H6(219),6)
  call HG1shiftOLR(G1H6(195),2,6)
  call Hotf_4pt_reduction(G2H6(90),RedSet_4(14),mass4set(:,1),  & 
G1H6(220),G1H6(231),G1H6(232),G1H6(243),G1H6(244),6)
  call HG1shiftOLR(G1H6(231),10,6)
call HGT_w2_OLR(G1H6(3),1,1,6)
call HGT_w2_invQ_OLR(G1H6(3),2,5,6)
  call Hloop_QV_A(ntryL,G1H6(3),ex5(:),G1H3(8),m3h2x3(:,60),heltab2x6(:,:,114))
  call Hloop_Q_A(ntryL,G1H3(8),55,0,G2H3(4),n2h3(38))
  call Hotf_5pt_reduction(G2H6(86),RedSet_5(140),mass5set(:,1),  & 
G1H6(255),G1H6(256),G1H6(261),G1H6(262),G1H6(269),G1H6(272),6)
  call HG1shiftOLR(G1H6(256),16,6)
  call Hotf_5pt_reduction(G2H4(229),RedSet_5(35),mass5set(:,1),  & 
G1H4(197),G1H4(198),G1H4(199),G1H4(200),G1H4(201),G1H4(202),4)
  call HG1shiftOLR(G1H4(198),2,4)
  call Hloop_QW_A(ntryL,G1H6(5),ex4(:),G1H2(13),m3h3x2(:,55),heltab2x6(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(25),n2h2(73))
  call Hotf_4pt_reduction(G2H4(231),RedSet_4(13),mass4set(:,1),  & 
G1H4(203),G1H4(204),G1H4(205),G1H4(206),G1H4(207),4)
  call HG1shiftOLR(G1H4(204),2,4)
  call Hotf_4pt_reduction(G2H4(232),RedSet_4(25),mass4set(:,1),  & 
G1H4(208),G1H4(209),G1H4(210),G1H4(211),G1H4(212),4)
  call HG1shiftOLR(G1H4(209),18,4)
call HGT_w2_OLR(G1H6(6),1,1,6)
call HGT_w2_invQ_OLR(G1H6(6),2,5,6)
  call Hloop_QW_A(ntryL,G1H6(6),ex4(:),G1H2(14),m3h3x2(:,56),heltab2x6(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(30),n2h2(74))
  call Hotf_5pt_reduction(G2H6(83),RedSet_5(72),mass5set(:,1),  & 
G1H6(273),G1H6(278),G1H6(279),G1H6(2),G1H6(3),G1H6(5),6)
  call HG1shiftOLR(G1H6(278),1,6)
  call Hotf_4pt_reduction(G2H6(84),RedSet_4(337),mass4set(:,1),  & 
G1H6(6),G1H6(287),G1H6(288),G1H6(289),G1H6(290),6)
  call HG1shiftOLR(G1H6(287),1,6)
  call Hotf_4pt_reduction(G2H6(85),RedSet_4(341),mass4set(:,1),  & 
G1H6(291),G1H6(292),G1H6(293),G1H6(294),G1H6(295),6)
  call HG1shiftOLR(G1H6(292),9,6)
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(74),mass5set(:,1),  & 
G1H4(213),G1H4(214),G1H4(215),G1H4(216),G1H4(217),G1H4(218),4)
  call HG1shiftOLR(G1H4(214),2,4)
  call Hotf_4pt_reduction(G2H4(78),RedSet_4(339),mass4set(:,1),  & 
G1H4(219),G1H4(220),G1H4(221),G1H4(222),G1H4(223),4)
  call HG1shiftOLR(G1H4(220),2,4)
  call Hotf_4pt_reduction(G2H4(81),RedSet_4(342),mass4set(:,1),  & 
G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(225),6,4)
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(141),mass5set(:,1),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),4,4)
  call Hotf_5pt_reduction(G2H4(99),RedSet_5(38),mass5set(:,1),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),2,4)
  call Hloop_QV_A(ntryL,G1H4(2),ex5(:),G1H2(19),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(19),59,0,G2H2(37),n2h2(75))
  call Hotf_4pt_reduction(G2H4(103),RedSet_4(13),mass4set(:,1),  & 
G1H4(2),G1H4(241),G1H4(242),G1H4(243),G1H4(244),4)
  call HG1shiftOLR(G1H4(241),2,4)
  call Hotf_4pt_reduction(G2H4(102),RedSet_4(37),mass4set(:,1),  & 
G1H4(245),G1H4(246),G1H4(247),G1H4(248),G1H4(249),4)
  call HG1shiftOLR(G1H4(246),6,4)
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(3),ex5(:),G1H2(20),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(20),59,0,G2H2(42),n2h2(76))
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(142),mass5set(:,1),  & 
G1H4(3),G1H4(250),G1H4(251),G1H4(252),G1H4(253),G1H4(254),4)
  call HG1shiftOLR(G1H4(250),16,4)
  call Hloop_QV_A(ntryL,G1H4(5),ex3(:),G1H2(25),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(47),n2h2(77))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(6),ex3(:),G1H2(26),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(26),47,0,G2H2(52),n2h2(78))
  call Hotf_5pt_reduction(G2H6(88),RedSet_5(143),mass5set(:,1),  & 
G1H6(296),G1H6(297),G1H6(298),G1H6(299),G1H6(300),G1H6(301),6)
  call HG1shiftOLR(G1H6(297),4,6)
  call Hloop_QW_A(ntryL,G1H6(8),ex4(:),G1H2(31),m3h3x2(:,57),heltab2x6(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(31),59,0,G2H2(57),n2h2(79))
call HGT_w2_OLR(G1H6(9),1,1,6)
call HGT_w2_invQ_OLR(G1H6(9),2,5,6)
  call Hloop_QW_A(ntryL,G1H6(9),ex4(:),G1H2(32),m3h3x2(:,58),heltab2x6(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(32),59,0,G2H2(60),n2h2(80))
  call Hotf_5pt_reduction(G2H6(92),RedSet_5(144),mass5set(:,1),  & 
G1H6(8),G1H6(9),G1H6(302),G1H6(303),G1H6(304),G1H6(305),6)
  call HG1shiftOLR(G1H6(9),8,6)
  call Hloop_QV_A(ntryL,G1H6(11),ex3(:),G1H3(13),m3h2x3(:,61),heltab2x6(:,:,119))
  call Hloop_Q_A(ntryL,G1H3(13),55,0,G2H3(9),n2h3(39))
call HGT_w2_OLR(G1H6(12),1,1,6)
call HGT_w2_invQ_OLR(G1H6(12),2,5,6)
  call Hloop_QV_A(ntryL,G1H6(12),ex3(:),G1H3(14),m3h2x3(:,62),heltab2x6(:,:,120))
  call Hloop_Q_A(ntryL,G1H3(14),55,0,G2H3(14),n2h3(40))
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(145),mass5set(:,1),  & 
G1H4(5),G1H4(6),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(6),16,4)
  call Hloop_VA_Q(ntryL,G1H4(15),ex2(:),G1H2(37),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(37),47,0,G2H2(65),n2h2(81))
  call Hloop_VA_Q(ntryL,G1H4(28),ex2(:),G1H2(38),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(74),n2h2(82))
  call Hloop_VA_Q(ntryL,G1H4(17),ex2(:),G1H2(43),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(43),47,0,G2H2(77),n2h2(83))
  call Hotf_5pt_reduction(G2H4(108),RedSet_5(146),mass5set(:,1),  & 
G1H4(15),G1H4(28),G1H4(17),G1H4(259),G1H4(260),G1H4(261),4)
  call HG1shiftOLR(G1H4(28),16,4)
  call Hloop_VA_Q(ntryL,G1H4(27),ex2(:),G1H2(44),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(82),n2h2(84))
  call Hloop_VA_Q(ntryL,G1H4(29),ex2(:),G1H2(49),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(49),47,0,G2H2(87),n2h2(85))
  call Hotf_5pt_reduction(G2H6(93),RedSet_5(147),mass5set(:,1),  & 
G1H6(11),G1H6(12),G1H6(306),G1H6(307),G1H6(308),G1H6(309),6)
  call HG1shiftOLR(G1H6(12),8,6)
  call Hotf_5pt_reduction(G2H6(76),RedSet_5(148),mass5set(:,1),  & 
G1H6(310),G1H6(311),G1H6(312),G1H6(313),G1H6(314),G1H6(315),6)
  call HG1shiftOLR(G1H6(311),8,6)
  call Hloop_VQ_A(ntryL,G1H6(21),ex1(:),G1H3(19),m3h2x3(:,63),heltab2x6(:,:,121))
  call Hloop_Q_A(ntryL,G1H3(19),55,0,G2H3(19),n2h3(41))
  call Hloop_VQ_A(ntryL,G1H6(22),ex1(:),G1H3(20),m3h2x3(:,64),heltab2x6(:,:,122))
  call Hloop_Q_A(ntryL,G1H3(20),55,0,G2H3(22),n2h3(42))
  call Hloop_VQ_A(ntryL,G1H6(215),ex1(:),G1H3(25),m3h2x3(:,65),heltab2x6(:,:,123))
  call Hloop_Q_A(ntryL,G1H3(25),55,0,G2H3(29),n2h3(43))
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(149),mass5set(:,1),  & 
G1H4(27),G1H4(29),G1H4(262),G1H4(263),G1H4(264),G1H4(265),4)
  call HG1shiftOLR(G1H4(29),16,4)
  call Hloop_VQ_A(ntryL,G1H4(39),ex1(:),G1H2(50),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(50),47,0,G2H2(94),n2h2(86))
  call Hloop_VQ_A(ntryL,G1H4(52),ex1(:),G1H2(55),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(55),47,0,G2H2(103),n2h2(87))
  call Hloop_VQ_A(ntryL,G1H4(41),ex1(:),G1H2(56),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(56),47,0,G2H2(108),n2h2(88))
  call Hotf_5pt_reduction(G2H4(110),RedSet_5(150),mass5set(:,1),  & 
G1H4(39),G1H4(52),G1H4(41),G1H4(266),G1H4(267),G1H4(268),4)
  call HG1shiftOLR(G1H4(52),16,4)
  call Hloop_VQ_A(ntryL,G1H4(51),ex1(:),G1H2(61),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(61),47,0,G2H2(111),n2h2(89))
  call Hloop_VQ_A(ntryL,G1H4(53),ex1(:),G1H2(62),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(62),47,0,G2H2(114),n2h2(90))
  call Hotf_5pt_reduction(G2H6(94),RedSet_5(151),mass5set(:,1),  & 
G1H6(21),G1H6(22),G1H6(215),G1H6(316),G1H6(317),G1H6(318),6)
  call HG1shiftOLR(G1H6(22),8,6)
  call Hotf_5pt_reduction(G2H6(78),RedSet_5(152),mass5set(:,1),  & 
G1H6(319),G1H6(320),G1H6(321),G1H6(322),G1H6(323),G1H6(324),6)
  call HG1shiftOLR(G1H6(320),8,6)
  call Hloop_VA_Q(ntryL,G1H6(33),ex2(:),G1H3(26),m3h2x3(:,66),heltab2x6(:,:,124))
  call Hloop_A_Q(ntryL,G1H3(26),55,0,G2H3(32),n2h3(44))
  call Hloop_VA_Q(ntryL,G1H6(34),ex2(:),G1H3(31),m3h2x3(:,67),heltab2x6(:,:,125))
  call Hloop_A_Q(ntryL,G1H3(31),55,0,G2H3(37),n2h3(45))
  call Hloop_VA_Q(ntryL,G1H6(191),ex2(:),G1H3(32),m3h2x3(:,68),heltab2x6(:,:,126))
  call Hloop_A_Q(ntryL,G1H3(32),55,0,G2H3(40),n2h3(46))
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(153),mass5set(:,1),  & 
G1H4(51),G1H4(53),G1H4(269),G1H4(270),G1H4(271),G1H4(272),4)
  call HG1shiftOLR(G1H4(53),16,4)
  call Hloop_QV_A(ntryL,G1H4(63),ex3(:),G1H2(67),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(67),47,0,G2H2(117),n2h2(91))
  call Hloop_QV_A(ntryL,G1H4(64),ex3(:),G1H2(68),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(68),47,0,G2H2(120),n2h2(92))
  call Hloop_QV_A(ntryL,G1H4(65),ex3(:),G1H2(73),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(73),47,0,G2H2(123),n2h2(93))
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(154),mass5set(:,1),  & 
G1H6(33),G1H6(34),G1H6(191),G1H6(325),G1H6(326),G1H6(327),6)
  call HG1shiftOLR(G1H6(34),16,6)
  call Hloop_AW_Q(ntryL,G1H6(45),ex4(:),G1H2(74),m3h3x2(:,59),heltab2x6(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(74),47,0,G2H2(126),n2h2(94))
  call Hloop_AW_Q(ntryL,G1H6(46),ex4(:),G1H2(79),m3h3x2(:,60),heltab2x6(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(79),47,0,G2H2(129),n2h2(95))
  call Hloop_AW_Q(ntryL,G1H6(47),ex4(:),G1H2(80),m3h3x2(:,61),heltab2x6(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(80),47,0,G2H2(130),n2h2(96))
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(155),mass5set(:,1),  & 
G1H6(45),G1H6(46),G1H6(47),G1H6(328),G1H6(329),G1H6(330),6)
  call HG1shiftOLR(G1H6(46),8,6)
  call Hloop_AV_Q(ntryL,G1H6(57),ex5(:),G1H3(37),m3h2x3(:,69),heltab2x6(:,:,130))
  call Hloop_A_Q(ntryL,G1H3(37),55,0,G2H3(43),n2h3(47))
  call Hloop_AV_Q(ntryL,G1H6(58),ex5(:),G1H3(38),m3h2x3(:,70),heltab2x6(:,:,131))
  call Hloop_A_Q(ntryL,G1H3(38),55,0,G2H3(48),n2h3(48))
  call Hloop_AV_Q(ntryL,G1H6(59),ex5(:),G1H3(43),m3h2x3(:,71),heltab2x6(:,:,132))
  call Hloop_A_Q(ntryL,G1H3(43),55,0,G2H3(53),n2h3(49))
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(156),mass5set(:,1),  & 
G1H6(57),G1H6(58),G1H6(59),G1H6(331),G1H6(332),G1H6(333),6)
  call HG1shiftOLR(G1H6(58),16,6)
  call Hloop_QW_A(ntryL,G1H6(70),ex4(:),G1H2(85),m3h3x2(:,62),heltab2x6(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(85),47,0,G2H2(131),n2h2(97))
  call Hloop_QW_A(ntryL,G1H6(71),ex4(:),G1H2(86),m3h3x2(:,63),heltab2x6(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(86),47,0,G2H2(132),n2h2(98))
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(157),mass5set(:,1),  & 
G1H6(70),G1H6(71),G1H6(334),G1H6(335),G1H6(336),G1H6(337),6)
  call HG1shiftOLR(G1H6(71),8,6)
  call Hloop_QV_A(ntryL,G1H6(82),ex5(:),G1H3(44),m3h2x3(:,72),heltab2x6(:,:,135))
  call Hloop_Q_A(ntryL,G1H3(44),55,0,G2H3(54),n2h3(50))
  call Hloop_QV_A(ntryL,G1H6(83),ex5(:),G1H3(49),m3h2x3(:,73),heltab2x6(:,:,136))
  call Hloop_Q_A(ntryL,G1H3(49),55,0,G2H3(55),n2h3(51))
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(158),mass5set(:,1),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(273),G1H4(274),G1H4(275),4)
  call HG1shiftOLR(G1H4(64),16,4)
  call Hloop_AV_Q(ntryL,G1H4(75),ex3(:),G1H2(91),m3h2x2(:,110),heltab2x4(:,:,110))



end subroutine vamp_2

end module ol_vamp_2_ppwajj_udxawgg_1_/**/REALKIND
