
module ol_vamp_1_ppwajj_udxawgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwajj_udxawgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwajj_udxawgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwajj_udxawgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwajj_udxawgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwajj_udxawgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwajj_udxawgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,1),heltab2x96(:,:,1))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(1),n2h48(1))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,2),heltab2x96(:,:,2))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(2),n2h48(2))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,3),heltab2x96(:,:,3))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(3),n2h48(3))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4),h0tab(:,4),[32,4,1,2,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,4),heltab2x96(:,:,4))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(4),n2h48(4))
  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,5),heltab2x96(:,:,5))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(5),n2h48(5))
  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(6),h0tab(:,6),[32,2,1,4,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,6),heltab2x96(:,:,6))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(6),n2h48(6))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(7),h0tab(:,7),[32,8,1,2,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,7),heltab2x96(:,:,7))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(7),n2h48(7))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(8),h0tab(:,8),[32,4,2,1,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,8),heltab2x96(:,:,8))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(8),n2h48(8))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(9),h0tab(:,9),[32,4,8,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,9),heltab2x96(:,:,9))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(9),n2h48(9))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(10),h0tab(:,10),[32,4,16,2,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,10),heltab2x96(:,:,10))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(10),n2h48(10))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(11),h0tab(:,11),[32,2,1,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,11),heltab2x96(:,:,11))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(11),n2h48(11))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(12),h0tab(:,12),[32,2,1,8,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,12),heltab2x96(:,:,12))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(12),n2h48(12))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(13),h0tab(:,13),[32,8,4,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,13),heltab2x96(:,:,13))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(13),n2h48(13))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(14),h0tab(:,14),[32,4,2,1,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,14),heltab2x96(:,:,14))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(14),n2h48(14))
  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(15),h0tab(:,15),[32,4,8,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,15),heltab2x96(:,:,15))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(15),n2h48(15))
  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(16),h0tab(:,16),[32,4,16,1,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,16),heltab2x96(:,:,16))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(16),n2h48(16))
  Gcoeff(:)%j = (c(24)*M(2,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(17),h0tab(:,17),[32,2,1,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,17),heltab2x96(:,:,17))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(17),n2h48(17))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(18),h0tab(:,18),[32,2,1,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,18),heltab2x96(:,:,18))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(18),n2h48(18))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(19),h0tab(:,19),[32,1,2,4,8,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,19),heltab2x96(:,:,19))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(19),n2h48(19))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(20),h0tab(:,20),[32,1,2,4,16,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,20),heltab2x96(:,:,20))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(20),n2h48(20))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(21),h0tab(:,21),[32,1,2,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,21),heltab2x96(:,:,21))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(21),n2h48(21))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(22),h0tab(:,22),[32,1,2,8,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,22),heltab2x96(:,:,22))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(22),n2h48(22))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(23),h0tab(:,23),[32,1,2,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,23),heltab2x96(:,:,23))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(23),n2h48(23))
  Gcoeff(:)%j = (c(24)*M(1,:)%j-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(24),h0tab(:,24),[32,1,2,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,24),heltab2x96(:,:,24))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(24),n2h48(24))
  Gcoeff(:)%j = (c(11)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(25),h0tab(:,25),[32,4,1,16,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,25),heltab2x96(:,:,25))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(25),n2h48(25))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(26),h0tab(:,26),[32,2,8,4,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(26),m3h2x48(:,26),heltab2x96(:,:,26))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(27),h0tab(:,27),[32,2,16,1,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,27),heltab2x96(:,:,27))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(27),n2h48(26))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(28),h0tab(:,28),[32,1,4,8,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(28),m3h2x48(:,28),heltab2x96(:,:,28))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(29),h0tab(:,29),[32,1,4,16,8,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(29),m3h2x48(:,29),heltab2x96(:,:,29))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(30),h0tab(:,30),[32,1,4,8,16,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(30),m3h2x48(:,30),heltab2x96(:,:,30))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(31),h0tab(:,31),[32,4,2,16,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,31),heltab2x96(:,:,31))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(31),n2h48(27))
  Gcoeff(:)%j = (c(23)*M(2,:)%j+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(32),h0tab(:,32),[32,2,4,8,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(32),m3h2x48(:,32),heltab2x96(:,:,32))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(33),h0tab(:,33),[32,2,16,1,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,33),heltab2x96(:,:,33))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(33),n2h48(28))
  Gcoeff(:)%j = (c(23)*M(1,:)%j+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(34),h0tab(:,34),[32,1,8,4,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(34),m3h2x48(:,34),heltab2x96(:,:,34))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(35),h0tab(:,35),[32,1,8,16,4,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(35),m3h2x48(:,35),heltab2x96(:,:,35))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(36),h0tab(:,36),[32,1,8,4,16,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(36),m3h2x48(:,36),heltab2x96(:,:,36))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(37),h0tab(:,37),[32,1,16,2,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,37),heltab2x96(:,:,37))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(37),n2h48(29))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(38),h0tab(:,38),[32,1,16,8,4,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(38),m3h2x48(:,38),heltab2x96(:,:,38))
  Gcoeff(:)%j = (c(11)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(39),h0tab(:,39),[32,1,16,2,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,39),heltab2x96(:,:,39))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(39),n2h48(30))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(40),h0tab(:,40),[32,1,16,4,8,2],[0,0,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(40),m3h2x48(:,40),heltab2x96(:,:,40))
  call Hloop_QW_A(ntryL,G1H48(1),ex4(:),G1H16(1),m3h3x16(:,1),heltab2x48(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),40,0,G2H16(1),n2h16(1))
  call Hloop_AV_Q(ntryL,G1H48(2),ex3(:),G1H24(1),m3h2x24(:,1),heltab2x48(:,:,2))
  call Hloop_A_Q(ntryL,G1H24(1),36,0,G2H24(1),n2h24(1))
  call Hloop_AW_Q(ntryL,G1H48(3),ex4(:),G1H16(1),m3h3x16(:,2),heltab2x48(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),40,0,G2H16(2),n2h16(2))
  call Hloop_AV_Q(ntryL,G1H48(4),ex3(:),G1H24(1),m3h2x24(:,2),heltab2x48(:,:,4))
  call Hloop_A_Q(ntryL,G1H24(1),36,0,G2H24(2),n2h24(2))
  call Hloop_QA_V(ntryL,G1H48(5),ex2(:),G1H24(1),m3h2x24(:,3),heltab2x48(:,:,5))
  call Hloop_QA_V(ntryL,G1H48(6),ex2(:),G1H24(2),m3h2x24(:,4),heltab2x48(:,:,6))
  call Hloop_AW_Q(ntryL,G1H48(7),ex4(:),G1H16(1),m3h3x16(:,3),heltab2x48(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(1),40,0,G2H16(3),n2h16(3))
  call Hloop_QV_A(ntryL,G1H48(8),ex3(:),G1H24(3),m3h2x24(:,5),heltab2x48(:,:,8))
  call Hloop_Q_A(ntryL,G1H24(3),36,0,G2H24(3),n2h24(3))
  call Hloop_AV_Q(ntryL,G1H48(9),ex3(:),G1H24(3),m3h2x24(:,6),heltab2x48(:,:,9))
  call Hloop_A_Q(ntryL,G1H24(3),36,0,G2H24(4),n2h24(4))
  call Hloop_QV_A(ntryL,G1H48(10),ex3(:),G1H24(3),m3h2x24(:,7),heltab2x48(:,:,10))
  call Hloop_Q_A(ntryL,G1H24(3),36,0,G2H24(5),n2h24(5))
  call Hloop_QA_V(ntryL,G1H48(11),ex2(:),G1H24(3),m3h2x24(:,8),heltab2x48(:,:,11))
  call Hloop_QA_V(ntryL,G1H48(12),ex2(:),G1H24(4),m3h2x24(:,9),heltab2x48(:,:,12))
  call Hloop_QW_A(ntryL,G1H48(13),ex4(:),G1H16(1),m3h3x16(:,4),heltab2x48(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(1),40,0,G2H16(4),n2h16(4))
  call Hloop_QV_A(ntryL,G1H48(14),ex3(:),G1H24(5),m3h2x24(:,10),heltab2x48(:,:,14))
  call Hloop_Q_A(ntryL,G1H24(5),36,0,G2H24(6),n2h24(6))
  call Hloop_QV_A(ntryL,G1H48(15),ex3(:),G1H24(5),m3h2x24(:,11),heltab2x48(:,:,15))
  call Hloop_Q_A(ntryL,G1H24(5),36,0,G2H24(7),n2h24(7))
  call Hloop_AV_Q(ntryL,G1H48(16),ex3(:),G1H24(5),m3h2x24(:,12),heltab2x48(:,:,16))
  call Hloop_A_Q(ntryL,G1H24(5),36,0,G2H24(8),n2h24(8))
  call Hloop_QA_V(ntryL,G1H48(17),ex2(:),G1H24(5),m3h2x24(:,13),heltab2x48(:,:,17))
  call Hloop_QA_V(ntryL,G1H48(18),ex2(:),G1H24(6),m3h2x24(:,14),heltab2x48(:,:,18))
  call Hloop_AQ_V(ntryL,G1H48(19),ex1(:),G1H24(7),m3h2x24(:,15),heltab2x48(:,:,19))
  call Hloop_AQ_V(ntryL,G1H48(20),ex1(:),G1H24(8),m3h2x24(:,16),heltab2x48(:,:,20))
  call Hloop_AQ_V(ntryL,G1H48(21),ex1(:),G1H24(9),m3h2x24(:,17),heltab2x48(:,:,21))
  call Hloop_AQ_V(ntryL,G1H48(22),ex1(:),G1H24(10),m3h2x24(:,18),heltab2x48(:,:,22))
  call Hloop_AQ_V(ntryL,G1H48(23),ex1(:),G1H24(11),m3h2x24(:,19),heltab2x48(:,:,23))
  call Hloop_AQ_V(ntryL,G1H48(24),ex1(:),G1H24(12),m3h2x24(:,20),heltab2x48(:,:,24))
  call Hloop_AV_Q(ntryL,G1H48(25),ex3(:),G1H24(13),m3h2x24(:,21),heltab2x48(:,:,25))
  call Hloop_A_Q(ntryL,G1H24(13),36,0,G2H24(9),n2h24(9))
  call Hloop_VA_Q(ntryL,G1H48(26),ex2(:),G1H24(13),m3h2x24(:,22),heltab2x48(:,:,26))
  call Hloop_A_Q(ntryL,G1H24(13),34,0,G2H24(10),n2h24(10))
  call Hloop_QA_V(ntryL,G1H48(27),ex2(:),G1H24(13),m3h2x24(:,23),heltab2x48(:,:,27))
  call Hloop_VQ_A(ntryL,G1H48(28),ex1(:),G1H24(14),m3h2x24(:,24),heltab2x48(:,:,28))
  call Hloop_Q_A(ntryL,G1H24(14),33,0,G2H24(11),n2h24(11))
  call Hloop_VQ_A(ntryL,G1H48(29),ex1(:),G1H24(14),m3h2x24(:,25),heltab2x48(:,:,29))
  call Hloop_Q_A(ntryL,G1H24(14),33,0,G2H24(12),n2h24(12))
  call Hloop_VQ_A(ntryL,G1H48(30),ex1(:),G1H24(14),m3h2x24(:,26),heltab2x48(:,:,30))
  call Hloop_Q_A(ntryL,G1H24(14),33,0,G2H24(13),n2h24(13))
  call Hloop_QV_A(ntryL,G1H48(31),ex3(:),G1H24(14),m3h2x24(:,27),heltab2x48(:,:,31))
  call Hloop_Q_A(ntryL,G1H24(14),36,0,G2H24(14),n2h24(14))
  call Hloop_VA_Q(ntryL,G1H48(32),ex2(:),G1H24(14),m3h2x24(:,28),heltab2x48(:,:,32))
  call Hloop_A_Q(ntryL,G1H24(14),34,0,G2H24(15),n2h24(15))
  call Hloop_QA_V(ntryL,G1H48(33),ex2(:),G1H24(14),m3h2x24(:,29),heltab2x48(:,:,33))
  call Hloop_VQ_A(ntryL,G1H48(34),ex1(:),G1H24(15),m3h2x24(:,30),heltab2x48(:,:,34))
  call Hloop_Q_A(ntryL,G1H24(15),33,0,G2H24(16),n2h24(16))
  call Hloop_VQ_A(ntryL,G1H48(35),ex1(:),G1H24(15),m3h2x24(:,31),heltab2x48(:,:,35))
  call Hloop_Q_A(ntryL,G1H24(15),33,0,G2H24(17),n2h24(17))
  call Hloop_VQ_A(ntryL,G1H48(36),ex1(:),G1H24(15),m3h2x24(:,32),heltab2x48(:,:,36))
  call Hloop_Q_A(ntryL,G1H24(15),33,0,G2H24(18),n2h24(18))
  call Hloop_AQ_V(ntryL,G1H48(37),ex1(:),G1H24(15),m3h2x24(:,33),heltab2x48(:,:,37))
  call Hloop_VQ_A(ntryL,G1H48(38),ex1(:),G1H24(16),m3h2x24(:,34),heltab2x48(:,:,38))
  call Hloop_Q_A(ntryL,G1H24(16),33,0,G2H24(19),n2h24(19))
  call Hloop_AQ_V(ntryL,G1H48(39),ex1(:),G1H24(16),m3h2x24(:,35),heltab2x48(:,:,39))
  call Hloop_VQ_A(ntryL,G1H48(40),ex1(:),G1H24(17),m3h2x24(:,36),heltab2x48(:,:,40))
  call Hloop_Q_A(ntryL,G1H24(17),33,0,G2H24(20),n2h24(20))
  call Hloop_QA_V(ntryL,G2H16(1),ex2(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H24(1),ex1(:),G2H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hloop_AQ_V(ntryL,G2H24(2),ex1(:),G2H12(2),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_VQ_A(ntryL,G1H24(1),ex1(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_Q_A(ntryL,G1H12(1),35,0,G2H12(3),n2h12(1))
  call Hloop_VQ_A(ntryL,G1H24(2),ex1(:),G1H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_Q_A(ntryL,G1H12(1),35,0,G2H12(4),n2h12(2))
  call Hloop_AQ_V(ntryL,G2H16(3),ex1(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_QA_V(ntryL,G2H24(3),ex2(:),G2H12(5),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hotf_5pt_reduction(G2H24(4),RedSet_5(2),mass5set(:,1),  & 
G1H24(17),G1H24(1),G1H24(2),G1H24(18),G1H24(19),G1H24(20),24)
  call HG1shiftOLR(G1H24(1),16,24)
  call Hotf_5pt_reduction(G2H24(5),RedSet_5(3),mass5set(:,1),  & 
G1H24(21),G1H24(22),G1H24(23),G1H24(24),G1H24(25),G1H24(26),24)
  call HG1shiftOLR(G1H24(22),8,24)
  call Hloop_VQ_A(ntryL,G1H24(3),ex1(:),G1H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_Q_A(ntryL,G1H12(1),35,0,G2H12(6),n2h12(3))
  call Hloop_VQ_A(ntryL,G1H24(4),ex1(:),G1H12(1),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_Q_A(ntryL,G1H12(1),35,0,G2H12(7),n2h12(4))
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(4),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),16,16)
  call Hloop_QA_V(ntryL,G2H24(6),ex2(:),G2H12(8),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hotf_5pt_reduction(G2H24(7),RedSet_5(5),mass5set(:,1),  & 
G1H24(3),G1H24(4),G1H24(27),G1H24(28),G1H24(29),G1H24(30),24)
  call HG1shiftOLR(G1H24(4),16,24)
  call Hotf_5pt_reduction(G2H24(8),RedSet_5(6),mass5set(:,1),  & 
G1H24(31),G1H24(32),G1H24(33),G1H24(34),G1H24(35),G1H24(36),24)
  call HG1shiftOLR(G1H24(32),8,24)
  call Hloop_VQ_A(ntryL,G1H24(5),ex1(:),G1H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_Q_A(ntryL,G1H12(1),35,0,G2H12(9),n2h12(5))
  call Hloop_VQ_A(ntryL,G1H24(6),ex1(:),G1H12(1),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_Q_A(ntryL,G1H12(1),35,0,G2H12(10),n2h12(6))
  call Hloop_VA_Q(ntryL,G1H24(7),ex2(:),G1H12(1),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(11),n2h12(7))
  call Hloop_VA_Q(ntryL,G1H24(8),ex2(:),G1H12(1),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(12),n2h12(8))
  call Hloop_VA_Q(ntryL,G1H24(9),ex2(:),G1H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(13),n2h12(9))
  call Hloop_VA_Q(ntryL,G1H24(10),ex2(:),G1H12(1),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(14),n2h12(10))
  call Hloop_VA_Q(ntryL,G1H24(11),ex2(:),G1H12(1),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(15),n2h12(11))
  call Hloop_VA_Q(ntryL,G1H24(12),ex2(:),G1H12(1),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(16),n2h12(12))
  call Hloop_AQ_V(ntryL,G2H24(9),ex1(:),G2H12(17),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hotf_5pt_reduction(G2H24(10),RedSet_5(7),mass5set(:,1),  & 
G1H24(5),G1H24(6),G1H24(7),G1H24(8),G1H24(9),G1H24(10),24)
  call HG1shiftOLR(G1H24(6),16,24)
  call Hloop_UV_W(ntryL,G1H24(13),34,ex5(:),16,G2H12(18),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hotf_5pt_reduction(G2H24(11),RedSet_5(8),mass5set(:,1),  & 
G1H24(11),G1H24(12),G1H24(13),G1H24(37),G1H24(38),G1H24(39),24)
  call HG1shiftOLR(G1H24(12),16,24)
  call Hotf_5pt_reduction(G2H24(12),RedSet_5(9),mass5set(:,1),  & 
G1H24(40),G1H24(41),G1H24(42),G1H24(43),G1H24(44),G1H24(45),24)
  call HG1shiftOLR(G1H24(41),2,24)
  call Hotf_5pt_reduction(G2H24(13),RedSet_5(8),mass5set(:,1),  & 
G1H24(46),G1H24(47),G1H24(48),G1H24(49),G1H24(50),G1H24(51),24)
  call HG1shiftOLR(G1H24(47),2,24)
  call Hloop_QA_V(ntryL,G2H24(14),ex2(:),G2H12(19),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hotf_5pt_reduction(G2H24(15),RedSet_5(10),mass5set(:,1),  & 
G1H24(52),G1H24(53),G1H24(54),G1H24(55),G1H24(56),G1H24(57),24)
  call HG1shiftOLR(G1H24(53),16,24)
  call Hloop_UV_W(ntryL,G1H24(14),34,ex5(:),16,G2H12(20),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hotf_5pt_reduction(G2H24(16),RedSet_5(11),mass5set(:,1),  & 
G1H24(14),G1H24(58),G1H24(59),G1H24(60),G1H24(61),G1H24(62),24)
  call HG1shiftOLR(G1H24(58),16,24)
  call Hotf_5pt_reduction(G2H24(17),RedSet_5(12),mass5set(:,1),  & 
G1H24(63),G1H24(64),G1H24(65),G1H24(66),G1H24(67),G1H24(68),24)
  call HG1shiftOLR(G1H24(64),2,24)
  call Hotf_5pt_reduction(G2H24(18),RedSet_5(11),mass5set(:,1),  & 
G1H24(69),G1H24(70),G1H24(71),G1H24(72),G1H24(73),G1H24(74),24)
  call HG1shiftOLR(G1H24(70),2,24)
  call Hloop_UV_W(ntryL,G1H24(15),33,ex5(:),16,G2H12(21),m3h2x12(:,21),heltab2x24(:,:,21))
  call Hotf_5pt_reduction(G2H24(19),RedSet_5(13),mass5set(:,1),  & 
G1H24(15),G1H24(75),G1H24(76),G1H24(77),G1H24(78),G1H24(79),24)
  call HG1shiftOLR(G1H24(75),2,24)
  call Hloop_UV_W(ntryL,G1H24(16),33,ex5(:),16,G2H12(22),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hotf_5pt_reduction(G2H24(20),RedSet_5(14),mass5set(:,1),  & 
G1H24(16),G1H24(80),G1H24(81),G1H24(82),G1H24(83),G1H24(84),24)
  call HG1shiftOLR(G1H24(80),2,24)
  call Hloop_AV_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(3),n2h8(1))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-16,0,G2H16(1),n2h16(5))
  call Hloop_QV_A(ntryL,G2H16(1),ex5(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AV_Q(ntryL,G1H16(4),ex3(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(5),n2h8(2))
  call Hloop_AV_Q(ntryL,G1H16(5),ex3(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(6),n2h8(3))
  call Hloop_AV_Q(ntryL,G1H16(6),ex3(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(7),n2h8(4))
  call Hloop_AW_Q(ntryL,G1H24(17),ex4(:),G1H8(1),m3h3x8(:,1),heltab2x24(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(8),n2h8(5))
call HGT_OLR(G1H24(1),1,1,24)
call HGT_invQ_OLR(G1H24(1),2,5,24)
  call Hloop_Q_A(ntryL,G1H24(1),-16,0,G2H24(1),n2h24(21))
  call Hloop_QV_A(ntryL,G2H24(1),ex5(:),G2H12(23),m3h2x12(:,23),heltab2x24(:,:,24))
  call Hloop_AW_Q(ntryL,G1H24(18),ex4(:),G1H8(1),m3h3x8(:,2),heltab2x24(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(9),n2h8(6))
  call Hloop_AW_Q(ntryL,G1H24(19),ex4(:),G1H8(1),m3h3x8(:,3),heltab2x24(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(10),n2h8(7))
  call Hloop_AW_Q(ntryL,G1H24(20),ex4(:),G1H8(1),m3h3x8(:,4),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(11),n2h8(8))
  call Hloop_QV_A(ntryL,G1H24(21),ex5(:),G1H12(1),m3h2x12(:,24),heltab2x24(:,:,28))
  call Hloop_Q_A(ntryL,G1H12(1),52,0,G2H12(24),n2h12(13))
call HGT_OLR(G1H24(22),1,1,24)
call HGT_invQ_OLR(G1H24(22),2,5,24)
  call Hloop_A_Q(ntryL,G1H24(22),-8,0,G2H24(2),n2h24(22))
  call Hloop_AW_Q(ntryL,G2H24(2),ex4(:),G2H8(12),m3h3x8(:,5),heltab2x24(:,:,29))
  call Hloop_QV_A(ntryL,G1H24(24),ex5(:),G1H12(1),m3h2x12(:,25),heltab2x24(:,:,30))
  call Hloop_Q_A(ntryL,G1H12(1),52,0,G2H12(25),n2h12(14))
  call Hloop_QV_A(ntryL,G1H24(25),ex5(:),G1H12(1),m3h2x12(:,26),heltab2x24(:,:,31))
  call Hloop_Q_A(ntryL,G1H12(1),52,0,G2H12(26),n2h12(15))
  call Hloop_QV_A(ntryL,G1H24(26),ex5(:),G1H12(1),m3h2x12(:,27),heltab2x24(:,:,32))
  call Hloop_Q_A(ntryL,G1H12(1),52,0,G2H12(27),n2h12(16))
  call Hloop_QV_A(ntryL,G1H16(7),ex3(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(13),n2h8(9))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(8),-16,0,G2H16(2),n2h16(6))
  call Hloop_AV_Q(ntryL,G2H16(2),ex5(:),G2H8(14),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_QV_A(ntryL,G1H16(10),ex3(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(15),n2h8(10))
  call Hloop_QV_A(ntryL,G1H16(11),ex3(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(16),n2h8(11))
  call Hloop_QV_A(ntryL,G1H16(12),ex3(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(17),n2h8(12))
  call Hloop_QW_A(ntryL,G1H24(3),ex4(:),G1H8(1),m3h3x8(:,6),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(18),n2h8(13))
call HGT_OLR(G1H24(4),1,1,24)
call HGT_invQ_OLR(G1H24(4),2,5,24)
  call Hloop_A_Q(ntryL,G1H24(4),-16,0,G2H24(3),n2h24(23))
  call Hloop_AV_Q(ntryL,G2H24(3),ex5(:),G2H12(28),m3h2x12(:,28),heltab2x24(:,:,34))
  call Hloop_QW_A(ntryL,G1H24(28),ex4(:),G1H8(1),m3h3x8(:,7),heltab2x24(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(19),n2h8(14))
  call Hloop_QW_A(ntryL,G1H24(29),ex4(:),G1H8(1),m3h3x8(:,8),heltab2x24(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(20),n2h8(15))
  call Hloop_QW_A(ntryL,G1H24(30),ex4(:),G1H8(1),m3h3x8(:,9),heltab2x24(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(21),n2h8(16))
  call Hloop_AV_Q(ntryL,G1H24(31),ex5(:),G1H12(1),m3h2x12(:,29),heltab2x24(:,:,38))
  call Hloop_A_Q(ntryL,G1H12(1),52,0,G2H12(29),n2h12(17))
call HGT_OLR(G1H24(32),1,1,24)
call HGT_invQ_OLR(G1H24(32),2,5,24)
  call Hloop_Q_A(ntryL,G1H24(32),-8,0,G2H24(4),n2h24(24))
  call Hloop_QW_A(ntryL,G2H24(4),ex4(:),G2H8(22),m3h3x8(:,10),heltab2x24(:,:,39))
  call Hloop_AV_Q(ntryL,G1H24(34),ex5(:),G1H12(1),m3h2x12(:,30),heltab2x24(:,:,40))
  call Hloop_A_Q(ntryL,G1H12(1),52,0,G2H12(30),n2h12(18))
  call Hloop_AV_Q(ntryL,G1H24(35),ex5(:),G1H12(1),m3h2x12(:,31),heltab2x24(:,:,41))
  call Hloop_A_Q(ntryL,G1H12(1),52,0,G2H12(31),n2h12(19))
  call Hloop_AV_Q(ntryL,G1H24(36),ex5(:),G1H12(1),m3h2x12(:,32),heltab2x24(:,:,42))
  call Hloop_A_Q(ntryL,G1H12(1),52,0,G2H12(32),n2h12(20))
  call Hloop_AW_Q(ntryL,G1H24(5),ex4(:),G1H8(1),m3h3x8(:,11),heltab2x24(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(23),n2h8(17))
call HGT_raise_alpha_OLR(G1H24(6),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(6),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(6),-16,ex5(:),16,G2H12(33),m3h2x12(:,33),heltab2x24(:,:,44))
call signflip_OLR(G2H12(33))
  call Hloop_AW_Q(ntryL,G1H24(8),ex4(:),G1H8(1),m3h3x8(:,12),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(24),n2h8(18))
  call Hloop_AW_Q(ntryL,G1H24(9),ex4(:),G1H8(1),m3h3x8(:,13),heltab2x24(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(25),n2h8(19))
  call Hloop_AW_Q(ntryL,G1H24(10),ex4(:),G1H8(1),m3h3x8(:,14),heltab2x24(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(26),n2h8(20))
  call Hloop_QV_A(ntryL,G1H24(11),ex3(:),G1H12(1),m3h2x12(:,34),heltab2x24(:,:,48))
  call Hloop_Q_A(ntryL,G1H12(1),37,0,G2H12(34),n2h12(21))
call HGT_raise_alpha_OLR(G1H24(12),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(12),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(12),-16,ex5(:),16,G2H12(35),m3h2x12(:,35),heltab2x24(:,:,49))
call signflip_OLR(G2H12(35))
  call Hloop_QV_A(ntryL,G1H24(37),ex3(:),G1H12(1),m3h2x12(:,36),heltab2x24(:,:,50))
  call Hloop_Q_A(ntryL,G1H12(1),37,0,G2H12(36),n2h12(22))
  call Hloop_QV_A(ntryL,G1H24(38),ex3(:),G1H12(1),m3h2x12(:,37),heltab2x24(:,:,51))
  call Hloop_Q_A(ntryL,G1H12(1),37,0,G2H12(37),n2h12(23))
  call Hloop_QV_A(ntryL,G1H24(39),ex3(:),G1H12(1),m3h2x12(:,38),heltab2x24(:,:,52))
  call Hloop_Q_A(ntryL,G1H12(1),37,0,G2H12(38),n2h12(24))
  call Hloop_QV_A(ntryL,G1H24(40),ex3(:),G1H12(1),m3h2x12(:,39),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G1H12(1),37,0,G2H12(39),n2h12(25))
call HGT_raise_alpha_OLR(G1H24(41),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(41),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(41),ex2(:),G1H12(1),m3h2x12(:,40),heltab2x24(:,:,54))
  call Hloop_QV_A(ntryL,G1H24(43),ex3(:),G1H12(2),m3h2x12(:,41),heltab2x24(:,:,55))
  call Hloop_Q_A(ntryL,G1H12(2),37,0,G2H12(40),n2h12(26))
  call Hloop_QV_A(ntryL,G1H24(44),ex3(:),G1H12(2),m3h2x12(:,42),heltab2x24(:,:,56))
  call Hloop_Q_A(ntryL,G1H12(2),37,0,G2H12(41),n2h12(27))
  call Hloop_QV_A(ntryL,G1H24(45),ex3(:),G1H12(2),m3h2x12(:,43),heltab2x24(:,:,57))
  call Hloop_Q_A(ntryL,G1H12(2),37,0,G2H12(42),n2h12(28))
  call Hloop_QV_A(ntryL,G1H24(46),ex3(:),G1H12(2),m3h2x12(:,44),heltab2x24(:,:,58))
  call Hloop_Q_A(ntryL,G1H12(2),37,0,G2H12(43),n2h12(29))
call HGT_raise_alpha_OLR(G1H24(47),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(47),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(47),ex2(:),G1H12(2),m3h2x12(:,45),heltab2x24(:,:,59))
  call Hloop_QV_A(ntryL,G1H24(49),ex3(:),G1H12(3),m3h2x12(:,46),heltab2x24(:,:,60))
  call Hloop_Q_A(ntryL,G1H12(3),37,0,G2H12(44),n2h12(30))
  call Hloop_QV_A(ntryL,G1H24(50),ex3(:),G1H12(3),m3h2x12(:,47),heltab2x24(:,:,61))
  call Hloop_Q_A(ntryL,G1H12(3),37,0,G2H12(45),n2h12(31))
  call Hloop_QV_A(ntryL,G1H24(51),ex3(:),G1H12(3),m3h2x12(:,48),heltab2x24(:,:,62))
  call Hloop_Q_A(ntryL,G1H12(3),37,0,G2H12(46),n2h12(32))
  call Hloop_AV_Q(ntryL,G1H24(52),ex3(:),G1H12(3),m3h2x12(:,49),heltab2x24(:,:,63))
  call Hloop_A_Q(ntryL,G1H12(3),38,0,G2H12(47),n2h12(33))
call HGT_raise_alpha_OLR(G1H24(53),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(53),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(53),-16,ex5(:),16,G2H12(48),m3h2x12(:,50),heltab2x24(:,:,64))
call signflip_OLR(G2H12(48))
  call Hloop_AV_Q(ntryL,G1H24(55),ex3(:),G1H12(3),m3h2x12(:,51),heltab2x24(:,:,65))
  call Hloop_A_Q(ntryL,G1H12(3),38,0,G2H12(49),n2h12(34))
  call Hloop_AV_Q(ntryL,G1H24(56),ex3(:),G1H12(3),m3h2x12(:,52),heltab2x24(:,:,66))
  call Hloop_A_Q(ntryL,G1H12(3),38,0,G2H12(50),n2h12(35))
  call Hloop_AV_Q(ntryL,G1H24(57),ex3(:),G1H12(3),m3h2x12(:,53),heltab2x24(:,:,67))
  call Hloop_A_Q(ntryL,G1H12(3),38,0,G2H12(51),n2h12(36))
  call Hloop_QW_A(ntryL,G1H24(14),ex4(:),G1H8(1),m3h3x8(:,15),heltab2x24(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(27),n2h8(21))
call HGT_raise_alpha_OLR(G1H24(58),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(58),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(58),-16,ex5(:),16,G2H12(52),m3h2x12(:,54),heltab2x24(:,:,69))
call signflip_OLR(G2H12(52))
  call Hloop_QW_A(ntryL,G1H24(60),ex4(:),G1H8(1),m3h3x8(:,16),heltab2x24(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(28),n2h8(22))
  call Hloop_QW_A(ntryL,G1H24(61),ex4(:),G1H8(1),m3h3x8(:,17),heltab2x24(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(29),n2h8(23))
  call Hloop_QW_A(ntryL,G1H24(62),ex4(:),G1H8(1),m3h3x8(:,18),heltab2x24(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(30),n2h8(24))
  call Hloop_QW_A(ntryL,G1H24(63),ex4(:),G1H8(1),m3h3x8(:,19),heltab2x24(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(31),n2h8(25))
call HGT_raise_alpha_OLR(G1H24(64),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(64),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(64),ex2(:),G1H12(3),m3h2x12(:,55),heltab2x24(:,:,74))
  call Hloop_QW_A(ntryL,G1H24(66),ex4(:),G1H8(1),m3h3x8(:,20),heltab2x24(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(32),n2h8(26))
  call Hloop_QW_A(ntryL,G1H24(67),ex4(:),G1H8(1),m3h3x8(:,21),heltab2x24(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(33),n2h8(27))
  call Hloop_QW_A(ntryL,G1H24(68),ex4(:),G1H8(1),m3h3x8(:,22),heltab2x24(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(34),n2h8(28))
  call Hloop_QW_A(ntryL,G1H24(69),ex4(:),G1H8(1),m3h3x8(:,23),heltab2x24(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(35),n2h8(29))
call HGT_raise_alpha_OLR(G1H24(70),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(70),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(70),ex2(:),G1H12(4),m3h2x12(:,56),heltab2x24(:,:,79))
  call Hloop_QW_A(ntryL,G1H24(72),ex4(:),G1H8(1),m3h3x8(:,24),heltab2x24(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(36),n2h8(30))
  call Hloop_QW_A(ntryL,G1H24(73),ex4(:),G1H8(1),m3h3x8(:,25),heltab2x24(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(37),n2h8(31))
  call Hloop_QW_A(ntryL,G1H24(74),ex4(:),G1H8(1),m3h3x8(:,26),heltab2x24(:,:,82))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(38),n2h8(32))
  call Hloop_QV_A(ntryL,G1H24(15),ex5(:),G1H12(5),m3h2x12(:,57),heltab2x24(:,:,83))
  call Hloop_Q_A(ntryL,G1H12(5),49,0,G2H12(53),n2h12(37))
call HGT_raise_alpha_OLR(G1H24(75),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(75),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(75),ex2(:),G1H12(5),m3h2x12(:,58),heltab2x24(:,:,84))
  call Hloop_QV_A(ntryL,G1H24(77),ex5(:),G1H12(6),m3h2x12(:,59),heltab2x24(:,:,85))
  call Hloop_Q_A(ntryL,G1H12(6),49,0,G2H12(54),n2h12(38))
  call Hloop_QV_A(ntryL,G1H24(78),ex5(:),G1H12(6),m3h2x12(:,60),heltab2x24(:,:,86))
  call Hloop_Q_A(ntryL,G1H12(6),49,0,G2H12(55),n2h12(39))
  call Hloop_QV_A(ntryL,G1H24(79),ex5(:),G1H12(6),m3h2x12(:,61),heltab2x24(:,:,87))
  call Hloop_Q_A(ntryL,G1H12(6),49,0,G2H12(56),n2h12(40))
  call Hloop_QV_A(ntryL,G1H24(16),ex5(:),G1H12(6),m3h2x12(:,62),heltab2x24(:,:,88))
  call Hloop_Q_A(ntryL,G1H12(6),49,0,G2H12(57),n2h12(41))
call HGT_raise_alpha_OLR(G1H24(80),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(80),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(80),ex2(:),G1H12(6),m3h2x12(:,63),heltab2x24(:,:,89))
  call Hloop_QV_A(ntryL,G1H24(82),ex5(:),G1H12(7),m3h2x12(:,64),heltab2x24(:,:,90))
  call Hloop_Q_A(ntryL,G1H12(7),49,0,G2H12(58),n2h12(42))
  call Hloop_QV_A(ntryL,G1H24(83),ex5(:),G1H12(7),m3h2x12(:,65),heltab2x24(:,:,91))
  call Hloop_Q_A(ntryL,G1H12(7),49,0,G2H12(59),n2h12(43))
  call Hloop_QV_A(ntryL,G1H24(84),ex5(:),G1H12(7),m3h2x12(:,66),heltab2x24(:,:,92))
  call Hloop_Q_A(ntryL,G1H12(7),49,0,G2H12(60),n2h12(44))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(15),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),16,8)
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(16),mass5set(:,1),  & 
G1H12(7),G1H12(8),G1H12(9),G1H12(10),G1H12(11),G1H12(12),12)
  call HG1shiftOLR(G1H12(8),16,12)
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(16),mass5set(:,1),  & 
G1H12(13),G1H12(14),G1H12(15),G1H12(16),G1H12(17),G1H12(18),12)
  call HG1shiftOLR(G1H12(14),8,12)
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(17),mass5set(:,1),  & 
G1H12(19),G1H12(20),G1H12(21),G1H12(22),G1H12(23),G1H12(24),12)
  call HG1shiftOLR(G1H12(20),16,12)
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(17),mass5set(:,1),  & 
G1H12(25),G1H12(26),G1H12(27),G1H12(28),G1H12(29),G1H12(30),12)
  call HG1shiftOLR(G1H12(26),8,12)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(18),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H12(5),RedSet_5(19),mass5set(:,1),  & 
G1H12(31),G1H12(32),G1H12(33),G1H12(34),G1H12(35),G1H12(36),12)
  call HG1shiftOLR(G1H12(32),16,12)
  call Hotf_5pt_reduction(G2H12(6),RedSet_5(20),mass5set(:,1),  & 
G1H12(37),G1H12(38),G1H12(39),G1H12(40),G1H12(41),G1H12(42),12)
  call HG1shiftOLR(G1H12(38),16,12)
  call Hotf_5pt_reduction(G2H12(7),RedSet_5(20),mass5set(:,1),  & 
G1H12(43),G1H12(44),G1H12(45),G1H12(46),G1H12(47),G1H12(48),12)
  call HG1shiftOLR(G1H12(44),4,12)
  call Hotf_5pt_reduction(G2H12(8),RedSet_5(19),mass5set(:,1),  & 
G1H12(49),G1H12(50),G1H12(51),G1H12(52),G1H12(53),G1H12(54),12)
  call HG1shiftOLR(G1H12(50),8,12)
  call Hotf_5pt_reduction(G2H12(9),RedSet_5(21),mass5set(:,1),  & 
G1H12(55),G1H12(56),G1H12(57),G1H12(58),G1H12(59),G1H12(60),12)
  call HG1shiftOLR(G1H12(56),8,12)
  call Hotf_5pt_reduction(G2H12(10),RedSet_5(21),mass5set(:,1),  & 
G1H12(61),G1H12(62),G1H12(63),G1H12(64),G1H12(65),G1H12(66),12)
  call HG1shiftOLR(G1H12(62),4,12)
  call Hotf_5pt_reduction(G2H12(11),RedSet_5(22),mass5set(:,1),  & 
G1H12(67),G1H12(68),G1H12(69),G1H12(70),G1H12(71),G1H12(72),12)
  call HG1shiftOLR(G1H12(68),16,12)
  call Hotf_5pt_reduction(G2H12(12),RedSet_5(22),mass5set(:,1),  & 
G1H12(73),G1H12(74),G1H12(75),G1H12(76),G1H12(77),G1H12(78),12)
  call HG1shiftOLR(G1H12(74),8,12)
  call Hotf_5pt_reduction(G2H12(13),RedSet_5(23),mass5set(:,1),  & 
G1H12(79),G1H12(80),G1H12(81),G1H12(82),G1H12(83),G1H12(84),12)
  call HG1shiftOLR(G1H12(80),16,12)
  call Hotf_5pt_reduction(G2H12(14),RedSet_5(23),mass5set(:,1),  & 
G1H12(85),G1H12(86),G1H12(87),G1H12(88),G1H12(89),G1H12(90),12)
  call HG1shiftOLR(G1H12(86),4,12)
  call Hotf_5pt_reduction(G2H12(15),RedSet_5(24),mass5set(:,1),  & 
G1H12(91),G1H12(92),G1H12(93),G1H12(94),G1H12(95),G1H12(96),12)
  call HG1shiftOLR(G1H12(92),8,12)
  call Hotf_5pt_reduction(G2H12(16),RedSet_5(24),mass5set(:,1),  & 
G1H12(97),G1H12(98),G1H12(99),G1H12(100),G1H12(101),G1H12(102),12)
  call HG1shiftOLR(G1H12(98),4,12)
  call Hotf_5pt_reduction(G2H12(17),RedSet_5(25),mass5set(:,1),  & 
G1H12(103),G1H12(104),G1H12(105),G1H12(106),G1H12(107),G1H12(108),12)
  call HG1shiftOLR(G1H12(104),8,12)
  call Hotf_5pt_reduction(G2H12(18),RedSet_5(26),mass5set(:,1),  & 
G1H12(109),G1H12(110),G1H12(111),G1H12(112),G1H12(113),G1H12(114),12)
  call HG1shiftOLR(G1H12(110),8,12)
  call Hotf_5pt_reduction(G2H12(19),RedSet_5(27),mass5set(:,1),  & 
G1H12(115),G1H12(116),G1H12(117),G1H12(118),G1H12(119),G1H12(120),12)
  call HG1shiftOLR(G1H12(116),8,12)
  call Hotf_5pt_reduction(G2H12(20),RedSet_5(26),mass5set(:,1),  & 
G1H12(121),G1H12(122),G1H12(123),G1H12(124),G1H12(125),G1H12(126),12)
  call HG1shiftOLR(G1H12(122),4,12)
  call Hotf_5pt_reduction(G2H12(21),RedSet_5(28),mass5set(:,1),  & 
G1H12(127),G1H12(128),G1H12(129),G1H12(130),G1H12(131),G1H12(132),12)
  call HG1shiftOLR(G1H12(128),8,12)
  call Hotf_5pt_reduction(G2H12(22),RedSet_5(28),mass5set(:,1),  & 
G1H12(133),G1H12(134),G1H12(135),G1H12(136),G1H12(137),G1H12(138),12)
  call HG1shiftOLR(G1H12(134),4,12)
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(6),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(7),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(8),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(10),ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(11),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_V(ntryL,G2H12(24),ex2(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_QA_V(ntryL,G2H12(26),ex2(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_QA_V(ntryL,G2H12(27),ex2(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_QA_V(ntryL,G2H8(13),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(16),ex2(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_V(ntryL,G2H8(17),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(18),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(20),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(21),ex2(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_V(ntryL,G2H12(29),ex1(:),G2H6(4),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_AQ_V(ntryL,G2H12(31),ex1(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_AQ_V(ntryL,G2H12(32),ex1(:),G2H6(6),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(7),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),16,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(29),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(30),mass5set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hotf_5pt_reduction(G2H12(34),RedSet_5(8),mass5set(:,1),  & 
G1H12(139),G1H12(140),G1H12(141),G1H12(142),G1H12(143),G1H12(144),12)
  call HG1shiftOLR(G1H12(140),16,12)
  call Hotf_5pt_reduction(G2H12(37),RedSet_5(31),mass5set(:,1),  & 
G1H12(145),G1H12(146),G1H12(147),G1H12(148),G1H12(149),G1H12(150),12)
  call HG1shiftOLR(G1H12(146),16,12)
  call Hotf_5pt_reduction(G2H12(38),RedSet_5(32),mass5set(:,1),  & 
G1H12(151),G1H12(152),G1H12(153),G1H12(154),G1H12(155),G1H12(156),12)
  call HG1shiftOLR(G1H12(152),16,12)
  call Hotf_5pt_reduction(G2H12(39),RedSet_5(9),mass5set(:,1),  & 
G1H12(157),G1H12(158),G1H12(159),G1H12(160),G1H12(161),G1H12(162),12)
  call HG1shiftOLR(G1H12(158),2,12)
  call Hotf_5pt_reduction(G2H12(41),RedSet_5(33),mass5set(:,1),  & 
G1H12(163),G1H12(164),G1H12(165),G1H12(166),G1H12(167),G1H12(168),12)
  call HG1shiftOLR(G1H12(164),2,12)
  call Hotf_5pt_reduction(G2H12(42),RedSet_5(34),mass5set(:,1),  & 
G1H12(169),G1H12(170),G1H12(171),G1H12(172),G1H12(173),G1H12(174),12)
  call HG1shiftOLR(G1H12(170),2,12)
  call Hotf_5pt_reduction(G2H12(43),RedSet_5(8),mass5set(:,1),  & 
G1H12(175),G1H12(176),G1H12(177),G1H12(178),G1H12(179),G1H12(180),12)
  call HG1shiftOLR(G1H12(176),2,12)
  call Hotf_5pt_reduction(G2H12(45),RedSet_5(35),mass5set(:,1),  & 
G1H12(181),G1H12(182),G1H12(183),G1H12(184),G1H12(185),G1H12(186),12)
  call HG1shiftOLR(G1H12(182),2,12)
  call Hotf_5pt_reduction(G2H12(46),RedSet_5(34),mass5set(:,1),  & 
G1H12(187),G1H12(188),G1H12(189),G1H12(190),G1H12(191),G1H12(192),12)
  call HG1shiftOLR(G1H12(188),2,12)
  call Hotf_5pt_reduction(G2H12(47),RedSet_5(10),mass5set(:,1),  & 
G1H12(193),G1H12(194),G1H12(195),G1H12(196),G1H12(197),G1H12(198),12)
  call HG1shiftOLR(G1H12(194),16,12)
  call Hotf_5pt_reduction(G2H12(50),RedSet_5(29),mass5set(:,1),  & 
G1H12(199),G1H12(200),G1H12(201),G1H12(202),G1H12(203),G1H12(204),12)
  call HG1shiftOLR(G1H12(200),16,12)
  call Hotf_5pt_reduction(G2H12(51),RedSet_5(36),mass5set(:,1),  & 
G1H12(205),G1H12(206),G1H12(207),G1H12(208),G1H12(209),G1H12(210),12)
  call HG1shiftOLR(G1H12(206),16,12)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(11),mass5set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),16,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(31),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),16,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(37),mass5set(:,1),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),16,8)
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(12),mass5set(:,1),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),2,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(38),mass5set(:,1),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),2,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(39),mass5set(:,1),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),2,8)
  call Hotf_5pt_reduction(G2H8(35),RedSet_5(11),mass5set(:,1),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),2,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(35),mass5set(:,1),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),2,8)
  call Hotf_5pt_reduction(G2H8(38),RedSet_5(39),mass5set(:,1),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),2,8)
  call Hotf_5pt_reduction(G2H12(53),RedSet_5(13),mass5set(:,1),  & 
G1H12(211),G1H12(212),G1H12(213),G1H12(214),G1H12(215),G1H12(216),12)
  call HG1shiftOLR(G1H12(212),2,12)
  call Hotf_5pt_reduction(G2H12(55),RedSet_5(38),mass5set(:,1),  & 
G1H12(217),G1H12(218),G1H12(219),G1H12(220),G1H12(221),G1H12(222),12)
  call HG1shiftOLR(G1H12(218),2,12)
  call Hotf_5pt_reduction(G2H12(56),RedSet_5(40),mass5set(:,1),  & 
G1H12(223),G1H12(224),G1H12(225),G1H12(226),G1H12(227),G1H12(228),12)
  call HG1shiftOLR(G1H12(224),2,12)
  call Hotf_5pt_reduction(G2H12(57),RedSet_5(14),mass5set(:,1),  & 
G1H12(229),G1H12(230),G1H12(231),G1H12(232),G1H12(233),G1H12(234),12)
  call HG1shiftOLR(G1H12(230),2,12)
  call Hotf_5pt_reduction(G2H12(59),RedSet_5(33),mass5set(:,1),  & 
G1H12(235),G1H12(236),G1H12(237),G1H12(238),G1H12(239),G1H12(240),12)
  call HG1shiftOLR(G1H12(236),2,12)
  call Hotf_5pt_reduction(G2H12(60),RedSet_5(40),mass5set(:,1),  & 
G1H12(241),G1H12(242),G1H12(243),G1H12(244),G1H12(245),G1H12(246),12)
  call HG1shiftOLR(G1H12(242),2,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(145),[G1H12(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(151),[G1H12(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(163),[G1H12(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(169),[G1H12(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(181),[G1H12(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(187),[G1H12(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(199),[G1H12(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(205),[G1H12(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(37),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(43),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(73),[G1H8(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(217),[G1H12(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(223),[G1H12(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(235),[G1H12(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(241),[G1H12(234)])
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(13),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-16,0,G2H8(1),n2h8(33))
  call Hloop_AV_Q(ntryL,G2H8(1),ex5(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(15),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(16),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H12(7),ex2(:),G1H6(1),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(7),n2h6(1))
call HGT_OLR(G1H12(8),1,1,12)
call HGT_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(8),-16,0,G2H12(1),n2h12(45))
  call Hloop_QV_A(ntryL,G2H12(1),ex5(:),G2H6(8),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_VA_Q(ntryL,G1H12(11),ex2(:),G1H6(1),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(9),n2h6(2))
  call Hloop_VA_Q(ntryL,G1H12(12),ex2(:),G1H6(1),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(10),n2h6(3))
  call Hloop_VA_Q(ntryL,G1H12(13),ex2(:),G1H6(1),m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(11),n2h6(4))
call HGT_OLR(G1H12(14),1,1,12)
call HGT_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(14),-8,0,G2H12(2),n2h12(46))
  call Hloop_QW_A(ntryL,G2H12(2),ex4(:),G2H4(17),m3h3x4(:,1),heltab2x12(:,:,12))
  call Hloop_VA_Q(ntryL,G1H12(17),ex2(:),G1H6(1),m3h2x6(:,12),heltab2x12(:,:,13))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(12),n2h6(5))
  call Hloop_VA_Q(ntryL,G1H12(18),ex2(:),G1H6(1),m3h2x6(:,13),heltab2x12(:,:,14))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(13),n2h6(6))
  call Hloop_QV_A(ntryL,G1H12(19),ex3(:),G1H6(1),m3h2x6(:,14),heltab2x12(:,:,15))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(14),n2h6(7))
call HGT_OLR(G1H12(20),1,1,12)
call HGT_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(20),-16,0,G2H12(3),n2h12(47))
  call Hloop_AV_Q(ntryL,G2H12(3),ex5(:),G2H6(15),m3h2x6(:,15),heltab2x12(:,:,16))
  call Hloop_QV_A(ntryL,G1H12(23),ex3(:),G1H6(1),m3h2x6(:,16),heltab2x12(:,:,17))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(16),n2h6(8))
  call Hloop_QV_A(ntryL,G1H12(24),ex3(:),G1H6(1),m3h2x6(:,17),heltab2x12(:,:,18))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(17),n2h6(9))
  call Hloop_QV_A(ntryL,G1H12(25),ex3(:),G1H6(1),m3h2x6(:,18),heltab2x12(:,:,19))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(18),n2h6(10))
call HGT_OLR(G1H12(26),1,1,12)
call HGT_invQ_OLR(G1H12(26),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(26),-8,0,G2H12(4),n2h12(48))
  call Hloop_AW_Q(ntryL,G2H12(4),ex4(:),G2H4(18),m3h3x4(:,2),heltab2x12(:,:,20))
  call Hloop_QV_A(ntryL,G1H12(29),ex3(:),G1H6(1),m3h2x6(:,19),heltab2x12(:,:,21))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(19),n2h6(11))
  call Hloop_QV_A(ntryL,G1H12(30),ex3(:),G1H6(1),m3h2x6(:,20),heltab2x12(:,:,22))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(20),n2h6(12))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(19),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-16,0,G2H8(2),n2h8(34))
  call Hloop_QV_A(ntryL,G2H8(2),ex5(:),G2H4(20),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_VA_Q(ntryL,G1H8(11),ex2(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(21),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H8(12),ex2(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(22),n2h4(6))
  call Hloop_VQ_A(ntryL,G1H12(31),ex1(:),G1H6(1),m3h2x6(:,21),heltab2x12(:,:,23))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(21),n2h6(13))
call HGT_OLR(G1H12(32),1,1,12)
call HGT_invQ_OLR(G1H12(32),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(32),-16,0,G2H12(5),n2h12(49))
  call Hloop_AV_Q(ntryL,G2H12(5),ex5(:),G2H6(22),m3h2x6(:,22),heltab2x12(:,:,24))
  call Hloop_VQ_A(ntryL,G1H12(35),ex1(:),G1H6(1),m3h2x6(:,23),heltab2x12(:,:,25))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(23),n2h6(14))
  call Hloop_VQ_A(ntryL,G1H12(36),ex1(:),G1H6(1),m3h2x6(:,24),heltab2x12(:,:,26))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(24),n2h6(15))
  call Hloop_QW_A(ntryL,G1H12(37),ex4(:),G1H4(1),m3h3x4(:,3),heltab2x12(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(23),n2h4(7))
call HGT_OLR(G1H12(38),1,1,12)
call HGT_invQ_OLR(G1H12(38),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(38),-16,0,G2H12(6),n2h12(50))
  call Hloop_AV_Q(ntryL,G2H12(6),ex5(:),G2H6(25),m3h2x6(:,25),heltab2x12(:,:,28))
  call Hloop_QW_A(ntryL,G1H12(41),ex4(:),G1H4(1),m3h3x4(:,4),heltab2x12(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(24),n2h4(8))
  call Hloop_QW_A(ntryL,G1H12(42),ex4(:),G1H4(1),m3h3x4(:,5),heltab2x12(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(25),n2h4(9))
  call Hloop_QW_A(ntryL,G1H12(43),ex4(:),G1H4(1),m3h3x4(:,6),heltab2x12(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(26),n2h4(10))
call HGT_OLR(G1H12(44),1,1,12)
call HGT_invQ_OLR(G1H12(44),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(44),-4,0,G2H12(7),n2h12(51))
  call Hloop_AV_Q(ntryL,G2H12(7),ex3(:),G2H6(26),m3h2x6(:,26),heltab2x12(:,:,32))
  call Hloop_QW_A(ntryL,G1H12(47),ex4(:),G1H4(1),m3h3x4(:,7),heltab2x12(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(27),n2h4(11))
  call Hloop_QW_A(ntryL,G1H12(48),ex4(:),G1H4(1),m3h3x4(:,8),heltab2x12(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(28),n2h4(12))
  call Hloop_VQ_A(ntryL,G1H12(49),ex1(:),G1H6(1),m3h2x6(:,27),heltab2x12(:,:,35))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(27),n2h6(16))
call HGT_OLR(G1H12(50),1,1,12)
call HGT_invQ_OLR(G1H12(50),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(50),-8,0,G2H12(8),n2h12(52))
  call Hloop_AW_Q(ntryL,G2H12(8),ex4(:),G2H4(29),m3h3x4(:,9),heltab2x12(:,:,36))
  call Hloop_VQ_A(ntryL,G1H12(53),ex1(:),G1H6(1),m3h2x6(:,28),heltab2x12(:,:,37))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(28),n2h6(17))
  call Hloop_VQ_A(ntryL,G1H12(54),ex1(:),G1H6(1),m3h2x6(:,29),heltab2x12(:,:,38))
  call Hloop_Q_A(ntryL,G1H6(1),39,0,G2H6(29),n2h6(18))
  call Hloop_QV_A(ntryL,G1H12(55),ex5(:),G1H6(1),m3h2x6(:,30),heltab2x12(:,:,39))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(30),n2h6(19))
call HGT_OLR(G1H12(56),1,1,12)
call HGT_invQ_OLR(G1H12(56),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(56),-8,0,G2H12(9),n2h12(53))
  call Hloop_AW_Q(ntryL,G2H12(9),ex4(:),G2H4(30),m3h3x4(:,10),heltab2x12(:,:,40))
  call Hloop_QV_A(ntryL,G1H12(59),ex5(:),G1H6(1),m3h2x6(:,31),heltab2x12(:,:,41))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(31),n2h6(20))
  call Hloop_QV_A(ntryL,G1H12(60),ex5(:),G1H6(1),m3h2x6(:,32),heltab2x12(:,:,42))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(32),n2h6(21))
  call Hloop_QV_A(ntryL,G1H12(61),ex5(:),G1H6(1),m3h2x6(:,33),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(33),n2h6(22))
call HGT_OLR(G1H12(62),1,1,12)
call HGT_invQ_OLR(G1H12(62),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(62),-4,0,G2H12(10),n2h12(54))
  call Hloop_AV_Q(ntryL,G2H12(10),ex3(:),G2H6(34),m3h2x6(:,34),heltab2x12(:,:,44))
  call Hloop_QV_A(ntryL,G1H12(65),ex5(:),G1H6(1),m3h2x6(:,35),heltab2x12(:,:,45))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(35),n2h6(23))
  call Hloop_QV_A(ntryL,G1H12(66),ex5(:),G1H6(1),m3h2x6(:,36),heltab2x12(:,:,46))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(36),n2h6(24))
  call Hloop_AV_Q(ntryL,G1H12(67),ex3(:),G1H6(1),m3h2x6(:,37),heltab2x12(:,:,47))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(37),n2h6(25))
call HGT_OLR(G1H12(68),1,1,12)
call HGT_invQ_OLR(G1H12(68),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(68),-16,0,G2H12(11),n2h12(55))
  call Hloop_QV_A(ntryL,G2H12(11),ex5(:),G2H6(38),m3h2x6(:,38),heltab2x12(:,:,48))
  call Hloop_AV_Q(ntryL,G1H12(71),ex3(:),G1H6(1),m3h2x6(:,39),heltab2x12(:,:,49))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(39),n2h6(26))
  call Hloop_AV_Q(ntryL,G1H12(72),ex3(:),G1H6(1),m3h2x6(:,40),heltab2x12(:,:,50))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(40),n2h6(27))
  call Hloop_AV_Q(ntryL,G1H12(73),ex3(:),G1H6(1),m3h2x6(:,41),heltab2x12(:,:,51))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(41),n2h6(28))
call HGT_OLR(G1H12(74),1,1,12)
call HGT_invQ_OLR(G1H12(74),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(74),-8,0,G2H12(12),n2h12(56))
  call Hloop_QW_A(ntryL,G2H12(12),ex4(:),G2H4(31),m3h3x4(:,11),heltab2x12(:,:,52))
  call Hloop_AV_Q(ntryL,G1H12(77),ex3(:),G1H6(1),m3h2x6(:,42),heltab2x12(:,:,53))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(42),n2h6(29))
  call Hloop_AV_Q(ntryL,G1H12(78),ex3(:),G1H6(1),m3h2x6(:,43),heltab2x12(:,:,54))
  call Hloop_A_Q(ntryL,G1H6(1),39,0,G2H6(43),n2h6(30))
  call Hloop_AW_Q(ntryL,G1H12(79),ex4(:),G1H4(1),m3h3x4(:,12),heltab2x12(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(32),n2h4(13))
call HGT_OLR(G1H12(80),1,1,12)
call HGT_invQ_OLR(G1H12(80),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(80),-16,0,G2H12(13),n2h12(57))
  call Hloop_QV_A(ntryL,G2H12(13),ex5(:),G2H6(44),m3h2x6(:,44),heltab2x12(:,:,56))
  call Hloop_AW_Q(ntryL,G1H12(83),ex4(:),G1H4(1),m3h3x4(:,13),heltab2x12(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(33),n2h4(14))
  call Hloop_AW_Q(ntryL,G1H12(84),ex4(:),G1H4(1),m3h3x4(:,14),heltab2x12(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(34),n2h4(15))
  call Hloop_AW_Q(ntryL,G1H12(85),ex4(:),G1H4(1),m3h3x4(:,15),heltab2x12(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(35),n2h4(16))
call HGT_OLR(G1H12(86),1,1,12)
call HGT_invQ_OLR(G1H12(86),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(86),-4,0,G2H12(14),n2h12(58))
  call Hloop_QV_A(ntryL,G2H12(14),ex3(:),G2H6(45),m3h2x6(:,45),heltab2x12(:,:,60))
  call Hloop_AW_Q(ntryL,G1H12(89),ex4(:),G1H4(1),m3h3x4(:,16),heltab2x12(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(36),n2h4(17))
  call Hloop_AW_Q(ntryL,G1H12(90),ex4(:),G1H4(1),m3h3x4(:,17),heltab2x12(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(1),43,0,G2H4(37),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H12(91),ex5(:),G1H6(1),m3h2x6(:,46),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(46),n2h6(31))
call HGT_OLR(G1H12(92),1,1,12)
call HGT_invQ_OLR(G1H12(92),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(92),-8,0,G2H12(15),n2h12(59))
  call Hloop_QW_A(ntryL,G2H12(15),ex4(:),G2H4(38),m3h3x4(:,18),heltab2x12(:,:,64))
  call Hloop_AV_Q(ntryL,G1H12(95),ex5(:),G1H6(1),m3h2x6(:,47),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(47),n2h6(32))
  call Hloop_AV_Q(ntryL,G1H12(96),ex5(:),G1H6(1),m3h2x6(:,48),heltab2x12(:,:,66))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(48),n2h6(33))
  call Hloop_AV_Q(ntryL,G1H12(97),ex5(:),G1H6(1),m3h2x6(:,49),heltab2x12(:,:,67))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(49),n2h6(34))
call HGT_OLR(G1H12(98),1,1,12)
call HGT_invQ_OLR(G1H12(98),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(98),-4,0,G2H12(16),n2h12(60))
  call Hloop_QV_A(ntryL,G2H12(16),ex3(:),G2H6(50),m3h2x6(:,50),heltab2x12(:,:,68))
  call Hloop_AV_Q(ntryL,G1H12(101),ex5(:),G1H6(1),m3h2x6(:,51),heltab2x12(:,:,69))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(51),n2h6(35))
  call Hloop_AV_Q(ntryL,G1H12(102),ex5(:),G1H6(1),m3h2x6(:,52),heltab2x12(:,:,70))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(52),n2h6(36))
  call Hloop_UV_W(ntryL,G1H12(103),37,ex5(:),16,G2H6(53),m3h2x6(:,53),heltab2x12(:,:,71))
call HGT_OLR(G1H12(104),1,1,12)
call HGT_invQ_OLR(G1H12(104),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(104),-8,0,G2H12(17),n2h12(61))
  call Hloop_QW_A(ntryL,G2H12(17),ex4(:),G2H4(39),m3h3x4(:,19),heltab2x12(:,:,72))
  call Hloop_UV_W(ntryL,G1H12(107),37,ex5(:),16,G2H6(54),m3h2x6(:,54),heltab2x12(:,:,73))
  call Hloop_UV_W(ntryL,G1H12(108),37,ex5(:),16,G2H6(55),m3h2x6(:,55),heltab2x12(:,:,74))
  call Hloop_VQ_A(ntryL,G1H12(109),ex1(:),G1H6(1),m3h2x6(:,56),heltab2x12(:,:,75))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(56),n2h6(37))
call HGT_OLR(G1H12(110),1,1,12)
call HGT_invQ_OLR(G1H12(110),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(110),-8,0,G2H12(18),n2h12(62))
  call Hloop_AW_Q(ntryL,G2H12(18),ex4(:),G2H4(40),m3h3x4(:,20),heltab2x12(:,:,76))
  call Hloop_VQ_A(ntryL,G1H12(113),ex1(:),G1H6(1),m3h2x6(:,57),heltab2x12(:,:,77))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(57),n2h6(38))
  call Hloop_VQ_A(ntryL,G1H12(114),ex1(:),G1H6(1),m3h2x6(:,58),heltab2x12(:,:,78))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(58),n2h6(39))
  call Hloop_UV_W(ntryL,G1H12(115),38,ex5(:),16,G2H6(59),m3h2x6(:,59),heltab2x12(:,:,79))
call HGT_OLR(G1H12(116),1,1,12)
call HGT_invQ_OLR(G1H12(116),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(116),-8,0,G2H12(19),n2h12(63))
  call Hloop_AW_Q(ntryL,G2H12(19),ex4(:),G2H4(41),m3h3x4(:,21),heltab2x12(:,:,80))
  call Hloop_UV_W(ntryL,G1H12(119),38,ex5(:),16,G2H6(60),m3h2x6(:,60),heltab2x12(:,:,81))
  call Hloop_UV_W(ntryL,G1H12(120),38,ex5(:),16,G2H6(61),m3h2x6(:,61),heltab2x12(:,:,82))
  call Hloop_VQ_A(ntryL,G1H12(121),ex1(:),G1H6(1),m3h2x6(:,62),heltab2x12(:,:,83))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(62),n2h6(40))
call HGT_OLR(G1H12(122),1,1,12)
call HGT_invQ_OLR(G1H12(122),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(122),-4,0,G2H12(20),n2h12(64))
  call Hloop_AV_Q(ntryL,G2H12(20),ex3(:),G2H6(63),m3h2x6(:,63),heltab2x12(:,:,84))
  call Hloop_VQ_A(ntryL,G1H12(125),ex1(:),G1H6(1),m3h2x6(:,64),heltab2x12(:,:,85))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(64),n2h6(41))
  call Hloop_VQ_A(ntryL,G1H12(126),ex1(:),G1H6(1),m3h2x6(:,65),heltab2x12(:,:,86))
  call Hloop_Q_A(ntryL,G1H6(1),51,0,G2H6(65),n2h6(42))
  call Hloop_VA_Q(ntryL,G1H12(127),ex2(:),G1H6(1),m3h2x6(:,66),heltab2x12(:,:,87))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(66),n2h6(43))
call HGT_OLR(G1H12(128),1,1,12)
call HGT_invQ_OLR(G1H12(128),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(128),-8,0,G2H12(21),n2h12(65))
  call Hloop_QW_A(ntryL,G2H12(21),ex4(:),G2H4(42),m3h3x4(:,22),heltab2x12(:,:,88))
  call Hloop_VA_Q(ntryL,G1H12(131),ex2(:),G1H6(1),m3h2x6(:,67),heltab2x12(:,:,89))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(67),n2h6(44))
  call Hloop_VA_Q(ntryL,G1H12(132),ex2(:),G1H6(1),m3h2x6(:,68),heltab2x12(:,:,90))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(68),n2h6(45))
  call Hloop_VA_Q(ntryL,G1H12(133),ex2(:),G1H6(1),m3h2x6(:,69),heltab2x12(:,:,91))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(69),n2h6(46))
call HGT_OLR(G1H12(134),1,1,12)
call HGT_invQ_OLR(G1H12(134),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(134),-4,0,G2H12(22),n2h12(66))
  call Hloop_QV_A(ntryL,G2H12(22),ex3(:),G2H6(70),m3h2x6(:,70),heltab2x12(:,:,92))
  call Hloop_VA_Q(ntryL,G1H12(137),ex2(:),G1H6(1),m3h2x6(:,71),heltab2x12(:,:,93))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(71),n2h6(47))
  call Hloop_VA_Q(ntryL,G1H12(138),ex2(:),G1H6(1),m3h2x6(:,72),heltab2x12(:,:,94))
  call Hloop_A_Q(ntryL,G1H6(1),51,0,G2H6(72),n2h6(48))
  call Hloop_AV_Q(ntryL,G1H8(13),ex3(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(43),n2h4(19))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(14),-16,ex5(:),16,G2H4(44),m3h2x4(:,22),heltab2x8(:,:,22))
call signflip_OLR(G2H4(44))
  call Hloop_AV_Q(ntryL,G1H8(19),ex3(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(45),n2h4(20))
  call Hloop_AV_Q(ntryL,G1H8(25),ex3(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(46),n2h4(21))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(20),-16,ex5(:),16,G2H4(47),m3h2x4(:,25),heltab2x8(:,:,25))
call signflip_OLR(G2H4(47))
  call Hloop_AV_Q(ntryL,G1H8(23),ex3(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(48),n2h4(22))
  call Hloop_AV_Q(ntryL,G1H8(24),ex3(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(49),n2h4(23))
call HGT_raise_alpha_OLR(G1H8(26),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(26),-16,ex5(:),16,G2H4(50),m3h2x4(:,28),heltab2x8(:,:,28))
call signflip_OLR(G2H4(50))
  call Hloop_AV_Q(ntryL,G1H8(29),ex3(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(51),n2h4(24))
  call Hloop_AV_Q(ntryL,G1H8(30),ex3(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(52),n2h4(25))
  call Hloop_QW_A(ntryL,G1H12(139),ex4(:),G1H4(1),m3h3x4(:,23),heltab2x12(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(53),n2h4(26))
call HGT_raise_alpha_OLR(G1H12(140),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(140),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(140),-16,ex5(:),16,G2H6(73),m3h2x6(:,73),heltab2x12(:,:,96))
call signflip_OLR(G2H6(73))
  call Hloop_QW_A(ntryL,G1H12(145),ex4(:),G1H4(1),m3h3x4(:,24),heltab2x12(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(54),n2h4(27))
  call Hloop_QW_A(ntryL,G1H12(151),ex4(:),G1H4(1),m3h3x4(:,25),heltab2x12(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(55),n2h4(28))
call HGT_raise_alpha_OLR(G1H12(146),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(146),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(146),-16,ex5(:),16,G2H6(74),m3h2x6(:,74),heltab2x12(:,:,99))
call signflip_OLR(G2H6(74))
  call Hloop_QW_A(ntryL,G1H12(149),ex4(:),G1H4(1),m3h3x4(:,26),heltab2x12(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(56),n2h4(29))
  call Hloop_QW_A(ntryL,G1H12(150),ex4(:),G1H4(1),m3h3x4(:,27),heltab2x12(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(57),n2h4(30))
call HGT_raise_alpha_OLR(G1H12(152),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(152),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(152),-16,ex5(:),16,G2H6(75),m3h2x6(:,75),heltab2x12(:,:,102))
call signflip_OLR(G2H6(75))
  call Hloop_QW_A(ntryL,G1H12(155),ex4(:),G1H4(1),m3h3x4(:,28),heltab2x12(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(58),n2h4(31))
  call Hloop_QW_A(ntryL,G1H12(156),ex4(:),G1H4(1),m3h3x4(:,29),heltab2x12(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(59),n2h4(32))
  call Hloop_QV_A(ntryL,G1H12(157),ex5(:),G1H6(1),m3h2x6(:,76),heltab2x12(:,:,105))
  call Hloop_Q_A(ntryL,G1H6(1),53,0,G2H6(76),n2h6(49))
call HGT_raise_alpha_OLR(G1H12(158),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(158),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(158),ex2(:),G1H6(1),m3h2x6(:,77),heltab2x12(:,:,106))
  call Hloop_QV_A(ntryL,G1H12(163),ex5(:),G1H6(2),m3h2x6(:,78),heltab2x12(:,:,107))
  call Hloop_Q_A(ntryL,G1H6(2),53,0,G2H6(77),n2h6(50))
  call Hloop_QV_A(ntryL,G1H12(169),ex5(:),G1H6(2),m3h2x6(:,79),heltab2x12(:,:,108))
  call Hloop_Q_A(ntryL,G1H6(2),53,0,G2H6(78),n2h6(51))
call HGT_raise_alpha_OLR(G1H12(164),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(164),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(164),ex2(:),G1H6(2),m3h2x6(:,80),heltab2x12(:,:,109))
  call Hloop_QV_A(ntryL,G1H12(167),ex5(:),G1H6(3),m3h2x6(:,81),heltab2x12(:,:,110))
  call Hloop_Q_A(ntryL,G1H6(3),53,0,G2H6(79),n2h6(52))
  call Hloop_QV_A(ntryL,G1H12(168),ex5(:),G1H6(3),m3h2x6(:,82),heltab2x12(:,:,111))
  call Hloop_Q_A(ntryL,G1H6(3),53,0,G2H6(80),n2h6(53))
call HGT_raise_alpha_OLR(G1H12(170),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(170),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(170),ex2(:),G1H6(3),m3h2x6(:,83),heltab2x12(:,:,112))
  call Hloop_QV_A(ntryL,G1H12(173),ex5(:),G1H6(4),m3h2x6(:,84),heltab2x12(:,:,113))
  call Hloop_Q_A(ntryL,G1H6(4),53,0,G2H6(81),n2h6(54))
  call Hloop_QV_A(ntryL,G1H12(174),ex5(:),G1H6(4),m3h2x6(:,85),heltab2x12(:,:,114))
  call Hloop_Q_A(ntryL,G1H6(4),53,0,G2H6(82),n2h6(55))
  call Hloop_QW_A(ntryL,G1H12(175),ex4(:),G1H4(1),m3h3x4(:,30),heltab2x12(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(60),n2h4(33))
call HGT_raise_alpha_OLR(G1H12(176),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(176),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(176),ex2(:),G1H6(4),m3h2x6(:,86),heltab2x12(:,:,116))
  call Hloop_QW_A(ntryL,G1H12(181),ex4(:),G1H4(1),m3h3x4(:,31),heltab2x12(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(61),n2h4(34))
  call Hloop_QW_A(ntryL,G1H12(187),ex4(:),G1H4(1),m3h3x4(:,32),heltab2x12(:,:,118))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(62),n2h4(35))
call HGT_raise_alpha_OLR(G1H12(182),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(182),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(182),ex2(:),G1H6(5),m3h2x6(:,87),heltab2x12(:,:,119))
  call Hloop_QW_A(ntryL,G1H12(185),ex4(:),G1H4(1),m3h3x4(:,33),heltab2x12(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(63),n2h4(36))
  call Hloop_QW_A(ntryL,G1H12(186),ex4(:),G1H4(1),m3h3x4(:,34),heltab2x12(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(64),n2h4(37))
call HGT_raise_alpha_OLR(G1H12(188),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(188),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(188),ex2(:),G1H6(6),m3h2x6(:,88),heltab2x12(:,:,122))
  call Hloop_QW_A(ntryL,G1H12(191),ex4(:),G1H4(1),m3h3x4(:,35),heltab2x12(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(65),n2h4(38))
  call Hloop_QW_A(ntryL,G1H12(192),ex4(:),G1H4(1),m3h3x4(:,36),heltab2x12(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(66),n2h4(39))
  call Hloop_AW_Q(ntryL,G1H12(193),ex4(:),G1H4(1),m3h3x4(:,37),heltab2x12(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(67),n2h4(40))
call HGT_raise_alpha_OLR(G1H12(194),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(194),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(194),-16,ex5(:),16,G2H6(83),m3h2x6(:,89),heltab2x12(:,:,126))
call signflip_OLR(G2H6(83))
  call Hloop_AW_Q(ntryL,G1H12(199),ex4(:),G1H4(1),m3h3x4(:,38),heltab2x12(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(68),n2h4(41))
  call Hloop_AW_Q(ntryL,G1H12(205),ex4(:),G1H4(1),m3h3x4(:,39),heltab2x12(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(69),n2h4(42))
call HGT_raise_alpha_OLR(G1H12(200),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(200),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(200),-16,ex5(:),16,G2H6(84),m3h2x6(:,90),heltab2x12(:,:,129))
call signflip_OLR(G2H6(84))
  call Hloop_AW_Q(ntryL,G1H12(203),ex4(:),G1H4(1),m3h3x4(:,40),heltab2x12(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(70),n2h4(43))
  call Hloop_AW_Q(ntryL,G1H12(204),ex4(:),G1H4(1),m3h3x4(:,41),heltab2x12(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(71),n2h4(44))
call HGT_raise_alpha_OLR(G1H12(206),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(206),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(206),-16,ex5(:),16,G2H6(85),m3h2x6(:,91),heltab2x12(:,:,132))
call signflip_OLR(G2H6(85))
  call Hloop_AW_Q(ntryL,G1H12(209),ex4(:),G1H4(1),m3h3x4(:,42),heltab2x12(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(72),n2h4(45))
  call Hloop_AW_Q(ntryL,G1H12(210),ex4(:),G1H4(1),m3h3x4(:,43),heltab2x12(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(73),n2h4(46))
  call Hloop_QV_A(ntryL,G1H8(31),ex3(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(74),n2h4(47))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(32),-16,ex5(:),16,G2H4(75),m3h2x4(:,32),heltab2x8(:,:,32))
call signflip_OLR(G2H4(75))
  call Hloop_QV_A(ntryL,G1H8(37),ex3(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(76),n2h4(48))
  call Hloop_QV_A(ntryL,G1H8(43),ex3(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(77),n2h4(49))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(38),-16,ex5(:),16,G2H4(78),m3h2x4(:,35),heltab2x8(:,:,35))
call signflip_OLR(G2H4(78))
  call Hloop_QV_A(ntryL,G1H8(41),ex3(:),G1H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(79),n2h4(50))
  call Hloop_QV_A(ntryL,G1H8(42),ex3(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(80),n2h4(51))
call HGT_raise_alpha_OLR(G1H8(44),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(44),-16,ex5(:),16,G2H4(81),m3h2x4(:,38),heltab2x8(:,:,38))
call signflip_OLR(G2H4(81))
  call Hloop_QV_A(ntryL,G1H8(47),ex3(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(82),n2h4(52))
  call Hloop_QV_A(ntryL,G1H8(48),ex3(:),G1H4(1),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(83),n2h4(53))
  call Hloop_QV_A(ntryL,G1H8(49),ex5(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(1),57,0,G2H4(84),n2h4(54))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(50),ex2(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_QV_A(ntryL,G1H8(55),ex5(:),G1H4(2),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(2),57,0,G2H4(85),n2h4(55))
  call Hloop_QV_A(ntryL,G1H8(61),ex5(:),G1H4(2),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(2),57,0,G2H4(86),n2h4(56))
call HGT_raise_alpha_OLR(G1H8(56),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(56),ex2(:),G1H4(2),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_QV_A(ntryL,G1H8(59),ex5(:),G1H4(3),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(3),57,0,G2H4(87),n2h4(57))
  call Hloop_QV_A(ntryL,G1H8(60),ex5(:),G1H4(3),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(3),57,0,G2H4(88),n2h4(58))
call HGT_raise_alpha_OLR(G1H8(62),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(62),ex2(:),G1H4(3),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_QV_A(ntryL,G1H8(65),ex5(:),G1H4(4),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(4),57,0,G2H4(89),n2h4(59))
  call Hloop_QV_A(ntryL,G1H8(66),ex5(:),G1H4(4),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(4),57,0,G2H4(90),n2h4(60))
  call Hloop_QV_A(ntryL,G1H8(67),ex3(:),G1H4(4),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(4),45,0,G2H4(91),n2h4(61))
call HGT_raise_alpha_OLR(G1H8(68),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(68),ex2(:),G1H4(4),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_QV_A(ntryL,G1H8(73),ex3(:),G1H4(5),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(5),45,0,G2H4(92),n2h4(62))
  call Hloop_QV_A(ntryL,G1H8(79),ex3(:),G1H4(5),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(5),45,0,G2H4(93),n2h4(63))
call HGT_raise_alpha_OLR(G1H8(74),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(74),ex2(:),G1H4(5),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_QV_A(ntryL,G1H8(77),ex3(:),G1H4(6),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(6),45,0,G2H4(94),n2h4(64))
  call Hloop_QV_A(ntryL,G1H8(78),ex3(:),G1H4(6),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(6),45,0,G2H4(95),n2h4(65))
call HGT_raise_alpha_OLR(G1H8(80),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(80),ex2(:),G1H4(6),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_QV_A(ntryL,G1H8(83),ex3(:),G1H4(7),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(96),n2h4(66))
  call Hloop_QV_A(ntryL,G1H8(84),ex3(:),G1H4(7),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(97),n2h4(67))
  call Hloop_QW_A(ntryL,G1H12(211),ex4(:),G1H4(7),m3h3x4(:,44),heltab2x12(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(7),57,0,G2H4(98),n2h4(68))
call HGT_raise_alpha_OLR(G1H12(212),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(212),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(212),ex2(:),G1H6(7),m3h2x6(:,92),heltab2x12(:,:,136))
  call Hloop_QW_A(ntryL,G1H12(217),ex4(:),G1H4(7),m3h3x4(:,45),heltab2x12(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(7),57,0,G2H4(99),n2h4(69))
  call Hloop_QW_A(ntryL,G1H12(223),ex4(:),G1H4(7),m3h3x4(:,46),heltab2x12(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(7),57,0,G2H4(100),n2h4(70))
call HGT_raise_alpha_OLR(G1H12(218),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(218),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(218),ex2(:),G1H6(8),m3h2x6(:,93),heltab2x12(:,:,139))
  call Hloop_QW_A(ntryL,G1H12(221),ex4(:),G1H4(7),m3h3x4(:,47),heltab2x12(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(7),57,0,G2H4(101),n2h4(71))
  call Hloop_QW_A(ntryL,G1H12(222),ex4(:),G1H4(7),m3h3x4(:,48),heltab2x12(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(7),57,0,G2H4(102),n2h4(72))
call HGT_raise_alpha_OLR(G1H12(224),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(224),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(224),ex2(:),G1H6(9),m3h2x6(:,94),heltab2x12(:,:,142))
  call Hloop_QW_A(ntryL,G1H12(227),ex4(:),G1H4(7),m3h3x4(:,49),heltab2x12(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(7),57,0,G2H4(103),n2h4(73))
  call Hloop_QW_A(ntryL,G1H12(228),ex4(:),G1H4(7),m3h3x4(:,50),heltab2x12(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(7),57,0,G2H4(104),n2h4(74))
  call Hloop_QV_A(ntryL,G1H12(229),ex3(:),G1H6(10),m3h2x6(:,95),heltab2x12(:,:,145))
  call Hloop_Q_A(ntryL,G1H6(10),53,0,G2H6(86),n2h6(56))
call HGT_raise_alpha_OLR(G1H12(230),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(230),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(230),ex2(:),G1H6(10),m3h2x6(:,96),heltab2x12(:,:,146))
  call Hloop_QV_A(ntryL,G1H12(235),ex3(:),G1H6(11),m3h2x6(:,97),heltab2x12(:,:,147))
  call Hloop_Q_A(ntryL,G1H6(11),53,0,G2H6(87),n2h6(57))
  call Hloop_QV_A(ntryL,G1H12(241),ex3(:),G1H6(11),m3h2x6(:,98),heltab2x12(:,:,148))
  call Hloop_Q_A(ntryL,G1H6(11),53,0,G2H6(88),n2h6(58))
call HGT_raise_alpha_OLR(G1H12(236),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(236),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(236),ex2(:),G1H6(11),m3h2x6(:,99),heltab2x12(:,:,149))
  call Hloop_QV_A(ntryL,G1H12(239),ex3(:),G1H6(12),m3h2x6(:,100),heltab2x12(:,:,150))
  call Hloop_Q_A(ntryL,G1H6(12),53,0,G2H6(89),n2h6(59))
  call Hloop_QV_A(ntryL,G1H12(240),ex3(:),G1H6(12),m3h2x6(:,101),heltab2x12(:,:,151))
  call Hloop_Q_A(ntryL,G1H6(12),53,0,G2H6(90),n2h6(60))
call HGT_raise_alpha_OLR(G1H12(242),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(242),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(242),ex2(:),G1H6(12),m3h2x6(:,102),heltab2x12(:,:,152))
  call Hloop_QV_A(ntryL,G1H12(245),ex3(:),G1H6(13),m3h2x6(:,103),heltab2x12(:,:,153))
  call Hloop_Q_A(ntryL,G1H6(13),53,0,G2H6(91),n2h6(61))
  call Hloop_QV_A(ntryL,G1H12(246),ex3(:),G1H6(13),m3h2x6(:,104),heltab2x12(:,:,154))
  call Hloop_Q_A(ntryL,G1H6(13),53,0,G2H6(92),n2h6(62))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(41),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(42),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),16,4)
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(3),mass5set(:,1),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),8,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(43),mass5set(:,1),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),6)
  call HG1shiftOLR(G1H6(20),8,6)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(4),mass5set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(41),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),16,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(5),mass5set(:,1),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(42),mass5set(:,1),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),16,4)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(6),mass5set(:,1),  & 
G1H6(25),G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
  call HG1shiftOLR(G1H6(26),8,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(43),mass5set(:,1),  & 
G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(32),8,6)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(15),mass5set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(44),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),16,4)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(16),mass5set(:,1),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),6)
  call HG1shiftOLR(G1H6(38),16,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(45),mass5set(:,1),  & 
G1H6(43),G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),6)
  call HG1shiftOLR(G1H6(44),16,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(16),mass5set(:,1),  & 
G1H6(49),G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
  call HG1shiftOLR(G1H6(50),8,6)
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(46),mass5set(:,1),  & 
G1H6(55),G1H6(56),G1H6(57),G1H6(58),G1H6(59),G1H6(60),6)
  call HG1shiftOLR(G1H6(56),8,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(17),mass5set(:,1),  & 
G1H6(61),G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),6)
  call HG1shiftOLR(G1H6(62),16,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(47),mass5set(:,1),  & 
G1H6(67),G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(68),16,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(17),mass5set(:,1),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),G1H6(78),6)
  call HG1shiftOLR(G1H6(74),8,6)
  call Hotf_5pt_reduction(G2H6(20),RedSet_5(48),mass5set(:,1),  & 
G1H6(79),G1H6(80),G1H6(81),G1H6(82),G1H6(83),G1H6(84),6)
  call HG1shiftOLR(G1H6(80),8,6)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(18),mass5set(:,1),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),16,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(49),mass5set(:,1),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),16,4)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(19),mass5set(:,1),  & 
G1H6(85),G1H6(86),G1H6(87),G1H6(88),G1H6(89),G1H6(90),6)
  call HG1shiftOLR(G1H6(86),16,6)
  call Hotf_5pt_reduction(G2H6(24),RedSet_5(50),mass5set(:,1),  & 
G1H6(91),G1H6(92),G1H6(93),G1H6(94),G1H6(95),G1H6(96),6)
  call HG1shiftOLR(G1H6(92),16,6)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(20),mass5set(:,1),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),16,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(47),mass5set(:,1),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),16,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(20),mass5set(:,1),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),4,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(51),mass5set(:,1),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),4,4)
  call Hotf_5pt_reduction(G2H6(27),RedSet_5(19),mass5set(:,1),  & 
G1H6(97),G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),6)
  call HG1shiftOLR(G1H6(98),8,6)
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(52),mass5set(:,1),  & 
G1H6(103),G1H6(104),G1H6(105),G1H6(106),G1H6(107),G1H6(108),6)
  call HG1shiftOLR(G1H6(104),8,6)
  call Hotf_5pt_reduction(G2H6(30),RedSet_5(21),mass5set(:,1),  & 
G1H6(109),G1H6(110),G1H6(111),G1H6(112),G1H6(113),G1H6(114),6)
  call HG1shiftOLR(G1H6(110),8,6)
  call Hotf_5pt_reduction(G2H6(32),RedSet_5(48),mass5set(:,1),  & 
G1H6(115),G1H6(116),G1H6(117),G1H6(118),G1H6(119),G1H6(120),6)
  call HG1shiftOLR(G1H6(116),8,6)
  call Hotf_5pt_reduction(G2H6(33),RedSet_5(21),mass5set(:,1),  & 
G1H6(121),G1H6(122),G1H6(123),G1H6(124),G1H6(125),G1H6(126),6)
  call HG1shiftOLR(G1H6(122),4,6)
  call Hotf_5pt_reduction(G2H6(36),RedSet_5(51),mass5set(:,1),  & 
G1H6(127),G1H6(128),G1H6(129),G1H6(130),G1H6(131),G1H6(132),6)
  call HG1shiftOLR(G1H6(128),4,6)
  call Hotf_5pt_reduction(G2H6(37),RedSet_5(22),mass5set(:,1),  & 
G1H6(133),G1H6(134),G1H6(135),G1H6(136),G1H6(137),G1H6(138),6)
  call HG1shiftOLR(G1H6(134),16,6)
  call Hotf_5pt_reduction(G2H6(40),RedSet_5(53),mass5set(:,1),  & 
G1H6(139),G1H6(140),G1H6(141),G1H6(142),G1H6(143),G1H6(144),6)
  call HG1shiftOLR(G1H6(140),16,6)
  call Hotf_5pt_reduction(G2H6(41),RedSet_5(22),mass5set(:,1),  & 
G1H6(145),G1H6(146),G1H6(147),G1H6(148),G1H6(149),G1H6(150),6)
  call HG1shiftOLR(G1H6(146),8,6)
  call Hotf_5pt_reduction(G2H6(43),RedSet_5(54),mass5set(:,1),  & 
G1H6(151),G1H6(152),G1H6(153),G1H6(154),G1H6(155),G1H6(156),6)
  call HG1shiftOLR(G1H6(152),8,6)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(23),mass5set(:,1),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),16,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(53),mass5set(:,1),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),16,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(23),mass5set(:,1),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),4,4)
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(55),mass5set(:,1),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),4,4)
  call Hotf_5pt_reduction(G2H6(46),RedSet_5(24),mass5set(:,1),  & 
G1H6(157),G1H6(158),G1H6(159),G1H6(160),G1H6(161),G1H6(162),6)
  call HG1shiftOLR(G1H6(158),8,6)
  call Hotf_5pt_reduction(G2H6(48),RedSet_5(54),mass5set(:,1),  & 
G1H6(163),G1H6(164),G1H6(165),G1H6(166),G1H6(167),G1H6(168),6)
  call HG1shiftOLR(G1H6(164),8,6)
  call Hotf_5pt_reduction(G2H6(49),RedSet_5(24),mass5set(:,1),  & 
G1H6(169),G1H6(170),G1H6(171),G1H6(172),G1H6(173),G1H6(174),6)
  call HG1shiftOLR(G1H6(170),4,6)
  call Hotf_5pt_reduction(G2H6(52),RedSet_5(55),mass5set(:,1),  & 
G1H6(175),G1H6(176),G1H6(177),G1H6(178),G1H6(179),G1H6(180),6)
  call HG1shiftOLR(G1H6(176),4,6)
  call Hotf_5pt_reduction(G2H6(53),RedSet_5(25),mass5set(:,1),  & 
G1H6(181),G1H6(182),G1H6(183),G1H6(184),G1H6(185),G1H6(186),6)
  call HG1shiftOLR(G1H6(182),8,6)
  call Hotf_5pt_reduction(G2H6(55),RedSet_5(46),mass5set(:,1),  & 
G1H6(187),G1H6(188),G1H6(189),G1H6(190),G1H6(191),G1H6(192),6)
  call HG1shiftOLR(G1H6(188),8,6)
  call Hotf_5pt_reduction(G2H6(56),RedSet_5(26),mass5set(:,1),  & 
G1H6(193),G1H6(194),G1H6(195),G1H6(196),G1H6(197),G1H6(198),6)
  call HG1shiftOLR(G1H6(194),8,6)
  call Hotf_5pt_reduction(G2H6(58),RedSet_5(56),mass5set(:,1),  & 
G1H6(199),G1H6(200),G1H6(201),G1H6(202),G1H6(203),G1H6(204),6)
  call HG1shiftOLR(G1H6(200),8,6)
  call Hotf_5pt_reduction(G2H6(59),RedSet_5(27),mass5set(:,1),  & 
G1H6(205),G1H6(206),G1H6(207),G1H6(208),G1H6(209),G1H6(210),6)
  call HG1shiftOLR(G1H6(206),8,6)
  call Hotf_5pt_reduction(G2H6(61),RedSet_5(52),mass5set(:,1),  & 
G1H6(211),G1H6(212),G1H6(213),G1H6(214),G1H6(215),G1H6(216),6)
  call HG1shiftOLR(G1H6(212),8,6)
  call Hotf_5pt_reduction(G2H6(62),RedSet_5(26),mass5set(:,1),  & 
G1H6(217),G1H6(218),G1H6(219),G1H6(220),G1H6(221),G1H6(222),6)
  call HG1shiftOLR(G1H6(218),4,6)
  call Hotf_5pt_reduction(G2H6(65),RedSet_5(57),mass5set(:,1),  & 
G1H6(223),G1H6(224),G1H6(225),G1H6(226),G1H6(227),G1H6(228),6)
  call HG1shiftOLR(G1H6(224),4,6)
  call Hotf_5pt_reduction(G2H6(66),RedSet_5(28),mass5set(:,1),  & 
G1H6(229),G1H6(230),G1H6(231),G1H6(232),G1H6(233),G1H6(234),6)
  call HG1shiftOLR(G1H6(230),8,6)
  call Hotf_5pt_reduction(G2H6(68),RedSet_5(58),mass5set(:,1),  & 
G1H6(235),G1H6(236),G1H6(237),G1H6(238),G1H6(239),G1H6(240),6)
  call HG1shiftOLR(G1H6(236),8,6)
  call Hotf_5pt_reduction(G2H6(69),RedSet_5(28),mass5set(:,1),  & 
G1H6(241),G1H6(242),G1H6(243),G1H6(244),G1H6(245),G1H6(246),6)
  call HG1shiftOLR(G1H6(242),4,6)
  call Hotf_5pt_reduction(G2H6(72),RedSet_5(59),mass5set(:,1),  & 
G1H6(247),G1H6(248),G1H6(249),G1H6(250),G1H6(251),G1H6(252),6)
  call HG1shiftOLR(G1H6(248),4,6)
  call Hloop_AQ_V(ntryL,G2H4(43),ex1(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(46),ex1(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(52),ex1(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(53),ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(55),ex2(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(59),ex2(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hotf_5pt_reduction(G2H6(76),RedSet_5(9),mass5set(:,1),  & 
G1H6(253),G1H6(254),G1H6(255),G1H6(256),G1H6(257),G1H6(258),6)
  call HG1shiftOLR(G1H6(254),2,6)
  call Hotf_5pt_reduction(G2H6(78),RedSet_5(34),mass5set(:,1),  & 
G1H6(259),G1H6(260),G1H6(261),G1H6(262),G1H6(263),G1H6(264),6)
  call HG1shiftOLR(G1H6(260),2,6)
  call Hotf_4pt_reduction(G2H6(82),RedSet_4(1),mass4set(:,1),  & 
G1H6(265),G1H6(266),G1H6(267),G1H6(268),G1H6(269),6)
  call HG1shiftOLR(G1H6(266),26,6)
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(8),mass5set(:,1),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),2,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(34),mass5set(:,1),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),2,4)
  call Hotf_4pt_reduction(G2H4(66),RedSet_4(1),mass4set(:,1),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),4)
  call HG1shiftOLR(G1H4(140),26,4)
  call Hloop_AQ_V(ntryL,G2H4(67),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(69),ex1(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(73),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(74),ex2(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(77),ex2(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(83),ex2(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H4(84),RedSet_5(12),mass5set(:,1),  & 
G1H4(144),G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),4)
  call HG1shiftOLR(G1H4(145),2,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(39),mass5set(:,1),  & 
G1H4(150),G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),4)
  call HG1shiftOLR(G1H4(151),2,4)
  call Hotf_4pt_reduction(G2H4(90),RedSet_4(2),mass4set(:,1),  & 
G1H4(156),G1H4(157),G1H4(158),G1H4(159),G1H4(160),4)
  call HG1shiftOLR(G1H4(157),22,4)
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(11),mass5set(:,1),  & 
G1H4(161),G1H4(162),G1H4(163),G1H4(164),G1H4(165),G1H4(166),4)
  call HG1shiftOLR(G1H4(162),2,4)
  call Hotf_5pt_reduction(G2H4(93),RedSet_5(39),mass5set(:,1),  & 
G1H4(167),G1H4(168),G1H4(169),G1H4(170),G1H4(171),G1H4(172),4)
  call HG1shiftOLR(G1H4(168),2,4)
  call Hotf_4pt_reduction(G2H4(97),RedSet_4(2),mass4set(:,1),  & 
G1H4(173),G1H4(174),G1H4(175),G1H4(176),G1H4(177),4)
  call HG1shiftOLR(G1H4(174),22,4)
  call Hotf_5pt_reduction(G2H4(98),RedSet_5(13),mass5set(:,1),  & 
G1H4(178),G1H4(179),G1H4(180),G1H4(181),G1H4(182),G1H4(183),4)
  call HG1shiftOLR(G1H4(179),2,4)
  call Hotf_5pt_reduction(G2H4(100),RedSet_5(40),mass5set(:,1),  & 
G1H4(184),G1H4(185),G1H4(186),G1H4(187),G1H4(188),G1H4(189),4)
  call HG1shiftOLR(G1H4(185),2,4)
  call Hotf_4pt_reduction(G2H4(104),RedSet_4(3),mass4set(:,1),  & 
G1H4(190),G1H4(191),G1H4(192),G1H4(193),G1H4(194),4)
  call HG1shiftOLR(G1H4(191),14,4)
  call Hotf_5pt_reduction(G2H6(86),RedSet_5(14),mass5set(:,1),  & 
G1H6(270),G1H6(271),G1H6(272),G1H6(273),G1H6(274),G1H6(275),6)
  call HG1shiftOLR(G1H6(271),2,6)
  call Hotf_5pt_reduction(G2H6(88),RedSet_5(40),mass5set(:,1),  & 
G1H6(276),G1H6(277),G1H6(278),G1H6(279),G1H6(280),G1H6(281),6)
  call HG1shiftOLR(G1H6(277),2,6)
  call Hotf_4pt_reduction(G2H6(92),RedSet_4(3),mass4set(:,1),  & 
G1H6(282),G1H6(283),G1H6(284),G1H6(285),G1H6(286),6)
  call HG1shiftOLR(G1H6(283),14,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(19),[G1H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(31),[G1H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(43),[G1H6(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(55),[G1H6(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(67),[G1H6(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(79),[G1H6(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(91),[G1H6(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(103),[G1H6(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(115),[G1H6(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(127),[G1H6(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(139),[G1H6(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(151),[G1H6(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(163),[G1H6(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(175),[G1H6(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(187),[G1H6(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(199),[G1H6(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(211),[G1H6(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(223),[G1H6(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(235),[G1H6(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(247),[G1H6(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(259),[G1H6(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(265),[G1H6(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(150),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(156),[G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(167),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(173),[G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(184),[G1H4(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(190),[G1H4(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(276),[G1H6(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(282),[G1H6(281)])
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(13),n2h2(1))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-16,0,G2H4(1),n2h4(75))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(15),n2h2(2))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(14),-16,0,G2H4(3),n2h4(76))
  call Hloop_QV_A(ntryL,G2H4(3),ex5(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VA_Q(ntryL,G1H4(18),ex2(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(17),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(19),ex2(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(18),n2h2(4))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-16,0,G2H4(4),n2h4(77))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VA_Q(ntryL,G1H4(25),ex2(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(20),n2h2(5))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(26),-16,0,G2H4(6),n2h4(78))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VA_Q(ntryL,G1H4(30),ex2(:),G1H2(1),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(22),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H6(13),ex1(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(14),-8,0,G2H6(1),n2h6(63))
  call Hloop_AW_Q(ntryL,G2H6(1),ex4(:),G2H2(23),m3h3x2(:,1),heltab2x6(:,:,2))
  call Hloop_VQ_A(ntryL,G1H6(19),ex1(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(2),n2h3(2))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(20),-8,0,G2H6(3),n2h6(64))
  call Hloop_AW_Q(ntryL,G2H6(3),ex4(:),G2H2(24),m3h3x2(:,2),heltab2x6(:,:,4))
  call Hloop_VQ_A(ntryL,G1H6(24),ex1(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(3),n2h3(3))
  call Hloop_VQ_A(ntryL,G1H4(31),ex1(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(25),n2h2(7))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(32),-16,0,G2H4(7),n2h4(79))
  call Hloop_AV_Q(ntryL,G2H4(7),ex5(:),G2H2(26),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_VQ_A(ntryL,G1H4(37),ex1(:),G1H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(27),n2h2(8))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(38),-16,0,G2H4(9),n2h4(80))
  call Hloop_AV_Q(ntryL,G2H4(9),ex5(:),G2H2(28),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_VQ_A(ntryL,G1H4(42),ex1(:),G1H2(1),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(29),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(43),ex1(:),G1H2(1),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(30),n2h2(10))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-16,0,G2H4(10),n2h4(81))
  call Hloop_AV_Q(ntryL,G2H4(10),ex5(:),G2H2(31),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_VQ_A(ntryL,G1H4(49),ex1(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(32),n2h2(11))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-16,0,G2H4(12),n2h4(82))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(33),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_VQ_A(ntryL,G1H4(54),ex1(:),G1H2(1),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(34),n2h2(12))
  call Hloop_VA_Q(ntryL,G1H6(25),ex2(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,6))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(4),n2h3(4))
call HGT_OLR(G1H6(26),1,1,6)
call HGT_invQ_OLR(G1H6(26),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(26),-8,0,G2H6(4),n2h6(65))
  call Hloop_QW_A(ntryL,G2H6(4),ex4(:),G2H2(35),m3h3x2(:,3),heltab2x6(:,:,7))
  call Hloop_VA_Q(ntryL,G1H6(31),ex2(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,8))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(5),n2h3(5))
call HGT_OLR(G1H6(32),1,1,6)
call HGT_invQ_OLR(G1H6(32),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(32),-8,0,G2H6(6),n2h6(66))
  call Hloop_QW_A(ntryL,G2H6(6),ex4(:),G2H2(36),m3h3x2(:,4),heltab2x6(:,:,9))
  call Hloop_VA_Q(ntryL,G1H6(36),ex2(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,10))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(6),n2h3(6))
  call Hloop_QV_A(ntryL,G1H4(55),ex3(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(37),n2h2(13))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-16,0,G2H4(13),n2h4(83))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(38),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QV_A(ntryL,G1H4(61),ex3(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(39),n2h2(14))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(62),-16,0,G2H4(16),n2h4(84))
  call Hloop_AV_Q(ntryL,G2H4(16),ex5(:),G2H2(40),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QV_A(ntryL,G1H4(66),ex3(:),G1H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(41),n2h2(15))
  call Hloop_AW_Q(ntryL,G1H6(37),ex4(:),G1H2(1),m3h3x2(:,5),heltab2x6(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(42),n2h2(16))
call HGT_OLR(G1H6(38),1,1,6)
call HGT_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(38),-16,0,G2H6(7),n2h6(67))
  call Hloop_QV_A(ntryL,G2H6(7),ex5(:),G2H3(7),m3h2x3(:,7),heltab2x6(:,:,12))
  call Hloop_AW_Q(ntryL,G1H6(43),ex4(:),G1H2(1),m3h3x2(:,6),heltab2x6(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(43),n2h2(17))
call HGT_OLR(G1H6(44),1,1,6)
call HGT_invQ_OLR(G1H6(44),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(44),-16,0,G2H6(10),n2h6(68))
  call Hloop_QV_A(ntryL,G2H6(10),ex5(:),G2H3(8),m3h2x3(:,8),heltab2x6(:,:,14))
  call Hloop_AW_Q(ntryL,G1H6(48),ex4(:),G1H2(1),m3h3x2(:,7),heltab2x6(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(44),n2h2(18))
  call Hloop_AV_Q(ntryL,G1H6(49),ex5(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,16))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(9),n2h3(7))
call HGT_OLR(G1H6(50),1,1,6)
call HGT_invQ_OLR(G1H6(50),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(50),-8,0,G2H6(11),n2h6(69))
  call Hloop_QW_A(ntryL,G2H6(11),ex4(:),G2H2(45),m3h3x2(:,8),heltab2x6(:,:,17))
  call Hloop_AV_Q(ntryL,G1H6(55),ex5(:),G1H3(1),m3h2x3(:,10),heltab2x6(:,:,18))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(10),n2h3(8))
call HGT_OLR(G1H6(56),1,1,6)
call HGT_invQ_OLR(G1H6(56),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(56),-8,0,G2H6(13),n2h6(70))
  call Hloop_QW_A(ntryL,G2H6(13),ex4(:),G2H2(46),m3h3x2(:,9),heltab2x6(:,:,19))
  call Hloop_AV_Q(ntryL,G1H6(60),ex5(:),G1H3(1),m3h2x3(:,11),heltab2x6(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(11),n2h3(9))
  call Hloop_QW_A(ntryL,G1H6(61),ex4(:),G1H2(1),m3h3x2(:,10),heltab2x6(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(47),n2h2(19))
call HGT_OLR(G1H6(62),1,1,6)
call HGT_invQ_OLR(G1H6(62),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(62),-16,0,G2H6(14),n2h6(71))
  call Hloop_AV_Q(ntryL,G2H6(14),ex5(:),G2H3(12),m3h2x3(:,12),heltab2x6(:,:,22))
  call Hloop_QW_A(ntryL,G1H6(67),ex4(:),G1H2(1),m3h3x2(:,11),heltab2x6(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(48),n2h2(20))
call HGT_OLR(G1H6(68),1,1,6)
call HGT_invQ_OLR(G1H6(68),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(68),-16,0,G2H6(17),n2h6(72))
  call Hloop_AV_Q(ntryL,G2H6(17),ex5(:),G2H3(13),m3h2x3(:,13),heltab2x6(:,:,24))
  call Hloop_QW_A(ntryL,G1H6(72),ex4(:),G1H2(1),m3h3x2(:,12),heltab2x6(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(49),n2h2(21))
  call Hloop_QV_A(ntryL,G1H6(73),ex5(:),G1H3(1),m3h2x3(:,14),heltab2x6(:,:,26))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(14),n2h3(10))
call HGT_OLR(G1H6(74),1,1,6)
call HGT_invQ_OLR(G1H6(74),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(74),-8,0,G2H6(18),n2h6(73))
  call Hloop_AW_Q(ntryL,G2H6(18),ex4(:),G2H2(50),m3h3x2(:,13),heltab2x6(:,:,27))
  call Hloop_QV_A(ntryL,G1H6(79),ex5(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(15),n2h3(11))
call HGT_OLR(G1H6(80),1,1,6)
call HGT_invQ_OLR(G1H6(80),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(80),-8,0,G2H6(20),n2h6(74))
  call Hloop_AW_Q(ntryL,G2H6(20),ex4(:),G2H2(51),m3h3x2(:,14),heltab2x6(:,:,29))
  call Hloop_QV_A(ntryL,G1H6(84),ex5(:),G1H3(1),m3h2x3(:,16),heltab2x6(:,:,30))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(16),n2h3(12))
  call Hloop_AV_Q(ntryL,G1H4(67),ex3(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(52),n2h2(22))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(68),-16,0,G2H4(19),n2h4(85))
  call Hloop_QV_A(ntryL,G2H4(19),ex5(:),G2H2(53),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AV_Q(ntryL,G1H4(73),ex3(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(54),n2h2(23))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(74),-16,0,G2H4(22),n2h4(86))
  call Hloop_QV_A(ntryL,G2H4(22),ex5(:),G2H2(55),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AV_Q(ntryL,G1H4(78),ex3(:),G1H2(1),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(56),n2h2(24))
  call Hloop_QW_A(ntryL,G1H6(85),ex4(:),G1H2(1),m3h3x2(:,15),heltab2x6(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(57),n2h2(25))
call HGT_OLR(G1H6(86),1,1,6)
call HGT_invQ_OLR(G1H6(86),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(86),-16,0,G2H6(21),n2h6(75))
  call Hloop_AV_Q(ntryL,G2H6(21),ex5(:),G2H3(17),m3h2x3(:,17),heltab2x6(:,:,32))
  call Hloop_QW_A(ntryL,G1H6(91),ex4(:),G1H2(1),m3h3x2(:,16),heltab2x6(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(58),n2h2(26))
call HGT_OLR(G1H6(92),1,1,6)
call HGT_invQ_OLR(G1H6(92),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(92),-16,0,G2H6(24),n2h6(76))
  call Hloop_AV_Q(ntryL,G2H6(24),ex5(:),G2H3(18),m3h2x3(:,18),heltab2x6(:,:,34))
  call Hloop_QW_A(ntryL,G1H6(96),ex4(:),G1H2(1),m3h3x2(:,17),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(59),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(79),ex3(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(60),n2h2(28))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(80),-16,0,G2H4(23),n2h4(87))
  call Hloop_AV_Q(ntryL,G2H4(23),ex5(:),G2H2(61),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_QV_A(ntryL,G1H4(85),ex3(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(62),n2h2(29))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(86),-16,0,G2H4(25),n2h4(88))
  call Hloop_AV_Q(ntryL,G2H4(25),ex5(:),G2H2(63),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_QV_A(ntryL,G1H4(90),ex3(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(64),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(91),ex5(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(65),n2h2(31))
call HGT_OLR(G1H4(92),1,1,4)
call HGT_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(92),-4,0,G2H4(26),n2h4(89))
  call Hloop_AV_Q(ntryL,G2H4(26),ex3(:),G2H2(66),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_QV_A(ntryL,G1H4(97),ex5(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(67),n2h2(32))
call HGT_OLR(G1H4(98),1,1,4)
call HGT_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(98),-4,0,G2H4(28),n2h4(90))
  call Hloop_AV_Q(ntryL,G2H4(28),ex3(:),G2H2(68),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_QV_A(ntryL,G1H4(102),ex5(:),G1H2(1),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(69),n2h2(33))
  call Hloop_QV_A(ntryL,G1H6(97),ex5(:),G1H3(1),m3h2x3(:,19),heltab2x6(:,:,36))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(19),n2h3(13))
call HGT_OLR(G1H6(98),1,1,6)
call HGT_invQ_OLR(G1H6(98),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(98),-8,0,G2H6(27),n2h6(77))
  call Hloop_AW_Q(ntryL,G2H6(27),ex4(:),G2H2(70),m3h3x2(:,18),heltab2x6(:,:,37))
  call Hloop_QV_A(ntryL,G1H6(103),ex5(:),G1H3(1),m3h2x3(:,20),heltab2x6(:,:,38))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(20),n2h3(14))
call HGT_OLR(G1H6(104),1,1,6)
call HGT_invQ_OLR(G1H6(104),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(104),-8,0,G2H6(29),n2h6(78))
  call Hloop_AW_Q(ntryL,G2H6(29),ex4(:),G2H2(71),m3h3x2(:,19),heltab2x6(:,:,39))
  call Hloop_QV_A(ntryL,G1H6(108),ex5(:),G1H3(1),m3h2x3(:,21),heltab2x6(:,:,40))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(21),n2h3(15))
  call Hloop_QV_A(ntryL,G1H6(109),ex3(:),G1H3(1),m3h2x3(:,22),heltab2x6(:,:,41))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(22),n2h3(16))
call HGT_OLR(G1H6(110),1,1,6)
call HGT_invQ_OLR(G1H6(110),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(110),-8,0,G2H6(30),n2h6(79))
  call Hloop_AW_Q(ntryL,G2H6(30),ex4(:),G2H2(72),m3h3x2(:,20),heltab2x6(:,:,42))
  call Hloop_QV_A(ntryL,G1H6(115),ex3(:),G1H3(1),m3h2x3(:,23),heltab2x6(:,:,43))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(23),n2h3(17))
call HGT_OLR(G1H6(116),1,1,6)
call HGT_invQ_OLR(G1H6(116),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(116),-8,0,G2H6(32),n2h6(80))
  call Hloop_AW_Q(ntryL,G2H6(32),ex4(:),G2H2(73),m3h3x2(:,21),heltab2x6(:,:,44))
  call Hloop_QV_A(ntryL,G1H6(120),ex3(:),G1H3(1),m3h2x3(:,24),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(24),n2h3(18))
  call Hloop_QW_A(ntryL,G1H6(121),ex4(:),G1H2(1),m3h3x2(:,22),heltab2x6(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(74),n2h2(34))
call HGT_OLR(G1H6(122),1,1,6)
call HGT_invQ_OLR(G1H6(122),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(122),-4,0,G2H6(33),n2h6(81))
  call Hloop_AV_Q(ntryL,G2H6(33),ex3(:),G2H3(25),m3h2x3(:,25),heltab2x6(:,:,47))
  call Hloop_QW_A(ntryL,G1H6(127),ex4(:),G1H2(1),m3h3x2(:,23),heltab2x6(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(75),n2h2(35))
call HGT_OLR(G1H6(128),1,1,6)
call HGT_invQ_OLR(G1H6(128),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(128),-4,0,G2H6(36),n2h6(82))
  call Hloop_AV_Q(ntryL,G2H6(36),ex3(:),G2H3(26),m3h2x3(:,26),heltab2x6(:,:,49))
  call Hloop_QW_A(ntryL,G1H6(132),ex4(:),G1H2(1),m3h3x2(:,24),heltab2x6(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(76),n2h2(36))
  call Hloop_AW_Q(ntryL,G1H6(133),ex4(:),G1H2(1),m3h3x2(:,25),heltab2x6(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(77),n2h2(37))
call HGT_OLR(G1H6(134),1,1,6)
call HGT_invQ_OLR(G1H6(134),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(134),-16,0,G2H6(37),n2h6(83))
  call Hloop_QV_A(ntryL,G2H6(37),ex5(:),G2H3(27),m3h2x3(:,27),heltab2x6(:,:,52))
  call Hloop_AW_Q(ntryL,G1H6(139),ex4(:),G1H2(1),m3h3x2(:,26),heltab2x6(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(78),n2h2(38))
call HGT_OLR(G1H6(140),1,1,6)
call HGT_invQ_OLR(G1H6(140),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(140),-16,0,G2H6(40),n2h6(84))
  call Hloop_QV_A(ntryL,G2H6(40),ex5(:),G2H3(28),m3h2x3(:,28),heltab2x6(:,:,54))
  call Hloop_AW_Q(ntryL,G1H6(144),ex4(:),G1H2(1),m3h3x2(:,27),heltab2x6(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(79),n2h2(39))
  call Hloop_AV_Q(ntryL,G1H6(145),ex5(:),G1H3(1),m3h2x3(:,29),heltab2x6(:,:,56))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(29),n2h3(19))
call HGT_OLR(G1H6(146),1,1,6)
call HGT_invQ_OLR(G1H6(146),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(146),-8,0,G2H6(41),n2h6(85))
  call Hloop_QW_A(ntryL,G2H6(41),ex4(:),G2H2(80),m3h3x2(:,28),heltab2x6(:,:,57))
  call Hloop_AV_Q(ntryL,G1H6(151),ex5(:),G1H3(1),m3h2x3(:,30),heltab2x6(:,:,58))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(30),n2h3(20))
call HGT_OLR(G1H6(152),1,1,6)
call HGT_invQ_OLR(G1H6(152),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(152),-8,0,G2H6(43),n2h6(86))
  call Hloop_QW_A(ntryL,G2H6(43),ex4(:),G2H2(81),m3h3x2(:,29),heltab2x6(:,:,59))
  call Hloop_AV_Q(ntryL,G1H6(156),ex5(:),G1H3(1),m3h2x3(:,31),heltab2x6(:,:,60))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(31),n2h3(21))
  call Hloop_AV_Q(ntryL,G1H4(103),ex3(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(82),n2h2(40))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(104),-16,0,G2H4(32),n2h4(91))
  call Hloop_QV_A(ntryL,G2H4(32),ex5(:),G2H2(83),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_AV_Q(ntryL,G1H4(109),ex3(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(84),n2h2(41))
call HGT_OLR(G1H4(110),1,1,4)
call HGT_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(110),-16,0,G2H4(34),n2h4(92))
  call Hloop_QV_A(ntryL,G2H4(34),ex5(:),G2H2(85),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AV_Q(ntryL,G1H4(114),ex3(:),G1H2(1),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(86),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H4(115),ex5(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(87),n2h2(43))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(116),-4,0,G2H4(35),n2h4(93))
  call Hloop_QV_A(ntryL,G2H4(35),ex3(:),G2H2(88),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AV_Q(ntryL,G1H4(121),ex5(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(89),n2h2(44))
call HGT_OLR(G1H4(122),1,1,4)
call HGT_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(122),-4,0,G2H4(37),n2h4(94))
  call Hloop_QV_A(ntryL,G2H4(37),ex3(:),G2H2(90),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_AV_Q(ntryL,G1H4(126),ex5(:),G1H2(1),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(91),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H6(157),ex3(:),G1H3(1),m3h2x3(:,32),heltab2x6(:,:,61))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(32),n2h3(22))
call HGT_OLR(G1H6(158),1,1,6)
call HGT_invQ_OLR(G1H6(158),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(158),-8,0,G2H6(46),n2h6(87))
  call Hloop_QW_A(ntryL,G2H6(46),ex4(:),G2H2(92),m3h3x2(:,30),heltab2x6(:,:,62))
  call Hloop_AV_Q(ntryL,G1H6(163),ex3(:),G1H3(1),m3h2x3(:,33),heltab2x6(:,:,63))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(33),n2h3(23))
call HGT_OLR(G1H6(164),1,1,6)
call HGT_invQ_OLR(G1H6(164),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(164),-8,0,G2H6(48),n2h6(88))
  call Hloop_QW_A(ntryL,G2H6(48),ex4(:),G2H2(93),m3h3x2(:,31),heltab2x6(:,:,64))
  call Hloop_AV_Q(ntryL,G1H6(168),ex3(:),G1H3(1),m3h2x3(:,34),heltab2x6(:,:,65))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(34),n2h3(24))
  call Hloop_AW_Q(ntryL,G1H6(169),ex4(:),G1H2(1),m3h3x2(:,32),heltab2x6(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(94),n2h2(46))
call HGT_OLR(G1H6(170),1,1,6)
call HGT_invQ_OLR(G1H6(170),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(170),-4,0,G2H6(49),n2h6(89))
  call Hloop_QV_A(ntryL,G2H6(49),ex3(:),G2H3(35),m3h2x3(:,35),heltab2x6(:,:,67))
  call Hloop_AW_Q(ntryL,G1H6(175),ex4(:),G1H2(1),m3h3x2(:,33),heltab2x6(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(95),n2h2(47))
call HGT_OLR(G1H6(176),1,1,6)
call HGT_invQ_OLR(G1H6(176),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(176),-4,0,G2H6(52),n2h6(90))
  call Hloop_QV_A(ntryL,G2H6(52),ex3(:),G2H3(36),m3h2x3(:,36),heltab2x6(:,:,69))
  call Hloop_AW_Q(ntryL,G1H6(180),ex4(:),G1H2(1),m3h3x2(:,34),heltab2x6(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(96),n2h2(48))
  call Hloop_VA_Q(ntryL,G1H6(181),ex2(:),G1H3(1),m3h2x3(:,37),heltab2x6(:,:,71))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(37),n2h3(25))
call HGT_OLR(G1H6(182),1,1,6)
call HGT_invQ_OLR(G1H6(182),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(182),-8,0,G2H6(53),n2h6(91))
  call Hloop_QW_A(ntryL,G2H6(53),ex4(:),G2H2(97),m3h3x2(:,35),heltab2x6(:,:,72))
  call Hloop_VA_Q(ntryL,G1H6(187),ex2(:),G1H3(1),m3h2x3(:,38),heltab2x6(:,:,73))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(38),n2h3(26))
call HGT_OLR(G1H6(188),1,1,6)
call HGT_invQ_OLR(G1H6(188),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(188),-8,0,G2H6(55),n2h6(92))
  call Hloop_QW_A(ntryL,G2H6(55),ex4(:),G2H2(98),m3h3x2(:,36),heltab2x6(:,:,74))
  call Hloop_VA_Q(ntryL,G1H6(192),ex2(:),G1H3(1),m3h2x3(:,39),heltab2x6(:,:,75))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(39),n2h3(27))
  call Hloop_QV_A(ntryL,G1H6(193),ex3(:),G1H3(1),m3h2x3(:,40),heltab2x6(:,:,76))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(40),n2h3(28))
call HGT_OLR(G1H6(194),1,1,6)
call HGT_invQ_OLR(G1H6(194),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(194),-8,0,G2H6(56),n2h6(93))
  call Hloop_AW_Q(ntryL,G2H6(56),ex4(:),G2H2(99),m3h3x2(:,37),heltab2x6(:,:,77))
  call Hloop_QV_A(ntryL,G1H6(199),ex3(:),G1H3(1),m3h2x3(:,41),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(41),n2h3(29))
call HGT_OLR(G1H6(200),1,1,6)
call HGT_invQ_OLR(G1H6(200),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(200),-8,0,G2H6(58),n2h6(94))
  call Hloop_AW_Q(ntryL,G2H6(58),ex4(:),G2H2(100),m3h3x2(:,38),heltab2x6(:,:,79))
  call Hloop_QV_A(ntryL,G1H6(204),ex3(:),G1H3(1),m3h2x3(:,42),heltab2x6(:,:,80))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(42),n2h3(30))
  call Hloop_VQ_A(ntryL,G1H6(205),ex1(:),G1H3(1),m3h2x3(:,43),heltab2x6(:,:,81))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(43),n2h3(31))
call HGT_OLR(G1H6(206),1,1,6)
call HGT_invQ_OLR(G1H6(206),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(206),-8,0,G2H6(59),n2h6(95))
  call Hloop_AW_Q(ntryL,G2H6(59),ex4(:),G2H2(101),m3h3x2(:,39),heltab2x6(:,:,82))
  call Hloop_VQ_A(ntryL,G1H6(211),ex1(:),G1H3(1),m3h2x3(:,44),heltab2x6(:,:,83))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(44),n2h3(32))
call HGT_OLR(G1H6(212),1,1,6)
call HGT_invQ_OLR(G1H6(212),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(212),-8,0,G2H6(61),n2h6(96))
  call Hloop_AW_Q(ntryL,G2H6(61),ex4(:),G2H2(102),m3h3x2(:,40),heltab2x6(:,:,84))
  call Hloop_VQ_A(ntryL,G1H6(216),ex1(:),G1H3(1),m3h2x3(:,45),heltab2x6(:,:,85))
  call Hloop_Q_A(ntryL,G1H3(1),55,0,G2H3(45),n2h3(33))
  call Hloop_QW_A(ntryL,G1H6(217),ex4(:),G1H2(1),m3h3x2(:,41),heltab2x6(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(103),n2h2(49))
call HGT_OLR(G1H6(218),1,1,6)
call HGT_invQ_OLR(G1H6(218),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(218),-4,0,G2H6(62),n2h6(97))
  call Hloop_AV_Q(ntryL,G2H6(62),ex3(:),G2H3(46),m3h2x3(:,46),heltab2x6(:,:,87))
  call Hloop_QW_A(ntryL,G1H6(223),ex4(:),G1H2(1),m3h3x2(:,42),heltab2x6(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(104),n2h2(50))
call HGT_OLR(G1H6(224),1,1,6)
call HGT_invQ_OLR(G1H6(224),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(224),-4,0,G2H6(65),n2h6(98))
  call Hloop_AV_Q(ntryL,G2H6(65),ex3(:),G2H3(47),m3h2x3(:,47),heltab2x6(:,:,89))
  call Hloop_QW_A(ntryL,G1H6(228),ex4(:),G1H2(1),m3h3x2(:,43),heltab2x6(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(1),59,0,G2H2(105),n2h2(51))
  call Hloop_AV_Q(ntryL,G1H6(229),ex3(:),G1H3(1),m3h2x3(:,48),heltab2x6(:,:,91))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(48),n2h3(34))
call HGT_OLR(G1H6(230),1,1,6)
call HGT_invQ_OLR(G1H6(230),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(230),-8,0,G2H6(66),n2h6(99))
  call Hloop_QW_A(ntryL,G2H6(66),ex4(:),G2H2(106),m3h3x2(:,44),heltab2x6(:,:,92))
  call Hloop_AV_Q(ntryL,G1H6(235),ex3(:),G1H3(1),m3h2x3(:,49),heltab2x6(:,:,93))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(49),n2h3(35))
call HGT_OLR(G1H6(236),1,1,6)
call HGT_invQ_OLR(G1H6(236),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(236),-8,0,G2H6(68),n2h6(100))
  call Hloop_QW_A(ntryL,G2H6(68),ex4(:),G2H2(107),m3h3x2(:,45),heltab2x6(:,:,94))
  call Hloop_AV_Q(ntryL,G1H6(240),ex3(:),G1H3(1),m3h2x3(:,50),heltab2x6(:,:,95))
  call Hloop_A_Q(ntryL,G1H3(1),55,0,G2H3(50),n2h3(36))
  call Hloop_AW_Q(ntryL,G1H6(241),ex4(:),G1H2(1),m3h3x2(:,46),heltab2x6(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(108),n2h2(52))
call HGT_OLR(G1H6(242),1,1,6)
call HGT_invQ_OLR(G1H6(242),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(242),-4,0,G2H6(69),n2h6(101))
  call Hloop_QV_A(ntryL,G2H6(69),ex3(:),G2H3(51),m3h2x3(:,51),heltab2x6(:,:,97))
  call Hloop_AW_Q(ntryL,G1H6(247),ex4(:),G1H2(1),m3h3x2(:,47),heltab2x6(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(109),n2h2(53))
call HGT_OLR(G1H6(248),1,1,6)
call HGT_invQ_OLR(G1H6(248),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(248),-4,0,G2H6(72),n2h6(102))
  call Hloop_QV_A(ntryL,G2H6(72),ex3(:),G2H3(52),m3h2x3(:,52),heltab2x6(:,:,99))
  call Hloop_AW_Q(ntryL,G1H6(252),ex4(:),G1H2(1),m3h3x2(:,48),heltab2x6(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(110),n2h2(54))
  call Hloop_QW_A(ntryL,G1H6(253),ex4(:),G1H2(1),m3h3x2(:,49),heltab2x6(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(1),61,0,G2H2(111),n2h2(55))
call HGT_raise_alpha_OLR(G1H6(254),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(254),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(254),ex2(:),G1H3(1),m3h2x3(:,53),heltab2x6(:,:,102))
  call Hloop_QW_A(ntryL,G1H6(259),ex4(:),G1H2(1),m3h3x2(:,50),heltab2x6(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(1),61,0,G2H2(112),n2h2(56))
call HGT_raise_alpha_OLR(G1H6(260),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(260),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(260),ex2(:),G1H3(2),m3h2x3(:,54),heltab2x6(:,:,104))
  call Hloop_QW_A(ntryL,G1H6(265),ex4(:),G1H2(1),m3h3x2(:,51),heltab2x6(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(1),61,0,G2H2(113),n2h2(57))
call HGT_raise_alpha_OLR(G1H6(266),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(266),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(266),ex2(:),G1H3(3),m3h2x3(:,55),heltab2x6(:,:,106))
  call Hloop_QV_A(ntryL,G1H4(127),ex5(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(1),61,0,G2H2(114),n2h2(58))
call HGT_raise_alpha_OLR(G1H4(128),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(128),ex2(:),G1H2(1),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QV_A(ntryL,G1H4(133),ex5(:),G1H2(2),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(2),61,0,G2H2(115),n2h2(59))
call HGT_raise_alpha_OLR(G1H4(134),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(134),ex2(:),G1H2(2),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_QV_A(ntryL,G1H4(139),ex5(:),G1H2(3),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(3),61,0,G2H2(116),n2h2(60))
call HGT_raise_alpha_OLR(G1H4(140),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(140),ex2(:),G1H2(3),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_QV_A(ntryL,G1H4(144),ex3(:),G1H2(4),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(4),61,0,G2H2(117),n2h2(61))
call HGT_raise_alpha_OLR(G1H4(145),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(145),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(145),ex2(:),G1H2(4),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_QV_A(ntryL,G1H4(150),ex3(:),G1H2(5),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(5),61,0,G2H2(118),n2h2(62))
call HGT_raise_alpha_OLR(G1H4(151),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(151),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(151),ex2(:),G1H2(5),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_QV_A(ntryL,G1H4(156),ex3(:),G1H2(6),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(6),61,0,G2H2(119),n2h2(63))
call HGT_raise_alpha_OLR(G1H4(157),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(157),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(157),ex2(:),G1H2(6),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_QV_A(ntryL,G1H4(161),ex5(:),G1H2(7),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(7),61,0,G2H2(120),n2h2(64))
call HGT_raise_alpha_OLR(G1H4(162),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(162),ex2(:),G1H2(7),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_QV_A(ntryL,G1H4(167),ex5(:),G1H2(8),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(8),61,0,G2H2(121),n2h2(65))
call HGT_raise_alpha_OLR(G1H4(168),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(168),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(168),ex2(:),G1H2(8),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_QV_A(ntryL,G1H4(173),ex5(:),G1H2(9),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(9),61,0,G2H2(122),n2h2(66))
call HGT_raise_alpha_OLR(G1H4(174),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(174),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(174),ex2(:),G1H2(9),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_QV_A(ntryL,G1H4(178),ex3(:),G1H2(10),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(10),61,0,G2H2(123),n2h2(67))
call HGT_raise_alpha_OLR(G1H4(179),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(179),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(179),ex2(:),G1H2(10),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_QV_A(ntryL,G1H4(184),ex3(:),G1H2(11),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(11),61,0,G2H2(124),n2h2(68))
call HGT_raise_alpha_OLR(G1H4(185),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(185),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(185),ex2(:),G1H2(11),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_QV_A(ntryL,G1H4(190),ex3(:),G1H2(12),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(12),61,0,G2H2(125),n2h2(69))
call HGT_raise_alpha_OLR(G1H4(191),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(191),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(191),ex2(:),G1H2(12),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_QW_A(ntryL,G1H6(270),ex4(:),G1H2(13),m3h3x2(:,52),heltab2x6(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(13),61,0,G2H2(126),n2h2(70))
call HGT_raise_alpha_OLR(G1H6(271),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(271),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(271),ex2(:),G1H3(4),m3h2x3(:,56),heltab2x6(:,:,108))
  call Hloop_QW_A(ntryL,G1H6(276),ex4(:),G1H2(13),m3h3x2(:,53),heltab2x6(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(13),61,0,G2H2(127),n2h2(71))
call HGT_raise_alpha_OLR(G1H6(277),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(277),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(277),ex2(:),G1H3(5),m3h2x3(:,57),heltab2x6(:,:,110))
  call Hloop_QW_A(ntryL,G1H6(282),ex4(:),G1H2(13),m3h3x2(:,54),heltab2x6(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(13),61,0,G2H2(128),n2h2(72))
call HGT_raise_alpha_OLR(G1H6(283),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(283),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(283),ex2(:),G1H3(6),m3h2x3(:,58),heltab2x6(:,:,112))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(7),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(8),mass5set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(10),mass5set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(11),mass5set(:,1),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(1),mass5set(:,1),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(2),mass5set(:,1),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(3),mass5set(:,1),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),G1H3(12),3)
  call HG1shiftOLR(G1H3(8),8,3)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(4),mass5set(:,1),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),16,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(5),mass5set(:,1),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(6),mass5set(:,1),  & 
G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),G1H3(18),3)
  call HG1shiftOLR(G1H3(14),8,3)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(15),mass5set(:,1),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),16,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(16),mass5set(:,1),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H3(9),RedSet_5(16),mass5set(:,1),  & 
G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),G1H3(24),3)
  call HG1shiftOLR(G1H3(20),8,3)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(17),mass5set(:,1),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hotf_5pt_reduction(G2H3(14),RedSet_5(17),mass5set(:,1),  & 
G1H3(25),G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),3)
  call HG1shiftOLR(G1H3(26),8,3)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(18),mass5set(:,1),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(19),mass5set(:,1),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),16,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(20),mass5set(:,1),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),16,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(20),mass5set(:,1),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),4,2)
  call Hotf_5pt_reduction(G2H3(19),RedSet_5(19),mass5set(:,1),  & 
G1H3(31),G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(32),8,3)
  call Hotf_5pt_reduction(G2H3(22),RedSet_5(21),mass5set(:,1),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),3)
  call HG1shiftOLR(G1H3(38),8,3)
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(21),mass5set(:,1),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),4,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(22),mass5set(:,1),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),16,2)
  call Hotf_5pt_reduction(G2H3(29),RedSet_5(22),mass5set(:,1),  & 
G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),G1H3(48),3)
  call HG1shiftOLR(G1H3(44),8,3)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(23),mass5set(:,1),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),16,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(23),mass5set(:,1),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),4,2)
  call Hotf_5pt_reduction(G2H3(32),RedSet_5(24),mass5set(:,1),  & 
G1H3(49),G1H3(50),G1H3(51),G1H3(52),G1H3(53),G1H3(54),3)
  call HG1shiftOLR(G1H3(50),8,3)
  call Hotf_5pt_reduction(G2H2(94),RedSet_5(24),mass5set(:,1),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),4,2)
  call Hotf_5pt_reduction(G2H3(37),RedSet_5(25),mass5set(:,1),  & 
G1H3(55),G1H3(56),G1H3(57),G1H3(58),G1H3(59),G1H3(60),3)
  call HG1shiftOLR(G1H3(56),8,3)
  call Hotf_5pt_reduction(G2H3(40),RedSet_5(26),mass5set(:,1),  & 
G1H3(61),G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),3)
  call HG1shiftOLR(G1H3(62),8,3)
  call Hotf_5pt_reduction(G2H3(43),RedSet_5(27),mass5set(:,1),  & 
G1H3(67),G1H3(68),G1H3(69),G1H3(70),G1H3(71),G1H3(72),3)
  call HG1shiftOLR(G1H3(68),8,3)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(26),mass5set(:,1),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),4,2)
  call Hotf_5pt_reduction(G2H3(48),RedSet_5(28),mass5set(:,1),  & 
G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),G1H3(78),3)
  call HG1shiftOLR(G1H3(74),8,3)
  call Hotf_5pt_reduction(G2H2(108),RedSet_5(28),mass5set(:,1),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(111),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(114),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(117),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(120),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(123),ex2(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(126),ex2(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(13),47,ex5(:),16,G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(14),0,ex5(:),16,G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(19),47,ex5(:),16,G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(20),0,ex5(:),16,G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(25),47,ex5(:),16,G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(26),0,ex5(:),16,G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(31),47,ex5(:),16,G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(32),0,ex5(:),16,G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hloop_AV_Q(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(5))
  call Hloop_AV_Q(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(16),n2h1(6))
  call Hloop_AV_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(7))
  call Hloop_AV_Q(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(18),n2h1(8))
  call Hloop_QW_A(ntryL,G1H3(7),ex4(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(9))
  call Hloop_QW_A(ntryL,G1H3(8),ex4(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(20),n2h1(10))
  call Hloop_QV_A(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(11))
  call Hloop_QV_A(ntryL,G1H2(50),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(22),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(24),n2h1(14))
  call Hloop_AW_Q(ntryL,G1H3(13),ex4(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(15))
  call Hloop_AW_Q(ntryL,G1H3(14),ex4(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(26),n2h1(16))
  call Hloop_QV_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(28),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(20))
  call Hloop_AW_Q(ntryL,G1H3(19),ex4(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(21))
  call Hloop_AW_Q(ntryL,G1H3(20),ex4(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(32),n2h1(22))
  call Hloop_QV_A(ntryL,G1H2(73),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(74),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(34),n2h1(24))
  call Hloop_QW_A(ntryL,G1H3(25),ex4(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(25))
  call Hloop_QW_A(ntryL,G1H3(26),ex4(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(36),n2h1(26))
  call Hloop_AV_Q(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(27))
  call Hloop_AV_Q(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(38),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(85),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(86),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(40),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(91),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(92),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(42),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(97),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(44),n2h1(34))
  call Hloop_QW_A(ntryL,G1H3(31),ex4(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(35))
  call Hloop_QW_A(ntryL,G1H3(32),ex4(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(46),n2h1(36))
  call Hloop_QW_A(ntryL,G1H3(37),ex4(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(37))
  call Hloop_QW_A(ntryL,G1H3(38),ex4(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(48),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(103),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(104),ex3(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(50),n2h1(40))
  call Hloop_AV_Q(ntryL,G1H2(109),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(52),n2h1(42))
  call Hloop_AW_Q(ntryL,G1H3(43),ex4(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(43))
  call Hloop_AW_Q(ntryL,G1H3(44),ex4(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(54),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H2(115),ex5(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H2(116),ex5(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(56),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H2(121),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(122),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(58),n2h1(48))
  call Hloop_AW_Q(ntryL,G1H3(49),ex4(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(49))
  call Hloop_AW_Q(ntryL,G1H3(50),ex4(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(60),n2h1(50))
  call Hloop_AV_Q(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(51))
  call Hloop_AV_Q(ntryL,G1H2(128),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(62),n2h1(52))
  call Hloop_AW_Q(ntryL,G1H3(55),ex4(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(53))
  call Hloop_AW_Q(ntryL,G1H3(56),ex4(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(64),n2h1(54))
  call Hloop_QW_A(ntryL,G1H3(61),ex4(:),G1H1(1),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(55))
  call Hloop_QW_A(ntryL,G1H3(62),ex4(:),G1H1(1),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(66),n2h1(56))
  call Hloop_QW_A(ntryL,G1H3(67),ex4(:),G1H1(1),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(57))
  call Hloop_QW_A(ntryL,G1H3(68),ex4(:),G1H1(1),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(68),n2h1(58))
  call Hloop_QV_A(ntryL,G1H2(133),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(134),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(70),n2h1(60))
  call Hloop_AW_Q(ntryL,G1H3(73),ex4(:),G1H1(1),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(61))
  call Hloop_AW_Q(ntryL,G1H3(74),ex4(:),G1H1(1),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(72),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H2(139),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(63))
  call Hloop_AV_Q(ntryL,G1H2(140),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(74),n2h1(64))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(9),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(8),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(12),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),2)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(11),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),2)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(13),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),2)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(14),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(7),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(8),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(10),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(11),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(1),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(2),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(3),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(4),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(5),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(6),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(15),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(16),mass5set(:,1),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(16),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(17),mass5set(:,1),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(17),mass5set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(18),mass5set(:,1),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(19),mass5set(:,1),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(20),mass5set(:,1),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(20),mass5set(:,1),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(19),mass5set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(21),mass5set(:,1),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(21),mass5set(:,1),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(22),mass5set(:,1),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(22),mass5set(:,1),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(23),mass5set(:,1),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(23),mass5set(:,1),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(24),mass5set(:,1),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(24),mass5set(:,1),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),4)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(25),mass5set(:,1),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),8)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(26),mass5set(:,1),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(27),mass5set(:,1),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(26),mass5set(:,1),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(28),mass5set(:,1),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(28),mass5set(:,1),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(41),h0tab(:,41),[48,1,4,8,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H96(1),ex6(:),ex5(:),G0H24(1),m4h2x2x24(:,1),heltab3x96(:,:,1))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)-c(25)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(42),h0tab(:,42),[48,1,4,8,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H96(1),ex5(:),ex6(:),G0H24(2),m4h2x2x24(:,2),heltab3x96(:,:,2))
  Gcoeff(:)%j = (c(27)*(-M(1,:)%j+M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(43),h0tab(:,43),[48,1,4,8,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H96(1),ex6(:),ex5(:),G0H24(3),m4h2x2x24(:,3),heltab3x96(:,:,3))
  Gcoeff(:)%j = (c(23)*M(2,:)%j+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(44),h0tab(:,44),[48,1,8,4,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H96(1),ex6(:),ex5(:),G0H24(4),m4h2x2x24(:,4),heltab3x96(:,:,4))
  Gcoeff(:)%j = (c(23)*M(1,:)%j+c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(45),h0tab(:,45),[48,1,8,4,2],[0,0,0,0,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H96(1),ex5(:),ex6(:),G0H24(5),m4h2x2x24(:,5),heltab3x96(:,:,5))



end subroutine vamp_1

end module ol_vamp_1_ppwajj_udxawgg_1_/**/REALKIND
