
module ol_vamp_10_ppwajj_udxawgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_10(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwajj_udxawgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwajj_udxawgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwajj_udxawgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwajj_udxawgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwajj_udxawgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwajj_udxawgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(105),n2h48(257))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(588),h0tab(:,588),[32,4,27],[0,0,0],3,1,wf24(:,48))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,360),heltab2x96(:,:,543))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(106),n2h48(258))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(589),h0tab(:,589),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,48))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,361),heltab2x96(:,:,544))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(107),n2h48(259))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(590),h0tab(:,590),[32,4,27],[0,0,0],3,1,wf24(:,48))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,362),heltab2x96(:,:,545))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(108),n2h48(260))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(591),h0tab(:,591),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,48))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,363),heltab2x96(:,:,546))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(109),n2h48(261))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(300)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(592),h0tab(:,592),[32,2,29],[0,0,0],3,1,wf24(:,50))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,364),heltab2x96(:,:,547))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(110),n2h48(262))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(300)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(593),h0tab(:,593),[32,2,29],[0,0,0],3,1,wf24(:,50))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(111),m3h2x48(:,365),heltab2x96(:,:,548))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(594),h0tab(:,594),[57,2,4],[0,0,0],3,1,wf24(:,52))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,52),G0H4(7),m3h24x4(:,28),heltab2x96(:,:,549))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(595),h0tab(:,595),[43,4,16],[0,0,0],3,1,wf24(:,53))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,53),G0H4(8),m3h24x4(:,29),heltab2x96(:,:,550))
  call Hloop_A_Q(ntryL,G0H4(8),43,0,G1H4(161),n2h4(548))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(596),h0tab(:,596),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,53))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,53),G0H4(8),m3h24x4(:,30),heltab2x96(:,:,551))
  call Hloop_A_Q(ntryL,G0H4(8),43,nMT,G1H4(178),n2h4(549))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(597),h0tab(:,597),[43,4,16],[0,0,0],3,1,wf24(:,53))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,53),G0H4(8),m3h24x4(:,31),heltab2x96(:,:,552))
  call Hloop_Q_A(ntryL,G0H4(8),43,0,G1H4(204),n2h4(550))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(598),h0tab(:,598),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,53))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,53),G0H4(8),m3h24x4(:,32),heltab2x96(:,:,553))
  call Hloop_Q_A(ntryL,G0H4(8),43,nMT,G1H4(58),n2h4(551))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(599),h0tab(:,599),[43,4,16],[0,0,0],3,1,wf24(:,53))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,53),G0H4(8),m3h24x4(:,33),heltab2x96(:,:,554))
  call Hloop_A_Q(ntryL,G0H4(8),43,0,G1H4(263),n2h4(552))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(600),h0tab(:,600),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,53))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,53),G0H4(8),m3h24x4(:,34),heltab2x96(:,:,555))
  call Hloop_A_Q(ntryL,G0H4(8),43,nMB,G1H4(24),n2h4(553))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(601),h0tab(:,601),[43,4,16],[0,0,0],3,1,wf24(:,53))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,53),G0H4(8),m3h24x4(:,35),heltab2x96(:,:,556))
  call Hloop_Q_A(ntryL,G0H4(8),43,0,G1H4(179),n2h4(554))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(602),h0tab(:,602),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,53))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,53),G0H4(8),m3h24x4(:,36),heltab2x96(:,:,557))
  call Hloop_Q_A(ntryL,G0H4(8),43,nMB,G1H4(12),n2h4(555))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(603),h0tab(:,603),[45,2,16],[0,0,0],3,1,wf24(:,55))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,55),G0H4(8),m3h24x4(:,37),heltab2x96(:,:,558))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(604),h0tab(:,604),[45,2,16],[0,0,0],3,1,wf24(:,55))
  call Hloop_VQ_A(ntryL,G0H96(1),wf24(:,55),G0H4(9),m3h24x4(:,38),heltab2x96(:,:,559))
  call Hloop_Q_A(ntryL,G0H4(9),45,0,G1H4(155),n2h4(556))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(304)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(605),h0tab(:,605),[57,2,4],[0,0,0],3,1,wf24(:,57))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,57),G0H4(9),m3h24x4(:,39),heltab2x96(:,:,560))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(606),h0tab(:,606),[32,10,21],[0,0,0],3,2,wf6(:,2),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,366),heltab2x96(:,:,561))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(112),n2h48(263))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(607),h0tab(:,607),[32,10,21],[0,0,0],3,2,wf6(:,2),wf8(:,20))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(113),m3h2x48(:,367),heltab2x96(:,:,562))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(608),h0tab(:,608),[49,4,10],[0,0,0],3,2,wf8(:,41),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf8(:,41),G0H12(10),m3h8x12(:,42),heltab2x96(:,:,563))
  call Hloop_Q_A(ntryL,G0H12(10),49,0,G1H12(203),n2h12(372))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(609),h0tab(:,609),[32,14,17],[0,0,0],3,2,wf12(:,22),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,368),heltab2x96(:,:,564))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(114),n2h48(264))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(610),h0tab(:,610),[32,14,17],[0,0,0],3,2,wf12(:,22),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(115),m3h2x48(:,369),heltab2x96(:,:,565))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(611),h0tab(:,611),[42,4,17],[0,0,0],3,2,wf12(:,31),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,31),G0H8(4),m3h12x8(:,22),heltab2x96(:,:,566))
  call Hloop_A_Q(ntryL,G0H8(4),42,0,G1H8(58),n2h8(170))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(612),h0tab(:,612),[32,4,27],[0,0,0],3,1,wf24(:,58))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,370),heltab2x96(:,:,567))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(116),n2h48(265))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(613),h0tab(:,613),[32,4,27],[nMT,nMT,nMT],3,1,wf24(:,58))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,371),heltab2x96(:,:,568))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(117),n2h48(266))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(614),h0tab(:,614),[32,4,27],[0,0,0],3,1,wf24(:,58))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,372),heltab2x96(:,:,569))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(118),n2h48(267))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(615),h0tab(:,615),[32,4,27],[nMT,nMT,nMT],3,1,wf24(:,58))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,373),heltab2x96(:,:,570))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(119),n2h48(268))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(616),h0tab(:,616),[32,4,27],[0,0,0],3,1,wf24(:,58))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,374),heltab2x96(:,:,571))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(120),n2h48(269))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(617),h0tab(:,617),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,58))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,375),heltab2x96(:,:,572))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(121),n2h48(270))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(618),h0tab(:,618),[32,4,27],[0,0,0],3,1,wf24(:,58))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,376),heltab2x96(:,:,573))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(122),n2h48(271))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(619),h0tab(:,619),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,58))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,377),heltab2x96(:,:,574))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(123),n2h48(272))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(620),h0tab(:,620),[37,10,16],[0,0,0],3,2,wf8(:,22),wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,22),G0H12(13),m3h8x12(:,43),heltab2x96(:,:,575))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(621),h0tab(:,621),[37,10,16],[0,0,0],3,2,wf8(:,22),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf8(:,22),G0H12(14),m3h8x12(:,44),heltab2x96(:,:,576))
  call Hloop_Q_A(ntryL,G0H12(14),37,0,G1H12(212),n2h12(373))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(622),h0tab(:,622),[49,4,10],[0,0,0],3,2,wf8(:,42),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf8(:,42),G0H12(2),m3h8x12(:,45),heltab2x96(:,:,577))
  call Hloop_Q_A(ntryL,G0H12(2),49,0,G1H12(210),n2h12(374))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(623),h0tab(:,623),[33,14,16],[0,0,0],3,2,wf4(:,13),wf12(:,22))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,13),G0H24(28),m3h4x24(:,89),heltab2x96(:,:,578))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(624),h0tab(:,624),[33,14,16],[0,0,0],3,2,wf4(:,13),wf12(:,22))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(29),m3h4x24(:,90),heltab2x96(:,:,579))
  call Hloop_Q_A(ntryL,G0H24(29),33,0,G1H24(131),n2h24(238))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(625),h0tab(:,625),[33,4,26],[0,0,0],3,2,wf4(:,13),wf12(:,3))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(29),m3h4x24(:,91),heltab2x96(:,:,580))
  call Hloop_Q_A(ntryL,G0H24(29),33,0,G1H24(137),n2h24(239))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(626),h0tab(:,626),[43,4,16],[0,0,0],3,1,wf24(:,59))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,59),G0H4(10),m3h24x4(:,40),heltab2x96(:,:,581))
  call Hloop_A_Q(ntryL,G0H4(10),43,0,G1H4(276),n2h4(557))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(627),h0tab(:,627),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,59))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,59),G0H4(10),m3h24x4(:,41),heltab2x96(:,:,582))
  call Hloop_A_Q(ntryL,G0H4(10),43,nMT,G1H4(270),n2h4(558))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(628),h0tab(:,628),[43,4,16],[0,0,0],3,1,wf24(:,59))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,59),G0H4(10),m3h24x4(:,42),heltab2x96(:,:,583))
  call Hloop_Q_A(ntryL,G0H4(10),43,0,G1H4(74),n2h4(559))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(629),h0tab(:,629),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,59))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,59),G0H4(10),m3h24x4(:,43),heltab2x96(:,:,584))
  call Hloop_Q_A(ntryL,G0H4(10),43,nMT,G1H4(172),n2h4(560))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(630),h0tab(:,630),[43,4,16],[0,0,0],3,1,wf24(:,59))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,59),G0H4(10),m3h24x4(:,44),heltab2x96(:,:,585))
  call Hloop_A_Q(ntryL,G0H4(10),43,0,G1H4(255),n2h4(561))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(631),h0tab(:,631),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,59))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,59),G0H4(10),m3h24x4(:,45),heltab2x96(:,:,586))
  call Hloop_A_Q(ntryL,G0H4(10),43,nMB,G1H4(13),n2h4(562))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(632),h0tab(:,632),[43,4,16],[0,0,0],3,1,wf24(:,59))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,59),G0H4(10),m3h24x4(:,46),heltab2x96(:,:,587))
  call Hloop_Q_A(ntryL,G0H4(10),43,0,G1H4(55),n2h4(563))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(633),h0tab(:,633),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,59))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,59),G0H4(10),m3h24x4(:,47),heltab2x96(:,:,588))
  call Hloop_Q_A(ntryL,G0H4(10),43,nMB,G1H4(290),n2h4(564))
  Gcoeff(:)%j = (c(35)*(-M(1,:)%j+M(2,:)%j)) * den(366)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(634),h0tab(:,634),[48,4,11],[0,0,0],3,2,wf4(:,2),wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(29),m3h4x24(:,92),heltab2x96(:,:,589))
  call Hloop_A_Q(ntryL,G0H24(29),48,0,G1H24(7),n2h24(240))
  Gcoeff(:)%j = (c(33)*(-M(1,:)%j+M(2,:)%j)) * den(366)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(635),h0tab(:,635),[48,4,11],[nMT,nMT,nMT],3,2,wf4(:,2),wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(29),m3h4x24(:,93),heltab2x96(:,:,590))
  call Hloop_A_Q(ntryL,G0H24(29),48,nMT,G1H24(19),n2h24(241))
  Gcoeff(:)%j = (c(35)*(-M(1,:)%j+M(2,:)%j)) * den(366)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(636),h0tab(:,636),[48,4,11],[0,0,0],3,2,wf4(:,2),wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(29),m3h4x24(:,94),heltab2x96(:,:,591))
  call Hloop_Q_A(ntryL,G0H24(29),48,0,G1H24(3),n2h24(242))
  Gcoeff(:)%j = (c(33)*(-M(1,:)%j+M(2,:)%j)) * den(366)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(637),h0tab(:,637),[48,4,11],[nMT,nMT,nMT],3,2,wf4(:,2),wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(29),m3h4x24(:,95),heltab2x96(:,:,592))
  call Hloop_Q_A(ntryL,G0H24(29),48,nMT,G1H24(13),n2h24(243))
  Gcoeff(:)%j = (c(33)*(M(1,:)%j-M(2,:)%j)) * den(366)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(638),h0tab(:,638),[48,4,11],[0,0,0],3,2,wf4(:,2),wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(29),m3h4x24(:,96),heltab2x96(:,:,593))
  call Hloop_A_Q(ntryL,G0H24(29),48,0,G1H24(38),n2h24(244))
  Gcoeff(:)%j = (c(32)*(M(1,:)%j-M(2,:)%j)) * den(366)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(639),h0tab(:,639),[48,4,11],[nMB,nMB,nMB],3,2,wf4(:,2),wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(29),m3h4x24(:,97),heltab2x96(:,:,594))
  call Hloop_A_Q(ntryL,G0H24(29),48,nMB,G1H24(33),n2h24(245))
  Gcoeff(:)%j = (c(33)*(M(1,:)%j-M(2,:)%j)) * den(366)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(640),h0tab(:,640),[48,4,11],[0,0,0],3,2,wf4(:,2),wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(29),m3h4x24(:,98),heltab2x96(:,:,595))
  call Hloop_Q_A(ntryL,G0H24(29),48,0,G1H24(73),n2h24(246))
  Gcoeff(:)%j = (c(32)*(M(1,:)%j-M(2,:)%j)) * den(366)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(641),h0tab(:,641),[48,4,11],[nMB,nMB,nMB],3,2,wf4(:,2),wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(29),m3h4x24(:,99),heltab2x96(:,:,596))
  call Hloop_Q_A(ntryL,G0H24(29),48,nMB,G1H24(20),n2h24(247))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(642),h0tab(:,642),[49,4,10],[0,0,0],3,2,wf8(:,14),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf8(:,14),G0H12(3),m3h8x12(:,46),heltab2x96(:,:,597))
  call Hloop_Q_A(ntryL,G0H12(3),49,0,G1H12(217),n2h12(375))
  Gcoeff(:)%j = (c(10)*(-M(1,:)%j+M(2,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(643),h0tab(:,643),[48,1,14],[0,0,0],3,2,wf4(:,2),wf12(:,22))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(29),m3h4x24(:,100),heltab2x96(:,:,598))
  call Hloop_A_Q(ntryL,G0H24(29),48,0,G1H24(48),n2h24(248))
  Gcoeff(:)%j = (c(27)*(-M(1,:)%j+M(2,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(644),h0tab(:,644),[48,1,14],[0,0,0],3,2,wf4(:,2),wf12(:,22))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf4(:,2),48,G1H24(88),m3h4x24(:,101),heltab2x96(:,:,599))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(645),h0tab(:,645),[58,1,4],[0,0,0],3,1,wf24(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,10),G0H4(10),m3h24x4(:,48),heltab2x96(:,:,600))
  Gcoeff(:)%j = (c(35)*(-M(1,:)%j+M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(646),h0tab(:,646),[32,4,27],[0,0,0],3,1,wf24(:,60))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,378),heltab2x96(:,:,601))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(124),n2h48(273))
  Gcoeff(:)%j = (c(33)*(-M(1,:)%j+M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(647),h0tab(:,647),[32,4,27],[nMT,nMT,nMT],3,1,wf24(:,60))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,379),heltab2x96(:,:,602))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(125),n2h48(274))
  Gcoeff(:)%j = (c(35)*(-M(1,:)%j+M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(648),h0tab(:,648),[32,4,27],[0,0,0],3,1,wf24(:,60))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,380),heltab2x96(:,:,603))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(126),n2h48(275))
  Gcoeff(:)%j = (c(33)*(-M(1,:)%j+M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(649),h0tab(:,649),[32,4,27],[nMT,nMT,nMT],3,1,wf24(:,60))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,381),heltab2x96(:,:,604))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(127),n2h48(276))
  Gcoeff(:)%j = (c(33)*(M(1,:)%j-M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(650),h0tab(:,650),[32,4,27],[0,0,0],3,1,wf24(:,60))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,382),heltab2x96(:,:,605))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(128),n2h48(277))
  Gcoeff(:)%j = (c(32)*(M(1,:)%j-M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(651),h0tab(:,651),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,60))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,383),heltab2x96(:,:,606))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(129),n2h48(278))
  Gcoeff(:)%j = (c(33)*(M(1,:)%j-M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(652),h0tab(:,652),[32,4,27],[0,0,0],3,1,wf24(:,60))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,384),heltab2x96(:,:,607))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(130),n2h48(279))
  Gcoeff(:)%j = (c(32)*(M(1,:)%j-M(2,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(653),h0tab(:,653),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,60))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,385),heltab2x96(:,:,608))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(131),n2h48(280))
  Gcoeff(:)%j = (c(35)*(M(1,:)%j-M(2,:)%j)) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(654),h0tab(:,654),[43,4,16],[0,0,0],3,1,wf24(:,61))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,61),G0H4(11),m3h24x4(:,49),heltab2x96(:,:,609))
  call Hloop_A_Q(ntryL,G0H4(11),43,0,G1H4(273),n2h4(565))
  Gcoeff(:)%j = (c(33)*(M(1,:)%j-M(2,:)%j)) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(655),h0tab(:,655),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,61))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,61),G0H4(11),m3h24x4(:,50),heltab2x96(:,:,610))
  call Hloop_A_Q(ntryL,G0H4(11),43,nMT,G1H4(95),n2h4(566))
  Gcoeff(:)%j = (c(35)*(M(1,:)%j-M(2,:)%j)) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(656),h0tab(:,656),[43,4,16],[0,0,0],3,1,wf24(:,61))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,61),G0H4(11),m3h24x4(:,51),heltab2x96(:,:,611))
  call Hloop_Q_A(ntryL,G0H4(11),43,0,G1H4(56),n2h4(567))
  Gcoeff(:)%j = (c(33)*(M(1,:)%j-M(2,:)%j)) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(657),h0tab(:,657),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,61))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,61),G0H4(11),m3h24x4(:,52),heltab2x96(:,:,612))
  call Hloop_Q_A(ntryL,G0H4(11),43,nMT,G1H4(91),n2h4(568))
  Gcoeff(:)%j = (c(33)*(-M(1,:)%j+M(2,:)%j)) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(658),h0tab(:,658),[43,4,16],[0,0,0],3,1,wf24(:,61))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,61),G0H4(11),m3h24x4(:,53),heltab2x96(:,:,613))
  call Hloop_A_Q(ntryL,G0H4(11),43,0,G1H4(262),n2h4(569))
  Gcoeff(:)%j = (c(32)*(-M(1,:)%j+M(2,:)%j)) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(659),h0tab(:,659),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,61))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,61),G0H4(11),m3h24x4(:,54),heltab2x96(:,:,614))
  call Hloop_A_Q(ntryL,G0H4(11),43,nMB,G1H4(114),n2h4(570))
  Gcoeff(:)%j = (c(33)*(-M(1,:)%j+M(2,:)%j)) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(660),h0tab(:,660),[43,4,16],[0,0,0],3,1,wf24(:,61))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,61),G0H4(11),m3h24x4(:,55),heltab2x96(:,:,615))
  call Hloop_Q_A(ntryL,G0H4(11),43,0,G1H4(284),n2h4(571))
  Gcoeff(:)%j = (c(32)*(-M(1,:)%j+M(2,:)%j)) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(661),h0tab(:,661),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,61))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,61),G0H4(11),m3h24x4(:,56),heltab2x96(:,:,616))
  call Hloop_Q_A(ntryL,G0H4(11),43,nMB,G1H4(83),n2h4(572))
  Gcoeff(:)%j = (c(44)*M(1,:)%j-c(43)*M(3,:)%j) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(662),h0tab(:,662),[32,15,16],[0,0,0],3,1,wf24(:,62))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,386),heltab2x96(:,:,617))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(132),n2h48(281))
  Gcoeff(:)%j = (c(40)*M(1,:)%j-c(39)*M(3,:)%j) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(663),h0tab(:,663),[32,15,16],[nMT,nMT,nMT],3,1,wf24(:,62))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,387),heltab2x96(:,:,618))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(133),n2h48(282))
  Gcoeff(:)%j = (c(44)*M(2,:)%j-c(43)*M(3,:)%j) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(664),h0tab(:,664),[32,15,16],[0,0,0],3,1,wf24(:,62))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,388),heltab2x96(:,:,619))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(134),n2h48(283))
  Gcoeff(:)%j = (c(40)*M(2,:)%j-c(39)*M(3,:)%j) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(665),h0tab(:,665),[32,15,16],[nMT,nMT,nMT],3,1,wf24(:,62))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,389),heltab2x96(:,:,620))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(135),n2h48(284))
  Gcoeff(:)%j = (c(44)*M(1,:)%j-c(43)*M(3,:)%j) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(666),h0tab(:,666),[32,15,16],[0,0,0],3,1,wf24(:,62))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,390),heltab2x96(:,:,621))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(136),n2h48(285))
  Gcoeff(:)%j = (c(40)*M(1,:)%j-c(39)*M(3,:)%j) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(667),h0tab(:,667),[32,15,16],[nMB,nMB,nMB],3,1,wf24(:,62))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,391),heltab2x96(:,:,622))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(137),n2h48(286))
  Gcoeff(:)%j = (c(44)*M(2,:)%j-c(43)*M(3,:)%j) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(668),h0tab(:,668),[32,15,16],[0,0,0],3,1,wf24(:,62))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,392),heltab2x96(:,:,623))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(138),n2h48(287))
  Gcoeff(:)%j = (c(40)*M(2,:)%j-c(39)*M(3,:)%j) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(669),h0tab(:,669),[32,15,16],[nMB,nMB,nMB],3,1,wf24(:,62))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,393),heltab2x96(:,:,624))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(139),n2h48(288))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(670),h0tab(:,670),[32,15,16],[0,0,0],3,1,wf24(:,62))
  call Hloop_DV_C(ntryL,G0H96(1),0,ex6(:),G1H48(140),m3h2x48(:,394),heltab2x96(:,:,625))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(671),h0tab(:,671),[32,15,16],[0,0,0],3,1,wf24(:,62))
  call Hloop_CV_D(ntryL,G0H96(1),0,ex6(:),32,G1H48(141),m3h2x48(:,395),heltab2x96(:,:,626))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(672),h0tab(:,672),[32,15,16],[0,0,0],3,1,wf24(:,62))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(142),m3h2x48(:,396),heltab2x96(:,:,627))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(673),h0tab(:,673),[32,4,27],[0,0,0],3,1,wf24(:,63))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,397),heltab2x96(:,:,628))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(143),n2h48(289))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(674),h0tab(:,674),[32,4,27],[nMT,nMT,nMT],3,1,wf24(:,63))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,398),heltab2x96(:,:,629))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(144),n2h48(290))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(675),h0tab(:,675),[32,4,27],[0,0,0],3,1,wf24(:,63))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,399),heltab2x96(:,:,630))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(145),n2h48(291))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(676),h0tab(:,676),[32,4,27],[nMT,nMT,nMT],3,1,wf24(:,63))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,400),heltab2x96(:,:,631))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(146),n2h48(292))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(677),h0tab(:,677),[32,4,27],[0,0,0],3,1,wf24(:,63))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,401),heltab2x96(:,:,632))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(147),n2h48(293))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(678),h0tab(:,678),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,63))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,402),heltab2x96(:,:,633))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(148),n2h48(294))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(679),h0tab(:,679),[32,4,27],[0,0,0],3,1,wf24(:,63))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,403),heltab2x96(:,:,634))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(149),n2h48(295))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(680),h0tab(:,680),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,63))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,404),heltab2x96(:,:,635))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(150),n2h48(296))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(681),h0tab(:,681),[43,4,16],[0,0,0],3,1,wf24(:,64))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,64),G0H4(11),m3h24x4(:,57),heltab2x96(:,:,636))
  call Hloop_A_Q(ntryL,G0H4(11),43,0,G1H4(165),n2h4(573))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(682),h0tab(:,682),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,64))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,64),G0H4(11),m3h24x4(:,58),heltab2x96(:,:,637))
  call Hloop_A_Q(ntryL,G0H4(11),43,nMT,G1H4(131),n2h4(574))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(683),h0tab(:,683),[43,4,16],[0,0,0],3,1,wf24(:,64))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,64),G0H4(11),m3h24x4(:,59),heltab2x96(:,:,638))
  call Hloop_Q_A(ntryL,G0H4(11),43,0,G1H4(314),n2h4(575))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(684),h0tab(:,684),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,64))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,64),G0H4(11),m3h24x4(:,60),heltab2x96(:,:,639))
  call Hloop_Q_A(ntryL,G0H4(11),43,nMT,G1H4(205),n2h4(576))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(685),h0tab(:,685),[43,4,16],[0,0,0],3,1,wf24(:,64))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,64),G0H4(11),m3h24x4(:,61),heltab2x96(:,:,640))
  call Hloop_A_Q(ntryL,G0H4(11),43,0,G1H4(319),n2h4(577))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(686),h0tab(:,686),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,64))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,64),G0H4(11),m3h24x4(:,62),heltab2x96(:,:,641))
  call Hloop_A_Q(ntryL,G0H4(11),43,nMB,G1H4(206),n2h4(578))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(687),h0tab(:,687),[43,4,16],[0,0,0],3,1,wf24(:,64))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,64),G0H4(11),m3h24x4(:,63),heltab2x96(:,:,642))
  call Hloop_Q_A(ntryL,G0H4(11),43,0,G1H4(400),n2h4(579))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(688),h0tab(:,688),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,64))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,64),G0H4(11),m3h24x4(:,64),heltab2x96(:,:,643))
  call Hloop_Q_A(ntryL,G0H4(11),43,nMB,G1H4(210),n2h4(580))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(315)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(689),h0tab(:,689),[32,1,30],[0,0,0],3,1,wf24(:,66))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,405),heltab2x96(:,:,644))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(151),n2h48(297))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(315)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(690),h0tab(:,690),[32,1,30],[0,0,0],3,1,wf24(:,66))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(152),m3h2x48(:,406),heltab2x96(:,:,645))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(316)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(691),h0tab(:,691),[46,1,16],[0,0,0],3,1,wf24(:,68))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,68),G0H4(11),m3h24x4(:,65),heltab2x96(:,:,646))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(316)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(692),h0tab(:,692),[46,1,16],[0,0,0],3,1,wf24(:,68))
  call Hloop_VA_Q(ntryL,G0H96(1),wf24(:,68),G0H4(12),m3h24x4(:,66),heltab2x96(:,:,647))
  call Hloop_A_Q(ntryL,G0H4(12),46,0,G1H4(380),n2h4(581))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(693),h0tab(:,693),[32,1,30],[0,0,0],3,1,wf24(:,70))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,407),heltab2x96(:,:,648))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(153),n2h48(298))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(694),h0tab(:,694),[32,1,30],[0,0,0],3,1,wf24(:,70))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(154),m3h2x48(:,408),heltab2x96(:,:,649))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(318)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(695),h0tab(:,695),[58,1,4],[0,0,0],3,1,wf24(:,72))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,72),G0H4(12),m3h24x4(:,67),heltab2x96(:,:,650))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(319)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(696),h0tab(:,696),[46,1,16],[0,0,0],3,1,wf24(:,74))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,74),G0H4(13),m3h24x4(:,68),heltab2x96(:,:,651))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(319)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(697),h0tab(:,697),[46,1,16],[0,0,0],3,1,wf24(:,74))
  call Hloop_VA_Q(ntryL,G0H96(1),wf24(:,74),G0H4(14),m3h24x4(:,69),heltab2x96(:,:,652))
  call Hloop_A_Q(ntryL,G0H4(14),46,0,G1H4(211),n2h4(582))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(698),h0tab(:,698),[58,1,4],[0,0,0],3,1,wf24(:,76))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,76),G0H4(14),m3h24x4(:,70),heltab2x96(:,:,653))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(367)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(699),h0tab(:,699),[34,12,17],[0,0,0],3,3,wf4(:,7),wf6(:,6),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,7),G0H24(29),m3h4x24(:,102),heltab2x96(:,:,654))
  call Hloop_A_Q(ntryL,G0H24(29),34,0,G1H24(93),n2h24(249))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(700),h0tab(:,700),[49,2,12],[0,0,0],3,2,wf8(:,41),wf6(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,41),G0H12(20),m3h8x12(:,47),heltab2x96(:,:,655))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(701),h0tab(:,701),[32,14,17],[0,0,0],3,2,wf12(:,24),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,409),heltab2x96(:,:,656))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(155),n2h48(299))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(702),h0tab(:,702),[32,14,17],[0,0,0],3,2,wf12(:,24),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(156),m3h2x48(:,410),heltab2x96(:,:,657))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(703),h0tab(:,703),[32,2,29],[0,0,0],3,1,wf24(:,16))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,411),heltab2x96(:,:,658))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(157),n2h48(300))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(704),h0tab(:,704),[32,2,29],[0,0,0],3,1,wf24(:,16))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(158),m3h2x48(:,412),heltab2x96(:,:,659))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(368)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(705),h0tab(:,705),[33,12,18],[0,0,0],3,3,wf4(:,13),wf6(:,6),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(29),m3h4x24(:,103),heltab2x96(:,:,660))
  call Hloop_Q_A(ntryL,G0H24(29),33,0,G1H24(57),n2h24(250))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(706),h0tab(:,706),[32,13,18],[0,0,0],3,2,wf12(:,26),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,413),heltab2x96(:,:,661))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(159),n2h48(301))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(707),h0tab(:,707),[32,13,18],[0,0,0],3,2,wf12(:,26),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(160),m3h2x48(:,414),heltab2x96(:,:,662))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(708),h0tab(:,708),[50,1,12],[0,0,0],3,2,wf8(:,32),wf6(:,6))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,32),G0H12(5),m3h8x12(:,48),heltab2x96(:,:,663))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(709),h0tab(:,709),[32,1,30],[0,0,0],3,1,wf24(:,18))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,415),heltab2x96(:,:,664))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(161),n2h48(302))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(710),h0tab(:,710),[32,1,30],[0,0,0],3,1,wf24(:,18))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(162),m3h2x48(:,416),heltab2x96(:,:,665))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(711),h0tab(:,711),[49,2,12],[0,0,0],3,2,wf8(:,42),wf6(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,42),G0H12(15),m3h8x12(:,49),heltab2x96(:,:,666))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(712),h0tab(:,712),[33,14,16],[0,0,0],3,2,wf4(:,13),wf12(:,24))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,13),G0H24(29),m3h4x24(:,104),heltab2x96(:,:,667))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(713),h0tab(:,713),[33,14,16],[0,0,0],3,2,wf4(:,13),wf12(:,24))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(30),m3h4x24(:,105),heltab2x96(:,:,668))
  call Hloop_Q_A(ntryL,G0H24(30),33,0,G1H24(4),n2h24(251))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(714),h0tab(:,714),[45,2,16],[0,0,0],3,1,wf24(:,20))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,20),G0H4(15),m3h24x4(:,71),heltab2x96(:,:,669))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(715),h0tab(:,715),[45,2,16],[0,0,0],3,1,wf24(:,20))
  call Hloop_VQ_A(ntryL,G0H96(1),wf24(:,20),G0H4(16),m3h24x4(:,72),heltab2x96(:,:,670))
  call Hloop_Q_A(ntryL,G0H4(16),45,0,G1H4(371),n2h4(583))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(716),h0tab(:,716),[34,13,16],[0,0,0],3,2,wf4(:,7),wf12(:,26))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,7),G0H24(30),m3h4x24(:,106),heltab2x96(:,:,671))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(717),h0tab(:,717),[34,13,16],[0,0,0],3,2,wf4(:,7),wf12(:,26))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,7),G0H24(31),m3h4x24(:,107),heltab2x96(:,:,672))
  call Hloop_A_Q(ntryL,G0H24(31),34,0,G1H24(81),n2h24(252))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(718),h0tab(:,718),[50,1,12],[0,0,0],3,2,wf8(:,33),wf6(:,6))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,33),G0H12(16),m3h8x12(:,50),heltab2x96(:,:,673))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(719),h0tab(:,719),[46,1,16],[0,0,0],3,1,wf24(:,14))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,14),G0H4(16),m3h24x4(:,73),heltab2x96(:,:,674))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(720),h0tab(:,720),[46,1,16],[0,0,0],3,1,wf24(:,14))
  call Hloop_VA_Q(ntryL,G0H96(1),wf24(:,14),G0H4(17),m3h24x4(:,74),heltab2x96(:,:,675))
  call Hloop_A_Q(ntryL,G0H4(17),46,0,G1H4(221),n2h4(584))
  Gcoeff(:)%j = (c(15)*(-M(1,:)%j+M(2,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(721),h0tab(:,721),[48,2,13],[0,0,0],3,2,wf4(:,2),wf12(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(31),m3h4x24(:,108),heltab2x96(:,:,676))
  call Hloop_Q_A(ntryL,G0H24(31),48,0,G1H24(5),n2h24(253))
  Gcoeff(:)%j = (c(31)*(M(1,:)%j-M(2,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(722),h0tab(:,722),[48,2,13],[0,0,0],3,2,wf4(:,2),wf12(:,26))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf4(:,2),48,G1H24(35),m3h4x24(:,109),heltab2x96(:,:,677))
  Gcoeff(:)%j = (c(17)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(723),h0tab(:,723),[49,2,12],[0,0,0],3,2,wf8(:,14),wf6(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,14),G0H12(8),m3h8x12(:,51),heltab2x96(:,:,678))
  Gcoeff(:)%j = (c(15)*(-M(1,:)%j+M(2,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(724),h0tab(:,724),[48,1,14],[0,0,0],3,2,wf4(:,2),wf12(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(31),m3h4x24(:,110),heltab2x96(:,:,679))
  call Hloop_A_Q(ntryL,G0H24(31),48,0,G1H24(127),n2h24(254))
  Gcoeff(:)%j = (c(31)*(-M(1,:)%j+M(2,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(725),h0tab(:,725),[48,1,14],[0,0,0],3,2,wf4(:,2),wf12(:,24))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf4(:,2),48,G1H24(11),m3h4x24(:,111),heltab2x96(:,:,680))
  Gcoeff(:)%j = (c(17)*(M(1,:)%j-M(2,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(726),h0tab(:,726),[50,1,12],[0,0,0],3,2,wf8(:,7),wf6(:,6))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,7),G0H12(9),m3h8x12(:,52),heltab2x96(:,:,681))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(3,:)%j) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(727),h0tab(:,727),[32,15,16],[0,0,0],3,1,wf24(:,77))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,417),heltab2x96(:,:,682))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(163),n2h48(303))
  Gcoeff(:)%j = (c(42)*M(1,:)%j-c(41)*M(3,:)%j) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(728),h0tab(:,728),[32,15,16],[nMT,nMT,nMT],3,1,wf24(:,77))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,418),heltab2x96(:,:,683))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(164),n2h48(304))
  Gcoeff(:)%j = (c(46)*M(2,:)%j-c(45)*M(3,:)%j) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(729),h0tab(:,729),[32,15,16],[0,0,0],3,1,wf24(:,77))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,419),heltab2x96(:,:,684))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(165),n2h48(305))
  Gcoeff(:)%j = (c(42)*M(2,:)%j-c(41)*M(3,:)%j) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(730),h0tab(:,730),[32,15,16],[nMT,nMT,nMT],3,1,wf24(:,77))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,420),heltab2x96(:,:,685))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(166),n2h48(306))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(3,:)%j) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(731),h0tab(:,731),[32,15,16],[0,0,0],3,1,wf24(:,77))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,421),heltab2x96(:,:,686))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(167),n2h48(307))
  Gcoeff(:)%j = (c(42)*M(1,:)%j-c(41)*M(3,:)%j) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(732),h0tab(:,732),[32,15,16],[nMB,nMB,nMB],3,1,wf24(:,77))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,422),heltab2x96(:,:,687))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(168),n2h48(308))
  Gcoeff(:)%j = (c(46)*M(2,:)%j-c(45)*M(3,:)%j) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(733),h0tab(:,733),[32,15,16],[0,0,0],3,1,wf24(:,77))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,423),heltab2x96(:,:,688))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(169),n2h48(309))
  Gcoeff(:)%j = (c(42)*M(2,:)%j-c(41)*M(3,:)%j) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(734),h0tab(:,734),[32,15,16],[nMB,nMB,nMB],3,1,wf24(:,77))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,424),heltab2x96(:,:,689))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(170),n2h48(310))
  Gcoeff(:)%j = (c(18)*(-M(1,:)%j+M(2,:)%j)) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(735),h0tab(:,735),[32,15,16],[0,0,0],3,1,wf24(:,77))
  call Hloop_DV_C(ntryL,G0H96(1),0,ex6(:),G1H48(171),m3h2x48(:,425),heltab2x96(:,:,690))
  Gcoeff(:)%j = (c(18)*(M(1,:)%j-M(2,:)%j)) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(736),h0tab(:,736),[32,15,16],[0,0,0],3,1,wf24(:,77))
  call Hloop_CV_D(ntryL,G0H96(1),0,ex6(:),32,G1H48(172),m3h2x48(:,426),heltab2x96(:,:,691))
  Gcoeff(:)%j = (c(18)*(M(1,:)%j-M(2,:)%j)) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(737),h0tab(:,737),[32,15,16],[0,0,0],3,1,wf24(:,77))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(173),m3h2x48(:,427),heltab2x96(:,:,692))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(3,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(738),h0tab(:,738),[32,15,16],[0,0,0],3,1,wf24(:,78))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,428),heltab2x96(:,:,693))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(174),n2h48(311))
  Gcoeff(:)%j = (c(42)*M(1,:)%j-c(41)*M(3,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(739),h0tab(:,739),[32,15,16],[nMT,nMT,nMT],3,1,wf24(:,78))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,429),heltab2x96(:,:,694))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(175),n2h48(312))
  Gcoeff(:)%j = (c(46)*M(2,:)%j-c(45)*M(3,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(740),h0tab(:,740),[32,15,16],[0,0,0],3,1,wf24(:,78))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,430),heltab2x96(:,:,695))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(176),n2h48(313))
  Gcoeff(:)%j = (c(42)*M(2,:)%j-c(41)*M(3,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(741),h0tab(:,741),[32,15,16],[nMT,nMT,nMT],3,1,wf24(:,78))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,431),heltab2x96(:,:,696))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(177),n2h48(314))
  Gcoeff(:)%j = (c(46)*M(1,:)%j-c(45)*M(3,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(742),h0tab(:,742),[32,15,16],[0,0,0],3,1,wf24(:,78))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,432),heltab2x96(:,:,697))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(178),n2h48(315))
  Gcoeff(:)%j = (c(42)*M(1,:)%j-c(41)*M(3,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(743),h0tab(:,743),[32,15,16],[nMB,nMB,nMB],3,1,wf24(:,78))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,433),heltab2x96(:,:,698))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(179),n2h48(316))
  Gcoeff(:)%j = (c(46)*M(2,:)%j-c(45)*M(3,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(744),h0tab(:,744),[32,15,16],[0,0,0],3,1,wf24(:,78))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,434),heltab2x96(:,:,699))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(180),n2h48(317))
  Gcoeff(:)%j = (c(42)*M(2,:)%j-c(41)*M(3,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(745),h0tab(:,745),[32,15,16],[nMB,nMB,nMB],3,1,wf24(:,78))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,435),heltab2x96(:,:,700))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(181),n2h48(318))
  Gcoeff(:)%j = (c(18)*(-M(1,:)%j+M(2,:)%j)) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(746),h0tab(:,746),[32,15,16],[0,0,0],3,1,wf24(:,78))
  call Hloop_DV_C(ntryL,G0H96(1),0,ex6(:),G1H48(182),m3h2x48(:,436),heltab2x96(:,:,701))
  Gcoeff(:)%j = (c(18)*(M(1,:)%j-M(2,:)%j)) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(747),h0tab(:,747),[32,15,16],[0,0,0],3,1,wf24(:,78))
  call Hloop_CV_D(ntryL,G0H96(1),0,ex6(:),32,G1H48(183),m3h2x48(:,437),heltab2x96(:,:,702))
  Gcoeff(:)%j = (c(18)*(M(1,:)%j-M(2,:)%j)) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(748),h0tab(:,748),[32,15,16],[0,0,0],3,1,wf24(:,78))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(184),m3h2x48(:,438),heltab2x96(:,:,703))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(749),h0tab(:,749),[32,2,29],[0,0,0],3,1,wf24(:,80))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,439),heltab2x96(:,:,704))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(185),n2h48(319))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(750),h0tab(:,750),[32,2,29],[0,0,0],3,1,wf24(:,80))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(186),m3h2x48(:,440),heltab2x96(:,:,705))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(324)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(751),h0tab(:,751),[45,2,16],[0,0,0],3,1,wf24(:,82))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,82),G0H4(17),m3h24x4(:,75),heltab2x96(:,:,706))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(324)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(752),h0tab(:,752),[45,2,16],[0,0,0],3,1,wf24(:,82))
  call Hloop_VQ_A(ntryL,G0H96(1),wf24(:,82),G0H4(18),m3h24x4(:,76),heltab2x96(:,:,707))
  call Hloop_Q_A(ntryL,G0H4(18),45,0,G1H4(394),n2h4(585))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(325)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(753),h0tab(:,753),[32,1,30],[0,0,0],3,1,wf24(:,84))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,441),heltab2x96(:,:,708))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(187),n2h48(320))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(325)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(754),h0tab(:,754),[32,1,30],[0,0,0],3,1,wf24(:,84))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(188),m3h2x48(:,442),heltab2x96(:,:,709))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(755),h0tab(:,755),[46,1,16],[0,0,0],3,1,wf24(:,86))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,86),G0H4(18),m3h24x4(:,77),heltab2x96(:,:,710))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(756),h0tab(:,756),[46,1,16],[0,0,0],3,1,wf24(:,86))
  call Hloop_VA_Q(ntryL,G0H96(1),wf24(:,86),G0H4(19),m3h24x4(:,78),heltab2x96(:,:,711))
  call Hloop_A_Q(ntryL,G0H4(19),46,0,G1H4(226),n2h4(586))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(757),h0tab(:,757),[34,8,21],[0,0,0],3,2,wf4(:,7),wf8(:,20))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,7),G0H24(31),m3h4x24(:,112),heltab2x96(:,:,712))
  call Hloop_A_Q(ntryL,G0H24(31),34,0,G1H24(143),n2h24(255))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(758),h0tab(:,758),[34,4,25],[0,0,0],3,2,wf4(:,7),wf12(:,14))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,7),G0H24(31),m3h4x24(:,113),heltab2x96(:,:,713))
  call Hloop_A_Q(ntryL,G0H24(31),34,0,G1H24(83),n2h24(256))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(759),h0tab(:,759),[38,8,17],[0,0,0],3,2,wf8(:,18),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H96(1),wf8(:,18),G0H12(10),m3h8x12(:,53),heltab2x96(:,:,714))
  call Hloop_A_Q(ntryL,G0H12(10),38,0,G1H12(228),n2h12(376))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(760),h0tab(:,760),[42,4,17],[0,0,0],3,2,wf12(:,9),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,9),G0H8(6),m3h12x8(:,23),heltab2x96(:,:,715))
  call Hloop_A_Q(ntryL,G0H8(6),42,0,G1H8(76),n2h8(171))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(761),h0tab(:,761),[32,2,29],[0,0,0],3,1,wf24(:,88))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,443),heltab2x96(:,:,716))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(189),n2h48(321))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(762),h0tab(:,762),[32,2,29],[0,0,0],3,1,wf24(:,88))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(190),m3h2x48(:,444),heltab2x96(:,:,717))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(328)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(763),h0tab(:,763),[53,2,8],[0,0,0],3,1,wf16(:,22))
  call Hloop_AQ_V(ntryL,G0H96(1),wf16(:,22),G0H6(7),m3h16x6(:,7),heltab2x96(:,:,718))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(764),h0tab(:,764),[32,4,27],[0,0,0],3,1,wf24(:,89))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,445),heltab2x96(:,:,719))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(191),n2h48(322))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(765),h0tab(:,765),[32,4,27],[nMT,nMT,nMT],3,1,wf24(:,89))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,446),heltab2x96(:,:,720))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(192),n2h48(323))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(766),h0tab(:,766),[32,4,27],[0,0,0],3,1,wf24(:,89))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,447),heltab2x96(:,:,721))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(193),n2h48(324))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(767),h0tab(:,767),[32,4,27],[nMT,nMT,nMT],3,1,wf24(:,89))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,448),heltab2x96(:,:,722))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(194),n2h48(325))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(768),h0tab(:,768),[32,4,27],[0,0,0],3,1,wf24(:,89))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,449),heltab2x96(:,:,723))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(195),n2h48(326))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(769),h0tab(:,769),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,89))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,450),heltab2x96(:,:,724))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(196),n2h48(327))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(770),h0tab(:,770),[32,4,27],[0,0,0],3,1,wf24(:,89))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,451),heltab2x96(:,:,725))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(197),n2h48(328))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(771),h0tab(:,771),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,89))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,452),heltab2x96(:,:,726))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(198),n2h48(329))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(330)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(772),h0tab(:,772),[32,2,29],[0,0,0],3,1,wf24(:,91))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,453),heltab2x96(:,:,727))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(199),n2h48(330))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(330)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(773),h0tab(:,773),[32,2,29],[0,0,0],3,1,wf24(:,91))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(200),m3h2x48(:,454),heltab2x96(:,:,728))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(331)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(774),h0tab(:,774),[57,2,4],[0,0,0],3,1,wf24(:,93))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,93),G0H4(19),m3h24x4(:,79),heltab2x96(:,:,729))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(332)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(775),h0tab(:,775),[53,2,8],[0,0,0],3,1,wf16(:,24))
  call Hloop_AQ_V(ntryL,G0H96(1),wf16(:,24),G0H6(8),m3h16x6(:,8),heltab2x96(:,:,730))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(333)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(776),h0tab(:,776),[57,2,4],[0,0,0],3,1,wf24(:,95))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,95),G0H4(20),m3h24x4(:,80),heltab2x96(:,:,731))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(777),h0tab(:,777),[37,8,18],[0,0,0],3,2,wf8(:,22),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H96(1),wf8(:,22),G0H12(14),m3h8x12(:,54),heltab2x96(:,:,732))
  call Hloop_Q_A(ntryL,G0H12(14),37,0,G1H12(229),n2h12(377))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(778),h0tab(:,778),[41,4,18],[0,0,0],3,2,wf12(:,18),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,18),G0H8(8),m3h12x8(:,24),heltab2x96(:,:,733))
  call Hloop_Q_A(ntryL,G0H8(8),41,0,G1H8(81),n2h8(172))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(779),h0tab(:,779),[33,8,22],[0,0,0],3,2,wf4(:,13),wf8(:,16))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(31),m3h4x24(:,114),heltab2x96(:,:,734))
  call Hloop_Q_A(ntryL,G0H24(31),33,0,G1H24(59),n2h24(257))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(780),h0tab(:,780),[33,4,26],[0,0,0],3,2,wf4(:,13),wf12(:,7))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(31),m3h4x24(:,115),heltab2x96(:,:,735))
  call Hloop_Q_A(ntryL,G0H24(31),33,0,G1H24(71),n2h24(258))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(334)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(781),h0tab(:,781),[32,4,27],[0,0,0],3,1,wf24(:,96))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,455),heltab2x96(:,:,736))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(201),n2h48(331))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(334)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(782),h0tab(:,782),[32,4,27],[nMT,nMT,nMT],3,1,wf24(:,96))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,456),heltab2x96(:,:,737))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(202),n2h48(332))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(334)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(783),h0tab(:,783),[32,4,27],[0,0,0],3,1,wf24(:,96))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,457),heltab2x96(:,:,738))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(203),n2h48(333))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(334)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(784),h0tab(:,784),[32,4,27],[nMT,nMT,nMT],3,1,wf24(:,96))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,458),heltab2x96(:,:,739))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(204),n2h48(334))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(334)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(785),h0tab(:,785),[32,4,27],[0,0,0],3,1,wf24(:,96))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,459),heltab2x96(:,:,740))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(205),n2h48(335))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(334)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(786),h0tab(:,786),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,96))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,460),heltab2x96(:,:,741))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(206),n2h48(336))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(334)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(787),h0tab(:,787),[32,4,27],[0,0,0],3,1,wf24(:,96))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,461),heltab2x96(:,:,742))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(207),n2h48(337))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(334)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(788),h0tab(:,788),[32,4,27],[nMB,nMB,nMB],3,1,wf24(:,96))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,462),heltab2x96(:,:,743))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(208),n2h48(338))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(789),h0tab(:,789),[32,1,30],[0,0,0],3,1,wf24(:,98))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,463),heltab2x96(:,:,744))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(209),n2h48(339))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(790),h0tab(:,790),[32,1,30],[0,0,0],3,1,wf24(:,98))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(210),m3h2x48(:,464),heltab2x96(:,:,745))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(336)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(791),h0tab(:,791),[54,1,8],[0,0,0],3,1,wf16(:,26))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,26),G0H6(9),m3h16x6(:,9),heltab2x96(:,:,746))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(337)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(792),h0tab(:,792),[32,1,30],[0,0,0],3,1,wf24(:,100))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,465),heltab2x96(:,:,747))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(211),n2h48(340))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(337)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(793),h0tab(:,793),[32,1,30],[0,0,0],3,1,wf24(:,100))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(212),m3h2x48(:,466),heltab2x96(:,:,748))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(794),h0tab(:,794),[58,1,4],[0,0,0],3,1,wf24(:,102))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,102),G0H4(21),m3h24x4(:,81),heltab2x96(:,:,749))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(339)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(795),h0tab(:,795),[54,1,8],[0,0,0],3,1,wf16(:,28))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,28),G0H6(10),m3h16x6(:,10),heltab2x96(:,:,750))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(340)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(796),h0tab(:,796),[58,1,4],[0,0,0],3,1,wf24(:,104))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,104),G0H4(22),m3h24x4(:,82),heltab2x96(:,:,751))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(797),h0tab(:,797),[45,2,16],[0,0,0],3,1,wf24(:,106))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,106),G0H4(23),m3h24x4(:,83),heltab2x96(:,:,752))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(798),h0tab(:,798),[45,2,16],[0,0,0],3,1,wf24(:,106))
  call Hloop_VQ_A(ntryL,G0H96(1),wf24(:,106),G0H4(24),m3h24x4(:,84),heltab2x96(:,:,753))
  call Hloop_Q_A(ntryL,G0H4(24),45,0,G1H4(333),n2h4(587))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(342)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(799),h0tab(:,799),[53,2,8],[0,0,0],3,1,wf16(:,30))
  call Hloop_AQ_V(ntryL,G0H96(1),wf16(:,30),G0H6(11),m3h16x6(:,11),heltab2x96(:,:,754))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(800),h0tab(:,800),[43,4,16],[0,0,0],3,1,wf24(:,107))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,107),G0H4(24),m3h24x4(:,85),heltab2x96(:,:,755))
  call Hloop_A_Q(ntryL,G0H4(24),43,0,G1H4(242),n2h4(588))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(801),h0tab(:,801),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,107))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,107),G0H4(24),m3h24x4(:,86),heltab2x96(:,:,756))
  call Hloop_A_Q(ntryL,G0H4(24),43,nMT,G1H4(338),n2h4(589))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(802),h0tab(:,802),[43,4,16],[0,0,0],3,1,wf24(:,107))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,107),G0H4(24),m3h24x4(:,87),heltab2x96(:,:,757))
  call Hloop_Q_A(ntryL,G0H4(24),43,0,G1H4(243),n2h4(590))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(803),h0tab(:,803),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,107))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,107),G0H4(24),m3h24x4(:,88),heltab2x96(:,:,758))
  call Hloop_Q_A(ntryL,G0H4(24),43,nMT,G1H4(405),n2h4(591))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(804),h0tab(:,804),[43,4,16],[0,0,0],3,1,wf24(:,107))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,107),G0H4(24),m3h24x4(:,89),heltab2x96(:,:,759))
  call Hloop_A_Q(ntryL,G0H4(24),43,0,G1H4(247),n2h4(592))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(805),h0tab(:,805),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,107))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,107),G0H4(24),m3h24x4(:,90),heltab2x96(:,:,760))
  call Hloop_A_Q(ntryL,G0H4(24),43,nMB,G1H4(385),n2h4(593))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(806),h0tab(:,806),[43,4,16],[0,0,0],3,1,wf24(:,107))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,107),G0H4(24),m3h24x4(:,91),heltab2x96(:,:,761))
  call Hloop_Q_A(ntryL,G0H4(24),43,0,G1H4(248),n2h4(594))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(807),h0tab(:,807),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,107))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,107),G0H4(24),m3h24x4(:,92),heltab2x96(:,:,762))
  call Hloop_Q_A(ntryL,G0H4(24),43,nMB,G1H4(283),n2h4(595))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(808),h0tab(:,808),[45,2,16],[0,0,0],3,1,wf24(:,109))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,109),G0H4(24),m3h24x4(:,93),heltab2x96(:,:,763))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(809),h0tab(:,809),[45,2,16],[0,0,0],3,1,wf24(:,109))
  call Hloop_VQ_A(ntryL,G0H96(1),wf24(:,109),G0H4(25),m3h24x4(:,94),heltab2x96(:,:,764))
  call Hloop_Q_A(ntryL,G0H4(25),45,0,G1H4(113),n2h4(596))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(810),h0tab(:,810),[57,2,4],[0,0,0],3,1,wf24(:,111))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,111),G0H4(25),m3h24x4(:,95),heltab2x96(:,:,765))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(811),h0tab(:,811),[53,2,8],[0,0,0],3,1,wf16(:,32))
  call Hloop_AQ_V(ntryL,G0H96(1),wf16(:,32),G0H6(12),m3h16x6(:,12),heltab2x96(:,:,766))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(347)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(812),h0tab(:,812),[57,2,4],[0,0,0],3,1,wf24(:,113))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,113),G0H4(26),m3h24x4(:,96),heltab2x96(:,:,767))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(813),h0tab(:,813),[43,4,16],[0,0,0],3,1,wf24(:,114))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,114),G0H4(27),m3h24x4(:,97),heltab2x96(:,:,768))
  call Hloop_A_Q(ntryL,G0H4(27),43,0,G1H4(307),n2h4(597))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(814),h0tab(:,814),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,114))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,114),G0H4(27),m3h24x4(:,98),heltab2x96(:,:,769))
  call Hloop_A_Q(ntryL,G0H4(27),43,nMT,G1H4(125),n2h4(598))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(815),h0tab(:,815),[43,4,16],[0,0,0],3,1,wf24(:,114))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(27),m3h24x4(:,99),heltab2x96(:,:,770))
  call Hloop_Q_A(ntryL,G0H4(27),43,0,G1H4(313),n2h4(599))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(816),h0tab(:,816),[43,4,16],[nMT,nMT,nMT],3,1,wf24(:,114))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(27),m3h24x4(:,100),heltab2x96(:,:,771))
  call Hloop_Q_A(ntryL,G0H4(27),43,nMT,G1H4(326),n2h4(600))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(817),h0tab(:,817),[43,4,16],[0,0,0],3,1,wf24(:,114))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,114),G0H4(27),m3h24x4(:,101),heltab2x96(:,:,772))
  call Hloop_A_Q(ntryL,G0H4(27),43,0,G1H4(177),n2h4(601))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(818),h0tab(:,818),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,114))
  call Hloop_AV_Q(ntryL,G0H96(1),wf24(:,114),G0H4(27),m3h24x4(:,102),heltab2x96(:,:,773))
  call Hloop_A_Q(ntryL,G0H4(27),43,nMB,G1H4(332),n2h4(602))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(819),h0tab(:,819),[43,4,16],[0,0,0],3,1,wf24(:,114))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(27),m3h24x4(:,103),heltab2x96(:,:,774))
  call Hloop_Q_A(ntryL,G0H4(27),43,0,G1H4(351),n2h4(603))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(820),h0tab(:,820),[43,4,16],[nMB,nMB,nMB],3,1,wf24(:,114))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(27),m3h24x4(:,104),heltab2x96(:,:,775))
  call Hloop_Q_A(ntryL,G0H4(27),43,nMB,G1H4(379),n2h4(604))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(349)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(821),h0tab(:,821),[46,1,16],[0,0,0],3,1,wf24(:,116))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,116),G0H4(27),m3h24x4(:,105),heltab2x96(:,:,776))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(349)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(822),h0tab(:,822),[46,1,16],[0,0,0],3,1,wf24(:,116))
  call Hloop_VA_Q(ntryL,G0H96(1),wf24(:,116),G0H4(28),m3h24x4(:,106),heltab2x96(:,:,777))
  call Hloop_A_Q(ntryL,G0H4(28),46,0,G1H4(384),n2h4(605))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(350)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(823),h0tab(:,823),[54,1,8],[0,0,0],3,1,wf16(:,34))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,34),G0H6(13),m3h16x6(:,13),heltab2x96(:,:,778))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(351)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(824),h0tab(:,824),[46,1,16],[0,0,0],3,1,wf24(:,118))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,118),G0H4(28),m3h24x4(:,107),heltab2x96(:,:,779))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(351)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(825),h0tab(:,825),[46,1,16],[0,0,0],3,1,wf24(:,118))
  call Hloop_VA_Q(ntryL,G0H96(1),wf24(:,118),G0H4(29),m3h24x4(:,108),heltab2x96(:,:,780))
  call Hloop_A_Q(ntryL,G0H4(29),46,0,G1H4(389),n2h4(606))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(352)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(826),h0tab(:,826),[58,1,4],[0,0,0],3,1,wf24(:,120))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,120),G0H4(29),m3h24x4(:,109),heltab2x96(:,:,781))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(353)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(827),h0tab(:,827),[54,1,8],[0,0,0],3,1,wf16(:,36))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,36),G0H6(14),m3h16x6(:,14),heltab2x96(:,:,782))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(354)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(828),h0tab(:,828),[58,1,4],[0,0,0],3,1,wf24(:,122))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,122),G0H4(30),m3h24x4(:,110),heltab2x96(:,:,783))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(355)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(829),h0tab(:,829),[53,2,8],[0,0,0],3,1,wf16(:,38))
  call Hloop_AQ_V(ntryL,G0H96(1),wf16(:,38),G0H6(15),m3h16x6(:,15),heltab2x96(:,:,784))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(356)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(830),h0tab(:,830),[57,2,4],[0,0,0],3,1,wf24(:,124))
  call Hloop_AQ_V(ntryL,G0H96(1),wf24(:,124),G0H4(31),m3h24x4(:,111),heltab2x96(:,:,785))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(357)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(831),h0tab(:,831),[54,1,8],[0,0,0],3,1,wf16(:,40))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,40),G0H6(16),m3h16x6(:,16),heltab2x96(:,:,786))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(358)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(832),h0tab(:,832),[58,1,4],[0,0,0],3,1,wf24(:,126))
  call Hloop_QA_V(ntryL,G0H96(1),wf24(:,126),G0H4(32),m3h24x4(:,112),heltab2x96(:,:,787))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(324),[G1H6(310),G1H6(305),G1H6(290),G1H6(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(294),[G1H4(261),G1H4(234),G1H4(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(301),[G1H4(278),G1H4(39),G1H4(250),G1H4(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(274),[G1H4(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(22),[G1H6(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(230),[G1H12(148),G1H12(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(161),[G1H12(208),G1H12(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(160),[G1H12(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(192),[G1H12(188),G1H12(175),G1H12(45),G1H12(54) &
    ,G1H12(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(34),[G1H12(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(217),[G1H12(210),G1H12(203),G1H12(251),G1H12(114) &
    ,G1H12(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(260),[G1H12(167),G1H12(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(228),[G1H12(170),G1H12(83),G1H12(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(58),G1H8(78),G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(229),[G1H12(156),G1H12(119),G1H12(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(81),[G1H8(57),G1H8(47),G1H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(351),[G1H4(313),G1H4(248),G1H4(243),G1H4(400),G1H4(314) &
    ,G1H4(284),G1H4(56),G1H4(55),G1H4(74),G1H4(179),G1H4(204),G1H4(256),G1H4(212),G1H4(269),G1H4(35),G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(177),[G1H4(307),G1H4(247),G1H4(242),G1H4(319),G1H4(165) &
    ,G1H4(262),G1H4(273),G1H4(255),G1H4(276),G1H4(263),G1H4(161),G1H4(146),G1H4(209),G1H4(182),G1H4(77),G1H4(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(130),[G1H24(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(136),[G1H24(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G1H4(338),G1H4(131),G1H4(95),G1H4(270),G1H4(178) &
    ,G1H4(127),G1H4(65),G1H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(326),[G1H4(405),G1H4(205),G1H4(91),G1H4(172),G1H4(58) &
    ,G1H4(144),G1H4(181),G1H4(364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(332),[G1H4(385),G1H4(206),G1H4(114),G1H4(13),G1H4(24) &
    ,G1H4(40),G1H4(164),G1H4(375)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(379),[G1H4(283),G1H4(210),G1H4(83),G1H4(290),G1H4(12) &
    ,G1H4(162),G1H4(26),G1H4(386)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(142),[G1H24(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(137),[G1H24(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(93),[G1H24(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(57),[G1H24(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(143),[G1H24(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(83),[G1H24(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(59),[G1H24(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(71),[G1H24(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(126),[G0H24(26),G0H24(25),G0H24(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(15),[G0H24(19),G0H24(3),G0H24(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(134),[G0H24(1),G0H24(6),G0H24(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(140),[G0H24(4),G0H24(7),G0H24(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(121),[G0H24(9),G0H24(10),G0H24(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(88),[G0H24(12),G0H24(13),G0H24(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(35),[G0H24(18),G0H24(16),G0H24(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(11),[G0H24(21),G0H24(20),G0H24(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(13),[G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(212),[G1H12(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(3),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(84),[G1H48(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(92),[G1H48(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(18),[G0H12(17),G0H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(15),[G0H6(12),G0H6(11),G0H6(8),G0H6(7),G0H6(3),G0H6(2) &
    ,G0H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(12),[G1H48(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(14),[G1H48(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(24),[G0H4(23),G0H4(17),G0H4(15),G0H4(8),G0H4(4),G0H4(3) &
    ,G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(113),[G1H4(333),G1H4(394),G1H4(371),G1H4(155),G1H4(145) &
    ,G1H4(231),G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(7),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(7),[G0H12(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(187),[G1H12(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(31),[G1H48(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(33),[G1H48(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(6),[G0H12(12),G0H12(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(16),[G0H6(14),G0H6(13),G0H6(10),G0H6(9),G0H6(6),G0H6(5) &
    ,G0H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(52),[G1H48(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(54),[G1H48(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(28),[G0H4(27),G0H4(18),G0H4(16),G0H4(13),G0H4(11),G0H4(2) &
    ,G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(389),[G1H4(384),G1H4(226),G1H4(221),G1H4(211),G1H4(380) &
    ,G1H4(251),G1H4(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(71),[G1H48(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(73),[G1H48(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(49),[G1H24(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(39),[G1H24(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(31),[G0H4(26),G0H4(25),G0H4(20),G0H4(19),G0H4(9),G0H4(7) &
    ,G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(79),[G1H48(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(83),[G1H48(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(91),[G1H48(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(93),[G1H48(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(106),[G1H48(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(108),[G1H48(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(120),[G1H48(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(122),[G1H48(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(38),[G1H24(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(73),[G1H24(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(32),[G0H4(30),G0H4(29),G0H4(22),G0H4(21),G0H4(14) &
    ,G0H4(12),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(128),[G1H48(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(130),[G1H48(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(136),[G1H48(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(138),[G1H48(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(147),[G1H48(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(149),[G1H48(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(8),[G0H12(15),G0H12(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(9),[G0H12(16),G0H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(167),[G1H48(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(169),[G1H48(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(178),[G1H48(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(180),[G1H48(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(195),[G1H48(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(197),[G1H48(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(205),[G1H48(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(207),[G1H48(203)])
  call Hloop_QW_A(ntryL,G1H6(324),ex4(:),G1H2(251),m3h3x2(:,282),heltab2x6(:,:,721))
  call Hloop_Q_A(ntryL,G1H2(251),61,0,G2H2(522),n2h2(703))
  call Hloop_QV_A(ntryL,G1H4(294),ex5(:),G1H2(125),m3h2x2(:,571),heltab2x4(:,:,699))
  call Hloop_Q_A(ntryL,G1H2(125),61,0,G2H2(525),n2h2(704))
  call Hloop_QV_A(ntryL,G1H4(301),ex3(:),G1H2(163),m3h2x2(:,572),heltab2x4(:,:,700))
  call Hloop_Q_A(ntryL,G1H2(163),61,0,G2H2(527),n2h2(705))
  call Hloop_AV_Q(ntryL,G1H4(274),ex3(:),G1H2(179),m3h2x2(:,573),heltab2x4(:,:,701))
  call Hloop_A_Q(ntryL,G1H2(179),62,0,G2H2(528),n2h2(706))
  call Hloop_AW_Q(ntryL,G1H6(22),ex4(:),G1H2(183),m3h3x2(:,283),heltab2x6(:,:,722))
  call Hloop_A_Q(ntryL,G1H2(183),62,0,G2H2(530),n2h2(707))
  call Hloop_AV_Q(ntryL,G1H4(53),ex5(:),G1H2(206),m3h2x2(:,574),heltab2x4(:,:,702))
  call Hloop_A_Q(ntryL,G1H2(206),62,0,G2H2(533),n2h2(708))
  call Hloop_AV_Q(ntryL,G1H8(60),ex5(:),G1H4(120),m3h2x4(:,239),heltab2x8(:,:,299))
  call Hloop_A_Q(ntryL,G1H4(120),58,0,G2H4(39),n2h4(607))
  call Hloop_AW_Q(ntryL,G1H12(230),ex4(:),G1H4(166),m3h3x4(:,200),heltab2x12(:,:,779))
  call Hloop_A_Q(ntryL,G1H4(166),58,0,G2H4(42),n2h4(608))
  call Hloop_QV_A(ntryL,G1H8(1),ex5(:),G1H4(67),m3h2x4(:,240),heltab2x8(:,:,300))
  call Hloop_Q_A(ntryL,G1H4(67),57,0,G2H4(225),n2h4(609))
  call Hloop_QW_A(ntryL,G1H12(161),ex4(:),G1H4(79),m3h3x4(:,201),heltab2x12(:,:,780))
  call Hloop_Q_A(ntryL,G1H4(79),57,0,G2H4(228),n2h4(610))
  call Hloop_AV_Q(ntryL,G1H12(160),ex5(:),G1H6(19),m3h2x6(:,335),heltab2x12(:,:,781))
  call Hloop_A_Q(ntryL,G1H6(19),54,0,G2H6(50),n2h6(378))
  call Hloop_AV_Q(ntryL,G1H12(192),ex3(:),G1H6(36),m3h2x6(:,336),heltab2x12(:,:,782))
  call Hloop_A_Q(ntryL,G1H6(36),54,0,G2H6(60),n2h6(379))
  call Hloop_QV_A(ntryL,G1H12(34),ex5(:),G1H6(43),m3h2x6(:,337),heltab2x12(:,:,783))
  call Hloop_Q_A(ntryL,G1H6(43),53,0,G2H6(54),n2h6(380))
  call Hloop_QV_A(ntryL,G1H12(217),ex3(:),G1H6(56),m3h2x6(:,338),heltab2x12(:,:,784))
  call Hloop_Q_A(ntryL,G1H6(56),53,0,G2H6(5),n2h6(381))
  call Hloop_QW_A(ntryL,G1H12(260),wf6(:,6),G1H2(184),m3h6x2(:,92),heltab2x12(:,:,785))
  call Hloop_Q_A(ntryL,G1H2(184),61,0,G2H2(535),n2h2(709))
  call Hloop_AW_Q(ntryL,G1H12(140),wf6(:,6),G1H2(909),m3h6x2(:,93),heltab2x12(:,:,786))
  call Hloop_A_Q(ntryL,G1H2(909),62,0,G2H2(536),n2h2(710))
  call Hloop_AW_Q(ntryL,G1H12(228),ex4(:),G1H4(98),m3h3x4(:,202),heltab2x12(:,:,787))
  call Hloop_A_Q(ntryL,G1H4(98),46,0,G2H4(233),n2h4(611))
  call Hloop_AV_Q(ntryL,G1H8(76),ex3(:),G1H4(102),m3h2x4(:,241),heltab2x8(:,:,301))
  call Hloop_A_Q(ntryL,G1H4(102),46,0,G2H4(203),n2h4(612))
  call Hloop_QW_A(ntryL,G1H12(229),ex4(:),G1H4(103),m3h3x4(:,203),heltab2x12(:,:,788))
  call Hloop_Q_A(ntryL,G1H4(103),45,0,G2H4(191),n2h4(613))
  call Hloop_QV_A(ntryL,G1H8(81),ex3(:),G1H4(104),m3h2x4(:,242),heltab2x8(:,:,302))
  call Hloop_Q_A(ntryL,G1H4(104),45,0,G2H4(4),n2h4(614))
  call Hloop_QV_A(ntryL,G1H4(351),ex3(:),G1H2(240),m3h2x2(:,575),heltab2x4(:,:,703))
  call Hloop_Q_A(ntryL,G1H2(240),47,0,G2H2(538),n2h2(711))
  call Hloop_AV_Q(ntryL,G1H4(177),ex3(:),G1H2(185),m3h2x2(:,576),heltab2x4(:,:,704))
  call Hloop_A_Q(ntryL,G1H2(185),47,0,G2H2(541),n2h2(712))
  call Hloop_AV_Q(ntryL,G1H24(129),ex5(:),G1H12(240),m3h2x12(:,301),heltab2x24(:,:,548))
  call Hloop_A_Q(ntryL,G1H12(240),50,0,G2H12(26),n2h12(378))
  call Hloop_AW_Q(ntryL,G1H24(130),ex4(:),G1H8(29),m3h3x8(:,85),heltab2x24(:,:,549))
  call Hloop_A_Q(ntryL,G1H8(29),42,0,G2H8(38),n2h8(173))
  call Hloop_QV_A(ntryL,G1H24(139),ex5(:),G1H12(144),m3h2x12(:,302),heltab2x24(:,:,550))
  call Hloop_Q_A(ntryL,G1H12(144),49,0,G2H12(43),n2h12(379))
  call Hloop_QW_A(ntryL,G1H24(136),ex4(:),G1H8(30),m3h3x8(:,86),heltab2x24(:,:,551))
  call Hloop_Q_A(ntryL,G1H8(30),41,0,G2H8(28),n2h8(174))
  call Hloop_AV_Q(ntryL,G1H24(66),ex5(:),G1H12(242),m3h2x12(:,303),heltab2x24(:,:,552))
  call Hloop_A_Q(ntryL,G1H12(242),52,0,G2H12(7),n2h12(380))
  call Hloop_AV_Q(ntryL,G1H24(115),ex5(:),G1H12(143),m3h2x12(:,304),heltab2x24(:,:,553))
  call Hloop_A_Q(ntryL,G1H12(143),52,nMT,G2H12(8),n2h12(381))
  call Hloop_QV_A(ntryL,G1H24(80),ex5(:),G1H12(180),m3h2x12(:,305),heltab2x24(:,:,554))
  call Hloop_Q_A(ntryL,G1H12(180),52,0,G2H12(61),n2h12(382))
  call Hloop_QV_A(ntryL,G1H24(23),ex5(:),G1H12(197),m3h2x12(:,306),heltab2x24(:,:,555))
  call Hloop_Q_A(ntryL,G1H12(197),52,nMT,G2H12(63),n2h12(383))
  call Hloop_AV_Q(ntryL,G1H24(17),ex5(:),G1H12(198),m3h2x12(:,307),heltab2x24(:,:,556))
  call Hloop_A_Q(ntryL,G1H12(198),52,nMB,G2H12(64),n2h12(384))
  call Hloop_QV_A(ntryL,G1H24(103),ex5(:),G1H12(35),m3h2x12(:,308),heltab2x24(:,:,557))
  call Hloop_Q_A(ntryL,G1H12(35),52,nMB,G2H12(67),n2h12(385))
  call Hloop_AV_Q(ntryL,G1H4(125),ex3(:),G1H2(205),m3h2x2(:,577),heltab2x4(:,:,705))
  call Hloop_A_Q(ntryL,G1H2(205),47,nMT,G2H2(543),n2h2(713))
  call Hloop_QV_A(ntryL,G1H4(326),ex3(:),G1H2(939),m3h2x2(:,578),heltab2x4(:,:,706))
  call Hloop_Q_A(ntryL,G1H2(939),47,nMT,G2H2(544),n2h2(714))
  call Hloop_AV_Q(ntryL,G1H4(332),ex3(:),G1H2(914),m3h2x2(:,579),heltab2x4(:,:,707))
  call Hloop_A_Q(ntryL,G1H2(914),47,nMB,G2H2(546),n2h2(715))
  call Hloop_QV_A(ntryL,G1H4(379),ex3(:),G1H2(317),m3h2x2(:,580),heltab2x4(:,:,708))
  call Hloop_Q_A(ntryL,G1H2(317),47,nMB,G2H2(549),n2h2(716))
  call Hloop_QV_A(ntryL,G1H24(10),wf12(:,27),G1H2(207),m3h12x2(:,87),heltab2x24(:,:,558))
  call Hloop_Q_A(ntryL,G1H2(207),47,0,G2H2(551),n2h2(717))
  call Hloop_QV_A(ntryL,G1H24(1),wf12(:,27),G1H2(218),m3h12x2(:,88),heltab2x24(:,:,559))
  call Hloop_Q_A(ntryL,G1H2(218),47,nMT,G2H2(552),n2h2(718))
  call Hloop_AV_Q(ntryL,G1H24(12),wf12(:,27),G1H2(238),m3h12x2(:,89),heltab2x24(:,:,560))
  call Hloop_A_Q(ntryL,G1H2(238),47,0,G2H2(554),n2h2(719))
  call Hloop_AV_Q(ntryL,G1H24(47),wf12(:,27),G1H2(239),m3h12x2(:,90),heltab2x24(:,:,561))
  call Hloop_A_Q(ntryL,G1H2(239),47,nMT,G2H2(557),n2h2(720))
  call Hloop_QV_A(ntryL,G1H24(18),wf12(:,27),G1H2(249),m3h12x2(:,91),heltab2x24(:,:,562))
  call Hloop_Q_A(ntryL,G1H2(249),47,nMB,G2H2(559),n2h2(721))
  call Hloop_AV_Q(ntryL,G1H24(75),wf12(:,27),G1H2(250),m3h12x2(:,92),heltab2x24(:,:,563))
  call Hloop_A_Q(ntryL,G1H2(250),47,nMB,G2H2(560),n2h2(722))
  call Hloop_AV_Q(ntryL,G1H24(21),ex5(:),G1H12(37),m3h2x12(:,309),heltab2x24(:,:,564))
  call Hloop_A_Q(ntryL,G1H12(37),50,0,G2H12(69),n2h12(386))
  call Hloop_AV_Q(ntryL,G1H24(142),ex3(:),G1H12(26),m3h2x12(:,310),heltab2x24(:,:,565))
  call Hloop_A_Q(ntryL,G1H12(26),38,0,G2H12(70),n2h12(387))
  call Hloop_AV_Q(ntryL,G1H24(65),ex5(:),G1H12(21),m3h2x12(:,311),heltab2x24(:,:,566))
  call Hloop_A_Q(ntryL,G1H12(21),52,0,G2H12(71),n2h12(388))
  call Hloop_AV_Q(ntryL,G1H24(90),ex5(:),G1H12(196),m3h2x12(:,312),heltab2x24(:,:,567))
  call Hloop_A_Q(ntryL,G1H12(196),52,nMT,G2H12(74),n2h12(389))
  call Hloop_QV_A(ntryL,G1H24(95),ex5(:),G1H12(30),m3h2x12(:,313),heltab2x24(:,:,568))
  call Hloop_Q_A(ntryL,G1H12(30),52,0,G2H12(46),n2h12(390))
  call Hloop_QV_A(ntryL,G1H24(61),ex5(:),G1H12(214),m3h2x12(:,314),heltab2x24(:,:,569))
  call Hloop_Q_A(ntryL,G1H12(214),52,nMT,G2H12(50),n2h12(391))
  call Hloop_AV_Q(ntryL,G1H24(28),ex5(:),G1H12(52),m3h2x12(:,315),heltab2x24(:,:,570))
  call Hloop_A_Q(ntryL,G1H12(52),52,nMB,G2H12(51),n2h12(392))
  call Hloop_QV_A(ntryL,G1H24(113),ex5(:),G1H12(31),m3h2x12(:,316),heltab2x24(:,:,571))
  call Hloop_Q_A(ntryL,G1H12(31),52,nMB,G2H12(55),n2h12(393))
  call Hloop_QV_A(ntryL,G1H24(123),wf12(:,28),G1H2(977),m3h12x2(:,93),heltab2x24(:,:,572))
  call Hloop_Q_A(ntryL,G1H2(977),47,0,G2H2(562),n2h2(723))
  call Hloop_QV_A(ntryL,G1H24(50),wf12(:,28),G1H2(260),m3h12x2(:,94),heltab2x24(:,:,573))
  call Hloop_Q_A(ntryL,G1H2(260),47,nMT,G2H2(80),n2h2(724))
  call Hloop_AV_Q(ntryL,G1H24(43),wf12(:,28),G1H2(261),m3h12x2(:,95),heltab2x24(:,:,574))
  call Hloop_A_Q(ntryL,G1H2(261),47,0,G2H2(71),n2h2(725))
  call Hloop_AV_Q(ntryL,G1H24(151),wf12(:,28),G1H2(1009),m3h12x2(:,96),heltab2x24(:,:,575))
  call Hloop_A_Q(ntryL,G1H2(1009),47,nMT,G2H2(225),n2h2(726))
  call Hloop_QV_A(ntryL,G1H24(156),wf12(:,28),G1H2(272),m3h12x2(:,97),heltab2x24(:,:,576))
  call Hloop_Q_A(ntryL,G1H2(272),47,nMB,G2H2(219),n2h2(727))
  call Hloop_AV_Q(ntryL,G1H24(161),wf12(:,28),G1H2(929),m3h12x2(:,98),heltab2x24(:,:,577))
  call Hloop_A_Q(ntryL,G1H2(929),47,nMB,G2H2(4),n2h2(728))
  call Hloop_QV_A(ntryL,G1H24(166),ex5(:),G1H12(69),m3h2x12(:,317),heltab2x24(:,:,578))
  call Hloop_Q_A(ntryL,G1H12(69),49,0,G2H12(56),n2h12(394))
  call Hloop_QV_A(ntryL,G1H24(137),ex3(:),G1H12(87),m3h2x12(:,318),heltab2x24(:,:,579))
  call Hloop_Q_A(ntryL,G1H12(87),37,0,G2H12(59),n2h12(395))
  call Hloop_AW_Q(ntryL,G1H24(93),wf6(:,6),G1H4(14),m3h6x4(:,38),heltab2x24(:,:,580))
  call Hloop_A_Q(ntryL,G1H4(14),46,0,G2H4(83),n2h4(615))
  call Hloop_QW_A(ntryL,G1H24(57),wf6(:,6),G1H4(213),m3h6x4(:,39),heltab2x24(:,:,581))
  call Hloop_Q_A(ntryL,G1H4(213),45,0,G2H4(217),n2h4(616))
  call Hloop_AV_Q(ntryL,G1H24(181),ex5(:),G1H12(93),m3h2x12(:,319),heltab2x24(:,:,582))
  call Hloop_A_Q(ntryL,G1H12(93),50,0,G2H12(60),n2h12(396))
  call Hloop_QV_A(ntryL,G1H24(184),ex5(:),G1H12(99),m3h2x12(:,320),heltab2x24(:,:,583))
  call Hloop_Q_A(ntryL,G1H12(99),49,0,G2H12(2),n2h12(397))
  call Hloop_AW_Q(ntryL,G1H24(143),ex4(:),G1H8(38),m3h3x8(:,87),heltab2x24(:,:,584))
  call Hloop_A_Q(ntryL,G1H8(38),42,0,G2H8(11),n2h8(175))
  call Hloop_AV_Q(ntryL,G1H24(83),ex3(:),G1H12(256),m3h2x12(:,321),heltab2x24(:,:,585))
  call Hloop_A_Q(ntryL,G1H12(256),38,0,G2H12(3),n2h12(398))
  call Hloop_QW_A(ntryL,G1H24(59),ex4(:),G1H8(41),m3h3x8(:,88),heltab2x24(:,:,586))
  call Hloop_Q_A(ntryL,G1H8(41),41,0,G2H8(14),n2h8(176))
  call Hloop_QV_A(ntryL,G1H24(71),ex3(:),G1H12(252),m3h2x12(:,322),heltab2x24(:,:,587))
  call Hloop_Q_A(ntryL,G1H12(252),37,0,G2H12(5),n2h12(399))
  call Hloop_VQ_A(ntryL,G1H24(126),wf4(:,3),G1H6(60),m3h4x6(:,33),heltab2x24(:,:,588))
  call Hloop_Q_A(ntryL,G1H6(60),53,0,G2H6(106),n2h6(382))
  call Hloop_VA_Q(ntryL,G1H24(15),ex2(:),G1H12(255),m3h2x12(:,323),heltab2x24(:,:,589))
  call Hloop_A_Q(ntryL,G1H12(255),50,0,G2H12(6),n2h12(400))
  call Hloop_VA_Q(ntryL,G1H24(134),wf4(:,9),G1H6(74),m3h4x6(:,34),heltab2x24(:,:,590))
  call Hloop_A_Q(ntryL,G1H6(74),54,0,G2H6(103),n2h6(383))
  call Hloop_VQ_A(ntryL,G1H24(140),ex1(:),G1H12(257),m3h2x12(:,324),heltab2x24(:,:,591))
  call Hloop_Q_A(ntryL,G1H12(257),49,0,G2H12(33),n2h12(401))
  call Hloop_VA_Q(ntryL,G1H24(121),ex2(:),G1H12(146),m3h2x12(:,325),heltab2x24(:,:,592))
  call Hloop_A_Q(ntryL,G1H12(146),50,0,G2H12(20),n2h12(402))
  call Hloop_VQ_A(ntryL,G1H24(88),ex1(:),G1H12(73),m3h2x12(:,326),heltab2x24(:,:,593))
  call Hloop_Q_A(ntryL,G1H12(73),49,0,G2H12(49),n2h12(403))
  call Hloop_VA_Q(ntryL,G1H24(35),ex2(:),G1H12(72),m3h2x12(:,327),heltab2x24(:,:,594))
  call Hloop_A_Q(ntryL,G1H12(72),50,0,G2H12(9),n2h12(404))
  call Hloop_VQ_A(ntryL,G1H24(11),ex1(:),G1H12(157),m3h2x12(:,328),heltab2x24(:,:,595))
  call Hloop_Q_A(ntryL,G1H12(157),49,0,G2H12(14),n2h12(405))
  call Hloop_AQ_V(ntryL,G1H24(125),wf4(:,3),G1H6(79),m3h4x6(:,35),heltab2x24(:,:,596))
  call Hloop_QA_V(ntryL,G1H48(40),wf6(:,2),G1H8(62),m3h6x8(:,15),heltab2x48(:,:,243))
  call Hloop_VA_Q(ntryL,G1H48(42),wf6(:,2),G1H8(65),m3h6x8(:,16),heltab2x48(:,:,244))
  call Hloop_A_Q(ntryL,G1H8(65),42,0,G2H8(17),n2h8(177))
  call Hloop_VA_Q(ntryL,G0H12(13),wf6(:,2),G0H2(1),m3h6x2(:,94),heltab2x12(:,:,789))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(273),n2h2(729))
  call Hloop_QA_V(ntryL,G1H12(212),wf6(:,2),G1H2(283),m3h6x2(:,95),heltab2x12(:,:,790))
  call Hloop_AQ_V(ntryL,G1H48(48),wf4(:,3),G1H12(91),m3h4x12(:,21),heltab2x48(:,:,245))
  call Hloop_VQ_A(ntryL,G1H48(50),wf4(:,3),G1H12(101),m3h4x12(:,22),heltab2x48(:,:,246))
  call Hloop_Q_A(ntryL,G1H12(101),37,0,G2H12(16),n2h12(406))
  call Hloop_VQ_A(ntryL,G0H8(3),wf4(:,3),G0H2(1),m3h4x2(:,41),heltab2x8(:,:,303))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(304),n2h2(730))
  call Hloop_AQ_V(ntryL,G1H8(10),wf4(:,3),G1H2(305),m3h4x2(:,42),heltab2x8(:,:,304))
  call Hloop_AV_Q(ntryL,G1H48(84),wf24(:,1),G1H2(315),m3h24x2(:,1),heltab2x48(:,:,247))
  call Hloop_A_Q(ntryL,G1H2(315),47,0,G2H2(88),n2h2(731))
  call Hloop_AV_Q(ntryL,G1H48(58),wf24(:,1),G1H2(316),m3h24x2(:,2),heltab2x48(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(316),47,nMT,G2H2(73),n2h2(732))
  call Hloop_QV_A(ntryL,G1H48(92),wf24(:,1),G1H2(344),m3h24x2(:,3),heltab2x48(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(344),47,0,G2H2(228),n2h2(733))
  call Hloop_QV_A(ntryL,G1H48(78),wf24(:,1),G1H2(1029),m3h24x2(:,4),heltab2x48(:,:,250))
  call Hloop_Q_A(ntryL,G1H2(1029),47,nMT,G2H2(222),n2h2(734))
  call Hloop_AV_Q(ntryL,G1H48(86),wf24(:,1),G1H2(349),m3h24x2(:,5),heltab2x48(:,:,251))
  call Hloop_A_Q(ntryL,G1H2(349),47,nMB,G2H2(13),n2h2(735))
  call Hloop_QV_A(ntryL,G1H48(94),wf24(:,1),G1H2(949),m3h24x2(:,6),heltab2x48(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(949),47,nMB,G2H2(409),n2h2(736))
  call Hloop_DV_C(ntryL,G1H48(1),32,wf24(:,1),G2H2(381),m3h24x2(:,7),heltab2x48(:,:,253))
  call Hloop_CV_D(ntryL,G1H48(2),32,wf24(:,1),15,G2H2(47),m3h24x2(:,8),heltab2x48(:,:,254))
  call Hloop_UV_W(ntryL,G1H48(3),32,wf24(:,1),15,G2H2(25),m3h24x2(:,9),heltab2x48(:,:,255))
  call Hloop_AQ_V(ntryL,G1H48(4),wf12(:,5),G1H4(259),m3h12x4(:,25),heltab2x48(:,:,256))
  call Hloop_VQ_A(ntryL,G1H48(5),wf12(:,5),G1H4(115),m3h12x4(:,26),heltab2x48(:,:,257))
  call Hloop_Q_A(ntryL,G1H4(115),45,0,G2H4(69),n2h4(617))
  call Hloop_AQ_V(ntryL,G1H48(6),wf4(:,3),G1H12(74),m3h4x12(:,23),heltab2x48(:,:,258))
  call Hloop_VQ_A(ntryL,G1H48(7),wf4(:,3),G1H12(191),m3h4x12(:,24),heltab2x48(:,:,259))
  call Hloop_Q_A(ntryL,G1H12(191),37,0,G2H12(36),n2h12(407))
  call Hloop_VQ_A(ntryL,G0H12(18),wf4(:,3),G0H3(1),m3h4x3(:,45),heltab2x12(:,:,791))
  call Hloop_Q_A(ntryL,G0H3(1),55,0,G1H3(58),n2h3(235))
  call Hloop_VQ_A(ntryL,G0H24(23),wf12(:,5),G0H2(1),m3h12x2(:,99),heltab2x24(:,:,597))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(482),n2h2(737))
  call Hloop_AQ_V(ntryL,G1H24(128),wf12(:,5),G1H2(350),m3h12x2(:,100),heltab2x24(:,:,598))
  call Hloop_QA_V(ntryL,G1H24(74),ex2(:),G1H12(137),m3h2x12(:,329),heltab2x24(:,:,599))
  call Hloop_VA_Q(ntryL,G0H6(15),ex2(:),G0H3(1),m3h2x3(:,283),heltab2x6(:,:,723))
  call Hloop_A_Q(ntryL,G0H3(1),55,0,G1H3(38),n2h3(236))
  call Hloop_AV_Q(ntryL,G1H48(12),wf24(:,21),G1H2(987),m3h24x2(:,10),heltab2x48(:,:,260))
  call Hloop_A_Q(ntryL,G1H2(987),47,0,G2H2(400),n2h2(738))
  call Hloop_AV_Q(ntryL,G1H48(9),wf24(:,21),G1H2(359),m3h24x2(:,11),heltab2x48(:,:,261))
  call Hloop_A_Q(ntryL,G1H2(359),47,nMT,G2H2(57),n2h2(739))
  call Hloop_QV_A(ntryL,G1H48(14),wf24(:,21),G1H2(360),m3h24x2(:,12),heltab2x48(:,:,262))
  call Hloop_Q_A(ntryL,G1H2(360),47,0,G2H2(37),n2h2(740))
  call Hloop_QV_A(ntryL,G1H48(11),wf24(:,21),G1H2(372),m3h24x2(:,13),heltab2x48(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(372),47,nMT,G2H2(65),n2h2(741))
  call Hloop_AV_Q(ntryL,G1H48(13),wf24(:,21),G1H2(1039),m3h24x2(:,14),heltab2x48(:,:,264))
  call Hloop_A_Q(ntryL,G1H2(1039),47,nMB,G2H2(262),n2h2(742))
  call Hloop_QV_A(ntryL,G1H48(15),wf24(:,21),G1H2(381),m3h24x2(:,15),heltab2x48(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(381),47,nMB,G2H2(74),n2h2(743))
  call Hloop_DV_C(ntryL,G1H48(16),32,wf24(:,21),G2H2(280),m3h24x2(:,16),heltab2x48(:,:,266))
  call Hloop_CV_D(ntryL,G1H48(17),32,wf24(:,21),15,G2H2(232),m3h24x2(:,17),heltab2x48(:,:,267))
  call Hloop_UV_W(ntryL,G1H48(18),32,wf24(:,21),15,G2H2(135),m3h24x2(:,18),heltab2x48(:,:,268))
  call Hloop_QA_V(ntryL,G1H48(19),ex2(:),G1H24(30),m3h2x24(:,169),heltab2x48(:,:,269))
  call Hloop_VA_Q(ntryL,G1H48(20),ex2(:),G1H24(82),m3h2x24(:,170),heltab2x48(:,:,270))
  call Hloop_A_Q(ntryL,G1H24(82),34,0,G2H24(29),n2h24(259))
  call Hloop_VA_Q(ntryL,G0H4(24),ex2(:),G0H2(1),m3h2x2(:,581),heltab2x4(:,:,709))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(1044),n2h2(744))
  call Hloop_QA_V(ntryL,G1H4(113),ex2(:),G1H2(382),m3h2x2(:,582),heltab2x4(:,:,710))
  call Hloop_QA_V(ntryL,G1H48(21),ex2(:),G1H24(84),m3h2x24(:,171),heltab2x48(:,:,271))
  call Hloop_VA_Q(ntryL,G1H48(22),ex2(:),G1H24(41),m3h2x24(:,172),heltab2x48(:,:,272))
  call Hloop_A_Q(ntryL,G1H24(41),34,0,G2H24(30),n2h24(260))
  call Hloop_QA_V(ntryL,G1H24(132),wf4(:,9),G1H6(98),m3h4x6(:,36),heltab2x24(:,:,600))
  call Hloop_QA_V(ntryL,G1H48(23),wf4(:,9),G1H12(127),m3h4x12(:,25),heltab2x48(:,:,273))
  call Hloop_VA_Q(ntryL,G1H48(24),wf4(:,9),G1H12(47),m3h4x12(:,26),heltab2x48(:,:,274))
  call Hloop_A_Q(ntryL,G1H12(47),38,0,G2H12(58),n2h12(408))
  call Hloop_VA_Q(ntryL,G0H8(7),wf4(:,9),G0H2(1),m3h4x2(:,43),heltab2x8(:,:,305))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(959),n2h2(745))
  call Hloop_QA_V(ntryL,G1H8(6),wf4(:,9),G1H2(383),m3h4x2(:,44),heltab2x8(:,:,306))
  call Hloop_AQ_V(ntryL,G1H48(25),wf6(:,4),G1H8(86),m3h6x8(:,17),heltab2x48(:,:,275))
  call Hloop_VQ_A(ntryL,G1H48(26),wf6(:,4),G1H8(87),m3h6x8(:,18),heltab2x48(:,:,276))
  call Hloop_Q_A(ntryL,G1H8(87),41,0,G2H8(40),n2h8(178))
  call Hloop_VQ_A(ntryL,G0H12(7),wf6(:,4),G0H2(1),m3h6x2(:,96),heltab2x12(:,:,792))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(393),n2h2(746))
  call Hloop_AQ_V(ntryL,G1H12(187),wf6(:,4),G1H2(421),m3h6x2(:,97),heltab2x12(:,:,793))
  call Hloop_AV_Q(ntryL,G1H48(31),wf24(:,2),G1H2(1059),m3h24x2(:,19),heltab2x48(:,:,277))
  call Hloop_A_Q(ntryL,G1H2(1059),47,0,G2H2(77),n2h2(747))
  call Hloop_AV_Q(ntryL,G1H48(28),wf24(:,2),G1H2(425),m3h24x2(:,20),heltab2x48(:,:,278))
  call Hloop_A_Q(ntryL,G1H2(425),47,nMT,G2H2(82),n2h2(748))
  call Hloop_QV_A(ntryL,G1H48(33),wf24(:,2),G1H2(1064),m3h24x2(:,21),heltab2x48(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(1064),47,0,G2H2(377),n2h2(749))
  call Hloop_QV_A(ntryL,G1H48(30),wf24(:,2),G1H2(426),m3h24x2(:,22),heltab2x48(:,:,280))
  call Hloop_Q_A(ntryL,G1H2(426),47,nMT,G2H2(580),n2h2(750))
  call Hloop_AV_Q(ntryL,G1H48(32),wf24(:,2),G1H2(969),m3h24x2(:,23),heltab2x48(:,:,281))
  call Hloop_A_Q(ntryL,G1H2(969),47,nMB,G2H2(258),n2h2(751))
  call Hloop_QV_A(ntryL,G1H48(34),wf24(:,2),G1H2(504),m3h24x2(:,24),heltab2x48(:,:,282))
  call Hloop_Q_A(ntryL,G1H2(504),47,nMB,G2H2(236),n2h2(752))
  call Hloop_DV_C(ntryL,G1H48(35),32,wf24(:,2),G2H2(130),m3h24x2(:,25),heltab2x48(:,:,283))
  call Hloop_CV_D(ntryL,G1H48(36),32,wf24(:,2),15,G2H2(87),m3h24x2(:,26),heltab2x48(:,:,284))
  call Hloop_UV_W(ntryL,G1H48(37),32,wf24(:,2),15,G2H2(94),m3h24x2(:,27),heltab2x48(:,:,285))
  call Hloop_QA_V(ntryL,G1H48(38),wf4(:,9),G1H12(55),m3h4x12(:,27),heltab2x48(:,:,286))
  call Hloop_VA_Q(ntryL,G1H48(39),wf4(:,9),G1H12(65),m3h4x12(:,28),heltab2x48(:,:,287))
  call Hloop_A_Q(ntryL,G1H12(65),38,0,G2H12(41),n2h12(409))
  call Hloop_VA_Q(ntryL,G0H12(6),wf4(:,9),G0H3(1),m3h4x3(:,46),heltab2x12(:,:,794))
  call Hloop_A_Q(ntryL,G0H3(1),55,0,G1H3(495),n2h3(237))
  call Hloop_QA_V(ntryL,G1H48(44),wf12(:,16),G1H4(219),m3h12x4(:,27),heltab2x48(:,:,288))
  call Hloop_VA_Q(ntryL,G1H48(41),wf12(:,16),G1H4(266),m3h12x4(:,28),heltab2x48(:,:,289))
  call Hloop_A_Q(ntryL,G1H4(266),46,0,G2H4(226),n2h4(618))
  call Hloop_VA_Q(ntryL,G0H24(22),wf12(:,16),G0H2(1),m3h12x2(:,101),heltab2x24(:,:,601))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(427),n2h2(753))
  call Hloop_QA_V(ntryL,G1H24(135),wf12(:,16),G1H2(438),m3h12x2(:,102),heltab2x24(:,:,602))
  call Hloop_AQ_V(ntryL,G1H24(138),ex1(:),G1H12(211),m3h2x12(:,330),heltab2x24(:,:,603))
  call Hloop_VQ_A(ntryL,G0H6(16),ex1(:),G0H3(1),m3h2x3(:,284),heltab2x6(:,:,724))
  call Hloop_Q_A(ntryL,G0H3(1),55,0,G1H3(88),n2h3(238))
  call Hloop_AV_Q(ntryL,G1H48(52),wf24(:,30),G1H2(480),m3h24x2(:,28),heltab2x48(:,:,290))
  call Hloop_A_Q(ntryL,G1H2(480),47,0,G2H2(302),n2h2(754))
  call Hloop_AV_Q(ntryL,G1H48(43),wf24(:,30),G1H2(481),m3h24x2(:,29),heltab2x48(:,:,291))
  call Hloop_A_Q(ntryL,G1H2(481),47,nMT,G2H2(103),n2h2(755))
  call Hloop_QV_A(ntryL,G1H48(54),wf24(:,30),G1H2(502),m3h24x2(:,30),heltab2x48(:,:,292))
  call Hloop_Q_A(ntryL,G1H2(502),47,0,G2H2(254),n2h2(756))
  call Hloop_QV_A(ntryL,G1H48(47),wf24(:,30),G1H2(503),m3h24x2(:,31),heltab2x48(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(503),47,nMT,G2H2(241),n2h2(757))
  call Hloop_AV_Q(ntryL,G1H48(49),wf24(:,30),G1H2(584),m3h24x2(:,32),heltab2x48(:,:,294))
  call Hloop_A_Q(ntryL,G1H2(584),47,nMB,G2H2(123),n2h2(758))
  call Hloop_QV_A(ntryL,G1H48(51),wf24(:,30),G1H2(559),m3h24x2(:,33),heltab2x48(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(559),47,nMB,G2H2(108),n2h2(759))
  call Hloop_DV_C(ntryL,G1H48(53),32,wf24(:,30),G2H2(111),m3h24x2(:,34),heltab2x48(:,:,296))
  call Hloop_CV_D(ntryL,G1H48(55),32,wf24(:,30),15,G2H2(345),m3h24x2(:,35),heltab2x48(:,:,297))
  call Hloop_UV_W(ntryL,G1H48(60),32,wf24(:,30),15,G2H2(573),m3h24x2(:,36),heltab2x48(:,:,298))
  call Hloop_AQ_V(ntryL,G1H48(57),ex1(:),G1H24(45),m3h2x24(:,173),heltab2x48(:,:,299))
  call Hloop_VQ_A(ntryL,G1H48(62),ex1(:),G1H24(54),m3h2x24(:,174),heltab2x48(:,:,300))
  call Hloop_Q_A(ntryL,G1H24(54),33,0,G2H24(31),n2h24(261))
  call Hloop_VQ_A(ntryL,G0H4(28),ex1(:),G0H2(1),m3h2x2(:,583),heltab2x4(:,:,711))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(548),n2h2(760))
  call Hloop_AQ_V(ntryL,G1H4(389),ex1(:),G1H2(590),m3h2x2(:,584),heltab2x4(:,:,712))
  call Hloop_AQ_V(ntryL,G1H48(59),ex1(:),G1H24(2),m3h2x24(:,175),heltab2x48(:,:,301))
  call Hloop_VQ_A(ntryL,G1H48(61),ex1(:),G1H24(53),m3h2x24(:,176),heltab2x48(:,:,302))
  call Hloop_Q_A(ntryL,G1H24(53),33,0,G2H24(32),n2h24(262))
  call Hloop_AQ_V(ntryL,G1H48(63),wf12(:,20),G1H4(84),m3h12x4(:,29),heltab2x48(:,:,303))
  call Hloop_VQ_A(ntryL,G1H48(64),wf12(:,20),G1H4(96),m3h12x4(:,30),heltab2x48(:,:,304))
  call Hloop_Q_A(ntryL,G1H4(96),45,0,G2H4(165),n2h4(619))
  call Hloop_AQ_V(ntryL,G1H48(65),wf6(:,4),G1H8(69),m3h6x8(:,19),heltab2x48(:,:,305))
  call Hloop_VQ_A(ntryL,G1H48(66),wf6(:,4),G1H8(9),m3h6x8(:,20),heltab2x48(:,:,306))
  call Hloop_Q_A(ntryL,G1H8(9),41,0,G2H8(6),n2h8(179))
  call Hloop_QV_A(ntryL,G1H48(71),ex3(:),G1H24(62),m3h2x24(:,177),heltab2x48(:,:,307))
  call Hloop_Q_A(ntryL,G1H24(62),36,0,G2H24(33),n2h24(263))
  call Hloop_QV_A(ntryL,G1H48(68),ex3(:),G1H24(67),m3h2x24(:,178),heltab2x48(:,:,308))
  call Hloop_Q_A(ntryL,G1H24(67),36,nMT,G2H24(34),n2h24(264))
  call Hloop_AV_Q(ntryL,G1H48(73),ex3(:),G1H24(68),m3h2x24(:,179),heltab2x48(:,:,309))
  call Hloop_A_Q(ntryL,G1H24(68),36,0,G2H24(5),n2h24(265))
  call Hloop_AV_Q(ntryL,G1H48(70),ex3(:),G1H24(42),m3h2x24(:,180),heltab2x48(:,:,310))
  call Hloop_A_Q(ntryL,G1H24(42),36,nMT,G2H24(6),n2h24(266))
  call Hloop_QV_A(ntryL,G1H48(72),ex3(:),G1H24(69),m3h2x24(:,181),heltab2x48(:,:,311))
  call Hloop_Q_A(ntryL,G1H24(69),36,nMB,G2H24(7),n2h24(267))
  call Hloop_AV_Q(ntryL,G1H48(74),ex3(:),G1H24(70),m3h2x24(:,182),heltab2x48(:,:,312))
  call Hloop_A_Q(ntryL,G1H24(70),36,nMB,G2H24(8),n2h24(268))
  call Hloop_VQ_A(ntryL,G0H24(27),wf12(:,20),G0H2(1),m3h12x2(:,103),heltab2x24(:,:,604))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(560),n2h2(761))
  call Hloop_AQ_V(ntryL,G1H24(141),wf12(:,20),G1H2(554),m3h12x2(:,104),heltab2x24(:,:,605))
  call Hloop_AV_Q(ntryL,G1H24(49),ex3(:),G1H12(102),m3h2x12(:,331),heltab2x24(:,:,606))
  call Hloop_A_Q(ntryL,G1H12(102),52,0,G2H12(52),n2h12(410))
  call Hloop_AV_Q(ntryL,G1H24(146),ex3(:),G1H12(168),m3h2x12(:,332),heltab2x24(:,:,607))
  call Hloop_A_Q(ntryL,G1H12(168),52,nMT,G2H12(48),n2h12(411))
  call Hloop_QV_A(ntryL,G1H24(39),ex3(:),G1H12(181),m3h2x12(:,333),heltab2x24(:,:,608))
  call Hloop_Q_A(ntryL,G1H12(181),52,0,G2H12(37),n2h12(412))
  call Hloop_QV_A(ntryL,G1H24(36),ex3(:),G1H12(109),m3h2x12(:,334),heltab2x24(:,:,609))
  call Hloop_Q_A(ntryL,G1H12(109),52,nMT,G2H12(62),n2h12(413))
  call Hloop_AV_Q(ntryL,G1H24(31),ex3(:),G1H12(103),m3h2x12(:,335),heltab2x24(:,:,610))
  call Hloop_A_Q(ntryL,G1H12(103),52,nMB,G2H12(65),n2h12(414))
  call Hloop_QV_A(ntryL,G1H24(97),ex3(:),G1H12(131),m3h2x12(:,336),heltab2x24(:,:,611))
  call Hloop_Q_A(ntryL,G1H12(131),52,nMB,G2H12(32),n2h12(415))
  call Hloop_QA_V(ntryL,G1H24(109),ex2(:),G1H12(132),m3h2x12(:,337),heltab2x24(:,:,612))
  call Hloop_VA_Q(ntryL,G0H4(31),ex2(:),G0H2(1),m3h2x2(:,585),heltab2x4(:,:,713))
  call Hloop_A_Q(ntryL,G0H2(1),59,0,G1H2(571),n2h2(762))
  call Hloop_QV_A(ntryL,G1H48(79),ex3(:),G1H24(72),m3h2x24(:,183),heltab2x48(:,:,313))
  call Hloop_Q_A(ntryL,G1H24(72),36,0,G2H24(35),n2h24(269))
  call Hloop_QV_A(ntryL,G1H48(80),ex3(:),G1H24(77),m3h2x24(:,184),heltab2x48(:,:,314))
  call Hloop_Q_A(ntryL,G1H24(77),36,nMT,G2H24(36),n2h24(270))
  call Hloop_AV_Q(ntryL,G1H48(83),ex3(:),G1H24(78),m3h2x24(:,185),heltab2x48(:,:,315))
  call Hloop_A_Q(ntryL,G1H24(78),36,0,G2H24(37),n2h24(271))
  call Hloop_AV_Q(ntryL,G1H48(82),ex3(:),G1H24(79),m3h2x24(:,186),heltab2x48(:,:,316))
  call Hloop_A_Q(ntryL,G1H24(79),36,nMT,G2H24(38),n2h24(272))
  call Hloop_QV_A(ntryL,G1H48(81),ex3(:),G1H24(16),m3h2x24(:,187),heltab2x48(:,:,317))
  call Hloop_Q_A(ntryL,G1H24(16),36,nMB,G2H24(39),n2h24(273))
  call Hloop_AV_Q(ntryL,G1H48(88),ex3(:),G1H24(22),m3h2x24(:,188),heltab2x48(:,:,318))
  call Hloop_A_Q(ntryL,G1H24(22),36,nMB,G2H24(40),n2h24(274))
  call Hloop_AV_Q(ntryL,G1H48(91),wf24(:,43),G1H2(565),m3h24x2(:,37),heltab2x48(:,:,319))
  call Hloop_A_Q(ntryL,G1H2(565),47,0,G2H2(284),n2h2(763))
  call Hloop_AV_Q(ntryL,G1H48(90),wf24(:,43),G1H2(596),m3h24x2(:,38),heltab2x48(:,:,320))
  call Hloop_A_Q(ntryL,G1H2(596),47,nMT,G2H2(245),n2h2(764))
  call Hloop_QV_A(ntryL,G1H48(93),wf24(:,43),G1H2(577),m3h24x2(:,39),heltab2x48(:,:,321))
  call Hloop_Q_A(ntryL,G1H2(577),47,0,G2H2(138),n2h2(765))
  call Hloop_QV_A(ntryL,G1H48(89),wf24(:,43),G1H2(566),m3h24x2(:,40),heltab2x48(:,:,322))
  call Hloop_Q_A(ntryL,G1H2(566),47,nMT,G2H2(114),n2h2(766))
  call Hloop_AV_Q(ntryL,G1H48(96),wf24(:,43),G1H2(602),m3h24x2(:,41),heltab2x48(:,:,323))
  call Hloop_A_Q(ntryL,G1H2(602),47,nMB,G2H2(271),n2h2(767))
  call Hloop_QV_A(ntryL,G1H48(98),wf24(:,43),G1H2(578),m3h24x2(:,42),heltab2x48(:,:,324))
  call Hloop_Q_A(ntryL,G1H2(578),47,nMB,G2H2(117),n2h2(768))
  call Hloop_DV_C(ntryL,G1H48(95),32,wf24(:,43),G2H2(22),m3h24x2(:,43),heltab2x48(:,:,325))
  call Hloop_CV_D(ntryL,G1H48(97),32,wf24(:,43),15,G2H2(437),m3h24x2(:,44),heltab2x48(:,:,326))
  call Hloop_UV_W(ntryL,G1H48(99),32,wf24(:,43),15,G2H2(120),m3h24x2(:,45),heltab2x48(:,:,327))
  call Hloop_QA_V(ntryL,G1H48(100),ex2(:),G1H24(24),m3h2x24(:,189),heltab2x48(:,:,328))
  call Hloop_VA_Q(ntryL,G1H48(101),ex2(:),G1H24(25),m3h2x24(:,190),heltab2x48(:,:,329))
  call Hloop_A_Q(ntryL,G1H24(25),34,0,G2H24(41),n2h24(275))
  call Hloop_QV_A(ntryL,G1H48(106),ex3(:),G1H24(26),m3h2x24(:,191),heltab2x48(:,:,330))
  call Hloop_Q_A(ntryL,G1H24(26),36,0,G2H24(42),n2h24(276))
  call Hloop_QV_A(ntryL,G1H48(103),ex3(:),G1H24(8),m3h2x24(:,192),heltab2x48(:,:,331))
  call Hloop_Q_A(ntryL,G1H24(8),36,nMT,G2H24(43),n2h24(277))
  call Hloop_AV_Q(ntryL,G1H48(108),ex3(:),G1H24(9),m3h2x24(:,193),heltab2x48(:,:,332))
  call Hloop_A_Q(ntryL,G1H24(9),36,0,G2H24(44),n2h24(278))
  call Hloop_AV_Q(ntryL,G1H48(105),ex3(:),G1H24(44),m3h2x24(:,194),heltab2x48(:,:,333))
  call Hloop_A_Q(ntryL,G1H24(44),36,nMT,G2H24(45),n2h24(279))
  call Hloop_QV_A(ntryL,G1H48(107),ex3(:),G1H24(85),m3h2x24(:,195),heltab2x48(:,:,334))
  call Hloop_Q_A(ntryL,G1H24(85),36,nMB,G2H24(46),n2h24(280))
  call Hloop_AV_Q(ntryL,G1H48(109),ex3(:),G1H24(76),m3h2x24(:,196),heltab2x48(:,:,335))
  call Hloop_A_Q(ntryL,G1H24(76),36,nMB,G2H24(47),n2h24(281))
  call Hloop_QA_V(ntryL,G1H48(110),ex2(:),G1H24(86),m3h2x24(:,197),heltab2x48(:,:,336))
  call Hloop_VA_Q(ntryL,G1H48(111),ex2(:),G1H24(87),m3h2x24(:,198),heltab2x48(:,:,337))
  call Hloop_A_Q(ntryL,G1H24(87),34,0,G2H24(48),n2h24(282))
  call Hloop_QA_V(ntryL,G1H48(112),wf6(:,2),G1H8(22),m3h6x8(:,21),heltab2x48(:,:,338))
  call Hloop_VA_Q(ntryL,G1H48(113),wf6(:,2),G1H8(45),m3h6x8(:,22),heltab2x48(:,:,339))
  call Hloop_A_Q(ntryL,G1H8(45),42,0,G2H8(27),n2h8(180))
  call Hloop_QA_V(ntryL,G1H48(114),wf12(:,22),G1H4(30),m3h12x4(:,31),heltab2x48(:,:,340))
  call Hloop_VA_Q(ntryL,G1H48(115),wf12(:,22),G1H4(17),m3h12x4(:,32),heltab2x48(:,:,341))
  call Hloop_A_Q(ntryL,G1H4(17),46,0,G2H4(153),n2h4(620))
  call Hloop_QV_A(ntryL,G1H48(120),ex3(:),G1H24(89),m3h2x24(:,199),heltab2x48(:,:,342))
  call Hloop_Q_A(ntryL,G1H24(89),36,0,G2H24(49),n2h24(283))
  call Hloop_QV_A(ntryL,G1H48(117),ex3(:),G1H24(91),m3h2x24(:,200),heltab2x48(:,:,343))
  call Hloop_Q_A(ntryL,G1H24(91),36,nMT,G2H24(50),n2h24(284))
  call Hloop_AV_Q(ntryL,G1H48(122),ex3(:),G1H24(51),m3h2x24(:,201),heltab2x48(:,:,344))
  call Hloop_A_Q(ntryL,G1H24(51),36,0,G2H24(51),n2h24(285))
  call Hloop_AV_Q(ntryL,G1H48(119),ex3(:),G1H24(92),m3h2x24(:,202),heltab2x48(:,:,345))
  call Hloop_A_Q(ntryL,G1H24(92),36,nMT,G2H24(52),n2h24(286))
  call Hloop_QV_A(ntryL,G1H48(121),ex3(:),G1H24(94),m3h2x24(:,203),heltab2x48(:,:,346))
  call Hloop_Q_A(ntryL,G1H24(94),36,nMB,G2H24(53),n2h24(287))
  call Hloop_AV_Q(ntryL,G1H48(123),ex3(:),G1H24(96),m3h2x24(:,204),heltab2x48(:,:,347))
  call Hloop_A_Q(ntryL,G1H24(96),36,nMB,G2H24(54),n2h24(288))
  call Hloop_VA_Q(ntryL,G0H24(28),wf12(:,22),G0H2(1),m3h12x2(:,105),heltab2x24(:,:,613))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(572),n2h2(769))
  call Hloop_QA_V(ntryL,G1H24(131),wf12(:,22),G1H2(589),m3h12x2(:,106),heltab2x24(:,:,614))
  call Hloop_AV_Q(ntryL,G1H24(38),ex3(:),G1H12(169),m3h2x12(:,338),heltab2x24(:,:,615))
  call Hloop_A_Q(ntryL,G1H12(169),52,0,G2H12(54),n2h12(416))
  call Hloop_AV_Q(ntryL,G1H24(19),ex3(:),G1H12(199),m3h2x12(:,339),heltab2x24(:,:,616))
  call Hloop_A_Q(ntryL,G1H12(199),52,nMT,G2H12(12),n2h12(417))
  call Hloop_QV_A(ntryL,G1H24(73),ex3(:),G1H12(205),m3h2x12(:,340),heltab2x24(:,:,617))
  call Hloop_Q_A(ntryL,G1H12(205),52,0,G2H12(13),n2h12(418))
  call Hloop_QV_A(ntryL,G1H24(13),ex3(:),G1H12(236),m3h2x12(:,341),heltab2x24(:,:,618))
  call Hloop_Q_A(ntryL,G1H12(236),52,nMT,G2H12(19),n2h12(419))
  call Hloop_AV_Q(ntryL,G1H24(33),ex3(:),G1H12(234),m3h2x12(:,342),heltab2x24(:,:,619))
  call Hloop_A_Q(ntryL,G1H12(234),52,nMB,G2H12(21),n2h12(420))
  call Hloop_QV_A(ntryL,G1H24(20),ex3(:),G1H12(12),m3h2x12(:,343),heltab2x24(:,:,620))
  call Hloop_Q_A(ntryL,G1H12(12),52,nMB,G2H12(34),n2h12(421))
  call Hloop_AQ_V(ntryL,G1H24(48),ex1(:),G1H12(63),m3h2x12(:,344),heltab2x24(:,:,621))
  call Hloop_VQ_A(ntryL,G0H4(32),ex1(:),G0H2(1),m3h2x2(:,586),heltab2x4(:,:,714))
  call Hloop_Q_A(ntryL,G0H2(1),59,0,G1H2(583),n2h2(770))
  call Hloop_QV_A(ntryL,G1H48(128),ex3(:),G1H24(55),m3h2x24(:,205),heltab2x48(:,:,348))
  call Hloop_Q_A(ntryL,G1H24(55),36,0,G2H24(9),n2h24(289))
  call Hloop_QV_A(ntryL,G1H48(125),ex3(:),G1H24(56),m3h2x24(:,206),heltab2x48(:,:,349))
  call Hloop_Q_A(ntryL,G1H24(56),36,nMT,G2H24(10),n2h24(290))
  call Hloop_AV_Q(ntryL,G1H48(130),ex3(:),G1H24(14),m3h2x24(:,207),heltab2x48(:,:,350))
  call Hloop_A_Q(ntryL,G1H24(14),36,0,G2H24(11),n2h24(291))
  call Hloop_AV_Q(ntryL,G1H48(127),ex3(:),G1H24(63),m3h2x24(:,208),heltab2x48(:,:,351))
  call Hloop_A_Q(ntryL,G1H24(63),36,nMT,G2H24(12),n2h24(292))
  call Hloop_QV_A(ntryL,G1H48(129),ex3(:),G1H24(98),m3h2x24(:,209),heltab2x48(:,:,352))
  call Hloop_Q_A(ntryL,G1H24(98),36,nMB,G2H24(13),n2h24(293))
  call Hloop_AV_Q(ntryL,G1H48(131),ex3(:),G1H24(101),m3h2x24(:,210),heltab2x48(:,:,353))
  call Hloop_A_Q(ntryL,G1H24(101),36,nMB,G2H24(14),n2h24(294))
  call Hloop_AV_Q(ntryL,G1H48(136),wf24(:,62),G1H2(626),m3h24x2(:,46),heltab2x48(:,:,354))
  call Hloop_A_Q(ntryL,G1H2(626),47,0,G2H2(331),n2h2(771))
  call Hloop_AV_Q(ntryL,G1H48(133),wf24(:,62),G1H2(614),m3h24x2(:,47),heltab2x48(:,:,355))
  call Hloop_A_Q(ntryL,G1H2(614),47,nMT,G2H2(126),n2h2(772))
  call Hloop_QV_A(ntryL,G1H48(138),wf24(:,62),G1H2(608),m3h24x2(:,48),heltab2x48(:,:,356))
  call Hloop_Q_A(ntryL,G1H2(608),47,0,G2H2(32),n2h2(773))
  call Hloop_QV_A(ntryL,G1H48(135),wf24(:,62),G1H2(625),m3h24x2(:,49),heltab2x48(:,:,357))
  call Hloop_Q_A(ntryL,G1H2(625),47,nMT,G2H2(440),n2h2(774))
  call Hloop_AV_Q(ntryL,G1H48(137),wf24(:,62),G1H2(620),m3h24x2(:,50),heltab2x48(:,:,358))
  call Hloop_A_Q(ntryL,G1H2(620),47,nMB,G2H2(129),n2h2(775))
  call Hloop_QV_A(ntryL,G1H48(139),wf24(:,62),G1H2(650),m3h24x2(:,51),heltab2x48(:,:,359))
  call Hloop_Q_A(ntryL,G1H2(650),47,nMB,G2H2(456),n2h2(776))
  call Hloop_DV_C(ntryL,G1H48(140),32,wf24(:,62),G2H2(444),m3h24x2(:,52),heltab2x48(:,:,360))
  call Hloop_CV_D(ntryL,G1H48(141),32,wf24(:,62),15,G2H2(139),m3h24x2(:,53),heltab2x48(:,:,361))
  call Hloop_UV_W(ntryL,G1H48(142),32,wf24(:,62),15,G2H2(131),m3h24x2(:,54),heltab2x48(:,:,362))
  call Hloop_QV_A(ntryL,G1H48(147),ex3(:),G1H24(104),m3h2x24(:,211),heltab2x48(:,:,363))
  call Hloop_Q_A(ntryL,G1H24(104),36,0,G2H24(15),n2h24(295))
  call Hloop_QV_A(ntryL,G1H48(144),ex3(:),G1H24(29),m3h2x24(:,212),heltab2x48(:,:,364))
  call Hloop_Q_A(ntryL,G1H24(29),36,nMT,G2H24(16),n2h24(296))
  call Hloop_AV_Q(ntryL,G1H48(149),ex3(:),G1H24(105),m3h2x24(:,213),heltab2x48(:,:,365))
  call Hloop_A_Q(ntryL,G1H24(105),36,0,G2H24(17),n2h24(297))
  call Hloop_AV_Q(ntryL,G1H48(146),ex3(:),G1H24(108),m3h2x24(:,214),heltab2x48(:,:,366))
  call Hloop_A_Q(ntryL,G1H24(108),36,nMT,G2H24(18),n2h24(298))
  call Hloop_QV_A(ntryL,G1H48(148),ex3(:),G1H24(110),m3h2x24(:,215),heltab2x48(:,:,367))
  call Hloop_Q_A(ntryL,G1H24(110),36,nMB,G2H24(19),n2h24(299))
  call Hloop_AV_Q(ntryL,G1H48(150),ex3(:),G1H24(114),m3h2x24(:,216),heltab2x48(:,:,368))
  call Hloop_A_Q(ntryL,G1H24(114),36,nMB,G2H24(20),n2h24(300))
  call Hloop_AQ_V(ntryL,G1H48(151),ex1(:),G1H24(117),m3h2x24(:,217),heltab2x48(:,:,369))
  call Hloop_VQ_A(ntryL,G1H48(152),ex1(:),G1H24(118),m3h2x24(:,218),heltab2x48(:,:,370))
  call Hloop_Q_A(ntryL,G1H24(118),33,0,G2H24(1),n2h24(301))
  call Hloop_AQ_V(ntryL,G1H48(153),ex1(:),G1H24(120),m3h2x24(:,219),heltab2x48(:,:,371))
  call Hloop_VQ_A(ntryL,G1H48(154),ex1(:),G1H24(124),m3h2x24(:,220),heltab2x48(:,:,372))
  call Hloop_Q_A(ntryL,G1H24(124),33,0,G2H24(2),n2h24(302))
  call Hloop_VA_Q(ntryL,G0H12(8),ex2(:),G0H6(12),m3h2x6(:,339),heltab2x12(:,:,795))
  call Hloop_A_Q(ntryL,G0H6(12),51,0,G1H6(109),n2h6(384))
  call Hloop_QA_V(ntryL,G1H48(155),wf12(:,24),G1H4(42),m3h12x4(:,33),heltab2x48(:,:,373))
  call Hloop_VA_Q(ntryL,G1H48(156),wf12(:,24),G1H4(43),m3h12x4(:,34),heltab2x48(:,:,374))
  call Hloop_A_Q(ntryL,G1H4(43),46,0,G2H4(6),n2h4(621))
  call Hloop_QA_V(ntryL,G1H48(157),ex2(:),G1H24(37),m3h2x24(:,221),heltab2x48(:,:,375))
  call Hloop_VA_Q(ntryL,G1H48(158),ex2(:),G1H24(40),m3h2x24(:,222),heltab2x48(:,:,376))
  call Hloop_A_Q(ntryL,G1H24(40),34,0,G2H24(3),n2h24(303))
  call Hloop_AQ_V(ntryL,G1H48(159),wf12(:,26),G1H4(47),m3h12x4(:,35),heltab2x48(:,:,377))
  call Hloop_VQ_A(ntryL,G1H48(160),wf12(:,26),G1H4(280),m3h12x4(:,36),heltab2x48(:,:,378))
  call Hloop_Q_A(ntryL,G1H4(280),45,0,G2H4(84),n2h4(622))
  call Hloop_VQ_A(ntryL,G0H12(9),ex1(:),G0H6(11),m3h2x6(:,340),heltab2x12(:,:,796))
  call Hloop_Q_A(ntryL,G0H6(11),51,0,G1H6(134),n2h6(385))
  call Hloop_AQ_V(ntryL,G1H48(161),ex1(:),G1H24(46),m3h2x24(:,223),heltab2x48(:,:,379))
  call Hloop_VQ_A(ntryL,G1H48(162),ex1(:),G1H24(52),m3h2x24(:,224),heltab2x48(:,:,380))
  call Hloop_Q_A(ntryL,G1H24(52),33,0,G2H24(4),n2h24(304))
  call Hloop_VA_Q(ntryL,G0H24(29),wf12(:,24),G0H2(1),m3h12x2(:,107),heltab2x24(:,:,622))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(638),n2h2(777))
  call Hloop_QA_V(ntryL,G1H24(4),wf12(:,24),G1H2(632),m3h12x2(:,108),heltab2x24(:,:,623))
  call Hloop_VQ_A(ntryL,G0H24(30),wf12(:,26),G0H2(1),m3h12x2(:,109),heltab2x24(:,:,624))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(649),n2h2(778))
  call Hloop_AQ_V(ntryL,G1H24(81),wf12(:,26),G1H2(644),m3h12x2(:,110),heltab2x24(:,:,625))
  call Hloop_QA_V(ntryL,G1H24(5),ex2(:),G1H12(249),m3h2x12(:,345),heltab2x24(:,:,626))
  call Hloop_AQ_V(ntryL,G1H24(127),ex1(:),G1H12(250),m3h2x12(:,346),heltab2x24(:,:,627))
  call Hloop_AV_Q(ntryL,G1H48(167),wf24(:,77),G1H2(722),m3h24x2(:,55),heltab2x48(:,:,381))
  call Hloop_A_Q(ntryL,G1H2(722),47,0,G2H2(589),n2h2(779))
  call Hloop_AV_Q(ntryL,G1H48(164),wf24(:,77),G1H2(716),m3h24x2(:,56),heltab2x48(:,:,382))
  call Hloop_A_Q(ntryL,G1H2(716),47,nMT,G2H2(70),n2h2(780))
  call Hloop_QV_A(ntryL,G1H48(169),wf24(:,77),G1H2(662),m3h24x2(:,57),heltab2x48(:,:,383))
  call Hloop_Q_A(ntryL,G1H2(662),47,0,G2H2(591),n2h2(781))
  call Hloop_QV_A(ntryL,G1H48(166),wf24(:,77),G1H2(656),m3h24x2(:,58),heltab2x48(:,:,384))
  call Hloop_Q_A(ntryL,G1H2(656),47,nMT,G2H2(291),n2h2(782))
  call Hloop_AV_Q(ntryL,G1H48(168),wf24(:,77),G1H2(764),m3h24x2(:,59),heltab2x48(:,:,385))
  call Hloop_A_Q(ntryL,G1H2(764),47,nMB,G2H2(267),n2h2(783))
  call Hloop_QV_A(ntryL,G1H48(170),wf24(:,77),G1H2(758),m3h24x2(:,60),heltab2x48(:,:,386))
  call Hloop_Q_A(ntryL,G1H2(758),47,nMB,G2H2(140),n2h2(784))
  call Hloop_DV_C(ntryL,G1H48(171),32,wf24(:,77),G2H2(132),m3h24x2(:,61),heltab2x48(:,:,387))
  call Hloop_CV_D(ntryL,G1H48(172),32,wf24(:,77),15,G2H2(320),m3h24x2(:,62),heltab2x48(:,:,388))
  call Hloop_UV_W(ntryL,G1H48(173),32,wf24(:,77),15,G2H2(133),m3h24x2(:,63),heltab2x48(:,:,389))
  call Hloop_AV_Q(ntryL,G1H48(178),wf24(:,78),G1H2(674),m3h24x2(:,64),heltab2x48(:,:,390))
  call Hloop_A_Q(ntryL,G1H2(674),47,0,G2H2(24),n2h2(785))
  call Hloop_AV_Q(ntryL,G1H48(175),wf24(:,78),G1H2(668),m3h24x2(:,65),heltab2x48(:,:,391))
  call Hloop_A_Q(ntryL,G1H2(668),47,nMT,G2H2(449),n2h2(786))
  call Hloop_QV_A(ntryL,G1H48(180),wf24(:,78),G1H2(710),m3h24x2(:,66),heltab2x48(:,:,392))
  call Hloop_Q_A(ntryL,G1H2(710),47,0,G2H2(134),n2h2(787))
  call Hloop_QV_A(ntryL,G1H48(177),wf24(:,78),G1H2(704),m3h24x2(:,67),heltab2x48(:,:,393))
  call Hloop_Q_A(ntryL,G1H2(704),47,nMT,G2H2(294),n2h2(788))
  call Hloop_AV_Q(ntryL,G1H48(179),wf24(:,78),G1H2(686),m3h24x2(:,68),heltab2x48(:,:,394))
  call Hloop_A_Q(ntryL,G1H2(686),47,nMB,G2H2(136),n2h2(789))
  call Hloop_QV_A(ntryL,G1H48(181),wf24(:,78),G1H2(680),m3h24x2(:,69),heltab2x48(:,:,395))
  call Hloop_Q_A(ntryL,G1H2(680),47,nMB,G2H2(27),n2h2(790))
  call Hloop_DV_C(ntryL,G1H48(182),32,wf24(:,78),G2H2(452),m3h24x2(:,70),heltab2x48(:,:,396))
  call Hloop_CV_D(ntryL,G1H48(183),32,wf24(:,78),15,G2H2(137),m3h24x2(:,71),heltab2x48(:,:,397))
  call Hloop_UV_W(ntryL,G1H48(184),32,wf24(:,78),15,G2H2(460),m3h24x2(:,72),heltab2x48(:,:,398))
  call Hloop_QA_V(ntryL,G1H48(185),ex2(:),G1H24(64),m3h2x24(:,225),heltab2x48(:,:,399))
  call Hloop_VA_Q(ntryL,G1H48(186),ex2(:),G1H24(32),m3h2x24(:,226),heltab2x48(:,:,400))
  call Hloop_A_Q(ntryL,G1H24(32),34,0,G2H24(21),n2h24(305))
  call Hloop_AQ_V(ntryL,G1H48(187),ex1(:),G1H24(34),m3h2x24(:,227),heltab2x48(:,:,401))
  call Hloop_VQ_A(ntryL,G1H48(188),ex1(:),G1H24(147),m3h2x24(:,228),heltab2x48(:,:,402))
  call Hloop_Q_A(ntryL,G1H24(147),33,0,G2H24(22),n2h24(306))
  call Hloop_QA_V(ntryL,G1H48(189),ex2(:),G1H24(148),m3h2x24(:,229),heltab2x48(:,:,403))
  call Hloop_VA_Q(ntryL,G1H48(190),ex2(:),G1H24(149),m3h2x24(:,230),heltab2x48(:,:,404))
  call Hloop_A_Q(ntryL,G1H24(149),34,0,G2H24(23),n2h24(307))
  call Hloop_QV_A(ntryL,G1H48(195),ex3(:),G1H24(150),m3h2x24(:,231),heltab2x48(:,:,405))
  call Hloop_Q_A(ntryL,G1H24(150),36,0,G2H24(24),n2h24(308))
  call Hloop_QV_A(ntryL,G1H48(192),ex3(:),G1H24(152),m3h2x24(:,232),heltab2x48(:,:,406))
  call Hloop_Q_A(ntryL,G1H24(152),36,nMT,G2H24(25),n2h24(309))
  call Hloop_AV_Q(ntryL,G1H48(197),ex3(:),G1H24(153),m3h2x24(:,233),heltab2x48(:,:,407))
  call Hloop_A_Q(ntryL,G1H24(153),36,0,G2H24(26),n2h24(310))
  call Hloop_AV_Q(ntryL,G1H48(194),ex3(:),G1H24(154),m3h2x24(:,234),heltab2x48(:,:,408))
  call Hloop_A_Q(ntryL,G1H24(154),36,nMT,G2H24(27),n2h24(311))
  call Hloop_QV_A(ntryL,G1H48(196),ex3(:),G1H24(155),m3h2x24(:,235),heltab2x48(:,:,409))
  call Hloop_Q_A(ntryL,G1H24(155),36,nMB,G2H24(28),n2h24(312))
  call Hloop_AV_Q(ntryL,G1H48(198),ex3(:),G1H24(157),m3h2x24(:,236),heltab2x48(:,:,410))
  call Hloop_A_Q(ntryL,G1H24(157),36,nMB,G2H24(55),n2h24(313))
  call Hloop_QA_V(ntryL,G1H48(199),ex2(:),G1H24(158),m3h2x24(:,237),heltab2x48(:,:,411))
  call Hloop_VA_Q(ntryL,G1H48(200),ex2(:),G1H24(159),m3h2x24(:,238),heltab2x48(:,:,412))
  call Hloop_A_Q(ntryL,G1H24(159),34,0,G2H24(56),n2h24(314))
  call Hloop_QV_A(ntryL,G1H48(205),ex3(:),G1H24(160),m3h2x24(:,239),heltab2x48(:,:,413))
  call Hloop_Q_A(ntryL,G1H24(160),36,0,G2H24(57),n2h24(315))
  call Hloop_QV_A(ntryL,G1H48(202),ex3(:),G1H24(162),m3h2x24(:,240),heltab2x48(:,:,414))
  call Hloop_Q_A(ntryL,G1H24(162),36,nMT,G2H24(58),n2h24(316))
  call Hloop_AV_Q(ntryL,G1H48(207),ex3(:),G1H24(163),m3h2x24(:,241),heltab2x48(:,:,415))
  call Hloop_A_Q(ntryL,G1H24(163),36,0,G2H24(59),n2h24(317))
  call Hloop_AV_Q(ntryL,G1H48(204),ex3(:),G1H24(164),m3h2x24(:,242),heltab2x48(:,:,416))
  call Hloop_A_Q(ntryL,G1H24(164),36,nMT,G2H24(60),n2h24(318))
  call Hloop_QV_A(ntryL,G1H48(206),ex3(:),G1H24(165),m3h2x24(:,243),heltab2x48(:,:,417))
  call Hloop_Q_A(ntryL,G1H24(165),36,nMB,G2H24(61),n2h24(319))
  call Hloop_AV_Q(ntryL,G1H48(208),ex3(:),G1H24(167),m3h2x24(:,244),heltab2x48(:,:,418))
  call Hloop_A_Q(ntryL,G1H24(167),36,nMB,G2H24(62),n2h24(320))
  call Hloop_AQ_V(ntryL,G1H48(209),ex1(:),G1H24(168),m3h2x24(:,245),heltab2x48(:,:,419))
  call Hloop_VQ_A(ntryL,G1H48(210),ex1(:),G1H24(58),m3h2x24(:,246),heltab2x48(:,:,420))
  call Hloop_Q_A(ntryL,G1H24(58),33,0,G2H24(63),n2h24(321))
  call Hloop_AQ_V(ntryL,G1H48(211),ex1(:),G1H24(60),m3h2x24(:,247),heltab2x48(:,:,421))
  call Hloop_VQ_A(ntryL,G1H48(212),ex1(:),G1H24(170),m3h2x24(:,248),heltab2x48(:,:,422))
  call Hloop_Q_A(ntryL,G1H24(170),33,0,G2H24(64),n2h24(322))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(536),[G2H2(413),G2H2(410),G2H2(127),G2H2(353)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(454),[G2H2(252),G2H2(234),G2H2(124),G2H2(354)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(535),[G2H2(206),G2H2(204),G2H2(125),G2H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(296),[G2H2(443),G2H2(429),G2H2(218),G2H2(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(382),G2H2(107),G2H2(100),G2H2(45),G2H2(229) &
    ,G2H2(118),G2H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(278),[G2H2(401),G2H2(115),G2H2(575),G2H2(46),G2H2(224) &
    ,G2H2(42),G2H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(343),[G2H2(333),G2H2(19),G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(511),[G2H2(202),G2H2(21),G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(95),[G2H4(94),G2H4(158),G2H4(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(210),[G2H4(194),G2H4(204),G2H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(101),[G2H4(170),G2H4(124),G2H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(222),G2H4(126),G2H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(34),[G2H6(26),G2H6(14),G2H6(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(72),[G2H6(122),G2H6(64),G2H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(45),[G2H6(98),G2H6(67),G2H6(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(22),[G2H6(8),G2H6(47),G2H6(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(83),[G2H4(8),G2H4(88),G2H4(137),G2H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(153),G2H4(226),G2H4(17),G2H4(76),G2H4(71) &
    ,G2H4(138),G2H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(217),[G2H4(36),G2H4(24),G2H4(155),G2H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G2H4(165),G2H4(69),G2H4(30),G2H4(80),G2H4(79) &
    ,G2H4(156),G2H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(260),[G1H3(236),G1H3(3),G1H3(98)])
call HGT_w2_OLR(G1H3(12),1,1,3)
call HGT_w2_invQ_OLR(G1H3(12),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(12),[G1H3(260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(57),[G1H3(248),G1H3(458),G1H3(233),G1H3(102)])
call HGT_w2_OLR(G1H3(18),1,1,3)
call HGT_w2_invQ_OLR(G1H3(18),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(18),[G1H3(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(126),[G1H2(416),G1H2(1060),G1H2(635)])
call HGT_w2_OLR(G1H2(142),1,1,2)
call HGT_w2_invQ_OLR(G1H2(142),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(142),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(649),[G1H2(560),G1H2(482),G1H2(27),G1H2(837),G1H2(804) &
    ,G1H2(636)])
call HGT_w2_OLR(G1H2(170),1,1,2)
call HGT_w2_invQ_OLR(G1H2(170),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(170),[G1H2(649)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(190),[G1H2(30),G1H2(871),G1H2(990)])
call HGT_w2_OLR(G1H2(182),1,1,2)
call HGT_w2_invQ_OLR(G1H2(182),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(182),[G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(573),G1H2(1076),G1H2(896),G1H2(647)])
call HGT_w2_OLR(G1H2(192),1,1,2)
call HGT_w2_invQ_OLR(G1H2(192),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(192),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(429),[G1H2(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(537),[G1H2(533),G1H2(527),G1H2(639),G1H2(335)])
call HGT_w2_OLR(G1H2(429),1,1,2)
call HGT_w2_invQ_OLR(G1H2(429),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(429),[G1H2(537)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(46),[G1H3(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(37),[G1H3(139),G1H3(64),G1H3(173),G1H3(429)])
call HGT_w2_OLR(G1H3(46),1,1,3)
call HGT_w2_invQ_OLR(G1H3(46),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(46),[G1H3(37)])
call ol_merge_last(G1H2(231), G1H2(231)) 
call ol_merge_last(G1H2(413), G1H2(413)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(441),[G2H2(209),G1H2(413),G1H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(538),[G1H2(348),G1H2(8),G1H2(591),G1H2(885),G1H2(357)])
call HGT_OLR(G2H2(441),1,1,2)
call HGT_invQ_OLR(G2H2(441),2,5,2)
call HGT_OLR(G2H2(441),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(441),[G2H2(538)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(434),[G1H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(691),[G1H2(223),G1H2(168),G1H2(90),G1H2(374)])
call HGT_w2_OLR(G1H2(434),1,1,2)
call HGT_w2_invQ_OLR(G1H2(434),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(434),[G1H2(691)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(77),[G1H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(326),[G1H3(65),G1H3(69),G1H3(504),G1H3(404)])
call HGT_w2_OLR(G1H3(77),1,1,3)
call HGT_w2_invQ_OLR(G1H3(77),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(77),[G1H3(326)])
call ol_merge_last(G1H2(253), G1H2(253)) 
call ol_merge_last(G1H2(418), G1H2(418)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(432),[G2H2(205),G1H2(418),G1H2(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(541),[G1H2(507),G1H2(453),G1H2(661),G1H2(172) &
    ,G1H2(675)])
call HGT_OLR(G2H2(432),1,1,2)
call HGT_invQ_OLR(G2H2(432),2,5,2)
call HGT_OLR(G2H2(432),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(432),[G2H2(541)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(347),[G1H2(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(336),[G1H2(199),G1H2(175),G1H2(45)])
call HGT_w2_OLR(G1H2(347),1,1,2)
call HGT_w2_invQ_OLR(G1H2(347),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(347),[G1H2(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(17),[G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(58),[G1H3(409),G1H3(483),G1H3(304),G1H3(293)])
call HGT_w2_OLR(G1H3(17),1,1,3)
call HGT_w2_invQ_OLR(G1H3(17),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(17),[G1H3(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(59),[G1H3(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(495),[G1H3(434),G1H3(503),G1H3(323),G1H3(413)])
call HGT_w2_OLR(G1H3(59),1,1,3)
call HGT_w2_invQ_OLR(G1H3(59),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(59),[G1H3(495)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(351),[G1H2(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(379),[G1H2(107),G1H2(48),G1H2(1071)])
call HGT_w2_OLR(G1H2(351),1,1,2)
call HGT_w2_invQ_OLR(G1H2(351),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(351),[G1H2(379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(273),[G1H2(651),G1H2(785),G1H2(774)])
call HGT_w2_OLR(G1H2(298),1,1,2)
call HGT_w2_invQ_OLR(G1H2(298),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(298),[G1H2(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(76),[G1H3(53),G1H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(38),[G1H3(94),G1H3(381),G1H3(351),G1H3(479),G1H3(383)])
call HGT_w2_OLR(G1H3(76),1,1,3)
call HGT_w2_invQ_OLR(G1H3(76),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(76),[G1H3(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(357),[G1H3(237),G1H3(208),G1H3(196)])
call HGT_w2_OLR(G1H3(2),1,1,3)
call HGT_w2_invQ_OLR(G1H3(2),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(393),[G1H2(395),G1H2(846),G1H2(834)])
call HGT_w2_OLR(G1H2(303),1,1,2)
call HGT_w2_invQ_OLR(G1H2(303),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(303),[G1H2(393)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(91),[G1H3(75),G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(88),[G1H3(356),G1H3(321),G1H3(291),G1H3(16),G1H3(364)])
call HGT_w2_OLR(G1H3(91),1,1,3)
call HGT_w2_invQ_OLR(G1H3(91),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(91),[G1H3(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(297),[G1H3(459),G1H3(438),G1H3(244)])
call HGT_w2_OLR(G1H3(10),1,1,3)
call HGT_w2_invQ_OLR(G1H3(10),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(10),[G1H3(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(959),[G1H2(627),G1H2(1075),G1H2(815)])
call HGT_w2_OLR(G1H2(307),1,1,2)
call HGT_w2_invQ_OLR(G1H2(307),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(307),[G1H2(959)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(606),[G1H2(875),G1H2(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(571),[G1H2(813),G1H2(765),G1H2(561),G1H2(186)])
call HGT_w2_OLR(G1H2(606),1,1,2)
call HGT_w2_invQ_OLR(G1H2(606),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(606),[G1H2(571)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(103),[G2H6(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(377),[G1H2(244),G1H2(237)])
call HGT_w2_OLR(G1H2(313),1,1,2)
call HGT_w2_invQ_OLR(G1H2(313),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(313),[G1H2(377)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(304),[G1H2(358),G1H2(955),G1H2(755)])
call HGT_w2_OLR(G1H2(314),1,1,2)
call HGT_w2_invQ_OLR(G1H2(314),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(314),[G1H2(304)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(975),[G1H2(600),G1H2(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(583),[G1H2(735),G1H2(310),G1H2(558),G1H2(108)])
call HGT_w2_OLR(G1H2(975),1,1,2)
call HGT_w2_invQ_OLR(G1H2(975),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(975),[G1H2(583)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(106),[G2H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(741),[G1H2(428),G1H2(165)])
call HGT_w2_OLR(G1H2(319),1,1,2)
call HGT_w2_invQ_OLR(G1H2(319),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(319),[G1H2(741)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(30),[G1H6(465),G1H6(238)])
call HGT_w2_OLR(G1H6(370),1,1,6)
call HGT_w2_invQ_OLR(G1H6(370),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(370),[G1H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(388),[G1H6(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(109),[G1H6(133),G1H6(247),G1H6(483)])
call HGT_w2_OLR(G1H6(388),1,1,6)
call HGT_w2_invQ_OLR(G1H6(388),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(388),[G1H6(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(177),[G1H6(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(134),[G1H6(234),G1H6(270),G1H6(447)])
call HGT_w2_OLR(G1H6(177),1,1,6)
call HGT_w2_invQ_OLR(G1H6(177),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(177),[G1H6(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(529),[G1H2(845),G1H2(94),G1H2(832)])
call HGT_OLR(G2H2(467),1,1,2)
call HGT_invQ_OLR(G2H2(467),2,5,2)
call HGT_OLR(G2H2(467),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(467),[G1H2(529)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G2H2(591),G2H2(32),G2H2(138),G2H2(254),G2H2(377) &
    ,G2H2(37),G2H2(228),G2H2(461),G2H2(364),G2H2(470),G1H2(211),G1H2(545),G1H2(74),G1H2(851),G1H2(1065),G1H2(797),G1H2(767) &
    ,G1H2(950),G1H2(726),G1H2(1020)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(229),[G1H2(138),G1H2(208),G1H2(22)])
call HGT_OLR(G2H2(479),1,1,2)
call HGT_invQ_OLR(G2H2(479),2,5,2)
call HGT_OLR(G2H2(479),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(479),[G1H2(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(589),G2H2(331),G2H2(284),G2H2(302),G2H2(77) &
    ,G2H2(400),G2H2(88),G2H2(486),G2H2(383),G2H2(326),G1H2(277),G1H2(143),G1H2(655),G1H2(976),G1H2(951),G1H2(827),G1H2(786) &
    ,G1H2(696),G1H2(677),G1H2(666)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(45),[G1H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(116),[G1H3(302),G1H3(55),G1H3(118),G1H3(454)])
call HGT_w2_OLR(G1H3(45),1,1,3)
call HGT_w2_invQ_OLR(G1H3(45),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(45),[G1H3(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(407),[G1H2(385)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(210),[G1H2(475),G1H2(498),G1H2(539),G1H2(391)])
call HGT_w2_OLR(G1H2(407),1,1,2)
call HGT_w2_invQ_OLR(G1H2(407),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(407),[G1H2(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(423),[G1H2(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(332),[G1H2(63),G1H2(549),G1H2(615),G1H2(424)])
call HGT_w2_OLR(G1H2(423),1,1,2)
call HGT_w2_invQ_OLR(G1H2(423),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(423),[G1H2(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(146),[G1H2(109),G1H2(23),G1H2(227),G1H2(711)])
call HGT_w2_OLR(G1H2(406),1,1,2)
call HGT_w2_invQ_OLR(G1H2(406),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(406),[G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(380),[G1H3(150),G1H3(183),G1H3(261),G1H3(227)])
call HGT_w2_OLR(G1H3(34),1,1,3)
call HGT_w2_invQ_OLR(G1H3(34),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(34),[G1H3(380)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(523),[G1H2(517),G1H2(513),G1H2(723),G1H2(669)])
call HGT_w2_OLR(G1H2(412),1,1,2)
call HGT_w2_invQ_OLR(G1H2(412),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(412),[G1H2(523)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(194),[G1H6(268)])
call HGT_w2_OLR(G1H6(387),1,1,6)
call HGT_w2_invQ_OLR(G1H6(387),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(387),[G1H6(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(870),[G1H2(546),G1H2(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1044),[G1H2(535),G1H2(149),G1H2(570),G1H2(219)])
call HGT_w2_OLR(G1H2(870),1,1,2)
call HGT_w2_invQ_OLR(G1H2(870),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(870),[G1H2(1044)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G2H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(605),[G1H2(599),G1H2(439)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(548),[G1H2(80),G1H2(320),G1H2(46),G1H2(119)])
call HGT_w2_OLR(G1H2(605),1,1,2)
call HGT_w2_invQ_OLR(G1H2(605),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(605),[G1H2(548)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G2H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(53),[G1H12(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(438),[G2H2(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(543),[G1H2(140)])
call HGT_OLR(G2H2(438),1,1,2)
call HGT_invQ_OLR(G2H2(438),2,5,2)
call HGT_OLR(G2H2(438),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(438),[G2H2(543)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(57),[G1H12(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(1),[G1H12(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(445),[G2H2(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(544),[G1H2(1078)])
call HGT_OLR(G2H2(445),1,1,2)
call HGT_invQ_OLR(G2H2(445),2,5,2)
call HGT_OLR(G2H2(445),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(445),[G2H2(544)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(4),[G1H12(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(450),[G2H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(546),[G1H2(392)])
call HGT_OLR(G2H2(450),1,1,2)
call HGT_invQ_OLR(G2H2(450),2,5,2)
call HGT_OLR(G2H2(450),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(450),[G2H2(546)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(30),[G1H12(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(453),[G2H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(549),[G1H2(370)])
call HGT_OLR(G2H2(453),1,1,2)
call HGT_invQ_OLR(G2H2(453),2,5,2)
call HGT_OLR(G2H2(453),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(453),[G2H2(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(35),[G1H12(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(449),[G2H2(70),G2H2(126),G2H2(245),G2H2(103),G2H2(82) &
    ,G2H2(57),G2H2(73),G2H2(498),G2H2(390),G2H2(237),G1H2(16),G1H2(543)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(294),[G2H2(291),G2H2(440),G2H2(114),G2H2(241),G2H2(580) &
    ,G2H2(65),G2H2(222),G2H2(472),G2H2(371),G2H2(259),G1H2(120),G1H2(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(136),[G2H2(267),G2H2(129),G2H2(271),G2H2(123),G2H2(258) &
    ,G2H2(262),G2H2(13),G2H2(519),G2H2(422),G2H2(292),G1H2(924),G1H2(1012)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G2H2(140),G2H2(456),G2H2(117),G2H2(108),G2H2(236) &
    ,G2H2(74),G2H2(409),G2H2(513),G2H2(402),G2H2(329),G1H2(70),G1H2(66)])
call HGT_OLR(G2H12(42),1,1,12)
call HGT_invQ_OLR(G2H12(42),2,5,12)
call HGT_OLR(G2H12(42),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(42),[G2H12(37)])
call HGT_OLR(G2H12(40),1,1,12)
call HGT_invQ_OLR(G2H12(40),2,5,12)
call HGT_OLR(G2H12(40),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(40),[G2H12(62)])
call HGT_OLR(G2H12(29),1,1,12)
call HGT_invQ_OLR(G2H12(29),2,5,12)
call HGT_OLR(G2H12(29),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(29),[G2H12(52)])
call HGT_OLR(G2H12(44),1,1,12)
call HGT_invQ_OLR(G2H12(44),2,5,12)
call HGT_OLR(G2H12(44),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(44),[G2H12(48)])
call HGT_OLR(G2H12(68),1,1,12)
call HGT_invQ_OLR(G2H12(68),2,5,12)
call HGT_OLR(G2H12(68),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(68),[G2H12(32)])
call HGT_OLR(G2H12(72),1,1,12)
call HGT_invQ_OLR(G2H12(72),2,5,12)
call HGT_OLR(G2H12(72),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(72),[G2H12(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(58),[G2H12(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(28),[G1H12(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(27),[G1H12(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(45),[G1H12(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(66),[G1H12(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(10),[G1H12(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(17),[G1H12(151)])
call HGT_OLR(G2H12(22),1,1,12)
call HGT_invQ_OLR(G2H12(22),2,5,12)
call HGT_OLR(G2H12(22),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(22),[G2H12(13)])
call HGT_OLR(G2H12(39),1,1,12)
call HGT_invQ_OLR(G2H12(39),2,5,12)
call HGT_OLR(G2H12(39),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(39),[G2H12(19)])
call HGT_OLR(G2H12(23),1,1,12)
call HGT_invQ_OLR(G2H12(23),2,5,12)
call HGT_OLR(G2H12(23),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(23),[G2H12(54)])
call HGT_OLR(G2H12(25),1,1,12)
call HGT_invQ_OLR(G2H12(25),2,5,12)
call HGT_OLR(G2H12(25),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(25),[G2H12(12)])
call HGT_OLR(G2H12(15),1,1,12)
call HGT_invQ_OLR(G2H12(15),2,5,12)
call HGT_OLR(G2H12(15),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(15),[G2H12(34)])
call HGT_OLR(G2H12(18),1,1,12)
call HGT_invQ_OLR(G2H12(18),2,5,12)
call HGT_OLR(G2H12(18),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(18),[G2H12(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(16),[G2H12(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G2H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(41),[G2H12(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(36),[G2H12(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(644),[G1H2(554),G1H2(350),G1H2(322),G1H2(466),G1H2(246) &
    ,G1H2(895)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(460),[G2H2(133),G2H2(131),G2H2(120),G2H2(573),G2H2(94) &
    ,G2H2(135),G2H2(25),G1H2(97),G1H2(366),G1H2(592),G1H2(520),G1H2(411),G1H2(296),G1H2(900),G1H2(617)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(632),[G1H2(589),G1H2(438),G1H2(463),G1H2(562),G1H2(356) &
    ,G1H2(624)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(220),[G1H2(684),G1H2(665),G1H2(654)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(633),[G1H2(575),G1H2(816),G1H2(920),G1H2(995)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G2H2(554),G1H2(158),G1H2(657),G1H2(1050),G1H2(695) &
    ,G1H2(925)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(365),[G1H3(353),G1H3(125),G1H3(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(327),[G1H3(129),G1H3(245),G1H3(141),G1H3(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(149),[G1H3(338),G1H3(272),G1H3(305),G1H3(256),G1H3(428) &
    ,G1H3(223),G1H3(142),G1H3(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(129),[G1H2(945),G1H2(714),G1H2(1015)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(609),[G1H2(587),G1H2(756),G1H2(725),G1H2(707)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(562),[G2H2(551),G1H2(13),G1H2(519),G1H2(1085),G1H2(744) &
    ,G1H2(737)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(513),[G1H3(334),G1H3(168),G1H3(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(387),[G1H3(267),G1H3(197),G1H3(180),G1H3(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(366),[G1H3(128),G1H3(314),G1H3(473),G1H3(286),G1H3(275) &
    ,G1H3(212),G1H3(185),G1H3(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(386),[G1H2(637),G1H2(87),G1H2(901),G1H2(876)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(464),[G1H2(667),G1H2(946),G1H2(921)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(638),[G1H2(572),G1H2(427),G1H2(85),G1H2(430),G1H2(971) &
    ,G1H2(926)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(106),[G1H3(362),G1H3(274),G1H3(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(258),[G1H3(192),G1H3(316),G1H3(453),G1H3(393)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(50),[G1H2(1007),G1H2(1021),G1H2(996)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1022),[G1H2(139),G1H2(89),G1H2(1046),G1H2(1001)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(115),[G1H2(1027),G1H2(191),G1H2(1051),G1H2(1026)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(305),[G1H2(258),G1H2(290),G1H2(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(283),[G1H2(254),G1H2(400),G1H2(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(421),[G1H2(1087),G1H2(510),G1H2(455)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(383),[G1H2(286),G1H2(586),G1H2(556)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(54),[G1H2(616)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(456),[G1H2(652),G1H2(622)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(5),[G1H2(646)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(473),[G1H2(274),G1H2(676)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(777),[G1H2(490),G1H2(682)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(58),[G1H2(706)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(511),[G1H2(742),G1H2(712)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(802),[G1H2(736)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(526),[G1H2(325),G1H2(766)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(294),[G1H2(542),G1H2(772)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(478),[G1H6(409),G1H6(391)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(482),[G1H6(23),G1H6(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(5),[G1H6(421),G1H6(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(463),[G1H6(457),G1H6(397)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(207),[G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(30),G1H4(219),G1H4(321),G1H4(134),G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(147),[G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(199),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(84),G1H4(259),G1H4(215),G1H4(93),G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(252),[G1H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(506),[G1H2(489),G1H2(468),G1H2(59),G1H2(796)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(826)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(541),[G1H2(522),G1H2(451),G1H2(1),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(184),[G1H3(484),G1H3(376),G1H3(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(41),[G1H3(509),G1H3(488),G1H3(346)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(187),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(476),[G1H2(295),G1H2(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(795),[G1H2(687),G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(590),[G1H2(104),G1H2(454),G1H2(166),G1H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(375),[G1H2(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(382),[G1H2(155),G1H2(547),G1H2(607),G1H2(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(693),[G1H2(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(474),[G1H6(470),G1H6(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(98),[G1H6(404)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(479),[G1H6(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(445),[G1H6(3),G1H6(415)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(79),[G1H6(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(492),[G1H6(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(246),[G1H6(199),G1H6(428)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(18),[G1H6(216),G1H6(434)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(53),[G1H6(230),G1H6(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(238),[G1H4(360),G1H4(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(232),[G1H4(359),G1H4(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(229),[G1H6(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(62),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(86),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(127),[G1H12(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(91),[G1H12(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(55),[G1H12(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(69),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(74),[G1H12(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(7),[G1H12(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G1H12(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(61),[G1H12(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(63),[G1H12(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(64),[G1H12(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(67),[G1H12(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(552),G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(225),[G2H2(557),G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(219),[G2H2(559),G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(560),G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(71),[G1H12(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(74),[G1H12(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(46),[G1H12(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(50),[G1H12(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(51),[G1H12(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(55),[G1H12(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(452),[G2H2(132),G2H2(444),G2H2(22),G2H2(111),G2H2(130) &
    ,G2H2(280),G2H2(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(137),[G2H2(320),G2H2(139),G2H2(437),G2H2(345),G2H2(87) &
    ,G2H2(232),G2H2(47)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(536),ex1(:),G2tensor(895),m3h2x1(:,1129),heltab2x2(:,:,1129))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(454),ex1(:),G2tensor(115),m3h2x1(:,1130),heltab2x2(:,:,1130))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(535),ex2(:),G2tensor(106),m3h2x1(:,1131),heltab2x2(:,:,1131))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(296),ex2(:),G2tensor(98),m3h2x1(:,1132),heltab2x2(:,:,1132))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex2(:),G2tensor(2),m3h2x1(:,1133),heltab2x2(:,:,1133))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(278),ex2(:),G2tensor(865),m3h2x1(:,1134),heltab2x2(:,:,1134))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(343),ex2(:),G2tensor(123),m3h2x1(:,1135),heltab2x2(:,:,1135))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(511),ex2(:),G2tensor(108),m3h2x1(:,1136),heltab2x2(:,:,1136))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(95),wf4(:,3),G2tensor(90),m3h4x1(:,129),heltab2x4(:,:,715))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(210),wf4(:,3),G2tensor(6),m3h4x1(:,130),heltab2x4(:,:,716))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(101),wf4(:,9),G2tensor(1605),m3h4x1(:,131),heltab2x4(:,:,717))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(70),wf4(:,9),G2tensor(1593),m3h4x1(:,132),heltab2x4(:,:,718))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(34),wf6(:,4),G2tensor(899),m3h6x1(:,158),heltab2x6(:,:,725))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(72),wf6(:,4),G2tensor(893),m3h6x1(:,159),heltab2x6(:,:,726))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(45),wf6(:,2),G2tensor(863),m3h6x1(:,160),heltab2x6(:,:,727))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(22),wf6(:,2),G2tensor(703),m3h6x1(:,161),heltab2x6(:,:,728))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(83),wf4(:,11),G2tensor(330),m3h4x1(:,133),heltab2x4(:,:,719))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(6),wf4(:,11),G2tensor(322),m3h4x1(:,134),heltab2x4(:,:,720))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(217),wf4(:,5),G2tensor(100),m3h4x1(:,135),heltab2x4(:,:,721))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(84),wf4(:,5),G2tensor(92),m3h4x1(:,136),heltab2x4(:,:,722))
  call Hloop_QW_A(ntryL,G1H3(12),ex4(:),G1H1(1),m3h3x1(:,428),heltab2x3(:,:,428))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(1659))
  call Hloop_QW_A(ntryL,G1H3(18),ex4(:),G1H1(1),m3h3x1(:,429),heltab2x3(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(110),n2h1(1660))
  call Hloop_QV_A(ntryL,G1H2(142),ex5(:),G1H1(1),m3h2x1(:,1137),heltab2x2(:,:,1137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(1661))
  call Hloop_QV_A(ntryL,G1H2(170),ex5(:),G1H1(1),m3h2x1(:,1138),heltab2x2(:,:,1138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(1662))
  call Hloop_QV_A(ntryL,G1H2(182),ex3(:),G1H1(1),m3h2x1(:,1139),heltab2x2(:,:,1139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(1663))
  call Hloop_QV_A(ntryL,G1H2(192),ex3(:),G1H1(1),m3h2x1(:,1140),heltab2x2(:,:,1140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(1664))
  call Hloop_AV_Q(ntryL,G1H2(429),ex3(:),G1H1(1),m3h2x1(:,1141),heltab2x2(:,:,1141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(374),n2h1(1665))
  call Hloop_AW_Q(ntryL,G1H3(46),ex4(:),G1H1(1),m3h3x1(:,430),heltab2x3(:,:,430))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(1666))
  call Hloop_QV_A(ntryL,G2H2(441),ex5(:),G2H1(1),m3h2x1(:,1142),heltab2x2(:,:,1142))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(25),n2h1(1667))
  call Hloop_QV_A(ntryL,G1H2(434),ex3(:),G1H1(1),m3h2x1(:,1143),heltab2x2(:,:,1143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(118),n2h1(1668))
  call Hloop_QW_A(ntryL,G1H3(77),ex4(:),G1H1(1),m3h3x1(:,431),heltab2x3(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(1669))
  call Hloop_AV_Q(ntryL,G2H2(432),ex5(:),G2H1(1),m3h2x1(:,1144),heltab2x2(:,:,1144))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(26),n2h1(1670))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(415),ex1(:),G2tensor(122),m3h2x1(:,1145),heltab2x2(:,:,1145))
  call Hloop_AV_Q(ntryL,G1H2(347),ex3(:),G1H1(1),m3h2x1(:,1146),heltab2x2(:,:,1146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(1671))
  call Hloop_QW_A(ntryL,G1H3(17),ex4(:),G1H1(1),m3h3x1(:,432),heltab2x3(:,:,432))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(1672))
  call Hloop_AW_Q(ntryL,G1H3(59),ex4(:),G1H1(1),m3h3x1(:,433),heltab2x3(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(1673))
  call Hloop_QV_A(ntryL,G1H2(351),ex3(:),G1H1(1),m3h2x1(:,1147),heltab2x2(:,:,1147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(834),n2h1(1674))
  call Hloop_AV_Q(ntryL,G1H2(298),ex5(:),G1H1(1),m3h2x1(:,1148),heltab2x2(:,:,1148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(557),n2h1(1675))
  call Hloop_AW_Q(ntryL,G1H3(76),ex4(:),G1H1(1),m3h3x1(:,434),heltab2x3(:,:,434))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(1676))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(202),wf4(:,3),G2tensor(368),m3h4x1(:,137),heltab2x4(:,:,723))
  call Hloop_AW_Q(ntryL,G1H3(2),ex4(:),G1H1(1),m3h3x1(:,435),heltab2x3(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(1677))
  call Hloop_QV_A(ntryL,G1H2(303),ex5(:),G1H1(1),m3h2x1(:,1149),heltab2x2(:,:,1149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(371),n2h1(1678))
  call Hloop_QW_A(ntryL,G1H3(91),ex4(:),G1H1(1),m3h3x1(:,436),heltab2x3(:,:,436))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(1679))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(45),wf4(:,9),G2tensor(65),m3h4x1(:,138),heltab2x4(:,:,724))
  call Hloop_QW_A(ntryL,G1H3(10),ex4(:),G1H1(1),m3h3x1(:,437),heltab2x3(:,:,437))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(1680))
  call Hloop_AV_Q(ntryL,G1H2(307),ex5(:),G1H1(1),m3h2x1(:,1150),heltab2x2(:,:,1150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(383),n2h1(1681))
  call Hloop_AV_Q(ntryL,G1H2(606),ex3(:),G1H1(1),m3h2x1(:,1151),heltab2x2(:,:,1151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(1682))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(103),wf6(:,4),G2tensor(386),m3h6x1(:,162),heltab2x6(:,:,729))
  call Hloop_AV_Q(ntryL,G1H2(313),ex3(:),G1H1(1),m3h2x1(:,1152),heltab2x2(:,:,1152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(76),n2h1(1683))
  call Hloop_QV_A(ntryL,G1H2(314),ex5(:),G1H1(1),m3h2x1(:,1153),heltab2x2(:,:,1153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(1684))
  call Hloop_QV_A(ntryL,G1H2(975),ex3(:),G1H1(1),m3h2x1(:,1154),heltab2x2(:,:,1154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(80),n2h1(1685))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(106),wf6(:,2),G2tensor(82),m3h6x1(:,163),heltab2x6(:,:,730))
  call Hloop_QV_A(ntryL,G1H2(319),ex3(:),G1H1(1),m3h2x1(:,1155),heltab2x2(:,:,1155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(1686))
  call Hloop_QW_A(ntryL,G1H6(370),wf6(:,6),G1H1(1),m3h6x1(:,164),heltab2x6(:,:,731))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(861),n2h1(1687))
  call Hloop_AW_Q(ntryL,G1H6(388),wf6(:,6),G1H1(1),m3h6x1(:,165),heltab2x6(:,:,732))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(1688))
  call Hloop_QW_A(ntryL,G1H6(177),wf6(:,6),G1H1(1),m3h6x1(:,166),heltab2x6(:,:,733))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(104),n2h1(1689))
  call Hloop_QV_A(ntryL,G2H2(467),ex3(:),G2H1(1),m3h2x1(:,1156),heltab2x2(:,:,1156))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(27),n2h1(1690))
  call Hloop_QV_A(ntryL,G2H2(134),ex5(:),G2H1(1),m3h2x1(:,1157),heltab2x2(:,:,1157))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(28),n2h1(1691))
  call Hloop_AV_Q(ntryL,G2H2(479),ex3(:),G2H1(1),m3h2x1(:,1158),heltab2x2(:,:,1158))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(29),n2h1(1692))
  call Hloop_AV_Q(ntryL,G2H2(24),ex5(:),G2H1(1),m3h2x1(:,1159),heltab2x2(:,:,1159))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(30),n2h1(1693))
  call Hloop_QW_A(ntryL,G1H3(45),ex4(:),G1H1(1),m3h3x1(:,438),heltab2x3(:,:,438))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(86),n2h1(1694))
  call Hloop_QV_A(ntryL,G1H2(407),ex5(:),G1H1(1),m3h2x1(:,1160),heltab2x2(:,:,1160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1599),n2h1(1695))
  call Hloop_QV_A(ntryL,G1H2(423),ex3(:),G1H1(1),m3h2x1(:,1161),heltab2x2(:,:,1161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1587),n2h1(1696))
  call Hloop_AV_Q(ntryL,G1H2(406),ex5(:),G1H1(1),m3h2x1(:,1162),heltab2x2(:,:,1162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(897),n2h1(1697))
  call Hloop_AW_Q(ntryL,G1H3(34),ex4(:),G1H1(1),m3h3x1(:,439),heltab2x3(:,:,439))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(883),n2h1(1698))
  call Hloop_AV_Q(ntryL,G1H2(412),ex3(:),G1H1(1),m3h2x1(:,1163),heltab2x2(:,:,1163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(859),n2h1(1699))
  call Hloop_QW_A(ntryL,G1H6(387),wf6(:,6),G1H1(1),m3h6x1(:,167),heltab2x6(:,:,734))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(707),n2h1(1700))
  call Hloop_AV_Q(ntryL,G1H2(870),ex5(:),G1H1(1),m3h2x1(:,1164),heltab2x2(:,:,1164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(314),n2h1(1701))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(73),wf12(:,5),G2tensor(302),m3h12x1(:,111),heltab2x12(:,:,797))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(17),wf8(:,2),G2tensor(96),m3h8x1(:,21),heltab2x8(:,:,307))
  call Hloop_QV_A(ntryL,G1H2(605),ex5(:),G1H1(1),m3h2x1(:,1165),heltab2x2(:,:,1165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(88),n2h1(1702))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(47),wf12(:,16),G2tensor(885),m3h12x1(:,112),heltab2x12(:,:,798))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(40),wf8(:,10),G2tensor(119),m3h8x1(:,22),heltab2x8(:,:,308))
  call Hloop_AV_Q(ntryL,G2H12(53),wf12(:,27),G2H1(1),m3h12x1(:,113),heltab2x12(:,:,799))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(31),n2h1(1703))
  call Hloop_AV_Q(ntryL,G2H2(438),ex5(:),G2H1(1),m3h2x1(:,1166),heltab2x2(:,:,1166))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(32),n2h1(1704))
  call Hloop_AV_Q(ntryL,G2H12(57),wf12(:,27),G2H1(1),m3h12x1(:,114),heltab2x12(:,:,800))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(33),n2h1(1705))
  call Hloop_QV_A(ntryL,G2H12(1),wf12(:,27),G2H1(1),m3h12x1(:,115),heltab2x12(:,:,801))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(34),n2h1(1706))
  call Hloop_QV_A(ntryL,G2H2(445),ex5(:),G2H1(1),m3h2x1(:,1167),heltab2x2(:,:,1167))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(35),n2h1(1707))
  call Hloop_QV_A(ntryL,G2H12(4),wf12(:,27),G2H1(1),m3h12x1(:,116),heltab2x12(:,:,802))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(36),n2h1(1708))
  call Hloop_AV_Q(ntryL,G2H2(450),ex5(:),G2H1(1),m3h2x1(:,1168),heltab2x2(:,:,1168))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(37),n2h1(1709))
  call Hloop_AV_Q(ntryL,G2H12(30),wf12(:,27),G2H1(1),m3h12x1(:,117),heltab2x12(:,:,803))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(38),n2h1(1710))
  call Hloop_QV_A(ntryL,G2H2(453),ex5(:),G2H1(1),m3h2x1(:,1169),heltab2x2(:,:,1169))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(39),n2h1(1711))
  call Hloop_QV_A(ntryL,G2H12(35),wf12(:,27),G2H1(1),m3h12x1(:,118),heltab2x12(:,:,804))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(40),n2h1(1712))
call HGT_OLR(G2H2(233),1,1,2)
call HGT_invQ_OLR(G2H2(233),2,5,2)
call HGT_OLR(G2H2(233),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(233),ex3(:),G2H1(1),m3h2x1(:,1170),heltab2x2(:,:,1170))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(41),n2h1(1713))
  call Hloop_AV_Q(ntryL,G2H2(449),ex5(:),G2H1(1),m3h2x1(:,1171),heltab2x2(:,:,1171))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(42),n2h1(1714))
call HGT_OLR(G2H2(255),1,1,2)
call HGT_invQ_OLR(G2H2(255),2,5,2)
call HGT_OLR(G2H2(255),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(255),ex3(:),G2H1(1),m3h2x1(:,1172),heltab2x2(:,:,1172))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(43),n2h1(1715))
  call Hloop_QV_A(ntryL,G2H2(294),ex5(:),G2H1(1),m3h2x1(:,1173),heltab2x2(:,:,1173))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(44),n2h1(1716))
call HGT_OLR(G2H2(285),1,1,2)
call HGT_invQ_OLR(G2H2(285),2,5,2)
call HGT_OLR(G2H2(285),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(285),ex3(:),G2H1(1),m3h2x1(:,1174),heltab2x2(:,:,1174))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(45),n2h1(1717))
  call Hloop_AV_Q(ntryL,G2H2(136),ex5(:),G2H1(1),m3h2x1(:,1175),heltab2x2(:,:,1175))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(46),n2h1(1718))
call HGT_OLR(G2H2(317),1,1,2)
call HGT_invQ_OLR(G2H2(317),2,5,2)
call HGT_OLR(G2H2(317),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(317),ex3(:),G2H1(1),m3h2x1(:,1176),heltab2x2(:,:,1176))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(47),n2h1(1719))
  call Hloop_QV_A(ntryL,G2H2(27),ex5(:),G2H1(1),m3h2x1(:,1177),heltab2x2(:,:,1177))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(48),n2h1(1720))
  call Hloop_QV_A(ntryL,G2H12(42),wf12(:,27),G2H1(1),m3h12x1(:,119),heltab2x12(:,:,805))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(49),n2h1(1721))
  call Hloop_QV_A(ntryL,G2H12(40),wf12(:,27),G2H1(1),m3h12x1(:,120),heltab2x12(:,:,806))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(50),n2h1(1722))
  call Hloop_AV_Q(ntryL,G2H12(29),wf12(:,27),G2H1(1),m3h12x1(:,121),heltab2x12(:,:,807))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(51),n2h1(1723))
  call Hloop_AV_Q(ntryL,G2H12(44),wf12(:,27),G2H1(1),m3h12x1(:,122),heltab2x12(:,:,808))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(52),n2h1(1724))
  call Hloop_QV_A(ntryL,G2H12(68),wf12(:,27),G2H1(1),m3h12x1(:,123),heltab2x12(:,:,809))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(53),n2h1(1725))
  call Hloop_AV_Q(ntryL,G2H12(72),wf12(:,27),G2H1(1),m3h12x1(:,124),heltab2x12(:,:,810))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(54),n2h1(1726))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(11),wf12(:,20),G2tensor(102),m3h12x1(:,125),heltab2x12(:,:,811))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(58),wf12(:,11),G2tensor(94),m3h12x1(:,126),heltab2x12(:,:,812))
  call Hloop_AV_Q(ntryL,G2H12(28),wf12(:,28),G2H1(1),m3h12x1(:,127),heltab2x12(:,:,813))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(55),n2h1(1727))
  call Hloop_AV_Q(ntryL,G2H12(27),wf12(:,28),G2H1(1),m3h12x1(:,128),heltab2x12(:,:,814))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(56),n2h1(1728))
  call Hloop_QV_A(ntryL,G2H12(45),wf12(:,28),G2H1(1),m3h12x1(:,129),heltab2x12(:,:,815))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(57),n2h1(1729))
  call Hloop_QV_A(ntryL,G2H12(66),wf12(:,28),G2H1(1),m3h12x1(:,130),heltab2x12(:,:,816))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(58),n2h1(1730))
  call Hloop_AV_Q(ntryL,G2H12(10),wf12(:,28),G2H1(1),m3h12x1(:,131),heltab2x12(:,:,817))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(59),n2h1(1731))
  call Hloop_QV_A(ntryL,G2H12(17),wf12(:,28),G2H1(1),m3h12x1(:,132),heltab2x12(:,:,818))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(60),n2h1(1732))
  call Hloop_QV_A(ntryL,G2H12(22),wf12(:,28),G2H1(1),m3h12x1(:,133),heltab2x12(:,:,819))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(61),n2h1(1733))
  call Hloop_QV_A(ntryL,G2H12(39),wf12(:,28),G2H1(1),m3h12x1(:,134),heltab2x12(:,:,820))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(62),n2h1(1734))
  call Hloop_AV_Q(ntryL,G2H12(23),wf12(:,28),G2H1(1),m3h12x1(:,135),heltab2x12(:,:,821))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(63),n2h1(1735))
  call Hloop_AV_Q(ntryL,G2H12(25),wf12(:,28),G2H1(1),m3h12x1(:,136),heltab2x12(:,:,822))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(64),n2h1(1736))
  call Hloop_QV_A(ntryL,G2H12(15),wf12(:,28),G2H1(1),m3h12x1(:,137),heltab2x12(:,:,823))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(65),n2h1(1737))
  call Hloop_AV_Q(ntryL,G2H12(18),wf12(:,28),G2H1(1),m3h12x1(:,138),heltab2x12(:,:,824))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(66),n2h1(1738))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(38),wf12(:,22),G2tensor(612),m3h12x1(:,139),heltab2x12(:,:,825))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(16),wf12(:,3),G2tensor(358),m3h12x1(:,140),heltab2x12(:,:,826))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(78),wf12(:,26),G2tensor(126),m3h12x1(:,141),heltab2x12(:,:,827))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(81),wf12(:,24),G2tensor(151),m3h12x1(:,142),heltab2x12(:,:,828))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(27),wf8(:,20),G2tensor(129),m3h8x1(:,23),heltab2x8(:,:,309))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(41),wf12(:,14),G2tensor(127),m3h12x1(:,143),heltab2x12(:,:,829))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(6),wf8(:,16),G2tensor(605),m3h8x1(:,24),heltab2x8(:,:,310))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(36),wf12(:,7),G2tensor(154),m3h12x1(:,144),heltab2x12(:,:,830))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(644),47,ex5(:),16,G2tensor(130),m3h2x1(:,1178),heltab2x2(:,:,1178))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(460),47,ex5(:),16,G3tensor(67),m3h2x1(:,1179),heltab2x2(:,:,1179))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(632),47,ex5(:),16,G2tensor(616),m3h2x1(:,1180),heltab2x2(:,:,1180))
  call Hloop_AV_Q(ntryL,G1H2(220),ex5(:),G1H1(1),m3h2x1(:,1181),heltab2x2(:,:,1181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(376),n2h1(1739))
  call Hloop_AV_Q(ntryL,G1H2(633),ex5(:),G1H1(1),m3h2x1(:,1182),heltab2x2(:,:,1182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(134),n2h1(1740))
  call Hloop_AV_Q(ntryL,G2H2(71),ex5(:),G2H1(1),m3h2x1(:,1183),heltab2x2(:,:,1183))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(68),n2h1(1741))
  call Hloop_QW_A(ntryL,G1H3(365),ex4(:),G1H1(1),m3h3x1(:,440),heltab2x3(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(1742))
  call Hloop_QW_A(ntryL,G1H3(327),ex4(:),G1H1(1),m3h3x1(:,441),heltab2x3(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(137),n2h1(1743))
  call Hloop_QW_A(ntryL,G1H3(149),ex4(:),G1H1(1),m3h3x1(:,442),heltab2x3(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(1744))
  call Hloop_QV_A(ntryL,G1H2(129),ex5(:),G1H1(1),m3h2x1(:,1184),heltab2x2(:,:,1184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(609),n2h1(1745))
  call Hloop_QV_A(ntryL,G1H2(609),ex5(:),G1H1(1),m3h2x1(:,1185),heltab2x2(:,:,1185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(1746))
  call Hloop_QV_A(ntryL,G2H2(562),ex5(:),G2H1(1),m3h2x1(:,1186),heltab2x2(:,:,1186))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(69),n2h1(1747))
  call Hloop_AW_Q(ntryL,G1H3(513),ex4(:),G1H1(1),m3h3x1(:,443),heltab2x3(:,:,443))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(1748))
  call Hloop_AW_Q(ntryL,G1H3(387),ex4(:),G1H1(1),m3h3x1(:,444),heltab2x3(:,:,444))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(596),n2h1(1749))
  call Hloop_AW_Q(ntryL,G1H3(366),ex4(:),G1H1(1),m3h3x1(:,445),heltab2x3(:,:,445))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(1750))
  call Hloop_QV_A(ntryL,G1H2(386),ex3(:),G1H1(1),m3h2x1(:,1187),heltab2x2(:,:,1187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(167),n2h1(1751))
  call Hloop_AV_Q(ntryL,G1H2(464),ex5(:),G1H1(1),m3h2x1(:,1188),heltab2x2(:,:,1188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(1752))
  call Hloop_AV_Q(ntryL,G1H2(638),ex5(:),G1H1(1),m3h2x1(:,1189),heltab2x2(:,:,1189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(1753))
  call Hloop_AW_Q(ntryL,G1H3(106),ex4(:),G1H1(1),m3h3x1(:,446),heltab2x3(:,:,446))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1671),n2h1(1754))
  call Hloop_AW_Q(ntryL,G1H3(258),ex4(:),G1H1(1),m3h3x1(:,447),heltab2x3(:,:,447))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1635),n2h1(1755))
  call Hloop_AV_Q(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,1190),heltab2x2(:,:,1190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1629),n2h1(1756))
  call Hloop_AV_Q(ntryL,G1H2(1022),ex3(:),G1H1(1),m3h2x1(:,1191),heltab2x2(:,:,1191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(601),n2h1(1757))
  call Hloop_AV_Q(ntryL,G1H2(115),ex3(:),G1H1(1),m3h2x1(:,1192),heltab2x2(:,:,1192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(597),n2h1(1758))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(305),47,ex5(:),16,G2tensor(170),m3h2x1(:,1193),heltab2x2(:,:,1193))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(283),47,ex5(:),16,G2tensor(146),m3h2x1(:,1194),heltab2x2(:,:,1194))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(421),47,ex5(:),16,G2tensor(604),m3h2x1(:,1195),heltab2x2(:,:,1195))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(383),47,ex5(:),16,G2tensor(382),m3h2x1(:,1196),heltab2x2(:,:,1196))
  call Hloop_VA_Q(ntryL,G1H2(54),ex2(:),G1H1(1),m3h2x1(:,1197),heltab2x2(:,:,1197))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(1759))
  call Hloop_VA_Q(ntryL,G1H2(456),ex2(:),G1H1(1),m3h2x1(:,1198),heltab2x2(:,:,1198))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(608),n2h1(1760))
  call Hloop_VA_Q(ntryL,G1H2(5),ex2(:),G1H1(1),m3h2x1(:,1199),heltab2x2(:,:,1199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(367),n2h1(1761))
  call Hloop_VQ_A(ntryL,G1H2(473),ex1(:),G1H1(1),m3h2x1(:,1200),heltab2x2(:,:,1200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(158),n2h1(1762))
  call Hloop_VQ_A(ntryL,G1H2(777),ex1(:),G1H1(1),m3h2x1(:,1201),heltab2x2(:,:,1201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(600),n2h1(1763))
  call Hloop_VQ_A(ntryL,G1H2(58),ex1(:),G1H1(1),m3h2x1(:,1202),heltab2x2(:,:,1202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(166),n2h1(1764))
  call Hloop_VQ_A(ntryL,G1H2(511),ex1(:),G1H1(1),m3h2x1(:,1203),heltab2x2(:,:,1203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(415),n2h1(1765))
  call Hloop_VQ_A(ntryL,G1H2(802),ex1(:),G1H1(1),m3h2x1(:,1204),heltab2x2(:,:,1204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(174),n2h1(1766))
  call Hloop_VA_Q(ntryL,G1H2(526),ex2(:),G1H1(1),m3h2x1(:,1205),heltab2x2(:,:,1205))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(1767))
  call Hloop_VA_Q(ntryL,G1H2(294),ex2(:),G1H1(1),m3h2x1(:,1206),heltab2x2(:,:,1206))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(1768))
  call Hloop_VQ_A(ntryL,G1H6(478),wf6(:,4),G1H1(1),m3h6x1(:,168),heltab2x6(:,:,735))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1590),n2h1(1769))
  call Hloop_VQ_A(ntryL,G1H6(482),wf6(:,4),G1H1(1),m3h6x1(:,169),heltab2x6(:,:,736))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(178),n2h1(1770))
  call Hloop_VA_Q(ntryL,G1H6(5),wf6(:,2),G1H1(1),m3h6x1(:,170),heltab2x6(:,:,737))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(190),n2h1(1771))
  call Hloop_VA_Q(ntryL,G1H6(463),wf6(:,2),G1H1(1),m3h6x1(:,171),heltab2x6(:,:,738))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(182),n2h1(1772))
  call Hloop_VQ_A(ntryL,G1H4(207),wf4(:,11),G1H1(1),m3h4x1(:,139),heltab2x4(:,:,725))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(185),n2h1(1773))
  call Hloop_VQ_A(ntryL,G1H4(42),wf4(:,11),G1H1(1),m3h4x1(:,140),heltab2x4(:,:,726))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(183),n2h1(1774))
  call Hloop_VQ_A(ntryL,G1H4(147),wf4(:,11),G1H1(1),m3h4x1(:,141),heltab2x4(:,:,727))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1608),n2h1(1775))
  call Hloop_VA_Q(ntryL,G1H4(199),wf4(:,5),G1H1(1),m3h4x1(:,142),heltab2x4(:,:,728))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(691),n2h1(1776))
  call Hloop_VA_Q(ntryL,G1H4(47),wf4(:,5),G1H1(1),m3h4x1(:,143),heltab2x4(:,:,729))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(194),n2h1(1777))
  call Hloop_VA_Q(ntryL,G1H4(252),wf4(:,5),G1H1(1),m3h4x1(:,144),heltab2x4(:,:,730))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(186),n2h1(1778))
  call Hloop_VQ_A(ntryL,G1H2(506),ex1(:),G1H1(1),m3h2x1(:,1207),heltab2x2(:,:,1207))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(295),n2h1(1779))
  call Hloop_QV_A(ntryL,G1H2(102),ex3(:),G1H1(1),m3h2x1(:,1208),heltab2x2(:,:,1208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(193),n2h1(1780))
  call Hloop_VA_Q(ntryL,G1H2(541),ex2(:),G1H1(1),m3h2x1(:,1209),heltab2x2(:,:,1209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(191),n2h1(1781))
  call Hloop_AW_Q(ntryL,G1H3(184),ex4(:),G1H1(1),m3h3x1(:,448),heltab2x3(:,:,448))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(206),n2h1(1782))
  call Hloop_QW_A(ntryL,G1H3(41),ex4(:),G1H1(1),m3h3x1(:,449),heltab2x3(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(198),n2h1(1783))
  call Hloop_AV_Q(ntryL,G1H2(187),ex3(:),G1H1(1),m3h2x1(:,1210),heltab2x2(:,:,1210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(231),n2h1(1784))
  call Hloop_QV_A(ntryL,G1H2(476),ex3(:),G1H1(1),m3h2x1(:,1211),heltab2x2(:,:,1211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(201),n2h1(1785))
  call Hloop_AV_Q(ntryL,G1H2(795),ex3(:),G1H1(1),m3h2x1(:,1212),heltab2x2(:,:,1212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(199),n2h1(1786))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(590),47,ex5(:),16,G2tensor(238),m3h2x1(:,1213),heltab2x2(:,:,1213))
  call Hloop_VQ_A(ntryL,G1H2(375),ex1(:),G1H1(1),m3h2x1(:,1214),heltab2x2(:,:,1214))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(210),n2h1(1787))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(382),47,ex5(:),16,G2tensor(202),m3h2x1(:,1215),heltab2x2(:,:,1215))
  call Hloop_VA_Q(ntryL,G1H2(693),ex2(:),G1H1(1),m3h2x1(:,1216),heltab2x2(:,:,1216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(209),n2h1(1788))
  call Hloop_VQ_A(ntryL,G1H4(154),wf4(:,3),G1H1(1),m3h4x1(:,145),heltab2x4(:,:,731))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(207),n2h1(1789))
  call Hloop_VQ_A(ntryL,G1H4(81),wf4(:,3),G1H1(1),m3h4x1(:,146),heltab2x4(:,:,732))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(394),n2h1(1790))
  call Hloop_VQ_A(ntryL,G1H4(21),wf4(:,3),G1H1(1),m3h4x1(:,147),heltab2x4(:,:,733))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(214),n2h1(1791))
  call Hloop_VQ_A(ntryL,G1H4(45),wf4(:,3),G1H1(1),m3h4x1(:,148),heltab2x4(:,:,734))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(217),n2h1(1792))
  call Hloop_VA_Q(ntryL,G1H4(118),wf4(:,9),G1H1(1),m3h4x1(:,149),heltab2x4(:,:,735))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(215),n2h1(1793))
  call Hloop_VA_Q(ntryL,G1H4(135),wf4(:,9),G1H1(1),m3h4x1(:,150),heltab2x4(:,:,736))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1596),n2h1(1794))
  call Hloop_VA_Q(ntryL,G1H4(186),wf4(:,9),G1H1(1),m3h4x1(:,151),heltab2x4(:,:,737))



end subroutine vamp_10

end module ol_vamp_10_ppwajj_udxawgg_1_/**/REALKIND
