
! **********************************************************************
module ol_tables_storage_ppwajj_uuxcsxaw_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(96,267)
integer(intkind2), save :: heltab2x2(2,2,313)
integer(intkind2), save :: heltab2x4(2,4,173)
integer(intkind2), save :: heltab2x8(2,8,132)
integer(intkind2), save :: heltab2x16(2,16,91)
integer(intkind2), save :: heltab2x32(2,32,48)
integer(intkind2), save :: heltab2x96(2,96,267)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(267)
integer(intkind2), save :: m3h2x1(3,313)
integer(intkind2), save :: m3h4x1(3,67)
integer(intkind2), save :: m3h8x1(3,38)
integer(intkind2), save :: m3h16x1(3,16)
integer(intkind2), save :: m3h2x2(3,106)
integer(intkind2), save :: m3h4x2(3,29)
integer(intkind2), save :: m3h8x2(3,7)
integer(intkind2), save :: m3h2x4(3,65)
integer(intkind2), save :: m3h4x4(3,16)
integer(intkind2), save :: m3h8x4(3,4)
integer(intkind2), save :: m3h24x4(3,80)
integer(intkind2), save :: m3h2x8(3,52)
integer(intkind2), save :: m3h4x8(3,8)
integer(intkind2), save :: m3h12x8(3,84)
integer(intkind2), save :: m3h2x16(3,36)
integer(intkind2), save :: m3h6x16(3,55)
integer(intkind2), save :: m3h3x32(3,48)

integer(intkind2), save :: n2h1(385)
integer(intkind2), save :: n2h2(84)
integer(intkind2), save :: n2h4(102)
integer(intkind2), save :: n2h8(105)
integer(intkind2), save :: n2h16(21)
integer(intkind2), save :: n2h32(48)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h24x4(1,:)=24
m3h24x4(2,:)=4
m3h24x4(3,:)=96
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h12x8(1,:)=12
m3h12x8(2,:)=8
m3h12x8(3,:)=96
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h6x16(1,:)=6
m3h6x16(2,:)=16
m3h6x16(3,:)=96
m3h3x32(1,:)=3
m3h3x32(2,:)=32
m3h3x32(3,:)=96

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppwajj_uuxcsxaw_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppwajj_uuxcsxaw_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G2H1(1)
  type(hol), save :: G0H2(1)
  type(hol), save :: G1H2(246)
  type(hol), save :: G2H2(64)
  type(hol), save :: G0H4(9)
  type(hol), save :: G1H4(54)
  type(hol), save :: G2H4(28)
  type(hol), save :: G0H8(12)
  type(hol), save :: G1H8(38)
  type(hol), save :: G2H8(9)
  type(hol), save :: G0H16(12)
  type(hol), save :: G1H16(14)
  type(hol), save :: G0H32(1)
  type(hol), save :: G1H32(16)
  type(hol), save :: G0H96(1)
  type(hcl), save, dimension(560) :: G0tensor
  type(hcl), save, dimension(560) :: G1tensor
  type(hcl), save, dimension(278) :: G2tensor
  type(hcl), save, dimension(6) :: G3tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(159)
type (redset4),    save :: RedSet_4(146)
type (redset5),    save :: RedSet_5(42)
integer, save :: mass2set(0:1,3)
integer, save :: mass3set(0:2,3)
integer, save :: mass4set(0:3,1)
integer, save :: mass5set(0:4,1)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(2)
  integer, save :: momenta_24(2)
  integer, save :: momenta_25(2)
  integer, save :: momenta_26(2)
  integer, save :: momenta_27(2)
  integer, save :: momenta_28(2)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(3)
  integer, save :: momenta_81(3)
  integer, save :: momenta_82(3)
  integer, save :: momenta_83(3)
  integer, save :: momenta_84(3)
  integer, save :: momenta_85(3)
  integer, save :: momenta_86(3)
  integer, save :: momenta_87(3)
  integer, save :: momenta_88(3)
  integer, save :: momenta_89(3)
  integer, save :: momenta_90(3)
  integer, save :: momenta_91(3)
  integer, save :: momenta_92(3)
  integer, save :: momenta_93(3)
  integer, save :: momenta_94(3)
  integer, save :: momenta_95(3)
  integer, save :: momenta_96(3)
  integer, save :: momenta_97(3)
  integer, save :: momenta_98(3)
  integer, save :: momenta_99(3)
  integer, save :: momenta_100(3)
  integer, save :: momenta_101(3)
  integer, save :: momenta_102(3)
  integer, save :: momenta_103(3)
  integer, save :: momenta_104(3)
  integer, save :: momenta_105(3)
  integer, save :: momenta_106(3)
  integer, save :: momenta_107(3)
  integer, save :: momenta_108(3)
  integer, save :: momenta_109(3)
  integer, save :: momenta_110(3)
  integer, save :: momenta_111(3)
  integer, save :: momenta_112(3)
  integer, save :: momenta_113(3)
  integer, save :: momenta_114(3)
  integer, save :: momenta_115(3)
  integer, save :: momenta_116(3)
  integer, save :: momenta_117(3)
  integer, save :: momenta_118(3)
  integer, save :: momenta_119(3)
  integer, save :: momenta_120(3)
  integer, save :: momenta_121(3)
  integer, save :: momenta_122(3)
  integer, save :: momenta_123(3)
  integer, save :: momenta_124(3)
  integer, save :: momenta_125(3)
  integer, save :: momenta_126(3)
  integer, save :: momenta_127(3)
  integer, save :: momenta_128(3)
  integer, save :: momenta_129(3)
  integer, save :: momenta_130(3)
  integer, save :: momenta_131(3)
  integer, save :: momenta_132(3)
  integer, save :: momenta_133(3)
  integer, save :: momenta_134(3)
  integer, save :: momenta_135(3)
  integer, save :: momenta_136(3)
  integer, save :: momenta_137(3)
  integer, save :: momenta_138(4)
  integer, save :: momenta_139(4)
  integer, save :: momenta_140(4)
  integer, save :: momenta_141(4)
  integer, save :: momenta_142(4)
  integer, save :: momenta_143(4)
  integer, save :: momenta_144(4)
  integer, save :: momenta_145(4)
  integer, save :: momenta_146(4)
  integer, save :: momenta_147(4)
  integer, save :: momenta_148(4)
  integer, save :: momenta_149(4)
  integer, save :: momenta_150(4)
  integer, save :: momenta_151(4)
  integer, save :: momenta_152(4)
  integer, save :: momenta_153(4)
  integer, save :: momenta_154(4)
  integer, save :: momenta_155(4)
  integer, save :: momenta_156(4)
  integer, save :: momenta_157(4)
  integer, save :: momenta_158(4)
  integer, save :: momenta_159(4)
  integer, save :: momenta_160(4)
  integer, save :: momenta_161(4)
  integer, save :: momenta_162(4)
  integer, save :: momenta_163(4)
  integer, save :: momenta_164(4)
  integer, save :: momenta_165(4)
  integer, save :: momenta_166(4)
  integer, save :: momenta_167(4)
  integer, save :: momenta_168(4)
  integer, save :: momenta_169(4)
  integer, save :: momenta_170(4)
  integer, save :: momenta_171(4)
  integer, save :: momenta_172(4)
  integer, save :: momenta_173(4)
  integer, save :: momenta_174(4)
  integer, save :: momenta_175(4)
  integer, save :: momenta_176(4)
  integer, save :: momenta_177(4)
  integer, save :: momenta_178(4)
  integer, save :: momenta_179(4)
  integer, save :: momenta_180(4)
  integer, save :: momenta_181(4)
  integer, save :: momenta_182(4)
  integer, save :: momenta_183(4)
  integer, save :: momenta_184(4)
  integer, save :: momenta_185(4)
  integer, save :: momenta_186(4)
  integer, save :: momenta_187(4)
  integer, save :: momenta_188(4)
  integer, save :: momenta_189(4)
  integer, save :: momenta_190(4)
  integer, save :: momenta_191(4)
  integer, save :: momenta_192(4)
  integer, save :: momenta_193(4)
  integer, save :: momenta_194(4)
  integer, save :: momenta_195(4)
  integer, save :: momenta_196(4)
  integer, save :: momenta_197(4)
  integer, save :: momenta_198(4)
  integer, save :: momenta_199(4)
  integer, save :: momenta_200(4)
  integer, save :: momenta_201(4)
  integer, save :: momenta_202(4)
  integer, save :: momenta_203(4)
  integer, save :: momenta_204(4)
  integer, save :: momenta_205(4)
  integer, save :: momenta_206(4)
  integer, save :: momenta_207(4)
  integer, save :: momenta_208(4)
  integer, save :: momenta_209(4)
  integer, save :: momenta_210(4)
  integer, save :: momenta_211(4)
  integer, save :: momenta_212(4)
  integer, save :: momenta_213(4)
  integer, save :: momenta_214(4)
  integer, save :: momenta_215(4)
  integer, save :: momenta_216(4)
  integer, save :: momenta_217(4)
  integer, save :: momenta_218(4)
  integer, save :: momenta_219(4)
  integer, save :: momenta_220(4)
  integer, save :: momenta_221(4)
  integer, save :: momenta_222(4)
  integer, save :: momenta_223(4)
  integer, save :: momenta_224(4)
  integer, save :: momenta_225(4)
  integer, save :: momenta_226(4)
  integer, save :: momenta_227(4)
  integer, save :: momenta_228(4)
  integer, save :: momenta_229(4)
  integer, save :: momenta_230(4)
  integer, save :: momenta_231(4)
  integer, save :: momenta_232(4)
  integer, save :: momenta_233(4)
  integer, save :: momenta_234(4)
  integer, save :: momenta_235(4)
  integer, save :: momenta_236(4)
  integer, save :: momenta_237(4)
  integer, save :: momenta_238(4)
  integer, save :: momenta_239(4)
  integer, save :: momenta_240(4)
  integer, save :: momenta_241(4)
  integer, save :: momenta_242(4)
  integer, save :: momenta_243(4)
  integer, save :: momenta_244(4)
  integer, save :: momenta_245(4)
  integer, save :: momenta_246(4)
  integer, save :: momenta_247(4)
  integer, save :: momenta_248(4)
  integer, save :: momenta_249(4)
  integer, save :: momenta_250(5)
  integer, save :: momenta_251(5)
  integer, save :: momenta_252(5)
  integer, save :: momenta_253(5)
  integer, save :: momenta_254(5)
  integer, save :: momenta_255(5)
  integer, save :: momenta_256(5)
  integer, save :: momenta_257(5)
  integer, save :: momenta_258(5)
  integer, save :: momenta_259(5)
  integer, save :: momenta_260(5)
  integer, save :: momenta_261(5)
  integer, save :: momenta_262(5)
  integer, save :: momenta_263(5)
  integer, save :: momenta_264(5)
  integer, save :: momenta_265(5)
  integer, save :: momenta_266(5)
  integer, save :: momenta_267(5)
  integer, save :: momenta_268(5)
  integer, save :: momenta_269(5)
  integer, save :: momenta_270(5)
  integer, save :: momenta_271(5)
  integer, save :: momenta_272(5)
  integer, save :: momenta_273(5)
  integer, save :: momenta_274(5)
  integer, save :: momenta_275(5)
  integer, save :: momenta_276(5)
  integer, save :: momenta_277(5)
  integer, save :: momenta_278(5)
  integer, save :: momenta_279(5)
  integer, save :: momenta_280(5)
  integer, save :: momenta_281(5)
  integer, save :: momenta_282(5)
  integer, save :: momenta_283(5)
  integer, save :: momenta_284(5)
  integer, save :: momenta_285(5)
  integer, save :: momenta_286(5)
  integer, save :: momenta_287(5)
  integer, save :: momenta_288(5)
  integer, save :: momenta_289(5)
  integer, save :: momenta_290(6)
  integer, save :: momenta_291(6)
  integer, save :: momenta_292(6)
  integer, save :: momenta_293(6)
  integer, save :: momenta_294(6)
  integer, save :: momenta_295(6)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(3)
  integer, save :: masses2_7(3)
  integer, save :: masses2_8(3)
  integer, save :: masses2_9(4)
  integer, save :: masses2_10(5)
  integer, save :: masses2_11(6)

type(scalarbox), save :: ScalarBoxes(130)

integer, save :: sbarray_1(15)
integer, save :: sbarray_2(15)
integer, save :: sbarray_3(15)
integer, save :: sbarray_4(15)
integer, save :: sbarray_5(15)
integer, save :: sbarray_6(15)
integer, save :: sbarray_7(5)
integer, save :: sbarray_8(5)
integer, save :: sbarray_9(5)
integer, save :: sbarray_10(5)
integer, save :: sbarray_11(5)
integer, save :: sbarray_12(5)
integer, save :: sbarray_13(5)
integer, save :: sbarray_14(5)
integer, save :: sbarray_15(5)
integer, save :: sbarray_16(5)
integer, save :: sbarray_17(5)
integer, save :: sbarray_18(5)
integer, save :: sbarray_19(5)
integer, save :: sbarray_20(5)
integer, save :: sbarray_21(5)
integer, save :: sbarray_22(5)
integer, save :: sbarray_23(5)
integer, save :: sbarray_24(5)
integer, save :: sbarray_25(5)
integer, save :: sbarray_26(5)
integer, save :: sbarray_27(5)
integer, save :: sbarray_28(5)
integer, save :: sbarray_29(5)
integer, save :: sbarray_30(5)
integer, save :: sbarray_31(5)
integer, save :: sbarray_32(5)
integer, save :: sbarray_33(5)
integer, save :: sbarray_34(5)
integer, save :: sbarray_35(5)
integer, save :: sbarray_36(5)
integer, save :: sbarray_37(5)
integer, save :: sbarray_38(5)
integer, save :: sbarray_39(5)
integer, save :: sbarray_40(5)
integer, save :: sbarray_41(5)
integer, save :: sbarray_42(5)
integer, save :: sbarray_43(5)
integer, save :: sbarray_44(5)
integer, save :: sbarray_45(5)
integer, save :: sbarray_46(5)

  type(hcl), save, dimension(258) :: T0sum
  type(hcl), save, dimension(46) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppwajj_uuxcsxaw_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,15,4,1,G2H1,1)
  call hol_allocation(4,1,4,2,G0H2,1)
  call hol_allocation(4,5,4,2,G1H2,246)
  call hol_allocation(4,15,4,2,G2H2,64)
  call hol_allocation(4,1,4,4,G0H4,9)
  call hol_allocation(4,5,4,4,G1H4,54)
  call hol_allocation(4,15,4,4,G2H4,28)
  call hol_allocation(4,1,4,8,G0H8,12)
  call hol_allocation(4,5,4,8,G1H8,38)
  call hol_allocation(4,15,4,8,G2H8,9)
  call hol_allocation(4,1,4,16,G0H16,12)
  call hol_allocation(4,5,4,16,G1H16,14)
  call hol_allocation(4,1,4,32,G0H32,1)
  call hol_allocation(4,5,4,32,G1H32,16)
  call hol_allocation(4,1,4,96,G0H96,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppwajj_uuxcsxaw_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,15,4,min(nhel,1),G2H1,1)
  call hol_allocation(4,1,4,min(nhel,2),G0H2,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,246)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,64)
  call hol_allocation(4,1,4,min(nhel,4),G0H4,9)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,54)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,28)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,12)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,38)
  call hol_allocation(4,15,4,min(nhel,8),G2H8,9)
  call hol_allocation(4,1,4,min(nhel,16),G0H16,12)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,14)
  call hol_allocation(4,1,4,min(nhel,32),G0H32,1)
  call hol_allocation(4,5,4,min(nhel,32),G1H32,16)
  call hol_allocation(4,1,4,min(nhel,96),G0H96,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G2H1,1,dmode)
  call hol_deallocation(G0H2,1,dmode)
  call hol_deallocation(G1H2,246,dmode)
  call hol_deallocation(G2H2,64,dmode)
  call hol_deallocation(G0H4,9,dmode)
  call hol_deallocation(G1H4,54,dmode)
  call hol_deallocation(G2H4,28,dmode)
  call hol_deallocation(G0H8,12,dmode)
  call hol_deallocation(G1H8,38,dmode)
  call hol_deallocation(G2H8,9,dmode)
  call hol_deallocation(G0H16,12,dmode)
  call hol_deallocation(G1H16,14,dmode)
  call hol_deallocation(G0H32,1,dmode)
  call hol_deallocation(G1H32,16,dmode)
  call hol_deallocation(G0H96,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 560)
call hcl_allocation(5,G1tensor, 560)
call hcl_allocation(15,G2tensor, 278)
call hcl_allocation(35,G3tensor, 6)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 560,dmode)
call hcl_deallocation(G1tensor, 560,dmode)
call hcl_deallocation(G2tensor, 278,dmode)
call hcl_deallocation(G3tensor, 6,dmode)

    call hcl_deallocation(T0sum,258,dmode)
  call hcl_deallocation(T1sum,46,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,258)
  call hcl_allocation(5,T1sum,46)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppwajj_uuxcsxaw_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 6
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppwajj_uuxcsxaw_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,258
    call init_hcl(T0sum(i))
  end do
  do i = 1,46
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T1sum(3)%cmp, 4)
  call scale_one_tsum(T1sum(4)%cmp, 4)
  call scale_one_tsum(T1sum(5)%cmp, 4)
  call scale_one_tsum(T1sum(6)%cmp, 4)
  call scale_one_tsum(T1sum(7)%cmp, 2)
  call scale_one_tsum(T1sum(8)%cmp, 2)
  call scale_one_tsum(T1sum(9)%cmp, 2)
  call scale_one_tsum(T1sum(10)%cmp, 2)
  call scale_one_tsum(T1sum(11)%cmp, 2)
  call scale_one_tsum(T1sum(12)%cmp, 2)
  call scale_one_tsum(T1sum(13)%cmp, 2)
  call scale_one_tsum(T1sum(14)%cmp, 2)
  call scale_one_tsum(T1sum(15)%cmp, 2)
  call scale_one_tsum(T1sum(16)%cmp, 2)
  call scale_one_tsum(T1sum(17)%cmp, 2)
  call scale_one_tsum(T1sum(18)%cmp, 2)
  call scale_one_tsum(T1sum(19)%cmp, 2)
  call scale_one_tsum(T1sum(20)%cmp, 2)
  call scale_one_tsum(T1sum(21)%cmp, 2)
  call scale_one_tsum(T1sum(22)%cmp, 2)
  call scale_one_tsum(T1sum(23)%cmp, 2)
  call scale_one_tsum(T1sum(24)%cmp, 2)
  call scale_one_tsum(T1sum(25)%cmp, 2)
  call scale_one_tsum(T1sum(26)%cmp, 2)
  call scale_one_tsum(T1sum(27)%cmp, 2)
  call scale_one_tsum(T1sum(28)%cmp, 2)
  call scale_one_tsum(T1sum(29)%cmp, 2)
  call scale_one_tsum(T1sum(30)%cmp, 2)
  call scale_one_tsum(T1sum(31)%cmp, 2)
  call scale_one_tsum(T1sum(32)%cmp, 2)
  call scale_one_tsum(T1sum(33)%cmp, 2)
  call scale_one_tsum(T1sum(34)%cmp, 2)
  call scale_one_tsum(T1sum(35)%cmp, 2)
  call scale_one_tsum(T1sum(36)%cmp, 2)
  call scale_one_tsum(T1sum(37)%cmp, 2)
  call scale_one_tsum(T1sum(38)%cmp, 2)
  call scale_one_tsum(T1sum(39)%cmp, 2)
  call scale_one_tsum(T1sum(40)%cmp, 2)
  call scale_one_tsum(T1sum(41)%cmp, 2)
  call scale_one_tsum(T1sum(42)%cmp, 2)
  call scale_one_tsum(T1sum(43)%cmp, 2)
  call scale_one_tsum(T1sum(44)%cmp, 2)
  call scale_one_tsum(T1sum(45)%cmp, 2)
  call scale_one_tsum(T1sum(46)%cmp, 2)
  call scale_one_tsum(T0sum(1)%cmp, 0)
  call scale_one_tsum(T0sum(2)%cmp, 0)
  call scale_one_tsum(T0sum(3)%cmp, 0)
  call scale_one_tsum(T0sum(4)%cmp, 0)
  call scale_one_tsum(T0sum(5)%cmp, 0)
  call scale_one_tsum(T0sum(6)%cmp, 0)
  call scale_one_tsum(T0sum(7)%cmp, 0)
  call scale_one_tsum(T0sum(8)%cmp, 0)
  call scale_one_tsum(T0sum(9)%cmp, 0)
  call scale_one_tsum(T0sum(10)%cmp, 0)
  call scale_one_tsum(T0sum(11)%cmp, 0)
  call scale_one_tsum(T0sum(12)%cmp, 0)
  call scale_one_tsum(T0sum(13)%cmp, 0)
  call scale_one_tsum(T0sum(14)%cmp, 0)
  call scale_one_tsum(T0sum(15)%cmp, 0)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, 0)
  call scale_one_tsum(T0sum(40)%cmp, 0)
  call scale_one_tsum(T0sum(41)%cmp, 0)
  call scale_one_tsum(T0sum(42)%cmp, 0)
  call scale_one_tsum(T0sum(43)%cmp, 0)
  call scale_one_tsum(T0sum(44)%cmp, 0)
  call scale_one_tsum(T0sum(45)%cmp, 0)
  call scale_one_tsum(T0sum(46)%cmp, 0)
  call scale_one_tsum(T0sum(47)%cmp, 0)
  call scale_one_tsum(T0sum(48)%cmp, 0)
  call scale_one_tsum(T0sum(49)%cmp, 0)
  call scale_one_tsum(T0sum(50)%cmp, 0)
  call scale_one_tsum(T0sum(51)%cmp, 0)
  call scale_one_tsum(T0sum(52)%cmp, 0)
  call scale_one_tsum(T0sum(53)%cmp, 0)
  call scale_one_tsum(T0sum(54)%cmp, 0)
  call scale_one_tsum(T0sum(55)%cmp, 0)
  call scale_one_tsum(T0sum(56)%cmp, 0)
  call scale_one_tsum(T0sum(57)%cmp, 0)
  call scale_one_tsum(T0sum(58)%cmp, 0)
  call scale_one_tsum(T0sum(59)%cmp, 0)
  call scale_one_tsum(T0sum(60)%cmp, 0)
  call scale_one_tsum(T0sum(61)%cmp, 0)
  call scale_one_tsum(T0sum(62)%cmp, 0)
  call scale_one_tsum(T0sum(63)%cmp, 0)
  call scale_one_tsum(T0sum(64)%cmp, 0)
  call scale_one_tsum(T0sum(65)%cmp, 0)
  call scale_one_tsum(T0sum(66)%cmp, 0)
  call scale_one_tsum(T0sum(67)%cmp, 0)
  call scale_one_tsum(T0sum(68)%cmp, 0)
  call scale_one_tsum(T0sum(69)%cmp, 0)
  call scale_one_tsum(T0sum(70)%cmp, 0)
  call scale_one_tsum(T0sum(71)%cmp, 0)
  call scale_one_tsum(T0sum(72)%cmp, 0)
  call scale_one_tsum(T0sum(73)%cmp, 0)
  call scale_one_tsum(T0sum(74)%cmp, 0)
  call scale_one_tsum(T0sum(75)%cmp, 0)
  call scale_one_tsum(T0sum(76)%cmp, 0)
  call scale_one_tsum(T0sum(77)%cmp, 0)
  call scale_one_tsum(T0sum(78)%cmp, 0)
  call scale_one_tsum(T0sum(79)%cmp, 0)
  call scale_one_tsum(T0sum(80)%cmp, 0)
  call scale_one_tsum(T0sum(81)%cmp, 0)
  call scale_one_tsum(T0sum(82)%cmp, 0)
  call scale_one_tsum(T0sum(83)%cmp, 0)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, 0)
  call scale_one_tsum(T0sum(90)%cmp, 0)
  call scale_one_tsum(T0sum(91)%cmp, 0)
  call scale_one_tsum(T0sum(92)%cmp, 0)
  call scale_one_tsum(T0sum(93)%cmp, 0)
  call scale_one_tsum(T0sum(94)%cmp, 0)
  call scale_one_tsum(T0sum(95)%cmp, 0)
  call scale_one_tsum(T0sum(96)%cmp, 0)
  call scale_one_tsum(T0sum(97)%cmp, 0)
  call scale_one_tsum(T0sum(98)%cmp, 0)
  call scale_one_tsum(T0sum(99)%cmp, 0)
  call scale_one_tsum(T0sum(100)%cmp, 0)
  call scale_one_tsum(T0sum(101)%cmp, 0)
  call scale_one_tsum(T0sum(102)%cmp, 0)
  call scale_one_tsum(T0sum(103)%cmp, 0)
  call scale_one_tsum(T0sum(104)%cmp, 0)
  call scale_one_tsum(T0sum(105)%cmp, 0)
  call scale_one_tsum(T0sum(106)%cmp, 0)
  call scale_one_tsum(T0sum(107)%cmp, 0)
  call scale_one_tsum(T0sum(108)%cmp, 0)
  call scale_one_tsum(T0sum(109)%cmp, 0)
  call scale_one_tsum(T0sum(110)%cmp, 0)
  call scale_one_tsum(T0sum(111)%cmp, 0)
  call scale_one_tsum(T0sum(112)%cmp, 0)
  call scale_one_tsum(T0sum(113)%cmp, -2)
  call scale_one_tsum(T0sum(114)%cmp, -2)
  call scale_one_tsum(T0sum(115)%cmp, -2)
  call scale_one_tsum(T0sum(116)%cmp, -2)
  call scale_one_tsum(T0sum(117)%cmp, -2)
  call scale_one_tsum(T0sum(118)%cmp, -2)
  call scale_one_tsum(T0sum(119)%cmp, -2)
  call scale_one_tsum(T0sum(120)%cmp, -2)
  call scale_one_tsum(T0sum(121)%cmp, -2)
  call scale_one_tsum(T0sum(122)%cmp, -2)
  call scale_one_tsum(T0sum(123)%cmp, -2)
  call scale_one_tsum(T0sum(124)%cmp, -2)
  call scale_one_tsum(T0sum(125)%cmp, -2)
  call scale_one_tsum(T0sum(126)%cmp, -2)
  call scale_one_tsum(T0sum(127)%cmp, -2)
  call scale_one_tsum(T0sum(128)%cmp, -2)
  call scale_one_tsum(T0sum(129)%cmp, -2)
  call scale_one_tsum(T0sum(130)%cmp, -2)
  call scale_one_tsum(T0sum(131)%cmp, -2)
  call scale_one_tsum(T0sum(132)%cmp, -2)
  call scale_one_tsum(T0sum(133)%cmp, -2)
  call scale_one_tsum(T0sum(134)%cmp, -2)
  call scale_one_tsum(T0sum(135)%cmp, -2)
  call scale_one_tsum(T0sum(136)%cmp, -2)
  call scale_one_tsum(T0sum(137)%cmp, -2)
  call scale_one_tsum(T0sum(138)%cmp, -2)
  call scale_one_tsum(T0sum(139)%cmp, -2)
  call scale_one_tsum(T0sum(140)%cmp, -2)
  call scale_one_tsum(T0sum(141)%cmp, -2)
  call scale_one_tsum(T0sum(142)%cmp, -2)
  call scale_one_tsum(T0sum(143)%cmp, -2)
  call scale_one_tsum(T0sum(144)%cmp, -2)
  call scale_one_tsum(T0sum(145)%cmp, -2)
  call scale_one_tsum(T0sum(146)%cmp, -2)
  call scale_one_tsum(T0sum(147)%cmp, -2)
  call scale_one_tsum(T0sum(148)%cmp, -2)
  call scale_one_tsum(T0sum(149)%cmp, -2)
  call scale_one_tsum(T0sum(150)%cmp, -2)
  call scale_one_tsum(T0sum(151)%cmp, -2)
  call scale_one_tsum(T0sum(152)%cmp, -2)
  call scale_one_tsum(T0sum(153)%cmp, -2)
  call scale_one_tsum(T0sum(154)%cmp, -2)
  call scale_one_tsum(T0sum(155)%cmp, -2)
  call scale_one_tsum(T0sum(156)%cmp, -2)
  call scale_one_tsum(T0sum(157)%cmp, -2)
  call scale_one_tsum(T0sum(158)%cmp, -2)
  call scale_one_tsum(T0sum(159)%cmp, -2)
  call scale_one_tsum(T0sum(160)%cmp, -2)
  call scale_one_tsum(T0sum(161)%cmp, -2)
  call scale_one_tsum(T0sum(162)%cmp, -2)
  call scale_one_tsum(T0sum(163)%cmp, -2)
  call scale_one_tsum(T0sum(164)%cmp, -2)
  call scale_one_tsum(T0sum(165)%cmp, -2)
  call scale_one_tsum(T0sum(166)%cmp, -2)
  call scale_one_tsum(T0sum(167)%cmp, -2)
  call scale_one_tsum(T0sum(168)%cmp, -2)
  call scale_one_tsum(T0sum(169)%cmp, -2)
  call scale_one_tsum(T0sum(170)%cmp, -2)
  call scale_one_tsum(T0sum(171)%cmp, -2)
  call scale_one_tsum(T0sum(172)%cmp, -2)
  call scale_one_tsum(T0sum(173)%cmp, -2)
  call scale_one_tsum(T0sum(174)%cmp, -2)
  call scale_one_tsum(T0sum(175)%cmp, -2)
  call scale_one_tsum(T0sum(176)%cmp, -2)
  call scale_one_tsum(T0sum(177)%cmp, -2)
  call scale_one_tsum(T0sum(178)%cmp, -2)
  call scale_one_tsum(T0sum(179)%cmp, -2)
  call scale_one_tsum(T0sum(180)%cmp, -2)
  call scale_one_tsum(T0sum(181)%cmp, -2)
  call scale_one_tsum(T0sum(182)%cmp, -2)
  call scale_one_tsum(T0sum(183)%cmp, -2)
  call scale_one_tsum(T0sum(184)%cmp, -2)
  call scale_one_tsum(T0sum(185)%cmp, -2)
  call scale_one_tsum(T0sum(186)%cmp, -2)
  call scale_one_tsum(T0sum(187)%cmp, -2)
  call scale_one_tsum(T0sum(188)%cmp, -2)
  call scale_one_tsum(T0sum(189)%cmp, -2)
  call scale_one_tsum(T0sum(190)%cmp, -2)
  call scale_one_tsum(T0sum(191)%cmp, -2)
  call scale_one_tsum(T0sum(192)%cmp, -2)
  call scale_one_tsum(T0sum(193)%cmp, -2)
  call scale_one_tsum(T0sum(194)%cmp, -2)
  call scale_one_tsum(T0sum(195)%cmp, -2)
  call scale_one_tsum(T0sum(196)%cmp, -2)
  call scale_one_tsum(T0sum(197)%cmp, -2)
  call scale_one_tsum(T0sum(198)%cmp, -2)
  call scale_one_tsum(T0sum(199)%cmp, -2)
  call scale_one_tsum(T0sum(200)%cmp, -2)
  call scale_one_tsum(T0sum(201)%cmp, -2)
  call scale_one_tsum(T0sum(202)%cmp, -2)
  call scale_one_tsum(T0sum(203)%cmp, -2)
  call scale_one_tsum(T0sum(204)%cmp, -2)
  call scale_one_tsum(T0sum(205)%cmp, -2)
  call scale_one_tsum(T0sum(206)%cmp, -2)
  call scale_one_tsum(T0sum(207)%cmp, -2)
  call scale_one_tsum(T0sum(208)%cmp, -2)
  call scale_one_tsum(T0sum(209)%cmp, -2)
  call scale_one_tsum(T0sum(210)%cmp, -2)
  call scale_one_tsum(T0sum(211)%cmp, -2)
  call scale_one_tsum(T0sum(212)%cmp, -2)
  call scale_one_tsum(T0sum(213)%cmp, -2)
  call scale_one_tsum(T0sum(214)%cmp, -2)
  call scale_one_tsum(T0sum(215)%cmp, -2)
  call scale_one_tsum(T0sum(216)%cmp, -2)
  call scale_one_tsum(T0sum(217)%cmp, -2)
  call scale_one_tsum(T0sum(218)%cmp, -2)
  call scale_one_tsum(T0sum(219)%cmp, -2)
  call scale_one_tsum(T0sum(220)%cmp, -2)
  call scale_one_tsum(T0sum(221)%cmp, -2)
  call scale_one_tsum(T0sum(222)%cmp, -2)
  call scale_one_tsum(T0sum(223)%cmp, -2)
  call scale_one_tsum(T0sum(224)%cmp, -4)
  call scale_one_tsum(T0sum(225)%cmp, -4)
  call scale_one_tsum(T0sum(226)%cmp, -4)
  call scale_one_tsum(T0sum(227)%cmp, -4)
  call scale_one_tsum(T0sum(228)%cmp, -4)
  call scale_one_tsum(T0sum(229)%cmp, -4)
  call scale_one_tsum(T0sum(230)%cmp, -4)
  call scale_one_tsum(T0sum(231)%cmp, -4)
  call scale_one_tsum(T0sum(232)%cmp, -4)
  call scale_one_tsum(T0sum(233)%cmp, -4)
  call scale_one_tsum(T0sum(234)%cmp, -4)
  call scale_one_tsum(T0sum(235)%cmp, -4)
  call scale_one_tsum(T0sum(236)%cmp, -4)
  call scale_one_tsum(T0sum(237)%cmp, -4)
  call scale_one_tsum(T0sum(238)%cmp, -4)
  call scale_one_tsum(T0sum(239)%cmp, -4)
  call scale_one_tsum(T0sum(240)%cmp, -4)
  call scale_one_tsum(T0sum(241)%cmp, -4)
  call scale_one_tsum(T0sum(242)%cmp, -4)
  call scale_one_tsum(T0sum(243)%cmp, -4)
  call scale_one_tsum(T0sum(244)%cmp, -4)
  call scale_one_tsum(T0sum(245)%cmp, -4)
  call scale_one_tsum(T0sum(246)%cmp, -4)
  call scale_one_tsum(T0sum(247)%cmp, -4)
  call scale_one_tsum(T0sum(248)%cmp, -4)
  call scale_one_tsum(T0sum(249)%cmp, -4)
  call scale_one_tsum(T0sum(250)%cmp, -4)
  call scale_one_tsum(T0sum(251)%cmp, -4)
  call scale_one_tsum(T0sum(252)%cmp, -4)
  call scale_one_tsum(T0sum(253)%cmp, -4)
  call scale_one_tsum(T0sum(254)%cmp, -4)
  call scale_one_tsum(T0sum(255)%cmp, -4)
  call scale_one_tsum(T0sum(256)%cmp, -4)
  call scale_one_tsum(T0sum(257)%cmp, -4)
  call scale_one_tsum(T0sum(258)%cmp, -4)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 32, 31 ]
  momenta_3 = [ 35, 28 ]
  momenta_4 = [ 36, 27 ]
  momenta_5 = [ 37, 26 ]
  momenta_6 = [ 38, 25 ]
  momenta_7 = [ 39, 24 ]
  momenta_8 = [ 40, 23 ]
  momenta_9 = [ 41, 22 ]
  momenta_10 = [ 42, 21 ]
  momenta_11 = [ 43, 20 ]
  momenta_12 = [ 44, 19 ]
  momenta_13 = [ 45, 18 ]
  momenta_14 = [ 46, 17 ]
  momenta_15 = [ 47, 16 ]
  momenta_16 = [ 48, 15 ]
  momenta_17 = [ 51, 12 ]
  momenta_18 = [ 52, 11 ]
  momenta_19 = [ 53, 10 ]
  momenta_20 = [ 54, 9 ]
  momenta_21 = [ 55, 8 ]
  momenta_22 = [ 56, 7 ]
  momenta_23 = [ 57, 6 ]
  momenta_24 = [ 58, 5 ]
  momenta_25 = [ 59, 4 ]
  momenta_26 = [ 60, 3 ]
  momenta_27 = [ 61, 2 ]
  momenta_28 = [ 62, 1 ]
  momenta_29 = [ 32, 3, 28 ]
  momenta_30 = [ 32, 4, 27 ]
  momenta_31 = [ 32, 5, 26 ]
  momenta_32 = [ 32, 6, 25 ]
  momenta_33 = [ 32, 7, 24 ]
  momenta_34 = [ 32, 8, 23 ]
  momenta_35 = [ 32, 9, 22 ]
  momenta_36 = [ 32, 10, 21 ]
  momenta_37 = [ 32, 11, 20 ]
  momenta_38 = [ 32, 12, 19 ]
  momenta_39 = [ 32, 15, 16 ]
  momenta_40 = [ 32, 19, 12 ]
  momenta_41 = [ 32, 21, 10 ]
  momenta_42 = [ 32, 22, 9 ]
  momenta_43 = [ 32, 23, 8 ]
  momenta_44 = [ 32, 27, 4 ]
  momenta_45 = [ 35, 4, 24 ]
  momenta_46 = [ 35, 8, 20 ]
  momenta_47 = [ 35, 12, 16 ]
  momenta_48 = [ 35, 16, 12 ]
  momenta_49 = [ 35, 20, 8 ]
  momenta_50 = [ 35, 24, 4 ]
  momenta_51 = [ 36, 1, 26 ]
  momenta_52 = [ 36, 2, 25 ]
  momenta_53 = [ 36, 3, 24 ]
  momenta_54 = [ 36, 8, 19 ]
  momenta_55 = [ 36, 9, 18 ]
  momenta_56 = [ 36, 10, 17 ]
  momenta_57 = [ 36, 11, 16 ]
  momenta_58 = [ 36, 17, 10 ]
  momenta_59 = [ 36, 18, 9 ]
  momenta_60 = [ 36, 19, 8 ]
  momenta_61 = [ 37, 2, 24 ]
  momenta_62 = [ 37, 10, 16 ]
  momenta_63 = [ 37, 16, 10 ]
  momenta_64 = [ 37, 18, 8 ]
  momenta_65 = [ 38, 1, 24 ]
  momenta_66 = [ 38, 9, 16 ]
  momenta_67 = [ 38, 16, 9 ]
  momenta_68 = [ 38, 17, 8 ]
  momenta_69 = [ 39, 8, 16 ]
  momenta_70 = [ 39, 16, 8 ]
  momenta_71 = [ 40, 1, 22 ]
  momenta_72 = [ 40, 2, 21 ]
  momenta_73 = [ 40, 3, 20 ]
  momenta_74 = [ 40, 4, 19 ]
  momenta_75 = [ 40, 5, 18 ]
  momenta_76 = [ 40, 6, 17 ]
  momenta_77 = [ 40, 7, 16 ]
  momenta_78 = [ 40, 17, 6 ]
  momenta_79 = [ 40, 18, 5 ]
  momenta_80 = [ 40, 19, 4 ]
  momenta_81 = [ 40, 21, 2 ]
  momenta_82 = [ 40, 22, 1 ]
  momenta_83 = [ 41, 2, 20 ]
  momenta_84 = [ 41, 4, 18 ]
  momenta_85 = [ 41, 6, 16 ]
  momenta_86 = [ 41, 16, 6 ]
  momenta_87 = [ 41, 18, 4 ]
  momenta_88 = [ 42, 1, 20 ]
  momenta_89 = [ 42, 4, 17 ]
  momenta_90 = [ 42, 5, 16 ]
  momenta_91 = [ 42, 16, 5 ]
  momenta_92 = [ 42, 17, 4 ]
  momenta_93 = [ 43, 4, 16 ]
  momenta_94 = [ 43, 16, 4 ]
  momenta_95 = [ 44, 1, 18 ]
  momenta_96 = [ 44, 2, 17 ]
  momenta_97 = [ 44, 3, 16 ]
  momenta_98 = [ 44, 17, 2 ]
  momenta_99 = [ 44, 18, 1 ]
  momenta_100 = [ 45, 2, 16 ]
  momenta_101 = [ 45, 16, 2 ]
  momenta_102 = [ 46, 1, 16 ]
  momenta_103 = [ 46, 16, 1 ]
  momenta_104 = [ 48, 3, 12 ]
  momenta_105 = [ 48, 4, 11 ]
  momenta_106 = [ 48, 5, 10 ]
  momenta_107 = [ 48, 6, 9 ]
  momenta_108 = [ 48, 7, 8 ]
  momenta_109 = [ 48, 8, 7 ]
  momenta_110 = [ 48, 9, 6 ]
  momenta_111 = [ 48, 10, 5 ]
  momenta_112 = [ 48, 11, 4 ]
  momenta_113 = [ 48, 12, 3 ]
  momenta_114 = [ 51, 4, 8 ]
  momenta_115 = [ 51, 8, 4 ]
  momenta_116 = [ 52, 1, 10 ]
  momenta_117 = [ 52, 2, 9 ]
  momenta_118 = [ 52, 3, 8 ]
  momenta_119 = [ 52, 8, 3 ]
  momenta_120 = [ 52, 9, 2 ]
  momenta_121 = [ 52, 10, 1 ]
  momenta_122 = [ 53, 2, 8 ]
  momenta_123 = [ 53, 8, 2 ]
  momenta_124 = [ 54, 1, 8 ]
  momenta_125 = [ 54, 8, 1 ]
  momenta_126 = [ 56, 1, 6 ]
  momenta_127 = [ 56, 2, 5 ]
  momenta_128 = [ 56, 3, 4 ]
  momenta_129 = [ 56, 4, 3 ]
  momenta_130 = [ 56, 5, 2 ]
  momenta_131 = [ 56, 6, 1 ]
  momenta_132 = [ 57, 2, 4 ]
  momenta_133 = [ 57, 4, 2 ]
  momenta_134 = [ 58, 1, 4 ]
  momenta_135 = [ 58, 4, 1 ]
  momenta_136 = [ 60, 1, 2 ]
  momenta_137 = [ 60, 2, 1 ]
  momenta_138 = [ 32, 3, 4, 24 ]
  momenta_139 = [ 32, 3, 8, 20 ]
  momenta_140 = [ 32, 3, 12, 16 ]
  momenta_141 = [ 32, 3, 16, 12 ]
  momenta_142 = [ 32, 3, 20, 8 ]
  momenta_143 = [ 32, 3, 24, 4 ]
  momenta_144 = [ 32, 4, 1, 26 ]
  momenta_145 = [ 32, 4, 2, 25 ]
  momenta_146 = [ 32, 4, 3, 24 ]
  momenta_147 = [ 32, 4, 8, 19 ]
  momenta_148 = [ 32, 4, 11, 16 ]
  momenta_149 = [ 32, 4, 17, 10 ]
  momenta_150 = [ 32, 4, 18, 9 ]
  momenta_151 = [ 32, 4, 19, 8 ]
  momenta_152 = [ 32, 5, 2, 24 ]
  momenta_153 = [ 32, 5, 10, 16 ]
  momenta_154 = [ 32, 5, 16, 10 ]
  momenta_155 = [ 32, 5, 18, 8 ]
  momenta_156 = [ 32, 6, 1, 24 ]
  momenta_157 = [ 32, 6, 9, 16 ]
  momenta_158 = [ 32, 6, 16, 9 ]
  momenta_159 = [ 32, 6, 17, 8 ]
  momenta_160 = [ 32, 7, 8, 16 ]
  momenta_161 = [ 32, 8, 1, 22 ]
  momenta_162 = [ 32, 8, 2, 21 ]
  momenta_163 = [ 32, 8, 3, 20 ]
  momenta_164 = [ 32, 8, 4, 19 ]
  momenta_165 = [ 32, 8, 7, 16 ]
  momenta_166 = [ 32, 9, 2, 20 ]
  momenta_167 = [ 32, 9, 6, 16 ]
  momenta_168 = [ 32, 10, 1, 20 ]
  momenta_169 = [ 32, 10, 5, 16 ]
  momenta_170 = [ 32, 11, 4, 16 ]
  momenta_171 = [ 32, 12, 3, 16 ]
  momenta_172 = [ 32, 19, 4, 8 ]
  momenta_173 = [ 32, 19, 8, 4 ]
  momenta_174 = [ 32, 21, 2, 8 ]
  momenta_175 = [ 32, 22, 1, 8 ]
  momenta_176 = [ 35, 4, 8, 16 ]
  momenta_177 = [ 35, 8, 4, 16 ]
  momenta_178 = [ 35, 16, 4, 8 ]
  momenta_179 = [ 35, 16, 8, 4 ]
  momenta_180 = [ 36, 1, 2, 24 ]
  momenta_181 = [ 36, 1, 10, 16 ]
  momenta_182 = [ 36, 1, 16, 10 ]
  momenta_183 = [ 36, 1, 18, 8 ]
  momenta_184 = [ 36, 2, 1, 24 ]
  momenta_185 = [ 36, 2, 9, 16 ]
  momenta_186 = [ 36, 2, 16, 9 ]
  momenta_187 = [ 36, 2, 17, 8 ]
  momenta_188 = [ 36, 3, 8, 16 ]
  momenta_189 = [ 36, 3, 16, 8 ]
  momenta_190 = [ 36, 8, 1, 18 ]
  momenta_191 = [ 36, 8, 2, 17 ]
  momenta_192 = [ 36, 8, 3, 16 ]
  momenta_193 = [ 36, 17, 2, 8 ]
  momenta_194 = [ 36, 18, 1, 8 ]
  momenta_195 = [ 37, 2, 8, 16 ]
  momenta_196 = [ 37, 16, 2, 8 ]
  momenta_197 = [ 38, 1, 8, 16 ]
  momenta_198 = [ 38, 16, 1, 8 ]
  momenta_199 = [ 40, 1, 2, 20 ]
  momenta_200 = [ 40, 1, 6, 16 ]
  momenta_201 = [ 40, 1, 16, 6 ]
  momenta_202 = [ 40, 1, 18, 4 ]
  momenta_203 = [ 40, 2, 1, 20 ]
  momenta_204 = [ 40, 2, 5, 16 ]
  momenta_205 = [ 40, 2, 16, 5 ]
  momenta_206 = [ 40, 2, 17, 4 ]
  momenta_207 = [ 40, 3, 4, 16 ]
  momenta_208 = [ 40, 3, 16, 4 ]
  momenta_209 = [ 40, 4, 1, 18 ]
  momenta_210 = [ 40, 4, 2, 17 ]
  momenta_211 = [ 40, 4, 3, 16 ]
  momenta_212 = [ 40, 4, 17, 2 ]
  momenta_213 = [ 40, 4, 18, 1 ]
  momenta_214 = [ 40, 5, 16, 2 ]
  momenta_215 = [ 40, 6, 16, 1 ]
  momenta_216 = [ 40, 17, 2, 4 ]
  momenta_217 = [ 40, 18, 1, 4 ]
  momenta_218 = [ 41, 2, 4, 16 ]
  momenta_219 = [ 41, 4, 2, 16 ]
  momenta_220 = [ 41, 16, 2, 4 ]
  momenta_221 = [ 42, 1, 4, 16 ]
  momenta_222 = [ 42, 4, 1, 16 ]
  momenta_223 = [ 42, 16, 1, 4 ]
  momenta_224 = [ 44, 1, 2, 16 ]
  momenta_225 = [ 44, 1, 16, 2 ]
  momenta_226 = [ 44, 2, 1, 16 ]
  momenta_227 = [ 44, 2, 16, 1 ]
  momenta_228 = [ 48, 3, 4, 8 ]
  momenta_229 = [ 48, 3, 8, 4 ]
  momenta_230 = [ 48, 4, 1, 10 ]
  momenta_231 = [ 48, 4, 2, 9 ]
  momenta_232 = [ 48, 4, 3, 8 ]
  momenta_233 = [ 48, 4, 8, 3 ]
  momenta_234 = [ 48, 5, 2, 8 ]
  momenta_235 = [ 48, 6, 1, 8 ]
  momenta_236 = [ 48, 8, 1, 6 ]
  momenta_237 = [ 48, 8, 2, 5 ]
  momenta_238 = [ 48, 8, 3, 4 ]
  momenta_239 = [ 48, 8, 4, 3 ]
  momenta_240 = [ 48, 9, 2, 4 ]
  momenta_241 = [ 48, 10, 1, 4 ]
  momenta_242 = [ 52, 1, 2, 8 ]
  momenta_243 = [ 52, 2, 1, 8 ]
  momenta_244 = [ 52, 8, 1, 2 ]
  momenta_245 = [ 52, 8, 2, 1 ]
  momenta_246 = [ 56, 1, 2, 4 ]
  momenta_247 = [ 56, 2, 1, 4 ]
  momenta_248 = [ 56, 4, 1, 2 ]
  momenta_249 = [ 56, 4, 2, 1 ]
  momenta_250 = [ 32, 3, 4, 8, 16 ]
  momenta_251 = [ 32, 3, 8, 4, 16 ]
  momenta_252 = [ 32, 3, 16, 4, 8 ]
  momenta_253 = [ 32, 3, 16, 8, 4 ]
  momenta_254 = [ 32, 4, 1, 2, 24 ]
  momenta_255 = [ 32, 4, 1, 10, 16 ]
  momenta_256 = [ 32, 4, 1, 18, 8 ]
  momenta_257 = [ 32, 4, 2, 1, 24 ]
  momenta_258 = [ 32, 4, 2, 9, 16 ]
  momenta_259 = [ 32, 4, 2, 17, 8 ]
  momenta_260 = [ 32, 4, 3, 8, 16 ]
  momenta_261 = [ 32, 4, 8, 3, 16 ]
  momenta_262 = [ 32, 4, 17, 2, 8 ]
  momenta_263 = [ 32, 4, 18, 1, 8 ]
  momenta_264 = [ 32, 5, 2, 8, 16 ]
  momenta_265 = [ 32, 5, 16, 2, 8 ]
  momenta_266 = [ 32, 6, 1, 8, 16 ]
  momenta_267 = [ 32, 6, 16, 1, 8 ]
  momenta_268 = [ 32, 8, 1, 2, 20 ]
  momenta_269 = [ 32, 8, 1, 6, 16 ]
  momenta_270 = [ 32, 8, 2, 1, 20 ]
  momenta_271 = [ 32, 8, 2, 5, 16 ]
  momenta_272 = [ 32, 8, 3, 4, 16 ]
  momenta_273 = [ 32, 8, 4, 3, 16 ]
  momenta_274 = [ 32, 9, 2, 4, 16 ]
  momenta_275 = [ 32, 10, 1, 4, 16 ]
  momenta_276 = [ 36, 1, 2, 8, 16 ]
  momenta_277 = [ 36, 1, 16, 2, 8 ]
  momenta_278 = [ 36, 2, 1, 8, 16 ]
  momenta_279 = [ 36, 2, 16, 1, 8 ]
  momenta_280 = [ 40, 1, 2, 4, 16 ]
  momenta_281 = [ 40, 1, 16, 2, 4 ]
  momenta_282 = [ 40, 2, 1, 4, 16 ]
  momenta_283 = [ 40, 2, 16, 1, 4 ]
  momenta_284 = [ 40, 4, 1, 16, 2 ]
  momenta_285 = [ 40, 4, 2, 16, 1 ]
  momenta_286 = [ 48, 4, 1, 2, 8 ]
  momenta_287 = [ 48, 4, 2, 1, 8 ]
  momenta_288 = [ 48, 8, 1, 2, 4 ]
  momenta_289 = [ 48, 8, 2, 1, 4 ]
  momenta_290 = [ 32, 4, 1, 2, 8, 16 ]
  momenta_291 = [ 32, 4, 1, 16, 2, 8 ]
  momenta_292 = [ 32, 4, 2, 1, 8, 16 ]
  momenta_293 = [ 32, 4, 2, 16, 1, 8 ]
  momenta_294 = [ 32, 8, 1, 2, 4, 16 ]
  momenta_295 = [ 32, 8, 2, 1, 4, 16 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMT, 0 ]
  masses2_4 = [ nMB, nMB ]
  masses2_5 = [ nMT, nMT ]
  masses2_6 = [ 0, 0, 0 ]
  masses2_7 = [ nMB, nMB, nMB ]
  masses2_8 = [ nMT, nMT, nMT ]
  masses2_9 = [ 0, 0, 0, 0 ]
  masses2_10 = [ 0, 0, 0, 0, 0 ]
  masses2_11 = [ 0, 0, 0, 0, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
sbarray_2 = [16, 17, 18, 19, 20, 21, 22, 23, 24, 10, 25, 26, 27, 28, 29]
sbarray_3 = [30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44]
sbarray_4 = [45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 13, 57, 58]
sbarray_5 = [59, 31, 60, 61, 62, 35, 63, 64, 65, 39, 40, 41, 66, 67, 68]
sbarray_6 = [69, 46, 70, 71, 72, 50, 73, 74, 75, 54, 55, 56, 27, 76, 77]
sbarray_7 = [78, 79, 80, 81, 15]
sbarray_8 = [82, 83, 84, 85, 29]
sbarray_9 = [86, 87, 88, 89, 44]
sbarray_10 = [90, 91, 92, 93, 58]
sbarray_11 = [94, 95, 88, 96, 68]
sbarray_12 = [97, 98, 92, 99, 77]
sbarray_13 = [1, 2, 3, 4, 5]
sbarray_14 = [1, 6, 7, 8, 9]
sbarray_15 = [2, 6, 10, 11, 12]
sbarray_16 = [3, 7, 10, 13, 14]
sbarray_17 = [16, 17, 18, 19, 20]
sbarray_18 = [16, 21, 22, 23, 24]
sbarray_19 = [17, 21, 10, 25, 26]
sbarray_20 = [18, 22, 10, 27, 28]
sbarray_21 = [30, 31, 32, 33, 34]
sbarray_22 = [30, 35, 36, 37, 38]
sbarray_23 = [31, 35, 39, 40, 41]
sbarray_24 = [32, 36, 39, 42, 43]
sbarray_25 = [45, 46, 47, 48, 49]
sbarray_26 = [45, 50, 51, 52, 53]
sbarray_27 = [46, 50, 54, 55, 56]
sbarray_28 = [47, 51, 54, 13, 57]
sbarray_29 = [59, 31, 60, 61, 62]
sbarray_30 = [59, 35, 63, 64, 65]
sbarray_31 = [60, 63, 39, 66, 67]
sbarray_32 = [69, 46, 70, 71, 72]
sbarray_33 = [69, 50, 73, 74, 75]
sbarray_34 = [70, 73, 54, 27, 76]
sbarray_35 = [61, 64, 40, 66, 68]
sbarray_36 = [33, 37, 40, 42, 44]
sbarray_37 = [48, 52, 55, 13, 58]
sbarray_38 = [71, 74, 55, 27, 77]
sbarray_39 = [100, 101, 102, 103, 20]
sbarray_40 = [104, 105, 106, 107, 5]
sbarray_41 = [108, 109, 110, 111, 112]
sbarray_42 = [113, 114, 115, 111, 116]
sbarray_43 = [117, 35, 118, 119, 120]
sbarray_44 = [121, 122, 54, 123, 124]
sbarray_45 = [125, 50, 118, 126, 127]
sbarray_46 = [128, 122, 39, 129, 130]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_209, masses2_9, T0sum(1), M2,[81], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_210, masses2_9, T0sum(2), M2,[85], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_144, masses2_9, T0sum(3), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_145, masses2_9, T0sum(4), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_245, masses2_9, T0sum(5), M2,[44], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_237, masses2_9, T0sum(6), M2,[89], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_162, masses2_9, T0sum(7), M2,[42], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_248, masses2_9, T0sum(8), M2,[58], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_230, masses2_9, T0sum(9), M2,[93], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_244, masses2_9, T0sum(10), M2,[68], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_236, masses2_9, T0sum(11), M2,[96], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_161, masses2_9, T0sum(12), M2,[66], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_249, masses2_9, T0sum(13), M2,[77], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_231, masses2_9, T0sum(14), M2,[99], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_225, masses2_9, T0sum(15), M2,[78], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_182, masses2_9, T0sum(16), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_214, masses2_9, T0sum(17), M2,[79], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_154, masses2_9, T0sum(18), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_212, masses2_9, T0sum(19), M2,[80], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_9, T0sum(20), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_227, masses2_9, T0sum(21), M2,[82], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_186, masses2_9, T0sum(22), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_215, masses2_9, T0sum(23), M2,[83], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_158, masses2_9, T0sum(24), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_213, masses2_9, T0sum(25), M2,[84], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_150, masses2_9, T0sum(26), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_247, masses2_9, T0sum(27), M2,[86], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_203, masses2_9, T0sum(28), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_241, masses2_9, T0sum(29), M2,[87], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_168, masses2_9, T0sum(30), M2,[37], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_238, masses2_9, T0sum(31), M2,[88], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_163, masses2_9, T0sum(32), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_242, masses2_9, T0sum(33), M2,[90], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_180, masses2_9, T0sum(34), M2,[48], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_234, masses2_9, T0sum(35), M2,[91], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_9, T0sum(36), M2,[52], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_232, masses2_9, T0sum(37), M2,[92], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_9, T0sum(38), M2,[55], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_246, masses2_9, T0sum(39), M2,[94], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_199, masses2_9, T0sum(40), M2,[61], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_240, masses2_9, T0sum(41), M2,[95], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_166, masses2_9, T0sum(42), M2,[64], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_243, masses2_9, T0sum(43), M2,[97], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_184, masses2_9, T0sum(44), M2,[71], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_235, masses2_9, T0sum(45), M2,[98], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_156, masses2_9, T0sum(46), M2,[74], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_205, masses2_9, T0sum(47), M2,[103], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_201, masses2_9, T0sum(48), M2,[107], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_208, masses2_9, T0sum(49), M2,[112], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_141, masses2_9, T0sum(50), M2,[111], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_189, masses2_9, T0sum(51), M2,[116], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_229, masses2_9, T0sum(52), M2,[120], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_9, T0sum(53), M2,[119], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_233, masses2_9, T0sum(54), M2,[124], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_9, T0sum(55), M2,[123], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_228, masses2_9, T0sum(56), M2,[127], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_138, masses2_9, T0sum(57), M2,[126], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_239, masses2_9, T0sum(58), M2,[130], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_164, masses2_9, T0sum(59), M2,[129], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_222, masses2_9, T0sum(60), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_219, masses2_9, T0sum(61), M2,[29], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_196, masses2_9, T0sum(62), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_193, masses2_9, T0sum(63), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_183, masses2_9, T0sum(64), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_174, masses2_9, T0sum(65), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_155, masses2_9, T0sum(66), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_151, masses2_9, T0sum(67), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_198, masses2_9, T0sum(68), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_194, masses2_9, T0sum(69), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_187, masses2_9, T0sum(70), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_175, masses2_9, T0sum(71), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_159, masses2_9, T0sum(72), M2,[22], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_221, masses2_9, T0sum(73), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_207, masses2_9, T0sum(74), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_204, masses2_9, T0sum(75), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_170, masses2_9, T0sum(76), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_169, masses2_9, T0sum(77), M2,[36], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_165, masses2_9, T0sum(78), M2,[39], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_195, masses2_9, T0sum(79), M2,[45], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_188, masses2_9, T0sum(80), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_181, masses2_9, T0sum(81), M2,[47], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_160, masses2_9, T0sum(82), M2,[50], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_9, T0sum(83), M2,[51], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_148, masses2_9, T0sum(84), M2,[54], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_218, masses2_9, T0sum(85), M2,[59], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_200, masses2_9, T0sum(86), M2,[60], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_167, masses2_9, T0sum(87), M2,[63], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_197, masses2_9, T0sum(88), M2,[69], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_185, masses2_9, T0sum(89), M2,[70], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_157, masses2_9, T0sum(90), M2,[73], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_223, masses2_9, T0sum(91), M2,[100], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_217, masses2_9, T0sum(92), M2,[101], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_206, masses2_9, T0sum(93), M2,[102], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_220, masses2_9, T0sum(94), M2,[104], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_216, masses2_9, T0sum(95), M2,[105], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_202, masses2_9, T0sum(96), M2,[106], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_178, masses2_9, T0sum(97), M2,[108], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_172, masses2_9, T0sum(98), M2,[109], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_142, masses2_9, T0sum(99), M2,[110], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_179, masses2_9, T0sum(100), M2,[113], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_173, masses2_9, T0sum(101), M2,[114], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_143, masses2_9, T0sum(102), M2,[115], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_177, masses2_9, T0sum(103), M2,[117], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_140, masses2_9, T0sum(104), M2,[118], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_192, masses2_9, T0sum(105), M2,[121], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_171, masses2_9, T0sum(106), M2,[122], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_176, masses2_9, T0sum(107), M2,[125], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_211, masses2_9, T0sum(108), M2,[128], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_191, masses2_9, T0sum(109), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_190, masses2_9, T0sum(110), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_226, masses2_9, T0sum(111), M2)
  call TI_call_OL(0,0, momenta_224, masses2_9, T0sum(112), M2)
  call TI_call_OL(0,0, momenta_97, masses2_6, T0sum(113), M2)
  call TI_call_OL(0,0, momenta_119, masses2_6, T0sum(114), M2)
  call TI_call_OL(0,0, momenta_129, masses2_6, T0sum(115), M2)
  call TI_call_OL(0,0, momenta_118, masses2_6, T0sum(116), M2)
  call TI_call_OL(0,0, momenta_114, masses2_6, T0sum(117), M2)
  call TI_call_OL(0,0, momenta_128, masses2_6, T0sum(118), M2)
  call TI_call_OL(0,0, momenta_115, masses2_6, T0sum(119), M2)
  call TI_call_OL(0,0, momenta_48, masses2_6, T0sum(120), M2)
  call TI_call_OL(0,0, momenta_40, masses2_6, T0sum(121), M2)
  call TI_call_OL(0,0, momenta_29, masses2_6, T0sum(122), M2)
  call TI_call_OL(0,0, momenta_73, masses2_6, T0sum(123), M2)
  call TI_call_OL(0,0, momenta_37, masses2_6, T0sum(124), M2)
  call TI_call_OL(0,0, momenta_34, masses2_6, T0sum(125), M2)
  call TI_call_OL(0,0, momenta_53, masses2_6, T0sum(126), M2)
  call TI_call_OL(0,0, momenta_33, masses2_6, T0sum(127), M2)
  call TI_call_OL(0,0, momenta_30, masses2_6, T0sum(128), M2)
  call TI_call_OL(0,0, momenta_46, masses2_6, T0sum(129), M2)
  call TI_call_OL(0,0, momenta_54, masses2_6, T0sum(130), M2)
  call TI_call_OL(0,0, momenta_38, masses2_6, T0sum(131), M2)
  call TI_call_OL(0,0, momenta_45, masses2_6, T0sum(132), M2)
  call TI_call_OL(0,0, momenta_74, masses2_6, T0sum(133), M2)
  call TI_call_OL(0,0, momenta_95, masses2_6, T0sum(134), M2)
  call TI_call_OL(0,0, momenta_109, masses2_6, T0sum(135), M2)
  call TI_call_OL(0,0, momenta_105, masses2_6, T0sum(136), M2)
  call TI_call_OL(0,0, momenta_104, masses2_6, T0sum(137), M2)
  call TI_call_OL(0,0, momenta_112, masses2_6, T0sum(138), M2)
  call TI_call_OL(0,0, momenta_108, masses2_6, T0sum(139), M2)
  call TI_call_OL(0,0, momenta_94, masses2_6, T0sum(140), M2)
  call TI_call_OL(0,0, momenta_80, masses2_6, T0sum(141), M2)
  call TI_call_OL(0,0, momenta_70, masses2_6, T0sum(142), M2)
  call TI_call_OL(0,0, momenta_60, masses2_6, T0sum(143), M2)
  call TI_call_OL(0,0, momenta_113, masses2_6, T0sum(144), M2)
  call TI_call_OL(0,0, momenta_137, masses2_6, T0sum(145), M2)
  call TI_call_OL(0,0, momenta_96, masses2_6, T0sum(146), M2)
  call TI_call_OL(0,0, momenta_136, masses2_6, T0sum(147), M2)
  call TI_call_OL(0,0, momenta_135, masses2_6, T0sum(148), M2)
  call TI_call_OL(0,0, momenta_75, masses2_6, T0sum(149), M2)
  call TI_call_OL(0,0, momenta_133, masses2_6, T0sum(150), M2)
  call TI_call_OL(0,0, momenta_76, masses2_6, T0sum(151), M2)
  call TI_call_OL(0,0, momenta_51, masses2_6, T0sum(152), M2)
  call TI_call_OL(0,0, momenta_31, masses2_6, T0sum(153), M2)
  call TI_call_OL(0,0, momenta_52, masses2_6, T0sum(154), M2)
  call TI_call_OL(0,0, momenta_32, masses2_6, T0sum(155), M2)
  call TI_call_OL(0,0, momenta_123, masses2_6, T0sum(156), M2)
  call TI_call_OL(0,0, momenta_121, masses2_6, T0sum(157), M2)
  call TI_call_OL(0,0, momenta_127, masses2_6, T0sum(158), M2)
  call TI_call_OL(0,0, momenta_111, masses2_6, T0sum(159), M2)
  call TI_call_OL(0,0, momenta_72, masses2_6, T0sum(160), M2)
  call TI_call_OL(0,0, momenta_36, masses2_6, T0sum(161), M2)
  call TI_call_OL(0,0, momenta_130, masses2_6, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_116, masses2_6, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_106, masses2_6, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_125, masses2_6, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_120, masses2_6, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_126, masses2_6, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_110, masses2_6, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_71, masses2_6, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_35, masses2_6, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_131, masses2_6, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_117, masses2_6, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_107, masses2_6, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_102, masses2_6, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_101, masses2_6, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_98, masses2_6, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_63, masses2_6, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_58, masses2_6, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_90, masses2_6, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_81, masses2_6, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_41, masses2_6, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_89, masses2_6, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_100, masses2_6, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_103, masses2_6, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_99, masses2_6, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_67, masses2_6, T0sum(186), M2)
  call TI_call_OL(0,0, momenta_59, masses2_6, T0sum(187), M2)
  call TI_call_OL(0,0, momenta_85, masses2_6, T0sum(188), M2)
  call TI_call_OL(0,0, momenta_82, masses2_6, T0sum(189), M2)
  call TI_call_OL(0,0, momenta_42, masses2_6, T0sum(190), M2)
  call TI_call_OL(0,0, momenta_84, masses2_6, T0sum(191), M2)
  call TI_call_OL(0,0, momenta_134, masses2_6, T0sum(192), M2)
  call TI_call_OL(0,0, momenta_88, masses2_6, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_122, masses2_6, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_61, masses2_6, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_132, masses2_6, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_83, masses2_6, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_124, masses2_6, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_65, masses2_6, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_91, masses2_6, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_79, masses2_6, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_86, masses2_6, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_78, masses2_6, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_64, masses2_6, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_43, masses2_6, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_68, masses2_6, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_93, masses2_6, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_77, masses2_6, T0sum(208), M2)
  call TI_call_OL(0,0, momenta_39, masses2_6, T0sum(209), M2)
  call TI_call_OL(0,0, momenta_69, masses2_6, T0sum(210), M2)
  call TI_call_OL(0,0, momenta_62, masses2_6, T0sum(211), M2)
  call TI_call_OL(0,0, momenta_57, masses2_6, T0sum(212), M2)
  call TI_call_OL(0,0, momenta_66, masses2_6, T0sum(213), M2)
  call TI_call_OL(0,0, momenta_92, masses2_6, T0sum(214), M2)
  call TI_call_OL(0,0, momenta_87, masses2_6, T0sum(215), M2)
  call TI_call_OL(0,0, momenta_49, masses2_6, T0sum(216), M2)
  call TI_call_OL(0,0, momenta_50, masses2_6, T0sum(217), M2)
  call TI_call_OL(0,0, momenta_44, masses2_6, T0sum(218), M2)
  call TI_call_OL(0,0, momenta_47, masses2_6, T0sum(219), M2)
  call TI_call_OL(0,0, momenta_56, masses2_6, T0sum(220), M2)
  call TI_call_OL(0,0, momenta_55, masses2_6, T0sum(221), M2)
  call TI_call_OL(0,0, momenta_97, masses2_8, T0sum(222), M2)
  call TI_call_OL(0,0, momenta_97, masses2_7, T0sum(223), M2)
  call TI_call_OL(0,0, momenta_26, masses2_1, T0sum(224), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(225), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(226), M2)
  call TI_call_OL(0,0, momenta_21, masses2_1, T0sum(227), M2)
  call TI_call_OL(0,0, momenta_18, masses2_1, T0sum(228), M2)
  call TI_call_OL(0,0, momenta_25, masses2_1, T0sum(229), M2)
  call TI_call_OL(0,0, momenta_22, masses2_1, T0sum(230), M2)
  call TI_call_OL(0,0, momenta_17, masses2_1, T0sum(231), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(232), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(233), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(234), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(235), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(236), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(237), M2)
  call TI_call_OL(0,0, momenta_28, masses2_1, T0sum(238), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(239), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(240), M2)
  call TI_call_OL(0,0, momenta_27, masses2_1, T0sum(241), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(242), M2)
  call TI_call_OL(0,0, momenta_26, masses2_5, T0sum(243), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(244), M2)
  call TI_call_OL(0,0, momenta_15, masses2_5, T0sum(245), M2)
  call TI_call_OL(0,0, momenta_12, masses2_5, T0sum(246), M2)
  call TI_call_OL(0,0, momenta_26, masses2_4, T0sum(247), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(248), M2)
  call TI_call_OL(0,0, momenta_15, masses2_4, T0sum(249), M2)
  call TI_call_OL(0,0, momenta_12, masses2_4, T0sum(250), M2)
  call TI_call_OL(0,0, momenta_24, masses2_1, T0sum(251), M2)
  call TI_call_OL(0,0, momenta_23, masses2_1, T0sum(252), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(253), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(254), M2)
  call TI_call_OL(0,0, momenta_19, masses2_1, T0sum(255), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(256), M2)
  call TI_call_OL(0,0, momenta_20, masses2_1, T0sum(257), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(258), M2)

  call TI_call_OL(0,1, momenta_291, masses2_11, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_293, masses2_11, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_295, masses2_11, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_290, masses2_11, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_294, masses2_11, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_292, masses2_11, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_284, masses2_10, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_285, masses2_10, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_289, masses2_10, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_286, masses2_10, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_288, masses2_10, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_287, masses2_10, T1sum(12), M2,sbarray_12, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_277, masses2_10, T1sum(13), M2,sbarray_13, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_265, masses2_10, T1sum(14), M2,sbarray_14, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_262, masses2_10, T1sum(15), M2,sbarray_15, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_256, masses2_10, T1sum(16), M2,sbarray_16, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_279, masses2_10, T1sum(17), M2,sbarray_17, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_267, masses2_10, T1sum(18), M2,sbarray_18, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_263, masses2_10, T1sum(19), M2,sbarray_19, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_259, masses2_10, T1sum(20), M2,sbarray_20, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_282, masses2_10, T1sum(21), M2,sbarray_21, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_275, masses2_10, T1sum(22), M2,sbarray_22, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_272, masses2_10, T1sum(23), M2,sbarray_23, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_271, masses2_10, T1sum(24), M2,sbarray_24, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_276, masses2_10, T1sum(25), M2,sbarray_25, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_264, masses2_10, T1sum(26), M2,sbarray_26, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_260, masses2_10, T1sum(27), M2,sbarray_27, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_255, masses2_10, T1sum(28), M2,sbarray_28, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_280, masses2_10, T1sum(29), M2,sbarray_29, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_274, masses2_10, T1sum(30), M2,sbarray_30, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_269, masses2_10, T1sum(31), M2,sbarray_31, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_278, masses2_10, T1sum(32), M2,sbarray_32, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_266, masses2_10, T1sum(33), M2,sbarray_33, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_258, masses2_10, T1sum(34), M2,sbarray_34, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_268, masses2_10, T1sum(35), M2,sbarray_35, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_270, masses2_10, T1sum(36), M2,sbarray_36, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_254, masses2_10, T1sum(37), M2,sbarray_37, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_257, masses2_10, T1sum(38), M2,sbarray_38, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_283, masses2_10, T1sum(39), M2,sbarray_39, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_281, masses2_10, T1sum(40), M2,sbarray_40, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_252, masses2_10, T1sum(41), M2,sbarray_41, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_253, masses2_10, T1sum(42), M2,sbarray_42, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_251, masses2_10, T1sum(43), M2,sbarray_43, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_261, masses2_10, T1sum(44), M2,sbarray_44, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_250, masses2_10, T1sum(45), M2,sbarray_45, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_273, masses2_10, T1sum(46), M2,sbarray_46, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppwajj_uuxcsxaw_1_/**/REALKIND
