
module ol_colourmatrix_ppwajj_uuxuxdawx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(46,2), K2(2,2), KL(2,2), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   3]
  K1( 2,:) = [   3,   9]
  K1( 3,:) = [  12,   4]
  K1( 4,:) = [   4,  12]
  K1( 5,:) = [   0,  -4]
  K1( 6,:) = [  -4, -12]
  K1( 7,:) = [  12,   4]
  K1( 8,:) = [   4,  12]
  K1( 9,:) = [ -12,  -4]
  K1(10,:) = [  -4,   0]
  K1(11,:) = [   0,   4]
  K1(12,:) = [   4,   0]
  K1(13,:) = [  12,   4]
  K1(14,:) = [   4,  12]
  K1(15,:) = [   0,   4]
  K1(16,:) = [   4,   0]
  K1(17,:) = [ -12,  -4]
  K1(18,:) = [  -4,   0]
  K1(19,:) = [   0,  -4]
  K1(20,:) = [  -4, -12]
  K1(21,:) = [  12,   4]
  K1(22,:) = [   4,  12]
  K1(23,:) = [   0,   0]
  K1(24,:) = [   0,   0]
  K1(25,:) = [   0,   0]
  K1(26,:) = [   0,   0]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [   0,   0]
  K1(32,:) = [   0,   0]
  K1(33,:) = [   0,   0]
  K1(34,:) = [   0,   0]
  K1(35,:) = [   0,   0]
  K1(36,:) = [   0,   0]
  K1(37,:) = [   0,   0]
  K1(38,:) = [   0,   0]
  K1(39,:) = [   0,   0]
  K1(40,:) = [   0,   0]
  K1(41,:) = [   0,   0]
  K1(42,:) = [   0,   0]
  K1(43,:) = [   0,   0]
  K1(44,:) = [   0,   0]
  K1(45,:) = [   0,   0]
  K1(46,:) = [   0,   0]

  K2(1,:) = [ 9, 3]
  K2(2,:) = [ 3, 9]

  KL(1,:) = [ 9, 3]
  KL(2,:) = [ 3, 9]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+2*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppwajj_uuxuxdawx_1_/**/REALKIND



module ol_forced_parameters_ppwajj_uuxuxdawx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppwajj_uuxuxdawx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppwajj_uuxuxdawx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 96 ! number of helicity configurations
  integer(intkind2), save :: nhel = 96 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 96 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(96) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(282)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,30), wf6(6,20), wf8(8,48), wf12(12,58), wf16(16,38), wf24(24,54), wf96(96,184)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(25), c(47)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppwajj_uuxuxdawx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppwajj_uuxuxdawx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppwajj_uuxuxdawx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**2*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 2) = (2*CI*eQED**2*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 3) = (CI*eQED**2*gQCD**2)/(sqrt2*sw)
    f( 4) = (CI*countertermnorm*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 5) = (2*CI*countertermnorm*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 6) = (CI*countertermnorm*eQED**2*gQCD**4)/(sqrt2*sw)
    f( 7) = (CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 8) = (2*CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 9) = (CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/(sqrt2*sw)
    f(10) = (CI*countertermnorm*ctVqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(11) = (2*CI*countertermnorm*ctVqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(12) = (CI*countertermnorm*ctVqq*eQED**2*gQCD**4)/(sqrt2*sw)
    f(13) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(3._/**/REALKIND*sqrt2*sw)
    f(14) = (2*CI*eQED**2*gQCD**4*integralnorm*SwB)/(3._/**/REALKIND*sqrt2*sw)
    f(15) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw)
    f(16) = (eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw*6._/**/REALKIND)
    f(17) = (eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(18) = (eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw*2._/**/REALKIND)
    f(19) = (2*eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(20) = (eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw)
    f(21) = (eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(22) = (2*eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(23) = (eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw)
    f(24) = (4*eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(25) = (2*eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw)

  c = [ 9*CI*f(13), 27*CI*f(13), 9*CI*f(14), 27*CI*f(14), 9*CI*f(15), 27*CI*f(15), 18*f(16), 54*f(16), f(17), 3*f(17), 6*f(17) &
    , 8*f(17), 10*f(17), 18*f(17), 21*f(17), 24*f(17), 54*f(17), 18*f(18), 54*f(18), f(19), 3*f(19), 6*f(19), 8*f(19), 10*f(19) &
    , 18*f(19), 21*f(19), 24*f(19), 54*f(19), f(20), 3*f(20), 6*f(20), 8*f(20), 10*f(20), 18*f(20), 21*f(20), 24*f(20), 54*f(20) &
    , 3*f(21), 9*f(21), 3*f(22), 9*f(22), 3*f(23), 9*f(23), 3*f(24), 9*f(24), 3*f(25), 9*f(25) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,20))+L(6,20))
  den(3) = 1 /((L(5,40))+L(6,40))
  den(6) = 1 /((L(5,11))+L(6,11))
  den(9) = 1 /((L(5,36))+L(6,36))
  den(10) = 1 /((L(5,24))+L(6,24))
  den(13) = 1 /((L(5,7))+L(6,7))
  den(18) = 1 /((L(5,48) - MW2)+L(6,48))
  den(20) = 1 /((L(5,52))+L(6,52))
  den(23) = 1 /((L(5,5))+L(6,5))
  den(24) = 1 /((L(5,18))+L(6,18))
  den(27) = 1 /((L(5,13))+L(6,13))
  den(30) = 1 /((L(5,34))+L(6,34))
  den(38) = 1 /((L(5,50))+L(6,50))
  den(41) = 1 /((L(5,17))+L(6,17))
  den(42) = 1 /((L(5,21))+L(6,21))
  den(45) = 1 /((L(5,19))+L(6,19))
  den(49) = 1 /((L(5,42))+L(6,42))
  den(62) = 1 /((L(5,56))+L(6,56))
  den(80) = 1 /((L(5,44))+L(6,44))
  den(91) = 1 /((L(5,60))+L(6,60))
  den(95) = 1 /((L(5,43))+L(6,43))
  den(98) = 1 /((L(5,23))+L(6,23))
  den(110) = 1 /((L(5,27))+L(6,27))
  den(113) = 1 /((L(5,39))+L(6,39))
  den(133) = 1 /((L(5,58))+L(6,58))
  den(137) = 1 /((L(5,45))+L(6,45))
  den(151) = 1 /((L(5,29))+L(6,29))
  den(216) = 1 /((L(5,46))+L(6,46))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(11) = den(1)*den(9)
  den(12) = den(10)*den(11)
  den(14) = den(1)*den(13)
  den(15) = den(10)*den(14)
  den(16) = den(7)*den(9)
  den(17) = den(3)*den(14)
  den(19) = den(14)*den(18)
  den(21) = den(18)*den(20)
  den(22) = den(1)*den(21)
  den(25) = den(23)*den(24)
  den(26) = den(3)*den(25)
  den(28) = den(23)*den(27)
  den(29) = den(24)*den(28)
  den(31) = den(23)*den(30)
  den(32) = den(10)*den(31)
  den(33) = den(13)*den(23)
  den(34) = den(10)*den(33)
  den(35) = den(28)*den(30)
  den(36) = den(3)*den(33)
  den(37) = den(18)*den(33)
  den(39) = den(18)*den(38)
  den(40) = den(23)*den(39)
  den(43) = den(41)*den(42)
  den(44) = den(30)*den(43)
  den(46) = den(41)*den(45)
  den(47) = den(9)*den(46)
  den(48) = den(3)*den(46)
  den(50) = den(3)*den(49)
  den(51) = den(41)*den(50)
  den(52) = den(24)*den(45)
  den(53) = den(9)*den(52)
  den(54) = den(3)*den(52)
  den(55) = den(2)*den(42)
  den(56) = den(30)*den(55)
  den(57) = den(3)*den(55)
  den(58) = den(2)*den(20)
  den(59) = den(1)*den(58)
  den(60) = den(9)*den(20)
  den(61) = den(1)*den(60)
  den(63) = den(10)*den(62)
  den(64) = den(1)*den(63)
  den(65) = den(3)*den(62)
  den(66) = den(1)*den(65)
  den(67) = den(7)*den(18)
  den(68) = den(18)*den(62)
  den(69) = den(1)*den(68)
  den(70) = den(24)*den(38)
  den(71) = den(23)*den(70)
  den(72) = den(30)*den(38)
  den(73) = den(23)*den(72)
  den(74) = den(30)*den(49)
  den(75) = den(41)*den(74)
  den(76) = den(23)*den(63)
  den(77) = den(23)*den(65)
  den(78) = den(18)*den(28)
  den(79) = den(23)*den(68)
  den(81) = den(9)*den(80)
  den(82) = den(41)*den(81)
  den(83) = den(3)*den(43)
  den(84) = den(3)*den(80)
  den(85) = den(41)*den(84)
  den(86) = den(24)*den(81)
  den(87) = den(24)*den(84)
  den(88) = den(2)*den(74)
  den(89) = den(2)*den(50)
  den(90) = den(2)*den(3)
  den(92) = den(90)*den(91)
  den(93) = den(1)*den(92)
  den(94) = den(1)*den(3)
  den(96) = den(94)*den(95)
  den(97) = den(2)*den(96)
  den(99) = den(4)*den(98)
  den(100) = den(3)*den(99)
  den(101) = den(1)**2
  den(102) = den(58)*den(101)
  den(103) = den(2)**2
  den(104) = den(7)*den(103)
  den(105) = den(7)*den(58)
  den(106) = den(9)*den(10)
  den(107) = den(91)*den(106)
  den(108) = den(1)*den(107)
  den(109) = den(1)*den(10)
  den(111) = den(109)*den(110)
  den(112) = den(9)*den(111)
  den(114) = den(11)*den(113)
  den(115) = den(10)*den(114)
  den(116) = den(63)*den(101)
  den(117) = den(14)*den(63)
  den(118) = den(10)**2
  den(119) = den(14)*den(118)
  den(120) = den(60)*den(101)
  den(121) = den(9)**2
  den(122) = den(7)*den(121)
  den(123) = den(7)*den(60)
  den(124) = den(65)*den(101)
  den(125) = den(14)*den(65)
  den(126) = den(3)**2
  den(127) = den(14)*den(126)
  den(128) = den(68)*den(101)
  den(129) = den(21)*den(101)
  den(130) = den(14)*den(68)
  den(131) = den(7)*den(21)
  den(132) = den(3)*den(24)
  den(134) = den(132)*den(133)
  den(135) = den(23)*den(134)
  den(136) = den(3)*den(23)
  den(138) = den(136)*den(137)
  den(139) = den(24)*den(138)
  den(140) = den(25)*den(98)
  den(141) = den(3)*den(140)
  den(142) = den(23)**2
  den(143) = den(70)*den(142)
  den(144) = den(24)**2
  den(145) = den(28)*den(144)
  den(146) = den(28)*den(70)
  den(147) = den(10)*den(30)
  den(148) = den(133)*den(147)
  den(149) = den(23)*den(148)
  den(150) = den(10)*den(23)
  den(152) = den(150)*den(151)
  den(153) = den(30)*den(152)
  den(154) = den(31)*den(113)
  den(155) = den(10)*den(154)
  den(156) = den(63)*den(142)
  den(157) = den(33)*den(63)
  den(158) = den(33)*den(118)
  den(159) = den(72)*den(142)
  den(160) = den(30)**2
  den(161) = den(28)*den(160)
  den(162) = den(28)*den(72)
  den(163) = den(65)*den(142)
  den(164) = den(33)*den(65)
  den(165) = den(33)*den(126)
  den(166) = den(68)*den(142)
  den(167) = den(39)*den(142)
  den(168) = den(33)*den(68)
  den(169) = den(28)*den(39)
  den(170) = den(41)**2
  den(171) = den(74)*den(170)
  den(172) = den(43)*den(160)
  den(173) = den(43)*den(74)
  den(174) = den(81)*den(170)
  den(175) = den(46)*den(81)
  den(176) = den(46)*den(121)
  den(177) = den(84)*den(170)
  den(178) = den(50)*den(170)
  den(179) = den(46)*den(84)
  den(180) = den(43)*den(50)
  den(181) = den(43)*den(126)
  den(182) = den(46)*den(126)
  den(183) = den(81)*den(144)
  den(184) = den(52)*den(81)
  den(185) = den(52)*den(121)
  den(186) = den(84)*den(144)
  den(187) = den(52)*den(84)
  den(188) = den(52)*den(126)
  den(189) = den(74)*den(103)
  den(190) = den(55)*den(74)
  den(191) = den(55)*den(160)
  den(192) = den(50)*den(55)
  den(193) = den(50)*den(103)
  den(194) = den(55)*den(126)
  den(195) = den(14)*den(98)
  den(196) = den(14)*den(113)
  den(197) = den(7)*den(110)
  den(198) = den(7)*den(95)
  den(199) = den(33)*den(98)
  den(200) = den(33)*den(113)
  den(201) = den(28)*den(151)
  den(202) = den(28)*den(137)
  den(203) = den(46)*den(98)
  den(204) = den(46)*den(110)
  den(205) = den(43)*den(98)
  den(206) = den(43)*den(151)
  den(207) = den(52)*den(98)
  den(208) = den(52)*den(110)
  den(209) = den(70)*den(133)
  den(210) = den(55)*den(98)
  den(211) = den(55)*den(151)
  den(212) = den(58)*den(91)
  den(213) = den(63)*den(133)
  den(214) = den(63)*den(91)
  den(215) = den(74)*den(95)
  den(217) = den(74)*den(216)
  den(218) = den(72)*den(133)
  den(219) = den(81)*den(137)
  den(220) = den(81)*den(216)
  den(221) = den(60)*den(91)
  den(222) = den(50)*den(95)
  den(223) = den(84)*den(137)
  den(224) = den(50)*den(216)
  den(225) = den(84)*den(216)
  den(226) = den(65)*den(133)
  den(227) = den(65)*den(91)
  den(228) = den(39)*den(133)
  den(229) = den(68)*den(133)
  den(230) = den(21)*den(91)
  den(231) = den(68)*den(91)
  den(232) = den(1)*den(2)*den(3)
  den(233) = den(1)*den(9)*den(10)
  den(234) = den(1)*den(81)
  den(235) = den(1)*den(84)
  den(236) = den(1)*den(18)
  den(237) = den(3)*den(23)*den(24)
  den(238) = den(10)*den(23)*den(30)
  den(239) = den(23)*den(74)
  den(240) = den(23)*den(50)
  den(241) = den(18)*den(23)
  den(242) = den(30)*den(41)
  den(243) = den(9)*den(41)
  den(244) = den(3)*den(41)
  den(245) = den(9)*den(24)
  den(246) = den(2)*den(30)
  den(247) = den(2)*den(198)
  den(248) = den(1)*den(212)
  den(249) = den(10)*den(196)
  den(250) = den(1)*den(214)
  den(251) = den(9)*den(197)
  den(252) = den(1)*den(221)
  den(253) = den(3)*den(195)
  den(254) = den(1)*den(227)
  den(255) = den(1)*den(230)
  den(256) = den(1)*den(231)
  den(257) = den(24)*den(202)
  den(258) = den(23)*den(209)
  den(259) = den(10)*den(200)
  den(260) = den(23)*den(213)
  den(261) = den(30)*den(201)
  den(262) = den(23)*den(218)
  den(263) = den(3)*den(199)
  den(264) = den(23)*den(226)
  den(265) = den(23)*den(228)
  den(266) = den(23)*den(229)
  den(267) = den(30)*den(206)
  den(268) = den(41)*den(217)
  den(269) = den(9)*den(204)
  den(270) = den(41)*den(220)
  den(271) = den(3)*den(203)
  den(272) = den(3)*den(205)
  den(273) = den(41)*den(224)
  den(274) = den(41)*den(225)
  den(275) = den(9)*den(208)
  den(276) = den(24)*den(219)
  den(277) = den(3)*den(207)
  den(278) = den(24)*den(223)
  den(279) = den(30)*den(211)
  den(280) = den(2)*den(215)
  den(281) = den(3)*den(210)
  den(282) = den(2)*den(222)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppwajj_uuxuxdawx_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,184))
  allocate(M1helarray(2,hel_states))
  allocate(M1helarray_ct(2,hel_states))
  allocate(M0_col1_helarray(2,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(2,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppwajj_uuxuxdawx_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-up anti-up down gamma W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppwajj_uuxuxdawx_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppwajj_uuxuxdawx_1, only: &
    & external_perm_ppwajj_uuxuxdawx_1, &
    & external_perm_inv_ppwajj_uuxuxdawx_1, &
    & extcomb_perm_ppwajj_uuxuxdawx_1, &
    & average_factor_ppwajj_uuxuxdawx_1
  use ol_external_ppwajj_uuxuxdawx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppwajj_uuxuxdawx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppwajj_uuxuxdawx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppwajj_uuxuxdawx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(22)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(22)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(2), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,184))
  end if

  if (do_ct) call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppwajj_uuxuxdawx_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_Q(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rMW, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AV_Q(ntry, ex3(:), ex5(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_WQ_A(ntry, ex6(:), ex4(:), wf6(:,1), n3(:,3), t3x6(:,:,1))
  call prop_A_Q(ntry, wf4(:,2), 20, ZERO, 0_intkind1, wf4(:,3), n2(1))
  call prop_Q_A(ntry, wf6(:,1), 40, ZERO, 0_intkind1, wf6(:,2), n2(2))
  call vert_AV_Q(ntry, wf4(:,3), wf4(:,1), wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_VQ_A(ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,5), t3x8(:,:,1))
  call vert_AW_Q(ntry, wf4(:,3), ex6(:), wf12(:,1), n3(:,6), t3x12(:,:,1))
  call prop_Q_A(ntry, wf8(:,1), 11, ZERO, 0_intkind1, wf8(:,2), n2(3))
  call vert_AW_Q(ntry, ex3(:), ex6(:), wf6(:,3), n3(:,7), t3x6(:,:,2))
  call vert_VQ_A(ntry, ex5(:), ex4(:), wf4(:,4), n3(:,8), t3x4(:,:,3))
  call prop_A_Q(ntry, wf6(:,3), 36, ZERO, 0_intkind1, wf6(:,4), n2(4))
  call prop_Q_A(ntry, wf4(:,4), 24, ZERO, 0_intkind1, wf4(:,5), n2(5))
  call vert_AV_Q(ntry, wf6(:,4), wf4(:,1), wf24(:,1), n3(:,9), t3x24(:,:,1))
  call vert_AV_Q(ntry, ex3(:), wf4(:,1), wf8(:,3), n3(:,10), t3x8(:,:,2))
  call vert_WQ_A(ntry, ex6(:), wf4(:,5), wf12(:,2), n3(:,11), t3x12(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 7, ZERO, 0_intkind1, wf8(:,4), n2(6))
  call vert_AV_Q(ntry, wf6(:,4), ex5(:), wf12(:,3), n3(:,12), t3x12(:,:,3))
  call vert_VQ_A(ntry, ex5(:), wf6(:,2), wf12(:,4), n3(:,13), t3x12(:,:,4))
  call vert_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf6(:,5), n3(:,14), t3x6(:,:,3))
  call prop_W_W(ntry, wf6(:,5), 48, MW, 1_intkind1, wf6(:,6), n2(7))
  call vert_WQ_A(ntry, wf6(:,6), ex4(:), wf12(:,5), n3(:,15), t3x12(:,:,5))
  call vert_AW_Q(ntry, ex3(:), wf6(:,6), wf12(:,6), n3(:,16), t3x12(:,:,6))
  call prop_A_Q(ntry, wf12(:,6), 52, ZERO, 0_intkind1, wf12(:,7), n2(8))
  call vert_QA_V(ntry, ex1(:), ex3(:), wf4(:,6), n3(:,17), t3x4(:,:,4))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,7), n3(:,18), t3x4(:,:,5))
  call prop_A_Q(ntry, wf4(:,7), 18, ZERO, 0_intkind1, wf4(:,8), n2(9))
  call vert_AV_Q(ntry, wf4(:,8), wf4(:,6), wf16(:,2), n3(:,19), t3x16(:,:,2))
  call vert_VQ_A(ntry, wf4(:,6), ex4(:), wf8(:,5), n3(:,20), t3x8(:,:,3))
  call vert_AW_Q(ntry, wf4(:,8), ex6(:), wf12(:,8), n3(:,21), t3x12(:,:,7))
  call prop_Q_A(ntry, wf8(:,5), 13, ZERO, 0_intkind1, wf8(:,6), n2(10))
  call vert_AW_Q(ntry, ex2(:), ex6(:), wf6(:,7), n3(:,22), t3x6(:,:,4))
  call prop_A_Q(ntry, wf6(:,7), 34, ZERO, 0_intkind1, wf6(:,8), n2(11))
  call vert_AV_Q(ntry, wf6(:,8), wf4(:,6), wf24(:,2), n3(:,23), t3x24(:,:,2))
  call vert_AV_Q(ntry, ex2(:), wf4(:,6), wf8(:,7), n3(:,24), t3x8(:,:,4))
  call prop_A_Q(ntry, wf8(:,7), 7, ZERO, 0_intkind1, wf8(:,8), n2(12))
  call vert_AV_Q(ntry, wf6(:,8), ex5(:), wf12(:,9), n3(:,25), t3x12(:,:,8))
  call vert_AW_Q(ntry, ex2(:), wf6(:,6), wf12(:,10), n3(:,26), t3x12(:,:,9))
  call prop_A_Q(ntry, wf12(:,10), 50, ZERO, 0_intkind1, wf12(:,11), n2(13))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,9), n3(:,27), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,9), 17, ZERO, 0_intkind1, wf4(:,10), n2(14))
  call vert_QA_V(ntry, wf4(:,10), ex3(:), wf8(:,9), n3(:,28), t3x8(:,:,5))
  call vert_QA_V(ntry, ex4(:), wf6(:,8), wf12(:,12), n3(:,29), t3x12(:,:,10))
  call vert_QA_V(ntry, wf4(:,10), ex2(:), wf8(:,10), n3(:,30), t3x8(:,:,6))
  call vert_QA_V(ntry, ex4(:), wf6(:,4), wf12(:,13), n3(:,31), t3x12(:,:,11))
  call vert_QA_V(ntry, wf6(:,2), ex3(:), wf12(:,14), n3(:,32), t3x12(:,:,12))
  call vert_QA_V(ntry, wf6(:,2), ex2(:), wf12(:,15), n3(:,33), t3x12(:,:,13))
  call vert_QA_V(ntry, ex1(:), wf4(:,8), wf8(:,11), n3(:,34), t3x8(:,:,7))
  call vert_QA_V(ntry, ex1(:), wf4(:,3), wf8(:,12), n3(:,35), t3x8(:,:,8))
  call counter_AV_Q(ntry, wf4(:,3), wf4(:,1), wf16(:,3), n3(:,36), t3x16(:,:,3))
  call counter_AW_Q(ntry, wf4(:,3), ex6(:), wf12(:,16), n3(:,37), t3x12(:,:,14))
  call counter_AV_Q(ntry, wf6(:,4), wf4(:,1), wf24(:,3), n3(:,38), t3x24(:,:,3))
  call counter_WQ_A(ntry, ex6(:), wf4(:,5), wf12(:,17), n3(:,39), t3x12(:,:,15))
  call counter_AV_Q(ntry, wf6(:,4), ex5(:), wf12(:,18), n3(:,40), t3x12(:,:,16))
  call counter_VQ_A(ntry, ex5(:), wf6(:,2), wf12(:,19), n3(:,41), t3x12(:,:,17))
  call counter_VQ_A(ntry, wf4(:,1), ex4(:), wf8(:,13), n3(:,42), t3x8(:,:,9))
  call prop_A_Q(ntry, wf12(:,1), 52, ZERO, 0_intkind1, wf12(:,20), n2(15))
  call counter_WQ_A(ntry, ex6(:), ex4(:), wf6(:,9), n3(:,43), t3x6(:,:,5))
  call prop_Q_A(ntry, wf6(:,9), 40, ZERO, 0_intkind1, wf6(:,10), n2(16))
  call prop_A_Q(ntry, wf12(:,3), 52, ZERO, 0_intkind1, wf12(:,21), n2(17))
  call counter_WQ_A(ntry, wf6(:,6), ex4(:), wf12(:,22), n3(:,44), t3x12(:,:,18))
  call vert_VQ_A(ntry, ex5(:), wf6(:,10), wf12(:,23), n3(:,45), t3x12(:,:,19))
  call counter_VQ_A(ntry, ex5(:), ex4(:), wf4(:,11), n3(:,46), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,11), 24, ZERO, 0_intkind1, wf4(:,12), n2(18))
  call vert_WQ_A(ntry, ex6(:), wf4(:,12), wf12(:,24), n3(:,47), t3x12(:,:,20))
  call counter_AV_Q(ntry, ex3(:), wf4(:,1), wf8(:,14), n3(:,48), t3x8(:,:,10))
  call prop_Q_A(ntry, wf12(:,2), 56, ZERO, 0_intkind1, wf12(:,25), n2(19))
  call counter_AW_Q(ntry, ex3(:), ex6(:), wf6(:,11), n3(:,49), t3x6(:,:,6))
  call prop_A_Q(ntry, wf6(:,11), 36, ZERO, 0_intkind1, wf6(:,12), n2(20))
  call vert_AV_Q(ntry, wf6(:,12), wf4(:,1), wf24(:,4), n3(:,50), t3x24(:,:,4))
  call prop_Q_A(ntry, wf12(:,4), 56, ZERO, 0_intkind1, wf12(:,26), n2(21))
  call counter_AW_Q(ntry, ex3(:), wf6(:,6), wf12(:,27), n3(:,51), t3x12(:,:,21))
  call prop_Q_A(ntry, wf12(:,5), 56, ZERO, 0_intkind1, wf12(:,28), n2(22))
  call vert_AV_Q(ntry, wf6(:,12), ex5(:), wf12(:,29), n3(:,52), t3x12(:,:,22))
  call counter_AV_Q(ntry, ex3(:), ex5(:), wf4(:,13), n3(:,53), t3x4(:,:,8))
  call prop_A_Q(ntry, wf4(:,13), 20, ZERO, 0_intkind1, wf4(:,14), n2(23))
  call vert_AV_Q(ntry, wf4(:,14), wf4(:,1), wf16(:,4), n3(:,54), t3x16(:,:,4))
  call vert_AW_Q(ntry, wf4(:,14), ex6(:), wf12(:,30), n3(:,55), t3x12(:,:,23))
  call counter_AV_Q(ntry, wf4(:,8), wf4(:,6), wf16(:,5), n3(:,56), t3x16(:,:,5))
  call counter_AW_Q(ntry, wf4(:,8), ex6(:), wf12(:,31), n3(:,57), t3x12(:,:,24))
  call counter_AV_Q(ntry, wf6(:,8), wf4(:,6), wf24(:,5), n3(:,58), t3x24(:,:,5))
  call counter_AV_Q(ntry, wf6(:,8), ex5(:), wf12(:,32), n3(:,59), t3x12(:,:,25))
  call counter_VQ_A(ntry, wf4(:,6), ex4(:), wf8(:,15), n3(:,60), t3x8(:,:,11))
  call prop_A_Q(ntry, wf12(:,8), 50, ZERO, 0_intkind1, wf12(:,33), n2(24))
  call prop_A_Q(ntry, wf12(:,9), 50, ZERO, 0_intkind1, wf12(:,34), n2(25))
  call counter_QA_V(ntry, ex4(:), wf6(:,8), wf12(:,35), n3(:,61), t3x12(:,:,26))
  call counter_QA_V(ntry, ex4(:), wf6(:,4), wf12(:,36), n3(:,62), t3x12(:,:,27))
  call vert_QA_V(ntry, wf6(:,10), ex3(:), wf12(:,37), n3(:,63), t3x12(:,:,28))
  call vert_QA_V(ntry, wf6(:,10), ex2(:), wf12(:,38), n3(:,64), t3x12(:,:,29))
  call counter_QA_V(ntry, wf4(:,10), ex3(:), wf8(:,16), n3(:,65), t3x8(:,:,12))
  call counter_QA_V(ntry, wf6(:,2), ex3(:), wf12(:,39), n3(:,66), t3x12(:,:,30))
  call vert_QA_V(ntry, ex4(:), wf6(:,12), wf12(:,40), n3(:,67), t3x12(:,:,31))
  call vert_QA_V(ntry, ex1(:), wf4(:,14), wf8(:,17), n3(:,68), t3x8(:,:,13))
  call counter_AV_Q(ntry, ex2(:), wf4(:,6), wf8(:,18), n3(:,69), t3x8(:,:,14))
  call counter_AW_Q(ntry, ex2(:), ex6(:), wf6(:,13), n3(:,70), t3x6(:,:,7))
  call prop_A_Q(ntry, wf6(:,13), 34, ZERO, 0_intkind1, wf6(:,14), n2(26))
  call vert_AV_Q(ntry, wf6(:,14), wf4(:,6), wf24(:,6), n3(:,71), t3x24(:,:,6))
  call counter_AW_Q(ntry, ex2(:), wf6(:,6), wf12(:,41), n3(:,72), t3x12(:,:,32))
  call vert_AV_Q(ntry, wf6(:,14), ex5(:), wf12(:,42), n3(:,73), t3x12(:,:,33))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,15), n3(:,74), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,15), 18, ZERO, 0_intkind1, wf4(:,16), n2(27))
  call vert_AV_Q(ntry, wf4(:,16), wf4(:,6), wf16(:,6), n3(:,75), t3x16(:,:,6))
  call vert_AW_Q(ntry, wf4(:,16), ex6(:), wf12(:,43), n3(:,76), t3x12(:,:,34))
  call counter_QA_V(ntry, wf4(:,10), ex2(:), wf8(:,19), n3(:,77), t3x8(:,:,15))
  call counter_QA_V(ntry, wf6(:,2), ex2(:), wf12(:,44), n3(:,78), t3x12(:,:,35))
  call vert_QA_V(ntry, ex4(:), wf6(:,14), wf12(:,45), n3(:,79), t3x12(:,:,36))
  call vert_QA_V(ntry, ex1(:), wf4(:,16), wf8(:,20), n3(:,80), t3x8(:,:,16))
  call counter_QA_V(ntry, ex1(:), wf4(:,8), wf8(:,21), n3(:,81), t3x8(:,:,17))
  call counter_QA_V(ntry, ex1(:), wf4(:,3), wf8(:,22), n3(:,82), t3x8(:,:,18))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,17), n3(:,83), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,17), 17, ZERO, 0_intkind1, wf4(:,18), n2(28))
  call vert_QA_V(ntry, wf4(:,18), ex3(:), wf8(:,23), n3(:,84), t3x8(:,:,19))
  call vert_QA_V(ntry, wf4(:,18), ex2(:), wf8(:,24), n3(:,85), t3x8(:,:,20))
  call counter_QA_V(ntry, ex1(:), ex3(:), wf4(:,19), n3(:,86), t3x4(:,:,11))
  call vert_AV_Q(ntry, wf4(:,8), wf4(:,19), wf16(:,7), n3(:,87), t3x16(:,:,7))
  call vert_VQ_A(ntry, wf4(:,19), ex4(:), wf8(:,25), n3(:,88), t3x8(:,:,21))
  call prop_Q_A(ntry, wf8(:,25), 13, ZERO, 0_intkind1, wf8(:,26), n2(29))
  call vert_AV_Q(ntry, wf6(:,8), wf4(:,19), wf24(:,7), n3(:,89), t3x24(:,:,7))
  call vert_AV_Q(ntry, ex2(:), wf4(:,19), wf8(:,27), n3(:,90), t3x8(:,:,22))
  call prop_A_Q(ntry, wf8(:,27), 7, ZERO, 0_intkind1, wf8(:,28), n2(30))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,20), n3(:,91), t3x4(:,:,12))
  call vert_AV_Q(ntry, wf4(:,3), wf4(:,20), wf16(:,8), n3(:,92), t3x16(:,:,8))
  call vert_VQ_A(ntry, wf4(:,20), ex4(:), wf8(:,29), n3(:,93), t3x8(:,:,23))
  call prop_Q_A(ntry, wf8(:,29), 11, ZERO, 0_intkind1, wf8(:,30), n2(31))
  call vert_AV_Q(ntry, wf6(:,4), wf4(:,20), wf24(:,8), n3(:,94), t3x24(:,:,8))
  call vert_AV_Q(ntry, ex3(:), wf4(:,20), wf8(:,31), n3(:,95), t3x8(:,:,24))
  call prop_A_Q(ntry, wf8(:,31), 7, ZERO, 0_intkind1, wf8(:,32), n2(32))
  call vert_QA_V(ntry, wf6(:,2), wf4(:,3), wf24(:,9), n3(:,96), t3x24(:,:,9))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 3, wf4(:,21), n2(33))
  call vert_VQ_A(ntry, wf4(:,1), wf6(:,2), wf24(:,10), n3(:,97), t3x24(:,:,10))
  call counter_A_Q(ctqq,2,ntry, wf4(:,3), 20, wf4(:,22), n2(34))
  call prop_Q_A(ntry, wf24(:,10), 43, ZERO, 0_intkind1, wf24(:,11), n2(35))
  call counter_Q_A(ctqq,2,ntry, wf6(:,2), 40, wf6(:,15), n2(36))
  call prop_A_Q(ntry, wf16(:,1), 23, ZERO, 0_intkind1, wf16(:,9), n2(37))
  call vert_VQ_A(ntry, wf4(:,21), ex4(:), wf8(:,33), n3(:,98), t3x8(:,:,25))
  call prop_A_Q(ntry, wf4(:,22), 20, ZERO, 0_intkind1, wf4(:,23), n2(38))
  call vert_AW_Q(ntry, wf4(:,23), ex6(:), wf12(:,46), n3(:,99), t3x12(:,:,37))
  call counter_Q_A(ctqq,1,ntry, wf8(:,2), 11, wf8(:,34), n2(39))
  call vert_QA_V(ntry, wf4(:,5), wf6(:,4), wf24(:,12), n3(:,100), t3x24(:,:,11))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,5), wf16(:,10), n3(:,101), t3x16(:,:,9))
  call counter_A_Q(ctqq,1,ntry, wf6(:,4), 36, wf6(:,16), n2(40))
  call prop_Q_A(ntry, wf16(:,10), 27, ZERO, 0_intkind1, wf16(:,11), n2(41))
  call counter_Q_A(ctqq,1,ntry, wf4(:,5), 24, wf4(:,24), n2(42))
  call prop_A_Q(ntry, wf24(:,1), 39, ZERO, 0_intkind1, wf24(:,13), n2(43))
  call vert_AV_Q(ntry, ex3(:), wf4(:,21), wf8(:,35), n3(:,102), t3x8(:,:,26))
  call counter_A_Q(ctqq,2,ntry, wf8(:,4), 7, wf8(:,36), n2(44))
  call prop_Q_A(ntry, wf4(:,24), 24, ZERO, 0_intkind1, wf4(:,25), n2(45))
  call vert_WQ_A(ntry, ex6(:), wf4(:,25), wf12(:,47), n3(:,103), t3x12(:,:,38))
  call prop_A_Q(ntry, wf6(:,16), 36, ZERO, 0_intkind1, wf6(:,17), n2(46))
  call vert_AV_Q(ntry, wf6(:,17), ex5(:), wf12(:,48), n3(:,104), t3x12(:,:,39))
  call prop_Q_A(ntry, wf6(:,15), 40, ZERO, 0_intkind1, wf6(:,18), n2(47))
  call vert_VQ_A(ntry, ex5(:), wf6(:,18), wf12(:,49), n3(:,105), t3x12(:,:,40))
  call counter_A_Q(ctqq,1,ntry, wf12(:,7), 52, wf12(:,50), n2(48))
  call vert_QA_V(ntry, wf6(:,2), wf4(:,8), wf24(:,14), n3(:,106), t3x24(:,:,12))
  call counter_V_V(ctGG,21,ntry, wf4(:,6), 5, wf4(:,26), n2(49))
  call vert_VQ_A(ntry, wf4(:,6), wf6(:,2), wf24(:,15), n3(:,107), t3x24(:,:,13))
  call counter_A_Q(ctqq,2,ntry, wf4(:,8), 18, wf4(:,27), n2(50))
  call prop_Q_A(ntry, wf24(:,15), 45, ZERO, 0_intkind1, wf24(:,16), n2(51))
  call prop_A_Q(ntry, wf16(:,2), 23, ZERO, 0_intkind1, wf16(:,12), n2(52))
  call vert_VQ_A(ntry, wf4(:,26), ex4(:), wf8(:,37), n3(:,108), t3x8(:,:,27))
  call prop_A_Q(ntry, wf4(:,27), 18, ZERO, 0_intkind1, wf4(:,28), n2(53))
  call vert_AW_Q(ntry, wf4(:,28), ex6(:), wf12(:,51), n3(:,109), t3x12(:,:,41))
  call counter_Q_A(ctqq,1,ntry, wf8(:,6), 13, wf8(:,38), n2(54))
  call vert_QA_V(ntry, wf4(:,5), wf6(:,8), wf24(:,17), n3(:,110), t3x24(:,:,14))
  call vert_VQ_A(ntry, wf4(:,6), wf4(:,5), wf16(:,13), n3(:,111), t3x16(:,:,10))
  call counter_A_Q(ctqq,1,ntry, wf6(:,8), 34, wf6(:,19), n2(55))
  call prop_Q_A(ntry, wf16(:,13), 29, ZERO, 0_intkind1, wf16(:,14), n2(56))
  call prop_A_Q(ntry, wf24(:,2), 39, ZERO, 0_intkind1, wf24(:,18), n2(57))
  call vert_AV_Q(ntry, ex2(:), wf4(:,26), wf8(:,39), n3(:,112), t3x8(:,:,28))
  call counter_A_Q(ctqq,2,ntry, wf8(:,8), 7, wf8(:,40), n2(58))
  call prop_A_Q(ntry, wf6(:,19), 34, ZERO, 0_intkind1, wf6(:,20), n2(59))
  call vert_AV_Q(ntry, wf6(:,20), ex5(:), wf12(:,52), n3(:,113), t3x12(:,:,42))
  call counter_A_Q(ctqq,1,ntry, wf12(:,11), 50, wf12(:,53), n2(60))
  call counter_Q_A(ctqq,2,ntry, wf4(:,10), 17, wf4(:,29), n2(61))
  call prop_Q_A(ntry, wf4(:,29), 17, ZERO, 0_intkind1, wf4(:,30), n2(62))
  call vert_QA_V(ntry, wf4(:,30), ex3(:), wf8(:,41), n3(:,114), t3x8(:,:,29))
  call vert_QA_V(ntry, ex4(:), wf6(:,20), wf12(:,54), n3(:,115), t3x12(:,:,43))
  call counter_V_V(ctGG,21,ntry, wf8(:,9), 21, wf8(:,42), n2(63))
  call vert_QA_V(ntry, wf4(:,30), ex2(:), wf8(:,43), n3(:,116), t3x8(:,:,30))
  call counter_V_V(ctGG,21,ntry, wf8(:,10), 19, wf8(:,44), n2(64))
  call vert_QA_V(ntry, ex4(:), wf6(:,17), wf12(:,55), n3(:,117), t3x12(:,:,44))
  call counter_V_V(ctGG,21,ntry, wf12(:,15), 42, wf12(:,56), n2(65))
  call vert_QA_V(ntry, wf6(:,18), ex2(:), wf12(:,57), n3(:,118), t3x12(:,:,45))
  call vert_QA_V(ntry, wf6(:,18), ex3(:), wf12(:,58), n3(:,119), t3x12(:,:,46))
  call vert_QA_V(ntry, ex1(:), wf4(:,28), wf8(:,45), n3(:,120), t3x8(:,:,31))
  call counter_V_V(ctGG,21,ntry, wf8(:,11), 19, wf8(:,46), n2(66))
  call vert_QA_V(ntry, ex1(:), wf4(:,23), wf8(:,47), n3(:,121), t3x8(:,:,32))
  call counter_V_V(ctGG,21,ntry, wf8(:,12), 21, wf8(:,48), n2(67))
  call vert_AV_Q(ntry, wf8(:,4), ex5(:), wf16(:,15), n3(:,122), t3x16(:,:,11))
  call prop_A_Q(ntry, wf16(:,15), 23, ZERO, 0_intkind1, wf16(:,16), n2(68))
  call vert_AW_Q(ntry, wf8(:,4), ex6(:), wf24(:,19), n3(:,123), t3x24(:,:,15))
  call prop_A_Q(ntry, wf24(:,19), 39, ZERO, 0_intkind1, wf24(:,20), n2(69))
  call vert_VQ_A(ntry, ex5(:), wf8(:,2), wf16(:,17), n3(:,124), t3x16(:,:,12))
  call prop_Q_A(ntry, wf16(:,17), 27, ZERO, 0_intkind1, wf16(:,18), n2(70))
  call vert_WQ_A(ntry, ex6(:), wf8(:,2), wf24(:,21), n3(:,125), t3x24(:,:,16))
  call prop_Q_A(ntry, wf24(:,21), 43, ZERO, 0_intkind1, wf24(:,22), n2(71))
  call vert_AV_Q(ntry, wf8(:,8), ex5(:), wf16(:,19), n3(:,126), t3x16(:,:,13))
  call prop_A_Q(ntry, wf16(:,19), 23, ZERO, 0_intkind1, wf16(:,20), n2(72))
  call vert_AW_Q(ntry, wf8(:,8), ex6(:), wf24(:,23), n3(:,127), t3x24(:,:,17))
  call prop_A_Q(ntry, wf24(:,23), 39, ZERO, 0_intkind1, wf24(:,24), n2(73))
  call vert_VQ_A(ntry, ex5(:), wf8(:,6), wf16(:,21), n3(:,128), t3x16(:,:,14))
  call prop_Q_A(ntry, wf16(:,21), 29, ZERO, 0_intkind1, wf16(:,22), n2(74))
  call vert_WQ_A(ntry, ex6(:), wf8(:,6), wf24(:,25), n3(:,129), t3x24(:,:,18))
  call prop_Q_A(ntry, wf24(:,25), 45, ZERO, 0_intkind1, wf24(:,26), n2(75))
  call vert_AV_Q(ntry, ex3(:), wf8(:,10), wf16(:,23), n3(:,130), t3x16(:,:,15))
  call prop_A_Q(ntry, wf16(:,23), 23, ZERO, 0_intkind1, wf16(:,24), n2(76))
  call vert_VQ_A(ntry, wf8(:,10), ex4(:), wf16(:,25), n3(:,131), t3x16(:,:,16))
  call prop_Q_A(ntry, wf16(:,25), 27, ZERO, 0_intkind1, wf16(:,26), n2(77))
  call vert_AV_Q(ntry, ex2(:), wf8(:,9), wf16(:,27), n3(:,132), t3x16(:,:,17))
  call prop_A_Q(ntry, wf16(:,27), 23, ZERO, 0_intkind1, wf16(:,28), n2(78))
  call vert_VQ_A(ntry, wf8(:,9), ex4(:), wf16(:,29), n3(:,133), t3x16(:,:,18))
  call prop_Q_A(ntry, wf16(:,29), 29, ZERO, 0_intkind1, wf16(:,30), n2(79))
  call vert_AV_Q(ntry, ex3(:), wf8(:,11), wf16(:,31), n3(:,134), t3x16(:,:,19))
  call prop_A_Q(ntry, wf16(:,31), 23, ZERO, 0_intkind1, wf16(:,32), n2(80))
  call vert_VQ_A(ntry, wf8(:,11), ex4(:), wf16(:,33), n3(:,135), t3x16(:,:,20))
  call prop_Q_A(ntry, wf16(:,33), 27, ZERO, 0_intkind1, wf16(:,34), n2(81))
  call vert_QA_V(ntry, ex4(:), wf12(:,33), wf24(:,27), n3(:,136), t3x24(:,:,19))
  call vert_AV_Q(ntry, ex2(:), wf8(:,12), wf16(:,35), n3(:,137), t3x16(:,:,21))
  call prop_A_Q(ntry, wf16(:,35), 23, ZERO, 0_intkind1, wf16(:,36), n2(82))
  call vert_VQ_A(ntry, wf8(:,12), ex4(:), wf16(:,37), n3(:,138), t3x16(:,:,22))
  call prop_Q_A(ntry, wf16(:,37), 29, ZERO, 0_intkind1, wf16(:,38), n2(83))
  call vert_QA_V(ntry, ex4(:), wf12(:,20), wf24(:,28), n3(:,139), t3x24(:,:,20))
  call vert_QA_V(ntry, wf12(:,25), ex2(:), wf24(:,29), n3(:,140), t3x24(:,:,21))
  call vert_QA_V(ntry, wf12(:,25), ex3(:), wf24(:,30), n3(:,141), t3x24(:,:,22))
  call vert_VQ_A(ntry, wf12(:,12), ex1(:), wf24(:,31), n3(:,142), t3x24(:,:,23))
  call prop_Q_A(ntry, wf24(:,31), 43, ZERO, 0_intkind1, wf24(:,32), n2(84))
  call vert_AV_Q(ntry, ex3(:), wf12(:,12), wf24(:,33), n3(:,143), t3x24(:,:,24))
  call prop_A_Q(ntry, wf24(:,33), 46, ZERO, 0_intkind1, wf24(:,34), n2(85))
  call vert_QA_V(ntry, ex4(:), wf12(:,34), wf24(:,35), n3(:,144), t3x24(:,:,25))
  call vert_VQ_A(ntry, wf12(:,13), ex1(:), wf24(:,36), n3(:,145), t3x24(:,:,26))
  call prop_Q_A(ntry, wf24(:,36), 45, ZERO, 0_intkind1, wf24(:,37), n2(86))
  call vert_AV_Q(ntry, ex2(:), wf12(:,13), wf24(:,38), n3(:,146), t3x24(:,:,27))
  call prop_A_Q(ntry, wf24(:,38), 46, ZERO, 0_intkind1, wf24(:,39), n2(87))
  call vert_QA_V(ntry, ex4(:), wf12(:,21), wf24(:,40), n3(:,147), t3x24(:,:,28))
  call vert_VQ_A(ntry, wf12(:,15), ex1(:), wf24(:,41), n3(:,148), t3x24(:,:,29))
  call prop_Q_A(ntry, wf24(:,41), 43, ZERO, 0_intkind1, wf24(:,42), n2(88))
  call vert_VQ_A(ntry, wf12(:,14), ex1(:), wf24(:,43), n3(:,149), t3x24(:,:,30))
  call prop_Q_A(ntry, wf24(:,43), 45, ZERO, 0_intkind1, wf24(:,44), n2(89))
  call vert_AV_Q(ntry, ex3(:), wf12(:,15), wf24(:,45), n3(:,150), t3x24(:,:,31))
  call prop_A_Q(ntry, wf24(:,45), 46, ZERO, 0_intkind1, wf24(:,46), n2(90))
  call vert_AV_Q(ntry, ex2(:), wf12(:,14), wf24(:,47), n3(:,151), t3x24(:,:,32))
  call prop_A_Q(ntry, wf24(:,47), 46, ZERO, 0_intkind1, wf24(:,48), n2(91))
  call vert_QA_V(ntry, wf12(:,26), ex2(:), wf24(:,49), n3(:,152), t3x24(:,:,33))
  call vert_QA_V(ntry, wf12(:,26), ex3(:), wf24(:,50), n3(:,153), t3x24(:,:,34))
  call vert_QA_V(ntry, ex4(:), wf12(:,11), wf24(:,51), n3(:,154), t3x24(:,:,35))
  call vert_QA_V(ntry, wf12(:,28), ex2(:), wf24(:,52), n3(:,155), t3x24(:,:,36))
  call vert_QA_V(ntry, ex4(:), wf12(:,7), wf24(:,53), n3(:,156), t3x24(:,:,37))
  call vert_QA_V(ntry, wf12(:,28), ex3(:), wf24(:,54), n3(:,157), t3x24(:,:,38))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 6 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 9
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 3
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf6(:,2), wf16(:,1), A(:,1), n3(:,158), t3x96(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,1), wf8(:,2), A(:,2), n3(:,159), t3x96(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,1), A(:,3), n3(:,160), t3x96(:,:,3), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,4), A(:,4), n3(:,161), t3x96(:,:,4), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,3), A(:,5), n3(:,162), t3x96(:,:,5), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,4), A(:,6), n3(:,163), t3x96(:,:,6), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,5), A(:,7), n3(:,164), t3x96(:,:,7), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,1), wf12(:,7), A(:,8), n3(:,165), t3x96(:,:,8), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,2), wf16(:,2), A(:,9), n3(:,166), t3x96(:,:,9), nhel, den(26))
    call Hcont_QA(nsync, wf12(:,8), wf8(:,6), A(:,10), n3(:,167), t3x96(:,:,10), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,2), A(:,11), n3(:,168), t3x96(:,:,11), nhel, den(32))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,8), A(:,12), n3(:,169), t3x96(:,:,12), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,9), A(:,13), n3(:,170), t3x96(:,:,13), nhel, den(35))
    call Hcont_QA(nsync, wf12(:,4), wf8(:,8), A(:,14), n3(:,171), t3x96(:,:,14), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,8), A(:,15), n3(:,172), t3x96(:,:,15), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,11), A(:,16), n3(:,173), t3x96(:,:,16), nhel, den(40))
    call Hcont_VV(nsync, wf8(:,9), wf12(:,12), A(:,17), n3(:,174), t3x96(:,:,17), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,13), A(:,18), n3(:,175), t3x96(:,:,18), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,14), A(:,19), n3(:,176), t3x96(:,:,19), nhel, den(48))
    call Hcont_VV(nsync, wf8(:,9), wf12(:,15), A(:,20), n3(:,177), t3x96(:,:,20), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,11), A(:,21), n3(:,178), t3x96(:,:,21), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,11), A(:,22), n3(:,179), t3x96(:,:,22), nhel, den(54))
    call Hcont_VV(nsync, wf12(:,12), wf8(:,12), A(:,23), n3(:,180), t3x96(:,:,23), nhel, den(56))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,12), A(:,24), n3(:,181), t3x96(:,:,24), nhel, den(57))

    call Hcont_QA(nsync, wf6(:,2), wf16(:,3), A(:,25), n3(:,182), t3x96(:,:,25), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,16), A(:,26), n3(:,183), t3x96(:,:,26), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,3), A(:,27), n3(:,184), t3x96(:,:,27), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,17), A(:,28), n3(:,185), t3x96(:,:,28), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,18), A(:,29), n3(:,186), t3x96(:,:,29), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,19), A(:,30), n3(:,187), t3x96(:,:,30), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,20), A(:,31), n3(:,188), t3x96(:,:,31), nhel, den(59))
    call Hcont_QA(nsync, wf16(:,1), wf6(:,10), A(:,32), n3(:,189), t3x96(:,:,32), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,13), wf12(:,21), A(:,33), n3(:,190), t3x96(:,:,33), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,22), A(:,34), n3(:,191), t3x96(:,:,34), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,13), A(:,35), n3(:,192), t3x96(:,:,35), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,23), A(:,36), n3(:,193), t3x96(:,:,36), nhel, den(17))
    call Hcont_QA(nsync, wf24(:,1), wf4(:,12), A(:,37), n3(:,194), t3x96(:,:,37), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,24), A(:,38), n3(:,195), t3x96(:,:,38), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,25), A(:,39), n3(:,196), t3x96(:,:,39), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,4), A(:,40), n3(:,197), t3x96(:,:,40), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,26), A(:,41), n3(:,198), t3x96(:,:,41), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,27), A(:,42), n3(:,199), t3x96(:,:,42), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,28), A(:,43), n3(:,200), t3x96(:,:,43), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,29), A(:,44), n3(:,201), t3x96(:,:,44), nhel, den(16))
    call Hcont_QA(nsync, wf6(:,2), wf16(:,4), A(:,45), n3(:,202), t3x96(:,:,45), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,30), A(:,46), n3(:,203), t3x96(:,:,46), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf16(:,5), A(:,47), n3(:,204), t3x96(:,:,47), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,31), A(:,48), n3(:,205), t3x96(:,:,48), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,5), A(:,49), n3(:,206), t3x96(:,:,49), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,17), A(:,50), n3(:,207), t3x96(:,:,50), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,32), A(:,51), n3(:,208), t3x96(:,:,51), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,19), A(:,52), n3(:,209), t3x96(:,:,52), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,15), wf12(:,33), A(:,53), n3(:,210), t3x96(:,:,53), nhel, den(71))
    call Hcont_QA(nsync, wf16(:,2), wf6(:,10), A(:,54), n3(:,211), t3x96(:,:,54), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,15), wf12(:,34), A(:,55), n3(:,212), t3x96(:,:,55), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,22), A(:,56), n3(:,213), t3x96(:,:,56), nhel, den(37))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,15), A(:,57), n3(:,214), t3x96(:,:,57), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,23), A(:,58), n3(:,215), t3x96(:,:,58), nhel, den(36))
    call Hcont_QA(nsync, wf24(:,2), wf4(:,12), A(:,59), n3(:,216), t3x96(:,:,59), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,24), A(:,60), n3(:,217), t3x96(:,:,60), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,9), wf12(:,35), A(:,61), n3(:,218), t3x96(:,:,61), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,36), A(:,62), n3(:,219), t3x96(:,:,62), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,37), A(:,63), n3(:,220), t3x96(:,:,63), nhel, den(48))
    call Hcont_VV(nsync, wf8(:,9), wf12(:,38), A(:,64), n3(:,221), t3x96(:,:,64), nhel, den(51))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,36), A(:,65), n3(:,222), t3x96(:,:,65), nhel, den(53))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,37), A(:,66), n3(:,223), t3x96(:,:,66), nhel, den(54))
    call Hcont_VV(nsync, wf8(:,12), wf12(:,35), A(:,67), n3(:,224), t3x96(:,:,67), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,12), wf12(:,38), A(:,68), n3(:,225), t3x96(:,:,68), nhel, den(57))
    call Hcont_VV(nsync, wf12(:,12), wf8(:,16), A(:,69), n3(:,226), t3x96(:,:,69), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,39), A(:,70), n3(:,227), t3x96(:,:,70), nhel, den(48))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,16), A(:,71), n3(:,228), t3x96(:,:,71), nhel, den(51))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,40), A(:,72), n3(:,229), t3x96(:,:,72), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,39), A(:,73), n3(:,230), t3x96(:,:,73), nhel, den(54))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,40), A(:,74), n3(:,231), t3x96(:,:,74), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,12), wf8(:,17), A(:,75), n3(:,232), t3x96(:,:,75), nhel, den(56))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,17), A(:,76), n3(:,233), t3x96(:,:,76), nhel, den(57))
    call Hcont_QA(nsync, wf12(:,25), wf8(:,18), A(:,77), n3(:,234), t3x96(:,:,77), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,6), A(:,78), n3(:,235), t3x96(:,:,78), nhel, den(32))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,18), A(:,79), n3(:,236), t3x96(:,:,79), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,41), A(:,80), n3(:,237), t3x96(:,:,80), nhel, den(78))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,18), A(:,81), n3(:,238), t3x96(:,:,81), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,42), A(:,82), n3(:,239), t3x96(:,:,82), nhel, den(35))
    call Hcont_QA(nsync, wf6(:,2), wf16(:,6), A(:,83), n3(:,240), t3x96(:,:,83), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,43), A(:,84), n3(:,241), t3x96(:,:,84), nhel, den(29))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,19), A(:,85), n3(:,242), t3x96(:,:,85), nhel, den(82))
    call Hcont_VV(nsync, wf8(:,9), wf12(:,44), A(:,86), n3(:,243), t3x96(:,:,86), nhel, den(83))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,19), A(:,87), n3(:,244), t3x96(:,:,87), nhel, den(85))
    call Hcont_VV(nsync, wf8(:,9), wf12(:,45), A(:,88), n3(:,245), t3x96(:,:,88), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,12), wf12(:,44), A(:,89), n3(:,246), t3x96(:,:,89), nhel, den(57))
    call Hcont_VV(nsync, wf8(:,12), wf12(:,45), A(:,90), n3(:,247), t3x96(:,:,90), nhel, den(56))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,20), A(:,91), n3(:,248), t3x96(:,:,91), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,20), A(:,92), n3(:,249), t3x96(:,:,92), nhel, den(54))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,21), A(:,93), n3(:,250), t3x96(:,:,93), nhel, den(86))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,21), A(:,94), n3(:,251), t3x96(:,:,94), nhel, den(87))
    call Hcont_VV(nsync, wf12(:,12), wf8(:,22), A(:,95), n3(:,252), t3x96(:,:,95), nhel, den(88))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,22), A(:,96), n3(:,253), t3x96(:,:,96), nhel, den(89))
    call Hcont_VV(nsync, wf12(:,12), wf8(:,23), A(:,97), n3(:,254), t3x96(:,:,97), nhel, den(44))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,24), A(:,98), n3(:,255), t3x96(:,:,98), nhel, den(47))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,24), A(:,99), n3(:,256), t3x96(:,:,99), nhel, den(48))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,23), A(:,100), n3(:,257), t3x96(:,:,100), nhel, den(51))
    call Hcont_QA(nsync, wf6(:,2), wf16(:,7), A(:,101), n3(:,258), t3x96(:,:,101), nhel, den(26))
    call Hcont_QA(nsync, wf12(:,8), wf8(:,26), A(:,102), n3(:,259), t3x96(:,:,102), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,7), A(:,103), n3(:,260), t3x96(:,:,103), nhel, den(32))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,28), A(:,104), n3(:,261), t3x96(:,:,104), nhel, den(34))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,26), A(:,105), n3(:,262), t3x96(:,:,105), nhel, den(35))
    call Hcont_QA(nsync, wf12(:,4), wf8(:,28), A(:,106), n3(:,263), t3x96(:,:,106), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,28), A(:,107), n3(:,264), t3x96(:,:,107), nhel, den(37))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,25), A(:,108), n3(:,265), t3x96(:,:,108), nhel, den(40))
    call Hcont_QA(nsync, wf6(:,2), wf16(:,8), A(:,109), n3(:,266), t3x96(:,:,109), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,1), wf8(:,30), A(:,110), n3(:,267), t3x96(:,:,110), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,8), A(:,111), n3(:,268), t3x96(:,:,111), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,32), A(:,112), n3(:,269), t3x96(:,:,112), nhel, den(15))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,30), A(:,113), n3(:,270), t3x96(:,:,113), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,4), wf8(:,32), A(:,114), n3(:,271), t3x96(:,:,114), nhel, den(17))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,32), A(:,115), n3(:,272), t3x96(:,:,115), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,29), A(:,116), n3(:,273), t3x96(:,:,116), nhel, den(22))
    call Hcont_VV(nsync, wf24(:,9), wf4(:,21), A(:,117), n3(:,274), t3x96(:,:,117), nhel, den(93))
    call Hcont_QA(nsync, wf4(:,22), wf24(:,11), A(:,118), n3(:,275), t3x96(:,:,118), nhel, den(97))
    call Hcont_QA(nsync, wf6(:,15), wf16(:,9), A(:,119), n3(:,276), t3x96(:,:,119), nhel, den(100))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,33), A(:,120), n3(:,277), t3x96(:,:,120), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,46), A(:,121), n3(:,278), t3x96(:,:,121), nhel, den(104))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,34), A(:,122), n3(:,279), t3x96(:,:,122), nhel, den(105))
    call Hcont_VV(nsync, wf4(:,21), wf24(:,12), A(:,123), n3(:,280), t3x96(:,:,123), nhel, den(108))
    call Hcont_QA(nsync, wf6(:,16), wf16(:,11), A(:,124), n3(:,281), t3x96(:,:,124), nhel, den(112))
    call Hcont_QA(nsync, wf4(:,24), wf24(:,13), A(:,125), n3(:,282), t3x96(:,:,125), nhel, den(115))
    call Hcont_QA(nsync, wf12(:,25), wf8(:,35), A(:,126), n3(:,283), t3x96(:,:,126), nhel, den(116))
    call Hcont_QA(nsync, wf12(:,25), wf8(:,36), A(:,127), n3(:,284), t3x96(:,:,127), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,47), A(:,128), n3(:,285), t3x96(:,:,128), nhel, den(119))
    call Hcont_QA(nsync, wf12(:,21), wf8(:,33), A(:,129), n3(:,286), t3x96(:,:,129), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,48), A(:,130), n3(:,287), t3x96(:,:,130), nhel, den(122))
    call Hcont_QA(nsync, wf12(:,21), wf8(:,34), A(:,131), n3(:,288), t3x96(:,:,131), nhel, den(123))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,35), A(:,132), n3(:,289), t3x96(:,:,132), nhel, den(124))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,36), A(:,133), n3(:,290), t3x96(:,:,133), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,49), A(:,134), n3(:,291), t3x96(:,:,134), nhel, den(127))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,35), A(:,135), n3(:,292), t3x96(:,:,135), nhel, den(128))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,33), A(:,136), n3(:,293), t3x96(:,:,136), nhel, den(129))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,36), A(:,137), n3(:,294), t3x96(:,:,137), nhel, den(130))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,50), A(:,138), n3(:,295), t3x96(:,:,138), nhel, den(131))
    call Hcont_VV(nsync, wf24(:,14), wf4(:,26), A(:,139), n3(:,296), t3x96(:,:,139), nhel, den(135))
    call Hcont_QA(nsync, wf4(:,27), wf24(:,16), A(:,140), n3(:,297), t3x96(:,:,140), nhel, den(139))
    call Hcont_QA(nsync, wf6(:,15), wf16(:,12), A(:,141), n3(:,298), t3x96(:,:,141), nhel, den(141))
    call Hcont_QA(nsync, wf12(:,33), wf8(:,37), A(:,142), n3(:,299), t3x96(:,:,142), nhel, den(143))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,51), A(:,143), n3(:,300), t3x96(:,:,143), nhel, den(145))
    call Hcont_QA(nsync, wf12(:,33), wf8(:,38), A(:,144), n3(:,301), t3x96(:,:,144), nhel, den(146))
    call Hcont_VV(nsync, wf4(:,26), wf24(:,17), A(:,145), n3(:,302), t3x96(:,:,145), nhel, den(149))
    call Hcont_QA(nsync, wf6(:,19), wf16(:,14), A(:,146), n3(:,303), t3x96(:,:,146), nhel, den(153))
    call Hcont_QA(nsync, wf4(:,24), wf24(:,18), A(:,147), n3(:,304), t3x96(:,:,147), nhel, den(155))
    call Hcont_QA(nsync, wf12(:,25), wf8(:,39), A(:,148), n3(:,305), t3x96(:,:,148), nhel, den(156))
    call Hcont_QA(nsync, wf12(:,25), wf8(:,40), A(:,149), n3(:,306), t3x96(:,:,149), nhel, den(157))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,47), A(:,150), n3(:,307), t3x96(:,:,150), nhel, den(158))
    call Hcont_QA(nsync, wf12(:,34), wf8(:,37), A(:,151), n3(:,308), t3x96(:,:,151), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,52), A(:,152), n3(:,309), t3x96(:,:,152), nhel, den(161))
    call Hcont_QA(nsync, wf12(:,34), wf8(:,38), A(:,153), n3(:,310), t3x96(:,:,153), nhel, den(162))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,39), A(:,154), n3(:,311), t3x96(:,:,154), nhel, den(163))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,40), A(:,155), n3(:,312), t3x96(:,:,155), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,49), A(:,156), n3(:,313), t3x96(:,:,156), nhel, den(165))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,39), A(:,157), n3(:,314), t3x96(:,:,157), nhel, den(166))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,37), A(:,158), n3(:,315), t3x96(:,:,158), nhel, den(167))
    call Hcont_QA(nsync, wf12(:,28), wf8(:,40), A(:,159), n3(:,316), t3x96(:,:,159), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,53), A(:,160), n3(:,317), t3x96(:,:,160), nhel, den(169))
    call Hcont_VV(nsync, wf12(:,12), wf8(:,41), A(:,161), n3(:,318), t3x96(:,:,161), nhel, den(171))
    call Hcont_VV(nsync, wf8(:,9), wf12(:,54), A(:,162), n3(:,319), t3x96(:,:,162), nhel, den(172))
    call Hcont_VV(nsync, wf12(:,12), wf8(:,42), A(:,163), n3(:,320), t3x96(:,:,163), nhel, den(173))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,43), A(:,164), n3(:,321), t3x96(:,:,164), nhel, den(174))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,44), A(:,165), n3(:,322), t3x96(:,:,165), nhel, den(175))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,55), A(:,166), n3(:,323), t3x96(:,:,166), nhel, den(176))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,43), A(:,167), n3(:,324), t3x96(:,:,167), nhel, den(177))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,41), A(:,168), n3(:,325), t3x96(:,:,168), nhel, den(178))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,44), A(:,169), n3(:,326), t3x96(:,:,169), nhel, den(179))
    call Hcont_VV(nsync, wf8(:,9), wf12(:,56), A(:,170), n3(:,327), t3x96(:,:,170), nhel, den(180))
    call Hcont_VV(nsync, wf8(:,9), wf12(:,57), A(:,171), n3(:,328), t3x96(:,:,171), nhel, den(181))
    call Hcont_VV(nsync, wf8(:,10), wf12(:,58), A(:,172), n3(:,329), t3x96(:,:,172), nhel, den(182))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,45), A(:,173), n3(:,330), t3x96(:,:,173), nhel, den(183))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,46), A(:,174), n3(:,331), t3x96(:,:,174), nhel, den(184))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,55), A(:,175), n3(:,332), t3x96(:,:,175), nhel, den(185))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,45), A(:,176), n3(:,333), t3x96(:,:,176), nhel, den(186))
    call Hcont_VV(nsync, wf12(:,14), wf8(:,46), A(:,177), n3(:,334), t3x96(:,:,177), nhel, den(187))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,58), A(:,178), n3(:,335), t3x96(:,:,178), nhel, den(188))
    call Hcont_VV(nsync, wf12(:,12), wf8(:,47), A(:,179), n3(:,336), t3x96(:,:,179), nhel, den(189))
    call Hcont_VV(nsync, wf12(:,12), wf8(:,48), A(:,180), n3(:,337), t3x96(:,:,180), nhel, den(190))
    call Hcont_VV(nsync, wf8(:,12), wf12(:,54), A(:,181), n3(:,338), t3x96(:,:,181), nhel, den(191))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,48), A(:,182), n3(:,339), t3x96(:,:,182), nhel, den(192))
    call Hcont_VV(nsync, wf12(:,15), wf8(:,47), A(:,183), n3(:,340), t3x96(:,:,183), nhel, den(193))
    call Hcont_VV(nsync, wf8(:,12), wf12(:,57), A(:,184), n3(:,341), t3x96(:,:,184), nhel, den(194))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(2) ! M1helarray(2,nhel)
  integer :: empty(0), i

  M1(1)%j = ((-A(j,3)%j-A(j,4)%j-A(j,5)%j)*f(1))/2._/**/REALKIND+((-A(j,11)%j-A(j,12)%j-A(j,13)%j)*f(1))/6._/**/REALKIND &
       +((A(j,1)%j+A(j,2)%j+A(j,6)%j+A(j,18)%j+A(j,19)%j+A(j,21)%j+A(j,22)%j)*f(2))/2._/**/REALKIND+((A(j,9)%j+A(j,10)%j+A(j,14)%j &
       +A(j,17)%j+A(j,20)%j+A(j,23)%j+A(j,24)%j)*f(2))/6._/**/REALKIND+((A(j,7)%j+A(j,8)%j)*f(3))/2._/**/REALKIND+((A(j,15)%j &
       +A(j,16)%j)*f(3))/6._/**/REALKIND
  M1(2)%j = ((A(j,3)%j+A(j,4)%j+A(j,5)%j)*f(1))/6._/**/REALKIND+((A(j,11)%j+A(j,12)%j+A(j,13)%j)*f(1))/2._/**/REALKIND+((-A(j,1)%j &
       -A(j,2)%j-A(j,6)%j-A(j,18)%j-A(j,19)%j-A(j,21)%j-A(j,22)%j)*f(2))/6._/**/REALKIND+((-A(j,9)%j-A(j,10)%j-A(j,14)%j-A(j,17)%j &
       -A(j,20)%j-A(j,23)%j-A(j,24)%j)*f(2))/2._/**/REALKIND+((-A(j,7)%j-A(j,8)%j)*f(3))/6._/**/REALKIND+((-A(j,15)%j &
       -A(j,16)%j)*f(3))/2._/**/REALKIND

  M2(1)%j = ((A(j,123)%j+A(j,124)%j+A(j,125)%j+A(j,126)%j+A(j,127)%j+A(j,128)%j+A(j,129)%j+A(j,130)%j &
       +A(j,131)%j)*f(4))/2._/**/REALKIND+((A(j,145)%j+A(j,146)%j+A(j,147)%j+A(j,148)%j+A(j,149)%j+A(j,150)%j+A(j,151)%j &
       +A(j,152)%j+A(j,153)%j)*f(4))/6._/**/REALKIND+((-A(j,117)%j-A(j,118)%j-A(j,119)%j-A(j,120)%j-A(j,121)%j-A(j,122)%j &
       -A(j,132)%j-A(j,133)%j-A(j,134)%j-A(j,164)%j-A(j,165)%j-A(j,166)%j-A(j,167)%j-A(j,169)%j-A(j,172)%j-A(j,173)%j-A(j,174)%j &
       -A(j,175)%j-A(j,176)%j-A(j,177)%j-A(j,178)%j)*f(5))/2._/**/REALKIND+((-A(j,139)%j-A(j,140)%j-A(j,141)%j-A(j,142)%j &
       -A(j,143)%j-A(j,144)%j-A(j,154)%j-A(j,155)%j-A(j,156)%j-A(j,161)%j-A(j,162)%j-A(j,163)%j-A(j,168)%j-A(j,170)%j-A(j,171)%j &
       -A(j,179)%j-A(j,180)%j-A(j,181)%j-A(j,182)%j-A(j,183)%j-A(j,184)%j)*f(5))/6._/**/REALKIND+((-A(j,135)%j-A(j,136)%j &
       -A(j,137)%j-A(j,138)%j)*f(6))/2._/**/REALKIND+((-A(j,157)%j-A(j,158)%j-A(j,159)%j-A(j,160)%j)*f(6))/6._/**/REALKIND+(( &
       -A(j,49)%j-A(j,55)%j-A(j,77)%j-A(j,103)%j-A(j,104)%j-A(j,105)%j)*f(7))/6._/**/REALKIND+((-A(j,27)%j-A(j,33)%j-A(j,39)%j &
       -A(j,111)%j-A(j,112)%j-A(j,113)%j)*f(7))/2._/**/REALKIND+((A(j,47)%j+A(j,53)%j+A(j,61)%j+A(j,67)%j+A(j,69)%j+A(j,71)%j &
       +A(j,79)%j+A(j,86)%j+A(j,89)%j+A(j,95)%j+A(j,96)%j+A(j,101)%j+A(j,102)%j+A(j,106)%j)*f(8))/6._/**/REALKIND+((A(j,25)%j &
       +A(j,31)%j+A(j,41)%j+A(j,62)%j+A(j,65)%j+A(j,70)%j+A(j,73)%j+A(j,85)%j+A(j,87)%j+A(j,93)%j+A(j,94)%j+A(j,109)%j+A(j,110)%j &
       +A(j,114)%j)*f(8))/2._/**/REALKIND+((A(j,57)%j+A(j,81)%j+A(j,107)%j+A(j,108)%j)*f(9))/6._/**/REALKIND+((A(j,35)%j+A(j,43)%j &
       +A(j,115)%j+A(j,116)%j)*f(9))/2._/**/REALKIND+((-A(j,28)%j-A(j,29)%j-A(j,37)%j-A(j,38)%j-A(j,40)%j &
       -A(j,44)%j)*f(10))/2._/**/REALKIND+((-A(j,50)%j-A(j,51)%j-A(j,59)%j-A(j,60)%j-A(j,78)%j-A(j,82)%j)*f(10))/6._/**/REALKIND &
       +((A(j,26)%j+A(j,30)%j+A(j,32)%j+A(j,36)%j+A(j,45)%j+A(j,46)%j+A(j,63)%j+A(j,66)%j+A(j,72)%j+A(j,74)%j+A(j,91)%j+A(j,92)%j &
       +A(j,98)%j+A(j,99)%j)*f(11))/2._/**/REALKIND+((A(j,48)%j+A(j,52)%j+A(j,54)%j+A(j,58)%j+A(j,64)%j+A(j,68)%j+A(j,75)%j &
       +A(j,76)%j+A(j,83)%j+A(j,84)%j+A(j,88)%j+A(j,90)%j+A(j,97)%j+A(j,100)%j)*f(11))/6._/**/REALKIND+((A(j,34)%j &
       +A(j,42)%j)*f(12))/2._/**/REALKIND+((A(j,56)%j+A(j,80)%j)*f(12))/6._/**/REALKIND
  M2(2)%j = ((-A(j,123)%j-A(j,124)%j-A(j,125)%j-A(j,126)%j-A(j,127)%j-A(j,128)%j-A(j,129)%j-A(j,130)%j &
       -A(j,131)%j)*f(4))/6._/**/REALKIND+((-A(j,145)%j-A(j,146)%j-A(j,147)%j-A(j,148)%j-A(j,149)%j-A(j,150)%j-A(j,151)%j &
       -A(j,152)%j-A(j,153)%j)*f(4))/2._/**/REALKIND+((A(j,117)%j+A(j,118)%j+A(j,119)%j+A(j,120)%j+A(j,121)%j+A(j,122)%j &
       +A(j,132)%j+A(j,133)%j+A(j,134)%j+A(j,164)%j+A(j,165)%j+A(j,166)%j+A(j,167)%j+A(j,169)%j+A(j,172)%j+A(j,173)%j+A(j,174)%j &
       +A(j,175)%j+A(j,176)%j+A(j,177)%j+A(j,178)%j)*f(5))/6._/**/REALKIND+((A(j,139)%j+A(j,140)%j+A(j,141)%j+A(j,142)%j &
       +A(j,143)%j+A(j,144)%j+A(j,154)%j+A(j,155)%j+A(j,156)%j+A(j,161)%j+A(j,162)%j+A(j,163)%j+A(j,168)%j+A(j,170)%j+A(j,171)%j &
       +A(j,179)%j+A(j,180)%j+A(j,181)%j+A(j,182)%j+A(j,183)%j+A(j,184)%j)*f(5))/2._/**/REALKIND+((A(j,135)%j+A(j,136)%j &
       +A(j,137)%j+A(j,138)%j)*f(6))/6._/**/REALKIND+((A(j,157)%j+A(j,158)%j+A(j,159)%j+A(j,160)%j)*f(6))/2._/**/REALKIND &
       +((A(j,49)%j+A(j,55)%j+A(j,77)%j+A(j,103)%j+A(j,104)%j+A(j,105)%j)*f(7))/2._/**/REALKIND+((A(j,27)%j+A(j,33)%j+A(j,39)%j &
       +A(j,111)%j+A(j,112)%j+A(j,113)%j)*f(7))/6._/**/REALKIND+((-A(j,47)%j-A(j,53)%j-A(j,61)%j-A(j,67)%j-A(j,69)%j-A(j,71)%j &
       -A(j,79)%j-A(j,86)%j-A(j,89)%j-A(j,95)%j-A(j,96)%j-A(j,101)%j-A(j,102)%j-A(j,106)%j)*f(8))/2._/**/REALKIND+((-A(j,25)%j &
       -A(j,31)%j-A(j,41)%j-A(j,62)%j-A(j,65)%j-A(j,70)%j-A(j,73)%j-A(j,85)%j-A(j,87)%j-A(j,93)%j-A(j,94)%j-A(j,109)%j-A(j,110)%j &
       -A(j,114)%j)*f(8))/6._/**/REALKIND+((-A(j,57)%j-A(j,81)%j-A(j,107)%j-A(j,108)%j)*f(9))/2._/**/REALKIND+((-A(j,35)%j &
       -A(j,43)%j-A(j,115)%j-A(j,116)%j)*f(9))/6._/**/REALKIND+((A(j,28)%j+A(j,29)%j+A(j,37)%j+A(j,38)%j+A(j,40)%j &
       +A(j,44)%j)*f(10))/6._/**/REALKIND+((A(j,50)%j+A(j,51)%j+A(j,59)%j+A(j,60)%j+A(j,78)%j+A(j,82)%j)*f(10))/2._/**/REALKIND+(( &
       -A(j,26)%j-A(j,30)%j-A(j,32)%j-A(j,36)%j-A(j,45)%j-A(j,46)%j-A(j,63)%j-A(j,66)%j-A(j,72)%j-A(j,74)%j-A(j,91)%j-A(j,92)%j &
       -A(j,98)%j-A(j,99)%j)*f(11))/6._/**/REALKIND+((-A(j,48)%j-A(j,52)%j-A(j,54)%j-A(j,58)%j-A(j,64)%j-A(j,68)%j-A(j,75)%j &
       -A(j,76)%j-A(j,83)%j-A(j,84)%j-A(j,88)%j-A(j,90)%j-A(j,97)%j-A(j,100)%j)*f(11))/2._/**/REALKIND+((-A(j,34)%j &
       -A(j,42)%j)*f(12))/6._/**/REALKIND+((-A(j,56)%j-A(j,80)%j)*f(12))/2._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwajj_uuxuxdawx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwajj_uuxuxdawx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(2), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 2
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+2*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppwajj_uuxuxdawx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwajj_uuxuxdawx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppwajj_uuxuxdawx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+2*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppwajj_uuxuxdawx_1_/**/REALKIND
