
! **********************************************************************
module ol_tables_storage_ppwajj_uuuxdxaw_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(96,534)
integer(intkind2), save :: heltab2x2(2,2,494)
integer(intkind2), save :: heltab2x4(2,4,357)
integer(intkind2), save :: heltab2x8(2,8,263)
integer(intkind2), save :: heltab2x16(2,16,186)
integer(intkind2), save :: heltab2x32(2,32,96)
integer(intkind2), save :: heltab2x96(2,96,534)


  ! number of helicity states for openloops recursion steps  
integer(intkind2), save :: m0h(534)
integer(intkind2), save :: m3h2x1(3,494)
integer(intkind2), save :: m3h4x1(3,176)
integer(intkind2), save :: m3h8x1(3,76)
integer(intkind2), save :: m3h16x1(3,32)
integer(intkind2), save :: m3h2x2(3,181)
integer(intkind2), save :: m3h4x2(3,54)
integer(intkind2), save :: m3h8x2(3,14)
integer(intkind2), save :: m3h2x4(3,133)
integer(intkind2), save :: m3h4x4(3,30)
integer(intkind2), save :: m3h8x4(3,8)
integer(intkind2), save :: m3h24x4(3,160)
integer(intkind2), save :: m3h2x8(3,110)
integer(intkind2), save :: m3h4x8(3,12)
integer(intkind2), save :: m3h12x8(3,168)
integer(intkind2), save :: m3h2x16(3,76)
integer(intkind2), save :: m3h6x16(3,110)
integer(intkind2), save :: m3h3x32(3,96)

integer(intkind2), save :: n2h1(685)
integer(intkind2), save :: n2h2(159)
integer(intkind2), save :: n2h4(202)
integer(intkind2), save :: n2h8(213)
integer(intkind2), save :: n2h16(46)
integer(intkind2), save :: n2h32(96)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2
  
m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h24x4(1,:)=24
m3h24x4(2,:)=4
m3h24x4(3,:)=96
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h12x8(1,:)=12
m3h12x8(2,:)=8
m3h12x8(3,:)=96
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h6x16(1,:)=6
m3h6x16(2,:)=16
m3h6x16(3,:)=96
m3h3x32(1,:)=3
m3h3x32(2,:)=32
m3h3x32(3,:)=96

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppwajj_uuuxdxaw_1_/**/REALKIND 

! **********************************************************************
module ol_tensor_sum_storage_ppwajj_uuuxdxaw_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G2H1(1)
  type(hol), save :: G0H2(1)
  type(hol), save :: G1H2(398)
  type(hol), save :: G2H2(115)
  type(hol), save :: G0H4(17)
  type(hol), save :: G1H4(108)
  type(hol), save :: G2H4(43)
  type(hol), save :: G0H8(16)
  type(hol), save :: G1H8(76)
  type(hol), save :: G2H8(19)
  type(hol), save :: G0H16(23)
  type(hol), save :: G1H16(33)
  type(hol), save :: G0H32(1)
  type(hol), save :: G1H32(32)
  type(hol), save :: G0H96(1)
  type(hcl), save, dimension(805) :: G0tensor
  type(hcl), save, dimension(805) :: G1tensor
  type(hcl), save, dimension(488) :: G2tensor
  type(hcl), save, dimension(12) :: G3tensor



  ! Declarations for on-the-fly tensor reduction 
type (basis),      save :: RedBasis(201)
type (redset4),    save :: RedSet_4(218)
type (redset5),    save :: RedSet_5(72)
integer, save :: mass2set(0:1,3)
integer, save :: mass3set(0:2,3)
integer, save :: mass4set(0:3,1)
integer, save :: mass5set(0:4,1)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(2)
  integer, save :: momenta_24(2)
  integer, save :: momenta_25(2)
  integer, save :: momenta_26(2)
  integer, save :: momenta_27(2)
  integer, save :: momenta_28(2)
  integer, save :: momenta_29(2)
  integer, save :: momenta_30(2)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(3)
  integer, save :: momenta_81(3)
  integer, save :: momenta_82(3)
  integer, save :: momenta_83(3)
  integer, save :: momenta_84(3)
  integer, save :: momenta_85(3)
  integer, save :: momenta_86(3)
  integer, save :: momenta_87(3)
  integer, save :: momenta_88(3)
  integer, save :: momenta_89(3)
  integer, save :: momenta_90(3)
  integer, save :: momenta_91(3)
  integer, save :: momenta_92(3)
  integer, save :: momenta_93(3)
  integer, save :: momenta_94(3)
  integer, save :: momenta_95(3)
  integer, save :: momenta_96(3)
  integer, save :: momenta_97(3)
  integer, save :: momenta_98(3)
  integer, save :: momenta_99(3)
  integer, save :: momenta_100(3)
  integer, save :: momenta_101(3)
  integer, save :: momenta_102(3)
  integer, save :: momenta_103(3)
  integer, save :: momenta_104(3)
  integer, save :: momenta_105(3)
  integer, save :: momenta_106(3)
  integer, save :: momenta_107(3)
  integer, save :: momenta_108(3)
  integer, save :: momenta_109(3)
  integer, save :: momenta_110(3)
  integer, save :: momenta_111(3)
  integer, save :: momenta_112(3)
  integer, save :: momenta_113(3)
  integer, save :: momenta_114(3)
  integer, save :: momenta_115(3)
  integer, save :: momenta_116(3)
  integer, save :: momenta_117(3)
  integer, save :: momenta_118(3)
  integer, save :: momenta_119(3)
  integer, save :: momenta_120(3)
  integer, save :: momenta_121(3)
  integer, save :: momenta_122(3)
  integer, save :: momenta_123(3)
  integer, save :: momenta_124(3)
  integer, save :: momenta_125(3)
  integer, save :: momenta_126(3)
  integer, save :: momenta_127(3)
  integer, save :: momenta_128(3)
  integer, save :: momenta_129(3)
  integer, save :: momenta_130(3)
  integer, save :: momenta_131(3)
  integer, save :: momenta_132(3)
  integer, save :: momenta_133(3)
  integer, save :: momenta_134(3)
  integer, save :: momenta_135(3)
  integer, save :: momenta_136(3)
  integer, save :: momenta_137(3)
  integer, save :: momenta_138(3)
  integer, save :: momenta_139(3)
  integer, save :: momenta_140(3)
  integer, save :: momenta_141(3)
  integer, save :: momenta_142(3)
  integer, save :: momenta_143(3)
  integer, save :: momenta_144(3)
  integer, save :: momenta_145(3)
  integer, save :: momenta_146(3)
  integer, save :: momenta_147(3)
  integer, save :: momenta_148(3)
  integer, save :: momenta_149(3)
  integer, save :: momenta_150(3)
  integer, save :: momenta_151(3)
  integer, save :: momenta_152(3)
  integer, save :: momenta_153(3)
  integer, save :: momenta_154(3)
  integer, save :: momenta_155(3)
  integer, save :: momenta_156(3)
  integer, save :: momenta_157(3)
  integer, save :: momenta_158(3)
  integer, save :: momenta_159(3)
  integer, save :: momenta_160(3)
  integer, save :: momenta_161(3)
  integer, save :: momenta_162(3)
  integer, save :: momenta_163(4)
  integer, save :: momenta_164(4)
  integer, save :: momenta_165(4)
  integer, save :: momenta_166(4)
  integer, save :: momenta_167(4)
  integer, save :: momenta_168(4)
  integer, save :: momenta_169(4)
  integer, save :: momenta_170(4)
  integer, save :: momenta_171(4)
  integer, save :: momenta_172(4)
  integer, save :: momenta_173(4)
  integer, save :: momenta_174(4)
  integer, save :: momenta_175(4)
  integer, save :: momenta_176(4)
  integer, save :: momenta_177(4)
  integer, save :: momenta_178(4)
  integer, save :: momenta_179(4)
  integer, save :: momenta_180(4)
  integer, save :: momenta_181(4)
  integer, save :: momenta_182(4)
  integer, save :: momenta_183(4)
  integer, save :: momenta_184(4)
  integer, save :: momenta_185(4)
  integer, save :: momenta_186(4)
  integer, save :: momenta_187(4)
  integer, save :: momenta_188(4)
  integer, save :: momenta_189(4)
  integer, save :: momenta_190(4)
  integer, save :: momenta_191(4)
  integer, save :: momenta_192(4)
  integer, save :: momenta_193(4)
  integer, save :: momenta_194(4)
  integer, save :: momenta_195(4)
  integer, save :: momenta_196(4)
  integer, save :: momenta_197(4)
  integer, save :: momenta_198(4)
  integer, save :: momenta_199(4)
  integer, save :: momenta_200(4)
  integer, save :: momenta_201(4)
  integer, save :: momenta_202(4)
  integer, save :: momenta_203(4)
  integer, save :: momenta_204(4)
  integer, save :: momenta_205(4)
  integer, save :: momenta_206(4)
  integer, save :: momenta_207(4)
  integer, save :: momenta_208(4)
  integer, save :: momenta_209(4)
  integer, save :: momenta_210(4)
  integer, save :: momenta_211(4)
  integer, save :: momenta_212(4)
  integer, save :: momenta_213(4)
  integer, save :: momenta_214(4)
  integer, save :: momenta_215(4)
  integer, save :: momenta_216(4)
  integer, save :: momenta_217(4)
  integer, save :: momenta_218(4)
  integer, save :: momenta_219(4)
  integer, save :: momenta_220(4)
  integer, save :: momenta_221(4)
  integer, save :: momenta_222(4)
  integer, save :: momenta_223(4)
  integer, save :: momenta_224(4)
  integer, save :: momenta_225(4)
  integer, save :: momenta_226(4)
  integer, save :: momenta_227(4)
  integer, save :: momenta_228(4)
  integer, save :: momenta_229(4)
  integer, save :: momenta_230(4)
  integer, save :: momenta_231(4)
  integer, save :: momenta_232(4)
  integer, save :: momenta_233(4)
  integer, save :: momenta_234(4)
  integer, save :: momenta_235(4)
  integer, save :: momenta_236(4)
  integer, save :: momenta_237(4)
  integer, save :: momenta_238(4)
  integer, save :: momenta_239(4)
  integer, save :: momenta_240(4)
  integer, save :: momenta_241(4)
  integer, save :: momenta_242(4)
  integer, save :: momenta_243(4)
  integer, save :: momenta_244(4)
  integer, save :: momenta_245(4)
  integer, save :: momenta_246(4)
  integer, save :: momenta_247(4)
  integer, save :: momenta_248(4)
  integer, save :: momenta_249(4)
  integer, save :: momenta_250(4)
  integer, save :: momenta_251(4)
  integer, save :: momenta_252(4)
  integer, save :: momenta_253(4)
  integer, save :: momenta_254(4)
  integer, save :: momenta_255(4)
  integer, save :: momenta_256(4)
  integer, save :: momenta_257(4)
  integer, save :: momenta_258(4)
  integer, save :: momenta_259(4)
  integer, save :: momenta_260(4)
  integer, save :: momenta_261(4)
  integer, save :: momenta_262(4)
  integer, save :: momenta_263(4)
  integer, save :: momenta_264(4)
  integer, save :: momenta_265(4)
  integer, save :: momenta_266(4)
  integer, save :: momenta_267(4)
  integer, save :: momenta_268(4)
  integer, save :: momenta_269(4)
  integer, save :: momenta_270(4)
  integer, save :: momenta_271(4)
  integer, save :: momenta_272(4)
  integer, save :: momenta_273(4)
  integer, save :: momenta_274(4)
  integer, save :: momenta_275(4)
  integer, save :: momenta_276(4)
  integer, save :: momenta_277(4)
  integer, save :: momenta_278(4)
  integer, save :: momenta_279(4)
  integer, save :: momenta_280(4)
  integer, save :: momenta_281(4)
  integer, save :: momenta_282(4)
  integer, save :: momenta_283(4)
  integer, save :: momenta_284(4)
  integer, save :: momenta_285(4)
  integer, save :: momenta_286(4)
  integer, save :: momenta_287(4)
  integer, save :: momenta_288(4)
  integer, save :: momenta_289(4)
  integer, save :: momenta_290(4)
  integer, save :: momenta_291(4)
  integer, save :: momenta_292(4)
  integer, save :: momenta_293(4)
  integer, save :: momenta_294(4)
  integer, save :: momenta_295(4)
  integer, save :: momenta_296(4)
  integer, save :: momenta_297(4)
  integer, save :: momenta_298(4)
  integer, save :: momenta_299(4)
  integer, save :: momenta_300(4)
  integer, save :: momenta_301(4)
  integer, save :: momenta_302(4)
  integer, save :: momenta_303(4)
  integer, save :: momenta_304(4)
  integer, save :: momenta_305(4)
  integer, save :: momenta_306(4)
  integer, save :: momenta_307(4)
  integer, save :: momenta_308(4)
  integer, save :: momenta_309(4)
  integer, save :: momenta_310(4)
  integer, save :: momenta_311(4)
  integer, save :: momenta_312(4)
  integer, save :: momenta_313(4)
  integer, save :: momenta_314(4)
  integer, save :: momenta_315(4)
  integer, save :: momenta_316(4)
  integer, save :: momenta_317(4)
  integer, save :: momenta_318(4)
  integer, save :: momenta_319(4)
  integer, save :: momenta_320(4)
  integer, save :: momenta_321(4)
  integer, save :: momenta_322(4)
  integer, save :: momenta_323(4)
  integer, save :: momenta_324(5)
  integer, save :: momenta_325(5)
  integer, save :: momenta_326(5)
  integer, save :: momenta_327(5)
  integer, save :: momenta_328(5)
  integer, save :: momenta_329(5)
  integer, save :: momenta_330(5)
  integer, save :: momenta_331(5)
  integer, save :: momenta_332(5)
  integer, save :: momenta_333(5)
  integer, save :: momenta_334(5)
  integer, save :: momenta_335(5)
  integer, save :: momenta_336(5)
  integer, save :: momenta_337(5)
  integer, save :: momenta_338(5)
  integer, save :: momenta_339(5)
  integer, save :: momenta_340(5)
  integer, save :: momenta_341(5)
  integer, save :: momenta_342(5)
  integer, save :: momenta_343(5)
  integer, save :: momenta_344(5)
  integer, save :: momenta_345(5)
  integer, save :: momenta_346(5)
  integer, save :: momenta_347(5)
  integer, save :: momenta_348(5)
  integer, save :: momenta_349(5)
  integer, save :: momenta_350(5)
  integer, save :: momenta_351(5)
  integer, save :: momenta_352(5)
  integer, save :: momenta_353(5)
  integer, save :: momenta_354(5)
  integer, save :: momenta_355(5)
  integer, save :: momenta_356(5)
  integer, save :: momenta_357(5)
  integer, save :: momenta_358(5)
  integer, save :: momenta_359(5)
  integer, save :: momenta_360(5)
  integer, save :: momenta_361(5)
  integer, save :: momenta_362(5)
  integer, save :: momenta_363(5)
  integer, save :: momenta_364(5)
  integer, save :: momenta_365(5)
  integer, save :: momenta_366(5)
  integer, save :: momenta_367(5)
  integer, save :: momenta_368(5)
  integer, save :: momenta_369(5)
  integer, save :: momenta_370(5)
  integer, save :: momenta_371(5)
  integer, save :: momenta_372(5)
  integer, save :: momenta_373(5)
  integer, save :: momenta_374(5)
  integer, save :: momenta_375(5)
  integer, save :: momenta_376(5)
  integer, save :: momenta_377(5)
  integer, save :: momenta_378(5)
  integer, save :: momenta_379(5)
  integer, save :: momenta_380(5)
  integer, save :: momenta_381(5)
  integer, save :: momenta_382(5)
  integer, save :: momenta_383(5)
  integer, save :: momenta_384(5)
  integer, save :: momenta_385(5)
  integer, save :: momenta_386(5)
  integer, save :: momenta_387(5)
  integer, save :: momenta_388(5)
  integer, save :: momenta_389(5)
  integer, save :: momenta_390(5)
  integer, save :: momenta_391(5)
  integer, save :: momenta_392(6)
  integer, save :: momenta_393(6)
  integer, save :: momenta_394(6)
  integer, save :: momenta_395(6)
  integer, save :: momenta_396(6)
  integer, save :: momenta_397(6)
  integer, save :: momenta_398(6)
  integer, save :: momenta_399(6)
  integer, save :: momenta_400(6)
  integer, save :: momenta_401(6)
  integer, save :: momenta_402(6)
  integer, save :: momenta_403(6)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(3)
  integer, save :: masses2_7(3)
  integer, save :: masses2_8(3)
  integer, save :: masses2_9(4)
  integer, save :: masses2_10(5)
  integer, save :: masses2_11(6)

type(scalarbox), save :: ScalarBoxes(199)

integer, save :: sbarray_1(15)
integer, save :: sbarray_2(15)
integer, save :: sbarray_3(15)
integer, save :: sbarray_4(15)
integer, save :: sbarray_5(15)
integer, save :: sbarray_6(15)
integer, save :: sbarray_7(15)
integer, save :: sbarray_8(15)
integer, save :: sbarray_9(15)
integer, save :: sbarray_10(15)
integer, save :: sbarray_11(15)
integer, save :: sbarray_12(15)
integer, save :: sbarray_13(5)
integer, save :: sbarray_14(5)
integer, save :: sbarray_15(5)
integer, save :: sbarray_16(5)
integer, save :: sbarray_17(5)
integer, save :: sbarray_18(5)
integer, save :: sbarray_19(5)
integer, save :: sbarray_20(5)
integer, save :: sbarray_21(5)
integer, save :: sbarray_22(5)
integer, save :: sbarray_23(5)
integer, save :: sbarray_24(5)
integer, save :: sbarray_25(5)
integer, save :: sbarray_26(5)
integer, save :: sbarray_27(5)
integer, save :: sbarray_28(5)
integer, save :: sbarray_29(5)
integer, save :: sbarray_30(5)
integer, save :: sbarray_31(5)
integer, save :: sbarray_32(5)
integer, save :: sbarray_33(5)
integer, save :: sbarray_34(5)
integer, save :: sbarray_35(5)
integer, save :: sbarray_36(5)
integer, save :: sbarray_37(5)
integer, save :: sbarray_38(5)
integer, save :: sbarray_39(5)
integer, save :: sbarray_40(5)
integer, save :: sbarray_41(5)
integer, save :: sbarray_42(5)
integer, save :: sbarray_43(5)
integer, save :: sbarray_44(5)
integer, save :: sbarray_45(5)
integer, save :: sbarray_46(5)
integer, save :: sbarray_47(5)
integer, save :: sbarray_48(5)
integer, save :: sbarray_49(5)
integer, save :: sbarray_50(5)
integer, save :: sbarray_51(5)
integer, save :: sbarray_52(5)
integer, save :: sbarray_53(5)
integer, save :: sbarray_54(5)
integer, save :: sbarray_55(5)
integer, save :: sbarray_56(5)
integer, save :: sbarray_57(5)
integer, save :: sbarray_58(5)
integer, save :: sbarray_59(5)
integer, save :: sbarray_60(5)
integer, save :: sbarray_61(5)
integer, save :: sbarray_62(5)
integer, save :: sbarray_63(5)
integer, save :: sbarray_64(5)
integer, save :: sbarray_65(5)
integer, save :: sbarray_66(5)
integer, save :: sbarray_67(5)
integer, save :: sbarray_68(5)
integer, save :: sbarray_69(5)
integer, save :: sbarray_70(5)
integer, save :: sbarray_71(5)
integer, save :: sbarray_72(5)
integer, save :: sbarray_73(5)
integer, save :: sbarray_74(5)
integer, save :: sbarray_75(5)
integer, save :: sbarray_76(5)
integer, save :: sbarray_77(5)
integer, save :: sbarray_78(5)
integer, save :: sbarray_79(5)
integer, save :: sbarray_80(5)

  type(hcl), save, dimension(338) :: T0sum
  type(hcl), save, dimension(80) :: T1sum


  contains
  
!**********************************************************************
subroutine HOL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none
  
    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,15,4,1,G2H1,1)
  call hol_allocation(4,1,4,2,G0H2,1)
  call hol_allocation(4,5,4,2,G1H2,398)
  call hol_allocation(4,15,4,2,G2H2,115)
  call hol_allocation(4,1,4,4,G0H4,17)
  call hol_allocation(4,5,4,4,G1H4,108)
  call hol_allocation(4,15,4,4,G2H4,43)
  call hol_allocation(4,1,4,8,G0H8,16)
  call hol_allocation(4,5,4,8,G1H8,76)
  call hol_allocation(4,15,4,8,G2H8,19)
  call hol_allocation(4,1,4,16,G0H16,23)
  call hol_allocation(4,5,4,16,G1H16,33)
  call hol_allocation(4,1,4,32,G0H32,1)
  call hol_allocation(4,5,4,32,G1H32,32)
  call hol_allocation(4,1,4,96,G0H96,1)


end subroutine HOL_memory_allocation


!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode
  
    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G2H1,1,dmode)
  call hol_deallocation(G0H2,1,dmode)
  call hol_deallocation(G1H2,398,dmode)
  call hol_deallocation(G2H2,115,dmode)
  call hol_deallocation(G0H4,17,dmode)
  call hol_deallocation(G1H4,108,dmode)
  call hol_deallocation(G2H4,43,dmode)
  call hol_deallocation(G0H8,16,dmode)
  call hol_deallocation(G1H8,76,dmode)
  call hol_deallocation(G2H8,19,dmode)
  call hol_deallocation(G0H16,23,dmode)
  call hol_deallocation(G1H16,33,dmode)
  call hol_deallocation(G0H32,1,dmode)
  call hol_deallocation(G1H32,32,dmode)
  call hol_deallocation(G0H96,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none
  
  call hcl_allocation(1,G0tensor, 805)
call hcl_allocation(5,G1tensor, 805)
call hcl_allocation(15,G2tensor, 488)
call hcl_allocation(35,G3tensor, 12)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode
  
  call hcl_deallocation(G0tensor, 805,dmode)
call hcl_deallocation(G1tensor, 805,dmode)
call hcl_deallocation(G2tensor, 488,dmode)
call hcl_deallocation(G3tensor, 12,dmode)

  call hcl_deallocation(T0sum,338,dmode)
call hcl_deallocation(T1sum,80,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none
  
  call hcl_allocation(1,T0sum,338)
call hcl_allocation(5,T1sum,80)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppwajj_uuuxdxaw_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 6
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppwajj_uuuxdxaw_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,338
    call init_hcl(T0sum(i))
  end do
  do i = 1,80
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T1sum(3)%cmp, 4)
  call scale_one_tsum(T1sum(4)%cmp, 4)
  call scale_one_tsum(T1sum(5)%cmp, 4)
  call scale_one_tsum(T1sum(6)%cmp, 4)
  call scale_one_tsum(T1sum(7)%cmp, 4)
  call scale_one_tsum(T1sum(8)%cmp, 4)
  call scale_one_tsum(T1sum(9)%cmp, 4)
  call scale_one_tsum(T1sum(10)%cmp, 4)
  call scale_one_tsum(T1sum(11)%cmp, 4)
  call scale_one_tsum(T1sum(12)%cmp, 4)
  call scale_one_tsum(T1sum(13)%cmp, 2)
  call scale_one_tsum(T1sum(14)%cmp, 2)
  call scale_one_tsum(T1sum(15)%cmp, 2)
  call scale_one_tsum(T1sum(16)%cmp, 2)
  call scale_one_tsum(T1sum(17)%cmp, 2)
  call scale_one_tsum(T1sum(18)%cmp, 2)
  call scale_one_tsum(T1sum(19)%cmp, 2)
  call scale_one_tsum(T1sum(20)%cmp, 2)
  call scale_one_tsum(T1sum(21)%cmp, 2)
  call scale_one_tsum(T1sum(22)%cmp, 2)
  call scale_one_tsum(T1sum(23)%cmp, 2)
  call scale_one_tsum(T1sum(24)%cmp, 2)
  call scale_one_tsum(T1sum(25)%cmp, 2)
  call scale_one_tsum(T1sum(26)%cmp, 2)
  call scale_one_tsum(T1sum(27)%cmp, 2)
  call scale_one_tsum(T1sum(28)%cmp, 2)
  call scale_one_tsum(T1sum(29)%cmp, 2)
  call scale_one_tsum(T1sum(30)%cmp, 2)
  call scale_one_tsum(T1sum(31)%cmp, 2)
  call scale_one_tsum(T1sum(32)%cmp, 2)
  call scale_one_tsum(T1sum(33)%cmp, 2)
  call scale_one_tsum(T1sum(34)%cmp, 2)
  call scale_one_tsum(T1sum(35)%cmp, 2)
  call scale_one_tsum(T1sum(36)%cmp, 2)
  call scale_one_tsum(T1sum(37)%cmp, 2)
  call scale_one_tsum(T1sum(38)%cmp, 2)
  call scale_one_tsum(T1sum(39)%cmp, 2)
  call scale_one_tsum(T1sum(40)%cmp, 2)
  call scale_one_tsum(T1sum(41)%cmp, 2)
  call scale_one_tsum(T1sum(42)%cmp, 2)
  call scale_one_tsum(T1sum(43)%cmp, 2)
  call scale_one_tsum(T1sum(44)%cmp, 2)
  call scale_one_tsum(T1sum(45)%cmp, 2)
  call scale_one_tsum(T1sum(46)%cmp, 2)
  call scale_one_tsum(T1sum(47)%cmp, 2)
  call scale_one_tsum(T1sum(48)%cmp, 2)
  call scale_one_tsum(T1sum(49)%cmp, 2)
  call scale_one_tsum(T1sum(50)%cmp, 2)
  call scale_one_tsum(T1sum(51)%cmp, 2)
  call scale_one_tsum(T1sum(52)%cmp, 2)
  call scale_one_tsum(T1sum(53)%cmp, 2)
  call scale_one_tsum(T1sum(54)%cmp, 2)
  call scale_one_tsum(T1sum(55)%cmp, 2)
  call scale_one_tsum(T1sum(56)%cmp, 2)
  call scale_one_tsum(T1sum(57)%cmp, 2)
  call scale_one_tsum(T1sum(58)%cmp, 2)
  call scale_one_tsum(T1sum(59)%cmp, 2)
  call scale_one_tsum(T1sum(60)%cmp, 2)
  call scale_one_tsum(T1sum(61)%cmp, 2)
  call scale_one_tsum(T1sum(62)%cmp, 2)
  call scale_one_tsum(T1sum(63)%cmp, 2)
  call scale_one_tsum(T1sum(64)%cmp, 2)
  call scale_one_tsum(T1sum(65)%cmp, 2)
  call scale_one_tsum(T1sum(66)%cmp, 2)
  call scale_one_tsum(T1sum(67)%cmp, 2)
  call scale_one_tsum(T1sum(68)%cmp, 2)
  call scale_one_tsum(T1sum(69)%cmp, 2)
  call scale_one_tsum(T1sum(70)%cmp, 2)
  call scale_one_tsum(T1sum(71)%cmp, 2)
  call scale_one_tsum(T1sum(72)%cmp, 2)
  call scale_one_tsum(T1sum(73)%cmp, 2)
  call scale_one_tsum(T1sum(74)%cmp, 2)
  call scale_one_tsum(T1sum(75)%cmp, 2)
  call scale_one_tsum(T1sum(76)%cmp, 2)
  call scale_one_tsum(T1sum(77)%cmp, 2)
  call scale_one_tsum(T1sum(78)%cmp, 2)
  call scale_one_tsum(T1sum(79)%cmp, 2)
  call scale_one_tsum(T1sum(80)%cmp, 2)
  call scale_one_tsum(T0sum(1)%cmp, 0)
  call scale_one_tsum(T0sum(2)%cmp, 0)
  call scale_one_tsum(T0sum(3)%cmp, 0)
  call scale_one_tsum(T0sum(4)%cmp, 0)
  call scale_one_tsum(T0sum(5)%cmp, 0)
  call scale_one_tsum(T0sum(6)%cmp, 0)
  call scale_one_tsum(T0sum(7)%cmp, 0)
  call scale_one_tsum(T0sum(8)%cmp, 0)
  call scale_one_tsum(T0sum(9)%cmp, 0)
  call scale_one_tsum(T0sum(10)%cmp, 0)
  call scale_one_tsum(T0sum(11)%cmp, 0)
  call scale_one_tsum(T0sum(12)%cmp, 0)
  call scale_one_tsum(T0sum(13)%cmp, 0)
  call scale_one_tsum(T0sum(14)%cmp, 0)
  call scale_one_tsum(T0sum(15)%cmp, 0)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, 0)
  call scale_one_tsum(T0sum(40)%cmp, 0)
  call scale_one_tsum(T0sum(41)%cmp, 0)
  call scale_one_tsum(T0sum(42)%cmp, 0)
  call scale_one_tsum(T0sum(43)%cmp, 0)
  call scale_one_tsum(T0sum(44)%cmp, 0)
  call scale_one_tsum(T0sum(45)%cmp, 0)
  call scale_one_tsum(T0sum(46)%cmp, 0)
  call scale_one_tsum(T0sum(47)%cmp, 0)
  call scale_one_tsum(T0sum(48)%cmp, 0)
  call scale_one_tsum(T0sum(49)%cmp, 0)
  call scale_one_tsum(T0sum(50)%cmp, 0)
  call scale_one_tsum(T0sum(51)%cmp, 0)
  call scale_one_tsum(T0sum(52)%cmp, 0)
  call scale_one_tsum(T0sum(53)%cmp, 0)
  call scale_one_tsum(T0sum(54)%cmp, 0)
  call scale_one_tsum(T0sum(55)%cmp, 0)
  call scale_one_tsum(T0sum(56)%cmp, 0)
  call scale_one_tsum(T0sum(57)%cmp, 0)
  call scale_one_tsum(T0sum(58)%cmp, 0)
  call scale_one_tsum(T0sum(59)%cmp, 0)
  call scale_one_tsum(T0sum(60)%cmp, 0)
  call scale_one_tsum(T0sum(61)%cmp, 0)
  call scale_one_tsum(T0sum(62)%cmp, 0)
  call scale_one_tsum(T0sum(63)%cmp, 0)
  call scale_one_tsum(T0sum(64)%cmp, 0)
  call scale_one_tsum(T0sum(65)%cmp, 0)
  call scale_one_tsum(T0sum(66)%cmp, 0)
  call scale_one_tsum(T0sum(67)%cmp, 0)
  call scale_one_tsum(T0sum(68)%cmp, 0)
  call scale_one_tsum(T0sum(69)%cmp, 0)
  call scale_one_tsum(T0sum(70)%cmp, 0)
  call scale_one_tsum(T0sum(71)%cmp, 0)
  call scale_one_tsum(T0sum(72)%cmp, 0)
  call scale_one_tsum(T0sum(73)%cmp, 0)
  call scale_one_tsum(T0sum(74)%cmp, 0)
  call scale_one_tsum(T0sum(75)%cmp, 0)
  call scale_one_tsum(T0sum(76)%cmp, 0)
  call scale_one_tsum(T0sum(77)%cmp, 0)
  call scale_one_tsum(T0sum(78)%cmp, 0)
  call scale_one_tsum(T0sum(79)%cmp, 0)
  call scale_one_tsum(T0sum(80)%cmp, 0)
  call scale_one_tsum(T0sum(81)%cmp, 0)
  call scale_one_tsum(T0sum(82)%cmp, 0)
  call scale_one_tsum(T0sum(83)%cmp, 0)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, 0)
  call scale_one_tsum(T0sum(90)%cmp, 0)
  call scale_one_tsum(T0sum(91)%cmp, 0)
  call scale_one_tsum(T0sum(92)%cmp, 0)
  call scale_one_tsum(T0sum(93)%cmp, 0)
  call scale_one_tsum(T0sum(94)%cmp, 0)
  call scale_one_tsum(T0sum(95)%cmp, 0)
  call scale_one_tsum(T0sum(96)%cmp, 0)
  call scale_one_tsum(T0sum(97)%cmp, 0)
  call scale_one_tsum(T0sum(98)%cmp, 0)
  call scale_one_tsum(T0sum(99)%cmp, 0)
  call scale_one_tsum(T0sum(100)%cmp, 0)
  call scale_one_tsum(T0sum(101)%cmp, 0)
  call scale_one_tsum(T0sum(102)%cmp, 0)
  call scale_one_tsum(T0sum(103)%cmp, 0)
  call scale_one_tsum(T0sum(104)%cmp, 0)
  call scale_one_tsum(T0sum(105)%cmp, 0)
  call scale_one_tsum(T0sum(106)%cmp, 0)
  call scale_one_tsum(T0sum(107)%cmp, 0)
  call scale_one_tsum(T0sum(108)%cmp, 0)
  call scale_one_tsum(T0sum(109)%cmp, 0)
  call scale_one_tsum(T0sum(110)%cmp, 0)
  call scale_one_tsum(T0sum(111)%cmp, 0)
  call scale_one_tsum(T0sum(112)%cmp, 0)
  call scale_one_tsum(T0sum(113)%cmp, 0)
  call scale_one_tsum(T0sum(114)%cmp, 0)
  call scale_one_tsum(T0sum(115)%cmp, 0)
  call scale_one_tsum(T0sum(116)%cmp, 0)
  call scale_one_tsum(T0sum(117)%cmp, 0)
  call scale_one_tsum(T0sum(118)%cmp, 0)
  call scale_one_tsum(T0sum(119)%cmp, 0)
  call scale_one_tsum(T0sum(120)%cmp, 0)
  call scale_one_tsum(T0sum(121)%cmp, 0)
  call scale_one_tsum(T0sum(122)%cmp, 0)
  call scale_one_tsum(T0sum(123)%cmp, 0)
  call scale_one_tsum(T0sum(124)%cmp, 0)
  call scale_one_tsum(T0sum(125)%cmp, 0)
  call scale_one_tsum(T0sum(126)%cmp, 0)
  call scale_one_tsum(T0sum(127)%cmp, 0)
  call scale_one_tsum(T0sum(128)%cmp, 0)
  call scale_one_tsum(T0sum(129)%cmp, 0)
  call scale_one_tsum(T0sum(130)%cmp, 0)
  call scale_one_tsum(T0sum(131)%cmp, 0)
  call scale_one_tsum(T0sum(132)%cmp, 0)
  call scale_one_tsum(T0sum(133)%cmp, 0)
  call scale_one_tsum(T0sum(134)%cmp, 0)
  call scale_one_tsum(T0sum(135)%cmp, 0)
  call scale_one_tsum(T0sum(136)%cmp, 0)
  call scale_one_tsum(T0sum(137)%cmp, 0)
  call scale_one_tsum(T0sum(138)%cmp, 0)
  call scale_one_tsum(T0sum(139)%cmp, 0)
  call scale_one_tsum(T0sum(140)%cmp, 0)
  call scale_one_tsum(T0sum(141)%cmp, 0)
  call scale_one_tsum(T0sum(142)%cmp, 0)
  call scale_one_tsum(T0sum(143)%cmp, 0)
  call scale_one_tsum(T0sum(144)%cmp, 0)
  call scale_one_tsum(T0sum(145)%cmp, 0)
  call scale_one_tsum(T0sum(146)%cmp, 0)
  call scale_one_tsum(T0sum(147)%cmp, 0)
  call scale_one_tsum(T0sum(148)%cmp, 0)
  call scale_one_tsum(T0sum(149)%cmp, 0)
  call scale_one_tsum(T0sum(150)%cmp, 0)
  call scale_one_tsum(T0sum(151)%cmp, 0)
  call scale_one_tsum(T0sum(152)%cmp, 0)
  call scale_one_tsum(T0sum(153)%cmp, 0)
  call scale_one_tsum(T0sum(154)%cmp, 0)
  call scale_one_tsum(T0sum(155)%cmp, 0)
  call scale_one_tsum(T0sum(156)%cmp, 0)
  call scale_one_tsum(T0sum(157)%cmp, 0)
  call scale_one_tsum(T0sum(158)%cmp, 0)
  call scale_one_tsum(T0sum(159)%cmp, 0)
  call scale_one_tsum(T0sum(160)%cmp, 0)
  call scale_one_tsum(T0sum(161)%cmp, 0)
  call scale_one_tsum(T0sum(162)%cmp, -2)
  call scale_one_tsum(T0sum(163)%cmp, -2)
  call scale_one_tsum(T0sum(164)%cmp, -2)
  call scale_one_tsum(T0sum(165)%cmp, -2)
  call scale_one_tsum(T0sum(166)%cmp, -2)
  call scale_one_tsum(T0sum(167)%cmp, -2)
  call scale_one_tsum(T0sum(168)%cmp, -2)
  call scale_one_tsum(T0sum(169)%cmp, -2)
  call scale_one_tsum(T0sum(170)%cmp, -2)
  call scale_one_tsum(T0sum(171)%cmp, -2)
  call scale_one_tsum(T0sum(172)%cmp, -2)
  call scale_one_tsum(T0sum(173)%cmp, -2)
  call scale_one_tsum(T0sum(174)%cmp, -2)
  call scale_one_tsum(T0sum(175)%cmp, -2)
  call scale_one_tsum(T0sum(176)%cmp, -2)
  call scale_one_tsum(T0sum(177)%cmp, -2)
  call scale_one_tsum(T0sum(178)%cmp, -2)
  call scale_one_tsum(T0sum(179)%cmp, -2)
  call scale_one_tsum(T0sum(180)%cmp, -2)
  call scale_one_tsum(T0sum(181)%cmp, -2)
  call scale_one_tsum(T0sum(182)%cmp, -2)
  call scale_one_tsum(T0sum(183)%cmp, -2)
  call scale_one_tsum(T0sum(184)%cmp, -2)
  call scale_one_tsum(T0sum(185)%cmp, -2)
  call scale_one_tsum(T0sum(186)%cmp, -2)
  call scale_one_tsum(T0sum(187)%cmp, -2)
  call scale_one_tsum(T0sum(188)%cmp, -2)
  call scale_one_tsum(T0sum(189)%cmp, -2)
  call scale_one_tsum(T0sum(190)%cmp, -2)
  call scale_one_tsum(T0sum(191)%cmp, -2)
  call scale_one_tsum(T0sum(192)%cmp, -2)
  call scale_one_tsum(T0sum(193)%cmp, -2)
  call scale_one_tsum(T0sum(194)%cmp, -2)
  call scale_one_tsum(T0sum(195)%cmp, -2)
  call scale_one_tsum(T0sum(196)%cmp, -2)
  call scale_one_tsum(T0sum(197)%cmp, -2)
  call scale_one_tsum(T0sum(198)%cmp, -2)
  call scale_one_tsum(T0sum(199)%cmp, -2)
  call scale_one_tsum(T0sum(200)%cmp, -2)
  call scale_one_tsum(T0sum(201)%cmp, -2)
  call scale_one_tsum(T0sum(202)%cmp, -2)
  call scale_one_tsum(T0sum(203)%cmp, -2)
  call scale_one_tsum(T0sum(204)%cmp, -2)
  call scale_one_tsum(T0sum(205)%cmp, -2)
  call scale_one_tsum(T0sum(206)%cmp, -2)
  call scale_one_tsum(T0sum(207)%cmp, -2)
  call scale_one_tsum(T0sum(208)%cmp, -2)
  call scale_one_tsum(T0sum(209)%cmp, -2)
  call scale_one_tsum(T0sum(210)%cmp, -2)
  call scale_one_tsum(T0sum(211)%cmp, -2)
  call scale_one_tsum(T0sum(212)%cmp, -2)
  call scale_one_tsum(T0sum(213)%cmp, -2)
  call scale_one_tsum(T0sum(214)%cmp, -2)
  call scale_one_tsum(T0sum(215)%cmp, -2)
  call scale_one_tsum(T0sum(216)%cmp, -2)
  call scale_one_tsum(T0sum(217)%cmp, -2)
  call scale_one_tsum(T0sum(218)%cmp, -2)
  call scale_one_tsum(T0sum(219)%cmp, -2)
  call scale_one_tsum(T0sum(220)%cmp, -2)
  call scale_one_tsum(T0sum(221)%cmp, -2)
  call scale_one_tsum(T0sum(222)%cmp, -2)
  call scale_one_tsum(T0sum(223)%cmp, -2)
  call scale_one_tsum(T0sum(224)%cmp, -2)
  call scale_one_tsum(T0sum(225)%cmp, -2)
  call scale_one_tsum(T0sum(226)%cmp, -2)
  call scale_one_tsum(T0sum(227)%cmp, -2)
  call scale_one_tsum(T0sum(228)%cmp, -2)
  call scale_one_tsum(T0sum(229)%cmp, -2)
  call scale_one_tsum(T0sum(230)%cmp, -2)
  call scale_one_tsum(T0sum(231)%cmp, -2)
  call scale_one_tsum(T0sum(232)%cmp, -2)
  call scale_one_tsum(T0sum(233)%cmp, -2)
  call scale_one_tsum(T0sum(234)%cmp, -2)
  call scale_one_tsum(T0sum(235)%cmp, -2)
  call scale_one_tsum(T0sum(236)%cmp, -2)
  call scale_one_tsum(T0sum(237)%cmp, -2)
  call scale_one_tsum(T0sum(238)%cmp, -2)
  call scale_one_tsum(T0sum(239)%cmp, -2)
  call scale_one_tsum(T0sum(240)%cmp, -2)
  call scale_one_tsum(T0sum(241)%cmp, -2)
  call scale_one_tsum(T0sum(242)%cmp, -2)
  call scale_one_tsum(T0sum(243)%cmp, -2)
  call scale_one_tsum(T0sum(244)%cmp, -2)
  call scale_one_tsum(T0sum(245)%cmp, -2)
  call scale_one_tsum(T0sum(246)%cmp, -2)
  call scale_one_tsum(T0sum(247)%cmp, -2)
  call scale_one_tsum(T0sum(248)%cmp, -2)
  call scale_one_tsum(T0sum(249)%cmp, -2)
  call scale_one_tsum(T0sum(250)%cmp, -2)
  call scale_one_tsum(T0sum(251)%cmp, -2)
  call scale_one_tsum(T0sum(252)%cmp, -2)
  call scale_one_tsum(T0sum(253)%cmp, -2)
  call scale_one_tsum(T0sum(254)%cmp, -2)
  call scale_one_tsum(T0sum(255)%cmp, -2)
  call scale_one_tsum(T0sum(256)%cmp, -2)
  call scale_one_tsum(T0sum(257)%cmp, -2)
  call scale_one_tsum(T0sum(258)%cmp, -2)
  call scale_one_tsum(T0sum(259)%cmp, -2)
  call scale_one_tsum(T0sum(260)%cmp, -2)
  call scale_one_tsum(T0sum(261)%cmp, -2)
  call scale_one_tsum(T0sum(262)%cmp, -2)
  call scale_one_tsum(T0sum(263)%cmp, -2)
  call scale_one_tsum(T0sum(264)%cmp, -2)
  call scale_one_tsum(T0sum(265)%cmp, -2)
  call scale_one_tsum(T0sum(266)%cmp, -2)
  call scale_one_tsum(T0sum(267)%cmp, -2)
  call scale_one_tsum(T0sum(268)%cmp, -2)
  call scale_one_tsum(T0sum(269)%cmp, -2)
  call scale_one_tsum(T0sum(270)%cmp, -2)
  call scale_one_tsum(T0sum(271)%cmp, -2)
  call scale_one_tsum(T0sum(272)%cmp, -2)
  call scale_one_tsum(T0sum(273)%cmp, -2)
  call scale_one_tsum(T0sum(274)%cmp, -2)
  call scale_one_tsum(T0sum(275)%cmp, -2)
  call scale_one_tsum(T0sum(276)%cmp, -2)
  call scale_one_tsum(T0sum(277)%cmp, -2)
  call scale_one_tsum(T0sum(278)%cmp, -2)
  call scale_one_tsum(T0sum(279)%cmp, -2)
  call scale_one_tsum(T0sum(280)%cmp, -2)
  call scale_one_tsum(T0sum(281)%cmp, -2)
  call scale_one_tsum(T0sum(282)%cmp, -2)
  call scale_one_tsum(T0sum(283)%cmp, -2)
  call scale_one_tsum(T0sum(284)%cmp, -2)
  call scale_one_tsum(T0sum(285)%cmp, -2)
  call scale_one_tsum(T0sum(286)%cmp, -2)
  call scale_one_tsum(T0sum(287)%cmp, -2)
  call scale_one_tsum(T0sum(288)%cmp, -2)
  call scale_one_tsum(T0sum(289)%cmp, -2)
  call scale_one_tsum(T0sum(290)%cmp, -2)
  call scale_one_tsum(T0sum(291)%cmp, -2)
  call scale_one_tsum(T0sum(292)%cmp, -2)
  call scale_one_tsum(T0sum(293)%cmp, -2)
  call scale_one_tsum(T0sum(294)%cmp, -2)
  call scale_one_tsum(T0sum(295)%cmp, -2)
  call scale_one_tsum(T0sum(296)%cmp, -2)
  call scale_one_tsum(T0sum(297)%cmp, -2)
  call scale_one_tsum(T0sum(298)%cmp, -4)
  call scale_one_tsum(T0sum(299)%cmp, -4)
  call scale_one_tsum(T0sum(300)%cmp, -4)
  call scale_one_tsum(T0sum(301)%cmp, -4)
  call scale_one_tsum(T0sum(302)%cmp, -4)
  call scale_one_tsum(T0sum(303)%cmp, -4)
  call scale_one_tsum(T0sum(304)%cmp, -4)
  call scale_one_tsum(T0sum(305)%cmp, -4)
  call scale_one_tsum(T0sum(306)%cmp, -4)
  call scale_one_tsum(T0sum(307)%cmp, -4)
  call scale_one_tsum(T0sum(308)%cmp, -4)
  call scale_one_tsum(T0sum(309)%cmp, -4)
  call scale_one_tsum(T0sum(310)%cmp, -4)
  call scale_one_tsum(T0sum(311)%cmp, -4)
  call scale_one_tsum(T0sum(312)%cmp, -4)
  call scale_one_tsum(T0sum(313)%cmp, -4)
  call scale_one_tsum(T0sum(314)%cmp, -4)
  call scale_one_tsum(T0sum(315)%cmp, -4)
  call scale_one_tsum(T0sum(316)%cmp, -4)
  call scale_one_tsum(T0sum(317)%cmp, -4)
  call scale_one_tsum(T0sum(318)%cmp, -4)
  call scale_one_tsum(T0sum(319)%cmp, -4)
  call scale_one_tsum(T0sum(320)%cmp, -4)
  call scale_one_tsum(T0sum(321)%cmp, -4)
  call scale_one_tsum(T0sum(322)%cmp, -4)
  call scale_one_tsum(T0sum(323)%cmp, -4)
  call scale_one_tsum(T0sum(324)%cmp, -4)
  call scale_one_tsum(T0sum(325)%cmp, -4)
  call scale_one_tsum(T0sum(326)%cmp, -4)
  call scale_one_tsum(T0sum(327)%cmp, -4)
  call scale_one_tsum(T0sum(328)%cmp, -4)
  call scale_one_tsum(T0sum(329)%cmp, -4)
  call scale_one_tsum(T0sum(330)%cmp, -4)
  call scale_one_tsum(T0sum(331)%cmp, -4)
  call scale_one_tsum(T0sum(332)%cmp, -4)
  call scale_one_tsum(T0sum(333)%cmp, -4)
  call scale_one_tsum(T0sum(334)%cmp, -4)
  call scale_one_tsum(T0sum(335)%cmp, -4)
  call scale_one_tsum(T0sum(336)%cmp, -4)
  call scale_one_tsum(T0sum(337)%cmp, -4)
  call scale_one_tsum(T0sum(338)%cmp, -4)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 32, 31 ]
  momenta_3 = [ 33, 30 ]
  momenta_4 = [ 34, 29 ]
  momenta_5 = [ 35, 28 ]
  momenta_6 = [ 37, 26 ]
  momenta_7 = [ 38, 25 ]
  momenta_8 = [ 39, 24 ]
  momenta_9 = [ 40, 23 ]
  momenta_10 = [ 41, 22 ]
  momenta_11 = [ 42, 21 ]
  momenta_12 = [ 43, 20 ]
  momenta_13 = [ 44, 19 ]
  momenta_14 = [ 45, 18 ]
  momenta_15 = [ 46, 17 ]
  momenta_16 = [ 47, 16 ]
  momenta_17 = [ 48, 15 ]
  momenta_18 = [ 49, 14 ]
  momenta_19 = [ 50, 13 ]
  momenta_20 = [ 51, 12 ]
  momenta_21 = [ 53, 10 ]
  momenta_22 = [ 54, 9 ]
  momenta_23 = [ 55, 8 ]
  momenta_24 = [ 56, 7 ]
  momenta_25 = [ 57, 6 ]
  momenta_26 = [ 58, 5 ]
  momenta_27 = [ 59, 4 ]
  momenta_28 = [ 60, 3 ]
  momenta_29 = [ 61, 2 ]
  momenta_30 = [ 62, 1 ]
  momenta_31 = [ 32, 1, 30 ]
  momenta_32 = [ 32, 2, 29 ]
  momenta_33 = [ 32, 3, 28 ]
  momenta_34 = [ 32, 5, 26 ]
  momenta_35 = [ 32, 6, 25 ]
  momenta_36 = [ 32, 7, 24 ]
  momenta_37 = [ 32, 8, 23 ]
  momenta_38 = [ 32, 9, 22 ]
  momenta_39 = [ 32, 10, 21 ]
  momenta_40 = [ 32, 12, 19 ]
  momenta_41 = [ 32, 13, 18 ]
  momenta_42 = [ 32, 14, 17 ]
  momenta_43 = [ 32, 15, 16 ]
  momenta_44 = [ 32, 19, 12 ]
  momenta_45 = [ 32, 21, 10 ]
  momenta_46 = [ 32, 22, 9 ]
  momenta_47 = [ 32, 23, 8 ]
  momenta_48 = [ 32, 25, 6 ]
  momenta_49 = [ 32, 26, 5 ]
  momenta_50 = [ 33, 2, 28 ]
  momenta_51 = [ 33, 4, 26 ]
  momenta_52 = [ 33, 6, 24 ]
  momenta_53 = [ 33, 8, 22 ]
  momenta_54 = [ 33, 10, 20 ]
  momenta_55 = [ 33, 12, 18 ]
  momenta_56 = [ 33, 14, 16 ]
  momenta_57 = [ 33, 18, 12 ]
  momenta_58 = [ 33, 20, 10 ]
  momenta_59 = [ 33, 22, 8 ]
  momenta_60 = [ 33, 24, 6 ]
  momenta_61 = [ 34, 1, 28 ]
  momenta_62 = [ 34, 4, 25 ]
  momenta_63 = [ 34, 5, 24 ]
  momenta_64 = [ 34, 8, 21 ]
  momenta_65 = [ 34, 9, 20 ]
  momenta_66 = [ 34, 12, 17 ]
  momenta_67 = [ 34, 13, 16 ]
  momenta_68 = [ 34, 17, 12 ]
  momenta_69 = [ 34, 20, 9 ]
  momenta_70 = [ 34, 21, 8 ]
  momenta_71 = [ 34, 24, 5 ]
  momenta_72 = [ 35, 4, 24 ]
  momenta_73 = [ 35, 12, 16 ]
  momenta_74 = [ 35, 16, 12 ]
  momenta_75 = [ 35, 20, 8 ]
  momenta_76 = [ 37, 2, 24 ]
  momenta_77 = [ 37, 8, 18 ]
  momenta_78 = [ 37, 10, 16 ]
  momenta_79 = [ 37, 16, 10 ]
  momenta_80 = [ 37, 18, 8 ]
  momenta_81 = [ 38, 1, 24 ]
  momenta_82 = [ 38, 8, 17 ]
  momenta_83 = [ 38, 9, 16 ]
  momenta_84 = [ 38, 16, 9 ]
  momenta_85 = [ 38, 17, 8 ]
  momenta_86 = [ 39, 8, 16 ]
  momenta_87 = [ 39, 16, 8 ]
  momenta_88 = [ 40, 1, 22 ]
  momenta_89 = [ 40, 2, 21 ]
  momenta_90 = [ 40, 3, 20 ]
  momenta_91 = [ 40, 4, 19 ]
  momenta_92 = [ 40, 5, 18 ]
  momenta_93 = [ 40, 6, 17 ]
  momenta_94 = [ 40, 7, 16 ]
  momenta_95 = [ 40, 17, 6 ]
  momenta_96 = [ 40, 18, 5 ]
  momenta_97 = [ 40, 19, 4 ]
  momenta_98 = [ 40, 21, 2 ]
  momenta_99 = [ 40, 22, 1 ]
  momenta_100 = [ 41, 2, 20 ]
  momenta_101 = [ 41, 4, 18 ]
  momenta_102 = [ 41, 6, 16 ]
  momenta_103 = [ 41, 16, 6 ]
  momenta_104 = [ 41, 18, 4 ]
  momenta_105 = [ 41, 20, 2 ]
  momenta_106 = [ 42, 1, 20 ]
  momenta_107 = [ 42, 4, 17 ]
  momenta_108 = [ 42, 5, 16 ]
  momenta_109 = [ 42, 16, 5 ]
  momenta_110 = [ 42, 17, 4 ]
  momenta_111 = [ 42, 20, 1 ]
  momenta_112 = [ 43, 4, 16 ]
  momenta_113 = [ 43, 16, 4 ]
  momenta_114 = [ 44, 1, 18 ]
  momenta_115 = [ 44, 2, 17 ]
  momenta_116 = [ 44, 3, 16 ]
  momenta_117 = [ 45, 2, 16 ]
  momenta_118 = [ 45, 16, 2 ]
  momenta_119 = [ 46, 1, 16 ]
  momenta_120 = [ 46, 16, 1 ]
  momenta_121 = [ 48, 1, 14 ]
  momenta_122 = [ 48, 2, 13 ]
  momenta_123 = [ 48, 3, 12 ]
  momenta_124 = [ 48, 5, 10 ]
  momenta_125 = [ 48, 6, 9 ]
  momenta_126 = [ 48, 7, 8 ]
  momenta_127 = [ 48, 8, 7 ]
  momenta_128 = [ 48, 9, 6 ]
  momenta_129 = [ 48, 10, 5 ]
  momenta_130 = [ 48, 12, 3 ]
  momenta_131 = [ 48, 13, 2 ]
  momenta_132 = [ 48, 14, 1 ]
  momenta_133 = [ 49, 2, 12 ]
  momenta_134 = [ 49, 4, 10 ]
  momenta_135 = [ 49, 6, 8 ]
  momenta_136 = [ 49, 8, 6 ]
  momenta_137 = [ 49, 10, 4 ]
  momenta_138 = [ 49, 12, 2 ]
  momenta_139 = [ 50, 1, 12 ]
  momenta_140 = [ 50, 4, 9 ]
  momenta_141 = [ 50, 5, 8 ]
  momenta_142 = [ 50, 8, 5 ]
  momenta_143 = [ 50, 9, 4 ]
  momenta_144 = [ 50, 12, 1 ]
  momenta_145 = [ 51, 4, 8 ]
  momenta_146 = [ 51, 8, 4 ]
  momenta_147 = [ 53, 2, 8 ]
  momenta_148 = [ 53, 8, 2 ]
  momenta_149 = [ 54, 1, 8 ]
  momenta_150 = [ 54, 8, 1 ]
  momenta_151 = [ 56, 1, 6 ]
  momenta_152 = [ 56, 2, 5 ]
  momenta_153 = [ 56, 3, 4 ]
  momenta_154 = [ 56, 4, 3 ]
  momenta_155 = [ 56, 5, 2 ]
  momenta_156 = [ 56, 6, 1 ]
  momenta_157 = [ 57, 2, 4 ]
  momenta_158 = [ 57, 4, 2 ]
  momenta_159 = [ 58, 1, 4 ]
  momenta_160 = [ 58, 4, 1 ]
  momenta_161 = [ 60, 1, 2 ]
  momenta_162 = [ 60, 2, 1 ]
  momenta_163 = [ 32, 1, 2, 28 ]
  momenta_164 = [ 32, 1, 4, 26 ]
  momenta_165 = [ 32, 1, 6, 24 ]
  momenta_166 = [ 32, 1, 8, 22 ]
  momenta_167 = [ 32, 1, 14, 16 ]
  momenta_168 = [ 32, 1, 18, 12 ]
  momenta_169 = [ 32, 1, 20, 10 ]
  momenta_170 = [ 32, 1, 22, 8 ]
  momenta_171 = [ 32, 1, 24, 6 ]
  momenta_172 = [ 32, 2, 1, 28 ]
  momenta_173 = [ 32, 2, 4, 25 ]
  momenta_174 = [ 32, 2, 5, 24 ]
  momenta_175 = [ 32, 2, 8, 21 ]
  momenta_176 = [ 32, 2, 13, 16 ]
  momenta_177 = [ 32, 2, 17, 12 ]
  momenta_178 = [ 32, 2, 20, 9 ]
  momenta_179 = [ 32, 2, 21, 8 ]
  momenta_180 = [ 32, 2, 24, 5 ]
  momenta_181 = [ 32, 3, 4, 24 ]
  momenta_182 = [ 32, 3, 12, 16 ]
  momenta_183 = [ 32, 3, 16, 12 ]
  momenta_184 = [ 32, 3, 20, 8 ]
  momenta_185 = [ 32, 5, 2, 24 ]
  momenta_186 = [ 32, 5, 8, 18 ]
  momenta_187 = [ 32, 5, 10, 16 ]
  momenta_188 = [ 32, 5, 16, 10 ]
  momenta_189 = [ 32, 5, 18, 8 ]
  momenta_190 = [ 32, 6, 1, 24 ]
  momenta_191 = [ 32, 6, 8, 17 ]
  momenta_192 = [ 32, 6, 9, 16 ]
  momenta_193 = [ 32, 6, 16, 9 ]
  momenta_194 = [ 32, 6, 17, 8 ]
  momenta_195 = [ 32, 7, 8, 16 ]
  momenta_196 = [ 32, 8, 1, 22 ]
  momenta_197 = [ 32, 8, 2, 21 ]
  momenta_198 = [ 32, 8, 4, 19 ]
  momenta_199 = [ 32, 8, 5, 18 ]
  momenta_200 = [ 32, 8, 6, 17 ]
  momenta_201 = [ 32, 8, 7, 16 ]
  momenta_202 = [ 32, 9, 4, 18 ]
  momenta_203 = [ 32, 9, 6, 16 ]
  momenta_204 = [ 32, 9, 16, 6 ]
  momenta_205 = [ 32, 10, 4, 17 ]
  momenta_206 = [ 32, 10, 5, 16 ]
  momenta_207 = [ 32, 10, 16, 5 ]
  momenta_208 = [ 32, 12, 1, 18 ]
  momenta_209 = [ 32, 12, 2, 17 ]
  momenta_210 = [ 32, 12, 3, 16 ]
  momenta_211 = [ 32, 13, 2, 16 ]
  momenta_212 = [ 32, 14, 1, 16 ]
  momenta_213 = [ 32, 19, 4, 8 ]
  momenta_214 = [ 32, 21, 2, 8 ]
  momenta_215 = [ 32, 22, 1, 8 ]
  momenta_216 = [ 33, 2, 4, 24 ]
  momenta_217 = [ 33, 2, 12, 16 ]
  momenta_218 = [ 33, 2, 16, 12 ]
  momenta_219 = [ 33, 2, 20, 8 ]
  momenta_220 = [ 33, 4, 2, 24 ]
  momenta_221 = [ 33, 4, 10, 16 ]
  momenta_222 = [ 33, 4, 16, 10 ]
  momenta_223 = [ 33, 4, 18, 8 ]
  momenta_224 = [ 33, 6, 8, 16 ]
  momenta_225 = [ 33, 6, 16, 8 ]
  momenta_226 = [ 33, 8, 2, 20 ]
  momenta_227 = [ 33, 8, 4, 18 ]
  momenta_228 = [ 33, 8, 6, 16 ]
  momenta_229 = [ 33, 8, 16, 6 ]
  momenta_230 = [ 33, 18, 4, 8 ]
  momenta_231 = [ 33, 20, 2, 8 ]
  momenta_232 = [ 34, 1, 4, 24 ]
  momenta_233 = [ 34, 1, 12, 16 ]
  momenta_234 = [ 34, 1, 16, 12 ]
  momenta_235 = [ 34, 1, 20, 8 ]
  momenta_236 = [ 34, 4, 1, 24 ]
  momenta_237 = [ 34, 4, 9, 16 ]
  momenta_238 = [ 34, 4, 16, 9 ]
  momenta_239 = [ 34, 4, 17, 8 ]
  momenta_240 = [ 34, 5, 8, 16 ]
  momenta_241 = [ 34, 5, 16, 8 ]
  momenta_242 = [ 34, 8, 1, 20 ]
  momenta_243 = [ 34, 8, 4, 17 ]
  momenta_244 = [ 34, 8, 5, 16 ]
  momenta_245 = [ 34, 8, 16, 5 ]
  momenta_246 = [ 34, 17, 4, 8 ]
  momenta_247 = [ 34, 20, 1, 8 ]
  momenta_248 = [ 35, 4, 8, 16 ]
  momenta_249 = [ 35, 16, 4, 8 ]
  momenta_250 = [ 37, 2, 8, 16 ]
  momenta_251 = [ 37, 8, 2, 16 ]
  momenta_252 = [ 37, 16, 2, 8 ]
  momenta_253 = [ 38, 1, 8, 16 ]
  momenta_254 = [ 38, 8, 1, 16 ]
  momenta_255 = [ 38, 16, 1, 8 ]
  momenta_256 = [ 40, 1, 2, 20 ]
  momenta_257 = [ 40, 1, 4, 18 ]
  momenta_258 = [ 40, 1, 6, 16 ]
  momenta_259 = [ 40, 1, 16, 6 ]
  momenta_260 = [ 40, 1, 18, 4 ]
  momenta_261 = [ 40, 1, 20, 2 ]
  momenta_262 = [ 40, 2, 1, 20 ]
  momenta_263 = [ 40, 2, 4, 17 ]
  momenta_264 = [ 40, 2, 5, 16 ]
  momenta_265 = [ 40, 2, 16, 5 ]
  momenta_266 = [ 40, 2, 17, 4 ]
  momenta_267 = [ 40, 2, 20, 1 ]
  momenta_268 = [ 40, 3, 16, 4 ]
  momenta_269 = [ 40, 4, 1, 18 ]
  momenta_270 = [ 40, 4, 2, 17 ]
  momenta_271 = [ 40, 4, 3, 16 ]
  momenta_272 = [ 40, 5, 2, 16 ]
  momenta_273 = [ 40, 5, 16, 2 ]
  momenta_274 = [ 40, 6, 1, 16 ]
  momenta_275 = [ 40, 6, 16, 1 ]
  momenta_276 = [ 40, 17, 4, 2 ]
  momenta_277 = [ 41, 2, 4, 16 ]
  momenta_278 = [ 41, 2, 16, 4 ]
  momenta_279 = [ 41, 4, 2, 16 ]
  momenta_280 = [ 41, 4, 16, 2 ]
  momenta_281 = [ 41, 16, 4, 2 ]
  momenta_282 = [ 42, 1, 4, 16 ]
  momenta_283 = [ 42, 1, 16, 4 ]
  momenta_284 = [ 42, 4, 1, 16 ]
  momenta_285 = [ 42, 4, 16, 1 ]
  momenta_286 = [ 44, 1, 2, 16 ]
  momenta_287 = [ 44, 2, 1, 16 ]
  momenta_288 = [ 48, 1, 2, 12 ]
  momenta_289 = [ 48, 1, 4, 10 ]
  momenta_290 = [ 48, 1, 6, 8 ]
  momenta_291 = [ 48, 1, 8, 6 ]
  momenta_292 = [ 48, 2, 1, 12 ]
  momenta_293 = [ 48, 2, 4, 9 ]
  momenta_294 = [ 48, 2, 5, 8 ]
  momenta_295 = [ 48, 2, 8, 5 ]
  momenta_296 = [ 48, 3, 4, 8 ]
  momenta_297 = [ 48, 5, 2, 8 ]
  momenta_298 = [ 48, 5, 8, 2 ]
  momenta_299 = [ 48, 6, 1, 8 ]
  momenta_300 = [ 48, 6, 8, 1 ]
  momenta_301 = [ 48, 8, 1, 6 ]
  momenta_302 = [ 48, 8, 2, 5 ]
  momenta_303 = [ 48, 8, 4, 3 ]
  momenta_304 = [ 48, 8, 5, 2 ]
  momenta_305 = [ 48, 8, 6, 1 ]
  momenta_306 = [ 48, 9, 4, 2 ]
  momenta_307 = [ 48, 10, 4, 1 ]
  momenta_308 = [ 48, 12, 1, 2 ]
  momenta_309 = [ 48, 12, 2, 1 ]
  momenta_310 = [ 49, 2, 4, 8 ]
  momenta_311 = [ 49, 4, 2, 8 ]
  momenta_312 = [ 49, 8, 2, 4 ]
  momenta_313 = [ 49, 8, 4, 2 ]
  momenta_314 = [ 50, 1, 4, 8 ]
  momenta_315 = [ 50, 4, 1, 8 ]
  momenta_316 = [ 50, 8, 1, 4 ]
  momenta_317 = [ 50, 8, 4, 1 ]
  momenta_318 = [ 56, 1, 2, 4 ]
  momenta_319 = [ 56, 1, 4, 2 ]
  momenta_320 = [ 56, 2, 1, 4 ]
  momenta_321 = [ 56, 2, 4, 1 ]
  momenta_322 = [ 56, 4, 1, 2 ]
  momenta_323 = [ 56, 4, 2, 1 ]
  momenta_324 = [ 32, 1, 2, 4, 24 ]
  momenta_325 = [ 32, 1, 2, 12, 16 ]
  momenta_326 = [ 32, 1, 2, 20, 8 ]
  momenta_327 = [ 32, 1, 4, 2, 24 ]
  momenta_328 = [ 32, 1, 4, 10, 16 ]
  momenta_329 = [ 32, 1, 4, 18, 8 ]
  momenta_330 = [ 32, 1, 6, 8, 16 ]
  momenta_331 = [ 32, 1, 8, 6, 16 ]
  momenta_332 = [ 32, 1, 8, 16, 6 ]
  momenta_333 = [ 32, 1, 18, 4, 8 ]
  momenta_334 = [ 32, 1, 20, 2, 8 ]
  momenta_335 = [ 32, 2, 1, 4, 24 ]
  momenta_336 = [ 32, 2, 1, 12, 16 ]
  momenta_337 = [ 32, 2, 1, 20, 8 ]
  momenta_338 = [ 32, 2, 4, 1, 24 ]
  momenta_339 = [ 32, 2, 4, 9, 16 ]
  momenta_340 = [ 32, 2, 4, 17, 8 ]
  momenta_341 = [ 32, 2, 5, 8, 16 ]
  momenta_342 = [ 32, 2, 8, 5, 16 ]
  momenta_343 = [ 32, 2, 8, 16, 5 ]
  momenta_344 = [ 32, 2, 17, 4, 8 ]
  momenta_345 = [ 32, 2, 20, 1, 8 ]
  momenta_346 = [ 32, 3, 4, 8, 16 ]
  momenta_347 = [ 32, 3, 16, 4, 8 ]
  momenta_348 = [ 32, 5, 2, 8, 16 ]
  momenta_349 = [ 32, 5, 8, 2, 16 ]
  momenta_350 = [ 32, 5, 16, 2, 8 ]
  momenta_351 = [ 32, 6, 1, 8, 16 ]
  momenta_352 = [ 32, 6, 8, 1, 16 ]
  momenta_353 = [ 32, 6, 16, 1, 8 ]
  momenta_354 = [ 32, 8, 1, 4, 18 ]
  momenta_355 = [ 32, 8, 1, 6, 16 ]
  momenta_356 = [ 32, 8, 2, 4, 17 ]
  momenta_357 = [ 32, 8, 2, 5, 16 ]
  momenta_358 = [ 32, 8, 4, 1, 18 ]
  momenta_359 = [ 32, 8, 4, 2, 17 ]
  momenta_360 = [ 32, 8, 4, 3, 16 ]
  momenta_361 = [ 32, 8, 5, 2, 16 ]
  momenta_362 = [ 32, 8, 6, 1, 16 ]
  momenta_363 = [ 32, 9, 4, 2, 16 ]
  momenta_364 = [ 32, 10, 4, 1, 16 ]
  momenta_365 = [ 32, 12, 1, 2, 16 ]
  momenta_366 = [ 32, 12, 2, 1, 16 ]
  momenta_367 = [ 33, 2, 4, 8, 16 ]
  momenta_368 = [ 33, 2, 16, 4, 8 ]
  momenta_369 = [ 33, 4, 2, 8, 16 ]
  momenta_370 = [ 33, 4, 16, 2, 8 ]
  momenta_371 = [ 34, 1, 4, 8, 16 ]
  momenta_372 = [ 34, 1, 16, 4, 8 ]
  momenta_373 = [ 34, 4, 1, 8, 16 ]
  momenta_374 = [ 34, 4, 16, 1, 8 ]
  momenta_375 = [ 40, 1, 2, 16, 4 ]
  momenta_376 = [ 40, 1, 4, 2, 16 ]
  momenta_377 = [ 40, 1, 4, 16, 2 ]
  momenta_378 = [ 40, 1, 16, 4, 2 ]
  momenta_379 = [ 40, 2, 1, 16, 4 ]
  momenta_380 = [ 40, 2, 4, 1, 16 ]
  momenta_381 = [ 40, 2, 4, 16, 1 ]
  momenta_382 = [ 40, 4, 1, 2, 16 ]
  momenta_383 = [ 40, 4, 2, 1, 16 ]
  momenta_384 = [ 48, 1, 2, 4, 8 ]
  momenta_385 = [ 48, 1, 4, 2, 8 ]
  momenta_386 = [ 48, 2, 1, 4, 8 ]
  momenta_387 = [ 48, 2, 4, 1, 8 ]
  momenta_388 = [ 48, 8, 1, 4, 2 ]
  momenta_389 = [ 48, 8, 2, 4, 1 ]
  momenta_390 = [ 48, 8, 4, 1, 2 ]
  momenta_391 = [ 48, 8, 4, 2, 1 ]
  momenta_392 = [ 32, 1, 2, 4, 8, 16 ]
  momenta_393 = [ 32, 1, 2, 16, 4, 8 ]
  momenta_394 = [ 32, 1, 4, 2, 8, 16 ]
  momenta_395 = [ 32, 1, 4, 16, 2, 8 ]
  momenta_396 = [ 32, 2, 1, 4, 8, 16 ]
  momenta_397 = [ 32, 2, 1, 16, 4, 8 ]
  momenta_398 = [ 32, 2, 4, 1, 8, 16 ]
  momenta_399 = [ 32, 2, 4, 16, 1, 8 ]
  momenta_400 = [ 32, 8, 1, 4, 2, 16 ]
  momenta_401 = [ 32, 8, 2, 4, 1, 16 ]
  momenta_402 = [ 32, 8, 4, 1, 2, 16 ]
  momenta_403 = [ 32, 8, 4, 2, 1, 16 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMT, 0 ]
  masses2_4 = [ nMB, nMB ]
  masses2_5 = [ nMT, nMT ]
  masses2_6 = [ 0, 0, 0 ]
  masses2_7 = [ nMB, nMB, nMB ]
  masses2_8 = [ nMT, nMT, nMT ]
  masses2_9 = [ 0, 0, 0, 0 ]
  masses2_10 = [ 0, 0, 0, 0, 0 ]
  masses2_11 = [ 0, 0, 0, 0, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_external_ppwajj_uuuxdxaw_1, only: channel_number_ppwajj_uuuxdxaw_1
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call channel_on(channel_number_ppwajj_uuuxdxaw_1)
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
sbarray_2 = [1, 16, 17, 18, 19, 6, 7, 8, 9, 20, 21, 22, 23, 24, 25]
sbarray_3 = [26, 27, 28, 29, 30, 31, 32, 33, 34, 20, 35, 36, 37, 38, 39]
sbarray_4 = [40, 41, 42, 43, 44, 45, 46, 47, 48, 10, 49, 50, 51, 52, 53]
sbarray_5 = [54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68]
sbarray_6 = [69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 13, 81, 82]
sbarray_7 = [83, 84, 56, 85, 86, 87, 60, 88, 89, 63, 90, 91, 66, 67, 92]
sbarray_8 = [69, 93, 94, 95, 96, 74, 75, 76, 77, 97, 98, 99, 23, 100, 101]
sbarray_9 = [102, 55, 103, 104, 105, 59, 106, 107, 108, 63, 64, 65, 109, 110, 111]
sbarray_10 = [112, 70, 113, 114, 115, 74, 116, 117, 118, 78, 79, 80, 51, 119, 120]
sbarray_11 = [121, 84, 122, 123, 120, 87, 124, 125, 126, 63, 90, 91, 127, 128, 129]
sbarray_12 = [130, 93, 131, 132, 133, 74, 134, 135, 136, 97, 98, 99, 37, 137, 105]
sbarray_13 = [138, 139, 140, 141, 15]
sbarray_14 = [142, 139, 143, 144, 25]
sbarray_15 = [145, 146, 147, 104, 39]
sbarray_16 = [148, 149, 150, 123, 53]
sbarray_17 = [151, 152, 153, 154, 68]
sbarray_18 = [155, 156, 157, 158, 82]
sbarray_19 = [159, 160, 161, 154, 92]
sbarray_20 = [162, 156, 163, 164, 101]
sbarray_21 = [165, 166, 153, 167, 111]
sbarray_22 = [168, 169, 157, 170, 120]
sbarray_23 = [171, 172, 161, 173, 129]
sbarray_24 = [174, 175, 163, 176, 105]
sbarray_25 = [1, 2, 3, 4, 5]
sbarray_26 = [1, 6, 7, 8, 9]
sbarray_27 = [2, 6, 10, 11, 12]
sbarray_28 = [3, 7, 10, 13, 14]
sbarray_29 = [1, 16, 17, 18, 19]
sbarray_30 = [16, 6, 20, 21, 22]
sbarray_31 = [17, 7, 20, 23, 24]
sbarray_32 = [26, 27, 28, 29, 30]
sbarray_33 = [26, 31, 32, 33, 34]
sbarray_34 = [27, 31, 20, 35, 36]
sbarray_35 = [28, 32, 20, 37, 38]
sbarray_36 = [40, 41, 42, 43, 44]
sbarray_37 = [40, 45, 46, 47, 48]
sbarray_38 = [41, 45, 10, 49, 50]
sbarray_39 = [42, 46, 10, 51, 52]
sbarray_40 = [54, 55, 56, 57, 58]
sbarray_41 = [54, 59, 60, 61, 62]
sbarray_42 = [55, 59, 63, 64, 65]
sbarray_43 = [56, 60, 63, 66, 67]
sbarray_44 = [69, 70, 71, 72, 73]
sbarray_45 = [69, 74, 75, 76, 77]
sbarray_46 = [70, 74, 78, 79, 80]
sbarray_47 = [71, 75, 78, 13, 81]
sbarray_48 = [83, 84, 56, 85, 86]
sbarray_49 = [83, 87, 60, 88, 89]
sbarray_50 = [84, 87, 63, 90, 91]
sbarray_51 = [69, 93, 94, 95, 96]
sbarray_52 = [93, 74, 97, 98, 99]
sbarray_53 = [94, 75, 97, 23, 100]
sbarray_54 = [102, 55, 103, 104, 105]
sbarray_55 = [102, 59, 106, 107, 108]
sbarray_56 = [103, 106, 63, 109, 110]
sbarray_57 = [112, 70, 113, 114, 115]
sbarray_58 = [112, 74, 116, 117, 118]
sbarray_59 = [113, 116, 78, 51, 119]
sbarray_60 = [121, 84, 122, 123, 120]
sbarray_61 = [121, 87, 124, 125, 126]
sbarray_62 = [122, 124, 63, 127, 128]
sbarray_63 = [130, 93, 131, 132, 133]
sbarray_64 = [130, 74, 134, 135, 136]
sbarray_65 = [131, 134, 97, 37, 137]
sbarray_66 = [123, 125, 90, 127, 129]
sbarray_67 = [85, 88, 90, 66, 92]
sbarray_68 = [104, 107, 64, 109, 111]
sbarray_69 = [57, 61, 64, 66, 68]
sbarray_70 = [72, 76, 79, 13, 82]
sbarray_71 = [95, 76, 98, 23, 101]
sbarray_72 = [132, 135, 98, 37, 105]
sbarray_73 = [114, 117, 79, 51, 120]
sbarray_74 = [177, 178, 147, 179, 5]
sbarray_75 = [180, 59, 134, 181, 182]
sbarray_76 = [183, 184, 185, 186, 187]
sbarray_77 = [188, 124, 78, 186, 189]
sbarray_78 = [190, 87, 116, 191, 192]
sbarray_79 = [193, 194, 195, 196, 197]
sbarray_80 = [198, 106, 97, 196, 199]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_262, masses2_9, T0sum(1), M2,[141], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_256, masses2_9, T0sum(2), M2,[144], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_257, masses2_9, T0sum(3), M2,[104], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_263, masses2_9, T0sum(4), M2,[123], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_172, masses2_9, T0sum(5), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_163, masses2_9, T0sum(6), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_164, masses2_9, T0sum(7), M2,[37], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_173, masses2_9, T0sum(8), M2,[51], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_317, masses2_9, T0sum(9), M2,[68], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_303, masses2_9, T0sum(10), M2,[154], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_198, masses2_9, T0sum(11), M2,[66], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_320, masses2_9, T0sum(12), M2,[82], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_292, masses2_9, T0sum(13), M2,[158], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_313, masses2_9, T0sum(14), M2,[92], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_318, masses2_9, T0sum(15), M2,[101], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_288, masses2_9, T0sum(16), M2,[164], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_316, masses2_9, T0sum(17), M2,[111], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_301, masses2_9, T0sum(18), M2,[167], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_196, masses2_9, T0sum(19), M2,[109], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_321, masses2_9, T0sum(20), M2,[171], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_293, masses2_9, T0sum(21), M2,[170], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_312, masses2_9, T0sum(22), M2,[129], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_302, masses2_9, T0sum(23), M2,[173], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_197, masses2_9, T0sum(24), M2,[127], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_319, masses2_9, T0sum(25), M2,[165], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_289, masses2_9, T0sum(26), M2,[176], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_283, masses2_9, T0sum(27), M2,[138], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_234, masses2_9, T0sum(28), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_268, masses2_9, T0sum(29), M2,[139], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_183, masses2_9, T0sum(30), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_266, masses2_9, T0sum(31), M2,[140], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_177, masses2_9, T0sum(32), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_278, masses2_9, T0sum(33), M2,[142], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_218, masses2_9, T0sum(34), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_260, masses2_9, T0sum(35), M2,[143], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_168, masses2_9, T0sum(36), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_280, masses2_9, T0sum(37), M2,[145], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_222, masses2_9, T0sum(38), M2,[29], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_273, masses2_9, T0sum(39), M2,[146], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_188, masses2_9, T0sum(40), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_261, masses2_9, T0sum(41), M2,[147], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_169, masses2_9, T0sum(42), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_285, masses2_9, T0sum(43), M2,[148], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_238, masses2_9, T0sum(44), M2,[43], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_275, masses2_9, T0sum(45), M2,[149], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_193, masses2_9, T0sum(46), M2,[47], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_267, masses2_9, T0sum(47), M2,[150], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_178, masses2_9, T0sum(48), M2,[49], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_322, masses2_9, T0sum(49), M2,[151], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_269, masses2_9, T0sum(50), M2,[57], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_308, masses2_9, T0sum(51), M2,[152], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_208, masses2_9, T0sum(52), M2,[61], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_304, masses2_9, T0sum(53), M2,[153], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_199, masses2_9, T0sum(54), M2,[64], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_314, masses2_9, T0sum(55), M2,[155], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_232, masses2_9, T0sum(56), M2,[72], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_296, masses2_9, T0sum(57), M2,[156], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_181, masses2_9, T0sum(58), M2,[76], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_294, masses2_9, T0sum(59), M2,[157], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_174, masses2_9, T0sum(60), M2,[79], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_323, masses2_9, T0sum(61), M2,[159], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_270, masses2_9, T0sum(62), M2,[85], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_309, masses2_9, T0sum(63), M2,[160], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_209, masses2_9, T0sum(64), M2,[88], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_305, masses2_9, T0sum(65), M2,[161], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_200, masses2_9, T0sum(66), M2,[90], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_310, masses2_9, T0sum(67), M2,[162], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_216, masses2_9, T0sum(68), M2,[95], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_290, masses2_9, T0sum(69), M2,[163], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_165, masses2_9, T0sum(70), M2,[98], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_306, masses2_9, T0sum(71), M2,[166], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_202, masses2_9, T0sum(72), M2,[107], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_315, masses2_9, T0sum(73), M2,[168], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_236, masses2_9, T0sum(74), M2,[114], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_299, masses2_9, T0sum(75), M2,[169], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_190, masses2_9, T0sum(76), M2,[117], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_307, masses2_9, T0sum(77), M2,[172], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_205, masses2_9, T0sum(78), M2,[125], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_311, masses2_9, T0sum(79), M2,[174], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_220, masses2_9, T0sum(80), M2,[132], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_297, masses2_9, T0sum(81), M2,[175], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_185, masses2_9, T0sum(82), M2,[135], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_259, masses2_9, T0sum(83), M2,[179], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_298, masses2_9, T0sum(84), M2,[182], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_186, masses2_9, T0sum(85), M2,[181], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_250, masses2_9, T0sum(86), M2,[130], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_175, masses2_9, T0sum(87), M2,[186], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_295, masses2_9, T0sum(88), M2,[189], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_300, masses2_9, T0sum(89), M2,[192], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_191, masses2_9, T0sum(90), M2,[191], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_253, masses2_9, T0sum(91), M2,[112], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_166, masses2_9, T0sum(92), M2,[196], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_291, masses2_9, T0sum(93), M2,[199], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_287, masses2_9, T0sum(94), M2,[83], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_286, masses2_9, T0sum(95), M2,[54], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_282, masses2_9, T0sum(96), M2,[39], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_277, masses2_9, T0sum(97), M2,[53], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_249, masses2_9, T0sum(98), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_246, masses2_9, T0sum(99), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_235, masses2_9, T0sum(100), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_213, masses2_9, T0sum(101), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_184, masses2_9, T0sum(102), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_179, masses2_9, T0sum(103), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_230, masses2_9, T0sum(104), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_219, masses2_9, T0sum(105), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_170, masses2_9, T0sum(106), M2,[20], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_252, masses2_9, T0sum(107), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_231, masses2_9, T0sum(108), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_223, masses2_9, T0sum(109), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_214, masses2_9, T0sum(110), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_189, masses2_9, T0sum(111), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_255, masses2_9, T0sum(112), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_247, masses2_9, T0sum(113), M2,[41], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_239, masses2_9, T0sum(114), M2,[42], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_215, masses2_9, T0sum(115), M2,[45], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_194, masses2_9, T0sum(116), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_272, masses2_9, T0sum(117), M2,[55], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_271, masses2_9, T0sum(118), M2,[56], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_211, masses2_9, T0sum(119), M2,[59], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_210, masses2_9, T0sum(120), M2,[60], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_201, masses2_9, T0sum(121), M2,[63], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_248, masses2_9, T0sum(122), M2,[69], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_240, masses2_9, T0sum(123), M2,[70], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_233, masses2_9, T0sum(124), M2,[71], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_195, masses2_9, T0sum(125), M2,[74], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_182, masses2_9, T0sum(126), M2,[75], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_176, masses2_9, T0sum(127), M2,[78], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_274, masses2_9, T0sum(128), M2,[84], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_212, masses2_9, T0sum(129), M2,[87], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_224, masses2_9, T0sum(130), M2,[93], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_217, masses2_9, T0sum(131), M2,[94], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_167, masses2_9, T0sum(132), M2,[97], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_279, masses2_9, T0sum(133), M2,[102], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_258, masses2_9, T0sum(134), M2,[103], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_203, masses2_9, T0sum(135), M2,[106], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_237, masses2_9, T0sum(136), M2,[113], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_192, masses2_9, T0sum(137), M2,[116], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_284, masses2_9, T0sum(138), M2,[121], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_264, masses2_9, T0sum(139), M2,[122], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_206, masses2_9, T0sum(140), M2,[124], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_221, masses2_9, T0sum(141), M2,[131], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_187, masses2_9, T0sum(142), M2,[134], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_281, masses2_9, T0sum(143), M2,[177], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_276, masses2_9, T0sum(144), M2,[178], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_251, masses2_9, T0sum(145), M2,[180], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_245, masses2_9, T0sum(146), M2,[183], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_207, masses2_9, T0sum(147), M2,[184], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_180, masses2_9, T0sum(148), M2,[185], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_244, masses2_9, T0sum(149), M2,[188], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_254, masses2_9, T0sum(150), M2,[190], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_229, masses2_9, T0sum(151), M2,[193], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_204, masses2_9, T0sum(152), M2,[194], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_171, masses2_9, T0sum(153), M2,[195], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_228, masses2_9, T0sum(154), M2,[198], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_243, masses2_9, T0sum(155), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_227, masses2_9, T0sum(156), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_226, masses2_9, T0sum(157), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_242, masses2_9, T0sum(158), M2,[41], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_241, masses2_9, T0sum(159), M2,[183], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_225, masses2_9, T0sum(160), M2,[193], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_265, masses2_9, T0sum(161), M2,[146], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_108, masses2_6, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_102, masses2_6, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_142, masses2_6, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_152, masses2_6, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_136, masses2_6, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_151, masses2_6, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_156, masses2_6, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_155, masses2_6, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_141, masses2_6, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_147, masses2_6, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_148, masses2_6, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_135, masses2_6, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_149, masses2_6, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_150, masses2_6, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_79, masses2_6, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_45, masses2_6, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_34, masses2_6, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_84, masses2_6, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_46, masses2_6, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_35, masses2_6, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_92, masses2_6, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_41, masses2_6, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_37, masses2_6, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_63, masses2_6, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_36, masses2_6, T0sum(186), M2)
  call TI_call_OL(0,0, momenta_32, masses2_6, T0sum(187), M2)
  call TI_call_OL(0,0, momenta_93, masses2_6, T0sum(188), M2)
  call TI_call_OL(0,0, momenta_42, masses2_6, T0sum(189), M2)
  call TI_call_OL(0,0, momenta_52, masses2_6, T0sum(190), M2)
  call TI_call_OL(0,0, momenta_31, masses2_6, T0sum(191), M2)
  call TI_call_OL(0,0, momenta_81, masses2_6, T0sum(192), M2)
  call TI_call_OL(0,0, momenta_76, masses2_6, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_77, masses2_6, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_64, masses2_6, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_39, masses2_6, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_89, masses2_6, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_82, masses2_6, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_53, masses2_6, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_38, masses2_6, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_88, masses2_6, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_106, masses2_6, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_100, masses2_6, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_159, masses2_6, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_157, masses2_6, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_127, masses2_6, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_122, masses2_6, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_121, masses2_6, T0sum(208), M2)
  call TI_call_OL(0,0, momenta_125, masses2_6, T0sum(209), M2)
  call TI_call_OL(0,0, momenta_124, masses2_6, T0sum(210), M2)
  call TI_call_OL(0,0, momenta_128, masses2_6, T0sum(211), M2)
  call TI_call_OL(0,0, momenta_129, masses2_6, T0sum(212), M2)
  call TI_call_OL(0,0, momenta_118, masses2_6, T0sum(213), M2)
  call TI_call_OL(0,0, momenta_98, masses2_6, T0sum(214), M2)
  call TI_call_OL(0,0, momenta_120, masses2_6, T0sum(215), M2)
  call TI_call_OL(0,0, momenta_99, masses2_6, T0sum(216), M2)
  call TI_call_OL(0,0, momenta_131, masses2_6, T0sum(217), M2)
  call TI_call_OL(0,0, momenta_126, masses2_6, T0sum(218), M2)
  call TI_call_OL(0,0, momenta_132, masses2_6, T0sum(219), M2)
  call TI_call_OL(0,0, momenta_158, masses2_6, T0sum(220), M2)
  call TI_call_OL(0,0, momenta_101, masses2_6, T0sum(221), M2)
  call TI_call_OL(0,0, momenta_160, masses2_6, T0sum(222), M2)
  call TI_call_OL(0,0, momenta_107, masses2_6, T0sum(223), M2)
  call TI_call_OL(0,0, momenta_86, masses2_6, T0sum(224), M2)
  call TI_call_OL(0,0, momenta_78, masses2_6, T0sum(225), M2)
  call TI_call_OL(0,0, momenta_83, masses2_6, T0sum(226), M2)
  call TI_call_OL(0,0, momenta_117, masses2_6, T0sum(227), M2)
  call TI_call_OL(0,0, momenta_119, masses2_6, T0sum(228), M2)
  call TI_call_OL(0,0, momenta_162, masses2_6, T0sum(229), M2)
  call TI_call_OL(0,0, momenta_90, masses2_6, T0sum(230), M2)
  call TI_call_OL(0,0, momenta_161, masses2_6, T0sum(231), M2)
  call TI_call_OL(0,0, momenta_61, masses2_6, T0sum(232), M2)
  call TI_call_OL(0,0, momenta_33, masses2_6, T0sum(233), M2)
  call TI_call_OL(0,0, momenta_50, masses2_6, T0sum(234), M2)
  call TI_call_OL(0,0, momenta_51, masses2_6, T0sum(235), M2)
  call TI_call_OL(0,0, momenta_62, masses2_6, T0sum(236), M2)
  call TI_call_OL(0,0, momenta_146, masses2_6, T0sum(237), M2)
  call TI_call_OL(0,0, momenta_144, masses2_6, T0sum(238), M2)
  call TI_call_OL(0,0, momenta_154, masses2_6, T0sum(239), M2)
  call TI_call_OL(0,0, momenta_130, masses2_6, T0sum(240), M2)
  call TI_call_OL(0,0, momenta_91, masses2_6, T0sum(241), M2)
  call TI_call_OL(0,0, momenta_40, masses2_6, T0sum(242), M2)
  call TI_call_OL(0,0, momenta_153, masses2_6, T0sum(243), M2)
  call TI_call_OL(0,0, momenta_139, masses2_6, T0sum(244), M2)
  call TI_call_OL(0,0, momenta_123, masses2_6, T0sum(245), M2)
  call TI_call_OL(0,0, momenta_138, masses2_6, T0sum(246), M2)
  call TI_call_OL(0,0, momenta_133, masses2_6, T0sum(247), M2)
  call TI_call_OL(0,0, momenta_143, masses2_6, T0sum(248), M2)
  call TI_call_OL(0,0, momenta_140, masses2_6, T0sum(249), M2)
  call TI_call_OL(0,0, momenta_137, masses2_6, T0sum(250), M2)
  call TI_call_OL(0,0, momenta_134, masses2_6, T0sum(251), M2)
  call TI_call_OL(0,0, momenta_113, masses2_6, T0sum(252), M2)
  call TI_call_OL(0,0, momenta_110, masses2_6, T0sum(253), M2)
  call TI_call_OL(0,0, momenta_74, masses2_6, T0sum(254), M2)
  call TI_call_OL(0,0, momenta_68, masses2_6, T0sum(255), M2)
  call TI_call_OL(0,0, momenta_116, masses2_6, T0sum(256), M2)
  call TI_call_OL(0,0, momenta_97, masses2_6, T0sum(257), M2)
  call TI_call_OL(0,0, momenta_44, masses2_6, T0sum(258), M2)
  call TI_call_OL(0,0, momenta_115, masses2_6, T0sum(259), M2)
  call TI_call_OL(0,0, momenta_104, masses2_6, T0sum(260), M2)
  call TI_call_OL(0,0, momenta_57, masses2_6, T0sum(261), M2)
  call TI_call_OL(0,0, momenta_114, masses2_6, T0sum(262), M2)
  call TI_call_OL(0,0, momenta_112, masses2_6, T0sum(263), M2)
  call TI_call_OL(0,0, momenta_105, masses2_6, T0sum(264), M2)
  call TI_call_OL(0,0, momenta_58, masses2_6, T0sum(265), M2)
  call TI_call_OL(0,0, momenta_111, masses2_6, T0sum(266), M2)
  call TI_call_OL(0,0, momenta_69, masses2_6, T0sum(267), M2)
  call TI_call_OL(0,0, momenta_145, masses2_6, T0sum(268), M2)
  call TI_call_OL(0,0, momenta_72, masses2_6, T0sum(269), M2)
  call TI_call_OL(0,0, momenta_103, masses2_6, T0sum(270), M2)
  call TI_call_OL(0,0, momenta_95, masses2_6, T0sum(271), M2)
  call TI_call_OL(0,0, momenta_75, masses2_6, T0sum(272), M2)
  call TI_call_OL(0,0, momenta_70, masses2_6, T0sum(273), M2)
  call TI_call_OL(0,0, momenta_47, masses2_6, T0sum(274), M2)
  call TI_call_OL(0,0, momenta_59, masses2_6, T0sum(275), M2)
  call TI_call_OL(0,0, momenta_80, masses2_6, T0sum(276), M2)
  call TI_call_OL(0,0, momenta_85, masses2_6, T0sum(277), M2)
  call TI_call_OL(0,0, momenta_94, masses2_6, T0sum(278), M2)
  call TI_call_OL(0,0, momenta_43, masses2_6, T0sum(279), M2)
  call TI_call_OL(0,0, momenta_73, masses2_6, T0sum(280), M2)
  call TI_call_OL(0,0, momenta_67, masses2_6, T0sum(281), M2)
  call TI_call_OL(0,0, momenta_56, masses2_6, T0sum(282), M2)
  call TI_call_OL(0,0, momenta_109, masses2_6, T0sum(283), M2)
  call TI_call_OL(0,0, momenta_71, masses2_6, T0sum(284), M2)
  call TI_call_OL(0,0, momenta_49, masses2_6, T0sum(285), M2)
  call TI_call_OL(0,0, momenta_60, masses2_6, T0sum(286), M2)
  call TI_call_OL(0,0, momenta_48, masses2_6, T0sum(287), M2)
  call TI_call_OL(0,0, momenta_66, masses2_6, T0sum(288), M2)
  call TI_call_OL(0,0, momenta_55, masses2_6, T0sum(289), M2)
  call TI_call_OL(0,0, momenta_54, masses2_6, T0sum(290), M2)
  call TI_call_OL(0,0, momenta_65, masses2_6, T0sum(291), M2)
  call TI_call_OL(0,0, momenta_87, masses2_6, T0sum(292), M2)
  call TI_call_OL(0,0, momenta_96, masses2_6, T0sum(293), M2)
  call TI_call_OL(0,0, momenta_108, masses2_8, T0sum(294), M2)
  call TI_call_OL(0,0, momenta_108, masses2_7, T0sum(295), M2)
  call TI_call_OL(0,0, momenta_102, masses2_8, T0sum(296), M2)
  call TI_call_OL(0,0, momenta_102, masses2_7, T0sum(297), M2)
  call TI_call_OL(0,0, momenta_26, masses2_1, T0sum(298), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(299), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(300), M2)
  call TI_call_OL(0,0, momenta_25, masses2_1, T0sum(301), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(302), M2)
  call TI_call_OL(0,0, momenta_23, masses2_1, T0sum(303), M2)
  call TI_call_OL(0,0, momenta_19, masses2_1, T0sum(304), M2)
  call TI_call_OL(0,0, momenta_29, masses2_1, T0sum(305), M2)
  call TI_call_OL(0,0, momenta_24, masses2_1, T0sum(306), M2)
  call TI_call_OL(0,0, momenta_18, masses2_1, T0sum(307), M2)
  call TI_call_OL(0,0, momenta_30, masses2_1, T0sum(308), M2)
  call TI_call_OL(0,0, momenta_21, masses2_1, T0sum(309), M2)
  call TI_call_OL(0,0, momenta_22, masses2_1, T0sum(310), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(311), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(312), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(313), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(314), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(315), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(316), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(317), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(318), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(319), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(320), M2)
  call TI_call_OL(0,0, momenta_27, masses2_1, T0sum(321), M2)
  call TI_call_OL(0,0, momenta_17, masses2_1, T0sum(322), M2)
  call TI_call_OL(0,0, momenta_26, masses2_5, T0sum(323), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(324), M2)
  call TI_call_OL(0,0, momenta_16, masses2_5, T0sum(325), M2)
  call TI_call_OL(0,0, momenta_11, masses2_5, T0sum(326), M2)
  call TI_call_OL(0,0, momenta_26, masses2_4, T0sum(327), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(328), M2)
  call TI_call_OL(0,0, momenta_16, masses2_4, T0sum(329), M2)
  call TI_call_OL(0,0, momenta_11, masses2_4, T0sum(330), M2)
  call TI_call_OL(0,0, momenta_25, masses2_5, T0sum(331), M2)
  call TI_call_OL(0,0, momenta_10, masses2_5, T0sum(332), M2)
  call TI_call_OL(0,0, momenta_25, masses2_4, T0sum(333), M2)
  call TI_call_OL(0,0, momenta_10, masses2_4, T0sum(334), M2)
  call TI_call_OL(0,0, momenta_28, masses2_1, T0sum(335), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(336), M2)
  call TI_call_OL(0,0, momenta_20, masses2_1, T0sum(337), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(338), M2)

  call TI_call_OL(0,1, momenta_397, masses2_11, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_393, masses2_11, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_395, masses2_11, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_399, masses2_11, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_402, masses2_11, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_396, masses2_11, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_403, masses2_11, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_392, masses2_11, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_400, masses2_11, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_398, masses2_11, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_401, masses2_11, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_394, masses2_11, T1sum(12), M2,sbarray_12, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_379, masses2_10, T1sum(13), M2,sbarray_13, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_375, masses2_10, T1sum(14), M2,sbarray_14, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_377, masses2_10, T1sum(15), M2,sbarray_15, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_381, masses2_10, T1sum(16), M2,sbarray_16, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_390, masses2_10, T1sum(17), M2,sbarray_17, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_386, masses2_10, T1sum(18), M2,sbarray_18, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_391, masses2_10, T1sum(19), M2,sbarray_19, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_384, masses2_10, T1sum(20), M2,sbarray_20, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_388, masses2_10, T1sum(21), M2,sbarray_21, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_387, masses2_10, T1sum(22), M2,sbarray_22, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_389, masses2_10, T1sum(23), M2,sbarray_23, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_385, masses2_10, T1sum(24), M2,sbarray_24, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_372, masses2_10, T1sum(25), M2,sbarray_25, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_347, masses2_10, T1sum(26), M2,sbarray_26, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_344, masses2_10, T1sum(27), M2,sbarray_27, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_337, masses2_10, T1sum(28), M2,sbarray_28, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_368, masses2_10, T1sum(29), M2,sbarray_29, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_333, masses2_10, T1sum(30), M2,sbarray_30, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_326, masses2_10, T1sum(31), M2,sbarray_31, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_370, masses2_10, T1sum(32), M2,sbarray_32, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_350, masses2_10, T1sum(33), M2,sbarray_33, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_334, masses2_10, T1sum(34), M2,sbarray_34, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_329, masses2_10, T1sum(35), M2,sbarray_35, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_374, masses2_10, T1sum(36), M2,sbarray_36, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_353, masses2_10, T1sum(37), M2,sbarray_37, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_345, masses2_10, T1sum(38), M2,sbarray_38, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_340, masses2_10, T1sum(39), M2,sbarray_39, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_382, masses2_10, T1sum(40), M2,sbarray_40, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_365, masses2_10, T1sum(41), M2,sbarray_41, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_361, masses2_10, T1sum(42), M2,sbarray_42, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_360, masses2_10, T1sum(43), M2,sbarray_43, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_371, masses2_10, T1sum(44), M2,sbarray_44, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_346, masses2_10, T1sum(45), M2,sbarray_45, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_341, masses2_10, T1sum(46), M2,sbarray_46, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_336, masses2_10, T1sum(47), M2,sbarray_47, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_383, masses2_10, T1sum(48), M2,sbarray_48, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_366, masses2_10, T1sum(49), M2,sbarray_49, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_362, masses2_10, T1sum(50), M2,sbarray_50, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_367, masses2_10, T1sum(51), M2,sbarray_51, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_330, masses2_10, T1sum(52), M2,sbarray_52, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_325, masses2_10, T1sum(53), M2,sbarray_53, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_376, masses2_10, T1sum(54), M2,sbarray_54, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_363, masses2_10, T1sum(55), M2,sbarray_55, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_355, masses2_10, T1sum(56), M2,sbarray_56, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_373, masses2_10, T1sum(57), M2,sbarray_57, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_351, masses2_10, T1sum(58), M2,sbarray_58, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_339, masses2_10, T1sum(59), M2,sbarray_59, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_380, masses2_10, T1sum(60), M2,sbarray_60, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_364, masses2_10, T1sum(61), M2,sbarray_61, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_357, masses2_10, T1sum(62), M2,sbarray_62, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_369, masses2_10, T1sum(63), M2,sbarray_63, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_348, masses2_10, T1sum(64), M2,sbarray_64, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_328, masses2_10, T1sum(65), M2,sbarray_65, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_356, masses2_10, T1sum(66), M2,sbarray_66, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_359, masses2_10, T1sum(67), M2,sbarray_67, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_354, masses2_10, T1sum(68), M2,sbarray_68, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_358, masses2_10, T1sum(69), M2,sbarray_69, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_335, masses2_10, T1sum(70), M2,sbarray_70, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_324, masses2_10, T1sum(71), M2,sbarray_71, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_327, masses2_10, T1sum(72), M2,sbarray_72, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_338, masses2_10, T1sum(73), M2,sbarray_73, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_378, masses2_10, T1sum(74), M2,sbarray_74, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_349, masses2_10, T1sum(75), M2,sbarray_75, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_343, masses2_10, T1sum(76), M2,sbarray_76, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_342, masses2_10, T1sum(77), M2,sbarray_77, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_352, masses2_10, T1sum(78), M2,sbarray_78, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_332, masses2_10, T1sum(79), M2,sbarray_79, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_331, masses2_10, T1sum(80), M2,sbarray_80, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)
  
#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppwajj_uuuxdxaw_1_/**/REALKIND
