
module ol_colourmatrix_ppwajj_uuxcxsawx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(46,2), K2(2,2), KL(2,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   3]
  K1( 2,:) = [   3,   9]
  K1( 3,:) = [  12,   4]
  K1( 4,:) = [   4,  12]
  K1( 5,:) = [   0,  -4]
  K1( 6,:) = [  -4, -12]
  K1( 7,:) = [  12,   4]
  K1( 8,:) = [   4,  12]
  K1( 9,:) = [ -12,  -4]
  K1(10,:) = [  -4,   0]
  K1(11,:) = [   0,   4]
  K1(12,:) = [   4,   0]
  K1(13,:) = [  12,   4]
  K1(14,:) = [   4,  12]
  K1(15,:) = [   0,   4]
  K1(16,:) = [   4,   0]
  K1(17,:) = [ -12,  -4]
  K1(18,:) = [  -4,   0]
  K1(19,:) = [   0,  -4]
  K1(20,:) = [  -4, -12]
  K1(21,:) = [  12,   4]
  K1(22,:) = [   4,  12]
  K1(23,:) = [   0,   0]
  K1(24,:) = [   0,   0]
  K1(25,:) = [   0,   0]
  K1(26,:) = [   0,   0]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [   0,   0]
  K1(32,:) = [   0,   0]
  K1(33,:) = [   0,   0]
  K1(34,:) = [   0,   0]
  K1(35,:) = [   0,   0]
  K1(36,:) = [   0,   0]
  K1(37,:) = [   0,   0]
  K1(38,:) = [   0,   0]
  K1(39,:) = [   0,   0]
  K1(40,:) = [   0,   0]
  K1(41,:) = [   0,   0]
  K1(42,:) = [   0,   0]
  K1(43,:) = [   0,   0]
  K1(44,:) = [   0,   0]
  K1(45,:) = [   0,   0]
  K1(46,:) = [   0,   0]

  K2(1,:) = [ 9, 3]
  K2(2,:) = [ 3, 9]

  KL(1,:) = [ 9, 3]
  KL(2,:) = [ 3, 9]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppwajj_uuxcxsawx_1_/**/REALKIND



module ol_forced_parameters_ppwajj_uuxcxsawx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppwajj_uuxcxsawx_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppwajj_uuxcxsawx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 96 ! number of helicity configurations
  integer(intkind2), save :: nhel = 96 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(96) ! physical helicity states
#endif

  complex(REALKIND), save :: den(153)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,27), wf6(6,14), wf8(8,24), wf12(12,35), wf16(16,19), wf24(24,27), wf96(96,92)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(31), c(47)

  !below the colour vector for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,96)

end module ol_loop_storage_ppwajj_uuxcxsawx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppwajj_uuxcxsawx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppwajj_uuxcxsawx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**2*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 2) = (2*CI*eQED**2*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 3) = (CI*eQED**2*gQCD**2)/(sqrt2*sw)
    f( 4) = (CI*countertermnorm*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 5) = (2*CI*countertermnorm*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 6) = (CI*countertermnorm*eQED**2*gQCD**4)/(sqrt2*sw)
    f( 7) = (CI*countertermnorm*ctGcc*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 8) = (2*CI*countertermnorm*ctGcc*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 9) = (CI*countertermnorm*ctGcc*eQED**2*gQCD**4)/(sqrt2*sw)
    f(10) = (CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(11) = (2*CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(12) = (CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/(sqrt2*sw)
    f(13) = (2*CI*countertermnorm*ctVcc*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(14) = (CI*countertermnorm*ctVqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(15) = (2*CI*countertermnorm*ctVqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(16) = (CI*countertermnorm*ctVsc*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(17) = (2*CI*countertermnorm*ctVsc*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(18) = (CI*countertermnorm*ctVsc*eQED**2*gQCD**4)/(sqrt2*sw)
    f(19) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(3._/**/REALKIND*sqrt2*sw)
    f(20) = (2*CI*eQED**2*gQCD**4*integralnorm*SwB)/(3._/**/REALKIND*sqrt2*sw)
    f(21) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw)
    f(22) = (eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw*6._/**/REALKIND)
    f(23) = (eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(24) = (eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw*2._/**/REALKIND)
    f(25) = (2*eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(26) = (eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw)
    f(27) = (eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(28) = (2*eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(29) = (eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw)
    f(30) = (4*eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(31) = (2*eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw)

  c = [ 9*CI*f(19), 27*CI*f(19), 9*CI*f(20), 27*CI*f(20), 9*CI*f(21), 27*CI*f(21), 18*f(22), 54*f(22), f(23), 3*f(23), 6*f(23) &
    , 8*f(23), 10*f(23), 18*f(23), 21*f(23), 24*f(23), 54*f(23), 18*f(24), 54*f(24), f(25), 3*f(25), 6*f(25), 8*f(25), 10*f(25) &
    , 18*f(25), 21*f(25), 24*f(25), 54*f(25), f(26), 3*f(26), 6*f(26), 8*f(26), 10*f(26), 18*f(26), 21*f(26), 24*f(26), 54*f(26) &
    , 3*f(27), 9*f(27), 3*f(28), 9*f(28), 3*f(29), 9*f(29), 3*f(30), 9*f(30), 3*f(31), 9*f(31) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,20))+L(6,20))
  den(3) = 1 /((L(5,40))+L(6,40))
  den(6) = 1 /((L(5,11))+L(6,11))
  den(9) = 1 /((L(5,36))+L(6,36))
  den(10) = 1 /((L(5,24))+L(6,24))
  den(13) = 1 /((L(5,7))+L(6,7))
  den(18) = 1 /((L(5,48) - MW2)+L(6,48))
  den(20) = 1 /((L(5,52))+L(6,52))
  den(23) = 1 /((L(5,17))+L(6,17))
  den(24) = 1 /((L(5,19))+L(6,19))
  den(28) = 1 /((L(5,18))+L(6,18))
  den(36) = 1 /((L(5,56))+L(6,56))
  den(44) = 1 /((L(5,44))+L(6,44))
  den(52) = 1 /((L(5,60))+L(6,60))
  den(56) = 1 /((L(5,43))+L(6,43))
  den(59) = 1 /((L(5,23))+L(6,23))
  den(71) = 1 /((L(5,27))+L(6,27))
  den(74) = 1 /((L(5,39))+L(6,39))
  den(117) = 1 /((L(5,45))+L(6,45))
  den(119) = 1 /((L(5,46))+L(6,46))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(11) = den(1)*den(9)
  den(12) = den(10)*den(11)
  den(14) = den(1)*den(13)
  den(15) = den(10)*den(14)
  den(16) = den(7)*den(9)
  den(17) = den(3)*den(14)
  den(19) = den(14)*den(18)
  den(21) = den(18)*den(20)
  den(22) = den(1)*den(21)
  den(25) = den(23)*den(24)
  den(26) = den(9)*den(25)
  den(27) = den(3)*den(25)
  den(29) = den(24)*den(28)
  den(30) = den(9)*den(29)
  den(31) = den(3)*den(29)
  den(32) = den(2)*den(20)
  den(33) = den(1)*den(32)
  den(34) = den(9)*den(20)
  den(35) = den(1)*den(34)
  den(37) = den(10)*den(36)
  den(38) = den(1)*den(37)
  den(39) = den(3)*den(36)
  den(40) = den(1)*den(39)
  den(41) = den(7)*den(18)
  den(42) = den(18)*den(36)
  den(43) = den(1)*den(42)
  den(45) = den(9)*den(44)
  den(46) = den(23)*den(45)
  den(47) = den(3)*den(44)
  den(48) = den(23)*den(47)
  den(49) = den(28)*den(45)
  den(50) = den(28)*den(47)
  den(51) = den(2)*den(3)
  den(53) = den(51)*den(52)
  den(54) = den(1)*den(53)
  den(55) = den(1)*den(3)
  den(57) = den(55)*den(56)
  den(58) = den(2)*den(57)
  den(60) = den(4)*den(59)
  den(61) = den(3)*den(60)
  den(62) = den(1)**2
  den(63) = den(32)*den(62)
  den(64) = den(2)**2
  den(65) = den(7)*den(64)
  den(66) = den(7)*den(32)
  den(67) = den(9)*den(10)
  den(68) = den(52)*den(67)
  den(69) = den(1)*den(68)
  den(70) = den(1)*den(10)
  den(72) = den(70)*den(71)
  den(73) = den(9)*den(72)
  den(75) = den(11)*den(74)
  den(76) = den(10)*den(75)
  den(77) = den(37)*den(62)
  den(78) = den(14)*den(37)
  den(79) = den(10)**2
  den(80) = den(14)*den(79)
  den(81) = den(34)*den(62)
  den(82) = den(9)**2
  den(83) = den(7)*den(82)
  den(84) = den(7)*den(34)
  den(85) = den(39)*den(62)
  den(86) = den(14)*den(39)
  den(87) = den(3)**2
  den(88) = den(14)*den(87)
  den(89) = den(42)*den(62)
  den(90) = den(21)*den(62)
  den(91) = den(14)*den(42)
  den(92) = den(7)*den(21)
  den(93) = den(23)**2
  den(94) = den(45)*den(93)
  den(95) = den(25)*den(45)
  den(96) = den(25)*den(82)
  den(97) = den(47)*den(93)
  den(98) = den(25)*den(47)
  den(99) = den(25)*den(87)
  den(100) = den(28)**2
  den(101) = den(45)*den(100)
  den(102) = den(29)*den(45)
  den(103) = den(29)*den(82)
  den(104) = den(47)*den(100)
  den(105) = den(29)*den(47)
  den(106) = den(29)*den(87)
  den(107) = den(14)*den(59)
  den(108) = den(14)*den(74)
  den(109) = den(7)*den(71)
  den(110) = den(7)*den(56)
  den(111) = den(25)*den(59)
  den(112) = den(25)*den(71)
  den(113) = den(29)*den(59)
  den(114) = den(29)*den(71)
  den(115) = den(32)*den(52)
  den(116) = den(37)*den(52)
  den(118) = den(45)*den(117)
  den(120) = den(45)*den(119)
  den(121) = den(34)*den(52)
  den(122) = den(47)*den(117)
  den(123) = den(47)*den(119)
  den(124) = den(39)*den(52)
  den(125) = den(21)*den(52)
  den(126) = den(42)*den(52)
  den(127) = den(1)*den(2)*den(3)
  den(128) = den(1)*den(9)*den(10)
  den(129) = den(1)*den(45)
  den(130) = den(1)*den(47)
  den(131) = den(1)*den(18)
  den(132) = den(9)*den(23)
  den(133) = den(3)*den(23)
  den(134) = den(9)*den(28)
  den(135) = den(3)*den(28)
  den(136) = den(2)*den(110)
  den(137) = den(1)*den(115)
  den(138) = den(10)*den(108)
  den(139) = den(1)*den(116)
  den(140) = den(9)*den(109)
  den(141) = den(1)*den(121)
  den(142) = den(3)*den(107)
  den(143) = den(1)*den(124)
  den(144) = den(1)*den(125)
  den(145) = den(1)*den(126)
  den(146) = den(9)*den(112)
  den(147) = den(23)*den(120)
  den(148) = den(3)*den(111)
  den(149) = den(23)*den(123)
  den(150) = den(9)*den(114)
  den(151) = den(28)*den(118)
  den(152) = den(3)*den(113)
  den(153) = den(28)*den(122)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint) &
    & bind(c,name="Hol_f_amp2_ppwajj_uuxcxsawx_1")
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint)
  use ol_loop_storage_ppwajj_uuxcxsawx_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-up anti-charm strange gamma W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppwajj_uuxcxsawx_1, only: external_perm_ppwajj_uuxcxsawx_1, &
    & external_perm_inv_ppwajj_uuxcxsawx_1, extcomb_perm_ppwajj_uuxcxsawx_1, &
    & average_factor_ppwajj_uuxcxsawx_1
  use ol_external_ppwajj_uuxcxsawx_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppwajj_uuxcxsawx_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppwajj_uuxcxsawx_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppwajj_uuxcxsawx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L, Q
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L, Q_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(2), M2(2) 
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(2,96)
  type(Hpolcont) :: M1helarray_ct(2,96)

  type(Hpolcont) :: A(96,92)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(92)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppwajj_uuxcxsawx_1, 6)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_Q(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rMW, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AV_Q(ntry, ex3(:), ex5(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_WQ_A(ntry, ex6(:), ex4(:), wf6(:,1), n3(:,3), t3x6(:,:,1))
  call prop_A_Q(ntry, wf4(:,2), 20, ZERO, 0_intkind1, wf4(:,3), n2(1))
  call prop_Q_A(ntry, wf6(:,1), 40, ZERO, 0_intkind1, wf6(:,2), n2(2))
  call vert_AV_Q(ntry, wf4(:,3), wf4(:,1), wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_VQ_A(ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,5), t3x8(:,:,1))
  call vert_AW_Q(ntry, wf4(:,3), ex6(:), wf12(:,1), n3(:,6), t3x12(:,:,1))
  call prop_Q_A(ntry, wf8(:,1), 11, ZERO, 0_intkind1, wf8(:,2), n2(3))
  call vert_AW_Q(ntry, ex3(:), ex6(:), wf6(:,3), n3(:,7), t3x6(:,:,2))
  call vert_VQ_A(ntry, ex5(:), ex4(:), wf4(:,4), n3(:,8), t3x4(:,:,3))
  call prop_A_Q(ntry, wf6(:,3), 36, ZERO, 0_intkind1, wf6(:,4), n2(4))
  call prop_Q_A(ntry, wf4(:,4), 24, ZERO, 0_intkind1, wf4(:,5), n2(5))
  call vert_AV_Q(ntry, wf6(:,4), wf4(:,1), wf24(:,1), n3(:,9), t3x24(:,:,1))
  call vert_AV_Q(ntry, ex3(:), wf4(:,1), wf8(:,3), n3(:,10), t3x8(:,:,2))
  call vert_WQ_A(ntry, ex6(:), wf4(:,5), wf12(:,2), n3(:,11), t3x12(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 7, ZERO, 0_intkind1, wf8(:,4), n2(6))
  call vert_AV_Q(ntry, wf6(:,4), ex5(:), wf12(:,3), n3(:,12), t3x12(:,:,3))
  call vert_VQ_A(ntry, ex5(:), wf6(:,2), wf12(:,4), n3(:,13), t3x12(:,:,4))
  call vert_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf6(:,5), n3(:,14), t3x6(:,:,3))
  call prop_W_W(ntry, wf6(:,5), 48, MW, 1_intkind1, wf6(:,6), n2(7))
  call vert_WQ_A(ntry, wf6(:,6), ex4(:), wf12(:,5), n3(:,15), t3x12(:,:,5))
  call vert_AW_Q(ntry, ex3(:), wf6(:,6), wf12(:,6), n3(:,16), t3x12(:,:,6))
  call prop_A_Q(ntry, wf12(:,6), 52, ZERO, 0_intkind1, wf12(:,7), n2(8))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,6), n3(:,17), t3x4(:,:,4))
  call prop_Q_A(ntry, wf4(:,6), 17, ZERO, 0_intkind1, wf4(:,7), n2(9))
  call vert_QA_V(ntry, wf4(:,7), ex2(:), wf8(:,5), n3(:,18), t3x8(:,:,3))
  call vert_QA_V(ntry, ex4(:), wf6(:,4), wf12(:,8), n3(:,19), t3x12(:,:,7))
  call vert_QA_V(ntry, wf6(:,2), ex3(:), wf12(:,9), n3(:,20), t3x12(:,:,8))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,8), n3(:,21), t3x4(:,:,5))
  call prop_A_Q(ntry, wf4(:,8), 18, ZERO, 0_intkind1, wf4(:,9), n2(10))
  call vert_QA_V(ntry, ex1(:), wf4(:,9), wf8(:,6), n3(:,22), t3x8(:,:,4))
  call counter_AV_Q(ntry, wf4(:,3), wf4(:,1), wf16(:,2), n3(:,23), t3x16(:,:,2))
  call counter_AW_Q(ntry, wf4(:,3), ex6(:), wf12(:,10), n3(:,24), t3x12(:,:,9))
  call counter_AV_Q(ntry, wf6(:,4), wf4(:,1), wf24(:,2), n3(:,25), t3x24(:,:,2))
  call counter_WQ_A(ntry, ex6(:), wf4(:,5), wf12(:,11), n3(:,26), t3x12(:,:,10))
  call counter_AV_Q(ntry, wf6(:,4), ex5(:), wf12(:,12), n3(:,27), t3x12(:,:,11))
  call counter_VQ_A(ntry, ex5(:), wf6(:,2), wf12(:,13), n3(:,28), t3x12(:,:,12))
  call counter_VQ_A(ntry, wf4(:,1), ex4(:), wf8(:,7), n3(:,29), t3x8(:,:,5))
  call prop_A_Q(ntry, wf12(:,1), 52, ZERO, 0_intkind1, wf12(:,14), n2(11))
  call counter_WQ_A(ntry, ex6(:), ex4(:), wf6(:,7), n3(:,30), t3x6(:,:,4))
  call prop_Q_A(ntry, wf6(:,7), 40, ZERO, 0_intkind1, wf6(:,8), n2(12))
  call prop_A_Q(ntry, wf12(:,3), 52, ZERO, 0_intkind1, wf12(:,15), n2(13))
  call counter_WQ_A(ntry, wf6(:,6), ex4(:), wf12(:,16), n3(:,31), t3x12(:,:,13))
  call vert_VQ_A(ntry, ex5(:), wf6(:,8), wf12(:,17), n3(:,32), t3x12(:,:,14))
  call counter_VQ_A(ntry, ex5(:), ex4(:), wf4(:,10), n3(:,33), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,10), 24, ZERO, 0_intkind1, wf4(:,11), n2(14))
  call vert_WQ_A(ntry, ex6(:), wf4(:,11), wf12(:,18), n3(:,34), t3x12(:,:,15))
  call counter_AV_Q(ntry, ex3(:), wf4(:,1), wf8(:,8), n3(:,35), t3x8(:,:,6))
  call prop_Q_A(ntry, wf12(:,2), 56, ZERO, 0_intkind1, wf12(:,19), n2(15))
  call counter_AW_Q(ntry, ex3(:), ex6(:), wf6(:,9), n3(:,36), t3x6(:,:,5))
  call prop_A_Q(ntry, wf6(:,9), 36, ZERO, 0_intkind1, wf6(:,10), n2(16))
  call vert_AV_Q(ntry, wf6(:,10), wf4(:,1), wf24(:,3), n3(:,37), t3x24(:,:,3))
  call prop_Q_A(ntry, wf12(:,4), 56, ZERO, 0_intkind1, wf12(:,20), n2(17))
  call counter_AW_Q(ntry, ex3(:), wf6(:,6), wf12(:,21), n3(:,38), t3x12(:,:,16))
  call prop_Q_A(ntry, wf12(:,5), 56, ZERO, 0_intkind1, wf12(:,22), n2(18))
  call vert_AV_Q(ntry, wf6(:,10), ex5(:), wf12(:,23), n3(:,39), t3x12(:,:,17))
  call counter_AV_Q(ntry, ex3(:), ex5(:), wf4(:,12), n3(:,40), t3x4(:,:,7))
  call prop_A_Q(ntry, wf4(:,12), 20, ZERO, 0_intkind1, wf4(:,13), n2(19))
  call vert_AV_Q(ntry, wf4(:,13), wf4(:,1), wf16(:,3), n3(:,41), t3x16(:,:,3))
  call vert_AW_Q(ntry, wf4(:,13), ex6(:), wf12(:,24), n3(:,42), t3x12(:,:,18))
  call counter_QA_V(ntry, ex4(:), wf6(:,4), wf12(:,25), n3(:,43), t3x12(:,:,19))
  call vert_QA_V(ntry, wf6(:,8), ex3(:), wf12(:,26), n3(:,44), t3x12(:,:,20))
  call counter_QA_V(ntry, wf6(:,2), ex3(:), wf12(:,27), n3(:,45), t3x12(:,:,21))
  call vert_QA_V(ntry, ex4(:), wf6(:,10), wf12(:,28), n3(:,46), t3x12(:,:,22))
  call counter_QA_V(ntry, wf4(:,7), ex2(:), wf8(:,9), n3(:,47), t3x8(:,:,7))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,14), n3(:,48), t3x4(:,:,8))
  call prop_A_Q(ntry, wf4(:,14), 18, ZERO, 0_intkind1, wf4(:,15), n2(20))
  call vert_QA_V(ntry, ex1(:), wf4(:,15), wf8(:,10), n3(:,49), t3x8(:,:,8))
  call counter_QA_V(ntry, ex1(:), wf4(:,9), wf8(:,11), n3(:,50), t3x8(:,:,9))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,16), n3(:,51), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,16), 17, ZERO, 0_intkind1, wf4(:,17), n2(21))
  call vert_QA_V(ntry, wf4(:,17), ex2(:), wf8(:,12), n3(:,52), t3x8(:,:,10))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,18), n3(:,53), t3x4(:,:,10))
  call vert_AV_Q(ntry, wf4(:,3), wf4(:,18), wf16(:,4), n3(:,54), t3x16(:,:,4))
  call vert_VQ_A(ntry, wf4(:,18), ex4(:), wf8(:,13), n3(:,55), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,13), 11, ZERO, 0_intkind1, wf8(:,14), n2(22))
  call vert_AV_Q(ntry, wf6(:,4), wf4(:,18), wf24(:,4), n3(:,56), t3x24(:,:,4))
  call vert_AV_Q(ntry, ex3(:), wf4(:,18), wf8(:,15), n3(:,57), t3x8(:,:,12))
  call prop_A_Q(ntry, wf8(:,15), 7, ZERO, 0_intkind1, wf8(:,16), n2(23))
  call vert_QA_V(ntry, wf6(:,2), wf4(:,3), wf24(:,5), n3(:,58), t3x24(:,:,5))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 3, wf4(:,19), n2(24))
  call vert_VQ_A(ntry, wf4(:,1), wf6(:,2), wf24(:,6), n3(:,59), t3x24(:,:,6))
  call counter_A_Q(ctcc,4,ntry, wf4(:,3), 20, wf4(:,20), n2(25))
  call prop_Q_A(ntry, wf24(:,6), 43, ZERO, 0_intkind1, wf24(:,7), n2(26))
  call counter_Q_A(ctcc,4,ntry, wf6(:,2), 40, wf6(:,11), n2(27))
  call prop_A_Q(ntry, wf16(:,1), 23, ZERO, 0_intkind1, wf16(:,5), n2(28))
  call vert_VQ_A(ntry, wf4(:,19), ex4(:), wf8(:,17), n3(:,60), t3x8(:,:,13))
  call prop_A_Q(ntry, wf4(:,20), 20, ZERO, 0_intkind1, wf4(:,21), n2(29))
  call vert_AW_Q(ntry, wf4(:,21), ex6(:), wf12(:,29), n3(:,61), t3x12(:,:,23))
  call counter_Q_A(ctqq,3,ntry, wf8(:,2), 11, wf8(:,18), n2(30))
  call vert_QA_V(ntry, wf4(:,5), wf6(:,4), wf24(:,8), n3(:,62), t3x24(:,:,7))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,5), wf16(:,6), n3(:,63), t3x16(:,:,5))
  call counter_A_Q(ctqq,3,ntry, wf6(:,4), 36, wf6(:,12), n2(31))
  call prop_Q_A(ntry, wf16(:,6), 27, ZERO, 0_intkind1, wf16(:,7), n2(32))
  call counter_Q_A(ctqq,3,ntry, wf4(:,5), 24, wf4(:,22), n2(33))
  call prop_A_Q(ntry, wf24(:,1), 39, ZERO, 0_intkind1, wf24(:,9), n2(34))
  call vert_AV_Q(ntry, ex3(:), wf4(:,19), wf8(:,19), n3(:,64), t3x8(:,:,14))
  call counter_A_Q(ctcc,4,ntry, wf8(:,4), 7, wf8(:,20), n2(35))
  call prop_Q_A(ntry, wf4(:,22), 24, ZERO, 0_intkind1, wf4(:,23), n2(36))
  call vert_WQ_A(ntry, ex6(:), wf4(:,23), wf12(:,30), n3(:,65), t3x12(:,:,24))
  call prop_A_Q(ntry, wf6(:,12), 36, ZERO, 0_intkind1, wf6(:,13), n2(37))
  call vert_AV_Q(ntry, wf6(:,13), ex5(:), wf12(:,31), n3(:,66), t3x12(:,:,25))
  call prop_Q_A(ntry, wf6(:,11), 40, ZERO, 0_intkind1, wf6(:,14), n2(38))
  call vert_VQ_A(ntry, ex5(:), wf6(:,14), wf12(:,32), n3(:,67), t3x12(:,:,26))
  call counter_A_Q(ctqq,3,ntry, wf12(:,7), 52, wf12(:,33), n2(39))
  call counter_Q_A(ctqq,2,ntry, wf4(:,7), 17, wf4(:,24), n2(40))
  call prop_Q_A(ntry, wf4(:,24), 17, ZERO, 0_intkind1, wf4(:,25), n2(41))
  call vert_QA_V(ntry, wf4(:,25), ex2(:), wf8(:,21), n3(:,68), t3x8(:,:,15))
  call counter_V_V(ctGG,21,ntry, wf8(:,5), 19, wf8(:,22), n2(42))
  call vert_QA_V(ntry, ex4(:), wf6(:,13), wf12(:,34), n3(:,69), t3x12(:,:,27))
  call vert_QA_V(ntry, wf6(:,14), ex3(:), wf12(:,35), n3(:,70), t3x12(:,:,28))
  call counter_A_Q(ctqq,2,ntry, wf4(:,9), 18, wf4(:,26), n2(43))
  call prop_A_Q(ntry, wf4(:,26), 18, ZERO, 0_intkind1, wf4(:,27), n2(44))
  call vert_QA_V(ntry, ex1(:), wf4(:,27), wf8(:,23), n3(:,71), t3x8(:,:,16))
  call counter_V_V(ctGG,21,ntry, wf8(:,6), 19, wf8(:,24), n2(45))
  call vert_AV_Q(ntry, wf8(:,4), ex5(:), wf16(:,8), n3(:,72), t3x16(:,:,6))
  call prop_A_Q(ntry, wf16(:,8), 23, ZERO, 0_intkind1, wf16(:,9), n2(46))
  call vert_AW_Q(ntry, wf8(:,4), ex6(:), wf24(:,10), n3(:,73), t3x24(:,:,8))
  call prop_A_Q(ntry, wf24(:,10), 39, ZERO, 0_intkind1, wf24(:,11), n2(47))
  call vert_VQ_A(ntry, ex5(:), wf8(:,2), wf16(:,10), n3(:,74), t3x16(:,:,7))
  call prop_Q_A(ntry, wf16(:,10), 27, ZERO, 0_intkind1, wf16(:,11), n2(48))
  call vert_WQ_A(ntry, ex6(:), wf8(:,2), wf24(:,12), n3(:,75), t3x24(:,:,9))
  call prop_Q_A(ntry, wf24(:,12), 43, ZERO, 0_intkind1, wf24(:,13), n2(49))
  call vert_AV_Q(ntry, ex3(:), wf8(:,5), wf16(:,12), n3(:,76), t3x16(:,:,8))
  call prop_A_Q(ntry, wf16(:,12), 23, ZERO, 0_intkind1, wf16(:,13), n2(50))
  call vert_VQ_A(ntry, wf8(:,5), ex4(:), wf16(:,14), n3(:,77), t3x16(:,:,9))
  call prop_Q_A(ntry, wf16(:,14), 27, ZERO, 0_intkind1, wf16(:,15), n2(51))
  call vert_AV_Q(ntry, ex3(:), wf8(:,6), wf16(:,16), n3(:,78), t3x16(:,:,10))
  call prop_A_Q(ntry, wf16(:,16), 23, ZERO, 0_intkind1, wf16(:,17), n2(52))
  call vert_VQ_A(ntry, wf8(:,6), ex4(:), wf16(:,18), n3(:,79), t3x16(:,:,11))
  call prop_Q_A(ntry, wf16(:,18), 27, ZERO, 0_intkind1, wf16(:,19), n2(53))
  call vert_QA_V(ntry, ex4(:), wf12(:,14), wf24(:,14), n3(:,80), t3x24(:,:,10))
  call vert_QA_V(ntry, wf12(:,19), ex3(:), wf24(:,15), n3(:,81), t3x24(:,:,11))
  call vert_VQ_A(ntry, wf12(:,8), ex1(:), wf24(:,16), n3(:,82), t3x24(:,:,12))
  call prop_Q_A(ntry, wf24(:,16), 45, ZERO, 0_intkind1, wf24(:,17), n2(54))
  call vert_AV_Q(ntry, ex2(:), wf12(:,8), wf24(:,18), n3(:,83), t3x24(:,:,13))
  call prop_A_Q(ntry, wf24(:,18), 46, ZERO, 0_intkind1, wf24(:,19), n2(55))
  call vert_QA_V(ntry, ex4(:), wf12(:,15), wf24(:,20), n3(:,84), t3x24(:,:,14))
  call vert_VQ_A(ntry, wf12(:,9), ex1(:), wf24(:,21), n3(:,85), t3x24(:,:,15))
  call prop_Q_A(ntry, wf24(:,21), 45, ZERO, 0_intkind1, wf24(:,22), n2(56))
  call vert_AV_Q(ntry, ex2(:), wf12(:,9), wf24(:,23), n3(:,86), t3x24(:,:,16))
  call prop_A_Q(ntry, wf24(:,23), 46, ZERO, 0_intkind1, wf24(:,24), n2(57))
  call vert_QA_V(ntry, wf12(:,20), ex3(:), wf24(:,25), n3(:,87), t3x24(:,:,17))
  call vert_QA_V(ntry, ex4(:), wf12(:,7), wf24(:,26), n3(:,88), t3x24(:,:,18))
  call vert_QA_V(ntry, wf12(:,22), ex3(:), wf24(:,27), n3(:,89), t3x24(:,:,19))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf6)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf12)
  call init_hybrid_wf(wf16)
  call init_hybrid_wf(wf24)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
    do k = 1, nhel
      call colint(M1helarray(:,k)%j, M2add)
      call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
      if (IR_is_on > 0) then
	call colint_IR(M1helarray(:,k)%j, M2add_colint)
      end if
      !summation over helicity configurations
      M02 = M02 + M2add
      M2ct = M2ct + M2add_ct
      M2colint = M2colint + M2add_colint
    end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 3
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf6(:,2), wf16(:,1), A(:,1), n3(:,90), t3x96(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,1), wf8(:,2), A(:,2), n3(:,91), t3x96(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,1), A(:,3), n3(:,92), t3x96(:,:,3), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,4), A(:,4), n3(:,93), t3x96(:,:,4), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,3), A(:,5), n3(:,94), t3x96(:,:,5), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,4), A(:,6), n3(:,95), t3x96(:,:,6), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,5), A(:,7), n3(:,96), t3x96(:,:,7), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,1), wf12(:,7), A(:,8), n3(:,97), t3x96(:,:,8), nhel, den(22))
    call Hcont_VV(nsync, wf8(:,5), wf12(:,8), A(:,9), n3(:,98), t3x96(:,:,9), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,5), wf12(:,9), A(:,10), n3(:,99), t3x96(:,:,10), nhel, den(27))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,6), A(:,11), n3(:,100), t3x96(:,:,11), nhel, den(30))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,6), A(:,12), n3(:,101), t3x96(:,:,12), nhel, den(31))

    call Hcont_QA(nsync, wf6(:,2), wf16(:,2), A(:,13), n3(:,102), t3x96(:,:,13), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,10), A(:,14), n3(:,103), t3x96(:,:,14), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,2), A(:,15), n3(:,104), t3x96(:,:,15), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,11), A(:,16), n3(:,105), t3x96(:,:,16), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,12), A(:,17), n3(:,106), t3x96(:,:,17), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,13), A(:,18), n3(:,107), t3x96(:,:,18), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,14), A(:,19), n3(:,108), t3x96(:,:,19), nhel, den(33))
    call Hcont_QA(nsync, wf16(:,1), wf6(:,8), A(:,20), n3(:,109), t3x96(:,:,20), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,15), A(:,21), n3(:,110), t3x96(:,:,21), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,16), A(:,22), n3(:,111), t3x96(:,:,22), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,7), A(:,23), n3(:,112), t3x96(:,:,23), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,17), A(:,24), n3(:,113), t3x96(:,:,24), nhel, den(17))
    call Hcont_QA(nsync, wf24(:,1), wf4(:,11), A(:,25), n3(:,114), t3x96(:,:,25), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,18), A(:,26), n3(:,115), t3x96(:,:,26), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,19), A(:,27), n3(:,116), t3x96(:,:,27), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,3), A(:,28), n3(:,117), t3x96(:,:,28), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,20), A(:,29), n3(:,118), t3x96(:,:,29), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,21), A(:,30), n3(:,119), t3x96(:,:,30), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,22), A(:,31), n3(:,120), t3x96(:,:,31), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,23), A(:,32), n3(:,121), t3x96(:,:,32), nhel, den(16))
    call Hcont_QA(nsync, wf6(:,2), wf16(:,3), A(:,33), n3(:,122), t3x96(:,:,33), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,24), A(:,34), n3(:,123), t3x96(:,:,34), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,5), wf12(:,25), A(:,35), n3(:,124), t3x96(:,:,35), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,5), wf12(:,26), A(:,36), n3(:,125), t3x96(:,:,36), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,6), wf12(:,25), A(:,37), n3(:,126), t3x96(:,:,37), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,6), wf12(:,26), A(:,38), n3(:,127), t3x96(:,:,38), nhel, den(31))
    call Hcont_VV(nsync, wf8(:,5), wf12(:,27), A(:,39), n3(:,128), t3x96(:,:,39), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,5), wf12(:,28), A(:,40), n3(:,129), t3x96(:,:,40), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,6), wf12(:,27), A(:,41), n3(:,130), t3x96(:,:,41), nhel, den(31))
    call Hcont_VV(nsync, wf8(:,6), wf12(:,28), A(:,42), n3(:,131), t3x96(:,:,42), nhel, den(30))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,9), A(:,43), n3(:,132), t3x96(:,:,43), nhel, den(46))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,9), A(:,44), n3(:,133), t3x96(:,:,44), nhel, den(48))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,10), A(:,45), n3(:,134), t3x96(:,:,45), nhel, den(30))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,10), A(:,46), n3(:,135), t3x96(:,:,46), nhel, den(31))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,11), A(:,47), n3(:,136), t3x96(:,:,47), nhel, den(49))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,11), A(:,48), n3(:,137), t3x96(:,:,48), nhel, den(50))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,12), A(:,49), n3(:,138), t3x96(:,:,49), nhel, den(26))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,12), A(:,50), n3(:,139), t3x96(:,:,50), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,2), wf16(:,4), A(:,51), n3(:,140), t3x96(:,:,51), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,1), wf8(:,14), A(:,52), n3(:,141), t3x96(:,:,52), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf24(:,4), A(:,53), n3(:,142), t3x96(:,:,53), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,16), A(:,54), n3(:,143), t3x96(:,:,54), nhel, den(15))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,14), A(:,55), n3(:,144), t3x96(:,:,55), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,4), wf8(:,16), A(:,56), n3(:,145), t3x96(:,:,56), nhel, den(17))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,16), A(:,57), n3(:,146), t3x96(:,:,57), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,13), A(:,58), n3(:,147), t3x96(:,:,58), nhel, den(22))
    call Hcont_VV(nsync, wf24(:,5), wf4(:,19), A(:,59), n3(:,148), t3x96(:,:,59), nhel, den(54))
    call Hcont_QA(nsync, wf4(:,20), wf24(:,7), A(:,60), n3(:,149), t3x96(:,:,60), nhel, den(58))
    call Hcont_QA(nsync, wf6(:,11), wf16(:,5), A(:,61), n3(:,150), t3x96(:,:,61), nhel, den(61))
    call Hcont_QA(nsync, wf12(:,14), wf8(:,17), A(:,62), n3(:,151), t3x96(:,:,62), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,29), A(:,63), n3(:,152), t3x96(:,:,63), nhel, den(65))
    call Hcont_QA(nsync, wf12(:,14), wf8(:,18), A(:,64), n3(:,153), t3x96(:,:,64), nhel, den(66))
    call Hcont_VV(nsync, wf4(:,19), wf24(:,8), A(:,65), n3(:,154), t3x96(:,:,65), nhel, den(69))
    call Hcont_QA(nsync, wf6(:,12), wf16(:,7), A(:,66), n3(:,155), t3x96(:,:,66), nhel, den(73))
    call Hcont_QA(nsync, wf4(:,22), wf24(:,9), A(:,67), n3(:,156), t3x96(:,:,67), nhel, den(76))
    call Hcont_QA(nsync, wf12(:,19), wf8(:,19), A(:,68), n3(:,157), t3x96(:,:,68), nhel, den(77))
    call Hcont_QA(nsync, wf12(:,19), wf8(:,20), A(:,69), n3(:,158), t3x96(:,:,69), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,30), A(:,70), n3(:,159), t3x96(:,:,70), nhel, den(80))
    call Hcont_QA(nsync, wf12(:,15), wf8(:,17), A(:,71), n3(:,160), t3x96(:,:,71), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,31), A(:,72), n3(:,161), t3x96(:,:,72), nhel, den(83))
    call Hcont_QA(nsync, wf12(:,15), wf8(:,18), A(:,73), n3(:,162), t3x96(:,:,73), nhel, den(84))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,19), A(:,74), n3(:,163), t3x96(:,:,74), nhel, den(85))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,20), A(:,75), n3(:,164), t3x96(:,:,75), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,32), A(:,76), n3(:,165), t3x96(:,:,76), nhel, den(88))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,19), A(:,77), n3(:,166), t3x96(:,:,77), nhel, den(89))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,17), A(:,78), n3(:,167), t3x96(:,:,78), nhel, den(90))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,20), A(:,79), n3(:,168), t3x96(:,:,79), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,33), A(:,80), n3(:,169), t3x96(:,:,80), nhel, den(92))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,21), A(:,81), n3(:,170), t3x96(:,:,81), nhel, den(94))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,22), A(:,82), n3(:,171), t3x96(:,:,82), nhel, den(95))
    call Hcont_VV(nsync, wf8(:,5), wf12(:,34), A(:,83), n3(:,172), t3x96(:,:,83), nhel, den(96))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,21), A(:,84), n3(:,173), t3x96(:,:,84), nhel, den(97))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,22), A(:,85), n3(:,174), t3x96(:,:,85), nhel, den(98))
    call Hcont_VV(nsync, wf8(:,5), wf12(:,35), A(:,86), n3(:,175), t3x96(:,:,86), nhel, den(99))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,23), A(:,87), n3(:,176), t3x96(:,:,87), nhel, den(101))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,24), A(:,88), n3(:,177), t3x96(:,:,88), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,6), wf12(:,34), A(:,89), n3(:,178), t3x96(:,:,89), nhel, den(103))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,23), A(:,90), n3(:,179), t3x96(:,:,90), nhel, den(104))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,24), A(:,91), n3(:,180), t3x96(:,:,91), nhel, den(105))
    call Hcont_VV(nsync, wf8(:,6), wf12(:,35), A(:,92), n3(:,181), t3x96(:,:,92), nhel, den(106))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(2) ! M1helarray(2,96)
  integer :: empty(0), i

  M1(1)%j = ((-A(j,3)%j-A(j,4)%j-A(j,5)%j)*f(1))/2._/**/REALKIND+((A(j,1)%j+A(j,2)%j+A(j,6)%j+A(j,9)%j+A(j,10)%j+A(j,11)%j &
       +A(j,12)%j)*f(2))/2._/**/REALKIND+((A(j,7)%j+A(j,8)%j)*f(3))/2._/**/REALKIND
  M1(2)%j = ((A(j,3)%j+A(j,4)%j+A(j,5)%j)*f(1))/6._/**/REALKIND+((-A(j,1)%j-A(j,2)%j-A(j,6)%j-A(j,9)%j-A(j,10)%j-A(j,11)%j &
       -A(j,12)%j)*f(2))/6._/**/REALKIND+((-A(j,7)%j-A(j,8)%j)*f(3))/6._/**/REALKIND

  M2(1)%j = ((A(j,65)%j+A(j,66)%j+A(j,67)%j+A(j,68)%j+A(j,69)%j+A(j,70)%j+A(j,71)%j+A(j,72)%j+A(j,73)%j)*f(4))/2._/**/REALKIND+(( &
       -A(j,59)%j-A(j,60)%j-A(j,61)%j-A(j,62)%j-A(j,63)%j-A(j,64)%j-A(j,74)%j-A(j,75)%j-A(j,76)%j-A(j,81)%j-A(j,82)%j-A(j,83)%j &
       -A(j,84)%j-A(j,85)%j-A(j,86)%j-A(j,87)%j-A(j,88)%j-A(j,89)%j-A(j,90)%j-A(j,91)%j-A(j,92)%j)*f(5))/2._/**/REALKIND+(( &
       -A(j,77)%j-A(j,78)%j-A(j,79)%j-A(j,80)%j)*f(6))/2._/**/REALKIND-(A(j,27)%j*f(7))/2._/**/REALKIND+((A(j,13)%j+A(j,29)%j &
       +A(j,39)%j+A(j,41)%j)*f(8))/2._/**/REALKIND+(A(j,31)%j*f(9))/2._/**/REALKIND+((-A(j,15)%j-A(j,21)%j-A(j,53)%j-A(j,54)%j &
       -A(j,55)%j)*f(10))/2._/**/REALKIND+((A(j,19)%j+A(j,35)%j+A(j,37)%j+A(j,43)%j+A(j,44)%j+A(j,47)%j+A(j,48)%j+A(j,51)%j &
       +A(j,52)%j+A(j,56)%j)*f(11))/2._/**/REALKIND+((A(j,23)%j+A(j,57)%j+A(j,58)%j)*f(12))/2._/**/REALKIND+((A(j,18)%j+A(j,33)%j &
       +A(j,34)%j)*f(13))/2._/**/REALKIND+((-A(j,17)%j-A(j,25)%j-A(j,26)%j)*f(14))/2._/**/REALKIND+((A(j,45)%j+A(j,46)%j+A(j,49)%j &
       +A(j,50)%j)*f(15))/2._/**/REALKIND+((-A(j,16)%j-A(j,28)%j-A(j,32)%j)*f(16))/2._/**/REALKIND+((A(j,14)%j+A(j,20)%j+A(j,24)%j &
       +A(j,36)%j+A(j,38)%j+A(j,40)%j+A(j,42)%j)*f(17))/2._/**/REALKIND+((A(j,22)%j+A(j,30)%j)*f(18))/2._/**/REALKIND
  M2(2)%j = ((-A(j,65)%j-A(j,66)%j-A(j,67)%j-A(j,68)%j-A(j,69)%j-A(j,70)%j-A(j,71)%j-A(j,72)%j-A(j,73)%j)*f(4))/6._/**/REALKIND &
       +((A(j,59)%j+A(j,60)%j+A(j,61)%j+A(j,62)%j+A(j,63)%j+A(j,64)%j+A(j,74)%j+A(j,75)%j+A(j,76)%j+A(j,81)%j+A(j,82)%j+A(j,83)%j &
       +A(j,84)%j+A(j,85)%j+A(j,86)%j+A(j,87)%j+A(j,88)%j+A(j,89)%j+A(j,90)%j+A(j,91)%j+A(j,92)%j)*f(5))/6._/**/REALKIND &
       +((A(j,77)%j+A(j,78)%j+A(j,79)%j+A(j,80)%j)*f(6))/6._/**/REALKIND+(A(j,27)%j*f(7))/6._/**/REALKIND+((-A(j,13)%j-A(j,29)%j &
       -A(j,39)%j-A(j,41)%j)*f(8))/6._/**/REALKIND-(A(j,31)%j*f(9))/6._/**/REALKIND+((A(j,15)%j+A(j,21)%j+A(j,53)%j+A(j,54)%j &
       +A(j,55)%j)*f(10))/6._/**/REALKIND+((-A(j,19)%j-A(j,35)%j-A(j,37)%j-A(j,43)%j-A(j,44)%j-A(j,47)%j-A(j,48)%j-A(j,51)%j &
       -A(j,52)%j-A(j,56)%j)*f(11))/6._/**/REALKIND+((-A(j,23)%j-A(j,57)%j-A(j,58)%j)*f(12))/6._/**/REALKIND+((-A(j,18)%j &
       -A(j,33)%j-A(j,34)%j)*f(13))/6._/**/REALKIND+((A(j,17)%j+A(j,25)%j+A(j,26)%j)*f(14))/6._/**/REALKIND+((-A(j,45)%j-A(j,46)%j &
       -A(j,49)%j-A(j,50)%j)*f(15))/6._/**/REALKIND+((A(j,16)%j+A(j,28)%j+A(j,32)%j)*f(16))/6._/**/REALKIND+((-A(j,14)%j-A(j,20)%j &
       -A(j,24)%j-A(j,36)%j-A(j,38)%j-A(j,40)%j-A(j,42)%j)*f(17))/6._/**/REALKIND+((-A(j,22)%j-A(j,30)%j)*f(18))/6._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwajj_uuxcxsawx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwajj_uuxcxsawx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(2), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 2
      do j = 1, 2
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppwajj_uuxcxsawx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwajj_uuxcxsawx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppwajj_uuxcxsawx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer :: i, j


  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppwajj_uuxcxsawx_1_/**/REALKIND
