
module ol_colourmatrix_ppwajj_udxawgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(46,2), K2(2,3), KL(2,3)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  48,  -6]
  K1( 2,:) = [  -6,  48]
  K1( 3,:) = [  64,  -8]
  K1( 4,:) = [  -8,  64]
  K1( 5,:) = [  -1, -10]
  K1( 6,:) = [ -10,  -1]
  K1( 7,:) = [  64,  -8]
  K1( 8,:) = [  -8,  64]
  K1( 9,:) = [   0,   0]
  K1(10,:) = [   0,   0]
  K1(11,:) = [   0,   0]
  K1(12,:) = [   0,   0]
  K1(13,:) = [   0,   0]
  K1(14,:) = [   0,   0]
  K1(15,:) = [   0,   0]
  K1(16,:) = [   0,   0]
  K1(17,:) = [   0,   0]
  K1(18,:) = [   0,   0]
  K1(19,:) = [   0,   0]
  K1(20,:) = [   0,   0]
  K1(21,:) = [   0,   0]
  K1(22,:) = [   0,   0]
  K1(23,:) = [   9,   9]
  K1(24,:) = [   9, -72]
  K1(25,:) = [ -72,   9]
  K1(26,:) = [   9,   9]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [ 144, -18]
  K1(32,:) = [ -18, 144]
  K1(33,:) = [ -72,   9]
  K1(34,:) = [   9,   9]
  K1(35,:) = [   9,   9]
  K1(36,:) = [   9, -72]
  K1(37,:) = [   0,   0]
  K1(38,:) = [   0,   0]
  K1(39,:) = [   0,   0]
  K1(40,:) = [   0,   0]
  K1(41,:) = [ -81,   0]
  K1(42,:) = [   0, -81]
  K1(43,:) = [ 144, -18]
  K1(44,:) = [ -18, 144]
  K1(45,:) = [   0,   0]
  K1(46,:) = [   0,   0]
  K1 = (1._/**/REALKIND / 9) * K1

  K2(1,:) = [ 16, -2,  6]
  K2(2,:) = [ -2, 16,  6]
  K2 = (1._/**/REALKIND / 3) * K2

  KL(1,:) = [ 16, -2,  6]
  KL(2,:) = [ -2, 16,  6]
  KL = (1._/**/REALKIND / 3) * KL

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppwajj_udxawgg_1_/**/REALKIND



module ol_forced_parameters_ppwajj_udxawgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppwajj_udxawgg_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppwajj_udxawgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 96 ! number of helicity configurations
  integer(intkind2), save :: nhel = 96 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(96) ! physical helicity states
#endif

  complex(REALKIND), save :: den(431)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(3), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,39), wf6(6,14), wf8(8,88), wf12(12,90), wf16(16,40), wf24(24,126), wf96(96,292)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(45), c(46)

  !below the colour vector for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(3,96)

end module ol_loop_storage_ppwajj_udxawgg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppwajj_udxawgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppwajj_udxawgg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**2*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 2) = (2*CI*eQED**2*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 3) = (CI*eQED**2*gQCD**2)/(sqrt2*sw)
    f( 4) = (eQED**2*gQCD**2)/(sqrt2*sw*3._/**/REALKIND)
    f( 5) = (2*eQED**2*gQCD**2)/(sqrt2*sw*3._/**/REALKIND)
    f( 6) = (eQED**2*gQCD**2)/(sqrt2*sw)
    f( 7) = (CI*countertermnorm*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 8) = (2*CI*countertermnorm*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 9) = (CI*countertermnorm*eQED**2*gQCD**4)/(sqrt2*sw)
    f(10) = (countertermnorm*eQED**2*gQCD**4)/(sqrt2*sw*3._/**/REALKIND)
    f(11) = (2*countertermnorm*eQED**2*gQCD**4)/(sqrt2*sw*3._/**/REALKIND)
    f(12) = (countertermnorm*eQED**2*gQCD**4)/(sqrt2*sw)
    f(13) = (CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(14) = (2*CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(15) = (CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/(sqrt2*sw)
    f(16) = (countertermnorm*ctGqq*eQED**2*gQCD**4)/(sqrt2*sw*3._/**/REALKIND)
    f(17) = (2*countertermnorm*ctGqq*eQED**2*gQCD**4)/(sqrt2*sw*3._/**/REALKIND)
    f(18) = (countertermnorm*ctGqq*eQED**2*gQCD**4)/(sqrt2*sw)
    f(19) = (CI*countertermnorm*ctVqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(20) = (2*CI*countertermnorm*ctVqq*eQED**2*gQCD**4)/(3._/**/REALKIND*sqrt2*sw)
    f(21) = (CI*countertermnorm*ctVqq*eQED**2*gQCD**4)/(sqrt2*sw)
    f(22) = (countertermnorm*ctVqq*eQED**2*gQCD**4)/(sqrt2*sw*3._/**/REALKIND)
    f(23) = (2*countertermnorm*ctVqq*eQED**2*gQCD**4)/(sqrt2*sw*3._/**/REALKIND)
    f(24) = (countertermnorm*ctVqq*eQED**2*gQCD**4)/(sqrt2*sw)
    f(25) = (countertermnorm*ctVVV*eQED**2*gQCD**4)/(sqrt2*sw*3._/**/REALKIND)
    f(26) = (2*countertermnorm*ctVVV*eQED**2*gQCD**4)/(sqrt2*sw*3._/**/REALKIND)
    f(27) = (countertermnorm*ctVVV*eQED**2*gQCD**4)/(sqrt2*sw)
    f(28) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(6._/**/REALKIND*sqrt2*sw)
    f(29) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(3._/**/REALKIND*sqrt2*sw)
    f(30) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(2._/**/REALKIND*sqrt2*sw)
    f(31) = (2*CI*eQED**2*gQCD**4*integralnorm*SwB)/(3._/**/REALKIND*sqrt2*sw)
    f(32) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw)
    f(33) = (eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(34) = (2*eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(35) = (eQED**2*gQCD**4*integralnorm*SwB)/(sqrt2*sw)
    f(36) = (CI*eQED**2*gQCD**4*integralnorm*SwF)/(3._/**/REALKIND*sqrt2*sw)
    f(37) = (2*CI*eQED**2*gQCD**4*integralnorm*SwF)/(3._/**/REALKIND*sqrt2*sw)
    f(38) = (CI*eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw)
    f(39) = (4*CI*eQED**2*gQCD**4*integralnorm*SwF)/(3._/**/REALKIND*sqrt2*sw)
    f(40) = (2*CI*eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw)
    f(41) = (eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(42) = (2*eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(43) = (eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw)
    f(44) = (4*eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(45) = (2*eQED**2*gQCD**4*integralnorm*SwF)/(sqrt2*sw)

  c = [ 9*CI*f(28), 18*CI*f(28), CI*f(29), 3*CI*f(29), 8*CI*f(29), 9*CI*f(29), 18*CI*f(29), 9*CI*f(30), 18*CI*f(30), CI*f(31) &
    , 3*CI*f(31), 8*CI*f(31), 9*CI*f(31), 18*CI*f(31), CI*f(32), 3*CI*f(32), 8*CI*f(32), 9*CI*f(32), 18*CI*f(32), f(33), 3*f(33) &
    , 8*f(33), 9*f(33), f(34), 3*f(34), 8*f(34), 9*f(34), f(35), 3*f(35), 8*f(35), 9*f(35), 3*CI*f(36), 3*CI*f(37), 3*CI*f(38) &
    , 3*CI*f(39), 3*CI*f(40), f(41), 3*f(41), f(42), 3*f(42), f(43), 3*f(43), f(44), 3*f(44), f(45), 3*f(45) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5))+L(6,5))
  den(2) = 1 /((L(5,10))+L(6,10))
  den(3) = 1 /((L(5,48))+L(6,48))
  den(6) = 1 /((L(5,21))+L(6,21))
  den(9) = 1 /((L(5,26))+L(6,26))
  den(12) = 1 /((L(5,18))+L(6,18))
  den(13) = 1 /((L(5,13))+L(6,13))
  den(18) = 1 /((L(5,34))+L(6,34))
  den(20) = 1 /((L(5,42))+L(6,42))
  den(23) = 1 /((L(5,50))+L(6,50))
  den(26) = 1 /((L(5,9))+L(6,9))
  den(27) = 1 /((L(5,6))+L(6,6))
  den(30) = 1 /((L(5,25))+L(6,25))
  den(33) = 1 /((L(5,22))+L(6,22))
  den(36) = 1 /((L(5,17))+L(6,17))
  den(39) = 1 /((L(5,14))+L(6,14))
  den(42) = 1 /((L(5,33))+L(6,33))
  den(43) = 1 /((L(5,41))+L(6,41))
  den(47) = 1 /((L(5,49))+L(6,49))
  den(55) = 1 /((L(5,38))+L(6,38))
  den(63) = 1 /((L(5,37))+L(6,37))
  den(68) = 1 /((L(5,12) - MW2)+L(6,12))
  den(85) = 1 /((L(5,52))+L(6,52))
  den(131) = 1 /((L(5,58))+L(6,58))
  den(135) = 1 /((L(5,53))+L(6,53))
  den(138) = 1 /((L(5,15))+L(6,15))
  den(168) = 1 /((L(5,54))+L(6,54))
  den(172) = 1 /((L(5,57))+L(6,57))
  den(233) = 1 /((L(5,46))+L(6,46))
  den(237) = 1 /((L(5,29))+L(6,29))
  den(243) = 1 /((L(5,30))+L(6,30))
  den(247) = 1 /((L(5,45))+L(6,45))
  den(287) = 1 /((L(5,27))+L(6,27))
  den(290) = 1 /((L(5,43))+L(6,43))
  den(292) = 1 /((L(5,11))+L(6,11))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(14) = den(1)*den(13)
  den(15) = den(12)*den(14)
  den(16) = den(9)*den(12)
  den(17) = den(1)*den(16)
  den(19) = den(14)*den(18)
  den(21) = den(18)*den(20)
  den(22) = den(1)*den(21)
  den(24) = den(3)*den(23)
  den(25) = den(1)*den(24)
  den(28) = den(26)*den(27)
  den(29) = den(3)*den(28)
  den(31) = den(26)*den(30)
  den(32) = den(27)*den(31)
  den(34) = den(27)*den(33)
  den(35) = den(26)*den(34)
  den(37) = den(30)*den(36)
  den(38) = den(27)*den(37)
  den(40) = den(27)*den(39)
  den(41) = den(36)*den(40)
  den(44) = den(42)*den(43)
  den(45) = den(27)*den(44)
  den(46) = den(40)*den(42)
  den(48) = den(3)*den(47)
  den(49) = den(27)*den(48)
  den(50) = den(13)*den(26)
  den(51) = den(12)*den(50)
  den(52) = den(12)*den(33)
  den(53) = den(26)*den(52)
  den(54) = den(18)*den(50)
  den(56) = den(18)*den(55)
  den(57) = den(26)*den(56)
  den(58) = den(24)*den(26)
  den(59) = den(6)*den(36)
  den(60) = den(2)*den(59)
  den(61) = den(2)*den(39)
  den(62) = den(36)*den(61)
  den(64) = den(42)*den(63)
  den(65) = den(2)*den(64)
  den(66) = den(42)*den(61)
  den(67) = den(2)*den(48)
  den(69) = den(18)*den(36)
  den(70) = den(68)*den(69)
  den(71) = den(39)*den(68)
  den(72) = den(36)*den(71)
  den(73) = den(12)*den(42)
  den(74) = den(68)*den(73)
  den(75) = den(13)*den(68)
  den(76) = den(12)*den(75)
  den(77) = den(42)*den(71)
  den(78) = den(18)*den(75)
  den(79) = den(3)*den(75)
  den(80) = den(48)*den(68)
  den(81) = den(18)*den(59)
  den(82) = den(36)*den(56)
  den(83) = den(12)*den(64)
  den(84) = den(42)*den(52)
  den(86) = den(26)*den(85)
  den(87) = den(2)*den(85)
  den(88) = den(1)*den(63)
  den(89) = den(2)*den(88)
  den(90) = den(2)*den(20)
  den(91) = den(1)*den(90)
  den(92) = den(12)*den(88)
  den(93) = den(12)*den(23)
  den(94) = den(1)*den(93)
  den(95) = den(7)*den(18)
  den(96) = den(18)*den(23)
  den(97) = den(1)*den(96)
  den(98) = den(26)*den(43)
  den(99) = den(27)*den(98)
  den(100) = den(27)*den(55)
  den(101) = den(26)*den(100)
  den(102) = den(36)*den(47)
  den(103) = den(27)*den(102)
  den(104) = den(36)*den(100)
  den(105) = den(42)*den(47)
  den(106) = den(27)*den(105)
  den(107) = den(34)*den(42)
  den(108) = den(12)*den(98)
  den(109) = den(26)*den(93)
  den(110) = den(18)*den(31)
  den(111) = den(26)*den(96)
  den(112) = den(2)*den(102)
  den(113) = den(36)*den(90)
  den(114) = den(2)*den(105)
  den(115) = den(10)*den(42)
  den(116) = den(18)*den(37)
  den(117) = den(21)*den(36)
  den(118) = den(12)*den(44)
  den(119) = den(16)*den(42)
  den(120) = den(3)*den(14)
  den(121) = den(3)*den(50)
  den(122) = den(68)*den(102)
  den(123) = den(68)*den(105)
  den(124) = den(3)*den(40)
  den(125) = den(3)*den(61)
  den(126) = den(68)*den(93)
  den(127) = den(68)*den(96)
  den(128) = den(24)*den(68)
  den(129) = den(3)*den(71)
  den(130) = den(2)*den(3)
  den(132) = den(130)*den(131)
  den(133) = den(1)*den(132)
  den(134) = den(1)*den(3)
  den(136) = den(134)*den(135)
  den(137) = den(2)*den(136)
  den(139) = den(4)*den(138)
  den(140) = den(3)*den(139)
  den(141) = den(1)**2
  den(142) = den(90)*den(141)
  den(143) = den(10)*den(141)
  den(144) = den(2)**2
  den(145) = den(88)*den(144)
  den(146) = den(7)*den(144)
  den(147) = den(7)*den(90)
  den(148) = den(10)*den(88)
  den(149) = den(93)*den(141)
  den(150) = den(16)*den(141)
  den(151) = den(12)**2
  den(152) = den(88)*den(151)
  den(153) = den(14)*den(151)
  den(154) = den(14)*den(93)
  den(155) = den(16)*den(88)
  den(156) = den(96)*den(141)
  den(157) = den(21)*den(141)
  den(158) = den(18)**2
  den(159) = den(7)*den(158)
  den(160) = den(14)*den(158)
  den(161) = den(14)*den(96)
  den(162) = den(7)*den(21)
  den(163) = den(24)*den(141)
  den(164) = den(14)*den(24)
  den(165) = den(3)**2
  den(166) = den(14)*den(165)
  den(167) = den(3)*den(27)
  den(169) = den(167)*den(168)
  den(170) = den(26)*den(169)
  den(171) = den(3)*den(26)
  den(173) = den(171)*den(172)
  den(174) = den(27)*den(173)
  den(175) = den(28)*den(138)
  den(176) = den(3)*den(175)
  den(177) = den(26)**2
  den(178) = den(100)*den(177)
  den(179) = den(34)*den(177)
  den(180) = den(27)**2
  den(181) = den(98)*den(180)
  den(182) = den(31)*den(180)
  den(183) = den(31)*den(100)
  den(184) = den(34)*den(98)
  den(185) = den(36)**2
  den(186) = den(100)*den(185)
  den(187) = den(40)*den(185)
  den(188) = den(102)*den(180)
  den(189) = den(37)*den(180)
  den(190) = den(37)*den(100)
  den(191) = den(40)*den(102)
  den(192) = den(42)**2
  den(193) = den(34)*den(192)
  den(194) = den(40)*den(192)
  den(195) = den(105)*den(180)
  den(196) = den(44)*den(180)
  den(197) = den(34)*den(44)
  den(198) = den(40)*den(105)
  den(199) = den(40)*den(48)
  den(200) = den(40)*den(165)
  den(201) = den(48)*den(180)
  den(202) = den(93)*den(177)
  den(203) = den(52)*den(177)
  den(204) = den(98)*den(151)
  den(205) = den(50)*den(151)
  den(206) = den(50)*den(93)
  den(207) = den(52)*den(98)
  den(208) = den(96)*den(177)
  den(209) = den(56)*den(177)
  den(210) = den(31)*den(158)
  den(211) = den(50)*den(158)
  den(212) = den(50)*den(96)
  den(213) = den(31)*den(56)
  den(214) = den(24)*den(177)
  den(215) = den(24)*den(50)
  den(216) = den(50)*den(165)
  den(217) = den(90)*den(185)
  den(218) = den(61)*den(185)
  den(219) = den(102)*den(144)
  den(220) = den(59)*den(144)
  den(221) = den(59)*den(90)
  den(222) = den(61)*den(102)
  den(223) = den(10)*den(192)
  den(224) = den(61)*den(192)
  den(225) = den(105)*den(144)
  den(226) = den(64)*den(144)
  den(227) = den(10)*den(64)
  den(228) = den(61)*den(105)
  den(229) = den(48)*den(61)
  den(230) = den(61)*den(165)
  den(231) = den(48)*den(144)
  den(232) = den(18)*den(68)
  den(234) = den(232)*den(233)
  den(235) = den(36)*den(234)
  den(236) = den(36)*den(68)
  den(238) = den(236)*den(237)
  den(239) = den(18)*den(238)
  den(240) = den(71)*den(185)
  den(241) = den(71)*den(102)
  den(242) = den(12)*den(68)
  den(244) = den(242)*den(243)
  den(245) = den(42)*den(244)
  den(246) = den(42)*den(68)
  den(248) = den(246)*den(247)
  den(249) = den(12)*den(248)
  den(250) = den(75)*den(93)
  den(251) = den(75)*den(151)
  den(252) = den(71)*den(192)
  den(253) = den(71)*den(105)
  den(254) = den(75)*den(96)
  den(255) = den(75)*den(158)
  den(256) = den(24)*den(75)
  den(257) = den(48)*den(71)
  den(258) = den(71)*den(165)
  den(259) = den(75)*den(165)
  den(260) = den(21)*den(185)
  den(261) = den(56)*den(185)
  den(262) = den(37)*den(158)
  den(263) = den(59)*den(158)
  den(264) = den(21)*den(59)
  den(265) = den(37)*den(56)
  den(266) = den(16)*den(192)
  den(267) = den(52)*den(192)
  den(268) = den(44)*den(151)
  den(269) = den(64)*den(151)
  den(270) = den(16)*den(64)
  den(271) = den(44)*den(52)
  den(272) = den(14)*den(138)
  den(273) = den(14)*den(237)
  den(274) = den(14)*den(247)
  den(275) = den(7)*den(237)
  den(276) = den(7)*den(135)
  den(277) = den(88)*den(247)
  den(278) = den(88)*den(135)
  den(279) = den(40)*den(138)
  den(280) = den(40)*den(243)
  den(281) = den(40)*den(233)
  den(282) = den(34)*den(243)
  den(283) = den(34)*den(168)
  den(284) = den(100)*den(233)
  den(285) = den(100)*den(168)
  den(286) = den(12)*den(26)
  den(288) = den(286)*den(287)
  den(289) = den(18)*den(26)
  den(291) = den(289)*den(290)
  den(293) = den(26)*den(292)
  den(294) = den(287)*den(293)
  den(295) = den(290)*den(293)
  den(296) = den(50)*den(138)
  den(297) = den(50)*den(237)
  den(298) = den(50)*den(247)
  den(299) = den(31)*den(287)
  den(300) = den(31)*den(237)
  den(301) = den(31)*den(172)
  den(302) = den(98)*den(290)
  den(303) = den(98)*den(247)
  den(304) = den(98)*den(172)
  den(305) = den(2)*den(36)
  den(306) = den(287)*den(305)
  den(307) = den(2)*den(42)
  den(308) = den(290)*den(307)
  den(309) = den(2)*den(292)
  den(310) = den(287)*den(309)
  den(311) = den(290)*den(309)
  den(312) = den(61)*den(138)
  den(313) = den(10)*den(287)
  den(314) = den(90)*den(290)
  den(315) = den(61)*den(243)
  den(316) = den(61)*den(233)
  den(317) = den(10)*den(243)
  den(318) = den(10)*den(131)
  den(319) = den(90)*den(233)
  den(320) = den(90)*den(131)
  den(321) = den(75)*den(138)
  den(322) = den(71)*den(138)
  den(323) = den(75)*den(237)
  den(324) = den(75)*den(247)
  den(325) = den(71)*den(243)
  den(326) = den(71)*den(233)
  den(327) = den(59)*den(237)
  den(328) = den(59)*den(135)
  den(329) = den(37)*den(287)
  den(330) = den(37)*den(237)
  den(331) = den(37)*den(172)
  den(332) = den(102)*den(135)
  den(333) = den(102)*den(172)
  den(334) = den(16)*den(287)
  den(335) = den(52)*den(243)
  den(336) = den(52)*den(168)
  den(337) = den(16)*den(243)
  den(338) = den(16)*den(131)
  den(339) = den(93)*den(168)
  den(340) = den(93)*den(131)
  den(341) = den(64)*den(247)
  den(342) = den(64)*den(135)
  den(343) = den(44)*den(290)
  den(344) = den(44)*den(247)
  den(345) = den(44)*den(172)
  den(346) = den(105)*den(135)
  den(347) = den(105)*den(172)
  den(348) = den(21)*den(290)
  den(349) = den(56)*den(233)
  den(350) = den(56)*den(168)
  den(351) = den(21)*den(233)
  den(352) = den(21)*den(131)
  den(353) = den(96)*den(168)
  den(354) = den(96)*den(131)
  den(355) = den(48)*den(135)
  den(356) = den(48)*den(172)
  den(357) = den(24)*den(168)
  den(358) = den(24)*den(131)
  den(359) = den(1)*den(2)*den(3)
  den(360) = den(1)*den(12)
  den(361) = den(1)*den(18)
  den(362) = den(3)*den(26)*den(27)
  den(363) = den(27)*den(36)
  den(364) = den(27)*den(42)
  den(365) = den(3)*den(293)
  den(366) = den(3)*den(309)
  den(367) = den(18)*den(36)*den(68)
  den(368) = den(12)*den(42)*den(68)
  den(369) = den(3)*den(68)
  den(370) = den(2)*den(276)
  den(371) = den(2)*den(278)
  den(372) = den(1)*den(318)
  den(373) = den(1)*den(320)
  den(374) = den(12)*den(274)
  den(375) = den(12)*den(277)
  den(376) = den(1)*den(338)
  den(377) = den(1)*den(340)
  den(378) = den(18)*den(273)
  den(379) = den(18)*den(275)
  den(380) = den(1)*den(352)
  den(381) = den(1)*den(354)
  den(382) = den(3)*den(272)
  den(383) = den(1)*den(358)
  den(384) = den(27)*den(301)
  den(385) = den(27)*den(304)
  den(386) = den(26)*den(283)
  den(387) = den(26)*den(285)
  den(388) = den(27)*den(331)
  den(389) = den(27)*den(333)
  den(390) = den(36)*den(281)
  den(391) = den(36)*den(284)
  den(392) = den(27)*den(345)
  den(393) = den(27)*den(347)
  den(394) = den(42)*den(280)
  den(395) = den(42)*den(282)
  den(396) = den(27)*den(356)
  den(397) = den(3)*den(279)
  den(398) = den(12)*den(298)
  den(399) = den(12)*den(303)
  den(400) = den(26)*den(336)
  den(401) = den(26)*den(339)
  den(402) = den(18)*den(297)
  den(403) = den(18)*den(300)
  den(404) = den(26)*den(350)
  den(405) = den(26)*den(353)
  den(406) = den(3)*den(296)
  den(407) = den(26)*den(357)
  den(408) = den(2)*den(328)
  den(409) = den(2)*den(332)
  den(410) = den(36)*den(316)
  den(411) = den(36)*den(319)
  den(412) = den(2)*den(342)
  den(413) = den(2)*den(346)
  den(414) = den(42)*den(315)
  den(415) = den(42)*den(317)
  den(416) = den(2)*den(355)
  den(417) = den(3)*den(312)
  den(418) = den(36)*den(326)
  den(419) = den(12)*den(324)
  den(420) = den(42)*den(325)
  den(421) = den(18)*den(323)
  den(422) = den(3)*den(321)
  den(423) = den(3)*den(322)
  den(424) = den(18)*den(327)
  den(425) = den(18)*den(330)
  den(426) = den(36)*den(349)
  den(427) = den(36)*den(351)
  den(428) = den(12)*den(341)
  den(429) = den(12)*den(344)
  den(430) = den(42)*den(335)
  den(431) = den(42)*den(337)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint) &
    & bind(c,name="Hol_f_amp2_ppwajj_udxawgg_1")
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint)
  use ol_loop_storage_ppwajj_udxawgg_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-down gamma W- glue glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppwajj_udxawgg_1, only: external_perm_ppwajj_udxawgg_1, &
    & external_perm_inv_ppwajj_udxawgg_1, extcomb_perm_ppwajj_udxawgg_1, &
    & average_factor_ppwajj_udxawgg_1
  use ol_external_ppwajj_udxawgg_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppwajj_udxawgg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppwajj_udxawgg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppwajj_udxawgg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L, Q
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L, Q_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(2), M2(3) 
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(2,96)
  type(Hpolcont) :: M1helarray_ct(3,96)

  type(Hpolcont) :: A(96,292)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(292)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, nMW, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppwajj_udxawgg_1, 6)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMW, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_VQ_A(ntry, ex3(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AW_Q(ntry, ex2(:), ex4(:), wf6(:,1), n3(:,2), t3x6(:,:,1))
  call vert_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,2), n3(:,3), t3x4(:,:,2))
  call prop_Q_A(ntry, wf4(:,1), 5, ZERO, 0_intkind1, wf4(:,3), n2(1))
  call prop_A_Q(ntry, wf6(:,1), 10, ZERO, 0_intkind1, wf6(:,2), n2(2))
  call vert_QA_V(ntry, wf4(:,3), wf6(:,2), wf24(:,1), n3(:,4), t3x24(:,:,1))
  call vert_VQ_A(ntry, ex5(:), wf4(:,3), wf8(:,1), n3(:,5), t3x8(:,:,1))
  call vert_AV_Q(ntry, wf6(:,2), ex6(:), wf12(:,1), n3(:,6), t3x12(:,:,1))
  call prop_Q_A(ntry, wf8(:,1), 21, ZERO, 0_intkind1, wf8(:,2), n2(3))
  call vert_AV_Q(ntry, wf6(:,2), ex5(:), wf12(:,2), n3(:,7), t3x12(:,:,2))
  call vert_VQ_A(ntry, ex6(:), wf4(:,3), wf8(:,3), n3(:,8), t3x8(:,:,2))
  call prop_A_Q(ntry, wf12(:,2), 26, ZERO, 0_intkind1, wf12(:,3), n2(4))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,4), n3(:,9), t3x4(:,:,3))
  call prop_A_Q(ntry, wf4(:,4), 18, ZERO, 0_intkind1, wf4(:,5), n2(5))
  call vert_WQ_A(ntry, ex4(:), wf4(:,3), wf12(:,4), n3(:,10), t3x12(:,:,3))
  call vert_AV_Q(ntry, wf4(:,5), ex6(:), wf8(:,4), n3(:,11), t3x8(:,:,3))
  call prop_Q_A(ntry, wf12(:,4), 13, ZERO, 0_intkind1, wf12(:,5), n2(6))
  call vert_AW_Q(ntry, wf4(:,5), ex4(:), wf12(:,6), n3(:,12), t3x12(:,:,4))
  call prop_A_Q(ntry, wf12(:,6), 26, ZERO, 0_intkind1, wf12(:,7), n2(7))
  call vert_AV_Q(ntry, ex2(:), ex6(:), wf4(:,6), n3(:,13), t3x4(:,:,4))
  call prop_A_Q(ntry, wf4(:,6), 34, ZERO, 0_intkind1, wf4(:,7), n2(8))
  call vert_AV_Q(ntry, wf4(:,7), ex5(:), wf8(:,5), n3(:,14), t3x8(:,:,4))
  call vert_AW_Q(ntry, wf4(:,7), ex4(:), wf12(:,8), n3(:,15), t3x12(:,:,5))
  call prop_A_Q(ntry, wf12(:,8), 42, ZERO, 0_intkind1, wf12(:,9), n2(9))
  call vert_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,6), n3(:,16), t3x8(:,:,5))
  call prop_A_Q(ntry, wf8(:,6), 50, ZERO, 0_intkind1, wf8(:,7), n2(10))
  call vert_WQ_A(ntry, ex4(:), ex1(:), wf6(:,3), n3(:,17), t3x6(:,:,2))
  call vert_AV_Q(ntry, ex2(:), ex3(:), wf4(:,8), n3(:,18), t3x4(:,:,5))
  call prop_Q_A(ntry, wf6(:,3), 9, ZERO, 0_intkind1, wf6(:,4), n2(11))
  call prop_A_Q(ntry, wf4(:,8), 6, ZERO, 0_intkind1, wf4(:,9), n2(12))
  call vert_QA_V(ntry, wf6(:,4), wf4(:,9), wf24(:,2), n3(:,19), t3x24(:,:,2))
  call vert_VQ_A(ntry, ex5(:), wf6(:,4), wf12(:,10), n3(:,20), t3x12(:,:,6))
  call vert_AV_Q(ntry, wf4(:,9), ex6(:), wf8(:,8), n3(:,21), t3x8(:,:,6))
  call prop_Q_A(ntry, wf12(:,10), 25, ZERO, 0_intkind1, wf12(:,11), n2(13))
  call vert_AV_Q(ntry, wf4(:,9), ex5(:), wf8(:,9), n3(:,22), t3x8(:,:,7))
  call vert_VQ_A(ntry, ex6(:), wf6(:,4), wf12(:,12), n3(:,23), t3x12(:,:,7))
  call prop_A_Q(ntry, wf8(:,9), 22, ZERO, 0_intkind1, wf8(:,10), n2(14))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,10), n3(:,24), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,10), 17, ZERO, 0_intkind1, wf4(:,11), n2(15))
  call vert_WQ_A(ntry, ex4(:), wf4(:,11), wf12(:,13), n3(:,25), t3x12(:,:,8))
  call prop_Q_A(ntry, wf12(:,13), 25, ZERO, 0_intkind1, wf12(:,14), n2(16))
  call vert_AW_Q(ntry, wf4(:,9), ex4(:), wf12(:,15), n3(:,26), t3x12(:,:,9))
  call vert_VQ_A(ntry, ex6(:), wf4(:,11), wf8(:,11), n3(:,27), t3x8(:,:,8))
  call prop_A_Q(ntry, wf12(:,15), 14, ZERO, 0_intkind1, wf12(:,16), n2(17))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,12), n3(:,28), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,12), 33, ZERO, 0_intkind1, wf4(:,13), n2(18))
  call vert_WQ_A(ntry, ex4(:), wf4(:,13), wf12(:,17), n3(:,29), t3x12(:,:,10))
  call prop_Q_A(ntry, wf12(:,17), 41, ZERO, 0_intkind1, wf12(:,18), n2(19))
  call vert_VQ_A(ntry, ex5(:), wf4(:,13), wf8(:,12), n3(:,30), t3x8(:,:,9))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,13), n3(:,31), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,13), 49, ZERO, 0_intkind1, wf8(:,14), n2(20))
  call vert_VQ_A(ntry, ex3(:), wf6(:,4), wf12(:,19), n3(:,32), t3x12(:,:,11))
  call prop_Q_A(ntry, wf12(:,19), 13, ZERO, 0_intkind1, wf12(:,20), n2(21))
  call vert_AV_Q(ntry, wf4(:,5), ex3(:), wf8(:,15), n3(:,33), t3x8(:,:,11))
  call prop_A_Q(ntry, wf8(:,15), 22, ZERO, 0_intkind1, wf8(:,16), n2(22))
  call vert_AV_Q(ntry, wf4(:,7), ex3(:), wf8(:,17), n3(:,34), t3x8(:,:,12))
  call prop_A_Q(ntry, wf8(:,17), 38, ZERO, 0_intkind1, wf8(:,18), n2(23))
  call vert_VQ_A(ntry, ex3(:), wf4(:,11), wf8(:,19), n3(:,35), t3x8(:,:,13))
  call prop_Q_A(ntry, wf8(:,19), 21, ZERO, 0_intkind1, wf8(:,20), n2(24))
  call vert_AV_Q(ntry, wf6(:,2), ex3(:), wf12(:,21), n3(:,36), t3x12(:,:,12))
  call prop_A_Q(ntry, wf12(:,21), 14, ZERO, 0_intkind1, wf12(:,22), n2(25))
  call vert_VQ_A(ntry, ex3(:), wf4(:,13), wf8(:,21), n3(:,37), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,21), 37, ZERO, 0_intkind1, wf8(:,22), n2(26))
  call vert_UV_W(ntry, ex4(:), 8, ex3(:), 4, wf6(:,5), n3(:,38), t3x6(:,:,3))
  call prop_W_W(ntry, wf6(:,5), 12, MW, 1_intkind1, wf6(:,6), n2(27))
  call vert_QA_W(ntry, wf4(:,11), wf4(:,7), wf16(:,1), n3(:,39), t3x16(:,:,1))
  call vert_AW_Q(ntry, ex2(:), wf6(:,6), wf12(:,23), n3(:,40), t3x12(:,:,13))
  call prop_A_Q(ntry, wf12(:,23), 14, ZERO, 0_intkind1, wf12(:,24), n2(28))
  call vert_QA_W(ntry, wf4(:,13), wf4(:,5), wf16(:,2), n3(:,41), t3x16(:,:,2))
  call vert_WQ_A(ntry, wf6(:,6), ex1(:), wf12(:,25), n3(:,42), t3x12(:,:,14))
  call prop_Q_A(ntry, wf12(:,25), 13, ZERO, 0_intkind1, wf12(:,26), n2(29))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex5(:), ex6(:), wf8(:,23), n4(:,1), t4x8(:,:,1))
  call vert_QA_V(ntry, wf6(:,4), ex2(:), wf12(:,27), n3(:,43), t3x12(:,:,15))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex6(:), ex5(:), wf8(:,24), n4(:,2), t4x8(:,:,2))
  call vert_QA_V(ntry, ex1(:), wf6(:,2), wf12(:,28), n3(:,44), t3x12(:,:,16))
  call counter_QA_V(ntry, wf4(:,3), wf6(:,2), wf24(:,3), n3(:,45), t3x24(:,:,3))
  call counter_AV_Q(ntry, wf6(:,2), ex6(:), wf12(:,29), n3(:,46), t3x12(:,:,17))
  call counter_VQ_A(ntry, ex6(:), wf4(:,3), wf8(:,25), n3(:,47), t3x8(:,:,15))
  call counter_AV_Q(ntry, wf6(:,2), ex5(:), wf12(:,30), n3(:,48), t3x12(:,:,18))
  call prop_Q_A(ntry, wf8(:,3), 37, ZERO, 0_intkind1, wf8(:,26), n2(30))
  call counter_VQ_A(ntry, ex5(:), wf4(:,3), wf8(:,27), n3(:,49), t3x8(:,:,16))
  call prop_A_Q(ntry, wf12(:,1), 42, ZERO, 0_intkind1, wf12(:,31), n2(31))
  call counter_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,14), n3(:,50), t3x4(:,:,8))
  call counter_AV_Q(ntry, wf4(:,5), ex6(:), wf8(:,28), n3(:,51), t3x8(:,:,17))
  call counter_AV_Q(ntry, wf4(:,7), ex5(:), wf8(:,29), n3(:,52), t3x8(:,:,18))
  call vert_AV_Q(ntry, ex2(:), wf4(:,14), wf8(:,30), n3(:,53), t3x8(:,:,19))
  call prop_A_Q(ntry, wf8(:,30), 50, ZERO, 0_intkind1, wf8(:,31), n2(32))
  call counter_AW_Q(ntry, wf4(:,5), ex4(:), wf12(:,32), n3(:,54), t3x12(:,:,19))
  call counter_WQ_A(ntry, ex4(:), wf4(:,3), wf12(:,33), n3(:,55), t3x12(:,:,20))
  call prop_A_Q(ntry, wf8(:,4), 50, ZERO, 0_intkind1, wf8(:,32), n2(33))
  call counter_AW_Q(ntry, wf4(:,7), ex4(:), wf12(:,34), n3(:,56), t3x12(:,:,21))
  call prop_A_Q(ntry, wf8(:,5), 50, ZERO, 0_intkind1, wf8(:,33), n2(34))
  call counter_QA_V(ntry, wf6(:,4), wf4(:,9), wf24(:,4), n3(:,57), t3x24(:,:,4))
  call counter_AV_Q(ntry, wf4(:,9), ex6(:), wf8(:,34), n3(:,58), t3x8(:,:,20))
  call counter_VQ_A(ntry, ex6(:), wf6(:,4), wf12(:,35), n3(:,59), t3x12(:,:,22))
  call counter_AV_Q(ntry, wf4(:,9), ex5(:), wf8(:,35), n3(:,60), t3x8(:,:,21))
  call prop_Q_A(ntry, wf12(:,12), 41, ZERO, 0_intkind1, wf12(:,36), n2(35))
  call counter_VQ_A(ntry, ex5(:), wf6(:,4), wf12(:,37), n3(:,61), t3x12(:,:,23))
  call prop_A_Q(ntry, wf8(:,8), 38, ZERO, 0_intkind1, wf8(:,36), n2(36))
  call counter_VQ_A(ntry, ex6(:), wf4(:,11), wf8(:,37), n3(:,62), t3x8(:,:,22))
  call counter_VQ_A(ntry, ex5(:), wf4(:,13), wf8(:,38), n3(:,63), t3x8(:,:,23))
  call vert_VQ_A(ntry, wf4(:,14), ex1(:), wf8(:,39), n3(:,64), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,39), 49, ZERO, 0_intkind1, wf8(:,40), n2(37))
  call counter_AW_Q(ntry, wf4(:,9), ex4(:), wf12(:,38), n3(:,65), t3x12(:,:,24))
  call prop_Q_A(ntry, wf8(:,11), 49, ZERO, 0_intkind1, wf8(:,41), n2(38))
  call counter_WQ_A(ntry, ex4(:), wf4(:,11), wf12(:,39), n3(:,66), t3x12(:,:,25))
  call prop_Q_A(ntry, wf8(:,12), 49, ZERO, 0_intkind1, wf8(:,42), n2(39))
  call counter_WQ_A(ntry, ex4(:), wf4(:,13), wf12(:,40), n3(:,67), t3x12(:,:,26))
  call counter_QA_W(ntry, wf4(:,11), wf4(:,7), wf16(:,3), n3(:,68), t3x16(:,:,3))
  call counter_QA_W(ntry, wf4(:,13), wf4(:,5), wf16(:,4), n3(:,69), t3x16(:,:,4))
  call counter_AV_Q(ntry, wf4(:,5), ex3(:), wf8(:,43), n3(:,70), t3x8(:,:,25))
  call counter_VQ_A(ntry, ex3(:), wf6(:,4), wf12(:,41), n3(:,71), t3x12(:,:,27))
  call counter_AV_Q(ntry, wf4(:,7), ex3(:), wf8(:,44), n3(:,72), t3x8(:,:,26))
  call counter_AV_Q(ntry, wf6(:,2), ex3(:), wf12(:,42), n3(:,73), t3x12(:,:,28))
  call counter_VQ_A(ntry, ex3(:), wf4(:,11), wf8(:,45), n3(:,74), t3x8(:,:,27))
  call counter_VQ_A(ntry, ex3(:), wf4(:,13), wf8(:,46), n3(:,75), t3x8(:,:,28))
  call counter_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,47), n3(:,76), t3x8(:,:,29))
  call counter_AV_Q(ntry, ex2(:), ex6(:), wf4(:,15), n3(:,77), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,15), 34, ZERO, 0_intkind1, wf4(:,16), n2(40))
  call vert_AV_Q(ntry, wf4(:,16), ex5(:), wf8(:,48), n3(:,78), t3x8(:,:,30))
  call vert_AW_Q(ntry, wf4(:,16), ex4(:), wf12(:,43), n3(:,79), t3x12(:,:,29))
  call prop_A_Q(ntry, wf12(:,43), 42, ZERO, 0_intkind1, wf12(:,44), n2(41))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,17), n3(:,80), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,17), 18, ZERO, 0_intkind1, wf4(:,18), n2(42))
  call vert_AV_Q(ntry, wf4(:,18), ex6(:), wf8(:,49), n3(:,81), t3x8(:,:,31))
  call vert_AW_Q(ntry, wf4(:,18), ex4(:), wf12(:,45), n3(:,82), t3x12(:,:,30))
  call prop_A_Q(ntry, wf12(:,45), 26, ZERO, 0_intkind1, wf12(:,46), n2(43))
  call counter_AW_Q(ntry, ex2(:), ex4(:), wf6(:,7), n3(:,83), t3x6(:,:,4))
  call prop_A_Q(ntry, wf6(:,7), 10, ZERO, 0_intkind1, wf6(:,8), n2(44))
  call vert_QA_V(ntry, wf4(:,3), wf6(:,8), wf24(:,5), n3(:,84), t3x24(:,:,5))
  call vert_AV_Q(ntry, wf6(:,8), ex6(:), wf12(:,47), n3(:,85), t3x12(:,:,31))
  call vert_AV_Q(ntry, wf6(:,8), ex5(:), wf12(:,48), n3(:,86), t3x12(:,:,32))
  call prop_A_Q(ntry, wf12(:,48), 26, ZERO, 0_intkind1, wf12(:,49), n2(45))
  call vert_AV_Q(ntry, wf4(:,16), ex3(:), wf8(:,50), n3(:,87), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,50), 38, ZERO, 0_intkind1, wf8(:,51), n2(46))
  call vert_AV_Q(ntry, wf4(:,18), ex3(:), wf8(:,52), n3(:,88), t3x8(:,:,33))
  call prop_A_Q(ntry, wf8(:,52), 22, ZERO, 0_intkind1, wf8(:,53), n2(47))
  call counter_AW_Q(ntry, ex2(:), wf6(:,6), wf12(:,50), n3(:,89), t3x12(:,:,33))
  call vert_QA_W(ntry, wf4(:,11), wf4(:,16), wf16(:,5), n3(:,90), t3x16(:,:,5))
  call vert_QA_W(ntry, wf4(:,13), wf4(:,18), wf16(:,6), n3(:,91), t3x16(:,:,6))
  call vert_AV_Q(ntry, wf6(:,8), ex3(:), wf12(:,51), n3(:,92), t3x12(:,:,34))
  call prop_A_Q(ntry, wf12(:,51), 14, ZERO, 0_intkind1, wf12(:,52), n2(48))
  call counter_AV_Q(ntry, ex2(:), ex3(:), wf4(:,19), n3(:,93), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,19), 6, ZERO, 0_intkind1, wf4(:,20), n2(49))
  call vert_QA_V(ntry, wf6(:,4), wf4(:,20), wf24(:,6), n3(:,94), t3x24(:,:,6))
  call vert_AV_Q(ntry, wf4(:,20), ex6(:), wf8(:,54), n3(:,95), t3x8(:,:,34))
  call vert_AV_Q(ntry, wf4(:,20), ex5(:), wf8(:,55), n3(:,96), t3x8(:,:,35))
  call prop_A_Q(ntry, wf8(:,55), 22, ZERO, 0_intkind1, wf8(:,56), n2(50))
  call vert_AW_Q(ntry, wf4(:,20), ex4(:), wf12(:,53), n3(:,97), t3x12(:,:,35))
  call prop_A_Q(ntry, wf12(:,53), 14, ZERO, 0_intkind1, wf12(:,54), n2(51))
  call counter_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,57), n3(:,98), t3x8(:,:,36))
  call counter_VQ_A(ntry, ex6(:), ex1(:), wf4(:,21), n3(:,99), t3x4(:,:,12))
  call prop_Q_A(ntry, wf4(:,21), 33, ZERO, 0_intkind1, wf4(:,22), n2(52))
  call vert_WQ_A(ntry, ex4(:), wf4(:,22), wf12(:,55), n3(:,100), t3x12(:,:,36))
  call prop_Q_A(ntry, wf12(:,55), 41, ZERO, 0_intkind1, wf12(:,56), n2(53))
  call vert_VQ_A(ntry, ex5(:), wf4(:,22), wf8(:,58), n3(:,101), t3x8(:,:,37))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,23), n3(:,102), t3x4(:,:,13))
  call prop_Q_A(ntry, wf4(:,23), 17, ZERO, 0_intkind1, wf4(:,24), n2(54))
  call vert_WQ_A(ntry, ex4(:), wf4(:,24), wf12(:,57), n3(:,103), t3x12(:,:,37))
  call prop_Q_A(ntry, wf12(:,57), 25, ZERO, 0_intkind1, wf12(:,58), n2(55))
  call vert_VQ_A(ntry, ex6(:), wf4(:,24), wf8(:,59), n3(:,104), t3x8(:,:,38))
  call counter_WQ_A(ntry, ex4(:), ex1(:), wf6(:,9), n3(:,105), t3x6(:,:,5))
  call prop_Q_A(ntry, wf6(:,9), 9, ZERO, 0_intkind1, wf6(:,10), n2(56))
  call vert_QA_V(ntry, wf6(:,10), wf4(:,9), wf24(:,7), n3(:,106), t3x24(:,:,7))
  call vert_VQ_A(ntry, ex5(:), wf6(:,10), wf12(:,59), n3(:,107), t3x12(:,:,38))
  call prop_Q_A(ntry, wf12(:,59), 25, ZERO, 0_intkind1, wf12(:,60), n2(57))
  call vert_VQ_A(ntry, ex6(:), wf6(:,10), wf12(:,61), n3(:,108), t3x12(:,:,39))
  call vert_VQ_A(ntry, ex3(:), wf4(:,22), wf8(:,60), n3(:,109), t3x8(:,:,39))
  call prop_Q_A(ntry, wf8(:,60), 37, ZERO, 0_intkind1, wf8(:,61), n2(58))
  call vert_VQ_A(ntry, ex3(:), wf4(:,24), wf8(:,62), n3(:,110), t3x8(:,:,40))
  call prop_Q_A(ntry, wf8(:,62), 21, ZERO, 0_intkind1, wf8(:,63), n2(59))
  call counter_WQ_A(ntry, wf6(:,6), ex1(:), wf12(:,62), n3(:,111), t3x12(:,:,40))
  call vert_QA_W(ntry, wf4(:,22), wf4(:,5), wf16(:,7), n3(:,112), t3x16(:,:,7))
  call vert_QA_W(ntry, wf4(:,24), wf4(:,7), wf16(:,8), n3(:,113), t3x16(:,:,8))
  call vert_VQ_A(ntry, ex3(:), wf6(:,10), wf12(:,63), n3(:,114), t3x12(:,:,41))
  call prop_Q_A(ntry, wf12(:,63), 13, ZERO, 0_intkind1, wf12(:,64), n2(60))
  call counter_VQ_A(ntry, ex3(:), ex1(:), wf4(:,25), n3(:,115), t3x4(:,:,14))
  call prop_Q_A(ntry, wf4(:,25), 5, ZERO, 0_intkind1, wf4(:,26), n2(61))
  call vert_QA_V(ntry, wf4(:,26), wf6(:,2), wf24(:,8), n3(:,116), t3x24(:,:,8))
  call vert_VQ_A(ntry, ex5(:), wf4(:,26), wf8(:,64), n3(:,117), t3x8(:,:,41))
  call prop_Q_A(ntry, wf8(:,64), 21, ZERO, 0_intkind1, wf8(:,65), n2(62))
  call vert_VQ_A(ntry, ex6(:), wf4(:,26), wf8(:,66), n3(:,118), t3x8(:,:,42))
  call vert_WQ_A(ntry, ex4(:), wf4(:,26), wf12(:,65), n3(:,119), t3x12(:,:,42))
  call prop_Q_A(ntry, wf12(:,65), 13, ZERO, 0_intkind1, wf12(:,66), n2(63))
  call vert_AV_Q(ntry, wf6(:,2), wf4(:,2), wf24(:,9), n3(:,120), t3x24(:,:,9))
  call counter_Q_A(ctqq,2,ntry, wf4(:,3), 5, wf4(:,27), n2(64))
  call prop_A_Q(ntry, wf24(:,9), 58, ZERO, 0_intkind1, wf24(:,10), n2(65))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,3), wf16(:,9), n3(:,121), t3x16(:,:,9))
  call counter_A_Q(ctqq,2,ntry, wf6(:,2), 10, wf6(:,11), n2(66))
  call prop_Q_A(ntry, wf16(:,9), 53, ZERO, 0_intkind1, wf16(:,10), n2(67))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 48, wf4(:,28), n2(68))
  call prop_Q_A(ntry, wf4(:,27), 5, ZERO, 0_intkind1, wf4(:,29), n2(69))
  call vert_VQ_A(ntry, ex5(:), wf4(:,29), wf8(:,67), n3(:,122), t3x8(:,:,43))
  call vert_VQ_A(ntry, ex6(:), wf4(:,29), wf8(:,68), n3(:,123), t3x8(:,:,44))
  call prop_A_Q(ntry, wf6(:,11), 10, ZERO, 0_intkind1, wf6(:,12), n2(70))
  call vert_AV_Q(ntry, wf6(:,12), ex5(:), wf12(:,67), n3(:,124), t3x12(:,:,43))
  call vert_AV_Q(ntry, wf6(:,12), ex6(:), wf12(:,68), n3(:,125), t3x12(:,:,44))
  call counter_Q_A(ctqq,2,ntry, wf8(:,2), 21, wf8(:,69), n2(71))
  call counter_A_Q(ctqq,2,ntry, wf12(:,3), 26, wf12(:,69), n2(72))
  call vert_WQ_A(ntry, ex4(:), wf4(:,29), wf12(:,70), n3(:,126), t3x12(:,:,45))
  call counter_A_Q(ctqq,1,ntry, wf4(:,5), 18, wf4(:,30), n2(73))
  call prop_A_Q(ntry, wf4(:,30), 18, ZERO, 0_intkind1, wf4(:,31), n2(74))
  call vert_AW_Q(ntry, wf4(:,31), ex4(:), wf12(:,71), n3(:,127), t3x12(:,:,46))
  call vert_AV_Q(ntry, wf4(:,31), ex6(:), wf8(:,70), n3(:,128), t3x8(:,:,45))
  call counter_Q_A(ctqq,1,ntry, wf12(:,5), 13, wf12(:,72), n2(75))
  call counter_A_Q(ctqq,2,ntry, wf12(:,7), 26, wf12(:,73), n2(76))
  call counter_A_Q(ctqq,1,ntry, wf4(:,7), 34, wf4(:,32), n2(77))
  call prop_A_Q(ntry, wf4(:,32), 34, ZERO, 0_intkind1, wf4(:,33), n2(78))
  call vert_AW_Q(ntry, wf4(:,33), ex4(:), wf12(:,74), n3(:,129), t3x12(:,:,47))
  call vert_AV_Q(ntry, wf4(:,33), ex5(:), wf8(:,71), n3(:,130), t3x8(:,:,46))
  call counter_A_Q(ctqq,2,ntry, wf12(:,9), 42, wf12(:,75), n2(79))
  call counter_A_Q(ctqq,1,ntry, wf8(:,7), 50, wf8(:,72), n2(80))
  call vert_AV_Q(ntry, ex2(:), wf4(:,28), wf8(:,73), n3(:,131), t3x8(:,:,47))
  call vert_AV_Q(ntry, wf4(:,9), wf4(:,2), wf16(:,11), n3(:,132), t3x16(:,:,10))
  call counter_Q_A(ctqq,1,ntry, wf6(:,4), 9, wf6(:,13), n2(81))
  call prop_A_Q(ntry, wf16(:,11), 54, ZERO, 0_intkind1, wf16(:,12), n2(82))
  call vert_VQ_A(ntry, wf4(:,2), wf6(:,4), wf24(:,11), n3(:,133), t3x24(:,:,10))
  call counter_A_Q(ctqq,1,ntry, wf4(:,9), 6, wf4(:,34), n2(83))
  call prop_Q_A(ntry, wf24(:,11), 57, ZERO, 0_intkind1, wf24(:,12), n2(84))
  call prop_Q_A(ntry, wf6(:,13), 9, ZERO, 0_intkind1, wf6(:,14), n2(85))
  call vert_VQ_A(ntry, ex5(:), wf6(:,14), wf12(:,76), n3(:,134), t3x12(:,:,48))
  call vert_VQ_A(ntry, ex6(:), wf6(:,14), wf12(:,77), n3(:,135), t3x12(:,:,49))
  call prop_A_Q(ntry, wf4(:,34), 6, ZERO, 0_intkind1, wf4(:,35), n2(86))
  call vert_AV_Q(ntry, wf4(:,35), ex5(:), wf8(:,74), n3(:,136), t3x8(:,:,48))
  call vert_AV_Q(ntry, wf4(:,35), ex6(:), wf8(:,75), n3(:,137), t3x8(:,:,49))
  call counter_Q_A(ctqq,1,ntry, wf12(:,11), 25, wf12(:,78), n2(87))
  call counter_A_Q(ctqq,1,ntry, wf8(:,10), 22, wf8(:,76), n2(88))
  call counter_Q_A(ctqq,2,ntry, wf4(:,11), 17, wf4(:,36), n2(89))
  call prop_Q_A(ntry, wf4(:,36), 17, ZERO, 0_intkind1, wf4(:,37), n2(90))
  call vert_WQ_A(ntry, ex4(:), wf4(:,37), wf12(:,79), n3(:,138), t3x12(:,:,50))
  call vert_VQ_A(ntry, ex6(:), wf4(:,37), wf8(:,77), n3(:,139), t3x8(:,:,50))
  call vert_AW_Q(ntry, wf4(:,35), ex4(:), wf12(:,80), n3(:,140), t3x12(:,:,51))
  call counter_Q_A(ctqq,1,ntry, wf12(:,14), 25, wf12(:,81), n2(91))
  call counter_A_Q(ctqq,2,ntry, wf12(:,16), 14, wf12(:,82), n2(92))
  call counter_Q_A(ctqq,2,ntry, wf4(:,13), 33, wf4(:,38), n2(93))
  call prop_Q_A(ntry, wf4(:,38), 33, ZERO, 0_intkind1, wf4(:,39), n2(94))
  call vert_WQ_A(ntry, ex4(:), wf4(:,39), wf12(:,83), n3(:,141), t3x12(:,:,52))
  call vert_VQ_A(ntry, ex5(:), wf4(:,39), wf8(:,78), n3(:,142), t3x8(:,:,51))
  call counter_Q_A(ctqq,1,ntry, wf12(:,18), 41, wf12(:,84), n2(95))
  call counter_Q_A(ctqq,2,ntry, wf8(:,14), 49, wf8(:,79), n2(96))
  call vert_VQ_A(ntry, wf4(:,28), ex1(:), wf8(:,80), n3(:,143), t3x8(:,:,52))
  call vert_VQ_A(ntry, ex3(:), wf6(:,14), wf12(:,85), n3(:,144), t3x12(:,:,53))
  call vert_AV_Q(ntry, wf4(:,31), ex3(:), wf8(:,81), n3(:,145), t3x8(:,:,53))
  call counter_Q_A(ctqq,1,ntry, wf12(:,20), 13, wf12(:,86), n2(97))
  call counter_A_Q(ctqq,1,ntry, wf8(:,16), 22, wf8(:,82), n2(98))
  call vert_AV_Q(ntry, wf4(:,33), ex3(:), wf8(:,83), n3(:,146), t3x8(:,:,54))
  call counter_A_Q(ctqq,1,ntry, wf8(:,18), 38, wf8(:,84), n2(99))
  call vert_VQ_A(ntry, ex3(:), wf4(:,37), wf8(:,85), n3(:,147), t3x8(:,:,55))
  call vert_AV_Q(ntry, wf6(:,12), ex3(:), wf12(:,87), n3(:,148), t3x12(:,:,54))
  call counter_Q_A(ctqq,2,ntry, wf8(:,20), 21, wf8(:,86), n2(100))
  call counter_A_Q(ctqq,2,ntry, wf12(:,22), 14, wf12(:,88), n2(101))
  call vert_VQ_A(ntry, ex3(:), wf4(:,39), wf8(:,87), n3(:,149), t3x8(:,:,56))
  call counter_Q_A(ctqq,2,ntry, wf8(:,22), 37, wf8(:,88), n2(102))
  call vert_AW_Q(ntry, wf4(:,7), wf6(:,6), wf24(:,13), n3(:,150), t3x24(:,:,11))
  call prop_A_Q(ntry, wf24(:,13), 46, ZERO, 0_intkind1, wf24(:,14), n2(103))
  call vert_WQ_A(ntry, wf6(:,6), wf4(:,11), wf24(:,15), n3(:,151), t3x24(:,:,12))
  call prop_Q_A(ntry, wf24(:,15), 29, ZERO, 0_intkind1, wf24(:,16), n2(104))
  call counter_A_Q(ctqq,2,ntry, wf12(:,24), 14, wf12(:,89), n2(105))
  call vert_AW_Q(ntry, wf4(:,5), wf6(:,6), wf24(:,17), n3(:,152), t3x24(:,:,13))
  call prop_A_Q(ntry, wf24(:,17), 30, ZERO, 0_intkind1, wf24(:,18), n2(106))
  call vert_WQ_A(ntry, wf6(:,6), wf4(:,13), wf24(:,19), n3(:,153), t3x24(:,:,14))
  call prop_Q_A(ntry, wf24(:,19), 45, ZERO, 0_intkind1, wf24(:,20), n2(107))
  call counter_Q_A(ctqq,1,ntry, wf12(:,26), 13, wf12(:,90), n2(108))
  call vert_QA_V(ntry, wf12(:,5), ex2(:), wf24(:,21), n3(:,154), t3x24(:,:,15))
  call vert_VQ_A(ntry, ex5(:), wf12(:,5), wf24(:,22), n3(:,155), t3x24(:,:,16))
  call prop_Q_A(ntry, wf24(:,22), 29, ZERO, 0_intkind1, wf24(:,23), n2(109))
  call vert_VQ_A(ntry, ex6(:), wf12(:,5), wf24(:,24), n3(:,156), t3x24(:,:,17))
  call prop_Q_A(ntry, wf24(:,24), 45, ZERO, 0_intkind1, wf24(:,25), n2(110))
  call vert_WQ_A(ntry, ex4(:), wf8(:,2), wf24(:,26), n3(:,157), t3x24(:,:,18))
  call prop_Q_A(ntry, wf24(:,26), 29, ZERO, 0_intkind1, wf24(:,27), n2(111))
  call vert_VQ_A(ntry, ex6(:), wf8(:,2), wf16(:,13), n3(:,158), t3x16(:,:,11))
  call prop_Q_A(ntry, wf16(:,13), 53, ZERO, 0_intkind1, wf16(:,14), n2(112))
  call vert_WQ_A(ntry, ex4(:), wf8(:,26), wf24(:,28), n3(:,159), t3x24(:,:,19))
  call prop_Q_A(ntry, wf24(:,28), 45, ZERO, 0_intkind1, wf24(:,29), n2(113))
  call vert_VQ_A(ntry, ex5(:), wf8(:,26), wf16(:,15), n3(:,160), t3x16(:,:,12))
  call prop_Q_A(ntry, wf16(:,15), 53, ZERO, 0_intkind1, wf16(:,16), n2(114))
  call vert_QA_V(ntry, ex1(:), wf12(:,16), wf24(:,30), n3(:,161), t3x24(:,:,20))
  call vert_AV_Q(ntry, wf12(:,16), ex5(:), wf24(:,31), n3(:,162), t3x24(:,:,21))
  call prop_A_Q(ntry, wf24(:,31), 30, ZERO, 0_intkind1, wf24(:,32), n2(115))
  call vert_AV_Q(ntry, wf12(:,16), ex6(:), wf24(:,33), n3(:,163), t3x24(:,:,22))
  call prop_A_Q(ntry, wf24(:,33), 46, ZERO, 0_intkind1, wf24(:,34), n2(116))
  call vert_AW_Q(ntry, wf8(:,10), ex4(:), wf24(:,35), n3(:,164), t3x24(:,:,23))
  call prop_A_Q(ntry, wf24(:,35), 30, ZERO, 0_intkind1, wf24(:,36), n2(117))
  call vert_AV_Q(ntry, wf8(:,10), ex6(:), wf16(:,17), n3(:,165), t3x16(:,:,13))
  call prop_A_Q(ntry, wf16(:,17), 54, ZERO, 0_intkind1, wf16(:,18), n2(118))
  call vert_AW_Q(ntry, wf8(:,36), ex4(:), wf24(:,37), n3(:,166), t3x24(:,:,24))
  call prop_A_Q(ntry, wf24(:,37), 46, ZERO, 0_intkind1, wf24(:,38), n2(119))
  call vert_AV_Q(ntry, wf8(:,36), ex5(:), wf16(:,19), n3(:,167), t3x16(:,:,14))
  call prop_A_Q(ntry, wf16(:,19), 54, ZERO, 0_intkind1, wf16(:,20), n2(120))
  call vert_QA_V(ntry, wf6(:,4), wf4(:,5), wf24(:,39), n3(:,168), t3x24(:,:,25))
  call vert_QA_V(ntry, wf6(:,4), wf4(:,7), wf24(:,40), n3(:,169), t3x24(:,:,26))
  call vert_UV_W(ntry, wf12(:,27), 11, ex5(:), 16, wf24(:,41), n3(:,170), t3x24(:,:,27))
  call vert_UV_W(ntry, wf12(:,27), 11, ex6(:), 32, wf24(:,42), n3(:,171), t3x24(:,:,28))
  call vert_QA_V(ntry, wf12(:,20), ex2(:), wf24(:,43), n3(:,172), t3x24(:,:,29))
  call vert_VQ_A(ntry, ex5(:), wf12(:,20), wf24(:,44), n3(:,173), t3x24(:,:,30))
  call prop_Q_A(ntry, wf24(:,44), 29, ZERO, 0_intkind1, wf24(:,45), n2(121))
  call vert_VQ_A(ntry, ex6(:), wf12(:,20), wf24(:,46), n3(:,174), t3x24(:,:,31))
  call prop_Q_A(ntry, wf24(:,46), 45, ZERO, 0_intkind1, wf24(:,47), n2(122))
  call vert_QA_V(ntry, wf12(:,11), ex2(:), wf24(:,48), n3(:,175), t3x24(:,:,32))
  call vert_VQ_A(ntry, ex3(:), wf12(:,11), wf24(:,49), n3(:,176), t3x24(:,:,33))
  call prop_Q_A(ntry, wf24(:,49), 29, ZERO, 0_intkind1, wf24(:,50), n2(123))
  call vert_VQ_A(ntry, ex6(:), wf12(:,11), wf24(:,51), n3(:,177), t3x24(:,:,34))
  call prop_Q_A(ntry, wf24(:,51), 57, ZERO, 0_intkind1, wf24(:,52), n2(124))
  call vert_QA_V(ntry, wf12(:,36), ex2(:), wf24(:,53), n3(:,178), t3x24(:,:,35))
  call vert_VQ_A(ntry, ex3(:), wf12(:,36), wf24(:,54), n3(:,179), t3x24(:,:,36))
  call prop_Q_A(ntry, wf24(:,54), 45, ZERO, 0_intkind1, wf24(:,55), n2(125))
  call vert_VQ_A(ntry, ex5(:), wf12(:,36), wf24(:,56), n3(:,180), t3x24(:,:,37))
  call prop_Q_A(ntry, wf24(:,56), 57, ZERO, 0_intkind1, wf24(:,57), n2(126))
  call vert_QA_V(ntry, wf4(:,11), wf6(:,2), wf24(:,58), n3(:,181), t3x24(:,:,38))
  call vert_QA_V(ntry, wf4(:,13), wf6(:,2), wf24(:,59), n3(:,182), t3x24(:,:,39))
  call vert_UV_W(ntry, wf12(:,28), 11, ex5(:), 16, wf24(:,60), n3(:,183), t3x24(:,:,40))
  call vert_UV_W(ntry, wf12(:,28), 11, ex6(:), 32, wf24(:,61), n3(:,184), t3x24(:,:,41))
  call vert_QA_V(ntry, ex1(:), wf12(:,22), wf24(:,62), n3(:,185), t3x24(:,:,42))
  call vert_QA_V(ntry, ex1(:), wf12(:,3), wf24(:,63), n3(:,186), t3x24(:,:,43))
  call vert_QA_V(ntry, ex1(:), wf12(:,31), wf24(:,64), n3(:,187), t3x24(:,:,44))
  call vert_AV_Q(ntry, wf12(:,22), ex5(:), wf24(:,65), n3(:,188), t3x24(:,:,45))
  call prop_A_Q(ntry, wf24(:,65), 30, ZERO, 0_intkind1, wf24(:,66), n2(127))
  call vert_AV_Q(ntry, wf12(:,22), ex6(:), wf24(:,67), n3(:,189), t3x24(:,:,46))
  call prop_A_Q(ntry, wf24(:,67), 46, ZERO, 0_intkind1, wf24(:,68), n2(128))
  call vert_AV_Q(ntry, wf12(:,3), ex3(:), wf24(:,69), n3(:,190), t3x24(:,:,47))
  call prop_A_Q(ntry, wf24(:,69), 30, ZERO, 0_intkind1, wf24(:,70), n2(129))
  call vert_AV_Q(ntry, wf12(:,3), ex6(:), wf24(:,71), n3(:,191), t3x24(:,:,48))
  call prop_A_Q(ntry, wf24(:,71), 58, ZERO, 0_intkind1, wf24(:,72), n2(130))
  call vert_AV_Q(ntry, wf12(:,31), ex3(:), wf24(:,73), n3(:,192), t3x24(:,:,49))
  call prop_A_Q(ntry, wf24(:,73), 46, ZERO, 0_intkind1, wf24(:,74), n2(131))
  call vert_AV_Q(ntry, wf12(:,31), ex5(:), wf24(:,75), n3(:,193), t3x24(:,:,50))
  call prop_A_Q(ntry, wf24(:,75), 58, ZERO, 0_intkind1, wf24(:,76), n2(132))
  call vert_QA_V(ntry, wf12(:,26), ex2(:), wf24(:,77), n3(:,194), t3x24(:,:,51))
  call vert_QA_V(ntry, ex1(:), wf12(:,24), wf24(:,78), n3(:,195), t3x24(:,:,52))
  call vert_VQ_A(ntry, ex5(:), wf12(:,26), wf24(:,79), n3(:,196), t3x24(:,:,53))
  call prop_Q_A(ntry, wf24(:,79), 29, ZERO, 0_intkind1, wf24(:,80), n2(133))
  call vert_VQ_A(ntry, ex6(:), wf12(:,26), wf24(:,81), n3(:,197), t3x24(:,:,54))
  call prop_Q_A(ntry, wf24(:,81), 45, ZERO, 0_intkind1, wf24(:,82), n2(134))
  call vert_AV_Q(ntry, wf12(:,24), ex5(:), wf24(:,83), n3(:,198), t3x24(:,:,55))
  call prop_A_Q(ntry, wf24(:,83), 30, ZERO, 0_intkind1, wf24(:,84), n2(135))
  call vert_AV_Q(ntry, wf12(:,24), ex6(:), wf24(:,85), n3(:,199), t3x24(:,:,56))
  call prop_A_Q(ntry, wf24(:,85), 46, ZERO, 0_intkind1, wf24(:,86), n2(136))
  call vert_WQ_A(ntry, ex4(:), wf8(:,20), wf24(:,87), n3(:,200), t3x24(:,:,57))
  call prop_Q_A(ntry, wf24(:,87), 29, ZERO, 0_intkind1, wf24(:,88), n2(137))
  call vert_VQ_A(ntry, ex6(:), wf8(:,20), wf16(:,21), n3(:,201), t3x16(:,:,15))
  call prop_Q_A(ntry, wf16(:,21), 53, ZERO, 0_intkind1, wf16(:,22), n2(138))
  call vert_QA_V(ntry, wf12(:,14), ex2(:), wf24(:,89), n3(:,202), t3x24(:,:,58))
  call vert_VQ_A(ntry, ex3(:), wf12(:,14), wf24(:,90), n3(:,203), t3x24(:,:,59))
  call prop_Q_A(ntry, wf24(:,90), 29, ZERO, 0_intkind1, wf24(:,91), n2(139))
  call vert_VQ_A(ntry, ex6(:), wf12(:,14), wf24(:,92), n3(:,204), t3x24(:,:,60))
  call prop_Q_A(ntry, wf24(:,92), 57, ZERO, 0_intkind1, wf24(:,93), n2(140))
  call vert_VQ_A(ntry, ex3(:), wf8(:,41), wf16(:,23), n3(:,205), t3x16(:,:,16))
  call prop_Q_A(ntry, wf16(:,23), 53, ZERO, 0_intkind1, wf16(:,24), n2(141))
  call vert_WQ_A(ntry, ex4(:), wf8(:,41), wf24(:,94), n3(:,206), t3x24(:,:,61))
  call prop_Q_A(ntry, wf24(:,94), 57, ZERO, 0_intkind1, wf24(:,95), n2(142))
  call vert_QA_V(ntry, ex1(:), wf12(:,7), wf24(:,96), n3(:,207), t3x24(:,:,62))
  call vert_AW_Q(ntry, wf8(:,16), ex4(:), wf24(:,97), n3(:,208), t3x24(:,:,63))
  call prop_A_Q(ntry, wf24(:,97), 30, ZERO, 0_intkind1, wf24(:,98), n2(143))
  call vert_AV_Q(ntry, wf8(:,16), ex6(:), wf16(:,25), n3(:,209), t3x16(:,:,17))
  call prop_A_Q(ntry, wf16(:,25), 54, ZERO, 0_intkind1, wf16(:,26), n2(144))
  call vert_AV_Q(ntry, wf12(:,7), ex3(:), wf24(:,99), n3(:,210), t3x24(:,:,64))
  call prop_A_Q(ntry, wf24(:,99), 30, ZERO, 0_intkind1, wf24(:,100), n2(145))
  call vert_AV_Q(ntry, wf12(:,7), ex6(:), wf24(:,101), n3(:,211), t3x24(:,:,65))
  call prop_A_Q(ntry, wf24(:,101), 58, ZERO, 0_intkind1, wf24(:,102), n2(146))
  call vert_AV_Q(ntry, wf8(:,32), ex3(:), wf16(:,27), n3(:,212), t3x16(:,:,18))
  call prop_A_Q(ntry, wf16(:,27), 54, ZERO, 0_intkind1, wf16(:,28), n2(147))
  call vert_AW_Q(ntry, wf8(:,32), ex4(:), wf24(:,103), n3(:,213), t3x24(:,:,66))
  call prop_A_Q(ntry, wf24(:,103), 58, ZERO, 0_intkind1, wf24(:,104), n2(148))
  call vert_WQ_A(ntry, ex4(:), wf8(:,22), wf24(:,105), n3(:,214), t3x24(:,:,67))
  call prop_Q_A(ntry, wf24(:,105), 45, ZERO, 0_intkind1, wf24(:,106), n2(149))
  call vert_VQ_A(ntry, ex5(:), wf8(:,22), wf16(:,29), n3(:,215), t3x16(:,:,19))
  call prop_Q_A(ntry, wf16(:,29), 53, ZERO, 0_intkind1, wf16(:,30), n2(150))
  call vert_QA_V(ntry, wf12(:,18), ex2(:), wf24(:,107), n3(:,216), t3x24(:,:,68))
  call vert_VQ_A(ntry, ex3(:), wf12(:,18), wf24(:,108), n3(:,217), t3x24(:,:,69))
  call prop_Q_A(ntry, wf24(:,108), 45, ZERO, 0_intkind1, wf24(:,109), n2(151))
  call vert_VQ_A(ntry, ex5(:), wf12(:,18), wf24(:,110), n3(:,218), t3x24(:,:,70))
  call prop_Q_A(ntry, wf24(:,110), 57, ZERO, 0_intkind1, wf24(:,111), n2(152))
  call vert_VQ_A(ntry, ex3(:), wf8(:,42), wf16(:,31), n3(:,219), t3x16(:,:,20))
  call prop_Q_A(ntry, wf16(:,31), 53, ZERO, 0_intkind1, wf16(:,32), n2(153))
  call vert_WQ_A(ntry, ex4(:), wf8(:,42), wf24(:,112), n3(:,220), t3x24(:,:,71))
  call prop_Q_A(ntry, wf24(:,112), 57, ZERO, 0_intkind1, wf24(:,113), n2(154))
  call vert_QA_V(ntry, ex1(:), wf12(:,9), wf24(:,114), n3(:,221), t3x24(:,:,72))
  call vert_AW_Q(ntry, wf8(:,18), ex4(:), wf24(:,115), n3(:,222), t3x24(:,:,73))
  call prop_A_Q(ntry, wf24(:,115), 46, ZERO, 0_intkind1, wf24(:,116), n2(155))
  call vert_AV_Q(ntry, wf8(:,18), ex5(:), wf16(:,33), n3(:,223), t3x16(:,:,21))
  call prop_A_Q(ntry, wf16(:,33), 54, ZERO, 0_intkind1, wf16(:,34), n2(156))
  call vert_AV_Q(ntry, wf12(:,9), ex3(:), wf24(:,117), n3(:,224), t3x24(:,:,74))
  call prop_A_Q(ntry, wf24(:,117), 46, ZERO, 0_intkind1, wf24(:,118), n2(157))
  call vert_AV_Q(ntry, wf12(:,9), ex5(:), wf24(:,119), n3(:,225), t3x24(:,:,75))
  call prop_A_Q(ntry, wf24(:,119), 58, ZERO, 0_intkind1, wf24(:,120), n2(158))
  call vert_AV_Q(ntry, wf8(:,33), ex3(:), wf16(:,35), n3(:,226), t3x16(:,:,22))
  call prop_A_Q(ntry, wf16(:,35), 54, ZERO, 0_intkind1, wf16(:,36), n2(159))
  call vert_AW_Q(ntry, wf8(:,33), ex4(:), wf24(:,121), n3(:,227), t3x24(:,:,76))
  call prop_A_Q(ntry, wf24(:,121), 58, ZERO, 0_intkind1, wf24(:,122), n2(160))
  call vert_VQ_A(ntry, ex3(:), wf8(:,14), wf16(:,37), n3(:,228), t3x16(:,:,23))
  call prop_Q_A(ntry, wf16(:,37), 53, ZERO, 0_intkind1, wf16(:,38), n2(161))
  call vert_WQ_A(ntry, ex4(:), wf8(:,14), wf24(:,123), n3(:,229), t3x24(:,:,77))
  call prop_Q_A(ntry, wf24(:,123), 57, ZERO, 0_intkind1, wf24(:,124), n2(162))
  call vert_AV_Q(ntry, wf8(:,7), ex3(:), wf16(:,39), n3(:,230), t3x16(:,:,24))
  call prop_A_Q(ntry, wf16(:,39), 54, ZERO, 0_intkind1, wf16(:,40), n2(163))
  call vert_AW_Q(ntry, wf8(:,7), ex4(:), wf24(:,125), n3(:,231), t3x24(:,:,78))
  call prop_A_Q(ntry, wf24(:,125), 58, ZERO, 0_intkind1, wf24(:,126), n2(164))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf6)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf12)
  call init_hybrid_wf(wf16)
  call init_hybrid_wf(wf24)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
    do k = 1, nhel
      call colint(M1helarray(:,k)%j, M2add)
      call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
      if (IR_is_on > 0) then
	call colint_IR(M1helarray(:,k)%j, M2add_colint)
      end if
      !summation over helicity configurations
      M02 = M02 + M2add
      M2ct = M2ct + M2add_ct
      M2colint = M2colint + M2add_colint
    end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 3
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,2), wf24(:,1), A(:,1), n3(:,232), t3x96(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,1), wf8(:,2), A(:,2), n3(:,233), t3x96(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,3), A(:,3), n3(:,234), t3x96(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,5), A(:,4), n3(:,235), t3x96(:,:,4), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,7), A(:,5), n3(:,236), t3x96(:,:,5), nhel, den(17))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,5), A(:,6), n3(:,237), t3x96(:,:,6), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,1), wf12(:,9), A(:,7), n3(:,238), t3x96(:,:,7), nhel, den(22))
    call Hcont_QA(nsync, wf12(:,4), wf8(:,7), A(:,8), n3(:,239), t3x96(:,:,8), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,2), wf24(:,2), A(:,9), n3(:,240), t3x96(:,:,9), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,11), A(:,10), n3(:,241), t3x96(:,:,10), nhel, den(32))
    call Hcont_QA(nsync, wf12(:,12), wf8(:,10), A(:,11), n3(:,242), t3x96(:,:,11), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,14), A(:,12), n3(:,243), t3x96(:,:,12), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,11), wf12(:,16), A(:,13), n3(:,244), t3x96(:,:,13), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,18), A(:,14), n3(:,245), t3x96(:,:,14), nhel, den(45))
    call Hcont_QA(nsync, wf12(:,16), wf8(:,12), A(:,15), n3(:,246), t3x96(:,:,15), nhel, den(46))
    call Hcont_QA(nsync, wf12(:,15), wf8(:,14), A(:,16), n3(:,247), t3x96(:,:,16), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,20), A(:,17), n3(:,248), t3x96(:,:,17), nhel, den(51))
    call Hcont_QA(nsync, wf12(:,12), wf8(:,16), A(:,18), n3(:,249), t3x96(:,:,18), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,20), A(:,19), n3(:,250), t3x96(:,:,19), nhel, den(54))
    call Hcont_QA(nsync, wf12(:,10), wf8(:,18), A(:,20), n3(:,251), t3x96(:,:,20), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,19), A(:,21), n3(:,252), t3x96(:,:,21), nhel, den(58))
    call Hcont_QA(nsync, wf12(:,1), wf8(:,20), A(:,22), n3(:,253), t3x96(:,:,22), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,11), wf12(:,22), A(:,23), n3(:,254), t3x96(:,:,23), nhel, den(62))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,22), A(:,24), n3(:,255), t3x96(:,:,24), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,12), wf12(:,22), A(:,25), n3(:,256), t3x96(:,:,25), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,21), A(:,26), n3(:,257), t3x96(:,:,26), nhel, den(67))
    call Hcont_VV(nsync, wf6(:,6), wf16(:,1), A(:,27), n3(:,258), t3x96(:,:,27), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,11), wf12(:,24), A(:,28), n3(:,259), t3x96(:,:,28), nhel, den(72))
    call Hcont_VV(nsync, wf6(:,6), wf16(:,2), A(:,29), n3(:,260), t3x96(:,:,29), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,26), A(:,30), n3(:,261), t3x96(:,:,30), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,12), wf12(:,24), A(:,31), n3(:,262), t3x96(:,:,31), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,26), A(:,32), n3(:,263), t3x96(:,:,32), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,26), A(:,33), n3(:,264), t3x96(:,:,33), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,23), A(:,34), n3(:,265), t3x96(:,:,34), nhel, den(80))
    call Hcont_QA(nsync, wf12(:,8), wf8(:,20), A(:,35), n3(:,266), t3x96(:,:,35), nhel, den(81))
    call Hcont_QA(nsync, wf12(:,13), wf8(:,18), A(:,36), n3(:,267), t3x96(:,:,36), nhel, den(82))
    call Hcont_QA(nsync, wf12(:,6), wf8(:,22), A(:,37), n3(:,268), t3x96(:,:,37), nhel, den(83))
    call Hcont_QA(nsync, wf12(:,17), wf8(:,16), A(:,38), n3(:,269), t3x96(:,:,38), nhel, den(84))

    call Hcont_VV(nsync, wf8(:,23), wf12(:,27), A(:,39), n3(:,270), t3x96(:,:,39), nhel, den(86))
    call Hcont_VV(nsync, wf12(:,27), wf8(:,24), A(:,40), n3(:,271), t3x96(:,:,40), nhel, den(86))
    call Hcont_VV(nsync, wf8(:,23), wf12(:,28), A(:,41), n3(:,272), t3x96(:,:,41), nhel, den(87))
    call Hcont_VV(nsync, wf8(:,24), wf12(:,28), A(:,42), n3(:,273), t3x96(:,:,42), nhel, den(87))
    call Hcont_VV(nsync, wf4(:,2), wf24(:,3), A(:,43), n3(:,274), t3x96(:,:,43), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,29), A(:,44), n3(:,275), t3x96(:,:,44), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,25), A(:,45), n3(:,276), t3x96(:,:,45), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,30), wf8(:,26), A(:,46), n3(:,277), t3x96(:,:,46), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,27), wf12(:,31), A(:,47), n3(:,278), t3x96(:,:,47), nhel, den(91))
    call Hcont_VV(nsync, wf24(:,1), wf4(:,14), A(:,48), n3(:,279), t3x96(:,:,48), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,28), A(:,49), n3(:,280), t3x96(:,:,49), nhel, den(15))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,25), A(:,50), n3(:,281), t3x96(:,:,50), nhel, den(17))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,29), A(:,51), n3(:,282), t3x96(:,:,51), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,27), A(:,52), n3(:,283), t3x96(:,:,52), nhel, den(22))
    call Hcont_QA(nsync, wf12(:,4), wf8(:,31), A(:,53), n3(:,284), t3x96(:,:,53), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,26), wf12(:,32), A(:,54), n3(:,285), t3x96(:,:,54), nhel, den(92))
    call Hcont_QA(nsync, wf12(:,33), wf8(:,32), A(:,55), n3(:,286), t3x96(:,:,55), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,34), A(:,56), n3(:,287), t3x96(:,:,56), nhel, den(95))
    call Hcont_QA(nsync, wf12(:,33), wf8(:,33), A(:,57), n3(:,288), t3x96(:,:,57), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,33), A(:,58), n3(:,289), t3x96(:,:,58), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,2), wf24(:,4), A(:,59), n3(:,290), t3x96(:,:,59), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,34), A(:,60), n3(:,291), t3x96(:,:,60), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,10), wf12(:,35), A(:,61), n3(:,292), t3x96(:,:,61), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,35), wf12(:,36), A(:,62), n3(:,293), t3x96(:,:,62), nhel, den(99))
    call Hcont_QA(nsync, wf12(:,37), wf8(:,36), A(:,63), n3(:,294), t3x96(:,:,63), nhel, den(101))
    call Hcont_VV(nsync, wf24(:,2), wf4(:,14), A(:,64), n3(:,295), t3x96(:,:,64), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf8(:,34), A(:,65), n3(:,296), t3x96(:,:,65), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,16), wf8(:,37), A(:,66), n3(:,297), t3x96(:,:,66), nhel, den(41))
    call Hcont_QA(nsync, wf12(:,18), wf8(:,35), A(:,67), n3(:,298), t3x96(:,:,67), nhel, den(45))
    call Hcont_QA(nsync, wf12(:,16), wf8(:,38), A(:,68), n3(:,299), t3x96(:,:,68), nhel, den(46))
    call Hcont_QA(nsync, wf12(:,15), wf8(:,40), A(:,69), n3(:,300), t3x96(:,:,69), nhel, den(49))
    call Hcont_QA(nsync, wf12(:,38), wf8(:,41), A(:,70), n3(:,301), t3x96(:,:,70), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,36), wf12(:,39), A(:,71), n3(:,302), t3x96(:,:,71), nhel, den(104))
    call Hcont_QA(nsync, wf12(:,38), wf8(:,42), A(:,72), n3(:,303), t3x96(:,:,72), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,10), wf12(:,40), A(:,73), n3(:,304), t3x96(:,:,73), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,38), A(:,74), n3(:,305), t3x96(:,:,74), nhel, den(49))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,28), A(:,75), n3(:,306), t3x96(:,:,75), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,16), wf12(:,35), A(:,76), n3(:,307), t3x96(:,:,76), nhel, den(53))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,29), A(:,77), n3(:,308), t3x96(:,:,77), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,18), wf12(:,37), A(:,78), n3(:,309), t3x96(:,:,78), nhel, den(57))
    call Hcont_QA(nsync, wf12(:,19), wf8(:,31), A(:,79), n3(:,310), t3x96(:,:,79), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,20), wf12(:,29), A(:,80), n3(:,311), t3x96(:,:,80), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,37), A(:,81), n3(:,312), t3x96(:,:,81), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,22), wf12(:,30), A(:,82), n3(:,313), t3x96(:,:,82), nhel, den(65))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,38), A(:,83), n3(:,314), t3x96(:,:,83), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,21), wf8(:,40), A(:,84), n3(:,315), t3x96(:,:,84), nhel, den(67))
    call Hcont_VV(nsync, wf6(:,6), wf16(:,3), A(:,85), n3(:,316), t3x96(:,:,85), nhel, den(70))
    call Hcont_QA(nsync, wf12(:,24), wf8(:,37), A(:,86), n3(:,317), t3x96(:,:,86), nhel, den(72))
    call Hcont_VV(nsync, wf6(:,6), wf16(:,4), A(:,87), n3(:,318), t3x96(:,:,87), nhel, den(74))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,28), A(:,88), n3(:,319), t3x96(:,:,88), nhel, den(76))
    call Hcont_QA(nsync, wf12(:,24), wf8(:,38), A(:,89), n3(:,320), t3x96(:,:,89), nhel, den(77))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,29), A(:,90), n3(:,321), t3x96(:,:,90), nhel, den(78))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,30), A(:,91), n3(:,322), t3x96(:,:,91), nhel, den(79))
    call Hcont_QA(nsync, wf12(:,23), wf8(:,40), A(:,92), n3(:,323), t3x96(:,:,92), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,20), wf12(:,34), A(:,93), n3(:,324), t3x96(:,:,93), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,18), wf12(:,39), A(:,94), n3(:,325), t3x96(:,:,94), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,22), wf12(:,32), A(:,95), n3(:,326), t3x96(:,:,95), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,16), wf12(:,40), A(:,96), n3(:,327), t3x96(:,:,96), nhel, den(84))
    call Hcont_QA(nsync, wf12(:,36), wf8(:,43), A(:,97), n3(:,328), t3x96(:,:,97), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,32), wf12(:,41), A(:,98), n3(:,329), t3x96(:,:,98), nhel, den(109))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,44), A(:,99), n3(:,330), t3x96(:,:,99), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,33), wf12(:,41), A(:,100), n3(:,331), t3x96(:,:,100), nhel, den(111))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,41), A(:,101), n3(:,332), t3x96(:,:,101), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,41), wf12(:,42), A(:,102), n3(:,333), t3x96(:,:,102), nhel, den(112))
    call Hcont_QA(nsync, wf12(:,31), wf8(:,45), A(:,103), n3(:,334), t3x96(:,:,103), nhel, den(113))
    call Hcont_QA(nsync, wf8(:,42), wf12(:,42), A(:,104), n3(:,335), t3x96(:,:,104), nhel, den(114))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,46), A(:,105), n3(:,336), t3x96(:,:,105), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,42), A(:,106), n3(:,337), t3x96(:,:,106), nhel, den(67))
    call Hcont_QA(nsync, wf12(:,14), wf8(:,44), A(:,107), n3(:,338), t3x96(:,:,107), nhel, den(116))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,45), A(:,108), n3(:,339), t3x96(:,:,108), nhel, den(117))
    call Hcont_QA(nsync, wf12(:,18), wf8(:,43), A(:,109), n3(:,340), t3x96(:,:,109), nhel, den(118))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,46), A(:,110), n3(:,341), t3x96(:,:,110), nhel, den(119))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,47), A(:,111), n3(:,342), t3x96(:,:,111), nhel, den(120))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,48), A(:,112), n3(:,343), t3x96(:,:,112), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,1), wf12(:,44), A(:,113), n3(:,344), t3x96(:,:,113), nhel, den(22))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,49), A(:,114), n3(:,345), t3x96(:,:,114), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,46), A(:,115), n3(:,346), t3x96(:,:,115), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,2), wf24(:,5), A(:,116), n3(:,347), t3x96(:,:,116), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,47), A(:,117), n3(:,348), t3x96(:,:,117), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,49), A(:,118), n3(:,349), t3x96(:,:,118), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,47), A(:,119), n3(:,350), t3x96(:,:,119), nhel, den(121))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,48), A(:,120), n3(:,351), t3x96(:,:,120), nhel, den(54))
    call Hcont_QA(nsync, wf12(:,10), wf8(:,51), A(:,121), n3(:,352), t3x96(:,:,121), nhel, den(57))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,49), A(:,122), n3(:,353), t3x96(:,:,122), nhel, den(51))
    call Hcont_QA(nsync, wf12(:,12), wf8(:,53), A(:,123), n3(:,354), t3x96(:,:,123), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,41), wf12(:,50), A(:,124), n3(:,355), t3x96(:,:,124), nhel, den(122))
    call Hcont_VV(nsync, wf6(:,6), wf16(:,5), A(:,125), n3(:,356), t3x96(:,:,125), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,42), wf12(:,50), A(:,126), n3(:,357), t3x96(:,:,126), nhel, den(123))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,47), A(:,127), n3(:,358), t3x96(:,:,127), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,50), A(:,128), n3(:,359), t3x96(:,:,128), nhel, den(80))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,48), A(:,129), n3(:,360), t3x96(:,:,129), nhel, den(78))
    call Hcont_VV(nsync, wf6(:,6), wf16(:,6), A(:,130), n3(:,361), t3x96(:,:,130), nhel, den(74))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,49), A(:,131), n3(:,362), t3x96(:,:,131), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,20), wf12(:,43), A(:,132), n3(:,363), t3x96(:,:,132), nhel, den(81))
    call Hcont_QA(nsync, wf12(:,13), wf8(:,51), A(:,133), n3(:,364), t3x96(:,:,133), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,22), wf12(:,45), A(:,134), n3(:,365), t3x96(:,:,134), nhel, den(83))
    call Hcont_QA(nsync, wf12(:,17), wf8(:,53), A(:,135), n3(:,366), t3x96(:,:,135), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,20), wf12(:,47), A(:,136), n3(:,367), t3x96(:,:,136), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,11), wf12(:,52), A(:,137), n3(:,368), t3x96(:,:,137), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,22), wf12(:,48), A(:,138), n3(:,369), t3x96(:,:,138), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,12), wf12(:,52), A(:,139), n3(:,370), t3x96(:,:,139), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,51), A(:,140), n3(:,371), t3x96(:,:,140), nhel, den(67))
    call Hcont_VV(nsync, wf4(:,2), wf24(:,6), A(:,141), n3(:,372), t3x96(:,:,141), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,54), A(:,142), n3(:,373), t3x96(:,:,142), nhel, den(32))
    call Hcont_QA(nsync, wf12(:,12), wf8(:,56), A(:,143), n3(:,374), t3x96(:,:,143), nhel, den(35))
    call Hcont_QA(nsync, wf12(:,14), wf8(:,54), A(:,144), n3(:,375), t3x96(:,:,144), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,11), wf12(:,54), A(:,145), n3(:,376), t3x96(:,:,145), nhel, den(41))
    call Hcont_QA(nsync, wf12(:,18), wf8(:,55), A(:,146), n3(:,377), t3x96(:,:,146), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,12), wf12(:,54), A(:,147), n3(:,378), t3x96(:,:,147), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,53), A(:,148), n3(:,379), t3x96(:,:,148), nhel, den(49))
    call Hcont_QA(nsync, wf12(:,16), wf8(:,57), A(:,149), n3(:,380), t3x96(:,:,149), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,9), wf12(:,56), A(:,150), n3(:,381), t3x96(:,:,150), nhel, den(45))
    call Hcont_QA(nsync, wf12(:,16), wf8(:,58), A(:,151), n3(:,382), t3x96(:,:,151), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,58), A(:,152), n3(:,383), t3x96(:,:,152), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,16), wf8(:,59), A(:,153), n3(:,384), t3x96(:,:,153), nhel, den(41))
    call Hcont_VV(nsync, wf4(:,2), wf24(:,7), A(:,154), n3(:,385), t3x96(:,:,154), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,60), A(:,155), n3(:,386), t3x96(:,:,155), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,10), wf12(:,61), A(:,156), n3(:,387), t3x96(:,:,156), nhel, den(35))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,57), A(:,157), n3(:,388), t3x96(:,:,157), nhel, den(125))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,61), A(:,158), n3(:,389), t3x96(:,:,158), nhel, den(65))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,58), A(:,159), n3(:,390), t3x96(:,:,159), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,1), wf8(:,63), A(:,160), n3(:,391), t3x96(:,:,160), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,59), A(:,161), n3(:,392), t3x96(:,:,161), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,32), wf12(:,62), A(:,162), n3(:,393), t3x96(:,:,162), nhel, den(126))
    call Hcont_VV(nsync, wf6(:,6), wf16(:,7), A(:,163), n3(:,394), t3x96(:,:,163), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,33), wf12(:,62), A(:,164), n3(:,395), t3x96(:,:,164), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,62), A(:,165), n3(:,396), t3x96(:,:,165), nhel, den(128))
    call Hcont_QA(nsync, wf12(:,24), wf8(:,57), A(:,166), n3(:,397), t3x96(:,:,166), nhel, den(129))
    call Hcont_QA(nsync, wf12(:,24), wf8(:,58), A(:,167), n3(:,398), t3x96(:,:,167), nhel, den(77))
    call Hcont_VV(nsync, wf6(:,6), wf16(:,8), A(:,168), n3(:,399), t3x96(:,:,168), nhel, den(70))
    call Hcont_QA(nsync, wf12(:,24), wf8(:,59), A(:,169), n3(:,400), t3x96(:,:,169), nhel, den(72))
    call Hcont_QA(nsync, wf12(:,6), wf8(:,61), A(:,170), n3(:,401), t3x96(:,:,170), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,16), wf12(:,55), A(:,171), n3(:,402), t3x96(:,:,171), nhel, den(84))
    call Hcont_QA(nsync, wf12(:,8), wf8(:,63), A(:,172), n3(:,403), t3x96(:,:,172), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,18), wf12(:,57), A(:,173), n3(:,404), t3x96(:,:,173), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,64), A(:,174), n3(:,405), t3x96(:,:,174), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,16), wf12(:,61), A(:,175), n3(:,406), t3x96(:,:,175), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,64), A(:,176), n3(:,407), t3x96(:,:,176), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,18), wf12(:,59), A(:,177), n3(:,408), t3x96(:,:,177), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,63), A(:,178), n3(:,409), t3x96(:,:,178), nhel, den(58))
    call Hcont_VV(nsync, wf4(:,2), wf24(:,8), A(:,179), n3(:,410), t3x96(:,:,179), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,1), wf8(:,65), A(:,180), n3(:,411), t3x96(:,:,180), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,66), A(:,181), n3(:,412), t3x96(:,:,181), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,66), A(:,182), n3(:,413), t3x96(:,:,182), nhel, den(15))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,66), A(:,183), n3(:,414), t3x96(:,:,183), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,5), wf12(:,66), A(:,184), n3(:,415), t3x96(:,:,184), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,64), A(:,185), n3(:,416), t3x96(:,:,185), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,65), A(:,186), n3(:,417), t3x96(:,:,186), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,27), wf24(:,10), A(:,187), n3(:,418), t3x96(:,:,187), nhel, den(133))
    call Hcont_QA(nsync, wf6(:,11), wf16(:,10), A(:,188), n3(:,419), t3x96(:,:,188), nhel, den(137))
    call Hcont_VV(nsync, wf24(:,1), wf4(:,28), A(:,189), n3(:,420), t3x96(:,:,189), nhel, den(140))
    call Hcont_QA(nsync, wf12(:,31), wf8(:,67), A(:,190), n3(:,421), t3x96(:,:,190), nhel, den(142))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,68), A(:,191), n3(:,422), t3x96(:,:,191), nhel, den(143))
    call Hcont_QA(nsync, wf8(:,26), wf12(:,67), A(:,192), n3(:,423), t3x96(:,:,192), nhel, den(145))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,68), A(:,193), n3(:,424), t3x96(:,:,193), nhel, den(146))
    call Hcont_QA(nsync, wf12(:,31), wf8(:,69), A(:,194), n3(:,425), t3x96(:,:,194), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,26), wf12(:,69), A(:,195), n3(:,426), t3x96(:,:,195), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,32), wf12(:,70), A(:,196), n3(:,427), t3x96(:,:,196), nhel, den(149))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,68), A(:,197), n3(:,428), t3x96(:,:,197), nhel, den(150))
    call Hcont_QA(nsync, wf8(:,26), wf12(:,71), A(:,198), n3(:,429), t3x96(:,:,198), nhel, den(152))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,70), A(:,199), n3(:,430), t3x96(:,:,199), nhel, den(153))
    call Hcont_QA(nsync, wf8(:,32), wf12(:,72), A(:,200), n3(:,431), t3x96(:,:,200), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,26), wf12(:,73), A(:,201), n3(:,432), t3x96(:,:,201), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,33), wf12(:,70), A(:,202), n3(:,433), t3x96(:,:,202), nhel, den(156))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,67), A(:,203), n3(:,434), t3x96(:,:,203), nhel, den(157))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,74), A(:,204), n3(:,435), t3x96(:,:,204), nhel, den(159))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,71), A(:,205), n3(:,436), t3x96(:,:,205), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,33), wf12(:,72), A(:,206), n3(:,437), t3x96(:,:,206), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,75), A(:,207), n3(:,438), t3x96(:,:,207), nhel, den(162))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,70), A(:,208), n3(:,439), t3x96(:,:,208), nhel, den(163))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,72), A(:,209), n3(:,440), t3x96(:,:,209), nhel, den(164))
    call Hcont_QA(nsync, wf12(:,5), wf8(:,73), A(:,210), n3(:,441), t3x96(:,:,210), nhel, den(166))
    call Hcont_QA(nsync, wf6(:,13), wf16(:,12), A(:,211), n3(:,442), t3x96(:,:,211), nhel, den(170))
    call Hcont_QA(nsync, wf4(:,34), wf24(:,12), A(:,212), n3(:,443), t3x96(:,:,212), nhel, den(174))
    call Hcont_VV(nsync, wf24(:,2), wf4(:,28), A(:,213), n3(:,444), t3x96(:,:,213), nhel, den(176))
    call Hcont_QA(nsync, wf8(:,36), wf12(:,76), A(:,214), n3(:,445), t3x96(:,:,214), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,10), wf12(:,77), A(:,215), n3(:,446), t3x96(:,:,215), nhel, den(179))
    call Hcont_QA(nsync, wf12(:,36), wf8(:,74), A(:,216), n3(:,447), t3x96(:,:,216), nhel, den(181))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,75), A(:,217), n3(:,448), t3x96(:,:,217), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,36), wf12(:,78), A(:,218), n3(:,449), t3x96(:,:,218), nhel, den(183))
    call Hcont_QA(nsync, wf12(:,36), wf8(:,76), A(:,219), n3(:,450), t3x96(:,:,219), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,36), wf12(:,79), A(:,220), n3(:,451), t3x96(:,:,220), nhel, den(186))
    call Hcont_QA(nsync, wf12(:,16), wf8(:,77), A(:,221), n3(:,452), t3x96(:,:,221), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,41), wf12(:,80), A(:,222), n3(:,453), t3x96(:,:,222), nhel, den(188))
    call Hcont_QA(nsync, wf12(:,14), wf8(:,75), A(:,223), n3(:,454), t3x96(:,:,223), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,36), wf12(:,81), A(:,224), n3(:,455), t3x96(:,:,224), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,41), wf12(:,82), A(:,225), n3(:,456), t3x96(:,:,225), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,10), wf12(:,83), A(:,226), n3(:,457), t3x96(:,:,226), nhel, den(193))
    call Hcont_QA(nsync, wf12(:,16), wf8(:,78), A(:,227), n3(:,458), t3x96(:,:,227), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,42), wf12(:,80), A(:,228), n3(:,459), t3x96(:,:,228), nhel, den(195))
    call Hcont_QA(nsync, wf12(:,18), wf8(:,74), A(:,229), n3(:,460), t3x96(:,:,229), nhel, den(196))
    call Hcont_QA(nsync, wf8(:,10), wf12(:,84), A(:,230), n3(:,461), t3x96(:,:,230), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,42), wf12(:,82), A(:,231), n3(:,462), t3x96(:,:,231), nhel, den(198))
    call Hcont_QA(nsync, wf12(:,16), wf8(:,79), A(:,232), n3(:,463), t3x96(:,:,232), nhel, den(199))
    call Hcont_QA(nsync, wf12(:,16), wf8(:,80), A(:,233), n3(:,464), t3x96(:,:,233), nhel, den(200))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,80), A(:,234), n3(:,465), t3x96(:,:,234), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,32), wf12(:,85), A(:,235), n3(:,466), t3x96(:,:,235), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,16), wf12(:,77), A(:,236), n3(:,467), t3x96(:,:,236), nhel, den(203))
    call Hcont_QA(nsync, wf12(:,36), wf8(:,81), A(:,237), n3(:,468), t3x96(:,:,237), nhel, den(204))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,70), A(:,238), n3(:,469), t3x96(:,:,238), nhel, den(205))
    call Hcont_QA(nsync, wf8(:,32), wf12(:,86), A(:,239), n3(:,470), t3x96(:,:,239), nhel, den(206))
    call Hcont_QA(nsync, wf12(:,36), wf8(:,82), A(:,240), n3(:,471), t3x96(:,:,240), nhel, den(207))
    call Hcont_QA(nsync, wf8(:,33), wf12(:,85), A(:,241), n3(:,472), t3x96(:,:,241), nhel, den(208))
    call Hcont_QA(nsync, wf8(:,18), wf12(:,76), A(:,242), n3(:,473), t3x96(:,:,242), nhel, den(209))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,83), A(:,243), n3(:,474), t3x96(:,:,243), nhel, den(210))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,71), A(:,244), n3(:,475), t3x96(:,:,244), nhel, den(211))
    call Hcont_QA(nsync, wf8(:,33), wf12(:,86), A(:,245), n3(:,476), t3x96(:,:,245), nhel, den(212))
    call Hcont_QA(nsync, wf12(:,11), wf8(:,84), A(:,246), n3(:,477), t3x96(:,:,246), nhel, den(213))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,85), A(:,247), n3(:,478), t3x96(:,:,247), nhel, den(214))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,72), A(:,248), n3(:,479), t3x96(:,:,248), nhel, den(215))
    call Hcont_QA(nsync, wf12(:,20), wf8(:,73), A(:,249), n3(:,480), t3x96(:,:,249), nhel, den(216))
    call Hcont_QA(nsync, wf12(:,31), wf8(:,85), A(:,250), n3(:,481), t3x96(:,:,250), nhel, den(217))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,77), A(:,251), n3(:,482), t3x96(:,:,251), nhel, den(218))
    call Hcont_QA(nsync, wf8(:,41), wf12(:,87), A(:,252), n3(:,483), t3x96(:,:,252), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,20), wf12(:,68), A(:,253), n3(:,484), t3x96(:,:,253), nhel, den(220))
    call Hcont_QA(nsync, wf12(:,31), wf8(:,86), A(:,254), n3(:,485), t3x96(:,:,254), nhel, den(221))
    call Hcont_QA(nsync, wf8(:,41), wf12(:,88), A(:,255), n3(:,486), t3x96(:,:,255), nhel, den(222))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,87), A(:,256), n3(:,487), t3x96(:,:,256), nhel, den(223))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,78), A(:,257), n3(:,488), t3x96(:,:,257), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,42), wf12(:,87), A(:,258), n3(:,489), t3x96(:,:,258), nhel, den(225))
    call Hcont_QA(nsync, wf8(:,22), wf12(:,67), A(:,259), n3(:,490), t3x96(:,:,259), nhel, den(226))
    call Hcont_QA(nsync, wf12(:,3), wf8(:,88), A(:,260), n3(:,491), t3x96(:,:,260), nhel, den(227))
    call Hcont_QA(nsync, wf8(:,42), wf12(:,88), A(:,261), n3(:,492), t3x96(:,:,261), nhel, den(228))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,79), A(:,262), n3(:,493), t3x96(:,:,262), nhel, den(229))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,80), A(:,263), n3(:,494), t3x96(:,:,263), nhel, den(230))
    call Hcont_QA(nsync, wf8(:,14), wf12(:,87), A(:,264), n3(:,495), t3x96(:,:,264), nhel, den(231))
    call Hcont_QA(nsync, wf4(:,36), wf24(:,14), A(:,265), n3(:,496), t3x96(:,:,265), nhel, den(235))
    call Hcont_QA(nsync, wf4(:,32), wf24(:,16), A(:,266), n3(:,497), t3x96(:,:,266), nhel, den(239))
    call Hcont_QA(nsync, wf12(:,24), wf8(:,77), A(:,267), n3(:,498), t3x96(:,:,267), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,41), wf12(:,89), A(:,268), n3(:,499), t3x96(:,:,268), nhel, den(241))
    call Hcont_QA(nsync, wf4(:,38), wf24(:,18), A(:,269), n3(:,500), t3x96(:,:,269), nhel, den(245))
    call Hcont_QA(nsync, wf4(:,30), wf24(:,20), A(:,270), n3(:,501), t3x96(:,:,270), nhel, den(249))
    call Hcont_QA(nsync, wf8(:,32), wf12(:,90), A(:,271), n3(:,502), t3x96(:,:,271), nhel, den(250))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,70), A(:,272), n3(:,503), t3x96(:,:,272), nhel, den(251))
    call Hcont_QA(nsync, wf12(:,24), wf8(:,78), A(:,273), n3(:,504), t3x96(:,:,273), nhel, den(252))
    call Hcont_QA(nsync, wf8(:,42), wf12(:,89), A(:,274), n3(:,505), t3x96(:,:,274), nhel, den(253))
    call Hcont_QA(nsync, wf8(:,33), wf12(:,90), A(:,275), n3(:,506), t3x96(:,:,275), nhel, den(254))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,71), A(:,276), n3(:,507), t3x96(:,:,276), nhel, den(255))
    call Hcont_QA(nsync, wf8(:,7), wf12(:,90), A(:,277), n3(:,508), t3x96(:,:,277), nhel, den(256))
    call Hcont_QA(nsync, wf12(:,24), wf8(:,79), A(:,278), n3(:,509), t3x96(:,:,278), nhel, den(257))
    call Hcont_QA(nsync, wf12(:,24), wf8(:,80), A(:,279), n3(:,510), t3x96(:,:,279), nhel, den(258))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,73), A(:,280), n3(:,511), t3x96(:,:,280), nhel, den(259))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,85), A(:,281), n3(:,512), t3x96(:,:,281), nhel, den(260))
    call Hcont_QA(nsync, wf8(:,18), wf12(:,79), A(:,282), n3(:,513), t3x96(:,:,282), nhel, den(261))
    call Hcont_QA(nsync, wf12(:,14), wf8(:,83), A(:,283), n3(:,514), t3x96(:,:,283), nhel, den(262))
    call Hcont_QA(nsync, wf8(:,20), wf12(:,74), A(:,284), n3(:,515), t3x96(:,:,284), nhel, den(263))
    call Hcont_QA(nsync, wf12(:,9), wf8(:,86), A(:,285), n3(:,516), t3x96(:,:,285), nhel, den(264))
    call Hcont_QA(nsync, wf12(:,14), wf8(:,84), A(:,286), n3(:,517), t3x96(:,:,286), nhel, den(265))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,87), A(:,287), n3(:,518), t3x96(:,:,287), nhel, den(266))
    call Hcont_QA(nsync, wf8(:,16), wf12(:,83), A(:,288), n3(:,519), t3x96(:,:,288), nhel, den(267))
    call Hcont_QA(nsync, wf12(:,18), wf8(:,81), A(:,289), n3(:,520), t3x96(:,:,289), nhel, den(268))
    call Hcont_QA(nsync, wf8(:,22), wf12(:,71), A(:,290), n3(:,521), t3x96(:,:,290), nhel, den(269))
    call Hcont_QA(nsync, wf12(:,7), wf8(:,88), A(:,291), n3(:,522), t3x96(:,:,291), nhel, den(270))
    call Hcont_QA(nsync, wf12(:,18), wf8(:,82), A(:,292), n3(:,523), t3x96(:,:,292), nhel, den(271))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(3) ! M1helarray(3,96)
  integer :: empty(0), i

  M1(1)%j = (A(j,11)%j+A(j,14)%j+A(j,15)%j+A(j,17)%j+A(j,18)%j+A(j,38)%j)*f(1)+(-A(j,3)%j-A(j,4)%j-A(j,5)%j-A(j,24)%j-A(j,25)%j &
       -A(j,37)%j)*f(2)+(-A(j,29)%j-A(j,30)%j-A(j,31)%j)*f(3)+CI*(A(j,9)%j+A(j,16)%j+A(j,21)%j)*f(4)+CI*(-A(j,1)%j-A(j,8)%j &
       -A(j,26)%j)*f(5)+CI*(-A(j,33)%j-A(j,34)%j)*f(6)
  M1(2)%j = (A(j,10)%j+A(j,12)%j+A(j,13)%j+A(j,19)%j+A(j,20)%j+A(j,36)%j)*f(1)+(-A(j,2)%j-A(j,6)%j-A(j,7)%j-A(j,22)%j-A(j,23)%j &
       -A(j,35)%j)*f(2)+(-A(j,27)%j-A(j,28)%j-A(j,32)%j)*f(3)+CI*(-A(j,9)%j-A(j,16)%j-A(j,21)%j)*f(4)+CI*(A(j,1)%j+A(j,8)%j &
       +A(j,26)%j)*f(5)+CI*(A(j,33)%j+A(j,34)%j)*f(6)

  M2(1)%j = (-A(j,215)%j-A(j,216)%j-A(j,219)%j-A(j,226)%j-A(j,227)%j-A(j,228)%j-A(j,229)%j-A(j,230)%j-A(j,231)%j-A(j,235)%j &
       -A(j,236)%j-A(j,237)%j-A(j,238)%j-A(j,239)%j-A(j,240)%j-A(j,288)%j-A(j,289)%j-A(j,292)%j)*f(7)+(A(j,191)%j+A(j,192)%j &
       +A(j,195)%j+A(j,196)%j+A(j,197)%j+A(j,198)%j+A(j,199)%j+A(j,200)%j+A(j,201)%j+A(j,256)%j+A(j,257)%j+A(j,258)%j+A(j,259)%j &
       +A(j,260)%j+A(j,261)%j+A(j,287)%j+A(j,290)%j+A(j,291)%j)*f(8)+((A(j,39)%j+A(j,41)%j)*f(9))/2._/**/REALKIND+(A(j,269)%j &
       +A(j,270)%j+A(j,271)%j+A(j,272)%j+A(j,273)%j+A(j,274)%j)*f(9)+CI*(-A(j,211)%j-A(j,212)%j-A(j,213)%j-A(j,232)%j-A(j,233)%j &
       -A(j,234)%j-A(j,247)%j-A(j,248)%j-A(j,249)%j)*f(10)+CI*(A(j,187)%j+A(j,188)%j+A(j,189)%j+A(j,208)%j+A(j,209)%j+A(j,210)%j &
       +A(j,262)%j+A(j,263)%j+A(j,264)%j)*f(11)+CI*(A(j,277)%j+A(j,278)%j+A(j,279)%j+A(j,280)%j)*f(12)+(A(j,61)%j+A(j,62)%j &
       +A(j,67)%j+A(j,68)%j+A(j,75)%j+A(j,76)%j+A(j,122)%j+A(j,123)%j+A(j,135)%j+A(j,150)%j+A(j,151)%j+A(j,171)%j)*f(13)+( &
       -A(j,45)%j-A(j,46)%j-A(j,49)%j-A(j,50)%j-A(j,82)%j-A(j,83)%j-A(j,114)%j-A(j,115)%j-A(j,134)%j-A(j,158)%j-A(j,159)%j &
       -A(j,170)%j)*f(14)+(-A(j,88)%j-A(j,89)%j-A(j,130)%j-A(j,131)%j-A(j,163)%j-A(j,167)%j)*f(15)+CI*(A(j,59)%j+A(j,119)%j &
       +A(j,149)%j)*f(16)+CI*(-A(j,43)%j-A(j,111)%j-A(j,157)%j)*f(17)+CI*(-A(j,127)%j-A(j,166)%j)*f(18)+(A(j,72)%j+A(j,73)%j &
       +A(j,96)%j+A(j,97)%j+A(j,98)%j+A(j,109)%j+A(j,143)%j+A(j,146)%j+A(j,147)%j+A(j,156)%j+A(j,174)%j+A(j,175)%j)*f(19)+( &
       -A(j,54)%j-A(j,55)%j-A(j,95)%j-A(j,104)%j-A(j,105)%j-A(j,110)%j-A(j,118)%j-A(j,138)%j-A(j,139)%j-A(j,181)%j-A(j,182)%j &
       -A(j,183)%j)*f(20)+(-A(j,87)%j-A(j,126)%j-A(j,162)%j)*f(21)+CI*(A(j,74)%j+A(j,101)%j+A(j,141)%j+A(j,148)%j+A(j,154)%j &
       +A(j,178)%j)*f(22)+CI*(-A(j,58)%j-A(j,106)%j-A(j,116)%j-A(j,140)%j-A(j,179)%j-A(j,186)%j)*f(23)+CI*(-A(j,128)%j &
       -A(j,165)%j)*f(24)+CI*(A(j,64)%j+A(j,69)%j+A(j,79)%j)*f(25)+CI*(-A(j,48)%j-A(j,53)%j-A(j,84)%j)*f(26)+CI*(-A(j,91)%j &
       -A(j,92)%j)*f(27)
  M2(2)%j = (-A(j,214)%j-A(j,217)%j-A(j,218)%j-A(j,220)%j-A(j,221)%j-A(j,222)%j-A(j,223)%j-A(j,224)%j-A(j,225)%j-A(j,241)%j &
       -A(j,242)%j-A(j,243)%j-A(j,244)%j-A(j,245)%j-A(j,246)%j-A(j,282)%j-A(j,283)%j-A(j,286)%j)*f(7)+(A(j,190)%j+A(j,193)%j &
       +A(j,194)%j+A(j,202)%j+A(j,203)%j+A(j,204)%j+A(j,205)%j+A(j,206)%j+A(j,207)%j+A(j,250)%j+A(j,251)%j+A(j,252)%j+A(j,253)%j &
       +A(j,254)%j+A(j,255)%j+A(j,281)%j+A(j,284)%j+A(j,285)%j)*f(8)+((A(j,40)%j+A(j,42)%j)*f(9))/2._/**/REALKIND+(A(j,265)%j &
       +A(j,266)%j+A(j,267)%j+A(j,268)%j+A(j,275)%j+A(j,276)%j)*f(9)+CI*(A(j,211)%j+A(j,212)%j+A(j,213)%j+A(j,232)%j+A(j,233)%j &
       +A(j,234)%j+A(j,247)%j+A(j,248)%j+A(j,249)%j)*f(10)+CI*(-A(j,187)%j-A(j,188)%j-A(j,189)%j-A(j,208)%j-A(j,209)%j-A(j,210)%j &
       -A(j,262)%j-A(j,263)%j-A(j,264)%j)*f(11)+CI*(-A(j,277)%j-A(j,278)%j-A(j,279)%j-A(j,280)%j)*f(12)+(A(j,60)%j+A(j,63)%j &
       +A(j,65)%j+A(j,66)%j+A(j,77)%j+A(j,78)%j+A(j,120)%j+A(j,121)%j+A(j,133)%j+A(j,152)%j+A(j,153)%j+A(j,173)%j)*f(13)+( &
       -A(j,44)%j-A(j,47)%j-A(j,51)%j-A(j,52)%j-A(j,80)%j-A(j,81)%j-A(j,112)%j-A(j,113)%j-A(j,132)%j-A(j,160)%j-A(j,161)%j &
       -A(j,172)%j)*f(14)+(-A(j,86)%j-A(j,90)%j-A(j,125)%j-A(j,129)%j-A(j,168)%j-A(j,169)%j)*f(15)+CI*(-A(j,59)%j-A(j,119)%j &
       -A(j,149)%j)*f(16)+CI*(A(j,43)%j+A(j,111)%j+A(j,157)%j)*f(17)+CI*(A(j,127)%j+A(j,166)%j)*f(18)+(A(j,70)%j+A(j,71)%j &
       +A(j,94)%j+A(j,99)%j+A(j,100)%j+A(j,107)%j+A(j,142)%j+A(j,144)%j+A(j,145)%j+A(j,155)%j+A(j,176)%j+A(j,177)%j)*f(19)+( &
       -A(j,56)%j-A(j,57)%j-A(j,93)%j-A(j,102)%j-A(j,103)%j-A(j,108)%j-A(j,117)%j-A(j,136)%j-A(j,137)%j-A(j,180)%j-A(j,184)%j &
       -A(j,185)%j)*f(20)+(-A(j,85)%j-A(j,124)%j-A(j,164)%j)*f(21)+CI*(-A(j,74)%j-A(j,101)%j-A(j,141)%j-A(j,148)%j-A(j,154)%j &
       -A(j,178)%j)*f(22)+CI*(A(j,58)%j+A(j,106)%j+A(j,116)%j+A(j,140)%j+A(j,179)%j+A(j,186)%j)*f(23)+CI*(A(j,128)%j &
       +A(j,165)%j)*f(24)+CI*(-A(j,64)%j-A(j,69)%j-A(j,79)%j)*f(25)+CI*(A(j,48)%j+A(j,53)%j+A(j,84)%j)*f(26)+CI*(A(j,91)%j &
       +A(j,92)%j)*f(27)
  M2(3)%j = ((-A(j,39)%j-A(j,40)%j-A(j,41)%j-A(j,42)%j)*f(9))/6._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwajj_udxawgg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwajj_udxawgg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(2), Mct(3)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 2
      do j = 1, 3
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppwajj_udxawgg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwajj_udxawgg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppwajj_udxawgg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(3)
  integer :: i, j


  do j = 1, 3 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppwajj_udxawgg_1_/**/REALKIND
