
module ol_vamp_1_ppwaj_udxawg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwaj_udxawg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwaj_udxawg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwaj_udxawg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwaj_udxawg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwaj_udxawg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwaj_udxawg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(48)
  type(Hpolcont), intent(in) :: M(1,48)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(6)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(1),n2h24(1))
Gcoeff(:)%j = (c(6)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(2),n2h24(2))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(3),h0tab(:,3),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(3),n2h24(3))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(4),h0tab(:,4),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(4),n2h24(4))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(5),h0tab(:,5),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(5),n2h24(5))
Gcoeff(:)%j = (c(6)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(6),h0tab(:,6),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(6),n2h24(6))
Gcoeff(:)%j = (c(2)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(7),h0tab(:,7),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(7),m3h2x24(:,7),heltab2x48(:,:,7))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(8),h0tab(:,8),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(8),m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_AV_Q(ntryL,G1H24(1),ex3(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(1),n2h12(1))
  call Hloop_QA_V(ntryL,G1H24(2),ex2(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_QV_A(ntryL,G1H24(3),ex3(:),G1H12(2),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_Q_A(ntryL,G1H12(2),20,0,G2H12(2),n2h12(2))
  call Hloop_QA_V(ntryL,G1H24(4),ex2(:),G1H12(2),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_AQ_V(ntryL,G1H24(5),ex1(:),G1H12(3),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_AQ_V(ntryL,G1H24(6),ex1(:),G1H12(4),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_VQ_A(ntryL,G1H24(7),ex1(:),G1H12(5),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_Q_A(ntryL,G1H12(5),17,0,G2H12(3),n2h12(3))
  call Hloop_VQ_A(ntryL,G1H24(8),ex1(:),G1H12(5),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_Q_A(ntryL,G1H12(5),17,0,G2H12(4),n2h12(4))
  call Hloop_AQ_V(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_VQ_A(ntryL,G1H12(1),ex1(:),G1H6(1),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(2),n2h6(1))
  call Hloop_QA_V(ntryL,G2H12(2),ex2(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_VQ_A(ntryL,G1H12(2),ex1(:),G1H6(1),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(4),n2h6(2))
  call Hloop_VA_Q(ntryL,G1H12(3),ex2(:),G1H6(1),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(5),n2h6(3))
  call Hloop_VA_Q(ntryL,G1H12(4),ex2(:),G1H6(1),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(6),n2h6(4))
call Hotf_5pt_reduction(G2H12(3),RedSet_5(1),mass5set(:,1),  & 
G1H12(5),G1H12(1),G1H12(2),G1H12(3),G1H12(4),G1H12(6),12)
call HG1shiftOLR(G1H12(1),2,12)
call Hotf_5pt_reduction(G2H12(4),RedSet_5(2),mass5set(:,1),  & 
G1H12(7),G1H12(8),G1H12(9),G1H12(10),G1H12(11),G1H12(12),12)
call HG1shiftOLR(G1H12(8),2,12)
  call Hloop_QV_A(ntryL,G1H12(5),ex3(:),G1H6(1),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(1),21,0,G2H6(7),n2h6(5))
call HGT_raise_alpha_OLR(G1H12(1),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(1),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(1),ex2(:),G1H6(1),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_QV_A(ntryL,G1H12(3),ex3(:),G1H6(2),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H6(2),21,0,G2H6(8),n2h6(6))
  call Hloop_QV_A(ntryL,G1H12(4),ex3(:),G1H6(2),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_Q_A(ntryL,G1H6(2),21,0,G2H6(9),n2h6(7))
  call Hloop_QV_A(ntryL,G1H12(6),ex3(:),G1H6(2),m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H6(2),21,0,G2H6(10),n2h6(8))
  call Hloop_QW_A(ntryL,G1H12(7),ex4(:),G1H4(1),m3h3x4(:,1),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(1),n2h4(1))
call HGT_raise_alpha_OLR(G1H12(8),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(8),ex2(:),G1H6(2),m3h2x6(:,12),heltab2x12(:,:,13))
  call Hloop_QW_A(ntryL,G1H12(10),ex4(:),G1H4(1),m3h3x4(:,2),heltab2x12(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(2),n2h4(2))
  call Hloop_QW_A(ntryL,G1H12(11),ex4(:),G1H4(1),m3h3x4(:,3),heltab2x12(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(3),n2h4(3))
  call Hloop_QW_A(ntryL,G1H12(12),ex4(:),G1H4(1),m3h3x4(:,4),heltab2x12(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(4),n2h4(4))
call Hotf_5pt_reduction(G2H6(1),RedSet_5(3),mass5set(:,1),  & 
G1H6(3),G1H6(4),G1H6(5),G1H6(6),G1H6(7),G1H6(8),6)
call HG1shiftOLR(G1H6(4),8,6)
call Hotf_5pt_reduction(G2H6(2),RedSet_5(4),mass5set(:,1),  & 
G1H6(9),G1H6(10),G1H6(11),G1H6(12),G1H6(13),G1H6(14),6)
call HG1shiftOLR(G1H6(10),8,6)
call Hotf_5pt_reduction(G2H6(3),RedSet_5(5),mass5set(:,1),  & 
G1H6(15),G1H6(16),G1H6(17),G1H6(18),G1H6(19),G1H6(20),6)
call HG1shiftOLR(G1H6(16),8,6)
call Hotf_5pt_reduction(G2H6(4),RedSet_5(6),mass5set(:,1),  & 
G1H6(21),G1H6(22),G1H6(23),G1H6(24),G1H6(25),G1H6(26),6)
call HG1shiftOLR(G1H6(22),4,6)
call Hotf_5pt_reduction(G2H6(5),RedSet_5(7),mass5set(:,1),  & 
G1H6(27),G1H6(28),G1H6(29),G1H6(30),G1H6(31),G1H6(32),6)
call HG1shiftOLR(G1H6(28),8,6)
call Hotf_5pt_reduction(G2H6(6),RedSet_5(8),mass5set(:,1),  & 
G1H6(33),G1H6(34),G1H6(35),G1H6(36),G1H6(37),G1H6(38),6)
call HG1shiftOLR(G1H6(34),4,6)
call Hotf_5pt_reduction(G2H6(7),RedSet_5(1),mass5set(:,1),  & 
G1H6(39),G1H6(40),G1H6(41),G1H6(42),G1H6(43),G1H6(44),6)
call HG1shiftOLR(G1H6(40),2,6)
call Hotf_4pt_reduction(G2H6(9),RedSet_4(1),mass4set(:,1),  & 
G1H6(45),G1H6(46),G1H6(47),G1H6(48),G1H6(49),6)
call HG1shiftOLR(G1H6(46),2,6)
call Hotf_4pt_reduction(G2H6(10),RedSet_4(2),mass4set(:,1),  & 
G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
call HG1shiftOLR(G1H6(51),10,6)
call Hotf_5pt_reduction(G2H4(1),RedSet_5(2),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
call HG1shiftOLR(G1H4(2),2,4)
call Hotf_4pt_reduction(G2H4(3),RedSet_4(1),mass4set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),4)
call HG1shiftOLR(G1H4(8),2,4)
call Hotf_4pt_reduction(G2H4(4),RedSet_4(3),mass4set(:,1),  & 
G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
call HG1shiftOLR(G1H4(13),6,4)
  call ol_merge(ntryL,G1H6(45),[G1H6(43)])
  call ol_merge(ntryL,G1H6(50),[G1H6(44)])
  call ol_merge(ntryL,G1H4(7),[G1H4(5)])
  call ol_merge(ntryL,G1H4(12),[G1H4(6)])
  call Hloop_VA_Q(ntryL,G1H6(3),ex2(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(4),1,1,6)
call HGT_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(4),-8,0,G2H6(1),n2h6(9))
  call Hloop_QW_A(ntryL,G2H6(1),ex4(:),G2H2(1),m3h3x2(:,1),heltab2x6(:,:,2))
  call Hloop_VA_Q(ntryL,G1H6(7),ex2(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,3))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(2),n2h3(2))
  call Hloop_VA_Q(ntryL,G1H6(8),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,4))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(3),n2h3(3))
  call Hloop_QV_A(ntryL,G1H6(9),ex3(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(4),n2h3(4))
call HGT_OLR(G1H6(10),1,1,6)
call HGT_invQ_OLR(G1H6(10),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(10),-8,0,G2H6(2),n2h6(10))
  call Hloop_AW_Q(ntryL,G2H6(2),ex4(:),G2H2(2),m3h3x2(:,2),heltab2x6(:,:,6))
  call Hloop_QV_A(ntryL,G1H6(13),ex3(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(5),n2h3(5))
  call Hloop_QV_A(ntryL,G1H6(14),ex3(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,8))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(6),n2h3(6))
  call Hloop_VQ_A(ntryL,G1H6(15),ex1(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(7),n2h3(7))
call HGT_OLR(G1H6(16),1,1,6)
call HGT_invQ_OLR(G1H6(16),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(16),-8,0,G2H6(3),n2h6(11))
  call Hloop_AW_Q(ntryL,G2H6(3),ex4(:),G2H2(3),m3h3x2(:,3),heltab2x6(:,:,10))
  call Hloop_VQ_A(ntryL,G1H6(19),ex1(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,11))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(8),n2h3(8))
  call Hloop_VQ_A(ntryL,G1H6(20),ex1(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,12))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(9),n2h3(9))
  call Hloop_QW_A(ntryL,G1H6(21),ex4(:),G1H2(1),m3h3x2(:,4),heltab2x6(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(4),n2h2(1))
call HGT_OLR(G1H6(22),1,1,6)
call HGT_invQ_OLR(G1H6(22),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(22),-4,0,G2H6(4),n2h6(12))
  call Hloop_AV_Q(ntryL,G2H6(4),ex3(:),G2H3(10),m3h2x3(:,10),heltab2x6(:,:,14))
  call Hloop_QW_A(ntryL,G1H6(25),ex4(:),G1H2(1),m3h3x2(:,5),heltab2x6(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(5),n2h2(2))
  call Hloop_QW_A(ntryL,G1H6(26),ex4(:),G1H2(1),m3h3x2(:,6),heltab2x6(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(6),n2h2(3))
  call Hloop_AV_Q(ntryL,G1H6(27),ex3(:),G1H3(1),m3h2x3(:,11),heltab2x6(:,:,17))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(11),n2h3(10))
call HGT_OLR(G1H6(28),1,1,6)
call HGT_invQ_OLR(G1H6(28),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(28),-8,0,G2H6(5),n2h6(13))
  call Hloop_QW_A(ntryL,G2H6(5),ex4(:),G2H2(7),m3h3x2(:,7),heltab2x6(:,:,18))
  call Hloop_AV_Q(ntryL,G1H6(31),ex3(:),G1H3(1),m3h2x3(:,12),heltab2x6(:,:,19))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(12),n2h3(11))
  call Hloop_AV_Q(ntryL,G1H6(32),ex3(:),G1H3(1),m3h2x3(:,13),heltab2x6(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(13),n2h3(12))
  call Hloop_AW_Q(ntryL,G1H6(33),ex4(:),G1H2(1),m3h3x2(:,8),heltab2x6(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(8),n2h2(4))
call HGT_OLR(G1H6(34),1,1,6)
call HGT_invQ_OLR(G1H6(34),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(34),-4,0,G2H6(6),n2h6(14))
  call Hloop_QV_A(ntryL,G2H6(6),ex3(:),G2H3(14),m3h2x3(:,14),heltab2x6(:,:,22))
  call Hloop_AW_Q(ntryL,G1H6(37),ex4(:),G1H2(1),m3h3x2(:,9),heltab2x6(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(9),n2h2(5))
  call Hloop_AW_Q(ntryL,G1H6(38),ex4(:),G1H2(1),m3h3x2(:,10),heltab2x6(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(10),n2h2(6))
  call Hloop_QW_A(ntryL,G1H6(39),ex4(:),G1H2(1),m3h3x2(:,11),heltab2x6(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(11),n2h2(7))
call HGT_raise_alpha_OLR(G1H6(40),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(40),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(40),ex2(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,26))
  call Hloop_QW_A(ntryL,G1H6(45),ex4(:),G1H2(1),m3h3x2(:,12),heltab2x6(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(12),n2h2(8))
  call Hloop_QW_A(ntryL,G1H6(50),ex4(:),G1H2(1),m3h3x2(:,13),heltab2x6(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(13),n2h2(9))
call HGT_raise_alpha_OLR(G1H6(46),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(46),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(46),ex2(:),G1H3(2),m3h2x3(:,16),heltab2x6(:,:,29))
  call Hloop_QW_A(ntryL,G1H6(49),ex4(:),G1H2(1),m3h3x2(:,14),heltab2x6(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(14),n2h2(10))
call HGT_raise_alpha_OLR(G1H6(51),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(51),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(51),ex2(:),G1H3(3),m3h2x3(:,17),heltab2x6(:,:,31))
  call Hloop_QW_A(ntryL,G1H6(54),ex4(:),G1H2(1),m3h3x2(:,15),heltab2x6(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(15),n2h2(11))
  call Hloop_QV_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(16),n2h2(12))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex2(:),G1H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QV_A(ntryL,G1H4(7),ex3(:),G1H2(2),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(2),29,0,G2H2(17),n2h2(13))
  call Hloop_QV_A(ntryL,G1H4(12),ex3(:),G1H2(2),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(2),29,0,G2H2(18),n2h2(14))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex2(:),G1H2(2),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QV_A(ntryL,G1H4(11),ex3(:),G1H2(3),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(3),29,0,G2H2(19),n2h2(15))
call HGT_raise_alpha_OLR(G1H4(13),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(3),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QV_A(ntryL,G1H4(16),ex3(:),G1H2(4),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(20),n2h2(16))
call Hotf_5pt_reduction(G2H3(1),RedSet_5(3),mass5set(:,1),  & 
G1H3(4),G1H3(5),G1H3(6),G1H3(7),G1H3(8),G1H3(9),3)
call HG1shiftOLR(G1H3(5),8,3)
call Hotf_4pt_reduction(G2H3(3),RedSet_4(4),mass4set(:,1),  & 
G1H3(10),G1H3(11),G1H3(12),G1H3(13),G1H3(14),3)
call HG1shiftOLR(G1H3(11),10,3)
call Hotf_5pt_reduction(G2H3(4),RedSet_5(4),mass5set(:,1),  & 
G1H3(15),G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),3)
call HG1shiftOLR(G1H3(16),8,3)
call Hotf_4pt_reduction(G2H3(6),RedSet_4(5),mass4set(:,1),  & 
G1H3(21),G1H3(22),G1H3(23),G1H3(24),G1H3(25),3)
call HG1shiftOLR(G1H3(22),12,3)
call Hotf_5pt_reduction(G2H3(7),RedSet_5(5),mass5set(:,1),  & 
G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),G1H3(31),3)
call HG1shiftOLR(G1H3(27),8,3)
call Hotf_4pt_reduction(G2H3(9),RedSet_4(6),mass4set(:,1),  & 
G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
call HG1shiftOLR(G1H3(33),9,3)
call Hotf_5pt_reduction(G2H2(4),RedSet_5(6),mass5set(:,1),  & 
G1H2(4),G1H2(5),G1H2(6),G1H2(7),G1H2(8),G1H2(9),2)
call HG1shiftOLR(G1H2(5),4,2)
call Hotf_4pt_reduction(G2H2(6),RedSet_4(5),mass4set(:,1),  & 
G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
call HG1shiftOLR(G1H2(11),12,2)
call Hotf_5pt_reduction(G2H3(11),RedSet_5(7),mass5set(:,1),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),3)
call HG1shiftOLR(G1H3(38),8,3)
call Hotf_4pt_reduction(G2H3(13),RedSet_4(7),mass4set(:,1),  & 
G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),3)
call HG1shiftOLR(G1H3(44),12,3)
call Hotf_5pt_reduction(G2H2(8),RedSet_5(8),mass5set(:,1),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
call HG1shiftOLR(G1H2(16),4,2)
call Hotf_4pt_reduction(G2H2(10),RedSet_4(7),mass4set(:,1),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),2)
call HG1shiftOLR(G1H2(22),12,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(16),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntryL,G1H3(10),[G1H3(9)])
  call ol_merge(ntryL,G1H3(21),[G1H3(20)])
  call ol_merge(ntryL,G1H3(32),[G1H3(31)])
  call ol_merge(ntryL,G1H2(10),[G1H2(9)])
  call ol_merge(ntryL,G1H3(43),[G1H3(42)])
  call ol_merge(ntryL,G1H2(21),[G1H2(20)])
  call Hloop_AW_Q(ntryL,G1H3(4),ex4(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(1))
  call Hloop_AW_Q(ntryL,G1H3(5),ex4(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(6),n2h1(2))
  call Hloop_AW_Q(ntryL,G1H3(10),ex4(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(3))
  call Hloop_AW_Q(ntryL,G1H3(11),ex4(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(8),n2h1(4))
  call Hloop_QW_A(ntryL,G1H3(15),ex4(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(5))
  call Hloop_QW_A(ntryL,G1H3(16),ex4(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(10),n2h1(6))
  call Hloop_QW_A(ntryL,G1H3(21),ex4(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(7))
  call Hloop_QW_A(ntryL,G1H3(22),ex4(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(12),n2h1(8))
  call Hloop_QW_A(ntryL,G1H3(26),ex4(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(9))
  call Hloop_QW_A(ntryL,G1H3(27),ex4(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(14),n2h1(10))
  call Hloop_QW_A(ntryL,G1H3(32),ex4(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(11))
  call Hloop_QW_A(ntryL,G1H3(33),ex4(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(16),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(18),n2h1(14))
  call Hloop_QV_A(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(15))
  call Hloop_QV_A(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(20),n2h1(16))
  call Hloop_AW_Q(ntryL,G1H3(37),ex4(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(17))
  call Hloop_AW_Q(ntryL,G1H3(38),ex4(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(22),n2h1(18))
  call Hloop_AW_Q(ntryL,G1H3(43),ex4(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(19))
  call Hloop_AW_Q(ntryL,G1H3(44),ex4(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(24),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(26),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(28),n2h1(24))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),2)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),2)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),8)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),8)
call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),8)
call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(6),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),4)
call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),8)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),4)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(9),h0tab(:,9),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(1),m3h2x24(:,9),heltab2x48(:,:,9))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(10),h0tab(:,10),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,10),heltab2x48(:,:,10))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(2),n2h24(7))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(11),h0tab(:,11),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,11),heltab2x48(:,:,11))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(3),n2h24(8))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(12),h0tab(:,12),[16,1,8,6],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(4),m3h2x24(:,12),heltab2x48(:,:,12))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(13),h0tab(:,13),[16,6,1,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,13),heltab2x48(:,:,13))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(5),n2h24(9))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(14),h0tab(:,14),[16,1,6,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,14),heltab2x48(:,:,14))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(6),n2h24(10))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(15),h0tab(:,15),[16,2,4,9],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(7),m3h2x24(:,15),heltab2x48(:,:,15))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(16),h0tab(:,16),[16,4,2,9],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,16),heltab2x48(:,:,16))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(8),n2h24(11))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(17),h0tab(:,17),[16,2,9,4],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,17),heltab2x48(:,:,17))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(9),n2h24(12))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(18),h0tab(:,18),[16,1,4,10],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(10),m3h2x24(:,18),heltab2x48(:,:,18))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(19),h0tab(:,19),[16,4,1,10],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,19),heltab2x48(:,:,19))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(11),n2h24(13))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(20),h0tab(:,20),[16,1,10,4],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,20),heltab2x48(:,:,20))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(12),n2h24(14))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(21),h0tab(:,21),[16,1,2,12],[0,0,0,0],4,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,21),heltab2x48(:,:,21))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(13),n2h24(15))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(22),h0tab(:,22),[16,2,1,12],[0,0,0,0],4,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,22),heltab2x48(:,:,22))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(14),n2h24(16))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(23),h0tab(:,23),[16,1,12,2],[0,0,0,0],4,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(15),m3h2x24(:,23),heltab2x48(:,:,23))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(24),h0tab(:,24),[17,2,4,8],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(1),m3h4x12(:,1),heltab2x48(:,:,24))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(25),h0tab(:,25),[17,2,8,4],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(2),m3h4x12(:,2),heltab2x48(:,:,25))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(26),h0tab(:,26),[18,1,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(3),m3h4x12(:,3),heltab2x48(:,:,26))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(27),h0tab(:,27),[18,1,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(4),m3h4x12(:,4),heltab2x48(:,:,27))
  call Hloop_QV_A(ntryL,G1H12(2),ex3(:),G1H6(43),m3h2x6(:,13),heltab2x12(:,:,17))
  call Hloop_Q_A(ntryL,G1H6(43),21,0,G2H6(7),n2h6(18))
  call Hloop_QW_A(ntryL,G1H12(9),ex4(:),G1H4(5),m3h3x4(:,5),heltab2x12(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(5),25,0,G2H4(1),n2h4(8))
  call Hloop_VA_Q(ntryL,G1H24(1),ex2(:),G1H12(5),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_A_Q(ntryL,G1H12(5),18,0,G2H12(1),n2h12(7))
  call Hloop_AQ_V(ntryL,G1H24(2),wf4(:,2),G1H6(44),m3h4x6(:,1),heltab2x24(:,:,10))
  call Hloop_QA_V(ntryL,G1H24(3),ex2(:),G1H12(1),m3h2x12(:,10),heltab2x24(:,:,11))
  call Hloop_VQ_A(ntryL,G1H24(4),ex1(:),G1H12(3),m3h2x12(:,11),heltab2x24(:,:,12))
  call Hloop_Q_A(ntryL,G1H12(3),17,0,G2H12(2),n2h12(8))
  call Hloop_QA_V(ntryL,G1H24(5),wf4(:,6),G1H6(3),m3h4x6(:,2),heltab2x24(:,:,13))
  call Hloop_AQ_V(ntryL,G1H24(6),ex1(:),G1H12(4),m3h2x12(:,12),heltab2x24(:,:,14))
  call Hloop_VA_Q(ntryL,G1H24(7),ex2(:),G1H12(6),m3h2x12(:,13),heltab2x24(:,:,15))
  call Hloop_A_Q(ntryL,G1H12(6),18,0,G2H12(3),n2h12(9))
  call Hloop_QV_A(ntryL,G1H24(8),ex3(:),G1H12(7),m3h2x12(:,14),heltab2x24(:,:,16))
  call Hloop_Q_A(ntryL,G1H12(7),20,0,G2H12(4),n2h12(10))
  call Hloop_QA_V(ntryL,G1H24(9),ex2(:),G1H12(8),m3h2x12(:,15),heltab2x24(:,:,17))
  call Hloop_VQ_A(ntryL,G1H24(10),ex1(:),G1H12(10),m3h2x12(:,16),heltab2x24(:,:,18))
  call Hloop_Q_A(ntryL,G1H12(10),17,0,G2H12(5),n2h12(11))
  call Hloop_AV_Q(ntryL,G1H24(11),ex3(:),G1H12(11),m3h2x12(:,17),heltab2x24(:,:,19))
  call Hloop_A_Q(ntryL,G1H12(11),20,0,G2H12(6),n2h12(12))
  call Hloop_AQ_V(ntryL,G1H24(12),ex1(:),G1H12(12),m3h2x12(:,18),heltab2x24(:,:,20))
  call Hloop_AQ_V(ntryL,G1H24(13),ex1(:),G1H12(2),m3h2x12(:,19),heltab2x24(:,:,21))
  call Hloop_QA_V(ntryL,G1H24(14),ex2(:),G1H12(9),m3h2x12(:,20),heltab2x24(:,:,22))
  call Hloop_VQ_A(ntryL,G1H24(15),ex1(:),G1H12(5),m3h2x12(:,21),heltab2x24(:,:,23))
  call Hloop_Q_A(ntryL,G1H12(5),17,0,G2H12(7),n2h12(13))
  call Hloop_VA_Q(ntryL,G0H12(1),ex2(:),G0H6(1),m3h2x6(:,14),heltab2x12(:,:,19))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(4),n2h6(19))
  call Hloop_VA_Q(ntryL,G0H12(2),ex2(:),G0H6(1),m3h2x6(:,15),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(7),n2h6(20))
  call Hloop_VQ_A(ntryL,G0H12(3),ex1(:),G0H6(1),m3h2x6(:,16),heltab2x12(:,:,21))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(8),n2h6(21))
  call Hloop_VQ_A(ntryL,G0H12(4),ex1(:),G0H6(1),m3h2x6(:,17),heltab2x12(:,:,22))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(9),n2h6(22))
  call ol_merge(ntryL,G1H6(8),[G1H6(11)])
call HGT_w2_OLR(G1H6(1),1,1,6)
call HGT_w2_invQ_OLR(G1H6(1),2,5,6)
  call ol_merge(ntryL,G1H6(1),[G1H6(8)])
  call ol_merge(ntryL,G2H6(8),[G1H6(42)])
  call ol_merge(ntryL,G1H6(9),[G1H6(23)])
call HGT_w2_OLR(G1H6(2),1,1,6)
call HGT_w2_invQ_OLR(G1H6(2),2,5,6)
  call ol_merge(ntryL,G1H6(2),[G1H6(9)])
  call ol_merge(ntryL,G2H4(2),[G1H4(4)])
  call ol_merge(ntryL,G1H6(44),[G1H6(6)])
  call ol_merge(ntryL,G1H6(3),[G1H6(18)])
  call ol_merge(ntryL,G1H6(4),[G1H6(29)])
  call ol_merge(ntryL,G1H6(7),[G1H6(35)])
  call ol_merge(ntryL,G2H6(7),[G1H6(41)])
  call ol_merge(ntryL,G2H4(1),[G1H4(3)])
  call Hloop_QV_A(ntryL,G1H6(1),ex3(:),G1H3(9),m3h2x3(:,18),heltab2x6(:,:,33))
  call Hloop_Q_A(ntryL,G1H3(9),23,0,G2H3(1),n2h3(13))
call Hotf_4pt_reduction(G2H6(8),RedSet_4(9),mass4set(:,1),  & 
G1H6(10),G1H6(13),G1H6(14),G1H6(15),G1H6(16),6)
call HG1shiftOLR(G1H6(13),2,6)
  call Hloop_QW_A(ntryL,G1H6(2),ex4(:),G1H2(9),m3h3x2(:,16),heltab2x6(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(9),27,0,G2H2(4),n2h2(17))
call Hotf_4pt_reduction(G2H4(2),RedSet_4(12),mass4set(:,1),  & 
G1H4(6),G1H4(1),G1H4(2),G1H4(7),G1H4(12),4)
call HG1shiftOLR(G1H4(1),2,4)
  call Hloop_VA_Q(ntryL,G1H6(5),ex2(:),G1H3(20),m3h2x3(:,19),heltab2x6(:,:,35))
  call Hloop_A_Q(ntryL,G1H3(20),23,0,G2H3(3),n2h3(14))
  call Hloop_VA_Q(ntryL,G1H6(44),ex2(:),G1H3(31),m3h2x3(:,20),heltab2x6(:,:,36))
  call Hloop_A_Q(ntryL,G1H3(31),23,0,G2H3(4),n2h3(15))
  call Hloop_QV_A(ntryL,G1H6(12),ex3(:),G1H3(42),m3h2x3(:,21),heltab2x6(:,:,37))
  call Hloop_Q_A(ntryL,G1H3(42),23,0,G2H3(6),n2h3(16))
  call Hloop_VQ_A(ntryL,G1H6(17),ex1(:),G1H3(4),m3h2x3(:,22),heltab2x6(:,:,38))
  call Hloop_Q_A(ntryL,G1H3(4),23,0,G2H3(7),n2h3(17))
  call Hloop_VQ_A(ntryL,G1H6(3),ex1(:),G1H3(5),m3h2x3(:,23),heltab2x6(:,:,39))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(9),n2h3(18))
  call Hloop_QW_A(ntryL,G1H6(24),ex4(:),G1H2(20),m3h3x2(:,17),heltab2x6(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(20),27,0,G2H2(6),n2h2(18))
  call Hloop_AV_Q(ntryL,G1H6(4),ex3(:),G1H3(10),m3h2x3(:,24),heltab2x6(:,:,41))
  call Hloop_A_Q(ntryL,G1H3(10),23,0,G2H3(11),n2h3(19))
  call Hloop_AV_Q(ntryL,G1H6(30),ex3(:),G1H3(11),m3h2x3(:,25),heltab2x6(:,:,42))
  call Hloop_A_Q(ntryL,G1H3(11),23,0,G2H3(13),n2h3(20))
  call Hloop_AW_Q(ntryL,G1H6(7),ex4(:),G1H2(4),m3h3x2(:,18),heltab2x6(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(4),27,0,G2H2(8),n2h2(19))
  call Hloop_AW_Q(ntryL,G1H6(36),ex4(:),G1H2(5),m3h3x2(:,19),heltab2x6(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(10),n2h2(20))
call Hotf_4pt_reduction(G2H6(7),RedSet_4(8),mass4set(:,1),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(25),6)
call HG1shiftOLR(G1H6(20),2,6)
  call Hloop_QW_A(ntryL,G1H6(47),ex4(:),G1H2(10),m3h3x2(:,20),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(10),29,0,G2H2(11),n2h2(21))
  call Hloop_QW_A(ntryL,G1H6(48),ex4(:),G1H2(11),m3h3x2(:,21),heltab2x6(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(13),n2h2(22))
  call Hloop_QW_A(ntryL,G1H6(52),ex4(:),G1H2(15),m3h3x2(:,22),heltab2x6(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(15),29,0,G2H2(16),n2h2(23))
  call Hloop_QW_A(ntryL,G1H6(53),ex4(:),G1H2(16),m3h3x2(:,23),heltab2x6(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(16),29,0,G2H2(18),n2h2(24))
call Hotf_4pt_reduction(G2H4(1),RedSet_4(11),mass4set(:,1),  & 
G1H4(8),G1H4(11),G1H4(13),G1H4(16),G1H4(5),4)
call HG1shiftOLR(G1H4(11),2,4)
  call Hloop_QV_A(ntryL,G1H4(9),ex3(:),G1H2(21),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(21),29,0,G2H2(21),n2h2(25))
  call Hloop_QV_A(ntryL,G1H4(10),ex3(:),G1H2(22),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(22),29,0,G2H2(22),n2h2(26))
  call Hloop_QV_A(ntryL,G1H4(14),ex3(:),G1H2(9),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(9),29,0,G2H2(23),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(15),ex3(:),G1H2(20),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(20),29,0,G2H2(24),n2h2(28))
call Hotf_4pt_reduction(G2H12(1),RedSet_4(35),mass4set(:,1),  & 
G1H12(3),G1H12(6),G1H12(7),G1H12(10),G1H12(11),12)
call HG1shiftOLR(G1H12(6),5,12)
  call Hloop_VQ_A(ntryL,G1H12(1),wf4(:,2),G1H3(15),m3h4x3(:,1),heltab2x12(:,:,23))
  call Hloop_Q_A(ntryL,G1H3(15),23,0,G2H3(15),n2h3(21))
call Hotf_4pt_reduction(G2H12(2),RedSet_4(3),mass4set(:,1),  & 
G1H12(5),G1H12(1),G1H12(13),G1H12(14),G1H12(15),12)
call HG1shiftOLR(G1H12(1),6,12)
  call Hloop_VA_Q(ntryL,G1H12(4),wf4(:,6),G1H3(16),m3h4x3(:,2),heltab2x12(:,:,24))
  call Hloop_A_Q(ntryL,G1H3(16),23,0,G2H3(16),n2h3(22))
call Hotf_4pt_reduction(G2H12(3),RedSet_4(36),mass4set(:,1),  & 
G1H12(4),G1H12(16),G1H12(17),G1H12(18),G1H12(19),12)
call HG1shiftOLR(G1H12(16),9,12)
  call Hloop_QA_V(ntryL,G2H12(4),ex2(:),G2H6(9),m3h2x6(:,18),heltab2x12(:,:,25))
  call Hloop_VQ_A(ntryL,G1H12(8),wf6(:,4),G1H2(4),m3h6x2(:,1),heltab2x12(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(4),27,0,G2H2(25),n2h2(29))
call Hotf_4pt_reduction(G2H12(5),RedSet_4(2),mass4set(:,1),  & 
G1H12(8),G1H12(20),G1H12(21),G1H12(22),G1H12(23),12)
call HG1shiftOLR(G1H12(20),10,12)
  call Hloop_AQ_V(ntryL,G2H12(6),ex1(:),G2H6(10),m3h2x6(:,19),heltab2x12(:,:,27))
  call Hloop_VA_Q(ntryL,G1H12(12),wf6(:,2),G1H2(5),m3h6x2(:,2),heltab2x12(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(26),n2h2(30))
  call Hloop_VA_Q(ntryL,G1H12(2),ex2(:),G1H6(26),m3h2x6(:,20),heltab2x12(:,:,29))
  call Hloop_A_Q(ntryL,G1H6(26),19,0,G2H6(1),n2h6(23))
  call Hloop_VQ_A(ntryL,G1H12(9),ex1(:),G1H6(27),m3h2x6(:,21),heltab2x12(:,:,30))
  call Hloop_Q_A(ntryL,G1H6(27),19,0,G2H6(2),n2h6(24))
call Hotf_4pt_reduction(G2H12(7),RedSet_4(1),mass4set(:,1),  & 
G1H12(12),G1H12(2),G1H12(9),G1H12(24),G1H12(25),12)
call HG1shiftOLR(G1H12(2),2,12)
  call Hloop_QW_A(ntryL,G1H6(10),ex4(:),G1H2(10),m3h3x2(:,24),heltab2x6(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(10),29,0,G2H2(27),n2h2(31))
call HGT_raise_alpha_OLR(G1H6(13),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(13),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(13),ex2(:),G1H3(21),m3h2x3(:,26),heltab2x6(:,:,50))
  call Hloop_QW_A(ntryL,G1H6(15),ex4(:),G1H2(11),m3h3x2(:,25),heltab2x6(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(28),n2h2(32))
  call Hloop_QW_A(ntryL,G1H6(16),ex4(:),G1H2(15),m3h3x2(:,26),heltab2x6(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(15),29,0,G2H2(29),n2h2(33))
  call Hloop_QV_A(ntryL,G1H4(6),ex3(:),G1H2(16),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(16),29,0,G2H2(30),n2h2(34))
call HGT_raise_alpha_OLR(G1H4(1),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(1),ex2(:),G1H2(21),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QV_A(ntryL,G1H4(7),ex3(:),G1H2(22),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(22),29,0,G2H2(31),n2h2(35))
  call Hloop_QV_A(ntryL,G1H4(12),ex3(:),G1H2(9),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(9),29,0,G2H2(32),n2h2(36))
  call Hloop_QW_A(ntryL,G1H6(19),ex4(:),G1H2(20),m3h3x2(:,27),heltab2x6(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(20),29,0,G2H2(33),n2h2(37))
call HGT_raise_alpha_OLR(G1H6(20),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(20),ex2(:),G1H3(22),m3h2x3(:,27),heltab2x6(:,:,54))
  call Hloop_QW_A(ntryL,G1H6(22),ex4(:),G1H2(4),m3h3x2(:,28),heltab2x6(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(34),n2h2(38))
  call Hloop_QW_A(ntryL,G1H6(25),ex4(:),G1H2(5),m3h3x2(:,29),heltab2x6(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(35),n2h2(39))
  call Hloop_QV_A(ntryL,G1H4(8),ex3(:),G1H2(10),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(10),29,0,G2H2(36),n2h2(40))
call HGT_raise_alpha_OLR(G1H4(11),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(11),ex2(:),G1H2(11),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QV_A(ntryL,G1H4(16),ex3(:),G1H2(15),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(15),29,0,G2H2(37),n2h2(41))
  call Hloop_QV_A(ntryL,G1H4(5),ex3(:),G1H2(16),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(16),29,0,G2H2(38),n2h2(42))
  call Hloop_AW_Q(ntryL,G1H12(3),ex4(:),G1H4(4),m3h3x4(:,6),heltab2x12(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(4),26,0,G2H4(3),n2h4(11))
call HGT_raise_alpha_OLR(G1H12(6),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(6),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(6),wf4(:,2),G1H3(26),m3h4x3(:,3),heltab2x12(:,:,32))
  call Hloop_AW_Q(ntryL,G1H12(10),ex4(:),G1H4(3),m3h3x4(:,7),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(3),26,0,G2H4(4),n2h4(12))
  call Hloop_AW_Q(ntryL,G1H12(11),ex4(:),G1H4(9),m3h3x4(:,8),heltab2x12(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(9),26,0,G2H4(2),n2h4(13))
  call Hloop_QW_A(ntryL,G1H12(5),ex4(:),G1H4(10),m3h3x4(:,9),heltab2x12(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(10),25,0,G2H4(1),n2h4(14))
call HGT_raise_alpha_OLR(G1H12(1),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(1),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(1),wf4(:,6),G1H3(27),m3h4x3(:,4),heltab2x12(:,:,36))
  call Hloop_QW_A(ntryL,G1H12(14),ex4(:),G1H4(14),m3h3x4(:,10),heltab2x12(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(14),25,0,G2H4(5),n2h4(15))
  call Hloop_QW_A(ntryL,G1H12(15),ex4(:),G1H4(15),m3h3x4(:,11),heltab2x12(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(15),25,0,G2H4(6),n2h4(16))
  call Hloop_AV_Q(ntryL,G1H12(4),ex3(:),G1H6(28),m3h2x6(:,22),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H6(28),22,0,G2H6(3),n2h6(27))
call HGT_raise_alpha_OLR(G1H12(16),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(16),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(16),wf6(:,4),G1H2(22),m3h6x2(:,3),heltab2x12(:,:,40))
  call Hloop_AV_Q(ntryL,G1H12(18),ex3(:),G1H6(31),m3h2x6(:,23),heltab2x12(:,:,41))
  call Hloop_A_Q(ntryL,G1H6(31),22,0,G2H6(4),n2h6(28))
  call Hloop_AV_Q(ntryL,G1H12(19),ex3(:),G1H6(32),m3h2x6(:,24),heltab2x12(:,:,42))
  call Hloop_A_Q(ntryL,G1H6(32),22,0,G2H6(5),n2h6(29))
  call Hloop_QV_A(ntryL,G1H12(8),ex3(:),G1H6(33),m3h2x6(:,25),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H6(33),21,0,G2H6(6),n2h6(30))
call HGT_raise_alpha_OLR(G1H12(20),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(20),wf6(:,2),G1H2(9),m3h6x2(:,4),heltab2x12(:,:,44))
  call Hloop_QV_A(ntryL,G1H12(22),ex3(:),G1H6(34),m3h2x6(:,26),heltab2x12(:,:,45))
  call Hloop_Q_A(ntryL,G1H6(34),21,0,G2H6(8),n2h6(31))
  call Hloop_QV_A(ntryL,G1H12(23),ex3(:),G1H6(37),m3h2x6(:,27),heltab2x12(:,:,46))
  call Hloop_Q_A(ntryL,G1H6(37),21,0,G2H6(7),n2h6(32))
  call Hloop_QW_A(ntryL,G1H12(12),wf6(:,6),G1H2(20),m3h6x2(:,5),heltab2x12(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(20),29,0,G2H2(39),n2h2(43))
call HGT_raise_alpha_OLR(G1H12(2),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(2),ex2(:),G1H6(38),m3h2x6(:,28),heltab2x12(:,:,48))
  call Hloop_QW_A(ntryL,G1H12(24),wf6(:,6),G1H2(4),m3h6x2(:,6),heltab2x12(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(40),n2h2(44))
  call Hloop_QW_A(ntryL,G1H12(25),wf6(:,6),G1H2(5),m3h6x2(:,7),heltab2x12(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(41),n2h2(45))
  call ol_merge(ntryL,G2H3(2),[G1H3(8)])
  call ol_merge(ntryL,G2H3(15),[G2H3(5),G1H3(19)])
  call ol_merge(ntryL,G2H3(8),[G1H3(30)])
  call ol_merge(ntryL,G2H3(7),[G1H3(28)])
call HGT_OLR(G2H3(10),1,1,3)
call HGT_invQ_OLR(G2H3(10),2,5,3)
call HGT_OLR(G2H3(10),6,15,3)
  call ol_merge(ntryL,G2H3(10),[G2H3(7)])
  call ol_merge(ntryL,G2H2(25),[G2H2(5),G1H2(8)])
  call ol_merge(ntryL,G2H3(16),[G2H3(12),G1H3(41)])
  call ol_merge(ntryL,G2H3(3),[G1H3(6)])
call HGT_OLR(G2H3(14),1,1,3)
call HGT_invQ_OLR(G2H3(14),2,5,3)
call HGT_OLR(G2H3(14),6,15,3)
  call ol_merge(ntryL,G2H3(14),[G2H3(3)])
  call ol_merge(ntryL,G2H2(26),[G2H2(9),G1H2(19)])
  call ol_merge(ntryL,G2H3(1),[G1H3(17)])
call HGT_w2_OLR(G1H3(1),1,1,3)
call HGT_w2_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,G2H3(1),[G1H3(1)])
  call ol_merge(ntryL,G2H2(39),[G2H2(17),G2H2(12)])
call HGT_w2_OLR(G1H3(2),1,1,3)
call HGT_w2_invQ_OLR(G1H3(2),2,5,3)
  call ol_merge(ntryL,G1H3(2),[G1H3(23)])
  call ol_merge(ntryL,G2H2(41),[G2H2(20),G2H2(19),G2H2(15),G2H2(14)])
  call ol_merge(ntryL,G2H2(4),[G1H2(6)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,G2H2(4),[G1H2(1)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,G1H2(2),[G1H2(12)])
  call ol_merge(ntryL,G2H3(4),[G1H3(7)])
  call ol_merge(ntryL,G2H3(6),[G1H3(18)])
  call ol_merge(ntryL,G2H3(9),[G1H3(29)])
  call ol_merge(ntryL,G2H2(6),[G1H2(7)])
  call ol_merge(ntryL,G2H3(11),[G1H3(39)])
  call ol_merge(ntryL,G2H3(13),[G1H3(40)])
  call ol_merge(ntryL,G2H2(8),[G1H2(17)])
  call ol_merge(ntryL,G2H2(10),[G1H2(18)])
  call ol_merge(ntryL,G2H2(35),[G2H2(16)])
  call ol_merge(ntryL,G2H2(29),[G2H2(18)])
  call ol_merge(ntryL,G2H2(38),[G2H2(23)])
  call ol_merge(ntryL,G2H2(32),[G2H2(24)])
call HGT_OLR(G2H2(1),1,1,2)
call HGT_invQ_OLR(G2H2(1),2,5,2)
call HGT_OLR(G2H2(1),6,15,2)
call Hotf_4pt_reduction(G2H2(1),RedSet_4(37),mass4set(:,1),  & 
G1H2(10),G1H2(15),G1H2(16),G1H2(20),G1H2(4),2)
call HG1shiftOLR(G1H2(15),2,2)
call Hotf_4pt_reduction(G2H3(2),RedSet_4(16),mass4set(:,1),  & 
G1H3(32),G1H3(33),G1H3(37),G1H3(38),G1H3(43),3)
call HG1shiftOLR(G1H3(33),8,3)
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
call Hotf_4pt_reduction(G2H2(2),RedSet_4(38),mass4set(:,1),  & 
G1H2(5),G1H2(8),G1H2(19),G1H2(6),G1H2(1),2)
call HG1shiftOLR(G1H2(8),4,2)
call Hotf_4pt_reduction(G2H3(15),RedSet_4(20),mass4set(:,1),  & 
G1H3(44),G1H3(9),G1H3(20),G1H3(31),G1H3(42),3)
call HG1shiftOLR(G1H3(9),8,3)
call HGT_OLR(G2H2(3),1,1,2)
call HGT_invQ_OLR(G2H2(3),2,5,2)
call HGT_OLR(G2H2(3),6,15,2)
call Hotf_4pt_reduction(G2H2(3),RedSet_4(39),mass4set(:,1),  & 
G1H2(12),G1H2(7),G1H2(17),G1H2(18),G1H2(26),2)
call HG1shiftOLR(G1H2(7),1,2)
call Hotf_4pt_reduction(G2H3(8),RedSet_4(16),mass4set(:,1),  & 
G1H3(4),G1H3(5),G1H3(10),G1H3(11),G1H3(15),3)
call HG1shiftOLR(G1H3(5),8,3)
call Hotf_4pt_reduction(G2H3(10),RedSet_4(22),mass4set(:,1),  & 
G1H3(16),G1H3(8),G1H3(19),G1H3(30),G1H3(28),3)
call HG1shiftOLR(G1H3(8),8,3)
call Hotf_4pt_reduction(G2H2(25),RedSet_4(27),mass4set(:,1),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),2)
call HG1shiftOLR(G1H2(28),4,2)
call HGT_OLR(G2H2(7),1,1,2)
call HGT_invQ_OLR(G2H2(7),2,5,2)
call HGT_OLR(G2H2(7),6,15,2)
call Hotf_4pt_reduction(G2H2(7),RedSet_4(40),mass4set(:,1),  & 
G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
call HG1shiftOLR(G1H2(33),4,2)
call Hotf_4pt_reduction(G2H3(16),RedSet_4(30),mass4set(:,1),  & 
G1H3(41),G1H3(6),G1H3(17),G1H3(1),G1H3(23),3)
call HG1shiftOLR(G1H3(6),8,3)
call Hotf_4pt_reduction(G2H3(14),RedSet_4(14),mass4set(:,1),  & 
G1H3(7),G1H3(18),G1H3(29),G1H3(39),G1H3(40),3)
call HG1shiftOLR(G1H3(18),8,3)
call Hotf_4pt_reduction(G2H2(26),RedSet_4(33),mass4set(:,1),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),2)
call HG1shiftOLR(G1H2(38),4,2)
call Hotf_4pt_reduction(G2H3(1),RedSet_4(18),mass4set(:,1),  & 
G1H3(48),G1H3(49),G1H3(50),G1H3(51),G1H3(52),3)
call HG1shiftOLR(G1H3(49),8,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex2(:),G2tensor(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hloop_QW_A(ntryL,G1H3(2),ex4(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(25))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(41),ex2(:),G2tensor(5),m3h2x1(:,14),heltab2x2(:,:,14))
call HGT_w2_OLR(G1H3(3),1,1,3)
call HGT_w2_invQ_OLR(G1H3(3),2,5,3)
  call Hloop_QW_A(ntryL,G1H3(3),ex4(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(9),n2h1(26))
call Hotf_4pt_reduction(G2H2(4),RedSet_4(25),mass4set(:,1),  & 
G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
call HG1shiftOLR(G1H2(43),4,2)
  call Hloop_QV_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(27))
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(17),n2h1(28))
call Hotf_4pt_reduction(G2H3(4),RedSet_4(15),mass4set(:,1),  & 
G1H3(2),G1H3(3),G1H3(53),G1H3(54),G1H3(55),3)
call HG1shiftOLR(G1H3(3),8,3)
  call Hloop_AW_Q(ntryL,G1H3(12),ex4(:),G1H1(1),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(29))
  call Hloop_AW_Q(ntryL,G1H3(13),ex4(:),G1H1(1),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(30))
  call Hloop_AW_Q(ntryL,G1H3(14),ex4(:),G1H1(1),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(31))
call Hotf_4pt_reduction(G2H3(6),RedSet_4(19),mass4set(:,1),  & 
G1H3(12),G1H3(13),G1H3(14),G1H3(56),G1H3(57),3)
call HG1shiftOLR(G1H3(13),8,3)
  call Hloop_QW_A(ntryL,G1H3(24),ex4(:),G1H1(1),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(30),n2h1(32))
  call Hloop_QW_A(ntryL,G1H3(25),ex4(:),G1H1(1),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(33))
call Hotf_4pt_reduction(G2H3(9),RedSet_4(23),mass4set(:,1),  & 
G1H3(24),G1H3(25),G1H3(58),G1H3(59),G1H3(60),3)
call HG1shiftOLR(G1H3(25),8,3)
  call Hloop_QW_A(ntryL,G1H3(34),ex4(:),G1H1(1),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(34))
  call Hloop_QW_A(ntryL,G1H3(35),ex4(:),G1H1(1),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(35))
  call Hloop_QW_A(ntryL,G1H3(36),ex4(:),G1H1(1),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(36))
call Hotf_4pt_reduction(G2H2(6),RedSet_4(26),mass4set(:,1),  & 
G1H2(2),G1H2(3),G1H2(47),G1H2(48),G1H2(49),2)
call HG1shiftOLR(G1H2(3),4,2)
  call Hloop_QV_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(38))
call Hotf_4pt_reduction(G2H3(11),RedSet_4(29),mass4set(:,1),  & 
G1H3(34),G1H3(35),G1H3(36),G1H3(61),G1H3(62),3)
call HG1shiftOLR(G1H3(35),8,3)
call Hotf_4pt_reduction(G2H3(13),RedSet_4(19),mass4set(:,1),  & 
G1H3(63),G1H3(64),G1H3(65),G1H3(66),G1H3(67),3)
call HG1shiftOLR(G1H3(64),8,3)
  call Hloop_AW_Q(ntryL,G1H3(45),ex4(:),G1H1(1),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(39))
  call Hloop_AW_Q(ntryL,G1H3(46),ex4(:),G1H1(1),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(38),n2h1(40))
  call Hloop_AW_Q(ntryL,G1H3(47),ex4(:),G1H1(1),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(41))
call Hotf_4pt_reduction(G2H2(8),RedSet_4(32),mass4set(:,1),  & 
G1H2(13),G1H2(14),G1H2(50),G1H2(51),G1H2(52),2)
call HG1shiftOLR(G1H2(14),4,2)
call Hotf_4pt_reduction(G2H2(10),RedSet_4(26),mass4set(:,1),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),2)
call HG1shiftOLR(G1H2(54),4,2)
  call Hloop_AV_Q(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H2(25),ex3(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(42),n2h1(44))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(35),ex2(:),G2tensor(43),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(29),ex2(:),G2tensor(44),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(38),ex2(:),G2tensor(45),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(32),ex2(:),G2tensor(46),m3h2x1(:,25),heltab2x2(:,:,25))
call Hotf_4pt_reduction(G2H6(9),RedSet_4(6),mass4set(:,1),  & 
G1H6(39),G1H6(40),G1H6(45),G1H6(50),G1H6(46),6)
call HG1shiftOLR(G1H6(40),9,6)
call Hotf_4pt_reduction(G2H6(10),RedSet_4(4),mass4set(:,1),  & 
G1H6(49),G1H6(51),G1H6(54),G1H6(43),G1H6(11),6)
call HG1shiftOLR(G1H6(51),10,6)
call Hotf_4pt_reduction(G2H6(1),RedSet_4(7),mass4set(:,1),  & 
G1H6(8),G1H6(42),G1H6(23),G1H6(9),G1H6(6),6)
call HG1shiftOLR(G1H6(42),12,6)
call Hotf_4pt_reduction(G2H6(2),RedSet_4(5),mass4set(:,1),  & 
G1H6(18),G1H6(29),G1H6(35),G1H6(41),G1H6(1),6)
call HG1shiftOLR(G1H6(29),12,6)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(27),ex2(:),G2tensor(47),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(30),ex2(:),G2tensor(48),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex2(:),G2tensor(49),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(36),ex2(:),G2tensor(50),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(3),wf4(:,2),G2tensor(51),m3h4x1(:,1),heltab2x4(:,:,21))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(2),wf4(:,2),G2tensor(52),m3h4x1(:,2),heltab2x4(:,:,22))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(1),wf4(:,6),G2tensor(53),m3h4x1(:,3),heltab2x4(:,:,23))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(6),wf4(:,6),G2tensor(54),m3h4x1(:,4),heltab2x4(:,:,24))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(3),wf6(:,4),G2tensor(55),m3h6x1(:,1),heltab2x6(:,:,57))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(5),wf6(:,4),G2tensor(56),m3h6x1(:,2),heltab2x6(:,:,58))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(6),wf6(:,2),G2tensor(57),m3h6x1(:,3),heltab2x6(:,:,59))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(7),wf6(:,2),G2tensor(58),m3h6x1(:,4),heltab2x6(:,:,60))
  call Hloop_VA_Q(ntryL,G1H2(10),ex2(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(45))
  call Hloop_VA_Q(ntryL,G1H2(15),ex2(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(60),n2h1(46))
  call Hloop_VA_Q(ntryL,G1H2(4),ex2(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(47))
  call Hloop_AW_Q(ntryL,G1H3(32),ex4(:),G1H1(1),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(48))
  call Hloop_AW_Q(ntryL,G1H3(33),ex4(:),G1H1(1),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(63),n2h1(49))
  call Hloop_AW_Q(ntryL,G1H3(43),ex4(:),G1H1(1),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(66),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(53))
  call Hloop_QW_A(ntryL,G1H3(44),ex4(:),G1H1(1),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(54))
  call Hloop_QW_A(ntryL,G1H3(9),ex4(:),G1H1(1),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(69),n2h1(55))
  call Hloop_QW_A(ntryL,G1H3(42),ex4(:),G1H1(1),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(70),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H2(12),ex1(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(7),ex1(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(72),n2h1(58))
  call Hloop_VQ_A(ntryL,G1H2(26),ex1(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(59))
  call Hloop_QW_A(ntryL,G1H3(4),ex4(:),G1H1(1),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(74),n2h1(60))
  call Hloop_QW_A(ntryL,G1H3(5),ex4(:),G1H1(1),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(75),n2h1(61))
  call Hloop_QW_A(ntryL,G1H3(15),ex4(:),G1H1(1),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(76),n2h1(62))
  call Hloop_QW_A(ntryL,G1H3(16),ex4(:),G1H1(1),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(63))
  call Hloop_QW_A(ntryL,G1H3(8),ex4(:),G1H1(1),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(78),n2h1(64))
  call Hloop_QW_A(ntryL,G1H3(28),ex4(:),G1H1(1),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(65))
  call Hloop_QV_A(ntryL,G1H2(27),ex3(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(80),n2h1(66))
  call Hloop_QV_A(ntryL,G1H2(28),ex3(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(81),n2h1(67))
  call Hloop_QV_A(ntryL,G1H2(31),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(82),n2h1(68))
  call Hloop_AV_Q(ntryL,G1H2(32),ex3(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(69))
  call Hloop_AV_Q(ntryL,G1H2(33),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(84),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H2(36),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(71))
  call Hloop_AW_Q(ntryL,G1H3(41),ex4(:),G1H1(1),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(86),n2h1(72))
  call Hloop_AW_Q(ntryL,G1H3(6),ex4(:),G1H1(1),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(87),n2h1(73))
  call Hloop_AW_Q(ntryL,G1H3(23),ex4(:),G1H1(1),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(88),n2h1(74))
  call Hloop_AW_Q(ntryL,G1H3(7),ex4(:),G1H1(1),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(75))
  call Hloop_AW_Q(ntryL,G1H3(18),ex4(:),G1H1(1),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(90),n2h1(76))
  call Hloop_AW_Q(ntryL,G1H3(40),ex4(:),G1H1(1),m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(93),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(41),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(94),n2h1(80))
  call Hloop_QW_A(ntryL,G1H3(48),ex4(:),G1H1(1),m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(81))
  call Hloop_QW_A(ntryL,G1H3(49),ex4(:),G1H1(1),m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(96),n2h1(82))
  call Hloop_QW_A(ntryL,G1H3(52),ex4(:),G1H1(1),m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(42),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(43),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(99),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(46),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(100),n2h1(86))
  call Hloop_AW_Q(ntryL,G1H3(2),ex4(:),G1H1(1),m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(101),n2h1(87))
  call Hloop_AW_Q(ntryL,G1H3(3),ex4(:),G1H1(1),m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(102),n2h1(88))
  call Hloop_AW_Q(ntryL,G1H3(55),ex4(:),G1H1(1),m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(89))
  call Hloop_QW_A(ntryL,G1H3(12),ex4(:),G1H1(1),m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(104),n2h1(90))
  call Hloop_QW_A(ntryL,G1H3(13),ex4(:),G1H1(1),m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(105),n2h1(91))
  call Hloop_QW_A(ntryL,G1H3(57),ex4(:),G1H1(1),m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(106),n2h1(92))
  call Hloop_QW_A(ntryL,G1H3(24),ex4(:),G1H1(1),m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(107),n2h1(93))
  call Hloop_QW_A(ntryL,G1H3(25),ex4(:),G1H1(1),m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(108),n2h1(94))
  call Hloop_QW_A(ntryL,G1H3(60),ex4(:),G1H1(1),m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(109),n2h1(95))
  call Hloop_QV_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(110),n2h1(96))
  call Hloop_QV_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(111),n2h1(97))
  call Hloop_QV_A(ntryL,G1H2(49),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(112),n2h1(98))
  call Hloop_AW_Q(ntryL,G1H3(34),ex4(:),G1H1(1),m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(113),n2h1(99))
  call Hloop_AW_Q(ntryL,G1H3(35),ex4(:),G1H1(1),m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(114),n2h1(100))
  call Hloop_AW_Q(ntryL,G1H3(62),ex4(:),G1H1(1),m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(115),n2h1(101))
  call Hloop_AW_Q(ntryL,G1H3(63),ex4(:),G1H1(1),m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(116),n2h1(102))
  call Hloop_AW_Q(ntryL,G1H3(64),ex4(:),G1H1(1),m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(117),n2h1(103))
  call Hloop_AW_Q(ntryL,G1H3(67),ex4(:),G1H1(1),m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(118),n2h1(104))
  call Hloop_AV_Q(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(105))
  call Hloop_AV_Q(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(120),n2h1(106))
  call Hloop_AV_Q(ntryL,G1H2(52),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(121),n2h1(107))
  call Hloop_AV_Q(ntryL,G1H2(53),ex3(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(122),n2h1(108))
  call Hloop_AV_Q(ntryL,G1H2(54),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(123),n2h1(109))
  call Hloop_AV_Q(ntryL,G1H2(57),ex3(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(124),n2h1(110))
  call Hloop_VQ_A(ntryL,G1H6(39),wf6(:,4),G1H1(1),m3h6x1(:,5),heltab2x6(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(125),n2h1(111))
  call Hloop_VQ_A(ntryL,G1H6(40),wf6(:,4),G1H1(1),m3h6x1(:,6),heltab2x6(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(126),n2h1(112))
  call Hloop_VQ_A(ntryL,G1H6(46),wf6(:,4),G1H1(1),m3h6x1(:,7),heltab2x6(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(127),n2h1(113))
  call Hloop_VA_Q(ntryL,G1H6(49),wf6(:,2),G1H1(1),m3h6x1(:,8),heltab2x6(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(128),n2h1(114))
  call Hloop_VA_Q(ntryL,G1H6(51),wf6(:,2),G1H1(1),m3h6x1(:,9),heltab2x6(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(129),n2h1(115))
  call Hloop_VA_Q(ntryL,G1H6(11),wf6(:,2),G1H1(1),m3h6x1(:,10),heltab2x6(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(130),n2h1(116))
  call Hloop_AW_Q(ntryL,G1H6(8),wf6(:,6),G1H1(1),m3h6x1(:,11),heltab2x6(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(117))
  call Hloop_AW_Q(ntryL,G1H6(42),wf6(:,6),G1H1(1),m3h6x1(:,12),heltab2x6(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(132),n2h1(118))
  call Hloop_AW_Q(ntryL,G1H6(6),wf6(:,6),G1H1(1),m3h6x1(:,13),heltab2x6(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(133),n2h1(119))
  call Hloop_QW_A(ntryL,G1H6(18),wf6(:,6),G1H1(1),m3h6x1(:,14),heltab2x6(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(134),n2h1(120))
  call Hloop_QW_A(ntryL,G1H6(29),wf6(:,6),G1H1(1),m3h6x1(:,15),heltab2x6(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(135),n2h1(121))
  call Hloop_QW_A(ntryL,G1H6(1),wf6(:,6),G1H1(1),m3h6x1(:,16),heltab2x6(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(136),n2h1(122))
  call ol_merge_tensors(G2tensor(57),[G2tensor(2),G1tensor(6)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(4),G1tensor(12)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(7),G1tensor(18)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(10),G1tensor(20)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(19),G2tensor(11),G1tensor(36),G1tensor(24)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(14),G1tensor(26)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(15),G1tensor(30)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(18),G1tensor(32),G1tensor(27)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(22),G1tensor(38)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(27),G2tensor(23),G1tensor(48),G1tensor(42)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(26),G1tensor(44),G1tensor(15)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(21),G1tensor(2)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(33),G1tensor(8)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(62),G1tensor(29),G1tensor(17)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(104),G1tensor(40),G1tensor(22)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(110),G1tensor(46),G1tensor(34)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(47)])
call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
call G_TensorShift(G1tensor(7),10)
call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(3),mass4set(:,1),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(6),G1tensor(12))
call G_TensorShift(G1tensor(37),6)
call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(37),mass4set(:,1),  & 
G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(36),G1tensor(24))
call G_TensorShift(G1tensor(18),2)
call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(4),mass4set(:,1),  & 
G1tensor(26),G1tensor(30),G1tensor(32),G1tensor(27),G1tensor(38))
call G_TensorShift(G1tensor(30),10)
call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(38),mass4set(:,1),  & 
G1tensor(48),G1tensor(42),G1tensor(44),G1tensor(15),G1tensor(21))
call G_TensorShift(G1tensor(42),4)
call Hotf_4pt_reduction_last(G2tensor(134),RedSet_4(5),mass4set(:,1),  & 
G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(11),G1tensor(5))
call G_TensorShift(G1tensor(3),12)
call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(39),mass4set(:,1),  & 
G1tensor(33),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(16))
call G_TensorShift(G1tensor(8),1)
call Hotf_4pt_reduction_last(G2tensor(125),RedSet_4(6),mass4set(:,1),  & 
G1tensor(29),G1tensor(17),G1tensor(40),G1tensor(22),G1tensor(23))
call G_TensorShift(G1tensor(17),9)
call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(22),mass4set(:,1),  & 
G1tensor(28),G1tensor(46),G1tensor(34),G1tensor(35),G1tensor(39))
call G_TensorShift(G1tensor(46),8)
call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(40),mass4set(:,1),  & 
G1tensor(41),G1tensor(45),G1tensor(47),G1tensor(49),G1tensor(50))
call G_TensorShift(G1tensor(45),4)
call Hotf_4pt_reduction_last(G2tensor(131),RedSet_4(7),mass4set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
call G_TensorShift(G1tensor(52),12)
call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(14),mass4set(:,1),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(57),8)
call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(18),mass4set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
call G_TensorShift(G1tensor(62),8)
call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(8),mass4set(:,1),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
call G_TensorShift(G1tensor(67),2)
call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(9),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
call G_TensorShift(G1tensor(72),2)
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
call G_TensorShift(G1tensor(77),2)
call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(25),mass4set(:,1),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
call G_TensorShift(G1tensor(82),4)
call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(11),mass4set(:,1),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(87),2)
call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(12),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
call G_TensorShift(G1tensor(92),2)
call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(15),mass4set(:,1),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
call G_TensorShift(G1tensor(97),8)
call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(16),mass4set(:,1),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
call G_TensorShift(G1tensor(102),8)
call Hotf_4pt_reduction_last(G2tensor(116),RedSet_4(19),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
call G_TensorShift(G1tensor(107),8)
call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(20),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
call G_TensorShift(G1tensor(112),8)
call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(23),mass4set(:,1),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(117),8)
call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(26),mass4set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
call G_TensorShift(G1tensor(122),4)
call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(27),mass4set(:,1),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
call G_TensorShift(G1tensor(127),4)
call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(29),mass4set(:,1),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
call G_TensorShift(G1tensor(132),8)
call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(30),mass4set(:,1),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
call G_TensorShift(G1tensor(137),8)
call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(32),mass4set(:,1),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
call G_TensorShift(G1tensor(142),4)
call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(33),mass4set(:,1),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
call G_TensorShift(G1tensor(147),4)
call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(35),mass4set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
call G_TensorShift(G1tensor(152),5)
call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(36),mass4set(:,1),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
call G_TensorShift(G1tensor(157),9)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(37),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(4),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
call Hotf_4pt_reduction_last(G1tensor(48),RedSet_4(38),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(5),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
call Hotf_4pt_reduction_last(G1tensor(33),RedSet_4(39),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(6),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(22),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(40),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(7),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(14),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(18),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(8),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(9),mass4set(:,1),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(1),mass4set(:,1),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(25),mass4set(:,1),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(11),mass4set(:,1),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(12),mass4set(:,1),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(15),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(16),mass4set(:,1),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(19),mass4set(:,1),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(20),mass4set(:,1),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(23),mass4set(:,1),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(26),mass4set(:,1),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(27),mass4set(:,1),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(29),mass4set(:,1),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(30),mass4set(:,1),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(32),mass4set(:,1),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(33),mass4set(:,1),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(35),mass4set(:,1),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(36),mass4set(:,1),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
call ol_merge_tensors(T0sum(3),[G0tensor(11)])
call ol_merge_tensors(T0sum(4),[G0tensor(16)])
call ol_merge_tensors(T0sum(5),[G0tensor(21)])
call ol_merge_tensors(T0sum(6),[G0tensor(26)])
call ol_merge_tensors(T0sum(7),[G0tensor(31)])
call ol_merge_tensors(T0sum(8),[G0tensor(36)])
call ol_merge_tensors(T0sum(9),[G0tensor(41)])
call ol_merge_tensors(T0sum(10),[G0tensor(46)])
call ol_merge_tensors(T0sum(11),[G0tensor(51)])
call ol_merge_tensors(T0sum(12),[G0tensor(56)])
call ol_merge_tensors(T0sum(13),[G0tensor(61)])
call ol_merge_tensors(T0sum(14),[G0tensor(66)])
call ol_merge_tensors(T0sum(15),[G0tensor(71)])
call ol_merge_tensors(T0sum(16),[G0tensor(76)])
call ol_merge_tensors(T0sum(17),[G0tensor(81)])
call ol_merge_tensors(T0sum(18),[G0tensor(86)])
call ol_merge_tensors(T0sum(19),[G0tensor(91)])
call ol_merge_tensors(T0sum(20),[G0tensor(96)])
call ol_merge_tensors(T0sum(21),[G0tensor(101)])
call ol_merge_tensors(T0sum(22),[G0tensor(106)])
call ol_merge_tensors(T0sum(23),[G0tensor(111)])
call ol_merge_tensors(T0sum(24),[G0tensor(116)])
call ol_merge_tensors(T0sum(25),[G0tensor(121)])
call ol_merge_tensors(T0sum(26),[G0tensor(126)])
call ol_merge_tensors(T0sum(27),[G0tensor(131)])
call ol_merge_tensors(T0sum(28),[G0tensor(136)])
call ol_merge_tensors(T0sum(29),[G0tensor(141)])
call ol_merge_tensors(T0sum(30),[G0tensor(146)])
call ol_merge_tensors(T0sum(31),[G0tensor(151)])
call ol_merge_tensors(T0sum(32),[G0tensor(156)])
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(28),h0tab(:,28),[16,5,10],[0,0,0],3,2,wf4(:,2),wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,24),heltab2x48(:,:,28))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(1),n2h24(17))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(29),h0tab(:,29),[16,5,10],[0,0,0],3,2,wf4(:,2),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(2),m3h2x24(:,25),heltab2x48(:,:,29))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(30),h0tab(:,30),[18,5,8],[0,0,0],3,2,wf4(:,4),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(1),m3h4x12(:,5),heltab2x48(:,:,30))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(31),h0tab(:,31),[16,2,13],[0,0,0],3,1,wf12(:,17))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,26),heltab2x48(:,:,31))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(3),n2h24(18))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(32),h0tab(:,32),[16,2,13],[0,0,0],3,1,wf12(:,17))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(4),m3h2x24(:,27),heltab2x48(:,:,32))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(20)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(33),h0tab(:,33),[21,2,8],[0,0,0],3,1,wf8(:,13))
  call Hloop_AQ_V(ntryL,G0H48(1),wf8(:,13),G0H6(1),m3h8x6(:,1),heltab2x48(:,:,33))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(34),h0tab(:,34),[16,6,9],[0,0,0],3,2,wf4(:,6),wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,28),heltab2x48(:,:,34))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(5),n2h24(19))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(35),h0tab(:,35),[16,6,9],[0,0,0],3,2,wf4(:,6),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(6),m3h2x24(:,29),heltab2x48(:,:,35))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(36),h0tab(:,36),[17,6,8],[0,0,0],3,2,wf4(:,8),wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(2),m3h4x12(:,6),heltab2x48(:,:,36))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(34)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(37),h0tab(:,37),[16,1,14],[0,0,0],3,1,wf12(:,20))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,30),heltab2x48(:,:,37))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(7),n2h24(20))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(34)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(38),h0tab(:,38),[16,1,14],[0,0,0],3,1,wf12(:,20))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(8),m3h2x24(:,31),heltab2x48(:,:,38))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(39),h0tab(:,39),[22,1,8],[0,0,0],3,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H48(1),wf8(:,15),G0H6(2),m3h8x6(:,2),heltab2x48(:,:,39))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(40),h0tab(:,40),[18,4,9],[0,0,0],3,2,wf4(:,4),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(3),m3h4x12(:,7),heltab2x48(:,:,40))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(3),n2h12(19))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(41),h0tab(:,41),[16,4,11],[0,0,0],3,1,wf12(:,29))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,32),heltab2x48(:,:,41))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(9),n2h24(21))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(42),h0tab(:,42),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,29))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,33),heltab2x48(:,:,42))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(10),n2h24(22))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(43),h0tab(:,43),[16,4,11],[0,0,0],3,1,wf12(:,29))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,34),heltab2x48(:,:,43))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(11),n2h24(23))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(44),h0tab(:,44),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,29))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,35),heltab2x48(:,:,44))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(12),n2h24(24))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(45),h0tab(:,45),[16,4,11],[0,0,0],3,1,wf12(:,29))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,36),heltab2x48(:,:,45))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(13),n2h24(25))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(46),h0tab(:,46),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,29))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,37),heltab2x48(:,:,46))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(14),n2h24(26))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(47),h0tab(:,47),[16,4,11],[0,0,0],3,1,wf12(:,29))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,38),heltab2x48(:,:,47))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(15),n2h24(27))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(48),h0tab(:,48),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,29))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,39),heltab2x48(:,:,48))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(16),n2h24(28))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(49),h0tab(:,49),[16,2,13],[0,0,0],3,1,wf12(:,22))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,40),heltab2x48(:,:,49))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(17),n2h24(29))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(50),h0tab(:,50),[16,2,13],[0,0,0],3,1,wf12(:,22))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(18),m3h2x24(:,41),heltab2x48(:,:,50))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(51),h0tab(:,51),[25,2,4],[0,0,0],3,1,wf12(:,18))
  call Hloop_AQ_V(ntryL,G0H48(1),wf12(:,18),G0H4(1),m3h12x4(:,1),heltab2x48(:,:,51))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(52),h0tab(:,52),[17,4,10],[0,0,0],3,2,wf4(:,8),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(4),m3h4x12(:,8),heltab2x48(:,:,52))
  call Hloop_Q_A(ntryL,G0H12(4),17,0,G1H12(6),n2h12(20))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(53),h0tab(:,53),[16,4,11],[0,0,0],3,1,wf12(:,30))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,42),heltab2x48(:,:,53))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(19),n2h24(30))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(54),h0tab(:,54),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,30))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,43),heltab2x48(:,:,54))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(20),n2h24(31))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(55),h0tab(:,55),[16,4,11],[0,0,0],3,1,wf12(:,30))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,44),heltab2x48(:,:,55))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(21),n2h24(32))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(56),h0tab(:,56),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,30))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,45),heltab2x48(:,:,56))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(22),n2h24(33))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(57),h0tab(:,57),[16,4,11],[0,0,0],3,1,wf12(:,30))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,46),heltab2x48(:,:,57))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(23),n2h24(34))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(58),h0tab(:,58),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,30))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,47),heltab2x48(:,:,58))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(24),n2h24(35))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(59),h0tab(:,59),[16,4,11],[0,0,0],3,1,wf12(:,30))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,48),heltab2x48(:,:,59))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(25),n2h24(36))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(60),h0tab(:,60),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,30))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,49),heltab2x48(:,:,60))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(26),n2h24(37))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(61),h0tab(:,61),[16,1,14],[0,0,0],3,1,wf12(:,24))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,50),heltab2x48(:,:,61))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(27),n2h24(38))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(62),h0tab(:,62),[16,1,14],[0,0,0],3,1,wf12(:,24))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(28),m3h2x24(:,51),heltab2x48(:,:,62))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(63),h0tab(:,63),[26,1,4],[0,0,0],3,1,wf12(:,14))
  call Hloop_QA_V(ntryL,G0H48(1),wf12(:,14),G0H4(2),m3h12x4(:,2),heltab2x48(:,:,63))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(64),h0tab(:,64),[17,2,12],[0,0,0],3,2,wf4(:,8),wf6(:,6))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(3),m3h4x12(:,9),heltab2x48(:,:,64))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(65),h0tab(:,65),[18,1,12],[0,0,0],3,2,wf4(:,4),wf6(:,6))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(4),m3h4x12(:,10),heltab2x48(:,:,65))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(48)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(66),h0tab(:,66),[16,2,13],[0,0,0],3,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,52),heltab2x48(:,:,66))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(29),n2h24(39))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(48)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(67),h0tab(:,67),[16,2,13],[0,0,0],3,1,wf12(:,28))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(30),m3h2x24(:,53),heltab2x48(:,:,67))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(68),h0tab(:,68),[16,1,14],[0,0,0],3,1,wf12(:,26))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,54),heltab2x48(:,:,68))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(31),n2h24(40))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(69),h0tab(:,69),[16,1,14],[0,0,0],3,1,wf12(:,26))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(32),m3h2x24(:,55),heltab2x48(:,:,69))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(70),h0tab(:,70),[21,2,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_AQ_V(ntryL,G0H48(1),wf8(:,18),G0H6(3),m3h8x6(:,3),heltab2x48(:,:,70))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(36)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(71),h0tab(:,71),[25,2,4],[0,0,0],3,1,wf12(:,21))
  call Hloop_AQ_V(ntryL,G0H48(1),wf12(:,21),G0H4(3),m3h12x4(:,3),heltab2x48(:,:,71))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(38)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(72),h0tab(:,72),[22,1,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_QA_V(ntryL,G0H48(1),wf8(:,17),G0H6(4),m3h8x6(:,4),heltab2x48(:,:,72))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(73),h0tab(:,73),[26,1,4],[0,0,0],3,1,wf12(:,16))
  call Hloop_QA_V(ntryL,G0H48(1),wf12(:,16),G0H4(4),m3h12x4(:,4),heltab2x48(:,:,73))
  call ol_merge(ntryL,G1H6(21),[G1H6(14)])
  call ol_merge(ntryL,G1H4(13),[G1H4(2)])
  call ol_merge(ntryL,G1H12(3),[G1H12(17)])
  call ol_merge(ntryL,G1H12(6),[G1H12(21)])
  call ol_merge(ntryL,G0H6(3),[G0H6(1)])
  call ol_merge(ntryL,G0H6(4),[G0H6(2)])
  call ol_merge(ntryL,G1H24(13),[G1H24(9)])
  call ol_merge(ntryL,G1H24(15),[G1H24(11)])
  call ol_merge(ntryL,G0H4(3),[G0H4(1)])
  call ol_merge(ntryL,G1H24(23),[G1H24(19)])
  call ol_merge(ntryL,G1H24(25),[G1H24(21)])
  call ol_merge(ntryL,G0H4(4),[G0H4(2)])
  call Hloop_QW_A(ntryL,G1H6(21),ex4(:),G1H2(23),m3h3x2(:,30),heltab2x6(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(23),29,0,G2H2(5),n2h2(46))
  call Hloop_QV_A(ntryL,G1H4(13),ex3(:),G1H2(24),m3h2x2(:,21),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(24),29,0,G2H2(9),n2h2(47))
  call Hloop_AW_Q(ntryL,G1H12(7),ex4(:),G1H4(6),m3h3x4(:,12),heltab2x12(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(6),26,0,G2H4(3),n2h4(17))
  call Hloop_QW_A(ntryL,G1H12(13),ex4(:),G1H4(1),m3h3x4(:,13),heltab2x12(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(2),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H12(3),ex3(:),G1H6(2),m3h2x6(:,29),heltab2x12(:,:,53))
  call Hloop_A_Q(ntryL,G1H6(2),22,0,G2H6(9),n2h6(33))
  call Hloop_QV_A(ntryL,G1H12(6),ex3(:),G1H6(5),m3h2x6(:,30),heltab2x12(:,:,54))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(10),n2h6(34))
  call Hloop_QW_A(ntryL,G1H12(9),wf6(:,6),G1H2(25),m3h6x2(:,8),heltab2x12(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(25),29,0,G2H2(17),n2h2(48))
  call Hloop_AQ_V(ntryL,G1H24(1),wf4(:,2),G1H6(44),m3h4x6(:,3),heltab2x24(:,:,24))
  call Hloop_VQ_A(ntryL,G1H24(2),wf4(:,2),G1H6(12),m3h4x6(:,4),heltab2x24(:,:,25))
  call Hloop_Q_A(ntryL,G1H6(12),21,0,G2H6(1),n2h6(35))
  call Hloop_VQ_A(ntryL,G0H12(1),wf4(:,2),G0H3(1),m3h4x3(:,5),heltab2x12(:,:,56))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(45),n2h3(23))
  call Hloop_QA_V(ntryL,G1H24(3),ex2(:),G1H12(10),m3h2x12(:,22),heltab2x24(:,:,26))
  call Hloop_VA_Q(ntryL,G1H24(4),ex2(:),G1H12(11),m3h2x12(:,23),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G1H12(11),18,0,G2H12(1),n2h12(21))
  call Hloop_VA_Q(ntryL,G0H6(3),ex2(:),G0H3(1),m3h2x3(:,28),heltab2x6(:,:,74))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(46),n2h3(24))
  call Hloop_QA_V(ntryL,G1H24(5),wf4(:,6),G1H6(17),m3h4x6(:,5),heltab2x24(:,:,28))
  call Hloop_VA_Q(ntryL,G1H24(6),wf4(:,6),G1H6(3),m3h4x6(:,6),heltab2x24(:,:,29))
  call Hloop_A_Q(ntryL,G1H6(3),22,0,G2H6(2),n2h6(36))
  call Hloop_VA_Q(ntryL,G0H12(2),wf4(:,6),G0H3(1),m3h4x3(:,6),heltab2x12(:,:,57))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(47),n2h3(25))
  call Hloop_AQ_V(ntryL,G1H24(7),ex1(:),G1H12(5),m3h2x12(:,24),heltab2x24(:,:,30))
  call Hloop_VQ_A(ntryL,G1H24(8),ex1(:),G1H12(1),m3h2x12(:,25),heltab2x24(:,:,31))
  call Hloop_Q_A(ntryL,G1H12(1),17,0,G2H12(2),n2h12(22))
  call Hloop_VQ_A(ntryL,G0H6(4),ex1(:),G0H3(1),m3h2x3(:,29),heltab2x6(:,:,75))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(32),n2h3(26))
  call Hloop_QV_A(ntryL,G1H24(13),ex3(:),G1H12(14),m3h2x12(:,26),heltab2x24(:,:,32))
  call Hloop_Q_A(ntryL,G1H12(14),20,0,G2H12(3),n2h12(23))
  call Hloop_QV_A(ntryL,G1H24(10),ex3(:),G1H12(15),m3h2x12(:,27),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G1H12(15),20,nMT,G2H12(4),n2h12(24))
  call Hloop_AV_Q(ntryL,G1H24(15),ex3(:),G1H12(4),m3h2x12(:,28),heltab2x24(:,:,34))
  call Hloop_A_Q(ntryL,G1H12(4),20,0,G2H12(5),n2h12(25))
  call Hloop_AV_Q(ntryL,G1H24(12),ex3(:),G1H12(16),m3h2x12(:,29),heltab2x24(:,:,35))
  call Hloop_A_Q(ntryL,G1H12(16),20,nMT,G2H12(6),n2h12(26))
  call Hloop_QV_A(ntryL,G1H24(14),ex3(:),G1H12(18),m3h2x12(:,30),heltab2x24(:,:,36))
  call Hloop_Q_A(ntryL,G1H12(18),20,nMB,G2H12(7),n2h12(27))
  call Hloop_AV_Q(ntryL,G1H24(16),ex3(:),G1H12(19),m3h2x12(:,31),heltab2x24(:,:,37))
  call Hloop_A_Q(ntryL,G1H12(19),20,nMB,G2H12(8),n2h12(28))
  call Hloop_QA_V(ntryL,G1H24(17),ex2(:),G1H12(8),m3h2x12(:,32),heltab2x24(:,:,38))
  call Hloop_VA_Q(ntryL,G1H24(18),ex2(:),G1H12(20),m3h2x12(:,33),heltab2x24(:,:,39))
  call Hloop_A_Q(ntryL,G1H12(20),18,0,G2H12(9),n2h12(29))
  call Hloop_VA_Q(ntryL,G0H4(3),ex2(:),G0H2(1),m3h2x2(:,22),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(10),n2h2(49))
  call Hloop_QV_A(ntryL,G1H24(23),ex3(:),G1H12(22),m3h2x12(:,34),heltab2x24(:,:,40))
  call Hloop_Q_A(ntryL,G1H12(22),20,0,G2H12(10),n2h12(30))
  call Hloop_QV_A(ntryL,G1H24(20),ex3(:),G1H12(23),m3h2x12(:,35),heltab2x24(:,:,41))
  call Hloop_Q_A(ntryL,G1H12(23),20,nMT,G2H12(11),n2h12(31))
  call Hloop_AV_Q(ntryL,G1H24(25),ex3(:),G1H12(12),m3h2x12(:,36),heltab2x24(:,:,42))
  call Hloop_A_Q(ntryL,G1H12(12),20,0,G2H12(12),n2h12(32))
  call Hloop_AV_Q(ntryL,G1H24(22),ex3(:),G1H12(2),m3h2x12(:,37),heltab2x24(:,:,43))
  call Hloop_A_Q(ntryL,G1H12(2),20,nMT,G2H12(13),n2h12(33))
  call Hloop_QV_A(ntryL,G1H24(24),ex3(:),G1H12(24),m3h2x12(:,38),heltab2x24(:,:,44))
  call Hloop_Q_A(ntryL,G1H12(24),20,nMB,G2H12(14),n2h12(34))
  call Hloop_AV_Q(ntryL,G1H24(26),ex3(:),G1H12(25),m3h2x12(:,39),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G1H12(25),20,nMB,G2H12(15),n2h12(35))
  call Hloop_AQ_V(ntryL,G1H24(27),ex1(:),G1H12(17),m3h2x12(:,40),heltab2x24(:,:,46))
  call Hloop_VQ_A(ntryL,G1H24(28),ex1(:),G1H12(21),m3h2x12(:,41),heltab2x24(:,:,47))
  call Hloop_Q_A(ntryL,G1H12(21),17,0,G2H12(16),n2h12(36))
  call Hloop_VQ_A(ntryL,G0H4(4),ex1(:),G0H2(1),m3h2x2(:,23),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(15),n2h2(50))
  call Hloop_VA_Q(ntryL,G0H12(3),ex2(:),G0H6(1),m3h2x6(:,31),heltab2x12(:,:,58))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(24),n2h6(37))
  call Hloop_VQ_A(ntryL,G0H12(4),ex1(:),G0H6(2),m3h2x6(:,32),heltab2x12(:,:,59))
  call Hloop_Q_A(ntryL,G0H6(2),19,0,G1H6(4),n2h6(38))
  call Hloop_QA_V(ntryL,G1H24(29),ex2(:),G1H12(7),m3h2x12(:,42),heltab2x24(:,:,48))
  call Hloop_VA_Q(ntryL,G1H24(30),ex2(:),G1H12(13),m3h2x12(:,43),heltab2x24(:,:,49))
  call Hloop_A_Q(ntryL,G1H12(13),18,0,G2H12(17),n2h12(37))
  call Hloop_AQ_V(ntryL,G1H24(31),ex1(:),G1H12(3),m3h2x12(:,44),heltab2x24(:,:,50))
  call Hloop_VQ_A(ntryL,G1H24(32),ex1(:),G1H12(6),m3h2x12(:,45),heltab2x24(:,:,51))
  call Hloop_Q_A(ntryL,G1H12(6),17,0,G2H12(18),n2h12(38))
  call ol_merge(ntryL,G2H2(17),[G2H2(37),G2H2(34),G2H2(21),G2H2(11)])
  call ol_merge(ntryL,G2H2(40),[G2H2(31),G2H2(28),G2H2(22),G2H2(13)])
  call ol_merge(ntryL,G1H3(45),[G1H3(51),G1H3(20)])
call HGT_w2_OLR(G1H3(21),1,1,3)
call HGT_w2_invQ_OLR(G1H3(21),2,5,3)
  call ol_merge(ntryL,G1H3(21),[G1H3(45)])
  call ol_merge(ntryL,G1H2(45),[G1H2(29)])
call HGT_w2_OLR(G1H2(21),1,1,2)
call HGT_w2_invQ_OLR(G1H2(21),2,5,2)
  call ol_merge(ntryL,G1H2(21),[G1H2(45)])
  call ol_merge(ntryL,G1H3(14),[G1H3(50)])
call HGT_w2_OLR(G1H3(22),1,1,3)
call HGT_w2_invQ_OLR(G1H3(22),2,5,3)
  call ol_merge(ntryL,G1H3(22),[G1H3(14)])
  call ol_merge(ntryL,G1H2(47),[G1H2(44)])
call HGT_w2_OLR(G1H2(11),1,1,2)
call HGT_w2_invQ_OLR(G1H2(11),2,5,2)
  call ol_merge(ntryL,G1H2(11),[G1H2(47)])
  call ol_merge(ntryL,G1H3(46),[G1H3(53),G1H3(29)])
call HGT_w2_OLR(G1H3(26),1,1,3)
call HGT_w2_invQ_OLR(G1H3(26),2,5,3)
  call ol_merge(ntryL,G1H3(26),[G1H3(46)])
  call ol_merge(ntryL,G1H3(32),[G1H3(58),G1H3(19)])
call HGT_w2_OLR(G1H3(27),1,1,3)
call HGT_w2_invQ_OLR(G1H3(27),2,5,3)
  call ol_merge(ntryL,G1H3(27),[G1H3(32)])
  call ol_merge(ntryL,G1H2(10),[G1H2(34)])
call HGT_w2_OLR(G1H2(22),1,1,2)
call HGT_w2_invQ_OLR(G1H2(22),2,5,2)
  call ol_merge(ntryL,G1H2(22),[G1H2(10)])
  call ol_merge(ntryL,G2H6(2),[G2H6(4)])
  call ol_merge(ntryL,G1H2(15),[G1H2(19)])
call HGT_w2_OLR(G1H2(9),1,1,2)
call HGT_w2_invQ_OLR(G1H2(9),2,5,2)
  call ol_merge(ntryL,G1H2(9),[G1H2(15)])
  call ol_merge(ntryL,G2H6(1),[G2H6(8)])
  call ol_merge(ntryL,G1H6(4),[G1H6(35)])
call HGT_w2_OLR(G1H6(38),1,1,6)
call HGT_w2_invQ_OLR(G1H6(38),2,5,6)
  call ol_merge(ntryL,G1H6(38),[G1H6(4)])
  call ol_merge(ntryL,G1H3(39),[G1H3(37)])
  call ol_merge(ntryL,G1H3(66),[G1H3(54),G1H3(1),G1H3(38)])
  call ol_merge(ntryL,G1H3(59),[G1H3(56),G1H3(11),G1H3(31)])
  call ol_merge(ntryL,G1H3(30),[G1H3(10)])
  call ol_merge(ntryL,G1H2(48),[G1H2(30)])
  call ol_merge(ntryL,G1H3(47),[G1H3(61),G1H3(17)])
  call ol_merge(ntryL,G1H2(51),[G1H2(39)])
  call ol_merge(ntryL,G1H2(56),[G1H2(40)])
  call ol_merge(ntryL,G1H3(65),[G1H3(36)])
  call ol_merge(ntryL,G1H2(55),[G1H2(50)])
  call ol_merge(ntryL,G1H6(17),[G1H6(50)])
  call ol_merge(ntryL,G1H6(44),[G1H6(43)])
  call ol_merge(ntryL,G1H6(24),[G1H6(23)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex2(:),G2tensor(2),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(40),ex2(:),G2tensor(4),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hloop_QW_A(ntryL,G1H3(21),ex4(:),G1H1(1),m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(123))
  call Hloop_QV_A(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(124))
  call Hloop_QW_A(ntryL,G1H3(22),ex4(:),G1H1(1),m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(125))
  call Hloop_QV_A(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(126))
  call Hloop_AW_Q(ntryL,G1H3(26),ex4(:),G1H1(1),m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(127))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(4),wf4(:,2),G2tensor(14),m3h4x1(:,5),heltab2x4(:,:,28))
  call Hloop_QW_A(ntryL,G1H3(27),ex4(:),G1H1(1),m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(128))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(5),wf4(:,6),G2tensor(18),m3h4x1(:,6),heltab2x4(:,:,29))
  call Hloop_AV_Q(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(129))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(2),wf6(:,4),G2tensor(27),m3h6x1(:,17),heltab2x6(:,:,76))
  call Hloop_QV_A(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(130))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(1),wf6(:,2),G2tensor(26),m3h6x1(:,18),heltab2x6(:,:,77))
  call Hloop_QW_A(ntryL,G1H6(38),wf6(:,6),G1H1(1),m3h6x1(:,19),heltab2x6(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(131))
  call Hloop_VA_Q(ntryL,G1H2(16),ex2(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(104),n2h1(132))
  call Hloop_VA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(110),n2h1(133))
  call Hloop_AW_Q(ntryL,G1H3(39),ex4(:),G1H1(1),m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(134))
  call Hloop_AW_Q(ntryL,G1H3(66),ex4(:),G1H1(1),m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(135))
  call Hloop_QV_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(136))
  call Hloop_QW_A(ntryL,G1H3(59),ex4(:),G1H1(1),m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(128),n2h1(137))
  call Hloop_VQ_A(ntryL,G1H2(17),ex1(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(138))
  call Hloop_VQ_A(ntryL,G1H2(18),ex1(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(134),n2h1(139))
  call Hloop_QW_A(ntryL,G1H3(30),ex4(:),G1H1(1),m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(140))
  call Hloop_QV_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(125),n2h1(141))
  call Hloop_AV_Q(ntryL,G1H2(35),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(142))
  call Hloop_AW_Q(ntryL,G1H3(47),ex4(:),G1H1(1),m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(143))
  call Hloop_AV_Q(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(144))
  call Hloop_AV_Q(ntryL,G1H2(56),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(145))
  call Hloop_AW_Q(ntryL,G1H3(65),ex4(:),G1H1(1),m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(146))
  call Hloop_AV_Q(ntryL,G1H2(55),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(147))
  call Hloop_VQ_A(ntryL,G1H6(45),wf6(:,4),G1H1(1),m3h6x1(:,20),heltab2x6(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(148))
  call Hloop_VQ_A(ntryL,G1H6(17),wf6(:,4),G1H1(1),m3h6x1(:,21),heltab2x6(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(149))
  call Hloop_VA_Q(ntryL,G1H6(54),wf6(:,2),G1H1(1),m3h6x1(:,22),heltab2x6(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(150))
  call Hloop_VA_Q(ntryL,G1H6(44),wf6(:,2),G1H1(1),m3h6x1(:,23),heltab2x6(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(50),n2h1(151))
  call Hloop_AW_Q(ntryL,G1H6(24),wf6(:,6),G1H1(1),m3h6x1(:,24),heltab2x6(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(152))
  call Hloop_AW_Q(ntryL,G1H6(9),wf6(:,6),G1H1(1),m3h6x1(:,25),heltab2x6(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(101),n2h1(153))
  call Hloop_QW_A(ntryL,G1H6(41),wf6(:,6),G1H1(1),m3h6x1(:,26),heltab2x6(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(74),n2h1(154))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(116),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(68),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(3),wf4(:,2),G2tensor(107),m3h4x1(:,7),heltab2x4(:,:,30))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(2),wf4(:,6),G2tensor(122),m3h4x1(:,8),heltab2x4(:,:,31))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(9),wf6(:,4),G2tensor(80),m3h6x1(:,27),heltab2x6(:,:,86))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(10),wf6(:,2),G2tensor(113),m3h6x1(:,28),heltab2x6(:,:,87))
  call Hloop_VQ_A(ntryL,G1H12(10),wf12(:,17),G1H1(1),m3h12x1(:,1),heltab2x12(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(86),n2h1(155))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(1),wf12(:,17),G2tensor(119),m3h12x1(:,2),heltab2x12(:,:,61))
  call Hloop_VA_Q(ntryL,G1H12(5),wf12(:,20),G1H1(1),m3h12x1(:,3),heltab2x12(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(156))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(2),wf12(:,20),G2tensor(51),m3h12x1(:,4),heltab2x12(:,:,63))
  call Hloop_QV_A(ntryL,G2H12(3),wf12(:,29),G2H1(1),m3h12x1(:,5),heltab2x12(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(1),n2h1(157))
  call Hloop_QV_A(ntryL,G2H12(4),wf12(:,29),G2H1(1),m3h12x1(:,6),heltab2x12(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(2),n2h1(158))
  call Hloop_AV_Q(ntryL,G2H12(5),wf12(:,29),G2H1(1),m3h12x1(:,7),heltab2x12(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(3),n2h1(159))
  call Hloop_AV_Q(ntryL,G2H12(6),wf12(:,29),G2H1(1),m3h12x1(:,8),heltab2x12(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(4),n2h1(160))
  call Hloop_QV_A(ntryL,G2H12(7),wf12(:,29),G2H1(1),m3h12x1(:,9),heltab2x12(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(5),n2h1(161))
  call Hloop_AV_Q(ntryL,G2H12(8),wf12(:,29),G2H1(1),m3h12x1(:,10),heltab2x12(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(6),n2h1(162))
  call Hloop_VQ_A(ntryL,G1H12(8),wf12(:,22),G1H1(1),m3h12x1(:,11),heltab2x12(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(163))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(9),wf12(:,22),G2tensor(137),m3h12x1(:,12),heltab2x12(:,:,71))
  call Hloop_QV_A(ntryL,G2H12(10),wf12(:,30),G2H1(1),m3h12x1(:,13),heltab2x12(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(7),n2h1(164))
  call Hloop_QV_A(ntryL,G2H12(11),wf12(:,30),G2H1(1),m3h12x1(:,14),heltab2x12(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(8),n2h1(165))
  call Hloop_AV_Q(ntryL,G2H12(12),wf12(:,30),G2H1(1),m3h12x1(:,15),heltab2x12(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(9),n2h1(166))
  call Hloop_AV_Q(ntryL,G2H12(13),wf12(:,30),G2H1(1),m3h12x1(:,16),heltab2x12(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(10),n2h1(167))
  call Hloop_QV_A(ntryL,G2H12(14),wf12(:,30),G2H1(1),m3h12x1(:,17),heltab2x12(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(11),n2h1(168))
  call Hloop_AV_Q(ntryL,G2H12(15),wf12(:,30),G2H1(1),m3h12x1(:,18),heltab2x12(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(12),n2h1(169))
  call Hloop_VA_Q(ntryL,G1H12(17),wf12(:,24),G1H1(1),m3h12x1(:,19),heltab2x12(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(138),n2h1(170))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(16),wf12(:,24),G2tensor(139),m3h12x1(:,20),heltab2x12(:,:,79))
  call Hloop_VQ_A(ntryL,G1H12(7),wf12(:,28),G1H1(1),m3h12x1(:,21),heltab2x12(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(140),n2h1(171))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(17),wf12(:,28),G2tensor(141),m3h12x1(:,22),heltab2x12(:,:,81))
  call Hloop_VA_Q(ntryL,G1H12(3),wf12(:,26),G1H1(1),m3h12x1(:,23),heltab2x12(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(142),n2h1(172))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(18),wf12(:,26),G2tensor(143),m3h12x1(:,24),heltab2x12(:,:,83))
  call ol_merge_tensors(G2tensor(129),[G2tensor(60),G2tensor(8),G1tensor(30),G1tensor(18),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(135),G2tensor(78),G2tensor(66),G2tensor(20),G2tensor(12),G1tensor(46),G1tensor(9) &
    ,G1tensor(3),G1tensor(42),G0tensor(42),G0tensor(33),G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(126),G2tensor(72),G2tensor(16),G1tensor(93),G1tensor(88),G1tensor(17),G1tensor(8) &
    ,G0tensor(93),G0tensor(88),G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(132),G2tensor(90),G2tensor(84),G2tensor(28),G2tensor(24),G1tensor(57),G1tensor(52) &
    ,G1tensor(45),G1tensor(20),G0tensor(57),G0tensor(52),G0tensor(47),G0tensor(13)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(100),G2tensor(97),G2tensor(13),G2tensor(3),G1tensor(85),G1tensor(77),G1tensor(65) &
    ,G1tensor(4),G0tensor(85),G0tensor(77),G0tensor(65),G0tensor(28)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(142),G2tensor(139),G2tensor(138),G2tensor(51),G2tensor(92),G2tensor(133) &
    ,G2tensor(94),G2tensor(88),G2tensor(58),G2tensor(54),G2tensor(42),G2tensor(39),G2tensor(5),G1tensor(150),G1tensor(140) &
    ,G1tensor(80),G1tensor(55),G1tensor(12),G1tensor(25),G0tensor(150),G0tensor(140),G0tensor(80),G0tensor(55),G0tensor(10) &
    ,G0tensor(5)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(96),G2tensor(9),G1tensor(62),G1tensor(44),G1tensor(7),G0tensor(62),G0tensor(23) &
    ,G0tensor(2)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(99),G2tensor(17),G1tensor(118),G1tensor(82),G1tensor(34),G1tensor(37),G0tensor(118) &
    ,G0tensor(82),G0tensor(43),G0tensor(7)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(93),G2tensor(91),G2tensor(21),G1tensor(147),G1tensor(60),G1tensor(32),G0tensor(147) &
    ,G0tensor(60),G0tensor(18)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(26),G2tensor(103),G2tensor(44),G2tensor(25),G1tensor(100),G1tensor(75),G1tensor(27) &
    ,G1tensor(19),G0tensor(100),G0tensor(75),G0tensor(19),G0tensor(4)])
  call ol_merge_tensors(G3tensor(9),[G3tensor(7),G3tensor(3),G3tensor(1),G2tensor(130),G2tensor(127),G2tensor(76),G2tensor(64) &
    ,G2tensor(34),G2tensor(29),G1tensor(105),G1tensor(23),G1tensor(38),G0tensor(105),G0tensor(40),G0tensor(20)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(101),G2tensor(124),G2tensor(118),G2tensor(112),G2tensor(106),G2tensor(41) &
    ,G2tensor(38),G2tensor(35),G2tensor(30),G1tensor(125),G1tensor(110),G1tensor(54),G1tensor(11),G0tensor(125),G0tensor(110) &
    ,G0tensor(54),G0tensor(29)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(140),G2tensor(137),G2tensor(55),G2tensor(119),G2tensor(86),G2tensor(136) &
    ,G2tensor(82),G2tensor(70),G2tensor(56),G2tensor(52),G2tensor(36),G2tensor(31),G1tensor(160),G1tensor(155),G1tensor(130) &
    ,G1tensor(115),G1tensor(5),G0tensor(160),G0tensor(155),G0tensor(130),G0tensor(115),G0tensor(30)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(81),G2tensor(79),G2tensor(32),G1tensor(127),G1tensor(39),G1tensor(40),G0tensor(127) &
    ,G0tensor(45),G0tensor(38)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(27),G2tensor(109),G2tensor(33),G1tensor(159),G1tensor(120),G1tensor(22) &
    ,G0tensor(159),G0tensor(120),G0tensor(39)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(121),G2tensor(115),G2tensor(40),G2tensor(37),G1tensor(145),G1tensor(135) &
    ,G1tensor(53),G0tensor(145),G0tensor(135),G0tensor(53)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(43),G1tensor(70),G1tensor(13),G0tensor(70),G0tensor(3)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(45),G1tensor(90),G1tensor(43),G0tensor(90),G0tensor(8)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(46),G1tensor(95),G1tensor(6),G0tensor(95),G0tensor(9)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(73),G2tensor(63),G2tensor(61),G1tensor(102),G1tensor(16),G1tensor(24),G0tensor(102) &
    ,G0tensor(35),G0tensor(15)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(67),G1tensor(112),G1tensor(21),G0tensor(112),G0tensor(25)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(85),G1tensor(137),G1tensor(50),G0tensor(137),G0tensor(50)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(102),G1tensor(97),G1tensor(36),G0tensor(97),G0tensor(14)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(59),G2tensor(117),G2tensor(105),G1tensor(107),G1tensor(49),G1tensor(15) &
    ,G0tensor(107),G0tensor(49),G0tensor(24)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(108),G1tensor(117),G1tensor(10),G0tensor(117),G0tensor(34)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(57),G2tensor(123),G2tensor(111),G1tensor(122),G1tensor(103),G1tensor(59) &
    ,G1tensor(35),G0tensor(122),G0tensor(103),G0tensor(59),G0tensor(44)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(114),G1tensor(157),G1tensor(132),G1tensor(47),G0tensor(157),G0tensor(132) &
    ,G0tensor(48)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(120),G1tensor(152),G1tensor(142),G1tensor(98),G1tensor(58),G0tensor(152) &
    ,G0tensor(142),G0tensor(98),G0tensor(58)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(10),G1tensor(133),G1tensor(108),G1tensor(67),G1tensor(63),G0tensor(133) &
    ,G0tensor(108),G0tensor(67),G0tensor(63)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(113),G1tensor(72),G1tensor(64),G0tensor(113),G0tensor(72),G0tensor(64)])
  call ol_merge_tensors(G2tensor(116),[G1tensor(73),G1tensor(68),G0tensor(73),G0tensor(68)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(89),G1tensor(78),G1tensor(69),G0tensor(89),G0tensor(78),G0tensor(69)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(94),G1tensor(79),G1tensor(74),G0tensor(94),G0tensor(79),G0tensor(74)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(19),G1tensor(143),G1tensor(123),G1tensor(87),G1tensor(83),G0tensor(143) &
    ,G0tensor(123),G0tensor(87),G0tensor(83)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(128),G1tensor(92),G1tensor(84),G0tensor(128),G0tensor(92),G0tensor(84)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(53),G1tensor(139),G1tensor(119),G1tensor(114),G1tensor(109),G1tensor(104) &
    ,G1tensor(99),G0tensor(139),G0tensor(119),G0tensor(114),G0tensor(109),G0tensor(104),G0tensor(99)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(125),G1tensor(149),G1tensor(129),G1tensor(124),G0tensor(149),G0tensor(129) &
    ,G0tensor(124)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(138),G1tensor(134),G0tensor(138),G0tensor(134)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(148),G1tensor(144),G0tensor(148),G0tensor(144)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(153),G0tensor(153)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(154),G0tensor(154)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(158),G0tensor(158)])
  call ol_merge_tensors(G3tensor(10),[G3tensor(8),G3tensor(4),G3tensor(2)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(11),G3tensor(6),G3tensor(5)])
call TI_triangle_red(G2tensor(129),RedBasis(60),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
call TI_triangle_red(G2tensor(65),RedBasis(57),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
call TI_triangle_red(G2tensor(68),RedBasis(9),mass3set(:,1),G0tensor(41),G0tensor(46),G0tensor(51),G0tensor(56),M2L1R1)
call TI_triangle_red(G2tensor(104),RedBasis(52),mass3set(:,1),G0tensor(61),G0tensor(66),G0tensor(71),G0tensor(76),M2L1R1)
call TI_triangle_red(G2tensor(62),RedBasis(17),mass3set(:,1),G0tensor(81),G0tensor(86),G0tensor(91),G0tensor(96),M2L1R1)
call TI_triangle_red(G2tensor(143),RedBasis(1),mass3set(:,1),G0tensor(101),G0tensor(106),G0tensor(111),G0tensor(116),M2L1R1)
call TI_triangle_red(G2tensor(23),RedBasis(55),mass3set(:,1),G0tensor(121),G0tensor(126),G0tensor(131),G0tensor(136),M2L1R1)
call TI_triangle_red(G2tensor(15),RedBasis(22),mass3set(:,1),G0tensor(141),G0tensor(146),G0tensor(151),G0tensor(156),M2L1R1)
call TI_triangle_red(G2tensor(98),RedBasis(12),mass3set(:,1),G0tensor(17),G0tensor(12),G0tensor(42),G0tensor(33),M2L1R1)
call TI_triangle_red(G2tensor(50),RedBasis(2),mass3set(:,1),G0tensor(27),G0tensor(22),G0tensor(93),G0tensor(88),M2L1R1)
call TI_triangle_red(G3tensor(9),RedBasis(10),mass3set(:,1),G0tensor(37),G0tensor(32),G0tensor(57),G0tensor(52),M2L1R1)
call TI_triangle_red(G2tensor(74),RedBasis(16),mass3set(:,1),G0tensor(47),G0tensor(13),G0tensor(85),G0tensor(77),M2L1R1)
call TI_triangle_red(G2tensor(141),RedBasis(15),mass3set(:,1),G0tensor(65),G0tensor(28),G0tensor(150),G0tensor(140),M2L1R1)
call TI_triangle_red(G2tensor(47),RedBasis(21),mass3set(:,1),G0tensor(80),G0tensor(55),G0tensor(10),G0tensor(5),M2L1R1)
call TI_triangle_red(G2tensor(1),RedBasis(20),mass3set(:,1),G0tensor(62),G0tensor(23),G0tensor(2),G0tensor(118),M2L1R1)
call TI_triangle_red(G2tensor(48),RedBasis(26),mass3set(:,1),G0tensor(82),G0tensor(43),G0tensor(7),G0tensor(147),M2L1R1)
call TI_triangle_red(G2tensor(113),RedBasis(4),mass3set(:,1),G0tensor(60),G0tensor(18),G0tensor(100),G0tensor(75),M2L1R1)
call TI_triangle_red(G2tensor(122),RedBasis(8),mass3set(:,1),G0tensor(19),G0tensor(4),G0tensor(105),G0tensor(40),M2L1R1)
call TI_triangle_red(G2tensor(18),RedBasis(7),mass3set(:,1),G0tensor(20),G0tensor(125),G0tensor(110),G0tensor(54),M2L1R1)
call TI_triangle_red(G2tensor(75),RedBasis(50),mass3set(:,1),G0tensor(29),G0tensor(160),G0tensor(155),G0tensor(130),M2L1R1)
call TI_triangle_red(G2tensor(69),RedBasis(53),mass3set(:,1),G0tensor(115),G0tensor(30),G0tensor(127),G0tensor(45),M2L1R1)
call TI_triangle_red(G2tensor(87),RedBasis(58),mass3set(:,1),G0tensor(38),G0tensor(159),G0tensor(120),G0tensor(39),M2L1R1)
call TI_triangle_red(G2tensor(110),RedBasis(51),mass3set(:,1),G0tensor(145),G0tensor(135),G0tensor(53),G0tensor(70),M2L1R1)
call TI_triangle_red(G2tensor(77),RedBasis(54),mass3set(:,1),G0tensor(3),G0tensor(90),G0tensor(8),G0tensor(95),M2L1R1)
call TI_triangle_red(G2tensor(134),RedBasis(56),mass3set(:,1),G0tensor(9),G0tensor(102),G0tensor(35),G0tensor(15),M2L1R1)
call TI_triangle_red(G2tensor(71),RedBasis(13),mass3set(:,1),G0tensor(112),G0tensor(25),G0tensor(137),G0tensor(50),M2L1R1)
call TI_triangle_red(G2tensor(22),RedBasis(59),mass3set(:,1),G0tensor(97),G0tensor(14),G0tensor(107),G0tensor(49),M2L1R1)
call TI_triangle_red(G2tensor(11),RedBasis(14),mass3set(:,1),G0tensor(24),G0tensor(117),G0tensor(34),G0tensor(122),M2L1R1)
call TI_triangle_red(G2tensor(95),RedBasis(19),mass3set(:,1),G0tensor(103),G0tensor(59),G0tensor(44),G0tensor(157),M2L1R1)
call TI_triangle_red(G2tensor(6),RedBasis(18),mass3set(:,1),G0tensor(132),G0tensor(48),G0tensor(152),G0tensor(142),M2L1R1)
call TI_triangle_red(G2tensor(116),RedBasis(6),mass3set(:,1),G0tensor(98),G0tensor(58),G0tensor(133),G0tensor(108),M2L1R1)
call TI_triangle_red(G2tensor(2),RedBasis(5),mass3set(:,1),G0tensor(67),G0tensor(63),G0tensor(113),G0tensor(72),M2L1R1)
call TI_triangle_red(G2tensor(4),RedBasis(3),mass3set(:,1),G0tensor(64),G0tensor(73),G0tensor(68),G0tensor(89),M2L1R1)
call TI_triangle_red(G2tensor(49),RedBasis(25),mass3set(:,1),G0tensor(78),G0tensor(69),G0tensor(94),G0tensor(79),M2L1R1)
call TI_triangle_red(G2tensor(7),RedBasis(24),mass3set(:,1),G0tensor(74),G0tensor(143),G0tensor(123),G0tensor(87),M2L1R1)
call TI_triangle_red(G2tensor(128),RedBasis(11),mass3set(:,1),G0tensor(83),G0tensor(128),G0tensor(92),G0tensor(84),M2L1R1)
call TI_triangle_red(G2tensor(89),RedBasis(23),mass3set(:,1),G0tensor(139),G0tensor(119),G0tensor(114),G0tensor(109),M2L1R1)
call TI_triangle_red(G2tensor(83),RedBasis(27),mass3set(:,1),G0tensor(104),G0tensor(99),G0tensor(149),G0tensor(129),M2L1R1)
call TI_triangle_red(G2tensor(131),RedBasis(28),mass3set(:,1),G0tensor(124),G0tensor(138),G0tensor(134),G0tensor(148),M2L1R1)
call TI_triangle_red(G2tensor(107),RedBasis(48),mass3set(:,1),G0tensor(144),G0tensor(153),G0tensor(154),G0tensor(158),M2L1R1)
call TI_triangle_red(G2tensor(14),RedBasis(47),mass3set(:,1),G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),M2L1R1)
call TI_triangle_red(G2tensor(80),RedBasis(49),mass3set(:,1),G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168),M2L1R1)
call TI_triangle_red(G3tensor(10),RedBasis(10),mass3set(:,2),G0tensor(169),G0tensor(170),G0tensor(171),G0tensor(172),M2L1R1,[nMT], &
    G0tensor(173))
call TI_triangle_red(G3tensor(12),RedBasis(10),mass3set(:,3),G0tensor(174),G0tensor(175),G0tensor(176),G0tensor(177),M2L1R1,[nMB], &
    G0tensor(178))
call ol_merge_tensors(T0sum(33),[G0tensor(1)])
call ol_merge_tensors(T0sum(34),[G0tensor(21)])
call ol_merge_tensors(T0sum(35),[G0tensor(41)])
call ol_merge_tensors(T0sum(36),[G0tensor(61)])
call ol_merge_tensors(T0sum(37),[G0tensor(81)])
call ol_merge_tensors(T0sum(38),[G0tensor(101)])
call ol_merge_tensors(T0sum(39),[G0tensor(121)])
call ol_merge_tensors(T0sum(40),[G0tensor(141)])
call ol_merge_tensors(T0sum(41),[G0tensor(17)])
call ol_merge_tensors(T0sum(42),[G0tensor(27)])
call ol_merge_tensors(T0sum(43),[G0tensor(37)])
call ol_merge_tensors(T0sum(44),[G0tensor(47)])
call ol_merge_tensors(T0sum(45),[G0tensor(65)])
call ol_merge_tensors(T0sum(46),[G0tensor(80)])
call ol_merge_tensors(T0sum(47),[G0tensor(62)])
call ol_merge_tensors(T0sum(48),[G0tensor(82)])
call ol_merge_tensors(T0sum(49),[G0tensor(60)])
call ol_merge_tensors(T0sum(50),[G0tensor(19)])
call ol_merge_tensors(T0sum(51),[G0tensor(20)])
call ol_merge_tensors(T0sum(52),[G0tensor(29)])
call ol_merge_tensors(T0sum(53),[G0tensor(115)])
call ol_merge_tensors(T0sum(54),[G0tensor(38)])
call ol_merge_tensors(T0sum(55),[G0tensor(145)])
call ol_merge_tensors(T0sum(56),[G0tensor(3)])
call ol_merge_tensors(T0sum(57),[G0tensor(9)])
call ol_merge_tensors(T0sum(58),[G0tensor(112)])
call ol_merge_tensors(T0sum(59),[G0tensor(97)])
call ol_merge_tensors(T0sum(60),[G0tensor(24)])
call ol_merge_tensors(T0sum(61),[G0tensor(103)])
call ol_merge_tensors(T0sum(62),[G0tensor(132)])
call ol_merge_tensors(T0sum(63),[G0tensor(98)])
call ol_merge_tensors(T0sum(64),[G0tensor(67)])
call ol_merge_tensors(T0sum(65),[G0tensor(64)])
call ol_merge_tensors(T0sum(66),[G0tensor(78)])
call ol_merge_tensors(T0sum(67),[G0tensor(74)])
call ol_merge_tensors(T0sum(68),[G0tensor(83)])
call ol_merge_tensors(T0sum(69),[G0tensor(139)])
call ol_merge_tensors(T0sum(70),[G0tensor(104)])
call ol_merge_tensors(T0sum(71),[G0tensor(124)])
call ol_merge_tensors(T0sum(72),[G0tensor(144)])
call ol_merge_tensors(T0sum(73),[G0tensor(161)])
call ol_merge_tensors(T0sum(74),[G0tensor(165)])
call ol_merge_tensors(T0sum(75),[G0tensor(169)])
call ol_merge_tensors(T0sum(76),[G0tensor(174)])
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(74),h0tab(:,74),[21,10],[0,0],2,2,wf8(:,13),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf8(:,13),G0H6(3),m3h8x6(:,5),heltab2x48(:,:,74))
  call Hloop_Q_A(ntryL,G0H6(3),21,0,G1H6(30),n2h6(39))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(75),h0tab(:,75),[26,5],[0,0],2,2,wf12(:,14),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,14),G0H4(1),m3h12x4(:,5),heltab2x48(:,:,75))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(7),n2h4(19))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(76),h0tab(:,76),[18,13],[0,0],2,2,wf4(:,4),wf12(:,17))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(1),m3h4x12(:,11),heltab2x48(:,:,76))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(77),h0tab(:,77),[26,5],[0,0],2,2,wf12(:,16),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,16),G0H4(2),m3h12x4(:,6),heltab2x48(:,:,77))
  call Hloop_A_Q(ntryL,G0H4(2),26,0,G1H4(12),n2h4(20))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(78),h0tab(:,78),[25,6],[0,0],2,2,wf12(:,18),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,18),G0H4(3),m3h12x4(:,7),heltab2x48(:,:,78))
  call Hloop_Q_A(ntryL,G0H4(3),25,0,G1H4(8),n2h4(21))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(29)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(79),h0tab(:,79),[22,9],[0,0],2,2,wf8(:,15),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf8(:,15),G0H6(4),m3h8x6(:,6),heltab2x48(:,:,79))
  call Hloop_A_Q(ntryL,G0H6(4),22,0,G1H6(7),n2h6(40))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(37)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(80),h0tab(:,80),[25,6],[0,0],2,2,wf12(:,21),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,21),G0H4(4),m3h12x4(:,8),heltab2x48(:,:,80))
  call Hloop_Q_A(ntryL,G0H4(4),25,0,G1H4(11),n2h4(22))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(81),h0tab(:,81),[17,14],[0,0],2,2,wf4(:,8),wf12(:,20))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(2),m3h4x12(:,12),heltab2x48(:,:,81))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(41)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(82),h0tab(:,82),[18,13],[0,0],2,2,wf4(:,4),wf12(:,22))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(3),m3h4x12(:,13),heltab2x48(:,:,82))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(39)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(83),h0tab(:,83),[22,9],[0,0],2,2,wf8(:,17),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf8(:,17),G0H6(1),m3h8x6(:,7),heltab2x48(:,:,83))
  call Hloop_A_Q(ntryL,G0H6(1),22,0,G1H6(36),n2h6(41))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(84),h0tab(:,84),[21,10],[0,0],2,2,wf8(:,18),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf8(:,18),G0H6(2),m3h8x6(:,8),heltab2x48(:,:,84))
  call Hloop_Q_A(ntryL,G0H6(2),21,0,G1H6(47),n2h6(42))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(43)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(85),h0tab(:,85),[17,14],[0,0],2,2,wf4(:,8),wf12(:,24))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(4),m3h4x12(:,14),heltab2x48(:,:,85))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(47)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(86),h0tab(:,86),[17,14],[0,0],2,2,wf4(:,8),wf12(:,26))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(5),m3h4x12(:,15),heltab2x48(:,:,86))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(49)
call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(87),h0tab(:,87),[18,13],[0,0],2,2,wf4(:,4),wf12(:,28))
  call Hloop_VA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(6),m3h4x12(:,16),heltab2x48(:,:,87))
  call Hloop_A_Q(ntryL,G0H12(6),18,0,G1H12(9),n2h12(39))
  call ol_merge(ntryL,G1H6(47),[G1H6(30)])
  call ol_merge(ntryL,G1H4(12),[G1H4(7)])
  call ol_merge(ntryL,G1H4(11),[G1H4(8)])
  call ol_merge(ntryL,G1H6(36),[G1H6(7)])
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(47),wf6(:,2),G1tensor(1),m3h6x1(:,29),heltab2x6(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(12),wf4(:,2),G1tensor(31),m3h4x1(:,9),heltab2x4(:,:,32))
  call Hloop_VQ_A(ntryL,G0H12(1),wf12(:,17),G0H1(1),m3h12x1(:,25),heltab2x12(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(14),n2h1(173))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(11),wf4(:,6),G1tensor(26),m3h4x1(:,10),heltab2x4(:,:,33))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(36),wf6(:,4),G1tensor(48),m3h6x1(:,30),heltab2x6(:,:,89))
  call Hloop_VA_Q(ntryL,G0H12(2),wf12(:,20),G0H1(1),m3h12x1(:,26),heltab2x12(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(2),n2h1(174))
  call Hloop_VQ_A(ntryL,G0H12(3),wf12(:,22),G0H1(1),m3h12x1(:,27),heltab2x12(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(33),n2h1(175))
  call Hloop_VA_Q(ntryL,G0H12(4),wf12(:,24),G0H1(1),m3h12x1(:,28),heltab2x12(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(29),n2h1(176))
  call Hloop_VA_Q(ntryL,G0H12(5),wf12(:,26),G0H1(1),m3h12x1(:,29),heltab2x12(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(28),n2h1(177))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H12(9),wf12(:,28),G1tensor(41),m3h12x1(:,30),heltab2x12(:,:,89))
  call ol_merge_tensors(G0tensor(166),[G0tensor(134),G0tensor(114),G0tensor(123),G0tensor(94),G0tensor(59),G0tensor(107) &
    ,G0tensor(8),G0tensor(160),G0tensor(18),G0tensor(32),G0tensor(131),G0tensor(46),G0tensor(6)])
  call ol_merge_tensors(G0tensor(35),[G0tensor(159),G0tensor(12),G0tensor(146),G0tensor(126),G0tensor(106),G0tensor(86) &
    ,G0tensor(66),G0tensor(31),G0tensor(11)])
  call ol_merge_tensors(G1tensor(31),[G0tensor(163),G0tensor(154),G0tensor(48),G0tensor(135),G0tensor(127),G0tensor(22) &
    ,G0tensor(136),G0tensor(16)])
  call ol_merge_tensors(G0tensor(68),[G0tensor(113),G0tensor(133),G0tensor(117),G0tensor(14),G0tensor(53),G0tensor(30) &
    ,G0tensor(43),G0tensor(55),G0tensor(28),G0tensor(71),G0tensor(51),G0tensor(26)])
  call ol_merge_tensors(G0tensor(25),[G0tensor(90),G0tensor(155),G0tensor(13),G0tensor(76),G0tensor(36)])
  call ol_merge_tensors(G1tensor(26),[G0tensor(99),G0tensor(49),G0tensor(102),G0tensor(120),G0tensor(110),G0tensor(105) &
    ,G0tensor(23),G0tensor(56)])
  call ol_merge_tensors(G0tensor(79),[G0tensor(63),G0tensor(157),G0tensor(7),G0tensor(85),G0tensor(91)])
  call ol_merge_tensors(G1tensor(41),[G1tensor(33),G1tensor(14),G0tensor(168),G0tensor(158),G0tensor(87),G0tensor(73) &
    ,G0tensor(142),G0tensor(150),G0tensor(96)])
  call ol_merge_tensors(G1tensor(28),[G1tensor(29),G1tensor(2),G0tensor(148),G0tensor(129),G0tensor(72),G0tensor(40),G0tensor(75) &
    ,G0tensor(147),G0tensor(111)])
  call ol_merge_tensors(G0tensor(164),[G0tensor(109),G0tensor(84),G0tensor(89),G0tensor(54),G0tensor(118),G0tensor(140) &
    ,G0tensor(77),G0tensor(52),G0tensor(88),G0tensor(116)])
  call ol_merge_tensors(G0tensor(153),[G0tensor(149),G0tensor(92),G0tensor(69),G0tensor(58),G0tensor(152),G0tensor(44) &
    ,G0tensor(34),G0tensor(137),G0tensor(4),G0tensor(151)])
  call ol_merge_tensors(G1tensor(48),[G0tensor(167),G0tensor(143),G0tensor(125),G0tensor(2),G0tensor(10),G0tensor(156)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(162),G0tensor(138),G0tensor(108),G0tensor(122),G0tensor(100),G0tensor(93) &
    ,G0tensor(42)])
  call ol_merge_tensors(G0tensor(119),[G0tensor(50),G0tensor(5),G0tensor(57),G0tensor(33)])
  call ol_merge_tensors(G0tensor(128),[G0tensor(15),G0tensor(95),G0tensor(70),G0tensor(39),G0tensor(45),G0tensor(130)])
call TI_bubble_red(G1tensor(31),26,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(26),25,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G1tensor(41),18,mass2set(:,1),G0tensor(41),M2L1R1)
call TI_bubble_red(G1tensor(28),17,mass2set(:,1),G0tensor(61),M2L1R1)
call TI_bubble_red(G1tensor(48),22,mass2set(:,1),G0tensor(81),M2L1R1)
call TI_bubble_red(G1tensor(1),21,mass2set(:,1),G0tensor(101),M2L1R1)
call ol_merge_tensors(T0sum(77),[G0tensor(166)])
call ol_merge_tensors(T0sum(78),[G0tensor(35)])
call ol_merge_tensors(T0sum(79),[G0tensor(1)])
call ol_merge_tensors(T0sum(80),[G0tensor(68)])
call ol_merge_tensors(T0sum(81),[G0tensor(25)])
call ol_merge_tensors(T0sum(82),[G0tensor(21)])
call ol_merge_tensors(T0sum(83),[G0tensor(79)])
call ol_merge_tensors(T0sum(84),[G0tensor(41)])
call ol_merge_tensors(T0sum(85),[G0tensor(61)])
call ol_merge_tensors(T0sum(86),[G0tensor(164)])
call ol_merge_tensors(T0sum(87),[G0tensor(153)])
call ol_merge_tensors(T0sum(88),[G0tensor(81)])
call ol_merge_tensors(T0sum(89),[G0tensor(101)])
call ol_merge_tensors(T0sum(90),[G0tensor(119)])
call ol_merge_tensors(T0sum(91),[G0tensor(128)])
call ol_merge_tensors(T0sum(92),[G0tensor(170)])
call ol_merge_tensors(T0sum(93),[G0tensor(171)])
call ol_merge_tensors(T0sum(94),[G0tensor(172)])
call ol_merge_tensors(T0sum(95),[G0tensor(173)])
call ol_merge_tensors(T0sum(96),[G0tensor(175)])
call ol_merge_tensors(T0sum(97),[G0tensor(176)])
call ol_merge_tensors(T0sum(98),[G0tensor(177)])
call ol_merge_tensors(T0sum(99),[G0tensor(178)])


! Compute scalar Master integrals 

call compute_scalar_box([ 17, 21, 29 ],masses2_9,RedSet_4(8),ScalarBoxes(1))
call compute_scalar_box([ 16, 21, 29 ],masses2_9,RedSet_4(9),ScalarBoxes(2))
call compute_scalar_box([ 16, 17, 29 ],masses2_9,RedSet_4(1),ScalarBoxes(3))
call compute_scalar_box([ 16, 17, 21 ],masses2_9,RedSet_4(2),ScalarBoxes(4))
call compute_scalar_box([ 1, 5, 13 ],masses2_9,RedSet_4(10),ScalarBoxes(5))
call compute_scalar_box([ 17, 25, 29 ],masses2_9,RedSet_4(11),ScalarBoxes(6))
call compute_scalar_box([ 16, 25, 29 ],masses2_9,RedSet_4(12),ScalarBoxes(7))
call compute_scalar_box([ 16, 17, 25 ],masses2_9,RedSet_4(3),ScalarBoxes(8))
call compute_scalar_box([ 1, 9, 13 ],masses2_9,RedSet_4(13),ScalarBoxes(9))
call compute_scalar_box([ 20, 21, 23 ],masses2_9,RedSet_4(14),ScalarBoxes(10))
call compute_scalar_box([ 16, 21, 23 ],masses2_9,RedSet_4(15),ScalarBoxes(11))
call compute_scalar_box([ 16, 20, 23 ],masses2_9,RedSet_4(16),ScalarBoxes(12))
call compute_scalar_box([ 16, 20, 21 ],masses2_9,RedSet_4(4),ScalarBoxes(13))
call compute_scalar_box([ 4, 5, 7 ],masses2_9,RedSet_4(17),ScalarBoxes(14))
call compute_scalar_box([ 18, 19, 23 ],masses2_9,RedSet_4(18),ScalarBoxes(15))
call compute_scalar_box([ 16, 19, 23 ],masses2_9,RedSet_4(19),ScalarBoxes(16))
call compute_scalar_box([ 16, 18, 23 ],masses2_9,RedSet_4(20),ScalarBoxes(17))
call compute_scalar_box([ 16, 18, 19 ],masses2_9,RedSet_4(5),ScalarBoxes(18))
call compute_scalar_box([ 2, 3, 7 ],masses2_9,RedSet_4(21),ScalarBoxes(19))
call compute_scalar_box([ 20, 22, 23 ],masses2_9,RedSet_4(22),ScalarBoxes(20))
call compute_scalar_box([ 16, 22, 23 ],masses2_9,RedSet_4(23),ScalarBoxes(21))
call compute_scalar_box([ 16, 20, 22 ],masses2_9,RedSet_4(6),ScalarBoxes(22))
call compute_scalar_box([ 4, 6, 7 ],masses2_9,RedSet_4(24),ScalarBoxes(23))
call compute_scalar_box([ 18, 19, 27 ],masses2_9,RedSet_4(25),ScalarBoxes(24))
call compute_scalar_box([ 16, 19, 27 ],masses2_9,RedSet_4(26),ScalarBoxes(25))
call compute_scalar_box([ 16, 18, 27 ],masses2_9,RedSet_4(27),ScalarBoxes(26))
call compute_scalar_box([ 2, 3, 11 ],masses2_9,RedSet_4(28),ScalarBoxes(27))
call compute_scalar_box([ 17, 19, 23 ],masses2_9,RedSet_4(29),ScalarBoxes(28))
call compute_scalar_box([ 16, 17, 23 ],masses2_9,RedSet_4(30),ScalarBoxes(29))
call compute_scalar_box([ 16, 17, 19 ],masses2_9,RedSet_4(7),ScalarBoxes(30))
call compute_scalar_box([ 1, 3, 7 ],masses2_9,RedSet_4(31),ScalarBoxes(31))
call compute_scalar_box([ 17, 19, 27 ],masses2_9,RedSet_4(32),ScalarBoxes(32))
call compute_scalar_box([ 16, 17, 27 ],masses2_9,RedSet_4(33),ScalarBoxes(33))
call compute_scalar_box([ 1, 3, 11 ],masses2_9,RedSet_4(34),ScalarBoxes(34))
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppwaj_udxawg_1_/**/REALKIND
