
module ol_vamp_1_ppvvv_ew_bbxazz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv_ew_bbxazz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv_ew_bbxazz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvv_ew_bbxazz_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvv_ew_bbxazz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvv_ew_bbxazz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvv_ew_bbxazz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMB,nMH,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZd,m3h3x24(:,1),heltab2x72(:,:,1))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(1),n2h24(1))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZd,m3h3x24(:,2),heltab2x72(:,:,2))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(2),n2h24(2))
  Gcoeff(:)%j = (c(112)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZu,m3h3x24(:,3),heltab2x72(:,:,3))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(3),n2h24(3))
  Gcoeff(:)%j = (-(c(168)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(4),m3h3x24(:,4),heltab2x72(:,:,4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZd,m3h3x24(:,5),heltab2x72(:,:,5))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(5),n2h24(4))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZd,m3h3x24(:,6),heltab2x72(:,:,6))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(6),n2h24(5))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZu,m3h3x24(:,7),heltab2x72(:,:,7))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(7),n2h24(6))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZd,m3h3x24(:,8),heltab2x72(:,:,8))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(8),n2h24(7))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,9),heltab2x72(:,:,9))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(10),h0tab(:,10),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(2),m3h3x24(:,10),heltab2x72(:,:,10))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(11),h0tab(:,11),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(9),m3h3x24(:,11),heltab2x72(:,:,11))
  Gcoeff(:)%j = (c(153)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(12),h0tab(:,12),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(10),m3h3x24(:,12),heltab2x72(:,:,12))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(13),h0tab(:,13),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(11),m3h3x24(:,13),heltab2x72(:,:,13))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(14),h0tab(:,14),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(3),m3h3x24(:,14),heltab2x72(:,:,14))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(15),h0tab(:,15),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(4),m3h3x24(:,15),heltab2x72(:,:,15))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(16),h0tab(:,16),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(5),m3h3x24(:,16),heltab2x72(:,:,16))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(17),h0tab(:,17),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(6),m3h3x24(:,17),heltab2x72(:,:,17))
  Gcoeff(:)%j = (c(177)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(18),h0tab(:,18),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(12),m3h3x24(:,18),heltab2x72(:,:,18))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(19),h0tab(:,19),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(13),m3h3x24(:,19),heltab2x72(:,:,19))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(20),h0tab(:,20),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(14),m3h3x24(:,20),heltab2x72(:,:,20))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(21),h0tab(:,21),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(7),m3h3x24(:,21),heltab2x72(:,:,21))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(22),h0tab(:,22),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(8),m3h3x24(:,22),heltab2x72(:,:,22))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(23),h0tab(:,23),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(15),m3h3x24(:,23),heltab2x72(:,:,23))
  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(24),h0tab(:,24),[16,2,1,4,8],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(9),ngZd,m3h3x24(:,24),heltab2x72(:,:,24))
  call Hloop_Q_A(ntryL,G0H24(9),16,nMB,G1H24(16),n2h24(8))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(25),h0tab(:,25),[16,2,1,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(9),ngZd,m3h3x24(:,25),heltab2x72(:,:,25))
  call Hloop_Q_A(ntryL,G0H24(9),16,nMB,G1H24(17),n2h24(9))
  Gcoeff(:)%j = (c(112)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(26),h0tab(:,26),[16,2,1,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(9),ngZu,m3h3x24(:,26),heltab2x72(:,:,26))
  call Hloop_Q_A(ntryL,G0H24(9),16,nMT,G1H24(18),n2h24(10))
  Gcoeff(:)%j = (-(c(168)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(27),h0tab(:,27),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(19),m3h3x24(:,27),heltab2x72(:,:,27))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(28),h0tab(:,28),[16,2,1,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(9),ngZd,m3h3x24(:,28),heltab2x72(:,:,28))
  call Hloop_Q_A(ntryL,G0H24(9),16,nMB,G1H24(20),n2h24(11))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(29),h0tab(:,29),[16,2,1,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(9),ngZd,m3h3x24(:,29),heltab2x72(:,:,29))
  call Hloop_Q_A(ntryL,G0H24(9),16,nMB,G1H24(21),n2h24(12))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(30),h0tab(:,30),[16,2,1,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(9),ngZu,m3h3x24(:,30),heltab2x72(:,:,30))
  call Hloop_Q_A(ntryL,G0H24(9),16,nMT,G1H24(22),n2h24(13))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(31),h0tab(:,31),[16,2,1,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(9),ngZd,m3h3x24(:,31),heltab2x72(:,:,31))
  call Hloop_Q_A(ntryL,G0H24(9),16,nMB,G1H24(23),n2h24(14))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(32),h0tab(:,32),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(9),m3h3x24(:,32),heltab2x72(:,:,32))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(33),h0tab(:,33),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(24),m3h3x24(:,33),heltab2x72(:,:,33))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(34),h0tab(:,34),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(10),m3h3x24(:,34),heltab2x72(:,:,34))
  Gcoeff(:)%j = (c(153)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(35),h0tab(:,35),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(25),m3h3x24(:,35),heltab2x72(:,:,35))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(36),h0tab(:,36),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(11),m3h3x24(:,36),heltab2x72(:,:,36))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(37),h0tab(:,37),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(26),m3h3x24(:,37),heltab2x72(:,:,37))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(38),h0tab(:,38),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(12),m3h3x24(:,38),heltab2x72(:,:,38))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(39),h0tab(:,39),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,39),heltab2x72(:,:,39))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(40),h0tab(:,40),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(27),m3h3x24(:,40),heltab2x72(:,:,40))
  Gcoeff(:)%j = (c(177)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(41),h0tab(:,41),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(14),m3h3x24(:,41),heltab2x72(:,:,41))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(42),h0tab(:,42),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(28),m3h3x24(:,42),heltab2x72(:,:,42))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(43),h0tab(:,43),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(15),m3h3x24(:,43),heltab2x72(:,:,43))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(44),h0tab(:,44),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(29),m3h3x24(:,44),heltab2x72(:,:,44))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(45),h0tab(:,45),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(16),m3h3x24(:,45),heltab2x72(:,:,45))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(46),h0tab(:,46),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(30),m3h3x24(:,46),heltab2x72(:,:,46))
  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(47),h0tab(:,47),[16,4,2,1,8],[nMB,nMB,nMH,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(17),ngZd,m3h3x24(:,47),heltab2x72(:,:,47))
  call Hloop_Q_A(ntryL,G0H24(17),16,nMB,G1H24(31),n2h24(15))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(48),h0tab(:,48),[16,4,2,1,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(17),ngZd,m3h3x24(:,48),heltab2x72(:,:,48))
  call Hloop_Q_A(ntryL,G0H24(17),16,nMB,G1H24(32),n2h24(16))
  Gcoeff(:)%j = (c(112)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(49),h0tab(:,49),[16,4,2,1,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(17),ngZu,m3h3x24(:,49),heltab2x72(:,:,49))
  call Hloop_Q_A(ntryL,G0H24(17),16,nMT,G1H24(33),n2h24(17))
  Gcoeff(:)%j = (-(c(168)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(50),h0tab(:,50),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(34),m3h3x24(:,50),heltab2x72(:,:,50))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(51),h0tab(:,51),[16,4,2,1,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(17),ngZd,m3h3x24(:,51),heltab2x72(:,:,51))
  call Hloop_Q_A(ntryL,G0H24(17),16,nMB,G1H24(35),n2h24(18))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(52),h0tab(:,52),[16,4,2,1,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(17),ngZd,m3h3x24(:,52),heltab2x72(:,:,52))
  call Hloop_Q_A(ntryL,G0H24(17),16,nMB,G1H24(36),n2h24(19))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(53),h0tab(:,53),[16,4,2,1,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(17),ngZu,m3h3x24(:,53),heltab2x72(:,:,53))
  call Hloop_Q_A(ntryL,G0H24(17),16,nMT,G1H24(37),n2h24(20))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(54),h0tab(:,54),[16,4,2,1,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(17),ngZd,m3h3x24(:,54),heltab2x72(:,:,54))
  call Hloop_Q_A(ntryL,G0H24(17),16,nMB,G1H24(38),n2h24(21))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(55),h0tab(:,55),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(17),m3h3x24(:,55),heltab2x72(:,:,55))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(56),h0tab(:,56),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(18),m3h3x24(:,56),heltab2x72(:,:,56))
  Gcoeff(:)%j = (-(c(153)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(57),h0tab(:,57),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(39),m3h3x24(:,57),heltab2x72(:,:,57))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(58),h0tab(:,58),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(40),m3h3x24(:,58),heltab2x72(:,:,58))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(59),h0tab(:,59),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(41),m3h3x24(:,59),heltab2x72(:,:,59))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(60),h0tab(:,60),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(19),m3h3x24(:,60),heltab2x72(:,:,60))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(61),h0tab(:,61),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(20),m3h3x24(:,61),heltab2x72(:,:,61))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(62),h0tab(:,62),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(21),m3h3x24(:,62),heltab2x72(:,:,62))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(63),h0tab(:,63),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(22),m3h3x24(:,63),heltab2x72(:,:,63))
  Gcoeff(:)%j = (c(177)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(64),h0tab(:,64),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(42),m3h3x24(:,64),heltab2x72(:,:,64))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(65),h0tab(:,65),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(43),m3h3x24(:,65),heltab2x72(:,:,65))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(66),h0tab(:,66),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(44),m3h3x24(:,66),heltab2x72(:,:,66))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(67),h0tab(:,67),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(23),m3h3x24(:,67),heltab2x72(:,:,67))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(68),h0tab(:,68),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(24),m3h3x24(:,68),heltab2x72(:,:,68))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(69),h0tab(:,69),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(45),m3h3x24(:,69),heltab2x72(:,:,69))
  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(70),h0tab(:,70),[16,2,1,8,4],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(25),ngZd,m3h3x24(:,70),heltab2x72(:,:,70))
  call Hloop_Q_A(ntryL,G0H24(25),16,nMB,G1H24(46),n2h24(22))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(71),h0tab(:,71),[16,2,1,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(25),ngZd,m3h3x24(:,71),heltab2x72(:,:,71))
  call Hloop_Q_A(ntryL,G0H24(25),16,nMB,G1H24(47),n2h24(23))
  Gcoeff(:)%j = (c(112)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(72),h0tab(:,72),[16,2,1,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(25),ngZu,m3h3x24(:,72),heltab2x72(:,:,72))
  call Hloop_Q_A(ntryL,G0H24(25),16,nMT,G1H24(48),n2h24(24))
  Gcoeff(:)%j = (-(c(168)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(73),h0tab(:,73),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(49),m3h3x24(:,73),heltab2x72(:,:,73))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(74),h0tab(:,74),[16,2,1,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(25),ngZd,m3h3x24(:,74),heltab2x72(:,:,74))
  call Hloop_Q_A(ntryL,G0H24(25),16,nMB,G1H24(50),n2h24(25))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(75),h0tab(:,75),[16,2,1,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(25),ngZd,m3h3x24(:,75),heltab2x72(:,:,75))
  call Hloop_Q_A(ntryL,G0H24(25),16,nMB,G1H24(51),n2h24(26))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(76),h0tab(:,76),[16,2,1,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(25),ngZu,m3h3x24(:,76),heltab2x72(:,:,76))
  call Hloop_Q_A(ntryL,G0H24(25),16,nMT,G1H24(52),n2h24(27))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(77),h0tab(:,77),[16,2,1,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(25),ngZd,m3h3x24(:,77),heltab2x72(:,:,77))
  call Hloop_Q_A(ntryL,G0H24(25),16,nMB,G1H24(53),n2h24(28))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(78),h0tab(:,78),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(25),m3h3x24(:,78),heltab2x72(:,:,78))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(79),h0tab(:,79),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(54),m3h3x24(:,79),heltab2x72(:,:,79))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(80),h0tab(:,80),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(26),m3h3x24(:,80),heltab2x72(:,:,80))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(81),h0tab(:,81),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(55),m3h3x24(:,81),heltab2x72(:,:,81))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(82),h0tab(:,82),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(27),m3h3x24(:,82),heltab2x72(:,:,82))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(83),h0tab(:,83),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(56),m3h3x24(:,83),heltab2x72(:,:,83))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(84),h0tab(:,84),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(28),m3h3x24(:,84),heltab2x72(:,:,84))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(85),h0tab(:,85),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(29),m3h3x24(:,85),heltab2x72(:,:,85))
  Gcoeff(:)%j = (c(152)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(86),h0tab(:,86),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(57),m3h3x24(:,86),heltab2x72(:,:,86))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(87),h0tab(:,87),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(30),m3h3x24(:,87),heltab2x72(:,:,87))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(88),h0tab(:,88),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(58),m3h3x24(:,88),heltab2x72(:,:,88))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(89),h0tab(:,89),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(31),m3h3x24(:,89),heltab2x72(:,:,89))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(90),h0tab(:,90),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(59),m3h3x24(:,90),heltab2x72(:,:,90))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(91),h0tab(:,91),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(32),m3h3x24(:,91),heltab2x72(:,:,91))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(92),h0tab(:,92),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(60),m3h3x24(:,92),heltab2x72(:,:,92))
  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(93),h0tab(:,93),[16,1,2,4,8],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,93),heltab2x72(:,:,93))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMB,G1H24(61),n2h24(29))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(94),h0tab(:,94),[16,1,2,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,94),heltab2x72(:,:,94))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMB,G1H24(62),n2h24(30))
  Gcoeff(:)%j = (c(112)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(95),h0tab(:,95),[16,1,2,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZu,m3h3x24(:,95),heltab2x72(:,:,95))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMT,G1H24(63),n2h24(31))
  Gcoeff(:)%j = (-(c(168)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(96),h0tab(:,96),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(64),m3h3x24(:,96),heltab2x72(:,:,96))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(97),h0tab(:,97),[16,1,2,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,97),heltab2x72(:,:,97))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMB,G1H24(65),n2h24(32))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(98),h0tab(:,98),[16,1,2,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,98),heltab2x72(:,:,98))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMB,G1H24(66),n2h24(33))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(99),h0tab(:,99),[16,1,2,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZu,m3h3x24(:,99),heltab2x72(:,:,99))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMT,G1H24(67),n2h24(34))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(100),h0tab(:,100),[16,1,2,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,100),heltab2x72(:,:,100))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMB,G1H24(68),n2h24(35))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(101),h0tab(:,101),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(33),m3h3x24(:,101),heltab2x72(:,:,101))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(102),h0tab(:,102),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(69),m3h3x24(:,102),heltab2x72(:,:,102))
  Gcoeff(:)%j = (-(c(153)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(103),h0tab(:,103),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(70),m3h3x24(:,103),heltab2x72(:,:,103))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(104),h0tab(:,104),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(34),m3h3x24(:,104),heltab2x72(:,:,104))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(105),h0tab(:,105),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(35),m3h3x24(:,105),heltab2x72(:,:,105))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(106),h0tab(:,106),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(36),m3h3x24(:,106),heltab2x72(:,:,106))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(107),h0tab(:,107),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(71),m3h3x24(:,107),heltab2x72(:,:,107))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(108),h0tab(:,108),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(72),m3h3x24(:,108),heltab2x72(:,:,108))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(109),h0tab(:,109),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(37),m3h3x24(:,109),heltab2x72(:,:,109))
  Gcoeff(:)%j = (c(177)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(110),h0tab(:,110),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(38),m3h3x24(:,110),heltab2x72(:,:,110))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(111),h0tab(:,111),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(39),m3h3x24(:,111),heltab2x72(:,:,111))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(112),h0tab(:,112),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(73),m3h3x24(:,112),heltab2x72(:,:,112))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(113),h0tab(:,113),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(74),m3h3x24(:,113),heltab2x72(:,:,113))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(114),h0tab(:,114),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(40),m3h3x24(:,114),heltab2x72(:,:,114))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(115),h0tab(:,115),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(75),m3h3x24(:,115),heltab2x72(:,:,115))
  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(116),h0tab(:,116),[16,1,2,8,4],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(41),ngZd,m3h3x24(:,116),heltab2x72(:,:,116))
  call Hloop_A_Q(ntryL,G0H24(41),16,nMB,G1H24(76),n2h24(36))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(117),h0tab(:,117),[16,1,2,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(41),ngZd,m3h3x24(:,117),heltab2x72(:,:,117))
  call Hloop_A_Q(ntryL,G0H24(41),16,nMB,G1H24(77),n2h24(37))
  Gcoeff(:)%j = (c(112)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(118),h0tab(:,118),[16,1,2,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(41),ngZu,m3h3x24(:,118),heltab2x72(:,:,118))
  call Hloop_A_Q(ntryL,G0H24(41),16,nMT,G1H24(78),n2h24(38))
  Gcoeff(:)%j = (-(c(168)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(119),h0tab(:,119),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(79),m3h3x24(:,119),heltab2x72(:,:,119))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(120),h0tab(:,120),[16,1,2,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(41),ngZd,m3h3x24(:,120),heltab2x72(:,:,120))
  call Hloop_A_Q(ntryL,G0H24(41),16,nMB,G1H24(80),n2h24(39))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(121),h0tab(:,121),[16,1,2,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(41),ngZd,m3h3x24(:,121),heltab2x72(:,:,121))
  call Hloop_A_Q(ntryL,G0H24(41),16,nMB,G1H24(81),n2h24(40))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(122),h0tab(:,122),[16,1,2,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(41),ngZu,m3h3x24(:,122),heltab2x72(:,:,122))
  call Hloop_A_Q(ntryL,G0H24(41),16,nMT,G1H24(82),n2h24(41))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(123),h0tab(:,123),[16,1,2,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(41),ngZd,m3h3x24(:,123),heltab2x72(:,:,123))
  call Hloop_A_Q(ntryL,G0H24(41),16,nMB,G1H24(83),n2h24(42))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(124),h0tab(:,124),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(41),m3h3x24(:,124),heltab2x72(:,:,124))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(125),h0tab(:,125),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(84),m3h3x24(:,125),heltab2x72(:,:,125))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(126),h0tab(:,126),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(85),m3h3x24(:,126),heltab2x72(:,:,126))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(127),h0tab(:,127),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(42),m3h3x24(:,127),heltab2x72(:,:,127))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(128),h0tab(:,128),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(43),m3h3x24(:,128),heltab2x72(:,:,128))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(129),h0tab(:,129),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(44),m3h3x24(:,129),heltab2x72(:,:,129))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(130),h0tab(:,130),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(86),m3h3x24(:,130),heltab2x72(:,:,130))
  Gcoeff(:)%j = (c(152)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(131),h0tab(:,131),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(87),m3h3x24(:,131),heltab2x72(:,:,131))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(132),h0tab(:,132),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(45),m3h3x24(:,132),heltab2x72(:,:,132))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(133),h0tab(:,133),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(46),m3h3x24(:,133),heltab2x72(:,:,133))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(134),h0tab(:,134),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(47),m3h3x24(:,134),heltab2x72(:,:,134))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(135),h0tab(:,135),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(88),m3h3x24(:,135),heltab2x72(:,:,135))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(136),h0tab(:,136),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(89),m3h3x24(:,136),heltab2x72(:,:,136))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(137),h0tab(:,137),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(48),m3h3x24(:,137),heltab2x72(:,:,137))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(138),h0tab(:,138),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(90),m3h3x24(:,138),heltab2x72(:,:,138))
  Gcoeff(:)%j = (c(113)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(139),h0tab(:,139),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(49),ngZu,m3h3x24(:,139),heltab2x72(:,:,139))
  call Hloop_Q_A(ntryL,G0H24(49),16,nMT,G1H24(91),n2h24(43))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(140),h0tab(:,140),[16,2,4,1,8],[nMH,nMB,nMB,nMH,nMZ],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(92),m3h3x24(:,140),heltab2x72(:,:,140))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(141),h0tab(:,141),[16,2,4,1,8],[nMZ,nMB,nMB,nMZ,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(93),m3h3x24(:,141),heltab2x72(:,:,141))
  Gcoeff(:)%j = (-(c(167)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(142),h0tab(:,142),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(94),m3h3x24(:,142),heltab2x72(:,:,142))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(143),h0tab(:,143),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(49),ngZu,m3h3x24(:,143),heltab2x72(:,:,143))
  call Hloop_Q_A(ntryL,G0H24(49),16,nMT,G1H24(95),n2h24(44))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(144),h0tab(:,144),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(49),ngZu,m3h3x24(:,144),heltab2x72(:,:,144))
  call Hloop_Q_A(ntryL,G0H24(49),16,nMT,G1H24(96),n2h24(45))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(145),h0tab(:,145),[16,2,4,1,8],[nMH,nMB,nMB,nMH,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(49),m3h3x24(:,145),heltab2x72(:,:,145))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(146),h0tab(:,146),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(50),m3h3x24(:,146),heltab2x72(:,:,146))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(147),h0tab(:,147),[16,2,4,1,8],[nMZ,nMB,nMB,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(51),m3h3x24(:,147),heltab2x72(:,:,147))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(148),h0tab(:,148),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(52),m3h3x24(:,148),heltab2x72(:,:,148))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(149),h0tab(:,149),[16,2,4,1,8],[nMZ,nMB,nMB,nMZ,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(97),m3h3x24(:,149),heltab2x72(:,:,149))
  Gcoeff(:)%j = (c(150)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(150),h0tab(:,150),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(98),m3h3x24(:,150),heltab2x72(:,:,150))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(151),h0tab(:,151),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(53),ngZu,m3h3x24(:,151),heltab2x72(:,:,151))
  call Hloop_Q_A(ntryL,G0H24(53),16,nMT,G1H24(99),n2h24(46))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(152),h0tab(:,152),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(100),m3h3x24(:,152),heltab2x72(:,:,152))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(153),h0tab(:,153),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(53),m3h3x24(:,153),heltab2x72(:,:,153))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(154),h0tab(:,154),[16,2,4,1,8],[nMZ,nMB,nMB,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(54),m3h3x24(:,154),heltab2x72(:,:,154))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(155),h0tab(:,155),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(55),m3h3x24(:,155),heltab2x72(:,:,155))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(156),h0tab(:,156),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(101),m3h3x24(:,156),heltab2x72(:,:,156))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(157),h0tab(:,157),[16,2,8,1,4],[nMB,nMZ,nMH,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(56),ngZd,m3h3x24(:,157),heltab2x72(:,:,157))
  call Hloop_Q_A(ntryL,G0H24(56),16,nMB,G1H24(102),n2h24(47))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(158),h0tab(:,158),[16,2,8,1,4],[nMB,nMH,nMZ,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(56),ngZd,m3h3x24(:,158),heltab2x72(:,:,158))
  call Hloop_Q_A(ntryL,G0H24(56),16,nMB,G1H24(103),n2h24(48))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(159),h0tab(:,159),[16,2,8,1,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(56),ngZu,m3h3x24(:,159),heltab2x72(:,:,159))
  call Hloop_Q_A(ntryL,G0H24(56),16,nMT,G1H24(104),n2h24(49))
  Gcoeff(:)%j = (-(c(188)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(160),h0tab(:,160),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(105),m3h3x24(:,160),heltab2x72(:,:,160))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(161),h0tab(:,161),[16,2,8,1,4],[nMB,nMZ,nMH,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(56),ngZd,m3h3x24(:,161),heltab2x72(:,:,161))
  call Hloop_Q_A(ntryL,G0H24(56),16,nMB,G1H24(106),n2h24(50))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(162),h0tab(:,162),[16,2,8,1,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(56),ngZu,m3h3x24(:,162),heltab2x72(:,:,162))
  call Hloop_Q_A(ntryL,G0H24(56),16,nMT,G1H24(107),n2h24(51))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(163),h0tab(:,163),[16,2,8,1,4],[nMB,nMH,nMZ,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(56),ngZd,m3h3x24(:,163),heltab2x72(:,:,163))
  call Hloop_Q_A(ntryL,G0H24(56),16,nMB,G1H24(108),n2h24(52))
  Gcoeff(:)%j = (c(128)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(164),h0tab(:,164),[16,2,8,1,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(56),ngZu,m3h3x24(:,164),heltab2x72(:,:,164))
  call Hloop_Q_A(ntryL,G0H24(56),16,nMT,G1H24(109),n2h24(53))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(165),h0tab(:,165),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(56),m3h3x24(:,165),heltab2x72(:,:,165))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(166),h0tab(:,166),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(57),m3h3x24(:,166),heltab2x72(:,:,166))
  Gcoeff(:)%j = (c(181)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(167),h0tab(:,167),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(110),m3h3x24(:,167),heltab2x72(:,:,167))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(168),h0tab(:,168),[16,2,8,1,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(58),ngZu,m3h3x24(:,168),heltab2x72(:,:,168))
  call Hloop_Q_A(ntryL,G0H24(58),16,nMT,G1H24(111),n2h24(54))
  Gcoeff(:)%j = (c(83)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(169),h0tab(:,169),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(112),m3h3x24(:,169),heltab2x72(:,:,169))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(170),h0tab(:,170),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(58),m3h3x24(:,170),heltab2x72(:,:,170))
  Gcoeff(:)%j = (c(135)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(171),h0tab(:,171),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(59),m3h3x24(:,171),heltab2x72(:,:,171))
  Gcoeff(:)%j = (c(83)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(172),h0tab(:,172),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(113),m3h3x24(:,172),heltab2x72(:,:,172))
  Gcoeff(:)%j = (c(113)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(173),h0tab(:,173),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(60),ngZu,m3h3x24(:,173),heltab2x72(:,:,173))
  call Hloop_A_Q(ntryL,G0H24(60),16,nMT,G1H24(114),n2h24(55))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(174),h0tab(:,174),[16,1,4,2,8],[nMH,nMB,nMB,nMH,nMZ],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(115),m3h3x24(:,174),heltab2x72(:,:,174))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(175),h0tab(:,175),[16,1,4,2,8],[nMZ,nMB,nMB,nMZ,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(116),m3h3x24(:,175),heltab2x72(:,:,175))
  Gcoeff(:)%j = (-(c(167)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(176),h0tab(:,176),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(117),m3h3x24(:,176),heltab2x72(:,:,176))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(177),h0tab(:,177),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(60),ngZu,m3h3x24(:,177),heltab2x72(:,:,177))
  call Hloop_A_Q(ntryL,G0H24(60),16,nMT,G1H24(118),n2h24(56))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(178),h0tab(:,178),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(60),ngZu,m3h3x24(:,178),heltab2x72(:,:,178))
  call Hloop_A_Q(ntryL,G0H24(60),16,nMT,G1H24(119),n2h24(57))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(179),h0tab(:,179),[16,1,4,2,8],[nMH,nMB,nMB,nMH,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(60),m3h3x24(:,179),heltab2x72(:,:,179))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(180),h0tab(:,180),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(61),m3h3x24(:,180),heltab2x72(:,:,180))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(181),h0tab(:,181),[16,1,4,2,8],[nMZ,nMB,nMB,nMZ,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(120),m3h3x24(:,181),heltab2x72(:,:,181))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(182),h0tab(:,182),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(121),m3h3x24(:,182),heltab2x72(:,:,182))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(183),h0tab(:,183),[16,1,4,2,8],[nMZ,nMB,nMB,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(62),m3h3x24(:,183),heltab2x72(:,:,183))
  Gcoeff(:)%j = (c(150)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(184),h0tab(:,184),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(63),m3h3x24(:,184),heltab2x72(:,:,184))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(185),h0tab(:,185),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(64),ngZu,m3h3x24(:,185),heltab2x72(:,:,185))
  call Hloop_A_Q(ntryL,G0H24(64),16,nMT,G1H24(122),n2h24(58))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(186),h0tab(:,186),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(64),m3h3x24(:,186),heltab2x72(:,:,186))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(187),h0tab(:,187),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(123),m3h3x24(:,187),heltab2x72(:,:,187))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(188),h0tab(:,188),[16,1,4,2,8],[nMZ,nMB,nMB,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(65),m3h3x24(:,188),heltab2x72(:,:,188))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(189),h0tab(:,189),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(66),m3h3x24(:,189),heltab2x72(:,:,189))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(190),h0tab(:,190),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(124),m3h3x24(:,190),heltab2x72(:,:,190))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(191),h0tab(:,191),[16,1,4,8,2],[nMH,nMB,nMB,nMB,nMZ],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(125),m3h3x24(:,191),heltab2x72(:,:,191))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(192),h0tab(:,192),[16,1,4,8,2],[nMZ,nMB,nMB,nMB,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(126),m3h3x24(:,192),heltab2x72(:,:,192))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(193),h0tab(:,193),[16,1,4,8,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(127),m3h3x24(:,193),heltab2x72(:,:,193))
  Gcoeff(:)%j = (-(c(188)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(194),h0tab(:,194),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(67),ngZu,m3h3x24(:,194),heltab2x72(:,:,194))
  call Hloop_A_Q(ntryL,G0H24(67),16,nMT,G1H24(128),n2h24(59))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(195),h0tab(:,195),[16,1,4,8,2],[nMH,nMB,nMB,nMB,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(67),m3h3x24(:,195),heltab2x72(:,:,195))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(196),h0tab(:,196),[16,1,4,8,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(68),m3h3x24(:,196),heltab2x72(:,:,196))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(197),h0tab(:,197),[16,1,4,8,2],[nMZ,nMB,nMB,nMB,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(69),m3h3x24(:,197),heltab2x72(:,:,197))
  Gcoeff(:)%j = (c(128)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(198),h0tab(:,198),[16,1,4,8,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(70),m3h3x24(:,198),heltab2x72(:,:,198))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(199),h0tab(:,199),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZu,m3h3x24(:,199),heltab2x72(:,:,199))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMT,G1H24(129),n2h24(60))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(200),h0tab(:,200),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZu,m3h3x24(:,200),heltab2x72(:,:,200))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMT,G1H24(130),n2h24(61))
  Gcoeff(:)%j = (c(181)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(201),h0tab(:,201),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZu,m3h3x24(:,201),heltab2x72(:,:,201))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMT,G1H24(131),n2h24(62))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(202),h0tab(:,202),[16,1,4,8,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(132),m3h3x24(:,202),heltab2x72(:,:,202))
  Gcoeff(:)%j = (c(83)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(203),h0tab(:,203),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZu,m3h3x24(:,203),heltab2x72(:,:,203))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMT,G1H24(133),n2h24(63))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(204),h0tab(:,204),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZu,m3h3x24(:,204),heltab2x72(:,:,204))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMT,G1H24(134),n2h24(64))
  Gcoeff(:)%j = (c(135)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(205),h0tab(:,205),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZu,m3h3x24(:,205),heltab2x72(:,:,205))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMT,G1H24(135),n2h24(65))
  Gcoeff(:)%j = (c(83)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(206),h0tab(:,206),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZu,m3h3x24(:,206),heltab2x72(:,:,206))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMT,G1H24(136),n2h24(66))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(207),h0tab(:,207),[16,1,8,2,4],[nMB,nMH,nMZ,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZd,m3h3x24(:,207),heltab2x72(:,:,207))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMB,G1H24(137),n2h24(67))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(208),h0tab(:,208),[16,1,8,2,4],[nMB,nMZ,nMH,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZd,m3h3x24(:,208),heltab2x72(:,:,208))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMB,G1H24(138),n2h24(68))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(209),h0tab(:,209),[16,1,8,2,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZu,m3h3x24(:,209),heltab2x72(:,:,209))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMT,G1H24(139),n2h24(69))
  Gcoeff(:)%j = (-(c(188)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(210),h0tab(:,210),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(140),m3h3x24(:,210),heltab2x72(:,:,210))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(211),h0tab(:,211),[16,1,8,2,4],[nMB,nMH,nMZ,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZd,m3h3x24(:,211),heltab2x72(:,:,211))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMB,G1H24(141),n2h24(70))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(212),h0tab(:,212),[16,1,8,2,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZu,m3h3x24(:,212),heltab2x72(:,:,212))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMT,G1H24(142),n2h24(71))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(213),h0tab(:,213),[16,1,8,2,4],[nMB,nMZ,nMH,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZd,m3h3x24(:,213),heltab2x72(:,:,213))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMB,G1H24(143),n2h24(72))
  Gcoeff(:)%j = (c(128)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(214),h0tab(:,214),[16,1,8,2,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(71),ngZu,m3h3x24(:,214),heltab2x72(:,:,214))
  call Hloop_A_Q(ntryL,G0H24(71),16,nMT,G1H24(144),n2h24(73))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(215),h0tab(:,215),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(71),m3h3x24(:,215),heltab2x72(:,:,215))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(216),h0tab(:,216),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(145),m3h3x24(:,216),heltab2x72(:,:,216))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(217),h0tab(:,217),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(72),m3h3x24(:,217),heltab2x72(:,:,217))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(218),h0tab(:,218),[16,1,8,2,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(73),ngZu,m3h3x24(:,218),heltab2x72(:,:,218))
  call Hloop_A_Q(ntryL,G0H24(73),16,nMT,G1H24(146),n2h24(74))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(219),h0tab(:,219),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(73),m3h3x24(:,219),heltab2x72(:,:,219))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(220),h0tab(:,220),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(147),m3h3x24(:,220),heltab2x72(:,:,220))
  Gcoeff(:)%j = (c(135)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(221),h0tab(:,221),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(74),m3h3x24(:,221),heltab2x72(:,:,221))
  Gcoeff(:)%j = (c(83)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(222),h0tab(:,222),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(148),m3h3x24(:,222),heltab2x72(:,:,222))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(223),h0tab(:,223),[16,1,8,4,2],[nMH,nMB,nMB,nMB,nMZ],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(149),m3h3x24(:,223),heltab2x72(:,:,223))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(224),h0tab(:,224),[16,1,8,4,2],[nMZ,nMB,nMB,nMB,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(150),m3h3x24(:,224),heltab2x72(:,:,224))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(225),h0tab(:,225),[16,1,8,4,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(151),m3h3x24(:,225),heltab2x72(:,:,225))
  Gcoeff(:)%j = (-(c(188)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(226),h0tab(:,226),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(75),ngZu,m3h3x24(:,226),heltab2x72(:,:,226))
  call Hloop_A_Q(ntryL,G0H24(75),16,nMT,G1H24(152),n2h24(75))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(227),h0tab(:,227),[16,1,8,4,2],[nMH,nMB,nMB,nMB,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(75),m3h3x24(:,227),heltab2x72(:,:,227))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(228),h0tab(:,228),[16,1,8,4,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(76),m3h3x24(:,228),heltab2x72(:,:,228))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(229),h0tab(:,229),[16,1,8,4,2],[nMZ,nMB,nMB,nMB,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(77),m3h3x24(:,229),heltab2x72(:,:,229))
  Gcoeff(:)%j = (c(128)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(230),h0tab(:,230),[16,1,8,4,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(78),m3h3x24(:,230),heltab2x72(:,:,230))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(231),h0tab(:,231),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(79),ngZu,m3h3x24(:,231),heltab2x72(:,:,231))
  call Hloop_A_Q(ntryL,G0H24(79),16,nMT,G1H24(153),n2h24(76))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(232),h0tab(:,232),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(79),ngZu,m3h3x24(:,232),heltab2x72(:,:,232))
  call Hloop_A_Q(ntryL,G0H24(79),16,nMT,G1H24(154),n2h24(77))
  Gcoeff(:)%j = (c(129)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(233),h0tab(:,233),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(79),ngZu,m3h3x24(:,233),heltab2x72(:,:,233))
  call Hloop_A_Q(ntryL,G0H24(79),16,nMT,G1H24(155),n2h24(78))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(234),h0tab(:,234),[16,1,8,4,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(156),m3h3x24(:,234),heltab2x72(:,:,234))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(235),h0tab(:,235),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(79),ngZu,m3h3x24(:,235),heltab2x72(:,:,235))
  call Hloop_A_Q(ntryL,G0H24(79),16,nMT,G1H24(157),n2h24(79))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(236),h0tab(:,236),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(79),ngZu,m3h3x24(:,236),heltab2x72(:,:,236))
  call Hloop_A_Q(ntryL,G0H24(79),16,nMT,G1H24(158),n2h24(80))
  Gcoeff(:)%j = (c(135)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(237),h0tab(:,237),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(79),ngZu,m3h3x24(:,237),heltab2x72(:,:,237))
  call Hloop_A_Q(ntryL,G0H24(79),16,nMT,G1H24(159),n2h24(81))
  Gcoeff(:)%j = (c(83)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(238),h0tab(:,238),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(79),ngZu,m3h3x24(:,238),heltab2x72(:,:,238))
  call Hloop_A_Q(ntryL,G0H24(79),16,nMT,G1H24(160),n2h24(82))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(8),[G1H24(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(23),[G1H24(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(38),[G1H24(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(53),[G1H24(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(68),[G1H24(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(83),[G1H24(80)])
  call Hloop_AV_Q(ntryL,G1H24(1),ex3(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(1),n2h12(1))
  call Hloop_AV_Q(ntryL,G1H24(2),ex3(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(2),n2h12(2))
  call Hloop_AV_Q(ntryL,G1H24(3),ex3(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(3),n2h12(3))
  call Hloop_SV_T(ntryL,G1H24(4),16,ex3(:),4,G2H12(4),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_AV_Q(ntryL,G1H24(8),ex3(:),G1H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(5),n2h12(4))
  call Hloop_AV_Q(ntryL,G1H24(6),ex3(:),G1H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(6),n2h12(5))
  call Hloop_AV_Q(ntryL,G1H24(7),ex3(:),G1H12(1),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(7),n2h12(6))
  call Hloop_SV_T(ntryL,G0H24(1),16,ex3(:),4,G1H12(1),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_VV_S(ntryL,G0H24(2),ex3(:),G0H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_SV_T(ntryL,G1H24(9),16,ex3(:),4,G2H12(8),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_SV_V(ntryL,G1H24(10),ex3(:),G1H12(2),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_VV_S(ntryL,G1H24(11),ex3(:),G1H12(3),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_SV_T(ntryL,G0H24(3),16,ex3(:),4,G1H12(4),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_VV_S(ntryL,G0H24(4),ex3(:),G0H12(2),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_SV_V(ntryL,G0H24(5),ex3(:),G0H12(3),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_UW_V(ntryL,G0H24(6),16,ex3(:),4,G1H12(5),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_SV_V(ntryL,G1H24(12),ex3(:),G1H12(6),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_VV_S(ntryL,G1H24(13),ex3(:),G1H12(7),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_UW_V(ntryL,G1H24(14),16,ex3(:),4,G2H12(9),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_SV_V(ntryL,G0H24(7),ex3(:),G0H12(4),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_UW_V(ntryL,G0H24(8),16,ex3(:),4,G1H12(8),m3h2x12(:,21),heltab2x24(:,:,21))
  call Hloop_UW_V(ntryL,G1H24(15),16,ex3(:),4,G2H12(10),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hloop_QA_S(ntryL,G1H24(16),ex2(:),G1H12(9),ngH,m3h2x12(:,23),heltab2x24(:,:,23))
  call Hloop_QA_S(ntryL,G1H24(17),ex2(:),G1H12(10),ngX,m3h2x12(:,24),heltab2x24(:,:,24))
  call Hloop_QA_S(ntryL,G1H24(18),ex2(:),G1H12(11),ngPbt,m3h2x12(:,25),heltab2x24(:,:,25))
  call Hloop_SA_Q(ntryL,G1H24(19),ex2(:),G1H12(12),ngPbt,m3h2x12(:,26),heltab2x24(:,:,26))
  call Hloop_A_Q(ntryL,G1H12(12),18,nMT,G2H12(11),n2h12(7))
  call Hloop_QA_V(ntryL,G1H24(23),ex2(:),G1H12(12),m3h2x12(:,27),heltab2x24(:,:,27))
  call Hloop_QA_Z(ntryL,G1H24(21),ex2(:),G1H12(13),ngZd,m3h2x12(:,28),heltab2x24(:,:,28))
  call Hloop_QA_W(ntryL,G1H24(22),ex2(:),G1H12(14),m3h2x12(:,29),heltab2x24(:,:,29))
  call Hloop_SA_Q(ntryL,G0H24(9),ex2(:),G0H12(5),ngPbt,m3h2x12(:,30),heltab2x24(:,:,30))
  call Hloop_A_Q(ntryL,G0H12(5),18,nMT,G1H12(15),n2h12(8))
  call Hloop_SA_Q(ntryL,G1H24(24),ex2(:),G1H12(16),ngPbt,m3h2x12(:,31),heltab2x24(:,:,31))
  call Hloop_A_Q(ntryL,G1H12(16),18,nMT,G2H12(12),n2h12(9))
  call Hloop_WA_Q(ntryL,G0H24(10),ex2(:),G0H12(5),m3h2x12(:,32),heltab2x24(:,:,32))
  call Hloop_A_Q(ntryL,G0H12(5),18,nMT,G1H12(16),n2h12(10))
  call Hloop_SA_Q(ntryL,G1H24(25),ex2(:),G1H12(17),ngPbt,m3h2x12(:,33),heltab2x24(:,:,33))
  call Hloop_A_Q(ntryL,G1H12(17),18,nMT,G2H12(13),n2h12(11))
  call Hloop_SA_Q(ntryL,G0H24(11),ex2(:),G0H12(5),ngPbt,m3h2x12(:,34),heltab2x24(:,:,34))
  call Hloop_A_Q(ntryL,G0H12(5),18,nMT,G1H12(17),n2h12(12))
  call Hloop_WA_Q(ntryL,G1H24(26),ex2(:),G1H12(18),m3h2x12(:,35),heltab2x24(:,:,35))
  call Hloop_A_Q(ntryL,G1H12(18),18,nMT,G2H12(14),n2h12(13))
  call Hloop_WA_Q(ntryL,G0H24(12),ex2(:),G0H12(5),m3h2x12(:,36),heltab2x24(:,:,36))
  call Hloop_A_Q(ntryL,G0H12(5),18,nMT,G1H12(18),n2h12(14))
  call Hloop_SA_Q(ntryL,G0H24(13),ex2(:),G0H12(5),ngPbt,m3h2x12(:,37),heltab2x24(:,:,37))
  call Hloop_A_Q(ntryL,G0H12(5),18,nMT,G1H12(19),n2h12(15))
  call Hloop_SA_Q(ntryL,G1H24(27),ex2(:),G1H12(20),ngPbt,m3h2x12(:,38),heltab2x24(:,:,38))
  call Hloop_A_Q(ntryL,G1H12(20),18,nMT,G2H12(15),n2h12(16))
  call Hloop_WA_Q(ntryL,G0H24(14),ex2(:),G0H12(5),m3h2x12(:,39),heltab2x24(:,:,39))
  call Hloop_A_Q(ntryL,G0H12(5),18,nMT,G1H12(20),n2h12(17))
  call Hloop_WA_Q(ntryL,G1H24(28),ex2(:),G1H12(21),m3h2x12(:,40),heltab2x24(:,:,40))
  call Hloop_A_Q(ntryL,G1H12(21),18,nMT,G2H12(16),n2h12(18))
  call Hloop_SA_Q(ntryL,G0H24(15),ex2(:),G0H12(5),ngPbt,m3h2x12(:,41),heltab2x24(:,:,41))
  call Hloop_A_Q(ntryL,G0H12(5),18,nMT,G1H12(21),n2h12(19))
  call Hloop_WA_Q(ntryL,G1H24(29),ex2(:),G1H12(22),m3h2x12(:,42),heltab2x24(:,:,42))
  call Hloop_A_Q(ntryL,G1H12(22),18,nMT,G2H12(17),n2h12(20))
  call Hloop_WA_Q(ntryL,G0H24(16),ex2(:),G0H12(5),m3h2x12(:,43),heltab2x24(:,:,43))
  call Hloop_A_Q(ntryL,G0H12(5),18,nMT,G1H12(22),n2h12(21))
  call Hloop_WA_Q(ntryL,G1H24(30),ex2(:),G1H12(23),m3h2x12(:,44),heltab2x24(:,:,44))
  call Hloop_A_Q(ntryL,G1H12(23),18,nMT,G2H12(18),n2h12(22))
  call Hloop_QV_A(ntryL,G1H24(31),ex3(:),G1H12(23),m3h2x12(:,45),heltab2x24(:,:,45))
  call Hloop_Q_A(ntryL,G1H12(23),20,nMB,G2H12(19),n2h12(23))
  call Hloop_QV_A(ntryL,G1H24(32),ex3(:),G1H12(23),m3h2x12(:,46),heltab2x24(:,:,46))
  call Hloop_Q_A(ntryL,G1H12(23),20,nMB,G2H12(20),n2h12(24))
  call Hloop_QV_A(ntryL,G1H24(33),ex3(:),G1H12(23),m3h2x12(:,47),heltab2x24(:,:,47))
  call Hloop_Q_A(ntryL,G1H12(23),20,nMT,G2H12(21),n2h12(25))
  call Hloop_TV_S(ntryL,G1H24(34),16,ex3(:),4,G2H12(22),m3h2x12(:,48),heltab2x24(:,:,48))
  call Hloop_QV_A(ntryL,G1H24(38),ex3(:),G1H12(23),m3h2x12(:,49),heltab2x24(:,:,49))
  call Hloop_Q_A(ntryL,G1H12(23),20,nMB,G2H12(23),n2h12(26))
  call Hloop_QV_A(ntryL,G1H24(36),ex3(:),G1H12(23),m3h2x12(:,50),heltab2x24(:,:,50))
  call Hloop_Q_A(ntryL,G1H12(23),20,nMB,G2H12(24),n2h12(27))
  call Hloop_QV_A(ntryL,G1H24(37),ex3(:),G1H12(23),m3h2x12(:,51),heltab2x24(:,:,51))
  call Hloop_Q_A(ntryL,G1H12(23),20,nMT,G2H12(25),n2h12(28))
  call Hloop_TV_S(ntryL,G0H24(17),16,ex3(:),4,G1H12(23),m3h2x12(:,52),heltab2x24(:,:,52))
  call Hloop_VV_S(ntryL,G0H24(18),ex3(:),G0H12(5),m3h2x12(:,53),heltab2x24(:,:,53))
  call Hloop_SV_V(ntryL,G1H24(39),ex3(:),G1H12(24),m3h2x12(:,54),heltab2x24(:,:,54))
  call Hloop_TV_S(ntryL,G1H24(40),16,ex3(:),4,G2H12(26),m3h2x12(:,55),heltab2x24(:,:,55))
  call Hloop_VV_S(ntryL,G1H24(41),ex3(:),G1H12(25),m3h2x12(:,56),heltab2x24(:,:,56))
  call Hloop_SV_V(ntryL,G0H24(19),ex3(:),G0H12(6),m3h2x12(:,57),heltab2x24(:,:,57))
  call Hloop_UV_W(ntryL,G0H24(20),16,ex3(:),4,G1H12(26),m3h2x12(:,58),heltab2x24(:,:,58))
  call Hloop_TV_S(ntryL,G0H24(21),16,ex3(:),4,G1H12(27),m3h2x12(:,59),heltab2x24(:,:,59))
  call Hloop_VV_S(ntryL,G0H24(22),ex3(:),G0H12(7),m3h2x12(:,60),heltab2x24(:,:,60))
  call Hloop_SV_V(ntryL,G1H24(42),ex3(:),G1H12(28),m3h2x12(:,61),heltab2x24(:,:,61))
  call Hloop_UV_W(ntryL,G1H24(43),16,ex3(:),4,G2H12(27),m3h2x12(:,62),heltab2x24(:,:,62))
  call Hloop_VV_S(ntryL,G1H24(44),ex3(:),G1H12(29),m3h2x12(:,63),heltab2x24(:,:,63))
  call Hloop_SV_V(ntryL,G0H24(23),ex3(:),G0H12(8),m3h2x12(:,64),heltab2x24(:,:,64))
  call Hloop_UV_W(ntryL,G0H24(24),16,ex3(:),4,G1H12(30),m3h2x12(:,65),heltab2x24(:,:,65))
  call Hloop_UV_W(ntryL,G1H24(45),16,ex3(:),4,G2H12(28),m3h2x12(:,66),heltab2x24(:,:,66))
  call Hloop_QA_S(ntryL,G1H24(46),ex2(:),G1H12(31),ngH,m3h2x12(:,67),heltab2x24(:,:,67))
  call Hloop_QA_S(ntryL,G1H24(47),ex2(:),G1H12(32),ngX,m3h2x12(:,68),heltab2x24(:,:,68))
  call Hloop_QA_S(ntryL,G1H24(48),ex2(:),G1H12(33),ngPbt,m3h2x12(:,69),heltab2x24(:,:,69))
  call Hloop_SA_Q(ntryL,G1H24(49),ex2(:),G1H12(34),ngPbt,m3h2x12(:,70),heltab2x24(:,:,70))
  call Hloop_A_Q(ntryL,G1H12(34),18,nMT,G2H12(29),n2h12(29))
  call Hloop_QA_V(ntryL,G1H24(53),ex2(:),G1H12(34),m3h2x12(:,71),heltab2x24(:,:,71))
  call Hloop_QA_Z(ntryL,G1H24(51),ex2(:),G1H12(35),ngZd,m3h2x12(:,72),heltab2x24(:,:,72))
  call Hloop_QA_W(ntryL,G1H24(52),ex2(:),G1H12(36),m3h2x12(:,73),heltab2x24(:,:,73))
  call Hloop_SA_Q(ntryL,G0H24(25),ex2(:),G0H12(9),ngPbt,m3h2x12(:,74),heltab2x24(:,:,74))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(37),n2h12(30))
  call Hloop_SA_Q(ntryL,G1H24(54),ex2(:),G1H12(38),ngPbt,m3h2x12(:,75),heltab2x24(:,:,75))
  call Hloop_A_Q(ntryL,G1H12(38),18,nMT,G2H12(30),n2h12(31))
  call Hloop_WA_Q(ntryL,G0H24(26),ex2(:),G0H12(9),m3h2x12(:,76),heltab2x24(:,:,76))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(38),n2h12(32))
  call Hloop_SA_Q(ntryL,G1H24(55),ex2(:),G1H12(39),ngPbt,m3h2x12(:,77),heltab2x24(:,:,77))
  call Hloop_A_Q(ntryL,G1H12(39),18,nMT,G2H12(31),n2h12(33))
  call Hloop_SA_Q(ntryL,G0H24(27),ex2(:),G0H12(9),ngPbt,m3h2x12(:,78),heltab2x24(:,:,78))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(39),n2h12(34))
  call Hloop_WA_Q(ntryL,G1H24(56),ex2(:),G1H12(40),m3h2x12(:,79),heltab2x24(:,:,79))
  call Hloop_A_Q(ntryL,G1H12(40),18,nMT,G2H12(32),n2h12(35))
  call Hloop_WA_Q(ntryL,G0H24(28),ex2(:),G0H12(9),m3h2x12(:,80),heltab2x24(:,:,80))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(40),n2h12(36))
  call Hloop_SA_Q(ntryL,G0H24(29),ex2(:),G0H12(9),ngPbt,m3h2x12(:,81),heltab2x24(:,:,81))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(41),n2h12(37))
  call Hloop_SA_Q(ntryL,G1H24(57),ex2(:),G1H12(42),ngPbt,m3h2x12(:,82),heltab2x24(:,:,82))
  call Hloop_A_Q(ntryL,G1H12(42),18,nMT,G2H12(33),n2h12(38))
  call Hloop_WA_Q(ntryL,G0H24(30),ex2(:),G0H12(9),m3h2x12(:,83),heltab2x24(:,:,83))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(42),n2h12(39))
  call Hloop_WA_Q(ntryL,G1H24(58),ex2(:),G1H12(43),m3h2x12(:,84),heltab2x24(:,:,84))
  call Hloop_A_Q(ntryL,G1H12(43),18,nMT,G2H12(34),n2h12(40))
  call Hloop_SA_Q(ntryL,G0H24(31),ex2(:),G0H12(9),ngPbt,m3h2x12(:,85),heltab2x24(:,:,85))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(43),n2h12(41))
  call Hloop_WA_Q(ntryL,G1H24(59),ex2(:),G1H12(44),m3h2x12(:,86),heltab2x24(:,:,86))
  call Hloop_A_Q(ntryL,G1H12(44),18,nMT,G2H12(35),n2h12(42))
  call Hloop_WA_Q(ntryL,G0H24(32),ex2(:),G0H12(9),m3h2x12(:,87),heltab2x24(:,:,87))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(44),n2h12(43))
  call Hloop_WA_Q(ntryL,G1H24(60),ex2(:),G1H12(45),m3h2x12(:,88),heltab2x24(:,:,88))
  call Hloop_A_Q(ntryL,G1H12(45),18,nMT,G2H12(36),n2h12(44))
  call Hloop_AQ_S(ntryL,G1H24(61),ex1(:),G1H12(45),ngH,m3h2x12(:,89),heltab2x24(:,:,89))
  call Hloop_AQ_S(ntryL,G1H24(62),ex1(:),G1H12(46),ngX,m3h2x12(:,90),heltab2x24(:,:,90))
  call Hloop_AQ_S(ntryL,G1H24(63),ex1(:),G1H12(47),ngPtb,m3h2x12(:,91),heltab2x24(:,:,91))
  call Hloop_SQ_A(ntryL,G1H24(64),ex1(:),G1H12(48),ngPtb,m3h2x12(:,92),heltab2x24(:,:,92))
  call Hloop_Q_A(ntryL,G1H12(48),17,nMT,G2H12(37),n2h12(45))
  call Hloop_AQ_V(ntryL,G1H24(68),ex1(:),G1H12(48),m3h2x12(:,93),heltab2x24(:,:,93))
  call Hloop_AQ_Z(ntryL,G1H24(66),ex1(:),G1H12(49),ngZd,m3h2x12(:,94),heltab2x24(:,:,94))
  call Hloop_AQ_W(ntryL,G1H24(67),ex1(:),G1H12(50),m3h2x12(:,95),heltab2x24(:,:,95))
  call Hloop_SQ_A(ntryL,G0H24(33),ex1(:),G0H12(9),ngPtb,m3h2x12(:,96),heltab2x24(:,:,96))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(51),n2h12(46))
  call Hloop_SQ_A(ntryL,G1H24(69),ex1(:),G1H12(52),ngPtb,m3h2x12(:,97),heltab2x24(:,:,97))
  call Hloop_Q_A(ntryL,G1H12(52),17,nMT,G2H12(38),n2h12(47))
  call Hloop_SQ_A(ntryL,G1H24(70),ex1(:),G1H12(52),ngPtb,m3h2x12(:,98),heltab2x24(:,:,98))
  call Hloop_Q_A(ntryL,G1H12(52),17,nMT,G2H12(39),n2h12(48))
  call Hloop_WQ_A(ntryL,G0H24(34),ex1(:),G0H12(9),m3h2x12(:,99),heltab2x24(:,:,99))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(52),n2h12(49))
  call Hloop_SQ_A(ntryL,G0H24(35),ex1(:),G0H12(9),ngPtb,m3h2x12(:,100),heltab2x24(:,:,100))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(53),n2h12(50))
  call Hloop_SQ_A(ntryL,G0H24(36),ex1(:),G0H12(9),ngPtb,m3h2x12(:,101),heltab2x24(:,:,101))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(54),n2h12(51))
  call Hloop_SQ_A(ntryL,G1H24(71),ex1(:),G1H12(55),ngPtb,m3h2x12(:,102),heltab2x24(:,:,102))
  call Hloop_Q_A(ntryL,G1H12(55),17,nMT,G2H12(40),n2h12(52))
  call Hloop_WQ_A(ntryL,G1H24(72),ex1(:),G1H12(55),m3h2x12(:,103),heltab2x24(:,:,103))
  call Hloop_Q_A(ntryL,G1H12(55),17,nMT,G2H12(41),n2h12(53))
  call Hloop_WQ_A(ntryL,G0H24(37),ex1(:),G0H12(9),m3h2x12(:,104),heltab2x24(:,:,104))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(55),n2h12(54))
  call Hloop_WQ_A(ntryL,G0H24(38),ex1(:),G0H12(9),m3h2x12(:,105),heltab2x24(:,:,105))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(56),n2h12(55))
  call Hloop_SQ_A(ntryL,G0H24(39),ex1(:),G0H12(9),ngPtb,m3h2x12(:,106),heltab2x24(:,:,106))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(57),n2h12(56))
  call Hloop_WQ_A(ntryL,G1H24(73),ex1(:),G1H12(58),m3h2x12(:,107),heltab2x24(:,:,107))
  call Hloop_Q_A(ntryL,G1H12(58),17,nMT,G2H12(42),n2h12(57))
  call Hloop_WQ_A(ntryL,G1H24(74),ex1(:),G1H12(58),m3h2x12(:,108),heltab2x24(:,:,108))
  call Hloop_Q_A(ntryL,G1H12(58),17,nMT,G2H12(43),n2h12(58))
  call Hloop_WQ_A(ntryL,G0H24(40),ex1(:),G0H12(9),m3h2x12(:,109),heltab2x24(:,:,109))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(58),n2h12(59))
  call Hloop_WQ_A(ntryL,G1H24(75),ex1(:),G1H12(59),m3h2x12(:,110),heltab2x24(:,:,110))
  call Hloop_Q_A(ntryL,G1H12(59),17,nMT,G2H12(44),n2h12(60))
  call Hloop_AQ_S(ntryL,G1H24(76),ex1(:),G1H12(59),ngH,m3h2x12(:,111),heltab2x24(:,:,111))
  call Hloop_AQ_S(ntryL,G1H24(77),ex1(:),G1H12(60),ngX,m3h2x12(:,112),heltab2x24(:,:,112))
  call Hloop_AQ_S(ntryL,G1H24(78),ex1(:),G1H12(61),ngPtb,m3h2x12(:,113),heltab2x24(:,:,113))
  call Hloop_SQ_A(ntryL,G1H24(79),ex1(:),G1H12(62),ngPtb,m3h2x12(:,114),heltab2x24(:,:,114))
  call Hloop_Q_A(ntryL,G1H12(62),17,nMT,G2H12(45),n2h12(61))
  call Hloop_AQ_V(ntryL,G1H24(83),ex1(:),G1H12(62),m3h2x12(:,115),heltab2x24(:,:,115))
  call Hloop_AQ_Z(ntryL,G1H24(81),ex1(:),G1H12(63),ngZd,m3h2x12(:,116),heltab2x24(:,:,116))
  call Hloop_AQ_W(ntryL,G1H24(82),ex1(:),G1H12(64),m3h2x12(:,117),heltab2x24(:,:,117))
  call Hloop_SQ_A(ntryL,G0H24(41),ex1(:),G0H12(9),ngPtb,m3h2x12(:,118),heltab2x24(:,:,118))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(65),n2h12(62))
  call Hloop_SQ_A(ntryL,G1H24(84),ex1(:),G1H12(66),ngPtb,m3h2x12(:,119),heltab2x24(:,:,119))
  call Hloop_Q_A(ntryL,G1H12(66),17,nMT,G2H12(46),n2h12(63))
  call Hloop_SQ_A(ntryL,G1H24(85),ex1(:),G1H12(66),ngPtb,m3h2x12(:,120),heltab2x24(:,:,120))
  call Hloop_Q_A(ntryL,G1H12(66),17,nMT,G2H12(47),n2h12(64))
  call Hloop_WQ_A(ntryL,G0H24(42),ex1(:),G0H12(9),m3h2x12(:,121),heltab2x24(:,:,121))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(66),n2h12(65))
  call Hloop_SQ_A(ntryL,G0H24(43),ex1(:),G0H12(9),ngPtb,m3h2x12(:,122),heltab2x24(:,:,122))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(67),n2h12(66))
  call Hloop_SQ_A(ntryL,G0H24(44),ex1(:),G0H12(9),ngPtb,m3h2x12(:,123),heltab2x24(:,:,123))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(68),n2h12(67))
  call Hloop_SQ_A(ntryL,G1H24(86),ex1(:),G1H12(69),ngPtb,m3h2x12(:,124),heltab2x24(:,:,124))
  call Hloop_Q_A(ntryL,G1H12(69),17,nMT,G2H12(48),n2h12(68))
  call Hloop_WQ_A(ntryL,G1H24(87),ex1(:),G1H12(69),m3h2x12(:,125),heltab2x24(:,:,125))
  call Hloop_Q_A(ntryL,G1H12(69),17,nMT,G2H12(49),n2h12(69))
  call Hloop_WQ_A(ntryL,G0H24(45),ex1(:),G0H12(9),m3h2x12(:,126),heltab2x24(:,:,126))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(69),n2h12(70))
  call Hloop_WQ_A(ntryL,G0H24(46),ex1(:),G0H12(9),m3h2x12(:,127),heltab2x24(:,:,127))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(70),n2h12(71))
  call Hloop_SQ_A(ntryL,G0H24(47),ex1(:),G0H12(9),ngPtb,m3h2x12(:,128),heltab2x24(:,:,128))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(71),n2h12(72))
  call Hloop_WQ_A(ntryL,G1H24(88),ex1(:),G1H12(72),m3h2x12(:,129),heltab2x24(:,:,129))
  call Hloop_Q_A(ntryL,G1H12(72),17,nMT,G2H12(50),n2h12(73))
  call Hloop_WQ_A(ntryL,G1H24(89),ex1(:),G1H12(72),m3h2x12(:,130),heltab2x24(:,:,130))
  call Hloop_Q_A(ntryL,G1H12(72),17,nMT,G2H12(51),n2h12(74))
  call Hloop_WQ_A(ntryL,G0H24(48),ex1(:),G0H12(9),m3h2x12(:,131),heltab2x24(:,:,131))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(72),n2h12(75))
  call Hloop_WQ_A(ntryL,G1H24(90),ex1(:),G1H12(73),m3h2x12(:,132),heltab2x24(:,:,132))
  call Hloop_Q_A(ntryL,G1H12(73),17,nMT,G2H12(52),n2h12(76))
  call Hloop_QA_S(ntryL,G1H24(91),ex2(:),G1H12(73),ngPbt,m3h2x12(:,133),heltab2x24(:,:,133))
  call Hloop_SA_Q(ntryL,G1H24(92),ex2(:),G1H12(74),ngH,m3h2x12(:,134),heltab2x24(:,:,134))
  call Hloop_A_Q(ntryL,G1H12(74),18,nMB,G2H12(53),n2h12(77))
  call Hloop_SA_Q(ntryL,G1H24(93),ex2(:),G1H12(74),ngX,m3h2x12(:,135),heltab2x24(:,:,135))
  call Hloop_A_Q(ntryL,G1H12(74),18,nMB,G2H12(54),n2h12(78))
  call Hloop_SA_Q(ntryL,G1H24(94),ex2(:),G1H12(74),ngPbt,m3h2x12(:,136),heltab2x24(:,:,136))
  call Hloop_A_Q(ntryL,G1H12(74),18,nMT,G2H12(55),n2h12(79))
  call Hloop_QA_W(ntryL,G1H24(95),ex2(:),G1H12(74),m3h2x12(:,137),heltab2x24(:,:,137))
  call Hloop_QA_S(ntryL,G1H24(96),ex2(:),G1H12(75),ngPbt,m3h2x12(:,138),heltab2x24(:,:,138))
  call Hloop_SA_Q(ntryL,G0H24(49),ex2(:),G0H12(9),ngH,m3h2x12(:,139),heltab2x24(:,:,139))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMB,G1H12(76),n2h12(80))
  call Hloop_SA_Q(ntryL,G0H24(50),ex2(:),G0H12(9),ngPbt,m3h2x12(:,140),heltab2x24(:,:,140))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(77),n2h12(81))
  call Hloop_ZA_Q(ntryL,G0H24(51),ex2(:),G0H12(9),ngZd,m3h2x12(:,141),heltab2x24(:,:,141))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMB,G1H12(78),n2h12(82))
  call Hloop_WA_Q(ntryL,G0H24(52),ex2(:),G0H12(9),m3h2x12(:,142),heltab2x24(:,:,142))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(79),n2h12(83))
  call Hloop_SA_Q(ntryL,G1H24(97),ex2(:),G1H12(80),ngX,m3h2x12(:,143),heltab2x24(:,:,143))
  call Hloop_A_Q(ntryL,G1H12(80),18,nMB,G2H12(56),n2h12(84))
  call Hloop_SA_Q(ntryL,G1H24(98),ex2(:),G1H12(80),ngPbt,m3h2x12(:,144),heltab2x24(:,:,144))
  call Hloop_A_Q(ntryL,G1H12(80),18,nMT,G2H12(57),n2h12(85))
  call Hloop_QA_W(ntryL,G1H24(99),ex2(:),G1H12(80),m3h2x12(:,145),heltab2x24(:,:,145))
  call Hloop_WA_Q(ntryL,G1H24(100),ex2(:),G1H12(81),m3h2x12(:,146),heltab2x24(:,:,146))
  call Hloop_A_Q(ntryL,G1H12(81),18,nMT,G2H12(58),n2h12(86))
  call Hloop_SA_Q(ntryL,G0H24(53),ex2(:),G0H12(9),ngPbt,m3h2x12(:,147),heltab2x24(:,:,147))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(81),n2h12(87))
  call Hloop_ZA_Q(ntryL,G0H24(54),ex2(:),G0H12(9),ngZd,m3h2x12(:,148),heltab2x24(:,:,148))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMB,G1H12(82),n2h12(88))
  call Hloop_WA_Q(ntryL,G0H24(55),ex2(:),G0H12(9),m3h2x12(:,149),heltab2x24(:,:,149))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(83),n2h12(89))
  call Hloop_WA_Q(ntryL,G1H24(101),ex2(:),G1H12(84),m3h2x12(:,150),heltab2x24(:,:,150))
  call Hloop_A_Q(ntryL,G1H12(84),18,nMT,G2H12(59),n2h12(90))
  call Hloop_QA_S(ntryL,G1H24(102),ex2(:),G1H12(84),ngX,m3h2x12(:,151),heltab2x24(:,:,151))
  call Hloop_QA_S(ntryL,G1H24(103),ex2(:),G1H12(85),ngH,m3h2x12(:,152),heltab2x24(:,:,152))
  call Hloop_QA_S(ntryL,G1H24(104),ex2(:),G1H12(86),ngPbt,m3h2x12(:,153),heltab2x24(:,:,153))
  call Hloop_SA_Q(ntryL,G1H24(105),ex2(:),G1H12(87),ngPbt,m3h2x12(:,154),heltab2x24(:,:,154))
  call Hloop_A_Q(ntryL,G1H12(87),18,nMT,G2H12(60),n2h12(91))
  call Hloop_QA_Z(ntryL,G1H24(106),ex2(:),G1H12(87),ngZd,m3h2x12(:,155),heltab2x24(:,:,155))
  call Hloop_QA_W(ntryL,G1H24(107),ex2(:),G1H12(88),m3h2x12(:,156),heltab2x24(:,:,156))
  call Hloop_QA_S(ntryL,G1H24(108),ex2(:),G1H12(89),ngH,m3h2x12(:,157),heltab2x24(:,:,157))
  call Hloop_QA_S(ntryL,G1H24(109),ex2(:),G1H12(90),ngPbt,m3h2x12(:,158),heltab2x24(:,:,158))
  call Hloop_SA_Q(ntryL,G0H24(56),ex2(:),G0H12(9),ngPbt,m3h2x12(:,159),heltab2x24(:,:,159))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(91),n2h12(92))
  call Hloop_WA_Q(ntryL,G0H24(57),ex2(:),G0H12(9),m3h2x12(:,160),heltab2x24(:,:,160))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(92),n2h12(93))
  call Hloop_SA_Q(ntryL,G1H24(110),ex2(:),G1H12(93),ngPbt,m3h2x12(:,161),heltab2x24(:,:,161))
  call Hloop_A_Q(ntryL,G1H12(93),18,nMT,G2H12(61),n2h12(94))
  call Hloop_QA_W(ntryL,G1H24(111),ex2(:),G1H12(93),m3h2x12(:,162),heltab2x24(:,:,162))
  call Hloop_WA_Q(ntryL,G1H24(112),ex2(:),G1H12(94),m3h2x12(:,163),heltab2x24(:,:,163))
  call Hloop_A_Q(ntryL,G1H12(94),18,nMT,G2H12(62),n2h12(95))
  call Hloop_SA_Q(ntryL,G0H24(58),ex2(:),G0H12(9),ngPbt,m3h2x12(:,164),heltab2x24(:,:,164))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(94),n2h12(96))
  call Hloop_WA_Q(ntryL,G0H24(59),ex2(:),G0H12(9),m3h2x12(:,165),heltab2x24(:,:,165))
  call Hloop_A_Q(ntryL,G0H12(9),18,nMT,G1H12(95),n2h12(97))
  call Hloop_WA_Q(ntryL,G1H24(113),ex2(:),G1H12(96),m3h2x12(:,166),heltab2x24(:,:,166))
  call Hloop_A_Q(ntryL,G1H12(96),18,nMT,G2H12(63),n2h12(98))
  call Hloop_AQ_S(ntryL,G1H24(114),ex1(:),G1H12(96),ngPtb,m3h2x12(:,167),heltab2x24(:,:,167))
  call Hloop_SQ_A(ntryL,G1H24(115),ex1(:),G1H12(97),ngH,m3h2x12(:,168),heltab2x24(:,:,168))
  call Hloop_Q_A(ntryL,G1H12(97),17,nMB,G2H12(64),n2h12(99))
  call Hloop_SQ_A(ntryL,G1H24(116),ex1(:),G1H12(97),ngX,m3h2x12(:,169),heltab2x24(:,:,169))
  call Hloop_Q_A(ntryL,G1H12(97),17,nMB,G2H12(65),n2h12(100))
  call Hloop_SQ_A(ntryL,G1H24(117),ex1(:),G1H12(97),ngPtb,m3h2x12(:,170),heltab2x24(:,:,170))
  call Hloop_Q_A(ntryL,G1H12(97),17,nMT,G2H12(66),n2h12(101))
  call Hloop_AQ_S(ntryL,G1H24(118),ex1(:),G1H12(97),ngPtb,m3h2x12(:,171),heltab2x24(:,:,171))
  call Hloop_AQ_W(ntryL,G1H24(119),ex1(:),G1H12(98),m3h2x12(:,172),heltab2x24(:,:,172))
  call Hloop_SQ_A(ntryL,G0H24(60),ex1(:),G0H12(9),ngH,m3h2x12(:,173),heltab2x24(:,:,173))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMB,G1H12(99),n2h12(102))
  call Hloop_SQ_A(ntryL,G0H24(61),ex1(:),G0H12(9),ngPtb,m3h2x12(:,174),heltab2x24(:,:,174))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(100),n2h12(103))
  call Hloop_SQ_A(ntryL,G1H24(120),ex1(:),G1H12(101),ngX,m3h2x12(:,175),heltab2x24(:,:,175))
  call Hloop_Q_A(ntryL,G1H12(101),17,nMB,G2H12(67),n2h12(104))
  call Hloop_SQ_A(ntryL,G1H24(121),ex1(:),G1H12(101),ngPtb,m3h2x12(:,176),heltab2x24(:,:,176))
  call Hloop_Q_A(ntryL,G1H12(101),17,nMT,G2H12(68),n2h12(105))
  call Hloop_ZQ_A(ntryL,G0H24(62),ex1(:),G0H12(9),ngZd,m3h2x12(:,177),heltab2x24(:,:,177))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMB,G1H12(101),n2h12(106))
  call Hloop_WQ_A(ntryL,G0H24(63),ex1(:),G0H12(9),m3h2x12(:,178),heltab2x24(:,:,178))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(102),n2h12(107))
  call Hloop_AQ_W(ntryL,G1H24(122),ex1(:),G1H12(103),m3h2x12(:,179),heltab2x24(:,:,179))
  call Hloop_SQ_A(ntryL,G0H24(64),ex1(:),G0H12(9),ngPtb,m3h2x12(:,180),heltab2x24(:,:,180))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(104),n2h12(108))
  call Hloop_WQ_A(ntryL,G1H24(123),ex1(:),G1H12(105),m3h2x12(:,181),heltab2x24(:,:,181))
  call Hloop_Q_A(ntryL,G1H12(105),17,nMT,G2H12(69),n2h12(109))
  call Hloop_ZQ_A(ntryL,G0H24(65),ex1(:),G0H12(9),ngZd,m3h2x12(:,182),heltab2x24(:,:,182))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMB,G1H12(105),n2h12(110))
  call Hloop_WQ_A(ntryL,G0H24(66),ex1(:),G0H12(9),m3h2x12(:,183),heltab2x24(:,:,183))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(106),n2h12(111))
  call Hloop_WQ_A(ntryL,G1H24(124),ex1(:),G1H12(107),m3h2x12(:,184),heltab2x24(:,:,184))
  call Hloop_Q_A(ntryL,G1H12(107),17,nMT,G2H12(70),n2h12(112))
  call Hloop_SQ_A(ntryL,G1H24(125),ex1(:),G1H12(107),ngH,m3h2x12(:,185),heltab2x24(:,:,185))
  call Hloop_Q_A(ntryL,G1H12(107),17,nMB,G2H12(71),n2h12(113))
  call Hloop_SQ_A(ntryL,G1H24(126),ex1(:),G1H12(107),ngX,m3h2x12(:,186),heltab2x24(:,:,186))
  call Hloop_Q_A(ntryL,G1H12(107),17,nMB,G2H12(72),n2h12(114))
  call Hloop_SQ_A(ntryL,G1H24(127),ex1(:),G1H12(107),ngPtb,m3h2x12(:,187),heltab2x24(:,:,187))
  call Hloop_Q_A(ntryL,G1H12(107),17,nMT,G2H12(73),n2h12(115))
  call Hloop_AQ_S(ntryL,G1H24(128),ex1(:),G1H12(107),ngPtb,m3h2x12(:,188),heltab2x24(:,:,188))
  call Hloop_SQ_A(ntryL,G0H24(67),ex1(:),G0H12(9),ngH,m3h2x12(:,189),heltab2x24(:,:,189))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMB,G1H12(108),n2h12(116))
  call Hloop_SQ_A(ntryL,G0H24(68),ex1(:),G0H12(9),ngPtb,m3h2x12(:,190),heltab2x24(:,:,190))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(109),n2h12(117))
  call Hloop_ZQ_A(ntryL,G0H24(69),ex1(:),G0H12(9),ngZd,m3h2x12(:,191),heltab2x24(:,:,191))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMB,G1H12(110),n2h12(118))
  call Hloop_WQ_A(ntryL,G0H24(70),ex1(:),G0H12(9),m3h2x12(:,192),heltab2x24(:,:,192))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(111),n2h12(119))
  call Hloop_AQ_S(ntryL,G1H24(129),ex1(:),G1H12(112),ngPtb,m3h2x12(:,193),heltab2x24(:,:,193))
  call Hloop_AQ_S(ntryL,G1H24(130),ex1(:),G1H12(113),ngPtb,m3h2x12(:,194),heltab2x24(:,:,194))
  call Hloop_AQ_W(ntryL,G1H24(131),ex1(:),G1H12(114),m3h2x12(:,195),heltab2x24(:,:,195))
  call Hloop_WQ_A(ntryL,G1H24(132),ex1(:),G1H12(115),m3h2x12(:,196),heltab2x24(:,:,196))
  call Hloop_Q_A(ntryL,G1H12(115),17,nMT,G2H12(74),n2h12(120))
  call Hloop_AQ_S(ntryL,G1H24(133),ex1(:),G1H12(115),ngPtb,m3h2x12(:,197),heltab2x24(:,:,197))
  call Hloop_AQ_W(ntryL,G1H24(134),ex1(:),G1H12(116),m3h2x12(:,198),heltab2x24(:,:,198))
  call Hloop_AQ_W(ntryL,G1H24(135),ex1(:),G1H12(117),m3h2x12(:,199),heltab2x24(:,:,199))
  call Hloop_AQ_W(ntryL,G1H24(136),ex1(:),G1H12(118),m3h2x12(:,200),heltab2x24(:,:,200))
  call Hloop_AQ_S(ntryL,G1H24(137),ex1(:),G1H12(119),ngH,m3h2x12(:,201),heltab2x24(:,:,201))
  call Hloop_AQ_S(ntryL,G1H24(138),ex1(:),G1H12(120),ngX,m3h2x12(:,202),heltab2x24(:,:,202))
  call Hloop_AQ_S(ntryL,G1H24(139),ex1(:),G1H12(121),ngPtb,m3h2x12(:,203),heltab2x24(:,:,203))
  call Hloop_SQ_A(ntryL,G1H24(140),ex1(:),G1H12(122),ngPtb,m3h2x12(:,204),heltab2x24(:,:,204))
  call Hloop_Q_A(ntryL,G1H12(122),17,nMT,G2H12(75),n2h12(121))
  call Hloop_AQ_S(ntryL,G1H24(141),ex1(:),G1H12(122),ngH,m3h2x12(:,205),heltab2x24(:,:,205))
  call Hloop_AQ_S(ntryL,G1H24(142),ex1(:),G1H12(123),ngPtb,m3h2x12(:,206),heltab2x24(:,:,206))
  call Hloop_AQ_Z(ntryL,G1H24(143),ex1(:),G1H12(124),ngZd,m3h2x12(:,207),heltab2x24(:,:,207))
  call Hloop_AQ_W(ntryL,G1H24(144),ex1(:),G1H12(125),m3h2x12(:,208),heltab2x24(:,:,208))
  call Hloop_SQ_A(ntryL,G0H24(71),ex1(:),G0H12(9),ngPtb,m3h2x12(:,209),heltab2x24(:,:,209))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(126),n2h12(122))
  call Hloop_SQ_A(ntryL,G1H24(145),ex1(:),G1H12(127),ngPtb,m3h2x12(:,210),heltab2x24(:,:,210))
  call Hloop_Q_A(ntryL,G1H12(127),17,nMT,G2H12(76),n2h12(123))
  call Hloop_WQ_A(ntryL,G0H24(72),ex1(:),G0H12(9),m3h2x12(:,211),heltab2x24(:,:,211))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(127),n2h12(124))
  call Hloop_AQ_W(ntryL,G1H24(146),ex1(:),G1H12(128),m3h2x12(:,212),heltab2x24(:,:,212))
  call Hloop_SQ_A(ntryL,G0H24(73),ex1(:),G0H12(9),ngPtb,m3h2x12(:,213),heltab2x24(:,:,213))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(129),n2h12(125))
  call Hloop_WQ_A(ntryL,G1H24(147),ex1(:),G1H12(130),m3h2x12(:,214),heltab2x24(:,:,214))
  call Hloop_Q_A(ntryL,G1H12(130),17,nMT,G2H12(77),n2h12(126))
  call Hloop_WQ_A(ntryL,G0H24(74),ex1(:),G0H12(9),m3h2x12(:,215),heltab2x24(:,:,215))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(130),n2h12(127))
  call Hloop_WQ_A(ntryL,G1H24(148),ex1(:),G1H12(131),m3h2x12(:,216),heltab2x24(:,:,216))
  call Hloop_Q_A(ntryL,G1H12(131),17,nMT,G2H12(78),n2h12(128))
  call Hloop_SQ_A(ntryL,G1H24(149),ex1(:),G1H12(131),ngH,m3h2x12(:,217),heltab2x24(:,:,217))
  call Hloop_Q_A(ntryL,G1H12(131),17,nMB,G2H12(79),n2h12(129))
  call Hloop_SQ_A(ntryL,G1H24(150),ex1(:),G1H12(131),ngX,m3h2x12(:,218),heltab2x24(:,:,218))
  call Hloop_Q_A(ntryL,G1H12(131),17,nMB,G2H12(80),n2h12(130))
  call Hloop_SQ_A(ntryL,G1H24(151),ex1(:),G1H12(131),ngPtb,m3h2x12(:,219),heltab2x24(:,:,219))
  call Hloop_Q_A(ntryL,G1H12(131),17,nMT,G2H12(81),n2h12(131))
  call Hloop_AQ_S(ntryL,G1H24(152),ex1(:),G1H12(131),ngPtb,m3h2x12(:,220),heltab2x24(:,:,220))
  call Hloop_SQ_A(ntryL,G0H24(75),ex1(:),G0H12(9),ngH,m3h2x12(:,221),heltab2x24(:,:,221))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMB,G1H12(132),n2h12(132))
  call Hloop_SQ_A(ntryL,G0H24(76),ex1(:),G0H12(9),ngPtb,m3h2x12(:,222),heltab2x24(:,:,222))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(133),n2h12(133))
  call Hloop_ZQ_A(ntryL,G0H24(77),ex1(:),G0H12(9),ngZd,m3h2x12(:,223),heltab2x24(:,:,223))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMB,G1H12(134),n2h12(134))
  call Hloop_WQ_A(ntryL,G0H24(78),ex1(:),G0H12(9),m3h2x12(:,224),heltab2x24(:,:,224))
  call Hloop_Q_A(ntryL,G0H12(9),17,nMT,G1H12(135),n2h12(135))
  call Hloop_AQ_S(ntryL,G1H24(153),ex1(:),G1H12(136),ngPtb,m3h2x12(:,225),heltab2x24(:,:,225))
  call Hloop_AQ_S(ntryL,G1H24(154),ex1(:),G1H12(137),ngPtb,m3h2x12(:,226),heltab2x24(:,:,226))
  call Hloop_AQ_W(ntryL,G1H24(155),ex1(:),G1H12(138),m3h2x12(:,227),heltab2x24(:,:,227))
  call Hloop_WQ_A(ntryL,G1H24(156),ex1(:),G1H12(139),m3h2x12(:,228),heltab2x24(:,:,228))
  call Hloop_Q_A(ntryL,G1H12(139),17,nMT,G2H12(82),n2h12(136))
  call Hloop_AQ_S(ntryL,G1H24(157),ex1(:),G1H12(139),ngPtb,m3h2x12(:,229),heltab2x24(:,:,229))
  call Hloop_AQ_W(ntryL,G1H24(158),ex1(:),G1H12(140),m3h2x12(:,230),heltab2x24(:,:,230))
  call Hloop_AQ_W(ntryL,G1H24(159),ex1(:),G1H12(141),m3h2x12(:,231),heltab2x24(:,:,231))
  call Hloop_AQ_W(ntryL,G1H24(160),ex1(:),G1H12(142),m3h2x12(:,232),heltab2x24(:,:,232))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(4),[G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(3),[G1H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G0H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(5),[G1H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(7),[G1H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(9),[G0H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(8),[G1H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(10),[G0H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(11),[G1H12(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(14),[G1H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(12),[G1H12(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(13),[G1H12(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(16),[G1H12(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(17),[G1H12(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(15),[G1H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(18),[G1H12(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(22),[G0H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(25),[G1H12(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(26),[G1H12(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(26),[G0H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(27),[G0H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(29),[G1H12(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(30),[G1H12(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(28),[G0H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(29),[G1H12(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(32),[G1H12(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(30),[G1H12(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(31),[G1H12(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(34),[G1H12(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(35),[G1H12(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(33),[G1H12(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(36),[G1H12(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(37),[G1H12(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(41),[G1H12(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(38),[G1H12(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(39),[G1H12(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(42),[G1H12(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(43),[G1H12(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(40),[G1H12(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(44),[G1H12(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(45),[G1H12(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(49),[G1H12(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(46),[G1H12(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(47),[G1H12(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(50),[G1H12(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(51),[G1H12(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(48),[G1H12(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(52),[G1H12(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(54),[G1H12(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(55),[G1H12(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(58),[G1H12(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(56),[G1H12(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(57),[G1H12(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(59),[G1H12(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(60),[G1H12(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(62),[G1H12(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(61),[G1H12(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(63),[G1H12(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(65),[G1H12(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(66),[G1H12(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(69),[G1H12(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(67),[G1H12(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(68),[G1H12(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(70),[G1H12(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(72),[G1H12(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(73),[G1H12(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(74),[G1H12(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(75),[G1H12(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(77),[G1H12(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(76),[G1H12(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(78),[G1H12(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(80),[G1H12(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(81),[G1H12(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(82),[G1H12(133)])
  call Hloop_AQ_S(ntryL,G2H12(1),ex1(:),G2H6(1),ngH,m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_S(ntryL,G2H12(2),ex1(:),G2H6(2),ngX,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_AQ_S(ntryL,G2H12(3),ex1(:),G2H6(3),ngPtb,m3h2x6(:,3),heltab2x12(:,:,3))
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(1),mass5set(:,1),  & 
G1H12(1),G1H12(2),G1H12(4),G1H12(6),G1H12(16),G1H12(15),12)
  call HG1shiftOLR(G1H12(2),8,12)
  call Hloop_AQ_V(ntryL,G2H12(5),ex1(:),G2H6(4),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_AQ_Z(ntryL,G2H12(6),ex1(:),G2H6(5),ngZd,m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_AQ_W(ntryL,G2H12(7),ex1(:),G2H6(6),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_SQ_A(ntryL,G1H12(3),ex1(:),G1H6(1),ngPtb,m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMT,G2H6(7),n2h6(1))
  call Hotf_5pt_reduction(G2H12(8),RedSet_5(1),mass5set(:,1),  & 
G1H12(18),G1H12(20),G1H12(17),G1H12(19),G1H12(22),G1H12(21),12)
  call HG1shiftOLR(G1H12(20),8,12)
  call Hloop_WQ_A(ntryL,G1H12(5),ex1(:),G1H6(1),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMT,G2H6(8),n2h6(2))
  call Hloop_SQ_A(ntryL,G1H12(7),ex1(:),G1H6(1),ngPtb,m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMT,G2H6(9),n2h6(3))
  call Hotf_5pt_reduction(G2H12(9),RedSet_5(1),mass5set(:,1),  & 
G1H12(23),G1H12(24),G1H12(27),G1H12(28),G1H12(38),G1H12(37),12)
  call HG1shiftOLR(G1H12(24),8,12)
  call Hloop_WQ_A(ntryL,G1H12(8),ex1(:),G1H6(1),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMT,G2H6(10),n2h6(4))
  call Hotf_5pt_reduction(G2H12(10),RedSet_5(1),mass5set(:,1),  & 
G1H12(40),G1H12(42),G1H12(39),G1H12(41),G1H12(44),G1H12(43),12)
  call HG1shiftOLR(G1H12(42),8,12)
  call Hloop_SQ_A(ntryL,G1H12(9),ex1(:),G1H6(1),ngH,m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(11),n2h6(5))
  call Hloop_SQ_A(ntryL,G1H12(10),ex1(:),G1H6(1),ngX,m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(12),n2h6(6))
  call Hloop_SQ_A(ntryL,G1H12(11),ex1(:),G1H6(1),ngPtb,m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(13),n2h6(7))
  call Hloop_AQ_S(ntryL,G2H12(11),ex1(:),G2H6(14),ngPtb,m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_VQ_A(ntryL,G1H12(12),ex1(:),G1H6(1),m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(15),n2h6(8))
  call Hloop_ZQ_A(ntryL,G1H12(13),ex1(:),G1H6(1),ngZd,m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(16),n2h6(9))
  call Hloop_WQ_A(ntryL,G1H12(14),ex1(:),G1H6(1),m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(17),n2h6(10))
  call Hloop_AQ_S(ntryL,G2H12(14),ex1(:),G2H6(18),ngPtb,m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_AQ_S(ntryL,G2H12(12),ex1(:),G2H6(19),ngPtb,m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_AQ_W(ntryL,G2H12(13),ex1(:),G2H6(20),m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_AQ_S(ntryL,G2H12(16),ex1(:),G2H6(21),ngPtb,m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_AQ_W(ntryL,G2H12(17),ex1(:),G2H6(22),m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_AQ_W(ntryL,G2H12(15),ex1(:),G2H6(23),m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_AQ_W(ntryL,G2H12(18),ex1(:),G2H6(24),m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_QA_S(ntryL,G2H12(19),ex2(:),G2H6(25),ngH,m3h2x6(:,25),heltab2x12(:,:,25))
  call Hloop_QA_S(ntryL,G2H12(20),ex2(:),G2H6(26),ngX,m3h2x6(:,26),heltab2x12(:,:,26))
  call Hloop_QA_S(ntryL,G2H12(21),ex2(:),G2H6(27),ngPbt,m3h2x6(:,27),heltab2x12(:,:,27))
  call Hotf_5pt_reduction(G2H12(22),RedSet_5(2),mass5set(:,1),  & 
G1H12(52),G1H12(51),G1H12(55),G1H12(56),G1H12(53),G1H12(54),12)
  call HG1shiftOLR(G1H12(51),8,12)
  call Hloop_QA_V(ntryL,G2H12(23),ex2(:),G2H6(28),m3h2x6(:,28),heltab2x12(:,:,28))
  call Hloop_QA_Z(ntryL,G2H12(24),ex2(:),G2H6(29),ngZd,m3h2x6(:,29),heltab2x12(:,:,29))
  call Hloop_QA_W(ntryL,G2H12(25),ex2(:),G2H6(30),m3h2x6(:,30),heltab2x12(:,:,30))
  call Hloop_SA_Q(ntryL,G1H12(25),ex2(:),G1H6(1),ngPbt,m3h2x6(:,31),heltab2x12(:,:,31))
  call Hloop_A_Q(ntryL,G1H6(1),22,nMT,G2H6(31),n2h6(11))
  call Hloop_WA_Q(ntryL,G1H12(26),ex2(:),G1H6(1),m3h2x6(:,32),heltab2x12(:,:,32))
  call Hloop_A_Q(ntryL,G1H6(1),22,nMT,G2H6(32),n2h6(12))
  call Hotf_5pt_reduction(G2H12(26),RedSet_5(2),mass5set(:,1),  & 
G1H12(58),G1H12(57),G1H12(66),G1H12(65),G1H12(69),G1H12(70),12)
  call HG1shiftOLR(G1H12(57),8,12)
  call Hotf_5pt_reduction(G2H12(27),RedSet_5(2),mass5set(:,1),  & 
G1H12(67),G1H12(68),G1H12(72),G1H12(71),G1H12(78),G1H12(79),12)
  call HG1shiftOLR(G1H12(68),8,12)
  call Hloop_SA_Q(ntryL,G1H12(29),ex2(:),G1H6(1),ngPbt,m3h2x6(:,33),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H6(1),22,nMT,G2H6(33),n2h6(13))
  call Hloop_WA_Q(ntryL,G1H12(30),ex2(:),G1H6(1),m3h2x6(:,34),heltab2x12(:,:,34))
  call Hloop_A_Q(ntryL,G1H6(1),22,nMT,G2H6(34),n2h6(14))
  call Hotf_5pt_reduction(G2H12(28),RedSet_5(2),mass5set(:,1),  & 
G1H12(77),G1H12(82),G1H12(83),G1H12(81),G1H12(92),G1H12(91),12)
  call HG1shiftOLR(G1H12(82),8,12)
  call Hloop_SQ_A(ntryL,G1H12(31),ex1(:),G1H6(1),ngH,m3h2x6(:,35),heltab2x12(:,:,35))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(35),n2h6(15))
  call Hloop_SQ_A(ntryL,G1H12(32),ex1(:),G1H6(1),ngX,m3h2x6(:,36),heltab2x12(:,:,36))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(36),n2h6(16))
  call Hloop_SQ_A(ntryL,G1H12(33),ex1(:),G1H6(1),ngPtb,m3h2x6(:,37),heltab2x12(:,:,37))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(37),n2h6(17))
  call Hloop_AQ_S(ntryL,G2H12(29),ex1(:),G2H6(38),ngPtb,m3h2x6(:,38),heltab2x12(:,:,38))
  call Hloop_VQ_A(ntryL,G1H12(34),ex1(:),G1H6(1),m3h2x6(:,39),heltab2x12(:,:,39))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(39),n2h6(18))
  call Hloop_ZQ_A(ntryL,G1H12(35),ex1(:),G1H6(1),ngZd,m3h2x6(:,40),heltab2x12(:,:,40))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(40),n2h6(19))
  call Hloop_WQ_A(ntryL,G1H12(36),ex1(:),G1H6(1),m3h2x6(:,41),heltab2x12(:,:,41))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(41),n2h6(20))
  call Hloop_AQ_S(ntryL,G2H12(32),ex1(:),G2H6(42),ngPtb,m3h2x6(:,42),heltab2x12(:,:,42))
  call Hloop_AQ_S(ntryL,G2H12(30),ex1(:),G2H6(43),ngPtb,m3h2x6(:,43),heltab2x12(:,:,43))
  call Hloop_AQ_W(ntryL,G2H12(31),ex1(:),G2H6(44),m3h2x6(:,44),heltab2x12(:,:,44))
  call Hloop_AQ_S(ntryL,G2H12(34),ex1(:),G2H6(45),ngPtb,m3h2x6(:,45),heltab2x12(:,:,45))
  call Hloop_AQ_W(ntryL,G2H12(35),ex1(:),G2H6(46),m3h2x6(:,46),heltab2x12(:,:,46))
  call Hloop_AQ_W(ntryL,G2H12(33),ex1(:),G2H6(47),m3h2x6(:,47),heltab2x12(:,:,47))
  call Hloop_AQ_W(ntryL,G2H12(36),ex1(:),G2H6(48),m3h2x6(:,48),heltab2x12(:,:,48))
  call Hloop_SA_Q(ntryL,G1H12(45),ex2(:),G1H6(1),ngH,m3h2x6(:,49),heltab2x12(:,:,49))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(49),n2h6(21))
  call Hloop_SA_Q(ntryL,G1H12(46),ex2(:),G1H6(1),ngX,m3h2x6(:,50),heltab2x12(:,:,50))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(50),n2h6(22))
  call Hloop_SA_Q(ntryL,G1H12(47),ex2(:),G1H6(1),ngPbt,m3h2x6(:,51),heltab2x12(:,:,51))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(51),n2h6(23))
  call Hloop_QA_S(ntryL,G2H12(37),ex2(:),G2H6(52),ngPbt,m3h2x6(:,52),heltab2x12(:,:,52))
  call Hloop_VA_Q(ntryL,G1H12(48),ex2(:),G1H6(1),m3h2x6(:,53),heltab2x12(:,:,53))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(53),n2h6(24))
  call Hloop_ZA_Q(ntryL,G1H12(49),ex2(:),G1H6(1),ngZd,m3h2x6(:,54),heltab2x12(:,:,54))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(54),n2h6(25))
  call Hloop_WA_Q(ntryL,G1H12(50),ex2(:),G1H6(1),m3h2x6(:,55),heltab2x12(:,:,55))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(55),n2h6(26))
  call Hloop_QA_S(ntryL,G2H12(41),ex2(:),G2H6(56),ngPbt,m3h2x6(:,56),heltab2x12(:,:,56))
  call Hloop_QA_S(ntryL,G2H12(38),ex2(:),G2H6(57),ngPbt,m3h2x6(:,57),heltab2x12(:,:,57))
  call Hloop_QA_W(ntryL,G2H12(39),ex2(:),G2H6(58),m3h2x6(:,58),heltab2x12(:,:,58))
  call Hloop_QA_S(ntryL,G2H12(42),ex2(:),G2H6(59),ngPbt,m3h2x6(:,59),heltab2x12(:,:,59))
  call Hloop_QA_W(ntryL,G2H12(43),ex2(:),G2H6(60),m3h2x6(:,60),heltab2x12(:,:,60))
  call Hloop_QA_W(ntryL,G2H12(40),ex2(:),G2H6(61),m3h2x6(:,61),heltab2x12(:,:,61))
  call Hloop_QA_W(ntryL,G2H12(44),ex2(:),G2H6(62),m3h2x6(:,62),heltab2x12(:,:,62))
  call Hloop_SA_Q(ntryL,G1H12(59),ex2(:),G1H6(1),ngH,m3h2x6(:,63),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(63),n2h6(27))
  call Hloop_SA_Q(ntryL,G1H12(60),ex2(:),G1H6(1),ngX,m3h2x6(:,64),heltab2x12(:,:,64))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(64),n2h6(28))
  call Hloop_SA_Q(ntryL,G1H12(61),ex2(:),G1H6(1),ngPbt,m3h2x6(:,65),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(65),n2h6(29))
  call Hloop_QA_S(ntryL,G2H12(45),ex2(:),G2H6(66),ngPbt,m3h2x6(:,66),heltab2x12(:,:,66))
  call Hloop_VA_Q(ntryL,G1H12(62),ex2(:),G1H6(1),m3h2x6(:,67),heltab2x12(:,:,67))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(67),n2h6(30))
  call Hloop_ZA_Q(ntryL,G1H12(63),ex2(:),G1H6(1),ngZd,m3h2x6(:,68),heltab2x12(:,:,68))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(68),n2h6(31))
  call Hloop_WA_Q(ntryL,G1H12(64),ex2(:),G1H6(1),m3h2x6(:,69),heltab2x12(:,:,69))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(69),n2h6(32))
  call Hloop_QA_S(ntryL,G2H12(49),ex2(:),G2H6(70),ngPbt,m3h2x6(:,70),heltab2x12(:,:,70))
  call Hloop_QA_S(ntryL,G2H12(46),ex2(:),G2H6(71),ngPbt,m3h2x6(:,71),heltab2x12(:,:,71))
  call Hloop_QA_W(ntryL,G2H12(47),ex2(:),G2H6(72),m3h2x6(:,72),heltab2x12(:,:,72))
  call Hloop_QA_S(ntryL,G2H12(50),ex2(:),G2H6(73),ngPbt,m3h2x6(:,73),heltab2x12(:,:,73))
  call Hloop_QA_W(ntryL,G2H12(51),ex2(:),G2H6(74),m3h2x6(:,74),heltab2x12(:,:,74))
  call Hloop_QA_W(ntryL,G2H12(48),ex2(:),G2H6(75),m3h2x6(:,75),heltab2x12(:,:,75))
  call Hloop_QA_W(ntryL,G2H12(52),ex2(:),G2H6(76),m3h2x6(:,76),heltab2x12(:,:,76))
  call Hloop_SV_T(ntryL,G1H12(73),18,ex3(:),4,G2H6(77),m3h2x6(:,77),heltab2x12(:,:,77))
  call Hotf_5pt_reduction(G2H12(53),RedSet_5(3),mass5set(:,2),  & 
G1H12(95),G1H12(94),G1H12(101),G1H12(102),G1H12(100),G1H12(105),12)
  call HG1shiftOLR(G1H12(94),8,12)
  call Hotf_5pt_reduction(G2H12(54),RedSet_5(3),mass5set(:,3),  & 
G1H12(106),G1H12(104),G1H12(110),G1H12(111),G1H12(109),G1H12(127),12)
  call HG1shiftOLR(G1H12(104),8,12)
  call Hotf_5pt_reduction(G2H12(55),RedSet_5(3),mass5set(:,4),  & 
G1H12(126),G1H12(130),G1H12(129),G1H12(134),G1H12(135),G1H12(133),12)
  call HG1shiftOLR(G1H12(130),8,12)
  call Hloop_VV_S(ntryL,G1H12(74),ex3(:),G1H6(1),m3h2x6(:,78),heltab2x12(:,:,78))
  call Hloop_SV_V(ntryL,G1H12(75),ex3(:),G1H6(2),m3h2x6(:,79),heltab2x12(:,:,79))
  call Hloop_AV_Q(ntryL,G1H12(76),ex3(:),G1H6(3),m3h2x6(:,80),heltab2x12(:,:,80))
  call Hloop_A_Q(ntryL,G1H6(3),22,nMB,G2H6(78),n2h6(33))
  call Hotf_5pt_reduction(G2H12(58),RedSet_5(3),mass5set(:,4),  & 
G1H12(3),G1H12(5),G1H12(7),G1H12(8),G1H12(9),G1H12(10),12)
  call HG1shiftOLR(G1H12(5),8,12)
  call Hotf_5pt_reduction(G2H12(56),RedSet_5(3),mass5set(:,3),  & 
G1H12(11),G1H12(12),G1H12(13),G1H12(14),G1H12(25),G1H12(26),12)
  call HG1shiftOLR(G1H12(12),8,12)
  call Hotf_5pt_reduction(G2H12(57),RedSet_5(3),mass5set(:,4),  & 
G1H12(29),G1H12(30),G1H12(31),G1H12(32),G1H12(33),G1H12(34),12)
  call HG1shiftOLR(G1H12(30),8,12)
  call Hloop_UW_V(ntryL,G1H12(80),18,ex3(:),4,G2H6(79),m3h2x6(:,81),heltab2x12(:,:,81))
  call Hotf_5pt_reduction(G2H12(59),RedSet_5(3),mass5set(:,4),  & 
G1H12(35),G1H12(36),G1H12(45),G1H12(46),G1H12(47),G1H12(48),12)
  call HG1shiftOLR(G1H12(36),8,12)
  call Hloop_SV_T(ntryL,G1H12(84),18,ex4(:),8,G2H4(1),m3h3x4(:,1),heltab2x12(:,:,82))
  call Hloop_TV_S(ntryL,G1H12(85),18,ex4(:),8,G2H4(2),m3h3x4(:,2),heltab2x12(:,:,83))
  call Hloop_SV_T(ntryL,G1H12(86),18,ex4(:),8,G2H4(3),m3h3x4(:,3),heltab2x12(:,:,84))
  call Hotf_5pt_reduction(G2H12(60),RedSet_5(4),mass5set(:,4),  & 
G1H12(49),G1H12(50),G1H12(59),G1H12(60),G1H12(61),G1H12(62),12)
  call HG1shiftOLR(G1H12(50),4,12)
  call Hloop_VV_S(ntryL,G1H12(87),ex4(:),G1H4(1),m3h3x4(:,4),heltab2x12(:,:,85))
  call Hloop_VV_S(ntryL,G1H12(88),ex4(:),G1H4(2),m3h3x4(:,5),heltab2x12(:,:,86))
  call Hloop_SV_V(ntryL,G1H12(89),ex4(:),G1H4(3),m3h3x4(:,6),heltab2x12(:,:,87))
  call Hloop_SV_V(ntryL,G1H12(90),ex4(:),G1H4(4),m3h3x4(:,7),heltab2x12(:,:,88))
  call Hotf_5pt_reduction(G2H12(62),RedSet_5(4),mass5set(:,4),  & 
G1H12(63),G1H12(64),G1H12(73),G1H12(74),G1H12(75),G1H12(76),12)
  call HG1shiftOLR(G1H12(64),4,12)
  call Hotf_5pt_reduction(G2H12(61),RedSet_5(4),mass5set(:,4),  & 
G1H12(80),G1H12(84),G1H12(85),G1H12(86),G1H12(87),G1H12(88),12)
  call HG1shiftOLR(G1H12(84),4,12)
  call Hloop_UW_V(ntryL,G1H12(93),18,ex4(:),8,G2H4(4),m3h3x4(:,8),heltab2x12(:,:,89))
  call Hotf_5pt_reduction(G2H12(63),RedSet_5(4),mass5set(:,4),  & 
G1H12(89),G1H12(90),G1H12(93),G1H12(143),G1H12(144),G1H12(145),12)
  call HG1shiftOLR(G1H12(90),4,12)
  call Hloop_TV_S(ntryL,G1H12(96),17,ex3(:),4,G2H6(80),m3h2x6(:,82),heltab2x12(:,:,90))
  call Hotf_5pt_reduction(G2H12(64),RedSet_5(5),mass5set(:,2),  & 
G1H12(96),G1H12(146),G1H12(147),G1H12(148),G1H12(149),G1H12(150),12)
  call HG1shiftOLR(G1H12(146),8,12)
  call Hotf_5pt_reduction(G2H12(65),RedSet_5(5),mass5set(:,3),  & 
G1H12(151),G1H12(152),G1H12(153),G1H12(154),G1H12(155),G1H12(156),12)
  call HG1shiftOLR(G1H12(152),8,12)
  call Hotf_5pt_reduction(G2H12(66),RedSet_5(5),mass5set(:,4),  & 
G1H12(157),G1H12(158),G1H12(159),G1H12(160),G1H12(161),G1H12(162),12)
  call HG1shiftOLR(G1H12(158),8,12)
  call Hloop_SV_V(ntryL,G1H12(97),ex3(:),G1H6(3),m3h2x6(:,83),heltab2x12(:,:,91))
  call Hloop_VV_S(ntryL,G1H12(98),ex3(:),G1H6(4),m3h2x6(:,84),heltab2x12(:,:,92))
  call Hloop_QV_A(ntryL,G1H12(99),ex3(:),G1H6(5),m3h2x6(:,85),heltab2x12(:,:,93))
  call Hloop_Q_A(ntryL,G1H6(5),21,nMB,G2H6(81),n2h6(34))
  call Hotf_5pt_reduction(G2H12(69),RedSet_5(5),mass5set(:,4),  & 
G1H12(97),G1H12(98),G1H12(99),G1H12(163),G1H12(164),G1H12(165),12)
  call HG1shiftOLR(G1H12(98),8,12)
  call Hotf_5pt_reduction(G2H12(67),RedSet_5(5),mass5set(:,3),  & 
G1H12(166),G1H12(167),G1H12(168),G1H12(169),G1H12(170),G1H12(171),12)
  call HG1shiftOLR(G1H12(167),8,12)
  call Hotf_5pt_reduction(G2H12(68),RedSet_5(5),mass5set(:,4),  & 
G1H12(172),G1H12(173),G1H12(174),G1H12(175),G1H12(176),G1H12(177),12)
  call HG1shiftOLR(G1H12(173),8,12)
  call Hloop_UV_W(ntryL,G1H12(103),17,ex3(:),4,G2H6(82),m3h2x6(:,86),heltab2x12(:,:,94))
  call Hotf_5pt_reduction(G2H12(70),RedSet_5(5),mass5set(:,4),  & 
G1H12(103),G1H12(178),G1H12(179),G1H12(180),G1H12(181),G1H12(182),12)
  call HG1shiftOLR(G1H12(178),8,12)
  call Hotf_5pt_reduction(G2H12(71),RedSet_5(6),mass5set(:,5),  & 
G1H12(183),G1H12(184),G1H12(185),G1H12(186),G1H12(187),G1H12(188),12)
  call HG1shiftOLR(G1H12(184),2,12)
  call Hotf_5pt_reduction(G2H12(72),RedSet_5(6),mass5set(:,6),  & 
G1H12(189),G1H12(190),G1H12(191),G1H12(192),G1H12(193),G1H12(194),12)
  call HG1shiftOLR(G1H12(190),2,12)
  call Hotf_5pt_reduction(G2H12(73),RedSet_5(6),mass5set(:,7),  & 
G1H12(195),G1H12(196),G1H12(197),G1H12(198),G1H12(199),G1H12(200),12)
  call HG1shiftOLR(G1H12(196),2,12)
  call Hloop_TV_S(ntryL,G1H12(107),17,ex3(:),4,G2H6(83),m3h2x6(:,87),heltab2x12(:,:,95))
  call Hloop_QV_A(ntryL,G1H12(108),ex3(:),G1H6(5),m3h2x6(:,88),heltab2x12(:,:,96))
  call Hloop_Q_A(ntryL,G1H6(5),21,nMB,G2H6(84),n2h6(35))
  call Hotf_5pt_reduction(G2H12(74),RedSet_5(6),mass5set(:,7),  & 
G1H12(107),G1H12(108),G1H12(201),G1H12(202),G1H12(203),G1H12(204),12)
  call HG1shiftOLR(G1H12(108),2,12)
  call Hloop_SV_V(ntryL,G1H12(112),ex3(:),G1H6(5),m3h2x6(:,89),heltab2x12(:,:,97))
  call Hloop_TV_S(ntryL,G1H12(113),17,ex3(:),4,G2H6(85),m3h2x6(:,90),heltab2x12(:,:,98))
  call Hloop_VV_S(ntryL,G1H12(114),ex3(:),G1H6(6),m3h2x6(:,91),heltab2x12(:,:,99))
  call Hloop_SV_V(ntryL,G1H12(115),ex3(:),G1H6(7),m3h2x6(:,92),heltab2x12(:,:,100))
  call Hloop_UV_W(ntryL,G1H12(116),17,ex3(:),4,G2H6(86),m3h2x6(:,93),heltab2x12(:,:,101))
  call Hloop_VV_S(ntryL,G1H12(117),ex3(:),G1H6(8),m3h2x6(:,94),heltab2x12(:,:,102))
  call Hloop_UV_W(ntryL,G1H12(118),17,ex3(:),4,G2H6(87),m3h2x6(:,95),heltab2x12(:,:,103))
  call Hloop_TV_S(ntryL,G1H12(119),17,ex4(:),8,G2H4(5),m3h3x4(:,9),heltab2x12(:,:,104))
  call Hloop_SV_T(ntryL,G1H12(120),17,ex4(:),8,G2H4(6),m3h3x4(:,10),heltab2x12(:,:,105))
  call Hloop_TV_S(ntryL,G1H12(121),17,ex4(:),8,G2H4(7),m3h3x4(:,11),heltab2x12(:,:,106))
  call Hotf_5pt_reduction(G2H12(75),RedSet_5(7),mass5set(:,4),  & 
G1H12(112),G1H12(113),G1H12(114),G1H12(115),G1H12(116),G1H12(117),12)
  call HG1shiftOLR(G1H12(113),4,12)
  call Hloop_SV_V(ntryL,G1H12(122),ex4(:),G1H4(5),m3h3x4(:,12),heltab2x12(:,:,107))
  call Hloop_SV_V(ntryL,G1H12(123),ex4(:),G1H4(6),m3h3x4(:,13),heltab2x12(:,:,108))
  call Hloop_VV_S(ntryL,G1H12(124),ex4(:),G1H4(7),m3h3x4(:,14),heltab2x12(:,:,109))
  call Hloop_VV_S(ntryL,G1H12(125),ex4(:),G1H4(8),m3h3x4(:,15),heltab2x12(:,:,110))
  call Hotf_5pt_reduction(G2H12(77),RedSet_5(7),mass5set(:,4),  & 
G1H12(118),G1H12(119),G1H12(120),G1H12(121),G1H12(122),G1H12(123),12)
  call HG1shiftOLR(G1H12(119),4,12)
  call Hotf_5pt_reduction(G2H12(76),RedSet_5(7),mass5set(:,4),  & 
G1H12(124),G1H12(125),G1H12(205),G1H12(206),G1H12(207),G1H12(208),12)
  call HG1shiftOLR(G1H12(125),4,12)
  call Hloop_UV_W(ntryL,G1H12(128),17,ex4(:),8,G2H4(8),m3h3x4(:,16),heltab2x12(:,:,111))
  call Hotf_5pt_reduction(G2H12(78),RedSet_5(7),mass5set(:,4),  & 
G1H12(128),G1H12(209),G1H12(210),G1H12(211),G1H12(212),G1H12(213),12)
  call HG1shiftOLR(G1H12(209),4,12)
  call Hotf_5pt_reduction(G2H12(79),RedSet_5(8),mass5set(:,5),  & 
G1H12(214),G1H12(215),G1H12(216),G1H12(217),G1H12(218),G1H12(219),12)
  call HG1shiftOLR(G1H12(215),2,12)
  call Hotf_5pt_reduction(G2H12(80),RedSet_5(8),mass5set(:,6),  & 
G1H12(220),G1H12(221),G1H12(222),G1H12(223),G1H12(224),G1H12(225),12)
  call HG1shiftOLR(G1H12(221),2,12)
  call Hotf_5pt_reduction(G2H12(81),RedSet_5(8),mass5set(:,7),  & 
G1H12(226),G1H12(227),G1H12(228),G1H12(229),G1H12(230),G1H12(231),12)
  call HG1shiftOLR(G1H12(227),2,12)
  call Hloop_TV_S(ntryL,G1H12(131),17,ex4(:),8,G2H4(9),m3h3x4(:,17),heltab2x12(:,:,112))
  call Hloop_QZ_A(ntryL,G1H12(132),ex4(:),G1H4(9),ngZd,m3h3x4(:,18),heltab2x12(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(9),25,nMB,G2H4(10),n2h4(1))
  call Hotf_5pt_reduction(G2H12(82),RedSet_5(8),mass5set(:,7),  & 
G1H12(131),G1H12(132),G1H12(232),G1H12(233),G1H12(234),G1H12(235),12)
  call HG1shiftOLR(G1H12(132),2,12)
  call Hloop_SV_V(ntryL,G1H12(136),ex4(:),G1H4(9),m3h3x4(:,19),heltab2x12(:,:,114))
  call Hloop_TV_S(ntryL,G1H12(137),17,ex4(:),8,G2H4(11),m3h3x4(:,20),heltab2x12(:,:,115))
  call Hloop_VV_S(ntryL,G1H12(138),ex4(:),G1H4(10),m3h3x4(:,21),heltab2x12(:,:,116))
  call Hloop_SV_V(ntryL,G1H12(139),ex4(:),G1H4(11),m3h3x4(:,22),heltab2x12(:,:,117))
  call Hloop_UV_W(ntryL,G1H12(140),17,ex4(:),8,G2H4(12),m3h3x4(:,23),heltab2x12(:,:,118))
  call Hloop_VV_S(ntryL,G1H12(141),ex4(:),G1H4(12),m3h3x4(:,24),heltab2x12(:,:,119))
  call Hloop_UV_W(ntryL,G1H12(142),17,ex4(:),8,G2H4(13),m3h3x4(:,25),heltab2x12(:,:,120))
  call Hloop_SQ_A(ntryL,G1H12(1),ex1(:),G1H6(9),ngPtb,m3h2x6(:,96),heltab2x12(:,:,121))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(88),n2h6(36))
call HGT_OLR(G1H12(2),1,1,12)
call HGT_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(2),-8,ex4(:),8,G2H4(14),m3h3x4(:,26),heltab2x12(:,:,122))
  call Hloop_SQ_A(ntryL,G1H12(6),ex1(:),G1H6(9),ngPtb,m3h2x6(:,97),heltab2x12(:,:,123))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(89),n2h6(37))
  call Hloop_SQ_A(ntryL,G1H12(16),ex1(:),G1H6(9),ngPtb,m3h2x6(:,98),heltab2x12(:,:,124))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(90),n2h6(38))
  call Hloop_SQ_A(ntryL,G1H12(15),ex1(:),G1H6(9),ngPtb,m3h2x6(:,99),heltab2x12(:,:,125))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(91),n2h6(39))
  call Hloop_SQ_A(ntryL,G1H12(18),ex1(:),G1H6(9),ngPtb,m3h2x6(:,100),heltab2x12(:,:,126))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(92),n2h6(40))
call HGT_OLR(G1H12(20),1,1,12)
call HGT_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(20),ex4(:),G1H4(13),m3h3x4(:,27),heltab2x12(:,:,127))
  call Hloop_SQ_A(ntryL,G1H12(19),ex1(:),G1H6(9),ngPtb,m3h2x6(:,101),heltab2x12(:,:,128))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(93),n2h6(41))
  call Hloop_SQ_A(ntryL,G1H12(22),ex1(:),G1H6(9),ngPtb,m3h2x6(:,102),heltab2x12(:,:,129))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(94),n2h6(42))
  call Hloop_SQ_A(ntryL,G1H12(21),ex1(:),G1H6(9),ngPtb,m3h2x6(:,103),heltab2x12(:,:,130))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(95),n2h6(43))
  call Hloop_WQ_A(ntryL,G1H12(23),ex1(:),G1H6(9),m3h2x6(:,104),heltab2x12(:,:,131))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(96),n2h6(44))
call HGT_raise_alpha_OLR(G1H12(24),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(24),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(24),ex4(:),G1H4(14),m3h3x4(:,28),heltab2x12(:,:,132))
  call Hloop_WQ_A(ntryL,G1H12(28),ex1(:),G1H6(9),m3h2x6(:,105),heltab2x12(:,:,133))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(97),n2h6(45))
  call Hloop_WQ_A(ntryL,G1H12(38),ex1(:),G1H6(9),m3h2x6(:,106),heltab2x12(:,:,134))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(98),n2h6(46))
  call Hloop_WQ_A(ntryL,G1H12(37),ex1(:),G1H6(9),m3h2x6(:,107),heltab2x12(:,:,135))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(99),n2h6(47))
  call Hloop_WQ_A(ntryL,G1H12(40),ex1(:),G1H6(9),m3h2x6(:,108),heltab2x12(:,:,136))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(100),n2h6(48))
call HGT_raise_alpha_OLR(G1H12(42),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(42),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(42),-8,ex4(:),8,G2H4(15),m3h3x4(:,29),heltab2x12(:,:,137))
  call Hloop_WQ_A(ntryL,G1H12(41),ex1(:),G1H6(9),m3h2x6(:,109),heltab2x12(:,:,138))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(101),n2h6(49))
  call Hloop_WQ_A(ntryL,G1H12(44),ex1(:),G1H6(9),m3h2x6(:,110),heltab2x12(:,:,139))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(102),n2h6(50))
  call Hloop_WQ_A(ntryL,G1H12(43),ex1(:),G1H6(9),m3h2x6(:,111),heltab2x12(:,:,140))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMT,G2H6(103),n2h6(51))
  call Hloop_SA_Q(ntryL,G1H12(52),ex2(:),G1H6(9),ngPbt,m3h2x6(:,112),heltab2x12(:,:,141))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(104),n2h6(52))
call HGT_OLR(G1H12(51),1,1,12)
call HGT_invQ_OLR(G1H12(51),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(51),-8,ex4(:),8,G2H4(16),m3h3x4(:,30),heltab2x12(:,:,142))
  call Hloop_SA_Q(ntryL,G1H12(56),ex2(:),G1H6(9),ngPbt,m3h2x6(:,113),heltab2x12(:,:,143))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(105),n2h6(53))
  call Hloop_SA_Q(ntryL,G1H12(53),ex2(:),G1H6(9),ngPbt,m3h2x6(:,114),heltab2x12(:,:,144))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(106),n2h6(54))
  call Hloop_SA_Q(ntryL,G1H12(54),ex2(:),G1H6(9),ngPbt,m3h2x6(:,115),heltab2x12(:,:,145))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(107),n2h6(55))
  call Hloop_SA_Q(ntryL,G1H12(58),ex2(:),G1H6(9),ngPbt,m3h2x6(:,116),heltab2x12(:,:,146))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(108),n2h6(56))
call HGT_OLR(G1H12(57),1,1,12)
call HGT_invQ_OLR(G1H12(57),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(57),ex4(:),G1H4(15),m3h3x4(:,31),heltab2x12(:,:,147))
  call Hloop_SA_Q(ntryL,G1H12(65),ex2(:),G1H6(9),ngPbt,m3h2x6(:,117),heltab2x12(:,:,148))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(109),n2h6(57))
  call Hloop_SA_Q(ntryL,G1H12(69),ex2(:),G1H6(9),ngPbt,m3h2x6(:,118),heltab2x12(:,:,149))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(110),n2h6(58))
  call Hloop_SA_Q(ntryL,G1H12(70),ex2(:),G1H6(9),ngPbt,m3h2x6(:,119),heltab2x12(:,:,150))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(111),n2h6(59))
  call Hloop_WA_Q(ntryL,G1H12(67),ex2(:),G1H6(9),m3h2x6(:,120),heltab2x12(:,:,151))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(112),n2h6(60))
call HGT_raise_alpha_OLR(G1H12(68),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(68),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(68),ex4(:),G1H4(16),m3h3x4(:,32),heltab2x12(:,:,152))
  call Hloop_WA_Q(ntryL,G1H12(71),ex2(:),G1H6(9),m3h2x6(:,121),heltab2x12(:,:,153))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(113),n2h6(61))
  call Hloop_WA_Q(ntryL,G1H12(78),ex2(:),G1H6(9),m3h2x6(:,122),heltab2x12(:,:,154))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(114),n2h6(62))
  call Hloop_WA_Q(ntryL,G1H12(79),ex2(:),G1H6(9),m3h2x6(:,123),heltab2x12(:,:,155))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(115),n2h6(63))
  call Hloop_WA_Q(ntryL,G1H12(77),ex2(:),G1H6(9),m3h2x6(:,124),heltab2x12(:,:,156))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(116),n2h6(64))
call HGT_raise_alpha_OLR(G1H12(82),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(82),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(82),-8,ex4(:),8,G2H4(17),m3h3x4(:,33),heltab2x12(:,:,157))
  call Hloop_WA_Q(ntryL,G1H12(81),ex2(:),G1H6(9),m3h2x6(:,125),heltab2x12(:,:,158))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(117),n2h6(65))
  call Hloop_WA_Q(ntryL,G1H12(92),ex2(:),G1H6(9),m3h2x6(:,126),heltab2x12(:,:,159))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(118),n2h6(66))
  call Hloop_WA_Q(ntryL,G1H12(91),ex2(:),G1H6(9),m3h2x6(:,127),heltab2x12(:,:,160))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(119),n2h6(67))
  call Hloop_AV_Q(ntryL,G1H12(95),ex3(:),G1H6(9),m3h2x6(:,128),heltab2x12(:,:,161))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(120),n2h6(68))
call HGT_OLR(G1H12(94),1,1,12)
call HGT_invQ_OLR(G1H12(94),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(94),-8,ex4(:),8,G2H4(18),m3h3x4(:,34),heltab2x12(:,:,162))
  call Hloop_AV_Q(ntryL,G1H12(102),ex3(:),G1H6(9),m3h2x6(:,129),heltab2x12(:,:,163))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(121),n2h6(69))
  call Hloop_AV_Q(ntryL,G1H12(100),ex3(:),G1H6(9),m3h2x6(:,130),heltab2x12(:,:,164))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(122),n2h6(70))
  call Hloop_AV_Q(ntryL,G1H12(105),ex3(:),G1H6(9),m3h2x6(:,131),heltab2x12(:,:,165))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(123),n2h6(71))
  call Hloop_AV_Q(ntryL,G1H12(106),ex3(:),G1H6(9),m3h2x6(:,132),heltab2x12(:,:,166))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(124),n2h6(72))
call HGT_OLR(G1H12(104),1,1,12)
call HGT_invQ_OLR(G1H12(104),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(104),-8,ex4(:),8,G2H4(19),m3h3x4(:,35),heltab2x12(:,:,167))
  call Hloop_AV_Q(ntryL,G1H12(111),ex3(:),G1H6(9),m3h2x6(:,133),heltab2x12(:,:,168))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(125),n2h6(73))
  call Hloop_AV_Q(ntryL,G1H12(109),ex3(:),G1H6(9),m3h2x6(:,134),heltab2x12(:,:,169))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(126),n2h6(74))
  call Hloop_AV_Q(ntryL,G1H12(127),ex3(:),G1H6(9),m3h2x6(:,135),heltab2x12(:,:,170))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(127),n2h6(75))
  call Hloop_AV_Q(ntryL,G1H12(126),ex3(:),G1H6(9),m3h2x6(:,136),heltab2x12(:,:,171))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(128),n2h6(76))
call HGT_OLR(G1H12(130),1,1,12)
call HGT_invQ_OLR(G1H12(130),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(130),-8,ex4(:),8,G2H4(20),m3h3x4(:,36),heltab2x12(:,:,172))
  call Hloop_AV_Q(ntryL,G1H12(134),ex3(:),G1H6(9),m3h2x6(:,137),heltab2x12(:,:,173))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(129),n2h6(77))
  call Hloop_AV_Q(ntryL,G1H12(135),ex3(:),G1H6(9),m3h2x6(:,138),heltab2x12(:,:,174))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(130),n2h6(78))
  call Hloop_AV_Q(ntryL,G1H12(133),ex3(:),G1H6(9),m3h2x6(:,139),heltab2x12(:,:,175))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(131),n2h6(79))
  call Hloop_AV_Q(ntryL,G1H12(3),ex3(:),G1H6(9),m3h2x6(:,140),heltab2x12(:,:,176))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(132),n2h6(80))
call HGT_raise_alpha_OLR(G1H12(5),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(5),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(5),ex4(:),G1H4(17),m3h3x4(:,37),heltab2x12(:,:,177))
  call Hloop_AV_Q(ntryL,G1H12(8),ex3(:),G1H6(9),m3h2x6(:,141),heltab2x12(:,:,178))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(133),n2h6(81))
  call Hloop_AV_Q(ntryL,G1H12(9),ex3(:),G1H6(9),m3h2x6(:,142),heltab2x12(:,:,179))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(134),n2h6(82))
  call Hloop_AV_Q(ntryL,G1H12(10),ex3(:),G1H6(9),m3h2x6(:,143),heltab2x12(:,:,180))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(135),n2h6(83))
  call Hloop_AV_Q(ntryL,G1H12(11),ex3(:),G1H6(9),m3h2x6(:,144),heltab2x12(:,:,181))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(136),n2h6(84))
call HGT_OLR(G1H12(12),1,1,12)
call HGT_invQ_OLR(G1H12(12),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(12),ex4(:),G1H4(18),m3h3x4(:,38),heltab2x12(:,:,182))
  call Hloop_AV_Q(ntryL,G1H12(14),ex3(:),G1H6(9),m3h2x6(:,145),heltab2x12(:,:,183))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(137),n2h6(85))
  call Hloop_AV_Q(ntryL,G1H12(25),ex3(:),G1H6(9),m3h2x6(:,146),heltab2x12(:,:,184))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(138),n2h6(86))
  call Hloop_AV_Q(ntryL,G1H12(26),ex3(:),G1H6(9),m3h2x6(:,147),heltab2x12(:,:,185))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMB,G2H6(139),n2h6(87))
  call Hloop_AV_Q(ntryL,G1H12(29),ex3(:),G1H6(9),m3h2x6(:,148),heltab2x12(:,:,186))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(140),n2h6(88))
call HGT_OLR(G1H12(30),1,1,12)
call HGT_invQ_OLR(G1H12(30),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(30),ex4(:),G1H4(19),m3h3x4(:,39),heltab2x12(:,:,187))
  call Hloop_AV_Q(ntryL,G1H12(32),ex3(:),G1H6(9),m3h2x6(:,149),heltab2x12(:,:,188))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(141),n2h6(89))
  call Hloop_AV_Q(ntryL,G1H12(33),ex3(:),G1H6(9),m3h2x6(:,150),heltab2x12(:,:,189))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(142),n2h6(90))
  call Hloop_AV_Q(ntryL,G1H12(34),ex3(:),G1H6(9),m3h2x6(:,151),heltab2x12(:,:,190))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(143),n2h6(91))
  call Hloop_AV_Q(ntryL,G1H12(35),ex3(:),G1H6(9),m3h2x6(:,152),heltab2x12(:,:,191))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(144),n2h6(92))
call HGT_raise_alpha_OLR(G1H12(36),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(36),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(36),-8,ex4(:),8,G2H4(21),m3h3x4(:,40),heltab2x12(:,:,192))
  call Hloop_AV_Q(ntryL,G1H12(46),ex3(:),G1H6(9),m3h2x6(:,153),heltab2x12(:,:,193))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(145),n2h6(93))
  call Hloop_AV_Q(ntryL,G1H12(47),ex3(:),G1H6(9),m3h2x6(:,154),heltab2x12(:,:,194))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(146),n2h6(94))
  call Hloop_AV_Q(ntryL,G1H12(48),ex3(:),G1H6(9),m3h2x6(:,155),heltab2x12(:,:,195))
  call Hloop_A_Q(ntryL,G1H6(9),22,nMT,G2H6(147),n2h6(95))
  call Hloop_AZ_Q(ntryL,G1H12(49),ex4(:),G1H4(20),ngZu,m3h3x4(:,41),heltab2x12(:,:,196))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(22),n2h4(2))
call HGT_OLR(G1H12(50),1,1,12)
call HGT_invQ_OLR(G1H12(50),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(50),-4,ex3(:),4,G2H6(148),m3h2x6(:,156),heltab2x12(:,:,197))
  call Hloop_AZ_Q(ntryL,G1H12(60),ex4(:),G1H4(20),ngZu,m3h3x4(:,42),heltab2x12(:,:,198))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(23),n2h4(3))
  call Hloop_AZ_Q(ntryL,G1H12(61),ex4(:),G1H4(20),ngZu,m3h3x4(:,43),heltab2x12(:,:,199))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(24),n2h4(4))
  call Hloop_AZ_Q(ntryL,G1H12(62),ex4(:),G1H4(20),ngZu,m3h3x4(:,44),heltab2x12(:,:,200))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(25),n2h4(5))
  call Hloop_AZ_Q(ntryL,G1H12(63),ex4(:),G1H4(20),ngZu,m3h3x4(:,45),heltab2x12(:,:,201))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(26),n2h4(6))
call HGT_raise_alpha_OLR(G1H12(64),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(64),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(64),ex3(:),G1H6(9),m3h2x6(:,157),heltab2x12(:,:,202))
  call Hloop_AZ_Q(ntryL,G1H12(74),ex4(:),G1H4(20),ngZu,m3h3x4(:,46),heltab2x12(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(27),n2h4(7))
  call Hloop_AZ_Q(ntryL,G1H12(75),ex4(:),G1H4(20),ngZu,m3h3x4(:,47),heltab2x12(:,:,204))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(28),n2h4(8))
  call Hloop_AZ_Q(ntryL,G1H12(76),ex4(:),G1H4(20),ngZu,m3h3x4(:,48),heltab2x12(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(29),n2h4(9))
  call Hloop_AZ_Q(ntryL,G1H12(80),ex4(:),G1H4(20),ngZu,m3h3x4(:,49),heltab2x12(:,:,206))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(30),n2h4(10))
call HGT_OLR(G1H12(84),1,1,12)
call HGT_invQ_OLR(G1H12(84),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(84),ex3(:),G1H6(10),m3h2x6(:,158),heltab2x12(:,:,207))
  call Hloop_AZ_Q(ntryL,G1H12(86),ex4(:),G1H4(20),ngZu,m3h3x4(:,50),heltab2x12(:,:,208))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(31),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H12(87),ex4(:),G1H4(20),ngZu,m3h3x4(:,51),heltab2x12(:,:,209))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(32),n2h4(12))
  call Hloop_AZ_Q(ntryL,G1H12(88),ex4(:),G1H4(20),ngZu,m3h3x4(:,52),heltab2x12(:,:,210))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(33),n2h4(13))
  call Hloop_AZ_Q(ntryL,G1H12(89),ex4(:),G1H4(20),ngZu,m3h3x4(:,53),heltab2x12(:,:,211))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(34),n2h4(14))
call HGT_raise_alpha_OLR(G1H12(90),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(90),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(90),-4,ex3(:),4,G2H6(149),m3h2x6(:,159),heltab2x12(:,:,212))
  call Hloop_AZ_Q(ntryL,G1H12(143),ex4(:),G1H4(20),ngZu,m3h3x4(:,54),heltab2x12(:,:,213))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(35),n2h4(15))
  call Hloop_AZ_Q(ntryL,G1H12(144),ex4(:),G1H4(20),ngZu,m3h3x4(:,55),heltab2x12(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(36),n2h4(16))
  call Hloop_AZ_Q(ntryL,G1H12(145),ex4(:),G1H4(20),ngZu,m3h3x4(:,56),heltab2x12(:,:,215))
  call Hloop_A_Q(ntryL,G1H4(20),26,nMT,G2H4(37),n2h4(17))
  call Hloop_QV_A(ntryL,G1H12(96),ex3(:),G1H6(11),m3h2x6(:,160),heltab2x12(:,:,216))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(150),n2h6(96))
call HGT_OLR(G1H12(146),1,1,12)
call HGT_invQ_OLR(G1H12(146),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(146),-8,ex4(:),8,G2H4(38),m3h3x4(:,57),heltab2x12(:,:,217))
  call Hloop_QV_A(ntryL,G1H12(148),ex3(:),G1H6(11),m3h2x6(:,161),heltab2x12(:,:,218))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(151),n2h6(97))
  call Hloop_QV_A(ntryL,G1H12(149),ex3(:),G1H6(11),m3h2x6(:,162),heltab2x12(:,:,219))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(152),n2h6(98))
  call Hloop_QV_A(ntryL,G1H12(150),ex3(:),G1H6(11),m3h2x6(:,163),heltab2x12(:,:,220))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(153),n2h6(99))
  call Hloop_QV_A(ntryL,G1H12(151),ex3(:),G1H6(11),m3h2x6(:,164),heltab2x12(:,:,221))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(154),n2h6(100))
call HGT_OLR(G1H12(152),1,1,12)
call HGT_invQ_OLR(G1H12(152),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(152),-8,ex4(:),8,G2H4(39),m3h3x4(:,58),heltab2x12(:,:,222))
  call Hloop_QV_A(ntryL,G1H12(154),ex3(:),G1H6(11),m3h2x6(:,165),heltab2x12(:,:,223))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(155),n2h6(101))
  call Hloop_QV_A(ntryL,G1H12(155),ex3(:),G1H6(11),m3h2x6(:,166),heltab2x12(:,:,224))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(156),n2h6(102))
  call Hloop_QV_A(ntryL,G1H12(156),ex3(:),G1H6(11),m3h2x6(:,167),heltab2x12(:,:,225))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(157),n2h6(103))
  call Hloop_QV_A(ntryL,G1H12(157),ex3(:),G1H6(11),m3h2x6(:,168),heltab2x12(:,:,226))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(158),n2h6(104))
call HGT_OLR(G1H12(158),1,1,12)
call HGT_invQ_OLR(G1H12(158),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(158),-8,ex4(:),8,G2H4(40),m3h3x4(:,59),heltab2x12(:,:,227))
  call Hloop_QV_A(ntryL,G1H12(160),ex3(:),G1H6(11),m3h2x6(:,169),heltab2x12(:,:,228))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(159),n2h6(105))
  call Hloop_QV_A(ntryL,G1H12(161),ex3(:),G1H6(11),m3h2x6(:,170),heltab2x12(:,:,229))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(160),n2h6(106))
  call Hloop_QV_A(ntryL,G1H12(162),ex3(:),G1H6(11),m3h2x6(:,171),heltab2x12(:,:,230))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(161),n2h6(107))
  call Hloop_QV_A(ntryL,G1H12(97),ex3(:),G1H6(11),m3h2x6(:,172),heltab2x12(:,:,231))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(162),n2h6(108))
call HGT_raise_alpha_OLR(G1H12(98),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(98),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(98),ex4(:),G1H4(20),m3h3x4(:,60),heltab2x12(:,:,232))
  call Hloop_QV_A(ntryL,G1H12(163),ex3(:),G1H6(11),m3h2x6(:,173),heltab2x12(:,:,233))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(163),n2h6(109))
  call Hloop_QV_A(ntryL,G1H12(164),ex3(:),G1H6(11),m3h2x6(:,174),heltab2x12(:,:,234))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(164),n2h6(110))
  call Hloop_QV_A(ntryL,G1H12(165),ex3(:),G1H6(11),m3h2x6(:,175),heltab2x12(:,:,235))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(165),n2h6(111))
  call Hloop_QV_A(ntryL,G1H12(166),ex3(:),G1H6(11),m3h2x6(:,176),heltab2x12(:,:,236))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(166),n2h6(112))
call HGT_OLR(G1H12(167),1,1,12)
call HGT_invQ_OLR(G1H12(167),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(167),ex4(:),G1H4(21),m3h3x4(:,61),heltab2x12(:,:,237))
  call Hloop_QV_A(ntryL,G1H12(169),ex3(:),G1H6(11),m3h2x6(:,177),heltab2x12(:,:,238))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(167),n2h6(113))
  call Hloop_QV_A(ntryL,G1H12(170),ex3(:),G1H6(11),m3h2x6(:,178),heltab2x12(:,:,239))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(168),n2h6(114))
  call Hloop_QV_A(ntryL,G1H12(171),ex3(:),G1H6(11),m3h2x6(:,179),heltab2x12(:,:,240))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(169),n2h6(115))
  call Hloop_QV_A(ntryL,G1H12(172),ex3(:),G1H6(11),m3h2x6(:,180),heltab2x12(:,:,241))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(170),n2h6(116))
call HGT_OLR(G1H12(173),1,1,12)
call HGT_invQ_OLR(G1H12(173),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(173),ex4(:),G1H4(22),m3h3x4(:,62),heltab2x12(:,:,242))
  call Hloop_QV_A(ntryL,G1H12(175),ex3(:),G1H6(11),m3h2x6(:,181),heltab2x12(:,:,243))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(171),n2h6(117))
  call Hloop_QV_A(ntryL,G1H12(176),ex3(:),G1H6(11),m3h2x6(:,182),heltab2x12(:,:,244))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(172),n2h6(118))
  call Hloop_QV_A(ntryL,G1H12(177),ex3(:),G1H6(11),m3h2x6(:,183),heltab2x12(:,:,245))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(173),n2h6(119))
  call Hloop_QV_A(ntryL,G1H12(103),ex3(:),G1H6(11),m3h2x6(:,184),heltab2x12(:,:,246))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(174),n2h6(120))
call HGT_raise_alpha_OLR(G1H12(178),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(178),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(178),-8,ex4(:),8,G2H4(41),m3h3x4(:,63),heltab2x12(:,:,247))
  call Hloop_QV_A(ntryL,G1H12(180),ex3(:),G1H6(11),m3h2x6(:,185),heltab2x12(:,:,248))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(175),n2h6(121))
  call Hloop_QV_A(ntryL,G1H12(181),ex3(:),G1H6(11),m3h2x6(:,186),heltab2x12(:,:,249))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(176),n2h6(122))
  call Hloop_QV_A(ntryL,G1H12(182),ex3(:),G1H6(11),m3h2x6(:,187),heltab2x12(:,:,250))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(177),n2h6(123))
  call Hloop_QV_A(ntryL,G1H12(183),ex3(:),G1H6(11),m3h2x6(:,188),heltab2x12(:,:,251))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMB,G2H6(178),n2h6(124))
call HGT_OLR(G1H12(184),1,1,12)
call HGT_invQ_OLR(G1H12(184),2,5,12)
  call Hloop_SA_Q(ntryL,G1H12(184),ex2(:),G1H6(11),ngX,m3h2x6(:,189),heltab2x12(:,:,252))
  call Hloop_QV_A(ntryL,G1H12(186),ex3(:),G1H6(12),m3h2x6(:,190),heltab2x12(:,:,253))
  call Hloop_Q_A(ntryL,G1H6(12),21,nMB,G2H6(179),n2h6(125))
  call Hloop_QV_A(ntryL,G1H12(187),ex3(:),G1H6(12),m3h2x6(:,191),heltab2x12(:,:,254))
  call Hloop_Q_A(ntryL,G1H6(12),21,nMB,G2H6(180),n2h6(126))
  call Hloop_QV_A(ntryL,G1H12(188),ex3(:),G1H6(12),m3h2x6(:,192),heltab2x12(:,:,255))
  call Hloop_Q_A(ntryL,G1H6(12),21,nMB,G2H6(181),n2h6(127))
  call Hloop_QV_A(ntryL,G1H12(189),ex3(:),G1H6(12),m3h2x6(:,193),heltab2x12(:,:,256))
  call Hloop_Q_A(ntryL,G1H6(12),21,nMB,G2H6(182),n2h6(128))
call HGT_OLR(G1H12(190),1,1,12)
call HGT_invQ_OLR(G1H12(190),2,5,12)
  call Hloop_SA_Q(ntryL,G1H12(190),ex2(:),G1H6(12),ngH,m3h2x6(:,194),heltab2x12(:,:,257))
  call Hloop_QV_A(ntryL,G1H12(192),ex3(:),G1H6(13),m3h2x6(:,195),heltab2x12(:,:,258))
  call Hloop_Q_A(ntryL,G1H6(13),21,nMB,G2H6(183),n2h6(129))
  call Hloop_QV_A(ntryL,G1H12(193),ex3(:),G1H6(13),m3h2x6(:,196),heltab2x12(:,:,259))
  call Hloop_Q_A(ntryL,G1H6(13),21,nMB,G2H6(184),n2h6(130))
  call Hloop_QV_A(ntryL,G1H12(194),ex3(:),G1H6(13),m3h2x6(:,197),heltab2x12(:,:,260))
  call Hloop_Q_A(ntryL,G1H6(13),21,nMB,G2H6(185),n2h6(131))
  call Hloop_QV_A(ntryL,G1H12(195),ex3(:),G1H6(13),m3h2x6(:,198),heltab2x12(:,:,261))
  call Hloop_Q_A(ntryL,G1H6(13),21,nMT,G2H6(186),n2h6(132))
call HGT_OLR(G1H12(196),1,1,12)
call HGT_invQ_OLR(G1H12(196),2,5,12)
  call Hloop_SA_Q(ntryL,G1H12(196),ex2(:),G1H6(13),ngPbt,m3h2x6(:,199),heltab2x12(:,:,262))
  call Hloop_QV_A(ntryL,G1H12(198),ex3(:),G1H6(14),m3h2x6(:,200),heltab2x12(:,:,263))
  call Hloop_Q_A(ntryL,G1H6(14),21,nMT,G2H6(187),n2h6(133))
  call Hloop_QV_A(ntryL,G1H12(199),ex3(:),G1H6(14),m3h2x6(:,201),heltab2x12(:,:,264))
  call Hloop_Q_A(ntryL,G1H6(14),21,nMT,G2H6(188),n2h6(134))
  call Hloop_QV_A(ntryL,G1H12(200),ex3(:),G1H6(14),m3h2x6(:,202),heltab2x12(:,:,265))
  call Hloop_Q_A(ntryL,G1H6(14),21,nMT,G2H6(189),n2h6(135))
  call Hloop_QV_A(ntryL,G1H12(107),ex3(:),G1H6(14),m3h2x6(:,203),heltab2x12(:,:,266))
  call Hloop_Q_A(ntryL,G1H6(14),21,nMT,G2H6(190),n2h6(136))
call HGT_raise_alpha_OLR(G1H12(108),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(108),2,5,12)
  call Hloop_WA_Q(ntryL,G1H12(108),ex2(:),G1H6(14),m3h2x6(:,204),heltab2x12(:,:,267))
  call Hloop_QV_A(ntryL,G1H12(202),ex3(:),G1H6(15),m3h2x6(:,205),heltab2x12(:,:,268))
  call Hloop_Q_A(ntryL,G1H6(15),21,nMT,G2H6(191),n2h6(137))
  call Hloop_QV_A(ntryL,G1H12(203),ex3(:),G1H6(15),m3h2x6(:,206),heltab2x12(:,:,269))
  call Hloop_Q_A(ntryL,G1H6(15),21,nMT,G2H6(192),n2h6(138))
  call Hloop_QV_A(ntryL,G1H12(204),ex3(:),G1H6(15),m3h2x6(:,207),heltab2x12(:,:,270))
  call Hloop_Q_A(ntryL,G1H6(15),21,nMT,G2H6(193),n2h6(139))
  call Hloop_QZ_A(ntryL,G1H12(112),ex4(:),G1H4(23),ngZu,m3h3x4(:,64),heltab2x12(:,:,271))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(42),n2h4(18))
call HGT_OLR(G1H12(113),1,1,12)
call HGT_invQ_OLR(G1H12(113),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(113),-4,ex3(:),4,G2H6(194),m3h2x6(:,208),heltab2x12(:,:,272))
  call Hloop_QZ_A(ntryL,G1H12(115),ex4(:),G1H4(23),ngZu,m3h3x4(:,65),heltab2x12(:,:,273))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(43),n2h4(19))
  call Hloop_QZ_A(ntryL,G1H12(116),ex4(:),G1H4(23),ngZu,m3h3x4(:,66),heltab2x12(:,:,274))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(44),n2h4(20))
  call Hloop_QZ_A(ntryL,G1H12(117),ex4(:),G1H4(23),ngZu,m3h3x4(:,67),heltab2x12(:,:,275))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(45),n2h4(21))
  call Hloop_QZ_A(ntryL,G1H12(118),ex4(:),G1H4(23),ngZu,m3h3x4(:,68),heltab2x12(:,:,276))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(46),n2h4(22))
call HGT_raise_alpha_OLR(G1H12(119),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(119),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(119),ex3(:),G1H6(15),m3h2x6(:,209),heltab2x12(:,:,277))
  call Hloop_QZ_A(ntryL,G1H12(121),ex4(:),G1H4(23),ngZu,m3h3x4(:,69),heltab2x12(:,:,278))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(47),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H12(122),ex4(:),G1H4(23),ngZu,m3h3x4(:,70),heltab2x12(:,:,279))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(48),n2h4(24))
  call Hloop_QZ_A(ntryL,G1H12(123),ex4(:),G1H4(23),ngZu,m3h3x4(:,71),heltab2x12(:,:,280))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(49),n2h4(25))
  call Hloop_QZ_A(ntryL,G1H12(124),ex4(:),G1H4(23),ngZu,m3h3x4(:,72),heltab2x12(:,:,281))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(50),n2h4(26))
call HGT_OLR(G1H12(125),1,1,12)
call HGT_invQ_OLR(G1H12(125),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(125),ex3(:),G1H6(16),m3h2x6(:,210),heltab2x12(:,:,282))
  call Hloop_QZ_A(ntryL,G1H12(206),ex4(:),G1H4(23),ngZu,m3h3x4(:,73),heltab2x12(:,:,283))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(51),n2h4(27))
  call Hloop_QZ_A(ntryL,G1H12(207),ex4(:),G1H4(23),ngZu,m3h3x4(:,74),heltab2x12(:,:,284))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(52),n2h4(28))
  call Hloop_QZ_A(ntryL,G1H12(208),ex4(:),G1H4(23),ngZu,m3h3x4(:,75),heltab2x12(:,:,285))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(53),n2h4(29))
  call Hloop_QZ_A(ntryL,G1H12(128),ex4(:),G1H4(23),ngZu,m3h3x4(:,76),heltab2x12(:,:,286))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(54),n2h4(30))
call HGT_raise_alpha_OLR(G1H12(209),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(209),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(209),-4,ex3(:),4,G2H6(195),m3h2x6(:,211),heltab2x12(:,:,287))
  call Hloop_QZ_A(ntryL,G1H12(211),ex4(:),G1H4(23),ngZu,m3h3x4(:,77),heltab2x12(:,:,288))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(55),n2h4(31))
  call Hloop_QZ_A(ntryL,G1H12(212),ex4(:),G1H4(23),ngZu,m3h3x4(:,78),heltab2x12(:,:,289))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(56),n2h4(32))
  call Hloop_QZ_A(ntryL,G1H12(213),ex4(:),G1H4(23),ngZu,m3h3x4(:,79),heltab2x12(:,:,290))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(57),n2h4(33))
  call Hloop_QZ_A(ntryL,G1H12(214),ex4(:),G1H4(23),ngZd,m3h3x4(:,80),heltab2x12(:,:,291))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMB,G2H4(58),n2h4(34))
call HGT_OLR(G1H12(215),1,1,12)
call HGT_invQ_OLR(G1H12(215),2,5,12)
  call Hloop_SA_Q(ntryL,G1H12(215),ex2(:),G1H6(17),ngX,m3h2x6(:,212),heltab2x12(:,:,292))
  call Hloop_QZ_A(ntryL,G1H12(217),ex4(:),G1H4(23),ngZd,m3h3x4(:,81),heltab2x12(:,:,293))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMB,G2H4(59),n2h4(35))
  call Hloop_QZ_A(ntryL,G1H12(218),ex4(:),G1H4(23),ngZd,m3h3x4(:,82),heltab2x12(:,:,294))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMB,G2H4(60),n2h4(36))
  call Hloop_QZ_A(ntryL,G1H12(219),ex4(:),G1H4(23),ngZd,m3h3x4(:,83),heltab2x12(:,:,295))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMB,G2H4(61),n2h4(37))
  call Hloop_QZ_A(ntryL,G1H12(220),ex4(:),G1H4(23),ngZd,m3h3x4(:,84),heltab2x12(:,:,296))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMB,G2H4(62),n2h4(38))
call HGT_OLR(G1H12(221),1,1,12)
call HGT_invQ_OLR(G1H12(221),2,5,12)
  call Hloop_SA_Q(ntryL,G1H12(221),ex2(:),G1H6(18),ngH,m3h2x6(:,213),heltab2x12(:,:,297))
  call Hloop_QZ_A(ntryL,G1H12(223),ex4(:),G1H4(23),ngZd,m3h3x4(:,85),heltab2x12(:,:,298))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMB,G2H4(63),n2h4(39))
  call Hloop_QZ_A(ntryL,G1H12(224),ex4(:),G1H4(23),ngZd,m3h3x4(:,86),heltab2x12(:,:,299))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMB,G2H4(64),n2h4(40))
  call Hloop_QZ_A(ntryL,G1H12(225),ex4(:),G1H4(23),ngZd,m3h3x4(:,87),heltab2x12(:,:,300))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMB,G2H4(65),n2h4(41))
  call Hloop_QZ_A(ntryL,G1H12(226),ex4(:),G1H4(23),ngZu,m3h3x4(:,88),heltab2x12(:,:,301))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(66),n2h4(42))
call HGT_OLR(G1H12(227),1,1,12)
call HGT_invQ_OLR(G1H12(227),2,5,12)
  call Hloop_SA_Q(ntryL,G1H12(227),ex2(:),G1H6(19),ngPbt,m3h2x6(:,214),heltab2x12(:,:,302))
  call Hloop_QZ_A(ntryL,G1H12(229),ex4(:),G1H4(23),ngZu,m3h3x4(:,89),heltab2x12(:,:,303))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(67),n2h4(43))
  call Hloop_QZ_A(ntryL,G1H12(230),ex4(:),G1H4(23),ngZu,m3h3x4(:,90),heltab2x12(:,:,304))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(68),n2h4(44))
  call Hloop_QZ_A(ntryL,G1H12(231),ex4(:),G1H4(23),ngZu,m3h3x4(:,91),heltab2x12(:,:,305))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(69),n2h4(45))
  call Hloop_QZ_A(ntryL,G1H12(131),ex4(:),G1H4(23),ngZu,m3h3x4(:,92),heltab2x12(:,:,306))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(70),n2h4(46))
call HGT_raise_alpha_OLR(G1H12(132),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(132),2,5,12)
  call Hloop_WA_Q(ntryL,G1H12(132),ex2(:),G1H6(20),m3h2x6(:,215),heltab2x12(:,:,307))
  call Hloop_QZ_A(ntryL,G1H12(233),ex4(:),G1H4(23),ngZu,m3h3x4(:,93),heltab2x12(:,:,308))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(71),n2h4(47))
  call Hloop_QZ_A(ntryL,G1H12(234),ex4(:),G1H4(23),ngZu,m3h3x4(:,94),heltab2x12(:,:,309))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(72),n2h4(48))
  call Hloop_QZ_A(ntryL,G1H12(235),ex4(:),G1H4(23),ngZu,m3h3x4(:,95),heltab2x12(:,:,310))
  call Hloop_Q_A(ntryL,G1H4(23),25,nMT,G2H4(73),n2h4(49))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(96),[G2H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(88),[G2H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(100),[G2H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(92),[G2H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(16),[G2H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(17),[G2H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(112),[G2H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(104),[G2H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(116),[G2H6(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(108),[G2H6(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(40),[G2H6(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(41),[G2H6(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(54),[G2H6(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(55),[G2H6(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(68),[G2H6(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(69),[G2H6(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(77),[G1H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(79),[G1H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(80),[G1H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(82),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(83),[G1H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(86),[G1H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(85),[G1H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(87),[G1H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(11)])
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(1),mass5set(:,8),  & 
G1H6(1),G1H6(2),G1H6(4),G1H6(3),G1H6(6),G1H6(5),6)
  call HG1shiftOLR(G1H6(2),8,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(1),mass5set(:,9),  & 
G1H6(8),G1H6(7),G1H6(21),G1H6(22),G1H6(23),G1H6(24),6)
  call HG1shiftOLR(G1H6(7),8,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(1),mass5set(:,10),  & 
G1H6(25),G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
  call HG1shiftOLR(G1H6(26),8,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(1),mass5set(:,11),  & 
G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(32),8,6)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(1),mass5set(:,9),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),6)
  call HG1shiftOLR(G1H6(38),8,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(1),mass5set(:,10),  & 
G1H6(43),G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),6)
  call HG1shiftOLR(G1H6(44),8,6)
  call Hloop_QA_S(ntryL,G2H6(96),ex2(:),G2H3(1),ngPbt,m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_QA_S(ntryL,G2H6(88),ex2(:),G2H3(2),ngPbt,m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_QA_W(ntryL,G2H6(100),ex2(:),G2H3(3),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_QA_W(ntryL,G2H6(92),ex2(:),G2H3(4),m3h2x3(:,4),heltab2x6(:,:,4))
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(9),mass5set(:,12),  & 
G1H6(49),G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
  call HG1shiftOLR(G1H6(50),8,6)
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(9),mass5set(:,13),  & 
G1H6(55),G1H6(56),G1H6(57),G1H6(58),G1H6(59),G1H6(60),6)
  call HG1shiftOLR(G1H6(56),8,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(9),mass5set(:,14),  & 
G1H6(61),G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),6)
  call HG1shiftOLR(G1H6(62),8,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(9),mass5set(:,15),  & 
G1H6(67),G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(68),8,6)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(9),mass5set(:,16),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),G1H6(78),6)
  call HG1shiftOLR(G1H6(74),8,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(9),mass5set(:,15),  & 
G1H6(79),G1H6(80),G1H6(81),G1H6(82),G1H6(83),G1H6(84),6)
  call HG1shiftOLR(G1H6(80),8,6)
  call Hloop_SV_V(ntryL,G2H6(19),ex3(:),G2H3(5),m3h2x3(:,5),heltab2x6(:,:,5))
  call Hloop_VV_S(ntryL,G2H6(20),ex3(:),G2H3(6),m3h2x3(:,6),heltab2x6(:,:,6))
  call Hloop_SV_V(ntryL,G2H6(21),ex3(:),G2H3(7),m3h2x3(:,7),heltab2x6(:,:,7))
  call Hloop_VV_S(ntryL,G2H6(22),ex3(:),G2H3(8),m3h2x3(:,8),heltab2x6(:,:,8))
  call Hotf_5pt_reduction(G2H6(23),RedSet_5(9),mass5set(:,15),  & 
G1H6(85),G1H6(86),G1H6(87),G1H6(88),G1H6(89),G1H6(90),6)
  call HG1shiftOLR(G1H6(86),8,6)
  call Hotf_5pt_reduction(G2H6(24),RedSet_5(9),mass5set(:,15),  & 
G1H6(91),G1H6(92),G1H6(93),G1H6(94),G1H6(95),G1H6(96),6)
  call HG1shiftOLR(G1H6(92),8,6)
  call Hotf_5pt_reduction(G2H6(25),RedSet_5(2),mass5set(:,8),  & 
G1H6(97),G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),6)
  call HG1shiftOLR(G1H6(98),8,6)
  call Hotf_5pt_reduction(G2H6(26),RedSet_5(2),mass5set(:,9),  & 
G1H6(103),G1H6(104),G1H6(105),G1H6(106),G1H6(107),G1H6(108),6)
  call HG1shiftOLR(G1H6(104),8,6)
  call Hotf_5pt_reduction(G2H6(27),RedSet_5(2),mass5set(:,10),  & 
G1H6(109),G1H6(110),G1H6(111),G1H6(112),G1H6(113),G1H6(114),6)
  call HG1shiftOLR(G1H6(110),8,6)
  call Hotf_5pt_reduction(G2H6(28),RedSet_5(2),mass5set(:,11),  & 
G1H6(115),G1H6(116),G1H6(117),G1H6(118),G1H6(119),G1H6(120),6)
  call HG1shiftOLR(G1H6(116),8,6)
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(2),mass5set(:,9),  & 
G1H6(121),G1H6(122),G1H6(123),G1H6(124),G1H6(125),G1H6(126),6)
  call HG1shiftOLR(G1H6(122),8,6)
  call Hotf_5pt_reduction(G2H6(30),RedSet_5(2),mass5set(:,10),  & 
G1H6(127),G1H6(128),G1H6(129),G1H6(130),G1H6(131),G1H6(132),6)
  call HG1shiftOLR(G1H6(128),8,6)
  call Hloop_AQ_S(ntryL,G2H6(112),ex1(:),G2H3(9),ngPtb,m3h2x3(:,9),heltab2x6(:,:,9))
  call Hloop_AQ_S(ntryL,G2H6(104),ex1(:),G2H3(10),ngPtb,m3h2x3(:,10),heltab2x6(:,:,10))
  call Hloop_AQ_W(ntryL,G2H6(116),ex1(:),G2H3(11),m3h2x3(:,11),heltab2x6(:,:,11))
  call Hloop_AQ_W(ntryL,G2H6(108),ex1(:),G2H3(12),m3h2x3(:,12),heltab2x6(:,:,12))
  call Hotf_5pt_reduction(G2H6(35),RedSet_5(10),mass5set(:,12),  & 
G1H6(133),G1H6(134),G1H6(135),G1H6(136),G1H6(137),G1H6(138),6)
  call HG1shiftOLR(G1H6(134),4,6)
  call Hotf_5pt_reduction(G2H6(40),RedSet_5(10),mass5set(:,13),  & 
G1H6(139),G1H6(140),G1H6(141),G1H6(142),G1H6(143),G1H6(144),6)
  call HG1shiftOLR(G1H6(140),4,6)
  call Hotf_5pt_reduction(G2H6(41),RedSet_5(10),mass5set(:,14),  & 
G1H6(145),G1H6(146),G1H6(147),G1H6(148),G1H6(149),G1H6(150),6)
  call HG1shiftOLR(G1H6(146),4,6)
  call Hotf_5pt_reduction(G2H6(38),RedSet_5(10),mass5set(:,15),  & 
G1H6(151),G1H6(152),G1H6(153),G1H6(154),G1H6(155),G1H6(156),6)
  call HG1shiftOLR(G1H6(152),4,6)
  call Hotf_5pt_reduction(G2H6(39),RedSet_5(10),mass5set(:,16),  & 
G1H6(157),G1H6(158),G1H6(159),G1H6(160),G1H6(161),G1H6(162),6)
  call HG1shiftOLR(G1H6(158),4,6)
  call Hotf_5pt_reduction(G2H6(42),RedSet_5(10),mass5set(:,15),  & 
G1H6(163),G1H6(164),G1H6(165),G1H6(166),G1H6(167),G1H6(168),6)
  call HG1shiftOLR(G1H6(164),4,6)
  call Hloop_SV_V(ntryL,G2H6(43),ex4(:),G2H2(1),m3h3x2(:,1),heltab2x6(:,:,13))
  call Hloop_VV_S(ntryL,G2H6(44),ex4(:),G2H2(2),m3h3x2(:,2),heltab2x6(:,:,14))
  call Hloop_SV_V(ntryL,G2H6(45),ex4(:),G2H2(3),m3h3x2(:,3),heltab2x6(:,:,15))
  call Hloop_VV_S(ntryL,G2H6(46),ex4(:),G2H2(4),m3h3x2(:,4),heltab2x6(:,:,16))
  call Hotf_5pt_reduction(G2H6(47),RedSet_5(10),mass5set(:,15),  & 
G1H6(169),G1H6(170),G1H6(171),G1H6(172),G1H6(173),G1H6(174),6)
  call HG1shiftOLR(G1H6(170),4,6)
  call Hotf_5pt_reduction(G2H6(48),RedSet_5(10),mass5set(:,15),  & 
G1H6(175),G1H6(176),G1H6(177),G1H6(178),G1H6(179),G1H6(180),6)
  call HG1shiftOLR(G1H6(176),4,6)
  call Hotf_5pt_reduction(G2H6(49),RedSet_5(11),mass5set(:,12),  & 
G1H6(181),G1H6(182),G1H6(183),G1H6(184),G1H6(185),G1H6(186),6)
  call HG1shiftOLR(G1H6(182),8,6)
  call Hotf_5pt_reduction(G2H6(54),RedSet_5(11),mass5set(:,13),  & 
G1H6(187),G1H6(188),G1H6(189),G1H6(190),G1H6(191),G1H6(192),6)
  call HG1shiftOLR(G1H6(188),8,6)
  call Hotf_5pt_reduction(G2H6(55),RedSet_5(11),mass5set(:,14),  & 
G1H6(193),G1H6(194),G1H6(195),G1H6(196),G1H6(197),G1H6(198),6)
  call HG1shiftOLR(G1H6(194),8,6)
  call Hotf_5pt_reduction(G2H6(52),RedSet_5(11),mass5set(:,15),  & 
G1H6(199),G1H6(200),G1H6(201),G1H6(202),G1H6(203),G1H6(204),6)
  call HG1shiftOLR(G1H6(200),8,6)
  call Hotf_5pt_reduction(G2H6(53),RedSet_5(11),mass5set(:,16),  & 
G1H6(205),G1H6(206),G1H6(207),G1H6(208),G1H6(209),G1H6(210),6)
  call HG1shiftOLR(G1H6(206),8,6)
  call Hotf_5pt_reduction(G2H6(56),RedSet_5(11),mass5set(:,15),  & 
G1H6(211),G1H6(212),G1H6(213),G1H6(214),G1H6(215),G1H6(216),6)
  call HG1shiftOLR(G1H6(212),8,6)
  call Hloop_SV_V(ntryL,G2H6(57),ex3(:),G2H3(13),m3h2x3(:,13),heltab2x6(:,:,17))
  call Hloop_VV_S(ntryL,G2H6(58),ex3(:),G2H3(14),m3h2x3(:,14),heltab2x6(:,:,18))
  call Hloop_SV_V(ntryL,G2H6(59),ex3(:),G2H3(15),m3h2x3(:,15),heltab2x6(:,:,19))
  call Hloop_VV_S(ntryL,G2H6(60),ex3(:),G2H3(16),m3h2x3(:,16),heltab2x6(:,:,20))
  call Hotf_5pt_reduction(G2H6(61),RedSet_5(11),mass5set(:,15),  & 
G1H6(217),G1H6(218),G1H6(219),G1H6(220),G1H6(221),G1H6(222),6)
  call HG1shiftOLR(G1H6(218),8,6)
  call Hotf_5pt_reduction(G2H6(62),RedSet_5(11),mass5set(:,15),  & 
G1H6(223),G1H6(224),G1H6(225),G1H6(226),G1H6(227),G1H6(228),6)
  call HG1shiftOLR(G1H6(224),8,6)
  call Hotf_5pt_reduction(G2H6(63),RedSet_5(12),mass5set(:,12),  & 
G1H6(229),G1H6(230),G1H6(231),G1H6(232),G1H6(233),G1H6(234),6)
  call HG1shiftOLR(G1H6(230),4,6)
  call Hotf_5pt_reduction(G2H6(68),RedSet_5(12),mass5set(:,13),  & 
G1H6(235),G1H6(236),G1H6(237),G1H6(238),G1H6(239),G1H6(240),6)
  call HG1shiftOLR(G1H6(236),4,6)
  call Hotf_5pt_reduction(G2H6(69),RedSet_5(12),mass5set(:,14),  & 
G1H6(241),G1H6(242),G1H6(243),G1H6(244),G1H6(245),G1H6(246),6)
  call HG1shiftOLR(G1H6(242),4,6)
  call Hotf_5pt_reduction(G2H6(66),RedSet_5(12),mass5set(:,15),  & 
G1H6(247),G1H6(248),G1H6(249),G1H6(250),G1H6(251),G1H6(252),6)
  call HG1shiftOLR(G1H6(248),4,6)
  call Hotf_5pt_reduction(G2H6(67),RedSet_5(12),mass5set(:,16),  & 
G1H6(253),G1H6(254),G1H6(255),G1H6(256),G1H6(257),G1H6(258),6)
  call HG1shiftOLR(G1H6(254),4,6)
  call Hotf_5pt_reduction(G2H6(70),RedSet_5(12),mass5set(:,15),  & 
G1H6(259),G1H6(260),G1H6(261),G1H6(262),G1H6(263),G1H6(264),6)
  call HG1shiftOLR(G1H6(260),4,6)
  call Hloop_SV_V(ntryL,G2H6(71),ex4(:),G2H2(5),m3h3x2(:,5),heltab2x6(:,:,21))
  call Hloop_VV_S(ntryL,G2H6(72),ex4(:),G2H2(6),m3h3x2(:,6),heltab2x6(:,:,22))
  call Hloop_SV_V(ntryL,G2H6(73),ex4(:),G2H2(7),m3h3x2(:,7),heltab2x6(:,:,23))
  call Hloop_VV_S(ntryL,G2H6(74),ex4(:),G2H2(8),m3h3x2(:,8),heltab2x6(:,:,24))
  call Hotf_5pt_reduction(G2H6(75),RedSet_5(12),mass5set(:,15),  & 
G1H6(265),G1H6(266),G1H6(267),G1H6(268),G1H6(269),G1H6(270),6)
  call HG1shiftOLR(G1H6(266),4,6)
  call Hotf_5pt_reduction(G2H6(76),RedSet_5(12),mass5set(:,15),  & 
G1H6(271),G1H6(272),G1H6(273),G1H6(274),G1H6(275),G1H6(276),6)
  call HG1shiftOLR(G1H6(272),4,6)
  call Hotf_5pt_reduction(G2H6(77),RedSet_5(3),mass5set(:,17),  & 
G1H6(277),G1H6(278),G1H6(279),G1H6(280),G1H6(281),G1H6(282),6)
  call HG1shiftOLR(G1H6(278),8,6)
  call Hotf_5pt_reduction(G2H6(79),RedSet_5(3),mass5set(:,17),  & 
G1H6(283),G1H6(284),G1H6(285),G1H6(286),G1H6(287),G1H6(288),6)
  call HG1shiftOLR(G1H6(284),8,6)
  call Hloop_AQ_S(ntryL,G2H6(78),ex1(:),G2H3(17),ngH,m3h2x3(:,17),heltab2x6(:,:,25))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(4),mass5set(:,18),  & 
G1H4(23),G1H4(1),G1H4(2),G1H4(4),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(1),4,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(4),mass5set(:,19),  & 
G1H4(6),G1H4(10),G1H4(9),G1H4(12),G1H4(11),G1H4(24),4)
  call HG1shiftOLR(G1H4(10),4,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(4),mass5set(:,17),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),4,4)
  call Hloop_ZQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),ngZd,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(9),n2h2(1))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(4),mass5set(:,17),  & 
G1H4(3),G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),4)
  call HG1shiftOLR(G1H4(31),4,4)
  call Hotf_5pt_reduction(G2H6(80),RedSet_5(5),mass5set(:,17),  & 
G1H6(289),G1H6(290),G1H6(291),G1H6(292),G1H6(293),G1H6(294),6)
  call HG1shiftOLR(G1H6(290),8,6)
  call Hotf_5pt_reduction(G2H6(82),RedSet_5(5),mass5set(:,17),  & 
G1H6(295),G1H6(296),G1H6(297),G1H6(298),G1H6(299),G1H6(300),6)
  call HG1shiftOLR(G1H6(296),8,6)
  call Hloop_QA_S(ntryL,G2H6(81),ex2(:),G2H3(18),ngH,m3h2x3(:,18),heltab2x6(:,:,26))
  call Hotf_5pt_reduction(G2H6(83),RedSet_5(6),mass5set(:,20),  & 
G1H6(301),G1H6(302),G1H6(303),G1H6(304),G1H6(305),G1H6(306),6)
  call HG1shiftOLR(G1H6(302),2,6)
  call Hotf_5pt_reduction(G2H6(84),RedSet_5(6),mass5set(:,5),  & 
G1H6(307),G1H6(308),G1H6(309),G1H6(310),G1H6(311),G1H6(312),6)
  call HG1shiftOLR(G1H6(308),2,6)
  call Hloop_VV_S(ntryL,G2H6(86),ex4(:),G2H2(10),m3h3x2(:,9),heltab2x6(:,:,27))
  call Hloop_SV_V(ntryL,G2H6(85),ex4(:),G2H2(11),m3h3x2(:,10),heltab2x6(:,:,28))
  call Hotf_5pt_reduction(G2H6(87),RedSet_5(6),mass5set(:,20),  & 
G1H6(313),G1H6(314),G1H6(315),G1H6(316),G1H6(317),G1H6(318),6)
  call HG1shiftOLR(G1H6(314),2,6)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(7),mass5set(:,19),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),4)
  call HG1shiftOLR(G1H4(37),4,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(7),mass5set(:,18),  & 
G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),4)
  call HG1shiftOLR(G1H4(43),4,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(7),mass5set(:,17),  & 
G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),4)
  call HG1shiftOLR(G1H4(49),4,4)
  call Hloop_ZA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),ngZd,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(12),n2h2(2))
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(7),mass5set(:,17),  & 
G1H4(5),G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(54),4,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(8),mass5set(:,20),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(60),2,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(8),mass5set(:,5),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),2,4)
  call Hloop_VV_S(ntryL,G2H4(12),ex3(:),G2H2(13),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_SV_V(ntryL,G2H4(11),ex3(:),G2H2(14),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(8),mass5set(:,20),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),2,4)
  call Hloop_QA_S(ntryL,G2H6(90),ex2(:),G2H3(19),ngPbt,m3h2x3(:,19),heltab2x6(:,:,29))
  call Hloop_QA_S(ntryL,G2H6(91),ex2(:),G2H3(20),ngPbt,m3h2x3(:,20),heltab2x6(:,:,30))
  call Hloop_QA_W(ntryL,G2H6(94),ex2(:),G2H3(21),m3h2x3(:,21),heltab2x6(:,:,31))
  call Hloop_QA_W(ntryL,G2H6(95),ex2(:),G2H3(22),m3h2x3(:,22),heltab2x6(:,:,32))
  call Hloop_QA_S(ntryL,G2H6(98),ex2(:),G2H3(23),ngPbt,m3h2x3(:,23),heltab2x6(:,:,33))
  call Hloop_QA_S(ntryL,G2H6(99),ex2(:),G2H3(24),ngPbt,m3h2x3(:,24),heltab2x6(:,:,34))
  call Hloop_QA_W(ntryL,G2H6(102),ex2(:),G2H3(25),m3h2x3(:,25),heltab2x6(:,:,35))
  call Hloop_QA_W(ntryL,G2H6(103),ex2(:),G2H3(26),m3h2x3(:,26),heltab2x6(:,:,36))
  call Hloop_AQ_S(ntryL,G2H6(106),ex1(:),G2H3(27),ngPtb,m3h2x3(:,27),heltab2x6(:,:,37))
  call Hloop_AQ_S(ntryL,G2H6(107),ex1(:),G2H3(28),ngPtb,m3h2x3(:,28),heltab2x6(:,:,38))
  call Hloop_AQ_W(ntryL,G2H6(110),ex1(:),G2H3(29),m3h2x3(:,29),heltab2x6(:,:,39))
  call Hloop_AQ_W(ntryL,G2H6(111),ex1(:),G2H3(30),m3h2x3(:,30),heltab2x6(:,:,40))
  call Hloop_AQ_S(ntryL,G2H6(114),ex1(:),G2H3(31),ngPtb,m3h2x3(:,31),heltab2x6(:,:,41))
  call Hloop_AQ_S(ntryL,G2H6(115),ex1(:),G2H3(32),ngPtb,m3h2x3(:,32),heltab2x6(:,:,42))
  call Hloop_AQ_W(ntryL,G2H6(118),ex1(:),G2H3(33),m3h2x3(:,33),heltab2x6(:,:,43))
  call Hloop_AQ_W(ntryL,G2H6(119),ex1(:),G2H3(34),m3h2x3(:,34),heltab2x6(:,:,44))
  call Hloop_AQ_S(ntryL,G2H6(120),ex1(:),G2H3(35),ngH,m3h2x3(:,35),heltab2x6(:,:,45))
  call Hloop_AQ_S(ntryL,G2H6(122),ex1(:),G2H3(36),ngH,m3h2x3(:,36),heltab2x6(:,:,46))
  call Hloop_AQ_S(ntryL,G2H6(123),ex1(:),G2H3(37),ngH,m3h2x3(:,37),heltab2x6(:,:,47))
  call Hloop_AQ_S(ntryL,G2H6(124),ex1(:),G2H3(38),ngX,m3h2x3(:,38),heltab2x6(:,:,48))
  call Hloop_AQ_S(ntryL,G2H6(126),ex1(:),G2H3(39),ngX,m3h2x3(:,39),heltab2x6(:,:,49))
  call Hloop_AQ_S(ntryL,G2H6(127),ex1(:),G2H3(40),ngX,m3h2x3(:,40),heltab2x6(:,:,50))
  call Hloop_AQ_S(ntryL,G2H6(128),ex1(:),G2H3(41),ngPtb,m3h2x3(:,41),heltab2x6(:,:,51))
  call Hloop_AQ_S(ntryL,G2H6(130),ex1(:),G2H3(42),ngPtb,m3h2x3(:,42),heltab2x6(:,:,52))
  call Hloop_AQ_S(ntryL,G2H6(131),ex1(:),G2H3(43),ngPtb,m3h2x3(:,43),heltab2x6(:,:,53))
  call Hloop_AQ_S(ntryL,G2H6(132),ex1(:),G2H3(44),ngPtb,m3h2x3(:,44),heltab2x6(:,:,54))
  call Hloop_AQ_S(ntryL,G2H6(134),ex1(:),G2H3(45),ngPtb,m3h2x3(:,45),heltab2x6(:,:,55))
  call Hloop_AQ_S(ntryL,G2H6(135),ex1(:),G2H3(46),ngPtb,m3h2x3(:,46),heltab2x6(:,:,56))
  call Hloop_AQ_Z(ntryL,G2H6(136),ex1(:),G2H3(47),ngZd,m3h2x3(:,47),heltab2x6(:,:,57))
  call Hloop_AQ_Z(ntryL,G2H6(138),ex1(:),G2H3(48),ngZd,m3h2x3(:,48),heltab2x6(:,:,58))
  call Hloop_AQ_Z(ntryL,G2H6(139),ex1(:),G2H3(49),ngZd,m3h2x3(:,49),heltab2x6(:,:,59))
  call Hloop_AQ_W(ntryL,G2H6(140),ex1(:),G2H3(50),m3h2x3(:,50),heltab2x6(:,:,60))
  call Hloop_AQ_W(ntryL,G2H6(142),ex1(:),G2H3(51),m3h2x3(:,51),heltab2x6(:,:,61))
  call Hloop_AQ_W(ntryL,G2H6(143),ex1(:),G2H3(52),m3h2x3(:,52),heltab2x6(:,:,62))
  call Hloop_AQ_W(ntryL,G2H6(144),ex1(:),G2H3(53),m3h2x3(:,53),heltab2x6(:,:,63))
  call Hloop_AQ_W(ntryL,G2H6(146),ex1(:),G2H3(54),m3h2x3(:,54),heltab2x6(:,:,64))
  call Hloop_AQ_W(ntryL,G2H6(147),ex1(:),G2H3(55),m3h2x3(:,55),heltab2x6(:,:,65))
  call Hloop_AQ_S(ntryL,G2H4(22),ex1(:),G2H2(15),ngPtb,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_S(ntryL,G2H4(24),ex1(:),G2H2(16),ngPtb,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_S(ntryL,G2H4(25),ex1(:),G2H2(17),ngPtb,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_S(ntryL,G2H4(26),ex1(:),G2H2(18),ngPtb,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_S(ntryL,G2H4(28),ex1(:),G2H2(19),ngPtb,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_S(ntryL,G2H4(29),ex1(:),G2H2(20),ngPtb,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_W(ntryL,G2H4(30),ex1(:),G2H2(21),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_W(ntryL,G2H4(32),ex1(:),G2H2(22),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_W(ntryL,G2H4(33),ex1(:),G2H2(23),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_W(ntryL,G2H4(34),ex1(:),G2H2(24),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_W(ntryL,G2H4(36),ex1(:),G2H2(25),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_W(ntryL,G2H4(37),ex1(:),G2H2(26),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_S(ntryL,G2H6(150),ex2(:),G2H3(56),ngH,m3h2x3(:,56),heltab2x6(:,:,66))
  call Hloop_QA_S(ntryL,G2H6(152),ex2(:),G2H3(57),ngH,m3h2x3(:,57),heltab2x6(:,:,67))
  call Hloop_QA_S(ntryL,G2H6(153),ex2(:),G2H3(58),ngH,m3h2x3(:,58),heltab2x6(:,:,68))
  call Hloop_QA_S(ntryL,G2H6(154),ex2(:),G2H3(59),ngX,m3h2x3(:,59),heltab2x6(:,:,69))
  call Hloop_QA_S(ntryL,G2H6(156),ex2(:),G2H3(60),ngX,m3h2x3(:,60),heltab2x6(:,:,70))
  call Hloop_QA_S(ntryL,G2H6(157),ex2(:),G2H3(61),ngX,m3h2x3(:,61),heltab2x6(:,:,71))
  call Hloop_QA_S(ntryL,G2H6(158),ex2(:),G2H3(62),ngPbt,m3h2x3(:,62),heltab2x6(:,:,72))
  call Hloop_QA_S(ntryL,G2H6(160),ex2(:),G2H3(63),ngPbt,m3h2x3(:,63),heltab2x6(:,:,73))
  call Hloop_QA_S(ntryL,G2H6(161),ex2(:),G2H3(64),ngPbt,m3h2x3(:,64),heltab2x6(:,:,74))
  call Hloop_QA_S(ntryL,G2H6(162),ex2(:),G2H3(65),ngPbt,m3h2x3(:,65),heltab2x6(:,:,75))
  call Hloop_QA_S(ntryL,G2H6(164),ex2(:),G2H3(66),ngPbt,m3h2x3(:,66),heltab2x6(:,:,76))
  call Hloop_QA_S(ntryL,G2H6(165),ex2(:),G2H3(67),ngPbt,m3h2x3(:,67),heltab2x6(:,:,77))
  call Hloop_QA_Z(ntryL,G2H6(166),ex2(:),G2H3(68),ngZd,m3h2x3(:,68),heltab2x6(:,:,78))
  call Hloop_QA_Z(ntryL,G2H6(168),ex2(:),G2H3(69),ngZd,m3h2x3(:,69),heltab2x6(:,:,79))
  call Hloop_QA_Z(ntryL,G2H6(169),ex2(:),G2H3(70),ngZd,m3h2x3(:,70),heltab2x6(:,:,80))
  call Hloop_QA_W(ntryL,G2H6(170),ex2(:),G2H3(71),m3h2x3(:,71),heltab2x6(:,:,81))
  call Hloop_QA_W(ntryL,G2H6(172),ex2(:),G2H3(72),m3h2x3(:,72),heltab2x6(:,:,82))
  call Hloop_QA_W(ntryL,G2H6(173),ex2(:),G2H3(73),m3h2x3(:,73),heltab2x6(:,:,83))
  call Hloop_QA_W(ntryL,G2H6(174),ex2(:),G2H3(74),m3h2x3(:,74),heltab2x6(:,:,84))
  call Hloop_QA_W(ntryL,G2H6(176),ex2(:),G2H3(75),m3h2x3(:,75),heltab2x6(:,:,85))
  call Hloop_QA_W(ntryL,G2H6(177),ex2(:),G2H3(76),m3h2x3(:,76),heltab2x6(:,:,86))
  call Hotf_5pt_reduction(G2H6(178),RedSet_5(6),mass5set(:,5),  & 
G1H6(319),G1H6(320),G1H6(321),G1H6(322),G1H6(323),G1H6(324),6)
  call HG1shiftOLR(G1H6(320),2,6)
  call Hotf_4pt_reduction(G2H6(180),RedSet_4(1),mass4set(:,1),  & 
G1H6(325),G1H6(326),G1H6(327),G1H6(328),G1H6(329),6)
  call HG1shiftOLR(G1H6(326),2,6)
  call Hotf_4pt_reduction(G2H6(181),RedSet_4(2),mass4set(:,1),  & 
G1H6(330),G1H6(331),G1H6(332),G1H6(333),G1H6(334),6)
  call HG1shiftOLR(G1H6(331),10,6)
  call Hotf_5pt_reduction(G2H6(182),RedSet_5(6),mass5set(:,6),  & 
G1H6(335),G1H6(336),G1H6(337),G1H6(338),G1H6(339),G1H6(340),6)
  call HG1shiftOLR(G1H6(336),2,6)
  call Hotf_4pt_reduction(G2H6(184),RedSet_4(1),mass4set(:,2),  & 
G1H6(341),G1H6(342),G1H6(343),G1H6(344),G1H6(345),6)
  call HG1shiftOLR(G1H6(342),2,6)
  call Hotf_4pt_reduction(G2H6(185),RedSet_4(2),mass4set(:,2),  & 
G1H6(346),G1H6(347),G1H6(348),G1H6(349),G1H6(350),6)
  call HG1shiftOLR(G1H6(347),10,6)
  call Hotf_5pt_reduction(G2H6(186),RedSet_5(6),mass5set(:,7),  & 
G1H6(351),G1H6(352),G1H6(353),G1H6(354),G1H6(355),G1H6(356),6)
  call HG1shiftOLR(G1H6(352),2,6)
  call Hotf_4pt_reduction(G2H6(188),RedSet_4(1),mass4set(:,3),  & 
G1H6(357),G1H6(358),G1H6(359),G1H6(360),G1H6(361),6)
  call HG1shiftOLR(G1H6(358),2,6)
  call Hotf_4pt_reduction(G2H6(189),RedSet_4(2),mass4set(:,3),  & 
G1H6(362),G1H6(363),G1H6(364),G1H6(365),G1H6(366),6)
  call HG1shiftOLR(G1H6(363),10,6)
  call Hotf_5pt_reduction(G2H6(190),RedSet_5(6),mass5set(:,7),  & 
G1H6(367),G1H6(368),G1H6(369),G1H6(370),G1H6(371),G1H6(372),6)
  call HG1shiftOLR(G1H6(368),2,6)
  call Hotf_4pt_reduction(G2H6(192),RedSet_4(1),mass4set(:,3),  & 
G1H6(373),G1H6(374),G1H6(375),G1H6(376),G1H6(377),6)
  call HG1shiftOLR(G1H6(374),2,6)
  call Hotf_4pt_reduction(G2H6(193),RedSet_4(2),mass4set(:,3),  & 
G1H6(378),G1H6(379),G1H6(380),G1H6(381),G1H6(382),6)
  call HG1shiftOLR(G1H6(379),10,6)
  call Hloop_QA_S(ntryL,G2H4(42),ex2(:),G2H2(27),ngPbt,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_S(ntryL,G2H4(44),ex2(:),G2H2(28),ngPbt,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_S(ntryL,G2H4(45),ex2(:),G2H2(29),ngPbt,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_S(ntryL,G2H4(46),ex2(:),G2H2(30),ngPbt,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_S(ntryL,G2H4(48),ex2(:),G2H2(31),ngPbt,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_S(ntryL,G2H4(49),ex2(:),G2H2(32),ngPbt,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_W(ntryL,G2H4(50),ex2(:),G2H2(33),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_W(ntryL,G2H4(52),ex2(:),G2H2(34),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_W(ntryL,G2H4(53),ex2(:),G2H2(35),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_W(ntryL,G2H4(54),ex2(:),G2H2(36),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_W(ntryL,G2H4(56),ex2(:),G2H2(37),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_W(ntryL,G2H4(57),ex2(:),G2H2(38),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(8),mass5set(:,5),  & 
G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(81),G1H4(82),4)
  call HG1shiftOLR(G1H4(78),2,4)
  call Hotf_4pt_reduction(G2H4(60),RedSet_4(1),mass4set(:,1),  & 
G1H4(83),G1H4(84),G1H4(85),G1H4(86),G1H4(87),4)
  call HG1shiftOLR(G1H4(84),2,4)
  call Hotf_4pt_reduction(G2H4(61),RedSet_4(3),mass4set(:,1),  & 
G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(89),6,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(8),mass5set(:,6),  & 
G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(94),2,4)
  call Hotf_4pt_reduction(G2H4(64),RedSet_4(1),mass4set(:,2),  & 
G1H4(99),G1H4(100),G1H4(101),G1H4(102),G1H4(103),4)
  call HG1shiftOLR(G1H4(100),2,4)
  call Hotf_4pt_reduction(G2H4(65),RedSet_4(3),mass4set(:,2),  & 
G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(105),6,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(8),mass5set(:,7),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),2,4)
  call Hotf_4pt_reduction(G2H4(68),RedSet_4(1),mass4set(:,3),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),4)
  call HG1shiftOLR(G1H4(116),2,4)
  call Hotf_4pt_reduction(G2H4(69),RedSet_4(3),mass4set(:,3),  & 
G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(121),6,4)
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(8),mass5set(:,7),  & 
G1H4(125),G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(126),2,4)
  call Hotf_4pt_reduction(G2H4(72),RedSet_4(1),mass4set(:,3),  & 
G1H4(131),G1H4(132),G1H4(133),G1H4(134),G1H4(135),4)
  call HG1shiftOLR(G1H4(132),2,4)
  call Hotf_4pt_reduction(G2H4(73),RedSet_4(3),mass4set(:,3),  & 
G1H4(136),G1H4(137),G1H4(138),G1H4(139),G1H4(140),4)
  call HG1shiftOLR(G1H4(137),6,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(325),[G1H6(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(330),[G1H6(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(341),[G1H6(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(346),[G1H6(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(357),[G1H6(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(362),[G1H6(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(373),[G1H6(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(378),[G1H6(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(83),[G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(99),[G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(104),[G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(130)])
  call Hloop_SA_Q(ntryL,G1H6(1),ex2(:),G1H3(1),ngH,m3h2x3(:,77),heltab2x6(:,:,87))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(77),n2h3(1))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(2),-8,nMB,G2H6(7),n2h6(140))
  call Hloop_QZ_A(ntryL,G2H6(7),ex4(:),G2H2(39),ngZd,m3h3x2(:,11),heltab2x6(:,:,88))
  call Hloop_SA_Q(ntryL,G1H6(6),ex2(:),G1H3(1),ngH,m3h2x3(:,78),heltab2x6(:,:,89))



end subroutine vamp_1

end module ol_vamp_1_ppvvv_ew_bbxazz_1_/**/REALKIND
