
module ol_external_ppvvv_ew_uxdaawx_1
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_ppvvv_ew_uxdaawx_1(5) = &
                     [ (dummy_counter, dummy_counter = 1, 5) ]
  integer, save :: external_perm_inv_ppvvv_ew_uxdaawx_1(5) = &
                     [ (dummy_counter, dummy_counter = 1, 5) ]
  integer, save :: extcomb_perm_ppvvv_ew_uxdaawx_1(0:16) = &
                     [ (dummy_counter, dummy_counter = 0, 16) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_ppvvv_ew_uxdaawx_1(5) = &
                     [ 1, 2, 3, 3, 4 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_ppvvv_ew_uxdaawx_1(5) = &
                     [ 6, 6, 2, 2, 3 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_ppvvv_ew_uxdaawx_1 = &
                     72
  integer, save :: channel_number_ppvvv_ew_uxdaawx_1 = -1
  ! external particle helicities
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(5,48) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(48,5)
  integer, save :: POLSEL(5) = 0
  integer, save :: photonid_ppvvv_ew_uxdaawx_1(5) = 0

  contains

  subroutine n_external(n) &
      & bind(c,name="ol_f_n_external_ppvvv_ew_uxdaawx_1")
    ! Return the number of external particles
    implicit none
    integer, intent(out) :: n
    n = 5
  end subroutine n_external


  subroutine n_external_c(n) &
      & bind(c,name="ol_n_external_ppvvv_ew_uxdaawx_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int) :: n
    n = 5
  end subroutine n_external_c


  subroutine set_permutation(perm) &
      & bind(c,name="ol_f_set_permutation_ppvvv_ew_uxdaawx_1")
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_external_decl_/**/DREALKIND, only: n_scatt
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(5)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_ppvvv_ew_uxdaawx_1(5)
    external_perm_ppvvv_ew_uxdaawx_1 = perm
    do i = 1, 5
      external_perm_inv_ppvvv_ew_uxdaawx_1( &
        external_perm_ppvvv_ew_uxdaawx_1(i)) = i
      particle_types_perm_ppvvv_ew_uxdaawx_1(i) = &
        particle_types_ppvvv_ew_uxdaawx_1( &
        external_perm_ppvvv_ew_uxdaawx_1(i))
    end do
    do i = 1, 5
      do j = 1, i
        if (external_perm_ppvvv_ew_uxdaawx_1(i) >= &
          external_perm_ppvvv_ew_uxdaawx_1(j)) then
          ii = external_perm_ppvvv_ew_uxdaawx_1(i)
          jj = external_perm_ppvvv_ew_uxdaawx_1(j)
        else
          ii = external_perm_ppvvv_ew_uxdaawx_1(j)
          jj = external_perm_ppvvv_ew_uxdaawx_1(i)
        end if
        extcomb_perm_ppvvv_ew_uxdaawx_1((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_ppvvv_ew_uxdaawx_1 = 1
    do i = 1, n_scatt
      average_factor_ppvvv_ew_uxdaawx_1 = &
        average_factor_ppvvv_ew_uxdaawx_1 &
        * average_factors_ppvvv_ew_uxdaawx_1( &
        external_perm_ppvvv_ew_uxdaawx_1(i))
    end do
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 5
        average_factor_ppvvv_ew_uxdaawx_1 = &
          average_factor_ppvvv_ew_uxdaawx_1 &
          * factorial(count(particle_types_perm_ppvvv_ew_uxdaawx_1(n_scatt+1:5) == i))
      end do
    end if
  end subroutine set_permutation


  subroutine set_permutation_c(perm) &
      & bind(c,name="ol_set_permutation_ppvvv_ew_uxdaawx_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int), intent(in) :: perm(5)
    integer :: f_perm(5)
    f_perm = perm
    call set_permutation(f_perm)
  end subroutine set_permutation_c


  subroutine get_masses(m_ex) &
      & bind(c,name="ol_f_get_masses_ppvvv_ew_uxdaawx_1")
    ! Return the masses of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: m_ex(5)
    integer        :: i
    real(DREALKIND) :: m_ex_orig(5)
    ! External particle masses for in the identity permutation
    m_ex_orig = [ rZERO, rZERO, rZERO, rZERO, rMW_unscaled ]
    do i = 1, 5
      m_ex(i) = m_ex_orig(external_perm_ppvvv_ew_uxdaawx_1(i))
    end do
  end subroutine get_masses


  subroutine get_masses_c(m_ex) &
      & bind(c,name="ol_get_masses_ppvvv_ew_uxdaawx_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: m_ex(5)
    real(DREALKIND) :: f_m_ex(5)
    call get_masses(f_m_ex)
    m_ex = f_m_ex
  end subroutine get_masses_c


  subroutine rambo(sqrt_s, p_rambo) &
      & bind(c,name="ol_f_rambo_ppvvv_ew_uxdaawx_1")
    use KIND_TYPES, only: DREALKIND
    use ol_kinematics_/**/DREALKIND, only: rambo_generic => rambo
    implicit none
    real(DREALKIND), intent(in) :: sqrt_s
    real(DREALKIND), intent(out) :: p_rambo(0:3,5)
    real(DREALKIND) :: m_ex(5)
    call get_masses(m_ex)
    call rambo_generic(sqrt_s, m_ex, p_rambo)
  end subroutine rambo


  subroutine rambo_c(sqrt_s, p_rambo) &
      & bind(c,name="ol_rambo_ppvvv_ew_uxdaawx_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in) :: sqrt_s
    real(c_double), intent(out) :: p_rambo(0:3,5)
    real(DREALKIND) :: f_sqrt_s
    real(DREALKIND) :: f_p_rambo(0:3,5)
    f_sqrt_s = sqrt_s
    call rambo(f_sqrt_s, f_p_rambo)
    p_rambo = f_p_rambo
  end subroutine rambo_c


  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:, 1) = [ -1, -1, -1, -1, -1 ]
  H(:, 2) = [ -1, -1, -1, -1,  0 ]
  H(:, 3) = [ -1, -1, -1, -1,  1 ]
  H(:, 4) = [ -1, -1, -1,  1, -1 ]
  H(:, 5) = [ -1, -1, -1,  1,  0 ]
  H(:, 6) = [ -1, -1, -1,  1,  1 ]
  H(:, 7) = [ -1, -1,  1, -1, -1 ]
  H(:, 8) = [ -1, -1,  1, -1,  0 ]
  H(:, 9) = [ -1, -1,  1, -1,  1 ]
  H(:,10) = [ -1, -1,  1,  1, -1 ]
  H(:,11) = [ -1, -1,  1,  1,  0 ]
  H(:,12) = [ -1, -1,  1,  1,  1 ]
  H(:,13) = [ -1,  1, -1, -1, -1 ]
  H(:,14) = [ -1,  1, -1, -1,  0 ]
  H(:,15) = [ -1,  1, -1, -1,  1 ]
  H(:,16) = [ -1,  1, -1,  1, -1 ]
  H(:,17) = [ -1,  1, -1,  1,  0 ]
  H(:,18) = [ -1,  1, -1,  1,  1 ]
  H(:,19) = [ -1,  1,  1, -1, -1 ]
  H(:,20) = [ -1,  1,  1, -1,  0 ]
  H(:,21) = [ -1,  1,  1, -1,  1 ]
  H(:,22) = [ -1,  1,  1,  1, -1 ]
  H(:,23) = [ -1,  1,  1,  1,  0 ]
  H(:,24) = [ -1,  1,  1,  1,  1 ]
  H(:,25) = [  1, -1, -1, -1, -1 ]
  H(:,26) = [  1, -1, -1, -1,  0 ]
  H(:,27) = [  1, -1, -1, -1,  1 ]
  H(:,28) = [  1, -1, -1,  1, -1 ]
  H(:,29) = [  1, -1, -1,  1,  0 ]
  H(:,30) = [  1, -1, -1,  1,  1 ]
  H(:,31) = [  1, -1,  1, -1, -1 ]
  H(:,32) = [  1, -1,  1, -1,  0 ]
  H(:,33) = [  1, -1,  1, -1,  1 ]
  H(:,34) = [  1, -1,  1,  1, -1 ]
  H(:,35) = [  1, -1,  1,  1,  0 ]
  H(:,36) = [  1, -1,  1,  1,  1 ]
  H(:,37) = [  1,  1, -1, -1, -1 ]
  H(:,38) = [  1,  1, -1, -1,  0 ]
  H(:,39) = [  1,  1, -1, -1,  1 ]
  H(:,40) = [  1,  1, -1,  1, -1 ]
  H(:,41) = [  1,  1, -1,  1,  0 ]
  H(:,42) = [  1,  1, -1,  1,  1 ]
  H(:,43) = [  1,  1,  1, -1, -1 ]
  H(:,44) = [  1,  1,  1, -1,  0 ]
  H(:,45) = [  1,  1,  1, -1,  1 ]
  H(:,46) = [  1,  1,  1,  1, -1 ]
  H(:,47) = [  1,  1,  1,  1,  0 ]
  H(:,48) = [  1,  1,  1,  1,  1 ]

  H_HC(:,3) = [ ((((2*(binco-1)+flip)*6+binpos, flip = 0, 1), binpos = 1, 6), binco = 1, 48/6/2) ]
  H_HC(:,4) = [ ((((2*(binco-1)+flip)*3+binpos, flip = 0, 1), binpos = 1, 3), binco = 1, 48/3/2) ]
  end subroutine hel_init


  subroutine pol_init(pol) &
      & bind(c,name="ol_f_pol_init_ppvvv_ew_uxdaawx_1")
    implicit none
    integer, intent(in) :: pol(5)
    POLSEL = pol
  end subroutine pol_init


  subroutine set_photons(photon_id) &
      & bind(c,name="ol_f_set_photons_ppvvv_ew_uxdaawx_1")
    implicit none
    integer, intent(in) :: photon_id(5)
    photonid_ppvvv_ew_uxdaawx_1 = photon_id
  end subroutine set_photons


end module ol_external_ppvvv_ew_uxdaawx_1


module ol_settings_ppvvv_ew_uxdaawx_1
  implicit none
  ! Activates optimized helicity bookkeeping. Default=false
    logical, save :: hel_mem_opt = .false.
  ! Calculate loop correlators
    logical, save :: loopcc = .false.

  contains

  subroutine set_hel_mem_opt(set) &
      & bind(c,name="ol_hel_mem_opt_ppvvv_ew_uxdaawx_1")
    implicit none
    logical, intent(in) :: set
    hel_mem_opt = set
  end subroutine set_hel_mem_opt

  subroutine set_loopcc(set,was) &
      & bind(c,name="ol_loopcc_ppvvv_ew_uxdaawx_1")
    implicit none
    logical, intent(in) :: set
    logical :: was
    was = loopcc
    loopcc = set
  end subroutine set_loopcc

end module ol_settings_ppvvv_ew_uxdaawx_1

module colour_basis_ppvvv_ew_uxdaawx_1
  implicit none
  ! tree colour basis
  integer, save :: extcolours(5) = [1,1,0,0,0]
  contains

  pure subroutine tree_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_tree_colbasis_dim_ppvvv_ew_uxdaawx_1")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(5)
    ! number of tree colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 1
    ncoupl = 1
    maxpows = 1
    nhel = 48
  end subroutine tree_colbasis_dim

  subroutine tree_colbasis(basis, powers) &
    & bind(c, name="ol_tree_colbasis_ppvvv_ew_uxdaawx_1")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,1)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([0], [1,1])
#endif
#if 1 > 0
    ! tree colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
    basis = reshape( &
      [1,1,0], &
      [3,1])
#endif
  end subroutine tree_colbasis

end module colour_basis_ppvvv_ew_uxdaawx_1

! **********************************************************************
module ol_heltables_OLR_ppvvv_ew_uxdaawx_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(3) = [-1,0,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(54), n3(3,270), n4(4,2)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x6(2,6,12), t3x4(2,4,16), t3x12(2,12,38), t3x8(2,8,48), t3x48(2,48,156), t4x12(3,12,2)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(48,5)
  integer,           save :: exthel(48,5)
  integer,           save :: firstpol(5)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n3(:,1), t3x4(:,:,1))
  call heltable([2,2,3,12], n4(:,1), t4x12(:,:,1))
  call heltable([2,3,6], n3(:,2), t3x6(:,:,1))
  call heltable([4,2,8], n3(:,3), t3x8(:,:,1))
  call heltable([2,3,6], n3(:,4), t3x6(:,:,2))
  call heltable([4,2,8], n3(:,5), t3x8(:,:,2))
  call heltable([2,3,6], n3(:,6), t3x6(:,:,3))
  call heltable([4,2,8], n3(:,7), t3x8(:,:,3))
  call heltable([2,3,6], n3(:,8), t3x6(:,:,4))
  call heltable([4,2,8], n3(:,9), t3x8(:,:,4))
  call heltable([2,2,4], n3(:,10), t3x4(:,:,2))
  call heltable([2,2,4], n3(:,11), t3x4(:,:,3))
  n2(1) = 4
  n2(2) = 4
  call heltable([4,3,12], n3(:,12), t3x12(:,:,1))
  call heltable([3,2,6], n3(:,13), t3x6(:,:,5))
  n2(3) = 6
  call heltable([4,2,8], n3(:,14), t3x8(:,:,5))
  call heltable([2,4,8], n3(:,15), t3x8(:,:,6))
  call heltable([2,2,4], n3(:,16), t3x4(:,:,4))
  call heltable([2,2,4], n3(:,17), t3x4(:,:,5))
  n2(4) = 4
  n2(5) = 4
  call heltable([4,3,12], n3(:,18), t3x12(:,:,2))
  call heltable([2,3,6], n3(:,19), t3x6(:,:,6))
  n2(6) = 6
  call heltable([6,2,12], n3(:,20), t3x12(:,:,3))
  call heltable([4,2,8], n3(:,21), t3x8(:,:,7))
  call heltable([4,2,8], n3(:,22), t3x8(:,:,8))
  call heltable([2,4,8], n3(:,23), t3x8(:,:,9))
  call heltable([6,2,12], n3(:,24), t3x12(:,:,4))
  call heltable([4,2,8], n3(:,25), t3x8(:,:,10))
  call heltable([2,2,3,12], n4(:,2), t4x12(:,:,2))
  call heltable([2,2,4], n3(:,26), t3x4(:,:,6))
  call heltable([4,2,8], n3(:,27), t3x8(:,:,11))
  call heltable([4,2,8], n3(:,28), t3x8(:,:,12))
  call heltable([2,3,6], n3(:,29), t3x6(:,:,7))
  call heltable([2,3,6], n3(:,30), t3x6(:,:,8))
  n2(7) = 4
  call heltable([4,2,8], n3(:,31), t3x8(:,:,13))
  call heltable([4,2,8], n3(:,32), t3x8(:,:,14))
  call heltable([2,3,6], n3(:,33), t3x6(:,:,9))
  call heltable([2,3,6], n3(:,34), t3x6(:,:,10))
  call heltable([2,2,4], n3(:,35), t3x4(:,:,7))
  call heltable([4,3,12], n3(:,36), t3x12(:,:,5))
  call heltable([4,3,12], n3(:,37), t3x12(:,:,6))
  call heltable([4,2,8], n3(:,38), t3x8(:,:,15))
  call heltable([4,2,8], n3(:,39), t3x8(:,:,16))
  call heltable([4,3,12], n3(:,40), t3x12(:,:,7))
  call heltable([6,2,12], n3(:,41), t3x12(:,:,8))
  call heltable([6,2,12], n3(:,42), t3x12(:,:,9))
  call heltable([4,2,8], n3(:,43), t3x8(:,:,17))
  call heltable([4,2,8], n3(:,44), t3x8(:,:,18))
  call heltable([6,2,12], n3(:,45), t3x12(:,:,10))
  call heltable([6,2,12], n3(:,46), t3x12(:,:,11))
  call heltable([4,2,8], n3(:,47), t3x8(:,:,19))
  call heltable([2,4,8], n3(:,48), t3x8(:,:,20))
  call heltable([3,2,6], n3(:,49), t3x6(:,:,11))
  n2(8) = 6
  call heltable([2,2,4], n3(:,50), t3x4(:,:,8))
  n2(9) = 4
  call heltable([2,2,4], n3(:,51), t3x4(:,:,9))
  n2(10) = 4
  call heltable([4,2,8], n3(:,52), t3x8(:,:,21))
  call heltable([2,4,8], n3(:,53), t3x8(:,:,22))
  call heltable([4,2,8], n3(:,54), t3x8(:,:,23))
  call heltable([4,2,8], n3(:,55), t3x8(:,:,24))
  call heltable([2,2,4], n3(:,56), t3x4(:,:,10))
  n2(11) = 4
  call heltable([2,2,4], n3(:,57), t3x4(:,:,11))
  n2(12) = 4
  call heltable([4,2,8], n3(:,58), t3x8(:,:,25))
  call heltable([4,2,8], n3(:,59), t3x8(:,:,26))
  call heltable([2,4,8], n3(:,60), t3x8(:,:,27))
  call heltable([4,2,8], n3(:,61), t3x8(:,:,28))
  call heltable([2,3,6], n3(:,62), t3x6(:,:,12))
  n2(13) = 6
  call heltable([6,2,12], n3(:,63), t3x12(:,:,12))
  call heltable([2,2,4], n3(:,64), t3x4(:,:,12))
  n2(14) = 4
  call heltable([4,3,12], n3(:,65), t3x12(:,:,13))
  call heltable([2,2,4], n3(:,66), t3x4(:,:,13))
  n2(15) = 4
  call heltable([4,3,12], n3(:,67), t3x12(:,:,14))
  call heltable([2,4,8], n3(:,68), t3x8(:,:,29))
  call heltable([4,2,8], n3(:,69), t3x8(:,:,30))
  call heltable([6,2,12], n3(:,70), t3x12(:,:,15))
  call heltable([4,2,8], n3(:,71), t3x8(:,:,31))
  call heltable([4,2,8], n3(:,72), t3x8(:,:,32))
  call heltable([2,4,8], n3(:,73), t3x8(:,:,33))
  call heltable([2,4,8], n3(:,74), t3x8(:,:,34))
  call heltable([2,2,4], n3(:,75), t3x4(:,:,14))
  n2(16) = 4
  call heltable([4,3,12], n3(:,76), t3x12(:,:,16))
  call heltable([2,2,4], n3(:,77), t3x4(:,:,15))
  n2(17) = 4
  call heltable([4,3,12], n3(:,78), t3x12(:,:,17))
  call heltable([4,2,8], n3(:,79), t3x8(:,:,35))
  call heltable([4,2,8], n3(:,80), t3x8(:,:,36))
  call heltable([2,4,8], n3(:,81), t3x8(:,:,37))
  call heltable([2,4,8], n3(:,82), t3x8(:,:,38))
  call heltable([2,2,4], n3(:,83), t3x4(:,:,16))
  call heltable([4,2,8], n3(:,84), t3x8(:,:,39))
  call heltable([4,2,8], n3(:,85), t3x8(:,:,40))
  call heltable([4,2,8], n3(:,86), t3x8(:,:,41))
  call heltable([4,2,8], n3(:,87), t3x8(:,:,42))
  call heltable([4,2,8], n3(:,88), t3x8(:,:,43))
  call heltable([4,2,8], n3(:,89), t3x8(:,:,44))
  call heltable([4,2,8], n3(:,90), t3x8(:,:,45))
  call heltable([4,2,8], n3(:,91), t3x8(:,:,46))
  call heltable([2,6,12], n3(:,92), t3x12(:,:,18))
  n2(18) = 4
  call heltable([2,6,12], n3(:,93), t3x12(:,:,19))
  call heltable([6,2,12], n3(:,94), t3x12(:,:,20))
  call heltable([2,6,12], n3(:,95), t3x12(:,:,21))
  n2(19) = 6
  n2(20) = 6
  n2(21) = 6
  n2(22) = 6
  call heltable([2,6,12], n3(:,96), t3x12(:,:,22))
  call heltable([2,6,12], n3(:,97), t3x12(:,:,23))
  call heltable([6,2,12], n3(:,98), t3x12(:,:,24))
  call heltable([2,6,12], n3(:,99), t3x12(:,:,25))
  n2(23) = 6
  n2(24) = 6
  n2(25) = 6
  n2(26) = 6
  call heltable([3,4,12], n3(:,100), t3x12(:,:,26))
  n2(27) = 4
  n2(28) = 12
  n2(29) = 4
  n2(30) = 4
  n2(31) = 12
  n2(32) = 4
  call heltable([2,6,12], n3(:,101), t3x12(:,:,27))
  n2(33) = 12
  n2(34) = 6
  n2(35) = 8
  n2(36) = 6
  call heltable([6,2,12], n3(:,102), t3x12(:,:,28))
  n2(37) = 12
  call heltable([3,4,12], n3(:,103), t3x12(:,:,29))
  n2(38) = 4
  n2(39) = 12
  n2(40) = 4
  n2(41) = 4
  n2(42) = 12
  n2(43) = 4
  call heltable([2,4,8], n3(:,104), t3x8(:,:,47))
  n2(44) = 6
  n2(45) = 8
  n2(46) = 6
  n2(47) = 12
  call heltable([2,6,12], n3(:,105), t3x12(:,:,30))
  n2(48) = 12
  call heltable([2,6,12], n3(:,106), t3x12(:,:,31))
  n2(49) = 12
  n2(50) = 8
  call heltable([6,2,12], n3(:,107), t3x12(:,:,32))
  n2(51) = 12
  call heltable([2,4,8], n3(:,108), t3x8(:,:,48))
  n2(52) = 8
  n2(53) = 12
  call heltable([2,6,12], n3(:,109), t3x12(:,:,33))
  n2(54) = 12
  call heltable([3,4,12], n3(:,110), t3x12(:,:,34))
  call heltable([2,6,12], n3(:,111), t3x12(:,:,35))
  call heltable([2,6,12], n3(:,112), t3x12(:,:,36))
  call heltable([6,2,12], n3(:,113), t3x12(:,:,37))
  call heltable([6,2,12], n3(:,114), t3x12(:,:,38))
  call heltable([4,12,48], n3(:,115), t3x48(:,:,1))
  call heltable([6,8,48], n3(:,116), t3x48(:,:,2))
  call heltable([6,8,48], n3(:,117), t3x48(:,:,3))
  call heltable([6,8,48], n3(:,118), t3x48(:,:,4))
  call heltable([6,8,48], n3(:,119), t3x48(:,:,5))
  call heltable([4,12,48], n3(:,120), t3x48(:,:,6))
  call heltable([6,8,48], n3(:,121), t3x48(:,:,7))
  call heltable([6,8,48], n3(:,122), t3x48(:,:,8))
  call heltable([4,12,48], n3(:,123), t3x48(:,:,9))
  call heltable([4,12,48], n3(:,124), t3x48(:,:,10))
  call heltable([6,8,48], n3(:,125), t3x48(:,:,11))
  call heltable([6,8,48], n3(:,126), t3x48(:,:,12))
  call heltable([6,8,48], n3(:,127), t3x48(:,:,13))
  call heltable([4,12,48], n3(:,128), t3x48(:,:,14))
  call heltable([6,8,48], n3(:,129), t3x48(:,:,15))
  call heltable([4,12,48], n3(:,130), t3x48(:,:,16))
  call heltable([12,4,48], n3(:,131), t3x48(:,:,17))
  call heltable([12,4,48], n3(:,132), t3x48(:,:,18))
  call heltable([6,8,48], n3(:,133), t3x48(:,:,19))
  call heltable([6,8,48], n3(:,134), t3x48(:,:,20))
  call heltable([8,6,48], n3(:,135), t3x48(:,:,21))
  call heltable([8,6,48], n3(:,136), t3x48(:,:,22))
  call heltable([12,4,48], n3(:,137), t3x48(:,:,23))
  call heltable([6,8,48], n3(:,138), t3x48(:,:,24))
  call heltable([6,8,48], n3(:,139), t3x48(:,:,25))
  call heltable([8,6,48], n3(:,140), t3x48(:,:,26))
  call heltable([8,6,48], n3(:,141), t3x48(:,:,27))
  call heltable([4,12,48], n3(:,142), t3x48(:,:,28))
  call heltable([4,12,48], n3(:,143), t3x48(:,:,29))
  call heltable([4,12,48], n3(:,144), t3x48(:,:,30))
  call heltable([6,8,48], n3(:,145), t3x48(:,:,31))
  call heltable([6,8,48], n3(:,146), t3x48(:,:,32))
  call heltable([8,6,48], n3(:,147), t3x48(:,:,33))
  call heltable([4,12,48], n3(:,148), t3x48(:,:,34))
  call heltable([4,12,48], n3(:,149), t3x48(:,:,35))
  call heltable([4,12,48], n3(:,150), t3x48(:,:,36))
  call heltable([4,12,48], n3(:,151), t3x48(:,:,37))
  call heltable([8,6,48], n3(:,152), t3x48(:,:,38))
  call heltable([6,8,48], n3(:,153), t3x48(:,:,39))
  call heltable([6,8,48], n3(:,154), t3x48(:,:,40))
  call heltable([8,6,48], n3(:,155), t3x48(:,:,41))
  call heltable([4,12,48], n3(:,156), t3x48(:,:,42))
  call heltable([4,12,48], n3(:,157), t3x48(:,:,43))
  call heltable([8,6,48], n3(:,158), t3x48(:,:,44))
  call heltable([6,8,48], n3(:,159), t3x48(:,:,45))
  call heltable([6,8,48], n3(:,160), t3x48(:,:,46))
  call heltable([6,8,48], n3(:,161), t3x48(:,:,47))
  call heltable([8,6,48], n3(:,162), t3x48(:,:,48))
  call heltable([8,6,48], n3(:,163), t3x48(:,:,49))
  call heltable([12,4,48], n3(:,164), t3x48(:,:,50))
  call heltable([12,4,48], n3(:,165), t3x48(:,:,51))
  call heltable([6,8,48], n3(:,166), t3x48(:,:,52))
  call heltable([6,8,48], n3(:,167), t3x48(:,:,53))
  call heltable([6,8,48], n3(:,168), t3x48(:,:,54))
  call heltable([8,6,48], n3(:,169), t3x48(:,:,55))
  call heltable([8,6,48], n3(:,170), t3x48(:,:,56))
  call heltable([12,4,48], n3(:,171), t3x48(:,:,57))
  call heltable([12,4,48], n3(:,172), t3x48(:,:,58))
  call heltable([6,8,48], n3(:,173), t3x48(:,:,59))
  call heltable([6,8,48], n3(:,174), t3x48(:,:,60))
  call heltable([12,4,48], n3(:,175), t3x48(:,:,61))
  call heltable([12,4,48], n3(:,176), t3x48(:,:,62))
  call heltable([12,4,48], n3(:,177), t3x48(:,:,63))
  call heltable([12,4,48], n3(:,178), t3x48(:,:,64))
  call heltable([6,8,48], n3(:,179), t3x48(:,:,65))
  call heltable([6,8,48], n3(:,180), t3x48(:,:,66))
  call heltable([6,8,48], n3(:,181), t3x48(:,:,67))
  call heltable([6,8,48], n3(:,182), t3x48(:,:,68))
  call heltable([6,8,48], n3(:,183), t3x48(:,:,69))
  call heltable([4,12,48], n3(:,184), t3x48(:,:,70))
  call heltable([4,12,48], n3(:,185), t3x48(:,:,71))
  call heltable([4,12,48], n3(:,186), t3x48(:,:,72))
  call heltable([4,12,48], n3(:,187), t3x48(:,:,73))
  call heltable([6,8,48], n3(:,188), t3x48(:,:,74))
  call heltable([6,8,48], n3(:,189), t3x48(:,:,75))
  call heltable([6,8,48], n3(:,190), t3x48(:,:,76))
  call heltable([4,12,48], n3(:,191), t3x48(:,:,77))
  call heltable([4,12,48], n3(:,192), t3x48(:,:,78))
  call heltable([6,8,48], n3(:,193), t3x48(:,:,79))
  call heltable([6,8,48], n3(:,194), t3x48(:,:,80))
  call heltable([6,8,48], n3(:,195), t3x48(:,:,81))
  call heltable([6,8,48], n3(:,196), t3x48(:,:,82))
  call heltable([4,12,48], n3(:,197), t3x48(:,:,83))
  call heltable([4,12,48], n3(:,198), t3x48(:,:,84))
  call heltable([6,8,48], n3(:,199), t3x48(:,:,85))
  call heltable([6,8,48], n3(:,200), t3x48(:,:,86))
  call heltable([6,8,48], n3(:,201), t3x48(:,:,87))
  call heltable([6,8,48], n3(:,202), t3x48(:,:,88))
  call heltable([6,8,48], n3(:,203), t3x48(:,:,89))
  call heltable([6,8,48], n3(:,204), t3x48(:,:,90))
  call heltable([6,8,48], n3(:,205), t3x48(:,:,91))
  call heltable([6,8,48], n3(:,206), t3x48(:,:,92))
  call heltable([6,8,48], n3(:,207), t3x48(:,:,93))
  call heltable([6,8,48], n3(:,208), t3x48(:,:,94))
  call heltable([6,8,48], n3(:,209), t3x48(:,:,95))
  call heltable([6,8,48], n3(:,210), t3x48(:,:,96))
  call heltable([6,8,48], n3(:,211), t3x48(:,:,97))
  call heltable([6,8,48], n3(:,212), t3x48(:,:,98))
  call heltable([6,8,48], n3(:,213), t3x48(:,:,99))
  call heltable([6,8,48], n3(:,214), t3x48(:,:,100))
  call heltable([12,4,48], n3(:,215), t3x48(:,:,101))
  call heltable([4,12,48], n3(:,216), t3x48(:,:,102))
  call heltable([4,12,48], n3(:,217), t3x48(:,:,103))
  call heltable([4,12,48], n3(:,218), t3x48(:,:,104))
  call heltable([8,6,48], n3(:,219), t3x48(:,:,105))
  call heltable([8,6,48], n3(:,220), t3x48(:,:,106))
  call heltable([8,6,48], n3(:,221), t3x48(:,:,107))
  call heltable([8,6,48], n3(:,222), t3x48(:,:,108))
  call heltable([4,12,48], n3(:,223), t3x48(:,:,109))
  call heltable([4,12,48], n3(:,224), t3x48(:,:,110))
  call heltable([4,12,48], n3(:,225), t3x48(:,:,111))
  call heltable([4,12,48], n3(:,226), t3x48(:,:,112))
  call heltable([8,6,48], n3(:,227), t3x48(:,:,113))
  call heltable([8,6,48], n3(:,228), t3x48(:,:,114))
  call heltable([8,6,48], n3(:,229), t3x48(:,:,115))
  call heltable([8,6,48], n3(:,230), t3x48(:,:,116))
  call heltable([4,12,48], n3(:,231), t3x48(:,:,117))
  call heltable([12,4,48], n3(:,232), t3x48(:,:,118))
  call heltable([4,12,48], n3(:,233), t3x48(:,:,119))
  call heltable([12,4,48], n3(:,234), t3x48(:,:,120))
  call heltable([4,12,48], n3(:,235), t3x48(:,:,121))
  call heltable([4,12,48], n3(:,236), t3x48(:,:,122))
  call heltable([6,8,48], n3(:,237), t3x48(:,:,123))
  call heltable([8,6,48], n3(:,238), t3x48(:,:,124))
  call heltable([4,12,48], n3(:,239), t3x48(:,:,125))
  call heltable([4,12,48], n3(:,240), t3x48(:,:,126))
  call heltable([8,6,48], n3(:,241), t3x48(:,:,127))
  call heltable([8,6,48], n3(:,242), t3x48(:,:,128))
  call heltable([4,12,48], n3(:,243), t3x48(:,:,129))
  call heltable([12,4,48], n3(:,244), t3x48(:,:,130))
  call heltable([4,12,48], n3(:,245), t3x48(:,:,131))
  call heltable([12,4,48], n3(:,246), t3x48(:,:,132))
  call heltable([6,8,48], n3(:,247), t3x48(:,:,133))
  call heltable([8,6,48], n3(:,248), t3x48(:,:,134))
  call heltable([4,12,48], n3(:,249), t3x48(:,:,135))
  call heltable([4,12,48], n3(:,250), t3x48(:,:,136))
  call heltable([4,12,48], n3(:,251), t3x48(:,:,137))
  call heltable([4,12,48], n3(:,252), t3x48(:,:,138))
  call heltable([8,6,48], n3(:,253), t3x48(:,:,139))
  call heltable([8,6,48], n3(:,254), t3x48(:,:,140))
  call heltable([4,12,48], n3(:,255), t3x48(:,:,141))
  call heltable([4,12,48], n3(:,256), t3x48(:,:,142))
  call heltable([6,8,48], n3(:,257), t3x48(:,:,143))
  call heltable([6,8,48], n3(:,258), t3x48(:,:,144))
  call heltable([4,12,48], n3(:,259), t3x48(:,:,145))
  call heltable([4,12,48], n3(:,260), t3x48(:,:,146))
  call heltable([8,6,48], n3(:,261), t3x48(:,:,147))
  call heltable([8,6,48], n3(:,262), t3x48(:,:,148))
  call heltable([6,8,48], n3(:,263), t3x48(:,:,149))
  call heltable([6,8,48], n3(:,264), t3x48(:,:,150))
  call heltable([4,12,48], n3(:,265), t3x48(:,:,151))
  call heltable([4,12,48], n3(:,266), t3x48(:,:,152))
  call heltable([4,12,48], n3(:,267), t3x48(:,:,153))
  call heltable([4,12,48], n3(:,268), t3x48(:,:,154))
  call heltable([8,6,48], n3(:,269), t3x48(:,:,155))
  call heltable([8,6,48], n3(:,270), t3x48(:,:,156))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_OLR_ppvvv_ew_uxdaawx_1
