
module ol_vamp_1_ppvvv_ew_uuxzzz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv_ew_uuxzzz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv_ew_uuxzzz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvv_ew_uuxzzz_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvv_ew_uuxzzz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvv_ew_uuxzzz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvv_ew_uuxzzz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(1),ngZu,m3h3x36(:,1),heltab2x108(:,:,1))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(1),n2h36(1))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,nMZ,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(1),ngZu,m3h3x36(:,2),heltab2x108(:,:,2))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(2),n2h36(2))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[0,0,nMW,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(1),ngZd,m3h3x36(:,3),heltab2x108(:,:,3))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(3),n2h36(3))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(1),ngZu,m3h3x36(:,4),heltab2x108(:,:,4))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(4),n2h36(4))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(5),m3h3x36(:,5),heltab2x108(:,:,5))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,6),heltab2x108(:,:,6))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(2),m3h3x36(:,7),heltab2x108(:,:,7))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(6),m3h3x36(:,8),heltab2x108(:,:,8))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(3),ngZu,m3h3x36(:,9),heltab2x108(:,:,9))
  call Hloop_Q_A(ntryL,G0H36(3),16,0,G1H36(7),n2h36(5))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(3),ngZu,m3h3x36(:,10),heltab2x108(:,:,10))
  call Hloop_Q_A(ntryL,G0H36(3),16,0,G1H36(8),n2h36(6))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(3),ngZd,m3h3x36(:,11),heltab2x108(:,:,11))
  call Hloop_Q_A(ntryL,G0H36(3),16,0,G1H36(9),n2h36(7))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(3),ngZu,m3h3x36(:,12),heltab2x108(:,:,12))
  call Hloop_Q_A(ntryL,G0H36(3),16,0,G1H36(10),n2h36(8))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(13),h0tab(:,13),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(3),m3h3x36(:,13),heltab2x108(:,:,13))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(14),h0tab(:,14),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(11),m3h3x36(:,14),heltab2x108(:,:,14))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(15),h0tab(:,15),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(4),m3h3x36(:,15),heltab2x108(:,:,15))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(16),h0tab(:,16),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(12),m3h3x36(:,16),heltab2x108(:,:,16))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(5),ngZu,m3h3x36(:,17),heltab2x108(:,:,17))
  call Hloop_Q_A(ntryL,G0H36(5),16,0,G1H36(13),n2h36(9))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[0,0,nMZ,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(5),ngZu,m3h3x36(:,18),heltab2x108(:,:,18))
  call Hloop_Q_A(ntryL,G0H36(5),16,0,G1H36(14),n2h36(10))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(19),h0tab(:,19),[16,4,2,1,8],[0,0,nMW,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(5),ngZd,m3h3x36(:,19),heltab2x108(:,:,19))
  call Hloop_Q_A(ntryL,G0H36(5),16,0,G1H36(15),n2h36(11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(20),h0tab(:,20),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(5),ngZu,m3h3x36(:,20),heltab2x108(:,:,20))
  call Hloop_Q_A(ntryL,G0H36(5),16,0,G1H36(16),n2h36(12))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(21),h0tab(:,21),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(17),m3h3x36(:,21),heltab2x108(:,:,21))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(22),h0tab(:,22),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(5),m3h3x36(:,22),heltab2x108(:,:,22))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(23),h0tab(:,23),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(6),m3h3x36(:,23),heltab2x108(:,:,23))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(24),h0tab(:,24),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(18),m3h3x36(:,24),heltab2x108(:,:,24))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(25),h0tab(:,25),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(7),ngZu,m3h3x36(:,25),heltab2x108(:,:,25))
  call Hloop_Q_A(ntryL,G0H36(7),16,0,G1H36(19),n2h36(13))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(26),h0tab(:,26),[16,2,1,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(7),ngZu,m3h3x36(:,26),heltab2x108(:,:,26))
  call Hloop_Q_A(ntryL,G0H36(7),16,0,G1H36(20),n2h36(14))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(27),h0tab(:,27),[16,2,1,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(7),ngZd,m3h3x36(:,27),heltab2x108(:,:,27))
  call Hloop_Q_A(ntryL,G0H36(7),16,0,G1H36(21),n2h36(15))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(28),h0tab(:,28),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(7),ngZu,m3h3x36(:,28),heltab2x108(:,:,28))
  call Hloop_Q_A(ntryL,G0H36(7),16,0,G1H36(22),n2h36(16))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(29),h0tab(:,29),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(7),m3h3x36(:,29),heltab2x108(:,:,29))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(30),h0tab(:,30),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(23),m3h3x36(:,30),heltab2x108(:,:,30))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(31),h0tab(:,31),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(8),m3h3x36(:,31),heltab2x108(:,:,31))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(32),h0tab(:,32),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(24),m3h3x36(:,32),heltab2x108(:,:,32))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(33),h0tab(:,33),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(9),ngZu,m3h3x36(:,33),heltab2x108(:,:,33))
  call Hloop_A_Q(ntryL,G0H36(9),16,0,G1H36(25),n2h36(17))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(34),h0tab(:,34),[16,1,2,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(9),ngZu,m3h3x36(:,34),heltab2x108(:,:,34))
  call Hloop_A_Q(ntryL,G0H36(9),16,0,G1H36(26),n2h36(18))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(35),h0tab(:,35),[16,1,2,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(9),ngZd,m3h3x36(:,35),heltab2x108(:,:,35))
  call Hloop_A_Q(ntryL,G0H36(9),16,0,G1H36(27),n2h36(19))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(36),h0tab(:,36),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(9),ngZu,m3h3x36(:,36),heltab2x108(:,:,36))
  call Hloop_A_Q(ntryL,G0H36(9),16,0,G1H36(28),n2h36(20))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(37),h0tab(:,37),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(9),m3h3x36(:,37),heltab2x108(:,:,37))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(38),h0tab(:,38),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(29),m3h3x36(:,38),heltab2x108(:,:,38))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(39),h0tab(:,39),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(10),m3h3x36(:,39),heltab2x108(:,:,39))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(40),h0tab(:,40),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(30),m3h3x36(:,40),heltab2x108(:,:,40))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(41),h0tab(:,41),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(11),ngZu,m3h3x36(:,41),heltab2x108(:,:,41))
  call Hloop_A_Q(ntryL,G0H36(11),16,0,G1H36(31),n2h36(21))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(42),h0tab(:,42),[16,1,2,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(11),ngZu,m3h3x36(:,42),heltab2x108(:,:,42))
  call Hloop_A_Q(ntryL,G0H36(11),16,0,G1H36(32),n2h36(22))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(43),h0tab(:,43),[16,1,2,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(11),ngZd,m3h3x36(:,43),heltab2x108(:,:,43))
  call Hloop_A_Q(ntryL,G0H36(11),16,0,G1H36(33),n2h36(23))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(44),h0tab(:,44),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(11),ngZu,m3h3x36(:,44),heltab2x108(:,:,44))
  call Hloop_A_Q(ntryL,G0H36(11),16,0,G1H36(34),n2h36(24))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(45),h0tab(:,45),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(11),m3h3x36(:,45),heltab2x108(:,:,45))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(46),h0tab(:,46),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(35),m3h3x36(:,46),heltab2x108(:,:,46))
  Gcoeff(:)%j = (c(60)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(47),h0tab(:,47),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(12),m3h3x36(:,47),heltab2x108(:,:,47))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(48),h0tab(:,48),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(36),m3h3x36(:,48),heltab2x108(:,:,48))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(49),h0tab(:,49),[16,2,4,1,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(13),ngZd,m3h3x36(:,49),heltab2x108(:,:,49))
  call Hloop_Q_A(ntryL,G0H36(13),16,0,G1H36(37),n2h36(25))
  Gcoeff(:)%j = (c(53)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(50),h0tab(:,50),[16,2,4,1,8],[nMZ,0,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(13),m3h3x36(:,50),heltab2x108(:,:,50))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(51),h0tab(:,51),[16,2,4,1,8],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(14),m3h3x36(:,51),heltab2x108(:,:,51))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(52),h0tab(:,52),[16,2,4,1,8],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(38),m3h3x36(:,52),heltab2x108(:,:,52))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(53),h0tab(:,53),[16,2,8,1,4],[0,nMW,nMW,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(15),ngZd,m3h3x36(:,53),heltab2x108(:,:,53))
  call Hloop_Q_A(ntryL,G0H36(15),16,0,G1H36(39),n2h36(26))
  Gcoeff(:)%j = (c(53)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(54),h0tab(:,54),[16,2,8,1,4],[nMZ,0,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(15),m3h3x36(:,54),heltab2x108(:,:,54))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(55),h0tab(:,55),[16,2,8,1,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(16),m3h3x36(:,55),heltab2x108(:,:,55))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(56),h0tab(:,56),[16,2,8,1,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(40),m3h3x36(:,56),heltab2x108(:,:,56))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(57),h0tab(:,57),[16,1,4,2,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(17),ngZd,m3h3x36(:,57),heltab2x108(:,:,57))
  call Hloop_A_Q(ntryL,G0H36(17),16,0,G1H36(41),n2h36(27))
  Gcoeff(:)%j = (c(53)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(58),h0tab(:,58),[16,1,4,2,8],[nMZ,0,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(17),m3h3x36(:,58),heltab2x108(:,:,58))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(59),h0tab(:,59),[16,1,4,2,8],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(18),m3h3x36(:,59),heltab2x108(:,:,59))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(60),h0tab(:,60),[16,1,4,2,8],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(42),m3h3x36(:,60),heltab2x108(:,:,60))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(61),h0tab(:,61),[16,1,4,8,2],[nMW,0,0,0,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(43),m3h3x36(:,61),heltab2x108(:,:,61))
  Gcoeff(:)%j = (c(53)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(62),h0tab(:,62),[16,1,4,8,2],[0,nMZ,nMH,nMZ,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(19),ngZu,m3h3x36(:,62),heltab2x108(:,:,62))
  call Hloop_A_Q(ntryL,G0H36(19),16,0,G1H36(44),n2h36(28))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(63),h0tab(:,63),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(19),ngZd,m3h3x36(:,63),heltab2x108(:,:,63))
  call Hloop_A_Q(ntryL,G0H36(19),16,0,G1H36(45),n2h36(29))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(64),h0tab(:,64),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(19),ngZd,m3h3x36(:,64),heltab2x108(:,:,64))
  call Hloop_A_Q(ntryL,G0H36(19),16,0,G1H36(46),n2h36(30))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(65),h0tab(:,65),[16,1,8,2,4],[0,nMW,nMW,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(19),ngZd,m3h3x36(:,65),heltab2x108(:,:,65))
  call Hloop_A_Q(ntryL,G0H36(19),16,0,G1H36(47),n2h36(31))
  Gcoeff(:)%j = (c(53)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(66),h0tab(:,66),[16,1,8,2,4],[nMZ,0,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(19),m3h3x36(:,66),heltab2x108(:,:,66))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(67),h0tab(:,67),[16,1,8,2,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(20),m3h3x36(:,67),heltab2x108(:,:,67))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(68),h0tab(:,68),[16,1,8,2,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(48),m3h3x36(:,68),heltab2x108(:,:,68))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(69),h0tab(:,69),[16,1,8,4,2],[nMW,0,0,0,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(49),m3h3x36(:,69),heltab2x108(:,:,69))
  Gcoeff(:)%j = (c(53)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(70),h0tab(:,70),[16,1,8,4,2],[0,nMZ,nMH,nMZ,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(21),ngZu,m3h3x36(:,70),heltab2x108(:,:,70))
  call Hloop_A_Q(ntryL,G0H36(21),16,0,G1H36(50),n2h36(32))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(71),h0tab(:,71),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(21),ngZd,m3h3x36(:,71),heltab2x108(:,:,71))
  call Hloop_A_Q(ntryL,G0H36(21),16,0,G1H36(51),n2h36(33))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(72),h0tab(:,72),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(21),ngZd,m3h3x36(:,72),heltab2x108(:,:,72))
  call Hloop_A_Q(ntryL,G0H36(21),16,0,G1H36(52),n2h36(34))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(4),[G1H36(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(10),[G1H36(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(16),[G1H36(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(22),[G1H36(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(28),[G1H36(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(34),[G1H36(31)])
  call Hloop_AZ_Q(ntryL,G1H36(4),ex3(:),G1H12(1),ngZu,m3h3x12(:,1),heltab2x36(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(1),n2h12(1))
  call Hloop_AZ_Q(ntryL,G1H36(2),ex3(:),G1H12(1),ngZu,m3h3x12(:,2),heltab2x36(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(2),n2h12(2))
  call Hloop_AZ_Q(ntryL,G1H36(3),ex3(:),G1H12(1),ngZd,m3h3x12(:,3),heltab2x36(:,:,3))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(3),n2h12(3))
  call Hloop_SV_V(ntryL,G1H36(5),ex3(:),G1H12(1),m3h3x12(:,4),heltab2x36(:,:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex3(:),G0H12(1),m3h3x12(:,5),heltab2x36(:,:,5))
  call Hloop_UV_W(ntryL,G0H36(2),16,ex3(:),4,G1H12(2),m3h3x12(:,6),heltab2x36(:,:,6))
  call Hloop_UV_W(ntryL,G1H36(6),16,ex3(:),4,G2H12(4),m3h3x12(:,7),heltab2x36(:,:,7))
  call Hloop_QA_V(ntryL,G1H36(10),ex2(:),G1H18(1),m3h2x18(:,1),heltab2x36(:,:,8))
  call Hloop_QA_Z(ntryL,G1H36(8),ex2(:),G1H18(2),ngZu,m3h2x18(:,2),heltab2x36(:,:,9))
  call Hloop_QA_W(ntryL,G1H36(9),ex2(:),G1H18(3),m3h2x18(:,3),heltab2x36(:,:,10))
  call Hloop_WA_Q(ntryL,G0H36(3),ex2(:),G0H18(1),m3h2x18(:,4),heltab2x36(:,:,11))
  call Hloop_A_Q(ntryL,G0H18(1),18,0,G1H18(4),n2h18(1))
  call Hloop_WA_Q(ntryL,G1H36(11),ex2(:),G1H18(5),m3h2x18(:,5),heltab2x36(:,:,12))
  call Hloop_A_Q(ntryL,G1H18(5),18,0,G2H18(1),n2h18(2))
  call Hloop_WA_Q(ntryL,G0H36(4),ex2(:),G0H18(1),m3h2x18(:,6),heltab2x36(:,:,13))
  call Hloop_A_Q(ntryL,G0H18(1),18,0,G1H18(5),n2h18(3))
  call Hloop_WA_Q(ntryL,G1H36(12),ex2(:),G1H18(6),m3h2x18(:,7),heltab2x36(:,:,14))
  call Hloop_A_Q(ntryL,G1H18(6),18,0,G2H18(2),n2h18(4))
  call Hloop_QZ_A(ntryL,G1H36(16),ex3(:),G1H12(3),ngZu,m3h3x12(:,8),heltab2x36(:,:,15))
  call Hloop_Q_A(ntryL,G1H12(3),20,0,G2H12(5),n2h12(4))
  call Hloop_QZ_A(ntryL,G1H36(14),ex3(:),G1H12(3),ngZu,m3h3x12(:,9),heltab2x36(:,:,16))
  call Hloop_Q_A(ntryL,G1H12(3),20,0,G2H12(6),n2h12(5))
  call Hloop_QZ_A(ntryL,G1H36(15),ex3(:),G1H12(3),ngZd,m3h3x12(:,10),heltab2x36(:,:,17))
  call Hloop_Q_A(ntryL,G1H12(3),20,0,G2H12(7),n2h12(6))
  call Hloop_SV_V(ntryL,G1H36(17),ex3(:),G1H12(3),m3h3x12(:,11),heltab2x36(:,:,18))
  call Hloop_SV_V(ntryL,G0H36(5),ex3(:),G0H12(2),m3h3x12(:,12),heltab2x36(:,:,19))
  call Hloop_UW_V(ntryL,G0H36(6),16,ex3(:),4,G1H12(4),m3h3x12(:,13),heltab2x36(:,:,20))
  call Hloop_UW_V(ntryL,G1H36(18),16,ex3(:),4,G2H12(8),m3h3x12(:,14),heltab2x36(:,:,21))
  call Hloop_QA_V(ntryL,G1H36(22),ex2(:),G1H18(6),m3h2x18(:,8),heltab2x36(:,:,22))
  call Hloop_QA_Z(ntryL,G1H36(20),ex2(:),G1H18(7),ngZu,m3h2x18(:,9),heltab2x36(:,:,23))
  call Hloop_QA_W(ntryL,G1H36(21),ex2(:),G1H18(8),m3h2x18(:,10),heltab2x36(:,:,24))
  call Hloop_WA_Q(ntryL,G0H36(7),ex2(:),G0H18(1),m3h2x18(:,11),heltab2x36(:,:,25))
  call Hloop_A_Q(ntryL,G0H18(1),18,0,G1H18(9),n2h18(5))
  call Hloop_WA_Q(ntryL,G1H36(23),ex2(:),G1H18(10),m3h2x18(:,12),heltab2x36(:,:,26))
  call Hloop_A_Q(ntryL,G1H18(10),18,0,G2H18(3),n2h18(6))
  call Hloop_WA_Q(ntryL,G0H36(8),ex2(:),G0H18(1),m3h2x18(:,13),heltab2x36(:,:,27))
  call Hloop_A_Q(ntryL,G0H18(1),18,0,G1H18(10),n2h18(7))
  call Hloop_WA_Q(ntryL,G1H36(24),ex2(:),G1H18(11),m3h2x18(:,14),heltab2x36(:,:,28))
  call Hloop_A_Q(ntryL,G1H18(11),18,0,G2H18(4),n2h18(8))
  call Hloop_AQ_V(ntryL,G1H36(28),ex1(:),G1H18(11),m3h2x18(:,15),heltab2x36(:,:,29))
  call Hloop_AQ_Z(ntryL,G1H36(26),ex1(:),G1H18(12),ngZu,m3h2x18(:,16),heltab2x36(:,:,30))
  call Hloop_AQ_W(ntryL,G1H36(27),ex1(:),G1H18(13),m3h2x18(:,17),heltab2x36(:,:,31))
  call Hloop_WQ_A(ntryL,G0H36(9),ex1(:),G0H18(1),m3h2x18(:,18),heltab2x36(:,:,32))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(14),n2h18(9))
  call Hloop_WQ_A(ntryL,G1H36(29),ex1(:),G1H18(15),m3h2x18(:,19),heltab2x36(:,:,33))
  call Hloop_Q_A(ntryL,G1H18(15),17,0,G2H18(5),n2h18(10))
  call Hloop_WQ_A(ntryL,G0H36(10),ex1(:),G0H18(1),m3h2x18(:,20),heltab2x36(:,:,34))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(15),n2h18(11))
  call Hloop_WQ_A(ntryL,G1H36(30),ex1(:),G1H18(16),m3h2x18(:,21),heltab2x36(:,:,35))
  call Hloop_Q_A(ntryL,G1H18(16),17,0,G2H18(6),n2h18(12))
  call Hloop_AQ_V(ntryL,G1H36(34),ex1(:),G1H18(16),m3h2x18(:,22),heltab2x36(:,:,36))
  call Hloop_AQ_Z(ntryL,G1H36(32),ex1(:),G1H18(17),ngZu,m3h2x18(:,23),heltab2x36(:,:,37))
  call Hloop_AQ_W(ntryL,G1H36(33),ex1(:),G1H18(18),m3h2x18(:,24),heltab2x36(:,:,38))
  call Hloop_WQ_A(ntryL,G0H36(11),ex1(:),G0H18(1),m3h2x18(:,25),heltab2x36(:,:,39))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(19),n2h18(13))
  call Hloop_WQ_A(ntryL,G1H36(35),ex1(:),G1H18(20),m3h2x18(:,26),heltab2x36(:,:,40))
  call Hloop_Q_A(ntryL,G1H18(20),17,0,G2H18(7),n2h18(14))
  call Hloop_WQ_A(ntryL,G0H36(12),ex1(:),G0H18(1),m3h2x18(:,27),heltab2x36(:,:,41))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(20),n2h18(15))
  call Hloop_WQ_A(ntryL,G1H36(36),ex1(:),G1H18(21),m3h2x18(:,28),heltab2x36(:,:,42))
  call Hloop_Q_A(ntryL,G1H18(21),17,0,G2H18(8),n2h18(16))
  call Hloop_QA_W(ntryL,G1H36(37),ex2(:),G1H18(21),m3h2x18(:,29),heltab2x36(:,:,43))
  call Hloop_ZA_Q(ntryL,G0H36(13),ex2(:),G0H18(1),ngZu,m3h2x18(:,30),heltab2x36(:,:,44))
  call Hloop_A_Q(ntryL,G0H18(1),18,0,G1H18(22),n2h18(17))
  call Hloop_WA_Q(ntryL,G0H36(14),ex2(:),G0H18(1),m3h2x18(:,31),heltab2x36(:,:,45))
  call Hloop_A_Q(ntryL,G0H18(1),18,0,G1H18(23),n2h18(18))
  call Hloop_WA_Q(ntryL,G1H36(38),ex2(:),G1H18(24),m3h2x18(:,32),heltab2x36(:,:,46))
  call Hloop_A_Q(ntryL,G1H18(24),18,0,G2H18(9),n2h18(19))
  call Hloop_QA_W(ntryL,G1H36(39),ex2(:),G1H18(24),m3h2x18(:,33),heltab2x36(:,:,47))
  call Hloop_ZA_Q(ntryL,G0H36(15),ex2(:),G0H18(1),ngZu,m3h2x18(:,34),heltab2x36(:,:,48))
  call Hloop_A_Q(ntryL,G0H18(1),18,0,G1H18(25),n2h18(20))
  call Hloop_WA_Q(ntryL,G0H36(16),ex2(:),G0H18(1),m3h2x18(:,35),heltab2x36(:,:,49))
  call Hloop_A_Q(ntryL,G0H18(1),18,0,G1H18(26),n2h18(21))
  call Hloop_WA_Q(ntryL,G1H36(40),ex2(:),G1H18(27),m3h2x18(:,36),heltab2x36(:,:,50))
  call Hloop_A_Q(ntryL,G1H18(27),18,0,G2H18(10),n2h18(22))
  call Hloop_AQ_W(ntryL,G1H36(41),ex1(:),G1H18(27),m3h2x18(:,37),heltab2x36(:,:,51))
  call Hloop_ZQ_A(ntryL,G0H36(17),ex1(:),G0H18(1),ngZu,m3h2x18(:,38),heltab2x36(:,:,52))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(28),n2h18(23))
  call Hloop_WQ_A(ntryL,G0H36(18),ex1(:),G0H18(1),m3h2x18(:,39),heltab2x36(:,:,53))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(29),n2h18(24))
  call Hloop_WQ_A(ntryL,G1H36(42),ex1(:),G1H18(30),m3h2x18(:,40),heltab2x36(:,:,54))
  call Hloop_Q_A(ntryL,G1H18(30),17,0,G2H18(11),n2h18(25))
  call Hloop_WQ_A(ntryL,G1H36(43),ex1(:),G1H18(30),m3h2x18(:,41),heltab2x36(:,:,55))
  call Hloop_Q_A(ntryL,G1H18(30),17,0,G2H18(12),n2h18(26))
  call Hloop_AQ_Z(ntryL,G1H36(44),ex1(:),G1H18(30),ngZu,m3h2x18(:,42),heltab2x36(:,:,56))
  call Hloop_AQ_W(ntryL,G1H36(45),ex1(:),G1H18(31),m3h2x18(:,43),heltab2x36(:,:,57))
  call Hloop_AQ_W(ntryL,G1H36(46),ex1(:),G1H18(32),m3h2x18(:,44),heltab2x36(:,:,58))
  call Hloop_AQ_W(ntryL,G1H36(47),ex1(:),G1H18(33),m3h2x18(:,45),heltab2x36(:,:,59))
  call Hloop_ZQ_A(ntryL,G0H36(19),ex1(:),G0H18(1),ngZu,m3h2x18(:,46),heltab2x36(:,:,60))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(34),n2h18(27))
  call Hloop_WQ_A(ntryL,G0H36(20),ex1(:),G0H18(1),m3h2x18(:,47),heltab2x36(:,:,61))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(35),n2h18(28))
  call Hloop_WQ_A(ntryL,G1H36(48),ex1(:),G1H18(36),m3h2x18(:,48),heltab2x36(:,:,62))
  call Hloop_Q_A(ntryL,G1H18(36),17,0,G2H18(13),n2h18(29))
  call Hloop_WQ_A(ntryL,G1H36(49),ex1(:),G1H18(36),m3h2x18(:,49),heltab2x36(:,:,63))
  call Hloop_Q_A(ntryL,G1H18(36),17,0,G2H18(14),n2h18(30))
  call Hloop_AQ_Z(ntryL,G1H36(50),ex1(:),G1H18(36),ngZu,m3h2x18(:,50),heltab2x36(:,:,64))
  call Hloop_AQ_W(ntryL,G1H36(51),ex1(:),G1H18(37),m3h2x18(:,51),heltab2x36(:,:,65))
  call Hloop_AQ_W(ntryL,G1H36(52),ex1(:),G1H18(38),m3h2x18(:,52),heltab2x36(:,:,66))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(4),[G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G1H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G0H12(2)])
  call Hloop_AQ_V(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H12(2),ex1(:),G2H6(2),ngZu,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_AQ_W(ntryL,G2H12(3),ex1(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_WQ_A(ntryL,G1H12(2),ex1(:),G1H6(1),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_Q_A(ntryL,G1H6(1),21,0,G2H6(4),n2h6(1))
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(1),mass5set(:,1),  & 
G1H12(1),G1H12(3),G1H12(2),G1H12(5),G1H12(6),G1H12(7),12)
  call HG1shiftOLR(G1H12(3),8,12)
  call Hloop_VQ_A(ntryL,G1H18(1),ex1(:),G1H9(1),m3h2x9(:,1),heltab2x18(:,:,1))
  call Hloop_Q_A(ntryL,G1H9(1),19,0,G2H9(1),n2h9(1))
  call Hloop_ZQ_A(ntryL,G1H18(2),ex1(:),G1H9(1),ngZu,m3h2x9(:,2),heltab2x18(:,:,2))
  call Hloop_Q_A(ntryL,G1H9(1),19,0,G2H9(2),n2h9(2))
  call Hloop_WQ_A(ntryL,G1H18(3),ex1(:),G1H9(1),m3h2x9(:,3),heltab2x18(:,:,3))
  call Hloop_Q_A(ntryL,G1H9(1),19,0,G2H9(3),n2h9(3))
  call Hloop_AQ_W(ntryL,G1H18(4),ex1(:),G1H9(1),m3h2x9(:,4),heltab2x18(:,:,4))
  call Hloop_AQ_W(ntryL,G2H18(1),ex1(:),G2H9(4),m3h2x9(:,5),heltab2x18(:,:,5))
  call Hloop_AQ_W(ntryL,G1H18(5),ex1(:),G1H9(2),m3h2x9(:,6),heltab2x18(:,:,6))
  call Hloop_AQ_W(ntryL,G2H18(2),ex1(:),G2H9(5),m3h2x9(:,7),heltab2x18(:,:,7))
  call Hloop_QA_V(ntryL,G2H12(5),ex2(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_QA_Z(ntryL,G2H12(6),ex2(:),G2H6(6),ngZu,m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_QA_W(ntryL,G2H12(7),ex2(:),G2H6(7),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_WA_Q(ntryL,G1H12(4),ex2(:),G1H6(1),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_A_Q(ntryL,G1H6(1),22,0,G2H6(8),n2h6(2))
  call Hotf_5pt_reduction(G2H12(8),RedSet_5(2),mass5set(:,1),  & 
G1H12(4),G1H12(8),G1H12(9),G1H12(10),G1H12(11),G1H12(12),12)
  call HG1shiftOLR(G1H12(8),8,12)
  call Hloop_VQ_A(ntryL,G1H18(6),ex1(:),G1H9(3),m3h2x9(:,8),heltab2x18(:,:,8))
  call Hloop_Q_A(ntryL,G1H9(3),19,0,G2H9(6),n2h9(4))
  call Hloop_ZQ_A(ntryL,G1H18(7),ex1(:),G1H9(3),ngZu,m3h2x9(:,9),heltab2x18(:,:,9))
  call Hloop_Q_A(ntryL,G1H9(3),19,0,G2H9(7),n2h9(5))
  call Hloop_WQ_A(ntryL,G1H18(8),ex1(:),G1H9(3),m3h2x9(:,10),heltab2x18(:,:,10))
  call Hloop_Q_A(ntryL,G1H9(3),19,0,G2H9(8),n2h9(6))
  call Hloop_AQ_W(ntryL,G1H18(9),ex1(:),G1H9(3),m3h2x9(:,11),heltab2x18(:,:,11))
  call Hloop_AQ_W(ntryL,G2H18(3),ex1(:),G2H9(9),m3h2x9(:,12),heltab2x18(:,:,12))
  call Hloop_AQ_W(ntryL,G1H18(10),ex1(:),G1H9(4),m3h2x9(:,13),heltab2x18(:,:,13))
  call Hloop_AQ_W(ntryL,G2H18(4),ex1(:),G2H9(10),m3h2x9(:,14),heltab2x18(:,:,14))
  call Hloop_VA_Q(ntryL,G1H18(11),ex2(:),G1H9(5),m3h2x9(:,15),heltab2x18(:,:,15))
  call Hloop_A_Q(ntryL,G1H9(5),19,0,G2H9(11),n2h9(7))
  call Hloop_ZA_Q(ntryL,G1H18(12),ex2(:),G1H9(5),ngZu,m3h2x9(:,16),heltab2x18(:,:,16))
  call Hloop_A_Q(ntryL,G1H9(5),19,0,G2H9(12),n2h9(8))
  call Hloop_WA_Q(ntryL,G1H18(13),ex2(:),G1H9(5),m3h2x9(:,17),heltab2x18(:,:,17))
  call Hloop_A_Q(ntryL,G1H9(5),19,0,G2H9(13),n2h9(9))
  call Hloop_QA_W(ntryL,G1H18(14),ex2(:),G1H9(5),m3h2x9(:,18),heltab2x18(:,:,18))
  call Hloop_QA_W(ntryL,G2H18(5),ex2(:),G2H9(14),m3h2x9(:,19),heltab2x18(:,:,19))
  call Hloop_QA_W(ntryL,G1H18(15),ex2(:),G1H9(6),m3h2x9(:,20),heltab2x18(:,:,20))
  call Hloop_QA_W(ntryL,G2H18(6),ex2(:),G2H9(15),m3h2x9(:,21),heltab2x18(:,:,21))
  call Hloop_VA_Q(ntryL,G1H18(16),ex2(:),G1H9(7),m3h2x9(:,22),heltab2x18(:,:,22))
  call Hloop_A_Q(ntryL,G1H9(7),19,0,G2H9(16),n2h9(10))
  call Hloop_ZA_Q(ntryL,G1H18(17),ex2(:),G1H9(7),ngZu,m3h2x9(:,23),heltab2x18(:,:,23))
  call Hloop_A_Q(ntryL,G1H9(7),19,0,G2H9(17),n2h9(11))
  call Hloop_WA_Q(ntryL,G1H18(18),ex2(:),G1H9(7),m3h2x9(:,24),heltab2x18(:,:,24))
  call Hloop_A_Q(ntryL,G1H9(7),19,0,G2H9(18),n2h9(12))
  call Hloop_QA_W(ntryL,G1H18(19),ex2(:),G1H9(7),m3h2x9(:,25),heltab2x18(:,:,25))
  call Hloop_QA_W(ntryL,G2H18(7),ex2(:),G2H9(19),m3h2x9(:,26),heltab2x18(:,:,26))
  call Hloop_QA_W(ntryL,G1H18(20),ex2(:),G1H9(8),m3h2x9(:,27),heltab2x18(:,:,27))
  call Hloop_QA_W(ntryL,G2H18(8),ex2(:),G2H9(20),m3h2x9(:,28),heltab2x18(:,:,28))
  call Hloop_UV_W(ntryL,G1H18(21),18,ex3(:),4,G2H6(9),m3h3x6(:,1),heltab2x18(:,:,29))
  call Hloop_AZ_Q(ntryL,G1H18(22),ex3(:),G1H6(1),ngZu,m3h3x6(:,2),heltab2x18(:,:,30))
  call Hloop_A_Q(ntryL,G1H6(1),22,0,G2H6(10),n2h6(3))
  call Hloop_AZ_Q(ntryL,G1H18(23),ex3(:),G1H6(1),ngZd,m3h3x6(:,3),heltab2x18(:,:,31))
  call Hloop_A_Q(ntryL,G1H6(1),22,0,G2H6(11),n2h6(4))
  call Hotf_5pt_reduction(G2H18(9),RedSet_5(3),mass5set(:,2),  & 
G1H18(1),G1H18(2),G1H18(3),G1H18(4),G1H18(5),G1H18(6),18)
  call HG1shiftOLR(G1H18(2),8,18)
  call Hloop_UV_W(ntryL,G1H18(24),18,ex4(:),8,G2H6(12),m3h3x6(:,4),heltab2x18(:,:,32))
  call Hloop_AZ_Q(ntryL,G1H18(25),ex4(:),G1H6(1),ngZu,m3h3x6(:,5),heltab2x18(:,:,33))
  call Hloop_A_Q(ntryL,G1H6(1),26,0,G2H6(13),n2h6(5))
  call Hloop_AZ_Q(ntryL,G1H18(26),ex4(:),G1H6(1),ngZd,m3h3x6(:,6),heltab2x18(:,:,34))
  call Hloop_A_Q(ntryL,G1H6(1),26,0,G2H6(14),n2h6(6))
  call Hotf_5pt_reduction(G2H18(10),RedSet_5(4),mass5set(:,2),  & 
G1H18(7),G1H18(8),G1H18(9),G1H18(10),G1H18(11),G1H18(12),18)
  call HG1shiftOLR(G1H18(8),4,18)
  call Hloop_UW_V(ntryL,G1H18(27),17,ex3(:),4,G2H6(15),m3h3x6(:,7),heltab2x18(:,:,35))
  call Hloop_QZ_A(ntryL,G1H18(28),ex3(:),G1H6(1),ngZu,m3h3x6(:,8),heltab2x18(:,:,36))
  call Hloop_Q_A(ntryL,G1H6(1),21,0,G2H6(16),n2h6(7))
  call Hloop_QZ_A(ntryL,G1H18(29),ex3(:),G1H6(1),ngZd,m3h3x6(:,9),heltab2x18(:,:,37))
  call Hloop_Q_A(ntryL,G1H6(1),21,0,G2H6(17),n2h6(8))
  call Hotf_5pt_reduction(G2H18(11),RedSet_5(5),mass5set(:,2),  & 
G1H18(13),G1H18(14),G1H18(15),G1H18(16),G1H18(17),G1H18(18),18)
  call HG1shiftOLR(G1H18(14),8,18)
  call Hotf_5pt_reduction(G2H18(12),RedSet_5(6),mass5set(:,3),  & 
G1H18(19),G1H18(20),G1H18(21),G1H18(22),G1H18(23),G1H18(24),18)
  call HG1shiftOLR(G1H18(20),2,18)
  call Hloop_VV_S(ntryL,G1H18(30),ex3(:),G1H6(1),m3h3x6(:,10),heltab2x18(:,:,38))
  call Hloop_VV_S(ntryL,G1H18(31),ex3(:),G1H6(2),m3h3x6(:,11),heltab2x18(:,:,39))
  call Hloop_UW_V(ntryL,G1H18(32),17,ex3(:),4,G2H6(18),m3h3x6(:,12),heltab2x18(:,:,40))
  call Hloop_UW_V(ntryL,G1H18(33),17,ex4(:),8,G2H6(19),m3h3x6(:,13),heltab2x18(:,:,41))
  call Hloop_QZ_A(ntryL,G1H18(34),ex4(:),G1H6(3),ngZu,m3h3x6(:,14),heltab2x18(:,:,42))
  call Hloop_Q_A(ntryL,G1H6(3),25,0,G2H6(20),n2h6(9))
  call Hloop_QZ_A(ntryL,G1H18(35),ex4(:),G1H6(3),ngZd,m3h3x6(:,15),heltab2x18(:,:,43))
  call Hloop_Q_A(ntryL,G1H6(3),25,0,G2H6(21),n2h6(10))
  call Hotf_5pt_reduction(G2H18(13),RedSet_5(7),mass5set(:,2),  & 
G1H18(25),G1H18(26),G1H18(27),G1H18(28),G1H18(29),G1H18(30),18)
  call HG1shiftOLR(G1H18(26),4,18)
  call Hotf_5pt_reduction(G2H18(14),RedSet_5(8),mass5set(:,3),  & 
G1H18(31),G1H18(32),G1H18(33),G1H18(34),G1H18(35),G1H18(39),18)
  call HG1shiftOLR(G1H18(32),2,18)
  call Hloop_VV_S(ntryL,G1H18(36),ex4(:),G1H6(3),m3h3x6(:,16),heltab2x18(:,:,44))
  call Hloop_VV_S(ntryL,G1H18(37),ex4(:),G1H6(4),m3h3x6(:,17),heltab2x18(:,:,45))
  call Hloop_UW_V(ntryL,G1H18(38),17,ex4(:),8,G2H6(22),m3h3x6(:,18),heltab2x18(:,:,46))
  call Hloop_WQ_A(ntryL,G1H12(1),ex1(:),G1H6(5),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(23),n2h6(11))
call HGT_raise_alpha_OLR(G1H12(3),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(3),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(3),-8,ex4(:),8,G2H4(1),m3h3x4(:,1),heltab2x12(:,:,10))
  call Hloop_WQ_A(ntryL,G1H12(5),ex1(:),G1H6(5),m3h2x6(:,10),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(24),n2h6(12))
  call Hloop_WQ_A(ntryL,G1H12(6),ex1(:),G1H6(5),m3h2x6(:,11),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(25),n2h6(13))
  call Hloop_WQ_A(ntryL,G1H12(7),ex1(:),G1H6(5),m3h2x6(:,12),heltab2x12(:,:,13))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(26),n2h6(14))
  call Hloop_WA_Q(ntryL,G1H12(4),ex2(:),G1H6(5),m3h2x6(:,13),heltab2x12(:,:,14))
  call Hloop_A_Q(ntryL,G1H6(5),22,0,G2H6(27),n2h6(15))
call HGT_raise_alpha_OLR(G1H12(8),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(8),-8,ex4(:),8,G2H4(2),m3h3x4(:,2),heltab2x12(:,:,15))
  call Hloop_WA_Q(ntryL,G1H12(10),ex2(:),G1H6(5),m3h2x6(:,14),heltab2x12(:,:,16))
  call Hloop_A_Q(ntryL,G1H6(5),22,0,G2H6(28),n2h6(16))
  call Hloop_WA_Q(ntryL,G1H12(11),ex2(:),G1H6(5),m3h2x6(:,15),heltab2x12(:,:,17))
  call Hloop_A_Q(ntryL,G1H6(5),22,0,G2H6(29),n2h6(17))
  call Hloop_WA_Q(ntryL,G1H12(12),ex2(:),G1H6(5),m3h2x6(:,16),heltab2x12(:,:,18))
  call Hloop_A_Q(ntryL,G1H6(5),22,0,G2H6(30),n2h6(18))
  call Hloop_AZ_Q(ntryL,G1H18(1),ex3(:),G1H6(5),ngZd,m3h3x6(:,19),heltab2x18(:,:,47))
  call Hloop_A_Q(ntryL,G1H6(5),22,0,G2H6(31),n2h6(19))
call HGT_raise_alpha_OLR(G1H18(2),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(2),2,5,18)
  call Hloop_UV_W(ntryL,G1H18(2),-8,ex4(:),8,G2H6(32),m3h3x6(:,20),heltab2x18(:,:,48))
  call Hloop_AZ_Q(ntryL,G1H18(4),ex3(:),G1H6(5),ngZd,m3h3x6(:,21),heltab2x18(:,:,49))
  call Hloop_A_Q(ntryL,G1H6(5),22,0,G2H6(33),n2h6(20))
  call Hloop_AZ_Q(ntryL,G1H18(5),ex3(:),G1H6(5),ngZd,m3h3x6(:,22),heltab2x18(:,:,50))
  call Hloop_A_Q(ntryL,G1H6(5),22,0,G2H6(34),n2h6(21))
  call Hloop_AZ_Q(ntryL,G1H18(6),ex3(:),G1H6(5),ngZd,m3h3x6(:,23),heltab2x18(:,:,51))
  call Hloop_A_Q(ntryL,G1H6(5),22,0,G2H6(35),n2h6(22))
  call Hloop_AZ_Q(ntryL,G1H18(7),ex4(:),G1H6(5),ngZd,m3h3x6(:,24),heltab2x18(:,:,52))
  call Hloop_A_Q(ntryL,G1H6(5),26,0,G2H6(36),n2h6(23))
call HGT_raise_alpha_OLR(G1H18(8),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(8),2,5,18)
  call Hloop_UV_W(ntryL,G1H18(8),-4,ex3(:),4,G2H6(37),m3h3x6(:,25),heltab2x18(:,:,53))
  call Hloop_AZ_Q(ntryL,G1H18(10),ex4(:),G1H6(5),ngZd,m3h3x6(:,26),heltab2x18(:,:,54))
  call Hloop_A_Q(ntryL,G1H6(5),26,0,G2H6(38),n2h6(24))
  call Hloop_AZ_Q(ntryL,G1H18(11),ex4(:),G1H6(5),ngZd,m3h3x6(:,27),heltab2x18(:,:,55))
  call Hloop_A_Q(ntryL,G1H6(5),26,0,G2H6(39),n2h6(25))
  call Hloop_AZ_Q(ntryL,G1H18(12),ex4(:),G1H6(5),ngZd,m3h3x6(:,28),heltab2x18(:,:,56))
  call Hloop_A_Q(ntryL,G1H6(5),26,0,G2H6(40),n2h6(26))
  call Hloop_QZ_A(ntryL,G1H18(13),ex3(:),G1H6(5),ngZd,m3h3x6(:,29),heltab2x18(:,:,57))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(41),n2h6(27))
call HGT_raise_alpha_OLR(G1H18(14),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(14),2,5,18)
  call Hloop_UW_V(ntryL,G1H18(14),-8,ex4(:),8,G2H6(42),m3h3x6(:,30),heltab2x18(:,:,58))
  call Hloop_QZ_A(ntryL,G1H18(16),ex3(:),G1H6(5),ngZd,m3h3x6(:,31),heltab2x18(:,:,59))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(43),n2h6(28))
  call Hloop_QZ_A(ntryL,G1H18(17),ex3(:),G1H6(5),ngZd,m3h3x6(:,32),heltab2x18(:,:,60))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(44),n2h6(29))
  call Hloop_QZ_A(ntryL,G1H18(18),ex3(:),G1H6(5),ngZd,m3h3x6(:,33),heltab2x18(:,:,61))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(45),n2h6(30))
  call Hloop_QZ_A(ntryL,G1H18(19),ex3(:),G1H6(5),ngZd,m3h3x6(:,34),heltab2x18(:,:,62))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(46),n2h6(31))
call HGT_raise_alpha_OLR(G1H18(20),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(20),2,5,18)
  call Hloop_WA_Q(ntryL,G1H18(20),ex2(:),G1H9(9),m3h2x9(:,29),heltab2x18(:,:,63))
  call Hloop_QZ_A(ntryL,G1H18(22),ex3(:),G1H6(5),ngZd,m3h3x6(:,35),heltab2x18(:,:,64))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(47),n2h6(32))
  call Hloop_QZ_A(ntryL,G1H18(23),ex3(:),G1H6(5),ngZd,m3h3x6(:,36),heltab2x18(:,:,65))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(48),n2h6(33))
  call Hloop_QZ_A(ntryL,G1H18(24),ex3(:),G1H6(5),ngZd,m3h3x6(:,37),heltab2x18(:,:,66))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(49),n2h6(34))
  call Hloop_QZ_A(ntryL,G1H18(25),ex4(:),G1H6(5),ngZd,m3h3x6(:,38),heltab2x18(:,:,67))
  call Hloop_Q_A(ntryL,G1H6(5),25,0,G2H6(50),n2h6(35))
call HGT_raise_alpha_OLR(G1H18(26),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(26),2,5,18)
  call Hloop_UW_V(ntryL,G1H18(26),-4,ex3(:),4,G2H6(51),m3h3x6(:,39),heltab2x18(:,:,68))
  call Hloop_QZ_A(ntryL,G1H18(28),ex4(:),G1H6(5),ngZd,m3h3x6(:,40),heltab2x18(:,:,69))
  call Hloop_Q_A(ntryL,G1H6(5),25,0,G2H6(52),n2h6(36))
  call Hloop_QZ_A(ntryL,G1H18(29),ex4(:),G1H6(5),ngZd,m3h3x6(:,41),heltab2x18(:,:,70))
  call Hloop_Q_A(ntryL,G1H6(5),25,0,G2H6(53),n2h6(37))
  call Hloop_QZ_A(ntryL,G1H18(30),ex4(:),G1H6(5),ngZd,m3h3x6(:,42),heltab2x18(:,:,71))
  call Hloop_Q_A(ntryL,G1H6(5),25,0,G2H6(54),n2h6(38))
  call Hloop_QZ_A(ntryL,G1H18(31),ex4(:),G1H6(5),ngZd,m3h3x6(:,43),heltab2x18(:,:,72))
  call Hloop_Q_A(ntryL,G1H6(5),25,0,G2H6(55),n2h6(39))
call HGT_raise_alpha_OLR(G1H18(32),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(32),2,5,18)
  call Hloop_WA_Q(ntryL,G1H18(32),ex2(:),G1H9(10),m3h2x9(:,30),heltab2x18(:,:,73))
  call Hloop_QZ_A(ntryL,G1H18(34),ex4(:),G1H6(5),ngZd,m3h3x6(:,44),heltab2x18(:,:,74))
  call Hloop_Q_A(ntryL,G1H6(5),25,0,G2H6(56),n2h6(40))
  call Hloop_QZ_A(ntryL,G1H18(35),ex4(:),G1H6(5),ngZd,m3h3x6(:,45),heltab2x18(:,:,75))
  call Hloop_Q_A(ntryL,G1H6(5),25,0,G2H6(57),n2h6(41))
  call Hloop_QZ_A(ntryL,G1H18(39),ex4(:),G1H6(5),ngZd,m3h3x6(:,46),heltab2x18(:,:,76))
  call Hloop_Q_A(ntryL,G1H6(5),25,0,G2H6(58),n2h6(42))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(1),mass5set(:,4),  & 
G1H6(5),G1H6(6),G1H6(7),G1H6(8),G1H6(9),G1H6(10),6)
  call HG1shiftOLR(G1H6(6),8,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(1),mass5set(:,5),  & 
G1H6(11),G1H6(12),G1H6(13),G1H6(14),G1H6(15),G1H6(16),6)
  call HG1shiftOLR(G1H6(12),8,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(1),mass5set(:,6),  & 
G1H6(17),G1H6(18),G1H6(19),G1H6(20),G1H6(21),G1H6(22),6)
  call HG1shiftOLR(G1H6(18),8,6)
  call Hloop_QA_W(ntryL,G2H6(4),ex2(:),G2H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hotf_5pt_reduction(G2H9(1),RedSet_5(9),mass5set(:,4),  & 
G1H9(11),G1H9(12),G1H9(13),G1H9(14),G1H9(15),G1H9(16),9)
  call HG1shiftOLR(G1H9(12),8,9)
  call Hotf_5pt_reduction(G2H9(2),RedSet_5(9),mass5set(:,7),  & 
G1H9(17),G1H9(18),G1H9(19),G1H9(20),G1H9(21),G1H9(22),9)
  call HG1shiftOLR(G1H9(18),8,9)
  call Hotf_5pt_reduction(G2H9(3),RedSet_5(9),mass5set(:,8),  & 
G1H9(23),G1H9(24),G1H9(25),G1H9(26),G1H9(27),G1H9(28),9)
  call HG1shiftOLR(G1H9(24),8,9)
  call Hloop_VV_S(ntryL,G1H9(1),ex3(:),G1H3(1),m3h3x3(:,1),heltab2x9(:,:,1))
  call Hloop_VV_S(ntryL,G2H9(4),ex3(:),G2H3(2),m3h3x3(:,2),heltab2x9(:,:,2))
  call Hloop_UW_V(ntryL,G1H9(2),19,ex3(:),4,G2H3(3),m3h3x3(:,3),heltab2x9(:,:,3))
  call Hotf_5pt_reduction(G2H9(5),RedSet_5(9),mass5set(:,9),  & 
G1H9(1),G1H9(2),G1H9(29),G1H9(30),G1H9(31),G1H9(32),9)
  call HG1shiftOLR(G1H9(2),8,9)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(2),mass5set(:,4),  & 
G1H6(23),G1H6(24),G1H6(25),G1H6(26),G1H6(27),G1H6(28),6)
  call HG1shiftOLR(G1H6(24),8,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(2),mass5set(:,5),  & 
G1H6(29),G1H6(30),G1H6(31),G1H6(32),G1H6(33),G1H6(34),6)
  call HG1shiftOLR(G1H6(30),8,6)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(2),mass5set(:,6),  & 
G1H6(35),G1H6(36),G1H6(37),G1H6(38),G1H6(39),G1H6(40),6)
  call HG1shiftOLR(G1H6(36),8,6)
  call Hloop_AQ_W(ntryL,G2H6(8),ex1(:),G2H3(4),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hotf_5pt_reduction(G2H9(6),RedSet_5(10),mass5set(:,4),  & 
G1H9(33),G1H9(34),G1H9(35),G1H9(36),G1H9(37),G1H9(38),9)
  call HG1shiftOLR(G1H9(34),4,9)
  call Hotf_5pt_reduction(G2H9(7),RedSet_5(10),mass5set(:,7),  & 
G1H9(39),G1H9(40),G1H9(41),G1H9(42),G1H9(43),G1H9(44),9)
  call HG1shiftOLR(G1H9(40),4,9)
  call Hotf_5pt_reduction(G2H9(8),RedSet_5(10),mass5set(:,8),  & 
G1H9(45),G1H9(46),G1H9(47),G1H9(48),G1H9(49),G1H9(50),9)
  call HG1shiftOLR(G1H9(46),4,9)
  call Hloop_VV_S(ntryL,G1H9(3),ex4(:),G1H3(2),m3h3x3(:,4),heltab2x9(:,:,4))
  call Hloop_VV_S(ntryL,G2H9(9),ex4(:),G2H3(5),m3h3x3(:,5),heltab2x9(:,:,5))
  call Hloop_UW_V(ntryL,G1H9(4),19,ex4(:),8,G2H3(6),m3h3x3(:,6),heltab2x9(:,:,6))
  call Hotf_5pt_reduction(G2H9(10),RedSet_5(10),mass5set(:,9),  & 
G1H9(3),G1H9(4),G1H9(51),G1H9(52),G1H9(53),G1H9(54),9)
  call HG1shiftOLR(G1H9(4),4,9)
  call Hotf_5pt_reduction(G2H9(11),RedSet_5(11),mass5set(:,4),  & 
G1H9(55),G1H9(56),G1H9(57),G1H9(58),G1H9(59),G1H9(60),9)
  call HG1shiftOLR(G1H9(56),8,9)
  call Hotf_5pt_reduction(G2H9(12),RedSet_5(11),mass5set(:,7),  & 
G1H9(61),G1H9(62),G1H9(63),G1H9(64),G1H9(65),G1H9(66),9)
  call HG1shiftOLR(G1H9(62),8,9)
  call Hotf_5pt_reduction(G2H9(13),RedSet_5(11),mass5set(:,8),  & 
G1H9(67),G1H9(68),G1H9(69),G1H9(70),G1H9(71),G1H9(72),9)
  call HG1shiftOLR(G1H9(68),8,9)
  call Hloop_VV_S(ntryL,G1H9(5),ex3(:),G1H3(3),m3h3x3(:,7),heltab2x9(:,:,7))
  call Hloop_VV_S(ntryL,G2H9(14),ex3(:),G2H3(7),m3h3x3(:,8),heltab2x9(:,:,8))
  call Hloop_UV_W(ntryL,G1H9(6),19,ex3(:),4,G2H3(8),m3h3x3(:,9),heltab2x9(:,:,9))
  call Hotf_5pt_reduction(G2H9(15),RedSet_5(11),mass5set(:,9),  & 
G1H9(5),G1H9(6),G1H9(73),G1H9(74),G1H9(75),G1H9(76),9)
  call HG1shiftOLR(G1H9(6),8,9)
  call Hotf_5pt_reduction(G2H9(16),RedSet_5(12),mass5set(:,4),  & 
G1H9(77),G1H9(78),G1H9(79),G1H9(80),G1H9(81),G1H9(82),9)
  call HG1shiftOLR(G1H9(78),4,9)
  call Hotf_5pt_reduction(G2H9(17),RedSet_5(12),mass5set(:,7),  & 
G1H9(83),G1H9(84),G1H9(85),G1H9(86),G1H9(87),G1H9(88),9)
  call HG1shiftOLR(G1H9(84),4,9)
  call Hotf_5pt_reduction(G2H9(18),RedSet_5(12),mass5set(:,8),  & 
G1H9(89),G1H9(90),G1H9(91),G1H9(92),G1H9(93),G1H9(94),9)
  call HG1shiftOLR(G1H9(90),4,9)
  call Hloop_VV_S(ntryL,G1H9(7),ex4(:),G1H3(4),m3h3x3(:,10),heltab2x9(:,:,10))
  call Hloop_VV_S(ntryL,G2H9(19),ex4(:),G2H3(9),m3h3x3(:,11),heltab2x9(:,:,11))
  call Hloop_UV_W(ntryL,G1H9(8),19,ex4(:),8,G2H3(10),m3h3x3(:,12),heltab2x9(:,:,12))
  call Hotf_5pt_reduction(G2H9(20),RedSet_5(12),mass5set(:,9),  & 
G1H9(7),G1H9(8),G1H9(95),G1H9(96),G1H9(97),G1H9(98),9)
  call HG1shiftOLR(G1H9(8),4,9)
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(3),mass5set(:,10),  & 
G1H6(41),G1H6(42),G1H6(43),G1H6(44),G1H6(45),G1H6(46),6)
  call HG1shiftOLR(G1H6(42),8,6)
  call Hloop_AQ_Z(ntryL,G2H6(10),ex1(:),G2H3(11),ngZu,m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_AQ_W(ntryL,G2H6(11),ex1(:),G2H3(12),m3h2x3(:,4),heltab2x6(:,:,4))
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(4),mass5set(:,10),  & 
G1H6(47),G1H6(48),G1H6(49),G1H6(50),G1H6(51),G1H6(52),6)
  call HG1shiftOLR(G1H6(48),4,6)
  call Hloop_AQ_Z(ntryL,G2H6(13),ex1(:),G2H3(13),ngZu,m3h2x3(:,5),heltab2x6(:,:,5))
  call Hloop_AQ_W(ntryL,G2H6(14),ex1(:),G2H3(14),m3h2x3(:,6),heltab2x6(:,:,6))
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(5),mass5set(:,10),  & 
G1H6(53),G1H6(54),G1H6(55),G1H6(56),G1H6(57),G1H6(58),6)
  call HG1shiftOLR(G1H6(54),8,6)
  call Hloop_QA_Z(ntryL,G2H6(16),ex2(:),G2H3(15),ngZu,m3h2x3(:,7),heltab2x6(:,:,7))
  call Hloop_QA_W(ntryL,G2H6(17),ex2(:),G2H3(16),m3h2x3(:,8),heltab2x6(:,:,8))
  call Hloop_SV_V(ntryL,G1H6(1),ex4(:),G1H2(1),m3h3x2(:,1),heltab2x6(:,:,9))
  call Hloop_SV_V(ntryL,G1H6(2),ex4(:),G1H2(2),m3h3x2(:,2),heltab2x6(:,:,10))
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(6),mass5set(:,11),  & 
G1H6(1),G1H6(2),G1H6(59),G1H6(60),G1H6(61),G1H6(62),6)
  call HG1shiftOLR(G1H6(2),2,6)
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(7),mass5set(:,10),  & 
G1H6(63),G1H6(64),G1H6(65),G1H6(66),G1H6(67),G1H6(68),6)
  call HG1shiftOLR(G1H6(64),4,6)
  call Hloop_QA_Z(ntryL,G2H6(20),ex2(:),G2H3(17),ngZu,m3h2x3(:,9),heltab2x6(:,:,11))
  call Hloop_QA_W(ntryL,G2H6(21),ex2(:),G2H3(18),m3h2x3(:,10),heltab2x6(:,:,12))
  call Hloop_SV_V(ntryL,G1H6(3),ex3(:),G1H2(3),m3h3x2(:,3),heltab2x6(:,:,13))
  call Hloop_SV_V(ntryL,G1H6(4),ex3(:),G1H2(4),m3h3x2(:,4),heltab2x6(:,:,14))
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(8),mass5set(:,11),  & 
G1H6(3),G1H6(4),G1H6(69),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(4),2,6)
  call Hloop_QA_W(ntryL,G2H6(23),ex2(:),G2H3(19),m3h2x3(:,11),heltab2x6(:,:,15))
  call Hloop_QA_W(ntryL,G2H6(25),ex2(:),G2H3(20),m3h2x3(:,12),heltab2x6(:,:,16))
  call Hloop_QA_W(ntryL,G2H6(26),ex2(:),G2H3(21),m3h2x3(:,13),heltab2x6(:,:,17))
  call Hloop_AQ_W(ntryL,G2H6(27),ex1(:),G2H3(22),m3h2x3(:,14),heltab2x6(:,:,18))
  call Hloop_AQ_W(ntryL,G2H6(29),ex1(:),G2H3(23),m3h2x3(:,15),heltab2x6(:,:,19))
  call Hloop_AQ_W(ntryL,G2H6(30),ex1(:),G2H3(24),m3h2x3(:,16),heltab2x6(:,:,20))
  call Hloop_AQ_W(ntryL,G2H6(31),ex1(:),G2H3(25),m3h2x3(:,17),heltab2x6(:,:,21))
  call Hloop_AQ_W(ntryL,G2H6(34),ex1(:),G2H3(26),m3h2x3(:,18),heltab2x6(:,:,22))
  call Hloop_AQ_W(ntryL,G2H6(35),ex1(:),G2H3(27),m3h2x3(:,19),heltab2x6(:,:,23))
  call Hloop_AQ_W(ntryL,G2H6(36),ex1(:),G2H3(28),m3h2x3(:,20),heltab2x6(:,:,24))
  call Hloop_AQ_W(ntryL,G2H6(39),ex1(:),G2H3(29),m3h2x3(:,21),heltab2x6(:,:,25))
  call Hloop_AQ_W(ntryL,G2H6(40),ex1(:),G2H3(30),m3h2x3(:,22),heltab2x6(:,:,26))
  call Hloop_QA_W(ntryL,G2H6(41),ex2(:),G2H3(31),m3h2x3(:,23),heltab2x6(:,:,27))
  call Hloop_QA_W(ntryL,G2H6(44),ex2(:),G2H3(32),m3h2x3(:,24),heltab2x6(:,:,28))
  call Hloop_QA_W(ntryL,G2H6(45),ex2(:),G2H3(33),m3h2x3(:,25),heltab2x6(:,:,29))
  call Hotf_5pt_reduction(G2H6(46),RedSet_5(6),mass5set(:,3),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),G1H6(78),6)
  call HG1shiftOLR(G1H6(74),2,6)
  call Hotf_4pt_reduction(G2H6(48),RedSet_4(1),mass4set(:,1),  & 
G1H6(79),G1H6(80),G1H6(81),G1H6(82),G1H6(83),6)
  call HG1shiftOLR(G1H6(80),2,6)
  call Hotf_4pt_reduction(G2H6(49),RedSet_4(2),mass4set(:,1),  & 
G1H6(84),G1H6(85),G1H6(86),G1H6(87),G1H6(88),6)
  call HG1shiftOLR(G1H6(85),10,6)
  call Hloop_QA_W(ntryL,G2H6(50),ex2(:),G2H3(34),m3h2x3(:,26),heltab2x6(:,:,30))
  call Hloop_QA_W(ntryL,G2H6(53),ex2(:),G2H3(35),m3h2x3(:,27),heltab2x6(:,:,31))
  call Hloop_QA_W(ntryL,G2H6(54),ex2(:),G2H3(36),m3h2x3(:,28),heltab2x6(:,:,32))
  call Hotf_5pt_reduction(G2H6(55),RedSet_5(8),mass5set(:,3),  & 
G1H6(89),G1H6(90),G1H6(91),G1H6(92),G1H6(93),G1H6(94),6)
  call HG1shiftOLR(G1H6(90),2,6)
  call Hotf_4pt_reduction(G2H6(57),RedSet_4(1),mass4set(:,1),  & 
G1H6(95),G1H6(96),G1H6(97),G1H6(98),G1H6(99),6)
  call HG1shiftOLR(G1H6(96),2,6)
  call Hotf_4pt_reduction(G2H6(58),RedSet_4(3),mass4set(:,1),  & 
G1H6(100),G1H6(101),G1H6(102),G1H6(103),G1H6(104),6)
  call HG1shiftOLR(G1H6(101),6,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(79),[G1H6(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(84),[G1H6(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(95),[G1H6(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(100),[G1H6(94)])
  call Hloop_VA_Q(ntryL,G1H6(5),ex2(:),G1H3(5),m3h2x3(:,29),heltab2x6(:,:,33))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(37),n2h3(1))
call HGT_OLR(G1H6(6),1,1,6)
call HGT_invQ_OLR(G1H6(6),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(6),-8,0,G2H6(1),n2h6(43))
  call Hloop_QZ_A(ntryL,G2H6(1),ex4(:),G2H2(1),ngZu,m3h3x2(:,5),heltab2x6(:,:,34))
  call Hloop_VA_Q(ntryL,G1H6(9),ex2(:),G1H3(5),m3h2x3(:,30),heltab2x6(:,:,35))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(38),n2h3(2))
  call Hloop_VA_Q(ntryL,G1H6(10),ex2(:),G1H3(5),m3h2x3(:,31),heltab2x6(:,:,36))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(39),n2h3(3))
  call Hloop_ZA_Q(ntryL,G1H6(11),ex2(:),G1H3(5),ngZu,m3h2x3(:,32),heltab2x6(:,:,37))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(40),n2h3(4))
call HGT_OLR(G1H6(12),1,1,6)
call HGT_invQ_OLR(G1H6(12),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(12),-8,0,G2H6(2),n2h6(44))
  call Hloop_QZ_A(ntryL,G2H6(2),ex4(:),G2H2(2),ngZu,m3h3x2(:,6),heltab2x6(:,:,38))
  call Hloop_ZA_Q(ntryL,G1H6(15),ex2(:),G1H3(5),ngZu,m3h2x3(:,33),heltab2x6(:,:,39))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(41),n2h3(5))
  call Hloop_ZA_Q(ntryL,G1H6(16),ex2(:),G1H3(5),ngZu,m3h2x3(:,34),heltab2x6(:,:,40))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(42),n2h3(6))
  call Hloop_WA_Q(ntryL,G1H6(17),ex2(:),G1H3(5),m3h2x3(:,35),heltab2x6(:,:,41))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(43),n2h3(7))
call HGT_OLR(G1H6(18),1,1,6)
call HGT_invQ_OLR(G1H6(18),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(18),-8,0,G2H6(3),n2h6(45))
  call Hloop_QZ_A(ntryL,G2H6(3),ex4(:),G2H2(3),ngZd,m3h3x2(:,7),heltab2x6(:,:,42))
  call Hloop_WA_Q(ntryL,G1H6(21),ex2(:),G1H3(5),m3h2x3(:,36),heltab2x6(:,:,43))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(44),n2h3(8))
  call Hloop_WA_Q(ntryL,G1H6(22),ex2(:),G1H3(5),m3h2x3(:,37),heltab2x6(:,:,44))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(45),n2h3(9))
  call Hloop_QZ_A(ntryL,G1H9(11),ex3(:),G1H3(5),ngZu,m3h3x3(:,13),heltab2x9(:,:,13))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(46),n2h3(10))
call HGT_OLR(G1H9(12),1,1,9)
call HGT_invQ_OLR(G1H9(12),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(12),-8,0,G2H9(1),n2h9(13))
  call Hloop_AZ_Q(ntryL,G2H9(1),ex4(:),G2H3(47),ngZu,m3h3x3(:,14),heltab2x9(:,:,14))
  call Hloop_QZ_A(ntryL,G1H9(15),ex3(:),G1H3(5),ngZu,m3h3x3(:,15),heltab2x9(:,:,15))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(48),n2h3(11))
  call Hloop_QZ_A(ntryL,G1H9(16),ex3(:),G1H3(5),ngZu,m3h3x3(:,16),heltab2x9(:,:,16))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(49),n2h3(12))
  call Hloop_QZ_A(ntryL,G1H9(17),ex3(:),G1H3(5),ngZu,m3h3x3(:,17),heltab2x9(:,:,17))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(50),n2h3(13))
call HGT_OLR(G1H9(18),1,1,9)
call HGT_invQ_OLR(G1H9(18),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(18),-8,0,G2H9(2),n2h9(14))
  call Hloop_AZ_Q(ntryL,G2H9(2),ex4(:),G2H3(51),ngZu,m3h3x3(:,18),heltab2x9(:,:,18))
  call Hloop_QZ_A(ntryL,G1H9(21),ex3(:),G1H3(5),ngZu,m3h3x3(:,19),heltab2x9(:,:,19))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(52),n2h3(14))
  call Hloop_QZ_A(ntryL,G1H9(22),ex3(:),G1H3(5),ngZu,m3h3x3(:,20),heltab2x9(:,:,20))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(53),n2h3(15))
  call Hloop_QZ_A(ntryL,G1H9(23),ex3(:),G1H3(5),ngZd,m3h3x3(:,21),heltab2x9(:,:,21))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(54),n2h3(16))
call HGT_OLR(G1H9(24),1,1,9)
call HGT_invQ_OLR(G1H9(24),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(24),-8,0,G2H9(3),n2h9(15))
  call Hloop_AZ_Q(ntryL,G2H9(3),ex4(:),G2H3(55),ngZd,m3h3x3(:,22),heltab2x9(:,:,22))
  call Hloop_QZ_A(ntryL,G1H9(27),ex3(:),G1H3(5),ngZd,m3h3x3(:,23),heltab2x9(:,:,23))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(56),n2h3(17))
  call Hloop_QZ_A(ntryL,G1H9(28),ex3(:),G1H3(5),ngZd,m3h3x3(:,24),heltab2x9(:,:,24))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(57),n2h3(18))
  call Hloop_UW_V(ntryL,G1H9(1),19,ex3(:),4,G2H3(58),m3h3x3(:,25),heltab2x9(:,:,25))
call HGT_raise_alpha_OLR(G1H9(2),1,1,9)
call HGT_raise_alpha_invQ_OLR(G1H9(2),2,5,9)
  call Hloop_UV_W(ntryL,G1H9(2),-8,ex4(:),8,G2H3(59),m3h3x3(:,26),heltab2x9(:,:,26))
  call Hloop_UW_V(ntryL,G1H9(31),19,ex3(:),4,G2H3(60),m3h3x3(:,27),heltab2x9(:,:,27))
  call Hloop_UW_V(ntryL,G1H9(32),19,ex3(:),4,G2H3(61),m3h3x3(:,28),heltab2x9(:,:,28))
  call Hloop_VQ_A(ntryL,G1H6(23),ex1(:),G1H3(5),m3h2x3(:,38),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(62),n2h3(19))
call HGT_OLR(G1H6(24),1,1,6)
call HGT_invQ_OLR(G1H6(24),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(24),-8,0,G2H6(4),n2h6(46))
  call Hloop_AZ_Q(ntryL,G2H6(4),ex4(:),G2H2(4),ngZu,m3h3x2(:,8),heltab2x6(:,:,46))
  call Hloop_VQ_A(ntryL,G1H6(27),ex1(:),G1H3(5),m3h2x3(:,39),heltab2x6(:,:,47))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(63),n2h3(20))
  call Hloop_VQ_A(ntryL,G1H6(28),ex1(:),G1H3(5),m3h2x3(:,40),heltab2x6(:,:,48))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(64),n2h3(21))
  call Hloop_ZQ_A(ntryL,G1H6(29),ex1(:),G1H3(5),ngZu,m3h2x3(:,41),heltab2x6(:,:,49))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(65),n2h3(22))
call HGT_OLR(G1H6(30),1,1,6)
call HGT_invQ_OLR(G1H6(30),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(30),-8,0,G2H6(5),n2h6(47))
  call Hloop_AZ_Q(ntryL,G2H6(5),ex4(:),G2H2(5),ngZu,m3h3x2(:,9),heltab2x6(:,:,50))
  call Hloop_ZQ_A(ntryL,G1H6(33),ex1(:),G1H3(5),ngZu,m3h2x3(:,42),heltab2x6(:,:,51))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(66),n2h3(23))
  call Hloop_ZQ_A(ntryL,G1H6(34),ex1(:),G1H3(5),ngZu,m3h2x3(:,43),heltab2x6(:,:,52))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(67),n2h3(24))
  call Hloop_WQ_A(ntryL,G1H6(35),ex1(:),G1H3(5),m3h2x3(:,44),heltab2x6(:,:,53))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(68),n2h3(25))
call HGT_OLR(G1H6(36),1,1,6)
call HGT_invQ_OLR(G1H6(36),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(36),-8,0,G2H6(6),n2h6(48))
  call Hloop_AZ_Q(ntryL,G2H6(6),ex4(:),G2H2(6),ngZd,m3h3x2(:,10),heltab2x6(:,:,54))
  call Hloop_WQ_A(ntryL,G1H6(39),ex1(:),G1H3(5),m3h2x3(:,45),heltab2x6(:,:,55))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(69),n2h3(26))
  call Hloop_WQ_A(ntryL,G1H6(40),ex1(:),G1H3(5),m3h2x3(:,46),heltab2x6(:,:,56))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(70),n2h3(27))
  call Hloop_QZ_A(ntryL,G1H9(33),ex4(:),G1H3(5),ngZu,m3h3x3(:,29),heltab2x9(:,:,29))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(71),n2h3(28))
call HGT_OLR(G1H9(34),1,1,9)
call HGT_invQ_OLR(G1H9(34),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(34),-4,0,G2H9(4),n2h9(17))
  call Hloop_AZ_Q(ntryL,G2H9(4),ex3(:),G2H3(72),ngZu,m3h3x3(:,30),heltab2x9(:,:,30))
  call Hloop_QZ_A(ntryL,G1H9(37),ex4(:),G1H3(5),ngZu,m3h3x3(:,31),heltab2x9(:,:,31))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(73),n2h3(29))
  call Hloop_QZ_A(ntryL,G1H9(38),ex4(:),G1H3(5),ngZu,m3h3x3(:,32),heltab2x9(:,:,32))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(74),n2h3(30))
  call Hloop_QZ_A(ntryL,G1H9(39),ex4(:),G1H3(5),ngZu,m3h3x3(:,33),heltab2x9(:,:,33))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(75),n2h3(31))
call HGT_OLR(G1H9(40),1,1,9)
call HGT_invQ_OLR(G1H9(40),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(40),-4,0,G2H9(5),n2h9(18))
  call Hloop_AZ_Q(ntryL,G2H9(5),ex3(:),G2H3(76),ngZu,m3h3x3(:,34),heltab2x9(:,:,34))
  call Hloop_QZ_A(ntryL,G1H9(43),ex4(:),G1H3(5),ngZu,m3h3x3(:,35),heltab2x9(:,:,35))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(77),n2h3(32))
  call Hloop_QZ_A(ntryL,G1H9(44),ex4(:),G1H3(5),ngZu,m3h3x3(:,36),heltab2x9(:,:,36))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(78),n2h3(33))
  call Hloop_QZ_A(ntryL,G1H9(45),ex4(:),G1H3(5),ngZd,m3h3x3(:,37),heltab2x9(:,:,37))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(79),n2h3(34))
call HGT_OLR(G1H9(46),1,1,9)
call HGT_invQ_OLR(G1H9(46),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(46),-4,0,G2H9(6),n2h9(19))
  call Hloop_AZ_Q(ntryL,G2H9(6),ex3(:),G2H3(80),ngZd,m3h3x3(:,38),heltab2x9(:,:,38))
  call Hloop_QZ_A(ntryL,G1H9(49),ex4(:),G1H3(5),ngZd,m3h3x3(:,39),heltab2x9(:,:,39))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(81),n2h3(35))
  call Hloop_QZ_A(ntryL,G1H9(50),ex4(:),G1H3(5),ngZd,m3h3x3(:,40),heltab2x9(:,:,40))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(82),n2h3(36))
  call Hloop_UW_V(ntryL,G1H9(3),19,ex4(:),8,G2H3(83),m3h3x3(:,41),heltab2x9(:,:,41))
call HGT_raise_alpha_OLR(G1H9(4),1,1,9)
call HGT_raise_alpha_invQ_OLR(G1H9(4),2,5,9)
  call Hloop_UV_W(ntryL,G1H9(4),-4,ex3(:),4,G2H3(84),m3h3x3(:,42),heltab2x9(:,:,42))
  call Hloop_UW_V(ntryL,G1H9(53),19,ex4(:),8,G2H3(85),m3h3x3(:,43),heltab2x9(:,:,43))
  call Hloop_UW_V(ntryL,G1H9(54),19,ex4(:),8,G2H3(86),m3h3x3(:,44),heltab2x9(:,:,44))
  call Hloop_AZ_Q(ntryL,G1H9(55),ex3(:),G1H3(5),ngZu,m3h3x3(:,45),heltab2x9(:,:,45))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(87),n2h3(37))
call HGT_OLR(G1H9(56),1,1,9)
call HGT_invQ_OLR(G1H9(56),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(56),-8,0,G2H9(7),n2h9(21))
  call Hloop_QZ_A(ntryL,G2H9(7),ex4(:),G2H3(88),ngZu,m3h3x3(:,46),heltab2x9(:,:,46))
  call Hloop_AZ_Q(ntryL,G1H9(59),ex3(:),G1H3(5),ngZu,m3h3x3(:,47),heltab2x9(:,:,47))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(89),n2h3(38))
  call Hloop_AZ_Q(ntryL,G1H9(60),ex3(:),G1H3(5),ngZu,m3h3x3(:,48),heltab2x9(:,:,48))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(90),n2h3(39))
  call Hloop_AZ_Q(ntryL,G1H9(61),ex3(:),G1H3(5),ngZu,m3h3x3(:,49),heltab2x9(:,:,49))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(91),n2h3(40))
call HGT_OLR(G1H9(62),1,1,9)
call HGT_invQ_OLR(G1H9(62),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(62),-8,0,G2H9(8),n2h9(22))
  call Hloop_QZ_A(ntryL,G2H9(8),ex4(:),G2H3(92),ngZu,m3h3x3(:,50),heltab2x9(:,:,50))
  call Hloop_AZ_Q(ntryL,G1H9(65),ex3(:),G1H3(5),ngZu,m3h3x3(:,51),heltab2x9(:,:,51))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(93),n2h3(41))
  call Hloop_AZ_Q(ntryL,G1H9(66),ex3(:),G1H3(5),ngZu,m3h3x3(:,52),heltab2x9(:,:,52))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(94),n2h3(42))
  call Hloop_AZ_Q(ntryL,G1H9(67),ex3(:),G1H3(5),ngZd,m3h3x3(:,53),heltab2x9(:,:,53))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(95),n2h3(43))
call HGT_OLR(G1H9(68),1,1,9)
call HGT_invQ_OLR(G1H9(68),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(68),-8,0,G2H9(9),n2h9(23))
  call Hloop_QZ_A(ntryL,G2H9(9),ex4(:),G2H3(96),ngZd,m3h3x3(:,54),heltab2x9(:,:,54))
  call Hloop_AZ_Q(ntryL,G1H9(71),ex3(:),G1H3(5),ngZd,m3h3x3(:,55),heltab2x9(:,:,55))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(97),n2h3(44))
  call Hloop_AZ_Q(ntryL,G1H9(72),ex3(:),G1H3(5),ngZd,m3h3x3(:,56),heltab2x9(:,:,56))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(98),n2h3(45))
  call Hloop_UV_W(ntryL,G1H9(5),19,ex3(:),4,G2H3(99),m3h3x3(:,57),heltab2x9(:,:,57))
call HGT_raise_alpha_OLR(G1H9(6),1,1,9)
call HGT_raise_alpha_invQ_OLR(G1H9(6),2,5,9)
  call Hloop_UW_V(ntryL,G1H9(6),-8,ex4(:),8,G2H3(100),m3h3x3(:,58),heltab2x9(:,:,58))
  call Hloop_UV_W(ntryL,G1H9(75),19,ex3(:),4,G2H3(101),m3h3x3(:,59),heltab2x9(:,:,59))
  call Hloop_UV_W(ntryL,G1H9(76),19,ex3(:),4,G2H3(102),m3h3x3(:,60),heltab2x9(:,:,60))
  call Hloop_AZ_Q(ntryL,G1H9(77),ex4(:),G1H3(5),ngZu,m3h3x3(:,61),heltab2x9(:,:,61))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(103),n2h3(46))
call HGT_OLR(G1H9(78),1,1,9)
call HGT_invQ_OLR(G1H9(78),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(78),-4,0,G2H9(10),n2h9(25))
  call Hloop_QZ_A(ntryL,G2H9(10),ex3(:),G2H3(104),ngZu,m3h3x3(:,62),heltab2x9(:,:,62))
  call Hloop_AZ_Q(ntryL,G1H9(81),ex4(:),G1H3(5),ngZu,m3h3x3(:,63),heltab2x9(:,:,63))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(105),n2h3(47))
  call Hloop_AZ_Q(ntryL,G1H9(82),ex4(:),G1H3(5),ngZu,m3h3x3(:,64),heltab2x9(:,:,64))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(106),n2h3(48))
  call Hloop_AZ_Q(ntryL,G1H9(83),ex4(:),G1H3(5),ngZu,m3h3x3(:,65),heltab2x9(:,:,65))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(107),n2h3(49))
call HGT_OLR(G1H9(84),1,1,9)
call HGT_invQ_OLR(G1H9(84),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(84),-4,0,G2H9(11),n2h9(26))
  call Hloop_QZ_A(ntryL,G2H9(11),ex3(:),G2H3(108),ngZu,m3h3x3(:,66),heltab2x9(:,:,66))
  call Hloop_AZ_Q(ntryL,G1H9(87),ex4(:),G1H3(5),ngZu,m3h3x3(:,67),heltab2x9(:,:,67))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(109),n2h3(50))
  call Hloop_AZ_Q(ntryL,G1H9(88),ex4(:),G1H3(5),ngZu,m3h3x3(:,68),heltab2x9(:,:,68))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(110),n2h3(51))
  call Hloop_AZ_Q(ntryL,G1H9(89),ex4(:),G1H3(5),ngZd,m3h3x3(:,69),heltab2x9(:,:,69))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(111),n2h3(52))
call HGT_OLR(G1H9(90),1,1,9)
call HGT_invQ_OLR(G1H9(90),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(90),-4,0,G2H9(12),n2h9(27))
  call Hloop_QZ_A(ntryL,G2H9(12),ex3(:),G2H3(112),ngZd,m3h3x3(:,70),heltab2x9(:,:,70))
  call Hloop_AZ_Q(ntryL,G1H9(93),ex4(:),G1H3(5),ngZd,m3h3x3(:,71),heltab2x9(:,:,71))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(113),n2h3(53))
  call Hloop_AZ_Q(ntryL,G1H9(94),ex4(:),G1H3(5),ngZd,m3h3x3(:,72),heltab2x9(:,:,72))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(114),n2h3(54))
  call Hloop_UV_W(ntryL,G1H9(7),19,ex4(:),8,G2H3(115),m3h3x3(:,73),heltab2x9(:,:,73))
call HGT_raise_alpha_OLR(G1H9(8),1,1,9)
call HGT_raise_alpha_invQ_OLR(G1H9(8),2,5,9)
  call Hloop_UW_V(ntryL,G1H9(8),-4,ex3(:),4,G2H3(116),m3h3x3(:,74),heltab2x9(:,:,74))
  call Hloop_UV_W(ntryL,G1H9(97),19,ex4(:),8,G2H3(117),m3h3x3(:,75),heltab2x9(:,:,75))
  call Hloop_UV_W(ntryL,G1H9(98),19,ex4(:),8,G2H3(118),m3h3x3(:,76),heltab2x9(:,:,76))
  call Hloop_WQ_A(ntryL,G1H6(41),ex1(:),G1H3(5),m3h2x3(:,47),heltab2x6(:,:,57))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(119),n2h3(55))
call HGT_OLR(G1H6(42),1,1,6)
call HGT_invQ_OLR(G1H6(42),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(42),-8,0,G2H6(7),n2h6(49))
  call Hloop_AZ_Q(ntryL,G2H6(7),ex4(:),G2H2(7),ngZd,m3h3x2(:,11),heltab2x6(:,:,58))
  call Hloop_WQ_A(ntryL,G1H6(45),ex1(:),G1H3(5),m3h2x3(:,48),heltab2x6(:,:,59))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(120),n2h3(56))
  call Hloop_WQ_A(ntryL,G1H6(46),ex1(:),G1H3(5),m3h2x3(:,49),heltab2x6(:,:,60))
  call Hloop_Q_A(ntryL,G1H3(5),23,0,G2H3(121),n2h3(57))
  call Hloop_WQ_A(ntryL,G1H6(47),ex1(:),G1H3(5),m3h2x3(:,50),heltab2x6(:,:,61))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(122),n2h3(58))
call HGT_OLR(G1H6(48),1,1,6)
call HGT_invQ_OLR(G1H6(48),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(48),-4,0,G2H6(8),n2h6(50))
  call Hloop_AZ_Q(ntryL,G2H6(8),ex3(:),G2H2(8),ngZd,m3h3x2(:,12),heltab2x6(:,:,62))
  call Hloop_WQ_A(ntryL,G1H6(51),ex1(:),G1H3(5),m3h2x3(:,51),heltab2x6(:,:,63))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(123),n2h3(59))
  call Hloop_WQ_A(ntryL,G1H6(52),ex1(:),G1H3(5),m3h2x3(:,52),heltab2x6(:,:,64))
  call Hloop_Q_A(ntryL,G1H3(5),27,0,G2H3(124),n2h3(60))
  call Hloop_WA_Q(ntryL,G1H6(53),ex2(:),G1H3(5),m3h2x3(:,53),heltab2x6(:,:,65))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(125),n2h3(61))
call HGT_OLR(G1H6(54),1,1,6)
call HGT_invQ_OLR(G1H6(54),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(54),-8,0,G2H6(9),n2h6(51))
  call Hloop_QZ_A(ntryL,G2H6(9),ex4(:),G2H2(9),ngZd,m3h3x2(:,13),heltab2x6(:,:,66))
  call Hloop_WA_Q(ntryL,G1H6(57),ex2(:),G1H3(5),m3h2x3(:,54),heltab2x6(:,:,67))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(126),n2h3(62))
  call Hloop_WA_Q(ntryL,G1H6(58),ex2(:),G1H3(5),m3h2x3(:,55),heltab2x6(:,:,68))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(127),n2h3(63))
  call Hloop_UW_V(ntryL,G1H6(1),21,ex4(:),8,G2H2(10),m3h3x2(:,14),heltab2x6(:,:,69))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(2),-2,0,G2H6(10),n2h6(52))
  call Hloop_QA_W(ntryL,G2H6(10),ex2(:),G2H3(128),m3h2x3(:,56),heltab2x6(:,:,70))
  call Hloop_UW_V(ntryL,G1H6(61),21,ex4(:),8,G2H2(11),m3h3x2(:,15),heltab2x6(:,:,71))
  call Hloop_UW_V(ntryL,G1H6(62),21,ex4(:),8,G2H2(12),m3h3x2(:,16),heltab2x6(:,:,72))
  call Hloop_WA_Q(ntryL,G1H6(63),ex2(:),G1H3(5),m3h2x3(:,57),heltab2x6(:,:,73))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(129),n2h3(64))
call HGT_OLR(G1H6(64),1,1,6)
call HGT_invQ_OLR(G1H6(64),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(64),-4,0,G2H6(11),n2h6(53))
  call Hloop_QZ_A(ntryL,G2H6(11),ex3(:),G2H2(13),ngZd,m3h3x2(:,17),heltab2x6(:,:,74))
  call Hloop_WA_Q(ntryL,G1H6(67),ex2(:),G1H3(5),m3h2x3(:,58),heltab2x6(:,:,75))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(130),n2h3(65))
  call Hloop_WA_Q(ntryL,G1H6(68),ex2(:),G1H3(5),m3h2x3(:,59),heltab2x6(:,:,76))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(131),n2h3(66))
  call Hloop_UW_V(ntryL,G1H6(3),25,ex3(:),4,G2H2(14),m3h3x2(:,18),heltab2x6(:,:,77))
call HGT_OLR(G1H6(4),1,1,6)
call HGT_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(4),-2,0,G2H6(12),n2h6(54))
  call Hloop_QA_W(ntryL,G2H6(12),ex2(:),G2H3(132),m3h2x3(:,60),heltab2x6(:,:,78))
  call Hloop_UW_V(ntryL,G1H6(71),25,ex3(:),4,G2H2(15),m3h3x2(:,19),heltab2x6(:,:,79))
  call Hloop_UW_V(ntryL,G1H6(72),25,ex3(:),4,G2H2(16),m3h3x2(:,20),heltab2x6(:,:,80))
  call Hloop_QZ_A(ntryL,G1H6(73),ex4(:),G1H2(5),ngZd,m3h3x2(:,21),heltab2x6(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(17),n2h2(1))
call HGT_raise_alpha_OLR(G1H6(74),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(74),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(74),ex2(:),G1H3(5),m3h2x3(:,61),heltab2x6(:,:,82))
  call Hloop_QZ_A(ntryL,G1H6(79),ex4(:),G1H2(5),ngZd,m3h3x2(:,22),heltab2x6(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(18),n2h2(2))
  call Hloop_QZ_A(ntryL,G1H6(84),ex4(:),G1H2(5),ngZd,m3h3x2(:,23),heltab2x6(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(19),n2h2(3))
call HGT_raise_alpha_OLR(G1H6(80),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(80),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(80),ex2(:),G1H3(6),m3h2x3(:,62),heltab2x6(:,:,85))
  call Hloop_QZ_A(ntryL,G1H6(83),ex4(:),G1H2(5),ngZd,m3h3x2(:,24),heltab2x6(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(20),n2h2(4))
call HGT_raise_alpha_OLR(G1H6(85),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(85),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(85),ex2(:),G1H3(7),m3h2x3(:,63),heltab2x6(:,:,87))
  call Hloop_QZ_A(ntryL,G1H6(88),ex4(:),G1H2(5),ngZd,m3h3x2(:,25),heltab2x6(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(21),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H6(89),ex3(:),G1H2(5),ngZd,m3h3x2(:,26),heltab2x6(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(22),n2h2(6))
call HGT_raise_alpha_OLR(G1H6(90),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(90),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(90),ex2(:),G1H3(8),m3h2x3(:,64),heltab2x6(:,:,90))
  call Hloop_QZ_A(ntryL,G1H6(95),ex3(:),G1H2(5),ngZd,m3h3x2(:,27),heltab2x6(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(23),n2h2(7))
  call Hloop_QZ_A(ntryL,G1H6(100),ex3(:),G1H2(5),ngZd,m3h3x2(:,28),heltab2x6(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(24),n2h2(8))
call HGT_raise_alpha_OLR(G1H6(96),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(96),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(96),ex2(:),G1H3(9),m3h2x3(:,65),heltab2x6(:,:,93))
  call Hloop_QZ_A(ntryL,G1H6(99),ex3(:),G1H2(5),ngZd,m3h3x2(:,29),heltab2x6(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(25),n2h2(9))
call HGT_raise_alpha_OLR(G1H6(101),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(101),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(101),ex2(:),G1H3(10),m3h2x3(:,66),heltab2x6(:,:,95))
  call Hloop_QZ_A(ntryL,G1H6(104),ex3(:),G1H2(5),ngZd,m3h3x2(:,30),heltab2x6(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(26),n2h2(10))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(4)])
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(1),ex4(:),G2tensor(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(1),23,ex4(:),8,G2tensor(2),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(2),ex4(:),G2tensor(3),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(3),ex4(:),G2tensor(4),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(4),ex4(:),G2tensor(5),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(2),27,ex3(:),4,G2tensor(6),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(5),ex3(:),G2tensor(7),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(6),ex3(:),G2tensor(8),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(3),23,ex4(:),8,G2tensor(9),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(7),ex4(:),G2tensor(10),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(8),ex4(:),G2tensor(11),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(4),27,ex3(:),4,G2tensor(12),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(9),ex3(:),G2tensor(13),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(10),ex3(:),G2tensor(14),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(11),ex4(:),G2tensor(15),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(12),ex4(:),G2tensor(16),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(13),ex3(:),G2tensor(17),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(14),ex3(:),G2tensor(18),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(15),ex4(:),G2tensor(19),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(16),ex4(:),G2tensor(20),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hloop_ZA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),ngZu,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(1))
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(6),mass5set(:,11),  & 
G1H2(5),G1H2(2),G1H2(4),G1H2(1),G1H2(6),G1H2(7),2)
  call HG1shiftOLR(G1H2(2),2,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(17),ex3(:),G2tensor(22),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(18),ex3(:),G2tensor(23),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hloop_ZA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),ngZu,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(2))
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(8),mass5set(:,11),  & 
G1H2(3),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),2,2)
  call Hotf_5pt_reduction(G2H3(19),RedSet_5(1),mass5set(:,1),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(11),G1H3(12),3)
  call HG1shiftOLR(G1H3(2),8,3)
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(4),mass4set(:,2),  & 
G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),3)
  call HG1shiftOLR(G1H3(14),10,3)
  call Hotf_5pt_reduction(G2H3(22),RedSet_5(2),mass5set(:,1),  & 
G1H3(18),G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),3)
  call HG1shiftOLR(G1H3(19),8,3)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(5),mass4set(:,2),  & 
G1H3(24),G1H3(25),G1H3(26),G1H3(27),G1H3(28),3)
  call HG1shiftOLR(G1H3(25),9,3)
  call Hotf_5pt_reduction(G2H3(25),RedSet_5(3),mass5set(:,2),  & 
G1H3(29),G1H3(30),G1H3(31),G1H3(32),G1H3(33),G1H3(34),3)
  call HG1shiftOLR(G1H3(30),8,3)
  call Hotf_4pt_reduction(G2H3(27),RedSet_4(6),mass4set(:,1),  & 
G1H3(35),G1H3(36),G1H3(37),G1H3(38),G1H3(39),3)
  call HG1shiftOLR(G1H3(36),9,3)
  call Hotf_5pt_reduction(G2H3(28),RedSet_5(4),mass5set(:,2),  & 
G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),G1H3(45),3)
  call HG1shiftOLR(G1H3(41),4,3)
  call Hotf_4pt_reduction(G2H3(30),RedSet_4(7),mass4set(:,1),  & 
G1H3(46),G1H3(47),G1H3(48),G1H3(49),G1H3(50),3)
  call HG1shiftOLR(G1H3(47),5,3)
  call Hotf_5pt_reduction(G2H3(31),RedSet_5(5),mass5set(:,2),  & 
G1H3(51),G1H3(52),G1H3(53),G1H3(54),G1H3(55),G1H3(56),3)
  call HG1shiftOLR(G1H3(52),8,3)
  call Hotf_4pt_reduction(G2H3(33),RedSet_4(2),mass4set(:,1),  & 
G1H3(57),G1H3(58),G1H3(59),G1H3(60),G1H3(61),3)
  call HG1shiftOLR(G1H3(58),10,3)
  call Hotf_5pt_reduction(G2H3(34),RedSet_5(7),mass5set(:,2),  & 
G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),G1H3(67),3)
  call HG1shiftOLR(G1H3(63),4,3)
  call Hotf_4pt_reduction(G2H3(36),RedSet_4(3),mass4set(:,1),  & 
G1H3(68),G1H3(69),G1H3(70),G1H3(71),G1H3(72),3)
  call HG1shiftOLR(G1H3(69),6,3)
  call Hotf_5pt_reduction(G2H3(37),RedSet_5(1),mass5set(:,4),  & 
G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),G1H3(78),3)
  call HG1shiftOLR(G1H3(74),8,3)
  call Hotf_4pt_reduction(G2H3(39),RedSet_4(4),mass4set(:,3),  & 
G1H3(79),G1H3(80),G1H3(81),G1H3(82),G1H3(83),3)
  call HG1shiftOLR(G1H3(80),10,3)
  call Hotf_5pt_reduction(G2H3(40),RedSet_5(1),mass5set(:,5),  & 
G1H3(84),G1H3(85),G1H3(86),G1H3(87),G1H3(88),G1H3(89),3)
  call HG1shiftOLR(G1H3(85),8,3)
  call Hotf_4pt_reduction(G2H3(42),RedSet_4(4),mass4set(:,4),  & 
G1H3(90),G1H3(91),G1H3(92),G1H3(93),G1H3(94),3)
  call HG1shiftOLR(G1H3(91),10,3)
  call Hotf_5pt_reduction(G2H3(43),RedSet_5(1),mass5set(:,6),  & 
G1H3(95),G1H3(96),G1H3(97),G1H3(98),G1H3(99),G1H3(100),3)
  call HG1shiftOLR(G1H3(96),8,3)
  call Hotf_4pt_reduction(G2H3(45),RedSet_4(4),mass4set(:,5),  & 
G1H3(101),G1H3(102),G1H3(103),G1H3(104),G1H3(105),3)
  call HG1shiftOLR(G1H3(102),10,3)
  call Hotf_5pt_reduction(G2H3(46),RedSet_5(9),mass5set(:,4),  & 
G1H3(106),G1H3(107),G1H3(108),G1H3(109),G1H3(110),G1H3(111),3)
  call HG1shiftOLR(G1H3(107),8,3)
  call Hotf_4pt_reduction(G2H3(49),RedSet_4(8),mass4set(:,3),  & 
G1H3(112),G1H3(113),G1H3(114),G1H3(115),G1H3(116),3)
  call HG1shiftOLR(G1H3(113),12,3)
  call Hotf_5pt_reduction(G2H3(50),RedSet_5(9),mass5set(:,7),  & 
G1H3(117),G1H3(118),G1H3(119),G1H3(120),G1H3(121),G1H3(122),3)
  call HG1shiftOLR(G1H3(118),8,3)
  call Hotf_4pt_reduction(G2H3(53),RedSet_4(8),mass4set(:,6),  & 
G1H3(123),G1H3(124),G1H3(125),G1H3(126),G1H3(127),3)
  call HG1shiftOLR(G1H3(124),12,3)
  call Hotf_5pt_reduction(G2H3(54),RedSet_5(9),mass5set(:,8),  & 
G1H3(128),G1H3(129),G1H3(130),G1H3(131),G1H3(132),G1H3(133),3)
  call HG1shiftOLR(G1H3(129),8,3)
  call Hotf_4pt_reduction(G2H3(57),RedSet_4(8),mass4set(:,7),  & 
G1H3(134),G1H3(135),G1H3(136),G1H3(137),G1H3(138),3)
  call HG1shiftOLR(G1H3(135),12,3)
  call Hotf_5pt_reduction(G2H3(58),RedSet_5(9),mass5set(:,9),  & 
G1H3(139),G1H3(140),G1H3(141),G1H3(142),G1H3(143),G1H3(144),3)
  call HG1shiftOLR(G1H3(140),8,3)
  call Hotf_4pt_reduction(G2H3(61),RedSet_4(8),mass4set(:,8),  & 
G1H3(145),G1H3(146),G1H3(147),G1H3(148),G1H3(149),3)
  call HG1shiftOLR(G1H3(146),12,3)
  call Hotf_5pt_reduction(G2H3(62),RedSet_5(2),mass5set(:,4),  & 
G1H3(150),G1H3(151),G1H3(152),G1H3(153),G1H3(154),G1H3(155),3)
  call HG1shiftOLR(G1H3(151),8,3)
  call Hotf_4pt_reduction(G2H3(64),RedSet_4(5),mass4set(:,3),  & 
G1H3(156),G1H3(157),G1H3(158),G1H3(159),G1H3(160),3)
  call HG1shiftOLR(G1H3(157),9,3)
  call Hotf_5pt_reduction(G2H3(65),RedSet_5(2),mass5set(:,5),  & 
G1H3(161),G1H3(162),G1H3(163),G1H3(164),G1H3(165),G1H3(166),3)
  call HG1shiftOLR(G1H3(162),8,3)
  call Hotf_4pt_reduction(G2H3(67),RedSet_4(5),mass4set(:,4),  & 
G1H3(167),G1H3(168),G1H3(169),G1H3(170),G1H3(171),3)
  call HG1shiftOLR(G1H3(168),9,3)
  call Hotf_5pt_reduction(G2H3(68),RedSet_5(2),mass5set(:,6),  & 
G1H3(172),G1H3(173),G1H3(174),G1H3(175),G1H3(176),G1H3(177),3)
  call HG1shiftOLR(G1H3(173),8,3)
  call Hotf_4pt_reduction(G2H3(70),RedSet_4(5),mass4set(:,5),  & 
G1H3(178),G1H3(179),G1H3(180),G1H3(181),G1H3(182),3)
  call HG1shiftOLR(G1H3(179),9,3)
  call Hotf_5pt_reduction(G2H3(71),RedSet_5(10),mass5set(:,4),  & 
G1H3(183),G1H3(184),G1H3(185),G1H3(186),G1H3(187),G1H3(188),3)
  call HG1shiftOLR(G1H3(184),4,3)
  call Hotf_4pt_reduction(G2H3(74),RedSet_4(8),mass4set(:,3),  & 
G1H3(189),G1H3(190),G1H3(191),G1H3(192),G1H3(193),3)
  call HG1shiftOLR(G1H3(190),12,3)
  call Hotf_5pt_reduction(G2H3(75),RedSet_5(10),mass5set(:,7),  & 
G1H3(194),G1H3(195),G1H3(196),G1H3(197),G1H3(198),G1H3(199),3)
  call HG1shiftOLR(G1H3(195),4,3)
  call Hotf_4pt_reduction(G2H3(78),RedSet_4(8),mass4set(:,6),  & 
G1H3(200),G1H3(201),G1H3(202),G1H3(203),G1H3(204),3)
  call HG1shiftOLR(G1H3(201),12,3)
  call Hotf_5pt_reduction(G2H3(79),RedSet_5(10),mass5set(:,8),  & 
G1H3(205),G1H3(206),G1H3(207),G1H3(208),G1H3(209),G1H3(210),3)
  call HG1shiftOLR(G1H3(206),4,3)
  call Hotf_4pt_reduction(G2H3(82),RedSet_4(8),mass4set(:,7),  & 
G1H3(211),G1H3(212),G1H3(213),G1H3(214),G1H3(215),3)
  call HG1shiftOLR(G1H3(212),12,3)
  call Hotf_5pt_reduction(G2H3(83),RedSet_5(10),mass5set(:,9),  & 
G1H3(216),G1H3(217),G1H3(218),G1H3(219),G1H3(220),G1H3(221),3)
  call HG1shiftOLR(G1H3(217),4,3)
  call Hotf_4pt_reduction(G2H3(86),RedSet_4(8),mass4set(:,8),  & 
G1H3(222),G1H3(223),G1H3(224),G1H3(225),G1H3(226),3)
  call HG1shiftOLR(G1H3(223),12,3)
  call Hotf_5pt_reduction(G2H3(87),RedSet_5(11),mass5set(:,4),  & 
G1H3(227),G1H3(228),G1H3(229),G1H3(230),G1H3(231),G1H3(232),3)
  call HG1shiftOLR(G1H3(228),8,3)
  call Hotf_4pt_reduction(G2H3(90),RedSet_4(9),mass4set(:,3),  & 
G1H3(233),G1H3(234),G1H3(235),G1H3(236),G1H3(237),3)
  call HG1shiftOLR(G1H3(234),12,3)
  call Hotf_5pt_reduction(G2H3(91),RedSet_5(11),mass5set(:,7),  & 
G1H3(238),G1H3(239),G1H3(240),G1H3(241),G1H3(242),G1H3(243),3)
  call HG1shiftOLR(G1H3(239),8,3)
  call Hotf_4pt_reduction(G2H3(94),RedSet_4(9),mass4set(:,6),  & 
G1H3(244),G1H3(245),G1H3(246),G1H3(247),G1H3(248),3)
  call HG1shiftOLR(G1H3(245),12,3)
  call Hotf_5pt_reduction(G2H3(95),RedSet_5(11),mass5set(:,8),  & 
G1H3(249),G1H3(250),G1H3(251),G1H3(252),G1H3(253),G1H3(254),3)
  call HG1shiftOLR(G1H3(250),8,3)
  call Hotf_4pt_reduction(G2H3(98),RedSet_4(9),mass4set(:,7),  & 
G1H3(255),G1H3(256),G1H3(257),G1H3(258),G1H3(259),3)
  call HG1shiftOLR(G1H3(256),12,3)
  call Hotf_5pt_reduction(G2H3(99),RedSet_5(11),mass5set(:,9),  & 
G1H3(260),G1H3(261),G1H3(262),G1H3(263),G1H3(264),G1H3(265),3)
  call HG1shiftOLR(G1H3(261),8,3)
  call Hotf_4pt_reduction(G2H3(102),RedSet_4(9),mass4set(:,8),  & 
G1H3(266),G1H3(267),G1H3(268),G1H3(269),G1H3(270),3)
  call HG1shiftOLR(G1H3(267),12,3)
  call Hotf_5pt_reduction(G2H3(103),RedSet_5(12),mass5set(:,4),  & 
G1H3(271),G1H3(272),G1H3(273),G1H3(274),G1H3(275),G1H3(276),3)
  call HG1shiftOLR(G1H3(272),4,3)
  call Hotf_4pt_reduction(G2H3(106),RedSet_4(9),mass4set(:,3),  & 
G1H3(277),G1H3(278),G1H3(279),G1H3(280),G1H3(281),3)
  call HG1shiftOLR(G1H3(278),12,3)
  call Hotf_5pt_reduction(G2H3(107),RedSet_5(12),mass5set(:,7),  & 
G1H3(282),G1H3(283),G1H3(284),G1H3(285),G1H3(286),G1H3(287),3)
  call HG1shiftOLR(G1H3(283),4,3)
  call Hotf_4pt_reduction(G2H3(110),RedSet_4(9),mass4set(:,6),  & 
G1H3(288),G1H3(289),G1H3(290),G1H3(291),G1H3(292),3)
  call HG1shiftOLR(G1H3(289),12,3)
  call Hotf_5pt_reduction(G2H3(111),RedSet_5(12),mass5set(:,8),  & 
G1H3(293),G1H3(294),G1H3(295),G1H3(296),G1H3(297),G1H3(298),3)
  call HG1shiftOLR(G1H3(294),4,3)
  call Hotf_4pt_reduction(G2H3(114),RedSet_4(9),mass4set(:,7),  & 
G1H3(299),G1H3(300),G1H3(301),G1H3(302),G1H3(303),3)
  call HG1shiftOLR(G1H3(300),12,3)
  call Hotf_5pt_reduction(G2H3(115),RedSet_5(12),mass5set(:,9),  & 
G1H3(304),G1H3(305),G1H3(306),G1H3(307),G1H3(308),G1H3(309),3)
  call HG1shiftOLR(G1H3(305),4,3)
  call Hotf_4pt_reduction(G2H3(118),RedSet_4(9),mass4set(:,8),  & 
G1H3(310),G1H3(311),G1H3(312),G1H3(313),G1H3(314),3)
  call HG1shiftOLR(G1H3(311),12,3)
  call Hotf_5pt_reduction(G2H3(119),RedSet_5(3),mass5set(:,10),  & 
G1H3(315),G1H3(316),G1H3(317),G1H3(318),G1H3(319),G1H3(320),3)
  call HG1shiftOLR(G1H3(316),8,3)
  call Hotf_4pt_reduction(G2H3(121),RedSet_4(6),mass4set(:,9),  & 
G1H3(321),G1H3(322),G1H3(323),G1H3(324),G1H3(325),3)
  call HG1shiftOLR(G1H3(322),9,3)
  call Hotf_5pt_reduction(G2H3(122),RedSet_5(4),mass5set(:,10),  & 
G1H3(326),G1H3(327),G1H3(328),G1H3(329),G1H3(330),G1H3(331),3)
  call HG1shiftOLR(G1H3(327),4,3)
  call Hotf_4pt_reduction(G2H3(124),RedSet_4(7),mass4set(:,9),  & 
G1H3(332),G1H3(333),G1H3(334),G1H3(335),G1H3(336),3)
  call HG1shiftOLR(G1H3(333),5,3)
  call Hotf_5pt_reduction(G2H3(125),RedSet_5(5),mass5set(:,10),  & 
G1H3(337),G1H3(338),G1H3(339),G1H3(340),G1H3(341),G1H3(342),3)
  call HG1shiftOLR(G1H3(338),8,3)
  call Hotf_4pt_reduction(G2H3(127),RedSet_4(2),mass4set(:,9),  & 
G1H3(343),G1H3(344),G1H3(345),G1H3(346),G1H3(347),3)
  call HG1shiftOLR(G1H3(344),10,3)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(2),mass4set(:,9),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(14),10,2)
  call Hotf_5pt_reduction(G2H3(129),RedSet_5(7),mass5set(:,10),  & 
G1H3(348),G1H3(349),G1H3(350),G1H3(351),G1H3(352),G1H3(353),3)
  call HG1shiftOLR(G1H3(349),4,3)
  call Hotf_4pt_reduction(G2H3(131),RedSet_4(3),mass4set(:,9),  & 
G1H3(354),G1H3(355),G1H3(356),G1H3(357),G1H3(358),3)
  call HG1shiftOLR(G1H3(355),6,3)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(3),mass4set(:,9),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),6,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(17),ex2(:),G2tensor(25),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(19),ex2(:),G2tensor(26),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(22),ex2(:),G2tensor(27),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(24),ex2(:),G2tensor(28),m3h2x1(:,6),heltab2x2(:,:,6))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(13),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(24),[G1H3(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(35),[G1H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(46),[G1H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(57),[G1H3(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(68),[G1H3(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(79),[G1H3(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(90),[G1H3(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(101),[G1H3(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(112),[G1H3(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(123),[G1H3(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(134),[G1H3(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(145),[G1H3(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(156),[G1H3(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(167),[G1H3(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(178),[G1H3(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(189),[G1H3(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(200),[G1H3(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(211),[G1H3(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(222),[G1H3(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(233),[G1H3(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(244),[G1H3(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(255),[G1H3(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(266),[G1H3(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(277),[G1H3(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(288),[G1H3(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(299),[G1H3(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(310),[G1H3(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(321),[G1H3(320)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(332),[G1H3(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(343),[G1H3(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(354),[G1H3(353)])
  call Hloop_WA_Q(ntryL,G1H2(5),ex2(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(3))
  call Hloop_WA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(30),n2h1(4))
  call Hloop_WA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(5))
  call Hloop_WA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(6))
  call Hloop_WA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(33),n2h1(7))
  call Hloop_WA_Q(ntryL,G1H2(18),ex2(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(8))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(1),23,ex4(:),8,G2tensor(35),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(2),0,ex4(:),8,G2tensor(36),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(13),23,ex4(:),8,G2tensor(37),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(14),2,ex4(:),8,G2tensor(38),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(18),23,ex4(:),8,G2tensor(39),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(19),0,ex4(:),8,G2tensor(40),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(24),23,ex4(:),8,G2tensor(41),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(25),1,ex4(:),8,G2tensor(42),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(29),23,ex4(:),8,G2tensor(43),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(30),0,ex4(:),8,G2tensor(44),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(35),23,ex4(:),8,G2tensor(45),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(36),1,ex4(:),8,G2tensor(46),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(40),27,ex3(:),4,G2tensor(47),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(41),0,ex3(:),4,G2tensor(48),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(46),27,ex3(:),4,G2tensor(49),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(47),1,ex3(:),4,G2tensor(50),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(51),23,ex4(:),8,G2tensor(51),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(52),0,ex4(:),8,G2tensor(52),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(57),23,ex4(:),8,G2tensor(53),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(58),2,ex4(:),8,G2tensor(54),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(62),27,ex3(:),4,G2tensor(55),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(63),0,ex3(:),4,G2tensor(56),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(68),27,ex3(:),4,G2tensor(57),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(69),2,ex3(:),4,G2tensor(58),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hloop_AZ_Q(ntryL,G1H3(73),ex4(:),G1H1(1),ngZu,m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(21))
  call Hloop_AZ_Q(ntryL,G1H3(74),ex4(:),G1H1(1),ngZu,m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(60),n2h1(22))
  call Hloop_AZ_Q(ntryL,G1H3(79),ex4(:),G1H1(1),ngZu,m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(23))
  call Hloop_AZ_Q(ntryL,G1H3(80),ex4(:),G1H1(1),ngZu,m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(62),n2h1(24))
  call Hloop_AZ_Q(ntryL,G1H3(84),ex4(:),G1H1(1),ngZu,m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(25))
  call Hloop_AZ_Q(ntryL,G1H3(85),ex4(:),G1H1(1),ngZu,m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(64),n2h1(26))
  call Hloop_AZ_Q(ntryL,G1H3(90),ex4(:),G1H1(1),ngZu,m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(27))
  call Hloop_AZ_Q(ntryL,G1H3(91),ex4(:),G1H1(1),ngZu,m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(66),n2h1(28))
  call Hloop_AZ_Q(ntryL,G1H3(95),ex4(:),G1H1(1),ngZd,m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(29))
  call Hloop_AZ_Q(ntryL,G1H3(96),ex4(:),G1H1(1),ngZd,m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(68),n2h1(30))
  call Hloop_AZ_Q(ntryL,G1H3(101),ex4(:),G1H1(1),ngZd,m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(31))
  call Hloop_AZ_Q(ntryL,G1H3(102),ex4(:),G1H1(1),ngZd,m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(70),n2h1(32))
  call Hloop_QZ_A(ntryL,G1H3(106),ex4(:),G1H1(1),ngZu,m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(33))
  call Hloop_QZ_A(ntryL,G1H3(107),ex4(:),G1H1(1),ngZu,m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(72),n2h1(34))
  call Hloop_QZ_A(ntryL,G1H3(112),ex4(:),G1H1(1),ngZu,m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(35))
  call Hloop_QZ_A(ntryL,G1H3(113),ex4(:),G1H1(1),ngZu,m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(74),n2h1(36))
  call Hloop_QZ_A(ntryL,G1H3(117),ex4(:),G1H1(1),ngZu,m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(37))
  call Hloop_QZ_A(ntryL,G1H3(118),ex4(:),G1H1(1),ngZu,m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(76),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H3(123),ex4(:),G1H1(1),ngZu,m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H3(124),ex4(:),G1H1(1),ngZu,m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(78),n2h1(40))
  call Hloop_QZ_A(ntryL,G1H3(128),ex4(:),G1H1(1),ngZd,m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(41))
  call Hloop_QZ_A(ntryL,G1H3(129),ex4(:),G1H1(1),ngZd,m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(80),n2h1(42))
  call Hloop_QZ_A(ntryL,G1H3(134),ex4(:),G1H1(1),ngZd,m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(43))
  call Hloop_QZ_A(ntryL,G1H3(135),ex4(:),G1H1(1),ngZd,m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(82),n2h1(44))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(139),23,ex4(:),8,G2tensor(83),m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(140),0,ex4(:),8,G2tensor(84),m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(145),23,ex4(:),8,G2tensor(85),m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(146),4,ex4(:),8,G2tensor(86),m3h3x1(:,74),heltab2x3(:,:,74))
  call Hloop_QZ_A(ntryL,G1H3(150),ex4(:),G1H1(1),ngZu,m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(47))
  call Hloop_QZ_A(ntryL,G1H3(151),ex4(:),G1H1(1),ngZu,m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(88),n2h1(48))
  call Hloop_QZ_A(ntryL,G1H3(156),ex4(:),G1H1(1),ngZu,m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(49))
  call Hloop_QZ_A(ntryL,G1H3(157),ex4(:),G1H1(1),ngZu,m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(90),n2h1(50))
  call Hloop_QZ_A(ntryL,G1H3(161),ex4(:),G1H1(1),ngZu,m3h3x1(:,79),heltab2x3(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(51))
  call Hloop_QZ_A(ntryL,G1H3(162),ex4(:),G1H1(1),ngZu,m3h3x1(:,80),heltab2x3(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(92),n2h1(52))
  call Hloop_QZ_A(ntryL,G1H3(167),ex4(:),G1H1(1),ngZu,m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(53))
  call Hloop_QZ_A(ntryL,G1H3(168),ex4(:),G1H1(1),ngZu,m3h3x1(:,82),heltab2x3(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(94),n2h1(54))
  call Hloop_QZ_A(ntryL,G1H3(172),ex4(:),G1H1(1),ngZd,m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(55))
  call Hloop_QZ_A(ntryL,G1H3(173),ex4(:),G1H1(1),ngZd,m3h3x1(:,84),heltab2x3(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(96),n2h1(56))
  call Hloop_QZ_A(ntryL,G1H3(178),ex4(:),G1H1(1),ngZd,m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(57))
  call Hloop_QZ_A(ntryL,G1H3(179),ex4(:),G1H1(1),ngZd,m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(98),n2h1(58))
  call Hloop_QZ_A(ntryL,G1H3(183),ex3(:),G1H1(1),ngZu,m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(99),n2h1(59))
  call Hloop_QZ_A(ntryL,G1H3(184),ex3(:),G1H1(1),ngZu,m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(100),n2h1(60))
  call Hloop_QZ_A(ntryL,G1H3(189),ex3(:),G1H1(1),ngZu,m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(101),n2h1(61))
  call Hloop_QZ_A(ntryL,G1H3(190),ex3(:),G1H1(1),ngZu,m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(102),n2h1(62))
  call Hloop_QZ_A(ntryL,G1H3(194),ex3(:),G1H1(1),ngZu,m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(63))
  call Hloop_QZ_A(ntryL,G1H3(195),ex3(:),G1H1(1),ngZu,m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(104),n2h1(64))
  call Hloop_QZ_A(ntryL,G1H3(200),ex3(:),G1H1(1),ngZu,m3h3x1(:,93),heltab2x3(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(105),n2h1(65))
  call Hloop_QZ_A(ntryL,G1H3(201),ex3(:),G1H1(1),ngZu,m3h3x1(:,94),heltab2x3(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(106),n2h1(66))
  call Hloop_QZ_A(ntryL,G1H3(205),ex3(:),G1H1(1),ngZd,m3h3x1(:,95),heltab2x3(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(107),n2h1(67))
  call Hloop_QZ_A(ntryL,G1H3(206),ex3(:),G1H1(1),ngZd,m3h3x1(:,96),heltab2x3(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(108),n2h1(68))
  call Hloop_QZ_A(ntryL,G1H3(211),ex3(:),G1H1(1),ngZd,m3h3x1(:,97),heltab2x3(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(109),n2h1(69))
  call Hloop_QZ_A(ntryL,G1H3(212),ex3(:),G1H1(1),ngZd,m3h3x1(:,98),heltab2x3(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(110),n2h1(70))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(216),27,ex3(:),4,G2tensor(111),m3h3x1(:,99),heltab2x3(:,:,99))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(217),0,ex3(:),4,G2tensor(112),m3h3x1(:,100),heltab2x3(:,:,100))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(222),27,ex3(:),4,G2tensor(113),m3h3x1(:,101),heltab2x3(:,:,101))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(223),8,ex3(:),4,G2tensor(114),m3h3x1(:,102),heltab2x3(:,:,102))
  call Hloop_AZ_Q(ntryL,G1H3(227),ex4(:),G1H1(1),ngZu,m3h3x1(:,103),heltab2x3(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(115),n2h1(73))
  call Hloop_AZ_Q(ntryL,G1H3(228),ex4(:),G1H1(1),ngZu,m3h3x1(:,104),heltab2x3(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(116),n2h1(74))
  call Hloop_AZ_Q(ntryL,G1H3(233),ex4(:),G1H1(1),ngZu,m3h3x1(:,105),heltab2x3(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(117),n2h1(75))
  call Hloop_AZ_Q(ntryL,G1H3(234),ex4(:),G1H1(1),ngZu,m3h3x1(:,106),heltab2x3(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(118),n2h1(76))
  call Hloop_AZ_Q(ntryL,G1H3(238),ex4(:),G1H1(1),ngZu,m3h3x1(:,107),heltab2x3(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(77))
  call Hloop_AZ_Q(ntryL,G1H3(239),ex4(:),G1H1(1),ngZu,m3h3x1(:,108),heltab2x3(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(120),n2h1(78))
  call Hloop_AZ_Q(ntryL,G1H3(244),ex4(:),G1H1(1),ngZu,m3h3x1(:,109),heltab2x3(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(121),n2h1(79))
  call Hloop_AZ_Q(ntryL,G1H3(245),ex4(:),G1H1(1),ngZu,m3h3x1(:,110),heltab2x3(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(122),n2h1(80))
  call Hloop_AZ_Q(ntryL,G1H3(249),ex4(:),G1H1(1),ngZd,m3h3x1(:,111),heltab2x3(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(123),n2h1(81))
  call Hloop_AZ_Q(ntryL,G1H3(250),ex4(:),G1H1(1),ngZd,m3h3x1(:,112),heltab2x3(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(124),n2h1(82))
  call Hloop_AZ_Q(ntryL,G1H3(255),ex4(:),G1H1(1),ngZd,m3h3x1(:,113),heltab2x3(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(125),n2h1(83))
  call Hloop_AZ_Q(ntryL,G1H3(256),ex4(:),G1H1(1),ngZd,m3h3x1(:,114),heltab2x3(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(126),n2h1(84))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(260),23,ex4(:),8,G2tensor(127),m3h3x1(:,115),heltab2x3(:,:,115))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(261),0,ex4(:),8,G2tensor(128),m3h3x1(:,116),heltab2x3(:,:,116))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(266),23,ex4(:),8,G2tensor(129),m3h3x1(:,117),heltab2x3(:,:,117))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(267),4,ex4(:),8,G2tensor(130),m3h3x1(:,118),heltab2x3(:,:,118))
  call Hloop_AZ_Q(ntryL,G1H3(271),ex3(:),G1H1(1),ngZu,m3h3x1(:,119),heltab2x3(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(87))
  call Hloop_AZ_Q(ntryL,G1H3(272),ex3(:),G1H1(1),ngZu,m3h3x1(:,120),heltab2x3(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(132),n2h1(88))
  call Hloop_AZ_Q(ntryL,G1H3(277),ex3(:),G1H1(1),ngZu,m3h3x1(:,121),heltab2x3(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(133),n2h1(89))
  call Hloop_AZ_Q(ntryL,G1H3(278),ex3(:),G1H1(1),ngZu,m3h3x1(:,122),heltab2x3(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(134),n2h1(90))
  call Hloop_AZ_Q(ntryL,G1H3(282),ex3(:),G1H1(1),ngZu,m3h3x1(:,123),heltab2x3(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(135),n2h1(91))
  call Hloop_AZ_Q(ntryL,G1H3(283),ex3(:),G1H1(1),ngZu,m3h3x1(:,124),heltab2x3(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(136),n2h1(92))
  call Hloop_AZ_Q(ntryL,G1H3(288),ex3(:),G1H1(1),ngZu,m3h3x1(:,125),heltab2x3(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(137),n2h1(93))
  call Hloop_AZ_Q(ntryL,G1H3(289),ex3(:),G1H1(1),ngZu,m3h3x1(:,126),heltab2x3(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(138),n2h1(94))
  call Hloop_AZ_Q(ntryL,G1H3(293),ex3(:),G1H1(1),ngZd,m3h3x1(:,127),heltab2x3(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(139),n2h1(95))
  call Hloop_AZ_Q(ntryL,G1H3(294),ex3(:),G1H1(1),ngZd,m3h3x1(:,128),heltab2x3(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(140),n2h1(96))
  call Hloop_AZ_Q(ntryL,G1H3(299),ex3(:),G1H1(1),ngZd,m3h3x1(:,129),heltab2x3(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(141),n2h1(97))
  call Hloop_AZ_Q(ntryL,G1H3(300),ex3(:),G1H1(1),ngZd,m3h3x1(:,130),heltab2x3(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(142),n2h1(98))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(304),27,ex3(:),4,G2tensor(143),m3h3x1(:,131),heltab2x3(:,:,131))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(305),0,ex3(:),4,G2tensor(144),m3h3x1(:,132),heltab2x3(:,:,132))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(310),27,ex3(:),4,G2tensor(145),m3h3x1(:,133),heltab2x3(:,:,133))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(311),8,ex3(:),4,G2tensor(146),m3h3x1(:,134),heltab2x3(:,:,134))
  call Hloop_QZ_A(ntryL,G1H3(315),ex4(:),G1H1(1),ngZd,m3h3x1(:,135),heltab2x3(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(147),n2h1(101))
  call Hloop_QZ_A(ntryL,G1H3(316),ex4(:),G1H1(1),ngZd,m3h3x1(:,136),heltab2x3(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(148),n2h1(102))
  call Hloop_QZ_A(ntryL,G1H3(321),ex4(:),G1H1(1),ngZd,m3h3x1(:,137),heltab2x3(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(149),n2h1(103))
  call Hloop_QZ_A(ntryL,G1H3(322),ex4(:),G1H1(1),ngZd,m3h3x1(:,138),heltab2x3(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(150),n2h1(104))
  call Hloop_QZ_A(ntryL,G1H3(326),ex3(:),G1H1(1),ngZd,m3h3x1(:,139),heltab2x3(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(151),n2h1(105))
  call Hloop_QZ_A(ntryL,G1H3(327),ex3(:),G1H1(1),ngZd,m3h3x1(:,140),heltab2x3(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(152),n2h1(106))
  call Hloop_QZ_A(ntryL,G1H3(332),ex3(:),G1H1(1),ngZd,m3h3x1(:,141),heltab2x3(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(153),n2h1(107))
  call Hloop_QZ_A(ntryL,G1H3(333),ex3(:),G1H1(1),ngZd,m3h3x1(:,142),heltab2x3(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(154),n2h1(108))
  call Hloop_AZ_Q(ntryL,G1H3(337),ex4(:),G1H1(1),ngZd,m3h3x1(:,143),heltab2x3(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(155),n2h1(109))
  call Hloop_AZ_Q(ntryL,G1H3(338),ex4(:),G1H1(1),ngZd,m3h3x1(:,144),heltab2x3(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(156),n2h1(110))
  call Hloop_AZ_Q(ntryL,G1H3(343),ex4(:),G1H1(1),ngZd,m3h3x1(:,145),heltab2x3(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(157),n2h1(111))
  call Hloop_AZ_Q(ntryL,G1H3(344),ex4(:),G1H1(1),ngZd,m3h3x1(:,146),heltab2x3(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(158),n2h1(112))
  call Hloop_WA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(159),n2h1(113))
  call Hloop_AZ_Q(ntryL,G1H3(348),ex3(:),G1H1(1),ngZd,m3h3x1(:,147),heltab2x3(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(160),n2h1(114))
  call Hloop_AZ_Q(ntryL,G1H3(349),ex3(:),G1H1(1),ngZd,m3h3x1(:,148),heltab2x3(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(161),n2h1(115))
  call Hloop_AZ_Q(ntryL,G1H3(354),ex3(:),G1H1(1),ngZd,m3h3x1(:,149),heltab2x3(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(162),n2h1(116))
  call Hloop_AZ_Q(ntryL,G1H3(355),ex3(:),G1H1(1),ngZd,m3h3x1(:,150),heltab2x3(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(163),n2h1(117))
  call Hloop_WA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(164),n2h1(118))
  call ol_merge_tensors(G2tensor(35),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(4),G2tensor(3),G2tensor(2)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(8),G2tensor(7),G2tensor(6)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(11),G2tensor(10),G2tensor(9)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(14),G2tensor(13),G2tensor(12)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(16)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(18)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(20)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(23)])
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(9),mass5set(:,9),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(10),mass5set(:,9),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(11),mass5set(:,9),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(143),RedSet_5(12),mass5set(:,9),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(3),mass5set(:,12),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(3),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(4),mass5set(:,12),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),4)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(4),mass5set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(5),mass5set(:,12),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(5),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(6),mass5set(:,13),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),2)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(7),mass5set(:,12),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(7),mass5set(:,2),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),4)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(8),mass5set(:,13),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(6),mass5set(:,3),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),2)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(8),mass5set(:,3),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),2)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(6),mass5set(:,11),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),2)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(8),mass5set(:,11),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),2)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(1),mass5set(:,4),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(1),mass5set(:,5),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(1),mass5set(:,6),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(9),mass5set(:,4),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(9),mass5set(:,7),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(9),mass5set(:,8),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(2),mass5set(:,4),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(2),mass5set(:,5),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),8)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(2),mass5set(:,6),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(10),mass5set(:,4),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),4)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(10),mass5set(:,7),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(10),mass5set(:,8),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(11),mass5set(:,4),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(11),mass5set(:,7),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(11),mass5set(:,8),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),8)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(12),mass5set(:,4),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(12),mass5set(:,7),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),4)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(12),mass5set(:,8),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_5pt_reduction_last(G2tensor(147),RedSet_5(3),mass5set(:,10),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(4),mass5set(:,10),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),4)
  call Hotf_5pt_reduction_last(G2tensor(155),RedSet_5(5),mass5set(:,10),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_5pt_reduction_last(G2tensor(160),RedSet_5(7),mass5set(:,10),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  Gcoeff(:)%j = (c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(73),h0tab(:,73),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H108(1),ex5(:),ex4(:),G0H12(1),m4h3x3x12(:,1),heltab3x108(:,:,1))
  Gcoeff(:)%j = (c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(74),h0tab(:,74),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H108(1),ex5(:),ex4(:),G0H12(2),m4h3x3x12(:,2),heltab3x108(:,:,2))
  Gcoeff(:)%j = (c(16)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(75),h0tab(:,75),[24,1,4,2],[nMW,0,0,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H108(1),ex5(:),ex4(:),G0H12(3),m4h3x3x12(:,3),heltab3x108(:,:,3))
  Gcoeff(:)%j = (c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(76),h0tab(:,76),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H108(1),ex5(:),ex3(:),G0H12(4),m4h3x3x12(:,4),heltab3x108(:,:,4))
  Gcoeff(:)%j = (c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(77),h0tab(:,77),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H108(1),ex5(:),ex3(:),G0H12(5),m4h3x3x12(:,5),heltab3x108(:,:,5))
  Gcoeff(:)%j = (c(16)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(78),h0tab(:,78),[20,1,8,2],[nMW,0,0,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H108(1),ex5(:),ex3(:),G0H12(6),m4h3x3x12(:,6),heltab3x108(:,:,6))
  Gcoeff(:)%j = (c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(79),h0tab(:,79),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(1),m3h3x36(:,73),heltab2x108(:,:,73))
  Gcoeff(:)%j = (c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(80),h0tab(:,80),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(7),m3h3x36(:,74),heltab2x108(:,:,74))
  Gcoeff(:)%j = (c(16)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(81),h0tab(:,81),[16,1,12,2],[0,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(21),ngZd,m3h3x36(:,75),heltab2x108(:,:,75))
  call Hloop_A_Q(ntryL,G0H36(21),16,0,G1H36(13),n2h36(35))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(82),h0tab(:,82),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(1),ngZl,m3h3x36(:,76),heltab2x108(:,:,76))
  call Hloop_Q_A(ntryL,G0H36(1),16,nME,G1H36(19),n2h36(36))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(83),h0tab(:,83),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(2),ngZl,m3h3x36(:,77),heltab2x108(:,:,77))
  call Hloop_Q_A(ntryL,G0H36(2),16,nMM,G1H36(25),n2h36(37))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(84),h0tab(:,84),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(3),ngZl,m3h3x36(:,78),heltab2x108(:,:,78))
  call Hloop_Q_A(ntryL,G0H36(3),16,nML,G1H36(31),n2h36(38))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(85),h0tab(:,85),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(4),ngZl,m3h3x36(:,79),heltab2x108(:,:,79))
  call Hloop_A_Q(ntryL,G0H36(4),16,nME,G1H36(4),n2h36(39))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(86),h0tab(:,86),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(5),ngZl,m3h3x36(:,80),heltab2x108(:,:,80))
  call Hloop_A_Q(ntryL,G0H36(5),16,nMM,G1H36(2),n2h36(40))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(87),h0tab(:,87),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(6),ngZl,m3h3x36(:,81),heltab2x108(:,:,81))
  call Hloop_A_Q(ntryL,G0H36(6),16,nML,G1H36(3),n2h36(41))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(88),h0tab(:,88),[16,3,8,4],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(7),ngZu,m3h3x36(:,82),heltab2x108(:,:,82))
  call Hloop_Q_A(ntryL,G0H36(7),16,0,G1H36(5),n2h36(42))
  Gcoeff(:)%j = (c(101)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(89),h0tab(:,89),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(8),ngZu,m3h3x36(:,83),heltab2x108(:,:,83))
  call Hloop_Q_A(ntryL,G0H36(8),16,nMT,G1H36(6),n2h36(43))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(90),h0tab(:,90),[16,3,8,4],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(9),ngZu,m3h3x36(:,84),heltab2x108(:,:,84))
  call Hloop_A_Q(ntryL,G0H36(9),16,0,G1H36(10),n2h36(44))
  Gcoeff(:)%j = (c(101)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(91),h0tab(:,91),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(10),ngZu,m3h3x36(:,85),heltab2x108(:,:,85))
  call Hloop_A_Q(ntryL,G0H36(10),16,nMT,G1H36(8),n2h36(45))
  Gcoeff(:)%j = (-(c(101)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(92),h0tab(:,92),[16,3,8,4],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(11),ngZd,m3h3x36(:,86),heltab2x108(:,:,86))
  call Hloop_Q_A(ntryL,G0H36(11),16,0,G1H36(9),n2h36(46))
  Gcoeff(:)%j = (-(c(100)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(93),h0tab(:,93),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(12),ngZd,m3h3x36(:,87),heltab2x108(:,:,87))
  call Hloop_Q_A(ntryL,G0H36(12),16,nMB,G1H36(11),n2h36(47))
  Gcoeff(:)%j = (-(c(101)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(94),h0tab(:,94),[16,3,8,4],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(13),ngZd,m3h3x36(:,88),heltab2x108(:,:,88))
  call Hloop_A_Q(ntryL,G0H36(13),16,0,G1H36(12),n2h36(48))
  Gcoeff(:)%j = (-(c(100)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(95),h0tab(:,95),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(14),ngZd,m3h3x36(:,89),heltab2x108(:,:,89))
  call Hloop_A_Q(ntryL,G0H36(14),16,nMB,G1H36(16),n2h36(49))
  Gcoeff(:)%j = (c(107)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(96),h0tab(:,96),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(15),ngZn,m3h3x36(:,90),heltab2x108(:,:,90))
  call Hloop_Q_A(ntryL,G0H36(15),16,0,G1H36(14),n2h36(50))
  Gcoeff(:)%j = (c(107)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(97),h0tab(:,97),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(16),ngZn,m3h3x36(:,91),heltab2x108(:,:,91))
  call Hloop_A_Q(ntryL,G0H36(16),16,0,G1H36(15),n2h36(51))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(98),h0tab(:,98),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(17),ngZl,m3h3x36(:,92),heltab2x108(:,:,92))
  call Hloop_Q_A(ntryL,G0H36(17),16,nME,G1H36(17),n2h36(52))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(99),h0tab(:,99),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(18),ngZl,m3h3x36(:,93),heltab2x108(:,:,93))
  call Hloop_Q_A(ntryL,G0H36(18),16,nMM,G1H36(18),n2h36(53))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(100),h0tab(:,100),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(19),ngZl,m3h3x36(:,94),heltab2x108(:,:,94))
  call Hloop_Q_A(ntryL,G0H36(19),16,nML,G1H36(22),n2h36(54))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(101),h0tab(:,101),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(20),ngZl,m3h3x36(:,95),heltab2x108(:,:,95))
  call Hloop_A_Q(ntryL,G0H36(20),16,nME,G1H36(20),n2h36(55))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(102),h0tab(:,102),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(21),ngZl,m3h3x36(:,96),heltab2x108(:,:,96))
  call Hloop_A_Q(ntryL,G0H36(21),16,nMM,G1H36(21),n2h36(56))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(103),h0tab(:,103),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(1),ngZl,m3h3x36(:,97),heltab2x108(:,:,97))
  call Hloop_A_Q(ntryL,G0H36(1),16,nML,G1H36(23),n2h36(57))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(104),h0tab(:,104),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(2),ngZu,m3h3x36(:,98),heltab2x108(:,:,98))
  call Hloop_Q_A(ntryL,G0H36(2),16,0,G1H36(24),n2h36(58))
  Gcoeff(:)%j = (c(105)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(105),h0tab(:,105),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(3),ngZu,m3h3x36(:,99),heltab2x108(:,:,99))
  call Hloop_Q_A(ntryL,G0H36(3),16,nMT,G1H36(28),n2h36(59))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(106),h0tab(:,106),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(4),ngZu,m3h3x36(:,100),heltab2x108(:,:,100))
  call Hloop_A_Q(ntryL,G0H36(4),16,0,G1H36(26),n2h36(60))
  Gcoeff(:)%j = (c(105)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(107),h0tab(:,107),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(5),ngZu,m3h3x36(:,101),heltab2x108(:,:,101))
  call Hloop_A_Q(ntryL,G0H36(5),16,nMT,G1H36(27),n2h36(61))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(108),h0tab(:,108),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(6),ngZd,m3h3x36(:,102),heltab2x108(:,:,102))
  call Hloop_Q_A(ntryL,G0H36(6),16,0,G1H36(29),n2h36(62))
  Gcoeff(:)%j = (c(105)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(109),h0tab(:,109),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(7),ngZd,m3h3x36(:,103),heltab2x108(:,:,103))
  call Hloop_Q_A(ntryL,G0H36(7),16,nMB,G1H36(30),n2h36(63))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(110),h0tab(:,110),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(8),ngZd,m3h3x36(:,104),heltab2x108(:,:,104))
  call Hloop_A_Q(ntryL,G0H36(8),16,0,G1H36(34),n2h36(64))
  Gcoeff(:)%j = (c(105)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(111),h0tab(:,111),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(9),ngZd,m3h3x36(:,105),heltab2x108(:,:,105))
  call Hloop_A_Q(ntryL,G0H36(9),16,nMB,G1H36(32),n2h36(65))
  Gcoeff(:)%j = (c(85)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(112),h0tab(:,112),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(33),m3h3x36(:,106),heltab2x108(:,:,106))
  Gcoeff(:)%j = (c(85)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(113),h0tab(:,113),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(35),m3h3x36(:,107),heltab2x108(:,:,107))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(114),h0tab(:,114),[16,3,8,4],[nMH,nMZ,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(36),m3h3x36(:,108),heltab2x108(:,:,108))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(115),h0tab(:,115),[16,3,8,4],[nMZ,nMH,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(37),m3h3x36(:,109),heltab2x108(:,:,109))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(116),h0tab(:,116),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(38),m3h3x36(:,110),heltab2x108(:,:,110))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(117),h0tab(:,117),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(39),m3h3x36(:,111),heltab2x108(:,:,111))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(118),h0tab(:,118),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H108(1),0,ex5(:),16,G1H36(40),m3h3x36(:,112),heltab2x108(:,:,112))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(119),h0tab(:,119),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H108(1),0,ex5(:),G1H36(41),m3h3x36(:,113),heltab2x108(:,:,113))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(120),h0tab(:,120),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H108(1),0,ex5(:),16,G1H36(42),m3h3x36(:,114),heltab2x108(:,:,114))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(121),h0tab(:,121),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H108(1),0,ex5(:),G1H36(43),m3h3x36(:,115),heltab2x108(:,:,115))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(122),h0tab(:,122),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H108(1),0,ex5(:),16,G1H36(44),m3h3x36(:,116),heltab2x108(:,:,116))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(123),h0tab(:,123),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H108(1),0,ex5(:),G1H36(45),m3h3x36(:,117),heltab2x108(:,:,117))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(124),h0tab(:,124),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H108(1),0,ex5(:),16,G1H36(46),m3h3x36(:,118),heltab2x108(:,:,118))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(125),h0tab(:,125),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H108(1),0,ex5(:),G1H36(47),m3h3x36(:,119),heltab2x108(:,:,119))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(126),h0tab(:,126),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(48),m3h3x36(:,120),heltab2x108(:,:,120))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(127),h0tab(:,127),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(49),m3h3x36(:,121),heltab2x108(:,:,121))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(128),h0tab(:,128),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(50),m3h3x36(:,122),heltab2x108(:,:,122))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(129),h0tab(:,129),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(51),m3h3x36(:,123),heltab2x108(:,:,123))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(130),h0tab(:,130),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(10),m3h3x36(:,124),heltab2x108(:,:,124))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(131),h0tab(:,131),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(11),m3h3x36(:,125),heltab2x108(:,:,125))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(132),h0tab(:,132),[16,3,8,4],[nMZ,nMH,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(12),m3h3x36(:,126),heltab2x108(:,:,126))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(133),h0tab(:,133),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(13),m3h3x36(:,127),heltab2x108(:,:,127))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(134),h0tab(:,134),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(14),m3h3x36(:,128),heltab2x108(:,:,128))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(135),h0tab(:,135),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(52),m3h3x36(:,129),heltab2x108(:,:,129))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(136),h0tab(:,136),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(53),m3h3x36(:,130),heltab2x108(:,:,130))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(137),h0tab(:,137),[16,3,8,4],[nMH,nMZ,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(54),m3h3x36(:,131),heltab2x108(:,:,131))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(138),h0tab(:,138),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(55),m3h3x36(:,132),heltab2x108(:,:,132))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(139),h0tab(:,139),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(56),m3h3x36(:,133),heltab2x108(:,:,133))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(140),h0tab(:,140),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(15),m3h3x36(:,134),heltab2x108(:,:,134))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(141),h0tab(:,141),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(16),m3h3x36(:,135),heltab2x108(:,:,135))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(142),h0tab(:,142),[16,3,8,4],[nMH,nMZ,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(17),m3h3x36(:,136),heltab2x108(:,:,136))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(143),h0tab(:,143),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(18),m3h3x36(:,137),heltab2x108(:,:,137))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(144),h0tab(:,144),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(19),m3h3x36(:,138),heltab2x108(:,:,138))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(145),h0tab(:,145),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(57),m3h3x36(:,139),heltab2x108(:,:,139))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(146),h0tab(:,146),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(58),m3h3x36(:,140),heltab2x108(:,:,140))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(147),h0tab(:,147),[16,3,8,4],[nMZ,nMH,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(59),m3h3x36(:,141),heltab2x108(:,:,141))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(148),h0tab(:,148),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(60),m3h3x36(:,142),heltab2x108(:,:,142))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(149),h0tab(:,149),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(61),m3h3x36(:,143),heltab2x108(:,:,143))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(150),h0tab(:,150),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(20),m3h3x36(:,144),heltab2x108(:,:,144))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(151),h0tab(:,151),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(21),m3h3x36(:,145),heltab2x108(:,:,145))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(152),h0tab(:,152),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,146),heltab2x108(:,:,146))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(153),h0tab(:,153),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(2),m3h3x36(:,147),heltab2x108(:,:,147))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(154),h0tab(:,154),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(62),m3h3x36(:,148),heltab2x108(:,:,148))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(155),h0tab(:,155),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(63),m3h3x36(:,149),heltab2x108(:,:,149))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(156),h0tab(:,156),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(64),m3h3x36(:,150),heltab2x108(:,:,150))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(157),h0tab(:,157),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(65),m3h3x36(:,151),heltab2x108(:,:,151))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(158),h0tab(:,158),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(3),m3h3x36(:,152),heltab2x108(:,:,152))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(159),h0tab(:,159),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(4),m3h3x36(:,153),heltab2x108(:,:,153))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(160),h0tab(:,160),[16,3,8,4],[nMH,nMZ,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(5),m3h3x36(:,154),heltab2x108(:,:,154))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(161),h0tab(:,161),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(6),m3h3x36(:,155),heltab2x108(:,:,155))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(162),h0tab(:,162),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(7),m3h3x36(:,156),heltab2x108(:,:,156))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(163),h0tab(:,163),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(8),m3h3x36(:,157),heltab2x108(:,:,157))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(164),h0tab(:,164),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(9),m3h3x36(:,158),heltab2x108(:,:,158))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(165),h0tab(:,165),[16,3,8,4],[nMZ,nMH,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(22),m3h3x36(:,159),heltab2x108(:,:,159))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(166),h0tab(:,166),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(23),m3h3x36(:,160),heltab2x108(:,:,160))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(167),h0tab(:,167),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(24),m3h3x36(:,161),heltab2x108(:,:,161))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(168),h0tab(:,168),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(66),m3h3x36(:,162),heltab2x108(:,:,162))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(169),h0tab(:,169),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(67),m3h3x36(:,163),heltab2x108(:,:,163))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(170),h0tab(:,170),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(68),m3h3x36(:,164),heltab2x108(:,:,164))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(171),h0tab(:,171),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(69),m3h3x36(:,165),heltab2x108(:,:,165))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(172),h0tab(:,172),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(25),m3h3x36(:,166),heltab2x108(:,:,166))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(173),h0tab(:,173),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(26),m3h3x36(:,167),heltab2x108(:,:,167))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(174),h0tab(:,174),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(27),m3h3x36(:,168),heltab2x108(:,:,168))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(175),h0tab(:,175),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(28),m3h3x36(:,169),heltab2x108(:,:,169))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(176),h0tab(:,176),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(70),m3h3x36(:,170),heltab2x108(:,:,170))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(177),h0tab(:,177),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(71),m3h3x36(:,171),heltab2x108(:,:,171))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(178),h0tab(:,178),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(72),m3h3x36(:,172),heltab2x108(:,:,172))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(179),h0tab(:,179),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(73),m3h3x36(:,173),heltab2x108(:,:,173))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(180),h0tab(:,180),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(29),m3h3x36(:,174),heltab2x108(:,:,174))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(181),h0tab(:,181),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(30),m3h3x36(:,175),heltab2x108(:,:,175))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(182),h0tab(:,182),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(31),m3h3x36(:,176),heltab2x108(:,:,176))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(183),h0tab(:,183),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(32),m3h3x36(:,177),heltab2x108(:,:,177))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(184),h0tab(:,184),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(74),m3h3x36(:,178),heltab2x108(:,:,178))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(185),h0tab(:,185),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(75),m3h3x36(:,179),heltab2x108(:,:,179))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(186),h0tab(:,186),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(76),m3h3x36(:,180),heltab2x108(:,:,180))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(187),h0tab(:,187),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(77),m3h3x36(:,181),heltab2x108(:,:,181))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(188),h0tab(:,188),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(33),m3h3x36(:,182),heltab2x108(:,:,182))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(189),h0tab(:,189),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(34),m3h3x36(:,183),heltab2x108(:,:,183))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(190),h0tab(:,190),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(35),m3h3x36(:,184),heltab2x108(:,:,184))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(191),h0tab(:,191),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(36),m3h3x36(:,185),heltab2x108(:,:,185))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(192),h0tab(:,192),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,186),heltab2x108(:,:,186))
  call Hloop_A_Q(ntryL,G0H36(37),16,nME,G1H36(78),n2h36(66))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(193),h0tab(:,193),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,187),heltab2x108(:,:,187))
  call Hloop_A_Q(ntryL,G0H36(37),16,nMM,G1H36(79),n2h36(67))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(194),h0tab(:,194),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,188),heltab2x108(:,:,188))
  call Hloop_A_Q(ntryL,G0H36(37),16,nML,G1H36(80),n2h36(68))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(195),h0tab(:,195),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,189),heltab2x108(:,:,189))
  call Hloop_Q_A(ntryL,G0H36(37),16,nME,G1H36(81),n2h36(69))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(196),h0tab(:,196),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,190),heltab2x108(:,:,190))
  call Hloop_Q_A(ntryL,G0H36(37),16,nMM,G1H36(82),n2h36(70))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(197),h0tab(:,197),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,191),heltab2x108(:,:,191))
  call Hloop_Q_A(ntryL,G0H36(37),16,nML,G1H36(83),n2h36(71))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(198),h0tab(:,198),[16,3,4,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZu,m3h3x36(:,192),heltab2x108(:,:,192))
  call Hloop_A_Q(ntryL,G0H36(37),16,0,G1H36(84),n2h36(72))
  Gcoeff(:)%j = (c(101)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(199),h0tab(:,199),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZu,m3h3x36(:,193),heltab2x108(:,:,193))
  call Hloop_A_Q(ntryL,G0H36(37),16,nMT,G1H36(85),n2h36(73))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(200),h0tab(:,200),[16,3,4,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZu,m3h3x36(:,194),heltab2x108(:,:,194))
  call Hloop_Q_A(ntryL,G0H36(37),16,0,G1H36(86),n2h36(74))
  Gcoeff(:)%j = (c(101)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(201),h0tab(:,201),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZu,m3h3x36(:,195),heltab2x108(:,:,195))
  call Hloop_Q_A(ntryL,G0H36(37),16,nMT,G1H36(87),n2h36(75))
  Gcoeff(:)%j = (-(c(101)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(202),h0tab(:,202),[16,3,4,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZd,m3h3x36(:,196),heltab2x108(:,:,196))
  call Hloop_A_Q(ntryL,G0H36(37),16,0,G1H36(88),n2h36(76))
  Gcoeff(:)%j = (-(c(100)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(203),h0tab(:,203),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZd,m3h3x36(:,197),heltab2x108(:,:,197))
  call Hloop_A_Q(ntryL,G0H36(37),16,nMB,G1H36(89),n2h36(77))
  Gcoeff(:)%j = (-(c(101)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(204),h0tab(:,204),[16,3,4,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZd,m3h3x36(:,198),heltab2x108(:,:,198))
  call Hloop_Q_A(ntryL,G0H36(37),16,0,G1H36(90),n2h36(78))
  Gcoeff(:)%j = (-(c(100)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(205),h0tab(:,205),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZd,m3h3x36(:,199),heltab2x108(:,:,199))
  call Hloop_Q_A(ntryL,G0H36(37),16,nMB,G1H36(91),n2h36(79))
  Gcoeff(:)%j = (c(107)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(206),h0tab(:,206),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZn,m3h3x36(:,200),heltab2x108(:,:,200))
  call Hloop_A_Q(ntryL,G0H36(37),16,0,G1H36(92),n2h36(80))
  Gcoeff(:)%j = (c(107)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(207),h0tab(:,207),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZn,m3h3x36(:,201),heltab2x108(:,:,201))
  call Hloop_Q_A(ntryL,G0H36(37),16,0,G1H36(93),n2h36(81))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(208),h0tab(:,208),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,202),heltab2x108(:,:,202))
  call Hloop_A_Q(ntryL,G0H36(37),16,nME,G1H36(94),n2h36(82))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(209),h0tab(:,209),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,203),heltab2x108(:,:,203))
  call Hloop_A_Q(ntryL,G0H36(37),16,nMM,G1H36(95),n2h36(83))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(210),h0tab(:,210),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,204),heltab2x108(:,:,204))
  call Hloop_A_Q(ntryL,G0H36(37),16,nML,G1H36(96),n2h36(84))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(211),h0tab(:,211),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,205),heltab2x108(:,:,205))
  call Hloop_Q_A(ntryL,G0H36(37),16,nME,G1H36(97),n2h36(85))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(212),h0tab(:,212),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,206),heltab2x108(:,:,206))
  call Hloop_Q_A(ntryL,G0H36(37),16,nMM,G1H36(98),n2h36(86))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(213),h0tab(:,213),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZl,m3h3x36(:,207),heltab2x108(:,:,207))
  call Hloop_Q_A(ntryL,G0H36(37),16,nML,G1H36(99),n2h36(87))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(214),h0tab(:,214),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZu,m3h3x36(:,208),heltab2x108(:,:,208))
  call Hloop_A_Q(ntryL,G0H36(37),16,0,G1H36(100),n2h36(88))
  Gcoeff(:)%j = (c(105)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(215),h0tab(:,215),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZu,m3h3x36(:,209),heltab2x108(:,:,209))
  call Hloop_A_Q(ntryL,G0H36(37),16,nMT,G1H36(101),n2h36(89))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(216),h0tab(:,216),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZu,m3h3x36(:,210),heltab2x108(:,:,210))
  call Hloop_Q_A(ntryL,G0H36(37),16,0,G1H36(102),n2h36(90))
  Gcoeff(:)%j = (c(105)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(217),h0tab(:,217),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZu,m3h3x36(:,211),heltab2x108(:,:,211))
  call Hloop_Q_A(ntryL,G0H36(37),16,nMT,G1H36(103),n2h36(91))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(218),h0tab(:,218),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZd,m3h3x36(:,212),heltab2x108(:,:,212))
  call Hloop_A_Q(ntryL,G0H36(37),16,0,G1H36(104),n2h36(92))
  Gcoeff(:)%j = (c(105)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(219),h0tab(:,219),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(37),ngZd,m3h3x36(:,213),heltab2x108(:,:,213))
  call Hloop_A_Q(ntryL,G0H36(37),16,nMB,G1H36(105),n2h36(93))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(220),h0tab(:,220),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZd,m3h3x36(:,214),heltab2x108(:,:,214))
  call Hloop_Q_A(ntryL,G0H36(37),16,0,G1H36(106),n2h36(94))
  Gcoeff(:)%j = (c(105)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(221),h0tab(:,221),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(37),ngZd,m3h3x36(:,215),heltab2x108(:,:,215))
  call Hloop_Q_A(ntryL,G0H36(37),16,nMB,G1H36(107),n2h36(95))
  Gcoeff(:)%j = (c(85)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(222),h0tab(:,222),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(108),m3h3x36(:,216),heltab2x108(:,:,216))
  Gcoeff(:)%j = (c(85)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(223),h0tab(:,223),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(109),m3h3x36(:,217),heltab2x108(:,:,217))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(224),h0tab(:,224),[16,3,4,8],[nMH,nMZ,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(110),m3h3x36(:,218),heltab2x108(:,:,218))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(225),h0tab(:,225),[16,3,4,8],[nMZ,nMH,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(111),m3h3x36(:,219),heltab2x108(:,:,219))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(226),h0tab(:,226),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(112),m3h3x36(:,220),heltab2x108(:,:,220))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(227),h0tab(:,227),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(113),m3h3x36(:,221),heltab2x108(:,:,221))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(228),h0tab(:,228),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H108(1),0,ex5(:),G1H36(114),m3h3x36(:,222),heltab2x108(:,:,222))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(229),h0tab(:,229),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H108(1),0,ex5(:),16,G1H36(115),m3h3x36(:,223),heltab2x108(:,:,223))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(230),h0tab(:,230),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H108(1),0,ex5(:),G1H36(116),m3h3x36(:,224),heltab2x108(:,:,224))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(231),h0tab(:,231),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H108(1),0,ex5(:),16,G1H36(117),m3h3x36(:,225),heltab2x108(:,:,225))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(232),h0tab(:,232),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H108(1),0,ex5(:),G1H36(118),m3h3x36(:,226),heltab2x108(:,:,226))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(233),h0tab(:,233),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H108(1),0,ex5(:),16,G1H36(119),m3h3x36(:,227),heltab2x108(:,:,227))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(234),h0tab(:,234),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H108(1),0,ex5(:),G1H36(120),m3h3x36(:,228),heltab2x108(:,:,228))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(235),h0tab(:,235),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H108(1),0,ex5(:),16,G1H36(121),m3h3x36(:,229),heltab2x108(:,:,229))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(236),h0tab(:,236),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(122),m3h3x36(:,230),heltab2x108(:,:,230))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(237),h0tab(:,237),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(123),m3h3x36(:,231),heltab2x108(:,:,231))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(238),h0tab(:,238),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(124),m3h3x36(:,232),heltab2x108(:,:,232))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(239),h0tab(:,239),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(125),m3h3x36(:,233),heltab2x108(:,:,233))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(240),h0tab(:,240),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(37),m3h3x36(:,234),heltab2x108(:,:,234))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(241),h0tab(:,241),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(38),m3h3x36(:,235),heltab2x108(:,:,235))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(242),h0tab(:,242),[16,3,4,8],[nMZ,nMH,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(39),m3h3x36(:,236),heltab2x108(:,:,236))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(243),h0tab(:,243),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(40),m3h3x36(:,237),heltab2x108(:,:,237))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(244),h0tab(:,244),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(41),m3h3x36(:,238),heltab2x108(:,:,238))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(245),h0tab(:,245),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(42),m3h3x36(:,239),heltab2x108(:,:,239))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(246),h0tab(:,246),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(43),m3h3x36(:,240),heltab2x108(:,:,240))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(247),h0tab(:,247),[16,3,4,8],[nMH,nMZ,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(44),m3h3x36(:,241),heltab2x108(:,:,241))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(248),h0tab(:,248),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(45),m3h3x36(:,242),heltab2x108(:,:,242))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(249),h0tab(:,249),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(46),m3h3x36(:,243),heltab2x108(:,:,243))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(250),h0tab(:,250),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(126),m3h3x36(:,244),heltab2x108(:,:,244))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(251),h0tab(:,251),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(127),m3h3x36(:,245),heltab2x108(:,:,245))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(252),h0tab(:,252),[16,3,4,8],[nMH,nMZ,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(128),m3h3x36(:,246),heltab2x108(:,:,246))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(253),h0tab(:,253),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(129),m3h3x36(:,247),heltab2x108(:,:,247))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(254),h0tab(:,254),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(130),m3h3x36(:,248),heltab2x108(:,:,248))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(255),h0tab(:,255),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(131),m3h3x36(:,249),heltab2x108(:,:,249))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(256),h0tab(:,256),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(132),m3h3x36(:,250),heltab2x108(:,:,250))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(257),h0tab(:,257),[16,3,4,8],[nMZ,nMH,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(133),m3h3x36(:,251),heltab2x108(:,:,251))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(258),h0tab(:,258),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(134),m3h3x36(:,252),heltab2x108(:,:,252))
  Gcoeff(:)%j = (c(98)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(259),h0tab(:,259),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(135),m3h3x36(:,253),heltab2x108(:,:,253))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(260),h0tab(:,260),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(136),m3h3x36(:,254),heltab2x108(:,:,254))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(261),h0tab(:,261),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(137),m3h3x36(:,255),heltab2x108(:,:,255))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(262),h0tab(:,262),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(138),m3h3x36(:,256),heltab2x108(:,:,256))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(263),h0tab(:,263),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(139),m3h3x36(:,257),heltab2x108(:,:,257))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(264),h0tab(:,264),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(47),m3h3x36(:,258),heltab2x108(:,:,258))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(265),h0tab(:,265),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(48),m3h3x36(:,259),heltab2x108(:,:,259))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(266),h0tab(:,266),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(49),m3h3x36(:,260),heltab2x108(:,:,260))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(267),h0tab(:,267),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(50),m3h3x36(:,261),heltab2x108(:,:,261))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(268),h0tab(:,268),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(51),m3h3x36(:,262),heltab2x108(:,:,262))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(269),h0tab(:,269),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(52),m3h3x36(:,263),heltab2x108(:,:,263))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(270),h0tab(:,270),[16,3,4,8],[nMH,nMZ,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(53),m3h3x36(:,264),heltab2x108(:,:,264))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(271),h0tab(:,271),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(54),m3h3x36(:,265),heltab2x108(:,:,265))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(272),h0tab(:,272),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(55),m3h3x36(:,266),heltab2x108(:,:,266))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(273),h0tab(:,273),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(56),m3h3x36(:,267),heltab2x108(:,:,267))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(274),h0tab(:,274),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(57),m3h3x36(:,268),heltab2x108(:,:,268))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(275),h0tab(:,275),[16,3,4,8],[nMZ,nMH,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(58),m3h3x36(:,269),heltab2x108(:,:,269))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(276),h0tab(:,276),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(59),m3h3x36(:,270),heltab2x108(:,:,270))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(277),h0tab(:,277),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(60),m3h3x36(:,271),heltab2x108(:,:,271))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(278),h0tab(:,278),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(61),m3h3x36(:,272),heltab2x108(:,:,272))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(279),h0tab(:,279),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(62),m3h3x36(:,273),heltab2x108(:,:,273))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(280),h0tab(:,280),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(63),m3h3x36(:,274),heltab2x108(:,:,274))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(281),h0tab(:,281),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(64),m3h3x36(:,275),heltab2x108(:,:,275))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(282),h0tab(:,282),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(140),m3h3x36(:,276),heltab2x108(:,:,276))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(283),h0tab(:,283),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(141),m3h3x36(:,277),heltab2x108(:,:,277))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(284),h0tab(:,284),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H108(1),0,ex5(:),16,G1H36(142),m3h3x36(:,278),heltab2x108(:,:,278))
  Gcoeff(:)%j = (-(c(84)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(285),h0tab(:,285),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H108(1),0,ex5(:),16,G1H36(143),m3h3x36(:,279),heltab2x108(:,:,279))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(286),h0tab(:,286),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(144),m3h3x36(:,280),heltab2x108(:,:,280))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(287),h0tab(:,287),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(145),m3h3x36(:,281),heltab2x108(:,:,281))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(288),h0tab(:,288),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(146),m3h3x36(:,282),heltab2x108(:,:,282))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(289),h0tab(:,289),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(147),m3h3x36(:,283),heltab2x108(:,:,283))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(290),h0tab(:,290),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(148),m3h3x36(:,284),heltab2x108(:,:,284))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(291),h0tab(:,291),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(149),m3h3x36(:,285),heltab2x108(:,:,285))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(292),h0tab(:,292),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H108(1),0,ex5(:),16,G1H36(150),m3h3x36(:,286),heltab2x108(:,:,286))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(293),h0tab(:,293),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H108(1),0,ex5(:),16,G1H36(151),m3h3x36(:,287),heltab2x108(:,:,287))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(294),h0tab(:,294),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(65),m3h3x36(:,288),heltab2x108(:,:,288))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(295),h0tab(:,295),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(66),m3h3x36(:,289),heltab2x108(:,:,289))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(296),h0tab(:,296),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(67),m3h3x36(:,290),heltab2x108(:,:,290))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(297),h0tab(:,297),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H108(1),ex5(:),G0H36(68),m3h3x36(:,291),heltab2x108(:,:,291))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(298),h0tab(:,298),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(69),m3h3x36(:,292),heltab2x108(:,:,292))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(299),h0tab(:,299),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(70),m3h3x36(:,293),heltab2x108(:,:,293))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(300),h0tab(:,300),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(71),m3h3x36(:,294),heltab2x108(:,:,294))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(301),h0tab(:,301),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H108(1),ex5(:),G0H36(72),m3h3x36(:,295),heltab2x108(:,:,295))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(302),h0tab(:,302),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(73),ngZl,m3h3x36(:,296),heltab2x108(:,:,296))
  call Hloop_Q_A(ntryL,G0H36(73),16,nME,G1H36(152),n2h36(96))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(303),h0tab(:,303),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(73),ngZl,m3h3x36(:,297),heltab2x108(:,:,297))
  call Hloop_Q_A(ntryL,G0H36(73),16,nMM,G1H36(153),n2h36(97))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(304),h0tab(:,304),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(73),ngZl,m3h3x36(:,298),heltab2x108(:,:,298))
  call Hloop_Q_A(ntryL,G0H36(73),16,nML,G1H36(154),n2h36(98))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(305),h0tab(:,305),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(73),ngZl,m3h3x36(:,299),heltab2x108(:,:,299))
  call Hloop_A_Q(ntryL,G0H36(73),16,nME,G1H36(155),n2h36(99))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(306),h0tab(:,306),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(73),ngZl,m3h3x36(:,300),heltab2x108(:,:,300))
  call Hloop_A_Q(ntryL,G0H36(73),16,nMM,G1H36(156),n2h36(100))
  Gcoeff(:)%j = (-(c(102)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(307),h0tab(:,307),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(73),ngZl,m3h3x36(:,301),heltab2x108(:,:,301))
  call Hloop_A_Q(ntryL,G0H36(73),16,nML,G1H36(157),n2h36(101))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(308),h0tab(:,308),[16,4,3,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(73),ngZu,m3h3x36(:,302),heltab2x108(:,:,302))
  call Hloop_Q_A(ntryL,G0H36(73),16,0,G1H36(158),n2h36(102))
  Gcoeff(:)%j = (c(101)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(309),h0tab(:,309),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(73),ngZu,m3h3x36(:,303),heltab2x108(:,:,303))
  call Hloop_Q_A(ntryL,G0H36(73),16,nMT,G1H36(159),n2h36(103))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(310),h0tab(:,310),[16,4,3,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(73),ngZu,m3h3x36(:,304),heltab2x108(:,:,304))
  call Hloop_A_Q(ntryL,G0H36(73),16,0,G1H36(160),n2h36(104))
  Gcoeff(:)%j = (c(101)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(311),h0tab(:,311),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H108(1),ex5(:),G0H36(73),ngZu,m3h3x36(:,305),heltab2x108(:,:,305))
  call Hloop_A_Q(ntryL,G0H36(73),16,nMT,G1H36(161),n2h36(105))
  Gcoeff(:)%j = (-(c(101)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(312),h0tab(:,312),[16,4,3,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H108(1),ex5(:),G0H36(73),ngZd,m3h3x36(:,306),heltab2x108(:,:,306))
  call Hloop_Q_A(ntryL,G0H36(73),16,0,G1H36(162),n2h36(106))



end subroutine vamp_1

end module ol_vamp_1_ppvvv_ew_uuxzzz_1_/**/REALKIND
