
module ol_vamp_1_ppvvv_ew_uuxawwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv_ew_uuxawwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv_ew_uuxawwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvv_ew_uuxawwx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvv_ew_uuxawwx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvv_ew_uuxawwx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvv_ew_uuxawwx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,nMW,0,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,1),heltab2x72(:,:,1))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(1),n2h24(1))
  Gcoeff(:)%j = (c(61)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,2),heltab2x72(:,:,2))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(2),n2h24(2))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(3),h0tab(:,3),[16,2,1,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,3),heltab2x72(:,:,3))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(3),n2h24(3))
  Gcoeff(:)%j = (c(72)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(4),h0tab(:,4),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,4),heltab2x72(:,:,4))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(4),n2h24(4))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(5),h0tab(:,5),[16,2,1,4,8],[nMW,0,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,5),heltab2x72(:,:,5))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[nMW,0,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(5),m3h3x24(:,6),heltab2x72(:,:,6))
  Gcoeff(:)%j = (c(83)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[nMW,0,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(6),m3h3x24(:,7),heltab2x72(:,:,7))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[nMW,0,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(2),m3h3x24(:,8),heltab2x72(:,:,8))
  Gcoeff(:)%j = (c(66)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[nMW,0,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(7),m3h3x24(:,9),heltab2x72(:,:,9))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[nMW,0,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(8),m3h3x24(:,10),heltab2x72(:,:,10))
  Gcoeff(:)%j = (c(61)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(11),h0tab(:,11),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(3),m3h3x24(:,11),heltab2x72(:,:,11))
  call Hloop_Q_A(ntryL,G0H24(3),16,0,G1H24(9),n2h24(5))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(12),h0tab(:,12),[16,4,2,1,8],[0,0,nMZ,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(3),m3h3x24(:,12),heltab2x72(:,:,12))
  call Hloop_Q_A(ntryL,G0H24(3),16,0,G1H24(10),n2h24(6))
  Gcoeff(:)%j = (c(72)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(13),h0tab(:,13),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(3),m3h3x24(:,13),heltab2x72(:,:,13))
  call Hloop_Q_A(ntryL,G0H24(3),16,0,G1H24(11),n2h24(7))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(14),h0tab(:,14),[16,4,2,1,8],[nMW,nMW,0,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(12),m3h3x24(:,14),heltab2x72(:,:,14))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(15),h0tab(:,15),[16,4,2,1,8],[nMW,nMW,0,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(3),m3h3x24(:,15),heltab2x72(:,:,15))
  Gcoeff(:)%j = (c(83)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMW,nMW,0,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(4),m3h3x24(:,16),heltab2x72(:,:,16))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMW,nMW,0,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(5),m3h3x24(:,17),heltab2x72(:,:,17))
  Gcoeff(:)%j = (c(66)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMW,nMW,0,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(13),m3h3x24(:,18),heltab2x72(:,:,18))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(19),h0tab(:,19),[16,4,2,1,8],[nMW,nMW,0,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(14),m3h3x24(:,19),heltab2x72(:,:,19))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(20),h0tab(:,20),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(6),m3h3x24(:,20),heltab2x72(:,:,20))
  call Hloop_Q_A(ntryL,G0H24(6),16,0,G1H24(15),n2h24(8))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(21),h0tab(:,21),[16,2,1,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(6),m3h3x24(:,21),heltab2x72(:,:,21))
  call Hloop_Q_A(ntryL,G0H24(6),16,0,G1H24(16),n2h24(9))
  Gcoeff(:)%j = (-(c(71)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(22),h0tab(:,22),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(6),m3h3x24(:,22),heltab2x72(:,:,22))
  call Hloop_Q_A(ntryL,G0H24(6),16,0,G1H24(17),n2h24(10))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(23),h0tab(:,23),[16,2,1,8,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(6),m3h3x24(:,23),heltab2x72(:,:,23))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(24),h0tab(:,24),[16,2,1,8,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(7),m3h3x24(:,24),heltab2x72(:,:,24))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(25),h0tab(:,25),[16,2,1,8,4],[0,0,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(8),m3h3x24(:,25),heltab2x72(:,:,25))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(26),h0tab(:,26),[16,2,1,8,4],[nMZ,0,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(9),m3h3x24(:,26),heltab2x72(:,:,26))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(27),h0tab(:,27),[16,2,1,8,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(18),m3h3x24(:,27),heltab2x72(:,:,27))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(28),h0tab(:,28),[16,2,1,8,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(19),m3h3x24(:,28),heltab2x72(:,:,28))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(29),h0tab(:,29),[16,2,1,8,4],[0,0,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(20),m3h3x24(:,29),heltab2x72(:,:,29))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(30),h0tab(:,30),[16,2,1,8,4],[nMZ,0,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(21),m3h3x24(:,30),heltab2x72(:,:,30))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(31),h0tab(:,31),[16,2,1,8,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(10),m3h3x24(:,31),heltab2x72(:,:,31))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(32),h0tab(:,32),[16,2,1,8,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(11),m3h3x24(:,32),heltab2x72(:,:,32))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(33),h0tab(:,33),[16,2,1,8,4],[0,0,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(12),m3h3x24(:,33),heltab2x72(:,:,33))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(34),h0tab(:,34),[16,2,1,8,4],[nMZ,0,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,34),heltab2x72(:,:,34))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(35),h0tab(:,35),[16,2,1,8,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(22),m3h3x24(:,35),heltab2x72(:,:,35))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(36),h0tab(:,36),[16,2,1,8,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(23),m3h3x24(:,36),heltab2x72(:,:,36))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(37),h0tab(:,37),[16,2,1,8,4],[0,0,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(24),m3h3x24(:,37),heltab2x72(:,:,37))
  Gcoeff(:)%j = (c(70)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(38),h0tab(:,38),[16,2,1,8,4],[nMZ,0,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(25),m3h3x24(:,38),heltab2x72(:,:,38))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(39),h0tab(:,39),[16,1,2,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(14),m3h3x24(:,39),heltab2x72(:,:,39))
  call Hloop_A_Q(ntryL,G0H24(14),16,0,G1H24(26),n2h24(11))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(40),h0tab(:,40),[16,1,2,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(14),m3h3x24(:,40),heltab2x72(:,:,40))
  call Hloop_A_Q(ntryL,G0H24(14),16,0,G1H24(27),n2h24(12))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(41),h0tab(:,41),[16,1,2,8,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(14),m3h3x24(:,41),heltab2x72(:,:,41))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(42),h0tab(:,42),[16,1,2,8,4],[0,0,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(15),m3h3x24(:,42),heltab2x72(:,:,42))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(43),h0tab(:,43),[16,1,2,8,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(16),m3h3x24(:,43),heltab2x72(:,:,43))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(44),h0tab(:,44),[16,1,2,8,4],[nMZ,0,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(17),m3h3x24(:,44),heltab2x72(:,:,44))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(45),h0tab(:,45),[16,1,2,8,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(28),m3h3x24(:,45),heltab2x72(:,:,45))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(46),h0tab(:,46),[16,1,2,8,4],[0,0,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(29),m3h3x24(:,46),heltab2x72(:,:,46))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(47),h0tab(:,47),[16,1,2,8,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(30),m3h3x24(:,47),heltab2x72(:,:,47))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(48),h0tab(:,48),[16,1,2,8,4],[nMZ,0,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(31),m3h3x24(:,48),heltab2x72(:,:,48))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(49),h0tab(:,49),[16,1,2,8,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(18),m3h3x24(:,49),heltab2x72(:,:,49))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(50),h0tab(:,50),[16,1,2,8,4],[0,0,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(19),m3h3x24(:,50),heltab2x72(:,:,50))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(51),h0tab(:,51),[16,1,2,8,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(20),m3h3x24(:,51),heltab2x72(:,:,51))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(52),h0tab(:,52),[16,1,2,8,4],[nMZ,0,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(21),m3h3x24(:,52),heltab2x72(:,:,52))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(53),h0tab(:,53),[16,1,2,8,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(32),m3h3x24(:,53),heltab2x72(:,:,53))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(54),h0tab(:,54),[16,1,2,8,4],[0,0,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(33),m3h3x24(:,54),heltab2x72(:,:,54))
  Gcoeff(:)%j = (c(95)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(55),h0tab(:,55),[16,1,2,8,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(34),m3h3x24(:,55),heltab2x72(:,:,55))
  Gcoeff(:)%j = (c(70)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(56),h0tab(:,56),[16,1,2,8,4],[nMZ,0,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(35),m3h3x24(:,56),heltab2x72(:,:,56))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(57),h0tab(:,57),[16,2,4,1,8],[0,0,0,0,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(22),m3h3x24(:,57),heltab2x72(:,:,57))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(58),h0tab(:,58),[16,2,4,1,8],[nMZ,0,0,0,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(23),m3h3x24(:,58),heltab2x72(:,:,58))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(59),h0tab(:,59),[16,2,4,1,8],[0,0,0,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(24),m3h3x24(:,59),heltab2x72(:,:,59))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(60),h0tab(:,60),[16,2,4,1,8],[nMZ,0,0,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(25),m3h3x24(:,60),heltab2x72(:,:,60))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(61),h0tab(:,61),[16,2,4,1,8],[nMW,0,0,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(26),m3h3x24(:,61),heltab2x72(:,:,61))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(62),h0tab(:,62),[16,2,4,1,8],[0,0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(36),m3h3x24(:,62),heltab2x72(:,:,62))
  Gcoeff(:)%j = (c(94)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(63),h0tab(:,63),[16,2,4,1,8],[nMZ,0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(37),m3h3x24(:,63),heltab2x72(:,:,63))
  Gcoeff(:)%j = (c(94)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(64),h0tab(:,64),[16,2,4,1,8],[0,0,0,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(38),m3h3x24(:,64),heltab2x72(:,:,64))
  Gcoeff(:)%j = (c(69)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(65),h0tab(:,65),[16,2,4,1,8],[nMZ,0,0,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(39),m3h3x24(:,65),heltab2x72(:,:,65))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(66),h0tab(:,66),[16,2,4,1,8],[nMW,0,0,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(40),m3h3x24(:,66),heltab2x72(:,:,66))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(67),h0tab(:,67),[16,2,4,1,8],[nMW,0,0,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(41),m3h3x24(:,67),heltab2x72(:,:,67))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(68),h0tab(:,68),[16,2,8,1,4],[0,0,nMW,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(27),m3h3x24(:,68),heltab2x72(:,:,68))
  call Hloop_Q_A(ntryL,G0H24(27),16,0,G1H24(42),n2h24(13))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(69),h0tab(:,69),[16,2,8,1,4],[0,nMZ,nMW,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(27),m3h3x24(:,69),heltab2x72(:,:,69))
  call Hloop_Q_A(ntryL,G0H24(27),16,0,G1H24(43),n2h24(14))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(70),h0tab(:,70),[16,1,4,2,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(27),m3h3x24(:,70),heltab2x72(:,:,70))
  call Hloop_A_Q(ntryL,G0H24(27),16,0,G1H24(44),n2h24(15))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(71),h0tab(:,71),[16,1,4,2,8],[0,0,0,0,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(27),m3h3x24(:,71),heltab2x72(:,:,71))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(72),h0tab(:,72),[16,1,4,2,8],[0,0,0,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(28),m3h3x24(:,72),heltab2x72(:,:,72))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(73),h0tab(:,73),[16,1,4,2,8],[nMZ,0,0,0,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(29),m3h3x24(:,73),heltab2x72(:,:,73))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(74),h0tab(:,74),[16,1,4,2,8],[nMZ,0,0,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(30),m3h3x24(:,74),heltab2x72(:,:,74))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(75),h0tab(:,75),[16,1,4,2,8],[0,0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(45),m3h3x24(:,75),heltab2x72(:,:,75))
  Gcoeff(:)%j = (c(94)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(76),h0tab(:,76),[16,1,4,2,8],[0,0,0,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(46),m3h3x24(:,76),heltab2x72(:,:,76))
  Gcoeff(:)%j = (c(94)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(77),h0tab(:,77),[16,1,4,2,8],[nMZ,0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(47),m3h3x24(:,77),heltab2x72(:,:,77))
  Gcoeff(:)%j = (c(69)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(78),h0tab(:,78),[16,1,4,2,8],[nMZ,0,0,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(48),m3h3x24(:,78),heltab2x72(:,:,78))
  Gcoeff(:)%j = (c(63)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(79),h0tab(:,79),[16,1,4,8,2],[0,0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(49),m3h3x24(:,79),heltab2x72(:,:,79))
  Gcoeff(:)%j = (c(36)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(80),h0tab(:,80),[16,1,4,8,2],[nMZ,0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(50),m3h3x24(:,80),heltab2x72(:,:,80))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(81),h0tab(:,81),[16,1,4,8,2],[0,nMW,nMW,0,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(31),m3h3x24(:,81),heltab2x72(:,:,81))
  call Hloop_A_Q(ntryL,G0H24(31),16,0,G1H24(51),n2h24(16))
  Gcoeff(:)%j = (c(106)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(82),h0tab(:,82),[16,1,4,8,2],[0,nMW,nMW,nMZ,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(31),m3h3x24(:,82),heltab2x72(:,:,82))
  call Hloop_A_Q(ntryL,G0H24(31),16,0,G1H24(52),n2h24(17))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(83),h0tab(:,83),[16,1,4,8,2],[0,nMW,nMW,0,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(31),m3h3x24(:,83),heltab2x72(:,:,83))
  call Hloop_A_Q(ntryL,G0H24(31),16,0,G1H24(53),n2h24(18))
  Gcoeff(:)%j = (c(37)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(84),h0tab(:,84),[16,1,4,8,2],[0,nMW,nMW,nMZ,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(31),m3h3x24(:,84),heltab2x72(:,:,84))
  call Hloop_A_Q(ntryL,G0H24(31),16,0,G1H24(54),n2h24(19))
  Gcoeff(:)%j = (c(63)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(85),h0tab(:,85),[16,1,8,2,4],[0,nMW,0,0,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(31),m3h3x24(:,85),heltab2x72(:,:,85))
  call Hloop_A_Q(ntryL,G0H24(31),16,0,G1H24(55),n2h24(20))
  Gcoeff(:)%j = (c(36)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(86),h0tab(:,86),[16,1,8,2,4],[0,nMW,nMZ,0,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(31),m3h3x24(:,86),heltab2x72(:,:,86))
  call Hloop_A_Q(ntryL,G0H24(31),16,0,G1H24(56),n2h24(21))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(87),h0tab(:,87),[16,1,8,2,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(31),m3h3x24(:,87),heltab2x72(:,:,87))
  Gcoeff(:)%j = (c(106)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(88),h0tab(:,88),[16,1,8,2,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(32),m3h3x24(:,88),heltab2x72(:,:,88))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(89),h0tab(:,89),[16,1,8,2,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(57),m3h3x24(:,89),heltab2x72(:,:,89))
  Gcoeff(:)%j = (c(37)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(90),h0tab(:,90),[16,1,8,2,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(58),m3h3x24(:,90),heltab2x72(:,:,90))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(91),h0tab(:,91),[16,1,8,4,2],[0,0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(59),m3h3x24(:,91),heltab2x72(:,:,91))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(92),h0tab(:,92),[16,1,8,4,2],[nMZ,0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(60),m3h3x24(:,92),heltab2x72(:,:,92))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(4),[G1H24(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(11),[G1H24(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(17),[G1H24(15)])
  call Hloop_AV_Q(ntryL,G1H24(1),ex3(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(1),n2h12(1))
  call Hloop_QA_V(ntryL,G1H24(4),ex2(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_QA_Z(ntryL,G1H24(3),ex2(:),G1H12(2),ngZu,m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),ex2(:),G0H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_A_Q(ntryL,G0H12(1),18,0,G1H12(3),n2h12(2))
  call Hloop_WA_Q(ntryL,G1H24(5),ex2(:),G1H12(4),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H12(4),18,0,G2H12(2),n2h12(3))
  call Hloop_WA_Q(ntryL,G1H24(6),ex2(:),G1H12(4),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G1H12(4),18,0,G2H12(3),n2h12(4))
  call Hloop_WA_Q(ntryL,G0H24(2),ex2(:),G0H12(1),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G0H12(1),18,0,G1H12(4),n2h12(5))
  call Hloop_WA_Q(ntryL,G1H24(7),ex2(:),G1H12(5),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_A_Q(ntryL,G1H12(5),18,0,G2H12(4),n2h12(6))
  call Hloop_WA_Q(ntryL,G1H24(8),ex2(:),G1H12(5),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_A_Q(ntryL,G1H12(5),18,0,G2H12(5),n2h12(7))
  call Hloop_QV_A(ntryL,G1H24(11),ex3(:),G1H12(5),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_Q_A(ntryL,G1H12(5),20,0,G2H12(6),n2h12(8))
  call Hloop_QV_A(ntryL,G1H24(10),ex3(:),G1H12(5),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_Q_A(ntryL,G1H12(5),20,0,G2H12(7),n2h12(9))
  call Hloop_SV_V(ntryL,G1H24(12),ex3(:),G1H12(5),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_SV_V(ntryL,G0H24(3),ex3(:),G0H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_SV_V(ntryL,G0H24(4),ex3(:),G0H12(2),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_UW_V(ntryL,G0H24(5),16,ex3(:),4,G1H12(6),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_UW_V(ntryL,G1H24(13),16,ex3(:),4,G2H12(8),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_UW_V(ntryL,G1H24(14),16,ex3(:),4,G2H12(9),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_QA_V(ntryL,G1H24(17),ex2(:),G1H12(7),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_QA_Z(ntryL,G1H24(16),ex2(:),G1H12(8),ngZu,m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_VA_Q(ntryL,G0H24(6),ex2(:),G0H12(3),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(9),n2h12(10))
  call Hloop_ZA_Q(ntryL,G0H24(7),ex2(:),G0H12(3),ngZu,m3h2x12(:,21),heltab2x24(:,:,21))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(10),n2h12(11))
  call Hloop_VA_Q(ntryL,G0H24(8),ex2(:),G0H12(3),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(11),n2h12(12))
  call Hloop_ZA_Q(ntryL,G0H24(9),ex2(:),G0H12(3),ngZu,m3h2x12(:,23),heltab2x24(:,:,23))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(12),n2h12(13))
  call Hloop_VA_Q(ntryL,G1H24(18),ex2(:),G1H12(13),m3h2x12(:,24),heltab2x24(:,:,24))
  call Hloop_A_Q(ntryL,G1H12(13),18,0,G2H12(10),n2h12(14))
  call Hloop_ZA_Q(ntryL,G1H24(19),ex2(:),G1H12(13),ngZu,m3h2x12(:,25),heltab2x24(:,:,25))
  call Hloop_A_Q(ntryL,G1H12(13),18,0,G2H12(11),n2h12(15))
  call Hloop_VA_Q(ntryL,G1H24(20),ex2(:),G1H12(13),m3h2x12(:,26),heltab2x24(:,:,26))
  call Hloop_A_Q(ntryL,G1H12(13),18,0,G2H12(12),n2h12(16))
  call Hloop_ZA_Q(ntryL,G1H24(21),ex2(:),G1H12(13),ngZu,m3h2x12(:,27),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G1H12(13),18,0,G2H12(13),n2h12(17))
  call Hloop_VA_Q(ntryL,G0H24(10),ex2(:),G0H12(3),m3h2x12(:,28),heltab2x24(:,:,28))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(13),n2h12(18))
  call Hloop_ZA_Q(ntryL,G0H24(11),ex2(:),G0H12(3),ngZu,m3h2x12(:,29),heltab2x24(:,:,29))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(14),n2h12(19))
  call Hloop_VA_Q(ntryL,G0H24(12),ex2(:),G0H12(3),m3h2x12(:,30),heltab2x24(:,:,30))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(15),n2h12(20))
  call Hloop_ZA_Q(ntryL,G0H24(13),ex2(:),G0H12(3),ngZu,m3h2x12(:,31),heltab2x24(:,:,31))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(16),n2h12(21))
  call Hloop_VA_Q(ntryL,G1H24(22),ex2(:),G1H12(17),m3h2x12(:,32),heltab2x24(:,:,32))
  call Hloop_A_Q(ntryL,G1H12(17),18,0,G2H12(14),n2h12(22))
  call Hloop_ZA_Q(ntryL,G1H24(23),ex2(:),G1H12(17),ngZu,m3h2x12(:,33),heltab2x24(:,:,33))
  call Hloop_A_Q(ntryL,G1H12(17),18,0,G2H12(15),n2h12(23))
  call Hloop_VA_Q(ntryL,G1H24(24),ex2(:),G1H12(17),m3h2x12(:,34),heltab2x24(:,:,34))
  call Hloop_A_Q(ntryL,G1H12(17),18,0,G2H12(16),n2h12(24))
  call Hloop_ZA_Q(ntryL,G1H24(25),ex2(:),G1H12(17),ngZu,m3h2x12(:,35),heltab2x24(:,:,35))
  call Hloop_A_Q(ntryL,G1H12(17),18,0,G2H12(17),n2h12(25))
  call Hloop_AQ_W(ntryL,G1H24(26),ex1(:),G1H12(17),m3h2x12(:,36),heltab2x24(:,:,36))
  call Hloop_AQ_W(ntryL,G1H24(27),ex1(:),G1H12(18),m3h2x12(:,37),heltab2x24(:,:,37))
  call Hloop_VQ_A(ntryL,G0H24(14),ex1(:),G0H12(3),m3h2x12(:,38),heltab2x24(:,:,38))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(19),n2h12(26))
  call Hloop_VQ_A(ntryL,G0H24(15),ex1(:),G0H12(3),m3h2x12(:,39),heltab2x24(:,:,39))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(20),n2h12(27))
  call Hloop_ZQ_A(ntryL,G0H24(16),ex1(:),G0H12(3),ngZu,m3h2x12(:,40),heltab2x24(:,:,40))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(21),n2h12(28))
  call Hloop_ZQ_A(ntryL,G0H24(17),ex1(:),G0H12(3),ngZu,m3h2x12(:,41),heltab2x24(:,:,41))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(22),n2h12(29))
  call Hloop_VQ_A(ntryL,G1H24(28),ex1(:),G1H12(23),m3h2x12(:,42),heltab2x24(:,:,42))
  call Hloop_Q_A(ntryL,G1H12(23),17,0,G2H12(18),n2h12(30))
  call Hloop_VQ_A(ntryL,G1H24(29),ex1(:),G1H12(23),m3h2x12(:,43),heltab2x24(:,:,43))
  call Hloop_Q_A(ntryL,G1H12(23),17,0,G2H12(19),n2h12(31))
  call Hloop_ZQ_A(ntryL,G1H24(30),ex1(:),G1H12(23),ngZu,m3h2x12(:,44),heltab2x24(:,:,44))
  call Hloop_Q_A(ntryL,G1H12(23),17,0,G2H12(20),n2h12(32))
  call Hloop_ZQ_A(ntryL,G1H24(31),ex1(:),G1H12(23),ngZu,m3h2x12(:,45),heltab2x24(:,:,45))
  call Hloop_Q_A(ntryL,G1H12(23),17,0,G2H12(21),n2h12(33))
  call Hloop_VQ_A(ntryL,G0H24(18),ex1(:),G0H12(3),m3h2x12(:,46),heltab2x24(:,:,46))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(23),n2h12(34))
  call Hloop_VQ_A(ntryL,G0H24(19),ex1(:),G0H12(3),m3h2x12(:,47),heltab2x24(:,:,47))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(24),n2h12(35))
  call Hloop_ZQ_A(ntryL,G0H24(20),ex1(:),G0H12(3),ngZu,m3h2x12(:,48),heltab2x24(:,:,48))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(25),n2h12(36))
  call Hloop_ZQ_A(ntryL,G0H24(21),ex1(:),G0H12(3),ngZu,m3h2x12(:,49),heltab2x24(:,:,49))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(26),n2h12(37))
  call Hloop_VQ_A(ntryL,G1H24(32),ex1(:),G1H12(27),m3h2x12(:,50),heltab2x24(:,:,50))
  call Hloop_Q_A(ntryL,G1H12(27),17,0,G2H12(22),n2h12(38))
  call Hloop_VQ_A(ntryL,G1H24(33),ex1(:),G1H12(27),m3h2x12(:,51),heltab2x24(:,:,51))
  call Hloop_Q_A(ntryL,G1H12(27),17,0,G2H12(23),n2h12(39))
  call Hloop_ZQ_A(ntryL,G1H24(34),ex1(:),G1H12(27),ngZu,m3h2x12(:,52),heltab2x24(:,:,52))
  call Hloop_Q_A(ntryL,G1H12(27),17,0,G2H12(24),n2h12(40))
  call Hloop_ZQ_A(ntryL,G1H24(35),ex1(:),G1H12(27),ngZu,m3h2x12(:,53),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G1H12(27),17,0,G2H12(25),n2h12(41))
  call Hloop_VA_Q(ntryL,G0H24(22),ex2(:),G0H12(3),m3h2x12(:,54),heltab2x24(:,:,54))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(27),n2h12(42))
  call Hloop_ZA_Q(ntryL,G0H24(23),ex2(:),G0H12(3),ngZu,m3h2x12(:,55),heltab2x24(:,:,55))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(28),n2h12(43))
  call Hloop_VA_Q(ntryL,G0H24(24),ex2(:),G0H12(3),m3h2x12(:,56),heltab2x24(:,:,56))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(29),n2h12(44))
  call Hloop_ZA_Q(ntryL,G0H24(25),ex2(:),G0H12(3),ngZu,m3h2x12(:,57),heltab2x24(:,:,57))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(30),n2h12(45))
  call Hloop_WA_Q(ntryL,G0H24(26),ex2(:),G0H12(3),m3h2x12(:,58),heltab2x24(:,:,58))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(31),n2h12(46))
  call Hloop_VA_Q(ntryL,G1H24(36),ex2(:),G1H12(32),m3h2x12(:,59),heltab2x24(:,:,59))
  call Hloop_A_Q(ntryL,G1H12(32),18,0,G2H12(26),n2h12(47))
  call Hloop_ZA_Q(ntryL,G1H24(37),ex2(:),G1H12(32),ngZu,m3h2x12(:,60),heltab2x24(:,:,60))
  call Hloop_A_Q(ntryL,G1H12(32),18,0,G2H12(27),n2h12(48))
  call Hloop_VA_Q(ntryL,G1H24(38),ex2(:),G1H12(32),m3h2x12(:,61),heltab2x24(:,:,61))
  call Hloop_A_Q(ntryL,G1H12(32),18,0,G2H12(28),n2h12(49))
  call Hloop_ZA_Q(ntryL,G1H24(39),ex2(:),G1H12(32),ngZu,m3h2x12(:,62),heltab2x24(:,:,62))
  call Hloop_A_Q(ntryL,G1H12(32),18,0,G2H12(29),n2h12(50))
  call Hloop_WA_Q(ntryL,G1H24(40),ex2(:),G1H12(32),m3h2x12(:,63),heltab2x24(:,:,63))
  call Hloop_A_Q(ntryL,G1H12(32),18,0,G2H12(30),n2h12(51))
  call Hloop_WA_Q(ntryL,G1H24(41),ex2(:),G1H12(32),m3h2x12(:,64),heltab2x24(:,:,64))
  call Hloop_A_Q(ntryL,G1H12(32),18,0,G2H12(31),n2h12(52))
  call Hloop_QA_V(ntryL,G1H24(42),ex2(:),G1H12(32),m3h2x12(:,65),heltab2x24(:,:,65))
  call Hloop_QA_Z(ntryL,G1H24(43),ex2(:),G1H12(33),ngZu,m3h2x12(:,66),heltab2x24(:,:,66))
  call Hloop_AQ_W(ntryL,G1H24(44),ex1(:),G1H12(34),m3h2x12(:,67),heltab2x24(:,:,67))
  call Hloop_VQ_A(ntryL,G0H24(27),ex1(:),G0H12(3),m3h2x12(:,68),heltab2x24(:,:,68))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(35),n2h12(53))
  call Hloop_VQ_A(ntryL,G0H24(28),ex1(:),G0H12(3),m3h2x12(:,69),heltab2x24(:,:,69))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(36),n2h12(54))
  call Hloop_ZQ_A(ntryL,G0H24(29),ex1(:),G0H12(3),ngZu,m3h2x12(:,70),heltab2x24(:,:,70))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(37),n2h12(55))
  call Hloop_ZQ_A(ntryL,G0H24(30),ex1(:),G0H12(3),ngZu,m3h2x12(:,71),heltab2x24(:,:,71))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(38),n2h12(56))
  call Hloop_VQ_A(ntryL,G1H24(45),ex1(:),G1H12(39),m3h2x12(:,72),heltab2x24(:,:,72))
  call Hloop_Q_A(ntryL,G1H12(39),17,0,G2H12(32),n2h12(57))
  call Hloop_VQ_A(ntryL,G1H24(46),ex1(:),G1H12(39),m3h2x12(:,73),heltab2x24(:,:,73))
  call Hloop_Q_A(ntryL,G1H12(39),17,0,G2H12(33),n2h12(58))
  call Hloop_ZQ_A(ntryL,G1H24(47),ex1(:),G1H12(39),ngZu,m3h2x12(:,74),heltab2x24(:,:,74))
  call Hloop_Q_A(ntryL,G1H12(39),17,0,G2H12(34),n2h12(59))
  call Hloop_ZQ_A(ntryL,G1H24(48),ex1(:),G1H12(39),ngZu,m3h2x12(:,75),heltab2x24(:,:,75))
  call Hloop_Q_A(ntryL,G1H12(39),17,0,G2H12(35),n2h12(60))
  call Hloop_VQ_A(ntryL,G1H24(49),ex1(:),G1H12(39),m3h2x12(:,76),heltab2x24(:,:,76))
  call Hloop_Q_A(ntryL,G1H12(39),17,0,G2H12(36),n2h12(61))
  call Hloop_ZQ_A(ntryL,G1H24(50),ex1(:),G1H12(39),ngZu,m3h2x12(:,77),heltab2x24(:,:,77))
  call Hloop_Q_A(ntryL,G1H12(39),17,0,G2H12(37),n2h12(62))
  call Hloop_AQ_W(ntryL,G1H24(51),ex1(:),G1H12(39),m3h2x12(:,78),heltab2x24(:,:,78))
  call Hloop_AQ_W(ntryL,G1H24(52),ex1(:),G1H12(40),m3h2x12(:,79),heltab2x24(:,:,79))
  call Hloop_AQ_W(ntryL,G1H24(53),ex1(:),G1H12(41),m3h2x12(:,80),heltab2x24(:,:,80))
  call Hloop_AQ_W(ntryL,G1H24(54),ex1(:),G1H12(42),m3h2x12(:,81),heltab2x24(:,:,81))
  call Hloop_AQ_W(ntryL,G1H24(55),ex1(:),G1H12(43),m3h2x12(:,82),heltab2x24(:,:,82))
  call Hloop_AQ_W(ntryL,G1H24(56),ex1(:),G1H12(44),m3h2x12(:,83),heltab2x24(:,:,83))
  call Hloop_VQ_A(ntryL,G0H24(31),ex1(:),G0H12(3),m3h2x12(:,84),heltab2x24(:,:,84))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(45),n2h12(63))
  call Hloop_ZQ_A(ntryL,G0H24(32),ex1(:),G0H12(3),ngZu,m3h2x12(:,85),heltab2x24(:,:,85))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(46),n2h12(64))
  call Hloop_VQ_A(ntryL,G1H24(57),ex1(:),G1H12(47),m3h2x12(:,86),heltab2x24(:,:,86))
  call Hloop_Q_A(ntryL,G1H12(47),17,0,G2H12(38),n2h12(65))
  call Hloop_ZQ_A(ntryL,G1H24(58),ex1(:),G1H12(47),ngZu,m3h2x12(:,87),heltab2x24(:,:,87))
  call Hloop_Q_A(ntryL,G1H12(47),17,0,G2H12(39),n2h12(66))
  call Hloop_VQ_A(ntryL,G1H24(59),ex1(:),G1H12(47),m3h2x12(:,88),heltab2x24(:,:,88))
  call Hloop_Q_A(ntryL,G1H12(47),17,0,G2H12(40),n2h12(67))
  call Hloop_ZQ_A(ntryL,G1H24(60),ex1(:),G1H12(47),ngZu,m3h2x12(:,89),heltab2x24(:,:,89))
  call Hloop_Q_A(ntryL,G1H12(47),17,0,G2H12(41),n2h12(68))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(6),[G1H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(9),[G0H12(2)])
  call Hloop_AQ_W(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_VQ_A(ntryL,G1H12(1),ex1(:),G1H6(1),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(2),n2h6(1))
  call Hloop_ZQ_A(ntryL,G1H12(2),ex1(:),G1H6(1),ngZu,m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(3),n2h6(2))
  call Hloop_AQ_W(ntryL,G1H12(3),ex1(:),G1H6(1),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_AQ_W(ntryL,G2H12(2),ex1(:),G2H6(4),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_AQ_W(ntryL,G2H12(3),ex1(:),G2H6(5),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_AQ_W(ntryL,G1H12(4),ex1(:),G1H6(2),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_AQ_W(ntryL,G2H12(4),ex1(:),G2H6(6),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_AQ_W(ntryL,G2H12(5),ex1(:),G2H6(7),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_QA_V(ntryL,G2H12(6),ex2(:),G2H6(8),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_QA_Z(ntryL,G2H12(7),ex2(:),G2H6(9),ngZu,m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_WA_Q(ntryL,G1H12(6),ex2(:),G1H6(3),m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_A_Q(ntryL,G1H6(3),22,0,G2H6(10),n2h6(3))
  call Hotf_5pt_reduction(G2H12(8),RedSet_5(1),mass5set(:,1),  & 
G1H12(47),G1H12(5),G1H12(1),G1H12(2),G1H12(3),G1H12(4),12)
  call HG1shiftOLR(G1H12(5),8,12)
  call Hotf_5pt_reduction(G2H12(9),RedSet_5(1),mass5set(:,2),  & 
G1H12(6),G1H12(48),G1H12(49),G1H12(50),G1H12(51),G1H12(52),12)
  call HG1shiftOLR(G1H12(48),8,12)
  call Hloop_VQ_A(ntryL,G1H12(7),ex1(:),G1H6(3),m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_Q_A(ntryL,G1H6(3),19,0,G2H6(11),n2h6(4))
  call Hloop_ZQ_A(ntryL,G1H12(8),ex1(:),G1H6(3),ngZu,m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_Q_A(ntryL,G1H6(3),19,0,G2H6(12),n2h6(5))
  call Hloop_AQ_V(ntryL,G1H12(9),ex1(:),G1H6(3),m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_AQ_V(ntryL,G1H12(10),ex1(:),G1H6(4),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_AQ_Z(ntryL,G1H12(11),ex1(:),G1H6(5),ngZu,m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H12(12),ex1(:),G1H6(6),ngZu,m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_AQ_V(ntryL,G2H12(10),ex1(:),G2H6(13),m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_AQ_V(ntryL,G2H12(11),ex1(:),G2H6(14),m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_AQ_Z(ntryL,G2H12(12),ex1(:),G2H6(15),ngZu,m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_AQ_Z(ntryL,G2H12(13),ex1(:),G2H6(16),ngZu,m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_AQ_V(ntryL,G1H12(13),ex1(:),G1H6(7),m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_AQ_V(ntryL,G1H12(14),ex1(:),G1H6(8),m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_AQ_Z(ntryL,G1H12(15),ex1(:),G1H6(9),ngZu,m3h2x6(:,25),heltab2x12(:,:,25))
  call Hloop_AQ_Z(ntryL,G1H12(16),ex1(:),G1H6(10),ngZu,m3h2x6(:,26),heltab2x12(:,:,26))
  call Hloop_AQ_V(ntryL,G2H12(14),ex1(:),G2H6(17),m3h2x6(:,27),heltab2x12(:,:,27))
  call Hloop_AQ_V(ntryL,G2H12(15),ex1(:),G2H6(18),m3h2x6(:,28),heltab2x12(:,:,28))
  call Hloop_AQ_Z(ntryL,G2H12(16),ex1(:),G2H6(19),ngZu,m3h2x6(:,29),heltab2x12(:,:,29))
  call Hloop_AQ_Z(ntryL,G2H12(17),ex1(:),G2H6(20),ngZu,m3h2x6(:,30),heltab2x12(:,:,30))
  call Hloop_WA_Q(ntryL,G1H12(17),ex2(:),G1H6(11),m3h2x6(:,31),heltab2x12(:,:,31))
  call Hloop_A_Q(ntryL,G1H6(11),19,0,G2H6(21),n2h6(6))
  call Hloop_WA_Q(ntryL,G1H12(18),ex2(:),G1H6(11),m3h2x6(:,32),heltab2x12(:,:,32))
  call Hloop_A_Q(ntryL,G1H6(11),19,0,G2H6(22),n2h6(7))
  call Hloop_QA_V(ntryL,G1H12(19),ex2(:),G1H6(11),m3h2x6(:,33),heltab2x12(:,:,33))
  call Hloop_QA_Z(ntryL,G1H12(20),ex2(:),G1H6(12),ngZu,m3h2x6(:,34),heltab2x12(:,:,34))
  call Hloop_QA_V(ntryL,G1H12(21),ex2(:),G1H6(13),m3h2x6(:,35),heltab2x12(:,:,35))
  call Hloop_QA_Z(ntryL,G1H12(22),ex2(:),G1H6(14),ngZu,m3h2x6(:,36),heltab2x12(:,:,36))
  call Hloop_QA_V(ntryL,G2H12(18),ex2(:),G2H6(23),m3h2x6(:,37),heltab2x12(:,:,37))
  call Hloop_QA_Z(ntryL,G2H12(19),ex2(:),G2H6(24),ngZu,m3h2x6(:,38),heltab2x12(:,:,38))
  call Hloop_QA_V(ntryL,G2H12(20),ex2(:),G2H6(25),m3h2x6(:,39),heltab2x12(:,:,39))
  call Hloop_QA_Z(ntryL,G2H12(21),ex2(:),G2H6(26),ngZu,m3h2x6(:,40),heltab2x12(:,:,40))
  call Hloop_QA_V(ntryL,G1H12(23),ex2(:),G1H6(15),m3h2x6(:,41),heltab2x12(:,:,41))
  call Hloop_QA_Z(ntryL,G1H12(24),ex2(:),G1H6(16),ngZu,m3h2x6(:,42),heltab2x12(:,:,42))
  call Hloop_QA_V(ntryL,G1H12(25),ex2(:),G1H6(17),m3h2x6(:,43),heltab2x12(:,:,43))
  call Hloop_QA_Z(ntryL,G1H12(26),ex2(:),G1H6(18),ngZu,m3h2x6(:,44),heltab2x12(:,:,44))
  call Hloop_QA_V(ntryL,G2H12(22),ex2(:),G2H6(27),m3h2x6(:,45),heltab2x12(:,:,45))
  call Hloop_QA_Z(ntryL,G2H12(23),ex2(:),G2H6(28),ngZu,m3h2x6(:,46),heltab2x12(:,:,46))
  call Hloop_QA_V(ntryL,G2H12(24),ex2(:),G2H6(29),m3h2x6(:,47),heltab2x12(:,:,47))
  call Hloop_QA_Z(ntryL,G2H12(25),ex2(:),G2H6(30),ngZu,m3h2x6(:,48),heltab2x12(:,:,48))
  call Hloop_AV_Q(ntryL,G1H12(27),ex3(:),G1H6(19),m3h2x6(:,49),heltab2x12(:,:,49))
  call Hloop_A_Q(ntryL,G1H6(19),22,0,G2H6(31),n2h6(8))
  call Hloop_AV_Q(ntryL,G1H12(28),ex3(:),G1H6(19),m3h2x6(:,50),heltab2x12(:,:,50))
  call Hloop_A_Q(ntryL,G1H6(19),22,0,G2H6(32),n2h6(9))
  call Hloop_AV_Q(ntryL,G1H12(29),ex3(:),G1H6(19),m3h2x6(:,51),heltab2x12(:,:,51))
  call Hloop_A_Q(ntryL,G1H6(19),22,0,G2H6(33),n2h6(10))
  call Hloop_AV_Q(ntryL,G1H12(30),ex3(:),G1H6(19),m3h2x6(:,52),heltab2x12(:,:,52))
  call Hloop_A_Q(ntryL,G1H6(19),22,0,G2H6(34),n2h6(11))
  call Hloop_AV_Q(ntryL,G1H12(31),ex3(:),G1H6(19),m3h2x6(:,53),heltab2x12(:,:,53))
  call Hloop_A_Q(ntryL,G1H6(19),22,0,G2H6(35),n2h6(12))
  call Hotf_5pt_reduction(G2H12(26),RedSet_5(2),mass5set(:,3),  & 
G1H12(7),G1H12(8),G1H12(9),G1H12(10),G1H12(11),G1H12(12),12)
  call HG1shiftOLR(G1H12(8),8,12)
  call Hotf_5pt_reduction(G2H12(27),RedSet_5(2),mass5set(:,4),  & 
G1H12(13),G1H12(14),G1H12(15),G1H12(16),G1H12(17),G1H12(18),12)
  call HG1shiftOLR(G1H12(14),8,12)
  call Hotf_5pt_reduction(G2H12(28),RedSet_5(2),mass5set(:,5),  & 
G1H12(19),G1H12(20),G1H12(21),G1H12(22),G1H12(23),G1H12(24),12)
  call HG1shiftOLR(G1H12(20),8,12)
  call Hotf_5pt_reduction(G2H12(29),RedSet_5(2),mass5set(:,6),  & 
G1H12(25),G1H12(26),G1H12(27),G1H12(28),G1H12(29),G1H12(30),12)
  call HG1shiftOLR(G1H12(26),8,12)
  call Hotf_5pt_reduction(G2H12(30),RedSet_5(2),mass5set(:,7),  & 
G1H12(31),G1H12(53),G1H12(54),G1H12(55),G1H12(56),G1H12(57),12)
  call HG1shiftOLR(G1H12(53),8,12)
  call Hotf_5pt_reduction(G2H12(31),RedSet_5(2),mass5set(:,8),  & 
G1H12(58),G1H12(59),G1H12(60),G1H12(61),G1H12(62),G1H12(63),12)
  call HG1shiftOLR(G1H12(59),8,12)
  call Hloop_UW_V(ntryL,G1H12(32),18,ex4(:),8,G2H4(1),m3h3x4(:,1),heltab2x12(:,:,54))
  call Hloop_UW_V(ntryL,G1H12(33),18,ex4(:),8,G2H4(2),m3h3x4(:,2),heltab2x12(:,:,55))
  call Hloop_UW_V(ntryL,G1H12(34),17,ex3(:),4,G2H6(36),m3h2x6(:,54),heltab2x12(:,:,56))
  call Hloop_QV_A(ntryL,G1H12(35),ex3(:),G1H6(19),m3h2x6(:,55),heltab2x12(:,:,57))
  call Hloop_Q_A(ntryL,G1H6(19),21,0,G2H6(37),n2h6(13))
  call Hloop_QV_A(ntryL,G1H12(36),ex3(:),G1H6(19),m3h2x6(:,56),heltab2x12(:,:,58))
  call Hloop_Q_A(ntryL,G1H6(19),21,0,G2H6(38),n2h6(14))
  call Hloop_QV_A(ntryL,G1H12(37),ex3(:),G1H6(19),m3h2x6(:,57),heltab2x12(:,:,59))
  call Hloop_Q_A(ntryL,G1H6(19),21,0,G2H6(39),n2h6(15))
  call Hloop_QV_A(ntryL,G1H12(38),ex3(:),G1H6(19),m3h2x6(:,58),heltab2x12(:,:,60))
  call Hloop_Q_A(ntryL,G1H6(19),21,0,G2H6(40),n2h6(16))
  call Hotf_5pt_reduction(G2H12(32),RedSet_5(3),mass5set(:,3),  & 
G1H12(32),G1H12(33),G1H12(34),G1H12(35),G1H12(36),G1H12(37),12)
  call HG1shiftOLR(G1H12(33),8,12)
  call Hotf_5pt_reduction(G2H12(33),RedSet_5(3),mass5set(:,5),  & 
G1H12(38),G1H12(64),G1H12(65),G1H12(66),G1H12(67),G1H12(68),12)
  call HG1shiftOLR(G1H12(64),8,12)
  call Hotf_5pt_reduction(G2H12(34),RedSet_5(3),mass5set(:,4),  & 
G1H12(69),G1H12(70),G1H12(71),G1H12(72),G1H12(73),G1H12(74),12)
  call HG1shiftOLR(G1H12(70),8,12)
  call Hotf_5pt_reduction(G2H12(35),RedSet_5(3),mass5set(:,6),  & 
G1H12(75),G1H12(76),G1H12(77),G1H12(78),G1H12(79),G1H12(80),12)
  call HG1shiftOLR(G1H12(76),8,12)
  call Hotf_5pt_reduction(G2H12(36),RedSet_5(4),mass5set(:,3),  & 
G1H12(81),G1H12(82),G1H12(83),G1H12(84),G1H12(85),G1H12(86),12)
  call HG1shiftOLR(G1H12(82),2,12)
  call Hotf_5pt_reduction(G2H12(37),RedSet_5(4),mass5set(:,4),  & 
G1H12(87),G1H12(88),G1H12(89),G1H12(90),G1H12(91),G1H12(92),12)
  call HG1shiftOLR(G1H12(88),2,12)
  call Hloop_VV_S(ntryL,G1H12(39),ex3(:),G1H6(19),m3h2x6(:,59),heltab2x12(:,:,61))
  call Hloop_VV_S(ntryL,G1H12(40),ex3(:),G1H6(20),m3h2x6(:,60),heltab2x12(:,:,62))
  call Hloop_UW_V(ntryL,G1H12(41),17,ex3(:),4,G2H6(41),m3h2x6(:,61),heltab2x12(:,:,63))
  call Hloop_UW_V(ntryL,G1H12(42),17,ex3(:),4,G2H6(42),m3h2x6(:,62),heltab2x12(:,:,64))
  call Hloop_UV_W(ntryL,G1H12(43),17,ex4(:),8,G2H4(3),m3h3x4(:,3),heltab2x12(:,:,65))
  call Hloop_UV_W(ntryL,G1H12(44),17,ex4(:),8,G2H4(4),m3h3x4(:,4),heltab2x12(:,:,66))
  call Hloop_QW_A(ntryL,G1H12(45),ex4(:),G1H4(1),m3h3x4(:,5),heltab2x12(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(5),n2h4(1))
  call Hloop_QW_A(ntryL,G1H12(46),ex4(:),G1H4(1),m3h3x4(:,6),heltab2x12(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(6),n2h4(2))
  call Hotf_5pt_reduction(G2H12(38),RedSet_5(5),mass5set(:,9),  & 
G1H12(39),G1H12(40),G1H12(41),G1H12(42),G1H12(43),G1H12(44),12)
  call HG1shiftOLR(G1H12(40),4,12)
  call Hotf_5pt_reduction(G2H12(39),RedSet_5(5),mass5set(:,10),  & 
G1H12(45),G1H12(46),G1H12(93),G1H12(94),G1H12(95),G1H12(96),12)
  call HG1shiftOLR(G1H12(46),4,12)
  call Hotf_5pt_reduction(G2H12(40),RedSet_5(6),mass5set(:,3),  & 
G1H12(97),G1H12(98),G1H12(99),G1H12(100),G1H12(101),G1H12(102),12)
  call HG1shiftOLR(G1H12(98),2,12)
  call Hotf_5pt_reduction(G2H12(41),RedSet_5(6),mass5set(:,4),  & 
G1H12(103),G1H12(104),G1H12(105),G1H12(106),G1H12(107),G1H12(108),12)
  call HG1shiftOLR(G1H12(104),2,12)
  call Hloop_WA_Q(ntryL,G1H12(47),ex2(:),G1H6(21),m3h2x6(:,63),heltab2x12(:,:,69))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(43),n2h6(17))
call HGT_raise_alpha_OLR(G1H12(5),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(5),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(5),-8,ex4(:),8,G2H4(7),m3h3x4(:,7),heltab2x12(:,:,70))
  call Hloop_WA_Q(ntryL,G1H12(2),ex2(:),G1H6(21),m3h2x6(:,64),heltab2x12(:,:,71))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(44),n2h6(18))
  call Hloop_WA_Q(ntryL,G1H12(3),ex2(:),G1H6(21),m3h2x6(:,65),heltab2x12(:,:,72))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(45),n2h6(19))
  call Hloop_WA_Q(ntryL,G1H12(4),ex2(:),G1H6(21),m3h2x6(:,66),heltab2x12(:,:,73))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(46),n2h6(20))
  call Hloop_WA_Q(ntryL,G1H12(6),ex2(:),G1H6(21),m3h2x6(:,67),heltab2x12(:,:,74))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(47),n2h6(21))
call HGT_raise_alpha_OLR(G1H12(48),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(48),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(48),-8,ex4(:),8,G2H4(8),m3h3x4(:,8),heltab2x12(:,:,75))
  call Hloop_WA_Q(ntryL,G1H12(50),ex2(:),G1H6(21),m3h2x6(:,68),heltab2x12(:,:,76))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(48),n2h6(22))
  call Hloop_WA_Q(ntryL,G1H12(51),ex2(:),G1H6(21),m3h2x6(:,69),heltab2x12(:,:,77))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(49),n2h6(23))
  call Hloop_WA_Q(ntryL,G1H12(52),ex2(:),G1H6(21),m3h2x6(:,70),heltab2x12(:,:,78))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(50),n2h6(24))
  call Hloop_AV_Q(ntryL,G1H12(7),ex3(:),G1H6(21),m3h2x6(:,71),heltab2x12(:,:,79))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(51),n2h6(25))
call HGT_raise_alpha_OLR(G1H12(8),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(8),-8,ex4(:),8,G2H4(9),m3h3x4(:,9),heltab2x12(:,:,80))
  call Hloop_AV_Q(ntryL,G1H12(10),ex3(:),G1H6(21),m3h2x6(:,72),heltab2x12(:,:,81))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(52),n2h6(26))
  call Hloop_AV_Q(ntryL,G1H12(11),ex3(:),G1H6(21),m3h2x6(:,73),heltab2x12(:,:,82))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(53),n2h6(27))
  call Hloop_AV_Q(ntryL,G1H12(12),ex3(:),G1H6(21),m3h2x6(:,74),heltab2x12(:,:,83))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(54),n2h6(28))
  call Hloop_AV_Q(ntryL,G1H12(13),ex3(:),G1H6(21),m3h2x6(:,75),heltab2x12(:,:,84))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(55),n2h6(29))
call HGT_raise_alpha_OLR(G1H12(14),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(14),-8,ex4(:),8,G2H4(10),m3h3x4(:,10),heltab2x12(:,:,85))
  call Hloop_AV_Q(ntryL,G1H12(16),ex3(:),G1H6(21),m3h2x6(:,76),heltab2x12(:,:,86))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(56),n2h6(30))
  call Hloop_AV_Q(ntryL,G1H12(17),ex3(:),G1H6(21),m3h2x6(:,77),heltab2x12(:,:,87))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(57),n2h6(31))
  call Hloop_AV_Q(ntryL,G1H12(18),ex3(:),G1H6(21),m3h2x6(:,78),heltab2x12(:,:,88))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(58),n2h6(32))
  call Hloop_AV_Q(ntryL,G1H12(19),ex3(:),G1H6(21),m3h2x6(:,79),heltab2x12(:,:,89))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(59),n2h6(33))
call HGT_raise_alpha_OLR(G1H12(20),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(20),-8,ex4(:),8,G2H4(11),m3h3x4(:,11),heltab2x12(:,:,90))
  call Hloop_AV_Q(ntryL,G1H12(22),ex3(:),G1H6(21),m3h2x6(:,80),heltab2x12(:,:,91))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(60),n2h6(34))
  call Hloop_AV_Q(ntryL,G1H12(23),ex3(:),G1H6(21),m3h2x6(:,81),heltab2x12(:,:,92))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(61),n2h6(35))
  call Hloop_AV_Q(ntryL,G1H12(24),ex3(:),G1H6(21),m3h2x6(:,82),heltab2x12(:,:,93))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(62),n2h6(36))
  call Hloop_AV_Q(ntryL,G1H12(25),ex3(:),G1H6(21),m3h2x6(:,83),heltab2x12(:,:,94))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(63),n2h6(37))
call HGT_raise_alpha_OLR(G1H12(26),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(26),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(26),-8,ex4(:),8,G2H4(12),m3h3x4(:,12),heltab2x12(:,:,95))
  call Hloop_AV_Q(ntryL,G1H12(28),ex3(:),G1H6(21),m3h2x6(:,84),heltab2x12(:,:,96))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(64),n2h6(38))
  call Hloop_AV_Q(ntryL,G1H12(29),ex3(:),G1H6(21),m3h2x6(:,85),heltab2x12(:,:,97))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(65),n2h6(39))
  call Hloop_AV_Q(ntryL,G1H12(30),ex3(:),G1H6(21),m3h2x6(:,86),heltab2x12(:,:,98))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(66),n2h6(40))
  call Hloop_AV_Q(ntryL,G1H12(31),ex3(:),G1H6(21),m3h2x6(:,87),heltab2x12(:,:,99))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(67),n2h6(41))
call HGT_raise_alpha_OLR(G1H12(53),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(53),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(53),-8,ex4(:),8,G2H4(13),m3h3x4(:,13),heltab2x12(:,:,100))
  call Hloop_AV_Q(ntryL,G1H12(55),ex3(:),G1H6(21),m3h2x6(:,88),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(68),n2h6(42))
  call Hloop_AV_Q(ntryL,G1H12(56),ex3(:),G1H6(21),m3h2x6(:,89),heltab2x12(:,:,102))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(69),n2h6(43))
  call Hloop_AV_Q(ntryL,G1H12(57),ex3(:),G1H6(21),m3h2x6(:,90),heltab2x12(:,:,103))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(70),n2h6(44))
  call Hloop_AV_Q(ntryL,G1H12(58),ex3(:),G1H6(21),m3h2x6(:,91),heltab2x12(:,:,104))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(71),n2h6(45))
call HGT_raise_alpha_OLR(G1H12(59),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(59),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(59),-8,ex4(:),8,G2H4(14),m3h3x4(:,14),heltab2x12(:,:,105))
  call Hloop_AV_Q(ntryL,G1H12(61),ex3(:),G1H6(21),m3h2x6(:,92),heltab2x12(:,:,106))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(72),n2h6(46))
  call Hloop_AV_Q(ntryL,G1H12(62),ex3(:),G1H6(21),m3h2x6(:,93),heltab2x12(:,:,107))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(73),n2h6(47))
  call Hloop_AV_Q(ntryL,G1H12(63),ex3(:),G1H6(21),m3h2x6(:,94),heltab2x12(:,:,108))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(74),n2h6(48))
  call Hloop_QV_A(ntryL,G1H12(32),ex3(:),G1H6(21),m3h2x6(:,95),heltab2x12(:,:,109))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(75),n2h6(49))
call HGT_raise_alpha_OLR(G1H12(33),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(33),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(33),-8,ex4(:),8,G2H4(15),m3h3x4(:,15),heltab2x12(:,:,110))
  call Hloop_QV_A(ntryL,G1H12(35),ex3(:),G1H6(21),m3h2x6(:,96),heltab2x12(:,:,111))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(76),n2h6(50))
  call Hloop_QV_A(ntryL,G1H12(36),ex3(:),G1H6(21),m3h2x6(:,97),heltab2x12(:,:,112))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(77),n2h6(51))
  call Hloop_QV_A(ntryL,G1H12(37),ex3(:),G1H6(21),m3h2x6(:,98),heltab2x12(:,:,113))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(78),n2h6(52))
  call Hloop_QV_A(ntryL,G1H12(38),ex3(:),G1H6(21),m3h2x6(:,99),heltab2x12(:,:,114))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(79),n2h6(53))
call HGT_raise_alpha_OLR(G1H12(64),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(64),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(64),-8,ex4(:),8,G2H4(16),m3h3x4(:,16),heltab2x12(:,:,115))
  call Hloop_QV_A(ntryL,G1H12(66),ex3(:),G1H6(21),m3h2x6(:,100),heltab2x12(:,:,116))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(80),n2h6(54))
  call Hloop_QV_A(ntryL,G1H12(67),ex3(:),G1H6(21),m3h2x6(:,101),heltab2x12(:,:,117))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(81),n2h6(55))
  call Hloop_QV_A(ntryL,G1H12(68),ex3(:),G1H6(21),m3h2x6(:,102),heltab2x12(:,:,118))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(82),n2h6(56))
  call Hloop_QV_A(ntryL,G1H12(69),ex3(:),G1H6(21),m3h2x6(:,103),heltab2x12(:,:,119))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(83),n2h6(57))
call HGT_raise_alpha_OLR(G1H12(70),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(70),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(70),-8,ex4(:),8,G2H4(17),m3h3x4(:,17),heltab2x12(:,:,120))
  call Hloop_QV_A(ntryL,G1H12(72),ex3(:),G1H6(21),m3h2x6(:,104),heltab2x12(:,:,121))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(84),n2h6(58))
  call Hloop_QV_A(ntryL,G1H12(73),ex3(:),G1H6(21),m3h2x6(:,105),heltab2x12(:,:,122))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(85),n2h6(59))
  call Hloop_QV_A(ntryL,G1H12(74),ex3(:),G1H6(21),m3h2x6(:,106),heltab2x12(:,:,123))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(86),n2h6(60))
  call Hloop_QV_A(ntryL,G1H12(75),ex3(:),G1H6(21),m3h2x6(:,107),heltab2x12(:,:,124))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(87),n2h6(61))
call HGT_raise_alpha_OLR(G1H12(76),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(76),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(76),-8,ex4(:),8,G2H4(18),m3h3x4(:,18),heltab2x12(:,:,125))
  call Hloop_QV_A(ntryL,G1H12(78),ex3(:),G1H6(21),m3h2x6(:,108),heltab2x12(:,:,126))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(88),n2h6(62))
  call Hloop_QV_A(ntryL,G1H12(79),ex3(:),G1H6(21),m3h2x6(:,109),heltab2x12(:,:,127))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(89),n2h6(63))
  call Hloop_QV_A(ntryL,G1H12(80),ex3(:),G1H6(21),m3h2x6(:,110),heltab2x12(:,:,128))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(90),n2h6(64))
  call Hloop_QV_A(ntryL,G1H12(81),ex3(:),G1H6(21),m3h2x6(:,111),heltab2x12(:,:,129))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(91),n2h6(65))
call HGT_raise_alpha_OLR(G1H12(82),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(82),2,5,12)
  call Hloop_WA_Q(ntryL,G1H12(82),ex2(:),G1H6(21),m3h2x6(:,112),heltab2x12(:,:,130))
  call Hloop_QV_A(ntryL,G1H12(84),ex3(:),G1H6(22),m3h2x6(:,113),heltab2x12(:,:,131))
  call Hloop_Q_A(ntryL,G1H6(22),21,0,G2H6(92),n2h6(66))
  call Hloop_QV_A(ntryL,G1H12(85),ex3(:),G1H6(22),m3h2x6(:,114),heltab2x12(:,:,132))
  call Hloop_Q_A(ntryL,G1H6(22),21,0,G2H6(93),n2h6(67))
  call Hloop_QV_A(ntryL,G1H12(86),ex3(:),G1H6(22),m3h2x6(:,115),heltab2x12(:,:,133))
  call Hloop_Q_A(ntryL,G1H6(22),21,0,G2H6(94),n2h6(68))
  call Hloop_QV_A(ntryL,G1H12(87),ex3(:),G1H6(22),m3h2x6(:,116),heltab2x12(:,:,134))
  call Hloop_Q_A(ntryL,G1H6(22),21,0,G2H6(95),n2h6(69))
call HGT_raise_alpha_OLR(G1H12(88),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(88),2,5,12)
  call Hloop_WA_Q(ntryL,G1H12(88),ex2(:),G1H6(22),m3h2x6(:,117),heltab2x12(:,:,135))
  call Hloop_QV_A(ntryL,G1H12(90),ex3(:),G1H6(23),m3h2x6(:,118),heltab2x12(:,:,136))
  call Hloop_Q_A(ntryL,G1H6(23),21,0,G2H6(96),n2h6(70))
  call Hloop_QV_A(ntryL,G1H12(91),ex3(:),G1H6(23),m3h2x6(:,119),heltab2x12(:,:,137))
  call Hloop_Q_A(ntryL,G1H6(23),21,0,G2H6(97),n2h6(71))
  call Hloop_QV_A(ntryL,G1H12(92),ex3(:),G1H6(23),m3h2x6(:,120),heltab2x12(:,:,138))
  call Hloop_Q_A(ntryL,G1H6(23),21,0,G2H6(98),n2h6(72))
  call Hloop_QW_A(ntryL,G1H12(39),ex4(:),G1H4(1),m3h3x4(:,19),heltab2x12(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(19),n2h4(3))
call HGT_raise_alpha_OLR(G1H12(40),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(40),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(40),-4,ex3(:),4,G2H6(99),m3h2x6(:,121),heltab2x12(:,:,140))
  call Hloop_QW_A(ntryL,G1H12(42),ex4(:),G1H4(1),m3h3x4(:,20),heltab2x12(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(20),n2h4(4))
  call Hloop_QW_A(ntryL,G1H12(43),ex4(:),G1H4(1),m3h3x4(:,21),heltab2x12(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(21),n2h4(5))
  call Hloop_QW_A(ntryL,G1H12(44),ex4(:),G1H4(1),m3h3x4(:,22),heltab2x12(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(22),n2h4(6))
  call Hloop_QW_A(ntryL,G1H12(45),ex4(:),G1H4(1),m3h3x4(:,23),heltab2x12(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(23),n2h4(7))
call HGT_raise_alpha_OLR(G1H12(46),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(46),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(46),-4,ex3(:),4,G2H6(100),m3h2x6(:,122),heltab2x12(:,:,145))
  call Hloop_QW_A(ntryL,G1H12(94),ex4(:),G1H4(1),m3h3x4(:,24),heltab2x12(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(24),n2h4(8))
  call Hloop_QW_A(ntryL,G1H12(95),ex4(:),G1H4(1),m3h3x4(:,25),heltab2x12(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(25),n2h4(9))
  call Hloop_QW_A(ntryL,G1H12(96),ex4(:),G1H4(1),m3h3x4(:,26),heltab2x12(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(26),n2h4(10))
  call Hloop_QW_A(ntryL,G1H12(97),ex4(:),G1H4(1),m3h3x4(:,27),heltab2x12(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(27),n2h4(11))
call HGT_raise_alpha_OLR(G1H12(98),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(98),2,5,12)
  call Hloop_WA_Q(ntryL,G1H12(98),ex2(:),G1H6(23),m3h2x6(:,123),heltab2x12(:,:,150))
  call Hloop_QW_A(ntryL,G1H12(100),ex4(:),G1H4(1),m3h3x4(:,28),heltab2x12(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(28),n2h4(12))
  call Hloop_QW_A(ntryL,G1H12(101),ex4(:),G1H4(1),m3h3x4(:,29),heltab2x12(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(29),n2h4(13))
  call Hloop_QW_A(ntryL,G1H12(102),ex4(:),G1H4(1),m3h3x4(:,30),heltab2x12(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(30),n2h4(14))
  call Hloop_QW_A(ntryL,G1H12(103),ex4(:),G1H4(1),m3h3x4(:,31),heltab2x12(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(31),n2h4(15))
call HGT_raise_alpha_OLR(G1H12(104),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(104),2,5,12)
  call Hloop_WA_Q(ntryL,G1H12(104),ex2(:),G1H6(24),m3h2x6(:,124),heltab2x12(:,:,155))
  call Hloop_QW_A(ntryL,G1H12(106),ex4(:),G1H4(1),m3h3x4(:,32),heltab2x12(:,:,156))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(32),n2h4(16))
  call Hloop_QW_A(ntryL,G1H12(107),ex4(:),G1H4(1),m3h3x4(:,33),heltab2x12(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(33),n2h4(17))
  call Hloop_QW_A(ntryL,G1H12(108),ex4(:),G1H4(1),m3h3x4(:,34),heltab2x12(:,:,158))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(34),n2h4(18))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(7),mass5set(:,11),  & 
G1H6(25),G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
  call HG1shiftOLR(G1H6(26),8,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(8),mass5set(:,12),  & 
G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(32),8,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(8),mass5set(:,13),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),6)
  call HG1shiftOLR(G1H6(38),8,6)
  call Hloop_VV_S(ntryL,G1H6(1),ex3(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_VV_S(ntryL,G2H6(4),ex3(:),G2H3(1),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_VV_S(ntryL,G2H6(5),ex3(:),G2H3(2),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_UW_V(ntryL,G1H6(2),19,ex3(:),4,G2H3(3),m3h2x3(:,4),heltab2x6(:,:,4))
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(8),mass5set(:,14),  & 
G1H6(1),G1H6(2),G1H6(43),G1H6(44),G1H6(45),G1H6(46),6)
  call HG1shiftOLR(G1H6(2),8,6)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(8),mass5set(:,15),  & 
G1H6(47),G1H6(48),G1H6(49),G1H6(50),G1H6(51),G1H6(52),6)
  call HG1shiftOLR(G1H6(48),8,6)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(1),mass5set(:,12),  & 
G1H6(53),G1H6(54),G1H6(55),G1H6(56),G1H6(57),G1H6(58),6)
  call HG1shiftOLR(G1H6(54),8,6)
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(1),mass5set(:,16),  & 
G1H6(59),G1H6(60),G1H6(61),G1H6(62),G1H6(63),G1H6(64),6)
  call HG1shiftOLR(G1H6(60),8,6)
  call Hloop_AQ_W(ntryL,G2H6(10),ex1(:),G2H3(4),m3h2x3(:,5),heltab2x6(:,:,5))
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(9),mass5set(:,12),  & 
G1H6(65),G1H6(66),G1H6(67),G1H6(68),G1H6(69),G1H6(70),6)
  call HG1shiftOLR(G1H6(66),4,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(9),mass5set(:,13),  & 
G1H6(71),G1H6(72),G1H6(73),G1H6(74),G1H6(75),G1H6(76),6)
  call HG1shiftOLR(G1H6(72),4,6)
  call Hloop_VV_S(ntryL,G1H6(3),ex4(:),G1H2(1),m3h3x2(:,1),heltab2x6(:,:,6))
  call Hloop_VV_S(ntryL,G1H6(4),ex4(:),G1H2(2),m3h3x2(:,2),heltab2x6(:,:,7))
  call Hloop_VV_S(ntryL,G1H6(5),ex4(:),G1H2(3),m3h3x2(:,3),heltab2x6(:,:,8))
  call Hloop_VV_S(ntryL,G1H6(6),ex4(:),G1H2(4),m3h3x2(:,4),heltab2x6(:,:,9))
  call Hloop_VV_S(ntryL,G2H6(13),ex4(:),G2H2(1),m3h3x2(:,5),heltab2x6(:,:,10))
  call Hloop_VV_S(ntryL,G2H6(14),ex4(:),G2H2(2),m3h3x2(:,6),heltab2x6(:,:,11))
  call Hloop_VV_S(ntryL,G2H6(15),ex4(:),G2H2(3),m3h3x2(:,7),heltab2x6(:,:,12))
  call Hloop_VV_S(ntryL,G2H6(16),ex4(:),G2H2(4),m3h3x2(:,8),heltab2x6(:,:,13))
  call Hloop_UW_V(ntryL,G1H6(7),19,ex4(:),8,G2H2(5),m3h3x2(:,9),heltab2x6(:,:,14))
  call Hloop_UW_V(ntryL,G1H6(8),19,ex4(:),8,G2H2(6),m3h3x2(:,10),heltab2x6(:,:,15))
  call Hloop_UW_V(ntryL,G1H6(9),19,ex4(:),8,G2H2(7),m3h3x2(:,11),heltab2x6(:,:,16))
  call Hloop_UW_V(ntryL,G1H6(10),19,ex4(:),8,G2H2(8),m3h3x2(:,12),heltab2x6(:,:,17))
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(9),mass5set(:,9),  & 
G1H6(3),G1H6(4),G1H6(5),G1H6(6),G1H6(7),G1H6(8),6)
  call HG1shiftOLR(G1H6(4),4,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(9),mass5set(:,10),  & 
G1H6(9),G1H6(10),G1H6(77),G1H6(78),G1H6(79),G1H6(80),6)
  call HG1shiftOLR(G1H6(10),4,6)
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(9),mass5set(:,17),  & 
G1H6(81),G1H6(82),G1H6(83),G1H6(84),G1H6(85),G1H6(86),6)
  call HG1shiftOLR(G1H6(82),4,6)
  call Hotf_5pt_reduction(G2H6(20),RedSet_5(9),mass5set(:,18),  & 
G1H6(87),G1H6(88),G1H6(89),G1H6(90),G1H6(91),G1H6(92),6)
  call HG1shiftOLR(G1H6(88),4,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(10),mass5set(:,19),  & 
G1H6(93),G1H6(94),G1H6(95),G1H6(96),G1H6(97),G1H6(98),6)
  call HG1shiftOLR(G1H6(94),8,6)
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(11),mass5set(:,19),  & 
G1H6(99),G1H6(100),G1H6(101),G1H6(102),G1H6(103),G1H6(104),6)
  call HG1shiftOLR(G1H6(100),4,6)
  call Hloop_VV_S(ntryL,G1H6(11),ex4(:),G1H2(5),m3h3x2(:,13),heltab2x6(:,:,18))
  call Hloop_VV_S(ntryL,G1H6(12),ex4(:),G1H2(6),m3h3x2(:,14),heltab2x6(:,:,19))
  call Hloop_VV_S(ntryL,G1H6(13),ex4(:),G1H2(7),m3h3x2(:,15),heltab2x6(:,:,20))
  call Hloop_VV_S(ntryL,G1H6(14),ex4(:),G1H2(8),m3h3x2(:,16),heltab2x6(:,:,21))
  call Hloop_VV_S(ntryL,G2H6(23),ex4(:),G2H2(9),m3h3x2(:,17),heltab2x6(:,:,22))
  call Hloop_VV_S(ntryL,G2H6(24),ex4(:),G2H2(10),m3h3x2(:,18),heltab2x6(:,:,23))
  call Hloop_VV_S(ntryL,G2H6(25),ex4(:),G2H2(11),m3h3x2(:,19),heltab2x6(:,:,24))
  call Hloop_VV_S(ntryL,G2H6(26),ex4(:),G2H2(12),m3h3x2(:,20),heltab2x6(:,:,25))
  call Hloop_UW_V(ntryL,G1H6(15),19,ex4(:),8,G2H2(13),m3h3x2(:,21),heltab2x6(:,:,26))
  call Hloop_UW_V(ntryL,G1H6(16),19,ex4(:),8,G2H2(14),m3h3x2(:,22),heltab2x6(:,:,27))
  call Hloop_UW_V(ntryL,G1H6(17),19,ex4(:),8,G2H2(15),m3h3x2(:,23),heltab2x6(:,:,28))
  call Hloop_UW_V(ntryL,G1H6(18),19,ex4(:),8,G2H2(16),m3h3x2(:,24),heltab2x6(:,:,29))
  call Hotf_5pt_reduction(G2H6(27),RedSet_5(11),mass5set(:,9),  & 
G1H6(11),G1H6(12),G1H6(13),G1H6(14),G1H6(15),G1H6(16),6)
  call HG1shiftOLR(G1H6(12),4,6)
  call Hotf_5pt_reduction(G2H6(28),RedSet_5(11),mass5set(:,17),  & 
G1H6(17),G1H6(18),G1H6(105),G1H6(106),G1H6(107),G1H6(108),6)
  call HG1shiftOLR(G1H6(18),4,6)
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(11),mass5set(:,10),  & 
G1H6(109),G1H6(110),G1H6(111),G1H6(112),G1H6(113),G1H6(114),6)
  call HG1shiftOLR(G1H6(110),4,6)
  call Hotf_5pt_reduction(G2H6(30),RedSet_5(11),mass5set(:,18),  & 
G1H6(115),G1H6(116),G1H6(117),G1H6(118),G1H6(119),G1H6(120),6)
  call HG1shiftOLR(G1H6(116),4,6)
  call Hloop_AQ_V(ntryL,G2H6(31),ex1(:),G2H3(5),m3h2x3(:,6),heltab2x6(:,:,30))
  call Hloop_AQ_V(ntryL,G2H6(32),ex1(:),G2H3(6),m3h2x3(:,7),heltab2x6(:,:,31))
  call Hloop_AQ_Z(ntryL,G2H6(33),ex1(:),G2H3(7),ngZu,m3h2x3(:,8),heltab2x6(:,:,32))
  call Hloop_AQ_Z(ntryL,G2H6(34),ex1(:),G2H3(8),ngZu,m3h2x3(:,9),heltab2x6(:,:,33))
  call Hloop_AQ_W(ntryL,G2H6(35),ex1(:),G2H3(9),m3h2x3(:,10),heltab2x6(:,:,34))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(12),mass5set(:,11),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),4,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(12),mass5set(:,20),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hotf_5pt_reduction(G2H6(36),RedSet_5(3),mass5set(:,21),  & 
G1H6(121),G1H6(122),G1H6(123),G1H6(124),G1H6(125),G1H6(126),6)
  call HG1shiftOLR(G1H6(122),8,6)
  call Hloop_QA_V(ntryL,G2H6(37),ex2(:),G2H3(10),m3h2x3(:,11),heltab2x6(:,:,35))
  call Hloop_QA_Z(ntryL,G2H6(38),ex2(:),G2H3(11),ngZu,m3h2x3(:,12),heltab2x6(:,:,36))
  call Hloop_QA_V(ntryL,G2H6(39),ex2(:),G2H3(12),m3h2x3(:,13),heltab2x6(:,:,37))
  call Hloop_QA_Z(ntryL,G2H6(40),ex2(:),G2H3(13),ngZu,m3h2x3(:,14),heltab2x6(:,:,38))
  call Hloop_SV_V(ntryL,G1H6(19),ex4(:),G1H2(9),m3h3x2(:,25),heltab2x6(:,:,39))
  call Hloop_SV_V(ntryL,G1H6(20),ex4(:),G1H2(10),m3h3x2(:,26),heltab2x6(:,:,40))
  call Hotf_5pt_reduction(G2H6(41),RedSet_5(4),mass5set(:,21),  & 
G1H6(19),G1H6(20),G1H6(127),G1H6(128),G1H6(129),G1H6(130),6)
  call HG1shiftOLR(G1H6(20),2,6)
  call Hotf_5pt_reduction(G2H6(42),RedSet_5(4),mass5set(:,22),  & 
G1H6(131),G1H6(132),G1H6(133),G1H6(134),G1H6(135),G1H6(136),6)
  call HG1shiftOLR(G1H6(132),2,6)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(5),mass5set(:,19),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),4,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(5),mass5set(:,23),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),4,4)
  call Hloop_QA_W(ntryL,G2H4(5),ex2(:),G2H2(17),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_W(ntryL,G2H4(6),ex2(:),G2H2(18),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_W(ntryL,G2H6(43),ex1(:),G2H3(14),m3h2x3(:,15),heltab2x6(:,:,41))
  call Hloop_AQ_W(ntryL,G2H6(45),ex1(:),G2H3(15),m3h2x3(:,16),heltab2x6(:,:,42))
  call Hloop_AQ_W(ntryL,G2H6(46),ex1(:),G2H3(16),m3h2x3(:,17),heltab2x6(:,:,43))
  call Hloop_AQ_W(ntryL,G2H6(47),ex1(:),G2H3(17),m3h2x3(:,18),heltab2x6(:,:,44))
  call Hloop_AQ_W(ntryL,G2H6(49),ex1(:),G2H3(18),m3h2x3(:,19),heltab2x6(:,:,45))
  call Hloop_AQ_W(ntryL,G2H6(50),ex1(:),G2H3(19),m3h2x3(:,20),heltab2x6(:,:,46))
  call Hloop_AQ_V(ntryL,G2H6(51),ex1(:),G2H3(20),m3h2x3(:,21),heltab2x6(:,:,47))
  call Hloop_AQ_V(ntryL,G2H6(53),ex1(:),G2H3(21),m3h2x3(:,22),heltab2x6(:,:,48))
  call Hloop_AQ_V(ntryL,G2H6(54),ex1(:),G2H3(22),m3h2x3(:,23),heltab2x6(:,:,49))
  call Hloop_AQ_V(ntryL,G2H6(55),ex1(:),G2H3(23),m3h2x3(:,24),heltab2x6(:,:,50))
  call Hloop_AQ_V(ntryL,G2H6(57),ex1(:),G2H3(24),m3h2x3(:,25),heltab2x6(:,:,51))
  call Hloop_AQ_V(ntryL,G2H6(58),ex1(:),G2H3(25),m3h2x3(:,26),heltab2x6(:,:,52))
  call Hloop_AQ_Z(ntryL,G2H6(59),ex1(:),G2H3(26),ngZu,m3h2x3(:,27),heltab2x6(:,:,53))
  call Hloop_AQ_Z(ntryL,G2H6(61),ex1(:),G2H3(27),ngZu,m3h2x3(:,28),heltab2x6(:,:,54))
  call Hloop_AQ_Z(ntryL,G2H6(62),ex1(:),G2H3(28),ngZu,m3h2x3(:,29),heltab2x6(:,:,55))
  call Hloop_AQ_Z(ntryL,G2H6(63),ex1(:),G2H3(29),ngZu,m3h2x3(:,30),heltab2x6(:,:,56))
  call Hloop_AQ_Z(ntryL,G2H6(65),ex1(:),G2H3(30),ngZu,m3h2x3(:,31),heltab2x6(:,:,57))
  call Hloop_AQ_Z(ntryL,G2H6(66),ex1(:),G2H3(31),ngZu,m3h2x3(:,32),heltab2x6(:,:,58))
  call Hloop_AQ_W(ntryL,G2H6(67),ex1(:),G2H3(32),m3h2x3(:,33),heltab2x6(:,:,59))
  call Hloop_AQ_W(ntryL,G2H6(69),ex1(:),G2H3(33),m3h2x3(:,34),heltab2x6(:,:,60))
  call Hloop_AQ_W(ntryL,G2H6(70),ex1(:),G2H3(34),m3h2x3(:,35),heltab2x6(:,:,61))
  call Hloop_AQ_W(ntryL,G2H6(71),ex1(:),G2H3(35),m3h2x3(:,36),heltab2x6(:,:,62))
  call Hloop_AQ_W(ntryL,G2H6(73),ex1(:),G2H3(36),m3h2x3(:,37),heltab2x6(:,:,63))
  call Hloop_AQ_W(ntryL,G2H6(74),ex1(:),G2H3(37),m3h2x3(:,38),heltab2x6(:,:,64))
  call Hloop_QA_V(ntryL,G2H6(75),ex2(:),G2H3(38),m3h2x3(:,39),heltab2x6(:,:,65))
  call Hloop_QA_V(ntryL,G2H6(77),ex2(:),G2H3(39),m3h2x3(:,40),heltab2x6(:,:,66))
  call Hloop_QA_V(ntryL,G2H6(78),ex2(:),G2H3(40),m3h2x3(:,41),heltab2x6(:,:,67))
  call Hloop_QA_Z(ntryL,G2H6(79),ex2(:),G2H3(41),ngZu,m3h2x3(:,42),heltab2x6(:,:,68))
  call Hloop_QA_Z(ntryL,G2H6(81),ex2(:),G2H3(42),ngZu,m3h2x3(:,43),heltab2x6(:,:,69))
  call Hloop_QA_Z(ntryL,G2H6(82),ex2(:),G2H3(43),ngZu,m3h2x3(:,44),heltab2x6(:,:,70))
  call Hloop_QA_V(ntryL,G2H6(83),ex2(:),G2H3(44),m3h2x3(:,45),heltab2x6(:,:,71))
  call Hloop_QA_V(ntryL,G2H6(85),ex2(:),G2H3(45),m3h2x3(:,46),heltab2x6(:,:,72))
  call Hloop_QA_V(ntryL,G2H6(86),ex2(:),G2H3(46),m3h2x3(:,47),heltab2x6(:,:,73))
  call Hloop_QA_Z(ntryL,G2H6(87),ex2(:),G2H3(47),ngZu,m3h2x3(:,48),heltab2x6(:,:,74))
  call Hloop_QA_Z(ntryL,G2H6(89),ex2(:),G2H3(48),ngZu,m3h2x3(:,49),heltab2x6(:,:,75))
  call Hloop_QA_Z(ntryL,G2H6(90),ex2(:),G2H3(49),ngZu,m3h2x3(:,50),heltab2x6(:,:,76))
  call Hotf_5pt_reduction(G2H6(91),RedSet_5(4),mass5set(:,3),  & 
G1H6(137),G1H6(138),G1H6(139),G1H6(140),G1H6(141),G1H6(142),6)
  call HG1shiftOLR(G1H6(138),2,6)
  call Hotf_4pt_reduction(G2H6(93),RedSet_4(1),mass4set(:,1),  & 
G1H6(143),G1H6(144),G1H6(145),G1H6(146),G1H6(147),6)
  call HG1shiftOLR(G1H6(144),2,6)
  call Hotf_4pt_reduction(G2H6(94),RedSet_4(2),mass4set(:,1),  & 
G1H6(148),G1H6(149),G1H6(150),G1H6(151),G1H6(152),6)
  call HG1shiftOLR(G1H6(149),10,6)
  call Hotf_5pt_reduction(G2H6(95),RedSet_5(4),mass5set(:,4),  & 
G1H6(153),G1H6(154),G1H6(155),G1H6(156),G1H6(157),G1H6(158),6)
  call HG1shiftOLR(G1H6(154),2,6)
  call Hotf_4pt_reduction(G2H6(97),RedSet_4(1),mass4set(:,2),  & 
G1H6(159),G1H6(160),G1H6(161),G1H6(162),G1H6(163),6)
  call HG1shiftOLR(G1H6(160),2,6)
  call Hotf_4pt_reduction(G2H6(98),RedSet_4(2),mass4set(:,2),  & 
G1H6(164),G1H6(165),G1H6(166),G1H6(167),G1H6(168),6)
  call HG1shiftOLR(G1H6(165),10,6)
  call Hloop_QA_W(ntryL,G2H4(19),ex2(:),G2H2(19),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_W(ntryL,G2H4(21),ex2(:),G2H2(20),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_W(ntryL,G2H4(22),ex2(:),G2H2(21),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_W(ntryL,G2H4(23),ex2(:),G2H2(22),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_W(ntryL,G2H4(25),ex2(:),G2H2(23),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_W(ntryL,G2H4(26),ex2(:),G2H2(24),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(6),mass5set(:,3),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),2,4)
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(1),mass4set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),4)
  call HG1shiftOLR(G1H4(32),2,4)
  call Hotf_4pt_reduction(G2H4(30),RedSet_4(3),mass4set(:,1),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(37),6,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(6),mass5set(:,4),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(42),2,4)
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(1),mass4set(:,2),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),4)
  call HG1shiftOLR(G1H4(48),2,4)
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(3),mass4set(:,2),  & 
G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(53),6,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(143),[G1H6(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(148),[G1H6(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(159),[G1H6(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(164),[G1H6(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(46)])
  call Hloop_WA_Q(ntryL,G1H6(25),ex2(:),G1H3(2),m3h2x3(:,51),heltab2x6(:,:,77))
  call Hloop_A_Q(ntryL,G1H3(2),23,0,G2H3(50),n2h3(1))
call HGT_OLR(G1H6(26),1,1,6)
call HGT_invQ_OLR(G1H6(26),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(26),-8,0,G2H6(1),n2h6(73))
  call Hloop_QW_A(ntryL,G2H6(1),ex4(:),G2H2(25),m3h3x2(:,27),heltab2x6(:,:,78))
  call Hloop_WA_Q(ntryL,G1H6(29),ex2(:),G1H3(2),m3h2x3(:,52),heltab2x6(:,:,79))
  call Hloop_A_Q(ntryL,G1H3(2),23,0,G2H3(51),n2h3(2))
  call Hloop_WA_Q(ntryL,G1H6(30),ex2(:),G1H3(2),m3h2x3(:,53),heltab2x6(:,:,80))
  call Hloop_A_Q(ntryL,G1H3(2),23,0,G2H3(52),n2h3(3))
  call Hloop_QV_A(ntryL,G1H6(31),ex3(:),G1H3(2),m3h2x3(:,54),heltab2x6(:,:,81))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(53),n2h3(4))
call HGT_OLR(G1H6(32),1,1,6)
call HGT_invQ_OLR(G1H6(32),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(32),-8,0,G2H6(2),n2h6(74))
  call Hloop_AW_Q(ntryL,G2H6(2),ex4(:),G2H2(26),m3h3x2(:,28),heltab2x6(:,:,82))
  call Hloop_QV_A(ntryL,G1H6(35),ex3(:),G1H3(2),m3h2x3(:,55),heltab2x6(:,:,83))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(54),n2h3(5))
  call Hloop_QV_A(ntryL,G1H6(36),ex3(:),G1H3(2),m3h2x3(:,56),heltab2x6(:,:,84))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(55),n2h3(6))
  call Hloop_QV_A(ntryL,G1H6(37),ex3(:),G1H3(2),m3h2x3(:,57),heltab2x6(:,:,85))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(56),n2h3(7))
call HGT_OLR(G1H6(38),1,1,6)
call HGT_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(38),-8,0,G2H6(3),n2h6(75))
  call Hloop_AW_Q(ntryL,G2H6(3),ex4(:),G2H2(27),m3h3x2(:,29),heltab2x6(:,:,86))
  call Hloop_QV_A(ntryL,G1H6(41),ex3(:),G1H3(2),m3h2x3(:,58),heltab2x6(:,:,87))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(57),n2h3(8))
  call Hloop_QV_A(ntryL,G1H6(42),ex3(:),G1H3(2),m3h2x3(:,59),heltab2x6(:,:,88))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(58),n2h3(9))
  call Hloop_UW_V(ntryL,G1H6(1),19,ex3(:),4,G2H3(59),m3h2x3(:,60),heltab2x6(:,:,89))
call HGT_raise_alpha_OLR(G1H6(2),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(2),-8,ex4(:),8,G2H2(28),m3h3x2(:,30),heltab2x6(:,:,90))
  call Hloop_UW_V(ntryL,G1H6(45),19,ex3(:),4,G2H3(60),m3h2x3(:,61),heltab2x6(:,:,91))
  call Hloop_UW_V(ntryL,G1H6(46),19,ex3(:),4,G2H3(61),m3h2x3(:,62),heltab2x6(:,:,92))
  call Hloop_UW_V(ntryL,G1H6(47),19,ex3(:),4,G2H3(62),m3h2x3(:,63),heltab2x6(:,:,93))
call HGT_raise_alpha_OLR(G1H6(48),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(48),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(48),-8,ex4(:),8,G2H2(29),m3h3x2(:,31),heltab2x6(:,:,94))
  call Hloop_UW_V(ntryL,G1H6(51),19,ex3(:),4,G2H3(63),m3h2x3(:,64),heltab2x6(:,:,95))
  call Hloop_UW_V(ntryL,G1H6(52),19,ex3(:),4,G2H3(64),m3h2x3(:,65),heltab2x6(:,:,96))
  call Hloop_VQ_A(ntryL,G1H6(53),ex1(:),G1H3(2),m3h2x3(:,66),heltab2x6(:,:,97))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(65),n2h3(10))
call HGT_OLR(G1H6(54),1,1,6)
call HGT_invQ_OLR(G1H6(54),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(54),-8,0,G2H6(4),n2h6(78))
  call Hloop_AW_Q(ntryL,G2H6(4),ex4(:),G2H2(30),m3h3x2(:,32),heltab2x6(:,:,98))
  call Hloop_VQ_A(ntryL,G1H6(57),ex1(:),G1H3(2),m3h2x3(:,67),heltab2x6(:,:,99))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(66),n2h3(11))
  call Hloop_VQ_A(ntryL,G1H6(58),ex1(:),G1H3(2),m3h2x3(:,68),heltab2x6(:,:,100))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(67),n2h3(12))
  call Hloop_ZQ_A(ntryL,G1H6(59),ex1(:),G1H3(2),ngZu,m3h2x3(:,69),heltab2x6(:,:,101))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(68),n2h3(13))
call HGT_OLR(G1H6(60),1,1,6)
call HGT_invQ_OLR(G1H6(60),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(60),-8,0,G2H6(5),n2h6(79))
  call Hloop_AW_Q(ntryL,G2H6(5),ex4(:),G2H2(31),m3h3x2(:,33),heltab2x6(:,:,102))
  call Hloop_ZQ_A(ntryL,G1H6(63),ex1(:),G1H3(2),ngZu,m3h2x3(:,70),heltab2x6(:,:,103))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(69),n2h3(14))
  call Hloop_ZQ_A(ntryL,G1H6(64),ex1(:),G1H3(2),ngZu,m3h2x3(:,71),heltab2x6(:,:,104))
  call Hloop_Q_A(ntryL,G1H3(2),23,0,G2H3(70),n2h3(15))
  call Hloop_QW_A(ntryL,G1H6(65),ex4(:),G1H2(11),m3h3x2(:,34),heltab2x6(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(32),n2h2(1))
call HGT_OLR(G1H6(66),1,1,6)
call HGT_invQ_OLR(G1H6(66),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(66),-4,0,G2H6(6),n2h6(80))
  call Hloop_AV_Q(ntryL,G2H6(6),ex3(:),G2H3(71),m3h2x3(:,72),heltab2x6(:,:,106))
  call Hloop_QW_A(ntryL,G1H6(69),ex4(:),G1H2(11),m3h3x2(:,35),heltab2x6(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(33),n2h2(2))
  call Hloop_QW_A(ntryL,G1H6(70),ex4(:),G1H2(11),m3h3x2(:,36),heltab2x6(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(34),n2h2(3))
  call Hloop_QW_A(ntryL,G1H6(71),ex4(:),G1H2(11),m3h3x2(:,37),heltab2x6(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(35),n2h2(4))
call HGT_OLR(G1H6(72),1,1,6)
call HGT_invQ_OLR(G1H6(72),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(72),-4,0,G2H6(7),n2h6(81))
  call Hloop_AV_Q(ntryL,G2H6(7),ex3(:),G2H3(72),m3h2x3(:,73),heltab2x6(:,:,110))
  call Hloop_QW_A(ntryL,G1H6(75),ex4(:),G1H2(11),m3h3x2(:,38),heltab2x6(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(36),n2h2(5))
  call Hloop_QW_A(ntryL,G1H6(76),ex4(:),G1H2(11),m3h3x2(:,39),heltab2x6(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(37),n2h2(6))
  call Hloop_UW_V(ntryL,G1H6(3),19,ex4(:),8,G2H2(38),m3h3x2(:,40),heltab2x6(:,:,113))
call HGT_raise_alpha_OLR(G1H6(4),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(4),-4,ex3(:),4,G2H3(73),m3h2x3(:,74),heltab2x6(:,:,114))
  call Hloop_UW_V(ntryL,G1H6(7),19,ex4(:),8,G2H2(39),m3h3x2(:,41),heltab2x6(:,:,115))
  call Hloop_UW_V(ntryL,G1H6(8),19,ex4(:),8,G2H2(40),m3h3x2(:,42),heltab2x6(:,:,116))
  call Hloop_UW_V(ntryL,G1H6(9),19,ex4(:),8,G2H2(41),m3h3x2(:,43),heltab2x6(:,:,117))
call HGT_raise_alpha_OLR(G1H6(10),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(10),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(10),-4,ex3(:),4,G2H3(74),m3h2x3(:,75),heltab2x6(:,:,118))
  call Hloop_UW_V(ntryL,G1H6(79),19,ex4(:),8,G2H2(42),m3h3x2(:,44),heltab2x6(:,:,119))
  call Hloop_UW_V(ntryL,G1H6(80),19,ex4(:),8,G2H2(43),m3h3x2(:,45),heltab2x6(:,:,120))
  call Hloop_UW_V(ntryL,G1H6(81),19,ex4(:),8,G2H2(44),m3h3x2(:,46),heltab2x6(:,:,121))
call HGT_raise_alpha_OLR(G1H6(82),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(82),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(82),-4,ex3(:),4,G2H3(75),m3h2x3(:,76),heltab2x6(:,:,122))
  call Hloop_UW_V(ntryL,G1H6(85),19,ex4(:),8,G2H2(45),m3h3x2(:,47),heltab2x6(:,:,123))
  call Hloop_UW_V(ntryL,G1H6(86),19,ex4(:),8,G2H2(46),m3h3x2(:,48),heltab2x6(:,:,124))
  call Hloop_UW_V(ntryL,G1H6(87),19,ex4(:),8,G2H2(47),m3h3x2(:,49),heltab2x6(:,:,125))
call HGT_raise_alpha_OLR(G1H6(88),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(88),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(88),-4,ex3(:),4,G2H3(76),m3h2x3(:,77),heltab2x6(:,:,126))
  call Hloop_UW_V(ntryL,G1H6(91),19,ex4(:),8,G2H2(48),m3h3x2(:,50),heltab2x6(:,:,127))
  call Hloop_UW_V(ntryL,G1H6(92),19,ex4(:),8,G2H2(49),m3h3x2(:,51),heltab2x6(:,:,128))
  call Hloop_AV_Q(ntryL,G1H6(93),ex3(:),G1H3(2),m3h2x3(:,78),heltab2x6(:,:,129))
  call Hloop_A_Q(ntryL,G1H3(2),23,0,G2H3(77),n2h3(16))
call HGT_OLR(G1H6(94),1,1,6)
call HGT_invQ_OLR(G1H6(94),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(94),-8,0,G2H6(8),n2h6(86))
  call Hloop_QW_A(ntryL,G2H6(8),ex4(:),G2H2(50),m3h3x2(:,52),heltab2x6(:,:,130))
  call Hloop_AV_Q(ntryL,G1H6(97),ex3(:),G1H3(2),m3h2x3(:,79),heltab2x6(:,:,131))
  call Hloop_A_Q(ntryL,G1H3(2),23,0,G2H3(78),n2h3(17))
  call Hloop_AV_Q(ntryL,G1H6(98),ex3(:),G1H3(2),m3h2x3(:,80),heltab2x6(:,:,132))
  call Hloop_A_Q(ntryL,G1H3(2),23,0,G2H3(79),n2h3(18))
  call Hloop_AW_Q(ntryL,G1H6(99),ex4(:),G1H2(11),m3h3x2(:,53),heltab2x6(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(11),27,0,G2H2(51),n2h2(7))
call HGT_OLR(G1H6(100),1,1,6)
call HGT_invQ_OLR(G1H6(100),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(100),-4,0,G2H6(9),n2h6(87))
  call Hloop_QV_A(ntryL,G2H6(9),ex3(:),G2H3(80),m3h2x3(:,81),heltab2x6(:,:,134))
  call Hloop_AW_Q(ntryL,G1H6(103),ex4(:),G1H2(11),m3h3x2(:,54),heltab2x6(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(11),27,0,G2H2(52),n2h2(8))
  call Hloop_AW_Q(ntryL,G1H6(104),ex4(:),G1H2(11),m3h3x2(:,55),heltab2x6(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(11),27,0,G2H2(53),n2h2(9))
  call Hloop_UW_V(ntryL,G1H6(11),19,ex4(:),8,G2H2(54),m3h3x2(:,56),heltab2x6(:,:,137))
call HGT_raise_alpha_OLR(G1H6(12),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(12),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(12),-4,ex3(:),4,G2H3(81),m3h2x3(:,82),heltab2x6(:,:,138))
  call Hloop_UW_V(ntryL,G1H6(15),19,ex4(:),8,G2H2(55),m3h3x2(:,57),heltab2x6(:,:,139))
  call Hloop_UW_V(ntryL,G1H6(16),19,ex4(:),8,G2H2(56),m3h3x2(:,58),heltab2x6(:,:,140))
  call Hloop_UW_V(ntryL,G1H6(17),19,ex4(:),8,G2H2(57),m3h3x2(:,59),heltab2x6(:,:,141))
call HGT_raise_alpha_OLR(G1H6(18),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(18),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(18),-4,ex3(:),4,G2H3(82),m3h2x3(:,83),heltab2x6(:,:,142))
  call Hloop_UW_V(ntryL,G1H6(107),19,ex4(:),8,G2H2(58),m3h3x2(:,60),heltab2x6(:,:,143))
  call Hloop_UW_V(ntryL,G1H6(108),19,ex4(:),8,G2H2(59),m3h3x2(:,61),heltab2x6(:,:,144))
  call Hloop_UW_V(ntryL,G1H6(109),19,ex4(:),8,G2H2(60),m3h3x2(:,62),heltab2x6(:,:,145))
call HGT_raise_alpha_OLR(G1H6(110),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(110),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(110),-4,ex3(:),4,G2H3(83),m3h2x3(:,84),heltab2x6(:,:,146))
  call Hloop_UW_V(ntryL,G1H6(113),19,ex4(:),8,G2H2(61),m3h3x2(:,63),heltab2x6(:,:,147))
  call Hloop_UW_V(ntryL,G1H6(114),19,ex4(:),8,G2H2(62),m3h3x2(:,64),heltab2x6(:,:,148))
  call Hloop_UW_V(ntryL,G1H6(115),19,ex4(:),8,G2H2(63),m3h3x2(:,65),heltab2x6(:,:,149))
call HGT_raise_alpha_OLR(G1H6(116),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(116),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(116),-4,ex3(:),4,G2H3(84),m3h2x3(:,85),heltab2x6(:,:,150))
  call Hloop_UW_V(ntryL,G1H6(119),19,ex4(:),8,G2H2(64),m3h3x2(:,66),heltab2x6(:,:,151))
  call Hloop_UW_V(ntryL,G1H6(120),19,ex4(:),8,G2H2(65),m3h3x2(:,67),heltab2x6(:,:,152))
  call Hloop_WQ_A(ntryL,G1H4(1),ex1(:),G1H2(11),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(66),n2h2(10))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(2),-4,0,G2H4(1),n2h4(19))
  call Hloop_AV_Q(ntryL,G2H4(1),ex3(:),G2H2(67),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_WQ_A(ntryL,G1H4(5),ex1(:),G1H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(68),n2h2(11))
  call Hloop_WQ_A(ntryL,G1H4(6),ex1(:),G1H2(11),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(69),n2h2(12))
  call Hloop_WQ_A(ntryL,G1H4(7),ex1(:),G1H2(11),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(70),n2h2(13))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-4,0,G2H4(2),n2h4(20))
  call Hloop_AV_Q(ntryL,G2H4(2),ex3(:),G2H2(71),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_WQ_A(ntryL,G1H4(11),ex1(:),G1H2(11),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(72),n2h2(14))
  call Hloop_WQ_A(ntryL,G1H4(12),ex1(:),G1H2(11),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(11),27,0,G2H2(73),n2h2(15))
  call Hloop_WA_Q(ntryL,G1H6(121),ex2(:),G1H3(2),m3h2x3(:,86),heltab2x6(:,:,153))
  call Hloop_A_Q(ntryL,G1H3(2),23,0,G2H3(85),n2h3(19))
call HGT_OLR(G1H6(122),1,1,6)
call HGT_invQ_OLR(G1H6(122),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(122),-8,0,G2H6(10),n2h6(92))
  call Hloop_QW_A(ntryL,G2H6(10),ex4(:),G2H2(74),m3h3x2(:,68),heltab2x6(:,:,154))
  call Hloop_WA_Q(ntryL,G1H6(125),ex2(:),G1H3(2),m3h2x3(:,87),heltab2x6(:,:,155))
  call Hloop_A_Q(ntryL,G1H3(2),23,0,G2H3(86),n2h3(20))
  call Hloop_WA_Q(ntryL,G1H6(126),ex2(:),G1H3(2),m3h2x3(:,88),heltab2x6(:,:,156))
  call Hloop_A_Q(ntryL,G1H3(2),23,0,G2H3(87),n2h3(21))
  call Hloop_UV_W(ntryL,G1H6(19),21,ex4(:),8,G2H2(75),m3h3x2(:,69),heltab2x6(:,:,157))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(20),-2,0,G2H6(11),n2h6(93))
  call Hloop_QA_V(ntryL,G2H6(11),ex2(:),G2H3(88),m3h2x3(:,89),heltab2x6(:,:,158))
  call Hloop_UV_W(ntryL,G1H6(129),21,ex4(:),8,G2H2(76),m3h3x2(:,70),heltab2x6(:,:,159))
  call Hloop_UV_W(ntryL,G1H6(130),21,ex4(:),8,G2H2(77),m3h3x2(:,71),heltab2x6(:,:,160))
  call Hloop_UV_W(ntryL,G1H6(131),21,ex4(:),8,G2H2(78),m3h3x2(:,72),heltab2x6(:,:,161))
call HGT_OLR(G1H6(132),1,1,6)
call HGT_invQ_OLR(G1H6(132),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(132),-2,0,G2H6(12),n2h6(94))
  call Hloop_QA_Z(ntryL,G2H6(12),ex2(:),G2H3(89),ngZu,m3h2x3(:,90),heltab2x6(:,:,162))
  call Hloop_UV_W(ntryL,G1H6(135),21,ex4(:),8,G2H2(79),m3h3x2(:,73),heltab2x6(:,:,163))
  call Hloop_UV_W(ntryL,G1H6(136),21,ex4(:),8,G2H2(80),m3h3x2(:,74),heltab2x6(:,:,164))
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(11),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(11),27,0,G2H2(81),n2h2(16))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(14),-4,0,G2H4(3),n2h4(21))
  call Hloop_QV_A(ntryL,G2H4(3),ex3(:),G2H2(82),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_VA_Q(ntryL,G1H4(17),ex2(:),G1H2(11),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(11),27,0,G2H2(83),n2h2(17))
  call Hloop_VA_Q(ntryL,G1H4(18),ex2(:),G1H2(11),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(11),27,0,G2H2(84),n2h2(18))
  call Hloop_ZA_Q(ntryL,G1H4(19),ex2(:),G1H2(11),ngZu,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(11),27,0,G2H2(85),n2h2(19))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-4,0,G2H4(4),n2h4(22))
  call Hloop_QV_A(ntryL,G2H4(4),ex3(:),G2H2(86),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_ZA_Q(ntryL,G1H4(23),ex2(:),G1H2(11),ngZu,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(11),27,0,G2H2(87),n2h2(20))
  call Hloop_ZA_Q(ntryL,G1H4(24),ex2(:),G1H2(11),ngZu,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(11),27,0,G2H2(88),n2h2(21))
  call Hloop_QW_A(ntryL,G1H6(137),ex4(:),G1H2(11),m3h3x2(:,75),heltab2x6(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(89),n2h2(22))
call HGT_raise_alpha_OLR(G1H6(138),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(138),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(138),ex2(:),G1H3(2),m3h2x3(:,91),heltab2x6(:,:,166))
  call Hloop_QW_A(ntryL,G1H6(143),ex4(:),G1H2(11),m3h3x2(:,76),heltab2x6(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(90),n2h2(23))
  call Hloop_QW_A(ntryL,G1H6(148),ex4(:),G1H2(11),m3h3x2(:,77),heltab2x6(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(91),n2h2(24))
call HGT_raise_alpha_OLR(G1H6(144),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(144),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(144),ex2(:),G1H3(3),m3h2x3(:,92),heltab2x6(:,:,169))
  call Hloop_QW_A(ntryL,G1H6(147),ex4(:),G1H2(11),m3h3x2(:,78),heltab2x6(:,:,170))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(92),n2h2(25))
call HGT_raise_alpha_OLR(G1H6(149),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(149),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(149),ex2(:),G1H3(4),m3h2x3(:,93),heltab2x6(:,:,171))
  call Hloop_QW_A(ntryL,G1H6(152),ex4(:),G1H2(11),m3h3x2(:,79),heltab2x6(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(93),n2h2(26))
  call Hloop_QW_A(ntryL,G1H6(153),ex4(:),G1H2(11),m3h3x2(:,80),heltab2x6(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(94),n2h2(27))
call HGT_raise_alpha_OLR(G1H6(154),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(154),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(154),ex2(:),G1H3(5),m3h2x3(:,94),heltab2x6(:,:,174))
  call Hloop_QW_A(ntryL,G1H6(159),ex4(:),G1H2(11),m3h3x2(:,81),heltab2x6(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(95),n2h2(28))
  call Hloop_QW_A(ntryL,G1H6(164),ex4(:),G1H2(11),m3h3x2(:,82),heltab2x6(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(96),n2h2(29))
call HGT_raise_alpha_OLR(G1H6(160),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(160),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(160),ex2(:),G1H3(6),m3h2x3(:,95),heltab2x6(:,:,177))
  call Hloop_QW_A(ntryL,G1H6(163),ex4(:),G1H2(11),m3h3x2(:,83),heltab2x6(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(97),n2h2(30))
call HGT_raise_alpha_OLR(G1H6(165),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(165),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(165),ex2(:),G1H3(7),m3h2x3(:,96),heltab2x6(:,:,179))
  call Hloop_QW_A(ntryL,G1H6(168),ex4(:),G1H2(11),m3h3x2(:,84),heltab2x6(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(98),n2h2(31))
  call Hloop_QV_A(ntryL,G1H4(25),ex3(:),G1H2(11),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(99),n2h2(32))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(26),ex2(:),G1H2(11),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QV_A(ntryL,G1H4(31),ex3(:),G1H2(12),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(12),29,0,G2H2(100),n2h2(33))
  call Hloop_QV_A(ntryL,G1H4(36),ex3(:),G1H2(12),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(12),29,0,G2H2(101),n2h2(34))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(32),ex2(:),G1H2(12),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QV_A(ntryL,G1H4(35),ex3(:),G1H2(13),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(13),29,0,G2H2(102),n2h2(35))
call HGT_raise_alpha_OLR(G1H4(37),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(37),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(37),ex2(:),G1H2(13),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QV_A(ntryL,G1H4(40),ex3(:),G1H2(14),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(14),29,0,G2H2(103),n2h2(36))
  call Hloop_QV_A(ntryL,G1H4(41),ex3(:),G1H2(14),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(14),29,0,G2H2(104),n2h2(37))
call HGT_raise_alpha_OLR(G1H4(42),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(42),ex2(:),G1H2(14),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QV_A(ntryL,G1H4(47),ex3(:),G1H2(15),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(15),29,0,G2H2(105),n2h2(38))
  call Hloop_QV_A(ntryL,G1H4(52),ex3(:),G1H2(15),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(15),29,0,G2H2(106),n2h2(39))
call HGT_raise_alpha_OLR(G1H4(48),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(48),ex2(:),G1H2(15),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QV_A(ntryL,G1H4(51),ex3(:),G1H2(16),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(16),29,0,G2H2(107),n2h2(40))
call HGT_raise_alpha_OLR(G1H4(53),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(53),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(53),ex2(:),G1H2(16),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QV_A(ntryL,G1H4(56),ex3(:),G1H2(17),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(17),29,0,G2H2(108),n2h2(41))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(10)])
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(1),23,ex4(:),8,G2tensor(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(1),ex4(:),G2tensor(2),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(2),ex4(:),G2tensor(3),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(3),ex4(:),G2tensor(4),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(4),ex4(:),G2tensor(5),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(1),27,ex3(:),4,G2tensor(6),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(2),27,ex3(:),4,G2tensor(7),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(3),27,ex3(:),4,G2tensor(8),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(4),27,ex3(:),4,G2tensor(9),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(10),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(11),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(12),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(13),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(14),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(15),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(16),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(17),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(5),27,ex3(:),4,G2tensor(18),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(6),27,ex3(:),4,G2tensor(19),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(7),27,ex3(:),4,G2tensor(20),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(8),27,ex3(:),4,G2tensor(21),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(22),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(23),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(24),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(12),ex3(:),G2tensor(25),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(26),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(27),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(28),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(29),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(5),ex4(:),G2tensor(30),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(6),ex4(:),G2tensor(31),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(7),ex4(:),G2tensor(32),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(8),ex4(:),G2tensor(33),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(9),ex4(:),G2tensor(34),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(10),ex4(:),G2tensor(35),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(11),ex4(:),G2tensor(36),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(12),ex4(:),G2tensor(37),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(13),ex4(:),G2tensor(38),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(4),mass5set(:,21),  & 
G1H2(17),G1H2(9),G1H2(10),G1H2(1),G1H2(2),G1H2(3),2)
  call HG1shiftOLR(G1H2(9),2,2)
  call Hotf_5pt_reduction(G2H2(78),RedSet_5(4),mass5set(:,22),  & 
G1H2(4),G1H2(5),G1H2(6),G1H2(7),G1H2(8),G1H2(18),2)
  call HG1shiftOLR(G1H2(5),2,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(39),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(40),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hotf_5pt_reduction(G2H3(14),RedSet_5(1),mass5set(:,1),  & 
G1H3(1),G1H3(8),G1H3(9),G1H3(10),G1H3(11),G1H3(12),3)
  call HG1shiftOLR(G1H3(8),8,3)
  call Hotf_4pt_reduction(G2H3(16),RedSet_4(4),mass4set(:,3),  & 
G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),3)
  call HG1shiftOLR(G1H3(14),9,3)
  call Hotf_5pt_reduction(G2H3(17),RedSet_5(1),mass5set(:,2),  & 
G1H3(18),G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),3)
  call HG1shiftOLR(G1H3(19),8,3)
  call Hotf_4pt_reduction(G2H3(19),RedSet_4(4),mass4set(:,4),  & 
G1H3(24),G1H3(25),G1H3(26),G1H3(27),G1H3(28),3)
  call HG1shiftOLR(G1H3(25),9,3)
  call Hotf_5pt_reduction(G2H3(20),RedSet_5(2),mass5set(:,3),  & 
G1H3(29),G1H3(30),G1H3(31),G1H3(32),G1H3(33),G1H3(34),3)
  call HG1shiftOLR(G1H3(30),8,3)
  call Hotf_4pt_reduction(G2H3(22),RedSet_4(5),mass4set(:,1),  & 
G1H3(35),G1H3(36),G1H3(37),G1H3(38),G1H3(39),3)
  call HG1shiftOLR(G1H3(36),9,3)
  call Hotf_5pt_reduction(G2H3(23),RedSet_5(2),mass5set(:,4),  & 
G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),G1H3(45),3)
  call HG1shiftOLR(G1H3(41),8,3)
  call Hotf_4pt_reduction(G2H3(25),RedSet_4(5),mass4set(:,2),  & 
G1H3(46),G1H3(47),G1H3(48),G1H3(49),G1H3(50),3)
  call HG1shiftOLR(G1H3(47),9,3)
  call Hotf_5pt_reduction(G2H3(26),RedSet_5(2),mass5set(:,5),  & 
G1H3(51),G1H3(52),G1H3(53),G1H3(54),G1H3(55),G1H3(56),3)
  call HG1shiftOLR(G1H3(52),8,3)
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(5),mass4set(:,1),  & 
G1H3(57),G1H3(58),G1H3(59),G1H3(60),G1H3(61),3)
  call HG1shiftOLR(G1H3(58),9,3)
  call Hotf_5pt_reduction(G2H3(29),RedSet_5(2),mass5set(:,6),  & 
G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),G1H3(67),3)
  call HG1shiftOLR(G1H3(63),8,3)
  call Hotf_4pt_reduction(G2H3(31),RedSet_4(5),mass4set(:,2),  & 
G1H3(68),G1H3(69),G1H3(70),G1H3(71),G1H3(72),3)
  call HG1shiftOLR(G1H3(69),9,3)
  call Hotf_5pt_reduction(G2H3(32),RedSet_5(2),mass5set(:,7),  & 
G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),G1H3(78),3)
  call HG1shiftOLR(G1H3(74),8,3)
  call Hotf_4pt_reduction(G2H3(34),RedSet_4(5),mass4set(:,5),  & 
G1H3(79),G1H3(80),G1H3(81),G1H3(82),G1H3(83),3)
  call HG1shiftOLR(G1H3(80),9,3)
  call Hotf_5pt_reduction(G2H3(35),RedSet_5(2),mass5set(:,8),  & 
G1H3(84),G1H3(85),G1H3(86),G1H3(87),G1H3(88),G1H3(89),3)
  call HG1shiftOLR(G1H3(85),8,3)
  call Hotf_4pt_reduction(G2H3(37),RedSet_4(5),mass4set(:,6),  & 
G1H3(90),G1H3(91),G1H3(92),G1H3(93),G1H3(94),3)
  call HG1shiftOLR(G1H3(91),9,3)
  call Hotf_5pt_reduction(G2H3(38),RedSet_5(3),mass5set(:,3),  & 
G1H3(95),G1H3(96),G1H3(97),G1H3(98),G1H3(99),G1H3(100),3)
  call HG1shiftOLR(G1H3(96),8,3)
  call Hotf_4pt_reduction(G2H3(40),RedSet_4(2),mass4set(:,1),  & 
G1H3(101),G1H3(102),G1H3(103),G1H3(104),G1H3(105),3)
  call HG1shiftOLR(G1H3(102),10,3)
  call Hotf_5pt_reduction(G2H3(41),RedSet_5(3),mass5set(:,5),  & 
G1H3(106),G1H3(107),G1H3(108),G1H3(109),G1H3(110),G1H3(111),3)
  call HG1shiftOLR(G1H3(107),8,3)
  call Hotf_4pt_reduction(G2H3(43),RedSet_4(2),mass4set(:,1),  & 
G1H3(112),G1H3(113),G1H3(114),G1H3(115),G1H3(116),3)
  call HG1shiftOLR(G1H3(113),10,3)
  call Hotf_5pt_reduction(G2H3(44),RedSet_5(3),mass5set(:,4),  & 
G1H3(117),G1H3(118),G1H3(119),G1H3(120),G1H3(121),G1H3(122),3)
  call HG1shiftOLR(G1H3(118),8,3)
  call Hotf_4pt_reduction(G2H3(46),RedSet_4(2),mass4set(:,2),  & 
G1H3(123),G1H3(124),G1H3(125),G1H3(126),G1H3(127),3)
  call HG1shiftOLR(G1H3(124),10,3)
  call Hotf_5pt_reduction(G2H3(47),RedSet_5(3),mass5set(:,6),  & 
G1H3(128),G1H3(129),G1H3(130),G1H3(131),G1H3(132),G1H3(133),3)
  call HG1shiftOLR(G1H3(129),8,3)
  call Hotf_4pt_reduction(G2H3(49),RedSet_4(2),mass4set(:,2),  & 
G1H3(134),G1H3(135),G1H3(136),G1H3(137),G1H3(138),3)
  call HG1shiftOLR(G1H3(135),10,3)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(5),mass5set(:,9),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),4,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(3),mass4set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),2)
  call HG1shiftOLR(G1H2(26),6,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(5),mass5set(:,10),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),2)
  call HG1shiftOLR(G1H2(31),4,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(3),mass4set(:,2),  & 
G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(37),6,2)
  call Hotf_5pt_reduction(G2H3(50),RedSet_5(7),mass5set(:,11),  & 
G1H3(139),G1H3(140),G1H3(141),G1H3(142),G1H3(143),G1H3(144),3)
  call HG1shiftOLR(G1H3(140),8,3)
  call Hotf_4pt_reduction(G2H3(52),RedSet_4(6),mass4set(:,7),  & 
G1H3(145),G1H3(146),G1H3(147),G1H3(148),G1H3(149),3)
  call HG1shiftOLR(G1H3(146),10,3)
  call Hotf_5pt_reduction(G2H3(53),RedSet_5(8),mass5set(:,12),  & 
G1H3(150),G1H3(151),G1H3(152),G1H3(153),G1H3(154),G1H3(155),3)
  call HG1shiftOLR(G1H3(151),8,3)
  call Hotf_4pt_reduction(G2H3(55),RedSet_4(7),mass4set(:,8),  & 
G1H3(156),G1H3(157),G1H3(158),G1H3(159),G1H3(160),3)
  call HG1shiftOLR(G1H3(157),12,3)
  call Hotf_5pt_reduction(G2H3(56),RedSet_5(8),mass5set(:,13),  & 
G1H3(161),G1H3(162),G1H3(163),G1H3(164),G1H3(165),G1H3(166),3)
  call HG1shiftOLR(G1H3(162),8,3)
  call Hotf_4pt_reduction(G2H3(58),RedSet_4(7),mass4set(:,9),  & 
G1H3(167),G1H3(168),G1H3(169),G1H3(170),G1H3(171),3)
  call HG1shiftOLR(G1H3(168),12,3)
  call Hotf_5pt_reduction(G2H3(59),RedSet_5(8),mass5set(:,14),  & 
G1H3(172),G1H3(173),G1H3(174),G1H3(175),G1H3(176),G1H3(177),3)
  call HG1shiftOLR(G1H3(173),8,3)
  call Hotf_4pt_reduction(G2H3(61),RedSet_4(7),mass4set(:,10),  & 
G1H3(178),G1H3(179),G1H3(180),G1H3(181),G1H3(182),3)
  call HG1shiftOLR(G1H3(179),12,3)
  call Hotf_5pt_reduction(G2H3(62),RedSet_5(8),mass5set(:,15),  & 
G1H3(183),G1H3(184),G1H3(185),G1H3(186),G1H3(187),G1H3(188),3)
  call HG1shiftOLR(G1H3(184),8,3)
  call Hotf_4pt_reduction(G2H3(64),RedSet_4(7),mass4set(:,11),  & 
G1H3(189),G1H3(190),G1H3(191),G1H3(192),G1H3(193),3)
  call HG1shiftOLR(G1H3(190),12,3)
  call Hotf_5pt_reduction(G2H3(65),RedSet_5(1),mass5set(:,12),  & 
G1H3(194),G1H3(195),G1H3(196),G1H3(197),G1H3(198),G1H3(199),3)
  call HG1shiftOLR(G1H3(195),8,3)
  call Hotf_4pt_reduction(G2H3(67),RedSet_4(4),mass4set(:,8),  & 
G1H3(200),G1H3(201),G1H3(202),G1H3(203),G1H3(204),3)
  call HG1shiftOLR(G1H3(201),9,3)
  call Hotf_5pt_reduction(G2H3(68),RedSet_5(1),mass5set(:,16),  & 
G1H3(205),G1H3(206),G1H3(207),G1H3(208),G1H3(209),G1H3(210),3)
  call HG1shiftOLR(G1H3(206),8,3)
  call Hotf_4pt_reduction(G2H3(70),RedSet_4(4),mass4set(:,12),  & 
G1H3(211),G1H3(212),G1H3(213),G1H3(214),G1H3(215),3)
  call HG1shiftOLR(G1H3(212),9,3)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(9),mass5set(:,12),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(42),4,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(7),mass4set(:,8),  & 
G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),2)
  call HG1shiftOLR(G1H2(48),12,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(9),mass5set(:,13),  & 
G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),2)
  call HG1shiftOLR(G1H2(53),4,2)
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(7),mass4set(:,9),  & 
G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(59),12,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(9),mass5set(:,9),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),4,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(7),mass4set(:,1),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),2)
  call HG1shiftOLR(G1H2(70),12,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(9),mass5set(:,10),  & 
G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),2)
  call HG1shiftOLR(G1H2(75),4,2)
  call Hotf_4pt_reduction(G2H2(43),RedSet_4(7),mass4set(:,2),  & 
G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(81),12,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(9),mass5set(:,17),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),4,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(7),mass4set(:,13),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),2)
  call HG1shiftOLR(G1H2(92),12,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(9),mass5set(:,18),  & 
G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),2)
  call HG1shiftOLR(G1H2(97),4,2)
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(7),mass4set(:,14),  & 
G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(103),12,2)
  call Hotf_5pt_reduction(G2H3(77),RedSet_5(10),mass5set(:,19),  & 
G1H3(216),G1H3(217),G1H3(218),G1H3(219),G1H3(220),G1H3(221),3)
  call HG1shiftOLR(G1H3(217),8,3)
  call Hotf_4pt_reduction(G2H3(79),RedSet_4(8),mass4set(:,15),  & 
G1H3(222),G1H3(223),G1H3(224),G1H3(225),G1H3(226),3)
  call HG1shiftOLR(G1H3(223),12,3)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(11),mass5set(:,19),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),G1H2(112),2)
  call HG1shiftOLR(G1H2(108),4,2)
  call Hotf_4pt_reduction(G2H2(53),RedSet_4(8),mass4set(:,15),  & 
G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),2)
  call HG1shiftOLR(G1H2(114),12,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(11),mass5set(:,9),  & 
G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),G1H2(123),2)
  call HG1shiftOLR(G1H2(119),4,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(8),mass4set(:,1),  & 
G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(125),12,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(11),mass5set(:,17),  & 
G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),G1H2(134),2)
  call HG1shiftOLR(G1H2(130),4,2)
  call Hotf_4pt_reduction(G2H2(59),RedSet_4(8),mass4set(:,13),  & 
G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),2)
  call HG1shiftOLR(G1H2(136),12,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(11),mass5set(:,10),  & 
G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),2)
  call HG1shiftOLR(G1H2(141),4,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(8),mass4set(:,2),  & 
G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(147),12,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(11),mass5set(:,18),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),4,2)
  call Hotf_4pt_reduction(G2H2(65),RedSet_4(8),mass4set(:,14),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),2)
  call HG1shiftOLR(G1H2(158),12,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(12),mass5set(:,11),  & 
G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),2)
  call HG1shiftOLR(G1H2(163),4,2)
  call Hotf_4pt_reduction(G2H2(69),RedSet_4(9),mass4set(:,7),  & 
G1H2(168),G1H2(169),G1H2(170),G1H2(171),G1H2(172),2)
  call HG1shiftOLR(G1H2(169),5,2)
  call Hotf_5pt_reduction(G2H2(70),RedSet_5(12),mass5set(:,20),  & 
G1H2(173),G1H2(174),G1H2(175),G1H2(176),G1H2(177),G1H2(178),2)
  call HG1shiftOLR(G1H2(174),4,2)
  call Hotf_4pt_reduction(G2H2(73),RedSet_4(9),mass4set(:,16),  & 
G1H2(179),G1H2(180),G1H2(181),G1H2(182),G1H2(183),2)
  call HG1shiftOLR(G1H2(180),5,2)
  call Hotf_5pt_reduction(G2H3(85),RedSet_5(3),mass5set(:,21),  & 
G1H3(227),G1H3(228),G1H3(229),G1H3(230),G1H3(231),G1H3(232),3)
  call HG1shiftOLR(G1H3(228),8,3)
  call Hotf_4pt_reduction(G2H3(87),RedSet_4(2),mass4set(:,17),  & 
G1H3(233),G1H3(234),G1H3(235),G1H3(236),G1H3(237),3)
  call HG1shiftOLR(G1H3(234),10,3)
  call Hotf_4pt_reduction(G2H2(77),RedSet_4(2),mass4set(:,17),  & 
G1H2(184),G1H2(185),G1H2(186),G1H2(187),G1H2(188),2)
  call HG1shiftOLR(G1H2(185),10,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(2),mass4set(:,17),  & 
G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(190),10,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(5),mass5set(:,19),  & 
G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),G1H2(199),2)
  call HG1shiftOLR(G1H2(195),4,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(3),mass4set(:,15),  & 
G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(201),6,2)
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(5),mass5set(:,23),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),4,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(3),mass4set(:,18),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),2)
  call HG1shiftOLR(G1H2(212),6,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(89),ex2(:),G2tensor(41),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(91),ex2(:),G2tensor(42),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(94),ex2(:),G2tensor(43),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(96),ex2(:),G2tensor(44),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(99),ex2(:),G2tensor(45),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(101),ex2(:),G2tensor(46),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(104),ex2(:),G2tensor(47),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(106),ex2(:),G2tensor(48),m3h2x1(:,34),heltab2x2(:,:,34))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(184),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(13),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(24),[G1H3(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(35),[G1H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(46),[G1H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(57),[G1H3(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(68),[G1H3(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(79),[G1H3(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(90),[G1H3(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(101),[G1H3(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(112),[G1H3(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(123),[G1H3(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(134),[G1H3(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(25),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(145),[G1H3(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(156),[G1H3(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(167),[G1H3(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(178),[G1H3(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(189),[G1H3(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(200),[G1H3(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(211),[G1H3(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(47),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(58),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(69),[G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(80),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(222),[G1H3(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(113),[G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(124),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(135),[G1H2(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(146),[G1H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(157),[G1H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(168),[G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(179),[G1H2(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(233),[G1H3(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(200),[G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(211),[G1H2(210)])
  call Hloop_VA_Q(ntryL,G1H2(17),ex2(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(9),ex2(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(50),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(184),ex2(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(3))
  call Hloop_ZA_Q(ntryL,G1H2(4),ex2(:),G1H1(1),ngZu,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(4))
  call Hloop_ZA_Q(ntryL,G1H2(5),ex2(:),G1H1(1),ngZu,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(53),n2h1(5))
  call Hloop_ZA_Q(ntryL,G1H2(189),ex2(:),G1H1(1),ngZu,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(54),n2h1(6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(1),23,ex4(:),8,G2tensor(55),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(8),0,ex4(:),8,G2tensor(56),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(13),23,ex4(:),8,G2tensor(57),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(14),1,ex4(:),8,G2tensor(58),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(18),23,ex4(:),8,G2tensor(59),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(19),0,ex4(:),8,G2tensor(60),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(24),23,ex4(:),8,G2tensor(61),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(25),1,ex4(:),8,G2tensor(62),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(29),23,ex4(:),8,G2tensor(63),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(30),0,ex4(:),8,G2tensor(64),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(35),23,ex4(:),8,G2tensor(65),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(36),1,ex4(:),8,G2tensor(66),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(40),23,ex4(:),8,G2tensor(67),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(41),0,ex4(:),8,G2tensor(68),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(46),23,ex4(:),8,G2tensor(69),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(47),1,ex4(:),8,G2tensor(70),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(51),23,ex4(:),8,G2tensor(71),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(52),0,ex4(:),8,G2tensor(72),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(57),23,ex4(:),8,G2tensor(73),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(58),1,ex4(:),8,G2tensor(74),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(62),23,ex4(:),8,G2tensor(75),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(63),0,ex4(:),8,G2tensor(76),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(68),23,ex4(:),8,G2tensor(77),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(69),1,ex4(:),8,G2tensor(78),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(73),23,ex4(:),8,G2tensor(79),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(74),0,ex4(:),8,G2tensor(80),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(79),23,ex4(:),8,G2tensor(81),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(80),1,ex4(:),8,G2tensor(82),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(84),23,ex4(:),8,G2tensor(83),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(85),0,ex4(:),8,G2tensor(84),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(90),23,ex4(:),8,G2tensor(85),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(91),1,ex4(:),8,G2tensor(86),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(95),23,ex4(:),8,G2tensor(87),m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(96),0,ex4(:),8,G2tensor(88),m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(101),23,ex4(:),8,G2tensor(89),m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(102),2,ex4(:),8,G2tensor(90),m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(106),23,ex4(:),8,G2tensor(91),m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(107),0,ex4(:),8,G2tensor(92),m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(112),23,ex4(:),8,G2tensor(93),m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(113),2,ex4(:),8,G2tensor(94),m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(117),23,ex4(:),8,G2tensor(95),m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(118),0,ex4(:),8,G2tensor(96),m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(123),23,ex4(:),8,G2tensor(97),m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(124),2,ex4(:),8,G2tensor(98),m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(128),23,ex4(:),8,G2tensor(99),m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(129),0,ex4(:),8,G2tensor(100),m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(134),23,ex4(:),8,G2tensor(101),m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(135),2,ex4(:),8,G2tensor(102),m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(19),27,ex3(:),4,G2tensor(103),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(20),0,ex3(:),4,G2tensor(104),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(25),27,ex3(:),4,G2tensor(105),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(26),2,ex3(:),4,G2tensor(106),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(30),27,ex3(:),4,G2tensor(107),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(31),0,ex3(:),4,G2tensor(108),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(36),27,ex3(:),4,G2tensor(109),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(37),2,ex3(:),4,G2tensor(110),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hloop_AW_Q(ntryL,G1H3(139),ex4(:),G1H1(1),m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(111),n2h1(35))
  call Hloop_AW_Q(ntryL,G1H3(140),ex4(:),G1H1(1),m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(112),n2h1(36))
  call Hloop_AW_Q(ntryL,G1H3(145),ex4(:),G1H1(1),m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(113),n2h1(37))
  call Hloop_AW_Q(ntryL,G1H3(146),ex4(:),G1H1(1),m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(114),n2h1(38))
  call Hloop_QW_A(ntryL,G1H3(150),ex4(:),G1H1(1),m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(115),n2h1(39))
  call Hloop_QW_A(ntryL,G1H3(151),ex4(:),G1H1(1),m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(116),n2h1(40))
  call Hloop_QW_A(ntryL,G1H3(156),ex4(:),G1H1(1),m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(117),n2h1(41))
  call Hloop_QW_A(ntryL,G1H3(157),ex4(:),G1H1(1),m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(118),n2h1(42))
  call Hloop_QW_A(ntryL,G1H3(161),ex4(:),G1H1(1),m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(43))
  call Hloop_QW_A(ntryL,G1H3(162),ex4(:),G1H1(1),m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(120),n2h1(44))
  call Hloop_QW_A(ntryL,G1H3(167),ex4(:),G1H1(1),m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(121),n2h1(45))
  call Hloop_QW_A(ntryL,G1H3(168),ex4(:),G1H1(1),m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(122),n2h1(46))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(172),23,ex4(:),8,G2tensor(123),m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(173),0,ex4(:),8,G2tensor(124),m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(178),23,ex4(:),8,G2tensor(125),m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(179),4,ex4(:),8,G2tensor(126),m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(183),23,ex4(:),8,G2tensor(127),m3h3x1(:,79),heltab2x3(:,:,79))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(184),0,ex4(:),8,G2tensor(128),m3h3x1(:,80),heltab2x3(:,:,80))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(189),23,ex4(:),8,G2tensor(129),m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(190),4,ex4(:),8,G2tensor(130),m3h3x1(:,82),heltab2x3(:,:,82))
  call Hloop_QW_A(ntryL,G1H3(194),ex4(:),G1H1(1),m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(51))
  call Hloop_QW_A(ntryL,G1H3(195),ex4(:),G1H1(1),m3h3x1(:,84),heltab2x3(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(132),n2h1(52))
  call Hloop_QW_A(ntryL,G1H3(200),ex4(:),G1H1(1),m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(133),n2h1(53))
  call Hloop_QW_A(ntryL,G1H3(201),ex4(:),G1H1(1),m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(134),n2h1(54))
  call Hloop_QW_A(ntryL,G1H3(205),ex4(:),G1H1(1),m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(135),n2h1(55))
  call Hloop_QW_A(ntryL,G1H3(206),ex4(:),G1H1(1),m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(136),n2h1(56))
  call Hloop_QW_A(ntryL,G1H3(211),ex4(:),G1H1(1),m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(137),n2h1(57))
  call Hloop_QW_A(ntryL,G1H3(212),ex4(:),G1H1(1),m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(138),n2h1(58))
  call Hloop_QV_A(ntryL,G1H2(41),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(139),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(42),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(140),n2h1(60))
  call Hloop_QV_A(ntryL,G1H2(47),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(141),n2h1(61))
  call Hloop_QV_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(142),n2h1(62))
  call Hloop_QV_A(ntryL,G1H2(52),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(143),n2h1(63))
  call Hloop_QV_A(ntryL,G1H2(53),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(144),n2h1(64))
  call Hloop_QV_A(ntryL,G1H2(58),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(145),n2h1(65))
  call Hloop_QV_A(ntryL,G1H2(59),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(146),n2h1(66))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(63),27,ex3(:),4,G2tensor(147),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(64),0,ex3(:),4,G2tensor(148),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(69),27,ex3(:),4,G2tensor(149),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(70),8,ex3(:),4,G2tensor(150),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(74),27,ex3(:),4,G2tensor(151),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(75),0,ex3(:),4,G2tensor(152),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(80),27,ex3(:),4,G2tensor(153),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(81),8,ex3(:),4,G2tensor(154),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(85),27,ex3(:),4,G2tensor(155),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(86),0,ex3(:),4,G2tensor(156),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(91),27,ex3(:),4,G2tensor(157),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(92),8,ex3(:),4,G2tensor(158),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(96),27,ex3(:),4,G2tensor(159),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(97),0,ex3(:),4,G2tensor(160),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(102),27,ex3(:),4,G2tensor(161),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(103),8,ex3(:),4,G2tensor(162),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hloop_AW_Q(ntryL,G1H3(216),ex4(:),G1H1(1),m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(163),n2h1(75))
  call Hloop_AW_Q(ntryL,G1H3(217),ex4(:),G1H1(1),m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(164),n2h1(76))
  call Hloop_AW_Q(ntryL,G1H3(222),ex4(:),G1H1(1),m3h3x1(:,93),heltab2x3(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(165),n2h1(77))
  call Hloop_AW_Q(ntryL,G1H3(223),ex4(:),G1H1(1),m3h3x1(:,94),heltab2x3(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(166),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(107),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(167),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(108),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(168),n2h1(80))
  call Hloop_AV_Q(ntryL,G1H2(113),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(169),n2h1(81))
  call Hloop_AV_Q(ntryL,G1H2(114),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(170),n2h1(82))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(118),27,ex3(:),4,G2tensor(171),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(119),0,ex3(:),4,G2tensor(172),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(124),27,ex3(:),4,G2tensor(173),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(125),8,ex3(:),4,G2tensor(174),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(129),27,ex3(:),4,G2tensor(175),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(130),0,ex3(:),4,G2tensor(176),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(135),27,ex3(:),4,G2tensor(177),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(136),8,ex3(:),4,G2tensor(178),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(140),27,ex3(:),4,G2tensor(179),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(141),0,ex3(:),4,G2tensor(180),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(146),27,ex3(:),4,G2tensor(181),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(147),8,ex3(:),4,G2tensor(182),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(151),27,ex3(:),4,G2tensor(183),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(152),0,ex3(:),4,G2tensor(184),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(157),27,ex3(:),4,G2tensor(185),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(158),8,ex3(:),4,G2tensor(186),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hloop_QV_A(ntryL,G1H2(162),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(187),n2h1(91))
  call Hloop_QV_A(ntryL,G1H2(163),ex3(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(188),n2h1(92))
  call Hloop_QV_A(ntryL,G1H2(168),ex3(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(189),n2h1(93))
  call Hloop_QV_A(ntryL,G1H2(169),ex3(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(190),n2h1(94))
  call Hloop_QV_A(ntryL,G1H2(173),ex3(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(191),n2h1(95))
  call Hloop_QV_A(ntryL,G1H2(174),ex3(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(192),n2h1(96))
  call Hloop_QV_A(ntryL,G1H2(179),ex3(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(193),n2h1(97))
  call Hloop_QV_A(ntryL,G1H2(180),ex3(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(194),n2h1(98))
  call Hloop_AW_Q(ntryL,G1H3(227),ex4(:),G1H1(1),m3h3x1(:,95),heltab2x3(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(195),n2h1(99))
  call Hloop_AW_Q(ntryL,G1H3(228),ex4(:),G1H1(1),m3h3x1(:,96),heltab2x3(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(196),n2h1(100))
  call Hloop_AW_Q(ntryL,G1H3(233),ex4(:),G1H1(1),m3h3x1(:,97),heltab2x3(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(197),n2h1(101))
  call Hloop_AW_Q(ntryL,G1H3(234),ex4(:),G1H1(1),m3h3x1(:,98),heltab2x3(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(198),n2h1(102))
  call Hloop_VA_Q(ntryL,G1H2(185),ex2(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(199),n2h1(103))
  call Hloop_ZA_Q(ntryL,G1H2(190),ex2(:),G1H1(1),ngZu,m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(200),n2h1(104))
  call Hloop_AV_Q(ntryL,G1H2(194),ex3(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(201),n2h1(105))
  call Hloop_AV_Q(ntryL,G1H2(195),ex3(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(202),n2h1(106))
  call Hloop_AV_Q(ntryL,G1H2(200),ex3(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(203),n2h1(107))
  call Hloop_AV_Q(ntryL,G1H2(201),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(204),n2h1(108))
  call Hloop_AV_Q(ntryL,G1H2(205),ex3(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(205),n2h1(109))
  call Hloop_AV_Q(ntryL,G1H2(206),ex3(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(206),n2h1(110))
  call Hloop_AV_Q(ntryL,G1H2(211),ex3(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(207),n2h1(111))
  call Hloop_AV_Q(ntryL,G1H2(212),ex3(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(208),n2h1(112))
  call ol_merge_tensors(G2tensor(4),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(2)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(147),[G2tensor(14),G2tensor(10),G2tensor(6)])
  call ol_merge_tensors(G2tensor(151),[G2tensor(15),G2tensor(11),G2tensor(7)])
  call ol_merge_tensors(G2tensor(155),[G2tensor(16),G2tensor(12),G2tensor(8)])
  call ol_merge_tensors(G2tensor(159),[G2tensor(17),G2tensor(13),G2tensor(9)])
  call ol_merge_tensors(G2tensor(171),[G2tensor(26),G2tensor(22),G2tensor(18)])
  call ol_merge_tensors(G2tensor(175),[G2tensor(27),G2tensor(23),G2tensor(19)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(28),G2tensor(24),G2tensor(20)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(29),G2tensor(25),G2tensor(21)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(30)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(31)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(32)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(33)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(35)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(36)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(37)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(38)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(39)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(40)])
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(8),mass5set(:,24),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(8),mass5set(:,14),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(8),mass5set(:,15),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,25),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(147),RedSet_5(9),mass5set(:,9),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),4)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(9),mass5set(:,10),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(155),RedSet_5(9),mass5set(:,17),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),4)
  call Hotf_5pt_reduction_last(G2tensor(159),RedSet_5(9),mass5set(:,18),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(171),RedSet_5(11),mass5set(:,9),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),4)
  call Hotf_5pt_reduction_last(G2tensor(175),RedSet_5(11),mass5set(:,17),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(179),RedSet_5(11),mass5set(:,10),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_5pt_reduction_last(G2tensor(183),RedSet_5(11),mass5set(:,18),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(2),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(2),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(2),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(2),mass5set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(2),mass5set(:,26),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(3),mass5set(:,3),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(3),mass5set(:,5),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(3),mass5set(:,4),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(3),mass5set(:,6),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(5),mass5set(:,9),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(5),mass5set(:,10),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(4),mass5set(:,3),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),2)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(4),mass5set(:,4),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),2)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(6),mass5set(:,3),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),2)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(6),mass5set(:,4),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),2)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(4),mass5set(:,21),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),2)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(4),mass5set(:,22),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),2)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(1),mass5set(:,1),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(1),mass5set(:,2),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(2),mass5set(:,7),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(2),mass5set(:,8),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(7),mass5set(:,11),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(8),mass5set(:,12),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),8)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(8),mass5set(:,13),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(1),mass5set(:,12),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),8)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(1),mass5set(:,16),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),8)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(9),mass5set(:,12),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),4)
  call Hotf_5pt_reduction_last(G2tensor(143),RedSet_5(9),mass5set(:,13),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),4)
  call Hotf_5pt_reduction_last(G2tensor(163),RedSet_5(10),mass5set(:,19),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_5pt_reduction_last(G2tensor(167),RedSet_5(11),mass5set(:,19),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_5pt_reduction_last(G2tensor(187),RedSet_5(12),mass5set(:,11),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),4)
  call Hotf_5pt_reduction_last(G2tensor(191),RedSet_5(12),mass5set(:,20),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),4)
  call Hotf_5pt_reduction_last(G2tensor(195),RedSet_5(3),mass5set(:,21),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),8)
  call Hotf_5pt_reduction_last(G2tensor(201),RedSet_5(5),mass5set(:,19),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),4)
  call Hotf_5pt_reduction_last(G2tensor(205),RedSet_5(5),mass5set(:,23),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  call ol_merge_tensors(T1sum(43),[G1tensor(253)])
  call ol_merge_tensors(T1sum(44),[G1tensor(259)])
  call ol_merge_tensors(T1sum(45),[G1tensor(265)])
  call ol_merge_tensors(T1sum(46),[G1tensor(271)])
  call ol_merge_tensors(T1sum(47),[G1tensor(277)])
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(93),h0tab(:,93),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex5(:),ex4(:),G0H8(1),m4h3x3x8(:,1),heltab3x72(:,:,1))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(94),h0tab(:,94),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex4(:),ex5(:),G0H8(2),m4h3x3x8(:,2),heltab3x72(:,:,2))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(95),h0tab(:,95),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_VWW_V(ntryL,G0H72(1),ex5(:),ex4(:),G0H8(3),m4h3x3x8(:,3),heltab3x72(:,:,3))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(96),h0tab(:,96),[24,1,4,2],[0,0,0,nMZ],5,0)
  call Hloop_VWW_V(ntryL,G0H72(1),ex5(:),ex4(:),G0H8(4),m4h3x3x8(:,4),heltab3x72(:,:,4))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(97),h0tab(:,97),[24,1,4,2],[nMZ,0,0,0],5,0)
  call Hloop_VWW_V(ntryL,G0H72(1),ex5(:),ex4(:),G0H8(5),m4h3x3x8(:,5),heltab3x72(:,:,5))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(98),h0tab(:,98),[24,1,4,2],[nMZ,0,0,nMZ],5,0)
  call Hloop_VWW_V(ntryL,G0H72(1),ex5(:),ex4(:),G0H8(6),m4h3x3x8(:,6),heltab3x72(:,:,6))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(99),h0tab(:,99),[24,1,4,2],[nMW,0,0,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex4(:),ex5(:),G0H8(7),m4h3x3x8(:,7),heltab3x72(:,:,7))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(100),h0tab(:,100),[20,2,1,8],[0,0,0,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(3),m4h3x2x12(:,1),heltab3x72(:,:,8))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(101),h0tab(:,101),[20,2,1,8],[nMZ,0,0,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(1),m4h3x2x12(:,2),heltab3x72(:,:,9))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(102),h0tab(:,102),[20,2,1,8],[0,0,nMZ,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(2),m4h3x2x12(:,3),heltab3x72(:,:,10))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(103),h0tab(:,103),[20,2,1,8],[nMZ,0,nMZ,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(4),m4h3x2x12(:,4),heltab3x72(:,:,11))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(104),h0tab(:,104),[20,2,1,8],[nMW,0,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex3(:),ex5(:),G0H12(5),m4h2x3x12(:,1),heltab3x72(:,:,12))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(105),h0tab(:,105),[20,2,1,8],[nMW,0,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex3(:),ex5(:),G0H12(6),m4h2x3x12(:,2),heltab3x72(:,:,13))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(106),h0tab(:,106),[20,1,2,8],[0,0,0,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(7),m4h3x2x12(:,5),heltab3x72(:,:,14))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(107),h0tab(:,107),[20,1,2,8],[0,0,nMZ,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(8),m4h3x2x12(:,6),heltab3x72(:,:,15))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(108),h0tab(:,108),[20,1,2,8],[nMZ,0,0,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(9),m4h3x2x12(:,7),heltab3x72(:,:,16))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(109),h0tab(:,109),[20,1,2,8],[nMZ,0,nMZ,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(10),m4h3x2x12(:,8),heltab3x72(:,:,17))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(110),h0tab(:,110),[20,1,8,2],[0,0,0,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(11),m4h3x2x12(:,9),heltab3x72(:,:,18))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(111),h0tab(:,111),[20,1,8,2],[nMZ,0,0,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(12),m4h3x2x12(:,10),heltab3x72(:,:,19))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(112),h0tab(:,112),[16,1,2,12],[0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(2),m3h3x24(:,93),heltab2x72(:,:,93))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(113),h0tab(:,113),[16,1,2,12],[0,0,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(9),m3h3x24(:,94),heltab2x72(:,:,94))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(114),h0tab(:,114),[16,1,2,12],[nMZ,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(15),m3h3x24(:,95),heltab2x72(:,:,95))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(115),h0tab(:,115),[16,1,2,12],[nMZ,0,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(1),m3h3x24(:,96),heltab2x72(:,:,96))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(116),h0tab(:,116),[16,2,1,12],[0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(4),m3h3x24(:,97),heltab2x72(:,:,97))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(117),h0tab(:,117),[16,2,1,12],[nMZ,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(3),m3h3x24(:,98),heltab2x72(:,:,98))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(118),h0tab(:,118),[16,2,1,12],[0,0,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(5),m3h3x24(:,99),heltab2x72(:,:,99))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(119),h0tab(:,119),[16,2,1,12],[nMZ,0,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(6),m3h3x24(:,100),heltab2x72(:,:,100))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(120),h0tab(:,120),[16,2,1,12],[nMW,0,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(7),m3h3x24(:,101),heltab2x72(:,:,101))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(121),h0tab(:,121),[16,2,1,12],[nMW,0,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(8),m3h3x24(:,102),heltab2x72(:,:,102))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(122),h0tab(:,122),[16,1,12,2],[0,nMW,0,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,103),heltab2x72(:,:,103))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(11),n2h24(22))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(123),h0tab(:,123),[16,1,12,2],[0,nMW,nMZ,0],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(2),m3h3x24(:,104),heltab2x72(:,:,104))
  call Hloop_A_Q(ntryL,G0H24(2),16,0,G1H24(10),n2h24(23))
  Gcoeff(:)%j = (c(214)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(124),h0tab(:,124),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(3),m3h3x24(:,105),heltab2x72(:,:,105))
  call Hloop_A_Q(ntryL,G0H24(3),16,0,G1H24(12),n2h24(24))
  Gcoeff(:)%j = (c(212)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(125),h0tab(:,125),[16,3,8,4],[nMB,nMB,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(4),m3h3x24(:,106),heltab2x72(:,:,106))
  call Hloop_A_Q(ntryL,G0H24(4),16,nMB,G1H24(13),n2h24(25))
  Gcoeff(:)%j = (c(214)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(126),h0tab(:,126),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(5),m3h3x24(:,107),heltab2x72(:,:,107))
  call Hloop_Q_A(ntryL,G0H24(5),16,0,G1H24(14),n2h24(26))
  Gcoeff(:)%j = (c(212)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(127),h0tab(:,127),[16,3,8,4],[nMT,nMT,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(6),m3h3x24(:,108),heltab2x72(:,:,108))
  call Hloop_Q_A(ntryL,G0H24(6),16,nMT,G1H24(17),n2h24(27))
  Gcoeff(:)%j = (c(222)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(128),h0tab(:,128),[16,3,8,4],[0,0,nME,nME],4,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(7),m3h3x24(:,109),heltab2x72(:,:,109))
  call Hloop_Q_A(ntryL,G0H24(7),16,0,G1H24(16),n2h24(28))
  Gcoeff(:)%j = (c(222)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(129),h0tab(:,129),[16,3,8,4],[0,0,nMM,nMM],4,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(8),m3h3x24(:,110),heltab2x72(:,:,110))
  call Hloop_Q_A(ntryL,G0H24(8),16,0,G1H24(18),n2h24(29))
  Gcoeff(:)%j = (c(222)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(130),h0tab(:,130),[16,3,8,4],[0,0,nML,nML],4,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(9),m3h3x24(:,111),heltab2x72(:,:,111))
  call Hloop_Q_A(ntryL,G0H24(9),16,0,G1H24(19),n2h24(30))
  Gcoeff(:)%j = (-(c(224)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(131),h0tab(:,131),[16,3,8,4],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(10),m3h3x24(:,112),heltab2x72(:,:,112))
  call Hloop_A_Q(ntryL,G0H24(10),16,0,G1H24(20),n2h24(31))
  Gcoeff(:)%j = (-(c(220)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(132),h0tab(:,132),[16,3,8,4],[nMB,nMB,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(11),m3h3x24(:,113),heltab2x72(:,:,113))
  call Hloop_A_Q(ntryL,G0H24(11),16,nMB,G1H24(21),n2h24(32))
  Gcoeff(:)%j = (c(220)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(133),h0tab(:,133),[16,3,8,4],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(12),m3h3x24(:,114),heltab2x72(:,:,114))
  call Hloop_Q_A(ntryL,G0H24(12),16,0,G1H24(22),n2h24(33))
  Gcoeff(:)%j = (c(215)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(134),h0tab(:,134),[16,3,8,4],[nMT,nMT,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,115),heltab2x72(:,:,115))
  call Hloop_Q_A(ntryL,G0H24(13),16,nMT,G1H24(23),n2h24(34))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(135),h0tab(:,135),[16,3,8,4],[nMZ,nMH,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(24),m3h3x24(:,116),heltab2x72(:,:,116))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(136),h0tab(:,136),[16,3,8,4],[nMH,nMZ,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(25),m3h3x24(:,117),heltab2x72(:,:,117))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(137),h0tab(:,137),[16,3,8,4],[nMZ,nMH,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(14),m3h3x24(:,118),heltab2x72(:,:,118))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(138),h0tab(:,138),[16,3,8,4],[nMH,nMZ,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(26),m3h3x24(:,119),heltab2x72(:,:,119))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(139),h0tab(:,139),[16,3,8,4],[nMH,nMZ,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(15),m3h3x24(:,120),heltab2x72(:,:,120))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(140),h0tab(:,140),[16,3,8,4],[nMZ,nMH,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(27),m3h3x24(:,121),heltab2x72(:,:,121))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(141),h0tab(:,141),[16,3,8,4],[nMZ,nMH,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(28),m3h3x24(:,122),heltab2x72(:,:,122))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(142),h0tab(:,142),[16,3,8,4],[nMH,nMZ,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(16),m3h3x24(:,123),heltab2x72(:,:,123))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(143),h0tab(:,143),[16,3,8,4],[nMZ,nMH,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(17),m3h3x24(:,124),heltab2x72(:,:,124))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(144),h0tab(:,144),[16,3,8,4],[nMH,nMZ,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(29),m3h3x24(:,125),heltab2x72(:,:,125))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(145),h0tab(:,145),[16,3,8,4],[nMZ,nMH,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(30),m3h3x24(:,126),heltab2x72(:,:,126))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(146),h0tab(:,146),[16,3,8,4],[nMH,nMZ,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(18),m3h3x24(:,127),heltab2x72(:,:,127))
  Gcoeff(:)%j = (-(c(219)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(147),h0tab(:,147),[16,3,4,8],[nME,nME,nME,0],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(19),m3h3x24(:,128),heltab2x72(:,:,128))
  call Hloop_A_Q(ntryL,G0H24(19),16,nME,G1H24(31),n2h24(35))
  Gcoeff(:)%j = (-(c(219)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(148),h0tab(:,148),[16,3,4,8],[nMM,nMM,nMM,0],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(20),m3h3x24(:,129),heltab2x72(:,:,129))
  call Hloop_A_Q(ntryL,G0H24(20),16,nMM,G1H24(32),n2h24(36))
  Gcoeff(:)%j = (-(c(219)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(149),h0tab(:,149),[16,3,4,8],[nML,nML,nML,0],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(21),m3h3x24(:,130),heltab2x72(:,:,130))
  call Hloop_A_Q(ntryL,G0H24(21),16,nML,G1H24(33),n2h24(37))
  Gcoeff(:)%j = (-(c(218)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(150),h0tab(:,150),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(22),m3h3x24(:,131),heltab2x72(:,:,131))
  call Hloop_Q_A(ntryL,G0H24(22),16,0,G1H24(34),n2h24(38))
  Gcoeff(:)%j = (-(c(214)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(151),h0tab(:,151),[16,3,4,8],[nMT,nMT,nMT,nMB],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(23),m3h3x24(:,132),heltab2x72(:,:,132))
  call Hloop_Q_A(ntryL,G0H24(23),16,nMT,G1H24(35),n2h24(39))
  Gcoeff(:)%j = (-(c(212)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(152),h0tab(:,152),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(24),m3h3x24(:,133),heltab2x72(:,:,133))
  call Hloop_A_Q(ntryL,G0H24(24),16,0,G1H24(36),n2h24(40))
  Gcoeff(:)%j = (-(c(211)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(153),h0tab(:,153),[16,3,4,8],[nMB,nMB,nMB,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(25),m3h3x24(:,134),heltab2x72(:,:,134))
  call Hloop_A_Q(ntryL,G0H24(25),16,nMB,G1H24(37),n2h24(41))
  Gcoeff(:)%j = (c(222)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(154),h0tab(:,154),[16,3,4,8],[nME,nME,nME,0],4,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(26),m3h3x24(:,135),heltab2x72(:,:,135))
  call Hloop_A_Q(ntryL,G0H24(26),16,nME,G1H24(38),n2h24(42))
  Gcoeff(:)%j = (c(222)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(155),h0tab(:,155),[16,3,4,8],[nMM,nMM,nMM,0],4,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(27),m3h3x24(:,136),heltab2x72(:,:,136))
  call Hloop_A_Q(ntryL,G0H24(27),16,nMM,G1H24(39),n2h24(43))
  Gcoeff(:)%j = (c(222)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(156),h0tab(:,156),[16,3,4,8],[nML,nML,nML,0],4,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(28),m3h3x24(:,137),heltab2x72(:,:,137))
  call Hloop_A_Q(ntryL,G0H24(28),16,nML,G1H24(40),n2h24(44))
  Gcoeff(:)%j = (-(c(224)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(157),h0tab(:,157),[16,3,4,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(29),m3h3x24(:,138),heltab2x72(:,:,138))
  call Hloop_Q_A(ntryL,G0H24(29),16,0,G1H24(41),n2h24(45))
  Gcoeff(:)%j = (-(c(220)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(158),h0tab(:,158),[16,3,4,8],[nMT,nMT,nMT,nMB],4,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(30),m3h3x24(:,139),heltab2x72(:,:,139))
  call Hloop_Q_A(ntryL,G0H24(30),16,nMT,G1H24(42),n2h24(46))
  Gcoeff(:)%j = (c(220)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(159),h0tab(:,159),[16,3,4,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(31),m3h3x24(:,140),heltab2x72(:,:,140))
  call Hloop_A_Q(ntryL,G0H24(31),16,0,G1H24(43),n2h24(47))
  Gcoeff(:)%j = (c(215)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(160),h0tab(:,160),[16,3,4,8],[nMB,nMB,nMB,nMT],4,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(32),m3h3x24(:,141),heltab2x72(:,:,141))
  call Hloop_A_Q(ntryL,G0H24(32),16,nMB,G1H24(44),n2h24(48))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(161),h0tab(:,161),[16,3,4,8],[nMW,nMW,nMW,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(45),m3h3x24(:,142),heltab2x72(:,:,142))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(162),h0tab(:,162),[16,3,4,8],[nMW,nMW,nMW,nMZ],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(46),m3h3x24(:,143),heltab2x72(:,:,143))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(163),h0tab(:,163),[16,3,4,8],[nMW,nMW,nMW,nMH],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(47),m3h3x24(:,144),heltab2x72(:,:,144))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(164),h0tab(:,164),[16,3,4,8],[nMW,nMW,nMW,nMZ],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(48),m3h3x24(:,145),heltab2x72(:,:,145))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(165),h0tab(:,165),[16,3,4,8],[nMW,nMW,nMW,0],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(49),m3h3x24(:,146),heltab2x72(:,:,146))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(166),h0tab(:,166),[16,3,4,8],[nMW,nMW,nMW,nMZ],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(50),m3h3x24(:,147),heltab2x72(:,:,147))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(167),h0tab(:,167),[16,3,4,8],[nMW,nMW,nMW,0],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(51),m3h3x24(:,148),heltab2x72(:,:,148))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(168),h0tab(:,168),[16,3,4,8],[nMW,nMW,nMW,nMZ],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(52),m3h3x24(:,149),heltab2x72(:,:,149))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(169),h0tab(:,169),[16,3,4,8],[nMW,nMW,nMW,0],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(53),m3h3x24(:,150),heltab2x72(:,:,150))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(170),h0tab(:,170),[16,3,4,8],[nMW,nMW,nMW,nMZ],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(54),m3h3x24(:,151),heltab2x72(:,:,151))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(171),h0tab(:,171),[16,3,4,8],[nMW,nMW,nMW,0],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(55),m3h3x24(:,152),heltab2x72(:,:,152))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(172),h0tab(:,172),[16,3,4,8],[nMW,nMW,nMW,nMZ],4,1,wf4(:,2))



end subroutine vamp_1

end module ol_vamp_1_ppvvv_ew_uuxawwx_1_/**/REALKIND
