
module ol_colourmatrix_ppvvv_ew_bbxzzz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,2), KL(17,2), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2( 1,:) = [ 0, 3]
  K2( 2,:) = [ 0, 0]
  K2( 3,:) = [ 0, 0]
  K2( 4,:) = [ 0, 0]
  K2( 5,:) = [ 0, 0]
  K2( 6,:) = [ 0, 0]
  K2( 7,:) = [ 0, 0]
  K2( 8,:) = [ 0, 0]
  K2( 9,:) = [ 0, 0]
  K2(10,:) = [ 0, 0]
  K2(11,:) = [ 0, 0]
  K2(12,:) = [ 0, 0]
  K2(13,:) = [ 0, 0]
  K2(14,:) = [ 0, 0]
  K2(15,:) = [ 0, 0]
  K2(16,:) = [ 0, 0]
  K2(17,:) = [ 0, 3]

  KL( 1,:) = [ 3, 0]
  KL( 2,:) = [ 0, 0]
  KL( 3,:) = [ 0, 0]
  KL( 4,:) = [ 0, 0]
  KL( 5,:) = [ 0, 0]
  KL( 6,:) = [ 0, 0]
  KL( 7,:) = [ 0, 0]
  KL( 8,:) = [ 0, 0]
  KL( 9,:) = [ 0, 0]
  KL(10,:) = [ 0, 0]
  KL(11,:) = [ 0, 0]
  KL(12,:) = [ 0, 0]
  KL(13,:) = [ 0, 0]
  KL(14,:) = [ 0, 0]
  KL(15,:) = [ 0, 0]
  KL(16,:) = [ 0, 0]
  KL(17,:) = [ 3, 0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvv_ew_bbxzzz_1_/**/REALKIND



module ol_forced_parameters_ppvvv_ew_bbxzzz_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvv_ew_bbxzzz_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppvvv_ew_bbxzzz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 108 ! number of helicity configurations
  integer(intkind2), save :: nhel = 108 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 108 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(108) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(145)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(3), ex4(3), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,14), wf6(6,48), wf9(9,9), wf12(12,81), wf18(18,60), wf27(27,7), wf108(108,179)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(330), c(305)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppvvv_ew_bbxzzz_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppvvv_ew_bbxzzz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppvvv_ew_bbxzzz_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = CI*eQED**3
    f(  2) = CI*countertermnorm*eQED**5
    f(  3) = (CI*countertermnorm*eQED**5*EWctR2AZZZ)/3._/**/REALKIND
    f(  4) = CI*countertermnorm*eQED**5*EWctR2ZZZZ
    f(  5) = CI*countertermnorm*eQED**3*gQCD**2
    f(  6) = CI*countertermnorm*ctVbb*eQED**3*gQCD**2
    f(  7) = (CI*eQED**3*MB)/(4._/**/REALKIND*cw**3*sw**3)
    f(  8) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*cw**3*sw**3)
    f(  9) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw**3*sw**3)
    f( 10) = (countertermnorm*eQED**5*MB*MW)/(cw**4*sw**3*2._/**/REALKIND)
    f( 11) = (CI*eQED**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 12) = (countertermnorm*eQED**5*MB)/(cw**3*sw**2*2._/**/REALKIND)
    f( 13) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 14) = (countertermnorm*eQED**5*EWctZXH*MB)/(cw**2*sw**2*2._/**/REALKIND)
    f( 15) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 16) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 17) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 18) = (CI*countertermnorm*eQED**5*EWctHZZ*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 19) = (countertermnorm*eQED**5*MW)/(cw**3*sw**2*6._/**/REALKIND)
    f( 20) = (countertermnorm*eQED**5*MW)/(cw**3*sw**2*2._/**/REALKIND)
    f( 21) = (CI*eQED**3*MW**2)/(cw**4*sw**2)
    f( 22) = (CI*countertermnorm*eQED**5*MW**2)/(3._/**/REALKIND*cw**4*sw**2)
    f( 23) = (CI*countertermnorm*eQED**5*MW**2)/(cw**4*sw**2)
    f( 24) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW**2)/(cw**4*sw**2)
    f( 25) = (CI*countertermnorm*eQED**5*MB)/(cw**2*sw)
    f( 26) = (CI*countertermnorm*eQED**5*EWctHZZ*MB)/(2._/**/REALKIND*MW*sw)
    f( 27) = (CI*countertermnorm*eQED**5*EWctHZA*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 28) = (CI*countertermnorm*eQED**5*EWctHZZ*MW)/(cw**2*sw)
    f( 29) = (eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 30) = eQED**5*integralnorm*SwB
    f( 31) = (eQED**5*integralnorm*SwB)/(cw**2*2._/**/REALKIND)
    f( 32) = eQED**3*gQCD**2*integralnorm*SwB
    f( 33) = (eQED**5*integralnorm*MB*SwB)/(cw**2*4._/**/REALKIND)
    f( 34) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*4._/**/REALKIND)
    f( 35) = (eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 36) = eQED**5*integralnorm*MW**2*SwB
    f( 37) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f( 38) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 39) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 40) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f( 41) = (eQED**5*integralnorm*MW**4*SwB)/cw**6
    f( 42) = (eQED**5*integralnorm*MW**4*SwB)/cw**4
    f( 43) = (eQED**5*integralnorm*SwB)/(cw**3*sw**5*8._/**/REALKIND)
    f( 44) = (eQED**5*integralnorm*SwB)/(cw*sw**5*4._/**/REALKIND)
    f( 45) = (cw**3*eQED**5*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f( 46) = (eQED**5*integralnorm*MB*SwB)/(cw**5*sw**5*16._/**/REALKIND)
    f( 47) = (eQED**5*integralnorm*MB*SwB)/(cw**5*sw**5*8._/**/REALKIND)
    f( 48) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**5*16._/**/REALKIND)
    f( 49) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**5*8._/**/REALKIND)
    f( 50) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**5*4._/**/REALKIND)
    f( 51) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**5*8._/**/REALKIND)
    f( 52) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**5*4._/**/REALKIND)
    f( 53) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**5*2._/**/REALKIND)
    f( 54) = (cw**3*eQED**5*integralnorm*MB*SwB)/(sw**5*4._/**/REALKIND)
    f( 55) = (cw**3*eQED**5*integralnorm*MB*SwB)/(sw**5*2._/**/REALKIND)
    f( 56) = (eQED**5*integralnorm*MB**2*SwB)/(cw**5*sw**5*8._/**/REALKIND)
    f( 57) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**5*sw**5*8._/**/REALKIND)
    f( 58) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**5*sw**5*8._/**/REALKIND)
    f( 59) = (eQED**5*integralnorm*MT*SwB)/(cw**3*sw**5*8._/**/REALKIND)
    f( 60) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**5*4._/**/REALKIND)
    f( 61) = (eQED**5*integralnorm*MB**2*SwB)/(cw**3*MW**2*sw**5*32._/**/REALKIND)
    f( 62) = (eQED**5*integralnorm*MB**2*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f( 63) = (eQED**5*integralnorm*MB**3*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f( 64) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**3*MW**2*sw**5*32._/**/REALKIND)
    f( 65) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f( 66) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**3*MW**2*sw**5*32._/**/REALKIND)
    f( 67) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f( 68) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f( 69) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**3*MW**2*sw**5*32._/**/REALKIND)
    f( 70) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f( 71) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f( 72) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw**3*MW**2*sw**5*32._/**/REALKIND)
    f( 73) = (eQED**5*integralnorm*MT*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND)
    f( 74) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**5*2._/**/REALKIND)
    f( 75) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**5*2._/**/REALKIND)
    f( 76) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**7*sw**5*16._/**/REALKIND)
    f( 77) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**7*sw**5*8._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**7*sw**5*4._/**/REALKIND)
    f( 79) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw**5*16._/**/REALKIND)
    f( 80) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw**5*4._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw**5*2._/**/REALKIND)
    f( 82) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw**5*8._/**/REALKIND)
    f( 83) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw**5*2._/**/REALKIND)
    f( 84) = (eQED**5*integralnorm*SwB)/(cw**4*sw**4*16._/**/REALKIND)
    f( 85) = (eQED**5*integralnorm*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f( 86) = (eQED**5*integralnorm*SwB)/(cw**4*sw**4*2._/**/REALKIND)
    f( 87) = (eQED**5*integralnorm*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f( 88) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 89) = (cw**4*eQED**5*integralnorm*SwB)/sw**4
    f( 90) = (eQED**5*integralnorm*MB*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f( 91) = (eQED**5*integralnorm*MB*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f( 92) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f( 93) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f( 94) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f( 95) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f( 96) = (eQED**5*integralnorm*MB**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f( 97) = (eQED**5*integralnorm*MH**2*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f( 98) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f( 99) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(100) = (eQED**5*integralnorm*MH**4*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f(101) = (eQED**5*integralnorm*MH**4*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(102) = (9*eQED**5*integralnorm*lambdaHHH**2*MH**4*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f(103) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(104) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f(105) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(106) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(107) = (eQED**5*integralnorm*MB**3*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(110) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(111) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(112) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(115) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(116) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f(118) = (eQED**5*integralnorm*MW**2*SwB)/sw**4
    f(119) = (eQED**5*integralnorm*MW**2*SwB)/(cw**6*sw**4*4._/**/REALKIND)
    f(120) = (eQED**5*integralnorm*MW**2*SwB)/(cw**6*sw**4*2._/**/REALKIND)
    f(121) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(122) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**4*2._/**/REALKIND)
    f(123) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**4)
    f(126) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*8._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*4._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*2._/**/REALKIND)
    f(129) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(130) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(131) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW**2*SwB)/(cw**6*sw**4*2._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*MW**4*SwB)/(cw**8*sw**4*4._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MW**4*SwB)/(cw**8*sw**4*2._/**/REALKIND)
    f(134) = (eQED**5*integralnorm*MW**4*SwB)/(cw**8*sw**4)
    f(135) = (eQED**5*integralnorm*MW**4*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(136) = (eQED**5*integralnorm*MW**4*SwB)/(cw**4*sw**4)
    f(137) = (eQED**5*integralnorm*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(138) = (cw*eQED**5*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(139) = (cw**3*eQED**5*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f(140) = (cw**3*eQED**5*integralnorm*SwB)/sw**3
    f(141) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**3*36._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**3*8._/**/REALKIND)
    f(143) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(145) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*4._/**/REALKIND)
    f(146) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(147) = (eQED**5*integralnorm*MH**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(148) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**3*sw**3*8._/**/REALKIND)
    f(149) = (eQED**5*integralnorm*MT*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(150) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MW**2*SwB)/(cw**5*sw**3*2._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*12._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(154) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*3._/**/REALKIND)
    f(155) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*2._/**/REALKIND)
    f(156) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*6._/**/REALKIND)
    f(157) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*3._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(159) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3)
    f(160) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**5*sw**3*4._/**/REALKIND)
    f(161) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(163) = (cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(164) = (eQED**5*integralnorm*MB*SwB)/(sw**2*4._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*18._/**/REALKIND)
    f(166) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(167) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(169) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(170) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**2*9._/**/REALKIND)
    f(172) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**2*4._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(174) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(176) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(177) = (eQED**3*gQCD**2*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(178) = (eQED**5*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(179) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw*8._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**3*sw*8._/**/REALKIND)
    f(182) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(183) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*6._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(186) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw*3._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw*4._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(190) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw**3*sw*6._/**/REALKIND)
    f(191) = (eQED**5*integralnorm*MW**4*SwB)/(cw**5*sw*3._/**/REALKIND)
    f(192) = (eQED**5*integralnorm*MW**4*SwB)/(cw**3*sw*3._/**/REALKIND)
    f(193) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw**3*2._/**/REALKIND)
    f(194) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*MW**2*sw*SwB)/cw
    f(196) = (eQED**5*integralnorm*MB*MW**2*sw*SwB)/(cw**3*4._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(198) = (eQED**5*integralnorm*MW**4*sw**3*SwB)/(cw**3*3._/**/REALKIND)
    f(199) = (eQED**5*integralnorm*MW**4*sw**4*SwB)/cw**4
    f(200) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**5*sw**5*4._/**/REALKIND))
    f(201) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**5*8._/**/REALKIND))
    f(202) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**5*16._/**/REALKIND))
    f(203) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**5*sw**5*8._/**/REALKIND))
    f(204) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(205) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(206) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND))
    f(207) = -((eQED**5*integralnorm*MB*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND))
    f(208) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(209) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(210) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(211) = -((eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**4*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(212) = -((eQED**5*integralnorm*MH**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(213) = -((eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(214) = -((eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW**2*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(215) = -((eQED**5*integralnorm*MB*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**2*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(216) = -((eQED**5*integralnorm*MB*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(217) = -((eQED**5*integralnorm*MW**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**6*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(218) = (eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw**2*4._/**/REALKIND)
    f(219) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(220) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*16._/**/REALKIND))
    f(221) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(222) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*12._/**/REALKIND))
    f(223) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*6._/**/REALKIND))
    f(224) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(225) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(226) = (eQED**5*integralnorm*MB*MH**2*SwB*(cw**4*16._/**/REALKIND + sw**4*16._/**/REALKIND  &
      - cw**2*sw**2*32._/**/REALKIND))/(cw**3*MW**2*sw**5*16._/**/REALKIND*32._/**/REALKIND)
    f(227) = (eQED**5*integralnorm*MB*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**3*MW**2*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(228) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**5*sw**3*6._/**/REALKIND))
    f(229) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*12._/**/REALKIND))
    f(230) = (eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**3*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(231) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**3*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(232) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(233) = -((eQED**5*integralnorm*MB*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**5*sw**5*16._/**/REALKIND))
    f(234) = -((eQED**5*integralnorm*MB*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**5*sw**5*8._/**/REALKIND))
    f(235) = (eQED**5*integralnorm*MB*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**3*sw**3*16._/**/REALKIND*8._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**3*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(237) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*8._/**/REALKIND))
    f(238) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*8._/**/REALKIND))
    f(239) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND))
    f(240) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(241) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW**2*sw**5*32._/**/REALKIND))
    f(242) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND))
    f(243) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(244) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(245) = -((eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**5*sw*4._/**/REALKIND))
    f(246) = -((eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(247) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**2*12._/**/REALKIND*6._/**/REALKIND)
    f(248) = (eQED**5*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*sw**2*3._/**/REALKIND*6._/**/REALKIND)
    f(249) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*6._/**/REALKIND))
    f(250) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*2._/**/REALKIND))
    f(251) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB*(-(cw**2*sw**2*24._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + cw**2*sw**2*8._/**/REALKIND + sw**4*8._/**/REALKIND))/(cw**3*sw**3*24._/**/REALKIND*8._/**/REALKIND))
    f(252) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*4._/**/REALKIND  &
      + cw**2*sw**2*4._/**/REALKIND + sw**4*4._/**/REALKIND))/(cw**3*sw**3*12._/**/REALKIND*4._/**/REALKIND))
    f(253) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(254) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB*(cw**4*2._/**/REALKIND + cw**2*sw**2*2._/**/REALKIND  &
      + sw**4*2._/**/REALKIND - cw**2*sw**2*6._/**/REALKIND))/(cw**3*sw**3*2._/**/REALKIND*6._/**/REALKIND))
    f(255) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(256) = (eQED**5*integralnorm*MW**2*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**3*sw*12._/**/REALKIND*6._/**/REALKIND)
    f(257) = (eQED**5*integralnorm*MW**2*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**3*sw*3._/**/REALKIND*6._/**/REALKIND)
    f(258) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*6._/**/REALKIND))
    f(259) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*3._/**/REALKIND))
    f(260) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(261) = (eQED**5*integralnorm*SwB*(3*cw**4*sw**4*16._/**/REALKIND*4._/**/REALKIND  &
      - cw**6*sw**2*16._/**/REALKIND*8._/**/REALKIND - cw**2*sw**6*16._/**/REALKIND*8._/**/REALKIND  &
      + cw**8*4._/**/REALKIND*8._/**/REALKIND  &
      + sw**8*4._/**/REALKIND*8._/**/REALKIND))/(cw**4*sw**4*16._/**/REALKIND*4._/**/REALKIND*8._/**/REALKIND)
    f(262) = (eQED**5*integralnorm*SwB*(cw**8*2._/**/REALKIND*4._/**/REALKIND + sw**8*2._/**/REALKIND*4._/**/REALKIND  &
      + 3*cw**4*sw**4*2._/**/REALKIND*8._/**/REALKIND - cw**6*sw**2*4._/**/REALKIND*8._/**/REALKIND  &
      - cw**2*sw**6*4._/**/REALKIND*8._/**/REALKIND))/(cw**4*sw**4*2._/**/REALKIND*4._/**/REALKIND*8._/**/REALKIND)
    f(263) = (eQED**5*integralnorm*SwB*(cw**8*2._/**/REALKIND + sw**8*2._/**/REALKIND + 3*cw**4*sw**4*4._/**/REALKIND  &
      - cw**6*sw**2*2._/**/REALKIND*4._/**/REALKIND  &
      - cw**2*sw**6*2._/**/REALKIND*4._/**/REALKIND))/(cw**4*sw**4*2._/**/REALKIND*4._/**/REALKIND)
    f(264) = (eQED**5*integralnorm*MW**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*2._/**/REALKIND*4._/**/REALKIND)
    f(265) = (eQED**5*integralnorm*MW**2*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**4*2._/**/REALKIND)
    f(266) = (eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(267) = (2*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(268) = (eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(269) = (4*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(270) = eQED**5*integralnorm*SwF
    f(271) = 2*eQED**5*integralnorm*SwF
    f(272) = 3*eQED**5*integralnorm*SwF
    f(273) = (eQED**5*integralnorm*MB**3*SwF)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(274) = (eQED**5*integralnorm*MB*ME**2*SwF)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(275) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(276) = (eQED**5*integralnorm*MB*MM**2*SwF)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(277) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(278) = (eQED**5*integralnorm*MB**2*SwF)/(cw**4*sw**4*4._/**/REALKIND)
    f(279) = (eQED**5*integralnorm*MB*ME*SwF)/(cw**4*sw**4*4._/**/REALKIND)
    f(280) = (eQED**5*integralnorm*ME**2*SwF)/(cw**4*sw**4*4._/**/REALKIND)
    f(281) = (eQED**5*integralnorm*MB*ML*SwF)/(cw**4*sw**4*4._/**/REALKIND)
    f(282) = (eQED**5*integralnorm*ML**2*SwF)/(cw**4*sw**4*4._/**/REALKIND)
    f(283) = (eQED**5*integralnorm*MB*MM*SwF)/(cw**4*sw**4*4._/**/REALKIND)
    f(284) = (eQED**5*integralnorm*MM**2*SwF)/(cw**4*sw**4*4._/**/REALKIND)
    f(285) = (eQED**5*integralnorm*MB*MT*SwF)/(cw**4*sw**4*4._/**/REALKIND)
    f(286) = (eQED**5*integralnorm*MT**2*SwF)/(cw**4*sw**4*4._/**/REALKIND)
    f(287) = (eQED**5*integralnorm*MB**3*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(288) = (eQED**5*integralnorm*MB*ME**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(289) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(290) = (eQED**5*integralnorm*MB*MM**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(291) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(292) = (eQED**5*integralnorm*MB*SwF)/(cw**3*sw**3*36._/**/REALKIND)
    f(293) = (eQED**5*integralnorm*MB*SwF)/(cw**3*sw**3*4._/**/REALKIND)
    f(294) = (eQED**5*integralnorm*ME*SwF)/(cw**3*sw**3*12._/**/REALKIND)
    f(295) = (eQED**5*integralnorm*ME*SwF)/(cw**3*sw**3*4._/**/REALKIND)
    f(296) = (eQED**5*integralnorm*ML*SwF)/(cw**3*sw**3*12._/**/REALKIND)
    f(297) = (eQED**5*integralnorm*ML*SwF)/(cw**3*sw**3*4._/**/REALKIND)
    f(298) = (eQED**5*integralnorm*MM*SwF)/(cw**3*sw**3*12._/**/REALKIND)
    f(299) = (eQED**5*integralnorm*MM*SwF)/(cw**3*sw**3*4._/**/REALKIND)
    f(300) = (eQED**5*integralnorm*MT*SwF)/(cw**3*sw**3*18._/**/REALKIND)
    f(301) = (eQED**5*integralnorm*MT*SwF)/(cw**3*sw**3*4._/**/REALKIND)
    f(302) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(303) = (eQED**5*integralnorm*MB*ME*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(304) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(305) = (eQED**5*integralnorm*MB*MM*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(306) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(307) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(308) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(309) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2)
    f(310) = (3*eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(311) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(312) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(313) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(314) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(315) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(316) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(317) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(318) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(319) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(320) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(321) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(322) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(323) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(324) = (eQED**5*integralnorm*MW**2*SwF)/(cw**4*sw**2*9._/**/REALKIND)
    f(325) = (2*eQED**5*integralnorm*MW**2*SwF)/(cw**4*sw**2*9._/**/REALKIND)
    f(326) = (eQED**5*integralnorm*MW**2*SwF)/(cw**4*sw**2*3._/**/REALKIND)
    f(327) = (4*eQED**5*integralnorm*MW**2*SwF)/(cw**4*sw**2*9._/**/REALKIND)
    f(328) = (eQED**5*integralnorm*MW**2*SwF)/(cw**4*sw**2)
    f(329) = (2*eQED**5*integralnorm*MW**2*SwF)/(cw**4*sw**2)
    f(330) = (3*eQED**5*integralnorm*MW**2*SwF)/(cw**4*sw**2)

  c = [ 3*f(29), 3*f(30), 3*f(31), 4*f(32), 3*f(33), 3*f(34), 3*f(35), 3*f(36), 3*f(37), 3*f(38), 3*f(39), 3*f(40), 3*f(41) &
    , 3*f(42), 3*f(43), 3*f(44), 3*f(45), 3*f(46), 3*f(47), 3*f(48), 3*f(49), 3*f(50), 3*f(51), 3*f(52), 3*f(53), 3*f(54), 3*f(55) &
    , 3*f(56), 3*f(57), 3*f(58), 3*f(59), 3*f(60), 3*f(61), 3*f(62), 3*f(63), 3*f(64), 3*f(65), 3*f(66), 3*f(67), 3*f(68), 3*f(69) &
    , 3*f(70), 3*f(71), 3*f(72), 3*f(73), 3*f(74), 3*f(75), 3*f(76), 3*f(77), 3*f(78), 3*f(79), 3*f(80), 3*f(81), 3*f(82), 3*f(83) &
    , 3*f(84), 3*f(85), 3*f(86), 3*f(87), 3*f(88), 3*f(89), 3*f(90), 3*f(91), 3*f(92), 3*f(93), 3*f(94), 3*f(95), 3*f(96), 3*f(97) &
    , 3*f(98), 3*f(99), 3*f(100), 3*f(101), 3*f(102), 3*f(103), 3*f(104), 3*f(105), 3*f(106), 3*f(107), 3*f(108), 3*f(109) &
    , 3*f(110), 3*f(111), 3*f(112), 3*f(113), 3*f(114), 3*f(115), 3*f(116), 3*f(117), 3*f(118), 3*f(119), 3*f(120), 3*f(121) &
    , 3*f(122), 3*f(123), 3*f(124), 3*f(125), 3*f(126), 3*f(127), 3*f(128), 3*f(129), 3*f(130), 3*f(131), 3*f(132), 3*f(133) &
    , 3*f(134), 3*f(135), 3*f(136), 3*f(137), 3*f(138), 3*f(139), 3*f(140), 3*f(141), 3*f(142), 3*f(143), 3*f(144), 3*f(145) &
    , 4*f(146), 3*f(147), 3*f(148), 3*f(149), 3*f(150), 3*f(151), 3*f(152), 3*f(153), 3*f(154), 3*f(155), 3*f(156), 3*f(157) &
    , 3*f(158), 3*f(159), 3*f(160), 3*f(161), 3*f(162), 3*f(163), 3*f(164), 3*f(165), 3*f(166), 4*f(167), 3*f(168), 3*f(169) &
    , 3*f(170), 3*f(171), 3*f(172), 3*f(173), 3*f(174), 3*f(175), 3*f(176), 4*f(177), 3*f(178), 3*f(179), 3*f(180), 3*f(181) &
    , 3*f(182), 3*f(183), 3*f(184), 3*f(185), 3*f(186), 3*f(187), 3*f(188), 3*f(189), 3*f(190), 3*f(191), 3*f(192), 3*f(193) &
    , 3*f(194), 3*f(195), 3*f(196), 3*f(197), 3*f(198), 3*f(199), 3*f(200), 3*f(201), 3*f(202), 3*f(203), 3*f(204), 3*f(205) &
    , 3*f(206), 3*f(207), 3*f(208), 3*f(209), 3*f(210), 3*f(211), 3*f(212), 3*f(213), 3*f(214), 3*f(215), 3*f(216), 3*f(217) &
    , 3*f(218), 3*f(219), 3*f(220), 3*f(221), 3*f(222), 3*f(223), 3*f(224), 3*f(225), 3*f(226), 3*f(227), 3*f(228), 3*f(229) &
    , 3*f(230), 3*f(231), 3*f(232), 3*f(233), 3*f(234), 3*f(235), 3*f(236), 3*f(237), 3*f(238), 3*f(239), 3*f(240), 3*f(241) &
    , 3*f(242), 3*f(243), 3*f(244), 3*f(245), 3*f(246), 3*f(247), 3*f(248), 3*f(249), 3*f(250), 3*f(251), 3*f(252), 3*f(253) &
    , 3*f(254), 3*f(255), 3*f(256), 3*f(257), 3*f(258), 3*f(259), 3*f(260), 3*f(261), 3*f(262), 3*f(263), 3*f(264), 3*f(265) &
    , 9*f(266), 9*f(267), 3*f(268), 9*f(269), 3*f(270), 9*f(270), 9*f(271), 3*f(272), 9*f(273), 3*f(274), 3*f(275), 3*f(276) &
    , 9*f(277), 9*f(278), 3*f(279), 3*f(280), 3*f(281), 3*f(282), 3*f(283), 3*f(284), 9*f(285), 9*f(286), 9*f(287), 3*f(288) &
    , 3*f(289), 3*f(290), 9*f(291), 9*f(292), 9*f(293), 3*f(294), 3*f(295), 3*f(296), 3*f(297), 3*f(298), 3*f(299), 9*f(300) &
    , 9*f(301), 9*f(302), 3*f(303), 3*f(304), 3*f(305), 9*f(306), 9*f(307), 3*f(308), 9*f(308), 9*f(309), 3*f(310), 3*f(311) &
    , 3*f(312), 3*f(313), 3*f(314), 3*f(315), 3*f(316), 9*f(317), 9*f(318), 9*f(319), 3*f(320), 3*f(321), 3*f(322), 9*f(323) &
    , 9*f(324), 9*f(325), 3*f(326), 9*f(327), 3*f(328), 9*f(328), 9*f(329), 3*f(330) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(2) = 1 /((L(5,12) - MH2)+L(6,12))
  den(4) = 1 /((L(5,20) - MH2)+L(6,20))
  den(6) = 1 /((L(5,24) - MH2)+L(6,24))
  den(8) = 1 /((L(5,5) - MB2)+L(6,5))
  den(9) = 1 /((L(5,10) - MB2)+L(6,10))
  den(11) = 1 /((L(5,18) - MB2)+L(6,18))
  den(14) = 1 /((L(5,9) - MB2)+L(6,9))
  den(15) = 1 /((L(5,6) - MB2)+L(6,6))
  den(17) = 1 /((L(5,17) - MB2)+L(6,17))
  den(26) = 1 /((L(5,3))+L(6,3))
  den(30) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(34) = 1 /((L(5,19) - MH2)+L(6,19))
  den(40) = 1 /((L(5,11) - MH2)+L(6,11))
  den(46) = 1 /((L(5,7) - MH2)+L(6,7))
  den(49) = 1 /((L(5,26) - MB2)+L(6,26))
  den(52) = 1 /((L(5,21) - MB2)+L(6,21))
  den(57) = 1 /((L(5,13) - MB2)+L(6,13))
  den(64) = 1 /((L(5,22) - MB2)+L(6,22))
  den(67) = 1 /((L(5,25) - MB2)+L(6,25))
  den(70) = 1 /((L(5,14) - MB2)+L(6,14))
  den(103) = 1 /((L(5,3) - MH2)+L(6,3))
  den(104) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(106) = 1 /((L(5,11) - MZ2)+L(6,11))
  den(108) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(111) = 1 /((L(5,7))+L(6,7))
  den(116) = 1 /((L(5,11))+L(6,11))
  den(121) = 1 /((L(5,19))+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(1)*den(6)
  den(10) = den(8)*den(9)
  den(12) = den(8)*den(11)
  den(13) = den(6)*den(8)
  den(16) = den(14)*den(15)
  den(18) = den(15)*den(17)
  den(19) = den(6)*den(15)
  den(20) = den(11)*den(14)
  den(21) = den(4)*den(14)
  den(22) = den(9)*den(17)
  den(23) = den(4)*den(9)
  den(24) = den(2)*den(17)
  den(25) = den(2)*den(11)
  den(27) = den(2)*den(26)
  den(28) = den(4)*den(26)
  den(29) = den(6)*den(26)
  den(31) = den(2)*den(30)
  den(32) = den(1)*den(31)
  den(33) = den(26)*den(31)
  den(35) = den(1)*den(34)
  den(36) = den(2)*den(35)
  den(37) = den(4)*den(30)
  den(38) = den(1)*den(37)
  den(39) = den(26)*den(37)
  den(41) = den(1)*den(40)
  den(42) = den(4)*den(41)
  den(43) = den(6)*den(30)
  den(44) = den(1)*den(43)
  den(45) = den(26)*den(43)
  den(47) = den(1)*den(46)
  den(48) = den(6)*den(47)
  den(50) = den(9)*den(49)
  den(51) = den(8)*den(50)
  den(53) = den(8)*den(52)
  den(54) = den(9)*den(53)
  den(55) = den(11)*den(49)
  den(56) = den(8)*den(55)
  den(58) = den(8)*den(57)
  den(59) = den(11)*den(58)
  den(60) = den(6)*den(49)
  den(61) = den(8)*den(60)
  den(62) = den(8)*den(46)
  den(63) = den(6)*den(62)
  den(65) = den(15)*den(64)
  den(66) = den(14)*den(65)
  den(68) = den(14)*den(67)
  den(69) = den(15)*den(68)
  den(71) = den(15)*den(70)
  den(72) = den(17)*den(71)
  den(73) = den(17)*den(67)
  den(74) = den(15)*den(73)
  den(75) = den(6)*den(67)
  den(76) = den(15)*den(75)
  den(77) = den(15)*den(46)
  den(78) = den(6)*den(77)
  den(79) = den(11)*den(64)
  den(80) = den(14)*den(79)
  den(81) = den(14)*den(57)
  den(82) = den(11)*den(81)
  den(83) = den(4)*den(64)
  den(84) = den(14)*den(83)
  den(85) = den(14)*den(40)
  den(86) = den(4)*den(85)
  den(87) = den(9)*den(70)
  den(88) = den(17)*den(87)
  den(89) = den(17)*den(52)
  den(90) = den(9)*den(89)
  den(91) = den(4)*den(52)
  den(92) = den(9)*den(91)
  den(93) = den(9)*den(40)
  den(94) = den(4)*den(93)
  den(95) = den(2)*den(70)
  den(96) = den(17)*den(95)
  den(97) = den(17)*den(34)
  den(98) = den(2)*den(97)
  den(99) = den(2)*den(57)
  den(100) = den(11)*den(99)
  den(101) = den(11)*den(34)
  den(102) = den(2)*den(101)
  den(105) = den(103)*den(104)
  den(107) = den(103)*den(106)
  den(109) = den(103)*den(108)
  den(110) = den(8)*den(104)
  den(112) = den(8)*den(111)
  den(113) = den(15)*den(104)
  den(114) = den(15)*den(111)
  den(115) = den(14)*den(106)
  den(117) = den(14)*den(116)
  den(118) = den(9)*den(106)
  den(119) = den(9)*den(116)
  den(120) = den(17)*den(108)
  den(122) = den(17)*den(121)
  den(123) = den(11)*den(108)
  den(124) = den(11)*den(121)
  den(125) = den(2)*den(103)
  den(126) = den(4)*den(103)
  den(127) = den(6)*den(103)
  den(128) = den(2)*den(109)
  den(129) = den(31)*den(103)
  den(130) = den(4)*den(107)
  den(131) = den(37)*den(103)
  den(132) = den(6)*den(105)
  den(133) = den(43)*den(103)
  den(134) = den(6)*den(110)
  den(135) = den(6)*den(112)
  den(136) = den(6)*den(113)
  den(137) = den(6)*den(114)
  den(138) = den(4)*den(115)
  den(139) = den(4)*den(117)
  den(140) = den(4)*den(118)
  den(141) = den(4)*den(119)
  den(142) = den(2)*den(120)
  den(143) = den(2)*den(122)
  den(144) = den(2)*den(123)
  den(145) = den(2)*den(124)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvv_ew_bbxzzz_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,179))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(2,hel_states))
  allocate(M0_col1_helarray(2,hel_states))
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(2,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppvvv_ew_bbxzzz_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for bottom anti-bottom Z Z Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppvvv_ew_bbxzzz_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppvvv_ew_bbxzzz_1, only: &
    & external_perm_ppvvv_ew_bbxzzz_1, &
    & external_perm_inv_ppvvv_ew_bbxzzz_1, &
    & extcomb_perm_ppvvv_ew_bbxzzz_1, &
    & average_factor_ppvvv_ew_bbxzzz_1
  use ol_external_ppvvv_ew_bbxzzz_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppvvv_ew_bbxzzz_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppvvv_ew_bbxzzz_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppvvv_ew_bbxzzz_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,179))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMB, nMB, nMZ, nMZ, nMZ ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppvvv_ew_bbxzzz_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMB, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMB, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rMZ, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMZ, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMZ, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VV_S(ntry, ex3(:), ex4(:), wf9(:,1), n3(:,2), t3x9(:,:,1))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,1), 3, wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_QA_Z(gZd,ntry, ex1(:), ex2(:), wf4(:,2), n3(:,4), t3x4(:,:,2))
  call vert_VV_S(ntry, wf4(:,2), ex5(:), wf12(:,2), n3(:,5), t3x12(:,:,2))
  call vert_VV_S(ntry, ex3(:), ex5(:), wf9(:,2), n3(:,6), t3x9(:,:,2))
  call vert_VS_T(ntry, ex4(:), 8, wf4(:,1), 3, wf12(:,3), n3(:,7), t3x12(:,:,3))
  call vert_VV_S(ntry, wf4(:,2), ex4(:), wf12(:,4), n3(:,8), t3x12(:,:,4))
  call vert_VV_S(ntry, ex4(:), ex5(:), wf9(:,3), n3(:,9), t3x9(:,:,3))
  call vert_VS_T(ntry, ex3(:), 4, wf4(:,1), 3, wf12(:,5), n3(:,10), t3x12(:,:,5))
  call vert_VV_S(ntry, wf4(:,2), ex3(:), wf12(:,6), n3(:,11), t3x12(:,:,6))
  call vert_ZQ_A(gZd,ntry, ex3(:), ex1(:), wf6(:,1), n3(:,12), t3x6(:,:,1))
  call vert_AZ_Q(gZd,ntry, ex2(:), ex4(:), wf6(:,2), n3(:,13), t3x6(:,:,2))
  call prop_Q_A(ntry, wf6(:,1), 5, MB, 1_intkind1, wf6(:,3), n2(1))
  call prop_A_Q(ntry, wf6(:,2), 10, MB, 1_intkind1, wf6(:,4), n2(2))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf6(:,3), wf18(:,1), n3(:,14), t3x18(:,:,1))
  call vert_AZ_Q(gZd,ntry, ex2(:), ex5(:), wf6(:,5), n3(:,15), t3x6(:,:,3))
  call prop_A_Q(ntry, wf6(:,5), 18, MB, 1_intkind1, wf6(:,6), n2(3))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,3), wf18(:,2), n3(:,16), t3x18(:,:,2))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,3), wf12(:,7), n3(:,17), t3x12(:,:,7))
  call vert_ZQ_A(gZd,ntry, ex4(:), ex1(:), wf6(:,7), n3(:,18), t3x6(:,:,4))
  call vert_AZ_Q(gZd,ntry, ex2(:), ex3(:), wf6(:,8), n3(:,19), t3x6(:,:,5))
  call prop_Q_A(ntry, wf6(:,7), 9, MB, 1_intkind1, wf6(:,9), n2(4))
  call prop_A_Q(ntry, wf6(:,8), 6, MB, 1_intkind1, wf6(:,10), n2(5))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf6(:,9), wf18(:,3), n3(:,20), t3x18(:,:,3))
  call vert_ZQ_A(gZd,ntry, ex5(:), ex1(:), wf6(:,11), n3(:,21), t3x6(:,:,6))
  call prop_Q_A(ntry, wf6(:,11), 17, MB, 1_intkind1, wf6(:,12), n2(6))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,12), wf18(:,4), n3(:,22), t3x18(:,:,4))
  call vert_AQ_S(gH,ntry, wf6(:,10), ex1(:), wf12(:,8), n3(:,23), t3x12(:,:,8))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,9), wf18(:,5), n3(:,24), t3x18(:,:,5))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,9), wf12(:,9), n3(:,25), t3x12(:,:,9))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,12), wf18(:,6), n3(:,26), t3x18(:,:,6))
  call vert_AQ_S(gH,ntry, wf6(:,4), ex1(:), wf12(:,10), n3(:,27), t3x12(:,:,10))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,12), wf12(:,11), n3(:,28), t3x12(:,:,11))
  call vert_AQ_S(gH,ntry, wf6(:,6), ex1(:), wf12(:,12), n3(:,29), t3x12(:,:,12))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,3), n3(:,30), t3x4(:,:,3))
  call counter_VVV_V(ntry, ex3(:), ex4(:), ex5(:), wf27(:,1), n4(:,1), t4x27(:,:,1))
  call counter_VS_T(ntry, ex5(:), 16, wf4(:,1), 3, wf12(:,13), n3(:,31), t3x12(:,:,13))
  call counter_VV_S(ntry, wf4(:,3), ex5(:), wf12(:,14), n3(:,32), t3x12(:,:,14))
  call counter_VV_S(ntry, wf4(:,2), ex5(:), wf12(:,15), n3(:,33), t3x12(:,:,15))
  call counter_VS_T(ntry, ex4(:), 8, wf4(:,1), 3, wf12(:,16), n3(:,34), t3x12(:,:,16))
  call counter_VV_S(ntry, wf4(:,3), ex4(:), wf12(:,17), n3(:,35), t3x12(:,:,17))
  call counter_VV_S(ntry, wf4(:,2), ex4(:), wf12(:,18), n3(:,36), t3x12(:,:,18))
  call counter_VV_S(ntry, ex4(:), ex5(:), wf9(:,4), n3(:,37), t3x9(:,:,4))
  call counter_VS_T(ntry, ex3(:), 4, wf4(:,1), 3, wf12(:,19), n3(:,38), t3x12(:,:,19))
  call counter_VV_S(ntry, wf4(:,3), ex3(:), wf12(:,20), n3(:,39), t3x12(:,:,20))
  call counter_VV_S(ntry, wf4(:,2), ex3(:), wf12(:,21), n3(:,40), t3x12(:,:,21))
  call counter_VV_S(ntry, ex3(:), ex5(:), wf9(:,5), n3(:,41), t3x9(:,:,5))
  call counter_VV_S(ntry, ex3(:), ex4(:), wf9(:,6), n3(:,42), t3x9(:,:,6))
  call counter_ZQ_A(gZd,ntry, ex5(:), wf6(:,3), wf18(:,7), n3(:,43), t3x18(:,:,7))
  call counter_ZQ_A(EWctVbb,ntry, ex5(:), wf6(:,3), wf18(:,8), n3(:,44), t3x18(:,:,8))
  call counter_ZQ_A(gZd,ntry, ex4(:), wf6(:,3), wf18(:,9), n3(:,45), t3x18(:,:,9))
  call counter_ZQ_A(EWctVbb,ntry, ex4(:), wf6(:,3), wf18(:,10), n3(:,46), t3x18(:,:,10))
  call counter_ZQ_A(gZd,ntry, ex5(:), wf6(:,9), wf18(:,11), n3(:,47), t3x18(:,:,11))
  call counter_ZQ_A(EWctVbb,ntry, ex5(:), wf6(:,9), wf18(:,12), n3(:,48), t3x18(:,:,12))
  call counter_ZQ_A(gZd,ntry, ex4(:), wf6(:,12), wf18(:,13), n3(:,49), t3x18(:,:,13))
  call counter_ZQ_A(EWctVbb,ntry, ex4(:), wf6(:,12), wf18(:,14), n3(:,50), t3x18(:,:,14))
  call counter_ZQ_A(gZd,ntry, ex3(:), wf6(:,9), wf18(:,15), n3(:,51), t3x18(:,:,15))
  call counter_ZQ_A(EWctVbb,ntry, ex3(:), wf6(:,9), wf18(:,16), n3(:,52), t3x18(:,:,16))
  call counter_ZQ_A(gZd,ntry, ex3(:), wf6(:,12), wf18(:,17), n3(:,53), t3x18(:,:,17))
  call counter_ZQ_A(EWctVbb,ntry, ex3(:), wf6(:,12), wf18(:,18), n3(:,54), t3x18(:,:,18))
  call counter_AQ_S(gH,ntry, ex2(:), wf6(:,3), wf12(:,22), n3(:,55), t3x12(:,:,22))
  call counter_AQ_S(EWctHbb,ntry, ex2(:), wf6(:,3), wf12(:,23), n3(:,56), t3x12(:,:,23))
  call counter_AZ_Q(gZd,ntry, ex2(:), ex5(:), wf6(:,13), n3(:,57), t3x6(:,:,7))
  call prop_A_Q(ntry, wf6(:,13), 18, MB, 1_intkind1, wf6(:,14), n2(7))
  call counter_AZ_Q(EWctVbb,ntry, ex2(:), ex5(:), wf6(:,15), n3(:,58), t3x6(:,:,8))
  call prop_A_Q(ntry, wf6(:,15), 18, MB, 1_intkind1, wf6(:,16), n2(8))
  call counter_AZ_Q(gZd,ntry, ex2(:), ex4(:), wf6(:,17), n3(:,59), t3x6(:,:,9))
  call prop_A_Q(ntry, wf6(:,17), 10, MB, 1_intkind1, wf6(:,18), n2(9))
  call counter_AZ_Q(EWctVbb,ntry, ex2(:), ex4(:), wf6(:,19), n3(:,60), t3x6(:,:,10))
  call prop_A_Q(ntry, wf6(:,19), 10, MB, 1_intkind1, wf6(:,20), n2(10))
  call counter_AQ_S(gH,ntry, ex2(:), wf6(:,9), wf12(:,24), n3(:,61), t3x12(:,:,24))
  call counter_AQ_S(EWctHbb,ntry, ex2(:), wf6(:,9), wf12(:,25), n3(:,62), t3x12(:,:,25))
  call counter_AQ_S(gH,ntry, ex2(:), wf6(:,12), wf12(:,26), n3(:,63), t3x12(:,:,26))
  call counter_AQ_S(EWctHbb,ntry, ex2(:), wf6(:,12), wf12(:,27), n3(:,64), t3x12(:,:,27))
  call vert_AQ_S(gH,ntry, wf6(:,14), ex1(:), wf12(:,28), n3(:,65), t3x12(:,:,28))
  call vert_AQ_S(gH,ntry, wf6(:,16), ex1(:), wf12(:,29), n3(:,66), t3x12(:,:,29))
  call vert_AQ_S(gH,ntry, wf6(:,18), ex1(:), wf12(:,30), n3(:,67), t3x12(:,:,30))
  call vert_AQ_S(gH,ntry, wf6(:,20), ex1(:), wf12(:,31), n3(:,68), t3x12(:,:,31))
  call counter_AZ_Q(gZd,ntry, ex2(:), ex3(:), wf6(:,21), n3(:,69), t3x6(:,:,11))
  call prop_A_Q(ntry, wf6(:,21), 6, MB, 1_intkind1, wf6(:,22), n2(11))
  call counter_AZ_Q(EWctVbb,ntry, ex2(:), ex3(:), wf6(:,23), n3(:,70), t3x6(:,:,12))
  call prop_A_Q(ntry, wf6(:,23), 6, MB, 1_intkind1, wf6(:,24), n2(12))
  call vert_AQ_S(gH,ntry, wf6(:,22), ex1(:), wf12(:,32), n3(:,71), t3x12(:,:,32))
  call vert_AQ_S(gH,ntry, wf6(:,24), ex1(:), wf12(:,33), n3(:,72), t3x12(:,:,33))
  call counter_AQ_S(gH,ntry, wf6(:,10), ex1(:), wf12(:,34), n3(:,73), t3x12(:,:,34))
  call counter_AQ_S(EWctHbb,ntry, wf6(:,10), ex1(:), wf12(:,35), n3(:,74), t3x12(:,:,35))
  call counter_ZQ_A(gZd,ntry, ex5(:), ex1(:), wf6(:,25), n3(:,75), t3x6(:,:,13))
  call prop_Q_A(ntry, wf6(:,25), 17, MB, 1_intkind1, wf6(:,26), n2(13))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,26), wf18(:,19), n3(:,76), t3x18(:,:,19))
  call counter_ZQ_A(EWctVbb,ntry, ex5(:), ex1(:), wf6(:,27), n3(:,77), t3x6(:,:,14))
  call prop_Q_A(ntry, wf6(:,27), 17, MB, 1_intkind1, wf6(:,28), n2(14))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,28), wf18(:,20), n3(:,78), t3x18(:,:,20))
  call counter_ZQ_A(gZd,ntry, ex4(:), ex1(:), wf6(:,29), n3(:,79), t3x6(:,:,15))
  call prop_Q_A(ntry, wf6(:,29), 9, MB, 1_intkind1, wf6(:,30), n2(15))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf6(:,30), wf18(:,21), n3(:,80), t3x18(:,:,21))
  call counter_ZQ_A(EWctVbb,ntry, ex4(:), ex1(:), wf6(:,31), n3(:,81), t3x6(:,:,16))
  call prop_Q_A(ntry, wf6(:,31), 9, MB, 1_intkind1, wf6(:,32), n2(16))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf6(:,32), wf18(:,22), n3(:,82), t3x18(:,:,22))
  call counter_AQ_S(gH,ntry, wf6(:,4), ex1(:), wf12(:,36), n3(:,83), t3x12(:,:,36))
  call counter_AQ_S(EWctHbb,ntry, wf6(:,4), ex1(:), wf12(:,37), n3(:,84), t3x12(:,:,37))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,26), wf18(:,23), n3(:,85), t3x18(:,:,23))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,28), wf18(:,24), n3(:,86), t3x18(:,:,24))
  call counter_AQ_S(gH,ntry, wf6(:,6), ex1(:), wf12(:,38), n3(:,87), t3x12(:,:,38))
  call counter_AQ_S(EWctHbb,ntry, wf6(:,6), ex1(:), wf12(:,39), n3(:,88), t3x12(:,:,39))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,26), wf12(:,40), n3(:,89), t3x12(:,:,40))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,28), wf12(:,41), n3(:,90), t3x12(:,:,41))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,30), wf18(:,25), n3(:,91), t3x18(:,:,25))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,32), wf18(:,26), n3(:,92), t3x18(:,:,26))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,30), wf12(:,42), n3(:,93), t3x12(:,:,42))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,32), wf12(:,43), n3(:,94), t3x12(:,:,43))
  call counter_ZQ_A(gZd,ntry, ex3(:), ex1(:), wf6(:,33), n3(:,95), t3x6(:,:,17))
  call prop_Q_A(ntry, wf6(:,33), 5, MB, 1_intkind1, wf6(:,34), n2(17))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf6(:,34), wf18(:,27), n3(:,96), t3x18(:,:,27))
  call counter_ZQ_A(EWctVbb,ntry, ex3(:), ex1(:), wf6(:,35), n3(:,97), t3x6(:,:,18))
  call prop_Q_A(ntry, wf6(:,35), 5, MB, 1_intkind1, wf6(:,36), n2(18))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf6(:,36), wf18(:,28), n3(:,98), t3x18(:,:,28))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,34), wf18(:,29), n3(:,99), t3x18(:,:,29))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,36), wf18(:,30), n3(:,100), t3x18(:,:,30))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,34), wf12(:,44), n3(:,101), t3x12(:,:,44))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,36), wf12(:,45), n3(:,102), t3x12(:,:,45))
  call counter_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,4), n3(:,103), t3x4(:,:,4))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,4), 3, wf12(:,46), n3(:,104), t3x12(:,:,46))
  call counter_AQ_S(EWctXbb,ntry, ex2(:), ex1(:), wf4(:,5), n3(:,105), t3x4(:,:,5))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,5), 3, wf12(:,47), n3(:,106), t3x12(:,:,47))
  call counter_QA_Z(gZd,ntry, ex1(:), ex2(:), wf4(:,6), n3(:,107), t3x4(:,:,6))
  call vert_VV_S(ntry, wf4(:,6), ex5(:), wf12(:,48), n3(:,108), t3x12(:,:,48))
  call counter_QA_Z(EWctVbb,ntry, ex1(:), ex2(:), wf4(:,7), n3(:,109), t3x4(:,:,7))
  call vert_VV_S(ntry, wf4(:,7), ex5(:), wf12(:,49), n3(:,110), t3x12(:,:,49))
  call vert_VS_T(ntry, ex4(:), 8, wf4(:,4), 3, wf12(:,50), n3(:,111), t3x12(:,:,50))
  call vert_VS_T(ntry, ex4(:), 8, wf4(:,5), 3, wf12(:,51), n3(:,112), t3x12(:,:,51))
  call vert_VV_S(ntry, wf4(:,6), ex4(:), wf12(:,52), n3(:,113), t3x12(:,:,52))
  call vert_VV_S(ntry, wf4(:,7), ex4(:), wf12(:,53), n3(:,114), t3x12(:,:,53))
  call vert_VS_T(ntry, ex3(:), 4, wf4(:,4), 3, wf12(:,54), n3(:,115), t3x12(:,:,54))
  call vert_VS_T(ntry, ex3(:), 4, wf4(:,5), 3, wf12(:,55), n3(:,116), t3x12(:,:,55))
  call vert_VV_S(ntry, wf4(:,6), ex3(:), wf12(:,56), n3(:,117), t3x12(:,:,56))
  call vert_VV_S(ntry, wf4(:,7), ex3(:), wf12(:,57), n3(:,118), t3x12(:,:,57))
  call vert_TV_S(ntry, wf9(:,1), 12, ex5(:), 16, wf27(:,2), n3(:,119), t3x27(:,:,1))
  call counter_S_S(EWctXX,ntry, wf4(:,1), 3, wf4(:,8), n2(19))
  call vert_SV_V(ntry, wf9(:,1), ex5(:), wf27(:,3), n3(:,120), t3x27(:,:,2))
  call counter_S_V(EWctXZ,ntry, wf4(:,1), 3, wf4(:,9), n2(20))
  call counter_V_S(EWctXA,ntry, wf4(:,3), 3, wf4(:,10), n2(21))
  call counter_V_S(EWctXZ,ntry, wf4(:,2), 3, wf4(:,11), n2(22))
  call counter_V_V(EWctAZ,ntry, wf4(:,3), 3, wf4(:,12), n2(23))
  call counter_V_V(EWctZZ,ntry, wf4(:,2), 3, wf4(:,13), n2(24))
  call counter_S_S(EWctHH,ntry, wf9(:,1), 12, wf9(:,7), n2(25))
  call vert_TV_S(ntry, wf9(:,2), 20, ex4(:), 8, wf27(:,4), n3(:,121), t3x27(:,:,3))
  call vert_SV_V(ntry, wf9(:,2), ex4(:), wf27(:,5), n3(:,122), t3x27(:,:,4))
  call counter_S_S(EWctHH,ntry, wf9(:,2), 20, wf9(:,8), n2(26))
  call vert_TV_S(ntry, wf9(:,3), 24, ex3(:), 4, wf27(:,6), n3(:,123), t3x27(:,:,5))
  call vert_SV_V(ntry, wf9(:,3), ex3(:), wf27(:,7), n3(:,124), t3x27(:,:,6))
  call counter_S_S(EWctHH,ntry, wf9(:,3), 24, wf9(:,9), n2(27))
  call vert_AZ_Q(gZd,ntry, wf6(:,4), ex5(:), wf18(:,31), n3(:,125), t3x18(:,:,31))
  call counter_Q_A(ctbb,5,ntry, wf6(:,3), 5, wf6(:,37), n2(28))
  call prop_A_Q(ntry, wf18(:,31), 26, MB, 1_intkind1, wf18(:,32), n2(29))
  call counter_Q_A_LR(EWctbb,ntry, wf6(:,3), 5, wf6(:,38), n2(30))
  call counter_A_Q(ctbb,5,ntry, wf6(:,4), 10, wf6(:,39), n2(31))
  call prop_Q_A(ntry, wf18(:,1), 21, MB, 1_intkind1, wf18(:,33), n2(32))
  call counter_A_Q_LR(EWctbb,ntry, wf6(:,4), 10, wf6(:,40), n2(33))
  call vert_AZ_Q(gZd,ntry, wf6(:,6), ex4(:), wf18(:,34), n3(:,126), t3x18(:,:,32))
  call prop_A_Q(ntry, wf18(:,34), 26, MB, 1_intkind1, wf18(:,35), n2(34))
  call counter_A_Q(ctbb,5,ntry, wf6(:,6), 18, wf6(:,41), n2(35))
  call prop_Q_A(ntry, wf18(:,2), 13, MB, 1_intkind1, wf18(:,36), n2(36))
  call counter_A_Q_LR(EWctbb,ntry, wf6(:,6), 18, wf6(:,42), n2(37))
  call vert_SA_Q(gH,ntry, wf9(:,3), ex2(:), wf18(:,37), n3(:,127), t3x18(:,:,33))
  call prop_A_Q(ntry, wf18(:,37), 26, MB, 1_intkind1, wf18(:,38), n2(38))
  call vert_AZ_Q(gZd,ntry, wf6(:,10), ex5(:), wf18(:,39), n3(:,128), t3x18(:,:,34))
  call counter_Q_A(ctbb,5,ntry, wf6(:,9), 9, wf6(:,43), n2(39))
  call prop_A_Q(ntry, wf18(:,39), 22, MB, 1_intkind1, wf18(:,40), n2(40))
  call counter_Q_A_LR(EWctbb,ntry, wf6(:,9), 9, wf6(:,44), n2(41))
  call counter_A_Q(ctbb,5,ntry, wf6(:,10), 6, wf6(:,45), n2(42))
  call prop_Q_A(ntry, wf18(:,3), 25, MB, 1_intkind1, wf18(:,41), n2(43))
  call counter_A_Q_LR(EWctbb,ntry, wf6(:,10), 6, wf6(:,46), n2(44))
  call vert_AZ_Q(gZd,ntry, wf6(:,10), ex4(:), wf18(:,42), n3(:,129), t3x18(:,:,35))
  call counter_Q_A(ctbb,5,ntry, wf6(:,12), 17, wf6(:,47), n2(45))
  call prop_A_Q(ntry, wf18(:,42), 14, MB, 1_intkind1, wf18(:,43), n2(46))
  call counter_Q_A_LR(EWctbb,ntry, wf6(:,12), 17, wf6(:,48), n2(47))
  call prop_Q_A(ntry, wf18(:,4), 25, MB, 1_intkind1, wf18(:,44), n2(48))
  call vert_QS_A(gH,ntry, ex1(:), wf9(:,3), wf18(:,45), n3(:,130), t3x18(:,:,36))
  call prop_Q_A(ntry, wf18(:,45), 25, MB, 1_intkind1, wf18(:,46), n2(49))
  call vert_AZ_Q(gZd,ntry, wf6(:,6), ex3(:), wf18(:,47), n3(:,131), t3x18(:,:,37))
  call prop_A_Q(ntry, wf18(:,47), 22, MB, 1_intkind1, wf18(:,48), n2(50))
  call prop_Q_A(ntry, wf18(:,5), 13, MB, 1_intkind1, wf18(:,49), n2(51))
  call vert_SA_Q(gH,ntry, wf9(:,2), ex2(:), wf18(:,50), n3(:,132), t3x18(:,:,38))
  call prop_A_Q(ntry, wf18(:,50), 22, MB, 1_intkind1, wf18(:,51), n2(52))
  call vert_AZ_Q(gZd,ntry, wf6(:,4), ex3(:), wf18(:,52), n3(:,133), t3x18(:,:,39))
  call prop_A_Q(ntry, wf18(:,52), 14, MB, 1_intkind1, wf18(:,53), n2(53))
  call prop_Q_A(ntry, wf18(:,6), 21, MB, 1_intkind1, wf18(:,54), n2(54))
  call vert_QS_A(gH,ntry, ex1(:), wf9(:,2), wf18(:,55), n3(:,134), t3x18(:,:,40))
  call prop_Q_A(ntry, wf18(:,55), 21, MB, 1_intkind1, wf18(:,56), n2(55))
  call vert_SA_Q(gH,ntry, wf9(:,1), ex2(:), wf18(:,57), n3(:,135), t3x18(:,:,41))
  call prop_A_Q(ntry, wf18(:,57), 14, MB, 1_intkind1, wf18(:,58), n2(56))
  call vert_QS_A(gH,ntry, ex1(:), wf9(:,1), wf18(:,59), n3(:,136), t3x18(:,:,42))
  call prop_Q_A(ntry, wf18(:,59), 13, MB, 1_intkind1, wf18(:,60), n2(57))
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,14), n3(:,137), t3x4(:,:,8))
  call vert_TV_S(ntry, wf4(:,14), 3, ex3(:), 4, wf12(:,58), n3(:,138), t3x12(:,:,58))
  call vert_SV_V(ntry, wf4(:,14), ex3(:), wf12(:,59), n3(:,139), t3x12(:,:,59))
  call vert_TV_S(ntry, wf4(:,14), 3, ex4(:), 8, wf12(:,60), n3(:,140), t3x12(:,:,60))
  call vert_SV_V(ntry, wf4(:,14), ex4(:), wf12(:,61), n3(:,141), t3x12(:,:,61))
  call vert_TV_S(ntry, wf4(:,14), 3, ex5(:), 16, wf12(:,62), n3(:,142), t3x12(:,:,62))
  call vert_SV_V(ntry, wf4(:,14), ex5(:), wf12(:,63), n3(:,143), t3x12(:,:,63))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,3), wf12(:,64), n3(:,144), t3x12(:,:,64))
  call vert_QA_V(ntry, wf6(:,3), ex2(:), wf12(:,65), n3(:,145), t3x12(:,:,65))
  call vert_QA_Z(gZd,ntry, wf6(:,3), ex2(:), wf12(:,66), n3(:,146), t3x12(:,:,66))
  call vert_AQ_S(gX,ntry, wf6(:,10), ex1(:), wf12(:,67), n3(:,147), t3x12(:,:,67))
  call vert_QA_V(ntry, ex1(:), wf6(:,10), wf12(:,68), n3(:,148), t3x12(:,:,68))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,10), wf12(:,69), n3(:,149), t3x12(:,:,69))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,9), wf12(:,70), n3(:,150), t3x12(:,:,70))
  call vert_QA_V(ntry, wf6(:,9), ex2(:), wf12(:,71), n3(:,151), t3x12(:,:,71))
  call vert_QA_Z(gZd,ntry, wf6(:,9), ex2(:), wf12(:,72), n3(:,152), t3x12(:,:,72))
  call vert_AQ_S(gX,ntry, wf6(:,4), ex1(:), wf12(:,73), n3(:,153), t3x12(:,:,73))
  call vert_QA_V(ntry, ex1(:), wf6(:,4), wf12(:,74), n3(:,154), t3x12(:,:,74))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,4), wf12(:,75), n3(:,155), t3x12(:,:,75))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,12), wf12(:,76), n3(:,156), t3x12(:,:,76))
  call vert_QA_V(ntry, wf6(:,12), ex2(:), wf12(:,77), n3(:,157), t3x12(:,:,77))
  call vert_QA_Z(gZd,ntry, wf6(:,12), ex2(:), wf12(:,78), n3(:,158), t3x12(:,:,78))
  call vert_AQ_S(gX,ntry, wf6(:,6), ex1(:), wf12(:,79), n3(:,159), t3x12(:,:,79))
  call vert_QA_V(ntry, ex1(:), wf6(:,6), wf12(:,80), n3(:,160), t3x12(:,:,80))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,6), wf12(:,81), n3(:,161), t3x12(:,:,81))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 3
do i3= 1, 3
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf9(:,1), wf12(:,1), A(:,1), n3(:,162), t3x108(:,:,1), nhel, den(3))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,2), A(:,2), n3(:,163), t3x108(:,:,2), nhel, den(3))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,3), A(:,3), n3(:,164), t3x108(:,:,3), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,4), A(:,4), n3(:,165), t3x108(:,:,4), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,5), A(:,5), n3(:,166), t3x108(:,:,5), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,6), A(:,6), n3(:,167), t3x108(:,:,6), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,1), A(:,7), n3(:,168), t3x108(:,:,7), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,6), wf18(:,2), A(:,8), n3(:,169), t3x108(:,:,8), nhel, den(12))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,7), A(:,9), n3(:,170), t3x108(:,:,9), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,10), wf18(:,3), A(:,10), n3(:,171), t3x108(:,:,10), nhel, den(16))
    call Hcont_QA(nsync, wf6(:,10), wf18(:,4), A(:,11), n3(:,172), t3x108(:,:,11), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,8), A(:,12), n3(:,173), t3x108(:,:,12), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,6), wf18(:,5), A(:,13), n3(:,174), t3x108(:,:,13), nhel, den(20))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,9), A(:,14), n3(:,175), t3x108(:,:,14), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,6), A(:,15), n3(:,176), t3x108(:,:,15), nhel, den(22))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,10), A(:,16), n3(:,177), t3x108(:,:,16), nhel, den(23))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,11), A(:,17), n3(:,178), t3x108(:,:,17), nhel, den(24))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,12), A(:,18), n3(:,179), t3x108(:,:,18), nhel, den(25))

    call Hcont_VV(nsync, wf4(:,3), wf27(:,1), A(:,19), n3(:,180), t3x108(:,:,19), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,2), wf27(:,1), A(:,20), n3(:,181), t3x108(:,:,20), nhel, den(1))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,13), A(:,21), n3(:,182), t3x108(:,:,21), nhel, den(3))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,14), A(:,22), n3(:,183), t3x108(:,:,22), nhel, den(27))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,15), A(:,23), n3(:,184), t3x108(:,:,23), nhel, den(3))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,16), A(:,24), n3(:,185), t3x108(:,:,24), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,17), A(:,25), n3(:,186), t3x108(:,:,25), nhel, den(28))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,18), A(:,26), n3(:,187), t3x108(:,:,26), nhel, den(5))
    call Hcont_SS(nsync, wf12(:,5), wf9(:,4), A(:,27), n3(:,188), t3x108(:,:,27), nhel, den(7))
    call Hcont_SS(nsync, wf12(:,6), wf9(:,4), A(:,28), n3(:,189), t3x108(:,:,28), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,19), A(:,29), n3(:,190), t3x108(:,:,29), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,20), A(:,30), n3(:,191), t3x108(:,:,30), nhel, den(29))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,21), A(:,31), n3(:,192), t3x108(:,:,31), nhel, den(7))
    call Hcont_SS(nsync, wf12(:,3), wf9(:,5), A(:,32), n3(:,193), t3x108(:,:,32), nhel, den(5))
    call Hcont_SS(nsync, wf12(:,4), wf9(:,5), A(:,33), n3(:,194), t3x108(:,:,33), nhel, den(5))
    call Hcont_SS(nsync, wf12(:,1), wf9(:,6), A(:,34), n3(:,195), t3x108(:,:,34), nhel, den(3))
    call Hcont_SS(nsync, wf12(:,2), wf9(:,6), A(:,35), n3(:,196), t3x108(:,:,35), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,7), A(:,36), n3(:,197), t3x108(:,:,36), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,8), A(:,37), n3(:,198), t3x108(:,:,37), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,6), wf18(:,9), A(:,38), n3(:,199), t3x108(:,:,38), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,6), wf18(:,10), A(:,39), n3(:,200), t3x108(:,:,39), nhel, den(12))
    call Hcont_SS(nsync, wf12(:,7), wf9(:,4), A(:,40), n3(:,201), t3x108(:,:,40), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,10), wf18(:,11), A(:,41), n3(:,202), t3x108(:,:,41), nhel, den(16))
    call Hcont_QA(nsync, wf6(:,10), wf18(:,12), A(:,42), n3(:,203), t3x108(:,:,42), nhel, den(16))
    call Hcont_QA(nsync, wf6(:,10), wf18(:,13), A(:,43), n3(:,204), t3x108(:,:,43), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,10), wf18(:,14), A(:,44), n3(:,205), t3x108(:,:,44), nhel, den(18))
    call Hcont_SS(nsync, wf12(:,8), wf9(:,4), A(:,45), n3(:,206), t3x108(:,:,45), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,6), wf18(:,15), A(:,46), n3(:,207), t3x108(:,:,46), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,6), wf18(:,16), A(:,47), n3(:,208), t3x108(:,:,47), nhel, den(20))
    call Hcont_SS(nsync, wf12(:,9), wf9(:,5), A(:,48), n3(:,209), t3x108(:,:,48), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,17), A(:,49), n3(:,210), t3x108(:,:,49), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,18), A(:,50), n3(:,211), t3x108(:,:,50), nhel, den(22))
    call Hcont_SS(nsync, wf12(:,10), wf9(:,5), A(:,51), n3(:,212), t3x108(:,:,51), nhel, den(23))
    call Hcont_SS(nsync, wf12(:,11), wf9(:,6), A(:,52), n3(:,213), t3x108(:,:,52), nhel, den(24))
    call Hcont_SS(nsync, wf12(:,12), wf9(:,6), A(:,53), n3(:,214), t3x108(:,:,53), nhel, den(25))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,22), A(:,54), n3(:,215), t3x108(:,:,54), nhel, den(13))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,23), A(:,55), n3(:,216), t3x108(:,:,55), nhel, den(13))
    call Hcont_QA(nsync, wf18(:,2), wf6(:,14), A(:,56), n3(:,217), t3x108(:,:,56), nhel, den(12))
    call Hcont_QA(nsync, wf18(:,2), wf6(:,16), A(:,57), n3(:,218), t3x108(:,:,57), nhel, den(12))
    call Hcont_QA(nsync, wf18(:,1), wf6(:,18), A(:,58), n3(:,219), t3x108(:,:,58), nhel, den(10))
    call Hcont_QA(nsync, wf18(:,1), wf6(:,20), A(:,59), n3(:,220), t3x108(:,:,59), nhel, den(10))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,24), A(:,60), n3(:,221), t3x108(:,:,60), nhel, den(21))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,25), A(:,61), n3(:,222), t3x108(:,:,61), nhel, den(21))
    call Hcont_QA(nsync, wf18(:,5), wf6(:,14), A(:,62), n3(:,223), t3x108(:,:,62), nhel, den(20))
    call Hcont_QA(nsync, wf18(:,5), wf6(:,16), A(:,63), n3(:,224), t3x108(:,:,63), nhel, den(20))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,26), A(:,64), n3(:,225), t3x108(:,:,64), nhel, den(24))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,27), A(:,65), n3(:,226), t3x108(:,:,65), nhel, den(24))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,28), A(:,66), n3(:,227), t3x108(:,:,66), nhel, den(25))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,29), A(:,67), n3(:,228), t3x108(:,:,67), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,6), wf6(:,18), A(:,68), n3(:,229), t3x108(:,:,68), nhel, den(22))
    call Hcont_QA(nsync, wf18(:,6), wf6(:,20), A(:,69), n3(:,230), t3x108(:,:,69), nhel, den(22))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,30), A(:,70), n3(:,231), t3x108(:,:,70), nhel, den(23))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,31), A(:,71), n3(:,232), t3x108(:,:,71), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,3), wf6(:,22), A(:,72), n3(:,233), t3x108(:,:,72), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,3), wf6(:,24), A(:,73), n3(:,234), t3x108(:,:,73), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,4), wf6(:,22), A(:,74), n3(:,235), t3x108(:,:,74), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,4), wf6(:,24), A(:,75), n3(:,236), t3x108(:,:,75), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,32), A(:,76), n3(:,237), t3x108(:,:,76), nhel, den(19))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,33), A(:,77), n3(:,238), t3x108(:,:,77), nhel, den(19))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,34), A(:,78), n3(:,239), t3x108(:,:,78), nhel, den(19))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,35), A(:,79), n3(:,240), t3x108(:,:,79), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,10), wf18(:,19), A(:,80), n3(:,241), t3x108(:,:,80), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,10), wf18(:,20), A(:,81), n3(:,242), t3x108(:,:,81), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,10), wf18(:,21), A(:,82), n3(:,243), t3x108(:,:,82), nhel, den(16))
    call Hcont_QA(nsync, wf6(:,10), wf18(:,22), A(:,83), n3(:,244), t3x108(:,:,83), nhel, den(16))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,36), A(:,84), n3(:,245), t3x108(:,:,84), nhel, den(23))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,37), A(:,85), n3(:,246), t3x108(:,:,85), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,23), A(:,86), n3(:,247), t3x108(:,:,86), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,24), A(:,87), n3(:,248), t3x108(:,:,87), nhel, den(22))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,38), A(:,88), n3(:,249), t3x108(:,:,88), nhel, den(25))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,39), A(:,89), n3(:,250), t3x108(:,:,89), nhel, den(25))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,40), A(:,90), n3(:,251), t3x108(:,:,90), nhel, den(24))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,41), A(:,91), n3(:,252), t3x108(:,:,91), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,6), wf18(:,25), A(:,92), n3(:,253), t3x108(:,:,92), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,6), wf18(:,26), A(:,93), n3(:,254), t3x108(:,:,93), nhel, den(20))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,42), A(:,94), n3(:,255), t3x108(:,:,94), nhel, den(21))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,43), A(:,95), n3(:,256), t3x108(:,:,95), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,27), A(:,96), n3(:,257), t3x108(:,:,96), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,28), A(:,97), n3(:,258), t3x108(:,:,97), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,6), wf18(:,29), A(:,98), n3(:,259), t3x108(:,:,98), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,6), wf18(:,30), A(:,99), n3(:,260), t3x108(:,:,99), nhel, den(12))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,44), A(:,100), n3(:,261), t3x108(:,:,100), nhel, den(13))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,45), A(:,101), n3(:,262), t3x108(:,:,101), nhel, den(13))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,46), A(:,102), n3(:,263), t3x108(:,:,102), nhel, den(3))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,47), A(:,103), n3(:,264), t3x108(:,:,103), nhel, den(3))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,48), A(:,104), n3(:,265), t3x108(:,:,104), nhel, den(3))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,49), A(:,105), n3(:,266), t3x108(:,:,105), nhel, den(3))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,50), A(:,106), n3(:,267), t3x108(:,:,106), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,51), A(:,107), n3(:,268), t3x108(:,:,107), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,52), A(:,108), n3(:,269), t3x108(:,:,108), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,2), wf12(:,53), A(:,109), n3(:,270), t3x108(:,:,109), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,54), A(:,110), n3(:,271), t3x108(:,:,110), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,55), A(:,111), n3(:,272), t3x108(:,:,111), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,56), A(:,112), n3(:,273), t3x108(:,:,112), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,57), A(:,113), n3(:,274), t3x108(:,:,113), nhel, den(7))
    call Hcont_SS(nsync, wf27(:,2), wf4(:,8), A(:,114), n3(:,275), t3x108(:,:,114), nhel, den(32))
    call Hcont_VV(nsync, wf27(:,3), wf4(:,9), A(:,115), n3(:,276), t3x108(:,:,115), nhel, den(32))
    call Hcont_SS(nsync, wf27(:,2), wf4(:,10), A(:,116), n3(:,277), t3x108(:,:,116), nhel, den(33))
    call Hcont_SS(nsync, wf27(:,2), wf4(:,11), A(:,117), n3(:,278), t3x108(:,:,117), nhel, den(32))
    call Hcont_VV(nsync, wf27(:,3), wf4(:,12), A(:,118), n3(:,279), t3x108(:,:,118), nhel, den(33))
    call Hcont_VV(nsync, wf27(:,3), wf4(:,13), A(:,119), n3(:,280), t3x108(:,:,119), nhel, den(32))
    call Hcont_SS(nsync, wf12(:,1), wf9(:,7), A(:,120), n3(:,281), t3x108(:,:,120), nhel, den(36))
    call Hcont_SS(nsync, wf12(:,2), wf9(:,7), A(:,121), n3(:,282), t3x108(:,:,121), nhel, den(36))
    call Hcont_SS(nsync, wf4(:,8), wf27(:,4), A(:,122), n3(:,283), t3x108(:,:,122), nhel, den(38))
    call Hcont_VV(nsync, wf4(:,9), wf27(:,5), A(:,123), n3(:,284), t3x108(:,:,123), nhel, den(38))
    call Hcont_SS(nsync, wf4(:,10), wf27(:,4), A(:,124), n3(:,285), t3x108(:,:,124), nhel, den(39))
    call Hcont_SS(nsync, wf4(:,11), wf27(:,4), A(:,125), n3(:,286), t3x108(:,:,125), nhel, den(38))
    call Hcont_VV(nsync, wf4(:,12), wf27(:,5), A(:,126), n3(:,287), t3x108(:,:,126), nhel, den(39))
    call Hcont_VV(nsync, wf4(:,13), wf27(:,5), A(:,127), n3(:,288), t3x108(:,:,127), nhel, den(38))
    call Hcont_SS(nsync, wf12(:,3), wf9(:,8), A(:,128), n3(:,289), t3x108(:,:,128), nhel, den(42))
    call Hcont_SS(nsync, wf12(:,4), wf9(:,8), A(:,129), n3(:,290), t3x108(:,:,129), nhel, den(42))
    call Hcont_SS(nsync, wf4(:,8), wf27(:,6), A(:,130), n3(:,291), t3x108(:,:,130), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,9), wf27(:,7), A(:,131), n3(:,292), t3x108(:,:,131), nhel, den(44))
    call Hcont_SS(nsync, wf4(:,10), wf27(:,6), A(:,132), n3(:,293), t3x108(:,:,132), nhel, den(45))
    call Hcont_SS(nsync, wf4(:,11), wf27(:,6), A(:,133), n3(:,294), t3x108(:,:,133), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,12), wf27(:,7), A(:,134), n3(:,295), t3x108(:,:,134), nhel, den(45))
    call Hcont_VV(nsync, wf4(:,13), wf27(:,7), A(:,135), n3(:,296), t3x108(:,:,135), nhel, den(44))
    call Hcont_SS(nsync, wf12(:,5), wf9(:,9), A(:,136), n3(:,297), t3x108(:,:,136), nhel, den(48))
    call Hcont_SS(nsync, wf12(:,6), wf9(:,9), A(:,137), n3(:,298), t3x108(:,:,137), nhel, den(48))
    call Hcont_QA(nsync, wf6(:,37), wf18(:,32), A(:,138), n3(:,299), t3x108(:,:,138), nhel, den(51))
    call Hcont_QA(nsync, wf18(:,32), wf6(:,38), A(:,139), n3(:,300), t3x108(:,:,139), nhel, den(51))
    call Hcont_QA(nsync, wf6(:,39), wf18(:,33), A(:,140), n3(:,301), t3x108(:,:,140), nhel, den(54))
    call Hcont_QA(nsync, wf18(:,33), wf6(:,40), A(:,141), n3(:,302), t3x108(:,:,141), nhel, den(54))
    call Hcont_QA(nsync, wf6(:,37), wf18(:,35), A(:,142), n3(:,303), t3x108(:,:,142), nhel, den(56))
    call Hcont_QA(nsync, wf6(:,38), wf18(:,35), A(:,143), n3(:,304), t3x108(:,:,143), nhel, den(56))
    call Hcont_QA(nsync, wf6(:,41), wf18(:,36), A(:,144), n3(:,305), t3x108(:,:,144), nhel, den(59))
    call Hcont_QA(nsync, wf18(:,36), wf6(:,42), A(:,145), n3(:,306), t3x108(:,:,145), nhel, den(59))
    call Hcont_QA(nsync, wf6(:,37), wf18(:,38), A(:,146), n3(:,307), t3x108(:,:,146), nhel, den(61))
    call Hcont_QA(nsync, wf6(:,38), wf18(:,38), A(:,147), n3(:,308), t3x108(:,:,147), nhel, den(61))
    call Hcont_SS(nsync, wf12(:,7), wf9(:,9), A(:,148), n3(:,309), t3x108(:,:,148), nhel, den(63))
    call Hcont_QA(nsync, wf6(:,43), wf18(:,40), A(:,149), n3(:,310), t3x108(:,:,149), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,40), wf6(:,44), A(:,150), n3(:,311), t3x108(:,:,150), nhel, den(66))
    call Hcont_QA(nsync, wf6(:,45), wf18(:,41), A(:,151), n3(:,312), t3x108(:,:,151), nhel, den(69))
    call Hcont_QA(nsync, wf18(:,41), wf6(:,46), A(:,152), n3(:,313), t3x108(:,:,152), nhel, den(69))
    call Hcont_QA(nsync, wf6(:,47), wf18(:,43), A(:,153), n3(:,314), t3x108(:,:,153), nhel, den(72))
    call Hcont_QA(nsync, wf18(:,43), wf6(:,48), A(:,154), n3(:,315), t3x108(:,:,154), nhel, den(72))
    call Hcont_QA(nsync, wf6(:,45), wf18(:,44), A(:,155), n3(:,316), t3x108(:,:,155), nhel, den(74))
    call Hcont_QA(nsync, wf6(:,46), wf18(:,44), A(:,156), n3(:,317), t3x108(:,:,156), nhel, den(74))
    call Hcont_QA(nsync, wf6(:,45), wf18(:,46), A(:,157), n3(:,318), t3x108(:,:,157), nhel, den(76))
    call Hcont_QA(nsync, wf6(:,46), wf18(:,46), A(:,158), n3(:,319), t3x108(:,:,158), nhel, den(76))
    call Hcont_SS(nsync, wf12(:,8), wf9(:,9), A(:,159), n3(:,320), t3x108(:,:,159), nhel, den(78))
    call Hcont_QA(nsync, wf6(:,43), wf18(:,48), A(:,160), n3(:,321), t3x108(:,:,160), nhel, den(80))
    call Hcont_QA(nsync, wf6(:,44), wf18(:,48), A(:,161), n3(:,322), t3x108(:,:,161), nhel, den(80))
    call Hcont_QA(nsync, wf6(:,41), wf18(:,49), A(:,162), n3(:,323), t3x108(:,:,162), nhel, den(82))
    call Hcont_QA(nsync, wf6(:,42), wf18(:,49), A(:,163), n3(:,324), t3x108(:,:,163), nhel, den(82))
    call Hcont_QA(nsync, wf6(:,43), wf18(:,51), A(:,164), n3(:,325), t3x108(:,:,164), nhel, den(84))
    call Hcont_QA(nsync, wf6(:,44), wf18(:,51), A(:,165), n3(:,326), t3x108(:,:,165), nhel, den(84))
    call Hcont_SS(nsync, wf12(:,9), wf9(:,8), A(:,166), n3(:,327), t3x108(:,:,166), nhel, den(86))
    call Hcont_QA(nsync, wf6(:,47), wf18(:,53), A(:,167), n3(:,328), t3x108(:,:,167), nhel, den(88))
    call Hcont_QA(nsync, wf6(:,48), wf18(:,53), A(:,168), n3(:,329), t3x108(:,:,168), nhel, den(88))
    call Hcont_QA(nsync, wf6(:,39), wf18(:,54), A(:,169), n3(:,330), t3x108(:,:,169), nhel, den(90))
    call Hcont_QA(nsync, wf6(:,40), wf18(:,54), A(:,170), n3(:,331), t3x108(:,:,170), nhel, den(90))
    call Hcont_QA(nsync, wf6(:,39), wf18(:,56), A(:,171), n3(:,332), t3x108(:,:,171), nhel, den(92))
    call Hcont_QA(nsync, wf6(:,40), wf18(:,56), A(:,172), n3(:,333), t3x108(:,:,172), nhel, den(92))
    call Hcont_SS(nsync, wf12(:,10), wf9(:,8), A(:,173), n3(:,334), t3x108(:,:,173), nhel, den(94))
    call Hcont_QA(nsync, wf6(:,47), wf18(:,58), A(:,174), n3(:,335), t3x108(:,:,174), nhel, den(96))
    call Hcont_QA(nsync, wf6(:,48), wf18(:,58), A(:,175), n3(:,336), t3x108(:,:,175), nhel, den(96))
    call Hcont_SS(nsync, wf12(:,11), wf9(:,7), A(:,176), n3(:,337), t3x108(:,:,176), nhel, den(98))
    call Hcont_QA(nsync, wf6(:,41), wf18(:,60), A(:,177), n3(:,338), t3x108(:,:,177), nhel, den(100))
    call Hcont_QA(nsync, wf6(:,42), wf18(:,60), A(:,178), n3(:,339), t3x108(:,:,178), nhel, den(100))
    call Hcont_SS(nsync, wf12(:,12), wf9(:,7), A(:,179), n3(:,340), t3x108(:,:,179), nhel, den(102))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(2) ! M1helarray(2,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,7)%j-A(j,8)%j-A(j,10)%j-A(j,11)%j-A(j,13)%j-A(j,15)%j)*f(1)+(-A(j,1)%j-A(j,3)%j-A(j,5)%j)*f(7)+(A(j,9)%j &
       +A(j,12)%j+A(j,14)%j+A(j,16)%j+A(j,17)%j+A(j,18)%j)*f(11)+(A(j,2)%j+A(j,4)%j+A(j,6)%j)*f(21)

  M2(1)%j = (A(j,138)%j+A(j,140)%j+A(j,142)%j+A(j,144)%j+A(j,149)%j+A(j,151)%j+A(j,153)%j+A(j,155)%j+A(j,160)%j+A(j,162)%j &
       +A(j,167)%j+A(j,169)%j)*f(5)+(-A(j,36)%j-A(j,38)%j-A(j,41)%j-A(j,43)%j-A(j,46)%j-A(j,49)%j-A(j,56)%j-A(j,58)%j-A(j,62)%j &
       -A(j,68)%j-A(j,72)%j-A(j,74)%j-A(j,80)%j-A(j,82)%j-A(j,86)%j-A(j,92)%j-A(j,96)%j-A(j,98)%j)*f(6)+(-A(j,102)%j-A(j,106)%j &
       -A(j,110)%j)*f(9)+(-A(j,146)%j-A(j,157)%j-A(j,164)%j-A(j,171)%j-A(j,174)%j-A(j,177)%j)*f(15)+(A(j,54)%j+A(j,60)%j+A(j,64)%j &
       +A(j,78)%j+A(j,84)%j+A(j,88)%j)*f(16)+(A(j,66)%j+A(j,70)%j+A(j,76)%j+A(j,90)%j+A(j,94)%j+A(j,100)%j)*f(17)+(A(j,104)%j &
       +A(j,108)%j+A(j,112)%j)*f(24)
  M2(2)%j = (-A(j,37)%j-A(j,39)%j-A(j,42)%j-A(j,44)%j-A(j,47)%j-A(j,50)%j-A(j,57)%j-A(j,59)%j-A(j,63)%j-A(j,69)%j-A(j,73)%j &
       -A(j,75)%j-A(j,81)%j-A(j,83)%j-A(j,87)%j-A(j,93)%j-A(j,97)%j-A(j,99)%j+A(j,139)%j+A(j,141)%j+A(j,143)%j+A(j,145)%j &
       +A(j,150)%j+A(j,152)%j+A(j,154)%j+A(j,156)%j+A(j,161)%j+A(j,163)%j+A(j,168)%j+A(j,170)%j)*f(2)-A(j,19)%j*f(3) &
       -A(j,20)%j*f(4)+(A(j,114)%j+A(j,120)%j+A(j,122)%j+A(j,128)%j+A(j,130)%j+A(j,136)%j)*f(8)+(A(j,115)%j+A(j,123)%j &
       +A(j,131)%j)*f(10)+(-A(j,103)%j-A(j,107)%j-A(j,111)%j)*f(12)+(A(j,67)%j+A(j,71)%j+A(j,77)%j+A(j,91)%j+A(j,95)%j+A(j,101)%j &
       -A(j,147)%j-A(j,148)%j-A(j,158)%j-A(j,159)%j-A(j,165)%j-A(j,166)%j-A(j,172)%j-A(j,173)%j-A(j,175)%j-A(j,176)%j-A(j,178)%j &
       -A(j,179)%j)*f(13)+(A(j,21)%j+A(j,24)%j+A(j,29)%j)*f(14)+(-A(j,27)%j-A(j,32)%j-A(j,34)%j)*f(18)+(-A(j,116)%j-A(j,124)%j &
       -A(j,132)%j)*f(19)+(-A(j,117)%j-A(j,125)%j-A(j,133)%j)*f(20)+(-A(j,118)%j-A(j,126)%j-A(j,134)%j)*f(22)+(A(j,105)%j &
       +A(j,109)%j+A(j,113)%j-A(j,119)%j-A(j,121)%j-A(j,127)%j-A(j,129)%j-A(j,135)%j-A(j,137)%j)*f(23)+(-A(j,55)%j-A(j,61)%j &
       -A(j,65)%j-A(j,79)%j-A(j,85)%j-A(j,89)%j)*f(25)+(A(j,40)%j+A(j,45)%j+A(j,48)%j+A(j,51)%j+A(j,52)%j+A(j,53)%j)*f(26) &
       +(A(j,22)%j+A(j,25)%j+A(j,30)%j)*f(27)+(A(j,23)%j+A(j,26)%j+A(j,28)%j+A(j,31)%j+A(j,33)%j+A(j,35)%j)*f(28)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxzzz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxzzz_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxzzz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxzzz_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxzzz_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppvvv_ew_bbxzzz_1_/**/REALKIND
