
module ol_colourmatrix_ppvvv_ew_bbxzwwx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,2), KL(17,2), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2( 1,:) = [ 0, 3]
  K2( 2,:) = [ 0, 0]
  K2( 3,:) = [ 0, 0]
  K2( 4,:) = [ 0, 0]
  K2( 5,:) = [ 0, 0]
  K2( 6,:) = [ 0, 0]
  K2( 7,:) = [ 0, 0]
  K2( 8,:) = [ 0, 0]
  K2( 9,:) = [ 0, 0]
  K2(10,:) = [ 0, 0]
  K2(11,:) = [ 0, 0]
  K2(12,:) = [ 0, 0]
  K2(13,:) = [ 0, 0]
  K2(14,:) = [ 0, 0]
  K2(15,:) = [ 0, 0]
  K2(16,:) = [ 0, 0]
  K2(17,:) = [ 0, 3]

  KL( 1,:) = [ 3, 0]
  KL( 2,:) = [ 0, 0]
  KL( 3,:) = [ 0, 0]
  KL( 4,:) = [ 0, 0]
  KL( 5,:) = [ 0, 0]
  KL( 6,:) = [ 0, 0]
  KL( 7,:) = [ 0, 0]
  KL( 8,:) = [ 0, 0]
  KL( 9,:) = [ 0, 0]
  KL(10,:) = [ 0, 0]
  KL(11,:) = [ 0, 0]
  KL(12,:) = [ 0, 0]
  KL(13,:) = [ 0, 0]
  KL(14,:) = [ 0, 0]
  KL(15,:) = [ 0, 0]
  KL(16,:) = [ 0, 0]
  KL(17,:) = [ 3, 0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvv_ew_bbxzwwx_1_/**/REALKIND



module ol_forced_parameters_ppvvv_ew_bbxzwwx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvv_ew_bbxzwwx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppvvv_ew_bbxzwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 108 ! number of helicity configurations
  integer(intkind2), save :: nhel = 108 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 108 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(108) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(164)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(3), ex4(3), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,22), wf6(6,28), wf9(9,26), wf12(12,116), wf18(18,40), wf27(27,14), wf108(108,311)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(913), c(815)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppvvv_ew_bbxzwwx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppvvv_ew_bbxzwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppvvv_ew_bbxzwwx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*eQED**3)/3._/**/REALKIND
    f(  2) = (CI*countertermnorm*eQED**5)/3._/**/REALKIND
    f(  3) = CI*countertermnorm*eQED**5
    f(  4) = (CI*countertermnorm*eQED**5*EWctAWW)/3._/**/REALKIND
    f(  5) = (CI*countertermnorm*eQED**5*EWctZWW)/3._/**/REALKIND
    f(  6) = CI*countertermnorm*eQED**5*EWctZWW
    f(  7) = (CI*countertermnorm*eQED**3*gQCD**2)/3._/**/REALKIND
    f(  8) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/3._/**/REALKIND
    f(  9) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*cw)
    f( 10) = (countertermnorm*eQED**5*MB)/(cw*2._/**/REALKIND)
    f( 11) = (CI*countertermnorm*eQED**5*EWctWPH*MB)/(2._/**/REALKIND*cw)
    f( 12) = (countertermnorm*eQED**5*EWctWPX*MB)/(cw*2._/**/REALKIND)
    f( 13) = CI*countertermnorm*eQED**5*MW
    f( 14) = (countertermnorm*eQED**5*MW)/(cw*6._/**/REALKIND)
    f( 15) = (countertermnorm*eQED**5*MW)/(cw*2._/**/REALKIND)
    f( 16) = (CI*countertermnorm*eQED**5*EWctPWZ*MW)/3._/**/REALKIND
    f( 17) = (countertermnorm*eQED**5*MB*MW)/(cw*2._/**/REALKIND)
    f( 18) = (CI*countertermnorm*eQED**5)/(cw*sqrt2)
    f( 19) = (CI*cw*eQED**3)/(2._/**/REALKIND*sw**3)
    f( 20) = (CI*countertermnorm*cw*eQED**5)/(2._/**/REALKIND*sw**3)
    f( 21) = (CI*countertermnorm*cw*eQED**5*EWctVbt)/(2._/**/REALKIND*sw**3)
    f( 22) = (CI*countertermnorm*cw*eQED**5*EWctVtb)/(2._/**/REALKIND*sw**3)
    f( 23) = (CI*countertermnorm*cw*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**3)
    f( 24) = (CI*countertermnorm*ctVbt*cw*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**3)
    f( 25) = (CI*eQED**3*MB)/(4._/**/REALKIND*cw*sw**3)
    f( 26) = (CI*eQED**3*MB)/(2._/**/REALKIND*cw*sw**3)
    f( 27) = (CI*cw*eQED**3*MB)/(2._/**/REALKIND*sw**3)
    f( 28) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*cw*sw**3)
    f( 29) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*cw*sw**3)
    f( 30) = (CI*countertermnorm*cw*eQED**5*MB)/(2._/**/REALKIND*sw**3)
    f( 31) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw*sw**3)
    f( 32) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*cw*sw**3)
    f( 33) = (CI*countertermnorm*ctSbb*cw*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*sw**3)
    f( 34) = (CI*countertermnorm*cw*eQED**5)/(2._/**/REALKIND*MW*sw**3)
    f( 35) = (countertermnorm*eQED**5*MB)/(MW*sw**3*4._/**/REALKIND)
    f( 36) = (CI*countertermnorm*cw*eQED**5*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 37) = (countertermnorm*cw**2*eQED**5*MB)/(MW*sw**3*2._/**/REALKIND)
    f( 38) = (countertermnorm*eQED**5*MB*MW)/(cw**2*sw**3*2._/**/REALKIND)
    f( 39) = (CI*eQED**3)/(2._/**/REALKIND*sw**2)
    f( 40) = (CI*cw**2*eQED**3)/sw**2
    f( 41) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*sw**2)
    f( 42) = (CI*countertermnorm*cw**2*eQED**5)/(3._/**/REALKIND*sw**2)
    f( 43) = (CI*countertermnorm*cw**2*eQED**5)/sw**2
    f( 44) = (CI*countertermnorm*eQED**5*EWctVbt)/(2._/**/REALKIND*sw**2)
    f( 45) = (CI*countertermnorm*eQED**5*EWctVtb)/(2._/**/REALKIND*sw**2)
    f( 46) = (CI*countertermnorm*eQED**5*EWctZWW)/(2._/**/REALKIND*sw**2)
    f( 47) = (CI*countertermnorm*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 48) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 49) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 50) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 51) = (CI*countertermnorm*ctVbb*cw**2*eQED**3*gQCD**2)/sw**2
    f( 52) = (CI*eQED**3*MB)/(2._/**/REALKIND*sw**2)
    f( 53) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*sw**2)
    f( 54) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 55) = (CI*countertermnorm*eQED**5*MB)/(cw*sw**2)
    f( 56) = (countertermnorm*eQED**5*MB)/(cw*sw**2*2._/**/REALKIND)
    f( 57) = (CI*countertermnorm*cw*eQED**5*MB)/sw**2
    f( 58) = (CI*countertermnorm*eQED**5*EWctZWW*MB)/(2._/**/REALKIND*sw**2)
    f( 59) = (CI*countertermnorm*eQED**5*EWctZWW*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 60) = (countertermnorm*eQED**5*EWctZXH*MB)/(sw**2*2._/**/REALKIND)
    f( 61) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*sw**2)
    f( 62) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*sw**2)
    f( 63) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*sw**2)
    f( 64) = (CI*countertermnorm*eQED**5*EWctPWZ)/(2._/**/REALKIND*MW*sw**2)
    f( 65) = (countertermnorm*eQED**5*MB)/(cw*MW*sw**2*4._/**/REALKIND)
    f( 66) = (countertermnorm*cw*eQED**5*MB)/(MW*sw**2*2._/**/REALKIND)
    f( 67) = (CI*countertermnorm*eQED**5*EWctHWW*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 68) = (CI*countertermnorm*cw*eQED**5*EWctHWW*MB)/(2._/**/REALKIND*MW*sw**2)
    f( 69) = (CI*countertermnorm*cw*eQED**5*EWctHZZ*MB)/(2._/**/REALKIND*MW*sw**2)
    f( 70) = (CI*countertermnorm*eQED**5*EWctPWZ*MB)/(4._/**/REALKIND*MW*sw**2)
    f( 71) = (countertermnorm*eQED**5*MW)/(cw*sw**2*6._/**/REALKIND)
    f( 72) = (countertermnorm*eQED**5*MW)/(cw*sw**2*2._/**/REALKIND)
    f( 73) = (CI*eQED**3*MW**2)/(cw**2*sw**2)
    f( 74) = (CI*countertermnorm*eQED**5*MW**2)/(3._/**/REALKIND*cw**2*sw**2)
    f( 75) = (CI*countertermnorm*eQED**5*MW**2)/(cw**2*sw**2)
    f( 76) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW**2)/(cw**2*sw**2)
    f( 77) = (CI*eQED**3)/(2._/**/REALKIND*cw*sw)
    f( 78) = (CI*cw*eQED**3)/(3._/**/REALKIND*sw)
    f( 79) = (CI*cw*eQED**3)/sw
    f( 80) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*cw*sw)
    f( 81) = (CI*countertermnorm*cw*eQED**5)/(3._/**/REALKIND*sw)
    f( 82) = (CI*countertermnorm*cw*eQED**5)/sw
    f( 83) = (CI*countertermnorm*cw*eQED**5*EWctAWW)/(3._/**/REALKIND*sw)
    f( 84) = (CI*countertermnorm*eQED**5*EWctVbt)/(2._/**/REALKIND*cw*sw)
    f( 85) = (CI*countertermnorm*eQED**5*EWctVtb)/(2._/**/REALKIND*cw*sw)
    f( 86) = (CI*countertermnorm*cw*eQED**5*EWctZWW)/sw
    f( 87) = (CI*countertermnorm*eQED**3*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f( 88) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f( 89) = (CI*countertermnorm*cw*eQED**3*gQCD**2)/sw
    f( 90) = (CI*countertermnorm*ctVbb*cw*eQED**3*gQCD**2)/(3._/**/REALKIND*sw)
    f( 91) = (CI*countertermnorm*ctVbb*cw*eQED**3*gQCD**2)/sw
    f( 92) = (CI*eQED**3*MB)/(4._/**/REALKIND*cw*sw)
    f( 93) = (CI*countertermnorm*eQED**5*MB)/sw
    f( 94) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*cw*sw)
    f( 95) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw*sw)
    f( 96) = (countertermnorm*eQED**5*MB)/(MW*sw*2._/**/REALKIND)
    f( 97) = (CI*countertermnorm*eQED**5*EWctHWW*MB)/(2._/**/REALKIND*MW*sw)
    f( 98) = (CI*countertermnorm*eQED**5*EWctHZA*MB)/(2._/**/REALKIND*MW*sw)
    f( 99) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*cw*sw)
    f(100) = (CI*countertermnorm*cw*eQED**5*MW)/(3._/**/REALKIND*sw)
    f(101) = (CI*countertermnorm*eQED**5*EWctHWW*MW)/(cw**2*sw)
    f(102) = (CI*countertermnorm*eQED**5*EWctHZA*MW)/(3._/**/REALKIND*sw)
    f(103) = (CI*countertermnorm*eQED**5*EWctHZZ*MW)/sw
    f(104) = (CI*countertermnorm*eQED**5*MB*MW)/(2._/**/REALKIND*cw*sw)
    f(105) = (CI*countertermnorm*eQED**5*MW*sw)/(3._/**/REALKIND*cw)
    f(106) = (CI*countertermnorm*eQED**5*EWctPWA*MW*sw)/(3._/**/REALKIND*cw)
    f(107) = (CI*countertermnorm*eQED**5*EWctPWZ*MW*sw)/cw
    f(108) = (countertermnorm*eQED**5*MB*MW*sw)/(cw**2*2._/**/REALKIND)
    f(109) = (CI*eQED**3*MW**2*sw)/(3._/**/REALKIND*cw)
    f(110) = (CI*countertermnorm*eQED**5*MW**2*sw)/(3._/**/REALKIND*cw)
    f(111) = (CI*countertermnorm*eQED**5*MW**2*sw)/cw
    f(112) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW**2*sw)/(3._/**/REALKIND*cw)
    f(113) = (CI*eQED**3*MW**2*sw**2)/cw**2
    f(114) = (CI*countertermnorm*eQED**5*MW**2*sw**2)/(3._/**/REALKIND*cw**2)
    f(115) = (CI*countertermnorm*eQED**5*MW**2*sw**2)/cw**2
    f(116) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW**2*sw**2)/cw**2
    f(117) = (eQED**5*integralnorm*SwB)/27._/**/REALKIND
    f(118) = (eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f(119) = (eQED**5*integralnorm*SwB)/3._/**/REALKIND
    f(120) = (eQED**5*integralnorm*SwB)/(cw**2*4._/**/REALKIND)
    f(121) = (eQED**5*integralnorm*SwB)/(cw**2*2._/**/REALKIND)
    f(122) = (eQED**3*gQCD**2*integralnorm*SwB)/3._/**/REALKIND
    f(123) = (eQED**5*integralnorm*MB*SwB)/(cw**2*4._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*4._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*4._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*4._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*MH**4*SwB)/(cw**2*4._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f(129) = (eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f(130) = eQED**5*integralnorm*MW**2*SwB
    f(131) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*4._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*4._/**/REALKIND)
    f(134) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f(135) = (eQED**5*integralnorm*MW**2*SwB)/cw**2
    f(136) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f(137) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f(138) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MW**4*SwB)/cw**6
    f(141) = (eQED**5*integralnorm*MW**4*SwB)/cw**4
    f(142) = (eQED**5*integralnorm*MW**4*SwB)/cw**2
    f(143) = (eQED**5*integralnorm*SwB)/(cw*sw**5*16._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(145) = (eQED**5*integralnorm*SwB)/(cw*sw**5*4._/**/REALKIND)
    f(146) = (cw*eQED**5*integralnorm*SwB)/(sw**5*8._/**/REALKIND)
    f(147) = (cw*eQED**5*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f(148) = (cw*eQED**5*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f(149) = (cw**3*eQED**5*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f(150) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**5*16._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**5*8._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**5*4._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**5*16._/**/REALKIND)
    f(154) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(155) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**5*4._/**/REALKIND)
    f(156) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**5*2._/**/REALKIND)
    f(157) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**5*8._/**/REALKIND)
    f(158) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**5*4._/**/REALKIND)
    f(159) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**5*2._/**/REALKIND)
    f(160) = (cw**3*eQED**5*integralnorm*MB*SwB)/(sw**5*4._/**/REALKIND)
    f(161) = (cw**3*eQED**5*integralnorm*MB*SwB)/(sw**5*2._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*MB**2*SwB)/(cw**3*sw**5*8._/**/REALKIND)
    f(163) = (eQED**5*integralnorm*MB**2*SwB)/(cw**3*sw**5*4._/**/REALKIND)
    f(164) = (eQED**5*integralnorm*MB**2*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*MB**2*SwB)/(cw*sw**5*4._/**/REALKIND)
    f(166) = (cw*eQED**5*integralnorm*MB**2*SwB)/(sw**5*4._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**3*sw**5*8._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(169) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**3*sw**5*8._/**/REALKIND)
    f(170) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**3*sw**5*4._/**/REALKIND)
    f(171) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(172) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*sw**5*4._/**/REALKIND)
    f(173) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(sw**5*4._/**/REALKIND)
    f(174) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**5*4._/**/REALKIND)
    f(176) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**5*4._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(178) = (cw*eQED**5*integralnorm*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(179) = (cw*eQED**5*integralnorm*SwB)/(MW**2*sw**5*4._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*MB*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(181) = (cw*eQED**5*integralnorm*MB*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(182) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND)
    f(183) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND)
    f(185) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(186) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*MB**3*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*MB**3*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND)
    f(189) = (cw*eQED**5*integralnorm*MB**3*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(190) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(191) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW**2*sw**5*4._/**/REALKIND)
    f(192) = (cw*eQED**5*integralnorm*MH**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(193) = (cw*eQED**5*integralnorm*MH**2*SwB)/(MW**2*sw**5*4._/**/REALKIND)
    f(194) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(196) = (cw*eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(197) = (cw*eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(198) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND)
    f(199) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(200) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(201) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(202) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND)
    f(203) = (cw*eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(204) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(205) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND)
    f(206) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(207) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND)
    f(208) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(209) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND)
    f(210) = (cw*eQED**5*integralnorm*MB*MH**4*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(211) = (cw*eQED**5*integralnorm*MB*MH**4*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(212) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(213) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND)
    f(214) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(215) = (9*cw*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(216) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(217) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND)
    f(218) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**2*sw**5*4._/**/REALKIND)
    f(219) = (cw*eQED**5*integralnorm*MT*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(220) = (cw*eQED**5*integralnorm*MT*SwB)/(MW**2*sw**5*4._/**/REALKIND)
    f(221) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(222) = (cw*eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(223) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(224) = (cw*eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(225) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**5*2._/**/REALKIND)
    f(226) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**5*2._/**/REALKIND)
    f(227) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**5*sw**5*16._/**/REALKIND)
    f(228) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**5*sw**5*8._/**/REALKIND)
    f(229) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**5*sw**5*4._/**/REALKIND)
    f(230) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**5*sw**5*2._/**/REALKIND)
    f(231) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw**5*8._/**/REALKIND)
    f(232) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw**5*4._/**/REALKIND)
    f(233) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw**5*2._/**/REALKIND)
    f(234) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw**5*16._/**/REALKIND)
    f(235) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw**5*4._/**/REALKIND)
    f(237) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw**5*2._/**/REALKIND)
    f(238) = (cw*eQED**5*integralnorm*MB*MW**2*SwB)/(sw**5*8._/**/REALKIND)
    f(239) = (cw*eQED**5*integralnorm*MB*MW**2*SwB)/(sw**5*2._/**/REALKIND)
    f(240) = (eQED**5*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f(241) = (eQED**5*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(242) = (eQED**5*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f(243) = (eQED**5*integralnorm*SwB)/(cw**2*sw**4*16._/**/REALKIND)
    f(244) = (eQED**5*integralnorm*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(245) = (eQED**5*integralnorm*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(246) = (eQED**5*integralnorm*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(247) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(248) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f(249) = (cw**2*eQED**5*integralnorm*SwB)/sw**4
    f(250) = (cw**4*eQED**5*integralnorm*SwB)/sw**4
    f(251) = (eQED**5*integralnorm*MB*SwB)/(sw**4*8._/**/REALKIND)
    f(252) = (eQED**5*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f(253) = (eQED**5*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f(254) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(255) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(256) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f(257) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f(258) = (eQED**5*integralnorm*MB**2*SwB)/(sw**4*4._/**/REALKIND)
    f(259) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(260) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(261) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(262) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(263) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(sw**4*4._/**/REALKIND)
    f(264) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(265) = (eQED**5*integralnorm*MH**4*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(266) = (eQED**5*integralnorm*MH**4*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(267) = (9*eQED**5*integralnorm*lambdaHHH**2*MH**4*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(268) = (eQED**5*integralnorm*MT*SwB)/(sw**4*4._/**/REALKIND)
    f(269) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(270) = (eQED**5*integralnorm*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(271) = (eQED**5*integralnorm*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(272) = (cw**2*eQED**5*integralnorm*SwB)/(MW**2*sw**4*2._/**/REALKIND)
    f(273) = (eQED**5*integralnorm*MB*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(274) = (eQED**5*integralnorm*MB*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(275) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(276) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(277) = (cw**2*eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(278) = (eQED**5*integralnorm*MB**3*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(279) = (eQED**5*integralnorm*MH**2*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(280) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(281) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(282) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(283) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(284) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(285) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(286) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(287) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(288) = (eQED**5*integralnorm*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(289) = (eQED**5*integralnorm*MT*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(290) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(291) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(292) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*4._/**/REALKIND)
    f(293) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f(294) = (eQED**5*integralnorm*MW**2*SwB)/sw**4
    f(295) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(296) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**4*2._/**/REALKIND)
    f(297) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(298) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(299) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**4)
    f(300) = (cw**2*eQED**5*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f(301) = (cw**2*eQED**5*integralnorm*MW**2*SwB)/sw**4
    f(302) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**4*8._/**/REALKIND)
    f(303) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f(304) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f(305) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(306) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*sw**4*2._/**/REALKIND)
    f(307) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(308) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW**2*SwB)/(cw**4*sw**4*2._/**/REALKIND)
    f(309) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(310) = (eQED**5*integralnorm*MW**4*SwB)/(cw**6*sw**4*4._/**/REALKIND)
    f(311) = (eQED**5*integralnorm*MW**4*SwB)/(cw**6*sw**4*2._/**/REALKIND)
    f(312) = (eQED**5*integralnorm*MW**4*SwB)/(cw**6*sw**4)
    f(313) = (eQED**5*integralnorm*MW**4*SwB)/(cw**4*sw**4)
    f(314) = (eQED**5*integralnorm*MW**4*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(315) = (eQED**5*integralnorm*MW**4*SwB)/(cw**2*sw**4)
    f(316) = (eQED**5*integralnorm*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(317) = (eQED**5*integralnorm*SwB)/(cw*sw**3*24._/**/REALKIND)
    f(318) = (eQED**5*integralnorm*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(319) = (eQED**5*integralnorm*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(320) = (eQED**5*integralnorm*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(321) = (cw*eQED**5*integralnorm*SwB)/(sw**3*18._/**/REALKIND)
    f(322) = (cw*eQED**5*integralnorm*SwB)/(sw**3*12._/**/REALKIND)
    f(323) = (cw*eQED**5*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f(324) = (cw*eQED**5*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f(325) = (2*cw*eQED**5*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f(326) = (cw*eQED**5*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f(327) = (cw*eQED**5*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(328) = (cw*eQED**5*integralnorm*SwB)/sw**3
    f(329) = (cw**3*eQED**5*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f(330) = (cw**3*eQED**5*integralnorm*SwB)/sw**3
    f(331) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(332) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**3*16._/**/REALKIND)
    f(333) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**3*8._/**/REALKIND)
    f(334) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(335) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*36._/**/REALKIND)
    f(336) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*24._/**/REALKIND)
    f(337) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*18._/**/REALKIND)
    f(338) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*16._/**/REALKIND)
    f(339) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*12._/**/REALKIND)
    f(340) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(341) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*6._/**/REALKIND)
    f(342) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(343) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(344) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*18._/**/REALKIND)
    f(345) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*12._/**/REALKIND)
    f(346) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*6._/**/REALKIND)
    f(347) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*4._/**/REALKIND)
    f(348) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*2._/**/REALKIND)
    f(349) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(350) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(351) = (cw*eQED**3*gQCD**2*integralnorm*MB*SwB)/(sw**3*2._/**/REALKIND)
    f(352) = (eQED**5*integralnorm*MB**2*SwB)/(cw**3*sw**3*8._/**/REALKIND)
    f(353) = (eQED**5*integralnorm*MB**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(354) = (eQED**5*integralnorm*MH**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(355) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw**3*24._/**/REALKIND)
    f(356) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(357) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw**3*6._/**/REALKIND)
    f(358) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(359) = (cw*eQED**5*integralnorm*MH**2*SwB)/(sw**3*12._/**/REALKIND)
    f(360) = (cw*eQED**5*integralnorm*MH**2*SwB)/(sw**3*6._/**/REALKIND)
    f(361) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**3*sw**3*8._/**/REALKIND)
    f(362) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(363) = (cw*eQED**5*integralnorm*MB*MH**2*SwB)/(sw**3*4._/**/REALKIND)
    f(364) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**3*sw**3*8._/**/REALKIND)
    f(365) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(366) = (eQED**5*integralnorm*MT*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(367) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(368) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(369) = (eQED**5*integralnorm*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(370) = (eQED**5*integralnorm*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(371) = (cw*eQED**5*integralnorm*SwB)/(MW**2*sw**3*3._/**/REALKIND)
    f(372) = (cw*eQED**5*integralnorm*SwB)/(MW**2*sw**3*2._/**/REALKIND)
    f(373) = (eQED**5*integralnorm*MB*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(374) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(375) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(376) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(377) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**3*12._/**/REALKIND)
    f(378) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**3*4._/**/REALKIND)
    f(379) = (eQED**5*integralnorm*MB**3*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(380) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(381) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(382) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(383) = (cw*eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**3*4._/**/REALKIND)
    f(384) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(385) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(386) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(387) = (eQED**5*integralnorm*MH**4*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(388) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw*MW**2*sw**3*32._/**/REALKIND)
    f(389) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(390) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(391) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw*MW**2*sw**3*32._/**/REALKIND)
    f(392) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(393) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(394) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(395) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(396) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(397) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*2._/**/REALKIND)
    f(398) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3)
    f(399) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*12._/**/REALKIND)
    f(400) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*6._/**/REALKIND)
    f(401) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(402) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*3._/**/REALKIND)
    f(403) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(404) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3)
    f(405) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*6._/**/REALKIND)
    f(406) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*3._/**/REALKIND)
    f(407) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f(408) = (cw*eQED**5*integralnorm*MW**2*SwB)/sw**3
    f(409) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**5*sw**3*16._/**/REALKIND)
    f(410) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**5*sw**3*8._/**/REALKIND)
    f(411) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**5*sw**3*4._/**/REALKIND)
    f(412) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw**3*8._/**/REALKIND)
    f(413) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(414) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw**3*16._/**/REALKIND)
    f(415) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(416) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(417) = (cw*eQED**5*integralnorm*MB*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f(418) = (eQED**5*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f(419) = (eQED**5*integralnorm*SwB)/(sw**2*12._/**/REALKIND)
    f(420) = (eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(421) = (eQED**5*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(422) = (2*eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(423) = (eQED**5*integralnorm*SwB)/(sw**2*4._/**/REALKIND)
    f(424) = (eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(425) = (eQED**5*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(426) = (eQED**5*integralnorm*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(427) = (cw**2*eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(428) = (cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(429) = (cw**2*eQED**5*integralnorm*SwB)/sw**2
    f(430) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(431) = (cw**2*eQED**3*gQCD**2*integralnorm*SwB)/sw**2
    f(432) = (eQED**5*integralnorm*MB*SwB)/(sw**2*18._/**/REALKIND)
    f(433) = (eQED**5*integralnorm*MB*SwB)/(sw**2*12._/**/REALKIND)
    f(434) = (eQED**5*integralnorm*MB*SwB)/(sw**2*6._/**/REALKIND)
    f(435) = (eQED**5*integralnorm*MB*SwB)/(sw**2*4._/**/REALKIND)
    f(436) = (eQED**5*integralnorm*MB*SwB)/(sw**2*2._/**/REALKIND)
    f(437) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(438) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(439) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(sw**2*2._/**/REALKIND)
    f(440) = (eQED**5*integralnorm*MH**2*SwB)/(sw**2*6._/**/REALKIND)
    f(441) = (eQED**5*integralnorm*MH**2*SwB)/(sw**2*4._/**/REALKIND)
    f(442) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(443) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(444) = (eQED**5*integralnorm*MB*MH**2*SwB)/(sw**2*4._/**/REALKIND)
    f(445) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(446) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(447) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(448) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(449) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(450) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f(451) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*4._/**/REALKIND)
    f(452) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*3._/**/REALKIND)
    f(453) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(454) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**2*4._/**/REALKIND)
    f(455) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(456) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(457) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(458) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(459) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(460) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2)
    f(461) = (cw**2*eQED**5*integralnorm*MW**2*SwB)/sw**2
    f(462) = (eQED**3*gQCD**2*integralnorm*MW**2*SwB)/(cw**2*sw**2)
    f(463) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(464) = (eQED**5*integralnorm*SwB)/(cw*sw*18._/**/REALKIND)
    f(465) = (eQED**5*integralnorm*SwB)/(cw*sw*12._/**/REALKIND)
    f(466) = (eQED**5*integralnorm*SwB)/(cw*sw*9._/**/REALKIND)
    f(467) = (eQED**5*integralnorm*SwB)/(cw*sw*6._/**/REALKIND)
    f(468) = (2*eQED**5*integralnorm*SwB)/(cw*sw*9._/**/REALKIND)
    f(469) = (eQED**5*integralnorm*SwB)/(cw*sw*4._/**/REALKIND)
    f(470) = (eQED**5*integralnorm*SwB)/(cw*sw*3._/**/REALKIND)
    f(471) = (eQED**5*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(472) = (cw*eQED**5*integralnorm*SwB)/(sw*27._/**/REALKIND)
    f(473) = (cw*eQED**5*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(474) = (cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(475) = (cw*eQED**5*integralnorm*SwB)/sw
    f(476) = (eQED**3*gQCD**2*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(477) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(478) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/sw
    f(479) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw*8._/**/REALKIND)
    f(480) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*36._/**/REALKIND)
    f(481) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*12._/**/REALKIND)
    f(482) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(483) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(484) = (eQED**5*integralnorm*MB**2*SwB)/(cw**3*sw*8._/**/REALKIND)
    f(485) = (eQED**5*integralnorm*MB**2*SwB)/(cw*sw*12._/**/REALKIND)
    f(486) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw*12._/**/REALKIND)
    f(487) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**3*sw*8._/**/REALKIND)
    f(488) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*sw*12._/**/REALKIND)
    f(489) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(490) = (eQED**5*integralnorm*MH**4*SwB)/(cw*sw*12._/**/REALKIND)
    f(491) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*6._/**/REALKIND)
    f(492) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(493) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*12._/**/REALKIND)
    f(494) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(495) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*3._/**/REALKIND)
    f(496) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(497) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw*9._/**/REALKIND)
    f(498) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw*3._/**/REALKIND)
    f(499) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**5*sw*4._/**/REALKIND)
    f(500) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw*6._/**/REALKIND)
    f(501) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw*4._/**/REALKIND)
    f(502) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(503) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(504) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(505) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(506) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw**3*sw*6._/**/REALKIND)
    f(507) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(508) = (eQED**5*integralnorm*MW**4*SwB)/(cw**3*sw*3._/**/REALKIND)
    f(509) = (eQED**5*integralnorm*MW**4*SwB)/(cw*sw*3._/**/REALKIND)
    f(510) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw**3*2._/**/REALKIND)
    f(511) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*27._/**/REALKIND)
    f(512) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(513) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(514) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(515) = (eQED**5*integralnorm*MW**2*sw*SwB)/cw
    f(516) = (eQED**3*gQCD**2*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(517) = (eQED**5*integralnorm*MB*MW**2*sw*SwB)/(cw**3*4._/**/REALKIND)
    f(518) = (eQED**5*integralnorm*MW**4*sw*SwB)/(cw*3._/**/REALKIND)
    f(519) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*9._/**/REALKIND)
    f(520) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(521) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(522) = (eQED**3*gQCD**2*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(523) = (eQED**5*integralnorm*MW**4*sw**2*SwB)/cw**2
    f(524) = (eQED**5*integralnorm*MW**4*sw**3*SwB)/(cw**3*3._/**/REALKIND)
    f(525) = (eQED**5*integralnorm*MW**4*sw**4*SwB)/cw**4
    f(526) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**5*8._/**/REALKIND))
    f(527) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**5*4._/**/REALKIND))
    f(528) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*16._/**/REALKIND))
    f(529) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f(530) = -((cw*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**5*4._/**/REALKIND))
    f(531) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**5*16._/**/REALKIND))
    f(532) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**5*8._/**/REALKIND))
    f(533) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*16._/**/REALKIND))
    f(534) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f(535) = -((cw*eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(sw**5*8._/**/REALKIND))
    f(536) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**5*8._/**/REALKIND))
    f(537) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(538) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(539) = -((cw*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**5*4._/**/REALKIND))
    f(540) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(541) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(542) = -((eQED**5*integralnorm*MB**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND))
    f(543) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(544) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(545) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND))
    f(546) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(547) = -((cw*eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**5*8._/**/REALKIND))
    f(548) = (-3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND)
    f(549) = -((eQED**5*integralnorm*MB*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(550) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(551) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(552) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(553) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**4*8._/**/REALKIND))
    f(554) = -((eQED**5*integralnorm*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(555) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(556) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(557) = -((eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(558) = -((eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(559) = (eQED**5*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*16._/**/REALKIND)
    f(560) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**2*6._/**/REALKIND)
    f(561) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**2*2._/**/REALKIND)
    f(562) = -((eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(563) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(564) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(565) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(566) = -((eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(567) = -((eQED**5*integralnorm*MH**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(568) = (eQED**5*integralnorm*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(569) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**4*4._/**/REALKIND))
    f(570) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**4*8._/**/REALKIND))
    f(571) = (eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(572) = (eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw**2*4._/**/REALKIND)
    f(573) = -((eQED**5*integralnorm*MW**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(574) = (eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**2*2._/**/REALKIND)
    f(575) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*24._/**/REALKIND))
    f(576) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(577) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(578) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*6._/**/REALKIND))
    f(579) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(580) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*2._/**/REALKIND))
    f(581) = -((cw*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**3*6._/**/REALKIND))
    f(582) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*16._/**/REALKIND))
    f(583) = (eQED**5*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**3*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(584) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(585) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*24._/**/REALKIND))
    f(586) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(587) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(588) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*24._/**/REALKIND))
    f(589) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(590) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*6._/**/REALKIND))
    f(591) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(592) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(593) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(594) = (eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw*MW**2*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(595) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*6._/**/REALKIND))
    f(596) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw*MW**2*sw**5*2._/**/REALKIND*4._/**/REALKIND)
    f(597) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(598) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*2._/**/REALKIND))
    f(599) = (eQED**5*integralnorm*MB*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw*MW**2*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(600) = (eQED**5*integralnorm*MB*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw*MW**2*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(601) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(602) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(603) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*12._/**/REALKIND))
    f(604) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(605) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*6._/**/REALKIND))
    f(606) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(607) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(608) = -((cw*eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**3*6._/**/REALKIND))
    f(609) = -((eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*16._/**/REALKIND))
    f(610) = -((eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(611) = -((eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(612) = -((eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(613) = -((eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(614) = (eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**3*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(615) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**3*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(616) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(617) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw*sw**3*12._/**/REALKIND*6._/**/REALKIND)
    f(618) = (eQED**5*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw*sw**3*3._/**/REALKIND*6._/**/REALKIND)
    f(619) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(620) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(621) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(622) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(623) = (eQED**5*integralnorm*MB*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**3*sw**3*16._/**/REALKIND*8._/**/REALKIND)
    f(624) = (eQED**5*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**3*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(625) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*8._/**/REALKIND))
    f(626) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*8._/**/REALKIND))
    f(627) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(628) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*18._/**/REALKIND))
    f(629) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(630) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(631) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(632) = -((eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**5*sw*4._/**/REALKIND))
    f(633) = -((eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(634) = -((eQED**5*integralnorm*MW**4*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*12._/**/REALKIND))
    f(635) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**2*sw**4*8._/**/REALKIND))
    f(636) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(637) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**2*sw**4*4._/**/REALKIND))
    f(638) = (eQED**5*integralnorm*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND)
    f(639) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*6._/**/REALKIND))
    f(640) = (eQED**5*integralnorm*MW**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(641) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*2._/**/REALKIND))
    f(642) = (eQED**5*integralnorm*MW**2*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND)
    f(643) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/cw**2)
    f(644) = -((eQED**5*integralnorm*MW**4*(cw - sw)*(cw + sw)*SwB)/(cw**4*4._/**/REALKIND))
    f(645) = (eQED**5*integralnorm*MW**2*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**3*sw*12._/**/REALKIND*6._/**/REALKIND)
    f(646) = (eQED**5*integralnorm*MW**2*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**3*sw*3._/**/REALKIND*6._/**/REALKIND)
    f(647) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*6._/**/REALKIND))
    f(648) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*3._/**/REALKIND))
    f(649) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(650) = (eQED**5*integralnorm*MW**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*2._/**/REALKIND*4._/**/REALKIND)
    f(651) = (eQED**5*integralnorm*MW**2*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**4*2._/**/REALKIND)
    f(652) = (eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(653) = (2*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(654) = (4*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(655) = (8*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(656) = (eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(657) = (2*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(658) = eQED**5*integralnorm*SwF
    f(659) = (4*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(660) = (eQED**5*integralnorm*SwF)/(cw**2*2._/**/REALKIND)
    f(661) = (eQED**5*integralnorm*MB**2*SwF)/(cw**2*4._/**/REALKIND)
    f(662) = (eQED**5*integralnorm*MB*ME*SwF)/(cw**2*4._/**/REALKIND)
    f(663) = (eQED**5*integralnorm*ME**2*SwF)/(cw**2*2._/**/REALKIND)
    f(664) = (eQED**5*integralnorm*MB*ML*SwF)/(cw**2*4._/**/REALKIND)
    f(665) = (eQED**5*integralnorm*ML**2*SwF)/(cw**2*2._/**/REALKIND)
    f(666) = (eQED**5*integralnorm*MB*MM*SwF)/(cw**2*4._/**/REALKIND)
    f(667) = (eQED**5*integralnorm*MM**2*SwF)/(cw**2*2._/**/REALKIND)
    f(668) = (eQED**5*integralnorm*MB*MT*SwF)/(cw**2*4._/**/REALKIND)
    f(669) = (cw*eQED**5*integralnorm*SwF)/(sw**5*4._/**/REALKIND)
    f(670) = (cw*eQED**5*integralnorm*SwF)/(sw**5*2._/**/REALKIND)
    f(671) = (cw*eQED**5*integralnorm*MB*SwF)/(sw**5*4._/**/REALKIND)
    f(672) = (cw*eQED**5*integralnorm*MB*SwF)/(sw**5*2._/**/REALKIND)
    f(673) = (cw*eQED**5*integralnorm*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(674) = (cw*eQED**5*integralnorm*MB*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(675) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(676) = (cw*eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(677) = (eQED**5*integralnorm*MB**3*SwF)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(678) = (eQED**5*integralnorm*MB**3*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND)
    f(679) = (cw*eQED**5*integralnorm*MB**3*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(680) = (cw*eQED**5*integralnorm*ME*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(681) = (eQED**5*integralnorm*MB*ME*SwF)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(682) = (cw*eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(683) = (eQED**5*integralnorm*MB*ME**2*SwF)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(684) = (eQED**5*integralnorm*MB*ME**2*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND)
    f(685) = (cw*eQED**5*integralnorm*MB*ME**2*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(686) = (cw*eQED**5*integralnorm*ML*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(687) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(688) = (cw*eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(689) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(690) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND)
    f(691) = (cw*eQED**5*integralnorm*MB*ML**2*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(692) = (cw*eQED**5*integralnorm*MM*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(693) = (eQED**5*integralnorm*MB*MM*SwF)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(694) = (cw*eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(695) = (eQED**5*integralnorm*MB*MM**2*SwF)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(696) = (eQED**5*integralnorm*MB*MM**2*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND)
    f(697) = (cw*eQED**5*integralnorm*MB*MM**2*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(698) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(699) = (cw*eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(700) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(701) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND)
    f(702) = (cw*eQED**5*integralnorm*MB*MT**2*SwF)/(MW**2*sw**5*8._/**/REALKIND)
    f(703) = (eQED**5*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(704) = (eQED**5*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(705) = (cw**2*eQED**5*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(706) = (cw**2*eQED**5*integralnorm*SwF)/sw**4
    f(707) = (eQED**5*integralnorm*MB*SwF)/(sw**4*4._/**/REALKIND)
    f(708) = (eQED**5*integralnorm*MB*SwF)/(sw**4*2._/**/REALKIND)
    f(709) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(710) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**4*2._/**/REALKIND)
    f(711) = (eQED**5*integralnorm*MB**2*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(712) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(713) = (eQED**5*integralnorm*MB*ME*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(714) = (eQED**5*integralnorm*ME**2*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(715) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(716) = (eQED**5*integralnorm*MB*ML*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(717) = (eQED**5*integralnorm*ML**2*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(718) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(719) = (eQED**5*integralnorm*MB*MM*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(720) = (eQED**5*integralnorm*MM**2*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(721) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(722) = (eQED**5*integralnorm*MB*MT*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(723) = (eQED**5*integralnorm*MT**2*SwF)/(cw**2*sw**4*4._/**/REALKIND)
    f(724) = (eQED**5*integralnorm*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(725) = (eQED**5*integralnorm*MB*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(726) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(727) = (cw**2*eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(728) = (eQED**5*integralnorm*MB**3*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(729) = (eQED**5*integralnorm*ME*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(730) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(731) = (cw**2*eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(732) = (eQED**5*integralnorm*MB*ME**2*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(733) = (eQED**5*integralnorm*ML*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(734) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(735) = (cw**2*eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(736) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(737) = (eQED**5*integralnorm*MM*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(738) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(739) = (cw**2*eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(740) = (eQED**5*integralnorm*MB*MM**2*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(741) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(742) = (cw**2*eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(743) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(744) = (eQED**5*integralnorm*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(745) = (cw*eQED**5*integralnorm*SwF)/(sw**3*18._/**/REALKIND)
    f(746) = (cw*eQED**5*integralnorm*SwF)/(sw**3*9._/**/REALKIND)
    f(747) = (cw*eQED**5*integralnorm*SwF)/(sw**3*6._/**/REALKIND)
    f(748) = (2*cw*eQED**5*integralnorm*SwF)/(sw**3*9._/**/REALKIND)
    f(749) = (cw*eQED**5*integralnorm*SwF)/(sw**3*3._/**/REALKIND)
    f(750) = (cw*eQED**5*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(751) = (cw*eQED**5*integralnorm*SwF)/sw**3
    f(752) = (eQED**5*integralnorm*MB*SwF)/(cw*sw**3*36._/**/REALKIND)
    f(753) = (eQED**5*integralnorm*MB*SwF)/(cw*sw**3*18._/**/REALKIND)
    f(754) = (eQED**5*integralnorm*MB*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(755) = (eQED**5*integralnorm*MB*SwF)/(cw*sw**3*2._/**/REALKIND)
    f(756) = (eQED**5*integralnorm*MB*SwF)/(cw*sw**3)
    f(757) = (3*eQED**5*integralnorm*MB*SwF)/(cw*sw**3*2._/**/REALKIND)
    f(758) = (cw*eQED**5*integralnorm*MB*SwF)/(sw**3*18._/**/REALKIND)
    f(759) = (cw*eQED**5*integralnorm*MB*SwF)/(sw**3*2._/**/REALKIND)
    f(760) = (eQED**5*integralnorm*ME*SwF)/(cw*sw**3*12._/**/REALKIND)
    f(761) = (eQED**5*integralnorm*ME*SwF)/(cw*sw**3*6._/**/REALKIND)
    f(762) = (eQED**5*integralnorm*ME*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(763) = (eQED**5*integralnorm*ME*SwF)/(cw*sw**3*2._/**/REALKIND)
    f(764) = (cw*eQED**5*integralnorm*ME*SwF)/(sw**3*6._/**/REALKIND)
    f(765) = (cw*eQED**5*integralnorm*ME*SwF)/(sw**3*2._/**/REALKIND)
    f(766) = (eQED**5*integralnorm*MB*ME*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(767) = (eQED**5*integralnorm*ML*SwF)/(cw*sw**3*12._/**/REALKIND)
    f(768) = (eQED**5*integralnorm*ML*SwF)/(cw*sw**3*6._/**/REALKIND)
    f(769) = (eQED**5*integralnorm*ML*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(770) = (eQED**5*integralnorm*ML*SwF)/(cw*sw**3*2._/**/REALKIND)
    f(771) = (cw*eQED**5*integralnorm*ML*SwF)/(sw**3*6._/**/REALKIND)
    f(772) = (cw*eQED**5*integralnorm*ML*SwF)/(sw**3*2._/**/REALKIND)
    f(773) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(774) = (eQED**5*integralnorm*MM*SwF)/(cw*sw**3*12._/**/REALKIND)
    f(775) = (eQED**5*integralnorm*MM*SwF)/(cw*sw**3*6._/**/REALKIND)
    f(776) = (eQED**5*integralnorm*MM*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(777) = (eQED**5*integralnorm*MM*SwF)/(cw*sw**3*2._/**/REALKIND)
    f(778) = (cw*eQED**5*integralnorm*MM*SwF)/(sw**3*6._/**/REALKIND)
    f(779) = (cw*eQED**5*integralnorm*MM*SwF)/(sw**3*2._/**/REALKIND)
    f(780) = (eQED**5*integralnorm*MB*MM*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(781) = (eQED**5*integralnorm*MT*SwF)/(cw*sw**3*18._/**/REALKIND)
    f(782) = (eQED**5*integralnorm*MT*SwF)/(cw*sw**3*9._/**/REALKIND)
    f(783) = (eQED**5*integralnorm*MT*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(784) = (eQED**5*integralnorm*MT*SwF)/(cw*sw**3*2._/**/REALKIND)
    f(785) = (cw*eQED**5*integralnorm*MT*SwF)/(sw**3*9._/**/REALKIND)
    f(786) = (cw*eQED**5*integralnorm*MT*SwF)/(sw**3*2._/**/REALKIND)
    f(787) = (eQED**5*integralnorm*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(788) = (eQED**5*integralnorm*MB*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(789) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(790) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(791) = (cw*eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**3*12._/**/REALKIND)
    f(792) = (cw*eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**3*4._/**/REALKIND)
    f(793) = (eQED**5*integralnorm*MB**3*SwF)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(794) = (eQED**5*integralnorm*MB*ME*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(795) = (cw*eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**3*4._/**/REALKIND)
    f(796) = (eQED**5*integralnorm*ME**2*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(797) = (eQED**5*integralnorm*MB*ME**2*SwF)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(798) = (eQED**5*integralnorm*MB*ME**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(799) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(800) = (cw*eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**3*4._/**/REALKIND)
    f(801) = (eQED**5*integralnorm*ML**2*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(802) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(803) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(804) = (eQED**5*integralnorm*MB*MM*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(805) = (cw*eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**3*4._/**/REALKIND)
    f(806) = (eQED**5*integralnorm*MM**2*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(807) = (eQED**5*integralnorm*MB*MM**2*SwF)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(808) = (eQED**5*integralnorm*MB*MM**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(809) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f(810) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(811) = (cw*eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**3*6._/**/REALKIND)
    f(812) = (cw*eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**3*4._/**/REALKIND)
    f(813) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(814) = (eQED**5*integralnorm*SwF)/(sw**2*18._/**/REALKIND)
    f(815) = (eQED**5*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(816) = (eQED**5*integralnorm*SwF)/(sw**2*6._/**/REALKIND)
    f(817) = (2*eQED**5*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(818) = (eQED**5*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(819) = (eQED**5*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(820) = (eQED**5*integralnorm*SwF)/sw**2
    f(821) = (cw**2*eQED**5*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(822) = (2*cw**2*eQED**5*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(823) = (cw**2*eQED**5*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(824) = (4*cw**2*eQED**5*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(825) = (cw**2*eQED**5*integralnorm*SwF)/sw**2
    f(826) = (2*cw**2*eQED**5*integralnorm*SwF)/sw**2
    f(827) = (3*cw**2*eQED**5*integralnorm*SwF)/sw**2
    f(828) = (eQED**5*integralnorm*MB*SwF)/(sw**2*18._/**/REALKIND)
    f(829) = (eQED**5*integralnorm*MB*SwF)/(sw**2*2._/**/REALKIND)
    f(830) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(831) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(832) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(833) = (2*eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(834) = (eQED**5*integralnorm*ME*SwF)/(sw**2*6._/**/REALKIND)
    f(835) = (eQED**5*integralnorm*ME*SwF)/(sw**2*2._/**/REALKIND)
    f(836) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(837) = (eQED**5*integralnorm*ML*SwF)/(sw**2*6._/**/REALKIND)
    f(838) = (eQED**5*integralnorm*ML*SwF)/(sw**2*2._/**/REALKIND)
    f(839) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(840) = (eQED**5*integralnorm*MM*SwF)/(sw**2*6._/**/REALKIND)
    f(841) = (eQED**5*integralnorm*MM*SwF)/(sw**2*2._/**/REALKIND)
    f(842) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(843) = (eQED**5*integralnorm*MT*SwF)/(sw**2*9._/**/REALKIND)
    f(844) = (eQED**5*integralnorm*MT*SwF)/(sw**2*2._/**/REALKIND)
    f(845) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(846) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(847) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(848) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(849) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(850) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(851) = (eQED**5*integralnorm*MW**2*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(852) = (2*eQED**5*integralnorm*MW**2*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(853) = (eQED**5*integralnorm*MW**2*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(854) = (4*eQED**5*integralnorm*MW**2*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(855) = (eQED**5*integralnorm*MW**2*SwF)/(cw**2*sw**2)
    f(856) = (2*eQED**5*integralnorm*MW**2*SwF)/(cw**2*sw**2)
    f(857) = (3*eQED**5*integralnorm*MW**2*SwF)/(cw**2*sw**2)
    f(858) = (eQED**5*integralnorm*SwF)/(cw*sw*18._/**/REALKIND)
    f(859) = (eQED**5*integralnorm*SwF)/(cw*sw*9._/**/REALKIND)
    f(860) = (eQED**5*integralnorm*SwF)/(cw*sw*6._/**/REALKIND)
    f(861) = (eQED**5*integralnorm*SwF)/(cw*sw*2._/**/REALKIND)
    f(862) = (cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(863) = (2*cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(864) = (cw*eQED**5*integralnorm*SwF)/(sw*9._/**/REALKIND)
    f(865) = (4*cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(866) = (2*cw*eQED**5*integralnorm*SwF)/(sw*9._/**/REALKIND)
    f(867) = (8*cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(868) = (cw*eQED**5*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(869) = (4*cw*eQED**5*integralnorm*SwF)/(sw*9._/**/REALKIND)
    f(870) = (2*cw*eQED**5*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(871) = (cw*eQED**5*integralnorm*SwF)/sw
    f(872) = (4*cw*eQED**5*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(873) = (2*cw*eQED**5*integralnorm*SwF)/sw
    f(874) = (3*cw*eQED**5*integralnorm*SwF)/sw
    f(875) = (eQED**5*integralnorm*MB*SwF)/(cw*sw*36._/**/REALKIND)
    f(876) = (eQED**5*integralnorm*MB*SwF)/(cw*sw*4._/**/REALKIND)
    f(877) = (eQED**5*integralnorm*MB**2*SwF)/(cw*sw*12._/**/REALKIND)
    f(878) = (eQED**5*integralnorm*ME*SwF)/(cw*sw*12._/**/REALKIND)
    f(879) = (eQED**5*integralnorm*ME*SwF)/(cw*sw*6._/**/REALKIND)
    f(880) = (eQED**5*integralnorm*ME*SwF)/(cw*sw*4._/**/REALKIND)
    f(881) = (eQED**5*integralnorm*ME*SwF)/(cw*sw*2._/**/REALKIND)
    f(882) = (eQED**5*integralnorm*MB*ME*SwF)/(cw*sw*4._/**/REALKIND)
    f(883) = (eQED**5*integralnorm*ME**2*SwF)/(cw*sw*6._/**/REALKIND)
    f(884) = (eQED**5*integralnorm*ML*SwF)/(cw*sw*12._/**/REALKIND)
    f(885) = (eQED**5*integralnorm*ML*SwF)/(cw*sw*6._/**/REALKIND)
    f(886) = (eQED**5*integralnorm*ML*SwF)/(cw*sw*4._/**/REALKIND)
    f(887) = (eQED**5*integralnorm*ML*SwF)/(cw*sw*2._/**/REALKIND)
    f(888) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*sw*4._/**/REALKIND)
    f(889) = (eQED**5*integralnorm*ML**2*SwF)/(cw*sw*6._/**/REALKIND)
    f(890) = (eQED**5*integralnorm*MM*SwF)/(cw*sw*12._/**/REALKIND)
    f(891) = (eQED**5*integralnorm*MM*SwF)/(cw*sw*6._/**/REALKIND)
    f(892) = (eQED**5*integralnorm*MM*SwF)/(cw*sw*4._/**/REALKIND)
    f(893) = (eQED**5*integralnorm*MM*SwF)/(cw*sw*2._/**/REALKIND)
    f(894) = (eQED**5*integralnorm*MB*MM*SwF)/(cw*sw*4._/**/REALKIND)
    f(895) = (eQED**5*integralnorm*MM**2*SwF)/(cw*sw*6._/**/REALKIND)
    f(896) = (eQED**5*integralnorm*MT*SwF)/(cw*sw*18._/**/REALKIND)
    f(897) = (eQED**5*integralnorm*MT*SwF)/(cw*sw*4._/**/REALKIND)
    f(898) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*sw*6._/**/REALKIND)
    f(899) = (eQED**5*integralnorm*MW**2*sw*SwF)/(cw*27._/**/REALKIND)
    f(900) = (2*eQED**5*integralnorm*MW**2*sw*SwF)/(cw*27._/**/REALKIND)
    f(901) = (4*eQED**5*integralnorm*MW**2*sw*SwF)/(cw*27._/**/REALKIND)
    f(902) = (8*eQED**5*integralnorm*MW**2*sw*SwF)/(cw*27._/**/REALKIND)
    f(903) = (eQED**5*integralnorm*MW**2*sw*SwF)/(cw*3._/**/REALKIND)
    f(904) = (2*eQED**5*integralnorm*MW**2*sw*SwF)/(cw*3._/**/REALKIND)
    f(905) = (eQED**5*integralnorm*MW**2*sw*SwF)/cw
    f(906) = (4*eQED**5*integralnorm*MW**2*sw*SwF)/(cw*3._/**/REALKIND)
    f(907) = (eQED**5*integralnorm*MW**2*sw**2*SwF)/(cw**2*9._/**/REALKIND)
    f(908) = (2*eQED**5*integralnorm*MW**2*sw**2*SwF)/(cw**2*9._/**/REALKIND)
    f(909) = (eQED**5*integralnorm*MW**2*sw**2*SwF)/(cw**2*3._/**/REALKIND)
    f(910) = (4*eQED**5*integralnorm*MW**2*sw**2*SwF)/(cw**2*9._/**/REALKIND)
    f(911) = (eQED**5*integralnorm*MW**2*sw**2*SwF)/cw**2
    f(912) = (2*eQED**5*integralnorm*MW**2*sw**2*SwF)/cw**2
    f(913) = (3*eQED**5*integralnorm*MW**2*sw**2*SwF)/cw**2

  c = [ 3*f(117), 3*f(118), 3*f(119), 3*f(120), 3*f(121), 4*f(122), 3*f(123), 3*f(124), 3*f(125), 3*f(126), 3*f(127), 3*f(128) &
    , 3*f(129), 3*f(130), 3*f(131), 3*f(132), 3*f(133), 3*f(134), 3*f(135), 3*f(136), 3*f(137), 3*f(138), 3*f(139), 3*f(140) &
    , 3*f(141), 3*f(142), 3*f(143), 3*f(144), 3*f(145), 3*f(146), 3*f(147), 3*f(148), 3*f(149), 3*f(150), 3*f(151), 3*f(152) &
    , 3*f(153), 3*f(154), 3*f(155), 3*f(156), 3*f(157), 3*f(158), 3*f(159), 3*f(160), 3*f(161), 3*f(162), 3*f(163), 3*f(164) &
    , 3*f(165), 3*f(166), 3*f(167), 3*f(168), 3*f(169), 3*f(170), 3*f(171), 3*f(172), 3*f(173), 3*f(174), 3*f(175), 3*f(176) &
    , 3*f(177), 3*f(178), 3*f(179), 3*f(180), 3*f(181), 3*f(182), 3*f(183), 3*f(184), 3*f(185), 3*f(186), 3*f(187), 3*f(188) &
    , 3*f(189), 3*f(190), 3*f(191), 3*f(192), 3*f(193), 3*f(194), 3*f(195), 3*f(196), 3*f(197), 3*f(198), 3*f(199), 3*f(200) &
    , 3*f(201), 3*f(202), 3*f(203), 3*f(204), 3*f(205), 3*f(206), 3*f(207), 3*f(208), 3*f(209), 3*f(210), 3*f(211), 3*f(212) &
    , 3*f(213), 3*f(214), 3*f(215), 3*f(216), 3*f(217), 3*f(218), 3*f(219), 3*f(220), 3*f(221), 3*f(222), 3*f(223), 3*f(224) &
    , 3*f(225), 3*f(226), 3*f(227), 3*f(228), 3*f(229), 3*f(230), 3*f(231), 3*f(232), 3*f(233), 3*f(234), 3*f(235), 3*f(236) &
    , 3*f(237), 3*f(238), 3*f(239), 3*f(240), 3*f(241), 3*f(242), 3*f(243), 3*f(244), 3*f(245), 3*f(246), 3*f(247), 3*f(248) &
    , 3*f(249), 3*f(250), 3*f(251), 3*f(252), 3*f(253), 3*f(254), 3*f(255), 3*f(256), 3*f(257), 3*f(258), 3*f(259), 3*f(260) &
    , 3*f(261), 3*f(262), 3*f(263), 3*f(264), 3*f(265), 3*f(266), 3*f(267), 3*f(268), 3*f(269), 3*f(270), 3*f(271), 3*f(272) &
    , 3*f(273), 3*f(274), 3*f(275), 3*f(276), 3*f(277), 3*f(278), 3*f(279), 3*f(280), 3*f(281), 3*f(282), 3*f(283), 3*f(284) &
    , 3*f(285), 3*f(286), 3*f(287), 3*f(288), 3*f(289), 3*f(290), 3*f(291), 3*f(292), 3*f(293), 3*f(294), 3*f(295), 3*f(296) &
    , 3*f(297), 3*f(298), 3*f(299), 3*f(300), 3*f(301), 3*f(302), 3*f(303), 3*f(304), 3*f(305), 3*f(306), 3*f(307), 3*f(308) &
    , 3*f(309), 3*f(310), 3*f(311), 3*f(312), 3*f(313), 3*f(314), 3*f(315), 3*f(316), 3*f(317), 3*f(318), 3*f(319), 3*f(320) &
    , 3*f(321), 3*f(322), 3*f(323), 3*f(324), 3*f(325), 3*f(326), 3*f(327), 3*f(328), 3*f(329), 3*f(330), 4*f(331), 3*f(332) &
    , 3*f(333), 3*f(334), 3*f(335), 3*f(336), 3*f(337), 3*f(338), 3*f(339), 3*f(340), 3*f(341), 3*f(342), 3*f(343), 3*f(344) &
    , 3*f(345), 3*f(346), 3*f(347), 3*f(348), 4*f(349), 4*f(350), 4*f(351), 3*f(352), 3*f(353), 3*f(354), 3*f(355), 3*f(356) &
    , 3*f(357), 3*f(358), 3*f(359), 3*f(360), 3*f(361), 3*f(362), 3*f(363), 3*f(364), 3*f(365), 3*f(366), 3*f(367), 3*f(368) &
    , 3*f(369), 3*f(370), 3*f(371), 3*f(372), 3*f(373), 3*f(374), 3*f(375), 3*f(376), 3*f(377), 3*f(378), 3*f(379), 3*f(380) &
    , 3*f(381), 3*f(382), 3*f(383), 3*f(384), 3*f(385), 3*f(386), 3*f(387), 3*f(388), 3*f(389), 3*f(390), 3*f(391), 3*f(392) &
    , 3*f(393), 3*f(394), 3*f(395), 3*f(396), 3*f(397), 3*f(398), 3*f(399), 3*f(400), 3*f(401), 3*f(402), 3*f(403), 3*f(404) &
    , 3*f(405), 3*f(406), 3*f(407), 3*f(408), 3*f(409), 3*f(410), 3*f(411), 3*f(412), 3*f(413), 3*f(414), 3*f(415), 3*f(416) &
    , 3*f(417), 3*f(418), 3*f(419), 3*f(420), 3*f(421), 3*f(422), 3*f(423), 3*f(424), 3*f(425), 3*f(426), 3*f(427), 3*f(428) &
    , 3*f(429), 4*f(430), 4*f(431), 3*f(432), 3*f(433), 3*f(434), 3*f(435), 3*f(436), 3*f(437), 3*f(438), 4*f(439), 3*f(440) &
    , 3*f(441), 3*f(442), 3*f(443), 3*f(444), 3*f(445), 3*f(446), 3*f(447), 3*f(448), 3*f(449), 3*f(450), 3*f(451), 3*f(452) &
    , 3*f(453), 3*f(454), 3*f(455), 3*f(456), 3*f(457), 3*f(458), 3*f(459), 3*f(460), 3*f(461), 4*f(462), 3*f(463), 3*f(464) &
    , 3*f(465), 3*f(466), 3*f(467), 3*f(468), 3*f(469), 3*f(470), 3*f(471), 3*f(472), 3*f(473), 3*f(474), 3*f(475), 4*f(476) &
    , 4*f(477), 4*f(478), 3*f(479), 3*f(480), 3*f(481), 3*f(482), 4*f(483), 3*f(484), 3*f(485), 3*f(486), 3*f(487), 3*f(488) &
    , 3*f(489), 3*f(490), 3*f(491), 3*f(492), 3*f(493), 3*f(494), 3*f(495), 3*f(496), 3*f(497), 3*f(498), 3*f(499), 3*f(500) &
    , 3*f(501), 3*f(502), 3*f(503), 3*f(504), 3*f(505), 3*f(506), 3*f(507), 3*f(508), 3*f(509), 3*f(510), 3*f(511), 3*f(512) &
    , 3*f(513), 3*f(514), 3*f(515), 4*f(516), 3*f(517), 3*f(518), 3*f(519), 3*f(520), 3*f(521), 4*f(522), 3*f(523), 3*f(524) &
    , 3*f(525), 3*f(526), 3*f(527), 3*f(528), 3*f(529), 3*f(530), 3*f(531), 3*f(532), 3*f(533), 3*f(534), 3*f(535), 3*f(536) &
    , 3*f(537), 3*f(538), 3*f(539), 3*f(540), 3*f(541), 3*f(542), 3*f(543), 3*f(544), 3*f(545), 3*f(546), 3*f(547), 3*f(548) &
    , 3*f(549), 3*f(550), 3*f(551), 3*f(552), 3*f(553), 3*f(554), 3*f(555), 3*f(556), 3*f(557), 3*f(558), 3*f(559), 3*f(560) &
    , 3*f(561), 3*f(562), 3*f(563), 3*f(564), 3*f(565), 3*f(566), 3*f(567), 3*f(568), 3*f(569), 3*f(570), 3*f(571), 3*f(572) &
    , 3*f(573), 3*f(574), 3*f(575), 3*f(576), 3*f(577), 3*f(578), 3*f(579), 3*f(580), 3*f(581), 3*f(582), 3*f(583), 3*f(584) &
    , 3*f(585), 3*f(586), 3*f(587), 3*f(588), 3*f(589), 3*f(590), 3*f(591), 3*f(592), 3*f(593), 3*f(594), 3*f(595), 3*f(596) &
    , 3*f(597), 3*f(598), 3*f(599), 3*f(600), 3*f(601), 3*f(602), 3*f(603), 3*f(604), 3*f(605), 3*f(606), 3*f(607), 3*f(608) &
    , 3*f(609), 3*f(610), 3*f(611), 3*f(612), 3*f(613), 3*f(614), 3*f(615), 3*f(616), 3*f(617), 3*f(618), 3*f(619), 3*f(620) &
    , 3*f(621), 3*f(622), 3*f(623), 3*f(624), 3*f(625), 3*f(626), 3*f(627), 3*f(628), 3*f(629), 3*f(630), 3*f(631), 3*f(632) &
    , 3*f(633), 3*f(634), 3*f(635), 3*f(636), 3*f(637), 3*f(638), 3*f(639), 3*f(640), 3*f(641), 3*f(642), 3*f(643), 3*f(644) &
    , 3*f(645), 3*f(646), 3*f(647), 3*f(648), 3*f(649), 3*f(650), 3*f(651), 9*f(652), 9*f(653), 9*f(654), 9*f(655), 3*f(656) &
    , 9*f(656), 9*f(657), 3*f(658), 9*f(659), 9*f(660), 9*f(661), 3*f(662), 3*f(663), 3*f(664), 3*f(665), 3*f(666), 3*f(667) &
    , 9*f(668), 3*f(669), 9*f(669), 9*f(670), 3*f(671), 9*f(671), 9*f(672), 9*f(673), 9*f(674), 9*f(675), 9*f(676), 9*f(677) &
    , 9*f(678), 9*f(679), 3*f(680), 3*f(681), 3*f(682), 3*f(683), 3*f(684), 3*f(685), 3*f(686), 3*f(687), 3*f(688), 3*f(689) &
    , 3*f(690), 3*f(691), 3*f(692), 3*f(693), 3*f(694), 3*f(695), 3*f(696), 3*f(697), 9*f(698), 9*f(699), 9*f(700), 9*f(701) &
    , 9*f(702), 3*f(703), 9*f(703), 9*f(704), 3*f(705), 9*f(705), 9*f(706), 3*f(707), 9*f(707), 9*f(708), 3*f(709), 9*f(709) &
    , 9*f(710), 9*f(711), 3*f(712), 3*f(713), 3*f(714), 3*f(715), 3*f(716), 3*f(717), 3*f(718), 3*f(719), 3*f(720), 9*f(721) &
    , 9*f(722), 9*f(723), 9*f(724), 9*f(725), 9*f(726), 9*f(727), 9*f(728), 3*f(729), 3*f(730), 3*f(731), 3*f(732), 3*f(733) &
    , 3*f(734), 3*f(735), 3*f(736), 3*f(737), 3*f(738), 3*f(739), 3*f(740), 9*f(741), 9*f(742), 9*f(743), 9*f(744), 9*f(745) &
    , 9*f(746), 3*f(747), 9*f(747), 9*f(748), 9*f(749), 3*f(750), 9*f(750), 9*f(751), 9*f(752), 9*f(753), 9*f(754), 3*f(755) &
    , 9*f(755), 9*f(756), 3*f(757), 9*f(758), 9*f(759), 3*f(760), 3*f(761), 3*f(762), 3*f(763), 3*f(764), 3*f(765), 3*f(766) &
    , 3*f(767), 3*f(768), 3*f(769), 3*f(770), 3*f(771), 3*f(772), 3*f(773), 3*f(774), 3*f(775), 3*f(776), 3*f(777), 3*f(778) &
    , 3*f(779), 3*f(780), 9*f(781), 9*f(782), 9*f(783), 9*f(784), 9*f(785), 9*f(786), 9*f(787), 9*f(788), 9*f(789), 9*f(790) &
    , 9*f(791), 9*f(792), 9*f(793), 3*f(794), 3*f(795), 3*f(796), 3*f(797), 3*f(798), 3*f(799), 3*f(800), 3*f(801), 3*f(802) &
    , 3*f(803), 3*f(804), 3*f(805), 3*f(806), 3*f(807), 3*f(808), 9*f(809), 9*f(810), 9*f(811), 9*f(812), 9*f(813), 9*f(814) &
    , 9*f(815), 3*f(816), 9*f(816), 9*f(817), 9*f(818), 3*f(819), 9*f(819), 9*f(820), 9*f(821), 9*f(822), 3*f(823), 9*f(824) &
    , 3*f(825), 9*f(825), 9*f(826), 3*f(827), 9*f(828), 9*f(829), 9*f(830), 9*f(831), 3*f(832), 9*f(833), 3*f(834), 3*f(835) &
    , 3*f(836), 3*f(837), 3*f(838), 3*f(839), 3*f(840), 3*f(841), 3*f(842), 9*f(843), 9*f(844), 9*f(845), 9*f(846), 3*f(847) &
    , 3*f(848), 3*f(849), 9*f(850), 9*f(851), 9*f(852), 3*f(853), 9*f(854), 3*f(855), 9*f(855), 9*f(856), 3*f(857), 9*f(858) &
    , 9*f(859), 9*f(860), 9*f(861), 9*f(862), 9*f(863), 9*f(864), 9*f(865), 9*f(866), 9*f(867), 3*f(868), 9*f(868), 9*f(869) &
    , 9*f(870), 3*f(871), 9*f(871), 9*f(872), 9*f(873), 3*f(874), 9*f(875), 9*f(876), 9*f(877), 3*f(878), 3*f(879), 3*f(880) &
    , 3*f(881), 3*f(882), 3*f(883), 3*f(884), 3*f(885), 3*f(886), 3*f(887), 3*f(888), 3*f(889), 3*f(890), 3*f(891), 3*f(892) &
    , 3*f(893), 3*f(894), 3*f(895), 9*f(896), 9*f(897), 9*f(898), 9*f(899), 9*f(900), 9*f(901), 9*f(902), 3*f(903), 9*f(903) &
    , 9*f(904), 3*f(905), 9*f(906), 9*f(907), 9*f(908), 3*f(909), 9*f(910), 3*f(911), 9*f(911), 9*f(912), 3*f(913) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(3) = 1 /((L(5,3) - MH2)+L(6,3))
  den(4) = 1 /((L(5,12) - MW2)+L(6,12))
  den(8) = 1 /((L(5,20) - MW2)+L(6,20))
  den(12) = 1 /((L(5,24) - MH2)+L(6,24))
  den(14) = 1 /((L(5,24) - MZ2)+L(6,24))
  den(16) = 1 /((L(5,5) - MB2)+L(6,5))
  den(17) = 1 /((L(5,10) - MT2)+L(6,10))
  den(20) = 1 /((L(5,24))+L(6,24))
  den(23) = 1 /((L(5,17) - MT2)+L(6,17))
  den(24) = 1 /((L(5,6) - MB2)+L(6,6))
  den(32) = 1 /((L(5,28))+L(6,28))
  den(33) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(40) = 1 /((L(5,28) - MH2)+L(6,28))
  den(49) = 1 /((L(5,19) - MW2)+L(6,19))
  den(64) = 1 /((L(5,11) - MW2)+L(6,11))
  den(76) = 1 /((L(5,7) - MH2)+L(6,7))
  den(79) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(83) = 1 /((L(5,26) - MB2)+L(6,26))
  den(86) = 1 /((L(5,21) - MT2)+L(6,21))
  den(100) = 1 /((L(5,7))+L(6,7))
  den(104) = 1 /((L(5,14) - MT2)+L(6,14))
  den(107) = 1 /((L(5,25) - MB2)+L(6,25))

  ! denominators
  den(5) = den(3)*den(4)
  den(6) = den(2)*den(4)
  den(7) = den(1)*den(4)
  den(9) = den(3)*den(8)
  den(10) = den(2)*den(8)
  den(11) = den(1)*den(8)
  den(13) = den(2)*den(12)
  den(15) = den(3)*den(14)
  den(18) = den(16)*den(17)
  den(19) = den(12)*den(16)
  den(21) = den(16)*den(20)
  den(22) = den(14)*den(16)
  den(25) = den(23)*den(24)
  den(26) = den(12)*den(24)
  den(27) = den(20)*den(24)
  den(28) = den(14)*den(24)
  den(29) = den(17)*den(23)
  den(30) = den(8)*den(17)
  den(31) = den(4)*den(23)
  den(34) = den(2)*den(32)
  den(35) = den(2)*den(33)
  den(36) = den(1)*den(32)
  den(37) = den(1)*den(33)
  den(38) = den(3)*den(20)
  den(39) = den(1)*den(12)
  den(41) = den(4)*den(40)
  den(42) = den(3)*den(41)
  den(43) = den(4)*den(33)
  den(44) = den(2)*den(43)
  den(45) = den(4)*den(32)
  den(46) = den(2)*den(45)
  den(47) = den(1)*den(43)
  den(48) = den(1)*den(45)
  den(50) = den(3)*den(49)
  den(51) = den(4)*den(50)
  den(52) = den(2)*den(49)
  den(53) = den(4)*den(52)
  den(54) = den(1)*den(49)
  den(55) = den(4)*den(54)
  den(56) = den(8)*den(40)
  den(57) = den(3)*den(56)
  den(58) = den(8)*den(33)
  den(59) = den(2)*den(58)
  den(60) = den(8)*den(32)
  den(61) = den(2)*den(60)
  den(62) = den(1)*den(58)
  den(63) = den(1)*den(60)
  den(65) = den(3)*den(64)
  den(66) = den(8)*den(65)
  den(67) = den(2)*den(64)
  den(68) = den(8)*den(67)
  den(69) = den(1)*den(64)
  den(70) = den(8)*den(69)
  den(71) = den(12)*den(33)
  den(72) = den(2)*den(71)
  den(73) = den(14)*den(40)
  den(74) = den(3)*den(73)
  den(75) = den(1)*den(71)
  den(77) = den(2)*den(76)
  den(78) = den(12)*den(77)
  den(80) = den(3)*den(79)
  den(81) = den(20)*den(80)
  den(82) = den(14)*den(80)
  den(84) = den(17)*den(83)
  den(85) = den(16)*den(84)
  den(87) = den(16)*den(86)
  den(88) = den(17)*den(87)
  den(89) = den(12)*den(83)
  den(90) = den(16)*den(89)
  den(91) = den(20)*den(83)
  den(92) = den(16)*den(91)
  den(93) = den(14)*den(83)
  den(94) = den(16)*den(93)
  den(95) = den(16)*den(76)
  den(96) = den(12)*den(95)
  den(97) = den(16)*den(79)
  den(98) = den(20)*den(97)
  den(99) = den(14)*den(97)
  den(101) = den(16)*den(100)
  den(102) = den(20)*den(101)
  den(103) = den(14)*den(101)
  den(105) = den(24)*den(104)
  den(106) = den(23)*den(105)
  den(108) = den(23)*den(107)
  den(109) = den(24)*den(108)
  den(110) = den(12)*den(107)
  den(111) = den(24)*den(110)
  den(112) = den(20)*den(107)
  den(113) = den(24)*den(112)
  den(114) = den(14)*den(107)
  den(115) = den(24)*den(114)
  den(116) = den(24)*den(76)
  den(117) = den(12)*den(116)
  den(118) = den(24)*den(79)
  den(119) = den(20)*den(118)
  den(120) = den(14)*den(118)
  den(121) = den(24)*den(100)
  den(122) = den(20)*den(121)
  den(123) = den(14)*den(121)
  den(124) = den(17)*den(104)
  den(125) = den(23)*den(124)
  den(126) = den(23)*den(86)
  den(127) = den(17)*den(126)
  den(128) = den(8)*den(86)
  den(129) = den(17)*den(128)
  den(130) = den(17)*den(64)
  den(131) = den(8)*den(130)
  den(132) = den(4)*den(104)
  den(133) = den(23)*den(132)
  den(134) = den(23)*den(49)
  den(135) = den(4)*den(134)
  den(136) = den(3)*den(12)
  den(137) = den(2)*den(20)
  den(138) = den(2)*den(14)
  den(139) = den(1)*den(20)
  den(140) = den(1)*den(14)
  den(141) = den(3)*den(32)
  den(142) = den(3)*den(33)
  den(143) = den(3)*den(43)
  den(144) = den(2)*den(41)
  den(145) = den(3)*den(45)
  den(146) = den(1)*den(41)
  den(147) = den(3)*den(58)
  den(148) = den(2)*den(56)
  den(149) = den(3)*den(60)
  den(150) = den(1)*den(56)
  den(151) = den(12)*den(80)
  den(152) = den(20)*den(77)
  den(153) = den(14)*den(77)
  den(154) = den(3)*den(71)
  den(155) = den(2)*den(73)
  den(156) = den(1)*den(73)
  den(157) = den(12)*den(97)
  den(158) = den(20)*den(95)
  den(159) = den(14)*den(95)
  den(160) = den(12)*den(101)
  den(161) = den(12)*den(118)
  den(162) = den(20)*den(116)
  den(163) = den(14)*den(116)
  den(164) = den(12)*den(121)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvv_ew_bbxzwwx_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,311))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(2,hel_states))
  allocate(M0_col1_helarray(2,hel_states))
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(2,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppvvv_ew_bbxzwwx_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for bottom anti-bottom Z W- W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppvvv_ew_bbxzwwx_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppvvv_ew_bbxzwwx_1, only: &
    & external_perm_ppvvv_ew_bbxzwwx_1, &
    & external_perm_inv_ppvvv_ew_bbxzwwx_1, &
    & extcomb_perm_ppvvv_ew_bbxzwwx_1, &
    & average_factor_ppvvv_ew_bbxzwwx_1
  use ol_external_ppvvv_ew_bbxzwwx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppvvv_ew_bbxzwwx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppvvv_ew_bbxzwwx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppvvv_ew_bbxzwwx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,311))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMB, nMB, nMZ, nMW, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppvvv_ew_bbxzwwx_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMB, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMB, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rMZ, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMW, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMW, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_WWV_V(ntry, ex4(:), ex5(:), ex3(:), wf27(:,1), n4(:,1), t4x27(:,:,1))
  call vert_QA_Z(gZd,ntry, ex1(:), ex2(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_VV_S(ntry, ex3(:), ex4(:), wf9(:,1), n3(:,4), t3x9(:,:,1))
  call vert_TV_S(ntry, wf4(:,3), 3, ex5(:), 16, wf12(:,1), n3(:,5), t3x12(:,:,1))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,4), n3(:,6), t3x4(:,:,4))
  call vert_TV_S(ntry, wf4(:,4), 3, ex5(:), 16, wf12(:,2), n3(:,7), t3x12(:,:,2))
  call vert_UV_W(ntry, ex4(:), 8, ex3(:), 4, wf9(:,2), n3(:,8), t3x9(:,:,2))
  call vert_SV_V(ntry, wf4(:,3), ex5(:), wf12(:,3), n3(:,9), t3x12(:,:,3))
  call vert_VV_S(ntry, wf4(:,1), ex5(:), wf12(:,4), n3(:,10), t3x12(:,:,4))
  call vert_VV_S(ntry, wf4(:,2), ex5(:), wf12(:,5), n3(:,11), t3x12(:,:,5))
  call vert_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,6), n3(:,12), t3x12(:,:,6))
  call vert_UV_W(ntry, wf4(:,2), 3, ex5(:), 16, wf12(:,7), n3(:,13), t3x12(:,:,7))
  call vert_VV_S(ntry, ex3(:), ex5(:), wf9(:,3), n3(:,14), t3x9(:,:,3))
  call vert_TV_S(ntry, wf4(:,3), 3, ex4(:), 8, wf12(:,8), n3(:,15), t3x12(:,:,8))
  call vert_TV_S(ntry, wf4(:,4), 3, ex4(:), 8, wf12(:,9), n3(:,16), t3x12(:,:,9))
  call vert_UV_W(ntry, ex3(:), 4, ex5(:), 16, wf9(:,4), n3(:,17), t3x9(:,:,4))
  call vert_SV_V(ntry, wf4(:,3), ex4(:), wf12(:,10), n3(:,18), t3x12(:,:,10))
  call vert_VV_S(ntry, wf4(:,1), ex4(:), wf12(:,11), n3(:,19), t3x12(:,:,11))
  call vert_VV_S(ntry, wf4(:,2), ex4(:), wf12(:,12), n3(:,20), t3x12(:,:,12))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,1), 3, wf12(:,13), n3(:,21), t3x12(:,:,13))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,2), 3, wf12(:,14), n3(:,22), t3x12(:,:,14))
  call vert_VV_S(ntry, ex4(:), ex5(:), wf9(:,5), n3(:,23), t3x9(:,:,5))
  call vert_VS_T(ntry, ex3(:), 4, wf4(:,4), 3, wf12(:,15), n3(:,24), t3x12(:,:,15))
  call vert_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,6), n3(:,25), t3x9(:,:,6))
  call vert_SV_V(ntry, wf4(:,3), ex3(:), wf12(:,16), n3(:,26), t3x12(:,:,16))
  call vert_VV_S(ntry, wf4(:,2), ex3(:), wf12(:,17), n3(:,27), t3x12(:,:,17))
  call vert_ZQ_A(gZd,ntry, ex3(:), ex1(:), wf6(:,1), n3(:,28), t3x6(:,:,1))
  call vert_AW_Q(ntry, ex2(:), ex4(:), wf6(:,2), n3(:,29), t3x6(:,:,2))
  call prop_Q_A(ntry, wf6(:,1), 5, MB, 1_intkind1, wf6(:,3), n2(1))
  call prop_A_Q(ntry, wf6(:,2), 10, MT, 1_intkind1, wf6(:,4), n2(2))
  call vert_WQ_A(ntry, ex5(:), wf6(:,3), wf18(:,1), n3(:,30), t3x18(:,:,1))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,3), wf12(:,18), n3(:,31), t3x12(:,:,18))
  call vert_QA_V(ntry, wf6(:,3), ex2(:), wf12(:,19), n3(:,32), t3x12(:,:,19))
  call vert_QA_Z(gZd,ntry, wf6(:,3), ex2(:), wf12(:,20), n3(:,33), t3x12(:,:,20))
  call vert_WQ_A(ntry, ex5(:), ex1(:), wf6(:,5), n3(:,34), t3x6(:,:,3))
  call vert_AZ_Q(gZd,ntry, ex2(:), ex3(:), wf6(:,6), n3(:,35), t3x6(:,:,4))
  call prop_Q_A(ntry, wf6(:,5), 17, MT, 1_intkind1, wf6(:,7), n2(3))
  call prop_A_Q(ntry, wf6(:,6), 6, MB, 1_intkind1, wf6(:,8), n2(4))
  call vert_WQ_A(ntry, ex4(:), wf6(:,7), wf18(:,2), n3(:,36), t3x18(:,:,2))
  call vert_AQ_S(gH,ntry, wf6(:,8), ex1(:), wf12(:,21), n3(:,37), t3x12(:,:,21))
  call vert_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,22), n3(:,38), t3x12(:,:,22))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,8), wf12(:,23), n3(:,39), t3x12(:,:,23))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,7), wf18(:,3), n3(:,40), t3x18(:,:,3))
  call vert_AQ_S(gPtb,ntry, wf6(:,4), ex1(:), wf12(:,24), n3(:,41), t3x12(:,:,24))
  call vert_QA_W(ntry, ex1(:), wf6(:,4), wf12(:,25), n3(:,42), t3x12(:,:,25))
  call vert_AQ_S(gPbt,ntry, ex2(:), wf6(:,7), wf12(:,26), n3(:,43), t3x12(:,:,26))
  call vert_QA_W(ntry, wf6(:,7), ex2(:), wf12(:,27), n3(:,44), t3x12(:,:,27))
  call counter_WWV_V(EWctWWAZ,ntry, ex4(:), ex5(:), ex3(:), wf27(:,2), n4(:,2), t4x27(:,:,2))
  call counter_WWV_V(EWctWWZZ,ntry, ex4(:), ex5(:), ex3(:), wf27(:,3), n4(:,3), t4x27(:,:,3))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,5), n3(:,45), t3x4(:,:,5))
  call counter_QA_V_LR(EWctAbb,ntry, ex1(:), ex2(:), wf4(:,6), n3(:,46), t3x4(:,:,6))
  call counter_QA_Z(gZd,ntry, ex1(:), ex2(:), wf4(:,7), n3(:,47), t3x4(:,:,7))
  call counter_QA_Z(EWctVbb,ntry, ex1(:), ex2(:), wf4(:,8), n3(:,48), t3x4(:,:,8))
  call counter_TV_S(ntry, wf4(:,3), 3, ex5(:), 16, wf12(:,28), n3(:,49), t3x12(:,:,28))
  call counter_TV_S(ntry, wf4(:,4), 3, ex5(:), 16, wf12(:,29), n3(:,50), t3x12(:,:,29))
  call counter_SV_V(ntry, wf4(:,3), ex5(:), wf12(:,30), n3(:,51), t3x12(:,:,30))
  call counter_VV_S(ntry, wf4(:,1), ex5(:), wf12(:,31), n3(:,52), t3x12(:,:,31))
  call counter_VV_S(ntry, wf4(:,2), ex5(:), wf12(:,32), n3(:,53), t3x12(:,:,32))
  call counter_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,33), n3(:,54), t3x12(:,:,33))
  call counter_UV_W(ntry, wf4(:,2), 3, ex5(:), 16, wf12(:,34), n3(:,55), t3x12(:,:,34))
  call counter_TV_S(ntry, wf4(:,3), 3, ex4(:), 8, wf12(:,35), n3(:,56), t3x12(:,:,35))
  call counter_TV_S(ntry, wf4(:,4), 3, ex4(:), 8, wf12(:,36), n3(:,57), t3x12(:,:,36))
  call counter_SV_V(ntry, wf4(:,3), ex4(:), wf12(:,37), n3(:,58), t3x12(:,:,37))
  call counter_VV_S(ntry, wf4(:,1), ex4(:), wf12(:,38), n3(:,59), t3x12(:,:,38))
  call counter_VV_S(ntry, wf4(:,2), ex4(:), wf12(:,39), n3(:,60), t3x12(:,:,39))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,1), 3, wf12(:,40), n3(:,61), t3x12(:,:,40))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,2), 3, wf12(:,41), n3(:,62), t3x12(:,:,41))
  call counter_VV_S(ntry, ex4(:), ex5(:), wf9(:,7), n3(:,63), t3x9(:,:,7))
  call counter_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,8), n3(:,64), t3x9(:,:,8))
  call counter_S_V(EWctXA,ntry, wf4(:,4), 3, wf4(:,9), n2(5))
  call counter_S_V(EWctXZ,ntry, wf4(:,4), 3, wf4(:,10), n2(6))
  call counter_V_V(EWctAA,ntry, wf4(:,1), 3, wf4(:,11), n2(7))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 3, wf4(:,12), n2(8))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 3, wf4(:,13), n2(9))
  call counter_V_V(EWctZZ,ntry, wf4(:,2), 3, wf4(:,14), n2(10))
  call counter_VS_T(ntry, ex3(:), 4, wf4(:,4), 3, wf12(:,42), n3(:,65), t3x12(:,:,42))
  call counter_SV_V(ntry, wf4(:,3), ex3(:), wf12(:,43), n3(:,66), t3x12(:,:,43))
  call counter_VV_S(ntry, wf4(:,1), ex3(:), wf12(:,44), n3(:,67), t3x12(:,:,44))
  call counter_VV_S(ntry, wf4(:,2), ex3(:), wf12(:,45), n3(:,68), t3x12(:,:,45))
  call counter_VV_S(ntry, ex3(:), ex5(:), wf9(:,9), n3(:,69), t3x9(:,:,9))
  call counter_UV_W(ntry, ex3(:), 4, ex5(:), 16, wf9(:,10), n3(:,70), t3x9(:,:,10))
  call counter_VV_S(ntry, ex3(:), ex4(:), wf9(:,11), n3(:,71), t3x9(:,:,11))
  call counter_UV_W(ntry, ex4(:), 8, ex3(:), 4, wf9(:,12), n3(:,72), t3x9(:,:,12))
  call counter_WQ_A(ntry, ex5(:), wf6(:,3), wf18(:,4), n3(:,73), t3x18(:,:,4))
  call counter_WQ_A(ntry, ex4(:), wf6(:,7), wf18(:,5), n3(:,74), t3x18(:,:,5))
  call counter_ZQ_A(gZu,ntry, ex3(:), wf6(:,7), wf18(:,6), n3(:,75), t3x18(:,:,6))
  call counter_ZQ_A(EWctVtt,ntry, ex3(:), wf6(:,7), wf18(:,7), n3(:,76), t3x18(:,:,7))
  call counter_AQ_S(gH,ntry, ex2(:), wf6(:,3), wf12(:,46), n3(:,77), t3x12(:,:,46))
  call counter_AQ_S(EWctHbb,ntry, ex2(:), wf6(:,3), wf12(:,47), n3(:,78), t3x12(:,:,47))
  call counter_QA_V(ntry, wf6(:,3), ex2(:), wf12(:,48), n3(:,79), t3x12(:,:,48))
  call counter_QA_V_LR(EWctAbb,ntry, wf6(:,3), ex2(:), wf12(:,49), n3(:,80), t3x12(:,:,49))
  call counter_QA_Z(gZd,ntry, wf6(:,3), ex2(:), wf12(:,50), n3(:,81), t3x12(:,:,50))
  call counter_QA_Z(EWctVbb,ntry, wf6(:,3), ex2(:), wf12(:,51), n3(:,82), t3x12(:,:,51))
  call counter_AW_Q(ntry, ex2(:), ex4(:), wf6(:,9), n3(:,83), t3x6(:,:,5))
  call prop_A_Q(ntry, wf6(:,9), 10, MT, 1_intkind1, wf6(:,10), n2(11))
  call counter_AQ_S(ctSbt,ntry, ex2(:), wf6(:,7), wf12(:,52), n3(:,84), t3x12(:,:,52))
  call counter_AQ_S(EWctPbt,ntry, ex2(:), wf6(:,7), wf12(:,53), n3(:,85), t3x12(:,:,53))
  call counter_QA_W(ntry, wf6(:,7), ex2(:), wf12(:,54), n3(:,86), t3x12(:,:,54))
  call vert_AQ_S(gPtb,ntry, wf6(:,10), ex1(:), wf12(:,55), n3(:,87), t3x12(:,:,55))
  call vert_QA_W(ntry, ex1(:), wf6(:,10), wf12(:,56), n3(:,88), t3x12(:,:,56))
  call counter_AZ_Q(gZd,ntry, ex2(:), ex3(:), wf6(:,11), n3(:,89), t3x6(:,:,6))
  call prop_A_Q(ntry, wf6(:,11), 6, MB, 1_intkind1, wf6(:,12), n2(12))
  call counter_AZ_Q(EWctVbb,ntry, ex2(:), ex3(:), wf6(:,13), n3(:,90), t3x6(:,:,7))
  call prop_A_Q(ntry, wf6(:,13), 6, MB, 1_intkind1, wf6(:,14), n2(13))
  call vert_AQ_S(gH,ntry, wf6(:,12), ex1(:), wf12(:,57), n3(:,91), t3x12(:,:,57))
  call vert_AQ_S(gH,ntry, wf6(:,14), ex1(:), wf12(:,58), n3(:,92), t3x12(:,:,58))
  call vert_QA_V(ntry, ex1(:), wf6(:,12), wf12(:,59), n3(:,93), t3x12(:,:,59))
  call vert_QA_V(ntry, ex1(:), wf6(:,14), wf12(:,60), n3(:,94), t3x12(:,:,60))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,12), wf12(:,61), n3(:,95), t3x12(:,:,61))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,14), wf12(:,62), n3(:,96), t3x12(:,:,62))
  call counter_AQ_S(gH,ntry, wf6(:,8), ex1(:), wf12(:,63), n3(:,97), t3x12(:,:,63))
  call counter_AQ_S(EWctHbb,ntry, wf6(:,8), ex1(:), wf12(:,64), n3(:,98), t3x12(:,:,64))
  call counter_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,65), n3(:,99), t3x12(:,:,65))
  call counter_QA_V_LR(EWctAbb,ntry, ex1(:), wf6(:,8), wf12(:,66), n3(:,100), t3x12(:,:,66))
  call counter_QA_Z(gZd,ntry, ex1(:), wf6(:,8), wf12(:,67), n3(:,101), t3x12(:,:,67))
  call counter_QA_Z(EWctVbb,ntry, ex1(:), wf6(:,8), wf12(:,68), n3(:,102), t3x12(:,:,68))
  call counter_WQ_A(ntry, ex5(:), ex1(:), wf6(:,15), n3(:,103), t3x6(:,:,8))
  call prop_Q_A(ntry, wf6(:,15), 17, MT, 1_intkind1, wf6(:,16), n2(14))
  call vert_WQ_A(ntry, ex4(:), wf6(:,16), wf18(:,8), n3(:,104), t3x18(:,:,8))
  call counter_AQ_S(ctStb,ntry, wf6(:,4), ex1(:), wf12(:,69), n3(:,105), t3x12(:,:,69))
  call counter_AQ_S(EWctPtb,ntry, wf6(:,4), ex1(:), wf12(:,70), n3(:,106), t3x12(:,:,70))
  call counter_QA_W(ntry, ex1(:), wf6(:,4), wf12(:,71), n3(:,107), t3x12(:,:,71))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,16), wf18(:,9), n3(:,108), t3x18(:,:,9))
  call vert_AQ_S(gPbt,ntry, ex2(:), wf6(:,16), wf12(:,72), n3(:,109), t3x12(:,:,72))
  call vert_QA_W(ntry, wf6(:,16), ex2(:), wf12(:,73), n3(:,110), t3x12(:,:,73))
  call counter_ZQ_A(gZd,ntry, ex3(:), ex1(:), wf6(:,17), n3(:,111), t3x6(:,:,9))
  call prop_Q_A(ntry, wf6(:,17), 5, MB, 1_intkind1, wf6(:,18), n2(15))
  call vert_WQ_A(ntry, ex5(:), wf6(:,18), wf18(:,10), n3(:,112), t3x18(:,:,10))
  call counter_ZQ_A(EWctVbb,ntry, ex3(:), ex1(:), wf6(:,19), n3(:,113), t3x6(:,:,10))
  call prop_Q_A(ntry, wf6(:,19), 5, MB, 1_intkind1, wf6(:,20), n2(16))
  call vert_WQ_A(ntry, ex5(:), wf6(:,20), wf18(:,11), n3(:,114), t3x18(:,:,11))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,18), wf12(:,74), n3(:,115), t3x12(:,:,74))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,20), wf12(:,75), n3(:,116), t3x12(:,:,75))
  call vert_QA_V(ntry, wf6(:,18), ex2(:), wf12(:,76), n3(:,117), t3x12(:,:,76))
  call vert_QA_V(ntry, wf6(:,20), ex2(:), wf12(:,77), n3(:,118), t3x12(:,:,77))
  call vert_QA_Z(gZd,ntry, wf6(:,18), ex2(:), wf12(:,78), n3(:,119), t3x12(:,:,78))
  call vert_QA_Z(gZd,ntry, wf6(:,20), ex2(:), wf12(:,79), n3(:,120), t3x12(:,:,79))
  call counter_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,15), n3(:,121), t3x4(:,:,9))
  call vert_TV_S(ntry, wf4(:,15), 3, ex5(:), 16, wf12(:,80), n3(:,122), t3x12(:,:,80))
  call counter_AQ_S(EWctHbb,ntry, ex2(:), ex1(:), wf4(:,16), n3(:,123), t3x4(:,:,10))
  call vert_TV_S(ntry, wf4(:,16), 3, ex5(:), 16, wf12(:,81), n3(:,124), t3x12(:,:,81))
  call counter_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,17), n3(:,125), t3x4(:,:,11))
  call vert_TV_S(ntry, wf4(:,17), 3, ex5(:), 16, wf12(:,82), n3(:,126), t3x12(:,:,82))
  call counter_AQ_S(EWctXbb,ntry, ex2(:), ex1(:), wf4(:,18), n3(:,127), t3x4(:,:,12))
  call vert_TV_S(ntry, wf4(:,18), 3, ex5(:), 16, wf12(:,83), n3(:,128), t3x12(:,:,83))
  call vert_SV_V(ntry, wf4(:,15), ex5(:), wf12(:,84), n3(:,129), t3x12(:,:,84))
  call vert_SV_V(ntry, wf4(:,16), ex5(:), wf12(:,85), n3(:,130), t3x12(:,:,85))
  call vert_VV_S(ntry, wf4(:,5), ex5(:), wf12(:,86), n3(:,131), t3x12(:,:,86))
  call vert_VV_S(ntry, wf4(:,6), ex5(:), wf12(:,87), n3(:,132), t3x12(:,:,87))
  call vert_VV_S(ntry, wf4(:,7), ex5(:), wf12(:,88), n3(:,133), t3x12(:,:,88))
  call vert_VV_S(ntry, wf4(:,8), ex5(:), wf12(:,89), n3(:,134), t3x12(:,:,89))
  call vert_UV_W(ntry, wf4(:,5), 3, ex5(:), 16, wf12(:,90), n3(:,135), t3x12(:,:,90))
  call vert_UV_W(ntry, wf4(:,6), 3, ex5(:), 16, wf12(:,91), n3(:,136), t3x12(:,:,91))
  call vert_UV_W(ntry, wf4(:,7), 3, ex5(:), 16, wf12(:,92), n3(:,137), t3x12(:,:,92))
  call vert_UV_W(ntry, wf4(:,8), 3, ex5(:), 16, wf12(:,93), n3(:,138), t3x12(:,:,93))
  call vert_TV_S(ntry, wf4(:,15), 3, ex4(:), 8, wf12(:,94), n3(:,139), t3x12(:,:,94))
  call vert_TV_S(ntry, wf4(:,16), 3, ex4(:), 8, wf12(:,95), n3(:,140), t3x12(:,:,95))
  call vert_TV_S(ntry, wf4(:,17), 3, ex4(:), 8, wf12(:,96), n3(:,141), t3x12(:,:,96))
  call vert_TV_S(ntry, wf4(:,18), 3, ex4(:), 8, wf12(:,97), n3(:,142), t3x12(:,:,97))
  call vert_SV_V(ntry, wf4(:,15), ex4(:), wf12(:,98), n3(:,143), t3x12(:,:,98))
  call vert_SV_V(ntry, wf4(:,16), ex4(:), wf12(:,99), n3(:,144), t3x12(:,:,99))
  call vert_VV_S(ntry, wf4(:,5), ex4(:), wf12(:,100), n3(:,145), t3x12(:,:,100))
  call vert_VV_S(ntry, wf4(:,6), ex4(:), wf12(:,101), n3(:,146), t3x12(:,:,101))
  call vert_VV_S(ntry, wf4(:,7), ex4(:), wf12(:,102), n3(:,147), t3x12(:,:,102))
  call vert_VV_S(ntry, wf4(:,8), ex4(:), wf12(:,103), n3(:,148), t3x12(:,:,103))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,5), 3, wf12(:,104), n3(:,149), t3x12(:,:,104))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,6), 3, wf12(:,105), n3(:,150), t3x12(:,:,105))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,7), 3, wf12(:,106), n3(:,151), t3x12(:,:,106))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,8), 3, wf12(:,107), n3(:,152), t3x12(:,:,107))
  call vert_VS_T(ntry, ex3(:), 4, wf4(:,17), 3, wf12(:,108), n3(:,153), t3x12(:,:,108))
  call vert_VS_T(ntry, ex3(:), 4, wf4(:,18), 3, wf12(:,109), n3(:,154), t3x12(:,:,109))
  call vert_SV_V(ntry, wf4(:,15), ex3(:), wf12(:,110), n3(:,155), t3x12(:,:,110))
  call vert_SV_V(ntry, wf4(:,16), ex3(:), wf12(:,111), n3(:,156), t3x12(:,:,111))
  call vert_VV_S(ntry, wf4(:,7), ex3(:), wf12(:,112), n3(:,157), t3x12(:,:,112))
  call vert_VV_S(ntry, wf4(:,8), ex3(:), wf12(:,113), n3(:,158), t3x12(:,:,113))
  call vert_VS_T(ntry, ex5(:), 16, wf9(:,1), 12, wf27(:,4), n3(:,159), t3x27(:,:,1))
  call counter_S_S(EWctHH,ntry, wf4(:,3), 3, wf4(:,19), n2(17))
  call counter_S_S(EWctXX,ntry, wf4(:,4), 3, wf4(:,20), n2(18))
  call vert_VV_S(ntry, wf9(:,2), ex5(:), wf27(:,5), n3(:,160), t3x27(:,:,2))
  call vert_SV_V(ntry, wf9(:,1), ex5(:), wf27(:,6), n3(:,161), t3x27(:,:,3))
  call vert_UV_W(ntry, ex5(:), 16, wf9(:,2), 12, wf27(:,7), n3(:,162), t3x27(:,:,4))
  call counter_V_S(EWctXA,ntry, wf4(:,1), 3, wf4(:,21), n2(19))
  call counter_V_S(EWctXZ,ntry, wf4(:,2), 3, wf4(:,22), n2(20))
  call counter_S_S(EWctPP,ntry, wf9(:,1), 12, wf9(:,13), n2(21))
  call counter_S_V(EWctPW,ntry, wf9(:,1), 12, wf9(:,14), n2(22))
  call counter_V_S(EWctPW,ntry, wf9(:,2), 12, wf9(:,15), n2(23))
  call counter_V_V(EWctWW,ntry, wf9(:,2), 12, wf9(:,16), n2(24))
  call vert_VS_T(ntry, ex4(:), 8, wf9(:,3), 20, wf27(:,8), n3(:,163), t3x27(:,:,5))
  call vert_VV_S(ntry, ex4(:), wf9(:,4), wf27(:,9), n3(:,164), t3x27(:,:,6))
  call vert_SV_V(ntry, wf9(:,3), ex4(:), wf27(:,10), n3(:,165), t3x27(:,:,7))
  call vert_UV_W(ntry, wf9(:,4), 20, ex4(:), 8, wf27(:,11), n3(:,166), t3x27(:,:,8))
  call counter_S_S(EWctPP,ntry, wf9(:,3), 20, wf9(:,17), n2(25))
  call counter_S_V(EWctPW,ntry, wf9(:,3), 20, wf9(:,18), n2(26))
  call counter_V_S(EWctPW,ntry, wf9(:,4), 20, wf9(:,19), n2(27))
  call counter_V_V(EWctWW,ntry, wf9(:,4), 20, wf9(:,20), n2(28))
  call vert_TV_S(ntry, wf9(:,5), 24, ex3(:), 4, wf27(:,12), n3(:,167), t3x27(:,:,9))
  call vert_VV_S(ntry, ex3(:), wf9(:,6), wf27(:,13), n3(:,168), t3x27(:,:,10))
  call vert_SV_V(ntry, wf9(:,5), ex3(:), wf27(:,14), n3(:,169), t3x27(:,:,11))
  call counter_S_S(EWctHH,ntry, wf9(:,5), 24, wf9(:,21), n2(29))
  call vert_TV_S(ntry, wf4(:,3), 3, ex3(:), 4, wf12(:,114), n3(:,170), t3x12(:,:,114))
  call counter_V_S(EWctXA,ntry, wf9(:,6), 24, wf9(:,22), n2(30))
  call counter_V_S(EWctXZ,ntry, wf9(:,6), 24, wf9(:,23), n2(31))
  call counter_V_V(EWctAZ,ntry, wf9(:,6), 24, wf9(:,24), n2(32))
  call counter_V_V(EWctZZ,ntry, wf9(:,6), 24, wf9(:,25), n2(33))
  call vert_AW_Q(ntry, wf6(:,4), ex5(:), wf18(:,12), n3(:,171), t3x18(:,:,12))
  call counter_Q_A(ctbb,5,ntry, wf6(:,3), 5, wf6(:,21), n2(34))
  call prop_A_Q(ntry, wf18(:,12), 26, MB, 1_intkind1, wf18(:,13), n2(35))
  call counter_Q_A_LR(EWctbb,ntry, wf6(:,3), 5, wf6(:,22), n2(36))
  call counter_A_Q(cttt,6,ntry, wf6(:,4), 10, wf6(:,23), n2(37))
  call prop_Q_A(ntry, wf18(:,1), 21, MT, 1_intkind1, wf18(:,14), n2(38))
  call counter_A_Q_LR(EWcttt,ntry, wf6(:,4), 10, wf6(:,24), n2(39))
  call vert_SA_Q(gH,ntry, wf9(:,5), ex2(:), wf18(:,15), n3(:,172), t3x18(:,:,13))
  call prop_A_Q(ntry, wf18(:,15), 26, MB, 1_intkind1, wf18(:,16), n2(40))
  call vert_AV_Q(ntry, ex2(:), wf9(:,6), wf18(:,17), n3(:,173), t3x18(:,:,14))
  call prop_A_Q(ntry, wf18(:,17), 26, MB, 1_intkind1, wf18(:,18), n2(41))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf9(:,6), wf18(:,19), n3(:,174), t3x18(:,:,15))
  call prop_A_Q(ntry, wf18(:,19), 26, MB, 1_intkind1, wf18(:,20), n2(42))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,3), wf12(:,115), n3(:,175), t3x12(:,:,115))
  call counter_V_V(EWctAA,ntry, wf9(:,6), 24, wf9(:,26), n2(43))
  call vert_AW_Q(ntry, wf6(:,8), ex4(:), wf18(:,21), n3(:,176), t3x18(:,:,16))
  call counter_Q_A(cttt,6,ntry, wf6(:,7), 17, wf6(:,25), n2(44))
  call prop_A_Q(ntry, wf18(:,21), 14, MT, 1_intkind1, wf18(:,22), n2(45))
  call counter_Q_A_LR(EWcttt,ntry, wf6(:,7), 17, wf6(:,26), n2(46))
  call counter_A_Q(ctbb,5,ntry, wf6(:,8), 6, wf6(:,27), n2(47))
  call prop_Q_A(ntry, wf18(:,2), 25, MB, 1_intkind1, wf18(:,23), n2(48))
  call counter_A_Q_LR(EWctbb,ntry, wf6(:,8), 6, wf6(:,28), n2(49))
  call vert_QS_A(gH,ntry, ex1(:), wf9(:,5), wf18(:,24), n3(:,177), t3x18(:,:,17))
  call prop_Q_A(ntry, wf18(:,24), 25, MB, 1_intkind1, wf18(:,25), n2(50))
  call vert_VQ_A(ntry, wf9(:,6), ex1(:), wf18(:,26), n3(:,178), t3x18(:,:,18))
  call prop_Q_A(ntry, wf18(:,26), 25, MB, 1_intkind1, wf18(:,27), n2(51))
  call vert_ZQ_A(gZd,ntry, wf9(:,6), ex1(:), wf18(:,28), n3(:,179), t3x18(:,:,19))
  call prop_Q_A(ntry, wf18(:,28), 25, MB, 1_intkind1, wf18(:,29), n2(52))
  call vert_AQ_S(gX,ntry, wf6(:,8), ex1(:), wf12(:,116), n3(:,180), t3x12(:,:,116))
  call vert_AZ_Q(gZu,ntry, wf6(:,4), ex3(:), wf18(:,30), n3(:,181), t3x18(:,:,20))
  call prop_A_Q(ntry, wf18(:,30), 14, MT, 1_intkind1, wf18(:,31), n2(53))
  call prop_Q_A(ntry, wf18(:,3), 21, MT, 1_intkind1, wf18(:,32), n2(54))
  call vert_QS_A(gPtb,ntry, ex1(:), wf9(:,3), wf18(:,33), n3(:,182), t3x18(:,:,21))
  call prop_Q_A(ntry, wf18(:,33), 21, MT, 1_intkind1, wf18(:,34), n2(55))
  call vert_WQ_A(ntry, wf9(:,4), ex1(:), wf18(:,35), n3(:,183), t3x18(:,:,22))
  call prop_Q_A(ntry, wf18(:,35), 21, MT, 1_intkind1, wf18(:,36), n2(56))
  call vert_SA_Q(gPbt,ntry, wf9(:,1), ex2(:), wf18(:,37), n3(:,184), t3x18(:,:,23))
  call prop_A_Q(ntry, wf18(:,37), 14, MT, 1_intkind1, wf18(:,38), n2(57))
  call vert_AW_Q(ntry, ex2(:), wf9(:,2), wf18(:,39), n3(:,185), t3x18(:,:,24))
  call prop_A_Q(ntry, wf18(:,39), 14, MT, 1_intkind1, wf18(:,40), n2(58))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 3
do i3= 1, 3
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,1), wf27(:,1), A(:,1), n3(:,186), t3x108(:,:,1), nhel, den(1))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,2), A(:,2), n3(:,187), t3x108(:,:,2), nhel, den(2))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,1), A(:,3), n3(:,188), t3x108(:,:,3), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,2), A(:,4), n3(:,189), t3x108(:,:,4), nhel, den(6))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,3), A(:,5), n3(:,190), t3x108(:,:,5), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,4), A(:,6), n3(:,191), t3x108(:,:,6), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,5), A(:,7), n3(:,192), t3x108(:,:,7), nhel, den(6))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,6), A(:,8), n3(:,193), t3x108(:,:,8), nhel, den(7))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,7), A(:,9), n3(:,194), t3x108(:,:,9), nhel, den(6))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,8), A(:,10), n3(:,195), t3x108(:,:,10), nhel, den(9))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,9), A(:,11), n3(:,196), t3x108(:,:,11), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,10), A(:,12), n3(:,197), t3x108(:,:,12), nhel, den(9))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,11), A(:,13), n3(:,198), t3x108(:,:,13), nhel, den(11))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,12), A(:,14), n3(:,199), t3x108(:,:,14), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,13), A(:,15), n3(:,200), t3x108(:,:,15), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,14), A(:,16), n3(:,201), t3x108(:,:,16), nhel, den(10))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,15), A(:,17), n3(:,202), t3x108(:,:,17), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,16), A(:,18), n3(:,203), t3x108(:,:,18), nhel, den(15))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,17), A(:,19), n3(:,204), t3x108(:,:,19), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,1), A(:,20), n3(:,205), t3x108(:,:,20), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,18), A(:,21), n3(:,206), t3x108(:,:,21), nhel, den(19))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,19), A(:,22), n3(:,207), t3x108(:,:,22), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,20), A(:,23), n3(:,208), t3x108(:,:,23), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,8), wf18(:,2), A(:,24), n3(:,209), t3x108(:,:,24), nhel, den(25))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,21), A(:,25), n3(:,210), t3x108(:,:,25), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,22), A(:,26), n3(:,211), t3x108(:,:,26), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,23), A(:,27), n3(:,212), t3x108(:,:,27), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,3), A(:,28), n3(:,213), t3x108(:,:,28), nhel, den(29))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,24), A(:,29), n3(:,214), t3x108(:,:,29), nhel, den(30))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,25), A(:,30), n3(:,215), t3x108(:,:,30), nhel, den(30))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,26), A(:,31), n3(:,216), t3x108(:,:,31), nhel, den(31))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,27), A(:,32), n3(:,217), t3x108(:,:,32), nhel, den(31))

    call Hcont_VV(nsync, wf4(:,1), wf27(:,2), A(:,33), n3(:,218), t3x108(:,:,33), nhel, den(1))
    call Hcont_VV(nsync, wf4(:,2), wf27(:,3), A(:,34), n3(:,219), t3x108(:,:,34), nhel, den(2))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,5), A(:,35), n3(:,220), t3x108(:,:,35), nhel, den(32))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,6), A(:,36), n3(:,221), t3x108(:,:,36), nhel, den(32))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,7), A(:,37), n3(:,222), t3x108(:,:,37), nhel, den(33))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,8), A(:,38), n3(:,223), t3x108(:,:,38), nhel, den(33))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,28), A(:,39), n3(:,224), t3x108(:,:,39), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,29), A(:,40), n3(:,225), t3x108(:,:,40), nhel, den(6))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,30), A(:,41), n3(:,226), t3x108(:,:,41), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,31), A(:,42), n3(:,227), t3x108(:,:,42), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,32), A(:,43), n3(:,228), t3x108(:,:,43), nhel, den(6))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,33), A(:,44), n3(:,229), t3x108(:,:,44), nhel, den(7))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,34), A(:,45), n3(:,230), t3x108(:,:,45), nhel, den(6))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,35), A(:,46), n3(:,231), t3x108(:,:,46), nhel, den(9))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,36), A(:,47), n3(:,232), t3x108(:,:,47), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,37), A(:,48), n3(:,233), t3x108(:,:,48), nhel, den(9))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,38), A(:,49), n3(:,234), t3x108(:,:,49), nhel, den(11))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,39), A(:,50), n3(:,235), t3x108(:,:,50), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,40), A(:,51), n3(:,236), t3x108(:,:,51), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,41), A(:,52), n3(:,237), t3x108(:,:,52), nhel, den(10))
    call Hcont_SS(nsync, wf12(:,15), wf9(:,7), A(:,53), n3(:,238), t3x108(:,:,53), nhel, den(13))
    call Hcont_VV(nsync, wf12(:,16), wf9(:,8), A(:,54), n3(:,239), t3x108(:,:,54), nhel, den(15))
    call Hcont_SS(nsync, wf12(:,17), wf9(:,7), A(:,55), n3(:,240), t3x108(:,:,55), nhel, den(13))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,9), A(:,56), n3(:,241), t3x108(:,:,56), nhel, den(34))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,10), A(:,57), n3(:,242), t3x108(:,:,57), nhel, den(35))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,11), A(:,58), n3(:,243), t3x108(:,:,58), nhel, den(36))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,12), A(:,59), n3(:,244), t3x108(:,:,59), nhel, den(37))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,13), A(:,60), n3(:,245), t3x108(:,:,60), nhel, den(34))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,14), A(:,61), n3(:,246), t3x108(:,:,61), nhel, den(35))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,42), A(:,62), n3(:,247), t3x108(:,:,62), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,43), A(:,63), n3(:,248), t3x108(:,:,63), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,43), A(:,64), n3(:,249), t3x108(:,:,64), nhel, den(15))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,44), A(:,65), n3(:,250), t3x108(:,:,65), nhel, den(39))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,45), A(:,66), n3(:,251), t3x108(:,:,66), nhel, den(13))
    call Hcont_SS(nsync, wf12(:,8), wf9(:,9), A(:,67), n3(:,252), t3x108(:,:,67), nhel, den(9))
    call Hcont_SS(nsync, wf12(:,9), wf9(:,9), A(:,68), n3(:,253), t3x108(:,:,68), nhel, den(10))
    call Hcont_VV(nsync, wf12(:,10), wf9(:,10), A(:,69), n3(:,254), t3x108(:,:,69), nhel, den(9))
    call Hcont_SS(nsync, wf12(:,11), wf9(:,9), A(:,70), n3(:,255), t3x108(:,:,70), nhel, den(11))
    call Hcont_SS(nsync, wf12(:,12), wf9(:,9), A(:,71), n3(:,256), t3x108(:,:,71), nhel, den(10))
    call Hcont_VV(nsync, wf12(:,13), wf9(:,10), A(:,72), n3(:,257), t3x108(:,:,72), nhel, den(11))
    call Hcont_VV(nsync, wf12(:,14), wf9(:,10), A(:,73), n3(:,258), t3x108(:,:,73), nhel, den(10))
    call Hcont_SS(nsync, wf12(:,1), wf9(:,11), A(:,74), n3(:,259), t3x108(:,:,74), nhel, den(5))
    call Hcont_SS(nsync, wf12(:,2), wf9(:,11), A(:,75), n3(:,260), t3x108(:,:,75), nhel, den(6))
    call Hcont_VV(nsync, wf12(:,3), wf9(:,12), A(:,76), n3(:,261), t3x108(:,:,76), nhel, den(5))
    call Hcont_SS(nsync, wf12(:,4), wf9(:,11), A(:,77), n3(:,262), t3x108(:,:,77), nhel, den(7))
    call Hcont_SS(nsync, wf12(:,5), wf9(:,11), A(:,78), n3(:,263), t3x108(:,:,78), nhel, den(6))
    call Hcont_VV(nsync, wf12(:,6), wf9(:,12), A(:,79), n3(:,264), t3x108(:,:,79), nhel, den(7))
    call Hcont_VV(nsync, wf12(:,7), wf9(:,12), A(:,80), n3(:,265), t3x108(:,:,80), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,4), A(:,81), n3(:,266), t3x108(:,:,81), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,4), A(:,82), n3(:,267), t3x108(:,:,82), nhel, den(18))
    call Hcont_SS(nsync, wf12(:,18), wf9(:,7), A(:,83), n3(:,268), t3x108(:,:,83), nhel, den(19))
    call Hcont_VV(nsync, wf12(:,19), wf9(:,8), A(:,84), n3(:,269), t3x108(:,:,84), nhel, den(21))
    call Hcont_VV(nsync, wf12(:,20), wf9(:,8), A(:,85), n3(:,270), t3x108(:,:,85), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,8), wf18(:,5), A(:,86), n3(:,271), t3x108(:,:,86), nhel, den(25))
    call Hcont_QA(nsync, wf6(:,8), wf18(:,5), A(:,87), n3(:,272), t3x108(:,:,87), nhel, den(25))
    call Hcont_SS(nsync, wf12(:,21), wf9(:,7), A(:,88), n3(:,273), t3x108(:,:,88), nhel, den(26))
    call Hcont_VV(nsync, wf12(:,22), wf9(:,8), A(:,89), n3(:,274), t3x108(:,:,89), nhel, den(27))
    call Hcont_VV(nsync, wf12(:,23), wf9(:,8), A(:,90), n3(:,275), t3x108(:,:,90), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,6), A(:,91), n3(:,276), t3x108(:,:,91), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,7), A(:,92), n3(:,277), t3x108(:,:,92), nhel, den(29))
    call Hcont_SS(nsync, wf12(:,24), wf9(:,9), A(:,93), n3(:,278), t3x108(:,:,93), nhel, den(30))
    call Hcont_VV(nsync, wf12(:,25), wf9(:,10), A(:,94), n3(:,279), t3x108(:,:,94), nhel, den(30))
    call Hcont_SS(nsync, wf12(:,26), wf9(:,11), A(:,95), n3(:,280), t3x108(:,:,95), nhel, den(31))
    call Hcont_VV(nsync, wf12(:,27), wf9(:,12), A(:,96), n3(:,281), t3x108(:,:,96), nhel, den(31))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,46), A(:,97), n3(:,282), t3x108(:,:,97), nhel, den(19))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,47), A(:,98), n3(:,283), t3x108(:,:,98), nhel, den(19))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,48), A(:,99), n3(:,284), t3x108(:,:,99), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,49), A(:,100), n3(:,285), t3x108(:,:,100), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,50), A(:,101), n3(:,286), t3x108(:,:,101), nhel, den(22))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,51), A(:,102), n3(:,287), t3x108(:,:,102), nhel, den(22))
    call Hcont_QA(nsync, wf18(:,1), wf6(:,10), A(:,103), n3(:,288), t3x108(:,:,103), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,1), wf6(:,10), A(:,104), n3(:,289), t3x108(:,:,104), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,52), A(:,105), n3(:,290), t3x108(:,:,105), nhel, den(31))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,53), A(:,106), n3(:,291), t3x108(:,:,106), nhel, den(31))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,54), A(:,107), n3(:,292), t3x108(:,:,107), nhel, den(31))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,54), A(:,108), n3(:,293), t3x108(:,:,108), nhel, den(31))
    call Hcont_QA(nsync, wf18(:,3), wf6(:,10), A(:,109), n3(:,294), t3x108(:,:,109), nhel, den(29))
    call Hcont_QA(nsync, wf18(:,3), wf6(:,10), A(:,110), n3(:,295), t3x108(:,:,110), nhel, den(29))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,55), A(:,111), n3(:,296), t3x108(:,:,111), nhel, den(30))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,55), A(:,112), n3(:,297), t3x108(:,:,112), nhel, den(30))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,56), A(:,113), n3(:,298), t3x108(:,:,113), nhel, den(30))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,56), A(:,114), n3(:,299), t3x108(:,:,114), nhel, den(30))
    call Hcont_QA(nsync, wf18(:,2), wf6(:,12), A(:,115), n3(:,300), t3x108(:,:,115), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,2), wf6(:,14), A(:,116), n3(:,301), t3x108(:,:,116), nhel, den(25))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,57), A(:,117), n3(:,302), t3x108(:,:,117), nhel, den(26))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,58), A(:,118), n3(:,303), t3x108(:,:,118), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,59), A(:,119), n3(:,304), t3x108(:,:,119), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,60), A(:,120), n3(:,305), t3x108(:,:,120), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,61), A(:,121), n3(:,306), t3x108(:,:,121), nhel, den(28))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,62), A(:,122), n3(:,307), t3x108(:,:,122), nhel, den(28))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,63), A(:,123), n3(:,308), t3x108(:,:,123), nhel, den(26))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,64), A(:,124), n3(:,309), t3x108(:,:,124), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,65), A(:,125), n3(:,310), t3x108(:,:,125), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,66), A(:,126), n3(:,311), t3x108(:,:,126), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,67), A(:,127), n3(:,312), t3x108(:,:,127), nhel, den(28))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,68), A(:,128), n3(:,313), t3x108(:,:,128), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,8), wf18(:,8), A(:,129), n3(:,314), t3x108(:,:,129), nhel, den(25))
    call Hcont_QA(nsync, wf6(:,8), wf18(:,8), A(:,130), n3(:,315), t3x108(:,:,130), nhel, den(25))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,69), A(:,131), n3(:,316), t3x108(:,:,131), nhel, den(30))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,70), A(:,132), n3(:,317), t3x108(:,:,132), nhel, den(30))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,71), A(:,133), n3(:,318), t3x108(:,:,133), nhel, den(30))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,71), A(:,134), n3(:,319), t3x108(:,:,134), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,9), A(:,135), n3(:,320), t3x108(:,:,135), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,9), A(:,136), n3(:,321), t3x108(:,:,136), nhel, den(29))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,72), A(:,137), n3(:,322), t3x108(:,:,137), nhel, den(31))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,72), A(:,138), n3(:,323), t3x108(:,:,138), nhel, den(31))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,73), A(:,139), n3(:,324), t3x108(:,:,139), nhel, den(31))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,73), A(:,140), n3(:,325), t3x108(:,:,140), nhel, den(31))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,10), A(:,141), n3(:,326), t3x108(:,:,141), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,11), A(:,142), n3(:,327), t3x108(:,:,142), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,74), A(:,143), n3(:,328), t3x108(:,:,143), nhel, den(19))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,75), A(:,144), n3(:,329), t3x108(:,:,144), nhel, den(19))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,76), A(:,145), n3(:,330), t3x108(:,:,145), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,77), A(:,146), n3(:,331), t3x108(:,:,146), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,78), A(:,147), n3(:,332), t3x108(:,:,147), nhel, den(22))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,79), A(:,148), n3(:,333), t3x108(:,:,148), nhel, den(22))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,80), A(:,149), n3(:,334), t3x108(:,:,149), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,81), A(:,150), n3(:,335), t3x108(:,:,150), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,82), A(:,151), n3(:,336), t3x108(:,:,151), nhel, den(6))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,83), A(:,152), n3(:,337), t3x108(:,:,152), nhel, den(6))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,84), A(:,153), n3(:,338), t3x108(:,:,153), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,85), A(:,154), n3(:,339), t3x108(:,:,154), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,86), A(:,155), n3(:,340), t3x108(:,:,155), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,87), A(:,156), n3(:,341), t3x108(:,:,156), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,88), A(:,157), n3(:,342), t3x108(:,:,157), nhel, den(6))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,89), A(:,158), n3(:,343), t3x108(:,:,158), nhel, den(6))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,90), A(:,159), n3(:,344), t3x108(:,:,159), nhel, den(7))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,91), A(:,160), n3(:,345), t3x108(:,:,160), nhel, den(7))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,92), A(:,161), n3(:,346), t3x108(:,:,161), nhel, den(6))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,93), A(:,162), n3(:,347), t3x108(:,:,162), nhel, den(6))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,94), A(:,163), n3(:,348), t3x108(:,:,163), nhel, den(9))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,95), A(:,164), n3(:,349), t3x108(:,:,164), nhel, den(9))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,96), A(:,165), n3(:,350), t3x108(:,:,165), nhel, den(10))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,97), A(:,166), n3(:,351), t3x108(:,:,166), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,98), A(:,167), n3(:,352), t3x108(:,:,167), nhel, den(9))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,99), A(:,168), n3(:,353), t3x108(:,:,168), nhel, den(9))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,100), A(:,169), n3(:,354), t3x108(:,:,169), nhel, den(11))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,101), A(:,170), n3(:,355), t3x108(:,:,170), nhel, den(11))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,102), A(:,171), n3(:,356), t3x108(:,:,171), nhel, den(10))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,103), A(:,172), n3(:,357), t3x108(:,:,172), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,104), A(:,173), n3(:,358), t3x108(:,:,173), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,105), A(:,174), n3(:,359), t3x108(:,:,174), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,106), A(:,175), n3(:,360), t3x108(:,:,175), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,107), A(:,176), n3(:,361), t3x108(:,:,176), nhel, den(10))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,108), A(:,177), n3(:,362), t3x108(:,:,177), nhel, den(13))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,109), A(:,178), n3(:,363), t3x108(:,:,178), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,110), A(:,179), n3(:,364), t3x108(:,:,179), nhel, den(15))
    call Hcont_VV(nsync, wf9(:,6), wf12(:,111), A(:,180), n3(:,365), t3x108(:,:,180), nhel, den(15))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,112), A(:,181), n3(:,366), t3x108(:,:,181), nhel, den(13))
    call Hcont_SS(nsync, wf9(:,5), wf12(:,113), A(:,182), n3(:,367), t3x108(:,:,182), nhel, den(13))
    call Hcont_SS(nsync, wf27(:,4), wf4(:,19), A(:,183), n3(:,368), t3x108(:,:,183), nhel, den(42))
    call Hcont_SS(nsync, wf27(:,4), wf4(:,20), A(:,184), n3(:,369), t3x108(:,:,184), nhel, den(44))
    call Hcont_SS(nsync, wf4(:,19), wf27(:,5), A(:,185), n3(:,370), t3x108(:,:,185), nhel, den(42))
    call Hcont_VV(nsync, wf4(:,9), wf27(:,6), A(:,186), n3(:,371), t3x108(:,:,186), nhel, den(46))
    call Hcont_VV(nsync, wf4(:,10), wf27(:,6), A(:,187), n3(:,372), t3x108(:,:,187), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,9), wf27(:,7), A(:,188), n3(:,373), t3x108(:,:,188), nhel, den(46))
    call Hcont_VV(nsync, wf4(:,10), wf27(:,7), A(:,189), n3(:,374), t3x108(:,:,189), nhel, den(44))
    call Hcont_SS(nsync, wf27(:,4), wf4(:,21), A(:,190), n3(:,375), t3x108(:,:,190), nhel, den(47))
    call Hcont_SS(nsync, wf27(:,4), wf4(:,22), A(:,191), n3(:,376), t3x108(:,:,191), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,11), wf27(:,6), A(:,192), n3(:,377), t3x108(:,:,192), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,12), wf27(:,6), A(:,193), n3(:,378), t3x108(:,:,193), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,13), wf27(:,6), A(:,194), n3(:,379), t3x108(:,:,194), nhel, den(46))
    call Hcont_VV(nsync, wf4(:,14), wf27(:,6), A(:,195), n3(:,380), t3x108(:,:,195), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,11), wf27(:,7), A(:,196), n3(:,381), t3x108(:,:,196), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,12), wf27(:,7), A(:,197), n3(:,382), t3x108(:,:,197), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,13), wf27(:,7), A(:,198), n3(:,383), t3x108(:,:,198), nhel, den(46))
    call Hcont_VV(nsync, wf4(:,14), wf27(:,7), A(:,199), n3(:,384), t3x108(:,:,199), nhel, den(44))
    call Hcont_SS(nsync, wf12(:,1), wf9(:,13), A(:,200), n3(:,385), t3x108(:,:,200), nhel, den(51))
    call Hcont_SS(nsync, wf12(:,2), wf9(:,13), A(:,201), n3(:,386), t3x108(:,:,201), nhel, den(53))
    call Hcont_SS(nsync, wf12(:,4), wf9(:,13), A(:,202), n3(:,387), t3x108(:,:,202), nhel, den(55))
    call Hcont_SS(nsync, wf12(:,5), wf9(:,13), A(:,203), n3(:,388), t3x108(:,:,203), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,3), wf9(:,14), A(:,204), n3(:,389), t3x108(:,:,204), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,6), wf9(:,14), A(:,205), n3(:,390), t3x108(:,:,205), nhel, den(55))
    call Hcont_VV(nsync, wf12(:,7), wf9(:,14), A(:,206), n3(:,391), t3x108(:,:,206), nhel, den(53))
    call Hcont_SS(nsync, wf12(:,1), wf9(:,15), A(:,207), n3(:,392), t3x108(:,:,207), nhel, den(51))
    call Hcont_SS(nsync, wf12(:,2), wf9(:,15), A(:,208), n3(:,393), t3x108(:,:,208), nhel, den(53))
    call Hcont_SS(nsync, wf12(:,4), wf9(:,15), A(:,209), n3(:,394), t3x108(:,:,209), nhel, den(55))
    call Hcont_SS(nsync, wf12(:,5), wf9(:,15), A(:,210), n3(:,395), t3x108(:,:,210), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,3), wf9(:,16), A(:,211), n3(:,396), t3x108(:,:,211), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,6), wf9(:,16), A(:,212), n3(:,397), t3x108(:,:,212), nhel, den(55))
    call Hcont_VV(nsync, wf12(:,7), wf9(:,16), A(:,213), n3(:,398), t3x108(:,:,213), nhel, den(53))
    call Hcont_SS(nsync, wf4(:,19), wf27(:,8), A(:,214), n3(:,399), t3x108(:,:,214), nhel, den(57))
    call Hcont_SS(nsync, wf4(:,20), wf27(:,8), A(:,215), n3(:,400), t3x108(:,:,215), nhel, den(59))
    call Hcont_SS(nsync, wf4(:,19), wf27(:,9), A(:,216), n3(:,401), t3x108(:,:,216), nhel, den(57))
    call Hcont_VV(nsync, wf4(:,9), wf27(:,10), A(:,217), n3(:,402), t3x108(:,:,217), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,10), wf27(:,10), A(:,218), n3(:,403), t3x108(:,:,218), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,9), wf27(:,11), A(:,219), n3(:,404), t3x108(:,:,219), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,10), wf27(:,11), A(:,220), n3(:,405), t3x108(:,:,220), nhel, den(59))
    call Hcont_SS(nsync, wf4(:,21), wf27(:,8), A(:,221), n3(:,406), t3x108(:,:,221), nhel, den(62))
    call Hcont_SS(nsync, wf4(:,22), wf27(:,8), A(:,222), n3(:,407), t3x108(:,:,222), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,11), wf27(:,10), A(:,223), n3(:,408), t3x108(:,:,223), nhel, den(63))
    call Hcont_VV(nsync, wf4(:,12), wf27(:,10), A(:,224), n3(:,409), t3x108(:,:,224), nhel, den(62))
    call Hcont_VV(nsync, wf4(:,13), wf27(:,10), A(:,225), n3(:,410), t3x108(:,:,225), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,14), wf27(:,10), A(:,226), n3(:,411), t3x108(:,:,226), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,11), wf27(:,11), A(:,227), n3(:,412), t3x108(:,:,227), nhel, den(63))
    call Hcont_VV(nsync, wf4(:,12), wf27(:,11), A(:,228), n3(:,413), t3x108(:,:,228), nhel, den(62))
    call Hcont_VV(nsync, wf4(:,13), wf27(:,11), A(:,229), n3(:,414), t3x108(:,:,229), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,14), wf27(:,11), A(:,230), n3(:,415), t3x108(:,:,230), nhel, den(59))
    call Hcont_SS(nsync, wf12(:,8), wf9(:,17), A(:,231), n3(:,416), t3x108(:,:,231), nhel, den(66))
    call Hcont_SS(nsync, wf12(:,9), wf9(:,17), A(:,232), n3(:,417), t3x108(:,:,232), nhel, den(68))
    call Hcont_SS(nsync, wf12(:,11), wf9(:,17), A(:,233), n3(:,418), t3x108(:,:,233), nhel, den(70))
    call Hcont_SS(nsync, wf12(:,12), wf9(:,17), A(:,234), n3(:,419), t3x108(:,:,234), nhel, den(68))
    call Hcont_VV(nsync, wf12(:,10), wf9(:,18), A(:,235), n3(:,420), t3x108(:,:,235), nhel, den(66))
    call Hcont_VV(nsync, wf12(:,13), wf9(:,18), A(:,236), n3(:,421), t3x108(:,:,236), nhel, den(70))
    call Hcont_VV(nsync, wf12(:,14), wf9(:,18), A(:,237), n3(:,422), t3x108(:,:,237), nhel, den(68))
    call Hcont_SS(nsync, wf12(:,8), wf9(:,19), A(:,238), n3(:,423), t3x108(:,:,238), nhel, den(66))
    call Hcont_SS(nsync, wf12(:,9), wf9(:,19), A(:,239), n3(:,424), t3x108(:,:,239), nhel, den(68))
    call Hcont_SS(nsync, wf12(:,11), wf9(:,19), A(:,240), n3(:,425), t3x108(:,:,240), nhel, den(70))
    call Hcont_SS(nsync, wf12(:,12), wf9(:,19), A(:,241), n3(:,426), t3x108(:,:,241), nhel, den(68))
    call Hcont_VV(nsync, wf12(:,10), wf9(:,20), A(:,242), n3(:,427), t3x108(:,:,242), nhel, den(66))
    call Hcont_VV(nsync, wf12(:,13), wf9(:,20), A(:,243), n3(:,428), t3x108(:,:,243), nhel, den(70))
    call Hcont_VV(nsync, wf12(:,14), wf9(:,20), A(:,244), n3(:,429), t3x108(:,:,244), nhel, den(68))
    call Hcont_SS(nsync, wf4(:,20), wf27(:,12), A(:,245), n3(:,430), t3x108(:,:,245), nhel, den(72))
    call Hcont_SS(nsync, wf4(:,19), wf27(:,13), A(:,246), n3(:,431), t3x108(:,:,246), nhel, den(74))
    call Hcont_VV(nsync, wf4(:,10), wf27(:,14), A(:,247), n3(:,432), t3x108(:,:,247), nhel, den(72))
    call Hcont_SS(nsync, wf4(:,21), wf27(:,12), A(:,248), n3(:,433), t3x108(:,:,248), nhel, den(75))
    call Hcont_SS(nsync, wf4(:,22), wf27(:,12), A(:,249), n3(:,434), t3x108(:,:,249), nhel, den(72))
    call Hcont_VV(nsync, wf4(:,12), wf27(:,14), A(:,250), n3(:,435), t3x108(:,:,250), nhel, den(75))
    call Hcont_VV(nsync, wf4(:,14), wf27(:,14), A(:,251), n3(:,436), t3x108(:,:,251), nhel, den(72))
    call Hcont_SS(nsync, wf12(:,15), wf9(:,21), A(:,252), n3(:,437), t3x108(:,:,252), nhel, den(78))
    call Hcont_SS(nsync, wf12(:,17), wf9(:,21), A(:,253), n3(:,438), t3x108(:,:,253), nhel, den(78))
    call Hcont_SS(nsync, wf12(:,114), wf9(:,22), A(:,254), n3(:,439), t3x108(:,:,254), nhel, den(81))
    call Hcont_SS(nsync, wf12(:,114), wf9(:,23), A(:,255), n3(:,440), t3x108(:,:,255), nhel, den(82))
    call Hcont_VV(nsync, wf12(:,16), wf9(:,24), A(:,256), n3(:,441), t3x108(:,:,256), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,16), wf9(:,25), A(:,257), n3(:,442), t3x108(:,:,257), nhel, den(82))
    call Hcont_QA(nsync, wf6(:,21), wf18(:,13), A(:,258), n3(:,443), t3x108(:,:,258), nhel, den(85))
    call Hcont_QA(nsync, wf18(:,13), wf6(:,22), A(:,259), n3(:,444), t3x108(:,:,259), nhel, den(85))
    call Hcont_QA(nsync, wf6(:,23), wf18(:,14), A(:,260), n3(:,445), t3x108(:,:,260), nhel, den(88))
    call Hcont_QA(nsync, wf18(:,14), wf6(:,24), A(:,261), n3(:,446), t3x108(:,:,261), nhel, den(88))
    call Hcont_QA(nsync, wf6(:,21), wf18(:,16), A(:,262), n3(:,447), t3x108(:,:,262), nhel, den(90))
    call Hcont_QA(nsync, wf6(:,22), wf18(:,16), A(:,263), n3(:,448), t3x108(:,:,263), nhel, den(90))
    call Hcont_QA(nsync, wf6(:,21), wf18(:,18), A(:,264), n3(:,449), t3x108(:,:,264), nhel, den(92))
    call Hcont_QA(nsync, wf6(:,22), wf18(:,18), A(:,265), n3(:,450), t3x108(:,:,265), nhel, den(92))
    call Hcont_QA(nsync, wf6(:,21), wf18(:,20), A(:,266), n3(:,451), t3x108(:,:,266), nhel, den(94))
    call Hcont_QA(nsync, wf6(:,22), wf18(:,20), A(:,267), n3(:,452), t3x108(:,:,267), nhel, den(94))
    call Hcont_SS(nsync, wf12(:,18), wf9(:,21), A(:,268), n3(:,453), t3x108(:,:,268), nhel, den(96))
    call Hcont_SS(nsync, wf9(:,22), wf12(:,115), A(:,269), n3(:,454), t3x108(:,:,269), nhel, den(98))
    call Hcont_SS(nsync, wf9(:,23), wf12(:,115), A(:,270), n3(:,455), t3x108(:,:,270), nhel, den(99))
    call Hcont_VV(nsync, wf12(:,19), wf9(:,26), A(:,271), n3(:,456), t3x108(:,:,271), nhel, den(102))
    call Hcont_VV(nsync, wf12(:,19), wf9(:,24), A(:,272), n3(:,457), t3x108(:,:,272), nhel, den(103))
    call Hcont_VV(nsync, wf12(:,20), wf9(:,24), A(:,273), n3(:,458), t3x108(:,:,273), nhel, den(98))
    call Hcont_VV(nsync, wf12(:,20), wf9(:,25), A(:,274), n3(:,459), t3x108(:,:,274), nhel, den(99))
    call Hcont_QA(nsync, wf6(:,25), wf18(:,22), A(:,275), n3(:,460), t3x108(:,:,275), nhel, den(106))
    call Hcont_QA(nsync, wf18(:,22), wf6(:,26), A(:,276), n3(:,461), t3x108(:,:,276), nhel, den(106))
    call Hcont_QA(nsync, wf6(:,27), wf18(:,23), A(:,277), n3(:,462), t3x108(:,:,277), nhel, den(109))
    call Hcont_QA(nsync, wf18(:,23), wf6(:,28), A(:,278), n3(:,463), t3x108(:,:,278), nhel, den(109))
    call Hcont_QA(nsync, wf6(:,27), wf18(:,25), A(:,279), n3(:,464), t3x108(:,:,279), nhel, den(111))
    call Hcont_QA(nsync, wf6(:,28), wf18(:,25), A(:,280), n3(:,465), t3x108(:,:,280), nhel, den(111))
    call Hcont_QA(nsync, wf6(:,27), wf18(:,27), A(:,281), n3(:,466), t3x108(:,:,281), nhel, den(113))
    call Hcont_QA(nsync, wf6(:,28), wf18(:,27), A(:,282), n3(:,467), t3x108(:,:,282), nhel, den(113))
    call Hcont_QA(nsync, wf6(:,27), wf18(:,29), A(:,283), n3(:,468), t3x108(:,:,283), nhel, den(115))
    call Hcont_QA(nsync, wf6(:,28), wf18(:,29), A(:,284), n3(:,469), t3x108(:,:,284), nhel, den(115))
    call Hcont_SS(nsync, wf12(:,21), wf9(:,21), A(:,285), n3(:,470), t3x108(:,:,285), nhel, den(117))
    call Hcont_SS(nsync, wf9(:,22), wf12(:,116), A(:,286), n3(:,471), t3x108(:,:,286), nhel, den(119))
    call Hcont_SS(nsync, wf9(:,23), wf12(:,116), A(:,287), n3(:,472), t3x108(:,:,287), nhel, den(120))
    call Hcont_VV(nsync, wf12(:,22), wf9(:,26), A(:,288), n3(:,473), t3x108(:,:,288), nhel, den(122))
    call Hcont_VV(nsync, wf12(:,22), wf9(:,24), A(:,289), n3(:,474), t3x108(:,:,289), nhel, den(123))
    call Hcont_VV(nsync, wf12(:,23), wf9(:,24), A(:,290), n3(:,475), t3x108(:,:,290), nhel, den(119))
    call Hcont_VV(nsync, wf12(:,23), wf9(:,25), A(:,291), n3(:,476), t3x108(:,:,291), nhel, den(120))
    call Hcont_QA(nsync, wf6(:,25), wf18(:,31), A(:,292), n3(:,477), t3x108(:,:,292), nhel, den(125))
    call Hcont_QA(nsync, wf6(:,26), wf18(:,31), A(:,293), n3(:,478), t3x108(:,:,293), nhel, den(125))
    call Hcont_QA(nsync, wf6(:,23), wf18(:,32), A(:,294), n3(:,479), t3x108(:,:,294), nhel, den(127))
    call Hcont_QA(nsync, wf6(:,24), wf18(:,32), A(:,295), n3(:,480), t3x108(:,:,295), nhel, den(127))
    call Hcont_QA(nsync, wf6(:,23), wf18(:,34), A(:,296), n3(:,481), t3x108(:,:,296), nhel, den(129))
    call Hcont_QA(nsync, wf6(:,24), wf18(:,34), A(:,297), n3(:,482), t3x108(:,:,297), nhel, den(129))
    call Hcont_QA(nsync, wf6(:,23), wf18(:,36), A(:,298), n3(:,483), t3x108(:,:,298), nhel, den(129))
    call Hcont_QA(nsync, wf6(:,24), wf18(:,36), A(:,299), n3(:,484), t3x108(:,:,299), nhel, den(129))
    call Hcont_SS(nsync, wf12(:,24), wf9(:,17), A(:,300), n3(:,485), t3x108(:,:,300), nhel, den(131))
    call Hcont_SS(nsync, wf12(:,24), wf9(:,19), A(:,301), n3(:,486), t3x108(:,:,301), nhel, den(131))
    call Hcont_VV(nsync, wf12(:,25), wf9(:,18), A(:,302), n3(:,487), t3x108(:,:,302), nhel, den(131))
    call Hcont_VV(nsync, wf12(:,25), wf9(:,20), A(:,303), n3(:,488), t3x108(:,:,303), nhel, den(131))
    call Hcont_QA(nsync, wf6(:,25), wf18(:,38), A(:,304), n3(:,489), t3x108(:,:,304), nhel, den(133))
    call Hcont_QA(nsync, wf6(:,26), wf18(:,38), A(:,305), n3(:,490), t3x108(:,:,305), nhel, den(133))
    call Hcont_QA(nsync, wf6(:,25), wf18(:,40), A(:,306), n3(:,491), t3x108(:,:,306), nhel, den(133))
    call Hcont_QA(nsync, wf6(:,26), wf18(:,40), A(:,307), n3(:,492), t3x108(:,:,307), nhel, den(133))
    call Hcont_SS(nsync, wf12(:,26), wf9(:,13), A(:,308), n3(:,493), t3x108(:,:,308), nhel, den(135))
    call Hcont_SS(nsync, wf12(:,26), wf9(:,15), A(:,309), n3(:,494), t3x108(:,:,309), nhel, den(135))
    call Hcont_VV(nsync, wf12(:,27), wf9(:,14), A(:,310), n3(:,495), t3x108(:,:,310), nhel, den(135))
    call Hcont_VV(nsync, wf12(:,27), wf9(:,16), A(:,311), n3(:,496), t3x108(:,:,311), nhel, den(135))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(2) ! M1helarray(2,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,22)%j+A(j,26)%j)*f(1)+(-A(j,30)%j-A(j,32)%j)*f(19)-A(j,17)%j*f(25)+A(j,18)%j*f(26)+(A(j,5)%j+A(j,12)%j)*f(27)+( &
       -A(j,20)%j-A(j,24)%j-A(j,28)%j)*f(39)+(A(j,2)%j-A(j,9)%j-A(j,16)%j)*f(40)+(A(j,21)%j+A(j,25)%j)*f(52)+A(j,19)%j*f(73) &
       +(A(j,29)%j-A(j,31)%j)*f(77)+(-A(j,1)%j+A(j,8)%j+A(j,15)%j)*f(78)+(-A(j,23)%j-A(j,27)%j)*f(79)+(A(j,3)%j+A(j,4)%j-A(j,10)%j &
       +A(j,11)%j)*f(92)+(A(j,6)%j+A(j,13)%j)*f(109)+(A(j,7)%j+A(j,14)%j)*f(113)

  M2(1)%j = (-A(j,264)%j-A(j,281)%j)*f(7)+(A(j,99)%j+A(j,119)%j+A(j,125)%j+A(j,145)%j)*f(8)+(A(j,298)%j+A(j,306)%j)*f(23)+( &
       -A(j,107)%j-A(j,113)%j-A(j,133)%j-A(j,139)%j)*f(24)-A(j,177)%j*f(31)+A(j,179)%j*f(32)+(A(j,153)%j+A(j,167)%j)*f(33) &
       +(A(j,258)%j+A(j,260)%j+A(j,275)%j+A(j,277)%j+A(j,292)%j+A(j,294)%j)*f(47)+(-A(j,115)%j-A(j,141)%j)*f(48)+(-A(j,81)%j &
       -A(j,86)%j-A(j,103)%j-A(j,109)%j-A(j,129)%j-A(j,135)%j)*f(49)-A(j,91)%j*f(50)+(A(j,37)%j-A(j,161)%j-A(j,175)%j)*f(51)+( &
       -A(j,262)%j-A(j,279)%j)*f(61)+(A(j,97)%j+A(j,123)%j)*f(62)+(A(j,117)%j+A(j,143)%j)*f(63)+A(j,181)%j*f(76)+(-A(j,105)%j &
       +A(j,131)%j-A(j,296)%j+A(j,304)%j)*f(87)+(A(j,111)%j-A(j,137)%j)*f(88)+(A(j,266)%j+A(j,283)%j)*f(89)+(-A(j,35)%j+A(j,159)%j &
       +A(j,173)%j)*f(90)+(-A(j,101)%j-A(j,121)%j-A(j,127)%j-A(j,147)%j)*f(91)+(A(j,149)%j+A(j,151)%j-A(j,163)%j+A(j,165)%j)*f(95) &
       +(A(j,155)%j+A(j,169)%j)*f(112)+(A(j,157)%j+A(j,171)%j)*f(116)
  M2(2)%j = (-A(j,33)%j+A(j,120)%j+A(j,146)%j-A(j,265)%j-A(j,271)%j-A(j,282)%j-A(j,288)%j)*f(2)+(-A(j,34)%j+A(j,100)%j+A(j,126)%j &
       -A(j,273)%j-A(j,290)%j)*f(3)+(A(j,84)%j+A(j,89)%j)*f(4)+(-A(j,72)%j-A(j,79)%j)*f(5)+(A(j,85)%j+A(j,90)%j)*f(6)+(-A(j,150)%j &
       +A(j,164)%j)*f(9)+(A(j,152)%j+A(j,166)%j)*f(10)+(-A(j,39)%j+A(j,46)%j)*f(11)+(-A(j,40)%j-A(j,47)%j)*f(12)+(A(j,206)%j &
       +A(j,210)%j+A(j,237)%j+A(j,241)%j)*f(13)+(A(j,190)%j+A(j,221)%j)*f(14)+(A(j,191)%j+A(j,222)%j)*f(15)+(-A(j,70)%j &
       -A(j,77)%j)*f(16)+(A(j,186)%j+A(j,217)%j)*f(17)+(A(j,106)%j+A(j,132)%j)*f(18)+(A(j,299)%j+A(j,303)%j+A(j,307)%j &
       +A(j,311)%j)*f(20)+(-A(j,108)%j-A(j,114)%j)*f(21)+(-A(j,134)%j-A(j,140)%j)*f(22)+(A(j,245)%j+A(j,252)%j)*f(28)+(-A(j,246)%j &
       -A(j,257)%j)*f(29)+(-A(j,185)%j-A(j,211)%j-A(j,216)%j-A(j,242)%j)*f(30)+(A(j,301)%j-A(j,309)%j)*f(34)-A(j,255)%j*f(35) &
       +(A(j,207)%j+A(j,208)%j-A(j,238)%j+A(j,239)%j)*f(36)+(A(j,57)%j-A(j,189)%j-A(j,220)%j)*f(37)+A(j,247)%j*f(38)+(-A(j,92)%j &
       -A(j,116)%j-A(j,142)%j+A(j,259)%j+A(j,261)%j+A(j,276)%j+A(j,278)%j+A(j,293)%j+A(j,295)%j)*f(41)+(-A(j,59)%j+A(j,197)%j &
       +A(j,228)%j)*f(42)+(A(j,38)%j-A(j,61)%j-A(j,162)%j-A(j,176)%j+A(j,199)%j+A(j,213)%j+A(j,230)%j+A(j,244)%j)*f(43)+( &
       -A(j,87)%j-A(j,104)%j-A(j,110)%j)*f(44)+(-A(j,82)%j-A(j,130)%j-A(j,136)%j)*f(45)+(A(j,94)%j+A(j,96)%j)*f(46)+(A(j,118)%j &
       +A(j,144)%j-A(j,263)%j-A(j,268)%j-A(j,280)%j-A(j,285)%j)*f(53)+A(j,256)%j*f(54)-A(j,180)%j*f(55)-A(j,178)%j*f(56)+( &
       -A(j,154)%j-A(j,168)%j)*f(57)+(-A(j,69)%j-A(j,76)%j)*f(58)-A(j,54)%j*f(59)+A(j,62)%j*f(60)+(-A(j,93)%j+A(j,95)%j)*f(64) &
       +A(j,254)%j*f(65)+(-A(j,56)%j+A(j,188)%j+A(j,219)%j-A(j,270)%j-A(j,287)%j)*f(66)-A(j,53)%j*f(67)+(A(j,41)%j &
       +A(j,48)%j)*f(68)+A(j,64)%j*f(69)+(A(j,67)%j-A(j,68)%j-A(j,74)%j-A(j,75)%j)*f(70)-A(j,248)%j*f(71)-A(j,249)%j*f(72) &
       -A(j,250)%j*f(74)+(A(j,182)%j-A(j,251)%j-A(j,253)%j)*f(75)+(-A(j,297)%j-A(j,300)%j+A(j,305)%j+A(j,308)%j)*f(80)+(A(j,58)%j &
       -A(j,196)%j-A(j,212)%j-A(j,227)%j-A(j,243)%j+A(j,272)%j+A(j,289)%j)*f(81)+(-A(j,36)%j+A(j,60)%j-A(j,102)%j-A(j,122)%j &
       -A(j,128)%j-A(j,148)%j+A(j,160)%j+A(j,174)%j-A(j,198)%j-A(j,229)%j+A(j,267)%j+A(j,274)%j+A(j,284)%j+A(j,291)%j)*f(82) &
       +(A(j,44)%j+A(j,51)%j)*f(83)+A(j,112)%j*f(84)-A(j,138)%j*f(85)+(A(j,45)%j+A(j,52)%j+A(j,73)%j+A(j,80)%j)*f(86)+(-A(j,98)%j &
       -A(j,124)%j)*f(93)+(-A(j,183)%j-A(j,184)%j-A(j,200)%j-A(j,201)%j+A(j,214)%j-A(j,215)%j+A(j,231)%j-A(j,232)%j)*f(94) &
       +(A(j,269)%j+A(j,286)%j)*f(96)+(A(j,83)%j+A(j,88)%j)*f(97)-A(j,63)%j*f(98)+(A(j,302)%j+A(j,310)%j)*f(99)+(A(j,209)%j &
       +A(j,240)%j)*f(100)+A(j,55)%j*f(101)+A(j,65)%j*f(102)+A(j,66)%j*f(103)+(-A(j,204)%j-A(j,235)%j)*f(104)+(-A(j,205)%j &
       -A(j,236)%j)*f(105)+(-A(j,42)%j-A(j,49)%j)*f(106)+(-A(j,43)%j-A(j,50)%j-A(j,71)%j-A(j,78)%j)*f(107)+(A(j,187)%j &
       +A(j,218)%j)*f(108)+(-A(j,192)%j-A(j,202)%j-A(j,223)%j-A(j,233)%j)*f(110)+(A(j,156)%j+A(j,170)%j-A(j,194)%j &
       -A(j,225)%j)*f(111)+(-A(j,193)%j-A(j,224)%j)*f(114)+(A(j,158)%j+A(j,172)%j-A(j,195)%j-A(j,203)%j-A(j,226)%j &
       -A(j,234)%j)*f(115)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxzwwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxzwwx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxzwwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxzwwx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxzwwx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppvvv_ew_bbxzwwx_1_/**/REALKIND
