
module ol_vamp_1_ppvvv_ew_ddxazz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv_ew_ddxazz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv_ew_ddxazz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvv_ew_ddxazz_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvv_ew_ddxazz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvv_ew_ddxazz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvv_ew_ddxazz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(72)
  type(Hpolcont), intent(in) :: M(2,72)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZd,m3h3x24(:,1),heltab2x72(:,:,1))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(1),n2h24(1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,nMZ,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZd,m3h3x24(:,2),heltab2x72(:,:,2))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(2),n2h24(2))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[0,0,nMW,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZu,m3h3x24(:,3),heltab2x72(:,:,3))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(3),n2h24(3))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZd,m3h3x24(:,4),heltab2x72(:,:,4))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(4),n2h24(4))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(5),m3h3x24(:,5),heltab2x72(:,:,5))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,6),heltab2x72(:,:,6))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(2),m3h3x24(:,7),heltab2x72(:,:,7))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(6),m3h3x24(:,8),heltab2x72(:,:,8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(3),ngZd,m3h3x24(:,9),heltab2x72(:,:,9))
  call Hloop_Q_A(ntryL,G0H24(3),16,0,G1H24(7),n2h24(5))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(3),ngZd,m3h3x24(:,10),heltab2x72(:,:,10))
  call Hloop_Q_A(ntryL,G0H24(3),16,0,G1H24(8),n2h24(6))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(3),ngZu,m3h3x24(:,11),heltab2x72(:,:,11))
  call Hloop_Q_A(ntryL,G0H24(3),16,0,G1H24(9),n2h24(7))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(3),ngZd,m3h3x24(:,12),heltab2x72(:,:,12))
  call Hloop_Q_A(ntryL,G0H24(3),16,0,G1H24(10),n2h24(8))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(13),h0tab(:,13),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(3),m3h3x24(:,13),heltab2x72(:,:,13))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(14),h0tab(:,14),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(11),m3h3x24(:,14),heltab2x72(:,:,14))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(15),h0tab(:,15),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(4),m3h3x24(:,15),heltab2x72(:,:,15))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(16),h0tab(:,16),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(12),m3h3x24(:,16),heltab2x72(:,:,16))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(5),ngZd,m3h3x24(:,17),heltab2x72(:,:,17))
  call Hloop_Q_A(ntryL,G0H24(5),16,0,G1H24(13),n2h24(9))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[0,0,nMZ,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(5),ngZd,m3h3x24(:,18),heltab2x72(:,:,18))
  call Hloop_Q_A(ntryL,G0H24(5),16,0,G1H24(14),n2h24(10))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(19),h0tab(:,19),[16,4,2,1,8],[0,0,nMW,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(5),ngZu,m3h3x24(:,19),heltab2x72(:,:,19))
  call Hloop_Q_A(ntryL,G0H24(5),16,0,G1H24(15),n2h24(11))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(20),h0tab(:,20),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(5),ngZd,m3h3x24(:,20),heltab2x72(:,:,20))
  call Hloop_Q_A(ntryL,G0H24(5),16,0,G1H24(16),n2h24(12))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(21),h0tab(:,21),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(17),m3h3x24(:,21),heltab2x72(:,:,21))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(22),h0tab(:,22),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(5),m3h3x24(:,22),heltab2x72(:,:,22))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(23),h0tab(:,23),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(6),m3h3x24(:,23),heltab2x72(:,:,23))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(24),h0tab(:,24),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(18),m3h3x24(:,24),heltab2x72(:,:,24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(25),h0tab(:,25),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(7),ngZd,m3h3x24(:,25),heltab2x72(:,:,25))
  call Hloop_Q_A(ntryL,G0H24(7),16,0,G1H24(19),n2h24(13))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(26),h0tab(:,26),[16,2,1,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(7),ngZd,m3h3x24(:,26),heltab2x72(:,:,26))
  call Hloop_Q_A(ntryL,G0H24(7),16,0,G1H24(20),n2h24(14))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(27),h0tab(:,27),[16,2,1,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(7),ngZu,m3h3x24(:,27),heltab2x72(:,:,27))
  call Hloop_Q_A(ntryL,G0H24(7),16,0,G1H24(21),n2h24(15))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(28),h0tab(:,28),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(7),ngZd,m3h3x24(:,28),heltab2x72(:,:,28))
  call Hloop_Q_A(ntryL,G0H24(7),16,0,G1H24(22),n2h24(16))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(29),h0tab(:,29),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(7),m3h3x24(:,29),heltab2x72(:,:,29))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(30),h0tab(:,30),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(23),m3h3x24(:,30),heltab2x72(:,:,30))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(31),h0tab(:,31),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(8),m3h3x24(:,31),heltab2x72(:,:,31))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(32),h0tab(:,32),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(24),m3h3x24(:,32),heltab2x72(:,:,32))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(33),h0tab(:,33),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(9),ngZd,m3h3x24(:,33),heltab2x72(:,:,33))
  call Hloop_A_Q(ntryL,G0H24(9),16,0,G1H24(25),n2h24(17))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(34),h0tab(:,34),[16,1,2,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(9),ngZd,m3h3x24(:,34),heltab2x72(:,:,34))
  call Hloop_A_Q(ntryL,G0H24(9),16,0,G1H24(26),n2h24(18))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(35),h0tab(:,35),[16,1,2,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(9),ngZu,m3h3x24(:,35),heltab2x72(:,:,35))
  call Hloop_A_Q(ntryL,G0H24(9),16,0,G1H24(27),n2h24(19))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(36),h0tab(:,36),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(9),ngZd,m3h3x24(:,36),heltab2x72(:,:,36))
  call Hloop_A_Q(ntryL,G0H24(9),16,0,G1H24(28),n2h24(20))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(37),h0tab(:,37),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(9),m3h3x24(:,37),heltab2x72(:,:,37))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(38),h0tab(:,38),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(29),m3h3x24(:,38),heltab2x72(:,:,38))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(39),h0tab(:,39),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(10),m3h3x24(:,39),heltab2x72(:,:,39))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(40),h0tab(:,40),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(30),m3h3x24(:,40),heltab2x72(:,:,40))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(41),h0tab(:,41),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(11),ngZd,m3h3x24(:,41),heltab2x72(:,:,41))
  call Hloop_A_Q(ntryL,G0H24(11),16,0,G1H24(31),n2h24(21))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(42),h0tab(:,42),[16,1,2,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(11),ngZd,m3h3x24(:,42),heltab2x72(:,:,42))
  call Hloop_A_Q(ntryL,G0H24(11),16,0,G1H24(32),n2h24(22))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(43),h0tab(:,43),[16,1,2,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(11),ngZu,m3h3x24(:,43),heltab2x72(:,:,43))
  call Hloop_A_Q(ntryL,G0H24(11),16,0,G1H24(33),n2h24(23))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(44),h0tab(:,44),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(11),ngZd,m3h3x24(:,44),heltab2x72(:,:,44))
  call Hloop_A_Q(ntryL,G0H24(11),16,0,G1H24(34),n2h24(24))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(45),h0tab(:,45),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(11),m3h3x24(:,45),heltab2x72(:,:,45))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(46),h0tab(:,46),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(35),m3h3x24(:,46),heltab2x72(:,:,46))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(47),h0tab(:,47),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(12),m3h3x24(:,47),heltab2x72(:,:,47))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(48),h0tab(:,48),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(36),m3h3x24(:,48),heltab2x72(:,:,48))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(49),h0tab(:,49),[16,2,4,1,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(13),ngZu,m3h3x24(:,49),heltab2x72(:,:,49))
  call Hloop_Q_A(ntryL,G0H24(13),16,0,G1H24(37),n2h24(25))
  Gcoeff(:)%j = (c(36)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(50),h0tab(:,50),[16,2,4,1,8],[nMZ,0,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,50),heltab2x72(:,:,50))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(51),h0tab(:,51),[16,2,4,1,8],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(14),m3h3x24(:,51),heltab2x72(:,:,51))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(52),h0tab(:,52),[16,2,4,1,8],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(38),m3h3x24(:,52),heltab2x72(:,:,52))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(53),h0tab(:,53),[16,2,8,1,4],[0,nMW,nMW,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(15),ngZu,m3h3x24(:,53),heltab2x72(:,:,53))
  call Hloop_Q_A(ntryL,G0H24(15),16,0,G1H24(39),n2h24(26))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(54),h0tab(:,54),[16,2,8,1,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(15),m3h3x24(:,54),heltab2x72(:,:,54))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(55),h0tab(:,55),[16,2,8,1,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(40),m3h3x24(:,55),heltab2x72(:,:,55))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(56),h0tab(:,56),[16,1,4,2,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(16),ngZu,m3h3x24(:,56),heltab2x72(:,:,56))
  call Hloop_A_Q(ntryL,G0H24(16),16,0,G1H24(41),n2h24(27))
  Gcoeff(:)%j = (c(36)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(57),h0tab(:,57),[16,1,4,2,8],[nMZ,0,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(16),m3h3x24(:,57),heltab2x72(:,:,57))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(58),h0tab(:,58),[16,1,4,2,8],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(17),m3h3x24(:,58),heltab2x72(:,:,58))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(59),h0tab(:,59),[16,1,4,2,8],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(42),m3h3x24(:,59),heltab2x72(:,:,59))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(60),h0tab(:,60),[16,1,4,8,2],[nMW,0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(43),m3h3x24(:,60),heltab2x72(:,:,60))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(61),h0tab(:,61),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(18),ngZu,m3h3x24(:,61),heltab2x72(:,:,61))
  call Hloop_A_Q(ntryL,G0H24(18),16,0,G1H24(44),n2h24(28))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(62),h0tab(:,62),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(18),ngZu,m3h3x24(:,62),heltab2x72(:,:,62))
  call Hloop_A_Q(ntryL,G0H24(18),16,0,G1H24(45),n2h24(29))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(63),h0tab(:,63),[16,1,8,2,4],[0,nMW,nMW,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(18),ngZu,m3h3x24(:,63),heltab2x72(:,:,63))
  call Hloop_A_Q(ntryL,G0H24(18),16,0,G1H24(46),n2h24(30))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(64),h0tab(:,64),[16,1,8,2,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(18),m3h3x24(:,64),heltab2x72(:,:,64))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(65),h0tab(:,65),[16,1,8,2,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(47),m3h3x24(:,65),heltab2x72(:,:,65))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(66),h0tab(:,66),[16,1,8,4,2],[nMW,0,0,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(48),m3h3x24(:,66),heltab2x72(:,:,66))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(67),h0tab(:,67),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(19),ngZu,m3h3x24(:,67),heltab2x72(:,:,67))
  call Hloop_A_Q(ntryL,G0H24(19),16,0,G1H24(49),n2h24(31))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(68),h0tab(:,68),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(19),ngZu,m3h3x24(:,68),heltab2x72(:,:,68))
  call Hloop_A_Q(ntryL,G0H24(19),16,0,G1H24(50),n2h24(32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(4),[G1H24(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(10),[G1H24(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(16),[G1H24(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(22),[G1H24(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(28),[G1H24(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(34),[G1H24(31)])
  call Hloop_AV_Q(ntryL,G1H24(4),ex3(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(1),n2h12(1))
  call Hloop_AV_Q(ntryL,G1H24(2),ex3(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(2),n2h12(2))
  call Hloop_AV_Q(ntryL,G1H24(3),ex3(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(3),n2h12(3))
  call Hloop_SV_V(ntryL,G1H24(5),ex3(:),G1H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex3(:),G0H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_UW_V(ntryL,G0H24(2),16,ex3(:),4,G1H12(2),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_UW_V(ntryL,G1H24(6),16,ex3(:),4,G2H12(4),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_QA_V(ntryL,G1H24(10),ex2(:),G1H12(3),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_QA_Z(ntryL,G1H24(8),ex2(:),G1H12(4),ngZd,m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_QA_W(ntryL,G1H24(9),ex2(:),G1H12(5),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_WA_Q(ntryL,G0H24(3),ex2(:),G0H12(2),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_A_Q(ntryL,G0H12(2),18,0,G1H12(6),n2h12(4))
  call Hloop_WA_Q(ntryL,G1H24(11),ex2(:),G1H12(7),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_A_Q(ntryL,G1H12(7),18,0,G2H12(5),n2h12(5))
  call Hloop_WA_Q(ntryL,G0H24(4),ex2(:),G0H12(2),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_A_Q(ntryL,G0H12(2),18,0,G1H12(7),n2h12(6))
  call Hloop_WA_Q(ntryL,G1H24(12),ex2(:),G1H12(8),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_A_Q(ntryL,G1H12(8),18,0,G2H12(6),n2h12(7))
  call Hloop_QV_A(ntryL,G1H24(16),ex3(:),G1H12(8),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_Q_A(ntryL,G1H12(8),20,0,G2H12(7),n2h12(8))
  call Hloop_QV_A(ntryL,G1H24(14),ex3(:),G1H12(8),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_Q_A(ntryL,G1H12(8),20,0,G2H12(8),n2h12(9))
  call Hloop_QV_A(ntryL,G1H24(15),ex3(:),G1H12(8),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_Q_A(ntryL,G1H12(8),20,0,G2H12(9),n2h12(10))
  call Hloop_SV_V(ntryL,G1H24(17),ex3(:),G1H12(8),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_SV_V(ntryL,G0H24(5),ex3(:),G0H12(2),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_UV_W(ntryL,G0H24(6),16,ex3(:),4,G1H12(9),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_UV_W(ntryL,G1H24(18),16,ex3(:),4,G2H12(10),m3h2x12(:,21),heltab2x24(:,:,21))
  call Hloop_QA_V(ntryL,G1H24(22),ex2(:),G1H12(10),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hloop_QA_Z(ntryL,G1H24(20),ex2(:),G1H12(11),ngZd,m3h2x12(:,23),heltab2x24(:,:,23))
  call Hloop_QA_W(ntryL,G1H24(21),ex2(:),G1H12(12),m3h2x12(:,24),heltab2x24(:,:,24))
  call Hloop_WA_Q(ntryL,G0H24(7),ex2(:),G0H12(3),m3h2x12(:,25),heltab2x24(:,:,25))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(13),n2h12(11))
  call Hloop_WA_Q(ntryL,G1H24(23),ex2(:),G1H12(14),m3h2x12(:,26),heltab2x24(:,:,26))
  call Hloop_A_Q(ntryL,G1H12(14),18,0,G2H12(11),n2h12(12))
  call Hloop_WA_Q(ntryL,G0H24(8),ex2(:),G0H12(3),m3h2x12(:,27),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(14),n2h12(13))
  call Hloop_WA_Q(ntryL,G1H24(24),ex2(:),G1H12(15),m3h2x12(:,28),heltab2x24(:,:,28))
  call Hloop_A_Q(ntryL,G1H12(15),18,0,G2H12(12),n2h12(14))
  call Hloop_AQ_V(ntryL,G1H24(28),ex1(:),G1H12(15),m3h2x12(:,29),heltab2x24(:,:,29))
  call Hloop_AQ_Z(ntryL,G1H24(26),ex1(:),G1H12(16),ngZd,m3h2x12(:,30),heltab2x24(:,:,30))
  call Hloop_AQ_W(ntryL,G1H24(27),ex1(:),G1H12(17),m3h2x12(:,31),heltab2x24(:,:,31))
  call Hloop_WQ_A(ntryL,G0H24(9),ex1(:),G0H12(3),m3h2x12(:,32),heltab2x24(:,:,32))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(18),n2h12(15))
  call Hloop_WQ_A(ntryL,G1H24(29),ex1(:),G1H12(19),m3h2x12(:,33),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G1H12(19),17,0,G2H12(13),n2h12(16))
  call Hloop_WQ_A(ntryL,G0H24(10),ex1(:),G0H12(3),m3h2x12(:,34),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(19),n2h12(17))
  call Hloop_WQ_A(ntryL,G1H24(30),ex1(:),G1H12(20),m3h2x12(:,35),heltab2x24(:,:,35))
  call Hloop_Q_A(ntryL,G1H12(20),17,0,G2H12(14),n2h12(18))
  call Hloop_AQ_V(ntryL,G1H24(34),ex1(:),G1H12(20),m3h2x12(:,36),heltab2x24(:,:,36))
  call Hloop_AQ_Z(ntryL,G1H24(32),ex1(:),G1H12(21),ngZd,m3h2x12(:,37),heltab2x24(:,:,37))
  call Hloop_AQ_W(ntryL,G1H24(33),ex1(:),G1H12(22),m3h2x12(:,38),heltab2x24(:,:,38))
  call Hloop_WQ_A(ntryL,G0H24(11),ex1(:),G0H12(3),m3h2x12(:,39),heltab2x24(:,:,39))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(23),n2h12(19))
  call Hloop_WQ_A(ntryL,G1H24(35),ex1(:),G1H12(24),m3h2x12(:,40),heltab2x24(:,:,40))
  call Hloop_Q_A(ntryL,G1H12(24),17,0,G2H12(15),n2h12(20))
  call Hloop_WQ_A(ntryL,G0H24(12),ex1(:),G0H12(3),m3h2x12(:,41),heltab2x24(:,:,41))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(24),n2h12(21))
  call Hloop_WQ_A(ntryL,G1H24(36),ex1(:),G1H12(25),m3h2x12(:,42),heltab2x24(:,:,42))
  call Hloop_Q_A(ntryL,G1H12(25),17,0,G2H12(16),n2h12(22))
  call Hloop_QA_W(ntryL,G1H24(37),ex2(:),G1H12(25),m3h2x12(:,43),heltab2x24(:,:,43))
  call Hloop_ZA_Q(ntryL,G0H24(13),ex2(:),G0H12(3),ngZd,m3h2x12(:,44),heltab2x24(:,:,44))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(26),n2h12(23))
  call Hloop_WA_Q(ntryL,G0H24(14),ex2(:),G0H12(3),m3h2x12(:,45),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(27),n2h12(24))
  call Hloop_WA_Q(ntryL,G1H24(38),ex2(:),G1H12(28),m3h2x12(:,46),heltab2x24(:,:,46))
  call Hloop_A_Q(ntryL,G1H12(28),18,0,G2H12(17),n2h12(25))
  call Hloop_QA_W(ntryL,G1H24(39),ex2(:),G1H12(28),m3h2x12(:,47),heltab2x24(:,:,47))
  call Hloop_WA_Q(ntryL,G0H24(15),ex2(:),G0H12(3),m3h2x12(:,48),heltab2x24(:,:,48))
  call Hloop_A_Q(ntryL,G0H12(3),18,0,G1H12(29),n2h12(26))
  call Hloop_WA_Q(ntryL,G1H24(40),ex2(:),G1H12(30),m3h2x12(:,49),heltab2x24(:,:,49))
  call Hloop_A_Q(ntryL,G1H12(30),18,0,G2H12(18),n2h12(27))
  call Hloop_AQ_W(ntryL,G1H24(41),ex1(:),G1H12(30),m3h2x12(:,50),heltab2x24(:,:,50))
  call Hloop_ZQ_A(ntryL,G0H24(16),ex1(:),G0H12(3),ngZd,m3h2x12(:,51),heltab2x24(:,:,51))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(31),n2h12(28))
  call Hloop_WQ_A(ntryL,G0H24(17),ex1(:),G0H12(3),m3h2x12(:,52),heltab2x24(:,:,52))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(32),n2h12(29))
  call Hloop_WQ_A(ntryL,G1H24(42),ex1(:),G1H12(33),m3h2x12(:,53),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G1H12(33),17,0,G2H12(19),n2h12(30))
  call Hloop_WQ_A(ntryL,G1H24(43),ex1(:),G1H12(33),m3h2x12(:,54),heltab2x24(:,:,54))
  call Hloop_Q_A(ntryL,G1H12(33),17,0,G2H12(20),n2h12(31))
  call Hloop_AQ_W(ntryL,G1H24(44),ex1(:),G1H12(33),m3h2x12(:,55),heltab2x24(:,:,55))
  call Hloop_AQ_W(ntryL,G1H24(45),ex1(:),G1H12(34),m3h2x12(:,56),heltab2x24(:,:,56))
  call Hloop_AQ_W(ntryL,G1H24(46),ex1(:),G1H12(35),m3h2x12(:,57),heltab2x24(:,:,57))
  call Hloop_WQ_A(ntryL,G0H24(18),ex1(:),G0H12(3),m3h2x12(:,58),heltab2x24(:,:,58))
  call Hloop_Q_A(ntryL,G0H12(3),17,0,G1H12(36),n2h12(32))
  call Hloop_WQ_A(ntryL,G1H24(47),ex1(:),G1H12(37),m3h2x12(:,59),heltab2x24(:,:,59))
  call Hloop_Q_A(ntryL,G1H12(37),17,0,G2H12(21),n2h12(33))
  call Hloop_WQ_A(ntryL,G1H24(48),ex1(:),G1H12(37),m3h2x12(:,60),heltab2x24(:,:,60))
  call Hloop_Q_A(ntryL,G1H12(37),17,0,G2H12(22),n2h12(34))
  call Hloop_AQ_W(ntryL,G1H24(49),ex1(:),G1H12(37),m3h2x12(:,61),heltab2x24(:,:,61))
  call Hloop_AQ_W(ntryL,G1H24(50),ex1(:),G1H12(38),m3h2x12(:,62),heltab2x24(:,:,62))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(4),[G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(9),[G1H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(10),[G0H12(2)])
  call Hloop_AQ_V(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H12(2),ex1(:),G2H6(2),ngZd,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_AQ_W(ntryL,G2H12(3),ex1(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_WQ_A(ntryL,G1H12(2),ex1(:),G1H6(1),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_Q_A(ntryL,G1H6(1),21,0,G2H6(4),n2h6(1))
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(1),mass5set(:,1),  & 
G1H12(1),G1H12(8),G1H12(2),G1H12(39),G1H12(40),G1H12(41),12)
  call HG1shiftOLR(G1H12(8),8,12)
  call Hloop_VQ_A(ntryL,G1H12(3),ex1(:),G1H6(1),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(5),n2h6(2))
  call Hloop_ZQ_A(ntryL,G1H12(4),ex1(:),G1H6(1),ngZd,m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(6),n2h6(3))
  call Hloop_WQ_A(ntryL,G1H12(5),ex1(:),G1H6(1),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(7),n2h6(4))
  call Hloop_AQ_W(ntryL,G1H12(6),ex1(:),G1H6(1),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_AQ_W(ntryL,G2H12(5),ex1(:),G2H6(8),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_AQ_W(ntryL,G1H12(7),ex1(:),G1H6(2),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_AQ_W(ntryL,G2H12(6),ex1(:),G2H6(9),m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_QA_V(ntryL,G2H12(7),ex2(:),G2H6(10),m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_QA_Z(ntryL,G2H12(8),ex2(:),G2H6(11),ngZd,m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_QA_W(ntryL,G2H12(9),ex2(:),G2H6(12),m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_WA_Q(ntryL,G1H12(9),ex2(:),G1H6(3),m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H6(3),22,0,G2H6(13),n2h6(5))
  call Hotf_5pt_reduction(G2H12(10),RedSet_5(2),mass5set(:,1),  & 
G1H12(3),G1H12(4),G1H12(5),G1H12(6),G1H12(7),G1H12(9),12)
  call HG1shiftOLR(G1H12(4),8,12)
  call Hloop_VQ_A(ntryL,G1H12(10),ex1(:),G1H6(3),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_Q_A(ntryL,G1H6(3),19,0,G2H6(14),n2h6(6))
  call Hloop_ZQ_A(ntryL,G1H12(11),ex1(:),G1H6(3),ngZd,m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_Q_A(ntryL,G1H6(3),19,0,G2H6(15),n2h6(7))
  call Hloop_WQ_A(ntryL,G1H12(12),ex1(:),G1H6(3),m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_Q_A(ntryL,G1H6(3),19,0,G2H6(16),n2h6(8))
  call Hloop_AQ_W(ntryL,G1H12(13),ex1(:),G1H6(3),m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_AQ_W(ntryL,G2H12(11),ex1(:),G2H6(17),m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_AQ_W(ntryL,G1H12(14),ex1(:),G1H6(4),m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_AQ_W(ntryL,G2H12(12),ex1(:),G2H6(18),m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_VA_Q(ntryL,G1H12(15),ex2(:),G1H6(5),m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_A_Q(ntryL,G1H6(5),19,0,G2H6(19),n2h6(9))
  call Hloop_ZA_Q(ntryL,G1H12(16),ex2(:),G1H6(5),ngZd,m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_A_Q(ntryL,G1H6(5),19,0,G2H6(20),n2h6(10))
  call Hloop_WA_Q(ntryL,G1H12(17),ex2(:),G1H6(5),m3h2x6(:,25),heltab2x12(:,:,25))
  call Hloop_A_Q(ntryL,G1H6(5),19,0,G2H6(21),n2h6(11))
  call Hloop_QA_W(ntryL,G1H12(18),ex2(:),G1H6(5),m3h2x6(:,26),heltab2x12(:,:,26))
  call Hloop_QA_W(ntryL,G2H12(13),ex2(:),G2H6(22),m3h2x6(:,27),heltab2x12(:,:,27))
  call Hloop_QA_W(ntryL,G1H12(19),ex2(:),G1H6(6),m3h2x6(:,28),heltab2x12(:,:,28))
  call Hloop_QA_W(ntryL,G2H12(14),ex2(:),G2H6(23),m3h2x6(:,29),heltab2x12(:,:,29))
  call Hloop_VA_Q(ntryL,G1H12(20),ex2(:),G1H6(7),m3h2x6(:,30),heltab2x12(:,:,30))
  call Hloop_A_Q(ntryL,G1H6(7),19,0,G2H6(24),n2h6(12))
  call Hloop_ZA_Q(ntryL,G1H12(21),ex2(:),G1H6(7),ngZd,m3h2x6(:,31),heltab2x12(:,:,31))
  call Hloop_A_Q(ntryL,G1H6(7),19,0,G2H6(25),n2h6(13))
  call Hloop_WA_Q(ntryL,G1H12(22),ex2(:),G1H6(7),m3h2x6(:,32),heltab2x12(:,:,32))
  call Hloop_A_Q(ntryL,G1H6(7),19,0,G2H6(26),n2h6(14))
  call Hloop_QA_W(ntryL,G1H12(23),ex2(:),G1H6(7),m3h2x6(:,33),heltab2x12(:,:,33))
  call Hloop_QA_W(ntryL,G2H12(15),ex2(:),G2H6(27),m3h2x6(:,34),heltab2x12(:,:,34))
  call Hloop_QA_W(ntryL,G1H12(24),ex2(:),G1H6(8),m3h2x6(:,35),heltab2x12(:,:,35))
  call Hloop_QA_W(ntryL,G2H12(16),ex2(:),G2H6(28),m3h2x6(:,36),heltab2x12(:,:,36))
  call Hloop_UW_V(ntryL,G1H12(25),18,ex3(:),4,G2H6(29),m3h2x6(:,37),heltab2x12(:,:,37))
  call Hloop_AV_Q(ntryL,G1H12(26),ex3(:),G1H6(9),m3h2x6(:,38),heltab2x12(:,:,38))
  call Hloop_A_Q(ntryL,G1H6(9),22,0,G2H6(30),n2h6(15))
  call Hloop_AV_Q(ntryL,G1H12(27),ex3(:),G1H6(9),m3h2x6(:,39),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H6(9),22,0,G2H6(31),n2h6(16))
  call Hotf_5pt_reduction(G2H12(17),RedSet_5(3),mass5set(:,2),  & 
G1H12(10),G1H12(11),G1H12(12),G1H12(13),G1H12(14),G1H12(15),12)
  call HG1shiftOLR(G1H12(11),8,12)
  call Hloop_UW_V(ntryL,G1H12(28),18,ex4(:),8,G2H4(1),m3h3x4(:,1),heltab2x12(:,:,40))
  call Hloop_AZ_Q(ntryL,G1H12(29),ex4(:),G1H4(1),ngZu,m3h3x4(:,2),heltab2x12(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),26,0,G2H4(2),n2h4(1))
  call Hotf_5pt_reduction(G2H12(18),RedSet_5(4),mass5set(:,2),  & 
G1H12(16),G1H12(17),G1H12(18),G1H12(19),G1H12(20),G1H12(21),12)
  call HG1shiftOLR(G1H12(17),4,12)
  call Hloop_UV_W(ntryL,G1H12(30),17,ex3(:),4,G2H6(32),m3h2x6(:,40),heltab2x12(:,:,42))
  call Hloop_QV_A(ntryL,G1H12(31),ex3(:),G1H6(9),m3h2x6(:,41),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H6(9),21,0,G2H6(33),n2h6(17))
  call Hloop_QV_A(ntryL,G1H12(32),ex3(:),G1H6(9),m3h2x6(:,42),heltab2x12(:,:,44))
  call Hloop_Q_A(ntryL,G1H6(9),21,0,G2H6(34),n2h6(18))
  call Hotf_5pt_reduction(G2H12(19),RedSet_5(5),mass5set(:,2),  & 
G1H12(22),G1H12(23),G1H12(24),G1H12(25),G1H12(26),G1H12(27),12)
  call HG1shiftOLR(G1H12(23),8,12)
  call Hotf_5pt_reduction(G2H12(20),RedSet_5(6),mass5set(:,3),  & 
G1H12(28),G1H12(29),G1H12(30),G1H12(31),G1H12(32),G1H12(42),12)
  call HG1shiftOLR(G1H12(29),2,12)
  call Hloop_VV_S(ntryL,G1H12(33),ex3(:),G1H6(9),m3h2x6(:,43),heltab2x12(:,:,45))
  call Hloop_UV_W(ntryL,G1H12(34),17,ex3(:),4,G2H6(35),m3h2x6(:,44),heltab2x12(:,:,46))
  call Hloop_UV_W(ntryL,G1H12(35),17,ex4(:),8,G2H4(3),m3h3x4(:,3),heltab2x12(:,:,47))
  call Hloop_QZ_A(ntryL,G1H12(36),ex4(:),G1H4(1),ngZu,m3h3x4(:,4),heltab2x12(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(4),n2h4(2))
  call Hotf_5pt_reduction(G2H12(21),RedSet_5(7),mass5set(:,2),  & 
G1H12(33),G1H12(34),G1H12(35),G1H12(36),G1H12(43),G1H12(44),12)
  call HG1shiftOLR(G1H12(34),4,12)
  call Hotf_5pt_reduction(G2H12(22),RedSet_5(8),mass5set(:,3),  & 
G1H12(45),G1H12(46),G1H12(47),G1H12(48),G1H12(49),G1H12(50),12)
  call HG1shiftOLR(G1H12(46),2,12)
  call Hloop_VV_S(ntryL,G1H12(37),ex4(:),G1H4(1),m3h3x4(:,5),heltab2x12(:,:,49))
  call Hloop_UV_W(ntryL,G1H12(38),17,ex4(:),8,G2H4(5),m3h3x4(:,6),heltab2x12(:,:,50))
  call Hloop_WQ_A(ntryL,G1H12(1),ex1(:),G1H6(10),m3h2x6(:,45),heltab2x12(:,:,51))
  call Hloop_Q_A(ntryL,G1H6(10),21,0,G2H6(36),n2h6(19))
call HGT_raise_alpha_OLR(G1H12(8),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(8),-8,ex4(:),8,G2H4(6),m3h3x4(:,7),heltab2x12(:,:,52))
  call Hloop_WQ_A(ntryL,G1H12(39),ex1(:),G1H6(10),m3h2x6(:,46),heltab2x12(:,:,53))
  call Hloop_Q_A(ntryL,G1H6(10),21,0,G2H6(37),n2h6(20))
  call Hloop_WQ_A(ntryL,G1H12(40),ex1(:),G1H6(10),m3h2x6(:,47),heltab2x12(:,:,54))
  call Hloop_Q_A(ntryL,G1H6(10),21,0,G2H6(38),n2h6(21))
  call Hloop_WQ_A(ntryL,G1H12(41),ex1(:),G1H6(10),m3h2x6(:,48),heltab2x12(:,:,55))
  call Hloop_Q_A(ntryL,G1H6(10),21,0,G2H6(39),n2h6(22))
  call Hloop_WA_Q(ntryL,G1H12(3),ex2(:),G1H6(10),m3h2x6(:,49),heltab2x12(:,:,56))
  call Hloop_A_Q(ntryL,G1H6(10),22,0,G2H6(40),n2h6(23))
call HGT_raise_alpha_OLR(G1H12(4),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(4),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(4),-8,ex4(:),8,G2H4(7),m3h3x4(:,8),heltab2x12(:,:,57))
  call Hloop_WA_Q(ntryL,G1H12(6),ex2(:),G1H6(10),m3h2x6(:,50),heltab2x12(:,:,58))
  call Hloop_A_Q(ntryL,G1H6(10),22,0,G2H6(41),n2h6(24))
  call Hloop_WA_Q(ntryL,G1H12(7),ex2(:),G1H6(10),m3h2x6(:,51),heltab2x12(:,:,59))
  call Hloop_A_Q(ntryL,G1H6(10),22,0,G2H6(42),n2h6(25))
  call Hloop_WA_Q(ntryL,G1H12(9),ex2(:),G1H6(10),m3h2x6(:,52),heltab2x12(:,:,60))
  call Hloop_A_Q(ntryL,G1H6(10),22,0,G2H6(43),n2h6(26))
  call Hloop_AV_Q(ntryL,G1H12(10),ex3(:),G1H6(10),m3h2x6(:,53),heltab2x12(:,:,61))
  call Hloop_A_Q(ntryL,G1H6(10),22,0,G2H6(44),n2h6(27))
call HGT_raise_alpha_OLR(G1H12(11),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(11),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(11),-8,ex4(:),8,G2H4(8),m3h3x4(:,9),heltab2x12(:,:,62))
  call Hloop_AV_Q(ntryL,G1H12(13),ex3(:),G1H6(10),m3h2x6(:,54),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H6(10),22,0,G2H6(45),n2h6(28))
  call Hloop_AV_Q(ntryL,G1H12(14),ex3(:),G1H6(10),m3h2x6(:,55),heltab2x12(:,:,64))
  call Hloop_A_Q(ntryL,G1H6(10),22,0,G2H6(46),n2h6(29))
  call Hloop_AV_Q(ntryL,G1H12(15),ex3(:),G1H6(10),m3h2x6(:,56),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G1H6(10),22,0,G2H6(47),n2h6(30))
  call Hloop_AZ_Q(ntryL,G1H12(16),ex4(:),G1H4(2),ngZu,m3h3x4(:,10),heltab2x12(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(2),26,0,G2H4(9),n2h4(3))
call HGT_raise_alpha_OLR(G1H12(17),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(17),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(17),-4,ex3(:),4,G2H6(48),m3h2x6(:,57),heltab2x12(:,:,67))
  call Hloop_AZ_Q(ntryL,G1H12(19),ex4(:),G1H4(2),ngZu,m3h3x4(:,11),heltab2x12(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(2),26,0,G2H4(10),n2h4(4))
  call Hloop_AZ_Q(ntryL,G1H12(20),ex4(:),G1H4(2),ngZu,m3h3x4(:,12),heltab2x12(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(2),26,0,G2H4(11),n2h4(5))
  call Hloop_AZ_Q(ntryL,G1H12(21),ex4(:),G1H4(2),ngZu,m3h3x4(:,13),heltab2x12(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(2),26,0,G2H4(12),n2h4(6))
  call Hloop_QV_A(ntryL,G1H12(22),ex3(:),G1H6(10),m3h2x6(:,58),heltab2x12(:,:,71))
  call Hloop_Q_A(ntryL,G1H6(10),21,0,G2H6(49),n2h6(31))
call HGT_raise_alpha_OLR(G1H12(23),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(23),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(23),-8,ex4(:),8,G2H4(13),m3h3x4(:,14),heltab2x12(:,:,72))
  call Hloop_QV_A(ntryL,G1H12(25),ex3(:),G1H6(10),m3h2x6(:,59),heltab2x12(:,:,73))
  call Hloop_Q_A(ntryL,G1H6(10),21,0,G2H6(50),n2h6(32))
  call Hloop_QV_A(ntryL,G1H12(26),ex3(:),G1H6(10),m3h2x6(:,60),heltab2x12(:,:,74))
  call Hloop_Q_A(ntryL,G1H6(10),21,0,G2H6(51),n2h6(33))
  call Hloop_QV_A(ntryL,G1H12(27),ex3(:),G1H6(10),m3h2x6(:,61),heltab2x12(:,:,75))
  call Hloop_Q_A(ntryL,G1H6(10),21,0,G2H6(52),n2h6(34))
  call Hloop_QV_A(ntryL,G1H12(28),ex3(:),G1H6(10),m3h2x6(:,62),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G1H6(10),21,0,G2H6(53),n2h6(35))
call HGT_raise_alpha_OLR(G1H12(29),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(29),2,5,12)
  call Hloop_WA_Q(ntryL,G1H12(29),ex2(:),G1H6(10),m3h2x6(:,63),heltab2x12(:,:,77))
  call Hloop_QV_A(ntryL,G1H12(31),ex3(:),G1H6(11),m3h2x6(:,64),heltab2x12(:,:,78))
  call Hloop_Q_A(ntryL,G1H6(11),21,0,G2H6(54),n2h6(36))
  call Hloop_QV_A(ntryL,G1H12(32),ex3(:),G1H6(11),m3h2x6(:,65),heltab2x12(:,:,79))
  call Hloop_Q_A(ntryL,G1H6(11),21,0,G2H6(55),n2h6(37))
  call Hloop_QV_A(ntryL,G1H12(42),ex3(:),G1H6(11),m3h2x6(:,66),heltab2x12(:,:,80))
  call Hloop_Q_A(ntryL,G1H6(11),21,0,G2H6(56),n2h6(38))
  call Hloop_QZ_A(ntryL,G1H12(33),ex4(:),G1H4(2),ngZu,m3h3x4(:,15),heltab2x12(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(14),n2h4(7))
call HGT_raise_alpha_OLR(G1H12(34),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(34),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(34),-4,ex3(:),4,G2H6(57),m3h2x6(:,67),heltab2x12(:,:,82))
  call Hloop_QZ_A(ntryL,G1H12(36),ex4(:),G1H4(2),ngZu,m3h3x4(:,16),heltab2x12(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(15),n2h4(8))
  call Hloop_QZ_A(ntryL,G1H12(43),ex4(:),G1H4(2),ngZu,m3h3x4(:,17),heltab2x12(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(16),n2h4(9))
  call Hloop_QZ_A(ntryL,G1H12(44),ex4(:),G1H4(2),ngZu,m3h3x4(:,18),heltab2x12(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(17),n2h4(10))
  call Hloop_QZ_A(ntryL,G1H12(45),ex4(:),G1H4(2),ngZu,m3h3x4(:,19),heltab2x12(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(18),n2h4(11))
call HGT_raise_alpha_OLR(G1H12(46),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(46),2,5,12)
  call Hloop_WA_Q(ntryL,G1H12(46),ex2(:),G1H6(11),m3h2x6(:,68),heltab2x12(:,:,87))
  call Hloop_QZ_A(ntryL,G1H12(48),ex4(:),G1H4(2),ngZu,m3h3x4(:,20),heltab2x12(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(19),n2h4(12))
  call Hloop_QZ_A(ntryL,G1H12(49),ex4(:),G1H4(2),ngZu,m3h3x4(:,21),heltab2x12(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(20),n2h4(13))
  call Hloop_QZ_A(ntryL,G1H12(50),ex4(:),G1H4(2),ngZu,m3h3x4(:,22),heltab2x12(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(21),n2h4(14))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(1),mass5set(:,4),  & 
G1H6(12),G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),6)
  call HG1shiftOLR(G1H6(13),8,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(1),mass5set(:,5),  & 
G1H6(18),G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),6)
  call HG1shiftOLR(G1H6(19),8,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(1),mass5set(:,6),  & 
G1H6(24),G1H6(25),G1H6(26),G1H6(27),G1H6(28),G1H6(29),6)
  call HG1shiftOLR(G1H6(25),8,6)
  call Hloop_QA_W(ntryL,G2H6(4),ex2(:),G2H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(9),mass5set(:,4),  & 
G1H6(30),G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),6)
  call HG1shiftOLR(G1H6(31),8,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(9),mass5set(:,7),  & 
G1H6(36),G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),6)
  call HG1shiftOLR(G1H6(37),8,6)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(9),mass5set(:,8),  & 
G1H6(42),G1H6(43),G1H6(44),G1H6(45),G1H6(46),G1H6(47),6)
  call HG1shiftOLR(G1H6(43),8,6)
  call Hloop_VV_S(ntryL,G1H6(1),ex3(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_VV_S(ntryL,G2H6(8),ex3(:),G2H3(2),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_UV_W(ntryL,G1H6(2),19,ex3(:),4,G2H3(3),m3h2x3(:,4),heltab2x6(:,:,4))
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(9),mass5set(:,9),  & 
G1H6(1),G1H6(2),G1H6(48),G1H6(49),G1H6(50),G1H6(51),6)
  call HG1shiftOLR(G1H6(2),8,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(2),mass5set(:,4),  & 
G1H6(52),G1H6(53),G1H6(54),G1H6(55),G1H6(56),G1H6(57),6)
  call HG1shiftOLR(G1H6(53),8,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(2),mass5set(:,5),  & 
G1H6(58),G1H6(59),G1H6(60),G1H6(61),G1H6(62),G1H6(63),6)
  call HG1shiftOLR(G1H6(59),8,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(2),mass5set(:,6),  & 
G1H6(64),G1H6(65),G1H6(66),G1H6(67),G1H6(68),G1H6(69),6)
  call HG1shiftOLR(G1H6(65),8,6)
  call Hloop_AQ_W(ntryL,G2H6(13),ex1(:),G2H3(4),m3h2x3(:,5),heltab2x6(:,:,5))
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(10),mass5set(:,4),  & 
G1H6(70),G1H6(71),G1H6(72),G1H6(73),G1H6(74),G1H6(75),6)
  call HG1shiftOLR(G1H6(71),4,6)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(10),mass5set(:,7),  & 
G1H6(76),G1H6(77),G1H6(78),G1H6(79),G1H6(80),G1H6(81),6)
  call HG1shiftOLR(G1H6(77),4,6)
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(10),mass5set(:,8),  & 
G1H6(82),G1H6(83),G1H6(84),G1H6(85),G1H6(86),G1H6(87),6)
  call HG1shiftOLR(G1H6(83),4,6)
  call Hloop_VV_S(ntryL,G1H6(3),ex4(:),G1H2(1),m3h3x2(:,1),heltab2x6(:,:,6))
  call Hloop_VV_S(ntryL,G2H6(17),ex4(:),G2H2(1),m3h3x2(:,2),heltab2x6(:,:,7))
  call Hloop_UV_W(ntryL,G1H6(4),19,ex4(:),8,G2H2(2),m3h3x2(:,3),heltab2x6(:,:,8))
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(10),mass5set(:,9),  & 
G1H6(3),G1H6(4),G1H6(88),G1H6(89),G1H6(90),G1H6(91),6)
  call HG1shiftOLR(G1H6(4),4,6)
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(11),mass5set(:,4),  & 
G1H6(92),G1H6(93),G1H6(94),G1H6(95),G1H6(96),G1H6(97),6)
  call HG1shiftOLR(G1H6(93),8,6)
  call Hotf_5pt_reduction(G2H6(20),RedSet_5(11),mass5set(:,7),  & 
G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),G1H6(103),6)
  call HG1shiftOLR(G1H6(99),8,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(11),mass5set(:,8),  & 
G1H6(104),G1H6(105),G1H6(106),G1H6(107),G1H6(108),G1H6(109),6)
  call HG1shiftOLR(G1H6(105),8,6)
  call Hloop_VV_S(ntryL,G1H6(5),ex3(:),G1H3(2),m3h2x3(:,6),heltab2x6(:,:,9))
  call Hloop_VV_S(ntryL,G2H6(22),ex3(:),G2H3(5),m3h2x3(:,7),heltab2x6(:,:,10))
  call Hloop_UW_V(ntryL,G1H6(6),19,ex3(:),4,G2H3(6),m3h2x3(:,8),heltab2x6(:,:,11))
  call Hotf_5pt_reduction(G2H6(23),RedSet_5(11),mass5set(:,9),  & 
G1H6(5),G1H6(6),G1H6(110),G1H6(111),G1H6(112),G1H6(113),6)
  call HG1shiftOLR(G1H6(6),8,6)
  call Hotf_5pt_reduction(G2H6(24),RedSet_5(12),mass5set(:,4),  & 
G1H6(114),G1H6(115),G1H6(116),G1H6(117),G1H6(118),G1H6(119),6)
  call HG1shiftOLR(G1H6(115),4,6)
  call Hotf_5pt_reduction(G2H6(25),RedSet_5(12),mass5set(:,7),  & 
G1H6(120),G1H6(121),G1H6(122),G1H6(123),G1H6(124),G1H6(125),6)
  call HG1shiftOLR(G1H6(121),4,6)
  call Hotf_5pt_reduction(G2H6(26),RedSet_5(12),mass5set(:,8),  & 
G1H6(126),G1H6(127),G1H6(128),G1H6(129),G1H6(130),G1H6(131),6)
  call HG1shiftOLR(G1H6(127),4,6)
  call Hloop_VV_S(ntryL,G1H6(7),ex4(:),G1H2(2),m3h3x2(:,4),heltab2x6(:,:,12))
  call Hloop_VV_S(ntryL,G2H6(27),ex4(:),G2H2(3),m3h3x2(:,5),heltab2x6(:,:,13))
  call Hloop_UW_V(ntryL,G1H6(8),19,ex4(:),8,G2H2(4),m3h3x2(:,6),heltab2x6(:,:,14))
  call Hotf_5pt_reduction(G2H6(28),RedSet_5(12),mass5set(:,9),  & 
G1H6(7),G1H6(8),G1H6(132),G1H6(133),G1H6(134),G1H6(135),6)
  call HG1shiftOLR(G1H6(8),4,6)
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(3),mass5set(:,10),  & 
G1H6(136),G1H6(137),G1H6(138),G1H6(139),G1H6(140),G1H6(141),6)
  call HG1shiftOLR(G1H6(137),8,6)
  call Hloop_AQ_Z(ntryL,G2H6(30),ex1(:),G2H3(7),ngZd,m3h2x3(:,9),heltab2x6(:,:,15))
  call Hloop_AQ_W(ntryL,G2H6(31),ex1(:),G2H3(8),m3h2x3(:,10),heltab2x6(:,:,16))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(4),mass5set(:,10),  & 
G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),G1H4(7),4)
  call HG1shiftOLR(G1H4(3),4,4)
  call Hloop_AQ_W(ntryL,G2H4(2),ex1(:),G2H2(5),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H6(32),RedSet_5(5),mass5set(:,10),  & 
G1H6(142),G1H6(143),G1H6(144),G1H6(145),G1H6(146),G1H6(147),6)
  call HG1shiftOLR(G1H6(143),8,6)
  call Hloop_QA_Z(ntryL,G2H6(33),ex2(:),G2H3(9),ngZd,m3h2x3(:,11),heltab2x6(:,:,17))
  call Hloop_QA_W(ntryL,G2H6(34),ex2(:),G2H3(10),m3h2x3(:,12),heltab2x6(:,:,18))
  call Hloop_SV_V(ntryL,G1H6(9),ex4(:),G1H2(3),m3h3x2(:,7),heltab2x6(:,:,19))
  call Hotf_5pt_reduction(G2H6(35),RedSet_5(6),mass5set(:,11),  & 
G1H6(9),G1H6(148),G1H6(149),G1H6(150),G1H6(151),G1H6(152),6)
  call HG1shiftOLR(G1H6(148),2,6)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(7),mass5set(:,10),  & 
G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),4)
  call HG1shiftOLR(G1H4(9),4,4)
  call Hloop_QA_W(ntryL,G2H4(4),ex2(:),G2H2(6),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_SV_V(ntryL,G1H4(1),ex3(:),G1H2(4),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(8),mass5set(:,11),  & 
G1H4(1),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),2,4)
  call Hloop_QA_W(ntryL,G2H6(36),ex2(:),G2H3(11),m3h2x3(:,13),heltab2x6(:,:,20))
  call Hloop_QA_W(ntryL,G2H6(38),ex2(:),G2H3(12),m3h2x3(:,14),heltab2x6(:,:,21))
  call Hloop_QA_W(ntryL,G2H6(39),ex2(:),G2H3(13),m3h2x3(:,15),heltab2x6(:,:,22))
  call Hloop_AQ_W(ntryL,G2H6(40),ex1(:),G2H3(14),m3h2x3(:,16),heltab2x6(:,:,23))
  call Hloop_AQ_W(ntryL,G2H6(42),ex1(:),G2H3(15),m3h2x3(:,17),heltab2x6(:,:,24))
  call Hloop_AQ_W(ntryL,G2H6(43),ex1(:),G2H3(16),m3h2x3(:,18),heltab2x6(:,:,25))
  call Hloop_AQ_W(ntryL,G2H6(44),ex1(:),G2H3(17),m3h2x3(:,19),heltab2x6(:,:,26))
  call Hloop_AQ_W(ntryL,G2H6(46),ex1(:),G2H3(18),m3h2x3(:,20),heltab2x6(:,:,27))
  call Hloop_AQ_W(ntryL,G2H6(47),ex1(:),G2H3(19),m3h2x3(:,21),heltab2x6(:,:,28))
  call Hloop_AQ_W(ntryL,G2H4(9),ex1(:),G2H2(7),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_W(ntryL,G2H4(11),ex1(:),G2H2(8),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_W(ntryL,G2H4(12),ex1(:),G2H2(9),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_W(ntryL,G2H6(49),ex2(:),G2H3(20),m3h2x3(:,22),heltab2x6(:,:,29))
  call Hloop_QA_W(ntryL,G2H6(51),ex2(:),G2H3(21),m3h2x3(:,23),heltab2x6(:,:,30))
  call Hloop_QA_W(ntryL,G2H6(52),ex2(:),G2H3(22),m3h2x3(:,24),heltab2x6(:,:,31))
  call Hotf_5pt_reduction(G2H6(53),RedSet_5(6),mass5set(:,3),  & 
G1H6(153),G1H6(154),G1H6(155),G1H6(156),G1H6(157),G1H6(158),6)
  call HG1shiftOLR(G1H6(154),2,6)
  call Hotf_4pt_reduction(G2H6(55),RedSet_4(1),mass4set(:,1),  & 
G1H6(159),G1H6(160),G1H6(161),G1H6(162),G1H6(163),6)
  call HG1shiftOLR(G1H6(160),2,6)
  call Hotf_4pt_reduction(G2H6(56),RedSet_4(2),mass4set(:,1),  & 
G1H6(164),G1H6(165),G1H6(166),G1H6(167),G1H6(168),6)
  call HG1shiftOLR(G1H6(165),10,6)
  call Hloop_QA_W(ntryL,G2H4(14),ex2(:),G2H2(10),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_W(ntryL,G2H4(16),ex2(:),G2H2(11),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_W(ntryL,G2H4(17),ex2(:),G2H2(12),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(8),mass5set(:,3),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),2,4)
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(1),mass4set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),4)
  call HG1shiftOLR(G1H4(26),2,4)
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(3),mass4set(:,1),  & 
G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(31),6,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(159),[G1H6(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(164),[G1H6(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(24)])
  call Hloop_VA_Q(ntryL,G1H6(12),ex2(:),G1H3(3),m3h2x3(:,25),heltab2x6(:,:,32))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(23),n2h3(1))
call HGT_OLR(G1H6(13),1,1,6)
call HGT_invQ_OLR(G1H6(13),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(13),-8,0,G2H6(1),n2h6(39))
  call Hloop_QZ_A(ntryL,G2H6(1),ex4(:),G2H2(13),ngZd,m3h3x2(:,8),heltab2x6(:,:,33))
  call Hloop_VA_Q(ntryL,G1H6(16),ex2(:),G1H3(3),m3h2x3(:,26),heltab2x6(:,:,34))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(24),n2h3(2))
  call Hloop_VA_Q(ntryL,G1H6(17),ex2(:),G1H3(3),m3h2x3(:,27),heltab2x6(:,:,35))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(25),n2h3(3))
  call Hloop_ZA_Q(ntryL,G1H6(18),ex2(:),G1H3(3),ngZd,m3h2x3(:,28),heltab2x6(:,:,36))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(26),n2h3(4))
call HGT_OLR(G1H6(19),1,1,6)
call HGT_invQ_OLR(G1H6(19),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(19),-8,0,G2H6(2),n2h6(40))
  call Hloop_QZ_A(ntryL,G2H6(2),ex4(:),G2H2(14),ngZd,m3h3x2(:,9),heltab2x6(:,:,37))
  call Hloop_ZA_Q(ntryL,G1H6(22),ex2(:),G1H3(3),ngZd,m3h2x3(:,29),heltab2x6(:,:,38))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(27),n2h3(5))
  call Hloop_ZA_Q(ntryL,G1H6(23),ex2(:),G1H3(3),ngZd,m3h2x3(:,30),heltab2x6(:,:,39))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(28),n2h3(6))
  call Hloop_WA_Q(ntryL,G1H6(24),ex2(:),G1H3(3),m3h2x3(:,31),heltab2x6(:,:,40))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(29),n2h3(7))
call HGT_OLR(G1H6(25),1,1,6)
call HGT_invQ_OLR(G1H6(25),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(25),-8,0,G2H6(3),n2h6(41))
  call Hloop_QZ_A(ntryL,G2H6(3),ex4(:),G2H2(15),ngZu,m3h3x2(:,10),heltab2x6(:,:,41))
  call Hloop_WA_Q(ntryL,G1H6(28),ex2(:),G1H3(3),m3h2x3(:,32),heltab2x6(:,:,42))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(30),n2h3(8))
  call Hloop_WA_Q(ntryL,G1H6(29),ex2(:),G1H3(3),m3h2x3(:,33),heltab2x6(:,:,43))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(31),n2h3(9))
  call Hloop_QV_A(ntryL,G1H6(30),ex3(:),G1H3(3),m3h2x3(:,34),heltab2x6(:,:,44))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(32),n2h3(10))
call HGT_OLR(G1H6(31),1,1,6)
call HGT_invQ_OLR(G1H6(31),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(31),-8,0,G2H6(4),n2h6(42))
  call Hloop_AZ_Q(ntryL,G2H6(4),ex4(:),G2H2(16),ngZd,m3h3x2(:,11),heltab2x6(:,:,45))
  call Hloop_QV_A(ntryL,G1H6(34),ex3(:),G1H3(3),m3h2x3(:,35),heltab2x6(:,:,46))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(33),n2h3(11))
  call Hloop_QV_A(ntryL,G1H6(35),ex3(:),G1H3(3),m3h2x3(:,36),heltab2x6(:,:,47))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(34),n2h3(12))
  call Hloop_QV_A(ntryL,G1H6(36),ex3(:),G1H3(3),m3h2x3(:,37),heltab2x6(:,:,48))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(35),n2h3(13))
call HGT_OLR(G1H6(37),1,1,6)
call HGT_invQ_OLR(G1H6(37),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(37),-8,0,G2H6(5),n2h6(43))
  call Hloop_AZ_Q(ntryL,G2H6(5),ex4(:),G2H2(17),ngZd,m3h3x2(:,12),heltab2x6(:,:,49))
  call Hloop_QV_A(ntryL,G1H6(40),ex3(:),G1H3(3),m3h2x3(:,38),heltab2x6(:,:,50))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(36),n2h3(14))
  call Hloop_QV_A(ntryL,G1H6(41),ex3(:),G1H3(3),m3h2x3(:,39),heltab2x6(:,:,51))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(37),n2h3(15))
  call Hloop_QV_A(ntryL,G1H6(42),ex3(:),G1H3(3),m3h2x3(:,40),heltab2x6(:,:,52))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(38),n2h3(16))
call HGT_OLR(G1H6(43),1,1,6)
call HGT_invQ_OLR(G1H6(43),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(43),-8,0,G2H6(6),n2h6(44))
  call Hloop_AZ_Q(ntryL,G2H6(6),ex4(:),G2H2(18),ngZu,m3h3x2(:,13),heltab2x6(:,:,53))
  call Hloop_QV_A(ntryL,G1H6(46),ex3(:),G1H3(3),m3h2x3(:,41),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(39),n2h3(17))
  call Hloop_QV_A(ntryL,G1H6(47),ex3(:),G1H3(3),m3h2x3(:,42),heltab2x6(:,:,55))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(40),n2h3(18))
  call Hloop_UV_W(ntryL,G1H6(1),19,ex3(:),4,G2H3(41),m3h2x3(:,43),heltab2x6(:,:,56))
call HGT_raise_alpha_OLR(G1H6(2),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(2),-8,ex4(:),8,G2H2(19),m3h3x2(:,14),heltab2x6(:,:,57))
  call Hloop_UV_W(ntryL,G1H6(50),19,ex3(:),4,G2H3(42),m3h2x3(:,44),heltab2x6(:,:,58))
  call Hloop_UV_W(ntryL,G1H6(51),19,ex3(:),4,G2H3(43),m3h2x3(:,45),heltab2x6(:,:,59))
  call Hloop_VQ_A(ntryL,G1H6(52),ex1(:),G1H3(3),m3h2x3(:,46),heltab2x6(:,:,60))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(44),n2h3(19))
call HGT_OLR(G1H6(53),1,1,6)
call HGT_invQ_OLR(G1H6(53),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(53),-8,0,G2H6(7),n2h6(46))
  call Hloop_AZ_Q(ntryL,G2H6(7),ex4(:),G2H2(20),ngZd,m3h3x2(:,15),heltab2x6(:,:,61))
  call Hloop_VQ_A(ntryL,G1H6(56),ex1(:),G1H3(3),m3h2x3(:,47),heltab2x6(:,:,62))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(45),n2h3(20))
  call Hloop_VQ_A(ntryL,G1H6(57),ex1(:),G1H3(3),m3h2x3(:,48),heltab2x6(:,:,63))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(46),n2h3(21))
  call Hloop_ZQ_A(ntryL,G1H6(58),ex1(:),G1H3(3),ngZd,m3h2x3(:,49),heltab2x6(:,:,64))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(47),n2h3(22))
call HGT_OLR(G1H6(59),1,1,6)
call HGT_invQ_OLR(G1H6(59),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(59),-8,0,G2H6(8),n2h6(47))
  call Hloop_AZ_Q(ntryL,G2H6(8),ex4(:),G2H2(21),ngZd,m3h3x2(:,16),heltab2x6(:,:,65))
  call Hloop_ZQ_A(ntryL,G1H6(62),ex1(:),G1H3(3),ngZd,m3h2x3(:,50),heltab2x6(:,:,66))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(48),n2h3(23))
  call Hloop_ZQ_A(ntryL,G1H6(63),ex1(:),G1H3(3),ngZd,m3h2x3(:,51),heltab2x6(:,:,67))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(49),n2h3(24))
  call Hloop_WQ_A(ntryL,G1H6(64),ex1(:),G1H3(3),m3h2x3(:,52),heltab2x6(:,:,68))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(50),n2h3(25))
call HGT_OLR(G1H6(65),1,1,6)
call HGT_invQ_OLR(G1H6(65),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(65),-8,0,G2H6(9),n2h6(48))
  call Hloop_AZ_Q(ntryL,G2H6(9),ex4(:),G2H2(22),ngZu,m3h3x2(:,17),heltab2x6(:,:,69))
  call Hloop_WQ_A(ntryL,G1H6(68),ex1(:),G1H3(3),m3h2x3(:,53),heltab2x6(:,:,70))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(51),n2h3(26))
  call Hloop_WQ_A(ntryL,G1H6(69),ex1(:),G1H3(3),m3h2x3(:,54),heltab2x6(:,:,71))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(52),n2h3(27))
  call Hloop_QZ_A(ntryL,G1H6(70),ex4(:),G1H2(5),ngZd,m3h3x2(:,18),heltab2x6(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(23),n2h2(1))
call HGT_OLR(G1H6(71),1,1,6)
call HGT_invQ_OLR(G1H6(71),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(71),-4,0,G2H6(10),n2h6(49))
  call Hloop_AV_Q(ntryL,G2H6(10),ex3(:),G2H3(53),m3h2x3(:,55),heltab2x6(:,:,73))
  call Hloop_QZ_A(ntryL,G1H6(74),ex4(:),G1H2(5),ngZd,m3h3x2(:,19),heltab2x6(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(24),n2h2(2))
  call Hloop_QZ_A(ntryL,G1H6(75),ex4(:),G1H2(5),ngZd,m3h3x2(:,20),heltab2x6(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(25),n2h2(3))
  call Hloop_QZ_A(ntryL,G1H6(76),ex4(:),G1H2(5),ngZd,m3h3x2(:,21),heltab2x6(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(26),n2h2(4))
call HGT_OLR(G1H6(77),1,1,6)
call HGT_invQ_OLR(G1H6(77),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(77),-4,0,G2H6(11),n2h6(50))
  call Hloop_AV_Q(ntryL,G2H6(11),ex3(:),G2H3(54),m3h2x3(:,56),heltab2x6(:,:,77))
  call Hloop_QZ_A(ntryL,G1H6(80),ex4(:),G1H2(5),ngZd,m3h3x2(:,22),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(27),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H6(81),ex4(:),G1H2(5),ngZd,m3h3x2(:,23),heltab2x6(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(28),n2h2(6))
  call Hloop_QZ_A(ntryL,G1H6(82),ex4(:),G1H2(5),ngZu,m3h3x2(:,24),heltab2x6(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(29),n2h2(7))
call HGT_OLR(G1H6(83),1,1,6)
call HGT_invQ_OLR(G1H6(83),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(83),-4,0,G2H6(12),n2h6(51))
  call Hloop_AV_Q(ntryL,G2H6(12),ex3(:),G2H3(55),m3h2x3(:,57),heltab2x6(:,:,81))
  call Hloop_QZ_A(ntryL,G1H6(86),ex4(:),G1H2(5),ngZu,m3h3x2(:,25),heltab2x6(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(30),n2h2(8))
  call Hloop_QZ_A(ntryL,G1H6(87),ex4(:),G1H2(5),ngZu,m3h3x2(:,26),heltab2x6(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(31),n2h2(9))
  call Hloop_UV_W(ntryL,G1H6(3),19,ex4(:),8,G2H2(32),m3h3x2(:,27),heltab2x6(:,:,84))
call HGT_raise_alpha_OLR(G1H6(4),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(4),-4,ex3(:),4,G2H3(56),m3h2x3(:,58),heltab2x6(:,:,85))
  call Hloop_UV_W(ntryL,G1H6(90),19,ex4(:),8,G2H2(33),m3h3x2(:,28),heltab2x6(:,:,86))
  call Hloop_UV_W(ntryL,G1H6(91),19,ex4(:),8,G2H2(34),m3h3x2(:,29),heltab2x6(:,:,87))
  call Hloop_AV_Q(ntryL,G1H6(92),ex3(:),G1H3(3),m3h2x3(:,59),heltab2x6(:,:,88))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(57),n2h3(28))
call HGT_OLR(G1H6(93),1,1,6)
call HGT_invQ_OLR(G1H6(93),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(93),-8,0,G2H6(13),n2h6(53))
  call Hloop_QZ_A(ntryL,G2H6(13),ex4(:),G2H2(35),ngZd,m3h3x2(:,30),heltab2x6(:,:,89))
  call Hloop_AV_Q(ntryL,G1H6(96),ex3(:),G1H3(3),m3h2x3(:,60),heltab2x6(:,:,90))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(58),n2h3(29))
  call Hloop_AV_Q(ntryL,G1H6(97),ex3(:),G1H3(3),m3h2x3(:,61),heltab2x6(:,:,91))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(59),n2h3(30))
  call Hloop_AV_Q(ntryL,G1H6(98),ex3(:),G1H3(3),m3h2x3(:,62),heltab2x6(:,:,92))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(60),n2h3(31))
call HGT_OLR(G1H6(99),1,1,6)
call HGT_invQ_OLR(G1H6(99),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(99),-8,0,G2H6(14),n2h6(54))
  call Hloop_QZ_A(ntryL,G2H6(14),ex4(:),G2H2(36),ngZd,m3h3x2(:,31),heltab2x6(:,:,93))
  call Hloop_AV_Q(ntryL,G1H6(102),ex3(:),G1H3(3),m3h2x3(:,63),heltab2x6(:,:,94))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(61),n2h3(32))
  call Hloop_AV_Q(ntryL,G1H6(103),ex3(:),G1H3(3),m3h2x3(:,64),heltab2x6(:,:,95))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(62),n2h3(33))
  call Hloop_AV_Q(ntryL,G1H6(104),ex3(:),G1H3(3),m3h2x3(:,65),heltab2x6(:,:,96))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(63),n2h3(34))
call HGT_OLR(G1H6(105),1,1,6)
call HGT_invQ_OLR(G1H6(105),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(105),-8,0,G2H6(15),n2h6(55))
  call Hloop_QZ_A(ntryL,G2H6(15),ex4(:),G2H2(37),ngZu,m3h3x2(:,32),heltab2x6(:,:,97))
  call Hloop_AV_Q(ntryL,G1H6(108),ex3(:),G1H3(3),m3h2x3(:,66),heltab2x6(:,:,98))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(64),n2h3(35))
  call Hloop_AV_Q(ntryL,G1H6(109),ex3(:),G1H3(3),m3h2x3(:,67),heltab2x6(:,:,99))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(65),n2h3(36))
  call Hloop_UW_V(ntryL,G1H6(5),19,ex3(:),4,G2H3(66),m3h2x3(:,68),heltab2x6(:,:,100))
call HGT_raise_alpha_OLR(G1H6(6),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(6),2,5,6)
  call Hloop_UV_W(ntryL,G1H6(6),-8,ex4(:),8,G2H2(38),m3h3x2(:,33),heltab2x6(:,:,101))
  call Hloop_UW_V(ntryL,G1H6(112),19,ex3(:),4,G2H3(67),m3h2x3(:,69),heltab2x6(:,:,102))
  call Hloop_UW_V(ntryL,G1H6(113),19,ex3(:),4,G2H3(68),m3h2x3(:,70),heltab2x6(:,:,103))
  call Hloop_AZ_Q(ntryL,G1H6(114),ex4(:),G1H2(5),ngZd,m3h3x2(:,34),heltab2x6(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(39),n2h2(10))
call HGT_OLR(G1H6(115),1,1,6)
call HGT_invQ_OLR(G1H6(115),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(115),-4,0,G2H6(16),n2h6(57))
  call Hloop_QV_A(ntryL,G2H6(16),ex3(:),G2H3(69),m3h2x3(:,71),heltab2x6(:,:,105))
  call Hloop_AZ_Q(ntryL,G1H6(118),ex4(:),G1H2(5),ngZd,m3h3x2(:,35),heltab2x6(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(40),n2h2(11))
  call Hloop_AZ_Q(ntryL,G1H6(119),ex4(:),G1H2(5),ngZd,m3h3x2(:,36),heltab2x6(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(41),n2h2(12))
  call Hloop_AZ_Q(ntryL,G1H6(120),ex4(:),G1H2(5),ngZd,m3h3x2(:,37),heltab2x6(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(42),n2h2(13))
call HGT_OLR(G1H6(121),1,1,6)
call HGT_invQ_OLR(G1H6(121),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(121),-4,0,G2H6(17),n2h6(58))
  call Hloop_QV_A(ntryL,G2H6(17),ex3(:),G2H3(70),m3h2x3(:,72),heltab2x6(:,:,109))
  call Hloop_AZ_Q(ntryL,G1H6(124),ex4(:),G1H2(5),ngZd,m3h3x2(:,38),heltab2x6(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(43),n2h2(14))
  call Hloop_AZ_Q(ntryL,G1H6(125),ex4(:),G1H2(5),ngZd,m3h3x2(:,39),heltab2x6(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(44),n2h2(15))
  call Hloop_AZ_Q(ntryL,G1H6(126),ex4(:),G1H2(5),ngZu,m3h3x2(:,40),heltab2x6(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(45),n2h2(16))
call HGT_OLR(G1H6(127),1,1,6)
call HGT_invQ_OLR(G1H6(127),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(127),-4,0,G2H6(18),n2h6(59))
  call Hloop_QV_A(ntryL,G2H6(18),ex3(:),G2H3(71),m3h2x3(:,73),heltab2x6(:,:,113))
  call Hloop_AZ_Q(ntryL,G1H6(130),ex4(:),G1H2(5),ngZu,m3h3x2(:,41),heltab2x6(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(46),n2h2(17))
  call Hloop_AZ_Q(ntryL,G1H6(131),ex4(:),G1H2(5),ngZu,m3h3x2(:,42),heltab2x6(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(47),n2h2(18))
  call Hloop_UW_V(ntryL,G1H6(7),19,ex4(:),8,G2H2(48),m3h3x2(:,43),heltab2x6(:,:,116))
call HGT_raise_alpha_OLR(G1H6(8),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_UV_W(ntryL,G1H6(8),-4,ex3(:),4,G2H3(72),m3h2x3(:,74),heltab2x6(:,:,117))
  call Hloop_UW_V(ntryL,G1H6(134),19,ex4(:),8,G2H2(49),m3h3x2(:,44),heltab2x6(:,:,118))
  call Hloop_UW_V(ntryL,G1H6(135),19,ex4(:),8,G2H2(50),m3h3x2(:,45),heltab2x6(:,:,119))
  call Hloop_WQ_A(ntryL,G1H6(136),ex1(:),G1H3(3),m3h2x3(:,75),heltab2x6(:,:,120))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(73),n2h3(37))
call HGT_OLR(G1H6(137),1,1,6)
call HGT_invQ_OLR(G1H6(137),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(137),-8,0,G2H6(19),n2h6(61))
  call Hloop_AZ_Q(ntryL,G2H6(19),ex4(:),G2H2(51),ngZu,m3h3x2(:,46),heltab2x6(:,:,121))
  call Hloop_WQ_A(ntryL,G1H6(140),ex1(:),G1H3(3),m3h2x3(:,76),heltab2x6(:,:,122))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(74),n2h3(38))
  call Hloop_WQ_A(ntryL,G1H6(141),ex1(:),G1H3(3),m3h2x3(:,77),heltab2x6(:,:,123))
  call Hloop_Q_A(ntryL,G1H3(3),23,0,G2H3(75),n2h3(39))
  call Hloop_WQ_A(ntryL,G1H4(2),ex1(:),G1H2(5),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(52),n2h2(19))
call HGT_OLR(G1H4(3),1,1,4)
call HGT_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(3),-4,0,G2H4(1),n2h4(15))
  call Hloop_AV_Q(ntryL,G2H4(1),ex3(:),G2H2(53),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_WQ_A(ntryL,G1H4(6),ex1(:),G1H2(5),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(54),n2h2(20))
  call Hloop_WQ_A(ntryL,G1H4(7),ex1(:),G1H2(5),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(55),n2h2(21))
  call Hloop_WA_Q(ntryL,G1H6(142),ex2(:),G1H3(3),m3h2x3(:,78),heltab2x6(:,:,124))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(76),n2h3(40))
call HGT_OLR(G1H6(143),1,1,6)
call HGT_invQ_OLR(G1H6(143),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(143),-8,0,G2H6(20),n2h6(62))
  call Hloop_QZ_A(ntryL,G2H6(20),ex4(:),G2H2(56),ngZu,m3h3x2(:,47),heltab2x6(:,:,125))
  call Hloop_WA_Q(ntryL,G1H6(146),ex2(:),G1H3(3),m3h2x3(:,79),heltab2x6(:,:,126))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(77),n2h3(41))
  call Hloop_WA_Q(ntryL,G1H6(147),ex2(:),G1H3(3),m3h2x3(:,80),heltab2x6(:,:,127))
  call Hloop_A_Q(ntryL,G1H3(3),23,0,G2H3(78),n2h3(42))
  call Hloop_UV_W(ntryL,G1H6(9),21,ex4(:),8,G2H2(57),m3h3x2(:,48),heltab2x6(:,:,128))
call HGT_OLR(G1H6(148),1,1,6)
call HGT_invQ_OLR(G1H6(148),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(148),-2,0,G2H6(21),n2h6(63))
  call Hloop_QA_W(ntryL,G2H6(21),ex2(:),G2H3(79),m3h2x3(:,81),heltab2x6(:,:,129))
  call Hloop_UV_W(ntryL,G1H6(151),21,ex4(:),8,G2H2(58),m3h3x2(:,49),heltab2x6(:,:,130))
  call Hloop_UV_W(ntryL,G1H6(152),21,ex4(:),8,G2H2(59),m3h3x2(:,50),heltab2x6(:,:,131))
  call Hloop_WA_Q(ntryL,G1H4(8),ex2(:),G1H2(5),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(60),n2h2(22))
call HGT_OLR(G1H4(9),1,1,4)
call HGT_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(9),-4,0,G2H4(2),n2h4(16))
  call Hloop_QV_A(ntryL,G2H4(2),ex3(:),G2H2(61),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_WA_Q(ntryL,G1H4(12),ex2(:),G1H2(5),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(62),n2h2(23))
  call Hloop_WA_Q(ntryL,G1H4(13),ex2(:),G1H2(5),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(63),n2h2(24))
  call Hloop_UV_W(ntryL,G1H4(1),25,ex3(:),4,G2H2(64),m3h2x2(:,18),heltab2x4(:,:,18))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(14),-2,0,G2H4(3),n2h4(17))
  call Hloop_QA_W(ntryL,G2H4(3),ex2(:),G2H2(65),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_UV_W(ntryL,G1H4(17),25,ex3(:),4,G2H2(66),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_UV_W(ntryL,G1H4(18),25,ex3(:),4,G2H2(67),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QZ_A(ntryL,G1H6(153),ex4(:),G1H2(5),ngZu,m3h3x2(:,51),heltab2x6(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(68),n2h2(25))
call HGT_raise_alpha_OLR(G1H6(154),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(154),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(154),ex2(:),G1H3(3),m3h2x3(:,82),heltab2x6(:,:,133))
  call Hloop_QZ_A(ntryL,G1H6(159),ex4(:),G1H2(5),ngZu,m3h3x2(:,52),heltab2x6(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(69),n2h2(26))
  call Hloop_QZ_A(ntryL,G1H6(164),ex4(:),G1H2(5),ngZu,m3h3x2(:,53),heltab2x6(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(70),n2h2(27))
call HGT_raise_alpha_OLR(G1H6(160),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(160),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(160),ex2(:),G1H3(4),m3h2x3(:,83),heltab2x6(:,:,136))
  call Hloop_QZ_A(ntryL,G1H6(163),ex4(:),G1H2(5),ngZu,m3h3x2(:,54),heltab2x6(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(71),n2h2(28))
call HGT_raise_alpha_OLR(G1H6(165),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(165),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(165),ex2(:),G1H3(5),m3h2x3(:,84),heltab2x6(:,:,138))
  call Hloop_QZ_A(ntryL,G1H6(168),ex4(:),G1H2(5),ngZu,m3h3x2(:,55),heltab2x6(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(72),n2h2(29))
  call Hloop_QV_A(ntryL,G1H4(19),ex3(:),G1H2(5),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(73),n2h2(30))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(20),ex2(:),G1H2(5),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QV_A(ntryL,G1H4(25),ex3(:),G1H2(6),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(6),29,0,G2H2(74),n2h2(31))
  call Hloop_QV_A(ntryL,G1H4(30),ex3(:),G1H2(6),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(6),29,0,G2H2(75),n2h2(32))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(26),ex2(:),G1H2(6),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QV_A(ntryL,G1H4(29),ex3(:),G1H2(7),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(76),n2h2(33))
call HGT_raise_alpha_OLR(G1H4(31),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(31),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(31),ex2(:),G1H2(7),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QV_A(ntryL,G1H4(34),ex3(:),G1H2(8),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(8),29,0,G2H2(77),n2h2(34))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G1H2(4)])
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(1),ex4(:),G2tensor(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(1),23,ex4(:),8,G2tensor(2),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(2),ex4(:),G2tensor(3),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(3),ex4(:),G2tensor(4),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(4),ex4(:),G2tensor(5),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(1),27,ex3(:),4,G2tensor(6),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(7),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(8),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(2),23,ex4(:),8,G2tensor(9),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(5),ex4(:),G2tensor(10),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(6),ex4(:),G2tensor(11),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(2),27,ex3(:),4,G2tensor(12),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(13),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(14),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(7),ex4(:),G2tensor(15),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(8),ex4(:),G2tensor(16),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(17),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(9),ex4(:),G2tensor(18),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(10),ex4(:),G2tensor(19),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(6),mass5set(:,11),  & 
G1H2(8),G1H2(3),G1H2(4),G1H2(1),G1H2(2),G1H2(9),2)
  call HG1shiftOLR(G1H2(3),2,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(20),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hotf_5pt_reduction(G2H2(64),RedSet_5(8),mass5set(:,11),  & 
G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(11),2,2)
  call Hotf_5pt_reduction(G2H3(11),RedSet_5(1),mass5set(:,1),  & 
G1H3(1),G1H3(2),G1H3(6),G1H3(7),G1H3(8),G1H3(9),3)
  call HG1shiftOLR(G1H3(2),8,3)
  call Hotf_4pt_reduction(G2H3(13),RedSet_4(4),mass4set(:,2),  & 
G1H3(10),G1H3(11),G1H3(12),G1H3(13),G1H3(14),3)
  call HG1shiftOLR(G1H3(11),10,3)
  call Hotf_5pt_reduction(G2H3(14),RedSet_5(2),mass5set(:,1),  & 
G1H3(15),G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),3)
  call HG1shiftOLR(G1H3(16),8,3)
  call Hotf_4pt_reduction(G2H3(16),RedSet_4(5),mass4set(:,2),  & 
G1H3(21),G1H3(22),G1H3(23),G1H3(24),G1H3(25),3)
  call HG1shiftOLR(G1H3(22),9,3)
  call Hotf_5pt_reduction(G2H3(17),RedSet_5(3),mass5set(:,2),  & 
G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),G1H3(31),3)
  call HG1shiftOLR(G1H3(27),8,3)
  call Hotf_4pt_reduction(G2H3(19),RedSet_4(6),mass4set(:,1),  & 
G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(33),9,3)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(4),mass5set(:,2),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),2)
  call HG1shiftOLR(G1H2(17),4,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(7),mass4set(:,1),  & 
G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(23),5,2)
  call Hotf_5pt_reduction(G2H3(20),RedSet_5(5),mass5set(:,2),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),3)
  call HG1shiftOLR(G1H3(38),8,3)
  call Hotf_4pt_reduction(G2H3(22),RedSet_4(2),mass4set(:,1),  & 
G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),3)
  call HG1shiftOLR(G1H3(44),10,3)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(7),mass5set(:,2),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),4,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(3),mass4set(:,1),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),2)
  call HG1shiftOLR(G1H2(34),6,2)
  call Hotf_5pt_reduction(G2H3(23),RedSet_5(1),mass5set(:,4),  & 
G1H3(48),G1H3(49),G1H3(50),G1H3(51),G1H3(52),G1H3(53),3)
  call HG1shiftOLR(G1H3(49),8,3)
  call Hotf_4pt_reduction(G2H3(25),RedSet_4(4),mass4set(:,3),  & 
G1H3(54),G1H3(55),G1H3(56),G1H3(57),G1H3(58),3)
  call HG1shiftOLR(G1H3(55),10,3)
  call Hotf_5pt_reduction(G2H3(26),RedSet_5(1),mass5set(:,5),  & 
G1H3(59),G1H3(60),G1H3(61),G1H3(62),G1H3(63),G1H3(64),3)
  call HG1shiftOLR(G1H3(60),8,3)
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(4),mass4set(:,4),  & 
G1H3(65),G1H3(66),G1H3(67),G1H3(68),G1H3(69),3)
  call HG1shiftOLR(G1H3(66),10,3)
  call Hotf_5pt_reduction(G2H3(29),RedSet_5(1),mass5set(:,6),  & 
G1H3(70),G1H3(71),G1H3(72),G1H3(73),G1H3(74),G1H3(75),3)
  call HG1shiftOLR(G1H3(71),8,3)
  call Hotf_4pt_reduction(G2H3(31),RedSet_4(4),mass4set(:,5),  & 
G1H3(76),G1H3(77),G1H3(78),G1H3(79),G1H3(80),3)
  call HG1shiftOLR(G1H3(77),10,3)
  call Hotf_5pt_reduction(G2H3(32),RedSet_5(9),mass5set(:,4),  & 
G1H3(81),G1H3(82),G1H3(83),G1H3(84),G1H3(85),G1H3(86),3)
  call HG1shiftOLR(G1H3(82),8,3)
  call Hotf_4pt_reduction(G2H3(34),RedSet_4(8),mass4set(:,3),  & 
G1H3(87),G1H3(88),G1H3(89),G1H3(90),G1H3(91),3)
  call HG1shiftOLR(G1H3(88),12,3)
  call Hotf_5pt_reduction(G2H3(35),RedSet_5(9),mass5set(:,7),  & 
G1H3(92),G1H3(93),G1H3(94),G1H3(95),G1H3(96),G1H3(97),3)
  call HG1shiftOLR(G1H3(93),8,3)
  call Hotf_4pt_reduction(G2H3(37),RedSet_4(8),mass4set(:,6),  & 
G1H3(98),G1H3(99),G1H3(100),G1H3(101),G1H3(102),3)
  call HG1shiftOLR(G1H3(99),12,3)
  call Hotf_5pt_reduction(G2H3(38),RedSet_5(9),mass5set(:,8),  & 
G1H3(103),G1H3(104),G1H3(105),G1H3(106),G1H3(107),G1H3(108),3)
  call HG1shiftOLR(G1H3(104),8,3)
  call Hotf_4pt_reduction(G2H3(40),RedSet_4(8),mass4set(:,7),  & 
G1H3(109),G1H3(110),G1H3(111),G1H3(112),G1H3(113),3)
  call HG1shiftOLR(G1H3(110),12,3)
  call Hotf_5pt_reduction(G2H3(41),RedSet_5(9),mass5set(:,9),  & 
G1H3(114),G1H3(115),G1H3(116),G1H3(117),G1H3(118),G1H3(119),3)
  call HG1shiftOLR(G1H3(115),8,3)
  call Hotf_4pt_reduction(G2H3(43),RedSet_4(8),mass4set(:,8),  & 
G1H3(120),G1H3(121),G1H3(122),G1H3(123),G1H3(124),3)
  call HG1shiftOLR(G1H3(121),12,3)
  call Hotf_5pt_reduction(G2H3(44),RedSet_5(2),mass5set(:,4),  & 
G1H3(125),G1H3(126),G1H3(127),G1H3(128),G1H3(129),G1H3(130),3)
  call HG1shiftOLR(G1H3(126),8,3)
  call Hotf_4pt_reduction(G2H3(46),RedSet_4(5),mass4set(:,3),  & 
G1H3(131),G1H3(132),G1H3(133),G1H3(134),G1H3(135),3)
  call HG1shiftOLR(G1H3(132),9,3)
  call Hotf_5pt_reduction(G2H3(47),RedSet_5(2),mass5set(:,5),  & 
G1H3(136),G1H3(137),G1H3(138),G1H3(139),G1H3(140),G1H3(141),3)
  call HG1shiftOLR(G1H3(137),8,3)
  call Hotf_4pt_reduction(G2H3(49),RedSet_4(5),mass4set(:,4),  & 
G1H3(142),G1H3(143),G1H3(144),G1H3(145),G1H3(146),3)
  call HG1shiftOLR(G1H3(143),9,3)
  call Hotf_5pt_reduction(G2H3(50),RedSet_5(2),mass5set(:,6),  & 
G1H3(147),G1H3(148),G1H3(149),G1H3(150),G1H3(151),G1H3(152),3)
  call HG1shiftOLR(G1H3(148),8,3)
  call Hotf_4pt_reduction(G2H3(52),RedSet_4(5),mass4set(:,5),  & 
G1H3(153),G1H3(154),G1H3(155),G1H3(156),G1H3(157),3)
  call HG1shiftOLR(G1H3(154),9,3)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(10),mass5set(:,4),  & 
G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),2)
  call HG1shiftOLR(G1H2(39),4,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(8),mass4set(:,3),  & 
G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(45),12,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(10),mass5set(:,7),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),4,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(8),mass4set(:,6),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),2)
  call HG1shiftOLR(G1H2(56),12,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(10),mass5set(:,8),  & 
G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),2)
  call HG1shiftOLR(G1H2(61),4,2)
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(8),mass4set(:,7),  & 
G1H2(66),G1H2(67),G1H2(68),G1H2(69),G1H2(70),2)
  call HG1shiftOLR(G1H2(67),12,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(10),mass5set(:,9),  & 
G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(72),4,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(8),mass4set(:,8),  & 
G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),2)
  call HG1shiftOLR(G1H2(78),12,2)
  call Hotf_5pt_reduction(G2H3(57),RedSet_5(11),mass5set(:,4),  & 
G1H3(158),G1H3(159),G1H3(160),G1H3(161),G1H3(162),G1H3(163),3)
  call HG1shiftOLR(G1H3(159),8,3)
  call Hotf_4pt_reduction(G2H3(59),RedSet_4(9),mass4set(:,3),  & 
G1H3(164),G1H3(165),G1H3(166),G1H3(167),G1H3(168),3)
  call HG1shiftOLR(G1H3(165),12,3)
  call Hotf_5pt_reduction(G2H3(60),RedSet_5(11),mass5set(:,7),  & 
G1H3(169),G1H3(170),G1H3(171),G1H3(172),G1H3(173),G1H3(174),3)
  call HG1shiftOLR(G1H3(170),8,3)
  call Hotf_4pt_reduction(G2H3(62),RedSet_4(9),mass4set(:,6),  & 
G1H3(175),G1H3(176),G1H3(177),G1H3(178),G1H3(179),3)
  call HG1shiftOLR(G1H3(176),12,3)
  call Hotf_5pt_reduction(G2H3(63),RedSet_5(11),mass5set(:,8),  & 
G1H3(180),G1H3(181),G1H3(182),G1H3(183),G1H3(184),G1H3(185),3)
  call HG1shiftOLR(G1H3(181),8,3)
  call Hotf_4pt_reduction(G2H3(65),RedSet_4(9),mass4set(:,7),  & 
G1H3(186),G1H3(187),G1H3(188),G1H3(189),G1H3(190),3)
  call HG1shiftOLR(G1H3(187),12,3)
  call Hotf_5pt_reduction(G2H3(66),RedSet_5(11),mass5set(:,9),  & 
G1H3(191),G1H3(192),G1H3(193),G1H3(194),G1H3(195),G1H3(196),3)
  call HG1shiftOLR(G1H3(192),8,3)
  call Hotf_4pt_reduction(G2H3(68),RedSet_4(9),mass4set(:,8),  & 
G1H3(197),G1H3(198),G1H3(199),G1H3(200),G1H3(201),3)
  call HG1shiftOLR(G1H3(198),12,3)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(12),mass5set(:,4),  & 
G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),G1H2(87),2)
  call HG1shiftOLR(G1H2(83),4,2)
  call Hotf_4pt_reduction(G2H2(41),RedSet_4(9),mass4set(:,3),  & 
G1H2(88),G1H2(89),G1H2(90),G1H2(91),G1H2(92),2)
  call HG1shiftOLR(G1H2(89),12,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(12),mass5set(:,7),  & 
G1H2(93),G1H2(94),G1H2(95),G1H2(96),G1H2(97),G1H2(98),2)
  call HG1shiftOLR(G1H2(94),4,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(9),mass4set(:,6),  & 
G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),2)
  call HG1shiftOLR(G1H2(100),12,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(12),mass5set(:,8),  & 
G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),G1H2(109),2)
  call HG1shiftOLR(G1H2(105),4,2)
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(9),mass4set(:,7),  & 
G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(111),12,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(12),mass5set(:,9),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),4,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(9),mass4set(:,8),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),2)
  call HG1shiftOLR(G1H2(122),12,2)
  call Hotf_5pt_reduction(G2H3(73),RedSet_5(3),mass5set(:,10),  & 
G1H3(202),G1H3(203),G1H3(204),G1H3(205),G1H3(206),G1H3(207),3)
  call HG1shiftOLR(G1H3(203),8,3)
  call Hotf_4pt_reduction(G2H3(75),RedSet_4(6),mass4set(:,9),  & 
G1H3(208),G1H3(209),G1H3(210),G1H3(211),G1H3(212),3)
  call HG1shiftOLR(G1H3(209),9,3)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(4),mass5set(:,10),  & 
G1H2(126),G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),2)
  call HG1shiftOLR(G1H2(127),4,2)
  call Hotf_4pt_reduction(G2H2(55),RedSet_4(7),mass4set(:,9),  & 
G1H2(132),G1H2(133),G1H2(134),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(133),5,2)
  call Hotf_5pt_reduction(G2H3(76),RedSet_5(5),mass5set(:,10),  & 
G1H3(213),G1H3(214),G1H3(215),G1H3(216),G1H3(217),G1H3(218),3)
  call HG1shiftOLR(G1H3(214),8,3)
  call Hotf_4pt_reduction(G2H3(78),RedSet_4(2),mass4set(:,9),  & 
G1H3(219),G1H3(220),G1H3(221),G1H3(222),G1H3(223),3)
  call HG1shiftOLR(G1H3(220),10,3)
  call Hotf_4pt_reduction(G2H2(59),RedSet_4(2),mass4set(:,9),  & 
G1H2(137),G1H2(138),G1H2(139),G1H2(140),G1H2(141),2)
  call HG1shiftOLR(G1H2(138),10,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(7),mass5set(:,10),  & 
G1H2(142),G1H2(143),G1H2(144),G1H2(145),G1H2(146),G1H2(147),2)
  call HG1shiftOLR(G1H2(143),4,2)
  call Hotf_4pt_reduction(G2H2(63),RedSet_4(3),mass4set(:,9),  & 
G1H2(148),G1H2(149),G1H2(150),G1H2(151),G1H2(152),2)
  call HG1shiftOLR(G1H2(149),6,2)
  call Hotf_4pt_reduction(G2H2(67),RedSet_4(3),mass4set(:,9),  & 
G1H2(153),G1H2(154),G1H2(155),G1H2(156),G1H2(157),2)
  call HG1shiftOLR(G1H2(154),6,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(68),ex2(:),G2tensor(21),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(70),ex2(:),G2tensor(22),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(73),ex2(:),G2tensor(23),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(75),ex2(:),G2tensor(24),m3h2x1(:,12),heltab2x2(:,:,12))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(137),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(153),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(10),[G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(21),[G1H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(32),[G1H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(43),[G1H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(54),[G1H3(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(65),[G1H3(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(76),[G1H3(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(87),[G1H3(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(98),[G1H3(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(109),[G1H3(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(120),[G1H3(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(131),[G1H3(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(142),[G1H3(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(153),[G1H3(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(55),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(66),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(77),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(164),[G1H3(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(175),[G1H3(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(186),[G1H3(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(197),[G1H3(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(88),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(99),[G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(110),[G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(121),[G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(208),[G1H3(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(132),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(219),[G1H3(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(148),[G1H2(147)])
  call Hloop_WA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(1))
  call Hloop_WA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(26),n2h1(2))
  call Hloop_WA_Q(ntryL,G1H2(137),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(3))
  call Hloop_WA_Q(ntryL,G1H2(10),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(4))
  call Hloop_WA_Q(ntryL,G1H2(11),ex2(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(29),n2h1(5))
  call Hloop_WA_Q(ntryL,G1H2(153),ex2(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(30),n2h1(6))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(1),23,ex4(:),8,G2tensor(31),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(2),0,ex4(:),8,G2tensor(32),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(10),23,ex4(:),8,G2tensor(33),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(11),2,ex4(:),8,G2tensor(34),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(15),23,ex4(:),8,G2tensor(35),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(16),0,ex4(:),8,G2tensor(36),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(21),23,ex4(:),8,G2tensor(37),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(22),1,ex4(:),8,G2tensor(38),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(26),23,ex4(:),8,G2tensor(39),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(27),0,ex4(:),8,G2tensor(40),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(32),23,ex4(:),8,G2tensor(41),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(33),1,ex4(:),8,G2tensor(42),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(16),27,ex3(:),4,G2tensor(43),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(17),0,ex3(:),4,G2tensor(44),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(22),27,ex3(:),4,G2tensor(45),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(23),1,ex3(:),4,G2tensor(46),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(37),23,ex4(:),8,G2tensor(47),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(38),0,ex4(:),8,G2tensor(48),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(43),23,ex4(:),8,G2tensor(49),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(44),2,ex4(:),8,G2tensor(50),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(27),27,ex3(:),4,G2tensor(51),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(28),0,ex3(:),4,G2tensor(52),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(33),27,ex3(:),4,G2tensor(53),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(34),2,ex3(:),4,G2tensor(54),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hloop_AZ_Q(ntryL,G1H3(48),ex4(:),G1H1(1),ngZd,m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(19))
  call Hloop_AZ_Q(ntryL,G1H3(49),ex4(:),G1H1(1),ngZd,m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(56),n2h1(20))
  call Hloop_AZ_Q(ntryL,G1H3(54),ex4(:),G1H1(1),ngZd,m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(21))
  call Hloop_AZ_Q(ntryL,G1H3(55),ex4(:),G1H1(1),ngZd,m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(58),n2h1(22))
  call Hloop_AZ_Q(ntryL,G1H3(59),ex4(:),G1H1(1),ngZd,m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(23))
  call Hloop_AZ_Q(ntryL,G1H3(60),ex4(:),G1H1(1),ngZd,m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(60),n2h1(24))
  call Hloop_AZ_Q(ntryL,G1H3(65),ex4(:),G1H1(1),ngZd,m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(25))
  call Hloop_AZ_Q(ntryL,G1H3(66),ex4(:),G1H1(1),ngZd,m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(62),n2h1(26))
  call Hloop_AZ_Q(ntryL,G1H3(70),ex4(:),G1H1(1),ngZu,m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(27))
  call Hloop_AZ_Q(ntryL,G1H3(71),ex4(:),G1H1(1),ngZu,m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(64),n2h1(28))
  call Hloop_AZ_Q(ntryL,G1H3(76),ex4(:),G1H1(1),ngZu,m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(29))
  call Hloop_AZ_Q(ntryL,G1H3(77),ex4(:),G1H1(1),ngZu,m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(66),n2h1(30))
  call Hloop_QZ_A(ntryL,G1H3(81),ex4(:),G1H1(1),ngZd,m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(31))
  call Hloop_QZ_A(ntryL,G1H3(82),ex4(:),G1H1(1),ngZd,m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(68),n2h1(32))
  call Hloop_QZ_A(ntryL,G1H3(87),ex4(:),G1H1(1),ngZd,m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(33))
  call Hloop_QZ_A(ntryL,G1H3(88),ex4(:),G1H1(1),ngZd,m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(70),n2h1(34))
  call Hloop_QZ_A(ntryL,G1H3(92),ex4(:),G1H1(1),ngZd,m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(35))
  call Hloop_QZ_A(ntryL,G1H3(93),ex4(:),G1H1(1),ngZd,m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(72),n2h1(36))
  call Hloop_QZ_A(ntryL,G1H3(98),ex4(:),G1H1(1),ngZd,m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(37))
  call Hloop_QZ_A(ntryL,G1H3(99),ex4(:),G1H1(1),ngZd,m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(74),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H3(103),ex4(:),G1H1(1),ngZu,m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H3(104),ex4(:),G1H1(1),ngZu,m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(76),n2h1(40))
  call Hloop_QZ_A(ntryL,G1H3(109),ex4(:),G1H1(1),ngZu,m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(41))
  call Hloop_QZ_A(ntryL,G1H3(110),ex4(:),G1H1(1),ngZu,m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(78),n2h1(42))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(114),23,ex4(:),8,G2tensor(79),m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(115),0,ex4(:),8,G2tensor(80),m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(120),23,ex4(:),8,G2tensor(81),m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(121),4,ex4(:),8,G2tensor(82),m3h3x1(:,56),heltab2x3(:,:,56))
  call Hloop_QZ_A(ntryL,G1H3(125),ex4(:),G1H1(1),ngZd,m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(45))
  call Hloop_QZ_A(ntryL,G1H3(126),ex4(:),G1H1(1),ngZd,m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(84),n2h1(46))
  call Hloop_QZ_A(ntryL,G1H3(131),ex4(:),G1H1(1),ngZd,m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(47))
  call Hloop_QZ_A(ntryL,G1H3(132),ex4(:),G1H1(1),ngZd,m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(86),n2h1(48))
  call Hloop_QZ_A(ntryL,G1H3(136),ex4(:),G1H1(1),ngZd,m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(49))
  call Hloop_QZ_A(ntryL,G1H3(137),ex4(:),G1H1(1),ngZd,m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(88),n2h1(50))
  call Hloop_QZ_A(ntryL,G1H3(142),ex4(:),G1H1(1),ngZd,m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(51))
  call Hloop_QZ_A(ntryL,G1H3(143),ex4(:),G1H1(1),ngZd,m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(90),n2h1(52))
  call Hloop_QZ_A(ntryL,G1H3(147),ex4(:),G1H1(1),ngZu,m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(53))
  call Hloop_QZ_A(ntryL,G1H3(148),ex4(:),G1H1(1),ngZu,m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(92),n2h1(54))
  call Hloop_QZ_A(ntryL,G1H3(153),ex4(:),G1H1(1),ngZu,m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(55))
  call Hloop_QZ_A(ntryL,G1H3(154),ex4(:),G1H1(1),ngZu,m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(94),n2h1(56))
  call Hloop_QV_A(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(57))
  call Hloop_QV_A(ntryL,G1H2(39),ex3(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(96),n2h1(58))
  call Hloop_QV_A(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(45),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(98),n2h1(60))
  call Hloop_QV_A(ntryL,G1H2(49),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(99),n2h1(61))
  call Hloop_QV_A(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(100),n2h1(62))
  call Hloop_QV_A(ntryL,G1H2(55),ex3(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(101),n2h1(63))
  call Hloop_QV_A(ntryL,G1H2(56),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(102),n2h1(64))
  call Hloop_QV_A(ntryL,G1H2(60),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(65))
  call Hloop_QV_A(ntryL,G1H2(61),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(104),n2h1(66))
  call Hloop_QV_A(ntryL,G1H2(66),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(105),n2h1(67))
  call Hloop_QV_A(ntryL,G1H2(67),ex3(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(106),n2h1(68))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(71),27,ex3(:),4,G2tensor(107),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(72),0,ex3(:),4,G2tensor(108),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(77),27,ex3(:),4,G2tensor(109),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(78),8,ex3(:),4,G2tensor(110),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hloop_AZ_Q(ntryL,G1H3(158),ex4(:),G1H1(1),ngZd,m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(111),n2h1(71))
  call Hloop_AZ_Q(ntryL,G1H3(159),ex4(:),G1H1(1),ngZd,m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(112),n2h1(72))
  call Hloop_AZ_Q(ntryL,G1H3(164),ex4(:),G1H1(1),ngZd,m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(113),n2h1(73))
  call Hloop_AZ_Q(ntryL,G1H3(165),ex4(:),G1H1(1),ngZd,m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(114),n2h1(74))
  call Hloop_AZ_Q(ntryL,G1H3(169),ex4(:),G1H1(1),ngZd,m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(115),n2h1(75))
  call Hloop_AZ_Q(ntryL,G1H3(170),ex4(:),G1H1(1),ngZd,m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(116),n2h1(76))
  call Hloop_AZ_Q(ntryL,G1H3(175),ex4(:),G1H1(1),ngZd,m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(117),n2h1(77))
  call Hloop_AZ_Q(ntryL,G1H3(176),ex4(:),G1H1(1),ngZd,m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(118),n2h1(78))
  call Hloop_AZ_Q(ntryL,G1H3(180),ex4(:),G1H1(1),ngZu,m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(79))
  call Hloop_AZ_Q(ntryL,G1H3(181),ex4(:),G1H1(1),ngZu,m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(120),n2h1(80))
  call Hloop_AZ_Q(ntryL,G1H3(186),ex4(:),G1H1(1),ngZu,m3h3x1(:,79),heltab2x3(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(121),n2h1(81))
  call Hloop_AZ_Q(ntryL,G1H3(187),ex4(:),G1H1(1),ngZu,m3h3x1(:,80),heltab2x3(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(122),n2h1(82))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(191),23,ex4(:),8,G2tensor(123),m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(192),0,ex4(:),8,G2tensor(124),m3h3x1(:,82),heltab2x3(:,:,82))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(197),23,ex4(:),8,G2tensor(125),m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(198),4,ex4(:),8,G2tensor(126),m3h3x1(:,84),heltab2x3(:,:,84))
  call Hloop_AV_Q(ntryL,G1H2(82),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(127),n2h1(85))
  call Hloop_AV_Q(ntryL,G1H2(83),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(128),n2h1(86))
  call Hloop_AV_Q(ntryL,G1H2(88),ex3(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(129),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H2(89),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(130),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H2(93),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(94),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(132),n2h1(90))
  call Hloop_AV_Q(ntryL,G1H2(99),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(133),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H2(100),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(134),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(104),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(135),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(105),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(136),n2h1(94))
  call Hloop_AV_Q(ntryL,G1H2(110),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(137),n2h1(95))
  call Hloop_AV_Q(ntryL,G1H2(111),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(138),n2h1(96))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(115),27,ex3(:),4,G2tensor(139),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(116),0,ex3(:),4,G2tensor(140),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(121),27,ex3(:),4,G2tensor(141),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(122),8,ex3(:),4,G2tensor(142),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hloop_QZ_A(ntryL,G1H3(202),ex4(:),G1H1(1),ngZu,m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(143),n2h1(99))
  call Hloop_QZ_A(ntryL,G1H3(203),ex4(:),G1H1(1),ngZu,m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(144),n2h1(100))
  call Hloop_QZ_A(ntryL,G1H3(208),ex4(:),G1H1(1),ngZu,m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(145),n2h1(101))
  call Hloop_QZ_A(ntryL,G1H3(209),ex4(:),G1H1(1),ngZu,m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(146),n2h1(102))
  call Hloop_QV_A(ntryL,G1H2(126),ex3(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(147),n2h1(103))
  call Hloop_QV_A(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(148),n2h1(104))
  call Hloop_QV_A(ntryL,G1H2(132),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(149),n2h1(105))
  call Hloop_QV_A(ntryL,G1H2(133),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(150),n2h1(106))
  call Hloop_AZ_Q(ntryL,G1H3(213),ex4(:),G1H1(1),ngZu,m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(151),n2h1(107))
  call Hloop_AZ_Q(ntryL,G1H3(214),ex4(:),G1H1(1),ngZu,m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(152),n2h1(108))
  call Hloop_AZ_Q(ntryL,G1H3(219),ex4(:),G1H1(1),ngZu,m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(153),n2h1(109))
  call Hloop_AZ_Q(ntryL,G1H3(220),ex4(:),G1H1(1),ngZu,m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(154),n2h1(110))
  call Hloop_WA_Q(ntryL,G1H2(138),ex2(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(155),n2h1(111))
  call Hloop_AV_Q(ntryL,G1H2(142),ex3(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(156),n2h1(112))
  call Hloop_AV_Q(ntryL,G1H2(143),ex3(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(157),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H2(148),ex3(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(158),n2h1(114))
  call Hloop_AV_Q(ntryL,G1H2(149),ex3(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(159),n2h1(115))
  call Hloop_WA_Q(ntryL,G1H2(154),ex2(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(160),n2h1(116))
  call ol_merge_tensors(G2tensor(31),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(4),G2tensor(3),G2tensor(2)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(8),G2tensor(7),G2tensor(6)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(11),G2tensor(10),G2tensor(9)])
  call ol_merge_tensors(G2tensor(139),[G2tensor(14),G2tensor(13),G2tensor(12)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(16)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(17)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(19)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(20)])
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(9),mass5set(:,9),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(10),mass5set(:,9),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(11),mass5set(:,9),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(12),mass5set(:,9),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(3),mass5set(:,12),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(3),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(4),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),4)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(5),mass5set(:,12),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(5),mass5set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(7),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(6),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),2)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(8),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),2)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(6),mass5set(:,11),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),2)
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(8),mass5set(:,11),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(1),mass5set(:,4),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(1),mass5set(:,5),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(1),mass5set(:,6),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(9),mass5set(:,4),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(9),mass5set(:,7),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(9),mass5set(:,8),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(2),mass5set(:,4),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(2),mass5set(:,5),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(2),mass5set(:,6),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(10),mass5set(:,4),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),4)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(10),mass5set(:,7),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),4)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(10),mass5set(:,8),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(11),mass5set(:,4),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(11),mass5set(:,7),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(11),mass5set(:,8),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(12),mass5set(:,4),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(12),mass5set(:,7),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),4)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(12),mass5set(:,8),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),4)
  call Hotf_5pt_reduction_last(G2tensor(143),RedSet_5(3),mass5set(:,10),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),8)
  call Hotf_5pt_reduction_last(G2tensor(147),RedSet_5(4),mass5set(:,10),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(5),mass5set(:,10),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),8)
  call Hotf_5pt_reduction_last(G2tensor(156),RedSet_5(7),mass5set(:,10),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(69),h0tab(:,69),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H72(1),ex5(:),ex4(:),G0H8(1),m4h3x3x8(:,1),heltab3x72(:,:,1))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(70),h0tab(:,70),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H72(1),ex5(:),ex4(:),G0H8(2),m4h3x3x8(:,2),heltab3x72(:,:,2))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(71),h0tab(:,71),[24,1,4,2],[nMW,0,0,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H72(1),ex5(:),ex4(:),G0H8(3),m4h3x3x8(:,3),heltab3x72(:,:,3))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(72),h0tab(:,72),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(3),m4h3x2x12(:,1),heltab3x72(:,:,4))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(73),h0tab(:,73),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(1),m4h3x2x12(:,2),heltab3x72(:,:,5))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(74),h0tab(:,74),[20,1,8,2],[nMW,0,0,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H72(1),ex5(:),ex3(:),G0H12(2),m4h3x2x12(:,3),heltab3x72(:,:,6))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(75),h0tab(:,75),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(1),m3h3x24(:,69),heltab2x72(:,:,69))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(76),h0tab(:,76),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(7),m3h3x24(:,70),heltab2x72(:,:,70))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(77),h0tab(:,77),[16,1,12,2],[0,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(19),ngZu,m3h3x24(:,71),heltab2x72(:,:,71))
  call Hloop_A_Q(ntryL,G0H24(19),16,0,G1H24(13),n2h24(33))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(78),h0tab(:,78),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(1),ngZl,m3h3x24(:,72),heltab2x72(:,:,72))
  call Hloop_Q_A(ntryL,G0H24(1),16,nME,G1H24(19),n2h24(34))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(79),h0tab(:,79),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(2),ngZl,m3h3x24(:,73),heltab2x72(:,:,73))
  call Hloop_Q_A(ntryL,G0H24(2),16,nMM,G1H24(25),n2h24(35))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(80),h0tab(:,80),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(3),ngZl,m3h3x24(:,74),heltab2x72(:,:,74))
  call Hloop_Q_A(ntryL,G0H24(3),16,nML,G1H24(31),n2h24(36))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(81),h0tab(:,81),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(4),ngZl,m3h3x24(:,75),heltab2x72(:,:,75))
  call Hloop_A_Q(ntryL,G0H24(4),16,nME,G1H24(4),n2h24(37))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(82),h0tab(:,82),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(5),ngZl,m3h3x24(:,76),heltab2x72(:,:,76))
  call Hloop_A_Q(ntryL,G0H24(5),16,nMM,G1H24(2),n2h24(38))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(83),h0tab(:,83),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(6),ngZl,m3h3x24(:,77),heltab2x72(:,:,77))
  call Hloop_A_Q(ntryL,G0H24(6),16,nML,G1H24(3),n2h24(39))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(84),h0tab(:,84),[16,3,8,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(7),ngZu,m3h3x24(:,78),heltab2x72(:,:,78))
  call Hloop_Q_A(ntryL,G0H24(7),16,0,G1H24(5),n2h24(40))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(85),h0tab(:,85),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(8),ngZu,m3h3x24(:,79),heltab2x72(:,:,79))
  call Hloop_Q_A(ntryL,G0H24(8),16,nMT,G1H24(6),n2h24(41))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(86),h0tab(:,86),[16,3,8,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(9),ngZu,m3h3x24(:,80),heltab2x72(:,:,80))
  call Hloop_A_Q(ntryL,G0H24(9),16,0,G1H24(10),n2h24(42))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(87),h0tab(:,87),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(10),ngZu,m3h3x24(:,81),heltab2x72(:,:,81))
  call Hloop_A_Q(ntryL,G0H24(10),16,nMT,G1H24(8),n2h24(43))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(88),h0tab(:,88),[16,3,8,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(11),ngZd,m3h3x24(:,82),heltab2x72(:,:,82))
  call Hloop_Q_A(ntryL,G0H24(11),16,0,G1H24(9),n2h24(44))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(89),h0tab(:,89),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(12),ngZd,m3h3x24(:,83),heltab2x72(:,:,83))
  call Hloop_Q_A(ntryL,G0H24(12),16,nMB,G1H24(11),n2h24(45))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(90),h0tab(:,90),[16,3,8,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(13),ngZd,m3h3x24(:,84),heltab2x72(:,:,84))
  call Hloop_A_Q(ntryL,G0H24(13),16,0,G1H24(12),n2h24(46))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(91),h0tab(:,91),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(14),ngZd,m3h3x24(:,85),heltab2x72(:,:,85))
  call Hloop_A_Q(ntryL,G0H24(14),16,nMB,G1H24(16),n2h24(47))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(92),h0tab(:,92),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(15),ngZl,m3h3x24(:,86),heltab2x72(:,:,86))
  call Hloop_Q_A(ntryL,G0H24(15),16,nME,G1H24(14),n2h24(48))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(93),h0tab(:,93),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(16),ngZl,m3h3x24(:,87),heltab2x72(:,:,87))
  call Hloop_Q_A(ntryL,G0H24(16),16,nMM,G1H24(15),n2h24(49))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(94),h0tab(:,94),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(17),ngZl,m3h3x24(:,88),heltab2x72(:,:,88))
  call Hloop_Q_A(ntryL,G0H24(17),16,nML,G1H24(17),n2h24(50))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(95),h0tab(:,95),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(18),ngZl,m3h3x24(:,89),heltab2x72(:,:,89))
  call Hloop_A_Q(ntryL,G0H24(18),16,nME,G1H24(18),n2h24(51))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(96),h0tab(:,96),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(19),ngZl,m3h3x24(:,90),heltab2x72(:,:,90))
  call Hloop_A_Q(ntryL,G0H24(19),16,nMM,G1H24(22),n2h24(52))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(97),h0tab(:,97),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(1),ngZl,m3h3x24(:,91),heltab2x72(:,:,91))
  call Hloop_A_Q(ntryL,G0H24(1),16,nML,G1H24(20),n2h24(53))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(98),h0tab(:,98),[16,3,8,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(2),ngZu,m3h3x24(:,92),heltab2x72(:,:,92))
  call Hloop_Q_A(ntryL,G0H24(2),16,0,G1H24(21),n2h24(54))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(99),h0tab(:,99),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(3),ngZu,m3h3x24(:,93),heltab2x72(:,:,93))
  call Hloop_Q_A(ntryL,G0H24(3),16,nMT,G1H24(23),n2h24(55))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(100),h0tab(:,100),[16,3,8,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(4),ngZu,m3h3x24(:,94),heltab2x72(:,:,94))
  call Hloop_A_Q(ntryL,G0H24(4),16,0,G1H24(24),n2h24(56))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(101),h0tab(:,101),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(5),ngZu,m3h3x24(:,95),heltab2x72(:,:,95))
  call Hloop_A_Q(ntryL,G0H24(5),16,nMT,G1H24(28),n2h24(57))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(102),h0tab(:,102),[16,3,8,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(6),ngZd,m3h3x24(:,96),heltab2x72(:,:,96))
  call Hloop_Q_A(ntryL,G0H24(6),16,0,G1H24(26),n2h24(58))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(103),h0tab(:,103),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(7),ngZd,m3h3x24(:,97),heltab2x72(:,:,97))
  call Hloop_Q_A(ntryL,G0H24(7),16,nMB,G1H24(27),n2h24(59))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(104),h0tab(:,104),[16,3,8,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(8),ngZd,m3h3x24(:,98),heltab2x72(:,:,98))
  call Hloop_A_Q(ntryL,G0H24(8),16,0,G1H24(29),n2h24(60))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(105),h0tab(:,105),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(9),ngZd,m3h3x24(:,99),heltab2x72(:,:,99))
  call Hloop_A_Q(ntryL,G0H24(9),16,nMB,G1H24(30),n2h24(61))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(106),h0tab(:,106),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(34),m3h3x24(:,100),heltab2x72(:,:,100))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(107),h0tab(:,107),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(32),m3h3x24(:,101),heltab2x72(:,:,101))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(108),h0tab(:,108),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(33),m3h3x24(:,102),heltab2x72(:,:,102))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(109),h0tab(:,109),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(35),m3h3x24(:,103),heltab2x72(:,:,103))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(110),h0tab(:,110),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(36),m3h3x24(:,104),heltab2x72(:,:,104))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(111),h0tab(:,111),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(37),m3h3x24(:,105),heltab2x72(:,:,105))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(112),h0tab(:,112),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(38),m3h3x24(:,106),heltab2x72(:,:,106))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(113),h0tab(:,113),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(39),m3h3x24(:,107),heltab2x72(:,:,107))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(114),h0tab(:,114),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(40),m3h3x24(:,108),heltab2x72(:,:,108))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(115),h0tab(:,115),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(41),m3h3x24(:,109),heltab2x72(:,:,109))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(116),h0tab(:,116),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(42),m3h3x24(:,110),heltab2x72(:,:,110))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(117),h0tab(:,117),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(43),m3h3x24(:,111),heltab2x72(:,:,111))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(118),h0tab(:,118),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(44),m3h3x24(:,112),heltab2x72(:,:,112))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(119),h0tab(:,119),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(45),m3h3x24(:,113),heltab2x72(:,:,113))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(120),h0tab(:,120),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(46),m3h3x24(:,114),heltab2x72(:,:,114))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(121),h0tab(:,121),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(47),m3h3x24(:,115),heltab2x72(:,:,115))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(122),h0tab(:,122),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(10),m3h3x24(:,116),heltab2x72(:,:,116))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(123),h0tab(:,123),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(11),m3h3x24(:,117),heltab2x72(:,:,117))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(124),h0tab(:,124),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(12),m3h3x24(:,118),heltab2x72(:,:,118))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(125),h0tab(:,125),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,119),heltab2x72(:,:,119))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(126),h0tab(:,126),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(48),m3h3x24(:,120),heltab2x72(:,:,120))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(127),h0tab(:,127),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(49),m3h3x24(:,121),heltab2x72(:,:,121))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(128),h0tab(:,128),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(50),m3h3x24(:,122),heltab2x72(:,:,122))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(129),h0tab(:,129),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(51),m3h3x24(:,123),heltab2x72(:,:,123))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(130),h0tab(:,130),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(14),m3h3x24(:,124),heltab2x72(:,:,124))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(131),h0tab(:,131),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(15),m3h3x24(:,125),heltab2x72(:,:,125))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(132),h0tab(:,132),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(16),m3h3x24(:,126),heltab2x72(:,:,126))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(133),h0tab(:,133),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(17),m3h3x24(:,127),heltab2x72(:,:,127))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(134),h0tab(:,134),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(52),m3h3x24(:,128),heltab2x72(:,:,128))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(135),h0tab(:,135),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(53),m3h3x24(:,129),heltab2x72(:,:,129))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(136),h0tab(:,136),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(54),m3h3x24(:,130),heltab2x72(:,:,130))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(137),h0tab(:,137),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(55),m3h3x24(:,131),heltab2x72(:,:,131))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(138),h0tab(:,138),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(18),m3h3x24(:,132),heltab2x72(:,:,132))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(139),h0tab(:,139),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(19),m3h3x24(:,133),heltab2x72(:,:,133))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(140),h0tab(:,140),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,134),heltab2x72(:,:,134))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(141),h0tab(:,141),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(2),m3h3x24(:,135),heltab2x72(:,:,135))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(142),h0tab(:,142),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(56),m3h3x24(:,136),heltab2x72(:,:,136))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(143),h0tab(:,143),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(57),m3h3x24(:,137),heltab2x72(:,:,137))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(144),h0tab(:,144),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(58),m3h3x24(:,138),heltab2x72(:,:,138))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(145),h0tab(:,145),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(59),m3h3x24(:,139),heltab2x72(:,:,139))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(146),h0tab(:,146),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(3),m3h3x24(:,140),heltab2x72(:,:,140))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(147),h0tab(:,147),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(4),m3h3x24(:,141),heltab2x72(:,:,141))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(148),h0tab(:,148),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(5),m3h3x24(:,142),heltab2x72(:,:,142))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(149),h0tab(:,149),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(6),m3h3x24(:,143),heltab2x72(:,:,143))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(150),h0tab(:,150),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(7),m3h3x24(:,144),heltab2x72(:,:,144))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(151),h0tab(:,151),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(8),m3h3x24(:,145),heltab2x72(:,:,145))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(152),h0tab(:,152),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(9),m3h3x24(:,146),heltab2x72(:,:,146))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(153),h0tab(:,153),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(20),m3h3x24(:,147),heltab2x72(:,:,147))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(154),h0tab(:,154),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(60),m3h3x24(:,148),heltab2x72(:,:,148))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(155),h0tab(:,155),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(61),m3h3x24(:,149),heltab2x72(:,:,149))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(156),h0tab(:,156),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(62),m3h3x24(:,150),heltab2x72(:,:,150))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(157),h0tab(:,157),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(63),m3h3x24(:,151),heltab2x72(:,:,151))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(158),h0tab(:,158),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(21),m3h3x24(:,152),heltab2x72(:,:,152))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(159),h0tab(:,159),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(22),m3h3x24(:,153),heltab2x72(:,:,153))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(160),h0tab(:,160),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(23),m3h3x24(:,154),heltab2x72(:,:,154))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(161),h0tab(:,161),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(24),m3h3x24(:,155),heltab2x72(:,:,155))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(162),h0tab(:,162),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(64),m3h3x24(:,156),heltab2x72(:,:,156))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(163),h0tab(:,163),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(65),m3h3x24(:,157),heltab2x72(:,:,157))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(164),h0tab(:,164),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(66),m3h3x24(:,158),heltab2x72(:,:,158))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(165),h0tab(:,165),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(67),m3h3x24(:,159),heltab2x72(:,:,159))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(166),h0tab(:,166),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(25),m3h3x24(:,160),heltab2x72(:,:,160))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(167),h0tab(:,167),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(26),m3h3x24(:,161),heltab2x72(:,:,161))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(168),h0tab(:,168),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(27),m3h3x24(:,162),heltab2x72(:,:,162))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(169),h0tab(:,169),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(28),m3h3x24(:,163),heltab2x72(:,:,163))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(170),h0tab(:,170),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(68),m3h3x24(:,164),heltab2x72(:,:,164))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(171),h0tab(:,171),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(69),m3h3x24(:,165),heltab2x72(:,:,165))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(172),h0tab(:,172),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(70),m3h3x24(:,166),heltab2x72(:,:,166))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(173),h0tab(:,173),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(71),m3h3x24(:,167),heltab2x72(:,:,167))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(174),h0tab(:,174),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(29),m3h3x24(:,168),heltab2x72(:,:,168))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(175),h0tab(:,175),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(30),m3h3x24(:,169),heltab2x72(:,:,169))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(176),h0tab(:,176),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(31),m3h3x24(:,170),heltab2x72(:,:,170))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(177),h0tab(:,177),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(32),m3h3x24(:,171),heltab2x72(:,:,171))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(178),h0tab(:,178),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,172),heltab2x72(:,:,172))
  call Hloop_A_Q(ntryL,G0H24(33),16,nME,G1H24(72),n2h24(62))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(179),h0tab(:,179),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,173),heltab2x72(:,:,173))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMM,G1H24(73),n2h24(63))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(180),h0tab(:,180),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,174),heltab2x72(:,:,174))
  call Hloop_A_Q(ntryL,G0H24(33),16,nML,G1H24(74),n2h24(64))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(181),h0tab(:,181),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,175),heltab2x72(:,:,175))
  call Hloop_Q_A(ntryL,G0H24(33),16,nME,G1H24(75),n2h24(65))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(182),h0tab(:,182),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,176),heltab2x72(:,:,176))
  call Hloop_Q_A(ntryL,G0H24(33),16,nMM,G1H24(76),n2h24(66))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(183),h0tab(:,183),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,177),heltab2x72(:,:,177))
  call Hloop_Q_A(ntryL,G0H24(33),16,nML,G1H24(77),n2h24(67))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(184),h0tab(:,184),[16,3,4,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZu,m3h3x24(:,178),heltab2x72(:,:,178))
  call Hloop_A_Q(ntryL,G0H24(33),16,0,G1H24(78),n2h24(68))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(185),h0tab(:,185),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZu,m3h3x24(:,179),heltab2x72(:,:,179))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMT,G1H24(79),n2h24(69))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(186),h0tab(:,186),[16,3,4,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZu,m3h3x24(:,180),heltab2x72(:,:,180))
  call Hloop_Q_A(ntryL,G0H24(33),16,0,G1H24(80),n2h24(70))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(187),h0tab(:,187),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZu,m3h3x24(:,181),heltab2x72(:,:,181))
  call Hloop_Q_A(ntryL,G0H24(33),16,nMT,G1H24(81),n2h24(71))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(188),h0tab(:,188),[16,3,4,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,182),heltab2x72(:,:,182))
  call Hloop_A_Q(ntryL,G0H24(33),16,0,G1H24(82),n2h24(72))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(189),h0tab(:,189),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,183),heltab2x72(:,:,183))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMB,G1H24(83),n2h24(73))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(190),h0tab(:,190),[16,3,4,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,184),heltab2x72(:,:,184))
  call Hloop_Q_A(ntryL,G0H24(33),16,0,G1H24(84),n2h24(74))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(191),h0tab(:,191),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,185),heltab2x72(:,:,185))
  call Hloop_Q_A(ntryL,G0H24(33),16,nMB,G1H24(85),n2h24(75))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(192),h0tab(:,192),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,186),heltab2x72(:,:,186))
  call Hloop_A_Q(ntryL,G0H24(33),16,nME,G1H24(86),n2h24(76))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(193),h0tab(:,193),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,187),heltab2x72(:,:,187))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMM,G1H24(87),n2h24(77))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(194),h0tab(:,194),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,188),heltab2x72(:,:,188))
  call Hloop_A_Q(ntryL,G0H24(33),16,nML,G1H24(88),n2h24(78))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(195),h0tab(:,195),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,189),heltab2x72(:,:,189))
  call Hloop_Q_A(ntryL,G0H24(33),16,nME,G1H24(89),n2h24(79))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(196),h0tab(:,196),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,190),heltab2x72(:,:,190))
  call Hloop_Q_A(ntryL,G0H24(33),16,nMM,G1H24(90),n2h24(80))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(197),h0tab(:,197),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZl,m3h3x24(:,191),heltab2x72(:,:,191))
  call Hloop_Q_A(ntryL,G0H24(33),16,nML,G1H24(91),n2h24(81))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(198),h0tab(:,198),[16,3,4,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZu,m3h3x24(:,192),heltab2x72(:,:,192))
  call Hloop_A_Q(ntryL,G0H24(33),16,0,G1H24(92),n2h24(82))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(199),h0tab(:,199),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZu,m3h3x24(:,193),heltab2x72(:,:,193))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMT,G1H24(93),n2h24(83))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(200),h0tab(:,200),[16,3,4,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZu,m3h3x24(:,194),heltab2x72(:,:,194))
  call Hloop_Q_A(ntryL,G0H24(33),16,0,G1H24(94),n2h24(84))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(201),h0tab(:,201),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZu,m3h3x24(:,195),heltab2x72(:,:,195))
  call Hloop_Q_A(ntryL,G0H24(33),16,nMT,G1H24(95),n2h24(85))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(202),h0tab(:,202),[16,3,4,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,196),heltab2x72(:,:,196))
  call Hloop_A_Q(ntryL,G0H24(33),16,0,G1H24(96),n2h24(86))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(203),h0tab(:,203),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,197),heltab2x72(:,:,197))
  call Hloop_A_Q(ntryL,G0H24(33),16,nMB,G1H24(97),n2h24(87))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(204),h0tab(:,204),[16,3,4,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,198),heltab2x72(:,:,198))
  call Hloop_Q_A(ntryL,G0H24(33),16,0,G1H24(98),n2h24(88))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(205),h0tab(:,205),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(33),ngZd,m3h3x24(:,199),heltab2x72(:,:,199))
  call Hloop_Q_A(ntryL,G0H24(33),16,nMB,G1H24(99),n2h24(89))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(206),h0tab(:,206),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(100),m3h3x24(:,200),heltab2x72(:,:,200))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(207),h0tab(:,207),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(101),m3h3x24(:,201),heltab2x72(:,:,201))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(208),h0tab(:,208),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(102),m3h3x24(:,202),heltab2x72(:,:,202))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(209),h0tab(:,209),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(103),m3h3x24(:,203),heltab2x72(:,:,203))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(210),h0tab(:,210),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(104),m3h3x24(:,204),heltab2x72(:,:,204))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(211),h0tab(:,211),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(105),m3h3x24(:,205),heltab2x72(:,:,205))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(212),h0tab(:,212),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(106),m3h3x24(:,206),heltab2x72(:,:,206))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(213),h0tab(:,213),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(107),m3h3x24(:,207),heltab2x72(:,:,207))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(214),h0tab(:,214),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(108),m3h3x24(:,208),heltab2x72(:,:,208))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(215),h0tab(:,215),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(109),m3h3x24(:,209),heltab2x72(:,:,209))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(216),h0tab(:,216),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(110),m3h3x24(:,210),heltab2x72(:,:,210))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(217),h0tab(:,217),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(111),m3h3x24(:,211),heltab2x72(:,:,211))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(218),h0tab(:,218),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(112),m3h3x24(:,212),heltab2x72(:,:,212))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(219),h0tab(:,219),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(113),m3h3x24(:,213),heltab2x72(:,:,213))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(220),h0tab(:,220),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(114),m3h3x24(:,214),heltab2x72(:,:,214))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(221),h0tab(:,221),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(115),m3h3x24(:,215),heltab2x72(:,:,215))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(222),h0tab(:,222),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(33),m3h3x24(:,216),heltab2x72(:,:,216))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(223),h0tab(:,223),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(34),m3h3x24(:,217),heltab2x72(:,:,217))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(224),h0tab(:,224),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(35),m3h3x24(:,218),heltab2x72(:,:,218))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(225),h0tab(:,225),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(36),m3h3x24(:,219),heltab2x72(:,:,219))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(226),h0tab(:,226),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(37),m3h3x24(:,220),heltab2x72(:,:,220))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(227),h0tab(:,227),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(38),m3h3x24(:,221),heltab2x72(:,:,221))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(228),h0tab(:,228),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(39),m3h3x24(:,222),heltab2x72(:,:,222))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(229),h0tab(:,229),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(40),m3h3x24(:,223),heltab2x72(:,:,223))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(230),h0tab(:,230),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(116),m3h3x24(:,224),heltab2x72(:,:,224))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(231),h0tab(:,231),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(117),m3h3x24(:,225),heltab2x72(:,:,225))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(232),h0tab(:,232),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(118),m3h3x24(:,226),heltab2x72(:,:,226))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(233),h0tab(:,233),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(119),m3h3x24(:,227),heltab2x72(:,:,227))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(234),h0tab(:,234),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(120),m3h3x24(:,228),heltab2x72(:,:,228))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(235),h0tab(:,235),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(121),m3h3x24(:,229),heltab2x72(:,:,229))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(236),h0tab(:,236),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(122),m3h3x24(:,230),heltab2x72(:,:,230))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(237),h0tab(:,237),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(123),m3h3x24(:,231),heltab2x72(:,:,231))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(238),h0tab(:,238),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(124),m3h3x24(:,232),heltab2x72(:,:,232))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(239),h0tab(:,239),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(125),m3h3x24(:,233),heltab2x72(:,:,233))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(240),h0tab(:,240),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(126),m3h3x24(:,234),heltab2x72(:,:,234))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(241),h0tab(:,241),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(127),m3h3x24(:,235),heltab2x72(:,:,235))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(242),h0tab(:,242),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(41),m3h3x24(:,236),heltab2x72(:,:,236))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(243),h0tab(:,243),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(42),m3h3x24(:,237),heltab2x72(:,:,237))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(244),h0tab(:,244),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(43),m3h3x24(:,238),heltab2x72(:,:,238))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(245),h0tab(:,245),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(44),m3h3x24(:,239),heltab2x72(:,:,239))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(246),h0tab(:,246),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(45),m3h3x24(:,240),heltab2x72(:,:,240))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(247),h0tab(:,247),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(46),m3h3x24(:,241),heltab2x72(:,:,241))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(248),h0tab(:,248),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(47),m3h3x24(:,242),heltab2x72(:,:,242))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(249),h0tab(:,249),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(48),m3h3x24(:,243),heltab2x72(:,:,243))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(250),h0tab(:,250),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(49),m3h3x24(:,244),heltab2x72(:,:,244))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(251),h0tab(:,251),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(50),m3h3x24(:,245),heltab2x72(:,:,245))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(252),h0tab(:,252),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(51),m3h3x24(:,246),heltab2x72(:,:,246))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(253),h0tab(:,253),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(52),m3h3x24(:,247),heltab2x72(:,:,247))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(254),h0tab(:,254),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(53),m3h3x24(:,248),heltab2x72(:,:,248))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(255),h0tab(:,255),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(54),m3h3x24(:,249),heltab2x72(:,:,249))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(256),h0tab(:,256),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(55),m3h3x24(:,250),heltab2x72(:,:,250))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(257),h0tab(:,257),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(56),m3h3x24(:,251),heltab2x72(:,:,251))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(258),h0tab(:,258),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(128),m3h3x24(:,252),heltab2x72(:,:,252))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(259),h0tab(:,259),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(129),m3h3x24(:,253),heltab2x72(:,:,253))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(260),h0tab(:,260),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(130),m3h3x24(:,254),heltab2x72(:,:,254))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(261),h0tab(:,261),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(131),m3h3x24(:,255),heltab2x72(:,:,255))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(262),h0tab(:,262),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(132),m3h3x24(:,256),heltab2x72(:,:,256))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(263),h0tab(:,263),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(133),m3h3x24(:,257),heltab2x72(:,:,257))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(264),h0tab(:,264),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(134),m3h3x24(:,258),heltab2x72(:,:,258))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(265),h0tab(:,265),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(135),m3h3x24(:,259),heltab2x72(:,:,259))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(266),h0tab(:,266),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(136),m3h3x24(:,260),heltab2x72(:,:,260))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(267),h0tab(:,267),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(137),m3h3x24(:,261),heltab2x72(:,:,261))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(268),h0tab(:,268),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(138),m3h3x24(:,262),heltab2x72(:,:,262))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(269),h0tab(:,269),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(139),m3h3x24(:,263),heltab2x72(:,:,263))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(270),h0tab(:,270),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(57),m3h3x24(:,264),heltab2x72(:,:,264))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(271),h0tab(:,271),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(58),m3h3x24(:,265),heltab2x72(:,:,265))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(272),h0tab(:,272),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(59),m3h3x24(:,266),heltab2x72(:,:,266))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(273),h0tab(:,273),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(60),m3h3x24(:,267),heltab2x72(:,:,267))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(274),h0tab(:,274),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(61),m3h3x24(:,268),heltab2x72(:,:,268))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(275),h0tab(:,275),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(62),m3h3x24(:,269),heltab2x72(:,:,269))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(276),h0tab(:,276),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(63),m3h3x24(:,270),heltab2x72(:,:,270))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(277),h0tab(:,277),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(64),m3h3x24(:,271),heltab2x72(:,:,271))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(278),h0tab(:,278),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,272),heltab2x72(:,:,272))
  call Hloop_Q_A(ntryL,G0H24(65),16,nME,G1H24(140),n2h24(90))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(279),h0tab(:,279),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,273),heltab2x72(:,:,273))
  call Hloop_Q_A(ntryL,G0H24(65),16,nMM,G1H24(141),n2h24(91))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(280),h0tab(:,280),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,274),heltab2x72(:,:,274))
  call Hloop_Q_A(ntryL,G0H24(65),16,nML,G1H24(142),n2h24(92))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(281),h0tab(:,281),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,275),heltab2x72(:,:,275))
  call Hloop_A_Q(ntryL,G0H24(65),16,nME,G1H24(143),n2h24(93))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(282),h0tab(:,282),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,276),heltab2x72(:,:,276))
  call Hloop_A_Q(ntryL,G0H24(65),16,nMM,G1H24(144),n2h24(94))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(283),h0tab(:,283),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,277),heltab2x72(:,:,277))
  call Hloop_A_Q(ntryL,G0H24(65),16,nML,G1H24(145),n2h24(95))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(284),h0tab(:,284),[16,4,3,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZu,m3h3x24(:,278),heltab2x72(:,:,278))
  call Hloop_Q_A(ntryL,G0H24(65),16,0,G1H24(146),n2h24(96))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(285),h0tab(:,285),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZu,m3h3x24(:,279),heltab2x72(:,:,279))
  call Hloop_Q_A(ntryL,G0H24(65),16,nMT,G1H24(147),n2h24(97))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(286),h0tab(:,286),[16,4,3,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZu,m3h3x24(:,280),heltab2x72(:,:,280))
  call Hloop_A_Q(ntryL,G0H24(65),16,0,G1H24(148),n2h24(98))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(287),h0tab(:,287),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZu,m3h3x24(:,281),heltab2x72(:,:,281))
  call Hloop_A_Q(ntryL,G0H24(65),16,nMT,G1H24(149),n2h24(99))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(288),h0tab(:,288),[16,4,3,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZd,m3h3x24(:,282),heltab2x72(:,:,282))
  call Hloop_Q_A(ntryL,G0H24(65),16,0,G1H24(150),n2h24(100))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(289),h0tab(:,289),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZd,m3h3x24(:,283),heltab2x72(:,:,283))
  call Hloop_Q_A(ntryL,G0H24(65),16,nMB,G1H24(151),n2h24(101))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(290),h0tab(:,290),[16,4,3,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZd,m3h3x24(:,284),heltab2x72(:,:,284))
  call Hloop_A_Q(ntryL,G0H24(65),16,0,G1H24(152),n2h24(102))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(291),h0tab(:,291),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZd,m3h3x24(:,285),heltab2x72(:,:,285))
  call Hloop_A_Q(ntryL,G0H24(65),16,nMB,G1H24(153),n2h24(103))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(292),h0tab(:,292),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,286),heltab2x72(:,:,286))
  call Hloop_Q_A(ntryL,G0H24(65),16,nME,G1H24(154),n2h24(104))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(293),h0tab(:,293),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,287),heltab2x72(:,:,287))
  call Hloop_Q_A(ntryL,G0H24(65),16,nMM,G1H24(155),n2h24(105))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(294),h0tab(:,294),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,288),heltab2x72(:,:,288))
  call Hloop_Q_A(ntryL,G0H24(65),16,nML,G1H24(156),n2h24(106))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(295),h0tab(:,295),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,289),heltab2x72(:,:,289))
  call Hloop_A_Q(ntryL,G0H24(65),16,nME,G1H24(157),n2h24(107))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(296),h0tab(:,296),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,290),heltab2x72(:,:,290))
  call Hloop_A_Q(ntryL,G0H24(65),16,nMM,G1H24(158),n2h24(108))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(297),h0tab(:,297),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZl,m3h3x24(:,291),heltab2x72(:,:,291))
  call Hloop_A_Q(ntryL,G0H24(65),16,nML,G1H24(159),n2h24(109))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(298),h0tab(:,298),[16,4,3,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZu,m3h3x24(:,292),heltab2x72(:,:,292))
  call Hloop_Q_A(ntryL,G0H24(65),16,0,G1H24(160),n2h24(110))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(299),h0tab(:,299),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZu,m3h3x24(:,293),heltab2x72(:,:,293))
  call Hloop_Q_A(ntryL,G0H24(65),16,nMT,G1H24(161),n2h24(111))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(300),h0tab(:,300),[16,4,3,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZu,m3h3x24(:,294),heltab2x72(:,:,294))
  call Hloop_A_Q(ntryL,G0H24(65),16,0,G1H24(162),n2h24(112))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(301),h0tab(:,301),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZu,m3h3x24(:,295),heltab2x72(:,:,295))
  call Hloop_A_Q(ntryL,G0H24(65),16,nMT,G1H24(163),n2h24(113))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(302),h0tab(:,302),[16,4,3,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZd,m3h3x24(:,296),heltab2x72(:,:,296))
  call Hloop_Q_A(ntryL,G0H24(65),16,0,G1H24(164),n2h24(114))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(303),h0tab(:,303),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H72(1),ex5(:),G0H24(65),ngZd,m3h3x24(:,297),heltab2x72(:,:,297))
  call Hloop_Q_A(ntryL,G0H24(65),16,nMB,G1H24(165),n2h24(115))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(304),h0tab(:,304),[16,4,3,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZd,m3h3x24(:,298),heltab2x72(:,:,298))
  call Hloop_A_Q(ntryL,G0H24(65),16,0,G1H24(166),n2h24(116))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(305),h0tab(:,305),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H72(1),ex5(:),G0H24(65),ngZd,m3h3x24(:,299),heltab2x72(:,:,299))
  call Hloop_A_Q(ntryL,G0H24(65),16,nMB,G1H24(167),n2h24(117))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(306),h0tab(:,306),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(168),m3h3x24(:,300),heltab2x72(:,:,300))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(307),h0tab(:,307),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(169),m3h3x24(:,301),heltab2x72(:,:,301))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(308),h0tab(:,308),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(170),m3h3x24(:,302),heltab2x72(:,:,302))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(309),h0tab(:,309),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(171),m3h3x24(:,303),heltab2x72(:,:,303))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(310),h0tab(:,310),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(172),m3h3x24(:,304),heltab2x72(:,:,304))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(311),h0tab(:,311),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(173),m3h3x24(:,305),heltab2x72(:,:,305))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(312),h0tab(:,312),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(174),m3h3x24(:,306),heltab2x72(:,:,306))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(313),h0tab(:,313),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(175),m3h3x24(:,307),heltab2x72(:,:,307))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(314),h0tab(:,314),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(176),m3h3x24(:,308),heltab2x72(:,:,308))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(315),h0tab(:,315),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(177),m3h3x24(:,309),heltab2x72(:,:,309))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(316),h0tab(:,316),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H72(1),0,ex5(:),16,G1H24(178),m3h3x24(:,310),heltab2x72(:,:,310))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(317),h0tab(:,317),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H72(1),0,ex5(:),G1H24(179),m3h3x24(:,311),heltab2x72(:,:,311))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(318),h0tab(:,318),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(180),m3h3x24(:,312),heltab2x72(:,:,312))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(319),h0tab(:,319),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(181),m3h3x24(:,313),heltab2x72(:,:,313))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(320),h0tab(:,320),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(182),m3h3x24(:,314),heltab2x72(:,:,314))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(321),h0tab(:,321),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(183),m3h3x24(:,315),heltab2x72(:,:,315))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(322),h0tab(:,322),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(184),m3h3x24(:,316),heltab2x72(:,:,316))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(323),h0tab(:,323),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(185),m3h3x24(:,317),heltab2x72(:,:,317))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(324),h0tab(:,324),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,6))



end subroutine vamp_1

end module ol_vamp_1_ppvvv_ew_ddxazz_1_/**/REALKIND
