
module ol_vamp_1_ppvvv_ew_bbxawwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv_ew_bbxawwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv_ew_bbxawwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvv_ew_bbxawwx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvv_ew_bbxawwx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvv_ew_bbxawwx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvv_ew_bbxawwx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(72)
  type(Hpolcont), intent(in) :: M(2,72)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(76)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMB,nMH,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,1),heltab2x72(:,:,1))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(1),n2h24(1))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMB,nMB,nMZ,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,2),heltab2x72(:,:,2))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(2),n2h24(2))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(3),m3h3x24(:,3),heltab2x72(:,:,3))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(4),m3h3x24(:,4),heltab2x72(:,:,4))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMB,nMB,0,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,5),heltab2x72(:,:,5))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(5),n2h24(3))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMB,nMB,nMZ,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,6),heltab2x72(:,:,6))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(6),n2h24(4))
  Gcoeff(:)%j = (-(c(191)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMB,nMB,0,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,7),heltab2x72(:,:,7))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(7),n2h24(5))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMW,nMW,nMT,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(1),m3h3x24(:,8),heltab2x72(:,:,8))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(2),m3h3x24(:,9),heltab2x72(:,:,9))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(10),h0tab(:,10),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(3),m3h3x24(:,10),heltab2x72(:,:,10))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(11),h0tab(:,11),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(8),m3h3x24(:,11),heltab2x72(:,:,11))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(12),h0tab(:,12),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(9),m3h3x24(:,12),heltab2x72(:,:,12))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(13),h0tab(:,13),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(10),m3h3x24(:,13),heltab2x72(:,:,13))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(14),h0tab(:,14),[16,4,1,2,8],[nMW,nMW,nMT,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(11),m3h3x24(:,14),heltab2x72(:,:,14))
  Gcoeff(:)%j = (c(186)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(15),h0tab(:,15),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(12),m3h3x24(:,15),heltab2x72(:,:,15))
  Gcoeff(:)%j = (c(186)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(16),h0tab(:,16),[16,4,1,2,8],[nMW,nMW,nMT,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(4),m3h3x24(:,16),heltab2x72(:,:,16))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(17),h0tab(:,17),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(5),m3h3x24(:,17),heltab2x72(:,:,17))
  Gcoeff(:)%j = (-(c(124)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(18),h0tab(:,18),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(6),m3h3x24(:,18),heltab2x72(:,:,18))
  Gcoeff(:)%j = (c(233)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(19),h0tab(:,19),[16,4,1,2,8],[nMW,nMW,nMT,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(7),m3h3x24(:,19),heltab2x72(:,:,19))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(20),h0tab(:,20),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(8),m3h3x24(:,20),heltab2x72(:,:,20))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(21),h0tab(:,21),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(9),m3h3x24(:,21),heltab2x72(:,:,21))
  Gcoeff(:)%j = (c(122)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(22),h0tab(:,22),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(13),m3h3x24(:,22),heltab2x72(:,:,22))
  Gcoeff(:)%j = (c(186)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(23),h0tab(:,23),[16,4,1,2,8],[nMW,nMW,nMT,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(14),m3h3x24(:,23),heltab2x72(:,:,23))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(24),h0tab(:,24),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(15),m3h3x24(:,24),heltab2x72(:,:,24))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(25),h0tab(:,25),[16,4,1,2,8],[nMW,nMW,nMT,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(16),m3h3x24(:,25),heltab2x72(:,:,25))
  Gcoeff(:)%j = (c(186)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(26),h0tab(:,26),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(17),m3h3x24(:,26),heltab2x72(:,:,26))
  Gcoeff(:)%j = (-(c(233)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(27),h0tab(:,27),[16,4,1,2,8],[nMW,nMW,nMT,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(10),m3h3x24(:,27),heltab2x72(:,:,27))
  Gcoeff(:)%j = (c(233)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(28),h0tab(:,28),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(11),m3h3x24(:,28),heltab2x72(:,:,28))
  Gcoeff(:)%j = (-(c(124)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(29),h0tab(:,29),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(12),m3h3x24(:,29),heltab2x72(:,:,29))
  Gcoeff(:)%j = (c(186)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(30),h0tab(:,30),[16,4,1,2,8],[nMW,nMW,nMT,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(18),m3h3x24(:,30),heltab2x72(:,:,30))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(31),h0tab(:,31),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(19),m3h3x24(:,31),heltab2x72(:,:,31))
  Gcoeff(:)%j = (c(68)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(32),h0tab(:,32),[16,2,1,4,8],[nMT,nMW,nMT,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,32),heltab2x72(:,:,32))
  call Hloop_Q_A(ntryL,G0H24(13),16,nMT,G1H24(20),n2h24(6))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(33),h0tab(:,33),[16,2,1,4,8],[nMT,nMW,nMT,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,33),heltab2x72(:,:,33))
  call Hloop_Q_A(ntryL,G0H24(13),16,nMT,G1H24(21),n2h24(7))
  Gcoeff(:)%j = (c(68)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(34),h0tab(:,34),[16,4,2,1,8],[nMT,nMT,nMW,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,34),heltab2x72(:,:,34))
  call Hloop_Q_A(ntryL,G0H24(13),16,nMT,G1H24(22),n2h24(8))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(35),h0tab(:,35),[16,4,2,1,8],[nMT,nMT,nMW,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,35),heltab2x72(:,:,35))
  call Hloop_Q_A(ntryL,G0H24(13),16,nMT,G1H24(23),n2h24(9))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(36),h0tab(:,36),[16,2,1,8,4],[nMT,nMW,nMT,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,36),heltab2x72(:,:,36))
  call Hloop_Q_A(ntryL,G0H24(13),16,nMT,G1H24(24),n2h24(10))
  Gcoeff(:)%j = (c(77)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(37),h0tab(:,37),[16,2,1,8,4],[nMH,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(25),m3h3x24(:,37),heltab2x72(:,:,37))
  Gcoeff(:)%j = (c(77)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(38),h0tab(:,38),[16,2,1,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(26),m3h3x24(:,38),heltab2x72(:,:,38))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(39),h0tab(:,39),[16,2,1,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(27),m3h3x24(:,39),heltab2x72(:,:,39))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(40),h0tab(:,40),[16,2,1,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(28),m3h3x24(:,40),heltab2x72(:,:,40))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(41),h0tab(:,41),[16,2,1,8,4],[nMT,nMW,nMT,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,41),heltab2x72(:,:,41))
  call Hloop_Q_A(ntryL,G0H24(13),16,nMT,G1H24(29),n2h24(11))
  Gcoeff(:)%j = (c(53)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(42),h0tab(:,42),[16,2,1,8,4],[nMH,nMB,nMH,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(13),m3h3x24(:,42),heltab2x72(:,:,42))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(43),h0tab(:,43),[16,2,1,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(14),m3h3x24(:,43),heltab2x72(:,:,43))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(44),h0tab(:,44),[16,2,1,8,4],[nMH,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(30),m3h3x24(:,44),heltab2x72(:,:,44))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(45),h0tab(:,45),[16,2,1,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(31),m3h3x24(:,45),heltab2x72(:,:,45))
  Gcoeff(:)%j = (c(197)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(46),h0tab(:,46),[16,2,1,8,4],[0,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(15),m3h3x24(:,46),heltab2x72(:,:,46))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(47),h0tab(:,47),[16,2,1,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(16),m3h3x24(:,47),heltab2x72(:,:,47))
  Gcoeff(:)%j = (c(258)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(48),h0tab(:,48),[16,2,1,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(17),m3h3x24(:,48),heltab2x72(:,:,48))
  Gcoeff(:)%j = (-(c(258)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(49),h0tab(:,49),[16,2,1,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(18),m3h3x24(:,49),heltab2x72(:,:,49))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(50),h0tab(:,50),[16,2,1,8,4],[nMH,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(32),m3h3x24(:,50),heltab2x72(:,:,50))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(51),h0tab(:,51),[16,2,1,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(33),m3h3x24(:,51),heltab2x72(:,:,51))
  Gcoeff(:)%j = (-(c(258)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(52),h0tab(:,52),[16,2,1,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(34),m3h3x24(:,52),heltab2x72(:,:,52))
  Gcoeff(:)%j = (-(c(258)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(53),h0tab(:,53),[16,2,1,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(35),m3h3x24(:,53),heltab2x72(:,:,53))
  Gcoeff(:)%j = (c(54)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(54),h0tab(:,54),[16,2,1,8,4],[nMH,nMB,nMH,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(19),m3h3x24(:,54),heltab2x72(:,:,54))
  Gcoeff(:)%j = (c(197)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(55),h0tab(:,55),[16,2,1,8,4],[0,nMB,nMH,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(36),m3h3x24(:,55),heltab2x72(:,:,55))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(56),h0tab(:,56),[16,2,1,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(37),m3h3x24(:,56),heltab2x72(:,:,56))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(57),h0tab(:,57),[16,2,1,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(38),m3h3x24(:,57),heltab2x72(:,:,57))
  Gcoeff(:)%j = (c(154)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(58),h0tab(:,58),[16,2,1,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(39),m3h3x24(:,58),heltab2x72(:,:,58))
  Gcoeff(:)%j = (-(c(238)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(59),h0tab(:,59),[16,2,1,8,4],[0,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(20),m3h3x24(:,59),heltab2x72(:,:,59))
  Gcoeff(:)%j = (-(c(273)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(60),h0tab(:,60),[16,2,1,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(21),m3h3x24(:,60),heltab2x72(:,:,60))
  Gcoeff(:)%j = (-(c(238)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(61),h0tab(:,61),[16,2,1,8,4],[nMH,nMB,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(22),m3h3x24(:,61),heltab2x72(:,:,61))
  Gcoeff(:)%j = (-(c(273)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(62),h0tab(:,62),[16,2,1,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(23),m3h3x24(:,62),heltab2x72(:,:,62))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(63),h0tab(:,63),[16,2,1,8,4],[nMH,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(40),m3h3x24(:,63),heltab2x72(:,:,63))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(64),h0tab(:,64),[16,2,1,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(41),m3h3x24(:,64),heltab2x72(:,:,64))
  Gcoeff(:)%j = (c(154)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(65),h0tab(:,65),[16,2,1,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(42),m3h3x24(:,65),heltab2x72(:,:,65))
  Gcoeff(:)%j = (c(154)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(66),h0tab(:,66),[16,2,1,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(43),m3h3x24(:,66),heltab2x72(:,:,66))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(67),h0tab(:,67),[16,2,1,8,4],[0,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(24),m3h3x24(:,67),heltab2x72(:,:,67))
  Gcoeff(:)%j = (-(c(280)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(68),h0tab(:,68),[16,2,1,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(25),m3h3x24(:,68),heltab2x72(:,:,68))
  Gcoeff(:)%j = (-(c(280)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(69),h0tab(:,69),[16,2,1,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(26),m3h3x24(:,69),heltab2x72(:,:,69))
  Gcoeff(:)%j = (-(c(288)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(70),h0tab(:,70),[16,2,1,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(27),m3h3x24(:,70),heltab2x72(:,:,70))
  Gcoeff(:)%j = (c(198)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(71),h0tab(:,71),[16,2,1,8,4],[0,nMB,nMH,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(44),m3h3x24(:,71),heltab2x72(:,:,71))
  Gcoeff(:)%j = (-(c(155)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(72),h0tab(:,72),[16,2,1,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(45),m3h3x24(:,72),heltab2x72(:,:,72))
  Gcoeff(:)%j = (c(198)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(73),h0tab(:,73),[16,2,1,8,4],[nMH,nMB,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(28),m3h3x24(:,73),heltab2x72(:,:,73))
  Gcoeff(:)%j = (-(c(155)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(74),h0tab(:,74),[16,2,1,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(29),m3h3x24(:,74),heltab2x72(:,:,74))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(75),h0tab(:,75),[16,2,1,8,4],[0,nMB,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(46),m3h3x24(:,75),heltab2x72(:,:,75))
  Gcoeff(:)%j = (c(270)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(76),h0tab(:,76),[16,2,1,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(47),m3h3x24(:,76),heltab2x72(:,:,76))
  Gcoeff(:)%j = (-(c(280)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(77),h0tab(:,77),[16,2,1,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(48),m3h3x24(:,77),heltab2x72(:,:,77))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(78),h0tab(:,78),[16,2,1,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(49),m3h3x24(:,78),heltab2x72(:,:,78))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(79),h0tab(:,79),[16,2,1,8,4],[0,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(30),m3h3x24(:,79),heltab2x72(:,:,79))
  Gcoeff(:)%j = (-(c(280)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(80),h0tab(:,80),[16,2,1,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(31),m3h3x24(:,80),heltab2x72(:,:,80))
  Gcoeff(:)%j = (c(270)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(81),h0tab(:,81),[16,2,1,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(32),m3h3x24(:,81),heltab2x72(:,:,81))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(82),h0tab(:,82),[16,2,1,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(33),m3h3x24(:,82),heltab2x72(:,:,82))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(83),h0tab(:,83),[16,2,1,8,4],[0,nMB,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(50),m3h3x24(:,83),heltab2x72(:,:,83))
  Gcoeff(:)%j = (-(c(253)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(84),h0tab(:,84),[16,2,1,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(51),m3h3x24(:,84),heltab2x72(:,:,84))
  Gcoeff(:)%j = (-(c(253)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(85),h0tab(:,85),[16,2,1,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(52),m3h3x24(:,85),heltab2x72(:,:,85))
  Gcoeff(:)%j = (c(190)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(86),h0tab(:,86),[16,2,1,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(53),m3h3x24(:,86),heltab2x72(:,:,86))
  Gcoeff(:)%j = (c(76)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(87),h0tab(:,87),[16,1,2,4,8],[nMB,nMH,nMB,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(34),m3h3x24(:,87),heltab2x72(:,:,87))
  call Hloop_A_Q(ntryL,G0H24(34),16,nMB,G1H24(54),n2h24(12))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(88),h0tab(:,88),[16,1,2,4,8],[nMB,nMZ,nMB,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(34),m3h3x24(:,88),heltab2x72(:,:,88))
  call Hloop_A_Q(ntryL,G0H24(34),16,nMB,G1H24(55),n2h24(13))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(89),h0tab(:,89),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(56),m3h3x24(:,89),heltab2x72(:,:,89))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(90),h0tab(:,90),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(57),m3h3x24(:,90),heltab2x72(:,:,90))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(91),h0tab(:,91),[16,1,2,4,8],[nMB,0,nMB,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(34),m3h3x24(:,91),heltab2x72(:,:,91))
  call Hloop_A_Q(ntryL,G0H24(34),16,nMB,G1H24(58),n2h24(14))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(92),h0tab(:,92),[16,1,2,4,8],[nMB,nMZ,nMB,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(34),m3h3x24(:,92),heltab2x72(:,:,92))
  call Hloop_A_Q(ntryL,G0H24(34),16,nMB,G1H24(59),n2h24(15))
  Gcoeff(:)%j = (-(c(191)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(93),h0tab(:,93),[16,1,2,4,8],[nMB,0,nMB,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(34),m3h3x24(:,93),heltab2x72(:,:,93))
  call Hloop_A_Q(ntryL,G0H24(34),16,nMB,G1H24(60),n2h24(16))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(94),h0tab(:,94),[16,1,2,4,8],[nMW,nMT,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(34),m3h3x24(:,94),heltab2x72(:,:,94))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(95),h0tab(:,95),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(35),m3h3x24(:,95),heltab2x72(:,:,95))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(96),h0tab(:,96),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(61),m3h3x24(:,96),heltab2x72(:,:,96))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(97),h0tab(:,97),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(62),m3h3x24(:,97),heltab2x72(:,:,97))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(98),h0tab(:,98),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(63),m3h3x24(:,98),heltab2x72(:,:,98))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(99),h0tab(:,99),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(36),m3h3x24(:,99),heltab2x72(:,:,99))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(100),h0tab(:,100),[16,1,2,4,8],[nMW,nMT,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(37),m3h3x24(:,100),heltab2x72(:,:,100))
  Gcoeff(:)%j = (c(186)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(101),h0tab(:,101),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(38),m3h3x24(:,101),heltab2x72(:,:,101))
  Gcoeff(:)%j = (-(c(233)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(102),h0tab(:,102),[16,1,2,4,8],[nMW,nMT,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(39),m3h3x24(:,102),heltab2x72(:,:,102))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(103),h0tab(:,103),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(40),m3h3x24(:,103),heltab2x72(:,:,103))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(104),h0tab(:,104),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(64),m3h3x24(:,104),heltab2x72(:,:,104))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(105),h0tab(:,105),[16,1,2,4,8],[nMW,nMT,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(65),m3h3x24(:,105),heltab2x72(:,:,105))
  Gcoeff(:)%j = (c(186)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(106),h0tab(:,106),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(66),m3h3x24(:,106),heltab2x72(:,:,106))
  Gcoeff(:)%j = (c(124)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(107),h0tab(:,107),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(41),m3h3x24(:,107),heltab2x72(:,:,107))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(108),h0tab(:,108),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(42),m3h3x24(:,108),heltab2x72(:,:,108))
  Gcoeff(:)%j = (c(186)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(109),h0tab(:,109),[16,1,2,4,8],[nMW,nMT,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(43),m3h3x24(:,109),heltab2x72(:,:,109))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(110),h0tab(:,110),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(44),m3h3x24(:,110),heltab2x72(:,:,110))
  Gcoeff(:)%j = (-(c(186)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(111),h0tab(:,111),[16,1,2,4,8],[nMW,nMT,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(67),m3h3x24(:,111),heltab2x72(:,:,111))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(112),h0tab(:,112),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(68),m3h3x24(:,112),heltab2x72(:,:,112))
  Gcoeff(:)%j = (-(c(233)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(113),h0tab(:,113),[16,1,2,4,8],[nMW,nMT,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(69),m3h3x24(:,113),heltab2x72(:,:,113))
  Gcoeff(:)%j = (c(233)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(114),h0tab(:,114),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(70),m3h3x24(:,114),heltab2x72(:,:,114))
  Gcoeff(:)%j = (-(c(124)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(115),h0tab(:,115),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(45),m3h3x24(:,115),heltab2x72(:,:,115))
  Gcoeff(:)%j = (c(186)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(116),h0tab(:,116),[16,1,2,4,8],[nMW,nMT,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(71),m3h3x24(:,116),heltab2x72(:,:,116))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(117),h0tab(:,117),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(72),m3h3x24(:,117),heltab2x72(:,:,117))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(118),h0tab(:,118),[16,1,2,8,4],[nMB,nMH,nMB,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(46),m3h3x24(:,118),heltab2x72(:,:,118))
  call Hloop_A_Q(ntryL,G0H24(46),16,nMB,G1H24(73),n2h24(17))
  Gcoeff(:)%j = (c(78)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(119),h0tab(:,119),[16,1,2,8,4],[nMB,nMZ,nMB,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(46),m3h3x24(:,119),heltab2x72(:,:,119))
  call Hloop_A_Q(ntryL,G0H24(46),16,nMB,G1H24(74),n2h24(18))
  Gcoeff(:)%j = (c(77)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(120),h0tab(:,120),[16,1,2,8,4],[nMH,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(75),m3h3x24(:,120),heltab2x72(:,:,120))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(121),h0tab(:,121),[16,1,2,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(76),m3h3x24(:,121),heltab2x72(:,:,121))
  Gcoeff(:)%j = (c(77)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(122),h0tab(:,122),[16,1,2,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(77),m3h3x24(:,122),heltab2x72(:,:,122))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(123),h0tab(:,123),[16,1,2,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(78),m3h3x24(:,123),heltab2x72(:,:,123))
  Gcoeff(:)%j = (c(177)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(124),h0tab(:,124),[16,1,2,8,4],[nMB,0,nMB,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(46),m3h3x24(:,124),heltab2x72(:,:,124))
  call Hloop_A_Q(ntryL,G0H24(46),16,nMB,G1H24(79),n2h24(19))
  Gcoeff(:)%j = (c(185)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(125),h0tab(:,125),[16,1,2,8,4],[nMB,nMZ,nMB,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(46),m3h3x24(:,125),heltab2x72(:,:,125))
  call Hloop_A_Q(ntryL,G0H24(46),16,nMB,G1H24(80),n2h24(20))
  Gcoeff(:)%j = (c(192)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(126),h0tab(:,126),[16,1,2,8,4],[nMB,0,nMB,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(46),m3h3x24(:,126),heltab2x72(:,:,126))
  call Hloop_A_Q(ntryL,G0H24(46),16,nMB,G1H24(81),n2h24(21))
  Gcoeff(:)%j = (c(53)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(127),h0tab(:,127),[16,1,2,8,4],[nMH,nMB,nMH,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(46),m3h3x24(:,127),heltab2x72(:,:,127))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(128),h0tab(:,128),[16,1,2,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(47),m3h3x24(:,128),heltab2x72(:,:,128))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(129),h0tab(:,129),[16,1,2,8,4],[nMH,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(82),m3h3x24(:,129),heltab2x72(:,:,129))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(130),h0tab(:,130),[16,1,2,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(83),m3h3x24(:,130),heltab2x72(:,:,130))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(131),h0tab(:,131),[16,1,2,8,4],[nMH,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(84),m3h3x24(:,131),heltab2x72(:,:,131))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(132),h0tab(:,132),[16,1,2,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(85),m3h3x24(:,132),heltab2x72(:,:,132))
  Gcoeff(:)%j = (-(c(258)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(133),h0tab(:,133),[16,1,2,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(86),m3h3x24(:,133),heltab2x72(:,:,133))
  Gcoeff(:)%j = (-(c(258)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(134),h0tab(:,134),[16,1,2,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(87),m3h3x24(:,134),heltab2x72(:,:,134))
  Gcoeff(:)%j = (c(197)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(135),h0tab(:,135),[16,1,2,8,4],[0,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(48),m3h3x24(:,135),heltab2x72(:,:,135))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(136),h0tab(:,136),[16,1,2,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(49),m3h3x24(:,136),heltab2x72(:,:,136))
  Gcoeff(:)%j = (c(258)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(137),h0tab(:,137),[16,1,2,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(50),m3h3x24(:,137),heltab2x72(:,:,137))
  Gcoeff(:)%j = (-(c(258)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(138),h0tab(:,138),[16,1,2,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(51),m3h3x24(:,138),heltab2x72(:,:,138))
  Gcoeff(:)%j = (c(54)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(139),h0tab(:,139),[16,1,2,8,4],[nMH,nMB,nMH,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(52),m3h3x24(:,139),heltab2x72(:,:,139))
  Gcoeff(:)%j = (-(c(238)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(140),h0tab(:,140),[16,1,2,8,4],[nMH,nMB,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(53),m3h3x24(:,140),heltab2x72(:,:,140))
  Gcoeff(:)%j = (-(c(273)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(141),h0tab(:,141),[16,1,2,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(54),m3h3x24(:,141),heltab2x72(:,:,141))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(142),h0tab(:,142),[16,1,2,8,4],[nMH,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(88),m3h3x24(:,142),heltab2x72(:,:,142))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(143),h0tab(:,143),[16,1,2,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(89),m3h3x24(:,143),heltab2x72(:,:,143))
  Gcoeff(:)%j = (c(154)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(144),h0tab(:,144),[16,1,2,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(90),m3h3x24(:,144),heltab2x72(:,:,144))
  Gcoeff(:)%j = (c(154)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(145),h0tab(:,145),[16,1,2,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(91),m3h3x24(:,145),heltab2x72(:,:,145))
  Gcoeff(:)%j = (c(197)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(146),h0tab(:,146),[16,1,2,8,4],[0,nMB,nMH,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(92),m3h3x24(:,146),heltab2x72(:,:,146))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(147),h0tab(:,147),[16,1,2,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(93),m3h3x24(:,147),heltab2x72(:,:,147))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(148),h0tab(:,148),[16,1,2,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(94),m3h3x24(:,148),heltab2x72(:,:,148))
  Gcoeff(:)%j = (c(154)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(149),h0tab(:,149),[16,1,2,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(95),m3h3x24(:,149),heltab2x72(:,:,149))
  Gcoeff(:)%j = (-(c(238)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(150),h0tab(:,150),[16,1,2,8,4],[0,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(55),m3h3x24(:,150),heltab2x72(:,:,150))
  Gcoeff(:)%j = (-(c(273)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(151),h0tab(:,151),[16,1,2,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(56),m3h3x24(:,151),heltab2x72(:,:,151))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(152),h0tab(:,152),[16,1,2,8,4],[0,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(57),m3h3x24(:,152),heltab2x72(:,:,152))
  Gcoeff(:)%j = (-(c(280)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(153),h0tab(:,153),[16,1,2,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(58),m3h3x24(:,153),heltab2x72(:,:,153))
  Gcoeff(:)%j = (-(c(280)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(154),h0tab(:,154),[16,1,2,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(59),m3h3x24(:,154),heltab2x72(:,:,154))
  Gcoeff(:)%j = (-(c(288)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(155),h0tab(:,155),[16,1,2,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(60),m3h3x24(:,155),heltab2x72(:,:,155))
  Gcoeff(:)%j = (c(198)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(156),h0tab(:,156),[16,1,2,8,4],[nMH,nMB,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(61),m3h3x24(:,156),heltab2x72(:,:,156))
  Gcoeff(:)%j = (-(c(155)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(157),h0tab(:,157),[16,1,2,8,4],[nMH,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(62),m3h3x24(:,157),heltab2x72(:,:,157))
  Gcoeff(:)%j = (c(198)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(158),h0tab(:,158),[16,1,2,8,4],[0,nMB,nMH,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(96),m3h3x24(:,158),heltab2x72(:,:,158))
  Gcoeff(:)%j = (-(c(155)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(159),h0tab(:,159),[16,1,2,8,4],[nMZ,nMB,nMH,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(97),m3h3x24(:,159),heltab2x72(:,:,159))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(160),h0tab(:,160),[16,1,2,8,4],[0,nMB,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(98),m3h3x24(:,160),heltab2x72(:,:,160))
  Gcoeff(:)%j = (-(c(280)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(161),h0tab(:,161),[16,1,2,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(99),m3h3x24(:,161),heltab2x72(:,:,161))
  Gcoeff(:)%j = (c(270)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(162),h0tab(:,162),[16,1,2,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(100),m3h3x24(:,162),heltab2x72(:,:,162))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(163),h0tab(:,163),[16,1,2,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(101),m3h3x24(:,163),heltab2x72(:,:,163))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(164),h0tab(:,164),[16,1,2,8,4],[0,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(63),m3h3x24(:,164),heltab2x72(:,:,164))
  Gcoeff(:)%j = (c(270)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(165),h0tab(:,165),[16,1,2,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(64),m3h3x24(:,165),heltab2x72(:,:,165))
  Gcoeff(:)%j = (-(c(280)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(166),h0tab(:,166),[16,1,2,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(65),m3h3x24(:,166),heltab2x72(:,:,166))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(167),h0tab(:,167),[16,1,2,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(66),m3h3x24(:,167),heltab2x72(:,:,167))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(168),h0tab(:,168),[16,1,2,8,4],[0,nMB,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(102),m3h3x24(:,168),heltab2x72(:,:,168))
  Gcoeff(:)%j = (-(c(253)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(169),h0tab(:,169),[16,1,2,8,4],[0,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(103),m3h3x24(:,169),heltab2x72(:,:,169))
  Gcoeff(:)%j = (-(c(253)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(170),h0tab(:,170),[16,1,2,8,4],[nMZ,nMB,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(104),m3h3x24(:,170),heltab2x72(:,:,170))
  Gcoeff(:)%j = (c(190)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(171),h0tab(:,171),[16,1,2,8,4],[nMZ,nMB,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(105),m3h3x24(:,171),heltab2x72(:,:,171))
  Gcoeff(:)%j = (c(69)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(172),h0tab(:,172),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(67),m3h3x24(:,172),heltab2x72(:,:,172))
  call Hloop_Q_A(ntryL,G0H24(67),16,nMT,G1H24(106),n2h24(22))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(173),h0tab(:,173),[16,2,4,1,8],[nMH,nMB,nMB,nMH,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(107),m3h3x24(:,173),heltab2x72(:,:,173))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(174),h0tab(:,174),[16,2,4,1,8],[nMZ,nMB,nMB,nMH,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(108),m3h3x24(:,174),heltab2x72(:,:,174))
  Gcoeff(:)%j = (c(75)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(175),h0tab(:,175),[16,2,4,1,8],[nMH,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(109),m3h3x24(:,175),heltab2x72(:,:,175))
  Gcoeff(:)%j = (c(75)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(176),h0tab(:,176),[16,2,4,1,8],[nMZ,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(110),m3h3x24(:,176),heltab2x72(:,:,176))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(177),h0tab(:,177),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(67),m3h3x24(:,177),heltab2x72(:,:,177))
  call Hloop_Q_A(ntryL,G0H24(67),16,nMT,G1H24(111),n2h24(23))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(178),h0tab(:,178),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(67),m3h3x24(:,178),heltab2x72(:,:,178))
  call Hloop_Q_A(ntryL,G0H24(67),16,nMT,G1H24(112),n2h24(24))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(179),h0tab(:,179),[16,2,4,1,8],[nMH,nMB,nMB,nMH,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(67),m3h3x24(:,179),heltab2x72(:,:,179))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(180),h0tab(:,180),[16,2,4,1,8],[0,nMB,nMB,nMH,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(68),m3h3x24(:,180),heltab2x72(:,:,180))
  Gcoeff(:)%j = (c(195)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(181),h0tab(:,181),[16,2,4,1,8],[0,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(69),m3h3x24(:,181),heltab2x72(:,:,181))
  Gcoeff(:)%j = (-(c(257)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(182),h0tab(:,182),[16,2,4,1,8],[nMZ,nMB,nMB,nMH,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(70),m3h3x24(:,182),heltab2x72(:,:,182))
  Gcoeff(:)%j = (c(257)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(183),h0tab(:,183),[16,2,4,1,8],[nMZ,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(71),m3h3x24(:,183),heltab2x72(:,:,183))
  Gcoeff(:)%j = (c(195)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(184),h0tab(:,184),[16,2,4,1,8],[nMH,nMB,nMB,0,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(113),m3h3x24(:,184),heltab2x72(:,:,184))
  Gcoeff(:)%j = (c(195)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(185),h0tab(:,185),[16,2,4,1,8],[nMZ,nMB,nMB,0,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(114),m3h3x24(:,185),heltab2x72(:,:,185))
  Gcoeff(:)%j = (c(257)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(186),h0tab(:,186),[16,2,4,1,8],[nMH,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(115),m3h3x24(:,186),heltab2x72(:,:,186))
  Gcoeff(:)%j = (c(257)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(187),h0tab(:,187),[16,2,4,1,8],[nMZ,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(116),m3h3x24(:,187),heltab2x72(:,:,187))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(188),h0tab(:,188),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(72),m3h3x24(:,188),heltab2x72(:,:,188))
  call Hloop_Q_A(ntryL,G0H24(72),16,nMT,G1H24(117),n2h24(25))
  Gcoeff(:)%j = (-(c(196)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(189),h0tab(:,189),[16,2,4,1,8],[0,nMB,nMB,nMH,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(118),m3h3x24(:,189),heltab2x72(:,:,189))
  Gcoeff(:)%j = (c(153)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(190),h0tab(:,190),[16,2,4,1,8],[nMZ,nMB,nMB,nMH,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(119),m3h3x24(:,190),heltab2x72(:,:,190))
  Gcoeff(:)%j = (-(c(196)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(191),h0tab(:,191),[16,2,4,1,8],[nMH,nMB,nMB,0,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(72),m3h3x24(:,191),heltab2x72(:,:,191))
  Gcoeff(:)%j = (c(153)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(192),h0tab(:,192),[16,2,4,1,8],[nMH,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(73),m3h3x24(:,192),heltab2x72(:,:,192))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(193),h0tab(:,193),[16,2,4,1,8],[0,nMB,nMB,0,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(74),m3h3x24(:,193),heltab2x72(:,:,193))
  Gcoeff(:)%j = (c(279)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(194),h0tab(:,194),[16,2,4,1,8],[nMZ,nMB,nMB,0,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(75),m3h3x24(:,194),heltab2x72(:,:,194))
  Gcoeff(:)%j = (c(279)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(195),h0tab(:,195),[16,2,4,1,8],[0,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(76),m3h3x24(:,195),heltab2x72(:,:,195))
  Gcoeff(:)%j = (c(286)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(196),h0tab(:,196),[16,2,4,1,8],[nMZ,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(77),m3h3x24(:,196),heltab2x72(:,:,196))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(197),h0tab(:,197),[16,2,4,1,8],[0,nMB,nMB,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(120),m3h3x24(:,197),heltab2x72(:,:,197))
  Gcoeff(:)%j = (c(252)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(198),h0tab(:,198),[16,2,4,1,8],[nMZ,nMB,nMB,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(121),m3h3x24(:,198),heltab2x72(:,:,198))
  Gcoeff(:)%j = (c(252)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(199),h0tab(:,199),[16,2,4,1,8],[0,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(122),m3h3x24(:,199),heltab2x72(:,:,199))
  Gcoeff(:)%j = (-(c(189)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(200),h0tab(:,200),[16,2,4,1,8],[nMZ,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(123),m3h3x24(:,200),heltab2x72(:,:,200))
  Gcoeff(:)%j = (c(70)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(201),h0tab(:,201),[16,2,8,1,4],[nMT,nMW,nMH,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(78),m3h3x24(:,201),heltab2x72(:,:,201))
  call Hloop_Q_A(ntryL,G0H24(78),16,nMT,G1H24(124),n2h24(26))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(202),h0tab(:,202),[16,2,8,1,4],[nMT,nMW,nMZ,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(78),m3h3x24(:,202),heltab2x72(:,:,202))
  call Hloop_Q_A(ntryL,G0H24(78),16,nMT,G1H24(125),n2h24(27))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(203),h0tab(:,203),[16,2,8,1,4],[nMH,nMB,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(126),m3h3x24(:,203),heltab2x72(:,:,203))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(204),h0tab(:,204),[16,2,8,1,4],[nMZ,nMB,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(127),m3h3x24(:,204),heltab2x72(:,:,204))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(205),h0tab(:,205),[16,2,8,1,4],[nMT,nMW,nMH,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(78),m3h3x24(:,205),heltab2x72(:,:,205))
  call Hloop_Q_A(ntryL,G0H24(78),16,nMT,G1H24(128),n2h24(28))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(206),h0tab(:,206),[16,2,8,1,4],[nMT,nMW,0,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(78),m3h3x24(:,206),heltab2x72(:,:,206))
  call Hloop_Q_A(ntryL,G0H24(78),16,nMT,G1H24(129),n2h24(29))
  Gcoeff(:)%j = (-(c(247)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(207),h0tab(:,207),[16,2,8,1,4],[nMT,nMW,nMZ,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(78),m3h3x24(:,207),heltab2x72(:,:,207))
  call Hloop_Q_A(ntryL,G0H24(78),16,nMT,G1H24(130),n2h24(30))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(208),h0tab(:,208),[16,2,8,1,4],[nMH,nMB,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(78),m3h3x24(:,208),heltab2x72(:,:,208))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(209),h0tab(:,209),[16,2,8,1,4],[0,nMB,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(79),m3h3x24(:,209),heltab2x72(:,:,209))
  Gcoeff(:)%j = (-(c(250)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(210),h0tab(:,210),[16,2,8,1,4],[nMZ,nMB,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(80),m3h3x24(:,210),heltab2x72(:,:,210))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(211),h0tab(:,211),[16,2,8,1,4],[nMH,nMB,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(131),m3h3x24(:,211),heltab2x72(:,:,211))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(212),h0tab(:,212),[16,2,8,1,4],[nMZ,nMB,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(132),m3h3x24(:,212),heltab2x72(:,:,212))
  Gcoeff(:)%j = (c(178)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(213),h0tab(:,213),[16,2,8,1,4],[nMT,nMW,0,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(81),m3h3x24(:,213),heltab2x72(:,:,213))
  call Hloop_Q_A(ntryL,G0H24(81),16,nMT,G1H24(133),n2h24(31))
  Gcoeff(:)%j = (-(c(141)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(214),h0tab(:,214),[16,2,8,1,4],[nMT,nMW,nMZ,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H72(1),ex5(:),G0H24(81),m3h3x24(:,214),heltab2x72(:,:,214))
  call Hloop_Q_A(ntryL,G0H24(81),16,nMT,G1H24(134),n2h24(32))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(215),h0tab(:,215),[16,2,8,1,4],[0,nMB,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(135),m3h3x24(:,215),heltab2x72(:,:,215))
  Gcoeff(:)%j = (c(144)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(216),h0tab(:,216),[16,2,8,1,4],[nMZ,nMB,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(136),m3h3x24(:,216),heltab2x72(:,:,216))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(217),h0tab(:,217),[16,2,8,1,4],[nMH,nMB,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(81),m3h3x24(:,217),heltab2x72(:,:,217))
  Gcoeff(:)%j = (c(231)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(218),h0tab(:,218),[16,2,8,1,4],[0,nMB,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(82),m3h3x24(:,218),heltab2x72(:,:,218))
  Gcoeff(:)%j = (c(268)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(219),h0tab(:,219),[16,2,8,1,4],[nMZ,nMB,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(83),m3h3x24(:,219),heltab2x72(:,:,219))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(220),h0tab(:,220),[16,2,8,1,4],[0,nMB,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(137),m3h3x24(:,220),heltab2x72(:,:,220))
  Gcoeff(:)%j = (c(144)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(221),h0tab(:,221),[16,2,8,1,4],[nMZ,nMB,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(138),m3h3x24(:,221),heltab2x72(:,:,221))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(222),h0tab(:,222),[16,1,4,2,8],[nMH,nMB,nMB,nMH,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(139),m3h3x24(:,222),heltab2x72(:,:,222))
  Gcoeff(:)%j = (c(75)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(223),h0tab(:,223),[16,1,4,2,8],[nMH,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(140),m3h3x24(:,223),heltab2x72(:,:,223))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(224),h0tab(:,224),[16,1,4,2,8],[nMZ,nMB,nMB,nMH,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(141),m3h3x24(:,224),heltab2x72(:,:,224))
  Gcoeff(:)%j = (c(75)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(225),h0tab(:,225),[16,1,4,2,8],[nMZ,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(142),m3h3x24(:,225),heltab2x72(:,:,225))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(226),h0tab(:,226),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(143),m3h3x24(:,226),heltab2x72(:,:,226))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(227),h0tab(:,227),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(144),m3h3x24(:,227),heltab2x72(:,:,227))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(228),h0tab(:,228),[16,1,4,2,8],[nMW,nMT,nMT,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(84),m3h3x24(:,228),heltab2x72(:,:,228))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(229),h0tab(:,229),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(85),m3h3x24(:,229),heltab2x72(:,:,229))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(230),h0tab(:,230),[16,1,4,2,8],[nMH,nMB,nMB,nMH,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(86),m3h3x24(:,230),heltab2x72(:,:,230))
  Gcoeff(:)%j = (c(195)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(231),h0tab(:,231),[16,1,4,2,8],[nMH,nMB,nMB,0,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(145),m3h3x24(:,231),heltab2x72(:,:,231))
  Gcoeff(:)%j = (c(195)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(232),h0tab(:,232),[16,1,4,2,8],[nMZ,nMB,nMB,0,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(146),m3h3x24(:,232),heltab2x72(:,:,232))
  Gcoeff(:)%j = (c(257)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(233),h0tab(:,233),[16,1,4,2,8],[nMH,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(147),m3h3x24(:,233),heltab2x72(:,:,233))
  Gcoeff(:)%j = (c(257)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(234),h0tab(:,234),[16,1,4,2,8],[nMZ,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H72(1),0,ex5(:),16,G1H24(148),m3h3x24(:,234),heltab2x72(:,:,234))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(235),h0tab(:,235),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(149),m3h3x24(:,235),heltab2x72(:,:,235))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(236),h0tab(:,236),[16,1,4,2,8],[0,nMB,nMB,nMH,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(87),m3h3x24(:,236),heltab2x72(:,:,236))
  Gcoeff(:)%j = (c(195)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(237),h0tab(:,237),[16,1,4,2,8],[0,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(88),m3h3x24(:,237),heltab2x72(:,:,237))
  Gcoeff(:)%j = (-(c(257)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(238),h0tab(:,238),[16,1,4,2,8],[nMZ,nMB,nMB,nMH,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(89),m3h3x24(:,238),heltab2x72(:,:,238))
  Gcoeff(:)%j = (c(257)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(239),h0tab(:,239),[16,1,4,2,8],[nMZ,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(90),m3h3x24(:,239),heltab2x72(:,:,239))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(240),h0tab(:,240),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(91),m3h3x24(:,240),heltab2x72(:,:,240))
  Gcoeff(:)%j = (-(c(196)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(241),h0tab(:,241),[16,1,4,2,8],[nMH,nMB,nMB,0,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(92),m3h3x24(:,241),heltab2x72(:,:,241))
  Gcoeff(:)%j = (c(185)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(242),h0tab(:,242),[16,1,4,2,8],[nMW,nMT,nMT,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(93),m3h3x24(:,242),heltab2x72(:,:,242))
  Gcoeff(:)%j = (c(153)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(243),h0tab(:,243),[16,1,4,2,8],[nMH,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(94),m3h3x24(:,243),heltab2x72(:,:,243))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(244),h0tab(:,244),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(95),m3h3x24(:,244),heltab2x72(:,:,244))
  Gcoeff(:)%j = (-(c(196)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(245),h0tab(:,245),[16,1,4,2,8],[0,nMB,nMB,nMH,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(150),m3h3x24(:,245),heltab2x72(:,:,245))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(246),h0tab(:,246),[16,1,4,2,8],[nMW,nMT,nMT,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(151),m3h3x24(:,246),heltab2x72(:,:,246))
  Gcoeff(:)%j = (c(153)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(247),h0tab(:,247),[16,1,4,2,8],[nMZ,nMB,nMB,nMH,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(152),m3h3x24(:,247),heltab2x72(:,:,247))
  Gcoeff(:)%j = (c(185)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(248),h0tab(:,248),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(153),m3h3x24(:,248),heltab2x72(:,:,248))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(249),h0tab(:,249),[16,1,4,2,8],[0,nMB,nMB,0,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(96),m3h3x24(:,249),heltab2x72(:,:,249))
  Gcoeff(:)%j = (c(279)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(250),h0tab(:,250),[16,1,4,2,8],[0,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(97),m3h3x24(:,250),heltab2x72(:,:,250))
  Gcoeff(:)%j = (c(279)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(251),h0tab(:,251),[16,1,4,2,8],[nMZ,nMB,nMB,0,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(98),m3h3x24(:,251),heltab2x72(:,:,251))
  Gcoeff(:)%j = (c(286)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(252),h0tab(:,252),[16,1,4,2,8],[nMZ,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(99),m3h3x24(:,252),heltab2x72(:,:,252))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(253),h0tab(:,253),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(100),m3h3x24(:,253),heltab2x72(:,:,253))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(254),h0tab(:,254),[16,1,4,2,8],[0,nMB,nMB,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(154),m3h3x24(:,254),heltab2x72(:,:,254))
  Gcoeff(:)%j = (c(252)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(255),h0tab(:,255),[16,1,4,2,8],[0,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(155),m3h3x24(:,255),heltab2x72(:,:,255))
  Gcoeff(:)%j = (c(252)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(256),h0tab(:,256),[16,1,4,2,8],[nMZ,nMB,nMB,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(156),m3h3x24(:,256),heltab2x72(:,:,256))
  Gcoeff(:)%j = (-(c(189)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(257),h0tab(:,257),[16,1,4,2,8],[nMZ,nMB,nMB,nMZ,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H72(1),0,ex5(:),16,G1H24(157),m3h3x24(:,257),heltab2x72(:,:,257))
  Gcoeff(:)%j = (c(185)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(258),h0tab(:,258),[16,1,4,2,8],[nMW,nMT,nMT,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(158),m3h3x24(:,258),heltab2x72(:,:,258))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(259),h0tab(:,259),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(159),m3h3x24(:,259),heltab2x72(:,:,259))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(260),h0tab(:,260),[16,1,4,8,2],[nMW,nMT,nMT,nMB,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(160),m3h3x24(:,260),heltab2x72(:,:,260))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(261),h0tab(:,261),[16,1,4,8,2],[nMW,nMT,nMT,nMB,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(161),m3h3x24(:,261),heltab2x72(:,:,261))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(262),h0tab(:,262),[16,1,4,8,2],[nMW,nMT,nMT,nMB,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(101),m3h3x24(:,262),heltab2x72(:,:,262))
  Gcoeff(:)%j = (-(c(249)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(263),h0tab(:,263),[16,1,4,8,2],[nMW,nMT,nMT,nMB,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(102),m3h3x24(:,263),heltab2x72(:,:,263))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(264),h0tab(:,264),[16,1,4,8,2],[nMW,nMT,nMT,nMB,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(103),m3h3x24(:,264),heltab2x72(:,:,264))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(265),h0tab(:,265),[16,1,4,8,2],[nMW,nMT,nMT,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(162),m3h3x24(:,265),heltab2x72(:,:,265))
  Gcoeff(:)%j = (c(143)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(266),h0tab(:,266),[16,1,4,8,2],[nMW,nMT,nMT,nMB,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(163),m3h3x24(:,266),heltab2x72(:,:,266))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(267),h0tab(:,267),[16,1,8,2,4],[nMB,nMH,nMW,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(104),m3h3x24(:,267),heltab2x72(:,:,267))
  call Hloop_A_Q(ntryL,G0H24(104),16,nMB,G1H24(164),n2h24(33))
  Gcoeff(:)%j = (c(71)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(268),h0tab(:,268),[16,1,8,2,4],[nMB,nMZ,nMW,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(104),m3h3x24(:,268),heltab2x72(:,:,268))
  call Hloop_A_Q(ntryL,G0H24(104),16,nMB,G1H24(165),n2h24(34))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(269),h0tab(:,269),[16,1,8,2,4],[nMB,nMH,nMW,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(104),m3h3x24(:,269),heltab2x72(:,:,269))
  call Hloop_A_Q(ntryL,G0H24(104),16,nMB,G1H24(166),n2h24(35))
  Gcoeff(:)%j = (c(181)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(270),h0tab(:,270),[16,1,8,2,4],[nMB,0,nMW,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(104),m3h3x24(:,270),heltab2x72(:,:,270))
  call Hloop_A_Q(ntryL,G0H24(104),16,nMB,G1H24(167),n2h24(36))
  Gcoeff(:)%j = (c(249)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(271),h0tab(:,271),[16,1,8,2,4],[nMB,nMZ,nMW,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(104),m3h3x24(:,271),heltab2x72(:,:,271))
  call Hloop_A_Q(ntryL,G0H24(104),16,nMB,G1H24(168),n2h24(37))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(272),h0tab(:,272),[16,1,8,2,4],[nMB,0,nMW,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(104),m3h3x24(:,272),heltab2x72(:,:,272))
  call Hloop_A_Q(ntryL,G0H24(104),16,nMB,G1H24(169),n2h24(38))
  Gcoeff(:)%j = (c(143)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(273),h0tab(:,273),[16,1,8,2,4],[nMB,nMZ,nMW,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(104),m3h3x24(:,273),heltab2x72(:,:,273))
  call Hloop_A_Q(ntryL,G0H24(104),16,nMB,G1H24(170),n2h24(39))
  Gcoeff(:)%j = (c(70)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(274),h0tab(:,274),[16,1,8,4,2],[nMW,nMT,nMB,nMB,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(171),m3h3x24(:,274),heltab2x72(:,:,274))
  Gcoeff(:)%j = (c(70)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(275),h0tab(:,275),[16,1,8,4,2],[nMW,nMT,nMB,nMB,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H72(1),0,ex5(:),16,G1H24(172),m3h3x24(:,275),heltab2x72(:,:,275))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(276),h0tab(:,276),[16,1,8,4,2],[nMB,nMH,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(104),m3h3x24(:,276),heltab2x72(:,:,276))
  call Hloop_A_Q(ntryL,G0H24(104),16,nMB,G1H24(173),n2h24(40))
  Gcoeff(:)%j = (c(72)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(277),h0tab(:,277),[16,1,8,4,2],[nMB,nMZ,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(104),m3h3x24(:,277),heltab2x72(:,:,277))
  call Hloop_A_Q(ntryL,G0H24(104),16,nMB,G1H24(174),n2h24(41))
  Gcoeff(:)%j = (c(178)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(278),h0tab(:,278),[16,1,8,4,2],[nMW,nMT,nMB,nMB,0],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(104),m3h3x24(:,278),heltab2x72(:,:,278))
  Gcoeff(:)%j = (c(247)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(279),h0tab(:,279),[16,1,8,4,2],[nMW,nMT,nMB,nMB,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H72(1),ex5(:),G0H24(105),m3h3x24(:,279),heltab2x72(:,:,279))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(280),h0tab(:,280),[16,1,8,4,2],[nMW,nMT,nMB,nMB,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H72(1),ex5(:),G0H24(106),m3h3x24(:,280),heltab2x72(:,:,280))
  Gcoeff(:)%j = (c(41)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(281),h0tab(:,281),[16,1,8,4,2],[nMB,nMH,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,281),heltab2x72(:,:,281))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(175),n2h24(42))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(282),h0tab(:,282),[16,1,8,4,2],[nMB,nMH,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,282),heltab2x72(:,:,282))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(176),n2h24(43))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(283),h0tab(:,283),[16,1,8,4,2],[nMB,nMZ,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,283),heltab2x72(:,:,283))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(177),n2h24(44))
  Gcoeff(:)%j = (c(183)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(284),h0tab(:,284),[16,1,8,4,2],[nMB,0,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,284),heltab2x72(:,:,284))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(178),n2h24(45))
  Gcoeff(:)%j = (c(250)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(285),h0tab(:,285),[16,1,8,4,2],[nMB,nMZ,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,285),heltab2x72(:,:,285))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(179),n2h24(46))
  Gcoeff(:)%j = (c(178)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(286),h0tab(:,286),[16,1,8,4,2],[nMW,nMT,nMB,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(180),m3h3x24(:,286),heltab2x72(:,:,286))
  Gcoeff(:)%j = (-(c(141)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(287),h0tab(:,287),[16,1,8,4,2],[nMW,nMT,nMB,nMB,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H24(181),m3h3x24(:,287),heltab2x72(:,:,287))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(288),h0tab(:,288),[16,1,8,4,2],[nMB,nMH,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,288),heltab2x72(:,:,288))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(182),n2h24(47))
  Gcoeff(:)%j = (c(183)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(289),h0tab(:,289),[16,1,8,4,2],[nMB,0,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,289),heltab2x72(:,:,289))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(183),n2h24(48))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(290),h0tab(:,290),[16,1,8,4,2],[nMB,nMZ,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,290),heltab2x72(:,:,290))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(184),n2h24(49))
  Gcoeff(:)%j = (c(231)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(291),h0tab(:,291),[16,1,8,4,2],[nMB,0,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,291),heltab2x72(:,:,291))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(185),n2h24(50))
  Gcoeff(:)%j = (c(268)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(292),h0tab(:,292),[16,1,8,4,2],[nMB,nMZ,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,292),heltab2x72(:,:,292))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(186),n2h24(51))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(293),h0tab(:,293),[16,1,8,4,2],[nMB,0,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,293),heltab2x72(:,:,293))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(187),n2h24(52))
  Gcoeff(:)%j = (c(144)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(294),h0tab(:,294),[16,1,8,4,2],[nMB,nMZ,nMW,nMW,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H72(1),ex5(:),G0H24(107),m3h3x24(:,294),heltab2x72(:,:,294))
  call Hloop_A_Q(ntryL,G0H24(107),16,nMB,G1H24(188),n2h24(53))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(7),[G1H24(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(60),[G1H24(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(81),[G1H24(79)])
  call Hloop_AV_Q(ntryL,G1H24(1),ex3(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(1),n2h12(1))
  call Hloop_AV_Q(ntryL,G1H24(2),ex3(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(2),n2h12(2))
  call Hloop_SV_T(ntryL,G1H24(3),16,ex3(:),4,G2H12(3),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_SV_T(ntryL,G1H24(4),16,ex3(:),4,G2H12(4),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_AV_Q(ntryL,G1H24(7),ex3(:),G1H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(5),n2h12(3))
  call Hloop_AV_Q(ntryL,G1H24(6),ex3(:),G1H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(6),n2h12(4))
  call Hloop_SV_T(ntryL,G0H24(1),16,ex3(:),4,G1H12(1),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_SV_T(ntryL,G0H24(2),16,ex3(:),4,G1H12(2),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_VV_S(ntryL,G0H24(3),ex3(:),G0H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_SV_T(ntryL,G1H24(8),16,ex3(:),4,G2H12(7),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_SV_V(ntryL,G1H24(9),ex3(:),G1H12(3),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_SV_V(ntryL,G1H24(10),ex3(:),G1H12(4),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_VV_S(ntryL,G1H24(11),ex3(:),G1H12(5),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_VV_S(ntryL,G1H24(12),ex3(:),G1H12(6),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_SV_T(ntryL,G0H24(4),16,ex3(:),4,G1H12(7),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_SV_T(ntryL,G0H24(5),16,ex3(:),4,G1H12(8),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_VV_S(ntryL,G0H24(6),ex3(:),G0H12(2),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_SV_V(ntryL,G0H24(7),ex3(:),G0H12(3),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_SV_V(ntryL,G0H24(8),ex3(:),G0H12(4),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_UW_V(ntryL,G0H24(9),16,ex3(:),4,G1H12(9),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_SV_V(ntryL,G1H24(13),ex3(:),G1H12(10),m3h2x12(:,21),heltab2x24(:,:,21))
  call Hloop_VV_S(ntryL,G1H24(14),ex3(:),G1H12(11),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hloop_VV_S(ntryL,G1H24(15),ex3(:),G1H12(12),m3h2x12(:,23),heltab2x24(:,:,23))
  call Hloop_UW_V(ntryL,G1H24(16),16,ex3(:),4,G2H12(8),m3h2x12(:,24),heltab2x24(:,:,24))
  call Hloop_UW_V(ntryL,G1H24(17),16,ex3(:),4,G2H12(9),m3h2x12(:,25),heltab2x24(:,:,25))
  call Hloop_SV_V(ntryL,G0H24(10),ex3(:),G0H12(5),m3h2x12(:,26),heltab2x24(:,:,26))
  call Hloop_SV_V(ntryL,G0H24(11),ex3(:),G0H12(6),m3h2x12(:,27),heltab2x24(:,:,27))
  call Hloop_UW_V(ntryL,G0H24(12),16,ex3(:),4,G1H12(13),m3h2x12(:,28),heltab2x24(:,:,28))
  call Hloop_UW_V(ntryL,G1H24(18),16,ex3(:),4,G2H12(10),m3h2x12(:,29),heltab2x24(:,:,29))
  call Hloop_UW_V(ntryL,G1H24(19),16,ex3(:),4,G2H12(11),m3h2x12(:,30),heltab2x24(:,:,30))
  call Hloop_QA_S(ntryL,G1H24(20),ex2(:),G1H12(14),ngPbt,m3h2x12(:,31),heltab2x24(:,:,31))
  call Hloop_QA_W(ntryL,G1H24(21),ex2(:),G1H12(15),m3h2x12(:,32),heltab2x24(:,:,32))
  call Hloop_QV_A(ntryL,G1H24(22),ex3(:),G1H12(16),m3h2x12(:,33),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G1H12(16),20,nMT,G2H12(12),n2h12(5))
  call Hloop_QV_A(ntryL,G1H24(23),ex3(:),G1H12(16),m3h2x12(:,34),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G1H12(16),20,nMT,G2H12(13),n2h12(6))
  call Hloop_QA_S(ntryL,G1H24(24),ex2(:),G1H12(16),ngPbt,m3h2x12(:,35),heltab2x24(:,:,35))
  call Hloop_SA_Q(ntryL,G1H24(25),ex2(:),G1H12(17),ngH,m3h2x12(:,36),heltab2x24(:,:,36))
  call Hloop_A_Q(ntryL,G1H12(17),18,nMB,G2H12(14),n2h12(7))
  call Hloop_SA_Q(ntryL,G1H24(26),ex2(:),G1H12(17),ngX,m3h2x12(:,37),heltab2x24(:,:,37))
  call Hloop_A_Q(ntryL,G1H12(17),18,nMB,G2H12(15),n2h12(8))
  call Hloop_SA_Q(ntryL,G1H24(27),ex2(:),G1H12(17),ngH,m3h2x12(:,38),heltab2x24(:,:,38))
  call Hloop_A_Q(ntryL,G1H12(17),18,nMB,G2H12(16),n2h12(9))
  call Hloop_SA_Q(ntryL,G1H24(28),ex2(:),G1H12(17),ngX,m3h2x12(:,39),heltab2x24(:,:,39))
  call Hloop_A_Q(ntryL,G1H12(17),18,nMB,G2H12(17),n2h12(10))
  call Hloop_QA_W(ntryL,G1H24(29),ex2(:),G1H12(17),m3h2x12(:,40),heltab2x24(:,:,40))
  call Hloop_SA_Q(ntryL,G0H24(13),ex2(:),G0H12(7),ngH,m3h2x12(:,41),heltab2x24(:,:,41))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(18),n2h12(11))
  call Hloop_SA_Q(ntryL,G0H24(14),ex2(:),G0H12(7),ngH,m3h2x12(:,42),heltab2x24(:,:,42))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(19),n2h12(12))
  call Hloop_SA_Q(ntryL,G1H24(30),ex2(:),G1H12(20),ngH,m3h2x12(:,43),heltab2x24(:,:,43))
  call Hloop_A_Q(ntryL,G1H12(20),18,nMB,G2H12(18),n2h12(13))
  call Hloop_SA_Q(ntryL,G1H24(31),ex2(:),G1H12(20),ngX,m3h2x12(:,44),heltab2x24(:,:,44))
  call Hloop_A_Q(ntryL,G1H12(20),18,nMB,G2H12(19),n2h12(14))
  call Hloop_VA_Q(ntryL,G0H24(15),ex2(:),G0H12(7),m3h2x12(:,45),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(20),n2h12(15))
  call Hloop_VA_Q(ntryL,G0H24(16),ex2(:),G0H12(7),m3h2x12(:,46),heltab2x24(:,:,46))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(21),n2h12(16))
  call Hloop_ZA_Q(ntryL,G0H24(17),ex2(:),G0H12(7),ngZd,m3h2x12(:,47),heltab2x24(:,:,47))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(22),n2h12(17))
  call Hloop_ZA_Q(ntryL,G0H24(18),ex2(:),G0H12(7),ngZd,m3h2x12(:,48),heltab2x24(:,:,48))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(23),n2h12(18))
  call Hloop_SA_Q(ntryL,G1H24(32),ex2(:),G1H12(24),ngH,m3h2x12(:,49),heltab2x24(:,:,49))
  call Hloop_A_Q(ntryL,G1H12(24),18,nMB,G2H12(20),n2h12(19))
  call Hloop_SA_Q(ntryL,G1H24(33),ex2(:),G1H12(24),ngX,m3h2x12(:,50),heltab2x24(:,:,50))
  call Hloop_A_Q(ntryL,G1H12(24),18,nMB,G2H12(21),n2h12(20))
  call Hloop_SA_Q(ntryL,G1H24(34),ex2(:),G1H12(24),ngH,m3h2x12(:,51),heltab2x24(:,:,51))
  call Hloop_A_Q(ntryL,G1H12(24),18,nMB,G2H12(22),n2h12(21))
  call Hloop_SA_Q(ntryL,G1H24(35),ex2(:),G1H12(24),ngX,m3h2x12(:,52),heltab2x24(:,:,52))
  call Hloop_A_Q(ntryL,G1H12(24),18,nMB,G2H12(23),n2h12(22))
  call Hloop_SA_Q(ntryL,G0H24(19),ex2(:),G0H12(7),ngH,m3h2x12(:,53),heltab2x24(:,:,53))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(24),n2h12(23))
  call Hloop_VA_Q(ntryL,G1H24(36),ex2(:),G1H12(25),m3h2x12(:,54),heltab2x24(:,:,54))
  call Hloop_A_Q(ntryL,G1H12(25),18,nMB,G2H12(24),n2h12(24))
  call Hloop_VA_Q(ntryL,G1H24(37),ex2(:),G1H12(25),m3h2x12(:,55),heltab2x24(:,:,55))
  call Hloop_A_Q(ntryL,G1H12(25),18,nMB,G2H12(25),n2h12(25))
  call Hloop_ZA_Q(ntryL,G1H24(38),ex2(:),G1H12(25),ngZd,m3h2x12(:,56),heltab2x24(:,:,56))
  call Hloop_A_Q(ntryL,G1H12(25),18,nMB,G2H12(26),n2h12(26))
  call Hloop_ZA_Q(ntryL,G1H24(39),ex2(:),G1H12(25),ngZd,m3h2x12(:,57),heltab2x24(:,:,57))
  call Hloop_A_Q(ntryL,G1H12(25),18,nMB,G2H12(27),n2h12(27))
  call Hloop_VA_Q(ntryL,G0H24(20),ex2(:),G0H12(7),m3h2x12(:,58),heltab2x24(:,:,58))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(25),n2h12(28))
  call Hloop_ZA_Q(ntryL,G0H24(21),ex2(:),G0H12(7),ngZd,m3h2x12(:,59),heltab2x24(:,:,59))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(26),n2h12(29))
  call Hloop_SA_Q(ntryL,G0H24(22),ex2(:),G0H12(7),ngH,m3h2x12(:,60),heltab2x24(:,:,60))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(27),n2h12(30))
  call Hloop_SA_Q(ntryL,G0H24(23),ex2(:),G0H12(7),ngH,m3h2x12(:,61),heltab2x24(:,:,61))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(28),n2h12(31))
  call Hloop_SA_Q(ntryL,G1H24(40),ex2(:),G1H12(29),ngH,m3h2x12(:,62),heltab2x24(:,:,62))
  call Hloop_A_Q(ntryL,G1H12(29),18,nMB,G2H12(28),n2h12(32))
  call Hloop_SA_Q(ntryL,G1H24(41),ex2(:),G1H12(29),ngX,m3h2x12(:,63),heltab2x24(:,:,63))
  call Hloop_A_Q(ntryL,G1H12(29),18,nMB,G2H12(29),n2h12(33))
  call Hloop_SA_Q(ntryL,G1H24(42),ex2(:),G1H12(29),ngH,m3h2x12(:,64),heltab2x24(:,:,64))
  call Hloop_A_Q(ntryL,G1H12(29),18,nMB,G2H12(30),n2h12(34))
  call Hloop_SA_Q(ntryL,G1H24(43),ex2(:),G1H12(29),ngX,m3h2x12(:,65),heltab2x24(:,:,65))
  call Hloop_A_Q(ntryL,G1H12(29),18,nMB,G2H12(31),n2h12(35))
  call Hloop_VA_Q(ntryL,G0H24(24),ex2(:),G0H12(7),m3h2x12(:,66),heltab2x24(:,:,66))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(29),n2h12(36))
  call Hloop_ZA_Q(ntryL,G0H24(25),ex2(:),G0H12(7),ngZd,m3h2x12(:,67),heltab2x24(:,:,67))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(30),n2h12(37))
  call Hloop_VA_Q(ntryL,G0H24(26),ex2(:),G0H12(7),m3h2x12(:,68),heltab2x24(:,:,68))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(31),n2h12(38))
  call Hloop_ZA_Q(ntryL,G0H24(27),ex2(:),G0H12(7),ngZd,m3h2x12(:,69),heltab2x24(:,:,69))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(32),n2h12(39))
  call Hloop_VA_Q(ntryL,G1H24(44),ex2(:),G1H12(33),m3h2x12(:,70),heltab2x24(:,:,70))
  call Hloop_A_Q(ntryL,G1H12(33),18,nMB,G2H12(32),n2h12(40))
  call Hloop_ZA_Q(ntryL,G1H24(45),ex2(:),G1H12(33),ngZd,m3h2x12(:,71),heltab2x24(:,:,71))
  call Hloop_A_Q(ntryL,G1H12(33),18,nMB,G2H12(33),n2h12(41))
  call Hloop_SA_Q(ntryL,G0H24(28),ex2(:),G0H12(7),ngH,m3h2x12(:,72),heltab2x24(:,:,72))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(33),n2h12(42))
  call Hloop_SA_Q(ntryL,G0H24(29),ex2(:),G0H12(7),ngH,m3h2x12(:,73),heltab2x24(:,:,73))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(34),n2h12(43))
  call Hloop_VA_Q(ntryL,G1H24(46),ex2(:),G1H12(35),m3h2x12(:,74),heltab2x24(:,:,74))
  call Hloop_A_Q(ntryL,G1H12(35),18,nMB,G2H12(34),n2h12(44))
  call Hloop_ZA_Q(ntryL,G1H24(47),ex2(:),G1H12(35),ngZd,m3h2x12(:,75),heltab2x24(:,:,75))
  call Hloop_A_Q(ntryL,G1H12(35),18,nMB,G2H12(35),n2h12(45))
  call Hloop_VA_Q(ntryL,G1H24(48),ex2(:),G1H12(35),m3h2x12(:,76),heltab2x24(:,:,76))
  call Hloop_A_Q(ntryL,G1H12(35),18,nMB,G2H12(36),n2h12(46))
  call Hloop_ZA_Q(ntryL,G1H24(49),ex2(:),G1H12(35),ngZd,m3h2x12(:,77),heltab2x24(:,:,77))
  call Hloop_A_Q(ntryL,G1H12(35),18,nMB,G2H12(37),n2h12(47))
  call Hloop_VA_Q(ntryL,G0H24(30),ex2(:),G0H12(7),m3h2x12(:,78),heltab2x24(:,:,78))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(35),n2h12(48))
  call Hloop_ZA_Q(ntryL,G0H24(31),ex2(:),G0H12(7),ngZd,m3h2x12(:,79),heltab2x24(:,:,79))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(36),n2h12(49))
  call Hloop_VA_Q(ntryL,G0H24(32),ex2(:),G0H12(7),m3h2x12(:,80),heltab2x24(:,:,80))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(37),n2h12(50))
  call Hloop_ZA_Q(ntryL,G0H24(33),ex2(:),G0H12(7),ngZd,m3h2x12(:,81),heltab2x24(:,:,81))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(38),n2h12(51))
  call Hloop_VA_Q(ntryL,G1H24(50),ex2(:),G1H12(39),m3h2x12(:,82),heltab2x24(:,:,82))
  call Hloop_A_Q(ntryL,G1H12(39),18,nMB,G2H12(38),n2h12(52))
  call Hloop_ZA_Q(ntryL,G1H24(51),ex2(:),G1H12(39),ngZd,m3h2x12(:,83),heltab2x24(:,:,83))
  call Hloop_A_Q(ntryL,G1H12(39),18,nMB,G2H12(39),n2h12(53))
  call Hloop_VA_Q(ntryL,G1H24(52),ex2(:),G1H12(39),m3h2x12(:,84),heltab2x24(:,:,84))
  call Hloop_A_Q(ntryL,G1H12(39),18,nMB,G2H12(40),n2h12(54))
  call Hloop_ZA_Q(ntryL,G1H24(53),ex2(:),G1H12(39),ngZd,m3h2x12(:,85),heltab2x24(:,:,85))
  call Hloop_A_Q(ntryL,G1H12(39),18,nMB,G2H12(41),n2h12(55))
  call Hloop_AQ_S(ntryL,G1H24(54),ex1(:),G1H12(39),ngH,m3h2x12(:,86),heltab2x24(:,:,86))
  call Hloop_AQ_S(ntryL,G1H24(55),ex1(:),G1H12(40),ngX,m3h2x12(:,87),heltab2x24(:,:,87))
  call Hloop_SQ_A(ntryL,G1H24(56),ex1(:),G1H12(41),ngPtb,m3h2x12(:,88),heltab2x24(:,:,88))
  call Hloop_Q_A(ntryL,G1H12(41),17,nMT,G2H12(42),n2h12(56))
  call Hloop_SQ_A(ntryL,G1H24(57),ex1(:),G1H12(41),ngPtb,m3h2x12(:,89),heltab2x24(:,:,89))
  call Hloop_Q_A(ntryL,G1H12(41),17,nMT,G2H12(43),n2h12(57))
  call Hloop_AQ_V(ntryL,G1H24(60),ex1(:),G1H12(41),m3h2x12(:,90),heltab2x24(:,:,90))
  call Hloop_AQ_Z(ntryL,G1H24(59),ex1(:),G1H12(42),ngZd,m3h2x12(:,91),heltab2x24(:,:,91))
  call Hloop_SQ_A(ntryL,G0H24(34),ex1(:),G0H12(7),ngPtb,m3h2x12(:,92),heltab2x24(:,:,92))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(43),n2h12(58))
  call Hloop_SQ_A(ntryL,G0H24(35),ex1(:),G0H12(7),ngPtb,m3h2x12(:,93),heltab2x24(:,:,93))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(44),n2h12(59))
  call Hloop_SQ_A(ntryL,G1H24(61),ex1(:),G1H12(45),ngPtb,m3h2x12(:,94),heltab2x24(:,:,94))
  call Hloop_Q_A(ntryL,G1H12(45),17,nMT,G2H12(44),n2h12(60))
  call Hloop_SQ_A(ntryL,G1H24(62),ex1(:),G1H12(45),ngPtb,m3h2x12(:,95),heltab2x24(:,:,95))
  call Hloop_Q_A(ntryL,G1H12(45),17,nMT,G2H12(45),n2h12(61))
  call Hloop_SQ_A(ntryL,G1H24(63),ex1(:),G1H12(45),ngPtb,m3h2x12(:,96),heltab2x24(:,:,96))
  call Hloop_Q_A(ntryL,G1H12(45),17,nMT,G2H12(46),n2h12(62))
  call Hloop_WQ_A(ntryL,G0H24(36),ex1(:),G0H12(7),m3h2x12(:,97),heltab2x24(:,:,97))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(45),n2h12(63))
  call Hloop_SQ_A(ntryL,G0H24(37),ex1(:),G0H12(7),ngPtb,m3h2x12(:,98),heltab2x24(:,:,98))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(46),n2h12(64))
  call Hloop_SQ_A(ntryL,G0H24(38),ex1(:),G0H12(7),ngPtb,m3h2x12(:,99),heltab2x24(:,:,99))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(47),n2h12(65))
  call Hloop_SQ_A(ntryL,G0H24(39),ex1(:),G0H12(7),ngPtb,m3h2x12(:,100),heltab2x24(:,:,100))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(48),n2h12(66))
  call Hloop_SQ_A(ntryL,G0H24(40),ex1(:),G0H12(7),ngPtb,m3h2x12(:,101),heltab2x24(:,:,101))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(49),n2h12(67))
  call Hloop_SQ_A(ntryL,G1H24(64),ex1(:),G1H12(50),ngPtb,m3h2x12(:,102),heltab2x24(:,:,102))
  call Hloop_Q_A(ntryL,G1H12(50),17,nMT,G2H12(47),n2h12(68))
  call Hloop_WQ_A(ntryL,G1H24(65),ex1(:),G1H12(50),m3h2x12(:,103),heltab2x24(:,:,103))
  call Hloop_Q_A(ntryL,G1H12(50),17,nMT,G2H12(48),n2h12(69))
  call Hloop_WQ_A(ntryL,G1H24(66),ex1(:),G1H12(50),m3h2x12(:,104),heltab2x24(:,:,104))
  call Hloop_Q_A(ntryL,G1H12(50),17,nMT,G2H12(49),n2h12(70))
  call Hloop_WQ_A(ntryL,G0H24(41),ex1(:),G0H12(7),m3h2x12(:,105),heltab2x24(:,:,105))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(50),n2h12(71))
  call Hloop_WQ_A(ntryL,G0H24(42),ex1(:),G0H12(7),m3h2x12(:,106),heltab2x24(:,:,106))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(51),n2h12(72))
  call Hloop_SQ_A(ntryL,G0H24(43),ex1(:),G0H12(7),ngPtb,m3h2x12(:,107),heltab2x24(:,:,107))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(52),n2h12(73))
  call Hloop_SQ_A(ntryL,G0H24(44),ex1(:),G0H12(7),ngPtb,m3h2x12(:,108),heltab2x24(:,:,108))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(53),n2h12(74))
  call Hloop_WQ_A(ntryL,G1H24(67),ex1(:),G1H12(54),m3h2x12(:,109),heltab2x24(:,:,109))
  call Hloop_Q_A(ntryL,G1H12(54),17,nMT,G2H12(50),n2h12(75))
  call Hloop_WQ_A(ntryL,G1H24(68),ex1(:),G1H12(54),m3h2x12(:,110),heltab2x24(:,:,110))
  call Hloop_Q_A(ntryL,G1H12(54),17,nMT,G2H12(51),n2h12(76))
  call Hloop_WQ_A(ntryL,G1H24(69),ex1(:),G1H12(54),m3h2x12(:,111),heltab2x24(:,:,111))
  call Hloop_Q_A(ntryL,G1H12(54),17,nMT,G2H12(52),n2h12(77))
  call Hloop_WQ_A(ntryL,G1H24(70),ex1(:),G1H12(54),m3h2x12(:,112),heltab2x24(:,:,112))
  call Hloop_Q_A(ntryL,G1H12(54),17,nMT,G2H12(53),n2h12(78))
  call Hloop_WQ_A(ntryL,G0H24(45),ex1(:),G0H12(7),m3h2x12(:,113),heltab2x24(:,:,113))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(54),n2h12(79))
  call Hloop_WQ_A(ntryL,G1H24(71),ex1(:),G1H12(55),m3h2x12(:,114),heltab2x24(:,:,114))
  call Hloop_Q_A(ntryL,G1H12(55),17,nMT,G2H12(54),n2h12(80))
  call Hloop_WQ_A(ntryL,G1H24(72),ex1(:),G1H12(55),m3h2x12(:,115),heltab2x24(:,:,115))
  call Hloop_Q_A(ntryL,G1H12(55),17,nMT,G2H12(55),n2h12(81))
  call Hloop_AQ_S(ntryL,G1H24(73),ex1(:),G1H12(55),ngH,m3h2x12(:,116),heltab2x24(:,:,116))
  call Hloop_AQ_S(ntryL,G1H24(74),ex1(:),G1H12(56),ngX,m3h2x12(:,117),heltab2x24(:,:,117))
  call Hloop_SQ_A(ntryL,G1H24(75),ex1(:),G1H12(57),ngH,m3h2x12(:,118),heltab2x24(:,:,118))
  call Hloop_Q_A(ntryL,G1H12(57),17,nMB,G2H12(56),n2h12(82))
  call Hloop_SQ_A(ntryL,G1H24(76),ex1(:),G1H12(57),ngH,m3h2x12(:,119),heltab2x24(:,:,119))
  call Hloop_Q_A(ntryL,G1H12(57),17,nMB,G2H12(57),n2h12(83))
  call Hloop_SQ_A(ntryL,G1H24(77),ex1(:),G1H12(57),ngX,m3h2x12(:,120),heltab2x24(:,:,120))
  call Hloop_Q_A(ntryL,G1H12(57),17,nMB,G2H12(58),n2h12(84))
  call Hloop_SQ_A(ntryL,G1H24(78),ex1(:),G1H12(57),ngX,m3h2x12(:,121),heltab2x24(:,:,121))
  call Hloop_Q_A(ntryL,G1H12(57),17,nMB,G2H12(59),n2h12(85))
  call Hloop_AQ_V(ntryL,G1H24(81),ex1(:),G1H12(57),m3h2x12(:,122),heltab2x24(:,:,122))
  call Hloop_AQ_Z(ntryL,G1H24(80),ex1(:),G1H12(58),ngZd,m3h2x12(:,123),heltab2x24(:,:,123))
  call Hloop_SQ_A(ntryL,G0H24(46),ex1(:),G0H12(7),ngH,m3h2x12(:,124),heltab2x24(:,:,124))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(59),n2h12(86))
  call Hloop_SQ_A(ntryL,G0H24(47),ex1(:),G0H12(7),ngH,m3h2x12(:,125),heltab2x24(:,:,125))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(60),n2h12(87))
  call Hloop_SQ_A(ntryL,G1H24(82),ex1(:),G1H12(61),ngH,m3h2x12(:,126),heltab2x24(:,:,126))
  call Hloop_Q_A(ntryL,G1H12(61),17,nMB,G2H12(60),n2h12(88))
  call Hloop_SQ_A(ntryL,G1H24(83),ex1(:),G1H12(61),ngX,m3h2x12(:,127),heltab2x24(:,:,127))
  call Hloop_Q_A(ntryL,G1H12(61),17,nMB,G2H12(61),n2h12(89))
  call Hloop_SQ_A(ntryL,G1H24(84),ex1(:),G1H12(61),ngH,m3h2x12(:,128),heltab2x24(:,:,128))
  call Hloop_Q_A(ntryL,G1H12(61),17,nMB,G2H12(62),n2h12(90))
  call Hloop_SQ_A(ntryL,G1H24(85),ex1(:),G1H12(61),ngX,m3h2x12(:,129),heltab2x24(:,:,129))
  call Hloop_Q_A(ntryL,G1H12(61),17,nMB,G2H12(63),n2h12(91))
  call Hloop_SQ_A(ntryL,G1H24(86),ex1(:),G1H12(61),ngH,m3h2x12(:,130),heltab2x24(:,:,130))
  call Hloop_Q_A(ntryL,G1H12(61),17,nMB,G2H12(64),n2h12(92))
  call Hloop_SQ_A(ntryL,G1H24(87),ex1(:),G1H12(61),ngX,m3h2x12(:,131),heltab2x24(:,:,131))
  call Hloop_Q_A(ntryL,G1H12(61),17,nMB,G2H12(65),n2h12(93))
  call Hloop_VQ_A(ntryL,G0H24(48),ex1(:),G0H12(7),m3h2x12(:,132),heltab2x24(:,:,132))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(61),n2h12(94))
  call Hloop_VQ_A(ntryL,G0H24(49),ex1(:),G0H12(7),m3h2x12(:,133),heltab2x24(:,:,133))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(62),n2h12(95))
  call Hloop_ZQ_A(ntryL,G0H24(50),ex1(:),G0H12(7),ngZd,m3h2x12(:,134),heltab2x24(:,:,134))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(63),n2h12(96))
  call Hloop_ZQ_A(ntryL,G0H24(51),ex1(:),G0H12(7),ngZd,m3h2x12(:,135),heltab2x24(:,:,135))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(64),n2h12(97))
  call Hloop_SQ_A(ntryL,G0H24(52),ex1(:),G0H12(7),ngH,m3h2x12(:,136),heltab2x24(:,:,136))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(65),n2h12(98))
  call Hloop_SQ_A(ntryL,G0H24(53),ex1(:),G0H12(7),ngH,m3h2x12(:,137),heltab2x24(:,:,137))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(66),n2h12(99))
  call Hloop_SQ_A(ntryL,G0H24(54),ex1(:),G0H12(7),ngH,m3h2x12(:,138),heltab2x24(:,:,138))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(67),n2h12(100))
  call Hloop_SQ_A(ntryL,G1H24(88),ex1(:),G1H12(68),ngH,m3h2x12(:,139),heltab2x24(:,:,139))
  call Hloop_Q_A(ntryL,G1H12(68),17,nMB,G2H12(66),n2h12(101))
  call Hloop_SQ_A(ntryL,G1H24(89),ex1(:),G1H12(68),ngX,m3h2x12(:,140),heltab2x24(:,:,140))
  call Hloop_Q_A(ntryL,G1H12(68),17,nMB,G2H12(67),n2h12(102))
  call Hloop_SQ_A(ntryL,G1H24(90),ex1(:),G1H12(68),ngH,m3h2x12(:,141),heltab2x24(:,:,141))
  call Hloop_Q_A(ntryL,G1H12(68),17,nMB,G2H12(68),n2h12(103))
  call Hloop_SQ_A(ntryL,G1H24(91),ex1(:),G1H12(68),ngX,m3h2x12(:,142),heltab2x24(:,:,142))
  call Hloop_Q_A(ntryL,G1H12(68),17,nMB,G2H12(69),n2h12(104))
  call Hloop_VQ_A(ntryL,G1H24(92),ex1(:),G1H12(68),m3h2x12(:,143),heltab2x24(:,:,143))
  call Hloop_Q_A(ntryL,G1H12(68),17,nMB,G2H12(70),n2h12(105))
  call Hloop_VQ_A(ntryL,G1H24(93),ex1(:),G1H12(68),m3h2x12(:,144),heltab2x24(:,:,144))
  call Hloop_Q_A(ntryL,G1H12(68),17,nMB,G2H12(71),n2h12(106))
  call Hloop_ZQ_A(ntryL,G1H24(94),ex1(:),G1H12(68),ngZd,m3h2x12(:,145),heltab2x24(:,:,145))
  call Hloop_Q_A(ntryL,G1H12(68),17,nMB,G2H12(72),n2h12(107))
  call Hloop_ZQ_A(ntryL,G1H24(95),ex1(:),G1H12(68),ngZd,m3h2x12(:,146),heltab2x24(:,:,146))
  call Hloop_Q_A(ntryL,G1H12(68),17,nMB,G2H12(73),n2h12(108))
  call Hloop_VQ_A(ntryL,G0H24(55),ex1(:),G0H12(7),m3h2x12(:,147),heltab2x24(:,:,147))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(68),n2h12(109))
  call Hloop_ZQ_A(ntryL,G0H24(56),ex1(:),G0H12(7),ngZd,m3h2x12(:,148),heltab2x24(:,:,148))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(69),n2h12(110))
  call Hloop_VQ_A(ntryL,G0H24(57),ex1(:),G0H12(7),m3h2x12(:,149),heltab2x24(:,:,149))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(70),n2h12(111))
  call Hloop_VQ_A(ntryL,G0H24(58),ex1(:),G0H12(7),m3h2x12(:,150),heltab2x24(:,:,150))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(71),n2h12(112))
  call Hloop_ZQ_A(ntryL,G0H24(59),ex1(:),G0H12(7),ngZd,m3h2x12(:,151),heltab2x24(:,:,151))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(72),n2h12(113))
  call Hloop_ZQ_A(ntryL,G0H24(60),ex1(:),G0H12(7),ngZd,m3h2x12(:,152),heltab2x24(:,:,152))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(73),n2h12(114))
  call Hloop_SQ_A(ntryL,G0H24(61),ex1(:),G0H12(7),ngH,m3h2x12(:,153),heltab2x24(:,:,153))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(74),n2h12(115))
  call Hloop_SQ_A(ntryL,G0H24(62),ex1(:),G0H12(7),ngH,m3h2x12(:,154),heltab2x24(:,:,154))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(75),n2h12(116))
  call Hloop_VQ_A(ntryL,G1H24(96),ex1(:),G1H12(76),m3h2x12(:,155),heltab2x24(:,:,155))
  call Hloop_Q_A(ntryL,G1H12(76),17,nMB,G2H12(74),n2h12(117))
  call Hloop_ZQ_A(ntryL,G1H24(97),ex1(:),G1H12(76),ngZd,m3h2x12(:,156),heltab2x24(:,:,156))
  call Hloop_Q_A(ntryL,G1H12(76),17,nMB,G2H12(75),n2h12(118))
  call Hloop_VQ_A(ntryL,G1H24(98),ex1(:),G1H12(76),m3h2x12(:,157),heltab2x24(:,:,157))
  call Hloop_Q_A(ntryL,G1H12(76),17,nMB,G2H12(76),n2h12(119))
  call Hloop_VQ_A(ntryL,G1H24(99),ex1(:),G1H12(76),m3h2x12(:,158),heltab2x24(:,:,158))
  call Hloop_Q_A(ntryL,G1H12(76),17,nMB,G2H12(77),n2h12(120))
  call Hloop_ZQ_A(ntryL,G1H24(100),ex1(:),G1H12(76),ngZd,m3h2x12(:,159),heltab2x24(:,:,159))
  call Hloop_Q_A(ntryL,G1H12(76),17,nMB,G2H12(78),n2h12(121))
  call Hloop_ZQ_A(ntryL,G1H24(101),ex1(:),G1H12(76),ngZd,m3h2x12(:,160),heltab2x24(:,:,160))
  call Hloop_Q_A(ntryL,G1H12(76),17,nMB,G2H12(79),n2h12(122))
  call Hloop_VQ_A(ntryL,G0H24(63),ex1(:),G0H12(7),m3h2x12(:,161),heltab2x24(:,:,161))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(76),n2h12(123))
  call Hloop_VQ_A(ntryL,G0H24(64),ex1(:),G0H12(7),m3h2x12(:,162),heltab2x24(:,:,162))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(77),n2h12(124))
  call Hloop_ZQ_A(ntryL,G0H24(65),ex1(:),G0H12(7),ngZd,m3h2x12(:,163),heltab2x24(:,:,163))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(78),n2h12(125))
  call Hloop_ZQ_A(ntryL,G0H24(66),ex1(:),G0H12(7),ngZd,m3h2x12(:,164),heltab2x24(:,:,164))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(79),n2h12(126))
  call Hloop_VQ_A(ntryL,G1H24(102),ex1(:),G1H12(80),m3h2x12(:,165),heltab2x24(:,:,165))
  call Hloop_Q_A(ntryL,G1H12(80),17,nMB,G2H12(80),n2h12(127))
  call Hloop_VQ_A(ntryL,G1H24(103),ex1(:),G1H12(80),m3h2x12(:,166),heltab2x24(:,:,166))
  call Hloop_Q_A(ntryL,G1H12(80),17,nMB,G2H12(81),n2h12(128))
  call Hloop_ZQ_A(ntryL,G1H24(104),ex1(:),G1H12(80),ngZd,m3h2x12(:,167),heltab2x24(:,:,167))
  call Hloop_Q_A(ntryL,G1H12(80),17,nMB,G2H12(82),n2h12(129))
  call Hloop_ZQ_A(ntryL,G1H24(105),ex1(:),G1H12(80),ngZd,m3h2x12(:,168),heltab2x24(:,:,168))
  call Hloop_Q_A(ntryL,G1H12(80),17,nMB,G2H12(83),n2h12(130))
  call Hloop_QA_S(ntryL,G1H24(106),ex2(:),G1H12(80),ngPbt,m3h2x12(:,169),heltab2x24(:,:,169))
  call Hloop_SA_Q(ntryL,G1H24(107),ex2(:),G1H12(81),ngH,m3h2x12(:,170),heltab2x24(:,:,170))
  call Hloop_A_Q(ntryL,G1H12(81),18,nMB,G2H12(84),n2h12(131))
  call Hloop_SA_Q(ntryL,G1H24(108),ex2(:),G1H12(81),ngX,m3h2x12(:,171),heltab2x24(:,:,171))
  call Hloop_A_Q(ntryL,G1H12(81),18,nMB,G2H12(85),n2h12(132))
  call Hloop_SA_Q(ntryL,G1H24(109),ex2(:),G1H12(81),ngH,m3h2x12(:,172),heltab2x24(:,:,172))
  call Hloop_A_Q(ntryL,G1H12(81),18,nMB,G2H12(86),n2h12(133))
  call Hloop_SA_Q(ntryL,G1H24(110),ex2(:),G1H12(81),ngX,m3h2x12(:,173),heltab2x24(:,:,173))
  call Hloop_A_Q(ntryL,G1H12(81),18,nMB,G2H12(87),n2h12(134))
  call Hloop_QA_W(ntryL,G1H24(111),ex2(:),G1H12(81),m3h2x12(:,174),heltab2x24(:,:,174))
  call Hloop_QA_S(ntryL,G1H24(112),ex2(:),G1H12(82),ngPbt,m3h2x12(:,175),heltab2x24(:,:,175))
  call Hloop_SA_Q(ntryL,G0H24(67),ex2(:),G0H12(7),ngH,m3h2x12(:,176),heltab2x24(:,:,176))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(83),n2h12(135))
  call Hloop_VA_Q(ntryL,G0H24(68),ex2(:),G0H12(7),m3h2x12(:,177),heltab2x24(:,:,177))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(84),n2h12(136))
  call Hloop_VA_Q(ntryL,G0H24(69),ex2(:),G0H12(7),m3h2x12(:,178),heltab2x24(:,:,178))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(85),n2h12(137))
  call Hloop_ZA_Q(ntryL,G0H24(70),ex2(:),G0H12(7),ngZd,m3h2x12(:,179),heltab2x24(:,:,179))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(86),n2h12(138))
  call Hloop_ZA_Q(ntryL,G0H24(71),ex2(:),G0H12(7),ngZd,m3h2x12(:,180),heltab2x24(:,:,180))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(87),n2h12(139))
  call Hloop_SA_Q(ntryL,G1H24(113),ex2(:),G1H12(88),ngH,m3h2x12(:,181),heltab2x24(:,:,181))
  call Hloop_A_Q(ntryL,G1H12(88),18,nMB,G2H12(88),n2h12(140))
  call Hloop_SA_Q(ntryL,G1H24(114),ex2(:),G1H12(88),ngX,m3h2x12(:,182),heltab2x24(:,:,182))
  call Hloop_A_Q(ntryL,G1H12(88),18,nMB,G2H12(89),n2h12(141))
  call Hloop_SA_Q(ntryL,G1H24(115),ex2(:),G1H12(88),ngH,m3h2x12(:,183),heltab2x24(:,:,183))
  call Hloop_A_Q(ntryL,G1H12(88),18,nMB,G2H12(90),n2h12(142))
  call Hloop_SA_Q(ntryL,G1H24(116),ex2(:),G1H12(88),ngX,m3h2x12(:,184),heltab2x24(:,:,184))
  call Hloop_A_Q(ntryL,G1H12(88),18,nMB,G2H12(91),n2h12(143))
  call Hloop_QA_W(ntryL,G1H24(117),ex2(:),G1H12(88),m3h2x12(:,185),heltab2x24(:,:,185))
  call Hloop_VA_Q(ntryL,G1H24(118),ex2(:),G1H12(89),m3h2x12(:,186),heltab2x24(:,:,186))
  call Hloop_A_Q(ntryL,G1H12(89),18,nMB,G2H12(92),n2h12(144))
  call Hloop_ZA_Q(ntryL,G1H24(119),ex2(:),G1H12(89),ngZd,m3h2x12(:,187),heltab2x24(:,:,187))
  call Hloop_A_Q(ntryL,G1H12(89),18,nMB,G2H12(93),n2h12(145))
  call Hloop_SA_Q(ntryL,G0H24(72),ex2(:),G0H12(7),ngH,m3h2x12(:,188),heltab2x24(:,:,188))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(89),n2h12(146))
  call Hloop_SA_Q(ntryL,G0H24(73),ex2(:),G0H12(7),ngH,m3h2x12(:,189),heltab2x24(:,:,189))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(90),n2h12(147))
  call Hloop_VA_Q(ntryL,G0H24(74),ex2(:),G0H12(7),m3h2x12(:,190),heltab2x24(:,:,190))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(91),n2h12(148))
  call Hloop_ZA_Q(ntryL,G0H24(75),ex2(:),G0H12(7),ngZd,m3h2x12(:,191),heltab2x24(:,:,191))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(92),n2h12(149))
  call Hloop_VA_Q(ntryL,G0H24(76),ex2(:),G0H12(7),m3h2x12(:,192),heltab2x24(:,:,192))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(93),n2h12(150))
  call Hloop_ZA_Q(ntryL,G0H24(77),ex2(:),G0H12(7),ngZd,m3h2x12(:,193),heltab2x24(:,:,193))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(94),n2h12(151))
  call Hloop_VA_Q(ntryL,G1H24(120),ex2(:),G1H12(95),m3h2x12(:,194),heltab2x24(:,:,194))
  call Hloop_A_Q(ntryL,G1H12(95),18,nMB,G2H12(94),n2h12(152))
  call Hloop_ZA_Q(ntryL,G1H24(121),ex2(:),G1H12(95),ngZd,m3h2x12(:,195),heltab2x24(:,:,195))
  call Hloop_A_Q(ntryL,G1H12(95),18,nMB,G2H12(95),n2h12(153))
  call Hloop_VA_Q(ntryL,G1H24(122),ex2(:),G1H12(95),m3h2x12(:,196),heltab2x24(:,:,196))
  call Hloop_A_Q(ntryL,G1H12(95),18,nMB,G2H12(96),n2h12(154))
  call Hloop_ZA_Q(ntryL,G1H24(123),ex2(:),G1H12(95),ngZd,m3h2x12(:,197),heltab2x24(:,:,197))
  call Hloop_A_Q(ntryL,G1H12(95),18,nMB,G2H12(97),n2h12(155))
  call Hloop_QA_S(ntryL,G1H24(124),ex2(:),G1H12(95),ngPbt,m3h2x12(:,198),heltab2x24(:,:,198))
  call Hloop_QA_S(ntryL,G1H24(125),ex2(:),G1H12(96),ngPbt,m3h2x12(:,199),heltab2x24(:,:,199))
  call Hloop_SA_Q(ntryL,G1H24(126),ex2(:),G1H12(97),ngH,m3h2x12(:,200),heltab2x24(:,:,200))
  call Hloop_A_Q(ntryL,G1H12(97),18,nMB,G2H12(98),n2h12(156))
  call Hloop_SA_Q(ntryL,G1H24(127),ex2(:),G1H12(97),ngX,m3h2x12(:,201),heltab2x24(:,:,201))
  call Hloop_A_Q(ntryL,G1H12(97),18,nMB,G2H12(99),n2h12(157))
  call Hloop_QA_W(ntryL,G1H24(128),ex2(:),G1H12(97),m3h2x12(:,202),heltab2x24(:,:,202))
  call Hloop_QA_S(ntryL,G1H24(129),ex2(:),G1H12(98),ngPbt,m3h2x12(:,203),heltab2x24(:,:,203))
  call Hloop_QA_S(ntryL,G1H24(130),ex2(:),G1H12(99),ngPbt,m3h2x12(:,204),heltab2x24(:,:,204))
  call Hloop_SA_Q(ntryL,G0H24(78),ex2(:),G0H12(7),ngH,m3h2x12(:,205),heltab2x24(:,:,205))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(100),n2h12(158))
  call Hloop_VA_Q(ntryL,G0H24(79),ex2(:),G0H12(7),m3h2x12(:,206),heltab2x24(:,:,206))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(101),n2h12(159))
  call Hloop_ZA_Q(ntryL,G0H24(80),ex2(:),G0H12(7),ngZd,m3h2x12(:,207),heltab2x24(:,:,207))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(102),n2h12(160))
  call Hloop_SA_Q(ntryL,G1H24(131),ex2(:),G1H12(103),ngH,m3h2x12(:,208),heltab2x24(:,:,208))
  call Hloop_A_Q(ntryL,G1H12(103),18,nMB,G2H12(100),n2h12(161))
  call Hloop_SA_Q(ntryL,G1H24(132),ex2(:),G1H12(103),ngX,m3h2x12(:,209),heltab2x24(:,:,209))
  call Hloop_A_Q(ntryL,G1H12(103),18,nMB,G2H12(101),n2h12(162))
  call Hloop_QA_W(ntryL,G1H24(133),ex2(:),G1H12(103),m3h2x12(:,210),heltab2x24(:,:,210))
  call Hloop_QA_W(ntryL,G1H24(134),ex2(:),G1H12(104),m3h2x12(:,211),heltab2x24(:,:,211))
  call Hloop_VA_Q(ntryL,G1H24(135),ex2(:),G1H12(105),m3h2x12(:,212),heltab2x24(:,:,212))
  call Hloop_A_Q(ntryL,G1H12(105),18,nMB,G2H12(102),n2h12(163))
  call Hloop_ZA_Q(ntryL,G1H24(136),ex2(:),G1H12(105),ngZd,m3h2x12(:,213),heltab2x24(:,:,213))
  call Hloop_A_Q(ntryL,G1H12(105),18,nMB,G2H12(103),n2h12(164))
  call Hloop_SA_Q(ntryL,G0H24(81),ex2(:),G0H12(7),ngH,m3h2x12(:,214),heltab2x24(:,:,214))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(105),n2h12(165))
  call Hloop_VA_Q(ntryL,G0H24(82),ex2(:),G0H12(7),m3h2x12(:,215),heltab2x24(:,:,215))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(106),n2h12(166))
  call Hloop_ZA_Q(ntryL,G0H24(83),ex2(:),G0H12(7),ngZd,m3h2x12(:,216),heltab2x24(:,:,216))
  call Hloop_A_Q(ntryL,G0H12(7),18,nMB,G1H12(107),n2h12(167))
  call Hloop_VA_Q(ntryL,G1H24(137),ex2(:),G1H12(108),m3h2x12(:,217),heltab2x24(:,:,217))
  call Hloop_A_Q(ntryL,G1H12(108),18,nMB,G2H12(104),n2h12(168))
  call Hloop_ZA_Q(ntryL,G1H24(138),ex2(:),G1H12(108),ngZd,m3h2x12(:,218),heltab2x24(:,:,218))
  call Hloop_A_Q(ntryL,G1H12(108),18,nMB,G2H12(105),n2h12(169))
  call Hloop_SQ_A(ntryL,G1H24(139),ex1(:),G1H12(108),ngH,m3h2x12(:,219),heltab2x24(:,:,219))
  call Hloop_Q_A(ntryL,G1H12(108),17,nMB,G2H12(106),n2h12(170))
  call Hloop_SQ_A(ntryL,G1H24(140),ex1(:),G1H12(108),ngH,m3h2x12(:,220),heltab2x24(:,:,220))
  call Hloop_Q_A(ntryL,G1H12(108),17,nMB,G2H12(107),n2h12(171))
  call Hloop_SQ_A(ntryL,G1H24(141),ex1(:),G1H12(108),ngX,m3h2x12(:,221),heltab2x24(:,:,221))
  call Hloop_Q_A(ntryL,G1H12(108),17,nMB,G2H12(108),n2h12(172))
  call Hloop_SQ_A(ntryL,G1H24(142),ex1(:),G1H12(108),ngX,m3h2x12(:,222),heltab2x24(:,:,222))
  call Hloop_Q_A(ntryL,G1H12(108),17,nMB,G2H12(109),n2h12(173))
  call Hloop_SQ_A(ntryL,G1H24(143),ex1(:),G1H12(108),ngPtb,m3h2x12(:,223),heltab2x24(:,:,223))
  call Hloop_Q_A(ntryL,G1H12(108),17,nMT,G2H12(110),n2h12(174))
  call Hloop_SQ_A(ntryL,G1H24(144),ex1(:),G1H12(108),ngPtb,m3h2x12(:,224),heltab2x24(:,:,224))
  call Hloop_Q_A(ntryL,G1H12(108),17,nMT,G2H12(111),n2h12(175))
  call Hloop_SQ_A(ntryL,G0H24(84),ex1(:),G0H12(7),ngPtb,m3h2x12(:,225),heltab2x24(:,:,225))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(108),n2h12(176))
  call Hloop_SQ_A(ntryL,G0H24(85),ex1(:),G0H12(7),ngPtb,m3h2x12(:,226),heltab2x24(:,:,226))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(109),n2h12(177))
  call Hloop_SQ_A(ntryL,G0H24(86),ex1(:),G0H12(7),ngH,m3h2x12(:,227),heltab2x24(:,:,227))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(110),n2h12(178))
  call Hloop_SQ_A(ntryL,G1H24(145),ex1(:),G1H12(111),ngH,m3h2x12(:,228),heltab2x24(:,:,228))
  call Hloop_Q_A(ntryL,G1H12(111),17,nMB,G2H12(112),n2h12(179))
  call Hloop_SQ_A(ntryL,G1H24(146),ex1(:),G1H12(111),ngX,m3h2x12(:,229),heltab2x24(:,:,229))
  call Hloop_Q_A(ntryL,G1H12(111),17,nMB,G2H12(113),n2h12(180))
  call Hloop_SQ_A(ntryL,G1H24(147),ex1(:),G1H12(111),ngH,m3h2x12(:,230),heltab2x24(:,:,230))
  call Hloop_Q_A(ntryL,G1H12(111),17,nMB,G2H12(114),n2h12(181))
  call Hloop_SQ_A(ntryL,G1H24(148),ex1(:),G1H12(111),ngX,m3h2x12(:,231),heltab2x24(:,:,231))
  call Hloop_Q_A(ntryL,G1H12(111),17,nMB,G2H12(115),n2h12(182))
  call Hloop_SQ_A(ntryL,G1H24(149),ex1(:),G1H12(111),ngPtb,m3h2x12(:,232),heltab2x24(:,:,232))
  call Hloop_Q_A(ntryL,G1H12(111),17,nMT,G2H12(116),n2h12(183))
  call Hloop_VQ_A(ntryL,G0H24(87),ex1(:),G0H12(7),m3h2x12(:,233),heltab2x24(:,:,233))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(111),n2h12(184))
  call Hloop_VQ_A(ntryL,G0H24(88),ex1(:),G0H12(7),m3h2x12(:,234),heltab2x24(:,:,234))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(112),n2h12(185))
  call Hloop_ZQ_A(ntryL,G0H24(89),ex1(:),G0H12(7),ngZd,m3h2x12(:,235),heltab2x24(:,:,235))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(113),n2h12(186))
  call Hloop_ZQ_A(ntryL,G0H24(90),ex1(:),G0H12(7),ngZd,m3h2x12(:,236),heltab2x24(:,:,236))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(114),n2h12(187))
  call Hloop_WQ_A(ntryL,G0H24(91),ex1(:),G0H12(7),m3h2x12(:,237),heltab2x24(:,:,237))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(115),n2h12(188))
  call Hloop_SQ_A(ntryL,G0H24(92),ex1(:),G0H12(7),ngH,m3h2x12(:,238),heltab2x24(:,:,238))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(116),n2h12(189))
  call Hloop_SQ_A(ntryL,G0H24(93),ex1(:),G0H12(7),ngPtb,m3h2x12(:,239),heltab2x24(:,:,239))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(117),n2h12(190))
  call Hloop_SQ_A(ntryL,G0H24(94),ex1(:),G0H12(7),ngH,m3h2x12(:,240),heltab2x24(:,:,240))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(118),n2h12(191))
  call Hloop_SQ_A(ntryL,G0H24(95),ex1(:),G0H12(7),ngPtb,m3h2x12(:,241),heltab2x24(:,:,241))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(119),n2h12(192))
  call Hloop_VQ_A(ntryL,G1H24(150),ex1(:),G1H12(120),m3h2x12(:,242),heltab2x24(:,:,242))
  call Hloop_Q_A(ntryL,G1H12(120),17,nMB,G2H12(117),n2h12(193))
  call Hloop_WQ_A(ntryL,G1H24(151),ex1(:),G1H12(120),m3h2x12(:,243),heltab2x24(:,:,243))
  call Hloop_Q_A(ntryL,G1H12(120),17,nMT,G2H12(118),n2h12(194))
  call Hloop_ZQ_A(ntryL,G1H24(152),ex1(:),G1H12(120),ngZd,m3h2x12(:,244),heltab2x24(:,:,244))
  call Hloop_Q_A(ntryL,G1H12(120),17,nMB,G2H12(119),n2h12(195))
  call Hloop_WQ_A(ntryL,G1H24(153),ex1(:),G1H12(120),m3h2x12(:,245),heltab2x24(:,:,245))
  call Hloop_Q_A(ntryL,G1H12(120),17,nMT,G2H12(120),n2h12(196))
  call Hloop_VQ_A(ntryL,G0H24(96),ex1(:),G0H12(7),m3h2x12(:,246),heltab2x24(:,:,246))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(120),n2h12(197))
  call Hloop_VQ_A(ntryL,G0H24(97),ex1(:),G0H12(7),m3h2x12(:,247),heltab2x24(:,:,247))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(121),n2h12(198))
  call Hloop_ZQ_A(ntryL,G0H24(98),ex1(:),G0H12(7),ngZd,m3h2x12(:,248),heltab2x24(:,:,248))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(122),n2h12(199))
  call Hloop_ZQ_A(ntryL,G0H24(99),ex1(:),G0H12(7),ngZd,m3h2x12(:,249),heltab2x24(:,:,249))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMB,G1H12(123),n2h12(200))
  call Hloop_WQ_A(ntryL,G0H24(100),ex1(:),G0H12(7),m3h2x12(:,250),heltab2x24(:,:,250))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(124),n2h12(201))
  call Hloop_VQ_A(ntryL,G1H24(154),ex1(:),G1H12(125),m3h2x12(:,251),heltab2x24(:,:,251))
  call Hloop_Q_A(ntryL,G1H12(125),17,nMB,G2H12(121),n2h12(202))
  call Hloop_VQ_A(ntryL,G1H24(155),ex1(:),G1H12(125),m3h2x12(:,252),heltab2x24(:,:,252))
  call Hloop_Q_A(ntryL,G1H12(125),17,nMB,G2H12(122),n2h12(203))
  call Hloop_ZQ_A(ntryL,G1H24(156),ex1(:),G1H12(125),ngZd,m3h2x12(:,253),heltab2x24(:,:,253))
  call Hloop_Q_A(ntryL,G1H12(125),17,nMB,G2H12(123),n2h12(204))
  call Hloop_ZQ_A(ntryL,G1H24(157),ex1(:),G1H12(125),ngZd,m3h2x12(:,254),heltab2x24(:,:,254))
  call Hloop_Q_A(ntryL,G1H12(125),17,nMB,G2H12(124),n2h12(205))
  call Hloop_WQ_A(ntryL,G1H24(158),ex1(:),G1H12(125),m3h2x12(:,255),heltab2x24(:,:,255))
  call Hloop_Q_A(ntryL,G1H12(125),17,nMT,G2H12(125),n2h12(206))
  call Hloop_WQ_A(ntryL,G1H24(159),ex1(:),G1H12(125),m3h2x12(:,256),heltab2x24(:,:,256))
  call Hloop_Q_A(ntryL,G1H12(125),17,nMT,G2H12(126),n2h12(207))
  call Hloop_SQ_A(ntryL,G1H24(160),ex1(:),G1H12(125),ngPtb,m3h2x12(:,257),heltab2x24(:,:,257))
  call Hloop_Q_A(ntryL,G1H12(125),17,nMT,G2H12(127),n2h12(208))
  call Hloop_SQ_A(ntryL,G1H24(161),ex1(:),G1H12(125),ngPtb,m3h2x12(:,258),heltab2x24(:,:,258))
  call Hloop_Q_A(ntryL,G1H12(125),17,nMT,G2H12(128),n2h12(209))
  call Hloop_SQ_A(ntryL,G0H24(101),ex1(:),G0H12(7),ngPtb,m3h2x12(:,259),heltab2x24(:,:,259))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(125),n2h12(210))
  call Hloop_SQ_A(ntryL,G0H24(102),ex1(:),G0H12(7),ngPtb,m3h2x12(:,260),heltab2x24(:,:,260))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(126),n2h12(211))
  call Hloop_WQ_A(ntryL,G0H24(103),ex1(:),G0H12(7),m3h2x12(:,261),heltab2x24(:,:,261))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(127),n2h12(212))
  call Hloop_WQ_A(ntryL,G1H24(162),ex1(:),G1H12(128),m3h2x12(:,262),heltab2x24(:,:,262))
  call Hloop_Q_A(ntryL,G1H12(128),17,nMT,G2H12(129),n2h12(213))
  call Hloop_WQ_A(ntryL,G1H24(163),ex1(:),G1H12(128),m3h2x12(:,263),heltab2x24(:,:,263))
  call Hloop_Q_A(ntryL,G1H12(128),17,nMT,G2H12(130),n2h12(214))
  call Hloop_AQ_S(ntryL,G1H24(164),ex1(:),G1H12(128),ngH,m3h2x12(:,264),heltab2x24(:,:,264))
  call Hloop_AQ_S(ntryL,G1H24(165),ex1(:),G1H12(129),ngX,m3h2x12(:,265),heltab2x24(:,:,265))
  call Hloop_AQ_S(ntryL,G1H24(166),ex1(:),G1H12(130),ngH,m3h2x12(:,266),heltab2x24(:,:,266))
  call Hloop_AQ_V(ntryL,G1H24(167),ex1(:),G1H12(131),m3h2x12(:,267),heltab2x24(:,:,267))
  call Hloop_AQ_Z(ntryL,G1H24(168),ex1(:),G1H12(132),ngZd,m3h2x12(:,268),heltab2x24(:,:,268))
  call Hloop_AQ_V(ntryL,G1H24(169),ex1(:),G1H12(133),m3h2x12(:,269),heltab2x24(:,:,269))
  call Hloop_AQ_Z(ntryL,G1H24(170),ex1(:),G1H12(134),ngZd,m3h2x12(:,270),heltab2x24(:,:,270))
  call Hloop_SQ_A(ntryL,G1H24(171),ex1(:),G1H12(135),ngPtb,m3h2x12(:,271),heltab2x24(:,:,271))
  call Hloop_Q_A(ntryL,G1H12(135),17,nMT,G2H12(131),n2h12(215))
  call Hloop_SQ_A(ntryL,G1H24(172),ex1(:),G1H12(135),ngPtb,m3h2x12(:,272),heltab2x24(:,:,272))
  call Hloop_Q_A(ntryL,G1H12(135),17,nMT,G2H12(132),n2h12(216))
  call Hloop_AQ_S(ntryL,G1H24(173),ex1(:),G1H12(135),ngH,m3h2x12(:,273),heltab2x24(:,:,273))
  call Hloop_AQ_S(ntryL,G1H24(174),ex1(:),G1H12(136),ngX,m3h2x12(:,274),heltab2x24(:,:,274))
  call Hloop_SQ_A(ntryL,G0H24(104),ex1(:),G0H12(7),ngPtb,m3h2x12(:,275),heltab2x24(:,:,275))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(137),n2h12(217))
  call Hloop_SQ_A(ntryL,G0H24(105),ex1(:),G0H12(7),ngPtb,m3h2x12(:,276),heltab2x24(:,:,276))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(138),n2h12(218))
  call Hloop_WQ_A(ntryL,G0H24(106),ex1(:),G0H12(7),m3h2x12(:,277),heltab2x24(:,:,277))
  call Hloop_Q_A(ntryL,G0H12(7),17,nMT,G1H12(139),n2h12(219))
  call Hloop_AQ_S(ntryL,G1H24(175),ex1(:),G1H12(140),ngH,m3h2x12(:,278),heltab2x24(:,:,278))
  call Hloop_AQ_S(ntryL,G1H24(176),ex1(:),G1H12(141),ngH,m3h2x12(:,279),heltab2x24(:,:,279))
  call Hloop_AQ_S(ntryL,G1H24(177),ex1(:),G1H12(142),ngX,m3h2x12(:,280),heltab2x24(:,:,280))
  call Hloop_AQ_V(ntryL,G1H24(178),ex1(:),G1H12(143),m3h2x12(:,281),heltab2x24(:,:,281))
  call Hloop_AQ_Z(ntryL,G1H24(179),ex1(:),G1H12(144),ngZd,m3h2x12(:,282),heltab2x24(:,:,282))
  call Hloop_WQ_A(ntryL,G1H24(180),ex1(:),G1H12(145),m3h2x12(:,283),heltab2x24(:,:,283))
  call Hloop_Q_A(ntryL,G1H12(145),17,nMT,G2H12(133),n2h12(220))
  call Hloop_WQ_A(ntryL,G1H24(181),ex1(:),G1H12(145),m3h2x12(:,284),heltab2x24(:,:,284))
  call Hloop_Q_A(ntryL,G1H12(145),17,nMT,G2H12(134),n2h12(221))
  call Hloop_AQ_S(ntryL,G1H24(182),ex1(:),G1H12(145),ngH,m3h2x12(:,285),heltab2x24(:,:,285))
  call Hloop_AQ_V(ntryL,G1H24(183),ex1(:),G1H12(146),m3h2x12(:,286),heltab2x24(:,:,286))
  call Hloop_AQ_Z(ntryL,G1H24(184),ex1(:),G1H12(147),ngZd,m3h2x12(:,287),heltab2x24(:,:,287))
  call Hloop_AQ_V(ntryL,G1H24(185),ex1(:),G1H12(148),m3h2x12(:,288),heltab2x24(:,:,288))
  call Hloop_AQ_Z(ntryL,G1H24(186),ex1(:),G1H12(149),ngZd,m3h2x12(:,289),heltab2x24(:,:,289))
  call Hloop_AQ_V(ntryL,G1H24(187),ex1(:),G1H12(150),m3h2x12(:,290),heltab2x24(:,:,290))
  call Hloop_AQ_Z(ntryL,G1H24(188),ex1(:),G1H12(151),ngZd,m3h2x12(:,291),heltab2x24(:,:,291))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(3),[G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(5),[G1H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(6),[G1H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(7),[G0H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(9),[G1H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(11),[G1H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(12),[G1H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G0H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(9),[G0H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(13),[G1H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(10),[G0H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(11),[G0H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(15),[G1H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(17),[G1H12(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(19),[G1H12(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(21),[G1H12(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(23),[G1H12(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(29),[G1H12(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(31),[G1H12(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(42),[G1H12(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(48),[G1H12(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(49),[G1H12(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(44),[G1H12(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(45),[G1H12(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(50),[G1H12(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(51),[G1H12(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(52),[G1H12(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(53),[G1H12(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(47),[G1H12(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(54),[G1H12(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(55),[G1H12(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(58),[G1H12(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(59),[G1H12(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(61),[G1H12(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(63),[G1H12(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(65),[G1H12(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(67),[G1H12(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(69),[G1H12(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(85),[G1H12(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(87),[G1H12(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(89),[G1H12(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(91),[G1H12(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(99),[G1H12(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(101),[G1H12(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(108),[G1H12(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(109),[G1H12(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(110),[G1H12(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(118),[G1H12(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(120),[G1H12(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(113),[G1H12(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(115),[G1H12(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(116),[G1H12(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(125),[G1H12(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(126),[G1H12(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(127),[G1H12(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(129),[G1H12(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(130),[G1H12(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(131),[G1H12(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(133),[G1H12(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(134),[G1H12(138)])
  call Hloop_AQ_S(ntryL,G2H12(1),ex1(:),G2H6(1),ngH,m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_S(ntryL,G2H12(2),ex1(:),G2H6(2),ngX,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(1),mass5set(:,1),  & 
G1H12(1),G1H12(2),G1H12(3),G1H12(7),G1H12(8),G1H12(10),12)
  call HG1shiftOLR(G1H12(2),8,12)
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(1),mass5set(:,2),  & 
G1H12(22),G1H12(23),G1H12(26),G1H12(30),G1H12(32),G1H12(36),12)
  call HG1shiftOLR(G1H12(23),8,12)
  call Hloop_AQ_V(ntryL,G2H12(5),ex1(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H12(6),ex1(:),G2H6(4),ngZd,m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_SQ_A(ntryL,G1H12(5),ex1(:),G1H6(1),ngPtb,m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMT,G2H6(5),n2h6(1))
  call Hloop_SQ_A(ntryL,G1H12(6),ex1(:),G1H6(1),ngPtb,m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMT,G2H6(6),n2h6(2))
  call Hotf_5pt_reduction(G2H12(7),RedSet_5(1),mass5set(:,1),  & 
G1H12(38),G1H12(45),G1H12(43),G1H12(44),G1H12(50),G1H12(51),12)
  call HG1shiftOLR(G1H12(45),8,12)
  call Hloop_WQ_A(ntryL,G1H12(9),ex1(:),G1H6(1),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMT,G2H6(7),n2h6(3))
  call Hloop_WQ_A(ntryL,G1H12(4),ex1(:),G1H6(1),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMT,G2H6(8),n2h6(4))
  call Hloop_SQ_A(ntryL,G1H12(11),ex1(:),G1H6(1),ngPtb,m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMT,G2H6(9),n2h6(5))
  call Hloop_SQ_A(ntryL,G1H12(12),ex1(:),G1H6(1),ngPtb,m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMT,G2H6(10),n2h6(6))
  call Hotf_5pt_reduction(G2H12(8),RedSet_5(1),mass5set(:,3),  & 
G1H12(46),G1H12(47),G1H12(48),G1H12(49),G1H12(54),G1H12(52),12)
  call HG1shiftOLR(G1H12(47),8,12)
  call Hotf_5pt_reduction(G2H12(9),RedSet_5(1),mass5set(:,2),  & 
G1H12(53),G1H12(63),G1H12(64),G1H12(69),G1H12(72),G1H12(73),12)
  call HG1shiftOLR(G1H12(63),8,12)
  call Hloop_WQ_A(ntryL,G1H12(13),ex1(:),G1H6(1),m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMT,G2H6(11),n2h6(7))
  call Hotf_5pt_reduction(G2H12(10),RedSet_5(1),mass5set(:,3),  & 
G1H12(78),G1H12(79),G1H12(86),G1H12(87),G1H12(92),G1H12(94),12)
  call HG1shiftOLR(G1H12(79),8,12)
  call Hotf_5pt_reduction(G2H12(11),RedSet_5(1),mass5set(:,2),  & 
G1H12(102),G1H12(107),G1H12(113),G1H12(114),G1H12(115),G1H12(108),12)
  call HG1shiftOLR(G1H12(107),8,12)
  call Hloop_SQ_A(ntryL,G1H12(14),ex1(:),G1H6(1),ngPtb,m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(12),n2h6(8))
  call Hloop_WQ_A(ntryL,G1H12(15),ex1(:),G1H6(1),m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(13),n2h6(9))
  call Hloop_QA_S(ntryL,G2H12(12),ex2(:),G2H6(14),ngPbt,m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_QA_W(ntryL,G2H12(13),ex2(:),G2H6(15),m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_SQ_A(ntryL,G1H12(16),ex1(:),G1H6(1),ngPtb,m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(16),n2h6(10))
  call Hloop_AQ_S(ntryL,G2H12(14),ex1(:),G2H6(17),ngH,m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_AQ_S(ntryL,G2H12(15),ex1(:),G2H6(18),ngH,m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_AQ_S(ntryL,G2H12(16),ex1(:),G2H6(19),ngX,m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_AQ_S(ntryL,G2H12(17),ex1(:),G2H6(20),ngX,m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_WQ_A(ntryL,G1H12(17),ex1(:),G1H6(1),m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(21),n2h6(11))
  call Hloop_AQ_S(ntryL,G1H12(18),ex1(:),G1H6(1),ngH,m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_AQ_S(ntryL,G1H12(19),ex1(:),G1H6(2),ngX,m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_AQ_S(ntryL,G2H12(18),ex1(:),G2H6(22),ngH,m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_AQ_S(ntryL,G2H12(19),ex1(:),G2H6(23),ngH,m3h2x6(:,25),heltab2x12(:,:,25))
  call Hloop_AQ_S(ntryL,G1H12(20),ex1(:),G1H6(3),ngH,m3h2x6(:,26),heltab2x12(:,:,26))
  call Hloop_AQ_S(ntryL,G1H12(21),ex1(:),G1H6(4),ngX,m3h2x6(:,27),heltab2x12(:,:,27))
  call Hloop_AQ_V(ntryL,G2H12(20),ex1(:),G2H6(24),m3h2x6(:,28),heltab2x12(:,:,28))
  call Hloop_AQ_V(ntryL,G2H12(21),ex1(:),G2H6(25),m3h2x6(:,29),heltab2x12(:,:,29))
  call Hloop_AQ_Z(ntryL,G2H12(22),ex1(:),G2H6(26),ngZd,m3h2x6(:,30),heltab2x12(:,:,30))
  call Hloop_AQ_Z(ntryL,G2H12(23),ex1(:),G2H6(27),ngZd,m3h2x6(:,31),heltab2x12(:,:,31))
  call Hloop_AQ_S(ntryL,G1H12(24),ex1(:),G1H6(5),ngH,m3h2x6(:,32),heltab2x12(:,:,32))
  call Hloop_AQ_S(ntryL,G2H12(24),ex1(:),G2H6(28),ngH,m3h2x6(:,33),heltab2x12(:,:,33))
  call Hloop_AQ_S(ntryL,G2H12(25),ex1(:),G2H6(29),ngX,m3h2x6(:,34),heltab2x12(:,:,34))
  call Hloop_AQ_S(ntryL,G2H12(26),ex1(:),G2H6(30),ngH,m3h2x6(:,35),heltab2x12(:,:,35))
  call Hloop_AQ_S(ntryL,G2H12(27),ex1(:),G2H6(31),ngX,m3h2x6(:,36),heltab2x12(:,:,36))
  call Hloop_AQ_S(ntryL,G1H12(25),ex1(:),G1H6(6),ngH,m3h2x6(:,37),heltab2x12(:,:,37))
  call Hloop_AQ_V(ntryL,G1H12(27),ex1(:),G1H6(7),m3h2x6(:,38),heltab2x12(:,:,38))
  call Hloop_AQ_Z(ntryL,G1H12(28),ex1(:),G1H6(8),ngZd,m3h2x6(:,39),heltab2x12(:,:,39))
  call Hloop_AQ_V(ntryL,G2H12(28),ex1(:),G2H6(32),m3h2x6(:,40),heltab2x12(:,:,40))
  call Hloop_AQ_V(ntryL,G2H12(29),ex1(:),G2H6(33),m3h2x6(:,41),heltab2x12(:,:,41))
  call Hloop_AQ_Z(ntryL,G2H12(30),ex1(:),G2H6(34),ngZd,m3h2x6(:,42),heltab2x12(:,:,42))
  call Hloop_AQ_Z(ntryL,G2H12(31),ex1(:),G2H6(35),ngZd,m3h2x6(:,43),heltab2x12(:,:,43))
  call Hloop_AQ_V(ntryL,G1H12(29),ex1(:),G1H6(9),m3h2x6(:,44),heltab2x12(:,:,44))
  call Hloop_AQ_Z(ntryL,G1H12(31),ex1(:),G1H6(10),ngZd,m3h2x6(:,45),heltab2x12(:,:,45))
  call Hloop_AQ_S(ntryL,G2H12(32),ex1(:),G2H6(36),ngH,m3h2x6(:,46),heltab2x12(:,:,46))
  call Hloop_AQ_S(ntryL,G2H12(33),ex1(:),G2H6(37),ngH,m3h2x6(:,47),heltab2x12(:,:,47))
  call Hloop_AQ_V(ntryL,G1H12(33),ex1(:),G1H6(11),m3h2x6(:,48),heltab2x12(:,:,48))
  call Hloop_AQ_Z(ntryL,G1H12(34),ex1(:),G1H6(12),ngZd,m3h2x6(:,49),heltab2x12(:,:,49))
  call Hloop_AQ_V(ntryL,G2H12(34),ex1(:),G2H6(38),m3h2x6(:,50),heltab2x12(:,:,50))
  call Hloop_AQ_V(ntryL,G2H12(35),ex1(:),G2H6(39),m3h2x6(:,51),heltab2x12(:,:,51))
  call Hloop_AQ_Z(ntryL,G2H12(36),ex1(:),G2H6(40),ngZd,m3h2x6(:,52),heltab2x12(:,:,52))
  call Hloop_AQ_Z(ntryL,G2H12(37),ex1(:),G2H6(41),ngZd,m3h2x6(:,53),heltab2x12(:,:,53))
  call Hloop_AQ_V(ntryL,G1H12(35),ex1(:),G1H6(13),m3h2x6(:,54),heltab2x12(:,:,54))
  call Hloop_AQ_Z(ntryL,G1H12(37),ex1(:),G1H6(14),ngZd,m3h2x6(:,55),heltab2x12(:,:,55))
  call Hloop_AQ_V(ntryL,G2H12(38),ex1(:),G2H6(42),m3h2x6(:,56),heltab2x12(:,:,56))
  call Hloop_AQ_V(ntryL,G2H12(39),ex1(:),G2H6(43),m3h2x6(:,57),heltab2x12(:,:,57))
  call Hloop_AQ_Z(ntryL,G2H12(40),ex1(:),G2H6(44),ngZd,m3h2x6(:,58),heltab2x12(:,:,58))
  call Hloop_AQ_Z(ntryL,G2H12(41),ex1(:),G2H6(45),ngZd,m3h2x6(:,59),heltab2x12(:,:,59))
  call Hloop_SA_Q(ntryL,G1H12(39),ex2(:),G1H6(15),ngH,m3h2x6(:,60),heltab2x12(:,:,60))
  call Hloop_A_Q(ntryL,G1H6(15),19,nMB,G2H6(46),n2h6(12))
  call Hloop_SA_Q(ntryL,G1H12(40),ex2(:),G1H6(15),ngX,m3h2x6(:,61),heltab2x12(:,:,61))
  call Hloop_A_Q(ntryL,G1H6(15),19,nMB,G2H6(47),n2h6(13))
  call Hloop_QA_S(ntryL,G2H12(42),ex2(:),G2H6(48),ngPbt,m3h2x6(:,62),heltab2x12(:,:,62))
  call Hloop_QA_S(ntryL,G2H12(43),ex2(:),G2H6(49),ngPbt,m3h2x6(:,63),heltab2x12(:,:,63))
  call Hloop_VA_Q(ntryL,G1H12(41),ex2(:),G1H6(15),m3h2x6(:,64),heltab2x12(:,:,64))
  call Hloop_A_Q(ntryL,G1H6(15),19,nMB,G2H6(50),n2h6(14))
  call Hloop_ZA_Q(ntryL,G1H12(42),ex2(:),G1H6(15),ngZd,m3h2x6(:,65),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G1H6(15),19,nMB,G2H6(51),n2h6(15))
  call Hloop_QA_S(ntryL,G2H12(48),ex2(:),G2H6(52),ngPbt,m3h2x6(:,66),heltab2x12(:,:,66))
  call Hloop_QA_S(ntryL,G2H12(49),ex2(:),G2H6(53),ngPbt,m3h2x6(:,67),heltab2x12(:,:,67))
  call Hloop_QA_S(ntryL,G2H12(44),ex2(:),G2H6(54),ngPbt,m3h2x6(:,68),heltab2x12(:,:,68))
  call Hloop_QA_W(ntryL,G2H12(45),ex2(:),G2H6(55),m3h2x6(:,69),heltab2x12(:,:,69))
  call Hloop_QA_W(ntryL,G2H12(46),ex2(:),G2H6(56),m3h2x6(:,70),heltab2x12(:,:,70))
  call Hloop_QA_S(ntryL,G2H12(50),ex2(:),G2H6(57),ngPbt,m3h2x6(:,71),heltab2x12(:,:,71))
  call Hloop_QA_S(ntryL,G2H12(51),ex2(:),G2H6(58),ngPbt,m3h2x6(:,72),heltab2x12(:,:,72))
  call Hloop_QA_W(ntryL,G2H12(52),ex2(:),G2H6(59),m3h2x6(:,73),heltab2x12(:,:,73))
  call Hloop_QA_W(ntryL,G2H12(53),ex2(:),G2H6(60),m3h2x6(:,74),heltab2x12(:,:,74))
  call Hloop_QA_W(ntryL,G2H12(47),ex2(:),G2H6(61),m3h2x6(:,75),heltab2x12(:,:,75))
  call Hloop_QA_W(ntryL,G2H12(54),ex2(:),G2H6(62),m3h2x6(:,76),heltab2x12(:,:,76))
  call Hloop_QA_W(ntryL,G2H12(55),ex2(:),G2H6(63),m3h2x6(:,77),heltab2x12(:,:,77))
  call Hloop_SA_Q(ntryL,G1H12(55),ex2(:),G1H6(15),ngH,m3h2x6(:,78),heltab2x12(:,:,78))
  call Hloop_A_Q(ntryL,G1H6(15),19,nMB,G2H6(64),n2h6(16))
  call Hloop_SA_Q(ntryL,G1H12(56),ex2(:),G1H6(15),ngX,m3h2x6(:,79),heltab2x12(:,:,79))
  call Hloop_A_Q(ntryL,G1H6(15),19,nMB,G2H6(65),n2h6(17))
  call Hloop_QA_S(ntryL,G2H12(56),ex2(:),G2H6(66),ngH,m3h2x6(:,80),heltab2x12(:,:,80))
  call Hloop_QA_S(ntryL,G2H12(57),ex2(:),G2H6(67),ngX,m3h2x6(:,81),heltab2x12(:,:,81))
  call Hloop_QA_S(ntryL,G2H12(58),ex2(:),G2H6(68),ngH,m3h2x6(:,82),heltab2x12(:,:,82))
  call Hloop_QA_S(ntryL,G2H12(59),ex2(:),G2H6(69),ngX,m3h2x6(:,83),heltab2x12(:,:,83))
  call Hloop_VA_Q(ntryL,G1H12(57),ex2(:),G1H6(15),m3h2x6(:,84),heltab2x12(:,:,84))
  call Hloop_A_Q(ntryL,G1H6(15),19,nMB,G2H6(70),n2h6(18))
  call Hloop_ZA_Q(ntryL,G1H12(58),ex2(:),G1H6(15),ngZd,m3h2x6(:,85),heltab2x12(:,:,85))
  call Hloop_A_Q(ntryL,G1H6(15),19,nMB,G2H6(71),n2h6(19))
  call Hloop_QA_S(ntryL,G1H12(59),ex2(:),G1H6(15),ngH,m3h2x6(:,86),heltab2x12(:,:,86))
  call Hloop_QA_S(ntryL,G1H12(60),ex2(:),G1H6(16),ngX,m3h2x6(:,87),heltab2x12(:,:,87))
  call Hloop_QA_S(ntryL,G2H12(60),ex2(:),G2H6(72),ngH,m3h2x6(:,88),heltab2x12(:,:,88))
  call Hloop_QA_S(ntryL,G2H12(61),ex2(:),G2H6(73),ngH,m3h2x6(:,89),heltab2x12(:,:,89))
  call Hloop_QA_V(ntryL,G2H12(62),ex2(:),G2H6(74),m3h2x6(:,90),heltab2x12(:,:,90))
  call Hloop_QA_V(ntryL,G2H12(63),ex2(:),G2H6(75),m3h2x6(:,91),heltab2x12(:,:,91))
  call Hloop_QA_Z(ntryL,G2H12(64),ex2(:),G2H6(76),ngZd,m3h2x6(:,92),heltab2x12(:,:,92))
  call Hloop_QA_Z(ntryL,G2H12(65),ex2(:),G2H6(77),ngZd,m3h2x6(:,93),heltab2x12(:,:,93))
  call Hloop_QA_S(ntryL,G1H12(61),ex2(:),G1H6(17),ngH,m3h2x6(:,94),heltab2x12(:,:,94))
  call Hloop_QA_S(ntryL,G1H12(62),ex2(:),G1H6(18),ngX,m3h2x6(:,95),heltab2x12(:,:,95))
  call Hloop_QA_S(ntryL,G1H12(65),ex2(:),G1H6(19),ngH,m3h2x6(:,96),heltab2x12(:,:,96))
  call Hloop_QA_V(ntryL,G1H12(66),ex2(:),G1H6(20),m3h2x6(:,97),heltab2x12(:,:,97))
  call Hloop_QA_Z(ntryL,G1H12(67),ex2(:),G1H6(21),ngZd,m3h2x6(:,98),heltab2x12(:,:,98))
  call Hloop_QA_V(ntryL,G2H12(66),ex2(:),G2H6(78),m3h2x6(:,99),heltab2x12(:,:,99))
  call Hloop_QA_V(ntryL,G2H12(67),ex2(:),G2H6(79),m3h2x6(:,100),heltab2x12(:,:,100))
  call Hloop_QA_Z(ntryL,G2H12(68),ex2(:),G2H6(80),ngZd,m3h2x6(:,101),heltab2x12(:,:,101))
  call Hloop_QA_Z(ntryL,G2H12(69),ex2(:),G2H6(81),ngZd,m3h2x6(:,102),heltab2x12(:,:,102))
  call Hloop_QA_S(ntryL,G2H12(70),ex2(:),G2H6(82),ngH,m3h2x6(:,103),heltab2x12(:,:,103))
  call Hloop_QA_S(ntryL,G2H12(71),ex2(:),G2H6(83),ngX,m3h2x6(:,104),heltab2x12(:,:,104))
  call Hloop_QA_S(ntryL,G2H12(72),ex2(:),G2H6(84),ngH,m3h2x6(:,105),heltab2x12(:,:,105))
  call Hloop_QA_S(ntryL,G2H12(73),ex2(:),G2H6(85),ngX,m3h2x6(:,106),heltab2x12(:,:,106))
  call Hloop_QA_S(ntryL,G1H12(68),ex2(:),G1H6(22),ngH,m3h2x6(:,107),heltab2x12(:,:,107))
  call Hloop_QA_V(ntryL,G1H12(70),ex2(:),G1H6(23),m3h2x6(:,108),heltab2x12(:,:,108))
  call Hloop_QA_Z(ntryL,G1H12(71),ex2(:),G1H6(24),ngZd,m3h2x6(:,109),heltab2x12(:,:,109))
  call Hloop_QA_V(ntryL,G1H12(74),ex2(:),G1H6(25),m3h2x6(:,110),heltab2x12(:,:,110))
  call Hloop_QA_Z(ntryL,G1H12(75),ex2(:),G1H6(26),ngZd,m3h2x6(:,111),heltab2x12(:,:,111))
  call Hloop_QA_S(ntryL,G2H12(74),ex2(:),G2H6(86),ngH,m3h2x6(:,112),heltab2x12(:,:,112))
  call Hloop_QA_S(ntryL,G2H12(75),ex2(:),G2H6(87),ngH,m3h2x6(:,113),heltab2x12(:,:,113))
  call Hloop_QA_V(ntryL,G2H12(76),ex2(:),G2H6(88),m3h2x6(:,114),heltab2x12(:,:,114))
  call Hloop_QA_Z(ntryL,G2H12(77),ex2(:),G2H6(89),ngZd,m3h2x6(:,115),heltab2x12(:,:,115))
  call Hloop_QA_V(ntryL,G2H12(78),ex2(:),G2H6(90),m3h2x6(:,116),heltab2x12(:,:,116))
  call Hloop_QA_Z(ntryL,G2H12(79),ex2(:),G2H6(91),ngZd,m3h2x6(:,117),heltab2x12(:,:,117))
  call Hloop_QA_V(ntryL,G1H12(76),ex2(:),G1H6(27),m3h2x6(:,118),heltab2x12(:,:,118))
  call Hloop_QA_Z(ntryL,G1H12(77),ex2(:),G1H6(28),ngZd,m3h2x6(:,119),heltab2x12(:,:,119))
  call Hloop_QA_V(ntryL,G2H12(80),ex2(:),G2H6(92),m3h2x6(:,120),heltab2x12(:,:,120))
  call Hloop_QA_Z(ntryL,G2H12(81),ex2(:),G2H6(93),ngZd,m3h2x6(:,121),heltab2x12(:,:,121))
  call Hloop_QA_V(ntryL,G2H12(82),ex2(:),G2H6(94),m3h2x6(:,122),heltab2x12(:,:,122))
  call Hloop_QA_Z(ntryL,G2H12(83),ex2(:),G2H6(95),ngZd,m3h2x6(:,123),heltab2x12(:,:,123))
  call Hloop_SV_T(ntryL,G1H12(80),18,ex3(:),4,G2H6(96),m3h2x6(:,124),heltab2x12(:,:,124))
  call Hotf_5pt_reduction(G2H12(84),RedSet_5(2),mass5set(:,4),  & 
G1H12(109),G1H12(122),G1H12(123),G1H12(124),G1H12(117),G1H12(119),12)
  call HG1shiftOLR(G1H12(122),8,12)
  call Hotf_5pt_reduction(G2H12(85),RedSet_5(2),mass5set(:,5),  & 
G1H12(127),G1H12(125),G1H12(126),G1H12(139),G1H12(137),G1H12(138),12)
  call HG1shiftOLR(G1H12(125),8,12)
  call Hotf_5pt_reduction(G2H12(86),RedSet_5(2),mass5set(:,6),  & 
G1H12(5),G1H12(6),G1H12(9),G1H12(4),G1H12(11),G1H12(12),12)
  call HG1shiftOLR(G1H12(6),8,12)
  call Hotf_5pt_reduction(G2H12(87),RedSet_5(2),mass5set(:,7),  & 
G1H12(13),G1H12(14),G1H12(15),G1H12(16),G1H12(17),G1H12(18),12)
  call HG1shiftOLR(G1H12(14),8,12)
  call Hloop_VV_S(ntryL,G1H12(81),ex3(:),G1H6(29),m3h2x6(:,125),heltab2x12(:,:,125))
  call Hloop_SV_V(ntryL,G1H12(82),ex3(:),G1H6(30),m3h2x6(:,126),heltab2x12(:,:,126))
  call Hloop_AV_Q(ntryL,G1H12(83),ex3(:),G1H6(31),m3h2x6(:,127),heltab2x12(:,:,127))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(97),n2h6(20))
  call Hloop_AV_Q(ntryL,G1H12(84),ex3(:),G1H6(31),m3h2x6(:,128),heltab2x12(:,:,128))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(98),n2h6(21))
  call Hloop_AV_Q(ntryL,G1H12(85),ex3(:),G1H6(31),m3h2x6(:,129),heltab2x12(:,:,129))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(99),n2h6(22))
  call Hotf_5pt_reduction(G2H12(88),RedSet_5(2),mass5set(:,8),  & 
G1H12(19),G1H12(20),G1H12(21),G1H12(24),G1H12(25),G1H12(27),12)
  call HG1shiftOLR(G1H12(20),8,12)
  call Hotf_5pt_reduction(G2H12(89),RedSet_5(2),mass5set(:,9),  & 
G1H12(28),G1H12(29),G1H12(31),G1H12(33),G1H12(34),G1H12(35),12)
  call HG1shiftOLR(G1H12(29),8,12)
  call Hotf_5pt_reduction(G2H12(90),RedSet_5(2),mass5set(:,6),  & 
G1H12(37),G1H12(39),G1H12(40),G1H12(41),G1H12(42),G1H12(55),12)
  call HG1shiftOLR(G1H12(39),8,12)
  call Hotf_5pt_reduction(G2H12(91),RedSet_5(2),mass5set(:,7),  & 
G1H12(56),G1H12(57),G1H12(58),G1H12(59),G1H12(60),G1H12(61),12)
  call HG1shiftOLR(G1H12(57),8,12)
  call Hloop_UW_V(ntryL,G1H12(88),18,ex3(:),4,G2H6(100),m3h2x6(:,130),heltab2x12(:,:,130))
  call Hotf_5pt_reduction(G2H12(92),RedSet_5(2),mass5set(:,10),  & 
G1H12(62),G1H12(65),G1H12(66),G1H12(67),G1H12(68),G1H12(70),12)
  call HG1shiftOLR(G1H12(65),8,12)
  call Hotf_5pt_reduction(G2H12(93),RedSet_5(2),mass5set(:,5),  & 
G1H12(71),G1H12(74),G1H12(75),G1H12(76),G1H12(77),G1H12(80),12)
  call HG1shiftOLR(G1H12(74),8,12)
  call Hloop_AV_Q(ntryL,G1H12(89),ex3(:),G1H6(31),m3h2x6(:,131),heltab2x12(:,:,131))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(101),n2h6(23))
  call Hloop_AV_Q(ntryL,G1H12(90),ex3(:),G1H6(31),m3h2x6(:,132),heltab2x12(:,:,132))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(102),n2h6(24))
  call Hloop_AV_Q(ntryL,G1H12(91),ex3(:),G1H6(31),m3h2x6(:,133),heltab2x12(:,:,133))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(103),n2h6(25))
  call Hloop_AV_Q(ntryL,G1H12(93),ex3(:),G1H6(31),m3h2x6(:,134),heltab2x12(:,:,134))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(104),n2h6(26))
  call Hotf_5pt_reduction(G2H12(94),RedSet_5(2),mass5set(:,11),  & 
G1H12(81),G1H12(82),G1H12(83),G1H12(84),G1H12(85),G1H12(88),12)
  call HG1shiftOLR(G1H12(82),8,12)
  call Hotf_5pt_reduction(G2H12(95),RedSet_5(2),mass5set(:,9),  & 
G1H12(89),G1H12(90),G1H12(91),G1H12(93),G1H12(152),G1H12(153),12)
  call HG1shiftOLR(G1H12(90),8,12)
  call Hotf_5pt_reduction(G2H12(96),RedSet_5(2),mass5set(:,12),  & 
G1H12(154),G1H12(155),G1H12(156),G1H12(157),G1H12(158),G1H12(159),12)
  call HG1shiftOLR(G1H12(155),8,12)
  call Hotf_5pt_reduction(G2H12(97),RedSet_5(2),mass5set(:,7),  & 
G1H12(160),G1H12(161),G1H12(162),G1H12(163),G1H12(164),G1H12(165),12)
  call HG1shiftOLR(G1H12(161),8,12)
  call Hloop_SV_T(ntryL,G1H12(95),18,ex4(:),8,G2H4(1),m3h3x4(:,1),heltab2x12(:,:,135))
  call Hloop_SV_T(ntryL,G1H12(96),18,ex4(:),8,G2H4(2),m3h3x4(:,2),heltab2x12(:,:,136))
  call Hotf_5pt_reduction(G2H12(98),RedSet_5(3),mass5set(:,13),  & 
G1H12(95),G1H12(96),G1H12(166),G1H12(167),G1H12(168),G1H12(169),12)
  call HG1shiftOLR(G1H12(96),4,12)
  call Hotf_5pt_reduction(G2H12(99),RedSet_5(3),mass5set(:,14),  & 
G1H12(170),G1H12(171),G1H12(172),G1H12(173),G1H12(174),G1H12(175),12)
  call HG1shiftOLR(G1H12(171),4,12)
  call Hloop_VV_S(ntryL,G1H12(97),ex4(:),G1H4(1),m3h3x4(:,3),heltab2x12(:,:,137))
  call Hloop_SV_V(ntryL,G1H12(98),ex4(:),G1H4(2),m3h3x4(:,4),heltab2x12(:,:,138))
  call Hloop_SV_V(ntryL,G1H12(99),ex4(:),G1H4(3),m3h3x4(:,5),heltab2x12(:,:,139))
  call Hloop_AW_Q(ntryL,G1H12(100),ex4(:),G1H4(4),m3h3x4(:,6),heltab2x12(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(4),26,nMT,G2H4(3),n2h4(1))
  call Hloop_AW_Q(ntryL,G1H12(101),ex4(:),G1H4(4),m3h3x4(:,7),heltab2x12(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(4),26,nMT,G2H4(4),n2h4(2))
  call Hotf_5pt_reduction(G2H12(100),RedSet_5(3),mass5set(:,13),  & 
G1H12(97),G1H12(98),G1H12(99),G1H12(100),G1H12(101),G1H12(176),12)
  call HG1shiftOLR(G1H12(98),4,12)
  call Hotf_5pt_reduction(G2H12(101),RedSet_5(3),mass5set(:,14),  & 
G1H12(177),G1H12(178),G1H12(179),G1H12(180),G1H12(181),G1H12(182),12)
  call HG1shiftOLR(G1H12(178),4,12)
  call Hloop_UV_W(ntryL,G1H12(103),18,ex4(:),8,G2H4(5),m3h3x4(:,8),heltab2x12(:,:,142))
  call Hloop_UV_W(ntryL,G1H12(104),18,ex4(:),8,G2H4(6),m3h3x4(:,9),heltab2x12(:,:,143))
  call Hotf_5pt_reduction(G2H12(102),RedSet_5(3),mass5set(:,15),  & 
G1H12(103),G1H12(104),G1H12(183),G1H12(184),G1H12(185),G1H12(186),12)
  call HG1shiftOLR(G1H12(104),4,12)
  call Hotf_5pt_reduction(G2H12(103),RedSet_5(3),mass5set(:,14),  & 
G1H12(187),G1H12(188),G1H12(189),G1H12(190),G1H12(191),G1H12(192),12)
  call HG1shiftOLR(G1H12(188),4,12)
  call Hloop_AW_Q(ntryL,G1H12(105),ex4(:),G1H4(4),m3h3x4(:,10),heltab2x12(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(4),26,nMT,G2H4(7),n2h4(3))
  call Hloop_AW_Q(ntryL,G1H12(106),ex4(:),G1H4(4),m3h3x4(:,11),heltab2x12(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(4),26,nMT,G2H4(8),n2h4(4))
  call Hotf_5pt_reduction(G2H12(104),RedSet_5(3),mass5set(:,15),  & 
G1H12(105),G1H12(106),G1H12(193),G1H12(194),G1H12(195),G1H12(196),12)
  call HG1shiftOLR(G1H12(106),4,12)
  call Hotf_5pt_reduction(G2H12(105),RedSet_5(3),mass5set(:,14),  & 
G1H12(197),G1H12(198),G1H12(199),G1H12(200),G1H12(201),G1H12(202),12)
  call HG1shiftOLR(G1H12(198),4,12)
  call Hotf_5pt_reduction(G2H12(106),RedSet_5(4),mass5set(:,4),  & 
G1H12(203),G1H12(204),G1H12(205),G1H12(206),G1H12(207),G1H12(208),12)
  call HG1shiftOLR(G1H12(204),8,12)
  call Hotf_5pt_reduction(G2H12(107),RedSet_5(4),mass5set(:,6),  & 
G1H12(209),G1H12(210),G1H12(211),G1H12(212),G1H12(213),G1H12(214),12)
  call HG1shiftOLR(G1H12(210),8,12)
  call Hotf_5pt_reduction(G2H12(108),RedSet_5(4),mass5set(:,5),  & 
G1H12(215),G1H12(216),G1H12(217),G1H12(218),G1H12(219),G1H12(220),12)
  call HG1shiftOLR(G1H12(216),8,12)
  call Hotf_5pt_reduction(G2H12(109),RedSet_5(4),mass5set(:,7),  & 
G1H12(221),G1H12(222),G1H12(223),G1H12(224),G1H12(225),G1H12(226),12)
  call HG1shiftOLR(G1H12(222),8,12)
  call Hotf_5pt_reduction(G2H12(110),RedSet_5(4),mass5set(:,16),  & 
G1H12(227),G1H12(228),G1H12(229),G1H12(230),G1H12(231),G1H12(232),12)
  call HG1shiftOLR(G1H12(228),8,12)
  call Hotf_5pt_reduction(G2H12(111),RedSet_5(4),mass5set(:,17),  & 
G1H12(233),G1H12(234),G1H12(235),G1H12(236),G1H12(237),G1H12(238),12)
  call HG1shiftOLR(G1H12(234),8,12)
  call Hotf_5pt_reduction(G2H12(118),RedSet_5(4),mass5set(:,18),  & 
G1H12(239),G1H12(240),G1H12(241),G1H12(242),G1H12(243),G1H12(244),12)
  call HG1shiftOLR(G1H12(240),8,12)
  call Hotf_5pt_reduction(G2H12(120),RedSet_5(4),mass5set(:,17),  & 
G1H12(245),G1H12(246),G1H12(247),G1H12(248),G1H12(249),G1H12(250),12)
  call HG1shiftOLR(G1H12(246),8,12)
  call Hloop_QV_A(ntryL,G1H12(110),ex3(:),G1H6(31),m3h2x6(:,135),heltab2x12(:,:,146))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMB,G2H6(105),n2h6(27))
  call Hotf_5pt_reduction(G2H12(112),RedSet_5(4),mass5set(:,8),  & 
G1H12(110),G1H12(251),G1H12(252),G1H12(253),G1H12(254),G1H12(255),12)
  call HG1shiftOLR(G1H12(251),8,12)
  call Hotf_5pt_reduction(G2H12(113),RedSet_5(4),mass5set(:,9),  & 
G1H12(256),G1H12(257),G1H12(258),G1H12(259),G1H12(260),G1H12(261),12)
  call HG1shiftOLR(G1H12(257),8,12)
  call Hotf_5pt_reduction(G2H12(114),RedSet_5(4),mass5set(:,6),  & 
G1H12(262),G1H12(263),G1H12(264),G1H12(265),G1H12(266),G1H12(267),12)
  call HG1shiftOLR(G1H12(263),8,12)
  call Hotf_5pt_reduction(G2H12(115),RedSet_5(4),mass5set(:,7),  & 
G1H12(268),G1H12(269),G1H12(270),G1H12(271),G1H12(272),G1H12(273),12)
  call HG1shiftOLR(G1H12(269),8,12)
  call Hotf_5pt_reduction(G2H12(116),RedSet_5(4),mass5set(:,16),  & 
G1H12(274),G1H12(275),G1H12(276),G1H12(277),G1H12(278),G1H12(279),12)
  call HG1shiftOLR(G1H12(275),8,12)
  call Hloop_QV_A(ntryL,G1H12(111),ex3(:),G1H6(31),m3h2x6(:,136),heltab2x12(:,:,147))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMB,G2H6(106),n2h6(28))
  call Hloop_QV_A(ntryL,G1H12(112),ex3(:),G1H6(31),m3h2x6(:,137),heltab2x12(:,:,148))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMB,G2H6(107),n2h6(29))
  call Hloop_QV_A(ntryL,G1H12(116),ex3(:),G1H6(31),m3h2x6(:,138),heltab2x12(:,:,149))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMB,G2H6(108),n2h6(30))
  call Hotf_5pt_reduction(G2H12(125),RedSet_5(4),mass5set(:,18),  & 
G1H12(111),G1H12(112),G1H12(116),G1H12(280),G1H12(281),G1H12(282),12)
  call HG1shiftOLR(G1H12(112),8,12)
  call Hloop_QV_A(ntryL,G1H12(118),ex3(:),G1H6(31),m3h2x6(:,139),heltab2x12(:,:,150))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMB,G2H6(109),n2h6(31))
  call Hotf_5pt_reduction(G2H12(126),RedSet_5(4),mass5set(:,17),  & 
G1H12(118),G1H12(283),G1H12(284),G1H12(285),G1H12(286),G1H12(287),12)
  call HG1shiftOLR(G1H12(283),8,12)
  call Hotf_5pt_reduction(G2H12(117),RedSet_5(4),mass5set(:,10),  & 
G1H12(288),G1H12(289),G1H12(290),G1H12(291),G1H12(292),G1H12(293),12)
  call HG1shiftOLR(G1H12(289),8,12)
  call Hotf_5pt_reduction(G2H12(119),RedSet_5(4),mass5set(:,5),  & 
G1H12(294),G1H12(295),G1H12(296),G1H12(297),G1H12(298),G1H12(299),12)
  call HG1shiftOLR(G1H12(295),8,12)
  call Hloop_QV_A(ntryL,G1H12(120),ex3(:),G1H6(31),m3h2x6(:,140),heltab2x12(:,:,151))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMB,G2H6(110),n2h6(32))
  call Hloop_QV_A(ntryL,G1H12(121),ex3(:),G1H6(31),m3h2x6(:,141),heltab2x12(:,:,152))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMB,G2H6(111),n2h6(33))
  call Hotf_5pt_reduction(G2H12(121),RedSet_5(4),mass5set(:,11),  & 
G1H12(120),G1H12(121),G1H12(300),G1H12(301),G1H12(302),G1H12(303),12)
  call HG1shiftOLR(G1H12(121),8,12)
  call Hotf_5pt_reduction(G2H12(122),RedSet_5(4),mass5set(:,12),  & 
G1H12(304),G1H12(305),G1H12(306),G1H12(307),G1H12(308),G1H12(309),12)
  call HG1shiftOLR(G1H12(305),8,12)
  call Hotf_5pt_reduction(G2H12(123),RedSet_5(4),mass5set(:,9),  & 
G1H12(310),G1H12(311),G1H12(312),G1H12(313),G1H12(314),G1H12(315),12)
  call HG1shiftOLR(G1H12(311),8,12)
  call Hotf_5pt_reduction(G2H12(124),RedSet_5(4),mass5set(:,7),  & 
G1H12(316),G1H12(317),G1H12(318),G1H12(319),G1H12(320),G1H12(321),12)
  call HG1shiftOLR(G1H12(317),8,12)
  call Hotf_5pt_reduction(G2H12(127),RedSet_5(5),mass5set(:,19),  & 
G1H12(322),G1H12(323),G1H12(324),G1H12(325),G1H12(326),G1H12(327),12)
  call HG1shiftOLR(G1H12(323),2,12)
  call Hotf_5pt_reduction(G2H12(128),RedSet_5(5),mass5set(:,20),  & 
G1H12(328),G1H12(329),G1H12(330),G1H12(331),G1H12(332),G1H12(333),12)
  call HG1shiftOLR(G1H12(329),2,12)
  call Hotf_5pt_reduction(G2H12(129),RedSet_5(5),mass5set(:,21),  & 
G1H12(334),G1H12(335),G1H12(336),G1H12(337),G1H12(338),G1H12(339),12)
  call HG1shiftOLR(G1H12(335),2,12)
  call Hotf_5pt_reduction(G2H12(130),RedSet_5(5),mass5set(:,20),  & 
G1H12(340),G1H12(341),G1H12(342),G1H12(343),G1H12(344),G1H12(345),12)
  call HG1shiftOLR(G1H12(341),2,12)
  call Hloop_TV_S(ntryL,G1H12(128),17,ex4(:),8,G2H4(9),m3h3x4(:,12),heltab2x12(:,:,153))
  call Hloop_TV_S(ntryL,G1H12(129),17,ex4(:),8,G2H4(10),m3h3x4(:,13),heltab2x12(:,:,154))
  call Hloop_SV_V(ntryL,G1H12(130),ex4(:),G1H4(4),m3h3x4(:,14),heltab2x12(:,:,155))
  call Hloop_VV_S(ntryL,G1H12(131),ex4(:),G1H4(5),m3h3x4(:,15),heltab2x12(:,:,156))
  call Hloop_VV_S(ntryL,G1H12(132),ex4(:),G1H4(6),m3h3x4(:,16),heltab2x12(:,:,157))
  call Hloop_UW_V(ntryL,G1H12(133),17,ex4(:),8,G2H4(11),m3h3x4(:,17),heltab2x12(:,:,158))
  call Hloop_UW_V(ntryL,G1H12(134),17,ex4(:),8,G2H4(12),m3h3x4(:,18),heltab2x12(:,:,159))
  call Hotf_5pt_reduction(G2H12(131),RedSet_5(6),mass5set(:,22),  & 
G1H12(128),G1H12(129),G1H12(130),G1H12(131),G1H12(132),G1H12(133),12)
  call HG1shiftOLR(G1H12(129),2,12)
  call Hotf_5pt_reduction(G2H12(132),RedSet_5(6),mass5set(:,23),  & 
G1H12(134),G1H12(346),G1H12(347),G1H12(348),G1H12(349),G1H12(350),12)
  call HG1shiftOLR(G1H12(346),2,12)
  call Hloop_TV_S(ntryL,G1H12(135),17,ex4(:),8,G2H4(13),m3h3x4(:,19),heltab2x12(:,:,160))
  call Hloop_TV_S(ntryL,G1H12(136),17,ex4(:),8,G2H4(14),m3h3x4(:,20),heltab2x12(:,:,161))
  call Hotf_5pt_reduction(G2H12(133),RedSet_5(6),mass5set(:,24),  & 
G1H12(135),G1H12(136),G1H12(351),G1H12(352),G1H12(353),G1H12(354),12)
  call HG1shiftOLR(G1H12(136),2,12)
  call Hotf_5pt_reduction(G2H12(134),RedSet_5(6),mass5set(:,23),  & 
G1H12(355),G1H12(356),G1H12(357),G1H12(358),G1H12(359),G1H12(360),12)
  call HG1shiftOLR(G1H12(356),2,12)
  call Hloop_SV_V(ntryL,G1H12(140),ex4(:),G1H4(7),m3h3x4(:,21),heltab2x12(:,:,162))
  call Hloop_TV_S(ntryL,G1H12(141),17,ex4(:),8,G2H4(15),m3h3x4(:,22),heltab2x12(:,:,163))
  call Hloop_TV_S(ntryL,G1H12(142),17,ex4(:),8,G2H4(16),m3h3x4(:,23),heltab2x12(:,:,164))
  call Hloop_VV_S(ntryL,G1H12(143),ex4(:),G1H4(8),m3h3x4(:,24),heltab2x12(:,:,165))
  call Hloop_VV_S(ntryL,G1H12(144),ex4(:),G1H4(9),m3h3x4(:,25),heltab2x12(:,:,166))
  call Hloop_SV_V(ntryL,G1H12(145),ex4(:),G1H4(10),m3h3x4(:,26),heltab2x12(:,:,167))
  call Hloop_UW_V(ntryL,G1H12(146),17,ex4(:),8,G2H4(17),m3h3x4(:,27),heltab2x12(:,:,168))
  call Hloop_UW_V(ntryL,G1H12(147),17,ex4(:),8,G2H4(18),m3h3x4(:,28),heltab2x12(:,:,169))
  call Hloop_VV_S(ntryL,G1H12(148),ex4(:),G1H4(11),m3h3x4(:,29),heltab2x12(:,:,170))
  call Hloop_VV_S(ntryL,G1H12(149),ex4(:),G1H4(12),m3h3x4(:,30),heltab2x12(:,:,171))
  call Hloop_UW_V(ntryL,G1H12(150),17,ex4(:),8,G2H4(19),m3h3x4(:,31),heltab2x12(:,:,172))
  call Hloop_UW_V(ntryL,G1H12(151),17,ex4(:),8,G2H4(20),m3h3x4(:,32),heltab2x12(:,:,173))
  call Hloop_SQ_A(ntryL,G1H12(1),ex1(:),G1H6(31),ngPtb,m3h2x6(:,142),heltab2x12(:,:,174))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(112),n2h6(34))
call HGT_OLR(G1H12(2),1,1,12)
call HGT_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(2),-8,ex4(:),8,G2H4(21),m3h3x4(:,33),heltab2x12(:,:,175))
  call Hloop_SQ_A(ntryL,G1H12(7),ex1(:),G1H6(31),ngPtb,m3h2x6(:,143),heltab2x12(:,:,176))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(113),n2h6(35))
  call Hloop_SQ_A(ntryL,G1H12(8),ex1(:),G1H6(31),ngPtb,m3h2x6(:,144),heltab2x12(:,:,177))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(114),n2h6(36))
  call Hloop_SQ_A(ntryL,G1H12(10),ex1(:),G1H6(31),ngPtb,m3h2x6(:,145),heltab2x12(:,:,178))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(115),n2h6(37))
  call Hloop_SQ_A(ntryL,G1H12(22),ex1(:),G1H6(31),ngPtb,m3h2x6(:,146),heltab2x12(:,:,179))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(116),n2h6(38))
call HGT_OLR(G1H12(23),1,1,12)
call HGT_invQ_OLR(G1H12(23),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(23),-8,ex4(:),8,G2H4(22),m3h3x4(:,34),heltab2x12(:,:,180))
  call Hloop_SQ_A(ntryL,G1H12(30),ex1(:),G1H6(31),ngPtb,m3h2x6(:,147),heltab2x12(:,:,181))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(117),n2h6(39))
  call Hloop_SQ_A(ntryL,G1H12(32),ex1(:),G1H6(31),ngPtb,m3h2x6(:,148),heltab2x12(:,:,182))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(118),n2h6(40))
  call Hloop_SQ_A(ntryL,G1H12(36),ex1(:),G1H6(31),ngPtb,m3h2x6(:,149),heltab2x12(:,:,183))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(119),n2h6(41))
  call Hloop_SQ_A(ntryL,G1H12(38),ex1(:),G1H6(31),ngPtb,m3h2x6(:,150),heltab2x12(:,:,184))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(120),n2h6(42))
call HGT_OLR(G1H12(45),1,1,12)
call HGT_invQ_OLR(G1H12(45),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(45),ex4(:),G1H4(13),m3h3x4(:,35),heltab2x12(:,:,185))
  call Hloop_SQ_A(ntryL,G1H12(44),ex1(:),G1H6(31),ngPtb,m3h2x6(:,151),heltab2x12(:,:,186))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(121),n2h6(43))
  call Hloop_SQ_A(ntryL,G1H12(50),ex1(:),G1H6(31),ngPtb,m3h2x6(:,152),heltab2x12(:,:,187))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(122),n2h6(44))
  call Hloop_SQ_A(ntryL,G1H12(51),ex1(:),G1H6(31),ngPtb,m3h2x6(:,153),heltab2x12(:,:,188))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(123),n2h6(45))
  call Hloop_WQ_A(ntryL,G1H12(46),ex1(:),G1H6(31),m3h2x6(:,154),heltab2x12(:,:,189))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(124),n2h6(46))
call HGT_raise_alpha_OLR(G1H12(47),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(47),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(47),ex4(:),G1H4(14),m3h3x4(:,36),heltab2x12(:,:,190))
  call Hloop_WQ_A(ntryL,G1H12(49),ex1(:),G1H6(31),m3h2x6(:,155),heltab2x12(:,:,191))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(125),n2h6(47))
  call Hloop_WQ_A(ntryL,G1H12(54),ex1(:),G1H6(31),m3h2x6(:,156),heltab2x12(:,:,192))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(126),n2h6(48))
  call Hloop_WQ_A(ntryL,G1H12(52),ex1(:),G1H6(31),m3h2x6(:,157),heltab2x12(:,:,193))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(127),n2h6(49))
  call Hloop_WQ_A(ntryL,G1H12(53),ex1(:),G1H6(31),m3h2x6(:,158),heltab2x12(:,:,194))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(128),n2h6(50))
call HGT_raise_alpha_OLR(G1H12(63),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(63),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(63),ex4(:),G1H4(15),m3h3x4(:,37),heltab2x12(:,:,195))
  call Hloop_WQ_A(ntryL,G1H12(69),ex1(:),G1H6(31),m3h2x6(:,159),heltab2x12(:,:,196))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(129),n2h6(51))
  call Hloop_WQ_A(ntryL,G1H12(72),ex1(:),G1H6(31),m3h2x6(:,160),heltab2x12(:,:,197))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(130),n2h6(52))
  call Hloop_WQ_A(ntryL,G1H12(73),ex1(:),G1H6(31),m3h2x6(:,161),heltab2x12(:,:,198))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(131),n2h6(53))
  call Hloop_WQ_A(ntryL,G1H12(78),ex1(:),G1H6(31),m3h2x6(:,162),heltab2x12(:,:,199))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(132),n2h6(54))
call HGT_raise_alpha_OLR(G1H12(79),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(79),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(79),-8,ex4(:),8,G2H4(23),m3h3x4(:,38),heltab2x12(:,:,200))
  call Hloop_WQ_A(ntryL,G1H12(87),ex1(:),G1H6(31),m3h2x6(:,163),heltab2x12(:,:,201))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(133),n2h6(55))
  call Hloop_WQ_A(ntryL,G1H12(92),ex1(:),G1H6(31),m3h2x6(:,164),heltab2x12(:,:,202))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(134),n2h6(56))
  call Hloop_WQ_A(ntryL,G1H12(94),ex1(:),G1H6(31),m3h2x6(:,165),heltab2x12(:,:,203))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(135),n2h6(57))
  call Hloop_WQ_A(ntryL,G1H12(102),ex1(:),G1H6(31),m3h2x6(:,166),heltab2x12(:,:,204))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(136),n2h6(58))
call HGT_raise_alpha_OLR(G1H12(107),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(107),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(107),-8,ex4(:),8,G2H4(24),m3h3x4(:,39),heltab2x12(:,:,205))
  call Hloop_WQ_A(ntryL,G1H12(114),ex1(:),G1H6(31),m3h2x6(:,167),heltab2x12(:,:,206))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(137),n2h6(59))
  call Hloop_WQ_A(ntryL,G1H12(115),ex1(:),G1H6(31),m3h2x6(:,168),heltab2x12(:,:,207))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(138),n2h6(60))
  call Hloop_WQ_A(ntryL,G1H12(108),ex1(:),G1H6(31),m3h2x6(:,169),heltab2x12(:,:,208))
  call Hloop_Q_A(ntryL,G1H6(31),21,nMT,G2H6(139),n2h6(61))
  call Hloop_AV_Q(ntryL,G1H12(109),ex3(:),G1H6(31),m3h2x6(:,170),heltab2x12(:,:,209))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(140),n2h6(62))
call HGT_OLR(G1H12(122),1,1,12)
call HGT_invQ_OLR(G1H12(122),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(122),-8,ex4(:),8,G2H4(25),m3h3x4(:,40),heltab2x12(:,:,210))
  call Hloop_AV_Q(ntryL,G1H12(124),ex3(:),G1H6(31),m3h2x6(:,171),heltab2x12(:,:,211))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(141),n2h6(63))
  call Hloop_AV_Q(ntryL,G1H12(117),ex3(:),G1H6(31),m3h2x6(:,172),heltab2x12(:,:,212))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(142),n2h6(64))
  call Hloop_AV_Q(ntryL,G1H12(119),ex3(:),G1H6(31),m3h2x6(:,173),heltab2x12(:,:,213))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(143),n2h6(65))
  call Hloop_AV_Q(ntryL,G1H12(127),ex3(:),G1H6(31),m3h2x6(:,174),heltab2x12(:,:,214))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(144),n2h6(66))
call HGT_OLR(G1H12(125),1,1,12)
call HGT_invQ_OLR(G1H12(125),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(125),-8,ex4(:),8,G2H4(26),m3h3x4(:,41),heltab2x12(:,:,215))
  call Hloop_AV_Q(ntryL,G1H12(139),ex3(:),G1H6(31),m3h2x6(:,175),heltab2x12(:,:,216))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(145),n2h6(67))
  call Hloop_AV_Q(ntryL,G1H12(137),ex3(:),G1H6(31),m3h2x6(:,176),heltab2x12(:,:,217))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(146),n2h6(68))
  call Hloop_AV_Q(ntryL,G1H12(138),ex3(:),G1H6(31),m3h2x6(:,177),heltab2x12(:,:,218))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(147),n2h6(69))
  call Hloop_AV_Q(ntryL,G1H12(5),ex3(:),G1H6(31),m3h2x6(:,178),heltab2x12(:,:,219))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(148),n2h6(70))
call HGT_OLR(G1H12(6),1,1,12)
call HGT_invQ_OLR(G1H12(6),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(6),-8,ex4(:),8,G2H4(27),m3h3x4(:,42),heltab2x12(:,:,220))
  call Hloop_AV_Q(ntryL,G1H12(4),ex3(:),G1H6(31),m3h2x6(:,179),heltab2x12(:,:,221))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(149),n2h6(71))
  call Hloop_AV_Q(ntryL,G1H12(11),ex3(:),G1H6(31),m3h2x6(:,180),heltab2x12(:,:,222))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(150),n2h6(72))
  call Hloop_AV_Q(ntryL,G1H12(12),ex3(:),G1H6(31),m3h2x6(:,181),heltab2x12(:,:,223))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(151),n2h6(73))
  call Hloop_AV_Q(ntryL,G1H12(13),ex3(:),G1H6(31),m3h2x6(:,182),heltab2x12(:,:,224))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(152),n2h6(74))
call HGT_OLR(G1H12(14),1,1,12)
call HGT_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(14),-8,ex4(:),8,G2H4(28),m3h3x4(:,43),heltab2x12(:,:,225))
  call Hloop_AV_Q(ntryL,G1H12(16),ex3(:),G1H6(31),m3h2x6(:,183),heltab2x12(:,:,226))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(153),n2h6(75))
  call Hloop_AV_Q(ntryL,G1H12(17),ex3(:),G1H6(31),m3h2x6(:,184),heltab2x12(:,:,227))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(154),n2h6(76))
  call Hloop_AV_Q(ntryL,G1H12(18),ex3(:),G1H6(31),m3h2x6(:,185),heltab2x12(:,:,228))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(155),n2h6(77))
  call Hloop_AV_Q(ntryL,G1H12(19),ex3(:),G1H6(31),m3h2x6(:,186),heltab2x12(:,:,229))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(156),n2h6(78))
call HGT_OLR(G1H12(20),1,1,12)
call HGT_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(20),ex4(:),G1H4(16),m3h3x4(:,44),heltab2x12(:,:,230))
  call Hloop_AV_Q(ntryL,G1H12(24),ex3(:),G1H6(31),m3h2x6(:,187),heltab2x12(:,:,231))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(157),n2h6(79))
  call Hloop_AV_Q(ntryL,G1H12(25),ex3(:),G1H6(31),m3h2x6(:,188),heltab2x12(:,:,232))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(158),n2h6(80))
  call Hloop_AV_Q(ntryL,G1H12(27),ex3(:),G1H6(31),m3h2x6(:,189),heltab2x12(:,:,233))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(159),n2h6(81))
  call Hloop_AV_Q(ntryL,G1H12(28),ex3(:),G1H6(31),m3h2x6(:,190),heltab2x12(:,:,234))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(160),n2h6(82))
call HGT_OLR(G1H12(29),1,1,12)
call HGT_invQ_OLR(G1H12(29),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(29),ex4(:),G1H4(17),m3h3x4(:,45),heltab2x12(:,:,235))
  call Hloop_AV_Q(ntryL,G1H12(33),ex3(:),G1H6(31),m3h2x6(:,191),heltab2x12(:,:,236))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(161),n2h6(83))
  call Hloop_AV_Q(ntryL,G1H12(34),ex3(:),G1H6(31),m3h2x6(:,192),heltab2x12(:,:,237))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(162),n2h6(84))
  call Hloop_AV_Q(ntryL,G1H12(35),ex3(:),G1H6(31),m3h2x6(:,193),heltab2x12(:,:,238))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(163),n2h6(85))
  call Hloop_AV_Q(ntryL,G1H12(37),ex3(:),G1H6(31),m3h2x6(:,194),heltab2x12(:,:,239))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(164),n2h6(86))
call HGT_OLR(G1H12(39),1,1,12)
call HGT_invQ_OLR(G1H12(39),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(39),ex4(:),G1H4(18),m3h3x4(:,46),heltab2x12(:,:,240))
  call Hloop_AV_Q(ntryL,G1H12(41),ex3(:),G1H6(31),m3h2x6(:,195),heltab2x12(:,:,241))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(165),n2h6(87))
  call Hloop_AV_Q(ntryL,G1H12(42),ex3(:),G1H6(31),m3h2x6(:,196),heltab2x12(:,:,242))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(166),n2h6(88))
  call Hloop_AV_Q(ntryL,G1H12(55),ex3(:),G1H6(31),m3h2x6(:,197),heltab2x12(:,:,243))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(167),n2h6(89))
  call Hloop_AV_Q(ntryL,G1H12(56),ex3(:),G1H6(31),m3h2x6(:,198),heltab2x12(:,:,244))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(168),n2h6(90))
call HGT_OLR(G1H12(57),1,1,12)
call HGT_invQ_OLR(G1H12(57),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(57),ex4(:),G1H4(19),m3h3x4(:,47),heltab2x12(:,:,245))
  call Hloop_AV_Q(ntryL,G1H12(59),ex3(:),G1H6(31),m3h2x6(:,199),heltab2x12(:,:,246))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(169),n2h6(91))
  call Hloop_AV_Q(ntryL,G1H12(60),ex3(:),G1H6(31),m3h2x6(:,200),heltab2x12(:,:,247))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(170),n2h6(92))
  call Hloop_AV_Q(ntryL,G1H12(61),ex3(:),G1H6(31),m3h2x6(:,201),heltab2x12(:,:,248))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(171),n2h6(93))
  call Hloop_AV_Q(ntryL,G1H12(62),ex3(:),G1H6(31),m3h2x6(:,202),heltab2x12(:,:,249))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(172),n2h6(94))
call HGT_raise_alpha_OLR(G1H12(65),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(65),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(65),ex4(:),G1H4(20),m3h3x4(:,48),heltab2x12(:,:,250))
  call Hloop_AV_Q(ntryL,G1H12(67),ex3(:),G1H6(31),m3h2x6(:,203),heltab2x12(:,:,251))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(173),n2h6(95))
  call Hloop_AV_Q(ntryL,G1H12(68),ex3(:),G1H6(31),m3h2x6(:,204),heltab2x12(:,:,252))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(174),n2h6(96))
  call Hloop_AV_Q(ntryL,G1H12(70),ex3(:),G1H6(31),m3h2x6(:,205),heltab2x12(:,:,253))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(175),n2h6(97))
  call Hloop_AV_Q(ntryL,G1H12(71),ex3(:),G1H6(31),m3h2x6(:,206),heltab2x12(:,:,254))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(176),n2h6(98))
call HGT_raise_alpha_OLR(G1H12(74),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(74),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(74),ex4(:),G1H4(21),m3h3x4(:,49),heltab2x12(:,:,255))
  call Hloop_AV_Q(ntryL,G1H12(76),ex3(:),G1H6(31),m3h2x6(:,207),heltab2x12(:,:,256))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(177),n2h6(99))
  call Hloop_AV_Q(ntryL,G1H12(77),ex3(:),G1H6(31),m3h2x6(:,208),heltab2x12(:,:,257))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(178),n2h6(100))
  call Hloop_AV_Q(ntryL,G1H12(80),ex3(:),G1H6(31),m3h2x6(:,209),heltab2x12(:,:,258))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(179),n2h6(101))
  call Hloop_AV_Q(ntryL,G1H12(81),ex3(:),G1H6(31),m3h2x6(:,210),heltab2x12(:,:,259))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(180),n2h6(102))
call HGT_raise_alpha_OLR(G1H12(82),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(82),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(82),-8,ex4(:),8,G2H4(29),m3h3x4(:,50),heltab2x12(:,:,260))
  call Hloop_AV_Q(ntryL,G1H12(84),ex3(:),G1H6(31),m3h2x6(:,211),heltab2x12(:,:,261))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(181),n2h6(103))
  call Hloop_AV_Q(ntryL,G1H12(85),ex3(:),G1H6(31),m3h2x6(:,212),heltab2x12(:,:,262))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(182),n2h6(104))
  call Hloop_AV_Q(ntryL,G1H12(88),ex3(:),G1H6(31),m3h2x6(:,213),heltab2x12(:,:,263))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(183),n2h6(105))
  call Hloop_AV_Q(ntryL,G1H12(89),ex3(:),G1H6(31),m3h2x6(:,214),heltab2x12(:,:,264))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(184),n2h6(106))
call HGT_raise_alpha_OLR(G1H12(90),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(90),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(90),-8,ex4(:),8,G2H4(30),m3h3x4(:,51),heltab2x12(:,:,265))
  call Hloop_AV_Q(ntryL,G1H12(93),ex3(:),G1H6(31),m3h2x6(:,215),heltab2x12(:,:,266))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(185),n2h6(107))
  call Hloop_AV_Q(ntryL,G1H12(152),ex3(:),G1H6(31),m3h2x6(:,216),heltab2x12(:,:,267))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(186),n2h6(108))
  call Hloop_AV_Q(ntryL,G1H12(153),ex3(:),G1H6(31),m3h2x6(:,217),heltab2x12(:,:,268))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(187),n2h6(109))
  call Hloop_AV_Q(ntryL,G1H12(154),ex3(:),G1H6(31),m3h2x6(:,218),heltab2x12(:,:,269))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(188),n2h6(110))
call HGT_raise_alpha_OLR(G1H12(155),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(155),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(155),-8,ex4(:),8,G2H4(31),m3h3x4(:,52),heltab2x12(:,:,270))
  call Hloop_AV_Q(ntryL,G1H12(157),ex3(:),G1H6(31),m3h2x6(:,219),heltab2x12(:,:,271))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(189),n2h6(111))
  call Hloop_AV_Q(ntryL,G1H12(158),ex3(:),G1H6(31),m3h2x6(:,220),heltab2x12(:,:,272))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(190),n2h6(112))
  call Hloop_AV_Q(ntryL,G1H12(159),ex3(:),G1H6(31),m3h2x6(:,221),heltab2x12(:,:,273))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(191),n2h6(113))
  call Hloop_AV_Q(ntryL,G1H12(160),ex3(:),G1H6(31),m3h2x6(:,222),heltab2x12(:,:,274))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(192),n2h6(114))
call HGT_raise_alpha_OLR(G1H12(161),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(161),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(161),-8,ex4(:),8,G2H4(32),m3h3x4(:,53),heltab2x12(:,:,275))
  call Hloop_AV_Q(ntryL,G1H12(163),ex3(:),G1H6(31),m3h2x6(:,223),heltab2x12(:,:,276))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(193),n2h6(115))
  call Hloop_AV_Q(ntryL,G1H12(164),ex3(:),G1H6(31),m3h2x6(:,224),heltab2x12(:,:,277))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(194),n2h6(116))
  call Hloop_AV_Q(ntryL,G1H12(165),ex3(:),G1H6(31),m3h2x6(:,225),heltab2x12(:,:,278))
  call Hloop_A_Q(ntryL,G1H6(31),22,nMB,G2H6(195),n2h6(117))
  call Hloop_AW_Q(ntryL,G1H12(95),ex4(:),G1H4(22),m3h3x4(:,54),heltab2x12(:,:,279))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(33),n2h4(5))
call HGT_OLR(G1H12(96),1,1,12)
call HGT_invQ_OLR(G1H12(96),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(96),-4,ex3(:),4,G2H6(196),m3h2x6(:,226),heltab2x12(:,:,280))
  call Hloop_AW_Q(ntryL,G1H12(167),ex4(:),G1H4(22),m3h3x4(:,55),heltab2x12(:,:,281))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(34),n2h4(6))
  call Hloop_AW_Q(ntryL,G1H12(168),ex4(:),G1H4(22),m3h3x4(:,56),heltab2x12(:,:,282))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(35),n2h4(7))
  call Hloop_AW_Q(ntryL,G1H12(169),ex4(:),G1H4(22),m3h3x4(:,57),heltab2x12(:,:,283))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(36),n2h4(8))
  call Hloop_AW_Q(ntryL,G1H12(170),ex4(:),G1H4(22),m3h3x4(:,58),heltab2x12(:,:,284))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(37),n2h4(9))
call HGT_OLR(G1H12(171),1,1,12)
call HGT_invQ_OLR(G1H12(171),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(171),-4,ex3(:),4,G2H6(197),m3h2x6(:,227),heltab2x12(:,:,285))
  call Hloop_AW_Q(ntryL,G1H12(173),ex4(:),G1H4(22),m3h3x4(:,59),heltab2x12(:,:,286))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(38),n2h4(10))
  call Hloop_AW_Q(ntryL,G1H12(174),ex4(:),G1H4(22),m3h3x4(:,60),heltab2x12(:,:,287))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(39),n2h4(11))
  call Hloop_AW_Q(ntryL,G1H12(175),ex4(:),G1H4(22),m3h3x4(:,61),heltab2x12(:,:,288))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(40),n2h4(12))
  call Hloop_AW_Q(ntryL,G1H12(97),ex4(:),G1H4(22),m3h3x4(:,62),heltab2x12(:,:,289))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(41),n2h4(13))
call HGT_OLR(G1H12(98),1,1,12)
call HGT_invQ_OLR(G1H12(98),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(98),ex3(:),G1H6(31),m3h2x6(:,228),heltab2x12(:,:,290))
  call Hloop_AW_Q(ntryL,G1H12(100),ex4(:),G1H4(22),m3h3x4(:,63),heltab2x12(:,:,291))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(42),n2h4(14))
  call Hloop_AW_Q(ntryL,G1H12(101),ex4(:),G1H4(22),m3h3x4(:,64),heltab2x12(:,:,292))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(43),n2h4(15))
  call Hloop_AW_Q(ntryL,G1H12(176),ex4(:),G1H4(22),m3h3x4(:,65),heltab2x12(:,:,293))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(44),n2h4(16))
  call Hloop_AW_Q(ntryL,G1H12(177),ex4(:),G1H4(22),m3h3x4(:,66),heltab2x12(:,:,294))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(45),n2h4(17))
call HGT_OLR(G1H12(178),1,1,12)
call HGT_invQ_OLR(G1H12(178),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(178),ex3(:),G1H6(32),m3h2x6(:,229),heltab2x12(:,:,295))
  call Hloop_AW_Q(ntryL,G1H12(180),ex4(:),G1H4(22),m3h3x4(:,67),heltab2x12(:,:,296))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(46),n2h4(18))
  call Hloop_AW_Q(ntryL,G1H12(181),ex4(:),G1H4(22),m3h3x4(:,68),heltab2x12(:,:,297))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(47),n2h4(19))
  call Hloop_AW_Q(ntryL,G1H12(182),ex4(:),G1H4(22),m3h3x4(:,69),heltab2x12(:,:,298))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(48),n2h4(20))
  call Hloop_AW_Q(ntryL,G1H12(103),ex4(:),G1H4(22),m3h3x4(:,70),heltab2x12(:,:,299))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(49),n2h4(21))
call HGT_raise_alpha_OLR(G1H12(104),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(104),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(104),ex3(:),G1H6(33),m3h2x6(:,230),heltab2x12(:,:,300))
  call Hloop_AW_Q(ntryL,G1H12(184),ex4(:),G1H4(22),m3h3x4(:,71),heltab2x12(:,:,301))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(50),n2h4(22))
  call Hloop_AW_Q(ntryL,G1H12(185),ex4(:),G1H4(22),m3h3x4(:,72),heltab2x12(:,:,302))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(51),n2h4(23))
  call Hloop_AW_Q(ntryL,G1H12(186),ex4(:),G1H4(22),m3h3x4(:,73),heltab2x12(:,:,303))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(52),n2h4(24))
  call Hloop_AW_Q(ntryL,G1H12(187),ex4(:),G1H4(22),m3h3x4(:,74),heltab2x12(:,:,304))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(53),n2h4(25))
call HGT_raise_alpha_OLR(G1H12(188),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(188),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(188),ex3(:),G1H6(34),m3h2x6(:,231),heltab2x12(:,:,305))
  call Hloop_AW_Q(ntryL,G1H12(190),ex4(:),G1H4(22),m3h3x4(:,75),heltab2x12(:,:,306))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(54),n2h4(26))
  call Hloop_AW_Q(ntryL,G1H12(191),ex4(:),G1H4(22),m3h3x4(:,76),heltab2x12(:,:,307))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(55),n2h4(27))
  call Hloop_AW_Q(ntryL,G1H12(192),ex4(:),G1H4(22),m3h3x4(:,77),heltab2x12(:,:,308))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(56),n2h4(28))
  call Hloop_AW_Q(ntryL,G1H12(105),ex4(:),G1H4(22),m3h3x4(:,78),heltab2x12(:,:,309))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(57),n2h4(29))
call HGT_raise_alpha_OLR(G1H12(106),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(106),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(106),-4,ex3(:),4,G2H6(198),m3h2x6(:,232),heltab2x12(:,:,310))
  call Hloop_AW_Q(ntryL,G1H12(194),ex4(:),G1H4(22),m3h3x4(:,79),heltab2x12(:,:,311))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(58),n2h4(30))
  call Hloop_AW_Q(ntryL,G1H12(195),ex4(:),G1H4(22),m3h3x4(:,80),heltab2x12(:,:,312))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(59),n2h4(31))
  call Hloop_AW_Q(ntryL,G1H12(196),ex4(:),G1H4(22),m3h3x4(:,81),heltab2x12(:,:,313))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(60),n2h4(32))
  call Hloop_AW_Q(ntryL,G1H12(197),ex4(:),G1H4(22),m3h3x4(:,82),heltab2x12(:,:,314))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(61),n2h4(33))
call HGT_raise_alpha_OLR(G1H12(198),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(198),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(198),-4,ex3(:),4,G2H6(199),m3h2x6(:,233),heltab2x12(:,:,315))
  call Hloop_AW_Q(ntryL,G1H12(200),ex4(:),G1H4(22),m3h3x4(:,83),heltab2x12(:,:,316))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(62),n2h4(34))
  call Hloop_AW_Q(ntryL,G1H12(201),ex4(:),G1H4(22),m3h3x4(:,84),heltab2x12(:,:,317))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(63),n2h4(35))
  call Hloop_AW_Q(ntryL,G1H12(202),ex4(:),G1H4(22),m3h3x4(:,85),heltab2x12(:,:,318))
  call Hloop_A_Q(ntryL,G1H4(22),26,nMT,G2H4(64),n2h4(36))
  call Hloop_QV_A(ntryL,G1H12(203),ex3(:),G1H6(35),m3h2x6(:,234),heltab2x12(:,:,319))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(200),n2h6(118))
call HGT_OLR(G1H12(204),1,1,12)
call HGT_invQ_OLR(G1H12(204),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(204),-8,ex4(:),8,G2H4(65),m3h3x4(:,86),heltab2x12(:,:,320))
  call Hloop_QV_A(ntryL,G1H12(206),ex3(:),G1H6(35),m3h2x6(:,235),heltab2x12(:,:,321))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(201),n2h6(119))
  call Hloop_QV_A(ntryL,G1H12(207),ex3(:),G1H6(35),m3h2x6(:,236),heltab2x12(:,:,322))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(202),n2h6(120))
  call Hloop_QV_A(ntryL,G1H12(208),ex3(:),G1H6(35),m3h2x6(:,237),heltab2x12(:,:,323))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(203),n2h6(121))
  call Hloop_QV_A(ntryL,G1H12(209),ex3(:),G1H6(35),m3h2x6(:,238),heltab2x12(:,:,324))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(204),n2h6(122))
call HGT_OLR(G1H12(210),1,1,12)
call HGT_invQ_OLR(G1H12(210),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(210),-8,ex4(:),8,G2H4(66),m3h3x4(:,87),heltab2x12(:,:,325))
  call Hloop_QV_A(ntryL,G1H12(212),ex3(:),G1H6(35),m3h2x6(:,239),heltab2x12(:,:,326))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(205),n2h6(123))
  call Hloop_QV_A(ntryL,G1H12(213),ex3(:),G1H6(35),m3h2x6(:,240),heltab2x12(:,:,327))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(206),n2h6(124))
  call Hloop_QV_A(ntryL,G1H12(214),ex3(:),G1H6(35),m3h2x6(:,241),heltab2x12(:,:,328))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(207),n2h6(125))
  call Hloop_QV_A(ntryL,G1H12(215),ex3(:),G1H6(35),m3h2x6(:,242),heltab2x12(:,:,329))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(208),n2h6(126))
call HGT_OLR(G1H12(216),1,1,12)
call HGT_invQ_OLR(G1H12(216),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(216),-8,ex4(:),8,G2H4(67),m3h3x4(:,88),heltab2x12(:,:,330))
  call Hloop_QV_A(ntryL,G1H12(218),ex3(:),G1H6(35),m3h2x6(:,243),heltab2x12(:,:,331))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(209),n2h6(127))
  call Hloop_QV_A(ntryL,G1H12(219),ex3(:),G1H6(35),m3h2x6(:,244),heltab2x12(:,:,332))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(210),n2h6(128))
  call Hloop_QV_A(ntryL,G1H12(220),ex3(:),G1H6(35),m3h2x6(:,245),heltab2x12(:,:,333))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(211),n2h6(129))
  call Hloop_QV_A(ntryL,G1H12(221),ex3(:),G1H6(35),m3h2x6(:,246),heltab2x12(:,:,334))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(212),n2h6(130))
call HGT_OLR(G1H12(222),1,1,12)
call HGT_invQ_OLR(G1H12(222),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(222),-8,ex4(:),8,G2H4(68),m3h3x4(:,89),heltab2x12(:,:,335))
  call Hloop_QV_A(ntryL,G1H12(224),ex3(:),G1H6(35),m3h2x6(:,247),heltab2x12(:,:,336))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(213),n2h6(131))
  call Hloop_QV_A(ntryL,G1H12(225),ex3(:),G1H6(35),m3h2x6(:,248),heltab2x12(:,:,337))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(214),n2h6(132))
  call Hloop_QV_A(ntryL,G1H12(226),ex3(:),G1H6(35),m3h2x6(:,249),heltab2x12(:,:,338))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(215),n2h6(133))
  call Hloop_QV_A(ntryL,G1H12(227),ex3(:),G1H6(35),m3h2x6(:,250),heltab2x12(:,:,339))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(216),n2h6(134))
call HGT_OLR(G1H12(228),1,1,12)
call HGT_invQ_OLR(G1H12(228),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(228),-8,ex4(:),8,G2H4(69),m3h3x4(:,90),heltab2x12(:,:,340))
  call Hloop_QV_A(ntryL,G1H12(230),ex3(:),G1H6(35),m3h2x6(:,251),heltab2x12(:,:,341))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(217),n2h6(135))
  call Hloop_QV_A(ntryL,G1H12(231),ex3(:),G1H6(35),m3h2x6(:,252),heltab2x12(:,:,342))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(218),n2h6(136))
  call Hloop_QV_A(ntryL,G1H12(232),ex3(:),G1H6(35),m3h2x6(:,253),heltab2x12(:,:,343))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(219),n2h6(137))
  call Hloop_QV_A(ntryL,G1H12(233),ex3(:),G1H6(35),m3h2x6(:,254),heltab2x12(:,:,344))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(220),n2h6(138))
call HGT_OLR(G1H12(234),1,1,12)
call HGT_invQ_OLR(G1H12(234),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(234),-8,ex4(:),8,G2H4(70),m3h3x4(:,91),heltab2x12(:,:,345))
  call Hloop_QV_A(ntryL,G1H12(236),ex3(:),G1H6(35),m3h2x6(:,255),heltab2x12(:,:,346))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(221),n2h6(139))
  call Hloop_QV_A(ntryL,G1H12(237),ex3(:),G1H6(35),m3h2x6(:,256),heltab2x12(:,:,347))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(222),n2h6(140))
  call Hloop_QV_A(ntryL,G1H12(238),ex3(:),G1H6(35),m3h2x6(:,257),heltab2x12(:,:,348))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(223),n2h6(141))
  call Hloop_QV_A(ntryL,G1H12(239),ex3(:),G1H6(35),m3h2x6(:,258),heltab2x12(:,:,349))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(224),n2h6(142))
call HGT_raise_alpha_OLR(G1H12(240),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(240),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(240),ex4(:),G1H4(22),m3h3x4(:,92),heltab2x12(:,:,350))
  call Hloop_QV_A(ntryL,G1H12(242),ex3(:),G1H6(35),m3h2x6(:,259),heltab2x12(:,:,351))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(225),n2h6(143))
  call Hloop_QV_A(ntryL,G1H12(243),ex3(:),G1H6(35),m3h2x6(:,260),heltab2x12(:,:,352))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(226),n2h6(144))
  call Hloop_QV_A(ntryL,G1H12(244),ex3(:),G1H6(35),m3h2x6(:,261),heltab2x12(:,:,353))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(227),n2h6(145))
  call Hloop_QV_A(ntryL,G1H12(245),ex3(:),G1H6(35),m3h2x6(:,262),heltab2x12(:,:,354))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(228),n2h6(146))
call HGT_raise_alpha_OLR(G1H12(246),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(246),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(246),ex4(:),G1H4(23),m3h3x4(:,93),heltab2x12(:,:,355))
  call Hloop_QV_A(ntryL,G1H12(248),ex3(:),G1H6(35),m3h2x6(:,263),heltab2x12(:,:,356))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(229),n2h6(147))
  call Hloop_QV_A(ntryL,G1H12(249),ex3(:),G1H6(35),m3h2x6(:,264),heltab2x12(:,:,357))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(230),n2h6(148))
  call Hloop_QV_A(ntryL,G1H12(250),ex3(:),G1H6(35),m3h2x6(:,265),heltab2x12(:,:,358))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(231),n2h6(149))
  call Hloop_QV_A(ntryL,G1H12(110),ex3(:),G1H6(35),m3h2x6(:,266),heltab2x12(:,:,359))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(232),n2h6(150))
call HGT_OLR(G1H12(251),1,1,12)
call HGT_invQ_OLR(G1H12(251),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(251),ex4(:),G1H4(24),m3h3x4(:,94),heltab2x12(:,:,360))
  call Hloop_QV_A(ntryL,G1H12(253),ex3(:),G1H6(35),m3h2x6(:,267),heltab2x12(:,:,361))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(233),n2h6(151))
  call Hloop_QV_A(ntryL,G1H12(254),ex3(:),G1H6(35),m3h2x6(:,268),heltab2x12(:,:,362))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(234),n2h6(152))
  call Hloop_QV_A(ntryL,G1H12(255),ex3(:),G1H6(35),m3h2x6(:,269),heltab2x12(:,:,363))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(235),n2h6(153))
  call Hloop_QV_A(ntryL,G1H12(256),ex3(:),G1H6(35),m3h2x6(:,270),heltab2x12(:,:,364))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(236),n2h6(154))
call HGT_OLR(G1H12(257),1,1,12)
call HGT_invQ_OLR(G1H12(257),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(257),ex4(:),G1H4(25),m3h3x4(:,95),heltab2x12(:,:,365))
  call Hloop_QV_A(ntryL,G1H12(259),ex3(:),G1H6(35),m3h2x6(:,271),heltab2x12(:,:,366))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(237),n2h6(155))
  call Hloop_QV_A(ntryL,G1H12(260),ex3(:),G1H6(35),m3h2x6(:,272),heltab2x12(:,:,367))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(238),n2h6(156))
  call Hloop_QV_A(ntryL,G1H12(261),ex3(:),G1H6(35),m3h2x6(:,273),heltab2x12(:,:,368))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(239),n2h6(157))
  call Hloop_QV_A(ntryL,G1H12(262),ex3(:),G1H6(35),m3h2x6(:,274),heltab2x12(:,:,369))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(240),n2h6(158))
call HGT_OLR(G1H12(263),1,1,12)
call HGT_invQ_OLR(G1H12(263),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(263),ex4(:),G1H4(26),m3h3x4(:,96),heltab2x12(:,:,370))
  call Hloop_QV_A(ntryL,G1H12(265),ex3(:),G1H6(35),m3h2x6(:,275),heltab2x12(:,:,371))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(241),n2h6(159))
  call Hloop_QV_A(ntryL,G1H12(266),ex3(:),G1H6(35),m3h2x6(:,276),heltab2x12(:,:,372))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(242),n2h6(160))
  call Hloop_QV_A(ntryL,G1H12(267),ex3(:),G1H6(35),m3h2x6(:,277),heltab2x12(:,:,373))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(243),n2h6(161))
  call Hloop_QV_A(ntryL,G1H12(268),ex3(:),G1H6(35),m3h2x6(:,278),heltab2x12(:,:,374))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(244),n2h6(162))
call HGT_OLR(G1H12(269),1,1,12)
call HGT_invQ_OLR(G1H12(269),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(269),ex4(:),G1H4(27),m3h3x4(:,97),heltab2x12(:,:,375))
  call Hloop_QV_A(ntryL,G1H12(271),ex3(:),G1H6(35),m3h2x6(:,279),heltab2x12(:,:,376))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(245),n2h6(163))
  call Hloop_QV_A(ntryL,G1H12(272),ex3(:),G1H6(35),m3h2x6(:,280),heltab2x12(:,:,377))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(246),n2h6(164))
  call Hloop_QV_A(ntryL,G1H12(273),ex3(:),G1H6(35),m3h2x6(:,281),heltab2x12(:,:,378))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMB,G2H6(247),n2h6(165))
  call Hloop_QV_A(ntryL,G1H12(274),ex3(:),G1H6(35),m3h2x6(:,282),heltab2x12(:,:,379))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(248),n2h6(166))
call HGT_OLR(G1H12(275),1,1,12)
call HGT_invQ_OLR(G1H12(275),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(275),ex4(:),G1H4(28),m3h3x4(:,98),heltab2x12(:,:,380))
  call Hloop_QV_A(ntryL,G1H12(277),ex3(:),G1H6(35),m3h2x6(:,283),heltab2x12(:,:,381))
  call Hloop_Q_A(ntryL,G1H6(35),21,nMT,G2H6(249),n2h6(167))



end subroutine vamp_1

end module ol_vamp_1_ppvvv_ew_bbxawwx_1_/**/REALKIND
