
module ol_colourmatrix_ppvvv_ew_udxwwwx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,2), KL(17,2), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2( 1,:) = [ 0, 3]
  K2( 2,:) = [ 0, 0]
  K2( 3,:) = [ 0, 0]
  K2( 4,:) = [ 0, 0]
  K2( 5,:) = [ 0, 0]
  K2( 6,:) = [ 0, 0]
  K2( 7,:) = [ 0, 0]
  K2( 8,:) = [ 0, 0]
  K2( 9,:) = [ 0, 0]
  K2(10,:) = [ 0, 0]
  K2(11,:) = [ 0, 0]
  K2(12,:) = [ 0, 0]
  K2(13,:) = [ 0, 0]
  K2(14,:) = [ 0, 0]
  K2(15,:) = [ 0, 0]
  K2(16,:) = [ 0, 0]
  K2(17,:) = [ 0, 3]

  KL( 1,:) = [ 3, 0]
  KL( 2,:) = [ 0, 0]
  KL( 3,:) = [ 0, 0]
  KL( 4,:) = [ 0, 0]
  KL( 5,:) = [ 0, 0]
  KL( 6,:) = [ 0, 0]
  KL( 7,:) = [ 0, 0]
  KL( 8,:) = [ 0, 0]
  KL( 9,:) = [ 0, 0]
  KL(10,:) = [ 0, 0]
  KL(11,:) = [ 0, 0]
  KL(12,:) = [ 0, 0]
  KL(13,:) = [ 0, 0]
  KL(14,:) = [ 0, 0]
  KL(15,:) = [ 0, 0]
  KL(16,:) = [ 0, 0]
  KL(17,:) = [ 3, 0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvv_ew_udxwwwx_1_/**/REALKIND



module ol_forced_parameters_ppvvv_ew_udxwwwx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvv_ew_udxwwwx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppvvv_ew_udxwwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 108 ! number of helicity configurations
  integer(intkind2), save :: nhel = 108 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(108) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:)
  complex(REALKIND), save :: den(135)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(3), ex4(3), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,5), wf6(6,24), wf9(9,16), wf12(12,48), wf18(18,28), wf27(27,10), wf108(108,165)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(270), c(235)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,108), M0M1_hel_cc(2,108,16)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppvvv_ew_udxwwwx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppvvv_ew_udxwwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppvvv_ew_udxwwwx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*eQED**3)/(sqrt2*sw**3)
    f(  2) = (CI*cw**2*eQED**3)/(sqrt2*sw**3)
    f(  3) = (CI*countertermnorm*eQED**5)/(sqrt2*sw**3)
    f(  4) = (CI*countertermnorm*cw**2*eQED**5)/(sqrt2*sw**3)
    f(  5) = (CI*countertermnorm*eQED**5*EWctVdu)/(sqrt2*sw**3)
    f(  6) = (CI*countertermnorm*cw**2*eQED**5*EWctVdu)/(sqrt2*sw**3)
    f(  7) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**2)/(2._/**/REALKIND*sqrt2*sw**3)
    f(  8) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/(sqrt2*sw**3)
    f(  9) = (CI*countertermnorm*ctVqq*cw**2*eQED**3*gQCD**2)/(sqrt2*sw**3)
    f( 10) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*sqrt2*sw**3)
    f( 11) = (CI*eQED**3*MW**2)/(sqrt2*sw**3)
    f( 12) = (CI*countertermnorm*eQED**5*MW**2)/(sqrt2*sw**3)
    f( 13) = (CI*countertermnorm*eQED**5*EWctVdu*MW**2)/(sqrt2*sw**3)
    f( 14) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW**2)/(sqrt2*sw**3)
    f( 15) = (CI*eQED**3*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 16) = (CI*countertermnorm*eQED**5*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 17) = (CI*countertermnorm*eQED**5*EWctVdu*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 18) = (CI*countertermnorm*eQED**5*EWctVud*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 19) = (CI*countertermnorm*eQED**3*gQCD**2*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 20) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 21) = (CI*cw*eQED**3)/(sqrt2*sw**2)
    f( 22) = (CI*countertermnorm*cw*eQED**5)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 23) = (2*CI*countertermnorm*cw*eQED**5)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 24) = (CI*countertermnorm*cw*eQED**5)/(sqrt2*sw**2)
    f( 25) = (CI*countertermnorm*cw*eQED**5*EWctVdu)/(sqrt2*sw**2)
    f( 26) = (CI*countertermnorm*cw*eQED**5*EWctZWW)/(sqrt2*sw**2)
    f( 27) = (CI*countertermnorm*cw*eQED**3*gQCD**2)/(sqrt2*sw**2)
    f( 28) = (CI*countertermnorm*ctVqq*cw*eQED**3*gQCD**2)/(sqrt2*sw**2)
    f( 29) = (CI*countertermnorm*eQED**5*EWctHWW*MW)/(sqrt2*sw**2)
    f( 30) = (CI*eQED**3)/(3._/**/REALKIND*sqrt2*sw)
    f( 31) = (2*CI*eQED**3)/(3._/**/REALKIND*sqrt2*sw)
    f( 32) = (CI*eQED**3)/(sqrt2*sw)
    f( 33) = (CI*countertermnorm*eQED**5)/(3._/**/REALKIND*sqrt2*sw)
    f( 34) = (2*CI*countertermnorm*eQED**5)/(3._/**/REALKIND*sqrt2*sw)
    f( 35) = (CI*countertermnorm*eQED**5)/(sqrt2*sw)
    f( 36) = (CI*countertermnorm*eQED**5*EWctAWW)/(3._/**/REALKIND*sqrt2*sw)
    f( 37) = (2*CI*countertermnorm*eQED**5*EWctAWW)/(3._/**/REALKIND*sqrt2*sw)
    f( 38) = (CI*countertermnorm*eQED**5*EWctAWW)/(sqrt2*sw)
    f( 39) = (CI*countertermnorm*eQED**5*EWctVdu)/(3._/**/REALKIND*sqrt2*sw)
    f( 40) = (2*CI*countertermnorm*eQED**5*EWctVdu)/(3._/**/REALKIND*sqrt2*sw)
    f( 41) = (CI*countertermnorm*eQED**5*EWctVdu)/(sqrt2*sw)
    f( 42) = (CI*countertermnorm*eQED**5*EWctZWW)/(sqrt2*sw)
    f( 43) = (CI*countertermnorm*eQED**3*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 44) = (2*CI*countertermnorm*eQED**3*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 45) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**2)/(sqrt2*sw)
    f( 46) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 47) = (2*CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 48) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/(sqrt2*sw)
    f( 49) = (CI*countertermnorm*eQED**5*MW)/(sqrt2*sw)
    f( 50) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sqrt2*3._/**/REALKIND)
    f( 51) = (2*eQED**5*integralnorm*MW**2*SwB)/(cw*sqrt2*3._/**/REALKIND)
    f( 52) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sqrt2)
    f( 53) = (eQED**5*integralnorm*SwB)/(sqrt2*sw**5*16._/**/REALKIND)
    f( 54) = (eQED**5*integralnorm*SwB)/(sqrt2*sw**5*8._/**/REALKIND)
    f( 55) = (eQED**5*integralnorm*SwB)/(sqrt2*sw**5*4._/**/REALKIND)
    f( 56) = (eQED**5*integralnorm*SwB)/(sqrt2*sw**5*2._/**/REALKIND)
    f( 57) = (eQED**5*integralnorm*SwB)/(sqrt2*sw**5)
    f( 58) = (cw**2*eQED**5*integralnorm*SwB)/(sqrt2*sw**5*4._/**/REALKIND)
    f( 59) = (cw**2*eQED**5*integralnorm*SwB)/(sqrt2*sw**5)
    f( 60) = (cw**4*eQED**5*integralnorm*SwB)/(sqrt2*sw**5*2._/**/REALKIND)
    f( 61) = (cw**4*eQED**5*integralnorm*SwB)/(sqrt2*sw**5)
    f( 62) = (eQED**5*integralnorm*MH**2*SwB)/(sqrt2*sw**5*8._/**/REALKIND)
    f( 63) = (eQED**5*integralnorm*MH**2*SwB)/(sqrt2*sw**5*4._/**/REALKIND)
    f( 64) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(sqrt2*sw**5*8._/**/REALKIND)
    f( 65) = (eQED**5*integralnorm*MH**4*SwB)/(sqrt2*sw**5*8._/**/REALKIND)
    f( 66) = (eQED**5*integralnorm*MH**4*SwB)/(sqrt2*sw**5*4._/**/REALKIND)
    f( 67) = (9*eQED**5*integralnorm*lambdaHHH**2*MH**4*SwB)/(sqrt2*sw**5*8._/**/REALKIND)
    f( 68) = (eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**5*4._/**/REALKIND)
    f( 69) = (eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**5*2._/**/REALKIND)
    f( 70) = (eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**5)
    f( 71) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sqrt2*sw**5*4._/**/REALKIND)
    f( 72) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sqrt2*sw**5)
    f( 73) = (cw**2*eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**5*2._/**/REALKIND)
    f( 74) = (cw**2*eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**5)
    f( 75) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW**2*SwB)/(sqrt2*sw**5*2._/**/REALKIND)
    f( 76) = (eQED**5*integralnorm*MW**4*SwB)/(sqrt2*sw**5*4._/**/REALKIND)
    f( 77) = (eQED**5*integralnorm*MW**4*SwB)/(sqrt2*sw**5)
    f( 78) = (eQED**5*integralnorm*MW**4*SwB)/(cw**4*sqrt2*sw**5*4._/**/REALKIND)
    f( 79) = (eQED**5*integralnorm*MW**4*SwB)/(cw**4*sqrt2*sw**5*2._/**/REALKIND)
    f( 80) = (eQED**5*integralnorm*sqrt2*SwB)/(sw**5*8._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*sqrt2*SwB)/(sw**5*4._/**/REALKIND)
    f( 82) = (cw**2*eQED**5*integralnorm*sqrt2*SwB)/(sw**5*4._/**/REALKIND)
    f( 83) = (eQED**5*integralnorm*MW**2*sqrt2*SwB)/(sw**5*4._/**/REALKIND)
    f( 84) = (eQED**5*integralnorm*SwB)/(cw*sqrt2*sw**4*8._/**/REALKIND)
    f( 85) = (eQED**5*integralnorm*SwB)/(cw*sqrt2*sw**4*4._/**/REALKIND)
    f( 86) = (cw*eQED**5*integralnorm*SwB)/(sqrt2*sw**4)
    f( 87) = (cw**3*eQED**5*integralnorm*SwB)/(sqrt2*sw**4)
    f( 88) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sqrt2*sw**4)
    f( 89) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sqrt2*sw**4)
    f( 90) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**4*2._/**/REALKIND)
    f( 91) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**4)
    f( 92) = (cw*eQED**5*integralnorm*sqrt2*SwB)/(sw**4*4._/**/REALKIND)
    f( 93) = (eQED**5*integralnorm*SwB)/(sqrt2*sw**3*12._/**/REALKIND)
    f( 94) = (eQED**5*integralnorm*SwB)/(sqrt2*sw**3*6._/**/REALKIND)
    f( 95) = (2*eQED**5*integralnorm*SwB)/(sqrt2*sw**3*9._/**/REALKIND)
    f( 96) = (eQED**5*integralnorm*SwB)/(sqrt2*sw**3*4._/**/REALKIND)
    f( 97) = (eQED**5*integralnorm*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f( 98) = (eQED**5*integralnorm*SwB)/(sqrt2*sw**3*2._/**/REALKIND)
    f( 99) = (2*eQED**5*integralnorm*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(100) = (eQED**5*integralnorm*SwB)/(sqrt2*sw**3)
    f(101) = (2*cw**2*eQED**5*integralnorm*SwB)/(sqrt2*sw**3*9._/**/REALKIND)
    f(102) = (cw**2*eQED**5*integralnorm*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(103) = (2*cw**2*eQED**5*integralnorm*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(104) = (cw**2*eQED**5*integralnorm*SwB)/(sqrt2*sw**3)
    f(105) = (eQED**3*gQCD**2*integralnorm*SwB)/(sqrt2*sw**3)
    f(106) = (cw**2*eQED**3*gQCD**2*integralnorm*SwB)/(sqrt2*sw**3)
    f(107) = (eQED**5*integralnorm*MH**2*SwB)/(sqrt2*sw**3*6._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MH**2*SwB)/(sqrt2*sw**3*4._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*MH**2*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MH**2*SwB)/(sqrt2*sw**3*2._/**/REALKIND)
    f(111) = (eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**3*6._/**/REALKIND)
    f(112) = (2*eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**3*9._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**3*4._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(115) = (eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**3*2._/**/REALKIND)
    f(116) = (2*eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**3)
    f(118) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sqrt2*sw**3*4._/**/REALKIND)
    f(119) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sqrt2*sw**3*2._/**/REALKIND)
    f(120) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sqrt2*sw**3)
    f(121) = (cw**2*eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw**3)
    f(122) = (eQED**3*gQCD**2*integralnorm*MW**2*SwB)/(sqrt2*sw**3)
    f(123) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(sqrt2*sw**3*2._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*MW**4*SwB)/(sqrt2*sw**3)
    f(125) = (eQED**5*integralnorm*sqrt2*SwB)/(sw**3*36._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*sqrt2*SwB)/(sw**3*18._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*sqrt2*SwB)/(sw**3*12._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*sqrt2*SwB)/(sw**3*9._/**/REALKIND)
    f(129) = (eQED**5*integralnorm*sqrt2*SwB)/(sw**3*6._/**/REALKIND)
    f(130) = (eQED**5*integralnorm*sqrt2*SwB)/(sw**3*4._/**/REALKIND)
    f(131) = (eQED**3*gQCD**2*integralnorm*sqrt2*SwB)/(sw**3*4._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*SwB)/(cw*sqrt2*sw**2*4._/**/REALKIND)
    f(133) = (cw*eQED**5*integralnorm*SwB)/(sqrt2*sw**2*9._/**/REALKIND)
    f(134) = (2*cw*eQED**5*integralnorm*SwB)/(sqrt2*sw**2*9._/**/REALKIND)
    f(135) = (cw*eQED**5*integralnorm*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(136) = (4*cw*eQED**5*integralnorm*SwB)/(sqrt2*sw**2*9._/**/REALKIND)
    f(137) = (2*cw*eQED**5*integralnorm*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(138) = (cw*eQED**5*integralnorm*SwB)/(sqrt2*sw**2)
    f(139) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/(sqrt2*sw**2)
    f(140) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sqrt2*sw**2*2._/**/REALKIND)
    f(141) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sqrt2*sw**2*2._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*SwB)/(sqrt2*sw*27._/**/REALKIND)
    f(143) = (2*eQED**5*integralnorm*SwB)/(sqrt2*sw*27._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(145) = (4*eQED**5*integralnorm*SwB)/(sqrt2*sw*27._/**/REALKIND)
    f(146) = (2*eQED**5*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(147) = (8*eQED**5*integralnorm*SwB)/(sqrt2*sw*27._/**/REALKIND)
    f(148) = (eQED**5*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(149) = (4*eQED**5*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(150) = (eQED**5*integralnorm*SwB)/(sqrt2*sw*2._/**/REALKIND)
    f(151) = (2*eQED**5*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*SwB)/(sqrt2*sw)
    f(153) = (eQED**3*gQCD**2*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(154) = (2*eQED**3*gQCD**2*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(155) = (eQED**3*gQCD**2*integralnorm*SwB)/(sqrt2*sw)
    f(156) = (eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(157) = (2*eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(159) = (4*eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(160) = (2*eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(161) = (eQED**5*integralnorm*MW**2*SwB)/(sqrt2*sw)
    f(162) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sqrt2*sw*4._/**/REALKIND)
    f(163) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sqrt2*sw*2._/**/REALKIND)
    f(164) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sqrt2*sw)
    f(165) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw**2*sqrt2*sw*2._/**/REALKIND)
    f(166) = (eQED**5*integralnorm*MW**4*SwB)/(sqrt2*sw)
    f(167) = (eQED**5*integralnorm*MW**4*SwB)/(cw**4*sqrt2*sw)
    f(168) = (eQED**5*integralnorm*MW**4*SwB)/(cw**2*sqrt2*sw)
    f(169) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw**2*sqrt2*3._/**/REALKIND)
    f(170) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/(cw**2*sqrt2*3._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw**2*sqrt2)
    f(172) = (eQED**5*integralnorm*MW**4*sw*SwB)/(cw**2*sqrt2)
    f(173) = (eQED**5*integralnorm*MW**4*sw**3*SwB)/(cw**4*sqrt2)
    f(174) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**5*8._/**/REALKIND))
    f(175) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**5*4._/**/REALKIND))
    f(176) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**5*4._/**/REALKIND))
    f(177) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**5*4._/**/REALKIND))
    f(178) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**4*8._/**/REALKIND))
    f(179) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**4*4._/**/REALKIND))
    f(180) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**2*2._/**/REALKIND)
    f(181) = -((eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw*sqrt2*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(182) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**4*4._/**/REALKIND))
    f(183) = (eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**2*2._/**/REALKIND)
    f(184) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**3*6._/**/REALKIND))
    f(185) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(sqrt2*sw**5*2._/**/REALKIND*4._/**/REALKIND)
    f(186) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**3*3._/**/REALKIND))
    f(187) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**3*2._/**/REALKIND))
    f(188) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**3*2._/**/REALKIND))
    f(189) = (eQED**5*integralnorm*MW**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw**3*4._/**/REALKIND)
    f(190) = (eQED**5*integralnorm*MW**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw*2._/**/REALKIND)
    f(191) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sqrt2*2._/**/REALKIND))
    f(192) = (eQED**5*integralnorm*MB**2*SwF)/(sqrt2*sw**5*4._/**/REALKIND)
    f(193) = (eQED**5*integralnorm*ME**2*SwF)/(sqrt2*sw**5*4._/**/REALKIND)
    f(194) = (eQED**5*integralnorm*ML**2*SwF)/(sqrt2*sw**5*4._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*MM**2*SwF)/(sqrt2*sw**5*4._/**/REALKIND)
    f(196) = (eQED**5*integralnorm*MT**2*SwF)/(sqrt2*sw**5*4._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*sqrt2*SwF)/(sw**5*8._/**/REALKIND)
    f(198) = (eQED**5*integralnorm*sqrt2*SwF)/(sw**5*4._/**/REALKIND)
    f(199) = (eQED**5*integralnorm*sqrt2*SwF)/(sw**5*2._/**/REALKIND)
    f(200) = (cw**2*eQED**5*integralnorm*sqrt2*SwF)/(sw**5*4._/**/REALKIND)
    f(201) = (cw**2*eQED**5*integralnorm*sqrt2*SwF)/(sw**5*2._/**/REALKIND)
    f(202) = (eQED**5*integralnorm*MB*sqrt2*SwF)/(sw**5*8._/**/REALKIND)
    f(203) = (eQED**5*integralnorm*ME*sqrt2*SwF)/(sw**5*8._/**/REALKIND)
    f(204) = (eQED**5*integralnorm*ML*sqrt2*SwF)/(sw**5*8._/**/REALKIND)
    f(205) = (eQED**5*integralnorm*MM*sqrt2*SwF)/(sw**5*8._/**/REALKIND)
    f(206) = (eQED**5*integralnorm*MT*sqrt2*SwF)/(sw**5*8._/**/REALKIND)
    f(207) = (eQED**5*integralnorm*MW**2*sqrt2*SwF)/(sw**5*4._/**/REALKIND)
    f(208) = (eQED**5*integralnorm*MW**2*sqrt2*SwF)/(sw**5*2._/**/REALKIND)
    f(209) = (cw*eQED**5*integralnorm*MB*SwF)/(sqrt2*sw**4*2._/**/REALKIND)
    f(210) = (cw*eQED**5*integralnorm*ME*SwF)/(sqrt2*sw**4*2._/**/REALKIND)
    f(211) = (cw*eQED**5*integralnorm*ML*SwF)/(sqrt2*sw**4*2._/**/REALKIND)
    f(212) = (cw*eQED**5*integralnorm*MM*SwF)/(sqrt2*sw**4*2._/**/REALKIND)
    f(213) = (cw*eQED**5*integralnorm*MT*SwF)/(sqrt2*sw**4*2._/**/REALKIND)
    f(214) = (cw*eQED**5*integralnorm*sqrt2*SwF)/(sw**4*4._/**/REALKIND)
    f(215) = (cw*eQED**5*integralnorm*sqrt2*SwF)/(sw**4*2._/**/REALKIND)
    f(216) = (cw**2*eQED**5*integralnorm*SwF)/(sqrt2*sw**3)
    f(217) = (2*cw**2*eQED**5*integralnorm*SwF)/(sqrt2*sw**3)
    f(218) = (3*cw**2*eQED**5*integralnorm*SwF)/(sqrt2*sw**3)
    f(219) = (eQED**5*integralnorm*MB*SwF)/(sqrt2*sw**3*18._/**/REALKIND)
    f(220) = (eQED**5*integralnorm*MB*SwF)/(sqrt2*sw**3*9._/**/REALKIND)
    f(221) = (eQED**5*integralnorm*MB*SwF)/(sqrt2*sw**3*6._/**/REALKIND)
    f(222) = (eQED**5*integralnorm*MB*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(223) = (eQED**5*integralnorm*ME*SwF)/(sqrt2*sw**3*6._/**/REALKIND)
    f(224) = (eQED**5*integralnorm*ME*SwF)/(sqrt2*sw**3*3._/**/REALKIND)
    f(225) = (eQED**5*integralnorm*ME*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(226) = (eQED**5*integralnorm*ML*SwF)/(sqrt2*sw**3*6._/**/REALKIND)
    f(227) = (eQED**5*integralnorm*ML*SwF)/(sqrt2*sw**3*3._/**/REALKIND)
    f(228) = (eQED**5*integralnorm*ML*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(229) = (eQED**5*integralnorm*MM*SwF)/(sqrt2*sw**3*6._/**/REALKIND)
    f(230) = (eQED**5*integralnorm*MM*SwF)/(sqrt2*sw**3*3._/**/REALKIND)
    f(231) = (eQED**5*integralnorm*MM*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(232) = (eQED**5*integralnorm*MT*SwF)/(sqrt2*sw**3*9._/**/REALKIND)
    f(233) = (2*eQED**5*integralnorm*MT*SwF)/(sqrt2*sw**3*9._/**/REALKIND)
    f(234) = (eQED**5*integralnorm*MT*SwF)/(sqrt2*sw**3*3._/**/REALKIND)
    f(235) = (eQED**5*integralnorm*MT*SwF)/(sqrt2*sw**3*2._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*sqrt2*SwF)/(sw**3*36._/**/REALKIND)
    f(237) = (eQED**5*integralnorm*sqrt2*SwF)/(sw**3*18._/**/REALKIND)
    f(238) = (eQED**5*integralnorm*sqrt2*SwF)/(sw**3*12._/**/REALKIND)
    f(239) = (eQED**5*integralnorm*sqrt2*SwF)/(sw**3*9._/**/REALKIND)
    f(240) = (eQED**5*integralnorm*sqrt2*SwF)/(sw**3*6._/**/REALKIND)
    f(241) = (2*eQED**5*integralnorm*sqrt2*SwF)/(sw**3*9._/**/REALKIND)
    f(242) = (eQED**5*integralnorm*sqrt2*SwF)/(sw**3*4._/**/REALKIND)
    f(243) = (eQED**5*integralnorm*sqrt2*SwF)/(sw**3*3._/**/REALKIND)
    f(244) = (eQED**5*integralnorm*sqrt2*SwF)/(sw**3*2._/**/REALKIND)
    f(245) = (eQED**5*integralnorm*ME*sqrt2*SwF)/(sw**3*4._/**/REALKIND)
    f(246) = (eQED**5*integralnorm*ML*sqrt2*SwF)/(sw**3*4._/**/REALKIND)
    f(247) = (eQED**5*integralnorm*MM*sqrt2*SwF)/(sw**3*4._/**/REALKIND)
    f(248) = (cw*eQED**5*integralnorm*SwF)/(sqrt2*sw**2*9._/**/REALKIND)
    f(249) = (2*cw*eQED**5*integralnorm*SwF)/(sqrt2*sw**2*9._/**/REALKIND)
    f(250) = (cw*eQED**5*integralnorm*SwF)/(sqrt2*sw**2*3._/**/REALKIND)
    f(251) = (4*cw*eQED**5*integralnorm*SwF)/(sqrt2*sw**2*9._/**/REALKIND)
    f(252) = (2*cw*eQED**5*integralnorm*SwF)/(sqrt2*sw**2*3._/**/REALKIND)
    f(253) = (8*cw*eQED**5*integralnorm*SwF)/(sqrt2*sw**2*9._/**/REALKIND)
    f(254) = (cw*eQED**5*integralnorm*SwF)/(sqrt2*sw**2)
    f(255) = (4*cw*eQED**5*integralnorm*SwF)/(sqrt2*sw**2*3._/**/REALKIND)
    f(256) = (2*cw*eQED**5*integralnorm*SwF)/(sqrt2*sw**2)
    f(257) = (3*cw*eQED**5*integralnorm*SwF)/(sqrt2*sw**2)
    f(258) = (eQED**5*integralnorm*SwF)/(sqrt2*sw*27._/**/REALKIND)
    f(259) = (2*eQED**5*integralnorm*SwF)/(sqrt2*sw*27._/**/REALKIND)
    f(260) = (eQED**5*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(261) = (4*eQED**5*integralnorm*SwF)/(sqrt2*sw*27._/**/REALKIND)
    f(262) = (2*eQED**5*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(263) = (8*eQED**5*integralnorm*SwF)/(sqrt2*sw*27._/**/REALKIND)
    f(264) = (eQED**5*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(265) = (4*eQED**5*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(266) = (16*eQED**5*integralnorm*SwF)/(sqrt2*sw*27._/**/REALKIND)
    f(267) = (2*eQED**5*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)
    f(268) = (8*eQED**5*integralnorm*SwF)/(sqrt2*sw*9._/**/REALKIND)
    f(269) = (eQED**5*integralnorm*SwF)/(sqrt2*sw)
    f(270) = (4*eQED**5*integralnorm*SwF)/(sqrt2*sw*3._/**/REALKIND)

  c = [ 3*f(50), 3*f(51), 3*f(52), 3*f(53), 3*f(54), 3*f(55), 3*f(56), 3*f(57), 3*f(58), 3*f(59), 3*f(60), 3*f(61), 3*f(62) &
    , 3*f(63), 3*f(64), 3*f(65), 3*f(66), 3*f(67), 3*f(68), 3*f(69), 3*f(70), 3*f(71), 3*f(72), 3*f(73), 3*f(74), 3*f(75), 3*f(76) &
    , 3*f(77), 3*f(78), 3*f(79), 3*f(80), 3*f(81), 3*f(82), 3*f(83), 3*f(84), 3*f(85), 3*f(86), 3*f(87), 3*f(88), 3*f(89), 3*f(90) &
    , 3*f(91), 3*f(92), 3*f(93), 3*f(94), 3*f(95), 3*f(96), 3*f(97), 3*f(98), 3*f(99), 3*f(100), 3*f(101), 3*f(102), 3*f(103) &
    , 3*f(104), 4*f(105), 4*f(106), 3*f(107), 3*f(108), 3*f(109), 3*f(110), 3*f(111), 3*f(112), 3*f(113), 3*f(114), 3*f(115) &
    , 3*f(116), 3*f(117), 3*f(118), 3*f(119), 3*f(120), 3*f(121), 4*f(122), 3*f(123), 3*f(124), 3*f(125), 3*f(126), 3*f(127) &
    , 3*f(128), 3*f(129), 3*f(130), 4*f(131), 3*f(132), 3*f(133), 3*f(134), 3*f(135), 3*f(136), 3*f(137), 3*f(138), 4*f(139) &
    , 3*f(140), 3*f(141), 3*f(142), 3*f(143), 3*f(144), 3*f(145), 3*f(146), 3*f(147), 3*f(148), 3*f(149), 3*f(150), 3*f(151) &
    , 3*f(152), 4*f(153), 4*f(154), 4*f(155), 3*f(156), 3*f(157), 3*f(158), 3*f(159), 3*f(160), 3*f(161), 3*f(162), 3*f(163) &
    , 3*f(164), 3*f(165), 3*f(166), 3*f(167), 3*f(168), 3*f(169), 3*f(170), 3*f(171), 3*f(172), 3*f(173), 3*f(174), 3*f(175) &
    , 3*f(176), 3*f(177), 3*f(178), 3*f(179), 3*f(180), 3*f(181), 3*f(182), 3*f(183), 3*f(184), 3*f(185), 3*f(186), 3*f(187) &
    , 3*f(188), 3*f(189), 3*f(190), 3*f(191), 9*f(192), 3*f(193), 3*f(194), 3*f(195), 9*f(196), 3*f(197), 9*f(197), 3*f(198) &
    , 9*f(198), 9*f(199), 3*f(200), 9*f(200), 9*f(201), 9*f(202), 3*f(203), 3*f(204), 3*f(205), 9*f(206), 3*f(207), 9*f(207) &
    , 9*f(208), 9*f(209), 3*f(210), 3*f(211), 3*f(212), 9*f(213), 3*f(214), 9*f(214), 9*f(215), 3*f(216), 9*f(216), 9*f(217) &
    , 3*f(218), 9*f(219), 9*f(220), 9*f(221), 9*f(222), 3*f(223), 3*f(224), 3*f(225), 3*f(226), 3*f(227), 3*f(228), 3*f(229) &
    , 3*f(230), 3*f(231), 9*f(232), 9*f(233), 9*f(234), 9*f(235), 9*f(236), 9*f(237), 3*f(238), 9*f(238), 9*f(239), 3*f(240) &
    , 9*f(240), 9*f(241), 3*f(242), 9*f(242), 9*f(243), 9*f(244), 3*f(245), 3*f(246), 3*f(247), 9*f(248), 9*f(249), 3*f(250) &
    , 9*f(250), 9*f(251), 3*f(252), 9*f(252), 9*f(253), 3*f(254), 9*f(254), 9*f(255), 9*f(256), 3*f(257), 9*f(258), 9*f(259) &
    , 9*f(260), 9*f(261), 9*f(262), 9*f(263), 3*f(264), 9*f(264), 9*f(265), 9*f(266), 3*f(267), 9*f(267), 9*f(268), 3*f(269) &
    , 9*f(270) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MW2)+L(6,3))
  den(2) = 1 /((L(5,20) - MH2)+L(6,20))
  den(4) = 1 /((L(5,20))+L(6,20))
  den(6) = 1 /((L(5,20) - MZ2)+L(6,20))
  den(8) = 1 /((L(5,24) - MH2)+L(6,24))
  den(10) = 1 /((L(5,24))+L(6,24))
  den(12) = 1 /((L(5,24) - MZ2)+L(6,24))
  den(14) = 1 /((L(5,5))+L(6,5))
  den(15) = 1 /((L(5,10))+L(6,10))
  den(19) = 1 /((L(5,9))+L(6,9))
  den(20) = 1 /((L(5,6))+L(6,6))
  den(28) = 1 /((L(5,28) - MW2)+L(6,28))
  den(36) = 1 /((L(5,11) - MH2)+L(6,11))
  den(39) = 1 /((L(5,11))+L(6,11))
  den(42) = 1 /((L(5,11) - MZ2)+L(6,11))
  den(53) = 1 /((L(5,7) - MH2)+L(6,7))
  den(56) = 1 /((L(5,7))+L(6,7))
  den(60) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(64) = 1 /((L(5,26))+L(6,26))
  den(67) = 1 /((L(5,21))+L(6,21))
  den(80) = 1 /((L(5,22))+L(6,22))
  den(83) = 1 /((L(5,25))+L(6,25))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(1)*den(6)
  den(9) = den(1)*den(8)
  den(11) = den(1)*den(10)
  den(13) = den(1)*den(12)
  den(16) = den(14)*den(15)
  den(17) = den(10)*den(14)
  den(18) = den(12)*den(14)
  den(21) = den(19)*den(20)
  den(22) = den(10)*den(20)
  den(23) = den(12)*den(20)
  den(24) = den(4)*den(19)
  den(25) = den(6)*den(19)
  den(26) = den(4)*den(15)
  den(27) = den(6)*den(15)
  den(29) = den(1)*den(28)
  den(30) = den(2)*den(28)
  den(31) = den(1)*den(30)
  den(32) = den(4)*den(28)
  den(33) = den(1)*den(32)
  den(34) = den(6)*den(28)
  den(35) = den(1)*den(34)
  den(37) = den(1)*den(36)
  den(38) = den(2)*den(37)
  den(40) = den(1)*den(39)
  den(41) = den(4)*den(40)
  den(43) = den(1)*den(42)
  den(44) = den(4)*den(43)
  den(45) = den(6)*den(40)
  den(46) = den(6)*den(43)
  den(47) = den(8)*den(28)
  den(48) = den(1)*den(47)
  den(49) = den(10)*den(28)
  den(50) = den(1)*den(49)
  den(51) = den(12)*den(28)
  den(52) = den(1)*den(51)
  den(54) = den(1)*den(53)
  den(55) = den(8)*den(54)
  den(57) = den(1)*den(56)
  den(58) = den(10)*den(57)
  den(59) = den(12)*den(57)
  den(61) = den(1)*den(60)
  den(62) = den(10)*den(61)
  den(63) = den(12)*den(61)
  den(65) = den(15)*den(64)
  den(66) = den(14)*den(65)
  den(68) = den(14)*den(67)
  den(69) = den(15)*den(68)
  den(70) = den(10)*den(64)
  den(71) = den(14)*den(70)
  den(72) = den(12)*den(64)
  den(73) = den(14)*den(72)
  den(74) = den(14)*den(56)
  den(75) = den(10)*den(74)
  den(76) = den(12)*den(74)
  den(77) = den(14)*den(60)
  den(78) = den(10)*den(77)
  den(79) = den(12)*den(77)
  den(81) = den(20)*den(80)
  den(82) = den(19)*den(81)
  den(84) = den(19)*den(83)
  den(85) = den(20)*den(84)
  den(86) = den(10)*den(83)
  den(87) = den(20)*den(86)
  den(88) = den(12)*den(83)
  den(89) = den(20)*den(88)
  den(90) = den(20)*den(56)
  den(91) = den(10)*den(90)
  den(92) = den(12)*den(90)
  den(93) = den(20)*den(60)
  den(94) = den(10)*den(93)
  den(95) = den(12)*den(93)
  den(96) = den(4)*den(80)
  den(97) = den(19)*den(96)
  den(98) = den(6)*den(80)
  den(99) = den(19)*den(98)
  den(100) = den(19)*den(39)
  den(101) = den(4)*den(100)
  den(102) = den(6)*den(100)
  den(103) = den(19)*den(42)
  den(104) = den(4)*den(103)
  den(105) = den(6)*den(103)
  den(106) = den(4)*den(67)
  den(107) = den(15)*den(106)
  den(108) = den(6)*den(67)
  den(109) = den(15)*den(108)
  den(110) = den(15)*den(39)
  den(111) = den(4)*den(110)
  den(112) = den(6)*den(110)
  den(113) = den(15)*den(42)
  den(114) = den(4)*den(113)
  den(115) = den(6)*den(113)
  den(116) = den(8)*den(14)
  den(117) = den(8)*den(20)
  den(118) = den(2)*den(19)
  den(119) = den(2)*den(15)
  den(120) = den(2)*den(40)
  den(121) = den(2)*den(43)
  den(122) = den(4)*den(37)
  den(123) = den(6)*den(37)
  den(124) = den(10)*den(54)
  den(125) = den(12)*den(54)
  den(126) = den(8)*den(57)
  den(127) = den(8)*den(61)
  den(128) = den(8)*den(74)
  den(129) = den(8)*den(77)
  den(130) = den(8)*den(90)
  den(131) = den(8)*den(93)
  den(132) = den(2)*den(100)
  den(133) = den(2)*den(103)
  den(134) = den(2)*den(110)
  den(135) = den(2)*den(113)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppvvv_ew_udxwwwx_1_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-down W- W- W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppvvv_ew_udxwwwx_1, only: &
    & external_perm_ppvvv_ew_udxwwwx_1, &
    & external_perm_inv_ppvvv_ew_udxwwwx_1, &
    & extcomb_perm_ppvvv_ew_udxwwwx_1, &
    & average_factor_ppvvv_ew_udxwwwx_1, &
    & photonid_ppvvv_ew_udxwwwx_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppvvv_ew_udxwwwx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppvvv_ew_udxwwwx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppvvv_ew_udxwwwx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppvvv_ew_udxwwwx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,108)
  type(Hpolcont) :: M1helarray_ct(2,108)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
!  type(Hpolcont) :: A(108,165)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(165)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,165))
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMW, nMW, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppvvv_ew_udxwwwx_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rMW, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMW, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMW, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_WWV_V(ntry, ex3(:), ex4(:), ex5(:), wf27(:,1), n4(:,1), t4x27(:,:,1))
  call vert_VV_S(ntry, ex3(:), ex5(:), wf9(:,1), n3(:,2), t3x9(:,:,1))
  call vert_VV_S(ntry, wf4(:,1), ex4(:), wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_UV_W(ntry, ex5(:), 16, ex3(:), 4, wf9(:,2), n3(:,4), t3x9(:,:,2))
  call vert_UV_W(ntry, wf4(:,1), 3, ex4(:), 8, wf12(:,2), n3(:,5), t3x12(:,:,2))
  call vert_VV_S(ntry, ex4(:), ex5(:), wf9(:,3), n3(:,6), t3x9(:,:,3))
  call vert_VV_S(ntry, wf4(:,1), ex3(:), wf12(:,3), n3(:,7), t3x12(:,:,3))
  call vert_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,4), n3(:,8), t3x9(:,:,4))
  call vert_UV_W(ntry, wf4(:,1), 3, ex3(:), 4, wf12(:,4), n3(:,9), t3x12(:,:,4))
  call vert_WQ_A(ntry, ex3(:), ex1(:), wf6(:,1), n3(:,10), t3x6(:,:,1))
  call vert_AW_Q(ntry, ex2(:), ex4(:), wf6(:,2), n3(:,11), t3x6(:,:,2))
  call prop_Q_A(ntry, wf6(:,1), 5, ZERO, 0_intkind1, wf6(:,3), n2(1))
  call prop_A_Q(ntry, wf6(:,2), 10, ZERO, 0_intkind1, wf6(:,4), n2(2))
  call vert_WQ_A(ntry, ex5(:), wf6(:,3), wf18(:,1), n3(:,12), t3x18(:,:,1))
  call vert_QA_V(ntry, wf6(:,3), ex2(:), wf12(:,5), n3(:,13), t3x12(:,:,5))
  call vert_QA_Z(gZd,ntry, wf6(:,3), ex2(:), wf12(:,6), n3(:,14), t3x12(:,:,6))
  call vert_WQ_A(ntry, ex4(:), ex1(:), wf6(:,5), n3(:,15), t3x6(:,:,3))
  call vert_AW_Q(ntry, ex2(:), ex3(:), wf6(:,6), n3(:,16), t3x6(:,:,4))
  call prop_Q_A(ntry, wf6(:,5), 9, ZERO, 0_intkind1, wf6(:,7), n2(3))
  call prop_A_Q(ntry, wf6(:,6), 6, ZERO, 0_intkind1, wf6(:,8), n2(4))
  call vert_WQ_A(ntry, ex5(:), wf6(:,7), wf18(:,2), n3(:,17), t3x18(:,:,2))
  call vert_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,7), n3(:,18), t3x12(:,:,7))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,8), wf12(:,8), n3(:,19), t3x12(:,:,8))
  call vert_QA_V(ntry, wf6(:,7), ex2(:), wf12(:,9), n3(:,20), t3x12(:,:,9))
  call vert_QA_Z(gZd,ntry, wf6(:,7), ex2(:), wf12(:,10), n3(:,21), t3x12(:,:,10))
  call vert_QA_V(ntry, ex1(:), wf6(:,4), wf12(:,11), n3(:,22), t3x12(:,:,11))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,4), wf12(:,12), n3(:,23), t3x12(:,:,12))
  call counter_WWV_V(EWctWWWW,ntry, ex3(:), ex4(:), ex5(:), wf27(:,2), n4(:,2), t4x27(:,:,2))
  call counter_QA_W(ntry, ex1(:), ex2(:), wf4(:,2), n3(:,24), t3x4(:,:,2))
  call counter_VV_S(ntry, wf4(:,1), ex4(:), wf12(:,13), n3(:,25), t3x12(:,:,13))
  call counter_UV_W(ntry, wf4(:,1), 3, ex4(:), 8, wf12(:,14), n3(:,26), t3x12(:,:,14))
  call counter_VV_S(ntry, ex4(:), ex5(:), wf9(:,5), n3(:,27), t3x9(:,:,5))
  call counter_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,6), n3(:,28), t3x9(:,:,6))
  call counter_V_V(EWctWW,ntry, wf4(:,1), 3, wf4(:,3), n2(5))
  call counter_VV_S(ntry, wf4(:,1), ex3(:), wf12(:,15), n3(:,29), t3x12(:,:,15))
  call counter_UV_W(ntry, wf4(:,1), 3, ex3(:), 4, wf12(:,16), n3(:,30), t3x12(:,:,16))
  call counter_VV_S(ntry, ex3(:), ex5(:), wf9(:,7), n3(:,31), t3x9(:,:,7))
  call counter_UV_W(ntry, ex5(:), 16, ex3(:), 4, wf9(:,8), n3(:,32), t3x9(:,:,8))
  call counter_WQ_A(ntry, ex5(:), wf6(:,3), wf18(:,3), n3(:,33), t3x18(:,:,3))
  call counter_WQ_A(ntry, ex5(:), wf6(:,7), wf18(:,4), n3(:,34), t3x18(:,:,4))
  call counter_QA_V(ntry, wf6(:,3), ex2(:), wf12(:,17), n3(:,35), t3x12(:,:,17))
  call counter_QA_V_LR(EWctAdd,ntry, wf6(:,3), ex2(:), wf12(:,18), n3(:,36), t3x12(:,:,18))
  call counter_QA_Z(gZd,ntry, wf6(:,3), ex2(:), wf12(:,19), n3(:,37), t3x12(:,:,19))
  call counter_QA_Z(EWctVdd,ntry, wf6(:,3), ex2(:), wf12(:,20), n3(:,38), t3x12(:,:,20))
  call counter_AW_Q(ntry, ex2(:), ex4(:), wf6(:,9), n3(:,39), t3x6(:,:,5))
  call prop_A_Q(ntry, wf6(:,9), 10, ZERO, 0_intkind1, wf6(:,10), n2(6))
  call counter_QA_V(ntry, wf6(:,7), ex2(:), wf12(:,21), n3(:,40), t3x12(:,:,21))
  call counter_QA_V_LR(EWctAdd,ntry, wf6(:,7), ex2(:), wf12(:,22), n3(:,41), t3x12(:,:,22))
  call counter_QA_Z(gZd,ntry, wf6(:,7), ex2(:), wf12(:,23), n3(:,42), t3x12(:,:,23))
  call counter_QA_Z(EWctVdd,ntry, wf6(:,7), ex2(:), wf12(:,24), n3(:,43), t3x12(:,:,24))
  call vert_QA_V(ntry, ex1(:), wf6(:,10), wf12(:,25), n3(:,44), t3x12(:,:,25))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,10), wf12(:,26), n3(:,45), t3x12(:,:,26))
  call counter_AW_Q(ntry, ex2(:), ex3(:), wf6(:,11), n3(:,46), t3x6(:,:,6))
  call prop_A_Q(ntry, wf6(:,11), 6, ZERO, 0_intkind1, wf6(:,12), n2(7))
  call vert_QA_V(ntry, ex1(:), wf6(:,12), wf12(:,27), n3(:,47), t3x12(:,:,27))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,12), wf12(:,28), n3(:,48), t3x12(:,:,28))
  call counter_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,29), n3(:,49), t3x12(:,:,29))
  call counter_QA_V_LR(EWctAuu,ntry, ex1(:), wf6(:,8), wf12(:,30), n3(:,50), t3x12(:,:,30))
  call counter_QA_Z(gZu,ntry, ex1(:), wf6(:,8), wf12(:,31), n3(:,51), t3x12(:,:,31))
  call counter_QA_Z(EWctVuu,ntry, ex1(:), wf6(:,8), wf12(:,32), n3(:,52), t3x12(:,:,32))
  call counter_WQ_A(ntry, ex4(:), ex1(:), wf6(:,13), n3(:,53), t3x6(:,:,7))
  call prop_Q_A(ntry, wf6(:,13), 9, ZERO, 0_intkind1, wf6(:,14), n2(8))
  call vert_WQ_A(ntry, ex5(:), wf6(:,14), wf18(:,5), n3(:,54), t3x18(:,:,5))
  call counter_QA_V(ntry, ex1(:), wf6(:,4), wf12(:,33), n3(:,55), t3x12(:,:,33))
  call counter_QA_V_LR(EWctAuu,ntry, ex1(:), wf6(:,4), wf12(:,34), n3(:,56), t3x12(:,:,34))
  call counter_QA_Z(gZu,ntry, ex1(:), wf6(:,4), wf12(:,35), n3(:,57), t3x12(:,:,35))
  call counter_QA_Z(EWctVuu,ntry, ex1(:), wf6(:,4), wf12(:,36), n3(:,58), t3x12(:,:,36))
  call vert_QA_V(ntry, wf6(:,14), ex2(:), wf12(:,37), n3(:,59), t3x12(:,:,37))
  call vert_QA_Z(gZd,ntry, wf6(:,14), ex2(:), wf12(:,38), n3(:,60), t3x12(:,:,38))
  call counter_WQ_A(ntry, ex3(:), ex1(:), wf6(:,15), n3(:,61), t3x6(:,:,8))
  call prop_Q_A(ntry, wf6(:,15), 5, ZERO, 0_intkind1, wf6(:,16), n2(9))
  call vert_WQ_A(ntry, ex5(:), wf6(:,16), wf18(:,6), n3(:,62), t3x18(:,:,6))
  call vert_QA_V(ntry, wf6(:,16), ex2(:), wf12(:,39), n3(:,63), t3x12(:,:,39))
  call vert_QA_Z(gZd,ntry, wf6(:,16), ex2(:), wf12(:,40), n3(:,64), t3x12(:,:,40))
  call counter_AQ_S(gPdu,ntry, ex2(:), ex1(:), wf4(:,4), n3(:,65), t3x4(:,:,3))
  call vert_VS_T(ntry, ex4(:), 8, wf4(:,4), 3, wf12(:,41), n3(:,66), t3x12(:,:,41))
  call vert_SV_V(ntry, wf4(:,4), ex4(:), wf12(:,42), n3(:,67), t3x12(:,:,42))
  call vert_VV_S(ntry, wf4(:,2), ex4(:), wf12(:,43), n3(:,68), t3x12(:,:,43))
  call vert_UV_W(ntry, wf4(:,2), 3, ex4(:), 8, wf12(:,44), n3(:,69), t3x12(:,:,44))
  call vert_VS_T(ntry, ex3(:), 4, wf4(:,4), 3, wf12(:,45), n3(:,70), t3x12(:,:,45))
  call vert_SV_V(ntry, wf4(:,4), ex3(:), wf12(:,46), n3(:,71), t3x12(:,:,46))
  call vert_VV_S(ntry, wf4(:,2), ex3(:), wf12(:,47), n3(:,72), t3x12(:,:,47))
  call vert_UV_W(ntry, wf4(:,2), 3, ex3(:), 4, wf12(:,48), n3(:,73), t3x12(:,:,48))
  call vert_TV_S(ntry, wf9(:,1), 20, ex4(:), 8, wf27(:,3), n3(:,74), t3x27(:,:,1))
  call counter_V_S(EWctPW,ntry, wf4(:,1), 3, wf4(:,5), n2(10))
  call vert_VV_S(ntry, ex4(:), wf9(:,2), wf27(:,4), n3(:,75), t3x27(:,:,2))
  call vert_SV_V(ntry, wf9(:,1), ex4(:), wf27(:,5), n3(:,76), t3x27(:,:,3))
  call vert_UV_W(ntry, ex4(:), 8, wf9(:,2), 20, wf27(:,6), n3(:,77), t3x27(:,:,4))
  call counter_S_S(EWctHH,ntry, wf9(:,1), 20, wf9(:,9), n2(11))
  call counter_V_V(EWctAA,ntry, wf9(:,2), 20, wf9(:,10), n2(12))
  call counter_V_V(EWctAZ,ntry, wf9(:,2), 20, wf9(:,11), n2(13))
  call counter_V_V(EWctZZ,ntry, wf9(:,2), 20, wf9(:,12), n2(14))
  call vert_TV_S(ntry, wf9(:,3), 24, ex3(:), 4, wf27(:,7), n3(:,78), t3x27(:,:,5))
  call vert_VV_S(ntry, ex3(:), wf9(:,4), wf27(:,8), n3(:,79), t3x27(:,:,6))
  call vert_SV_V(ntry, wf9(:,3), ex3(:), wf27(:,9), n3(:,80), t3x27(:,:,7))
  call vert_UV_W(ntry, ex3(:), 4, wf9(:,4), 24, wf27(:,10), n3(:,81), t3x27(:,:,8))
  call counter_S_S(EWctHH,ntry, wf9(:,3), 24, wf9(:,13), n2(15))
  call counter_V_V(EWctAA,ntry, wf9(:,4), 24, wf9(:,14), n2(16))
  call counter_V_V(EWctAZ,ntry, wf9(:,4), 24, wf9(:,15), n2(17))
  call counter_V_V(EWctZZ,ntry, wf9(:,4), 24, wf9(:,16), n2(18))
  call vert_AW_Q(ntry, wf6(:,4), ex5(:), wf18(:,7), n3(:,82), t3x18(:,:,7))
  call counter_Q_A(ctqq,1,ntry, wf6(:,3), 5, wf6(:,17), n2(19))
  call prop_A_Q(ntry, wf18(:,7), 26, ZERO, 0_intkind1, wf18(:,8), n2(20))
  call counter_Q_A_LR(EWctdd,ntry, wf6(:,3), 5, wf6(:,18), n2(21))
  call counter_A_Q(ctqq,2,ntry, wf6(:,4), 10, wf6(:,19), n2(22))
  call prop_Q_A(ntry, wf18(:,1), 21, ZERO, 0_intkind1, wf18(:,9), n2(23))
  call counter_A_Q_LR(EWctuu,ntry, wf6(:,4), 10, wf6(:,20), n2(24))
  call vert_AV_Q(ntry, ex2(:), wf9(:,4), wf18(:,10), n3(:,83), t3x18(:,:,8))
  call prop_A_Q(ntry, wf18(:,10), 26, ZERO, 0_intkind1, wf18(:,11), n2(25))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf9(:,4), wf18(:,12), n3(:,84), t3x18(:,:,9))
  call prop_A_Q(ntry, wf18(:,12), 26, ZERO, 0_intkind1, wf18(:,13), n2(26))
  call vert_AW_Q(ntry, wf6(:,8), ex5(:), wf18(:,14), n3(:,85), t3x18(:,:,10))
  call counter_Q_A(ctqq,1,ntry, wf6(:,7), 9, wf6(:,21), n2(27))
  call prop_A_Q(ntry, wf18(:,14), 22, ZERO, 0_intkind1, wf18(:,15), n2(28))
  call counter_Q_A_LR(EWctdd,ntry, wf6(:,7), 9, wf6(:,22), n2(29))
  call counter_A_Q(ctqq,2,ntry, wf6(:,8), 6, wf6(:,23), n2(30))
  call prop_Q_A(ntry, wf18(:,2), 25, ZERO, 0_intkind1, wf18(:,16), n2(31))
  call counter_A_Q_LR(EWctuu,ntry, wf6(:,8), 6, wf6(:,24), n2(32))
  call vert_VQ_A(ntry, wf9(:,4), ex1(:), wf18(:,17), n3(:,86), t3x18(:,:,11))
  call prop_Q_A(ntry, wf18(:,17), 25, ZERO, 0_intkind1, wf18(:,18), n2(33))
  call vert_ZQ_A(gZu,ntry, wf9(:,4), ex1(:), wf18(:,19), n3(:,87), t3x18(:,:,12))
  call prop_Q_A(ntry, wf18(:,19), 25, ZERO, 0_intkind1, wf18(:,20), n2(34))
  call vert_AV_Q(ntry, ex2(:), wf9(:,2), wf18(:,21), n3(:,88), t3x18(:,:,13))
  call prop_A_Q(ntry, wf18(:,21), 22, ZERO, 0_intkind1, wf18(:,22), n2(35))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf9(:,2), wf18(:,23), n3(:,89), t3x18(:,:,14))
  call prop_A_Q(ntry, wf18(:,23), 22, ZERO, 0_intkind1, wf18(:,24), n2(36))
  call vert_VQ_A(ntry, wf9(:,2), ex1(:), wf18(:,25), n3(:,90), t3x18(:,:,15))
  call prop_Q_A(ntry, wf18(:,25), 21, ZERO, 0_intkind1, wf18(:,26), n2(37))
  call vert_ZQ_A(gZu,ntry, wf9(:,2), ex1(:), wf18(:,27), n3(:,91), t3x18(:,:,16))
  call prop_Q_A(ntry, wf18(:,27), 21, ZERO, 0_intkind1, wf18(:,28), n2(38))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf6)
  call init_hybrid_wf(wf9)
  call init_hybrid_wf(wf12)
  call init_hybrid_wf(wf18)
  call init_hybrid_wf(wf27)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppvvv_ew_udxwwwx_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

#if 1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
  ind_cc_comb = [8,12,9,13,14]
  M0M1_hel_cc(:,:,:)%j = 0
  M2ctcc = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 3
do i3= 1, 3
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,1), wf27(:,1), A(:,1), n3(:,92), t3x108(:,:,1), nhel, den(1))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,1), A(:,2), n3(:,93), t3x108(:,:,2), nhel, den(3))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,2), A(:,3), n3(:,94), t3x108(:,:,3), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,2), A(:,4), n3(:,95), t3x108(:,:,4), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,3), A(:,5), n3(:,96), t3x108(:,:,5), nhel, den(9))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,4), A(:,6), n3(:,97), t3x108(:,:,6), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,4), A(:,7), n3(:,98), t3x108(:,:,7), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,1), A(:,8), n3(:,99), t3x108(:,:,8), nhel, den(16))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,5), A(:,9), n3(:,100), t3x108(:,:,9), nhel, den(17))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,6), A(:,10), n3(:,101), t3x108(:,:,10), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,8), wf18(:,2), A(:,11), n3(:,102), t3x108(:,:,11), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,7), A(:,12), n3(:,103), t3x108(:,:,12), nhel, den(22))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,8), A(:,13), n3(:,104), t3x108(:,:,13), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,9), A(:,14), n3(:,105), t3x108(:,:,14), nhel, den(24))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,10), A(:,15), n3(:,106), t3x108(:,:,15), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,11), A(:,16), n3(:,107), t3x108(:,:,16), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,12), A(:,17), n3(:,108), t3x108(:,:,17), nhel, den(27))

    call Hcont_VV(nsync, wf4(:,1), wf27(:,2), A(:,18), n3(:,109), t3x108(:,:,18), nhel, den(1))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,2), A(:,19), n3(:,110), t3x108(:,:,19), nhel, den(28))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,2), A(:,20), n3(:,111), t3x108(:,:,20), nhel, den(28))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,13), A(:,21), n3(:,112), t3x108(:,:,21), nhel, den(3))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,14), A(:,22), n3(:,113), t3x108(:,:,22), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,14), A(:,23), n3(:,114), t3x108(:,:,23), nhel, den(7))
    call Hcont_SS(nsync, wf12(:,3), wf9(:,5), A(:,24), n3(:,115), t3x108(:,:,24), nhel, den(9))
    call Hcont_VV(nsync, wf12(:,4), wf9(:,6), A(:,25), n3(:,116), t3x108(:,:,25), nhel, den(11))
    call Hcont_VV(nsync, wf12(:,4), wf9(:,6), A(:,26), n3(:,117), t3x108(:,:,26), nhel, den(13))
    call Hcont_VV(nsync, wf27(:,1), wf4(:,3), A(:,27), n3(:,118), t3x108(:,:,27), nhel, den(29))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,15), A(:,28), n3(:,119), t3x108(:,:,28), nhel, den(9))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,16), A(:,29), n3(:,120), t3x108(:,:,29), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,16), A(:,30), n3(:,121), t3x108(:,:,30), nhel, den(13))
    call Hcont_SS(nsync, wf12(:,1), wf9(:,7), A(:,31), n3(:,122), t3x108(:,:,31), nhel, den(3))
    call Hcont_VV(nsync, wf12(:,2), wf9(:,8), A(:,32), n3(:,123), t3x108(:,:,32), nhel, den(5))
    call Hcont_VV(nsync, wf12(:,2), wf9(:,8), A(:,33), n3(:,124), t3x108(:,:,33), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,3), A(:,34), n3(:,125), t3x108(:,:,34), nhel, den(16))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,3), A(:,35), n3(:,126), t3x108(:,:,35), nhel, den(16))
    call Hcont_VV(nsync, wf12(:,5), wf9(:,6), A(:,36), n3(:,127), t3x108(:,:,36), nhel, den(17))
    call Hcont_VV(nsync, wf12(:,6), wf9(:,6), A(:,37), n3(:,128), t3x108(:,:,37), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,8), wf18(:,4), A(:,38), n3(:,129), t3x108(:,:,38), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,8), wf18(:,4), A(:,39), n3(:,130), t3x108(:,:,39), nhel, den(21))
    call Hcont_VV(nsync, wf12(:,7), wf9(:,6), A(:,40), n3(:,131), t3x108(:,:,40), nhel, den(22))
    call Hcont_VV(nsync, wf12(:,8), wf9(:,6), A(:,41), n3(:,132), t3x108(:,:,41), nhel, den(23))
    call Hcont_VV(nsync, wf12(:,9), wf9(:,8), A(:,42), n3(:,133), t3x108(:,:,42), nhel, den(24))
    call Hcont_VV(nsync, wf12(:,10), wf9(:,8), A(:,43), n3(:,134), t3x108(:,:,43), nhel, den(25))
    call Hcont_VV(nsync, wf12(:,11), wf9(:,8), A(:,44), n3(:,135), t3x108(:,:,44), nhel, den(26))
    call Hcont_VV(nsync, wf12(:,12), wf9(:,8), A(:,45), n3(:,136), t3x108(:,:,45), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,17), A(:,46), n3(:,137), t3x108(:,:,46), nhel, den(17))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,18), A(:,47), n3(:,138), t3x108(:,:,47), nhel, den(17))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,19), A(:,48), n3(:,139), t3x108(:,:,48), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,20), A(:,49), n3(:,140), t3x108(:,:,49), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,1), wf6(:,10), A(:,50), n3(:,141), t3x108(:,:,50), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,1), wf6(:,10), A(:,51), n3(:,142), t3x108(:,:,51), nhel, den(16))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,21), A(:,52), n3(:,143), t3x108(:,:,52), nhel, den(24))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,22), A(:,53), n3(:,144), t3x108(:,:,53), nhel, den(24))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,23), A(:,54), n3(:,145), t3x108(:,:,54), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,24), A(:,55), n3(:,146), t3x108(:,:,55), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,25), A(:,56), n3(:,147), t3x108(:,:,56), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,25), A(:,57), n3(:,148), t3x108(:,:,57), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,26), A(:,58), n3(:,149), t3x108(:,:,58), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,26), A(:,59), n3(:,150), t3x108(:,:,59), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,2), wf6(:,12), A(:,60), n3(:,151), t3x108(:,:,60), nhel, den(21))
    call Hcont_QA(nsync, wf18(:,2), wf6(:,12), A(:,61), n3(:,152), t3x108(:,:,61), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,27), A(:,62), n3(:,153), t3x108(:,:,62), nhel, den(22))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,27), A(:,63), n3(:,154), t3x108(:,:,63), nhel, den(22))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,28), A(:,64), n3(:,155), t3x108(:,:,64), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,28), A(:,65), n3(:,156), t3x108(:,:,65), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,29), A(:,66), n3(:,157), t3x108(:,:,66), nhel, den(22))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,30), A(:,67), n3(:,158), t3x108(:,:,67), nhel, den(22))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,31), A(:,68), n3(:,159), t3x108(:,:,68), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,32), A(:,69), n3(:,160), t3x108(:,:,69), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,8), wf18(:,5), A(:,70), n3(:,161), t3x108(:,:,70), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,8), wf18(:,5), A(:,71), n3(:,162), t3x108(:,:,71), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,33), A(:,72), n3(:,163), t3x108(:,:,72), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,34), A(:,73), n3(:,164), t3x108(:,:,73), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,35), A(:,74), n3(:,165), t3x108(:,:,74), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,36), A(:,75), n3(:,166), t3x108(:,:,75), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,37), A(:,76), n3(:,167), t3x108(:,:,76), nhel, den(24))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,37), A(:,77), n3(:,168), t3x108(:,:,77), nhel, den(24))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,38), A(:,78), n3(:,169), t3x108(:,:,78), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,38), A(:,79), n3(:,170), t3x108(:,:,79), nhel, den(25))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,6), A(:,80), n3(:,171), t3x108(:,:,80), nhel, den(16))
    call Hcont_QA(nsync, wf6(:,4), wf18(:,6), A(:,81), n3(:,172), t3x108(:,:,81), nhel, den(16))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,39), A(:,82), n3(:,173), t3x108(:,:,82), nhel, den(17))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,39), A(:,83), n3(:,174), t3x108(:,:,83), nhel, den(17))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,40), A(:,84), n3(:,175), t3x108(:,:,84), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,40), A(:,85), n3(:,176), t3x108(:,:,85), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,41), A(:,86), n3(:,177), t3x108(:,:,86), nhel, den(3))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,42), A(:,87), n3(:,178), t3x108(:,:,87), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,42), A(:,88), n3(:,179), t3x108(:,:,88), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,43), A(:,89), n3(:,180), t3x108(:,:,89), nhel, den(3))
    call Hcont_SS(nsync, wf9(:,1), wf12(:,43), A(:,90), n3(:,181), t3x108(:,:,90), nhel, den(3))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,44), A(:,91), n3(:,182), t3x108(:,:,91), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,44), A(:,92), n3(:,183), t3x108(:,:,92), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,44), A(:,93), n3(:,184), t3x108(:,:,93), nhel, den(7))
    call Hcont_VV(nsync, wf9(:,2), wf12(:,44), A(:,94), n3(:,185), t3x108(:,:,94), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,45), A(:,95), n3(:,186), t3x108(:,:,95), nhel, den(9))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,46), A(:,96), n3(:,187), t3x108(:,:,96), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,46), A(:,97), n3(:,188), t3x108(:,:,97), nhel, den(13))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,47), A(:,98), n3(:,189), t3x108(:,:,98), nhel, den(9))
    call Hcont_SS(nsync, wf9(:,3), wf12(:,47), A(:,99), n3(:,190), t3x108(:,:,99), nhel, den(9))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,48), A(:,100), n3(:,191), t3x108(:,:,100), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,48), A(:,101), n3(:,192), t3x108(:,:,101), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,48), A(:,102), n3(:,193), t3x108(:,:,102), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,4), wf12(:,48), A(:,103), n3(:,194), t3x108(:,:,103), nhel, den(13))
    call Hcont_SS(nsync, wf27(:,3), wf4(:,5), A(:,104), n3(:,195), t3x108(:,:,104), nhel, den(31))
    call Hcont_SS(nsync, wf4(:,5), wf27(:,4), A(:,105), n3(:,196), t3x108(:,:,105), nhel, den(33))
    call Hcont_SS(nsync, wf4(:,5), wf27(:,4), A(:,106), n3(:,197), t3x108(:,:,106), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,3), wf27(:,5), A(:,107), n3(:,198), t3x108(:,:,107), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,3), wf27(:,6), A(:,108), n3(:,199), t3x108(:,:,108), nhel, den(33))
    call Hcont_VV(nsync, wf4(:,3), wf27(:,6), A(:,109), n3(:,200), t3x108(:,:,109), nhel, den(35))
    call Hcont_SS(nsync, wf12(:,1), wf9(:,9), A(:,110), n3(:,201), t3x108(:,:,110), nhel, den(38))
    call Hcont_VV(nsync, wf12(:,2), wf9(:,10), A(:,111), n3(:,202), t3x108(:,:,111), nhel, den(41))
    call Hcont_VV(nsync, wf12(:,2), wf9(:,11), A(:,112), n3(:,203), t3x108(:,:,112), nhel, den(44))
    call Hcont_VV(nsync, wf12(:,2), wf9(:,11), A(:,113), n3(:,204), t3x108(:,:,113), nhel, den(45))
    call Hcont_VV(nsync, wf12(:,2), wf9(:,12), A(:,114), n3(:,205), t3x108(:,:,114), nhel, den(46))
    call Hcont_SS(nsync, wf4(:,5), wf27(:,7), A(:,115), n3(:,206), t3x108(:,:,115), nhel, den(48))
    call Hcont_SS(nsync, wf4(:,5), wf27(:,8), A(:,116), n3(:,207), t3x108(:,:,116), nhel, den(50))
    call Hcont_SS(nsync, wf4(:,5), wf27(:,8), A(:,117), n3(:,208), t3x108(:,:,117), nhel, den(52))
    call Hcont_VV(nsync, wf4(:,3), wf27(:,9), A(:,118), n3(:,209), t3x108(:,:,118), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,3), wf27(:,10), A(:,119), n3(:,210), t3x108(:,:,119), nhel, den(50))
    call Hcont_VV(nsync, wf4(:,3), wf27(:,10), A(:,120), n3(:,211), t3x108(:,:,120), nhel, den(52))
    call Hcont_SS(nsync, wf12(:,3), wf9(:,13), A(:,121), n3(:,212), t3x108(:,:,121), nhel, den(55))
    call Hcont_VV(nsync, wf12(:,4), wf9(:,14), A(:,122), n3(:,213), t3x108(:,:,122), nhel, den(58))
    call Hcont_VV(nsync, wf12(:,4), wf9(:,15), A(:,123), n3(:,214), t3x108(:,:,123), nhel, den(59))
    call Hcont_VV(nsync, wf12(:,4), wf9(:,15), A(:,124), n3(:,215), t3x108(:,:,124), nhel, den(62))
    call Hcont_VV(nsync, wf12(:,4), wf9(:,16), A(:,125), n3(:,216), t3x108(:,:,125), nhel, den(63))
    call Hcont_QA(nsync, wf6(:,17), wf18(:,8), A(:,126), n3(:,217), t3x108(:,:,126), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,8), wf6(:,18), A(:,127), n3(:,218), t3x108(:,:,127), nhel, den(66))
    call Hcont_QA(nsync, wf6(:,19), wf18(:,9), A(:,128), n3(:,219), t3x108(:,:,128), nhel, den(69))
    call Hcont_QA(nsync, wf18(:,9), wf6(:,20), A(:,129), n3(:,220), t3x108(:,:,129), nhel, den(69))
    call Hcont_QA(nsync, wf6(:,17), wf18(:,11), A(:,130), n3(:,221), t3x108(:,:,130), nhel, den(71))
    call Hcont_QA(nsync, wf6(:,18), wf18(:,11), A(:,131), n3(:,222), t3x108(:,:,131), nhel, den(71))
    call Hcont_QA(nsync, wf6(:,17), wf18(:,13), A(:,132), n3(:,223), t3x108(:,:,132), nhel, den(73))
    call Hcont_QA(nsync, wf6(:,18), wf18(:,13), A(:,133), n3(:,224), t3x108(:,:,133), nhel, den(73))
    call Hcont_VV(nsync, wf12(:,5), wf9(:,14), A(:,134), n3(:,225), t3x108(:,:,134), nhel, den(75))
    call Hcont_VV(nsync, wf12(:,5), wf9(:,15), A(:,135), n3(:,226), t3x108(:,:,135), nhel, den(76))
    call Hcont_VV(nsync, wf12(:,6), wf9(:,15), A(:,136), n3(:,227), t3x108(:,:,136), nhel, den(78))
    call Hcont_VV(nsync, wf12(:,6), wf9(:,16), A(:,137), n3(:,228), t3x108(:,:,137), nhel, den(79))
    call Hcont_QA(nsync, wf6(:,21), wf18(:,15), A(:,138), n3(:,229), t3x108(:,:,138), nhel, den(82))
    call Hcont_QA(nsync, wf18(:,15), wf6(:,22), A(:,139), n3(:,230), t3x108(:,:,139), nhel, den(82))
    call Hcont_QA(nsync, wf6(:,23), wf18(:,16), A(:,140), n3(:,231), t3x108(:,:,140), nhel, den(85))
    call Hcont_QA(nsync, wf18(:,16), wf6(:,24), A(:,141), n3(:,232), t3x108(:,:,141), nhel, den(85))
    call Hcont_QA(nsync, wf6(:,23), wf18(:,18), A(:,142), n3(:,233), t3x108(:,:,142), nhel, den(87))
    call Hcont_QA(nsync, wf6(:,24), wf18(:,18), A(:,143), n3(:,234), t3x108(:,:,143), nhel, den(87))
    call Hcont_QA(nsync, wf6(:,23), wf18(:,20), A(:,144), n3(:,235), t3x108(:,:,144), nhel, den(89))
    call Hcont_QA(nsync, wf6(:,24), wf18(:,20), A(:,145), n3(:,236), t3x108(:,:,145), nhel, den(89))
    call Hcont_VV(nsync, wf12(:,7), wf9(:,14), A(:,146), n3(:,237), t3x108(:,:,146), nhel, den(91))
    call Hcont_VV(nsync, wf12(:,7), wf9(:,15), A(:,147), n3(:,238), t3x108(:,:,147), nhel, den(92))
    call Hcont_VV(nsync, wf12(:,8), wf9(:,15), A(:,148), n3(:,239), t3x108(:,:,148), nhel, den(94))
    call Hcont_VV(nsync, wf12(:,8), wf9(:,16), A(:,149), n3(:,240), t3x108(:,:,149), nhel, den(95))
    call Hcont_QA(nsync, wf6(:,21), wf18(:,22), A(:,150), n3(:,241), t3x108(:,:,150), nhel, den(97))
    call Hcont_QA(nsync, wf6(:,22), wf18(:,22), A(:,151), n3(:,242), t3x108(:,:,151), nhel, den(97))
    call Hcont_QA(nsync, wf6(:,21), wf18(:,24), A(:,152), n3(:,243), t3x108(:,:,152), nhel, den(99))
    call Hcont_QA(nsync, wf6(:,22), wf18(:,24), A(:,153), n3(:,244), t3x108(:,:,153), nhel, den(99))
    call Hcont_VV(nsync, wf12(:,9), wf9(:,10), A(:,154), n3(:,245), t3x108(:,:,154), nhel, den(101))
    call Hcont_VV(nsync, wf12(:,9), wf9(:,11), A(:,155), n3(:,246), t3x108(:,:,155), nhel, den(102))
    call Hcont_VV(nsync, wf12(:,10), wf9(:,11), A(:,156), n3(:,247), t3x108(:,:,156), nhel, den(104))
    call Hcont_VV(nsync, wf12(:,10), wf9(:,12), A(:,157), n3(:,248), t3x108(:,:,157), nhel, den(105))
    call Hcont_QA(nsync, wf6(:,19), wf18(:,26), A(:,158), n3(:,249), t3x108(:,:,158), nhel, den(107))
    call Hcont_QA(nsync, wf6(:,20), wf18(:,26), A(:,159), n3(:,250), t3x108(:,:,159), nhel, den(107))
    call Hcont_QA(nsync, wf6(:,19), wf18(:,28), A(:,160), n3(:,251), t3x108(:,:,160), nhel, den(109))
    call Hcont_QA(nsync, wf6(:,20), wf18(:,28), A(:,161), n3(:,252), t3x108(:,:,161), nhel, den(109))
    call Hcont_VV(nsync, wf12(:,11), wf9(:,10), A(:,162), n3(:,253), t3x108(:,:,162), nhel, den(111))
    call Hcont_VV(nsync, wf12(:,11), wf9(:,11), A(:,163), n3(:,254), t3x108(:,:,163), nhel, den(112))
    call Hcont_VV(nsync, wf12(:,12), wf9(:,11), A(:,164), n3(:,255), t3x108(:,:,164), nhel, den(114))
    call Hcont_VV(nsync, wf12(:,12), wf9(:,12), A(:,165), n3(:,256), t3x108(:,:,165), nhel, den(115))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(2) ! M1helarray(2,108)
  integer :: empty(0), i

  M1(1)%j = -(A(j,1)%j*f(1))+(-A(j,4)%j-A(j,7)%j)*f(2)+(A(j,2)%j+A(j,5)%j)*f(11)+(-A(j,8)%j-A(j,11)%j)*f(15)+(-A(j,10)%j-A(j,13)%j &
       -A(j,15)%j-A(j,17)%j)*f(21)+(A(j,9)%j+A(j,14)%j)*f(30)+(-A(j,12)%j-A(j,16)%j)*f(31)+(-A(j,3)%j-A(j,6)%j)*f(32)

  M2(1)%j = (A(j,86)%j+A(j,95)%j)*f(7)-A(j,19)%j*f(8)+(-A(j,93)%j-A(j,102)%j)*f(9)+(A(j,89)%j+A(j,98)%j)*f(14)+(A(j,126)%j &
       +A(j,128)%j+A(j,138)%j+A(j,140)%j)*f(19)+(-A(j,34)%j-A(j,38)%j-A(j,50)%j-A(j,60)%j-A(j,70)%j-A(j,80)%j)*f(20)+(A(j,132)%j &
       +A(j,144)%j+A(j,152)%j+A(j,160)%j)*f(27)+(-A(j,48)%j-A(j,54)%j-A(j,58)%j-A(j,64)%j-A(j,68)%j-A(j,74)%j-A(j,78)%j &
       -A(j,84)%j)*f(28)+(-A(j,130)%j-A(j,150)%j)*f(43)+(A(j,142)%j+A(j,158)%j)*f(44)+(A(j,87)%j-A(j,88)%j+A(j,96)%j &
       -A(j,97)%j)*f(45)+(A(j,46)%j+A(j,52)%j+A(j,76)%j+A(j,82)%j)*f(46)+(-A(j,56)%j-A(j,62)%j-A(j,66)%j-A(j,72)%j)*f(47)+( &
       -A(j,91)%j-A(j,100)%j)*f(48)
  M2(2)%j = A(j,27)%j*f(3)+(A(j,109)%j+A(j,114)%j+A(j,120)%j+A(j,125)%j)*f(4)-A(j,20)%j*f(5)+(-A(j,94)%j-A(j,103)%j)*f(6)+( &
       -A(j,104)%j-A(j,115)%j)*f(10)+(-A(j,107)%j-A(j,110)%j-A(j,118)%j-A(j,121)%j)*f(12)+(A(j,90)%j+A(j,99)%j)*f(13)+(A(j,127)%j &
       +A(j,129)%j+A(j,139)%j+A(j,141)%j)*f(16)+(-A(j,51)%j-A(j,61)%j-A(j,71)%j-A(j,81)%j)*f(17)+(-A(j,35)%j-A(j,39)%j)*f(18) &
       +(A(j,135)%j+A(j,155)%j)*f(22)+(-A(j,147)%j-A(j,163)%j)*f(23)+(-A(j,49)%j-A(j,55)%j-A(j,69)%j-A(j,75)%j-A(j,112)%j &
       -A(j,113)%j-A(j,123)%j-A(j,124)%j+A(j,133)%j+A(j,137)%j+A(j,145)%j+A(j,149)%j+A(j,153)%j+A(j,157)%j+A(j,161)%j &
       +A(j,165)%j)*f(24)+(-A(j,59)%j-A(j,65)%j-A(j,79)%j-A(j,85)%j)*f(25)+(A(j,23)%j+A(j,26)%j+A(j,30)%j+A(j,33)%j)*f(26) &
       +(A(j,21)%j+A(j,24)%j+A(j,28)%j+A(j,31)%j)*f(29)+(-A(j,131)%j-A(j,134)%j-A(j,151)%j-A(j,154)%j)*f(33)+(A(j,143)%j &
       +A(j,146)%j+A(j,159)%j+A(j,162)%j)*f(34)+(-A(j,18)%j+A(j,47)%j+A(j,53)%j+A(j,67)%j+A(j,73)%j+A(j,108)%j+A(j,111)%j &
       +A(j,119)%j+A(j,122)%j-A(j,136)%j-A(j,148)%j-A(j,156)%j-A(j,164)%j)*f(35)+(A(j,36)%j+A(j,42)%j)*f(36)+(-A(j,40)%j &
       -A(j,44)%j)*f(37)+(-A(j,22)%j-A(j,25)%j-A(j,29)%j-A(j,32)%j)*f(38)+(A(j,77)%j+A(j,83)%j)*f(39)+(-A(j,57)%j-A(j,63)%j)*f(40) &
       +(-A(j,92)%j-A(j,101)%j)*f(41)+(A(j,37)%j+A(j,41)%j+A(j,43)%j+A(j,45)%j)*f(42)+(-A(j,105)%j+A(j,106)%j-A(j,116)%j &
       +A(j,117)%j)*f(49)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_udxwwwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_udxwwwx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_udxwwwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_udxwwwx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_udxwwwx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppvvv_ew_udxwwwx_1_/**/REALKIND
