
module ol_colourmatrix_ppvvv_ew_ddxawwx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,2), KL(17,2), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2( 1,:) = [ 0, 3]
  K2( 2,:) = [ 0, 0]
  K2( 3,:) = [ 0, 0]
  K2( 4,:) = [ 0, 0]
  K2( 5,:) = [ 0, 0]
  K2( 6,:) = [ 0, 0]
  K2( 7,:) = [ 0, 0]
  K2( 8,:) = [ 0, 0]
  K2( 9,:) = [ 0, 0]
  K2(10,:) = [ 0, 0]
  K2(11,:) = [ 0, 0]
  K2(12,:) = [ 0, 0]
  K2(13,:) = [ 0, 0]
  K2(14,:) = [ 0, 0]
  K2(15,:) = [ 0, 0]
  K2(16,:) = [ 0, 0]
  K2(17,:) = [ 0, 3]

  KL( 1,:) = [ 3, 0]
  KL( 2,:) = [ 0, 0]
  KL( 3,:) = [ 0, 0]
  KL( 4,:) = [ 0, 0]
  KL( 5,:) = [ 0, 0]
  KL( 6,:) = [ 0, 0]
  KL( 7,:) = [ 0, 0]
  KL( 8,:) = [ 0, 0]
  KL( 9,:) = [ 0, 0]
  KL(10,:) = [ 0, 0]
  KL(11,:) = [ 0, 0]
  KL(12,:) = [ 0, 0]
  KL(13,:) = [ 0, 0]
  KL(14,:) = [ 0, 0]
  KL(15,:) = [ 0, 0]
  KL(16,:) = [ 0, 0]
  KL(17,:) = [ 3, 0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvv_ew_ddxawwx_1_/**/REALKIND



module ol_forced_parameters_ppvvv_ew_ddxawwx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvv_ew_ddxawwx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppvvv_ew_ddxawwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 72 ! number of helicity configurations
  integer(intkind2), save :: nhel = 72 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(72) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:)
  complex(REALKIND), save :: den(117)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(3), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,28), wf6(6,28), wf8(8,22), wf9(9,6), wf12(12,58), wf18(18,25), wf72(72,185)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(337), c(289)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,72), M0M1_hel_cc(2,72,16)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppvvv_ew_ddxawwx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppvvv_ew_ddxawwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppvvv_ew_ddxawwx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*eQED**3)/9._/**/REALKIND
    f(  2) = (CI*eQED**3)/3._/**/REALKIND
    f(  3) = (CI*countertermnorm*eQED**5)/9._/**/REALKIND
    f(  4) = (CI*countertermnorm*eQED**5)/3._/**/REALKIND
    f(  5) = CI*countertermnorm*eQED**5
    f(  6) = (CI*countertermnorm*eQED**5*EWctAWW)/9._/**/REALKIND
    f(  7) = (CI*countertermnorm*eQED**5*EWctAWW)/3._/**/REALKIND
    f(  8) = (CI*countertermnorm*eQED**5*EWctZWW)/3._/**/REALKIND
    f(  9) = CI*countertermnorm*eQED**5*EWctZWW
    f( 10) = (CI*countertermnorm*eQED**3*gQCD**2)/9._/**/REALKIND
    f( 11) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/9._/**/REALKIND
    f( 12) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 13) = (CI*countertermnorm*eQED**5*MW)/3._/**/REALKIND
    f( 14) = (CI*countertermnorm*eQED**5*EWctPWA*MW)/3._/**/REALKIND
    f( 15) = CI*countertermnorm*eQED**5*EWctPWZ*MW
    f( 16) = (CI*eQED**3*MW**2)/3._/**/REALKIND
    f( 17) = (CI*countertermnorm*eQED**5*MW**2)/3._/**/REALKIND
    f( 18) = CI*countertermnorm*eQED**5*MW**2
    f( 19) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW**2)/3._/**/REALKIND
    f( 20) = (CI*eQED**3)/(6._/**/REALKIND*sw**2)
    f( 21) = (CI*eQED**3)/(3._/**/REALKIND*sw**2)
    f( 22) = (CI*eQED**3)/(2._/**/REALKIND*sw**2)
    f( 23) = (CI*countertermnorm*eQED**5)/(6._/**/REALKIND*sw**2)
    f( 24) = (CI*countertermnorm*eQED**5)/(3._/**/REALKIND*sw**2)
    f( 25) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*sw**2)
    f( 26) = (CI*countertermnorm*eQED**5*EWctAWW)/(2._/**/REALKIND*sw**2)
    f( 27) = (CI*countertermnorm*eQED**5*EWctVdu)/(6._/**/REALKIND*sw**2)
    f( 28) = (CI*countertermnorm*eQED**5*EWctVdu)/(3._/**/REALKIND*sw**2)
    f( 29) = (CI*countertermnorm*eQED**5*EWctVdu)/(2._/**/REALKIND*sw**2)
    f( 30) = (CI*countertermnorm*eQED**5*EWctVud)/(6._/**/REALKIND*sw**2)
    f( 31) = (CI*countertermnorm*eQED**5*EWctVud)/(3._/**/REALKIND*sw**2)
    f( 32) = (CI*countertermnorm*eQED**5*EWctVud)/(2._/**/REALKIND*sw**2)
    f( 33) = (CI*countertermnorm*eQED**3*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 34) = (CI*countertermnorm*eQED**3*gQCD**2)/(3._/**/REALKIND*sw**2)
    f( 35) = (CI*countertermnorm*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 36) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 37) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 38) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/(3._/**/REALKIND*sw**2)
    f( 39) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 40) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*sw**2)
    f( 41) = (CI*cw*eQED**3)/(3._/**/REALKIND*sw)
    f( 42) = (CI*cw*eQED**3)/sw
    f( 43) = (CI*countertermnorm*cw*eQED**5)/(9._/**/REALKIND*sw)
    f( 44) = (CI*countertermnorm*cw*eQED**5)/(3._/**/REALKIND*sw)
    f( 45) = (CI*countertermnorm*cw*eQED**5)/sw
    f( 46) = (CI*countertermnorm*cw*eQED**5*EWctAWW)/sw
    f( 47) = (CI*countertermnorm*cw*eQED**3*gQCD**2)/(3._/**/REALKIND*sw)
    f( 48) = (CI*countertermnorm*ctVqq*cw*eQED**3*gQCD**2)/(3._/**/REALKIND*sw)
    f( 49) = (CI*countertermnorm*ctVqq*cw*eQED**3*gQCD**2)/sw
    f( 50) = (countertermnorm*eQED**5*MW)/(sw*6._/**/REALKIND)
    f( 51) = (countertermnorm*eQED**5*MW)/(sw*2._/**/REALKIND)
    f( 52) = (CI*countertermnorm*cw*eQED**5*MW)/sw
    f( 53) = (CI*countertermnorm*eQED**5*EWctHAA*MW)/(3._/**/REALKIND*sw)
    f( 54) = (CI*countertermnorm*eQED**5*EWctHZA*MW)/sw
    f( 55) = (CI*countertermnorm*eQED**5*MW*sw)/cw
    f( 56) = (CI*countertermnorm*eQED**5*EWctPWA*MW*sw)/cw
    f( 57) = (CI*eQED**3*MW**2*sw)/cw
    f( 58) = (CI*countertermnorm*eQED**5*MW**2*sw)/(3._/**/REALKIND*cw)
    f( 59) = (CI*countertermnorm*eQED**5*MW**2*sw)/cw
    f( 60) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW**2*sw)/cw
    f( 61) = (eQED**5*integralnorm*SwB)/81._/**/REALKIND
    f( 62) = (eQED**5*integralnorm*SwB)/27._/**/REALKIND
    f( 63) = (eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 64) = (eQED**5*integralnorm*SwB)/3._/**/REALKIND
    f( 65) = (2*eQED**5*integralnorm*SwB)/3._/**/REALKIND
    f( 66) = (eQED**3*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f( 67) = (eQED**3*gQCD**2*integralnorm*SwB)/3._/**/REALKIND
    f( 68) = (eQED**5*integralnorm*MW**2*SwB)/27._/**/REALKIND
    f( 69) = (eQED**5*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f( 70) = (eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 71) = (2*eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 72) = eQED**5*integralnorm*MW**2*SwB
    f( 73) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 74) = (eQED**3*gQCD**2*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 75) = (eQED**5*integralnorm*MW**4*SwB)/3._/**/REALKIND
    f( 76) = (eQED**5*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f( 77) = (eQED**5*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f( 79) = (eQED**5*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 80) = (eQED**5*integralnorm*SwB)/(sw**4*3._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 82) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f( 83) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*3._/**/REALKIND)
    f( 84) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 85) = (eQED**5*integralnorm*MH**2*SwB)/(sw**4*8._/**/REALKIND)
    f( 86) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*6._/**/REALKIND)
    f( 87) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*4._/**/REALKIND)
    f( 88) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*3._/**/REALKIND)
    f( 89) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f( 90) = (eQED**5*integralnorm*SwB)/(cw*sw**3*24._/**/REALKIND)
    f( 91) = (eQED**5*integralnorm*SwB)/(cw*sw**3*12._/**/REALKIND)
    f( 92) = (eQED**5*integralnorm*SwB)/(cw*sw**3*8._/**/REALKIND)
    f( 93) = (eQED**5*integralnorm*SwB)/(cw*sw**3*4._/**/REALKIND)
    f( 94) = (cw*eQED**5*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f( 95) = (cw*eQED**5*integralnorm*SwB)/(sw**3*4._/**/REALKIND)
    f( 96) = (cw*eQED**5*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f( 97) = (cw*eQED**5*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f( 98) = (cw*eQED**5*integralnorm*SwB)/sw**3
    f( 99) = (cw**3*eQED**5*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f(100) = (cw**3*eQED**5*integralnorm*SwB)/sw**3
    f(101) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(102) = (cw*eQED**5*integralnorm*MH**2*SwB)/(sw**3*4._/**/REALKIND)
    f(103) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(104) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*3._/**/REALKIND)
    f(105) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3)
    f(106) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(107) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*3._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3)
    f(110) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*6._/**/REALKIND)
    f(111) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*4._/**/REALKIND)
    f(112) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*3._/**/REALKIND)
    f(113) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f(114) = (cw*eQED**5*integralnorm*MW**2*SwB)/sw**3
    f(115) = (eQED**5*integralnorm*SwB)/(sw**2*54._/**/REALKIND)
    f(116) = (eQED**5*integralnorm*SwB)/(sw**2*36._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(118) = (eQED**5*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f(119) = (2*eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(120) = (eQED**5*integralnorm*SwB)/(sw**2*12._/**/REALKIND)
    f(121) = (eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(122) = (4*eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(123) = (eQED**5*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(124) = (2*eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(127) = (cw**2*eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(128) = (cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(129) = (cw**2*eQED**5*integralnorm*SwB)/sw**2
    f(130) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(131) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(132) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MH**2*SwB)/(sw**2*18._/**/REALKIND)
    f(134) = (eQED**5*integralnorm*MH**2*SwB)/(sw**2*12._/**/REALKIND)
    f(135) = (eQED**5*integralnorm*MH**2*SwB)/(sw**2*6._/**/REALKIND)
    f(136) = (eQED**5*integralnorm*MH**2*SwB)/(sw**2*3._/**/REALKIND)
    f(137) = (eQED**5*integralnorm*MH**4*SwB)/(sw**2*12._/**/REALKIND)
    f(138) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*18._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*12._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*9._/**/REALKIND)
    f(141) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*3._/**/REALKIND)
    f(143) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(145) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(146) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2)
    f(147) = (cw**2*eQED**5*integralnorm*MW**2*SwB)/(sw**2*3._/**/REALKIND)
    f(148) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f(149) = (eQED**5*integralnorm*MW**4*SwB)/(sw**2*3._/**/REALKIND)
    f(150) = (eQED**5*integralnorm*SwB)/(cw*sw*12._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*SwB)/(cw*sw*4._/**/REALKIND)
    f(152) = (cw*eQED**5*integralnorm*SwB)/(sw*27._/**/REALKIND)
    f(153) = (cw*eQED**5*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(154) = (cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(155) = (cw*eQED**5*integralnorm*SwB)/sw
    f(156) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(157) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/sw
    f(158) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(159) = (eQED**5*integralnorm*MH**4*SwB)/(cw*sw*4._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*6._/**/REALKIND)
    f(161) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*4._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(163) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(164) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(166) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw)
    f(167) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw*3._/**/REALKIND)
    f(168) = (cw*eQED**5*integralnorm*MW**2*SwB)/sw
    f(169) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(170) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MW**4*SwB)/(cw**5*sw)
    f(172) = (eQED**5*integralnorm*MW**4*SwB)/(cw**3*sw)
    f(173) = (eQED**5*integralnorm*MW**4*SwB)/(cw*sw)
    f(174) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(176) = (eQED**5*integralnorm*MW**2*sw*SwB)/cw
    f(177) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/cw
    f(178) = (eQED**3*gQCD**2*integralnorm*MW**2*sw*SwB)/cw
    f(179) = (eQED**5*integralnorm*MW**4*sw*SwB)/cw
    f(180) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*9._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(182) = (2*eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(183) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(184) = (eQED**5*integralnorm*MW**4*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MW**4*sw**3*SwB)/cw**3
    f(186) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**2*18._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**2*6._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**2*3._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(190) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(191) = (eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**2*6._/**/REALKIND)
    f(192) = (eQED**5*integralnorm*MW**4*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*12._/**/REALKIND)
    f(193) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*24._/**/REALKIND))
    f(194) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(195) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(196) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(197) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*2._/**/REALKIND))
    f(198) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(199) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(200) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(201) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*2._/**/REALKIND))
    f(202) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(203) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(204) = -((cw*eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**3*2._/**/REALKIND))
    f(205) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw*sw**3*12._/**/REALKIND*6._/**/REALKIND)
    f(206) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(207) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(208) = (eQED**5*integralnorm*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw*sw**3*2._/**/REALKIND)
    f(209) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(210) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(211) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(212) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(213) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(214) = -((eQED**5*integralnorm*MW**4*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(215) = (eQED**5*integralnorm*MW**2*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**2*12._/**/REALKIND*6._/**/REALKIND)
    f(216) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*6._/**/REALKIND))
    f(217) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*3._/**/REALKIND))
    f(218) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*2._/**/REALKIND))
    f(219) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*6._/**/REALKIND))
    f(220) = (eQED**5*integralnorm*MW**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**3*sw*2._/**/REALKIND*4._/**/REALKIND)
    f(221) = (eQED**5*integralnorm*MW**2*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**3*sw*2._/**/REALKIND)
    f(222) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(223) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/cw**3)
    f(224) = (eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(225) = (2*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(226) = (eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(227) = (4*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(228) = (2*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(229) = (8*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(230) = (eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(231) = (4*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(232) = (16*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(233) = (2*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(234) = (8*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(235) = (eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(236) = (4*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(237) = (2*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(238) = (8*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(239) = eQED**5*integralnorm*SwF
    f(240) = (4*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(241) = (eQED**5*integralnorm*MW**2*SwF)/27._/**/REALKIND
    f(242) = (2*eQED**5*integralnorm*MW**2*SwF)/27._/**/REALKIND
    f(243) = (4*eQED**5*integralnorm*MW**2*SwF)/27._/**/REALKIND
    f(244) = (8*eQED**5*integralnorm*MW**2*SwF)/27._/**/REALKIND
    f(245) = (eQED**5*integralnorm*MW**2*SwF)/3._/**/REALKIND
    f(246) = (2*eQED**5*integralnorm*MW**2*SwF)/3._/**/REALKIND
    f(247) = eQED**5*integralnorm*MW**2*SwF
    f(248) = (4*eQED**5*integralnorm*MW**2*SwF)/3._/**/REALKIND
    f(249) = (eQED**5*integralnorm*SwF)/(sw**4*12._/**/REALKIND)
    f(250) = (eQED**5*integralnorm*SwF)/(sw**4*6._/**/REALKIND)
    f(251) = (eQED**5*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(252) = (eQED**5*integralnorm*SwF)/(sw**4*3._/**/REALKIND)
    f(253) = (eQED**5*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(254) = (eQED**5*integralnorm*ME*SwF)/(sw**4*4._/**/REALKIND)
    f(255) = (eQED**5*integralnorm*ML*SwF)/(sw**4*4._/**/REALKIND)
    f(256) = (eQED**5*integralnorm*MM*SwF)/(sw**4*4._/**/REALKIND)
    f(257) = (cw*eQED**5*integralnorm*SwF)/(sw**3*6._/**/REALKIND)
    f(258) = (cw*eQED**5*integralnorm*SwF)/(sw**3*3._/**/REALKIND)
    f(259) = (cw*eQED**5*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(260) = (2*cw*eQED**5*integralnorm*SwF)/(sw**3*3._/**/REALKIND)
    f(261) = (cw*eQED**5*integralnorm*SwF)/sw**3
    f(262) = (cw*eQED**5*integralnorm*ME*SwF)/(sw**3*2._/**/REALKIND)
    f(263) = (cw*eQED**5*integralnorm*ML*SwF)/(sw**3*2._/**/REALKIND)
    f(264) = (cw*eQED**5*integralnorm*MM*SwF)/(sw**3*2._/**/REALKIND)
    f(265) = (eQED**5*integralnorm*SwF)/(sw**2*54._/**/REALKIND)
    f(266) = (eQED**5*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(267) = (eQED**5*integralnorm*SwF)/(sw**2*18._/**/REALKIND)
    f(268) = (2*eQED**5*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(269) = (eQED**5*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(270) = (4*eQED**5*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(271) = (eQED**5*integralnorm*SwF)/(sw**2*6._/**/REALKIND)
    f(272) = (2*eQED**5*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(273) = (eQED**5*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(274) = (eQED**5*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(275) = (2*eQED**5*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(276) = (eQED**5*integralnorm*SwF)/sw**2
    f(277) = (eQED**5*integralnorm*MB*SwF)/(sw**2*54._/**/REALKIND)
    f(278) = (eQED**5*integralnorm*MB*SwF)/(sw**2*36._/**/REALKIND)
    f(279) = (eQED**5*integralnorm*MB*SwF)/(sw**2*18._/**/REALKIND)
    f(280) = (eQED**5*integralnorm*MB*SwF)/(sw**2*6._/**/REALKIND)
    f(281) = (eQED**5*integralnorm*MB*SwF)/(sw**2*4._/**/REALKIND)
    f(282) = (eQED**5*integralnorm*MB*SwF)/(sw**2*2._/**/REALKIND)
    f(283) = (eQED**5*integralnorm*ME*SwF)/(sw**2*18._/**/REALKIND)
    f(284) = (eQED**5*integralnorm*ME*SwF)/(sw**2*12._/**/REALKIND)
    f(285) = (eQED**5*integralnorm*ME*SwF)/(sw**2*6._/**/REALKIND)
    f(286) = (eQED**5*integralnorm*ME*SwF)/(sw**2*4._/**/REALKIND)
    f(287) = (eQED**5*integralnorm*ME*SwF)/(sw**2*2._/**/REALKIND)
    f(288) = (eQED**5*integralnorm*ME**2*SwF)/(sw**2*6._/**/REALKIND)
    f(289) = (eQED**5*integralnorm*ML*SwF)/(sw**2*18._/**/REALKIND)
    f(290) = (eQED**5*integralnorm*ML*SwF)/(sw**2*12._/**/REALKIND)
    f(291) = (eQED**5*integralnorm*ML*SwF)/(sw**2*6._/**/REALKIND)
    f(292) = (eQED**5*integralnorm*ML*SwF)/(sw**2*4._/**/REALKIND)
    f(293) = (eQED**5*integralnorm*ML*SwF)/(sw**2*2._/**/REALKIND)
    f(294) = (eQED**5*integralnorm*ML**2*SwF)/(sw**2*6._/**/REALKIND)
    f(295) = (eQED**5*integralnorm*MM*SwF)/(sw**2*18._/**/REALKIND)
    f(296) = (eQED**5*integralnorm*MM*SwF)/(sw**2*12._/**/REALKIND)
    f(297) = (eQED**5*integralnorm*MM*SwF)/(sw**2*6._/**/REALKIND)
    f(298) = (eQED**5*integralnorm*MM*SwF)/(sw**2*4._/**/REALKIND)
    f(299) = (eQED**5*integralnorm*MM*SwF)/(sw**2*2._/**/REALKIND)
    f(300) = (eQED**5*integralnorm*MM**2*SwF)/(sw**2*6._/**/REALKIND)
    f(301) = (eQED**5*integralnorm*MT*SwF)/(sw**2*27._/**/REALKIND)
    f(302) = (eQED**5*integralnorm*MT*SwF)/(sw**2*18._/**/REALKIND)
    f(303) = (2*eQED**5*integralnorm*MT*SwF)/(sw**2*27._/**/REALKIND)
    f(304) = (eQED**5*integralnorm*MT*SwF)/(sw**2*9._/**/REALKIND)
    f(305) = (eQED**5*integralnorm*MT*SwF)/(sw**2*6._/**/REALKIND)
    f(306) = (eQED**5*integralnorm*MT*SwF)/(sw**2*4._/**/REALKIND)
    f(307) = (eQED**5*integralnorm*MT*SwF)/(sw**2*3._/**/REALKIND)
    f(308) = (eQED**5*integralnorm*MT*SwF)/(sw**2*2._/**/REALKIND)
    f(309) = (eQED**5*integralnorm*SwF)/(cw*sw*6._/**/REALKIND)
    f(310) = (eQED**5*integralnorm*SwF)/(cw*sw*3._/**/REALKIND)
    f(311) = (eQED**5*integralnorm*SwF)/(cw*sw*2._/**/REALKIND)
    f(312) = (cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(313) = (2*cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(314) = (cw*eQED**5*integralnorm*SwF)/(sw*9._/**/REALKIND)
    f(315) = (4*cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(316) = (2*cw*eQED**5*integralnorm*SwF)/(sw*9._/**/REALKIND)
    f(317) = (8*cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(318) = (cw*eQED**5*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(319) = (4*cw*eQED**5*integralnorm*SwF)/(sw*9._/**/REALKIND)
    f(320) = (2*cw*eQED**5*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(321) = (cw*eQED**5*integralnorm*SwF)/sw
    f(322) = (4*cw*eQED**5*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(323) = (2*cw*eQED**5*integralnorm*SwF)/sw
    f(324) = (3*cw*eQED**5*integralnorm*SwF)/sw
    f(325) = (eQED**5*integralnorm*ME*SwF)/(cw*sw*2._/**/REALKIND)
    f(326) = (eQED**5*integralnorm*ME**2*SwF)/(cw*sw*2._/**/REALKIND)
    f(327) = (eQED**5*integralnorm*ML*SwF)/(cw*sw*2._/**/REALKIND)
    f(328) = (eQED**5*integralnorm*ML**2*SwF)/(cw*sw*2._/**/REALKIND)
    f(329) = (eQED**5*integralnorm*MM*SwF)/(cw*sw*2._/**/REALKIND)
    f(330) = (eQED**5*integralnorm*MM**2*SwF)/(cw*sw*2._/**/REALKIND)
    f(331) = (eQED**5*integralnorm*MW**2*sw*SwF)/(cw*9._/**/REALKIND)
    f(332) = (2*eQED**5*integralnorm*MW**2*sw*SwF)/(cw*9._/**/REALKIND)
    f(333) = (eQED**5*integralnorm*MW**2*sw*SwF)/(cw*3._/**/REALKIND)
    f(334) = (4*eQED**5*integralnorm*MW**2*sw*SwF)/(cw*9._/**/REALKIND)
    f(335) = (eQED**5*integralnorm*MW**2*sw*SwF)/cw
    f(336) = (2*eQED**5*integralnorm*MW**2*sw*SwF)/cw
    f(337) = (3*eQED**5*integralnorm*MW**2*sw*SwF)/cw

  c = [ 3*f(61), 3*f(62), 3*f(63), 3*f(64), 3*f(65), 4*f(66), 4*f(67), 3*f(68), 3*f(69), 3*f(70), 3*f(71), 3*f(72), 3*f(73) &
    , 4*f(74), 3*f(75), 3*f(76), 3*f(77), 3*f(78), 3*f(79), 3*f(80), 3*f(81), 3*f(82), 3*f(83), 3*f(84), 3*f(85), 3*f(86), 3*f(87) &
    , 3*f(88), 3*f(89), 3*f(90), 3*f(91), 3*f(92), 3*f(93), 3*f(94), 3*f(95), 3*f(96), 3*f(97), 3*f(98), 3*f(99), 3*f(100) &
    , 3*f(101), 3*f(102), 3*f(103), 3*f(104), 3*f(105), 3*f(106), 3*f(107), 3*f(108), 3*f(109), 3*f(110), 3*f(111), 3*f(112) &
    , 3*f(113), 3*f(114), 3*f(115), 3*f(116), 3*f(117), 3*f(118), 3*f(119), 3*f(120), 3*f(121), 3*f(122), 3*f(123), 3*f(124) &
    , 3*f(125), 3*f(126), 3*f(127), 3*f(128), 3*f(129), 4*f(130), 4*f(131), 4*f(132), 3*f(133), 3*f(134), 3*f(135), 3*f(136) &
    , 3*f(137), 3*f(138), 3*f(139), 3*f(140), 3*f(141), 3*f(142), 3*f(143), 3*f(144), 3*f(145), 3*f(146), 3*f(147), 3*f(148) &
    , 3*f(149), 3*f(150), 3*f(151), 3*f(152), 3*f(153), 3*f(154), 3*f(155), 4*f(156), 4*f(157), 3*f(158), 3*f(159), 3*f(160) &
    , 3*f(161), 3*f(162), 3*f(163), 3*f(164), 3*f(165), 3*f(166), 3*f(167), 3*f(168), 3*f(169), 3*f(170), 3*f(171), 3*f(172) &
    , 3*f(173), 3*f(174), 3*f(175), 3*f(176), 3*f(177), 4*f(178), 3*f(179), 3*f(180), 3*f(181), 3*f(182), 3*f(183), 3*f(184) &
    , 3*f(185), 3*f(186), 3*f(187), 3*f(188), 3*f(189), 3*f(190), 3*f(191), 3*f(192), 3*f(193), 3*f(194), 3*f(195), 3*f(196) &
    , 3*f(197), 3*f(198), 3*f(199), 3*f(200), 3*f(201), 3*f(202), 3*f(203), 3*f(204), 3*f(205), 3*f(206), 3*f(207), 3*f(208) &
    , 3*f(209), 3*f(210), 3*f(211), 3*f(212), 3*f(213), 3*f(214), 3*f(215), 3*f(216), 3*f(217), 3*f(218), 3*f(219), 3*f(220) &
    , 3*f(221), 3*f(222), 3*f(223), 9*f(224), 9*f(225), 9*f(226), 9*f(227), 9*f(228), 9*f(229), 3*f(230), 9*f(230), 9*f(231) &
    , 9*f(232), 9*f(233), 9*f(234), 3*f(235), 9*f(235), 9*f(236), 9*f(237), 9*f(238), 3*f(239), 9*f(240), 9*f(241), 9*f(242) &
    , 9*f(243), 9*f(244), 3*f(245), 9*f(245), 9*f(246), 3*f(247), 9*f(248), 9*f(249), 9*f(250), 3*f(251), 9*f(251), 9*f(252) &
    , 9*f(253), 3*f(254), 3*f(255), 3*f(256), 9*f(257), 9*f(258), 3*f(259), 9*f(259), 9*f(260), 9*f(261), 3*f(262), 3*f(263) &
    , 3*f(264), 9*f(265), 9*f(266), 3*f(267), 9*f(267), 9*f(268), 9*f(269), 9*f(270), 3*f(271), 9*f(271), 9*f(272), 9*f(273) &
    , 3*f(274), 9*f(274), 9*f(275), 9*f(276), 9*f(277), 9*f(278), 9*f(279), 9*f(280), 9*f(281), 9*f(282), 3*f(283), 3*f(284) &
    , 3*f(285), 3*f(286), 3*f(287), 3*f(288), 3*f(289), 3*f(290), 3*f(291), 3*f(292), 3*f(293), 3*f(294), 3*f(295), 3*f(296) &
    , 3*f(297), 3*f(298), 3*f(299), 3*f(300), 9*f(301), 9*f(302), 9*f(303), 9*f(304), 9*f(305), 9*f(306), 9*f(307), 9*f(308) &
    , 9*f(309), 9*f(310), 9*f(311), 9*f(312), 9*f(313), 3*f(314), 9*f(314), 9*f(315), 9*f(316), 9*f(317), 3*f(318), 9*f(318) &
    , 9*f(319), 9*f(320), 3*f(321), 9*f(321), 9*f(322), 9*f(323), 3*f(324), 3*f(325), 3*f(326), 3*f(327), 3*f(328), 3*f(329) &
    , 3*f(330), 9*f(331), 9*f(332), 3*f(333), 9*f(334), 3*f(335), 9*f(335), 9*f(336), 3*f(337) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(3) = 1 /((L(5,12) - MW2)+L(6,12))
  den(6) = 1 /((L(5,20) - MW2)+L(6,20))
  den(9) = 1 /((L(5,5))+L(6,5))
  den(10) = 1 /((L(5,10))+L(6,10))
  den(12) = 1 /((L(5,24))+L(6,24))
  den(14) = 1 /((L(5,24) - MZ2)+L(6,24))
  den(16) = 1 /((L(5,17))+L(6,17))
  den(17) = 1 /((L(5,6))+L(6,6))
  den(24) = 1 /((L(5,28))+L(6,28))
  den(25) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(30) = 1 /((L(5,24) - MH2)+L(6,24))
  den(39) = 1 /((L(5,19) - MW2)+L(6,19))
  den(50) = 1 /((L(5,11) - MW2)+L(6,11))
  den(55) = 1 /((L(5,26))+L(6,26))
  den(58) = 1 /((L(5,21))+L(6,21))
  den(65) = 1 /((L(5,7))+L(6,7))
  den(69) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(73) = 1 /((L(5,14))+L(6,14))
  den(76) = 1 /((L(5,25))+L(6,25))
  den(101) = 1 /((L(5,28) - MH2)+L(6,28))

  ! denominators
  den(4) = den(1)*den(3)
  den(5) = den(2)*den(3)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(6)
  den(11) = den(9)*den(10)
  den(13) = den(9)*den(12)
  den(15) = den(9)*den(14)
  den(18) = den(16)*den(17)
  den(19) = den(12)*den(17)
  den(20) = den(14)*den(17)
  den(21) = den(10)*den(16)
  den(22) = den(6)*den(10)
  den(23) = den(3)*den(16)
  den(26) = den(1)*den(24)
  den(27) = den(1)*den(25)
  den(28) = den(2)*den(24)
  den(29) = den(2)*den(25)
  den(31) = den(1)*den(30)
  den(32) = den(2)*den(30)
  den(33) = den(3)*den(25)
  den(34) = den(1)*den(33)
  den(35) = den(2)*den(33)
  den(36) = den(3)*den(24)
  den(37) = den(1)*den(36)
  den(38) = den(2)*den(36)
  den(40) = den(1)*den(39)
  den(41) = den(3)*den(40)
  den(42) = den(2)*den(39)
  den(43) = den(3)*den(42)
  den(44) = den(6)*den(25)
  den(45) = den(1)*den(44)
  den(46) = den(2)*den(44)
  den(47) = den(6)*den(24)
  den(48) = den(1)*den(47)
  den(49) = den(2)*den(47)
  den(51) = den(1)*den(50)
  den(52) = den(6)*den(51)
  den(53) = den(2)*den(50)
  den(54) = den(6)*den(53)
  den(56) = den(10)*den(55)
  den(57) = den(9)*den(56)
  den(59) = den(9)*den(58)
  den(60) = den(10)*den(59)
  den(61) = den(12)*den(55)
  den(62) = den(9)*den(61)
  den(63) = den(14)*den(55)
  den(64) = den(9)*den(63)
  den(66) = den(9)*den(65)
  den(67) = den(12)*den(66)
  den(68) = den(14)*den(66)
  den(70) = den(9)*den(69)
  den(71) = den(12)*den(70)
  den(72) = den(14)*den(70)
  den(74) = den(17)*den(73)
  den(75) = den(16)*den(74)
  den(77) = den(16)*den(76)
  den(78) = den(17)*den(77)
  den(79) = den(12)*den(76)
  den(80) = den(17)*den(79)
  den(81) = den(14)*den(76)
  den(82) = den(17)*den(81)
  den(83) = den(17)*den(65)
  den(84) = den(12)*den(83)
  den(85) = den(14)*den(83)
  den(86) = den(17)*den(69)
  den(87) = den(12)*den(86)
  den(88) = den(14)*den(86)
  den(89) = den(10)*den(73)
  den(90) = den(16)*den(89)
  den(91) = den(16)*den(58)
  den(92) = den(10)*den(91)
  den(93) = den(6)*den(58)
  den(94) = den(10)*den(93)
  den(95) = den(10)*den(50)
  den(96) = den(6)*den(95)
  den(97) = den(3)*den(73)
  den(98) = den(16)*den(97)
  den(99) = den(16)*den(39)
  den(100) = den(3)*den(99)
  den(102) = den(3)*den(101)
  den(103) = den(6)*den(101)
  den(104) = den(1)*den(12)
  den(105) = den(1)*den(14)
  den(106) = den(2)*den(12)
  den(107) = den(2)*den(14)
  den(108) = den(9)*den(30)
  den(109) = den(17)*den(30)
  den(110) = den(1)*den(102)
  den(111) = den(2)*den(102)
  den(112) = den(1)*den(103)
  den(113) = den(2)*den(103)
  den(114) = den(30)*den(66)
  den(115) = den(30)*den(70)
  den(116) = den(30)*den(83)
  den(117) = den(30)*den(86)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppvvv_ew_ddxawwx_1_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for down anti-down gamma W- W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppvvv_ew_ddxawwx_1, only: &
    & external_perm_ppvvv_ew_ddxawwx_1, &
    & external_perm_inv_ppvvv_ew_ddxawwx_1, &
    & extcomb_perm_ppvvv_ew_ddxawwx_1, &
    & average_factor_ppvvv_ew_ddxawwx_1, &
    & photonid_ppvvv_ew_ddxawwx_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppvvv_ew_ddxawwx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppvvv_ew_ddxawwx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppvvv_ew_ddxawwx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppvvv_ew_ddxawwx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,72)
  type(Hpolcont) :: M1helarray_ct(2,72)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
!  type(Hpolcont) :: A(72,185)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(185)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,185))
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, nMW, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppvvv_ew_ddxawwx_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMW, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMW, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_WWV_V(ntry, ex4(:), ex5(:), ex3(:), wf18(:,1), n4(:,1), t4x18(:,:,1))
  call vert_QA_Z(gZd,ntry, ex1(:), ex2(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VV_S(ntry, ex3(:), ex4(:), wf6(:,1), n3(:,3), t3x6(:,:,1))
  call vert_VV_S(ntry, wf4(:,1), ex5(:), wf12(:,1), n3(:,4), t3x12(:,:,1))
  call vert_VV_S(ntry, wf4(:,2), ex5(:), wf12(:,2), n3(:,5), t3x12(:,:,2))
  call vert_UV_W(ntry, ex4(:), 8, ex3(:), 4, wf6(:,2), n3(:,6), t3x6(:,:,2))
  call vert_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,3), n3(:,7), t3x12(:,:,3))
  call vert_UV_W(ntry, wf4(:,2), 3, ex5(:), 16, wf12(:,4), n3(:,8), t3x12(:,:,4))
  call vert_VV_S(ntry, ex3(:), ex5(:), wf6(:,3), n3(:,9), t3x6(:,:,3))
  call vert_VV_S(ntry, wf4(:,1), ex4(:), wf12(:,5), n3(:,10), t3x12(:,:,5))
  call vert_VV_S(ntry, wf4(:,2), ex4(:), wf12(:,6), n3(:,11), t3x12(:,:,6))
  call vert_UV_W(ntry, ex3(:), 4, ex5(:), 16, wf6(:,4), n3(:,12), t3x6(:,:,4))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,1), 3, wf12(:,7), n3(:,13), t3x12(:,:,7))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,2), 3, wf12(:,8), n3(:,14), t3x12(:,:,8))
  call vert_VQ_A(ntry, ex3(:), ex1(:), wf4(:,3), n3(:,15), t3x4(:,:,3))
  call vert_AW_Q(ntry, ex2(:), ex4(:), wf6(:,5), n3(:,16), t3x6(:,:,5))
  call prop_Q_A(ntry, wf4(:,3), 5, ZERO, 0_intkind1, wf4(:,4), n2(1))
  call prop_A_Q(ntry, wf6(:,5), 10, ZERO, 0_intkind1, wf6(:,6), n2(2))
  call vert_WQ_A(ntry, ex5(:), wf4(:,4), wf12(:,9), n3(:,17), t3x12(:,:,9))
  call vert_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,1), n3(:,18), t3x9(:,:,1))
  call vert_QA_V(ntry, wf4(:,4), ex2(:), wf8(:,1), n3(:,19), t3x8(:,:,1))
  call vert_QA_Z(gZd,ntry, wf4(:,4), ex2(:), wf8(:,2), n3(:,20), t3x8(:,:,2))
  call vert_WQ_A(ntry, ex5(:), ex1(:), wf6(:,7), n3(:,21), t3x6(:,:,6))
  call vert_AV_Q(ntry, ex2(:), ex3(:), wf4(:,5), n3(:,22), t3x4(:,:,4))
  call prop_Q_A(ntry, wf6(:,7), 17, ZERO, 0_intkind1, wf6(:,8), n2(3))
  call prop_A_Q(ntry, wf4(:,5), 6, ZERO, 0_intkind1, wf4(:,6), n2(4))
  call vert_WQ_A(ntry, ex4(:), wf6(:,8), wf18(:,2), n3(:,23), t3x18(:,:,1))
  call vert_QA_V(ntry, ex1(:), wf4(:,6), wf8(:,3), n3(:,24), t3x8(:,:,3))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,6), wf8(:,4), n3(:,25), t3x8(:,:,4))
  call vert_VQ_A(ntry, ex3(:), wf6(:,8), wf12(:,10), n3(:,26), t3x12(:,:,10))
  call vert_QA_W(ntry, ex1(:), wf6(:,6), wf12(:,11), n3(:,27), t3x12(:,:,11))
  call vert_QA_W(ntry, wf6(:,8), ex2(:), wf12(:,12), n3(:,28), t3x12(:,:,12))
  call counter_WWV_V(EWctWWAA,ntry, ex4(:), ex5(:), ex3(:), wf18(:,3), n4(:,2), t4x18(:,:,2))
  call counter_WWV_V(EWctWWAZ,ntry, ex4(:), ex5(:), ex3(:), wf18(:,4), n4(:,3), t4x18(:,:,3))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,7), n3(:,29), t3x4(:,:,5))
  call counter_QA_V_LR(EWctAdd,ntry, ex1(:), ex2(:), wf4(:,8), n3(:,30), t3x4(:,:,6))
  call counter_QA_Z(gZd,ntry, ex1(:), ex2(:), wf4(:,9), n3(:,31), t3x4(:,:,7))
  call counter_QA_Z(EWctVdd,ntry, ex1(:), ex2(:), wf4(:,10), n3(:,32), t3x4(:,:,8))
  call counter_VV_S(ntry, wf4(:,1), ex5(:), wf12(:,13), n3(:,33), t3x12(:,:,13))
  call counter_VV_S(ntry, wf4(:,2), ex5(:), wf12(:,14), n3(:,34), t3x12(:,:,14))
  call counter_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,15), n3(:,35), t3x12(:,:,15))
  call counter_UV_W(ntry, wf4(:,2), 3, ex5(:), 16, wf12(:,16), n3(:,36), t3x12(:,:,16))
  call counter_VV_S(ntry, wf4(:,1), ex4(:), wf12(:,17), n3(:,37), t3x12(:,:,17))
  call counter_VV_S(ntry, wf4(:,2), ex4(:), wf12(:,18), n3(:,38), t3x12(:,:,18))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,1), 3, wf12(:,19), n3(:,39), t3x12(:,:,19))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,2), 3, wf12(:,20), n3(:,40), t3x12(:,:,20))
  call counter_V_V(EWctAA,ntry, wf4(:,1), 3, wf4(:,11), n2(5))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 3, wf4(:,12), n2(6))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 3, wf4(:,13), n2(7))
  call counter_V_V(EWctZZ,ntry, wf4(:,2), 3, wf4(:,14), n2(8))
  call vert_VV_S(ntry, ex4(:), ex5(:), wf9(:,2), n3(:,41), t3x9(:,:,2))
  call counter_VV_S(ntry, wf4(:,1), ex3(:), wf8(:,5), n3(:,42), t3x8(:,:,5))
  call counter_VV_S(ntry, wf4(:,2), ex3(:), wf8(:,6), n3(:,43), t3x8(:,:,6))
  call counter_VV_S(ntry, ex3(:), ex5(:), wf6(:,9), n3(:,44), t3x6(:,:,7))
  call counter_UV_W(ntry, ex3(:), 4, ex5(:), 16, wf6(:,10), n3(:,45), t3x6(:,:,8))
  call counter_VV_S(ntry, ex3(:), ex4(:), wf6(:,11), n3(:,46), t3x6(:,:,9))
  call counter_UV_W(ntry, ex4(:), 8, ex3(:), 4, wf6(:,12), n3(:,47), t3x6(:,:,10))
  call counter_WQ_A(ntry, ex5(:), wf4(:,4), wf12(:,21), n3(:,48), t3x12(:,:,21))
  call counter_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,3), n3(:,49), t3x9(:,:,3))
  call counter_WQ_A(ntry, ex4(:), wf6(:,8), wf18(:,5), n3(:,50), t3x18(:,:,2))
  call counter_VQ_A(ntry, ex3(:), wf6(:,8), wf12(:,22), n3(:,51), t3x12(:,:,22))
  call counter_VQ_A_LR(EWctAuu,ntry, ex3(:), wf6(:,8), wf12(:,23), n3(:,52), t3x12(:,:,23))
  call counter_QA_V(ntry, wf4(:,4), ex2(:), wf8(:,7), n3(:,53), t3x8(:,:,7))
  call counter_QA_V_LR(EWctAdd,ntry, wf4(:,4), ex2(:), wf8(:,8), n3(:,54), t3x8(:,:,8))
  call counter_QA_Z(gZd,ntry, wf4(:,4), ex2(:), wf8(:,9), n3(:,55), t3x8(:,:,9))
  call counter_QA_Z(EWctVdd,ntry, wf4(:,4), ex2(:), wf8(:,10), n3(:,56), t3x8(:,:,10))
  call counter_AW_Q(ntry, ex2(:), ex4(:), wf6(:,13), n3(:,57), t3x6(:,:,11))
  call prop_A_Q(ntry, wf6(:,13), 10, ZERO, 0_intkind1, wf6(:,14), n2(9))
  call counter_AQ_S(gPdu,ntry, ex2(:), wf6(:,8), wf12(:,24), n3(:,58), t3x12(:,:,24))
  call counter_QA_W(ntry, wf6(:,8), ex2(:), wf12(:,25), n3(:,59), t3x12(:,:,25))
  call vert_QA_W(ntry, ex1(:), wf6(:,14), wf12(:,26), n3(:,60), t3x12(:,:,26))
  call counter_AV_Q(ntry, ex2(:), ex3(:), wf4(:,15), n3(:,61), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,15), 6, ZERO, 0_intkind1, wf4(:,16), n2(10))
  call counter_AV_Q_LR(EWctAdd,ntry, ex2(:), ex3(:), wf4(:,17), n3(:,62), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,17), 6, ZERO, 0_intkind1, wf4(:,18), n2(11))
  call vert_QA_V(ntry, ex1(:), wf4(:,16), wf8(:,11), n3(:,63), t3x8(:,:,11))
  call vert_QA_V(ntry, ex1(:), wf4(:,18), wf8(:,12), n3(:,64), t3x8(:,:,12))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,16), wf8(:,13), n3(:,65), t3x8(:,:,13))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,18), wf8(:,14), n3(:,66), t3x8(:,:,14))
  call counter_QA_V(ntry, ex1(:), wf4(:,6), wf8(:,15), n3(:,67), t3x8(:,:,15))
  call counter_QA_V_LR(EWctAdd,ntry, ex1(:), wf4(:,6), wf8(:,16), n3(:,68), t3x8(:,:,16))
  call counter_QA_Z(gZd,ntry, ex1(:), wf4(:,6), wf8(:,17), n3(:,69), t3x8(:,:,17))
  call counter_QA_Z(EWctVdd,ntry, ex1(:), wf4(:,6), wf8(:,18), n3(:,70), t3x8(:,:,18))
  call counter_WQ_A(ntry, ex5(:), ex1(:), wf6(:,15), n3(:,71), t3x6(:,:,12))
  call prop_Q_A(ntry, wf6(:,15), 17, ZERO, 0_intkind1, wf6(:,16), n2(12))
  call vert_WQ_A(ntry, ex4(:), wf6(:,16), wf18(:,6), n3(:,72), t3x18(:,:,3))
  call counter_AQ_S(gPud,ntry, wf6(:,6), ex1(:), wf12(:,27), n3(:,73), t3x12(:,:,27))
  call counter_QA_W(ntry, ex1(:), wf6(:,6), wf12(:,28), n3(:,74), t3x12(:,:,28))
  call vert_VQ_A(ntry, ex3(:), wf6(:,16), wf12(:,29), n3(:,75), t3x12(:,:,29))
  call vert_QA_W(ntry, wf6(:,16), ex2(:), wf12(:,30), n3(:,76), t3x12(:,:,30))
  call counter_VQ_A(ntry, ex3(:), ex1(:), wf4(:,19), n3(:,77), t3x4(:,:,11))
  call prop_Q_A(ntry, wf4(:,19), 5, ZERO, 0_intkind1, wf4(:,20), n2(13))
  call vert_WQ_A(ntry, ex5(:), wf4(:,20), wf12(:,31), n3(:,78), t3x12(:,:,31))
  call counter_VQ_A_LR(EWctAdd,ntry, ex3(:), ex1(:), wf4(:,21), n3(:,79), t3x4(:,:,12))
  call prop_Q_A(ntry, wf4(:,21), 5, ZERO, 0_intkind1, wf4(:,22), n2(14))
  call vert_WQ_A(ntry, ex5(:), wf4(:,22), wf12(:,32), n3(:,80), t3x12(:,:,32))
  call vert_QA_V(ntry, wf4(:,20), ex2(:), wf8(:,19), n3(:,81), t3x8(:,:,19))
  call vert_QA_V(ntry, wf4(:,22), ex2(:), wf8(:,20), n3(:,82), t3x8(:,:,20))
  call vert_QA_Z(gZd,ntry, wf4(:,20), ex2(:), wf8(:,21), n3(:,83), t3x8(:,:,21))
  call vert_QA_Z(gZd,ntry, wf4(:,22), ex2(:), wf8(:,22), n3(:,84), t3x8(:,:,22))
  call vert_VV_S(ntry, wf4(:,7), ex5(:), wf12(:,33), n3(:,85), t3x12(:,:,33))
  call vert_VV_S(ntry, wf4(:,8), ex5(:), wf12(:,34), n3(:,86), t3x12(:,:,34))
  call vert_VV_S(ntry, wf4(:,9), ex5(:), wf12(:,35), n3(:,87), t3x12(:,:,35))
  call vert_VV_S(ntry, wf4(:,10), ex5(:), wf12(:,36), n3(:,88), t3x12(:,:,36))
  call vert_UV_W(ntry, wf4(:,7), 3, ex5(:), 16, wf12(:,37), n3(:,89), t3x12(:,:,37))
  call vert_UV_W(ntry, wf4(:,8), 3, ex5(:), 16, wf12(:,38), n3(:,90), t3x12(:,:,38))
  call vert_UV_W(ntry, wf4(:,9), 3, ex5(:), 16, wf12(:,39), n3(:,91), t3x12(:,:,39))
  call vert_UV_W(ntry, wf4(:,10), 3, ex5(:), 16, wf12(:,40), n3(:,92), t3x12(:,:,40))
  call vert_VV_S(ntry, wf4(:,7), ex4(:), wf12(:,41), n3(:,93), t3x12(:,:,41))
  call vert_VV_S(ntry, wf4(:,8), ex4(:), wf12(:,42), n3(:,94), t3x12(:,:,42))
  call vert_VV_S(ntry, wf4(:,9), ex4(:), wf12(:,43), n3(:,95), t3x12(:,:,43))
  call vert_VV_S(ntry, wf4(:,10), ex4(:), wf12(:,44), n3(:,96), t3x12(:,:,44))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,7), 3, wf12(:,45), n3(:,97), t3x12(:,:,45))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,8), 3, wf12(:,46), n3(:,98), t3x12(:,:,46))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,9), 3, wf12(:,47), n3(:,99), t3x12(:,:,47))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,10), 3, wf12(:,48), n3(:,100), t3x12(:,:,48))
  call vert_VS_T(ntry, ex5(:), 16, wf6(:,1), 12, wf18(:,7), n3(:,101), t3x18(:,:,4))
  call counter_V_S(EWctXA,ntry, wf4(:,1), 3, wf4(:,23), n2(15))
  call counter_V_S(EWctXZ,ntry, wf4(:,2), 3, wf4(:,24), n2(16))
  call vert_SV_V(ntry, wf6(:,1), ex5(:), wf18(:,8), n3(:,102), t3x18(:,:,5))
  call vert_UV_W(ntry, ex5(:), 16, wf6(:,2), 12, wf18(:,9), n3(:,103), t3x18(:,:,6))
  call counter_S_S(EWctPP,ntry, wf6(:,1), 12, wf6(:,17), n2(17))
  call counter_S_V(EWctPW,ntry, wf6(:,1), 12, wf6(:,18), n2(18))
  call counter_V_S(EWctPW,ntry, wf6(:,2), 12, wf6(:,19), n2(19))
  call counter_V_V(EWctWW,ntry, wf6(:,2), 12, wf6(:,20), n2(20))
  call vert_VS_T(ntry, ex4(:), 8, wf6(:,3), 20, wf18(:,10), n3(:,104), t3x18(:,:,7))
  call vert_SV_V(ntry, wf6(:,3), ex4(:), wf18(:,11), n3(:,105), t3x18(:,:,8))
  call vert_UV_W(ntry, wf6(:,4), 20, ex4(:), 8, wf18(:,12), n3(:,106), t3x18(:,:,9))
  call counter_S_S(EWctPP,ntry, wf6(:,3), 20, wf6(:,21), n2(21))
  call counter_S_V(EWctPW,ntry, wf6(:,3), 20, wf6(:,22), n2(22))
  call counter_V_S(EWctPW,ntry, wf6(:,4), 20, wf6(:,23), n2(23))
  call counter_V_V(EWctWW,ntry, wf6(:,4), 20, wf6(:,24), n2(24))
  call vert_AW_Q(ntry, wf6(:,6), ex5(:), wf18(:,13), n3(:,107), t3x18(:,:,10))
  call counter_Q_A(ctqq,1,ntry, wf4(:,4), 5, wf4(:,25), n2(25))
  call prop_A_Q(ntry, wf18(:,13), 26, ZERO, 0_intkind1, wf18(:,14), n2(26))
  call counter_Q_A_LR(EWctdd,ntry, wf4(:,4), 5, wf4(:,26), n2(27))
  call counter_A_Q(ctqq,2,ntry, wf6(:,6), 10, wf6(:,25), n2(28))
  call prop_Q_A(ntry, wf12(:,9), 21, ZERO, 0_intkind1, wf12(:,49), n2(29))
  call counter_A_Q_LR(EWctuu,ntry, wf6(:,6), 10, wf6(:,26), n2(30))
  call vert_AV_Q(ntry, ex2(:), wf9(:,1), wf18(:,15), n3(:,108), t3x18(:,:,11))
  call prop_A_Q(ntry, wf18(:,15), 26, ZERO, 0_intkind1, wf18(:,16), n2(31))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf9(:,1), wf18(:,17), n3(:,109), t3x18(:,:,12))
  call prop_A_Q(ntry, wf18(:,17), 26, ZERO, 0_intkind1, wf18(:,18), n2(32))
  call counter_V_V(EWctAA,ntry, wf9(:,1), 24, wf9(:,4), n2(33))
  call counter_V_V(EWctAZ,ntry, wf9(:,1), 24, wf9(:,5), n2(34))
  call counter_V_V(EWctZZ,ntry, wf9(:,1), 24, wf9(:,6), n2(35))
  call vert_AW_Q(ntry, wf4(:,6), ex4(:), wf12(:,50), n3(:,110), t3x12(:,:,49))
  call counter_Q_A(ctqq,2,ntry, wf6(:,8), 17, wf6(:,27), n2(36))
  call prop_A_Q(ntry, wf12(:,50), 14, ZERO, 0_intkind1, wf12(:,51), n2(37))
  call counter_Q_A_LR(EWctuu,ntry, wf6(:,8), 17, wf6(:,28), n2(38))
  call counter_A_Q(ctqq,1,ntry, wf4(:,6), 6, wf4(:,27), n2(39))
  call prop_Q_A(ntry, wf18(:,2), 25, ZERO, 0_intkind1, wf18(:,19), n2(40))
  call counter_A_Q_LR(EWctdd,ntry, wf4(:,6), 6, wf4(:,28), n2(41))
  call vert_VQ_A(ntry, wf9(:,1), ex1(:), wf18(:,20), n3(:,111), t3x18(:,:,13))
  call prop_Q_A(ntry, wf18(:,20), 25, ZERO, 0_intkind1, wf18(:,21), n2(42))
  call vert_ZQ_A(gZd,ntry, wf9(:,1), ex1(:), wf18(:,22), n3(:,112), t3x18(:,:,14))
  call prop_Q_A(ntry, wf18(:,22), 25, ZERO, 0_intkind1, wf18(:,23), n2(43))
  call vert_AV_Q(ntry, wf6(:,6), ex3(:), wf12(:,52), n3(:,113), t3x12(:,:,50))
  call prop_A_Q(ntry, wf12(:,52), 14, ZERO, 0_intkind1, wf12(:,53), n2(44))
  call prop_Q_A(ntry, wf12(:,10), 21, ZERO, 0_intkind1, wf12(:,54), n2(45))
  call vert_WQ_A(ntry, wf6(:,4), ex1(:), wf12(:,55), n3(:,114), t3x12(:,:,51))
  call prop_Q_A(ntry, wf12(:,55), 21, ZERO, 0_intkind1, wf12(:,56), n2(46))
  call vert_AW_Q(ntry, ex2(:), wf6(:,2), wf12(:,57), n3(:,115), t3x12(:,:,52))
  call prop_A_Q(ntry, wf12(:,57), 14, ZERO, 0_intkind1, wf12(:,58), n2(47))
  call vert_VV_S(ntry, wf6(:,2), ex5(:), wf18(:,24), n3(:,116), t3x18(:,:,15))
  call vert_VV_S(ntry, ex4(:), wf6(:,4), wf18(:,25), n3(:,117), t3x18(:,:,16))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf6)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf9)
  call init_hybrid_wf(wf12)
  call init_hybrid_wf(wf18)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppvvv_ew_ddxawwx_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

#if 1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
  ind_cc_comb = [8,12,9,13,14]
  M0M1_hel_cc(:,:,:)%j = 0
  M2ctcc = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 3
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,1), wf18(:,1), A(:,1), n3(:,118), t3x72(:,:,1), nhel, den(1))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,2), A(:,2), n3(:,119), t3x72(:,:,2), nhel, den(2))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,1), A(:,3), n3(:,120), t3x72(:,:,3), nhel, den(4))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,2), A(:,4), n3(:,121), t3x72(:,:,4), nhel, den(5))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,3), A(:,5), n3(:,122), t3x72(:,:,5), nhel, den(4))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,4), A(:,6), n3(:,123), t3x72(:,:,6), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,5), A(:,7), n3(:,124), t3x72(:,:,7), nhel, den(7))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,6), A(:,8), n3(:,125), t3x72(:,:,8), nhel, den(8))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,7), A(:,9), n3(:,126), t3x72(:,:,9), nhel, den(7))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,8), A(:,10), n3(:,127), t3x72(:,:,10), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,9), A(:,11), n3(:,128), t3x72(:,:,11), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,1), A(:,12), n3(:,129), t3x72(:,:,12), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,2), A(:,13), n3(:,130), t3x72(:,:,13), nhel, den(15))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,2), A(:,14), n3(:,131), t3x72(:,:,14), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,3), A(:,15), n3(:,132), t3x72(:,:,15), nhel, den(19))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,4), A(:,16), n3(:,133), t3x72(:,:,16), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,10), A(:,17), n3(:,134), t3x72(:,:,17), nhel, den(21))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,11), A(:,18), n3(:,135), t3x72(:,:,18), nhel, den(22))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,12), A(:,19), n3(:,136), t3x72(:,:,19), nhel, den(23))

    call Hcont_VV(nsync, wf4(:,1), wf18(:,3), A(:,20), n3(:,137), t3x72(:,:,20), nhel, den(1))
    call Hcont_VV(nsync, wf4(:,2), wf18(:,4), A(:,21), n3(:,138), t3x72(:,:,21), nhel, den(2))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,7), A(:,22), n3(:,139), t3x72(:,:,22), nhel, den(24))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,8), A(:,23), n3(:,140), t3x72(:,:,23), nhel, den(24))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,9), A(:,24), n3(:,141), t3x72(:,:,24), nhel, den(25))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,10), A(:,25), n3(:,142), t3x72(:,:,25), nhel, den(25))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,13), A(:,26), n3(:,143), t3x72(:,:,26), nhel, den(4))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,14), A(:,27), n3(:,144), t3x72(:,:,27), nhel, den(5))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,15), A(:,28), n3(:,145), t3x72(:,:,28), nhel, den(4))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,16), A(:,29), n3(:,146), t3x72(:,:,29), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,17), A(:,30), n3(:,147), t3x72(:,:,30), nhel, den(7))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,18), A(:,31), n3(:,148), t3x72(:,:,31), nhel, den(8))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,19), A(:,32), n3(:,149), t3x72(:,:,32), nhel, den(7))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,20), A(:,33), n3(:,150), t3x72(:,:,33), nhel, den(8))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,11), A(:,34), n3(:,151), t3x72(:,:,34), nhel, den(26))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,12), A(:,35), n3(:,152), t3x72(:,:,35), nhel, den(27))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,13), A(:,36), n3(:,153), t3x72(:,:,36), nhel, den(28))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,14), A(:,37), n3(:,154), t3x72(:,:,37), nhel, den(29))
    call Hcont_SS(nsync, wf9(:,2), wf8(:,5), A(:,38), n3(:,155), t3x72(:,:,38), nhel, den(31))
    call Hcont_SS(nsync, wf9(:,2), wf8(:,6), A(:,39), n3(:,156), t3x72(:,:,39), nhel, den(32))
    call Hcont_SS(nsync, wf12(:,5), wf6(:,9), A(:,40), n3(:,157), t3x72(:,:,40), nhel, den(7))
    call Hcont_SS(nsync, wf12(:,6), wf6(:,9), A(:,41), n3(:,158), t3x72(:,:,41), nhel, den(8))
    call Hcont_VV(nsync, wf12(:,7), wf6(:,10), A(:,42), n3(:,159), t3x72(:,:,42), nhel, den(7))
    call Hcont_VV(nsync, wf12(:,8), wf6(:,10), A(:,43), n3(:,160), t3x72(:,:,43), nhel, den(8))
    call Hcont_SS(nsync, wf12(:,1), wf6(:,11), A(:,44), n3(:,161), t3x72(:,:,44), nhel, den(4))
    call Hcont_SS(nsync, wf12(:,2), wf6(:,11), A(:,45), n3(:,162), t3x72(:,:,45), nhel, den(5))
    call Hcont_VV(nsync, wf12(:,3), wf6(:,12), A(:,46), n3(:,163), t3x72(:,:,46), nhel, den(4))
    call Hcont_VV(nsync, wf12(:,4), wf6(:,12), A(:,47), n3(:,164), t3x72(:,:,47), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,21), A(:,48), n3(:,165), t3x72(:,:,48), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,21), A(:,49), n3(:,166), t3x72(:,:,49), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,3), A(:,50), n3(:,167), t3x72(:,:,50), nhel, den(13))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,3), A(:,51), n3(:,168), t3x72(:,:,51), nhel, den(15))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,5), A(:,52), n3(:,169), t3x72(:,:,52), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,5), A(:,53), n3(:,170), t3x72(:,:,53), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,3), A(:,54), n3(:,171), t3x72(:,:,54), nhel, den(19))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,3), A(:,55), n3(:,172), t3x72(:,:,55), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,22), A(:,56), n3(:,173), t3x72(:,:,56), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,23), A(:,57), n3(:,174), t3x72(:,:,57), nhel, den(21))
    call Hcont_VV(nsync, wf12(:,11), wf6(:,10), A(:,58), n3(:,175), t3x72(:,:,58), nhel, den(22))
    call Hcont_VV(nsync, wf12(:,12), wf6(:,12), A(:,59), n3(:,176), t3x72(:,:,59), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,7), A(:,60), n3(:,177), t3x72(:,:,60), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,8), A(:,61), n3(:,178), t3x72(:,:,61), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,9), A(:,62), n3(:,179), t3x72(:,:,62), nhel, den(15))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,10), A(:,63), n3(:,180), t3x72(:,:,63), nhel, den(15))
    call Hcont_QA(nsync, wf12(:,9), wf6(:,14), A(:,64), n3(:,181), t3x72(:,:,64), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,9), wf6(:,14), A(:,65), n3(:,182), t3x72(:,:,65), nhel, den(11))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,24), A(:,66), n3(:,183), t3x72(:,:,66), nhel, den(23))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,25), A(:,67), n3(:,184), t3x72(:,:,67), nhel, den(23))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,25), A(:,68), n3(:,185), t3x72(:,:,68), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,14), A(:,69), n3(:,186), t3x72(:,:,69), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,14), A(:,70), n3(:,187), t3x72(:,:,70), nhel, den(21))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,26), A(:,71), n3(:,188), t3x72(:,:,71), nhel, den(22))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,26), A(:,72), n3(:,189), t3x72(:,:,72), nhel, den(22))
    call Hcont_QA(nsync, wf18(:,2), wf4(:,16), A(:,73), n3(:,190), t3x72(:,:,73), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,2), wf4(:,18), A(:,74), n3(:,191), t3x72(:,:,74), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,11), A(:,75), n3(:,192), t3x72(:,:,75), nhel, den(19))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,12), A(:,76), n3(:,193), t3x72(:,:,76), nhel, den(19))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,13), A(:,77), n3(:,194), t3x72(:,:,77), nhel, den(20))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,14), A(:,78), n3(:,195), t3x72(:,:,78), nhel, den(20))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,15), A(:,79), n3(:,196), t3x72(:,:,79), nhel, den(19))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,16), A(:,80), n3(:,197), t3x72(:,:,80), nhel, den(19))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,17), A(:,81), n3(:,198), t3x72(:,:,81), nhel, den(20))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,18), A(:,82), n3(:,199), t3x72(:,:,82), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,6), A(:,83), n3(:,200), t3x72(:,:,83), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,6), A(:,84), n3(:,201), t3x72(:,:,84), nhel, den(18))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,27), A(:,85), n3(:,202), t3x72(:,:,85), nhel, den(22))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,28), A(:,86), n3(:,203), t3x72(:,:,86), nhel, den(22))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,28), A(:,87), n3(:,204), t3x72(:,:,87), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,29), A(:,88), n3(:,205), t3x72(:,:,88), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,29), A(:,89), n3(:,206), t3x72(:,:,89), nhel, den(21))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,30), A(:,90), n3(:,207), t3x72(:,:,90), nhel, den(23))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,30), A(:,91), n3(:,208), t3x72(:,:,91), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,31), A(:,92), n3(:,209), t3x72(:,:,92), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,32), A(:,93), n3(:,210), t3x72(:,:,93), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,19), A(:,94), n3(:,211), t3x72(:,:,94), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,20), A(:,95), n3(:,212), t3x72(:,:,95), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,21), A(:,96), n3(:,213), t3x72(:,:,96), nhel, den(15))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,22), A(:,97), n3(:,214), t3x72(:,:,97), nhel, den(15))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,33), A(:,98), n3(:,215), t3x72(:,:,98), nhel, den(4))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,34), A(:,99), n3(:,216), t3x72(:,:,99), nhel, den(4))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,35), A(:,100), n3(:,217), t3x72(:,:,100), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,36), A(:,101), n3(:,218), t3x72(:,:,101), nhel, den(5))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,37), A(:,102), n3(:,219), t3x72(:,:,102), nhel, den(4))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,38), A(:,103), n3(:,220), t3x72(:,:,103), nhel, den(4))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,39), A(:,104), n3(:,221), t3x72(:,:,104), nhel, den(5))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,40), A(:,105), n3(:,222), t3x72(:,:,105), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,41), A(:,106), n3(:,223), t3x72(:,:,106), nhel, den(7))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,42), A(:,107), n3(:,224), t3x72(:,:,107), nhel, den(7))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,43), A(:,108), n3(:,225), t3x72(:,:,108), nhel, den(8))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,44), A(:,109), n3(:,226), t3x72(:,:,109), nhel, den(8))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,45), A(:,110), n3(:,227), t3x72(:,:,110), nhel, den(7))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,46), A(:,111), n3(:,228), t3x72(:,:,111), nhel, den(7))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,47), A(:,112), n3(:,229), t3x72(:,:,112), nhel, den(8))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,48), A(:,113), n3(:,230), t3x72(:,:,113), nhel, den(8))
    call Hcont_SS(nsync, wf18(:,7), wf4(:,23), A(:,114), n3(:,231), t3x72(:,:,114), nhel, den(34))
    call Hcont_SS(nsync, wf18(:,7), wf4(:,24), A(:,115), n3(:,232), t3x72(:,:,115), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,11), wf18(:,8), A(:,116), n3(:,233), t3x72(:,:,116), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,12), wf18(:,8), A(:,117), n3(:,234), t3x72(:,:,117), nhel, den(34))
    call Hcont_VV(nsync, wf4(:,13), wf18(:,8), A(:,118), n3(:,235), t3x72(:,:,118), nhel, den(38))
    call Hcont_VV(nsync, wf4(:,14), wf18(:,8), A(:,119), n3(:,236), t3x72(:,:,119), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,11), wf18(:,9), A(:,120), n3(:,237), t3x72(:,:,120), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,12), wf18(:,9), A(:,121), n3(:,238), t3x72(:,:,121), nhel, den(34))
    call Hcont_VV(nsync, wf4(:,13), wf18(:,9), A(:,122), n3(:,239), t3x72(:,:,122), nhel, den(38))
    call Hcont_VV(nsync, wf4(:,14), wf18(:,9), A(:,123), n3(:,240), t3x72(:,:,123), nhel, den(35))
    call Hcont_SS(nsync, wf12(:,1), wf6(:,17), A(:,124), n3(:,241), t3x72(:,:,124), nhel, den(41))
    call Hcont_SS(nsync, wf12(:,2), wf6(:,17), A(:,125), n3(:,242), t3x72(:,:,125), nhel, den(43))
    call Hcont_VV(nsync, wf12(:,3), wf6(:,18), A(:,126), n3(:,243), t3x72(:,:,126), nhel, den(41))
    call Hcont_VV(nsync, wf12(:,4), wf6(:,18), A(:,127), n3(:,244), t3x72(:,:,127), nhel, den(43))
    call Hcont_SS(nsync, wf12(:,1), wf6(:,19), A(:,128), n3(:,245), t3x72(:,:,128), nhel, den(41))
    call Hcont_SS(nsync, wf12(:,2), wf6(:,19), A(:,129), n3(:,246), t3x72(:,:,129), nhel, den(43))
    call Hcont_VV(nsync, wf12(:,3), wf6(:,20), A(:,130), n3(:,247), t3x72(:,:,130), nhel, den(41))
    call Hcont_VV(nsync, wf12(:,4), wf6(:,20), A(:,131), n3(:,248), t3x72(:,:,131), nhel, den(43))
    call Hcont_SS(nsync, wf4(:,23), wf18(:,10), A(:,132), n3(:,249), t3x72(:,:,132), nhel, den(45))
    call Hcont_SS(nsync, wf4(:,24), wf18(:,10), A(:,133), n3(:,250), t3x72(:,:,133), nhel, den(46))
    call Hcont_VV(nsync, wf4(:,11), wf18(:,11), A(:,134), n3(:,251), t3x72(:,:,134), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,12), wf18(:,11), A(:,135), n3(:,252), t3x72(:,:,135), nhel, den(45))
    call Hcont_VV(nsync, wf4(:,13), wf18(:,11), A(:,136), n3(:,253), t3x72(:,:,136), nhel, den(49))
    call Hcont_VV(nsync, wf4(:,14), wf18(:,11), A(:,137), n3(:,254), t3x72(:,:,137), nhel, den(46))
    call Hcont_VV(nsync, wf4(:,11), wf18(:,12), A(:,138), n3(:,255), t3x72(:,:,138), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,12), wf18(:,12), A(:,139), n3(:,256), t3x72(:,:,139), nhel, den(45))
    call Hcont_VV(nsync, wf4(:,13), wf18(:,12), A(:,140), n3(:,257), t3x72(:,:,140), nhel, den(49))
    call Hcont_VV(nsync, wf4(:,14), wf18(:,12), A(:,141), n3(:,258), t3x72(:,:,141), nhel, den(46))
    call Hcont_SS(nsync, wf12(:,5), wf6(:,21), A(:,142), n3(:,259), t3x72(:,:,142), nhel, den(52))
    call Hcont_SS(nsync, wf12(:,6), wf6(:,21), A(:,143), n3(:,260), t3x72(:,:,143), nhel, den(54))
    call Hcont_VV(nsync, wf12(:,7), wf6(:,22), A(:,144), n3(:,261), t3x72(:,:,144), nhel, den(52))
    call Hcont_VV(nsync, wf12(:,8), wf6(:,22), A(:,145), n3(:,262), t3x72(:,:,145), nhel, den(54))
    call Hcont_SS(nsync, wf12(:,5), wf6(:,23), A(:,146), n3(:,263), t3x72(:,:,146), nhel, den(52))
    call Hcont_SS(nsync, wf12(:,6), wf6(:,23), A(:,147), n3(:,264), t3x72(:,:,147), nhel, den(54))
    call Hcont_VV(nsync, wf12(:,7), wf6(:,24), A(:,148), n3(:,265), t3x72(:,:,148), nhel, den(52))
    call Hcont_VV(nsync, wf12(:,8), wf6(:,24), A(:,149), n3(:,266), t3x72(:,:,149), nhel, den(54))
    call Hcont_QA(nsync, wf4(:,25), wf18(:,14), A(:,150), n3(:,267), t3x72(:,:,150), nhel, den(57))
    call Hcont_QA(nsync, wf18(:,14), wf4(:,26), A(:,151), n3(:,268), t3x72(:,:,151), nhel, den(57))
    call Hcont_QA(nsync, wf6(:,25), wf12(:,49), A(:,152), n3(:,269), t3x72(:,:,152), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,49), wf6(:,26), A(:,153), n3(:,270), t3x72(:,:,153), nhel, den(60))
    call Hcont_QA(nsync, wf4(:,25), wf18(:,16), A(:,154), n3(:,271), t3x72(:,:,154), nhel, den(62))
    call Hcont_QA(nsync, wf4(:,26), wf18(:,16), A(:,155), n3(:,272), t3x72(:,:,155), nhel, den(62))
    call Hcont_QA(nsync, wf4(:,25), wf18(:,18), A(:,156), n3(:,273), t3x72(:,:,156), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,26), wf18(:,18), A(:,157), n3(:,274), t3x72(:,:,157), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,4), A(:,158), n3(:,275), t3x72(:,:,158), nhel, den(67))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,5), A(:,159), n3(:,276), t3x72(:,:,159), nhel, den(68))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,5), A(:,160), n3(:,277), t3x72(:,:,160), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,6), A(:,161), n3(:,278), t3x72(:,:,161), nhel, den(72))
    call Hcont_QA(nsync, wf6(:,27), wf12(:,51), A(:,162), n3(:,279), t3x72(:,:,162), nhel, den(75))
    call Hcont_QA(nsync, wf12(:,51), wf6(:,28), A(:,163), n3(:,280), t3x72(:,:,163), nhel, den(75))
    call Hcont_QA(nsync, wf4(:,27), wf18(:,19), A(:,164), n3(:,281), t3x72(:,:,164), nhel, den(78))
    call Hcont_QA(nsync, wf18(:,19), wf4(:,28), A(:,165), n3(:,282), t3x72(:,:,165), nhel, den(78))
    call Hcont_QA(nsync, wf4(:,27), wf18(:,21), A(:,166), n3(:,283), t3x72(:,:,166), nhel, den(80))
    call Hcont_QA(nsync, wf4(:,28), wf18(:,21), A(:,167), n3(:,284), t3x72(:,:,167), nhel, den(80))
    call Hcont_QA(nsync, wf4(:,27), wf18(:,23), A(:,168), n3(:,285), t3x72(:,:,168), nhel, den(82))
    call Hcont_QA(nsync, wf4(:,28), wf18(:,23), A(:,169), n3(:,286), t3x72(:,:,169), nhel, den(82))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,4), A(:,170), n3(:,287), t3x72(:,:,170), nhel, den(84))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,5), A(:,171), n3(:,288), t3x72(:,:,171), nhel, den(85))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,5), A(:,172), n3(:,289), t3x72(:,:,172), nhel, den(87))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,6), A(:,173), n3(:,290), t3x72(:,:,173), nhel, den(88))
    call Hcont_QA(nsync, wf6(:,27), wf12(:,53), A(:,174), n3(:,291), t3x72(:,:,174), nhel, den(90))
    call Hcont_QA(nsync, wf6(:,28), wf12(:,53), A(:,175), n3(:,292), t3x72(:,:,175), nhel, den(90))
    call Hcont_QA(nsync, wf6(:,25), wf12(:,54), A(:,176), n3(:,293), t3x72(:,:,176), nhel, den(92))
    call Hcont_QA(nsync, wf6(:,26), wf12(:,54), A(:,177), n3(:,294), t3x72(:,:,177), nhel, den(92))
    call Hcont_QA(nsync, wf6(:,25), wf12(:,56), A(:,178), n3(:,295), t3x72(:,:,178), nhel, den(94))
    call Hcont_QA(nsync, wf6(:,26), wf12(:,56), A(:,179), n3(:,296), t3x72(:,:,179), nhel, den(94))
    call Hcont_VV(nsync, wf12(:,11), wf6(:,22), A(:,180), n3(:,297), t3x72(:,:,180), nhel, den(96))
    call Hcont_VV(nsync, wf12(:,11), wf6(:,24), A(:,181), n3(:,298), t3x72(:,:,181), nhel, den(96))
    call Hcont_QA(nsync, wf6(:,27), wf12(:,58), A(:,182), n3(:,299), t3x72(:,:,182), nhel, den(98))
    call Hcont_QA(nsync, wf6(:,28), wf12(:,58), A(:,183), n3(:,300), t3x72(:,:,183), nhel, den(98))
    call Hcont_VV(nsync, wf12(:,12), wf6(:,18), A(:,184), n3(:,301), t3x72(:,:,184), nhel, den(100))
    call Hcont_VV(nsync, wf12(:,12), wf6(:,20), A(:,185), n3(:,302), t3x72(:,:,185), nhel, den(100))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(2) ! M1helarray(2,72)
  integer :: empty(0), i

  M1(1)%j = (A(j,12)%j+A(j,15)%j)*f(1)+(A(j,1)%j-A(j,5)%j-A(j,9)%j)*f(2)+(A(j,3)%j+A(j,7)%j)*f(16)+(-A(j,11)%j-A(j,14)%j)*f(20) &
       +A(j,17)%j*f(21)+(A(j,18)%j+A(j,19)%j)*f(22)+(-A(j,13)%j-A(j,16)%j)*f(41)+(-A(j,2)%j+A(j,6)%j+A(j,10)%j)*f(42)+(A(j,4)%j &
       +A(j,8)%j)*f(57)

  M2(1)%j = (-A(j,154)%j-A(j,166)%j)*f(10)+(A(j,60)%j+A(j,75)%j+A(j,79)%j+A(j,94)%j)*f(11)+(A(j,22)%j-A(j,102)%j-A(j,110)%j)*f(12) &
       +(A(j,98)%j+A(j,106)%j)*f(19)+(A(j,150)%j+A(j,152)%j+A(j,162)%j+A(j,164)%j)*f(33)+(-A(j,174)%j-A(j,176)%j)*f(34)+( &
       -A(j,178)%j-A(j,182)%j)*f(35)+(-A(j,66)%j+A(j,85)%j)*f(36)+(-A(j,48)%j-A(j,52)%j-A(j,64)%j-A(j,73)%j-A(j,83)%j &
       -A(j,92)%j)*f(37)+(A(j,56)%j+A(j,69)%j+A(j,88)%j)*f(38)+(A(j,67)%j+A(j,71)%j+A(j,86)%j+A(j,90)%j)*f(39)+(A(j,156)%j &
       +A(j,168)%j)*f(47)+(-A(j,62)%j-A(j,77)%j-A(j,81)%j-A(j,96)%j)*f(48)+(-A(j,24)%j+A(j,104)%j+A(j,112)%j)*f(49)+(A(j,100)%j &
       +A(j,108)%j)*f(60)
  M2(2)%j = (-A(j,155)%j-A(j,158)%j-A(j,167)%j-A(j,170)%j)*f(3)+(-A(j,20)%j-A(j,34)%j+A(j,61)%j+A(j,76)%j+A(j,80)%j+A(j,95)%j &
       +A(j,120)%j+A(j,130)%j+A(j,138)%j+A(j,148)%j-A(j,160)%j-A(j,172)%j)*f(4)+(-A(j,21)%j+A(j,23)%j-A(j,36)%j-A(j,103)%j &
       -A(j,111)%j+A(j,122)%j+A(j,140)%j)*f(5)+(A(j,50)%j+A(j,54)%j)*f(6)+(-A(j,28)%j-A(j,32)%j-A(j,42)%j-A(j,46)%j)*f(7) &
       +(A(j,51)%j+A(j,55)%j)*f(8)+(-A(j,29)%j-A(j,33)%j)*f(9)+(-A(j,126)%j-A(j,128)%j-A(j,144)%j-A(j,146)%j)*f(13)+(-A(j,26)%j &
       -A(j,30)%j-A(j,40)%j-A(j,44)%j)*f(14)+(-A(j,27)%j-A(j,31)%j)*f(15)+(-A(j,116)%j-A(j,124)%j-A(j,134)%j-A(j,142)%j)*f(17) &
       +(A(j,99)%j+A(j,107)%j-A(j,118)%j-A(j,136)%j)*f(18)+(A(j,151)%j+A(j,153)%j+A(j,163)%j+A(j,165)%j)*f(23)+(-A(j,175)%j &
       -A(j,177)%j)*f(24)+(-A(j,57)%j-A(j,74)%j-A(j,93)%j-A(j,179)%j-A(j,181)%j-A(j,183)%j-A(j,185)%j)*f(25)+(A(j,58)%j &
       +A(j,59)%j)*f(26)+(-A(j,53)%j-A(j,65)%j)*f(27)+A(j,70)%j*f(28)+(A(j,68)%j+A(j,72)%j)*f(29)+(-A(j,49)%j-A(j,84)%j)*f(30) &
       +A(j,89)%j*f(31)+(A(j,87)%j+A(j,91)%j)*f(32)+(A(j,180)%j+A(j,184)%j)*f(40)+(A(j,159)%j+A(j,171)%j)*f(43)+(A(j,35)%j &
       -A(j,63)%j-A(j,82)%j-A(j,121)%j-A(j,139)%j+A(j,157)%j+A(j,161)%j+A(j,169)%j+A(j,173)%j)*f(44)+(-A(j,25)%j+A(j,37)%j &
       -A(j,78)%j-A(j,97)%j+A(j,105)%j+A(j,113)%j-A(j,123)%j-A(j,131)%j-A(j,141)%j-A(j,149)%j)*f(45)+(A(j,43)%j+A(j,47)%j)*f(46) &
       +(A(j,114)%j+A(j,132)%j)*f(50)+(A(j,115)%j+A(j,133)%j)*f(51)+(A(j,127)%j+A(j,145)%j)*f(52)+A(j,38)%j*f(53)+A(j,39)%j*f(54) &
       +(-A(j,129)%j-A(j,147)%j)*f(55)+(-A(j,41)%j-A(j,45)%j)*f(56)+(-A(j,117)%j-A(j,135)%j)*f(58)+(A(j,101)%j+A(j,109)%j &
       -A(j,119)%j-A(j,125)%j-A(j,137)%j-A(j,143)%j)*f(59)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_ddxawwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_ddxawwx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_ddxawwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_ddxawwx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_ddxawwx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppvvv_ew_ddxawwx_1_/**/REALKIND
