
module ol_colourmatrix_ppvvv_ew_bbxawwx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,2), KL(17,2), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2( 1,:) = [ 0, 3]
  K2( 2,:) = [ 0, 0]
  K2( 3,:) = [ 0, 0]
  K2( 4,:) = [ 0, 0]
  K2( 5,:) = [ 0, 0]
  K2( 6,:) = [ 0, 0]
  K2( 7,:) = [ 0, 0]
  K2( 8,:) = [ 0, 0]
  K2( 9,:) = [ 0, 0]
  K2(10,:) = [ 0, 0]
  K2(11,:) = [ 0, 0]
  K2(12,:) = [ 0, 0]
  K2(13,:) = [ 0, 0]
  K2(14,:) = [ 0, 0]
  K2(15,:) = [ 0, 0]
  K2(16,:) = [ 0, 0]
  K2(17,:) = [ 0, 3]

  KL( 1,:) = [ 3, 0]
  KL( 2,:) = [ 0, 0]
  KL( 3,:) = [ 0, 0]
  KL( 4,:) = [ 0, 0]
  KL( 5,:) = [ 0, 0]
  KL( 6,:) = [ 0, 0]
  KL( 7,:) = [ 0, 0]
  KL( 8,:) = [ 0, 0]
  KL( 9,:) = [ 0, 0]
  KL(10,:) = [ 0, 0]
  KL(11,:) = [ 0, 0]
  KL(12,:) = [ 0, 0]
  KL(13,:) = [ 0, 0]
  KL(14,:) = [ 0, 0]
  KL(15,:) = [ 0, 0]
  KL(16,:) = [ 0, 0]
  KL(17,:) = [ 3, 0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvv_ew_bbxawwx_1_/**/REALKIND



module ol_forced_parameters_ppvvv_ew_bbxawwx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvv_ew_bbxawwx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppvvv_ew_bbxawwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 72 ! number of helicity configurations
  integer(intkind2), save :: nhel = 72 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(72) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:)
  complex(REALKIND), save :: den(148)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(3), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,38), wf6(6,28), wf8(8,36), wf9(9,10), wf12(12,92), wf18(18,29), wf72(72,286)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(643), c(560)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,72), M0M1_hel_cc(2,72,16)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppvvv_ew_bbxawwx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppvvv_ew_bbxawwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppvvv_ew_bbxawwx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*eQED**3)/9._/**/REALKIND
    f(  2) = (CI*eQED**3)/3._/**/REALKIND
    f(  3) = (CI*countertermnorm*eQED**5)/9._/**/REALKIND
    f(  4) = (CI*countertermnorm*eQED**5)/3._/**/REALKIND
    f(  5) = CI*countertermnorm*eQED**5
    f(  6) = (CI*countertermnorm*eQED**5*EWctAWW)/9._/**/REALKIND
    f(  7) = (CI*countertermnorm*eQED**5*EWctAWW)/3._/**/REALKIND
    f(  8) = (CI*countertermnorm*eQED**5*EWctZWW)/3._/**/REALKIND
    f(  9) = CI*countertermnorm*eQED**5*EWctZWW
    f( 10) = (CI*countertermnorm*eQED**3*gQCD**2)/9._/**/REALKIND
    f( 11) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/9._/**/REALKIND
    f( 12) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 13) = (CI*countertermnorm*eQED**5*MW)/3._/**/REALKIND
    f( 14) = (CI*countertermnorm*eQED**5*EWctPWA*MW)/3._/**/REALKIND
    f( 15) = CI*countertermnorm*eQED**5*EWctPWZ*MW
    f( 16) = (countertermnorm*eQED**5*MB*MW)/(cw*2._/**/REALKIND)
    f( 17) = (CI*eQED**3*MW**2)/3._/**/REALKIND
    f( 18) = (CI*countertermnorm*eQED**5*MW**2)/3._/**/REALKIND
    f( 19) = CI*countertermnorm*eQED**5*MW**2
    f( 20) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW**2)/3._/**/REALKIND
    f( 21) = (CI*eQED**3)/(6._/**/REALKIND*sw**2)
    f( 22) = (CI*eQED**3)/(3._/**/REALKIND*sw**2)
    f( 23) = (CI*eQED**3)/(2._/**/REALKIND*sw**2)
    f( 24) = (CI*countertermnorm*eQED**5)/(6._/**/REALKIND*sw**2)
    f( 25) = (CI*countertermnorm*eQED**5)/(3._/**/REALKIND*sw**2)
    f( 26) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*sw**2)
    f( 27) = (CI*countertermnorm*eQED**5*EWctAWW)/(2._/**/REALKIND*sw**2)
    f( 28) = (CI*countertermnorm*eQED**5*EWctVbt)/(6._/**/REALKIND*sw**2)
    f( 29) = (CI*countertermnorm*eQED**5*EWctVbt)/(3._/**/REALKIND*sw**2)
    f( 30) = (CI*countertermnorm*eQED**5*EWctVbt)/(2._/**/REALKIND*sw**2)
    f( 31) = (CI*countertermnorm*eQED**5*EWctVtb)/(6._/**/REALKIND*sw**2)
    f( 32) = (CI*countertermnorm*eQED**5*EWctVtb)/(3._/**/REALKIND*sw**2)
    f( 33) = (CI*countertermnorm*eQED**5*EWctVtb)/(2._/**/REALKIND*sw**2)
    f( 34) = (CI*countertermnorm*eQED**3*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 35) = (CI*countertermnorm*eQED**3*gQCD**2)/(3._/**/REALKIND*sw**2)
    f( 36) = (CI*countertermnorm*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 37) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 38) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 39) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2)/(3._/**/REALKIND*sw**2)
    f( 40) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 41) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2)/(3._/**/REALKIND*sw**2)
    f( 42) = (CI*eQED**3*MB)/(6._/**/REALKIND*sw**2)
    f( 43) = (CI*eQED**3*MB)/(4._/**/REALKIND*sw**2)
    f( 44) = (CI*eQED**3*MB)/(2._/**/REALKIND*sw**2)
    f( 45) = (CI*countertermnorm*eQED**5*MB)/(6._/**/REALKIND*sw**2)
    f( 46) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*sw**2)
    f( 47) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*sw**2)
    f( 48) = (CI*countertermnorm*eQED**5*EWctAWW*MB)/(2._/**/REALKIND*sw**2)
    f( 49) = (countertermnorm*eQED**5*EWctAXH*MB)/(sw**2*2._/**/REALKIND)
    f( 50) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(6._/**/REALKIND*sw**2)
    f( 51) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(6._/**/REALKIND*sw**2)
    f( 52) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*sw**2)
    f( 53) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*sw**2)
    f( 54) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(6._/**/REALKIND*sw**2)
    f( 55) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*MW*sw**2)
    f( 56) = (CI*countertermnorm*eQED**5*EWctPWA)/(2._/**/REALKIND*MW*sw**2)
    f( 57) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*MW*sw**2)
    f( 58) = (countertermnorm*cw*eQED**5*MB)/(MW*sw**2*6._/**/REALKIND)
    f( 59) = (countertermnorm*cw*eQED**5*MB)/(MW*sw**2*2._/**/REALKIND)
    f( 60) = (CI*countertermnorm*cw*eQED**5*EWctHZA*MB)/(2._/**/REALKIND*MW*sw**2)
    f( 61) = (CI*countertermnorm*eQED**5*EWctPWA*MB)/(4._/**/REALKIND*MW*sw**2)
    f( 62) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*sw**2)
    f( 63) = (CI*countertermnorm*eQED**5*MB*MW)/(2._/**/REALKIND*sw**2)
    f( 64) = (CI*cw*eQED**3)/(3._/**/REALKIND*sw)
    f( 65) = (CI*cw*eQED**3)/sw
    f( 66) = (CI*countertermnorm*cw*eQED**5)/(9._/**/REALKIND*sw)
    f( 67) = (CI*countertermnorm*cw*eQED**5)/(3._/**/REALKIND*sw)
    f( 68) = (CI*countertermnorm*cw*eQED**5)/sw
    f( 69) = (CI*countertermnorm*cw*eQED**5*EWctAWW)/sw
    f( 70) = (CI*countertermnorm*cw*eQED**3*gQCD**2)/(3._/**/REALKIND*sw)
    f( 71) = (CI*countertermnorm*ctVbb*cw*eQED**3*gQCD**2)/(3._/**/REALKIND*sw)
    f( 72) = (CI*countertermnorm*ctVbb*cw*eQED**3*gQCD**2)/sw
    f( 73) = (CI*countertermnorm*eQED**5*MB)/(3._/**/REALKIND*sw)
    f( 74) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*sw)
    f( 75) = (CI*countertermnorm*eQED**5*MB)/sw
    f( 76) = (countertermnorm*eQED**5*MB)/(sw*2._/**/REALKIND)
    f( 77) = (CI*countertermnorm*eQED**5*EWctWPH*MB)/(2._/**/REALKIND*sw)
    f( 78) = (countertermnorm*eQED**5*EWctWPX*MB)/(sw*2._/**/REALKIND)
    f( 79) = (countertermnorm*eQED**5*MB)/(MW*sw*6._/**/REALKIND)
    f( 80) = (countertermnorm*eQED**5*MB)/(MW*sw*2._/**/REALKIND)
    f( 81) = (CI*countertermnorm*eQED**5*EWctHAA*MB)/(2._/**/REALKIND*MW*sw)
    f( 82) = (CI*countertermnorm*eQED**5*EWctHWW*MB)/(6._/**/REALKIND*MW*sw)
    f( 83) = (CI*countertermnorm*eQED**5*EWctHWW*MB)/(2._/**/REALKIND*MW*sw)
    f( 84) = (countertermnorm*eQED**5*MW)/(sw*6._/**/REALKIND)
    f( 85) = (countertermnorm*eQED**5*MW)/(sw*2._/**/REALKIND)
    f( 86) = (CI*countertermnorm*cw*eQED**5*MW)/sw
    f( 87) = (CI*countertermnorm*eQED**5*EWctHAA*MW)/(3._/**/REALKIND*sw)
    f( 88) = (CI*countertermnorm*eQED**5*EWctHZA*MW)/sw
    f( 89) = (countertermnorm*eQED**5*MB*MW)/(sw*2._/**/REALKIND)
    f( 90) = (CI*countertermnorm*eQED**5)/(sqrt2*sw)
    f( 91) = (CI*countertermnorm*eQED**5*MW*sw)/cw
    f( 92) = (CI*countertermnorm*eQED**5*EWctPWA*MW*sw)/cw
    f( 93) = (CI*eQED**3*MW**2*sw)/cw
    f( 94) = (CI*countertermnorm*eQED**5*MW**2*sw)/(3._/**/REALKIND*cw)
    f( 95) = (CI*countertermnorm*eQED**5*MW**2*sw)/cw
    f( 96) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW**2*sw)/cw
    f( 97) = (eQED**5*integralnorm*SwB)/81._/**/REALKIND
    f( 98) = (eQED**5*integralnorm*SwB)/27._/**/REALKIND
    f( 99) = (eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f(100) = (eQED**5*integralnorm*SwB)/3._/**/REALKIND
    f(101) = (2*eQED**5*integralnorm*SwB)/3._/**/REALKIND
    f(102) = (eQED**5*integralnorm*SwB)/(cw**2*6._/**/REALKIND)
    f(103) = (eQED**5*integralnorm*SwB)/(cw**2*3._/**/REALKIND)
    f(104) = (eQED**5*integralnorm*SwB)/(cw**2*2._/**/REALKIND)
    f(105) = (eQED**3*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f(106) = (eQED**3*gQCD**2*integralnorm*SwB)/3._/**/REALKIND
    f(107) = (eQED**5*integralnorm*MB*SwB)/(cw**2*12._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MB*SwB)/(cw**2*4._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*12._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*4._/**/REALKIND)
    f(111) = (eQED**5*integralnorm*MW**2*SwB)/27._/**/REALKIND
    f(112) = (eQED**5*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f(113) = (eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f(114) = (2*eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f(115) = eQED**5*integralnorm*MW**2*SwB
    f(116) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f(117) = (eQED**3*gQCD**2*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f(118) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*6._/**/REALKIND)
    f(119) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f(120) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*4._/**/REALKIND)
    f(121) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f(122) = (eQED**5*integralnorm*MW**4*SwB)/3._/**/REALKIND
    f(123) = (eQED**5*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*SwB)/(sw**4*3._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f(129) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f(130) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*3._/**/REALKIND)
    f(131) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*MB*SwB)/(sw**4*24._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MB*SwB)/(sw**4*16._/**/REALKIND)
    f(134) = (eQED**5*integralnorm*MB*SwB)/(sw**4*12._/**/REALKIND)
    f(135) = (eQED**5*integralnorm*MB*SwB)/(sw**4*8._/**/REALKIND)
    f(136) = (eQED**5*integralnorm*MB*SwB)/(sw**4*6._/**/REALKIND)
    f(137) = (eQED**5*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f(138) = (eQED**5*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*24._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*16._/**/REALKIND)
    f(141) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*12._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(143) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(144) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*12._/**/REALKIND)
    f(145) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*6._/**/REALKIND)
    f(146) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f(147) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f(148) = (eQED**5*integralnorm*MB**2*SwB)/(sw**4*12._/**/REALKIND)
    f(149) = (eQED**5*integralnorm*MB**2*SwB)/(sw**4*8._/**/REALKIND)
    f(150) = (eQED**5*integralnorm*MB**2*SwB)/(sw**4*4._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MH**2*SwB)/(sw**4*8._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*MH**2*SwB)/(sw**4*4._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MB*MH**2*SwB)/(sw**4*8._/**/REALKIND)
    f(154) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(sw**4*4._/**/REALKIND)
    f(155) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(sw**4*8._/**/REALKIND)
    f(156) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(sw**4*4._/**/REALKIND)
    f(157) = (eQED**5*integralnorm*MT*SwB)/(sw**4*12._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MT*SwB)/(sw**4*8._/**/REALKIND)
    f(159) = (eQED**5*integralnorm*MT*SwB)/(sw**4*6._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MT*SwB)/(sw**4*4._/**/REALKIND)
    f(161) = (eQED**5*integralnorm*SwB)/(MW**2*sw**4*24._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*SwB)/(MW**2*sw**4*12._/**/REALKIND)
    f(163) = (eQED**5*integralnorm*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(164) = (eQED**5*integralnorm*SwB)/(MW**2*sw**4*6._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(166) = (eQED**5*integralnorm*MB*SwB)/(MW**2*sw**4*24._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*MB*SwB)/(MW**2*sw**4*12._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MB*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(169) = (eQED**5*integralnorm*MB*SwB)/(MW**2*sw**4*6._/**/REALKIND)
    f(170) = (eQED**5*integralnorm*MB*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**4*48._/**/REALKIND)
    f(172) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**4*24._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(174) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**4*12._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(176) = (eQED**5*integralnorm*MB**3*SwB)/(MW**2*sw**4*24._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*MB**3*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(178) = (eQED**5*integralnorm*MB**3*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(179) = (eQED**5*integralnorm*MH**2*SwB)/(MW**2*sw**4*12._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*MH**2*SwB)/(MW**2*sw**4*6._/**/REALKIND)
    f(182) = (eQED**5*integralnorm*MH**2*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(183) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**4*48._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**4*24._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(186) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(188) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**2*sw**4*24._/**/REALKIND)
    f(190) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(191) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(192) = (eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(193) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(194) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*MH**4*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(196) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**2*sw**4*48._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**2*sw**4*32._/**/REALKIND)
    f(198) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**2*sw**4*24._/**/REALKIND)
    f(199) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(200) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(201) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(202) = (3*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(203) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(MW**2*sw**4*32._/**/REALKIND)
    f(204) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(205) = (eQED**5*integralnorm*MT*SwB)/(MW**2*sw**4*24._/**/REALKIND)
    f(206) = (eQED**5*integralnorm*MT*SwB)/(MW**2*sw**4*12._/**/REALKIND)
    f(207) = (eQED**5*integralnorm*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(208) = (eQED**5*integralnorm*MT*SwB)/(MW**2*sw**4*6._/**/REALKIND)
    f(209) = (eQED**5*integralnorm*MT*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(210) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**4*24._/**/REALKIND)
    f(211) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**4*12._/**/REALKIND)
    f(212) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(213) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(214) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**4*24._/**/REALKIND)
    f(215) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**4*12._/**/REALKIND)
    f(216) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(217) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*6._/**/REALKIND)
    f(218) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*4._/**/REALKIND)
    f(219) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*3._/**/REALKIND)
    f(220) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f(221) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**4*24._/**/REALKIND)
    f(222) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**4*16._/**/REALKIND)
    f(223) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**4*8._/**/REALKIND)
    f(224) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**4*6._/**/REALKIND)
    f(225) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**4*4._/**/REALKIND)
    f(226) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f(227) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*sw**4*24._/**/REALKIND)
    f(228) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*sw**4*16._/**/REALKIND)
    f(229) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*sw**4*12._/**/REALKIND)
    f(230) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f(231) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(232) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(233) = (eQED**5*integralnorm*SwB)/(cw*sw**3*24._/**/REALKIND)
    f(234) = (eQED**5*integralnorm*SwB)/(cw*sw**3*12._/**/REALKIND)
    f(235) = (eQED**5*integralnorm*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(237) = (cw*eQED**5*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f(238) = (cw*eQED**5*integralnorm*SwB)/(sw**3*4._/**/REALKIND)
    f(239) = (cw*eQED**5*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f(240) = (cw*eQED**5*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(241) = (cw*eQED**5*integralnorm*SwB)/sw**3
    f(242) = (cw**3*eQED**5*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f(243) = (cw**3*eQED**5*integralnorm*SwB)/sw**3
    f(244) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*12._/**/REALKIND)
    f(245) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(246) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*6._/**/REALKIND)
    f(247) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(248) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(249) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*6._/**/REALKIND)
    f(250) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*4._/**/REALKIND)
    f(251) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*2._/**/REALKIND)
    f(252) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(253) = (cw*eQED**5*integralnorm*MH**2*SwB)/(sw**3*4._/**/REALKIND)
    f(254) = (cw*eQED**5*integralnorm*SwB)/(MW**2*sw**3*6._/**/REALKIND)
    f(255) = (cw*eQED**5*integralnorm*SwB)/(MW**2*sw**3*3._/**/REALKIND)
    f(256) = (cw*eQED**5*integralnorm*SwB)/(MW**2*sw**3*2._/**/REALKIND)
    f(257) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**3*12._/**/REALKIND)
    f(258) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**3*4._/**/REALKIND)
    f(259) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(260) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*3._/**/REALKIND)
    f(261) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3)
    f(262) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(263) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*3._/**/REALKIND)
    f(264) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(265) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3)
    f(266) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*6._/**/REALKIND)
    f(267) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*4._/**/REALKIND)
    f(268) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*3._/**/REALKIND)
    f(269) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f(270) = (cw*eQED**5*integralnorm*MW**2*SwB)/sw**3
    f(271) = (eQED**5*integralnorm*SwB)/(sw**2*54._/**/REALKIND)
    f(272) = (eQED**5*integralnorm*SwB)/(sw**2*36._/**/REALKIND)
    f(273) = (eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(274) = (eQED**5*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f(275) = (2*eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(276) = (eQED**5*integralnorm*SwB)/(sw**2*12._/**/REALKIND)
    f(277) = (eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(278) = (4*eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(279) = (eQED**5*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(280) = (2*eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(281) = (eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(282) = (eQED**5*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(283) = (eQED**5*integralnorm*SwB)/sw**2
    f(284) = (cw**2*eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(285) = (cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(286) = (cw**2*eQED**5*integralnorm*SwB)/sw**2
    f(287) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(288) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(289) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(290) = (eQED**5*integralnorm*MB*SwB)/(sw**2*54._/**/REALKIND)
    f(291) = (eQED**5*integralnorm*MB*SwB)/(sw**2*36._/**/REALKIND)
    f(292) = (eQED**5*integralnorm*MB*SwB)/(sw**2*18._/**/REALKIND)
    f(293) = (eQED**5*integralnorm*MB*SwB)/(sw**2*12._/**/REALKIND)
    f(294) = (eQED**5*integralnorm*MB*SwB)/(sw**2*6._/**/REALKIND)
    f(295) = (eQED**5*integralnorm*MB*SwB)/(sw**2*4._/**/REALKIND)
    f(296) = (eQED**5*integralnorm*MB*SwB)/(sw**2*2._/**/REALKIND)
    f(297) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*24._/**/REALKIND)
    f(298) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(299) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(sw**2*6._/**/REALKIND)
    f(300) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(sw**2*4._/**/REALKIND)
    f(301) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(sw**2*2._/**/REALKIND)
    f(302) = (eQED**5*integralnorm*MB**2*SwB)/(sw**2*12._/**/REALKIND)
    f(303) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(304) = (eQED**5*integralnorm*MH**2*SwB)/(sw**2*18._/**/REALKIND)
    f(305) = (eQED**5*integralnorm*MH**2*SwB)/(sw**2*12._/**/REALKIND)
    f(306) = (eQED**5*integralnorm*MH**2*SwB)/(sw**2*6._/**/REALKIND)
    f(307) = (eQED**5*integralnorm*MH**2*SwB)/(sw**2*3._/**/REALKIND)
    f(308) = (eQED**5*integralnorm*MB*MH**2*SwB)/(sw**2*12._/**/REALKIND)
    f(309) = (eQED**5*integralnorm*MB*MH**2*SwB)/(sw**2*4._/**/REALKIND)
    f(310) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(311) = (eQED**5*integralnorm*MH**4*SwB)/(sw**2*12._/**/REALKIND)
    f(312) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(313) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(314) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(315) = (2*eQED**5*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(316) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(317) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(318) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2)
    f(319) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*36._/**/REALKIND)
    f(320) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(321) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(322) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(323) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(324) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*18._/**/REALKIND)
    f(325) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*12._/**/REALKIND)
    f(326) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*9._/**/REALKIND)
    f(327) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f(328) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*3._/**/REALKIND)
    f(329) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(330) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(331) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(332) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2)
    f(333) = (cw**2*eQED**5*integralnorm*MW**2*SwB)/(sw**2*3._/**/REALKIND)
    f(334) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f(335) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**2*4._/**/REALKIND)
    f(336) = (eQED**5*integralnorm*MB*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(337) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*sw**2*4._/**/REALKIND)
    f(338) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(339) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(340) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f(341) = (eQED**5*integralnorm*MW**4*SwB)/(sw**2*3._/**/REALKIND)
    f(342) = (eQED**5*integralnorm*SwB)/(cw*sw*12._/**/REALKIND)
    f(343) = (eQED**5*integralnorm*SwB)/(cw*sw*6._/**/REALKIND)
    f(344) = (eQED**5*integralnorm*SwB)/(cw*sw*4._/**/REALKIND)
    f(345) = (eQED**5*integralnorm*SwB)/(cw*sw*3._/**/REALKIND)
    f(346) = (eQED**5*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(347) = (cw*eQED**5*integralnorm*SwB)/(sw*27._/**/REALKIND)
    f(348) = (cw*eQED**5*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(349) = (cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(350) = (cw*eQED**5*integralnorm*SwB)/sw
    f(351) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(352) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/sw
    f(353) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*12._/**/REALKIND)
    f(354) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(355) = (eQED**5*integralnorm*MB**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(356) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(357) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(358) = (eQED**5*integralnorm*MH**4*SwB)/(cw*sw*4._/**/REALKIND)
    f(359) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*6._/**/REALKIND)
    f(360) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*4._/**/REALKIND)
    f(361) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(362) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(363) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(364) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(365) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw)
    f(366) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw*3._/**/REALKIND)
    f(367) = (cw*eQED**5*integralnorm*MW**2*SwB)/sw
    f(368) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(369) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(370) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(371) = (eQED**5*integralnorm*MH**2*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(372) = (eQED**5*integralnorm*MW**4*SwB)/(cw**5*sw)
    f(373) = (eQED**5*integralnorm*MW**4*SwB)/(cw**3*sw)
    f(374) = (eQED**5*integralnorm*MW**4*SwB)/(cw*sw)
    f(375) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(376) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(377) = (eQED**5*integralnorm*MW**2*sw*SwB)/cw
    f(378) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/cw
    f(379) = (eQED**3*gQCD**2*integralnorm*MW**2*sw*SwB)/cw
    f(380) = (eQED**5*integralnorm*MW**4*sw*SwB)/cw
    f(381) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*9._/**/REALKIND)
    f(382) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(383) = (2*eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(384) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(385) = (eQED**5*integralnorm*MW**4*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(386) = (eQED**5*integralnorm*MW**4*sw**3*SwB)/cw**3
    f(387) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(388) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(389) = -((eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(390) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(391) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**2*18._/**/REALKIND)
    f(392) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**2*6._/**/REALKIND)
    f(393) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**2*3._/**/REALKIND)
    f(394) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(395) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(sw**4*8._/**/REALKIND))
    f(396) = -((eQED**5*integralnorm*MB*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(397) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(398) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*16._/**/REALKIND)
    f(399) = (eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(400) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**4*12._/**/REALKIND))
    f(401) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**4*6._/**/REALKIND))
    f(402) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**4*4._/**/REALKIND))
    f(403) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**4*2._/**/REALKIND))
    f(404) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**4*24._/**/REALKIND))
    f(405) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**4*8._/**/REALKIND))
    f(406) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW**2*sw**4*4._/**/REALKIND))
    f(407) = (eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(408) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(409) = (eQED**5*integralnorm*MW**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(410) = (eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**2*6._/**/REALKIND)
    f(411) = -((eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**4*8._/**/REALKIND))
    f(412) = (eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(413) = -((eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(414) = (eQED**5*integralnorm*MB*MW**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*16._/**/REALKIND)
    f(415) = (eQED**5*integralnorm*MB*MW**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(416) = (eQED**5*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw**2*4._/**/REALKIND)
    f(417) = (eQED**5*integralnorm*MW**4*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*12._/**/REALKIND)
    f(418) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*24._/**/REALKIND))
    f(419) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(420) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(421) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(422) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*2._/**/REALKIND))
    f(423) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(424) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(425) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(426) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(427) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*2._/**/REALKIND))
    f(428) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(429) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(430) = -((cw*eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**3*2._/**/REALKIND))
    f(431) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw*sw**3*12._/**/REALKIND*6._/**/REALKIND)
    f(432) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(433) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(434) = (eQED**5*integralnorm*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw*sw**3*2._/**/REALKIND)
    f(435) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(436) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(437) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(438) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(439) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(440) = -((eQED**5*integralnorm*MW**4*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(441) = (eQED**5*integralnorm*MW**2*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**2*12._/**/REALKIND*6._/**/REALKIND)
    f(442) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*6._/**/REALKIND))
    f(443) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*3._/**/REALKIND))
    f(444) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*2._/**/REALKIND))
    f(445) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*6._/**/REALKIND))
    f(446) = (eQED**5*integralnorm*MW**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**3*sw*2._/**/REALKIND*4._/**/REALKIND)
    f(447) = (eQED**5*integralnorm*MW**2*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**3*sw*2._/**/REALKIND)
    f(448) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(449) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/cw**3)
    f(450) = (eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(451) = (2*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(452) = (eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(453) = (4*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(454) = (2*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(455) = (8*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(456) = (eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(457) = (4*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(458) = (16*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(459) = (2*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(460) = (8*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(461) = (eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(462) = (4*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(463) = (2*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(464) = (8*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(465) = eQED**5*integralnorm*SwF
    f(466) = (4*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(467) = (eQED**5*integralnorm*MW**2*SwF)/27._/**/REALKIND
    f(468) = (2*eQED**5*integralnorm*MW**2*SwF)/27._/**/REALKIND
    f(469) = (4*eQED**5*integralnorm*MW**2*SwF)/27._/**/REALKIND
    f(470) = (8*eQED**5*integralnorm*MW**2*SwF)/27._/**/REALKIND
    f(471) = (eQED**5*integralnorm*MW**2*SwF)/3._/**/REALKIND
    f(472) = (2*eQED**5*integralnorm*MW**2*SwF)/3._/**/REALKIND
    f(473) = eQED**5*integralnorm*MW**2*SwF
    f(474) = (4*eQED**5*integralnorm*MW**2*SwF)/3._/**/REALKIND
    f(475) = (eQED**5*integralnorm*SwF)/(sw**4*12._/**/REALKIND)
    f(476) = (eQED**5*integralnorm*SwF)/(sw**4*6._/**/REALKIND)
    f(477) = (eQED**5*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(478) = (eQED**5*integralnorm*SwF)/(sw**4*3._/**/REALKIND)
    f(479) = (eQED**5*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(480) = (eQED**5*integralnorm*MB*SwF)/(sw**4*12._/**/REALKIND)
    f(481) = (eQED**5*integralnorm*MB*SwF)/(sw**4*6._/**/REALKIND)
    f(482) = (eQED**5*integralnorm*MB*SwF)/(sw**4*4._/**/REALKIND)
    f(483) = (eQED**5*integralnorm*MB*SwF)/(sw**4*3._/**/REALKIND)
    f(484) = (eQED**5*integralnorm*MB*SwF)/(sw**4*2._/**/REALKIND)
    f(485) = (eQED**5*integralnorm*ME*SwF)/(sw**4*4._/**/REALKIND)
    f(486) = (eQED**5*integralnorm*MB*ME*SwF)/(sw**4*4._/**/REALKIND)
    f(487) = (eQED**5*integralnorm*ML*SwF)/(sw**4*4._/**/REALKIND)
    f(488) = (eQED**5*integralnorm*MB*ML*SwF)/(sw**4*4._/**/REALKIND)
    f(489) = (eQED**5*integralnorm*MM*SwF)/(sw**4*4._/**/REALKIND)
    f(490) = (eQED**5*integralnorm*MB*MM*SwF)/(sw**4*4._/**/REALKIND)
    f(491) = (eQED**5*integralnorm*SwF)/(MW**2*sw**4*12._/**/REALKIND)
    f(492) = (eQED**5*integralnorm*SwF)/(MW**2*sw**4*6._/**/REALKIND)
    f(493) = (eQED**5*integralnorm*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(494) = (eQED**5*integralnorm*MB*SwF)/(MW**2*sw**4*24._/**/REALKIND)
    f(495) = (eQED**5*integralnorm*MB*SwF)/(MW**2*sw**4*12._/**/REALKIND)
    f(496) = (eQED**5*integralnorm*MB*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(497) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**4*24._/**/REALKIND)
    f(498) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**4*12._/**/REALKIND)
    f(499) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(500) = (eQED**5*integralnorm*MB**3*SwF)/(MW**2*sw**4*24._/**/REALKIND)
    f(501) = (eQED**5*integralnorm*MB**3*SwF)/(MW**2*sw**4*16._/**/REALKIND)
    f(502) = (eQED**5*integralnorm*MB**3*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(503) = (eQED**5*integralnorm*ME*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(504) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**4*24._/**/REALKIND)
    f(505) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(506) = (eQED**5*integralnorm*ME**2*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(507) = (eQED**5*integralnorm*MB*ME**2*SwF)/(MW**2*sw**4*24._/**/REALKIND)
    f(508) = (eQED**5*integralnorm*MB*ME**2*SwF)/(MW**2*sw**4*16._/**/REALKIND)
    f(509) = (eQED**5*integralnorm*MB*ME**2*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(510) = (eQED**5*integralnorm*ML*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(511) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**4*24._/**/REALKIND)
    f(512) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(513) = (eQED**5*integralnorm*ML**2*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(514) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**2*sw**4*24._/**/REALKIND)
    f(515) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**2*sw**4*16._/**/REALKIND)
    f(516) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(517) = (eQED**5*integralnorm*MM*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(518) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**4*24._/**/REALKIND)
    f(519) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(520) = (eQED**5*integralnorm*MM**2*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(521) = (eQED**5*integralnorm*MB*MM**2*SwF)/(MW**2*sw**4*24._/**/REALKIND)
    f(522) = (eQED**5*integralnorm*MB*MM**2*SwF)/(MW**2*sw**4*16._/**/REALKIND)
    f(523) = (eQED**5*integralnorm*MB*MM**2*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(524) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**4*24._/**/REALKIND)
    f(525) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**4*12._/**/REALKIND)
    f(526) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(527) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**2*sw**4*24._/**/REALKIND)
    f(528) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**2*sw**4*16._/**/REALKIND)
    f(529) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**2*sw**4*12._/**/REALKIND)
    f(530) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**2*sw**4*8._/**/REALKIND)
    f(531) = (cw*eQED**5*integralnorm*SwF)/(sw**3*6._/**/REALKIND)
    f(532) = (cw*eQED**5*integralnorm*SwF)/(sw**3*3._/**/REALKIND)
    f(533) = (cw*eQED**5*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(534) = (2*cw*eQED**5*integralnorm*SwF)/(sw**3*3._/**/REALKIND)
    f(535) = (cw*eQED**5*integralnorm*SwF)/sw**3
    f(536) = (cw*eQED**5*integralnorm*ME*SwF)/(sw**3*2._/**/REALKIND)
    f(537) = (cw*eQED**5*integralnorm*ML*SwF)/(sw**3*2._/**/REALKIND)
    f(538) = (cw*eQED**5*integralnorm*MM*SwF)/(sw**3*2._/**/REALKIND)
    f(539) = (cw*eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**3*12._/**/REALKIND)
    f(540) = (cw*eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**3*4._/**/REALKIND)
    f(541) = (cw*eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**3*12._/**/REALKIND)
    f(542) = (cw*eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**3*4._/**/REALKIND)
    f(543) = (cw*eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**3*12._/**/REALKIND)
    f(544) = (cw*eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**3*4._/**/REALKIND)
    f(545) = (cw*eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**3*12._/**/REALKIND)
    f(546) = (cw*eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**3*4._/**/REALKIND)
    f(547) = (cw*eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**3*12._/**/REALKIND)
    f(548) = (cw*eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**3*6._/**/REALKIND)
    f(549) = (cw*eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**3*4._/**/REALKIND)
    f(550) = (eQED**5*integralnorm*SwF)/(sw**2*54._/**/REALKIND)
    f(551) = (eQED**5*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(552) = (eQED**5*integralnorm*SwF)/(sw**2*18._/**/REALKIND)
    f(553) = (2*eQED**5*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(554) = (eQED**5*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(555) = (4*eQED**5*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(556) = (eQED**5*integralnorm*SwF)/(sw**2*6._/**/REALKIND)
    f(557) = (2*eQED**5*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(558) = (eQED**5*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(559) = (eQED**5*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(560) = (2*eQED**5*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(561) = (eQED**5*integralnorm*SwF)/sw**2
    f(562) = (eQED**5*integralnorm*MB*SwF)/(sw**2*54._/**/REALKIND)
    f(563) = (eQED**5*integralnorm*MB*SwF)/(sw**2*36._/**/REALKIND)
    f(564) = (eQED**5*integralnorm*MB*SwF)/(sw**2*18._/**/REALKIND)
    f(565) = (eQED**5*integralnorm*MB*SwF)/(sw**2*6._/**/REALKIND)
    f(566) = (eQED**5*integralnorm*MB*SwF)/(sw**2*4._/**/REALKIND)
    f(567) = (eQED**5*integralnorm*MB*SwF)/(sw**2*2._/**/REALKIND)
    f(568) = (eQED**5*integralnorm*MB**2*SwF)/(sw**2*12._/**/REALKIND)
    f(569) = (eQED**5*integralnorm*ME*SwF)/(sw**2*18._/**/REALKIND)
    f(570) = (eQED**5*integralnorm*ME*SwF)/(sw**2*12._/**/REALKIND)
    f(571) = (eQED**5*integralnorm*ME*SwF)/(sw**2*6._/**/REALKIND)
    f(572) = (eQED**5*integralnorm*ME*SwF)/(sw**2*4._/**/REALKIND)
    f(573) = (eQED**5*integralnorm*ME*SwF)/(sw**2*2._/**/REALKIND)
    f(574) = (eQED**5*integralnorm*MB*ME*SwF)/(sw**2*4._/**/REALKIND)
    f(575) = (eQED**5*integralnorm*ME**2*SwF)/(sw**2*6._/**/REALKIND)
    f(576) = (eQED**5*integralnorm*ML*SwF)/(sw**2*18._/**/REALKIND)
    f(577) = (eQED**5*integralnorm*ML*SwF)/(sw**2*12._/**/REALKIND)
    f(578) = (eQED**5*integralnorm*ML*SwF)/(sw**2*6._/**/REALKIND)
    f(579) = (eQED**5*integralnorm*ML*SwF)/(sw**2*4._/**/REALKIND)
    f(580) = (eQED**5*integralnorm*ML*SwF)/(sw**2*2._/**/REALKIND)
    f(581) = (eQED**5*integralnorm*MB*ML*SwF)/(sw**2*4._/**/REALKIND)
    f(582) = (eQED**5*integralnorm*ML**2*SwF)/(sw**2*6._/**/REALKIND)
    f(583) = (eQED**5*integralnorm*MM*SwF)/(sw**2*18._/**/REALKIND)
    f(584) = (eQED**5*integralnorm*MM*SwF)/(sw**2*12._/**/REALKIND)
    f(585) = (eQED**5*integralnorm*MM*SwF)/(sw**2*6._/**/REALKIND)
    f(586) = (eQED**5*integralnorm*MM*SwF)/(sw**2*4._/**/REALKIND)
    f(587) = (eQED**5*integralnorm*MM*SwF)/(sw**2*2._/**/REALKIND)
    f(588) = (eQED**5*integralnorm*MB*MM*SwF)/(sw**2*4._/**/REALKIND)
    f(589) = (eQED**5*integralnorm*MM**2*SwF)/(sw**2*6._/**/REALKIND)
    f(590) = (eQED**5*integralnorm*MT*SwF)/(sw**2*27._/**/REALKIND)
    f(591) = (eQED**5*integralnorm*MT*SwF)/(sw**2*18._/**/REALKIND)
    f(592) = (2*eQED**5*integralnorm*MT*SwF)/(sw**2*27._/**/REALKIND)
    f(593) = (eQED**5*integralnorm*MT*SwF)/(sw**2*9._/**/REALKIND)
    f(594) = (eQED**5*integralnorm*MT*SwF)/(sw**2*6._/**/REALKIND)
    f(595) = (eQED**5*integralnorm*MT*SwF)/(sw**2*4._/**/REALKIND)
    f(596) = (eQED**5*integralnorm*MT*SwF)/(sw**2*3._/**/REALKIND)
    f(597) = (eQED**5*integralnorm*MT*SwF)/(sw**2*2._/**/REALKIND)
    f(598) = (eQED**5*integralnorm*MB*MT*SwF)/(sw**2*6._/**/REALKIND)
    f(599) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*36._/**/REALKIND)
    f(600) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(601) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(602) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(603) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(604) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(605) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(606) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(607) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(608) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*9._/**/REALKIND)
    f(609) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(610) = (eQED**5*integralnorm*SwF)/(cw*sw*6._/**/REALKIND)
    f(611) = (eQED**5*integralnorm*SwF)/(cw*sw*3._/**/REALKIND)
    f(612) = (eQED**5*integralnorm*SwF)/(cw*sw*2._/**/REALKIND)
    f(613) = (cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(614) = (2*cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(615) = (cw*eQED**5*integralnorm*SwF)/(sw*9._/**/REALKIND)
    f(616) = (4*cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(617) = (2*cw*eQED**5*integralnorm*SwF)/(sw*9._/**/REALKIND)
    f(618) = (8*cw*eQED**5*integralnorm*SwF)/(sw*27._/**/REALKIND)
    f(619) = (cw*eQED**5*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(620) = (4*cw*eQED**5*integralnorm*SwF)/(sw*9._/**/REALKIND)
    f(621) = (2*cw*eQED**5*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(622) = (cw*eQED**5*integralnorm*SwF)/sw
    f(623) = (4*cw*eQED**5*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(624) = (2*cw*eQED**5*integralnorm*SwF)/sw
    f(625) = (3*cw*eQED**5*integralnorm*SwF)/sw
    f(626) = (eQED**5*integralnorm*MB**2*SwF)/(cw*sw*4._/**/REALKIND)
    f(627) = (eQED**5*integralnorm*ME*SwF)/(cw*sw*2._/**/REALKIND)
    f(628) = (eQED**5*integralnorm*MB*ME*SwF)/(cw*sw*4._/**/REALKIND)
    f(629) = (eQED**5*integralnorm*ME**2*SwF)/(cw*sw*2._/**/REALKIND)
    f(630) = (eQED**5*integralnorm*ML*SwF)/(cw*sw*2._/**/REALKIND)
    f(631) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*sw*4._/**/REALKIND)
    f(632) = (eQED**5*integralnorm*ML**2*SwF)/(cw*sw*2._/**/REALKIND)
    f(633) = (eQED**5*integralnorm*MM*SwF)/(cw*sw*2._/**/REALKIND)
    f(634) = (eQED**5*integralnorm*MB*MM*SwF)/(cw*sw*4._/**/REALKIND)
    f(635) = (eQED**5*integralnorm*MM**2*SwF)/(cw*sw*2._/**/REALKIND)
    f(636) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*sw*4._/**/REALKIND)
    f(637) = (eQED**5*integralnorm*MW**2*sw*SwF)/(cw*9._/**/REALKIND)
    f(638) = (2*eQED**5*integralnorm*MW**2*sw*SwF)/(cw*9._/**/REALKIND)
    f(639) = (eQED**5*integralnorm*MW**2*sw*SwF)/(cw*3._/**/REALKIND)
    f(640) = (4*eQED**5*integralnorm*MW**2*sw*SwF)/(cw*9._/**/REALKIND)
    f(641) = (eQED**5*integralnorm*MW**2*sw*SwF)/cw
    f(642) = (2*eQED**5*integralnorm*MW**2*sw*SwF)/cw
    f(643) = (3*eQED**5*integralnorm*MW**2*sw*SwF)/cw

  c = [ 3*f(97), 3*f(98), 3*f(99), 3*f(100), 3*f(101), 3*f(102), 3*f(103), 3*f(104), 4*f(105), 4*f(106), 3*f(107), 3*f(108) &
    , 3*f(109), 3*f(110), 3*f(111), 3*f(112), 3*f(113), 3*f(114), 3*f(115), 3*f(116), 4*f(117), 3*f(118), 3*f(119), 3*f(120) &
    , 3*f(121), 3*f(122), 3*f(123), 3*f(124), 3*f(125), 3*f(126), 3*f(127), 3*f(128), 3*f(129), 3*f(130), 3*f(131), 3*f(132) &
    , 3*f(133), 3*f(134), 3*f(135), 3*f(136), 3*f(137), 3*f(138), 3*f(139), 3*f(140), 3*f(141), 3*f(142), 3*f(143), 3*f(144) &
    , 3*f(145), 3*f(146), 3*f(147), 3*f(148), 3*f(149), 3*f(150), 3*f(151), 3*f(152), 3*f(153), 3*f(154), 3*f(155), 3*f(156) &
    , 3*f(157), 3*f(158), 3*f(159), 3*f(160), 3*f(161), 3*f(162), 3*f(163), 3*f(164), 3*f(165), 3*f(166), 3*f(167), 3*f(168) &
    , 3*f(169), 3*f(170), 3*f(171), 3*f(172), 3*f(173), 3*f(174), 3*f(175), 3*f(176), 3*f(177), 3*f(178), 3*f(179), 3*f(180) &
    , 3*f(181), 3*f(182), 3*f(183), 3*f(184), 3*f(185), 3*f(186), 3*f(187), 3*f(188), 3*f(189), 3*f(190), 3*f(191), 3*f(192) &
    , 3*f(193), 3*f(194), 3*f(195), 3*f(196), 3*f(197), 3*f(198), 3*f(199), 3*f(200), 3*f(201), 3*f(202), 3*f(203), 3*f(204) &
    , 3*f(205), 3*f(206), 3*f(207), 3*f(208), 3*f(209), 3*f(210), 3*f(211), 3*f(212), 3*f(213), 3*f(214), 3*f(215), 3*f(216) &
    , 3*f(217), 3*f(218), 3*f(219), 3*f(220), 3*f(221), 3*f(222), 3*f(223), 3*f(224), 3*f(225), 3*f(226), 3*f(227), 3*f(228) &
    , 3*f(229), 3*f(230), 3*f(231), 3*f(232), 3*f(233), 3*f(234), 3*f(235), 3*f(236), 3*f(237), 3*f(238), 3*f(239), 3*f(240) &
    , 3*f(241), 3*f(242), 3*f(243), 3*f(244), 3*f(245), 3*f(246), 3*f(247), 3*f(248), 3*f(249), 3*f(250), 3*f(251), 3*f(252) &
    , 3*f(253), 3*f(254), 3*f(255), 3*f(256), 3*f(257), 3*f(258), 3*f(259), 3*f(260), 3*f(261), 3*f(262), 3*f(263), 3*f(264) &
    , 3*f(265), 3*f(266), 3*f(267), 3*f(268), 3*f(269), 3*f(270), 3*f(271), 3*f(272), 3*f(273), 3*f(274), 3*f(275), 3*f(276) &
    , 3*f(277), 3*f(278), 3*f(279), 3*f(280), 3*f(281), 3*f(282), 3*f(283), 3*f(284), 3*f(285), 3*f(286), 4*f(287), 4*f(288) &
    , 4*f(289), 3*f(290), 3*f(291), 3*f(292), 3*f(293), 3*f(294), 3*f(295), 3*f(296), 3*f(297), 3*f(298), 4*f(299), 4*f(300) &
    , 4*f(301), 3*f(302), 3*f(303), 3*f(304), 3*f(305), 3*f(306), 3*f(307), 3*f(308), 3*f(309), 3*f(310), 3*f(311), 3*f(312) &
    , 3*f(313), 3*f(314), 3*f(315), 3*f(316), 3*f(317), 3*f(318), 3*f(319), 3*f(320), 3*f(321), 3*f(322), 3*f(323), 3*f(324) &
    , 3*f(325), 3*f(326), 3*f(327), 3*f(328), 3*f(329), 3*f(330), 3*f(331), 3*f(332), 3*f(333), 3*f(334), 3*f(335), 3*f(336) &
    , 3*f(337), 3*f(338), 3*f(339), 3*f(340), 3*f(341), 3*f(342), 3*f(343), 3*f(344), 3*f(345), 3*f(346), 3*f(347), 3*f(348) &
    , 3*f(349), 3*f(350), 4*f(351), 4*f(352), 3*f(353), 3*f(354), 3*f(355), 3*f(356), 3*f(357), 3*f(358), 3*f(359), 3*f(360) &
    , 3*f(361), 3*f(362), 3*f(363), 3*f(364), 3*f(365), 3*f(366), 3*f(367), 3*f(368), 3*f(369), 3*f(370), 3*f(371), 3*f(372) &
    , 3*f(373), 3*f(374), 3*f(375), 3*f(376), 3*f(377), 3*f(378), 4*f(379), 3*f(380), 3*f(381), 3*f(382), 3*f(383), 3*f(384) &
    , 3*f(385), 3*f(386), 3*f(387), 3*f(388), 3*f(389), 3*f(390), 3*f(391), 3*f(392), 3*f(393), 3*f(394), 3*f(395), 3*f(396) &
    , 3*f(397), 3*f(398), 3*f(399), 3*f(400), 3*f(401), 3*f(402), 3*f(403), 3*f(404), 3*f(405), 3*f(406), 3*f(407), 3*f(408) &
    , 3*f(409), 3*f(410), 3*f(411), 3*f(412), 3*f(413), 3*f(414), 3*f(415), 3*f(416), 3*f(417), 3*f(418), 3*f(419), 3*f(420) &
    , 3*f(421), 3*f(422), 3*f(423), 3*f(424), 3*f(425), 3*f(426), 3*f(427), 3*f(428), 3*f(429), 3*f(430), 3*f(431), 3*f(432) &
    , 3*f(433), 3*f(434), 3*f(435), 3*f(436), 3*f(437), 3*f(438), 3*f(439), 3*f(440), 3*f(441), 3*f(442), 3*f(443), 3*f(444) &
    , 3*f(445), 3*f(446), 3*f(447), 3*f(448), 3*f(449), 9*f(450), 9*f(451), 9*f(452), 9*f(453), 9*f(454), 9*f(455), 3*f(456) &
    , 9*f(456), 9*f(457), 9*f(458), 9*f(459), 9*f(460), 3*f(461), 9*f(461), 9*f(462), 9*f(463), 9*f(464), 3*f(465), 9*f(466) &
    , 9*f(467), 9*f(468), 9*f(469), 9*f(470), 3*f(471), 9*f(471), 9*f(472), 3*f(473), 9*f(474), 9*f(475), 9*f(476), 3*f(477) &
    , 9*f(477), 9*f(478), 9*f(479), 9*f(480), 9*f(481), 3*f(482), 9*f(482), 9*f(483), 9*f(484), 3*f(485), 3*f(486), 3*f(487) &
    , 3*f(488), 3*f(489), 3*f(490), 9*f(491), 9*f(492), 9*f(493), 9*f(494), 9*f(495), 9*f(496), 9*f(497), 9*f(498), 9*f(499) &
    , 9*f(500), 9*f(501), 9*f(502), 3*f(503), 3*f(504), 3*f(505), 3*f(506), 3*f(507), 3*f(508), 3*f(509), 3*f(510), 3*f(511) &
    , 3*f(512), 3*f(513), 3*f(514), 3*f(515), 3*f(516), 3*f(517), 3*f(518), 3*f(519), 3*f(520), 3*f(521), 3*f(522), 3*f(523) &
    , 9*f(524), 9*f(525), 9*f(526), 9*f(527), 9*f(528), 9*f(529), 9*f(530), 9*f(531), 9*f(532), 3*f(533), 9*f(533), 9*f(534) &
    , 9*f(535), 3*f(536), 3*f(537), 3*f(538), 9*f(539), 9*f(540), 3*f(541), 3*f(542), 3*f(543), 3*f(544), 3*f(545), 3*f(546) &
    , 9*f(547), 9*f(548), 9*f(549), 9*f(550), 9*f(551), 3*f(552), 9*f(552), 9*f(553), 9*f(554), 9*f(555), 3*f(556), 9*f(556) &
    , 9*f(557), 9*f(558), 3*f(559), 9*f(559), 9*f(560), 9*f(561), 9*f(562), 9*f(563), 9*f(564), 9*f(565), 9*f(566), 9*f(567) &
    , 9*f(568), 3*f(569), 3*f(570), 3*f(571), 3*f(572), 3*f(573), 3*f(574), 3*f(575), 3*f(576), 3*f(577), 3*f(578), 3*f(579) &
    , 3*f(580), 3*f(581), 3*f(582), 3*f(583), 3*f(584), 3*f(585), 3*f(586), 3*f(587), 3*f(588), 3*f(589), 9*f(590), 9*f(591) &
    , 9*f(592), 9*f(593), 9*f(594), 9*f(595), 9*f(596), 9*f(597), 9*f(598), 9*f(599), 9*f(600), 3*f(601), 3*f(602), 3*f(603) &
    , 3*f(604), 3*f(605), 3*f(606), 9*f(607), 9*f(608), 9*f(609), 9*f(610), 9*f(611), 9*f(612), 9*f(613), 9*f(614), 3*f(615) &
    , 9*f(615), 9*f(616), 9*f(617), 9*f(618), 3*f(619), 9*f(619), 9*f(620), 9*f(621), 3*f(622), 9*f(622), 9*f(623), 9*f(624) &
    , 3*f(625), 9*f(626), 3*f(627), 3*f(628), 3*f(629), 3*f(630), 3*f(631), 3*f(632), 3*f(633), 3*f(634), 3*f(635), 9*f(636) &
    , 9*f(637), 9*f(638), 3*f(639), 9*f(640), 3*f(641), 9*f(641), 9*f(642), 3*f(643) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(3) = 1 /((L(5,3) - MH2)+L(6,3))
  den(4) = 1 /((L(5,12) - MW2)+L(6,12))
  den(8) = 1 /((L(5,20) - MW2)+L(6,20))
  den(12) = 1 /((L(5,5) - MB2)+L(6,5))
  den(13) = 1 /((L(5,10) - MT2)+L(6,10))
  den(15) = 1 /((L(5,24) - MH2)+L(6,24))
  den(17) = 1 /((L(5,24))+L(6,24))
  den(19) = 1 /((L(5,24) - MZ2)+L(6,24))
  den(21) = 1 /((L(5,17) - MT2)+L(6,17))
  den(22) = 1 /((L(5,6) - MB2)+L(6,6))
  den(30) = 1 /((L(5,28))+L(6,28))
  den(31) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(40) = 1 /((L(5,28) - MH2)+L(6,28))
  den(49) = 1 /((L(5,19) - MW2)+L(6,19))
  den(64) = 1 /((L(5,11) - MW2)+L(6,11))
  den(71) = 1 /((L(5,26) - MB2)+L(6,26))
  den(74) = 1 /((L(5,21) - MT2)+L(6,21))
  den(83) = 1 /((L(5,7) - MH2)+L(6,7))
  den(86) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(90) = 1 /((L(5,7))+L(6,7))
  den(94) = 1 /((L(5,14) - MT2)+L(6,14))
  den(97) = 1 /((L(5,25) - MB2)+L(6,25))

  ! denominators
  den(5) = den(3)*den(4)
  den(6) = den(2)*den(4)
  den(7) = den(1)*den(4)
  den(9) = den(3)*den(8)
  den(10) = den(2)*den(8)
  den(11) = den(1)*den(8)
  den(14) = den(12)*den(13)
  den(16) = den(12)*den(15)
  den(18) = den(12)*den(17)
  den(20) = den(12)*den(19)
  den(23) = den(21)*den(22)
  den(24) = den(15)*den(22)
  den(25) = den(17)*den(22)
  den(26) = den(19)*den(22)
  den(27) = den(13)*den(21)
  den(28) = den(8)*den(13)
  den(29) = den(4)*den(21)
  den(32) = den(2)*den(30)
  den(33) = den(2)*den(31)
  den(34) = den(1)*den(30)
  den(35) = den(1)*den(31)
  den(36) = den(2)*den(15)
  den(37) = den(3)*den(17)
  den(38) = den(3)*den(19)
  den(39) = den(1)*den(15)
  den(41) = den(4)*den(40)
  den(42) = den(3)*den(41)
  den(43) = den(4)*den(31)
  den(44) = den(2)*den(43)
  den(45) = den(4)*den(30)
  den(46) = den(2)*den(45)
  den(47) = den(1)*den(43)
  den(48) = den(1)*den(45)
  den(50) = den(3)*den(49)
  den(51) = den(4)*den(50)
  den(52) = den(2)*den(49)
  den(53) = den(4)*den(52)
  den(54) = den(1)*den(49)
  den(55) = den(4)*den(54)
  den(56) = den(8)*den(40)
  den(57) = den(3)*den(56)
  den(58) = den(8)*den(31)
  den(59) = den(2)*den(58)
  den(60) = den(8)*den(30)
  den(61) = den(2)*den(60)
  den(62) = den(1)*den(58)
  den(63) = den(1)*den(60)
  den(65) = den(3)*den(64)
  den(66) = den(8)*den(65)
  den(67) = den(2)*den(64)
  den(68) = den(8)*den(67)
  den(69) = den(1)*den(64)
  den(70) = den(8)*den(69)
  den(72) = den(13)*den(71)
  den(73) = den(12)*den(72)
  den(75) = den(12)*den(74)
  den(76) = den(13)*den(75)
  den(77) = den(15)*den(71)
  den(78) = den(12)*den(77)
  den(79) = den(17)*den(71)
  den(80) = den(12)*den(79)
  den(81) = den(19)*den(71)
  den(82) = den(12)*den(81)
  den(84) = den(12)*den(83)
  den(85) = den(15)*den(84)
  den(87) = den(12)*den(86)
  den(88) = den(17)*den(87)
  den(89) = den(19)*den(87)
  den(91) = den(12)*den(90)
  den(92) = den(17)*den(91)
  den(93) = den(19)*den(91)
  den(95) = den(22)*den(94)
  den(96) = den(21)*den(95)
  den(98) = den(21)*den(97)
  den(99) = den(22)*den(98)
  den(100) = den(15)*den(97)
  den(101) = den(22)*den(100)
  den(102) = den(17)*den(97)
  den(103) = den(22)*den(102)
  den(104) = den(19)*den(97)
  den(105) = den(22)*den(104)
  den(106) = den(22)*den(83)
  den(107) = den(15)*den(106)
  den(108) = den(22)*den(86)
  den(109) = den(17)*den(108)
  den(110) = den(19)*den(108)
  den(111) = den(22)*den(90)
  den(112) = den(17)*den(111)
  den(113) = den(19)*den(111)
  den(114) = den(13)*den(94)
  den(115) = den(21)*den(114)
  den(116) = den(21)*den(74)
  den(117) = den(13)*den(116)
  den(118) = den(8)*den(74)
  den(119) = den(13)*den(118)
  den(120) = den(13)*den(64)
  den(121) = den(8)*den(120)
  den(122) = den(4)*den(94)
  den(123) = den(21)*den(122)
  den(124) = den(21)*den(49)
  den(125) = den(4)*den(124)
  den(126) = den(3)*den(15)
  den(127) = den(2)*den(17)
  den(128) = den(2)*den(19)
  den(129) = den(1)*den(17)
  den(130) = den(1)*den(19)
  den(131) = den(3)*den(30)
  den(132) = den(3)*den(31)
  den(133) = den(3)*den(43)
  den(134) = den(2)*den(41)
  den(135) = den(3)*den(45)
  den(136) = den(1)*den(41)
  den(137) = den(3)*den(58)
  den(138) = den(2)*den(56)
  den(139) = den(3)*den(60)
  den(140) = den(1)*den(56)
  den(141) = den(15)*den(87)
  den(142) = den(17)*den(84)
  den(143) = den(19)*den(84)
  den(144) = den(15)*den(91)
  den(145) = den(15)*den(108)
  den(146) = den(17)*den(106)
  den(147) = den(19)*den(106)
  den(148) = den(15)*den(111)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppvvv_ew_bbxawwx_1_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for bottom anti-bottom gamma W- W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppvvv_ew_bbxawwx_1, only: &
    & external_perm_ppvvv_ew_bbxawwx_1, &
    & external_perm_inv_ppvvv_ew_bbxawwx_1, &
    & extcomb_perm_ppvvv_ew_bbxawwx_1, &
    & average_factor_ppvvv_ew_bbxawwx_1, &
    & photonid_ppvvv_ew_bbxawwx_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppvvv_ew_bbxawwx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppvvv_ew_bbxawwx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppvvv_ew_bbxawwx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppvvv_ew_bbxawwx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,72)
  type(Hpolcont) :: M1helarray_ct(2,72)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
!  type(Hpolcont) :: A(72,286)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(286)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,286))
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMB, nMB, 0, nMW, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppvvv_ew_bbxawwx_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMB, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMB, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMW, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMW, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_WWV_V(ntry, ex4(:), ex5(:), ex3(:), wf18(:,1), n4(:,1), t4x18(:,:,1))
  call vert_QA_Z(gZd,ntry, ex1(:), ex2(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_VV_S(ntry, ex3(:), ex4(:), wf6(:,1), n3(:,4), t3x6(:,:,1))
  call vert_TV_S(ntry, wf4(:,3), 3, ex5(:), 16, wf12(:,1), n3(:,5), t3x12(:,:,1))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,4), n3(:,6), t3x4(:,:,4))
  call vert_TV_S(ntry, wf4(:,4), 3, ex5(:), 16, wf12(:,2), n3(:,7), t3x12(:,:,2))
  call vert_UV_W(ntry, ex4(:), 8, ex3(:), 4, wf6(:,2), n3(:,8), t3x6(:,:,2))
  call vert_SV_V(ntry, wf4(:,3), ex5(:), wf12(:,3), n3(:,9), t3x12(:,:,3))
  call vert_VV_S(ntry, wf4(:,1), ex5(:), wf12(:,4), n3(:,10), t3x12(:,:,4))
  call vert_VV_S(ntry, wf4(:,2), ex5(:), wf12(:,5), n3(:,11), t3x12(:,:,5))
  call vert_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,6), n3(:,12), t3x12(:,:,6))
  call vert_UV_W(ntry, wf4(:,2), 3, ex5(:), 16, wf12(:,7), n3(:,13), t3x12(:,:,7))
  call vert_VV_S(ntry, ex3(:), ex5(:), wf6(:,3), n3(:,14), t3x6(:,:,3))
  call vert_TV_S(ntry, wf4(:,3), 3, ex4(:), 8, wf12(:,8), n3(:,15), t3x12(:,:,8))
  call vert_TV_S(ntry, wf4(:,4), 3, ex4(:), 8, wf12(:,9), n3(:,16), t3x12(:,:,9))
  call vert_UV_W(ntry, ex3(:), 4, ex5(:), 16, wf6(:,4), n3(:,17), t3x6(:,:,4))
  call vert_SV_V(ntry, wf4(:,3), ex4(:), wf12(:,10), n3(:,18), t3x12(:,:,10))
  call vert_VV_S(ntry, wf4(:,1), ex4(:), wf12(:,11), n3(:,19), t3x12(:,:,11))
  call vert_VV_S(ntry, wf4(:,2), ex4(:), wf12(:,12), n3(:,20), t3x12(:,:,12))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,1), 3, wf12(:,13), n3(:,21), t3x12(:,:,13))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,2), 3, wf12(:,14), n3(:,22), t3x12(:,:,14))
  call vert_VQ_A(ntry, ex3(:), ex1(:), wf4(:,5), n3(:,23), t3x4(:,:,5))
  call vert_AW_Q(ntry, ex2(:), ex4(:), wf6(:,5), n3(:,24), t3x6(:,:,5))
  call prop_Q_A(ntry, wf4(:,5), 5, MB, 1_intkind1, wf4(:,6), n2(1))
  call prop_A_Q(ntry, wf6(:,5), 10, MT, 1_intkind1, wf6(:,6), n2(2))
  call vert_WQ_A(ntry, ex5(:), wf4(:,6), wf12(:,15), n3(:,25), t3x12(:,:,15))
  call vert_VV_S(ntry, ex4(:), ex5(:), wf9(:,1), n3(:,26), t3x9(:,:,1))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,6), wf8(:,1), n3(:,27), t3x8(:,:,1))
  call vert_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,2), n3(:,28), t3x9(:,:,2))
  call vert_QA_V(ntry, wf4(:,6), ex2(:), wf8(:,2), n3(:,29), t3x8(:,:,2))
  call vert_QA_Z(gZd,ntry, wf4(:,6), ex2(:), wf8(:,3), n3(:,30), t3x8(:,:,3))
  call vert_WQ_A(ntry, ex5(:), ex1(:), wf6(:,7), n3(:,31), t3x6(:,:,6))
  call vert_AV_Q(ntry, ex2(:), ex3(:), wf4(:,7), n3(:,32), t3x4(:,:,6))
  call prop_Q_A(ntry, wf6(:,7), 17, MT, 1_intkind1, wf6(:,8), n2(3))
  call prop_A_Q(ntry, wf4(:,7), 6, MB, 1_intkind1, wf4(:,8), n2(4))
  call vert_WQ_A(ntry, ex4(:), wf6(:,8), wf18(:,2), n3(:,33), t3x18(:,:,1))
  call vert_AQ_S(gH,ntry, wf4(:,8), ex1(:), wf8(:,4), n3(:,34), t3x8(:,:,4))
  call vert_QA_V(ntry, ex1(:), wf4(:,8), wf8(:,5), n3(:,35), t3x8(:,:,5))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,8), wf8(:,6), n3(:,36), t3x8(:,:,6))
  call vert_VQ_A(ntry, ex3(:), wf6(:,8), wf12(:,16), n3(:,37), t3x12(:,:,16))
  call vert_AQ_S(gPtb,ntry, wf6(:,6), ex1(:), wf12(:,17), n3(:,38), t3x12(:,:,17))
  call vert_QA_W(ntry, ex1(:), wf6(:,6), wf12(:,18), n3(:,39), t3x12(:,:,18))
  call vert_AQ_S(gPbt,ntry, ex2(:), wf6(:,8), wf12(:,19), n3(:,40), t3x12(:,:,19))
  call vert_QA_W(ntry, wf6(:,8), ex2(:), wf12(:,20), n3(:,41), t3x12(:,:,20))
  call counter_WWV_V(EWctWWAA,ntry, ex4(:), ex5(:), ex3(:), wf18(:,3), n4(:,2), t4x18(:,:,2))
  call counter_WWV_V(EWctWWAZ,ntry, ex4(:), ex5(:), ex3(:), wf18(:,4), n4(:,3), t4x18(:,:,3))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,9), n3(:,42), t3x4(:,:,7))
  call counter_QA_V_LR(EWctAbb,ntry, ex1(:), ex2(:), wf4(:,10), n3(:,43), t3x4(:,:,8))
  call counter_QA_Z(gZd,ntry, ex1(:), ex2(:), wf4(:,11), n3(:,44), t3x4(:,:,9))
  call counter_QA_Z(EWctVbb,ntry, ex1(:), ex2(:), wf4(:,12), n3(:,45), t3x4(:,:,10))
  call counter_TV_S(ntry, wf4(:,3), 3, ex5(:), 16, wf12(:,21), n3(:,46), t3x12(:,:,21))
  call counter_TV_S(ntry, wf4(:,4), 3, ex5(:), 16, wf12(:,22), n3(:,47), t3x12(:,:,22))
  call counter_SV_V(ntry, wf4(:,3), ex5(:), wf12(:,23), n3(:,48), t3x12(:,:,23))
  call counter_VV_S(ntry, wf4(:,1), ex5(:), wf12(:,24), n3(:,49), t3x12(:,:,24))
  call counter_VV_S(ntry, wf4(:,2), ex5(:), wf12(:,25), n3(:,50), t3x12(:,:,25))
  call counter_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,26), n3(:,51), t3x12(:,:,26))
  call counter_UV_W(ntry, wf4(:,2), 3, ex5(:), 16, wf12(:,27), n3(:,52), t3x12(:,:,27))
  call counter_TV_S(ntry, wf4(:,3), 3, ex4(:), 8, wf12(:,28), n3(:,53), t3x12(:,:,28))
  call counter_TV_S(ntry, wf4(:,4), 3, ex4(:), 8, wf12(:,29), n3(:,54), t3x12(:,:,29))
  call counter_SV_V(ntry, wf4(:,3), ex4(:), wf12(:,30), n3(:,55), t3x12(:,:,30))
  call counter_VV_S(ntry, wf4(:,1), ex4(:), wf12(:,31), n3(:,56), t3x12(:,:,31))
  call counter_VV_S(ntry, wf4(:,2), ex4(:), wf12(:,32), n3(:,57), t3x12(:,:,32))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,1), 3, wf12(:,33), n3(:,58), t3x12(:,:,33))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,2), 3, wf12(:,34), n3(:,59), t3x12(:,:,34))
  call counter_S_V(EWctXA,ntry, wf4(:,4), 3, wf4(:,13), n2(5))
  call counter_S_V(EWctXZ,ntry, wf4(:,4), 3, wf4(:,14), n2(6))
  call counter_V_V(EWctAA,ntry, wf4(:,1), 3, wf4(:,15), n2(7))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 3, wf4(:,16), n2(8))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 3, wf4(:,17), n2(9))
  call counter_V_V(EWctZZ,ntry, wf4(:,2), 3, wf4(:,18), n2(10))
  call counter_VS_T(ntry, ex3(:), 4, wf4(:,4), 3, wf8(:,7), n3(:,60), t3x8(:,:,7))
  call counter_SV_V(ntry, wf4(:,3), ex3(:), wf8(:,8), n3(:,61), t3x8(:,:,8))
  call counter_VV_S(ntry, wf4(:,1), ex3(:), wf8(:,9), n3(:,62), t3x8(:,:,9))
  call counter_VV_S(ntry, wf4(:,2), ex3(:), wf8(:,10), n3(:,63), t3x8(:,:,10))
  call counter_VV_S(ntry, ex3(:), ex5(:), wf6(:,9), n3(:,64), t3x6(:,:,7))
  call counter_UV_W(ntry, ex3(:), 4, ex5(:), 16, wf6(:,10), n3(:,65), t3x6(:,:,8))
  call counter_VV_S(ntry, ex3(:), ex4(:), wf6(:,11), n3(:,66), t3x6(:,:,9))
  call counter_UV_W(ntry, ex4(:), 8, ex3(:), 4, wf6(:,12), n3(:,67), t3x6(:,:,10))
  call counter_WQ_A(ntry, ex5(:), wf4(:,6), wf12(:,35), n3(:,68), t3x12(:,:,35))
  call counter_VV_S(ntry, ex4(:), ex5(:), wf9(:,3), n3(:,69), t3x9(:,:,3))
  call counter_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,4), n3(:,70), t3x9(:,:,4))
  call counter_WQ_A(ntry, ex4(:), wf6(:,8), wf18(:,5), n3(:,71), t3x18(:,:,2))
  call counter_VQ_A(ntry, ex3(:), wf6(:,8), wf12(:,36), n3(:,72), t3x12(:,:,36))
  call counter_VQ_A_LR(EWctAtt,ntry, ex3(:), wf6(:,8), wf12(:,37), n3(:,73), t3x12(:,:,37))
  call counter_AQ_S(gH,ntry, ex2(:), wf4(:,6), wf8(:,11), n3(:,74), t3x8(:,:,11))
  call counter_AQ_S(EWctHbb,ntry, ex2(:), wf4(:,6), wf8(:,12), n3(:,75), t3x8(:,:,12))
  call counter_QA_V(ntry, wf4(:,6), ex2(:), wf8(:,13), n3(:,76), t3x8(:,:,13))
  call counter_QA_V_LR(EWctAbb,ntry, wf4(:,6), ex2(:), wf8(:,14), n3(:,77), t3x8(:,:,14))
  call counter_QA_Z(gZd,ntry, wf4(:,6), ex2(:), wf8(:,15), n3(:,78), t3x8(:,:,15))
  call counter_QA_Z(EWctVbb,ntry, wf4(:,6), ex2(:), wf8(:,16), n3(:,79), t3x8(:,:,16))
  call counter_AW_Q(ntry, ex2(:), ex4(:), wf6(:,13), n3(:,80), t3x6(:,:,11))
  call prop_A_Q(ntry, wf6(:,13), 10, MT, 1_intkind1, wf6(:,14), n2(11))
  call counter_AQ_S(ctSbt,ntry, ex2(:), wf6(:,8), wf12(:,38), n3(:,81), t3x12(:,:,38))
  call counter_AQ_S(EWctPbt,ntry, ex2(:), wf6(:,8), wf12(:,39), n3(:,82), t3x12(:,:,39))
  call counter_QA_W(ntry, wf6(:,8), ex2(:), wf12(:,40), n3(:,83), t3x12(:,:,40))
  call vert_AQ_S(gPtb,ntry, wf6(:,14), ex1(:), wf12(:,41), n3(:,84), t3x12(:,:,41))
  call vert_QA_W(ntry, ex1(:), wf6(:,14), wf12(:,42), n3(:,85), t3x12(:,:,42))
  call counter_AV_Q(ntry, ex2(:), ex3(:), wf4(:,19), n3(:,86), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,19), 6, MB, 1_intkind1, wf4(:,20), n2(12))
  call counter_AV_Q_LR(EWctAbb,ntry, ex2(:), ex3(:), wf4(:,21), n3(:,87), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,21), 6, MB, 1_intkind1, wf4(:,22), n2(13))
  call vert_AQ_S(gH,ntry, wf4(:,20), ex1(:), wf8(:,17), n3(:,88), t3x8(:,:,17))
  call vert_AQ_S(gH,ntry, wf4(:,22), ex1(:), wf8(:,18), n3(:,89), t3x8(:,:,18))
  call vert_QA_V(ntry, ex1(:), wf4(:,20), wf8(:,19), n3(:,90), t3x8(:,:,19))
  call vert_QA_V(ntry, ex1(:), wf4(:,22), wf8(:,20), n3(:,91), t3x8(:,:,20))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,20), wf8(:,21), n3(:,92), t3x8(:,:,21))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,22), wf8(:,22), n3(:,93), t3x8(:,:,22))
  call counter_AQ_S(gH,ntry, wf4(:,8), ex1(:), wf8(:,23), n3(:,94), t3x8(:,:,23))
  call counter_AQ_S(EWctHbb,ntry, wf4(:,8), ex1(:), wf8(:,24), n3(:,95), t3x8(:,:,24))
  call counter_QA_V(ntry, ex1(:), wf4(:,8), wf8(:,25), n3(:,96), t3x8(:,:,25))
  call counter_QA_V_LR(EWctAbb,ntry, ex1(:), wf4(:,8), wf8(:,26), n3(:,97), t3x8(:,:,26))
  call counter_QA_Z(gZd,ntry, ex1(:), wf4(:,8), wf8(:,27), n3(:,98), t3x8(:,:,27))
  call counter_QA_Z(EWctVbb,ntry, ex1(:), wf4(:,8), wf8(:,28), n3(:,99), t3x8(:,:,28))
  call counter_WQ_A(ntry, ex5(:), ex1(:), wf6(:,15), n3(:,100), t3x6(:,:,12))
  call prop_Q_A(ntry, wf6(:,15), 17, MT, 1_intkind1, wf6(:,16), n2(14))
  call vert_WQ_A(ntry, ex4(:), wf6(:,16), wf18(:,6), n3(:,101), t3x18(:,:,3))
  call counter_AQ_S(ctStb,ntry, wf6(:,6), ex1(:), wf12(:,43), n3(:,102), t3x12(:,:,43))
  call counter_AQ_S(EWctPtb,ntry, wf6(:,6), ex1(:), wf12(:,44), n3(:,103), t3x12(:,:,44))
  call counter_QA_W(ntry, ex1(:), wf6(:,6), wf12(:,45), n3(:,104), t3x12(:,:,45))
  call vert_VQ_A(ntry, ex3(:), wf6(:,16), wf12(:,46), n3(:,105), t3x12(:,:,46))
  call vert_AQ_S(gPbt,ntry, ex2(:), wf6(:,16), wf12(:,47), n3(:,106), t3x12(:,:,47))
  call vert_QA_W(ntry, wf6(:,16), ex2(:), wf12(:,48), n3(:,107), t3x12(:,:,48))
  call counter_VQ_A(ntry, ex3(:), ex1(:), wf4(:,23), n3(:,108), t3x4(:,:,13))
  call prop_Q_A(ntry, wf4(:,23), 5, MB, 1_intkind1, wf4(:,24), n2(15))
  call vert_WQ_A(ntry, ex5(:), wf4(:,24), wf12(:,49), n3(:,109), t3x12(:,:,49))
  call counter_VQ_A_LR(EWctAbb,ntry, ex3(:), ex1(:), wf4(:,25), n3(:,110), t3x4(:,:,14))
  call prop_Q_A(ntry, wf4(:,25), 5, MB, 1_intkind1, wf4(:,26), n2(16))
  call vert_WQ_A(ntry, ex5(:), wf4(:,26), wf12(:,50), n3(:,111), t3x12(:,:,50))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,24), wf8(:,29), n3(:,112), t3x8(:,:,29))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,26), wf8(:,30), n3(:,113), t3x8(:,:,30))
  call vert_QA_V(ntry, wf4(:,24), ex2(:), wf8(:,31), n3(:,114), t3x8(:,:,31))
  call vert_QA_V(ntry, wf4(:,26), ex2(:), wf8(:,32), n3(:,115), t3x8(:,:,32))
  call vert_QA_Z(gZd,ntry, wf4(:,24), ex2(:), wf8(:,33), n3(:,116), t3x8(:,:,33))
  call vert_QA_Z(gZd,ntry, wf4(:,26), ex2(:), wf8(:,34), n3(:,117), t3x8(:,:,34))
  call counter_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,27), n3(:,118), t3x4(:,:,15))
  call vert_TV_S(ntry, wf4(:,27), 3, ex5(:), 16, wf12(:,51), n3(:,119), t3x12(:,:,51))
  call counter_AQ_S(EWctHbb,ntry, ex2(:), ex1(:), wf4(:,28), n3(:,120), t3x4(:,:,16))
  call vert_TV_S(ntry, wf4(:,28), 3, ex5(:), 16, wf12(:,52), n3(:,121), t3x12(:,:,52))
  call counter_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,29), n3(:,122), t3x4(:,:,17))
  call vert_TV_S(ntry, wf4(:,29), 3, ex5(:), 16, wf12(:,53), n3(:,123), t3x12(:,:,53))
  call counter_AQ_S(EWctXbb,ntry, ex2(:), ex1(:), wf4(:,30), n3(:,124), t3x4(:,:,18))
  call vert_TV_S(ntry, wf4(:,30), 3, ex5(:), 16, wf12(:,54), n3(:,125), t3x12(:,:,54))
  call vert_SV_V(ntry, wf4(:,27), ex5(:), wf12(:,55), n3(:,126), t3x12(:,:,55))
  call vert_SV_V(ntry, wf4(:,28), ex5(:), wf12(:,56), n3(:,127), t3x12(:,:,56))
  call vert_VV_S(ntry, wf4(:,9), ex5(:), wf12(:,57), n3(:,128), t3x12(:,:,57))
  call vert_VV_S(ntry, wf4(:,10), ex5(:), wf12(:,58), n3(:,129), t3x12(:,:,58))
  call vert_VV_S(ntry, wf4(:,11), ex5(:), wf12(:,59), n3(:,130), t3x12(:,:,59))
  call vert_VV_S(ntry, wf4(:,12), ex5(:), wf12(:,60), n3(:,131), t3x12(:,:,60))
  call vert_UV_W(ntry, wf4(:,9), 3, ex5(:), 16, wf12(:,61), n3(:,132), t3x12(:,:,61))
  call vert_UV_W(ntry, wf4(:,10), 3, ex5(:), 16, wf12(:,62), n3(:,133), t3x12(:,:,62))
  call vert_UV_W(ntry, wf4(:,11), 3, ex5(:), 16, wf12(:,63), n3(:,134), t3x12(:,:,63))
  call vert_UV_W(ntry, wf4(:,12), 3, ex5(:), 16, wf12(:,64), n3(:,135), t3x12(:,:,64))
  call vert_TV_S(ntry, wf4(:,27), 3, ex4(:), 8, wf12(:,65), n3(:,136), t3x12(:,:,65))
  call vert_TV_S(ntry, wf4(:,28), 3, ex4(:), 8, wf12(:,66), n3(:,137), t3x12(:,:,66))
  call vert_TV_S(ntry, wf4(:,29), 3, ex4(:), 8, wf12(:,67), n3(:,138), t3x12(:,:,67))
  call vert_TV_S(ntry, wf4(:,30), 3, ex4(:), 8, wf12(:,68), n3(:,139), t3x12(:,:,68))
  call vert_SV_V(ntry, wf4(:,27), ex4(:), wf12(:,69), n3(:,140), t3x12(:,:,69))
  call vert_SV_V(ntry, wf4(:,28), ex4(:), wf12(:,70), n3(:,141), t3x12(:,:,70))
  call vert_VV_S(ntry, wf4(:,9), ex4(:), wf12(:,71), n3(:,142), t3x12(:,:,71))
  call vert_VV_S(ntry, wf4(:,10), ex4(:), wf12(:,72), n3(:,143), t3x12(:,:,72))
  call vert_VV_S(ntry, wf4(:,11), ex4(:), wf12(:,73), n3(:,144), t3x12(:,:,73))
  call vert_VV_S(ntry, wf4(:,12), ex4(:), wf12(:,74), n3(:,145), t3x12(:,:,74))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,9), 3, wf12(:,75), n3(:,146), t3x12(:,:,75))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,10), 3, wf12(:,76), n3(:,147), t3x12(:,:,76))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,11), 3, wf12(:,77), n3(:,148), t3x12(:,:,77))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,12), 3, wf12(:,78), n3(:,149), t3x12(:,:,78))
  call vert_VS_T(ntry, ex5(:), 16, wf6(:,1), 12, wf18(:,7), n3(:,150), t3x18(:,:,4))
  call counter_S_S(EWctHH,ntry, wf4(:,3), 3, wf4(:,31), n2(17))
  call counter_S_S(EWctXX,ntry, wf4(:,4), 3, wf4(:,32), n2(18))
  call vert_VV_S(ntry, wf6(:,2), ex5(:), wf18(:,8), n3(:,151), t3x18(:,:,5))
  call vert_SV_V(ntry, wf6(:,1), ex5(:), wf18(:,9), n3(:,152), t3x18(:,:,6))
  call vert_UV_W(ntry, ex5(:), 16, wf6(:,2), 12, wf18(:,10), n3(:,153), t3x18(:,:,7))
  call counter_V_S(EWctXA,ntry, wf4(:,1), 3, wf4(:,33), n2(19))
  call counter_V_S(EWctXZ,ntry, wf4(:,2), 3, wf4(:,34), n2(20))
  call counter_S_S(EWctPP,ntry, wf6(:,1), 12, wf6(:,17), n2(21))
  call counter_S_V(EWctPW,ntry, wf6(:,1), 12, wf6(:,18), n2(22))
  call counter_V_S(EWctPW,ntry, wf6(:,2), 12, wf6(:,19), n2(23))
  call counter_V_V(EWctWW,ntry, wf6(:,2), 12, wf6(:,20), n2(24))
  call vert_VS_T(ntry, ex4(:), 8, wf6(:,3), 20, wf18(:,11), n3(:,154), t3x18(:,:,8))
  call vert_VV_S(ntry, ex4(:), wf6(:,4), wf18(:,12), n3(:,155), t3x18(:,:,9))
  call vert_SV_V(ntry, wf6(:,3), ex4(:), wf18(:,13), n3(:,156), t3x18(:,:,10))
  call vert_UV_W(ntry, wf6(:,4), 20, ex4(:), 8, wf18(:,14), n3(:,157), t3x18(:,:,11))
  call counter_S_S(EWctPP,ntry, wf6(:,3), 20, wf6(:,21), n2(25))
  call counter_S_V(EWctPW,ntry, wf6(:,3), 20, wf6(:,22), n2(26))
  call counter_V_S(EWctPW,ntry, wf6(:,4), 20, wf6(:,23), n2(27))
  call counter_V_V(EWctWW,ntry, wf6(:,4), 20, wf6(:,24), n2(28))
  call vert_AW_Q(ntry, wf6(:,6), ex5(:), wf18(:,15), n3(:,158), t3x18(:,:,12))
  call counter_Q_A(ctbb,5,ntry, wf4(:,6), 5, wf4(:,35), n2(29))
  call prop_A_Q(ntry, wf18(:,15), 26, MB, 1_intkind1, wf18(:,16), n2(30))
  call counter_Q_A_LR(EWctbb,ntry, wf4(:,6), 5, wf4(:,36), n2(31))
  call counter_A_Q(cttt,6,ntry, wf6(:,6), 10, wf6(:,25), n2(32))
  call prop_Q_A(ntry, wf12(:,15), 21, MT, 1_intkind1, wf12(:,79), n2(33))
  call counter_A_Q_LR(EWcttt,ntry, wf6(:,6), 10, wf6(:,26), n2(34))
  call vert_SA_Q(gH,ntry, wf9(:,1), ex2(:), wf18(:,17), n3(:,159), t3x18(:,:,13))
  call prop_A_Q(ntry, wf18(:,17), 26, MB, 1_intkind1, wf18(:,18), n2(35))
  call vert_AV_Q(ntry, ex2(:), wf9(:,2), wf18(:,19), n3(:,160), t3x18(:,:,14))
  call prop_A_Q(ntry, wf18(:,19), 26, MB, 1_intkind1, wf18(:,20), n2(36))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf9(:,2), wf18(:,21), n3(:,161), t3x18(:,:,15))
  call prop_A_Q(ntry, wf18(:,21), 26, MB, 1_intkind1, wf18(:,22), n2(37))
  call counter_S_S(EWctHH,ntry, wf9(:,1), 24, wf9(:,5), n2(38))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,6), wf8(:,35), n3(:,162), t3x8(:,:,35))
  call counter_V_S(EWctXA,ntry, wf9(:,2), 24, wf9(:,6), n2(39))
  call counter_V_S(EWctXZ,ntry, wf9(:,2), 24, wf9(:,7), n2(40))
  call counter_V_V(EWctAA,ntry, wf9(:,2), 24, wf9(:,8), n2(41))
  call counter_V_V(EWctAZ,ntry, wf9(:,2), 24, wf9(:,9), n2(42))
  call counter_V_V(EWctZZ,ntry, wf9(:,2), 24, wf9(:,10), n2(43))
  call vert_AW_Q(ntry, wf4(:,8), ex4(:), wf12(:,80), n3(:,163), t3x12(:,:,79))
  call counter_Q_A(cttt,6,ntry, wf6(:,8), 17, wf6(:,27), n2(44))
  call prop_A_Q(ntry, wf12(:,80), 14, MT, 1_intkind1, wf12(:,81), n2(45))
  call counter_Q_A_LR(EWcttt,ntry, wf6(:,8), 17, wf6(:,28), n2(46))
  call counter_A_Q(ctbb,5,ntry, wf4(:,8), 6, wf4(:,37), n2(47))
  call prop_Q_A(ntry, wf18(:,2), 25, MB, 1_intkind1, wf18(:,23), n2(48))
  call counter_A_Q_LR(EWctbb,ntry, wf4(:,8), 6, wf4(:,38), n2(49))
  call vert_QS_A(gH,ntry, ex1(:), wf9(:,1), wf18(:,24), n3(:,164), t3x18(:,:,16))
  call prop_Q_A(ntry, wf18(:,24), 25, MB, 1_intkind1, wf18(:,25), n2(50))
  call vert_VQ_A(ntry, wf9(:,2), ex1(:), wf18(:,26), n3(:,165), t3x18(:,:,17))
  call prop_Q_A(ntry, wf18(:,26), 25, MB, 1_intkind1, wf18(:,27), n2(51))
  call vert_ZQ_A(gZd,ntry, wf9(:,2), ex1(:), wf18(:,28), n3(:,166), t3x18(:,:,18))
  call prop_Q_A(ntry, wf18(:,28), 25, MB, 1_intkind1, wf18(:,29), n2(52))
  call vert_AQ_S(gX,ntry, wf4(:,8), ex1(:), wf8(:,36), n3(:,167), t3x8(:,:,36))
  call vert_AV_Q(ntry, wf6(:,6), ex3(:), wf12(:,82), n3(:,168), t3x12(:,:,80))
  call prop_A_Q(ntry, wf12(:,82), 14, MT, 1_intkind1, wf12(:,83), n2(53))
  call prop_Q_A(ntry, wf12(:,16), 21, MT, 1_intkind1, wf12(:,84), n2(54))
  call vert_QS_A(gPtb,ntry, ex1(:), wf6(:,3), wf12(:,85), n3(:,169), t3x12(:,:,81))
  call prop_Q_A(ntry, wf12(:,85), 21, MT, 1_intkind1, wf12(:,86), n2(55))
  call vert_WQ_A(ntry, wf6(:,4), ex1(:), wf12(:,87), n3(:,170), t3x12(:,:,82))
  call prop_Q_A(ntry, wf12(:,87), 21, MT, 1_intkind1, wf12(:,88), n2(56))
  call vert_SA_Q(gPbt,ntry, wf6(:,1), ex2(:), wf12(:,89), n3(:,171), t3x12(:,:,83))
  call prop_A_Q(ntry, wf12(:,89), 14, MT, 1_intkind1, wf12(:,90), n2(57))
  call vert_AW_Q(ntry, ex2(:), wf6(:,2), wf12(:,91), n3(:,172), t3x12(:,:,84))
  call prop_A_Q(ntry, wf12(:,91), 14, MT, 1_intkind1, wf12(:,92), n2(58))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf6)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf9)
  call init_hybrid_wf(wf12)
  call init_hybrid_wf(wf18)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppvvv_ew_bbxawwx_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

#if 1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
  ind_cc_comb = [8,12,9,13,14]
  M0M1_hel_cc(:,:,:)%j = 0
  M2ctcc = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 3
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,1), wf18(:,1), A(:,1), n3(:,173), t3x72(:,:,1), nhel, den(1))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,2), A(:,2), n3(:,174), t3x72(:,:,2), nhel, den(2))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,1), A(:,3), n3(:,175), t3x72(:,:,3), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,2), A(:,4), n3(:,176), t3x72(:,:,4), nhel, den(6))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,3), A(:,5), n3(:,177), t3x72(:,:,5), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,4), A(:,6), n3(:,178), t3x72(:,:,6), nhel, den(7))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,5), A(:,7), n3(:,179), t3x72(:,:,7), nhel, den(6))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,6), A(:,8), n3(:,180), t3x72(:,:,8), nhel, den(7))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,7), A(:,9), n3(:,181), t3x72(:,:,9), nhel, den(6))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,8), A(:,10), n3(:,182), t3x72(:,:,10), nhel, den(9))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,9), A(:,11), n3(:,183), t3x72(:,:,11), nhel, den(10))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,10), A(:,12), n3(:,184), t3x72(:,:,12), nhel, den(9))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,11), A(:,13), n3(:,185), t3x72(:,:,13), nhel, den(11))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,12), A(:,14), n3(:,186), t3x72(:,:,14), nhel, den(10))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,13), A(:,15), n3(:,187), t3x72(:,:,15), nhel, den(11))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,14), A(:,16), n3(:,188), t3x72(:,:,16), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,15), A(:,17), n3(:,189), t3x72(:,:,17), nhel, den(14))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,1), A(:,18), n3(:,190), t3x72(:,:,18), nhel, den(16))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,2), A(:,19), n3(:,191), t3x72(:,:,19), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,3), A(:,20), n3(:,192), t3x72(:,:,20), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,8), wf18(:,2), A(:,21), n3(:,193), t3x72(:,:,21), nhel, den(23))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,4), A(:,22), n3(:,194), t3x72(:,:,22), nhel, den(24))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,5), A(:,23), n3(:,195), t3x72(:,:,23), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,6), A(:,24), n3(:,196), t3x72(:,:,24), nhel, den(26))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,16), A(:,25), n3(:,197), t3x72(:,:,25), nhel, den(27))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,17), A(:,26), n3(:,198), t3x72(:,:,26), nhel, den(28))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,18), A(:,27), n3(:,199), t3x72(:,:,27), nhel, den(28))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,19), A(:,28), n3(:,200), t3x72(:,:,28), nhel, den(29))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,20), A(:,29), n3(:,201), t3x72(:,:,29), nhel, den(29))

    call Hcont_VV(nsync, wf4(:,1), wf18(:,3), A(:,30), n3(:,202), t3x72(:,:,30), nhel, den(1))
    call Hcont_VV(nsync, wf4(:,2), wf18(:,4), A(:,31), n3(:,203), t3x72(:,:,31), nhel, den(2))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,9), A(:,32), n3(:,204), t3x72(:,:,32), nhel, den(30))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,10), A(:,33), n3(:,205), t3x72(:,:,33), nhel, den(30))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,11), A(:,34), n3(:,206), t3x72(:,:,34), nhel, den(31))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,12), A(:,35), n3(:,207), t3x72(:,:,35), nhel, den(31))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,21), A(:,36), n3(:,208), t3x72(:,:,36), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,22), A(:,37), n3(:,209), t3x72(:,:,37), nhel, den(6))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,23), A(:,38), n3(:,210), t3x72(:,:,38), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,24), A(:,39), n3(:,211), t3x72(:,:,39), nhel, den(7))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,25), A(:,40), n3(:,212), t3x72(:,:,40), nhel, den(6))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,26), A(:,41), n3(:,213), t3x72(:,:,41), nhel, den(7))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,27), A(:,42), n3(:,214), t3x72(:,:,42), nhel, den(6))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,28), A(:,43), n3(:,215), t3x72(:,:,43), nhel, den(9))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,29), A(:,44), n3(:,216), t3x72(:,:,44), nhel, den(10))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,30), A(:,45), n3(:,217), t3x72(:,:,45), nhel, den(9))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,31), A(:,46), n3(:,218), t3x72(:,:,46), nhel, den(11))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,32), A(:,47), n3(:,219), t3x72(:,:,47), nhel, den(10))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,33), A(:,48), n3(:,220), t3x72(:,:,48), nhel, den(11))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,34), A(:,49), n3(:,221), t3x72(:,:,49), nhel, den(10))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,13), A(:,50), n3(:,222), t3x72(:,:,50), nhel, den(32))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,14), A(:,51), n3(:,223), t3x72(:,:,51), nhel, den(33))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,15), A(:,52), n3(:,224), t3x72(:,:,52), nhel, den(34))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,16), A(:,53), n3(:,225), t3x72(:,:,53), nhel, den(35))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,17), A(:,54), n3(:,226), t3x72(:,:,54), nhel, den(32))
    call Hcont_VV(nsync, wf18(:,1), wf4(:,18), A(:,55), n3(:,227), t3x72(:,:,55), nhel, den(33))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,7), A(:,56), n3(:,228), t3x72(:,:,56), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,8), A(:,57), n3(:,229), t3x72(:,:,57), nhel, den(37))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,8), A(:,58), n3(:,230), t3x72(:,:,58), nhel, den(38))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,9), A(:,59), n3(:,231), t3x72(:,:,59), nhel, den(39))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,10), A(:,60), n3(:,232), t3x72(:,:,60), nhel, den(36))
    call Hcont_SS(nsync, wf12(:,8), wf6(:,9), A(:,61), n3(:,233), t3x72(:,:,61), nhel, den(9))
    call Hcont_SS(nsync, wf12(:,9), wf6(:,9), A(:,62), n3(:,234), t3x72(:,:,62), nhel, den(10))
    call Hcont_VV(nsync, wf12(:,10), wf6(:,10), A(:,63), n3(:,235), t3x72(:,:,63), nhel, den(9))
    call Hcont_SS(nsync, wf12(:,11), wf6(:,9), A(:,64), n3(:,236), t3x72(:,:,64), nhel, den(11))
    call Hcont_SS(nsync, wf12(:,12), wf6(:,9), A(:,65), n3(:,237), t3x72(:,:,65), nhel, den(10))
    call Hcont_VV(nsync, wf12(:,13), wf6(:,10), A(:,66), n3(:,238), t3x72(:,:,66), nhel, den(11))
    call Hcont_VV(nsync, wf12(:,14), wf6(:,10), A(:,67), n3(:,239), t3x72(:,:,67), nhel, den(10))
    call Hcont_SS(nsync, wf12(:,1), wf6(:,11), A(:,68), n3(:,240), t3x72(:,:,68), nhel, den(5))
    call Hcont_SS(nsync, wf12(:,2), wf6(:,11), A(:,69), n3(:,241), t3x72(:,:,69), nhel, den(6))
    call Hcont_VV(nsync, wf12(:,3), wf6(:,12), A(:,70), n3(:,242), t3x72(:,:,70), nhel, den(5))
    call Hcont_SS(nsync, wf12(:,4), wf6(:,11), A(:,71), n3(:,243), t3x72(:,:,71), nhel, den(7))
    call Hcont_SS(nsync, wf12(:,5), wf6(:,11), A(:,72), n3(:,244), t3x72(:,:,72), nhel, den(6))
    call Hcont_VV(nsync, wf12(:,6), wf6(:,12), A(:,73), n3(:,245), t3x72(:,:,73), nhel, den(7))
    call Hcont_VV(nsync, wf12(:,7), wf6(:,12), A(:,74), n3(:,246), t3x72(:,:,74), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,35), A(:,75), n3(:,247), t3x72(:,:,75), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,35), A(:,76), n3(:,248), t3x72(:,:,76), nhel, den(14))
    call Hcont_SS(nsync, wf8(:,1), wf9(:,3), A(:,77), n3(:,249), t3x72(:,:,77), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,4), A(:,78), n3(:,250), t3x72(:,:,78), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,4), A(:,79), n3(:,251), t3x72(:,:,79), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,8), wf18(:,5), A(:,80), n3(:,252), t3x72(:,:,80), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,8), wf18(:,5), A(:,81), n3(:,253), t3x72(:,:,81), nhel, den(23))
    call Hcont_SS(nsync, wf8(:,4), wf9(:,3), A(:,82), n3(:,254), t3x72(:,:,82), nhel, den(24))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,4), A(:,83), n3(:,255), t3x72(:,:,83), nhel, den(25))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,4), A(:,84), n3(:,256), t3x72(:,:,84), nhel, den(26))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,36), A(:,85), n3(:,257), t3x72(:,:,85), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,37), A(:,86), n3(:,258), t3x72(:,:,86), nhel, den(27))
    call Hcont_SS(nsync, wf12(:,17), wf6(:,9), A(:,87), n3(:,259), t3x72(:,:,87), nhel, den(28))
    call Hcont_VV(nsync, wf12(:,18), wf6(:,10), A(:,88), n3(:,260), t3x72(:,:,88), nhel, den(28))
    call Hcont_SS(nsync, wf12(:,19), wf6(:,11), A(:,89), n3(:,261), t3x72(:,:,89), nhel, den(29))
    call Hcont_VV(nsync, wf12(:,20), wf6(:,12), A(:,90), n3(:,262), t3x72(:,:,90), nhel, den(29))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,11), A(:,91), n3(:,263), t3x72(:,:,91), nhel, den(16))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,12), A(:,92), n3(:,264), t3x72(:,:,92), nhel, den(16))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,13), A(:,93), n3(:,265), t3x72(:,:,93), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,14), A(:,94), n3(:,266), t3x72(:,:,94), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,15), A(:,95), n3(:,267), t3x72(:,:,95), nhel, den(20))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,16), A(:,96), n3(:,268), t3x72(:,:,96), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,15), wf6(:,14), A(:,97), n3(:,269), t3x72(:,:,97), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,15), wf6(:,14), A(:,98), n3(:,270), t3x72(:,:,98), nhel, den(14))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,38), A(:,99), n3(:,271), t3x72(:,:,99), nhel, den(29))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,39), A(:,100), n3(:,272), t3x72(:,:,100), nhel, den(29))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,40), A(:,101), n3(:,273), t3x72(:,:,101), nhel, den(29))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,40), A(:,102), n3(:,274), t3x72(:,:,102), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,14), A(:,103), n3(:,275), t3x72(:,:,103), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,14), A(:,104), n3(:,276), t3x72(:,:,104), nhel, den(27))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,41), A(:,105), n3(:,277), t3x72(:,:,105), nhel, den(28))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,41), A(:,106), n3(:,278), t3x72(:,:,106), nhel, den(28))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,42), A(:,107), n3(:,279), t3x72(:,:,107), nhel, den(28))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,42), A(:,108), n3(:,280), t3x72(:,:,108), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,2), wf4(:,20), A(:,109), n3(:,281), t3x72(:,:,109), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,2), wf4(:,22), A(:,110), n3(:,282), t3x72(:,:,110), nhel, den(23))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,17), A(:,111), n3(:,283), t3x72(:,:,111), nhel, den(24))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,18), A(:,112), n3(:,284), t3x72(:,:,112), nhel, den(24))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,19), A(:,113), n3(:,285), t3x72(:,:,113), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,20), A(:,114), n3(:,286), t3x72(:,:,114), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,21), A(:,115), n3(:,287), t3x72(:,:,115), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,22), A(:,116), n3(:,288), t3x72(:,:,116), nhel, den(26))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,23), A(:,117), n3(:,289), t3x72(:,:,117), nhel, den(24))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,24), A(:,118), n3(:,290), t3x72(:,:,118), nhel, den(24))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,25), A(:,119), n3(:,291), t3x72(:,:,119), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,26), A(:,120), n3(:,292), t3x72(:,:,120), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,27), A(:,121), n3(:,293), t3x72(:,:,121), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,28), A(:,122), n3(:,294), t3x72(:,:,122), nhel, den(26))
    call Hcont_QA(nsync, wf4(:,8), wf18(:,6), A(:,123), n3(:,295), t3x72(:,:,123), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,8), wf18(:,6), A(:,124), n3(:,296), t3x72(:,:,124), nhel, den(23))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,43), A(:,125), n3(:,297), t3x72(:,:,125), nhel, den(28))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,44), A(:,126), n3(:,298), t3x72(:,:,126), nhel, den(28))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,45), A(:,127), n3(:,299), t3x72(:,:,127), nhel, den(28))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,45), A(:,128), n3(:,300), t3x72(:,:,128), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,46), A(:,129), n3(:,301), t3x72(:,:,129), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,46), A(:,130), n3(:,302), t3x72(:,:,130), nhel, den(27))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,47), A(:,131), n3(:,303), t3x72(:,:,131), nhel, den(29))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,47), A(:,132), n3(:,304), t3x72(:,:,132), nhel, den(29))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,48), A(:,133), n3(:,305), t3x72(:,:,133), nhel, den(29))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,48), A(:,134), n3(:,306), t3x72(:,:,134), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,49), A(:,135), n3(:,307), t3x72(:,:,135), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,6), wf12(:,50), A(:,136), n3(:,308), t3x72(:,:,136), nhel, den(14))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,29), A(:,137), n3(:,309), t3x72(:,:,137), nhel, den(16))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,30), A(:,138), n3(:,310), t3x72(:,:,138), nhel, den(16))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,31), A(:,139), n3(:,311), t3x72(:,:,139), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,32), A(:,140), n3(:,312), t3x72(:,:,140), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,33), A(:,141), n3(:,313), t3x72(:,:,141), nhel, den(20))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,34), A(:,142), n3(:,314), t3x72(:,:,142), nhel, den(20))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,51), A(:,143), n3(:,315), t3x72(:,:,143), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,52), A(:,144), n3(:,316), t3x72(:,:,144), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,53), A(:,145), n3(:,317), t3x72(:,:,145), nhel, den(6))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,54), A(:,146), n3(:,318), t3x72(:,:,146), nhel, den(6))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,55), A(:,147), n3(:,319), t3x72(:,:,147), nhel, den(5))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,56), A(:,148), n3(:,320), t3x72(:,:,148), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,57), A(:,149), n3(:,321), t3x72(:,:,149), nhel, den(7))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,58), A(:,150), n3(:,322), t3x72(:,:,150), nhel, den(7))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,59), A(:,151), n3(:,323), t3x72(:,:,151), nhel, den(6))
    call Hcont_SS(nsync, wf6(:,1), wf12(:,60), A(:,152), n3(:,324), t3x72(:,:,152), nhel, den(6))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,61), A(:,153), n3(:,325), t3x72(:,:,153), nhel, den(7))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,62), A(:,154), n3(:,326), t3x72(:,:,154), nhel, den(7))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,63), A(:,155), n3(:,327), t3x72(:,:,155), nhel, den(6))
    call Hcont_VV(nsync, wf6(:,2), wf12(:,64), A(:,156), n3(:,328), t3x72(:,:,156), nhel, den(6))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,65), A(:,157), n3(:,329), t3x72(:,:,157), nhel, den(9))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,66), A(:,158), n3(:,330), t3x72(:,:,158), nhel, den(9))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,67), A(:,159), n3(:,331), t3x72(:,:,159), nhel, den(10))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,68), A(:,160), n3(:,332), t3x72(:,:,160), nhel, den(10))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,69), A(:,161), n3(:,333), t3x72(:,:,161), nhel, den(9))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,70), A(:,162), n3(:,334), t3x72(:,:,162), nhel, den(9))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,71), A(:,163), n3(:,335), t3x72(:,:,163), nhel, den(11))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,72), A(:,164), n3(:,336), t3x72(:,:,164), nhel, den(11))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,73), A(:,165), n3(:,337), t3x72(:,:,165), nhel, den(10))
    call Hcont_SS(nsync, wf6(:,3), wf12(:,74), A(:,166), n3(:,338), t3x72(:,:,166), nhel, den(10))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,75), A(:,167), n3(:,339), t3x72(:,:,167), nhel, den(11))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,76), A(:,168), n3(:,340), t3x72(:,:,168), nhel, den(11))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,77), A(:,169), n3(:,341), t3x72(:,:,169), nhel, den(10))
    call Hcont_VV(nsync, wf6(:,4), wf12(:,78), A(:,170), n3(:,342), t3x72(:,:,170), nhel, den(10))
    call Hcont_SS(nsync, wf18(:,7), wf4(:,31), A(:,171), n3(:,343), t3x72(:,:,171), nhel, den(42))
    call Hcont_SS(nsync, wf18(:,7), wf4(:,32), A(:,172), n3(:,344), t3x72(:,:,172), nhel, den(44))
    call Hcont_SS(nsync, wf4(:,31), wf18(:,8), A(:,173), n3(:,345), t3x72(:,:,173), nhel, den(42))
    call Hcont_VV(nsync, wf4(:,13), wf18(:,9), A(:,174), n3(:,346), t3x72(:,:,174), nhel, den(46))
    call Hcont_VV(nsync, wf4(:,14), wf18(:,9), A(:,175), n3(:,347), t3x72(:,:,175), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,13), wf18(:,10), A(:,176), n3(:,348), t3x72(:,:,176), nhel, den(46))
    call Hcont_VV(nsync, wf4(:,14), wf18(:,10), A(:,177), n3(:,349), t3x72(:,:,177), nhel, den(44))
    call Hcont_SS(nsync, wf18(:,7), wf4(:,33), A(:,178), n3(:,350), t3x72(:,:,178), nhel, den(47))
    call Hcont_SS(nsync, wf18(:,7), wf4(:,34), A(:,179), n3(:,351), t3x72(:,:,179), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,15), wf18(:,9), A(:,180), n3(:,352), t3x72(:,:,180), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,16), wf18(:,9), A(:,181), n3(:,353), t3x72(:,:,181), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,17), wf18(:,9), A(:,182), n3(:,354), t3x72(:,:,182), nhel, den(46))
    call Hcont_VV(nsync, wf4(:,18), wf18(:,9), A(:,183), n3(:,355), t3x72(:,:,183), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,15), wf18(:,10), A(:,184), n3(:,356), t3x72(:,:,184), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,16), wf18(:,10), A(:,185), n3(:,357), t3x72(:,:,185), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,17), wf18(:,10), A(:,186), n3(:,358), t3x72(:,:,186), nhel, den(46))
    call Hcont_VV(nsync, wf4(:,18), wf18(:,10), A(:,187), n3(:,359), t3x72(:,:,187), nhel, den(44))
    call Hcont_SS(nsync, wf12(:,1), wf6(:,17), A(:,188), n3(:,360), t3x72(:,:,188), nhel, den(51))
    call Hcont_SS(nsync, wf12(:,2), wf6(:,17), A(:,189), n3(:,361), t3x72(:,:,189), nhel, den(53))
    call Hcont_SS(nsync, wf12(:,4), wf6(:,17), A(:,190), n3(:,362), t3x72(:,:,190), nhel, den(55))
    call Hcont_SS(nsync, wf12(:,5), wf6(:,17), A(:,191), n3(:,363), t3x72(:,:,191), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,3), wf6(:,18), A(:,192), n3(:,364), t3x72(:,:,192), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,6), wf6(:,18), A(:,193), n3(:,365), t3x72(:,:,193), nhel, den(55))
    call Hcont_VV(nsync, wf12(:,7), wf6(:,18), A(:,194), n3(:,366), t3x72(:,:,194), nhel, den(53))
    call Hcont_SS(nsync, wf12(:,1), wf6(:,19), A(:,195), n3(:,367), t3x72(:,:,195), nhel, den(51))
    call Hcont_SS(nsync, wf12(:,2), wf6(:,19), A(:,196), n3(:,368), t3x72(:,:,196), nhel, den(53))
    call Hcont_SS(nsync, wf12(:,4), wf6(:,19), A(:,197), n3(:,369), t3x72(:,:,197), nhel, den(55))
    call Hcont_SS(nsync, wf12(:,5), wf6(:,19), A(:,198), n3(:,370), t3x72(:,:,198), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,3), wf6(:,20), A(:,199), n3(:,371), t3x72(:,:,199), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,6), wf6(:,20), A(:,200), n3(:,372), t3x72(:,:,200), nhel, den(55))
    call Hcont_VV(nsync, wf12(:,7), wf6(:,20), A(:,201), n3(:,373), t3x72(:,:,201), nhel, den(53))
    call Hcont_SS(nsync, wf4(:,31), wf18(:,11), A(:,202), n3(:,374), t3x72(:,:,202), nhel, den(57))
    call Hcont_SS(nsync, wf4(:,32), wf18(:,11), A(:,203), n3(:,375), t3x72(:,:,203), nhel, den(59))
    call Hcont_SS(nsync, wf4(:,31), wf18(:,12), A(:,204), n3(:,376), t3x72(:,:,204), nhel, den(57))
    call Hcont_VV(nsync, wf4(:,13), wf18(:,13), A(:,205), n3(:,377), t3x72(:,:,205), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,14), wf18(:,13), A(:,206), n3(:,378), t3x72(:,:,206), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,13), wf18(:,14), A(:,207), n3(:,379), t3x72(:,:,207), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,14), wf18(:,14), A(:,208), n3(:,380), t3x72(:,:,208), nhel, den(59))
    call Hcont_SS(nsync, wf4(:,33), wf18(:,11), A(:,209), n3(:,381), t3x72(:,:,209), nhel, den(62))
    call Hcont_SS(nsync, wf4(:,34), wf18(:,11), A(:,210), n3(:,382), t3x72(:,:,210), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,15), wf18(:,13), A(:,211), n3(:,383), t3x72(:,:,211), nhel, den(63))
    call Hcont_VV(nsync, wf4(:,16), wf18(:,13), A(:,212), n3(:,384), t3x72(:,:,212), nhel, den(62))
    call Hcont_VV(nsync, wf4(:,17), wf18(:,13), A(:,213), n3(:,385), t3x72(:,:,213), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,18), wf18(:,13), A(:,214), n3(:,386), t3x72(:,:,214), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,15), wf18(:,14), A(:,215), n3(:,387), t3x72(:,:,215), nhel, den(63))
    call Hcont_VV(nsync, wf4(:,16), wf18(:,14), A(:,216), n3(:,388), t3x72(:,:,216), nhel, den(62))
    call Hcont_VV(nsync, wf4(:,17), wf18(:,14), A(:,217), n3(:,389), t3x72(:,:,217), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,18), wf18(:,14), A(:,218), n3(:,390), t3x72(:,:,218), nhel, den(59))
    call Hcont_SS(nsync, wf12(:,8), wf6(:,21), A(:,219), n3(:,391), t3x72(:,:,219), nhel, den(66))
    call Hcont_SS(nsync, wf12(:,9), wf6(:,21), A(:,220), n3(:,392), t3x72(:,:,220), nhel, den(68))
    call Hcont_SS(nsync, wf12(:,11), wf6(:,21), A(:,221), n3(:,393), t3x72(:,:,221), nhel, den(70))
    call Hcont_SS(nsync, wf12(:,12), wf6(:,21), A(:,222), n3(:,394), t3x72(:,:,222), nhel, den(68))
    call Hcont_VV(nsync, wf12(:,10), wf6(:,22), A(:,223), n3(:,395), t3x72(:,:,223), nhel, den(66))
    call Hcont_VV(nsync, wf12(:,13), wf6(:,22), A(:,224), n3(:,396), t3x72(:,:,224), nhel, den(70))
    call Hcont_VV(nsync, wf12(:,14), wf6(:,22), A(:,225), n3(:,397), t3x72(:,:,225), nhel, den(68))
    call Hcont_SS(nsync, wf12(:,8), wf6(:,23), A(:,226), n3(:,398), t3x72(:,:,226), nhel, den(66))
    call Hcont_SS(nsync, wf12(:,9), wf6(:,23), A(:,227), n3(:,399), t3x72(:,:,227), nhel, den(68))
    call Hcont_SS(nsync, wf12(:,11), wf6(:,23), A(:,228), n3(:,400), t3x72(:,:,228), nhel, den(70))
    call Hcont_SS(nsync, wf12(:,12), wf6(:,23), A(:,229), n3(:,401), t3x72(:,:,229), nhel, den(68))
    call Hcont_VV(nsync, wf12(:,10), wf6(:,24), A(:,230), n3(:,402), t3x72(:,:,230), nhel, den(66))
    call Hcont_VV(nsync, wf12(:,13), wf6(:,24), A(:,231), n3(:,403), t3x72(:,:,231), nhel, den(70))
    call Hcont_VV(nsync, wf12(:,14), wf6(:,24), A(:,232), n3(:,404), t3x72(:,:,232), nhel, den(68))
    call Hcont_QA(nsync, wf4(:,35), wf18(:,16), A(:,233), n3(:,405), t3x72(:,:,233), nhel, den(73))
    call Hcont_QA(nsync, wf18(:,16), wf4(:,36), A(:,234), n3(:,406), t3x72(:,:,234), nhel, den(73))
    call Hcont_QA(nsync, wf6(:,25), wf12(:,79), A(:,235), n3(:,407), t3x72(:,:,235), nhel, den(76))
    call Hcont_QA(nsync, wf12(:,79), wf6(:,26), A(:,236), n3(:,408), t3x72(:,:,236), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,35), wf18(:,18), A(:,237), n3(:,409), t3x72(:,:,237), nhel, den(78))
    call Hcont_QA(nsync, wf4(:,36), wf18(:,18), A(:,238), n3(:,410), t3x72(:,:,238), nhel, den(78))
    call Hcont_QA(nsync, wf4(:,35), wf18(:,20), A(:,239), n3(:,411), t3x72(:,:,239), nhel, den(80))
    call Hcont_QA(nsync, wf4(:,36), wf18(:,20), A(:,240), n3(:,412), t3x72(:,:,240), nhel, den(80))
    call Hcont_QA(nsync, wf4(:,35), wf18(:,22), A(:,241), n3(:,413), t3x72(:,:,241), nhel, den(82))
    call Hcont_QA(nsync, wf4(:,36), wf18(:,22), A(:,242), n3(:,414), t3x72(:,:,242), nhel, den(82))
    call Hcont_SS(nsync, wf8(:,1), wf9(:,5), A(:,243), n3(:,415), t3x72(:,:,243), nhel, den(85))
    call Hcont_SS(nsync, wf8(:,35), wf9(:,6), A(:,244), n3(:,416), t3x72(:,:,244), nhel, den(88))
    call Hcont_SS(nsync, wf8(:,35), wf9(:,7), A(:,245), n3(:,417), t3x72(:,:,245), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,8), A(:,246), n3(:,418), t3x72(:,:,246), nhel, den(92))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,9), A(:,247), n3(:,419), t3x72(:,:,247), nhel, den(93))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,9), A(:,248), n3(:,420), t3x72(:,:,248), nhel, den(88))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,10), A(:,249), n3(:,421), t3x72(:,:,249), nhel, den(89))
    call Hcont_QA(nsync, wf6(:,27), wf12(:,81), A(:,250), n3(:,422), t3x72(:,:,250), nhel, den(96))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,28), A(:,251), n3(:,423), t3x72(:,:,251), nhel, den(96))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,23), A(:,252), n3(:,424), t3x72(:,:,252), nhel, den(99))
    call Hcont_QA(nsync, wf18(:,23), wf4(:,38), A(:,253), n3(:,425), t3x72(:,:,253), nhel, den(99))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,25), A(:,254), n3(:,426), t3x72(:,:,254), nhel, den(101))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,25), A(:,255), n3(:,427), t3x72(:,:,255), nhel, den(101))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,27), A(:,256), n3(:,428), t3x72(:,:,256), nhel, den(103))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,27), A(:,257), n3(:,429), t3x72(:,:,257), nhel, den(103))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,29), A(:,258), n3(:,430), t3x72(:,:,258), nhel, den(105))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,29), A(:,259), n3(:,431), t3x72(:,:,259), nhel, den(105))
    call Hcont_SS(nsync, wf8(:,4), wf9(:,5), A(:,260), n3(:,432), t3x72(:,:,260), nhel, den(107))
    call Hcont_SS(nsync, wf9(:,6), wf8(:,36), A(:,261), n3(:,433), t3x72(:,:,261), nhel, den(109))
    call Hcont_SS(nsync, wf9(:,7), wf8(:,36), A(:,262), n3(:,434), t3x72(:,:,262), nhel, den(110))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,8), A(:,263), n3(:,435), t3x72(:,:,263), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,9), A(:,264), n3(:,436), t3x72(:,:,264), nhel, den(113))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,9), A(:,265), n3(:,437), t3x72(:,:,265), nhel, den(109))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,10), A(:,266), n3(:,438), t3x72(:,:,266), nhel, den(110))
    call Hcont_QA(nsync, wf6(:,27), wf12(:,83), A(:,267), n3(:,439), t3x72(:,:,267), nhel, den(115))
    call Hcont_QA(nsync, wf6(:,28), wf12(:,83), A(:,268), n3(:,440), t3x72(:,:,268), nhel, den(115))
    call Hcont_QA(nsync, wf6(:,25), wf12(:,84), A(:,269), n3(:,441), t3x72(:,:,269), nhel, den(117))
    call Hcont_QA(nsync, wf6(:,26), wf12(:,84), A(:,270), n3(:,442), t3x72(:,:,270), nhel, den(117))
    call Hcont_QA(nsync, wf6(:,25), wf12(:,86), A(:,271), n3(:,443), t3x72(:,:,271), nhel, den(119))
    call Hcont_QA(nsync, wf6(:,26), wf12(:,86), A(:,272), n3(:,444), t3x72(:,:,272), nhel, den(119))
    call Hcont_QA(nsync, wf6(:,25), wf12(:,88), A(:,273), n3(:,445), t3x72(:,:,273), nhel, den(119))
    call Hcont_QA(nsync, wf6(:,26), wf12(:,88), A(:,274), n3(:,446), t3x72(:,:,274), nhel, den(119))
    call Hcont_SS(nsync, wf12(:,17), wf6(:,21), A(:,275), n3(:,447), t3x72(:,:,275), nhel, den(121))
    call Hcont_SS(nsync, wf12(:,17), wf6(:,23), A(:,276), n3(:,448), t3x72(:,:,276), nhel, den(121))
    call Hcont_VV(nsync, wf12(:,18), wf6(:,22), A(:,277), n3(:,449), t3x72(:,:,277), nhel, den(121))
    call Hcont_VV(nsync, wf12(:,18), wf6(:,24), A(:,278), n3(:,450), t3x72(:,:,278), nhel, den(121))
    call Hcont_QA(nsync, wf6(:,27), wf12(:,90), A(:,279), n3(:,451), t3x72(:,:,279), nhel, den(123))
    call Hcont_QA(nsync, wf6(:,28), wf12(:,90), A(:,280), n3(:,452), t3x72(:,:,280), nhel, den(123))
    call Hcont_QA(nsync, wf6(:,27), wf12(:,92), A(:,281), n3(:,453), t3x72(:,:,281), nhel, den(123))
    call Hcont_QA(nsync, wf6(:,28), wf12(:,92), A(:,282), n3(:,454), t3x72(:,:,282), nhel, den(123))
    call Hcont_SS(nsync, wf12(:,19), wf6(:,17), A(:,283), n3(:,455), t3x72(:,:,283), nhel, den(125))
    call Hcont_SS(nsync, wf12(:,19), wf6(:,19), A(:,284), n3(:,456), t3x72(:,:,284), nhel, den(125))
    call Hcont_VV(nsync, wf12(:,20), wf6(:,18), A(:,285), n3(:,457), t3x72(:,:,285), nhel, den(125))
    call Hcont_VV(nsync, wf12(:,20), wf6(:,20), A(:,286), n3(:,458), t3x72(:,:,286), nhel, den(125))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(2) ! M1helarray(2,72)
  integer :: empty(0), i

  M1(1)%j = (A(j,19)%j+A(j,23)%j)*f(1)+(A(j,1)%j-A(j,8)%j-A(j,15)%j)*f(2)+(A(j,6)%j+A(j,13)%j)*f(17)+(-A(j,17)%j-A(j,21)%j)*f(21) &
       +A(j,25)%j*f(22)+(A(j,26)%j+A(j,27)%j-A(j,28)%j+A(j,29)%j)*f(23)+(A(j,18)%j+A(j,22)%j)*f(42)+(A(j,3)%j+A(j,4)%j-A(j,10)%j &
       +A(j,11)%j)*f(43)+(-A(j,5)%j-A(j,12)%j)*f(44)+(-A(j,20)%j-A(j,24)%j)*f(64)+(-A(j,2)%j+A(j,9)%j+A(j,16)%j)*f(65)+(A(j,7)%j &
       +A(j,14)%j)*f(93)

  M2(1)%j = (-A(j,239)%j-A(j,256)%j)*f(10)+(A(j,93)%j+A(j,113)%j+A(j,119)%j+A(j,139)%j)*f(11)+(A(j,32)%j-A(j,153)%j &
       -A(j,167)%j)*f(12)+(A(j,149)%j+A(j,163)%j)*f(20)+(A(j,233)%j+A(j,235)%j+A(j,250)%j+A(j,252)%j)*f(34)+(-A(j,267)%j &
       -A(j,269)%j)*f(35)+(-A(j,99)%j+A(j,125)%j-A(j,271)%j-A(j,273)%j+A(j,279)%j-A(j,281)%j)*f(36)+(-A(j,109)%j-A(j,135)%j)*f(37) &
       +(-A(j,75)%j-A(j,80)%j-A(j,97)%j-A(j,123)%j)*f(38)+(A(j,103)%j+A(j,129)%j)*f(39)+(A(j,101)%j+A(j,105)%j+A(j,107)%j &
       +A(j,127)%j-A(j,131)%j+A(j,133)%j)*f(40)+A(j,85)%j*f(41)+(-A(j,237)%j-A(j,254)%j)*f(50)+(A(j,91)%j+A(j,117)%j)*f(51) &
       +(A(j,143)%j+A(j,145)%j-A(j,157)%j+A(j,159)%j)*f(52)+(-A(j,147)%j-A(j,161)%j)*f(53)+(A(j,111)%j+A(j,137)%j)*f(54) &
       +(A(j,241)%j+A(j,258)%j)*f(70)+(-A(j,95)%j-A(j,115)%j-A(j,121)%j-A(j,141)%j)*f(71)+(-A(j,34)%j+A(j,155)%j+A(j,169)%j)*f(72) &
       +(A(j,151)%j+A(j,165)%j)*f(96)
  M2(2)%j = (-A(j,240)%j-A(j,246)%j-A(j,257)%j-A(j,263)%j)*f(3)+(-A(j,30)%j-A(j,52)%j+A(j,94)%j+A(j,114)%j+A(j,120)%j+A(j,140)%j &
       +A(j,184)%j+A(j,200)%j+A(j,215)%j+A(j,231)%j-A(j,248)%j-A(j,265)%j)*f(4)+(-A(j,31)%j+A(j,33)%j-A(j,54)%j-A(j,154)%j &
       -A(j,168)%j+A(j,186)%j+A(j,217)%j)*f(5)+(A(j,78)%j+A(j,83)%j)*f(6)+(-A(j,41)%j-A(j,48)%j-A(j,66)%j-A(j,73)%j)*f(7) &
       +(A(j,79)%j+A(j,84)%j)*f(8)+(-A(j,42)%j-A(j,49)%j)*f(9)+(-A(j,193)%j-A(j,197)%j-A(j,224)%j-A(j,228)%j)*f(13)+(-A(j,39)%j &
       -A(j,46)%j-A(j,64)%j-A(j,71)%j)*f(14)+(-A(j,40)%j-A(j,47)%j)*f(15)+(A(j,175)%j+A(j,206)%j)*f(16)+(-A(j,180)%j-A(j,190)%j &
       -A(j,211)%j-A(j,221)%j)*f(18)+(A(j,150)%j+A(j,164)%j-A(j,182)%j-A(j,213)%j)*f(19)+(A(j,234)%j+A(j,236)%j+A(j,251)%j &
       +A(j,253)%j)*f(24)+(-A(j,268)%j-A(j,270)%j)*f(25)+(-A(j,86)%j-A(j,110)%j-A(j,136)%j-A(j,272)%j-A(j,274)%j-A(j,275)%j &
       -A(j,278)%j+A(j,280)%j-A(j,282)%j+A(j,283)%j-A(j,286)%j)*f(26)+(A(j,88)%j+A(j,90)%j)*f(27)+(-A(j,81)%j-A(j,98)%j)*f(28) &
       +A(j,104)%j*f(29)+(A(j,102)%j+A(j,106)%j+A(j,108)%j)*f(30)+(-A(j,76)%j-A(j,124)%j)*f(31)+A(j,130)%j*f(32)+(A(j,128)%j &
       -A(j,132)%j+A(j,134)%j)*f(33)+(-A(j,238)%j-A(j,243)%j-A(j,255)%j-A(j,260)%j)*f(45)+(-A(j,171)%j-A(j,172)%j-A(j,188)%j &
       -A(j,189)%j+A(j,202)%j-A(j,203)%j+A(j,219)%j-A(j,220)%j)*f(46)+(A(j,112)%j+A(j,138)%j+A(j,173)%j+A(j,199)%j+A(j,204)%j &
       +A(j,230)%j)*f(47)+(-A(j,63)%j-A(j,70)%j)*f(48)+A(j,56)%j*f(49)+(-A(j,276)%j+A(j,284)%j)*f(55)+(-A(j,87)%j+A(j,89)%j)*f(56) &
       +(-A(j,195)%j-A(j,196)%j+A(j,226)%j-A(j,227)%j)*f(57)+(-A(j,245)%j-A(j,262)%j)*f(58)+(-A(j,51)%j+A(j,177)%j &
       +A(j,208)%j)*f(59)+A(j,58)%j*f(60)+(A(j,61)%j-A(j,62)%j-A(j,68)%j-A(j,69)%j)*f(61)+(A(j,277)%j+A(j,285)%j)*f(62)+( &
       -A(j,192)%j-A(j,223)%j)*f(63)+(A(j,247)%j+A(j,264)%j)*f(66)+(A(j,53)%j-A(j,96)%j-A(j,122)%j-A(j,185)%j-A(j,216)%j &
       +A(j,242)%j+A(j,249)%j+A(j,259)%j+A(j,266)%j)*f(67)+(-A(j,35)%j+A(j,55)%j-A(j,116)%j-A(j,142)%j+A(j,156)%j+A(j,170)%j &
       -A(j,187)%j-A(j,201)%j-A(j,218)%j-A(j,232)%j)*f(68)+(A(j,67)%j+A(j,74)%j)*f(69)+(-A(j,92)%j-A(j,118)%j)*f(73)+(-A(j,144)%j &
       +A(j,158)%j)*f(74)+(A(j,148)%j+A(j,162)%j)*f(75)+(A(j,146)%j+A(j,160)%j)*f(76)+(-A(j,36)%j+A(j,43)%j)*f(77)+(-A(j,37)%j &
       -A(j,44)%j)*f(78)+(A(j,244)%j+A(j,261)%j)*f(79)+(A(j,50)%j-A(j,176)%j-A(j,207)%j)*f(80)-A(j,57)%j*f(81)+(A(j,77)%j &
       +A(j,82)%j)*f(82)+(-A(j,38)%j-A(j,45)%j)*f(83)+(A(j,178)%j+A(j,209)%j)*f(84)+(A(j,179)%j+A(j,210)%j)*f(85)+(A(j,194)%j &
       +A(j,225)%j)*f(86)+A(j,59)%j*f(87)+A(j,60)%j*f(88)+(A(j,174)%j+A(j,205)%j)*f(89)+(A(j,100)%j+A(j,126)%j)*f(90)+(-A(j,198)%j &
       -A(j,229)%j)*f(91)+(-A(j,65)%j-A(j,72)%j)*f(92)+(-A(j,181)%j-A(j,212)%j)*f(94)+(A(j,152)%j+A(j,166)%j-A(j,183)%j-A(j,191)%j &
       -A(j,214)%j-A(j,222)%j)*f(95)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxawwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxawwx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxawwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxawwx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppvvv_ew_bbxawwx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppvvv_ew_bbxawwx_1_/**/REALKIND
