
module ol_external_ppvvv_ew_bbxawwx_1
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_ppvvv_ew_bbxawwx_1(5) = &
                     [ (dummy_counter, dummy_counter = 1, 5) ]
  integer, save :: external_perm_inv_ppvvv_ew_bbxawwx_1(5) = &
                     [ (dummy_counter, dummy_counter = 1, 5) ]
  integer, save :: extcomb_perm_ppvvv_ew_bbxawwx_1(0:16) = &
                     [ (dummy_counter, dummy_counter = 0, 16) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_ppvvv_ew_bbxawwx_1(5) = &
                     [ 1, 2, 3, 4, 5 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_ppvvv_ew_bbxawwx_1(5) = &
                     [ 6, 6, 2, 3, 3 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_ppvvv_ew_bbxawwx_1 = &
                     36
  integer, save :: channel_number_ppvvv_ew_bbxawwx_1 = -1
  ! external particle helicities
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(5,72) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(72,5)
  integer, save :: POLSEL(5) = 0
  integer, save :: photonid_ppvvv_ew_bbxawwx_1(5) = 0

  contains

  subroutine n_external(n) &
      & bind(c,name="ol_f_n_external_ppvvv_ew_bbxawwx_1")
    ! Return the number of external particles
    implicit none
    integer, intent(out) :: n
    n = 5
  end subroutine n_external


  subroutine n_external_c(n) &
      & bind(c,name="ol_n_external_ppvvv_ew_bbxawwx_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int) :: n
    n = 5
  end subroutine n_external_c


  subroutine set_permutation(perm) &
      & bind(c,name="ol_f_set_permutation_ppvvv_ew_bbxawwx_1")
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_external_decl_/**/DREALKIND, only: n_scatt
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(5)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_ppvvv_ew_bbxawwx_1(5)
    external_perm_ppvvv_ew_bbxawwx_1 = perm
    do i = 1, 5
      external_perm_inv_ppvvv_ew_bbxawwx_1( &
        external_perm_ppvvv_ew_bbxawwx_1(i)) = i
      particle_types_perm_ppvvv_ew_bbxawwx_1(i) = &
        particle_types_ppvvv_ew_bbxawwx_1( &
        external_perm_ppvvv_ew_bbxawwx_1(i))
    end do
    do i = 1, 5
      do j = 1, i
        if (external_perm_ppvvv_ew_bbxawwx_1(i) >= &
          external_perm_ppvvv_ew_bbxawwx_1(j)) then
          ii = external_perm_ppvvv_ew_bbxawwx_1(i)
          jj = external_perm_ppvvv_ew_bbxawwx_1(j)
        else
          ii = external_perm_ppvvv_ew_bbxawwx_1(j)
          jj = external_perm_ppvvv_ew_bbxawwx_1(i)
        end if
        extcomb_perm_ppvvv_ew_bbxawwx_1((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_ppvvv_ew_bbxawwx_1 = 1
    do i = 1, n_scatt
      average_factor_ppvvv_ew_bbxawwx_1 = &
        average_factor_ppvvv_ew_bbxawwx_1 &
        * average_factors_ppvvv_ew_bbxawwx_1( &
        external_perm_ppvvv_ew_bbxawwx_1(i))
    end do
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 5
        average_factor_ppvvv_ew_bbxawwx_1 = &
          average_factor_ppvvv_ew_bbxawwx_1 &
          * factorial(count(particle_types_perm_ppvvv_ew_bbxawwx_1(n_scatt+1:5) == i))
      end do
    end if
  end subroutine set_permutation


  subroutine set_permutation_c(perm) &
      & bind(c,name="ol_set_permutation_ppvvv_ew_bbxawwx_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int), intent(in) :: perm(5)
    integer :: f_perm(5)
    f_perm = perm
    call set_permutation(f_perm)
  end subroutine set_permutation_c


  subroutine get_masses(m_ex) &
      & bind(c,name="ol_f_get_masses_ppvvv_ew_bbxawwx_1")
    ! Return the masses of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: m_ex(5)
    integer        :: i
    real(DREALKIND) :: m_ex_orig(5)
    ! External particle masses for in the identity permutation
    m_ex_orig = [ rMB_unscaled, rMB_unscaled, rZERO, rMW_unscaled, rMW_unscaled ]
    do i = 1, 5
      m_ex(i) = m_ex_orig(external_perm_ppvvv_ew_bbxawwx_1(i))
    end do
  end subroutine get_masses


  subroutine get_masses_c(m_ex) &
      & bind(c,name="ol_get_masses_ppvvv_ew_bbxawwx_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: m_ex(5)
    real(DREALKIND) :: f_m_ex(5)
    call get_masses(f_m_ex)
    m_ex = f_m_ex
  end subroutine get_masses_c


  subroutine rambo(sqrt_s, p_rambo) &
      & bind(c,name="ol_f_rambo_ppvvv_ew_bbxawwx_1")
    use KIND_TYPES, only: DREALKIND
    use ol_kinematics_/**/DREALKIND, only: rambo_generic => rambo
    implicit none
    real(DREALKIND), intent(in) :: sqrt_s
    real(DREALKIND), intent(out) :: p_rambo(0:3,5)
    real(DREALKIND) :: m_ex(5)
    call get_masses(m_ex)
    call rambo_generic(sqrt_s, m_ex, p_rambo)
  end subroutine rambo


  subroutine rambo_c(sqrt_s, p_rambo) &
      & bind(c,name="ol_rambo_ppvvv_ew_bbxawwx_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in) :: sqrt_s
    real(c_double), intent(out) :: p_rambo(0:3,5)
    real(DREALKIND) :: f_sqrt_s
    real(DREALKIND) :: f_p_rambo(0:3,5)
    f_sqrt_s = sqrt_s
    call rambo(f_sqrt_s, f_p_rambo)
    p_rambo = f_p_rambo
  end subroutine rambo_c


  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:, 1) = [ -1, -1, -1, -1, -1 ]
  H(:, 2) = [ -1, -1, -1, -1,  0 ]
  H(:, 3) = [ -1, -1, -1, -1,  1 ]
  H(:, 4) = [ -1, -1, -1,  0, -1 ]
  H(:, 5) = [ -1, -1, -1,  0,  0 ]
  H(:, 6) = [ -1, -1, -1,  0,  1 ]
  H(:, 7) = [ -1, -1, -1,  1, -1 ]
  H(:, 8) = [ -1, -1, -1,  1,  0 ]
  H(:, 9) = [ -1, -1, -1,  1,  1 ]
  H(:,10) = [ -1, -1,  1, -1, -1 ]
  H(:,11) = [ -1, -1,  1, -1,  0 ]
  H(:,12) = [ -1, -1,  1, -1,  1 ]
  H(:,13) = [ -1, -1,  1,  0, -1 ]
  H(:,14) = [ -1, -1,  1,  0,  0 ]
  H(:,15) = [ -1, -1,  1,  0,  1 ]
  H(:,16) = [ -1, -1,  1,  1, -1 ]
  H(:,17) = [ -1, -1,  1,  1,  0 ]
  H(:,18) = [ -1, -1,  1,  1,  1 ]
  H(:,19) = [ -1,  1, -1, -1, -1 ]
  H(:,20) = [ -1,  1, -1, -1,  0 ]
  H(:,21) = [ -1,  1, -1, -1,  1 ]
  H(:,22) = [ -1,  1, -1,  0, -1 ]
  H(:,23) = [ -1,  1, -1,  0,  0 ]
  H(:,24) = [ -1,  1, -1,  0,  1 ]
  H(:,25) = [ -1,  1, -1,  1, -1 ]
  H(:,26) = [ -1,  1, -1,  1,  0 ]
  H(:,27) = [ -1,  1, -1,  1,  1 ]
  H(:,28) = [ -1,  1,  1, -1, -1 ]
  H(:,29) = [ -1,  1,  1, -1,  0 ]
  H(:,30) = [ -1,  1,  1, -1,  1 ]
  H(:,31) = [ -1,  1,  1,  0, -1 ]
  H(:,32) = [ -1,  1,  1,  0,  0 ]
  H(:,33) = [ -1,  1,  1,  0,  1 ]
  H(:,34) = [ -1,  1,  1,  1, -1 ]
  H(:,35) = [ -1,  1,  1,  1,  0 ]
  H(:,36) = [ -1,  1,  1,  1,  1 ]
  H(:,37) = [  1, -1, -1, -1, -1 ]
  H(:,38) = [  1, -1, -1, -1,  0 ]
  H(:,39) = [  1, -1, -1, -1,  1 ]
  H(:,40) = [  1, -1, -1,  0, -1 ]
  H(:,41) = [  1, -1, -1,  0,  0 ]
  H(:,42) = [  1, -1, -1,  0,  1 ]
  H(:,43) = [  1, -1, -1,  1, -1 ]
  H(:,44) = [  1, -1, -1,  1,  0 ]
  H(:,45) = [  1, -1, -1,  1,  1 ]
  H(:,46) = [  1, -1,  1, -1, -1 ]
  H(:,47) = [  1, -1,  1, -1,  0 ]
  H(:,48) = [  1, -1,  1, -1,  1 ]
  H(:,49) = [  1, -1,  1,  0, -1 ]
  H(:,50) = [  1, -1,  1,  0,  0 ]
  H(:,51) = [  1, -1,  1,  0,  1 ]
  H(:,52) = [  1, -1,  1,  1, -1 ]
  H(:,53) = [  1, -1,  1,  1,  0 ]
  H(:,54) = [  1, -1,  1,  1,  1 ]
  H(:,55) = [  1,  1, -1, -1, -1 ]
  H(:,56) = [  1,  1, -1, -1,  0 ]
  H(:,57) = [  1,  1, -1, -1,  1 ]
  H(:,58) = [  1,  1, -1,  0, -1 ]
  H(:,59) = [  1,  1, -1,  0,  0 ]
  H(:,60) = [  1,  1, -1,  0,  1 ]
  H(:,61) = [  1,  1, -1,  1, -1 ]
  H(:,62) = [  1,  1, -1,  1,  0 ]
  H(:,63) = [  1,  1, -1,  1,  1 ]
  H(:,64) = [  1,  1,  1, -1, -1 ]
  H(:,65) = [  1,  1,  1, -1,  0 ]
  H(:,66) = [  1,  1,  1, -1,  1 ]
  H(:,67) = [  1,  1,  1,  0, -1 ]
  H(:,68) = [  1,  1,  1,  0,  0 ]
  H(:,69) = [  1,  1,  1,  0,  1 ]
  H(:,70) = [  1,  1,  1,  1, -1 ]
  H(:,71) = [  1,  1,  1,  1,  0 ]
  H(:,72) = [  1,  1,  1,  1,  1 ]

  H_HC(:,3) = [ ((((2*(binco-1)+flip)*9+binpos, flip = 0, 1), binpos = 1, 9), binco = 1, 72/9/2) ]
  end subroutine hel_init


  subroutine pol_init(pol) &
      & bind(c,name="ol_f_pol_init_ppvvv_ew_bbxawwx_1")
    implicit none
    integer, intent(in) :: pol(5)
    POLSEL = pol
  end subroutine pol_init


  subroutine set_photons(photon_id) &
      & bind(c,name="ol_f_set_photons_ppvvv_ew_bbxawwx_1")
    implicit none
    integer, intent(in) :: photon_id(5)
    photonid_ppvvv_ew_bbxawwx_1 = photon_id
  end subroutine set_photons


end module ol_external_ppvvv_ew_bbxawwx_1


module colour_basis_ppvvv_ew_bbxawwx_1
  implicit none
  ! tree colour basis
  integer, save :: extcolours(5) = [1,1,0,0,0]
  contains

  pure subroutine tree_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_tree_colbasis_dim_ppvvv_ew_bbxawwx_1")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(5)
    ! number of tree colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 1
    ncoupl = 1
    maxpows = 1
    nhel = 72
  end subroutine tree_colbasis_dim

  subroutine tree_colbasis(basis, powers) &
    & bind(c, name="ol_tree_colbasis_ppvvv_ew_bbxawwx_1")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,1)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([0], [1,1])
#endif
#if 1 > 0
    ! tree colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
    basis = reshape( &
      [1,2,0], &
      [3,1])
#endif
  end subroutine tree_colbasis

end module colour_basis_ppvvv_ew_bbxawwx_1

! **********************************************************************
module ol_heltables_OLR_ppvvv_ew_bbxawwx_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(3) = [-1,0,1], &
    H5(3) = [-1,0,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(58), n3(3,458), n4(4,3)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x9(2,9,4), t3x6(2,6,12), t3x4(2,4,18), t3x18(2,18,18), t3x8(2,8,36), t3x12(2,12,84), &
    t3x72(2,72,286), t4x18(3,18,3)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(72,5)
  integer,           save :: exthel(72,5)
  integer,           save :: firstpol(5)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n3(:,1), t3x4(:,:,1))
  call heltable([3,3,2,18], n4(:,1), t4x18(:,:,1))
  call heltable([2,2,4], n3(:,2), t3x4(:,:,2))
  call heltable([2,2,4], n3(:,3), t3x4(:,:,3))
  call heltable([2,3,6], n3(:,4), t3x6(:,:,1))
  call heltable([4,3,12], n3(:,5), t3x12(:,:,1))
  call heltable([2,2,4], n3(:,6), t3x4(:,:,4))
  call heltable([4,3,12], n3(:,7), t3x12(:,:,2))
  call heltable([3,2,6], n3(:,8), t3x6(:,:,2))
  call heltable([4,3,12], n3(:,9), t3x12(:,:,3))
  call heltable([4,3,12], n3(:,10), t3x12(:,:,4))
  call heltable([4,3,12], n3(:,11), t3x12(:,:,5))
  call heltable([4,3,12], n3(:,12), t3x12(:,:,6))
  call heltable([4,3,12], n3(:,13), t3x12(:,:,7))
  call heltable([2,3,6], n3(:,14), t3x6(:,:,3))
  call heltable([4,3,12], n3(:,15), t3x12(:,:,8))
  call heltable([4,3,12], n3(:,16), t3x12(:,:,9))
  call heltable([2,3,6], n3(:,17), t3x6(:,:,4))
  call heltable([4,3,12], n3(:,18), t3x12(:,:,10))
  call heltable([4,3,12], n3(:,19), t3x12(:,:,11))
  call heltable([4,3,12], n3(:,20), t3x12(:,:,12))
  call heltable([3,4,12], n3(:,21), t3x12(:,:,13))
  call heltable([3,4,12], n3(:,22), t3x12(:,:,14))
  call heltable([2,2,4], n3(:,23), t3x4(:,:,5))
  call heltable([2,3,6], n3(:,24), t3x6(:,:,5))
  n2(1) = 4
  n2(2) = 6
  call heltable([3,4,12], n3(:,25), t3x12(:,:,15))
  call heltable([3,3,9], n3(:,26), t3x9(:,:,1))
  call heltable([2,4,8], n3(:,27), t3x8(:,:,1))
  call heltable([3,3,9], n3(:,28), t3x9(:,:,2))
  call heltable([4,2,8], n3(:,29), t3x8(:,:,2))
  call heltable([4,2,8], n3(:,30), t3x8(:,:,3))
  call heltable([3,2,6], n3(:,31), t3x6(:,:,6))
  call heltable([2,2,4], n3(:,32), t3x4(:,:,6))
  n2(3) = 6
  n2(4) = 4
  call heltable([3,6,18], n3(:,33), t3x18(:,:,1))
  call heltable([4,2,8], n3(:,34), t3x8(:,:,4))
  call heltable([2,4,8], n3(:,35), t3x8(:,:,5))
  call heltable([2,4,8], n3(:,36), t3x8(:,:,6))
  call heltable([2,6,12], n3(:,37), t3x12(:,:,16))
  call heltable([6,2,12], n3(:,38), t3x12(:,:,17))
  call heltable([2,6,12], n3(:,39), t3x12(:,:,18))
  call heltable([2,6,12], n3(:,40), t3x12(:,:,19))
  call heltable([6,2,12], n3(:,41), t3x12(:,:,20))
  call heltable([3,3,2,18], n4(:,2), t4x18(:,:,2))
  call heltable([3,3,2,18], n4(:,3), t4x18(:,:,3))
  call heltable([2,2,4], n3(:,42), t3x4(:,:,7))
  call heltable([2,2,4], n3(:,43), t3x4(:,:,8))
  call heltable([2,2,4], n3(:,44), t3x4(:,:,9))
  call heltable([2,2,4], n3(:,45), t3x4(:,:,10))
  call heltable([4,3,12], n3(:,46), t3x12(:,:,21))
  call heltable([4,3,12], n3(:,47), t3x12(:,:,22))
  call heltable([4,3,12], n3(:,48), t3x12(:,:,23))
  call heltable([4,3,12], n3(:,49), t3x12(:,:,24))
  call heltable([4,3,12], n3(:,50), t3x12(:,:,25))
  call heltable([4,3,12], n3(:,51), t3x12(:,:,26))
  call heltable([4,3,12], n3(:,52), t3x12(:,:,27))
  call heltable([4,3,12], n3(:,53), t3x12(:,:,28))
  call heltable([4,3,12], n3(:,54), t3x12(:,:,29))
  call heltable([4,3,12], n3(:,55), t3x12(:,:,30))
  call heltable([4,3,12], n3(:,56), t3x12(:,:,31))
  call heltable([4,3,12], n3(:,57), t3x12(:,:,32))
  call heltable([3,4,12], n3(:,58), t3x12(:,:,33))
  call heltable([3,4,12], n3(:,59), t3x12(:,:,34))
  n2(5) = 4
  n2(6) = 4
  n2(7) = 4
  n2(8) = 4
  n2(9) = 4
  n2(10) = 4
  call heltable([2,4,8], n3(:,60), t3x8(:,:,7))
  call heltable([4,2,8], n3(:,61), t3x8(:,:,8))
  call heltable([4,2,8], n3(:,62), t3x8(:,:,9))
  call heltable([4,2,8], n3(:,63), t3x8(:,:,10))
  call heltable([2,3,6], n3(:,64), t3x6(:,:,7))
  call heltable([2,3,6], n3(:,65), t3x6(:,:,8))
  call heltable([2,3,6], n3(:,66), t3x6(:,:,9))
  call heltable([3,2,6], n3(:,67), t3x6(:,:,10))
  call heltable([3,4,12], n3(:,68), t3x12(:,:,35))
  call heltable([3,3,9], n3(:,69), t3x9(:,:,3))
  call heltable([3,3,9], n3(:,70), t3x9(:,:,4))
  call heltable([3,6,18], n3(:,71), t3x18(:,:,2))
  call heltable([2,6,12], n3(:,72), t3x12(:,:,36))
  call heltable([2,6,12], n3(:,73), t3x12(:,:,37))
  call heltable([2,4,8], n3(:,74), t3x8(:,:,11))
  call heltable([2,4,8], n3(:,75), t3x8(:,:,12))
  call heltable([4,2,8], n3(:,76), t3x8(:,:,13))
  call heltable([4,2,8], n3(:,77), t3x8(:,:,14))
  call heltable([4,2,8], n3(:,78), t3x8(:,:,15))
  call heltable([4,2,8], n3(:,79), t3x8(:,:,16))
  call heltable([2,3,6], n3(:,80), t3x6(:,:,11))
  n2(11) = 6
  call heltable([2,6,12], n3(:,81), t3x12(:,:,38))
  call heltable([2,6,12], n3(:,82), t3x12(:,:,39))
  call heltable([6,2,12], n3(:,83), t3x12(:,:,40))
  call heltable([6,2,12], n3(:,84), t3x12(:,:,41))
  call heltable([2,6,12], n3(:,85), t3x12(:,:,42))
  call heltable([2,2,4], n3(:,86), t3x4(:,:,11))
  n2(12) = 4
  call heltable([2,2,4], n3(:,87), t3x4(:,:,12))
  n2(13) = 4
  call heltable([4,2,8], n3(:,88), t3x8(:,:,17))
  call heltable([4,2,8], n3(:,89), t3x8(:,:,18))
  call heltable([2,4,8], n3(:,90), t3x8(:,:,19))
  call heltable([2,4,8], n3(:,91), t3x8(:,:,20))
  call heltable([2,4,8], n3(:,92), t3x8(:,:,21))
  call heltable([2,4,8], n3(:,93), t3x8(:,:,22))
  call heltable([4,2,8], n3(:,94), t3x8(:,:,23))
  call heltable([4,2,8], n3(:,95), t3x8(:,:,24))
  call heltable([2,4,8], n3(:,96), t3x8(:,:,25))
  call heltable([2,4,8], n3(:,97), t3x8(:,:,26))
  call heltable([2,4,8], n3(:,98), t3x8(:,:,27))
  call heltable([2,4,8], n3(:,99), t3x8(:,:,28))
  call heltable([3,2,6], n3(:,100), t3x6(:,:,12))
  n2(14) = 6
  call heltable([3,6,18], n3(:,101), t3x18(:,:,3))
  call heltable([6,2,12], n3(:,102), t3x12(:,:,43))
  call heltable([6,2,12], n3(:,103), t3x12(:,:,44))
  call heltable([2,6,12], n3(:,104), t3x12(:,:,45))
  call heltable([2,6,12], n3(:,105), t3x12(:,:,46))
  call heltable([2,6,12], n3(:,106), t3x12(:,:,47))
  call heltable([6,2,12], n3(:,107), t3x12(:,:,48))
  call heltable([2,2,4], n3(:,108), t3x4(:,:,13))
  n2(15) = 4
  call heltable([3,4,12], n3(:,109), t3x12(:,:,49))
  call heltable([2,2,4], n3(:,110), t3x4(:,:,14))
  n2(16) = 4
  call heltable([3,4,12], n3(:,111), t3x12(:,:,50))
  call heltable([2,4,8], n3(:,112), t3x8(:,:,29))
  call heltable([2,4,8], n3(:,113), t3x8(:,:,30))
  call heltable([4,2,8], n3(:,114), t3x8(:,:,31))
  call heltable([4,2,8], n3(:,115), t3x8(:,:,32))
  call heltable([4,2,8], n3(:,116), t3x8(:,:,33))
  call heltable([4,2,8], n3(:,117), t3x8(:,:,34))
  call heltable([2,2,4], n3(:,118), t3x4(:,:,15))
  call heltable([4,3,12], n3(:,119), t3x12(:,:,51))
  call heltable([2,2,4], n3(:,120), t3x4(:,:,16))
  call heltable([4,3,12], n3(:,121), t3x12(:,:,52))
  call heltable([2,2,4], n3(:,122), t3x4(:,:,17))
  call heltable([4,3,12], n3(:,123), t3x12(:,:,53))
  call heltable([2,2,4], n3(:,124), t3x4(:,:,18))
  call heltable([4,3,12], n3(:,125), t3x12(:,:,54))
  call heltable([4,3,12], n3(:,126), t3x12(:,:,55))
  call heltable([4,3,12], n3(:,127), t3x12(:,:,56))
  call heltable([4,3,12], n3(:,128), t3x12(:,:,57))
  call heltable([4,3,12], n3(:,129), t3x12(:,:,58))
  call heltable([4,3,12], n3(:,130), t3x12(:,:,59))
  call heltable([4,3,12], n3(:,131), t3x12(:,:,60))
  call heltable([4,3,12], n3(:,132), t3x12(:,:,61))
  call heltable([4,3,12], n3(:,133), t3x12(:,:,62))
  call heltable([4,3,12], n3(:,134), t3x12(:,:,63))
  call heltable([4,3,12], n3(:,135), t3x12(:,:,64))
  call heltable([4,3,12], n3(:,136), t3x12(:,:,65))
  call heltable([4,3,12], n3(:,137), t3x12(:,:,66))
  call heltable([4,3,12], n3(:,138), t3x12(:,:,67))
  call heltable([4,3,12], n3(:,139), t3x12(:,:,68))
  call heltable([4,3,12], n3(:,140), t3x12(:,:,69))
  call heltable([4,3,12], n3(:,141), t3x12(:,:,70))
  call heltable([4,3,12], n3(:,142), t3x12(:,:,71))
  call heltable([4,3,12], n3(:,143), t3x12(:,:,72))
  call heltable([4,3,12], n3(:,144), t3x12(:,:,73))
  call heltable([4,3,12], n3(:,145), t3x12(:,:,74))
  call heltable([3,4,12], n3(:,146), t3x12(:,:,75))
  call heltable([3,4,12], n3(:,147), t3x12(:,:,76))
  call heltable([3,4,12], n3(:,148), t3x12(:,:,77))
  call heltable([3,4,12], n3(:,149), t3x12(:,:,78))
  call heltable([3,6,18], n3(:,150), t3x18(:,:,4))
  n2(17) = 4
  n2(18) = 4
  call heltable([6,3,18], n3(:,151), t3x18(:,:,5))
  call heltable([6,3,18], n3(:,152), t3x18(:,:,6))
  call heltable([3,6,18], n3(:,153), t3x18(:,:,7))
  n2(19) = 4
  n2(20) = 4
  n2(21) = 6
  n2(22) = 6
  n2(23) = 6
  n2(24) = 6
  call heltable([3,6,18], n3(:,154), t3x18(:,:,8))
  call heltable([3,6,18], n3(:,155), t3x18(:,:,9))
  call heltable([6,3,18], n3(:,156), t3x18(:,:,10))
  call heltable([6,3,18], n3(:,157), t3x18(:,:,11))
  n2(25) = 6
  n2(26) = 6
  n2(27) = 6
  n2(28) = 6
  call heltable([6,3,18], n3(:,158), t3x18(:,:,12))
  n2(29) = 4
  n2(30) = 18
  n2(31) = 4
  n2(32) = 6
  n2(33) = 12
  n2(34) = 6
  call heltable([9,2,18], n3(:,159), t3x18(:,:,13))
  n2(35) = 18
  call heltable([2,9,18], n3(:,160), t3x18(:,:,14))
  n2(36) = 18
  call heltable([2,9,18], n3(:,161), t3x18(:,:,15))
  n2(37) = 18
  n2(38) = 9
  call heltable([2,4,8], n3(:,162), t3x8(:,:,35))
  n2(39) = 9
  n2(40) = 9
  n2(41) = 9
  n2(42) = 9
  n2(43) = 9
  call heltable([4,3,12], n3(:,163), t3x12(:,:,79))
  n2(44) = 6
  n2(45) = 12
  n2(46) = 6
  n2(47) = 4
  n2(48) = 18
  n2(49) = 4
  call heltable([2,9,18], n3(:,164), t3x18(:,:,16))
  n2(50) = 18
  call heltable([9,2,18], n3(:,165), t3x18(:,:,17))
  n2(51) = 18
  call heltable([9,2,18], n3(:,166), t3x18(:,:,18))
  n2(52) = 18
  call heltable([4,2,8], n3(:,167), t3x8(:,:,36))
  call heltable([6,2,12], n3(:,168), t3x12(:,:,80))
  n2(53) = 12
  n2(54) = 12
  call heltable([2,6,12], n3(:,169), t3x12(:,:,81))
  n2(55) = 12
  call heltable([6,2,12], n3(:,170), t3x12(:,:,82))
  n2(56) = 12
  call heltable([6,2,12], n3(:,171), t3x12(:,:,83))
  n2(57) = 12
  call heltable([2,6,12], n3(:,172), t3x12(:,:,84))
  n2(58) = 12
  call heltable([4,18,72], n3(:,173), t3x72(:,:,1))
  call heltable([18,4,72], n3(:,174), t3x72(:,:,2))
  call heltable([6,12,72], n3(:,175), t3x72(:,:,3))
  call heltable([6,12,72], n3(:,176), t3x72(:,:,4))
  call heltable([6,12,72], n3(:,177), t3x72(:,:,5))
  call heltable([6,12,72], n3(:,178), t3x72(:,:,6))
  call heltable([6,12,72], n3(:,179), t3x72(:,:,7))
  call heltable([6,12,72], n3(:,180), t3x72(:,:,8))
  call heltable([6,12,72], n3(:,181), t3x72(:,:,9))
  call heltable([6,12,72], n3(:,182), t3x72(:,:,10))
  call heltable([6,12,72], n3(:,183), t3x72(:,:,11))
  call heltable([6,12,72], n3(:,184), t3x72(:,:,12))
  call heltable([6,12,72], n3(:,185), t3x72(:,:,13))
  call heltable([6,12,72], n3(:,186), t3x72(:,:,14))
  call heltable([6,12,72], n3(:,187), t3x72(:,:,15))
  call heltable([6,12,72], n3(:,188), t3x72(:,:,16))
  call heltable([6,12,72], n3(:,189), t3x72(:,:,17))
  call heltable([9,8,72], n3(:,190), t3x72(:,:,18))
  call heltable([9,8,72], n3(:,191), t3x72(:,:,19))
  call heltable([9,8,72], n3(:,192), t3x72(:,:,20))
  call heltable([4,18,72], n3(:,193), t3x72(:,:,21))
  call heltable([9,8,72], n3(:,194), t3x72(:,:,22))
  call heltable([9,8,72], n3(:,195), t3x72(:,:,23))
  call heltable([9,8,72], n3(:,196), t3x72(:,:,24))
  call heltable([6,12,72], n3(:,197), t3x72(:,:,25))
  call heltable([6,12,72], n3(:,198), t3x72(:,:,26))
  call heltable([6,12,72], n3(:,199), t3x72(:,:,27))
  call heltable([6,12,72], n3(:,200), t3x72(:,:,28))
  call heltable([6,12,72], n3(:,201), t3x72(:,:,29))
  call heltable([4,18,72], n3(:,202), t3x72(:,:,30))
  call heltable([4,18,72], n3(:,203), t3x72(:,:,31))
  call heltable([18,4,72], n3(:,204), t3x72(:,:,32))
  call heltable([18,4,72], n3(:,205), t3x72(:,:,33))
  call heltable([18,4,72], n3(:,206), t3x72(:,:,34))
  call heltable([18,4,72], n3(:,207), t3x72(:,:,35))
  call heltable([6,12,72], n3(:,208), t3x72(:,:,36))
  call heltable([6,12,72], n3(:,209), t3x72(:,:,37))
  call heltable([6,12,72], n3(:,210), t3x72(:,:,38))
  call heltable([6,12,72], n3(:,211), t3x72(:,:,39))
  call heltable([6,12,72], n3(:,212), t3x72(:,:,40))
  call heltable([6,12,72], n3(:,213), t3x72(:,:,41))
  call heltable([6,12,72], n3(:,214), t3x72(:,:,42))
  call heltable([6,12,72], n3(:,215), t3x72(:,:,43))
  call heltable([6,12,72], n3(:,216), t3x72(:,:,44))
  call heltable([6,12,72], n3(:,217), t3x72(:,:,45))
  call heltable([6,12,72], n3(:,218), t3x72(:,:,46))
  call heltable([6,12,72], n3(:,219), t3x72(:,:,47))
  call heltable([6,12,72], n3(:,220), t3x72(:,:,48))
  call heltable([6,12,72], n3(:,221), t3x72(:,:,49))
  call heltable([18,4,72], n3(:,222), t3x72(:,:,50))
  call heltable([18,4,72], n3(:,223), t3x72(:,:,51))
  call heltable([18,4,72], n3(:,224), t3x72(:,:,52))
  call heltable([18,4,72], n3(:,225), t3x72(:,:,53))
  call heltable([18,4,72], n3(:,226), t3x72(:,:,54))
  call heltable([18,4,72], n3(:,227), t3x72(:,:,55))
  call heltable([9,8,72], n3(:,228), t3x72(:,:,56))
  call heltable([9,8,72], n3(:,229), t3x72(:,:,57))
  call heltable([9,8,72], n3(:,230), t3x72(:,:,58))
  call heltable([9,8,72], n3(:,231), t3x72(:,:,59))
  call heltable([9,8,72], n3(:,232), t3x72(:,:,60))
  call heltable([12,6,72], n3(:,233), t3x72(:,:,61))
  call heltable([12,6,72], n3(:,234), t3x72(:,:,62))
  call heltable([12,6,72], n3(:,235), t3x72(:,:,63))
  call heltable([12,6,72], n3(:,236), t3x72(:,:,64))
  call heltable([12,6,72], n3(:,237), t3x72(:,:,65))
  call heltable([12,6,72], n3(:,238), t3x72(:,:,66))
  call heltable([12,6,72], n3(:,239), t3x72(:,:,67))
  call heltable([12,6,72], n3(:,240), t3x72(:,:,68))
  call heltable([12,6,72], n3(:,241), t3x72(:,:,69))
  call heltable([12,6,72], n3(:,242), t3x72(:,:,70))
  call heltable([12,6,72], n3(:,243), t3x72(:,:,71))
  call heltable([12,6,72], n3(:,244), t3x72(:,:,72))
  call heltable([12,6,72], n3(:,245), t3x72(:,:,73))
  call heltable([12,6,72], n3(:,246), t3x72(:,:,74))
  call heltable([6,12,72], n3(:,247), t3x72(:,:,75))
  call heltable([6,12,72], n3(:,248), t3x72(:,:,76))
  call heltable([8,9,72], n3(:,249), t3x72(:,:,77))
  call heltable([8,9,72], n3(:,250), t3x72(:,:,78))
  call heltable([8,9,72], n3(:,251), t3x72(:,:,79))
  call heltable([4,18,72], n3(:,252), t3x72(:,:,80))
  call heltable([4,18,72], n3(:,253), t3x72(:,:,81))
  call heltable([8,9,72], n3(:,254), t3x72(:,:,82))
  call heltable([8,9,72], n3(:,255), t3x72(:,:,83))
  call heltable([8,9,72], n3(:,256), t3x72(:,:,84))
  call heltable([6,12,72], n3(:,257), t3x72(:,:,85))
  call heltable([6,12,72], n3(:,258), t3x72(:,:,86))
  call heltable([12,6,72], n3(:,259), t3x72(:,:,87))
  call heltable([12,6,72], n3(:,260), t3x72(:,:,88))
  call heltable([12,6,72], n3(:,261), t3x72(:,:,89))
  call heltable([12,6,72], n3(:,262), t3x72(:,:,90))
  call heltable([9,8,72], n3(:,263), t3x72(:,:,91))
  call heltable([9,8,72], n3(:,264), t3x72(:,:,92))
  call heltable([9,8,72], n3(:,265), t3x72(:,:,93))
  call heltable([9,8,72], n3(:,266), t3x72(:,:,94))
  call heltable([9,8,72], n3(:,267), t3x72(:,:,95))
  call heltable([9,8,72], n3(:,268), t3x72(:,:,96))
  call heltable([12,6,72], n3(:,269), t3x72(:,:,97))
  call heltable([12,6,72], n3(:,270), t3x72(:,:,98))
  call heltable([6,12,72], n3(:,271), t3x72(:,:,99))
  call heltable([6,12,72], n3(:,272), t3x72(:,:,100))
  call heltable([6,12,72], n3(:,273), t3x72(:,:,101))
  call heltable([6,12,72], n3(:,274), t3x72(:,:,102))
  call heltable([12,6,72], n3(:,275), t3x72(:,:,103))
  call heltable([12,6,72], n3(:,276), t3x72(:,:,104))
  call heltable([6,12,72], n3(:,277), t3x72(:,:,105))
  call heltable([6,12,72], n3(:,278), t3x72(:,:,106))
  call heltable([6,12,72], n3(:,279), t3x72(:,:,107))
  call heltable([6,12,72], n3(:,280), t3x72(:,:,108))
  call heltable([18,4,72], n3(:,281), t3x72(:,:,109))
  call heltable([18,4,72], n3(:,282), t3x72(:,:,110))
  call heltable([9,8,72], n3(:,283), t3x72(:,:,111))
  call heltable([9,8,72], n3(:,284), t3x72(:,:,112))
  call heltable([9,8,72], n3(:,285), t3x72(:,:,113))
  call heltable([9,8,72], n3(:,286), t3x72(:,:,114))
  call heltable([9,8,72], n3(:,287), t3x72(:,:,115))
  call heltable([9,8,72], n3(:,288), t3x72(:,:,116))
  call heltable([9,8,72], n3(:,289), t3x72(:,:,117))
  call heltable([9,8,72], n3(:,290), t3x72(:,:,118))
  call heltable([9,8,72], n3(:,291), t3x72(:,:,119))
  call heltable([9,8,72], n3(:,292), t3x72(:,:,120))
  call heltable([9,8,72], n3(:,293), t3x72(:,:,121))
  call heltable([9,8,72], n3(:,294), t3x72(:,:,122))
  call heltable([4,18,72], n3(:,295), t3x72(:,:,123))
  call heltable([4,18,72], n3(:,296), t3x72(:,:,124))
  call heltable([6,12,72], n3(:,297), t3x72(:,:,125))
  call heltable([6,12,72], n3(:,298), t3x72(:,:,126))
  call heltable([6,12,72], n3(:,299), t3x72(:,:,127))
  call heltable([6,12,72], n3(:,300), t3x72(:,:,128))
  call heltable([6,12,72], n3(:,301), t3x72(:,:,129))
  call heltable([6,12,72], n3(:,302), t3x72(:,:,130))
  call heltable([6,12,72], n3(:,303), t3x72(:,:,131))
  call heltable([6,12,72], n3(:,304), t3x72(:,:,132))
  call heltable([6,12,72], n3(:,305), t3x72(:,:,133))
  call heltable([6,12,72], n3(:,306), t3x72(:,:,134))
  call heltable([6,12,72], n3(:,307), t3x72(:,:,135))
  call heltable([6,12,72], n3(:,308), t3x72(:,:,136))
  call heltable([9,8,72], n3(:,309), t3x72(:,:,137))
  call heltable([9,8,72], n3(:,310), t3x72(:,:,138))
  call heltable([9,8,72], n3(:,311), t3x72(:,:,139))
  call heltable([9,8,72], n3(:,312), t3x72(:,:,140))
  call heltable([9,8,72], n3(:,313), t3x72(:,:,141))
  call heltable([9,8,72], n3(:,314), t3x72(:,:,142))
  call heltable([6,12,72], n3(:,315), t3x72(:,:,143))
  call heltable([6,12,72], n3(:,316), t3x72(:,:,144))
  call heltable([6,12,72], n3(:,317), t3x72(:,:,145))
  call heltable([6,12,72], n3(:,318), t3x72(:,:,146))
  call heltable([6,12,72], n3(:,319), t3x72(:,:,147))
  call heltable([6,12,72], n3(:,320), t3x72(:,:,148))
  call heltable([6,12,72], n3(:,321), t3x72(:,:,149))
  call heltable([6,12,72], n3(:,322), t3x72(:,:,150))
  call heltable([6,12,72], n3(:,323), t3x72(:,:,151))
  call heltable([6,12,72], n3(:,324), t3x72(:,:,152))
  call heltable([6,12,72], n3(:,325), t3x72(:,:,153))
  call heltable([6,12,72], n3(:,326), t3x72(:,:,154))
  call heltable([6,12,72], n3(:,327), t3x72(:,:,155))
  call heltable([6,12,72], n3(:,328), t3x72(:,:,156))
  call heltable([6,12,72], n3(:,329), t3x72(:,:,157))
  call heltable([6,12,72], n3(:,330), t3x72(:,:,158))
  call heltable([6,12,72], n3(:,331), t3x72(:,:,159))
  call heltable([6,12,72], n3(:,332), t3x72(:,:,160))
  call heltable([6,12,72], n3(:,333), t3x72(:,:,161))
  call heltable([6,12,72], n3(:,334), t3x72(:,:,162))
  call heltable([6,12,72], n3(:,335), t3x72(:,:,163))
  call heltable([6,12,72], n3(:,336), t3x72(:,:,164))
  call heltable([6,12,72], n3(:,337), t3x72(:,:,165))
  call heltable([6,12,72], n3(:,338), t3x72(:,:,166))
  call heltable([6,12,72], n3(:,339), t3x72(:,:,167))
  call heltable([6,12,72], n3(:,340), t3x72(:,:,168))
  call heltable([6,12,72], n3(:,341), t3x72(:,:,169))
  call heltable([6,12,72], n3(:,342), t3x72(:,:,170))
  call heltable([18,4,72], n3(:,343), t3x72(:,:,171))
  call heltable([18,4,72], n3(:,344), t3x72(:,:,172))
  call heltable([4,18,72], n3(:,345), t3x72(:,:,173))
  call heltable([4,18,72], n3(:,346), t3x72(:,:,174))
  call heltable([4,18,72], n3(:,347), t3x72(:,:,175))
  call heltable([4,18,72], n3(:,348), t3x72(:,:,176))
  call heltable([4,18,72], n3(:,349), t3x72(:,:,177))
  call heltable([18,4,72], n3(:,350), t3x72(:,:,178))
  call heltable([18,4,72], n3(:,351), t3x72(:,:,179))
  call heltable([4,18,72], n3(:,352), t3x72(:,:,180))
  call heltable([4,18,72], n3(:,353), t3x72(:,:,181))
  call heltable([4,18,72], n3(:,354), t3x72(:,:,182))
  call heltable([4,18,72], n3(:,355), t3x72(:,:,183))
  call heltable([4,18,72], n3(:,356), t3x72(:,:,184))
  call heltable([4,18,72], n3(:,357), t3x72(:,:,185))
  call heltable([4,18,72], n3(:,358), t3x72(:,:,186))
  call heltable([4,18,72], n3(:,359), t3x72(:,:,187))
  call heltable([12,6,72], n3(:,360), t3x72(:,:,188))
  call heltable([12,6,72], n3(:,361), t3x72(:,:,189))
  call heltable([12,6,72], n3(:,362), t3x72(:,:,190))
  call heltable([12,6,72], n3(:,363), t3x72(:,:,191))
  call heltable([12,6,72], n3(:,364), t3x72(:,:,192))
  call heltable([12,6,72], n3(:,365), t3x72(:,:,193))
  call heltable([12,6,72], n3(:,366), t3x72(:,:,194))
  call heltable([12,6,72], n3(:,367), t3x72(:,:,195))
  call heltable([12,6,72], n3(:,368), t3x72(:,:,196))
  call heltable([12,6,72], n3(:,369), t3x72(:,:,197))
  call heltable([12,6,72], n3(:,370), t3x72(:,:,198))
  call heltable([12,6,72], n3(:,371), t3x72(:,:,199))
  call heltable([12,6,72], n3(:,372), t3x72(:,:,200))
  call heltable([12,6,72], n3(:,373), t3x72(:,:,201))
  call heltable([4,18,72], n3(:,374), t3x72(:,:,202))
  call heltable([4,18,72], n3(:,375), t3x72(:,:,203))
  call heltable([4,18,72], n3(:,376), t3x72(:,:,204))
  call heltable([4,18,72], n3(:,377), t3x72(:,:,205))
  call heltable([4,18,72], n3(:,378), t3x72(:,:,206))
  call heltable([4,18,72], n3(:,379), t3x72(:,:,207))
  call heltable([4,18,72], n3(:,380), t3x72(:,:,208))
  call heltable([4,18,72], n3(:,381), t3x72(:,:,209))
  call heltable([4,18,72], n3(:,382), t3x72(:,:,210))
  call heltable([4,18,72], n3(:,383), t3x72(:,:,211))
  call heltable([4,18,72], n3(:,384), t3x72(:,:,212))
  call heltable([4,18,72], n3(:,385), t3x72(:,:,213))
  call heltable([4,18,72], n3(:,386), t3x72(:,:,214))
  call heltable([4,18,72], n3(:,387), t3x72(:,:,215))
  call heltable([4,18,72], n3(:,388), t3x72(:,:,216))
  call heltable([4,18,72], n3(:,389), t3x72(:,:,217))
  call heltable([4,18,72], n3(:,390), t3x72(:,:,218))
  call heltable([12,6,72], n3(:,391), t3x72(:,:,219))
  call heltable([12,6,72], n3(:,392), t3x72(:,:,220))
  call heltable([12,6,72], n3(:,393), t3x72(:,:,221))
  call heltable([12,6,72], n3(:,394), t3x72(:,:,222))
  call heltable([12,6,72], n3(:,395), t3x72(:,:,223))
  call heltable([12,6,72], n3(:,396), t3x72(:,:,224))
  call heltable([12,6,72], n3(:,397), t3x72(:,:,225))
  call heltable([12,6,72], n3(:,398), t3x72(:,:,226))
  call heltable([12,6,72], n3(:,399), t3x72(:,:,227))
  call heltable([12,6,72], n3(:,400), t3x72(:,:,228))
  call heltable([12,6,72], n3(:,401), t3x72(:,:,229))
  call heltable([12,6,72], n3(:,402), t3x72(:,:,230))
  call heltable([12,6,72], n3(:,403), t3x72(:,:,231))
  call heltable([12,6,72], n3(:,404), t3x72(:,:,232))
  call heltable([4,18,72], n3(:,405), t3x72(:,:,233))
  call heltable([18,4,72], n3(:,406), t3x72(:,:,234))
  call heltable([6,12,72], n3(:,407), t3x72(:,:,235))
  call heltable([12,6,72], n3(:,408), t3x72(:,:,236))
  call heltable([4,18,72], n3(:,409), t3x72(:,:,237))
  call heltable([4,18,72], n3(:,410), t3x72(:,:,238))
  call heltable([4,18,72], n3(:,411), t3x72(:,:,239))
  call heltable([4,18,72], n3(:,412), t3x72(:,:,240))
  call heltable([4,18,72], n3(:,413), t3x72(:,:,241))
  call heltable([4,18,72], n3(:,414), t3x72(:,:,242))
  call heltable([8,9,72], n3(:,415), t3x72(:,:,243))
  call heltable([8,9,72], n3(:,416), t3x72(:,:,244))
  call heltable([8,9,72], n3(:,417), t3x72(:,:,245))
  call heltable([8,9,72], n3(:,418), t3x72(:,:,246))
  call heltable([8,9,72], n3(:,419), t3x72(:,:,247))
  call heltable([8,9,72], n3(:,420), t3x72(:,:,248))
  call heltable([8,9,72], n3(:,421), t3x72(:,:,249))
  call heltable([6,12,72], n3(:,422), t3x72(:,:,250))
  call heltable([12,6,72], n3(:,423), t3x72(:,:,251))
  call heltable([4,18,72], n3(:,424), t3x72(:,:,252))
  call heltable([18,4,72], n3(:,425), t3x72(:,:,253))
  call heltable([4,18,72], n3(:,426), t3x72(:,:,254))
  call heltable([4,18,72], n3(:,427), t3x72(:,:,255))
  call heltable([4,18,72], n3(:,428), t3x72(:,:,256))
  call heltable([4,18,72], n3(:,429), t3x72(:,:,257))
  call heltable([4,18,72], n3(:,430), t3x72(:,:,258))
  call heltable([4,18,72], n3(:,431), t3x72(:,:,259))
  call heltable([8,9,72], n3(:,432), t3x72(:,:,260))
  call heltable([9,8,72], n3(:,433), t3x72(:,:,261))
  call heltable([9,8,72], n3(:,434), t3x72(:,:,262))
  call heltable([8,9,72], n3(:,435), t3x72(:,:,263))
  call heltable([8,9,72], n3(:,436), t3x72(:,:,264))
  call heltable([8,9,72], n3(:,437), t3x72(:,:,265))
  call heltable([8,9,72], n3(:,438), t3x72(:,:,266))
  call heltable([6,12,72], n3(:,439), t3x72(:,:,267))
  call heltable([6,12,72], n3(:,440), t3x72(:,:,268))
  call heltable([6,12,72], n3(:,441), t3x72(:,:,269))
  call heltable([6,12,72], n3(:,442), t3x72(:,:,270))
  call heltable([6,12,72], n3(:,443), t3x72(:,:,271))
  call heltable([6,12,72], n3(:,444), t3x72(:,:,272))
  call heltable([6,12,72], n3(:,445), t3x72(:,:,273))
  call heltable([6,12,72], n3(:,446), t3x72(:,:,274))
  call heltable([12,6,72], n3(:,447), t3x72(:,:,275))
  call heltable([12,6,72], n3(:,448), t3x72(:,:,276))
  call heltable([12,6,72], n3(:,449), t3x72(:,:,277))
  call heltable([12,6,72], n3(:,450), t3x72(:,:,278))
  call heltable([6,12,72], n3(:,451), t3x72(:,:,279))
  call heltable([6,12,72], n3(:,452), t3x72(:,:,280))
  call heltable([6,12,72], n3(:,453), t3x72(:,:,281))
  call heltable([6,12,72], n3(:,454), t3x72(:,:,282))
  call heltable([12,6,72], n3(:,455), t3x72(:,:,283))
  call heltable([12,6,72], n3(:,456), t3x72(:,:,284))
  call heltable([12,6,72], n3(:,457), t3x72(:,:,285))
  call heltable([12,6,72], n3(:,458), t3x72(:,:,286))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_OLR_ppvvv_ew_bbxawwx_1
