
! **********************************************************************
module ol_tables_storage_ppvvv_bbxawwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(72,64)
integer(intkind2), save :: heltab2x2(2,2,34)
integer(intkind2), save :: heltab2x3(2,3,37)
integer(intkind2), save :: heltab2x4(2,4,10)
integer(intkind2), save :: heltab2x6(2,6,32)
integer(intkind2), save :: heltab2x8(2,8,4)
integer(intkind2), save :: heltab2x12(2,12,20)
integer(intkind2), save :: heltab2x24(2,24,12)
integer(intkind2), save :: heltab2x72(2,72,64)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(64)
integer(intkind2), save :: m3h2x1(3,34)
integer(intkind2), save :: m3h3x1(3,37)
integer(intkind2), save :: m3h4x1(3,5)
integer(intkind2), save :: m3h6x1(3,13)
integer(intkind2), save :: m3h12x1(3,6)
integer(intkind2), save :: m3h2x2(3,5)
integer(intkind2), save :: m3h3x2(3,7)
integer(intkind2), save :: m3h6x2(3,1)
integer(intkind2), save :: m3h2x3(3,12)
integer(intkind2), save :: m3h4x3(3,2)
integer(intkind2), save :: m3h2x4(3,4)
integer(intkind2), save :: m3h18x4(3,24)
integer(intkind2), save :: m3h2x6(3,11)
integer(intkind2), save :: m3h4x6(3,2)
integer(intkind2), save :: m3h12x6(3,6)
integer(intkind2), save :: m3h9x8(3,12)
integer(intkind2), save :: m3h2x12(3,10)
integer(intkind2), save :: m3h6x12(3,10)
integer(intkind2), save :: m3h3x24(3,12)

integer(intkind2), save :: n2h1(91)
integer(intkind2), save :: n2h2(10)
integer(intkind2), save :: n2h3(13)
integer(intkind2), save :: n2h4(13)
integer(intkind2), save :: n2h6(12)
integer(intkind2), save :: n2h8(12)
integer(intkind2), save :: n2h12(5)
integer(intkind2), save :: n2h24(12)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h3x1(1,:)=3
m3h3x1(2,:)=1
m3h3x1(3,:)=3
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h6x1(1,:)=6
m3h6x1(2,:)=1
m3h6x1(3,:)=6
m3h12x1(1,:)=12
m3h12x1(2,:)=1
m3h12x1(3,:)=12
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h3x2(1,:)=3
m3h3x2(2,:)=2
m3h3x2(3,:)=6
m3h6x2(1,:)=6
m3h6x2(2,:)=2
m3h6x2(3,:)=12
m3h2x3(1,:)=2
m3h2x3(2,:)=3
m3h2x3(3,:)=6
m3h4x3(1,:)=4
m3h4x3(2,:)=3
m3h4x3(3,:)=12
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h18x4(1,:)=18
m3h18x4(2,:)=4
m3h18x4(3,:)=72
m3h2x6(1,:)=2
m3h2x6(2,:)=6
m3h2x6(3,:)=12
m3h4x6(1,:)=4
m3h4x6(2,:)=6
m3h4x6(3,:)=24
m3h12x6(1,:)=12
m3h12x6(2,:)=6
m3h12x6(3,:)=72
m3h9x8(1,:)=9
m3h9x8(2,:)=8
m3h9x8(3,:)=72
m3h2x12(1,:)=2
m3h2x12(2,:)=12
m3h2x12(3,:)=24
m3h6x12(1,:)=6
m3h6x12(2,:)=12
m3h6x12(3,:)=72
m3h3x24(1,:)=3
m3h3x24(2,:)=24
m3h3x24(3,:)=72

n2h1(:)=1
n2h2(:)=2
n2h3(:)=3
n2h4(:)=4
n2h6(:)=6
n2h8(:)=8
n2h12(:)=12
n2h24(:)=24


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppvvv_bbxawwx_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppvvv_bbxawwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G0H2(1)
  type(hol), save :: G1H2(30)
  type(hol), save :: G2H2(8)
  type(hol), save :: G0H3(1)
  type(hol), save :: G1H3(33)
  type(hol), save :: G2H3(8)
  type(hol), save :: G0H4(8)
  type(hol), save :: G1H4(8)
  type(hol), save :: G0H6(3)
  type(hol), save :: G1H6(18)
  type(hol), save :: G2H6(3)
  type(hol), save :: G0H8(1)
  type(hol), save :: G1H8(6)
  type(hol), save :: G0H12(3)
  type(hol), save :: G1H12(4)
  type(hol), save :: G2H12(1)
  type(hol), save :: G0H24(1)
  type(hol), save :: G1H24(5)
  type(hol), save :: G0H72(1)
  type(hcl), save, dimension(138) :: G0tensor
  type(hcl), save, dimension(70) :: G1tensor
  type(hcl), save, dimension(64) :: G2tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(33)
type (redset4),    save :: RedSet_4(17)
type (redset5),    save :: RedSet_5(3)
integer, save :: mass2set(0:1,4)
integer, save :: mass3set(0:2,10)
integer, save :: mass4set(0:3,9)
integer, save :: mass5set(0:4,3)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(3)
  integer, save :: momenta_16(3)
  integer, save :: momenta_17(3)
  integer, save :: momenta_18(3)
  integer, save :: momenta_19(3)
  integer, save :: momenta_20(3)
  integer, save :: momenta_21(3)
  integer, save :: momenta_22(3)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(4)
  integer, save :: momenta_41(4)
  integer, save :: momenta_42(4)
  integer, save :: momenta_43(4)
  integer, save :: momenta_44(4)
  integer, save :: momenta_45(4)
  integer, save :: momenta_46(4)
  integer, save :: momenta_47(4)
  integer, save :: momenta_48(4)
  integer, save :: momenta_49(4)
  integer, save :: momenta_50(4)
  integer, save :: momenta_51(4)
  integer, save :: momenta_52(4)
  integer, save :: momenta_53(4)
  integer, save :: momenta_54(5)
  integer, save :: momenta_55(5)
  integer, save :: momenta_56(5)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(2)
  integer, save :: masses2_8(3)
  integer, save :: masses2_9(3)
  integer, save :: masses2_10(3)
  integer, save :: masses2_11(3)
  integer, save :: masses2_12(3)
  integer, save :: masses2_13(3)
  integer, save :: masses2_14(3)
  integer, save :: masses2_15(3)
  integer, save :: masses2_16(3)
  integer, save :: masses2_17(3)
  integer, save :: masses2_18(4)
  integer, save :: masses2_19(4)
  integer, save :: masses2_20(4)
  integer, save :: masses2_21(4)
  integer, save :: masses2_22(4)
  integer, save :: masses2_23(4)
  integer, save :: masses2_24(4)
  integer, save :: masses2_25(4)
  integer, save :: masses2_26(4)
  integer, save :: masses2_27(4)
  integer, save :: masses2_28(4)
  integer, save :: masses2_29(5)
  integer, save :: masses2_30(5)
  integer, save :: masses2_31(5)

type(scalarbox), save :: ScalarBoxes(14)

integer, save :: sbarray_1(5)
integer, save :: sbarray_2(5)
integer, save :: sbarray_3(5)

  type(hcl), save, dimension(61) :: T0sum
  type(hcl), save, dimension(3) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppvvv_bbxawwx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,1,4,2,G0H2,1)
  call hol_allocation(4,5,4,2,G1H2,30)
  call hol_allocation(4,15,4,2,G2H2,8)
  call hol_allocation(4,1,4,3,G0H3,1)
  call hol_allocation(4,5,4,3,G1H3,33)
  call hol_allocation(4,15,4,3,G2H3,8)
  call hol_allocation(4,1,4,4,G0H4,8)
  call hol_allocation(4,5,4,4,G1H4,8)
  call hol_allocation(4,1,4,6,G0H6,3)
  call hol_allocation(4,5,4,6,G1H6,18)
  call hol_allocation(4,15,4,6,G2H6,3)
  call hol_allocation(4,1,4,8,G0H8,1)
  call hol_allocation(4,5,4,8,G1H8,6)
  call hol_allocation(4,1,4,12,G0H12,3)
  call hol_allocation(4,5,4,12,G1H12,4)
  call hol_allocation(4,15,4,12,G2H12,1)
  call hol_allocation(4,1,4,24,G0H24,1)
  call hol_allocation(4,5,4,24,G1H24,5)
  call hol_allocation(4,1,4,72,G0H72,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppvvv_bbxawwx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,1,4,min(nhel,2),G0H2,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,30)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,8)
  call hol_allocation(4,1,4,min(nhel,3),G0H3,1)
  call hol_allocation(4,5,4,min(nhel,3),G1H3,33)
  call hol_allocation(4,15,4,min(nhel,3),G2H3,8)
  call hol_allocation(4,1,4,min(nhel,4),G0H4,8)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,8)
  call hol_allocation(4,1,4,min(nhel,6),G0H6,3)
  call hol_allocation(4,5,4,min(nhel,6),G1H6,18)
  call hol_allocation(4,15,4,min(nhel,6),G2H6,3)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,1)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,6)
  call hol_allocation(4,1,4,min(nhel,12),G0H12,3)
  call hol_allocation(4,5,4,min(nhel,12),G1H12,4)
  call hol_allocation(4,15,4,min(nhel,12),G2H12,1)
  call hol_allocation(4,1,4,min(nhel,24),G0H24,1)
  call hol_allocation(4,5,4,min(nhel,24),G1H24,5)
  call hol_allocation(4,1,4,min(nhel,72),G0H72,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G0H2,1,dmode)
  call hol_deallocation(G1H2,30,dmode)
  call hol_deallocation(G2H2,8,dmode)
  call hol_deallocation(G0H3,1,dmode)
  call hol_deallocation(G1H3,33,dmode)
  call hol_deallocation(G2H3,8,dmode)
  call hol_deallocation(G0H4,8,dmode)
  call hol_deallocation(G1H4,8,dmode)
  call hol_deallocation(G0H6,3,dmode)
  call hol_deallocation(G1H6,18,dmode)
  call hol_deallocation(G2H6,3,dmode)
  call hol_deallocation(G0H8,1,dmode)
  call hol_deallocation(G1H8,6,dmode)
  call hol_deallocation(G0H12,3,dmode)
  call hol_deallocation(G1H12,4,dmode)
  call hol_deallocation(G2H12,1,dmode)
  call hol_deallocation(G0H24,1,dmode)
  call hol_deallocation(G1H24,5,dmode)
  call hol_deallocation(G0H72,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 138)
call hcl_allocation(5,G1tensor, 70)
call hcl_allocation(15,G2tensor, 64)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 138,dmode)
call hcl_deallocation(G1tensor, 70,dmode)
call hcl_deallocation(G2tensor, 64,dmode)

    call hcl_deallocation(T0sum,61,dmode)
  call hcl_deallocation(T1sum,3,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,61)
  call hcl_allocation(5,T1sum,3)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppvvv_bbxawwx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppvvv_bbxawwx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,61
    call init_hcl(T0sum(i))
  end do
  do i = 1,3
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T1sum(3)%cmp, 4)
  call scale_one_tsum(T0sum(1)%cmp, 2)
  call scale_one_tsum(T0sum(2)%cmp, 2)
  call scale_one_tsum(T0sum(3)%cmp, 2)
  call scale_one_tsum(T0sum(4)%cmp, 2)
  call scale_one_tsum(T0sum(5)%cmp, 2)
  call scale_one_tsum(T0sum(6)%cmp, 2)
  call scale_one_tsum(T0sum(7)%cmp, 2)
  call scale_one_tsum(T0sum(8)%cmp, 2)
  call scale_one_tsum(T0sum(9)%cmp, 2)
  call scale_one_tsum(T0sum(10)%cmp, 2)
  call scale_one_tsum(T0sum(11)%cmp, 2)
  call scale_one_tsum(T0sum(12)%cmp, 2)
  call scale_one_tsum(T0sum(13)%cmp, 2)
  call scale_one_tsum(T0sum(14)%cmp, 2)
  call scale_one_tsum(T0sum(15)%cmp, 0)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, 0)
  call scale_one_tsum(T0sum(40)%cmp, -2)
  call scale_one_tsum(T0sum(41)%cmp, -2)
  call scale_one_tsum(T0sum(42)%cmp, -2)
  call scale_one_tsum(T0sum(43)%cmp, -2)
  call scale_one_tsum(T0sum(44)%cmp, -2)
  call scale_one_tsum(T0sum(45)%cmp, -2)
  call scale_one_tsum(T0sum(46)%cmp, -2)
  call scale_one_tsum(T0sum(47)%cmp, -2)
  call scale_one_tsum(T0sum(48)%cmp, -2)
  call scale_one_tsum(T0sum(49)%cmp, -2)
  call scale_one_tsum(T0sum(50)%cmp, -2)
  call scale_one_tsum(T0sum(51)%cmp, -2)
  call scale_one_tsum(T0sum(52)%cmp, -2)
  call scale_one_tsum(T0sum(53)%cmp, -2)
  call scale_one_tsum(T0sum(54)%cmp, -2)
  call scale_one_tsum(T0sum(55)%cmp, -2)
  call scale_one_tsum(T0sum(56)%cmp, -2)
  call scale_one_tsum(T0sum(57)%cmp, -2)
  call scale_one_tsum(T0sum(58)%cmp, -2)
  call scale_one_tsum(T0sum(59)%cmp, -2)
  call scale_one_tsum(T0sum(60)%cmp, -2)
  call scale_one_tsum(T0sum(61)%cmp, -2)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 16, 15 ]
  momenta_3 = [ 17, 14 ]
  momenta_4 = [ 19, 12 ]
  momenta_5 = [ 20, 11 ]
  momenta_6 = [ 21, 10 ]
  momenta_7 = [ 23, 8 ]
  momenta_8 = [ 24, 7 ]
  momenta_9 = [ 25, 6 ]
  momenta_10 = [ 26, 5 ]
  momenta_11 = [ 27, 4 ]
  momenta_12 = [ 28, 3 ]
  momenta_13 = [ 29, 2 ]
  momenta_14 = [ 30, 1 ]
  momenta_15 = [ 16, 1, 14 ]
  momenta_16 = [ 16, 3, 12 ]
  momenta_17 = [ 16, 4, 11 ]
  momenta_18 = [ 16, 5, 10 ]
  momenta_19 = [ 16, 7, 8 ]
  momenta_20 = [ 16, 11, 4 ]
  momenta_21 = [ 17, 2, 12 ]
  momenta_22 = [ 17, 4, 10 ]
  momenta_23 = [ 17, 6, 8 ]
  momenta_24 = [ 17, 10, 4 ]
  momenta_25 = [ 19, 4, 8 ]
  momenta_26 = [ 19, 8, 4 ]
  momenta_27 = [ 20, 1, 10 ]
  momenta_28 = [ 20, 3, 8 ]
  momenta_29 = [ 21, 2, 8 ]
  momenta_30 = [ 24, 1, 6 ]
  momenta_31 = [ 24, 2, 5 ]
  momenta_32 = [ 24, 3, 4 ]
  momenta_33 = [ 24, 4, 3 ]
  momenta_34 = [ 24, 5, 2 ]
  momenta_35 = [ 25, 2, 4 ]
  momenta_36 = [ 26, 1, 4 ]
  momenta_37 = [ 26, 4, 1 ]
  momenta_38 = [ 28, 1, 2 ]
  momenta_39 = [ 28, 2, 1 ]
  momenta_40 = [ 16, 1, 2, 12 ]
  momenta_41 = [ 16, 1, 6, 8 ]
  momenta_42 = [ 16, 1, 10, 4 ]
  momenta_43 = [ 16, 3, 4, 8 ]
  momenta_44 = [ 16, 3, 8, 4 ]
  momenta_45 = [ 16, 4, 1, 10 ]
  momenta_46 = [ 16, 4, 3, 8 ]
  momenta_47 = [ 16, 5, 2, 8 ]
  momenta_48 = [ 17, 2, 4, 8 ]
  momenta_49 = [ 17, 2, 8, 4 ]
  momenta_50 = [ 20, 1, 2, 8 ]
  momenta_51 = [ 24, 1, 2, 4 ]
  momenta_52 = [ 24, 2, 1, 4 ]
  momenta_53 = [ 24, 4, 1, 2 ]
  momenta_54 = [ 16, 1, 2, 4, 8 ]
  momenta_55 = [ 16, 1, 2, 8, 4 ]
  momenta_56 = [ 16, 4, 1, 2, 8 ]

  masses2_1 = [ nMB, 0 ]
  masses2_2 = [ nMT, 0 ]
  masses2_3 = [ 0, nMB ]
  masses2_4 = [ nMB, nMB ]
  masses2_5 = [ nMT, nMB ]
  masses2_6 = [ 0, nMT ]
  masses2_7 = [ nMT, nMT ]
  masses2_8 = [ nMB, 0, nMB ]
  masses2_9 = [ nMT, 0, nMB ]
  masses2_10 = [ nMT, 0, nMT ]
  masses2_11 = [ nMB, nMB, 0 ]
  masses2_12 = [ nMT, nMB, 0 ]
  masses2_13 = [ 0, nMB, nMB ]
  masses2_14 = [ nMB, nMB, nMB ]
  masses2_15 = [ nMT, nMB, nMB ]
  masses2_16 = [ nMT, nMB, nMT ]
  masses2_17 = [ 0, nMT, nMT ]
  masses2_18 = [ nMB, 0, nMB, nMB ]
  masses2_19 = [ nMT, 0, nMB, nMB ]
  masses2_20 = [ nMB, 0, nMB, nMT ]
  masses2_21 = [ nMT, 0, nMB, nMT ]
  masses2_22 = [ nMB, nMB, 0, nMB ]
  masses2_23 = [ nMT, nMB, 0, nMB ]
  masses2_24 = [ nMT, nMB, 0, nMT ]
  masses2_25 = [ nMB, nMB, nMB, 0 ]
  masses2_26 = [ nMT, nMB, nMB, 0 ]
  masses2_27 = [ nMT, nMB, nMB, nMB ]
  masses2_28 = [ nMT, nMB, nMB, nMT ]
  masses2_29 = [ nMT, nMB, 0, nMB, nMB ]
  masses2_30 = [ nMT, nMB, 0, nMB, nMT ]
  masses2_31 = [ nMT, nMB, nMB, 0, nMB ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5]
sbarray_2 = [6, 7, 8, 9, 10]
sbarray_3 = [11, 12, 13, 9, 14]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_53, masses2_25, T0sum(1), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_45, masses2_26, T0sum(2), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_51, masses2_22, T0sum(3), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_40, masses2_23, T0sum(4), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_50, masses2_23, T0sum(5), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_47, masses2_23, T0sum(6), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_46, masses2_27, T0sum(7), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_48, masses2_19, T0sum(8), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_43, masses2_27, T0sum(9), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_41, masses2_23, T0sum(10), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_49, masses2_21, T0sum(11), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_44, masses2_28, T0sum(12), M2,[12], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_42, masses2_24, T0sum(13), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_52, masses2_22, T0sum(14), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_37, masses2_13, T0sum(15), M2)
  call TI_call_OL(0,0, momenta_38, masses2_11, T0sum(16), M2)
  call TI_call_OL(0,0, momenta_27, masses2_12, T0sum(17), M2)
  call TI_call_OL(0,0, momenta_18, masses2_12, T0sum(18), M2)
  call TI_call_OL(0,0, momenta_17, masses2_15, T0sum(19), M2)
  call TI_call_OL(0,0, momenta_21, masses2_9, T0sum(20), M2)
  call TI_call_OL(0,0, momenta_16, masses2_15, T0sum(21), M2)
  call TI_call_OL(0,0, momenta_15, masses2_12, T0sum(22), M2)
  call TI_call_OL(0,0, momenta_33, masses2_14, T0sum(23), M2)
  call TI_call_OL(0,0, momenta_30, masses2_11, T0sum(24), M2)
  call TI_call_OL(0,0, momenta_34, masses2_11, T0sum(25), M2)
  call TI_call_OL(0,0, momenta_35, masses2_8, T0sum(26), M2)
  call TI_call_OL(0,0, momenta_32, masses2_14, T0sum(27), M2)
  call TI_call_OL(0,0, momenta_29, masses2_9, T0sum(28), M2)
  call TI_call_OL(0,0, momenta_28, masses2_15, T0sum(29), M2)
  call TI_call_OL(0,0, momenta_39, masses2_11, T0sum(30), M2)
  call TI_call_OL(0,0, momenta_31, masses2_11, T0sum(31), M2)
  call TI_call_OL(0,0, momenta_19, masses2_15, T0sum(32), M2)
  call TI_call_OL(0,0, momenta_25, masses2_15, T0sum(33), M2)
  call TI_call_OL(0,0, momenta_23, masses2_9, T0sum(34), M2)
  call TI_call_OL(0,0, momenta_26, masses2_16, T0sum(35), M2)
  call TI_call_OL(0,0, momenta_24, masses2_10, T0sum(36), M2)
  call TI_call_OL(0,0, momenta_20, masses2_16, T0sum(37), M2)
  call TI_call_OL(0,0, momenta_36, masses2_8, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_22, masses2_17, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_11, masses2_4, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_14, masses2_3, T0sum(41), M2)
  call TI_call_OL(0,0, momenta_10, masses2_3, T0sum(42), M2)
  call TI_call_OL(0,0, momenta_1, masses2_1, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_12, masses2_4, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_6, masses2_2, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_5, masses2_5, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_2, masses2_5, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_4, masses2_5, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_3, masses2_2, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_8, masses2_4, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_7, masses2_5, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_13, masses2_3, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_11, masses2_7, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_6, masses2_6, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_3, masses2_6, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_9, masses2_3, T0sum(61), M2)

  call TI_call_OL(0,1, momenta_56, masses2_31, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_54, masses2_29, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_55, masses2_30, T1sum(3), M2,sbarray_3, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppvvv_bbxawwx_1_/**/REALKIND
