
module ol_vamp_1_ppvvv_uxdwwxwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv_uxdwwxwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv_uxdwwxwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvv_uxdwwxwx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvv_uxdwwxwx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvv_uxdwwxwx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvv_uxdwwxwx_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(108)
  type(Hpolcont), intent(in) :: M(1,108)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(4)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(1),h0tab(:,1),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_AW_Q(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,1),heltab2x108(:,:,1))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(1),n2h36(1))
Gcoeff(:)%j = (c(4)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(2),h0tab(:,2),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,2),heltab2x108(:,:,2))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(2),n2h36(2))
  call Hloop_AQ_V(ntryL,G1H36(1),ex2(:),G1H18(1),m3h2x18(:,1),heltab2x36(:,:,1))
  call Hloop_QA_V(ntryL,G1H36(2),ex1(:),G1H18(2),m3h2x18(:,2),heltab2x36(:,:,2))
  call Hloop_VA_Q(ntryL,G1H18(1),ex1(:),G1H9(1),m3h2x9(:,1),heltab2x18(:,:,1))
  call Hloop_A_Q(ntryL,G1H9(1),19,0,G2H9(1),n2h9(1))
  call Hloop_VQ_A(ntryL,G1H18(2),ex2(:),G1H9(1),m3h2x9(:,2),heltab2x18(:,:,2))
  call Hloop_Q_A(ntryL,G1H9(1),19,0,G2H9(2),n2h9(2))
call Hotf_5pt_reduction(G2H9(1),RedSet_5(1),mass5set(:,1),  & 
G1H9(1),G1H9(2),G1H9(3),G1H9(4),G1H9(5),G1H9(6),9)
call HG1shiftOLR(G1H9(2),4,9)
call Hotf_5pt_reduction(G2H9(2),RedSet_5(2),mass5set(:,1),  & 
G1H9(7),G1H9(8),G1H9(9),G1H9(10),G1H9(11),G1H9(12),9)
call HG1shiftOLR(G1H9(8),4,9)
  call Hloop_AW_Q(ntryL,G1H9(1),ex4(:),G1H3(1),m3h3x3(:,1),heltab2x9(:,:,1))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(1),n2h3(1))
call HGT_OLR(G1H9(2),1,1,9)
call HGT_invQ_OLR(G1H9(2),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(2),-4,0,G2H9(1),n2h9(3))
  call Hloop_QW_A(ntryL,G2H9(1),ex3(:),G2H3(2),m3h3x3(:,2),heltab2x9(:,:,2))
  call Hloop_AW_Q(ntryL,G1H9(5),ex4(:),G1H3(1),m3h3x3(:,3),heltab2x9(:,:,3))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(3),n2h3(2))
  call Hloop_AW_Q(ntryL,G1H9(6),ex4(:),G1H3(1),m3h3x3(:,4),heltab2x9(:,:,4))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(4),n2h3(3))
  call Hloop_QW_A(ntryL,G1H9(7),ex4(:),G1H3(1),m3h3x3(:,5),heltab2x9(:,:,5))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(5),n2h3(4))
call HGT_OLR(G1H9(8),1,1,9)
call HGT_invQ_OLR(G1H9(8),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(8),-4,0,G2H9(2),n2h9(4))
  call Hloop_AW_Q(ntryL,G2H9(2),ex3(:),G2H3(6),m3h3x3(:,6),heltab2x9(:,:,6))
  call Hloop_QW_A(ntryL,G1H9(11),ex4(:),G1H3(1),m3h3x3(:,7),heltab2x9(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(7),n2h3(5))
  call Hloop_QW_A(ntryL,G1H9(12),ex4(:),G1H3(1),m3h3x3(:,8),heltab2x9(:,:,8))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(8),n2h3(6))
call Hotf_5pt_reduction(G2H3(1),RedSet_5(1),mass5set(:,1),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),G1H3(6),3)
call HG1shiftOLR(G1H3(2),4,3)
call Hotf_4pt_reduction(G2H3(4),RedSet_4(1),mass4set(:,1),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),3)
call HG1shiftOLR(G1H3(8),12,3)
call Hotf_5pt_reduction(G2H3(5),RedSet_5(2),mass5set(:,1),  & 
G1H3(12),G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),3)
call HG1shiftOLR(G1H3(13),4,3)
call Hotf_4pt_reduction(G2H3(8),RedSet_4(2),mass4set(:,1),  & 
G1H3(18),G1H3(19),G1H3(20),G1H3(21),G1H3(22),3)
call HG1shiftOLR(G1H3(19),12,3)
  call ol_merge(ntryL,G1H3(7),[G1H3(6)])
  call ol_merge(ntryL,G1H3(18),[G1H3(17)])
  call Hloop_AW_Q(ntryL,G1H3(1),ex3(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(1))
  call Hloop_AW_Q(ntryL,G1H3(2),ex3(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(2),n2h1(2))
  call Hloop_AW_Q(ntryL,G1H3(7),ex3(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(3))
  call Hloop_AW_Q(ntryL,G1H3(8),ex3(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(4),n2h1(4))
  call Hloop_QW_A(ntryL,G1H3(12),ex3(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(5))
  call Hloop_QW_A(ntryL,G1H3(13),ex3(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(6),n2h1(6))
  call Hloop_QW_A(ntryL,G1H3(18),ex3(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(7))
  call Hloop_QW_A(ntryL,G1H3(19),ex3(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(8),n2h1(8))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),4)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),4)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(3),h0tab(:,3),[16,2,9,4],[0,0,0,0],4,1,wf6(:,3))
  call Hloop_AW_Q(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,3),heltab2x108(:,:,3))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(1),n2h36(3))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(20)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(4),h0tab(:,4),[16,1,10,4],[0,0,0,0],4,1,wf6(:,8))
  call Hloop_QW_A(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,4),heltab2x108(:,:,4))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(2),n2h36(4))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(5),h0tab(:,5),[16,1,2,12],[0,0,0,0],4,1,wf9(:,2))
  call Hloop_QW_A(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,5),heltab2x108(:,:,5))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(3),n2h36(5))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(6),h0tab(:,6),[16,1,2,12],[0,0,0,0],4,1,wf9(:,3))
  call Hloop_QW_A(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,6),heltab2x108(:,:,6))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(4),n2h36(6))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(7),h0tab(:,7),[16,2,1,12],[0,0,0,0],4,1,wf9(:,2))
  call Hloop_AW_Q(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,7),heltab2x108(:,:,7))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(5),n2h36(7))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(8),h0tab(:,8),[16,2,1,12],[0,0,0,0],4,1,wf9(:,3))
  call Hloop_AW_Q(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,8),heltab2x108(:,:,8))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(6),n2h36(8))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(9),h0tab(:,9),[17,2,8,4],[0,0,0,0],4,1,wf6(:,7))
  call Hloop_QA_V(ntryL,G0H108(1),wf6(:,7),G0H18(1),m3h6x18(:,1),heltab2x108(:,:,9))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(10),h0tab(:,10),[18,1,8,4],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H108(1),wf6(:,4),G0H18(2),m3h6x18(:,2),heltab2x108(:,:,10))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(11),h0tab(:,11),[20,2,1,8],[0,0,0,0],4,1,wf9(:,5))
  call Hloop_AV_Q(ntryL,G0H108(1),wf9(:,5),G0H12(1),m3h9x12(:,1),heltab2x108(:,:,11))
  call Hloop_A_Q(ntryL,G0H12(1),20,0,G1H12(1),n2h12(1))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(12),h0tab(:,12),[20,2,1,8],[0,0,0,0],4,1,wf9(:,6))
  call Hloop_AZ_Q(ntryL,G0H108(1),wf9(:,6),G0H12(1),ngZd,m3h9x12(:,2),heltab2x108(:,:,12))
  call Hloop_A_Q(ntryL,G0H12(1),20,0,G1H12(2),n2h12(2))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(13),h0tab(:,13),[20,1,2,8],[0,0,0,0],4,1,wf9(:,5))
  call Hloop_QV_A(ntryL,G0H108(1),wf9(:,5),G0H12(1),m3h9x12(:,3),heltab2x108(:,:,13))
  call Hloop_Q_A(ntryL,G0H12(1),20,0,G1H12(3),n2h12(3))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(14),h0tab(:,14),[20,1,2,8],[0,0,0,0],4,1,wf9(:,6))
  call Hloop_QZ_A(ntryL,G0H108(1),wf9(:,6),G0H12(1),ngZu,m3h9x12(:,4),heltab2x108(:,:,14))
  call Hloop_Q_A(ntryL,G0H12(1),20,0,G1H12(4),n2h12(4))
  call ol_merge(ntryL,G1H12(2),[G1H12(1)])
  call ol_merge(ntryL,G1H12(4),[G1H12(3)])
  call Hloop_AQ_V(ntryL,G1H36(1),ex2(:),G1H18(1),m3h2x18(:,3),heltab2x36(:,:,3))
  call Hloop_QA_V(ntryL,G1H36(2),ex1(:),G1H18(2),m3h2x18(:,4),heltab2x36(:,:,4))
  call Hloop_QA_V(ntryL,G1H36(3),ex1(:),G1H18(3),m3h2x18(:,5),heltab2x36(:,:,5))
  call Hloop_QA_V(ntryL,G1H36(4),ex1(:),G1H18(4),m3h2x18(:,6),heltab2x36(:,:,6))
  call Hloop_AQ_V(ntryL,G1H36(5),ex2(:),G1H18(5),m3h2x18(:,7),heltab2x36(:,:,7))
  call Hloop_AQ_V(ntryL,G1H36(6),ex2(:),G1H18(6),m3h2x18(:,8),heltab2x36(:,:,8))
  call Hloop_VQ_A(ntryL,G0H18(1),ex2(:),G0H9(1),m3h2x9(:,3),heltab2x18(:,:,3))
  call Hloop_Q_A(ntryL,G0H9(1),19,0,G1H9(1),n2h9(5))
  call Hloop_VA_Q(ntryL,G0H18(2),ex1(:),G0H9(1),m3h2x9(:,4),heltab2x18(:,:,4))
  call Hloop_A_Q(ntryL,G0H9(1),19,0,G1H9(2),n2h9(6))
  call Hloop_AQ_V(ntryL,G1H12(2),ex2(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_QA_V(ntryL,G1H12(4),ex1(:),G1H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call ol_merge(ntryL,G1H9(2),[G1H9(3)])
  call ol_merge(ntryL,G1H9(1),[G1H9(9)])
  call Hloop_AW_Q(ntryL,G1H9(2),ex4(:),G1H3(6),m3h3x3(:,9),heltab2x9(:,:,9))
  call Hloop_A_Q(ntryL,G1H3(6),27,0,G2H3(1),n2h3(7))
  call Hloop_AW_Q(ntryL,G1H9(4),ex4(:),G1H3(17),m3h3x3(:,10),heltab2x9(:,:,10))
  call Hloop_A_Q(ntryL,G1H3(17),27,0,G2H3(4),n2h3(8))
  call Hloop_QW_A(ntryL,G1H9(1),ex4(:),G1H3(1),m3h3x3(:,11),heltab2x9(:,:,11))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(5),n2h3(9))
  call Hloop_QW_A(ntryL,G1H9(10),ex4(:),G1H3(2),m3h3x3(:,12),heltab2x9(:,:,12))
  call Hloop_Q_A(ntryL,G1H3(2),27,0,G2H3(8),n2h3(10))
  call Hloop_VA_Q(ntryL,G1H18(1),wf6(:,3),G1H3(7),m3h6x3(:,1),heltab2x18(:,:,5))
  call Hloop_A_Q(ntryL,G1H3(7),27,0,G2H3(9),n2h3(11))
  call Hloop_VQ_A(ntryL,G1H18(2),wf6(:,8),G1H3(8),m3h6x3(:,2),heltab2x18(:,:,6))
  call Hloop_Q_A(ntryL,G1H3(8),27,0,G2H3(10),n2h3(12))
  call Hloop_VQ_A(ntryL,G1H18(3),ex2(:),G1H9(5),m3h2x9(:,5),heltab2x18(:,:,7))
  call Hloop_Q_A(ntryL,G1H9(5),19,0,G2H9(1),n2h9(7))
  call Hloop_VQ_A(ntryL,G1H18(4),ex2(:),G1H9(6),m3h2x9(:,6),heltab2x18(:,:,8))
  call Hloop_Q_A(ntryL,G1H9(6),19,0,G2H9(2),n2h9(8))
  call Hloop_VA_Q(ntryL,G1H18(5),ex1(:),G1H9(7),m3h2x9(:,7),heltab2x18(:,:,9))
  call Hloop_A_Q(ntryL,G1H9(7),19,0,G2H9(3),n2h9(9))
  call Hloop_VA_Q(ntryL,G1H18(6),ex1(:),G1H9(8),m3h2x9(:,8),heltab2x18(:,:,10))
  call Hloop_A_Q(ntryL,G1H9(8),19,0,G2H9(4),n2h9(10))
  call Hloop_VA_Q(ntryL,G1H6(1),ex1(:),G1H3(12),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_A_Q(ntryL,G1H3(12),23,0,G2H3(11),n2h3(13))
  call Hloop_VQ_A(ntryL,G1H6(2),ex2(:),G1H3(13),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_Q_A(ntryL,G1H3(13),23,0,G2H3(12),n2h3(14))
call HGT_OLR(G2H3(2),1,1,3)
call HGT_invQ_OLR(G2H3(2),2,5,3)
call HGT_OLR(G2H3(2),6,15,3)
  call ol_merge(ntryL,G2H3(2),[G2H3(11)])
  call ol_merge(ntryL,G2H3(9),[G2H3(3),G1H3(5)])
call HGT_OLR(G2H3(6),1,1,3)
call HGT_invQ_OLR(G2H3(6),2,5,3)
call HGT_OLR(G2H3(6),6,15,3)
  call ol_merge(ntryL,G2H3(6),[G2H3(12)])
  call ol_merge(ntryL,G2H3(10),[G2H3(7),G1H3(16)])
  call ol_merge(ntryL,G2H3(1),[G1H3(3)])
  call ol_merge(ntryL,G2H3(4),[G1H3(4)])
  call ol_merge(ntryL,G2H3(5),[G1H3(14)])
  call ol_merge(ntryL,G2H3(8),[G1H3(15)])
call Hotf_4pt_reduction(G2H3(2),RedSet_4(10),mass4set(:,1),  & 
G1H3(18),G1H3(19),G1H3(6),G1H3(17),G1H3(1),3)
call HG1shiftOLR(G1H3(19),8,3)
call Hotf_4pt_reduction(G2H3(9),RedSet_4(5),mass4set(:,1),  & 
G1H3(2),G1H3(7),G1H3(8),G1H3(12),G1H3(13),3)
call HG1shiftOLR(G1H3(7),4,3)
call Hotf_4pt_reduction(G2H3(6),RedSet_4(11),mass4set(:,1),  & 
G1H3(5),G1H3(16),G1H3(3),G1H3(4),G1H3(14),3)
call HG1shiftOLR(G1H3(16),8,3)
call Hotf_4pt_reduction(G2H3(10),RedSet_4(8),mass4set(:,1),  & 
G1H3(15),G1H3(23),G1H3(24),G1H3(25),G1H3(26),3)
call HG1shiftOLR(G1H3(23),4,3)
call Hotf_4pt_reduction(G2H3(1),RedSet_4(3),mass4set(:,1),  & 
G1H3(27),G1H3(28),G1H3(29),G1H3(30),G1H3(31),3)
call HG1shiftOLR(G1H3(28),4,3)
call Hotf_4pt_reduction(G2H3(4),RedSet_4(4),mass4set(:,1),  & 
G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
call HG1shiftOLR(G1H3(33),4,3)
  call Hloop_AW_Q(ntryL,G1H3(9),ex3(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(9))
  call Hloop_AW_Q(ntryL,G1H3(10),ex3(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(10))
  call Hloop_AW_Q(ntryL,G1H3(11),ex3(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(11))
call Hotf_4pt_reduction(G2H3(5),RedSet_4(7),mass4set(:,1),  & 
G1H3(9),G1H3(10),G1H3(11),G1H3(37),G1H3(38),3)
call HG1shiftOLR(G1H3(10),4,3)
call Hotf_4pt_reduction(G2H3(8),RedSet_4(4),mass4set(:,1),  & 
G1H3(39),G1H3(40),G1H3(41),G1H3(42),G1H3(43),3)
call HG1shiftOLR(G1H3(40),4,3)
  call Hloop_QW_A(ntryL,G1H3(20),ex3(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(12))
  call Hloop_QW_A(ntryL,G1H3(21),ex3(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(13))
  call Hloop_QW_A(ntryL,G1H3(22),ex3(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(14))
call Hotf_4pt_reduction(G2H9(1),RedSet_4(2),mass4set(:,1),  & 
G1H9(11),G1H9(12),G1H9(3),G1H9(9),G1H9(2),9)
call HG1shiftOLR(G1H9(12),12,9)
call Hotf_4pt_reduction(G2H9(2),RedSet_4(2),mass4set(:,1),  & 
G1H9(4),G1H9(1),G1H9(10),G1H9(5),G1H9(6),9)
call HG1shiftOLR(G1H9(1),12,9)
call Hotf_4pt_reduction(G2H9(3),RedSet_4(1),mass4set(:,1),  & 
G1H9(7),G1H9(8),G1H9(13),G1H9(14),G1H9(15),9)
call HG1shiftOLR(G1H9(8),12,9)
call Hotf_4pt_reduction(G2H9(4),RedSet_4(1),mass4set(:,1),  & 
G1H9(16),G1H9(17),G1H9(18),G1H9(19),G1H9(20),9)
call HG1shiftOLR(G1H9(17),12,9)
  call Hloop_AW_Q(ntryL,G1H3(18),ex4(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(15))
  call Hloop_AW_Q(ntryL,G1H3(19),ex4(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(14),n2h1(16))
  call Hloop_AW_Q(ntryL,G1H3(1),ex4(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(17))
  call Hloop_AW_Q(ntryL,G1H3(2),ex3(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(18))
  call Hloop_AW_Q(ntryL,G1H3(7),ex3(:),G1H1(1),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(17),n2h1(19))
  call Hloop_AW_Q(ntryL,G1H3(13),ex3(:),G1H1(1),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(18),n2h1(20))
  call Hloop_QW_A(ntryL,G1H3(5),ex4(:),G1H1(1),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(21))
  call Hloop_QW_A(ntryL,G1H3(16),ex4(:),G1H1(1),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(20),n2h1(22))
  call Hloop_QW_A(ntryL,G1H3(14),ex4(:),G1H1(1),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(23))
  call Hloop_QW_A(ntryL,G1H3(15),ex3(:),G1H1(1),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(24))
  call Hloop_QW_A(ntryL,G1H3(23),ex3(:),G1H1(1),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(23),n2h1(25))
  call Hloop_QW_A(ntryL,G1H3(26),ex3(:),G1H1(1),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(26))
  call Hloop_AW_Q(ntryL,G1H3(27),ex3(:),G1H1(1),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(27))
  call Hloop_AW_Q(ntryL,G1H3(28),ex3(:),G1H1(1),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(26),n2h1(28))
  call Hloop_AW_Q(ntryL,G1H3(31),ex3(:),G1H1(1),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(29))
  call Hloop_AW_Q(ntryL,G1H3(32),ex3(:),G1H1(1),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(30))
  call Hloop_AW_Q(ntryL,G1H3(33),ex3(:),G1H1(1),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(29),n2h1(31))
  call Hloop_AW_Q(ntryL,G1H3(36),ex3(:),G1H1(1),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(30),n2h1(32))
  call Hloop_QW_A(ntryL,G1H3(9),ex3(:),G1H1(1),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(33))
  call Hloop_QW_A(ntryL,G1H3(10),ex3(:),G1H1(1),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(32),n2h1(34))
  call Hloop_QW_A(ntryL,G1H3(38),ex3(:),G1H1(1),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(35))
  call Hloop_QW_A(ntryL,G1H3(39),ex3(:),G1H1(1),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(36))
  call Hloop_QW_A(ntryL,G1H3(40),ex3(:),G1H1(1),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(35),n2h1(37))
  call Hloop_QW_A(ntryL,G1H3(43),ex3(:),G1H1(1),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(38))
  call Hloop_QV_A(ntryL,G1H9(11),wf9(:,2),G1H1(1),m3h9x1(:,1),heltab2x9(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(39))
  call Hloop_QV_A(ntryL,G1H9(12),wf9(:,2),G1H1(1),m3h9x1(:,2),heltab2x9(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(38),n2h1(40))
  call Hloop_QV_A(ntryL,G1H9(2),wf9(:,2),G1H1(1),m3h9x1(:,3),heltab2x9(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(41))
  call Hloop_QZ_A(ntryL,G1H9(4),wf9(:,3),G1H1(1),ngZd,m3h9x1(:,4),heltab2x9(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(42))
  call Hloop_QZ_A(ntryL,G1H9(1),wf9(:,3),G1H1(1),ngZd,m3h9x1(:,5),heltab2x9(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(41),n2h1(43))
  call Hloop_QZ_A(ntryL,G1H9(6),wf9(:,3),G1H1(1),ngZd,m3h9x1(:,6),heltab2x9(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(42),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H9(7),wf9(:,2),G1H1(1),m3h9x1(:,7),heltab2x9(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H9(8),wf9(:,2),G1H1(1),m3h9x1(:,8),heltab2x9(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(44),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H9(15),wf9(:,2),G1H1(1),m3h9x1(:,9),heltab2x9(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(47))
  call Hloop_AZ_Q(ntryL,G1H9(16),wf9(:,3),G1H1(1),ngZu,m3h9x1(:,10),heltab2x9(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(46),n2h1(48))
  call Hloop_AZ_Q(ntryL,G1H9(17),wf9(:,3),G1H1(1),ngZu,m3h9x1(:,11),heltab2x9(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(47),n2h1(49))
  call Hloop_AZ_Q(ntryL,G1H9(20),wf9(:,3),G1H1(1),ngZu,m3h9x1(:,12),heltab2x9(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(50))
  call ol_merge_tensors(G2tensor(13),[G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(43),G2tensor(3),G1tensor(6)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(6),G1tensor(8)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(37),G2tensor(7),G1tensor(12)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(28),G1tensor(10),G1tensor(4)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(11)])
call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(10),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(2),G1tensor(6),G1tensor(8))
call G_TensorShift(G1tensor(7),8)
call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(1),mass4set(:,1),  & 
G1tensor(12),G1tensor(3),G1tensor(10),G1tensor(4),G1tensor(5))
call G_TensorShift(G1tensor(3),12)
call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(11),mass4set(:,1),  & 
G1tensor(9),G1tensor(11),G1tensor(13),G1tensor(14),G1tensor(15))
call G_TensorShift(G1tensor(11),8)
call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(2),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
call G_TensorShift(G1tensor(17),12)
call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(3),mass4set(:,1),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
call G_TensorShift(G1tensor(22),4)
call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(4),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(27),4)
call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(5),mass4set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
call G_TensorShift(G1tensor(32),4)
call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(7),mass4set(:,1),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
call G_TensorShift(G1tensor(37),4)
call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(8),mass4set(:,1),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
call G_TensorShift(G1tensor(42),4)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(10),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(1),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(11),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(2),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(3),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(4),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(5),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(7),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(8),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
call ol_merge_tensors(T0sum(3),[G0tensor(11)])
call ol_merge_tensors(T0sum(4),[G0tensor(16)])
call ol_merge_tensors(T0sum(5),[G0tensor(21)])
call ol_merge_tensors(T0sum(6),[G0tensor(26)])
call ol_merge_tensors(T0sum(7),[G0tensor(31)])
call ol_merge_tensors(T0sum(8),[G0tensor(36)])
call ol_merge_tensors(T0sum(9),[G0tensor(41)])
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(15),h0tab(:,15),[28,1,2],[0,0,0],3,1,wf27(:,2))
  call Hloop_QW_A(ntryL,G0H108(1),wf27(:,2),G0H4(1),m3h27x4(:,1),heltab2x108(:,:,15))
  call Hloop_Q_A(ntryL,G0H4(1),28,0,G1H4(1),n2h4(1))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(16),h0tab(:,16),[18,4,9],[0,0,0],3,2,wf6(:,4),wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H108(1),wf6(:,4),G0H18(1),m3h6x18(:,3),heltab2x108(:,:,16))
  call Hloop_Q_A(ntryL,G0H18(1),18,0,G1H18(1),n2h18(1))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(17),h0tab(:,17),[20,2,9],[0,0,0],3,2,wf9(:,5),wf6(:,3))
  call Hloop_AV_Q(ntryL,G0H108(1),wf9(:,5),G0H12(1),m3h9x12(:,5),heltab2x108(:,:,17))
  call Hloop_A_Q(ntryL,G0H12(1),20,0,G1H12(1),n2h12(5))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(18),h0tab(:,18),[20,2,9],[0,0,0],3,2,wf9(:,6),wf6(:,3))
  call Hloop_AZ_Q(ntryL,G0H108(1),wf9(:,6),G0H12(1),ngZd,m3h9x12(:,6),heltab2x108(:,:,18))
  call Hloop_A_Q(ntryL,G0H12(1),20,0,G1H12(3),n2h12(6))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(33)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(19),h0tab(:,19),[16,2,13],[0,0,0],3,1,wf18(:,9))
  call Hloop_AW_Q(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,9),heltab2x108(:,:,19))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(1),n2h36(9))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(20),h0tab(:,20),[17,4,10],[0,0,0],3,2,wf6(:,7),wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H108(1),wf6(:,7),G0H18(2),m3h6x18(:,4),heltab2x108(:,:,20))
  call Hloop_A_Q(ntryL,G0H18(2),17,0,G1H18(2),n2h18(2))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(21),h0tab(:,21),[20,1,10],[0,0,0],3,2,wf9(:,5),wf6(:,8))
  call Hloop_QV_A(ntryL,G0H108(1),wf9(:,5),G0H12(1),m3h9x12(:,7),heltab2x108(:,:,21))
  call Hloop_Q_A(ntryL,G0H12(1),20,0,G1H12(2),n2h12(7))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(22),h0tab(:,22),[20,1,10],[0,0,0],3,2,wf9(:,6),wf6(:,8))
  call Hloop_QZ_A(ntryL,G0H108(1),wf9(:,6),G0H12(1),ngZu,m3h9x12(:,8),heltab2x108(:,:,22))
  call Hloop_Q_A(ntryL,G0H12(1),20,0,G1H12(4),n2h12(8))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(23),h0tab(:,23),[16,1,14],[0,0,0],3,1,wf18(:,15))
  call Hloop_QW_A(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,10),heltab2x108(:,:,23))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(2),n2h36(10))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(24),h0tab(:,24),[17,2,12],[0,0,0],3,2,wf6(:,7),wf9(:,2))
  call Hloop_QA_V(ntryL,G0H108(1),wf6(:,7),G0H18(1),m3h6x18(:,5),heltab2x108(:,:,24))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(25),h0tab(:,25),[17,2,12],[0,0,0],3,2,wf6(:,7),wf9(:,3))
  call Hloop_QA_V(ntryL,G0H108(1),wf6(:,7),G0H18(2),m3h6x18(:,6),heltab2x108(:,:,25))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(26),h0tab(:,26),[18,1,12],[0,0,0],3,2,wf6(:,4),wf9(:,2))
  call Hloop_AQ_V(ntryL,G0H108(1),wf6(:,4),G0H18(3),m3h6x18(:,7),heltab2x108(:,:,26))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(27)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(27),h0tab(:,27),[18,1,12],[0,0,0],3,2,wf6(:,4),wf9(:,3))
  call Hloop_AQ_V(ntryL,G0H108(1),wf6(:,4),G0H18(4),m3h6x18(:,8),heltab2x108(:,:,27))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(53)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(28),h0tab(:,28),[16,2,13],[0,0,0],3,1,wf18(:,26))
  call Hloop_AW_Q(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,11),heltab2x108(:,:,28))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(3),n2h36(11))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(55)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(29),h0tab(:,29),[16,2,13],[0,0,0],3,1,wf18(:,28))
  call Hloop_AW_Q(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,12),heltab2x108(:,:,29))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(4),n2h36(12))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(49)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(30),h0tab(:,30),[16,1,14],[0,0,0],3,1,wf18(:,22))
  call Hloop_QW_A(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,13),heltab2x108(:,:,30))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(5),n2h36(13))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(31),h0tab(:,31),[16,1,14],[0,0,0],3,1,wf18(:,24))
  call Hloop_QW_A(ntryL,G0H108(1),ex5(:),G0H36(1),m3h3x36(:,14),heltab2x108(:,:,31))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(6),n2h36(14))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(57)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(32),h0tab(:,32),[28,1,2],[0,0,0],3,1,wf27(:,4))
  call Hloop_QW_A(ntryL,G0H108(1),wf27(:,4),G0H4(1),m3h27x4(:,2),heltab2x108(:,:,32))
  call Hloop_Q_A(ntryL,G0H4(1),28,0,G1H4(2),n2h4(2))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(58)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(33),h0tab(:,33),[28,1,2],[0,0,0],3,1,wf27(:,6))
  call Hloop_QW_A(ntryL,G0H108(1),wf27(:,6),G0H4(1),m3h27x4(:,3),heltab2x108(:,:,33))
  call Hloop_Q_A(ntryL,G0H4(1),28,0,G1H4(3),n2h4(3))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(34),h0tab(:,34),[28,1,2],[0,0,0],3,1,wf27(:,8))
  call Hloop_QW_A(ntryL,G0H108(1),wf27(:,8),G0H4(1),m3h27x4(:,4),heltab2x108(:,:,34))
  call Hloop_Q_A(ntryL,G0H4(1),28,0,G1H4(4),n2h4(4))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(35),h0tab(:,35),[21,2,8],[0,0,0],3,1,wf18(:,16))
  call Hloop_QA_V(ntryL,G0H108(1),wf18(:,16),G0H6(1),m3h18x6(:,1),heltab2x108(:,:,35))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(30)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(36),h0tab(:,36),[22,1,8],[0,0,0],3,1,wf18(:,8))
  call Hloop_AQ_V(ntryL,G0H108(1),wf18(:,8),G0H6(2),m3h18x6(:,2),heltab2x108(:,:,36))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(37),h0tab(:,37),[21,2,8],[0,0,0],3,1,wf18(:,18))
  call Hloop_QA_V(ntryL,G0H108(1),wf18(:,18),G0H6(3),m3h18x6(:,3),heltab2x108(:,:,37))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(47)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(38),h0tab(:,38),[21,2,8],[0,0,0],3,1,wf18(:,20))
  call Hloop_QA_V(ntryL,G0H108(1),wf18(:,20),G0H6(4),m3h18x6(:,4),heltab2x108(:,:,38))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(39),h0tab(:,39),[22,1,8],[0,0,0],3,1,wf18(:,11))
  call Hloop_AQ_V(ntryL,G0H108(1),wf18(:,11),G0H6(5),m3h18x6(:,5),heltab2x108(:,:,39))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(37)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(40),h0tab(:,40),[22,1,8],[0,0,0],3,1,wf18(:,13))
  call Hloop_AQ_V(ntryL,G0H108(1),wf18(:,13),G0H6(6),m3h18x6(:,6),heltab2x108(:,:,40))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(41),h0tab(:,41),[28,1,2],[0,0,0],3,1,wf27(:,10))
  call Hloop_QW_A(ntryL,G0H108(1),wf27(:,10),G0H4(1),m3h27x4(:,5),heltab2x108(:,:,41))
  call Hloop_Q_A(ntryL,G0H4(1),28,0,G1H4(5),n2h4(5))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(61)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(42),h0tab(:,42),[28,1,2],[0,0,0],3,1,wf27(:,12))
  call Hloop_QW_A(ntryL,G0H108(1),wf27(:,12),G0H4(1),m3h27x4(:,6),heltab2x108(:,:,42))
  call Hloop_Q_A(ntryL,G0H4(1),28,0,G1H4(6),n2h4(6))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(43),h0tab(:,43),[28,1,2],[0,0,0],3,1,wf27(:,14))
  call Hloop_QW_A(ntryL,G0H108(1),wf27(:,14),G0H4(1),m3h27x4(:,7),heltab2x108(:,:,43))
  call Hloop_Q_A(ntryL,G0H4(1),28,0,G1H4(7),n2h4(7))
  call ol_merge(ntryL,G1H4(7),[G1H4(6),G1H4(5),G1H4(4),G1H4(3),G1H4(2),G1H4(1)])
  call ol_merge(ntryL,G1H12(3),[G1H12(1)])
  call ol_merge(ntryL,G1H12(4),[G1H12(2)])
  call ol_merge(ntryL,G0H6(4),[G0H6(3),G0H6(1)])
  call ol_merge(ntryL,G0H6(6),[G0H6(5),G0H6(2)])
  call Hloop_QA_V(ntryL,G1H4(7),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QW_A(ntryL,G1H18(1),ex3(:),G1H6(1),m3h3x6(:,1),heltab2x18(:,:,11))
  call Hloop_Q_A(ntryL,G1H6(1),22,0,G2H6(1),n2h6(1))
  call Hloop_AQ_V(ntryL,G1H12(3),ex2(:),G1H6(2),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_AQ_V(ntryL,G1H36(1),ex2(:),G1H18(3),m3h2x18(:,9),heltab2x36(:,:,9))
  call Hloop_AW_Q(ntryL,G1H18(2),ex3(:),G1H6(1),m3h3x6(:,2),heltab2x18(:,:,12))
  call Hloop_A_Q(ntryL,G1H6(1),21,0,G2H6(2),n2h6(2))
  call Hloop_QA_V(ntryL,G1H12(4),ex1(:),G1H6(1),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_QA_V(ntryL,G1H36(2),ex1(:),G1H18(4),m3h2x18(:,10),heltab2x36(:,:,10))
  call Hloop_VQ_A(ntryL,G0H18(1),ex2(:),G0H9(1),m3h2x9(:,9),heltab2x18(:,:,13))
  call Hloop_Q_A(ntryL,G0H9(1),19,0,G1H9(11),n2h9(11))
  call Hloop_VQ_A(ntryL,G0H18(2),ex2(:),G0H9(1),m3h2x9(:,10),heltab2x18(:,:,14))
  call Hloop_Q_A(ntryL,G0H9(1),19,0,G1H9(12),n2h9(12))
  call Hloop_VA_Q(ntryL,G0H18(3),ex1(:),G0H9(1),m3h2x9(:,11),heltab2x18(:,:,15))
  call Hloop_A_Q(ntryL,G0H9(1),19,0,G1H9(2),n2h9(13))
  call Hloop_VA_Q(ntryL,G0H18(4),ex1(:),G0H9(1),m3h2x9(:,12),heltab2x18(:,:,16))
  call Hloop_A_Q(ntryL,G0H9(1),19,0,G1H9(4),n2h9(14))
  call Hloop_AQ_V(ntryL,G1H36(3),ex2(:),G1H18(5),m3h2x18(:,11),heltab2x36(:,:,11))
  call Hloop_AQ_V(ntryL,G1H36(4),ex2(:),G1H18(6),m3h2x18(:,12),heltab2x36(:,:,12))
  call Hloop_QA_V(ntryL,G1H36(5),ex1(:),G1H18(1),m3h2x18(:,13),heltab2x36(:,:,13))
  call Hloop_QA_V(ntryL,G1H36(6),ex1(:),G1H18(2),m3h2x18(:,14),heltab2x36(:,:,14))
  call Hloop_VQ_A(ntryL,G0H6(4),ex2(:),G0H3(1),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(20),n2h3(15))
  call Hloop_VA_Q(ntryL,G0H6(6),ex1(:),G0H3(1),m3h2x3(:,4),heltab2x6(:,:,4))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(21),n2h3(16))
  call ol_merge(ntryL,G1H3(21),[G1H3(6)])
  call ol_merge(ntryL,G1H3(30),[G1H3(8)])
  call ol_merge(ntryL,G1H3(35),[G1H3(12)])
  call ol_merge(ntryL,G1H3(20),[G1H3(3)])
  call ol_merge(ntryL,G1H3(37),[G1H3(24)])
  call ol_merge(ntryL,G1H3(42),[G1H3(25)])
  call ol_merge(ntryL,G1H3(34),[G1H3(29)])
  call ol_merge(ntryL,G1H3(41),[G1H3(11)])
  call ol_merge(ntryL,G1H9(11),[G1H9(3)])
  call ol_merge(ntryL,G1H9(12),[G1H9(10)])
  call ol_merge(ntryL,G1H9(2),[G1H9(13)])
  call ol_merge(ntryL,G1H9(4),[G1H9(18)])
  call Hloop_AW_Q(ntryL,G1H3(21),ex4(:),G1H1(1),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(2),n2h1(51))
  call Hloop_AW_Q(ntryL,G1H3(17),ex4(:),G1H1(1),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(52))
  call Hloop_AW_Q(ntryL,G1H3(30),ex3(:),G1H1(1),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(53))
  call Hloop_AW_Q(ntryL,G1H3(35),ex3(:),G1H1(1),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(54))
  call Hloop_QW_A(ntryL,G1H3(20),ex4(:),G1H1(1),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(55))
  call Hloop_QW_A(ntryL,G1H3(4),ex4(:),G1H1(1),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(56))
  call Hloop_QW_A(ntryL,G1H3(37),ex3(:),G1H1(1),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(57))
  call Hloop_QW_A(ntryL,G1H3(42),ex3(:),G1H1(1),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(58))
  call Hloop_AW_Q(ntryL,G1H3(34),ex3(:),G1H1(1),m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(46),n2h1(59))
  call Hloop_QW_A(ntryL,G1H3(41),ex3(:),G1H1(1),m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(60))
  call Hloop_QV_A(ntryL,G1H9(11),wf9(:,2),G1H1(1),m3h9x1(:,13),heltab2x9(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(61))
  call Hloop_QV_A(ntryL,G1H9(9),wf9(:,2),G1H1(1),m3h9x1(:,14),heltab2x9(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(62))
  call Hloop_QZ_A(ntryL,G1H9(12),wf9(:,3),G1H1(1),ngZd,m3h9x1(:,15),heltab2x9(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(63))
  call Hloop_QZ_A(ntryL,G1H9(5),wf9(:,3),G1H1(1),ngZd,m3h9x1(:,16),heltab2x9(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(64))
  call Hloop_AV_Q(ntryL,G1H9(2),wf9(:,2),G1H1(1),m3h9x1(:,17),heltab2x9(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H9(14),wf9(:,2),G1H1(1),m3h9x1(:,18),heltab2x9(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(66))
  call Hloop_AZ_Q(ntryL,G1H9(4),wf9(:,3),G1H1(1),ngZu,m3h9x1(:,19),heltab2x9(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(67))
  call Hloop_AZ_Q(ntryL,G1H9(19),wf9(:,3),G1H1(1),ngZu,m3h9x1(:,20),heltab2x9(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(50),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(69))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(1),wf6(:,3),G2tensor(52),m3h6x1(:,1),heltab2x6(:,:,5))
  call Hloop_VA_Q(ntryL,G1H6(2),wf6(:,3),G1H1(1),m3h6x1(:,2),heltab2x6(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(70))
  call Hloop_VA_Q(ntryL,G1H18(3),wf18(:,9),G1H1(1),m3h18x1(:,1),heltab2x18(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(54),n2h1(71))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(2),wf6(:,8),G2tensor(55),m3h6x1(:,3),heltab2x6(:,:,7))
  call Hloop_VQ_A(ntryL,G1H6(1),wf6(:,8),G1H1(1),m3h6x1(:,4),heltab2x6(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(56),n2h1(72))
  call Hloop_VQ_A(ntryL,G1H18(4),wf18(:,15),G1H1(1),m3h18x1(:,2),heltab2x18(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(73))
  call Hloop_VA_Q(ntryL,G1H18(5),wf18(:,26),G1H1(1),m3h18x1(:,3),heltab2x18(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(58),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H18(6),wf18(:,28),G1H1(1),m3h18x1(:,4),heltab2x18(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(75))
  call Hloop_VQ_A(ntryL,G1H18(1),wf18(:,22),G1H1(1),m3h18x1(:,5),heltab2x18(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(60),n2h1(76))
  call Hloop_VQ_A(ntryL,G1H18(2),wf18(:,24),G1H1(1),m3h18x1(:,6),heltab2x18(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(77))
  call ol_merge_tensors(G2tensor(47),[G2tensor(44),G2tensor(14),G2tensor(4),G1tensor(3),G1tensor(7),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(41),G2tensor(38),G2tensor(20),G2tensor(8),G1tensor(17),G1tensor(11),G0tensor(17) &
    ,G0tensor(12)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(31),G2tensor(27),G2tensor(1),G1tensor(25),G1tensor(10),G0tensor(25),G0tensor(8)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(22),G2tensor(16),G2tensor(25),G2tensor(36),G2tensor(30),G2tensor(11),G2tensor(5) &
    ,G1tensor(30),G1tensor(19),G1tensor(4),G0tensor(30),G0tensor(19),G0tensor(9)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(58),G2tensor(54),G2tensor(48),G2tensor(45),G2tensor(18),G2tensor(9),G1tensor(35) &
    ,G1tensor(5),G0tensor(35),G0tensor(10)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(40),G2tensor(33),G2tensor(10),G1tensor(40),G1tensor(18),G0tensor(40) &
    ,G0tensor(18)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(60),G2tensor(57),G2tensor(42),G2tensor(39),G2tensor(24),G2tensor(12),G1tensor(45) &
    ,G1tensor(20),G0tensor(45),G0tensor(20)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(17),G2tensor(15),G1tensor(32),G1tensor(8),G0tensor(32),G0tensor(5)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(23),G2tensor(21),G1tensor(42),G1tensor(15),G0tensor(42),G0tensor(15)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(26),G1tensor(22),G1tensor(2),G0tensor(22),G0tensor(3)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(43),G2tensor(35),G2tensor(29),G1tensor(27),G1tensor(14),G1tensor(6),G0tensor(27) &
    ,G0tensor(14),G0tensor(4)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(32),G1tensor(37),G1tensor(13),G0tensor(37),G0tensor(13)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(46),G1tensor(38),G1tensor(28),G1tensor(23),G0tensor(38),G0tensor(28) &
    ,G0tensor(23)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(33),G1tensor(24),G0tensor(33),G0tensor(24)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(6),G1tensor(44),G1tensor(34),G1tensor(29),G0tensor(44),G0tensor(34),G0tensor(29)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(43),G1tensor(39),G0tensor(43),G0tensor(39)])
call TI_triangle_red(G2tensor(47),RedBasis(20),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
call TI_triangle_red(G2tensor(51),RedBasis(21),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
call TI_triangle_red(G2tensor(49),RedBasis(4),mass3set(:,1),G0tensor(41),G0tensor(7),G0tensor(2),G0tensor(17),M2L1R1)
call TI_triangle_red(G2tensor(50),RedBasis(2),mass3set(:,1),G0tensor(12),G0tensor(25),G0tensor(8),G0tensor(30),M2L1R1)
call TI_triangle_red(G2tensor(59),RedBasis(1),mass3set(:,1),G0tensor(19),G0tensor(9),G0tensor(35),G0tensor(10),M2L1R1)
call TI_triangle_red(G2tensor(34),RedBasis(8),mass3set(:,1),G0tensor(40),G0tensor(18),G0tensor(45),G0tensor(20),M2L1R1)
call TI_triangle_red(G2tensor(61),RedBasis(7),mass3set(:,1),G0tensor(32),G0tensor(5),G0tensor(42),G0tensor(15),M2L1R1)
call TI_triangle_red(G2tensor(53),RedBasis(15),mass3set(:,1),G0tensor(22),G0tensor(3),G0tensor(27),G0tensor(14),M2L1R1)
call TI_triangle_red(G2tensor(56),RedBasis(18),mass3set(:,1),G0tensor(4),G0tensor(37),G0tensor(13),G0tensor(38),M2L1R1)
call TI_triangle_red(G2tensor(2),RedBasis(17),mass3set(:,1),G0tensor(28),G0tensor(23),G0tensor(33),G0tensor(24),M2L1R1)
call TI_triangle_red(G2tensor(7),RedBasis(16),mass3set(:,1),G0tensor(44),G0tensor(34),G0tensor(29),G0tensor(43),M2L1R1)
call TI_triangle_red(G2tensor(37),RedBasis(19),mass3set(:,1),G0tensor(39),G0tensor(46),G0tensor(47),G0tensor(48),M2L1R1)
call TI_triangle_red(G2tensor(19),RedBasis(6),mass3set(:,1),G0tensor(49),G0tensor(50),G0tensor(51),G0tensor(52),M2L1R1)
call TI_triangle_red(G2tensor(3),RedBasis(5),mass3set(:,1),G0tensor(53),G0tensor(54),G0tensor(55),G0tensor(56),M2L1R1)
call TI_triangle_red(G2tensor(13),RedBasis(3),mass3set(:,1),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60),M2L1R1)
call TI_triangle_red(G2tensor(28),RedBasis(9),mass3set(:,1),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),M2L1R1)
call TI_triangle_red(G2tensor(52),RedBasis(22),mass3set(:,1),G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),M2L1R1)
call TI_triangle_red(G2tensor(55),RedBasis(23),mass3set(:,1),G0tensor(69),G0tensor(70),G0tensor(71),G0tensor(72),M2L1R1)
call ol_merge_tensors(T0sum(10),[G0tensor(1)])
call ol_merge_tensors(T0sum(11),[G0tensor(21)])
call ol_merge_tensors(T0sum(12),[G0tensor(41)])
call ol_merge_tensors(T0sum(13),[G0tensor(12)])
call ol_merge_tensors(T0sum(14),[G0tensor(19)])
call ol_merge_tensors(T0sum(15),[G0tensor(40)])
call ol_merge_tensors(T0sum(16),[G0tensor(32)])
call ol_merge_tensors(T0sum(17),[G0tensor(22)])
call ol_merge_tensors(T0sum(18),[G0tensor(4)])
call ol_merge_tensors(T0sum(19),[G0tensor(28)])
call ol_merge_tensors(T0sum(20),[G0tensor(44)])
call ol_merge_tensors(T0sum(21),[G0tensor(39)])
call ol_merge_tensors(T0sum(22),[G0tensor(49)])
call ol_merge_tensors(T0sum(23),[G0tensor(53)])
call ol_merge_tensors(T0sum(24),[G0tensor(57)])
call ol_merge_tensors(T0sum(25),[G0tensor(61)])
call ol_merge_tensors(T0sum(26),[G0tensor(65)])
call ol_merge_tensors(T0sum(27),[G0tensor(69)])
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(34)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(44),h0tab(:,44),[18,13],[0,0],2,2,wf6(:,4),wf18(:,9))
  call Hloop_AQ_V(ntryL,G0H108(1),wf6(:,4),G0H18(1),m3h6x18(:,9),heltab2x108(:,:,44))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(45),h0tab(:,45),[22,9],[0,0],2,2,wf18(:,8),wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H108(1),wf18(:,8),G0H6(3),m3h18x6(:,7),heltab2x108(:,:,45))
  call Hloop_Q_A(ntryL,G0H6(3),22,0,G1H6(2),n2h6(3))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(36)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(46),h0tab(:,46),[22,9],[0,0],2,2,wf18(:,11),wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H108(1),wf18(:,11),G0H6(1),m3h18x6(:,8),heltab2x108(:,:,46))
  call Hloop_Q_A(ntryL,G0H6(1),22,0,G1H6(1),n2h6(4))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(38)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(47),h0tab(:,47),[22,9],[0,0],2,2,wf18(:,13),wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H108(1),wf18(:,13),G0H6(5),m3h18x6(:,9),heltab2x108(:,:,47))
  call Hloop_Q_A(ntryL,G0H6(5),22,0,G1H6(3),n2h6(5))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(48),h0tab(:,48),[21,10],[0,0],2,2,wf18(:,16),wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H108(1),wf18(:,16),G0H6(2),m3h18x6(:,10),heltab2x108(:,:,48))
  call Hloop_A_Q(ntryL,G0H6(2),21,0,G1H6(4),n2h6(6))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(41)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(49),h0tab(:,49),[17,14],[0,0],2,2,wf6(:,7),wf18(:,15))
  call Hloop_QA_V(ntryL,G0H108(1),wf6(:,7),G0H18(2),m3h6x18(:,10),heltab2x108(:,:,49))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(50),h0tab(:,50),[21,10],[0,0],2,2,wf18(:,18),wf6(:,8))
  call Hloop_QA_V(ntryL,G0H108(1),wf18(:,18),G0H6(4),m3h18x6(:,11),heltab2x108(:,:,50))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(48)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(51),h0tab(:,51),[21,10],[0,0],2,2,wf18(:,20),wf6(:,8))
  call Hloop_QA_V(ntryL,G0H108(1),wf18(:,20),G0H6(6),m3h18x6(:,12),heltab2x108(:,:,51))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(52),h0tab(:,52),[17,14],[0,0],2,2,wf6(:,7),wf18(:,22))
  call Hloop_QA_V(ntryL,G0H108(1),wf6(:,7),G0H18(3),m3h6x18(:,11),heltab2x108(:,:,52))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(53),h0tab(:,53),[17,14],[0,0],2,2,wf6(:,7),wf18(:,24))
  call Hloop_QA_V(ntryL,G0H108(1),wf6(:,7),G0H18(4),m3h6x18(:,12),heltab2x108(:,:,53))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(54)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(54),h0tab(:,54),[18,13],[0,0],2,2,wf6(:,4),wf18(:,26))
  call Hloop_VQ_A(ntryL,G0H108(1),wf6(:,4),G0H18(5),m3h6x18(:,13),heltab2x108(:,:,54))
  call Hloop_Q_A(ntryL,G0H18(5),18,0,G1H18(3),n2h18(3))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(56)
call G0_hol_initialisation(ntryL,Gcoeff,G0H108(1),m0h(55),h0tab(:,55),[18,13],[0,0],2,2,wf6(:,4),wf18(:,28))
  call Hloop_VQ_A(ntryL,G0H108(1),wf6(:,4),G0H18(5),m3h6x18(:,14),heltab2x108(:,:,55))
  call Hloop_Q_A(ntryL,G0H18(5),18,0,G1H18(4),n2h18(4))
  call ol_merge(ntryL,G1H6(3),[G1H6(1),G1H6(2)])
  call ol_merge(ntryL,G0H6(6),[G0H6(4)])
  call Hloop_VA_Q(ntryL,G0H18(1),wf18(:,9),G0H1(1),m3h18x1(:,7),heltab2x18(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(1),n2h1(78))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(3),wf6(:,3),G1tensor(12),m3h6x1(:,5),heltab2x6(:,:,9))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(4),wf6(:,8),G1tensor(9),m3h6x1(:,6),heltab2x6(:,:,10))
  call Hloop_VQ_A(ntryL,G0H18(2),wf18(:,15),G0H1(1),m3h18x1(:,8),heltab2x18(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(16),n2h1(79))
  call Hloop_VQ_A(ntryL,G0H6(6),wf6(:,8),G0H1(1),m3h6x1(:,7),heltab2x6(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(21),n2h1(80))
  call Hloop_VQ_A(ntryL,G0H18(3),wf18(:,22),G0H1(1),m3h18x1(:,9),heltab2x18(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(26),n2h1(81))
  call Hloop_VQ_A(ntryL,G0H18(4),wf18(:,24),G0H1(1),m3h18x1(:,10),heltab2x18(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(31),n2h1(82))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H18(3),wf18(:,26),G1tensor(36),m3h18x1(:,11),heltab2x18(:,:,27))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H18(4),wf18(:,28),G1tensor(41),m3h18x1(:,12),heltab2x18(:,:,28))
  call ol_merge_tensors(G0tensor(46),[G0tensor(3),G0tensor(18),G0tensor(9),G0tensor(31),G0tensor(6)])
  call ol_merge_tensors(G0tensor(23),[G0tensor(37),G0tensor(5),G0tensor(7),G0tensor(26),G0tensor(11)])
  call ol_merge_tensors(G0tensor(34),[G0tensor(25),G0tensor(36),G0tensor(16)])
  call ol_merge_tensors(G0tensor(52),[G0tensor(45),G0tensor(8),G0tensor(2)])
  call ol_merge_tensors(G1tensor(41),[G1tensor(36),G1tensor(1),G0tensor(68),G0tensor(56),G0tensor(35),G0tensor(17)])
  call ol_merge_tensors(G0tensor(60),[G0tensor(15),G0tensor(10),G0tensor(30)])
  call ol_merge_tensors(G1tensor(31),[G1tensor(26),G1tensor(16),G0tensor(72),G0tensor(64),G0tensor(42),G0tensor(20)])
  call ol_merge_tensors(G1tensor(12),[G0tensor(67),G0tensor(54),G0tensor(24),G0tensor(27)])
  call ol_merge_tensors(G0tensor(58),[G0tensor(43),G0tensor(38),G0tensor(14)])
  call ol_merge_tensors(G1tensor(21),[G1tensor(9),G0tensor(71),G0tensor(62),G0tensor(48),G0tensor(13)])
  call ol_merge_tensors(G0tensor(50),[G0tensor(47),G0tensor(29),G0tensor(33)])
  call ol_merge_tensors(G0tensor(70),[G0tensor(66),G0tensor(63),G0tensor(59),G0tensor(55),G0tensor(51)])
call TI_bubble_red(G1tensor(41),18,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(31),17,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G1tensor(12),22,mass2set(:,1),G0tensor(41),M2L1R1)
call TI_bubble_red(G1tensor(21),21,mass2set(:,1),G0tensor(12),M2L1R1)
call ol_merge_tensors(T0sum(28),[G0tensor(46)])
call ol_merge_tensors(T0sum(29),[G0tensor(23)])
call ol_merge_tensors(T0sum(30),[G0tensor(34)])
call ol_merge_tensors(T0sum(31),[G0tensor(52)])
call ol_merge_tensors(T0sum(32),[G0tensor(1)])
call ol_merge_tensors(T0sum(33),[G0tensor(60)])
call ol_merge_tensors(T0sum(34),[G0tensor(21)])
call ol_merge_tensors(T0sum(35),[G0tensor(41)])
call ol_merge_tensors(T0sum(36),[G0tensor(58)])
call ol_merge_tensors(T0sum(37),[G0tensor(12)])
call ol_merge_tensors(T0sum(38),[G0tensor(50)])
call ol_merge_tensors(T0sum(39),[G0tensor(70)])


! Compute scalar Master integrals 

call compute_scalar_box([ 18, 19, 27 ],masses2_3,RedSet_4(3),ScalarBoxes(1))
call compute_scalar_box([ 16, 19, 27 ],masses2_3,RedSet_4(4),ScalarBoxes(2))
call compute_scalar_box([ 16, 18, 27 ],masses2_3,RedSet_4(5),ScalarBoxes(3))
call compute_scalar_box([ 16, 18, 19 ],masses2_3,RedSet_4(1),ScalarBoxes(4))
call compute_scalar_box([ 2, 3, 11 ],masses2_3,RedSet_4(6),ScalarBoxes(5))
call compute_scalar_box([ 17, 19, 27 ],masses2_3,RedSet_4(7),ScalarBoxes(6))
call compute_scalar_box([ 16, 17, 27 ],masses2_3,RedSet_4(8),ScalarBoxes(7))
call compute_scalar_box([ 16, 17, 19 ],masses2_3,RedSet_4(2),ScalarBoxes(8))
call compute_scalar_box([ 1, 3, 11 ],masses2_3,RedSet_4(9),ScalarBoxes(9))
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppvvv_uxdwwxwx_1_/**/REALKIND
