
module ol_vamp_1_ppvvv2_zzzgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv2_zzzgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv2_zzzgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvv2_zzzgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvv2_zzzgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,31) :: G0
  complex(REALKIND), dimension(4,5,4,124) :: G1
  complex(REALKIND), dimension(4,15,4,250) :: G2
  complex(REALKIND), dimension(4,35,4,264) :: G3
  complex(REALKIND), dimension(4,70,4,192) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,24,108))
    allocate(G4tensorhel(70,36,108))
    allocate(G5tensorhel(126,96,108))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,8),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,24),ZERO,G2(:,:,:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,9),G2(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,9),G2(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,31),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,10),G2(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,31),ZERO,G3tensor(:,3))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,10),G2(:,:,:,5),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,31),ZERO,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,11),G2(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,31),ZERO,G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,11),G2(:,:,:,7),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,31),ZERO,G3tensor(:,6))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,-1),G1(:,:,:,3),gZu)
  call loop_A_Q(G1(:,:,:,3),Q(:,10),ZERO,G2(:,:,:,8))
  call loop_AZ_Q(G2(:,:,:,8),wf(:,-2),G2(:,:,:,9),gZu)
  call loop_A_Q(G2(:,:,:,9),Q(:,14),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,-4),G3(:,:,:,2))
  call loop_A_Q(G3(:,:,:,2),Q(:,30),ZERO,G4(:,:,:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,0),G4(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,31),ZERO,G5tensor(:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,-1),G1(:,:,:,4),gZd)
  call loop_A_Q(G1(:,:,:,4),Q(:,10),ZERO,G2(:,:,:,10))
  call loop_AZ_Q(G2(:,:,:,10),wf(:,-2),G2(:,:,:,11),gZd)
  call loop_A_Q(G2(:,:,:,11),Q(:,14),ZERO,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-4),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,30),ZERO,G4(:,:,:,3))
  call loop_AZ_Q(G4(:,:,:,3),wf(:,0),G4(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,31),ZERO,G5tensor(:,2))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,5),gZu)
  call loop_A_Q(G1(:,:,:,5),Q(:,12),ZERO,G2(:,:,:,12))
  call loop_AZ_Q(G2(:,:,:,12),wf(:,-1),G2(:,:,:,13),gZu)
  call loop_A_Q(G2(:,:,:,13),Q(:,14),ZERO,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-4),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,30),ZERO,G4(:,:,:,5))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,0),G4(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,31),ZERO,G5tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,6),gZd)
  call loop_A_Q(G1(:,:,:,6),Q(:,12),ZERO,G2(:,:,:,14))
  call loop_AZ_Q(G2(:,:,:,14),wf(:,-1),G2(:,:,:,15),gZd)
  call loop_A_Q(G2(:,:,:,15),Q(:,14),ZERO,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,-4),G3(:,:,:,8))
  call loop_A_Q(G3(:,:,:,8),Q(:,30),ZERO,G4(:,:,:,7))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,0),G4(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,31),ZERO,G5tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,8),MT,G1(:,:,:,7))
  call loop_AV_Q(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,24),MT,G2(:,:,:,16))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,9),G2(:,:,:,17),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,31),MT,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,10),G2(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,31),MT,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,11),G2(:,:,:,19),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,31),MT,G3tensor(:,9))
  call loop_AZ_Q(G1(:,:,:,7),wf(:,-2),G1(:,:,:,9),gZu)
  call loop_A_Q(G1(:,:,:,9),Q(:,12),MT,G2(:,:,:,20))
  call loop_AV_Q(G2(:,:,:,20),wf(:,-4),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,28),MT,G3(:,:,:,9))
  call loop_AS_Q(G3(:,:,:,9),wf(:,1),G3(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,31),MT,G4tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,20),wf(:,-1),G2(:,:,:,22),gZu)
  call loop_A_Q(G2(:,:,:,22),Q(:,14),MT,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-4),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,30),MT,G4(:,:,:,9))
  call loop_AZ_Q(G4(:,:,:,9),wf(:,0),G4(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,31),MT,G5tensor(:,5))
  call loop_AS_Q(G1(:,:,:,7),wf(:,5),G1(:,:,:,10),gH)
  call loop_A_Q(G1(:,:,:,10),Q(:,13),MT,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,-4),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,29),MT,G3(:,:,:,13))
  call loop_AZ_Q(G3(:,:,:,13),wf(:,-1),G3(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,31),MT,G4tensor(:,2))
  call loop_AS_Q(G1(:,:,:,7),wf(:,7),G1(:,:,:,11),gH)
  call loop_A_Q(G1(:,:,:,11),Q(:,14),MT,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-4),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,30),MT,G3(:,:,:,15))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,0),G3(:,:,:,16),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,31),MT,G4tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,7),wf(:,-1),G1(:,:,:,12),gZu)
  call loop_A_Q(G1(:,:,:,12),Q(:,10),MT,G2(:,:,:,27))
  call loop_AZ_Q(G2(:,:,:,27),wf(:,-2),G2(:,:,:,28),gZu)
  call loop_A_Q(G2(:,:,:,28),Q(:,14),MT,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,-4),G3(:,:,:,18))
  call loop_A_Q(G3(:,:,:,18),Q(:,30),MT,G4(:,:,:,11))
  call loop_AZ_Q(G4(:,:,:,11),wf(:,0),G4(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,31),MT,G5tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,8),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,-4),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,24),ZERO,G2(:,:,:,29))
  call loop_QZ_A(G2(:,:,:,29),wf(:,9),G2(:,:,:,30),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,31),ZERO,G3tensor(:,10))
  call loop_QZ_A(G2(:,:,:,29),wf(:,9),G2(:,:,:,31),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,31),Q(:,31),ZERO,G3tensor(:,11))
  call loop_QZ_A(G2(:,:,:,29),wf(:,10),G2(:,:,:,32),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,31),ZERO,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,29),wf(:,10),G2(:,:,:,33),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,33),Q(:,31),ZERO,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,29),wf(:,11),G2(:,:,:,34),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,31),ZERO,G3tensor(:,14))
  call loop_QZ_A(G2(:,:,:,29),wf(:,11),G2(:,:,:,35),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,31),ZERO,G3tensor(:,15))
  call loop_QZ_A(G1(:,:,:,13),wf(:,-1),G1(:,:,:,15),gZu)
  call loop_Q_A(G1(:,:,:,15),Q(:,10),ZERO,G2(:,:,:,36))
  call loop_QZ_A(G2(:,:,:,36),wf(:,-2),G2(:,:,:,37),gZu)
  call loop_Q_A(G2(:,:,:,37),Q(:,14),ZERO,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,-4),G3(:,:,:,20))
  call loop_Q_A(G3(:,:,:,20),Q(:,30),ZERO,G4(:,:,:,13))
  call loop_QZ_A(G4(:,:,:,13),wf(:,0),G4(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,31),ZERO,G5tensor(:,7))
  call loop_QZ_A(G1(:,:,:,13),wf(:,-1),G1(:,:,:,16),gZd)
  call loop_Q_A(G1(:,:,:,16),Q(:,10),ZERO,G2(:,:,:,38))
  call loop_QZ_A(G2(:,:,:,38),wf(:,-2),G2(:,:,:,39),gZd)
  call loop_Q_A(G2(:,:,:,39),Q(:,14),ZERO,G3(:,:,:,21))
  call loop_QV_A(G3(:,:,:,21),wf(:,-4),G3(:,:,:,22))
  call loop_Q_A(G3(:,:,:,22),Q(:,30),ZERO,G4(:,:,:,15))
  call loop_QZ_A(G4(:,:,:,15),wf(:,0),G4(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,31),ZERO,G5tensor(:,8))
  call loop_QZ_A(G1(:,:,:,13),wf(:,-2),G1(:,:,:,17),gZu)
  call loop_Q_A(G1(:,:,:,17),Q(:,12),ZERO,G2(:,:,:,40))
  call loop_QZ_A(G2(:,:,:,40),wf(:,-1),G2(:,:,:,41),gZu)
  call loop_Q_A(G2(:,:,:,41),Q(:,14),ZERO,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24))
  call loop_Q_A(G3(:,:,:,24),Q(:,30),ZERO,G4(:,:,:,17))
  call loop_QZ_A(G4(:,:,:,17),wf(:,0),G4(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,31),ZERO,G5tensor(:,9))
  call loop_QZ_A(G1(:,:,:,13),wf(:,-2),G1(:,:,:,18),gZd)
  call loop_Q_A(G1(:,:,:,18),Q(:,12),ZERO,G2(:,:,:,42))
  call loop_QZ_A(G2(:,:,:,42),wf(:,-1),G2(:,:,:,43),gZd)
  call loop_Q_A(G2(:,:,:,43),Q(:,14),ZERO,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,-4),G3(:,:,:,26))
  call loop_Q_A(G3(:,:,:,26),Q(:,30),ZERO,G4(:,:,:,19))
  call loop_QZ_A(G4(:,:,:,19),wf(:,0),G4(:,:,:,20),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,31),ZERO,G5tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,8),MT,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,-4),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,24),MT,G2(:,:,:,44))
  call loop_QZ_A(G2(:,:,:,44),wf(:,9),G2(:,:,:,45),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,45),Q(:,31),MT,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,44),wf(:,10),G2(:,:,:,46),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,31),MT,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,44),wf(:,11),G2(:,:,:,47),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,31),MT,G3tensor(:,18))
  call loop_QZ_A(G1(:,:,:,19),wf(:,-2),G1(:,:,:,21),gZu)
  call loop_Q_A(G1(:,:,:,21),Q(:,12),MT,G2(:,:,:,48))
  call loop_QV_A(G2(:,:,:,48),wf(:,-4),G2(:,:,:,49))
  call loop_Q_A(G2(:,:,:,49),Q(:,28),MT,G3(:,:,:,27))
  call loop_QS_A(G3(:,:,:,27),wf(:,1),G3(:,:,:,28),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,31),MT,G4tensor(:,4))
  call loop_QZ_A(G2(:,:,:,48),wf(:,-1),G2(:,:,:,50),gZu)
  call loop_Q_A(G2(:,:,:,50),Q(:,14),MT,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,-4),G3(:,:,:,30))
  call loop_Q_A(G3(:,:,:,30),Q(:,30),MT,G4(:,:,:,21))
  call loop_QZ_A(G4(:,:,:,21),wf(:,0),G4(:,:,:,22),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,31),MT,G5tensor(:,11))
  call loop_QS_A(G1(:,:,:,19),wf(:,5),G1(:,:,:,22),gH)
  call loop_Q_A(G1(:,:,:,22),Q(:,13),MT,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,-4),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,29),MT,G3(:,:,:,31))
  call loop_QZ_A(G3(:,:,:,31),wf(:,-1),G3(:,:,:,32),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,31),MT,G4tensor(:,5))
  call loop_QS_A(G1(:,:,:,19),wf(:,7),G1(:,:,:,23),gH)
  call loop_Q_A(G1(:,:,:,23),Q(:,14),MT,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,30),MT,G3(:,:,:,33))
  call loop_QZ_A(G3(:,:,:,33),wf(:,0),G3(:,:,:,34),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,31),MT,G4tensor(:,6))
  call loop_QZ_A(G1(:,:,:,19),wf(:,-1),G1(:,:,:,24),gZu)
  call loop_Q_A(G1(:,:,:,24),Q(:,10),MT,G2(:,:,:,55))
  call loop_QZ_A(G2(:,:,:,55),wf(:,-2),G2(:,:,:,56),gZu)
  call loop_Q_A(G2(:,:,:,56),Q(:,14),MT,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,-4),G3(:,:,:,36))
  call loop_Q_A(G3(:,:,:,36),Q(:,30),MT,G4(:,:,:,23))
  call loop_QZ_A(G4(:,:,:,23),wf(:,0),G4(:,:,:,24),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,31),MT,G5tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,8),MB,G1(:,:,:,25))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-4),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,24),MB,G2(:,:,:,57))
  call loop_AZ_Q(G2(:,:,:,57),wf(:,9),G2(:,:,:,58),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,58),Q(:,31),MB,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,57),wf(:,10),G2(:,:,:,59),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,59),Q(:,31),MB,G3tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,57),wf(:,11),G2(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,31),MB,G3tensor(:,21))
  call loop_AZ_Q(G1(:,:,:,25),wf(:,-2),G1(:,:,:,27),gZd)
  call loop_A_Q(G1(:,:,:,27),Q(:,12),MB,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-4),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,28),MB,G3(:,:,:,37))
  call loop_AS_Q(G3(:,:,:,37),wf(:,1),G3(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,31),MB,G4tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,-1),G2(:,:,:,63),gZd)
  call loop_A_Q(G2(:,:,:,63),Q(:,14),MB,G3(:,:,:,39))
  call loop_AV_Q(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,30),MB,G4(:,:,:,25))
  call loop_AZ_Q(G4(:,:,:,25),wf(:,0),G4(:,:,:,26),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,31),MB,G5tensor(:,13))
  call loop_AS_Q(G1(:,:,:,25),wf(:,5),G1(:,:,:,28),gH)
  call loop_A_Q(G1(:,:,:,28),Q(:,13),MB,G2(:,:,:,64))
  call loop_AV_Q(G2(:,:,:,64),wf(:,-4),G2(:,:,:,65))
  call loop_A_Q(G2(:,:,:,65),Q(:,29),MB,G3(:,:,:,41))
  call loop_AZ_Q(G3(:,:,:,41),wf(:,-1),G3(:,:,:,42),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,31),MB,G4tensor(:,8))
  call loop_AS_Q(G1(:,:,:,25),wf(:,7),G1(:,:,:,29),gH)
  call loop_A_Q(G1(:,:,:,29),Q(:,14),MB,G2(:,:,:,66))
  call loop_AV_Q(G2(:,:,:,66),wf(:,-4),G2(:,:,:,67))
  call loop_A_Q(G2(:,:,:,67),Q(:,30),MB,G3(:,:,:,43))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,0),G3(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,31),MB,G4tensor(:,9))
  call loop_AZ_Q(G1(:,:,:,25),wf(:,-1),G1(:,:,:,30),gZd)
  call loop_A_Q(G1(:,:,:,30),Q(:,10),MB,G2(:,:,:,68))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,-2),G2(:,:,:,69),gZd)
  call loop_A_Q(G2(:,:,:,69),Q(:,14),MB,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,-4),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,30),MB,G4(:,:,:,27))
  call loop_AZ_Q(G4(:,:,:,27),wf(:,0),G4(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,31),MB,G5tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,8),MB,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,-4),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,24),MB,G2(:,:,:,70))
  call loop_QZ_A(G2(:,:,:,70),wf(:,9),G2(:,:,:,71),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,71),Q(:,31),MB,G3tensor(:,22))
  call loop_QZ_A(G2(:,:,:,70),wf(:,10),G2(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,31),MB,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,70),wf(:,11),G2(:,:,:,73),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,73),Q(:,31),MB,G3tensor(:,24))
  call loop_QZ_A(G1(:,:,:,31),wf(:,-2),G1(:,:,:,33),gZd)
  call loop_Q_A(G1(:,:,:,33),Q(:,12),MB,G2(:,:,:,74))
  call loop_QV_A(G2(:,:,:,74),wf(:,-4),G2(:,:,:,75))
  call loop_Q_A(G2(:,:,:,75),Q(:,28),MB,G3(:,:,:,47))
  call loop_QS_A(G3(:,:,:,47),wf(:,1),G3(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,31),MB,G4tensor(:,10))
  call loop_QZ_A(G2(:,:,:,74),wf(:,-1),G2(:,:,:,76),gZd)
  call loop_Q_A(G2(:,:,:,76),Q(:,14),MB,G3(:,:,:,49))
  call loop_QV_A(G3(:,:,:,49),wf(:,-4),G3(:,:,:,50))
  call loop_Q_A(G3(:,:,:,50),Q(:,30),MB,G4(:,:,:,29))
  call loop_QZ_A(G4(:,:,:,29),wf(:,0),G4(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,31),MB,G5tensor(:,15))
  call loop_QS_A(G1(:,:,:,31),wf(:,5),G1(:,:,:,34),gH)
  call loop_Q_A(G1(:,:,:,34),Q(:,13),MB,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,-4),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,29),MB,G3(:,:,:,51))
  call loop_QZ_A(G3(:,:,:,51),wf(:,-1),G3(:,:,:,52),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,31),MB,G4tensor(:,11))
  call loop_QS_A(G1(:,:,:,31),wf(:,7),G1(:,:,:,35),gH)
  call loop_Q_A(G1(:,:,:,35),Q(:,14),MB,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,-4),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,30),MB,G3(:,:,:,53))
  call loop_QZ_A(G3(:,:,:,53),wf(:,0),G3(:,:,:,54),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,31),MB,G4tensor(:,12))
  call loop_QZ_A(G1(:,:,:,31),wf(:,-1),G1(:,:,:,36),gZd)
  call loop_Q_A(G1(:,:,:,36),Q(:,10),MB,G2(:,:,:,81))
  call loop_QZ_A(G2(:,:,:,81),wf(:,-2),G2(:,:,:,82),gZd)
  call loop_Q_A(G2(:,:,:,82),Q(:,14),MB,G3(:,:,:,55))
  call loop_QV_A(G3(:,:,:,55),wf(:,-4),G3(:,:,:,56))
  call loop_Q_A(G3(:,:,:,56),Q(:,30),MB,G4(:,:,:,31))
  call loop_QZ_A(G4(:,:,:,31),wf(:,0),G4(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,31),MB,G5tensor(:,16))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,8),gZu)
  call loop_A_Q(G0(:,:,:,8),Q(:,4),MT,G1(:,:,:,37))
  call loop_AV_Q(G1(:,:,:,37),wf(:,-3),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,12),MT,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,-4),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,28),MT,G3(:,:,:,57))
  call loop_AS_Q(G3(:,:,:,57),wf(:,1),G3(:,:,:,58),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,31),MT,G4tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,83),wf(:,-1),G2(:,:,:,85),gZu)
  call loop_A_Q(G2(:,:,:,85),Q(:,14),MT,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,-4),G3(:,:,:,60))
  call loop_A_Q(G3(:,:,:,60),Q(:,30),MT,G4(:,:,:,33))
  call loop_AZ_Q(G4(:,:,:,33),wf(:,0),G4(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,31),MT,G5tensor(:,17))
  call loop_AV_Q(G1(:,:,:,37),wf(:,-4),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,20),MT,G2(:,:,:,86))
  call loop_AV_Q(G2(:,:,:,86),wf(:,-3),G2(:,:,:,87))
  call loop_A_Q(G2(:,:,:,87),Q(:,28),MT,G3(:,:,:,61))
  call loop_AS_Q(G3(:,:,:,61),wf(:,1),G3(:,:,:,62),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,31),MT,G4tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,86),wf(:,-1),G2(:,:,:,88),gZu)
  call loop_A_Q(G2(:,:,:,88),Q(:,22),MT,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,-3),G3(:,:,:,64))
  call loop_A_Q(G3(:,:,:,64),Q(:,30),MT,G4(:,:,:,35))
  call loop_AZ_Q(G4(:,:,:,35),wf(:,0),G4(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,31),MT,G5tensor(:,18))
  call loop_AZ_Q(G1(:,:,:,37),wf(:,-1),G1(:,:,:,40),gZu)
  call loop_A_Q(G1(:,:,:,40),Q(:,6),MT,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-4),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,22),MT,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,-3),G3(:,:,:,66))
  call loop_A_Q(G3(:,:,:,66),Q(:,30),MT,G4(:,:,:,37))
  call loop_AZ_Q(G4(:,:,:,37),wf(:,0),G4(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,31),MT,G5tensor(:,19))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-3),G2(:,:,:,91))
  call loop_A_Q(G2(:,:,:,91),Q(:,14),MT,G3(:,:,:,67))
  call loop_AV_Q(G3(:,:,:,67),wf(:,-4),G3(:,:,:,68))
  call loop_A_Q(G3(:,:,:,68),Q(:,30),MT,G4(:,:,:,39))
  call loop_AZ_Q(G4(:,:,:,39),wf(:,0),G4(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,40),Q(:,31),MT,G5tensor(:,20))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,9),gZu)
  call loop_Q_A(G0(:,:,:,9),Q(:,4),MT,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,-3),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,12),MT,G2(:,:,:,92))
  call loop_QV_A(G2(:,:,:,92),wf(:,-4),G2(:,:,:,93))
  call loop_Q_A(G2(:,:,:,93),Q(:,28),MT,G3(:,:,:,69))
  call loop_QS_A(G3(:,:,:,69),wf(:,1),G3(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,31),MT,G4tensor(:,15))
  call loop_QZ_A(G2(:,:,:,92),wf(:,-1),G2(:,:,:,94),gZu)
  call loop_Q_A(G2(:,:,:,94),Q(:,14),MT,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,-4),G3(:,:,:,72))
  call loop_Q_A(G3(:,:,:,72),Q(:,30),MT,G4(:,:,:,41))
  call loop_QZ_A(G4(:,:,:,41),wf(:,0),G4(:,:,:,42),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,31),MT,G5tensor(:,21))
  call loop_QV_A(G1(:,:,:,41),wf(:,-4),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,20),MT,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,-3),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,28),MT,G3(:,:,:,73))
  call loop_QS_A(G3(:,:,:,73),wf(:,1),G3(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,31),MT,G4tensor(:,16))
  call loop_QZ_A(G2(:,:,:,95),wf(:,-1),G2(:,:,:,97),gZu)
  call loop_Q_A(G2(:,:,:,97),Q(:,22),MT,G3(:,:,:,75))
  call loop_QV_A(G3(:,:,:,75),wf(:,-3),G3(:,:,:,76))
  call loop_Q_A(G3(:,:,:,76),Q(:,30),MT,G4(:,:,:,43))
  call loop_QZ_A(G4(:,:,:,43),wf(:,0),G4(:,:,:,44),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,31),MT,G5tensor(:,22))
  call loop_QZ_A(G1(:,:,:,41),wf(:,-1),G1(:,:,:,44),gZu)
  call loop_Q_A(G1(:,:,:,44),Q(:,6),MT,G2(:,:,:,98))
  call loop_QV_A(G2(:,:,:,98),wf(:,-4),G2(:,:,:,99))
  call loop_Q_A(G2(:,:,:,99),Q(:,22),MT,G3(:,:,:,77))
  call loop_QV_A(G3(:,:,:,77),wf(:,-3),G3(:,:,:,78))
  call loop_Q_A(G3(:,:,:,78),Q(:,30),MT,G4(:,:,:,45))
  call loop_QZ_A(G4(:,:,:,45),wf(:,0),G4(:,:,:,46),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,31),MT,G5tensor(:,23))
  call loop_QV_A(G2(:,:,:,98),wf(:,-3),G2(:,:,:,100))
  call loop_Q_A(G2(:,:,:,100),Q(:,14),MT,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,-4),G3(:,:,:,80))
  call loop_Q_A(G3(:,:,:,80),Q(:,30),MT,G4(:,:,:,47))
  call loop_QZ_A(G4(:,:,:,47),wf(:,0),G4(:,:,:,48),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,31),MT,G5tensor(:,24))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,10),gZd)
  call loop_A_Q(G0(:,:,:,10),Q(:,4),MB,G1(:,:,:,45))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-3),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,12),MB,G2(:,:,:,101))
  call loop_AV_Q(G2(:,:,:,101),wf(:,-4),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,28),MB,G3(:,:,:,81))
  call loop_AS_Q(G3(:,:,:,81),wf(:,1),G3(:,:,:,82),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,31),MB,G4tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,101),wf(:,-1),G2(:,:,:,103),gZd)
  call loop_A_Q(G2(:,:,:,103),Q(:,14),MB,G3(:,:,:,83))
  call loop_AV_Q(G3(:,:,:,83),wf(:,-4),G3(:,:,:,84))
  call loop_A_Q(G3(:,:,:,84),Q(:,30),MB,G4(:,:,:,49))
  call loop_AZ_Q(G4(:,:,:,49),wf(:,0),G4(:,:,:,50),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,31),MB,G5tensor(:,25))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-4),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,20),MB,G2(:,:,:,104))
  call loop_AV_Q(G2(:,:,:,104),wf(:,-3),G2(:,:,:,105))
  call loop_A_Q(G2(:,:,:,105),Q(:,28),MB,G3(:,:,:,85))
  call loop_AS_Q(G3(:,:,:,85),wf(:,1),G3(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,31),MB,G4tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,104),wf(:,-1),G2(:,:,:,106),gZd)
  call loop_A_Q(G2(:,:,:,106),Q(:,22),MB,G3(:,:,:,87))
  call loop_AV_Q(G3(:,:,:,87),wf(:,-3),G3(:,:,:,88))
  call loop_A_Q(G3(:,:,:,88),Q(:,30),MB,G4(:,:,:,51))
  call loop_AZ_Q(G4(:,:,:,51),wf(:,0),G4(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,31),MB,G5tensor(:,26))
  call loop_AZ_Q(G1(:,:,:,45),wf(:,-1),G1(:,:,:,48),gZd)
  call loop_A_Q(G1(:,:,:,48),Q(:,6),MB,G2(:,:,:,107))
  call loop_AV_Q(G2(:,:,:,107),wf(:,-4),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,22),MB,G3(:,:,:,89))
  call loop_AV_Q(G3(:,:,:,89),wf(:,-3),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,30),MB,G4(:,:,:,53))
  call loop_AZ_Q(G4(:,:,:,53),wf(:,0),G4(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,31),MB,G5tensor(:,27))
  call loop_AV_Q(G2(:,:,:,107),wf(:,-3),G2(:,:,:,109))
  call loop_A_Q(G2(:,:,:,109),Q(:,14),MB,G3(:,:,:,91))
  call loop_AV_Q(G3(:,:,:,91),wf(:,-4),G3(:,:,:,92))
  call loop_A_Q(G3(:,:,:,92),Q(:,30),MB,G4(:,:,:,55))
  call loop_AZ_Q(G4(:,:,:,55),wf(:,0),G4(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,31),MB,G5tensor(:,28))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,11),gZd)
  call loop_Q_A(G0(:,:,:,11),Q(:,4),MB,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,-3),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,12),MB,G2(:,:,:,110))
  call loop_QV_A(G2(:,:,:,110),wf(:,-4),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,28),MB,G3(:,:,:,93))
  call loop_QS_A(G3(:,:,:,93),wf(:,1),G3(:,:,:,94),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,31),MB,G4tensor(:,19))
  call loop_QZ_A(G2(:,:,:,110),wf(:,-1),G2(:,:,:,112),gZd)
  call loop_Q_A(G2(:,:,:,112),Q(:,14),MB,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,-4),G3(:,:,:,96))
  call loop_Q_A(G3(:,:,:,96),Q(:,30),MB,G4(:,:,:,57))
  call loop_QZ_A(G4(:,:,:,57),wf(:,0),G4(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,31),MB,G5tensor(:,29))
  call loop_QV_A(G1(:,:,:,49),wf(:,-4),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,20),MB,G2(:,:,:,113))
  call loop_QV_A(G2(:,:,:,113),wf(:,-3),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,28),MB,G3(:,:,:,97))
  call loop_QS_A(G3(:,:,:,97),wf(:,1),G3(:,:,:,98),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,31),MB,G4tensor(:,20))
  call loop_QZ_A(G2(:,:,:,113),wf(:,-1),G2(:,:,:,115),gZd)
  call loop_Q_A(G2(:,:,:,115),Q(:,22),MB,G3(:,:,:,99))
  call loop_QV_A(G3(:,:,:,99),wf(:,-3),G3(:,:,:,100))
  call loop_Q_A(G3(:,:,:,100),Q(:,30),MB,G4(:,:,:,59))
  call loop_QZ_A(G4(:,:,:,59),wf(:,0),G4(:,:,:,60),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,31),MB,G5tensor(:,30))
  call loop_QZ_A(G1(:,:,:,49),wf(:,-1),G1(:,:,:,52),gZd)
  call loop_Q_A(G1(:,:,:,52),Q(:,6),MB,G2(:,:,:,116))
  call loop_QV_A(G2(:,:,:,116),wf(:,-4),G2(:,:,:,117))
  call loop_Q_A(G2(:,:,:,117),Q(:,22),MB,G3(:,:,:,101))
  call loop_QV_A(G3(:,:,:,101),wf(:,-3),G3(:,:,:,102))
  call loop_Q_A(G3(:,:,:,102),Q(:,30),MB,G4(:,:,:,61))
  call loop_QZ_A(G4(:,:,:,61),wf(:,0),G4(:,:,:,62),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,31),MB,G5tensor(:,31))
  call loop_QV_A(G2(:,:,:,116),wf(:,-3),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,14),MB,G3(:,:,:,103))
  call loop_QV_A(G3(:,:,:,103),wf(:,-4),G3(:,:,:,104))
  call loop_Q_A(G3(:,:,:,104),Q(:,30),MB,G4(:,:,:,63))
  call loop_QZ_A(G4(:,:,:,63),wf(:,0),G4(:,:,:,64),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,31),MB,G5tensor(:,32))
  call loop_QS_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,12),gH)
  call loop_Q_A(G0(:,:,:,12),Q(:,5),MT,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,-4),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,21),MT,G2(:,:,:,119))
  call loop_QV_A(G2(:,:,:,119),wf(:,-3),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,29),MT,G3(:,:,:,105))
  call loop_QZ_A(G3(:,:,:,105),wf(:,-1),G3(:,:,:,106),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,31),MT,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,53),wf(:,-3),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,13),MT,G2(:,:,:,121))
  call loop_QV_A(G2(:,:,:,121),wf(:,-4),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,29),MT,G3(:,:,:,107))
  call loop_QZ_A(G3(:,:,:,107),wf(:,-1),G3(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,31),MT,G4tensor(:,22))
  call loop_AS_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,13),gH)
  call loop_A_Q(G0(:,:,:,13),Q(:,5),MT,G1(:,:,:,56))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-4),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,21),MT,G2(:,:,:,123))
  call loop_AV_Q(G2(:,:,:,123),wf(:,-3),G2(:,:,:,124))
  call loop_A_Q(G2(:,:,:,124),Q(:,29),MT,G3(:,:,:,109))
  call loop_AZ_Q(G3(:,:,:,109),wf(:,-1),G3(:,:,:,110),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,31),MT,G4tensor(:,23))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-3),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,13),MT,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,-4),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,29),MT,G3(:,:,:,111))
  call loop_AZ_Q(G3(:,:,:,111),wf(:,-1),G3(:,:,:,112),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,112),Q(:,31),MT,G4tensor(:,24))
  call loop_QS_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,14),gH)
  call loop_Q_A(G0(:,:,:,14),Q(:,5),MB,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,-4),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,21),MB,G2(:,:,:,127))
  call loop_QV_A(G2(:,:,:,127),wf(:,-3),G2(:,:,:,128))
  call loop_Q_A(G2(:,:,:,128),Q(:,29),MB,G3(:,:,:,113))
  call loop_QZ_A(G3(:,:,:,113),wf(:,-1),G3(:,:,:,114),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,114),Q(:,31),MB,G4tensor(:,25))
  call loop_QV_A(G1(:,:,:,59),wf(:,-3),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,13),MB,G2(:,:,:,129))
  call loop_QV_A(G2(:,:,:,129),wf(:,-4),G2(:,:,:,130))
  call loop_Q_A(G2(:,:,:,130),Q(:,29),MB,G3(:,:,:,115))
  call loop_QZ_A(G3(:,:,:,115),wf(:,-1),G3(:,:,:,116),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,116),Q(:,31),MB,G4tensor(:,26))
  call loop_AS_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,15),gH)
  call loop_A_Q(G0(:,:,:,15),Q(:,5),MB,G1(:,:,:,62))
  call loop_AV_Q(G1(:,:,:,62),wf(:,-4),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,21),MB,G2(:,:,:,131))
  call loop_AV_Q(G2(:,:,:,131),wf(:,-3),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,29),MB,G3(:,:,:,117))
  call loop_AZ_Q(G3(:,:,:,117),wf(:,-1),G3(:,:,:,118),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,118),Q(:,31),MB,G4tensor(:,27))
  call loop_AV_Q(G1(:,:,:,62),wf(:,-3),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,13),MB,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-4),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,29),MB,G3(:,:,:,119))
  call loop_AZ_Q(G3(:,:,:,119),wf(:,-1),G3(:,:,:,120),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,120),Q(:,31),MB,G4tensor(:,28))
  call loop_QS_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,16),gH)
  call loop_Q_A(G0(:,:,:,16),Q(:,6),MT,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,-4),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,22),MT,G2(:,:,:,135))
  call loop_QV_A(G2(:,:,:,135),wf(:,-3),G2(:,:,:,136))
  call loop_Q_A(G2(:,:,:,136),Q(:,30),MT,G3(:,:,:,121))
  call loop_QZ_A(G3(:,:,:,121),wf(:,0),G3(:,:,:,122),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,31),MT,G4tensor(:,29))
  call loop_QV_A(G1(:,:,:,65),wf(:,-3),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,14),MT,G2(:,:,:,137))
  call loop_QV_A(G2(:,:,:,137),wf(:,-4),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,30),MT,G3(:,:,:,123))
  call loop_QZ_A(G3(:,:,:,123),wf(:,0),G3(:,:,:,124),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,31),MT,G4tensor(:,30))
  call loop_AS_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,17),gH)
  call loop_A_Q(G0(:,:,:,17),Q(:,6),MT,G1(:,:,:,68))
  call loop_AV_Q(G1(:,:,:,68),wf(:,-4),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,22),MT,G2(:,:,:,139))
  call loop_AV_Q(G2(:,:,:,139),wf(:,-3),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,30),MT,G3(:,:,:,125))
  call loop_AZ_Q(G3(:,:,:,125),wf(:,0),G3(:,:,:,126),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,126),Q(:,31),MT,G4tensor(:,31))
  call loop_AV_Q(G1(:,:,:,68),wf(:,-3),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,14),MT,G2(:,:,:,141))
  call loop_AV_Q(G2(:,:,:,141),wf(:,-4),G2(:,:,:,142))
  call loop_A_Q(G2(:,:,:,142),Q(:,30),MT,G3(:,:,:,127))
  call loop_AZ_Q(G3(:,:,:,127),wf(:,0),G3(:,:,:,128),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,128),Q(:,31),MT,G4tensor(:,32))
  call loop_QS_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,18),gH)
  call loop_Q_A(G0(:,:,:,18),Q(:,6),MB,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,-4),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,22),MB,G2(:,:,:,143))
  call loop_QV_A(G2(:,:,:,143),wf(:,-3),G2(:,:,:,144))
  call loop_Q_A(G2(:,:,:,144),Q(:,30),MB,G3(:,:,:,129))
  call loop_QZ_A(G3(:,:,:,129),wf(:,0),G3(:,:,:,130),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,31),MB,G4tensor(:,33))
  call loop_QV_A(G1(:,:,:,71),wf(:,-3),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,14),MB,G2(:,:,:,145))
  call loop_QV_A(G2(:,:,:,145),wf(:,-4),G2(:,:,:,146))
  call loop_Q_A(G2(:,:,:,146),Q(:,30),MB,G3(:,:,:,131))
  call loop_QZ_A(G3(:,:,:,131),wf(:,0),G3(:,:,:,132),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,132),Q(:,31),MB,G4tensor(:,34))
  call loop_AS_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,19),gH)
  call loop_A_Q(G0(:,:,:,19),Q(:,6),MB,G1(:,:,:,74))
  call loop_AV_Q(G1(:,:,:,74),wf(:,-4),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,22),MB,G2(:,:,:,147))
  call loop_AV_Q(G2(:,:,:,147),wf(:,-3),G2(:,:,:,148))
  call loop_A_Q(G2(:,:,:,148),Q(:,30),MB,G3(:,:,:,133))
  call loop_AZ_Q(G3(:,:,:,133),wf(:,0),G3(:,:,:,134),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,134),Q(:,31),MB,G4tensor(:,35))
  call loop_AV_Q(G1(:,:,:,74),wf(:,-3),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,14),MB,G2(:,:,:,149))
  call loop_AV_Q(G2(:,:,:,149),wf(:,-4),G2(:,:,:,150))
  call loop_A_Q(G2(:,:,:,150),Q(:,30),MB,G3(:,:,:,135))
  call loop_AZ_Q(G3(:,:,:,135),wf(:,0),G3(:,:,:,136),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,136),Q(:,31),MB,G4tensor(:,36))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,20),gZu)
  call loop_A_Q(G0(:,:,:,20),Q(:,2),ZERO,G1(:,:,:,77))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-3),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,10),ZERO,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,-4),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,26),ZERO,G3(:,:,:,137))
  call loop_AZ_Q(G3(:,:,:,137),wf(:,-2),G3(:,:,:,138),gZu)
  call loop_A_Q(G3(:,:,:,138),Q(:,30),ZERO,G4(:,:,:,65))
  call loop_AZ_Q(G4(:,:,:,65),wf(:,0),G4(:,:,:,66),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,31),ZERO,G5tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,151),wf(:,-2),G2(:,:,:,153),gZu)
  call loop_A_Q(G2(:,:,:,153),Q(:,14),ZERO,G3(:,:,:,139))
  call loop_AV_Q(G3(:,:,:,139),wf(:,-4),G3(:,:,:,140))
  call loop_A_Q(G3(:,:,:,140),Q(:,30),ZERO,G4(:,:,:,67))
  call loop_AZ_Q(G4(:,:,:,67),wf(:,0),G4(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,31),ZERO,G5tensor(:,34))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-4),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,18),ZERO,G2(:,:,:,154))
  call loop_AV_Q(G2(:,:,:,154),wf(:,-3),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,26),ZERO,G3(:,:,:,141))
  call loop_AZ_Q(G3(:,:,:,141),wf(:,-2),G3(:,:,:,142),gZu)
  call loop_A_Q(G3(:,:,:,142),Q(:,30),ZERO,G4(:,:,:,69))
  call loop_AZ_Q(G4(:,:,:,69),wf(:,0),G4(:,:,:,70),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,31),ZERO,G5tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,154),wf(:,-2),G2(:,:,:,156),gZu)
  call loop_A_Q(G2(:,:,:,156),Q(:,22),ZERO,G3(:,:,:,143))
  call loop_AV_Q(G3(:,:,:,143),wf(:,-3),G3(:,:,:,144))
  call loop_A_Q(G3(:,:,:,144),Q(:,30),ZERO,G4(:,:,:,71))
  call loop_AZ_Q(G4(:,:,:,71),wf(:,0),G4(:,:,:,72),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,31),ZERO,G5tensor(:,36))
  call loop_AZ_Q(G1(:,:,:,77),wf(:,-2),G1(:,:,:,80),gZu)
  call loop_A_Q(G1(:,:,:,80),Q(:,6),ZERO,G2(:,:,:,157))
  call loop_AV_Q(G2(:,:,:,157),wf(:,-4),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,22),ZERO,G3(:,:,:,145))
  call loop_AV_Q(G3(:,:,:,145),wf(:,-3),G3(:,:,:,146))
  call loop_A_Q(G3(:,:,:,146),Q(:,30),ZERO,G4(:,:,:,73))
  call loop_AZ_Q(G4(:,:,:,73),wf(:,0),G4(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,31),ZERO,G5tensor(:,37))
  call loop_AV_Q(G2(:,:,:,157),wf(:,-3),G2(:,:,:,159))
  call loop_A_Q(G2(:,:,:,159),Q(:,14),ZERO,G3(:,:,:,147))
  call loop_AV_Q(G3(:,:,:,147),wf(:,-4),G3(:,:,:,148))
  call loop_A_Q(G3(:,:,:,148),Q(:,30),ZERO,G4(:,:,:,75))
  call loop_AZ_Q(G4(:,:,:,75),wf(:,0),G4(:,:,:,76),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,31),ZERO,G5tensor(:,38))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,21),gZu)
  call loop_A_Q(G0(:,:,:,21),Q(:,2),MT,G1(:,:,:,81))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-3),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,10),MT,G2(:,:,:,160))
  call loop_AV_Q(G2(:,:,:,160),wf(:,-4),G2(:,:,:,161))
  call loop_A_Q(G2(:,:,:,161),Q(:,26),MT,G3(:,:,:,149))
  call loop_AZ_Q(G3(:,:,:,149),wf(:,-2),G3(:,:,:,150),gZu)
  call loop_A_Q(G3(:,:,:,150),Q(:,30),MT,G4(:,:,:,77))
  call loop_AZ_Q(G4(:,:,:,77),wf(:,0),G4(:,:,:,78),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,31),MT,G5tensor(:,39))
  call loop_AZ_Q(G2(:,:,:,160),wf(:,-2),G2(:,:,:,162),gZu)
  call loop_A_Q(G2(:,:,:,162),Q(:,14),MT,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,-4),G3(:,:,:,152))
  call loop_A_Q(G3(:,:,:,152),Q(:,30),MT,G4(:,:,:,79))
  call loop_AZ_Q(G4(:,:,:,79),wf(:,0),G4(:,:,:,80),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,31),MT,G5tensor(:,40))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-4),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,18),MT,G2(:,:,:,163))
  call loop_AV_Q(G2(:,:,:,163),wf(:,-3),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,26),MT,G3(:,:,:,153))
  call loop_AZ_Q(G3(:,:,:,153),wf(:,-2),G3(:,:,:,154),gZu)
  call loop_A_Q(G3(:,:,:,154),Q(:,30),MT,G4(:,:,:,81))
  call loop_AZ_Q(G4(:,:,:,81),wf(:,0),G4(:,:,:,82),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,31),MT,G5tensor(:,41))
  call loop_AZ_Q(G2(:,:,:,163),wf(:,-2),G2(:,:,:,165),gZu)
  call loop_A_Q(G2(:,:,:,165),Q(:,22),MT,G3(:,:,:,155))
  call loop_AV_Q(G3(:,:,:,155),wf(:,-3),G3(:,:,:,156))
  call loop_A_Q(G3(:,:,:,156),Q(:,30),MT,G4(:,:,:,83))
  call loop_AZ_Q(G4(:,:,:,83),wf(:,0),G4(:,:,:,84),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,31),MT,G5tensor(:,42))
  call loop_AZ_Q(G1(:,:,:,81),wf(:,-2),G1(:,:,:,84),gZu)
  call loop_A_Q(G1(:,:,:,84),Q(:,6),MT,G2(:,:,:,166))
  call loop_AV_Q(G2(:,:,:,166),wf(:,-4),G2(:,:,:,167))
  call loop_A_Q(G2(:,:,:,167),Q(:,22),MT,G3(:,:,:,157))
  call loop_AV_Q(G3(:,:,:,157),wf(:,-3),G3(:,:,:,158))
  call loop_A_Q(G3(:,:,:,158),Q(:,30),MT,G4(:,:,:,85))
  call loop_AZ_Q(G4(:,:,:,85),wf(:,0),G4(:,:,:,86),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,31),MT,G5tensor(:,43))
  call loop_AV_Q(G2(:,:,:,166),wf(:,-3),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,14),MT,G3(:,:,:,159))
  call loop_AV_Q(G3(:,:,:,159),wf(:,-4),G3(:,:,:,160))
  call loop_A_Q(G3(:,:,:,160),Q(:,30),MT,G4(:,:,:,87))
  call loop_AZ_Q(G4(:,:,:,87),wf(:,0),G4(:,:,:,88),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,88),Q(:,31),MT,G5tensor(:,44))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,22),gZu)
  call loop_Q_A(G0(:,:,:,22),Q(:,2),ZERO,G1(:,:,:,85))
  call loop_QV_A(G1(:,:,:,85),wf(:,-3),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,10),ZERO,G2(:,:,:,169))
  call loop_QV_A(G2(:,:,:,169),wf(:,-4),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,26),ZERO,G3(:,:,:,161))
  call loop_QZ_A(G3(:,:,:,161),wf(:,-2),G3(:,:,:,162),gZu)
  call loop_Q_A(G3(:,:,:,162),Q(:,30),ZERO,G4(:,:,:,89))
  call loop_QZ_A(G4(:,:,:,89),wf(:,0),G4(:,:,:,90),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,31),ZERO,G5tensor(:,45))
  call loop_QZ_A(G2(:,:,:,169),wf(:,-2),G2(:,:,:,171),gZu)
  call loop_Q_A(G2(:,:,:,171),Q(:,14),ZERO,G3(:,:,:,163))
  call loop_QV_A(G3(:,:,:,163),wf(:,-4),G3(:,:,:,164))
  call loop_Q_A(G3(:,:,:,164),Q(:,30),ZERO,G4(:,:,:,91))
  call loop_QZ_A(G4(:,:,:,91),wf(:,0),G4(:,:,:,92),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,31),ZERO,G5tensor(:,46))
  call loop_QV_A(G1(:,:,:,85),wf(:,-4),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,18),ZERO,G2(:,:,:,172))
  call loop_QV_A(G2(:,:,:,172),wf(:,-3),G2(:,:,:,173))
  call loop_Q_A(G2(:,:,:,173),Q(:,26),ZERO,G3(:,:,:,165))
  call loop_QZ_A(G3(:,:,:,165),wf(:,-2),G3(:,:,:,166),gZu)
  call loop_Q_A(G3(:,:,:,166),Q(:,30),ZERO,G4(:,:,:,93))
  call loop_QZ_A(G4(:,:,:,93),wf(:,0),G4(:,:,:,94),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,31),ZERO,G5tensor(:,47))
  call loop_QZ_A(G2(:,:,:,172),wf(:,-2),G2(:,:,:,174),gZu)
  call loop_Q_A(G2(:,:,:,174),Q(:,22),ZERO,G3(:,:,:,167))
  call loop_QV_A(G3(:,:,:,167),wf(:,-3),G3(:,:,:,168))
  call loop_Q_A(G3(:,:,:,168),Q(:,30),ZERO,G4(:,:,:,95))
  call loop_QZ_A(G4(:,:,:,95),wf(:,0),G4(:,:,:,96),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,31),ZERO,G5tensor(:,48))
  call loop_QZ_A(G1(:,:,:,85),wf(:,-2),G1(:,:,:,88),gZu)
  call loop_Q_A(G1(:,:,:,88),Q(:,6),ZERO,G2(:,:,:,175))
  call loop_QV_A(G2(:,:,:,175),wf(:,-4),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,22),ZERO,G3(:,:,:,169))
  call loop_QV_A(G3(:,:,:,169),wf(:,-3),G3(:,:,:,170))
  call loop_Q_A(G3(:,:,:,170),Q(:,30),ZERO,G4(:,:,:,97))
  call loop_QZ_A(G4(:,:,:,97),wf(:,0),G4(:,:,:,98),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,98),Q(:,31),ZERO,G5tensor(:,49))
  call loop_QV_A(G2(:,:,:,175),wf(:,-3),G2(:,:,:,177))
  call loop_Q_A(G2(:,:,:,177),Q(:,14),ZERO,G3(:,:,:,171))
  call loop_QV_A(G3(:,:,:,171),wf(:,-4),G3(:,:,:,172))
  call loop_Q_A(G3(:,:,:,172),Q(:,30),ZERO,G4(:,:,:,99))
  call loop_QZ_A(G4(:,:,:,99),wf(:,0),G4(:,:,:,100),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,100),Q(:,31),ZERO,G5tensor(:,50))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,23),gZu)
  call loop_Q_A(G0(:,:,:,23),Q(:,2),MT,G1(:,:,:,89))
  call loop_QV_A(G1(:,:,:,89),wf(:,-3),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,10),MT,G2(:,:,:,178))
  call loop_QV_A(G2(:,:,:,178),wf(:,-4),G2(:,:,:,179))
  call loop_Q_A(G2(:,:,:,179),Q(:,26),MT,G3(:,:,:,173))
  call loop_QZ_A(G3(:,:,:,173),wf(:,-2),G3(:,:,:,174),gZu)
  call loop_Q_A(G3(:,:,:,174),Q(:,30),MT,G4(:,:,:,101))
  call loop_QZ_A(G4(:,:,:,101),wf(:,0),G4(:,:,:,102),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,102),Q(:,31),MT,G5tensor(:,51))
  call loop_QZ_A(G2(:,:,:,178),wf(:,-2),G2(:,:,:,180),gZu)
  call loop_Q_A(G2(:,:,:,180),Q(:,14),MT,G3(:,:,:,175))
  call loop_QV_A(G3(:,:,:,175),wf(:,-4),G3(:,:,:,176))
  call loop_Q_A(G3(:,:,:,176),Q(:,30),MT,G4(:,:,:,103))
  call loop_QZ_A(G4(:,:,:,103),wf(:,0),G4(:,:,:,104),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,104),Q(:,31),MT,G5tensor(:,52))
  call loop_QV_A(G1(:,:,:,89),wf(:,-4),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,18),MT,G2(:,:,:,181))
  call loop_QV_A(G2(:,:,:,181),wf(:,-3),G2(:,:,:,182))
  call loop_Q_A(G2(:,:,:,182),Q(:,26),MT,G3(:,:,:,177))
  call loop_QZ_A(G3(:,:,:,177),wf(:,-2),G3(:,:,:,178),gZu)
  call loop_Q_A(G3(:,:,:,178),Q(:,30),MT,G4(:,:,:,105))
  call loop_QZ_A(G4(:,:,:,105),wf(:,0),G4(:,:,:,106),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,106),Q(:,31),MT,G5tensor(:,53))
  call loop_QZ_A(G2(:,:,:,181),wf(:,-2),G2(:,:,:,183),gZu)
  call loop_Q_A(G2(:,:,:,183),Q(:,22),MT,G3(:,:,:,179))
  call loop_QV_A(G3(:,:,:,179),wf(:,-3),G3(:,:,:,180))
  call loop_Q_A(G3(:,:,:,180),Q(:,30),MT,G4(:,:,:,107))
  call loop_QZ_A(G4(:,:,:,107),wf(:,0),G4(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,108),Q(:,31),MT,G5tensor(:,54))
  call loop_QZ_A(G1(:,:,:,89),wf(:,-2),G1(:,:,:,92),gZu)
  call loop_Q_A(G1(:,:,:,92),Q(:,6),MT,G2(:,:,:,184))
  call loop_QV_A(G2(:,:,:,184),wf(:,-4),G2(:,:,:,185))
  call loop_Q_A(G2(:,:,:,185),Q(:,22),MT,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,-3),G3(:,:,:,182))
  call loop_Q_A(G3(:,:,:,182),Q(:,30),MT,G4(:,:,:,109))
  call loop_QZ_A(G4(:,:,:,109),wf(:,0),G4(:,:,:,110),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,31),MT,G5tensor(:,55))
  call loop_QV_A(G2(:,:,:,184),wf(:,-3),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,14),MT,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,-4),G3(:,:,:,184))
  call loop_Q_A(G3(:,:,:,184),Q(:,30),MT,G4(:,:,:,111))
  call loop_QZ_A(G4(:,:,:,111),wf(:,0),G4(:,:,:,112),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,112),Q(:,31),MT,G5tensor(:,56))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,24),gZd)
  call loop_A_Q(G0(:,:,:,24),Q(:,2),ZERO,G1(:,:,:,93))
  call loop_AV_Q(G1(:,:,:,93),wf(:,-3),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,10),ZERO,G2(:,:,:,187))
  call loop_AV_Q(G2(:,:,:,187),wf(:,-4),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,26),ZERO,G3(:,:,:,185))
  call loop_AZ_Q(G3(:,:,:,185),wf(:,-2),G3(:,:,:,186),gZd)
  call loop_A_Q(G3(:,:,:,186),Q(:,30),ZERO,G4(:,:,:,113))
  call loop_AZ_Q(G4(:,:,:,113),wf(:,0),G4(:,:,:,114),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,114),Q(:,31),ZERO,G5tensor(:,57))
  call loop_AZ_Q(G2(:,:,:,187),wf(:,-2),G2(:,:,:,189),gZd)
  call loop_A_Q(G2(:,:,:,189),Q(:,14),ZERO,G3(:,:,:,187))
  call loop_AV_Q(G3(:,:,:,187),wf(:,-4),G3(:,:,:,188))
  call loop_A_Q(G3(:,:,:,188),Q(:,30),ZERO,G4(:,:,:,115))
  call loop_AZ_Q(G4(:,:,:,115),wf(:,0),G4(:,:,:,116),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,116),Q(:,31),ZERO,G5tensor(:,58))
  call loop_AV_Q(G1(:,:,:,93),wf(:,-4),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,18),ZERO,G2(:,:,:,190))
  call loop_AV_Q(G2(:,:,:,190),wf(:,-3),G2(:,:,:,191))
  call loop_A_Q(G2(:,:,:,191),Q(:,26),ZERO,G3(:,:,:,189))
  call loop_AZ_Q(G3(:,:,:,189),wf(:,-2),G3(:,:,:,190),gZd)
  call loop_A_Q(G3(:,:,:,190),Q(:,30),ZERO,G4(:,:,:,117))
  call loop_AZ_Q(G4(:,:,:,117),wf(:,0),G4(:,:,:,118),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,118),Q(:,31),ZERO,G5tensor(:,59))
  call loop_AZ_Q(G2(:,:,:,190),wf(:,-2),G2(:,:,:,192),gZd)
  call loop_A_Q(G2(:,:,:,192),Q(:,22),ZERO,G3(:,:,:,191))
  call loop_AV_Q(G3(:,:,:,191),wf(:,-3),G3(:,:,:,192))
  call loop_A_Q(G3(:,:,:,192),Q(:,30),ZERO,G4(:,:,:,119))
  call loop_AZ_Q(G4(:,:,:,119),wf(:,0),G4(:,:,:,120),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,120),Q(:,31),ZERO,G5tensor(:,60))
  call loop_AZ_Q(G1(:,:,:,93),wf(:,-2),G1(:,:,:,96),gZd)
  call loop_A_Q(G1(:,:,:,96),Q(:,6),ZERO,G2(:,:,:,193))
  call loop_AV_Q(G2(:,:,:,193),wf(:,-4),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,22),ZERO,G3(:,:,:,193))
  call loop_AV_Q(G3(:,:,:,193),wf(:,-3),G3(:,:,:,194))
  call loop_A_Q(G3(:,:,:,194),Q(:,30),ZERO,G4(:,:,:,121))
  call loop_AZ_Q(G4(:,:,:,121),wf(:,0),G4(:,:,:,122),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,31),ZERO,G5tensor(:,61))
  call loop_AV_Q(G2(:,:,:,193),wf(:,-3),G2(:,:,:,195))
  call loop_A_Q(G2(:,:,:,195),Q(:,14),ZERO,G3(:,:,:,195))
  call loop_AV_Q(G3(:,:,:,195),wf(:,-4),G3(:,:,:,196))
  call loop_A_Q(G3(:,:,:,196),Q(:,30),ZERO,G4(:,:,:,123))
  call loop_AZ_Q(G4(:,:,:,123),wf(:,0),G4(:,:,:,124),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,124),Q(:,31),ZERO,G5tensor(:,62))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,25),gZd)
  call loop_A_Q(G0(:,:,:,25),Q(:,2),MB,G1(:,:,:,97))
  call loop_AV_Q(G1(:,:,:,97),wf(:,-3),G1(:,:,:,98))
  call loop_A_Q(G1(:,:,:,98),Q(:,10),MB,G2(:,:,:,196))
  call loop_AV_Q(G2(:,:,:,196),wf(:,-4),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,26),MB,G3(:,:,:,197))
  call loop_AZ_Q(G3(:,:,:,197),wf(:,-2),G3(:,:,:,198),gZd)
  call loop_A_Q(G3(:,:,:,198),Q(:,30),MB,G4(:,:,:,125))
  call loop_AZ_Q(G4(:,:,:,125),wf(:,0),G4(:,:,:,126),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,126),Q(:,31),MB,G5tensor(:,63))
  call loop_AZ_Q(G2(:,:,:,196),wf(:,-2),G2(:,:,:,198),gZd)
  call loop_A_Q(G2(:,:,:,198),Q(:,14),MB,G3(:,:,:,199))
  call loop_AV_Q(G3(:,:,:,199),wf(:,-4),G3(:,:,:,200))
  call loop_A_Q(G3(:,:,:,200),Q(:,30),MB,G4(:,:,:,127))
  call loop_AZ_Q(G4(:,:,:,127),wf(:,0),G4(:,:,:,128),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,31),MB,G5tensor(:,64))
  call loop_AV_Q(G1(:,:,:,97),wf(:,-4),G1(:,:,:,99))
  call loop_A_Q(G1(:,:,:,99),Q(:,18),MB,G2(:,:,:,199))
  call loop_AV_Q(G2(:,:,:,199),wf(:,-3),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,26),MB,G3(:,:,:,201))
  call loop_AZ_Q(G3(:,:,:,201),wf(:,-2),G3(:,:,:,202),gZd)
  call loop_A_Q(G3(:,:,:,202),Q(:,30),MB,G4(:,:,:,129))
  call loop_AZ_Q(G4(:,:,:,129),wf(:,0),G4(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,130),Q(:,31),MB,G5tensor(:,65))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,-2),G2(:,:,:,201),gZd)
  call loop_A_Q(G2(:,:,:,201),Q(:,22),MB,G3(:,:,:,203))
  call loop_AV_Q(G3(:,:,:,203),wf(:,-3),G3(:,:,:,204))
  call loop_A_Q(G3(:,:,:,204),Q(:,30),MB,G4(:,:,:,131))
  call loop_AZ_Q(G4(:,:,:,131),wf(:,0),G4(:,:,:,132),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,132),Q(:,31),MB,G5tensor(:,66))
  call loop_AZ_Q(G1(:,:,:,97),wf(:,-2),G1(:,:,:,100),gZd)
  call loop_A_Q(G1(:,:,:,100),Q(:,6),MB,G2(:,:,:,202))
  call loop_AV_Q(G2(:,:,:,202),wf(:,-4),G2(:,:,:,203))
  call loop_A_Q(G2(:,:,:,203),Q(:,22),MB,G3(:,:,:,205))
  call loop_AV_Q(G3(:,:,:,205),wf(:,-3),G3(:,:,:,206))
  call loop_A_Q(G3(:,:,:,206),Q(:,30),MB,G4(:,:,:,133))
  call loop_AZ_Q(G4(:,:,:,133),wf(:,0),G4(:,:,:,134),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,134),Q(:,31),MB,G5tensor(:,67))
  call loop_AV_Q(G2(:,:,:,202),wf(:,-3),G2(:,:,:,204))
  call loop_A_Q(G2(:,:,:,204),Q(:,14),MB,G3(:,:,:,207))
  call loop_AV_Q(G3(:,:,:,207),wf(:,-4),G3(:,:,:,208))
  call loop_A_Q(G3(:,:,:,208),Q(:,30),MB,G4(:,:,:,135))
  call loop_AZ_Q(G4(:,:,:,135),wf(:,0),G4(:,:,:,136),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,136),Q(:,31),MB,G5tensor(:,68))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,26),gZd)
  call loop_Q_A(G0(:,:,:,26),Q(:,2),ZERO,G1(:,:,:,101))
  call loop_QV_A(G1(:,:,:,101),wf(:,-3),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,10),ZERO,G2(:,:,:,205))
  call loop_QV_A(G2(:,:,:,205),wf(:,-4),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,26),ZERO,G3(:,:,:,209))
  call loop_QZ_A(G3(:,:,:,209),wf(:,-2),G3(:,:,:,210),gZd)
  call loop_Q_A(G3(:,:,:,210),Q(:,30),ZERO,G4(:,:,:,137))
  call loop_QZ_A(G4(:,:,:,137),wf(:,0),G4(:,:,:,138),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,138),Q(:,31),ZERO,G5tensor(:,69))
  call loop_QZ_A(G2(:,:,:,205),wf(:,-2),G2(:,:,:,207),gZd)
  call loop_Q_A(G2(:,:,:,207),Q(:,14),ZERO,G3(:,:,:,211))
  call loop_QV_A(G3(:,:,:,211),wf(:,-4),G3(:,:,:,212))
  call loop_Q_A(G3(:,:,:,212),Q(:,30),ZERO,G4(:,:,:,139))
  call loop_QZ_A(G4(:,:,:,139),wf(:,0),G4(:,:,:,140),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,140),Q(:,31),ZERO,G5tensor(:,70))
  call loop_QV_A(G1(:,:,:,101),wf(:,-4),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,18),ZERO,G2(:,:,:,208))
  call loop_QV_A(G2(:,:,:,208),wf(:,-3),G2(:,:,:,209))
  call loop_Q_A(G2(:,:,:,209),Q(:,26),ZERO,G3(:,:,:,213))
  call loop_QZ_A(G3(:,:,:,213),wf(:,-2),G3(:,:,:,214),gZd)
  call loop_Q_A(G3(:,:,:,214),Q(:,30),ZERO,G4(:,:,:,141))
  call loop_QZ_A(G4(:,:,:,141),wf(:,0),G4(:,:,:,142),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,142),Q(:,31),ZERO,G5tensor(:,71))
  call loop_QZ_A(G2(:,:,:,208),wf(:,-2),G2(:,:,:,210),gZd)
  call loop_Q_A(G2(:,:,:,210),Q(:,22),ZERO,G3(:,:,:,215))
  call loop_QV_A(G3(:,:,:,215),wf(:,-3),G3(:,:,:,216))
  call loop_Q_A(G3(:,:,:,216),Q(:,30),ZERO,G4(:,:,:,143))
  call loop_QZ_A(G4(:,:,:,143),wf(:,0),G4(:,:,:,144),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,144),Q(:,31),ZERO,G5tensor(:,72))
  call loop_QZ_A(G1(:,:,:,101),wf(:,-2),G1(:,:,:,104),gZd)
  call loop_Q_A(G1(:,:,:,104),Q(:,6),ZERO,G2(:,:,:,211))
  call loop_QV_A(G2(:,:,:,211),wf(:,-4),G2(:,:,:,212))
  call loop_Q_A(G2(:,:,:,212),Q(:,22),ZERO,G3(:,:,:,217))
  call loop_QV_A(G3(:,:,:,217),wf(:,-3),G3(:,:,:,218))
  call loop_Q_A(G3(:,:,:,218),Q(:,30),ZERO,G4(:,:,:,145))
  call loop_QZ_A(G4(:,:,:,145),wf(:,0),G4(:,:,:,146),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,146),Q(:,31),ZERO,G5tensor(:,73))
  call loop_QV_A(G2(:,:,:,211),wf(:,-3),G2(:,:,:,213))
  call loop_Q_A(G2(:,:,:,213),Q(:,14),ZERO,G3(:,:,:,219))
  call loop_QV_A(G3(:,:,:,219),wf(:,-4),G3(:,:,:,220))
  call loop_Q_A(G3(:,:,:,220),Q(:,30),ZERO,G4(:,:,:,147))
  call loop_QZ_A(G4(:,:,:,147),wf(:,0),G4(:,:,:,148),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,148),Q(:,31),ZERO,G5tensor(:,74))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,27),gZd)
  call loop_Q_A(G0(:,:,:,27),Q(:,2),MB,G1(:,:,:,105))
  call loop_QV_A(G1(:,:,:,105),wf(:,-3),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,10),MB,G2(:,:,:,214))
  call loop_QV_A(G2(:,:,:,214),wf(:,-4),G2(:,:,:,215))
  call loop_Q_A(G2(:,:,:,215),Q(:,26),MB,G3(:,:,:,221))
  call loop_QZ_A(G3(:,:,:,221),wf(:,-2),G3(:,:,:,222),gZd)
  call loop_Q_A(G3(:,:,:,222),Q(:,30),MB,G4(:,:,:,149))
  call loop_QZ_A(G4(:,:,:,149),wf(:,0),G4(:,:,:,150),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,150),Q(:,31),MB,G5tensor(:,75))
  call loop_QZ_A(G2(:,:,:,214),wf(:,-2),G2(:,:,:,216),gZd)
  call loop_Q_A(G2(:,:,:,216),Q(:,14),MB,G3(:,:,:,223))
  call loop_QV_A(G3(:,:,:,223),wf(:,-4),G3(:,:,:,224))
  call loop_Q_A(G3(:,:,:,224),Q(:,30),MB,G4(:,:,:,151))
  call loop_QZ_A(G4(:,:,:,151),wf(:,0),G4(:,:,:,152),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,152),Q(:,31),MB,G5tensor(:,76))
  call loop_QV_A(G1(:,:,:,105),wf(:,-4),G1(:,:,:,107))
  call loop_Q_A(G1(:,:,:,107),Q(:,18),MB,G2(:,:,:,217))
  call loop_QV_A(G2(:,:,:,217),wf(:,-3),G2(:,:,:,218))
  call loop_Q_A(G2(:,:,:,218),Q(:,26),MB,G3(:,:,:,225))
  call loop_QZ_A(G3(:,:,:,225),wf(:,-2),G3(:,:,:,226),gZd)
  call loop_Q_A(G3(:,:,:,226),Q(:,30),MB,G4(:,:,:,153))
  call loop_QZ_A(G4(:,:,:,153),wf(:,0),G4(:,:,:,154),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,154),Q(:,31),MB,G5tensor(:,77))
  call loop_QZ_A(G2(:,:,:,217),wf(:,-2),G2(:,:,:,219),gZd)
  call loop_Q_A(G2(:,:,:,219),Q(:,22),MB,G3(:,:,:,227))
  call loop_QV_A(G3(:,:,:,227),wf(:,-3),G3(:,:,:,228))
  call loop_Q_A(G3(:,:,:,228),Q(:,30),MB,G4(:,:,:,155))
  call loop_QZ_A(G4(:,:,:,155),wf(:,0),G4(:,:,:,156),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,156),Q(:,31),MB,G5tensor(:,78))
  call loop_QZ_A(G1(:,:,:,105),wf(:,-2),G1(:,:,:,108),gZd)
  call loop_Q_A(G1(:,:,:,108),Q(:,6),MB,G2(:,:,:,220))
  call loop_QV_A(G2(:,:,:,220),wf(:,-4),G2(:,:,:,221))
  call loop_Q_A(G2(:,:,:,221),Q(:,22),MB,G3(:,:,:,229))
  call loop_QV_A(G3(:,:,:,229),wf(:,-3),G3(:,:,:,230))
  call loop_Q_A(G3(:,:,:,230),Q(:,30),MB,G4(:,:,:,157))
  call loop_QZ_A(G4(:,:,:,157),wf(:,0),G4(:,:,:,158),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,158),Q(:,31),MB,G5tensor(:,79))
  call loop_QV_A(G2(:,:,:,220),wf(:,-3),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,14),MB,G3(:,:,:,231))
  call loop_QV_A(G3(:,:,:,231),wf(:,-4),G3(:,:,:,232))
  call loop_Q_A(G3(:,:,:,232),Q(:,30),MB,G4(:,:,:,159))
  call loop_QZ_A(G4(:,:,:,159),wf(:,0),G4(:,:,:,160),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,160),Q(:,31),MB,G5tensor(:,80))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,28),gZu)
  call loop_A_Q(G0(:,:,:,28),Q(:,4),ZERO,G1(:,:,:,109))
  call loop_AZ_Q(G1(:,:,:,109),wf(:,-1),G1(:,:,:,110),gZu)
  call loop_A_Q(G1(:,:,:,110),Q(:,6),ZERO,G2(:,:,:,223))
  call loop_AV_Q(G2(:,:,:,223),wf(:,-4),G2(:,:,:,224))
  call loop_A_Q(G2(:,:,:,224),Q(:,22),ZERO,G3(:,:,:,233))
  call loop_AV_Q(G3(:,:,:,233),wf(:,-3),G3(:,:,:,234))
  call loop_A_Q(G3(:,:,:,234),Q(:,30),ZERO,G4(:,:,:,161))
  call loop_AZ_Q(G4(:,:,:,161),wf(:,0),G4(:,:,:,162),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,162),Q(:,31),ZERO,G5tensor(:,81))
  call loop_AV_Q(G2(:,:,:,223),wf(:,-3),G2(:,:,:,225))
  call loop_A_Q(G2(:,:,:,225),Q(:,14),ZERO,G3(:,:,:,235))
  call loop_AV_Q(G3(:,:,:,235),wf(:,-4),G3(:,:,:,236))
  call loop_A_Q(G3(:,:,:,236),Q(:,30),ZERO,G4(:,:,:,163))
  call loop_AZ_Q(G4(:,:,:,163),wf(:,0),G4(:,:,:,164),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,164),Q(:,31),ZERO,G5tensor(:,82))
  call loop_AV_Q(G1(:,:,:,109),wf(:,-4),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,20),ZERO,G2(:,:,:,226))
  call loop_AZ_Q(G2(:,:,:,226),wf(:,-1),G2(:,:,:,227),gZu)
  call loop_A_Q(G2(:,:,:,227),Q(:,22),ZERO,G3(:,:,:,237))
  call loop_AV_Q(G3(:,:,:,237),wf(:,-3),G3(:,:,:,238))
  call loop_A_Q(G3(:,:,:,238),Q(:,30),ZERO,G4(:,:,:,165))
  call loop_AZ_Q(G4(:,:,:,165),wf(:,0),G4(:,:,:,166),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,166),Q(:,31),ZERO,G5tensor(:,83))
  call loop_AV_Q(G1(:,:,:,109),wf(:,-3),G1(:,:,:,112))
  call loop_A_Q(G1(:,:,:,112),Q(:,12),ZERO,G2(:,:,:,228))
  call loop_AZ_Q(G2(:,:,:,228),wf(:,-1),G2(:,:,:,229),gZu)
  call loop_A_Q(G2(:,:,:,229),Q(:,14),ZERO,G3(:,:,:,239))
  call loop_AV_Q(G3(:,:,:,239),wf(:,-4),G3(:,:,:,240))
  call loop_A_Q(G3(:,:,:,240),Q(:,30),ZERO,G4(:,:,:,167))
  call loop_AZ_Q(G4(:,:,:,167),wf(:,0),G4(:,:,:,168),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,168),Q(:,31),ZERO,G5tensor(:,84))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,29),gZu)
  call loop_Q_A(G0(:,:,:,29),Q(:,4),ZERO,G1(:,:,:,113))
  call loop_QZ_A(G1(:,:,:,113),wf(:,-1),G1(:,:,:,114),gZu)
  call loop_Q_A(G1(:,:,:,114),Q(:,6),ZERO,G2(:,:,:,230))
  call loop_QV_A(G2(:,:,:,230),wf(:,-4),G2(:,:,:,231))
  call loop_Q_A(G2(:,:,:,231),Q(:,22),ZERO,G3(:,:,:,241))
  call loop_QV_A(G3(:,:,:,241),wf(:,-3),G3(:,:,:,242))
  call loop_Q_A(G3(:,:,:,242),Q(:,30),ZERO,G4(:,:,:,169))
  call loop_QZ_A(G4(:,:,:,169),wf(:,0),G4(:,:,:,170),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,170),Q(:,31),ZERO,G5tensor(:,85))
  call loop_QV_A(G2(:,:,:,230),wf(:,-3),G2(:,:,:,232))
  call loop_Q_A(G2(:,:,:,232),Q(:,14),ZERO,G3(:,:,:,243))
  call loop_QV_A(G3(:,:,:,243),wf(:,-4),G3(:,:,:,244))
  call loop_Q_A(G3(:,:,:,244),Q(:,30),ZERO,G4(:,:,:,171))
  call loop_QZ_A(G4(:,:,:,171),wf(:,0),G4(:,:,:,172),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,172),Q(:,31),ZERO,G5tensor(:,86))
  call loop_QV_A(G1(:,:,:,113),wf(:,-4),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,20),ZERO,G2(:,:,:,233))
  call loop_QZ_A(G2(:,:,:,233),wf(:,-1),G2(:,:,:,234),gZu)
  call loop_Q_A(G2(:,:,:,234),Q(:,22),ZERO,G3(:,:,:,245))
  call loop_QV_A(G3(:,:,:,245),wf(:,-3),G3(:,:,:,246))
  call loop_Q_A(G3(:,:,:,246),Q(:,30),ZERO,G4(:,:,:,173))
  call loop_QZ_A(G4(:,:,:,173),wf(:,0),G4(:,:,:,174),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,174),Q(:,31),ZERO,G5tensor(:,87))
  call loop_QV_A(G1(:,:,:,113),wf(:,-3),G1(:,:,:,116))
  call loop_Q_A(G1(:,:,:,116),Q(:,12),ZERO,G2(:,:,:,235))
  call loop_QZ_A(G2(:,:,:,235),wf(:,-1),G2(:,:,:,236),gZu)
  call loop_Q_A(G2(:,:,:,236),Q(:,14),ZERO,G3(:,:,:,247))
  call loop_QV_A(G3(:,:,:,247),wf(:,-4),G3(:,:,:,248))
  call loop_Q_A(G3(:,:,:,248),Q(:,30),ZERO,G4(:,:,:,175))
  call loop_QZ_A(G4(:,:,:,175),wf(:,0),G4(:,:,:,176),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,176),Q(:,31),ZERO,G5tensor(:,88))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,30),gZd)
  call loop_A_Q(G0(:,:,:,30),Q(:,4),ZERO,G1(:,:,:,117))
  call loop_AZ_Q(G1(:,:,:,117),wf(:,-1),G1(:,:,:,118),gZd)
  call loop_A_Q(G1(:,:,:,118),Q(:,6),ZERO,G2(:,:,:,237))
  call loop_AV_Q(G2(:,:,:,237),wf(:,-4),G2(:,:,:,238))
  call loop_A_Q(G2(:,:,:,238),Q(:,22),ZERO,G3(:,:,:,249))
  call loop_AV_Q(G3(:,:,:,249),wf(:,-3),G3(:,:,:,250))
  call loop_A_Q(G3(:,:,:,250),Q(:,30),ZERO,G4(:,:,:,177))
  call loop_AZ_Q(G4(:,:,:,177),wf(:,0),G4(:,:,:,178),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,178),Q(:,31),ZERO,G5tensor(:,89))
  call loop_AV_Q(G2(:,:,:,237),wf(:,-3),G2(:,:,:,239))
  call loop_A_Q(G2(:,:,:,239),Q(:,14),ZERO,G3(:,:,:,251))
  call loop_AV_Q(G3(:,:,:,251),wf(:,-4),G3(:,:,:,252))
  call loop_A_Q(G3(:,:,:,252),Q(:,30),ZERO,G4(:,:,:,179))
  call loop_AZ_Q(G4(:,:,:,179),wf(:,0),G4(:,:,:,180),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,180),Q(:,31),ZERO,G5tensor(:,90))
  call loop_AV_Q(G1(:,:,:,117),wf(:,-4),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,20),ZERO,G2(:,:,:,240))
  call loop_AZ_Q(G2(:,:,:,240),wf(:,-1),G2(:,:,:,241),gZd)
  call loop_A_Q(G2(:,:,:,241),Q(:,22),ZERO,G3(:,:,:,253))
  call loop_AV_Q(G3(:,:,:,253),wf(:,-3),G3(:,:,:,254))
  call loop_A_Q(G3(:,:,:,254),Q(:,30),ZERO,G4(:,:,:,181))
  call loop_AZ_Q(G4(:,:,:,181),wf(:,0),G4(:,:,:,182),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,182),Q(:,31),ZERO,G5tensor(:,91))
  call loop_AV_Q(G1(:,:,:,117),wf(:,-3),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,12),ZERO,G2(:,:,:,242))
  call loop_AZ_Q(G2(:,:,:,242),wf(:,-1),G2(:,:,:,243),gZd)
  call loop_A_Q(G2(:,:,:,243),Q(:,14),ZERO,G3(:,:,:,255))
  call loop_AV_Q(G3(:,:,:,255),wf(:,-4),G3(:,:,:,256))
  call loop_A_Q(G3(:,:,:,256),Q(:,30),ZERO,G4(:,:,:,183))
  call loop_AZ_Q(G4(:,:,:,183),wf(:,0),G4(:,:,:,184),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,184),Q(:,31),ZERO,G5tensor(:,92))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,31),gZd)
  call loop_Q_A(G0(:,:,:,31),Q(:,4),ZERO,G1(:,:,:,121))
  call loop_QZ_A(G1(:,:,:,121),wf(:,-1),G1(:,:,:,122),gZd)
  call loop_Q_A(G1(:,:,:,122),Q(:,6),ZERO,G2(:,:,:,244))
  call loop_QV_A(G2(:,:,:,244),wf(:,-4),G2(:,:,:,245))
  call loop_Q_A(G2(:,:,:,245),Q(:,22),ZERO,G3(:,:,:,257))
  call loop_QV_A(G3(:,:,:,257),wf(:,-3),G3(:,:,:,258))
  call loop_Q_A(G3(:,:,:,258),Q(:,30),ZERO,G4(:,:,:,185))
  call loop_QZ_A(G4(:,:,:,185),wf(:,0),G4(:,:,:,186),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,186),Q(:,31),ZERO,G5tensor(:,93))
  call loop_QV_A(G2(:,:,:,244),wf(:,-3),G2(:,:,:,246))
  call loop_Q_A(G2(:,:,:,246),Q(:,14),ZERO,G3(:,:,:,259))
  call loop_QV_A(G3(:,:,:,259),wf(:,-4),G3(:,:,:,260))
  call loop_Q_A(G3(:,:,:,260),Q(:,30),ZERO,G4(:,:,:,187))
  call loop_QZ_A(G4(:,:,:,187),wf(:,0),G4(:,:,:,188),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,188),Q(:,31),ZERO,G5tensor(:,94))
  call loop_QV_A(G1(:,:,:,121),wf(:,-4),G1(:,:,:,123))
  call loop_Q_A(G1(:,:,:,123),Q(:,20),ZERO,G2(:,:,:,247))
  call loop_QZ_A(G2(:,:,:,247),wf(:,-1),G2(:,:,:,248),gZd)
  call loop_Q_A(G2(:,:,:,248),Q(:,22),ZERO,G3(:,:,:,261))
  call loop_QV_A(G3(:,:,:,261),wf(:,-3),G3(:,:,:,262))
  call loop_Q_A(G3(:,:,:,262),Q(:,30),ZERO,G4(:,:,:,189))
  call loop_QZ_A(G4(:,:,:,189),wf(:,0),G4(:,:,:,190),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,190),Q(:,31),ZERO,G5tensor(:,95))
  call loop_QV_A(G1(:,:,:,121),wf(:,-3),G1(:,:,:,124))
  call loop_Q_A(G1(:,:,:,124),Q(:,12),ZERO,G2(:,:,:,249))
  call loop_QZ_A(G2(:,:,:,249),wf(:,-1),G2(:,:,:,250),gZd)
  call loop_Q_A(G2(:,:,:,250),Q(:,14),ZERO,G3(:,:,:,263))
  call loop_QV_A(G3(:,:,:,263),wf(:,-4),G3(:,:,:,264))
  call loop_Q_A(G3(:,:,:,264),Q(:,30),ZERO,G4(:,:,:,191))
  call loop_QZ_A(G4(:,:,:,191),wf(:,0),G4(:,:,:,192),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,192),Q(:,31),ZERO,G5tensor(:,96))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-f(5) * den(9)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(9)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(9)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(9)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(9)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(9)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,3))
  M(1) = M(1) + (-f(5) * den(9)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(9)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,3))
  M(1) = M(1) + (-f(7) * den(1)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,4),T4sum(1:70,1))
  M(1) = M(1) + (-f(7) * den(1)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,10),T4sum(1:70,2))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,7),T4sum(1:70,2))
  M(1) = M(1) + (-f(7) * den(1)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,13),T4sum(1:70,3))
  M(1) = M(1) + (-f(7) * den(1)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,15),T4sum(1:70,3))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,17),T4sum(1:70,4))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,19),T4sum(1:70,4))
  M(1) = M(1) + (-f(7) * den(1)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,14),T4sum(1:70,5))
  M(1) = M(1) + (-f(7) * den(1)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,16),T4sum(1:70,5))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,18),T4sum(1:70,6))
  M(1) = M(1) + (-f(6) * den(1)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,20),T4sum(1:70,6))
  M(1) = M(1) + (-f(5) * den(10)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(10)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(10)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(10)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(10)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(10)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,3))
  M(1) = M(1) + (-f(5) * den(10)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(10)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,3))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,2),T4sum(1:70,7))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,5),T4sum(1:70,7))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,8),T4sum(1:70,8))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,11),T4sum(1:70,8))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,21),T4sum(1:70,9))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,23),T4sum(1:70,9))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,25),T4sum(1:70,10))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,27),T4sum(1:70,10))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,22),T4sum(1:70,11))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,24),T4sum(1:70,11))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,26),T4sum(1:70,12))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,28),T4sum(1:70,12))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,3))
  M(1) = M(1) + (-f(5) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-f(4) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,3))
  M(1) = M(1) + (-f(7) * den(6)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,3),T4sum(1:70,13))
  M(1) = M(1) + (-f(7) * den(6)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,6),T4sum(1:70,13))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,9),T4sum(1:70,14))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,12),T4sum(1:70,14))
  M(1) = M(1) + (-f(7) * den(6)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,29),T4sum(1:70,15))
  M(1) = M(1) + (-f(7) * den(6)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,31),T4sum(1:70,15))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,33),T4sum(1:70,16))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,35),T4sum(1:70,16))
  M(1) = M(1) + (-f(7) * den(6)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,30),T4sum(1:70,17))
  M(1) = M(1) + (-f(7) * den(6)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,32),T4sum(1:70,17))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,34),T4sum(1:70,18))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,36),T4sum(1:70,18))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_14,masses2_8,G5tensor(:,33),T5sum(1:126,1))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_14,masses2_7,G5tensor(:,39),T5sum(1:126,2))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_14,masses2_8,G5tensor(:,45),T5sum(1:126,1))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_14,masses2_7,G5tensor(:,51),T5sum(1:126,2))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_14,masses2_8,G5tensor(:,57),T5sum(1:126,1))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_14,masses2_6,G5tensor(:,63),T5sum(1:126,3))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_14,masses2_8,G5tensor(:,69),T5sum(1:126,1))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_14,masses2_6,G5tensor(:,75),T5sum(1:126,3))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,35),T5sum(1:126,4))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,41),T5sum(1:126,5))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,47),T5sum(1:126,4))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,53),T5sum(1:126,5))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,59),T5sum(1:126,4))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_16,masses2_6,G5tensor(:,65),T5sum(1:126,6))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,71),T5sum(1:126,4))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_16,masses2_6,G5tensor(:,77),T5sum(1:126,6))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_12,masses2_8,G5tensor(:,37),T5sum(1:126,7))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_12,masses2_7,G5tensor(:,43),T5sum(1:126,8))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_12,masses2_8,G5tensor(:,49),T5sum(1:126,7))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_12,masses2_7,G5tensor(:,55),T5sum(1:126,8))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_12,masses2_8,G5tensor(:,61),T5sum(1:126,7))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_12,masses2_6,G5tensor(:,67),T5sum(1:126,9))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_12,masses2_8,G5tensor(:,73),T5sum(1:126,7))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_12,masses2_6,G5tensor(:,79),T5sum(1:126,9))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_15,masses2_8,G5tensor(:,36),T5sum(1:126,10))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_15,masses2_7,G5tensor(:,42),T5sum(1:126,11))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_15,masses2_8,G5tensor(:,48),T5sum(1:126,10))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_15,masses2_7,G5tensor(:,54),T5sum(1:126,11))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_15,masses2_8,G5tensor(:,60),T5sum(1:126,10))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_15,masses2_6,G5tensor(:,66),T5sum(1:126,12))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_15,masses2_8,G5tensor(:,72),T5sum(1:126,10))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_15,masses2_6,G5tensor(:,78),T5sum(1:126,12))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_11,masses2_8,G5tensor(:,38),T5sum(1:126,13))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_11,masses2_7,G5tensor(:,44),T5sum(1:126,14))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_11,masses2_8,G5tensor(:,50),T5sum(1:126,13))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_11,masses2_7,G5tensor(:,56),T5sum(1:126,14))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_11,masses2_8,G5tensor(:,62),T5sum(1:126,13))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_11,masses2_6,G5tensor(:,68),T5sum(1:126,15))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_11,masses2_8,G5tensor(:,74),T5sum(1:126,13))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_11,masses2_6,G5tensor(:,80),T5sum(1:126,15))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_13,masses2_8,G5tensor(:,34),T5sum(1:126,16))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_13,masses2_7,G5tensor(:,40),T5sum(1:126,17))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_13,masses2_8,G5tensor(:,46),T5sum(1:126,16))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_13,masses2_7,G5tensor(:,52),T5sum(1:126,17))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_13,masses2_8,G5tensor(:,58),T5sum(1:126,16))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_13,masses2_6,G5tensor(:,64),T5sum(1:126,18))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_13,masses2_8,G5tensor(:,70),T5sum(1:126,16))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_13,masses2_6,G5tensor(:,76),T5sum(1:126,18))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,81),T5sum(1:126,19))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,19),T5sum(1:126,20))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,85),T5sum(1:126,19))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,23),T5sum(1:126,20))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,89),T5sum(1:126,19))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_18,masses2_6,G5tensor(:,27),T5sum(1:126,21))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,93),T5sum(1:126,19))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_18,masses2_6,G5tensor(:,31),T5sum(1:126,21))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,83),T5sum(1:126,22))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,18),T5sum(1:126,23))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,87),T5sum(1:126,22))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,22),T5sum(1:126,23))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,91),T5sum(1:126,22))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_20,masses2_6,G5tensor(:,26),T5sum(1:126,24))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,95),T5sum(1:126,22))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_20,masses2_6,G5tensor(:,30),T5sum(1:126,24))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,82),T5sum(1:126,25))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,20),T5sum(1:126,26))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,86),T5sum(1:126,25))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,24),T5sum(1:126,26))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,90),T5sum(1:126,25))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_17,masses2_6,G5tensor(:,28),T5sum(1:126,27))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,94),T5sum(1:126,25))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_17,masses2_6,G5tensor(:,32),T5sum(1:126,27))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,84),T5sum(1:126,28))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,17),T5sum(1:126,29))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,88),T5sum(1:126,28))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,21),T5sum(1:126,29))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,92),T5sum(1:126,28))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_19,masses2_6,G5tensor(:,25),T5sum(1:126,30))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,96),T5sum(1:126,28))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_19,masses2_6,G5tensor(:,29),T5sum(1:126,30))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,1),T5sum(1:126,31))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,6),T5sum(1:126,32))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,7),T5sum(1:126,31))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,12),T5sum(1:126,32))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,2),T5sum(1:126,31))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_21,masses2_6,G5tensor(:,14),T5sum(1:126,33))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,8),T5sum(1:126,31))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_21,masses2_6,G5tensor(:,16),T5sum(1:126,33))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,3),T5sum(1:126,34))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,5),T5sum(1:126,35))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,9),T5sum(1:126,34))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,11),T5sum(1:126,35))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,4),T5sum(1:126,34))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_22,masses2_6,G5tensor(:,13),T5sum(1:126,36))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,10),T5sum(1:126,34))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_22,masses2_6,G5tensor(:,15),T5sum(1:126,36))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppvvv2_zzzgg_1_/**/REALKIND
