
module ol_vamp_1_ppvvv2_zwwxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv2_zwwxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv2_zwwxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvv2_zwwxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvv2_zwwxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,37) :: G0
  complex(REALKIND), dimension(4,5,4,140) :: G1
  complex(REALKIND), dimension(4,15,4,292) :: G2
  complex(REALKIND), dimension(4,35,4,258) :: G3
  complex(REALKIND), dimension(4,70,4,96) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,62,108))
    allocate(G4tensorhel(70,84,108))
    allocate(G5tensorhel(126,48,108))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,8),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,24),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,7),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,9),G2(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,31),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,9),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,31),ZERO,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,16),G2(:,:,:,5))
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,31),ZERO,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,22),G2(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,31),ZERO,G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,22),G2(:,:,:,7),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,31),ZERO,G3tensor(:,6))
  call loop_AV_Q(G2(:,:,:,1),wf(:,18),G2(:,:,:,8))
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,31),ZERO,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,23),G2(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,31),ZERO,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,23),G2(:,:,:,10),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,31),ZERO,G3tensor(:,9))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,24),G2(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,31),ZERO,G3tensor(:,10))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,24),G2(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,31),ZERO,G3tensor(:,11))
  call loop_AW_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,12),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-4),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,28),ZERO,G3(:,:,:,1))
  call loop_AW_Q(G3(:,:,:,1),wf(:,3),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,31),ZERO,G4tensor(:,1))
  call loop_AW_Q(G2(:,:,:,13),wf(:,-1),G2(:,:,:,15))
  call loop_A_Q(G2(:,:,:,15),Q(:,14),ZERO,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-4),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,30),ZERO,G4(:,:,:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,0),G4(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,31),ZERO,G5tensor(:,1))
  call loop_AW_Q(G1(:,:,:,1),wf(:,6),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,13),ZERO,G2(:,:,:,16))
  call loop_AV_Q(G2(:,:,:,16),wf(:,-4),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,29),ZERO,G3(:,:,:,5))
  call loop_AW_Q(G3(:,:,:,5),wf(:,-1),G3(:,:,:,6))
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,31),ZERO,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,10),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,14),ZERO,G2(:,:,:,18))
  call loop_AV_Q(G2(:,:,:,18),wf(:,-4),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,30),ZERO,G3(:,:,:,7))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,0),G3(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,31),ZERO,G4tensor(:,3))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,0),G3(:,:,:,9),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,31),ZERO,G4tensor(:,4))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,12),G1(:,:,:,6),gZu)
  call loop_A_Q(G1(:,:,:,6),Q(:,14),ZERO,G2(:,:,:,20))
  call loop_AV_Q(G2(:,:,:,20),wf(:,-4),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,30),ZERO,G3(:,:,:,10))
  call loop_AZ_Q(G3(:,:,:,10),wf(:,0),G3(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,31),ZERO,G4tensor(:,5))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,12),G1(:,:,:,7),gZd)
  call loop_A_Q(G1(:,:,:,7),Q(:,14),ZERO,G2(:,:,:,22))
  call loop_AV_Q(G2(:,:,:,22),wf(:,-4),G2(:,:,:,23))
  call loop_A_Q(G2(:,:,:,23),Q(:,30),ZERO,G3(:,:,:,12))
  call loop_AZ_Q(G3(:,:,:,12),wf(:,0),G3(:,:,:,13),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,13),Q(:,31),ZERO,G4tensor(:,6))
  call loop_AW_Q(G1(:,:,:,1),wf(:,-1),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,10),ZERO,G2(:,:,:,24))
  call loop_AW_Q(G2(:,:,:,24),wf(:,-2),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,14),ZERO,G3(:,:,:,14))
  call loop_AV_Q(G3(:,:,:,14),wf(:,-4),G3(:,:,:,15))
  call loop_A_Q(G3(:,:,:,15),Q(:,30),ZERO,G4(:,:,:,3))
  call loop_AZ_Q(G4(:,:,:,3),wf(:,0),G4(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,31),ZERO,G5tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,8),MT,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,-4),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,24),MT,G2(:,:,:,26))
  call loop_AV_Q(G2(:,:,:,26),wf(:,7),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,31),MT,G3tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,26),wf(:,9),G2(:,:,:,28),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,31),MT,G3tensor(:,13))
  call loop_AS_Q(G2(:,:,:,26),wf(:,14),G2(:,:,:,29),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,31),MT,G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,26),wf(:,16),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,31),MT,G3tensor(:,15))
  call loop_AZ_Q(G2(:,:,:,26),wf(:,22),G2(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,31),MT,G3tensor(:,16))
  call loop_AS_Q(G2(:,:,:,26),wf(:,17),G2(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,31),MT,G3tensor(:,17))
  call loop_AV_Q(G2(:,:,:,26),wf(:,18),G2(:,:,:,33))
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,31),MT,G3tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,26),wf(:,23),G2(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,31),MT,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,26),wf(:,24),G2(:,:,:,35),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,31),MT,G3tensor(:,20))
  call loop_AS_Q(G2(:,:,:,26),wf(:,21),G2(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,31),MT,G3tensor(:,21))
  call loop_AW_Q(G1(:,:,:,9),wf(:,-2),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,12),MB,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,-4),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,28),MB,G3(:,:,:,16))
  call loop_AW_Q(G3(:,:,:,16),wf(:,3),G3(:,:,:,17))
  call check_last_A_Q(l_switch,G3(:,:,:,17),Q(:,31),MT,G4tensor(:,7))
  call loop_AW_Q(G2(:,:,:,37),wf(:,-1),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,14),MT,G3(:,:,:,18))
  call loop_AV_Q(G3(:,:,:,18),wf(:,-4),G3(:,:,:,19))
  call loop_A_Q(G3(:,:,:,19),Q(:,30),MT,G4(:,:,:,5))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,0),G4(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,31),MT,G5tensor(:,3))
  call loop_AW_Q(G1(:,:,:,9),wf(:,6),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,13),MB,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-4),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,29),MB,G3(:,:,:,20))
  call loop_AW_Q(G3(:,:,:,20),wf(:,-1),G3(:,:,:,21))
  call check_last_A_Q(l_switch,G3(:,:,:,21),Q(:,31),MT,G4tensor(:,8))
  call loop_AS_Q(G1(:,:,:,9),wf(:,19),G1(:,:,:,13),gH)
  call loop_A_Q(G1(:,:,:,13),Q(:,14),MT,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,-4),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,30),MT,G3(:,:,:,22))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,0),G3(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,31),MT,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,10),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,14),MT,G2(:,:,:,44))
  call loop_AV_Q(G2(:,:,:,44),wf(:,-4),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,30),MT,G3(:,:,:,24))
  call loop_AZ_Q(G3(:,:,:,24),wf(:,0),G3(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,25),Q(:,31),MT,G4tensor(:,10))
  call loop_AZ_Q(G1(:,:,:,9),wf(:,12),G1(:,:,:,15),gZu)
  call loop_A_Q(G1(:,:,:,15),Q(:,14),MT,G2(:,:,:,46))
  call loop_AV_Q(G2(:,:,:,46),wf(:,-4),G2(:,:,:,47))
  call loop_A_Q(G2(:,:,:,47),Q(:,30),MT,G3(:,:,:,26))
  call loop_AZ_Q(G3(:,:,:,26),wf(:,0),G3(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,31),MT,G4tensor(:,11))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,8),ZERO,G1(:,:,:,16))
  call loop_QV_A(G1(:,:,:,16),wf(:,-4),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,24),ZERO,G2(:,:,:,48))
  call loop_QV_A(G2(:,:,:,48),wf(:,7),G2(:,:,:,49))
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,31),ZERO,G3tensor(:,22))
  call loop_QZ_A(G2(:,:,:,48),wf(:,9),G2(:,:,:,50),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,31),ZERO,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,48),wf(:,9),G2(:,:,:,51),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,31),ZERO,G3tensor(:,24))
  call loop_QV_A(G2(:,:,:,48),wf(:,16),G2(:,:,:,52))
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,31),ZERO,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,48),wf(:,22),G2(:,:,:,53),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,31),ZERO,G3tensor(:,26))
  call loop_QZ_A(G2(:,:,:,48),wf(:,22),G2(:,:,:,54),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,31),ZERO,G3tensor(:,27))
  call loop_QV_A(G2(:,:,:,48),wf(:,18),G2(:,:,:,55))
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,31),ZERO,G3tensor(:,28))
  call loop_QZ_A(G2(:,:,:,48),wf(:,23),G2(:,:,:,56),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,31),ZERO,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,48),wf(:,23),G2(:,:,:,57),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,31),ZERO,G3tensor(:,30))
  call loop_QZ_A(G2(:,:,:,48),wf(:,24),G2(:,:,:,58),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,31),ZERO,G3tensor(:,31))
  call loop_QZ_A(G2(:,:,:,48),wf(:,24),G2(:,:,:,59),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,31),ZERO,G3tensor(:,32))
  call loop_QW_A(G1(:,:,:,16),wf(:,-2),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,12),ZERO,G2(:,:,:,60))
  call loop_QV_A(G2(:,:,:,60),wf(:,-4),G2(:,:,:,61))
  call loop_Q_A(G2(:,:,:,61),Q(:,28),ZERO,G3(:,:,:,28))
  call loop_QW_A(G3(:,:,:,28),wf(:,3),G3(:,:,:,29))
  call check_last_Q_A(l_switch,G3(:,:,:,29),Q(:,31),ZERO,G4tensor(:,12))
  call loop_QW_A(G2(:,:,:,60),wf(:,-1),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,14),ZERO,G3(:,:,:,30))
  call loop_QV_A(G3(:,:,:,30),wf(:,-4),G3(:,:,:,31))
  call loop_Q_A(G3(:,:,:,31),Q(:,30),ZERO,G4(:,:,:,7))
  call loop_QZ_A(G4(:,:,:,7),wf(:,0),G4(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,8),Q(:,31),ZERO,G5tensor(:,4))
  call loop_QW_A(G1(:,:,:,16),wf(:,6),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,13),ZERO,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,-4),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,29),ZERO,G3(:,:,:,32))
  call loop_QW_A(G3(:,:,:,32),wf(:,-1),G3(:,:,:,33))
  call check_last_Q_A(l_switch,G3(:,:,:,33),Q(:,31),ZERO,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,16),wf(:,10),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,14),ZERO,G2(:,:,:,65))
  call loop_QV_A(G2(:,:,:,65),wf(:,-4),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,30),ZERO,G3(:,:,:,34))
  call loop_QZ_A(G3(:,:,:,34),wf(:,0),G3(:,:,:,35),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,35),Q(:,31),ZERO,G4tensor(:,14))
  call loop_QZ_A(G3(:,:,:,34),wf(:,0),G3(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,31),ZERO,G4tensor(:,15))
  call loop_QZ_A(G1(:,:,:,16),wf(:,12),G1(:,:,:,21),gZu)
  call loop_Q_A(G1(:,:,:,21),Q(:,14),ZERO,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,-4),G2(:,:,:,68))
  call loop_Q_A(G2(:,:,:,68),Q(:,30),ZERO,G3(:,:,:,37))
  call loop_QZ_A(G3(:,:,:,37),wf(:,0),G3(:,:,:,38),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,31),ZERO,G4tensor(:,16))
  call loop_QZ_A(G1(:,:,:,16),wf(:,12),G1(:,:,:,22),gZd)
  call loop_Q_A(G1(:,:,:,22),Q(:,14),ZERO,G2(:,:,:,69))
  call loop_QV_A(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70))
  call loop_Q_A(G2(:,:,:,70),Q(:,30),ZERO,G3(:,:,:,39))
  call loop_QZ_A(G3(:,:,:,39),wf(:,0),G3(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,31),ZERO,G4tensor(:,17))
  call loop_QW_A(G1(:,:,:,16),wf(:,-1),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,10),ZERO,G2(:,:,:,71))
  call loop_QW_A(G2(:,:,:,71),wf(:,-2),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,14),ZERO,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,-4),G3(:,:,:,42))
  call loop_Q_A(G3(:,:,:,42),Q(:,30),ZERO,G4(:,:,:,9))
  call loop_QZ_A(G4(:,:,:,9),wf(:,0),G4(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,31),ZERO,G5tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,8),MT,G1(:,:,:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,-4),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,24),MT,G2(:,:,:,73))
  call loop_QV_A(G2(:,:,:,73),wf(:,7),G2(:,:,:,74))
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,31),MT,G3tensor(:,33))
  call loop_QZ_A(G2(:,:,:,73),wf(:,9),G2(:,:,:,75),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,75),Q(:,31),MT,G3tensor(:,34))
  call loop_QS_A(G2(:,:,:,73),wf(:,14),G2(:,:,:,76),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,31),MT,G3tensor(:,35))
  call loop_QV_A(G2(:,:,:,73),wf(:,16),G2(:,:,:,77))
  call check_last_Q_A(l_switch,G2(:,:,:,77),Q(:,31),MT,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,73),wf(:,22),G2(:,:,:,78),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,78),Q(:,31),MT,G3tensor(:,37))
  call loop_QS_A(G2(:,:,:,73),wf(:,17),G2(:,:,:,79),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,79),Q(:,31),MT,G3tensor(:,38))
  call loop_QV_A(G2(:,:,:,73),wf(:,18),G2(:,:,:,80))
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,31),MT,G3tensor(:,39))
  call loop_QZ_A(G2(:,:,:,73),wf(:,23),G2(:,:,:,81),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,81),Q(:,31),MT,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,73),wf(:,24),G2(:,:,:,82),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,31),MT,G3tensor(:,41))
  call loop_QS_A(G2(:,:,:,73),wf(:,21),G2(:,:,:,83),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,83),Q(:,31),MT,G3tensor(:,42))
  call loop_QS_A(G1(:,:,:,24),wf(:,19),G1(:,:,:,26),gH)
  call loop_Q_A(G1(:,:,:,26),Q(:,14),MT,G2(:,:,:,84))
  call loop_QV_A(G2(:,:,:,84),wf(:,-4),G2(:,:,:,85))
  call loop_Q_A(G2(:,:,:,85),Q(:,30),MT,G3(:,:,:,43))
  call loop_QZ_A(G3(:,:,:,43),wf(:,0),G3(:,:,:,44),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,31),MT,G4tensor(:,18))
  call loop_QV_A(G1(:,:,:,24),wf(:,10),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,14),MT,G2(:,:,:,86))
  call loop_QV_A(G2(:,:,:,86),wf(:,-4),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,30),MT,G3(:,:,:,45))
  call loop_QZ_A(G3(:,:,:,45),wf(:,0),G3(:,:,:,46),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,31),MT,G4tensor(:,19))
  call loop_QZ_A(G1(:,:,:,24),wf(:,12),G1(:,:,:,28),gZu)
  call loop_Q_A(G1(:,:,:,28),Q(:,14),MT,G2(:,:,:,88))
  call loop_QV_A(G2(:,:,:,88),wf(:,-4),G2(:,:,:,89))
  call loop_Q_A(G2(:,:,:,89),Q(:,30),MT,G3(:,:,:,47))
  call loop_QZ_A(G3(:,:,:,47),wf(:,0),G3(:,:,:,48),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,31),MT,G4tensor(:,20))
  call loop_QW_A(G1(:,:,:,24),wf(:,-1),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,10),MB,G2(:,:,:,90))
  call loop_QW_A(G2(:,:,:,90),wf(:,-2),G2(:,:,:,91))
  call loop_Q_A(G2(:,:,:,91),Q(:,14),MT,G3(:,:,:,49))
  call loop_QV_A(G3(:,:,:,49),wf(:,-4),G3(:,:,:,50))
  call loop_Q_A(G3(:,:,:,50),Q(:,30),MT,G4(:,:,:,11))
  call loop_QZ_A(G4(:,:,:,11),wf(:,0),G4(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,31),MT,G5tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,8),MB,G1(:,:,:,30))
  call loop_AV_Q(G1(:,:,:,30),wf(:,-4),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,24),MB,G2(:,:,:,92))
  call loop_AV_Q(G2(:,:,:,92),wf(:,7),G2(:,:,:,93))
  call check_last_A_Q(l_switch,G2(:,:,:,93),Q(:,31),MB,G3tensor(:,43))
  call loop_AZ_Q(G2(:,:,:,92),wf(:,9),G2(:,:,:,94),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,94),Q(:,31),MB,G3tensor(:,44))
  call loop_AS_Q(G2(:,:,:,92),wf(:,14),G2(:,:,:,95),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,95),Q(:,31),MB,G3tensor(:,45))
  call loop_AV_Q(G2(:,:,:,92),wf(:,16),G2(:,:,:,96))
  call check_last_A_Q(l_switch,G2(:,:,:,96),Q(:,31),MB,G3tensor(:,46))
  call loop_AZ_Q(G2(:,:,:,92),wf(:,22),G2(:,:,:,97),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,97),Q(:,31),MB,G3tensor(:,47))
  call loop_AS_Q(G2(:,:,:,92),wf(:,17),G2(:,:,:,98),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,31),MB,G3tensor(:,48))
  call loop_AV_Q(G2(:,:,:,92),wf(:,18),G2(:,:,:,99))
  call check_last_A_Q(l_switch,G2(:,:,:,99),Q(:,31),MB,G3tensor(:,49))
  call loop_AZ_Q(G2(:,:,:,92),wf(:,23),G2(:,:,:,100),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,31),MB,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,92),wf(:,24),G2(:,:,:,101),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,101),Q(:,31),MB,G3tensor(:,51))
  call loop_AS_Q(G2(:,:,:,92),wf(:,21),G2(:,:,:,102),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,102),Q(:,31),MB,G3tensor(:,52))
  call loop_AS_Q(G1(:,:,:,30),wf(:,19),G1(:,:,:,32),gH)
  call loop_A_Q(G1(:,:,:,32),Q(:,14),MB,G2(:,:,:,103))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-4),G2(:,:,:,104))
  call loop_A_Q(G2(:,:,:,104),Q(:,30),MB,G3(:,:,:,51))
  call loop_AZ_Q(G3(:,:,:,51),wf(:,0),G3(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,31),MB,G4tensor(:,21))
  call loop_AV_Q(G1(:,:,:,30),wf(:,10),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,14),MB,G2(:,:,:,105))
  call loop_AV_Q(G2(:,:,:,105),wf(:,-4),G2(:,:,:,106))
  call loop_A_Q(G2(:,:,:,106),Q(:,30),MB,G3(:,:,:,53))
  call loop_AZ_Q(G3(:,:,:,53),wf(:,0),G3(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,31),MB,G4tensor(:,22))
  call loop_AZ_Q(G1(:,:,:,30),wf(:,12),G1(:,:,:,34),gZd)
  call loop_A_Q(G1(:,:,:,34),Q(:,14),MB,G2(:,:,:,107))
  call loop_AV_Q(G2(:,:,:,107),wf(:,-4),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,30),MB,G3(:,:,:,55))
  call loop_AZ_Q(G3(:,:,:,55),wf(:,0),G3(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,31),MB,G4tensor(:,23))
  call loop_AW_Q(G1(:,:,:,30),wf(:,-1),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,10),MT,G2(:,:,:,109))
  call loop_AW_Q(G2(:,:,:,109),wf(:,-2),G2(:,:,:,110))
  call loop_A_Q(G2(:,:,:,110),Q(:,14),MB,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,-4),G3(:,:,:,58))
  call loop_A_Q(G3(:,:,:,58),Q(:,30),MB,G4(:,:,:,13))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,0),G4(:,:,:,14),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,31),MB,G5tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,8),MB,G1(:,:,:,36))
  call loop_QV_A(G1(:,:,:,36),wf(:,-4),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,24),MB,G2(:,:,:,111))
  call loop_QV_A(G2(:,:,:,111),wf(:,7),G2(:,:,:,112))
  call check_last_Q_A(l_switch,G2(:,:,:,112),Q(:,31),MB,G3tensor(:,53))
  call loop_QZ_A(G2(:,:,:,111),wf(:,9),G2(:,:,:,113),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,113),Q(:,31),MB,G3tensor(:,54))
  call loop_QS_A(G2(:,:,:,111),wf(:,14),G2(:,:,:,114),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,31),MB,G3tensor(:,55))
  call loop_QV_A(G2(:,:,:,111),wf(:,16),G2(:,:,:,115))
  call check_last_Q_A(l_switch,G2(:,:,:,115),Q(:,31),MB,G3tensor(:,56))
  call loop_QZ_A(G2(:,:,:,111),wf(:,22),G2(:,:,:,116),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,116),Q(:,31),MB,G3tensor(:,57))
  call loop_QS_A(G2(:,:,:,111),wf(:,17),G2(:,:,:,117),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,117),Q(:,31),MB,G3tensor(:,58))
  call loop_QV_A(G2(:,:,:,111),wf(:,18),G2(:,:,:,118))
  call check_last_Q_A(l_switch,G2(:,:,:,118),Q(:,31),MB,G3tensor(:,59))
  call loop_QZ_A(G2(:,:,:,111),wf(:,23),G2(:,:,:,119),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,119),Q(:,31),MB,G3tensor(:,60))
  call loop_QZ_A(G2(:,:,:,111),wf(:,24),G2(:,:,:,120),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,120),Q(:,31),MB,G3tensor(:,61))
  call loop_QS_A(G2(:,:,:,111),wf(:,21),G2(:,:,:,121),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,121),Q(:,31),MB,G3tensor(:,62))
  call loop_QW_A(G1(:,:,:,36),wf(:,-2),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,12),MT,G2(:,:,:,122))
  call loop_QV_A(G2(:,:,:,122),wf(:,-4),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,28),MT,G3(:,:,:,59))
  call loop_QW_A(G3(:,:,:,59),wf(:,3),G3(:,:,:,60))
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,31),MB,G4tensor(:,24))
  call loop_QW_A(G2(:,:,:,122),wf(:,-1),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,14),MB,G3(:,:,:,61))
  call loop_QV_A(G3(:,:,:,61),wf(:,-4),G3(:,:,:,62))
  call loop_Q_A(G3(:,:,:,62),Q(:,30),MB,G4(:,:,:,15))
  call loop_QZ_A(G4(:,:,:,15),wf(:,0),G4(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,31),MB,G5tensor(:,8))
  call loop_QW_A(G1(:,:,:,36),wf(:,6),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,13),MT,G2(:,:,:,125))
  call loop_QV_A(G2(:,:,:,125),wf(:,-4),G2(:,:,:,126))
  call loop_Q_A(G2(:,:,:,126),Q(:,29),MT,G3(:,:,:,63))
  call loop_QW_A(G3(:,:,:,63),wf(:,-1),G3(:,:,:,64))
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,31),MB,G4tensor(:,25))
  call loop_QS_A(G1(:,:,:,36),wf(:,19),G1(:,:,:,40),gH)
  call loop_Q_A(G1(:,:,:,40),Q(:,14),MB,G2(:,:,:,127))
  call loop_QV_A(G2(:,:,:,127),wf(:,-4),G2(:,:,:,128))
  call loop_Q_A(G2(:,:,:,128),Q(:,30),MB,G3(:,:,:,65))
  call loop_QZ_A(G3(:,:,:,65),wf(:,0),G3(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,31),MB,G4tensor(:,26))
  call loop_QV_A(G1(:,:,:,36),wf(:,10),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,14),MB,G2(:,:,:,129))
  call loop_QV_A(G2(:,:,:,129),wf(:,-4),G2(:,:,:,130))
  call loop_Q_A(G2(:,:,:,130),Q(:,30),MB,G3(:,:,:,67))
  call loop_QZ_A(G3(:,:,:,67),wf(:,0),G3(:,:,:,68),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,31),MB,G4tensor(:,27))
  call loop_QZ_A(G1(:,:,:,36),wf(:,12),G1(:,:,:,42),gZd)
  call loop_Q_A(G1(:,:,:,42),Q(:,14),MB,G2(:,:,:,131))
  call loop_QV_A(G2(:,:,:,131),wf(:,-4),G2(:,:,:,132))
  call loop_Q_A(G2(:,:,:,132),Q(:,30),MB,G3(:,:,:,69))
  call loop_QZ_A(G3(:,:,:,69),wf(:,0),G3(:,:,:,70),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,31),MB,G4tensor(:,28))
  call loop_QW_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,4),ZERO,G1(:,:,:,43))
  call loop_QV_A(G1(:,:,:,43),wf(:,-3),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,12),ZERO,G2(:,:,:,133))
  call loop_QV_A(G2(:,:,:,133),wf(:,-4),G2(:,:,:,134))
  call loop_Q_A(G2(:,:,:,134),Q(:,28),ZERO,G3(:,:,:,71))
  call loop_QW_A(G3(:,:,:,71),wf(:,3),G3(:,:,:,72))
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,31),ZERO,G4tensor(:,29))
  call loop_QW_A(G2(:,:,:,133),wf(:,-1),G2(:,:,:,135))
  call loop_Q_A(G2(:,:,:,135),Q(:,14),ZERO,G3(:,:,:,73))
  call loop_QV_A(G3(:,:,:,73),wf(:,-4),G3(:,:,:,74))
  call loop_Q_A(G3(:,:,:,74),Q(:,30),ZERO,G4(:,:,:,17))
  call loop_QZ_A(G4(:,:,:,17),wf(:,0),G4(:,:,:,18),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,31),ZERO,G5tensor(:,9))
  call loop_QV_A(G1(:,:,:,43),wf(:,-4),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,20),ZERO,G2(:,:,:,136))
  call loop_QV_A(G2(:,:,:,136),wf(:,-3),G2(:,:,:,137))
  call loop_Q_A(G2(:,:,:,137),Q(:,28),ZERO,G3(:,:,:,75))
  call loop_QW_A(G3(:,:,:,75),wf(:,3),G3(:,:,:,76))
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,31),ZERO,G4tensor(:,30))
  call loop_QW_A(G2(:,:,:,136),wf(:,-1),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,22),ZERO,G3(:,:,:,77))
  call loop_QV_A(G3(:,:,:,77),wf(:,-3),G3(:,:,:,78))
  call loop_Q_A(G3(:,:,:,78),Q(:,30),ZERO,G4(:,:,:,19))
  call loop_QZ_A(G4(:,:,:,19),wf(:,0),G4(:,:,:,20),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,31),ZERO,G5tensor(:,10))
  call loop_QW_A(G1(:,:,:,43),wf(:,-1),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,6),ZERO,G2(:,:,:,139))
  call loop_QV_A(G2(:,:,:,139),wf(:,-4),G2(:,:,:,140))
  call loop_Q_A(G2(:,:,:,140),Q(:,22),ZERO,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,-3),G3(:,:,:,80))
  call loop_Q_A(G3(:,:,:,80),Q(:,30),ZERO,G4(:,:,:,21))
  call loop_QZ_A(G4(:,:,:,21),wf(:,0),G4(:,:,:,22),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,31),ZERO,G5tensor(:,11))
  call loop_QV_A(G2(:,:,:,139),wf(:,-3),G2(:,:,:,141))
  call loop_Q_A(G2(:,:,:,141),Q(:,14),ZERO,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,-4),G3(:,:,:,82))
  call loop_Q_A(G3(:,:,:,82),Q(:,30),ZERO,G4(:,:,:,23))
  call loop_QZ_A(G4(:,:,:,23),wf(:,0),G4(:,:,:,24),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,31),ZERO,G5tensor(:,12))
  call loop_QW_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,4),MT,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,-3),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,12),MT,G2(:,:,:,142))
  call loop_QV_A(G2(:,:,:,142),wf(:,-4),G2(:,:,:,143))
  call loop_Q_A(G2(:,:,:,143),Q(:,28),MT,G3(:,:,:,83))
  call loop_QW_A(G3(:,:,:,83),wf(:,3),G3(:,:,:,84))
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,31),MB,G4tensor(:,31))
  call loop_QW_A(G2(:,:,:,142),wf(:,-1),G2(:,:,:,144))
  call loop_Q_A(G2(:,:,:,144),Q(:,14),MB,G3(:,:,:,85))
  call loop_QV_A(G3(:,:,:,85),wf(:,-4),G3(:,:,:,86))
  call loop_Q_A(G3(:,:,:,86),Q(:,30),MB,G4(:,:,:,25))
  call loop_QZ_A(G4(:,:,:,25),wf(:,0),G4(:,:,:,26),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,31),MB,G5tensor(:,13))
  call loop_QV_A(G1(:,:,:,47),wf(:,-4),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,20),MT,G2(:,:,:,145))
  call loop_QV_A(G2(:,:,:,145),wf(:,-3),G2(:,:,:,146))
  call loop_Q_A(G2(:,:,:,146),Q(:,28),MT,G3(:,:,:,87))
  call loop_QW_A(G3(:,:,:,87),wf(:,3),G3(:,:,:,88))
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,31),MB,G4tensor(:,32))
  call loop_QW_A(G2(:,:,:,145),wf(:,-1),G2(:,:,:,147))
  call loop_Q_A(G2(:,:,:,147),Q(:,22),MB,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,-3),G3(:,:,:,90))
  call loop_Q_A(G3(:,:,:,90),Q(:,30),MB,G4(:,:,:,27))
  call loop_QZ_A(G4(:,:,:,27),wf(:,0),G4(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,31),MB,G5tensor(:,14))
  call loop_QW_A(G1(:,:,:,47),wf(:,-1),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,6),MB,G2(:,:,:,148))
  call loop_QV_A(G2(:,:,:,148),wf(:,-4),G2(:,:,:,149))
  call loop_Q_A(G2(:,:,:,149),Q(:,22),MB,G3(:,:,:,91))
  call loop_QV_A(G3(:,:,:,91),wf(:,-3),G3(:,:,:,92))
  call loop_Q_A(G3(:,:,:,92),Q(:,30),MB,G4(:,:,:,29))
  call loop_QZ_A(G4(:,:,:,29),wf(:,0),G4(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,31),MB,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,148),wf(:,-3),G2(:,:,:,150))
  call loop_Q_A(G2(:,:,:,150),Q(:,14),MB,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-4),G3(:,:,:,94))
  call loop_Q_A(G3(:,:,:,94),Q(:,30),MB,G4(:,:,:,31))
  call loop_QZ_A(G4(:,:,:,31),wf(:,0),G4(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,31),MB,G5tensor(:,16))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,4),ZERO,G1(:,:,:,51))
  call loop_AV_Q(G1(:,:,:,51),wf(:,-3),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,12),ZERO,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,-4),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,28),ZERO,G3(:,:,:,95))
  call loop_AW_Q(G3(:,:,:,95),wf(:,3),G3(:,:,:,96))
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,31),ZERO,G4tensor(:,33))
  call loop_AW_Q(G2(:,:,:,151),wf(:,-1),G2(:,:,:,153))
  call loop_A_Q(G2(:,:,:,153),Q(:,14),ZERO,G3(:,:,:,97))
  call loop_AV_Q(G3(:,:,:,97),wf(:,-4),G3(:,:,:,98))
  call loop_A_Q(G3(:,:,:,98),Q(:,30),ZERO,G4(:,:,:,33))
  call loop_AZ_Q(G4(:,:,:,33),wf(:,0),G4(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,31),ZERO,G5tensor(:,17))
  call loop_AV_Q(G1(:,:,:,51),wf(:,-4),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,20),ZERO,G2(:,:,:,154))
  call loop_AV_Q(G2(:,:,:,154),wf(:,-3),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,28),ZERO,G3(:,:,:,99))
  call loop_AW_Q(G3(:,:,:,99),wf(:,3),G3(:,:,:,100))
  call check_last_A_Q(l_switch,G3(:,:,:,100),Q(:,31),ZERO,G4tensor(:,34))
  call loop_AW_Q(G2(:,:,:,154),wf(:,-1),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,22),ZERO,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,-3),G3(:,:,:,102))
  call loop_A_Q(G3(:,:,:,102),Q(:,30),ZERO,G4(:,:,:,35))
  call loop_AZ_Q(G4(:,:,:,35),wf(:,0),G4(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,31),ZERO,G5tensor(:,18))
  call loop_AW_Q(G1(:,:,:,51),wf(:,-1),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,6),ZERO,G2(:,:,:,157))
  call loop_AV_Q(G2(:,:,:,157),wf(:,-4),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,22),ZERO,G3(:,:,:,103))
  call loop_AV_Q(G3(:,:,:,103),wf(:,-3),G3(:,:,:,104))
  call loop_A_Q(G3(:,:,:,104),Q(:,30),ZERO,G4(:,:,:,37))
  call loop_AZ_Q(G4(:,:,:,37),wf(:,0),G4(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,31),ZERO,G5tensor(:,19))
  call loop_AV_Q(G2(:,:,:,157),wf(:,-3),G2(:,:,:,159))
  call loop_A_Q(G2(:,:,:,159),Q(:,14),ZERO,G3(:,:,:,105))
  call loop_AV_Q(G3(:,:,:,105),wf(:,-4),G3(:,:,:,106))
  call loop_A_Q(G3(:,:,:,106),Q(:,30),ZERO,G4(:,:,:,39))
  call loop_AZ_Q(G4(:,:,:,39),wf(:,0),G4(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,40),Q(:,31),ZERO,G5tensor(:,20))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,4),MB,G1(:,:,:,55))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-3),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,12),MB,G2(:,:,:,160))
  call loop_AV_Q(G2(:,:,:,160),wf(:,-4),G2(:,:,:,161))
  call loop_A_Q(G2(:,:,:,161),Q(:,28),MB,G3(:,:,:,107))
  call loop_AW_Q(G3(:,:,:,107),wf(:,3),G3(:,:,:,108))
  call check_last_A_Q(l_switch,G3(:,:,:,108),Q(:,31),MT,G4tensor(:,35))
  call loop_AW_Q(G2(:,:,:,160),wf(:,-1),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,14),MT,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,-4),G3(:,:,:,110))
  call loop_A_Q(G3(:,:,:,110),Q(:,30),MT,G4(:,:,:,41))
  call loop_AZ_Q(G4(:,:,:,41),wf(:,0),G4(:,:,:,42),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,31),MT,G5tensor(:,21))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-4),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,20),MB,G2(:,:,:,163))
  call loop_AV_Q(G2(:,:,:,163),wf(:,-3),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,28),MB,G3(:,:,:,111))
  call loop_AW_Q(G3(:,:,:,111),wf(:,3),G3(:,:,:,112))
  call check_last_A_Q(l_switch,G3(:,:,:,112),Q(:,31),MT,G4tensor(:,36))
  call loop_AW_Q(G2(:,:,:,163),wf(:,-1),G2(:,:,:,165))
  call loop_A_Q(G2(:,:,:,165),Q(:,22),MT,G3(:,:,:,113))
  call loop_AV_Q(G3(:,:,:,113),wf(:,-3),G3(:,:,:,114))
  call loop_A_Q(G3(:,:,:,114),Q(:,30),MT,G4(:,:,:,43))
  call loop_AZ_Q(G4(:,:,:,43),wf(:,0),G4(:,:,:,44),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,31),MT,G5tensor(:,22))
  call loop_AW_Q(G1(:,:,:,55),wf(:,-1),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,6),MT,G2(:,:,:,166))
  call loop_AV_Q(G2(:,:,:,166),wf(:,-4),G2(:,:,:,167))
  call loop_A_Q(G2(:,:,:,167),Q(:,22),MT,G3(:,:,:,115))
  call loop_AV_Q(G3(:,:,:,115),wf(:,-3),G3(:,:,:,116))
  call loop_A_Q(G3(:,:,:,116),Q(:,30),MT,G4(:,:,:,45))
  call loop_AZ_Q(G4(:,:,:,45),wf(:,0),G4(:,:,:,46),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,31),MT,G5tensor(:,23))
  call loop_AV_Q(G2(:,:,:,166),wf(:,-3),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,14),MT,G3(:,:,:,117))
  call loop_AV_Q(G3(:,:,:,117),wf(:,-4),G3(:,:,:,118))
  call loop_A_Q(G3(:,:,:,118),Q(:,30),MT,G4(:,:,:,47))
  call loop_AZ_Q(G4(:,:,:,47),wf(:,0),G4(:,:,:,48),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,31),MT,G5tensor(:,24))
  call loop_QW_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,5),ZERO,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,-4),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,21),ZERO,G2(:,:,:,169))
  call loop_QV_A(G2(:,:,:,169),wf(:,-3),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,29),ZERO,G3(:,:,:,119))
  call loop_QW_A(G3(:,:,:,119),wf(:,-1),G3(:,:,:,120))
  call check_last_Q_A(l_switch,G3(:,:,:,120),Q(:,31),ZERO,G4tensor(:,37))
  call loop_QV_A(G1(:,:,:,59),wf(:,-3),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,13),ZERO,G2(:,:,:,171))
  call loop_QV_A(G2(:,:,:,171),wf(:,-4),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,29),ZERO,G3(:,:,:,121))
  call loop_QW_A(G3(:,:,:,121),wf(:,-1),G3(:,:,:,122))
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,31),ZERO,G4tensor(:,38))
  call loop_QW_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,5),MT,G1(:,:,:,62))
  call loop_QV_A(G1(:,:,:,62),wf(:,-4),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,21),MT,G2(:,:,:,173))
  call loop_QV_A(G2(:,:,:,173),wf(:,-3),G2(:,:,:,174))
  call loop_Q_A(G2(:,:,:,174),Q(:,29),MT,G3(:,:,:,123))
  call loop_QW_A(G3(:,:,:,123),wf(:,-1),G3(:,:,:,124))
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,31),MB,G4tensor(:,39))
  call loop_QV_A(G1(:,:,:,62),wf(:,-3),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,13),MT,G2(:,:,:,175))
  call loop_QV_A(G2(:,:,:,175),wf(:,-4),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,29),MT,G3(:,:,:,125))
  call loop_QW_A(G3(:,:,:,125),wf(:,-1),G3(:,:,:,126))
  call check_last_Q_A(l_switch,G3(:,:,:,126),Q(:,31),MB,G4tensor(:,40))
  call loop_AW_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,5),ZERO,G1(:,:,:,65))
  call loop_AV_Q(G1(:,:,:,65),wf(:,-4),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,21),ZERO,G2(:,:,:,177))
  call loop_AV_Q(G2(:,:,:,177),wf(:,-3),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,29),ZERO,G3(:,:,:,127))
  call loop_AW_Q(G3(:,:,:,127),wf(:,-1),G3(:,:,:,128))
  call check_last_A_Q(l_switch,G3(:,:,:,128),Q(:,31),ZERO,G4tensor(:,41))
  call loop_AV_Q(G1(:,:,:,65),wf(:,-3),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,13),ZERO,G2(:,:,:,179))
  call loop_AV_Q(G2(:,:,:,179),wf(:,-4),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,29),ZERO,G3(:,:,:,129))
  call loop_AW_Q(G3(:,:,:,129),wf(:,-1),G3(:,:,:,130))
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,31),ZERO,G4tensor(:,42))
  call loop_AW_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,5),MB,G1(:,:,:,68))
  call loop_AV_Q(G1(:,:,:,68),wf(:,-4),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,21),MB,G2(:,:,:,181))
  call loop_AV_Q(G2(:,:,:,181),wf(:,-3),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,29),MB,G3(:,:,:,131))
  call loop_AW_Q(G3(:,:,:,131),wf(:,-1),G3(:,:,:,132))
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,31),MT,G4tensor(:,43))
  call loop_AV_Q(G1(:,:,:,68),wf(:,-3),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,13),MB,G2(:,:,:,183))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-4),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,29),MB,G3(:,:,:,133))
  call loop_AW_Q(G3(:,:,:,133),wf(:,-1),G3(:,:,:,134))
  call check_last_A_Q(l_switch,G3(:,:,:,134),Q(:,31),MT,G4tensor(:,44))
  call loop_QS_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,16),gH)
  call loop_Q_A(G0(:,:,:,16),Q(:,6),MT,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,-4),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,22),MT,G2(:,:,:,185))
  call loop_QV_A(G2(:,:,:,185),wf(:,-3),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,30),MT,G3(:,:,:,135))
  call loop_QZ_A(G3(:,:,:,135),wf(:,0),G3(:,:,:,136),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,136),Q(:,31),MT,G4tensor(:,45))
  call loop_QV_A(G1(:,:,:,71),wf(:,-3),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,14),MT,G2(:,:,:,187))
  call loop_QV_A(G2(:,:,:,187),wf(:,-4),G2(:,:,:,188))
  call loop_Q_A(G2(:,:,:,188),Q(:,30),MT,G3(:,:,:,137))
  call loop_QZ_A(G3(:,:,:,137),wf(:,0),G3(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,31),MT,G4tensor(:,46))
  call loop_AS_Q(G0(:,:,:,1),wf(:,19),G0(:,:,:,17),gH)
  call loop_A_Q(G0(:,:,:,17),Q(:,6),MT,G1(:,:,:,74))
  call loop_AV_Q(G1(:,:,:,74),wf(:,-4),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,22),MT,G2(:,:,:,189))
  call loop_AV_Q(G2(:,:,:,189),wf(:,-3),G2(:,:,:,190))
  call loop_A_Q(G2(:,:,:,190),Q(:,30),MT,G3(:,:,:,139))
  call loop_AZ_Q(G3(:,:,:,139),wf(:,0),G3(:,:,:,140),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,31),MT,G4tensor(:,47))
  call loop_AV_Q(G1(:,:,:,74),wf(:,-3),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,14),MT,G2(:,:,:,191))
  call loop_AV_Q(G2(:,:,:,191),wf(:,-4),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,30),MT,G3(:,:,:,141))
  call loop_AZ_Q(G3(:,:,:,141),wf(:,0),G3(:,:,:,142),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,142),Q(:,31),MT,G4tensor(:,48))
  call loop_QS_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,18),gH)
  call loop_Q_A(G0(:,:,:,18),Q(:,6),MB,G1(:,:,:,77))
  call loop_QV_A(G1(:,:,:,77),wf(:,-4),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,22),MB,G2(:,:,:,193))
  call loop_QV_A(G2(:,:,:,193),wf(:,-3),G2(:,:,:,194))
  call loop_Q_A(G2(:,:,:,194),Q(:,30),MB,G3(:,:,:,143))
  call loop_QZ_A(G3(:,:,:,143),wf(:,0),G3(:,:,:,144),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,144),Q(:,31),MB,G4tensor(:,49))
  call loop_QV_A(G1(:,:,:,77),wf(:,-3),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,14),MB,G2(:,:,:,195))
  call loop_QV_A(G2(:,:,:,195),wf(:,-4),G2(:,:,:,196))
  call loop_Q_A(G2(:,:,:,196),Q(:,30),MB,G3(:,:,:,145))
  call loop_QZ_A(G3(:,:,:,145),wf(:,0),G3(:,:,:,146),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,146),Q(:,31),MB,G4tensor(:,50))
  call loop_AS_Q(G0(:,:,:,1),wf(:,19),G0(:,:,:,19),gH)
  call loop_A_Q(G0(:,:,:,19),Q(:,6),MB,G1(:,:,:,80))
  call loop_AV_Q(G1(:,:,:,80),wf(:,-4),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,22),MB,G2(:,:,:,197))
  call loop_AV_Q(G2(:,:,:,197),wf(:,-3),G2(:,:,:,198))
  call loop_A_Q(G2(:,:,:,198),Q(:,30),MB,G3(:,:,:,147))
  call loop_AZ_Q(G3(:,:,:,147),wf(:,0),G3(:,:,:,148),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,148),Q(:,31),MB,G4tensor(:,51))
  call loop_AV_Q(G1(:,:,:,80),wf(:,-3),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,14),MB,G2(:,:,:,199))
  call loop_AV_Q(G2(:,:,:,199),wf(:,-4),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,30),MB,G3(:,:,:,149))
  call loop_AZ_Q(G3(:,:,:,149),wf(:,0),G3(:,:,:,150),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,150),Q(:,31),MB,G4tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,6),ZERO,G1(:,:,:,83))
  call loop_QV_A(G1(:,:,:,83),wf(:,-4),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,22),ZERO,G2(:,:,:,201))
  call loop_QV_A(G2(:,:,:,201),wf(:,-3),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,30),ZERO,G3(:,:,:,151))
  call loop_QZ_A(G3(:,:,:,151),wf(:,0),G3(:,:,:,152),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,31),ZERO,G4tensor(:,53))
  call loop_QZ_A(G3(:,:,:,151),wf(:,0),G3(:,:,:,153),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,153),Q(:,31),ZERO,G4tensor(:,54))
  call loop_QV_A(G1(:,:,:,83),wf(:,-3),G1(:,:,:,85))
  call loop_Q_A(G1(:,:,:,85),Q(:,14),ZERO,G2(:,:,:,203))
  call loop_QV_A(G2(:,:,:,203),wf(:,-4),G2(:,:,:,204))
  call loop_Q_A(G2(:,:,:,204),Q(:,30),ZERO,G3(:,:,:,154))
  call loop_QZ_A(G3(:,:,:,154),wf(:,0),G3(:,:,:,155),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,155),Q(:,31),ZERO,G4tensor(:,55))
  call loop_QZ_A(G3(:,:,:,154),wf(:,0),G3(:,:,:,156),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,31),ZERO,G4tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,6),MT,G1(:,:,:,86))
  call loop_QV_A(G1(:,:,:,86),wf(:,-4),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,22),MT,G2(:,:,:,205))
  call loop_QV_A(G2(:,:,:,205),wf(:,-3),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,30),MT,G3(:,:,:,157))
  call loop_QZ_A(G3(:,:,:,157),wf(:,0),G3(:,:,:,158),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,158),Q(:,31),MT,G4tensor(:,57))
  call loop_QV_A(G1(:,:,:,86),wf(:,-3),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,14),MT,G2(:,:,:,207))
  call loop_QV_A(G2(:,:,:,207),wf(:,-4),G2(:,:,:,208))
  call loop_Q_A(G2(:,:,:,208),Q(:,30),MT,G3(:,:,:,159))
  call loop_QZ_A(G3(:,:,:,159),wf(:,0),G3(:,:,:,160),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,160),Q(:,31),MT,G4tensor(:,58))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,6),ZERO,G1(:,:,:,89))
  call loop_AV_Q(G1(:,:,:,89),wf(:,-4),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,22),ZERO,G2(:,:,:,209))
  call loop_AV_Q(G2(:,:,:,209),wf(:,-3),G2(:,:,:,210))
  call loop_A_Q(G2(:,:,:,210),Q(:,30),ZERO,G3(:,:,:,161))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,0),G3(:,:,:,162),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,31),ZERO,G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,0),G3(:,:,:,163),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,163),Q(:,31),ZERO,G4tensor(:,60))
  call loop_AV_Q(G1(:,:,:,89),wf(:,-3),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,14),ZERO,G2(:,:,:,211))
  call loop_AV_Q(G2(:,:,:,211),wf(:,-4),G2(:,:,:,212))
  call loop_A_Q(G2(:,:,:,212),Q(:,30),ZERO,G3(:,:,:,164))
  call loop_AZ_Q(G3(:,:,:,164),wf(:,0),G3(:,:,:,165),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,165),Q(:,31),ZERO,G4tensor(:,61))
  call loop_AZ_Q(G3(:,:,:,164),wf(:,0),G3(:,:,:,166),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,166),Q(:,31),ZERO,G4tensor(:,62))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,6),MT,G1(:,:,:,92))
  call loop_AV_Q(G1(:,:,:,92),wf(:,-4),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,22),MT,G2(:,:,:,213))
  call loop_AV_Q(G2(:,:,:,213),wf(:,-3),G2(:,:,:,214))
  call loop_A_Q(G2(:,:,:,214),Q(:,30),MT,G3(:,:,:,167))
  call loop_AZ_Q(G3(:,:,:,167),wf(:,0),G3(:,:,:,168),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,168),Q(:,31),MT,G4tensor(:,63))
  call loop_AV_Q(G1(:,:,:,92),wf(:,-3),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,14),MT,G2(:,:,:,215))
  call loop_AV_Q(G2(:,:,:,215),wf(:,-4),G2(:,:,:,216))
  call loop_A_Q(G2(:,:,:,216),Q(:,30),MT,G3(:,:,:,169))
  call loop_AZ_Q(G3(:,:,:,169),wf(:,0),G3(:,:,:,170),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,31),MT,G4tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,6),MB,G1(:,:,:,95))
  call loop_QV_A(G1(:,:,:,95),wf(:,-4),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,22),MB,G2(:,:,:,217))
  call loop_QV_A(G2(:,:,:,217),wf(:,-3),G2(:,:,:,218))
  call loop_Q_A(G2(:,:,:,218),Q(:,30),MB,G3(:,:,:,171))
  call loop_QZ_A(G3(:,:,:,171),wf(:,0),G3(:,:,:,172),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,172),Q(:,31),MB,G4tensor(:,65))
  call loop_QV_A(G1(:,:,:,95),wf(:,-3),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,14),MB,G2(:,:,:,219))
  call loop_QV_A(G2(:,:,:,219),wf(:,-4),G2(:,:,:,220))
  call loop_Q_A(G2(:,:,:,220),Q(:,30),MB,G3(:,:,:,173))
  call loop_QZ_A(G3(:,:,:,173),wf(:,0),G3(:,:,:,174),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,174),Q(:,31),MB,G4tensor(:,66))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,6),MB,G1(:,:,:,98))
  call loop_AV_Q(G1(:,:,:,98),wf(:,-4),G1(:,:,:,99))
  call loop_A_Q(G1(:,:,:,99),Q(:,22),MB,G2(:,:,:,221))
  call loop_AV_Q(G2(:,:,:,221),wf(:,-3),G2(:,:,:,222))
  call loop_A_Q(G2(:,:,:,222),Q(:,30),MB,G3(:,:,:,175))
  call loop_AZ_Q(G3(:,:,:,175),wf(:,0),G3(:,:,:,176),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,176),Q(:,31),MB,G4tensor(:,67))
  call loop_AV_Q(G1(:,:,:,98),wf(:,-3),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,14),MB,G2(:,:,:,223))
  call loop_AV_Q(G2(:,:,:,223),wf(:,-4),G2(:,:,:,224))
  call loop_A_Q(G2(:,:,:,224),Q(:,30),MB,G3(:,:,:,177))
  call loop_AZ_Q(G3(:,:,:,177),wf(:,0),G3(:,:,:,178),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,178),Q(:,31),MB,G4tensor(:,68))
  call loop_QZ_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,26),gZu)
  call loop_Q_A(G0(:,:,:,26),Q(:,6),ZERO,G1(:,:,:,101))
  call loop_QV_A(G1(:,:,:,101),wf(:,-4),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,22),ZERO,G2(:,:,:,225))
  call loop_QV_A(G2(:,:,:,225),wf(:,-3),G2(:,:,:,226))
  call loop_Q_A(G2(:,:,:,226),Q(:,30),ZERO,G3(:,:,:,179))
  call loop_QZ_A(G3(:,:,:,179),wf(:,0),G3(:,:,:,180),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,31),ZERO,G4tensor(:,69))
  call loop_QV_A(G1(:,:,:,101),wf(:,-3),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,14),ZERO,G2(:,:,:,227))
  call loop_QV_A(G2(:,:,:,227),wf(:,-4),G2(:,:,:,228))
  call loop_Q_A(G2(:,:,:,228),Q(:,30),ZERO,G3(:,:,:,181))
  call loop_QZ_A(G3(:,:,:,181),wf(:,0),G3(:,:,:,182),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,31),ZERO,G4tensor(:,70))
  call loop_QZ_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,27),gZu)
  call loop_Q_A(G0(:,:,:,27),Q(:,6),MT,G1(:,:,:,104))
  call loop_QV_A(G1(:,:,:,104),wf(:,-4),G1(:,:,:,105))
  call loop_Q_A(G1(:,:,:,105),Q(:,22),MT,G2(:,:,:,229))
  call loop_QV_A(G2(:,:,:,229),wf(:,-3),G2(:,:,:,230))
  call loop_Q_A(G2(:,:,:,230),Q(:,30),MT,G3(:,:,:,183))
  call loop_QZ_A(G3(:,:,:,183),wf(:,0),G3(:,:,:,184),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,184),Q(:,31),MT,G4tensor(:,71))
  call loop_QV_A(G1(:,:,:,104),wf(:,-3),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,14),MT,G2(:,:,:,231))
  call loop_QV_A(G2(:,:,:,231),wf(:,-4),G2(:,:,:,232))
  call loop_Q_A(G2(:,:,:,232),Q(:,30),MT,G3(:,:,:,185))
  call loop_QZ_A(G3(:,:,:,185),wf(:,0),G3(:,:,:,186),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,31),MT,G4tensor(:,72))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,28),gZu)
  call loop_A_Q(G0(:,:,:,28),Q(:,6),ZERO,G1(:,:,:,107))
  call loop_AV_Q(G1(:,:,:,107),wf(:,-4),G1(:,:,:,108))
  call loop_A_Q(G1(:,:,:,108),Q(:,22),ZERO,G2(:,:,:,233))
  call loop_AV_Q(G2(:,:,:,233),wf(:,-3),G2(:,:,:,234))
  call loop_A_Q(G2(:,:,:,234),Q(:,30),ZERO,G3(:,:,:,187))
  call loop_AZ_Q(G3(:,:,:,187),wf(:,0),G3(:,:,:,188),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,188),Q(:,31),ZERO,G4tensor(:,73))
  call loop_AV_Q(G1(:,:,:,107),wf(:,-3),G1(:,:,:,109))
  call loop_A_Q(G1(:,:,:,109),Q(:,14),ZERO,G2(:,:,:,235))
  call loop_AV_Q(G2(:,:,:,235),wf(:,-4),G2(:,:,:,236))
  call loop_A_Q(G2(:,:,:,236),Q(:,30),ZERO,G3(:,:,:,189))
  call loop_AZ_Q(G3(:,:,:,189),wf(:,0),G3(:,:,:,190),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,190),Q(:,31),ZERO,G4tensor(:,74))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,29),gZu)
  call loop_A_Q(G0(:,:,:,29),Q(:,6),MT,G1(:,:,:,110))
  call loop_AV_Q(G1(:,:,:,110),wf(:,-4),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,22),MT,G2(:,:,:,237))
  call loop_AV_Q(G2(:,:,:,237),wf(:,-3),G2(:,:,:,238))
  call loop_A_Q(G2(:,:,:,238),Q(:,30),MT,G3(:,:,:,191))
  call loop_AZ_Q(G3(:,:,:,191),wf(:,0),G3(:,:,:,192),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,192),Q(:,31),MT,G4tensor(:,75))
  call loop_AV_Q(G1(:,:,:,110),wf(:,-3),G1(:,:,:,112))
  call loop_A_Q(G1(:,:,:,112),Q(:,14),MT,G2(:,:,:,239))
  call loop_AV_Q(G2(:,:,:,239),wf(:,-4),G2(:,:,:,240))
  call loop_A_Q(G2(:,:,:,240),Q(:,30),MT,G3(:,:,:,193))
  call loop_AZ_Q(G3(:,:,:,193),wf(:,0),G3(:,:,:,194),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,194),Q(:,31),MT,G4tensor(:,76))
  call loop_QZ_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,30),gZd)
  call loop_Q_A(G0(:,:,:,30),Q(:,6),ZERO,G1(:,:,:,113))
  call loop_QV_A(G1(:,:,:,113),wf(:,-4),G1(:,:,:,114))
  call loop_Q_A(G1(:,:,:,114),Q(:,22),ZERO,G2(:,:,:,241))
  call loop_QV_A(G2(:,:,:,241),wf(:,-3),G2(:,:,:,242))
  call loop_Q_A(G2(:,:,:,242),Q(:,30),ZERO,G3(:,:,:,195))
  call loop_QZ_A(G3(:,:,:,195),wf(:,0),G3(:,:,:,196),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,196),Q(:,31),ZERO,G4tensor(:,77))
  call loop_QV_A(G1(:,:,:,113),wf(:,-3),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,14),ZERO,G2(:,:,:,243))
  call loop_QV_A(G2(:,:,:,243),wf(:,-4),G2(:,:,:,244))
  call loop_Q_A(G2(:,:,:,244),Q(:,30),ZERO,G3(:,:,:,197))
  call loop_QZ_A(G3(:,:,:,197),wf(:,0),G3(:,:,:,198),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,198),Q(:,31),ZERO,G4tensor(:,78))
  call loop_QZ_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,31),gZd)
  call loop_Q_A(G0(:,:,:,31),Q(:,6),MB,G1(:,:,:,116))
  call loop_QV_A(G1(:,:,:,116),wf(:,-4),G1(:,:,:,117))
  call loop_Q_A(G1(:,:,:,117),Q(:,22),MB,G2(:,:,:,245))
  call loop_QV_A(G2(:,:,:,245),wf(:,-3),G2(:,:,:,246))
  call loop_Q_A(G2(:,:,:,246),Q(:,30),MB,G3(:,:,:,199))
  call loop_QZ_A(G3(:,:,:,199),wf(:,0),G3(:,:,:,200),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,200),Q(:,31),MB,G4tensor(:,79))
  call loop_QV_A(G1(:,:,:,116),wf(:,-3),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,14),MB,G2(:,:,:,247))
  call loop_QV_A(G2(:,:,:,247),wf(:,-4),G2(:,:,:,248))
  call loop_Q_A(G2(:,:,:,248),Q(:,30),MB,G3(:,:,:,201))
  call loop_QZ_A(G3(:,:,:,201),wf(:,0),G3(:,:,:,202),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,31),MB,G4tensor(:,80))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,32),gZd)
  call loop_A_Q(G0(:,:,:,32),Q(:,6),ZERO,G1(:,:,:,119))
  call loop_AV_Q(G1(:,:,:,119),wf(:,-4),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,22),ZERO,G2(:,:,:,249))
  call loop_AV_Q(G2(:,:,:,249),wf(:,-3),G2(:,:,:,250))
  call loop_A_Q(G2(:,:,:,250),Q(:,30),ZERO,G3(:,:,:,203))
  call loop_AZ_Q(G3(:,:,:,203),wf(:,0),G3(:,:,:,204),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,204),Q(:,31),ZERO,G4tensor(:,81))
  call loop_AV_Q(G1(:,:,:,119),wf(:,-3),G1(:,:,:,121))
  call loop_A_Q(G1(:,:,:,121),Q(:,14),ZERO,G2(:,:,:,251))
  call loop_AV_Q(G2(:,:,:,251),wf(:,-4),G2(:,:,:,252))
  call loop_A_Q(G2(:,:,:,252),Q(:,30),ZERO,G3(:,:,:,205))
  call loop_AZ_Q(G3(:,:,:,205),wf(:,0),G3(:,:,:,206),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,206),Q(:,31),ZERO,G4tensor(:,82))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,33),gZd)
  call loop_A_Q(G0(:,:,:,33),Q(:,6),MB,G1(:,:,:,122))
  call loop_AV_Q(G1(:,:,:,122),wf(:,-4),G1(:,:,:,123))
  call loop_A_Q(G1(:,:,:,123),Q(:,22),MB,G2(:,:,:,253))
  call loop_AV_Q(G2(:,:,:,253),wf(:,-3),G2(:,:,:,254))
  call loop_A_Q(G2(:,:,:,254),Q(:,30),MB,G3(:,:,:,207))
  call loop_AZ_Q(G3(:,:,:,207),wf(:,0),G3(:,:,:,208),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,208),Q(:,31),MB,G4tensor(:,83))
  call loop_AV_Q(G1(:,:,:,122),wf(:,-3),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,14),MB,G2(:,:,:,255))
  call loop_AV_Q(G2(:,:,:,255),wf(:,-4),G2(:,:,:,256))
  call loop_A_Q(G2(:,:,:,256),Q(:,30),MB,G3(:,:,:,209))
  call loop_AZ_Q(G3(:,:,:,209),wf(:,0),G3(:,:,:,210),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,210),Q(:,31),MB,G4tensor(:,84))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,2),ZERO,G1(:,:,:,125))
  call loop_AV_Q(G1(:,:,:,125),wf(:,-3),G1(:,:,:,126))
  call loop_A_Q(G1(:,:,:,126),Q(:,10),ZERO,G2(:,:,:,257))
  call loop_AV_Q(G2(:,:,:,257),wf(:,-4),G2(:,:,:,258))
  call loop_A_Q(G2(:,:,:,258),Q(:,26),ZERO,G3(:,:,:,211))
  call loop_AW_Q(G3(:,:,:,211),wf(:,-2),G3(:,:,:,212))
  call loop_A_Q(G3(:,:,:,212),Q(:,30),ZERO,G4(:,:,:,49))
  call loop_AZ_Q(G4(:,:,:,49),wf(:,0),G4(:,:,:,50),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,31),ZERO,G5tensor(:,25))
  call loop_AW_Q(G2(:,:,:,257),wf(:,-2),G2(:,:,:,259))
  call loop_A_Q(G2(:,:,:,259),Q(:,14),ZERO,G3(:,:,:,213))
  call loop_AV_Q(G3(:,:,:,213),wf(:,-4),G3(:,:,:,214))
  call loop_A_Q(G3(:,:,:,214),Q(:,30),ZERO,G4(:,:,:,51))
  call loop_AZ_Q(G4(:,:,:,51),wf(:,0),G4(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,31),ZERO,G5tensor(:,26))
  call loop_AV_Q(G1(:,:,:,125),wf(:,-4),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,18),ZERO,G2(:,:,:,260))
  call loop_AV_Q(G2(:,:,:,260),wf(:,-3),G2(:,:,:,261))
  call loop_A_Q(G2(:,:,:,261),Q(:,26),ZERO,G3(:,:,:,215))
  call loop_AW_Q(G3(:,:,:,215),wf(:,-2),G3(:,:,:,216))
  call loop_A_Q(G3(:,:,:,216),Q(:,30),ZERO,G4(:,:,:,53))
  call loop_AZ_Q(G4(:,:,:,53),wf(:,0),G4(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,31),ZERO,G5tensor(:,27))
  call loop_AW_Q(G2(:,:,:,260),wf(:,-2),G2(:,:,:,262))
  call loop_A_Q(G2(:,:,:,262),Q(:,22),ZERO,G3(:,:,:,217))
  call loop_AV_Q(G3(:,:,:,217),wf(:,-3),G3(:,:,:,218))
  call loop_A_Q(G3(:,:,:,218),Q(:,30),ZERO,G4(:,:,:,55))
  call loop_AZ_Q(G4(:,:,:,55),wf(:,0),G4(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,31),ZERO,G5tensor(:,28))
  call loop_AW_Q(G1(:,:,:,125),wf(:,-2),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,6),ZERO,G2(:,:,:,263))
  call loop_AV_Q(G2(:,:,:,263),wf(:,-4),G2(:,:,:,264))
  call loop_A_Q(G2(:,:,:,264),Q(:,22),ZERO,G3(:,:,:,219))
  call loop_AV_Q(G3(:,:,:,219),wf(:,-3),G3(:,:,:,220))
  call loop_A_Q(G3(:,:,:,220),Q(:,30),ZERO,G4(:,:,:,57))
  call loop_AZ_Q(G4(:,:,:,57),wf(:,0),G4(:,:,:,58),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,58),Q(:,31),ZERO,G5tensor(:,29))
  call loop_AV_Q(G2(:,:,:,263),wf(:,-3),G2(:,:,:,265))
  call loop_A_Q(G2(:,:,:,265),Q(:,14),ZERO,G3(:,:,:,221))
  call loop_AV_Q(G3(:,:,:,221),wf(:,-4),G3(:,:,:,222))
  call loop_A_Q(G3(:,:,:,222),Q(:,30),ZERO,G4(:,:,:,59))
  call loop_AZ_Q(G4(:,:,:,59),wf(:,0),G4(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,60),Q(:,31),ZERO,G5tensor(:,30))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,2),MT,G1(:,:,:,129))
  call loop_AV_Q(G1(:,:,:,129),wf(:,-3),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,10),MT,G2(:,:,:,266))
  call loop_AV_Q(G2(:,:,:,266),wf(:,-4),G2(:,:,:,267))
  call loop_A_Q(G2(:,:,:,267),Q(:,26),MT,G3(:,:,:,223))
  call loop_AW_Q(G3(:,:,:,223),wf(:,-2),G3(:,:,:,224))
  call loop_A_Q(G3(:,:,:,224),Q(:,30),MB,G4(:,:,:,61))
  call loop_AZ_Q(G4(:,:,:,61),wf(:,0),G4(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,31),MB,G5tensor(:,31))
  call loop_AW_Q(G2(:,:,:,266),wf(:,-2),G2(:,:,:,268))
  call loop_A_Q(G2(:,:,:,268),Q(:,14),MB,G3(:,:,:,225))
  call loop_AV_Q(G3(:,:,:,225),wf(:,-4),G3(:,:,:,226))
  call loop_A_Q(G3(:,:,:,226),Q(:,30),MB,G4(:,:,:,63))
  call loop_AZ_Q(G4(:,:,:,63),wf(:,0),G4(:,:,:,64),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,64),Q(:,31),MB,G5tensor(:,32))
  call loop_AV_Q(G1(:,:,:,129),wf(:,-4),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,18),MT,G2(:,:,:,269))
  call loop_AV_Q(G2(:,:,:,269),wf(:,-3),G2(:,:,:,270))
  call loop_A_Q(G2(:,:,:,270),Q(:,26),MT,G3(:,:,:,227))
  call loop_AW_Q(G3(:,:,:,227),wf(:,-2),G3(:,:,:,228))
  call loop_A_Q(G3(:,:,:,228),Q(:,30),MB,G4(:,:,:,65))
  call loop_AZ_Q(G4(:,:,:,65),wf(:,0),G4(:,:,:,66),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,31),MB,G5tensor(:,33))
  call loop_AW_Q(G2(:,:,:,269),wf(:,-2),G2(:,:,:,271))
  call loop_A_Q(G2(:,:,:,271),Q(:,22),MB,G3(:,:,:,229))
  call loop_AV_Q(G3(:,:,:,229),wf(:,-3),G3(:,:,:,230))
  call loop_A_Q(G3(:,:,:,230),Q(:,30),MB,G4(:,:,:,67))
  call loop_AZ_Q(G4(:,:,:,67),wf(:,0),G4(:,:,:,68),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,31),MB,G5tensor(:,34))
  call loop_AW_Q(G1(:,:,:,129),wf(:,-2),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,6),MB,G2(:,:,:,272))
  call loop_AV_Q(G2(:,:,:,272),wf(:,-4),G2(:,:,:,273))
  call loop_A_Q(G2(:,:,:,273),Q(:,22),MB,G3(:,:,:,231))
  call loop_AV_Q(G3(:,:,:,231),wf(:,-3),G3(:,:,:,232))
  call loop_A_Q(G3(:,:,:,232),Q(:,30),MB,G4(:,:,:,69))
  call loop_AZ_Q(G4(:,:,:,69),wf(:,0),G4(:,:,:,70),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,31),MB,G5tensor(:,35))
  call loop_AV_Q(G2(:,:,:,272),wf(:,-3),G2(:,:,:,274))
  call loop_A_Q(G2(:,:,:,274),Q(:,14),MB,G3(:,:,:,233))
  call loop_AV_Q(G3(:,:,:,233),wf(:,-4),G3(:,:,:,234))
  call loop_A_Q(G3(:,:,:,234),Q(:,30),MB,G4(:,:,:,71))
  call loop_AZ_Q(G4(:,:,:,71),wf(:,0),G4(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,31),MB,G5tensor(:,36))
  call loop_QW_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,2),ZERO,G1(:,:,:,133))
  call loop_QV_A(G1(:,:,:,133),wf(:,-3),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,10),ZERO,G2(:,:,:,275))
  call loop_QV_A(G2(:,:,:,275),wf(:,-4),G2(:,:,:,276))
  call loop_Q_A(G2(:,:,:,276),Q(:,26),ZERO,G3(:,:,:,235))
  call loop_QW_A(G3(:,:,:,235),wf(:,-2),G3(:,:,:,236))
  call loop_Q_A(G3(:,:,:,236),Q(:,30),ZERO,G4(:,:,:,73))
  call loop_QZ_A(G4(:,:,:,73),wf(:,0),G4(:,:,:,74),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,31),ZERO,G5tensor(:,37))
  call loop_QW_A(G2(:,:,:,275),wf(:,-2),G2(:,:,:,277))
  call loop_Q_A(G2(:,:,:,277),Q(:,14),ZERO,G3(:,:,:,237))
  call loop_QV_A(G3(:,:,:,237),wf(:,-4),G3(:,:,:,238))
  call loop_Q_A(G3(:,:,:,238),Q(:,30),ZERO,G4(:,:,:,75))
  call loop_QZ_A(G4(:,:,:,75),wf(:,0),G4(:,:,:,76),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,76),Q(:,31),ZERO,G5tensor(:,38))
  call loop_QV_A(G1(:,:,:,133),wf(:,-4),G1(:,:,:,135))
  call loop_Q_A(G1(:,:,:,135),Q(:,18),ZERO,G2(:,:,:,278))
  call loop_QV_A(G2(:,:,:,278),wf(:,-3),G2(:,:,:,279))
  call loop_Q_A(G2(:,:,:,279),Q(:,26),ZERO,G3(:,:,:,239))
  call loop_QW_A(G3(:,:,:,239),wf(:,-2),G3(:,:,:,240))
  call loop_Q_A(G3(:,:,:,240),Q(:,30),ZERO,G4(:,:,:,77))
  call loop_QZ_A(G4(:,:,:,77),wf(:,0),G4(:,:,:,78),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,31),ZERO,G5tensor(:,39))
  call loop_QW_A(G2(:,:,:,278),wf(:,-2),G2(:,:,:,280))
  call loop_Q_A(G2(:,:,:,280),Q(:,22),ZERO,G3(:,:,:,241))
  call loop_QV_A(G3(:,:,:,241),wf(:,-3),G3(:,:,:,242))
  call loop_Q_A(G3(:,:,:,242),Q(:,30),ZERO,G4(:,:,:,79))
  call loop_QZ_A(G4(:,:,:,79),wf(:,0),G4(:,:,:,80),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,31),ZERO,G5tensor(:,40))
  call loop_QW_A(G1(:,:,:,133),wf(:,-2),G1(:,:,:,136))
  call loop_Q_A(G1(:,:,:,136),Q(:,6),ZERO,G2(:,:,:,281))
  call loop_QV_A(G2(:,:,:,281),wf(:,-4),G2(:,:,:,282))
  call loop_Q_A(G2(:,:,:,282),Q(:,22),ZERO,G3(:,:,:,243))
  call loop_QV_A(G3(:,:,:,243),wf(:,-3),G3(:,:,:,244))
  call loop_Q_A(G3(:,:,:,244),Q(:,30),ZERO,G4(:,:,:,81))
  call loop_QZ_A(G4(:,:,:,81),wf(:,0),G4(:,:,:,82),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,82),Q(:,31),ZERO,G5tensor(:,41))
  call loop_QV_A(G2(:,:,:,281),wf(:,-3),G2(:,:,:,283))
  call loop_Q_A(G2(:,:,:,283),Q(:,14),ZERO,G3(:,:,:,245))
  call loop_QV_A(G3(:,:,:,245),wf(:,-4),G3(:,:,:,246))
  call loop_Q_A(G3(:,:,:,246),Q(:,30),ZERO,G4(:,:,:,83))
  call loop_QZ_A(G4(:,:,:,83),wf(:,0),G4(:,:,:,84),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,31),ZERO,G5tensor(:,42))
  call loop_QW_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,2),MB,G1(:,:,:,137))
  call loop_QV_A(G1(:,:,:,137),wf(:,-3),G1(:,:,:,138))
  call loop_Q_A(G1(:,:,:,138),Q(:,10),MB,G2(:,:,:,284))
  call loop_QV_A(G2(:,:,:,284),wf(:,-4),G2(:,:,:,285))
  call loop_Q_A(G2(:,:,:,285),Q(:,26),MB,G3(:,:,:,247))
  call loop_QW_A(G3(:,:,:,247),wf(:,-2),G3(:,:,:,248))
  call loop_Q_A(G3(:,:,:,248),Q(:,30),MT,G4(:,:,:,85))
  call loop_QZ_A(G4(:,:,:,85),wf(:,0),G4(:,:,:,86),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,31),MT,G5tensor(:,43))
  call loop_QW_A(G2(:,:,:,284),wf(:,-2),G2(:,:,:,286))
  call loop_Q_A(G2(:,:,:,286),Q(:,14),MT,G3(:,:,:,249))
  call loop_QV_A(G3(:,:,:,249),wf(:,-4),G3(:,:,:,250))
  call loop_Q_A(G3(:,:,:,250),Q(:,30),MT,G4(:,:,:,87))
  call loop_QZ_A(G4(:,:,:,87),wf(:,0),G4(:,:,:,88),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,31),MT,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,137),wf(:,-4),G1(:,:,:,139))
  call loop_Q_A(G1(:,:,:,139),Q(:,18),MB,G2(:,:,:,287))
  call loop_QV_A(G2(:,:,:,287),wf(:,-3),G2(:,:,:,288))
  call loop_Q_A(G2(:,:,:,288),Q(:,26),MB,G3(:,:,:,251))
  call loop_QW_A(G3(:,:,:,251),wf(:,-2),G3(:,:,:,252))
  call loop_Q_A(G3(:,:,:,252),Q(:,30),MT,G4(:,:,:,89))
  call loop_QZ_A(G4(:,:,:,89),wf(:,0),G4(:,:,:,90),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,31),MT,G5tensor(:,45))
  call loop_QW_A(G2(:,:,:,287),wf(:,-2),G2(:,:,:,289))
  call loop_Q_A(G2(:,:,:,289),Q(:,22),MT,G3(:,:,:,253))
  call loop_QV_A(G3(:,:,:,253),wf(:,-3),G3(:,:,:,254))
  call loop_Q_A(G3(:,:,:,254),Q(:,30),MT,G4(:,:,:,91))
  call loop_QZ_A(G4(:,:,:,91),wf(:,0),G4(:,:,:,92),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,31),MT,G5tensor(:,46))
  call loop_QW_A(G1(:,:,:,137),wf(:,-2),G1(:,:,:,140))
  call loop_Q_A(G1(:,:,:,140),Q(:,6),MT,G2(:,:,:,290))
  call loop_QV_A(G2(:,:,:,290),wf(:,-4),G2(:,:,:,291))
  call loop_Q_A(G2(:,:,:,291),Q(:,22),MT,G3(:,:,:,255))
  call loop_QV_A(G3(:,:,:,255),wf(:,-3),G3(:,:,:,256))
  call loop_Q_A(G3(:,:,:,256),Q(:,30),MT,G4(:,:,:,93))
  call loop_QZ_A(G4(:,:,:,93),wf(:,0),G4(:,:,:,94),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,31),MT,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,290),wf(:,-3),G2(:,:,:,292))
  call loop_Q_A(G2(:,:,:,292),Q(:,14),MT,G3(:,:,:,257))
  call loop_QV_A(G3(:,:,:,257),wf(:,-4),G3(:,:,:,258))
  call loop_Q_A(G3(:,:,:,258),Q(:,30),MT,G4(:,:,:,95))
  call loop_QZ_A(G4(:,:,:,95),wf(:,0),G4(:,:,:,96),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,31),MT,G5tensor(:,48))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-f(20) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-f(18) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,2))
  M(1) = M(1) + (-f(20) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (-f(18) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (f(18) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(17) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,3))
  M(1) = M(1) + (f(18) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (f(17) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,53),T3sum(1:35,3))
  M(1) = M(1) + (-f(14) * den(3)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-f(13) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,2))
  M(1) = M(1) + (-f(14) * den(3)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,1))
  M(1) = M(1) + (-f(13) * den(3)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,34),T3sum(1:35,2))
  M(1) = M(1) + (-f(14) * den(3)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-f(13) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,3))
  M(1) = M(1) + (-f(14) * den(3)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,24),T3sum(1:35,1))
  M(1) = M(1) + (-f(13) * den(3)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,54),T3sum(1:35,3))
  M(1) = M(1) + (-f(29) * den(17)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,2))
  M(1) = M(1) + (-f(29) * den(17)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,35),T3sum(1:35,2))
  M(1) = M(1) + (-f(24) * den(17)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,3))
  M(1) = M(1) + (-f(24) * den(17)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,55),T3sum(1:35,3))
  M(1) = M(1) + (f(20) * den(18)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(18) * den(18)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,2))
  M(1) = M(1) + (f(20) * den(18)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,25),T3sum(1:35,1))
  M(1) = M(1) + (f(18) * den(18)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,36),T3sum(1:35,2))
  M(1) = M(1) + (-f(18) * den(18)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-f(17) * den(18)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(1) = M(1) + (-f(18) * den(18)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,25),T3sum(1:35,1))
  M(1) = M(1) + (-f(17) * den(18)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,56),T3sum(1:35,3))
  M(1) = M(1) + (f(14) * den(19)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (f(13) * den(19)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,2))
  M(1) = M(1) + (f(14) * den(19)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,26),T3sum(1:35,1))
  M(1) = M(1) + (f(13) * den(19)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,37),T3sum(1:35,2))
  M(1) = M(1) + (f(14) * den(19)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(13) * den(19)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,47),T3sum(1:35,3))
  M(1) = M(1) + (f(14) * den(19)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,27),T3sum(1:35,1))
  M(1) = M(1) + (f(13) * den(19)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,57),T3sum(1:35,3))
  M(1) = M(1) + (f(10) * den(1)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (f(9) * den(1)) * TI2_call(4,momenta_8,masses2_7,G4tensor(:,7),T4sum(1:70,2))
  M(1) = M(1) + (f(10) * den(1)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,12),T4sum(1:70,1))
  M(1) = M(1) + (f(9) * den(1)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,24),T4sum(1:70,3))
  M(1) = M(1) + (f(10) * den(1)) * TI2_call(4,momenta_2,masses2_10,G4tensor(:,29),T4sum(1:70,4))
  M(1) = M(1) + (f(9) * den(1)) * TI2_call(4,momenta_2,masses2_8,G4tensor(:,31),T4sum(1:70,5))
  M(1) = M(1) + (f(10) * den(1)) * TI2_call(4,momenta_2,masses2_10,G4tensor(:,33),T4sum(1:70,4))
  M(1) = M(1) + (f(9) * den(1)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,35),T4sum(1:70,6))
  M(1) = M(1) + (f(10) * den(1)) * TI2_call(4,momenta_3,masses2_10,G4tensor(:,30),T4sum(1:70,7))
  M(1) = M(1) + (f(9) * den(1)) * TI2_call(4,momenta_3,masses2_8,G4tensor(:,32),T4sum(1:70,8))
  M(1) = M(1) + (f(10) * den(1)) * TI2_call(4,momenta_3,masses2_10,G4tensor(:,34),T4sum(1:70,7))
  M(1) = M(1) + (f(9) * den(1)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,36),T4sum(1:70,9))
  M(1) = M(1) + (-f(29) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,2))
  M(1) = M(1) + (-f(29) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,38),T3sum(1:35,2))
  M(1) = M(1) + (-f(24) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,48),T3sum(1:35,3))
  M(1) = M(1) + (-f(24) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,58),T3sum(1:35,3))
  M(1) = M(1) + (f(20) * den(21)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (f(18) * den(21)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,2))
  M(1) = M(1) + (f(20) * den(21)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,28),T3sum(1:35,1))
  M(1) = M(1) + (f(18) * den(21)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,39),T3sum(1:35,2))
  M(1) = M(1) + (-f(18) * den(21)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-f(17) * den(21)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,49),T3sum(1:35,3))
  M(1) = M(1) + (-f(18) * den(21)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,28),T3sum(1:35,1))
  M(1) = M(1) + (-f(17) * den(21)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,59),T3sum(1:35,3))
  M(1) = M(1) + (f(14) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (f(13) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (f(14) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,1))
  M(1) = M(1) + (f(13) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,40),T3sum(1:35,2))
  M(1) = M(1) + (f(14) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (f(13) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,50),T3sum(1:35,3))
  M(1) = M(1) + (f(14) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,1))
  M(1) = M(1) + (f(13) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,60),T3sum(1:35,3))
  M(1) = M(1) + (f(10) * den(2)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,2),T4sum(1:70,10))
  M(1) = M(1) + (f(9) * den(2)) * TI2_call(4,momenta_9,masses2_7,G4tensor(:,8),T4sum(1:70,11))
  M(1) = M(1) + (f(10) * den(2)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,13),T4sum(1:70,10))
  M(1) = M(1) + (f(9) * den(2)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,25),T4sum(1:70,12))
  M(1) = M(1) + (f(10) * den(2)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,37),T4sum(1:70,13))
  M(1) = M(1) + (f(9) * den(2)) * TI2_call(4,momenta_5,masses2_8,G4tensor(:,39),T4sum(1:70,14))
  M(1) = M(1) + (f(10) * den(2)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,41),T4sum(1:70,13))
  M(1) = M(1) + (f(9) * den(2)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,43),T4sum(1:70,15))
  M(1) = M(1) + (f(10) * den(2)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,38),T4sum(1:70,16))
  M(1) = M(1) + (f(9) * den(2)) * TI2_call(4,momenta_4,masses2_8,G4tensor(:,40),T4sum(1:70,17))
  M(1) = M(1) + (f(10) * den(2)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,42),T4sum(1:70,16))
  M(1) = M(1) + (f(9) * den(2)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,44),T4sum(1:70,18))
  M(1) = M(1) + (-f(16) * den(23)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (-f(15) * den(23)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,2))
  M(1) = M(1) + (-f(16) * den(23)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,1))
  M(1) = M(1) + (-f(15) * den(23)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,41),T3sum(1:35,2))
  M(1) = M(1) + (-f(16) * den(23)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-f(15) * den(23)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(1) = M(1) + (-f(16) * den(23)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,1))
  M(1) = M(1) + (-f(15) * den(23)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,61),T3sum(1:35,3))
  M(1) = M(1) + (-f(30) * den(24)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,2))
  M(1) = M(1) + (-f(30) * den(24)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,42),T3sum(1:35,2))
  M(1) = M(1) + (-f(25) * den(24)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,52),T3sum(1:35,3))
  M(1) = M(1) + (-f(25) * den(24)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,62),T3sum(1:35,3))
  M(1) = M(1) + (-f(31) * den(12)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,9),T4sum(1:70,19))
  M(1) = M(1) + (-f(31) * den(12)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,18),T4sum(1:70,19))
  M(1) = M(1) + (-f(26) * den(12)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,21),T4sum(1:70,20))
  M(1) = M(1) + (-f(26) * den(12)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,26),T4sum(1:70,20))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,3),T4sum(1:70,21))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,10),T4sum(1:70,19))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,14),T4sum(1:70,21))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,19),T4sum(1:70,19))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,4),T4sum(1:70,21))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,22),T4sum(1:70,20))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,15),T4sum(1:70,21))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,27),T4sum(1:70,20))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,5),T4sum(1:70,21))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,11),T4sum(1:70,19))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,16),T4sum(1:70,21))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,20),T4sum(1:70,19))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,6),T4sum(1:70,21))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,23),T4sum(1:70,20))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,17),T4sum(1:70,21))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,28),T4sum(1:70,20))
  M(1) = M(1) + (-f(31) * den(12)) * TI2_call(4,momenta_7,masses2_9,G4tensor(:,45),T4sum(1:70,22))
  M(1) = M(1) + (-f(31) * den(12)) * TI2_call(4,momenta_7,masses2_9,G4tensor(:,47),T4sum(1:70,22))
  M(1) = M(1) + (-f(26) * den(12)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,49),T4sum(1:70,23))
  M(1) = M(1) + (-f(26) * den(12)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,51),T4sum(1:70,23))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,53),T4sum(1:70,24))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(4,momenta_7,masses2_9,G4tensor(:,57),T4sum(1:70,22))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,59),T4sum(1:70,24))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(4,momenta_7,masses2_9,G4tensor(:,63),T4sum(1:70,22))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,54),T4sum(1:70,24))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,65),T4sum(1:70,23))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,60),T4sum(1:70,24))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,67),T4sum(1:70,23))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,69),T4sum(1:70,24))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_7,masses2_9,G4tensor(:,71),T4sum(1:70,22))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,73),T4sum(1:70,24))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_7,masses2_9,G4tensor(:,75),T4sum(1:70,22))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,77),T4sum(1:70,24))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,79),T4sum(1:70,23))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,81),T4sum(1:70,24))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,83),T4sum(1:70,23))
  M(1) = M(1) + (-f(31) * den(12)) * TI2_call(4,momenta_6,masses2_9,G4tensor(:,46),T4sum(1:70,25))
  M(1) = M(1) + (-f(31) * den(12)) * TI2_call(4,momenta_6,masses2_9,G4tensor(:,48),T4sum(1:70,25))
  M(1) = M(1) + (-f(26) * den(12)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,50),T4sum(1:70,26))
  M(1) = M(1) + (-f(26) * den(12)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,52),T4sum(1:70,26))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,55),T4sum(1:70,27))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(4,momenta_6,masses2_9,G4tensor(:,58),T4sum(1:70,25))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,61),T4sum(1:70,27))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(4,momenta_6,masses2_9,G4tensor(:,64),T4sum(1:70,25))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,56),T4sum(1:70,27))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,66),T4sum(1:70,26))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,62),T4sum(1:70,27))
  M(1) = M(1) + (-f(6) * den(4)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,68),T4sum(1:70,26))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,70),T4sum(1:70,27))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_6,masses2_9,G4tensor(:,72),T4sum(1:70,25))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,74),T4sum(1:70,27))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_6,masses2_9,G4tensor(:,76),T4sum(1:70,25))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,78),T4sum(1:70,27))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,80),T4sum(1:70,26))
  M(1) = M(1) + (f(21) * den(5)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,82),T4sum(1:70,27))
  M(1) = M(1) + (f(19) * den(5)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,84),T4sum(1:70,26))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_14,masses2_19,G5tensor(:,25),T5sum(1:126,1))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_14,masses2_18,G5tensor(:,31),T5sum(1:126,2))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_14,masses2_19,G5tensor(:,37),T5sum(1:126,1))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_14,masses2_11,G5tensor(:,43),T5sum(1:126,3))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_16,masses2_19,G5tensor(:,27),T5sum(1:126,4))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_16,masses2_18,G5tensor(:,33),T5sum(1:126,5))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_16,masses2_19,G5tensor(:,39),T5sum(1:126,4))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_16,masses2_11,G5tensor(:,45),T5sum(1:126,6))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_12,masses2_19,G5tensor(:,41),T5sum(1:126,7))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_12,masses2_14,G5tensor(:,47),T5sum(1:126,8))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_12,masses2_19,G5tensor(:,29),T5sum(1:126,7))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_12,masses2_15,G5tensor(:,35),T5sum(1:126,9))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_15,masses2_19,G5tensor(:,40),T5sum(1:126,10))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_15,masses2_12,G5tensor(:,46),T5sum(1:126,11))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_15,masses2_19,G5tensor(:,28),T5sum(1:126,10))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_15,masses2_17,G5tensor(:,34),T5sum(1:126,12))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_11,masses2_19,G5tensor(:,42),T5sum(1:126,13))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_11,masses2_14,G5tensor(:,48),T5sum(1:126,14))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_11,masses2_19,G5tensor(:,30),T5sum(1:126,13))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_11,masses2_15,G5tensor(:,36),T5sum(1:126,15))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_13,masses2_19,G5tensor(:,38),T5sum(1:126,16))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_13,masses2_12,G5tensor(:,44),T5sum(1:126,17))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_13,masses2_19,G5tensor(:,26),T5sum(1:126,16))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_13,masses2_17,G5tensor(:,32),T5sum(1:126,18))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_18,masses2_19,G5tensor(:,19),T5sum(1:126,19))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_18,masses2_14,G5tensor(:,23),T5sum(1:126,20))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_18,masses2_19,G5tensor(:,11),T5sum(1:126,19))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_18,masses2_15,G5tensor(:,15),T5sum(1:126,21))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_20,masses2_19,G5tensor(:,18),T5sum(1:126,22))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_20,masses2_12,G5tensor(:,22),T5sum(1:126,23))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_20,masses2_19,G5tensor(:,10),T5sum(1:126,22))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_20,masses2_17,G5tensor(:,14),T5sum(1:126,24))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_17,masses2_19,G5tensor(:,20),T5sum(1:126,25))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_17,masses2_14,G5tensor(:,24),T5sum(1:126,26))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_17,masses2_19,G5tensor(:,12),T5sum(1:126,25))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_17,masses2_15,G5tensor(:,16),T5sum(1:126,27))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_19,masses2_19,G5tensor(:,17),T5sum(1:126,28))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_19,masses2_12,G5tensor(:,21),T5sum(1:126,29))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_19,masses2_19,G5tensor(:,9),T5sum(1:126,28))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_19,masses2_17,G5tensor(:,13),T5sum(1:126,30))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_21,masses2_19,G5tensor(:,5),T5sum(1:126,31))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_21,masses2_16,G5tensor(:,6),T5sum(1:126,32))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_21,masses2_19,G5tensor(:,2),T5sum(1:126,31))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_21,masses2_13,G5tensor(:,7),T5sum(1:126,33))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_22,masses2_19,G5tensor(:,1),T5sum(1:126,34))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_22,masses2_16,G5tensor(:,3),T5sum(1:126,35))
  M(1) = M(1) + (f(12)) * TI2_call(5,momenta_22,masses2_19,G5tensor(:,4),T5sum(1:126,34))
  M(1) = M(1) + (f(11)) * TI2_call(5,momenta_22,masses2_13,G5tensor(:,8),T5sum(1:126,36))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppvvv2_zwwxgg_1_/**/REALKIND
