
module ol_vamp_1_ppvvv2_aazgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv2_aazgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv2_aazgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvv2_aazgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvv2_aazgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,21) :: G0
  complex(REALKIND), dimension(4,5,4,78) :: G1
  complex(REALKIND), dimension(4,15,4,150) :: G2
  complex(REALKIND), dimension(4,35,4,188) :: G3
  complex(REALKIND), dimension(4,70,4,192) :: G4
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G5tensorhel(126,96,48))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,2),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,10),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-4),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,26),ZERO,G3(:,:,:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,-2),G3(:,:,:,2),gZu)
  call loop_A_Q(G3(:,:,:,2),Q(:,30),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,0),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,31),ZERO,G5tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,-2),G3(:,:,:,3),gZd)
  call loop_A_Q(G3(:,:,:,3),Q(:,30),ZERO,G4(:,:,:,3))
  call loop_AV_Q(G4(:,:,:,3),wf(:,0),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,31),ZERO,G5tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,-2),G2(:,:,:,3),gZu)
  call loop_A_Q(G2(:,:,:,3),Q(:,14),ZERO,G3(:,:,:,4))
  call loop_AV_Q(G3(:,:,:,4),wf(:,-4),G3(:,:,:,5))
  call loop_A_Q(G3(:,:,:,5),Q(:,30),ZERO,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,0),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,31),ZERO,G5tensor(:,3))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,-2),G2(:,:,:,4),gZd)
  call loop_A_Q(G2(:,:,:,4),Q(:,14),ZERO,G3(:,:,:,6))
  call loop_AV_Q(G3(:,:,:,6),wf(:,-4),G3(:,:,:,7))
  call loop_A_Q(G3(:,:,:,7),Q(:,30),ZERO,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,0),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,31),ZERO,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,18),ZERO,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,-3),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,26),ZERO,G3(:,:,:,8))
  call loop_AZ_Q(G3(:,:,:,8),wf(:,-2),G3(:,:,:,9),gZu)
  call loop_A_Q(G3(:,:,:,9),Q(:,30),ZERO,G4(:,:,:,9))
  call loop_AV_Q(G4(:,:,:,9),wf(:,0),G4(:,:,:,10))
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,31),ZERO,G5tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,8),wf(:,-2),G3(:,:,:,10),gZd)
  call loop_A_Q(G3(:,:,:,10),Q(:,30),ZERO,G4(:,:,:,11))
  call loop_AV_Q(G4(:,:,:,11),wf(:,0),G4(:,:,:,12))
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,31),ZERO,G5tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,5),wf(:,-2),G2(:,:,:,7),gZu)
  call loop_A_Q(G2(:,:,:,7),Q(:,22),ZERO,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-3),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,30),ZERO,G4(:,:,:,13))
  call loop_AV_Q(G4(:,:,:,13),wf(:,0),G4(:,:,:,14))
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,31),ZERO,G5tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,5),wf(:,-2),G2(:,:,:,8),gZd)
  call loop_A_Q(G2(:,:,:,8),Q(:,22),ZERO,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,-3),G3(:,:,:,14))
  call loop_A_Q(G3(:,:,:,14),Q(:,30),ZERO,G4(:,:,:,15))
  call loop_AV_Q(G4(:,:,:,15),wf(:,0),G4(:,:,:,16))
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,31),ZERO,G5tensor(:,8))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,4),gZu)
  call loop_A_Q(G1(:,:,:,4),Q(:,6),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-4),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,22),ZERO,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,-3),G3(:,:,:,16))
  call loop_A_Q(G3(:,:,:,16),Q(:,30),ZERO,G4(:,:,:,17))
  call loop_AV_Q(G4(:,:,:,17),wf(:,0),G4(:,:,:,18))
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,31),ZERO,G5tensor(:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-3),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,14),ZERO,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,-4),G3(:,:,:,18))
  call loop_A_Q(G3(:,:,:,18),Q(:,30),ZERO,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,0),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,31),ZERO,G5tensor(:,10))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,5),gZd)
  call loop_A_Q(G1(:,:,:,5),Q(:,6),ZERO,G2(:,:,:,12))
  call loop_AV_Q(G2(:,:,:,12),wf(:,-4),G2(:,:,:,13))
  call loop_A_Q(G2(:,:,:,13),Q(:,22),ZERO,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-3),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,30),ZERO,G4(:,:,:,21))
  call loop_AV_Q(G4(:,:,:,21),wf(:,0),G4(:,:,:,22))
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,31),ZERO,G5tensor(:,11))
  call loop_AV_Q(G2(:,:,:,12),wf(:,-3),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,14),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-4),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,30),ZERO,G4(:,:,:,23))
  call loop_AV_Q(G4(:,:,:,23),wf(:,0),G4(:,:,:,24))
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,31),ZERO,G5tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,2),MT,G1(:,:,:,6))
  call loop_AV_Q(G1(:,:,:,6),wf(:,-3),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,10),MT,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-4),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,26),MT,G3(:,:,:,23))
  call loop_AZ_Q(G3(:,:,:,23),wf(:,-2),G3(:,:,:,24),gZu)
  call loop_A_Q(G3(:,:,:,24),Q(:,30),MT,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,0),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,31),MT,G5tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,-2),G2(:,:,:,17),gZu)
  call loop_A_Q(G2(:,:,:,17),Q(:,14),MT,G3(:,:,:,25))
  call loop_AV_Q(G3(:,:,:,25),wf(:,-4),G3(:,:,:,26))
  call loop_A_Q(G3(:,:,:,26),Q(:,30),MT,G4(:,:,:,27))
  call loop_AV_Q(G4(:,:,:,27),wf(:,0),G4(:,:,:,28))
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,31),MT,G5tensor(:,14))
  call loop_AV_Q(G1(:,:,:,6),wf(:,-4),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,18),MT,G2(:,:,:,18))
  call loop_AV_Q(G2(:,:,:,18),wf(:,-3),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,26),MT,G3(:,:,:,27))
  call loop_AZ_Q(G3(:,:,:,27),wf(:,-2),G3(:,:,:,28),gZu)
  call loop_A_Q(G3(:,:,:,28),Q(:,30),MT,G4(:,:,:,29))
  call loop_AV_Q(G4(:,:,:,29),wf(:,0),G4(:,:,:,30))
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,31),MT,G5tensor(:,15))
  call loop_AZ_Q(G2(:,:,:,18),wf(:,-2),G2(:,:,:,20),gZu)
  call loop_A_Q(G2(:,:,:,20),Q(:,22),MT,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,-3),G3(:,:,:,30))
  call loop_A_Q(G3(:,:,:,30),Q(:,30),MT,G4(:,:,:,31))
  call loop_AV_Q(G4(:,:,:,31),wf(:,0),G4(:,:,:,32))
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,31),MT,G5tensor(:,16))
  call loop_AZ_Q(G1(:,:,:,6),wf(:,-2),G1(:,:,:,9),gZu)
  call loop_A_Q(G1(:,:,:,9),Q(:,6),MT,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-4),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,22),MT,G3(:,:,:,31))
  call loop_AV_Q(G3(:,:,:,31),wf(:,-3),G3(:,:,:,32))
  call loop_A_Q(G3(:,:,:,32),Q(:,30),MT,G4(:,:,:,33))
  call loop_AV_Q(G4(:,:,:,33),wf(:,0),G4(:,:,:,34))
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,31),MT,G5tensor(:,17))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-3),G2(:,:,:,23))
  call loop_A_Q(G2(:,:,:,23),Q(:,14),MT,G3(:,:,:,33))
  call loop_AV_Q(G3(:,:,:,33),wf(:,-4),G3(:,:,:,34))
  call loop_A_Q(G3(:,:,:,34),Q(:,30),MT,G4(:,:,:,35))
  call loop_AV_Q(G4(:,:,:,35),wf(:,0),G4(:,:,:,36))
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,31),MT,G5tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,2),ZERO,G1(:,:,:,10))
  call loop_QV_A(G1(:,:,:,10),wf(:,-3),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,10),ZERO,G2(:,:,:,24))
  call loop_QV_A(G2(:,:,:,24),wf(:,-4),G2(:,:,:,25))
  call loop_Q_A(G2(:,:,:,25),Q(:,26),ZERO,G3(:,:,:,35))
  call loop_QZ_A(G3(:,:,:,35),wf(:,-2),G3(:,:,:,36),gZu)
  call loop_Q_A(G3(:,:,:,36),Q(:,30),ZERO,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,0),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,31),ZERO,G5tensor(:,19))
  call loop_QZ_A(G3(:,:,:,35),wf(:,-2),G3(:,:,:,37),gZd)
  call loop_Q_A(G3(:,:,:,37),Q(:,30),ZERO,G4(:,:,:,39))
  call loop_QV_A(G4(:,:,:,39),wf(:,0),G4(:,:,:,40))
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,31),ZERO,G5tensor(:,20))
  call loop_QZ_A(G2(:,:,:,24),wf(:,-2),G2(:,:,:,26),gZu)
  call loop_Q_A(G2(:,:,:,26),Q(:,14),ZERO,G3(:,:,:,38))
  call loop_QV_A(G3(:,:,:,38),wf(:,-4),G3(:,:,:,39))
  call loop_Q_A(G3(:,:,:,39),Q(:,30),ZERO,G4(:,:,:,41))
  call loop_QV_A(G4(:,:,:,41),wf(:,0),G4(:,:,:,42))
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,31),ZERO,G5tensor(:,21))
  call loop_QZ_A(G2(:,:,:,24),wf(:,-2),G2(:,:,:,27),gZd)
  call loop_Q_A(G2(:,:,:,27),Q(:,14),ZERO,G3(:,:,:,40))
  call loop_QV_A(G3(:,:,:,40),wf(:,-4),G3(:,:,:,41))
  call loop_Q_A(G3(:,:,:,41),Q(:,30),ZERO,G4(:,:,:,43))
  call loop_QV_A(G4(:,:,:,43),wf(:,0),G4(:,:,:,44))
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,31),ZERO,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,10),wf(:,-4),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,18),ZERO,G2(:,:,:,28))
  call loop_QV_A(G2(:,:,:,28),wf(:,-3),G2(:,:,:,29))
  call loop_Q_A(G2(:,:,:,29),Q(:,26),ZERO,G3(:,:,:,42))
  call loop_QZ_A(G3(:,:,:,42),wf(:,-2),G3(:,:,:,43),gZu)
  call loop_Q_A(G3(:,:,:,43),Q(:,30),ZERO,G4(:,:,:,45))
  call loop_QV_A(G4(:,:,:,45),wf(:,0),G4(:,:,:,46))
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,31),ZERO,G5tensor(:,23))
  call loop_QZ_A(G3(:,:,:,42),wf(:,-2),G3(:,:,:,44),gZd)
  call loop_Q_A(G3(:,:,:,44),Q(:,30),ZERO,G4(:,:,:,47))
  call loop_QV_A(G4(:,:,:,47),wf(:,0),G4(:,:,:,48))
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,31),ZERO,G5tensor(:,24))
  call loop_QZ_A(G2(:,:,:,28),wf(:,-2),G2(:,:,:,30),gZu)
  call loop_Q_A(G2(:,:,:,30),Q(:,22),ZERO,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,-3),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,30),ZERO,G4(:,:,:,49))
  call loop_QV_A(G4(:,:,:,49),wf(:,0),G4(:,:,:,50))
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,31),ZERO,G5tensor(:,25))
  call loop_QZ_A(G2(:,:,:,28),wf(:,-2),G2(:,:,:,31),gZd)
  call loop_Q_A(G2(:,:,:,31),Q(:,22),ZERO,G3(:,:,:,47))
  call loop_QV_A(G3(:,:,:,47),wf(:,-3),G3(:,:,:,48))
  call loop_Q_A(G3(:,:,:,48),Q(:,30),ZERO,G4(:,:,:,51))
  call loop_QV_A(G4(:,:,:,51),wf(:,0),G4(:,:,:,52))
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,31),ZERO,G5tensor(:,26))
  call loop_QZ_A(G1(:,:,:,10),wf(:,-2),G1(:,:,:,13),gZu)
  call loop_Q_A(G1(:,:,:,13),Q(:,6),ZERO,G2(:,:,:,32))
  call loop_QV_A(G2(:,:,:,32),wf(:,-4),G2(:,:,:,33))
  call loop_Q_A(G2(:,:,:,33),Q(:,22),ZERO,G3(:,:,:,49))
  call loop_QV_A(G3(:,:,:,49),wf(:,-3),G3(:,:,:,50))
  call loop_Q_A(G3(:,:,:,50),Q(:,30),ZERO,G4(:,:,:,53))
  call loop_QV_A(G4(:,:,:,53),wf(:,0),G4(:,:,:,54))
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,31),ZERO,G5tensor(:,27))
  call loop_QV_A(G2(:,:,:,32),wf(:,-3),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,14),ZERO,G3(:,:,:,51))
  call loop_QV_A(G3(:,:,:,51),wf(:,-4),G3(:,:,:,52))
  call loop_Q_A(G3(:,:,:,52),Q(:,30),ZERO,G4(:,:,:,55))
  call loop_QV_A(G4(:,:,:,55),wf(:,0),G4(:,:,:,56))
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,31),ZERO,G5tensor(:,28))
  call loop_QZ_A(G1(:,:,:,10),wf(:,-2),G1(:,:,:,14),gZd)
  call loop_Q_A(G1(:,:,:,14),Q(:,6),ZERO,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,-4),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,22),ZERO,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,-3),G3(:,:,:,54))
  call loop_Q_A(G3(:,:,:,54),Q(:,30),ZERO,G4(:,:,:,57))
  call loop_QV_A(G4(:,:,:,57),wf(:,0),G4(:,:,:,58))
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,31),ZERO,G5tensor(:,29))
  call loop_QV_A(G2(:,:,:,35),wf(:,-3),G2(:,:,:,37))
  call loop_Q_A(G2(:,:,:,37),Q(:,14),ZERO,G3(:,:,:,55))
  call loop_QV_A(G3(:,:,:,55),wf(:,-4),G3(:,:,:,56))
  call loop_Q_A(G3(:,:,:,56),Q(:,30),ZERO,G4(:,:,:,59))
  call loop_QV_A(G4(:,:,:,59),wf(:,0),G4(:,:,:,60))
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,31),ZERO,G5tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,2),MT,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,-3),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,10),MT,G2(:,:,:,38))
  call loop_QV_A(G2(:,:,:,38),wf(:,-4),G2(:,:,:,39))
  call loop_Q_A(G2(:,:,:,39),Q(:,26),MT,G3(:,:,:,57))
  call loop_QZ_A(G3(:,:,:,57),wf(:,-2),G3(:,:,:,58),gZu)
  call loop_Q_A(G3(:,:,:,58),Q(:,30),MT,G4(:,:,:,61))
  call loop_QV_A(G4(:,:,:,61),wf(:,0),G4(:,:,:,62))
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,31),MT,G5tensor(:,31))
  call loop_QZ_A(G2(:,:,:,38),wf(:,-2),G2(:,:,:,40),gZu)
  call loop_Q_A(G2(:,:,:,40),Q(:,14),MT,G3(:,:,:,59))
  call loop_QV_A(G3(:,:,:,59),wf(:,-4),G3(:,:,:,60))
  call loop_Q_A(G3(:,:,:,60),Q(:,30),MT,G4(:,:,:,63))
  call loop_QV_A(G4(:,:,:,63),wf(:,0),G4(:,:,:,64))
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,31),MT,G5tensor(:,32))
  call loop_QV_A(G1(:,:,:,15),wf(:,-4),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,18),MT,G2(:,:,:,41))
  call loop_QV_A(G2(:,:,:,41),wf(:,-3),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,26),MT,G3(:,:,:,61))
  call loop_QZ_A(G3(:,:,:,61),wf(:,-2),G3(:,:,:,62),gZu)
  call loop_Q_A(G3(:,:,:,62),Q(:,30),MT,G4(:,:,:,65))
  call loop_QV_A(G4(:,:,:,65),wf(:,0),G4(:,:,:,66))
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,31),MT,G5tensor(:,33))
  call loop_QZ_A(G2(:,:,:,41),wf(:,-2),G2(:,:,:,43),gZu)
  call loop_Q_A(G2(:,:,:,43),Q(:,22),MT,G3(:,:,:,63))
  call loop_QV_A(G3(:,:,:,63),wf(:,-3),G3(:,:,:,64))
  call loop_Q_A(G3(:,:,:,64),Q(:,30),MT,G4(:,:,:,67))
  call loop_QV_A(G4(:,:,:,67),wf(:,0),G4(:,:,:,68))
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,31),MT,G5tensor(:,34))
  call loop_QZ_A(G1(:,:,:,15),wf(:,-2),G1(:,:,:,18),gZu)
  call loop_Q_A(G1(:,:,:,18),Q(:,6),MT,G2(:,:,:,44))
  call loop_QV_A(G2(:,:,:,44),wf(:,-4),G2(:,:,:,45))
  call loop_Q_A(G2(:,:,:,45),Q(:,22),MT,G3(:,:,:,65))
  call loop_QV_A(G3(:,:,:,65),wf(:,-3),G3(:,:,:,66))
  call loop_Q_A(G3(:,:,:,66),Q(:,30),MT,G4(:,:,:,69))
  call loop_QV_A(G4(:,:,:,69),wf(:,0),G4(:,:,:,70))
  call check_last_Q_A(l_switch,G4(:,:,:,70),Q(:,31),MT,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,44),wf(:,-3),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,14),MT,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,-4),G3(:,:,:,68))
  call loop_Q_A(G3(:,:,:,68),Q(:,30),MT,G4(:,:,:,71))
  call loop_QV_A(G4(:,:,:,71),wf(:,0),G4(:,:,:,72))
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,31),MT,G5tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,2),MB,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-3),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,10),MB,G2(:,:,:,47))
  call loop_AV_Q(G2(:,:,:,47),wf(:,-4),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,26),MB,G3(:,:,:,69))
  call loop_AZ_Q(G3(:,:,:,69),wf(:,-2),G3(:,:,:,70),gZd)
  call loop_A_Q(G3(:,:,:,70),Q(:,30),MB,G4(:,:,:,73))
  call loop_AV_Q(G4(:,:,:,73),wf(:,0),G4(:,:,:,74))
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,31),MB,G5tensor(:,37))
  call loop_AZ_Q(G2(:,:,:,47),wf(:,-2),G2(:,:,:,49),gZd)
  call loop_A_Q(G2(:,:,:,49),Q(:,14),MB,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-4),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,30),MB,G4(:,:,:,75))
  call loop_AV_Q(G4(:,:,:,75),wf(:,0),G4(:,:,:,76))
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,31),MB,G5tensor(:,38))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-4),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,18),MB,G2(:,:,:,50))
  call loop_AV_Q(G2(:,:,:,50),wf(:,-3),G2(:,:,:,51))
  call loop_A_Q(G2(:,:,:,51),Q(:,26),MB,G3(:,:,:,73))
  call loop_AZ_Q(G3(:,:,:,73),wf(:,-2),G3(:,:,:,74),gZd)
  call loop_A_Q(G3(:,:,:,74),Q(:,30),MB,G4(:,:,:,77))
  call loop_AV_Q(G4(:,:,:,77),wf(:,0),G4(:,:,:,78))
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,31),MB,G5tensor(:,39))
  call loop_AZ_Q(G2(:,:,:,50),wf(:,-2),G2(:,:,:,52),gZd)
  call loop_A_Q(G2(:,:,:,52),Q(:,22),MB,G3(:,:,:,75))
  call loop_AV_Q(G3(:,:,:,75),wf(:,-3),G3(:,:,:,76))
  call loop_A_Q(G3(:,:,:,76),Q(:,30),MB,G4(:,:,:,79))
  call loop_AV_Q(G4(:,:,:,79),wf(:,0),G4(:,:,:,80))
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,31),MB,G5tensor(:,40))
  call loop_AZ_Q(G1(:,:,:,19),wf(:,-2),G1(:,:,:,22),gZd)
  call loop_A_Q(G1(:,:,:,22),Q(:,6),MB,G2(:,:,:,53))
  call loop_AV_Q(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,22),MB,G3(:,:,:,77))
  call loop_AV_Q(G3(:,:,:,77),wf(:,-3),G3(:,:,:,78))
  call loop_A_Q(G3(:,:,:,78),Q(:,30),MB,G4(:,:,:,81))
  call loop_AV_Q(G4(:,:,:,81),wf(:,0),G4(:,:,:,82))
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,31),MB,G5tensor(:,41))
  call loop_AV_Q(G2(:,:,:,53),wf(:,-3),G2(:,:,:,55))
  call loop_A_Q(G2(:,:,:,55),Q(:,14),MB,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-4),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,30),MB,G4(:,:,:,83))
  call loop_AV_Q(G4(:,:,:,83),wf(:,0),G4(:,:,:,84))
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,31),MB,G5tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,2),MB,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,-3),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,10),MB,G2(:,:,:,56))
  call loop_QV_A(G2(:,:,:,56),wf(:,-4),G2(:,:,:,57))
  call loop_Q_A(G2(:,:,:,57),Q(:,26),MB,G3(:,:,:,81))
  call loop_QZ_A(G3(:,:,:,81),wf(:,-2),G3(:,:,:,82),gZd)
  call loop_Q_A(G3(:,:,:,82),Q(:,30),MB,G4(:,:,:,85))
  call loop_QV_A(G4(:,:,:,85),wf(:,0),G4(:,:,:,86))
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,31),MB,G5tensor(:,43))
  call loop_QZ_A(G2(:,:,:,56),wf(:,-2),G2(:,:,:,58),gZd)
  call loop_Q_A(G2(:,:,:,58),Q(:,14),MB,G3(:,:,:,83))
  call loop_QV_A(G3(:,:,:,83),wf(:,-4),G3(:,:,:,84))
  call loop_Q_A(G3(:,:,:,84),Q(:,30),MB,G4(:,:,:,87))
  call loop_QV_A(G4(:,:,:,87),wf(:,0),G4(:,:,:,88))
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,31),MB,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,23),wf(:,-4),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,18),MB,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,-3),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,26),MB,G3(:,:,:,85))
  call loop_QZ_A(G3(:,:,:,85),wf(:,-2),G3(:,:,:,86),gZd)
  call loop_Q_A(G3(:,:,:,86),Q(:,30),MB,G4(:,:,:,89))
  call loop_QV_A(G4(:,:,:,89),wf(:,0),G4(:,:,:,90))
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,31),MB,G5tensor(:,45))
  call loop_QZ_A(G2(:,:,:,59),wf(:,-2),G2(:,:,:,61),gZd)
  call loop_Q_A(G2(:,:,:,61),Q(:,22),MB,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-3),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,30),MB,G4(:,:,:,91))
  call loop_QV_A(G4(:,:,:,91),wf(:,0),G4(:,:,:,92))
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,31),MB,G5tensor(:,46))
  call loop_QZ_A(G1(:,:,:,23),wf(:,-2),G1(:,:,:,26),gZd)
  call loop_Q_A(G1(:,:,:,26),Q(:,6),MB,G2(:,:,:,62))
  call loop_QV_A(G2(:,:,:,62),wf(:,-4),G2(:,:,:,63))
  call loop_Q_A(G2(:,:,:,63),Q(:,22),MB,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,-3),G3(:,:,:,90))
  call loop_Q_A(G3(:,:,:,90),Q(:,30),MB,G4(:,:,:,93))
  call loop_QV_A(G4(:,:,:,93),wf(:,0),G4(:,:,:,94))
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,31),MB,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,62),wf(:,-3),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,14),MB,G3(:,:,:,91))
  call loop_QV_A(G3(:,:,:,91),wf(:,-4),G3(:,:,:,92))
  call loop_Q_A(G3(:,:,:,92),Q(:,30),MB,G4(:,:,:,95))
  call loop_QV_A(G4(:,:,:,95),wf(:,0),G4(:,:,:,96))
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,31),MB,G5tensor(:,48))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,8),gZu)
  call loop_A_Q(G0(:,:,:,8),Q(:,4),ZERO,G1(:,:,:,27))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-1),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,6),ZERO,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-4),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,22),ZERO,G3(:,:,:,93))
  call loop_AV_Q(G3(:,:,:,93),wf(:,-3),G3(:,:,:,94))
  call loop_A_Q(G3(:,:,:,94),Q(:,30),ZERO,G4(:,:,:,97))
  call loop_AV_Q(G4(:,:,:,97),wf(:,0),G4(:,:,:,98))
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,31),ZERO,G5tensor(:,49))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-3),G2(:,:,:,67))
  call loop_A_Q(G2(:,:,:,67),Q(:,14),ZERO,G3(:,:,:,95))
  call loop_AV_Q(G3(:,:,:,95),wf(:,-4),G3(:,:,:,96))
  call loop_A_Q(G3(:,:,:,96),Q(:,30),ZERO,G4(:,:,:,99))
  call loop_AV_Q(G4(:,:,:,99),wf(:,0),G4(:,:,:,100))
  call check_last_A_Q(l_switch,G4(:,:,:,100),Q(:,31),ZERO,G5tensor(:,50))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-4),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,20),ZERO,G2(:,:,:,68))
  call loop_AV_Q(G2(:,:,:,68),wf(:,-1),G2(:,:,:,69))
  call loop_A_Q(G2(:,:,:,69),Q(:,22),ZERO,G3(:,:,:,97))
  call loop_AV_Q(G3(:,:,:,97),wf(:,-3),G3(:,:,:,98))
  call loop_A_Q(G3(:,:,:,98),Q(:,30),ZERO,G4(:,:,:,101))
  call loop_AV_Q(G4(:,:,:,101),wf(:,0),G4(:,:,:,102))
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,31),ZERO,G5tensor(:,51))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-3),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,12),ZERO,G2(:,:,:,70))
  call loop_AV_Q(G2(:,:,:,70),wf(:,-1),G2(:,:,:,71))
  call loop_A_Q(G2(:,:,:,71),Q(:,14),ZERO,G3(:,:,:,99))
  call loop_AV_Q(G3(:,:,:,99),wf(:,-4),G3(:,:,:,100))
  call loop_A_Q(G3(:,:,:,100),Q(:,30),ZERO,G4(:,:,:,103))
  call loop_AV_Q(G4(:,:,:,103),wf(:,0),G4(:,:,:,104))
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,31),ZERO,G5tensor(:,52))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,9),gZu)
  call loop_A_Q(G0(:,:,:,9),Q(:,4),MT,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-1),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,6),MT,G2(:,:,:,72))
  call loop_AV_Q(G2(:,:,:,72),wf(:,-4),G2(:,:,:,73))
  call loop_A_Q(G2(:,:,:,73),Q(:,22),MT,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,-3),G3(:,:,:,102))
  call loop_A_Q(G3(:,:,:,102),Q(:,30),MT,G4(:,:,:,105))
  call loop_AV_Q(G4(:,:,:,105),wf(:,0),G4(:,:,:,106))
  call check_last_A_Q(l_switch,G4(:,:,:,106),Q(:,31),MT,G5tensor(:,53))
  call loop_AV_Q(G2(:,:,:,72),wf(:,-3),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,14),MT,G3(:,:,:,103))
  call loop_AV_Q(G3(:,:,:,103),wf(:,-4),G3(:,:,:,104))
  call loop_A_Q(G3(:,:,:,104),Q(:,30),MT,G4(:,:,:,107))
  call loop_AV_Q(G4(:,:,:,107),wf(:,0),G4(:,:,:,108))
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,31),MT,G5tensor(:,54))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-4),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,20),MT,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,-1),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,22),MT,G3(:,:,:,105))
  call loop_AV_Q(G3(:,:,:,105),wf(:,-3),G3(:,:,:,106))
  call loop_A_Q(G3(:,:,:,106),Q(:,30),MT,G4(:,:,:,109))
  call loop_AV_Q(G4(:,:,:,109),wf(:,0),G4(:,:,:,110))
  call check_last_A_Q(l_switch,G4(:,:,:,110),Q(:,31),MT,G5tensor(:,55))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-3),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,12),MT,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,-1),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,14),MT,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,-4),G3(:,:,:,108))
  call loop_A_Q(G3(:,:,:,108),Q(:,30),MT,G4(:,:,:,111))
  call loop_AV_Q(G4(:,:,:,111),wf(:,0),G4(:,:,:,112))
  call check_last_A_Q(l_switch,G4(:,:,:,112),Q(:,31),MT,G5tensor(:,56))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,10),gZu)
  call loop_Q_A(G0(:,:,:,10),Q(:,4),ZERO,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,-1),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,6),ZERO,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,-4),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,22),ZERO,G3(:,:,:,109))
  call loop_QV_A(G3(:,:,:,109),wf(:,-3),G3(:,:,:,110))
  call loop_Q_A(G3(:,:,:,110),Q(:,30),ZERO,G4(:,:,:,113))
  call loop_QV_A(G4(:,:,:,113),wf(:,0),G4(:,:,:,114))
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,31),ZERO,G5tensor(:,57))
  call loop_QV_A(G2(:,:,:,79),wf(:,-3),G2(:,:,:,81))
  call loop_Q_A(G2(:,:,:,81),Q(:,14),ZERO,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,-4),G3(:,:,:,112))
  call loop_Q_A(G3(:,:,:,112),Q(:,30),ZERO,G4(:,:,:,115))
  call loop_QV_A(G4(:,:,:,115),wf(:,0),G4(:,:,:,116))
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,31),ZERO,G5tensor(:,58))
  call loop_QV_A(G1(:,:,:,35),wf(:,-4),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,20),ZERO,G2(:,:,:,82))
  call loop_QV_A(G2(:,:,:,82),wf(:,-1),G2(:,:,:,83))
  call loop_Q_A(G2(:,:,:,83),Q(:,22),ZERO,G3(:,:,:,113))
  call loop_QV_A(G3(:,:,:,113),wf(:,-3),G3(:,:,:,114))
  call loop_Q_A(G3(:,:,:,114),Q(:,30),ZERO,G4(:,:,:,117))
  call loop_QV_A(G4(:,:,:,117),wf(:,0),G4(:,:,:,118))
  call check_last_Q_A(l_switch,G4(:,:,:,118),Q(:,31),ZERO,G5tensor(:,59))
  call loop_QV_A(G1(:,:,:,35),wf(:,-3),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,12),ZERO,G2(:,:,:,84))
  call loop_QV_A(G2(:,:,:,84),wf(:,-1),G2(:,:,:,85))
  call loop_Q_A(G2(:,:,:,85),Q(:,14),ZERO,G3(:,:,:,115))
  call loop_QV_A(G3(:,:,:,115),wf(:,-4),G3(:,:,:,116))
  call loop_Q_A(G3(:,:,:,116),Q(:,30),ZERO,G4(:,:,:,119))
  call loop_QV_A(G4(:,:,:,119),wf(:,0),G4(:,:,:,120))
  call check_last_Q_A(l_switch,G4(:,:,:,120),Q(:,31),ZERO,G5tensor(:,60))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,11),gZu)
  call loop_Q_A(G0(:,:,:,11),Q(:,4),MT,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,-1),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,6),MT,G2(:,:,:,86))
  call loop_QV_A(G2(:,:,:,86),wf(:,-4),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,22),MT,G3(:,:,:,117))
  call loop_QV_A(G3(:,:,:,117),wf(:,-3),G3(:,:,:,118))
  call loop_Q_A(G3(:,:,:,118),Q(:,30),MT,G4(:,:,:,121))
  call loop_QV_A(G4(:,:,:,121),wf(:,0),G4(:,:,:,122))
  call check_last_Q_A(l_switch,G4(:,:,:,122),Q(:,31),MT,G5tensor(:,61))
  call loop_QV_A(G2(:,:,:,86),wf(:,-3),G2(:,:,:,88))
  call loop_Q_A(G2(:,:,:,88),Q(:,14),MT,G3(:,:,:,119))
  call loop_QV_A(G3(:,:,:,119),wf(:,-4),G3(:,:,:,120))
  call loop_Q_A(G3(:,:,:,120),Q(:,30),MT,G4(:,:,:,123))
  call loop_QV_A(G4(:,:,:,123),wf(:,0),G4(:,:,:,124))
  call check_last_Q_A(l_switch,G4(:,:,:,124),Q(:,31),MT,G5tensor(:,62))
  call loop_QV_A(G1(:,:,:,39),wf(:,-4),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,20),MT,G2(:,:,:,89))
  call loop_QV_A(G2(:,:,:,89),wf(:,-1),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,22),MT,G3(:,:,:,121))
  call loop_QV_A(G3(:,:,:,121),wf(:,-3),G3(:,:,:,122))
  call loop_Q_A(G3(:,:,:,122),Q(:,30),MT,G4(:,:,:,125))
  call loop_QV_A(G4(:,:,:,125),wf(:,0),G4(:,:,:,126))
  call check_last_Q_A(l_switch,G4(:,:,:,126),Q(:,31),MT,G5tensor(:,63))
  call loop_QV_A(G1(:,:,:,39),wf(:,-3),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,12),MT,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,-1),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,14),MT,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,-4),G3(:,:,:,124))
  call loop_Q_A(G3(:,:,:,124),Q(:,30),MT,G4(:,:,:,127))
  call loop_QV_A(G4(:,:,:,127),wf(:,0),G4(:,:,:,128))
  call check_last_Q_A(l_switch,G4(:,:,:,128),Q(:,31),MT,G5tensor(:,64))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,12),gZd)
  call loop_A_Q(G0(:,:,:,12),Q(:,4),ZERO,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-1),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,6),ZERO,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-4),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,22),ZERO,G3(:,:,:,125))
  call loop_AV_Q(G3(:,:,:,125),wf(:,-3),G3(:,:,:,126))
  call loop_A_Q(G3(:,:,:,126),Q(:,30),ZERO,G4(:,:,:,129))
  call loop_AV_Q(G4(:,:,:,129),wf(:,0),G4(:,:,:,130))
  call check_last_A_Q(l_switch,G4(:,:,:,130),Q(:,31),ZERO,G5tensor(:,65))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-3),G2(:,:,:,95))
  call loop_A_Q(G2(:,:,:,95),Q(:,14),ZERO,G3(:,:,:,127))
  call loop_AV_Q(G3(:,:,:,127),wf(:,-4),G3(:,:,:,128))
  call loop_A_Q(G3(:,:,:,128),Q(:,30),ZERO,G4(:,:,:,131))
  call loop_AV_Q(G4(:,:,:,131),wf(:,0),G4(:,:,:,132))
  call check_last_A_Q(l_switch,G4(:,:,:,132),Q(:,31),ZERO,G5tensor(:,66))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-4),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,20),ZERO,G2(:,:,:,96))
  call loop_AV_Q(G2(:,:,:,96),wf(:,-1),G2(:,:,:,97))
  call loop_A_Q(G2(:,:,:,97),Q(:,22),ZERO,G3(:,:,:,129))
  call loop_AV_Q(G3(:,:,:,129),wf(:,-3),G3(:,:,:,130))
  call loop_A_Q(G3(:,:,:,130),Q(:,30),ZERO,G4(:,:,:,133))
  call loop_AV_Q(G4(:,:,:,133),wf(:,0),G4(:,:,:,134))
  call check_last_A_Q(l_switch,G4(:,:,:,134),Q(:,31),ZERO,G5tensor(:,67))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-3),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,12),ZERO,G2(:,:,:,98))
  call loop_AV_Q(G2(:,:,:,98),wf(:,-1),G2(:,:,:,99))
  call loop_A_Q(G2(:,:,:,99),Q(:,14),ZERO,G3(:,:,:,131))
  call loop_AV_Q(G3(:,:,:,131),wf(:,-4),G3(:,:,:,132))
  call loop_A_Q(G3(:,:,:,132),Q(:,30),ZERO,G4(:,:,:,135))
  call loop_AV_Q(G4(:,:,:,135),wf(:,0),G4(:,:,:,136))
  call check_last_A_Q(l_switch,G4(:,:,:,136),Q(:,31),ZERO,G5tensor(:,68))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,13),gZd)
  call loop_A_Q(G0(:,:,:,13),Q(:,4),MB,G1(:,:,:,47))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-1),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,6),MB,G2(:,:,:,100))
  call loop_AV_Q(G2(:,:,:,100),wf(:,-4),G2(:,:,:,101))
  call loop_A_Q(G2(:,:,:,101),Q(:,22),MB,G3(:,:,:,133))
  call loop_AV_Q(G3(:,:,:,133),wf(:,-3),G3(:,:,:,134))
  call loop_A_Q(G3(:,:,:,134),Q(:,30),MB,G4(:,:,:,137))
  call loop_AV_Q(G4(:,:,:,137),wf(:,0),G4(:,:,:,138))
  call check_last_A_Q(l_switch,G4(:,:,:,138),Q(:,31),MB,G5tensor(:,69))
  call loop_AV_Q(G2(:,:,:,100),wf(:,-3),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,14),MB,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,-4),G3(:,:,:,136))
  call loop_A_Q(G3(:,:,:,136),Q(:,30),MB,G4(:,:,:,139))
  call loop_AV_Q(G4(:,:,:,139),wf(:,0),G4(:,:,:,140))
  call check_last_A_Q(l_switch,G4(:,:,:,140),Q(:,31),MB,G5tensor(:,70))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-4),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,20),MB,G2(:,:,:,103))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-1),G2(:,:,:,104))
  call loop_A_Q(G2(:,:,:,104),Q(:,22),MB,G3(:,:,:,137))
  call loop_AV_Q(G3(:,:,:,137),wf(:,-3),G3(:,:,:,138))
  call loop_A_Q(G3(:,:,:,138),Q(:,30),MB,G4(:,:,:,141))
  call loop_AV_Q(G4(:,:,:,141),wf(:,0),G4(:,:,:,142))
  call check_last_A_Q(l_switch,G4(:,:,:,142),Q(:,31),MB,G5tensor(:,71))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-3),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,12),MB,G2(:,:,:,105))
  call loop_AV_Q(G2(:,:,:,105),wf(:,-1),G2(:,:,:,106))
  call loop_A_Q(G2(:,:,:,106),Q(:,14),MB,G3(:,:,:,139))
  call loop_AV_Q(G3(:,:,:,139),wf(:,-4),G3(:,:,:,140))
  call loop_A_Q(G3(:,:,:,140),Q(:,30),MB,G4(:,:,:,143))
  call loop_AV_Q(G4(:,:,:,143),wf(:,0),G4(:,:,:,144))
  call check_last_A_Q(l_switch,G4(:,:,:,144),Q(:,31),MB,G5tensor(:,72))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,14),gZd)
  call loop_Q_A(G0(:,:,:,14),Q(:,4),ZERO,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,-1),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,6),ZERO,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,-4),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,22),ZERO,G3(:,:,:,141))
  call loop_QV_A(G3(:,:,:,141),wf(:,-3),G3(:,:,:,142))
  call loop_Q_A(G3(:,:,:,142),Q(:,30),ZERO,G4(:,:,:,145))
  call loop_QV_A(G4(:,:,:,145),wf(:,0),G4(:,:,:,146))
  call check_last_Q_A(l_switch,G4(:,:,:,146),Q(:,31),ZERO,G5tensor(:,73))
  call loop_QV_A(G2(:,:,:,107),wf(:,-3),G2(:,:,:,109))
  call loop_Q_A(G2(:,:,:,109),Q(:,14),ZERO,G3(:,:,:,143))
  call loop_QV_A(G3(:,:,:,143),wf(:,-4),G3(:,:,:,144))
  call loop_Q_A(G3(:,:,:,144),Q(:,30),ZERO,G4(:,:,:,147))
  call loop_QV_A(G4(:,:,:,147),wf(:,0),G4(:,:,:,148))
  call check_last_Q_A(l_switch,G4(:,:,:,148),Q(:,31),ZERO,G5tensor(:,74))
  call loop_QV_A(G1(:,:,:,51),wf(:,-4),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,20),ZERO,G2(:,:,:,110))
  call loop_QV_A(G2(:,:,:,110),wf(:,-1),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,22),ZERO,G3(:,:,:,145))
  call loop_QV_A(G3(:,:,:,145),wf(:,-3),G3(:,:,:,146))
  call loop_Q_A(G3(:,:,:,146),Q(:,30),ZERO,G4(:,:,:,149))
  call loop_QV_A(G4(:,:,:,149),wf(:,0),G4(:,:,:,150))
  call check_last_Q_A(l_switch,G4(:,:,:,150),Q(:,31),ZERO,G5tensor(:,75))
  call loop_QV_A(G1(:,:,:,51),wf(:,-3),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,12),ZERO,G2(:,:,:,112))
  call loop_QV_A(G2(:,:,:,112),wf(:,-1),G2(:,:,:,113))
  call loop_Q_A(G2(:,:,:,113),Q(:,14),ZERO,G3(:,:,:,147))
  call loop_QV_A(G3(:,:,:,147),wf(:,-4),G3(:,:,:,148))
  call loop_Q_A(G3(:,:,:,148),Q(:,30),ZERO,G4(:,:,:,151))
  call loop_QV_A(G4(:,:,:,151),wf(:,0),G4(:,:,:,152))
  call check_last_Q_A(l_switch,G4(:,:,:,152),Q(:,31),ZERO,G5tensor(:,76))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,15),gZd)
  call loop_Q_A(G0(:,:,:,15),Q(:,4),MB,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,-1),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,6),MB,G2(:,:,:,114))
  call loop_QV_A(G2(:,:,:,114),wf(:,-4),G2(:,:,:,115))
  call loop_Q_A(G2(:,:,:,115),Q(:,22),MB,G3(:,:,:,149))
  call loop_QV_A(G3(:,:,:,149),wf(:,-3),G3(:,:,:,150))
  call loop_Q_A(G3(:,:,:,150),Q(:,30),MB,G4(:,:,:,153))
  call loop_QV_A(G4(:,:,:,153),wf(:,0),G4(:,:,:,154))
  call check_last_Q_A(l_switch,G4(:,:,:,154),Q(:,31),MB,G5tensor(:,77))
  call loop_QV_A(G2(:,:,:,114),wf(:,-3),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,14),MB,G3(:,:,:,151))
  call loop_QV_A(G3(:,:,:,151),wf(:,-4),G3(:,:,:,152))
  call loop_Q_A(G3(:,:,:,152),Q(:,30),MB,G4(:,:,:,155))
  call loop_QV_A(G4(:,:,:,155),wf(:,0),G4(:,:,:,156))
  call check_last_Q_A(l_switch,G4(:,:,:,156),Q(:,31),MB,G5tensor(:,78))
  call loop_QV_A(G1(:,:,:,55),wf(:,-4),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,20),MB,G2(:,:,:,117))
  call loop_QV_A(G2(:,:,:,117),wf(:,-1),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,22),MB,G3(:,:,:,153))
  call loop_QV_A(G3(:,:,:,153),wf(:,-3),G3(:,:,:,154))
  call loop_Q_A(G3(:,:,:,154),Q(:,30),MB,G4(:,:,:,157))
  call loop_QV_A(G4(:,:,:,157),wf(:,0),G4(:,:,:,158))
  call check_last_Q_A(l_switch,G4(:,:,:,158),Q(:,31),MB,G5tensor(:,79))
  call loop_QV_A(G1(:,:,:,55),wf(:,-3),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,12),MB,G2(:,:,:,119))
  call loop_QV_A(G2(:,:,:,119),wf(:,-1),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,14),MB,G3(:,:,:,155))
  call loop_QV_A(G3(:,:,:,155),wf(:,-4),G3(:,:,:,156))
  call loop_Q_A(G3(:,:,:,156),Q(:,30),MB,G4(:,:,:,159))
  call loop_QV_A(G4(:,:,:,159),wf(:,0),G4(:,:,:,160))
  call check_last_Q_A(l_switch,G4(:,:,:,160),Q(:,31),MB,G5tensor(:,80))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,8),ZERO,G1(:,:,:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-1),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,10),ZERO,G2(:,:,:,121))
  call loop_AZ_Q(G2(:,:,:,121),wf(:,-2),G2(:,:,:,122),gZu)
  call loop_A_Q(G2(:,:,:,122),Q(:,14),ZERO,G3(:,:,:,157))
  call loop_AV_Q(G3(:,:,:,157),wf(:,-4),G3(:,:,:,158))
  call loop_A_Q(G3(:,:,:,158),Q(:,30),ZERO,G4(:,:,:,161))
  call loop_AV_Q(G4(:,:,:,161),wf(:,0),G4(:,:,:,162))
  call check_last_A_Q(l_switch,G4(:,:,:,162),Q(:,31),ZERO,G5tensor(:,81))
  call loop_AZ_Q(G2(:,:,:,121),wf(:,-2),G2(:,:,:,123),gZd)
  call loop_A_Q(G2(:,:,:,123),Q(:,14),ZERO,G3(:,:,:,159))
  call loop_AV_Q(G3(:,:,:,159),wf(:,-4),G3(:,:,:,160))
  call loop_A_Q(G3(:,:,:,160),Q(:,30),ZERO,G4(:,:,:,163))
  call loop_AV_Q(G4(:,:,:,163),wf(:,0),G4(:,:,:,164))
  call check_last_A_Q(l_switch,G4(:,:,:,164),Q(:,31),ZERO,G5tensor(:,82))
  call loop_AZ_Q(G1(:,:,:,59),wf(:,-2),G1(:,:,:,61),gZu)
  call loop_A_Q(G1(:,:,:,61),Q(:,12),ZERO,G2(:,:,:,124))
  call loop_AV_Q(G2(:,:,:,124),wf(:,-1),G2(:,:,:,125))
  call loop_A_Q(G2(:,:,:,125),Q(:,14),ZERO,G3(:,:,:,161))
  call loop_AV_Q(G3(:,:,:,161),wf(:,-4),G3(:,:,:,162))
  call loop_A_Q(G3(:,:,:,162),Q(:,30),ZERO,G4(:,:,:,165))
  call loop_AV_Q(G4(:,:,:,165),wf(:,0),G4(:,:,:,166))
  call check_last_A_Q(l_switch,G4(:,:,:,166),Q(:,31),ZERO,G5tensor(:,83))
  call loop_AZ_Q(G1(:,:,:,59),wf(:,-2),G1(:,:,:,62),gZd)
  call loop_A_Q(G1(:,:,:,62),Q(:,12),ZERO,G2(:,:,:,126))
  call loop_AV_Q(G2(:,:,:,126),wf(:,-1),G2(:,:,:,127))
  call loop_A_Q(G2(:,:,:,127),Q(:,14),ZERO,G3(:,:,:,163))
  call loop_AV_Q(G3(:,:,:,163),wf(:,-4),G3(:,:,:,164))
  call loop_A_Q(G3(:,:,:,164),Q(:,30),ZERO,G4(:,:,:,167))
  call loop_AV_Q(G4(:,:,:,167),wf(:,0),G4(:,:,:,168))
  call check_last_A_Q(l_switch,G4(:,:,:,168),Q(:,31),ZERO,G5tensor(:,84))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,8),MT,G1(:,:,:,63))
  call loop_AV_Q(G1(:,:,:,63),wf(:,-1),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,10),MT,G2(:,:,:,128))
  call loop_AZ_Q(G2(:,:,:,128),wf(:,-2),G2(:,:,:,129),gZu)
  call loop_A_Q(G2(:,:,:,129),Q(:,14),MT,G3(:,:,:,165))
  call loop_AV_Q(G3(:,:,:,165),wf(:,-4),G3(:,:,:,166))
  call loop_A_Q(G3(:,:,:,166),Q(:,30),MT,G4(:,:,:,169))
  call loop_AV_Q(G4(:,:,:,169),wf(:,0),G4(:,:,:,170))
  call check_last_A_Q(l_switch,G4(:,:,:,170),Q(:,31),MT,G5tensor(:,85))
  call loop_AZ_Q(G1(:,:,:,63),wf(:,-2),G1(:,:,:,65),gZu)
  call loop_A_Q(G1(:,:,:,65),Q(:,12),MT,G2(:,:,:,130))
  call loop_AV_Q(G2(:,:,:,130),wf(:,-1),G2(:,:,:,131))
  call loop_A_Q(G2(:,:,:,131),Q(:,14),MT,G3(:,:,:,167))
  call loop_AV_Q(G3(:,:,:,167),wf(:,-4),G3(:,:,:,168))
  call loop_A_Q(G3(:,:,:,168),Q(:,30),MT,G4(:,:,:,171))
  call loop_AV_Q(G4(:,:,:,171),wf(:,0),G4(:,:,:,172))
  call check_last_A_Q(l_switch,G4(:,:,:,172),Q(:,31),MT,G5tensor(:,86))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,8),ZERO,G1(:,:,:,66))
  call loop_QV_A(G1(:,:,:,66),wf(:,-1),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,10),ZERO,G2(:,:,:,132))
  call loop_QZ_A(G2(:,:,:,132),wf(:,-2),G2(:,:,:,133),gZu)
  call loop_Q_A(G2(:,:,:,133),Q(:,14),ZERO,G3(:,:,:,169))
  call loop_QV_A(G3(:,:,:,169),wf(:,-4),G3(:,:,:,170))
  call loop_Q_A(G3(:,:,:,170),Q(:,30),ZERO,G4(:,:,:,173))
  call loop_QV_A(G4(:,:,:,173),wf(:,0),G4(:,:,:,174))
  call check_last_Q_A(l_switch,G4(:,:,:,174),Q(:,31),ZERO,G5tensor(:,87))
  call loop_QZ_A(G2(:,:,:,132),wf(:,-2),G2(:,:,:,134),gZd)
  call loop_Q_A(G2(:,:,:,134),Q(:,14),ZERO,G3(:,:,:,171))
  call loop_QV_A(G3(:,:,:,171),wf(:,-4),G3(:,:,:,172))
  call loop_Q_A(G3(:,:,:,172),Q(:,30),ZERO,G4(:,:,:,175))
  call loop_QV_A(G4(:,:,:,175),wf(:,0),G4(:,:,:,176))
  call check_last_Q_A(l_switch,G4(:,:,:,176),Q(:,31),ZERO,G5tensor(:,88))
  call loop_QZ_A(G1(:,:,:,66),wf(:,-2),G1(:,:,:,68),gZu)
  call loop_Q_A(G1(:,:,:,68),Q(:,12),ZERO,G2(:,:,:,135))
  call loop_QV_A(G2(:,:,:,135),wf(:,-1),G2(:,:,:,136))
  call loop_Q_A(G2(:,:,:,136),Q(:,14),ZERO,G3(:,:,:,173))
  call loop_QV_A(G3(:,:,:,173),wf(:,-4),G3(:,:,:,174))
  call loop_Q_A(G3(:,:,:,174),Q(:,30),ZERO,G4(:,:,:,177))
  call loop_QV_A(G4(:,:,:,177),wf(:,0),G4(:,:,:,178))
  call check_last_Q_A(l_switch,G4(:,:,:,178),Q(:,31),ZERO,G5tensor(:,89))
  call loop_QZ_A(G1(:,:,:,66),wf(:,-2),G1(:,:,:,69),gZd)
  call loop_Q_A(G1(:,:,:,69),Q(:,12),ZERO,G2(:,:,:,137))
  call loop_QV_A(G2(:,:,:,137),wf(:,-1),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,14),ZERO,G3(:,:,:,175))
  call loop_QV_A(G3(:,:,:,175),wf(:,-4),G3(:,:,:,176))
  call loop_Q_A(G3(:,:,:,176),Q(:,30),ZERO,G4(:,:,:,179))
  call loop_QV_A(G4(:,:,:,179),wf(:,0),G4(:,:,:,180))
  call check_last_Q_A(l_switch,G4(:,:,:,180),Q(:,31),ZERO,G5tensor(:,90))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,8),MT,G1(:,:,:,70))
  call loop_QV_A(G1(:,:,:,70),wf(:,-1),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,10),MT,G2(:,:,:,139))
  call loop_QZ_A(G2(:,:,:,139),wf(:,-2),G2(:,:,:,140),gZu)
  call loop_Q_A(G2(:,:,:,140),Q(:,14),MT,G3(:,:,:,177))
  call loop_QV_A(G3(:,:,:,177),wf(:,-4),G3(:,:,:,178))
  call loop_Q_A(G3(:,:,:,178),Q(:,30),MT,G4(:,:,:,181))
  call loop_QV_A(G4(:,:,:,181),wf(:,0),G4(:,:,:,182))
  call check_last_Q_A(l_switch,G4(:,:,:,182),Q(:,31),MT,G5tensor(:,91))
  call loop_QZ_A(G1(:,:,:,70),wf(:,-2),G1(:,:,:,72),gZu)
  call loop_Q_A(G1(:,:,:,72),Q(:,12),MT,G2(:,:,:,141))
  call loop_QV_A(G2(:,:,:,141),wf(:,-1),G2(:,:,:,142))
  call loop_Q_A(G2(:,:,:,142),Q(:,14),MT,G3(:,:,:,179))
  call loop_QV_A(G3(:,:,:,179),wf(:,-4),G3(:,:,:,180))
  call loop_Q_A(G3(:,:,:,180),Q(:,30),MT,G4(:,:,:,183))
  call loop_QV_A(G4(:,:,:,183),wf(:,0),G4(:,:,:,184))
  call check_last_Q_A(l_switch,G4(:,:,:,184),Q(:,31),MT,G5tensor(:,92))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,8),MB,G1(:,:,:,73))
  call loop_AV_Q(G1(:,:,:,73),wf(:,-1),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,10),MB,G2(:,:,:,143))
  call loop_AZ_Q(G2(:,:,:,143),wf(:,-2),G2(:,:,:,144),gZd)
  call loop_A_Q(G2(:,:,:,144),Q(:,14),MB,G3(:,:,:,181))
  call loop_AV_Q(G3(:,:,:,181),wf(:,-4),G3(:,:,:,182))
  call loop_A_Q(G3(:,:,:,182),Q(:,30),MB,G4(:,:,:,185))
  call loop_AV_Q(G4(:,:,:,185),wf(:,0),G4(:,:,:,186))
  call check_last_A_Q(l_switch,G4(:,:,:,186),Q(:,31),MB,G5tensor(:,93))
  call loop_AZ_Q(G1(:,:,:,73),wf(:,-2),G1(:,:,:,75),gZd)
  call loop_A_Q(G1(:,:,:,75),Q(:,12),MB,G2(:,:,:,145))
  call loop_AV_Q(G2(:,:,:,145),wf(:,-1),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,14),MB,G3(:,:,:,183))
  call loop_AV_Q(G3(:,:,:,183),wf(:,-4),G3(:,:,:,184))
  call loop_A_Q(G3(:,:,:,184),Q(:,30),MB,G4(:,:,:,187))
  call loop_AV_Q(G4(:,:,:,187),wf(:,0),G4(:,:,:,188))
  call check_last_A_Q(l_switch,G4(:,:,:,188),Q(:,31),MB,G5tensor(:,94))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,8),MB,G1(:,:,:,76))
  call loop_QV_A(G1(:,:,:,76),wf(:,-1),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,10),MB,G2(:,:,:,147))
  call loop_QZ_A(G2(:,:,:,147),wf(:,-2),G2(:,:,:,148),gZd)
  call loop_Q_A(G2(:,:,:,148),Q(:,14),MB,G3(:,:,:,185))
  call loop_QV_A(G3(:,:,:,185),wf(:,-4),G3(:,:,:,186))
  call loop_Q_A(G3(:,:,:,186),Q(:,30),MB,G4(:,:,:,189))
  call loop_QV_A(G4(:,:,:,189),wf(:,0),G4(:,:,:,190))
  call check_last_Q_A(l_switch,G4(:,:,:,190),Q(:,31),MB,G5tensor(:,95))
  call loop_QZ_A(G1(:,:,:,76),wf(:,-2),G1(:,:,:,78),gZd)
  call loop_Q_A(G1(:,:,:,78),Q(:,12),MB,G2(:,:,:,149))
  call loop_QV_A(G2(:,:,:,149),wf(:,-1),G2(:,:,:,150))
  call loop_Q_A(G2(:,:,:,150),Q(:,14),MB,G3(:,:,:,187))
  call loop_QV_A(G3(:,:,:,187),wf(:,-4),G3(:,:,:,188))
  call loop_Q_A(G3(:,:,:,188),Q(:,30),MB,G4(:,:,:,191))
  call loop_QV_A(G4(:,:,:,191),wf(:,0),G4(:,:,:,192))
  call check_last_Q_A(l_switch,G4(:,:,:,192),Q(:,31),MB,G5tensor(:,96))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_4,masses2_2,G5tensor(:,13),T5sum(1:126,2))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,19),T5sum(1:126,1))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_4,masses2_2,G5tensor(:,31),T5sum(1:126,2))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,2),T5sum(1:126,1))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_4,masses2_1,G5tensor(:,37),T5sum(1:126,3))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_4,masses2_3,G5tensor(:,20),T5sum(1:126,1))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_4,masses2_1,G5tensor(:,43),T5sum(1:126,3))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,5),T5sum(1:126,4))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_6,masses2_2,G5tensor(:,15),T5sum(1:126,5))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,23),T5sum(1:126,4))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_6,masses2_2,G5tensor(:,33),T5sum(1:126,5))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,6),T5sum(1:126,4))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_6,masses2_1,G5tensor(:,39),T5sum(1:126,6))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_6,masses2_3,G5tensor(:,24),T5sum(1:126,4))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_6,masses2_1,G5tensor(:,45),T5sum(1:126,6))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,9),T5sum(1:126,7))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_2,masses2_2,G5tensor(:,17),T5sum(1:126,8))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,27),T5sum(1:126,7))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_2,masses2_2,G5tensor(:,35),T5sum(1:126,8))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,11),T5sum(1:126,7))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_2,masses2_1,G5tensor(:,41),T5sum(1:126,9))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_2,masses2_3,G5tensor(:,29),T5sum(1:126,7))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_2,masses2_1,G5tensor(:,47),T5sum(1:126,9))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,7),T5sum(1:126,10))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_5,masses2_2,G5tensor(:,16),T5sum(1:126,11))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,25),T5sum(1:126,10))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_5,masses2_2,G5tensor(:,34),T5sum(1:126,11))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,8),T5sum(1:126,10))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_5,masses2_1,G5tensor(:,40),T5sum(1:126,12))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_5,masses2_3,G5tensor(:,26),T5sum(1:126,10))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_5,masses2_1,G5tensor(:,46),T5sum(1:126,12))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,10),T5sum(1:126,13))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_1,masses2_2,G5tensor(:,18),T5sum(1:126,14))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,28),T5sum(1:126,13))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_1,masses2_2,G5tensor(:,36),T5sum(1:126,14))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,12),T5sum(1:126,13))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_1,masses2_1,G5tensor(:,42),T5sum(1:126,15))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_1,masses2_3,G5tensor(:,30),T5sum(1:126,13))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_1,masses2_1,G5tensor(:,48),T5sum(1:126,15))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,3),T5sum(1:126,16))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_3,masses2_2,G5tensor(:,14),T5sum(1:126,17))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,21),T5sum(1:126,16))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_3,masses2_2,G5tensor(:,32),T5sum(1:126,17))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,4),T5sum(1:126,16))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_3,masses2_1,G5tensor(:,38),T5sum(1:126,18))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_3,masses2_3,G5tensor(:,22),T5sum(1:126,16))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_3,masses2_1,G5tensor(:,44),T5sum(1:126,18))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,49),T5sum(1:126,19))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_8,masses2_2,G5tensor(:,53),T5sum(1:126,20))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,57),T5sum(1:126,19))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_8,masses2_2,G5tensor(:,61),T5sum(1:126,20))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,65),T5sum(1:126,19))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_8,masses2_1,G5tensor(:,69),T5sum(1:126,21))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_8,masses2_3,G5tensor(:,73),T5sum(1:126,19))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_8,masses2_1,G5tensor(:,77),T5sum(1:126,21))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,51),T5sum(1:126,22))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,55),T5sum(1:126,23))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,59),T5sum(1:126,22))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,63),T5sum(1:126,23))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,67),T5sum(1:126,22))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_10,masses2_1,G5tensor(:,71),T5sum(1:126,24))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_10,masses2_3,G5tensor(:,75),T5sum(1:126,22))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_10,masses2_1,G5tensor(:,79),T5sum(1:126,24))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,50),T5sum(1:126,25))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_7,masses2_2,G5tensor(:,54),T5sum(1:126,26))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,58),T5sum(1:126,25))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_7,masses2_2,G5tensor(:,62),T5sum(1:126,26))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,66),T5sum(1:126,25))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_7,masses2_1,G5tensor(:,70),T5sum(1:126,27))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_7,masses2_3,G5tensor(:,74),T5sum(1:126,25))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_7,masses2_1,G5tensor(:,78),T5sum(1:126,27))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,52),T5sum(1:126,28))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_9,masses2_2,G5tensor(:,56),T5sum(1:126,29))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,60),T5sum(1:126,28))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_9,masses2_2,G5tensor(:,64),T5sum(1:126,29))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,68),T5sum(1:126,28))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_9,masses2_1,G5tensor(:,72),T5sum(1:126,30))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_9,masses2_3,G5tensor(:,76),T5sum(1:126,28))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_9,masses2_1,G5tensor(:,80),T5sum(1:126,30))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,81),T5sum(1:126,31))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,85),T5sum(1:126,32))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,87),T5sum(1:126,31))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,91),T5sum(1:126,32))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,82),T5sum(1:126,31))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_11,masses2_1,G5tensor(:,93),T5sum(1:126,33))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_11,masses2_3,G5tensor(:,88),T5sum(1:126,31))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_11,masses2_1,G5tensor(:,95),T5sum(1:126,33))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,83),T5sum(1:126,34))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,86),T5sum(1:126,35))
  M(1) = M(1) + (f(4)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,89),T5sum(1:126,34))
  M(1) = M(1) + (f(3)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,92),T5sum(1:126,35))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,84),T5sum(1:126,34))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_12,masses2_1,G5tensor(:,94),T5sum(1:126,36))
  M(1) = M(1) + (f(2)) * TI2_call(5,momenta_12,masses2_3,G5tensor(:,90),T5sum(1:126,34))
  M(1) = M(1) + (f(1)) * TI2_call(5,momenta_12,masses2_1,G5tensor(:,96),T5sum(1:126,36))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppvvv2_aazgg_1_/**/REALKIND
