
module ol_colourmatrix_ppvvv2_zwwxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(0,0), K2(0,1), KL(0,1), KL2(17,1), KL2ct(17,1), KL2ct2(17,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  KL2( 1,:) = [  2]
  KL2( 2,:) = [  0]
  KL2( 3,:) = [  0]
  KL2( 4,:) = [  0]
  KL2( 5,:) = [  0]
  KL2( 6,:) = [  0]
  KL2( 7,:) = [  0]
  KL2( 8,:) = [  0]
  KL2( 9,:) = [  0]
  KL2(10,:) = [  0]
  KL2(11,:) = [  6]
  KL2(12,:) = [  0]
  KL2(13,:) = [  0]
  KL2(14,:) = [  0]
  KL2(15,:) = [ -6]
  KL2(16,:) = [  6]
  KL2(17,:) = [  0]

  KL2ct( 1,:) = [  2]
  KL2ct( 2,:) = [  0]
  KL2ct( 3,:) = [  0]
  KL2ct( 4,:) = [  0]
  KL2ct( 5,:) = [  0]
  KL2ct( 6,:) = [  0]
  KL2ct( 7,:) = [  0]
  KL2ct( 8,:) = [  0]
  KL2ct( 9,:) = [  0]
  KL2ct(10,:) = [  0]
  KL2ct(11,:) = [  6]
  KL2ct(12,:) = [  0]
  KL2ct(13,:) = [  0]
  KL2ct(14,:) = [  0]
  KL2ct(15,:) = [ -6]
  KL2ct(16,:) = [  6]
  KL2ct(17,:) = [  0]

  KL2ct2( 1,:) = [  2]
  KL2ct2( 2,:) = [  0]
  KL2ct2( 3,:) = [  0]
  KL2ct2( 4,:) = [  0]
  KL2ct2( 5,:) = [  0]
  KL2ct2( 6,:) = [  0]
  KL2ct2( 7,:) = [  0]
  KL2ct2( 8,:) = [  0]
  KL2ct2( 9,:) = [  0]
  KL2ct2(10,:) = [  0]
  KL2ct2(11,:) = [  6]
  KL2ct2(12,:) = [  0]
  KL2ct2(13,:) = [  0]
  KL2ct2(14,:) = [  0]
  KL2ct2(15,:) = [ -6]
  KL2ct2(16,:) = [  6]
  KL2ct2(17,:) = [  0]


  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvv2_zwwxgg_1_/**/REALKIND



module ol_forced_parameters_ppvvv2_zwwxgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvv2_zwwxgg_1_/**/REALKIND

module ol_loop_ppvvv2_zwwxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(31), c(0)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-5+1:24)
  ! denominators
  complex(REALKIND), save :: den(24)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(0,108), Mct(1,108), Mcol_loop(1,108)
  ! zero helicity identifier
  logical,           save :: zerohel(108) = .true., zerohel_ct(108) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*countertermnorm*ctAZGG*eQED**3*gQCD**2
    f( 2) = (countertermnorm*ctZGG*cw**2*eQED**3*gQCD**2)/sw**2
    f( 3) = (countertermnorm*ctZGG*eQED**3*gQCD**2*lambdaHWW*lambdaHZZ*MW**2)/(cw**2*sw**2)
    f( 4) = (CI*countertermnorm*ctWWGG*cw*eQED**3*gQCD**2)/sw
    f( 5) = (CI*countertermnorm*ctZZGG*cw*eQED**3*gQCD**2)/sw
    f( 6) = (eQED**3*gQCD**2*integralnorm*SwF)/3._/**/REALKIND
    f( 7) = (2*eQED**3*gQCD**2*integralnorm*SwF)/3._/**/REALKIND
    f( 8) = (4*eQED**3*gQCD**2*integralnorm*SwF)/3._/**/REALKIND
    f( 9) = (cw*eQED**3*gQCD**2*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(10) = (cw*eQED**3*gQCD**2*integralnorm*SwF)/sw**3
    f(11) = (eQED**3*gQCD**2*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(12) = (eQED**3*gQCD**2*integralnorm*SwF)/sw**2
    f(13) = (cw**2*eQED**3*gQCD**2*integralnorm*SwF)/sw**2
    f(14) = (2*cw**2*eQED**3*gQCD**2*integralnorm*SwF)/sw**2
    f(15) = (eQED**3*gQCD**2*integralnorm*lambdaHWW*lambdaHZZ*MW**2*SwF)/(cw**2*sw**2)
    f(16) = (2*eQED**3*gQCD**2*integralnorm*lambdaHWW*lambdaHZZ*MW**2*SwF)/(cw**2*sw**2)
    f(17) = (cw*eQED**3*gQCD**2*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(18) = (2*cw*eQED**3*gQCD**2*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(19) = (cw*eQED**3*gQCD**2*integralnorm*SwF)/sw
    f(20) = (4*cw*eQED**3*gQCD**2*integralnorm*SwF)/(sw*3._/**/REALKIND)
    f(21) = (2*cw*eQED**3*gQCD**2*integralnorm*SwF)/sw
    f(22) = (CI*countertermnorm*ctHGG*cw*eQED**3*gQCD**2*lambdaHWW*MB*MW*YB)/(MQ2sum*sw**2)
    f(23) = (CI*countertermnorm*ctHGG*eQED**3*gQCD**2*lambdaHZZ*MB*MW*YB)/(cw*MQ2sum*sw**2)
    f(24) = (cw*eQED**3*gQCD**2*integralnorm*lambdaHWW*SwF*YB)/(sw**3*2._/**/REALKIND)
    f(25) = (eQED**3*gQCD**2*integralnorm*lambdaHZZ*SwF*YB)/(cw*sw**3*2._/**/REALKIND)
    f(26) = (eQED**3*gQCD**2*integralnorm*lambdaHWW*SwF*YB)/(sw**2*2._/**/REALKIND)
    f(27) = (CI*countertermnorm*ctHGG*cw*eQED**3*gQCD**2*lambdaHWW*MT*MW*YT)/(MQ2sum*sw**2)
    f(28) = (CI*countertermnorm*ctHGG*eQED**3*gQCD**2*lambdaHZZ*MT*MW*YT)/(cw*MQ2sum*sw**2)
    f(29) = (cw*eQED**3*gQCD**2*integralnorm*lambdaHWW*SwF*YT)/(sw**3*2._/**/REALKIND)
    f(30) = (eQED**3*gQCD**2*integralnorm*lambdaHZZ*SwF*YT)/(cw*sw**3*2._/**/REALKIND)
    f(31) = (eQED**3*gQCD**2*integralnorm*lambdaHWW*SwF*YT)/(sw**2*2._/**/REALKIND)


end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,5)
  integer,           intent(in)  :: H(5)
  integer,           intent(in), optional  :: POLSEL(5)
  complex(REALKIND), intent(out) :: M1(0), M2(1)
  complex(REALKIND) :: A(14)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_V(P(:,1), rMZ, H(1), wf(:,0), POLSEL(1))
    call pol_wf_V(P(:,2), rMW, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_V(P(:,3), rMW, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))

  else
    call pol_wf_V(P(:,1), rMZ, H(1), wf(:,0), 0)
    call pol_wf_V(P(:,2), rMW, H(2), wf(:,-1), 0)
    call pol_wf_V(P(:,3), rMW, H(3), wf(:,-2), 0)
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)

  end if

  ! internal WFs
  call vert_UV_W(wf(:,-1),Q(:,2),wf(:,0),Q(:,1),wf(:,1))
  call counter_VVG_G(wf(:,-3),wf(:,-4),wf(:,-2),wf(:,2))
  call prop_W_W(wf(:,1),Q(:,3),MW,1_intkind1,wf(:,3))
  call vert_UV_W(wf(:,0),Q(:,1),wf(:,-2),Q(:,4),wf(:,4))
  call counter_VVG_G(wf(:,-3),wf(:,-4),wf(:,-1),wf(:,5))
  call prop_W_W(wf(:,4),Q(:,5),MW,1_intkind1,wf(:,6))
  call vert_WWV_V(wf(:,-1),wf(:,-2),wf(:,0),wf(:,7))
  call counter_GG_V(wf(:,-3),Q(:,8),wf(:,-4),Q(:,16),wf(:,8))
  call prop_W_W(wf(:,7),Q(:,7),MZ,1_intkind1,wf(:,9))
  call vert_UV_W(wf(:,-2),Q(:,4),wf(:,-1),Q(:,2),wf(:,10))
  call counter_VVG_G(wf(:,-3),wf(:,-4),wf(:,0),wf(:,11))
  call prop_W_W(wf(:,10),Q(:,6),MZ,1_intkind1,wf(:,12))
  call counter_GG_S(wf(:,-3),wf(:,-4),wf(:,13))
  call vert_VV_S(wf(:,3),wf(:,-2),wf(:,14))
  call prop_W_W(wf(:,8),Q(:,24),MZ,1_intkind1,wf(:,15))
  call vert_UV_W(wf(:,-2),Q(:,4),wf(:,3),Q(:,3),wf(:,16))
  call vert_VV_S(wf(:,-1),wf(:,6),wf(:,17))
  call vert_UV_W(wf(:,6),Q(:,5),wf(:,-1),Q(:,2),wf(:,18))
  call vert_VV_S(wf(:,-1),wf(:,-2),wf(:,19))
  call vert_SV_V(wf(:,19),wf(:,0),wf(:,20))
  call vert_VV_S(wf(:,0),wf(:,12),wf(:,21))
  call prop_W_W(wf(:,16),Q(:,7),MZ,1_intkind1,wf(:,22))
  call prop_W_W(wf(:,18),Q(:,7),MZ,1_intkind1,wf(:,23))
  call prop_W_W(wf(:,20),Q(:,7),MZ,1_intkind1,wf(:,24))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MW2)
  den(2) = 1 / (Q(5,5) - MW2)
  den(3) = 1 / (Q(5,7) - MZ2)
  den(4) = 1 / (Q(5,6))
  den(5) = 1 / (Q(5,6) - MZ2)
  den(6) = 1 / (Q(5,24) - MH2)
  den(8) = 1 / (Q(5,24) - MZ2)
  den(12) = 1 / (Q(5,6) - MH2)
  den(15) = 1 / (Q(5,7))
  den(16) = 1 / (Q(5,7) - MH2)

  ! denominators
  den(7) = den(1)*den(6)
  den(9) = den(1)*den(8)
  den(10) = den(2)*den(6)
  den(11) = den(2)*den(8)
  den(13) = den(8)*den(12)
  den(14) = den(5)*den(6)
  den(17) = den(1)*den(16)
  den(18) = den(1)*den(15)
  den(19) = den(1)*den(3)
  den(20) = den(2)*den(16)
  den(21) = den(2)*den(15)
  den(22) = den(2)*den(3)
  den(23) = den(3)*den(12)
  den(24) = den(5)*den(16)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(14)


  A(1) = cont_VV(wf(:,2),wf(:,3)) * den(1)
  A(2) = cont_VV(wf(:,5),wf(:,6)) * den(2)
  A(3) = cont_VV(wf(:,8),wf(:,9)) * den(3)
  A(4) = cont_VV(wf(:,10),wf(:,11)) * den(4)
  A(5) = cont_VV(wf(:,11),wf(:,12)) * den(5)
  A(6) = cont_SS(wf(:,13),wf(:,14)) * den(7)
  A(7) = cont_SS(wf(:,13),wf(:,14)) * den(7)
  A(8) = cont_VV(wf(:,15),wf(:,16)) * den(9)
  A(9) = cont_SS(wf(:,13),wf(:,17)) * den(10)
  A(10) = cont_SS(wf(:,13),wf(:,17)) * den(10)
  A(11) = cont_VV(wf(:,15),wf(:,18)) * den(11)
  A(12) = cont_VV(wf(:,15),wf(:,20)) * den(13)
  A(13) = cont_SS(wf(:,13),wf(:,21)) * den(14)
  A(14) = cont_SS(wf(:,13),wf(:,21)) * den(14)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(14)
  complex(REALKIND), intent(out) :: M1(0), M2(1)


  M2(1) = 2*A(4)*f(1)+2*(-A(3)+A(8)+A(11))*f(2)-2*A(12)*f(3)+2*(-A(1)-A(2))*f(4)-2*A(5)*f(5)+2*(A(7)+A(10))*f(22)+2*A(14)*f(23) &
       +2*(A(6)+A(9))*f(27)+2*A(13)*f(28)

end subroutine colourvectors

end module ol_loop_ppvvv2_zwwxgg_1_/**/REALKIND
