
module ol_vamp_1_ppvvj_ew_bbxwwxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj_ew_bbxwwxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj_ew_bbxwwxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvj_ew_bbxwwxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvj_ew_bbxwwxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvj_ew_bbxwwxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvj_ew_bbxwwxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMT,nMW,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,1),heltab2x72(:,:,1))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(1),n2h36(1))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMB,nMT,nMW,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,2),heltab2x72(:,:,2))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(2),n2h36(2))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(3),h0tab(:,3),[16,2,1,4,8],[nMT,nMW,nMT,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,3),heltab2x72(:,:,3))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(3),n2h36(3))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(4),h0tab(:,4),[16,2,1,4,8],[nMT,nMW,nMT,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,4),heltab2x72(:,:,4))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(4),n2h36(4))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(5),h0tab(:,5),[16,4,2,1,8],[nMT,nMB,nMH,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,5),heltab2x72(:,:,5))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(5),n2h36(5))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(6),h0tab(:,6),[16,4,2,1,8],[nMT,nMB,nMZ,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,6),heltab2x72(:,:,6))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(6),n2h36(6))
  Gcoeff(:)%j = (c(65)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(7),h0tab(:,7),[16,4,2,1,8],[nMT,nMB,0,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,7),heltab2x72(:,:,7))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(7),n2h36(7))
  Gcoeff(:)%j = (c(71)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(8),h0tab(:,8),[16,4,2,1,8],[nMT,nMB,nMZ,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,8),heltab2x72(:,:,8))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(8),n2h36(8))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[nMT,nMB,0,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,9),heltab2x72(:,:,9))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(9),n2h36(9))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(10),h0tab(:,10),[16,2,1,8,4],[nMB,nMH,nMB,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,10),heltab2x72(:,:,10))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(10),n2h36(10))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(11),h0tab(:,11),[16,2,1,8,4],[nMB,nMZ,nMB,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,11),heltab2x72(:,:,11))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(11),n2h36(11))
  Gcoeff(:)%j = (c(65)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(12),h0tab(:,12),[16,2,1,8,4],[nMB,0,nMB,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,12),heltab2x72(:,:,12))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(12),n2h36(12))
  Gcoeff(:)%j = (c(71)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(13),h0tab(:,13),[16,2,1,8,4],[nMB,nMZ,nMB,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,13),heltab2x72(:,:,13))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(13),n2h36(13))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(14),h0tab(:,14),[16,2,1,8,4],[nMB,0,nMB,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,14),heltab2x72(:,:,14))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(14),n2h36(14))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(15),h0tab(:,15),[16,1,2,4,8],[nMB,nMH,nMB,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,15),heltab2x72(:,:,15))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(15),n2h36(15))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(16),h0tab(:,16),[16,1,2,4,8],[nMB,nMZ,nMB,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,16),heltab2x72(:,:,16))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(16),n2h36(16))
  Gcoeff(:)%j = (c(65)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(17),h0tab(:,17),[16,1,2,4,8],[nMB,0,nMB,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,17),heltab2x72(:,:,17))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(17),n2h36(17))
  Gcoeff(:)%j = (c(71)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(18),h0tab(:,18),[16,1,2,4,8],[nMB,nMZ,nMB,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,18),heltab2x72(:,:,18))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(18),n2h36(18))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(19),h0tab(:,19),[16,1,2,4,8],[nMB,0,nMB,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,19),heltab2x72(:,:,19))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(19),n2h36(19))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(20),h0tab(:,20),[16,1,2,8,4],[nMT,nMW,nMT,nMB,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,20),heltab2x72(:,:,20))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(20),n2h36(20))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(21),h0tab(:,21),[16,1,2,8,4],[nMT,nMW,nMT,nMB,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,21),heltab2x72(:,:,21))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(21),n2h36(21))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(22),h0tab(:,22),[16,2,4,1,8],[nMT,nMW,nMH,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,22),heltab2x72(:,:,22))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(22),n2h36(22))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(23),h0tab(:,23),[16,2,4,1,8],[nMT,nMW,nMZ,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,23),heltab2x72(:,:,23))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(23),n2h36(23))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(24),h0tab(:,24),[16,2,4,1,8],[nMT,nMW,nMH,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,24),heltab2x72(:,:,24))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(24),n2h36(24))
  Gcoeff(:)%j = (c(68)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(25),h0tab(:,25),[16,2,4,1,8],[nMT,nMW,0,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,25),heltab2x72(:,:,25))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(25),n2h36(25))
  Gcoeff(:)%j = (c(97)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(26),h0tab(:,26),[16,2,4,1,8],[nMT,nMW,nMZ,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,26),heltab2x72(:,:,26))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(26),n2h36(26))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(27),h0tab(:,27),[16,2,4,1,8],[nMT,nMW,0,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,27),heltab2x72(:,:,27))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(27),n2h36(27))
  Gcoeff(:)%j = (c(53)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(28),h0tab(:,28),[16,2,4,1,8],[nMT,nMW,nMZ,nMB,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,28),heltab2x72(:,:,28))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMT,G1H36(28),n2h36(28))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(29),h0tab(:,29),[16,2,8,1,4],[nMB,nMH,nMW,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,29),heltab2x72(:,:,29))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(29),n2h36(29))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(30),h0tab(:,30),[16,2,8,1,4],[nMB,nMZ,nMW,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,30),heltab2x72(:,:,30))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(30),n2h36(30))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(31),h0tab(:,31),[16,2,8,1,4],[nMB,0,nMW,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,31),heltab2x72(:,:,31))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(31),n2h36(31))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(32),h0tab(:,32),[16,2,8,1,4],[nMB,nMZ,nMW,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,32),heltab2x72(:,:,32))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(32),n2h36(32))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(33),h0tab(:,33),[16,2,8,1,4],[nMB,nMH,nMW,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,33),heltab2x72(:,:,33))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(33),n2h36(33))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(34),h0tab(:,34),[16,2,8,1,4],[nMB,0,nMW,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,34),heltab2x72(:,:,34))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(34),n2h36(34))
  Gcoeff(:)%j = (c(53)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(35),h0tab(:,35),[16,2,8,1,4],[nMB,nMZ,nMW,nMT,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,35),heltab2x72(:,:,35))
  call Hloop_Q_A(ntryL,G0H36(1),16,nMB,G1H36(35),n2h36(35))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(36),h0tab(:,36),[16,1,4,2,8],[nMB,nMH,nMW,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,36),heltab2x72(:,:,36))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(36),n2h36(36))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(37),h0tab(:,37),[16,1,4,2,8],[nMB,nMZ,nMW,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,37),heltab2x72(:,:,37))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(37),n2h36(37))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(38),h0tab(:,38),[16,1,4,2,8],[nMB,nMH,nMW,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,38),heltab2x72(:,:,38))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(38),n2h36(38))
  Gcoeff(:)%j = (c(68)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(39),h0tab(:,39),[16,1,4,2,8],[nMB,0,nMW,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,39),heltab2x72(:,:,39))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(39),n2h36(39))
  Gcoeff(:)%j = (c(97)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(40),h0tab(:,40),[16,1,4,2,8],[nMB,nMZ,nMW,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,40),heltab2x72(:,:,40))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(40),n2h36(40))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(41),h0tab(:,41),[16,1,4,2,8],[nMB,0,nMW,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,41),heltab2x72(:,:,41))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(41),n2h36(41))
  Gcoeff(:)%j = (c(53)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(42),h0tab(:,42),[16,1,4,2,8],[nMB,nMZ,nMW,nMT,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,42),heltab2x72(:,:,42))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(42),n2h36(42))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(43),h0tab(:,43),[16,1,4,8,2],[nMB,nMH,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,43),heltab2x72(:,:,43))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(43),n2h36(43))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(44),h0tab(:,44),[16,1,4,8,2],[nMB,nMH,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,44),heltab2x72(:,:,44))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(44),n2h36(44))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(45),h0tab(:,45),[16,1,4,8,2],[nMB,nMZ,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,45),heltab2x72(:,:,45))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(45),n2h36(45))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(46),h0tab(:,46),[16,1,4,8,2],[nMB,nMZ,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,46),heltab2x72(:,:,46))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(46),n2h36(46))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(47),h0tab(:,47),[16,1,4,8,2],[nMB,nMH,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,47),heltab2x72(:,:,47))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(47),n2h36(47))
  Gcoeff(:)%j = (c(78)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(48),h0tab(:,48),[16,1,4,8,2],[nMB,nMH,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,48),heltab2x72(:,:,48))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(48),n2h36(48))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(49),h0tab(:,49),[16,1,4,8,2],[nMB,nMZ,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,49),heltab2x72(:,:,49))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(49),n2h36(49))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(50),h0tab(:,50),[16,1,4,8,2],[nMB,nMH,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,50),heltab2x72(:,:,50))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(50),n2h36(50))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(51),h0tab(:,51),[16,1,4,8,2],[nMB,nMZ,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,51),heltab2x72(:,:,51))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(51),n2h36(51))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(52),h0tab(:,52),[16,1,4,8,2],[nMB,0,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,52),heltab2x72(:,:,52))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(52),n2h36(52))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(53),h0tab(:,53),[16,1,4,8,2],[nMB,0,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,53),heltab2x72(:,:,53))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(53),n2h36(53))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(54),h0tab(:,54),[16,1,4,8,2],[nMB,nMZ,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,54),heltab2x72(:,:,54))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(54),n2h36(54))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(55),h0tab(:,55),[16,1,4,8,2],[nMB,nMZ,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,55),heltab2x72(:,:,55))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(55),n2h36(55))
  Gcoeff(:)%j = (c(79)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(56),h0tab(:,56),[16,1,4,8,2],[nMB,nMH,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,56),heltab2x72(:,:,56))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(56),n2h36(56))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(57),h0tab(:,57),[16,1,4,8,2],[nMB,nMH,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,57),heltab2x72(:,:,57))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(57),n2h36(57))
  Gcoeff(:)%j = (c(79)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(58),h0tab(:,58),[16,1,4,8,2],[nMB,0,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,58),heltab2x72(:,:,58))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(58),n2h36(58))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(59),h0tab(:,59),[16,1,4,8,2],[nMB,nMZ,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,59),heltab2x72(:,:,59))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(59),n2h36(59))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(60),h0tab(:,60),[16,1,4,8,2],[nMB,0,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,60),heltab2x72(:,:,60))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(60),n2h36(60))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(61),h0tab(:,61),[16,1,4,8,2],[nMB,0,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,61),heltab2x72(:,:,61))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(61),n2h36(61))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(62),h0tab(:,62),[16,1,4,8,2],[nMB,nMZ,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,62),heltab2x72(:,:,62))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(62),n2h36(62))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(63),h0tab(:,63),[16,1,4,8,2],[nMB,nMZ,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,63),heltab2x72(:,:,63))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(63),n2h36(63))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(64),h0tab(:,64),[16,1,4,8,2],[nMB,0,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,64),heltab2x72(:,:,64))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(64),n2h36(64))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(65),h0tab(:,65),[16,1,4,8,2],[nMB,0,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,65),heltab2x72(:,:,65))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(65),n2h36(65))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(66),h0tab(:,66),[16,1,4,8,2],[nMB,nMZ,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,66),heltab2x72(:,:,66))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(66),n2h36(66))
  Gcoeff(:)%j = (c(73)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(67),h0tab(:,67),[16,1,4,8,2],[nMB,nMZ,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,67),heltab2x72(:,:,67))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(67),n2h36(67))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(68),h0tab(:,68),[16,1,8,2,4],[nMT,nMW,nMH,nMB,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,68),heltab2x72(:,:,68))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(68),n2h36(68))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(69),h0tab(:,69),[16,1,8,2,4],[nMT,nMW,nMZ,nMB,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,69),heltab2x72(:,:,69))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(69),n2h36(69))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(70),h0tab(:,70),[16,1,8,2,4],[nMT,nMW,0,nMB,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,70),heltab2x72(:,:,70))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(70),n2h36(70))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(71),h0tab(:,71),[16,1,8,2,4],[nMT,nMW,nMZ,nMB,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,71),heltab2x72(:,:,71))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(71),n2h36(71))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(72),h0tab(:,72),[16,1,8,2,4],[nMT,nMW,nMH,nMB,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,72),heltab2x72(:,:,72))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(72),n2h36(72))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(73),h0tab(:,73),[16,1,8,2,4],[nMT,nMW,0,nMB,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,73),heltab2x72(:,:,73))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(73),n2h36(73))
  Gcoeff(:)%j = (c(53)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(74),h0tab(:,74),[16,1,8,2,4],[nMT,nMW,nMZ,nMB,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,74),heltab2x72(:,:,74))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(74),n2h36(74))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(75),h0tab(:,75),[16,1,8,4,2],[nMB,nMH,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,75),heltab2x72(:,:,75))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(75),n2h36(75))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(76),h0tab(:,76),[16,1,8,4,2],[nMB,nMH,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,76),heltab2x72(:,:,76))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(76),n2h36(76))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(77),h0tab(:,77),[16,1,8,4,2],[nMB,nMZ,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,77),heltab2x72(:,:,77))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(77),n2h36(77))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(78),h0tab(:,78),[16,1,8,4,2],[nMB,nMZ,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,78),heltab2x72(:,:,78))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(78),n2h36(78))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(79),h0tab(:,79),[16,1,8,4,2],[nMT,nMW,nMH,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,79),heltab2x72(:,:,79))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(79),n2h36(79))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(80),h0tab(:,80),[16,1,8,4,2],[nMT,nMW,nMZ,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,80),heltab2x72(:,:,80))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(80),n2h36(80))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(81),h0tab(:,81),[16,1,8,4,2],[nMT,nMW,0,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,81),heltab2x72(:,:,81))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(81),n2h36(81))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(82),h0tab(:,82),[16,1,8,4,2],[nMT,nMW,nMZ,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,82),heltab2x72(:,:,82))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(82),n2h36(82))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(83),h0tab(:,83),[16,1,8,4,2],[nMB,nMH,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,83),heltab2x72(:,:,83))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(83),n2h36(83))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(84),h0tab(:,84),[16,1,8,4,2],[nMB,nMH,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,84),heltab2x72(:,:,84))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(84),n2h36(84))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(85),h0tab(:,85),[16,1,8,4,2],[nMB,nMZ,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,85),heltab2x72(:,:,85))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(85),n2h36(85))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(86),h0tab(:,86),[16,1,8,4,2],[nMB,nMH,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,86),heltab2x72(:,:,86))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(86),n2h36(86))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(87),h0tab(:,87),[16,1,8,4,2],[nMB,nMZ,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,87),heltab2x72(:,:,87))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(87),n2h36(87))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(88),h0tab(:,88),[16,1,8,4,2],[nMT,nMW,nMH,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,88),heltab2x72(:,:,88))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(88),n2h36(88))
  Gcoeff(:)%j = (c(78)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(89),h0tab(:,89),[16,1,8,4,2],[nMB,0,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,89),heltab2x72(:,:,89))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(89),n2h36(89))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(90),h0tab(:,90),[16,1,8,4,2],[nMB,0,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,90),heltab2x72(:,:,90))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(90),n2h36(90))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(91),h0tab(:,91),[16,1,8,4,2],[nMB,nMZ,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,91),heltab2x72(:,:,91))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(91),n2h36(91))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(92),h0tab(:,92),[16,1,8,4,2],[nMB,nMZ,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,92),heltab2x72(:,:,92))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(92),n2h36(92))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(93),h0tab(:,93),[16,1,8,4,2],[nMT,nMW,nMH,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,93),heltab2x72(:,:,93))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(93),n2h36(93))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(94),h0tab(:,94),[16,1,8,4,2],[0,nMB,nMT,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(94),m3h2x36(:,94),heltab2x72(:,:,94))
  Gcoeff(:)%j = (c(79)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(95),h0tab(:,95),[16,1,8,4,2],[nMB,nMH,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,95),heltab2x72(:,:,95))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(95),n2h36(94))
  Gcoeff(:)%j = (c(71)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(96),h0tab(:,96),[16,1,8,4,2],[nMT,nMW,0,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,96),heltab2x72(:,:,96))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(96),n2h36(95))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(97),h0tab(:,97),[16,1,8,4,2],[nMB,nMH,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,97),heltab2x72(:,:,97))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(97),n2h36(96))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(98),h0tab(:,98),[16,1,8,4,2],[nMT,nMW,nMZ,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,98),heltab2x72(:,:,98))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(98),n2h36(97))
  Gcoeff(:)%j = (c(79)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(99),h0tab(:,99),[16,1,8,4,2],[nMB,0,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,99),heltab2x72(:,:,99))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(99),n2h36(98))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(100),h0tab(:,100),[16,1,8,4,2],[nMT,nMW,0,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,100),heltab2x72(:,:,100))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(100),n2h36(99))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(101),h0tab(:,101),[16,1,8,4,2],[nMB,nMZ,nMW,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,101),heltab2x72(:,:,101))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(101),n2h36(100))
  Gcoeff(:)%j = (c(71)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(102),h0tab(:,102),[16,1,8,4,2],[nMT,nMW,nMZ,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,102),heltab2x72(:,:,102))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(102),n2h36(101))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(103),h0tab(:,103),[16,1,8,4,2],[nMB,0,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,103),heltab2x72(:,:,103))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(103),n2h36(102))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(104),h0tab(:,104),[16,1,8,4,2],[nMB,0,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,104),heltab2x72(:,:,104))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(104),n2h36(103))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(105),h0tab(:,105),[16,1,8,4,2],[nMB,nMZ,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,105),heltab2x72(:,:,105))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(105),n2h36(104))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(106),h0tab(:,106),[16,1,8,4,2],[nMB,nMZ,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,106),heltab2x72(:,:,106))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(106),n2h36(105))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(107),h0tab(:,107),[16,1,8,4,2],[nMT,nMW,nMH,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,107),heltab2x72(:,:,107))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(107),n2h36(106))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(108),h0tab(:,108),[16,1,8,4,2],[nMB,0,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,108),heltab2x72(:,:,108))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(108),n2h36(107))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(109),h0tab(:,109),[16,1,8,4,2],[nMB,0,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,109),heltab2x72(:,:,109))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(109),n2h36(108))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(110),h0tab(:,110),[16,1,8,4,2],[nMB,nMZ,nMW,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,110),heltab2x72(:,:,110))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(110),n2h36(109))
  Gcoeff(:)%j = (c(73)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(111),h0tab(:,111),[16,1,8,4,2],[nMB,nMZ,nMW,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,111),heltab2x72(:,:,111))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMB,G1H36(111),n2h36(110))
  Gcoeff(:)%j = (c(71)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(112),h0tab(:,112),[16,1,8,4,2],[nMT,nMW,0,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,112),heltab2x72(:,:,112))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(112),n2h36(111))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(113),h0tab(:,113),[16,1,8,4,2],[nMT,nMW,nMZ,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,113),heltab2x72(:,:,113))
  call Hloop_A_Q(ntryL,G0H36(1),16,nMT,G1H36(113),n2h36(112))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(9),[G1H36(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(14),[G1H36(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(19),[G1H36(17)])
  call Hloop_AW_Q(ntryL,G1H36(1),ex3(:),G1H12(1),m3h3x12(:,1),heltab2x36(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(1),n2h12(1))
  call Hloop_AW_Q(ntryL,G1H36(2),ex3(:),G1H12(1),m3h3x12(:,2),heltab2x36(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(2),n2h12(2))
  call Hloop_QA_S(ntryL,G1H36(3),ex2(:),G1H18(1),ngPbt,m3h2x18(:,1),heltab2x36(:,:,3))
  call Hloop_QA_W(ntryL,G1H36(4),ex2(:),G1H18(2),m3h2x18(:,2),heltab2x36(:,:,4))
  call Hloop_QW_A(ntryL,G1H36(5),ex3(:),G1H12(1),m3h3x12(:,3),heltab2x36(:,:,5))
  call Hloop_Q_A(ntryL,G1H12(1),20,nMB,G2H12(3),n2h12(3))
  call Hloop_QW_A(ntryL,G1H36(6),ex3(:),G1H12(1),m3h3x12(:,4),heltab2x36(:,:,6))
  call Hloop_Q_A(ntryL,G1H12(1),20,nMB,G2H12(4),n2h12(4))
  call Hloop_QW_A(ntryL,G1H36(9),ex3(:),G1H12(1),m3h3x12(:,5),heltab2x36(:,:,7))
  call Hloop_Q_A(ntryL,G1H12(1),20,nMB,G2H12(5),n2h12(5))
  call Hloop_QW_A(ntryL,G1H36(8),ex3(:),G1H12(1),m3h3x12(:,6),heltab2x36(:,:,8))
  call Hloop_Q_A(ntryL,G1H12(1),20,nMB,G2H12(6),n2h12(6))
  call Hloop_QA_S(ntryL,G1H36(10),ex2(:),G1H18(3),ngH,m3h2x18(:,3),heltab2x36(:,:,9))
  call Hloop_QA_S(ntryL,G1H36(11),ex2(:),G1H18(4),ngX,m3h2x18(:,4),heltab2x36(:,:,10))
  call Hloop_QA_V(ntryL,G1H36(14),ex2(:),G1H18(5),m3h2x18(:,5),heltab2x36(:,:,11))
  call Hloop_QA_Z(ntryL,G1H36(13),ex2(:),G1H18(6),ngZd,m3h2x18(:,6),heltab2x36(:,:,12))
  call Hloop_AQ_S(ntryL,G1H36(15),ex1(:),G1H18(7),ngH,m3h2x18(:,7),heltab2x36(:,:,13))
  call Hloop_AQ_S(ntryL,G1H36(16),ex1(:),G1H18(8),ngX,m3h2x18(:,8),heltab2x36(:,:,14))
  call Hloop_AQ_V(ntryL,G1H36(19),ex1(:),G1H18(9),m3h2x18(:,9),heltab2x36(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H36(18),ex1(:),G1H18(10),ngZd,m3h2x18(:,10),heltab2x36(:,:,16))
  call Hloop_AQ_S(ntryL,G1H36(20),ex1(:),G1H18(11),ngPtb,m3h2x18(:,11),heltab2x36(:,:,17))
  call Hloop_AQ_W(ntryL,G1H36(21),ex1(:),G1H18(12),m3h2x18(:,12),heltab2x36(:,:,18))
  call Hloop_QA_S(ntryL,G1H36(22),ex2(:),G1H18(13),ngPbt,m3h2x18(:,13),heltab2x36(:,:,19))
  call Hloop_QA_S(ntryL,G1H36(23),ex2(:),G1H18(14),ngPbt,m3h2x18(:,14),heltab2x36(:,:,20))
  call Hloop_QA_W(ntryL,G1H36(24),ex2(:),G1H18(15),m3h2x18(:,15),heltab2x36(:,:,21))
  call Hloop_QA_S(ntryL,G1H36(25),ex2(:),G1H18(16),ngPbt,m3h2x18(:,16),heltab2x36(:,:,22))
  call Hloop_QA_S(ntryL,G1H36(26),ex2(:),G1H18(17),ngPbt,m3h2x18(:,17),heltab2x36(:,:,23))
  call Hloop_QA_W(ntryL,G1H36(27),ex2(:),G1H18(18),m3h2x18(:,18),heltab2x36(:,:,24))
  call Hloop_QA_W(ntryL,G1H36(28),ex2(:),G1H18(19),m3h2x18(:,19),heltab2x36(:,:,25))
  call Hloop_QA_S(ntryL,G1H36(29),ex2(:),G1H18(20),ngH,m3h2x18(:,20),heltab2x36(:,:,26))
  call Hloop_QA_S(ntryL,G1H36(30),ex2(:),G1H18(21),ngX,m3h2x18(:,21),heltab2x36(:,:,27))
  call Hloop_QA_V(ntryL,G1H36(31),ex2(:),G1H18(22),m3h2x18(:,22),heltab2x36(:,:,28))
  call Hloop_QA_Z(ntryL,G1H36(32),ex2(:),G1H18(23),ngZd,m3h2x18(:,23),heltab2x36(:,:,29))
  call Hloop_QA_S(ntryL,G1H36(33),ex2(:),G1H18(24),ngH,m3h2x18(:,24),heltab2x36(:,:,30))
  call Hloop_QA_V(ntryL,G1H36(34),ex2(:),G1H18(25),m3h2x18(:,25),heltab2x36(:,:,31))
  call Hloop_QA_Z(ntryL,G1H36(35),ex2(:),G1H18(26),ngZd,m3h2x18(:,26),heltab2x36(:,:,32))
  call Hloop_AQ_S(ntryL,G1H36(36),ex1(:),G1H18(27),ngH,m3h2x18(:,27),heltab2x36(:,:,33))
  call Hloop_AQ_S(ntryL,G1H36(37),ex1(:),G1H18(28),ngX,m3h2x18(:,28),heltab2x36(:,:,34))
  call Hloop_AQ_S(ntryL,G1H36(38),ex1(:),G1H18(29),ngH,m3h2x18(:,29),heltab2x36(:,:,35))
  call Hloop_AQ_V(ntryL,G1H36(39),ex1(:),G1H18(30),m3h2x18(:,30),heltab2x36(:,:,36))
  call Hloop_AQ_Z(ntryL,G1H36(40),ex1(:),G1H18(31),ngZd,m3h2x18(:,31),heltab2x36(:,:,37))
  call Hloop_AQ_V(ntryL,G1H36(41),ex1(:),G1H18(32),m3h2x18(:,32),heltab2x36(:,:,38))
  call Hloop_AQ_Z(ntryL,G1H36(42),ex1(:),G1H18(33),ngZd,m3h2x18(:,33),heltab2x36(:,:,39))
  call Hloop_AQ_S(ntryL,G1H36(43),ex1(:),G1H18(34),ngH,m3h2x18(:,34),heltab2x36(:,:,40))
  call Hloop_AQ_S(ntryL,G1H36(44),ex1(:),G1H18(35),ngH,m3h2x18(:,35),heltab2x36(:,:,41))
  call Hloop_AQ_S(ntryL,G1H36(45),ex1(:),G1H18(36),ngX,m3h2x18(:,36),heltab2x36(:,:,42))
  call Hloop_AQ_S(ntryL,G1H36(46),ex1(:),G1H18(37),ngX,m3h2x18(:,37),heltab2x36(:,:,43))
  call Hloop_AQ_S(ntryL,G1H36(47),ex1(:),G1H18(38),ngH,m3h2x18(:,38),heltab2x36(:,:,44))
  call Hloop_AQ_S(ntryL,G1H36(48),ex1(:),G1H18(39),ngH,m3h2x18(:,39),heltab2x36(:,:,45))
  call Hloop_AQ_S(ntryL,G1H36(49),ex1(:),G1H18(40),ngX,m3h2x18(:,40),heltab2x36(:,:,46))
  call Hloop_AQ_S(ntryL,G1H36(50),ex1(:),G1H18(41),ngH,m3h2x18(:,41),heltab2x36(:,:,47))
  call Hloop_AQ_S(ntryL,G1H36(51),ex1(:),G1H18(42),ngX,m3h2x18(:,42),heltab2x36(:,:,48))
  call Hloop_AQ_V(ntryL,G1H36(52),ex1(:),G1H18(43),m3h2x18(:,43),heltab2x36(:,:,49))
  call Hloop_AQ_V(ntryL,G1H36(53),ex1(:),G1H18(44),m3h2x18(:,44),heltab2x36(:,:,50))
  call Hloop_AQ_Z(ntryL,G1H36(54),ex1(:),G1H18(45),ngZd,m3h2x18(:,45),heltab2x36(:,:,51))
  call Hloop_AQ_Z(ntryL,G1H36(55),ex1(:),G1H18(46),ngZd,m3h2x18(:,46),heltab2x36(:,:,52))
  call Hloop_AQ_S(ntryL,G1H36(56),ex1(:),G1H18(47),ngH,m3h2x18(:,47),heltab2x36(:,:,53))
  call Hloop_AQ_S(ntryL,G1H36(57),ex1(:),G1H18(48),ngH,m3h2x18(:,48),heltab2x36(:,:,54))
  call Hloop_AQ_V(ntryL,G1H36(58),ex1(:),G1H18(49),m3h2x18(:,49),heltab2x36(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H36(59),ex1(:),G1H18(50),ngZd,m3h2x18(:,50),heltab2x36(:,:,56))
  call Hloop_AQ_V(ntryL,G1H36(60),ex1(:),G1H18(51),m3h2x18(:,51),heltab2x36(:,:,57))
  call Hloop_AQ_V(ntryL,G1H36(61),ex1(:),G1H18(52),m3h2x18(:,52),heltab2x36(:,:,58))
  call Hloop_AQ_Z(ntryL,G1H36(62),ex1(:),G1H18(53),ngZd,m3h2x18(:,53),heltab2x36(:,:,59))
  call Hloop_AQ_Z(ntryL,G1H36(63),ex1(:),G1H18(54),ngZd,m3h2x18(:,54),heltab2x36(:,:,60))
  call Hloop_AQ_V(ntryL,G1H36(64),ex1(:),G1H18(55),m3h2x18(:,55),heltab2x36(:,:,61))
  call Hloop_AQ_V(ntryL,G1H36(65),ex1(:),G1H18(56),m3h2x18(:,56),heltab2x36(:,:,62))
  call Hloop_AQ_Z(ntryL,G1H36(66),ex1(:),G1H18(57),ngZd,m3h2x18(:,57),heltab2x36(:,:,63))
  call Hloop_AQ_Z(ntryL,G1H36(67),ex1(:),G1H18(58),ngZd,m3h2x18(:,58),heltab2x36(:,:,64))
  call Hloop_AQ_S(ntryL,G1H36(68),ex1(:),G1H18(59),ngPtb,m3h2x18(:,59),heltab2x36(:,:,65))
  call Hloop_AQ_S(ntryL,G1H36(69),ex1(:),G1H18(60),ngPtb,m3h2x18(:,60),heltab2x36(:,:,66))
  call Hloop_AQ_S(ntryL,G1H36(70),ex1(:),G1H18(61),ngPtb,m3h2x18(:,61),heltab2x36(:,:,67))
  call Hloop_AQ_S(ntryL,G1H36(71),ex1(:),G1H18(62),ngPtb,m3h2x18(:,62),heltab2x36(:,:,68))
  call Hloop_AQ_W(ntryL,G1H36(72),ex1(:),G1H18(63),m3h2x18(:,63),heltab2x36(:,:,69))
  call Hloop_AQ_W(ntryL,G1H36(73),ex1(:),G1H18(64),m3h2x18(:,64),heltab2x36(:,:,70))
  call Hloop_AQ_W(ntryL,G1H36(74),ex1(:),G1H18(65),m3h2x18(:,65),heltab2x36(:,:,71))
  call Hloop_AQ_S(ntryL,G1H36(75),ex1(:),G1H18(66),ngH,m3h2x18(:,66),heltab2x36(:,:,72))
  call Hloop_AQ_S(ntryL,G1H36(76),ex1(:),G1H18(67),ngH,m3h2x18(:,67),heltab2x36(:,:,73))
  call Hloop_AQ_S(ntryL,G1H36(77),ex1(:),G1H18(68),ngX,m3h2x18(:,68),heltab2x36(:,:,74))
  call Hloop_AQ_S(ntryL,G1H36(78),ex1(:),G1H18(69),ngX,m3h2x18(:,69),heltab2x36(:,:,75))
  call Hloop_AQ_S(ntryL,G1H36(79),ex1(:),G1H18(70),ngPtb,m3h2x18(:,70),heltab2x36(:,:,76))
  call Hloop_AQ_S(ntryL,G1H36(80),ex1(:),G1H18(71),ngPtb,m3h2x18(:,71),heltab2x36(:,:,77))
  call Hloop_AQ_S(ntryL,G1H36(81),ex1(:),G1H18(72),ngPtb,m3h2x18(:,72),heltab2x36(:,:,78))
  call Hloop_AQ_S(ntryL,G1H36(82),ex1(:),G1H18(73),ngPtb,m3h2x18(:,73),heltab2x36(:,:,79))
  call Hloop_AQ_S(ntryL,G1H36(83),ex1(:),G1H18(74),ngH,m3h2x18(:,74),heltab2x36(:,:,80))
  call Hloop_AQ_S(ntryL,G1H36(84),ex1(:),G1H18(75),ngH,m3h2x18(:,75),heltab2x36(:,:,81))
  call Hloop_AQ_S(ntryL,G1H36(85),ex1(:),G1H18(76),ngX,m3h2x18(:,76),heltab2x36(:,:,82))
  call Hloop_AQ_S(ntryL,G1H36(86),ex1(:),G1H18(77),ngH,m3h2x18(:,77),heltab2x36(:,:,83))
  call Hloop_AQ_S(ntryL,G1H36(87),ex1(:),G1H18(78),ngX,m3h2x18(:,78),heltab2x36(:,:,84))
  call Hloop_AQ_S(ntryL,G1H36(88),ex1(:),G1H18(79),ngPtb,m3h2x18(:,79),heltab2x36(:,:,85))
  call Hloop_AQ_V(ntryL,G1H36(89),ex1(:),G1H18(80),m3h2x18(:,80),heltab2x36(:,:,86))
  call Hloop_AQ_V(ntryL,G1H36(90),ex1(:),G1H18(81),m3h2x18(:,81),heltab2x36(:,:,87))
  call Hloop_AQ_Z(ntryL,G1H36(91),ex1(:),G1H18(82),ngZd,m3h2x18(:,82),heltab2x36(:,:,88))
  call Hloop_AQ_Z(ntryL,G1H36(92),ex1(:),G1H18(83),ngZd,m3h2x18(:,83),heltab2x36(:,:,89))
  call Hloop_AQ_W(ntryL,G1H36(93),ex1(:),G1H18(84),m3h2x18(:,84),heltab2x36(:,:,90))
  call Hloop_VQ_A(ntryL,G1H36(94),ex1(:),G1H18(85),m3h2x18(:,85),heltab2x36(:,:,91))
  call Hloop_Q_A(ntryL,G1H18(85),17,nMB,G2H18(1),n2h18(1))
  call Hloop_AQ_S(ntryL,G1H36(95),ex1(:),G1H18(85),ngH,m3h2x18(:,86),heltab2x36(:,:,92))
  call Hloop_AQ_S(ntryL,G1H36(96),ex1(:),G1H18(86),ngPtb,m3h2x18(:,87),heltab2x36(:,:,93))
  call Hloop_AQ_S(ntryL,G1H36(97),ex1(:),G1H18(87),ngH,m3h2x18(:,88),heltab2x36(:,:,94))
  call Hloop_AQ_S(ntryL,G1H36(98),ex1(:),G1H18(88),ngPtb,m3h2x18(:,89),heltab2x36(:,:,95))
  call Hloop_AQ_V(ntryL,G1H36(99),ex1(:),G1H18(89),m3h2x18(:,90),heltab2x36(:,:,96))
  call Hloop_AQ_W(ntryL,G1H36(100),ex1(:),G1H18(90),m3h2x18(:,91),heltab2x36(:,:,97))
  call Hloop_AQ_Z(ntryL,G1H36(101),ex1(:),G1H18(91),ngZd,m3h2x18(:,92),heltab2x36(:,:,98))
  call Hloop_AQ_W(ntryL,G1H36(102),ex1(:),G1H18(92),m3h2x18(:,93),heltab2x36(:,:,99))
  call Hloop_AQ_V(ntryL,G1H36(103),ex1(:),G1H18(93),m3h2x18(:,94),heltab2x36(:,:,100))
  call Hloop_AQ_V(ntryL,G1H36(104),ex1(:),G1H18(94),m3h2x18(:,95),heltab2x36(:,:,101))
  call Hloop_AQ_Z(ntryL,G1H36(105),ex1(:),G1H18(95),ngZd,m3h2x18(:,96),heltab2x36(:,:,102))
  call Hloop_AQ_Z(ntryL,G1H36(106),ex1(:),G1H18(96),ngZd,m3h2x18(:,97),heltab2x36(:,:,103))
  call Hloop_AQ_W(ntryL,G1H36(107),ex1(:),G1H18(97),m3h2x18(:,98),heltab2x36(:,:,104))
  call Hloop_AQ_V(ntryL,G1H36(108),ex1(:),G1H18(98),m3h2x18(:,99),heltab2x36(:,:,105))
  call Hloop_AQ_V(ntryL,G1H36(109),ex1(:),G1H18(99),m3h2x18(:,100),heltab2x36(:,:,106))
  call Hloop_AQ_Z(ntryL,G1H36(110),ex1(:),G1H18(100),ngZd,m3h2x18(:,101),heltab2x36(:,:,107))
  call Hloop_AQ_Z(ntryL,G1H36(111),ex1(:),G1H18(101),ngZd,m3h2x18(:,102),heltab2x36(:,:,108))
  call Hloop_AQ_W(ntryL,G1H36(112),ex1(:),G1H18(102),m3h2x18(:,103),heltab2x36(:,:,109))
  call Hloop_AQ_W(ntryL,G1H36(113),ex1(:),G1H18(103),m3h2x18(:,104),heltab2x36(:,:,110))
  call Hloop_AQ_S(ntryL,G2H12(1),ex1(:),G2H6(1),ngPtb,m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_W(ntryL,G2H12(2),ex1(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_SQ_A(ntryL,G1H18(1),ex1(:),G1H9(1),ngPtb,m3h2x9(:,1),heltab2x18(:,:,1))
  call Hloop_Q_A(ntryL,G1H9(1),19,nMT,G2H9(1),n2h9(1))
  call Hloop_WQ_A(ntryL,G1H18(2),ex1(:),G1H9(1),m3h2x9(:,2),heltab2x18(:,:,2))
  call Hloop_Q_A(ntryL,G1H9(1),19,nMT,G2H9(2),n2h9(2))
  call Hloop_QA_S(ntryL,G2H12(3),ex2(:),G2H6(3),ngH,m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_QA_S(ntryL,G2H12(4),ex2(:),G2H6(4),ngX,m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_QA_V(ntryL,G2H12(5),ex2(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_QA_Z(ntryL,G2H12(6),ex2(:),G2H6(6),ngZd,m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_SQ_A(ntryL,G1H18(3),ex1(:),G1H9(1),ngH,m3h2x9(:,3),heltab2x18(:,:,3))
  call Hloop_Q_A(ntryL,G1H9(1),19,nMB,G2H9(3),n2h9(3))
  call Hloop_SQ_A(ntryL,G1H18(4),ex1(:),G1H9(1),ngX,m3h2x9(:,4),heltab2x18(:,:,4))
  call Hloop_Q_A(ntryL,G1H9(1),19,nMB,G2H9(4),n2h9(4))
  call Hloop_VQ_A(ntryL,G1H18(5),ex1(:),G1H9(1),m3h2x9(:,5),heltab2x18(:,:,5))
  call Hloop_Q_A(ntryL,G1H9(1),19,nMB,G2H9(5),n2h9(5))
  call Hloop_ZQ_A(ntryL,G1H18(6),ex1(:),G1H9(1),ngZd,m3h2x9(:,6),heltab2x18(:,:,6))
  call Hloop_Q_A(ntryL,G1H9(1),19,nMB,G2H9(6),n2h9(6))
  call Hloop_SA_Q(ntryL,G1H18(7),ex2(:),G1H9(1),ngH,m3h2x9(:,7),heltab2x18(:,:,7))
  call Hloop_A_Q(ntryL,G1H9(1),19,nMB,G2H9(7),n2h9(7))
  call Hloop_SA_Q(ntryL,G1H18(8),ex2(:),G1H9(1),ngX,m3h2x9(:,8),heltab2x18(:,:,8))
  call Hloop_A_Q(ntryL,G1H9(1),19,nMB,G2H9(8),n2h9(8))
  call Hloop_VA_Q(ntryL,G1H18(9),ex2(:),G1H9(1),m3h2x9(:,9),heltab2x18(:,:,9))
  call Hloop_A_Q(ntryL,G1H9(1),19,nMB,G2H9(9),n2h9(9))
  call Hloop_ZA_Q(ntryL,G1H18(10),ex2(:),G1H9(1),ngZd,m3h2x9(:,10),heltab2x18(:,:,10))
  call Hloop_A_Q(ntryL,G1H9(1),19,nMB,G2H9(10),n2h9(10))
  call Hloop_SA_Q(ntryL,G1H18(11),ex2(:),G1H9(1),ngPbt,m3h2x9(:,11),heltab2x18(:,:,11))
  call Hloop_A_Q(ntryL,G1H9(1),19,nMT,G2H9(11),n2h9(11))
  call Hloop_WA_Q(ntryL,G1H18(12),ex2(:),G1H9(1),m3h2x9(:,12),heltab2x18(:,:,12))
  call Hloop_A_Q(ntryL,G1H9(1),19,nMT,G2H9(12),n2h9(12))
  call Hloop_SV_T(ntryL,G1H18(13),18,ex3(:),4,G2H6(7),m3h3x6(:,1),heltab2x18(:,:,13))
  call Hloop_SV_T(ntryL,G1H18(14),18,ex3(:),4,G2H6(8),m3h3x6(:,2),heltab2x18(:,:,14))
  call Hloop_VV_S(ntryL,G1H18(15),ex3(:),G1H6(1),m3h3x6(:,3),heltab2x18(:,:,15))
  call Hloop_SV_V(ntryL,G1H18(16),ex3(:),G1H6(2),m3h3x6(:,4),heltab2x18(:,:,16))
  call Hloop_SV_V(ntryL,G1H18(17),ex3(:),G1H6(3),m3h3x6(:,5),heltab2x18(:,:,17))
  call Hloop_UV_W(ntryL,G1H18(18),18,ex3(:),4,G2H6(9),m3h3x6(:,6),heltab2x18(:,:,18))
  call Hloop_UV_W(ntryL,G1H18(19),18,ex3(:),4,G2H6(10),m3h3x6(:,7),heltab2x18(:,:,19))
  call Hloop_TV_S(ntryL,G1H18(20),18,ex4(:),8,G2H6(11),m3h3x6(:,8),heltab2x18(:,:,20))
  call Hloop_TV_S(ntryL,G1H18(21),18,ex4(:),8,G2H6(12),m3h3x6(:,9),heltab2x18(:,:,21))
  call Hloop_VV_S(ntryL,G1H18(22),ex4(:),G1H6(4),m3h3x6(:,10),heltab2x18(:,:,22))
  call Hloop_VV_S(ntryL,G1H18(23),ex4(:),G1H6(5),m3h3x6(:,11),heltab2x18(:,:,23))
  call Hloop_SV_V(ntryL,G1H18(24),ex4(:),G1H6(6),m3h3x6(:,12),heltab2x18(:,:,24))
  call Hloop_UV_W(ntryL,G1H18(25),18,ex4(:),8,G2H6(13),m3h3x6(:,13),heltab2x18(:,:,25))
  call Hloop_UV_W(ntryL,G1H18(26),18,ex4(:),8,G2H6(14),m3h3x6(:,14),heltab2x18(:,:,26))
  call Hloop_TV_S(ntryL,G1H18(27),17,ex3(:),4,G2H6(15),m3h3x6(:,15),heltab2x18(:,:,27))
  call Hloop_TV_S(ntryL,G1H18(28),17,ex3(:),4,G2H6(16),m3h3x6(:,16),heltab2x18(:,:,28))
  call Hloop_SV_V(ntryL,G1H18(29),ex3(:),G1H6(7),m3h3x6(:,17),heltab2x18(:,:,29))
  call Hloop_VV_S(ntryL,G1H18(30),ex3(:),G1H6(8),m3h3x6(:,18),heltab2x18(:,:,30))
  call Hloop_VV_S(ntryL,G1H18(31),ex3(:),G1H6(9),m3h3x6(:,19),heltab2x18(:,:,31))
  call Hloop_UW_V(ntryL,G1H18(32),17,ex3(:),4,G2H6(17),m3h3x6(:,20),heltab2x18(:,:,32))
  call Hloop_UW_V(ntryL,G1H18(33),17,ex3(:),4,G2H6(18),m3h3x6(:,21),heltab2x18(:,:,33))
  call Hloop_TV_S(ntryL,G1H18(34),17,ex3(:),4,G2H6(19),m3h3x6(:,22),heltab2x18(:,:,34))
  call Hloop_TV_S(ntryL,G1H18(35),17,ex3(:),4,G2H6(20),m3h3x6(:,23),heltab2x18(:,:,35))
  call Hloop_TV_S(ntryL,G1H18(36),17,ex3(:),4,G2H6(21),m3h3x6(:,24),heltab2x18(:,:,36))
  call Hloop_TV_S(ntryL,G1H18(37),17,ex3(:),4,G2H6(22),m3h3x6(:,25),heltab2x18(:,:,37))
  call Hloop_SV_V(ntryL,G1H18(38),ex3(:),G1H6(10),m3h3x6(:,26),heltab2x18(:,:,38))
  call Hloop_TV_S(ntryL,G1H18(39),17,ex3(:),4,G2H6(23),m3h3x6(:,27),heltab2x18(:,:,39))
  call Hloop_TV_S(ntryL,G1H18(40),17,ex3(:),4,G2H6(24),m3h3x6(:,28),heltab2x18(:,:,40))
  call Hloop_TV_S(ntryL,G1H18(41),17,ex3(:),4,G2H6(25),m3h3x6(:,29),heltab2x18(:,:,41))
  call Hloop_TV_S(ntryL,G1H18(42),17,ex3(:),4,G2H6(26),m3h3x6(:,30),heltab2x18(:,:,42))
  call Hloop_VV_S(ntryL,G1H18(43),ex3(:),G1H6(11),m3h3x6(:,31),heltab2x18(:,:,43))
  call Hloop_VV_S(ntryL,G1H18(44),ex3(:),G1H6(12),m3h3x6(:,32),heltab2x18(:,:,44))
  call Hloop_VV_S(ntryL,G1H18(45),ex3(:),G1H6(13),m3h3x6(:,33),heltab2x18(:,:,45))
  call Hloop_VV_S(ntryL,G1H18(46),ex3(:),G1H6(14),m3h3x6(:,34),heltab2x18(:,:,46))
  call Hloop_SV_V(ntryL,G1H18(47),ex3(:),G1H6(15),m3h3x6(:,35),heltab2x18(:,:,47))
  call Hloop_SV_V(ntryL,G1H18(48),ex3(:),G1H6(16),m3h3x6(:,36),heltab2x18(:,:,48))
  call Hloop_UW_V(ntryL,G1H18(49),17,ex3(:),4,G2H6(27),m3h3x6(:,37),heltab2x18(:,:,49))
  call Hloop_UW_V(ntryL,G1H18(50),17,ex3(:),4,G2H6(28),m3h3x6(:,38),heltab2x18(:,:,50))
  call Hloop_VV_S(ntryL,G1H18(51),ex3(:),G1H6(17),m3h3x6(:,39),heltab2x18(:,:,51))
  call Hloop_VV_S(ntryL,G1H18(52),ex3(:),G1H6(18),m3h3x6(:,40),heltab2x18(:,:,52))
  call Hloop_VV_S(ntryL,G1H18(53),ex3(:),G1H6(19),m3h3x6(:,41),heltab2x18(:,:,53))
  call Hloop_VV_S(ntryL,G1H18(54),ex3(:),G1H6(20),m3h3x6(:,42),heltab2x18(:,:,54))
  call Hloop_UW_V(ntryL,G1H18(55),17,ex3(:),4,G2H6(29),m3h3x6(:,43),heltab2x18(:,:,55))
  call Hloop_UW_V(ntryL,G1H18(56),17,ex3(:),4,G2H6(30),m3h3x6(:,44),heltab2x18(:,:,56))
  call Hloop_UW_V(ntryL,G1H18(57),17,ex3(:),4,G2H6(31),m3h3x6(:,45),heltab2x18(:,:,57))
  call Hloop_UW_V(ntryL,G1H18(58),17,ex3(:),4,G2H6(32),m3h3x6(:,46),heltab2x18(:,:,58))
  call Hloop_SV_T(ntryL,G1H18(59),17,ex4(:),8,G2H6(33),m3h3x6(:,47),heltab2x18(:,:,59))
  call Hloop_SV_T(ntryL,G1H18(60),17,ex4(:),8,G2H6(34),m3h3x6(:,48),heltab2x18(:,:,60))
  call Hloop_SV_V(ntryL,G1H18(61),ex4(:),G1H6(21),m3h3x6(:,49),heltab2x18(:,:,61))
  call Hloop_SV_V(ntryL,G1H18(62),ex4(:),G1H6(22),m3h3x6(:,50),heltab2x18(:,:,62))
  call Hloop_VV_S(ntryL,G1H18(63),ex4(:),G1H6(23),m3h3x6(:,51),heltab2x18(:,:,63))
  call Hloop_UW_V(ntryL,G1H18(64),17,ex4(:),8,G2H6(35),m3h3x6(:,52),heltab2x18(:,:,64))
  call Hloop_UW_V(ntryL,G1H18(65),17,ex4(:),8,G2H6(36),m3h3x6(:,53),heltab2x18(:,:,65))
  call Hloop_TV_S(ntryL,G1H18(66),17,ex4(:),8,G2H6(37),m3h3x6(:,54),heltab2x18(:,:,66))
  call Hloop_TV_S(ntryL,G1H18(67),17,ex4(:),8,G2H6(38),m3h3x6(:,55),heltab2x18(:,:,67))
  call Hloop_TV_S(ntryL,G1H18(68),17,ex4(:),8,G2H6(39),m3h3x6(:,56),heltab2x18(:,:,68))
  call Hloop_TV_S(ntryL,G1H18(69),17,ex4(:),8,G2H6(40),m3h3x6(:,57),heltab2x18(:,:,69))
  call Hloop_SV_T(ntryL,G1H18(70),17,ex4(:),8,G2H6(41),m3h3x6(:,58),heltab2x18(:,:,70))
  call Hloop_SV_T(ntryL,G1H18(71),17,ex4(:),8,G2H6(42),m3h3x6(:,59),heltab2x18(:,:,71))
  call Hloop_SV_V(ntryL,G1H18(72),ex4(:),G1H6(24),m3h3x6(:,60),heltab2x18(:,:,72))
  call Hloop_SV_V(ntryL,G1H18(73),ex4(:),G1H6(25),m3h3x6(:,61),heltab2x18(:,:,73))
  call Hloop_SV_V(ntryL,G1H18(74),ex4(:),G1H6(26),m3h3x6(:,62),heltab2x18(:,:,74))
  call Hloop_TV_S(ntryL,G1H18(75),17,ex4(:),8,G2H6(43),m3h3x6(:,63),heltab2x18(:,:,75))
  call Hloop_TV_S(ntryL,G1H18(76),17,ex4(:),8,G2H6(44),m3h3x6(:,64),heltab2x18(:,:,76))
  call Hloop_TV_S(ntryL,G1H18(77),17,ex4(:),8,G2H6(45),m3h3x6(:,65),heltab2x18(:,:,77))
  call Hloop_TV_S(ntryL,G1H18(78),17,ex4(:),8,G2H6(46),m3h3x6(:,66),heltab2x18(:,:,78))
  call Hloop_SV_T(ntryL,G1H18(79),17,ex4(:),8,G2H6(47),m3h3x6(:,67),heltab2x18(:,:,79))
  call Hloop_VV_S(ntryL,G1H18(80),ex4(:),G1H6(27),m3h3x6(:,68),heltab2x18(:,:,80))
  call Hloop_VV_S(ntryL,G1H18(81),ex4(:),G1H6(28),m3h3x6(:,69),heltab2x18(:,:,81))
  call Hloop_VV_S(ntryL,G1H18(82),ex4(:),G1H6(29),m3h3x6(:,70),heltab2x18(:,:,82))
  call Hloop_VV_S(ntryL,G1H18(83),ex4(:),G1H6(30),m3h3x6(:,71),heltab2x18(:,:,83))
  call Hloop_VV_S(ntryL,G1H18(84),ex4(:),G1H6(31),m3h3x6(:,72),heltab2x18(:,:,84))
  call Hotf_5pt_reduction(G2H18(1),RedSet_5(1),mass5set(:,1),  & 
G1H18(1),G1H18(2),G1H18(3),G1H18(4),G1H18(5),G1H18(6),18)
  call HG1shiftOLR(G1H18(2),2,18)
  call Hloop_SV_V(ntryL,G1H18(85),ex4(:),G1H6(32),m3h3x6(:,73),heltab2x18(:,:,85))
  call Hloop_SV_V(ntryL,G1H18(86),ex4(:),G1H6(33),m3h3x6(:,74),heltab2x18(:,:,86))
  call Hloop_SV_V(ntryL,G1H18(87),ex4(:),G1H6(34),m3h3x6(:,75),heltab2x18(:,:,87))
  call Hloop_SV_V(ntryL,G1H18(88),ex4(:),G1H6(35),m3h3x6(:,76),heltab2x18(:,:,88))
  call Hloop_UV_W(ntryL,G1H18(89),17,ex4(:),8,G2H6(48),m3h3x6(:,77),heltab2x18(:,:,89))
  call Hloop_UW_V(ntryL,G1H18(90),17,ex4(:),8,G2H6(49),m3h3x6(:,78),heltab2x18(:,:,90))
  call Hloop_UV_W(ntryL,G1H18(91),17,ex4(:),8,G2H6(50),m3h3x6(:,79),heltab2x18(:,:,91))
  call Hloop_UW_V(ntryL,G1H18(92),17,ex4(:),8,G2H6(51),m3h3x6(:,80),heltab2x18(:,:,92))
  call Hloop_VV_S(ntryL,G1H18(93),ex4(:),G1H6(36),m3h3x6(:,81),heltab2x18(:,:,93))
  call Hloop_VV_S(ntryL,G1H18(94),ex4(:),G1H6(37),m3h3x6(:,82),heltab2x18(:,:,94))
  call Hloop_VV_S(ntryL,G1H18(95),ex4(:),G1H6(38),m3h3x6(:,83),heltab2x18(:,:,95))
  call Hloop_VV_S(ntryL,G1H18(96),ex4(:),G1H6(39),m3h3x6(:,84),heltab2x18(:,:,96))
  call Hloop_VV_S(ntryL,G1H18(97),ex4(:),G1H6(40),m3h3x6(:,85),heltab2x18(:,:,97))
  call Hloop_UV_W(ntryL,G1H18(98),17,ex4(:),8,G2H6(52),m3h3x6(:,86),heltab2x18(:,:,98))
  call Hloop_UV_W(ntryL,G1H18(99),17,ex4(:),8,G2H6(53),m3h3x6(:,87),heltab2x18(:,:,99))
  call Hloop_UV_W(ntryL,G1H18(100),17,ex4(:),8,G2H6(54),m3h3x6(:,88),heltab2x18(:,:,100))
  call Hloop_UV_W(ntryL,G1H18(101),17,ex4(:),8,G2H6(55),m3h3x6(:,89),heltab2x18(:,:,101))
  call Hloop_UW_V(ntryL,G1H18(102),17,ex4(:),8,G2H6(56),m3h3x6(:,90),heltab2x18(:,:,102))
  call Hloop_UW_V(ntryL,G1H18(103),17,ex4(:),8,G2H6(57),m3h3x6(:,91),heltab2x18(:,:,103))
  call Hloop_QW_A(ntryL,G1H18(1),ex4(:),G1H6(41),m3h3x6(:,92),heltab2x18(:,:,104))
  call Hloop_Q_A(ntryL,G1H6(41),25,nMT,G2H6(58),n2h6(1))
call HGT_raise_alpha_OLR(G1H18(2),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(2),2,5,18)
  call Hloop_VA_Q(ntryL,G1H18(2),ex2(:),G1H9(1),m3h2x9(:,13),heltab2x18(:,:,105))
  call Hloop_QW_A(ntryL,G1H18(4),ex4(:),G1H6(41),m3h3x6(:,93),heltab2x18(:,:,106))
  call Hloop_Q_A(ntryL,G1H6(41),25,nMT,G2H6(59),n2h6(2))
  call Hloop_QW_A(ntryL,G1H18(5),ex4(:),G1H6(41),m3h3x6(:,94),heltab2x18(:,:,107))
  call Hloop_Q_A(ntryL,G1H6(41),25,nMT,G2H6(60),n2h6(3))
  call Hloop_QW_A(ntryL,G1H18(6),ex4(:),G1H6(41),m3h3x6(:,95),heltab2x18(:,:,108))
  call Hloop_Q_A(ntryL,G1H6(41),25,nMT,G2H6(61),n2h6(4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(2),[G2H9(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(6),[G2H9(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(10),[G2H9(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(12),[G2H9(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(7),[G1H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(9),[G1H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G1H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(16),[G1H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(21),[G1H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(22),[G1H6(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(24),[G1H6(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(26),[G1H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(33),[G1H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(35),[G1H6(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(36),[G1H6(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(39),[G1H6(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(40),[G1H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(41),[G1H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(49),[G1H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(51),[G1H6(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(44),[G1H6(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(46),[G1H6(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(47),[G1H6(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(56),[G1H6(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(57),[G1H6(35)])
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(2),mass5set(:,2),  & 
G1H6(41),G1H6(1),G1H6(2),G1H6(3),G1H6(5),G1H6(9),6)
  call HG1shiftOLR(G1H6(1),8,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(2),mass5set(:,2),  & 
G1H6(13),G1H6(14),G1H6(19),G1H6(20),G1H6(23),G1H6(21),6)
  call HG1shiftOLR(G1H6(14),8,6)
  call Hotf_5pt_reduction(G2H9(2),RedSet_5(3),mass5set(:,3),  & 
G1H9(2),G1H9(3),G1H9(4),G1H9(5),G1H9(6),G1H9(7),9)
  call HG1shiftOLR(G1H9(3),8,9)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(4),mass5set(:,4),  & 
G1H6(22),G1H6(29),G1H6(30),G1H6(31),G1H6(24),G1H6(25),6)
  call HG1shiftOLR(G1H6(29),8,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(4),mass5set(:,5),  & 
G1H6(38),G1H6(39),G1H6(40),G1H6(33),G1H6(35),G1H6(42),6)
  call HG1shiftOLR(G1H6(39),8,6)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(4),mass5set(:,6),  & 
G1H6(43),G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),6)
  call HG1shiftOLR(G1H6(44),8,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(4),mass5set(:,5),  & 
G1H6(49),G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
  call HG1shiftOLR(G1H6(50),8,6)
  call Hotf_5pt_reduction(G2H9(3),RedSet_5(5),mass5set(:,7),  & 
G1H9(8),G1H9(9),G1H9(10),G1H9(11),G1H9(12),G1H9(13),9)
  call HG1shiftOLR(G1H9(9),4,9)
  call Hotf_5pt_reduction(G2H9(6),RedSet_5(5),mass5set(:,8),  & 
G1H9(14),G1H9(15),G1H9(16),G1H9(17),G1H9(18),G1H9(19),9)
  call HG1shiftOLR(G1H9(15),4,9)
  call Hotf_5pt_reduction(G2H9(5),RedSet_5(5),mass5set(:,9),  & 
G1H9(20),G1H9(21),G1H9(22),G1H9(23),G1H9(24),G1H9(25),9)
  call HG1shiftOLR(G1H9(21),4,9)
  call Hotf_5pt_reduction(G2H9(7),RedSet_5(6),mass5set(:,7),  & 
G1H9(26),G1H9(27),G1H9(28),G1H9(29),G1H9(30),G1H9(31),9)
  call HG1shiftOLR(G1H9(27),8,9)
  call Hotf_5pt_reduction(G2H9(10),RedSet_5(6),mass5set(:,8),  & 
G1H9(32),G1H9(33),G1H9(34),G1H9(35),G1H9(36),G1H9(37),9)
  call HG1shiftOLR(G1H9(33),8,9)
  call Hotf_5pt_reduction(G2H9(9),RedSet_5(6),mass5set(:,9),  & 
G1H9(38),G1H9(39),G1H9(40),G1H9(41),G1H9(42),G1H9(43),9)
  call HG1shiftOLR(G1H9(39),8,9)
  call Hotf_5pt_reduction(G2H9(12),RedSet_5(7),mass5set(:,3),  & 
G1H9(44),G1H9(45),G1H9(46),G1H9(47),G1H9(48),G1H9(49),9)
  call HG1shiftOLR(G1H9(45),4,9)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(8),mass5set(:,10),  & 
G1H6(55),G1H6(56),G1H6(57),G1H6(58),G1H6(59),G1H6(60),6)
  call HG1shiftOLR(G1H6(56),8,6)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(8),mass5set(:,11),  & 
G1H6(61),G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),6)
  call HG1shiftOLR(G1H6(62),8,6)
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(8),mass5set(:,12),  & 
G1H6(67),G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(68),8,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(8),mass5set(:,11),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),G1H6(78),6)
  call HG1shiftOLR(G1H6(74),8,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(9),mass5set(:,13),  & 
G1H6(79),G1H6(80),G1H6(81),G1H6(82),G1H6(83),G1H6(84),6)
  call HG1shiftOLR(G1H6(80),4,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(9),mass5set(:,14),  & 
G1H6(85),G1H6(86),G1H6(87),G1H6(88),G1H6(89),G1H6(90),6)
  call HG1shiftOLR(G1H6(86),4,6)
  call Hloop_SQ_A(ntryL,G1H6(4),ex1(:),G1H3(1),ngPtb,m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(1),n2h3(1))
  call Hloop_WQ_A(ntryL,G1H6(6),ex1(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(2),n2h3(2))
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(9),mass5set(:,15),  & 
G1H6(4),G1H6(6),G1H6(91),G1H6(92),G1H6(93),G1H6(94),6)
  call HG1shiftOLR(G1H6(6),4,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(9),mass5set(:,14),  & 
G1H6(95),G1H6(96),G1H6(97),G1H6(98),G1H6(99),G1H6(100),6)
  call HG1shiftOLR(G1H6(96),4,6)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(10),mass5set(:,13),  & 
G1H6(101),G1H6(102),G1H6(103),G1H6(104),G1H6(105),G1H6(106),6)
  call HG1shiftOLR(G1H6(102),8,6)
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(10),mass5set(:,14),  & 
G1H6(107),G1H6(108),G1H6(109),G1H6(110),G1H6(111),G1H6(112),6)
  call HG1shiftOLR(G1H6(108),8,6)
  call Hloop_WA_Q(ntryL,G1H6(7),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(3),n2h3(3))
  call Hloop_SA_Q(ntryL,G1H6(8),ex2(:),G1H3(1),ngPbt,m3h2x3(:,4),heltab2x6(:,:,4))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(4),n2h3(4))
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(10),mass5set(:,15),  & 
G1H6(7),G1H6(8),G1H6(113),G1H6(114),G1H6(115),G1H6(116),6)
  call HG1shiftOLR(G1H6(8),8,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(10),mass5set(:,14),  & 
G1H6(117),G1H6(118),G1H6(119),G1H6(120),G1H6(121),G1H6(122),6)
  call HG1shiftOLR(G1H6(118),8,6)
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(11),mass5set(:,16),  & 
G1H6(123),G1H6(124),G1H6(125),G1H6(126),G1H6(127),G1H6(128),6)
  call HG1shiftOLR(G1H6(124),2,6)
  call Hotf_5pt_reduction(G2H6(20),RedSet_5(11),mass5set(:,17),  & 
G1H6(129),G1H6(130),G1H6(131),G1H6(132),G1H6(133),G1H6(134),6)
  call HG1shiftOLR(G1H6(130),2,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(11),mass5set(:,18),  & 
G1H6(135),G1H6(136),G1H6(137),G1H6(138),G1H6(139),G1H6(140),6)
  call HG1shiftOLR(G1H6(136),2,6)
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(11),mass5set(:,19),  & 
G1H6(141),G1H6(142),G1H6(143),G1H6(144),G1H6(145),G1H6(146),6)
  call HG1shiftOLR(G1H6(142),2,6)
  call Hloop_VV_S(ntryL,G1H6(10),ex4(:),G1H2(1),m3h3x2(:,1),heltab2x6(:,:,5))
  call Hloop_SV_V(ntryL,G2H6(23),ex4(:),G2H2(1),m3h3x2(:,2),heltab2x6(:,:,6))
  call Hloop_SV_V(ntryL,G2H6(24),ex4(:),G2H2(2),m3h3x2(:,3),heltab2x6(:,:,7))
  call Hloop_SV_V(ntryL,G2H6(25),ex4(:),G2H2(3),m3h3x2(:,4),heltab2x6(:,:,8))
  call Hloop_SV_V(ntryL,G2H6(26),ex4(:),G2H2(4),m3h3x2(:,5),heltab2x6(:,:,9))
  call Hloop_SV_T(ntryL,G1H6(11),21,ex4(:),8,G2H2(5),m3h3x2(:,6),heltab2x6(:,:,10))
  call Hloop_SV_T(ntryL,G1H6(12),21,ex4(:),8,G2H2(6),m3h3x2(:,7),heltab2x6(:,:,11))
  call Hloop_UW_V(ntryL,G1H6(15),21,ex4(:),8,G2H2(7),m3h3x2(:,8),heltab2x6(:,:,12))
  call Hloop_UW_V(ntryL,G1H6(16),21,ex4(:),8,G2H2(8),m3h3x2(:,9),heltab2x6(:,:,13))
  call Hloop_VV_S(ntryL,G2H6(27),ex4(:),G2H2(9),m3h3x2(:,10),heltab2x6(:,:,14))
  call Hloop_VV_S(ntryL,G2H6(28),ex4(:),G2H2(10),m3h3x2(:,11),heltab2x6(:,:,15))
  call Hloop_SV_V(ntryL,G1H6(17),ex4(:),G1H2(2),m3h3x2(:,12),heltab2x6(:,:,16))
  call Hloop_SV_V(ntryL,G1H6(18),ex4(:),G1H2(3),m3h3x2(:,13),heltab2x6(:,:,17))
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(11),mass5set(:,20),  & 
G1H6(10),G1H6(11),G1H6(12),G1H6(15),G1H6(16),G1H6(17),6)
  call HG1shiftOLR(G1H6(11),2,6)
  call Hotf_5pt_reduction(G2H6(30),RedSet_5(11),mass5set(:,21),  & 
G1H6(18),G1H6(147),G1H6(148),G1H6(149),G1H6(150),G1H6(151),6)
  call HG1shiftOLR(G1H6(147),2,6)
  call Hotf_5pt_reduction(G2H6(31),RedSet_5(11),mass5set(:,22),  & 
G1H6(152),G1H6(153),G1H6(154),G1H6(155),G1H6(156),G1H6(157),6)
  call HG1shiftOLR(G1H6(153),2,6)
  call Hotf_5pt_reduction(G2H6(32),RedSet_5(11),mass5set(:,19),  & 
G1H6(158),G1H6(159),G1H6(160),G1H6(161),G1H6(162),G1H6(163),6)
  call HG1shiftOLR(G1H6(159),2,6)
  call Hotf_5pt_reduction(G2H6(33),RedSet_5(12),mass5set(:,10),  & 
G1H6(164),G1H6(165),G1H6(166),G1H6(167),G1H6(168),G1H6(169),6)
  call HG1shiftOLR(G1H6(165),4,6)
  call Hotf_5pt_reduction(G2H6(34),RedSet_5(12),mass5set(:,11),  & 
G1H6(170),G1H6(171),G1H6(172),G1H6(173),G1H6(174),G1H6(175),6)
  call HG1shiftOLR(G1H6(171),4,6)
  call Hotf_5pt_reduction(G2H6(35),RedSet_5(12),mass5set(:,12),  & 
G1H6(176),G1H6(177),G1H6(178),G1H6(179),G1H6(180),G1H6(181),6)
  call HG1shiftOLR(G1H6(177),4,6)
  call Hotf_5pt_reduction(G2H6(36),RedSet_5(12),mass5set(:,11),  & 
G1H6(182),G1H6(183),G1H6(184),G1H6(185),G1H6(186),G1H6(187),6)
  call HG1shiftOLR(G1H6(183),4,6)
  call Hotf_5pt_reduction(G2H6(37),RedSet_5(1),mass5set(:,16),  & 
G1H6(188),G1H6(189),G1H6(190),G1H6(191),G1H6(192),G1H6(193),6)
  call HG1shiftOLR(G1H6(189),2,6)
  call Hotf_5pt_reduction(G2H6(38),RedSet_5(1),mass5set(:,17),  & 
G1H6(194),G1H6(195),G1H6(196),G1H6(197),G1H6(198),G1H6(199),6)
  call HG1shiftOLR(G1H6(195),2,6)
  call Hotf_5pt_reduction(G2H6(39),RedSet_5(1),mass5set(:,18),  & 
G1H6(200),G1H6(201),G1H6(202),G1H6(203),G1H6(204),G1H6(205),6)
  call HG1shiftOLR(G1H6(201),2,6)
  call Hotf_5pt_reduction(G2H6(40),RedSet_5(1),mass5set(:,19),  & 
G1H6(206),G1H6(207),G1H6(208),G1H6(209),G1H6(210),G1H6(211),6)
  call HG1shiftOLR(G1H6(207),2,6)
  call Hotf_5pt_reduction(G2H6(41),RedSet_5(1),mass5set(:,23),  & 
G1H6(212),G1H6(213),G1H6(214),G1H6(215),G1H6(216),G1H6(217),6)
  call HG1shiftOLR(G1H6(213),2,6)
  call Hotf_5pt_reduction(G2H6(42),RedSet_5(1),mass5set(:,24),  & 
G1H6(218),G1H6(219),G1H6(220),G1H6(221),G1H6(222),G1H6(223),6)
  call HG1shiftOLR(G1H6(219),2,6)
  call Hloop_VV_S(ntryL,G2H6(49),ex3(:),G2H2(11),m3h3x2(:,14),heltab2x6(:,:,18))
  call Hloop_VV_S(ntryL,G2H6(51),ex3(:),G2H2(12),m3h3x2(:,15),heltab2x6(:,:,19))
  call Hloop_VV_S(ntryL,G1H6(26),ex3(:),G1H2(4),m3h3x2(:,16),heltab2x6(:,:,20))
  call Hloop_SV_V(ntryL,G2H6(43),ex3(:),G2H2(13),m3h3x2(:,17),heltab2x6(:,:,21))
  call Hloop_SV_V(ntryL,G2H6(44),ex3(:),G2H2(14),m3h3x2(:,18),heltab2x6(:,:,22))
  call Hloop_SV_V(ntryL,G2H6(45),ex3(:),G2H2(15),m3h3x2(:,19),heltab2x6(:,:,23))
  call Hloop_SV_V(ntryL,G2H6(46),ex3(:),G2H2(16),m3h3x2(:,20),heltab2x6(:,:,24))
  call Hloop_SV_V(ntryL,G2H6(47),ex3(:),G2H2(17),m3h3x2(:,21),heltab2x6(:,:,25))
  call Hloop_SV_T(ntryL,G1H6(27),25,ex3(:),4,G2H2(18),m3h3x2(:,22),heltab2x6(:,:,26))
  call Hloop_SV_T(ntryL,G1H6(28),25,ex3(:),4,G2H2(19),m3h3x2(:,23),heltab2x6(:,:,27))
  call Hloop_UV_W(ntryL,G1H6(32),25,ex3(:),4,G2H2(20),m3h3x2(:,24),heltab2x6(:,:,28))
  call Hotf_5pt_reduction(G2H6(56),RedSet_5(1),mass5set(:,25),  & 
G1H6(26),G1H6(27),G1H6(28),G1H6(32),G1H6(224),G1H6(225),6)
  call HG1shiftOLR(G1H6(27),2,6)
  call Hloop_UV_W(ntryL,G1H6(34),25,ex3(:),4,G2H2(21),m3h3x2(:,25),heltab2x6(:,:,29))
  call Hotf_5pt_reduction(G2H6(57),RedSet_5(1),mass5set(:,24),  & 
G1H6(34),G1H6(226),G1H6(227),G1H6(228),G1H6(229),G1H6(230),6)
  call HG1shiftOLR(G1H6(226),2,6)
  call Hloop_VV_S(ntryL,G2H6(48),ex3(:),G2H2(22),m3h3x2(:,26),heltab2x6(:,:,30))
  call Hloop_VV_S(ntryL,G2H6(50),ex3(:),G2H2(23),m3h3x2(:,27),heltab2x6(:,:,31))
  call Hloop_SV_V(ntryL,G1H6(36),ex3(:),G1H2(5),m3h3x2(:,28),heltab2x6(:,:,32))
  call Hloop_SV_V(ntryL,G1H6(37),ex3(:),G1H2(6),m3h3x2(:,29),heltab2x6(:,:,33))
  call Hotf_5pt_reduction(G2H6(52),RedSet_5(1),mass5set(:,20),  & 
G1H6(36),G1H6(37),G1H6(231),G1H6(232),G1H6(233),G1H6(234),6)
  call HG1shiftOLR(G1H6(37),2,6)
  call Hotf_5pt_reduction(G2H6(53),RedSet_5(1),mass5set(:,21),  & 
G1H6(235),G1H6(236),G1H6(237),G1H6(238),G1H6(239),G1H6(240),6)
  call HG1shiftOLR(G1H6(236),2,6)
  call Hotf_5pt_reduction(G2H6(54),RedSet_5(1),mass5set(:,22),  & 
G1H6(241),G1H6(242),G1H6(243),G1H6(244),G1H6(245),G1H6(246),6)
  call HG1shiftOLR(G1H6(242),2,6)
  call Hotf_5pt_reduction(G2H6(55),RedSet_5(1),mass5set(:,19),  & 
G1H6(247),G1H6(248),G1H6(249),G1H6(250),G1H6(251),G1H6(252),6)
  call HG1shiftOLR(G1H6(248),2,6)
  call Hotf_5pt_reduction(G2H6(58),RedSet_5(1),mass5set(:,1),  & 
G1H6(253),G1H6(254),G1H6(255),G1H6(256),G1H6(257),G1H6(258),6)
  call HG1shiftOLR(G1H6(254),2,6)
  call Hotf_4pt_reduction(G2H6(60),RedSet_4(1),mass4set(:,1),  & 
G1H6(259),G1H6(260),G1H6(261),G1H6(262),G1H6(263),6)
  call HG1shiftOLR(G1H6(260),2,6)
  call Hotf_4pt_reduction(G2H6(61),RedSet_4(2),mass4set(:,2),  & 
G1H6(264),G1H6(265),G1H6(266),G1H6(267),G1H6(268),6)
  call HG1shiftOLR(G1H6(265),6,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(259),[G1H6(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(264),[G1H6(258)])
  call Hloop_SA_Q(ntryL,G1H6(41),ex2(:),G1H3(1),ngPbt,m3h2x3(:,5),heltab2x6(:,:,34))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(5),n2h3(5))
call HGT_OLR(G1H6(1),1,1,6)
call HGT_invQ_OLR(G1H6(1),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(1),-8,nMB,G2H6(1),n2h6(5))
  call Hloop_QW_A(ntryL,G2H6(1),ex4(:),G2H2(24),m3h3x2(:,30),heltab2x6(:,:,35))
  call Hloop_SA_Q(ntryL,G1H6(5),ex2(:),G1H3(1),ngPbt,m3h2x3(:,6),heltab2x6(:,:,36))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(6),n2h3(6))
  call Hloop_SA_Q(ntryL,G1H6(9),ex2(:),G1H3(1),ngPbt,m3h2x3(:,7),heltab2x6(:,:,37))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(7),n2h3(7))
  call Hloop_WA_Q(ntryL,G1H6(13),ex2(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,38))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(8),n2h3(8))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(14),-8,nMB,G2H6(2),n2h6(6))
  call Hloop_QW_A(ntryL,G2H6(2),ex4(:),G2H2(25),m3h3x2(:,31),heltab2x6(:,:,39))
  call Hloop_WA_Q(ntryL,G1H6(23),ex2(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,40))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(9),n2h3(9))
  call Hloop_WA_Q(ntryL,G1H6(21),ex2(:),G1H3(1),m3h2x3(:,10),heltab2x6(:,:,41))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(10),n2h3(10))
  call Hloop_QW_A(ntryL,G1H9(2),ex3(:),G1H3(1),m3h3x3(:,1),heltab2x9(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(11),n2h3(11))
call HGT_OLR(G1H9(3),1,1,9)
call HGT_invQ_OLR(G1H9(3),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(3),-8,nMT,G2H9(1),n2h9(13))
  call Hloop_AW_Q(ntryL,G2H9(1),ex4(:),G2H3(12),m3h3x3(:,2),heltab2x9(:,:,2))
  call Hloop_QW_A(ntryL,G1H9(6),ex3(:),G1H3(1),m3h3x3(:,3),heltab2x9(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(13),n2h3(12))
  call Hloop_QW_A(ntryL,G1H9(7),ex3(:),G1H3(1),m3h3x3(:,4),heltab2x9(:,:,4))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(14),n2h3(13))
  call Hloop_SQ_A(ntryL,G1H6(22),ex1(:),G1H3(1),ngH,m3h2x3(:,11),heltab2x6(:,:,42))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(15),n2h3(14))
call HGT_OLR(G1H6(29),1,1,6)
call HGT_invQ_OLR(G1H6(29),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(29),-8,nMT,G2H6(3),n2h6(7))
  call Hloop_AW_Q(ntryL,G2H6(3),ex4(:),G2H2(26),m3h3x2(:,32),heltab2x6(:,:,43))
  call Hloop_SQ_A(ntryL,G1H6(24),ex1(:),G1H3(1),ngH,m3h2x3(:,12),heltab2x6(:,:,44))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(16),n2h3(15))
  call Hloop_SQ_A(ntryL,G1H6(25),ex1(:),G1H3(1),ngH,m3h2x3(:,13),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(17),n2h3(16))
  call Hloop_SQ_A(ntryL,G1H6(38),ex1(:),G1H3(1),ngX,m3h2x3(:,14),heltab2x6(:,:,46))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(18),n2h3(17))
call HGT_OLR(G1H6(39),1,1,6)
call HGT_invQ_OLR(G1H6(39),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(39),-8,nMT,G2H6(4),n2h6(8))
  call Hloop_AW_Q(ntryL,G2H6(4),ex4(:),G2H2(27),m3h3x2(:,33),heltab2x6(:,:,47))
  call Hloop_SQ_A(ntryL,G1H6(35),ex1(:),G1H3(1),ngX,m3h2x3(:,15),heltab2x6(:,:,48))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(19),n2h3(18))
  call Hloop_SQ_A(ntryL,G1H6(42),ex1(:),G1H3(1),ngX,m3h2x3(:,16),heltab2x6(:,:,49))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(20),n2h3(19))
  call Hloop_VQ_A(ntryL,G1H6(43),ex1(:),G1H3(1),m3h2x3(:,17),heltab2x6(:,:,50))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(21),n2h3(20))
call HGT_OLR(G1H6(44),1,1,6)
call HGT_invQ_OLR(G1H6(44),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(44),-8,nMT,G2H6(5),n2h6(9))
  call Hloop_AW_Q(ntryL,G2H6(5),ex4(:),G2H2(28),m3h3x2(:,34),heltab2x6(:,:,51))
  call Hloop_VQ_A(ntryL,G1H6(47),ex1(:),G1H3(1),m3h2x3(:,18),heltab2x6(:,:,52))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(22),n2h3(21))
  call Hloop_VQ_A(ntryL,G1H6(48),ex1(:),G1H3(1),m3h2x3(:,19),heltab2x6(:,:,53))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(23),n2h3(22))
  call Hloop_ZQ_A(ntryL,G1H6(49),ex1(:),G1H3(1),ngZd,m3h2x3(:,20),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(24),n2h3(23))
call HGT_OLR(G1H6(50),1,1,6)
call HGT_invQ_OLR(G1H6(50),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(50),-8,nMT,G2H6(6),n2h6(10))
  call Hloop_AW_Q(ntryL,G2H6(6),ex4(:),G2H2(29),m3h3x2(:,35),heltab2x6(:,:,55))
  call Hloop_ZQ_A(ntryL,G1H6(53),ex1(:),G1H3(1),ngZd,m3h2x3(:,21),heltab2x6(:,:,56))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(25),n2h3(24))
  call Hloop_ZQ_A(ntryL,G1H6(54),ex1(:),G1H3(1),ngZd,m3h2x3(:,22),heltab2x6(:,:,57))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(26),n2h3(25))
  call Hloop_QW_A(ntryL,G1H9(8),ex4(:),G1H3(1),m3h3x3(:,5),heltab2x9(:,:,5))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(27),n2h3(26))
call HGT_OLR(G1H9(9),1,1,9)
call HGT_invQ_OLR(G1H9(9),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(9),-4,nMB,G2H9(4),n2h9(14))
  call Hloop_AW_Q(ntryL,G2H9(4),ex3(:),G2H3(28),m3h3x3(:,6),heltab2x9(:,:,6))
  call Hloop_QW_A(ntryL,G1H9(12),ex4(:),G1H3(1),m3h3x3(:,7),heltab2x9(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(29),n2h3(27))
  call Hloop_QW_A(ntryL,G1H9(13),ex4(:),G1H3(1),m3h3x3(:,8),heltab2x9(:,:,8))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(30),n2h3(28))
  call Hloop_QW_A(ntryL,G1H9(14),ex4(:),G1H3(1),m3h3x3(:,9),heltab2x9(:,:,9))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(31),n2h3(29))
call HGT_OLR(G1H9(15),1,1,9)
call HGT_invQ_OLR(G1H9(15),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(15),-4,nMB,G2H9(8),n2h9(15))
  call Hloop_AW_Q(ntryL,G2H9(8),ex3(:),G2H3(32),m3h3x3(:,10),heltab2x9(:,:,10))
  call Hloop_QW_A(ntryL,G1H9(18),ex4(:),G1H3(1),m3h3x3(:,11),heltab2x9(:,:,11))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(33),n2h3(30))
  call Hloop_QW_A(ntryL,G1H9(19),ex4(:),G1H3(1),m3h3x3(:,12),heltab2x9(:,:,12))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(34),n2h3(31))
  call Hloop_QW_A(ntryL,G1H9(20),ex4(:),G1H3(1),m3h3x3(:,13),heltab2x9(:,:,13))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(35),n2h3(32))
call HGT_OLR(G1H9(21),1,1,9)
call HGT_invQ_OLR(G1H9(21),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(21),-4,nMB,G2H9(11),n2h9(16))
  call Hloop_AW_Q(ntryL,G2H9(11),ex3(:),G2H3(36),m3h3x3(:,14),heltab2x9(:,:,14))
  call Hloop_QW_A(ntryL,G1H9(24),ex4(:),G1H3(1),m3h3x3(:,15),heltab2x9(:,:,15))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(37),n2h3(33))
  call Hloop_QW_A(ntryL,G1H9(25),ex4(:),G1H3(1),m3h3x3(:,16),heltab2x9(:,:,16))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(38),n2h3(34))
  call Hloop_AW_Q(ntryL,G1H9(26),ex3(:),G1H3(1),m3h3x3(:,17),heltab2x9(:,:,17))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(39),n2h3(35))
call HGT_OLR(G1H9(27),1,1,9)
call HGT_invQ_OLR(G1H9(27),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(27),-8,nMB,G2H9(2),n2h9(17))
  call Hloop_QW_A(ntryL,G2H9(2),ex4(:),G2H3(40),m3h3x3(:,18),heltab2x9(:,:,18))
  call Hloop_AW_Q(ntryL,G1H9(30),ex3(:),G1H3(1),m3h3x3(:,19),heltab2x9(:,:,19))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(41),n2h3(36))
  call Hloop_AW_Q(ntryL,G1H9(31),ex3(:),G1H3(1),m3h3x3(:,20),heltab2x9(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(42),n2h3(37))
  call Hloop_AW_Q(ntryL,G1H9(32),ex3(:),G1H3(1),m3h3x3(:,21),heltab2x9(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(43),n2h3(38))
call HGT_OLR(G1H9(33),1,1,9)
call HGT_invQ_OLR(G1H9(33),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(33),-8,nMB,G2H9(3),n2h9(18))
  call Hloop_QW_A(ntryL,G2H9(3),ex4(:),G2H3(44),m3h3x3(:,22),heltab2x9(:,:,22))
  call Hloop_AW_Q(ntryL,G1H9(36),ex3(:),G1H3(1),m3h3x3(:,23),heltab2x9(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(45),n2h3(39))
  call Hloop_AW_Q(ntryL,G1H9(37),ex3(:),G1H3(1),m3h3x3(:,24),heltab2x9(:,:,24))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(46),n2h3(40))
  call Hloop_AW_Q(ntryL,G1H9(38),ex3(:),G1H3(1),m3h3x3(:,25),heltab2x9(:,:,25))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(47),n2h3(41))
call HGT_OLR(G1H9(39),1,1,9)
call HGT_invQ_OLR(G1H9(39),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(39),-8,nMB,G2H9(6),n2h9(19))
  call Hloop_QW_A(ntryL,G2H9(6),ex4(:),G2H3(48),m3h3x3(:,26),heltab2x9(:,:,26))
  call Hloop_AW_Q(ntryL,G1H9(42),ex3(:),G1H3(1),m3h3x3(:,27),heltab2x9(:,:,27))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(49),n2h3(42))
  call Hloop_AW_Q(ntryL,G1H9(43),ex3(:),G1H3(1),m3h3x3(:,28),heltab2x9(:,:,28))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(50),n2h3(43))
  call Hloop_AW_Q(ntryL,G1H9(44),ex4(:),G1H3(1),m3h3x3(:,29),heltab2x9(:,:,29))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(51),n2h3(44))
call HGT_OLR(G1H9(45),1,1,9)
call HGT_invQ_OLR(G1H9(45),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(45),-4,nMT,G2H9(5),n2h9(20))
  call Hloop_QW_A(ntryL,G2H9(5),ex3(:),G2H3(52),m3h3x3(:,30),heltab2x9(:,:,30))
  call Hloop_AW_Q(ntryL,G1H9(48),ex4(:),G1H3(1),m3h3x3(:,31),heltab2x9(:,:,31))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(53),n2h3(45))
  call Hloop_AW_Q(ntryL,G1H9(49),ex4(:),G1H3(1),m3h3x3(:,32),heltab2x9(:,:,32))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(54),n2h3(46))
  call Hloop_SQ_A(ntryL,G1H6(55),ex1(:),G1H3(1),ngH,m3h2x3(:,23),heltab2x6(:,:,58))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(55),n2h3(47))
call HGT_OLR(G1H6(56),1,1,6)
call HGT_invQ_OLR(G1H6(56),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(56),-8,nMT,G2H6(7),n2h6(11))
  call Hloop_AW_Q(ntryL,G2H6(7),ex4(:),G2H2(30),m3h3x2(:,36),heltab2x6(:,:,59))
  call Hloop_SQ_A(ntryL,G1H6(59),ex1(:),G1H3(1),ngH,m3h2x3(:,24),heltab2x6(:,:,60))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(56),n2h3(48))
  call Hloop_SQ_A(ntryL,G1H6(60),ex1(:),G1H3(1),ngH,m3h2x3(:,25),heltab2x6(:,:,61))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(57),n2h3(49))
  call Hloop_SQ_A(ntryL,G1H6(61),ex1(:),G1H3(1),ngX,m3h2x3(:,26),heltab2x6(:,:,62))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(58),n2h3(50))
call HGT_OLR(G1H6(62),1,1,6)
call HGT_invQ_OLR(G1H6(62),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(62),-8,nMT,G2H6(8),n2h6(12))
  call Hloop_AW_Q(ntryL,G2H6(8),ex4(:),G2H2(31),m3h3x2(:,37),heltab2x6(:,:,63))
  call Hloop_SQ_A(ntryL,G1H6(65),ex1(:),G1H3(1),ngX,m3h2x3(:,27),heltab2x6(:,:,64))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(59),n2h3(51))
  call Hloop_SQ_A(ntryL,G1H6(66),ex1(:),G1H3(1),ngX,m3h2x3(:,28),heltab2x6(:,:,65))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(60),n2h3(52))
  call Hloop_VQ_A(ntryL,G1H6(67),ex1(:),G1H3(1),m3h2x3(:,29),heltab2x6(:,:,66))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(61),n2h3(53))
call HGT_OLR(G1H6(68),1,1,6)
call HGT_invQ_OLR(G1H6(68),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(68),-8,nMT,G2H6(9),n2h6(13))
  call Hloop_AW_Q(ntryL,G2H6(9),ex4(:),G2H2(32),m3h3x2(:,38),heltab2x6(:,:,67))
  call Hloop_VQ_A(ntryL,G1H6(71),ex1(:),G1H3(1),m3h2x3(:,30),heltab2x6(:,:,68))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(62),n2h3(54))
  call Hloop_VQ_A(ntryL,G1H6(72),ex1(:),G1H3(1),m3h2x3(:,31),heltab2x6(:,:,69))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(63),n2h3(55))
  call Hloop_ZQ_A(ntryL,G1H6(73),ex1(:),G1H3(1),ngZd,m3h2x3(:,32),heltab2x6(:,:,70))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(64),n2h3(56))
call HGT_OLR(G1H6(74),1,1,6)
call HGT_invQ_OLR(G1H6(74),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(74),-8,nMT,G2H6(10),n2h6(14))
  call Hloop_AW_Q(ntryL,G2H6(10),ex4(:),G2H2(33),m3h3x2(:,39),heltab2x6(:,:,71))
  call Hloop_ZQ_A(ntryL,G1H6(77),ex1(:),G1H3(1),ngZd,m3h2x3(:,33),heltab2x6(:,:,72))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(65),n2h3(57))
  call Hloop_ZQ_A(ntryL,G1H6(78),ex1(:),G1H3(1),ngZd,m3h2x3(:,34),heltab2x6(:,:,73))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(66),n2h3(58))
  call Hloop_SQ_A(ntryL,G1H6(79),ex1(:),G1H3(1),ngPtb,m3h2x3(:,35),heltab2x6(:,:,74))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(67),n2h3(59))
call HGT_OLR(G1H6(80),1,1,6)
call HGT_invQ_OLR(G1H6(80),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(80),-4,nMB,G2H6(11),n2h6(15))
  call Hloop_AW_Q(ntryL,G2H6(11),ex3(:),G2H2(34),m3h3x2(:,40),heltab2x6(:,:,75))
  call Hloop_SQ_A(ntryL,G1H6(83),ex1(:),G1H3(1),ngPtb,m3h2x3(:,36),heltab2x6(:,:,76))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(68),n2h3(60))
  call Hloop_SQ_A(ntryL,G1H6(84),ex1(:),G1H3(1),ngPtb,m3h2x3(:,37),heltab2x6(:,:,77))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(69),n2h3(61))
  call Hloop_SQ_A(ntryL,G1H6(85),ex1(:),G1H3(1),ngPtb,m3h2x3(:,38),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(70),n2h3(62))
call HGT_OLR(G1H6(86),1,1,6)
call HGT_invQ_OLR(G1H6(86),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(86),-4,nMB,G2H6(12),n2h6(16))
  call Hloop_AW_Q(ntryL,G2H6(12),ex3(:),G2H2(35),m3h3x2(:,41),heltab2x6(:,:,79))
  call Hloop_SQ_A(ntryL,G1H6(89),ex1(:),G1H3(1),ngPtb,m3h2x3(:,39),heltab2x6(:,:,80))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(71),n2h3(63))
  call Hloop_SQ_A(ntryL,G1H6(90),ex1(:),G1H3(1),ngPtb,m3h2x3(:,40),heltab2x6(:,:,81))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(72),n2h3(64))
  call Hloop_WQ_A(ntryL,G1H6(4),ex1(:),G1H3(1),m3h2x3(:,41),heltab2x6(:,:,82))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(73),n2h3(65))
call HGT_OLR(G1H6(6),1,1,6)
call HGT_invQ_OLR(G1H6(6),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(6),-4,nMB,G2H6(13),n2h6(17))
  call Hloop_AW_Q(ntryL,G2H6(13),ex3(:),G2H2(36),m3h3x2(:,42),heltab2x6(:,:,83))
  call Hloop_WQ_A(ntryL,G1H6(93),ex1(:),G1H3(1),m3h2x3(:,42),heltab2x6(:,:,84))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(74),n2h3(66))
  call Hloop_WQ_A(ntryL,G1H6(94),ex1(:),G1H3(1),m3h2x3(:,43),heltab2x6(:,:,85))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(75),n2h3(67))
  call Hloop_WQ_A(ntryL,G1H6(95),ex1(:),G1H3(1),m3h2x3(:,44),heltab2x6(:,:,86))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(76),n2h3(68))
call HGT_OLR(G1H6(96),1,1,6)
call HGT_invQ_OLR(G1H6(96),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(96),-4,nMB,G2H6(14),n2h6(18))
  call Hloop_AW_Q(ntryL,G2H6(14),ex3(:),G2H2(37),m3h3x2(:,43),heltab2x6(:,:,87))
  call Hloop_WQ_A(ntryL,G1H6(99),ex1(:),G1H3(1),m3h2x3(:,45),heltab2x6(:,:,88))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(77),n2h3(69))
  call Hloop_WQ_A(ntryL,G1H6(100),ex1(:),G1H3(1),m3h2x3(:,46),heltab2x6(:,:,89))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(78),n2h3(70))
  call Hloop_SA_Q(ntryL,G1H6(101),ex2(:),G1H3(1),ngPbt,m3h2x3(:,47),heltab2x6(:,:,90))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(79),n2h3(71))
call HGT_OLR(G1H6(102),1,1,6)
call HGT_invQ_OLR(G1H6(102),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(102),-8,nMB,G2H6(15),n2h6(19))
  call Hloop_QW_A(ntryL,G2H6(15),ex4(:),G2H2(38),m3h3x2(:,44),heltab2x6(:,:,91))
  call Hloop_SA_Q(ntryL,G1H6(105),ex2(:),G1H3(1),ngPbt,m3h2x3(:,48),heltab2x6(:,:,92))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(80),n2h3(72))
  call Hloop_SA_Q(ntryL,G1H6(106),ex2(:),G1H3(1),ngPbt,m3h2x3(:,49),heltab2x6(:,:,93))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(81),n2h3(73))
  call Hloop_SA_Q(ntryL,G1H6(107),ex2(:),G1H3(1),ngPbt,m3h2x3(:,50),heltab2x6(:,:,94))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(82),n2h3(74))
call HGT_OLR(G1H6(108),1,1,6)
call HGT_invQ_OLR(G1H6(108),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(108),-8,nMB,G2H6(16),n2h6(20))
  call Hloop_QW_A(ntryL,G2H6(16),ex4(:),G2H2(39),m3h3x2(:,45),heltab2x6(:,:,95))
  call Hloop_SA_Q(ntryL,G1H6(111),ex2(:),G1H3(1),ngPbt,m3h2x3(:,51),heltab2x6(:,:,96))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(83),n2h3(75))
  call Hloop_SA_Q(ntryL,G1H6(112),ex2(:),G1H3(1),ngPbt,m3h2x3(:,52),heltab2x6(:,:,97))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(84),n2h3(76))
  call Hloop_WA_Q(ntryL,G1H6(7),ex2(:),G1H3(1),m3h2x3(:,53),heltab2x6(:,:,98))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(85),n2h3(77))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(8),-8,nMB,G2H6(17),n2h6(21))
  call Hloop_QW_A(ntryL,G2H6(17),ex4(:),G2H2(40),m3h3x2(:,46),heltab2x6(:,:,99))
  call Hloop_WA_Q(ntryL,G1H6(115),ex2(:),G1H3(1),m3h2x3(:,54),heltab2x6(:,:,100))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(86),n2h3(78))
  call Hloop_WA_Q(ntryL,G1H6(116),ex2(:),G1H3(1),m3h2x3(:,55),heltab2x6(:,:,101))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(87),n2h3(79))
  call Hloop_WA_Q(ntryL,G1H6(117),ex2(:),G1H3(1),m3h2x3(:,56),heltab2x6(:,:,102))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(88),n2h3(80))
call HGT_OLR(G1H6(118),1,1,6)
call HGT_invQ_OLR(G1H6(118),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(118),-8,nMB,G2H6(18),n2h6(22))
  call Hloop_QW_A(ntryL,G2H6(18),ex4(:),G2H2(41),m3h3x2(:,47),heltab2x6(:,:,103))
  call Hloop_WA_Q(ntryL,G1H6(121),ex2(:),G1H3(1),m3h2x3(:,57),heltab2x6(:,:,104))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(89),n2h3(81))
  call Hloop_WA_Q(ntryL,G1H6(122),ex2(:),G1H3(1),m3h2x3(:,58),heltab2x6(:,:,105))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(90),n2h3(82))
  call Hloop_SV_T(ntryL,G1H6(123),21,ex4(:),8,G2H2(42),m3h3x2(:,48),heltab2x6(:,:,106))
call HGT_OLR(G1H6(124),1,1,6)
call HGT_invQ_OLR(G1H6(124),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(124),-2,nMB,G2H6(19),n2h6(23))
  call Hloop_QA_S(ntryL,G2H6(19),ex2(:),G2H3(91),ngH,m3h2x3(:,59),heltab2x6(:,:,107))
  call Hloop_SV_T(ntryL,G1H6(127),21,ex4(:),8,G2H2(43),m3h3x2(:,49),heltab2x6(:,:,108))
  call Hloop_SV_T(ntryL,G1H6(128),21,ex4(:),8,G2H2(44),m3h3x2(:,50),heltab2x6(:,:,109))
  call Hloop_SV_T(ntryL,G1H6(129),21,ex4(:),8,G2H2(45),m3h3x2(:,51),heltab2x6(:,:,110))
call HGT_OLR(G1H6(130),1,1,6)
call HGT_invQ_OLR(G1H6(130),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(130),-2,nMB,G2H6(20),n2h6(24))
  call Hloop_QA_S(ntryL,G2H6(20),ex2(:),G2H3(92),ngX,m3h2x3(:,60),heltab2x6(:,:,111))
  call Hloop_SV_T(ntryL,G1H6(133),21,ex4(:),8,G2H2(46),m3h3x2(:,52),heltab2x6(:,:,112))
  call Hloop_SV_T(ntryL,G1H6(134),21,ex4(:),8,G2H2(47),m3h3x2(:,53),heltab2x6(:,:,113))
  call Hloop_SV_T(ntryL,G1H6(135),21,ex4(:),8,G2H2(48),m3h3x2(:,54),heltab2x6(:,:,114))
call HGT_OLR(G1H6(136),1,1,6)
call HGT_invQ_OLR(G1H6(136),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(136),-2,nMB,G2H6(21),n2h6(25))
  call Hloop_QA_S(ntryL,G2H6(21),ex2(:),G2H3(93),ngH,m3h2x3(:,61),heltab2x6(:,:,115))
  call Hloop_SV_T(ntryL,G1H6(139),21,ex4(:),8,G2H2(49),m3h3x2(:,55),heltab2x6(:,:,116))
  call Hloop_SV_T(ntryL,G1H6(140),21,ex4(:),8,G2H2(50),m3h3x2(:,56),heltab2x6(:,:,117))
  call Hloop_SV_T(ntryL,G1H6(141),21,ex4(:),8,G2H2(51),m3h3x2(:,57),heltab2x6(:,:,118))
call HGT_OLR(G1H6(142),1,1,6)
call HGT_invQ_OLR(G1H6(142),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(142),-2,nMB,G2H6(22),n2h6(26))
  call Hloop_QA_S(ntryL,G2H6(22),ex2(:),G2H3(94),ngX,m3h2x3(:,62),heltab2x6(:,:,119))
  call Hloop_SV_T(ntryL,G1H6(145),21,ex4(:),8,G2H2(52),m3h3x2(:,58),heltab2x6(:,:,120))
  call Hloop_SV_T(ntryL,G1H6(146),21,ex4(:),8,G2H2(53),m3h3x2(:,59),heltab2x6(:,:,121))
  call Hloop_UW_V(ntryL,G1H6(10),21,ex4(:),8,G2H2(54),m3h3x2(:,60),heltab2x6(:,:,122))
call HGT_OLR(G1H6(11),1,1,6)
call HGT_invQ_OLR(G1H6(11),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(11),-2,nMB,G2H6(23),n2h6(27))
  call Hloop_QA_V(ntryL,G2H6(23),ex2(:),G2H3(95),m3h2x3(:,63),heltab2x6(:,:,123))
  call Hloop_UW_V(ntryL,G1H6(16),21,ex4(:),8,G2H2(55),m3h3x2(:,61),heltab2x6(:,:,124))
  call Hloop_UW_V(ntryL,G1H6(17),21,ex4(:),8,G2H2(56),m3h3x2(:,62),heltab2x6(:,:,125))
  call Hloop_UW_V(ntryL,G1H6(18),21,ex4(:),8,G2H2(57),m3h3x2(:,63),heltab2x6(:,:,126))
call HGT_OLR(G1H6(147),1,1,6)
call HGT_invQ_OLR(G1H6(147),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(147),-2,nMB,G2H6(24),n2h6(28))
  call Hloop_QA_Z(ntryL,G2H6(24),ex2(:),G2H3(96),ngZd,m3h2x3(:,64),heltab2x6(:,:,127))
  call Hloop_UW_V(ntryL,G1H6(150),21,ex4(:),8,G2H2(58),m3h3x2(:,64),heltab2x6(:,:,128))
  call Hloop_UW_V(ntryL,G1H6(151),21,ex4(:),8,G2H2(59),m3h3x2(:,65),heltab2x6(:,:,129))
  call Hloop_UW_V(ntryL,G1H6(152),21,ex4(:),8,G2H2(60),m3h3x2(:,66),heltab2x6(:,:,130))
call HGT_OLR(G1H6(153),1,1,6)
call HGT_invQ_OLR(G1H6(153),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(153),-2,nMB,G2H6(25),n2h6(29))
  call Hloop_QA_V(ntryL,G2H6(25),ex2(:),G2H3(97),m3h2x3(:,65),heltab2x6(:,:,131))
  call Hloop_UW_V(ntryL,G1H6(156),21,ex4(:),8,G2H2(61),m3h3x2(:,67),heltab2x6(:,:,132))
  call Hloop_UW_V(ntryL,G1H6(157),21,ex4(:),8,G2H2(62),m3h3x2(:,68),heltab2x6(:,:,133))
  call Hloop_UW_V(ntryL,G1H6(158),21,ex4(:),8,G2H2(63),m3h3x2(:,69),heltab2x6(:,:,134))
call HGT_OLR(G1H6(159),1,1,6)
call HGT_invQ_OLR(G1H6(159),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(159),-2,nMB,G2H6(26),n2h6(30))
  call Hloop_QA_Z(ntryL,G2H6(26),ex2(:),G2H3(98),ngZd,m3h2x3(:,66),heltab2x6(:,:,135))
  call Hloop_UW_V(ntryL,G1H6(162),21,ex4(:),8,G2H2(64),m3h3x2(:,70),heltab2x6(:,:,136))
  call Hloop_UW_V(ntryL,G1H6(163),21,ex4(:),8,G2H2(65),m3h3x2(:,71),heltab2x6(:,:,137))
  call Hloop_SA_Q(ntryL,G1H6(164),ex2(:),G1H3(1),ngH,m3h2x3(:,67),heltab2x6(:,:,138))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(99),n2h3(83))
call HGT_OLR(G1H6(165),1,1,6)
call HGT_invQ_OLR(G1H6(165),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(165),-4,nMT,G2H6(27),n2h6(31))
  call Hloop_QW_A(ntryL,G2H6(27),ex3(:),G2H2(66),m3h3x2(:,72),heltab2x6(:,:,139))
  call Hloop_SA_Q(ntryL,G1H6(168),ex2(:),G1H3(1),ngH,m3h2x3(:,68),heltab2x6(:,:,140))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(100),n2h3(84))
  call Hloop_SA_Q(ntryL,G1H6(169),ex2(:),G1H3(1),ngH,m3h2x3(:,69),heltab2x6(:,:,141))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(101),n2h3(85))
  call Hloop_SA_Q(ntryL,G1H6(170),ex2(:),G1H3(1),ngX,m3h2x3(:,70),heltab2x6(:,:,142))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(102),n2h3(86))
call HGT_OLR(G1H6(171),1,1,6)
call HGT_invQ_OLR(G1H6(171),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(171),-4,nMT,G2H6(28),n2h6(32))
  call Hloop_QW_A(ntryL,G2H6(28),ex3(:),G2H2(67),m3h3x2(:,73),heltab2x6(:,:,143))
  call Hloop_SA_Q(ntryL,G1H6(174),ex2(:),G1H3(1),ngX,m3h2x3(:,71),heltab2x6(:,:,144))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(103),n2h3(87))
  call Hloop_SA_Q(ntryL,G1H6(175),ex2(:),G1H3(1),ngX,m3h2x3(:,72),heltab2x6(:,:,145))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(104),n2h3(88))
  call Hloop_VA_Q(ntryL,G1H6(176),ex2(:),G1H3(1),m3h2x3(:,73),heltab2x6(:,:,146))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(105),n2h3(89))
call HGT_OLR(G1H6(177),1,1,6)
call HGT_invQ_OLR(G1H6(177),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(177),-4,nMT,G2H6(29),n2h6(33))
  call Hloop_QW_A(ntryL,G2H6(29),ex3(:),G2H2(68),m3h3x2(:,74),heltab2x6(:,:,147))
  call Hloop_VA_Q(ntryL,G1H6(180),ex2(:),G1H3(1),m3h2x3(:,74),heltab2x6(:,:,148))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(106),n2h3(90))
  call Hloop_VA_Q(ntryL,G1H6(181),ex2(:),G1H3(1),m3h2x3(:,75),heltab2x6(:,:,149))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(107),n2h3(91))
  call Hloop_ZA_Q(ntryL,G1H6(182),ex2(:),G1H3(1),ngZd,m3h2x3(:,76),heltab2x6(:,:,150))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(108),n2h3(92))
call HGT_OLR(G1H6(183),1,1,6)
call HGT_invQ_OLR(G1H6(183),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(183),-4,nMT,G2H6(30),n2h6(34))
  call Hloop_QW_A(ntryL,G2H6(30),ex3(:),G2H2(69),m3h3x2(:,75),heltab2x6(:,:,151))
  call Hloop_ZA_Q(ntryL,G1H6(186),ex2(:),G1H3(1),ngZd,m3h2x3(:,77),heltab2x6(:,:,152))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(109),n2h3(93))
  call Hloop_ZA_Q(ntryL,G1H6(187),ex2(:),G1H3(1),ngZd,m3h2x3(:,78),heltab2x6(:,:,153))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(110),n2h3(94))
  call Hloop_SV_T(ntryL,G1H6(188),25,ex3(:),4,G2H2(70),m3h3x2(:,76),heltab2x6(:,:,154))
call HGT_OLR(G1H6(189),1,1,6)
call HGT_invQ_OLR(G1H6(189),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(189),-2,nMB,G2H6(31),n2h6(35))
  call Hloop_QA_S(ntryL,G2H6(31),ex2(:),G2H3(111),ngH,m3h2x3(:,79),heltab2x6(:,:,155))
  call Hloop_SV_T(ntryL,G1H6(192),25,ex3(:),4,G2H2(71),m3h3x2(:,77),heltab2x6(:,:,156))
  call Hloop_SV_T(ntryL,G1H6(193),25,ex3(:),4,G2H2(72),m3h3x2(:,78),heltab2x6(:,:,157))
  call Hloop_SV_T(ntryL,G1H6(194),25,ex3(:),4,G2H2(73),m3h3x2(:,79),heltab2x6(:,:,158))
call HGT_OLR(G1H6(195),1,1,6)
call HGT_invQ_OLR(G1H6(195),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(195),-2,nMB,G2H6(32),n2h6(36))
  call Hloop_QA_S(ntryL,G2H6(32),ex2(:),G2H3(112),ngX,m3h2x3(:,80),heltab2x6(:,:,159))
  call Hloop_SV_T(ntryL,G1H6(198),25,ex3(:),4,G2H2(74),m3h3x2(:,80),heltab2x6(:,:,160))
  call Hloop_SV_T(ntryL,G1H6(199),25,ex3(:),4,G2H2(75),m3h3x2(:,81),heltab2x6(:,:,161))
  call Hloop_SV_T(ntryL,G1H6(200),25,ex3(:),4,G2H2(76),m3h3x2(:,82),heltab2x6(:,:,162))
call HGT_OLR(G1H6(201),1,1,6)
call HGT_invQ_OLR(G1H6(201),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(201),-2,nMB,G2H6(33),n2h6(37))
  call Hloop_QA_S(ntryL,G2H6(33),ex2(:),G2H3(113),ngH,m3h2x3(:,81),heltab2x6(:,:,163))
  call Hloop_SV_T(ntryL,G1H6(204),25,ex3(:),4,G2H2(77),m3h3x2(:,83),heltab2x6(:,:,164))
  call Hloop_SV_T(ntryL,G1H6(205),25,ex3(:),4,G2H2(78),m3h3x2(:,84),heltab2x6(:,:,165))
  call Hloop_SV_T(ntryL,G1H6(206),25,ex3(:),4,G2H2(79),m3h3x2(:,85),heltab2x6(:,:,166))
call HGT_OLR(G1H6(207),1,1,6)
call HGT_invQ_OLR(G1H6(207),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(207),-2,nMB,G2H6(34),n2h6(38))
  call Hloop_QA_S(ntryL,G2H6(34),ex2(:),G2H3(114),ngX,m3h2x3(:,82),heltab2x6(:,:,167))
  call Hloop_SV_T(ntryL,G1H6(210),25,ex3(:),4,G2H2(80),m3h3x2(:,86),heltab2x6(:,:,168))
  call Hloop_SV_T(ntryL,G1H6(211),25,ex3(:),4,G2H2(81),m3h3x2(:,87),heltab2x6(:,:,169))
  call Hloop_TV_S(ntryL,G1H6(212),25,ex3(:),4,G2H2(82),m3h3x2(:,88),heltab2x6(:,:,170))
call HGT_OLR(G1H6(213),1,1,6)
call HGT_invQ_OLR(G1H6(213),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(213),-2,nMT,G2H6(35),n2h6(39))
  call Hloop_QA_S(ntryL,G2H6(35),ex2(:),G2H3(115),ngPbt,m3h2x3(:,83),heltab2x6(:,:,171))
  call Hloop_TV_S(ntryL,G1H6(216),25,ex3(:),4,G2H2(83),m3h3x2(:,89),heltab2x6(:,:,172))
  call Hloop_TV_S(ntryL,G1H6(217),25,ex3(:),4,G2H2(84),m3h3x2(:,90),heltab2x6(:,:,173))
  call Hloop_TV_S(ntryL,G1H6(218),25,ex3(:),4,G2H2(85),m3h3x2(:,91),heltab2x6(:,:,174))
call HGT_OLR(G1H6(219),1,1,6)
call HGT_invQ_OLR(G1H6(219),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(219),-2,nMT,G2H6(36),n2h6(40))
  call Hloop_QA_S(ntryL,G2H6(36),ex2(:),G2H3(116),ngPbt,m3h2x3(:,84),heltab2x6(:,:,175))
  call Hloop_TV_S(ntryL,G1H6(222),25,ex3(:),4,G2H2(86),m3h3x2(:,92),heltab2x6(:,:,176))
  call Hloop_TV_S(ntryL,G1H6(223),25,ex3(:),4,G2H2(87),m3h3x2(:,93),heltab2x6(:,:,177))
  call Hloop_UW_V(ntryL,G1H6(26),25,ex3(:),4,G2H2(88),m3h3x2(:,94),heltab2x6(:,:,178))
call HGT_OLR(G1H6(27),1,1,6)
call HGT_invQ_OLR(G1H6(27),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(27),-2,nMT,G2H6(37),n2h6(41))
  call Hloop_QA_W(ntryL,G2H6(37),ex2(:),G2H3(117),m3h2x3(:,85),heltab2x6(:,:,179))
  call Hloop_UW_V(ntryL,G1H6(224),25,ex3(:),4,G2H2(89),m3h3x2(:,95),heltab2x6(:,:,180))
  call Hloop_UW_V(ntryL,G1H6(225),25,ex3(:),4,G2H2(90),m3h3x2(:,96),heltab2x6(:,:,181))
  call Hloop_UW_V(ntryL,G1H6(34),25,ex3(:),4,G2H2(91),m3h3x2(:,97),heltab2x6(:,:,182))
call HGT_OLR(G1H6(226),1,1,6)
call HGT_invQ_OLR(G1H6(226),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(226),-2,nMT,G2H6(38),n2h6(42))
  call Hloop_QA_W(ntryL,G2H6(38),ex2(:),G2H3(118),m3h2x3(:,86),heltab2x6(:,:,183))
  call Hloop_UW_V(ntryL,G1H6(229),25,ex3(:),4,G2H2(92),m3h3x2(:,98),heltab2x6(:,:,184))
  call Hloop_UW_V(ntryL,G1H6(230),25,ex3(:),4,G2H2(93),m3h3x2(:,99),heltab2x6(:,:,185))
  call Hloop_UV_W(ntryL,G1H6(36),25,ex3(:),4,G2H2(94),m3h3x2(:,100),heltab2x6(:,:,186))
call HGT_OLR(G1H6(37),1,1,6)
call HGT_invQ_OLR(G1H6(37),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(37),-2,nMB,G2H6(39),n2h6(43))
  call Hloop_QA_V(ntryL,G2H6(39),ex2(:),G2H3(119),m3h2x3(:,87),heltab2x6(:,:,187))
  call Hloop_UV_W(ntryL,G1H6(233),25,ex3(:),4,G2H2(95),m3h3x2(:,101),heltab2x6(:,:,188))
  call Hloop_UV_W(ntryL,G1H6(234),25,ex3(:),4,G2H2(96),m3h3x2(:,102),heltab2x6(:,:,189))
  call Hloop_UV_W(ntryL,G1H6(235),25,ex3(:),4,G2H2(97),m3h3x2(:,103),heltab2x6(:,:,190))
call HGT_OLR(G1H6(236),1,1,6)
call HGT_invQ_OLR(G1H6(236),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(236),-2,nMB,G2H6(40),n2h6(44))
  call Hloop_QA_Z(ntryL,G2H6(40),ex2(:),G2H3(120),ngZd,m3h2x3(:,88),heltab2x6(:,:,191))
  call Hloop_UV_W(ntryL,G1H6(239),25,ex3(:),4,G2H2(98),m3h3x2(:,104),heltab2x6(:,:,192))
  call Hloop_UV_W(ntryL,G1H6(240),25,ex3(:),4,G2H2(99),m3h3x2(:,105),heltab2x6(:,:,193))
  call Hloop_UV_W(ntryL,G1H6(241),25,ex3(:),4,G2H2(100),m3h3x2(:,106),heltab2x6(:,:,194))
call HGT_OLR(G1H6(242),1,1,6)
call HGT_invQ_OLR(G1H6(242),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(242),-2,nMB,G2H6(41),n2h6(45))
  call Hloop_QA_V(ntryL,G2H6(41),ex2(:),G2H3(121),m3h2x3(:,89),heltab2x6(:,:,195))
  call Hloop_UV_W(ntryL,G1H6(245),25,ex3(:),4,G2H2(101),m3h3x2(:,107),heltab2x6(:,:,196))
  call Hloop_UV_W(ntryL,G1H6(246),25,ex3(:),4,G2H2(102),m3h3x2(:,108),heltab2x6(:,:,197))
  call Hloop_UV_W(ntryL,G1H6(247),25,ex3(:),4,G2H2(103),m3h3x2(:,109),heltab2x6(:,:,198))
call HGT_OLR(G1H6(248),1,1,6)
call HGT_invQ_OLR(G1H6(248),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(248),-2,nMB,G2H6(42),n2h6(46))
  call Hloop_QA_Z(ntryL,G2H6(42),ex2(:),G2H3(122),ngZd,m3h2x3(:,90),heltab2x6(:,:,199))
  call Hloop_UV_W(ntryL,G1H6(251),25,ex3(:),4,G2H2(104),m3h3x2(:,110),heltab2x6(:,:,200))
  call Hloop_UV_W(ntryL,G1H6(252),25,ex3(:),4,G2H2(105),m3h3x2(:,111),heltab2x6(:,:,201))
  call Hloop_QW_A(ntryL,G1H6(253),ex3(:),G1H2(7),m3h3x2(:,112),heltab2x6(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(7),29,nMB,G2H2(106),n2h2(1))
call HGT_raise_alpha_OLR(G1H6(254),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(254),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(254),ex2(:),G1H3(1),m3h2x3(:,91),heltab2x6(:,:,203))
  call Hloop_QW_A(ntryL,G1H6(259),ex3(:),G1H2(7),m3h3x2(:,113),heltab2x6(:,:,204))
  call Hloop_Q_A(ntryL,G1H2(7),29,nMB,G2H2(107),n2h2(2))
  call Hloop_QW_A(ntryL,G1H6(264),ex3(:),G1H2(7),m3h3x2(:,114),heltab2x6(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(7),29,nMB,G2H2(108),n2h2(3))
call HGT_raise_alpha_OLR(G1H6(260),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(260),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(260),ex2(:),G1H3(2),m3h2x3(:,92),heltab2x6(:,:,206))
  call Hloop_QW_A(ntryL,G1H6(263),ex3(:),G1H2(7),m3h3x2(:,115),heltab2x6(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(7),29,nMB,G2H2(109),n2h2(4))
call HGT_raise_alpha_OLR(G1H6(265),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(265),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(265),ex2(:),G1H3(3),m3h2x3(:,93),heltab2x6(:,:,208))
  call Hloop_QW_A(ntryL,G1H6(268),ex3(:),G1H2(7),m3h3x2(:,116),heltab2x6(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(7),29,nMB,G2H2(110),n2h2(5))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(73),[G2H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(67),[G2H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(79),[G2H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(85),[G2H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(103),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G2H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G2H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G2H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G2H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(26),[G2H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(64),[G2H3(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(66),[G2H3(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(76),[G2H3(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(78),[G2H3(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(88),[G2H3(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(90),[G2H3(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(108),[G2H3(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(110),[G2H3(104)])
  call Hotf_5pt_reduction(G2H3(73),RedSet_5(9),mass5set(:,15),  & 
G1H3(4),G1H3(5),G1H3(6),G1H3(7),G1H3(8),G1H3(9),3)
  call HG1shiftOLR(G1H3(5),4,3)
  call Hotf_5pt_reduction(G2H3(67),RedSet_5(9),mass5set(:,13),  & 
G1H3(10),G1H3(11),G1H3(12),G1H3(13),G1H3(14),G1H3(15),3)
  call HG1shiftOLR(G1H3(11),4,3)
  call Hotf_5pt_reduction(G2H3(79),RedSet_5(10),mass5set(:,13),  & 
G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),G1H3(21),3)
  call HG1shiftOLR(G1H3(17),8,3)
  call Hotf_5pt_reduction(G2H3(85),RedSet_5(10),mass5set(:,15),  & 
G1H3(22),G1H3(23),G1H3(24),G1H3(25),G1H3(26),G1H3(27),3)
  call HG1shiftOLR(G1H3(23),8,3)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(11),mass5set(:,16),  & 
G1H2(7),G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(1),2,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(11),mass5set(:,26),  & 
G1H2(6),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),2,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(11),mass5set(:,22),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),2,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(11),mass5set(:,17),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),2,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(11),mass5set(:,19),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),2,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(11),mass5set(:,27),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),2,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(11),mass5set(:,21),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),2,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(11),mass5set(:,18),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),2,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(11),mass5set(:,20),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),2,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(11),mass5set(:,21),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),2,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(1),mass5set(:,25),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),2,2)
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(1),mass5set(:,24),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),2,2)
  call Hotf_5pt_reduction(G2H2(70),RedSet_5(1),mass5set(:,16),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),2,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(1),mass5set(:,26),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),2,2)
  call Hotf_5pt_reduction(G2H2(100),RedSet_5(1),mass5set(:,22),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),2,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(1),mass5set(:,17),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),2,2)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(1),mass5set(:,19),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),2,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(1),mass5set(:,23),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),2,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(1),mass5set(:,27),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),2,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(1),mass5set(:,21),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),2,2)
  call Hotf_5pt_reduction(G2H2(76),RedSet_5(1),mass5set(:,18),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),2,2)
  call Hotf_5pt_reduction(G2H2(94),RedSet_5(1),mass5set(:,20),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),2,2)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(1),mass5set(:,21),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),2,2)
  call Hotf_5pt_reduction(G2H3(8),RedSet_5(2),mass5set(:,2),  & 
G1H3(28),G1H3(29),G1H3(30),G1H3(31),G1H3(32),G1H3(33),3)
  call HG1shiftOLR(G1H3(29),8,3)
  call Hotf_4pt_reduction(G2H3(10),RedSet_4(3),mass4set(:,3),  & 
G1H3(34),G1H3(35),G1H3(36),G1H3(37),G1H3(38),3)
  call HG1shiftOLR(G1H3(35),10,3)
  call Hotf_5pt_reduction(G2H3(11),RedSet_5(3),mass5set(:,3),  & 
G1H3(39),G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),3)
  call HG1shiftOLR(G1H3(40),8,3)
  call Hotf_4pt_reduction(G2H3(14),RedSet_4(4),mass4set(:,4),  & 
G1H3(45),G1H3(46),G1H3(47),G1H3(48),G1H3(49),3)
  call HG1shiftOLR(G1H3(46),12,3)
  call Hotf_5pt_reduction(G2H3(15),RedSet_5(4),mass5set(:,4),  & 
G1H3(50),G1H3(51),G1H3(52),G1H3(53),G1H3(54),G1H3(55),3)
  call HG1shiftOLR(G1H3(51),8,3)
  call Hotf_4pt_reduction(G2H3(17),RedSet_4(5),mass4set(:,5),  & 
G1H3(56),G1H3(57),G1H3(58),G1H3(59),G1H3(60),3)
  call HG1shiftOLR(G1H3(57),9,3)
  call Hotf_5pt_reduction(G2H3(24),RedSet_5(4),mass5set(:,5),  & 
G1H3(61),G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),3)
  call HG1shiftOLR(G1H3(62),8,3)
  call Hotf_4pt_reduction(G2H3(26),RedSet_4(5),mass4set(:,6),  & 
G1H3(67),G1H3(68),G1H3(69),G1H3(70),G1H3(71),3)
  call HG1shiftOLR(G1H3(68),9,3)
  call Hotf_5pt_reduction(G2H3(21),RedSet_5(4),mass5set(:,6),  & 
G1H3(72),G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),3)
  call HG1shiftOLR(G1H3(73),8,3)
  call Hotf_4pt_reduction(G2H3(23),RedSet_4(5),mass4set(:,7),  & 
G1H3(78),G1H3(79),G1H3(80),G1H3(81),G1H3(82),3)
  call HG1shiftOLR(G1H3(79),9,3)
  call Hotf_5pt_reduction(G2H3(27),RedSet_5(5),mass5set(:,7),  & 
G1H3(83),G1H3(84),G1H3(85),G1H3(86),G1H3(87),G1H3(88),3)
  call HG1shiftOLR(G1H3(84),4,3)
  call Hotf_4pt_reduction(G2H3(30),RedSet_4(4),mass4set(:,8),  & 
G1H3(89),G1H3(90),G1H3(91),G1H3(92),G1H3(93),3)
  call HG1shiftOLR(G1H3(90),12,3)
  call Hotf_5pt_reduction(G2H3(31),RedSet_5(5),mass5set(:,8),  & 
G1H3(94),G1H3(95),G1H3(96),G1H3(97),G1H3(98),G1H3(99),3)
  call HG1shiftOLR(G1H3(95),4,3)
  call Hotf_4pt_reduction(G2H3(34),RedSet_4(4),mass4set(:,9),  & 
G1H3(100),G1H3(101),G1H3(102),G1H3(103),G1H3(104),3)
  call HG1shiftOLR(G1H3(101),12,3)
  call Hotf_5pt_reduction(G2H3(35),RedSet_5(5),mass5set(:,9),  & 
G1H3(105),G1H3(106),G1H3(107),G1H3(108),G1H3(109),G1H3(110),3)
  call HG1shiftOLR(G1H3(106),4,3)
  call Hotf_4pt_reduction(G2H3(38),RedSet_4(4),mass4set(:,10),  & 
G1H3(111),G1H3(112),G1H3(113),G1H3(114),G1H3(115),3)
  call HG1shiftOLR(G1H3(112),12,3)
  call Hotf_5pt_reduction(G2H3(39),RedSet_5(6),mass5set(:,7),  & 
G1H3(116),G1H3(117),G1H3(118),G1H3(119),G1H3(120),G1H3(121),3)
  call HG1shiftOLR(G1H3(117),8,3)
  call Hotf_4pt_reduction(G2H3(42),RedSet_4(6),mass4set(:,8),  & 
G1H3(122),G1H3(123),G1H3(124),G1H3(125),G1H3(126),3)
  call HG1shiftOLR(G1H3(123),12,3)
  call Hotf_5pt_reduction(G2H3(43),RedSet_5(6),mass5set(:,8),  & 
G1H3(127),G1H3(128),G1H3(129),G1H3(130),G1H3(131),G1H3(132),3)
  call HG1shiftOLR(G1H3(128),8,3)
  call Hotf_4pt_reduction(G2H3(46),RedSet_4(6),mass4set(:,9),  & 
G1H3(133),G1H3(134),G1H3(135),G1H3(136),G1H3(137),3)
  call HG1shiftOLR(G1H3(134),12,3)
  call Hotf_5pt_reduction(G2H3(47),RedSet_5(6),mass5set(:,9),  & 
G1H3(138),G1H3(139),G1H3(140),G1H3(141),G1H3(142),G1H3(143),3)
  call HG1shiftOLR(G1H3(139),8,3)
  call Hotf_4pt_reduction(G2H3(50),RedSet_4(6),mass4set(:,10),  & 
G1H3(144),G1H3(145),G1H3(146),G1H3(147),G1H3(148),3)
  call HG1shiftOLR(G1H3(145),12,3)
  call Hotf_5pt_reduction(G2H3(51),RedSet_5(7),mass5set(:,3),  & 
G1H3(149),G1H3(150),G1H3(151),G1H3(152),G1H3(153),G1H3(154),3)
  call HG1shiftOLR(G1H3(150),4,3)
  call Hotf_4pt_reduction(G2H3(54),RedSet_4(6),mass4set(:,4),  & 
G1H3(155),G1H3(156),G1H3(157),G1H3(158),G1H3(159),3)
  call HG1shiftOLR(G1H3(156),12,3)
  call Hotf_5pt_reduction(G2H3(55),RedSet_5(8),mass5set(:,10),  & 
G1H3(160),G1H3(161),G1H3(162),G1H3(163),G1H3(164),G1H3(165),3)
  call HG1shiftOLR(G1H3(161),8,3)
  call Hotf_4pt_reduction(G2H3(57),RedSet_4(7),mass4set(:,11),  & 
G1H3(166),G1H3(167),G1H3(168),G1H3(169),G1H3(170),3)
  call HG1shiftOLR(G1H3(167),9,3)
  call Hotf_5pt_reduction(G2H3(64),RedSet_5(8),mass5set(:,11),  & 
G1H3(171),G1H3(172),G1H3(173),G1H3(174),G1H3(175),G1H3(176),3)
  call HG1shiftOLR(G1H3(172),8,3)
  call Hotf_4pt_reduction(G2H3(66),RedSet_4(7),mass4set(:,12),  & 
G1H3(177),G1H3(178),G1H3(179),G1H3(180),G1H3(181),3)
  call HG1shiftOLR(G1H3(178),9,3)
  call Hotf_5pt_reduction(G2H3(61),RedSet_5(8),mass5set(:,12),  & 
G1H3(182),G1H3(183),G1H3(184),G1H3(185),G1H3(186),G1H3(187),3)
  call HG1shiftOLR(G1H3(183),8,3)
  call Hotf_4pt_reduction(G2H3(63),RedSet_4(7),mass4set(:,13),  & 
G1H3(188),G1H3(189),G1H3(190),G1H3(191),G1H3(192),3)
  call HG1shiftOLR(G1H3(189),9,3)
  call Hotf_4pt_reduction(G2H3(69),RedSet_4(8),mass4set(:,14),  & 
G1H3(193),G1H3(194),G1H3(195),G1H3(196),G1H3(197),3)
  call HG1shiftOLR(G1H3(194),5,3)
  call Hotf_5pt_reduction(G2H3(76),RedSet_5(9),mass5set(:,14),  & 
G1H3(198),G1H3(199),G1H3(200),G1H3(201),G1H3(202),G1H3(203),3)
  call HG1shiftOLR(G1H3(199),4,3)
  call Hotf_4pt_reduction(G2H3(78),RedSet_4(8),mass4set(:,15),  & 
G1H3(204),G1H3(205),G1H3(206),G1H3(207),G1H3(208),3)
  call HG1shiftOLR(G1H3(205),5,3)
  call Hotf_4pt_reduction(G2H3(75),RedSet_4(8),mass4set(:,16),  & 
G1H3(209),G1H3(210),G1H3(211),G1H3(212),G1H3(213),3)
  call HG1shiftOLR(G1H3(210),5,3)
  call Hotf_4pt_reduction(G2H3(81),RedSet_4(9),mass4set(:,14),  & 
G1H3(214),G1H3(215),G1H3(216),G1H3(217),G1H3(218),3)
  call HG1shiftOLR(G1H3(215),10,3)
  call Hotf_5pt_reduction(G2H3(88),RedSet_5(10),mass5set(:,14),  & 
G1H3(219),G1H3(220),G1H3(221),G1H3(222),G1H3(223),G1H3(224),3)
  call HG1shiftOLR(G1H3(220),8,3)
  call Hotf_4pt_reduction(G2H3(90),RedSet_4(9),mass4set(:,15),  & 
G1H3(225),G1H3(226),G1H3(227),G1H3(228),G1H3(229),3)
  call HG1shiftOLR(G1H3(226),10,3)
  call Hotf_4pt_reduction(G2H3(87),RedSet_4(9),mass4set(:,16),  & 
G1H3(230),G1H3(231),G1H3(232),G1H3(233),G1H3(234),3)
  call HG1shiftOLR(G1H3(231),10,3)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(9),mass4set(:,14),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),2)
  call HG1shiftOLR(G1H2(140),10,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(11),mass5set(:,17),  & 
G1H2(144),G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),2)
  call HG1shiftOLR(G1H2(145),2,2)
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(9),mass4set(:,14),  & 
G1H2(150),G1H2(151),G1H2(152),G1H2(153),G1H2(154),2)
  call HG1shiftOLR(G1H2(151),10,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(9),mass4set(:,15),  & 
G1H2(155),G1H2(156),G1H2(157),G1H2(158),G1H2(159),2)
  call HG1shiftOLR(G1H2(156),10,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(11),mass5set(:,19),  & 
G1H2(160),G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),2)
  call HG1shiftOLR(G1H2(161),2,2)
  call Hotf_4pt_reduction(G2H2(53),RedSet_4(9),mass4set(:,15),  & 
G1H2(166),G1H2(167),G1H2(168),G1H2(169),G1H2(170),2)
  call HG1shiftOLR(G1H2(167),10,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(9),mass4set(:,16),  & 
G1H2(171),G1H2(172),G1H2(173),G1H2(174),G1H2(175),2)
  call HG1shiftOLR(G1H2(172),10,2)
  call Hotf_4pt_reduction(G2H2(59),RedSet_4(9),mass4set(:,16),  & 
G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(177),10,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(9),mass4set(:,15),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),2)
  call HG1shiftOLR(G1H2(182),10,2)
  call Hotf_4pt_reduction(G2H2(65),RedSet_4(9),mass4set(:,15),  & 
G1H2(186),G1H2(187),G1H2(188),G1H2(189),G1H2(190),2)
  call HG1shiftOLR(G1H2(187),10,2)
  call Hotf_5pt_reduction(G2H3(99),RedSet_5(12),mass5set(:,10),  & 
G1H3(235),G1H3(236),G1H3(237),G1H3(238),G1H3(239),G1H3(240),3)
  call HG1shiftOLR(G1H3(236),4,3)
  call Hotf_4pt_reduction(G2H3(101),RedSet_4(2),mass4set(:,11),  & 
G1H3(241),G1H3(242),G1H3(243),G1H3(244),G1H3(245),3)
  call HG1shiftOLR(G1H3(242),6,3)
  call Hotf_5pt_reduction(G2H3(108),RedSet_5(12),mass5set(:,11),  & 
G1H3(246),G1H3(247),G1H3(248),G1H3(249),G1H3(250),G1H3(251),3)
  call HG1shiftOLR(G1H3(247),4,3)
  call Hotf_4pt_reduction(G2H3(110),RedSet_4(2),mass4set(:,12),  & 
G1H3(252),G1H3(253),G1H3(254),G1H3(255),G1H3(256),3)
  call HG1shiftOLR(G1H3(253),6,3)
  call Hotf_5pt_reduction(G2H3(105),RedSet_5(12),mass5set(:,12),  & 
G1H3(257),G1H3(258),G1H3(259),G1H3(260),G1H3(261),G1H3(262),3)
  call HG1shiftOLR(G1H3(258),4,3)
  call Hotf_4pt_reduction(G2H3(107),RedSet_4(2),mass4set(:,13),  & 
G1H3(263),G1H3(264),G1H3(265),G1H3(266),G1H3(267),3)
  call HG1shiftOLR(G1H3(264),6,3)
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(2),mass4set(:,14),  & 
G1H2(191),G1H2(192),G1H2(193),G1H2(194),G1H2(195),2)
  call HG1shiftOLR(G1H2(192),6,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(1),mass5set(:,17),  & 
G1H2(196),G1H2(197),G1H2(198),G1H2(199),G1H2(200),G1H2(201),2)
  call HG1shiftOLR(G1H2(197),2,2)
  call Hotf_4pt_reduction(G2H2(75),RedSet_4(2),mass4set(:,14),  & 
G1H2(202),G1H2(203),G1H2(204),G1H2(205),G1H2(206),2)
  call HG1shiftOLR(G1H2(203),6,2)
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(2),mass4set(:,15),  & 
G1H2(207),G1H2(208),G1H2(209),G1H2(210),G1H2(211),2)
  call HG1shiftOLR(G1H2(208),6,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(1),mass5set(:,19),  & 
G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),G1H2(217),2)
  call HG1shiftOLR(G1H2(213),2,2)
  call Hotf_4pt_reduction(G2H2(81),RedSet_4(2),mass4set(:,15),  & 
G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(219),6,2)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(1),mass5set(:,23),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),2,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(2),mass4set(:,11),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),2)
  call HG1shiftOLR(G1H2(230),6,2)
  call Hotf_4pt_reduction(G2H2(87),RedSet_4(2),mass4set(:,12),  & 
G1H2(234),G1H2(235),G1H2(236),G1H2(237),G1H2(238),2)
  call HG1shiftOLR(G1H2(235),6,2)
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(1),mass5set(:,25),  & 
G1H2(239),G1H2(240),G1H2(241),G1H2(242),G1H2(243),G1H2(244),2)
  call HG1shiftOLR(G1H2(240),2,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(2),mass4set(:,13),  & 
G1H2(245),G1H2(246),G1H2(247),G1H2(248),G1H2(249),2)
  call HG1shiftOLR(G1H2(246),6,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(1),mass5set(:,24),  & 
G1H2(250),G1H2(251),G1H2(252),G1H2(253),G1H2(254),G1H2(255),2)
  call HG1shiftOLR(G1H2(251),2,2)
  call Hotf_4pt_reduction(G2H2(93),RedSet_4(2),mass4set(:,12),  & 
G1H2(256),G1H2(257),G1H2(258),G1H2(259),G1H2(260),2)
  call HG1shiftOLR(G1H2(257),6,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(2),mass4set(:,16),  & 
G1H2(261),G1H2(262),G1H2(263),G1H2(264),G1H2(265),2)
  call HG1shiftOLR(G1H2(262),6,2)
  call Hotf_4pt_reduction(G2H2(99),RedSet_4(2),mass4set(:,16),  & 
G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),2)
  call HG1shiftOLR(G1H2(267),6,2)
  call Hotf_4pt_reduction(G2H2(102),RedSet_4(2),mass4set(:,15),  & 
G1H2(271),G1H2(272),G1H2(273),G1H2(274),G1H2(275),2)
  call HG1shiftOLR(G1H2(272),6,2)
  call Hotf_4pt_reduction(G2H2(105),RedSet_4(2),mass4set(:,15),  & 
G1H2(276),G1H2(277),G1H2(278),G1H2(279),G1H2(280),2)
  call HG1shiftOLR(G1H2(277),6,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(106),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(108),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(209),[G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(193),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(214),[G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(230),[G1H3(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(139),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(181),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(186),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(155),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(171),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(176),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(234),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(191),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(271),[G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(276),[G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(207),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(261),[G1H2(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(266),[G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(34),[G1H3(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(45),[G1H3(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(56),[G1H3(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(67),[G1H3(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(78),[G1H3(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(89),[G1H3(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(100),[G1H3(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(111),[G1H3(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(122),[G1H3(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(133),[G1H3(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(144),[G1H3(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(155),[G1H3(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(166),[G1H3(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(177),[G1H3(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(188),[G1H3(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(204),[G1H3(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(225),[G1H3(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(150),[G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(166),[G1H2(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(241),[G1H3(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(252),[G1H3(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(263),[G1H3(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(202),[G1H2(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(218),[G1H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(229),[G1H2(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(245),[G1H2(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(256),[G1H2(255)])
  call Hloop_QW_A(ntryL,G1H3(4),ex3(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(3),n2h1(1))
  call Hloop_QW_A(ntryL,G1H3(5),ex3(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(4),n2h1(2))
  call Hloop_QW_A(ntryL,G1H3(209),ex3(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(5),n2h1(3))
  call Hloop_QW_A(ntryL,G1H3(10),ex3(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(6),n2h1(4))
  call Hloop_QW_A(ntryL,G1H3(11),ex3(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(7),n2h1(5))
  call Hloop_QW_A(ntryL,G1H3(193),ex3(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(8),n2h1(6))
  call Hloop_AW_Q(ntryL,G1H3(16),ex4(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(7))
  call Hloop_AW_Q(ntryL,G1H3(17),ex4(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(10),n2h1(8))
  call Hloop_AW_Q(ntryL,G1H3(214),ex4(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(11),n2h1(9))
  call Hloop_AW_Q(ntryL,G1H3(22),ex4(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(12),n2h1(10))
  call Hloop_AW_Q(ntryL,G1H3(23),ex4(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(13),n2h1(11))
  call Hloop_AW_Q(ntryL,G1H3(230),ex4(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(14),n2h1(12))
  call Hloop_SA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),ngH,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(15),n2h1(13))
  call Hloop_SA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),ngH,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(16),n2h1(14))
  call Hloop_SA_Q(ntryL,G1H2(139),ex2(:),G1H1(1),ngH,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(17),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(6),ex2(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(18),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(19),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(12),ex2(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(20),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(21),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(22),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(181),ex2(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(23),n2h1(21))
  call Hloop_ZA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),ngZd,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(24),n2h1(22))
  call Hloop_ZA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),ngZd,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(25),n2h1(23))
  call Hloop_ZA_Q(ntryL,G1H2(24),ex2(:),G1H1(1),ngZd,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(26),n2h1(24))
  call Hloop_ZA_Q(ntryL,G1H2(25),ex2(:),G1H1(1),ngZd,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(27),n2h1(25))
  call Hloop_ZA_Q(ntryL,G1H2(26),ex2(:),G1H1(1),ngZd,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(28),n2h1(26))
  call Hloop_ZA_Q(ntryL,G1H2(186),ex2(:),G1H1(1),ngZd,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(29),n2h1(27))
  call Hloop_SA_Q(ntryL,G1H2(31),ex2(:),G1H1(1),ngH,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(30),n2h1(28))
  call Hloop_SA_Q(ntryL,G1H2(32),ex2(:),G1H1(1),ngH,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(31),n2h1(29))
  call Hloop_SA_Q(ntryL,G1H2(36),ex2(:),G1H1(1),ngH,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(32),n2h1(30))
  call Hloop_SA_Q(ntryL,G1H2(37),ex2(:),G1H1(1),ngX,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(33),n2h1(31))
  call Hloop_SA_Q(ntryL,G1H2(38),ex2(:),G1H1(1),ngX,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(34),n2h1(32))
  call Hloop_SA_Q(ntryL,G1H2(42),ex2(:),G1H1(1),ngX,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(35),n2h1(33))
  call Hloop_SA_Q(ntryL,G1H2(43),ex2(:),G1H1(1),ngH,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(36),n2h1(34))
  call Hloop_SA_Q(ntryL,G1H2(44),ex2(:),G1H1(1),ngH,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(37),n2h1(35))
  call Hloop_SA_Q(ntryL,G1H2(155),ex2(:),G1H1(1),ngH,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(38),n2h1(36))
  call Hloop_VA_Q(ntryL,G1H2(49),ex2(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(37))
  call Hloop_VA_Q(ntryL,G1H2(50),ex2(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(40),n2h1(38))
  call Hloop_VA_Q(ntryL,G1H2(171),ex2(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(41),n2h1(39))
  call Hloop_ZA_Q(ntryL,G1H2(55),ex2(:),G1H1(1),ngZd,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(42),n2h1(40))
  call Hloop_ZA_Q(ntryL,G1H2(56),ex2(:),G1H1(1),ngZd,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(43),n2h1(41))
  call Hloop_ZA_Q(ntryL,G1H2(176),ex2(:),G1H1(1),ngZd,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(44),n2h1(42))
  call Hloop_SA_Q(ntryL,G1H2(61),ex2(:),G1H1(1),ngPbt,m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(45),n2h1(43))
  call Hloop_SA_Q(ntryL,G1H2(62),ex2(:),G1H1(1),ngPbt,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(46),n2h1(44))
  call Hloop_SA_Q(ntryL,G1H2(66),ex2(:),G1H1(1),ngPbt,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(47),n2h1(45))
  call Hloop_SA_Q(ntryL,G1H2(67),ex2(:),G1H1(1),ngPbt,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(48),n2h1(46))
  call Hloop_SA_Q(ntryL,G1H2(68),ex2(:),G1H1(1),ngPbt,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(49),n2h1(47))
  call Hloop_SA_Q(ntryL,G1H2(234),ex2(:),G1H1(1),ngPbt,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(50),n2h1(48))
  call Hloop_SA_Q(ntryL,G1H2(73),ex2(:),G1H1(1),ngH,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(51),n2h1(49))
  call Hloop_SA_Q(ntryL,G1H2(74),ex2(:),G1H1(1),ngH,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(52),n2h1(50))
  call Hloop_SA_Q(ntryL,G1H2(191),ex2(:),G1H1(1),ngH,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(53),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(79),ex2(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(54),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(80),ex2(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(55),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H2(84),ex2(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(56),n2h1(54))
  call Hloop_VA_Q(ntryL,G1H2(85),ex2(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(57),n2h1(55))
  call Hloop_VA_Q(ntryL,G1H2(86),ex2(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(58),n2h1(56))
  call Hloop_VA_Q(ntryL,G1H2(271),ex2(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(57))
  call Hloop_ZA_Q(ntryL,G1H2(91),ex2(:),G1H1(1),ngZd,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(60),n2h1(58))
  call Hloop_ZA_Q(ntryL,G1H2(92),ex2(:),G1H1(1),ngZd,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(61),n2h1(59))
  call Hloop_ZA_Q(ntryL,G1H2(96),ex2(:),G1H1(1),ngZd,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(62),n2h1(60))
  call Hloop_ZA_Q(ntryL,G1H2(97),ex2(:),G1H1(1),ngZd,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(63),n2h1(61))
  call Hloop_ZA_Q(ntryL,G1H2(98),ex2(:),G1H1(1),ngZd,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(64),n2h1(62))
  call Hloop_ZA_Q(ntryL,G1H2(276),ex2(:),G1H1(1),ngZd,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(65),n2h1(63))
  call Hloop_WA_Q(ntryL,G1H2(103),ex2(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(66),n2h1(64))
  call Hloop_WA_Q(ntryL,G1H2(104),ex2(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(67),n2h1(65))
  call Hloop_WA_Q(ntryL,G1H2(108),ex2(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(68),n2h1(66))
  call Hloop_SA_Q(ntryL,G1H2(109),ex2(:),G1H1(1),ngH,m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(69),n2h1(67))
  call Hloop_SA_Q(ntryL,G1H2(110),ex2(:),G1H1(1),ngH,m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(70),n2h1(68))
  call Hloop_SA_Q(ntryL,G1H2(114),ex2(:),G1H1(1),ngH,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(69))
  call Hloop_SA_Q(ntryL,G1H2(115),ex2(:),G1H1(1),ngX,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(72),n2h1(70))
  call Hloop_SA_Q(ntryL,G1H2(116),ex2(:),G1H1(1),ngX,m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(73),n2h1(71))
  call Hloop_SA_Q(ntryL,G1H2(120),ex2(:),G1H1(1),ngX,m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(74),n2h1(72))
  call Hloop_SA_Q(ntryL,G1H2(121),ex2(:),G1H1(1),ngH,m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(75),n2h1(73))
  call Hloop_SA_Q(ntryL,G1H2(122),ex2(:),G1H1(1),ngH,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(76),n2h1(74))
  call Hloop_SA_Q(ntryL,G1H2(207),ex2(:),G1H1(1),ngH,m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(77),n2h1(75))
  call Hloop_VA_Q(ntryL,G1H2(127),ex2(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(78),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(128),ex2(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(79),n2h1(77))
  call Hloop_VA_Q(ntryL,G1H2(261),ex2(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(80),n2h1(78))
  call Hloop_ZA_Q(ntryL,G1H2(133),ex2(:),G1H1(1),ngZd,m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(81),n2h1(79))
  call Hloop_ZA_Q(ntryL,G1H2(134),ex2(:),G1H1(1),ngZd,m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(82),n2h1(80))
  call Hloop_ZA_Q(ntryL,G1H2(266),ex2(:),G1H1(1),ngZd,m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(83),n2h1(81))
  call Hloop_AW_Q(ntryL,G1H3(28),ex4(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(84),n2h1(82))
  call Hloop_AW_Q(ntryL,G1H3(29),ex4(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(85),n2h1(83))
  call Hloop_AW_Q(ntryL,G1H3(34),ex4(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(86),n2h1(84))
  call Hloop_AW_Q(ntryL,G1H3(35),ex4(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(87),n2h1(85))
  call Hloop_QW_A(ntryL,G1H3(39),ex4(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(88),n2h1(86))
  call Hloop_QW_A(ntryL,G1H3(40),ex4(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(89),n2h1(87))
  call Hloop_QW_A(ntryL,G1H3(45),ex4(:),G1H1(1),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(90),n2h1(88))
  call Hloop_QW_A(ntryL,G1H3(46),ex4(:),G1H1(1),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(91),n2h1(89))
  call Hloop_QW_A(ntryL,G1H3(50),ex4(:),G1H1(1),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(92),n2h1(90))
  call Hloop_QW_A(ntryL,G1H3(51),ex4(:),G1H1(1),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(93),n2h1(91))
  call Hloop_QW_A(ntryL,G1H3(56),ex4(:),G1H1(1),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(94),n2h1(92))
  call Hloop_QW_A(ntryL,G1H3(57),ex4(:),G1H1(1),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(95),n2h1(93))
  call Hloop_QW_A(ntryL,G1H3(61),ex4(:),G1H1(1),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(96),n2h1(94))
  call Hloop_QW_A(ntryL,G1H3(62),ex4(:),G1H1(1),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(97),n2h1(95))
  call Hloop_QW_A(ntryL,G1H3(67),ex4(:),G1H1(1),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(98),n2h1(96))
  call Hloop_QW_A(ntryL,G1H3(68),ex4(:),G1H1(1),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(99),n2h1(97))
  call Hloop_QW_A(ntryL,G1H3(72),ex4(:),G1H1(1),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(100),n2h1(98))
  call Hloop_QW_A(ntryL,G1H3(73),ex4(:),G1H1(1),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(101),n2h1(99))
  call Hloop_QW_A(ntryL,G1H3(78),ex4(:),G1H1(1),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(102),n2h1(100))
  call Hloop_QW_A(ntryL,G1H3(79),ex4(:),G1H1(1),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(103),n2h1(101))
  call Hloop_QW_A(ntryL,G1H3(83),ex3(:),G1H1(1),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(104),n2h1(102))
  call Hloop_QW_A(ntryL,G1H3(84),ex3(:),G1H1(1),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(105),n2h1(103))
  call Hloop_QW_A(ntryL,G1H3(89),ex3(:),G1H1(1),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(106),n2h1(104))
  call Hloop_QW_A(ntryL,G1H3(90),ex3(:),G1H1(1),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(107),n2h1(105))
  call Hloop_QW_A(ntryL,G1H3(94),ex3(:),G1H1(1),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(108),n2h1(106))
  call Hloop_QW_A(ntryL,G1H3(95),ex3(:),G1H1(1),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(109),n2h1(107))
  call Hloop_QW_A(ntryL,G1H3(100),ex3(:),G1H1(1),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(110),n2h1(108))
  call Hloop_QW_A(ntryL,G1H3(101),ex3(:),G1H1(1),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(111),n2h1(109))
  call Hloop_QW_A(ntryL,G1H3(105),ex3(:),G1H1(1),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(112),n2h1(110))
  call Hloop_QW_A(ntryL,G1H3(106),ex3(:),G1H1(1),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(113),n2h1(111))
  call Hloop_QW_A(ntryL,G1H3(111),ex3(:),G1H1(1),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(114),n2h1(112))
  call Hloop_QW_A(ntryL,G1H3(112),ex3(:),G1H1(1),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(115),n2h1(113))
  call Hloop_AW_Q(ntryL,G1H3(116),ex4(:),G1H1(1),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(116),n2h1(114))
  call Hloop_AW_Q(ntryL,G1H3(117),ex4(:),G1H1(1),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(117),n2h1(115))
  call Hloop_AW_Q(ntryL,G1H3(122),ex4(:),G1H1(1),m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(118),n2h1(116))
  call Hloop_AW_Q(ntryL,G1H3(123),ex4(:),G1H1(1),m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(119),n2h1(117))
  call Hloop_AW_Q(ntryL,G1H3(127),ex4(:),G1H1(1),m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(120),n2h1(118))
  call Hloop_AW_Q(ntryL,G1H3(128),ex4(:),G1H1(1),m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(121),n2h1(119))
  call Hloop_AW_Q(ntryL,G1H3(133),ex4(:),G1H1(1),m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(122),n2h1(120))
  call Hloop_AW_Q(ntryL,G1H3(134),ex4(:),G1H1(1),m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(123),n2h1(121))
  call Hloop_AW_Q(ntryL,G1H3(138),ex4(:),G1H1(1),m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(124),n2h1(122))
  call Hloop_AW_Q(ntryL,G1H3(139),ex4(:),G1H1(1),m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(125),n2h1(123))
  call Hloop_AW_Q(ntryL,G1H3(144),ex4(:),G1H1(1),m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(126),n2h1(124))
  call Hloop_AW_Q(ntryL,G1H3(145),ex4(:),G1H1(1),m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(127),n2h1(125))
  call Hloop_AW_Q(ntryL,G1H3(149),ex3(:),G1H1(1),m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(128),n2h1(126))
  call Hloop_AW_Q(ntryL,G1H3(150),ex3(:),G1H1(1),m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(129),n2h1(127))
  call Hloop_AW_Q(ntryL,G1H3(155),ex3(:),G1H1(1),m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(130),n2h1(128))
  call Hloop_AW_Q(ntryL,G1H3(156),ex3(:),G1H1(1),m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(131),n2h1(129))
  call Hloop_QW_A(ntryL,G1H3(160),ex4(:),G1H1(1),m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(132),n2h1(130))
  call Hloop_QW_A(ntryL,G1H3(161),ex4(:),G1H1(1),m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(133),n2h1(131))
  call Hloop_QW_A(ntryL,G1H3(166),ex4(:),G1H1(1),m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(134),n2h1(132))
  call Hloop_QW_A(ntryL,G1H3(167),ex4(:),G1H1(1),m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(135),n2h1(133))
  call Hloop_QW_A(ntryL,G1H3(171),ex4(:),G1H1(1),m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(136),n2h1(134))
  call Hloop_QW_A(ntryL,G1H3(172),ex4(:),G1H1(1),m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(137),n2h1(135))
  call Hloop_QW_A(ntryL,G1H3(177),ex4(:),G1H1(1),m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(138),n2h1(136))
  call Hloop_QW_A(ntryL,G1H3(178),ex4(:),G1H1(1),m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(139),n2h1(137))
  call Hloop_QW_A(ntryL,G1H3(182),ex4(:),G1H1(1),m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(140),n2h1(138))
  call Hloop_QW_A(ntryL,G1H3(183),ex4(:),G1H1(1),m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(141),n2h1(139))
  call Hloop_QW_A(ntryL,G1H3(188),ex4(:),G1H1(1),m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(142),n2h1(140))
  call Hloop_QW_A(ntryL,G1H3(189),ex4(:),G1H1(1),m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(143),n2h1(141))
  call Hloop_QW_A(ntryL,G1H3(194),ex3(:),G1H1(1),m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(144),n2h1(142))
  call Hloop_QW_A(ntryL,G1H3(198),ex3(:),G1H1(1),m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(145),n2h1(143))
  call Hloop_QW_A(ntryL,G1H3(199),ex3(:),G1H1(1),m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(146),n2h1(144))
  call Hloop_QW_A(ntryL,G1H3(204),ex3(:),G1H1(1),m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(147),n2h1(145))
  call Hloop_QW_A(ntryL,G1H3(205),ex3(:),G1H1(1),m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(148),n2h1(146))
  call Hloop_QW_A(ntryL,G1H3(210),ex3(:),G1H1(1),m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(149),n2h1(147))
  call Hloop_AW_Q(ntryL,G1H3(215),ex4(:),G1H1(1),m3h3x1(:,79),heltab2x3(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(150),n2h1(148))
  call Hloop_AW_Q(ntryL,G1H3(219),ex4(:),G1H1(1),m3h3x1(:,80),heltab2x3(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(151),n2h1(149))
  call Hloop_AW_Q(ntryL,G1H3(220),ex4(:),G1H1(1),m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(152),n2h1(150))
  call Hloop_AW_Q(ntryL,G1H3(225),ex4(:),G1H1(1),m3h3x1(:,82),heltab2x3(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(153),n2h1(151))
  call Hloop_AW_Q(ntryL,G1H3(226),ex4(:),G1H1(1),m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(154),n2h1(152))
  call Hloop_AW_Q(ntryL,G1H3(231),ex4(:),G1H1(1),m3h3x1(:,84),heltab2x3(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(155),n2h1(153))
  call Hloop_SA_Q(ntryL,G1H2(140),ex2(:),G1H1(1),ngH,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(156),n2h1(154))
  call Hloop_SA_Q(ntryL,G1H2(144),ex2(:),G1H1(1),ngX,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(157),n2h1(155))
  call Hloop_SA_Q(ntryL,G1H2(145),ex2(:),G1H1(1),ngX,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(158),n2h1(156))
  call Hloop_SA_Q(ntryL,G1H2(150),ex2(:),G1H1(1),ngX,m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(159),n2h1(157))
  call Hloop_SA_Q(ntryL,G1H2(151),ex2(:),G1H1(1),ngX,m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(160),n2h1(158))
  call Hloop_SA_Q(ntryL,G1H2(156),ex2(:),G1H1(1),ngH,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(161),n2h1(159))
  call Hloop_SA_Q(ntryL,G1H2(160),ex2(:),G1H1(1),ngX,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(162),n2h1(160))
  call Hloop_SA_Q(ntryL,G1H2(161),ex2(:),G1H1(1),ngX,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(163),n2h1(161))
  call Hloop_SA_Q(ntryL,G1H2(166),ex2(:),G1H1(1),ngX,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(164),n2h1(162))
  call Hloop_SA_Q(ntryL,G1H2(167),ex2(:),G1H1(1),ngX,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(165),n2h1(163))
  call Hloop_VA_Q(ntryL,G1H2(172),ex2(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(166),n2h1(164))
  call Hloop_ZA_Q(ntryL,G1H2(177),ex2(:),G1H1(1),ngZd,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(167),n2h1(165))
  call Hloop_VA_Q(ntryL,G1H2(182),ex2(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(168),n2h1(166))
  call Hloop_ZA_Q(ntryL,G1H2(187),ex2(:),G1H1(1),ngZd,m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(169),n2h1(167))
  call Hloop_AW_Q(ntryL,G1H3(235),ex3(:),G1H1(1),m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(170),n2h1(168))
  call Hloop_AW_Q(ntryL,G1H3(236),ex3(:),G1H1(1),m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(171),n2h1(169))
  call Hloop_AW_Q(ntryL,G1H3(241),ex3(:),G1H1(1),m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(172),n2h1(170))
  call Hloop_AW_Q(ntryL,G1H3(242),ex3(:),G1H1(1),m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(173),n2h1(171))
  call Hloop_AW_Q(ntryL,G1H3(246),ex3(:),G1H1(1),m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(174),n2h1(172))
  call Hloop_AW_Q(ntryL,G1H3(247),ex3(:),G1H1(1),m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(175),n2h1(173))
  call Hloop_AW_Q(ntryL,G1H3(252),ex3(:),G1H1(1),m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(176),n2h1(174))
  call Hloop_AW_Q(ntryL,G1H3(253),ex3(:),G1H1(1),m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(177),n2h1(175))
  call Hloop_AW_Q(ntryL,G1H3(257),ex3(:),G1H1(1),m3h3x1(:,93),heltab2x3(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(178),n2h1(176))
  call Hloop_AW_Q(ntryL,G1H3(258),ex3(:),G1H1(1),m3h3x1(:,94),heltab2x3(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(179),n2h1(177))
  call Hloop_AW_Q(ntryL,G1H3(263),ex3(:),G1H1(1),m3h3x1(:,95),heltab2x3(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(180),n2h1(178))
  call Hloop_AW_Q(ntryL,G1H3(264),ex3(:),G1H1(1),m3h3x1(:,96),heltab2x3(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(181),n2h1(179))
  call Hloop_SA_Q(ntryL,G1H2(192),ex2(:),G1H1(1),ngH,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(182),n2h1(180))
  call Hloop_SA_Q(ntryL,G1H2(196),ex2(:),G1H1(1),ngX,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(183),n2h1(181))
  call Hloop_SA_Q(ntryL,G1H2(197),ex2(:),G1H1(1),ngX,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(184),n2h1(182))
  call Hloop_SA_Q(ntryL,G1H2(202),ex2(:),G1H1(1),ngX,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(185),n2h1(183))
  call Hloop_SA_Q(ntryL,G1H2(203),ex2(:),G1H1(1),ngX,m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(186),n2h1(184))
  call Hloop_SA_Q(ntryL,G1H2(208),ex2(:),G1H1(1),ngH,m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(187),n2h1(185))
  call Hloop_SA_Q(ntryL,G1H2(212),ex2(:),G1H1(1),ngX,m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(188),n2h1(186))
  call Hloop_SA_Q(ntryL,G1H2(213),ex2(:),G1H1(1),ngX,m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(189),n2h1(187))
  call Hloop_SA_Q(ntryL,G1H2(218),ex2(:),G1H1(1),ngX,m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(190),n2h1(188))
  call Hloop_SA_Q(ntryL,G1H2(219),ex2(:),G1H1(1),ngX,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(191),n2h1(189))
  call Hloop_SA_Q(ntryL,G1H2(223),ex2(:),G1H1(1),ngPbt,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(192),n2h1(190))
  call Hloop_SA_Q(ntryL,G1H2(224),ex2(:),G1H1(1),ngPbt,m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(193),n2h1(191))
  call Hloop_SA_Q(ntryL,G1H2(229),ex2(:),G1H1(1),ngPbt,m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(194),n2h1(192))
  call Hloop_SA_Q(ntryL,G1H2(230),ex2(:),G1H1(1),ngPbt,m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(195),n2h1(193))
  call Hloop_SA_Q(ntryL,G1H2(235),ex2(:),G1H1(1),ngPbt,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(196),n2h1(194))
  call Hloop_WA_Q(ntryL,G1H2(239),ex2(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(197),n2h1(195))
  call Hloop_WA_Q(ntryL,G1H2(240),ex2(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(198),n2h1(196))
  call Hloop_WA_Q(ntryL,G1H2(245),ex2(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(199),n2h1(197))
  call Hloop_WA_Q(ntryL,G1H2(246),ex2(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(200),n2h1(198))
  call Hloop_WA_Q(ntryL,G1H2(250),ex2(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(201),n2h1(199))
  call Hloop_WA_Q(ntryL,G1H2(251),ex2(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(202),n2h1(200))
  call Hloop_WA_Q(ntryL,G1H2(256),ex2(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(203),n2h1(201))
  call Hloop_WA_Q(ntryL,G1H2(257),ex2(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(204),n2h1(202))
  call Hloop_VA_Q(ntryL,G1H2(262),ex2(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(205),n2h1(203))
  call Hloop_ZA_Q(ntryL,G1H2(267),ex2(:),G1H1(1),ngZd,m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(206),n2h1(204))
  call Hloop_VA_Q(ntryL,G1H2(272),ex2(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(207),n2h1(205))
  call Hloop_ZA_Q(ntryL,G1H2(277),ex2(:),G1H1(1),ngZd,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(208),n2h1(206))
  call ol_merge_tensors(G2tensor(157),[G2tensor(24)])
  call ol_merge_tensors(G2tensor(162),[G2tensor(27)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(33)])
  call ol_merge_tensors(G2tensor(197),[G2tensor(45)])
  call ol_merge_tensors(G2tensor(201),[G2tensor(48)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(60)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(63)])
  call ol_merge_tensors(G2tensor(192),[G2tensor(66)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(72)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(9),mass5set(:,15),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(9),mass5set(:,13),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(10),mass5set(:,13),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(10),mass5set(:,15),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(11),mass5set(:,16),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(11),mass5set(:,26),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),2)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(11),mass5set(:,22),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),2)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(11),mass5set(:,17),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),2)
  call Hotf_5pt_reduction_last(G2tensor(162),RedSet_5(11),mass5set(:,19),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),2)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(11),mass5set(:,27),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),2)
  call Hotf_5pt_reduction_last(G2tensor(42),RedSet_5(11),mass5set(:,21),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),2)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(11),mass5set(:,18),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),2)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(11),mass5set(:,20),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),2)
  call Hotf_5pt_reduction_last(G2tensor(197),RedSet_5(1),mass5set(:,25),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),2)
  call Hotf_5pt_reduction_last(G2tensor(201),RedSet_5(1),mass5set(:,24),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(1),mass5set(:,16),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),2)
  call Hotf_5pt_reduction_last(G2tensor(54),RedSet_5(1),mass5set(:,26),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),2)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(1),mass5set(:,22),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),2)
  call Hotf_5pt_reduction_last(G2tensor(183),RedSet_5(1),mass5set(:,17),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),2)
  call Hotf_5pt_reduction_last(G2tensor(188),RedSet_5(1),mass5set(:,19),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),2)
  call Hotf_5pt_reduction_last(G2tensor(192),RedSet_5(1),mass5set(:,23),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),2)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(1),mass5set(:,27),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),2)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(1),mass5set(:,21),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),2)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(1),mass5set(:,18),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),2)
  call Hotf_5pt_reduction_last(G2tensor(78),RedSet_5(1),mass5set(:,20),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),2)
  call Hotf_5pt_reduction_last(G2tensor(84),RedSet_5(2),mass5set(:,2),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(88),RedSet_5(3),mass5set(:,3),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),8)
  call Hotf_5pt_reduction_last(G2tensor(92),RedSet_5(4),mass5set(:,4),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(96),RedSet_5(4),mass5set(:,5),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(100),RedSet_5(4),mass5set(:,6),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(104),RedSet_5(5),mass5set(:,7),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(108),RedSet_5(5),mass5set(:,8),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),4)
  call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(5),mass5set(:,9),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),4)
  call Hotf_5pt_reduction_last(G2tensor(116),RedSet_5(6),mass5set(:,7),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),8)
  call Hotf_5pt_reduction_last(G2tensor(120),RedSet_5(6),mass5set(:,8),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_5pt_reduction_last(G2tensor(124),RedSet_5(6),mass5set(:,9),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),8)
  call Hotf_5pt_reduction_last(G2tensor(128),RedSet_5(7),mass5set(:,3),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_5pt_reduction_last(G2tensor(132),RedSet_5(8),mass5set(:,10),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(136),RedSet_5(8),mass5set(:,11),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),8)
  call Hotf_5pt_reduction_last(G2tensor(140),RedSet_5(8),mass5set(:,12),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(9),mass5set(:,14),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(10),mass5set(:,14),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),8)
  call Hotf_5pt_reduction_last(G2tensor(170),RedSet_5(12),mass5set(:,10),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),4)
  call Hotf_5pt_reduction_last(G2tensor(174),RedSet_5(12),mass5set(:,11),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),4)
  call Hotf_5pt_reduction_last(G2tensor(178),RedSet_5(12),mass5set(:,12),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])



end subroutine vamp_1

end module ol_vamp_1_ppvvj_ew_bbxwwxg_1_/**/REALKIND
