
module ol_colourmatrix_ppvvj_ew_uuuxuxaz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(92,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   0,   9,   0,   3]
  K1( 2,:) = [   9,   0,   3,   0]
  K1( 3,:) = [   0,   3,   0,   9]
  K1( 4,:) = [   3,   0,   9,   0]
  K1( 5,:) = [  12,   0,   4,   0]
  K1( 6,:) = [   0,   0,   0,   0]
  K1( 7,:) = [   4,   0,  12,   0]
  K1( 8,:) = [   0,   0,   0,   0]
  K1( 9,:) = [   0,   0,   4,   0]
  K1(10,:) = [   0,   0,   0,   0]
  K1(11,:) = [   4,   0,   0,   0]
  K1(12,:) = [   0,   0,   0,   0]
  K1(13,:) = [  12,   0,   4,   0]
  K1(14,:) = [   0,   0,   0,   0]
  K1(15,:) = [   4,   0,  12,   0]
  K1(16,:) = [   0,   0,   0,   0]
  K1(17,:) = [   0,   0,  -4,   0]
  K1(18,:) = [   0,   0,   0,   0]
  K1(19,:) = [  -4,   0, -12,   0]
  K1(20,:) = [   0,   0,   0,   0]
  K1(21,:) = [ -12,   0,  -4,   0]
  K1(22,:) = [   0,   0,   0,   0]
  K1(23,:) = [  -4,   0,   0,   0]
  K1(24,:) = [   0,   0,   0,   0]
  K1(25,:) = [  12,   0,   4,   0]
  K1(26,:) = [   0,   0,   0,   0]
  K1(27,:) = [   4,   0,  12,   0]
  K1(28,:) = [   0,   0,   0,   0]
  K1(29,:) = [ -12,   0,  -4,   0]
  K1(30,:) = [   0,   0,   0,   0]
  K1(31,:) = [  -4,   0,   0,   0]
  K1(32,:) = [   0,   0,   0,   0]
  K1(33,:) = [   0,   0,  -4,   0]
  K1(34,:) = [   0,   0,   0,   0]
  K1(35,:) = [  -4,   0, -12,   0]
  K1(36,:) = [   0,   0,   0,   0]
  K1(37,:) = [   0,   0,   4,   0]
  K1(38,:) = [   0,   0,   0,   0]
  K1(39,:) = [   4,   0,   0,   0]
  K1(40,:) = [   0,   0,   0,   0]
  K1(41,:) = [  12,   0,   4,   0]
  K1(42,:) = [   0,   0,   0,   0]
  K1(43,:) = [   4,   0,  12,   0]
  K1(44,:) = [   0,   0,   0,   0]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [   0,   0,   0,   0]
  K1(66,:) = [   0,   0,   0,   0]
  K1(67,:) = [   0,   0,   0,   0]
  K1(68,:) = [   0,   0,   0,   0]
  K1(69,:) = [   0,   0,   0,   0]
  K1(70,:) = [   0,   0,   0,   0]
  K1(71,:) = [   0,   0,   0,   0]
  K1(72,:) = [   0,   0,   0,   0]
  K1(73,:) = [   0,   0,   0,   0]
  K1(74,:) = [   0,   0,   0,   0]
  K1(75,:) = [   0,   0,   0,   0]
  K1(76,:) = [   0,   0,   0,   0]
  K1(77,:) = [   0,   0,   0,   0]
  K1(78,:) = [   0,   0,   0,   0]
  K1(79,:) = [   0,   0,   0,   0]
  K1(80,:) = [   0,   0,   0,   0]
  K1(81,:) = [   0,   0,   0,   0]
  K1(82,:) = [   0,   0,   0,   0]
  K1(83,:) = [   0,   0,   0,   0]
  K1(84,:) = [   0,   0,   0,   0]
  K1(85,:) = [   0,   0,   0,   0]
  K1(86,:) = [   0,   0,   0,   0]
  K1(87,:) = [   0,   0,   0,   0]
  K1(88,:) = [   0,   0,   0,   0]
  K1(89,:) = [   0,   9,   0,   3]
  K1(90,:) = [   9,   0,   3,   0]
  K1(91,:) = [   0,   3,   0,   9]
  K1(92,:) = [   3,   0,   9,   0]


  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvj_ew_uuuxuxaz_1_/**/REALKIND



module ol_forced_parameters_ppvvj_ew_uuuxuxaz_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvj_ew_uuuxuxaz_1_/**/REALKIND

module ol_tree_ppvvj_ew_uuuxuxaz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(3)
  complex(REALKIND), save :: den(172)
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind2), parameter :: nheltot = 96 ! number of helicity configurations
  integer(intkind2), save :: nhel = 96 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(96) ! physical helicity states
  complex(DREALKIND) :: M1helarr(4,96) ! cache
#endif

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = (8*CI*eQED**4)/27._/**/REALKIND
    f(2) = (2*CI*eQED**4)/3._/**/REALKIND
    f(3) = (2*CI*eQED**2*gQCD**2)/3._/**/REALKIND

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none

  ! propagators

  den(1) = 1 /((L(5,5))+L(6,5))
  den(2) = 1 /((L(5,18))+L(6,18))
  den(3) = 1 /((L(5,40))+L(6,40))
  den(6) = 1 /((L(5,5) - MZ2)+L(6,5))
  den(9) = 1 /((L(5,13))+L(6,13))
  den(14) = 1 /((L(5,34))+L(6,34))
  den(15) = 1 /((L(5,24))+L(6,24))
  den(20) = 1 /((L(5,7))+L(6,7))
  den(29) = 1 /((L(5,17))+L(6,17))
  den(30) = 1 /((L(5,6))+L(6,6))
  den(33) = 1 /((L(5,6) - MZ2)+L(6,6))
  den(36) = 1 /((L(5,14))+L(6,14))
  den(41) = 1 /((L(5,33))+L(6,33))
  den(54) = 1 /((L(5,9))+L(6,9))
  den(55) = 1 /((L(5,36))+L(6,36))
  den(58) = 1 /((L(5,9) - MZ2)+L(6,9))
  den(65) = 1 /((L(5,20))+L(6,20))
  den(70) = 1 /((L(5,11))+L(6,11))
  den(79) = 1 /((L(5,10))+L(6,10))
  den(82) = 1 /((L(5,10) - MZ2)+L(6,10))
  den(101) = 1 /((L(5,21))+L(6,21))
  den(104) = 1 /((L(5,21) - MZ2)+L(6,21))
  den(107) = 1 /((L(5,38))+L(6,38))
  den(110) = 1 /((L(5,38) - MZ2)+L(6,38))
  den(117) = 1 /((L(5,42))+L(6,42))
  den(120) = 1 /((L(5,42) - MZ2)+L(6,42))
  den(123) = 1 /((L(5,37))+L(6,37))
  den(126) = 1 /((L(5,37) - MZ2)+L(6,37))
  den(129) = 1 /((L(5,22))+L(6,22))
  den(132) = 1 /((L(5,22) - MZ2)+L(6,22))
  den(139) = 1 /((L(5,41))+L(6,41))
  den(142) = 1 /((L(5,41) - MZ2)+L(6,41))
  den(157) = 1 /((L(5,26))+L(6,26))
  den(160) = 1 /((L(5,26) - MZ2)+L(6,26))
  den(163) = 1 /((L(5,25))+L(6,25))
  den(166) = 1 /((L(5,25) - MZ2)+L(6,25))

  ! denominators

  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(3)*den(7)
  den(10) = den(1)*den(9)
  den(11) = den(2)*den(10)
  den(12) = den(6)*den(9)
  den(13) = den(2)*den(12)
  den(16) = den(1)*den(14)
  den(17) = den(15)*den(16)
  den(18) = den(6)*den(14)
  den(19) = den(15)*den(18)
  den(21) = den(1)*den(20)
  den(22) = den(15)*den(21)
  den(23) = den(6)*den(20)
  den(24) = den(15)*den(23)
  den(25) = den(10)*den(14)
  den(26) = den(12)*den(14)
  den(27) = den(3)*den(21)
  den(28) = den(3)*den(23)
  den(31) = den(29)*den(30)
  den(32) = den(3)*den(31)
  den(34) = den(29)*den(33)
  den(35) = den(3)*den(34)
  den(37) = den(30)*den(36)
  den(38) = den(29)*den(37)
  den(39) = den(33)*den(36)
  den(40) = den(29)*den(39)
  den(42) = den(30)*den(41)
  den(43) = den(15)*den(42)
  den(44) = den(33)*den(41)
  den(45) = den(15)*den(44)
  den(46) = den(20)*den(30)
  den(47) = den(15)*den(46)
  den(48) = den(20)*den(33)
  den(49) = den(15)*den(48)
  den(50) = den(37)*den(41)
  den(51) = den(39)*den(41)
  den(52) = den(3)*den(46)
  den(53) = den(3)*den(48)
  den(56) = den(2)*den(54)
  den(57) = den(55)*den(56)
  den(59) = den(2)*den(58)
  den(60) = den(55)*den(59)
  den(61) = den(9)*den(54)
  den(62) = den(2)*den(61)
  den(63) = den(9)*den(58)
  den(64) = den(2)*den(63)
  den(66) = den(14)*den(54)
  den(67) = den(65)*den(66)
  den(68) = den(14)*den(58)
  den(69) = den(65)*den(68)
  den(71) = den(54)*den(70)
  den(72) = den(65)*den(71)
  den(73) = den(58)*den(70)
  den(74) = den(65)*den(73)
  den(75) = den(14)*den(61)
  den(76) = den(14)*den(63)
  den(77) = den(55)*den(71)
  den(78) = den(55)*den(73)
  den(80) = den(29)*den(79)
  den(81) = den(55)*den(80)
  den(83) = den(29)*den(82)
  den(84) = den(55)*den(83)
  den(85) = den(36)*den(79)
  den(86) = den(29)*den(85)
  den(87) = den(36)*den(82)
  den(88) = den(29)*den(87)
  den(89) = den(41)*den(79)
  den(90) = den(65)*den(89)
  den(91) = den(41)*den(82)
  den(92) = den(65)*den(91)
  den(93) = den(70)*den(79)
  den(94) = den(65)*den(93)
  den(95) = den(70)*den(82)
  den(96) = den(65)*den(95)
  den(97) = den(41)*den(85)
  den(98) = den(41)*den(87)
  den(99) = den(55)*den(93)
  den(100) = den(55)*den(95)
  den(102) = den(29)*den(101)
  den(103) = den(14)*den(102)
  den(105) = den(29)*den(104)
  den(106) = den(14)*den(105)
  den(108) = den(14)*den(107)
  den(109) = den(29)*den(108)
  den(111) = den(14)*den(110)
  den(112) = den(29)*den(111)
  den(113) = den(55)*den(107)
  den(114) = den(29)*den(113)
  den(115) = den(55)*den(110)
  den(116) = den(29)*den(115)
  den(118) = den(3)*den(117)
  den(119) = den(29)*den(118)
  den(121) = den(3)*den(120)
  den(122) = den(29)*den(121)
  den(124) = den(41)*den(123)
  den(125) = den(2)*den(124)
  den(127) = den(41)*den(126)
  den(128) = den(2)*den(127)
  den(130) = den(2)*den(129)
  den(131) = den(41)*den(130)
  den(133) = den(2)*den(132)
  den(134) = den(41)*den(133)
  den(135) = den(55)*den(123)
  den(136) = den(2)*den(135)
  den(137) = den(55)*den(126)
  den(138) = den(2)*den(137)
  den(140) = den(3)*den(139)
  den(141) = den(2)*den(140)
  den(143) = den(3)*den(142)
  den(144) = den(2)*den(143)
  den(145) = den(65)*den(129)
  den(146) = den(41)*den(145)
  den(147) = den(65)*den(132)
  den(148) = den(41)*den(147)
  den(149) = den(65)*den(101)
  den(150) = den(14)*den(149)
  den(151) = den(65)*den(104)
  den(152) = den(14)*den(151)
  den(153) = den(3)*den(149)
  den(154) = den(3)*den(151)
  den(155) = den(65)*den(140)
  den(156) = den(65)*den(143)
  den(158) = den(15)*den(157)
  den(159) = den(41)*den(158)
  den(161) = den(15)*den(160)
  den(162) = den(41)*den(161)
  den(164) = den(15)*den(163)
  den(165) = den(14)*den(164)
  den(167) = den(15)*den(166)
  den(168) = den(14)*den(167)
  den(169) = den(15)*den(135)
  den(170) = den(15)*den(137)
  den(171) = den(55)*den(164)
  den(172) = den(55)*den(167)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu) &
    & bind(c,name="ol_f_amp2_ppvvj_ew_uuuxuxaz_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu)
  use ol_tree_ppvvj_ew_uuuxuxaz_1_/**/DREALKIND, only: &
    & ntry, nhel, Hel, M1helarr
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up up anti-up anti-up gamma Z -> 0
! I   = emitter, 0 means none (replace wave function I in the current crossing by the momentum MOM),
!       for I < 0 emitter for PowHeg B^mu,nu
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! M2munu = Spin correlated born squared amplitude in PowHeg format B^mu,nu for emitter -I
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_init, only: tree_parameters_flush
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: L
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_ppvvj_ew_uuuxuxaz_1, only: &
    & external_perm_ppvvj_ew_uuuxuxaz_1, &
    & external_perm_inv_ppvvj_ew_uuuxuxaz_1, &
    & extcomb_perm_ppvvj_ew_uuuxuxaz_1, &
    & average_factor_ppvvj_ew_uuuxuxaz_1, &
    & photonid_ppvvj_ew_uuuxuxaz_1
  use ol_external_ppvvj_ew_uuuxuxaz_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppvvj_ew_uuuxuxaz_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppvvj_ew_uuuxuxaz_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_ppvvj_ew_uuuxuxaz_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M2(0:23-1)
  real(REALKIND),  intent(out) :: M2munu(4,4)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, JBmunu, extcombs_permuted(nextcombs), shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add(0:23-1)
  complex(REALKIND) :: M2munuadd(2)
  complex(REALKIND) :: MOM_LC(4), M1(4), M1helarray(4,96)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  complex(REALKIND) :: epLC(1:4), epStd(1:4,2)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0, bornphotonfactor
  integer(intkind1) :: nsync

  ! type(wfun) :: ex1(h1), ex2(h2), ... ! external wave functions for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(3)

  ! type(wfun) :: wf<h>(h,n), ... ! n wave functions with h helicity configurations
  type(wfun) :: wf4(4,20), wf6(6,8), wf8(8,54), wf12(12,30), wf16(16,8), wf24(24,8), wf96(96,120)

  type(polcont) :: A(96,120)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call tree_parameters_flush()
  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    call check_forced_parameters()
  end if
  call factors_init()

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, nMZ ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
      &  external_perm_inv_ppvvj_ew_uuuxuxaz_1, 6,.false.)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  JBmunu = 0
  if (I > 0) then
    ReplacePol = external_perm_ppvvj_ew_uuuxuxaz_1(I)
  else if (I < 0) then
    JBmunu = external_perm_ppvvj_ew_uuuxuxaz_1(-I)
  end if

  do k = 1, nextcombs
    extcombs_permuted(k) = &
       & extcomb_perm_ppvvj_ew_uuuxuxaz_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  42 continue
  ! external WFs
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1))
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2))
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3))
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4))
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5))
  call pol_wf_V(P(:,6), rMZ, H6, ex6, POLSEL(6))


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...

    if (any(POLSEL /= 0)) then

      call pol_wf_Q(P(:,1), rZERO, H1, ex1, 0)
      call pol_wf_Q(P(:,2), rZERO, H2, ex2, 0)
      call pol_wf_A(P(:,3), rZERO, H3, ex3, 0)
      call pol_wf_A(P(:,4), rZERO, H4, ex4, 0)
      call pol_wf_V(P(:,5), rZERO, H5, ex5, 0)
      call pol_wf_V(P(:,6), rMZ, H6, ex6, 0)

    end if

    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1, ex3, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VQ_A(ntry, ex5, ex2, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AZ_Q(gZu,ntry, ex4, ex6, wf6(:,1), n3(:,3), t3x6(:,:,1))
  call prop_Q_A(ntry, wf4(:,2), 18, ZERO, 0_intkind1, wf4(:,3), n2(1))
  call prop_A_Q(ntry, wf6(:,1), 40, ZERO, 0_intkind1, wf6(:,2), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,3), wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_QA_Z(gZu,ntry, ex1, ex3, wf4(:,4), n3(:,5), t3x4(:,:,3))
  call prop_W_W(ntry, wf4(:,4), 5, MZ, 1_intkind1, wf4(:,5), n2(3))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf4(:,3), wf16(:,2), n3(:,6), t3x16(:,:,2))
  call vert_AV_Q(ntry, ex4, wf4(:,1), wf8(:,1), n3(:,7), t3x8(:,:,1))
  call vert_ZQ_A(gZu,ntry, ex6, wf4(:,3), wf12(:,1), n3(:,8), t3x12(:,:,1))
  call prop_A_Q(ntry, wf8(:,1), 13, ZERO, 0_intkind1, wf8(:,2), n2(4))
  call vert_AZ_Q(gZu,ntry, ex4, wf4(:,5), wf8(:,3), n3(:,9), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 13, ZERO, 0_intkind1, wf8(:,4), n2(5))
  call vert_ZQ_A(gZu,ntry, ex6, ex2, wf6(:,3), n3(:,10), t3x6(:,:,2))
  call vert_AV_Q(ntry, ex4, ex5, wf4(:,6), n3(:,11), t3x4(:,:,4))
  call prop_Q_A(ntry, wf6(:,3), 34, ZERO, 0_intkind1, wf6(:,4), n2(6))
  call prop_A_Q(ntry, wf4(:,6), 24, ZERO, 0_intkind1, wf4(:,7), n2(7))
  call vert_VQ_A(ntry, wf4(:,1), wf6(:,4), wf24(:,1), n3(:,12), t3x24(:,:,1))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf6(:,4), wf24(:,2), n3(:,13), t3x24(:,:,2))
  call vert_VQ_A(ntry, wf4(:,1), ex2, wf8(:,5), n3(:,14), t3x8(:,:,3))
  call vert_AZ_Q(gZu,ntry, wf4(:,7), ex6, wf12(:,2), n3(:,15), t3x12(:,:,2))
  call prop_Q_A(ntry, wf8(:,5), 7, ZERO, 0_intkind1, wf8(:,6), n2(8))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), ex2, wf8(:,7), n3(:,16), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,7), 7, ZERO, 0_intkind1, wf8(:,8), n2(9))
  call vert_VQ_A(ntry, ex5, wf6(:,4), wf12(:,3), n3(:,17), t3x12(:,:,3))
  call vert_AV_Q(ntry, wf6(:,2), ex5, wf12(:,4), n3(:,18), t3x12(:,:,4))
  call vert_VQ_A(ntry, ex5, ex1, wf4(:,8), n3(:,19), t3x4(:,:,5))
  call vert_QA_V(ntry, ex2, ex3, wf4(:,9), n3(:,20), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,8), 17, ZERO, 0_intkind1, wf4(:,10), n2(10))
  call vert_VQ_A(ntry, wf4(:,9), wf4(:,10), wf16(:,3), n3(:,21), t3x16(:,:,3))
  call vert_QA_Z(gZu,ntry, ex2, ex3, wf4(:,11), n3(:,22), t3x4(:,:,7))
  call prop_W_W(ntry, wf4(:,11), 6, MZ, 1_intkind1, wf4(:,12), n2(11))
  call vert_ZQ_A(gZu,ntry, wf4(:,12), wf4(:,10), wf16(:,4), n3(:,23), t3x16(:,:,4))
  call vert_AV_Q(ntry, ex4, wf4(:,9), wf8(:,9), n3(:,24), t3x8(:,:,5))
  call vert_ZQ_A(gZu,ntry, ex6, wf4(:,10), wf12(:,5), n3(:,25), t3x12(:,:,5))
  call prop_A_Q(ntry, wf8(:,9), 14, ZERO, 0_intkind1, wf8(:,10), n2(12))
  call vert_AZ_Q(gZu,ntry, ex4, wf4(:,12), wf8(:,11), n3(:,26), t3x8(:,:,6))
  call prop_A_Q(ntry, wf8(:,11), 14, ZERO, 0_intkind1, wf8(:,12), n2(13))
  call vert_ZQ_A(gZu,ntry, ex6, ex1, wf6(:,5), n3(:,27), t3x6(:,:,3))
  call prop_Q_A(ntry, wf6(:,5), 33, ZERO, 0_intkind1, wf6(:,6), n2(14))
  call vert_VQ_A(ntry, wf4(:,9), wf6(:,6), wf24(:,3), n3(:,28), t3x24(:,:,3))
  call vert_ZQ_A(gZu,ntry, wf4(:,12), wf6(:,6), wf24(:,4), n3(:,29), t3x24(:,:,4))
  call vert_VQ_A(ntry, wf4(:,9), ex1, wf8(:,13), n3(:,30), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,13), 7, ZERO, 0_intkind1, wf8(:,14), n2(15))
  call vert_ZQ_A(gZu,ntry, wf4(:,12), ex1, wf8(:,15), n3(:,31), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,15), 7, ZERO, 0_intkind1, wf8(:,16), n2(16))
  call vert_VQ_A(ntry, ex5, wf6(:,6), wf12(:,6), n3(:,32), t3x12(:,:,6))
  call vert_QA_V(ntry, ex1, ex4, wf4(:,13), n3(:,33), t3x4(:,:,8))
  call vert_AZ_Q(gZu,ntry, ex3, ex6, wf6(:,7), n3(:,34), t3x6(:,:,4))
  call prop_A_Q(ntry, wf6(:,7), 36, ZERO, 0_intkind1, wf6(:,8), n2(17))
  call vert_VQ_A(ntry, wf4(:,13), wf4(:,3), wf16(:,5), n3(:,35), t3x16(:,:,5))
  call vert_QA_Z(gZu,ntry, ex1, ex4, wf4(:,14), n3(:,36), t3x4(:,:,9))
  call prop_W_W(ntry, wf4(:,14), 9, MZ, 1_intkind1, wf4(:,15), n2(18))
  call vert_ZQ_A(gZu,ntry, wf4(:,15), wf4(:,3), wf16(:,6), n3(:,37), t3x16(:,:,6))
  call vert_AV_Q(ntry, ex3, wf4(:,13), wf8(:,17), n3(:,38), t3x8(:,:,9))
  call prop_A_Q(ntry, wf8(:,17), 13, ZERO, 0_intkind1, wf8(:,18), n2(19))
  call vert_AZ_Q(gZu,ntry, ex3, wf4(:,15), wf8(:,19), n3(:,39), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,19), 13, ZERO, 0_intkind1, wf8(:,20), n2(20))
  call vert_AV_Q(ntry, ex3, ex5, wf4(:,16), n3(:,40), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,16), 20, ZERO, 0_intkind1, wf4(:,17), n2(21))
  call vert_VQ_A(ntry, wf4(:,13), wf6(:,4), wf24(:,5), n3(:,41), t3x24(:,:,5))
  call vert_ZQ_A(gZu,ntry, wf4(:,15), wf6(:,4), wf24(:,6), n3(:,42), t3x24(:,:,6))
  call vert_VQ_A(ntry, wf4(:,13), ex2, wf8(:,21), n3(:,43), t3x8(:,:,11))
  call vert_AZ_Q(gZu,ntry, wf4(:,17), ex6, wf12(:,7), n3(:,44), t3x12(:,:,7))
  call prop_Q_A(ntry, wf8(:,21), 11, ZERO, 0_intkind1, wf8(:,22), n2(22))
  call vert_ZQ_A(gZu,ntry, wf4(:,15), ex2, wf8(:,23), n3(:,45), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,23), 11, ZERO, 0_intkind1, wf8(:,24), n2(23))
  call vert_AV_Q(ntry, wf6(:,8), ex5, wf12(:,8), n3(:,46), t3x12(:,:,8))
  call vert_QA_V(ntry, ex2, ex4, wf4(:,18), n3(:,47), t3x4(:,:,11))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,10), wf16(:,7), n3(:,48), t3x16(:,:,7))
  call vert_QA_Z(gZu,ntry, ex2, ex4, wf4(:,19), n3(:,49), t3x4(:,:,12))
  call prop_W_W(ntry, wf4(:,19), 10, MZ, 1_intkind1, wf4(:,20), n2(24))
  call vert_ZQ_A(gZu,ntry, wf4(:,20), wf4(:,10), wf16(:,8), n3(:,50), t3x16(:,:,8))
  call vert_AV_Q(ntry, ex3, wf4(:,18), wf8(:,25), n3(:,51), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,25), 14, ZERO, 0_intkind1, wf8(:,26), n2(25))
  call vert_AZ_Q(gZu,ntry, ex3, wf4(:,20), wf8(:,27), n3(:,52), t3x8(:,:,14))
  call prop_A_Q(ntry, wf8(:,27), 14, ZERO, 0_intkind1, wf8(:,28), n2(26))
  call vert_VQ_A(ntry, wf4(:,18), wf6(:,6), wf24(:,7), n3(:,53), t3x24(:,:,7))
  call vert_ZQ_A(gZu,ntry, wf4(:,20), wf6(:,6), wf24(:,8), n3(:,54), t3x24(:,:,8))
  call vert_VQ_A(ntry, wf4(:,18), ex1, wf8(:,29), n3(:,55), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,29), 11, ZERO, 0_intkind1, wf8(:,30), n2(27))
  call vert_ZQ_A(gZu,ntry, wf4(:,20), ex1, wf8(:,31), n3(:,56), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,31), 11, ZERO, 0_intkind1, wf8(:,32), n2(28))
  call vert_QA_V(ntry, wf4(:,10), ex3, wf8(:,33), n3(:,57), t3x8(:,:,17))
  call vert_QA_V(ntry, wf6(:,4), ex4, wf12(:,9), n3(:,58), t3x12(:,:,9))
  call vert_QA_Z(gZu,ntry, wf4(:,10), ex3, wf8(:,34), n3(:,59), t3x8(:,:,18))
  call vert_QA_Z(gZu,ntry, wf6(:,4), ex4, wf12(:,10), n3(:,60), t3x12(:,:,10))
  call prop_W_W(ntry, wf8(:,34), 21, MZ, 1_intkind1, wf8(:,35), n2(29))
  call vert_QA_V(ntry, wf6(:,4), ex3, wf12(:,11), n3(:,61), t3x12(:,:,11))
  call vert_QA_V(ntry, wf4(:,10), ex4, wf8(:,36), n3(:,62), t3x8(:,:,19))
  call vert_QA_Z(gZu,ntry, wf6(:,4), ex3, wf12(:,12), n3(:,63), t3x12(:,:,12))
  call vert_QA_Z(gZu,ntry, wf4(:,10), ex4, wf8(:,37), n3(:,64), t3x8(:,:,20))
  call prop_W_W(ntry, wf12(:,12), 38, MZ, 1_intkind1, wf12(:,13), n2(30))
  call vert_QA_V(ntry, ex2, wf6(:,8), wf12(:,14), n3(:,65), t3x12(:,:,13))
  call vert_QA_Z(gZu,ntry, ex2, wf6(:,8), wf12(:,15), n3(:,66), t3x12(:,:,14))
  call prop_W_W(ntry, wf12(:,15), 38, MZ, 1_intkind1, wf12(:,16), n2(31))
  call vert_QA_V(ntry, ex2, wf6(:,2), wf12(:,17), n3(:,67), t3x12(:,:,15))
  call vert_QA_Z(gZu,ntry, ex2, wf6(:,2), wf12(:,18), n3(:,68), t3x12(:,:,16))
  call prop_W_W(ntry, wf12(:,18), 42, MZ, 1_intkind1, wf12(:,19), n2(32))
  call vert_QA_V(ntry, wf6(:,6), ex3, wf12(:,20), n3(:,69), t3x12(:,:,17))
  call vert_QA_V(ntry, wf4(:,3), ex4, wf8(:,38), n3(:,70), t3x8(:,:,21))
  call vert_QA_Z(gZu,ntry, wf6(:,6), ex3, wf12(:,21), n3(:,71), t3x12(:,:,18))
  call vert_QA_Z(gZu,ntry, wf4(:,3), ex4, wf8(:,39), n3(:,72), t3x8(:,:,22))
  call prop_W_W(ntry, wf12(:,21), 37, MZ, 1_intkind1, wf12(:,22), n2(33))
  call vert_QA_V(ntry, wf4(:,3), ex3, wf8(:,40), n3(:,73), t3x8(:,:,23))
  call vert_QA_V(ntry, wf6(:,6), ex4, wf12(:,23), n3(:,74), t3x12(:,:,19))
  call vert_QA_Z(gZu,ntry, wf4(:,3), ex3, wf8(:,41), n3(:,75), t3x8(:,:,24))
  call vert_QA_Z(gZu,ntry, wf6(:,6), ex4, wf12(:,24), n3(:,76), t3x12(:,:,20))
  call prop_W_W(ntry, wf8(:,41), 22, MZ, 1_intkind1, wf8(:,42), n2(34))
  call vert_QA_V(ntry, ex1, wf6(:,8), wf12(:,25), n3(:,77), t3x12(:,:,21))
  call vert_QA_Z(gZu,ntry, ex1, wf6(:,8), wf12(:,26), n3(:,78), t3x12(:,:,22))
  call prop_W_W(ntry, wf12(:,26), 37, MZ, 1_intkind1, wf12(:,27), n2(35))
  call vert_QA_V(ntry, ex1, wf6(:,2), wf12(:,28), n3(:,79), t3x12(:,:,23))
  call vert_QA_Z(gZu,ntry, ex1, wf6(:,2), wf12(:,29), n3(:,80), t3x12(:,:,24))
  call prop_W_W(ntry, wf12(:,29), 41, MZ, 1_intkind1, wf12(:,30), n2(36))
  call vert_QA_V(ntry, ex2, wf4(:,17), wf8(:,43), n3(:,81), t3x8(:,:,25))
  call vert_QA_Z(gZu,ntry, ex2, wf4(:,17), wf8(:,44), n3(:,82), t3x8(:,:,26))
  call prop_W_W(ntry, wf8(:,44), 22, MZ, 1_intkind1, wf8(:,45), n2(37))
  call vert_QA_V(ntry, ex1, wf4(:,17), wf8(:,46), n3(:,83), t3x8(:,:,27))
  call vert_QA_Z(gZu,ntry, ex1, wf4(:,17), wf8(:,47), n3(:,84), t3x8(:,:,28))
  call prop_W_W(ntry, wf8(:,47), 21, MZ, 1_intkind1, wf8(:,48), n2(38))
  call vert_QA_V(ntry, ex2, wf4(:,7), wf8(:,49), n3(:,85), t3x8(:,:,29))
  call vert_QA_Z(gZu,ntry, ex2, wf4(:,7), wf8(:,50), n3(:,86), t3x8(:,:,30))
  call prop_W_W(ntry, wf8(:,50), 26, MZ, 1_intkind1, wf8(:,51), n2(39))
  call vert_QA_V(ntry, ex1, wf4(:,7), wf8(:,52), n3(:,87), t3x8(:,:,31))
  call vert_QA_Z(gZu,ntry, ex1, wf4(:,7), wf8(:,53), n3(:,88), t3x8(:,:,32))
  call prop_W_W(ntry, wf8(:,53), 25, MZ, 1_intkind1, wf8(:,54), n2(40))


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
      if (any(POLSEL /= 0)) then
        ntry = 2
        goto 42
      end if
    end if
  end do

  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do
  M1helarray(:,nhel+1:) = 0
  M1helarr = M1helarray ! fill cache

  M2 = 0
  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it does not vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint2(M1helarray(:,k), M1, M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.5_/**/REALKIND * M2

  end if

  M2munu = 0
  if ( JBmunu /= 0 ) then ! POWHEGs Bmunu helicity correlation
    P_scatt_intern = P_scatt
    ! get wfs
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, -1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,1))
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, 1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,2))

    ! sum over helicities
    do k = 1, nhel
      !same helicity case
      call colintmunu(M1helarray(:,k), M1helarray(:,k), M2munuadd(1))
      !opposite helicity case
      r = eflip(k, JBmunu) ! Flip helicity of external particle JBmunu (gluon emitter).
      if (r <= nhel) then  ! Only add opposite helicity configuration if it does not vanish.
        call colintmunu(M1helarray(:,k), M1helarray(:,r), M2munuadd(2))
      else
        M2munuadd(2) = 0
      end if
      ! Fill B^(mu,nu) = sum_(k) sum_(l1,l2) M^*_(k) M_(k) (eps^(mu)_(l1))^* eps^(nu)_(l2)
      do m = 1,4
        do n = 1,4
          M2munu(m,n) = M2munu(m,n) + M2munuadd(1)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(k,JBmunu))
          if (r <= nhel) then
            M2munu(m,n) = M2munu(m,n) + M2munuadd(2)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(r,JBmunu))
          end if
        end do
      end do
    end do

    M2munu = M2munu / average_factor_ppvvj_ew_uuuxuxaz_1
  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_ppvvj_ew_uuuxuxaz_1

  do k = 0, 23-1
    M2(k) = M2add(extcomb_perm_ppvvj_ew_uuuxuxaz_1(k))
  end do

  ! photon-factors
  call photon_factors(photonid_ppvvj_ew_uuuxuxaz_1, 0, bornphotonfactor)
  M2 = bornphotonfactor * M2
  M2munu = bornphotonfactor * M2munu

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*6-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2
  M2munu = scalebackfactor * M2munu

  contains

subroutine diagrams()
  implicit none
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_QA(nsync, wf6(:,2), wf16(:,1), A(:,1), n3(:,89), t3x96(:,:,1), nhel, den(5))
    call cont_QA(nsync, wf6(:,2), wf16(:,2), A(:,2), n3(:,90), t3x96(:,:,2), nhel, den(8))
    call cont_QA(nsync, wf6(:,2), wf16(:,1), A(:,3), n3(:,91), t3x96(:,:,3), nhel, den(5))
    call cont_QA(nsync, wf12(:,1), wf8(:,2), A(:,4), n3(:,92), t3x96(:,:,4), nhel, den(11))
    call cont_QA(nsync, wf12(:,1), wf8(:,4), A(:,5), n3(:,93), t3x96(:,:,5), nhel, den(13))
    call cont_QA(nsync, wf12(:,1), wf8(:,2), A(:,6), n3(:,94), t3x96(:,:,6), nhel, den(11))
    call cont_QA(nsync, wf4(:,7), wf24(:,1), A(:,7), n3(:,95), t3x96(:,:,7), nhel, den(17))
    call cont_QA(nsync, wf4(:,7), wf24(:,2), A(:,8), n3(:,96), t3x96(:,:,8), nhel, den(19))
    call cont_QA(nsync, wf4(:,7), wf24(:,1), A(:,9), n3(:,97), t3x96(:,:,9), nhel, den(17))
    call cont_QA(nsync, wf12(:,2), wf8(:,6), A(:,10), n3(:,98), t3x96(:,:,10), nhel, den(22))
    call cont_QA(nsync, wf12(:,2), wf8(:,8), A(:,11), n3(:,99), t3x96(:,:,11), nhel, den(24))
    call cont_QA(nsync, wf12(:,2), wf8(:,6), A(:,12), n3(:,100), t3x96(:,:,12), nhel, den(22))
    call cont_QA(nsync, wf8(:,2), wf12(:,3), A(:,13), n3(:,101), t3x96(:,:,13), nhel, den(25))
    call cont_QA(nsync, wf8(:,4), wf12(:,3), A(:,14), n3(:,102), t3x96(:,:,14), nhel, den(26))
    call cont_QA(nsync, wf8(:,2), wf12(:,3), A(:,15), n3(:,103), t3x96(:,:,15), nhel, den(25))
    call cont_QA(nsync, wf8(:,6), wf12(:,4), A(:,16), n3(:,104), t3x96(:,:,16), nhel, den(27))
    call cont_QA(nsync, wf8(:,8), wf12(:,4), A(:,17), n3(:,105), t3x96(:,:,17), nhel, den(28))
    call cont_QA(nsync, wf8(:,6), wf12(:,4), A(:,18), n3(:,106), t3x96(:,:,18), nhel, den(27))
    call cont_QA(nsync, wf6(:,2), wf16(:,3), A(:,19), n3(:,107), t3x96(:,:,19), nhel, den(32))
    call cont_QA(nsync, wf6(:,2), wf16(:,4), A(:,20), n3(:,108), t3x96(:,:,20), nhel, den(35))
    call cont_QA(nsync, wf6(:,2), wf16(:,3), A(:,21), n3(:,109), t3x96(:,:,21), nhel, den(32))
    call cont_QA(nsync, wf12(:,5), wf8(:,10), A(:,22), n3(:,110), t3x96(:,:,22), nhel, den(38))
    call cont_QA(nsync, wf12(:,5), wf8(:,12), A(:,23), n3(:,111), t3x96(:,:,23), nhel, den(40))
    call cont_QA(nsync, wf12(:,5), wf8(:,10), A(:,24), n3(:,112), t3x96(:,:,24), nhel, den(38))
    call cont_QA(nsync, wf4(:,7), wf24(:,3), A(:,25), n3(:,113), t3x96(:,:,25), nhel, den(43))
    call cont_QA(nsync, wf4(:,7), wf24(:,4), A(:,26), n3(:,114), t3x96(:,:,26), nhel, den(45))
    call cont_QA(nsync, wf4(:,7), wf24(:,3), A(:,27), n3(:,115), t3x96(:,:,27), nhel, den(43))
    call cont_QA(nsync, wf12(:,2), wf8(:,14), A(:,28), n3(:,116), t3x96(:,:,28), nhel, den(47))
    call cont_QA(nsync, wf12(:,2), wf8(:,16), A(:,29), n3(:,117), t3x96(:,:,29), nhel, den(49))
    call cont_QA(nsync, wf12(:,2), wf8(:,14), A(:,30), n3(:,118), t3x96(:,:,30), nhel, den(47))
    call cont_QA(nsync, wf8(:,10), wf12(:,6), A(:,31), n3(:,119), t3x96(:,:,31), nhel, den(50))
    call cont_QA(nsync, wf8(:,12), wf12(:,6), A(:,32), n3(:,120), t3x96(:,:,32), nhel, den(51))
    call cont_QA(nsync, wf8(:,10), wf12(:,6), A(:,33), n3(:,121), t3x96(:,:,33), nhel, den(50))
    call cont_QA(nsync, wf12(:,4), wf8(:,14), A(:,34), n3(:,122), t3x96(:,:,34), nhel, den(52))
    call cont_QA(nsync, wf12(:,4), wf8(:,16), A(:,35), n3(:,123), t3x96(:,:,35), nhel, den(53))
    call cont_QA(nsync, wf12(:,4), wf8(:,14), A(:,36), n3(:,124), t3x96(:,:,36), nhel, den(52))
    call cont_QA(nsync, wf6(:,8), wf16(:,5), A(:,37), n3(:,125), t3x96(:,:,37), nhel, den(57))
    call cont_QA(nsync, wf6(:,8), wf16(:,6), A(:,38), n3(:,126), t3x96(:,:,38), nhel, den(60))
    call cont_QA(nsync, wf6(:,8), wf16(:,5), A(:,39), n3(:,127), t3x96(:,:,39), nhel, den(57))
    call cont_QA(nsync, wf12(:,1), wf8(:,18), A(:,40), n3(:,128), t3x96(:,:,40), nhel, den(62))
    call cont_QA(nsync, wf12(:,1), wf8(:,20), A(:,41), n3(:,129), t3x96(:,:,41), nhel, den(64))
    call cont_QA(nsync, wf12(:,1), wf8(:,18), A(:,42), n3(:,130), t3x96(:,:,42), nhel, den(62))
    call cont_QA(nsync, wf4(:,17), wf24(:,5), A(:,43), n3(:,131), t3x96(:,:,43), nhel, den(67))
    call cont_QA(nsync, wf4(:,17), wf24(:,6), A(:,44), n3(:,132), t3x96(:,:,44), nhel, den(69))
    call cont_QA(nsync, wf4(:,17), wf24(:,5), A(:,45), n3(:,133), t3x96(:,:,45), nhel, den(67))
    call cont_QA(nsync, wf12(:,7), wf8(:,22), A(:,46), n3(:,134), t3x96(:,:,46), nhel, den(72))
    call cont_QA(nsync, wf12(:,7), wf8(:,24), A(:,47), n3(:,135), t3x96(:,:,47), nhel, den(74))
    call cont_QA(nsync, wf12(:,7), wf8(:,22), A(:,48), n3(:,136), t3x96(:,:,48), nhel, den(72))
    call cont_QA(nsync, wf12(:,3), wf8(:,18), A(:,49), n3(:,137), t3x96(:,:,49), nhel, den(75))
    call cont_QA(nsync, wf12(:,3), wf8(:,20), A(:,50), n3(:,138), t3x96(:,:,50), nhel, den(76))
    call cont_QA(nsync, wf12(:,3), wf8(:,18), A(:,51), n3(:,139), t3x96(:,:,51), nhel, den(75))
    call cont_QA(nsync, wf8(:,22), wf12(:,8), A(:,52), n3(:,140), t3x96(:,:,52), nhel, den(77))
    call cont_QA(nsync, wf8(:,24), wf12(:,8), A(:,53), n3(:,141), t3x96(:,:,53), nhel, den(78))
    call cont_QA(nsync, wf8(:,22), wf12(:,8), A(:,54), n3(:,142), t3x96(:,:,54), nhel, den(77))
    call cont_QA(nsync, wf6(:,8), wf16(:,7), A(:,55), n3(:,143), t3x96(:,:,55), nhel, den(81))
    call cont_QA(nsync, wf6(:,8), wf16(:,8), A(:,56), n3(:,144), t3x96(:,:,56), nhel, den(84))
    call cont_QA(nsync, wf6(:,8), wf16(:,7), A(:,57), n3(:,145), t3x96(:,:,57), nhel, den(81))
    call cont_QA(nsync, wf12(:,5), wf8(:,26), A(:,58), n3(:,146), t3x96(:,:,58), nhel, den(86))
    call cont_QA(nsync, wf12(:,5), wf8(:,28), A(:,59), n3(:,147), t3x96(:,:,59), nhel, den(88))
    call cont_QA(nsync, wf12(:,5), wf8(:,26), A(:,60), n3(:,148), t3x96(:,:,60), nhel, den(86))
    call cont_QA(nsync, wf4(:,17), wf24(:,7), A(:,61), n3(:,149), t3x96(:,:,61), nhel, den(90))
    call cont_QA(nsync, wf4(:,17), wf24(:,8), A(:,62), n3(:,150), t3x96(:,:,62), nhel, den(92))
    call cont_QA(nsync, wf4(:,17), wf24(:,7), A(:,63), n3(:,151), t3x96(:,:,63), nhel, den(90))
    call cont_QA(nsync, wf12(:,7), wf8(:,30), A(:,64), n3(:,152), t3x96(:,:,64), nhel, den(94))
    call cont_QA(nsync, wf12(:,7), wf8(:,32), A(:,65), n3(:,153), t3x96(:,:,65), nhel, den(96))
    call cont_QA(nsync, wf12(:,7), wf8(:,30), A(:,66), n3(:,154), t3x96(:,:,66), nhel, den(94))
    call cont_QA(nsync, wf12(:,6), wf8(:,26), A(:,67), n3(:,155), t3x96(:,:,67), nhel, den(97))
    call cont_QA(nsync, wf12(:,6), wf8(:,28), A(:,68), n3(:,156), t3x96(:,:,68), nhel, den(98))
    call cont_QA(nsync, wf12(:,6), wf8(:,26), A(:,69), n3(:,157), t3x96(:,:,69), nhel, den(97))
    call cont_QA(nsync, wf12(:,8), wf8(:,30), A(:,70), n3(:,158), t3x96(:,:,70), nhel, den(99))
    call cont_QA(nsync, wf12(:,8), wf8(:,32), A(:,71), n3(:,159), t3x96(:,:,71), nhel, den(100))
    call cont_QA(nsync, wf12(:,8), wf8(:,30), A(:,72), n3(:,160), t3x96(:,:,72), nhel, den(99))
    call cont_VV(nsync, wf8(:,33), wf12(:,9), A(:,73), n3(:,161), t3x96(:,:,73), nhel, den(103))
    call cont_VV(nsync, wf12(:,10), wf8(:,35), A(:,74), n3(:,162), t3x96(:,:,74), nhel, den(106))
    call cont_VV(nsync, wf8(:,33), wf12(:,9), A(:,75), n3(:,163), t3x96(:,:,75), nhel, den(103))
    call cont_VV(nsync, wf12(:,11), wf8(:,36), A(:,76), n3(:,164), t3x96(:,:,76), nhel, den(109))
    call cont_VV(nsync, wf8(:,37), wf12(:,13), A(:,77), n3(:,165), t3x96(:,:,77), nhel, den(112))
    call cont_VV(nsync, wf12(:,11), wf8(:,36), A(:,78), n3(:,166), t3x96(:,:,78), nhel, den(109))
    call cont_VV(nsync, wf8(:,36), wf12(:,14), A(:,79), n3(:,167), t3x96(:,:,79), nhel, den(114))
    call cont_VV(nsync, wf8(:,37), wf12(:,16), A(:,80), n3(:,168), t3x96(:,:,80), nhel, den(116))
    call cont_VV(nsync, wf8(:,36), wf12(:,14), A(:,81), n3(:,169), t3x96(:,:,81), nhel, den(114))
    call cont_VV(nsync, wf8(:,33), wf12(:,17), A(:,82), n3(:,170), t3x96(:,:,82), nhel, den(119))
    call cont_VV(nsync, wf8(:,34), wf12(:,19), A(:,83), n3(:,171), t3x96(:,:,83), nhel, den(122))
    call cont_VV(nsync, wf8(:,33), wf12(:,17), A(:,84), n3(:,172), t3x96(:,:,84), nhel, den(119))
    call cont_VV(nsync, wf12(:,20), wf8(:,38), A(:,85), n3(:,173), t3x96(:,:,85), nhel, den(125))
    call cont_VV(nsync, wf8(:,39), wf12(:,22), A(:,86), n3(:,174), t3x96(:,:,86), nhel, den(128))
    call cont_VV(nsync, wf12(:,20), wf8(:,38), A(:,87), n3(:,175), t3x96(:,:,87), nhel, den(125))
    call cont_VV(nsync, wf8(:,40), wf12(:,23), A(:,88), n3(:,176), t3x96(:,:,88), nhel, den(131))
    call cont_VV(nsync, wf12(:,24), wf8(:,42), A(:,89), n3(:,177), t3x96(:,:,89), nhel, den(134))
    call cont_VV(nsync, wf8(:,40), wf12(:,23), A(:,90), n3(:,178), t3x96(:,:,90), nhel, den(131))
    call cont_VV(nsync, wf8(:,38), wf12(:,25), A(:,91), n3(:,179), t3x96(:,:,91), nhel, den(136))
    call cont_VV(nsync, wf8(:,39), wf12(:,27), A(:,92), n3(:,180), t3x96(:,:,92), nhel, den(138))
    call cont_VV(nsync, wf8(:,38), wf12(:,25), A(:,93), n3(:,181), t3x96(:,:,93), nhel, den(136))
    call cont_VV(nsync, wf8(:,40), wf12(:,28), A(:,94), n3(:,182), t3x96(:,:,94), nhel, den(141))
    call cont_VV(nsync, wf8(:,41), wf12(:,30), A(:,95), n3(:,183), t3x96(:,:,95), nhel, den(144))
    call cont_VV(nsync, wf8(:,40), wf12(:,28), A(:,96), n3(:,184), t3x96(:,:,96), nhel, den(141))
    call cont_VV(nsync, wf12(:,23), wf8(:,43), A(:,97), n3(:,185), t3x96(:,:,97), nhel, den(146))
    call cont_VV(nsync, wf12(:,24), wf8(:,45), A(:,98), n3(:,186), t3x96(:,:,98), nhel, den(148))
    call cont_VV(nsync, wf12(:,23), wf8(:,43), A(:,99), n3(:,187), t3x96(:,:,99), nhel, den(146))
    call cont_VV(nsync, wf12(:,9), wf8(:,46), A(:,100), n3(:,188), t3x96(:,:,100), nhel, den(150))
    call cont_VV(nsync, wf12(:,10), wf8(:,48), A(:,101), n3(:,189), t3x96(:,:,101), nhel, den(152))
    call cont_VV(nsync, wf12(:,9), wf8(:,46), A(:,102), n3(:,190), t3x96(:,:,102), nhel, den(150))
    call cont_VV(nsync, wf12(:,17), wf8(:,46), A(:,103), n3(:,191), t3x96(:,:,103), nhel, den(153))
    call cont_VV(nsync, wf12(:,18), wf8(:,48), A(:,104), n3(:,192), t3x96(:,:,104), nhel, den(154))
    call cont_VV(nsync, wf12(:,17), wf8(:,46), A(:,105), n3(:,193), t3x96(:,:,105), nhel, den(153))
    call cont_VV(nsync, wf12(:,28), wf8(:,43), A(:,106), n3(:,194), t3x96(:,:,106), nhel, den(155))
    call cont_VV(nsync, wf12(:,30), wf8(:,44), A(:,107), n3(:,195), t3x96(:,:,107), nhel, den(156))
    call cont_VV(nsync, wf12(:,28), wf8(:,43), A(:,108), n3(:,196), t3x96(:,:,108), nhel, den(155))
    call cont_VV(nsync, wf12(:,20), wf8(:,49), A(:,109), n3(:,197), t3x96(:,:,109), nhel, den(159))
    call cont_VV(nsync, wf12(:,21), wf8(:,51), A(:,110), n3(:,198), t3x96(:,:,110), nhel, den(162))
    call cont_VV(nsync, wf12(:,20), wf8(:,49), A(:,111), n3(:,199), t3x96(:,:,111), nhel, den(159))
    call cont_VV(nsync, wf12(:,11), wf8(:,52), A(:,112), n3(:,200), t3x96(:,:,112), nhel, den(165))
    call cont_VV(nsync, wf12(:,12), wf8(:,54), A(:,113), n3(:,201), t3x96(:,:,113), nhel, den(168))
    call cont_VV(nsync, wf12(:,11), wf8(:,52), A(:,114), n3(:,202), t3x96(:,:,114), nhel, den(165))
    call cont_VV(nsync, wf12(:,25), wf8(:,49), A(:,115), n3(:,203), t3x96(:,:,115), nhel, den(169))
    call cont_VV(nsync, wf12(:,27), wf8(:,50), A(:,116), n3(:,204), t3x96(:,:,116), nhel, den(170))
    call cont_VV(nsync, wf12(:,25), wf8(:,49), A(:,117), n3(:,205), t3x96(:,:,117), nhel, den(169))
    call cont_VV(nsync, wf12(:,14), wf8(:,52), A(:,118), n3(:,206), t3x96(:,:,118), nhel, den(171))
    call cont_VV(nsync, wf12(:,15), wf8(:,54), A(:,119), n3(:,207), t3x96(:,:,119), nhel, den(172))
    call cont_VV(nsync, wf12(:,14), wf8(:,52), A(:,120), n3(:,208), t3x96(:,:,120), nhel, den(171))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont) :: A(:,:)
  integer, intent(in) :: j
  complex(REALKIND), intent(out) :: M1(4) ! M1helarray(4,96)
  integer :: empty(0)

  M1(1) = (-A(j,19)%j-A(j,22)%j-A(j,25)%j-A(j,28)%j-A(j,31)%j-A(j,34)%j-A(j,37)%j-A(j,40)%j-A(j,43)%j-A(j,46)%j-A(j,49)%j &
       -A(j,52)%j-A(j,76)%j-A(j,79)%j-A(j,88)%j-A(j,94)%j-A(j,97)%j-A(j,106)%j-A(j,112)%j-A(j,118)%j)*f(1)+(-A(j,20)%j-A(j,23)%j &
       -A(j,26)%j-A(j,29)%j-A(j,32)%j-A(j,35)%j-A(j,38)%j-A(j,41)%j-A(j,44)%j-A(j,47)%j-A(j,50)%j-A(j,53)%j-A(j,77)%j-A(j,80)%j &
       -A(j,89)%j-A(j,95)%j-A(j,98)%j-A(j,107)%j-A(j,113)%j-A(j,119)%j)*f(2)
  M1(2) = ((A(j,3)%j+A(j,6)%j+A(j,9)%j+A(j,12)%j+A(j,15)%j+A(j,18)%j+A(j,57)%j+A(j,60)%j+A(j,63)%j+A(j,66)%j+A(j,69)%j+A(j,72)%j &
       +A(j,75)%j+A(j,84)%j+A(j,87)%j+A(j,93)%j+A(j,102)%j+A(j,105)%j+A(j,111)%j+A(j,117)%j)*f(3))/2._/**/REALKIND+((A(j,21)%j &
       +A(j,24)%j+A(j,27)%j+A(j,30)%j+A(j,33)%j+A(j,36)%j+A(j,39)%j+A(j,42)%j+A(j,45)%j+A(j,48)%j+A(j,51)%j+A(j,54)%j+A(j,78)%j &
       +A(j,81)%j+A(j,90)%j+A(j,96)%j+A(j,99)%j+A(j,108)%j+A(j,114)%j+A(j,120)%j)*f(3))/6._/**/REALKIND
  M1(3) = (A(j,1)%j+A(j,4)%j+A(j,7)%j+A(j,10)%j+A(j,13)%j+A(j,16)%j+A(j,55)%j+A(j,58)%j+A(j,61)%j+A(j,64)%j+A(j,67)%j+A(j,70)%j &
       +A(j,73)%j+A(j,82)%j+A(j,85)%j+A(j,91)%j+A(j,100)%j+A(j,103)%j+A(j,109)%j+A(j,115)%j)*f(1)+(A(j,2)%j+A(j,5)%j+A(j,8)%j &
       +A(j,11)%j+A(j,14)%j+A(j,17)%j+A(j,56)%j+A(j,59)%j+A(j,62)%j+A(j,65)%j+A(j,68)%j+A(j,71)%j+A(j,74)%j+A(j,83)%j+A(j,86)%j &
       +A(j,92)%j+A(j,101)%j+A(j,104)%j+A(j,110)%j+A(j,116)%j)*f(2)
  M1(4) = ((-A(j,3)%j-A(j,6)%j-A(j,9)%j-A(j,12)%j-A(j,15)%j-A(j,18)%j-A(j,57)%j-A(j,60)%j-A(j,63)%j-A(j,66)%j-A(j,69)%j-A(j,72)%j &
       -A(j,75)%j-A(j,84)%j-A(j,87)%j-A(j,93)%j-A(j,102)%j-A(j,105)%j-A(j,111)%j-A(j,117)%j)*f(3))/6._/**/REALKIND+((-A(j,21)%j &
       -A(j,24)%j-A(j,27)%j-A(j,30)%j-A(j,33)%j-A(j,36)%j-A(j,39)%j-A(j,42)%j-A(j,45)%j-A(j,48)%j-A(j,51)%j-A(j,54)%j-A(j,78)%j &
       -A(j,81)%j-A(j,90)%j-A(j,96)%j-A(j,99)%j-A(j,108)%j-A(j,114)%j-A(j,120)%j)*f(3))/2._/**/REALKIND

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppvvj_ew_uuuxuxaz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint(0:23-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 4*extcomb
    do i = 1, 4
      do j = 1, 4
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint


! **********************************************************************
subroutine colint2(M1, M2, M2colint, extcombs)
! M1(i)   = <M1|Ci> colour component of matrix element
! M2(i)   = <M2|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppvvj_ew_uuuxuxaz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(4), M2(4)
  real(REALKIND),    intent(out) :: M2colint(0:23-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 4*extcomb
    do i = 1, 4
      do j = 1, 4
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M1(i))*K1(i+colmatpos,j)*M2(j))
      end do
    end do
  end do

end subroutine colint2


! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvj_ew_uuuxuxaz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K1(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

end subroutine amp2


#ifdef PRECISION_dp
subroutine colourvector(M1out, nhelout) &
  & bind(c,name="ol_tree_colvect_ppvvj_ew_uuuxuxaz_1")
  ! Retrieve M1helarr from cache. Cache must have been filled before by calling amp2().
  ! [out] M1out(:,h): colour vector for each helicity configuration h
  ! [out] nhelout: number of non-vanishing helicity configurations
  implicit none
  complex(DREALKIND) :: M1out(4,96)
  integer, intent(out) :: nhelout
  M1out = M1helarr
  nhelout = nhel
end subroutine colourvector
#endif


! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_ppvvj_ew_uuuxuxaz_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ], M2munu)
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_ppvvj_ew_uuuxuxaz_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_ppvvj_ew_uuuxuxaz_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    23, [ (k, k = 0, 23-1) ], M2munu)
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_ppvvj_ew_uuuxuxaz_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_ppvvj_ew_uuuxuxaz_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2(6)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  integer        :: J, extcombs(6)
  do J = 1, 6
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 6,extcombs, M2munu)
  do J = 1, 6
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_ppvvj_ew_uuuxuxaz_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_ppvvj_ew_uuuxuxaz_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_ppvvj_ew_uuuxuxaz_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(0:23-1)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(0:23-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_ppvvj_ew_uuuxuxaz_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_ppvvj_ew_uuuxuxaz_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(6)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(6)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c

#endif

end module ol_tree_ppvvj_ew_uuuxuxaz_1_/**/REALKIND
