
module ol_vamp_3_ppvvj_ew_uxdzwxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj_ew_uxdzwxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj_ew_uxdzwxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvj_ew_uxdzwxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvj_ew_uxdzwxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvj_ew_uxdzwxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvj_ew_uxdzwxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,2),G0H9(10),m3h8x9(:,55),heltab2x72(:,:,340))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(341),h0tab(:,341),[19,4,8],[nMZ,nMH,nMW],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(11),m3h8x9(:,56),heltab2x72(:,:,341))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(342),h0tab(:,342),[19,4,8],[nMW,nMW,nMH],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(12),m3h8x9(:,57),heltab2x72(:,:,342))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(343),h0tab(:,343),[19,4,8],[nMH,nMZ,nMW],3,1,wf8(:,2))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(55),m3h8x9(:,58),heltab2x72(:,:,343))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(344),h0tab(:,344),[19,4,8],[nMW,nMW,nMH],3,1,wf8(:,2))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(56),m3h8x9(:,59),heltab2x72(:,:,344))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(345),h0tab(:,345),[19,4,8],[nMW,nMW,0],3,1,wf8(:,2))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(57),m3h8x9(:,60),heltab2x72(:,:,345))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(346),h0tab(:,346),[19,4,8],[nMZ,nMH,nMW],3,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(58),m3h8x9(:,61),heltab2x72(:,:,346))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(347),h0tab(:,347),[19,4,8],[nMW,nMW,nMZ],3,1,wf8(:,2))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(59),m3h8x9(:,62),heltab2x72(:,:,347))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(348),h0tab(:,348),[19,4,8],[nMW,nMW,0],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,2),G0H9(13),m3h8x9(:,63),heltab2x72(:,:,348))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(349),h0tab(:,349),[19,4,8],[nMH,nMZ,nMW],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,2),G0H9(14),m3h8x9(:,64),heltab2x72(:,:,349))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(350),h0tab(:,350),[19,4,8],[nMW,nMW,nMZ],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,2),G0H9(15),m3h8x9(:,65),heltab2x72(:,:,350))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(351),h0tab(:,351),[19,4,8],[nMW,nMW,nMH],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(16),m3h8x9(:,66),heltab2x72(:,:,351))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(352),h0tab(:,352),[22,1,8],[0,0,0],3,1,wf12(:,31))
  call Hloop_AQ_V(ntryL,G0H72(1),wf12(:,31),G0H6(22),m3h12x6(:,37),heltab2x72(:,:,352))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(353),h0tab(:,353),[22,1,8],[nMZ,0,0],3,1,wf12(:,31))
  call Hloop_AQ_Z(ntryL,G0H72(1),wf12(:,31),G0H6(23),ngZd,m3h12x6(:,38),heltab2x72(:,:,353))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(354),h0tab(:,354),[22,1,8],[0,0,0],3,1,wf12(:,31))
  call Hloop_AQ_V(ntryL,G0H72(1),wf12(:,31),G0H6(24),m3h12x6(:,39),heltab2x72(:,:,354))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(355),h0tab(:,355),[22,1,8],[0,0,nMW],3,1,wf12(:,31))
  call Hloop_WQ_A(ntryL,G0H72(1),wf12(:,31),G0H6(25),m3h12x6(:,40),heltab2x72(:,:,355))
  call Hloop_Q_A(ntryL,G0H6(25),22,0,G1H6(127),n2h6(72))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(356),h0tab(:,356),[22,1,8],[0,nMW,0],3,1,wf12(:,31))
  call Hloop_VQ_A(ntryL,G0H72(1),wf12(:,31),G0H6(25),m3h12x6(:,41),heltab2x72(:,:,356))
  call Hloop_Q_A(ntryL,G0H6(25),22,0,G1H6(23),n2h6(73))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(357),h0tab(:,357),[22,1,8],[0,nMZ,nMW],3,1,wf12(:,31))
  call Hloop_WQ_A(ntryL,G0H72(1),wf12(:,31),G0H6(25),m3h12x6(:,42),heltab2x72(:,:,357))
  call Hloop_Q_A(ntryL,G0H6(25),22,0,G1H6(24),n2h6(74))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(358),h0tab(:,358),[22,1,8],[0,nMW,nMZ],3,1,wf12(:,31))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf12(:,31),G0H6(25),ngZd,m3h12x6(:,43),heltab2x72(:,:,358))
  call Hloop_Q_A(ntryL,G0H6(25),22,0,G1H6(26),n2h6(75))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(359),h0tab(:,359),[26,1,4],[0,0,0],3,1,wf12(:,25))
  call Hloop_AQ_V(ntryL,G0H72(1),wf12(:,25),G0H6(25),m3h12x6(:,44),heltab2x72(:,:,359))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(360),h0tab(:,360),[26,1,4],[nMZ,0,0],3,1,wf12(:,25))
  call Hloop_AQ_Z(ntryL,G0H72(1),wf12(:,25),G0H6(26),ngZu,m3h12x6(:,45),heltab2x72(:,:,360))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(361),h0tab(:,361),[26,1,4],[nMW,0,0],3,1,wf12(:,25))
  call Hloop_AQ_W(ntryL,G0H72(1),wf12(:,25),G0H6(27),m3h12x6(:,46),heltab2x72(:,:,361))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(362),h0tab(:,362),[26,1,4],[0,0,0],3,1,wf12(:,25))
  call Hloop_AQ_V(ntryL,G0H72(1),wf12(:,25),G0H6(28),m3h12x6(:,47),heltab2x72(:,:,362))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(363),h0tab(:,363),[26,1,4],[0,nMW,nMW],3,1,wf12(:,25))
  call Hloop_WQ_A(ntryL,G0H72(1),wf12(:,25),G0H6(29),m3h12x6(:,48),heltab2x72(:,:,363))
  call Hloop_Q_A(ntryL,G0H6(29),26,0,G1H6(29),n2h6(76))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(41),[G1H6(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(48),[G1H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(44),[G1H18(41),G1H18(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(48),[G1H18(45),G1H18(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(24),[G1H36(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(8),[G0H18(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(47),[G1H36(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(17),[G0H6(15),G0H6(3),G0H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(16),[G0H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(110),[G1H6(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(111),[G1H6(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(121),[G1H6(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(122),[G1H6(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(10),[G1H36(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(10),[G0H18(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(6),[G1H36(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(24),[G0H6(22),G0H6(6),G0H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(23),[G0H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(127),[G1H6(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(23),[G1H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(24),[G1H6(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(26),[G1H6(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(25),[G1H36(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(21),[G0H6(18),G0H6(10),G0H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(19),[G0H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(20),[G0H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(126),[G1H6(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(41),[G1H36(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(28),[G0H6(25),G0H6(14),G0H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(26),[G0H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(27),[G0H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(29),[G1H6(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(6),[G0H18(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(14),[G0H18(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(48),[G1H36(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(55),[G1H36(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(39),[G1H9(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(40),[G1H9(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(43),[G1H9(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(44),[G1H9(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(25),[G1H9(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(17),[G1H9(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(11),[G1H9(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(18),[G1H9(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(23),[G1H9(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(35),[G1H9(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(41),[G1H9(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(42),[G1H9(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(2),[G1H9(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(12),[G1H9(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(26),[G1H9(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(3),[G1H9(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(51),[G1H9(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(52),[G1H9(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(53),[G1H9(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(54),[G1H9(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(9),[G0H9(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(10),[G0H9(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(11),[G0H9(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(12),[G0H9(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(55),[G1H9(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(56),[G1H9(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(57),[G1H9(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(58),[G1H9(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(59),[G1H9(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(13),[G0H9(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(14),[G0H9(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(15),[G0H9(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(16),[G0H9(8)])
  call Hloop_AW_Q(ntryL,G1H6(41),ex4(:),G1H2(27),m3h3x2(:,68),heltab2x6(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(27),29,0,G2H2(10),n2h2(34))
  call Hloop_AZ_Q(ntryL,G1H6(48),ex3(:),G1H2(28),ngZd,m3h3x2(:,69),heltab2x6(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(28),29,0,G2H2(13),n2h2(35))
  call Hloop_QW_A(ntryL,G1H18(14),ex4(:),G1H6(30),m3h3x6(:,59),heltab2x18(:,:,127))
  call Hloop_Q_A(ntryL,G1H6(30),26,0,G2H6(5),n2h6(77))
  call Hloop_AW_Q(ntryL,G1H18(19),ex4(:),G1H6(31),m3h3x6(:,60),heltab2x18(:,:,128))
  call Hloop_A_Q(ntryL,G1H6(31),25,0,G2H6(6),n2h6(78))
  call Hloop_QZ_A(ntryL,G1H18(44),ex3(:),G1H6(35),ngZd,m3h3x6(:,61),heltab2x18(:,:,129))
  call Hloop_Q_A(ntryL,G1H6(35),22,0,G2H6(7),n2h6(79))
  call Hloop_AZ_Q(ntryL,G1H18(48),ex3(:),G1H6(36),ngZu,m3h3x6(:,62),heltab2x18(:,:,130))
  call Hloop_A_Q(ntryL,G1H6(36),21,0,G2H6(8),n2h6(80))
  call Hloop_AW_Q(ntryL,G1H18(10),wf9(:,1),G1H2(29),m3h9x2(:,12),heltab2x18(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(29),29,0,G2H2(20),n2h2(36))
  call Hloop_AQ_W(ntryL,G1H18(27),ex2(:),G1H9(36),m3h2x9(:,44),heltab2x18(:,:,132))
  call Hloop_AQ_V(ntryL,G1H18(28),ex2(:),G1H9(4),m3h2x9(:,45),heltab2x18(:,:,133))
  call Hloop_AQ_W(ntryL,G1H18(29),ex2(:),G1H9(14),m3h2x9(:,46),heltab2x18(:,:,134))
  call Hloop_AQ_Z(ntryL,G1H18(30),ex2(:),G1H9(48),ngZd,m3h2x9(:,47),heltab2x18(:,:,135))
  call Hloop_QA_V(ntryL,G1H18(3),ex1(:),G1H9(15),m3h2x9(:,48),heltab2x18(:,:,136))
  call Hloop_QA_W(ntryL,G1H18(9),ex1(:),G1H9(45),m3h2x9(:,49),heltab2x18(:,:,137))
  call Hloop_QA_Z(ntryL,G1H18(31),ex1(:),G1H9(46),ngZu,m3h2x9(:,50),heltab2x18(:,:,138))
  call Hloop_QA_W(ntryL,G1H18(32),ex1(:),G1H9(49),m3h2x9(:,51),heltab2x18(:,:,139))
  call Hloop_QA_V(ntryL,G1H36(24),wf6(:,3),G1H6(37),m3h6x6(:,5),heltab2x36(:,:,84))
  call Hloop_QA_Z(ntryL,G1H36(12),wf6(:,3),G1H6(38),ngZu,m3h6x6(:,6),heltab2x36(:,:,85))
  call Hloop_QA_W(ntryL,G1H36(21),wf6(:,3),G1H6(42),m3h6x6(:,7),heltab2x36(:,:,86))
  call Hloop_VA_Q(ntryL,G1H36(29),wf6(:,3),G1H6(43),m3h6x6(:,8),heltab2x36(:,:,87))
  call Hloop_A_Q(ntryL,G1H6(43),21,0,G2H6(9),n2h6(81))
  call Hloop_VA_Q(ntryL,G0H18(8),wf6(:,3),G0H3(1),m3h6x3(:,15),heltab2x18(:,:,140))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(90),n2h3(105))
  call Hloop_ZA_Q(ntryL,G0H18(9),wf6(:,3),G0H3(1),ngZu,m3h6x3(:,16),heltab2x18(:,:,141))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(91),n2h3(106))
  call Hloop_QA_V(ntryL,G1H18(33),wf6(:,3),G1H3(95),m3h6x3(:,17),heltab2x18(:,:,142))
  call Hloop_QA_W(ntryL,G1H18(34),wf6(:,3),G1H3(96),m3h6x3(:,18),heltab2x18(:,:,143))
  call Hloop_QA_Z(ntryL,G1H18(35),wf6(:,3),G1H3(101),ngZu,m3h6x3(:,19),heltab2x18(:,:,144))
  call Hloop_QA_W(ntryL,G1H18(36),wf6(:,3),G1H3(102),m3h6x3(:,20),heltab2x18(:,:,145))
  call Hloop_AQ_V(ntryL,G1H36(47),ex2(:),G1H18(65),m3h2x18(:,70),heltab2x36(:,:,88))
  call Hloop_AQ_Z(ntryL,G1H36(39),ex2(:),G1H18(13),ngZd,m3h2x18(:,71),heltab2x36(:,:,89))
  call Hloop_AQ_W(ntryL,G1H36(43),ex2(:),G1H18(15),m3h2x18(:,72),heltab2x36(:,:,90))
  call Hloop_VQ_A(ntryL,G1H36(50),ex2(:),G1H18(16),m3h2x18(:,73),heltab2x36(:,:,91))
  call Hloop_Q_A(ntryL,G1H18(16),18,0,G2H18(1),n2h18(83))
  call Hloop_VQ_A(ntryL,G0H6(17),ex2(:),G0H3(1),m3h2x3(:,81),heltab2x6(:,:,206))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(128),n2h3(107))
  call Hloop_ZQ_A(ntryL,G0H6(16),ex2(:),G0H3(1),ngZd,m3h2x3(:,82),heltab2x6(:,:,207))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(129),n2h3(108))
  call Hloop_AQ_W(ntryL,G1H6(110),ex2(:),G1H3(139),m3h2x3(:,83),heltab2x6(:,:,208))
  call Hloop_AQ_V(ntryL,G1H6(111),ex2(:),G1H3(140),m3h2x3(:,84),heltab2x6(:,:,209))
  call Hloop_AQ_W(ntryL,G1H6(121),ex2(:),G1H3(145),m3h2x3(:,85),heltab2x6(:,:,210))
  call Hloop_AQ_Z(ntryL,G1H6(122),ex2(:),G1H3(151),ngZd,m3h2x3(:,86),heltab2x6(:,:,211))
  call Hloop_AQ_V(ntryL,G1H36(10),wf6(:,8),G1H6(44),m3h6x6(:,9),heltab2x36(:,:,92))
  call Hloop_AQ_Z(ntryL,G1H36(4),wf6(:,8),G1H6(47),ngZd,m3h6x6(:,10),heltab2x36(:,:,93))
  call Hloop_AQ_W(ntryL,G1H36(7),wf6(:,8),G1H6(49),m3h6x6(:,11),heltab2x36(:,:,94))
  call Hloop_VQ_A(ntryL,G1H36(13),wf6(:,8),G1H6(50),m3h6x6(:,12),heltab2x36(:,:,95))
  call Hloop_Q_A(ntryL,G1H6(50),22,0,G2H6(10),n2h6(82))
  call Hloop_VQ_A(ntryL,G0H18(10),wf6(:,8),G0H3(1),m3h6x3(:,21),heltab2x18(:,:,146))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(156),n2h3(109))
  call Hloop_ZQ_A(ntryL,G0H18(7),wf6(:,8),G0H3(1),ngZd,m3h6x3(:,22),heltab2x18(:,:,147))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(157),n2h3(110))
  call Hloop_AQ_W(ntryL,G1H18(37),wf6(:,8),G1H3(167),m3h6x3(:,23),heltab2x18(:,:,148))
  call Hloop_AQ_V(ntryL,G1H18(38),wf6(:,8),G1H3(168),m3h6x3(:,24),heltab2x18(:,:,149))
  call Hloop_AQ_W(ntryL,G1H18(39),wf6(:,8),G1H3(172),m3h6x3(:,25),heltab2x18(:,:,150))
  call Hloop_AQ_Z(ntryL,G1H18(40),wf6(:,8),G1H3(179),ngZd,m3h6x3(:,26),heltab2x18(:,:,151))
  call Hloop_QA_V(ntryL,G1H36(6),ex1(:),G1H18(17),m3h2x18(:,74),heltab2x36(:,:,96))
  call Hloop_QA_Z(ntryL,G1H36(3),ex1(:),G1H18(18),ngZu,m3h2x18(:,75),heltab2x36(:,:,97))
  call Hloop_QA_W(ntryL,G1H36(2),ex1(:),G1H18(20),m3h2x18(:,76),heltab2x36(:,:,98))
  call Hloop_VA_Q(ntryL,G1H36(8),ex1(:),G1H18(21),m3h2x18(:,77),heltab2x36(:,:,99))
  call Hloop_A_Q(ntryL,G1H18(21),17,0,G2H18(2),n2h18(84))
  call Hloop_VA_Q(ntryL,G0H6(24),ex1(:),G0H3(1),m3h2x3(:,87),heltab2x6(:,:,212))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(183),n2h3(111))
  call Hloop_ZA_Q(ntryL,G0H6(23),ex1(:),G0H3(1),ngZu,m3h2x3(:,88),heltab2x6(:,:,213))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(184),n2h3(112))
  call Hloop_QA_V(ntryL,G1H6(127),ex1(:),G1H3(194),m3h2x3(:,89),heltab2x6(:,:,214))
  call Hloop_QA_W(ntryL,G1H6(23),ex1(:),G1H3(195),m3h2x3(:,90),heltab2x6(:,:,215))
  call Hloop_QA_Z(ntryL,G1H6(24),ex1(:),G1H3(200),ngZu,m3h2x3(:,91),heltab2x6(:,:,216))
  call Hloop_QA_W(ntryL,G1H6(26),ex1(:),G1H3(206),m3h2x3(:,92),heltab2x6(:,:,217))
  call Hloop_QZ_A(ntryL,G1H18(42),ex3(:),G1H6(53),ngZd,m3h3x6(:,63),heltab2x18(:,:,152))
  call Hloop_Q_A(ntryL,G1H6(53),22,0,G2H6(11),n2h6(83))
  call Hloop_QZ_A(ntryL,G1H18(43),ex3(:),G1H6(54),ngZu,m3h3x6(:,64),heltab2x18(:,:,153))
  call Hloop_Q_A(ntryL,G1H6(54),22,0,G2H6(12),n2h6(84))
  call Hloop_UV_W(ntryL,G0H18(2),18,ex3(:),4,G1H6(1),m3h3x6(:,65),heltab2x18(:,:,154))
  call Hloop_QZ_A(ntryL,G1H36(9),ex3(:),G1H12(1),ngZu,m3h3x12(:,11),heltab2x36(:,:,100))
  call Hloop_Q_A(ntryL,G1H12(1),20,0,G2H12(1),n2h12(11))
  call Hloop_QZ_A(ntryL,G1H36(15),ex3(:),G1H12(1),ngZu,m3h3x12(:,12),heltab2x36(:,:,101))
  call Hloop_Q_A(ntryL,G1H12(1),20,nMT,G2H12(2),n2h12(12))
  call Hloop_AZ_Q(ntryL,G1H36(11),ex3(:),G1H12(1),ngZu,m3h3x12(:,13),heltab2x36(:,:,102))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(3),n2h12(13))
  call Hloop_AZ_Q(ntryL,G1H36(14),ex3(:),G1H12(1),ngZu,m3h3x12(:,14),heltab2x36(:,:,103))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(4),n2h12(14))
  call Hloop_QZ_A(ntryL,G1H36(18),ex3(:),G1H12(1),ngZd,m3h3x12(:,15),heltab2x36(:,:,104))
  call Hloop_Q_A(ntryL,G1H12(1),20,0,G2H12(5),n2h12(15))
  call Hloop_QZ_A(ntryL,G1H36(17),ex3(:),G1H12(1),ngZd,m3h3x12(:,16),heltab2x36(:,:,105))
  call Hloop_Q_A(ntryL,G1H12(1),20,nMB,G2H12(6),n2h12(16))
  call Hloop_AZ_Q(ntryL,G1H36(19),ex3(:),G1H12(1),ngZd,m3h3x12(:,17),heltab2x36(:,:,106))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(7),n2h12(17))
  call Hloop_AZ_Q(ntryL,G1H36(20),ex3(:),G1H12(1),ngZd,m3h3x12(:,18),heltab2x36(:,:,107))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(8),n2h12(18))
  call Hloop_AQ_V(ntryL,G1H36(25),ex2(:),G1H18(22),m3h2x18(:,78),heltab2x36(:,:,108))
  call Hloop_AQ_Z(ntryL,G1H36(22),ex2(:),G1H18(23),ngZd,m3h2x18(:,79),heltab2x36(:,:,109))
  call Hloop_AQ_W(ntryL,G1H36(26),ex2(:),G1H18(25),m3h2x18(:,80),heltab2x36(:,:,110))
  call Hloop_VQ_A(ntryL,G1H36(27),ex2(:),G1H18(26),m3h2x18(:,81),heltab2x36(:,:,111))
  call Hloop_Q_A(ntryL,G1H18(26),18,0,G2H18(3),n2h18(85))
  call Hloop_VQ_A(ntryL,G0H6(21),ex2(:),G0H3(1),m3h2x3(:,93),heltab2x6(:,:,218))
  call Hloop_Q_A(ntryL,G0H3(1),27,0,G1H3(211),n2h3(113))
  call Hloop_ZQ_A(ntryL,G0H6(19),ex2(:),G0H3(1),ngZd,m3h2x3(:,94),heltab2x6(:,:,219))
  call Hloop_Q_A(ntryL,G0H3(1),27,0,G1H3(212),n2h3(114))
  call Hloop_WQ_A(ntryL,G0H6(20),ex2(:),G0H3(1),m3h2x3(:,95),heltab2x6(:,:,220))
  call Hloop_Q_A(ntryL,G0H3(1),27,0,G1H3(222),n2h3(115))
  call Hloop_AQ_W(ntryL,G1H6(126),ex2(:),G1H3(223),m3h2x3(:,96),heltab2x6(:,:,221))
  call Hloop_AZ_Q(ntryL,G1H18(46),ex3(:),G1H6(2),ngZu,m3h3x6(:,66),heltab2x18(:,:,155))
  call Hloop_A_Q(ntryL,G1H6(2),21,0,G2H6(13),n2h6(85))
  call Hloop_AZ_Q(ntryL,G1H18(47),ex3(:),G1H6(56),ngZd,m3h3x6(:,67),heltab2x18(:,:,156))
  call Hloop_A_Q(ntryL,G1H6(56),21,0,G2H6(14),n2h6(86))
  call Hloop_UV_W(ntryL,G0H18(1),17,ex3(:),4,G1H6(57),m3h3x6(:,68),heltab2x18(:,:,157))
  call Hloop_QZ_A(ntryL,G1H36(28),ex3(:),G1H12(1),ngZu,m3h3x12(:,19),heltab2x36(:,:,112))
  call Hloop_Q_A(ntryL,G1H12(1),20,0,G2H12(9),n2h12(19))
  call Hloop_QZ_A(ntryL,G1H36(32),ex3(:),G1H12(1),ngZu,m3h3x12(:,20),heltab2x36(:,:,113))
  call Hloop_Q_A(ntryL,G1H12(1),20,nMT,G2H12(10),n2h12(20))
  call Hloop_AZ_Q(ntryL,G1H36(30),ex3(:),G1H12(1),ngZu,m3h3x12(:,21),heltab2x36(:,:,114))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(11),n2h12(21))
  call Hloop_AZ_Q(ntryL,G1H36(31),ex3(:),G1H12(1),ngZu,m3h3x12(:,22),heltab2x36(:,:,115))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(12),n2h12(22))
  call Hloop_QZ_A(ntryL,G1H36(36),ex3(:),G1H12(1),ngZd,m3h3x12(:,23),heltab2x36(:,:,116))
  call Hloop_Q_A(ntryL,G1H12(1),20,0,G2H12(13),n2h12(23))
  call Hloop_QZ_A(ntryL,G1H36(34),ex3(:),G1H12(1),ngZd,m3h3x12(:,24),heltab2x36(:,:,117))
  call Hloop_Q_A(ntryL,G1H12(1),20,nMB,G2H12(14),n2h12(24))
  call Hloop_AZ_Q(ntryL,G1H36(35),ex3(:),G1H12(1),ngZd,m3h3x12(:,25),heltab2x36(:,:,118))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(15),n2h12(25))
  call Hloop_AZ_Q(ntryL,G1H36(37),ex3(:),G1H12(1),ngZd,m3h3x12(:,26),heltab2x36(:,:,119))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(16),n2h12(26))
  call Hloop_QA_V(ntryL,G1H36(41),ex1(:),G1H18(1),m3h2x18(:,82),heltab2x36(:,:,120))
  call Hloop_QA_Z(ntryL,G1H36(42),ex1(:),G1H18(2),ngZu,m3h2x18(:,83),heltab2x36(:,:,121))
  call Hloop_QA_W(ntryL,G1H36(40),ex1(:),G1H18(5),m3h2x18(:,84),heltab2x36(:,:,122))
  call Hloop_VA_Q(ntryL,G1H36(46),ex1(:),G1H18(6),m3h2x18(:,85),heltab2x36(:,:,123))
  call Hloop_A_Q(ntryL,G1H18(6),17,0,G2H18(4),n2h18(86))
  call Hloop_VA_Q(ntryL,G0H6(28),ex1(:),G0H3(1),m3h2x3(:,97),heltab2x6(:,:,222))
  call Hloop_A_Q(ntryL,G0H3(1),27,0,G1H3(12),n2h3(116))
  call Hloop_ZA_Q(ntryL,G0H6(26),ex1(:),G0H3(1),ngZu,m3h2x3(:,98),heltab2x6(:,:,223))
  call Hloop_A_Q(ntryL,G0H3(1),27,0,G1H3(45),n2h3(117))
  call Hloop_WA_Q(ntryL,G0H6(27),ex1(:),G0H3(1),m3h2x3(:,99),heltab2x6(:,:,224))
  call Hloop_A_Q(ntryL,G0H3(1),27,0,G1H3(56),n2h3(118))
  call Hloop_QA_W(ntryL,G1H6(29),ex1(:),G1H3(67),m3h2x3(:,100),heltab2x6(:,:,225))
  call Hloop_AQ_W(ntryL,G1H18(49),ex2(:),G1H9(50),m3h2x9(:,52),heltab2x18(:,:,158))
  call Hloop_AQ_V(ntryL,G1H18(50),ex2(:),G1H9(7),m3h2x9(:,53),heltab2x18(:,:,159))
  call Hloop_AQ_W(ntryL,G1H18(51),ex2(:),G1H9(8),m3h2x9(:,54),heltab2x18(:,:,160))
  call Hloop_AQ_Z(ntryL,G1H18(52),ex2(:),G1H9(9),ngZd,m3h2x9(:,55),heltab2x18(:,:,161))
  call Hloop_VQ_A(ntryL,G0H18(6),ex2(:),G0H9(1),m3h2x9(:,56),heltab2x18(:,:,162))
  call Hloop_Q_A(ntryL,G0H9(1),19,0,G1H9(10),n2h9(49))
  call Hloop_ZQ_A(ntryL,G0H18(3),ex2(:),G0H9(2),ngZd,m3h2x9(:,57),heltab2x18(:,:,163))
  call Hloop_Q_A(ntryL,G0H9(2),19,0,G1H9(13),n2h9(50))
  call Hloop_AQ_W(ntryL,G1H18(53),ex2(:),G1H9(16),m3h2x9(:,58),heltab2x18(:,:,164))
  call Hloop_AQ_V(ntryL,G1H18(54),ex2(:),G1H9(19),m3h2x9(:,59),heltab2x18(:,:,165))
  call Hloop_AQ_W(ntryL,G1H18(55),ex2(:),G1H9(20),m3h2x9(:,60),heltab2x18(:,:,166))
  call Hloop_AQ_Z(ntryL,G1H18(56),ex2(:),G1H9(21),ngZd,m3h2x9(:,61),heltab2x18(:,:,167))
  call Hloop_QA_V(ntryL,G1H18(57),ex1(:),G1H9(22),m3h2x9(:,62),heltab2x18(:,:,168))
  call Hloop_QA_W(ntryL,G1H18(58),ex1(:),G1H9(27),m3h2x9(:,63),heltab2x18(:,:,169))
  call Hloop_QA_Z(ntryL,G1H18(59),ex1(:),G1H9(28),ngZu,m3h2x9(:,64),heltab2x18(:,:,170))
  call Hloop_QA_W(ntryL,G1H18(60),ex1(:),G1H9(31),m3h2x9(:,65),heltab2x18(:,:,171))
  call Hloop_VA_Q(ntryL,G0H18(14),ex1(:),G0H9(3),m3h2x9(:,66),heltab2x18(:,:,172))
  call Hloop_A_Q(ntryL,G0H9(3),19,0,G1H9(32),n2h9(51))
  call Hloop_ZA_Q(ntryL,G0H18(11),ex1(:),G0H9(4),ngZu,m3h2x9(:,67),heltab2x18(:,:,173))
  call Hloop_A_Q(ntryL,G0H9(4),19,0,G1H9(33),n2h9(52))
  call Hloop_QA_V(ntryL,G1H18(61),ex1(:),G1H9(38),m3h2x9(:,68),heltab2x18(:,:,174))
  call Hloop_QA_W(ntryL,G1H18(62),ex1(:),G1H9(60),m3h2x9(:,69),heltab2x18(:,:,175))
  call Hloop_QA_Z(ntryL,G1H18(63),ex1(:),G1H9(61),ngZu,m3h2x9(:,70),heltab2x18(:,:,176))
  call Hloop_QA_W(ntryL,G1H18(64),ex1(:),G1H9(62),m3h2x9(:,71),heltab2x18(:,:,177))
  call Hloop_AQ_V(ntryL,G1H36(48),ex2(:),G1H18(7),m3h2x18(:,86),heltab2x36(:,:,124))
  call Hloop_AQ_Z(ntryL,G1H36(45),ex2(:),G1H18(8),ngZd,m3h2x18(:,87),heltab2x36(:,:,125))
  call Hloop_AQ_W(ntryL,G1H36(49),ex2(:),G1H18(11),m3h2x18(:,88),heltab2x36(:,:,126))
  call Hloop_VQ_A(ntryL,G1H36(52),ex2(:),G1H18(12),m3h2x18(:,89),heltab2x36(:,:,127))
  call Hloop_Q_A(ntryL,G1H18(12),18,0,G2H18(5),n2h18(87))
  call Hloop_QA_V(ntryL,G1H36(55),ex1(:),G1H18(41),m3h2x18(:,90),heltab2x36(:,:,128))
  call Hloop_QA_Z(ntryL,G1H36(53),ex1(:),G1H18(24),ngZu,m3h2x18(:,91),heltab2x36(:,:,129))
  call Hloop_QA_W(ntryL,G1H36(54),ex1(:),G1H18(45),m3h2x18(:,92),heltab2x36(:,:,130))
  call Hloop_VA_Q(ntryL,G1H36(56),ex1(:),G1H18(4),m3h2x18(:,93),heltab2x36(:,:,131))
  call Hloop_A_Q(ntryL,G1H18(4),17,0,G2H18(6),n2h18(88))
  call Hloop_AZ_Q(ntryL,G1H9(39),ex3(:),G1H3(100),ngZn,m3h3x3(:,65),heltab2x9(:,:,77))
  call Hloop_A_Q(ntryL,G1H3(100),23,0,G2H3(2),n2h3(119))
  call Hloop_AZ_Q(ntryL,G1H9(40),ex3(:),G1H3(111),ngZn,m3h3x3(:,66),heltab2x9(:,:,78))
  call Hloop_A_Q(ntryL,G1H3(111),23,0,G2H3(9),n2h3(120))
  call Hloop_AZ_Q(ntryL,G1H9(43),ex3(:),G1H3(122),ngZn,m3h3x3(:,67),heltab2x9(:,:,79))
  call Hloop_A_Q(ntryL,G1H3(122),23,0,G2H3(13),n2h3(121))
  call Hloop_QZ_A(ntryL,G1H9(44),ex3(:),G1H3(155),ngZl,m3h3x3(:,68),heltab2x9(:,:,80))
  call Hloop_Q_A(ntryL,G1H3(155),23,nME,G2H3(16),n2h3(122))
  call Hloop_QZ_A(ntryL,G1H9(25),ex3(:),G1H3(166),ngZl,m3h3x3(:,69),heltab2x9(:,:,81))
  call Hloop_Q_A(ntryL,G1H3(166),23,nMM,G2H3(15),n2h3(123))
  call Hloop_QZ_A(ntryL,G1H9(17),ex3(:),G1H3(177),ngZl,m3h3x3(:,70),heltab2x9(:,:,82))
  call Hloop_Q_A(ntryL,G1H3(177),23,nML,G2H3(49),n2h3(124))
  call Hloop_AZ_Q(ntryL,G1H9(11),ex3(:),G1H3(210),ngZu,m3h3x3(:,71),heltab2x9(:,:,83))
  call Hloop_A_Q(ntryL,G1H3(210),23,0,G2H3(23),n2h3(125))
  call Hloop_AZ_Q(ntryL,G1H9(18),ex3(:),G1H3(221),ngZu,m3h3x3(:,72),heltab2x9(:,:,84))
  call Hloop_A_Q(ntryL,G1H3(221),23,nMT,G2H3(18),n2h3(126))
  call Hloop_QZ_A(ntryL,G1H9(23),ex3(:),G1H3(7),ngZd,m3h3x3(:,73),heltab2x9(:,:,85))
  call Hloop_Q_A(ntryL,G1H3(7),23,0,G2H3(55),n2h3(127))
  call Hloop_QZ_A(ntryL,G1H9(35),ex3(:),G1H3(14),ngZd,m3h3x3(:,74),heltab2x9(:,:,86))
  call Hloop_Q_A(ntryL,G1H3(14),23,nMB,G2H3(27),n2h3(128))
  call Hloop_SV_T(ntryL,G1H9(41),19,ex3(:),4,G2H3(31),m3h3x3(:,75),heltab2x9(:,:,87))
  call Hloop_TV_S(ntryL,G1H9(42),19,ex3(:),4,G2H3(35),m3h3x3(:,76),heltab2x9(:,:,88))
  call Hloop_TV_S(ntryL,G1H9(2),19,ex3(:),4,G2H3(4),m3h3x3(:,77),heltab2x9(:,:,89))
  call Hloop_TV_S(ntryL,G1H9(12),19,ex3(:),4,G2H3(60),m3h3x3(:,78),heltab2x9(:,:,90))
  call Hloop_CV_D(ntryL,G1H9(26),19,ex3(:),4,G2H3(39),m3h3x3(:,79),heltab2x9(:,:,91))
  call Hloop_CV_D(ntryL,G1H9(3),19,ex3(:),4,G2H3(7),m3h3x3(:,80),heltab2x9(:,:,92))
  call Hloop_DV_C(ntryL,G1H9(51),19,ex3(:),G2H3(66),m3h3x3(:,81),heltab2x9(:,:,93))
  call Hloop_DV_C(ntryL,G1H9(52),19,ex3(:),G2H3(43),m3h3x3(:,82),heltab2x9(:,:,94))
  call Hloop_UV_W(ntryL,G1H9(53),19,ex3(:),4,G2H3(52),m3h3x3(:,83),heltab2x9(:,:,95))
  call Hloop_UV_W(ntryL,G1H9(54),19,ex3(:),4,G2H3(46),m3h3x3(:,84),heltab2x9(:,:,96))
  call Hloop_TV_S(ntryL,G0H9(9),19,ex3(:),4,G1H3(18),m3h3x3(:,85),heltab2x9(:,:,97))
  call Hloop_TV_S(ntryL,G0H9(10),19,ex3(:),4,G1H3(19),m3h3x3(:,86),heltab2x9(:,:,98))
  call Hloop_VV_S(ntryL,G0H9(11),ex3(:),G0H3(1),m3h3x3(:,87),heltab2x9(:,:,99))
  call Hloop_VV_S(ntryL,G0H9(12),ex3(:),G0H3(2),m3h3x3(:,88),heltab2x9(:,:,100))
  call Hloop_SV_V(ntryL,G1H9(55),ex3(:),G1H3(29),m3h3x3(:,89),heltab2x9(:,:,101))
  call Hloop_SV_V(ntryL,G1H9(56),ex3(:),G1H3(30),m3h3x3(:,90),heltab2x9(:,:,102))
  call Hloop_VV_S(ntryL,G1H9(57),ex3(:),G1H3(35),m3h3x3(:,91),heltab2x9(:,:,103))
  call Hloop_VV_S(ntryL,G1H9(58),ex3(:),G1H3(41),m3h3x3(:,92),heltab2x9(:,:,104))
  call Hloop_VV_S(ntryL,G1H9(59),ex3(:),G1H3(46),m3h3x3(:,93),heltab2x9(:,:,105))
  call Hloop_SV_V(ntryL,G0H9(13),ex3(:),G0H3(3),m3h3x3(:,94),heltab2x9(:,:,106))
  call Hloop_SV_V(ntryL,G0H9(14),ex3(:),G0H3(4),m3h3x3(:,95),heltab2x9(:,:,107))
  call Hloop_SV_V(ntryL,G0H9(15),ex3(:),G0H3(5),m3h3x3(:,96),heltab2x9(:,:,108))
  call Hloop_UV_W(ntryL,G0H9(16),19,ex3(:),4,G1H3(47),m3h3x3(:,97),heltab2x9(:,:,109))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(52),G2H2(49),G2H2(32),G2H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G2H2(46),G2H2(43),G2H2(35),G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(90),[G1H3(83),G1H3(161)])
call HGT_w2_OLR(G1H3(106),1,1,3)
call HGT_w2_invQ_OLR(G1H3(106),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(106),[G1H3(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(247),[G1H3(98),G1H3(23)])
call HGT_w2_OLR(G1H3(107),1,1,3)
call HGT_w2_invQ_OLR(G1H3(107),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(107),[G1H3(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(23),[G1H3(174),G1H3(175),G1H3(82)])
call HGT_w2_OLR(G1H3(112),1,1,3)
call HGT_w2_invQ_OLR(G1H3(112),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(23),[G1H3(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(49),[G1H3(15),G1H3(109)])
call HGT_w2_OLR(G1H3(113),1,1,3)
call HGT_w2_invQ_OLR(G1H3(113),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(113),[G1H3(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(128),[G1H3(131),G1H3(51)])
call HGT_w2_OLR(G1H3(117),1,1,3)
call HGT_w2_invQ_OLR(G1H3(117),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(117),[G1H3(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(183),[G1H3(196),G1H3(216)])
call HGT_w2_OLR(G1H3(118),1,1,3)
call HGT_w2_invQ_OLR(G1H3(118),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(118),[G1H3(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(211),[G1H3(279),G1H3(274),G1H3(188)])
call HGT_w2_OLR(G1H3(123),1,1,3)
call HGT_w2_invQ_OLR(G1H3(123),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(123),[G1H3(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G2H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(12),[G1H3(244),G1H3(239),G1H3(146)])
call HGT_w2_OLR(G1H3(124),1,1,3)
call HGT_w2_invQ_OLR(G1H3(124),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(124),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(9),[G2H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(32),[G1H9(47)])
call HGT_w2_OLR(G1H9(5),1,1,9)
call HGT_w2_invQ_OLR(G1H9(5),2,5,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(5),[G1H9(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(44),[G1H3(52),G1H3(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(92),[G1H3(141),G1H3(120),G1H3(40),G1H3(13),G1H3(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(178),[G1H3(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(197),G1H3(153),G1H3(205),G1H3(190),G1H3(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(45),[G1H3(259),G1H3(254),G1H3(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(91),[G1H3(185),G1H3(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(89),[G1H3(217),G1H3(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(252),[G1H3(16),G1H3(144),G1H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(184),[G1H3(219),G1H3(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(263),[G1H3(39),G1H3(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(25),[G1H3(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(156),[G1H3(72),G1H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(212),[G1H3(290),G1H3(285),G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(157),[G1H3(227),G1H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(267),[G1H3(230),G1H3(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(272),[G1H3(235),G1H3(77),G1H3(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(129),[G1H3(138),G1H3(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(282),[G1H3(237),G1H3(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(255),[G1H3(240),G1H3(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(260),[G1H3(245),G1H3(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(50),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(52),[G1H3(79),G1H3(20),G0H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(96),[G1H3(333),G1H3(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(95),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(100),[G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(46),[G1H3(315),G1H3(220),G0H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(102),[G1H3(343),G1H3(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(110),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(99),[G1H2(94),G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(286),[G1H3(275),G1H3(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(291),[G1H3(280),G1H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(109),[G1H2(104),G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(85),[G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(61),[G1H3(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(115),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(120),[G1H2(90),G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(322),[G1H3(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(125),[G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(124),[G1H2(119),G1H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(55),[G1H3(105),G1H3(160),G1H3(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(193),[G1H3(234),G1H3(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(56),[G1H3(262),G1H3(251),G1H3(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(222),[G1H3(226),G1H3(271),G1H3(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(91),[G1H6(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(124),[G1H6(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(49),[G1H6(115),G1H6(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(44),[G1H6(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(47),[G1H6(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(57),[G1H6(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(42),[G1H6(66),G1H6(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(37),[G1H6(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(38),[G1H6(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(10),[G1H9(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(30),[G1H9(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(13),[G1H9(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(37),[G1H9(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(33),[G1H9(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(139),[G1H3(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(167),[G1H3(311),G1H3(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(140),[G1H3(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(168),[G1H3(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(145),[G1H3(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(172),[G1H3(316),G1H3(304)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(151),[G1H3(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(179),[G1H3(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(323),[G1H3(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(194),[G1H3(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(95),[G1H3(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(195),[G1H3(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(200),[G1H3(337)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(101),[G1H3(338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(206),[G1H3(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(5),[G2H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(7),[G2H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(13),[G2H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(15),[G2H12(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(31),[G0H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G0H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(35),[G1H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(46),[G1H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(47),[G1H3(30)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex2(:),G2tensor(4),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(55),ex2(:),G2tensor(6),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hloop_AW_Q(ntryL,G1H3(106),ex4(:),G1H1(1),m3h3x1(:,339),heltab2x3(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(453))
  call Hloop_AZ_Q(ntryL,G1H3(107),ex3(:),G1H1(1),ngZd,m3h3x1(:,340),heltab2x3(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(454))
  call Hloop_AW_Q(ntryL,G2H3(23),ex4(:),G2H1(1),m3h3x1(:,341),heltab2x3(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(1),n2h1(455))
  call Hloop_AZ_Q(ntryL,G1H3(113),ex3(:),G1H1(1),ngZd,m3h3x1(:,342),heltab2x3(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(456))
  call Hloop_QW_A(ntryL,G1H3(117),ex4(:),G1H1(1),m3h3x1(:,343),heltab2x3(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(457))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(21),wf6(:,3),G2tensor(14),m3h6x1(:,57),heltab2x6(:,:,226))
  call Hloop_AW_Q(ntryL,G1H3(118),ex4(:),G1H1(1),m3h3x1(:,344),heltab2x3(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(458))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(1),wf6(:,8),G2tensor(15),m3h6x1(:,58),heltab2x6(:,:,227))
  call Hloop_QZ_A(ntryL,G1H3(123),ex3(:),G1H1(1),ngZd,m3h3x1(:,345),heltab2x3(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(459))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(10),wf6(:,7),G2tensor(95),m3h6x1(:,59),heltab2x6(:,:,228))
  call Hloop_AZ_Q(ntryL,G1H3(124),ex3(:),G1H1(1),ngZu,m3h3x1(:,346),heltab2x3(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(18),n2h1(460))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(9),wf6(:,4),G2tensor(20),m3h6x1(:,60),heltab2x6(:,:,229))
  call Hloop_AW_Q(ntryL,G1H9(5),wf9(:,1),G1H1(1),m3h9x1(:,13),heltab2x9(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(461))
  call Hloop_VQ_A(ntryL,G1H2(13),ex2(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(462))
  call Hloop_VQ_A(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(463))
  call Hloop_QW_A(ntryL,G1H3(44),ex4(:),G1H1(1),m3h3x1(:,347),heltab2x3(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(464))
  call Hloop_QW_A(ntryL,G1H3(92),ex4(:),G1H1(1),m3h3x1(:,348),heltab2x3(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(465))
  call Hloop_ZQ_A(ntryL,G1H2(25),ex2(:),G1H1(1),ngZd,m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(466))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex2(:),G1H1(1),ngZd,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(467))
  call Hloop_AZ_Q(ntryL,G1H3(178),ex3(:),G1H1(1),ngZu,m3h3x1(:,349),heltab2x3(:,:,349))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(468))
  call Hloop_AW_Q(ntryL,G1H3(2),ex4(:),G1H1(1),m3h3x1(:,350),heltab2x3(:,:,350))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(469))
  call Hloop_AZ_Q(ntryL,G1H3(45),ex3(:),G1H1(1),ngZu,m3h3x1(:,351),heltab2x3(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(470))
  call Hloop_AW_Q(ntryL,G1H3(91),ex4(:),G1H1(1),m3h3x1(:,352),heltab2x3(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(471))
  call Hloop_VA_Q(ntryL,G1H2(5),ex1(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(472))
  call Hloop_VA_Q(ntryL,G1H2(30),ex1(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(473))
  call Hloop_AW_Q(ntryL,G1H3(89),ex4(:),G1H1(1),m3h3x1(:,353),heltab2x3(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(474))
  call Hloop_ZA_Q(ntryL,G1H2(12),ex1(:),G1H1(1),ngZu,m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(475))
  call Hloop_ZA_Q(ntryL,G1H2(35),ex1(:),G1H1(1),ngZu,m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(476))
  call Hloop_AZ_Q(ntryL,G1H3(252),ex3(:),G1H1(1),ngZd,m3h3x1(:,354),heltab2x3(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(477))
  call Hloop_AW_Q(ntryL,G1H3(184),ex4(:),G1H1(1),m3h3x1(:,355),heltab2x3(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(478))
  call Hloop_AZ_Q(ntryL,G1H3(263),ex3(:),G1H1(1),ngZd,m3h3x1(:,356),heltab2x3(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(56),n2h1(479))
  call Hloop_QZ_A(ntryL,G1H3(25),ex3(:),G1H1(1),ngZd,m3h3x1(:,357),heltab2x3(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(480))
  call Hloop_QW_A(ntryL,G1H3(156),ex4(:),G1H1(1),m3h3x1(:,358),heltab2x3(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(481))
  call Hloop_QZ_A(ntryL,G1H3(212),ex3(:),G1H1(1),ngZd,m3h3x1(:,359),heltab2x3(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(60),n2h1(482))
  call Hloop_QW_A(ntryL,G1H3(157),ex4(:),G1H1(1),m3h3x1(:,360),heltab2x3(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(483))
  call Hloop_QZ_A(ntryL,G1H3(267),ex3(:),G1H1(1),ngZu,m3h3x1(:,361),heltab2x3(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(484))
  call Hloop_QZ_A(ntryL,G1H3(272),ex3(:),G1H1(1),ngZu,m3h3x1(:,362),heltab2x3(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(485))
  call Hloop_QW_A(ntryL,G1H3(129),ex4(:),G1H1(1),m3h3x1(:,363),heltab2x3(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(72),n2h1(486))
  call Hloop_QZ_A(ntryL,G1H3(282),ex3(:),G1H1(1),ngZu,m3h3x1(:,364),heltab2x3(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(487))
  call Hloop_VA_Q(ntryL,G1H2(14),ex1(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(76),n2h1(488))
  call Hloop_VA_Q(ntryL,G1H2(23),ex1(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(489))
  call Hloop_AZ_Q(ntryL,G1H3(255),ex3(:),G1H1(1),ngZu,m3h3x1(:,365),heltab2x3(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(80),n2h1(490))
  call Hloop_AZ_Q(ntryL,G1H3(260),ex3(:),G1H1(1),ngZu,m3h3x1(:,366),heltab2x3(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(491))
  call Hloop_WA_Q(ntryL,G1H2(11),ex1(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(86),n2h1(492))
  call Hloop_WA_Q(ntryL,G1H2(50),ex1(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(90),n2h1(493))
  call Hloop_ZA_Q(ntryL,G1H2(38),ex1(:),G1H1(1),ngZu,m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(494))
  call Hloop_ZA_Q(ntryL,G1H2(45),ex1(:),G1H1(1),ngZu,m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(94),n2h1(495))
  call Hloop_WA_Q(ntryL,G1H2(49),ex1(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(496))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H3(52),23,ex4(:),8,G3tensor(2),m3h3x1(:,367),heltab2x3(:,:,367))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(96),23,ex4(:),8,G2tensor(99),m3h3x1(:,368),heltab2x3(:,:,368))
  call Hloop_VQ_A(ntryL,G1H2(95),ex2(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(155),n2h1(497))
  call Hloop_VQ_A(ntryL,G1H2(100),ex2(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(305),n2h1(498))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H3(46),23,ex4(:),8,G3tensor(3),m3h3x1(:,369),heltab2x3(:,:,369))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(102),23,ex4(:),8,G2tensor(317),m3h3x1(:,370),heltab2x3(:,:,370))
  call Hloop_ZQ_A(ntryL,G1H2(105),ex2(:),G1H1(1),ngZd,m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(150),n2h1(499))
  call Hloop_ZQ_A(ntryL,G1H2(110),ex2(:),G1H1(1),ngZd,m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(146),n2h1(500))
  call Hloop_WQ_A(ntryL,G1H2(64),ex2(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(233),n2h1(501))
  call Hloop_WQ_A(ntryL,G1H2(75),ex2(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(419),n2h1(502))
  call Hloop_VQ_A(ntryL,G1H2(99),ex2(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(239),n2h1(503))
  call Hloop_VQ_A(ntryL,G1H2(70),ex2(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(260),n2h1(504))
  call Hloop_QZ_A(ntryL,G1H3(286),ex3(:),G1H1(1),ngZd,m3h3x1(:,371),heltab2x3(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(395),n2h1(505))
  call Hloop_QZ_A(ntryL,G1H3(291),ex3(:),G1H1(1),ngZd,m3h3x1(:,372),heltab2x3(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(266),n2h1(506))
  call Hloop_WQ_A(ntryL,G1H2(74),ex2(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(401),n2h1(507))
  call Hloop_ZQ_A(ntryL,G1H2(109),ex2(:),G1H1(1),ngZd,m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(152),n2h1(508))
  call Hloop_ZQ_A(ntryL,G1H2(80),ex2(:),G1H1(1),ngZd,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(422),n2h1(509))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(85),27,ex3(:),4,G2tensor(158),m3h3x1(:,373),heltab2x3(:,:,373))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(61),27,ex3(:),4,G2tensor(425),m3h3x1(:,374),heltab2x3(:,:,374))
  call Hloop_WQ_A(ntryL,G1H2(115),ex2(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(161),n2h1(510))
  call Hloop_WQ_A(ntryL,G1H2(120),ex2(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(437),n2h1(511))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(322),27,ex3(:),4,G2tensor(167),m3h3x1(:,375),heltab2x3(:,:,375))
  call Hloop_WQ_A(ntryL,G1H2(125),ex2(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(440),n2h1(512))
  call Hloop_WQ_A(ntryL,G1H2(124),ex2(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(173),n2h1(513))
  call Hloop_QW_A(ntryL,G2H3(55),ex4(:),G2H1(1),m3h3x1(:,376),heltab2x3(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(4),n2h1(514))
  call Hloop_QZ_A(ntryL,G1H3(193),ex3(:),G1H1(1),ngZu,m3h3x1(:,377),heltab2x3(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(410),n2h1(515))
  call Hloop_AZ_Q(ntryL,G1H3(56),ex3(:),G1H1(1),ngZd,m3h3x1(:,378),heltab2x3(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(179),n2h1(516))
  call Hloop_QZ_A(ntryL,G1H3(222),ex3(:),G1H1(1),ngZu,m3h3x1(:,379),heltab2x3(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(413),n2h1(517))
  call Hloop_VA_Q(ntryL,G1H6(70),wf6(:,3),G1H1(1),m3h6x1(:,61),heltab2x6(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(182),n2h1(518))
  call Hloop_VA_Q(ntryL,G1H6(71),wf6(:,3),G1H1(1),m3h6x1(:,62),heltab2x6(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(188),n2h1(519))
  call Hloop_WA_Q(ntryL,G1H6(77),wf6(:,3),G1H1(1),m3h6x1(:,63),heltab2x6(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(194),n2h1(520))
  call Hloop_WA_Q(ntryL,G1H6(91),wf6(:,3),G1H1(1),m3h6x1(:,64),heltab2x6(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(431),n2h1(521))
  call Hloop_ZA_Q(ntryL,G1H6(86),wf6(:,3),G1H1(1),ngZu,m3h6x1(:,65),heltab2x6(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(200),n2h1(522))
  call Hloop_ZA_Q(ntryL,G1H6(87),wf6(:,3),G1H1(1),ngZu,m3h6x1(:,66),heltab2x6(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(434),n2h1(523))
  call Hloop_WA_Q(ntryL,G1H6(90),wf6(:,3),G1H1(1),m3h6x1(:,67),heltab2x6(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(206),n2h1(524))
  call Hloop_WQ_A(ntryL,G1H6(97),wf6(:,8),G1H1(1),m3h6x1(:,68),heltab2x6(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(212),n2h1(525))
  call Hloop_WQ_A(ntryL,G1H6(124),wf6(:,8),G1H1(1),m3h6x1(:,69),heltab2x6(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(218),n2h1(526))
  call Hloop_VQ_A(ntryL,G1H6(107),wf6(:,8),G1H1(1),m3h6x1(:,70),heltab2x6(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(383),n2h1(527))
  call Hloop_VQ_A(ntryL,G1H6(109),wf6(:,8),G1H1(1),m3h6x1(:,71),heltab2x6(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(224),n2h1(528))
  call Hloop_WQ_A(ntryL,G1H6(119),wf6(:,8),G1H1(1),m3h6x1(:,72),heltab2x6(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(386),n2h1(529))
  call Hloop_ZQ_A(ntryL,G1H6(128),wf6(:,8),G1H1(1),ngZd,m3h6x1(:,73),heltab2x6(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(227),n2h1(530))
  call Hloop_ZQ_A(ntryL,G1H6(101),wf6(:,8),G1H1(1),ngZd,m3h6x1(:,74),heltab2x6(:,:,243))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(389),n2h1(531))
  call Hloop_WA_Q(ntryL,G1H6(1),wf6(:,7),G1H1(1),m3h6x1(:,75),heltab2x6(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(230),n2h1(532))
  call Hloop_WA_Q(ntryL,G1H6(49),wf6(:,7),G1H1(1),m3h6x1(:,76),heltab2x6(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(392),n2h1(533))
  call Hloop_VA_Q(ntryL,G1H6(20),wf6(:,7),G1H1(1),m3h6x1(:,77),heltab2x6(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(245),n2h1(534))
  call Hloop_VA_Q(ntryL,G1H6(44),wf6(:,7),G1H1(1),m3h6x1(:,78),heltab2x6(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(248),n2h1(535))
  call Hloop_ZA_Q(ntryL,G1H6(22),wf6(:,7),G1H1(1),ngZd,m3h6x1(:,79),heltab2x6(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(398),n2h1(536))
  call Hloop_ZA_Q(ntryL,G1H6(47),wf6(:,7),G1H1(1),ngZd,m3h6x1(:,80),heltab2x6(:,:,249))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(254),n2h1(537))
  call Hloop_WA_Q(ntryL,G1H6(99),wf6(:,7),G1H1(1),m3h6x1(:,81),heltab2x6(:,:,250))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(257),n2h1(538))
  call Hloop_WQ_A(ntryL,G1H6(57),wf6(:,4),G1H1(1),m3h6x1(:,82),heltab2x6(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(404),n2h1(539))
  call Hloop_WQ_A(ntryL,G1H6(42),wf6(:,4),G1H1(1),m3h6x1(:,83),heltab2x6(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(269),n2h1(540))
  call Hloop_VQ_A(ntryL,G1H6(33),wf6(:,4),G1H1(1),m3h6x1(:,84),heltab2x6(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(242),n2h1(541))
  call Hloop_VQ_A(ntryL,G1H6(37),wf6(:,4),G1H1(1),m3h6x1(:,85),heltab2x6(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(272),n2h1(542))
  call Hloop_ZQ_A(ntryL,G1H6(46),wf6(:,4),G1H1(1),ngZu,m3h6x1(:,86),heltab2x6(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(142),n2h1(543))
  call Hloop_ZQ_A(ntryL,G1H6(38),wf6(:,4),G1H1(1),ngZu,m3h6x1(:,87),heltab2x6(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(140),n2h1(544))
  call Hloop_WQ_A(ntryL,G1H6(61),wf6(:,4),G1H1(1),m3h6x1(:,88),heltab2x6(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(545))
  call Hloop_QW_A(ntryL,G1H9(10),wf9(:,1),G1H1(1),m3h9x1(:,14),heltab2x9(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(275),n2h1(546))
  call Hloop_QW_A(ntryL,G1H9(30),wf9(:,1),G1H1(1),m3h9x1(:,15),heltab2x9(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(143),n2h1(547))
  call Hloop_QW_A(ntryL,G1H9(13),wf9(:,1),G1H1(1),m3h9x1(:,16),heltab2x9(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(141),n2h1(548))
  call Hloop_AW_Q(ntryL,G1H9(37),wf9(:,1),G1H1(1),m3h9x1(:,17),heltab2x9(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(278),n2h1(549))
  call Hloop_AW_Q(ntryL,G1H9(33),wf9(:,1),G1H1(1),m3h9x1(:,18),heltab2x9(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(281),n2h1(550))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(139),23,ex4(:),8,G2tensor(236),m3h3x1(:,380),heltab2x3(:,:,380))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(167),23,ex4(:),8,G2tensor(284),m3h3x1(:,381),heltab2x3(:,:,381))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(140),23,ex4(:),8,G2tensor(287),m3h3x1(:,382),heltab2x3(:,:,382))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(168),23,ex4(:),8,G2tensor(290),m3h3x1(:,383),heltab2x3(:,:,383))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(145),23,ex4(:),8,G2tensor(293),m3h3x1(:,384),heltab2x3(:,:,384))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(172),23,ex4(:),8,G2tensor(263),m3h3x1(:,385),heltab2x3(:,:,385))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(151),23,ex4(:),8,G2tensor(296),m3h3x1(:,386),heltab2x3(:,:,386))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(179),23,ex4(:),8,G2tensor(299),m3h3x1(:,387),heltab2x3(:,:,387))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(323),27,ex3(:),4,G2tensor(176),m3h3x1(:,388),heltab2x3(:,:,388))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(194),23,ex4(:),8,G2tensor(302),m3h3x1(:,389),heltab2x3(:,:,389))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(95),23,ex4(:),8,G2tensor(326),m3h3x1(:,390),heltab2x3(:,:,390))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(195),23,ex4(:),8,G2tensor(164),m3h3x1(:,391),heltab2x3(:,:,391))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(200),23,ex4(:),8,G2tensor(308),m3h3x1(:,392),heltab2x3(:,:,392))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(101),23,ex4(:),8,G2tensor(170),m3h3x1(:,393),heltab2x3(:,:,393))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(206),23,ex4(:),8,G2tensor(311),m3h3x1(:,394),heltab2x3(:,:,394))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(314),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(13),ex2(:),G2tensor(335),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(5),wf6(:,3),G2tensor(185),m3h6x1(:,89),heltab2x6(:,:,258))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(6),wf6(:,8),G2tensor(320),m3h6x1(:,90),heltab2x6(:,:,259))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(7),wf6(:,7),G2tensor(191),m3h6x1(:,91),heltab2x6(:,:,260))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(8),wf6(:,4),G2tensor(323),m3h6x1(:,92),heltab2x6(:,:,261))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H9(36),ex4(:),ex3(:),G1tensor(73),m4h3x3x1(:,1),heltab3x9(:,:,1))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H9(4),ex3(:),ex4(:),G1tensor(103),m4h3x3x1(:,2),heltab3x9(:,:,2))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H9(14),ex4(:),ex3(:),G1tensor(133),m4h3x3x1(:,3),heltab3x9(:,:,3))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H9(48),ex3(:),ex4(:),G1tensor(163),m4h3x3x1(:,4),heltab3x9(:,:,4))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H9(15),ex3(:),ex4(:),G1tensor(36),m4h3x3x1(:,5),heltab3x9(:,:,5))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H9(45),ex4(:),ex3(:),G1tensor(38),m4h3x3x1(:,6),heltab3x9(:,:,6))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H9(46),ex3(:),ex4(:),G1tensor(162),m4h3x3x1(:,7),heltab3x9(:,:,7))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H9(49),ex4(:),ex3(:),G1tensor(60),m4h3x3x1(:,8),heltab3x9(:,:,8))
  call Hloop_VA_Q(ntryL,G1H18(65),wf18(:,9),G1H1(1),m3h18x1(:,1),heltab2x18(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(197),n2h1(551))
  call Hloop_ZA_Q(ntryL,G1H18(13),wf18(:,9),G1H1(1),ngZd,m3h18x1(:,2),heltab2x18(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(329),n2h1(552))
  call Hloop_WA_Q(ntryL,G1H18(15),wf18(:,9),G1H1(1),m3h18x1(:,3),heltab2x18(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(203),n2h1(553))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H18(1),wf18(:,9),G2tensor(332),m3h18x1(:,4),heltab2x18(:,:,181))
  call Hloop_VQ_A(ntryL,G1H18(17),wf18(:,11),G1H1(1),m3h18x1(:,5),heltab2x18(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(209),n2h1(554))
  call Hloop_ZQ_A(ntryL,G1H18(18),wf18(:,11),G1H1(1),ngZu,m3h18x1(:,6),heltab2x18(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(338),n2h1(555))
  call Hloop_WQ_A(ntryL,G1H18(20),wf18(:,11),G1H1(1),m3h18x1(:,7),heltab2x18(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(215),n2h1(556))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H18(2),wf18(:,11),G2tensor(341),m3h18x1(:,8),heltab2x18(:,:,185))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H6(11),wf6(:,7),G2tensor(344),ngZd,m3h6x1(:,93),heltab2x6(:,:,262))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(12),wf6(:,7),G2tensor(221),m3h6x1(:,94),heltab2x6(:,:,263))
  call Hloop_QV_A(ntryL,G2H12(5),wf12(:,10),G2H1(1),m3h12x1(:,1),heltab2x12(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(5),n2h1(557))
  call Hloop_QV_A(ntryL,G2H12(2),wf12(:,10),G2H1(1),m3h12x1(:,2),heltab2x12(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(6),n2h1(558))
  call Hloop_AV_Q(ntryL,G2H12(7),wf12(:,10),G2H1(1),m3h12x1(:,3),heltab2x12(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(7),n2h1(559))
  call Hloop_AV_Q(ntryL,G2H12(4),wf12(:,10),G2H1(1),m3h12x1(:,4),heltab2x12(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(8),n2h1(560))
  call Hloop_QV_A(ntryL,G2H12(6),wf12(:,10),G2H1(1),m3h12x1(:,5),heltab2x12(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(9),n2h1(561))
  call Hloop_AV_Q(ntryL,G2H12(8),wf12(:,10),G2H1(1),m3h12x1(:,6),heltab2x12(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(10),n2h1(562))
  call Hloop_VA_Q(ntryL,G1H18(22),wf18(:,12),G1H1(1),m3h18x1(:,9),heltab2x18(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(347),n2h1(563))
  call Hloop_ZA_Q(ntryL,G1H18(23),wf18(:,12),G1H1(1),ngZd,m3h18x1(:,10),heltab2x18(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(350),n2h1(564))
  call Hloop_WA_Q(ntryL,G1H18(25),wf18(:,12),G1H1(1),m3h18x1(:,11),heltab2x18(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(353),n2h1(565))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H18(3),wf18(:,12),G2tensor(356),m3h18x1(:,12),heltab2x18(:,:,189))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(223),27,ex3(:),4,G2tensor(359),m3h3x1(:,395),heltab2x3(:,:,395))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H6(13),wf6(:,4),G2tensor(362),ngZu,m3h6x1(:,95),heltab2x6(:,:,264))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(14),wf6(:,4),G2tensor(365),m3h6x1(:,96),heltab2x6(:,:,265))
  call Hloop_QV_A(ntryL,G2H12(13),wf12(:,13),G2H1(1),m3h12x1(:,7),heltab2x12(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(11),n2h1(566))
  call Hloop_QV_A(ntryL,G2H12(10),wf12(:,13),G2H1(1),m3h12x1(:,8),heltab2x12(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(12),n2h1(567))
  call Hloop_AV_Q(ntryL,G2H12(15),wf12(:,13),G2H1(1),m3h12x1(:,9),heltab2x12(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(13),n2h1(568))
  call Hloop_AV_Q(ntryL,G2H12(12),wf12(:,13),G2H1(1),m3h12x1(:,10),heltab2x12(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(14),n2h1(569))
  call Hloop_QV_A(ntryL,G2H12(14),wf12(:,13),G2H1(1),m3h12x1(:,11),heltab2x12(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(15),n2h1(570))
  call Hloop_AV_Q(ntryL,G2H12(16),wf12(:,13),G2H1(1),m3h12x1(:,12),heltab2x12(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(16),n2h1(571))
  call Hloop_VQ_A(ntryL,G1H18(1),wf18(:,14),G1H1(1),m3h18x1(:,13),heltab2x18(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(368),n2h1(572))
  call Hloop_ZQ_A(ntryL,G1H18(2),wf18(:,14),G1H1(1),ngZu,m3h18x1(:,14),heltab2x18(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(371),n2h1(573))
  call Hloop_WQ_A(ntryL,G1H18(5),wf18(:,14),G1H1(1),m3h18x1(:,15),heltab2x18(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(251),n2h1(574))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H18(4),wf18(:,14),G2tensor(374),m3h18x1(:,16),heltab2x18(:,:,193))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(67),27,ex3(:),4,G2tensor(377),m3h3x1(:,396),heltab2x3(:,:,396))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(50),wf9(:,3),G1tensor(96),m3h9x1(:,19),heltab2x9(:,:,116))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(7),wf9(:,3),G1tensor(84),m3h9x1(:,20),heltab2x9(:,:,117))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(8),wf9(:,3),G1tensor(98),m3h9x1(:,21),heltab2x9(:,:,118))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(9),wf9(:,3),G1tensor(108),m3h9x1(:,22),heltab2x9(:,:,119))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H9(16),19,wf9(:,1),12,G2tensor(380),m3h9x1(:,23),heltab2x9(:,:,120))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H9(19),19,wf9(:,1),12,G2tensor(455),m3h9x1(:,24),heltab2x9(:,:,121))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H9(20),19,wf9(:,1),12,G2tensor(458),m3h9x1(:,25),heltab2x9(:,:,122))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H9(21),19,wf9(:,1),12,G2tensor(461),m3h9x1(:,26),heltab2x9(:,:,123))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(22),wf9(:,3),G1tensor(122),m3h9x1(:,27),heltab2x9(:,:,124))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(27),wf9(:,3),G1tensor(138),m3h9x1(:,28),heltab2x9(:,:,125))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(28),wf9(:,3),G1tensor(156),m3h9x1(:,29),heltab2x9(:,:,126))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(31),wf9(:,3),G1tensor(47),m3h9x1(:,30),heltab2x9(:,:,127))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H9(38),19,wf9(:,1),12,G2tensor(464),m3h9x1(:,31),heltab2x9(:,:,128))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H9(60),19,wf9(:,1),12,G2tensor(144),m3h9x1(:,32),heltab2x9(:,:,129))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H9(61),19,wf9(:,1),12,G2tensor(148),m3h9x1(:,33),heltab2x9(:,:,130))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H9(62),19,wf9(:,1),12,G2tensor(407),m3h9x1(:,34),heltab2x9(:,:,131))
  call Hloop_VA_Q(ntryL,G1H18(7),wf18(:,18),G1H1(1),m3h18x1(:,17),heltab2x18(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(416),n2h1(575))
  call Hloop_ZA_Q(ntryL,G1H18(8),wf18(:,18),G1H1(1),ngZd,m3h18x1(:,18),heltab2x18(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(428),n2h1(576))
  call Hloop_WA_Q(ntryL,G1H18(11),wf18(:,18),G1H1(1),m3h18x1(:,19),heltab2x18(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(443),n2h1(577))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H18(5),wf18(:,18),G2tensor(446),m3h18x1(:,20),heltab2x18(:,:,197))
  call Hloop_VQ_A(ntryL,G1H18(41),wf18(:,16),G1H1(1),m3h18x1(:,21),heltab2x18(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(449),n2h1(578))
  call Hloop_ZQ_A(ntryL,G1H18(24),wf18(:,16),G1H1(1),ngZu,m3h18x1(:,22),heltab2x18(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(452),n2h1(579))
  call Hloop_WQ_A(ntryL,G1H18(45),wf18(:,16),G1H1(1),m3h18x1(:,23),heltab2x18(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(467),n2h1(580))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H18(6),wf18(:,16),G2tensor(470),m3h18x1(:,24),heltab2x18(:,:,201))
  call Hloop_AW_Q(ntryL,G2H3(2),ex4(:),G2H1(1),m3h3x1(:,397),heltab2x3(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(17),n2h1(581))
  call Hloop_AW_Q(ntryL,G2H3(9),ex4(:),G2H1(1),m3h3x1(:,398),heltab2x3(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(18),n2h1(582))
  call Hloop_AW_Q(ntryL,G2H3(13),ex4(:),G2H1(1),m3h3x1(:,399),heltab2x3(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(19),n2h1(583))
  call Hloop_QW_A(ntryL,G2H3(16),ex4(:),G2H1(1),m3h3x1(:,400),heltab2x3(:,:,400))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(20),n2h1(584))
  call Hloop_QW_A(ntryL,G2H3(15),ex4(:),G2H1(1),m3h3x1(:,401),heltab2x3(:,:,401))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(21),n2h1(585))
  call Hloop_QW_A(ntryL,G2H3(49),ex4(:),G2H1(1),m3h3x1(:,402),heltab2x3(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(22),n2h1(586))
  call Hloop_AW_Q(ntryL,G2H3(18),ex4(:),G2H1(1),m3h3x1(:,403),heltab2x3(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(23),n2h1(587))
  call Hloop_QW_A(ntryL,G2H3(27),ex4(:),G2H1(1),m3h3x1(:,404),heltab2x3(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(24),n2h1(588))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(31),23,ex4(:),8,G3tensor(25),m3h3x1(:,405),heltab2x3(:,:,405))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(35),23,ex4(:),8,G3tensor(26),m3h3x1(:,406),heltab2x3(:,:,406))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(4),23,ex4(:),8,G3tensor(27),m3h3x1(:,407),heltab2x3(:,:,407))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(60),23,ex4(:),8,G3tensor(28),m3h3x1(:,408),heltab2x3(:,:,408))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(39),23,ex4(:),8,G3tensor(29),m3h3x1(:,409),heltab2x3(:,:,409))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(7),23,ex4(:),8,G3tensor(30),m3h3x1(:,410),heltab2x3(:,:,410))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(66),23,ex4(:),G3tensor(31),m3h3x1(:,411),heltab2x3(:,:,411))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(43),23,ex4(:),G3tensor(32),m3h3x1(:,412),heltab2x3(:,:,412))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(35),ex4(:),G1tensor(63),m3h3x1(:,413),heltab2x3(:,:,413))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(46),ex4(:),G1tensor(17),m3h3x1(:,414),heltab2x3(:,:,414))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(29),ex4(:),G1tensor(27),m3h3x1(:,415),heltab2x3(:,:,415))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(47),ex4(:),G1tensor(39),m3h3x1(:,416),heltab2x3(:,:,416))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(41),ex4(:),G1tensor(52),m3h3x1(:,417),heltab2x3(:,:,417))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H3(4),23,ex4(:),8,G1tensor(58),m3h3x1(:,418),heltab2x3(:,:,418))
  call ol_merge_tensors(G2tensor(468),[G2tensor(423),G2tensor(153),G2tensor(22),G1tensor(567),G1tensor(114),G1tensor(86) &
    ,G0tensor(607),G0tensor(52),G0tensor(47)])
  call ol_merge_tensors(G2tensor(474),[G2tensor(426),G2tensor(159),G2tensor(26),G1tensor(577),G1tensor(126),G1tensor(110) &
    ,G0tensor(617),G0tensor(62),G0tensor(57)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(438),G2tensor(183),G2tensor(162),G2tensor(46),G2tensor(30),G1tensor(106) &
    ,G1tensor(20),G1tensor(158),G1tensor(140),G0tensor(107),G0tensor(88),G0tensor(72),G0tensor(67)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(441),G2tensor(189),G2tensor(168),G2tensor(50),G2tensor(34),G1tensor(69) &
    ,G1tensor(40),G1tensor(14),G1tensor(5),G0tensor(112),G0tensor(98),G0tensor(82),G0tensor(77)])
  call ol_merge_tensors(G2tensor(335),[G2tensor(447),G2tensor(411),G2tensor(174),G2tensor(38),G1tensor(552),G1tensor(268) &
    ,G1tensor(263),G1tensor(28),G1tensor(87),G0tensor(592),G0tensor(298),G0tensor(293),G0tensor(92),G0tensor(87)])
  call ol_merge_tensors(G2tensor(453),[G2tensor(414),G2tensor(180),G2tensor(42),G1tensor(562),G1tensor(83),G1tensor(46) &
    ,G0tensor(602),G0tensor(102),G0tensor(97)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(432),G2tensor(207),G2tensor(195),G2tensor(62),G2tensor(54),G1tensor(137) &
    ,G1tensor(93),G1tensor(112),G1tensor(75),G0tensor(137),G0tensor(122),G0tensor(117),G0tensor(48)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(435),G2tensor(213),G2tensor(201),G2tensor(66),G2tensor(58),G1tensor(135) &
    ,G1tensor(117),G1tensor(105),G1tensor(51),G0tensor(142),G0tensor(132),G0tensor(127),G0tensor(58)])
  call ol_merge_tensors(G2tensor(236),[G2tensor(384),G2tensor(219),G2tensor(70),G1tensor(548),G1tensor(159),G1tensor(148) &
    ,G0tensor(588),G0tensor(152),G0tensor(147)])
  call ol_merge_tensors(G2tensor(287),[G2tensor(462),G2tensor(387),G2tensor(225),G2tensor(74),G1tensor(553),G1tensor(512) &
    ,G1tensor(172),G1tensor(19),G0tensor(593),G0tensor(547),G0tensor(162),G0tensor(157)])
  call ol_merge_tensors(G2tensor(293),[G2tensor(390),G2tensor(228),G2tensor(78),G1tensor(558),G1tensor(182),G1tensor(177) &
    ,G0tensor(598),G0tensor(172),G0tensor(167)])
  call ol_merge_tensors(G2tensor(296),[G2tensor(465),G2tensor(393),G2tensor(231),G2tensor(82),G1tensor(563),G1tensor(517) &
    ,G1tensor(192),G1tensor(187),G0tensor(603),G0tensor(557),G0tensor(182),G0tensor(177)])
  call ol_merge_tensors(G2tensor(377),[G2tensor(420),G2tensor(240),G2tensor(234),G2tensor(84),G2tensor(83),G1tensor(30) &
    ,G1tensor(18),G1tensor(139),G0tensor(22),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G2tensor(302),[G2tensor(396),G2tensor(261),G2tensor(246),G2tensor(101),G2tensor(88),G1tensor(568) &
    ,G1tensor(197),G1tensor(48),G1tensor(150),G0tensor(608),G0tensor(187),G0tensor(32),G0tensor(27)])
  call ol_merge_tensors(G2tensor(164),[G2tensor(399),G2tensor(249),G2tensor(92),G1tensor(573),G1tensor(207),G1tensor(202) &
    ,G0tensor(613),G0tensor(197),G0tensor(192)])
  call ol_merge_tensors(G2tensor(308),[G2tensor(402),G2tensor(267),G2tensor(255),G2tensor(102),G2tensor(96),G1tensor(578) &
    ,G1tensor(212),G1tensor(72),G1tensor(62),G0tensor(618),G0tensor(202),G0tensor(42),G0tensor(37)])
  call ol_merge_tensors(G2tensor(311),[G2tensor(405),G2tensor(258),G2tensor(100),G1tensor(583),G1tensor(222),G1tensor(217) &
    ,G0tensor(623),G0tensor(212),G0tensor(207)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(277),G2tensor(274),G2tensor(7),G2tensor(2),G1tensor(260),G1tensor(252) &
    ,G1tensor(240),G1tensor(164),G0tensor(290),G0tensor(282),G0tensor(270),G0tensor(73)])
  call ol_merge_tensors(G2tensor(470),[G2tensor(449),G2tensor(374),G2tensor(368),G2tensor(341),G2tensor(209),G2tensor(433) &
    ,G2tensor(397),G2tensor(265),G2tensor(211),G2tensor(199),G2tensor(151),G2tensor(147),G2tensor(133),G2tensor(106),G2tensor(93) &
    ,G2tensor(3),G1tensor(410),G1tensor(390),G1tensor(310),G1tensor(255),G1tensor(99),G1tensor(56),G1tensor(127),G1tensor(97) &
    ,G0tensor(440),G0tensor(420),G0tensor(340),G0tensor(285),G0tensor(125),G0tensor(35),G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(273),G2tensor(5),G1tensor(428),G1tensor(423),G1tensor(237),G1tensor(144) &
    ,G1tensor(79),G0tensor(458),G0tensor(453),G0tensor(267),G0tensor(68),G0tensor(2)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(276),G2tensor(10),G1tensor(353),G1tensor(257),G1tensor(100),G1tensor(109) &
    ,G0tensor(383),G0tensor(287),G0tensor(108),G0tensor(7)])
  call ol_merge_tensors(G2tensor(242),[G2tensor(247),G2tensor(210),G2tensor(208),G2tensor(13),G1tensor(407),G1tensor(200) &
    ,G1tensor(142),G1tensor(102),G0tensor(437),G0tensor(190),G0tensor(140),G0tensor(53)])
  call ol_merge_tensors(G2tensor(272),[G2tensor(20),G2tensor(301),G2tensor(137),G2tensor(16),G1tensor(320),G1tensor(250) &
    ,G1tensor(104),G1tensor(91),G0tensor(350),G0tensor(280),G0tensor(54),G0tensor(4)])
  call ol_merge_tensors(G3tensor(13),[G3tensor(11),G3tensor(7),G3tensor(5),G2tensor(430),G2tensor(427),G2tensor(424),G2tensor(418) &
    ,G2tensor(415),G2tensor(412),G2tensor(178),G2tensor(157),G2tensor(55),G2tensor(19),G1tensor(545),G1tensor(540),G1tensor(325) &
    ,G1tensor(53),G1tensor(34),G1tensor(134),G1tensor(120),G0tensor(585),G0tensor(580),G0tensor(355),G0tensor(105),G0tensor(95) &
    ,G0tensor(65),G0tensor(55)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(256),G2tensor(216),G2tensor(214),G2tensor(23),G1tensor(417),G1tensor(215) &
    ,G1tensor(147),G1tensor(128),G0tensor(447),G0tensor(205),G0tensor(145),G0tensor(63)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(304),G2tensor(27),G1tensor(330),G1tensor(132),G0tensor(360),G0tensor(64)])
  call ol_merge_tensors(G2tensor(278),[G2tensor(143),G2tensor(337),G2tensor(328),G2tensor(319),G2tensor(307),G2tensor(105) &
    ,G2tensor(89),G2tensor(67),G2tensor(31),G1tensor(365),G1tensor(335),G1tensor(119),G1tensor(95),G1tensor(16),G1tensor(168) &
    ,G0tensor(395),G0tensor(365),G0tensor(134),G0tensor(124),G0tensor(84),G0tensor(74)])
  call ol_merge_tensors(G2tensor(446),[G2tensor(416),G2tensor(356),G2tensor(347),G2tensor(332),G2tensor(197),G2tensor(439) &
    ,G2tensor(388),G2tensor(187),G2tensor(166),G2tensor(149),G2tensor(145),G2tensor(71),G2tensor(35),G1tensor(530),G1tensor(525) &
    ,G1tensor(370),G1tensor(340),G1tensor(175),G1tensor(2),G0tensor(570),G0tensor(565),G0tensor(400),G0tensor(370),G0tensor(165) &
    ,G0tensor(75)])
  call ol_merge_tensors(G2tensor(281),[G2tensor(322),G2tensor(310),G2tensor(75),G2tensor(39),G1tensor(375),G1tensor(345) &
    ,G1tensor(15),G0tensor(405),G0tensor(375),G0tensor(83)])
  call ol_merge_tensors(G2tensor(428),[G2tensor(350),G2tensor(329),G2tensor(442),G2tensor(394),G2tensor(193),G2tensor(172) &
    ,G2tensor(79),G2tensor(43),G1tensor(380),G1tensor(350),G1tensor(195),G1tensor(23),G0tensor(410),G0tensor(380),G0tensor(185) &
    ,G0tensor(85)])
  call ol_merge_tensors(G2tensor(245),[G2tensor(226),G2tensor(186),G2tensor(184),G2tensor(47),G1tensor(367),G1tensor(170) &
    ,G1tensor(64),G1tensor(29),G0tensor(397),G0tensor(160),G0tensor(110),G0tensor(93)])
  call ol_merge_tensors(G2tensor(248),[G2tensor(95),G2tensor(313),G2tensor(51),G1tensor(529),G1tensor(355),G1tensor(33) &
    ,G0tensor(569),G0tensor(385),G0tensor(94)])
  call ol_merge_tensors(G2tensor(398),[G2tensor(232),G2tensor(192),G2tensor(190),G2tensor(59),G1tensor(377),G1tensor(190) &
    ,G1tensor(82),G1tensor(77),G0tensor(407),G0tensor(180),G0tensor(115),G0tensor(103)])
  call ol_merge_tensors(G2tensor(254),[G2tensor(316),G2tensor(63),G1tensor(360),G1tensor(59),G0tensor(390),G0tensor(104)])
  call ol_merge_tensors(G2tensor(275),[G2tensor(334),G2tensor(325),G2tensor(104),G2tensor(85),G1tensor(405),G1tensor(385) &
    ,G1tensor(143),G0tensor(435),G0tensor(415),G0tensor(123)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(340),G2tensor(331),G2tensor(107),G2tensor(97),G1tensor(415),G1tensor(395) &
    ,G1tensor(161),G0tensor(445),G0tensor(425),G0tensor(133)])
  call ol_merge_tensors(G2tensor(452),[G2tensor(371),G2tensor(338),G2tensor(436),G2tensor(403),G2tensor(271),G2tensor(217) &
    ,G2tensor(205),G2tensor(135),G2tensor(108),G2tensor(103),G1tensor(420),G1tensor(400),G1tensor(230),G1tensor(123),G1tensor(80) &
    ,G0tensor(450),G0tensor(430),G0tensor(240),G0tensor(235),G0tensor(135),G0tensor(45)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(343),G2tensor(109),G1tensor(425),G1tensor(165),G0tensor(455),G0tensor(153)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(14),G2tensor(346),G2tensor(110),G1tensor(524),G1tensor(430),G1tensor(166) &
    ,G0tensor(564),G0tensor(460),G0tensor(154)])
  call ol_merge_tensors(G2tensor(443),[G2tensor(353),G2tensor(203),G2tensor(409),G2tensor(391),G2tensor(385),G2tensor(223) &
    ,G2tensor(111),G1tensor(535),G1tensor(435),G1tensor(185),G1tensor(1),G0tensor(575),G0tensor(465),G0tensor(175) &
    ,G0tensor(155)])
  call ol_merge_tensors(G2tensor(194),[G2tensor(349),G2tensor(112),G1tensor(440),G1tensor(173),G0tensor(470),G0tensor(163)])
  call ol_merge_tensors(G2tensor(431),[G2tensor(352),G2tensor(113),G1tensor(445),G1tensor(194),G1tensor(174),G0tensor(475) &
    ,G0tensor(184),G0tensor(164)])
  call ol_merge_tensors(G2tensor(200),[G2tensor(355),G2tensor(114),G1tensor(450),G1tensor(183),G0tensor(480),G0tensor(173)])
  call ol_merge_tensors(G2tensor(434),[G2tensor(358),G2tensor(115),G1tensor(455),G1tensor(184),G0tensor(485),G0tensor(174)])
  call ol_merge_tensors(G2tensor(206),[G2tensor(361),G2tensor(116),G1tensor(460),G1tensor(193),G0tensor(490),G0tensor(183)])
  call ol_merge_tensors(G2tensor(404),[G2tensor(286),G2tensor(280),G2tensor(120),G2tensor(117),G1tensor(290),G1tensor(275) &
    ,G1tensor(24),G0tensor(320),G0tensor(305),G0tensor(18)])
  call ol_merge_tensors(G2tensor(269),[G2tensor(289),G2tensor(283),G2tensor(121),G2tensor(118),G1tensor(544),G1tensor(295) &
    ,G1tensor(280),G1tensor(37),G0tensor(584),G0tensor(325),G0tensor(310),G0tensor(19)])
  call ol_merge_tensors(G2tensor(467),[G2tensor(251),G2tensor(215),G2tensor(421),G2tensor(406),G2tensor(400),G2tensor(253) &
    ,G2tensor(244),G2tensor(238),G2tensor(127),G2tensor(122),G2tensor(119),G1tensor(485),G1tensor(285),G1tensor(235),G1tensor(225) &
    ,G1tensor(210),G1tensor(26),G0tensor(515),G0tensor(315),G0tensor(265),G0tensor(260),G0tensor(215),G0tensor(200) &
    ,G0tensor(20)])
  call ol_merge_tensors(G2tensor(212),[G2tensor(364),G2tensor(292),G2tensor(131),G2tensor(123),G1tensor(465),G1tensor(300) &
    ,G1tensor(50),G0tensor(495),G0tensor(330),G0tensor(33)])
  call ol_merge_tensors(G2tensor(218),[G2tensor(367),G2tensor(295),G2tensor(132),G2tensor(124),G1tensor(470),G1tensor(305) &
    ,G1tensor(78),G1tensor(54),G0tensor(500),G0tensor(335),G0tensor(44),G0tensor(34)])
  call ol_merge_tensors(G2tensor(383),[G2tensor(370),G2tensor(125),G1tensor(475),G1tensor(208),G0tensor(505),G0tensor(198)])
  call ol_merge_tensors(G2tensor(224),[G2tensor(15),G2tensor(373),G2tensor(139),G2tensor(126),G1tensor(480),G1tensor(270) &
    ,G1tensor(209),G1tensor(121),G0tensor(510),G0tensor(300),G0tensor(199),G0tensor(9)])
  call ol_merge_tensors(G2tensor(386),[G2tensor(376),G2tensor(298),G2tensor(134),G2tensor(128),G1tensor(490),G1tensor(315) &
    ,G1tensor(74),G0tensor(520),G0tensor(345),G0tensor(43)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(379),G2tensor(129),G1tensor(495),G1tensor(223),G0tensor(525),G0tensor(213)])
  call ol_merge_tensors(G2tensor(389),[G2tensor(382),G2tensor(130),G1tensor(500),G1tensor(224),G0tensor(530),G0tensor(214)])
  call ol_merge_tensors(G2tensor(323),[G2tensor(445),G2tensor(136),G1tensor(550),G1tensor(245),G1tensor(85),G0tensor(590) &
    ,G0tensor(275),G0tensor(3)])
  call ol_merge_tensors(G2tensor(320),[G2tensor(138),G1tensor(265),G1tensor(115),G0tensor(295),G0tensor(8)])
  call ol_merge_tensors(G2tensor(181),[G2tensor(177),G2tensor(175),G2tensor(160),G2tensor(156),G2tensor(154),G1tensor(322) &
    ,G1tensor(45),G1tensor(22),G1tensor(57),G1tensor(81),G0tensor(352),G0tensor(100),G0tensor(90),G0tensor(60),G0tensor(50)])
  call ol_merge_tensors(G2tensor(165),[G2tensor(163),G1tensor(337),G1tensor(152),G0tensor(367),G0tensor(70)])
  call ol_merge_tensors(G2tensor(171),[G2tensor(169),G1tensor(347),G1tensor(11),G0tensor(377),G0tensor(80)])
  call ol_merge_tensors(G2tensor(198),[G2tensor(196),G1tensor(387),G1tensor(131),G0tensor(417),G0tensor(120)])
  call ol_merge_tensors(G2tensor(204),[G2tensor(202),G1tensor(397),G1tensor(149),G0tensor(427),G0tensor(130)])
  call ol_merge_tensors(G2tensor(257),[G2tensor(229),G2tensor(222),G2tensor(220),G1tensor(538),G1tensor(432),G1tensor(180) &
    ,G1tensor(167),G0tensor(578),G0tensor(462),G0tensor(170),G0tensor(150)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(237),G2tensor(235),G1tensor(138),G1tensor(38),G1tensor(282),G1tensor(157) &
    ,G0tensor(312),G0tensor(15)])
  call ol_merge_tensors(G2tensor(407),[G2tensor(243),G2tensor(241),G1tensor(47),G1tensor(60),G1tensor(232),G1tensor(55) &
    ,G0tensor(257),G0tensor(245),G0tensor(25)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(259),G2tensor(252),G2tensor(250),G1tensor(543),G1tensor(482),G1tensor(220) &
    ,G1tensor(205),G0tensor(583),G0tensor(512),G0tensor(210),G0tensor(195)])
  call ol_merge_tensors(G2tensor(464),[G2tensor(264),G2tensor(262),G1tensor(122),G1tensor(36),G1tensor(307),G1tensor(44) &
    ,G0tensor(337),G0tensor(30)])
  call ol_merge_tensors(G2tensor(148),[G2tensor(270),G2tensor(268),G1tensor(156),G1tensor(162),G1tensor(227),G1tensor(68) &
    ,G0tensor(232),G0tensor(220),G0tensor(40)])
  call ol_merge_tensors(G3tensor(31),[G3tensor(29),G3tensor(2),G2tensor(279),G1tensor(63),G1tensor(503),G1tensor(272) &
    ,G1tensor(145),G0tensor(533),G0tensor(302),G0tensor(13)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(282),G1tensor(574),G1tensor(277),G1tensor(151),G0tensor(614),G0tensor(307) &
    ,G0tensor(14)])
  call ol_merge_tensors(G3tensor(32),[G3tensor(30),G3tensor(28),G3tensor(3),G2tensor(285),G1tensor(17),G1tensor(508),G1tensor(287) &
    ,G1tensor(49),G0tensor(543),G0tensor(317),G0tensor(23)])
  call ol_merge_tensors(G2tensor(317),[G2tensor(288),G1tensor(584),G1tensor(292),G1tensor(32),G0tensor(624),G0tensor(322) &
    ,G0tensor(24)])
  call ol_merge_tensors(G2tensor(158),[G2tensor(291),G1tensor(513),G1tensor(297),G1tensor(42),G0tensor(548),G0tensor(327) &
    ,G0tensor(28)])
  call ol_merge_tensors(G2tensor(425),[G2tensor(294),G1tensor(302),G1tensor(66),G1tensor(67),G0tensor(332),G0tensor(39) &
    ,G0tensor(29)])
  call ol_merge_tensors(G2tensor(167),[G2tensor(297),G1tensor(518),G1tensor(312),G1tensor(90),G0tensor(558),G0tensor(342) &
    ,G0tensor(38)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(300),G1tensor(317),G1tensor(92),G0tensor(347),G0tensor(49)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(303),G1tensor(327),G1tensor(116),G0tensor(357),G0tensor(59)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(49),G2tensor(327),G2tensor(306),G1tensor(332),G1tensor(111),G1tensor(88) &
    ,G1tensor(35),G1tensor(146),G0tensor(362),G0tensor(129),G0tensor(119),G0tensor(79),G0tensor(69)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(309),G1tensor(453),G1tensor(448),G1tensor(342),G1tensor(8),G0tensor(483) &
    ,G0tensor(478),G0tensor(372),G0tensor(78)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(312),G1tensor(352),G1tensor(21),G0tensor(382),G0tensor(89)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(315),G1tensor(357),G1tensor(41),G0tensor(387),G0tensor(99)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(28),G2tensor(336),G2tensor(318),G1tensor(362),G1tensor(323),G1tensor(141) &
    ,G1tensor(129),G1tensor(76),G1tensor(70),G0tensor(392),G0tensor(353),G0tensor(144),G0tensor(139),G0tensor(114) &
    ,G0tensor(109)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(321),G1tensor(372),G1tensor(358),G1tensor(71),G0tensor(402),G0tensor(388) &
    ,G0tensor(113)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(324),G1tensor(527),G1tensor(478),G1tensor(473),G1tensor(382),G1tensor(94) &
    ,G0tensor(567),G0tensor(508),G0tensor(503),G0tensor(412),G0tensor(118)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(330),G1tensor(498),G1tensor(493),G1tensor(392),G1tensor(107),G0tensor(528) &
    ,G0tensor(523),G0tensor(422),G0tensor(128)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(333),G1tensor(522),G1tensor(402),G1tensor(318),G1tensor(125),G0tensor(562) &
    ,G0tensor(432),G0tensor(348),G0tensor(138)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(339),G1tensor(412),G1tensor(328),G1tensor(136),G0tensor(442),G0tensor(358) &
    ,G0tensor(143)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(342),G1tensor(422),G1tensor(153),G0tensor(452),G0tensor(148)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(345),G1tensor(427),G1tensor(154),G0tensor(457),G0tensor(149)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(348),G1tensor(437),G1tensor(31),G0tensor(467),G0tensor(158)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(351),G1tensor(442),G1tensor(189),G1tensor(169),G0tensor(472),G0tensor(179) &
    ,G0tensor(159)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(354),G1tensor(447),G1tensor(178),G0tensor(477),G0tensor(168)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(357),G1tensor(452),G1tensor(179),G0tensor(482),G0tensor(169)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(360),G1tensor(457),G1tensor(188),G0tensor(487),G0tensor(178)])
  call ol_merge_tensors(G2tensor(233),[G2tensor(363),G1tensor(462),G1tensor(198),G0tensor(492),G0tensor(188)])
  call ol_merge_tensors(G2tensor(419),[G2tensor(366),G1tensor(467),G1tensor(214),G1tensor(199),G0tensor(497),G0tensor(204) &
    ,G0tensor(189)])
  call ol_merge_tensors(G2tensor(239),[G2tensor(369),G1tensor(472),G1tensor(278),G1tensor(273),G1tensor(203),G0tensor(502) &
    ,G0tensor(308),G0tensor(303),G0tensor(193)])
  call ol_merge_tensors(G2tensor(260),[G2tensor(372),G1tensor(477),G1tensor(204),G0tensor(507),G0tensor(194)])
  call ol_merge_tensors(G2tensor(401),[G2tensor(375),G1tensor(487),G1tensor(213),G0tensor(517),G0tensor(203)])
  call ol_merge_tensors(G2tensor(152),[G2tensor(378),G1tensor(492),G1tensor(293),G1tensor(288),G1tensor(218),G0tensor(522) &
    ,G0tensor(323),G0tensor(318),G0tensor(208)])
  call ol_merge_tensors(G2tensor(422),[G2tensor(381),G1tensor(497),G1tensor(219),G0tensor(527),G0tensor(209)])
  call ol_merge_tensors(G2tensor(359),[G2tensor(459),G2tensor(456),G2tensor(408),G1tensor(532),G1tensor(507),G1tensor(502) &
    ,G0tensor(572),G0tensor(542),G0tensor(532)])
  call ol_merge_tensors(G2tensor(450),[G2tensor(444),G2tensor(417),G1tensor(557),G1tensor(547),G1tensor(537),G0tensor(597) &
    ,G0tensor(587),G0tensor(577)])
  call ol_merge_tensors(G2tensor(477),[G2tensor(471),G2tensor(429),G1tensor(582),G1tensor(572),G1tensor(542),G0tensor(622) &
    ,G0tensor(612),G0tensor(582)])
  call ol_merge_tensors(G2tensor(365),[G2tensor(454),G2tensor(448),G1tensor(565),G1tensor(555),G0tensor(605),G0tensor(595)])
  call ol_merge_tensors(G2tensor(362),[G2tensor(451),G1tensor(560),G0tensor(600)])
  call ol_merge_tensors(G2tensor(380),[G2tensor(457),G1tensor(96),G1tensor(73),G1tensor(505),G0tensor(535)])
  call ol_merge_tensors(G2tensor(458),[G2tensor(460),G1tensor(98),G1tensor(133),G1tensor(510),G0tensor(555),G0tensor(545)])
  call ol_merge_tensors(G2tensor(455),[G2tensor(463),G1tensor(84),G1tensor(103),G1tensor(515),G0tensor(550)])
  call ol_merge_tensors(G2tensor(461),[G2tensor(466),G1tensor(108),G1tensor(163),G1tensor(520),G0tensor(560),G0tensor(540)])
  call ol_merge_tensors(G2tensor(221),[G2tensor(475),G2tensor(469),G1tensor(580),G1tensor(570),G0tensor(620),G0tensor(610)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(472),G1tensor(575),G1tensor(528),G0tensor(615),G0tensor(568)])
  call ol_merge_tensors(G2tensor(344),[G2tensor(478),G1tensor(585),G0tensor(625)])
  call ol_merge_tensors(G2tensor(440),[G1tensor(314),G1tensor(228),G0tensor(344),G0tensor(233),G0tensor(224)])
  call ol_merge_tensors(G2tensor(437),[G1tensor(309),G1tensor(304),G1tensor(229),G0tensor(339),G0tensor(334),G0tensor(234) &
    ,G0tensor(229)])
  call ol_merge_tensors(G2tensor(150),[G1tensor(289),G1tensor(233),G0tensor(319),G0tensor(258),G0tensor(249)])
  call ol_merge_tensors(G2tensor(146),[G1tensor(294),G1tensor(234),G0tensor(324),G0tensor(259),G0tensor(254)])
  call ol_merge_tensors(G3tensor(4),[G3tensor(1),G1tensor(393),G1tensor(383),G1tensor(343),G1tensor(333),G1tensor(242) &
    ,G1tensor(238),G0tensor(423),G0tensor(413),G0tensor(373),G0tensor(363),G0tensor(272),G0tensor(268)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(338),G1tensor(247),G1tensor(239),G0tensor(368),G0tensor(277),G0tensor(269)])
  call ol_merge_tensors(G2tensor(314),[G1tensor(248),G1tensor(243),G0tensor(278),G0tensor(273)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(264),G1tensor(253),G1tensor(244),G0tensor(294),G0tensor(283),G0tensor(274)])
  call ol_merge_tensors(G2tensor(305),[G2tensor(6),G1tensor(284),G1tensor(279),G1tensor(269),G1tensor(254),G1tensor(249) &
    ,G0tensor(314),G0tensor(309),G0tensor(299),G0tensor(284),G0tensor(279)])
  call ol_merge_tensors(G2tensor(410),[G2tensor(9),G1tensor(413),G1tensor(403),G1tensor(373),G1tensor(363),G1tensor(262) &
    ,G1tensor(258),G0tensor(443),G0tensor(433),G0tensor(403),G0tensor(393),G0tensor(292),G0tensor(288)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(439),G1tensor(368),G1tensor(267),G1tensor(259),G0tensor(469),G0tensor(398) &
    ,G0tensor(297),G0tensor(289)])
  call ol_merge_tensors(G2tensor(155),[G1tensor(283),G1tensor(274),G0tensor(313),G0tensor(304)])
  call ol_merge_tensors(G2tensor(173),[G1tensor(313),G1tensor(303),G1tensor(298),G0tensor(343),G0tensor(333),G0tensor(328)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(308),G1tensor(299),G0tensor(338),G0tensor(329)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(45),G1tensor(399),G1tensor(389),G1tensor(359),G1tensor(354),G1tensor(349) &
    ,G1tensor(339),G1tensor(334),G1tensor(329),G1tensor(324),G1tensor(319),G0tensor(429),G0tensor(419),G0tensor(389),G0tensor(384) &
    ,G0tensor(379),G0tensor(369),G0tensor(364),G0tensor(359),G0tensor(354),G0tensor(349)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(348),G1tensor(344),G0tensor(378),G0tensor(374)])
  call ol_merge_tensors(G2tensor(266),[G2tensor(81),G2tensor(69),G2tensor(61),G1tensor(499),G1tensor(484),G1tensor(479) &
    ,G1tensor(469),G1tensor(454),G1tensor(444),G1tensor(434),G1tensor(429),G1tensor(419),G1tensor(409),G1tensor(379),G1tensor(369) &
    ,G1tensor(364),G0tensor(529),G0tensor(514),G0tensor(509),G0tensor(499),G0tensor(484),G0tensor(474),G0tensor(464),G0tensor(459) &
    ,G0tensor(449),G0tensor(439),G0tensor(409),G0tensor(399),G0tensor(394)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(459),G1tensor(378),G1tensor(374),G0tensor(489),G0tensor(408),G0tensor(404)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(388),G1tensor(384),G0tensor(418),G0tensor(414)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(398),G1tensor(394),G0tensor(428),G0tensor(424)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(464),G1tensor(408),G1tensor(404),G0tensor(494),G0tensor(438),G0tensor(434)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(489),G1tensor(418),G1tensor(414),G0tensor(519),G0tensor(448),G0tensor(444)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(449),G1tensor(433),G1tensor(424),G0tensor(479),G0tensor(463),G0tensor(454)])
  call ol_merge_tensors(G2tensor(179),[G1tensor(458),G1tensor(443),G1tensor(438),G0tensor(488),G0tensor(473),G0tensor(468)])
  call ol_merge_tensors(G2tensor(413),[G1tensor(488),G1tensor(468),G1tensor(463),G0tensor(518),G0tensor(498),G0tensor(493)])
  call ol_merge_tensors(G2tensor(395),[G1tensor(494),G1tensor(483),G1tensor(474),G0tensor(524),G0tensor(513),G0tensor(504)])
  call ol_merge_tensors(G2tensor(284),[G1tensor(549),G1tensor(504),G0tensor(589),G0tensor(534)])
  call ol_merge_tensors(G2tensor(263),[G1tensor(559),G1tensor(509),G0tensor(599),G0tensor(544)])
  call ol_merge_tensors(G2tensor(176),[G1tensor(519),G1tensor(514),G0tensor(559),G0tensor(549)])
  call ol_merge_tensors(G2tensor(185),[G1tensor(523),G0tensor(563)])
  call ol_merge_tensors(G2tensor(230),[G1tensor(533),G0tensor(573)])
  call ol_merge_tensors(G2tensor(392),[G1tensor(539),G1tensor(534),G0tensor(579),G0tensor(574)])
  call ol_merge_tensors(G2tensor(290),[G1tensor(554),G0tensor(594)])
  call ol_merge_tensors(G2tensor(299),[G1tensor(564),G0tensor(604)])
  call ol_merge_tensors(G2tensor(326),[G1tensor(569),G0tensor(609)])
  call ol_merge_tensors(G2tensor(170),[G1tensor(579),G0tensor(619)])
  call ol_merge_tensors(G0tensor(237),[G0tensor(217)])
  call ol_merge_tensors(G3tensor(25),[G1tensor(52),G0tensor(538),G0tensor(222),G0tensor(218)])
  call ol_merge_tensors(G0tensor(227),[G0tensor(219)])
  call ol_merge_tensors(G0tensor(228),[G0tensor(223)])
  call ol_merge_tensors(G0tensor(238),[G0tensor(225)])
  call ol_merge_tensors(G0tensor(239),[G0tensor(230)])
  call ol_merge_tensors(G0tensor(262),[G0tensor(242)])
  call ol_merge_tensors(G0tensor(553),[G0tensor(247),G0tensor(243)])
  call ol_merge_tensors(G0tensor(252),[G0tensor(244)])
  call ol_merge_tensors(G0tensor(253),[G0tensor(248)])
  call ol_merge_tensors(G0tensor(263),[G0tensor(250)])
  call ol_merge_tensors(G0tensor(264),[G0tensor(255)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(12),G3tensor(8),G3tensor(6)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(15),G3tensor(10),G3tensor(9)])
  call ol_merge_tensors(G3tensor(26),[G1tensor(58),G1tensor(27)])
  call ol_merge_tensors(G3tensor(27),[G1tensor(39)])
  call TI_triangle_red(G2tensor(468),RedBasis(66),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(474),RedBasis(66),mass3set(:,2),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1,[nMZ], &
    G0tensor(41))
  call TI_triangle_red(G2tensor(40),RedBasis(61),mass3set(:,1),G0tensor(46),G0tensor(51),G0tensor(56),G0tensor(61),M2L1R1)
  call TI_triangle_red(G2tensor(48),RedBasis(61),mass3set(:,3),G0tensor(66),G0tensor(71),G0tensor(76),G0tensor(81),M2L1R1,[nMZ], &
    G0tensor(86))
  call TI_triangle_red(G2tensor(335),RedBasis(9),mass3set(:,1),G0tensor(91),G0tensor(96),G0tensor(101),G0tensor(106),M2L1R1)
  call TI_triangle_red(G2tensor(453),RedBasis(9),mass3set(:,2),G0tensor(111),G0tensor(116),G0tensor(121), &
    G0tensor(126),M2L1R1,[nMZ],G0tensor(131))
  call TI_triangle_red(G2tensor(24),RedBasis(57),mass3set(:,1),G0tensor(136),G0tensor(141),G0tensor(146),G0tensor(151),M2L1R1)
  call TI_triangle_red(G2tensor(29),RedBasis(57),mass3set(:,3),G0tensor(156),G0tensor(161),G0tensor(166), &
    G0tensor(171),M2L1R1,[nMZ],G0tensor(176))
  call TI_triangle_red(G2tensor(236),RedBasis(14),mass3set(:,4),G0tensor(181),G0tensor(186),G0tensor(191), &
    G0tensor(196),M2L1R1,[nMW],G0tensor(201))
  call TI_triangle_red(G2tensor(287),RedBasis(14),mass3set(:,5),G0tensor(206),G0tensor(211),G0tensor(216), &
    G0tensor(221),M2L1R1,[nMW],G0tensor(226))
  call TI_triangle_red(G2tensor(293),RedBasis(14),mass3set(:,6),G0tensor(231),G0tensor(236),G0tensor(241), &
    G0tensor(246),M2L1R1,[nMZ,nMW],G0tensor(251),G0tensor(256))
  call TI_triangle_red(G2tensor(296),RedBasis(14),mass3set(:,7),G0tensor(261),G0tensor(266),G0tensor(271), &
    G0tensor(276),M2L1R1,[nMW,nMZ],G0tensor(281),G0tensor(286))
  call TI_triangle_red(G2tensor(377),RedBasis(31),mass3set(:,8),G0tensor(291),G0tensor(296),G0tensor(301), &
    G0tensor(306),M2L1R1,[nMW],G0tensor(311))
  call TI_triangle_red(G2tensor(302),RedBasis(22),mass3set(:,5),G0tensor(316),G0tensor(321),G0tensor(326), &
    G0tensor(331),M2L1R1,[nMW],G0tensor(336))
  call TI_triangle_red(G2tensor(164),RedBasis(22),mass3set(:,4),G0tensor(341),G0tensor(346),G0tensor(351), &
    G0tensor(356),M2L1R1,[nMW],G0tensor(361))
  call TI_triangle_red(G2tensor(308),RedBasis(22),mass3set(:,7),G0tensor(366),G0tensor(371),G0tensor(376), &
    G0tensor(381),M2L1R1,[nMW,nMZ],G0tensor(386),G0tensor(391))
  call TI_triangle_red(G2tensor(311),RedBasis(22),mass3set(:,6),G0tensor(396),G0tensor(401),G0tensor(406), &
    G0tensor(411),M2L1R1,[nMZ,nMW],G0tensor(416),G0tensor(421))
  call TI_triangle_red(G2tensor(21),RedBasis(17),mass3set(:,1),G0tensor(426),G0tensor(431),G0tensor(436),G0tensor(441),M2L1R1)
  call TI_triangle_red(G2tensor(470),RedBasis(1),mass3set(:,1),G0tensor(446),G0tensor(451),G0tensor(456),G0tensor(461),M2L1R1)
  call TI_triangle_red(G2tensor(18),RedBasis(31),mass3set(:,1),G0tensor(466),G0tensor(471),G0tensor(476),G0tensor(481),M2L1R1)
  call TI_triangle_red(G2tensor(87),RedBasis(22),mass3set(:,1),G0tensor(486),G0tensor(491),G0tensor(496),G0tensor(501),M2L1R1)
  call TI_triangle_red(G2tensor(242),RedBasis(12),mass3set(:,1),G0tensor(506),G0tensor(511),G0tensor(516),G0tensor(521),M2L1R1)
  call TI_triangle_red(G2tensor(272),RedBasis(2),mass3set(:,1),G0tensor(526),G0tensor(531),G0tensor(536),G0tensor(541),M2L1R1)
  call TI_triangle_red(G3tensor(13),RedBasis(10),mass3set(:,1),G0tensor(546),G0tensor(551),G0tensor(556),G0tensor(561),M2L1R1)
  call TI_triangle_red(G2tensor(142),RedBasis(12),mass3set(:,3),G0tensor(566),G0tensor(571),G0tensor(576), &
    G0tensor(581),M2L1R1,[nMZ],G0tensor(586))
  call TI_triangle_red(G2tensor(140),RedBasis(2),mass3set(:,3),G0tensor(591),G0tensor(596),G0tensor(601), &
    G0tensor(606),M2L1R1,[nMZ],G0tensor(611))
  call TI_triangle_red(G2tensor(278),RedBasis(16),mass3set(:,1),G0tensor(616),G0tensor(621),G0tensor(607),G0tensor(52),M2L1R1)
  call TI_triangle_red(G2tensor(446),RedBasis(15),mass3set(:,1),G0tensor(47),G0tensor(617),G0tensor(62),G0tensor(57),M2L1R1)
  call TI_triangle_red(G2tensor(281),RedBasis(17),mass3set(:,9),G0tensor(107),G0tensor(88),G0tensor(72),G0tensor(67),M2L1R1,[nMZ], &
    G0tensor(112))
  call TI_triangle_red(G2tensor(428),RedBasis(15),mass3set(:,3),G0tensor(98),G0tensor(82),G0tensor(77),G0tensor(592),M2L1R1,[nMZ], &
    G0tensor(298))
  call TI_triangle_red(G2tensor(245),RedBasis(21),mass3set(:,1),G0tensor(293),G0tensor(92),G0tensor(87),G0tensor(602),M2L1R1)
  call TI_triangle_red(G2tensor(248),RedBasis(20),mass3set(:,1),G0tensor(102),G0tensor(97),G0tensor(137),G0tensor(122),M2L1R1)
  call TI_triangle_red(G2tensor(398),RedBasis(21),mass3set(:,3),G0tensor(117),G0tensor(48),G0tensor(142), &
    G0tensor(132),M2L1R1,[nMZ],G0tensor(127))
  call TI_triangle_red(G2tensor(254),RedBasis(20),mass3set(:,3),G0tensor(58),G0tensor(588),G0tensor(152), &
    G0tensor(147),M2L1R1,[nMZ],G0tensor(593))
  call TI_triangle_red(G2tensor(275),RedBasis(26),mass3set(:,1),G0tensor(547),G0tensor(162),G0tensor(157),G0tensor(598),M2L1R1)
  call TI_triangle_red(G2tensor(141),RedBasis(26),mass3set(:,9),G0tensor(172),G0tensor(167),G0tensor(603), &
    G0tensor(557),M2L1R1,[nMZ],G0tensor(182))
  call TI_triangle_red(G2tensor(452),RedBasis(1),mass3set(:,3),G0tensor(177),G0tensor(22),G0tensor(17),G0tensor(12),M2L1R1,[nMZ], &
    G0tensor(608))
  call TI_triangle_red(G2tensor(182),RedBasis(30),mass3set(:,10),G0tensor(187),G0tensor(32),G0tensor(27), &
    G0tensor(613),M2L1R1,[nMW],G0tensor(197))
  call TI_triangle_red(G2tensor(188),RedBasis(29),mass3set(:,1),G0tensor(192),G0tensor(618),G0tensor(202),G0tensor(42),M2L1R1)
  call TI_triangle_red(G2tensor(443),RedBasis(15),mass3set(:,4),G0tensor(37),G0tensor(623),G0tensor(212), &
    G0tensor(207),M2L1R1,[nMW],G0tensor(290))
  call TI_triangle_red(G2tensor(194),RedBasis(30),mass3set(:,4),G0tensor(282),G0tensor(270),G0tensor(73), &
    G0tensor(440),M2L1R1,[nMW],G0tensor(420))
  call TI_triangle_red(G2tensor(431),RedBasis(29),mass3set(:,4),G0tensor(340),G0tensor(285),G0tensor(125), &
    G0tensor(35),M2L1R1,[nMW],G0tensor(10))
  call TI_triangle_red(G2tensor(200),RedBasis(30),mass3set(:,11),G0tensor(5),G0tensor(458),G0tensor(453), &
    G0tensor(267),M2L1R1,[nMW,nMZ],G0tensor(68),G0tensor(2))
  call TI_triangle_red(G2tensor(434),RedBasis(29),mass3set(:,3),G0tensor(383),G0tensor(287),G0tensor(108), &
    G0tensor(7),M2L1R1,[nMZ],G0tensor(437))
  call TI_triangle_red(G2tensor(206),RedBasis(30),mass3set(:,12),G0tensor(190),G0tensor(140),G0tensor(53), &
    G0tensor(350),M2L1R1,[nMZ,nMW],G0tensor(280),G0tensor(54))
  call TI_triangle_red(G2tensor(404),RedBasis(4),mass3set(:,13),G0tensor(4),G0tensor(585),G0tensor(580), &
    G0tensor(355),M2L1R1,[nMW],G0tensor(105))
  call TI_triangle_red(G2tensor(269),RedBasis(2),mass3set(:,4),G0tensor(95),G0tensor(65),G0tensor(55),G0tensor(447),M2L1R1,[nMW], &
    G0tensor(205))
  call TI_triangle_red(G2tensor(467),RedBasis(1),mass3set(:,4),G0tensor(145),G0tensor(63),G0tensor(360),G0tensor(64),M2L1R1,[nMW], &
    G0tensor(395))
  call TI_triangle_red(G2tensor(212),RedBasis(8),mass3set(:,4),G0tensor(365),G0tensor(134),G0tensor(124), &
    G0tensor(84),M2L1R1,[nMW],G0tensor(74))
  call TI_triangle_red(G2tensor(218),RedBasis(7),mass3set(:,4),G0tensor(570),G0tensor(565),G0tensor(400), &
    G0tensor(370),M2L1R1,[nMW],G0tensor(165))
  call TI_triangle_red(G2tensor(383),RedBasis(8),mass3set(:,10),G0tensor(75),G0tensor(405),G0tensor(375), &
    G0tensor(83),M2L1R1,[nMW],G0tensor(410))
  call TI_triangle_red(G2tensor(224),RedBasis(7),mass3set(:,1),G0tensor(380),G0tensor(185),G0tensor(85),G0tensor(397),M2L1R1)
  call TI_triangle_red(G2tensor(386),RedBasis(8),mass3set(:,12),G0tensor(160),G0tensor(110),G0tensor(93), &
    G0tensor(569),M2L1R1,[nMZ,nMW],G0tensor(385),G0tensor(94))
  call TI_triangle_red(G2tensor(227),RedBasis(8),mass3set(:,11),G0tensor(407),G0tensor(180),G0tensor(115), &
    G0tensor(103),M2L1R1,[nMW,nMZ],G0tensor(390),G0tensor(104))
  call TI_triangle_red(G2tensor(389),RedBasis(7),mass3set(:,3),G0tensor(435),G0tensor(415),G0tensor(123), &
    G0tensor(445),M2L1R1,[nMZ],G0tensor(425))
  call TI_triangle_red(G2tensor(323),RedBasis(4),mass3set(:,1),G0tensor(133),G0tensor(450),G0tensor(430),G0tensor(240),M2L1R1)
  call TI_triangle_red(G2tensor(320),RedBasis(8),mass3set(:,1),G0tensor(235),G0tensor(135),G0tensor(45),G0tensor(455),M2L1R1)
  call TI_triangle_red(G2tensor(181),RedBasis(55),mass3set(:,1),G0tensor(153),G0tensor(564),G0tensor(460),G0tensor(154),M2L1R1)
  call TI_triangle_red(G2tensor(165),RedBasis(58),mass3set(:,1),G0tensor(575),G0tensor(465),G0tensor(175),G0tensor(155),M2L1R1)
  call TI_triangle_red(G2tensor(171),RedBasis(58),mass3set(:,3),G0tensor(470),G0tensor(163),G0tensor(475), &
    G0tensor(184),M2L1R1,[nMZ],G0tensor(164))
  call TI_triangle_red(G2tensor(198),RedBasis(62),mass3set(:,1),G0tensor(480),G0tensor(173),G0tensor(485),G0tensor(174),M2L1R1)
  call TI_triangle_red(G2tensor(204),RedBasis(62),mass3set(:,3),G0tensor(490),G0tensor(183),G0tensor(320), &
    G0tensor(305),M2L1R1,[nMZ],G0tensor(18))
  call TI_triangle_red(G2tensor(257),RedBasis(21),mass3set(:,4),G0tensor(584),G0tensor(325),G0tensor(310), &
    G0tensor(19),M2L1R1,[nMW],G0tensor(515))
  call TI_triangle_red(G2tensor(144),RedBasis(17),mass3set(:,4),G0tensor(315),G0tensor(265),G0tensor(260), &
    G0tensor(215),M2L1R1,[nMW],G0tensor(200))
  call TI_triangle_red(G2tensor(407),RedBasis(17),mass3set(:,6),G0tensor(20),G0tensor(495),G0tensor(330), &
    G0tensor(33),M2L1R1,[nMZ,nMW],G0tensor(500),G0tensor(335))
  call TI_triangle_red(G2tensor(1),RedBasis(12),mass3set(:,4),G0tensor(44),G0tensor(34),G0tensor(505),G0tensor(198),M2L1R1,[nMW], &
    G0tensor(510))
  call TI_triangle_red(G2tensor(464),RedBasis(17),mass3set(:,5),G0tensor(300),G0tensor(199),G0tensor(9), &
    G0tensor(520),M2L1R1,[nMW],G0tensor(345))
  call TI_triangle_red(G2tensor(148),RedBasis(17),mass3set(:,7),G0tensor(43),G0tensor(525),G0tensor(213), &
    G0tensor(530),M2L1R1,[nMW,nMZ],G0tensor(214),G0tensor(590))
  call TI_triangle_red(G3tensor(31),RedBasis(19),mass3set(:,13),G0tensor(275),G0tensor(3),G0tensor(295),G0tensor(8),M2L1R1,[nMW], &
    G0tensor(352))
  call TI_triangle_red(G2tensor(99),RedBasis(18),mass3set(:,4),G0tensor(100),G0tensor(90),G0tensor(60),G0tensor(50),M2L1R1,[nMW], &
    G0tensor(367))
  call TI_triangle_red(G3tensor(32),RedBasis(19),mass3set(:,14),G0tensor(70),G0tensor(377),G0tensor(80), &
    G0tensor(417),M2L1R1,[nMZ,nMW],G0tensor(120),G0tensor(427))
  call TI_triangle_red(G2tensor(317),RedBasis(18),mass3set(:,6),G0tensor(130),G0tensor(578),G0tensor(462), &
    G0tensor(170),M2L1R1,[nMZ,nMW],G0tensor(150),G0tensor(312))
  call TI_triangle_red(G2tensor(158),RedBasis(25),mass3set(:,8),G0tensor(15),G0tensor(257),G0tensor(245), &
    G0tensor(25),M2L1R1,[nMW],G0tensor(583))
  call TI_triangle_red(G2tensor(425),RedBasis(24),mass3set(:,8),G0tensor(512),G0tensor(210),G0tensor(195), &
    G0tensor(337),M2L1R1,[nMW],G0tensor(30))
  call TI_triangle_red(G2tensor(167),RedBasis(25),mass3set(:,15),G0tensor(232),G0tensor(220),G0tensor(40), &
    G0tensor(533),M2L1R1,[nMW,nMZ],G0tensor(302),G0tensor(13))
  call TI_triangle_red(G2tensor(25),RedBasis(56),mass3set(:,1),G0tensor(614),G0tensor(307),G0tensor(14),G0tensor(543),M2L1R1)
  call TI_triangle_red(G2tensor(32),RedBasis(56),mass3set(:,3),G0tensor(317),G0tensor(23),G0tensor(624), &
    G0tensor(322),M2L1R1,[nMZ],G0tensor(24))
  call TI_triangle_red(G2tensor(65),RedBasis(59),mass3set(:,1),G0tensor(548),G0tensor(327),G0tensor(28),G0tensor(332),M2L1R1)
  call TI_triangle_red(G2tensor(36),RedBasis(31),mass3set(:,9),G0tensor(39),G0tensor(29),G0tensor(558),G0tensor(342),M2L1R1,[nMZ], &
    G0tensor(38))
  call TI_triangle_red(G2tensor(41),RedBasis(60),mass3set(:,1),G0tensor(347),G0tensor(49),G0tensor(357),G0tensor(59),M2L1R1)
  call TI_triangle_red(G2tensor(52),RedBasis(60),mass3set(:,3),G0tensor(362),G0tensor(129),G0tensor(119), &
    G0tensor(79),M2L1R1,[nMZ],G0tensor(69))
  call TI_triangle_red(G2tensor(44),RedBasis(13),mass3set(:,1),G0tensor(483),G0tensor(478),G0tensor(372),G0tensor(78),M2L1R1)
  call TI_triangle_red(G2tensor(53),RedBasis(22),mass3set(:,9),G0tensor(382),G0tensor(89),G0tensor(387),G0tensor(99),M2L1R1,[nMZ], &
    G0tensor(392))
  call TI_triangle_red(G2tensor(17),RedBasis(32),mass3set(:,1),G0tensor(353),G0tensor(144),G0tensor(139),G0tensor(114),M2L1R1)
  call TI_triangle_red(G2tensor(60),RedBasis(32),mass3set(:,9),G0tensor(109),G0tensor(402),G0tensor(388), &
    G0tensor(113),M2L1R1,[nMZ],G0tensor(567))
  call TI_triangle_red(G2tensor(11),RedBasis(14),mass3set(:,1),G0tensor(508),G0tensor(503),G0tensor(412),G0tensor(118),M2L1R1)
  call TI_triangle_red(G2tensor(72),RedBasis(14),mass3set(:,9),G0tensor(528),G0tensor(523),G0tensor(422), &
    G0tensor(128),M2L1R1,[nMZ],G0tensor(562))
  call TI_triangle_red(G2tensor(76),RedBasis(64),mass3set(:,10),G0tensor(432),G0tensor(348),G0tensor(138), &
    G0tensor(442),M2L1R1,[nMW],G0tensor(358))
  call TI_triangle_red(G2tensor(77),RedBasis(63),mass3set(:,1),G0tensor(143),G0tensor(452),G0tensor(148),G0tensor(457),M2L1R1)
  call TI_triangle_red(G2tensor(86),RedBasis(64),mass3set(:,4),G0tensor(149),G0tensor(467),G0tensor(158), &
    G0tensor(472),M2L1R1,[nMW],G0tensor(179))
  call TI_triangle_red(G2tensor(90),RedBasis(63),mass3set(:,4),G0tensor(159),G0tensor(477),G0tensor(168), &
    G0tensor(482),M2L1R1,[nMW],G0tensor(169))
  call TI_triangle_red(G2tensor(91),RedBasis(64),mass3set(:,11),G0tensor(487),G0tensor(178),G0tensor(492), &
    G0tensor(188),M2L1R1,[nMW,nMZ],G0tensor(497),G0tensor(204))
  call TI_triangle_red(G2tensor(94),RedBasis(63),mass3set(:,3),G0tensor(189),G0tensor(502),G0tensor(308), &
    G0tensor(303),M2L1R1,[nMZ],G0tensor(193))
  call TI_triangle_red(G2tensor(98),RedBasis(64),mass3set(:,12),G0tensor(507),G0tensor(194),G0tensor(517), &
    G0tensor(203),M2L1R1,[nMZ,nMW],G0tensor(522),G0tensor(323))
  call TI_triangle_red(G2tensor(233),RedBasis(6),mass3set(:,4),G0tensor(318),G0tensor(208),G0tensor(527), &
    G0tensor(209),M2L1R1,[nMW],G0tensor(572))
  call TI_triangle_red(G2tensor(419),RedBasis(65),mass3set(:,4),G0tensor(542),G0tensor(532),G0tensor(597), &
    G0tensor(587),M2L1R1,[nMW],G0tensor(577))
  call TI_triangle_red(G2tensor(239),RedBasis(6),mass3set(:,10),G0tensor(622),G0tensor(612),G0tensor(582), &
    G0tensor(605),M2L1R1,[nMW],G0tensor(595))
  call TI_triangle_red(G2tensor(260),RedBasis(65),mass3set(:,1),G0tensor(600),G0tensor(535),G0tensor(555),G0tensor(545),M2L1R1)
  call TI_triangle_red(G2tensor(401),RedBasis(6),mass3set(:,12),G0tensor(550),G0tensor(560),G0tensor(540), &
    G0tensor(620),M2L1R1,[nMZ,nMW],G0tensor(610),G0tensor(615))
  call TI_triangle_red(G2tensor(152),RedBasis(6),mass3set(:,11),G0tensor(568),G0tensor(625),G0tensor(344), &
    G0tensor(233),M2L1R1,[nMW,nMZ],G0tensor(224),G0tensor(339))
  call TI_triangle_red(G2tensor(422),RedBasis(65),mass3set(:,3),G0tensor(334),G0tensor(234),G0tensor(229), &
    G0tensor(319),M2L1R1,[nMZ],G0tensor(258))
  call TI_triangle_red(G2tensor(359),RedBasis(32),mass3set(:,8),G0tensor(249),G0tensor(324),G0tensor(259), &
    G0tensor(254),M2L1R1,[nMW],G0tensor(423))
  call TI_triangle_red(G2tensor(450),RedBasis(9),mass3set(:,5),G0tensor(413),G0tensor(373),G0tensor(363), &
    G0tensor(272),M2L1R1,[nMW],G0tensor(268))
  call TI_triangle_red(G2tensor(477),RedBasis(66),mass3set(:,5),G0tensor(368),G0tensor(277),G0tensor(269), &
    G0tensor(278),M2L1R1,[nMW],G0tensor(273))
  call TI_triangle_red(G2tensor(365),RedBasis(4),mass3set(:,5),G0tensor(294),G0tensor(283),G0tensor(274), &
    G0tensor(314),M2L1R1,[nMW],G0tensor(309))
  call TI_triangle_red(G2tensor(362),RedBasis(4),mass3set(:,2),G0tensor(299),G0tensor(284),G0tensor(279), &
    G0tensor(443),M2L1R1,[nMZ],G0tensor(433))
  call TI_triangle_red(G2tensor(380),RedBasis(26),mass3set(:,4),G0tensor(403),G0tensor(393),G0tensor(292), &
    G0tensor(288),M2L1R1,[nMW],G0tensor(469))
  call TI_triangle_red(G2tensor(458),RedBasis(26),mass3set(:,6),G0tensor(398),G0tensor(297),G0tensor(289), &
    G0tensor(313),M2L1R1,[nMZ,nMW],G0tensor(304),G0tensor(343))
  call TI_triangle_red(G2tensor(455),RedBasis(26),mass3set(:,5),G0tensor(333),G0tensor(328),G0tensor(338), &
    G0tensor(329),M2L1R1,[nMW],G0tensor(429))
  call TI_triangle_red(G2tensor(461),RedBasis(26),mass3set(:,7),G0tensor(419),G0tensor(389),G0tensor(384), &
    G0tensor(379),M2L1R1,[nMW,nMZ],G0tensor(369),G0tensor(364))
  call TI_triangle_red(G2tensor(221),RedBasis(54),mass3set(:,5),G0tensor(359),G0tensor(354),G0tensor(349), &
    G0tensor(378),M2L1R1,[nMW],G0tensor(374))
  call TI_triangle_red(G2tensor(191),RedBasis(54),mass3set(:,1),G0tensor(529),G0tensor(514),G0tensor(509),G0tensor(499),M2L1R1)
  call TI_triangle_red(G2tensor(344),RedBasis(54),mass3set(:,2),G0tensor(484),G0tensor(474),G0tensor(464), &
    G0tensor(459),M2L1R1,[nMZ],G0tensor(449))
  call TI_triangle_red(G2tensor(440),RedBasis(5),mass3set(:,12),G0tensor(439),G0tensor(409),G0tensor(399), &
    G0tensor(394),M2L1R1,[nMZ,nMW],G0tensor(489),G0tensor(408))
  call TI_triangle_red(G2tensor(437),RedBasis(3),mass3set(:,4),G0tensor(404),G0tensor(418),G0tensor(414), &
    G0tensor(428),M2L1R1,[nMW],G0tensor(424))
  call TI_triangle_red(G2tensor(150),RedBasis(5),mass3set(:,11),G0tensor(494),G0tensor(438),G0tensor(434), &
    G0tensor(519),M2L1R1,[nMW,nMZ],G0tensor(448),G0tensor(444))
  call TI_triangle_red(G2tensor(146),RedBasis(3),mass3set(:,3),G0tensor(479),G0tensor(463),G0tensor(454), &
    G0tensor(488),M2L1R1,[nMZ],G0tensor(473))
  call TI_triangle_red(G3tensor(4),RedBasis(19),mass3set(:,1),G0tensor(468),G0tensor(518),G0tensor(498),G0tensor(493),M2L1R1)
  call TI_triangle_red(G2tensor(8),RedBasis(18),mass3set(:,1),G0tensor(524),G0tensor(513),G0tensor(504),G0tensor(589),M2L1R1)
  call TI_triangle_red(G2tensor(314),RedBasis(6),mass3set(:,1),G0tensor(534),G0tensor(599),G0tensor(544),G0tensor(559),M2L1R1)
  call TI_triangle_red(G2tensor(4),RedBasis(5),mass3set(:,1),G0tensor(549),G0tensor(563),G0tensor(573),G0tensor(579),M2L1R1)
  call TI_triangle_red(G2tensor(305),RedBasis(3),mass3set(:,1),G0tensor(574),G0tensor(594),G0tensor(604),G0tensor(609),M2L1R1)
  call TI_triangle_red(G2tensor(410),RedBasis(25),mass3set(:,1),G0tensor(619),G0tensor(217),G0tensor(538),G0tensor(222),M2L1R1)
  call TI_triangle_red(G2tensor(12),RedBasis(24),mass3set(:,1),G0tensor(218),G0tensor(219),G0tensor(223),G0tensor(225),M2L1R1)
  call TI_triangle_red(G2tensor(155),RedBasis(5),mass3set(:,10),G0tensor(230),G0tensor(242),G0tensor(247), &
    G0tensor(243),M2L1R1,[nMW],G0tensor(244))
  call TI_triangle_red(G2tensor(173),RedBasis(9),mass3set(:,13),G0tensor(248),G0tensor(250),G0tensor(255), &
    G0tensor(626),M2L1R1,[nMW],G0tensor(627))
  call TI_triangle_red(G2tensor(161),RedBasis(5),mass3set(:,4),G0tensor(628),G0tensor(629),G0tensor(630), &
    G0tensor(631),M2L1R1,[nMW],G0tensor(632))
  call TI_triangle_red(G2tensor(33),RedBasis(11),mass3set(:,1),G0tensor(633),G0tensor(634),G0tensor(635),G0tensor(636),M2L1R1)
  call TI_triangle_red(G2tensor(37),RedBasis(18),mass3set(:,9),G0tensor(637),G0tensor(638),G0tensor(639), &
    G0tensor(640),M2L1R1,[nMZ],G0tensor(641))
  call TI_triangle_red(G2tensor(266),RedBasis(23),mass3set(:,1),G0tensor(642),G0tensor(643),G0tensor(644),G0tensor(645),M2L1R1)
  call TI_triangle_red(G2tensor(56),RedBasis(24),mass3set(:,9),G0tensor(646),G0tensor(647),G0tensor(648), &
    G0tensor(649),M2L1R1,[nMZ],G0tensor(650))
  call TI_triangle_red(G2tensor(57),RedBasis(27),mass3set(:,1),G0tensor(651),G0tensor(652),G0tensor(653),G0tensor(654),M2L1R1)
  call TI_triangle_red(G2tensor(64),RedBasis(27),mass3set(:,9),G0tensor(655),G0tensor(656),G0tensor(657), &
    G0tensor(658),M2L1R1,[nMZ],G0tensor(659))
  call TI_triangle_red(G2tensor(68),RedBasis(28),mass3set(:,1),G0tensor(660),G0tensor(661),G0tensor(662),G0tensor(663),M2L1R1)
  call TI_triangle_red(G2tensor(73),RedBasis(28),mass3set(:,9),G0tensor(664),G0tensor(665),G0tensor(666), &
    G0tensor(667),M2L1R1,[nMZ],G0tensor(668))
  call TI_triangle_red(G2tensor(80),RedBasis(24),mass3set(:,10),G0tensor(669),G0tensor(670),G0tensor(671), &
    G0tensor(672),M2L1R1,[nMW],G0tensor(673))
  call TI_triangle_red(G2tensor(179),RedBasis(31),mass3set(:,10),G0tensor(674),G0tensor(675),G0tensor(676), &
    G0tensor(677),M2L1R1,[nMW],G0tensor(678))
  call TI_triangle_red(G2tensor(413),RedBasis(32),mass3set(:,10),G0tensor(679),G0tensor(680),G0tensor(681), &
    G0tensor(682),M2L1R1,[nMW],G0tensor(683))
  call TI_triangle_red(G2tensor(395),RedBasis(28),mass3set(:,10),G0tensor(684),G0tensor(685),G0tensor(686), &
    G0tensor(687),M2L1R1,[nMW],G0tensor(688))
  call TI_triangle_red(G2tensor(284),RedBasis(27),mass3set(:,4),G0tensor(689),G0tensor(690),G0tensor(691), &
    G0tensor(692),M2L1R1,[nMW],G0tensor(693))
  call TI_triangle_red(G2tensor(263),RedBasis(27),mass3set(:,6),G0tensor(694),G0tensor(695),G0tensor(696), &
    G0tensor(697),M2L1R1,[nMZ,nMW],G0tensor(698),G0tensor(699))
  call TI_triangle_red(G2tensor(176),RedBasis(28),mass3set(:,8),G0tensor(700),G0tensor(701),G0tensor(702), &
    G0tensor(703),M2L1R1,[nMW],G0tensor(704))
  call TI_triangle_red(G2tensor(185),RedBasis(30),mass3set(:,1),G0tensor(705),G0tensor(706),G0tensor(707),G0tensor(708),M2L1R1)
  call TI_triangle_red(G2tensor(230),RedBasis(54),mass3set(:,13),G0tensor(709),G0tensor(710),G0tensor(711), &
    G0tensor(712),M2L1R1,[nMW],G0tensor(713))
  call TI_triangle_red(G2tensor(392),RedBasis(20),mass3set(:,4),G0tensor(714),G0tensor(715),G0tensor(716), &
    G0tensor(717),M2L1R1,[nMW],G0tensor(718))
  call TI_triangle_red(G2tensor(290),RedBasis(27),mass3set(:,5),G0tensor(719),G0tensor(720),G0tensor(721), &
    G0tensor(722),M2L1R1,[nMW],G0tensor(723))
  call TI_triangle_red(G2tensor(299),RedBasis(27),mass3set(:,7),G0tensor(724),G0tensor(725),G0tensor(726), &
    G0tensor(727),M2L1R1,[nMW,nMZ],G0tensor(728),G0tensor(729))
  call TI_triangle_red(G2tensor(326),RedBasis(18),mass3set(:,5),G0tensor(730),G0tensor(731),G0tensor(732), &
    G0tensor(733),M2L1R1,[nMW],G0tensor(734))
  call TI_triangle_red(G2tensor(170),RedBasis(18),mass3set(:,7),G0tensor(735),G0tensor(736),G0tensor(737), &
    G0tensor(738),M2L1R1,[nMW,nMZ],G0tensor(739),G0tensor(740))
  call TI_triangle_red(G3tensor(25),RedBasis(19),mass3set(:,16),G0tensor(741),G0tensor(742),G0tensor(743), &
    G0tensor(744),M2L1R1,[nMW,nMZ,nMH],G0tensor(745),G0tensor(746),G0tensor(747))
  call TI_triangle_red(G3tensor(14),RedBasis(10),mass3set(:,17),G0tensor(748),G0tensor(749),G0tensor(750), &
    G0tensor(751),M2L1R1,[nMT],G0tensor(752))
  call TI_triangle_red(G3tensor(16),RedBasis(10),mass3set(:,18),G0tensor(753),G0tensor(754),G0tensor(755), &
    G0tensor(756),M2L1R1,[nMB],G0tensor(757))
  call TI_triangle_red(G3tensor(17),RedBasis(19),mass3set(:,19),G0tensor(758),G0tensor(759),G0tensor(760), &
    G0tensor(761),M2L1R1,[nME],G0tensor(762))
  call TI_triangle_red(G3tensor(18),RedBasis(19),mass3set(:,20),G0tensor(763),G0tensor(764),G0tensor(765), &
    G0tensor(766),M2L1R1,[nMM],G0tensor(767))
  call TI_triangle_red(G3tensor(19),RedBasis(19),mass3set(:,21),G0tensor(768),G0tensor(769),G0tensor(770), &
    G0tensor(771),M2L1R1,[nML],G0tensor(772))
  call TI_triangle_red(G3tensor(20),RedBasis(19),mass3set(:,22),G0tensor(773),G0tensor(774),G0tensor(775), &
    G0tensor(776),M2L1R1,[nME],G0tensor(777))
  call TI_triangle_red(G3tensor(21),RedBasis(19),mass3set(:,23),G0tensor(778),G0tensor(779),G0tensor(780), &
    G0tensor(781),M2L1R1,[nMM],G0tensor(782))
  call TI_triangle_red(G3tensor(22),RedBasis(19),mass3set(:,24),G0tensor(783),G0tensor(784),G0tensor(785), &
    G0tensor(786),M2L1R1,[nML],G0tensor(787))
  call TI_triangle_red(G3tensor(23),RedBasis(19),mass3set(:,25),G0tensor(788),G0tensor(789),G0tensor(790), &
    G0tensor(791),M2L1R1,[nMB,nMT],G0tensor(792),G0tensor(793))
  call TI_triangle_red(G3tensor(24),RedBasis(19),mass3set(:,26),G0tensor(794),G0tensor(795),G0tensor(796), &
    G0tensor(797),M2L1R1,[nMT,nMB],G0tensor(798),G0tensor(799))
  call TI_triangle_red(G3tensor(26),RedBasis(19),mass3set(:,27),G0tensor(800),G0tensor(801),G0tensor(802), &
    G0tensor(803),M2L1R1,[nMW,nMH,nMZ],G0tensor(804),G0tensor(805),G0tensor(806))
  call TI_triangle_red(G3tensor(27),RedBasis(19),mass3set(:,28),G0tensor(807),G0tensor(808),G0tensor(809), &
    G0tensor(810),M2L1R1,[nMH,nMW],G0tensor(811),G0tensor(812))
  call ol_merge_tensors(T0sum(126),[G0tensor(1)])
  call ol_merge_tensors(T0sum(127),[G0tensor(21)])
  call ol_merge_tensors(T0sum(128),[G0tensor(46)])
  call ol_merge_tensors(T0sum(129),[G0tensor(66)])
  call ol_merge_tensors(T0sum(130),[G0tensor(91)])
  call ol_merge_tensors(T0sum(131),[G0tensor(111)])
  call ol_merge_tensors(T0sum(132),[G0tensor(136)])
  call ol_merge_tensors(T0sum(133),[G0tensor(156)])
  call ol_merge_tensors(T0sum(134),[G0tensor(181)])
  call ol_merge_tensors(T0sum(135),[G0tensor(206)])
  call ol_merge_tensors(T0sum(136),[G0tensor(231)])
  call ol_merge_tensors(T0sum(137),[G0tensor(261)])
  call ol_merge_tensors(T0sum(138),[G0tensor(291)])
  call ol_merge_tensors(T0sum(139),[G0tensor(316)])
  call ol_merge_tensors(T0sum(140),[G0tensor(341)])
  call ol_merge_tensors(T0sum(141),[G0tensor(366)])
  call ol_merge_tensors(T0sum(142),[G0tensor(396)])
  call ol_merge_tensors(T0sum(143),[G0tensor(426)])
  call ol_merge_tensors(T0sum(144),[G0tensor(446)])
  call ol_merge_tensors(T0sum(145),[G0tensor(466)])
  call ol_merge_tensors(T0sum(146),[G0tensor(486)])
  call ol_merge_tensors(T0sum(147),[G0tensor(506)])
  call ol_merge_tensors(T0sum(148),[G0tensor(526)])
  call ol_merge_tensors(T0sum(149),[G0tensor(546)])
  call ol_merge_tensors(T0sum(150),[G0tensor(566)])
  call ol_merge_tensors(T0sum(151),[G0tensor(591)])
  call ol_merge_tensors(T0sum(152),[G0tensor(616)])
  call ol_merge_tensors(T0sum(153),[G0tensor(47)])
  call ol_merge_tensors(T0sum(154),[G0tensor(107)])
  call ol_merge_tensors(T0sum(155),[G0tensor(98)])
  call ol_merge_tensors(T0sum(156),[G0tensor(293)])
  call ol_merge_tensors(T0sum(157),[G0tensor(102)])
  call ol_merge_tensors(T0sum(158),[G0tensor(117)])
  call ol_merge_tensors(T0sum(159),[G0tensor(58)])
  call ol_merge_tensors(T0sum(160),[G0tensor(547)])
  call ol_merge_tensors(T0sum(161),[G0tensor(172)])
  call ol_merge_tensors(T0sum(162),[G0tensor(177)])
  call ol_merge_tensors(T0sum(163),[G0tensor(187)])
  call ol_merge_tensors(T0sum(164),[G0tensor(192)])
  call ol_merge_tensors(T0sum(165),[G0tensor(37)])
  call ol_merge_tensors(T0sum(166),[G0tensor(282)])
  call ol_merge_tensors(T0sum(167),[G0tensor(340)])
  call ol_merge_tensors(T0sum(168),[G0tensor(5)])
  call ol_merge_tensors(T0sum(169),[G0tensor(383)])
  call ol_merge_tensors(T0sum(170),[G0tensor(190)])
  call ol_merge_tensors(T0sum(171),[G0tensor(4)])
  call ol_merge_tensors(T0sum(172),[G0tensor(95)])
  call ol_merge_tensors(T0sum(173),[G0tensor(145)])
  call ol_merge_tensors(T0sum(174),[G0tensor(365)])
  call ol_merge_tensors(T0sum(175),[G0tensor(570)])
  call ol_merge_tensors(T0sum(176),[G0tensor(75)])
  call ol_merge_tensors(T0sum(177),[G0tensor(380)])
  call ol_merge_tensors(T0sum(178),[G0tensor(160)])
  call ol_merge_tensors(T0sum(179),[G0tensor(407)])
  call ol_merge_tensors(T0sum(180),[G0tensor(435)])
  call ol_merge_tensors(T0sum(181),[G0tensor(133)])
  call ol_merge_tensors(T0sum(182),[G0tensor(235)])
  call ol_merge_tensors(T0sum(183),[G0tensor(153)])
  call ol_merge_tensors(T0sum(184),[G0tensor(575)])
  call ol_merge_tensors(T0sum(185),[G0tensor(470)])
  call ol_merge_tensors(T0sum(186),[G0tensor(480)])
  call ol_merge_tensors(T0sum(187),[G0tensor(490)])
  call ol_merge_tensors(T0sum(188),[G0tensor(584)])
  call ol_merge_tensors(T0sum(189),[G0tensor(315)])
  call ol_merge_tensors(T0sum(190),[G0tensor(20)])
  call ol_merge_tensors(T0sum(191),[G0tensor(44)])
  call ol_merge_tensors(T0sum(192),[G0tensor(300)])
  call ol_merge_tensors(T0sum(193),[G0tensor(43)])
  call ol_merge_tensors(T0sum(194),[G0tensor(275)])
  call ol_merge_tensors(T0sum(195),[G0tensor(100)])
  call ol_merge_tensors(T0sum(196),[G0tensor(70)])
  call ol_merge_tensors(T0sum(197),[G0tensor(130)])
  call ol_merge_tensors(T0sum(198),[G0tensor(15)])
  call ol_merge_tensors(T0sum(199),[G0tensor(512)])
  call ol_merge_tensors(T0sum(200),[G0tensor(232)])
  call ol_merge_tensors(T0sum(201),[G0tensor(614)])
  call ol_merge_tensors(T0sum(202),[G0tensor(317)])
  call ol_merge_tensors(T0sum(203),[G0tensor(548)])
  call ol_merge_tensors(T0sum(204),[G0tensor(39)])
  call ol_merge_tensors(T0sum(205),[G0tensor(347)])
  call ol_merge_tensors(T0sum(206),[G0tensor(362)])
  call ol_merge_tensors(T0sum(207),[G0tensor(483)])
  call ol_merge_tensors(T0sum(208),[G0tensor(382)])
  call ol_merge_tensors(T0sum(209),[G0tensor(353)])
  call ol_merge_tensors(T0sum(210),[G0tensor(109)])
  call ol_merge_tensors(T0sum(211),[G0tensor(508)])
  call ol_merge_tensors(T0sum(212),[G0tensor(528)])
  call ol_merge_tensors(T0sum(213),[G0tensor(432)])
  call ol_merge_tensors(T0sum(214),[G0tensor(143)])
  call ol_merge_tensors(T0sum(215),[G0tensor(149)])
  call ol_merge_tensors(T0sum(216),[G0tensor(159)])
  call ol_merge_tensors(T0sum(217),[G0tensor(487)])
  call ol_merge_tensors(T0sum(218),[G0tensor(189)])
  call ol_merge_tensors(T0sum(219),[G0tensor(507)])
  call ol_merge_tensors(T0sum(220),[G0tensor(318)])
  call ol_merge_tensors(T0sum(221),[G0tensor(542)])
  call ol_merge_tensors(T0sum(222),[G0tensor(622)])
  call ol_merge_tensors(T0sum(223),[G0tensor(600)])
  call ol_merge_tensors(T0sum(224),[G0tensor(550)])
  call ol_merge_tensors(T0sum(225),[G0tensor(568)])
  call ol_merge_tensors(T0sum(226),[G0tensor(334)])
  call ol_merge_tensors(T0sum(227),[G0tensor(249)])
  call ol_merge_tensors(T0sum(228),[G0tensor(413)])
  call ol_merge_tensors(T0sum(229),[G0tensor(368)])
  call ol_merge_tensors(T0sum(230),[G0tensor(294)])
  call ol_merge_tensors(T0sum(231),[G0tensor(299)])
  call ol_merge_tensors(T0sum(232),[G0tensor(403)])
  call ol_merge_tensors(T0sum(233),[G0tensor(398)])
  call ol_merge_tensors(T0sum(234),[G0tensor(333)])
  call ol_merge_tensors(T0sum(235),[G0tensor(419)])
  call ol_merge_tensors(T0sum(236),[G0tensor(359)])
  call ol_merge_tensors(T0sum(237),[G0tensor(529)])
  call ol_merge_tensors(T0sum(238),[G0tensor(484)])
  call ol_merge_tensors(T0sum(239),[G0tensor(439)])
  call ol_merge_tensors(T0sum(240),[G0tensor(404)])
  call ol_merge_tensors(T0sum(241),[G0tensor(494)])
  call ol_merge_tensors(T0sum(242),[G0tensor(479)])
  call ol_merge_tensors(T0sum(243),[G0tensor(468)])
  call ol_merge_tensors(T0sum(244),[G0tensor(524)])
  call ol_merge_tensors(T0sum(245),[G0tensor(534)])
  call ol_merge_tensors(T0sum(246),[G0tensor(549)])
  call ol_merge_tensors(T0sum(247),[G0tensor(574)])
  call ol_merge_tensors(T0sum(248),[G0tensor(619)])
  call ol_merge_tensors(T0sum(249),[G0tensor(218)])
  call ol_merge_tensors(T0sum(250),[G0tensor(230)])
  call ol_merge_tensors(T0sum(251),[G0tensor(248)])
  call ol_merge_tensors(T0sum(252),[G0tensor(628)])
  call ol_merge_tensors(T0sum(253),[G0tensor(633)])
  call ol_merge_tensors(T0sum(254),[G0tensor(637)])
  call ol_merge_tensors(T0sum(255),[G0tensor(642)])
  call ol_merge_tensors(T0sum(256),[G0tensor(646)])
  call ol_merge_tensors(T0sum(257),[G0tensor(651)])
  call ol_merge_tensors(T0sum(258),[G0tensor(655)])
  call ol_merge_tensors(T0sum(259),[G0tensor(660)])
  call ol_merge_tensors(T0sum(260),[G0tensor(664)])
  call ol_merge_tensors(T0sum(261),[G0tensor(669)])
  call ol_merge_tensors(T0sum(262),[G0tensor(674)])
  call ol_merge_tensors(T0sum(263),[G0tensor(679)])
  call ol_merge_tensors(T0sum(264),[G0tensor(684)])
  call ol_merge_tensors(T0sum(265),[G0tensor(689)])
  call ol_merge_tensors(T0sum(266),[G0tensor(694)])
  call ol_merge_tensors(T0sum(267),[G0tensor(700)])
  call ol_merge_tensors(T0sum(268),[G0tensor(705)])
  call ol_merge_tensors(T0sum(269),[G0tensor(709)])
  call ol_merge_tensors(T0sum(270),[G0tensor(714)])
  call ol_merge_tensors(T0sum(271),[G0tensor(719)])
  call ol_merge_tensors(T0sum(272),[G0tensor(724)])
  call ol_merge_tensors(T0sum(273),[G0tensor(730)])
  call ol_merge_tensors(T0sum(274),[G0tensor(735)])
  call ol_merge_tensors(T0sum(275),[G0tensor(237)])
  call ol_merge_tensors(T0sum(276),[G0tensor(741)])
  call ol_merge_tensors(T0sum(277),[G0tensor(227)])
  call ol_merge_tensors(T0sum(278),[G0tensor(228)])
  call ol_merge_tensors(T0sum(279),[G0tensor(238)])
  call ol_merge_tensors(T0sum(280),[G0tensor(239)])
  call ol_merge_tensors(T0sum(281),[G0tensor(262)])
  call ol_merge_tensors(T0sum(282),[G0tensor(553)])
  call ol_merge_tensors(T0sum(283),[G0tensor(252)])
  call ol_merge_tensors(T0sum(284),[G0tensor(253)])
  call ol_merge_tensors(T0sum(285),[G0tensor(263)])
  call ol_merge_tensors(T0sum(286),[G0tensor(264)])
  call ol_merge_tensors(T0sum(287),[G0tensor(537)])
  call ol_merge_tensors(T0sum(288),[G0tensor(539)])
  call ol_merge_tensors(T0sum(289),[G0tensor(552)])
  call ol_merge_tensors(T0sum(290),[G0tensor(554)])
  call ol_merge_tensors(T0sum(291),[G0tensor(748)])
  call ol_merge_tensors(T0sum(292),[G0tensor(753)])
  call ol_merge_tensors(T0sum(293),[G0tensor(758)])
  call ol_merge_tensors(T0sum(294),[G0tensor(763)])
  call ol_merge_tensors(T0sum(295),[G0tensor(768)])
  call ol_merge_tensors(T0sum(296),[G0tensor(773)])
  call ol_merge_tensors(T0sum(297),[G0tensor(778)])
  call ol_merge_tensors(T0sum(298),[G0tensor(783)])
  call ol_merge_tensors(T0sum(299),[G0tensor(788)])
  call ol_merge_tensors(T0sum(300),[G0tensor(794)])
  call ol_merge_tensors(T0sum(301),[G0tensor(800)])
  call ol_merge_tensors(T0sum(302),[G0tensor(807)])
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(364),h0tab(:,364),[27,4],[nMW,nMW],3,1,wf8(:,1))
  call Hloop_SVV_S(ntryL,G0H72(1),ex4(:),wf8(:,1),G0H3(3),m4h3x8x3(:,1),heltab3x72(:,:,1))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(365),h0tab(:,365),[27,4],[nMW,nMW],3,1,wf8(:,1))
  call Hloop_WWV_V(ntryL,G0H72(1),wf8(:,1),ex4(:),G0H3(5),m4h8x3x3(:,1),heltab3x72(:,:,2))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(366),h0tab(:,366),[27,4],[nMW,nMW],3,1,wf8(:,2))
  call Hloop_SVV_S(ntryL,G0H72(1),ex4(:),wf8(:,2),G0H3(1),m4h3x8x3(:,2),heltab3x72(:,:,3))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(367),h0tab(:,367),[27,4],[nMW,nMW],3,1,wf8(:,2))
  call Hloop_WWV_V(ntryL,G0H72(1),wf8(:,2),ex4(:),G0H3(2),m4h8x3x3(:,2),heltab3x72(:,:,4))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(368),h0tab(:,368),[23,8],[nMH,nMW],3,1,wf8(:,1))
  call Hloop_SVV_S(ntryL,G0H72(1),ex3(:),wf8(:,1),G0H3(4),m4h3x8x3(:,3),heltab3x72(:,:,5))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(369),h0tab(:,369),[23,8],[nMZ,nMW],3,1,wf8(:,1))
  call Hloop_SVV_S(ntryL,G0H72(1),ex3(:),wf8(:,1),G0H3(6),m4h3x8x3(:,4),heltab3x72(:,:,6))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(370),h0tab(:,370),[23,8],[0,nMW],3,1,wf8(:,1))
  call Hloop_WWV_V(ntryL,G0H72(1),wf8(:,1),ex3(:),G0H3(7),m4h8x3x3(:,3),heltab3x72(:,:,7))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(371),h0tab(:,371),[23,8],[nMZ,nMW],3,1,wf8(:,1))
  call Hloop_WWV_V(ntryL,G0H72(1),wf8(:,1),ex3(:),G0H3(8),m4h8x3x3(:,4),heltab3x72(:,:,8))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(372),h0tab(:,372),[23,8],[nMH,nMW],3,1,wf8(:,2))
  call Hloop_SVV_S(ntryL,G0H72(1),ex3(:),wf8(:,2),G0H3(9),m4h3x8x3(:,5),heltab3x72(:,:,9))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(373),h0tab(:,373),[23,8],[nMZ,nMW],3,1,wf8(:,2))
  call Hloop_SVV_S(ntryL,G0H72(1),ex3(:),wf8(:,2),G0H3(10),m4h3x8x3(:,6),heltab3x72(:,:,10))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(374),h0tab(:,374),[23,8],[0,nMW],3,1,wf8(:,2))
  call Hloop_WWV_V(ntryL,G0H72(1),wf8(:,2),ex3(:),G0H3(11),m4h8x3x3(:,5),heltab3x72(:,:,11))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(375),h0tab(:,375),[23,8],[nMZ,nMW],3,1,wf8(:,2))
  call Hloop_WWV_V(ntryL,G0H72(1),wf8(:,2),ex3(:),G0H3(12),m4h8x3x3(:,6),heltab3x72(:,:,12))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(376),h0tab(:,376),[19,12],[nMW,nMH],3,1,wf8(:,1))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(39),m3h8x9(:,67),heltab2x72(:,:,364))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(377),h0tab(:,377),[19,12],[nMW,nMZ],3,1,wf8(:,1))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(40),m3h8x9(:,68),heltab2x72(:,:,365))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(378),h0tab(:,378),[19,12],[nMW,0],3,1,wf8(:,1))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(43),m3h8x9(:,69),heltab2x72(:,:,366))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(379),h0tab(:,379),[19,12],[nMW,nMZ],3,1,wf8(:,1))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(44),m3h8x9(:,70),heltab2x72(:,:,367))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(380),h0tab(:,380),[19,12],[nMW,nMH],3,1,wf8(:,2))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(25),m3h8x9(:,71),heltab2x72(:,:,368))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(381),h0tab(:,381),[19,12],[nMW,nMZ],3,1,wf8(:,2))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(17),m3h8x9(:,72),heltab2x72(:,:,369))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(382),h0tab(:,382),[19,12],[nMW,0],3,1,wf8(:,2))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(11),m3h8x9(:,73),heltab2x72(:,:,370))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(383),h0tab(:,383),[19,12],[nMW,nMZ],3,1,wf8(:,2))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(18),m3h8x9(:,74),heltab2x72(:,:,371))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(384),h0tab(:,384),[21,10],[0,0],2,2,wf12(:,23),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H72(1),wf12(:,23),G0H6(29),m3h12x6(:,49),heltab2x72(:,:,372))
  call Hloop_A_Q(ntryL,G0H6(29),21,0,G1H6(58),n2h6(87))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(385),h0tab(:,385),[21,10],[0,nMZ],2,2,wf12(:,23),wf6(:,4))
  call Hloop_ZA_Q(ntryL,G0H72(1),wf12(:,23),G0H6(15),ngZu,m3h12x6(:,50),heltab2x72(:,:,373))
  call Hloop_A_Q(ntryL,G0H6(15),21,0,G1H6(59),n2h6(88))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(386),h0tab(:,386),[21,10],[0,nMW],2,2,wf12(:,23),wf6(:,4))
  call Hloop_WA_Q(ntryL,G0H72(1),wf12(:,23),G0H6(3),m3h12x6(:,51),heltab2x72(:,:,374))
  call Hloop_A_Q(ntryL,G0H6(3),21,0,G1H6(62),n2h6(89))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(387),h0tab(:,387),[21,10],[0,0],2,2,wf12(:,23),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H72(1),wf12(:,23),G0H6(1),m3h12x6(:,52),heltab2x72(:,:,375))
  call Hloop_A_Q(ntryL,G0H6(1),21,0,G1H6(63),n2h6(90))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(388),h0tab(:,388),[26,5],[0,0],2,2,wf12(:,22),wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H72(1),wf12(:,22),G0H6(2),m3h12x6(:,53),heltab2x72(:,:,376))
  call Hloop_Q_A(ntryL,G0H6(2),26,0,G1H6(64),n2h6(91))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(389),h0tab(:,389),[26,5],[0,nMZ],2,2,wf12(:,22),wf6(:,3))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf12(:,22),G0H6(22),ngZu,m3h12x6(:,54),heltab2x72(:,:,377))
  call Hloop_Q_A(ntryL,G0H6(22),26,0,G1H6(65),n2h6(92))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(390),h0tab(:,390),[26,5],[0,nMW],2,2,wf12(:,22),wf6(:,3))
  call Hloop_WQ_A(ntryL,G0H72(1),wf12(:,22),G0H6(6),m3h12x6(:,55),heltab2x72(:,:,378))
  call Hloop_Q_A(ntryL,G0H6(6),26,0,G1H6(68),n2h6(93))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(391),h0tab(:,391),[26,5],[0,0],2,2,wf12(:,22),wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H72(1),wf12(:,22),G0H6(4),m3h12x6(:,56),heltab2x72(:,:,379))
  call Hloop_Q_A(ntryL,G0H6(4),26,0,G1H6(69),n2h6(94))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(392),h0tab(:,392),[18,13],[0,0],2,2,wf4(:,2),wf18(:,9))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,2),G0H18(15),m3h4x18(:,95),heltab2x72(:,:,380))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(393),h0tab(:,393),[18,13],[nMZ,0],2,2,wf4(:,2),wf18(:,9))
  call Hloop_AQ_Z(ntryL,G0H72(1),wf4(:,2),G0H18(5),ngZd,m3h4x18(:,96),heltab2x72(:,:,381))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(394),h0tab(:,394),[18,13],[nMW,0],2,2,wf4(:,2),wf18(:,9))
  call Hloop_AQ_W(ntryL,G0H72(1),wf4(:,2),G0H18(4),m3h4x18(:,97),heltab2x72(:,:,382))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(395),h0tab(:,395),[18,13],[0,0],2,2,wf4(:,2),wf18(:,9))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,2),G0H18(13),m3h4x18(:,98),heltab2x72(:,:,383))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(396),h0tab(:,396),[26,5],[0,0],2,2,wf12(:,25),wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H72(1),wf12(:,25),G0H6(5),m3h12x6(:,57),heltab2x72(:,:,384))
  call Hloop_Q_A(ntryL,G0H6(5),26,0,G1H6(74),n2h6(95))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(397),h0tab(:,397),[26,5],[0,nMZ],2,2,wf12(:,25),wf6(:,3))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf12(:,25),G0H6(18),ngZu,m3h12x6(:,58),heltab2x72(:,:,385))
  call Hloop_Q_A(ntryL,G0H6(18),26,0,G1H6(75),n2h6(96))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(398),h0tab(:,398),[26,5],[0,nMW],2,2,wf12(:,25),wf6(:,3))
  call Hloop_WQ_A(ntryL,G0H72(1),wf12(:,25),G0H6(10),m3h12x6(:,59),heltab2x72(:,:,386))
  call Hloop_Q_A(ntryL,G0H6(10),26,0,G1H6(76),n2h6(97))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(399),h0tab(:,399),[26,5],[0,0],2,2,wf12(:,25),wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H72(1),wf12(:,25),G0H6(7),m3h12x6(:,60),heltab2x72(:,:,387))
  call Hloop_Q_A(ntryL,G0H6(7),26,0,G1H6(81),n2h6(98))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(400),h0tab(:,400),[25,6],[0,0],2,2,wf12(:,28),wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H72(1),wf12(:,28),G0H6(8),m3h12x6(:,61),heltab2x72(:,:,388))
  call Hloop_A_Q(ntryL,G0H6(8),25,0,G1H6(82),n2h6(99))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(401),h0tab(:,401),[25,6],[0,nMZ],2,2,wf12(:,28),wf6(:,8))
  call Hloop_ZA_Q(ntryL,G0H72(1),wf12(:,28),G0H6(9),ngZd,m3h12x6(:,62),heltab2x72(:,:,389))
  call Hloop_A_Q(ntryL,G0H6(9),25,0,G1H6(83),n2h6(100))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(402),h0tab(:,402),[25,6],[0,nMW],2,2,wf12(:,28),wf6(:,8))
  call Hloop_WA_Q(ntryL,G0H72(1),wf12(:,28),G0H6(25),m3h12x6(:,63),heltab2x72(:,:,390))
  call Hloop_A_Q(ntryL,G0H6(25),25,0,G1H6(4),n2h6(101))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(403),h0tab(:,403),[25,6],[0,0],2,2,wf12(:,28),wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H72(1),wf12(:,28),G0H6(14),m3h12x6(:,64),heltab2x72(:,:,391))
  call Hloop_A_Q(ntryL,G0H6(14),25,0,G1H6(5),n2h6(102))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(404),h0tab(:,404),[22,9],[0,0],2,2,wf12(:,27),wf6(:,7))
  call Hloop_VQ_A(ntryL,G0H72(1),wf12(:,27),G0H6(11),m3h12x6(:,65),heltab2x72(:,:,392))
  call Hloop_Q_A(ntryL,G0H6(11),22,0,G1H6(89),n2h6(103))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(405),h0tab(:,405),[22,9],[0,nMZ],2,2,wf12(:,27),wf6(:,7))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf12(:,27),G0H6(12),ngZd,m3h12x6(:,66),heltab2x72(:,:,393))
  call Hloop_Q_A(ntryL,G0H6(12),22,0,G1H6(92),n2h6(104))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(406),h0tab(:,406),[22,9],[0,nMW],2,2,wf12(:,27),wf6(:,7))
  call Hloop_WQ_A(ntryL,G0H72(1),wf12(:,27),G0H6(13),m3h12x6(:,67),heltab2x72(:,:,394))
  call Hloop_Q_A(ntryL,G0H6(13),22,0,G1H6(95),n2h6(105))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(407),h0tab(:,407),[22,9],[0,0],2,2,wf12(:,27),wf6(:,7))
  call Hloop_VQ_A(ntryL,G0H72(1),wf12(:,27),G0H6(17),m3h12x6(:,68),heltab2x72(:,:,395))
  call Hloop_Q_A(ntryL,G0H6(17),22,0,G1H6(96),n2h6(106))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(408),h0tab(:,408),[25,6],[0,0],2,2,wf12(:,29),wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H72(1),wf12(:,29),G0H6(16),m3h12x6(:,69),heltab2x72(:,:,396))
  call Hloop_A_Q(ntryL,G0H6(16),25,0,G1H6(103),n2h6(107))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(409),h0tab(:,409),[25,6],[0,nMZ],2,2,wf12(:,29),wf6(:,8))
  call Hloop_ZA_Q(ntryL,G0H72(1),wf12(:,29),G0H6(24),ngZd,m3h12x6(:,70),heltab2x72(:,:,397))
  call Hloop_A_Q(ntryL,G0H6(24),25,0,G1H6(108),n2h6(108))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(410),h0tab(:,410),[25,6],[0,nMW],2,2,wf12(:,29),wf6(:,8))
  call Hloop_WA_Q(ntryL,G0H72(1),wf12(:,29),G0H6(23),m3h12x6(:,71),heltab2x72(:,:,398))
  call Hloop_A_Q(ntryL,G0H6(23),25,0,G1H6(104),n2h6(109))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(411),h0tab(:,411),[25,6],[0,0],2,2,wf12(:,29),wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H72(1),wf12(:,29),G0H6(21),m3h12x6(:,72),heltab2x72(:,:,399))
  call Hloop_A_Q(ntryL,G0H6(21),25,0,G1H6(112),n2h6(110))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(412),h0tab(:,412),[17,14],[0,0],2,2,wf4(:,4),wf18(:,11))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,4),G0H18(12),m3h4x18(:,99),heltab2x72(:,:,400))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(413),h0tab(:,413),[17,14],[nMZ,0],2,2,wf4(:,4),wf18(:,11))
  call Hloop_QA_Z(ntryL,G0H72(1),wf4(:,4),G0H18(8),ngZu,m3h4x18(:,100),heltab2x72(:,:,401))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(414),h0tab(:,414),[17,14],[nMW,0],2,2,wf4(:,4),wf18(:,11))
  call Hloop_QA_W(ntryL,G0H72(1),wf4(:,4),G0H18(9),m3h4x18(:,101),heltab2x72(:,:,402))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(415),h0tab(:,415),[17,14],[0,0],2,2,wf4(:,4),wf18(:,11))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,4),G0H18(10),m3h4x18(:,102),heltab2x72(:,:,403))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(416),h0tab(:,416),[18,13],[0,0],2,2,wf4(:,2),wf18(:,12))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,2),G0H18(7),m3h4x18(:,103),heltab2x72(:,:,404))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(417),h0tab(:,417),[18,13],[nMZ,0],2,2,wf4(:,2),wf18(:,12))
  call Hloop_AQ_Z(ntryL,G0H72(1),wf4(:,2),G0H18(2),ngZd,m3h4x18(:,104),heltab2x72(:,:,405))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(418),h0tab(:,418),[18,13],[nMW,0],2,2,wf4(:,2),wf18(:,12))
  call Hloop_AQ_W(ntryL,G0H72(1),wf4(:,2),G0H18(1),m3h4x18(:,105),heltab2x72(:,:,406))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(419),h0tab(:,419),[18,13],[0,0],2,2,wf4(:,2),wf18(:,12))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,2),G0H18(6),m3h4x18(:,106),heltab2x72(:,:,407))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(420),h0tab(:,420),[22,9],[0,0],2,2,wf12(:,31),wf6(:,7))
  call Hloop_VQ_A(ntryL,G0H72(1),wf12(:,31),G0H6(19),m3h12x6(:,73),heltab2x72(:,:,408))
  call Hloop_Q_A(ntryL,G0H6(19),22,0,G1H6(113),n2h6(111))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(421),h0tab(:,421),[22,9],[0,nMZ],2,2,wf12(:,31),wf6(:,7))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf12(:,31),G0H6(20),ngZd,m3h12x6(:,74),heltab2x72(:,:,409))
  call Hloop_Q_A(ntryL,G0H6(20),22,0,G1H6(114),n2h6(112))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(422),h0tab(:,422),[22,9],[0,nMW],2,2,wf12(:,31),wf6(:,7))
  call Hloop_WQ_A(ntryL,G0H72(1),wf12(:,31),G0H6(28),m3h12x6(:,75),heltab2x72(:,:,410))
  call Hloop_Q_A(ntryL,G0H6(28),22,0,G1H6(120),n2h6(113))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(423),h0tab(:,423),[22,9],[0,0],2,2,wf12(:,31),wf6(:,7))
  call Hloop_VQ_A(ntryL,G0H72(1),wf12(:,31),G0H6(26),m3h12x6(:,76),heltab2x72(:,:,411))
  call Hloop_Q_A(ntryL,G0H6(26),22,0,G1H6(123),n2h6(114))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(424),h0tab(:,424),[21,10],[0,0],2,2,wf12(:,32),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H72(1),wf12(:,32),G0H6(27),m3h12x6(:,77),heltab2x72(:,:,412))
  call Hloop_A_Q(ntryL,G0H6(27),21,0,G1H6(125),n2h6(115))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(425),h0tab(:,425),[21,10],[0,nMZ],2,2,wf12(:,32),wf6(:,4))
  call Hloop_ZA_Q(ntryL,G0H72(1),wf12(:,32),G0H6(29),ngZu,m3h12x6(:,78),heltab2x72(:,:,413))
  call Hloop_A_Q(ntryL,G0H6(29),21,0,G1H6(102),n2h6(116))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(426),h0tab(:,426),[21,10],[0,nMW],2,2,wf12(:,32),wf6(:,4))
  call Hloop_WA_Q(ntryL,G0H72(1),wf12(:,32),G0H6(15),m3h12x6(:,79),heltab2x72(:,:,414))
  call Hloop_A_Q(ntryL,G0H6(15),21,0,G1H6(11),n2h6(117))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(427),h0tab(:,427),[21,10],[0,0],2,2,wf12(:,32),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H72(1),wf12(:,32),G0H6(3),m3h12x6(:,80),heltab2x72(:,:,415))
  call Hloop_A_Q(ntryL,G0H6(3),21,0,G1H6(12),n2h6(118))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(428),h0tab(:,428),[17,14],[0,0],2,2,wf4(:,4),wf18(:,14))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,4),G0H18(3),m3h4x18(:,107),heltab2x72(:,:,416))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(429),h0tab(:,429),[17,14],[nMZ,0],2,2,wf4(:,4),wf18(:,14))
  call Hloop_QA_Z(ntryL,G0H72(1),wf4(:,4),G0H18(14),ngZu,m3h4x18(:,108),heltab2x72(:,:,417))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(430),h0tab(:,430),[17,14],[nMW,0],2,2,wf4(:,4),wf18(:,14))
  call Hloop_QA_W(ntryL,G0H72(1),wf4(:,4),G0H18(11),m3h4x18(:,109),heltab2x72(:,:,418))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(431),h0tab(:,431),[17,14],[0,0],2,2,wf4(:,4),wf18(:,14))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,4),G0H18(16),m3h4x18(:,110),heltab2x72(:,:,419))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(432),h0tab(:,432),[19,12],[nME,0],2,2,wf8(:,1),wf9(:,3))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,1),G0H9(5),m3h8x9(:,75),heltab2x72(:,:,420))
  call Hloop_Q_A(ntryL,G0H9(5),19,nME,G1H9(23),n2h9(53))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(433),h0tab(:,433),[19,12],[nMM,0],2,2,wf8(:,1),wf9(:,3))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,1),G0H9(6),m3h8x9(:,76),heltab2x72(:,:,421))
  call Hloop_Q_A(ntryL,G0H9(6),19,nMM,G1H9(35),n2h9(54))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(434),h0tab(:,434),[19,12],[nML,0],2,2,wf8(:,1),wf9(:,3))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,1),G0H9(7),m3h8x9(:,77),heltab2x72(:,:,422))
  call Hloop_Q_A(ntryL,G0H9(7),19,nML,G1H9(41),n2h9(55))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(435),h0tab(:,435),[19,12],[nMB,nMT],2,2,wf8(:,1),wf9(:,3))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,1),G0H9(8),m3h8x9(:,78),heltab2x72(:,:,423))
  call Hloop_Q_A(ntryL,G0H9(8),19,nMB,G1H9(42),n2h9(56))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(436),h0tab(:,436),[19,12],[nMW,nMH],2,2,wf8(:,1),wf9(:,3))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(2),m3h8x9(:,79),heltab2x72(:,:,424))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(437),h0tab(:,437),[19,12],[nMW,nMZ],2,2,wf8(:,1),wf9(:,3))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(12),m3h8x9(:,80),heltab2x72(:,:,425))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(438),h0tab(:,438),[19,12],[nMW,0],2,2,wf8(:,1),wf9(:,3))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,1),G1H9(26),m3h8x9(:,81),heltab2x72(:,:,426))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(439),h0tab(:,439),[19,12],[nMW,nMZ],2,2,wf8(:,1),wf9(:,3))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,1),G1H9(3),m3h8x9(:,82),heltab2x72(:,:,427))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(440),h0tab(:,440),[19,12],[nMW,0],2,2,wf8(:,1),wf9(:,3))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(51),m3h8x9(:,83),heltab2x72(:,:,428))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(441),h0tab(:,441),[19,12],[nMW,nMZ],2,2,wf8(:,1),wf9(:,3))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(52),m3h8x9(:,84),heltab2x72(:,:,429))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(442),h0tab(:,442),[19,12],[0,nMW],2,2,wf8(:,1),wf9(:,3))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,1),G0H9(1),m3h8x9(:,85),heltab2x72(:,:,430))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(443),h0tab(:,443),[19,12],[nMZ,nMW],2,2,wf8(:,1),wf9(:,3))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,1),G0H9(2),m3h8x9(:,86),heltab2x72(:,:,431))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(444),h0tab(:,444),[19,12],[nMW,nMH],2,2,wf8(:,1),wf9(:,3))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,1),G0H9(3),m3h8x9(:,87),heltab2x72(:,:,432))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(445),h0tab(:,445),[19,12],[nME,0],2,2,wf8(:,1),wf9(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,1),G0H9(4),m3h8x9(:,88),heltab2x72(:,:,433))
  call Hloop_Q_A(ntryL,G0H9(4),19,nME,G1H9(53),n2h9(57))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(446),h0tab(:,446),[19,12],[nMM,0],2,2,wf8(:,1),wf9(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,1),G0H9(9),m3h8x9(:,89),heltab2x72(:,:,434))
  call Hloop_Q_A(ntryL,G0H9(9),19,nMM,G1H9(54),n2h9(58))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(447),h0tab(:,447),[19,12],[nML,0],2,2,wf8(:,1),wf9(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,1),G0H9(10),m3h8x9(:,90),heltab2x72(:,:,435))
  call Hloop_Q_A(ntryL,G0H9(10),19,nML,G1H9(55),n2h9(59))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(448),h0tab(:,448),[19,12],[0,0],2,2,wf8(:,1),wf9(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,1),G0H9(11),m3h8x9(:,91),heltab2x72(:,:,436))
  call Hloop_Q_A(ntryL,G0H9(11),19,0,G1H9(56),n2h9(60))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(449),h0tab(:,449),[19,12],[nMB,nMT],2,2,wf8(:,1),wf9(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,1),G0H9(12),m3h8x9(:,92),heltab2x72(:,:,437))
  call Hloop_Q_A(ntryL,G0H9(12),19,nMB,G1H9(57),n2h9(61))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(450),h0tab(:,450),[19,12],[nMW,nMH],2,2,wf8(:,1),wf9(:,1))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(58),m3h8x9(:,93),heltab2x72(:,:,438))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(451),h0tab(:,451),[19,12],[nMW,nMZ],2,2,wf8(:,1),wf9(:,1))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(59),m3h8x9(:,94),heltab2x72(:,:,439))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(452),h0tab(:,452),[19,12],[nMW,0],2,2,wf8(:,1),wf9(:,1))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(47),m3h8x9(:,95),heltab2x72(:,:,440))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(453),h0tab(:,453),[19,12],[nMW,nMZ],2,2,wf8(:,1),wf9(:,1))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(32),m3h8x9(:,96),heltab2x72(:,:,441))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(454),h0tab(:,454),[19,12],[nMW,0],2,2,wf8(:,1),wf9(:,1))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,1),G1H9(34),m3h8x9(:,97),heltab2x72(:,:,442))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(455),h0tab(:,455),[19,12],[nMW,nMZ],2,2,wf8(:,1),wf9(:,1))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,1),G1H9(6),m3h8x9(:,98),heltab2x72(:,:,443))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(456),h0tab(:,456),[19,12],[nMW,0],2,2,wf8(:,1),wf9(:,1))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(29),m3h8x9(:,99),heltab2x72(:,:,444))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(457),h0tab(:,457),[19,12],[nMW,nMZ],2,2,wf8(:,1),wf9(:,1))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(1),m3h8x9(:,100),heltab2x72(:,:,445))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(458),h0tab(:,458),[19,12],[0,nMW],2,2,wf8(:,1),wf9(:,1))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,1),G0H9(13),m3h8x9(:,101),heltab2x72(:,:,446))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(459),h0tab(:,459),[19,12],[nMZ,nMW],2,2,wf8(:,1),wf9(:,1))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,1),G0H9(14),m3h8x9(:,102),heltab2x72(:,:,447))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(460),h0tab(:,460),[19,12],[nMW,nMH],2,2,wf8(:,1),wf9(:,1))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,1),G0H9(15),m3h8x9(:,103),heltab2x72(:,:,448))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(461),h0tab(:,461),[17,14],[0,0],2,2,wf4(:,4),wf18(:,16))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,4),G0H18(17),m3h4x18(:,111),heltab2x72(:,:,449))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(462),h0tab(:,462),[17,14],[nMZ,0],2,2,wf4(:,4),wf18(:,16))
  call Hloop_QA_Z(ntryL,G0H72(1),wf4(:,4),G0H18(18),ngZu,m3h4x18(:,112),heltab2x72(:,:,450))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(463),h0tab(:,463),[17,14],[nMW,0],2,2,wf4(:,4),wf18(:,16))
  call Hloop_QA_W(ntryL,G0H72(1),wf4(:,4),G0H18(19),m3h4x18(:,113),heltab2x72(:,:,451))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(464),h0tab(:,464),[17,14],[0,0],2,2,wf4(:,4),wf18(:,16))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,4),G0H18(20),m3h4x18(:,114),heltab2x72(:,:,452))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(465),h0tab(:,465),[19,12],[nME,0],2,2,wf8(:,2),wf9(:,3))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,2),G0H9(16),m3h8x9(:,104),heltab2x72(:,:,453))
  call Hloop_Q_A(ntryL,G0H9(16),19,nME,G1H9(24),n2h9(62))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(466),h0tab(:,466),[19,12],[nMM,0],2,2,wf8(:,2),wf9(:,3))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,2),G0H9(5),m3h8x9(:,105),heltab2x72(:,:,454))
  call Hloop_Q_A(ntryL,G0H9(5),19,nMM,G1H9(5),n2h9(63))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(467),h0tab(:,467),[19,12],[nML,0],2,2,wf8(:,2),wf9(:,3))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,2),G0H9(6),m3h8x9(:,106),heltab2x72(:,:,455))
  call Hloop_Q_A(ntryL,G0H9(6),19,nML,G1H9(10),n2h9(64))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(468),h0tab(:,468),[19,12],[nMB,nMT],2,2,wf8(:,2),wf9(:,3))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,2),G0H9(7),m3h8x9(:,107),heltab2x72(:,:,456))
  call Hloop_Q_A(ntryL,G0H9(7),19,nMB,G1H9(30),n2h9(65))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(469),h0tab(:,469),[19,12],[nMW,nMH],2,2,wf8(:,2),wf9(:,3))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(13),m3h8x9(:,108),heltab2x72(:,:,457))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(470),h0tab(:,470),[19,12],[nMW,nMZ],2,2,wf8(:,2),wf9(:,3))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(37),m3h8x9(:,109),heltab2x72(:,:,458))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(471),h0tab(:,471),[19,12],[nMW,0],2,2,wf8(:,2),wf9(:,3))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,2),G1H9(33),m3h8x9(:,110),heltab2x72(:,:,459))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(472),h0tab(:,472),[19,12],[nMW,nMZ],2,2,wf8(:,2),wf9(:,3))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,2),G1H9(36),m3h8x9(:,111),heltab2x72(:,:,460))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(473),h0tab(:,473),[19,12],[nMW,0],2,2,wf8(:,2),wf9(:,3))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(4),m3h8x9(:,112),heltab2x72(:,:,461))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(474),h0tab(:,474),[19,12],[nMW,nMZ],2,2,wf8(:,2),wf9(:,3))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(14),m3h8x9(:,113),heltab2x72(:,:,462))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(475),h0tab(:,475),[19,12],[0,nMW],2,2,wf8(:,2),wf9(:,3))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(8),m3h8x9(:,114),heltab2x72(:,:,463))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(476),h0tab(:,476),[19,12],[nMZ,nMW],2,2,wf8(:,2),wf9(:,3))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(4),m3h8x9(:,115),heltab2x72(:,:,464))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(477),h0tab(:,477),[19,12],[nMW,nMH],2,2,wf8(:,2),wf9(:,3))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(9),m3h8x9(:,116),heltab2x72(:,:,465))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(478),h0tab(:,478),[19,12],[nME,0],2,2,wf8(:,2),wf9(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,2),G0H9(10),m3h8x9(:,117),heltab2x72(:,:,466))
  call Hloop_Q_A(ntryL,G0H9(10),19,nME,G1H9(48),n2h9(66))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(479),h0tab(:,479),[19,12],[nMM,0],2,2,wf8(:,2),wf9(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,2),G0H9(11),m3h8x9(:,118),heltab2x72(:,:,467))
  call Hloop_Q_A(ntryL,G0H9(11),19,nMM,G1H9(15),n2h9(67))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(480),h0tab(:,480),[19,12],[nML,0],2,2,wf8(:,2),wf9(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,2),G0H9(12),m3h8x9(:,119),heltab2x72(:,:,468))
  call Hloop_Q_A(ntryL,G0H9(12),19,nML,G1H9(45),n2h9(68))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(481),h0tab(:,481),[19,12],[0,0],2,2,wf8(:,2),wf9(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,2),G0H9(16),m3h8x9(:,120),heltab2x72(:,:,469))
  call Hloop_Q_A(ntryL,G0H9(16),19,0,G1H9(46),n2h9(69))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(482),h0tab(:,482),[19,12],[nMB,nMT],2,2,wf8(:,2),wf9(:,1))
  call Hloop_QW_A(ntryL,G0H72(1),wf8(:,2),G0H9(5),m3h8x9(:,121),heltab2x72(:,:,470))
  call Hloop_Q_A(ntryL,G0H9(5),19,nMB,G1H9(49),n2h9(70))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(483),h0tab(:,483),[19,12],[nMW,nMH],2,2,wf8(:,2),wf9(:,1))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(50),m3h8x9(:,122),heltab2x72(:,:,471))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(484),h0tab(:,484),[19,12],[nMW,nMZ],2,2,wf8(:,2),wf9(:,1))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(7),m3h8x9(:,123),heltab2x72(:,:,472))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(485),h0tab(:,485),[19,12],[nMW,0],2,2,wf8(:,2),wf9(:,1))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(8),m3h8x9(:,124),heltab2x72(:,:,473))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(486),h0tab(:,486),[19,12],[nMW,nMZ],2,2,wf8(:,2),wf9(:,1))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(9),m3h8x9(:,125),heltab2x72(:,:,474))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(487),h0tab(:,487),[19,12],[nMW,0],2,2,wf8(:,2),wf9(:,1))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,2),G1H9(16),m3h8x9(:,126),heltab2x72(:,:,475))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(488),h0tab(:,488),[19,12],[nMW,nMZ],2,2,wf8(:,2),wf9(:,1))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,2),G1H9(19),m3h8x9(:,127),heltab2x72(:,:,476))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(489),h0tab(:,489),[19,12],[nMW,0],2,2,wf8(:,2),wf9(:,1))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(20),m3h8x9(:,128),heltab2x72(:,:,477))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(490),h0tab(:,490),[19,12],[nMW,nMZ],2,2,wf8(:,2),wf9(:,1))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(21),m3h8x9(:,129),heltab2x72(:,:,478))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(491),h0tab(:,491),[19,12],[0,nMW],2,2,wf8(:,2),wf9(:,1))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(6),m3h8x9(:,130),heltab2x72(:,:,479))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(492),h0tab(:,492),[19,12],[nMZ,nMW],2,2,wf8(:,2),wf9(:,1))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(7),m3h8x9(:,131),heltab2x72(:,:,480))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(493),h0tab(:,493),[19,12],[nMW,nMH],2,2,wf8(:,2),wf9(:,1))



end subroutine vamp_3

end module ol_vamp_3_ppvvj_ew_uxdzwxg_1_/**/REALKIND
