
module ol_vamp_1_ppvvj_ew_uxdawxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj_ew_uxdawxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj_ew_uxdawxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvj_ew_uxdawxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvj_ew_uxdawxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvj_ew_uxdawxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvj_ew_uxdawxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(1),n2h24(1))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,nMZ,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(2),n2h24(2))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(3),n2h24(3))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(4),h0tab(:,4),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(4),n2h24(4))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(5),h0tab(:,5),[16,2,1,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(5),n2h24(5))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(6),n2h24(6))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(7),h0tab(:,7),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,7),heltab2x48(:,:,7))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(7),n2h24(7))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(8),h0tab(:,8),[16,4,2,1,8],[0,0,nMZ,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(8),n2h24(8))
  Gcoeff(:)%j = (c(28)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,9),heltab2x48(:,:,9))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(9),n2h24(9))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(10),h0tab(:,10),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,10),heltab2x48(:,:,10))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(10),n2h24(10))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(11),h0tab(:,11),[16,2,1,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,11),heltab2x48(:,:,11))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(11),n2h24(11))
  Gcoeff(:)%j = (c(28)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(12),h0tab(:,12),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,12),heltab2x48(:,:,12))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(12),n2h24(12))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(13),h0tab(:,13),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,13),heltab2x48(:,:,13))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(13),n2h24(13))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(14),h0tab(:,14),[16,1,2,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,14),heltab2x48(:,:,14))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(14),n2h24(14))
  Gcoeff(:)%j = (c(28)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(15),h0tab(:,15),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,15),heltab2x48(:,:,15))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(15),n2h24(15))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(16),h0tab(:,16),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,16),heltab2x48(:,:,16))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(16),n2h24(16))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(17),h0tab(:,17),[16,1,2,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,17),heltab2x48(:,:,17))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(17),n2h24(17))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(18),h0tab(:,18),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,18),heltab2x48(:,:,18))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(18),n2h24(18))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(19),h0tab(:,19),[16,2,8,1,4],[0,nMW,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,19),heltab2x48(:,:,19))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(19),n2h24(19))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(20),h0tab(:,20),[16,2,8,1,4],[0,0,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,20),heltab2x48(:,:,20))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(20),n2h24(20))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(21),h0tab(:,21),[16,2,8,1,4],[0,nMW,nMZ,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,21),heltab2x48(:,:,21))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(21),n2h24(21))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(22),h0tab(:,22),[16,2,8,1,4],[0,nMZ,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,22),heltab2x48(:,:,22))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(22),n2h24(22))
  Gcoeff(:)%j = (c(26)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(23),h0tab(:,23),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(23),m3h2x24(:,23),heltab2x48(:,:,23))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(24),h0tab(:,24),[16,1,4,8,2],[0,nMW,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,24),heltab2x48(:,:,24))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(24),n2h24(23))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(25),h0tab(:,25),[16,1,4,8,2],[0,nMW,nMW,nMZ,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,25),heltab2x48(:,:,25))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(25),n2h24(24))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(26),h0tab(:,26),[16,1,4,8,2],[0,nMW,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,26),heltab2x48(:,:,26))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(26),n2h24(25))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(27),h0tab(:,27),[16,1,4,8,2],[0,nMW,nMW,nMZ,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,27),heltab2x48(:,:,27))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(27),n2h24(26))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(28),h0tab(:,28),[16,1,8,2,4],[0,0,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,28),heltab2x48(:,:,28))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(28),n2h24(27))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(29),h0tab(:,29),[16,1,8,2,4],[0,nMW,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,29),heltab2x48(:,:,29))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(29),n2h24(28))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(30),h0tab(:,30),[16,1,8,2,4],[0,nMZ,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,30),heltab2x48(:,:,30))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(30),n2h24(29))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(31),h0tab(:,31),[16,1,8,2,4],[0,nMW,nMZ,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,31),heltab2x48(:,:,31))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(31),n2h24(30))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(32),h0tab(:,32),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(32),m3h2x24(:,32),heltab2x48(:,:,32))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(33),h0tab(:,33),[16,1,8,4,2],[0,0,nMW,nMW,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,33),heltab2x48(:,:,33))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(33),n2h24(31))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(34),h0tab(:,34),[16,1,8,4,2],[0,nMZ,nMW,nMW,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,34),heltab2x48(:,:,34))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(34),n2h24(32))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(35),h0tab(:,35),[16,1,8,4,2],[0,0,nMW,nMW,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,35),heltab2x48(:,:,35))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(35),n2h24(33))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(36),h0tab(:,36),[16,1,8,4,2],[0,nMZ,nMW,nMW,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,36),heltab2x48(:,:,36))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(36),n2h24(34))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(3),[G1H24(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(6),[G1H24(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(9),[G1H24(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(12),[G1H24(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(15),[G1H24(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(18),[G1H24(16)])
  call Hloop_QV_A(ntryL,G1H24(3),ex3(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_Q_A(ntryL,G1H12(1),20,0,G2H12(1),n2h12(1))
  call Hloop_QV_A(ntryL,G1H24(2),ex3(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_Q_A(ntryL,G1H12(1),20,0,G2H12(2),n2h12(2))
  call Hloop_AQ_V(ntryL,G1H24(6),ex2(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H24(5),ex2(:),G1H12(2),ngZd,m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_AV_Q(ntryL,G1H24(9),ex3(:),G1H12(3),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H12(3),20,0,G2H12(3),n2h12(3))
  call Hloop_AV_Q(ntryL,G1H24(8),ex3(:),G1H12(3),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G1H12(3),20,0,G2H12(4),n2h12(4))
  call Hloop_AQ_V(ntryL,G1H24(12),ex2(:),G1H12(3),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H24(11),ex2(:),G1H12(4),ngZd,m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_QA_V(ntryL,G1H24(15),ex1(:),G1H12(5),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_QA_Z(ntryL,G1H24(14),ex1(:),G1H12(6),ngZu,m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_QA_V(ntryL,G1H24(18),ex1(:),G1H12(7),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_QA_Z(ntryL,G1H24(17),ex1(:),G1H12(8),ngZu,m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_AQ_W(ntryL,G1H24(19),ex2(:),G1H12(9),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_AQ_V(ntryL,G1H24(20),ex2(:),G1H12(10),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_AQ_W(ntryL,G1H24(21),ex2(:),G1H12(11),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H24(22),ex2(:),G1H12(12),ngZd,m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_VA_Q(ntryL,G1H24(23),ex1(:),G1H12(13),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_A_Q(ntryL,G1H12(13),17,0,G2H12(5),n2h12(5))
  call Hloop_QA_W(ntryL,G1H24(24),ex1(:),G1H12(13),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_QA_W(ntryL,G1H24(25),ex1(:),G1H12(14),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_QA_W(ntryL,G1H24(26),ex1(:),G1H12(15),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_QA_W(ntryL,G1H24(27),ex1(:),G1H12(16),m3h2x12(:,21),heltab2x24(:,:,21))
  call Hloop_QA_V(ntryL,G1H24(28),ex1(:),G1H12(17),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hloop_QA_W(ntryL,G1H24(29),ex1(:),G1H12(18),m3h2x12(:,23),heltab2x24(:,:,23))
  call Hloop_QA_Z(ntryL,G1H24(30),ex1(:),G1H12(19),ngZu,m3h2x12(:,24),heltab2x24(:,:,24))
  call Hloop_QA_W(ntryL,G1H24(31),ex1(:),G1H12(20),m3h2x12(:,25),heltab2x24(:,:,25))
  call Hloop_VA_Q(ntryL,G1H24(32),ex1(:),G1H12(21),m3h2x12(:,26),heltab2x24(:,:,26))
  call Hloop_A_Q(ntryL,G1H12(21),17,0,G2H12(6),n2h12(6))
  call Hloop_QA_V(ntryL,G1H24(33),ex1(:),G1H12(21),m3h2x12(:,27),heltab2x24(:,:,27))
  call Hloop_QA_Z(ntryL,G1H24(34),ex1(:),G1H12(22),ngZu,m3h2x12(:,28),heltab2x24(:,:,28))
  call Hloop_QA_V(ntryL,G1H24(35),ex1(:),G1H12(23),m3h2x12(:,29),heltab2x24(:,:,29))
  call Hloop_QA_Z(ntryL,G1H24(36),ex1(:),G1H12(24),ngZu,m3h2x12(:,30),heltab2x24(:,:,30))
  call Hloop_QA_V(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_QA_Z(ntryL,G2H12(2),ex1(:),G2H6(2),ngZu,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_VA_Q(ntryL,G1H12(1),ex1(:),G1H6(1),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(3),n2h6(1))
  call Hloop_ZA_Q(ntryL,G1H12(2),ex1(:),G1H6(1),ngZu,m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(4),n2h6(2))
  call Hloop_AQ_V(ntryL,G2H12(3),ex2(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_AQ_Z(ntryL,G2H12(4),ex2(:),G2H6(6),ngZd,m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_VA_Q(ntryL,G1H12(3),ex1(:),G1H6(1),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(7),n2h6(3))
  call Hloop_ZA_Q(ntryL,G1H12(4),ex1(:),G1H6(1),ngZu,m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(8),n2h6(4))
  call Hloop_VQ_A(ntryL,G1H12(5),ex2(:),G1H6(1),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(9),n2h6(5))
  call Hloop_ZQ_A(ntryL,G1H12(6),ex2(:),G1H6(1),ngZd,m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(10),n2h6(6))
  call Hloop_VQ_A(ntryL,G1H12(7),ex2(:),G1H6(1),m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(11),n2h6(7))
  call Hloop_ZQ_A(ntryL,G1H12(8),ex2(:),G1H6(1),ngZd,m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(12),n2h6(8))
  call Hloop_UW_V(ntryL,G1H12(9),18,ex4(:),8,G2H4(1),m3h3x4(:,1),heltab2x12(:,:,13))
  call Hloop_UV_W(ntryL,G1H12(10),18,ex4(:),8,G2H4(2),m3h3x4(:,2),heltab2x12(:,:,14))
  call Hloop_UW_V(ntryL,G1H12(11),18,ex4(:),8,G2H4(3),m3h3x4(:,3),heltab2x12(:,:,15))
  call Hloop_UV_W(ntryL,G1H12(12),18,ex4(:),8,G2H4(4),m3h3x4(:,4),heltab2x12(:,:,16))
  call Hotf_5pt_reduction(G2H12(5),RedSet_5(1),mass5set(:,1),  & 
G1H12(1),G1H12(2),G1H12(3),G1H12(4),G1H12(5),G1H12(6),12)
  call HG1shiftOLR(G1H12(2),2,12)
  call Hloop_VV_S(ntryL,G1H12(13),ex3(:),G1H6(1),m3h2x6(:,13),heltab2x12(:,:,17))
  call Hloop_VV_S(ntryL,G1H12(14),ex3(:),G1H6(2),m3h2x6(:,14),heltab2x12(:,:,18))
  call Hloop_UV_W(ntryL,G1H12(15),17,ex3(:),4,G2H6(13),m3h2x6(:,15),heltab2x12(:,:,19))
  call Hloop_UV_W(ntryL,G1H12(16),17,ex3(:),4,G2H6(14),m3h2x6(:,16),heltab2x12(:,:,20))
  call Hloop_UV_W(ntryL,G1H12(17),17,ex4(:),8,G2H4(5),m3h3x4(:,5),heltab2x12(:,:,21))
  call Hloop_UW_V(ntryL,G1H12(18),17,ex4(:),8,G2H4(6),m3h3x4(:,6),heltab2x12(:,:,22))
  call Hloop_UV_W(ntryL,G1H12(19),17,ex4(:),8,G2H4(7),m3h3x4(:,7),heltab2x12(:,:,23))
  call Hloop_UW_V(ntryL,G1H12(20),17,ex4(:),8,G2H4(8),m3h3x4(:,8),heltab2x12(:,:,24))
  call Hotf_5pt_reduction(G2H12(6),RedSet_5(2),mass5set(:,1),  & 
G1H12(7),G1H12(8),G1H12(9),G1H12(10),G1H12(11),G1H12(12),12)
  call HG1shiftOLR(G1H12(8),2,12)
  call Hloop_VV_S(ntryL,G1H12(21),ex4(:),G1H4(1),m3h3x4(:,9),heltab2x12(:,:,25))
  call Hloop_VV_S(ntryL,G1H12(22),ex4(:),G1H4(2),m3h3x4(:,10),heltab2x12(:,:,26))
  call Hloop_UV_W(ntryL,G1H12(23),17,ex4(:),8,G2H4(9),m3h3x4(:,11),heltab2x12(:,:,27))
  call Hloop_UV_W(ntryL,G1H12(24),17,ex4(:),8,G2H4(10),m3h3x4(:,12),heltab2x12(:,:,28))
  call Hloop_AV_Q(ntryL,G1H12(1),ex3(:),G1H6(3),m3h2x6(:,17),heltab2x12(:,:,29))
  call Hloop_A_Q(ntryL,G1H6(3),21,0,G2H6(15),n2h6(9))
call HGT_raise_alpha_OLR(G1H12(2),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(2),ex2(:),G1H6(3),m3h2x6(:,18),heltab2x12(:,:,30))
  call Hloop_AV_Q(ntryL,G1H12(4),ex3(:),G1H6(4),m3h2x6(:,19),heltab2x12(:,:,31))
  call Hloop_A_Q(ntryL,G1H6(4),21,0,G2H6(16),n2h6(10))
  call Hloop_AV_Q(ntryL,G1H12(5),ex3(:),G1H6(4),m3h2x6(:,20),heltab2x12(:,:,32))
  call Hloop_A_Q(ntryL,G1H6(4),21,0,G2H6(17),n2h6(11))
  call Hloop_AV_Q(ntryL,G1H12(6),ex3(:),G1H6(4),m3h2x6(:,21),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H6(4),21,0,G2H6(18),n2h6(12))
  call Hloop_AW_Q(ntryL,G1H12(7),ex4(:),G1H4(3),m3h3x4(:,13),heltab2x12(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(3),25,0,G2H4(11),n2h4(1))
call HGT_raise_alpha_OLR(G1H12(8),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(8),ex2(:),G1H6(4),m3h2x6(:,22),heltab2x12(:,:,35))
  call Hloop_AW_Q(ntryL,G1H12(10),ex4(:),G1H4(3),m3h3x4(:,14),heltab2x12(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(3),25,0,G2H4(12),n2h4(2))
  call Hloop_AW_Q(ntryL,G1H12(11),ex4(:),G1H4(3),m3h3x4(:,15),heltab2x12(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(3),25,0,G2H4(13),n2h4(3))
  call Hloop_AW_Q(ntryL,G1H12(12),ex4(:),G1H4(3),m3h3x4(:,16),heltab2x12(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(3),25,0,G2H4(14),n2h4(4))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(3),mass5set(:,1),  & 
G1H6(5),G1H6(6),G1H6(7),G1H6(8),G1H6(9),G1H6(10),6)
  call HG1shiftOLR(G1H6(6),8,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(3),mass5set(:,2),  & 
G1H6(11),G1H6(12),G1H6(13),G1H6(14),G1H6(15),G1H6(16),6)
  call HG1shiftOLR(G1H6(12),8,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(4),mass5set(:,1),  & 
G1H6(17),G1H6(18),G1H6(19),G1H6(20),G1H6(21),G1H6(22),6)
  call HG1shiftOLR(G1H6(18),8,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(4),mass5set(:,3),  & 
G1H6(23),G1H6(24),G1H6(25),G1H6(26),G1H6(27),G1H6(28),6)
  call HG1shiftOLR(G1H6(24),8,6)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(5),mass5set(:,1),  & 
G1H6(29),G1H6(30),G1H6(31),G1H6(32),G1H6(33),G1H6(34),6)
  call HG1shiftOLR(G1H6(30),8,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(5),mass5set(:,2),  & 
G1H6(35),G1H6(36),G1H6(37),G1H6(38),G1H6(39),G1H6(40),6)
  call HG1shiftOLR(G1H6(36),8,6)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(6),mass5set(:,1),  & 
G1H6(41),G1H6(42),G1H6(43),G1H6(44),G1H6(45),G1H6(46),6)
  call HG1shiftOLR(G1H6(42),4,6)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(6),mass5set(:,3),  & 
G1H6(47),G1H6(48),G1H6(49),G1H6(50),G1H6(51),G1H6(52),6)
  call HG1shiftOLR(G1H6(48),4,6)
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(7),mass5set(:,1),  & 
G1H6(53),G1H6(54),G1H6(55),G1H6(56),G1H6(57),G1H6(58),6)
  call HG1shiftOLR(G1H6(54),8,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(7),mass5set(:,3),  & 
G1H6(59),G1H6(60),G1H6(61),G1H6(62),G1H6(63),G1H6(64),6)
  call HG1shiftOLR(G1H6(60),8,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(8),mass5set(:,1),  & 
G1H6(65),G1H6(66),G1H6(67),G1H6(68),G1H6(69),G1H6(70),6)
  call HG1shiftOLR(G1H6(66),4,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(8),mass5set(:,3),  & 
G1H6(71),G1H6(72),G1H6(73),G1H6(74),G1H6(75),G1H6(76),6)
  call HG1shiftOLR(G1H6(72),4,6)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(9),mass5set(:,4),  & 
G1H4(3),G1H4(4),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(4),4,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(9),mass5set(:,5),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(10),4,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(9),mass5set(:,6),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),4,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(9),mass5set(:,7),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),4,4)
  call Hloop_SV_V(ntryL,G1H6(1),ex4(:),G1H2(1),m3h3x2(:,1),heltab2x6(:,:,1))
  call Hloop_SV_V(ntryL,G1H6(2),ex4(:),G1H2(2),m3h3x2(:,2),heltab2x6(:,:,2))
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(1),mass5set(:,8),  & 
G1H6(1),G1H6(2),G1H6(77),G1H6(78),G1H6(79),G1H6(80),6)
  call HG1shiftOLR(G1H6(2),2,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(1),mass5set(:,9),  & 
G1H6(81),G1H6(82),G1H6(83),G1H6(84),G1H6(85),G1H6(86),6)
  call HG1shiftOLR(G1H6(82),2,6)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(10),mass5set(:,5),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),4,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(10),mass5set(:,4),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),4,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(10),mass5set(:,7),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),4,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(10),mass5set(:,6),  & 
G1H4(45),G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(46),4,4)
  call Hloop_SV_V(ntryL,G1H4(1),ex3(:),G1H2(3),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_SV_V(ntryL,G1H4(2),ex3(:),G1H2(4),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(2),mass5set(:,10),  & 
G1H4(1),G1H4(2),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(2),2,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(2),mass5set(:,11),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),2,4)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(1),mass5set(:,1),  & 
G1H6(87),G1H6(88),G1H6(89),G1H6(90),G1H6(91),G1H6(92),6)
  call HG1shiftOLR(G1H6(88),2,6)
  call Hotf_4pt_reduction(G2H6(17),RedSet_4(1),mass4set(:,1),  & 
G1H6(93),G1H6(94),G1H6(95),G1H6(96),G1H6(97),6)
  call HG1shiftOLR(G1H6(94),2,6)
  call Hotf_4pt_reduction(G2H6(18),RedSet_4(2),mass4set(:,1),  & 
G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),6)
  call HG1shiftOLR(G1H6(99),10,6)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(2),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),2,4)
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(1),mass4set(:,1),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),4)
  call HG1shiftOLR(G1H4(68),2,4)
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(3),mass4set(:,1),  & 
G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(73),6,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(93),[G1H6(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(98),[G1H6(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(66)])
  call Hloop_VQ_A(ntryL,G1H6(5),ex2(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(6),1,1,6)
call HGT_invQ_OLR(G1H6(6),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(6),-8,0,G2H6(1),n2h6(13))
  call Hloop_AW_Q(ntryL,G2H6(1),ex4(:),G2H2(1),m3h3x2(:,3),heltab2x6(:,:,4))
  call Hloop_VQ_A(ntryL,G1H6(9),ex2(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(2),n2h3(2))
  call Hloop_VQ_A(ntryL,G1H6(10),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,6))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(3),n2h3(3))
  call Hloop_ZQ_A(ntryL,G1H6(11),ex2(:),G1H3(1),ngZd,m3h2x3(:,4),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(4),n2h3(4))
call HGT_OLR(G1H6(12),1,1,6)
call HGT_invQ_OLR(G1H6(12),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(12),-8,0,G2H6(2),n2h6(14))
  call Hloop_AW_Q(ntryL,G2H6(2),ex4(:),G2H2(2),m3h3x2(:,4),heltab2x6(:,:,8))
  call Hloop_ZQ_A(ntryL,G1H6(15),ex2(:),G1H3(1),ngZd,m3h2x3(:,5),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(5),n2h3(5))
  call Hloop_ZQ_A(ntryL,G1H6(16),ex2(:),G1H3(1),ngZd,m3h2x3(:,6),heltab2x6(:,:,10))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(6),n2h3(6))
  call Hloop_AV_Q(ntryL,G1H6(17),ex3(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,11))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(7),n2h3(7))
call HGT_OLR(G1H6(18),1,1,6)
call HGT_invQ_OLR(G1H6(18),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(18),-8,0,G2H6(3),n2h6(15))
  call Hloop_QW_A(ntryL,G2H6(3),ex4(:),G2H2(3),m3h3x2(:,5),heltab2x6(:,:,12))
  call Hloop_AV_Q(ntryL,G1H6(21),ex3(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,13))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(8),n2h3(8))
  call Hloop_AV_Q(ntryL,G1H6(22),ex3(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,14))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(9),n2h3(9))
  call Hloop_AV_Q(ntryL,G1H6(23),ex3(:),G1H3(1),m3h2x3(:,10),heltab2x6(:,:,15))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(10),n2h3(10))
call HGT_OLR(G1H6(24),1,1,6)
call HGT_invQ_OLR(G1H6(24),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(24),-8,0,G2H6(4),n2h6(16))
  call Hloop_QW_A(ntryL,G2H6(4),ex4(:),G2H2(4),m3h3x2(:,6),heltab2x6(:,:,16))
  call Hloop_AV_Q(ntryL,G1H6(27),ex3(:),G1H3(1),m3h2x3(:,11),heltab2x6(:,:,17))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(11),n2h3(11))
  call Hloop_AV_Q(ntryL,G1H6(28),ex3(:),G1H3(1),m3h2x3(:,12),heltab2x6(:,:,18))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(12),n2h3(12))
  call Hloop_VA_Q(ntryL,G1H6(29),ex1(:),G1H3(1),m3h2x3(:,13),heltab2x6(:,:,19))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(13),n2h3(13))
call HGT_OLR(G1H6(30),1,1,6)
call HGT_invQ_OLR(G1H6(30),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(30),-8,0,G2H6(5),n2h6(17))
  call Hloop_QW_A(ntryL,G2H6(5),ex4(:),G2H2(5),m3h3x2(:,7),heltab2x6(:,:,20))
  call Hloop_VA_Q(ntryL,G1H6(33),ex1(:),G1H3(1),m3h2x3(:,14),heltab2x6(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(14),n2h3(14))
  call Hloop_VA_Q(ntryL,G1H6(34),ex1(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,22))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(15),n2h3(15))
  call Hloop_ZA_Q(ntryL,G1H6(35),ex1(:),G1H3(1),ngZu,m3h2x3(:,16),heltab2x6(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(16),n2h3(16))
call HGT_OLR(G1H6(36),1,1,6)
call HGT_invQ_OLR(G1H6(36),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(36),-8,0,G2H6(6),n2h6(18))
  call Hloop_QW_A(ntryL,G2H6(6),ex4(:),G2H2(6),m3h3x2(:,8),heltab2x6(:,:,24))
  call Hloop_ZA_Q(ntryL,G1H6(39),ex1(:),G1H3(1),ngZu,m3h2x3(:,17),heltab2x6(:,:,25))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(17),n2h3(17))
  call Hloop_ZA_Q(ntryL,G1H6(40),ex1(:),G1H3(1),ngZu,m3h2x3(:,18),heltab2x6(:,:,26))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(18),n2h3(18))
  call Hloop_AW_Q(ntryL,G1H6(41),ex4(:),G1H2(5),m3h3x2(:,9),heltab2x6(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(7),n2h2(1))
call HGT_OLR(G1H6(42),1,1,6)
call HGT_invQ_OLR(G1H6(42),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(42),-4,0,G2H6(7),n2h6(19))
  call Hloop_QV_A(ntryL,G2H6(7),ex3(:),G2H3(19),m3h2x3(:,19),heltab2x6(:,:,28))
  call Hloop_AW_Q(ntryL,G1H6(45),ex4(:),G1H2(5),m3h3x2(:,10),heltab2x6(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(8),n2h2(2))
  call Hloop_AW_Q(ntryL,G1H6(46),ex4(:),G1H2(5),m3h3x2(:,11),heltab2x6(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(9),n2h2(3))
  call Hloop_AW_Q(ntryL,G1H6(47),ex4(:),G1H2(5),m3h3x2(:,12),heltab2x6(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(10),n2h2(4))
call HGT_OLR(G1H6(48),1,1,6)
call HGT_invQ_OLR(G1H6(48),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(48),-4,0,G2H6(8),n2h6(20))
  call Hloop_QV_A(ntryL,G2H6(8),ex3(:),G2H3(20),m3h2x3(:,20),heltab2x6(:,:,32))
  call Hloop_AW_Q(ntryL,G1H6(51),ex4(:),G1H2(5),m3h3x2(:,13),heltab2x6(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(11),n2h2(5))
  call Hloop_AW_Q(ntryL,G1H6(52),ex4(:),G1H2(5),m3h3x2(:,14),heltab2x6(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(12),n2h2(6))
  call Hloop_QV_A(ntryL,G1H6(53),ex3(:),G1H3(1),m3h2x3(:,21),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(21),n2h3(19))
call HGT_OLR(G1H6(54),1,1,6)
call HGT_invQ_OLR(G1H6(54),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(54),-8,0,G2H6(9),n2h6(21))
  call Hloop_AW_Q(ntryL,G2H6(9),ex4(:),G2H2(13),m3h3x2(:,15),heltab2x6(:,:,36))
  call Hloop_QV_A(ntryL,G1H6(57),ex3(:),G1H3(1),m3h2x3(:,22),heltab2x6(:,:,37))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(22),n2h3(20))
  call Hloop_QV_A(ntryL,G1H6(58),ex3(:),G1H3(1),m3h2x3(:,23),heltab2x6(:,:,38))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(23),n2h3(21))
  call Hloop_QV_A(ntryL,G1H6(59),ex3(:),G1H3(1),m3h2x3(:,24),heltab2x6(:,:,39))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(24),n2h3(22))
call HGT_OLR(G1H6(60),1,1,6)
call HGT_invQ_OLR(G1H6(60),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(60),-8,0,G2H6(10),n2h6(22))
  call Hloop_AW_Q(ntryL,G2H6(10),ex4(:),G2H2(14),m3h3x2(:,16),heltab2x6(:,:,40))
  call Hloop_QV_A(ntryL,G1H6(63),ex3(:),G1H3(1),m3h2x3(:,25),heltab2x6(:,:,41))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(25),n2h3(23))
  call Hloop_QV_A(ntryL,G1H6(64),ex3(:),G1H3(1),m3h2x3(:,26),heltab2x6(:,:,42))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(26),n2h3(24))
  call Hloop_QW_A(ntryL,G1H6(65),ex4(:),G1H2(5),m3h3x2(:,17),heltab2x6(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(15),n2h2(7))
call HGT_OLR(G1H6(66),1,1,6)
call HGT_invQ_OLR(G1H6(66),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(66),-4,0,G2H6(11),n2h6(23))
  call Hloop_AV_Q(ntryL,G2H6(11),ex3(:),G2H3(27),m3h2x3(:,27),heltab2x6(:,:,44))
  call Hloop_QW_A(ntryL,G1H6(69),ex4(:),G1H2(5),m3h3x2(:,18),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(16),n2h2(8))
  call Hloop_QW_A(ntryL,G1H6(70),ex4(:),G1H2(5),m3h3x2(:,19),heltab2x6(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(17),n2h2(9))
  call Hloop_QW_A(ntryL,G1H6(71),ex4(:),G1H2(5),m3h3x2(:,20),heltab2x6(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(18),n2h2(10))
call HGT_OLR(G1H6(72),1,1,6)
call HGT_invQ_OLR(G1H6(72),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(72),-4,0,G2H6(12),n2h6(24))
  call Hloop_AV_Q(ntryL,G2H6(12),ex3(:),G2H3(28),m3h2x3(:,28),heltab2x6(:,:,48))
  call Hloop_QW_A(ntryL,G1H6(75),ex4(:),G1H2(5),m3h3x2(:,21),heltab2x6(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(19),n2h2(11))
  call Hloop_QW_A(ntryL,G1H6(76),ex4(:),G1H2(5),m3h3x2(:,22),heltab2x6(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(20),n2h2(12))
  call Hloop_VA_Q(ntryL,G1H4(3),ex1(:),G1H2(5),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(21),n2h2(13))
call HGT_OLR(G1H4(4),1,1,4)
call HGT_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(4),-4,0,G2H4(1),n2h4(5))
  call Hloop_QV_A(ntryL,G2H4(1),ex3(:),G2H2(22),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VA_Q(ntryL,G1H4(7),ex1(:),G1H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(23),n2h2(14))
  call Hloop_VA_Q(ntryL,G1H4(8),ex1(:),G1H2(5),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(24),n2h2(15))
  call Hloop_WA_Q(ntryL,G1H4(9),ex1(:),G1H2(5),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(25),n2h2(16))
call HGT_OLR(G1H4(10),1,1,4)
call HGT_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(10),-4,0,G2H4(2),n2h4(6))
  call Hloop_QV_A(ntryL,G2H4(2),ex3(:),G2H2(26),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_WA_Q(ntryL,G1H4(13),ex1(:),G1H2(5),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(27),n2h2(17))
  call Hloop_WA_Q(ntryL,G1H4(14),ex1(:),G1H2(5),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(28),n2h2(18))
  call Hloop_ZA_Q(ntryL,G1H4(15),ex1(:),G1H2(5),ngZu,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(29),n2h2(19))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(16),-4,0,G2H4(3),n2h4(7))
  call Hloop_QV_A(ntryL,G2H4(3),ex3(:),G2H2(30),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_ZA_Q(ntryL,G1H4(19),ex1(:),G1H2(5),ngZu,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(31),n2h2(20))
  call Hloop_ZA_Q(ntryL,G1H4(20),ex1(:),G1H2(5),ngZu,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(32),n2h2(21))
  call Hloop_WA_Q(ntryL,G1H4(21),ex1(:),G1H2(5),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(33),n2h2(22))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(22),-4,0,G2H4(4),n2h4(8))
  call Hloop_QV_A(ntryL,G2H4(4),ex3(:),G2H2(34),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_WA_Q(ntryL,G1H4(25),ex1(:),G1H2(5),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(35),n2h2(23))
  call Hloop_WA_Q(ntryL,G1H4(26),ex1(:),G1H2(5),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(36),n2h2(24))
  call Hloop_UW_V(ntryL,G1H6(1),21,ex4(:),8,G2H2(37),m3h3x2(:,23),heltab2x6(:,:,51))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(2),-2,0,G2H6(13),n2h6(25))
  call Hloop_AQ_V(ntryL,G2H6(13),ex2(:),G2H3(29),m3h2x3(:,29),heltab2x6(:,:,52))
  call Hloop_UW_V(ntryL,G1H6(79),21,ex4(:),8,G2H2(38),m3h3x2(:,24),heltab2x6(:,:,53))
  call Hloop_UW_V(ntryL,G1H6(80),21,ex4(:),8,G2H2(39),m3h3x2(:,25),heltab2x6(:,:,54))
  call Hloop_UW_V(ntryL,G1H6(81),21,ex4(:),8,G2H2(40),m3h3x2(:,26),heltab2x6(:,:,55))
call HGT_OLR(G1H6(82),1,1,6)
call HGT_invQ_OLR(G1H6(82),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(82),-2,0,G2H6(14),n2h6(26))
  call Hloop_AQ_Z(ntryL,G2H6(14),ex2(:),G2H3(30),ngZd,m3h2x3(:,30),heltab2x6(:,:,56))
  call Hloop_UW_V(ntryL,G1H6(85),21,ex4(:),8,G2H2(41),m3h3x2(:,27),heltab2x6(:,:,57))
  call Hloop_UW_V(ntryL,G1H6(86),21,ex4(:),8,G2H2(42),m3h3x2(:,28),heltab2x6(:,:,58))
  call Hloop_WQ_A(ntryL,G1H4(27),ex2(:),G1H2(5),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(43),n2h2(25))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(28),-4,0,G2H4(5),n2h4(9))
  call Hloop_AV_Q(ntryL,G2H4(5),ex3(:),G2H2(44),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_WQ_A(ntryL,G1H4(31),ex2(:),G1H2(5),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(45),n2h2(26))
  call Hloop_WQ_A(ntryL,G1H4(32),ex2(:),G1H2(5),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(46),n2h2(27))
  call Hloop_VQ_A(ntryL,G1H4(33),ex2(:),G1H2(5),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(47),n2h2(28))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(34),-4,0,G2H4(6),n2h4(10))
  call Hloop_AV_Q(ntryL,G2H4(6),ex3(:),G2H2(48),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_VQ_A(ntryL,G1H4(37),ex2(:),G1H2(5),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(49),n2h2(29))
  call Hloop_VQ_A(ntryL,G1H4(38),ex2(:),G1H2(5),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(50),n2h2(30))
  call Hloop_WQ_A(ntryL,G1H4(39),ex2(:),G1H2(5),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(51),n2h2(31))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(40),-4,0,G2H4(7),n2h4(11))
  call Hloop_AV_Q(ntryL,G2H4(7),ex3(:),G2H2(52),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_WQ_A(ntryL,G1H4(43),ex2(:),G1H2(5),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(53),n2h2(32))
  call Hloop_WQ_A(ntryL,G1H4(44),ex2(:),G1H2(5),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(54),n2h2(33))
  call Hloop_ZQ_A(ntryL,G1H4(45),ex2(:),G1H2(5),ngZd,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(55),n2h2(34))
call HGT_OLR(G1H4(46),1,1,4)
call HGT_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(46),-4,0,G2H4(8),n2h4(12))
  call Hloop_AV_Q(ntryL,G2H4(8),ex3(:),G2H2(56),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_ZQ_A(ntryL,G1H4(49),ex2(:),G1H2(5),ngZd,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(57),n2h2(35))
  call Hloop_ZQ_A(ntryL,G1H4(50),ex2(:),G1H2(5),ngZd,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(58),n2h2(36))
  call Hloop_UW_V(ntryL,G1H4(1),25,ex3(:),4,G2H2(59),m3h2x2(:,35),heltab2x4(:,:,35))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(2),-2,0,G2H4(9),n2h4(13))
  call Hloop_AQ_W(ntryL,G2H4(9),ex2(:),G2H2(60),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_UW_V(ntryL,G1H4(53),25,ex3(:),4,G2H2(61),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_UW_V(ntryL,G1H4(54),25,ex3(:),4,G2H2(62),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_UW_V(ntryL,G1H4(55),25,ex3(:),4,G2H2(63),m3h2x2(:,39),heltab2x4(:,:,39))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-2,0,G2H4(10),n2h4(14))
  call Hloop_AQ_W(ntryL,G2H4(10),ex2(:),G2H2(64),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_UW_V(ntryL,G1H4(59),25,ex3(:),4,G2H2(65),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_UW_V(ntryL,G1H4(60),25,ex3(:),4,G2H2(66),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AW_Q(ntryL,G1H6(87),ex4(:),G1H2(5),m3h3x2(:,29),heltab2x6(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(5),29,0,G2H2(67),n2h2(37))
call HGT_raise_alpha_OLR(G1H6(88),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(88),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(88),ex2(:),G1H3(1),m3h2x3(:,31),heltab2x6(:,:,60))
  call Hloop_AW_Q(ntryL,G1H6(93),ex4(:),G1H2(5),m3h3x2(:,30),heltab2x6(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(5),29,0,G2H2(68),n2h2(38))
  call Hloop_AW_Q(ntryL,G1H6(98),ex4(:),G1H2(5),m3h3x2(:,31),heltab2x6(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(5),29,0,G2H2(69),n2h2(39))
call HGT_raise_alpha_OLR(G1H6(94),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(94),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(94),ex2(:),G1H3(2),m3h2x3(:,32),heltab2x6(:,:,63))
  call Hloop_AW_Q(ntryL,G1H6(97),ex4(:),G1H2(5),m3h3x2(:,32),heltab2x6(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(5),29,0,G2H2(70),n2h2(40))
call HGT_raise_alpha_OLR(G1H6(99),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(99),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(99),ex2(:),G1H3(3),m3h2x3(:,33),heltab2x6(:,:,65))
  call Hloop_AW_Q(ntryL,G1H6(102),ex4(:),G1H2(5),m3h3x2(:,33),heltab2x6(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(5),29,0,G2H2(71),n2h2(41))
  call Hloop_AV_Q(ntryL,G1H4(61),ex3(:),G1H2(5),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(5),29,0,G2H2(72),n2h2(42))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(62),ex2(:),G1H2(5),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AV_Q(ntryL,G1H4(67),ex3(:),G1H2(6),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(6),29,0,G2H2(73),n2h2(43))
  call Hloop_AV_Q(ntryL,G1H4(72),ex3(:),G1H2(6),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(6),29,0,G2H2(74),n2h2(44))
call HGT_raise_alpha_OLR(G1H4(68),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(68),ex2(:),G1H2(6),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AV_Q(ntryL,G1H4(71),ex3(:),G1H2(7),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(7),29,0,G2H2(75),n2h2(45))
call HGT_raise_alpha_OLR(G1H4(73),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(73),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(73),ex2(:),G1H2(7),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AV_Q(ntryL,G1H4(76),ex3(:),G1H2(8),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(8),29,0,G2H2(76),n2h2(46))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G1H2(4)])
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(1),mass5set(:,8),  & 
G1H2(8),G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(9),2)
  call HG1shiftOLR(G1H2(1),2,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(1),mass5set(:,9),  & 
G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(11),2,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(2),mass5set(:,10),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),2)
  call HG1shiftOLR(G1H2(17),2,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(2),mass5set(:,11),  & 
G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),2)
  call HG1shiftOLR(G1H2(23),2,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(3),mass5set(:,1),  & 
G1H3(4),G1H3(5),G1H3(6),G1H3(7),G1H3(8),G1H3(9),3)
  call HG1shiftOLR(G1H3(5),8,3)
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(4),mass4set(:,1),  & 
G1H3(10),G1H3(11),G1H3(12),G1H3(13),G1H3(14),3)
  call HG1shiftOLR(G1H3(11),10,3)
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(3),mass5set(:,2),  & 
G1H3(15),G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),3)
  call HG1shiftOLR(G1H3(16),8,3)
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(4),mass4set(:,2),  & 
G1H3(21),G1H3(22),G1H3(23),G1H3(24),G1H3(25),3)
  call HG1shiftOLR(G1H3(22),10,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(4),mass5set(:,1),  & 
G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),G1H3(31),3)
  call HG1shiftOLR(G1H3(27),8,3)
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(5),mass4set(:,1),  & 
G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(33),12,3)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(4),mass5set(:,3),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),3)
  call HG1shiftOLR(G1H3(38),8,3)
  call Hotf_4pt_reduction(G2H3(12),RedSet_4(5),mass4set(:,3),  & 
G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),3)
  call HG1shiftOLR(G1H3(44),12,3)
  call Hotf_5pt_reduction(G2H3(13),RedSet_5(5),mass5set(:,1),  & 
G1H3(48),G1H3(49),G1H3(50),G1H3(51),G1H3(52),G1H3(53),3)
  call HG1shiftOLR(G1H3(49),8,3)
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(6),mass4set(:,1),  & 
G1H3(54),G1H3(55),G1H3(56),G1H3(57),G1H3(58),3)
  call HG1shiftOLR(G1H3(55),9,3)
  call Hotf_5pt_reduction(G2H3(16),RedSet_5(5),mass5set(:,2),  & 
G1H3(59),G1H3(60),G1H3(61),G1H3(62),G1H3(63),G1H3(64),3)
  call HG1shiftOLR(G1H3(60),8,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(6),mass4set(:,2),  & 
G1H3(65),G1H3(66),G1H3(67),G1H3(68),G1H3(69),3)
  call HG1shiftOLR(G1H3(66),9,3)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(6),mass5set(:,1),  & 
G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(29),4,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(5),mass4set(:,1),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(35),12,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(6),mass5set(:,3),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),4,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(5),mass4set(:,3),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),2)
  call HG1shiftOLR(G1H2(46),12,2)
  call Hotf_5pt_reduction(G2H3(21),RedSet_5(7),mass5set(:,1),  & 
G1H3(70),G1H3(71),G1H3(72),G1H3(73),G1H3(74),G1H3(75),3)
  call HG1shiftOLR(G1H3(71),8,3)
  call Hotf_4pt_reduction(G2H3(23),RedSet_4(7),mass4set(:,1),  & 
G1H3(76),G1H3(77),G1H3(78),G1H3(79),G1H3(80),3)
  call HG1shiftOLR(G1H3(77),12,3)
  call Hotf_5pt_reduction(G2H3(24),RedSet_5(7),mass5set(:,3),  & 
G1H3(81),G1H3(82),G1H3(83),G1H3(84),G1H3(85),G1H3(86),3)
  call HG1shiftOLR(G1H3(82),8,3)
  call Hotf_4pt_reduction(G2H3(26),RedSet_4(7),mass4set(:,3),  & 
G1H3(87),G1H3(88),G1H3(89),G1H3(90),G1H3(91),3)
  call HG1shiftOLR(G1H3(88),12,3)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(8),mass5set(:,1),  & 
G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
  call HG1shiftOLR(G1H2(51),4,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(7),mass4set(:,1),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(57),12,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(8),mass5set(:,3),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),4,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(7),mass4set(:,3),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),2)
  call HG1shiftOLR(G1H2(68),12,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(9),mass5set(:,4),  & 
G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),2)
  call HG1shiftOLR(G1H2(73),4,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(8),mass4set(:,4),  & 
G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),2)
  call HG1shiftOLR(G1H2(79),5,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(9),mass5set(:,5),  & 
G1H2(83),G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(84),4,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(8),mass4set(:,5),  & 
G1H2(89),G1H2(90),G1H2(91),G1H2(92),G1H2(93),2)
  call HG1shiftOLR(G1H2(90),5,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(9),mass5set(:,6),  & 
G1H2(94),G1H2(95),G1H2(96),G1H2(97),G1H2(98),G1H2(99),2)
  call HG1shiftOLR(G1H2(95),4,2)
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(8),mass4set(:,6),  & 
G1H2(100),G1H2(101),G1H2(102),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(101),5,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(9),mass5set(:,7),  & 
G1H2(105),G1H2(106),G1H2(107),G1H2(108),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(106),4,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(8),mass4set(:,7),  & 
G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),2)
  call HG1shiftOLR(G1H2(112),5,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(2),mass4set(:,8),  & 
G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(117),10,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(2),mass4set(:,8),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),2)
  call HG1shiftOLR(G1H2(122),10,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(10),mass5set(:,5),  & 
G1H2(126),G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),2)
  call HG1shiftOLR(G1H2(127),4,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(3),mass4set(:,5),  & 
G1H2(132),G1H2(133),G1H2(134),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(133),6,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(10),mass5set(:,4),  & 
G1H2(137),G1H2(138),G1H2(139),G1H2(140),G1H2(141),G1H2(142),2)
  call HG1shiftOLR(G1H2(138),4,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(3),mass4set(:,4),  & 
G1H2(143),G1H2(144),G1H2(145),G1H2(146),G1H2(147),2)
  call HG1shiftOLR(G1H2(144),6,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(10),mass5set(:,7),  & 
G1H2(148),G1H2(149),G1H2(150),G1H2(151),G1H2(152),G1H2(153),2)
  call HG1shiftOLR(G1H2(149),4,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(3),mass4set(:,7),  & 
G1H2(154),G1H2(155),G1H2(156),G1H2(157),G1H2(158),2)
  call HG1shiftOLR(G1H2(155),6,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(10),mass5set(:,6),  & 
G1H2(159),G1H2(160),G1H2(161),G1H2(162),G1H2(163),G1H2(164),2)
  call HG1shiftOLR(G1H2(160),4,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(3),mass4set(:,6),  & 
G1H2(165),G1H2(166),G1H2(167),G1H2(168),G1H2(169),2)
  call HG1shiftOLR(G1H2(166),6,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(3),mass4set(:,5),  & 
G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(171),6,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(3),mass4set(:,7),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),2)
  call HG1shiftOLR(G1H2(176),6,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(67),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(69),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(72),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(74),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(116),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(121),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(170),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(175),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(10),[G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(21),[G1H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(32),[G1H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(43),[G1H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(54),[G1H3(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(65),[G1H3(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(34),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(76),[G1H3(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(87),[G1H3(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(56),[G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(67),[G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(78),[G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(89),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(100),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(111),[G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(132),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(143),[G1H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(165),[G1H2(164)])
  call Hloop_VQ_A(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(6),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(116),ex2(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(3))
  call Hloop_ZQ_A(ntryL,G1H2(10),ex2(:),G1H1(1),ngZd,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(4))
  call Hloop_ZQ_A(ntryL,G1H2(11),ex2(:),G1H1(1),ngZd,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(9),n2h1(5))
  call Hloop_ZQ_A(ntryL,G1H2(121),ex2(:),G1H1(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(6))
  call Hloop_WQ_A(ntryL,G1H2(16),ex2(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(7))
  call Hloop_WQ_A(ntryL,G1H2(17),ex2(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(12),n2h1(8))
  call Hloop_WQ_A(ntryL,G1H2(170),ex2(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(9))
  call Hloop_WQ_A(ntryL,G1H2(22),ex2(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(10))
  call Hloop_WQ_A(ntryL,G1H2(23),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(15),n2h1(11))
  call Hloop_WQ_A(ntryL,G1H2(175),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(12))
  call Hloop_QW_A(ntryL,G1H3(4),ex4(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(13))
  call Hloop_QW_A(ntryL,G1H3(5),ex4(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(18),n2h1(14))
  call Hloop_QW_A(ntryL,G1H3(10),ex4(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(15))
  call Hloop_QW_A(ntryL,G1H3(11),ex4(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(20),n2h1(16))
  call Hloop_QW_A(ntryL,G1H3(15),ex4(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(17))
  call Hloop_QW_A(ntryL,G1H3(16),ex4(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(22),n2h1(18))
  call Hloop_QW_A(ntryL,G1H3(21),ex4(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(19))
  call Hloop_QW_A(ntryL,G1H3(22),ex4(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(24),n2h1(20))
  call Hloop_AW_Q(ntryL,G1H3(26),ex4(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(21))
  call Hloop_AW_Q(ntryL,G1H3(27),ex4(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(26),n2h1(22))
  call Hloop_AW_Q(ntryL,G1H3(32),ex4(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(23))
  call Hloop_AW_Q(ntryL,G1H3(33),ex4(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(28),n2h1(24))
  call Hloop_AW_Q(ntryL,G1H3(37),ex4(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(25))
  call Hloop_AW_Q(ntryL,G1H3(38),ex4(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(30),n2h1(26))
  call Hloop_AW_Q(ntryL,G1H3(43),ex4(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(27))
  call Hloop_AW_Q(ntryL,G1H3(44),ex4(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(32),n2h1(28))
  call Hloop_AW_Q(ntryL,G1H3(48),ex4(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(29))
  call Hloop_AW_Q(ntryL,G1H3(49),ex4(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(34),n2h1(30))
  call Hloop_AW_Q(ntryL,G1H3(54),ex4(:),G1H1(1),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(31))
  call Hloop_AW_Q(ntryL,G1H3(55),ex4(:),G1H1(1),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(36),n2h1(32))
  call Hloop_AW_Q(ntryL,G1H3(59),ex4(:),G1H1(1),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(33))
  call Hloop_AW_Q(ntryL,G1H3(60),ex4(:),G1H1(1),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(38),n2h1(34))
  call Hloop_AW_Q(ntryL,G1H3(65),ex4(:),G1H1(1),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(35))
  call Hloop_AW_Q(ntryL,G1H3(66),ex4(:),G1H1(1),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(40),n2h1(36))
  call Hloop_AV_Q(ntryL,G1H2(28),ex3(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(37))
  call Hloop_AV_Q(ntryL,G1H2(29),ex3(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(42),n2h1(38))
  call Hloop_AV_Q(ntryL,G1H2(34),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(39))
  call Hloop_AV_Q(ntryL,G1H2(35),ex3(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(44),n2h1(40))
  call Hloop_AV_Q(ntryL,G1H2(39),ex3(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H2(40),ex3(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(46),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H2(45),ex3(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H2(46),ex3(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(48),n2h1(44))
  call Hloop_QW_A(ntryL,G1H3(70),ex4(:),G1H1(1),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(45))
  call Hloop_QW_A(ntryL,G1H3(71),ex4(:),G1H1(1),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(50),n2h1(46))
  call Hloop_QW_A(ntryL,G1H3(76),ex4(:),G1H1(1),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(47))
  call Hloop_QW_A(ntryL,G1H3(77),ex4(:),G1H1(1),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(52),n2h1(48))
  call Hloop_QW_A(ntryL,G1H3(81),ex4(:),G1H1(1),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(49))
  call Hloop_QW_A(ntryL,G1H3(82),ex4(:),G1H1(1),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(54),n2h1(50))
  call Hloop_QW_A(ntryL,G1H3(87),ex4(:),G1H1(1),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(51))
  call Hloop_QW_A(ntryL,G1H3(88),ex4(:),G1H1(1),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(56),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(58),n2h1(54))
  call Hloop_QV_A(ntryL,G1H2(56),ex3(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(55))
  call Hloop_QV_A(ntryL,G1H2(57),ex3(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(60),n2h1(56))
  call Hloop_QV_A(ntryL,G1H2(61),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(57))
  call Hloop_QV_A(ntryL,G1H2(62),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(62),n2h1(58))
  call Hloop_QV_A(ntryL,G1H2(67),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(68),ex3(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(64),n2h1(60))
  call Hloop_AV_Q(ntryL,G1H2(72),ex3(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H2(73),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(66),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H2(78),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(63))
  call Hloop_AV_Q(ntryL,G1H2(79),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(68),n2h1(64))
  call Hloop_AV_Q(ntryL,G1H2(83),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H2(84),ex3(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(70),n2h1(66))
  call Hloop_AV_Q(ntryL,G1H2(89),ex3(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(67))
  call Hloop_AV_Q(ntryL,G1H2(90),ex3(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(72),n2h1(68))
  call Hloop_AV_Q(ntryL,G1H2(94),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(69))
  call Hloop_AV_Q(ntryL,G1H2(95),ex3(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(74),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H2(100),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H2(101),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(76),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H2(105),ex3(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(73))
  call Hloop_AV_Q(ntryL,G1H2(106),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(78),n2h1(74))
  call Hloop_AV_Q(ntryL,G1H2(111),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(75))
  call Hloop_AV_Q(ntryL,G1H2(112),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(80),n2h1(76))
  call Hloop_VQ_A(ntryL,G1H2(117),ex2(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(81),n2h1(77))
  call Hloop_ZQ_A(ntryL,G1H2(122),ex2(:),G1H1(1),ngZd,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(82),n2h1(78))
  call Hloop_QV_A(ntryL,G1H2(126),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(84),n2h1(80))
  call Hloop_QV_A(ntryL,G1H2(132),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(81))
  call Hloop_QV_A(ntryL,G1H2(133),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(86),n2h1(82))
  call Hloop_QV_A(ntryL,G1H2(137),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(138),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(88),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(143),ex3(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(144),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(90),n2h1(86))
  call Hloop_QV_A(ntryL,G1H2(148),ex3(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(87))
  call Hloop_QV_A(ntryL,G1H2(149),ex3(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(92),n2h1(88))
  call Hloop_QV_A(ntryL,G1H2(154),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(89))
  call Hloop_QV_A(ntryL,G1H2(155),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(94),n2h1(90))
  call Hloop_QV_A(ntryL,G1H2(159),ex3(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(91))
  call Hloop_QV_A(ntryL,G1H2(160),ex3(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(96),n2h1(92))
  call Hloop_QV_A(ntryL,G1H2(165),ex3(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(93))
  call Hloop_QV_A(ntryL,G1H2(166),ex3(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(98),n2h1(94))
  call Hloop_WQ_A(ntryL,G1H2(171),ex2(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(99),n2h1(95))
  call Hloop_WQ_A(ntryL,G1H2(176),ex2(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(100),n2h1(96))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,8),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),2)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(1),mass5set(:,9),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),2)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(2),mass5set(:,10),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),2)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(2),mass5set(:,11),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(3),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(3),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(4),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(4),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(5),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(5),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(6),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),4)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(6),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(7),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(7),mass5set(:,3),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(8),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(8),mass5set(:,3),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(9),mass5set(:,4),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),4)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(9),mass5set(:,5),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),4)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(9),mass5set(:,6),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),4)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(9),mass5set(:,7),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(10),mass5set(:,5),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(10),mass5set(:,4),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(10),mass5set(:,7),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(10),mass5set(:,6),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(37),h0tab(:,37),[16,1,12,2],[0,0,nMW,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,37),heltab2x48(:,:,37))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(1),n2h24(35))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(38),h0tab(:,38),[16,1,12,2],[0,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,38),heltab2x48(:,:,38))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(4),n2h24(36))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(39),h0tab(:,39),[16,1,12,2],[0,nMZ,nMW,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,39),heltab2x48(:,:,39))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(7),n2h24(37))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(40),h0tab(:,40),[16,1,12,2],[0,nMW,nMZ,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,40),heltab2x48(:,:,40))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(10),n2h24(38))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(41),h0tab(:,41),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(13),m3h2x24(:,41),heltab2x48(:,:,41))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(42),h0tab(:,42),[16,2,8,5],[0,nMW,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,42),heltab2x48(:,:,42))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(16),n2h24(39))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(43),h0tab(:,43),[16,2,8,5],[0,0,nMW,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,43),heltab2x48(:,:,43))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(3),n2h24(40))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(44),h0tab(:,44),[16,2,8,5],[0,nMW,nMZ,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,44),heltab2x48(:,:,44))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(2),n2h24(41))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(45),h0tab(:,45),[16,2,8,5],[0,nMZ,nMW,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,45),heltab2x48(:,:,45))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(6),n2h24(42))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(46),h0tab(:,46),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,46),heltab2x48(:,:,46))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(5),n2h24(43))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(47),h0tab(:,47),[16,5,2,8],[0,nMZ,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,47),heltab2x48(:,:,47))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(9),n2h24(44))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(48),h0tab(:,48),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,48),heltab2x48(:,:,48))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(8),n2h24(45))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(49),h0tab(:,49),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,49),heltab2x48(:,:,49))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(12),n2h24(46))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(50),h0tab(:,50),[16,2,5,8],[0,nMZ,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,50),heltab2x48(:,:,50))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(11),n2h24(47))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(51),h0tab(:,51),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,51),heltab2x48(:,:,51))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(15),n2h24(48))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(52),h0tab(:,52),[16,1,8,6],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(14),m3h2x24(:,52),heltab2x48(:,:,52))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(53),h0tab(:,53),[16,1,8,6],[0,0,nMW,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,53),heltab2x48(:,:,53))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(18),n2h24(49))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(54),h0tab(:,54),[16,1,8,6],[0,nMW,0,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,54),heltab2x48(:,:,54))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(17),n2h24(50))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(55),h0tab(:,55),[16,1,8,6],[0,nMZ,nMW,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,55),heltab2x48(:,:,55))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(19),n2h24(51))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(56),h0tab(:,56),[16,1,8,6],[0,nMW,nMZ,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,56),heltab2x48(:,:,56))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(20),n2h24(52))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(57),h0tab(:,57),[16,6,1,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,57),heltab2x48(:,:,57))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(21),n2h24(53))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(58),h0tab(:,58),[16,6,1,8],[0,nMZ,0,0],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,58),heltab2x48(:,:,58))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(22),n2h24(54))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(59),h0tab(:,59),[16,6,1,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,59),heltab2x48(:,:,59))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(23),n2h24(55))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(60),h0tab(:,60),[16,1,6,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,60),heltab2x48(:,:,60))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(24),n2h24(56))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(61),h0tab(:,61),[16,1,6,8],[0,nMZ,0,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,61),heltab2x48(:,:,61))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(25),n2h24(57))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(62),h0tab(:,62),[16,1,6,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,62),heltab2x48(:,:,62))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(26),n2h24(58))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(63),h0tab(:,63),[16,2,4,9],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(27),m3h2x24(:,63),heltab2x48(:,:,63))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(64),h0tab(:,64),[16,2,4,9],[0,nMW,nMW,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,64),heltab2x48(:,:,64))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(28),n2h24(59))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(65),h0tab(:,65),[16,4,2,9],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,65),heltab2x48(:,:,65))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(29),n2h24(60))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(66),h0tab(:,66),[16,4,2,9],[0,0,nMZ,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,66),heltab2x48(:,:,66))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(30),n2h24(61))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(67),h0tab(:,67),[16,4,2,9],[0,0,nMW,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,67),heltab2x48(:,:,67))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(31),n2h24(62))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(68),h0tab(:,68),[16,4,2,9],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,68),heltab2x48(:,:,68))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(32),n2h24(63))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(69),h0tab(:,69),[16,2,9,4],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,69),heltab2x48(:,:,69))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(33),n2h24(64))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(70),h0tab(:,70),[16,2,9,4],[0,nMZ,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,70),heltab2x48(:,:,70))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(34),n2h24(65))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(71),h0tab(:,71),[16,2,9,4],[0,nMW,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,71),heltab2x48(:,:,71))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(35),n2h24(66))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(72),h0tab(:,72),[16,2,9,4],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,72),heltab2x48(:,:,72))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(36),n2h24(67))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(73),h0tab(:,73),[16,1,4,10],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(37),m3h2x24(:,73),heltab2x48(:,:,73))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(74),h0tab(:,74),[16,1,4,10],[0,nMW,nMW,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,74),heltab2x48(:,:,74))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(38),n2h24(68))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(75),h0tab(:,75),[16,4,1,10],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,75),heltab2x48(:,:,75))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(39),n2h24(69))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(76),h0tab(:,76),[16,4,1,10],[0,0,nMZ,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,76),heltab2x48(:,:,76))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(40),n2h24(70))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(77),h0tab(:,77),[16,4,1,10],[0,0,nMW,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,77),heltab2x48(:,:,77))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(41),n2h24(71))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(78),h0tab(:,78),[16,4,1,10],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,78),heltab2x48(:,:,78))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(42),n2h24(72))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(79),h0tab(:,79),[16,1,10,4],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,79),heltab2x48(:,:,79))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(43),n2h24(73))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(80),h0tab(:,80),[16,1,10,4],[0,nMZ,0,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,80),heltab2x48(:,:,80))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(44),n2h24(74))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(81),h0tab(:,81),[16,1,10,4],[0,nMW,0,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,81),heltab2x48(:,:,81))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(45),n2h24(75))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(82),h0tab(:,82),[16,1,10,4],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,82),heltab2x48(:,:,82))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(46),n2h24(76))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(83),h0tab(:,83),[16,1,2,12],[0,0,0,0],4,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,83),heltab2x48(:,:,83))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(47),n2h24(77))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(84),h0tab(:,84),[16,1,2,12],[0,nMZ,0,0],4,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,84),heltab2x48(:,:,84))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(48),n2h24(78))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(85),h0tab(:,85),[16,1,2,12],[0,0,0,0],4,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,85),heltab2x48(:,:,85))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(49),n2h24(79))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(86),h0tab(:,86),[16,2,1,12],[0,0,0,0],4,1,wf6(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,86),heltab2x48(:,:,86))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(50),n2h24(80))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(87),h0tab(:,87),[16,2,1,12],[0,nMZ,0,0],4,1,wf6(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,87),heltab2x48(:,:,87))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(51),n2h24(81))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(88),h0tab(:,88),[16,2,1,12],[0,0,0,0],4,1,wf6(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,88),heltab2x48(:,:,88))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(52),n2h24(82))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(89),h0tab(:,89),[16,1,12,2],[0,0,nMW,0],4,1,wf6(:,9))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,89),heltab2x48(:,:,89))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(53),n2h24(83))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(90),h0tab(:,90),[16,1,12,2],[0,nMW,0,0],4,1,wf6(:,9))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,90),heltab2x48(:,:,90))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(54),n2h24(84))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(91),h0tab(:,91),[16,1,12,2],[0,nMZ,nMW,0],4,1,wf6(:,9))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,91),heltab2x48(:,:,91))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(55),n2h24(85))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(92),h0tab(:,92),[16,1,12,2],[0,nMW,nMZ,0],4,1,wf6(:,9))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,92),heltab2x48(:,:,92))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(56),n2h24(86))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(93),h0tab(:,93),[16,1,12,2],[0,0,nMW,0],4,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,93),heltab2x48(:,:,93))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(57),n2h24(87))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(94),h0tab(:,94),[16,1,12,2],[0,nMW,0,0],4,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,94),heltab2x48(:,:,94))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(58),n2h24(88))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(95),h0tab(:,95),[16,1,12,2],[0,nMZ,nMW,0],4,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,95),heltab2x48(:,:,95))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(59),n2h24(89))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(96),h0tab(:,96),[16,1,12,2],[0,nMW,nMZ,0],4,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,96),heltab2x48(:,:,96))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(60),n2h24(90))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(97),h0tab(:,97),[16,1,12,2],[0,0,0,0],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(61),m3h2x24(:,97),heltab2x48(:,:,97))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(98),h0tab(:,98),[17,4,2,8],[0,0,nMW,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(1),m3h4x12(:,1),heltab2x48(:,:,98))
  call Hloop_A_Q(ntryL,G0H12(1),17,0,G1H12(13),n2h12(9))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(99),h0tab(:,99),[17,4,2,8],[0,0,0,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(1),m3h4x12(:,2),heltab2x48(:,:,99))
  call Hloop_A_Q(ntryL,G0H12(1),17,0,G1H12(14),n2h12(10))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(100),h0tab(:,100),[17,4,2,8],[0,0,nMW,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(1),ngZu,m3h4x12(:,3),heltab2x48(:,:,100))
  call Hloop_A_Q(ntryL,G0H12(1),17,0,G1H12(15),n2h12(11))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(101),h0tab(:,101),[17,4,2,8],[0,0,nMZ,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(1),m3h4x12(:,4),heltab2x48(:,:,101))
  call Hloop_A_Q(ntryL,G0H12(1),17,0,G1H12(16),n2h12(12))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(102),h0tab(:,102),[17,2,4,8],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,8),G0H12(1),m3h4x12(:,5),heltab2x48(:,:,102))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(103),h0tab(:,103),[17,2,4,8],[nMZ,0,0,0],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,8),G0H12(2),ngZu,m3h4x12(:,6),heltab2x48(:,:,103))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(104),h0tab(:,104),[17,2,4,8],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,8),G0H12(3),m3h4x12(:,7),heltab2x48(:,:,104))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(105),h0tab(:,105),[17,2,4,8],[0,nMW,nMW,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(4),m3h4x12(:,8),heltab2x48(:,:,105))
  call Hloop_A_Q(ntryL,G0H12(4),17,0,G1H12(17),n2h12(13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(106),h0tab(:,106),[17,2,4,8],[0,nMW,nMW,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(4),ngZu,m3h4x12(:,9),heltab2x48(:,:,106))
  call Hloop_A_Q(ntryL,G0H12(4),17,0,G1H12(18),n2h12(14))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(107),h0tab(:,107),[17,2,4,8],[0,nMW,nMW,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(4),m3h4x12(:,10),heltab2x48(:,:,107))
  call Hloop_A_Q(ntryL,G0H12(4),17,0,G1H12(19),n2h12(15))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(108),h0tab(:,108),[17,2,4,8],[0,nMW,nMW,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(4),ngZu,m3h4x12(:,11),heltab2x48(:,:,108))
  call Hloop_A_Q(ntryL,G0H12(4),17,0,G1H12(20),n2h12(16))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(109),h0tab(:,109),[17,2,8,4],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,8),G0H12(4),m3h4x12(:,12),heltab2x48(:,:,109))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(110),h0tab(:,110),[17,2,8,4],[nMZ,0,0,0],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,8),G0H12(5),ngZu,m3h4x12(:,13),heltab2x48(:,:,110))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(111),h0tab(:,111),[17,2,8,4],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,8),G0H12(6),m3h4x12(:,14),heltab2x48(:,:,111))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(112),h0tab(:,112),[17,2,8,4],[0,0,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(7),m3h4x12(:,15),heltab2x48(:,:,112))
  call Hloop_A_Q(ntryL,G0H12(7),17,0,G1H12(21),n2h12(17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(113),h0tab(:,113),[17,2,8,4],[0,nMZ,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(7),m3h4x12(:,16),heltab2x48(:,:,113))
  call Hloop_A_Q(ntryL,G0H12(7),17,0,G1H12(22),n2h12(18))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(114),h0tab(:,114),[17,2,8,4],[0,0,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(7),m3h4x12(:,17),heltab2x48(:,:,114))
  call Hloop_A_Q(ntryL,G0H12(7),17,0,G1H12(23),n2h12(19))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(115),h0tab(:,115),[17,2,8,4],[0,nMZ,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,8),G0H12(7),m3h4x12(:,18),heltab2x48(:,:,115))
  call Hloop_A_Q(ntryL,G0H12(7),17,0,G1H12(24),n2h12(20))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(116),h0tab(:,116),[18,4,1,8],[0,0,0,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(7),m3h4x12(:,19),heltab2x48(:,:,116))
  call Hloop_Q_A(ntryL,G0H12(7),18,0,G1H12(1),n2h12(21))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(117),h0tab(:,117),[18,4,1,8],[0,0,nMW,0],4,1,wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(7),m3h4x12(:,20),heltab2x48(:,:,117))
  call Hloop_Q_A(ntryL,G0H12(7),18,0,G1H12(2),n2h12(22))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(118),h0tab(:,118),[18,4,1,8],[0,0,nMZ,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(7),m3h4x12(:,21),heltab2x48(:,:,118))
  call Hloop_Q_A(ntryL,G0H12(7),18,0,G1H12(4),n2h12(23))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(119),h0tab(:,119),[18,4,1,8],[0,0,nMW,nMZ],4,1,wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(7),ngZd,m3h4x12(:,22),heltab2x48(:,:,119))
  call Hloop_Q_A(ntryL,G0H12(7),18,0,G1H12(5),n2h12(24))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(120),h0tab(:,120),[18,1,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,4),G0H12(7),m3h4x12(:,23),heltab2x48(:,:,120))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(121),h0tab(:,121),[18,1,4,8],[nMZ,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,4),G0H12(8),ngZd,m3h4x12(:,24),heltab2x48(:,:,121))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(122),h0tab(:,122),[18,1,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,4),G0H12(9),m3h4x12(:,25),heltab2x48(:,:,122))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(123),h0tab(:,123),[18,1,4,8],[0,nMW,nMW,0],4,1,wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(10),m3h4x12(:,26),heltab2x48(:,:,123))
  call Hloop_Q_A(ntryL,G0H12(10),18,0,G1H12(6),n2h12(25))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(124),h0tab(:,124),[18,1,4,8],[0,nMW,nMW,nMZ],4,1,wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(10),ngZd,m3h4x12(:,27),heltab2x48(:,:,124))
  call Hloop_Q_A(ntryL,G0H12(10),18,0,G1H12(7),n2h12(26))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(125),h0tab(:,125),[18,1,4,8],[0,nMW,nMW,0],4,1,wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(10),m3h4x12(:,28),heltab2x48(:,:,125))
  call Hloop_Q_A(ntryL,G0H12(10),18,0,G1H12(8),n2h12(27))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(126),h0tab(:,126),[18,1,4,8],[0,nMW,nMW,nMZ],4,1,wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(10),ngZd,m3h4x12(:,29),heltab2x48(:,:,126))
  call Hloop_Q_A(ntryL,G0H12(10),18,0,G1H12(10),n2h12(28))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(127),h0tab(:,127),[18,1,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,4),G0H12(10),m3h4x12(:,30),heltab2x48(:,:,127))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(128),h0tab(:,128),[18,1,8,4],[nMZ,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,4),G0H12(11),ngZd,m3h4x12(:,31),heltab2x48(:,:,128))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(129),h0tab(:,129),[18,1,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,4),G0H12(12),m3h4x12(:,32),heltab2x48(:,:,129))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(130),h0tab(:,130),[18,1,8,4],[0,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(13),m3h4x12(:,33),heltab2x48(:,:,130))
  call Hloop_Q_A(ntryL,G0H12(13),18,0,G1H12(11),n2h12(29))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(131),h0tab(:,131),[18,1,8,4],[0,nMZ,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(13),m3h4x12(:,34),heltab2x48(:,:,131))
  call Hloop_Q_A(ntryL,G0H12(13),18,0,G1H12(12),n2h12(30))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(132),h0tab(:,132),[18,1,8,4],[0,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(13),m3h4x12(:,35),heltab2x48(:,:,132))
  call Hloop_Q_A(ntryL,G0H12(13),18,0,G1H12(25),n2h12(31))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(133),h0tab(:,133),[18,1,8,4],[0,nMZ,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,4),G0H12(13),m3h4x12(:,36),heltab2x48(:,:,133))
  call Hloop_Q_A(ntryL,G0H12(13),18,0,G1H12(26),n2h12(32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(8),[G1H24(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(15),[G1H24(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(23),[G1H24(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(26),[G1H24(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(32),[G1H24(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(36),[G1H24(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(42),[G1H24(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(46),[G1H24(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(49),[G1H24(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(52),[G1H24(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(3),[G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(6),[G0H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(9),[G0H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(12),[G0H12(10)])
  call Hloop_AV_Q(ntryL,G1H12(3),ex3(:),G1H6(91),m3h2x6(:,23),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H6(91),21,0,G2H6(15),n2h6(30))
  call Hloop_AW_Q(ntryL,G1H12(9),ex4(:),G1H4(65),m3h3x4(:,17),heltab2x12(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(65),25,0,G2H4(11),n2h4(18))
  call Hloop_QA_V(ntryL,G1H24(1),ex1(:),G1H12(3),m3h2x12(:,31),heltab2x24(:,:,31))
  call Hloop_QA_W(ntryL,G1H24(4),ex1(:),G1H12(9),m3h2x12(:,32),heltab2x24(:,:,32))
  call Hloop_QA_Z(ntryL,G1H24(7),ex1(:),G1H12(27),ngZu,m3h2x12(:,33),heltab2x24(:,:,33))
  call Hloop_QA_W(ntryL,G1H24(10),ex1(:),G1H12(28),m3h2x12(:,34),heltab2x24(:,:,34))
  call Hloop_VQ_A(ntryL,G1H24(13),ex2(:),G1H12(29),m3h2x12(:,35),heltab2x24(:,:,35))
  call Hloop_Q_A(ntryL,G1H12(29),18,0,G2H12(1),n2h12(33))
  call Hloop_AQ_W(ntryL,G1H24(16),ex2(:),G1H12(29),m3h2x12(:,36),heltab2x24(:,:,36))
  call Hloop_AQ_V(ntryL,G1H24(3),ex2(:),G1H12(30),m3h2x12(:,37),heltab2x24(:,:,37))
  call Hloop_AQ_W(ntryL,G1H24(2),ex2(:),G1H12(31),m3h2x12(:,38),heltab2x24(:,:,38))
  call Hloop_AQ_Z(ntryL,G1H24(6),ex2(:),G1H12(32),ngZd,m3h2x12(:,39),heltab2x24(:,:,39))
  call Hloop_QA_V(ntryL,G1H24(8),wf4(:,2),G1H6(92),m3h4x6(:,1),heltab2x24(:,:,40))
  call Hloop_QA_Z(ntryL,G1H24(9),wf4(:,2),G1H6(5),ngZu,m3h4x6(:,2),heltab2x24(:,:,41))
  call Hloop_AQ_V(ntryL,G1H24(15),ex2(:),G1H12(33),m3h2x12(:,40),heltab2x24(:,:,42))
  call Hloop_AQ_Z(ntryL,G1H24(11),ex2(:),G1H12(34),ngZd,m3h2x12(:,41),heltab2x24(:,:,43))
  call Hloop_VA_Q(ntryL,G1H24(14),ex1(:),G1H12(35),m3h2x12(:,42),heltab2x24(:,:,44))
  call Hloop_A_Q(ntryL,G1H12(35),17,0,G2H12(2),n2h12(34))
  call Hloop_QA_V(ntryL,G1H24(18),ex1(:),G1H12(35),m3h2x12(:,43),heltab2x24(:,:,45))
  call Hloop_QA_W(ntryL,G1H24(17),ex1(:),G1H12(36),m3h2x12(:,44),heltab2x24(:,:,46))
  call Hloop_QA_Z(ntryL,G1H24(19),ex1(:),G1H12(37),ngZu,m3h2x12(:,45),heltab2x24(:,:,47))
  call Hloop_QA_W(ntryL,G1H24(20),ex1(:),G1H12(38),m3h2x12(:,46),heltab2x24(:,:,48))
  call Hloop_AQ_V(ntryL,G1H24(23),wf4(:,6),G1H6(6),m3h4x6(:,3),heltab2x24(:,:,49))
  call Hloop_AQ_Z(ntryL,G1H24(22),wf4(:,6),G1H6(9),ngZd,m3h4x6(:,4),heltab2x24(:,:,50))
  call Hloop_QA_V(ntryL,G1H24(26),ex1(:),G1H12(39),m3h2x12(:,47),heltab2x24(:,:,51))
  call Hloop_QA_Z(ntryL,G1H24(25),ex1(:),G1H12(40),ngZu,m3h2x12(:,48),heltab2x24(:,:,52))
  call Hloop_VQ_A(ntryL,G1H24(27),ex2(:),G1H12(41),m3h2x12(:,49),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G1H12(41),18,0,G2H12(3),n2h12(35))
  call Hloop_AQ_W(ntryL,G1H24(28),ex2(:),G1H12(41),m3h2x12(:,50),heltab2x24(:,:,54))
  call Hloop_AV_Q(ntryL,G1H24(32),ex3(:),G1H12(42),m3h2x12(:,51),heltab2x24(:,:,55))
  call Hloop_A_Q(ntryL,G1H12(42),20,0,G2H12(4),n2h12(36))
  call Hloop_AV_Q(ntryL,G1H24(30),ex3(:),G1H12(42),m3h2x12(:,52),heltab2x24(:,:,56))
  call Hloop_A_Q(ntryL,G1H12(42),20,0,G2H12(5),n2h12(37))
  call Hloop_AV_Q(ntryL,G1H24(31),ex3(:),G1H12(42),m3h2x12(:,53),heltab2x24(:,:,57))
  call Hloop_A_Q(ntryL,G1H12(42),20,0,G2H12(6),n2h12(38))
  call Hloop_AQ_V(ntryL,G1H24(36),ex2(:),G1H12(42),m3h2x12(:,54),heltab2x24(:,:,58))
  call Hloop_AQ_Z(ntryL,G1H24(34),ex2(:),G1H12(43),ngZd,m3h2x12(:,55),heltab2x24(:,:,59))
  call Hloop_AQ_W(ntryL,G1H24(35),ex2(:),G1H12(44),m3h2x12(:,56),heltab2x24(:,:,60))
  call Hloop_VA_Q(ntryL,G1H24(37),ex1(:),G1H12(45),m3h2x12(:,57),heltab2x24(:,:,61))
  call Hloop_A_Q(ntryL,G1H12(45),17,0,G2H12(7),n2h12(39))
  call Hloop_QA_W(ntryL,G1H24(38),ex1(:),G1H12(45),m3h2x12(:,58),heltab2x24(:,:,62))
  call Hloop_QV_A(ntryL,G1H24(42),ex3(:),G1H12(46),m3h2x12(:,59),heltab2x24(:,:,63))
  call Hloop_Q_A(ntryL,G1H12(46),20,0,G2H12(8),n2h12(40))
  call Hloop_QV_A(ntryL,G1H24(40),ex3(:),G1H12(46),m3h2x12(:,60),heltab2x24(:,:,64))
  call Hloop_Q_A(ntryL,G1H12(46),20,0,G2H12(9),n2h12(41))
  call Hloop_QV_A(ntryL,G1H24(41),ex3(:),G1H12(46),m3h2x12(:,61),heltab2x24(:,:,65))
  call Hloop_Q_A(ntryL,G1H12(46),20,0,G2H12(10),n2h12(42))
  call Hloop_QA_V(ntryL,G1H24(46),ex1(:),G1H12(46),m3h2x12(:,62),heltab2x24(:,:,66))
  call Hloop_QA_Z(ntryL,G1H24(44),ex1(:),G1H12(47),ngZu,m3h2x12(:,63),heltab2x24(:,:,67))
  call Hloop_QA_W(ntryL,G1H24(45),ex1(:),G1H12(48),m3h2x12(:,64),heltab2x24(:,:,68))
  call Hloop_QA_V(ntryL,G1H24(49),ex1(:),G1H12(49),m3h2x12(:,65),heltab2x24(:,:,69))
  call Hloop_QA_Z(ntryL,G1H24(48),ex1(:),G1H12(50),ngZu,m3h2x12(:,66),heltab2x24(:,:,70))
  call Hloop_AQ_V(ntryL,G1H24(52),ex2(:),G1H12(51),m3h2x12(:,67),heltab2x24(:,:,71))
  call Hloop_AQ_Z(ntryL,G1H24(51),ex2(:),G1H12(52),ngZd,m3h2x12(:,68),heltab2x24(:,:,72))
  call Hloop_QA_V(ntryL,G1H24(53),ex1(:),G1H12(53),m3h2x12(:,69),heltab2x24(:,:,73))
  call Hloop_QA_W(ntryL,G1H24(54),ex1(:),G1H12(54),m3h2x12(:,70),heltab2x24(:,:,74))
  call Hloop_QA_Z(ntryL,G1H24(55),ex1(:),G1H12(55),ngZu,m3h2x12(:,71),heltab2x24(:,:,75))
  call Hloop_QA_W(ntryL,G1H24(56),ex1(:),G1H12(56),m3h2x12(:,72),heltab2x24(:,:,76))
  call Hloop_QA_V(ntryL,G1H24(57),ex1(:),G1H12(57),m3h2x12(:,73),heltab2x24(:,:,77))
  call Hloop_QA_W(ntryL,G1H24(58),ex1(:),G1H12(58),m3h2x12(:,74),heltab2x24(:,:,78))
  call Hloop_QA_Z(ntryL,G1H24(59),ex1(:),G1H12(59),ngZu,m3h2x12(:,75),heltab2x24(:,:,79))
  call Hloop_QA_W(ntryL,G1H24(60),ex1(:),G1H12(60),m3h2x12(:,76),heltab2x24(:,:,80))
  call Hloop_VA_Q(ntryL,G1H24(61),ex1(:),G1H12(61),m3h2x12(:,77),heltab2x24(:,:,81))
  call Hloop_A_Q(ntryL,G1H12(61),17,0,G2H12(11),n2h12(43))
  call Hloop_AV_Q(ntryL,G1H12(13),ex3(:),G1H6(10),m3h2x6(:,24),heltab2x12(:,:,41))
  call Hloop_A_Q(ntryL,G1H6(10),21,0,G2H6(17),n2h6(31))
  call Hloop_AV_Q(ntryL,G1H12(14),ex3(:),G1H6(11),m3h2x6(:,25),heltab2x12(:,:,42))
  call Hloop_A_Q(ntryL,G1H6(11),21,0,G2H6(18),n2h6(32))
  call Hloop_AV_Q(ntryL,G1H12(15),ex3(:),G1H6(12),m3h2x6(:,26),heltab2x12(:,:,43))
  call Hloop_A_Q(ntryL,G1H6(12),21,0,G2H6(1),n2h6(33))
  call Hloop_AV_Q(ntryL,G1H12(16),ex3(:),G1H6(15),m3h2x6(:,27),heltab2x12(:,:,44))
  call Hloop_A_Q(ntryL,G1H6(15),21,0,G2H6(2),n2h6(34))
  call Hloop_VQ_A(ntryL,G0H12(3),ex2(:),G0H6(1),m3h2x6(:,28),heltab2x12(:,:,45))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(16),n2h6(35))
  call Hloop_ZQ_A(ntryL,G0H12(2),ex2(:),G0H6(1),ngZd,m3h2x6(:,29),heltab2x12(:,:,46))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(17),n2h6(36))
  call Hloop_AQ_W(ntryL,G1H12(17),ex2(:),G1H6(18),m3h2x6(:,30),heltab2x12(:,:,47))
  call Hloop_AQ_W(ntryL,G1H12(18),ex2(:),G1H6(21),m3h2x6(:,31),heltab2x12(:,:,48))
  call Hloop_AQ_W(ntryL,G1H12(19),ex2(:),G1H6(22),m3h2x6(:,32),heltab2x12(:,:,49))
  call Hloop_AQ_W(ntryL,G1H12(20),ex2(:),G1H6(23),m3h2x6(:,33),heltab2x12(:,:,50))
  call Hloop_VQ_A(ntryL,G0H12(6),ex2(:),G0H6(1),m3h2x6(:,34),heltab2x12(:,:,51))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(24),n2h6(37))
  call Hloop_ZQ_A(ntryL,G0H12(5),ex2(:),G0H6(1),ngZd,m3h2x6(:,35),heltab2x12(:,:,52))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(27),n2h6(38))
  call Hloop_AQ_V(ntryL,G1H12(21),ex2(:),G1H6(28),m3h2x6(:,36),heltab2x12(:,:,53))
  call Hloop_AQ_Z(ntryL,G1H12(22),ex2(:),G1H6(29),ngZd,m3h2x6(:,37),heltab2x12(:,:,54))
  call Hloop_AQ_V(ntryL,G1H12(23),ex2(:),G1H6(30),m3h2x6(:,38),heltab2x12(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H12(24),ex2(:),G1H6(33),ngZd,m3h2x6(:,39),heltab2x12(:,:,56))
  call Hloop_QV_A(ntryL,G1H12(1),ex3(:),G1H6(34),m3h2x6(:,40),heltab2x12(:,:,57))
  call Hloop_Q_A(ntryL,G1H6(34),22,0,G2H6(3),n2h6(39))
  call Hloop_QV_A(ntryL,G1H12(2),ex3(:),G1H6(35),m3h2x6(:,41),heltab2x12(:,:,58))
  call Hloop_Q_A(ntryL,G1H6(35),22,0,G2H6(4),n2h6(40))
  call Hloop_QV_A(ntryL,G1H12(4),ex3(:),G1H6(36),m3h2x6(:,42),heltab2x12(:,:,59))
  call Hloop_Q_A(ntryL,G1H6(36),22,0,G2H6(5),n2h6(41))
  call Hloop_QV_A(ntryL,G1H12(5),ex3(:),G1H6(39),m3h2x6(:,43),heltab2x12(:,:,60))
  call Hloop_Q_A(ntryL,G1H6(39),22,0,G2H6(6),n2h6(42))
  call Hloop_VA_Q(ntryL,G0H12(9),ex1(:),G0H6(1),m3h2x6(:,44),heltab2x12(:,:,61))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(40),n2h6(43))
  call Hloop_ZA_Q(ntryL,G0H12(8),ex1(:),G0H6(1),ngZu,m3h2x6(:,45),heltab2x12(:,:,62))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(41),n2h6(44))
  call Hloop_QA_W(ntryL,G1H12(6),ex1(:),G1H6(42),m3h2x6(:,46),heltab2x12(:,:,63))
  call Hloop_QA_W(ntryL,G1H12(7),ex1(:),G1H6(45),m3h2x6(:,47),heltab2x12(:,:,64))
  call Hloop_QA_W(ntryL,G1H12(8),ex1(:),G1H6(46),m3h2x6(:,48),heltab2x12(:,:,65))
  call Hloop_QA_W(ntryL,G1H12(10),ex1(:),G1H6(47),m3h2x6(:,49),heltab2x12(:,:,66))
  call Hloop_VA_Q(ntryL,G0H12(12),ex1(:),G0H6(1),m3h2x6(:,50),heltab2x12(:,:,67))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(48),n2h6(45))
  call Hloop_ZA_Q(ntryL,G0H12(11),ex1(:),G0H6(1),ngZu,m3h2x6(:,51),heltab2x12(:,:,68))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(51),n2h6(46))
  call Hloop_QA_V(ntryL,G1H12(11),ex1(:),G1H6(52),m3h2x6(:,52),heltab2x12(:,:,69))
  call Hloop_QA_Z(ntryL,G1H12(12),ex1(:),G1H6(53),ngZu,m3h2x6(:,53),heltab2x12(:,:,70))
  call Hloop_QA_V(ntryL,G1H12(25),ex1(:),G1H6(54),m3h2x6(:,54),heltab2x12(:,:,71))
  call Hloop_QA_Z(ntryL,G1H12(26),ex1(:),G1H6(57),ngZu,m3h2x6(:,55),heltab2x12(:,:,72))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(40),[G1H6(19)])
call HGT_w2_OLR(G1H6(3),1,1,6)
call HGT_w2_invQ_OLR(G1H6(3),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(3),[G1H6(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(16),[G1H6(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(48),[G1H6(43)])
call HGT_w2_OLR(G1H6(4),1,1,6)
call HGT_w2_invQ_OLR(G1H6(4),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(4),[G1H6(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(92),[G1H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(5),[G1H6(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(26),[G1H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(41),[G1H6(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(6),[G1H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(9),[G1H6(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(50),[G1H6(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(51),[G1H6(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(16),[G1H6(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(62),[G1H6(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(17),[G1H6(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(24),[G1H6(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(74),[G1H6(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(27),[G1H6(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(15),[G1H6(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(63)])
  call Hloop_AV_Q(ntryL,G1H6(3),ex3(:),G1H3(9),m3h2x3(:,34),heltab2x6(:,:,67))
  call Hloop_A_Q(ntryL,G1H3(9),23,0,G2H3(1),n2h3(25))
  call Hotf_4pt_reduction(G2H6(16),RedSet_4(10),mass4set(:,1),  & 
G1H6(58),G1H6(59),G1H6(60),G1H6(63),G1H6(64),6)
  call HG1shiftOLR(G1H6(59),2,6)
  call Hloop_AW_Q(ntryL,G1H6(4),ex4(:),G1H2(9),m3h3x2(:,34),heltab2x6(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(9),27,0,G2H2(37),n2h2(47))
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(13),mass4set(:,1),  & 
G1H4(66),G1H4(3),G1H4(4),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(3),2,4)
  call Hloop_VQ_A(ntryL,G1H6(7),ex2(:),G1H3(20),m3h2x3(:,35),heltab2x6(:,:,69))
  call Hloop_Q_A(ntryL,G1H3(20),23,0,G2H3(3),n2h3(26))
  call Hloop_VQ_A(ntryL,G1H6(92),ex2(:),G1H3(31),m3h2x3(:,36),heltab2x6(:,:,70))
  call Hloop_Q_A(ntryL,G1H3(31),23,0,G2H3(4),n2h3(27))
  call Hloop_ZQ_A(ntryL,G1H6(13),ex2(:),G1H3(42),ngZd,m3h2x3(:,37),heltab2x6(:,:,71))
  call Hloop_Q_A(ntryL,G1H3(42),23,0,G2H3(6),n2h3(28))
  call Hloop_ZQ_A(ntryL,G1H6(5),ex2(:),G1H3(53),ngZd,m3h2x3(:,38),heltab2x6(:,:,72))
  call Hloop_Q_A(ntryL,G1H3(53),23,0,G2H3(7),n2h3(29))
  call Hloop_AV_Q(ntryL,G1H6(26),ex3(:),G1H3(64),m3h2x3(:,39),heltab2x6(:,:,73))
  call Hloop_A_Q(ntryL,G1H3(64),23,0,G2H3(9),n2h3(30))
  call Hloop_AV_Q(ntryL,G1H6(41),ex3(:),G1H3(75),m3h2x3(:,40),heltab2x6(:,:,74))
  call Hloop_A_Q(ntryL,G1H3(75),23,0,G2H3(10),n2h3(31))
  call Hloop_VA_Q(ntryL,G1H6(31),ex1(:),G1H3(86),m3h2x3(:,41),heltab2x6(:,:,75))
  call Hloop_A_Q(ntryL,G1H3(86),23,0,G2H3(12),n2h3(32))
  call Hloop_VA_Q(ntryL,G1H6(6),ex1(:),G1H3(4),m3h2x3(:,42),heltab2x6(:,:,76))
  call Hloop_A_Q(ntryL,G1H3(4),23,0,G2H3(13),n2h3(33))
  call Hloop_ZA_Q(ntryL,G1H6(37),ex1(:),G1H3(5),ngZu,m3h2x3(:,43),heltab2x6(:,:,77))
  call Hloop_A_Q(ntryL,G1H3(5),23,0,G2H3(15),n2h3(34))
  call Hloop_ZA_Q(ntryL,G1H6(9),ex1(:),G1H3(10),ngZu,m3h2x3(:,44),heltab2x6(:,:,78))
  call Hloop_A_Q(ntryL,G1H3(10),23,0,G2H3(16),n2h3(35))
  call Hloop_AW_Q(ntryL,G1H6(50),ex4(:),G1H2(15),m3h3x2(:,35),heltab2x6(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(15),27,0,G2H2(40),n2h2(48))
  call Hloop_AW_Q(ntryL,G1H6(51),ex4(:),G1H2(21),m3h3x2(:,36),heltab2x6(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(21),27,0,G2H2(59),n2h2(49))
  call Hloop_QV_A(ntryL,G1H6(16),ex3(:),G1H3(11),m3h2x3(:,45),heltab2x6(:,:,81))
  call Hloop_Q_A(ntryL,G1H3(11),23,0,G2H3(18),n2h3(36))
  call Hloop_QV_A(ntryL,G1H6(62),ex3(:),G1H3(15),m3h2x3(:,46),heltab2x6(:,:,82))
  call Hloop_Q_A(ntryL,G1H3(15),23,0,G2H3(21),n2h3(37))
  call Hloop_QV_A(ntryL,G1H6(17),ex3(:),G1H3(16),m3h2x3(:,47),heltab2x6(:,:,83))
  call Hloop_Q_A(ntryL,G1H3(16),23,0,G2H3(23),n2h3(38))
  call Hloop_QW_A(ntryL,G1H6(24),ex4(:),G1H2(27),m3h3x2(:,37),heltab2x6(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(27),27,0,G2H2(63),n2h2(50))
  call Hloop_QW_A(ntryL,G1H6(74),ex4(:),G1H2(33),m3h3x2(:,38),heltab2x6(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(33),27,0,G2H2(7),n2h2(51))
  call Hloop_QW_A(ntryL,G1H6(27),ex4(:),G1H2(44),m3h3x2(:,39),heltab2x6(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(44),27,0,G2H2(9),n2h2(52))
  call Hloop_VA_Q(ntryL,G1H4(5),ex1(:),G1H2(55),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(55),27,0,G2H2(10),n2h2(53))
  call Hloop_VA_Q(ntryL,G1H4(6),ex1(:),G1H2(66),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(66),27,0,G2H2(12),n2h2(54))
  call Hloop_WA_Q(ntryL,G1H4(11),ex1(:),G1H2(77),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(77),27,0,G2H2(15),n2h2(55))
  call Hloop_WA_Q(ntryL,G1H4(24),ex1(:),G1H2(88),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(88),27,0,G2H2(17),n2h2(56))
  call Hloop_ZA_Q(ntryL,G1H4(17),ex1(:),G1H2(99),ngZu,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(99),27,0,G2H2(18),n2h2(57))
  call Hloop_ZA_Q(ntryL,G1H4(18),ex1(:),G1H2(110),ngZu,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(110),27,0,G2H2(20),n2h2(58))
  call Hloop_WA_Q(ntryL,G1H4(23),ex1(:),G1H2(131),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(131),27,0,G2H2(21),n2h2(59))
  call Hloop_UW_V(ntryL,G1H6(77),21,ex4(:),8,G2H2(24),m3h3x2(:,40),heltab2x6(:,:,87))
  call Hloop_UW_V(ntryL,G1H6(78),21,ex4(:),8,G2H2(25),m3h3x2(:,41),heltab2x6(:,:,88))
  call Hloop_UW_V(ntryL,G1H6(83),21,ex4(:),8,G2H2(28),m3h3x2(:,42),heltab2x6(:,:,89))
  call Hloop_UW_V(ntryL,G1H6(84),21,ex4(:),8,G2H2(29),m3h3x2(:,43),heltab2x6(:,:,90))
  call Hloop_WQ_A(ntryL,G1H4(29),ex2(:),G1H2(142),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(142),27,0,G2H2(32),n2h2(60))
  call Hloop_WQ_A(ntryL,G1H4(42),ex2(:),G1H2(153),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(153),27,0,G2H2(33),n2h2(61))
  call Hloop_VQ_A(ntryL,G1H4(35),ex2(:),G1H2(164),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(164),27,0,G2H2(36),n2h2(62))
  call Hloop_VQ_A(ntryL,G1H4(36),ex2(:),G1H2(8),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(8),27,0,G2H2(39),n2h2(63))
  call Hloop_WQ_A(ntryL,G1H4(41),ex2(:),G1H2(1),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(42),n2h2(64))
  call Hloop_ZQ_A(ntryL,G1H4(47),ex2(:),G1H2(116),ngZd,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(116),27,0,G2H2(43),n2h2(65))
  call Hloop_ZQ_A(ntryL,G1H4(48),ex2(:),G1H2(10),ngZd,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(10),27,0,G2H2(46),n2h2(66))
  call Hloop_UW_V(ntryL,G1H4(51),25,ex3(:),4,G2H2(47),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_UW_V(ntryL,G1H4(58),25,ex3(:),4,G2H2(50),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_UW_V(ntryL,G1H4(57),25,ex3(:),4,G2H2(51),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hotf_4pt_reduction(G2H6(15),RedSet_4(9),mass4set(:,1),  & 
G1H6(65),G1H6(66),G1H6(69),G1H6(70),G1H6(71),6)
  call HG1shiftOLR(G1H6(66),2,6)
  call Hloop_AW_Q(ntryL,G1H6(95),ex4(:),G1H2(11),m3h3x2(:,44),heltab2x6(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(11),29,0,G2H2(54),n2h2(67))
  call Hloop_AW_Q(ntryL,G1H6(96),ex4(:),G1H2(121),m3h3x2(:,45),heltab2x6(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(121),29,0,G2H2(55),n2h2(68))
  call Hloop_AW_Q(ntryL,G1H6(100),ex4(:),G1H2(16),m3h3x2(:,46),heltab2x6(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(16),29,0,G2H2(58),n2h2(69))
  call Hloop_AW_Q(ntryL,G1H6(101),ex4(:),G1H2(17),m3h3x2(:,47),heltab2x6(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(17),29,0,G2H2(62),n2h2(70))
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(12),mass4set(:,1),  & 
G1H4(9),G1H4(10),G1H4(13),G1H4(14),G1H4(15),4)
  call HG1shiftOLR(G1H4(10),2,4)
  call Hloop_AV_Q(ntryL,G1H4(69),ex3(:),G1H2(170),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(170),29,0,G2H2(66),n2h2(71))
  call Hloop_AV_Q(ntryL,G1H4(70),ex3(:),G1H2(22),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(22),29,0,G2H2(67),n2h2(72))
  call Hloop_AV_Q(ntryL,G1H4(74),ex3(:),G1H2(23),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(23),29,0,G2H2(69),n2h2(73))
  call Hloop_AV_Q(ntryL,G1H4(75),ex3(:),G1H2(175),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(175),29,0,G2H2(72),n2h2(74))
  call Hloop_WWV_V(ntryL,G1H12(3),ex3(:),ex4(:),G1H2(28),m4h2x3x2(:,1),heltab3x12(:,:,1))
  call Hloop_WWV_V(ntryL,G1H12(9),ex4(:),ex3(:),G1H2(29),m4h3x2x2(:,1),heltab3x12(:,:,2))
  call Hloop_WWV_V(ntryL,G1H12(27),ex3(:),ex4(:),G1H2(34),m4h2x3x2(:,2),heltab3x12(:,:,3))
  call Hloop_WWV_V(ntryL,G1H12(28),ex4(:),ex3(:),G1H2(35),m4h3x2x2(:,2),heltab3x12(:,:,4))
  call Hotf_4pt_reduction(G2H12(1),RedSet_4(8),mass4set(:,1),  & 
G1H12(61),G1H12(13),G1H12(14),G1H12(15),G1H12(16),12)
  call HG1shiftOLR(G1H12(13),5,12)
  call Hloop_UW_V(ntryL,G1H12(29),18,ex4(:),8,G2H4(13),m3h3x4(:,18),heltab2x12(:,:,73))
  call Hloop_UV_W(ntryL,G1H12(30),18,ex4(:),8,G2H4(14),m3h3x4(:,19),heltab2x12(:,:,74))
  call Hloop_UW_V(ntryL,G1H12(31),18,ex4(:),8,G2H4(1),m3h3x4(:,20),heltab2x12(:,:,75))
  call Hloop_UV_W(ntryL,G1H12(32),18,ex4(:),8,G2H4(2),m3h3x4(:,21),heltab2x12(:,:,76))
  call Hloop_VA_Q(ntryL,G1H12(33),wf4(:,2),G1H3(21),m3h4x3(:,1),heltab2x12(:,:,77))
  call Hloop_A_Q(ntryL,G1H3(21),23,0,G2H3(24),n2h3(39))
  call Hloop_ZA_Q(ntryL,G1H12(34),wf4(:,2),G1H3(22),ngZu,m3h4x3(:,2),heltab2x12(:,:,78))
  call Hloop_A_Q(ntryL,G1H3(22),23,0,G2H3(26),n2h3(40))
  call Hotf_4pt_reduction(G2H12(2),RedSet_4(3),mass4set(:,1),  & 
G1H12(17),G1H12(18),G1H12(19),G1H12(20),G1H12(21),12)
  call HG1shiftOLR(G1H12(18),6,12)
  call Hloop_UV_W(ntryL,G1H12(35),17,ex4(:),8,G2H4(3),m3h3x4(:,22),heltab2x12(:,:,79))
  call Hloop_UW_V(ntryL,G1H12(36),17,ex4(:),8,G2H4(4),m3h3x4(:,23),heltab2x12(:,:,80))
  call Hloop_UV_W(ntryL,G1H12(37),17,ex4(:),8,G2H4(5),m3h3x4(:,24),heltab2x12(:,:,81))
  call Hloop_UW_V(ntryL,G1H12(38),17,ex4(:),8,G2H4(6),m3h3x4(:,25),heltab2x12(:,:,82))
  call Hloop_VQ_A(ntryL,G1H12(39),wf4(:,6),G1H3(26),m3h4x3(:,3),heltab2x12(:,:,83))
  call Hloop_Q_A(ntryL,G1H3(26),23,0,G2H3(31),n2h3(41))
  call Hloop_ZQ_A(ntryL,G1H12(40),wf4(:,6),G1H3(27),ngZd,m3h4x3(:,4),heltab2x12(:,:,84))
  call Hloop_Q_A(ntryL,G1H3(27),23,0,G2H3(32),n2h3(42))
  call Hotf_4pt_reduction(G2H12(3),RedSet_4(42),mass4set(:,1),  & 
G1H12(22),G1H12(23),G1H12(24),G1H12(1),G1H12(2),12)
  call HG1shiftOLR(G1H12(23),9,12)
  call Hloop_UV_W(ntryL,G1H12(41),18,ex3(:),4,G2H6(7),m3h2x6(:,56),heltab2x12(:,:,85))
  call Hloop_AQ_V(ntryL,G2H12(4),ex2(:),G2H6(8),m3h2x6(:,57),heltab2x12(:,:,86))
  call Hloop_AQ_Z(ntryL,G2H12(5),ex2(:),G2H6(9),ngZd,m3h2x6(:,58),heltab2x12(:,:,87))
  call Hloop_AQ_W(ntryL,G2H12(6),ex2(:),G2H6(10),m3h2x6(:,59),heltab2x12(:,:,88))
  call Hloop_VA_Q(ntryL,G1H12(42),wf6(:,4),G1H2(39),m3h6x2(:,1),heltab2x12(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(39),27,0,G2H2(74),n2h2(75))
  call Hloop_ZA_Q(ntryL,G1H12(43),wf6(:,4),G1H2(40),ngZd,m3h6x2(:,2),heltab2x12(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(40),27,0,G2H2(77),n2h2(76))
  call Hloop_WA_Q(ntryL,G1H12(44),wf6(:,4),G1H2(45),m3h6x2(:,3),heltab2x12(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(45),27,0,G2H2(78),n2h2(77))
  call Hotf_4pt_reduction(G2H12(7),RedSet_4(2),mass4set(:,1),  & 
G1H12(4),G1H12(5),G1H12(6),G1H12(7),G1H12(8),12)
  call HG1shiftOLR(G1H12(5),10,12)
  call Hloop_UV_W(ntryL,G1H12(45),17,ex3(:),4,G2H6(11),m3h2x6(:,60),heltab2x12(:,:,92))
  call Hloop_QA_V(ntryL,G2H12(8),ex1(:),G2H6(12),m3h2x6(:,61),heltab2x12(:,:,93))
  call Hloop_QA_Z(ntryL,G2H12(9),ex1(:),G2H6(13),ngZu,m3h2x6(:,62),heltab2x12(:,:,94))
  call Hloop_QA_W(ntryL,G2H12(10),ex1(:),G2H6(14),m3h2x6(:,63),heltab2x12(:,:,95))
  call Hloop_VQ_A(ntryL,G1H12(46),wf6(:,2),G1H2(46),m3h6x2(:,4),heltab2x12(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(46),27,0,G2H2(79),n2h2(78))
  call Hloop_ZQ_A(ntryL,G1H12(47),wf6(:,2),G1H2(50),ngZu,m3h6x2(:,5),heltab2x12(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(50),27,0,G2H2(80),n2h2(79))
  call Hloop_WQ_A(ntryL,G1H12(48),wf6(:,2),G1H2(51),m3h6x2(:,6),heltab2x12(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(51),27,0,G2H2(81),n2h2(80))
  call Hloop_VQ_A(ntryL,G1H12(49),ex2(:),G1H6(72),m3h2x6(:,64),heltab2x12(:,:,99))
  call Hloop_Q_A(ntryL,G1H6(72),19,0,G2H6(16),n2h6(47))
  call Hloop_ZQ_A(ntryL,G1H12(50),ex2(:),G1H6(75),ngZd,m3h2x6(:,65),heltab2x12(:,:,100))
  call Hloop_Q_A(ntryL,G1H6(75),19,0,G2H6(15),n2h6(48))
  call Hloop_VA_Q(ntryL,G1H12(51),ex1(:),G1H6(76),m3h2x6(:,66),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G1H6(76),19,0,G2H6(19),n2h6(49))
  call Hloop_ZA_Q(ntryL,G1H12(52),ex1(:),G1H6(1),ngZu,m3h2x6(:,67),heltab2x12(:,:,102))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(20),n2h6(50))
  call Hloop_VS_V(ntryL,G1H12(53),wf6(:,9),G1H2(56),m3h6x2(:,7),heltab2x12(:,:,103))
  call Hloop_VS_V(ntryL,G1H12(54),wf6(:,9),G1H2(57),m3h6x2(:,8),heltab2x12(:,:,104))
  call Hloop_VS_V(ntryL,G1H12(55),wf6(:,9),G1H2(61),m3h6x2(:,9),heltab2x12(:,:,105))
  call Hloop_VS_V(ntryL,G1H12(56),wf6(:,9),G1H2(62),m3h6x2(:,10),heltab2x12(:,:,106))
  call Hloop_UV_W(ntryL,G1H12(57),17,wf6(:,5),12,G2H2(82),m3h6x2(:,11),heltab2x12(:,:,107))
  call Hloop_UW_V(ntryL,G1H12(58),17,wf6(:,5),12,G2H2(83),m3h6x2(:,12),heltab2x12(:,:,108))
  call Hloop_UV_W(ntryL,G1H12(59),17,wf6(:,5),12,G2H2(84),m3h6x2(:,13),heltab2x12(:,:,109))
  call Hloop_UW_V(ntryL,G1H12(60),17,wf6(:,5),12,G2H2(85),m3h6x2(:,14),heltab2x12(:,:,110))
  call Hotf_4pt_reduction(G2H12(11),RedSet_4(1),mass4set(:,1),  & 
G1H12(10),G1H12(11),G1H12(12),G1H12(25),G1H12(26),12)
  call HG1shiftOLR(G1H12(11),2,12)
  call Hloop_AQ_W(ntryL,G2H6(17),ex2(:),G2H3(33),m3h2x3(:,48),heltab2x6(:,:,95))
  call Hloop_AQ_V(ntryL,G2H6(18),ex2(:),G2H3(34),m3h2x3(:,49),heltab2x6(:,:,96))
  call Hloop_AQ_W(ntryL,G2H6(1),ex2(:),G2H3(35),m3h2x3(:,50),heltab2x6(:,:,97))
  call Hloop_AQ_Z(ntryL,G2H6(2),ex2(:),G2H3(36),ngZd,m3h2x3(:,51),heltab2x6(:,:,98))
  call Hloop_VV_S(ntryL,G1H6(18),ex3(:),G1H3(32),m3h2x3(:,52),heltab2x6(:,:,99))
  call Hloop_VV_S(ntryL,G1H6(21),ex3(:),G1H3(33),m3h2x3(:,53),heltab2x6(:,:,100))
  call Hloop_UV_W(ntryL,G1H6(22),19,ex3(:),4,G2H3(37),m3h2x3(:,54),heltab2x6(:,:,101))
  call Hloop_UV_W(ntryL,G1H6(23),19,ex3(:),4,G2H3(38),m3h2x3(:,55),heltab2x6(:,:,102))
  call Hloop_VV_S(ntryL,G1H6(28),ex4(:),G1H2(67),m3h3x2(:,48),heltab2x6(:,:,103))
  call Hloop_VV_S(ntryL,G1H6(29),ex4(:),G1H2(68),m3h3x2(:,49),heltab2x6(:,:,104))
  call Hloop_UV_W(ntryL,G1H6(30),19,ex4(:),8,G2H2(86),m3h3x2(:,50),heltab2x6(:,:,105))
  call Hloop_UV_W(ntryL,G1H6(33),19,ex4(:),8,G2H2(87),m3h3x2(:,51),heltab2x6(:,:,106))
  call Hloop_QA_V(ntryL,G2H6(3),ex1(:),G2H3(39),m3h2x3(:,56),heltab2x6(:,:,107))
  call Hloop_QA_W(ntryL,G2H6(4),ex1(:),G2H3(40),m3h2x3(:,57),heltab2x6(:,:,108))
  call Hloop_QA_Z(ntryL,G2H6(5),ex1(:),G2H3(41),ngZu,m3h2x3(:,58),heltab2x6(:,:,109))
  call Hloop_QA_W(ntryL,G2H6(6),ex1(:),G2H3(42),m3h2x3(:,59),heltab2x6(:,:,110))
  call Hloop_VV_S(ntryL,G1H6(42),ex3(:),G1H3(37),m3h2x3(:,60),heltab2x6(:,:,111))
  call Hloop_VV_S(ntryL,G1H6(45),ex3(:),G1H3(38),m3h2x3(:,61),heltab2x6(:,:,112))
  call Hloop_UV_W(ntryL,G1H6(46),19,ex3(:),4,G2H3(43),m3h2x3(:,62),heltab2x6(:,:,113))
  call Hloop_UV_W(ntryL,G1H6(47),19,ex3(:),4,G2H3(44),m3h2x3(:,63),heltab2x6(:,:,114))
  call Hloop_VV_S(ntryL,G1H6(52),ex4(:),G1H2(72),m3h3x2(:,52),heltab2x6(:,:,115))
  call Hloop_VV_S(ntryL,G1H6(53),ex4(:),G1H2(73),m3h3x2(:,53),heltab2x6(:,:,116))
  call Hloop_UV_W(ntryL,G1H6(54),19,ex4(:),8,G2H2(88),m3h3x2(:,54),heltab2x6(:,:,117))
  call Hloop_UV_W(ntryL,G1H6(57),19,ex4(:),8,G2H2(89),m3h3x2(:,55),heltab2x6(:,:,118))
  call Hloop_AW_Q(ntryL,G1H6(58),ex4(:),G1H2(78),m3h3x2(:,56),heltab2x6(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(78),29,0,G2H2(90),n2h2(81))
call HGT_raise_alpha_OLR(G1H6(59),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(59),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(59),ex2(:),G1H3(43),m3h2x3(:,64),heltab2x6(:,:,120))
  call Hloop_AW_Q(ntryL,G1H6(63),ex4(:),G1H2(79),m3h3x2(:,57),heltab2x6(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(79),29,0,G2H2(91),n2h2(82))
  call Hloop_AW_Q(ntryL,G1H6(64),ex4(:),G1H2(83),m3h3x2(:,58),heltab2x6(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(83),29,0,G2H2(92),n2h2(83))
  call Hloop_AV_Q(ntryL,G1H4(66),ex3(:),G1H2(84),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(84),29,0,G2H2(93),n2h2(84))
call HGT_raise_alpha_OLR(G1H4(3),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(3),ex2(:),G1H2(89),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_AV_Q(ntryL,G1H4(7),ex3(:),G1H2(90),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(90),29,0,G2H2(94),n2h2(85))
  call Hloop_AV_Q(ntryL,G1H4(8),ex3(:),G1H2(94),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(94),29,0,G2H2(95),n2h2(86))
  call Hloop_AW_Q(ntryL,G1H6(65),ex4(:),G1H2(95),m3h3x2(:,59),heltab2x6(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(95),29,0,G2H2(96),n2h2(87))
call HGT_raise_alpha_OLR(G1H6(66),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(66),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(66),ex2(:),G1H3(44),m3h2x3(:,65),heltab2x6(:,:,124))
  call Hloop_AW_Q(ntryL,G1H6(70),ex4(:),G1H2(100),m3h3x2(:,60),heltab2x6(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(100),29,0,G2H2(97),n2h2(88))
  call Hloop_AW_Q(ntryL,G1H6(71),ex4(:),G1H2(101),m3h3x2(:,61),heltab2x6(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(101),29,0,G2H2(98),n2h2(89))
  call Hloop_AV_Q(ntryL,G1H4(9),ex3(:),G1H2(105),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(105),29,0,G2H2(99),n2h2(90))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(10),ex2(:),G1H2(106),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_AV_Q(ntryL,G1H4(14),ex3(:),G1H2(111),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(111),29,0,G2H2(100),n2h2(91))
  call Hloop_AV_Q(ntryL,G1H4(15),ex3(:),G1H2(112),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(112),29,0,G2H2(101),n2h2(92))
  call Hloop_QW_A(ntryL,G1H12(61),ex4(:),G1H4(16),m3h3x4(:,26),heltab2x12(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(16),26,0,G2H4(7),n2h4(21))
call HGT_raise_alpha_OLR(G1H12(13),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(13),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(13),wf4(:,2),G1H3(48),m3h4x3(:,5),heltab2x12(:,:,112))
  call Hloop_QW_A(ntryL,G1H12(15),ex4(:),G1H4(19),m3h3x4(:,27),heltab2x12(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(19),26,0,G2H4(8),n2h4(22))
  call Hloop_QW_A(ntryL,G1H12(16),ex4(:),G1H4(20),m3h3x4(:,28),heltab2x12(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(20),26,0,G2H4(9),n2h4(23))
  call Hloop_AW_Q(ntryL,G1H12(17),ex4(:),G1H4(21),m3h3x4(:,29),heltab2x12(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(21),25,0,G2H4(10),n2h4(24))
call HGT_raise_alpha_OLR(G1H12(18),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(18),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(18),wf4(:,6),G1H3(49),m3h4x3(:,6),heltab2x12(:,:,116))
  call Hloop_AW_Q(ntryL,G1H12(20),ex4(:),G1H4(22),m3h3x4(:,30),heltab2x12(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(22),25,0,G2H4(12),n2h4(25))
  call Hloop_AW_Q(ntryL,G1H12(21),ex4(:),G1H4(25),m3h3x4(:,31),heltab2x12(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(25),25,0,G2H4(11),n2h4(26))
  call Hloop_QV_A(ntryL,G1H12(22),ex3(:),G1H6(2),m3h2x6(:,68),heltab2x12(:,:,119))
  call Hloop_Q_A(ntryL,G1H6(2),22,0,G2H6(17),n2h6(53))
call HGT_raise_alpha_OLR(G1H12(23),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(23),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(23),wf6(:,4),G1H2(117),m3h6x2(:,15),heltab2x12(:,:,120))
  call Hloop_QV_A(ntryL,G1H12(1),ex3(:),G1H6(79),m3h2x6(:,69),heltab2x12(:,:,121))
  call Hloop_Q_A(ntryL,G1H6(79),22,0,G2H6(18),n2h6(54))
  call Hloop_QV_A(ntryL,G1H12(2),ex3(:),G1H6(80),m3h2x6(:,70),heltab2x12(:,:,122))
  call Hloop_Q_A(ntryL,G1H6(80),22,0,G2H6(1),n2h6(55))
  call Hloop_AV_Q(ntryL,G1H12(4),ex3(:),G1H6(81),m3h2x6(:,71),heltab2x12(:,:,123))
  call Hloop_A_Q(ntryL,G1H6(81),21,0,G2H6(2),n2h6(56))
call HGT_raise_alpha_OLR(G1H12(5),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(5),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(5),wf6(:,2),G1H2(122),m3h6x2(:,16),heltab2x12(:,:,124))
  call Hloop_AV_Q(ntryL,G1H12(7),ex3(:),G1H6(82),m3h2x6(:,72),heltab2x12(:,:,125))
  call Hloop_A_Q(ntryL,G1H6(82),21,0,G2H6(3),n2h6(57))
  call Hloop_AV_Q(ntryL,G1H12(8),ex3(:),G1H6(85),m3h2x6(:,73),heltab2x12(:,:,126))
  call Hloop_A_Q(ntryL,G1H6(85),21,0,G2H6(4),n2h6(58))
  call Hloop_AW_Q(ntryL,G1H12(10),wf6(:,5),G1H2(126),m3h6x2(:,17),heltab2x12(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(126),29,0,G2H2(102),n2h2(93))
call HGT_raise_alpha_OLR(G1H12(11),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(11),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(11),ex2(:),G1H6(86),m3h2x6(:,74),heltab2x12(:,:,128))
  call Hloop_AW_Q(ntryL,G1H12(25),wf6(:,5),G1H2(127),m3h6x2(:,18),heltab2x12(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(127),29,0,G2H2(103),n2h2(94))
  call Hloop_AW_Q(ntryL,G1H12(26),wf6(:,5),G1H2(132),m3h6x2(:,19),heltab2x12(:,:,130))
  call Hloop_A_Q(ntryL,G1H2(132),29,0,G2H2(104),n2h2(95))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G2H3(2),G1H3(19),G1H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G2H3(8),G1H3(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(26),[G2H3(11),G1H3(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(17),[G2H3(14),G1H3(63),G1H3(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G1H3(50)])
call HGT_OLR(G2H3(19),1,1,3)
call HGT_invQ_OLR(G2H3(19),2,5,3)
call HGT_OLR(G2H3(19),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(19),[G2H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(27),G2H2(8),G1H2(87),G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G1H3(61)])
call HGT_OLR(G2H3(20),1,1,3)
call HGT_invQ_OLR(G2H3(20),2,5,3)
call HGT_OLR(G2H3(20),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(20),[G2H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G2H2(35),G2H2(11),G1H2(109),G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(31),[G2H3(22),G1H3(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(32),[G2H3(25),G1H3(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(6)])
call HGT_OLR(G2H3(27),1,1,3)
call HGT_invQ_OLR(G2H3(27),2,5,3)
call HGT_OLR(G2H3(27),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(27),[G2H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(45),G2H2(16),G1H2(130),G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(17)])
call HGT_OLR(G2H3(28),1,1,3)
call HGT_invQ_OLR(G2H3(28),2,5,3)
call HGT_OLR(G2H3(28),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(28),[G2H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(53),G2H2(19),G1H2(152),G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G2H2(31),G2H2(23),G1H2(98),G1H2(76)])
call HGT_lower_alpha_w2_OLR(G2H3(29),1,1,3)
call HGT_lower_alpha_w2_invQ_OLR(G2H3(29),2,5,3)
call HGT_lower_alpha_w2_OLR(G2H3(29),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(29),[G2H3(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(38),G1H2(57),G1H2(29),G1H2(4)])
call HGT_lower_alpha_w2_OLR(G2H3(30),1,1,3)
call HGT_lower_alpha_w2_invQ_OLR(G2H3(30),2,5,3)
call HGT_lower_alpha_w2_OLR(G2H3(30),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(30),[G2H3(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(41),G1H2(62),G1H2(35),G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G2H2(57),G2H2(49),G1H2(163),G1H2(141)])
call HGT_lower_alpha_w2_OLR(G2H2(60),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(60),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(60),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G2H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(61),G1H2(56),G1H2(28),G1H2(20)])
call HGT_lower_alpha_w2_OLR(G2H2(64),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(64),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(64),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G2H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(65),G1H2(61),G1H2(34),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(28)])
call HGT_w2_OLR(G1H3(1),1,1,3)
call HGT_w2_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G2H2(73),G2H2(68)])
call HGT_w2_OLR(G1H3(2),1,1,3)
call HGT_w2_invQ_OLR(G1H3(2),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G2H2(76),G2H2(75),G2H2(71),G2H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(30)])
call HGT_w2_OLR(G1H2(5),1,1,2)
call HGT_w2_invQ_OLR(G1H2(5),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(5)])
call HGT_w2_OLR(G1H2(6),1,1,2)
call HGT_w2_invQ_OLR(G1H2(6),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(6),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G1H2(25),G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(25),[G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G1H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G1H3(40),G1H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(46),[G1H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G1H3(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(69),[G1H3(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G1H3(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(42),G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(93),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(115),[G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(18),[G1H3(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(21),[G1H3(84),G1H3(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(90),[G1H3(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(23),[G1H3(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(64),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(70),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(136),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(158),[G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(104),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(108),G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(114),[G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(151),G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(157),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(169),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(178),[G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G2H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(72)])
call HGT_OLR(G2H2(1),1,1,2)
call HGT_invQ_OLR(G2H2(1),2,5,2)
call HGT_OLR(G2H2(1),6,15,2)
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(43),mass4set(:,1),  & 
G1H2(133),G1H2(137),G1H2(138),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(137),2,2)
  call Hotf_4pt_reduction(G2H3(5),RedSet_4(17),mass4set(:,1),  & 
G1H3(54),G1H3(55),G1H3(59),G1H3(60),G1H3(65),3)
  call HG1shiftOLR(G1H3(55),8,3)
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(43),mass4set(:,2),  & 
G1H2(148),G1H2(149),G1H2(154),G1H2(155),G1H2(159),2)
  call HG1shiftOLR(G1H2(149),2,2)
call HGT_OLR(G2H2(3),1,1,2)
call HGT_invQ_OLR(G2H2(3),2,5,2)
call HGT_OLR(G2H2(3),6,15,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(44),mass4set(:,1),  & 
G1H2(160),G1H2(165),G1H2(166),G1H2(171),G1H2(176),2)
  call HG1shiftOLR(G1H2(165),4,2)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(21),mass4set(:,1),  & 
G1H3(66),G1H3(70),G1H3(71),G1H3(76),G1H3(77),3)
  call HG1shiftOLR(G1H3(70),8,3)
call HGT_OLR(G2H2(4),1,1,2)
call HGT_invQ_OLR(G2H2(4),2,5,2)
call HGT_OLR(G2H2(4),6,15,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(44),mass4set(:,3),  & 
G1H2(9),G1H2(15),G1H2(21),G1H2(27),G1H2(33),2)
  call HG1shiftOLR(G1H2(15),4,2)
  call Hotf_4pt_reduction(G2H3(26),RedSet_4(21),mass4set(:,3),  & 
G1H3(81),G1H3(82),G1H3(87),G1H3(88),G1H3(9),3)
  call HG1shiftOLR(G1H3(82),8,3)
call HGT_OLR(G2H2(5),1,1,2)
call HGT_invQ_OLR(G2H2(5),2,5,2)
call HGT_OLR(G2H2(5),6,15,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(45),mass4set(:,1),  & 
G1H2(44),G1H2(55),G1H2(66),G1H2(77),G1H2(88),2)
  call HG1shiftOLR(G1H2(55),1,2)
  call Hotf_4pt_reduction(G2H3(17),RedSet_4(17),mass4set(:,1),  & 
G1H3(20),G1H3(31),G1H3(42),G1H3(53),G1H3(64),3)
  call HG1shiftOLR(G1H3(31),8,3)
call HGT_OLR(G2H2(6),1,1,2)
call HGT_invQ_OLR(G2H2(6),2,5,2)
call HGT_OLR(G2H2(6),6,15,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(45),mass4set(:,2),  & 
G1H2(99),G1H2(110),G1H2(131),G1H2(142),G1H2(153),2)
  call HG1shiftOLR(G1H2(110),1,2)
  call Hotf_4pt_reduction(G2H3(19),RedSet_4(23),mass4set(:,1),  & 
G1H3(75),G1H3(86),G1H3(4),G1H3(5),G1H3(10),3)
  call HG1shiftOLR(G1H3(86),8,3)
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(28),mass4set(:,1),  & 
G1H2(164),G1H2(8),G1H2(1),G1H2(116),G1H2(10),2)
  call HG1shiftOLR(G1H2(8),4,2)
  call Hotf_4pt_reduction(G2H3(20),RedSet_4(23),mass4set(:,3),  & 
G1H3(11),G1H3(15),G1H3(16),G1H3(21),G1H3(22),3)
  call HG1shiftOLR(G1H3(15),8,3)
  call Hotf_4pt_reduction(G2H2(77),RedSet_4(28),mass4set(:,3),  & 
G1H2(11),G1H2(121),G1H2(16),G1H2(17),G1H2(170),2)
  call HG1shiftOLR(G1H2(121),4,2)
call HGT_OLR(G2H2(13),1,1,2)
call HGT_invQ_OLR(G2H2(13),2,5,2)
call HGT_OLR(G2H2(13),6,15,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(46),mass4set(:,1),  & 
G1H2(22),G1H2(23),G1H2(175),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(23),4,2)
  call Hotf_4pt_reduction(G2H3(31),RedSet_4(31),mass4set(:,1),  & 
G1H3(26),G1H3(27),G1H3(19),G1H3(8),G1H3(30),3)
  call HG1shiftOLR(G1H3(27),8,3)
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(46),mass4set(:,3),  & 
G1H2(45),G1H2(46),G1H2(50),G1H2(51),G1H2(78),2)
  call HG1shiftOLR(G1H2(46),4,2)
  call Hotf_4pt_reduction(G2H3(32),RedSet_4(31),mass4set(:,3),  & 
G1H3(41),G1H3(63),G1H3(52),G1H3(50),G1H3(61),3)
  call HG1shiftOLR(G1H3(63),8,3)
  call Hotf_4pt_reduction(G2H3(27),RedSet_4(15),mass4set(:,1),  & 
G1H3(74),G1H3(85),G1H3(6),G1H3(17),G1H3(28),3)
  call HG1shiftOLR(G1H3(85),8,3)
  call Hotf_4pt_reduction(G2H2(79),RedSet_4(34),mass4set(:,1),  & 
G1H2(79),G1H2(83),G1H2(84),G1H2(90),G1H2(94),2)
  call HG1shiftOLR(G1H2(83),4,2)
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(15),mass4set(:,3),  & 
G1H3(1),G1H3(34),G1H3(7),G1H3(14),G1H3(18),3)
  call HG1shiftOLR(G1H3(34),8,3)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(34),mass4set(:,3),  & 
G1H2(95),G1H2(100),G1H2(101),G1H2(105),G1H2(111),2)
  call HG1shiftOLR(G1H2(100),4,2)
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(47),mass4set(:,4),  & 
G1H2(112),G1H2(126),G1H2(127),G1H2(132),G1H2(87),2)
  call HG1shiftOLR(G1H2(126),1,2)
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(28),mass4set(:,4),  & 
G1H2(32),G1H2(109),G1H2(43),G1H2(130),G1H2(54),2)
  call HG1shiftOLR(G1H2(109),4,2)
call HGT_OLR(G2H2(26),1,1,2)
call HGT_invQ_OLR(G2H2(26),2,5,2)
call HGT_OLR(G2H2(26),6,15,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(47),mass4set(:,5),  & 
G1H2(152),G1H2(65),G1H2(98),G1H2(76),G1H2(57),2)
  call HG1shiftOLR(G1H2(65),1,2)
call HGT_OLR(G2H2(30),1,1,2)
call HGT_invQ_OLR(G2H2(30),2,5,2)
call HGT_OLR(G2H2(30),6,15,2)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(47),mass4set(:,6),  & 
G1H2(29),G1H2(4),G1H2(62),G1H2(35),G1H2(14),2)
  call HG1shiftOLR(G1H2(4),1,2)
call HGT_OLR(G2H2(34),1,1,2)
call HGT_invQ_OLR(G2H2(34),2,5,2)
call HGT_OLR(G2H2(34),6,15,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(47),mass4set(:,7),  & 
G1H2(163),G1H2(141),G1H2(56),G1H2(28),G1H2(20),2)
  call HG1shiftOLR(G1H2(141),1,2)
  call Hotf_4pt_reduction(G2H3(29),RedSet_4(19),mass4set(:,8),  & 
G1H3(40),G1H3(29),G1H3(35),G1H3(39),G1H3(51),3)
  call HG1shiftOLR(G1H3(29),8,3)
  call Hotf_4pt_reduction(G2H2(83),RedSet_4(1),mass4set(:,4),  & 
G1H2(61),G1H2(34),G1H2(26),G1H2(30),G1H2(5),2)
  call HG1shiftOLR(G1H2(34),2,2)
  call Hotf_4pt_reduction(G2H3(30),RedSet_4(19),mass4set(:,9),  & 
G1H3(58),G1H3(62),G1H3(72),G1H3(84),G1H3(73),3)
  call HG1shiftOLR(G1H3(62),8,3)
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(1),mass4set(:,6),  & 
G1H2(36),G1H2(2),G1H2(3),G1H2(12),G1H2(13),2)
  call HG1shiftOLR(G1H2(2),2,2)
call HGT_OLR(G2H2(44),1,1,2)
call HGT_invQ_OLR(G2H2(44),2,5,2)
call HGT_OLR(G2H2(44),6,15,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(48),mass4set(:,5),  & 
G1H2(18),G1H2(25),G1H2(19),G1H2(24),G1H2(42),2)
  call HG1shiftOLR(G1H2(25),2,2)
call HGT_OLR(G2H2(48),1,1,2)
call HGT_invQ_OLR(G2H2(48),2,5,2)
call HGT_OLR(G2H2(48),6,15,2)
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(48),mass4set(:,4),  & 
G1H2(31),G1H2(37),G1H2(38),G1H2(41),G1H2(49),2)
  call HG1shiftOLR(G1H2(37),2,2)
  call Hotf_4pt_reduction(G2H2(81),RedSet_4(34),mass4set(:,4),  & 
G1H2(52),G1H2(64),G1H2(53),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(64),4,2)
call HGT_OLR(G2H2(52),1,1,2)
call HGT_invQ_OLR(G2H2(52),2,5,2)
call HGT_OLR(G2H2(52),6,15,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(48),mass4set(:,7),  & 
G1H2(63),G1H2(71),G1H2(74),G1H2(75),G1H2(82),2)
  call HG1shiftOLR(G1H2(71),2,2)
call HGT_OLR(G2H2(56),1,1,2)
call HGT_invQ_OLR(G2H2(56),2,5,2)
call HGT_OLR(G2H2(56),6,15,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(48),mass4set(:,6),  & 
G1H2(85),G1H2(108),G1H2(86),G1H2(92),G1H2(96),2)
  call HG1shiftOLR(G1H2(108),2,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(26),mass4set(:,10),  & 
G1H2(97),G1H2(107),G1H2(128),G1H2(151),G1H2(129),2)
  call HG1shiftOLR(G1H2(107),4,2)
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(1),mass4set(:,5),  & 
G1H2(135),G1H2(139),G1H2(140),G1H2(147),G1H2(150),2)
  call HG1shiftOLR(G1H2(139),2,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(26),mass4set(:,11),  & 
G1H2(161),G1H2(162),G1H2(173),G1H2(180),G1H2(181),2)
  call HG1shiftOLR(G1H2(162),4,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(1),mass4set(:,7),  & 
G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(183),2,2)
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(19),mass4set(:,1),  & 
G1H3(79),G1H3(83),G1H3(92),G1H3(93),G1H3(94),3)
  call HG1shiftOLR(G1H3(83),8,3)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(102),ex2(:),G2tensor(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hloop_AW_Q(ntryL,G1H3(2),ex4(:),G1H1(1),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(97))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(104),ex2(:),G2tensor(5),m3h2x1(:,70),heltab2x2(:,:,70))
call HGT_w2_OLR(G1H3(3),1,1,3)
call HGT_w2_invQ_OLR(G1H3(3),2,5,3)
  call Hloop_AW_Q(ntryL,G1H3(3),ex4(:),G1H1(1),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(8),n2h1(98))
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(26),mass4set(:,1),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),2)
  call HG1shiftOLR(G1H2(188),4,2)
  call Hloop_AV_Q(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(99))
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call Hloop_AV_Q(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(14),n2h1(100))
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(9),mass4set(:,12),  & 
G1H2(6),G1H2(7),G1H2(192),G1H2(193),G1H2(194),2)
  call HG1shiftOLR(G1H2(7),2,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(10),mass4set(:,4),  & 
G1H2(195),G1H2(196),G1H2(197),G1H2(198),G1H2(199),2)
  call HG1shiftOLR(G1H2(196),2,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(9),mass4set(:,13),  & 
G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(201),2,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(10),mass4set(:,6),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),2)
  call HG1shiftOLR(G1H2(206),2,2)
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(12),mass4set(:,8),  & 
G1H2(210),G1H2(211),G1H2(212),G1H2(213),G1H2(214),2)
  call HG1shiftOLR(G1H2(211),2,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(13),mass4set(:,8),  & 
G1H2(215),G1H2(216),G1H2(217),G1H2(218),G1H2(219),2)
  call HG1shiftOLR(G1H2(216),2,2)
  call Hotf_4pt_reduction(G2H2(51),RedSet_4(12),mass4set(:,14),  & 
G1H2(220),G1H2(221),G1H2(222),G1H2(223),G1H2(224),2)
  call HG1shiftOLR(G1H2(221),2,2)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(16),mass4set(:,1),  & 
G1H3(2),G1H3(3),G1H3(95),G1H3(96),G1H3(97),3)
  call HG1shiftOLR(G1H3(3),8,3)
  call Hloop_QW_A(ntryL,G1H3(12),ex4(:),G1H1(1),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(101))
  call Hloop_QW_A(ntryL,G1H3(13),ex4(:),G1H1(1),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(102))
  call Hloop_QW_A(ntryL,G1H3(25),ex4(:),G1H1(1),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(103))
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(16),mass4set(:,3),  & 
G1H3(12),G1H3(13),G1H3(25),G1H3(98),G1H3(99),3)
  call HG1shiftOLR(G1H3(13),8,3)
  call Hloop_QW_A(ntryL,G1H3(23),ex4(:),G1H1(1),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(104))
  call Hloop_QW_A(ntryL,G1H3(24),ex4(:),G1H1(1),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(105))
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(20),mass4set(:,1),  & 
G1H3(23),G1H3(24),G1H3(100),G1H3(101),G1H3(102),3)
  call HG1shiftOLR(G1H3(24),8,3)
  call Hloop_AW_Q(ntryL,G1H3(46),ex4(:),G1H1(1),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(106))
  call Hloop_AW_Q(ntryL,G1H3(36),ex4(:),G1H1(1),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(107))
  call Hotf_4pt_reduction(G2H3(10),RedSet_4(19),mass4set(:,15),  & 
G1H3(46),G1H3(36),G1H3(103),G1H3(104),G1H3(105),3)
  call HG1shiftOLR(G1H3(36),8,3)
  call Hloop_AW_Q(ntryL,G1H3(45),ex4(:),G1H1(1),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(108))
  call Hloop_AW_Q(ntryL,G1H3(47),ex4(:),G1H1(1),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(109))
  call Hotf_4pt_reduction(G2H3(13),RedSet_4(24),mass4set(:,1),  & 
G1H3(45),G1H3(47),G1H3(106),G1H3(107),G1H3(108),3)
  call HG1shiftOLR(G1H3(47),8,3)
  call Hloop_AW_Q(ntryL,G1H3(56),ex4(:),G1H1(1),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(110))
  call Hloop_AW_Q(ntryL,G1H3(57),ex4(:),G1H1(1),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(111))
  call Hloop_AW_Q(ntryL,G1H3(69),ex4(:),G1H1(1),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(112))
  call Hotf_4pt_reduction(G2H3(16),RedSet_4(24),mass4set(:,3),  & 
G1H3(56),G1H3(57),G1H3(69),G1H3(109),G1H3(110),3)
  call HG1shiftOLR(G1H3(57),8,3)
  call Hloop_AW_Q(ntryL,G1H3(67),ex4(:),G1H1(1),m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(113))
  call Hloop_AW_Q(ntryL,G1H3(68),ex4(:),G1H1(1),m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(114))
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(27),mass4set(:,1),  & 
G1H2(225),G1H2(226),G1H2(227),G1H2(228),G1H2(229),2)
  call HG1shiftOLR(G1H2(226),4,2)
  call Hloop_AV_Q(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(115))
  call Hloop_AV_Q(ntryL,G1H2(93),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(116))
  call Hotf_4pt_reduction(G2H2(59),RedSet_4(26),mass4set(:,15),  & 
G1H2(48),G1H2(93),G1H2(230),G1H2(231),G1H2(232),2)
  call HG1shiftOLR(G1H2(93),4,2)
  call Hloop_AV_Q(ntryL,G1H2(47),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(117))
  call Hloop_AV_Q(ntryL,G1H2(115),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(118))
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(30),mass4set(:,1),  & 
G1H3(67),G1H3(68),G1H3(111),G1H3(112),G1H3(113),3)
  call HG1shiftOLR(G1H3(68),8,3)
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(20),mass4set(:,1),  & 
G1H3(114),G1H3(115),G1H3(116),G1H3(117),G1H3(118),3)
  call HG1shiftOLR(G1H3(115),8,3)
  call Hloop_QW_A(ntryL,G1H3(78),ex4(:),G1H1(1),m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(119))
  call Hloop_QW_A(ntryL,G1H3(90),ex4(:),G1H1(1),m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(120))
  call Hloop_QW_A(ntryL,G1H3(80),ex4(:),G1H1(1),m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(101),n2h1(121))
  call Hotf_4pt_reduction(G2H3(23),RedSet_4(30),mass4set(:,15),  & 
G1H3(78),G1H3(90),G1H3(80),G1H3(119),G1H3(120),3)
  call HG1shiftOLR(G1H3(90),8,3)
  call Hloop_QW_A(ntryL,G1H3(89),ex4(:),G1H1(1),m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(102),n2h1(122))
  call Hloop_QW_A(ntryL,G1H3(91),ex4(:),G1H1(1),m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(123))
  call Hotf_4pt_reduction(G2H2(63),RedSet_4(33),mass4set(:,1),  & 
G1H2(47),G1H2(115),G1H2(233),G1H2(234),G1H2(235),2)
  call HG1shiftOLR(G1H2(115),4,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(27),mass4set(:,1),  & 
G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(237),4,2)
  call Hloop_QV_A(ntryL,G1H2(58),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(104),n2h1(124))
  call Hloop_QV_A(ntryL,G1H2(70),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(105),n2h1(125))
  call Hloop_QV_A(ntryL,G1H2(136),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(106),n2h1(126))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(33),mass4set(:,15),  & 
G1H2(58),G1H2(70),G1H2(136),G1H2(241),G1H2(242),2)
  call HG1shiftOLR(G1H2(70),4,2)
  call Hloop_QV_A(ntryL,G1H2(69),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(107),n2h1(127))
  call Hloop_QV_A(ntryL,G1H2(158),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(108),n2h1(128))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(36),mass4set(:,16),  & 
G1H2(69),G1H2(158),G1H2(243),G1H2(244),G1H2(245),2)
  call HG1shiftOLR(G1H2(158),4,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(37),mass4set(:,1),  & 
G1H2(246),G1H2(247),G1H2(248),G1H2(249),G1H2(250),2)
  call HG1shiftOLR(G1H2(247),4,2)
  call Hloop_AV_Q(ntryL,G1H2(80),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(109),n2h1(129))
  call Hloop_AV_Q(ntryL,G1H2(81),ex3(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(110),n2h1(130))
  call Hloop_AV_Q(ntryL,G1H2(104),ex3(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(111),n2h1(131))
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(36),mass4set(:,4),  & 
G1H2(80),G1H2(81),G1H2(104),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(81),4,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(37),mass4set(:,4),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),2)
  call HG1shiftOLR(G1H2(254),4,2)
  call Hloop_AV_Q(ntryL,G1H2(91),ex3(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(112),n2h1(132))
  call Hloop_AV_Q(ntryL,G1H2(114),ex3(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(113),n2h1(133))
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(36),mass4set(:,17),  & 
G1H2(91),G1H2(114),G1H2(258),G1H2(259),G1H2(260),2)
  call HG1shiftOLR(G1H2(114),4,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(37),mass4set(:,3),  & 
G1H2(261),G1H2(262),G1H2(263),G1H2(264),G1H2(265),2)
  call HG1shiftOLR(G1H2(262),4,2)
  call Hloop_AV_Q(ntryL,G1H2(102),ex3(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(114),n2h1(134))
  call Hloop_AV_Q(ntryL,G1H2(103),ex3(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(115),n2h1(135))
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(36),mass4set(:,18),  & 
G1H2(102),G1H2(103),G1H2(266),G1H2(267),G1H2(268),2)
  call HG1shiftOLR(G1H2(103),4,2)
  call Hloop_AV_Q(ntryL,G1H2(113),ex3(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(116),n2h1(136))
  call Hloop_VQ_A(ntryL,G1H2(118),ex2(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(117),n2h1(137))
  call Hloop_VQ_A(ntryL,G1H2(119),ex2(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(118),n2h1(138))
  call Hloop_VQ_A(ntryL,G1H2(120),ex2(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(139))
  call Hloop_ZQ_A(ntryL,G1H2(123),ex2(:),G1H1(1),ngZd,m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(120),n2h1(140))
  call Hloop_ZQ_A(ntryL,G1H2(124),ex2(:),G1H1(1),ngZd,m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(121),n2h1(141))
  call Hloop_ZQ_A(ntryL,G1H2(125),ex2(:),G1H1(1),ngZd,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(122),n2h1(142))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(39),mass4set(:,4),  & 
G1H2(113),G1H2(118),G1H2(119),G1H2(120),G1H2(123),2)
  call HG1shiftOLR(G1H2(118),4,2)
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(40),mass4set(:,4),  & 
G1H2(124),G1H2(125),G1H2(269),G1H2(270),G1H2(271),2)
  call HG1shiftOLR(G1H2(125),4,2)
  call Hloop_QV_A(ntryL,G1H2(134),ex3(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(123),n2h1(143))
  call Hloop_QV_A(ntryL,G1H2(157),ex3(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(124),n2h1(144))
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(39),mass4set(:,16),  & 
G1H2(134),G1H2(157),G1H2(272),G1H2(273),G1H2(274),2)
  call HG1shiftOLR(G1H2(157),4,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(40),mass4set(:,1),  & 
G1H2(275),G1H2(276),G1H2(277),G1H2(278),G1H2(279),2)
  call HG1shiftOLR(G1H2(276),4,2)
  call Hloop_QV_A(ntryL,G1H2(145),ex3(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(125),n2h1(145))
  call Hloop_QV_A(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(126),n2h1(146))
  call Hloop_QV_A(ntryL,G1H2(169),ex3(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(127),n2h1(147))
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(39),mass4set(:,18),  & 
G1H2(145),G1H2(146),G1H2(169),G1H2(280),G1H2(281),2)
  call HG1shiftOLR(G1H2(146),4,2)
  call Hloop_QV_A(ntryL,G1H2(156),ex3(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(128),n2h1(148))
  call Hotf_4pt_reduction(G2H2(43),RedSet_4(39),mass4set(:,17),  & 
G1H2(156),G1H2(282),G1H2(283),G1H2(284),G1H2(285),2)
  call HG1shiftOLR(G1H2(282),4,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(40),mass4set(:,3),  & 
G1H2(286),G1H2(287),G1H2(288),G1H2(289),G1H2(290),2)
  call HG1shiftOLR(G1H2(287),4,2)
  call Hloop_QV_A(ntryL,G1H2(167),ex3(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(129),n2h1(149))
  call Hloop_QV_A(ntryL,G1H2(168),ex3(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))



end subroutine vamp_1

end module ol_vamp_1_ppvvj_ew_uxdawxg_1_/**/REALKIND
