
module ol_colourmatrix_ppvvj_ew_uuxzzg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(1,2), KL(1,2), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 4]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 4]

  K2(1,:) = [ 0, 4]

  KL(1,:) = [ 0, 4]

#if -1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvj_ew_uuxzzg_1_/**/REALKIND



module ol_forced_parameters_ppvvj_ew_uuxzzg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvj_ew_uuxzzg_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppvvj_ew_uuxzzg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 72 ! number of helicity configurations
  integer(intkind2), save :: nhel = 72 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 72 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(72) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(69)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(3), ex4(3), ex5(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,17), wf6(6,34), wf8(8,5), wf9(9,1), wf12(12,36), wf18(18,17), wf72(72,72)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(57), c(51)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppvvj_ew_uuxzzg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppvvj_ew_uuxzzg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppvvj_ew_uuxzzg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*eQED**2*gQCD
    f( 2) = CI*countertermnorm*eQED**4*gQCD
    f( 3) = CI*countertermnorm*eQED**2*gQCD**3
    f( 4) = CI*countertermnorm*ctGqq*eQED**2*gQCD**3
    f( 5) = CI*countertermnorm*ctVqq*eQED**2*gQCD**3
    f( 6) = countertermnorm*ctZGG*eQED**2*gQCD**3
    f( 7) = CI*countertermnorm*ctZZGG*eQED**2*gQCD**3
    f( 8) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**3*MW)/(cw**2*sw)
    f( 9) = (4*eQED**4*gQCD*integralnorm*SwB)/9._/**/REALKIND
    f(10) = eQED**4*gQCD*integralnorm*SwB
    f(11) = CI*eQED**2*gQCD**3*integralnorm*SwB
    f(12) = eQED**2*gQCD**3*integralnorm*SwB
    f(13) = (2*eQED**4*gQCD*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f(14) = (eQED**4*gQCD*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f(15) = (cw**2*eQED**4*gQCD*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f(16) = (eQED**4*gQCD*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(17) = (cw*eQED**4*gQCD*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(18) = (cw**3*eQED**4*gQCD*integralnorm*SwB)/sw**3
    f(19) = (eQED**4*gQCD*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(20) = (eQED**4*gQCD*integralnorm*MW**2*SwB)/(cw*sw**3)
    f(21) = (eQED**4*gQCD*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(22) = (2*cw**2*eQED**4*gQCD*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(23) = (eQED**4*gQCD*integralnorm*MH**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(24) = (eQED**4*gQCD*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(25) = (eQED**4*gQCD*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(26) = (2*eQED**4*gQCD*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(27) = (eQED**4*gQCD*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(28) = (eQED**4*gQCD*integralnorm*MW**2*sw*SwB)/cw
    f(29) = (2*eQED**4*gQCD*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(30) = -((eQED**4*gQCD*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(31) = (eQED**4*gQCD*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*sw**2*3._/**/REALKIND*6._/**/REALKIND)
    f(32) = (eQED**4*gQCD*integralnorm*(cw - sw)**2*(cw + sw)**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(33) = -((eQED**4*gQCD*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*3._/**/REALKIND))
    f(34) = -((eQED**4*gQCD*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(35) = -((eQED**4*gQCD*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(36) = -((eQED**4*gQCD*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(37) = (2*eQED**4*gQCD*integralnorm*SwF)/9._/**/REALKIND
    f(38) = (4*eQED**4*gQCD*integralnorm*SwF)/9._/**/REALKIND
    f(39) = (2*eQED**4*gQCD*integralnorm*SwF)/3._/**/REALKIND
    f(40) = (8*eQED**4*gQCD*integralnorm*SwF)/9._/**/REALKIND
    f(41) = eQED**4*gQCD*integralnorm*SwF
    f(42) = 2*eQED**4*gQCD*integralnorm*SwF
    f(43) = 3*eQED**4*gQCD*integralnorm*SwF
    f(44) = eQED**2*gQCD**3*integralnorm*SwF
    f(45) = 2*eQED**2*gQCD**3*integralnorm*SwF
    f(46) = (eQED**4*gQCD*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(47) = (eQED**4*gQCD*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(48) = (eQED**2*gQCD**3*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(49) = (eQED**4*gQCD*integralnorm*ME*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(50) = (eQED**4*gQCD*integralnorm*ME*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(51) = (eQED**4*gQCD*integralnorm*ML*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(52) = (eQED**4*gQCD*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(53) = (eQED**4*gQCD*integralnorm*MM*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(54) = (eQED**4*gQCD*integralnorm*MM*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(55) = (2*eQED**4*gQCD*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(56) = (eQED**4*gQCD*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(57) = (eQED**2*gQCD**3*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 6*f(9), 6*f(10), 9*CI*f(11), f(12), 8*f(12), 6*f(13), 6*f(14), 6*f(15), 6*f(16), 6*f(17), 6*f(18), 6*f(19), 6*f(20) &
    , 6*f(21), 6*f(22), 6*f(23), 6*f(24), 6*f(25), 6*f(26), 6*f(27), 6*f(28), 6*f(29), 6*f(30), 6*f(31), 6*f(32), 6*f(33), 6*f(34) &
    , 6*f(35), 6*f(36), 18*f(37), 18*f(38), 6*f(39), 18*f(40), 6*f(41), 18*f(41), 18*f(42), 6*f(43), 3*f(44), 3*f(45), 18*f(46) &
    , 18*f(47), 3*f(48), 6*f(49), 6*f(50), 6*f(51), 6*f(52), 6*f(53), 6*f(54), 18*f(55), 18*f(56), 3*f(57) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5))+L(6,5))
  den(2) = 1 /((L(5,10))+L(6,10))
  den(4) = 1 /((L(5,18))+L(6,18))
  den(6) = 1 /((L(5,9))+L(6,9))
  den(7) = 1 /((L(5,6))+L(6,6))
  den(9) = 1 /((L(5,17))+L(6,17))
  den(13) = 1 /((L(5,3))+L(6,3))
  den(14) = 1 /((L(5,12) - MH2)+L(6,12))
  den(16) = 1 /((L(5,24))+L(6,24))
  den(19) = 1 /((L(5,20))+L(6,20))
  den(22) = 1 /((L(5,26))+L(6,26))
  den(25) = 1 /((L(5,21))+L(6,21))
  den(30) = 1 /((L(5,13))+L(6,13))
  den(33) = 1 /((L(5,22))+L(6,22))
  den(36) = 1 /((L(5,25))+L(6,25))
  den(39) = 1 /((L(5,14))+L(6,14))
  den(52) = 1 /((L(5,7))+L(6,7))
  den(55) = 1 /((L(5,11))+L(6,11))
  den(58) = 1 /((L(5,19))+L(6,19))
  den(60) = 1 /((L(5,19) - MZ2)+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(8) = den(6)*den(7)
  den(10) = den(7)*den(9)
  den(11) = den(4)*den(6)
  den(12) = den(2)*den(9)
  den(15) = den(13)*den(14)
  den(17) = den(1)*den(16)
  den(18) = den(7)*den(16)
  den(20) = den(6)*den(19)
  den(21) = den(2)*den(19)
  den(23) = den(2)*den(22)
  den(24) = den(1)*den(23)
  den(26) = den(1)*den(25)
  den(27) = den(2)*den(26)
  den(28) = den(4)*den(22)
  den(29) = den(1)*den(28)
  den(31) = den(1)*den(30)
  den(32) = den(4)*den(31)
  den(34) = den(7)*den(33)
  den(35) = den(6)*den(34)
  den(37) = den(6)*den(36)
  den(38) = den(7)*den(37)
  den(40) = den(7)*den(39)
  den(41) = den(9)*den(40)
  den(42) = den(9)*den(36)
  den(43) = den(7)*den(42)
  den(44) = den(4)*den(33)
  den(45) = den(6)*den(44)
  den(46) = den(6)*den(30)
  den(47) = den(4)*den(46)
  den(48) = den(2)*den(39)
  den(49) = den(9)*den(48)
  den(50) = den(9)*den(25)
  den(51) = den(2)*den(50)
  den(53) = den(1)*den(52)
  den(54) = den(7)*den(52)
  den(56) = den(6)*den(55)
  den(57) = den(2)*den(55)
  den(59) = den(9)*den(58)
  den(61) = den(9)*den(60)
  den(62) = den(4)*den(58)
  den(63) = den(4)*den(60)
  den(64) = den(9)*den(14)
  den(65) = den(4)*den(14)
  den(66) = den(14)*den(59)
  den(67) = den(14)*den(61)
  den(68) = den(14)*den(62)
  den(69) = den(14)*den(63)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvj_ew_uuxzzg_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,72))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(2,hel_states))
  allocate(M0_col1_helarray(2,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(2,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppvvj_ew_uuxzzg_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-up Z Z glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppvvj_ew_uuxzzg_1, only: hel_mem_opt
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppvvj_ew_uuxzzg_1, only: &
    & external_perm_ppvvj_ew_uuxzzg_1, &
    & external_perm_inv_ppvvj_ew_uuxzzg_1, &
    & extcomb_perm_ppvvj_ew_uuxzzg_1, &
    & average_factor_ppvvj_ew_uuxzzg_1, &
    & photonid_ppvvj_ew_uuxzzg_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppvvj_ew_uuxzzg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppvvj_ew_uuxzzg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppvvj_ew_uuxzzg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppvvj_ew_uuxzzg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(72)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,72))
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMZ, nMZ, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppvvj_ew_uuxzzg_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rMZ, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMZ, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_ZQ_A(gZu,ntry, ex3(:), ex1(:), wf6(:,1), n3(:,1), t3x6(:,:,1))
  call vert_AZ_Q(gZu,ntry, ex2(:), ex4(:), wf6(:,2), n3(:,2), t3x6(:,:,2))
  call prop_Q_A(ntry, wf6(:,1), 5, ZERO, 0_intkind1, wf6(:,3), n2(1))
  call prop_A_Q(ntry, wf6(:,2), 10, ZERO, 0_intkind1, wf6(:,4), n2(2))
  call vert_VQ_A(ntry, ex5(:), wf6(:,3), wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,1), n3(:,4), t3x4(:,:,1))
  call prop_A_Q(ntry, wf4(:,1), 18, ZERO, 0_intkind1, wf4(:,2), n2(3))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,3), wf18(:,1), n3(:,5), t3x18(:,:,1))
  call vert_ZQ_A(gZu,ntry, ex4(:), ex1(:), wf6(:,5), n3(:,6), t3x6(:,:,3))
  call vert_AZ_Q(gZu,ntry, ex2(:), ex3(:), wf6(:,6), n3(:,7), t3x6(:,:,4))
  call prop_Q_A(ntry, wf6(:,5), 9, ZERO, 0_intkind1, wf6(:,7), n2(4))
  call prop_A_Q(ntry, wf6(:,6), 6, ZERO, 0_intkind1, wf6(:,8), n2(5))
  call vert_VQ_A(ntry, ex5(:), wf6(:,7), wf12(:,2), n3(:,8), t3x12(:,:,2))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,3), n3(:,9), t3x4(:,:,2))
  call prop_Q_A(ntry, wf4(:,3), 17, ZERO, 0_intkind1, wf4(:,4), n2(6))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf4(:,4), wf12(:,3), n3(:,10), t3x12(:,:,3))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,7), wf18(:,2), n3(:,11), t3x18(:,:,2))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf4(:,4), wf12(:,4), n3(:,12), t3x12(:,:,4))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,5), n3(:,13), t3x4(:,:,3))
  call counter_VVG_G(ntry, ex3(:), ex4(:), ex5(:), wf18(:,3), n4(:,1), t4x18(:,:,1))
  call vert_VV_S(ntry, ex3(:), ex4(:), wf9(:,1), n3(:,14), t3x9(:,:,1))
  call counter_GG_S(ntry, wf4(:,5), ex5(:), wf8(:,1), n3(:,15), t3x8(:,:,1))
  call counter_VQ_A(ntry, ex5(:), wf6(:,3), wf12(:,5), n3(:,16), t3x12(:,:,5))
  call counter_VQ_A_LR(EWctGuu,ntry, ex5(:), wf6(:,3), wf12(:,6), n3(:,17), t3x12(:,:,6))
  call counter_ZQ_A(gZu,ntry, ex4(:), wf6(:,3), wf18(:,4), n3(:,18), t3x18(:,:,3))
  call counter_ZQ_A(EWctVuu,ntry, ex4(:), wf6(:,3), wf18(:,5), n3(:,19), t3x18(:,:,4))
  call counter_VG_G(ntry, ex4(:), ex5(:), 16, wf6(:,9), 24, n3(:,20), t3x6(:,:,5))
  call vert_QA_V(ntry, wf6(:,3), ex2(:), wf12(:,7), n3(:,21), t3x12(:,:,7))
  call counter_VQ_A(ntry, ex5(:), wf6(:,7), wf12(:,8), n3(:,22), t3x12(:,:,8))
  call counter_VQ_A_LR(EWctGuu,ntry, ex5(:), wf6(:,7), wf12(:,9), n3(:,23), t3x12(:,:,9))
  call counter_ZQ_A(gZu,ntry, ex4(:), wf4(:,4), wf12(:,10), n3(:,24), t3x12(:,:,10))
  call counter_ZQ_A(EWctVuu,ntry, ex4(:), wf4(:,4), wf12(:,11), n3(:,25), t3x12(:,:,11))
  call vert_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,12), n3(:,26), t3x12(:,:,12))
  call counter_ZQ_A(gZu,ntry, ex3(:), wf6(:,7), wf18(:,6), n3(:,27), t3x18(:,:,5))
  call counter_ZQ_A(EWctVuu,ntry, ex3(:), wf6(:,7), wf18(:,7), n3(:,28), t3x18(:,:,6))
  call counter_VG_G(ntry, ex3(:), ex5(:), 16, wf6(:,10), 20, n3(:,29), t3x6(:,:,6))
  call vert_QA_V(ntry, wf6(:,7), ex2(:), wf12(:,13), n3(:,30), t3x12(:,:,13))
  call counter_ZQ_A(gZu,ntry, ex3(:), wf4(:,4), wf12(:,14), n3(:,31), t3x12(:,:,14))
  call counter_ZQ_A(EWctVuu,ntry, ex3(:), wf4(:,4), wf12(:,15), n3(:,32), t3x12(:,:,15))
  call vert_QA_V(ntry, ex1(:), wf6(:,4), wf12(:,16), n3(:,33), t3x12(:,:,16))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,6), n3(:,34), t3x4(:,:,4))
  call prop_A_Q(ntry, wf4(:,6), 18, ZERO, 0_intkind1, wf4(:,7), n2(7))
  call counter_AV_Q_LR(EWctGuu,ntry, ex2(:), ex5(:), wf4(:,8), n3(:,35), t3x4(:,:,5))
  call prop_A_Q(ntry, wf4(:,8), 18, ZERO, 0_intkind1, wf4(:,9), n2(8))
  call counter_AZ_Q(gZu,ntry, ex2(:), ex4(:), wf6(:,11), n3(:,36), t3x6(:,:,7))
  call prop_A_Q(ntry, wf6(:,11), 10, ZERO, 0_intkind1, wf6(:,12), n2(9))
  call counter_AZ_Q(EWctVuu,ntry, ex2(:), ex4(:), wf6(:,13), n3(:,37), t3x6(:,:,8))
  call prop_A_Q(ntry, wf6(:,13), 10, ZERO, 0_intkind1, wf6(:,14), n2(10))
  call counter_AZ_Q(gZu,ntry, ex2(:), ex3(:), wf6(:,15), n3(:,38), t3x6(:,:,9))
  call prop_A_Q(ntry, wf6(:,15), 6, ZERO, 0_intkind1, wf6(:,16), n2(11))
  call counter_AZ_Q(EWctVuu,ntry, ex2(:), ex3(:), wf6(:,17), n3(:,39), t3x6(:,:,10))
  call prop_A_Q(ntry, wf6(:,17), 6, ZERO, 0_intkind1, wf6(:,18), n2(12))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,10), n3(:,40), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,10), 17, ZERO, 0_intkind1, wf4(:,11), n2(13))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf4(:,11), wf12(:,17), n3(:,41), t3x12(:,:,17))
  call counter_VQ_A_LR(EWctGuu,ntry, ex5(:), ex1(:), wf4(:,12), n3(:,42), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,12), 17, ZERO, 0_intkind1, wf4(:,13), n2(14))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf4(:,13), wf12(:,18), n3(:,43), t3x12(:,:,18))
  call counter_ZQ_A(gZu,ntry, ex4(:), ex1(:), wf6(:,19), n3(:,44), t3x6(:,:,11))
  call prop_Q_A(ntry, wf6(:,19), 9, ZERO, 0_intkind1, wf6(:,20), n2(15))
  call vert_VQ_A(ntry, ex5(:), wf6(:,20), wf12(:,19), n3(:,45), t3x12(:,:,19))
  call counter_ZQ_A(EWctVuu,ntry, ex4(:), ex1(:), wf6(:,21), n3(:,46), t3x6(:,:,12))
  call prop_Q_A(ntry, wf6(:,21), 9, ZERO, 0_intkind1, wf6(:,22), n2(16))
  call vert_VQ_A(ntry, ex5(:), wf6(:,22), wf12(:,20), n3(:,47), t3x12(:,:,20))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf4(:,11), wf12(:,21), n3(:,48), t3x12(:,:,21))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf4(:,13), wf12(:,22), n3(:,49), t3x12(:,:,22))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,20), wf18(:,8), n3(:,50), t3x18(:,:,7))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,22), wf18(:,9), n3(:,51), t3x18(:,:,8))
  call counter_ZQ_A(gZu,ntry, ex3(:), ex1(:), wf6(:,23), n3(:,52), t3x6(:,:,13))
  call prop_Q_A(ntry, wf6(:,23), 5, ZERO, 0_intkind1, wf6(:,24), n2(17))
  call vert_VQ_A(ntry, ex5(:), wf6(:,24), wf12(:,23), n3(:,53), t3x12(:,:,23))
  call counter_ZQ_A(EWctVuu,ntry, ex3(:), ex1(:), wf6(:,25), n3(:,54), t3x6(:,:,14))
  call prop_Q_A(ntry, wf6(:,25), 5, ZERO, 0_intkind1, wf6(:,26), n2(18))
  call vert_VQ_A(ntry, ex5(:), wf6(:,26), wf12(:,24), n3(:,55), t3x12(:,:,24))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,24), wf18(:,10), n3(:,56), t3x18(:,:,9))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,26), wf18(:,11), n3(:,57), t3x18(:,:,10))
  call vert_AV_Q(ntry, wf6(:,4), ex5(:), wf12(:,25), n3(:,58), t3x12(:,:,25))
  call counter_Q_A(ctqq,2,ntry, wf6(:,3), 5, wf6(:,27), n2(19))
  call prop_A_Q(ntry, wf12(:,25), 26, ZERO, 0_intkind1, wf12(:,26), n2(20))
  call counter_Q_A_LR(EWctuu,ntry, wf6(:,3), 5, wf6(:,28), n2(21))
  call counter_A_Q(ctqq,2,ntry, wf6(:,4), 10, wf6(:,29), n2(22))
  call prop_Q_A(ntry, wf12(:,1), 21, ZERO, 0_intkind1, wf12(:,27), n2(23))
  call counter_A_Q_LR(EWctuu,ntry, wf6(:,4), 10, wf6(:,30), n2(24))
  call vert_AZ_Q(gZu,ntry, wf4(:,2), ex4(:), wf12(:,28), n3(:,59), t3x12(:,:,26))
  call prop_A_Q(ntry, wf12(:,28), 26, ZERO, 0_intkind1, wf12(:,29), n2(25))
  call counter_A_Q(ctqq,2,ntry, wf4(:,2), 18, wf4(:,14), n2(26))
  call prop_Q_A(ntry, wf18(:,1), 13, ZERO, 0_intkind1, wf18(:,12), n2(27))
  call counter_A_Q_LR(EWctuu,ntry, wf4(:,2), 18, wf4(:,15), n2(28))
  call vert_AV_Q(ntry, wf6(:,8), ex5(:), wf12(:,30), n3(:,60), t3x12(:,:,27))
  call counter_Q_A(ctqq,2,ntry, wf6(:,7), 9, wf6(:,31), n2(29))
  call prop_A_Q(ntry, wf12(:,30), 22, ZERO, 0_intkind1, wf12(:,31), n2(30))
  call counter_Q_A_LR(EWctuu,ntry, wf6(:,7), 9, wf6(:,32), n2(31))
  call counter_A_Q(ctqq,2,ntry, wf6(:,8), 6, wf6(:,33), n2(32))
  call prop_Q_A(ntry, wf12(:,2), 25, ZERO, 0_intkind1, wf12(:,32), n2(33))
  call counter_A_Q_LR(EWctuu,ntry, wf6(:,8), 6, wf6(:,34), n2(34))
  call vert_AZ_Q(gZu,ntry, wf6(:,8), ex4(:), wf18(:,13), n3(:,61), t3x18(:,:,11))
  call counter_Q_A(ctqq,2,ntry, wf4(:,4), 17, wf4(:,16), n2(35))
  call prop_A_Q(ntry, wf18(:,13), 14, ZERO, 0_intkind1, wf18(:,14), n2(36))
  call counter_Q_A_LR(EWctuu,ntry, wf4(:,4), 17, wf4(:,17), n2(37))
  call prop_Q_A(ntry, wf12(:,3), 25, ZERO, 0_intkind1, wf12(:,33), n2(38))
  call vert_AZ_Q(gZu,ntry, wf4(:,2), ex3(:), wf12(:,34), n3(:,62), t3x12(:,:,28))
  call prop_A_Q(ntry, wf12(:,34), 22, ZERO, 0_intkind1, wf12(:,35), n2(39))
  call prop_Q_A(ntry, wf18(:,2), 13, ZERO, 0_intkind1, wf18(:,15), n2(40))
  call vert_AZ_Q(gZu,ntry, wf6(:,4), ex3(:), wf18(:,16), n3(:,63), t3x18(:,:,12))
  call prop_A_Q(ntry, wf18(:,16), 14, ZERO, 0_intkind1, wf18(:,17), n2(41))
  call prop_Q_A(ntry, wf12(:,4), 21, ZERO, 0_intkind1, wf12(:,36), n2(42))
  call vert_QA_V(ntry, wf4(:,4), ex2(:), wf8(:,2), n3(:,64), t3x8(:,:,2))
  call vert_QA_Z(gZu,ntry, wf4(:,4), ex2(:), wf8(:,3), n3(:,65), t3x8(:,:,3))
  call vert_QA_V(ntry, ex1(:), wf4(:,2), wf8(:,4), n3(:,66), t3x8(:,:,4))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,2), wf8(:,5), n3(:,67), t3x8(:,:,5))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppvvj_ew_uuxzzg_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

#if -1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
  
  M0M1_hel_cc(:,:,:)%j = 0
  M2ctcc = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 2
do i4= 1, 3
do i3= 1, 3
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf6(:,4), wf12(:,1), A(:,1), n3(:,68), t3x72(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,1), A(:,2), n3(:,69), t3x72(:,:,2), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,2), A(:,3), n3(:,70), t3x72(:,:,3), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,3), A(:,4), n3(:,71), t3x72(:,:,4), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,2), A(:,5), n3(:,72), t3x72(:,:,5), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,4), A(:,6), n3(:,73), t3x72(:,:,6), nhel, den(12))

    call Hcont_VV(nsync, wf4(:,5), wf18(:,3), A(:,7), n3(:,74), t3x72(:,:,7), nhel, den(13))
    call Hcont_SS(nsync, wf9(:,1), wf8(:,1), A(:,8), n3(:,75), t3x72(:,:,8), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,5), A(:,9), n3(:,76), t3x72(:,:,9), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,6), A(:,10), n3(:,77), t3x72(:,:,10), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,4), A(:,11), n3(:,78), t3x72(:,:,11), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,5), A(:,12), n3(:,79), t3x72(:,:,12), nhel, den(5))
    call Hcont_VV(nsync, wf6(:,9), wf12(:,7), A(:,13), n3(:,80), t3x72(:,:,13), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,8), A(:,14), n3(:,81), t3x72(:,:,14), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,9), A(:,15), n3(:,82), t3x72(:,:,15), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,10), A(:,16), n3(:,83), t3x72(:,:,16), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,11), A(:,17), n3(:,84), t3x72(:,:,17), nhel, den(10))
    call Hcont_VV(nsync, wf6(:,9), wf12(:,12), A(:,18), n3(:,85), t3x72(:,:,18), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,6), A(:,19), n3(:,86), t3x72(:,:,19), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,7), A(:,20), n3(:,87), t3x72(:,:,20), nhel, den(11))
    call Hcont_VV(nsync, wf6(:,10), wf12(:,13), A(:,21), n3(:,88), t3x72(:,:,21), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,14), A(:,22), n3(:,89), t3x72(:,:,22), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,15), A(:,23), n3(:,90), t3x72(:,:,23), nhel, den(12))
    call Hcont_VV(nsync, wf6(:,10), wf12(:,16), A(:,24), n3(:,91), t3x72(:,:,24), nhel, den(21))
    call Hcont_QA(nsync, wf18(:,1), wf4(:,7), A(:,25), n3(:,92), t3x72(:,:,25), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,1), wf4(:,9), A(:,26), n3(:,93), t3x72(:,:,26), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,1), wf6(:,12), A(:,27), n3(:,94), t3x72(:,:,27), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,1), wf6(:,14), A(:,28), n3(:,95), t3x72(:,:,28), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,2), wf4(:,7), A(:,29), n3(:,96), t3x72(:,:,29), nhel, den(11))
    call Hcont_QA(nsync, wf18(:,2), wf4(:,9), A(:,30), n3(:,97), t3x72(:,:,30), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,4), wf6(:,12), A(:,31), n3(:,98), t3x72(:,:,31), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,4), wf6(:,14), A(:,32), n3(:,99), t3x72(:,:,32), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,2), wf6(:,16), A(:,33), n3(:,100), t3x72(:,:,33), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,2), wf6(:,18), A(:,34), n3(:,101), t3x72(:,:,34), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,3), wf6(:,16), A(:,35), n3(:,102), t3x72(:,:,35), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,3), wf6(:,18), A(:,36), n3(:,103), t3x72(:,:,36), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,17), A(:,37), n3(:,104), t3x72(:,:,37), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,18), A(:,38), n3(:,105), t3x72(:,:,38), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,19), A(:,39), n3(:,106), t3x72(:,:,39), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,20), A(:,40), n3(:,107), t3x72(:,:,40), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,21), A(:,41), n3(:,108), t3x72(:,:,41), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,22), A(:,42), n3(:,109), t3x72(:,:,42), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,8), A(:,43), n3(:,110), t3x72(:,:,43), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,9), A(:,44), n3(:,111), t3x72(:,:,44), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,23), A(:,45), n3(:,112), t3x72(:,:,45), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,24), A(:,46), n3(:,113), t3x72(:,:,46), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,10), A(:,47), n3(:,114), t3x72(:,:,47), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,11), A(:,48), n3(:,115), t3x72(:,:,48), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,27), wf12(:,26), A(:,49), n3(:,116), t3x72(:,:,49), nhel, den(24))
    call Hcont_QA(nsync, wf12(:,26), wf6(:,28), A(:,50), n3(:,117), t3x72(:,:,50), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,29), wf12(:,27), A(:,51), n3(:,118), t3x72(:,:,51), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,27), wf6(:,30), A(:,52), n3(:,119), t3x72(:,:,52), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,27), wf12(:,29), A(:,53), n3(:,120), t3x72(:,:,53), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,28), wf12(:,29), A(:,54), n3(:,121), t3x72(:,:,54), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,12), A(:,55), n3(:,122), t3x72(:,:,55), nhel, den(32))
    call Hcont_QA(nsync, wf18(:,12), wf4(:,15), A(:,56), n3(:,123), t3x72(:,:,56), nhel, den(32))
    call Hcont_QA(nsync, wf6(:,31), wf12(:,31), A(:,57), n3(:,124), t3x72(:,:,57), nhel, den(35))
    call Hcont_QA(nsync, wf12(:,31), wf6(:,32), A(:,58), n3(:,125), t3x72(:,:,58), nhel, den(35))
    call Hcont_QA(nsync, wf6(:,33), wf12(:,32), A(:,59), n3(:,126), t3x72(:,:,59), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,32), wf6(:,34), A(:,60), n3(:,127), t3x72(:,:,60), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,14), A(:,61), n3(:,128), t3x72(:,:,61), nhel, den(41))
    call Hcont_QA(nsync, wf18(:,14), wf4(:,17), A(:,62), n3(:,129), t3x72(:,:,62), nhel, den(41))
    call Hcont_QA(nsync, wf6(:,33), wf12(:,33), A(:,63), n3(:,130), t3x72(:,:,63), nhel, den(43))
    call Hcont_QA(nsync, wf6(:,34), wf12(:,33), A(:,64), n3(:,131), t3x72(:,:,64), nhel, den(43))
    call Hcont_QA(nsync, wf6(:,31), wf12(:,35), A(:,65), n3(:,132), t3x72(:,:,65), nhel, den(45))
    call Hcont_QA(nsync, wf6(:,32), wf12(:,35), A(:,66), n3(:,133), t3x72(:,:,66), nhel, den(45))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,15), A(:,67), n3(:,134), t3x72(:,:,67), nhel, den(47))
    call Hcont_QA(nsync, wf4(:,15), wf18(:,15), A(:,68), n3(:,135), t3x72(:,:,68), nhel, den(47))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,17), A(:,69), n3(:,136), t3x72(:,:,69), nhel, den(49))
    call Hcont_QA(nsync, wf4(:,17), wf18(:,17), A(:,70), n3(:,137), t3x72(:,:,70), nhel, den(49))
    call Hcont_QA(nsync, wf6(:,29), wf12(:,36), A(:,71), n3(:,138), t3x72(:,:,71), nhel, den(51))
    call Hcont_QA(nsync, wf6(:,30), wf12(:,36), A(:,72), n3(:,139), t3x72(:,:,72), nhel, den(51))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(2) ! M1helarray(2,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j+A(j,2)%j+A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,6)%j)*f(1)

  M2(1)%j = (-A(j,49)%j-A(j,51)%j-A(j,53)%j-A(j,55)%j-A(j,57)%j-A(j,59)%j-A(j,61)%j-A(j,63)%j-A(j,65)%j-A(j,67)%j-A(j,69)%j &
       -A(j,71)%j)*f(3)+(A(j,9)%j+A(j,14)%j+A(j,25)%j+A(j,29)%j+A(j,37)%j+A(j,41)%j)*f(4)+(A(j,11)%j+A(j,16)%j+A(j,19)%j+A(j,22)%j &
       +A(j,27)%j+A(j,31)%j+A(j,33)%j+A(j,35)%j+A(j,39)%j+A(j,43)%j+A(j,45)%j+A(j,47)%j)*f(5)+(-A(j,13)%j-A(j,18)%j-A(j,21)%j &
       -A(j,24)%j)*f(6)+A(j,7)%j*f(7)-A(j,8)%j*f(8)
  M2(2)%j = (A(j,10)%j+A(j,12)%j+A(j,15)%j+A(j,17)%j+A(j,20)%j+A(j,23)%j+A(j,26)%j+A(j,28)%j+A(j,30)%j+A(j,32)%j+A(j,34)%j &
       +A(j,36)%j+A(j,38)%j+A(j,40)%j+A(j,42)%j+A(j,44)%j+A(j,46)%j+A(j,48)%j-A(j,50)%j-A(j,52)%j-A(j,54)%j-A(j,56)%j-A(j,58)%j &
       -A(j,60)%j-A(j,62)%j-A(j,64)%j-A(j,66)%j-A(j,68)%j-A(j,70)%j-A(j,72)%j)*f(2)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvj_ew_uuxzzg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvj_ew_uuxzzg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppvvj_ew_uuxzzg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvj_ew_uuxzzg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppvvj_ew_uuxzzg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppvvj_ew_uuxzzg_1_/**/REALKIND
