
module ol_vamp_3_ppvvj_ew_uuxwwxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj_ew_uuxwwxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj_ew_uuxwwxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvj_ew_uuxwwxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvj_ew_uuxwwxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvj_ew_uuxwwxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvj_ew_uuxwwxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(72)
  type(Hpolcont), intent(in) :: M(2,72)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(207),h0tab(:,207),[21,2,8],[0,nMW,0],3,1,wf12(:,11))
  call Hloop_VQ_A(ntryL,G0H72(1),wf12(:,11),G0H6(4),m3h12x6(:,5),heltab2x72(:,:,207))
  call Hloop_Q_A(ntryL,G0H6(4),21,0,G1H6(115),n2h6(43))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(208),h0tab(:,208),[21,2,8],[0,nMZ,nMW],3,1,wf12(:,11))
  call Hloop_WQ_A(ntryL,G0H72(1),wf12(:,11),G0H6(4),m3h12x6(:,6),heltab2x72(:,:,208))
  call Hloop_Q_A(ntryL,G0H6(4),21,0,G1H6(116),n2h6(44))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(209),h0tab(:,209),[21,2,8],[0,nMW,nMZ],3,1,wf12(:,11))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf12(:,11),G0H6(4),ngZd,m3h12x6(:,7),heltab2x72(:,:,209))
  call Hloop_Q_A(ntryL,G0H6(4),21,0,G1H6(119),n2h6(45))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(210),h0tab(:,210),[17,4,10],[0,0,0],3,2,wf4(:,4),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(2),m3h4x18(:,72),heltab2x72(:,:,210))
  call Hloop_Q_A(ntryL,G0H18(2),17,0,G1H18(35),n2h18(67))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(211),h0tab(:,211),[17,4,10],[0,0,nMZ],3,2,wf4(:,4),wf6(:,4))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(3),ngZu,m3h4x18(:,73),heltab2x72(:,:,211))
  call Hloop_Q_A(ntryL,G0H18(3),17,0,G1H18(36),n2h18(68))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(212),h0tab(:,212),[17,4,10],[0,0,0],3,2,wf4(:,4),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(6),m3h4x18(:,74),heltab2x72(:,:,212))
  call Hloop_Q_A(ntryL,G0H18(6),17,0,G1H18(37),n2h18(69))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(213),h0tab(:,213),[17,4,10],[0,nMW,0],3,2,wf4(:,4),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,4),G0H18(5),m3h4x18(:,75),heltab2x72(:,:,213))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(214),h0tab(:,214),[17,4,10],[nMW,0,0],3,2,wf4(:,4),wf6(:,4))
  call Hloop_AQ_W(ntryL,G0H72(1),wf4(:,4),G0H18(7),m3h4x18(:,76),heltab2x72(:,:,214))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(215),h0tab(:,215),[17,4,10],[nMZ,nMW,0],3,2,wf4(:,4),wf6(:,4))
  call Hloop_AQ_Z(ntryL,G0H72(1),wf4(:,4),G0H18(8),ngZu,m3h4x18(:,77),heltab2x72(:,:,215))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(216),h0tab(:,216),[17,4,10],[nMW,nMZ,0],3,2,wf4(:,4),wf6(:,4))
  call Hloop_AQ_W(ntryL,G0H72(1),wf4(:,4),G0H18(13),m3h4x18(:,78),heltab2x72(:,:,216))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(217),h0tab(:,217),[16,1,14],[0,0,0],3,1,wf18(:,7))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,132),heltab2x72(:,:,217))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(22),n2h36(125))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(218),h0tab(:,218),[16,1,14],[0,nMZ,0],3,1,wf18(:,7))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,133),heltab2x72(:,:,218))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(25),n2h36(126))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(219),h0tab(:,219),[16,1,14],[0,nMW,0],3,1,wf18(:,7))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,134),heltab2x72(:,:,219))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(24),n2h36(127))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(220),h0tab(:,220),[16,1,14],[0,0,0],3,1,wf18(:,7))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,135),heltab2x72(:,:,220))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(28),n2h36(128))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(221),h0tab(:,221),[16,1,14],[0,0,0],3,1,wf18(:,7))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(27),m3h2x36(:,136),heltab2x72(:,:,221))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(222),h0tab(:,222),[26,1,4],[0,0,0],3,1,wf12(:,10))
  call Hloop_QA_V(ntryL,G0H72(1),wf12(:,10),G0H6(4),m3h12x6(:,8),heltab2x72(:,:,222))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(223),h0tab(:,223),[26,1,4],[nMZ,0,0],3,1,wf12(:,10))
  call Hloop_QA_Z(ntryL,G0H72(1),wf12(:,10),G0H6(5),ngZd,m3h12x6(:,9),heltab2x72(:,:,223))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(224),h0tab(:,224),[26,1,4],[0,0,0],3,1,wf12(:,10))
  call Hloop_QA_V(ntryL,G0H72(1),wf12(:,10),G0H6(6),m3h12x6(:,10),heltab2x72(:,:,224))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(225),h0tab(:,225),[26,1,4],[0,0,nMW],3,1,wf12(:,10))
  call Hloop_WA_Q(ntryL,G0H72(1),wf12(:,10),G0H6(7),m3h12x6(:,11),heltab2x72(:,:,225))
  call Hloop_A_Q(ntryL,G0H6(7),26,0,G1H6(120),n2h6(46))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(226),h0tab(:,226),[26,1,4],[0,nMW,0],3,1,wf12(:,10))
  call Hloop_VA_Q(ntryL,G0H72(1),wf12(:,10),G0H6(7),m3h12x6(:,12),heltab2x72(:,:,226))
  call Hloop_A_Q(ntryL,G0H6(7),26,0,G1H6(121),n2h6(47))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(227),h0tab(:,227),[26,1,4],[0,nMZ,nMW],3,1,wf12(:,10))
  call Hloop_WA_Q(ntryL,G0H72(1),wf12(:,10),G0H6(7),m3h12x6(:,13),heltab2x72(:,:,227))
  call Hloop_A_Q(ntryL,G0H6(7),26,0,G1H6(122),n2h6(48))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(228),h0tab(:,228),[26,1,4],[0,nMW,nMZ],3,1,wf12(:,10))
  call Hloop_ZA_Q(ntryL,G0H72(1),wf12(:,10),G0H6(7),ngZd,m3h12x6(:,14),heltab2x72(:,:,228))
  call Hloop_A_Q(ntryL,G0H6(7),26,0,G1H6(125),n2h6(49))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(229),h0tab(:,229),[17,2,12],[0,nMZ,nMZ],3,2,wf4(:,4),wf9(:,2))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(4),ngZu,m3h4x18(:,79),heltab2x72(:,:,229))
  call Hloop_Q_A(ntryL,G0H18(4),17,0,G1H18(38),n2h18(70))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(230),h0tab(:,230),[17,2,12],[0,nMW,nMW],3,2,wf4(:,4),wf9(:,2))
  call Hloop_WQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(9),m3h4x18(:,80),heltab2x72(:,:,230))
  call Hloop_Q_A(ntryL,G0H18(9),17,0,G1H18(39),n2h18(71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(231),h0tab(:,231),[17,2,12],[0,0,0],3,2,wf4(:,4),wf9(:,1))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,4),G0H18(1),m3h4x18(:,81),heltab2x72(:,:,231))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(232),h0tab(:,232),[17,2,12],[nMZ,0,0],3,2,wf4(:,4),wf9(:,1))
  call Hloop_AQ_Z(ntryL,G0H72(1),wf4(:,4),G0H18(2),ngZu,m3h4x18(:,82),heltab2x72(:,:,232))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(233),h0tab(:,233),[17,2,12],[nMW,0,0],3,2,wf4(:,4),wf9(:,1))
  call Hloop_AQ_W(ntryL,G0H72(1),wf4(:,4),G0H18(3),m3h4x18(:,83),heltab2x72(:,:,233))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(234),h0tab(:,234),[17,2,12],[0,0,0],3,2,wf4(:,4),wf9(:,1))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,4),G0H18(6),m3h4x18(:,84),heltab2x72(:,:,234))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(235),h0tab(:,235),[17,2,12],[0,0,0],3,2,wf4(:,4),wf9(:,1))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,4),G0H18(4),m3h4x18(:,85),heltab2x72(:,:,235))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(236),h0tab(:,236),[17,2,12],[nMZ,0,0],3,2,wf4(:,4),wf9(:,1))
  call Hloop_AQ_Z(ntryL,G0H72(1),wf4(:,4),G0H18(9),ngZu,m3h4x18(:,86),heltab2x72(:,:,236))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(237),h0tab(:,237),[17,2,12],[nMW,0,0],3,2,wf4(:,4),wf9(:,1))
  call Hloop_AQ_W(ntryL,G0H72(1),wf4(:,4),G0H18(14),m3h4x18(:,87),heltab2x72(:,:,237))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(238),h0tab(:,238),[17,2,12],[0,0,0],3,2,wf4(:,4),wf9(:,1))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,4),G0H18(15),m3h4x18(:,88),heltab2x72(:,:,238))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(239),h0tab(:,239),[17,2,12],[0,nMW,nMW],3,2,wf4(:,4),wf9(:,1))
  call Hloop_WQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(16),m3h4x18(:,89),heltab2x72(:,:,239))
  call Hloop_Q_A(ntryL,G0H18(16),17,0,G1H18(40),n2h18(72))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(240),h0tab(:,240),[17,2,12],[0,nMW,nMW],3,2,wf4(:,4),wf9(:,1))
  call Hloop_WQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(16),m3h4x18(:,90),heltab2x72(:,:,240))
  call Hloop_Q_A(ntryL,G0H18(16),17,0,G1H18(41),n2h18(73))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(241),h0tab(:,241),[18,1,12],[0,nMZ,nMZ],3,2,wf4(:,2),wf9(:,2))
  call Hloop_ZA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(16),ngZu,m3h4x18(:,91),heltab2x72(:,:,241))
  call Hloop_A_Q(ntryL,G0H18(16),18,0,G1H18(42),n2h18(74))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(242),h0tab(:,242),[18,1,12],[0,nMW,nMW],3,2,wf4(:,2),wf9(:,2))
  call Hloop_WA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(16),m3h4x18(:,92),heltab2x72(:,:,242))
  call Hloop_A_Q(ntryL,G0H18(16),18,0,G1H18(43),n2h18(75))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(243),h0tab(:,243),[18,1,12],[0,0,0],3,2,wf4(:,2),wf9(:,1))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,2),G0H18(16),m3h4x18(:,93),heltab2x72(:,:,243))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(244),h0tab(:,244),[18,1,12],[nMZ,0,0],3,2,wf4(:,2),wf9(:,1))
  call Hloop_QA_Z(ntryL,G0H72(1),wf4(:,2),G0H18(17),ngZu,m3h4x18(:,94),heltab2x72(:,:,244))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(245),h0tab(:,245),[18,1,12],[nMW,0,0],3,2,wf4(:,2),wf9(:,1))
  call Hloop_QA_W(ntryL,G0H72(1),wf4(:,2),G0H18(18),m3h4x18(:,95),heltab2x72(:,:,245))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(246),h0tab(:,246),[18,1,12],[0,0,0],3,2,wf4(:,2),wf9(:,1))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,2),G0H18(19),m3h4x18(:,96),heltab2x72(:,:,246))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(247),h0tab(:,247),[18,1,12],[0,0,0],3,2,wf4(:,2),wf9(:,1))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,2),G0H18(20),m3h4x18(:,97),heltab2x72(:,:,247))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(248),h0tab(:,248),[18,1,12],[nMZ,0,0],3,2,wf4(:,2),wf9(:,1))
  call Hloop_QA_Z(ntryL,G0H72(1),wf4(:,2),G0H18(21),ngZu,m3h4x18(:,98),heltab2x72(:,:,248))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(249),h0tab(:,249),[18,1,12],[nMW,0,0],3,2,wf4(:,2),wf9(:,1))
  call Hloop_QA_W(ntryL,G0H72(1),wf4(:,2),G0H18(22),m3h4x18(:,99),heltab2x72(:,:,249))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(250),h0tab(:,250),[18,1,12],[0,0,0],3,2,wf4(:,2),wf9(:,1))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,2),G0H18(23),m3h4x18(:,100),heltab2x72(:,:,250))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(251),h0tab(:,251),[18,1,12],[0,nMW,nMW],3,2,wf4(:,2),wf9(:,1))
  call Hloop_WA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(24),m3h4x18(:,101),heltab2x72(:,:,251))
  call Hloop_A_Q(ntryL,G0H18(24),18,0,G1H18(3),n2h18(76))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(252),h0tab(:,252),[18,1,12],[0,nMW,nMW],3,2,wf4(:,2),wf9(:,1))
  call Hloop_WA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(24),m3h4x18(:,102),heltab2x72(:,:,252))
  call Hloop_A_Q(ntryL,G0H18(24),18,0,G1H18(44),n2h18(77))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(253),h0tab(:,253),[16,2,13],[0,0,0],3,1,wf18(:,13))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,137),heltab2x72(:,:,253))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(29),n2h36(129))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(254),h0tab(:,254),[16,2,13],[0,nMZ,0],3,1,wf18(:,13))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,138),heltab2x72(:,:,254))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(30),n2h36(130))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(255),h0tab(:,255),[16,2,13],[0,nMW,0],3,1,wf18(:,13))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,139),heltab2x72(:,:,255))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(31),n2h36(131))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(256),h0tab(:,256),[16,2,13],[0,0,0],3,1,wf18(:,13))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,140),heltab2x72(:,:,256))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(32),n2h36(132))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(257),h0tab(:,257),[16,2,13],[0,0,0],3,1,wf18(:,15))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,141),heltab2x72(:,:,257))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(33),n2h36(133))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(258),h0tab(:,258),[16,2,13],[0,nMZ,0],3,1,wf18(:,15))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,142),heltab2x72(:,:,258))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(36),n2h36(134))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(259),h0tab(:,259),[16,2,13],[0,nMW,0],3,1,wf18(:,15))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,143),heltab2x72(:,:,259))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(35),n2h36(135))
  Gcoeff(:)%j = (-(c(43)*M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(260),h0tab(:,260),[16,2,13],[0,0,0],3,1,wf18(:,15))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,144),heltab2x72(:,:,260))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(39),n2h36(136))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(261),h0tab(:,261),[16,2,13],[0,0,0],3,1,wf18(:,13))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(38),m3h2x36(:,145),heltab2x72(:,:,261))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(262),h0tab(:,262),[16,2,13],[0,0,0],3,1,wf18(:,15))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(43),m3h2x36(:,146),heltab2x72(:,:,262))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(263),h0tab(:,263),[16,1,14],[0,0,0],3,1,wf18(:,9))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,147),heltab2x72(:,:,263))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(41),n2h36(137))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(264),h0tab(:,264),[16,1,14],[0,nMZ,0],3,1,wf18(:,9))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,148),heltab2x72(:,:,264))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(42),n2h36(138))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(265),h0tab(:,265),[16,1,14],[0,nMW,0],3,1,wf18(:,9))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,149),heltab2x72(:,:,265))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(47),n2h36(139))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(266),h0tab(:,266),[16,1,14],[0,0,0],3,1,wf18(:,9))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,150),heltab2x72(:,:,266))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(45),n2h36(140))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(267),h0tab(:,267),[16,1,14],[0,0,0],3,1,wf18(:,11))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,151),heltab2x72(:,:,267))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(46),n2h36(141))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(268),h0tab(:,268),[16,1,14],[0,nMZ,0],3,1,wf18(:,11))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,152),heltab2x72(:,:,268))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(51),n2h36(142))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(269),h0tab(:,269),[16,1,14],[0,nMW,0],3,1,wf18(:,11))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,153),heltab2x72(:,:,269))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(49),n2h36(143))
  Gcoeff(:)%j = (-(c(43)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(270),h0tab(:,270),[16,1,14],[0,0,0],3,1,wf18(:,11))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,154),heltab2x72(:,:,270))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(50),n2h36(144))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(271),h0tab(:,271),[16,1,14],[0,0,0],3,1,wf18(:,9))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(55),m3h2x36(:,155),heltab2x72(:,:,271))
  Gcoeff(:)%j = (-(c(42)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(272),h0tab(:,272),[16,1,14],[0,0,0],3,1,wf18(:,11))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(53),m3h2x36(:,156),heltab2x72(:,:,272))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(273),h0tab(:,273),[19,4,8],[nME,0,nME],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),wf8(:,1),G0H9(1),m3h8x9(:,1),heltab2x72(:,:,273))
  call Hloop_A_Q(ntryL,G0H9(1),19,nME,G1H9(68),n2h9(47))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(274),h0tab(:,274),[19,4,8],[nMM,0,nMM],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),wf8(:,1),G0H9(2),m3h8x9(:,2),heltab2x72(:,:,274))
  call Hloop_A_Q(ntryL,G0H9(2),19,nMM,G1H9(69),n2h9(48))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(275),h0tab(:,275),[19,4,8],[nML,0,nML],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),wf8(:,1),G0H9(3),m3h8x9(:,3),heltab2x72(:,:,275))
  call Hloop_A_Q(ntryL,G0H9(3),19,nML,G1H9(70),n2h9(49))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(276),h0tab(:,276),[19,4,8],[0,0,0],3,1,wf8(:,1))
  call Hloop_QV_A(ntryL,G0H72(1),wf8(:,1),G0H9(4),m3h8x9(:,4),heltab2x72(:,:,276))
  call Hloop_Q_A(ntryL,G0H9(4),19,0,G1H9(72),n2h9(50))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(277),h0tab(:,277),[19,4,8],[nMT,nMB,nMT],3,1,wf8(:,1))
  call Hloop_QV_A(ntryL,G0H72(1),wf8(:,1),G0H9(5),m3h8x9(:,5),heltab2x72(:,:,277))
  call Hloop_Q_A(ntryL,G0H9(5),19,nMT,G1H9(73),n2h9(51))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(278),h0tab(:,278),[19,4,8],[0,0,0],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),wf8(:,1),G0H9(6),m3h8x9(:,6),heltab2x72(:,:,278))
  call Hloop_A_Q(ntryL,G0H9(6),19,0,G1H9(74),n2h9(52))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(279),h0tab(:,279),[19,4,8],[nMB,nMT,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),wf8(:,1),G0H9(7),m3h8x9(:,7),heltab2x72(:,:,279))
  call Hloop_A_Q(ntryL,G0H9(7),19,nMB,G1H9(75),n2h9(53))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(280),h0tab(:,280),[19,4,8],[0,nME,0],3,1,wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H72(1),wf8(:,2),G0H9(8),ngZn,m3h8x9(:,8),heltab2x72(:,:,280))
  call Hloop_Q_A(ntryL,G0H9(8),19,0,G1H9(77),n2h9(54))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(281),h0tab(:,281),[19,4,8],[0,nMM,0],3,1,wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H72(1),wf8(:,2),G0H9(1),ngZn,m3h8x9(:,9),heltab2x72(:,:,281))
  call Hloop_Q_A(ntryL,G0H9(1),19,0,G1H9(78),n2h9(55))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(282),h0tab(:,282),[19,4,8],[0,nML,0],3,1,wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H72(1),wf8(:,2),G0H9(2),ngZn,m3h8x9(:,10),heltab2x72(:,:,282))
  call Hloop_Q_A(ntryL,G0H9(2),19,0,G1H9(18),n2h9(56))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(283),h0tab(:,283),[19,4,8],[nME,0,nME],3,1,wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H72(1),wf8(:,2),G0H9(3),ngZl,m3h8x9(:,11),heltab2x72(:,:,283))
  call Hloop_A_Q(ntryL,G0H9(3),19,nME,G1H9(19),n2h9(57))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(284),h0tab(:,284),[19,4,8],[nMM,0,nMM],3,1,wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H72(1),wf8(:,2),G0H9(4),ngZl,m3h8x9(:,12),heltab2x72(:,:,284))
  call Hloop_A_Q(ntryL,G0H9(4),19,nMM,G1H9(24),n2h9(58))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(285),h0tab(:,285),[19,4,8],[nML,0,nML],3,1,wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H72(1),wf8(:,2),G0H9(5),ngZl,m3h8x9(:,13),heltab2x72(:,:,285))
  call Hloop_A_Q(ntryL,G0H9(5),19,nML,G1H9(25),n2h9(59))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(286),h0tab(:,286),[19,4,8],[0,0,0],3,1,wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H72(1),wf8(:,2),G0H9(6),ngZu,m3h8x9(:,14),heltab2x72(:,:,286))
  call Hloop_Q_A(ntryL,G0H9(6),19,0,G1H9(26),n2h9(60))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(287),h0tab(:,287),[19,4,8],[nMT,nMB,nMT],3,1,wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H72(1),wf8(:,2),G0H9(7),ngZu,m3h8x9(:,15),heltab2x72(:,:,287))
  call Hloop_Q_A(ntryL,G0H9(7),19,nMT,G1H9(33),n2h9(61))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(288),h0tab(:,288),[19,4,8],[0,0,0],3,1,wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H72(1),wf8(:,2),G0H9(8),ngZd,m3h8x9(:,16),heltab2x72(:,:,288))
  call Hloop_A_Q(ntryL,G0H9(8),19,0,G1H9(36),n2h9(62))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(289),h0tab(:,289),[19,4,8],[nMB,nMT,nMB],3,1,wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H72(1),wf8(:,2),G0H9(1),ngZd,m3h8x9(:,17),heltab2x72(:,:,289))
  call Hloop_A_Q(ntryL,G0H9(1),19,nMB,G1H9(37),n2h9(63))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(290),h0tab(:,290),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,1))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(6),m3h8x9(:,18),heltab2x72(:,:,290))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(291),h0tab(:,291),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,1))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(7),m3h8x9(:,19),heltab2x72(:,:,291))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(292),h0tab(:,292),[19,4,8],[nMH,nMW,nMZ],3,1,wf8(:,2))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(8),m3h8x9(:,20),heltab2x72(:,:,292))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(293),h0tab(:,293),[19,4,8],[nMZ,nMW,nMH],3,1,wf8(:,2))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(39),m3h8x9(:,21),heltab2x72(:,:,293))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(294),h0tab(:,294),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,2))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(40),m3h8x9(:,22),heltab2x72(:,:,294))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(295),h0tab(:,295),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,2))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(41),m3h8x9(:,23),heltab2x72(:,:,295))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(296),h0tab(:,296),[19,4,8],[nMW,0,nMW],3,1,wf8(:,1))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,1),G1H9(44),m3h8x9(:,24),heltab2x72(:,:,296))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(297),h0tab(:,297),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,1))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,1),G1H9(45),m3h8x9(:,25),heltab2x72(:,:,297))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(298),h0tab(:,298),[19,4,8],[nMW,0,nMW],3,1,wf8(:,1))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(46),m3h8x9(:,26),heltab2x72(:,:,298))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(299),h0tab(:,299),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,1))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(50),m3h8x9(:,27),heltab2x72(:,:,299))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(300),h0tab(:,300),[19,4,8],[nMW,0,nMW],3,1,wf8(:,2))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,2),G1H9(51),m3h8x9(:,28),heltab2x72(:,:,300))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(301),h0tab(:,301),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,2))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,2),G1H9(52),m3h8x9(:,29),heltab2x72(:,:,301))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(302),h0tab(:,302),[19,4,8],[nMW,0,nMW],3,1,wf8(:,2))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(55),m3h8x9(:,30),heltab2x72(:,:,302))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(303),h0tab(:,303),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,2))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(56),m3h8x9(:,31),heltab2x72(:,:,303))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(304),h0tab(:,304),[19,4,8],[nMW,0,nMW],3,1,wf8(:,1))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(57),m3h8x9(:,32),heltab2x72(:,:,304))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(305),h0tab(:,305),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,1))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(5),m3h8x9(:,33),heltab2x72(:,:,305))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(306),h0tab(:,306),[19,4,8],[nMW,0,nMW],3,1,wf8(:,2))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(10),m3h8x9(:,34),heltab2x72(:,:,306))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(307),h0tab(:,307),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,2))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(16),m3h8x9(:,35),heltab2x72(:,:,307))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(308),h0tab(:,308),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,1))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,1),G0H9(2),m3h8x9(:,36),heltab2x72(:,:,308))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(309),h0tab(:,309),[19,4,8],[nMH,nMW,nMZ],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,2),G0H9(3),m3h8x9(:,37),heltab2x72(:,:,309))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(310),h0tab(:,310),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,2),G0H9(4),m3h8x9(:,38),heltab2x72(:,:,310))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(311),h0tab(:,311),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,1),G0H9(5),m3h8x9(:,39),heltab2x72(:,:,311))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(312),h0tab(:,312),[19,4,8],[nMZ,nMW,nMH],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(6),m3h8x9(:,40),heltab2x72(:,:,312))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(313),h0tab(:,313),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(7),m3h8x9(:,41),heltab2x72(:,:,313))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(314),h0tab(:,314),[19,4,8],[nMW,0,nMW],3,1,wf8(:,1))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(28),m3h8x9(:,42),heltab2x72(:,:,314))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(315),h0tab(:,315),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,1))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(35),m3h8x9(:,43),heltab2x72(:,:,315))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(316),h0tab(:,316),[19,4,8],[nMW,0,nMW],3,1,wf8(:,2))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(29),m3h8x9(:,44),heltab2x72(:,:,316))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(317),h0tab(:,317),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,2))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(49),m3h8x9(:,45),heltab2x72(:,:,317))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(318),h0tab(:,318),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,1))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,1),19,G1H9(14),m3h8x9(:,46),heltab2x72(:,:,318))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(319),h0tab(:,319),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,2))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,2),19,G1H9(58),m3h8x9(:,47),heltab2x72(:,:,319))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(320),h0tab(:,320),[19,4,8],[nMW,0,nMW],3,1,wf8(:,1))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,1),G0H9(8),m3h8x9(:,48),heltab2x72(:,:,320))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(321),h0tab(:,321),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,1))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,1),G0H9(1),m3h8x9(:,49),heltab2x72(:,:,321))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(322),h0tab(:,322),[19,4,8],[nMW,0,nMW],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,2),G0H9(9),m3h8x9(:,50),heltab2x72(:,:,322))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(323),h0tab(:,323),[19,4,8],[nMH,nMW,nMZ],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,2),G0H9(10),m3h8x9(:,51),heltab2x72(:,:,323))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(324),h0tab(:,324),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,2),G0H9(11),m3h8x9(:,52),heltab2x72(:,:,324))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(325),h0tab(:,325),[19,4,8],[nMW,0,nMW],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,1),G0H9(12),m3h8x9(:,53),heltab2x72(:,:,325))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(326),h0tab(:,326),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,1),G0H9(13),m3h8x9(:,54),heltab2x72(:,:,326))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(327),h0tab(:,327),[19,4,8],[nMW,0,nMW],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(14),m3h8x9(:,55),heltab2x72(:,:,327))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(328),h0tab(:,328),[19,4,8],[nMZ,nMW,nMH],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(15),m3h8x9(:,56),heltab2x72(:,:,328))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(329),h0tab(:,329),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,2),G0H9(16),m3h8x9(:,57),heltab2x72(:,:,329))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(330),h0tab(:,330),[21,2,8],[0,0,0],3,1,wf12(:,14))
  call Hloop_AQ_V(ntryL,G0H72(1),wf12(:,14),G0H6(7),m3h12x6(:,15),heltab2x72(:,:,330))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(331),h0tab(:,331),[21,2,8],[nMZ,0,0],3,1,wf12(:,14))
  call Hloop_AQ_Z(ntryL,G0H72(1),wf12(:,14),G0H6(8),ngZd,m3h12x6(:,16),heltab2x72(:,:,331))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(332),h0tab(:,332),[21,2,8],[0,0,0],3,1,wf12(:,14))
  call Hloop_AQ_V(ntryL,G0H72(1),wf12(:,14),G0H6(9),m3h12x6(:,17),heltab2x72(:,:,332))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(333),h0tab(:,333),[21,2,8],[0,0,nMW],3,1,wf12(:,14))
  call Hloop_WQ_A(ntryL,G0H72(1),wf12(:,14),G0H6(10),m3h12x6(:,18),heltab2x72(:,:,333))
  call Hloop_Q_A(ntryL,G0H6(10),21,0,G1H6(126),n2h6(50))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(334),h0tab(:,334),[21,2,8],[0,nMW,0],3,1,wf12(:,14))
  call Hloop_VQ_A(ntryL,G0H72(1),wf12(:,14),G0H6(10),m3h12x6(:,19),heltab2x72(:,:,334))
  call Hloop_Q_A(ntryL,G0H6(10),21,0,G1H6(127),n2h6(51))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(335),h0tab(:,335),[21,2,8],[0,nMZ,nMW],3,1,wf12(:,14))
  call Hloop_WQ_A(ntryL,G0H72(1),wf12(:,14),G0H6(10),m3h12x6(:,20),heltab2x72(:,:,335))
  call Hloop_Q_A(ntryL,G0H6(10),21,0,G1H6(128),n2h6(52))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(336),h0tab(:,336),[21,2,8],[0,nMW,nMZ],3,1,wf12(:,14))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf12(:,14),G0H6(10),ngZd,m3h12x6(:,21),heltab2x72(:,:,336))
  call Hloop_Q_A(ntryL,G0H6(10),21,0,G1H6(133),n2h6(53))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(337),h0tab(:,337),[19,4,8],[nME,0,nME],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),wf8(:,3),G0H9(17),m3h8x9(:,58),heltab2x72(:,:,337))
  call Hloop_A_Q(ntryL,G0H9(17),19,nME,G1H9(60),n2h9(64))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(338),h0tab(:,338),[19,4,8],[nMM,0,nMM],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),wf8(:,3),G0H9(17),m3h8x9(:,59),heltab2x72(:,:,338))
  call Hloop_A_Q(ntryL,G0H9(17),19,nMM,G1H9(62),n2h9(65))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(339),h0tab(:,339),[19,4,8],[nML,0,nML],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),wf8(:,3),G0H9(17),m3h8x9(:,60),heltab2x72(:,:,339))
  call Hloop_A_Q(ntryL,G0H9(17),19,nML,G1H9(63),n2h9(66))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(340),h0tab(:,340),[19,4,8],[0,0,0],3,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H72(1),wf8(:,3),G0H9(17),m3h8x9(:,61),heltab2x72(:,:,340))
  call Hloop_Q_A(ntryL,G0H9(17),19,0,G1H9(67),n2h9(67))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(341),h0tab(:,341),[19,4,8],[nMT,nMB,nMT],3,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H72(1),wf8(:,3),G0H9(17),m3h8x9(:,62),heltab2x72(:,:,341))
  call Hloop_Q_A(ntryL,G0H9(17),19,nMT,G1H9(80),n2h9(68))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(342),h0tab(:,342),[19,4,8],[0,0,0],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),wf8(:,3),G0H9(17),m3h8x9(:,63),heltab2x72(:,:,342))
  call Hloop_A_Q(ntryL,G0H9(17),19,0,G1H9(81),n2h9(69))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(343),h0tab(:,343),[19,4,8],[nMB,nMT,nMB],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),wf8(:,3),G0H9(17),m3h8x9(:,64),heltab2x72(:,:,343))
  call Hloop_A_Q(ntryL,G0H9(17),19,nMB,G1H9(82),n2h9(70))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(344),h0tab(:,344),[19,4,8],[0,nME,0],3,1,wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H72(1),wf8(:,4),G0H9(17),ngZn,m3h8x9(:,65),heltab2x72(:,:,344))
  call Hloop_Q_A(ntryL,G0H9(17),19,0,G1H9(83),n2h9(71))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(345),h0tab(:,345),[19,4,8],[0,nMM,0],3,1,wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H72(1),wf8(:,4),G0H9(17),ngZn,m3h8x9(:,66),heltab2x72(:,:,345))
  call Hloop_Q_A(ntryL,G0H9(17),19,0,G1H9(84),n2h9(72))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(346),h0tab(:,346),[19,4,8],[0,nML,0],3,1,wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H72(1),wf8(:,4),G0H9(17),ngZn,m3h8x9(:,67),heltab2x72(:,:,346))
  call Hloop_Q_A(ntryL,G0H9(17),19,0,G1H9(85),n2h9(73))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(347),h0tab(:,347),[19,4,8],[nME,0,nME],3,1,wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H72(1),wf8(:,4),G0H9(17),ngZl,m3h8x9(:,68),heltab2x72(:,:,347))
  call Hloop_A_Q(ntryL,G0H9(17),19,nME,G1H9(86),n2h9(74))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(348),h0tab(:,348),[19,4,8],[nMM,0,nMM],3,1,wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H72(1),wf8(:,4),G0H9(17),ngZl,m3h8x9(:,69),heltab2x72(:,:,348))
  call Hloop_A_Q(ntryL,G0H9(17),19,nMM,G1H9(87),n2h9(75))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(349),h0tab(:,349),[19,4,8],[nML,0,nML],3,1,wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H72(1),wf8(:,4),G0H9(17),ngZl,m3h8x9(:,70),heltab2x72(:,:,349))
  call Hloop_A_Q(ntryL,G0H9(17),19,nML,G1H9(88),n2h9(76))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(350),h0tab(:,350),[19,4,8],[0,0,0],3,1,wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H72(1),wf8(:,4),G0H9(17),ngZu,m3h8x9(:,71),heltab2x72(:,:,350))
  call Hloop_Q_A(ntryL,G0H9(17),19,0,G1H9(89),n2h9(77))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(351),h0tab(:,351),[19,4,8],[nMT,nMB,nMT],3,1,wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H72(1),wf8(:,4),G0H9(17),ngZu,m3h8x9(:,72),heltab2x72(:,:,351))
  call Hloop_Q_A(ntryL,G0H9(17),19,nMT,G1H9(90),n2h9(78))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(352),h0tab(:,352),[19,4,8],[0,0,0],3,1,wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H72(1),wf8(:,4),G0H9(17),ngZd,m3h8x9(:,73),heltab2x72(:,:,352))
  call Hloop_A_Q(ntryL,G0H9(17),19,0,G1H9(91),n2h9(79))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(353),h0tab(:,353),[19,4,8],[nMB,nMT,nMB],3,1,wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H72(1),wf8(:,4),G0H9(17),ngZd,m3h8x9(:,74),heltab2x72(:,:,353))
  call Hloop_A_Q(ntryL,G0H9(17),19,nMB,G1H9(92),n2h9(80))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(354),h0tab(:,354),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,3))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,3),19,G1H9(93),m3h8x9(:,75),heltab2x72(:,:,354))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(355),h0tab(:,355),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,3))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,3),19,G1H9(94),m3h8x9(:,76),heltab2x72(:,:,355))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(356),h0tab(:,356),[19,4,8],[nMH,nMW,nMZ],3,1,wf8(:,4))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,4),19,G1H9(95),m3h8x9(:,77),heltab2x72(:,:,356))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(357),h0tab(:,357),[19,4,8],[nMZ,nMW,nMH],3,1,wf8(:,4))
  call Hloop_TV_S(ntryL,G0H72(1),0,wf8(:,4),19,G1H9(96),m3h8x9(:,78),heltab2x72(:,:,357))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(358),h0tab(:,358),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,4))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,4),19,G1H9(97),m3h8x9(:,79),heltab2x72(:,:,358))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(359),h0tab(:,359),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,4))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,4),19,G1H9(98),m3h8x9(:,80),heltab2x72(:,:,359))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(360),h0tab(:,360),[19,4,8],[nMW,0,nMW],3,1,wf8(:,3))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,3),G1H9(99),m3h8x9(:,81),heltab2x72(:,:,360))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(361),h0tab(:,361),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,3))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,3),G1H9(100),m3h8x9(:,82),heltab2x72(:,:,361))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(362),h0tab(:,362),[19,4,8],[nMW,0,nMW],3,1,wf8(:,3))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,3),19,G1H9(101),m3h8x9(:,83),heltab2x72(:,:,362))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(363),h0tab(:,363),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,3))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,3),19,G1H9(102),m3h8x9(:,84),heltab2x72(:,:,363))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(364),h0tab(:,364),[19,4,8],[nMW,0,nMW],3,1,wf8(:,4))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,4),G1H9(103),m3h8x9(:,85),heltab2x72(:,:,364))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(365),h0tab(:,365),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,4))
  call Hloop_DV_C(ntryL,G0H72(1),0,wf8(:,4),G1H9(104),m3h8x9(:,86),heltab2x72(:,:,365))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(366),h0tab(:,366),[19,4,8],[nMW,0,nMW],3,1,wf8(:,4))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,4),19,G1H9(105),m3h8x9(:,87),heltab2x72(:,:,366))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(367),h0tab(:,367),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,4))
  call Hloop_CV_D(ntryL,G0H72(1),0,wf8(:,4),19,G1H9(106),m3h8x9(:,88),heltab2x72(:,:,367))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(368),h0tab(:,368),[19,4,8],[nMW,0,nMW],3,1,wf8(:,3))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,3),19,G1H9(107),m3h8x9(:,89),heltab2x72(:,:,368))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(369),h0tab(:,369),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,3))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,3),19,G1H9(108),m3h8x9(:,90),heltab2x72(:,:,369))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(370),h0tab(:,370),[19,4,8],[nMW,0,nMW],3,1,wf8(:,4))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,4),19,G1H9(109),m3h8x9(:,91),heltab2x72(:,:,370))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(371),h0tab(:,371),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,4))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,4),19,G1H9(110),m3h8x9(:,92),heltab2x72(:,:,371))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(372),h0tab(:,372),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,3))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,3),G0H9(17),m3h8x9(:,93),heltab2x72(:,:,372))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(373),h0tab(:,373),[19,4,8],[nMH,nMW,nMZ],3,1,wf8(:,4))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,4),G0H9(18),m3h8x9(:,94),heltab2x72(:,:,373))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(374),h0tab(:,374),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,4))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,4),G0H9(19),m3h8x9(:,95),heltab2x72(:,:,374))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(375),h0tab(:,375),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,3))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,3),G0H9(20),m3h8x9(:,96),heltab2x72(:,:,375))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(376),h0tab(:,376),[19,4,8],[nMZ,nMW,nMH],3,1,wf8(:,4))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,4),G0H9(21),m3h8x9(:,97),heltab2x72(:,:,376))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(377),h0tab(:,377),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,4))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,4),G0H9(22),m3h8x9(:,98),heltab2x72(:,:,377))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(378),h0tab(:,378),[19,4,8],[nMW,0,nMW],3,1,wf8(:,3))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,3),19,G1H9(111),m3h8x9(:,99),heltab2x72(:,:,378))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(379),h0tab(:,379),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,3))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,3),19,G1H9(112),m3h8x9(:,100),heltab2x72(:,:,379))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(380),h0tab(:,380),[19,4,8],[nMW,0,nMW],3,1,wf8(:,4))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,4),19,G1H9(113),m3h8x9(:,101),heltab2x72(:,:,380))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(381),h0tab(:,381),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,4))
  call Hloop_SV_T(ntryL,G0H72(1),0,wf8(:,4),19,G1H9(114),m3h8x9(:,102),heltab2x72(:,:,381))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(382),h0tab(:,382),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,3))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,3),19,G1H9(115),m3h8x9(:,103),heltab2x72(:,:,382))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(383),h0tab(:,383),[19,4,8],[nMW,nMH,nMW],3,1,wf8(:,4))
  call Hloop_UW_V(ntryL,G0H72(1),0,wf8(:,4),19,G1H9(116),m3h8x9(:,104),heltab2x72(:,:,383))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(384),h0tab(:,384),[19,4,8],[nMW,0,nMW],3,1,wf8(:,3))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,3),G0H9(23),m3h8x9(:,105),heltab2x72(:,:,384))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(385),h0tab(:,385),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,3))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,3),G0H9(24),m3h8x9(:,106),heltab2x72(:,:,385))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(386),h0tab(:,386),[19,4,8],[nMW,0,nMW],3,1,wf8(:,4))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,4),G0H9(25),m3h8x9(:,107),heltab2x72(:,:,386))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(387),h0tab(:,387),[19,4,8],[nMH,nMW,nMZ],3,1,wf8(:,4))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,4),G0H9(26),m3h8x9(:,108),heltab2x72(:,:,387))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(388),h0tab(:,388),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,4))
  call Hloop_VV_S(ntryL,G0H72(1),wf8(:,4),G0H9(27),m3h8x9(:,109),heltab2x72(:,:,388))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(389),h0tab(:,389),[19,4,8],[nMW,0,nMW],3,1,wf8(:,3))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,3),G0H9(28),m3h8x9(:,110),heltab2x72(:,:,389))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(390),h0tab(:,390),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,3))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,3),G0H9(29),m3h8x9(:,111),heltab2x72(:,:,390))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(391),h0tab(:,391),[19,4,8],[nMW,0,nMW],3,1,wf8(:,4))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,4),G0H9(30),m3h8x9(:,112),heltab2x72(:,:,391))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(392),h0tab(:,392),[19,4,8],[nMZ,nMW,nMH],3,1,wf8(:,4))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,4),G0H9(31),m3h8x9(:,113),heltab2x72(:,:,392))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(393),h0tab(:,393),[19,4,8],[nMW,nMZ,nMW],3,1,wf8(:,4))
  call Hloop_SV_V(ntryL,G0H72(1),wf8(:,4),G0H9(32),m3h8x9(:,114),heltab2x72(:,:,393))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(394),h0tab(:,394),[26,1,4],[0,0,0],3,1,wf12(:,13))
  call Hloop_QA_V(ntryL,G0H72(1),wf12(:,13),G0H6(10),m3h12x6(:,22),heltab2x72(:,:,394))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(395),h0tab(:,395),[26,1,4],[nMZ,0,0],3,1,wf12(:,13))
  call Hloop_QA_Z(ntryL,G0H72(1),wf12(:,13),G0H6(11),ngZd,m3h12x6(:,23),heltab2x72(:,:,395))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(396),h0tab(:,396),[26,1,4],[0,0,0],3,1,wf12(:,13))
  call Hloop_QA_V(ntryL,G0H72(1),wf12(:,13),G0H6(12),m3h12x6(:,24),heltab2x72(:,:,396))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(397),h0tab(:,397),[26,1,4],[0,0,nMW],3,1,wf12(:,13))
  call Hloop_WA_Q(ntryL,G0H72(1),wf12(:,13),G0H6(13),m3h12x6(:,25),heltab2x72(:,:,397))
  call Hloop_A_Q(ntryL,G0H6(13),26,0,G1H6(138),n2h6(54))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(398),h0tab(:,398),[26,1,4],[0,nMW,0],3,1,wf12(:,13))
  call Hloop_VA_Q(ntryL,G0H72(1),wf12(:,13),G0H6(13),m3h12x6(:,26),heltab2x72(:,:,398))
  call Hloop_A_Q(ntryL,G0H6(13),26,0,G1H6(134),n2h6(55))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(399),h0tab(:,399),[26,1,4],[0,nMZ,nMW],3,1,wf12(:,13))
  call Hloop_WA_Q(ntryL,G0H72(1),wf12(:,13),G0H6(13),m3h12x6(:,27),heltab2x72(:,:,399))
  call Hloop_A_Q(ntryL,G0H6(13),26,0,G1H6(137),n2h6(56))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(400),h0tab(:,400),[26,1,4],[0,nMW,nMZ],3,1,wf12(:,13))
  call Hloop_ZA_Q(ntryL,G0H72(1),wf12(:,13),G0H6(13),ngZd,m3h12x6(:,28),heltab2x72(:,:,400))
  call Hloop_A_Q(ntryL,G0H6(13),26,0,G1H6(139),n2h6(57))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(34),[G1H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(89),[G1H9(67),G1H9(26),G1H9(72),G1H9(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(91),[G1H9(81),G1H9(36),G1H9(74),G1H9(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(90),[G1H9(80),G1H9(33),G1H9(73),G1H9(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(92),[G1H9(82),G1H9(37),G1H9(75),G1H9(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(37),[G1H18(35),G1H18(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(58),[G1H36(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(4),[G1H36(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(15),[G1H36(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(12),[G0H18(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(20),[G1H36(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(9),[G0H6(7),G0H6(3),G0H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(8),[G0H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(126),[G1H6(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(127),[G1H6(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(128),[G1H6(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(133),[G1H6(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(28),[G1H36(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(12),[G0H6(10),G0H6(6),G0H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(11),[G0H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(138),[G1H6(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(134),[G1H6(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(137),[G1H6(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(139),[G1H6(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(6),[G0H18(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(15),[G0H18(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(41),[G1H18(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(19),[G0H18(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(23),[G0H18(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(44),[G1H18(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(32),[G1H36(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(39),[G1H36(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(45),[G1H36(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(50),[G1H36(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(86),[G1H9(60),G1H9(19),G1H9(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(87),[G1H9(62),G1H9(24),G1H9(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(88),[G1H9(63),G1H9(25),G1H9(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(83),[G1H9(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(84),[G1H9(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(85),[G1H9(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(97),[G1H9(93),G1H9(40),G1H9(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(98),[G1H9(94),G1H9(41),G1H9(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(95),[G1H9(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(96),[G1H9(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(103),[G1H9(99),G1H9(51),G1H9(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(104),[G1H9(100),G1H9(52),G1H9(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(105),[G1H9(101),G1H9(55),G1H9(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(106),[G1H9(102),G1H9(56),G1H9(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(109),[G1H9(107),G1H9(10),G1H9(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(110),[G1H9(108),G1H9(16),G1H9(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(19),[G0H9(17),G0H9(4),G0H9(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(18),[G0H9(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(22),[G0H9(20),G0H9(7),G0H9(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(21),[G0H9(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(113),[G1H9(111),G1H9(29),G1H9(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(114),[G1H9(112),G1H9(49),G1H9(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(116),[G1H9(115),G1H9(58),G1H9(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(25),[G0H9(23),G0H9(9),G0H9(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(27),[G0H9(24),G0H9(11),G0H9(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(26),[G0H9(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(30),[G0H9(28),G0H9(14),G0H9(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(32),[G0H9(29),G0H9(16),G0H9(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H9(31),[G0H9(15)])
  call Hloop_QW_A(ntryL,G1H6(34),ex4(:),G1H2(88),m3h3x2(:,82),heltab2x6(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(88),29,0,G2H2(11),n2h2(22))
  call Hloop_QW_A(ntryL,G1H9(89),ex3(:),G1H3(108),m3h3x3(:,109),heltab2x9(:,:,145))
  call Hloop_Q_A(ntryL,G1H3(108),23,0,G2H3(5),n2h3(127))
  call Hloop_QW_A(ntryL,G1H9(22),ex4(:),G1H3(141),m3h3x3(:,110),heltab2x9(:,:,146))
  call Hloop_Q_A(ntryL,G1H3(141),27,0,G2H3(2),n2h3(128))
  call Hloop_AW_Q(ntryL,G1H9(91),ex3(:),G1H3(152),m3h3x3(:,111),heltab2x9(:,:,147))
  call Hloop_A_Q(ntryL,G1H3(152),23,0,G2H3(35),n2h3(129))
  call Hloop_AW_Q(ntryL,G1H9(27),ex4(:),G1H3(185),m3h3x3(:,112),heltab2x9(:,:,148))
  call Hloop_A_Q(ntryL,G1H3(185),27,0,G2H3(9),n2h3(130))
  call Hloop_AW_Q(ntryL,G1H9(61),ex4(:),G1H3(4),m3h3x3(:,113),heltab2x9(:,:,149))
  call Hloop_A_Q(ntryL,G1H3(4),27,nMB,G2H3(38),n2h3(131))
  call Hloop_QW_A(ntryL,G1H9(66),ex4(:),G1H3(5),m3h3x3(:,114),heltab2x9(:,:,150))
  call Hloop_Q_A(ntryL,G1H3(5),27,nMT,G2H3(13),n2h3(132))
  call Hloop_QW_A(ntryL,G1H9(90),ex3(:),G1H3(15),m3h3x3(:,115),heltab2x9(:,:,151))
  call Hloop_Q_A(ntryL,G1H3(15),23,nMB,G2H3(16),n2h3(133))
  call Hloop_AW_Q(ntryL,G1H9(92),ex3(:),G1H3(16),m3h3x3(:,116),heltab2x9(:,:,152))
  call Hloop_A_Q(ntryL,G1H3(16),23,nMT,G2H3(11),n2h3(134))
  call Hloop_QV_A(ntryL,G1H12(3),wf4(:,5),G1H3(21),m3h4x3(:,17),heltab2x12(:,:,26))
  call Hloop_Q_A(ntryL,G1H3(21),23,0,G2H3(41),n2h3(135))
  call Hloop_QV_A(ntryL,G1H12(8),wf4(:,5),G1H3(27),m3h4x3(:,18),heltab2x12(:,:,27))
  call Hloop_Q_A(ntryL,G1H3(27),23,nMB,G2H3(20),n2h3(136))
  call Hloop_AV_Q(ntryL,G1H12(13),wf4(:,5),G1H3(82),m3h4x3(:,19),heltab2x12(:,:,28))
  call Hloop_A_Q(ntryL,G1H3(82),23,0,G2H3(47),n2h3(137))
  call Hloop_AV_Q(ntryL,G1H12(18),wf4(:,5),G1H3(87),m3h4x3(:,20),heltab2x12(:,:,29))
  call Hloop_A_Q(ntryL,G1H3(87),23,nMT,G2H3(24),n2h3(138))
  call Hloop_AW_Q(ntryL,G1H18(8),ex4(:),G1H6(142),m3h3x6(:,55),heltab2x18(:,:,135))
  call Hloop_A_Q(ntryL,G1H6(142),26,0,G2H6(19),n2h6(58))
  call Hloop_QW_A(ntryL,G1H18(37),ex3(:),G1H6(131),m3h3x6(:,56),heltab2x18(:,:,136))
  call Hloop_Q_A(ntryL,G1H6(131),21,0,G2H6(20),n2h6(59))
  call Hloop_QV_A(ntryL,G1H18(18),wf9(:,1),G1H2(89),m3h9x2(:,10),heltab2x18(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(89),29,0,G2H2(14),n2h2(23))
  call Hloop_QZ_A(ntryL,G1H18(23),wf9(:,1),G1H2(93),ngZu,m3h9x2(:,11),heltab2x18(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(93),29,0,G2H2(17),n2h2(24))
  call Hloop_QA_V(ntryL,G1H18(26),ex2(:),G1H9(67),m3h2x9(:,66),heltab2x18(:,:,139))
  call Hloop_QA_V(ntryL,G1H18(27),ex2(:),G1H9(26),m3h2x9(:,67),heltab2x18(:,:,140))
  call Hloop_QA_Z(ntryL,G1H18(28),ex2(:),G1H9(72),ngZu,m3h2x9(:,68),heltab2x18(:,:,141))
  call Hloop_QA_Z(ntryL,G1H18(29),ex2(:),G1H9(11),ngZu,m3h2x9(:,69),heltab2x18(:,:,142))
  call Hloop_QA_W(ntryL,G1H18(30),ex2(:),G1H9(81),m3h2x9(:,70),heltab2x18(:,:,143))
  call Hloop_AQ_V(ntryL,G1H18(31),ex1(:),G1H9(36),m3h2x9(:,71),heltab2x18(:,:,144))
  call Hloop_AQ_V(ntryL,G1H18(32),ex1(:),G1H9(74),m3h2x9(:,72),heltab2x18(:,:,145))
  call Hloop_AQ_Z(ntryL,G1H18(33),ex1(:),G1H9(34),ngZu,m3h2x9(:,73),heltab2x18(:,:,146))
  call Hloop_AQ_Z(ntryL,G1H18(1),ex1(:),G1H9(80),ngZu,m3h2x9(:,74),heltab2x18(:,:,147))
  call Hloop_AQ_W(ntryL,G1H18(2),ex1(:),G1H9(33),m3h2x9(:,75),heltab2x18(:,:,148))
  call Hloop_AV_Q(ntryL,G1H36(23),wf4(:,5),G1H9(73),m3h4x9(:,9),heltab2x36(:,:,90))
  call Hloop_A_Q(ntryL,G1H9(73),19,nMT,G2H9(13),n2h9(81))
  call Hloop_QV_A(ntryL,G1H36(26),wf4(:,5),G1H9(71),m3h4x9(:,10),heltab2x36(:,:,91))
  call Hloop_Q_A(ntryL,G1H9(71),19,nMT,G2H9(5),n2h9(82))
  call Hloop_AV_Q(ntryL,G1H36(34),wf4(:,5),G1H9(82),m3h4x9(:,11),heltab2x36(:,:,92))
  call Hloop_A_Q(ntryL,G1H9(82),19,nMB,G2H9(3),n2h9(83))
  call Hloop_QV_A(ntryL,G1H36(37),wf4(:,5),G1H9(37),m3h4x9(:,12),heltab2x36(:,:,93))
  call Hloop_Q_A(ntryL,G1H9(37),19,nMB,G2H9(7),n2h9(84))
  call Hloop_AV_Q(ntryL,G1H36(58),wf4(:,5),G1H9(75),m3h4x9(:,13),heltab2x36(:,:,94))
  call Hloop_A_Q(ntryL,G1H9(75),19,0,G2H9(1),n2h9(85))
  call Hloop_AV_Q(ntryL,G1H36(44),wf4(:,5),G1H9(76),m3h4x9(:,14),heltab2x36(:,:,95))
  call Hloop_A_Q(ntryL,G1H9(76),19,nMT,G2H9(2),n2h9(86))
  call Hloop_QV_A(ntryL,G1H36(4),wf4(:,5),G1H9(60),m3h4x9(:,15),heltab2x36(:,:,96))
  call Hloop_Q_A(ntryL,G1H9(60),19,0,G2H9(4),n2h9(87))
  call Hloop_QV_A(ntryL,G1H36(52),wf4(:,5),G1H9(19),m3h4x9(:,16),heltab2x36(:,:,97))
  call Hloop_Q_A(ntryL,G1H9(19),19,nMT,G2H9(6),n2h9(88))
  call Hloop_AV_Q(ntryL,G1H36(1),wf4(:,5),G1H9(68),m3h4x9(:,17),heltab2x36(:,:,98))
  call Hloop_A_Q(ntryL,G1H9(68),19,nMB,G2H9(8),n2h9(89))
  call Hloop_QV_A(ntryL,G1H36(10),wf4(:,5),G1H9(62),m3h4x9(:,18),heltab2x36(:,:,99))
  call Hloop_Q_A(ntryL,G1H9(62),19,nMB,G2H9(9),n2h9(90))
  call Hloop_AV_Q(ntryL,G1H36(3),wf4(:,5),G1H9(24),m3h4x9(:,19),heltab2x36(:,:,100))
  call Hloop_A_Q(ntryL,G1H9(24),19,0,G2H9(10),n2h9(91))
  call Hloop_AV_Q(ntryL,G1H36(2),wf4(:,5),G1H9(69),m3h4x9(:,20),heltab2x36(:,:,101))
  call Hloop_A_Q(ntryL,G1H9(69),19,nMT,G2H9(11),n2h9(92))
  call Hloop_QV_A(ntryL,G1H36(6),wf4(:,5),G1H9(63),m3h4x9(:,21),heltab2x36(:,:,102))
  call Hloop_Q_A(ntryL,G1H9(63),19,0,G2H9(12),n2h9(93))
  call Hloop_QV_A(ntryL,G1H36(5),wf4(:,5),G1H9(25),m3h4x9(:,22),heltab2x36(:,:,103))
  call Hloop_Q_A(ntryL,G1H9(25),19,nMT,G2H9(14),n2h9(94))
  call Hloop_AV_Q(ntryL,G1H36(7),wf4(:,5),G1H9(70),m3h4x9(:,23),heltab2x36(:,:,104))
  call Hloop_A_Q(ntryL,G1H9(70),19,0,G2H9(15),n2h9(95))
  call Hloop_AV_Q(ntryL,G1H36(8),wf4(:,5),G1H9(77),m3h4x9(:,24),heltab2x36(:,:,105))
  call Hloop_A_Q(ntryL,G1H9(77),19,nMB,G2H9(16),n2h9(96))
  call Hloop_QV_A(ntryL,G1H36(9),wf4(:,5),G1H9(78),m3h4x9(:,25),heltab2x36(:,:,106))
  call Hloop_Q_A(ntryL,G1H9(78),19,0,G2H9(17),n2h9(97))
  call Hloop_QV_A(ntryL,G1H36(12),wf4(:,5),G1H9(18),m3h4x9(:,26),heltab2x36(:,:,107))
  call Hloop_Q_A(ntryL,G1H9(18),19,nMB,G2H9(18),n2h9(98))
  call Hloop_AQ_V(ntryL,G1H36(15),wf6(:,3),G1H6(11),m3h6x6(:,3),heltab2x36(:,:,108))
  call Hloop_AQ_Z(ntryL,G1H36(13),wf6(:,3),G1H6(14),ngZd,m3h6x6(:,4),heltab2x36(:,:,109))
  call Hloop_AQ_W(ntryL,G1H36(14),wf6(:,3),G1H6(17),m3h6x6(:,5),heltab2x36(:,:,110))
  call Hloop_VQ_A(ntryL,G1H36(16),wf6(:,3),G1H6(20),m3h6x6(:,6),heltab2x36(:,:,111))
  call Hloop_Q_A(ntryL,G1H6(20),21,0,G2H6(21),n2h6(60))
  call Hloop_VQ_A(ntryL,G0H18(12),wf6(:,3),G0H3(1),m3h6x3(:,7),heltab2x18(:,:,149))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(98),n2h3(139))
  call Hloop_ZQ_A(ntryL,G0H18(10),wf6(:,3),G0H3(1),ngZd,m3h6x3(:,8),heltab2x18(:,:,150))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(99),n2h3(140))
  call Hloop_AQ_W(ntryL,G1H18(4),wf6(:,3),G1H3(104),m3h6x3(:,9),heltab2x18(:,:,151))
  call Hloop_AQ_V(ntryL,G1H18(5),wf6(:,3),G1H3(115),m3h6x3(:,10),heltab2x18(:,:,152))
  call Hloop_AQ_W(ntryL,G1H18(6),wf6(:,3),G1H3(120),m3h6x3(:,11),heltab2x18(:,:,153))
  call Hloop_AQ_Z(ntryL,G1H18(34),wf6(:,3),G1H3(121),ngZd,m3h6x3(:,12),heltab2x18(:,:,154))
  call Hloop_QA_V(ntryL,G1H36(20),ex2(:),G1H18(45),m3h2x18(:,71),heltab2x36(:,:,112))
  call Hloop_QA_Z(ntryL,G1H36(18),ex2(:),G1H18(46),ngZu,m3h2x18(:,72),heltab2x36(:,:,113))
  call Hloop_QA_W(ntryL,G1H36(19),ex2(:),G1H18(47),m3h2x18(:,73),heltab2x36(:,:,114))
  call Hloop_VA_Q(ntryL,G1H36(21),ex2(:),G1H18(48),m3h2x18(:,74),heltab2x36(:,:,115))
  call Hloop_A_Q(ntryL,G1H18(48),18,0,G2H18(1),n2h18(78))
  call Hloop_VA_Q(ntryL,G0H6(9),ex2(:),G0H3(1),m3h2x3(:,70),heltab2x6(:,:,186))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(136),n2h3(141))
  call Hloop_ZA_Q(ntryL,G0H6(8),ex2(:),G0H3(1),ngZu,m3h2x3(:,71),heltab2x6(:,:,187))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(142),n2h3(142))
  call Hloop_QA_V(ntryL,G1H6(126),ex2(:),G1H3(143),m3h2x3(:,72),heltab2x6(:,:,188))
  call Hloop_QA_W(ntryL,G1H6(127),ex2(:),G1H3(154),m3h2x3(:,73),heltab2x6(:,:,189))
  call Hloop_QA_Z(ntryL,G1H6(128),ex2(:),G1H3(158),ngZu,m3h2x3(:,74),heltab2x6(:,:,190))
  call Hloop_QA_W(ntryL,G1H6(133),ex2(:),G1H3(164),m3h2x3(:,75),heltab2x6(:,:,191))
  call Hloop_QW_A(ntryL,G1H18(36),ex3(:),G1H6(130),m3h3x6(:,57),heltab2x18(:,:,155))
  call Hloop_Q_A(ntryL,G1H6(130),21,0,G2H6(23),n2h6(61))
  call Hloop_UW_V(ntryL,G0H18(5),17,ex3(:),4,G1H6(55),m3h3x6(:,58),heltab2x18(:,:,156))
  call Hloop_UV_W(ntryL,G0H18(7),17,ex3(:),4,G1H6(13),m3h3x6(:,59),heltab2x18(:,:,157))
  call Hloop_UW_V(ntryL,G0H18(8),17,ex3(:),4,G1H6(61),m3h3x6(:,60),heltab2x18(:,:,158))
  call Hloop_UV_W(ntryL,G0H18(13),17,ex3(:),4,G1H6(19),m3h3x6(:,61),heltab2x18(:,:,159))
  call Hloop_AQ_V(ntryL,G1H36(28),ex1(:),G1H18(49),m3h2x18(:,75),heltab2x36(:,:,116))
  call Hloop_AQ_Z(ntryL,G1H36(25),ex1(:),G1H18(50),ngZu,m3h2x18(:,76),heltab2x36(:,:,117))
  call Hloop_AQ_W(ntryL,G1H36(24),ex1(:),G1H18(51),m3h2x18(:,77),heltab2x36(:,:,118))
  call Hloop_VQ_A(ntryL,G1H36(27),ex1(:),G1H18(52),m3h2x18(:,78),heltab2x36(:,:,119))
  call Hloop_Q_A(ntryL,G1H18(52),17,0,G2H18(2),n2h18(79))
  call Hloop_VQ_A(ntryL,G0H6(12),ex1(:),G0H3(1),m3h2x3(:,76),heltab2x6(:,:,192))
  call Hloop_Q_A(ntryL,G0H3(1),27,0,G1H3(175),n2h3(143))
  call Hloop_ZQ_A(ntryL,G0H6(11),ex1(:),G0H3(1),ngZu,m3h2x3(:,77),heltab2x6(:,:,193))
  call Hloop_Q_A(ntryL,G0H3(1),27,0,G1H3(176),n2h3(144))
  call Hloop_AQ_V(ntryL,G1H6(138),ex1(:),G1H3(180),m3h2x3(:,78),heltab2x6(:,:,194))
  call Hloop_AQ_W(ntryL,G1H6(134),ex1(:),G1H3(9),m3h2x3(:,79),heltab2x6(:,:,195))
  call Hloop_AQ_Z(ntryL,G1H6(137),ex1(:),G1H3(31),ngZu,m3h2x3(:,80),heltab2x6(:,:,196))
  call Hloop_AQ_W(ntryL,G1H6(139),ex1(:),G1H3(42),m3h2x3(:,81),heltab2x6(:,:,197))
  call Hloop_QA_Z(ntryL,G1H18(38),ex2(:),G1H9(93),ngZu,m3h2x9(:,76),heltab2x18(:,:,160))
  call Hloop_QA_W(ntryL,G1H18(39),ex2(:),G1H9(40),m3h2x9(:,77),heltab2x18(:,:,161))
  call Hloop_VA_Q(ntryL,G0H18(6),ex2(:),G0H9(17),m3h2x9(:,78),heltab2x18(:,:,162))
  call Hloop_A_Q(ntryL,G0H9(17),19,0,G1H9(6),n2h9(99))
  call Hloop_ZA_Q(ntryL,G0H18(2),ex2(:),G0H9(4),ngZu,m3h2x9(:,79),heltab2x18(:,:,163))
  call Hloop_A_Q(ntryL,G0H9(4),19,0,G1H9(94),n2h9(100))
  call Hloop_WA_Q(ntryL,G0H18(3),ex2(:),G0H9(2),m3h2x9(:,80),heltab2x18(:,:,164))
  call Hloop_A_Q(ntryL,G0H9(2),19,0,G1H9(41),n2h9(101))
  call Hloop_VA_Q(ntryL,G0H18(15),ex2(:),G0H9(3),m3h2x9(:,81),heltab2x18(:,:,165))
  call Hloop_A_Q(ntryL,G0H9(3),19,0,G1H9(7),n2h9(102))
  call Hloop_ZA_Q(ntryL,G0H18(9),ex2(:),G0H9(20),ngZu,m3h2x9(:,82),heltab2x18(:,:,166))
  call Hloop_A_Q(ntryL,G0H9(20),19,0,G1H9(8),n2h9(103))
  call Hloop_WA_Q(ntryL,G0H18(14),ex2(:),G0H9(7),m3h2x9(:,83),heltab2x18(:,:,167))
  call Hloop_A_Q(ntryL,G0H9(7),19,0,G1H9(39),n2h9(104))
  call Hloop_QA_W(ntryL,G1H18(41),ex2(:),G1H9(99),m3h2x9(:,84),heltab2x18(:,:,168))
  call Hloop_AQ_Z(ntryL,G1H18(42),ex1(:),G1H9(51),ngZu,m3h2x9(:,85),heltab2x18(:,:,169))
  call Hloop_AQ_W(ntryL,G1H18(43),ex1(:),G1H9(44),m3h2x9(:,86),heltab2x18(:,:,170))
  call Hloop_VQ_A(ntryL,G0H18(19),ex1(:),G0H9(5),m3h2x9(:,87),heltab2x18(:,:,171))
  call Hloop_Q_A(ntryL,G0H9(5),19,0,G1H9(100),n2h9(105))
  call Hloop_ZQ_A(ntryL,G0H18(17),ex1(:),G0H9(6),ngZu,m3h2x9(:,88),heltab2x18(:,:,172))
  call Hloop_Q_A(ntryL,G0H9(6),19,0,G1H9(52),n2h9(106))
  call Hloop_WQ_A(ntryL,G0H18(18),ex1(:),G0H9(23),m3h2x9(:,89),heltab2x18(:,:,173))
  call Hloop_Q_A(ntryL,G0H9(23),19,0,G1H9(45),n2h9(107))
  call Hloop_VQ_A(ntryL,G0H18(23),ex1(:),G0H9(9),m3h2x9(:,90),heltab2x18(:,:,174))
  call Hloop_Q_A(ntryL,G0H9(9),19,0,G1H9(101),n2h9(108))
  call Hloop_ZQ_A(ntryL,G0H18(21),ex1(:),G0H9(8),ngZu,m3h2x9(:,91),heltab2x18(:,:,175))
  call Hloop_Q_A(ntryL,G0H9(8),19,0,G1H9(55),n2h9(109))
  call Hloop_WQ_A(ntryL,G0H18(22),ex1(:),G0H9(24),m3h2x9(:,92),heltab2x18(:,:,176))
  call Hloop_Q_A(ntryL,G0H9(24),19,0,G1H9(46),n2h9(110))
  call Hloop_AQ_W(ntryL,G1H18(44),ex1(:),G1H9(102),m3h2x9(:,93),heltab2x18(:,:,177))
  call Hloop_QA_V(ntryL,G1H36(32),ex2(:),G1H18(53),m3h2x18(:,79),heltab2x36(:,:,120))
  call Hloop_QA_Z(ntryL,G1H36(30),ex2(:),G1H18(54),ngZu,m3h2x18(:,80),heltab2x36(:,:,121))
  call Hloop_QA_W(ntryL,G1H36(31),ex2(:),G1H18(55),m3h2x18(:,81),heltab2x36(:,:,122))
  call Hloop_QA_V(ntryL,G1H36(39),ex2(:),G1H18(56),m3h2x18(:,82),heltab2x36(:,:,123))
  call Hloop_QA_Z(ntryL,G1H36(36),ex2(:),G1H18(57),ngZu,m3h2x18(:,83),heltab2x36(:,:,124))
  call Hloop_QA_W(ntryL,G1H36(35),ex2(:),G1H18(58),m3h2x18(:,84),heltab2x36(:,:,125))
  call Hloop_VA_Q(ntryL,G1H36(38),ex2(:),G1H18(59),m3h2x18(:,85),heltab2x36(:,:,126))
  call Hloop_A_Q(ntryL,G1H18(59),18,0,G2H18(3),n2h18(80))
  call Hloop_VA_Q(ntryL,G1H36(43),ex2(:),G1H18(60),m3h2x18(:,86),heltab2x36(:,:,127))
  call Hloop_A_Q(ntryL,G1H18(60),18,0,G2H18(4),n2h18(81))
  call Hloop_AQ_V(ntryL,G1H36(45),ex1(:),G1H18(61),m3h2x18(:,87),heltab2x36(:,:,128))
  call Hloop_AQ_Z(ntryL,G1H36(42),ex1(:),G1H18(62),ngZu,m3h2x18(:,88),heltab2x36(:,:,129))
  call Hloop_AQ_W(ntryL,G1H36(47),ex1(:),G1H18(63),m3h2x18(:,89),heltab2x36(:,:,130))
  call Hloop_AQ_V(ntryL,G1H36(50),ex1(:),G1H18(64),m3h2x18(:,90),heltab2x36(:,:,131))
  call Hloop_AQ_Z(ntryL,G1H36(51),ex1(:),G1H18(65),ngZu,m3h2x18(:,91),heltab2x36(:,:,132))
  call Hloop_AQ_W(ntryL,G1H36(49),ex1(:),G1H18(66),m3h2x18(:,92),heltab2x36(:,:,133))
  call Hloop_VQ_A(ntryL,G1H36(55),ex1(:),G1H18(67),m3h2x18(:,93),heltab2x36(:,:,134))
  call Hloop_Q_A(ntryL,G1H18(67),17,0,G2H18(5),n2h18(82))
  call Hloop_VQ_A(ntryL,G1H36(53),ex1(:),G1H18(68),m3h2x18(:,94),heltab2x36(:,:,135))
  call Hloop_Q_A(ntryL,G1H18(68),17,0,G2H18(6),n2h18(83))
  call Hloop_AW_Q(ntryL,G1H9(86),ex3(:),G1H3(86),m3h3x3(:,117),heltab2x9(:,:,153))
  call Hloop_A_Q(ntryL,G1H3(86),23,0,G2H3(3),n2h3(145))
  call Hloop_AW_Q(ntryL,G1H9(87),ex3(:),G1H3(97),m3h3x3(:,118),heltab2x9(:,:,154))
  call Hloop_A_Q(ntryL,G1H3(97),23,0,G2H3(59),n2h3(146))
  call Hloop_AW_Q(ntryL,G1H9(88),ex3(:),G1H3(19),m3h3x3(:,119),heltab2x9(:,:,155))
  call Hloop_A_Q(ntryL,G1H3(19),23,0,G2H3(28),n2h3(147))
  call Hloop_QW_A(ntryL,G1H9(83),ex3(:),G1H3(30),m3h3x3(:,120),heltab2x9(:,:,156))
  call Hloop_Q_A(ntryL,G1H3(30),23,nME,G2H3(6),n2h3(148))
  call Hloop_QW_A(ntryL,G1H9(84),ex3(:),G1H3(118),m3h3x3(:,121),heltab2x9(:,:,157))
  call Hloop_Q_A(ntryL,G1H3(118),23,nMM,G2H3(62),n2h3(149))
  call Hloop_QW_A(ntryL,G1H9(85),ex3(:),G1H3(41),m3h3x3(:,122),heltab2x9(:,:,158))
  call Hloop_Q_A(ntryL,G1H3(41),23,nML,G2H3(32),n2h3(150))
  call Hloop_SV_T(ntryL,G1H9(97),19,ex3(:),4,G2H3(75),m3h3x3(:,123),heltab2x9(:,:,159))
  call Hloop_SV_T(ntryL,G1H9(98),19,ex3(:),4,G2H3(76),m3h3x3(:,124),heltab2x9(:,:,160))
  call Hloop_TV_S(ntryL,G1H9(95),19,ex3(:),4,G2H3(77),m3h3x3(:,125),heltab2x9(:,:,161))
  call Hloop_TV_S(ntryL,G1H9(96),19,ex3(:),4,G2H3(78),m3h3x3(:,126),heltab2x9(:,:,162))
  call Hloop_DV_C(ntryL,G1H9(103),19,ex3(:),G2H3(79),m3h3x3(:,127),heltab2x9(:,:,163))
  call Hloop_DV_C(ntryL,G1H9(104),19,ex3(:),G2H3(80),m3h3x3(:,128),heltab2x9(:,:,164))
  call Hloop_CV_D(ntryL,G1H9(105),19,ex3(:),4,G2H3(81),m3h3x3(:,129),heltab2x9(:,:,165))
  call Hloop_CV_D(ntryL,G1H9(106),19,ex3(:),4,G2H3(82),m3h3x3(:,130),heltab2x9(:,:,166))
  call Hloop_UV_W(ntryL,G1H9(109),19,ex3(:),4,G2H3(83),m3h3x3(:,131),heltab2x9(:,:,167))
  call Hloop_UV_W(ntryL,G1H9(110),19,ex3(:),4,G2H3(84),m3h3x3(:,132),heltab2x9(:,:,168))
  call Hloop_SV_T(ntryL,G0H9(19),19,ex3(:),4,G1H3(140),m3h3x3(:,133),heltab2x9(:,:,169))
  call Hloop_TV_S(ntryL,G0H9(18),19,ex3(:),4,G1H3(129),m3h3x3(:,134),heltab2x9(:,:,170))
  call Hloop_VV_S(ntryL,G0H9(22),ex3(:),G0H3(1),m3h3x3(:,135),heltab2x9(:,:,171))
  call Hloop_VV_S(ntryL,G0H9(21),ex3(:),G0H3(2),m3h3x3(:,136),heltab2x9(:,:,172))
  call Hloop_SV_V(ntryL,G1H9(113),ex3(:),G1H3(63),m3h3x3(:,137),heltab2x9(:,:,173))
  call Hloop_SV_V(ntryL,G1H9(114),ex3(:),G1H3(74),m3h3x3(:,138),heltab2x9(:,:,174))
  call Hloop_VV_S(ntryL,G1H9(116),ex3(:),G1H3(6),m3h3x3(:,139),heltab2x9(:,:,175))
  call Hloop_SV_V(ntryL,G0H9(25),ex3(:),G0H3(3),m3h3x3(:,140),heltab2x9(:,:,176))
  call Hloop_SV_V(ntryL,G0H9(27),ex3(:),G0H3(4),m3h3x3(:,141),heltab2x9(:,:,177))
  call Hloop_SV_V(ntryL,G0H9(26),ex3(:),G0H3(5),m3h3x3(:,142),heltab2x9(:,:,178))
  call Hloop_UV_W(ntryL,G0H9(30),19,ex3(:),4,G1H3(173),m3h3x3(:,143),heltab2x9(:,:,179))
  call Hloop_UV_W(ntryL,G0H9(32),19,ex3(:),4,G1H3(184),m3h3x3(:,144),heltab2x9(:,:,180))
  call Hloop_UW_V(ntryL,G0H9(31),19,ex3(:),4,G1H3(96),m3h3x3(:,145),heltab2x9(:,:,181))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(14),G2H2(50),G2H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(53),G2H2(47),G2H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(98),[G1H3(234),G1H3(172),G1H3(22)])
call HGT_w2_OLR(G1H3(81),1,1,3)
call HGT_w2_invQ_OLR(G1H3(81),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(81),[G1H3(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(93),[G1H3(11)])
call HGT_OLR(G2H3(86),1,1,3)
call HGT_invQ_OLR(G2H3(86),2,5,3)
call HGT_OLR(G2H3(86),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(86),[G1H3(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(118),[G2H3(87),G1H3(204),G1H3(197),G1H3(132),G1H3(110) &
    ,G1H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(41),[G1H3(153),G1H3(131)])
call HGT_OLR(G2H3(90),1,1,3)
call HGT_invQ_OLR(G2H3(90),2,5,3)
call HGT_OLR(G2H3(90),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(90),[G2H3(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(91),[G1H3(255),G1H3(247),G1H3(212),G1H3(169)])
call HGT_OLR(G2H3(94),1,1,3)
call HGT_invQ_OLR(G2H3(94),2,5,3)
call HGT_OLR(G2H3(94),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(94),[G1H3(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(124),[G2H3(95),G1H3(220),G1H3(194),G1H3(191),G1H3(75) &
    ,G1H3(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(47),[G1H3(151),G1H3(107),G1H3(163)])
call HGT_OLR(G2H3(98),1,1,3)
call HGT_invQ_OLR(G2H3(98),2,5,3)
call HGT_OLR(G2H3(98),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(98),[G2H3(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(99),[G1H3(271),G1H3(228),G1H3(17),G1H3(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G1H3(200),G1H3(196),G1H3(183)])
call HGT_w2_OLR(G1H3(126),1,1,3)
call HGT_w2_invQ_OLR(G1H3(126),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G1H3(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G1H3(343)])
call HGT_OLR(G2H3(102),1,1,3)
call HGT_invQ_OLR(G2H3(102),2,5,3)
call HGT_OLR(G2H3(102),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(102),[G2H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(103),[G1H3(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(20),[G1H3(340)])
call HGT_OLR(G2H3(106),1,1,3)
call HGT_invQ_OLR(G2H3(106),2,5,3)
call HGT_OLR(G2H3(106),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(106),[G2H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(107),[G1H3(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(121),[G2H3(111),G1H3(341),G1H3(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(127),[G2H3(115),G1H3(344),G1H3(338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(136),[G1H3(257),G1H3(3),G1H3(8)])
call HGT_w2_OLR(G1H3(119),1,1,3)
call HGT_w2_invQ_OLR(G1H3(119),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(119),[G1H3(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(175),[G1H3(246),G1H3(241),G1H3(10)])
call HGT_w2_OLR(G1H3(130),1,1,3)
call HGT_w2_invQ_OLR(G1H3(130),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(130),[G1H3(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(21),[G2H6(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(100),[G1H9(53)])
call HGT_w2_OLR(G1H9(79),1,1,9)
call HGT_w2_invQ_OLR(G1H9(79),2,5,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(79),[G1H9(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(101),[G1H9(1)])
call HGT_w2_OLR(G1H9(15),1,1,9)
call HGT_w2_invQ_OLR(G1H9(15),2,5,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(15),[G1H9(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(176),[G1H3(254),G1H3(249),G1H3(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(99),[G1H3(238),G1H3(201),G1H3(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(92),[G1H2(76),G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(237),[G1H3(233),G1H3(203),G1H3(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(250),[G1H3(242),G1H3(207),G1H3(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(273),[G1H3(270),G1H3(265),G1H3(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(262),[G1H3(258),G1H3(215),G1H3(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(266),[G1H3(223),G1H3(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(142),[G1H3(261),G1H3(193),G1H3(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(274),[G1H3(231),G1H3(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(139),G1H2(134),G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(159),[G1H2(149),G1H2(144),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(37),[G1H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(104),[G1H3(29),G1H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(135),[G1H2(72),G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(140),[G1H2(99),G1H2(84),G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(288),[G1H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(120),[G1H3(47),G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(145),[G1H2(115),G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(150),[G1H2(120),G1H2(9),G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(293),[G1H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(155),[G1H2(125),G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(298),[G1H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(160),[G1H2(130),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(83),[G1H3(112),G0H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(115),[G1H3(329),G1H3(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(162),[G1H2(56),G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(167),[G1H2(66),G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(84),[G1H3(68),G0H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(121),[G1H3(334),G1H3(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(95),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(57),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(166),[G1H2(90),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(48),[G1H3(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(105),[G1H3(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(303),[G1H3(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(139),[G1H3(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(308),[G1H3(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(313),[G1H3(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(124),[G1H2(94),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(129),[G1H2(119),G1H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G1H3(211),G1H3(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(35),[G1H3(219),G1H3(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G1H3(230),G1H3(227),G1H3(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(5),[G1H6(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(55),[G1H6(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(17),[G1H6(93),G1H6(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(13),[G1H6(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(11),[G1H6(6),G1H6(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(61),[G1H6(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(19),[G1H6(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(14),[G1H6(110),G1H6(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(6),[G1H9(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(1),[G1H9(3),G1H9(32),G1H9(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(94),[G1H9(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(41),[G1H9(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(7),[G1H9(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(10),[G1H9(43),G1H9(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(8),[G1H9(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(39),[G1H9(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(15),[G1H9(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(4),[G1H9(23),G1H9(12),G1H9(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(52),[G1H9(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(45),[G1H9(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(12),[G1H9(30),G1H9(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(55),[G1H9(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(46),[G1H9(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(17),[G1H9(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(154),[G1H3(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(294),[G1H3(38),G1H3(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(164),[G1H3(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(299),[G1H3(289),G1H3(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(309),[G1H3(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(314),[G1H3(304)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(38),[G1H3(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G1H3(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G1H3(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G1H3(337)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(75),[G0H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(78),[G0H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(6),[G1H3(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(173),[G1H3(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(184),[G1H3(74)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex2(:),G2tensor(3),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(56),ex2(:),G2tensor(5),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hloop_QW_A(ntryL,G1H3(81),ex4(:),G1H1(1),m3h3x1(:,345),heltab2x3(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(503))
  call Hloop_QW_A(ntryL,G2H3(86),ex3(:),G2H1(1),m3h3x1(:,346),heltab2x3(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(13),n2h1(504))
  call Hloop_QW_A(ntryL,G2H3(118),ex4(:),G2H1(1),m3h3x1(:,347),heltab2x3(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(14),n2h1(505))
  call Hloop_QW_A(ntryL,G2H3(90),ex4(:),G2H1(1),m3h3x1(:,348),heltab2x3(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(15),n2h1(506))
  call Hloop_QW_A(ntryL,G2H3(91),ex3(:),G2H1(1),m3h3x1(:,349),heltab2x3(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(16),n2h1(507))
  call Hloop_AW_Q(ntryL,G2H3(94),ex3(:),G2H1(1),m3h3x1(:,350),heltab2x3(:,:,350))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(17),n2h1(508))
  call Hloop_AW_Q(ntryL,G2H3(124),ex4(:),G2H1(1),m3h3x1(:,351),heltab2x3(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(18),n2h1(509))
  call Hloop_AW_Q(ntryL,G2H3(98),ex4(:),G2H1(1),m3h3x1(:,352),heltab2x3(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(19),n2h1(510))
  call Hloop_AW_Q(ntryL,G2H3(99),ex3(:),G2H1(1),m3h3x1(:,353),heltab2x3(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(20),n2h1(511))
  call Hloop_QW_A(ntryL,G2H3(5),ex4(:),G2H1(1),m3h3x1(:,354),heltab2x3(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(21),n2h1(512))
  call Hloop_AW_Q(ntryL,G2H3(102),ex4(:),G2H1(1),m3h3x1(:,355),heltab2x3(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(22),n2h1(513))
  call Hloop_AW_Q(ntryL,G2H3(103),ex3(:),G2H1(1),m3h3x1(:,356),heltab2x3(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(23),n2h1(514))
  call Hloop_QW_A(ntryL,G2H3(106),ex4(:),G2H1(1),m3h3x1(:,357),heltab2x3(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(24),n2h1(515))
  call Hloop_QW_A(ntryL,G2H3(107),ex3(:),G2H1(1),m3h3x1(:,358),heltab2x3(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(25),n2h1(516))
call HGT_OLR(G2H3(110),1,1,3)
call HGT_invQ_OLR(G2H3(110),2,5,3)
call HGT_OLR(G2H3(110),6,15,3)
  call Hloop_QW_A(ntryL,G2H3(110),ex3(:),G2H1(1),m3h3x1(:,359),heltab2x3(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(26),n2h1(517))
  call Hloop_QW_A(ntryL,G2H3(121),ex4(:),G2H1(1),m3h3x1(:,360),heltab2x3(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(27),n2h1(518))
call HGT_OLR(G2H3(114),1,1,3)
call HGT_invQ_OLR(G2H3(114),2,5,3)
call HGT_OLR(G2H3(114),6,15,3)
  call Hloop_AW_Q(ntryL,G2H3(114),ex3(:),G2H1(1),m3h3x1(:,361),heltab2x3(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(28),n2h1(519))
  call Hloop_AW_Q(ntryL,G2H3(127),ex4(:),G2H1(1),m3h3x1(:,362),heltab2x3(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(29),n2h1(520))
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(1),wf4(:,5),G2H1(1),m3h4x1(:,1),heltab2x4(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(30),n2h1(521))
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(2),wf4(:,5),G2H1(1),m3h4x1(:,2),heltab2x4(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(31),n2h1(522))
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(3),wf4(:,5),G2H1(1),m3h4x1(:,3),heltab2x4(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(32),n2h1(523))
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(4),wf4(:,5),G2H1(1),m3h4x1(:,4),heltab2x4(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(33),n2h1(524))
  call Hloop_AW_Q(ntryL,G1H3(119),ex4(:),G1H1(1),m3h3x1(:,363),heltab2x3(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(525))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(14),wf6(:,3),G2tensor(8),m3h6x1(:,35),heltab2x6(:,:,198))
  call Hloop_QW_A(ntryL,G1H3(130),ex3(:),G1H1(1),m3h3x1(:,364),heltab2x3(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(526))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(21),wf6(:,4),G2tensor(15),m3h6x1(:,36),heltab2x6(:,:,199))
  call Hloop_QV_A(ntryL,G1H9(79),wf9(:,1),G1H1(1),m3h9x1(:,37),heltab2x9(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(527))
  call Hloop_QZ_A(ntryL,G1H9(15),wf9(:,1),G1H1(1),ngZu,m3h9x1(:,38),heltab2x9(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(528))
  call Hloop_VA_Q(ntryL,G1H2(31),ex2(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(529))
  call Hloop_VA_Q(ntryL,G1H2(59),ex2(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(530))
  call Hloop_ZA_Q(ntryL,G1H2(101),ex2(:),G1H1(1),ngZu,m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(18),n2h1(531))
  call Hloop_ZA_Q(ntryL,G1H2(30),ex2(:),G1H1(1),ngZu,m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(532))
  call Hloop_QW_A(ntryL,G1H3(176),ex3(:),G1H1(1),m3h3x1(:,365),heltab2x3(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(533))
  call Hloop_QW_A(ntryL,G1H3(99),ex4(:),G1H1(1),m3h3x1(:,366),heltab2x3(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(534))
  call Hloop_WQ_A(ntryL,G1H2(55),ex1(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(535))
  call Hloop_WQ_A(ntryL,G1H2(92),ex1(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(26),n2h1(536))
  call Hloop_QW_A(ntryL,G1H3(237),ex4(:),G1H1(1),m3h3x1(:,367),heltab2x3(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(537))
  call Hloop_QW_A(ntryL,G1H3(250),ex3(:),G1H1(1),m3h3x1(:,368),heltab2x3(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(30),n2h1(538))
  call Hloop_AW_Q(ntryL,G1H3(273),ex3(:),G1H1(1),m3h3x1(:,369),heltab2x3(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(539))
  call Hloop_AW_Q(ntryL,G1H3(262),ex4(:),G1H1(1),m3h3x1(:,370),heltab2x3(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(540))
  call Hloop_AW_Q(ntryL,G1H3(266),ex3(:),G1H1(1),m3h3x1(:,371),heltab2x3(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(541))
  call Hloop_AW_Q(ntryL,G1H3(142),ex4(:),G1H1(1),m3h3x1(:,372),heltab2x3(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(444),n2h1(542))
  call Hloop_AW_Q(ntryL,G1H3(274),ex3(:),G1H1(1),m3h3x1(:,373),heltab2x3(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(38),n2h1(543))
  call Hloop_WQ_A(ntryL,G1H2(75),ex1(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(544))
  call Hloop_WQ_A(ntryL,G1H2(87),ex1(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(447),n2h1(545))
  call Hloop_VQ_A(ntryL,G1H2(6),ex1(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(42),n2h1(546))
  call Hloop_VQ_A(ntryL,G1H2(13),ex1(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(547))
  call Hloop_ZQ_A(ntryL,G1H2(49),ex1(:),G1H1(1),ngZu,m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(548))
  call Hloop_ZQ_A(ntryL,G1H2(7),ex1(:),G1H1(1),ngZu,m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(450),n2h1(549))
  call Hloop_VA_Q(ntryL,G1H2(154),ex2(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(50),n2h1(550))
  call Hloop_ZA_Q(ntryL,G1H2(159),ex2(:),G1H1(1),ngZu,m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(551))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(37),23,ex4(:),8,G2tensor(432),m3h3x1(:,374),heltab2x3(:,:,374))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(104),23,ex4(:),8,G2tensor(54),m3h3x1(:,375),heltab2x3(:,:,375))
  call Hloop_VA_Q(ntryL,G1H2(135),ex2(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(552))
  call Hloop_VA_Q(ntryL,G1H2(140),ex2(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(426),n2h1(553))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(288),23,ex4(:),8,G2tensor(58),m3h3x1(:,376),heltab2x3(:,:,376))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(120),23,ex4(:),8,G2tensor(61),m3h3x1(:,377),heltab2x3(:,:,377))
  call Hloop_ZA_Q(ntryL,G1H2(145),ex2(:),G1H1(1),ngZu,m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(429),n2h1(554))
  call Hloop_ZA_Q(ntryL,G1H2(150),ex2(:),G1H1(1),ngZu,m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(555))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(293),23,ex4(:),8,G2tensor(65),m3h3x1(:,378),heltab2x3(:,:,378))
  call Hloop_VA_Q(ntryL,G1H2(155),ex2(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(556))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(298),23,ex4(:),8,G2tensor(73),m3h3x1(:,379),heltab2x3(:,:,379))
  call Hloop_ZA_Q(ntryL,G1H2(160),ex2(:),G1H1(1),ngZu,m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(74),n2h1(557))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(83),23,ex4(:),8,G3tensor(34),m3h3x1(:,380),heltab2x3(:,:,380))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(115),23,ex4(:),8,G2tensor(77),m3h3x1(:,381),heltab2x3(:,:,381))
  call Hloop_WA_Q(ntryL,G1H2(162),ex2(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(78),n2h1(558))
  call Hloop_WA_Q(ntryL,G1H2(167),ex2(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(559))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(84),23,ex4(:),8,G3tensor(35),m3h3x1(:,382),heltab2x3(:,:,382))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(121),23,ex4(:),8,G2tensor(94),m3h3x1(:,383),heltab2x3(:,:,383))
  call Hloop_WA_Q(ntryL,G1H2(105),ex2(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(82),n2h1(560))
  call Hloop_WA_Q(ntryL,G1H2(57),ex2(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(561))
  call Hloop_WA_Q(ntryL,G1H2(166),ex2(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(562))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(48),27,ex3(:),4,G2tensor(86),m3h3x1(:,384),heltab2x3(:,:,384))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(105),27,ex3(:),4,G2tensor(93),m3h3x1(:,385),heltab2x3(:,:,385))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(303),27,ex3(:),4,G2tensor(97),m3h3x1(:,386),heltab2x3(:,:,386))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(139),27,ex3(:),4,G2tensor(101),m3h3x1(:,387),heltab2x3(:,:,387))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(308),27,ex3(:),4,G2tensor(105),m3h3x1(:,388),heltab2x3(:,:,388))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(313),27,ex3(:),4,G2tensor(1),m3h3x1(:,389),heltab2x3(:,:,389))
  call Hloop_VA_Q(ntryL,G1H2(124),ex2(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(159),n2h1(563))
  call Hloop_ZA_Q(ntryL,G1H2(129),ex2(:),G1H1(1),ngZu,m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(321),n2h1(564))
  call Hloop_QW_A(ntryL,G2H3(2),ex3(:),G2H1(1),m3h3x1(:,390),heltab2x3(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(36),n2h1(565))
  call Hloop_AW_Q(ntryL,G2H3(35),ex4(:),G2H1(1),m3h3x1(:,391),heltab2x3(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(37),n2h1(566))
  call Hloop_AW_Q(ntryL,G2H3(9),ex3(:),G2H1(1),m3h3x1(:,392),heltab2x3(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(38),n2h1(567))
  call Hloop_WQ_A(ntryL,G1H6(51),wf6(:,3),G1H1(1),m3h6x1(:,37),heltab2x6(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(333),n2h1(568))
  call Hloop_WQ_A(ntryL,G1H6(5),wf6(:,3),G1H1(1),m3h6x1(:,38),heltab2x6(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(139),n2h1(569))
  call Hloop_VQ_A(ntryL,G1H6(58),wf6(:,3),G1H1(1),m3h6x1(:,39),heltab2x6(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(140),n2h1(570))
  call Hloop_VQ_A(ntryL,G1H6(59),wf6(:,3),G1H1(1),m3h6x1(:,40),heltab2x6(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(148),n2h1(571))
  call Hloop_WQ_A(ntryL,G1H6(2),wf6(:,3),G1H1(1),m3h6x1(:,41),heltab2x6(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(154),n2h1(572))
  call Hloop_ZQ_A(ntryL,G1H6(69),wf6(:,3),G1H1(1),ngZd,m3h6x1(:,42),heltab2x6(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(225),n2h1(573))
  call Hloop_ZQ_A(ntryL,G1H6(70),wf6(:,3),G1H1(1),ngZd,m3h6x1(:,43),heltab2x6(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(408),n2h1(574))
  call Hloop_WA_Q(ntryL,G1H6(55),wf6(:,4),G1H1(1),m3h6x1(:,44),heltab2x6(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(231),n2h1(575))
  call Hloop_WA_Q(ntryL,G1H6(17),wf6(:,4),G1H1(1),m3h6x1(:,45),heltab2x6(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(237),n2h1(576))
  call Hloop_VA_Q(ntryL,G1H6(13),wf6(:,4),G1H1(1),m3h6x1(:,46),heltab2x6(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(414),n2h1(577))
  call Hloop_VA_Q(ntryL,G1H6(11),wf6(:,4),G1H1(1),m3h6x1(:,47),heltab2x6(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(243),n2h1(578))
  call Hloop_WA_Q(ntryL,G1H6(61),wf6(:,4),G1H1(1),m3h6x1(:,48),heltab2x6(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(264),n2h1(579))
  call Hloop_ZA_Q(ntryL,G1H6(19),wf6(:,4),G1H1(1),ngZd,m3h6x1(:,49),heltab2x6(:,:,212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(102),n2h1(580))
  call Hloop_ZA_Q(ntryL,G1H6(14),wf6(:,4),G1H1(1),ngZd,m3h6x1(:,50),heltab2x6(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(267),n2h1(581))
  call Hloop_VA_Q(ntryL,G1H6(106),wf6(:,4),G1H1(1),m3h6x1(:,51),heltab2x6(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(270),n2h1(582))
  call Hloop_ZA_Q(ntryL,G1H6(109),wf6(:,4),G1H1(1),ngZd,m3h6x1(:,52),heltab2x6(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(106),n2h1(583))
  call Hloop_AV_Q(ntryL,G1H9(6),wf9(:,1),G1H1(1),m3h9x1(:,39),heltab2x9(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(273),n2h1(584))
  call Hloop_AV_Q(ntryL,G2H9(1),wf9(:,1),G2H1(1),m3h9x1(:,40),heltab2x9(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(39),n2h1(585))
  call Hloop_AV_Q(ntryL,G1H9(94),wf9(:,1),G1H1(1),m3h9x1(:,41),heltab2x9(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(156),n2h1(586))
  call Hloop_AV_Q(ntryL,G1H9(41),wf9(:,1),G1H1(1),m3h9x1(:,42),heltab2x9(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(420),n2h1(587))
  call Hloop_AZ_Q(ntryL,G1H9(7),wf9(:,1),G1H1(1),ngZu,m3h9x1(:,43),heltab2x9(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(162),n2h1(588))
  call Hloop_AZ_Q(ntryL,G2H9(10),wf9(:,1),G2H1(1),ngZu,m3h9x1(:,44),heltab2x9(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(40),n2h1(589))
  call Hloop_AZ_Q(ntryL,G1H9(8),wf9(:,1),G1H1(1),ngZu,m3h9x1(:,45),heltab2x9(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(423),n2h1(590))
  call Hloop_AZ_Q(ntryL,G1H9(39),wf9(:,1),G1H1(1),ngZd,m3h9x1(:,46),heltab2x9(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(165),n2h1(591))
  call Hloop_AZ_Q(ntryL,G2H9(15),wf9(:,1),G2H1(1),ngZd,m3h9x1(:,47),heltab2x9(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(41),n2h1(592))
  call Hloop_QV_A(ntryL,G2H9(4),wf9(:,1),G2H1(1),m3h9x1(:,48),heltab2x9(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(42),n2h1(593))
  call Hloop_QV_A(ntryL,G1H9(52),wf9(:,1),G1H1(1),m3h9x1(:,49),heltab2x9(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(453),n2h1(594))
  call Hloop_QV_A(ntryL,G1H9(45),wf9(:,1),G1H1(1),m3h9x1(:,50),heltab2x9(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(171),n2h1(595))
  call Hloop_QZ_A(ntryL,G2H9(12),wf9(:,1),G2H1(1),ngZu,m3h9x1(:,51),heltab2x9(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(43),n2h1(596))
  call Hloop_QZ_A(ntryL,G1H9(55),wf9(:,1),G1H1(1),ngZu,m3h9x1(:,52),heltab2x9(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(456),n2h1(597))
  call Hloop_QZ_A(ntryL,G1H9(46),wf9(:,1),G1H1(1),ngZd,m3h9x1(:,53),heltab2x9(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(177),n2h1(598))
  call Hloop_QZ_A(ntryL,G2H9(17),wf9(:,1),G2H1(1),ngZd,m3h9x1(:,54),heltab2x9(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(44),n2h1(599))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(154),23,ex4(:),8,G2tensor(46),m3h3x1(:,393),heltab2x3(:,:,393))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(294),23,ex4(:),8,G2tensor(183),m3h3x1(:,394),heltab2x3(:,:,394))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(164),23,ex4(:),8,G2tensor(459),m3h3x1(:,395),heltab2x3(:,:,395))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(299),23,ex4(:),8,G2tensor(189),m3h3x1(:,396),heltab2x3(:,:,396))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(309),27,ex3(:),4,G2tensor(441),m3h3x1(:,397),heltab2x3(:,:,397))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(314),27,ex3(:),4,G2tensor(195),m3h3x1(:,398),heltab2x3(:,:,398))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(318),27,ex3(:),4,G2tensor(435),m3h3x1(:,399),heltab2x3(:,:,399))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(319),27,ex3(:),4,G2tensor(201),m3h3x1(:,400),heltab2x3(:,:,400))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(323),27,ex3(:),4,G2tensor(438),m3h3x1(:,401),heltab2x3(:,:,401))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(324),27,ex3(:),4,G2tensor(207),m3h3x1(:,402),heltab2x3(:,:,402))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(328),23,ex4(:),8,G2tensor(66),m3h3x1(:,403),heltab2x3(:,:,403))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(333),23,ex4(:),8,G2tensor(210),m3h3x1(:,404),heltab2x3(:,:,404))
  call Hloop_AW_Q(ntryL,G2H3(38),ex3(:),G2H1(1),m3h3x1(:,405),heltab2x3(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(45),n2h1(600))
  call Hloop_QW_A(ntryL,G2H3(13),ex3(:),G2H1(1),m3h3x1(:,406),heltab2x3(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(46),n2h1(601))
  call Hloop_QW_A(ntryL,G2H3(16),ex4(:),G2H1(1),m3h3x1(:,407),heltab2x3(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(47),n2h1(602))
  call Hloop_AW_Q(ntryL,G2H3(11),ex4(:),G2H1(1),m3h3x1(:,408),heltab2x3(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(48),n2h1(603))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(70),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(19),wf6(:,3),G2tensor(213),m3h6x1(:,53),heltab2x6(:,:,216))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(20),wf6(:,4),G2tensor(399),m3h6x1(:,54),heltab2x6(:,:,217))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H9(67),ex4(:),ex3(:),G1tensor(109),m4h3x3x1(:,1),heltab3x9(:,:,1))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H9(26),ex4(:),ex3(:),G1tensor(139),m4h3x3x1(:,2),heltab3x9(:,:,2))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H9(72),ex4(:),ex3(:),G1tensor(169),m4h3x3x1(:,3),heltab3x9(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H9(11),ex4(:),ex3(:),G1tensor(18),m4h3x3x1(:,4),heltab3x9(:,:,4))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H9(81),ex3(:),ex4(:),G1tensor(36),m4h3x3x1(:,5),heltab3x9(:,:,5))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H9(36),ex4(:),ex3(:),G1tensor(38),m4h3x3x1(:,6),heltab3x9(:,:,6))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H9(74),ex4(:),ex3(:),G1tensor(44),m4h3x3x1(:,7),heltab3x9(:,:,7))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H9(34),ex4(:),ex3(:),G1tensor(54),m4h3x3x1(:,8),heltab3x9(:,:,8))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H9(80),ex4(:),ex3(:),G1tensor(68),m4h3x3x1(:,9),heltab3x9(:,:,9))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H9(33),ex4(:),ex3(:),G1tensor(84),m4h3x3x1(:,10),heltab3x9(:,:,10))
  call Hloop_AS_Q(ntryL,G2H9(13),wf9(:,2),G2H1(1),ngH,m3h9x1(:,55),heltab2x9(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(49),n2h1(604))
  call Hloop_QS_A(ntryL,G2H9(5),wf9(:,2),G2H1(1),ngH,m3h9x1(:,56),heltab2x9(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(50),n2h1(605))
  call Hloop_AS_Q(ntryL,G2H9(3),wf9(:,2),G2H1(1),ngH,m3h9x1(:,57),heltab2x9(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(51),n2h1(606))
  call Hloop_QS_A(ntryL,G2H9(7),wf9(:,2),G2H1(1),ngH,m3h9x1(:,58),heltab2x9(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(52),n2h1(607))
  call Hloop_AV_Q(ntryL,G2H9(2),wf9(:,1),G2H1(1),m3h9x1(:,59),heltab2x9(:,:,204))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(53),n2h1(608))
  call Hloop_QV_A(ntryL,G2H9(6),wf9(:,1),G2H1(1),m3h9x1(:,60),heltab2x9(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(54),n2h1(609))
  call Hloop_AV_Q(ntryL,G2H9(8),wf9(:,1),G2H1(1),m3h9x1(:,61),heltab2x9(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(55),n2h1(610))
  call Hloop_QV_A(ntryL,G2H9(9),wf9(:,1),G2H1(1),m3h9x1(:,62),heltab2x9(:,:,207))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(56),n2h1(611))
  call Hloop_AZ_Q(ntryL,G2H9(11),wf9(:,1),G2H1(1),ngZu,m3h9x1(:,63),heltab2x9(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(57),n2h1(612))
  call Hloop_QZ_A(ntryL,G2H9(14),wf9(:,1),G2H1(1),ngZu,m3h9x1(:,64),heltab2x9(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(58),n2h1(613))
  call Hloop_AZ_Q(ntryL,G2H9(16),wf9(:,1),G2H1(1),ngZd,m3h9x1(:,65),heltab2x9(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(59),n2h1(614))
  call Hloop_QZ_A(ntryL,G2H9(18),wf9(:,1),G2H1(1),ngZd,m3h9x1(:,66),heltab2x9(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(60),n2h1(615))
  call Hloop_VQ_A(ntryL,G1H18(45),wf18(:,5),G1H1(1),m3h18x1(:,1),heltab2x18(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(216),n2h1(616))
  call Hloop_ZQ_A(ntryL,G1H18(46),wf18(:,5),G1H1(1),ngZu,m3h18x1(:,2),heltab2x18(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(405),n2h1(617))
  call Hloop_WQ_A(ntryL,G1H18(47),wf18(:,5),G1H1(1),m3h18x1(:,3),heltab2x18(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(219),n2h1(618))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H18(1),wf18(:,5),G2tensor(411),m3h18x1(:,4),heltab2x18(:,:,181))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(143),23,ex4(:),8,G2tensor(222),m3h3x1(:,409),heltab2x3(:,:,409))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(158),23,ex4(:),8,G2tensor(417),m3h3x1(:,410),heltab2x3(:,:,410))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H6(23),wf6(:,4),G2tensor(249),ngZd,m3h6x1(:,55),heltab2x6(:,:,218))
  call Hloop_VA_Q(ntryL,G1H18(49),wf18(:,7),G1H1(1),m3h18x1(:,5),heltab2x18(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(255),n2h1(619))
  call Hloop_ZA_Q(ntryL,G1H18(50),wf18(:,7),G1H1(1),ngZu,m3h18x1(:,6),heltab2x18(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(258),n2h1(620))
  call Hloop_WA_Q(ntryL,G1H18(51),wf18(:,7),G1H1(1),m3h18x1(:,7),heltab2x18(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(261),n2h1(621))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H18(2),wf18(:,7),G2tensor(252),m3h18x1(:,8),heltab2x18(:,:,185))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(180),27,ex3(:),4,G2tensor(276),m3h3x1(:,411),heltab2x3(:,:,411))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(9),27,ex3(:),4,G2tensor(143),m3h3x1(:,412),heltab2x3(:,:,412))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(31),27,ex3(:),4,G2tensor(138),m3h3x1(:,413),heltab2x3(:,:,413))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(42),27,ex3(:),4,G2tensor(228),m3h3x1(:,414),heltab2x3(:,:,414))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(93),wf9(:,2),G1tensor(96),m3h9x1(:,67),heltab2x9(:,:,212))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(40),wf9(:,2),G1tensor(108),m3h9x1(:,68),heltab2x9(:,:,213))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H9(99),19,wf9(:,1),12,G2tensor(279),m3h9x1(:,69),heltab2x9(:,:,214))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(51),wf9(:,2),G1tensor(120),m3h9x1(:,70),heltab2x9(:,:,215))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H9(44),wf9(:,2),G1tensor(134),m3h9x1(:,71),heltab2x9(:,:,216))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H9(102),19,wf9(:,1),12,G2tensor(282),m3h9x1(:,72),heltab2x9(:,:,217))
  call Hloop_VQ_A(ntryL,G1H18(53),wf18(:,13),G1H1(1),m3h18x1(:,9),heltab2x18(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(285),n2h1(622))
  call Hloop_ZQ_A(ntryL,G1H18(54),wf18(:,13),G1H1(1),ngZu,m3h18x1(:,10),heltab2x18(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(288),n2h1(623))
  call Hloop_WQ_A(ntryL,G1H18(55),wf18(:,13),G1H1(1),m3h18x1(:,11),heltab2x18(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(234),n2h1(624))
  call Hloop_VQ_A(ntryL,G1H18(56),wf18(:,15),G1H1(1),m3h18x1(:,12),heltab2x18(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(291),n2h1(625))
  call Hloop_ZQ_A(ntryL,G1H18(57),wf18(:,15),G1H1(1),ngZu,m3h18x1(:,13),heltab2x18(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(240),n2h1(626))
  call Hloop_WQ_A(ntryL,G1H18(58),wf18(:,15),G1H1(1),m3h18x1(:,14),heltab2x18(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(294),n2h1(627))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H18(3),wf18(:,13),G2tensor(246),m3h18x1(:,15),heltab2x18(:,:,192))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H18(4),wf18(:,15),G2tensor(297),m3h18x1(:,16),heltab2x18(:,:,193))
  call Hloop_VA_Q(ntryL,G1H18(61),wf18(:,9),G1H1(1),m3h18x1(:,17),heltab2x18(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(300),n2h1(628))
  call Hloop_ZA_Q(ntryL,G1H18(62),wf18(:,9),G1H1(1),ngZu,m3h18x1(:,18),heltab2x18(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(303),n2h1(629))
  call Hloop_WA_Q(ntryL,G1H18(63),wf18(:,9),G1H1(1),m3h18x1(:,19),heltab2x18(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(306),n2h1(630))
  call Hloop_VA_Q(ntryL,G1H18(64),wf18(:,11),G1H1(1),m3h18x1(:,20),heltab2x18(:,:,197))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(309),n2h1(631))
  call Hloop_ZA_Q(ntryL,G1H18(65),wf18(:,11),G1H1(1),ngZu,m3h18x1(:,21),heltab2x18(:,:,198))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(312),n2h1(632))
  call Hloop_WA_Q(ntryL,G1H18(66),wf18(:,11),G1H1(1),m3h18x1(:,22),heltab2x18(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(315),n2h1(633))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H18(5),wf18(:,9),G2tensor(180),m3h18x1(:,23),heltab2x18(:,:,200))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H18(6),wf18(:,11),G2tensor(318),m3h18x1(:,24),heltab2x18(:,:,201))
  call Hloop_AW_Q(ntryL,G2H3(3),ex4(:),G2H1(1),m3h3x1(:,415),heltab2x3(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(61),n2h1(634))
  call Hloop_AW_Q(ntryL,G2H3(59),ex4(:),G2H1(1),m3h3x1(:,416),heltab2x3(:,:,416))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(62),n2h1(635))
  call Hloop_AW_Q(ntryL,G2H3(28),ex4(:),G2H1(1),m3h3x1(:,417),heltab2x3(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(63),n2h1(636))
  call Hloop_QW_A(ntryL,G2H3(6),ex4(:),G2H1(1),m3h3x1(:,418),heltab2x3(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(64),n2h1(637))
  call Hloop_QW_A(ntryL,G2H3(62),ex4(:),G2H1(1),m3h3x1(:,419),heltab2x3(:,:,419))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(65),n2h1(638))
  call Hloop_QW_A(ntryL,G2H3(32),ex4(:),G2H1(1),m3h3x1(:,420),heltab2x3(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(66),n2h1(639))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(75),23,ex4(:),8,G3tensor(67),m3h3x1(:,421),heltab2x3(:,:,421))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(76),23,ex4(:),8,G3tensor(68),m3h3x1(:,422),heltab2x3(:,:,422))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(77),23,ex4(:),8,G3tensor(69),m3h3x1(:,423),heltab2x3(:,:,423))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(78),23,ex4(:),8,G3tensor(70),m3h3x1(:,424),heltab2x3(:,:,424))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(79),23,ex4(:),G3tensor(71),m3h3x1(:,425),heltab2x3(:,:,425))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(80),23,ex4(:),G3tensor(72),m3h3x1(:,426),heltab2x3(:,:,426))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(81),23,ex4(:),8,G3tensor(73),m3h3x1(:,427),heltab2x3(:,:,427))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(82),23,ex4(:),8,G3tensor(74),m3h3x1(:,428),heltab2x3(:,:,428))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(6),ex4(:),G1tensor(146),m3h3x1(:,429),heltab2x3(:,:,429))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(129),ex4(:),G1tensor(164),m3h3x1(:,430),heltab2x3(:,:,430))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(173),ex4(:),G1tensor(5),m3h3x1(:,431),heltab2x3(:,:,431))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(184),ex4(:),G1tensor(41),m3h3x1(:,432),heltab2x3(:,:,432))
  call Hcheck_last_UW_V(ntryL,l_switch,G0H3(5),23,ex4(:),8,G1tensor(16),m3h3x1(:,433),heltab2x3(:,:,433))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(96),ex4(:),G1tensor(23),m3h3x1(:,434),heltab2x3(:,:,434))
  call ol_merge_tensors(G2tensor(499),[G2tensor(421),G2tensor(157),G2tensor(31),G1tensor(613),G1tensor(162),G1tensor(138) &
    ,G0tensor(606),G0tensor(81),G0tensor(76)])
  call ol_merge_tensors(G2tensor(502),[G2tensor(424),G2tensor(163),G2tensor(35),G1tensor(618),G1tensor(75),G1tensor(170) &
    ,G0tensor(611),G0tensor(91),G0tensor(86)])
  call ol_merge_tensors(G2tensor(454),[G2tensor(445),G2tensor(166),G2tensor(39),G1tensor(21),G1tensor(17),G0tensor(101) &
    ,G0tensor(96)])
  call ol_merge_tensors(G2tensor(457),[G2tensor(448),G2tensor(172),G2tensor(43),G1tensor(35),G1tensor(27),G0tensor(111) &
    ,G0tensor(106)])
  call ol_merge_tensors(G2tensor(466),[G2tensor(463),G2tensor(178),G2tensor(47),G1tensor(598),G1tensor(593),G1tensor(64) &
    ,G1tensor(58),G0tensor(591),G0tensor(586),G0tensor(121),G0tensor(116)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(460),G2tensor(451),G2tensor(184),G2tensor(51),G1tensor(77),G1tensor(70) &
    ,G1tensor(46),G0tensor(131),G0tensor(126),G0tensor(117)])
  call ol_merge_tensors(G2tensor(442),[G2tensor(433),G2tensor(190),G2tensor(55),G1tensor(94),G1tensor(118),G0tensor(141) &
    ,G0tensor(136)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(436),G2tensor(427),G2tensor(196),G2tensor(59),G1tensor(107),G1tensor(149) &
    ,G1tensor(140),G0tensor(151),G0tensor(146),G0tensor(77)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(439),G2tensor(430),G2tensor(202),G2tensor(63),G1tensor(141),G1tensor(123) &
    ,G1tensor(2),G0tensor(161),G0tensor(156),G0tensor(87)])
  call ol_merge_tensors(G2tensor(472),[G2tensor(469),G2tensor(208),G2tensor(67),G1tensor(507),G1tensor(502),G1tensor(1) &
    ,G1tensor(160),G0tensor(531),G0tensor(526),G0tensor(171),G0tensor(166)])
  call ol_merge_tensors(G2tensor(478),[G2tensor(475),G2tensor(211),G2tensor(71),G1tensor(517),G1tensor(512),G1tensor(177) &
    ,G1tensor(31),G0tensor(541),G0tensor(536),G0tensor(181),G0tensor(176)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(493),G2tensor(400),G2tensor(214),G2tensor(75),G1tensor(603),G1tensor(594) &
    ,G1tensor(187),G1tensor(182),G0tensor(596),G0tensor(587),G0tensor(191),G0tensor(186)])
  call ol_merge_tensors(G2tensor(459),[G2tensor(496),G2tensor(406),G2tensor(217),G2tensor(79),G1tensor(608),G1tensor(599) &
    ,G1tensor(197),G1tensor(192),G0tensor(601),G0tensor(592),G0tensor(201),G0tensor(196)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(412),G2tensor(250),G2tensor(220),G2tensor(95),G2tensor(83),G1tensor(222) &
    ,G1tensor(207),G1tensor(202),G0tensor(226),G0tensor(211),G0tensor(206)])
  call ol_merge_tensors(G2tensor(228),[G2tensor(418),G2tensor(256),G2tensor(223),G2tensor(99),G2tensor(87),G1tensor(227) &
    ,G1tensor(217),G1tensor(212),G0tensor(231),G0tensor(221),G0tensor(216)])
  call ol_merge_tensors(G2tensor(276),[G2tensor(409),G2tensor(232),G2tensor(226),G2tensor(89),G2tensor(88),G1tensor(61) &
    ,G1tensor(12),G1tensor(145),G0tensor(26),G0tensor(21),G0tensor(16)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(415),G2tensor(244),G2tensor(238),G2tensor(91),G2tensor(90),G1tensor(97) &
    ,G1tensor(168),G1tensor(30),G0tensor(41),G0tensor(36),G0tensor(31)])
  call ol_merge_tensors(G2tensor(66),[G2tensor(268),G2tensor(265),G2tensor(259),G2tensor(109),G2tensor(108),G2tensor(103) &
    ,G1tensor(614),G1tensor(232),G1tensor(86),G1tensor(72),G1tensor(103),G0tensor(607),G0tensor(236),G0tensor(56),G0tensor(51) &
    ,G0tensor(46)])
  call ol_merge_tensors(G2tensor(210),[G2tensor(274),G2tensor(271),G2tensor(262),G2tensor(111),G2tensor(110),G2tensor(107) &
    ,G1tensor(619),G1tensor(237),G1tensor(122),G1tensor(110),G1tensor(98),G0tensor(612),G0tensor(241),G0tensor(71),G0tensor(66) &
    ,G0tensor(61)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(12),G2tensor(278),G2tensor(266),G2tensor(229),G2tensor(227),G2tensor(2) &
    ,G1tensor(38),G1tensor(262),G1tensor(250),G1tensor(34),G1tensor(66),G1tensor(163),G0tensor(286),G0tensor(274),G0tensor(102) &
    ,G0tensor(49),G0tensor(19)])
  call ol_merge_tensors(G2tensor(318),[G2tensor(180),G2tensor(309),G2tensor(300),G2tensor(252),G2tensor(255),G2tensor(437) &
    ,G2tensor(428),G2tensor(410),G2tensor(236),G2tensor(230),G2tensor(200),G2tensor(155),G2tensor(117),G2tensor(114),G2tensor(60) &
    ,G2tensor(4),G1tensor(415),G1tensor(290),G1tensor(265),G1tensor(113),G1tensor(80),G1tensor(24),G1tensor(133),G0tensor(439) &
    ,G0tensor(314),G0tensor(289),G0tensor(154),G0tensor(54),G0tensor(24),G0tensor(14)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(277),G2tensor(7),G1tensor(443),G1tensor(438),G1tensor(247),G1tensor(11) &
    ,G1tensor(115),G0tensor(467),G0tensor(462),G0tensor(271),G0tensor(97),G0tensor(11)])
  call ol_merge_tensors(G2tensor(270),[G2tensor(260),G2tensor(199),G2tensor(197),G2tensor(10),G1tensor(412),G1tensor(235) &
    ,G1tensor(105),G1tensor(150),G0tensor(436),G0tensor(239),G0tensor(149),G0tensor(82)])
  call ol_merge_tensors(G2tensor(243),[G2tensor(15),G2tensor(380),G2tensor(317),G2tensor(137),G2tensor(123),G2tensor(13) &
    ,G1tensor(475),G1tensor(345),G1tensor(260),G1tensor(209),G1tensor(152),G1tensor(127),G0tensor(499),G0tensor(369),G0tensor(284) &
    ,G0tensor(213),G0tensor(83),G0tensor(13)])
  call ol_merge_tensors(G3tensor(3),[G3tensor(1),G2tensor(425),G2tensor(422),G2tensor(182),G2tensor(161),G1tensor(350) &
    ,G1tensor(65),G1tensor(10),G1tensor(158),G0tensor(374),G0tensor(124),G0tensor(94),G0tensor(84)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(263),G2tensor(205),G2tensor(203),G2tensor(16),G1tensor(422),G1tensor(240) &
    ,G1tensor(135),G1tensor(8),G0tensor(446),G0tensor(244),G0tensor(159),G0tensor(92)])
  call ol_merge_tensors(G2tensor(267),[G2tensor(386),G2tensor(320),G2tensor(126),G2tensor(19),G1tensor(485),G1tensor(355) &
    ,G1tensor(219),G1tensor(9),G0tensor(509),G0tensor(379),G0tensor(223),G0tensor(93)])
  call ol_merge_tensors(G3tensor(44),[G3tensor(43),G3tensor(42),G3tensor(41),G3tensor(40),G3tensor(39),G3tensor(6),G3tensor(5) &
    ,G3tensor(4),G3tensor(2),G2tensor(347),G2tensor(341),G2tensor(335),G2tensor(323),G1tensor(390),G1tensor(360),G1tensor(153) &
    ,G1tensor(173),G1tensor(131),G1tensor(125),G1tensor(52),G1tensor(22),G0tensor(414),G0tensor(384),G0tensor(163),G0tensor(153) &
    ,G0tensor(143),G0tensor(133),G0tensor(113),G0tensor(103)])
  call ol_merge_tensors(G2tensor(297),[G2tensor(246),G2tensor(291),G2tensor(285),G2tensor(411),G2tensor(216),G2tensor(455) &
    ,G2tensor(446),G2tensor(398),G2tensor(170),G2tensor(153),G2tensor(22),G1tensor(586),G1tensor(581),G1tensor(365),G1tensor(19) &
    ,G1tensor(47),G0tensor(579),G0tensor(574),G0tensor(389),G0tensor(174),G0tensor(104)])
  call ol_merge_tensors(G2tensor(456),[G2tensor(453),G2tensor(326),G2tensor(25),G1tensor(370),G1tensor(39),G0tensor(394) &
    ,G0tensor(112)])
  call ol_merge_tensors(G2tensor(240),[G2tensor(288),G2tensor(405),G2tensor(458),G2tensor(449),G2tensor(404),G2tensor(176) &
    ,G2tensor(28),G1tensor(591),G1tensor(375),G1tensor(180),G1tensor(40),G0tensor(584),G0tensor(399),G0tensor(184) &
    ,G0tensor(114)])
  call ol_merge_tensors(G2tensor(218),[G2tensor(215),G2tensor(187),G2tensor(185),G2tensor(32),G1tensor(392),G1tensor(195) &
    ,G1tensor(185),G1tensor(76),G1tensor(89),G0tensor(416),G0tensor(199),G0tensor(189),G0tensor(129),G0tensor(122)])
  call ol_merge_tensors(G2tensor(329),[G2tensor(36),G1tensor(380),G1tensor(179),G1tensor(13),G1tensor(71),G0tensor(404) &
    ,G0tensor(183),G0tensor(173),G0tensor(123)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(171),G2tensor(332),G2tensor(40),G1tensor(385),G1tensor(81),G0tensor(409) &
    ,G0tensor(132)])
  call ol_merge_tensors(G2tensor(294),[G2tensor(234),G2tensor(219),G2tensor(461),G2tensor(452),G2tensor(407),G2tensor(401) &
    ,G2tensor(188),G2tensor(44),G1tensor(395),G1tensor(200),G1tensor(190),G1tensor(83),G0tensor(419),G0tensor(204),G0tensor(194) &
    ,G0tensor(134)])
  call ol_merge_tensors(G2tensor(165),[G2tensor(420),G2tensor(338),G2tensor(48),G1tensor(400),G1tensor(137),G0tensor(424) &
    ,G0tensor(142)])
  call ol_merge_tensors(G2tensor(315),[G2tensor(306),G2tensor(261),G2tensor(443),G2tensor(434),G2tensor(419),G2tensor(413) &
    ,G2tensor(254),G2tensor(194),G2tensor(124),G2tensor(52),G1tensor(405),G1tensor(245),G1tensor(220),G1tensor(210),G1tensor(95) &
    ,G0tensor(429),G0tensor(269),G0tensor(264),G0tensor(224),G0tensor(214),G0tensor(144)])
  call ol_merge_tensors(G2tensor(162),[G2tensor(273),G2tensor(482),G2tensor(470),G2tensor(344),G2tensor(56),G1tensor(109) &
    ,G1tensor(525),G1tensor(505),G1tensor(410),G1tensor(111),G0tensor(549),G0tensor(529),G0tensor(434),G0tensor(152)])
  call ol_merge_tensors(G2tensor(423),[G2tensor(156),G2tensor(350),G2tensor(64),G1tensor(420),G1tensor(147),G0tensor(444) &
    ,G0tensor(162)])
  call ol_merge_tensors(G2tensor(312),[G2tensor(303),G2tensor(258),G2tensor(440),G2tensor(431),G2tensor(416),G2tensor(248) &
    ,G2tensor(242),G2tensor(206),G2tensor(121),G2tensor(119),G2tensor(68),G1tensor(425),G1tensor(310),G1tensor(300),G1tensor(154) &
    ,G1tensor(116),G1tensor(91),G0tensor(449),G0tensor(334),G0tensor(324),G0tensor(164),G0tensor(69),G0tensor(39)])
  call ol_merge_tensors(G2tensor(353),[G2tensor(72),G1tensor(430),G1tensor(7),G0tensor(454),G0tensor(172)])
  call ol_merge_tensors(G2tensor(356),[G2tensor(76),G1tensor(435),G1tensor(178),G0tensor(459),G0tensor(182)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(359),G2tensor(80),G1tensor(440),G1tensor(188),G0tensor(464),G0tensor(192)])
  call ol_merge_tensors(G2tensor(148),[G2tensor(8),G2tensor(362),G2tensor(84),G1tensor(580),G1tensor(445),G1tensor(189) &
    ,G0tensor(573),G0tensor(469),G0tensor(193)])
  call ol_merge_tensors(G2tensor(225),[G2tensor(365),G2tensor(92),G1tensor(450),G1tensor(198),G0tensor(474),G0tensor(202)])
  call ol_merge_tensors(G2tensor(408),[G2tensor(368),G2tensor(96),G1tensor(455),G1tensor(199),G0tensor(479),G0tensor(203)])
  call ol_merge_tensors(G2tensor(414),[G2tensor(377),G2tensor(371),G2tensor(122),G2tensor(100),G1tensor(470),G1tensor(460) &
    ,G1tensor(208),G0tensor(494),G0tensor(484),G0tensor(212)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(383),G2tensor(374),G2tensor(125),G2tensor(104),G1tensor(480),G1tensor(465) &
    ,G1tensor(218),G0tensor(504),G0tensor(489),G0tensor(222)])
  call ol_merge_tensors(G2tensor(231),[G2tensor(287),G2tensor(281),G2tensor(115),G2tensor(112),G1tensor(280),G1tensor(270) &
    ,G1tensor(55),G0tensor(304),G0tensor(294),G0tensor(22)])
  call ol_merge_tensors(G2tensor(237),[G2tensor(290),G2tensor(284),G2tensor(116),G2tensor(113),G1tensor(285),G1tensor(275) &
    ,G1tensor(42),G1tensor(14),G0tensor(309),G0tensor(299),G0tensor(38),G0tensor(23)])
  call ol_merge_tensors(G2tensor(264),[G2tensor(296),G2tensor(293),G2tensor(120),G2tensor(118),G1tensor(305),G1tensor(295) &
    ,G1tensor(48),G0tensor(329),G0tensor(319),G0tensor(37)])
  call ol_merge_tensors(G2tensor(389),[G2tensor(305),G2tensor(299),G2tensor(132),G2tensor(130),G2tensor(127),G1tensor(490) &
    ,G1tensor(325),G1tensor(315),G1tensor(74),G0tensor(514),G0tensor(349),G0tensor(339),G0tensor(52)])
  call ol_merge_tensors(G2tensor(392),[G2tensor(308),G2tensor(302),G2tensor(133),G2tensor(131),G2tensor(128),G1tensor(495) &
    ,G1tensor(330),G1tensor(320),G1tensor(114),G1tensor(78),G0tensor(519),G0tensor(354),G0tensor(344),G0tensor(68),G0tensor(53)])
  call ol_merge_tensors(G2tensor(395),[G2tensor(314),G2tensor(311),G2tensor(135),G2tensor(134),G2tensor(129),G1tensor(500) &
    ,G1tensor(340),G1tensor(335),G1tensor(69),G0tensor(524),G0tensor(364),G0tensor(359),G0tensor(67)])
  call ol_merge_tensors(G2tensor(399),[G2tensor(464),G2tensor(136),G1tensor(596),G1tensor(255),G1tensor(121),G0tensor(589) &
    ,G0tensor(279),G0tensor(12)])
  call ol_merge_tensors(G3tensor(58),[G3tensor(57),G3tensor(54),G3tensor(53),G3tensor(50),G3tensor(49),G3tensor(9),G3tensor(7) &
    ,G2tensor(512),G2tensor(506),G1tensor(636),G1tensor(626),G0tensor(629),G0tensor(619)])
  call ol_merge_tensors(G3tensor(60),[G3tensor(59),G3tensor(56),G3tensor(55),G3tensor(52),G3tensor(51),G3tensor(10),G3tensor(8) &
    ,G2tensor(515),G2tensor(509),G1tensor(641),G1tensor(631),G0tensor(634),G0tensor(624)])
  call ol_merge_tensors(G3tensor(11),[G2tensor(518),G1tensor(646),G0tensor(639)])
  call ol_merge_tensors(G3tensor(12),[G2tensor(521),G1tensor(651),G0tensor(644)])
  call ol_merge_tensors(G3tensor(32),[G3tensor(30),G2tensor(181),G2tensor(179),G2tensor(164),G2tensor(160),G2tensor(158) &
    ,G1tensor(347),G1tensor(57),G1tensor(155),G1tensor(144),G0tensor(371),G0tensor(119),G0tensor(89),G0tensor(79)])
  call ol_merge_tensors(G2tensor(209),[G2tensor(169),G2tensor(167),G1tensor(362),G1tensor(166),G1tensor(28),G0tensor(386) &
    ,G0tensor(169),G0tensor(99)])
  call ol_merge_tensors(G2tensor(212),[G2tensor(175),G2tensor(173),G1tensor(372),G1tensor(175),G1tensor(33),G0tensor(396) &
    ,G0tensor(179),G0tensor(109)])
  call ol_merge_tensors(G2tensor(224),[G2tensor(221),G2tensor(193),G2tensor(191),G1tensor(402),G1tensor(215),G1tensor(205) &
    ,G1tensor(112),G0tensor(426),G0tensor(219),G0tensor(209),G0tensor(139)])
  call ol_merge_tensors(G2tensor(269),[G2tensor(235),G2tensor(233),G1tensor(44),G1tensor(287),G1tensor(87),G1tensor(26) &
    ,G0tensor(311),G0tensor(59),G0tensor(29)])
  call ol_merge_tensors(G2tensor(272),[G2tensor(241),G2tensor(239),G1tensor(54),G1tensor(297),G1tensor(63),G1tensor(85) &
    ,G0tensor(321),G0tensor(64),G0tensor(34)])
  call ol_merge_tensors(G2tensor(275),[G2tensor(247),G2tensor(245),G1tensor(120),G1tensor(68),G1tensor(307),G1tensor(132) &
    ,G1tensor(60),G0tensor(331),G0tensor(74),G0tensor(44)])
  call ol_merge_tensors(G2tensor(282),[G2tensor(257),G2tensor(253),G2tensor(251),G1tensor(134),G1tensor(84),G1tensor(242) &
    ,G1tensor(230),G1tensor(225),G0tensor(261),G0tensor(249),G0tensor(234),G0tensor(229)])
  call ol_merge_tensors(G2tensor(432),[G2tensor(280),G1tensor(503),G1tensor(267),G1tensor(151),G0tensor(527),G0tensor(291) &
    ,G0tensor(17)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(283),G1tensor(272),G1tensor(32),G1tensor(157),G0tensor(296),G0tensor(33) &
    ,G0tensor(18)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(286),G1tensor(508),G1tensor(277),G1tensor(20),G0tensor(532),G0tensor(301) &
    ,G0tensor(27)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(289),G1tensor(282),G1tensor(174),G1tensor(67),G0tensor(306),G0tensor(43) &
    ,G0tensor(28)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(292),G1tensor(513),G1tensor(292),G1tensor(73),G0tensor(537),G0tensor(316) &
    ,G0tensor(32)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(295),G1tensor(518),G1tensor(302),G1tensor(50),G0tensor(542),G0tensor(326) &
    ,G0tensor(42)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(298),G1tensor(523),G1tensor(312),G1tensor(56),G0tensor(547),G0tensor(336) &
    ,G0tensor(47)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(301),G1tensor(317),G1tensor(104),G1tensor(62),G0tensor(341),G0tensor(63) &
    ,G0tensor(48)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(304),G1tensor(528),G1tensor(322),G1tensor(90),G0tensor(552),G0tensor(346) &
    ,G0tensor(57)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(307),G1tensor(327),G1tensor(128),G1tensor(92),G0tensor(351),G0tensor(73) &
    ,G0tensor(58)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(310),G1tensor(533),G1tensor(332),G1tensor(102),G0tensor(557),G0tensor(356) &
    ,G0tensor(62)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(313),G1tensor(538),G1tensor(337),G1tensor(126),G0tensor(562),G0tensor(361) &
    ,G0tensor(72)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(316),G1tensor(342),G1tensor(204),G1tensor(156),G0tensor(366),G0tensor(208) &
    ,G0tensor(78)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(319),G1tensor(352),G1tensor(214),G1tensor(161),G0tensor(376),G0tensor(218) &
    ,G0tensor(88)])
  call ol_merge_tensors(G3tensor(17),[G3tensor(13),G2tensor(340),G2tensor(322),G1tensor(357),G1tensor(93),G1tensor(29) &
    ,G1tensor(15),G0tensor(381),G0tensor(138),G0tensor(108),G0tensor(98)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(325),G1tensor(453),G1tensor(448),G1tensor(367),G1tensor(53),G0tensor(477) &
    ,G0tensor(472),G0tensor(391),G0tensor(107)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(328),G1tensor(377),G1tensor(43),G1tensor(172),G1tensor(51),G0tensor(401) &
    ,G0tensor(178),G0tensor(168),G0tensor(118)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(331),G1tensor(433),G1tensor(428),G1tensor(382),G1tensor(378),G1tensor(100) &
    ,G0tensor(457),G0tensor(452),G0tensor(406),G0tensor(402),G0tensor(127)])
  call ol_merge_tensors(G3tensor(19),[G3tensor(15),G2tensor(346),G2tensor(334),G1tensor(387),G1tensor(348),G1tensor(130) &
    ,G1tensor(101),G1tensor(82),G0tensor(411),G0tensor(372),G0tensor(158),G0tensor(148),G0tensor(128)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(337),G1tensor(498),G1tensor(493),G1tensor(488),G1tensor(397),G1tensor(88) &
    ,G0tensor(522),G0tensor(517),G0tensor(512),G0tensor(421),G0tensor(137)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(343),G1tensor(578),G1tensor(458),G1tensor(407),G1tensor(343),G1tensor(143) &
    ,G0tensor(571),G0tensor(482),G0tensor(431),G0tensor(367),G0tensor(147)])
  call ol_merge_tensors(G2tensor(444),[G2tensor(349),G1tensor(463),G1tensor(417),G1tensor(353),G1tensor(129),G0tensor(487) &
    ,G0tensor(441),G0tensor(377),G0tensor(157)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(352),G1tensor(427),G1tensor(165),G0tensor(451),G0tensor(167)])
  call ol_merge_tensors(G2tensor(447),[G2tensor(355),G1tensor(432),G1tensor(37),G0tensor(456),G0tensor(177)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(358),G1tensor(437),G1tensor(183),G0tensor(461),G0tensor(187)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(361),G1tensor(442),G1tensor(184),G0tensor(466),G0tensor(188)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(364),G1tensor(447),G1tensor(193),G0tensor(471),G0tensor(197)])
  call ol_merge_tensors(G2tensor(450),[G2tensor(367),G1tensor(452),G1tensor(194),G0tensor(476),G0tensor(198)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(370),G1tensor(457),G1tensor(333),G1tensor(318),G1tensor(313),G1tensor(203) &
    ,G0tensor(481),G0tensor(357),G0tensor(342),G0tensor(337),G0tensor(207)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(373),G1tensor(462),G1tensor(338),G1tensor(328),G1tensor(323),G1tensor(213) &
    ,G0tensor(486),G0tensor(362),G0tensor(352),G0tensor(347),G0tensor(217)])
  call ol_merge_tensors(G3tensor(73),[G3tensor(71),G3tensor(34),G2tensor(376),G1tensor(5),G1tensor(467),G1tensor(223) &
    ,G0tensor(491),G0tensor(227)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(379),G1tensor(615),G1tensor(472),G1tensor(224),G0tensor(608),G0tensor(496) &
    ,G0tensor(228)])
  call ol_merge_tensors(G3tensor(74),[G3tensor(72),G3tensor(68),G3tensor(35),G2tensor(382),G1tensor(41),G1tensor(477) &
    ,G1tensor(228),G0tensor(501),G0tensor(232)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(385),G1tensor(620),G1tensor(482),G1tensor(229),G0tensor(613),G0tensor(506) &
    ,G0tensor(233)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(388),G1tensor(487),G1tensor(473),G1tensor(468),G1tensor(233),G0tensor(511) &
    ,G0tensor(497),G0tensor(492),G0tensor(237)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(391),G1tensor(492),G1tensor(239),G1tensor(234),G0tensor(516),G0tensor(243) &
    ,G0tensor(238)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(394),G1tensor(497),G1tensor(483),G1tensor(478),G1tensor(238),G0tensor(521) &
    ,G0tensor(507),G0tensor(502),G0tensor(242)])
  call ol_merge_tensors(G2tensor(222),[G2tensor(484),G2tensor(481),G2tensor(397),G1tensor(583),G1tensor(527),G1tensor(522) &
    ,G0tensor(576),G0tensor(551),G0tensor(546)])
  call ol_merge_tensors(G2tensor(417),[G2tensor(490),G2tensor(487),G2tensor(403),G1tensor(588),G1tensor(537),G1tensor(532) &
    ,G0tensor(581),G0tensor(561),G0tensor(556)])
  call ol_merge_tensors(G2tensor(249),[G2tensor(467),G1tensor(601),G0tensor(594)])
  call ol_merge_tensors(G2tensor(485),[G2tensor(473),G1tensor(139),G1tensor(530),G1tensor(510),G0tensor(554),G0tensor(534)])
  call ol_merge_tensors(G2tensor(488),[G2tensor(476),G1tensor(169),G1tensor(535),G1tensor(515),G0tensor(559),G0tensor(539)])
  call ol_merge_tensors(G2tensor(491),[G2tensor(479),G1tensor(96),G1tensor(18),G1tensor(540),G1tensor(520),G0tensor(564) &
    ,G0tensor(544)])
  call ol_merge_tensors(G2tensor(279),[G2tensor(497),G2tensor(494),G1tensor(108),G1tensor(36),G1tensor(611),G1tensor(606) &
    ,G0tensor(604),G0tensor(599),G0tensor(569)])
  call ol_merge_tensors(G2tensor(503),[G2tensor(500),G1tensor(621),G1tensor(616),G0tensor(614),G0tensor(609)])
  call ol_merge_tensors(G3tensor(22),[G2tensor(505),G1tensor(649),G1tensor(623),G0tensor(642),G0tensor(616)])
  call ol_merge_tensors(G3tensor(24),[G2tensor(508),G1tensor(644),G1tensor(628),G0tensor(637),G0tensor(621)])
  call ol_merge_tensors(G3tensor(26),[G2tensor(511),G1tensor(633),G0tensor(626)])
  call ol_merge_tensors(G3tensor(28),[G2tensor(514),G1tensor(638),G0tensor(631)])
  call ol_merge_tensors(G3tensor(31),[G2tensor(517),G1tensor(643),G0tensor(636)])
  call ol_merge_tensors(G3tensor(33),[G2tensor(520),G1tensor(648),G0tensor(641)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(479),G1tensor(469),G1tensor(243),G0tensor(503),G0tensor(493),G0tensor(262) &
    ,G0tensor(253)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(484),G1tensor(474),G1tensor(244),G0tensor(508),G0tensor(498),G0tensor(263) &
    ,G0tensor(258)])
  call ol_merge_tensors(G3tensor(37),[G3tensor(21),G1tensor(398),G1tensor(368),G1tensor(358),G1tensor(252),G1tensor(248) &
    ,G0tensor(422),G0tensor(392),G0tensor(382),G0tensor(276),G0tensor(272)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(429),G1tensor(363),G1tensor(257),G1tensor(249),G0tensor(453),G0tensor(387) &
    ,G0tensor(281),G0tensor(273)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(258),G1tensor(253),G0tensor(282),G0tensor(277)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(3),G1tensor(314),G1tensor(269),G1tensor(263),G1tensor(254),G0tensor(338) &
    ,G0tensor(293),G0tensor(287),G0tensor(278)])
  call ol_merge_tensors(G2tensor(426),[G2tensor(5),G1tensor(319),G1tensor(299),G1tensor(274),G1tensor(264),G1tensor(259) &
    ,G0tensor(343),G0tensor(323),G0tensor(298),G0tensor(288),G0tensor(283)])
  call ol_merge_tensors(G2tensor(159),[G1tensor(293),G1tensor(273),G1tensor(268),G0tensor(317),G0tensor(297),G0tensor(292)])
  call ol_merge_tensors(G2tensor(321),[G1tensor(303),G1tensor(283),G1tensor(278),G0tensor(327),G0tensor(307),G0tensor(302)])
  call ol_merge_tensors(G2tensor(429),[G1tensor(324),G1tensor(288),G1tensor(279),G0tensor(348),G0tensor(312),G0tensor(303)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(329),G1tensor(309),G1tensor(289),G1tensor(284),G0tensor(353),G0tensor(333) &
    ,G0tensor(313),G0tensor(308)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(334),G1tensor(298),G1tensor(294),G0tensor(358),G0tensor(322),G0tensor(318)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(339),G1tensor(308),G1tensor(304),G0tensor(363),G0tensor(332),G0tensor(328)])
  call ol_merge_tensors(G3tensor(18),[G3tensor(14),G1tensor(404),G1tensor(379),G1tensor(374),G1tensor(364),G1tensor(359) &
    ,G1tensor(354),G1tensor(349),G1tensor(344),G0tensor(428),G0tensor(403),G0tensor(398),G0tensor(388),G0tensor(383),G0tensor(378) &
    ,G0tensor(373),G0tensor(368)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(434),G1tensor(373),G1tensor(369),G0tensor(458),G0tensor(397),G0tensor(393)])
  call ol_merge_tensors(G3tensor(38),[G3tensor(36),G1tensor(418),G1tensor(408),G1tensor(388),G1tensor(383),G0tensor(442) &
    ,G0tensor(432),G0tensor(412),G0tensor(407)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(449),G1tensor(439),G1tensor(393),G1tensor(384),G0tensor(473),G0tensor(463) &
    ,G0tensor(417),G0tensor(408)])
  call ol_merge_tensors(G3tensor(20),[G3tensor(16),G1tensor(494),G1tensor(454),G1tensor(444),G1tensor(424),G1tensor(414) &
    ,G1tensor(394),G1tensor(389),G0tensor(518),G0tensor(478),G0tensor(468),G0tensor(448),G0tensor(438),G0tensor(418) &
    ,G0tensor(413)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(464),G1tensor(459),G1tensor(403),G1tensor(399),G0tensor(488),G0tensor(483) &
    ,G0tensor(427),G0tensor(423)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(489),G1tensor(413),G1tensor(409),G0tensor(513),G0tensor(437),G0tensor(433)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(499),G1tensor(423),G1tensor(419),G0tensor(523),G0tensor(447),G0tensor(443)])
  call ol_merge_tensors(G2tensor(183),[G1tensor(595),G1tensor(514),G1tensor(504),G0tensor(588),G0tensor(538),G0tensor(528)])
  call ol_merge_tensors(G2tensor(189),[G1tensor(600),G1tensor(519),G1tensor(509),G0tensor(593),G0tensor(543),G0tensor(533)])
  call ol_merge_tensors(G2tensor(441),[G1tensor(534),G1tensor(524),G0tensor(558),G0tensor(548)])
  call ol_merge_tensors(G2tensor(195),[G1tensor(539),G1tensor(529),G0tensor(563),G0tensor(553)])
  call ol_merge_tensors(G1tensor(568),[G1tensor(544)])
  call ol_merge_tensors(G1tensor(549),[G1tensor(545)])
  call ol_merge_tensors(G1tensor(567),[G1tensor(546)])
  call ol_merge_tensors(G1tensor(575),[G1tensor(550)])
  call ol_merge_tensors(G1tensor(561),[G1tensor(553)])
  call ol_merge_tensors(G1tensor(571),[G1tensor(554)])
  call ol_merge_tensors(G1tensor(565),[G1tensor(557)])
  call ol_merge_tensors(G1tensor(572),[G1tensor(560)])
  call ol_merge_tensors(G1tensor(576),[G1tensor(564)])
  call ol_merge_tensors(G2tensor(213),[G1tensor(579),G0tensor(572)])
  call ol_merge_tensors(G2tensor(333),[G1tensor(584),G0tensor(577)])
  call ol_merge_tensors(G2tensor(139),[G1tensor(590),G1tensor(585),G0tensor(583),G0tensor(578)])
  call ol_merge_tensors(G2tensor(154),[G1tensor(589),G0tensor(582)])
  call ol_merge_tensors(G2tensor(435),[G1tensor(604),G0tensor(597)])
  call ol_merge_tensors(G2tensor(201),[G1tensor(605),G0tensor(598)])
  call ol_merge_tensors(G2tensor(438),[G1tensor(609),G0tensor(602)])
  call ol_merge_tensors(G2tensor(207),[G1tensor(610),G0tensor(603)])
  call ol_merge_tensors(G3tensor(45),[G1tensor(624),G0tensor(617)])
  call ol_merge_tensors(G3tensor(23),[G1tensor(625),G0tensor(618)])
  call ol_merge_tensors(G3tensor(46),[G1tensor(629),G0tensor(622)])
  call ol_merge_tensors(G3tensor(25),[G1tensor(630),G0tensor(623)])
  call ol_merge_tensors(G3tensor(47),[G1tensor(634),G0tensor(627)])
  call ol_merge_tensors(G3tensor(27),[G1tensor(645),G1tensor(635),G0tensor(638),G0tensor(628)])
  call ol_merge_tensors(G3tensor(48),[G1tensor(639),G0tensor(632)])
  call ol_merge_tensors(G3tensor(29),[G1tensor(650),G1tensor(640),G0tensor(643),G0tensor(633)])
  call ol_merge_tensors(G0tensor(266),[G0tensor(246)])
  call ol_merge_tensors(G3tensor(67),[G1tensor(146),G0tensor(251),G0tensor(247)])
  call ol_merge_tensors(G0tensor(256),[G0tensor(248)])
  call ol_merge_tensors(G0tensor(257),[G0tensor(252)])
  call ol_merge_tensors(G0tensor(267),[G0tensor(254)])
  call ol_merge_tensors(G0tensor(268),[G0tensor(259)])
  call ol_merge_tensors(G3tensor(69),[G1tensor(16),G1tensor(164)])
  call ol_merge_tensors(G3tensor(70),[G1tensor(23)])
  call TI_triangle_red(G2tensor(499),RedBasis(64),mass3set(:,1),G0tensor(10),G0tensor(15),G0tensor(20),G0tensor(25),M2L1R1)
  call TI_triangle_red(G2tensor(502),RedBasis(64),mass3set(:,2),G0tensor(30),G0tensor(35),G0tensor(40),G0tensor(45),M2L1R1,[nMZ], &
    G0tensor(50))
  call TI_triangle_red(G2tensor(454),RedBasis(62),mass3set(:,1),G0tensor(55),G0tensor(60),G0tensor(65),G0tensor(70),M2L1R1)
  call TI_triangle_red(G2tensor(457),RedBasis(62),mass3set(:,3),G0tensor(75),G0tensor(80),G0tensor(85),G0tensor(90),M2L1R1,[nMZ], &
    G0tensor(95))
  call TI_triangle_red(G2tensor(466),RedBasis(33),mass3set(:,4),G0tensor(100),G0tensor(105),G0tensor(110), &
    G0tensor(115),M2L1R1,[nMW],G0tensor(120))
  call TI_triangle_red(G2tensor(24),RedBasis(62),mass3set(:,5),G0tensor(125),G0tensor(130),G0tensor(135), &
    G0tensor(140),M2L1R1,[nMW],G0tensor(145))
  call TI_triangle_red(G2tensor(442),RedBasis(58),mass3set(:,5),G0tensor(150),G0tensor(155),G0tensor(160), &
    G0tensor(165),M2L1R1,[nMW],G0tensor(170))
  call TI_triangle_red(G2tensor(17),RedBasis(58),mass3set(:,1),G0tensor(175),G0tensor(180),G0tensor(185),G0tensor(190),M2L1R1)
  call TI_triangle_red(G2tensor(18),RedBasis(58),mass3set(:,3),G0tensor(195),G0tensor(200),G0tensor(205), &
    G0tensor(210),M2L1R1,[nMZ],G0tensor(215))
  call TI_triangle_red(G2tensor(472),RedBasis(32),mass3set(:,4),G0tensor(220),G0tensor(225),G0tensor(230), &
    G0tensor(235),M2L1R1,[nMW],G0tensor(240))
  call TI_triangle_red(G2tensor(478),RedBasis(32),mass3set(:,6),G0tensor(245),G0tensor(250),G0tensor(255), &
    G0tensor(260),M2L1R1,[nMW,nMZ],G0tensor(265),G0tensor(270))
  call TI_triangle_red(G2tensor(46),RedBasis(11),mass3set(:,5),G0tensor(275),G0tensor(280),G0tensor(285), &
    G0tensor(290),M2L1R1,[nMW],G0tensor(295))
  call TI_triangle_red(G2tensor(459),RedBasis(11),mass3set(:,7),G0tensor(300),G0tensor(305),G0tensor(310), &
    G0tensor(315),M2L1R1,[nMZ,nMW],G0tensor(320),G0tensor(325))
  call TI_triangle_red(G2tensor(143),RedBasis(29),mass3set(:,5),G0tensor(330),G0tensor(335),G0tensor(340), &
    G0tensor(345),M2L1R1,[nMW],G0tensor(350))
  call TI_triangle_red(G2tensor(228),RedBasis(29),mass3set(:,7),G0tensor(355),G0tensor(360),G0tensor(365), &
    G0tensor(370),M2L1R1,[nMZ,nMW],G0tensor(375),G0tensor(380))
  call TI_triangle_red(G2tensor(276),RedBasis(29),mass3set(:,4),G0tensor(385),G0tensor(390),G0tensor(395), &
    G0tensor(400),M2L1R1,[nMW],G0tensor(405))
  call TI_triangle_red(G2tensor(138),RedBasis(29),mass3set(:,6),G0tensor(410),G0tensor(415),G0tensor(420), &
    G0tensor(425),M2L1R1,[nMW,nMZ],G0tensor(430),G0tensor(435))
  call TI_triangle_red(G2tensor(66),RedBasis(19),mass3set(:,4),G0tensor(440),G0tensor(445),G0tensor(450), &
    G0tensor(455),M2L1R1,[nMW],G0tensor(460))
  call TI_triangle_red(G2tensor(210),RedBasis(19),mass3set(:,6),G0tensor(465),G0tensor(470),G0tensor(475), &
    G0tensor(480),M2L1R1,[nMW,nMZ],G0tensor(485),G0tensor(490))
  call TI_triangle_red(G2tensor(14),RedBasis(14),mass3set(:,1),G0tensor(495),G0tensor(500),G0tensor(505),G0tensor(510),M2L1R1)
  call TI_triangle_red(G2tensor(318),RedBasis(1),mass3set(:,1),G0tensor(515),G0tensor(520),G0tensor(525),G0tensor(530),M2L1R1)
  call TI_triangle_red(G2tensor(11),RedBasis(29),mass3set(:,1),G0tensor(535),G0tensor(540),G0tensor(545),G0tensor(550),M2L1R1)
  call TI_triangle_red(G2tensor(270),RedBasis(9),mass3set(:,1),G0tensor(555),G0tensor(560),G0tensor(565),G0tensor(1),M2L1R1)
  call TI_triangle_red(G2tensor(243),RedBasis(2),mass3set(:,1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5),M2L1R1)
  call TI_triangle_red(G3tensor(3),RedBasis(7),mass3set(:,1),G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),M2L1R1)
  call TI_triangle_red(G2tensor(106),RedBasis(9),mass3set(:,3),G0tensor(570),G0tensor(575),G0tensor(580), &
    G0tensor(585),M2L1R1,[nMZ],G0tensor(590))
  call TI_triangle_red(G2tensor(267),RedBasis(2),mass3set(:,3),G0tensor(595),G0tensor(600),G0tensor(605), &
    G0tensor(610),M2L1R1,[nMZ],G0tensor(615))
  call TI_triangle_red(G3tensor(44),RedBasis(13),mass3set(:,1),G0tensor(620),G0tensor(625),G0tensor(630),G0tensor(635),M2L1R1)
  call TI_triangle_red(G2tensor(297),RedBasis(12),mass3set(:,1),G0tensor(640),G0tensor(606),G0tensor(81),G0tensor(76),M2L1R1)
  call TI_triangle_red(G2tensor(456),RedBasis(14),mass3set(:,8),G0tensor(611),G0tensor(91),G0tensor(86), &
    G0tensor(101),M2L1R1,[nMZ],G0tensor(96))
  call TI_triangle_red(G2tensor(240),RedBasis(12),mass3set(:,3),G0tensor(111),G0tensor(106),G0tensor(591), &
    G0tensor(586),M2L1R1,[nMZ],G0tensor(121))
  call TI_triangle_red(G2tensor(218),RedBasis(18),mass3set(:,5),G0tensor(116),G0tensor(131),G0tensor(126), &
    G0tensor(117),M2L1R1,[nMW],G0tensor(141))
  call TI_triangle_red(G2tensor(329),RedBasis(17),mass3set(:,5),G0tensor(136),G0tensor(151),G0tensor(146), &
    G0tensor(77),M2L1R1,[nMW],G0tensor(161))
  call TI_triangle_red(G2tensor(177),RedBasis(14),mass3set(:,9),G0tensor(156),G0tensor(87),G0tensor(531), &
    G0tensor(526),M2L1R1,[nMW],G0tensor(171))
  call TI_triangle_red(G2tensor(294),RedBasis(12),mass3set(:,5),G0tensor(166),G0tensor(541),G0tensor(536), &
    G0tensor(181),M2L1R1,[nMW],G0tensor(176))
  call TI_triangle_red(G2tensor(165),RedBasis(23),mass3set(:,9),G0tensor(596),G0tensor(587),G0tensor(191), &
    G0tensor(186),M2L1R1,[nMW],G0tensor(601))
  call TI_triangle_red(G2tensor(315),RedBasis(1),mass3set(:,5),G0tensor(592),G0tensor(201),G0tensor(196), &
    G0tensor(226),M2L1R1,[nMW],G0tensor(211))
  call TI_triangle_red(G2tensor(162),RedBasis(23),mass3set(:,1),G0tensor(206),G0tensor(231),G0tensor(221),G0tensor(216),M2L1R1)
  call TI_triangle_red(G2tensor(423),RedBasis(23),mass3set(:,8),G0tensor(26),G0tensor(21),G0tensor(16),G0tensor(41),M2L1R1,[nMZ], &
    G0tensor(36))
  call TI_triangle_red(G2tensor(312),RedBasis(1),mass3set(:,3),G0tensor(31),G0tensor(607),G0tensor(236),G0tensor(56),M2L1R1,[nMZ], &
    G0tensor(51))
  call TI_triangle_red(G2tensor(353),RedBasis(26),mass3set(:,5),G0tensor(46),G0tensor(612),G0tensor(241), &
    G0tensor(71),M2L1R1,[nMW],G0tensor(66))
  call TI_triangle_red(G2tensor(356),RedBasis(26),mass3set(:,10),G0tensor(61),G0tensor(286),G0tensor(274), &
    G0tensor(102),M2L1R1,[nMZ,nMW],G0tensor(49),G0tensor(19))
  call TI_triangle_red(G2tensor(140),RedBasis(28),mass3set(:,9),G0tensor(439),G0tensor(314),G0tensor(289), &
    G0tensor(154),M2L1R1,[nMW],G0tensor(54))
  call TI_triangle_red(G2tensor(148),RedBasis(27),mass3set(:,1),G0tensor(24),G0tensor(14),G0tensor(467),G0tensor(462),M2L1R1)
  call TI_triangle_red(G2tensor(225),RedBasis(28),mass3set(:,11),G0tensor(271),G0tensor(97),G0tensor(11), &
    G0tensor(436),M2L1R1,[nMW,nMZ],G0tensor(239),G0tensor(149))
  call TI_triangle_red(G2tensor(408),RedBasis(27),mass3set(:,3),G0tensor(82),G0tensor(499),G0tensor(369), &
    G0tensor(284),M2L1R1,[nMZ],G0tensor(213))
  call TI_triangle_red(G2tensor(414),RedBasis(4),mass3set(:,9),G0tensor(83),G0tensor(13),G0tensor(374),G0tensor(124),M2L1R1,[nMW], &
    G0tensor(94))
  call TI_triangle_red(G2tensor(102),RedBasis(4),mass3set(:,11),G0tensor(84),G0tensor(446),G0tensor(244), &
    G0tensor(159),M2L1R1,[nMW,nMZ],G0tensor(92),G0tensor(509))
  call TI_triangle_red(G2tensor(231),RedBasis(4),mass3set(:,5),G0tensor(379),G0tensor(223),G0tensor(93), &
    G0tensor(414),M2L1R1,[nMW],G0tensor(384))
  call TI_triangle_red(G2tensor(237),RedBasis(2),mass3set(:,5),G0tensor(163),G0tensor(153),G0tensor(143), &
    G0tensor(133),M2L1R1,[nMW],G0tensor(113))
  call TI_triangle_red(G2tensor(264),RedBasis(4),mass3set(:,10),G0tensor(103),G0tensor(579),G0tensor(574), &
    G0tensor(389),M2L1R1,[nMZ,nMW],G0tensor(174),G0tensor(104))
  call TI_triangle_red(G2tensor(389),RedBasis(31),mass3set(:,5),G0tensor(394),G0tensor(112),G0tensor(584), &
    G0tensor(399),M2L1R1,[nMW],G0tensor(184))
  call TI_triangle_red(G2tensor(392),RedBasis(30),mass3set(:,5),G0tensor(114),G0tensor(416),G0tensor(199), &
    G0tensor(189),M2L1R1,[nMW],G0tensor(129))
  call TI_triangle_red(G2tensor(395),RedBasis(31),mass3set(:,10),G0tensor(122),G0tensor(404),G0tensor(183), &
    G0tensor(173),M2L1R1,[nMZ,nMW],G0tensor(123),G0tensor(409))
  call TI_triangle_red(G2tensor(399),RedBasis(4),mass3set(:,1),G0tensor(132),G0tensor(419),G0tensor(204),G0tensor(194),M2L1R1)
  call TI_triangle_red(G3tensor(58),RedBasis(13),mass3set(:,12),G0tensor(134),G0tensor(424),G0tensor(142), &
    G0tensor(429),M2L1R1,[nMT],G0tensor(269))
  call TI_triangle_red(G3tensor(60),RedBasis(13),mass3set(:,13),G0tensor(264),G0tensor(224),G0tensor(214), &
    G0tensor(144),M2L1R1,[nMB],G0tensor(549))
  call TI_triangle_red(G3tensor(11),RedBasis(7),mass3set(:,14),G0tensor(529),G0tensor(434),G0tensor(152), &
    G0tensor(444),M2L1R1,[nMT,nMB],G0tensor(162),G0tensor(449))
  call TI_triangle_red(G3tensor(12),RedBasis(7),mass3set(:,15),G0tensor(334),G0tensor(324),G0tensor(164), &
    G0tensor(69),M2L1R1,[nMB,nMT],G0tensor(39),G0tensor(454))
  call TI_triangle_red(G3tensor(32),RedBasis(56),mass3set(:,1),G0tensor(172),G0tensor(459),G0tensor(182),G0tensor(464),M2L1R1)
  call TI_triangle_red(G2tensor(209),RedBasis(59),mass3set(:,1),G0tensor(192),G0tensor(573),G0tensor(469),G0tensor(193),M2L1R1)
  call TI_triangle_red(G2tensor(212),RedBasis(59),mass3set(:,3),G0tensor(474),G0tensor(202),G0tensor(479), &
    G0tensor(203),M2L1R1,[nMZ],G0tensor(494))
  call TI_triangle_red(G2tensor(224),RedBasis(63),mass3set(:,5),G0tensor(484),G0tensor(212),G0tensor(504), &
    G0tensor(489),M2L1R1,[nMW],G0tensor(222))
  call TI_triangle_red(G2tensor(269),RedBasis(14),mass3set(:,2),G0tensor(304),G0tensor(294),G0tensor(22), &
    G0tensor(309),M2L1R1,[nMZ],G0tensor(299))
  call TI_triangle_red(G2tensor(272),RedBasis(14),mass3set(:,3),G0tensor(38),G0tensor(23),G0tensor(329), &
    G0tensor(319),M2L1R1,[nMZ],G0tensor(37))
  call TI_triangle_red(G2tensor(275),RedBasis(14),mass3set(:,16),G0tensor(514),G0tensor(349),G0tensor(339), &
    G0tensor(52),M2L1R1,[nMZ],G0tensor(519))
  call TI_triangle_red(G2tensor(282),RedBasis(14),mass3set(:,17),G0tensor(354),G0tensor(344),G0tensor(68), &
    G0tensor(53),M2L1R1,[nMW],G0tensor(524))
  call TI_triangle_red(G2tensor(432),RedBasis(16),mass3set(:,5),G0tensor(364),G0tensor(359),G0tensor(67), &
    G0tensor(589),M2L1R1,[nMW],G0tensor(279))
  call TI_triangle_red(G2tensor(54),RedBasis(15),mass3set(:,5),G0tensor(12),G0tensor(629),G0tensor(619), &
    G0tensor(634),M2L1R1,[nMW],G0tensor(624))
  call TI_triangle_red(G2tensor(58),RedBasis(16),mass3set(:,7),G0tensor(639),G0tensor(644),G0tensor(371), &
    G0tensor(119),M2L1R1,[nMZ,nMW],G0tensor(89),G0tensor(79))
  call TI_triangle_red(G2tensor(61),RedBasis(15),mass3set(:,7),G0tensor(386),G0tensor(169),G0tensor(99), &
    G0tensor(396),M2L1R1,[nMZ,nMW],G0tensor(179),G0tensor(109))
  call TI_triangle_red(G2tensor(65),RedBasis(16),mass3set(:,10),G0tensor(426),G0tensor(219),G0tensor(209), &
    G0tensor(139),M2L1R1,[nMZ,nMW],G0tensor(311),G0tensor(59))
  call TI_triangle_red(G2tensor(73),RedBasis(16),mass3set(:,18),G0tensor(29),G0tensor(321),G0tensor(64), &
    G0tensor(34),M2L1R1,[nMZ,nMW],G0tensor(331),G0tensor(74))
  call TI_triangle_red(G2tensor(86),RedBasis(22),mass3set(:,5),G0tensor(44),G0tensor(261),G0tensor(249), &
    G0tensor(234),M2L1R1,[nMW],G0tensor(229))
  call TI_triangle_red(G2tensor(93),RedBasis(21),mass3set(:,5),G0tensor(527),G0tensor(291),G0tensor(17), &
    G0tensor(296),M2L1R1,[nMW],G0tensor(33))
  call TI_triangle_red(G2tensor(97),RedBasis(22),mass3set(:,7),G0tensor(18),G0tensor(532),G0tensor(301), &
    G0tensor(27),M2L1R1,[nMZ,nMW],G0tensor(306),G0tensor(43))
  call TI_triangle_red(G2tensor(101),RedBasis(21),mass3set(:,7),G0tensor(28),G0tensor(537),G0tensor(316), &
    G0tensor(32),M2L1R1,[nMZ,nMW],G0tensor(542),G0tensor(326))
  call TI_triangle_red(G2tensor(105),RedBasis(22),mass3set(:,10),G0tensor(42),G0tensor(547),G0tensor(336), &
    G0tensor(47),M2L1R1,[nMZ,nMW],G0tensor(341),G0tensor(63))
  call TI_triangle_red(G2tensor(1),RedBasis(22),mass3set(:,18),G0tensor(48),G0tensor(552),G0tensor(346), &
    G0tensor(57),M2L1R1,[nMZ,nMW],G0tensor(351),G0tensor(73))
  call TI_triangle_red(G2tensor(21),RedBasis(57),mass3set(:,1),G0tensor(58),G0tensor(557),G0tensor(356),G0tensor(62),M2L1R1)
  call TI_triangle_red(G2tensor(20),RedBasis(57),mass3set(:,3),G0tensor(562),G0tensor(361),G0tensor(72), &
    G0tensor(366),M2L1R1,[nMZ],G0tensor(208))
  call TI_triangle_red(G3tensor(17),RedBasis(60),mass3set(:,1),G0tensor(78),G0tensor(376),G0tensor(218),G0tensor(88),M2L1R1)
  call TI_triangle_red(G2tensor(23),RedBasis(29),mass3set(:,8),G0tensor(381),G0tensor(138),G0tensor(108), &
    G0tensor(98),M2L1R1,[nMZ],G0tensor(477))
  call TI_triangle_red(G2tensor(26),RedBasis(61),mass3set(:,5),G0tensor(472),G0tensor(391),G0tensor(107), &
    G0tensor(401),M2L1R1,[nMW],G0tensor(178))
  call TI_triangle_red(G2tensor(29),RedBasis(19),mass3set(:,9),G0tensor(168),G0tensor(118),G0tensor(457), &
    G0tensor(452),M2L1R1,[nMW],G0tensor(406))
  call TI_triangle_red(G3tensor(19),RedBasis(10),mass3set(:,1),G0tensor(402),G0tensor(127),G0tensor(411),G0tensor(372),M2L1R1)
  call TI_triangle_red(G2tensor(33),RedBasis(32),mass3set(:,9),G0tensor(158),G0tensor(148),G0tensor(128), &
    G0tensor(522),M2L1R1,[nMW],G0tensor(517))
  call TI_triangle_red(G2tensor(6),RedBasis(11),mass3set(:,1),G0tensor(512),G0tensor(421),G0tensor(137),G0tensor(571),M2L1R1)
  call TI_triangle_red(G2tensor(444),RedBasis(11),mass3set(:,8),G0tensor(482),G0tensor(431),G0tensor(367), &
    G0tensor(147),M2L1R1,[nMZ],G0tensor(487))
  call TI_triangle_red(G2tensor(41),RedBasis(64),mass3set(:,5),G0tensor(441),G0tensor(377),G0tensor(157), &
    G0tensor(451),M2L1R1,[nMW],G0tensor(167))
  call TI_triangle_red(G2tensor(447),RedBasis(64),mass3set(:,10),G0tensor(456),G0tensor(177),G0tensor(461), &
    G0tensor(187),M2L1R1,[nMZ,nMW],G0tensor(466),G0tensor(188))
  call TI_triangle_red(G2tensor(42),RedBasis(66),mass3set(:,9),G0tensor(471),G0tensor(197),G0tensor(476), &
    G0tensor(198),M2L1R1,[nMW],G0tensor(481))
  call TI_triangle_red(G2tensor(45),RedBasis(65),mass3set(:,1),G0tensor(357),G0tensor(342),G0tensor(337),G0tensor(207),M2L1R1)
  call TI_triangle_red(G2tensor(49),RedBasis(66),mass3set(:,11),G0tensor(486),G0tensor(362),G0tensor(352), &
    G0tensor(347),M2L1R1,[nMW,nMZ],G0tensor(217),G0tensor(491))
  call TI_triangle_red(G2tensor(450),RedBasis(65),mass3set(:,3),G0tensor(227),G0tensor(608),G0tensor(496), &
    G0tensor(228),M2L1R1,[nMZ],G0tensor(501))
  call TI_triangle_red(G2tensor(50),RedBasis(33),mass3set(:,9),G0tensor(232),G0tensor(613),G0tensor(506), &
    G0tensor(233),M2L1R1,[nMW],G0tensor(511))
  call TI_triangle_red(G2tensor(53),RedBasis(33),mass3set(:,11),G0tensor(497),G0tensor(492),G0tensor(237), &
    G0tensor(516),M2L1R1,[nMW,nMZ],G0tensor(243),G0tensor(238))
  call TI_triangle_red(G3tensor(73),RedBasis(16),mass3set(:,19),G0tensor(521),G0tensor(507),G0tensor(502), &
    G0tensor(242),M2L1R1,[nMW],G0tensor(576))
  call TI_triangle_red(G2tensor(77),RedBasis(15),mass3set(:,4),G0tensor(551),G0tensor(546),G0tensor(581), &
    G0tensor(561),M2L1R1,[nMW],G0tensor(556))
  call TI_triangle_red(G3tensor(74),RedBasis(16),mass3set(:,20),G0tensor(594),G0tensor(554),G0tensor(534), &
    G0tensor(559),M2L1R1,[nMW,nMZ],G0tensor(539),G0tensor(564))
  call TI_triangle_red(G2tensor(94),RedBasis(15),mass3set(:,6),G0tensor(544),G0tensor(604),G0tensor(599), &
    G0tensor(569),M2L1R1,[nMW,nMZ],G0tensor(614),G0tensor(609))
  call TI_triangle_red(G2tensor(82),RedBasis(6),mass3set(:,5),G0tensor(642),G0tensor(616),G0tensor(637), &
    G0tensor(621),M2L1R1,[nMW],G0tensor(626))
  call TI_triangle_red(G2tensor(85),RedBasis(67),mass3set(:,5),G0tensor(631),G0tensor(636),G0tensor(641), &
    G0tensor(503),M2L1R1,[nMW],G0tensor(493))
  call TI_triangle_red(G2tensor(98),RedBasis(6),mass3set(:,10),G0tensor(262),G0tensor(253),G0tensor(508), &
    G0tensor(498),M2L1R1,[nMZ,nMW],G0tensor(263),G0tensor(258))
  call TI_triangle_red(G2tensor(222),RedBasis(11),mass3set(:,4),G0tensor(422),G0tensor(392),G0tensor(382), &
    G0tensor(276),M2L1R1,[nMW],G0tensor(272))
  call TI_triangle_red(G2tensor(417),RedBasis(11),mass3set(:,6),G0tensor(453),G0tensor(387),G0tensor(281), &
    G0tensor(273),M2L1R1,[nMW,nMZ],G0tensor(282),G0tensor(277))
  call TI_triangle_red(G2tensor(249),RedBasis(4),mass3set(:,2),G0tensor(338),G0tensor(293),G0tensor(287), &
    G0tensor(278),M2L1R1,[nMZ],G0tensor(343))
  call TI_triangle_red(G2tensor(485),RedBasis(23),mass3set(:,2),G0tensor(323),G0tensor(298),G0tensor(288), &
    G0tensor(283),M2L1R1,[nMZ],G0tensor(317))
  call TI_triangle_red(G2tensor(488),RedBasis(23),mass3set(:,3),G0tensor(297),G0tensor(292),G0tensor(327), &
    G0tensor(307),M2L1R1,[nMZ],G0tensor(302))
  call TI_triangle_red(G2tensor(491),RedBasis(23),mass3set(:,16),G0tensor(348),G0tensor(312),G0tensor(303), &
    G0tensor(353),M2L1R1,[nMZ],G0tensor(333))
  call TI_triangle_red(G2tensor(279),RedBasis(23),mass3set(:,17),G0tensor(313),G0tensor(308),G0tensor(358), &
    G0tensor(322),M2L1R1,[nMW],G0tensor(318))
  call TI_triangle_red(G2tensor(503),RedBasis(26),mass3set(:,4),G0tensor(363),G0tensor(332),G0tensor(328), &
    G0tensor(428),M2L1R1,[nMW],G0tensor(403))
  call TI_triangle_red(G3tensor(22),RedBasis(10),mass3set(:,21),G0tensor(398),G0tensor(388),G0tensor(383), &
    G0tensor(378),M2L1R1,[nMB,nMT],G0tensor(373),G0tensor(368))
  call TI_triangle_red(G3tensor(24),RedBasis(10),mass3set(:,22),G0tensor(458),G0tensor(397),G0tensor(393), &
    G0tensor(442),M2L1R1,[nMT,nMB],G0tensor(432),G0tensor(412))
  call TI_triangle_red(G3tensor(26),RedBasis(60),mass3set(:,21),G0tensor(407),G0tensor(473),G0tensor(463), &
    G0tensor(417),M2L1R1,[nMB,nMT],G0tensor(408),G0tensor(518))
  call TI_triangle_red(G3tensor(28),RedBasis(60),mass3set(:,22),G0tensor(478),G0tensor(468),G0tensor(448), &
    G0tensor(438),M2L1R1,[nMT,nMB],G0tensor(418),G0tensor(413))
  call TI_triangle_red(G3tensor(31),RedBasis(56),mass3set(:,23),G0tensor(488),G0tensor(483),G0tensor(427), &
    G0tensor(423),M2L1R1,[nMB,nMT],G0tensor(513),G0tensor(437))
  call TI_triangle_red(G3tensor(33),RedBasis(56),mass3set(:,24),G0tensor(433),G0tensor(523),G0tensor(447), &
    G0tensor(443),M2L1R1,[nMT,nMB],G0tensor(588),G0tensor(538))
  call TI_triangle_red(G2tensor(78),RedBasis(5),mass3set(:,25),G0tensor(528),G0tensor(593),G0tensor(543), &
    G0tensor(533),M2L1R1,[nMW],G0tensor(558))
  call TI_triangle_red(G2tensor(81),RedBasis(3),mass3set(:,5),G0tensor(548),G0tensor(563),G0tensor(553), &
    G0tensor(572),M2L1R1,[nMW],G0tensor(577))
  call TI_triangle_red(G3tensor(37),RedBasis(16),mass3set(:,1),G0tensor(583),G0tensor(578),G0tensor(582),G0tensor(597),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(15),mass3set(:,1),G0tensor(598),G0tensor(602),G0tensor(603),G0tensor(617),M2L1R1)
  call TI_triangle_red(G2tensor(70),RedBasis(6),mass3set(:,1),G0tensor(618),G0tensor(622),G0tensor(623),G0tensor(627),M2L1R1)
  call TI_triangle_red(G2tensor(57),RedBasis(5),mass3set(:,1),G0tensor(638),G0tensor(628),G0tensor(632),G0tensor(643),M2L1R1)
  call TI_triangle_red(G2tensor(426),RedBasis(3),mass3set(:,1),G0tensor(633),G0tensor(246),G0tensor(251),G0tensor(247),M2L1R1)
  call TI_triangle_red(G2tensor(159),RedBasis(6),mass3set(:,9),G0tensor(248),G0tensor(252),G0tensor(254), &
    G0tensor(259),M2L1R1,[nMW],G0tensor(645))
  call TI_triangle_red(G2tensor(321),RedBasis(6),mass3set(:,11),G0tensor(646),G0tensor(647),G0tensor(648), &
    G0tensor(649),M2L1R1,[nMW,nMZ],G0tensor(650),G0tensor(651))
  call TI_triangle_red(G2tensor(429),RedBasis(5),mass3set(:,3),G0tensor(652),G0tensor(653),G0tensor(654), &
    G0tensor(655),M2L1R1,[nMZ],G0tensor(656))
  call TI_triangle_red(G2tensor(62),RedBasis(3),mass3set(:,3),G0tensor(657),G0tensor(658),G0tensor(659), &
    G0tensor(660),M2L1R1,[nMZ],G0tensor(661))
  call TI_triangle_red(G2tensor(69),RedBasis(5),mass3set(:,8),G0tensor(662),G0tensor(663),G0tensor(664), &
    G0tensor(665),M2L1R1,[nMZ],G0tensor(666))
  call TI_triangle_red(G2tensor(74),RedBasis(5),mass3set(:,26),G0tensor(667),G0tensor(668),G0tensor(669), &
    G0tensor(670),M2L1R1,[nMZ],G0tensor(671))
  call TI_triangle_red(G3tensor(18),RedBasis(8),mass3set(:,1),G0tensor(672),G0tensor(673),G0tensor(674),G0tensor(675),M2L1R1)
  call TI_triangle_red(G2tensor(27),RedBasis(15),mass3set(:,8),G0tensor(676),G0tensor(677),G0tensor(678), &
    G0tensor(679),M2L1R1,[nMZ],G0tensor(680))
  call TI_triangle_red(G3tensor(38),RedBasis(22),mass3set(:,1),G0tensor(681),G0tensor(682),G0tensor(683),G0tensor(684),M2L1R1)
  call TI_triangle_red(G2tensor(30),RedBasis(21),mass3set(:,9),G0tensor(685),G0tensor(686),G0tensor(687), &
    G0tensor(688),M2L1R1,[nMW],G0tensor(689))
  call TI_triangle_red(G3tensor(20),RedBasis(20),mass3set(:,1),G0tensor(690),G0tensor(691),G0tensor(692),G0tensor(693),M2L1R1)
  call TI_triangle_red(G2tensor(34),RedBasis(24),mass3set(:,9),G0tensor(694),G0tensor(695),G0tensor(696), &
    G0tensor(697),M2L1R1,[nMW],G0tensor(698))
  call TI_triangle_red(G2tensor(37),RedBasis(25),mass3set(:,1),G0tensor(699),G0tensor(700),G0tensor(701),G0tensor(702),M2L1R1)
  call TI_triangle_red(G2tensor(38),RedBasis(25),mass3set(:,8),G0tensor(703),G0tensor(704),G0tensor(705), &
    G0tensor(706),M2L1R1,[nMZ],G0tensor(707))
  call TI_triangle_red(G2tensor(183),RedBasis(24),mass3set(:,5),G0tensor(708),G0tensor(709),G0tensor(710), &
    G0tensor(711),M2L1R1,[nMW],G0tensor(712))
  call TI_triangle_red(G2tensor(189),RedBasis(24),mass3set(:,7),G0tensor(713),G0tensor(714),G0tensor(715), &
    G0tensor(716),M2L1R1,[nMZ,nMW],G0tensor(717),G0tensor(718))
  call TI_triangle_red(G2tensor(441),RedBasis(25),mass3set(:,5),G0tensor(719),G0tensor(720),G0tensor(721), &
    G0tensor(722),M2L1R1,[nMW],G0tensor(723))
  call TI_triangle_red(G2tensor(195),RedBasis(25),mass3set(:,7),G0tensor(724),G0tensor(725),G0tensor(726), &
    G0tensor(727),M2L1R1,[nMZ,nMW],G0tensor(728),G0tensor(729))
  call TI_triangle_red(G2tensor(213),RedBasis(28),mass3set(:,1),G0tensor(730),G0tensor(731),G0tensor(732),G0tensor(733),M2L1R1)
  call TI_triangle_red(G2tensor(333),RedBasis(28),mass3set(:,5),G0tensor(734),G0tensor(735),G0tensor(736), &
    G0tensor(737),M2L1R1,[nMW],G0tensor(738))
  call TI_triangle_red(G2tensor(139),RedBasis(27),mass3set(:,5),G0tensor(739),G0tensor(740),G0tensor(741), &
    G0tensor(742),M2L1R1,[nMW],G0tensor(743))
  call TI_triangle_red(G2tensor(154),RedBasis(28),mass3set(:,10),G0tensor(744),G0tensor(745),G0tensor(746), &
    G0tensor(747),M2L1R1,[nMZ,nMW],G0tensor(748),G0tensor(749))
  call TI_triangle_red(G2tensor(435),RedBasis(22),mass3set(:,19),G0tensor(750),G0tensor(751),G0tensor(752), &
    G0tensor(753),M2L1R1,[nMW],G0tensor(754))
  call TI_triangle_red(G2tensor(201),RedBasis(25),mass3set(:,4),G0tensor(755),G0tensor(756),G0tensor(757), &
    G0tensor(758),M2L1R1,[nMW],G0tensor(759))
  call TI_triangle_red(G2tensor(438),RedBasis(22),mass3set(:,20),G0tensor(760),G0tensor(761),G0tensor(762), &
    G0tensor(763),M2L1R1,[nMW,nMZ],G0tensor(764),G0tensor(765))
  call TI_triangle_red(G2tensor(207),RedBasis(25),mass3set(:,6),G0tensor(766),G0tensor(767),G0tensor(768), &
    G0tensor(769),M2L1R1,[nMW,nMZ],G0tensor(770),G0tensor(771))
  call TI_triangle_red(G3tensor(45),RedBasis(22),mass3set(:,14),G0tensor(772),G0tensor(773),G0tensor(774), &
    G0tensor(775),M2L1R1,[nMT,nMB],G0tensor(776),G0tensor(777))
  call TI_triangle_red(G3tensor(23),RedBasis(20),mass3set(:,14),G0tensor(778),G0tensor(779),G0tensor(780), &
    G0tensor(781),M2L1R1,[nMT,nMB],G0tensor(782),G0tensor(783))
  call TI_triangle_red(G3tensor(46),RedBasis(22),mass3set(:,15),G0tensor(784),G0tensor(785),G0tensor(786), &
    G0tensor(787),M2L1R1,[nMB,nMT],G0tensor(788),G0tensor(789))
  call TI_triangle_red(G3tensor(25),RedBasis(20),mass3set(:,15),G0tensor(790),G0tensor(791),G0tensor(792), &
    G0tensor(793),M2L1R1,[nMB,nMT],G0tensor(794),G0tensor(795))
  call TI_triangle_red(G3tensor(47),RedBasis(16),mass3set(:,14),G0tensor(796),G0tensor(797),G0tensor(798), &
    G0tensor(799),M2L1R1,[nMT,nMB],G0tensor(800),G0tensor(801))
  call TI_triangle_red(G3tensor(27),RedBasis(8),mass3set(:,14),G0tensor(802),G0tensor(803),G0tensor(804), &
    G0tensor(805),M2L1R1,[nMT,nMB],G0tensor(806),G0tensor(807))
  call TI_triangle_red(G3tensor(48),RedBasis(16),mass3set(:,15),G0tensor(808),G0tensor(809),G0tensor(810), &
    G0tensor(811),M2L1R1,[nMB,nMT],G0tensor(812),G0tensor(813))
  call TI_triangle_red(G3tensor(29),RedBasis(8),mass3set(:,15),G0tensor(814),G0tensor(815),G0tensor(816), &
    G0tensor(817),M2L1R1,[nMB,nMT],G0tensor(818),G0tensor(819))
  call TI_triangle_red(G3tensor(67),RedBasis(16),mass3set(:,27),G0tensor(820),G0tensor(821),G0tensor(822), &
    G0tensor(823),M2L1R1,[nMW,nMH],G0tensor(824),G0tensor(825))
  call TI_triangle_red(G3tensor(61),RedBasis(16),mass3set(:,28),G0tensor(826),G0tensor(827),G0tensor(828), &
    G0tensor(829),M2L1R1,[nME],G0tensor(830))
  call TI_triangle_red(G3tensor(62),RedBasis(16),mass3set(:,29),G0tensor(831),G0tensor(832),G0tensor(833), &
    G0tensor(834),M2L1R1,[nMM],G0tensor(835))
  call TI_triangle_red(G3tensor(63),RedBasis(16),mass3set(:,30),G0tensor(836),G0tensor(837),G0tensor(838), &
    G0tensor(839),M2L1R1,[nML],G0tensor(840))
  call TI_triangle_red(G3tensor(64),RedBasis(16),mass3set(:,31),G0tensor(841),G0tensor(842),G0tensor(843), &
    G0tensor(844),M2L1R1,[nME],G0tensor(845))
  call TI_triangle_red(G3tensor(65),RedBasis(16),mass3set(:,32),G0tensor(846),G0tensor(847),G0tensor(848), &
    G0tensor(849),M2L1R1,[nMM],G0tensor(850))
  call TI_triangle_red(G3tensor(66),RedBasis(16),mass3set(:,33),G0tensor(851),G0tensor(852),G0tensor(853), &
    G0tensor(854),M2L1R1,[nML],G0tensor(855))
  call TI_triangle_red(G3tensor(69),RedBasis(16),mass3set(:,34),G0tensor(856),G0tensor(857),G0tensor(858), &
    G0tensor(859),M2L1R1,[nMZ,nMH,nMW],G0tensor(860),G0tensor(861),G0tensor(862))



end subroutine vamp_3

end module ol_vamp_3_ppvvj_ew_uuxwwxg_1_/**/REALKIND
