
module ol_vamp_3_ppvvj_ew_ddxaag_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj_ew_ddxaag_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj_ew_ddxaag_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvj_ew_ddxaag_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvj_ew_ddxaag_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvj_ew_ddxaag_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvj_ew_ddxaag_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(2,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[19,4,8],[0,0,0],3,1,wf8(:,56))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,56),G0H4(41),m3h8x4(:,105),heltab2x32(:,:,316))
  call Hloop_A_Q(ntryL,G0H4(41),19,0,G1H4(118),n2h4(147))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,56))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,56),G0H4(41),m3h8x4(:,106),heltab2x32(:,:,317))
  call Hloop_A_Q(ntryL,G0H4(41),19,nMT,G1H4(119),n2h4(148))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[19,4,8],[0,0,0],3,1,wf8(:,56))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,56),G0H4(41),m3h8x4(:,107),heltab2x32(:,:,318))
  call Hloop_Q_A(ntryL,G0H4(41),19,0,G1H4(123),n2h4(149))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,56))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,56),G0H4(41),m3h8x4(:,108),heltab2x32(:,:,319))
  call Hloop_Q_A(ntryL,G0H4(41),19,nMT,G1H4(124),n2h4(150))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[19,4,8],[0,0,0],3,1,wf8(:,56))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,56),G0H4(41),m3h8x4(:,109),heltab2x32(:,:,320))
  call Hloop_A_Q(ntryL,G0H4(41),19,0,G1H4(125),n2h4(151))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,56))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,56),G0H4(41),m3h8x4(:,110),heltab2x32(:,:,321))
  call Hloop_A_Q(ntryL,G0H4(41),19,nMB,G1H4(126),n2h4(152))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[19,4,8],[0,0,0],3,1,wf8(:,56))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,56),G0H4(41),m3h8x4(:,111),heltab2x32(:,:,322))
  call Hloop_Q_A(ntryL,G0H4(41),19,0,G1H4(130),n2h4(153))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,56))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,56),G0H4(41),m3h8x4(:,112),heltab2x32(:,:,323))
  call Hloop_Q_A(ntryL,G0H4(41),19,nMB,G1H4(1),n2h4(154))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[19,4,8],[nME,nME,nME],3,1,wf8(:,57))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZl,m3h8x4(:,113),heltab2x32(:,:,324))
  call Hloop_A_Q(ntryL,G0H4(41),19,nME,G1H4(131),n2h4(155))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,57))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZl,m3h8x4(:,114),heltab2x32(:,:,325))
  call Hloop_A_Q(ntryL,G0H4(41),19,nMM,G1H4(134),n2h4(156))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[19,4,8],[nML,nML,nML],3,1,wf8(:,57))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZl,m3h8x4(:,115),heltab2x32(:,:,326))
  call Hloop_A_Q(ntryL,G0H4(41),19,nML,G1H4(136),n2h4(157))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[19,4,8],[nME,nME,nME],3,1,wf8(:,57))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZl,m3h8x4(:,116),heltab2x32(:,:,327))
  call Hloop_Q_A(ntryL,G0H4(41),19,nME,G1H4(137),n2h4(158))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,57))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZl,m3h8x4(:,117),heltab2x32(:,:,328))
  call Hloop_Q_A(ntryL,G0H4(41),19,nMM,G1H4(140),n2h4(159))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[19,4,8],[nML,nML,nML],3,1,wf8(:,57))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZl,m3h8x4(:,118),heltab2x32(:,:,329))
  call Hloop_Q_A(ntryL,G0H4(41),19,nML,G1H4(141),n2h4(160))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[19,4,8],[0,0,0],3,1,wf8(:,57))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZu,m3h8x4(:,119),heltab2x32(:,:,330))
  call Hloop_A_Q(ntryL,G0H4(41),19,0,G1H4(142),n2h4(161))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,57))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZu,m3h8x4(:,120),heltab2x32(:,:,331))
  call Hloop_A_Q(ntryL,G0H4(41),19,nMT,G1H4(145),n2h4(162))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[19,4,8],[0,0,0],3,1,wf8(:,57))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZu,m3h8x4(:,121),heltab2x32(:,:,332))
  call Hloop_Q_A(ntryL,G0H4(41),19,0,G1H4(146),n2h4(163))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,57))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZu,m3h8x4(:,122),heltab2x32(:,:,333))
  call Hloop_Q_A(ntryL,G0H4(41),19,nMT,G1H4(147),n2h4(164))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[19,4,8],[0,0,0],3,1,wf8(:,57))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZd,m3h8x4(:,123),heltab2x32(:,:,334))
  call Hloop_A_Q(ntryL,G0H4(41),19,0,G1H4(153),n2h4(165))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,57))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZd,m3h8x4(:,124),heltab2x32(:,:,335))
  call Hloop_A_Q(ntryL,G0H4(41),19,nMB,G1H4(158),n2h4(166))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[19,4,8],[0,0,0],3,1,wf8(:,57))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZd,m3h8x4(:,125),heltab2x32(:,:,336))
  call Hloop_Q_A(ntryL,G0H4(41),19,0,G1H4(154),n2h4(167))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,57))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,57),G0H4(41),ngZd,m3h8x4(:,126),heltab2x32(:,:,337))
  call Hloop_Q_A(ntryL,G0H4(41),19,nMB,G1H4(157),n2h4(168))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(162),m3h8x4(:,127),heltab2x32(:,:,338))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(163),m3h8x4(:,128),heltab2x32(:,:,339))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(164),m3h8x4(:,129),heltab2x32(:,:,340))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(169),m3h8x4(:,130),heltab2x32(:,:,341))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,56),G1H4(170),m3h8x4(:,131),heltab2x32(:,:,342))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(173),m3h8x4(:,132),heltab2x32(:,:,343))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,56),G1H4(175),m3h8x4(:,133),heltab2x32(:,:,344))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(178),m3h8x4(:,134),heltab2x32(:,:,345))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,57),G1H4(152),m3h8x4(:,135),heltab2x32(:,:,346))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(167),m3h8x4(:,136),heltab2x32(:,:,347))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,57),G1H4(168),m3h8x4(:,137),heltab2x32(:,:,348))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(5),m3h8x4(:,138),heltab2x32(:,:,349))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(9),m3h8x4(:,139),heltab2x32(:,:,350))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(10),m3h8x4(:,140),heltab2x32(:,:,351))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(11),m3h8x4(:,141),heltab2x32(:,:,352))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(12),m3h8x4(:,142),heltab2x32(:,:,353))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,56),G0H4(41),m3h8x4(:,143),heltab2x32(:,:,354))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,56),G0H4(42),m3h8x4(:,144),heltab2x32(:,:,355))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(43),m3h8x4(:,145),heltab2x32(:,:,356))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(44),m3h8x4(:,146),heltab2x32(:,:,357))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,56),G0H4(45),m3h8x4(:,147),heltab2x32(:,:,358))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,56),G0H4(46),m3h8x4(:,148),heltab2x32(:,:,359))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(47),m3h8x4(:,149),heltab2x32(:,:,360))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(48),m3h8x4(:,150),heltab2x32(:,:,361))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(15),m3h8x4(:,151),heltab2x32(:,:,362))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(16),m3h8x4(:,152),heltab2x32(:,:,363))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(17),m3h8x4(:,153),heltab2x32(:,:,364))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(18),m3h8x4(:,154),heltab2x32(:,:,365))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(29),m3h8x4(:,155),heltab2x32(:,:,366))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(47),m3h8x4(:,156),heltab2x32(:,:,367))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(25),m3h8x4(:,157),heltab2x32(:,:,368))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(51),m3h8x4(:,158),heltab2x32(:,:,369))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,56),G0H4(49),m3h8x4(:,159),heltab2x32(:,:,370))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,56),G0H4(50),m3h8x4(:,160),heltab2x32(:,:,371))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(51),m3h8x4(:,161),heltab2x32(:,:,372))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(52),m3h8x4(:,162),heltab2x32(:,:,373))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,56),G0H4(53),m3h8x4(:,163),heltab2x32(:,:,374))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,56),G0H4(54),m3h8x4(:,164),heltab2x32(:,:,375))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(55),m3h8x4(:,165),heltab2x32(:,:,376))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(56),m3h8x4(:,166),heltab2x32(:,:,377))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[22,1,8],[0,0,0],3,1,wf8(:,45))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,45),G0H4(57),m3h8x4(:,167),heltab2x32(:,:,378))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[22,1,8],[nMZ,0,0],3,1,wf8(:,45))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,45),G0H4(58),ngZd,m3h8x4(:,168),heltab2x32(:,:,379))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[22,1,8],[nMW,0,0],3,1,wf8(:,45))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,45),G0H4(59),m3h8x4(:,169),heltab2x32(:,:,380))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[22,1,8],[0,0,0],3,1,wf8(:,45))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,45),G0H4(60),m3h8x4(:,170),heltab2x32(:,:,381))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[22,1,8],[0,nMW,nMW],3,1,wf8(:,45))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,45),G0H4(61),m3h8x4(:,171),heltab2x32(:,:,382))
  call Hloop_A_Q(ntryL,G0H4(61),22,0,G1H4(150),n2h4(169))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[26,1,4],[0,0,0],3,1,wf8(:,36))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,36),G0H4(61),m3h8x4(:,172),heltab2x32(:,:,383))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[26,1,4],[nMZ,0,0],3,1,wf8(:,36))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,36),G0H4(62),ngZd,m3h8x4(:,173),heltab2x32(:,:,384))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[26,1,4],[nMW,0,0],3,1,wf8(:,36))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,36),G0H4(63),m3h8x4(:,174),heltab2x32(:,:,385))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[26,1,4],[0,0,0],3,1,wf8(:,36))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,36),G0H4(64),m3h8x4(:,175),heltab2x32(:,:,386))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[26,1,4],[0,nMW,nMW],3,1,wf8(:,36))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,36),G0H4(65),m3h8x4(:,176),heltab2x32(:,:,387))
  call Hloop_A_Q(ntryL,G0H4(65),26,0,G1H4(61),n2h4(170))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(113),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(154),[G1H4(146),G1H4(130),G1H4(123),G1H4(45),G1H4(176) &
    ,G1H4(138),G1H4(122),G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(153),[G1H4(142),G1H4(125),G1H4(118),G1H4(36),G1H4(171) &
    ,G1H4(132),G1H4(48),G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(145),[G1H4(119),G1H4(172),G1H4(121),G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(147),[G1H4(124),G1H4(177),G1H4(30),G1H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(158),[G1H4(126),G1H4(39),G1H4(133),G1H4(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(1),G1H4(46),G1H4(139),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(13),G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(18),G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(8),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(52),[G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(36),[G0H4(33),G0H4(4),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(34),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(35),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G1H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(27),[G1H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(60),[G0H4(57),G0H4(9),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(58),[G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(59),[G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(150),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(34),[G1H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(37),[G1H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(43),[G1H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(40),[G0H4(37),G0H4(10),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(38),[G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(39),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(50),[G1H16(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(53),[G1H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(59),[G1H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(64),[G0H4(61),G0H4(16),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(62),[G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(63),[G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(107),G1H4(143),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(108),G1H4(144),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(111),G1H4(155),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(137),[G1H4(112),G1H4(156),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(140),[G1H4(114),G1H4(160),G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(141),[G1H4(117),G1H4(161),G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(164),[G1H4(162),G1H4(63),G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(163),G1H4(64),G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(168),[G1H4(152),G1H4(175),G1H4(170),G1H4(77),G1H4(72) &
    ,G1H4(70),G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(167),G1H4(178),G1H4(173),G1H4(78),G1H4(75) &
    ,G1H4(71),G1H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(9),G1H4(84),G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(10),G1H4(87),G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(43),[G0H4(41),G0H4(19),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(44),[G0H4(42),G0H4(20),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(47),[G0H4(45),G0H4(23),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(48),[G0H4(46),G0H4(24),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(17),G1H4(16),G1H4(15),G1H4(94),G1H4(93) &
    ,G1H4(89),G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(25),G1H4(47),G1H4(29),G1H4(101),G1H4(100) &
    ,G1H4(96),G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(51),[G0H4(49),G0H4(27),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(52),[G0H4(50),G0H4(28),G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(55),[G0H4(53),G0H4(31),G0H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(56),[G0H4(54),G0H4(32),G0H4(30)])
  call Hloop_QV_A(ntryL,G1H4(113),ex4(:),G1H2(244),m3h2x2(:,243),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(244),29,0,G2H2(11),n2h2(211))
  call Hloop_QV_A(ntryL,G1H4(120),ex3(:),G1H2(13),m3h2x2(:,244),heltab2x4(:,:,282))
  call Hloop_Q_A(ntryL,G1H2(13),29,0,G2H2(7),n2h2(212))
  call Hloop_QV_A(ntryL,G1H4(154),ex3(:),G1H2(14),m3h2x2(:,245),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(14),23,0,G2H2(3),n2h2(213))
  call Hloop_QV_A(ntryL,G1H4(90),ex4(:),G1H2(20),m3h2x2(:,246),heltab2x4(:,:,284))
  call Hloop_Q_A(ntryL,G1H2(20),27,0,G2H2(15),n2h2(214))
  call Hloop_AV_Q(ntryL,G1H4(153),ex3(:),G1H2(25),m3h2x2(:,247),heltab2x4(:,:,285))
  call Hloop_A_Q(ntryL,G1H2(25),23,0,G2H2(19),n2h2(215))
  call Hloop_AV_Q(ntryL,G1H4(106),ex4(:),G1H2(26),m3h2x2(:,248),heltab2x4(:,:,286))
  call Hloop_A_Q(ntryL,G1H2(26),27,0,G2H2(75),n2h2(216))
  call Hloop_QV_A(ntryL,G1H4(129),ex4(:),G1H2(36),m3h2x2(:,249),heltab2x4(:,:,287))
  call Hloop_Q_A(ntryL,G1H2(36),27,nMT,G2H2(23),n2h2(217))
  call Hloop_AV_Q(ntryL,G1H4(135),ex4(:),G1H2(37),m3h2x2(:,250),heltab2x4(:,:,288))
  call Hloop_A_Q(ntryL,G1H2(37),27,nMT,G2H2(35),n2h2(218))
  call Hloop_QV_A(ntryL,G1H4(2),ex4(:),G1H2(42),m3h2x2(:,251),heltab2x4(:,:,289))
  call Hloop_Q_A(ntryL,G1H2(42),27,nMB,G2H2(31),n2h2(219))
  call Hloop_AV_Q(ntryL,G1H4(148),ex4(:),G1H2(52),m3h2x2(:,252),heltab2x4(:,:,290))
  call Hloop_A_Q(ntryL,G1H2(52),27,nMB,G2H2(27),n2h2(220))
  call Hloop_AV_Q(ntryL,G1H4(145),ex3(:),G1H2(53),m3h2x2(:,253),heltab2x4(:,:,291))
  call Hloop_A_Q(ntryL,G1H2(53),23,nMT,G2H2(17),n2h2(221))
  call Hloop_QV_A(ntryL,G1H4(147),ex3(:),G1H2(58),m3h2x2(:,254),heltab2x4(:,:,292))
  call Hloop_Q_A(ntryL,G1H2(58),23,nMT,G2H2(39),n2h2(222))
  call Hloop_AV_Q(ntryL,G1H4(158),ex3(:),G1H2(64),m3h2x2(:,255),heltab2x4(:,:,293))
  call Hloop_A_Q(ntryL,G1H2(64),23,nMB,G2H2(21),n2h2(223))
  call Hloop_QV_A(ntryL,G1H4(157),ex3(:),G1H2(69),m3h2x2(:,256),heltab2x4(:,:,294))
  call Hloop_Q_A(ntryL,G1H2(69),23,nMB,G2H2(43),n2h2(224))
  call Hloop_QV_A(ntryL,G1H8(15),wf4(:,13),G1H2(70),m3h4x2(:,41),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(70),23,0,G2H2(25),n2h2(225))
  call Hloop_QV_A(ntryL,G1H8(20),wf4(:,13),G1H2(92),m3h4x2(:,42),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(92),23,nMT,G2H2(79),n2h2(226))
  call Hloop_AV_Q(ntryL,G1H8(29),wf4(:,13),G1H2(96),m3h4x2(:,43),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(96),23,0,G2H2(47),n2h2(227))
  call Hloop_AV_Q(ntryL,G1H8(34),wf4(:,13),G1H2(97),m3h4x2(:,44),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(97),23,nMT,G2H2(51),n2h2(228))
  call Hloop_QV_A(ntryL,G1H8(39),wf4(:,13),G1H2(108),m3h4x2(:,45),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(108),23,nMB,G2H2(55),n2h2(229))
  call Hloop_AV_Q(ntryL,G1H8(44),wf4(:,13),G1H2(113),m3h4x2(:,46),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(113),23,nMB,G2H2(83),n2h2(230))
  call Hloop_AV_Q(ntryL,G1H8(49),ex4(:),G1H4(58),m3h2x4(:,91),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(58),26,0,G2H4(3),n2h4(171))
  call Hloop_QV_A(ntryL,G1H8(5),ex4(:),G1H4(166),m3h2x4(:,92),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(166),25,0,G2H4(31),n2h4(172))
  call Hloop_AV_Q(ntryL,G1H8(17),ex3(:),G1H4(128),m3h2x4(:,93),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(128),22,0,G2H4(25),n2h4(173))
  call Hloop_QV_A(ntryL,G1H8(2),ex3(:),G1H4(20),m3h2x4(:,94),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(20),21,0,G2H4(27),n2h4(174))
  call Hloop_QA_W(ntryL,G1H8(24),ex2(:),G1H4(38),m3h2x4(:,95),heltab2x8(:,:,141))
  call Hloop_AQ_W(ntryL,G1H8(25),ex1(:),G1H4(31),m3h2x4(:,96),heltab2x8(:,:,142))
  call Hloop_AQ_V(ntryL,G1H16(7),wf4(:,3),G1H4(37),m3h4x4(:,19),heltab2x16(:,:,80))
  call Hloop_AQ_Z(ntryL,G1H16(13),wf4(:,3),G1H4(44),ngZd,m3h4x4(:,20),heltab2x16(:,:,81))
  call Hloop_AQ_W(ntryL,G1H16(8),wf4(:,3),G1H4(56),m3h4x4(:,21),heltab2x16(:,:,82))
  call Hloop_VQ_A(ntryL,G1H16(15),wf4(:,3),G1H4(74),m3h4x4(:,22),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(74),21,0,G2H4(11),n2h4(175))
  call Hloop_VQ_A(ntryL,G0H8(8),wf4(:,3),G0H2(1),m3h4x2(:,47),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(114),n2h2(231))
  call Hloop_ZQ_A(ntryL,G0H8(9),wf4(:,3),G0H2(1),ngZd,m3h4x2(:,48),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(125),n2h2(232))
  call Hloop_WQ_A(ntryL,G0H8(7),wf4(:,3),G0H2(1),m3h4x2(:,49),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(130),n2h2(233))
  call Hloop_AQ_W(ntryL,G1H8(26),wf4(:,3),G1H2(135),m3h4x2(:,50),heltab2x8(:,:,146))
  call Hloop_AV_Q(ntryL,G1H16(42),wf8(:,50),G1H2(146),m3h8x2(:,1),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(146),23,0,G2H2(59),n2h2(234))
  call Hloop_AV_Q(ntryL,G1H16(28),wf8(:,50),G1H2(147),m3h8x2(:,2),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(147),23,nMT,G2H2(1),n2h2(235))
  call Hloop_QV_A(ntryL,G1H16(52),wf8(:,50),G1H2(152),m3h8x2(:,3),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(152),23,0,G2H2(63),n2h2(236))
  call Hloop_QV_A(ntryL,G1H16(38),wf8(:,50),G1H2(163),m3h8x2(:,4),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(163),23,nMT,G2H2(5),n2h2(237))
  call Hloop_AV_Q(ntryL,G1H16(48),wf8(:,50),G1H2(169),m3h8x2(:,5),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(169),23,nMB,G2H2(67),n2h2(238))
  call Hloop_QV_A(ntryL,G1H16(58),wf8(:,50),G1H2(173),m3h8x2(:,6),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(173),23,nMB,G2H2(9),n2h2(239))
  call Hloop_QA_V(ntryL,G1H16(9),ex2(:),G1H8(4),m3h2x8(:,62),heltab2x16(:,:,90))
  call Hloop_QA_Z(ntryL,G1H16(1),ex2(:),G1H8(28),ngZd,m3h2x8(:,63),heltab2x16(:,:,91))
  call Hloop_QA_W(ntryL,G1H16(21),ex2(:),G1H8(30),m3h2x8(:,64),heltab2x16(:,:,92))
  call Hloop_VA_Q(ntryL,G1H16(2),ex2(:),G1H8(31),m3h2x8(:,65),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(31),18,0,G2H8(7),n2h8(59))
  call Hloop_VA_Q(ntryL,G0H4(36),ex2(:),G0H2(1),m3h2x2(:,257),heltab2x4(:,:,295))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(180),n2h2(240))
  call Hloop_ZA_Q(ntryL,G0H4(34),ex2(:),G0H2(1),ngZd,m3h2x2(:,258),heltab2x4(:,:,296))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(185),n2h2(241))
  call Hloop_WA_Q(ntryL,G0H4(35),ex2(:),G0H2(1),m3h2x2(:,259),heltab2x4(:,:,297))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(190),n2h2(242))
  call Hloop_QA_W(ntryL,G1H4(102),ex2(:),G1H2(201),m3h2x2(:,260),heltab2x4(:,:,298))
  call Hloop_QA_V(ntryL,G1H16(10),wf4(:,10),G1H4(68),m3h4x4(:,23),heltab2x16(:,:,94))
  call Hloop_QA_Z(ntryL,G1H16(4),wf4(:,10),G1H4(73),ngZd,m3h4x4(:,24),heltab2x16(:,:,95))
  call Hloop_QA_W(ntryL,G1H16(3),wf4(:,10),G1H4(79),m3h4x4(:,25),heltab2x16(:,:,96))
  call Hloop_VA_Q(ntryL,G1H16(6),wf4(:,10),G1H4(92),m3h4x4(:,26),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(92),22,0,G2H4(12),n2h4(176))
  call Hloop_VA_Q(ntryL,G0H8(18),wf4(:,10),G0H2(1),m3h4x2(:,51),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(202),n2h2(243))
  call Hloop_ZA_Q(ntryL,G0H8(12),wf4(:,10),G0H2(1),ngZd,m3h4x2(:,52),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(207),n2h2(244))
  call Hloop_WA_Q(ntryL,G0H8(13),wf4(:,10),G0H2(1),m3h4x2(:,53),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(218),n2h2(245))
  call Hloop_QA_W(ntryL,G1H8(27),wf4(:,10),G1H2(223),m3h4x2(:,54),heltab2x8(:,:,150))
  call Hloop_AV_Q(ntryL,G1H16(24),wf8(:,51),G1H2(224),m3h8x2(:,7),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(224),23,0,G2H2(91),n2h2(246))
  call Hloop_AV_Q(ntryL,G1H16(12),wf8(:,51),G1H2(235),m3h8x2(:,8),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(235),23,nMT,G2H2(71),n2h2(247))
  call Hloop_QV_A(ntryL,G1H16(23),wf8(:,51),G1H2(240),m3h8x2(:,9),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(240),23,0,G2H2(113),n2h2(248))
  call Hloop_QV_A(ntryL,G1H16(14),wf8(:,51),G1H2(245),m3h8x2(:,10),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(245),23,nMT,G2H2(87),n2h2(249))
  call Hloop_AV_Q(ntryL,G1H16(20),wf8(:,51),G1H2(256),m3h8x2(:,11),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(256),23,nMB,G2H2(114),n2h2(250))
  call Hloop_QV_A(ntryL,G1H16(19),wf8(:,51),G1H2(261),m3h8x2(:,12),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(261),23,nMB,G2H2(98),n2h2(251))
  call Hloop_AQ_V(ntryL,G1H16(27),ex1(:),G1H8(32),m3h2x8(:,66),heltab2x16(:,:,104))
  call Hloop_AQ_Z(ntryL,G1H16(25),ex1(:),G1H8(33),ngZd,m3h2x8(:,67),heltab2x16(:,:,105))
  call Hloop_AQ_W(ntryL,G1H16(26),ex1(:),G1H8(35),m3h2x8(:,68),heltab2x16(:,:,106))
  call Hloop_VQ_A(ntryL,G1H16(31),ex1(:),G1H8(36),m3h2x8(:,69),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(36),17,0,G2H8(8),n2h8(60))
  call Hloop_VQ_A(ntryL,G0H4(60),ex1(:),G0H2(1),m3h2x2(:,261),heltab2x4(:,:,299))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(267),n2h2(252))
  call Hloop_ZQ_A(ntryL,G0H4(58),ex1(:),G0H2(1),ngZd,m3h2x2(:,262),heltab2x4(:,:,300))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(35),n2h2(253))
  call Hloop_WQ_A(ntryL,G0H4(59),ex1(:),G0H2(1),m3h2x2(:,263),heltab2x4(:,:,301))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(46),n2h2(254))
  call Hloop_AQ_W(ntryL,G1H4(150),ex1(:),G1H2(57),m3h2x2(:,264),heltab2x4(:,:,302))
  call Hloop_AV_Q(ntryL,G1H8(14),ex3(:),G1H4(85),m3h2x4(:,97),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(85),22,0,G2H4(13),n2h4(177))
  call Hloop_AV_Q(ntryL,G1H8(16),ex3(:),G1H4(91),m3h2x4(:,98),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G1H4(91),22,0,G2H4(14),n2h4(178))
  call Hloop_UW_V(ntryL,G0H8(11),18,ex3(:),4,G1H4(97),m3h2x4(:,99),heltab2x8(:,:,153))
  call Hloop_QV_A(ntryL,G1H16(34),ex3(:),G1H8(37),m3h2x8(:,70),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(37),20,0,G2H8(9),n2h8(61))
  call Hloop_QV_A(ntryL,G1H16(30),ex3(:),G1H8(38),m3h2x8(:,71),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(38),20,nMT,G2H8(10),n2h8(62))
  call Hloop_AV_Q(ntryL,G1H16(37),ex3(:),G1H8(40),m3h2x8(:,72),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G1H8(40),20,0,G2H8(11),n2h8(63))
  call Hloop_AV_Q(ntryL,G1H16(33),ex3(:),G1H8(41),m3h2x8(:,73),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(41),20,nMT,G2H8(12),n2h8(64))
  call Hloop_QV_A(ntryL,G1H16(36),ex3(:),G1H8(42),m3h2x8(:,74),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(42),20,nMB,G2H8(13),n2h8(65))
  call Hloop_AV_Q(ntryL,G1H16(41),ex3(:),G1H8(43),m3h2x8(:,75),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H8(43),20,nMB,G2H8(14),n2h8(66))
  call Hloop_QA_V(ntryL,G1H16(43),ex2(:),G1H8(45),m3h2x8(:,76),heltab2x16(:,:,114))
  call Hloop_QA_Z(ntryL,G1H16(40),ex2(:),G1H8(46),ngZd,m3h2x8(:,77),heltab2x16(:,:,115))
  call Hloop_QA_W(ntryL,G1H16(45),ex2(:),G1H8(47),m3h2x8(:,78),heltab2x16(:,:,116))
  call Hloop_VA_Q(ntryL,G1H16(44),ex2(:),G1H8(48),m3h2x8(:,79),heltab2x16(:,:,117))
  call Hloop_A_Q(ntryL,G1H8(48),18,0,G2H8(15),n2h8(67))
  call Hloop_VA_Q(ntryL,G0H4(40),ex2(:),G0H2(1),m3h2x2(:,265),heltab2x4(:,:,303))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(101),n2h2(255))
  call Hloop_ZA_Q(ntryL,G0H4(38),ex2(:),G0H2(1),ngZd,m3h2x2(:,266),heltab2x4(:,:,304))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(123),n2h2(256))
  call Hloop_WA_Q(ntryL,G0H4(39),ex2(:),G0H2(1),m3h2x2(:,267),heltab2x4(:,:,305))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(134),n2h2(257))
  call Hloop_QA_W(ntryL,G1H4(105),ex2(:),G1H2(178),m3h2x2(:,268),heltab2x4(:,:,306))
  call Hloop_QV_A(ntryL,G1H8(19),ex3(:),G1H4(98),m3h2x4(:,100),heltab2x8(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(98),21,0,G2H4(15),n2h4(179))
  call Hloop_QV_A(ntryL,G1H8(1),ex3(:),G1H4(103),m3h2x4(:,101),heltab2x8(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(103),21,0,G2H4(16),n2h4(180))
  call Hloop_UV_W(ntryL,G0H8(10),17,ex3(:),4,G1H4(109),m3h2x4(:,102),heltab2x8(:,:,156))
  call Hloop_QV_A(ntryL,G1H16(50),ex3(:),G1H8(50),m3h2x8(:,80),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(50),20,0,G2H8(16),n2h8(68))
  call Hloop_QV_A(ntryL,G1H16(47),ex3(:),G1H8(51),m3h2x8(:,81),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H8(51),20,nMT,G2H8(1),n2h8(69))
  call Hloop_AV_Q(ntryL,G1H16(53),ex3(:),G1H8(3),m3h2x8(:,82),heltab2x16(:,:,120))
  call Hloop_A_Q(ntryL,G1H8(3),20,0,G2H8(2),n2h8(70))
  call Hloop_AV_Q(ntryL,G1H16(49),ex3(:),G1H8(9),m3h2x8(:,83),heltab2x16(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(9),20,nMT,G2H8(3),n2h8(71))
  call Hloop_QV_A(ntryL,G1H16(55),ex3(:),G1H8(6),m3h2x8(:,84),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G1H8(6),20,nMB,G2H8(4),n2h8(72))
  call Hloop_AV_Q(ntryL,G1H16(54),ex3(:),G1H8(52),m3h2x8(:,85),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(52),20,nMB,G2H8(5),n2h8(73))
  call Hloop_AQ_V(ntryL,G1H16(59),ex1(:),G1H8(8),m3h2x8(:,86),heltab2x16(:,:,124))
  call Hloop_AQ_Z(ntryL,G1H16(57),ex1(:),G1H8(10),ngZd,m3h2x8(:,87),heltab2x16(:,:,125))
  call Hloop_AQ_W(ntryL,G1H16(61),ex1(:),G1H8(12),m3h2x8(:,88),heltab2x16(:,:,126))
  call Hloop_VQ_A(ntryL,G1H16(60),ex1(:),G1H8(53),m3h2x8(:,89),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G1H8(53),17,0,G2H8(6),n2h8(74))
  call Hloop_VQ_A(ntryL,G0H4(64),ex1(:),G0H2(1),m3h2x2(:,269),heltab2x4(:,:,307))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(189),n2h2(258))
  call Hloop_ZQ_A(ntryL,G0H4(62),ex1(:),G0H2(1),ngZd,m3h2x2(:,270),heltab2x4(:,:,308))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(211),n2h2(259))
  call Hloop_WQ_A(ntryL,G0H4(63),ex1(:),G0H2(1),m3h2x2(:,271),heltab2x4(:,:,309))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(45),n2h2(260))
  call Hloop_AQ_W(ntryL,G1H4(61),ex1(:),G1H2(34),m3h2x2(:,272),heltab2x4(:,:,310))
  call Hloop_AV_Q(ntryL,G1H4(131),ex3(:),G1H2(23),m3h2x2(:,273),heltab2x4(:,:,311))
  call Hloop_A_Q(ntryL,G1H2(23),23,nME,G2H2(105),n2h2(261))
  call Hloop_AV_Q(ntryL,G1H4(134),ex3(:),G1H2(221),m3h2x2(:,274),heltab2x4(:,:,312))
  call Hloop_A_Q(ntryL,G1H2(221),23,nMM,G2H2(101),n2h2(262))
  call Hloop_AV_Q(ntryL,G1H4(136),ex3(:),G1H2(78),m3h2x2(:,275),heltab2x4(:,:,313))
  call Hloop_A_Q(ntryL,G1H2(78),23,nML,G2H2(100),n2h2(263))
  call Hloop_QV_A(ntryL,G1H4(137),ex3(:),G1H2(111),m3h2x2(:,276),heltab2x4(:,:,314))
  call Hloop_Q_A(ntryL,G1H2(111),23,nME,G2H2(69),n2h2(264))
  call Hloop_QV_A(ntryL,G1H4(140),ex3(:),G1H2(87),m3h2x2(:,277),heltab2x4(:,:,315))
  call Hloop_Q_A(ntryL,G1H2(87),23,nMM,G2H2(72),n2h2(265))
  call Hloop_QV_A(ntryL,G1H4(141),ex3(:),G1H2(122),m3h2x2(:,278),heltab2x4(:,:,316))
  call Hloop_Q_A(ntryL,G1H2(122),23,nML,G2H2(77),n2h2(266))
  call Hloop_SV_T(ntryL,G1H4(164),19,ex3(:),4,G2H2(80),m3h2x2(:,279),heltab2x4(:,:,317))
  call Hloop_TV_S(ntryL,G1H4(169),19,ex3(:),4,G2H2(2),m3h2x2(:,280),heltab2x4(:,:,318))
  call Hloop_DV_C(ntryL,G1H4(168),19,ex3(:),G2H2(181),m3h2x2(:,281),heltab2x4(:,:,319))
  call Hloop_CV_D(ntryL,G1H4(5),19,ex3(:),4,G2H2(6),m3h2x2(:,282),heltab2x4(:,:,320))
  call Hloop_UW_V(ntryL,G1H4(11),19,ex3(:),4,G2H2(10),m3h2x2(:,283),heltab2x4(:,:,321))
  call Hloop_UV_W(ntryL,G1H4(12),19,ex3(:),4,G2H2(14),m3h2x2(:,284),heltab2x4(:,:,322))
  call Hloop_SV_T(ntryL,G0H4(43),19,ex3(:),4,G1H2(98),m3h2x2(:,285),heltab2x4(:,:,323))
  call Hloop_TV_S(ntryL,G0H4(44),19,ex3(:),4,G1H2(232),m3h2x2(:,286),heltab2x4(:,:,324))
  call Hloop_VV_S(ntryL,G0H4(47),ex3(:),G0H2(1),m3h2x2(:,287),heltab2x4(:,:,325))
  call Hloop_VV_S(ntryL,G0H4(48),ex3(:),G0H2(2),m3h2x2(:,288),heltab2x4(:,:,326))
  call Hloop_SV_V(ntryL,G1H4(18),ex3(:),G1H2(144),m3h2x2(:,289),heltab2x4(:,:,327))
  call Hloop_VV_S(ntryL,G1H4(51),ex3(:),G1H2(155),m3h2x2(:,290),heltab2x4(:,:,328))
  call Hloop_SV_V(ntryL,G0H4(51),ex3(:),G0H2(3),m3h2x2(:,291),heltab2x4(:,:,329))
  call Hloop_SV_V(ntryL,G0H4(52),ex3(:),G0H2(4),m3h2x2(:,292),heltab2x4(:,:,330))
  call Hloop_UW_V(ntryL,G0H4(55),19,ex3(:),4,G1H2(177),m3h2x2(:,293),heltab2x4(:,:,331))
  call Hloop_UV_W(ntryL,G0H4(56),19,ex3(:),4,G1H2(21),m3h2x2(:,294),heltab2x4(:,:,332))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G2H2(138),G2H2(73),G2H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(119),[G2H2(116),G2H2(76),G2H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(114),[G1H2(278),G1H2(103)])
call HGT_w2_OLR(G1H2(91),1,1,2)
call HGT_w2_invQ_OLR(G1H2(91),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(281),[G1H2(79)])
call HGT_w2_OLR(G1H2(102),1,1,2)
call HGT_w2_invQ_OLR(G1H2(102),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(162),[G1H2(124),G1H2(86)])
call HGT_OLR(G2H2(122),1,1,2)
call HGT_invQ_OLR(G2H2(122),2,5,2)
call HGT_OLR(G2H2(122),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(122),[G1H2(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(63),G2H2(176),G2H2(123),G1H2(329),G1H2(326) &
    ,G1H2(323),G1H2(313),G1H2(213),G1H2(179),G1H2(141),G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(67),G1H2(167),G1H2(18),G1H2(212)])
call HGT_OLR(G2H2(126),1,1,2)
call HGT_invQ_OLR(G2H2(126),2,5,2)
call HGT_OLR(G2H2(126),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(127),[G1H2(379),G1H2(332),G1H2(89),G1H2(233),G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(120),[G1H2(199),G1H2(109)])
call HGT_OLR(G2H2(130),1,1,2)
call HGT_invQ_OLR(G2H2(130),2,5,2)
call HGT_OLR(G2H2(130),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(130),[G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G2H2(59),G2H2(182),G2H2(131),G1H2(347),G1H2(310) &
    ,G1H2(307),G1H2(304),G1H2(15),G1H2(17),G1H2(243),G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(110),G1H2(61),G1H2(29),G1H2(30)])
call HGT_OLR(G2H2(134),1,1,2)
call HGT_invQ_OLR(G2H2(134),2,5,2)
call HGT_OLR(G2H2(134),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G2H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(135),[G1H2(388),G1H2(361),G1H2(149),G1H2(117),G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(319),G1H2(316),G1H2(312),G1H2(277)])
call HGT_w2_OLR(G1H2(157),1,1,2)
call HGT_w2_invQ_OLR(G1H2(157),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(338),G1H2(335),G1H2(331),G1H2(280)])
call HGT_w2_OLR(G1H2(168),1,1,2)
call HGT_w2_invQ_OLR(G1H2(168),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G1H2(431)])
call HGT_OLR(G2H2(144),1,1,2)
call HGT_invQ_OLR(G2H2(144),2,5,2)
call HGT_OLR(G2H2(144),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G2H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(145),[G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(434)])
call HGT_OLR(G2H2(148),1,1,2)
call HGT_invQ_OLR(G2H2(148),2,5,2)
call HGT_OLR(G2H2(148),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G2H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(149),[G1H2(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G1H2(438)])
call HGT_OLR(G2H2(152),1,1,2)
call HGT_invQ_OLR(G2H2(152),2,5,2)
call HGT_OLR(G2H2(152),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G2H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(153),[G1H2(409)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G1H2(442)])
call HGT_OLR(G2H2(156),1,1,2)
call HGT_invQ_OLR(G2H2(156),2,5,2)
call HGT_OLR(G2H2(156),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(156),[G2H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(157),[G1H2(413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G2H2(1),G2H2(185),G2H2(161),G1H2(435),G1H2(417)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(5),G2H2(179),G2H2(165),G1H2(432),G1H2(421)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G2H2(67),G2H2(191),G2H2(169),G1H2(443),G1H2(425)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(9),G2H2(188),G2H2(173),G1H2(439),G1H2(429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(180),[G1H2(303),G1H2(40)])
call HGT_w2_OLR(G1H2(260),1,1,2)
call HGT_w2_invQ_OLR(G1H2(260),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(260),[G1H2(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(267),[G1H2(322),G1H2(12)])
call HGT_w2_OLR(G1H2(9),1,1,2)
call HGT_w2_invQ_OLR(G1H2(9),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(101),[G1H2(133)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(74)])
call HGT_w2_OLR(G1H2(250),1,1,2)
call HGT_w2_invQ_OLR(G1H2(250),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(250),[G1H2(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(183),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(211),[G1H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(125),[G1H2(317),G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(378),G1H2(373),G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(130),[G1H2(370),G1H2(320),G1H2(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(150),[G1H2(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(325),G1H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(336),[G1H2(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(369),G1H2(328),G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(374),[G1H2(339),G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(202),[G1H2(342),G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(123),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(207),[G1H2(350),G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(134),[G1H2(387),G1H2(253),G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(218),[G1H2(382),G1H2(353),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(356),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(185),[G1H2(306),G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(364),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(190),[G1H2(381),G1H2(309),G1H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(270),[G1H2(367),G1H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(298),[G1H2(293),G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(187),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(135),[G1H2(402),G1H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(294),[G1H2(284),G1H2(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(299),[G1H2(289),G1H2(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(288),[G1H2(283),G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(352),G1H2(349),G1H2(346),G1H2(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G1H2(366),G1H2(363),G1H2(360),G1H2(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(104),G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(49),G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(201),[G1H2(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(223),[G1H2(393),G1H2(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(392),G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(57),[G1H2(401)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(404)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(412)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(416)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(424)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(428)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(155),[G1H2(232),G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(177),G1H2(144)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(141),ex2(:),G2tensor(2),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(119),ex2(:),G2tensor(4),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(461))
  call Hloop_QV_A(ntryL,G1H2(102),ex3(:),G1H1(1),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(462))
  call Hloop_QV_A(ntryL,G2H2(122),ex3(:),G2H1(1),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(19),n2h1(463))
  call Hloop_QV_A(ntryL,G2H2(113),ex4(:),G2H1(1),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(20),n2h1(464))
  call Hloop_QV_A(ntryL,G2H2(126),ex4(:),G2H1(1),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(21),n2h1(465))
  call Hloop_QV_A(ntryL,G2H2(127),ex3(:),G2H1(1),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(22),n2h1(466))
  call Hloop_AV_Q(ntryL,G2H2(130),ex3(:),G2H1(1),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(23),n2h1(467))
  call Hloop_AV_Q(ntryL,G2H2(91),ex4(:),G2H1(1),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(24),n2h1(468))
  call Hloop_AV_Q(ntryL,G2H2(134),ex4(:),G2H1(1),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(25),n2h1(469))
  call Hloop_AV_Q(ntryL,G2H2(135),ex3(:),G2H1(1),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(26),n2h1(470))
  call Hloop_QV_A(ntryL,G2H2(3),ex4(:),G2H1(1),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(27),n2h1(471))
  call Hloop_QV_A(ntryL,G2H2(15),ex3(:),G2H1(1),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(28),n2h1(472))
  call Hloop_QV_A(ntryL,G2H2(144),ex4(:),G2H1(1),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(29),n2h1(473))
  call Hloop_QV_A(ntryL,G2H2(145),ex3(:),G2H1(1),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(30),n2h1(474))
  call Hloop_AV_Q(ntryL,G2H2(148),ex4(:),G2H1(1),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(31),n2h1(475))
  call Hloop_AV_Q(ntryL,G2H2(149),ex3(:),G2H1(1),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(32),n2h1(476))
  call Hloop_QV_A(ntryL,G2H2(152),ex4(:),G2H1(1),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(33),n2h1(477))
  call Hloop_QV_A(ntryL,G2H2(153),ex3(:),G2H1(1),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(34),n2h1(478))
  call Hloop_AV_Q(ntryL,G2H2(156),ex4(:),G2H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(35),n2h1(479))
  call Hloop_AV_Q(ntryL,G2H2(157),ex3(:),G2H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(36),n2h1(480))
call HGT_OLR(G2H2(160),1,1,2)
call HGT_invQ_OLR(G2H2(160),2,5,2)
call HGT_OLR(G2H2(160),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(160),ex3(:),G2H1(1),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(37),n2h1(481))
  call Hloop_AV_Q(ntryL,G2H2(71),ex4(:),G2H1(1),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(38),n2h1(482))
call HGT_OLR(G2H2(164),1,1,2)
call HGT_invQ_OLR(G2H2(164),2,5,2)
call HGT_OLR(G2H2(164),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(164),ex3(:),G2H1(1),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(39),n2h1(483))
  call Hloop_QV_A(ntryL,G2H2(87),ex4(:),G2H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(40),n2h1(484))
call HGT_OLR(G2H2(168),1,1,2)
call HGT_invQ_OLR(G2H2(168),2,5,2)
call HGT_OLR(G2H2(168),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(168),ex3(:),G2H1(1),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(41),n2h1(485))
  call Hloop_AV_Q(ntryL,G2H2(114),ex4(:),G2H1(1),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(42),n2h1(486))
call HGT_OLR(G2H2(172),1,1,2)
call HGT_invQ_OLR(G2H2(172),2,5,2)
call HGT_OLR(G2H2(172),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(172),ex3(:),G2H1(1),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(43),n2h1(487))
  call Hloop_QV_A(ntryL,G2H2(98),ex4(:),G2H1(1),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(44),n2h1(488))
call HGT_OLR(G2H4(29),1,1,4)
call HGT_invQ_OLR(G2H4(29),2,5,4)
call HGT_OLR(G2H4(29),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(29),wf4(:,13),G2H1(1),m3h4x1(:,39),heltab2x4(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(45),n2h1(489))
call HGT_OLR(G2H4(32),1,1,4)
call HGT_invQ_OLR(G2H4(32),2,5,4)
call HGT_OLR(G2H4(32),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(32),wf4(:,13),G2H1(1),m3h4x1(:,40),heltab2x4(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(46),n2h1(490))
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(1),wf4(:,13),G2H1(1),m3h4x1(:,41),heltab2x4(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(47),n2h1(491))
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(2),wf4(:,13),G2H1(1),m3h4x1(:,42),heltab2x4(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(48),n2h1(492))
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(4),wf4(:,13),G2H1(1),m3h4x1(:,43),heltab2x4(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(49),n2h1(493))
call HGT_OLR(G2H4(6),1,1,4)
call HGT_invQ_OLR(G2H4(6),2,5,4)
call HGT_OLR(G2H4(6),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(6),wf4(:,13),G2H1(1),m3h4x1(:,44),heltab2x4(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(50),n2h1(494))
  call Hloop_AV_Q(ntryL,G1H2(260),ex4(:),G1H1(1),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(495))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(8),wf4(:,3),G2tensor(9),m3h4x1(:,45),heltab2x4(:,:,339))
  call Hloop_QV_A(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(496))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(21),wf4(:,10),G2tensor(10),m3h4x1(:,46),heltab2x4(:,:,340))
  call Hloop_AV_Q(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(497))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(12),wf4(:,9),G2tensor(13),m3h4x1(:,47),heltab2x4(:,:,341))
  call Hloop_QV_A(ntryL,G1H2(250),ex3(:),G1H1(1),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(498))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(11),wf4(:,4),G2tensor(17),m3h4x1(:,48),heltab2x4(:,:,342))
  call Hloop_VA_Q(ntryL,G1H2(266),ex2(:),G1H1(1),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(499))
  call Hloop_VA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(500))
  call Hloop_ZA_Q(ntryL,G1H2(47),ex2(:),G1H1(1),ngZd,m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(501))
  call Hloop_ZA_Q(ntryL,G1H2(48),ex2(:),G1H1(1),ngZd,m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(502))
  call Hloop_WA_Q(ntryL,G1H2(59),ex2(:),G1H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(503))
  call Hloop_WA_Q(ntryL,G1H2(183),ex2(:),G1H1(1),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(504))
  call Hloop_QV_A(ntryL,G1H2(211),ex3(:),G1H1(1),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(505))
  call Hloop_QV_A(ntryL,G1H2(125),ex4(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(506))
  call Hloop_QV_A(ntryL,G1H2(45),ex3(:),G1H1(1),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(507))
  call Hloop_QV_A(ntryL,G1H2(130),ex4(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(508))
  call Hloop_VQ_A(ntryL,G1H2(191),ex1(:),G1H1(1),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(509))
  call Hloop_VQ_A(ntryL,G1H2(196),ex1(:),G1H1(1),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(510))
  call Hloop_ZQ_A(ntryL,G1H2(229),ex1(:),G1H1(1),ngZd,m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(511))
  call Hloop_ZQ_A(ntryL,G1H2(234),ex1(:),G1H1(1),ngZd,m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(512))
  call Hloop_WQ_A(ntryL,G1H2(246),ex1(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(513))
  call Hloop_WQ_A(ntryL,G1H2(150),ex1(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(514))
  call Hloop_QV_A(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(56),n2h1(515))
  call Hloop_QV_A(ntryL,G1H2(336),ex3(:),G1H1(1),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(60),n2h1(516))
  call Hloop_QV_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(517))
  call Hloop_QV_A(ntryL,G1H2(374),ex3(:),G1H1(1),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(518))
  call Hloop_AV_Q(ntryL,G1H2(202),ex4(:),G1H1(1),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(519))
  call Hloop_AV_Q(ntryL,G1H2(123),ex3(:),G1H1(1),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(520))
  call Hloop_AV_Q(ntryL,G1H2(207),ex4(:),G1H1(1),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(521))
  call Hloop_AV_Q(ntryL,G1H2(134),ex3(:),G1H1(1),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(72),n2h1(522))
  call Hloop_AV_Q(ntryL,G1H2(218),ex4(:),G1H1(1),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(76),n2h1(523))
  call Hloop_AV_Q(ntryL,G1H2(356),ex3(:),G1H1(1),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(80),n2h1(524))
  call Hloop_AV_Q(ntryL,G1H2(185),ex4(:),G1H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(84),n2h1(525))
  call Hloop_AV_Q(ntryL,G1H2(364),ex3(:),G1H1(1),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(526))
  call Hloop_AV_Q(ntryL,G1H2(190),ex4(:),G1H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(88),n2h1(527))
  call Hloop_AV_Q(ntryL,G1H2(270),ex3(:),G1H1(1),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(528))
  call Hloop_WQ_A(ntryL,G1H2(142),ex1(:),G1H1(1),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(529))
  call Hloop_WQ_A(ntryL,G1H2(154),ex1(:),G1H1(1),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(530))
  call Hloop_WQ_A(ntryL,G1H2(182),ex1(:),G1H1(1),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(163),n2h1(531))
  call Hloop_WA_Q(ntryL,G1H2(298),ex2(:),G1H1(1),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(304),n2h1(532))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(14),23,ex4(:),8,G3tensor(51),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(135),23,ex4(:),8,G2tensor(322),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hloop_WA_Q(ntryL,G1H2(294),ex2(:),G1H1(1),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(132),n2h1(533))
  call Hloop_WA_Q(ntryL,G1H2(299),ex2(:),G1H1(1),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(133),n2h1(534))
  call Hloop_WA_Q(ntryL,G1H2(288),ex2(:),G1H1(1),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(138),n2h1(535))
  call Hloop_WA_Q(ntryL,G1H2(254),ex2(:),G1H1(1),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(140),n2h1(536))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(272),27,ex3(:),4,G2tensor(142),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(273),27,ex3(:),4,G2tensor(144),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hloop_AV_Q(ntryL,G2H2(19),ex4(:),G2H1(1),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(52),n2h1(537))
  call Hloop_AV_Q(ntryL,G2H2(75),ex3(:),G2H1(1),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(53),n2h1(538))
  call Hloop_WQ_A(ntryL,G1H4(8),wf4(:,3),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(146),n2h1(539))
  call Hloop_WQ_A(ntryL,G1H4(14),wf4(:,3),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(147),n2h1(540))
  call Hloop_WA_Q(ntryL,G1H4(32),wf4(:,10),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(150),n2h1(541))
  call Hloop_WA_Q(ntryL,G1H4(26),wf4(:,10),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(415),n2h1(542))
  call Hloop_WQ_A(ntryL,G1H4(97),wf4(:,9),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(421),n2h1(543))
  call Hloop_WQ_A(ntryL,G1H4(79),wf4(:,9),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(427),n2h1(544))
  call Hloop_VQ_A(ntryL,G1H4(62),wf4(:,9),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(433),n2h1(545))
  call Hloop_VQ_A(ntryL,G1H4(68),wf4(:,9),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(439),n2h1(546))
  call Hloop_ZQ_A(ntryL,G1H4(86),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,57),heltab2x4(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(445),n2h1(547))
  call Hloop_ZQ_A(ntryL,G1H4(73),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,58),heltab2x4(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(158),n2h1(548))
  call Hloop_WQ_A(ntryL,G1H4(110),wf4(:,9),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(154),n2h1(549))
  call Hloop_WA_Q(ntryL,G1H4(109),wf4(:,4),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(265),n2h1(550))
  call Hloop_WA_Q(ntryL,G1H4(56),wf4(:,4),G1H1(1),m3h4x1(:,61),heltab2x4(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(391),n2h1(551))
  call Hloop_VA_Q(ntryL,G1H4(4),wf4(:,4),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(274),n2h1(552))
  call Hloop_VA_Q(ntryL,G1H4(37),wf4(:,4),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(376),n2h1(553))
  call Hloop_ZA_Q(ntryL,G1H4(19),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,64),heltab2x4(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(160),n2h1(554))
  call Hloop_ZA_Q(ntryL,G1H4(44),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,65),heltab2x4(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(394),n2h1(555))
  call Hloop_WA_Q(ntryL,G1H4(24),wf4(:,4),G1H1(1),m3h4x1(:,66),heltab2x4(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(166),n2h1(556))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(201),23,ex4(:),8,G2tensor(397),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(223),23,ex4(:),8,G2tensor(169),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(10),23,ex4(:),8,G3tensor(54),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(396),27,ex3(:),4,G2tensor(400),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(397),27,ex3(:),4,G2tensor(172),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(57),23,ex4(:),8,G2tensor(49),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hloop_QV_A(ntryL,G2H2(23),ex3(:),G2H1(1),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(55),n2h1(557))
  call Hloop_AV_Q(ntryL,G2H2(35),ex3(:),G2H1(1),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(56),n2h1(558))
  call Hloop_QV_A(ntryL,G2H2(31),ex3(:),G2H1(1),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(57),n2h1(559))
  call Hloop_AV_Q(ntryL,G2H2(27),ex3(:),G2H1(1),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(58),n2h1(560))
  call Hloop_AV_Q(ntryL,G2H2(17),ex4(:),G2H1(1),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(59),n2h1(561))
  call Hloop_QV_A(ntryL,G2H2(39),ex4(:),G2H1(1),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(60),n2h1(562))
  call Hloop_AV_Q(ntryL,G2H2(21),ex4(:),G2H1(1),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(61),n2h1(563))
  call Hloop_QV_A(ntryL,G2H2(43),ex4(:),G2H1(1),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(62),n2h1(564))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(178),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(53),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(3),wf4(:,3),G2tensor(184),m3h4x1(:,67),heltab2x4(:,:,361))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(31),wf4(:,10),G2tensor(57),m3h4x1(:,68),heltab2x4(:,:,362))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(25),wf4(:,9),G2tensor(190),m3h4x1(:,69),heltab2x4(:,:,363))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(27),wf4(:,4),G2tensor(382),m3h4x1(:,70),heltab2x4(:,:,364))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(38),ex4(:),ex3(:),G1tensor(25),m4h2x2x1(:,1),heltab3x4(:,:,1))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(31),ex4(:),ex3(:),G1tensor(55),m4h2x2x1(:,2),heltab3x4(:,:,2))
  call Hloop_VQ_A(ntryL,G1H8(4),wf8(:,37),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(196),n2h1(565))
  call Hloop_ZQ_A(ntryL,G1H8(28),wf8(:,37),G1H1(1),ngZd,m3h8x1(:,2),heltab2x8(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(385),n2h1(566))
  call Hloop_WQ_A(ntryL,G1H8(30),wf8(:,37),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(199),n2h1(567))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(7),wf8(:,37),G2tensor(388),m3h8x1(:,4),heltab2x8(:,:,160))
  call Hloop_VA_Q(ntryL,G1H8(32),wf8(:,42),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(202),n2h1(568))
  call Hloop_ZA_Q(ntryL,G1H8(33),wf8(:,42),G1H1(1),ngZd,m3h8x1(:,6),heltab2x8(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(208),n2h1(569))
  call Hloop_WA_Q(ntryL,G1H8(35),wf8(:,42),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(214),n2h1(570))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(8),wf8(:,42),G2tensor(220),m3h8x1(:,8),heltab2x8(:,:,164))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H4(13),wf4(:,9),G2tensor(73),ngZd,m3h4x1(:,71),heltab2x4(:,:,365))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(14),wf4(:,9),G2tensor(226),m3h4x1(:,72),heltab2x4(:,:,366))
  call Hloop_QV_A(ntryL,G2H8(9),wf8(:,52),G2H1(1),m3h8x1(:,9),heltab2x8(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(63),n2h1(571))
  call Hloop_QV_A(ntryL,G2H8(10),wf8(:,52),G2H1(1),m3h8x1(:,10),heltab2x8(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(64),n2h1(572))
  call Hloop_AV_Q(ntryL,G2H8(11),wf8(:,52),G2H1(1),m3h8x1(:,11),heltab2x8(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(65),n2h1(573))
  call Hloop_AV_Q(ntryL,G2H8(12),wf8(:,52),G2H1(1),m3h8x1(:,12),heltab2x8(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(66),n2h1(574))
  call Hloop_QV_A(ntryL,G2H8(13),wf8(:,52),G2H1(1),m3h8x1(:,13),heltab2x8(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(67),n2h1(575))
  call Hloop_AV_Q(ntryL,G2H8(14),wf8(:,52),G2H1(1),m3h8x1(:,14),heltab2x8(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(68),n2h1(576))
  call Hloop_VQ_A(ntryL,G1H8(45),wf8(:,46),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(577))
  call Hloop_ZQ_A(ntryL,G1H8(46),wf8(:,46),G1H1(1),ngZd,m3h8x1(:,16),heltab2x8(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(232),n2h1(578))
  call Hloop_WQ_A(ntryL,G1H8(47),wf8(:,46),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(579))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(15),wf8(:,46),G2tensor(238),m3h8x1(:,18),heltab2x8(:,:,174))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(178),27,ex3(:),4,G2tensor(244),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H4(15),wf4(:,4),G2tensor(250),ngZd,m3h4x1(:,73),heltab2x4(:,:,367))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(16),wf4(:,4),G2tensor(256),m3h4x1(:,74),heltab2x4(:,:,368))
  call Hloop_QV_A(ntryL,G2H8(16),wf8(:,53),G2H1(1),m3h8x1(:,19),heltab2x8(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(69),n2h1(580))
  call Hloop_QV_A(ntryL,G2H8(1),wf8(:,53),G2H1(1),m3h8x1(:,20),heltab2x8(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(70),n2h1(581))
  call Hloop_AV_Q(ntryL,G2H8(2),wf8(:,53),G2H1(1),m3h8x1(:,21),heltab2x8(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(71),n2h1(582))
  call Hloop_AV_Q(ntryL,G2H8(3),wf8(:,53),G2H1(1),m3h8x1(:,22),heltab2x8(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(72),n2h1(583))
  call Hloop_QV_A(ntryL,G2H8(4),wf8(:,53),G2H1(1),m3h8x1(:,23),heltab2x8(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(73),n2h1(584))
  call Hloop_AV_Q(ntryL,G2H8(5),wf8(:,53),G2H1(1),m3h8x1(:,24),heltab2x8(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(74),n2h1(585))
  call Hloop_VA_Q(ntryL,G1H8(8),wf8(:,48),G1H1(1),m3h8x1(:,25),heltab2x8(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(379),n2h1(586))
  call Hloop_ZA_Q(ntryL,G1H8(10),wf8(:,48),G1H1(1),ngZd,m3h8x1(:,26),heltab2x8(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(259),n2h1(587))
  call Hloop_WA_Q(ntryL,G1H8(12),wf8(:,48),G1H1(1),m3h8x1(:,27),heltab2x8(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(373),n2h1(588))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(6),wf8(:,48),G2tensor(262),m3h8x1(:,28),heltab2x8(:,:,184))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(34),27,ex3(:),4,G2tensor(271),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hloop_AV_Q(ntryL,G2H2(105),ex4(:),G2H1(1),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(75),n2h1(589))
  call Hloop_AV_Q(ntryL,G2H2(101),ex4(:),G2H1(1),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(76),n2h1(590))
  call Hloop_AV_Q(ntryL,G2H2(100),ex4(:),G2H1(1),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(77),n2h1(591))
  call Hloop_QV_A(ntryL,G2H2(69),ex4(:),G2H1(1),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(78),n2h1(592))
  call Hloop_QV_A(ntryL,G2H2(72),ex4(:),G2H1(1),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(79),n2h1(593))
  call Hloop_QV_A(ntryL,G2H2(77),ex4(:),G2H1(1),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(80),n2h1(594))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(80),23,ex4(:),8,G3tensor(81),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(2),23,ex4(:),8,G3tensor(82),m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(181),23,ex4(:),G3tensor(83),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(6),23,ex4(:),8,G3tensor(84),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(155),ex4(:),G1tensor(85),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(21),ex4(:),G1tensor(115),m3h2x1(:,568),heltab2x2(:,:,568))
  call ol_merge_tensors(G2tensor(395),[G2tensor(161),G2tensor(14),G1tensor(38),G1tensor(24),G0tensor(46),G0tensor(41)])
  call ol_merge_tensors(G2tensor(398),[G2tensor(167),G2tensor(18),G1tensor(60),G1tensor(50),G0tensor(56),G0tensor(51)])
  call ol_merge_tensors(G2tensor(413),[G2tensor(401),G2tensor(170),G2tensor(22),G1tensor(518),G1tensor(69),G1tensor(74) &
    ,G0tensor(491),G0tensor(66),G0tensor(61)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(203),G2tensor(173),G2tensor(50),G2tensor(26),G1tensor(76),G1tensor(23) &
    ,G1tensor(132),G1tensor(102),G0tensor(131),G0tensor(102),G0tensor(76),G0tensor(71)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(209),G2tensor(179),G2tensor(54),G2tensor(30),G1tensor(88),G1tensor(29) &
    ,G1tensor(140),G1tensor(33),G0tensor(136),G0tensor(112),G0tensor(86),G0tensor(81)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(215),G2tensor(185),G2tensor(58),G2tensor(34),G1tensor(93),G1tensor(47),G1tensor(81) &
    ,G1tensor(2),G0tensor(141),G0tensor(122),G0tensor(96),G0tensor(91)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(383),G2tensor(191),G2tensor(38),G1tensor(243),G1tensor(238),G1tensor(28) &
    ,G1tensor(16),G0tensor(252),G0tensor(247),G0tensor(106),G0tensor(101)])
  call ol_merge_tensors(G2tensor(386),[G2tensor(197),G2tensor(42),G1tensor(112),G1tensor(35),G0tensor(116),G0tensor(111)])
  call ol_merge_tensors(G2tensor(404),[G2tensor(389),G2tensor(200),G2tensor(46),G1tensor(513),G1tensor(137),G1tensor(46) &
    ,G0tensor(486),G0tensor(126),G0tensor(121)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(239),G2tensor(221),G2tensor(74),G2tensor(62),G1tensor(167),G1tensor(117) &
    ,G1tensor(105),G1tensor(26),G0tensor(176),G0tensor(151),G0tensor(146),G0tensor(42)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(245),G2tensor(227),G2tensor(78),G2tensor(66),G1tensor(172),G1tensor(147) &
    ,G1tensor(155),G1tensor(90),G0tensor(181),G0tensor(161),G0tensor(156),G0tensor(52)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(251),G2tensor(233),G2tensor(82),G2tensor(70),G1tensor(177),G1tensor(162) &
    ,G1tensor(157),G1tensor(78),G0tensor(186),G0tensor(171),G0tensor(166),G0tensor(62)])
  call ol_merge_tensors(G2tensor(244),[G2tensor(407),G2tensor(380),G2tensor(257),G2tensor(86),G1tensor(457),G1tensor(187) &
    ,G1tensor(182),G0tensor(466),G0tensor(196),G0tensor(191)])
  call ol_merge_tensors(G2tensor(397),[G2tensor(410),G2tensor(374),G2tensor(260),G2tensor(90),G1tensor(514),G1tensor(462) &
    ,G1tensor(197),G1tensor(192),G0tensor(487),G0tensor(471),G0tensor(206),G0tensor(201)])
  call ol_merge_tensors(G2tensor(271),[G2tensor(392),G2tensor(266),G2tensor(263),G2tensor(95),G2tensor(94),G1tensor(202) &
    ,G1tensor(121),G1tensor(91),G0tensor(211),G0tensor(26),G0tensor(21)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(377),G2tensor(275),G2tensor(272),G2tensor(100),G2tensor(99),G1tensor(519) &
    ,G1tensor(207),G1tensor(150),G1tensor(151),G0tensor(492),G0tensor(216),G0tensor(36),G0tensor(31)])
  call ol_merge_tensors(G2tensor(282),[G2tensor(279),G2tensor(11),G2tensor(3),G1tensor(235),G1tensor(227),G1tensor(215) &
    ,G1tensor(114),G0tensor(244),G0tensor(236),G0tensor(224),G0tensor(77)])
  call ol_merge_tensors(G2tensor(262),[G2tensor(379),G2tensor(220),G2tensor(202),G2tensor(243),G2tensor(225),G2tensor(159) &
    ,G2tensor(155),G2tensor(110),G2tensor(104),G2tensor(5),G1tensor(405),G1tensor(375),G1tensor(230),G1tensor(125),G1tensor(79) &
    ,G1tensor(49),G0tensor(414),G0tensor(384),G0tensor(239),G0tensor(154),G0tensor(19),G0tensor(14)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(278),G2tensor(8),G1tensor(212),G1tensor(104),G1tensor(31),G0tensor(221) &
    ,G0tensor(72),G0tensor(11)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(281),G2tensor(15),G1tensor(323),G1tensor(232),G1tensor(130),G1tensor(61) &
    ,G0tensor(332),G0tensor(241),G0tensor(132),G0tensor(16)])
  call ol_merge_tensors(G2tensor(274),[G2tensor(242),G2tensor(240),G2tensor(19),G1tensor(402),G1tensor(170),G1tensor(42) &
    ,G0tensor(411),G0tensor(179),G0tensor(47)])
  call ol_merge_tensors(G2tensor(376),[G2tensor(17),G2tensor(297),G2tensor(127),G2tensor(23),G1tensor(275),G1tensor(225) &
    ,G1tensor(44),G1tensor(43),G0tensor(284),G0tensor(234),G0tensor(48),G0tensor(13)])
  call ol_merge_tensors(G3tensor(71),[G3tensor(69),G3tensor(65),G3tensor(63),G3tensor(3),G3tensor(1),G2tensor(402),G2tensor(399) &
    ,G2tensor(396),G2tensor(390),G2tensor(387),G2tensor(384),G2tensor(195),G2tensor(165),G1tensor(280),G1tensor(70),G1tensor(58) &
    ,G1tensor(65),G1tensor(98),G1tensor(68),G1tensor(84),G0tensor(289),G0tensor(129),G0tensor(119),G0tensor(109),G0tensor(69) &
    ,G0tensor(59),G0tensor(49)])
  call ol_merge_tensors(G2tensor(160),[G2tensor(248),G2tensor(246),G2tensor(27),G1tensor(412),G1tensor(175),G1tensor(62) &
    ,G0tensor(421),G0tensor(184),G0tensor(57)])
  call ol_merge_tensors(G2tensor(394),[G2tensor(300),G2tensor(31),G1tensor(285),G1tensor(66),G0tensor(294),G0tensor(58)])
  call ol_merge_tensors(G2tensor(166),[G2tensor(273),G2tensor(254),G2tensor(252),G2tensor(35),G1tensor(422),G1tensor(210) &
    ,G1tensor(180),G1tensor(92),G0tensor(431),G0tensor(219),G0tensor(189),G0tensor(67)])
  call ol_merge_tensors(G2tensor(391),[G2tensor(303),G2tensor(288),G2tensor(120),G2tensor(39),G1tensor(290),G1tensor(255) &
    ,G1tensor(75),G1tensor(133),G0tensor(299),G0tensor(264),G0tensor(68),G0tensor(28)])
  call ol_merge_tensors(G3tensor(6),[G3tensor(5),G3tensor(4),G3tensor(2),G2tensor(348),G2tensor(336),G2tensor(324),G2tensor(306) &
    ,G1tensor(340),G1tensor(295),G1tensor(164),G1tensor(154),G1tensor(123),G1tensor(9),G1tensor(146),G1tensor(116),G0tensor(349) &
    ,G0tensor(304),G0tensor(173),G0tensor(163),G0tensor(153),G0tensor(98),G0tensor(88),G0tensor(78)])
  call ol_merge_tensors(G2tensor(238),[G2tensor(77),G2tensor(388),G2tensor(196),G2tensor(207),G2tensor(177),G2tensor(157) &
    ,G2tensor(153),G2tensor(87),G2tensor(43),G1tensor(511),G1tensor(506),G1tensor(345),G1tensor(300),G1tensor(27),G0tensor(484) &
    ,G0tensor(479),G0tensor(354),G0tensor(309),G0tensor(79)])
  call ol_merge_tensors(G2tensor(327),[G2tensor(309),G2tensor(91),G2tensor(47),G1tensor(350),G1tensor(305),G1tensor(144) &
    ,G0tensor(359),G0tensor(314),G0tensor(87)])
  call ol_merge_tensors(G2tensor(232),[G2tensor(385),G2tensor(213),G2tensor(183),G2tensor(96),G2tensor(51),G1tensor(355) &
    ,G1tensor(310),G1tensor(152),G0tensor(364),G0tensor(319),G0tensor(89)])
  call ol_merge_tensors(G2tensor(330),[G2tensor(312),G2tensor(101),G2tensor(55),G1tensor(360),G1tensor(315),G1tensor(8) &
    ,G0tensor(369),G0tensor(324),G0tensor(97)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(199),G2tensor(381),G2tensor(375),G2tensor(219),G2tensor(189),G2tensor(102) &
    ,G2tensor(59),G1tensor(365),G1tensor(320),G1tensor(200),G1tensor(190),G1tensor(10),G0tensor(374),G0tensor(329),G0tensor(209) &
    ,G0tensor(199),G0tensor(99)])
  call ol_merge_tensors(G2tensor(433),[G2tensor(206),G2tensor(204),G2tensor(63),G1tensor(342),G1tensor(118),G1tensor(77) &
    ,G0tensor(351),G0tensor(134),G0tensor(107)])
  call ol_merge_tensors(G2tensor(439),[G2tensor(13),G2tensor(315),G2tensor(67),G1tensor(510),G1tensor(325),G1tensor(71) &
    ,G0tensor(483),G0tensor(334),G0tensor(108)])
  call ol_merge_tensors(G2tensor(445),[G2tensor(212),G2tensor(210),G2tensor(71),G1tensor(352),G1tensor(87),G1tensor(106) &
    ,G0tensor(361),G0tensor(139),G0tensor(117)])
  call ol_merge_tensors(G2tensor(158),[G2tensor(318),G2tensor(75),G1tensor(330),G1tensor(100),G0tensor(339),G0tensor(118)])
  call ol_merge_tensors(G2tensor(154),[G2tensor(261),G2tensor(218),G2tensor(216),G2tensor(79),G1tensor(362),G1tensor(195) &
    ,G1tensor(99),G1tensor(59),G0tensor(371),G0tensor(204),G0tensor(144),G0tensor(127)])
  call ol_merge_tensors(G2tensor(427),[G2tensor(321),G2tensor(83),G1tensor(335),G1tensor(189),G1tensor(64),G0tensor(344) &
    ,G0tensor(198),G0tensor(128)])
  call ol_merge_tensors(G2tensor(345),[G2tensor(333),G2tensor(109),G2tensor(103),G1tensor(400),G1tensor(370),G1tensor(119) &
    ,G0tensor(409),G0tensor(379),G0tensor(152)])
  call ol_merge_tensors(G2tensor(351),[G2tensor(339),G2tensor(111),G2tensor(105),G1tensor(410),G1tensor(380),G1tensor(153) &
    ,G0tensor(419),G0tensor(389),G0tensor(162)])
  call ol_merge_tensors(G2tensor(259),[G2tensor(208),G2tensor(249),G2tensor(231),G2tensor(112),G2tensor(106),G1tensor(415) &
    ,G1tensor(385),G1tensor(1),G0tensor(424),G0tensor(394),G0tensor(164)])
  call ol_merge_tensors(G2tensor(354),[G2tensor(342),G2tensor(113),G2tensor(107),G1tensor(420),G1tensor(390),G1tensor(163) &
    ,G0tensor(429),G0tensor(399),G0tensor(172)])
  call ol_merge_tensors(G2tensor(373),[G2tensor(214),G2tensor(393),G2tensor(378),G2tensor(270),G2tensor(255),G2tensor(237) &
    ,G2tensor(121),G2tensor(114),G2tensor(108),G1tensor(425),G1tensor(395),G1tensor(260),G1tensor(165),G1tensor(20),G1tensor(139) &
    ,G0tensor(434),G0tensor(404),G0tensor(269),G0tensor(174),G0tensor(39),G0tensor(29)])
  call ol_merge_tensors(G2tensor(421),[G2tensor(357),G2tensor(115),G1tensor(430),G1tensor(188),G0tensor(439),G0tensor(197)])
  call ol_merge_tensors(G2tensor(146),[G2tensor(360),G2tensor(116),G1tensor(435),G1tensor(198),G0tensor(444),G0tensor(207)])
  call ol_merge_tensors(G2tensor(147),[G2tensor(363),G2tensor(117),G1tensor(440),G1tensor(199),G0tensor(449),G0tensor(208)])
  call ol_merge_tensors(G2tensor(265),[G2tensor(366),G2tensor(285),G2tensor(119),G2tensor(118),G1tensor(445),G1tensor(250) &
    ,G1tensor(127),G0tensor(454),G0tensor(259),G0tensor(27)])
  call ol_merge_tensors(G2tensor(150),[G2tensor(369),G2tensor(291),G2tensor(124),G2tensor(122),G1tensor(450),G1tensor(265) &
    ,G1tensor(18),G0tensor(459),G0tensor(274),G0tensor(37)])
  call ol_merge_tensors(G2tensor(415),[G2tensor(372),G2tensor(294),G2tensor(125),G2tensor(123),G1tensor(455),G1tensor(270) &
    ,G1tensor(19),G0tensor(464),G0tensor(279),G0tensor(38)])
  call ol_merge_tensors(G2tensor(382),[G2tensor(126),G1tensor(220),G1tensor(37),G0tensor(229),G0tensor(12)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(128),G1tensor(240),G1tensor(67),G0tensor(249),G0tensor(17)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(129),G1tensor(245),G1tensor(73),G0tensor(254),G0tensor(18)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(11),G3tensor(8),G3tensor(7),G2tensor(432),G2tensor(429),G2tensor(420),G2tensor(417) &
    ,G1tensor(536),G1tensor(526),G0tensor(509),G0tensor(499)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(13),G3tensor(10),G3tensor(9),G2tensor(438),G2tensor(435),G2tensor(426) &
    ,G2tensor(423),G1tensor(541),G1tensor(531),G0tensor(514),G0tensor(504)])
  call ol_merge_tensors(G3tensor(72),[G3tensor(70),G3tensor(66),G3tensor(64),G3tensor(16),G3tensor(15),G2tensor(444),G2tensor(441) &
    ,G1tensor(546),G0tensor(519)])
  call ol_merge_tensors(G3tensor(74),[G3tensor(73),G3tensor(68),G3tensor(67),G3tensor(18),G3tensor(17),G2tensor(450),G2tensor(447) &
    ,G1tensor(551),G0tensor(524)])
  call ol_merge_tensors(G3tensor(47),[G3tensor(45),G2tensor(201),G2tensor(198),G2tensor(194),G2tensor(192),G2tensor(171) &
    ,G2tensor(168),G2tensor(164),G2tensor(162),G1tensor(277),G1tensor(53),G1tensor(148),G1tensor(21),G1tensor(63),G1tensor(56) &
    ,G1tensor(32),G0tensor(286),G0tensor(124),G0tensor(114),G0tensor(104),G0tensor(64),G0tensor(54),G0tensor(44)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(174),G1tensor(297),G1tensor(108),G0tensor(306),G0tensor(74)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(180),G1tensor(307),G1tensor(134),G0tensor(316),G0tensor(84)])
  call ol_merge_tensors(G2tensor(258),[G2tensor(188),G2tensor(186),G1tensor(317),G1tensor(185),G1tensor(11),G0tensor(326) &
    ,G0tensor(194),G0tensor(94)])
  call ol_merge_tensors(G2tensor(224),[G2tensor(222),G1tensor(372),G1tensor(149),G0tensor(381),G0tensor(149)])
  call ol_merge_tensors(G2tensor(230),[G2tensor(228),G1tensor(382),G1tensor(141),G0tensor(391),G0tensor(159)])
  call ol_merge_tensors(G2tensor(264),[G2tensor(236),G2tensor(234),G1tensor(392),G1tensor(205),G1tensor(160),G0tensor(401) &
    ,G0tensor(214),G0tensor(169)])
  call ol_merge_tensors(G2tensor(276),[G2tensor(269),G2tensor(267),G1tensor(55),G1tensor(257),G1tensor(13),G1tensor(109) &
    ,G0tensor(266),G0tensor(34),G0tensor(24)])
  call ol_merge_tensors(G3tensor(84),[G3tensor(83),G3tensor(82),G3tensor(81),G3tensor(54),G3tensor(51),G2tensor(284),G1tensor(115) &
    ,G1tensor(85),G1tensor(458),G1tensor(247),G1tensor(97),G0tensor(467),G0tensor(256),G0tensor(22)])
  call ol_merge_tensors(G2tensor(322),[G2tensor(287),G1tensor(520),G1tensor(252),G1tensor(103),G0tensor(493),G0tensor(261) &
    ,G0tensor(23)])
  call ol_merge_tensors(G2tensor(400),[G2tensor(142),G2tensor(290),G1tensor(463),G1tensor(262),G1tensor(6),G0tensor(472) &
    ,G0tensor(271),G0tensor(32)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(293),G1tensor(267),G1tensor(12),G0tensor(276),G0tensor(33)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(296),G1tensor(272),G1tensor(30),G0tensor(281),G0tensor(43)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(299),G1tensor(282),G1tensor(54),G0tensor(291),G0tensor(53)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(302),G1tensor(287),G1tensor(204),G1tensor(80),G0tensor(296),G0tensor(213) &
    ,G0tensor(63)])
  call ol_merge_tensors(G3tensor(23),[G3tensor(19),G2tensor(335),G2tensor(305),G1tensor(292),G1tensor(159),G1tensor(135) &
    ,G1tensor(111),G1tensor(4),G1tensor(39),G1tensor(126),G0tensor(301),G0tensor(168),G0tensor(158),G0tensor(148),G0tensor(93) &
    ,G0tensor(83),G0tensor(73)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(308),G1tensor(302),G1tensor(128),G0tensor(311),G0tensor(82)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(311),G1tensor(438),G1tensor(433),G1tensor(312),G1tensor(3),G0tensor(447) &
    ,G0tensor(442),G0tensor(321),G0tensor(92)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(314),G1tensor(322),G1tensor(17),G0tensor(331),G0tensor(103)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(317),G1tensor(327),G1tensor(34),G0tensor(336),G0tensor(113)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(320),G1tensor(332),G1tensor(184),G1tensor(51),G0tensor(341),G0tensor(193) &
    ,G0tensor(123)])
  call ol_merge_tensors(G3tensor(25),[G3tensor(21),G2tensor(347),G2tensor(323),G1tensor(337),G1tensor(278),G1tensor(179) &
    ,G1tensor(174),G1tensor(169),G1tensor(95),G1tensor(83),G1tensor(124),G0tensor(346),G0tensor(287),G0tensor(188),G0tensor(183) &
    ,G0tensor(178),G0tensor(143),G0tensor(138),G0tensor(133)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(326),G1tensor(347),G1tensor(328),G1tensor(82),G0tensor(356),G0tensor(337) &
    ,G0tensor(137)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(329),G1tensor(428),G1tensor(357),G1tensor(333),G1tensor(143),G0tensor(437) &
    ,G0tensor(366),G0tensor(342),G0tensor(142)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(332),G1tensor(508),G1tensor(367),G1tensor(107),G0tensor(481),G0tensor(376) &
    ,G0tensor(147)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(338),G1tensor(377),G1tensor(131),G0tensor(386),G0tensor(157)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(341),G1tensor(453),G1tensor(448),G1tensor(387),G1tensor(158),G0tensor(462) &
    ,G0tensor(457),G0tensor(396),G0tensor(167)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(344),G1tensor(503),G1tensor(397),G1tensor(273),G1tensor(168),G0tensor(476) &
    ,G0tensor(406),G0tensor(282),G0tensor(177)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(350),G1tensor(407),G1tensor(283),G1tensor(173),G0tensor(416),G0tensor(292) &
    ,G0tensor(182)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(353),G1tensor(443),G1tensor(417),G1tensor(288),G1tensor(178),G0tensor(452) &
    ,G0tensor(426),G0tensor(297),G0tensor(187)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(356),G1tensor(427),G1tensor(183),G0tensor(436),G0tensor(192)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(359),G1tensor(432),G1tensor(193),G0tensor(441),G0tensor(202)])
  call ol_merge_tensors(G2tensor(163),[G2tensor(362),G1tensor(437),G1tensor(194),G0tensor(446),G0tensor(203)])
  call ol_merge_tensors(G2tensor(304),[G2tensor(365),G1tensor(442),G1tensor(268),G1tensor(263),G1tensor(203),G0tensor(451) &
    ,G0tensor(277),G0tensor(272),G0tensor(212)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(368),G1tensor(447),G1tensor(253),G1tensor(248),G1tensor(208),G0tensor(456) &
    ,G0tensor(262),G0tensor(257),G0tensor(217)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(371),G1tensor(452),G1tensor(209),G0tensor(461),G0tensor(218)])
  call ol_merge_tensors(G2tensor(256),[G2tensor(405),G1tensor(516),G0tensor(489)])
  call ol_merge_tensors(G2tensor(411),[G2tensor(408),G1tensor(25),G1tensor(465),G1tensor(460),G0tensor(474),G0tensor(469)])
  call ol_merge_tensors(G2tensor(226),[G2tensor(414),G1tensor(521),G0tensor(494)])
  call ol_merge_tensors(G3tensor(31),[G3tensor(29),G2tensor(419),G2tensor(416),G1tensor(544),G1tensor(523),G0tensor(517) &
    ,G0tensor(496)])
  call ol_merge_tensors(G3tensor(35),[G3tensor(33),G2tensor(425),G2tensor(422),G1tensor(549),G1tensor(528),G0tensor(522) &
    ,G0tensor(501)])
  call ol_merge_tensors(G3tensor(39),[G3tensor(37),G2tensor(431),G2tensor(428),G1tensor(533),G0tensor(506)])
  call ol_merge_tensors(G3tensor(43),[G3tensor(41),G2tensor(437),G2tensor(434),G1tensor(538),G0tensor(511)])
  call ol_merge_tensors(G3tensor(48),[G3tensor(46),G2tensor(443),G2tensor(440),G1tensor(543),G0tensor(516)])
  call ol_merge_tensors(G3tensor(50),[G3tensor(49),G2tensor(449),G2tensor(446),G1tensor(548),G0tensor(521)])
  call ol_merge_tensors(G3tensor(52),[G3tensor(27),G1tensor(388),G1tensor(378),G1tensor(368),G1tensor(313),G1tensor(303) &
    ,G1tensor(293),G1tensor(217),G1tensor(213),G0tensor(397),G0tensor(387),G0tensor(377),G0tensor(322),G0tensor(312),G0tensor(302) &
    ,G0tensor(226),G0tensor(222)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(298),G1tensor(222),G1tensor(214),G0tensor(307),G0tensor(231),G0tensor(223)])
  call ol_merge_tensors(G2tensor(178),[G1tensor(223),G1tensor(218),G0tensor(232),G0tensor(227)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(239),G1tensor(228),G1tensor(219),G0tensor(248),G0tensor(237),G0tensor(228)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(244),G1tensor(229),G1tensor(224),G0tensor(253),G0tensor(238),G0tensor(233)])
  call ol_merge_tensors(G3tensor(53),[G3tensor(28),G1tensor(418),G1tensor(408),G1tensor(398),G1tensor(358),G1tensor(348) &
    ,G1tensor(338),G1tensor(237),G1tensor(233),G0tensor(427),G0tensor(417),G0tensor(407),G0tensor(367),G0tensor(357),G0tensor(347) &
    ,G0tensor(246),G0tensor(242)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(343),G1tensor(242),G1tensor(234),G0tensor(352),G0tensor(251),G0tensor(243)])
  call ol_merge_tensors(G2tensor(132),[G1tensor(264),G1tensor(258),G1tensor(249),G0tensor(273),G0tensor(267),G0tensor(258)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(269),G1tensor(259),G1tensor(254),G0tensor(278),G0tensor(268),G0tensor(263)])
  call ol_merge_tensors(G3tensor(24),[G3tensor(20),G1tensor(394),G1tensor(384),G1tensor(374),G1tensor(334),G1tensor(329) &
    ,G1tensor(324),G1tensor(319),G1tensor(309),G1tensor(299),G1tensor(294),G1tensor(289),G1tensor(284),G1tensor(279),G1tensor(274) &
    ,G0tensor(403),G0tensor(393),G0tensor(383),G0tensor(343),G0tensor(338),G0tensor(333),G0tensor(328),G0tensor(318),G0tensor(308) &
    ,G0tensor(303),G0tensor(298),G0tensor(293),G0tensor(288),G0tensor(283)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(308),G1tensor(304),G0tensor(317),G0tensor(313)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(429),G1tensor(318),G1tensor(314),G0tensor(438),G0tensor(327),G0tensor(323)])
  call ol_merge_tensors(G3tensor(26),[G3tensor(22),G1tensor(454),G1tensor(439),G1tensor(424),G1tensor(414),G1tensor(404) &
    ,G1tensor(364),G1tensor(354),G1tensor(344),G1tensor(339),G0tensor(463),G0tensor(448),G0tensor(433),G0tensor(423),G0tensor(413) &
    ,G0tensor(373),G0tensor(363),G0tensor(353),G0tensor(348)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(353),G1tensor(349),G0tensor(362),G0tensor(358)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(434),G1tensor(363),G1tensor(359),G0tensor(443),G0tensor(372),G0tensor(368)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(373),G1tensor(369),G0tensor(382),G0tensor(378)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(383),G1tensor(379),G0tensor(392),G0tensor(388)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(444),G1tensor(393),G1tensor(389),G0tensor(453),G0tensor(402),G0tensor(398)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(403),G1tensor(399),G0tensor(412),G0tensor(408)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(413),G1tensor(409),G0tensor(422),G0tensor(418)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(449),G1tensor(423),G1tensor(419),G0tensor(458),G0tensor(432),G0tensor(428)])
  call ol_merge_tensors(G2tensor(169),[G1tensor(515),G1tensor(459),G0tensor(488),G0tensor(468)])
  call ol_merge_tensors(G2tensor(172),[G1tensor(464),G0tensor(473)])
  call ol_merge_tensors(G1tensor(493),[G1tensor(469)])
  call ol_merge_tensors(G1tensor(474),[G1tensor(470)])
  call ol_merge_tensors(G1tensor(492),[G1tensor(471)])
  call ol_merge_tensors(G1tensor(496),[G1tensor(475)])
  call ol_merge_tensors(G1tensor(486),[G1tensor(478)])
  call ol_merge_tensors(G1tensor(500),[G1tensor(479)])
  call ol_merge_tensors(G1tensor(490),[G1tensor(482)])
  call ol_merge_tensors(G1tensor(497),[G1tensor(485)])
  call ol_merge_tensors(G1tensor(501),[G1tensor(489)])
  call ol_merge_tensors(G2tensor(184),[G1tensor(504),G0tensor(477)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(505),G0tensor(478)])
  call ol_merge_tensors(G2tensor(190),[G1tensor(509),G0tensor(482)])
  call ol_merge_tensors(G3tensor(56),[G3tensor(55),G1tensor(524),G0tensor(497)])
  call ol_merge_tensors(G3tensor(32),[G3tensor(30),G1tensor(525),G0tensor(498)])
  call ol_merge_tensors(G3tensor(58),[G3tensor(57),G1tensor(529),G0tensor(502)])
  call ol_merge_tensors(G3tensor(36),[G3tensor(34),G1tensor(530),G0tensor(503)])
  call ol_merge_tensors(G3tensor(60),[G3tensor(59),G1tensor(534),G0tensor(507)])
  call ol_merge_tensors(G3tensor(40),[G3tensor(38),G1tensor(545),G1tensor(535),G0tensor(518),G0tensor(508)])
  call ol_merge_tensors(G3tensor(62),[G3tensor(61),G1tensor(539),G0tensor(512)])
  call ol_merge_tensors(G3tensor(44),[G3tensor(42),G1tensor(550),G1tensor(540),G0tensor(523),G0tensor(513)])
  call ol_merge_tensors(G3tensor(78),[G3tensor(75)])
  call ol_merge_tensors(G3tensor(79),[G3tensor(76)])
  call ol_merge_tensors(G3tensor(80),[G3tensor(77)])
  call TI_triangle_red(G2tensor(395),RedBasis(64),mass3set(:,1),G0tensor(10),G0tensor(15),G0tensor(20),G0tensor(25),M2L1R1)
  call TI_triangle_red(G2tensor(398),RedBasis(64),mass3set(:,2),G0tensor(30),G0tensor(35),G0tensor(40),G0tensor(45),M2L1R1,[nMZ], &
    G0tensor(50))
  call TI_triangle_red(G2tensor(413),RedBasis(64),mass3set(:,3),G0tensor(55),G0tensor(60),G0tensor(65),G0tensor(70),M2L1R1,[nMW], &
    G0tensor(75))
  call TI_triangle_red(G2tensor(40),RedBasis(62),mass3set(:,1),G0tensor(80),G0tensor(85),G0tensor(90),G0tensor(95),M2L1R1)
  call TI_triangle_red(G2tensor(44),RedBasis(62),mass3set(:,4),G0tensor(100),G0tensor(105),G0tensor(110), &
    G0tensor(115),M2L1R1,[nMZ],G0tensor(120))
  call TI_triangle_red(G2tensor(48),RedBasis(62),mass3set(:,5),G0tensor(125),G0tensor(130),G0tensor(135), &
    G0tensor(140),M2L1R1,[nMW],G0tensor(145))
  call TI_triangle_red(G2tensor(53),RedBasis(9),mass3set(:,1),G0tensor(150),G0tensor(155),G0tensor(160),G0tensor(165),M2L1R1)
  call TI_triangle_red(G2tensor(386),RedBasis(9),mass3set(:,2),G0tensor(170),G0tensor(175),G0tensor(180), &
    G0tensor(185),M2L1R1,[nMZ],G0tensor(190))
  call TI_triangle_red(G2tensor(404),RedBasis(9),mass3set(:,3),G0tensor(195),G0tensor(200),G0tensor(205), &
    G0tensor(210),M2L1R1,[nMW],G0tensor(215))
  call TI_triangle_red(G2tensor(20),RedBasis(58),mass3set(:,1),G0tensor(220),G0tensor(225),G0tensor(230),G0tensor(235),M2L1R1)
  call TI_triangle_red(G2tensor(24),RedBasis(58),mass3set(:,4),G0tensor(240),G0tensor(245),G0tensor(250), &
    G0tensor(255),M2L1R1,[nMZ],G0tensor(260))
  call TI_triangle_red(G2tensor(28),RedBasis(58),mass3set(:,5),G0tensor(265),G0tensor(270),G0tensor(275), &
    G0tensor(280),M2L1R1,[nMW],G0tensor(285))
  call TI_triangle_red(G2tensor(244),RedBasis(33),mass3set(:,6),G0tensor(290),G0tensor(295),G0tensor(300), &
    G0tensor(305),M2L1R1,[nMW],G0tensor(310))
  call TI_triangle_red(G2tensor(397),RedBasis(14),mass3set(:,6),G0tensor(315),G0tensor(320),G0tensor(325), &
    G0tensor(330),M2L1R1,[nMW],G0tensor(335))
  call TI_triangle_red(G2tensor(271),RedBasis(32),mass3set(:,6),G0tensor(340),G0tensor(345),G0tensor(350), &
    G0tensor(355),M2L1R1,[nMW],G0tensor(360))
  call TI_triangle_red(G2tensor(49),RedBasis(22),mass3set(:,6),G0tensor(365),G0tensor(370),G0tensor(375), &
    G0tensor(380),M2L1R1,[nMW],G0tensor(385))
  call TI_triangle_red(G2tensor(282),RedBasis(17),mass3set(:,1),G0tensor(390),G0tensor(395),G0tensor(400),G0tensor(405),M2L1R1)
  call TI_triangle_red(G2tensor(262),RedBasis(1),mass3set(:,1),G0tensor(410),G0tensor(415),G0tensor(420),G0tensor(425),M2L1R1)
  call TI_triangle_red(G2tensor(16),RedBasis(32),mass3set(:,1),G0tensor(430),G0tensor(435),G0tensor(440),G0tensor(445),M2L1R1)
  call TI_triangle_red(G2tensor(98),RedBasis(22),mass3set(:,1),G0tensor(450),G0tensor(455),G0tensor(460),G0tensor(465),M2L1R1)
  call TI_triangle_red(G2tensor(274),RedBasis(12),mass3set(:,1),G0tensor(470),G0tensor(1),G0tensor(2),G0tensor(3),M2L1R1)
  call TI_triangle_red(G2tensor(376),RedBasis(2),mass3set(:,1),G0tensor(4),G0tensor(5),G0tensor(6),G0tensor(7),M2L1R1)
  call TI_triangle_red(G3tensor(71),RedBasis(10),mass3set(:,1),G0tensor(8),G0tensor(9),G0tensor(475),G0tensor(480),M2L1R1)
  call TI_triangle_red(G2tensor(160),RedBasis(12),mass3set(:,4),G0tensor(485),G0tensor(490),G0tensor(495), &
    G0tensor(500),M2L1R1,[nMZ],G0tensor(505))
  call TI_triangle_red(G2tensor(394),RedBasis(2),mass3set(:,4),G0tensor(510),G0tensor(515),G0tensor(520), &
    G0tensor(46),M2L1R1,[nMZ],G0tensor(41))
  call TI_triangle_red(G2tensor(166),RedBasis(12),mass3set(:,5),G0tensor(56),G0tensor(51),G0tensor(491),G0tensor(66),M2L1R1,[nMW], &
    G0tensor(61))
  call TI_triangle_red(G2tensor(391),RedBasis(2),mass3set(:,5),G0tensor(131),G0tensor(102),G0tensor(76),G0tensor(71),M2L1R1,[nMW], &
    G0tensor(136))
  call TI_triangle_red(G3tensor(6),RedBasis(16),mass3set(:,1),G0tensor(112),G0tensor(86),G0tensor(81),G0tensor(141),M2L1R1)
  call TI_triangle_red(G2tensor(238),RedBasis(15),mass3set(:,1),G0tensor(122),G0tensor(96),G0tensor(91),G0tensor(252),M2L1R1)
  call TI_triangle_red(G2tensor(327),RedBasis(17),mass3set(:,7),G0tensor(247),G0tensor(106),G0tensor(101), &
    G0tensor(116),M2L1R1,[nMZ],G0tensor(111))
  call TI_triangle_red(G2tensor(232),RedBasis(15),mass3set(:,4),G0tensor(486),G0tensor(126),G0tensor(121), &
    G0tensor(176),M2L1R1,[nMZ],G0tensor(151))
  call TI_triangle_red(G2tensor(330),RedBasis(17),mass3set(:,8),G0tensor(146),G0tensor(42),G0tensor(181), &
    G0tensor(161),M2L1R1,[nMW],G0tensor(156))
  call TI_triangle_red(G2tensor(81),RedBasis(15),mass3set(:,5),G0tensor(52),G0tensor(186),G0tensor(171), &
    G0tensor(166),M2L1R1,[nMW],G0tensor(62))
  call TI_triangle_red(G2tensor(433),RedBasis(21),mass3set(:,1),G0tensor(466),G0tensor(196),G0tensor(191),G0tensor(487),M2L1R1)
  call TI_triangle_red(G2tensor(439),RedBasis(20),mass3set(:,1),G0tensor(471),G0tensor(206),G0tensor(201),G0tensor(211),M2L1R1)
  call TI_triangle_red(G2tensor(445),RedBasis(21),mass3set(:,4),G0tensor(26),G0tensor(21),G0tensor(492), &
    G0tensor(216),M2L1R1,[nMZ],G0tensor(36))
  call TI_triangle_red(G2tensor(158),RedBasis(20),mass3set(:,4),G0tensor(31),G0tensor(244),G0tensor(236), &
    G0tensor(224),M2L1R1,[nMZ],G0tensor(77))
  call TI_triangle_red(G2tensor(154),RedBasis(21),mass3set(:,5),G0tensor(414),G0tensor(384),G0tensor(239), &
    G0tensor(154),M2L1R1,[nMW],G0tensor(19))
  call TI_triangle_red(G2tensor(427),RedBasis(20),mass3set(:,5),G0tensor(14),G0tensor(221),G0tensor(72),G0tensor(11),M2L1R1,[nMW], &
    G0tensor(332))
  call TI_triangle_red(G2tensor(345),RedBasis(26),mass3set(:,1),G0tensor(241),G0tensor(132),G0tensor(16),G0tensor(411),M2L1R1)
  call TI_triangle_red(G2tensor(351),RedBasis(26),mass3set(:,7),G0tensor(179),G0tensor(47),G0tensor(284), &
    G0tensor(234),M2L1R1,[nMZ],G0tensor(48))
  call TI_triangle_red(G2tensor(259),RedBasis(1),mass3set(:,4),G0tensor(13),G0tensor(289),G0tensor(129), &
    G0tensor(119),M2L1R1,[nMZ],G0tensor(109))
  call TI_triangle_red(G2tensor(354),RedBasis(26),mass3set(:,8),G0tensor(69),G0tensor(59),G0tensor(49),G0tensor(421),M2L1R1,[nMW], &
    G0tensor(184))
  call TI_triangle_red(G2tensor(373),RedBasis(1),mass3set(:,5),G0tensor(57),G0tensor(294),G0tensor(58),G0tensor(431),M2L1R1,[nMW], &
    G0tensor(219))
  call TI_triangle_red(G2tensor(421),RedBasis(29),mass3set(:,9),G0tensor(189),G0tensor(67),G0tensor(299), &
    G0tensor(264),M2L1R1,[nMW],G0tensor(68))
  call TI_triangle_red(G2tensor(146),RedBasis(31),mass3set(:,9),G0tensor(28),G0tensor(349),G0tensor(304), &
    G0tensor(173),M2L1R1,[nMW],G0tensor(163))
  call TI_triangle_red(G2tensor(147),RedBasis(30),mass3set(:,5),G0tensor(153),G0tensor(98),G0tensor(88),G0tensor(78),M2L1R1,[nMW], &
    G0tensor(484))
  call TI_triangle_red(G2tensor(265),RedBasis(4),mass3set(:,9),G0tensor(479),G0tensor(354),G0tensor(309), &
    G0tensor(79),M2L1R1,[nMW],G0tensor(359))
  call TI_triangle_red(G2tensor(150),RedBasis(8),mass3set(:,9),G0tensor(314),G0tensor(87),G0tensor(364), &
    G0tensor(319),M2L1R1,[nMW],G0tensor(89))
  call TI_triangle_red(G2tensor(415),RedBasis(7),mass3set(:,5),G0tensor(369),G0tensor(324),G0tensor(97), &
    G0tensor(374),M2L1R1,[nMW],G0tensor(329))
  call TI_triangle_red(G2tensor(382),RedBasis(4),mass3set(:,1),G0tensor(209),G0tensor(199),G0tensor(99),G0tensor(351),M2L1R1)
  call TI_triangle_red(G2tensor(57),RedBasis(8),mass3set(:,1),G0tensor(134),G0tensor(107),G0tensor(483),G0tensor(334),M2L1R1)
  call TI_triangle_red(G2tensor(10),RedBasis(7),mass3set(:,1),G0tensor(108),G0tensor(361),G0tensor(139),G0tensor(117),M2L1R1)
  call TI_triangle_red(G3tensor(12),RedBasis(16),mass3set(:,10),G0tensor(339),G0tensor(118),G0tensor(371), &
    G0tensor(204),M2L1R1,[nMT],G0tensor(144))
  call TI_triangle_red(G3tensor(14),RedBasis(16),mass3set(:,11),G0tensor(127),G0tensor(344),G0tensor(198), &
    G0tensor(128),M2L1R1,[nMB],G0tensor(409))
  call TI_triangle_red(G3tensor(72),RedBasis(10),mass3set(:,10),G0tensor(379),G0tensor(152),G0tensor(419), &
    G0tensor(389),M2L1R1,[nMT],G0tensor(162))
  call TI_triangle_red(G3tensor(74),RedBasis(10),mass3set(:,11),G0tensor(424),G0tensor(394),G0tensor(164), &
    G0tensor(429),M2L1R1,[nMB],G0tensor(399))
  call TI_triangle_red(G3tensor(47),RedBasis(56),mass3set(:,1),G0tensor(172),G0tensor(434),G0tensor(404),G0tensor(269),M2L1R1)
  call TI_triangle_red(G2tensor(176),RedBasis(59),mass3set(:,1),G0tensor(174),G0tensor(39),G0tensor(29),G0tensor(439),M2L1R1)
  call TI_triangle_red(G2tensor(182),RedBasis(59),mass3set(:,4),G0tensor(197),G0tensor(444),G0tensor(207), &
    G0tensor(449),M2L1R1,[nMZ],G0tensor(208))
  call TI_triangle_red(G2tensor(258),RedBasis(59),mass3set(:,5),G0tensor(454),G0tensor(259),G0tensor(27), &
    G0tensor(459),M2L1R1,[nMW],G0tensor(274))
  call TI_triangle_red(G2tensor(224),RedBasis(63),mass3set(:,1),G0tensor(37),G0tensor(464),G0tensor(279),G0tensor(38),M2L1R1)
  call TI_triangle_red(G2tensor(230),RedBasis(63),mass3set(:,4),G0tensor(229),G0tensor(12),G0tensor(249), &
    G0tensor(17),M2L1R1,[nMZ],G0tensor(254))
  call TI_triangle_red(G2tensor(264),RedBasis(63),mass3set(:,5),G0tensor(18),G0tensor(509),G0tensor(499), &
    G0tensor(514),M2L1R1,[nMW],G0tensor(504))
  call TI_triangle_red(G2tensor(276),RedBasis(17),mass3set(:,6),G0tensor(519),G0tensor(524),G0tensor(286), &
    G0tensor(124),M2L1R1,[nMW],G0tensor(114))
  call TI_triangle_red(G3tensor(84),RedBasis(19),mass3set(:,12),G0tensor(104),G0tensor(64),G0tensor(54),G0tensor(44),M2L1R1,[nMW], &
    G0tensor(306))
  call TI_triangle_red(G2tensor(322),RedBasis(18),mass3set(:,6),G0tensor(74),G0tensor(316),G0tensor(84), &
    G0tensor(326),M2L1R1,[nMW],G0tensor(194))
  call TI_triangle_red(G2tensor(400),RedBasis(25),mass3set(:,12),G0tensor(94),G0tensor(381),G0tensor(149), &
    G0tensor(391),M2L1R1,[nMW],G0tensor(159))
  call TI_triangle_red(G2tensor(144),RedBasis(24),mass3set(:,6),G0tensor(401),G0tensor(214),G0tensor(169), &
    G0tensor(266),M2L1R1,[nMW],G0tensor(34))
  call TI_triangle_red(G2tensor(21),RedBasis(57),mass3set(:,1),G0tensor(24),G0tensor(467),G0tensor(256),G0tensor(22),M2L1R1)
  call TI_triangle_red(G2tensor(25),RedBasis(57),mass3set(:,4),G0tensor(493),G0tensor(261),G0tensor(23), &
    G0tensor(472),M2L1R1,[nMZ],G0tensor(271))
  call TI_triangle_red(G2tensor(29),RedBasis(57),mass3set(:,5),G0tensor(32),G0tensor(276),G0tensor(33),G0tensor(281),M2L1R1,[nMW], &
    G0tensor(43))
  call TI_triangle_red(G3tensor(23),RedBasis(60),mass3set(:,1),G0tensor(291),G0tensor(53),G0tensor(296),G0tensor(213),M2L1R1)
  call TI_triangle_red(G2tensor(32),RedBasis(32),mass3set(:,7),G0tensor(63),G0tensor(301),G0tensor(168), &
    G0tensor(158),M2L1R1,[nMZ],G0tensor(148))
  call TI_triangle_red(G2tensor(36),RedBasis(32),mass3set(:,8),G0tensor(93),G0tensor(83),G0tensor(73),G0tensor(311),M2L1R1,[nMW], &
    G0tensor(82))
  call TI_triangle_red(G2tensor(41),RedBasis(61),mass3set(:,1),G0tensor(447),G0tensor(442),G0tensor(321),G0tensor(92),M2L1R1)
  call TI_triangle_red(G2tensor(45),RedBasis(61),mass3set(:,4),G0tensor(331),G0tensor(103),G0tensor(336), &
    G0tensor(113),M2L1R1,[nMZ],G0tensor(341))
  call TI_triangle_red(G2tensor(52),RedBasis(61),mass3set(:,5),G0tensor(193),G0tensor(123),G0tensor(346), &
    G0tensor(287),M2L1R1,[nMW],G0tensor(188))
  call TI_triangle_red(G3tensor(25),RedBasis(13),mass3set(:,1),G0tensor(183),G0tensor(178),G0tensor(143),G0tensor(138),M2L1R1)
  call TI_triangle_red(G2tensor(56),RedBasis(22),mass3set(:,7),G0tensor(133),G0tensor(356),G0tensor(337), &
    G0tensor(137),M2L1R1,[nMZ],G0tensor(437))
  call TI_triangle_red(G2tensor(61),RedBasis(22),mass3set(:,8),G0tensor(366),G0tensor(342),G0tensor(142), &
    G0tensor(481),M2L1R1,[nMW],G0tensor(376))
  call TI_triangle_red(G2tensor(12),RedBasis(33),mass3set(:,1),G0tensor(147),G0tensor(386),G0tensor(157),G0tensor(462),M2L1R1)
  call TI_triangle_red(G2tensor(68),RedBasis(33),mass3set(:,7),G0tensor(457),G0tensor(396),G0tensor(167), &
    G0tensor(476),M2L1R1,[nMZ],G0tensor(406))
  call TI_triangle_red(G2tensor(72),RedBasis(33),mass3set(:,8),G0tensor(282),G0tensor(177),G0tensor(416), &
    G0tensor(292),M2L1R1,[nMW],G0tensor(182))
  call TI_triangle_red(G2tensor(7),RedBasis(14),mass3set(:,1),G0tensor(452),G0tensor(426),G0tensor(297),G0tensor(187),M2L1R1)
  call TI_triangle_red(G2tensor(84),RedBasis(14),mass3set(:,7),G0tensor(436),G0tensor(192),G0tensor(441), &
    G0tensor(202),M2L1R1,[nMZ],G0tensor(446))
  call TI_triangle_red(G2tensor(88),RedBasis(14),mass3set(:,8),G0tensor(203),G0tensor(451),G0tensor(277), &
    G0tensor(272),M2L1R1,[nMW],G0tensor(212))
  call TI_triangle_red(G2tensor(92),RedBasis(64),mass3set(:,9),G0tensor(456),G0tensor(262),G0tensor(257), &
    G0tensor(217),M2L1R1,[nMW],G0tensor(461))
  call TI_triangle_red(G2tensor(97),RedBasis(66),mass3set(:,9),G0tensor(218),G0tensor(489),G0tensor(474), &
    G0tensor(469),M2L1R1,[nMW],G0tensor(494))
  call TI_triangle_red(G2tensor(163),RedBasis(65),mass3set(:,5),G0tensor(517),G0tensor(496),G0tensor(522), &
    G0tensor(501),M2L1R1,[nMW],G0tensor(506))
  call TI_triangle_red(G2tensor(304),RedBasis(9),mass3set(:,9),G0tensor(511),G0tensor(516),G0tensor(521), &
    G0tensor(397),M2L1R1,[nMW],G0tensor(387))
  call TI_triangle_red(G2tensor(138),RedBasis(6),mass3set(:,9),G0tensor(377),G0tensor(322),G0tensor(312), &
    G0tensor(302),M2L1R1,[nMW],G0tensor(226))
  call TI_triangle_red(G2tensor(140),RedBasis(67),mass3set(:,5),G0tensor(222),G0tensor(307),G0tensor(231), &
    G0tensor(223),M2L1R1,[nMW],G0tensor(232))
  call TI_triangle_red(G2tensor(256),RedBasis(4),mass3set(:,3),G0tensor(227),G0tensor(248),G0tensor(237), &
    G0tensor(228),M2L1R1,[nMW],G0tensor(253))
  call TI_triangle_red(G2tensor(411),RedBasis(26),mass3set(:,6),G0tensor(238),G0tensor(233),G0tensor(427), &
    G0tensor(417),M2L1R1,[nMW],G0tensor(407))
  call TI_triangle_red(G2tensor(226),RedBasis(29),mass3set(:,3),G0tensor(367),G0tensor(357),G0tensor(347), &
    G0tensor(246),M2L1R1,[nMW],G0tensor(242))
  call TI_triangle_red(G3tensor(31),RedBasis(13),mass3set(:,10),G0tensor(352),G0tensor(251),G0tensor(243), &
    G0tensor(273),M2L1R1,[nMT],G0tensor(267))
  call TI_triangle_red(G3tensor(35),RedBasis(13),mass3set(:,11),G0tensor(258),G0tensor(278),G0tensor(268), &
    G0tensor(263),M2L1R1,[nMB],G0tensor(403))
  call TI_triangle_red(G3tensor(39),RedBasis(60),mass3set(:,10),G0tensor(393),G0tensor(383),G0tensor(343), &
    G0tensor(338),M2L1R1,[nMT],G0tensor(333))
  call TI_triangle_red(G3tensor(43),RedBasis(60),mass3set(:,11),G0tensor(328),G0tensor(318),G0tensor(308), &
    G0tensor(303),M2L1R1,[nMB],G0tensor(298))
  call TI_triangle_red(G3tensor(48),RedBasis(56),mass3set(:,10),G0tensor(293),G0tensor(288),G0tensor(283), &
    G0tensor(317),M2L1R1,[nMT],G0tensor(313))
  call TI_triangle_red(G3tensor(50),RedBasis(56),mass3set(:,11),G0tensor(438),G0tensor(327),G0tensor(323), &
    G0tensor(463),M2L1R1,[nMB],G0tensor(448))
  call TI_triangle_red(G3tensor(52),RedBasis(19),mass3set(:,1),G0tensor(433),G0tensor(423),G0tensor(413),G0tensor(373),M2L1R1)
  call TI_triangle_red(G2tensor(6),RedBasis(18),mass3set(:,1),G0tensor(363),G0tensor(353),G0tensor(348),G0tensor(362),M2L1R1)
  call TI_triangle_red(G2tensor(178),RedBasis(6),mass3set(:,1),G0tensor(358),G0tensor(443),G0tensor(372),G0tensor(368),M2L1R1)
  call TI_triangle_red(G2tensor(2),RedBasis(5),mass3set(:,1),G0tensor(382),G0tensor(378),G0tensor(392),G0tensor(388),M2L1R1)
  call TI_triangle_red(G2tensor(4),RedBasis(3),mass3set(:,1),G0tensor(453),G0tensor(402),G0tensor(398),G0tensor(412),M2L1R1)
  call TI_triangle_red(G3tensor(53),RedBasis(25),mass3set(:,1),G0tensor(408),G0tensor(422),G0tensor(418),G0tensor(458),M2L1R1)
  call TI_triangle_red(G2tensor(93),RedBasis(24),mass3set(:,1),G0tensor(432),G0tensor(428),G0tensor(488),G0tensor(468),M2L1R1)
  call TI_triangle_red(G2tensor(132),RedBasis(5),mass3set(:,9),G0tensor(473),G0tensor(477),G0tensor(478), &
    G0tensor(482),M2L1R1,[nMW],G0tensor(497))
  call TI_triangle_red(G2tensor(133),RedBasis(3),mass3set(:,5),G0tensor(498),G0tensor(502),G0tensor(503), &
    G0tensor(507),M2L1R1,[nMW],G0tensor(518))
  call TI_triangle_red(G3tensor(24),RedBasis(11),mass3set(:,1),G0tensor(508),G0tensor(512),G0tensor(523),G0tensor(513),M2L1R1)
  call TI_triangle_red(G2tensor(33),RedBasis(18),mass3set(:,7),G0tensor(525),G0tensor(526),G0tensor(527), &
    G0tensor(528),M2L1R1,[nMZ],G0tensor(529))
  call TI_triangle_red(G2tensor(37),RedBasis(18),mass3set(:,8),G0tensor(530),G0tensor(531),G0tensor(532), &
    G0tensor(533),M2L1R1,[nMW],G0tensor(534))
  call TI_triangle_red(G3tensor(26),RedBasis(23),mass3set(:,1),G0tensor(535),G0tensor(536),G0tensor(537),G0tensor(538),M2L1R1)
  call TI_triangle_red(G2tensor(60),RedBasis(24),mass3set(:,7),G0tensor(539),G0tensor(540),G0tensor(541), &
    G0tensor(542),M2L1R1,[nMZ],G0tensor(543))
  call TI_triangle_red(G2tensor(64),RedBasis(24),mass3set(:,8),G0tensor(544),G0tensor(545),G0tensor(546), &
    G0tensor(547),M2L1R1,[nMW],G0tensor(548))
  call TI_triangle_red(G2tensor(65),RedBasis(27),mass3set(:,1),G0tensor(549),G0tensor(550),G0tensor(551),G0tensor(552),M2L1R1)
  call TI_triangle_red(G2tensor(69),RedBasis(27),mass3set(:,7),G0tensor(553),G0tensor(554),G0tensor(555), &
    G0tensor(556),M2L1R1,[nMZ],G0tensor(557))
  call TI_triangle_red(G2tensor(76),RedBasis(27),mass3set(:,8),G0tensor(558),G0tensor(559),G0tensor(560), &
    G0tensor(561),M2L1R1,[nMW],G0tensor(562))
  call TI_triangle_red(G2tensor(80),RedBasis(28),mass3set(:,1),G0tensor(563),G0tensor(564),G0tensor(565),G0tensor(566),M2L1R1)
  call TI_triangle_red(G2tensor(85),RedBasis(28),mass3set(:,7),G0tensor(567),G0tensor(568),G0tensor(569), &
    G0tensor(570),M2L1R1,[nMZ],G0tensor(571))
  call TI_triangle_red(G2tensor(89),RedBasis(28),mass3set(:,8),G0tensor(572),G0tensor(573),G0tensor(574), &
    G0tensor(575),M2L1R1,[nMW],G0tensor(576))
  call TI_triangle_red(G2tensor(169),RedBasis(27),mass3set(:,6),G0tensor(577),G0tensor(578),G0tensor(579), &
    G0tensor(580),M2L1R1,[nMW],G0tensor(581))
  call TI_triangle_red(G2tensor(172),RedBasis(28),mass3set(:,6),G0tensor(582),G0tensor(583),G0tensor(584), &
    G0tensor(585),M2L1R1,[nMW],G0tensor(586))
  call TI_triangle_red(G2tensor(184),RedBasis(31),mass3set(:,1),G0tensor(587),G0tensor(588),G0tensor(589),G0tensor(590),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(30),mass3set(:,1),G0tensor(591),G0tensor(592),G0tensor(593),G0tensor(594),M2L1R1)
  call TI_triangle_red(G2tensor(190),RedBasis(29),mass3set(:,1),G0tensor(595),G0tensor(596),G0tensor(597),G0tensor(598),M2L1R1)
  call TI_triangle_red(G3tensor(56),RedBasis(25),mass3set(:,10),G0tensor(599),G0tensor(600),G0tensor(601), &
    G0tensor(602),M2L1R1,[nMT],G0tensor(603))
  call TI_triangle_red(G3tensor(32),RedBasis(23),mass3set(:,10),G0tensor(604),G0tensor(605),G0tensor(606), &
    G0tensor(607),M2L1R1,[nMT],G0tensor(608))
  call TI_triangle_red(G3tensor(58),RedBasis(25),mass3set(:,11),G0tensor(609),G0tensor(610),G0tensor(611), &
    G0tensor(612),M2L1R1,[nMB],G0tensor(613))
  call TI_triangle_red(G3tensor(36),RedBasis(23),mass3set(:,11),G0tensor(614),G0tensor(615),G0tensor(616), &
    G0tensor(617),M2L1R1,[nMB],G0tensor(618))
  call TI_triangle_red(G3tensor(60),RedBasis(19),mass3set(:,10),G0tensor(619),G0tensor(620),G0tensor(621), &
    G0tensor(622),M2L1R1,[nMT],G0tensor(623))
  call TI_triangle_red(G3tensor(40),RedBasis(11),mass3set(:,10),G0tensor(624),G0tensor(625),G0tensor(626), &
    G0tensor(627),M2L1R1,[nMT],G0tensor(628))
  call TI_triangle_red(G3tensor(62),RedBasis(19),mass3set(:,11),G0tensor(629),G0tensor(630),G0tensor(631), &
    G0tensor(632),M2L1R1,[nMB],G0tensor(633))
  call TI_triangle_red(G3tensor(44),RedBasis(11),mass3set(:,11),G0tensor(634),G0tensor(635),G0tensor(636), &
    G0tensor(637),M2L1R1,[nMB],G0tensor(638))
  call TI_triangle_red(G2tensor(73),RedBasis(29),mass3set(:,2),G0tensor(639),G0tensor(640),G0tensor(641), &
    G0tensor(642),M2L1R1,[nMZ],G0tensor(643))
  call TI_triangle_red(G2tensor(250),RedBasis(4),mass3set(:,2),G0tensor(644),G0tensor(645),G0tensor(646), &
    G0tensor(647),M2L1R1,[nMZ],G0tensor(648))
  call TI_triangle_red(G3tensor(78),RedBasis(19),mass3set(:,13),G0tensor(649),G0tensor(650),G0tensor(651), &
    G0tensor(652),M2L1R1,[nME],G0tensor(653))
  call TI_triangle_red(G3tensor(79),RedBasis(19),mass3set(:,14),G0tensor(654),G0tensor(655),G0tensor(656), &
    G0tensor(657),M2L1R1,[nMM],G0tensor(658))
  call TI_triangle_red(G3tensor(80),RedBasis(19),mass3set(:,15),G0tensor(659),G0tensor(660),G0tensor(661), &
    G0tensor(662),M2L1R1,[nML],G0tensor(663))
  call ol_merge_tensors(T0sum(113),[G0tensor(10)])
  call ol_merge_tensors(T0sum(114),[G0tensor(30)])
  call ol_merge_tensors(T0sum(115),[G0tensor(55)])
  call ol_merge_tensors(T0sum(116),[G0tensor(80)])
  call ol_merge_tensors(T0sum(117),[G0tensor(100)])
  call ol_merge_tensors(T0sum(118),[G0tensor(125)])
  call ol_merge_tensors(T0sum(119),[G0tensor(150)])
  call ol_merge_tensors(T0sum(120),[G0tensor(170)])
  call ol_merge_tensors(T0sum(121),[G0tensor(195)])
  call ol_merge_tensors(T0sum(122),[G0tensor(220)])
  call ol_merge_tensors(T0sum(123),[G0tensor(240)])
  call ol_merge_tensors(T0sum(124),[G0tensor(265)])
  call ol_merge_tensors(T0sum(125),[G0tensor(290)])
  call ol_merge_tensors(T0sum(126),[G0tensor(315)])
  call ol_merge_tensors(T0sum(127),[G0tensor(340)])
  call ol_merge_tensors(T0sum(128),[G0tensor(365)])
  call ol_merge_tensors(T0sum(129),[G0tensor(390)])
  call ol_merge_tensors(T0sum(130),[G0tensor(410)])
  call ol_merge_tensors(T0sum(131),[G0tensor(430)])
  call ol_merge_tensors(T0sum(132),[G0tensor(450)])
  call ol_merge_tensors(T0sum(133),[G0tensor(470)])
  call ol_merge_tensors(T0sum(134),[G0tensor(4)])
  call ol_merge_tensors(T0sum(135),[G0tensor(8)])
  call ol_merge_tensors(T0sum(136),[G0tensor(485)])
  call ol_merge_tensors(T0sum(137),[G0tensor(510)])
  call ol_merge_tensors(T0sum(138),[G0tensor(56)])
  call ol_merge_tensors(T0sum(139),[G0tensor(131)])
  call ol_merge_tensors(T0sum(140),[G0tensor(112)])
  call ol_merge_tensors(T0sum(141),[G0tensor(122)])
  call ol_merge_tensors(T0sum(142),[G0tensor(247)])
  call ol_merge_tensors(T0sum(143),[G0tensor(486)])
  call ol_merge_tensors(T0sum(144),[G0tensor(146)])
  call ol_merge_tensors(T0sum(145),[G0tensor(52)])
  call ol_merge_tensors(T0sum(146),[G0tensor(466)])
  call ol_merge_tensors(T0sum(147),[G0tensor(471)])
  call ol_merge_tensors(T0sum(148),[G0tensor(26)])
  call ol_merge_tensors(T0sum(149),[G0tensor(31)])
  call ol_merge_tensors(T0sum(150),[G0tensor(414)])
  call ol_merge_tensors(T0sum(151),[G0tensor(14)])
  call ol_merge_tensors(T0sum(152),[G0tensor(241)])
  call ol_merge_tensors(T0sum(153),[G0tensor(179)])
  call ol_merge_tensors(T0sum(154),[G0tensor(13)])
  call ol_merge_tensors(T0sum(155),[G0tensor(69)])
  call ol_merge_tensors(T0sum(156),[G0tensor(57)])
  call ol_merge_tensors(T0sum(157),[G0tensor(189)])
  call ol_merge_tensors(T0sum(158),[G0tensor(28)])
  call ol_merge_tensors(T0sum(159),[G0tensor(153)])
  call ol_merge_tensors(T0sum(160),[G0tensor(479)])
  call ol_merge_tensors(T0sum(161),[G0tensor(314)])
  call ol_merge_tensors(T0sum(162),[G0tensor(369)])
  call ol_merge_tensors(T0sum(163),[G0tensor(209)])
  call ol_merge_tensors(T0sum(164),[G0tensor(134)])
  call ol_merge_tensors(T0sum(165),[G0tensor(108)])
  call ol_merge_tensors(T0sum(166),[G0tensor(339)])
  call ol_merge_tensors(T0sum(167),[G0tensor(127)])
  call ol_merge_tensors(T0sum(168),[G0tensor(379)])
  call ol_merge_tensors(T0sum(169),[G0tensor(424)])
  call ol_merge_tensors(T0sum(170),[G0tensor(172)])
  call ol_merge_tensors(T0sum(171),[G0tensor(174)])
  call ol_merge_tensors(T0sum(172),[G0tensor(197)])
  call ol_merge_tensors(T0sum(173),[G0tensor(454)])
  call ol_merge_tensors(T0sum(174),[G0tensor(37)])
  call ol_merge_tensors(T0sum(175),[G0tensor(229)])
  call ol_merge_tensors(T0sum(176),[G0tensor(18)])
  call ol_merge_tensors(T0sum(177),[G0tensor(519)])
  call ol_merge_tensors(T0sum(178),[G0tensor(104)])
  call ol_merge_tensors(T0sum(179),[G0tensor(74)])
  call ol_merge_tensors(T0sum(180),[G0tensor(94)])
  call ol_merge_tensors(T0sum(181),[G0tensor(401)])
  call ol_merge_tensors(T0sum(182),[G0tensor(24)])
  call ol_merge_tensors(T0sum(183),[G0tensor(493)])
  call ol_merge_tensors(T0sum(184),[G0tensor(32)])
  call ol_merge_tensors(T0sum(185),[G0tensor(291)])
  call ol_merge_tensors(T0sum(186),[G0tensor(63)])
  call ol_merge_tensors(T0sum(187),[G0tensor(93)])
  call ol_merge_tensors(T0sum(188),[G0tensor(447)])
  call ol_merge_tensors(T0sum(189),[G0tensor(331)])
  call ol_merge_tensors(T0sum(190),[G0tensor(193)])
  call ol_merge_tensors(T0sum(191),[G0tensor(183)])
  call ol_merge_tensors(T0sum(192),[G0tensor(133)])
  call ol_merge_tensors(T0sum(193),[G0tensor(366)])
  call ol_merge_tensors(T0sum(194),[G0tensor(147)])
  call ol_merge_tensors(T0sum(195),[G0tensor(457)])
  call ol_merge_tensors(T0sum(196),[G0tensor(282)])
  call ol_merge_tensors(T0sum(197),[G0tensor(452)])
  call ol_merge_tensors(T0sum(198),[G0tensor(436)])
  call ol_merge_tensors(T0sum(199),[G0tensor(203)])
  call ol_merge_tensors(T0sum(200),[G0tensor(456)])
  call ol_merge_tensors(T0sum(201),[G0tensor(218)])
  call ol_merge_tensors(T0sum(202),[G0tensor(517)])
  call ol_merge_tensors(T0sum(203),[G0tensor(511)])
  call ol_merge_tensors(T0sum(204),[G0tensor(377)])
  call ol_merge_tensors(T0sum(205),[G0tensor(222)])
  call ol_merge_tensors(T0sum(206),[G0tensor(227)])
  call ol_merge_tensors(T0sum(207),[G0tensor(238)])
  call ol_merge_tensors(T0sum(208),[G0tensor(367)])
  call ol_merge_tensors(T0sum(209),[G0tensor(352)])
  call ol_merge_tensors(T0sum(210),[G0tensor(258)])
  call ol_merge_tensors(T0sum(211),[G0tensor(393)])
  call ol_merge_tensors(T0sum(212),[G0tensor(328)])
  call ol_merge_tensors(T0sum(213),[G0tensor(293)])
  call ol_merge_tensors(T0sum(214),[G0tensor(438)])
  call ol_merge_tensors(T0sum(215),[G0tensor(433)])
  call ol_merge_tensors(T0sum(216),[G0tensor(363)])
  call ol_merge_tensors(T0sum(217),[G0tensor(358)])
  call ol_merge_tensors(T0sum(218),[G0tensor(382)])
  call ol_merge_tensors(T0sum(219),[G0tensor(453)])
  call ol_merge_tensors(T0sum(220),[G0tensor(408)])
  call ol_merge_tensors(T0sum(221),[G0tensor(432)])
  call ol_merge_tensors(T0sum(222),[G0tensor(473)])
  call ol_merge_tensors(T0sum(223),[G0tensor(498)])
  call ol_merge_tensors(T0sum(224),[G0tensor(508)])
  call ol_merge_tensors(T0sum(225),[G0tensor(525)])
  call ol_merge_tensors(T0sum(226),[G0tensor(530)])
  call ol_merge_tensors(T0sum(227),[G0tensor(535)])
  call ol_merge_tensors(T0sum(228),[G0tensor(539)])
  call ol_merge_tensors(T0sum(229),[G0tensor(544)])
  call ol_merge_tensors(T0sum(230),[G0tensor(549)])
  call ol_merge_tensors(T0sum(231),[G0tensor(553)])
  call ol_merge_tensors(T0sum(232),[G0tensor(558)])
  call ol_merge_tensors(T0sum(233),[G0tensor(563)])
  call ol_merge_tensors(T0sum(234),[G0tensor(567)])
  call ol_merge_tensors(T0sum(235),[G0tensor(572)])
  call ol_merge_tensors(T0sum(236),[G0tensor(577)])
  call ol_merge_tensors(T0sum(237),[G0tensor(582)])
  call ol_merge_tensors(T1sum(27),[G1tensor(467)])
  call ol_merge_tensors(T1sum(28),[G1tensor(468)])
  call ol_merge_tensors(T1sum(29),[G1tensor(493)])
  call ol_merge_tensors(T1sum(30),[G1tensor(474)])
  call ol_merge_tensors(T1sum(31),[G1tensor(492)])
  call ol_merge_tensors(T1sum(32),[G1tensor(472)])
  call ol_merge_tensors(T1sum(33),[G1tensor(473)])
  call ol_merge_tensors(T1sum(34),[G1tensor(496)])
  call ol_merge_tensors(T1sum(35),[G1tensor(476)])
  call ol_merge_tensors(T1sum(36),[G1tensor(477)])
  call ol_merge_tensors(T1sum(37),[G1tensor(486)])
  call ol_merge_tensors(T1sum(38),[G1tensor(500)])
  call ol_merge_tensors(T1sum(39),[G1tensor(480)])
  call ol_merge_tensors(T1sum(40),[G1tensor(481)])
  call ol_merge_tensors(T1sum(41),[G1tensor(490)])
  call ol_merge_tensors(T1sum(42),[G1tensor(483)])
  call ol_merge_tensors(T1sum(43),[G1tensor(484)])
  call ol_merge_tensors(T1sum(44),[G1tensor(497)])
  call ol_merge_tensors(T1sum(45),[G1tensor(487)])
  call ol_merge_tensors(T1sum(46),[G1tensor(488)])
  call ol_merge_tensors(T1sum(47),[G1tensor(501)])
  call ol_merge_tensors(T1sum(48),[G1tensor(491)])
  call ol_merge_tensors(T1sum(49),[G1tensor(494)])
  call ol_merge_tensors(T1sum(50),[G1tensor(495)])
  call ol_merge_tensors(T1sum(51),[G1tensor(498)])
  call ol_merge_tensors(T1sum(52),[G1tensor(499)])
  call ol_merge_tensors(T1sum(53),[G1tensor(502)])
  call ol_merge_tensors(T0sum(238),[G0tensor(587)])
  call ol_merge_tensors(T0sum(239),[G0tensor(591)])
  call ol_merge_tensors(T0sum(240),[G0tensor(595)])
  call ol_merge_tensors(T0sum(241),[G0tensor(599)])
  call ol_merge_tensors(T0sum(242),[G0tensor(604)])
  call ol_merge_tensors(T0sum(243),[G0tensor(609)])
  call ol_merge_tensors(T0sum(244),[G0tensor(614)])
  call ol_merge_tensors(T0sum(245),[G0tensor(619)])
  call ol_merge_tensors(T0sum(246),[G0tensor(624)])
  call ol_merge_tensors(T0sum(247),[G0tensor(629)])
  call ol_merge_tensors(T0sum(248),[G0tensor(634)])
  call ol_merge_tensors(T0sum(249),[G0tensor(639)])
  call ol_merge_tensors(T0sum(250),[G0tensor(644)])
  call ol_merge_tensors(T0sum(251),[G0tensor(649)])
  call ol_merge_tensors(T0sum(252),[G0tensor(654)])
  call ol_merge_tensors(T0sum(253),[G0tensor(659)])
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[27,4],[nMW,nMW],3,1,wf8(:,54))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,54),G0H2(4),m4h2x8x2(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[27,4],[nMW,nMW],3,1,wf8(:,55))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,55),G0H2(3),m4h2x8x2(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[27,4],[nMW,nMW],3,1,wf8(:,54))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,54),G0H2(1),m4h2x8x2(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[27,4],[nMW,nMW],3,1,wf8(:,55))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,55),G0H2(2),m4h2x8x2(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[27,4],[nMW,nMW],3,1,wf8(:,56))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,56),G0H2(5),m4h2x8x2(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[27,4],[nMW,nMW],3,1,wf8(:,57))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,57),G0H2(6),m4h2x8x2(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[27,4],[nMW,nMW],3,1,wf8(:,56))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,56),G0H2(7),m4h2x8x2(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[27,4],[nMW,nMW],3,1,wf8(:,57))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,57),G0H2(8),m4h2x8x2(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[23,8],[nMW,nMW],3,1,wf8(:,54))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,54),G0H2(9),m4h2x8x2(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[23,8],[nMW,nMW],3,1,wf8(:,55))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,55),G0H2(10),m4h2x8x2(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[23,8],[nMW,nMW],3,1,wf8(:,54))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,54),G0H2(11),m4h2x8x2(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[23,8],[nMW,nMW],3,1,wf8(:,55))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,55),G0H2(12),m4h2x8x2(:,12),heltab3x32(:,:,12))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[23,8],[nMW,nMW],3,1,wf8(:,56))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,56),G0H2(13),m4h2x8x2(:,13),heltab3x32(:,:,13))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[23,8],[nMW,nMW],3,1,wf8(:,57))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,57),G0H2(14),m4h2x8x2(:,14),heltab3x32(:,:,14))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[23,8],[nMW,nMW],3,1,wf8(:,56))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,56),G0H2(15),m4h2x8x2(:,15),heltab3x32(:,:,15))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[23,8],[nMW,nMW],3,1,wf8(:,57))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,57),G0H2(16),m4h2x8x2(:,16),heltab3x32(:,:,16))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[19,12],[nMW,nMW],3,1,wf8(:,54))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,54),19,G1H4(149),m3h8x4(:,177),heltab2x32(:,:,388))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[19,12],[nMW,nMW],3,1,wf8(:,55))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,55),19,G1H4(165),m3h8x4(:,178),heltab2x32(:,:,389))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[19,12],[nMW,nMW],3,1,wf8(:,54))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,54),19,G1H4(3),m3h8x4(:,179),heltab2x32(:,:,390))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[19,12],[nMW,nMW],3,1,wf8(:,55))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,55),19,G1H4(21),m3h8x4(:,180),heltab2x32(:,:,391))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[19,12],[nMW,nMW],3,1,wf8(:,56))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(13),m3h8x4(:,181),heltab2x32(:,:,392))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[19,12],[nMW,nMW],3,1,wf8(:,57))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(22),m3h8x4(:,182),heltab2x32(:,:,393))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[19,12],[nMW,nMW],3,1,wf8(:,56))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(52),m3h8x4(:,183),heltab2x32(:,:,394))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[19,12],[nMW,nMW],3,1,wf8(:,57))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(53),m3h8x4(:,184),heltab2x32(:,:,395))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[21,10],[0,0],2,2,wf8(:,34),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(65),m3h8x4(:,185),heltab2x32(:,:,396))
  call Hloop_Q_A(ntryL,G0H4(65),21,0,G1H4(43),n2h4(181))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[21,10],[0,nMZ],2,2,wf8(:,34),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(33),ngZd,m3h8x4(:,186),heltab2x32(:,:,397))
  call Hloop_Q_A(ntryL,G0H4(33),21,0,G1H4(27),n2h4(182))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[21,10],[0,nMW],2,2,wf8(:,34),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(4),m3h8x4(:,187),heltab2x32(:,:,398))
  call Hloop_Q_A(ntryL,G0H4(4),21,0,G1H4(69),n2h4(183))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[21,10],[0,0],2,2,wf8(:,34),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(1),m3h8x4(:,188),heltab2x32(:,:,399))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(76),n2h4(184))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[26,5],[0,0],2,2,wf8(:,33),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(2),m3h8x4(:,189),heltab2x32(:,:,400))
  call Hloop_A_Q(ntryL,G0H4(2),26,0,G1H4(146),n2h4(185))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[26,5],[0,nMZ],2,2,wf8(:,33),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(3),ngZd,m3h8x4(:,190),heltab2x32(:,:,401))
  call Hloop_A_Q(ntryL,G0H4(3),26,0,G1H4(130),n2h4(186))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[26,5],[0,nMW],2,2,wf8(:,33),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(57),m3h8x4(:,191),heltab2x32(:,:,402))
  call Hloop_A_Q(ntryL,G0H4(57),26,0,G1H4(123),n2h4(187))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[26,5],[0,0],2,2,wf8(:,33),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(9),m3h8x4(:,192),heltab2x32(:,:,403))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(45),n2h4(188))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[18,13],[0,0],2,2,wf4(:,6),wf8(:,37))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(16),m3h4x8(:,51),heltab2x32(:,:,404))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[18,13],[nMZ,0],2,2,wf4(:,6),wf8(:,37))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(17),ngZd,m3h4x8(:,52),heltab2x32(:,:,405))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[18,13],[nMW,0],2,2,wf4(:,6),wf8(:,37))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(19),m3h4x8(:,53),heltab2x32(:,:,406))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[18,13],[0,0],2,2,wf4(:,6),wf8(:,37))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(2),m3h4x8(:,54),heltab2x32(:,:,407))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[26,5],[0,0],2,2,wf8(:,36),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,36),G0H4(6),m3h8x4(:,193),heltab2x32(:,:,408))
  call Hloop_A_Q(ntryL,G0H4(6),26,0,G1H4(176),n2h4(189))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[26,5],[0,nMZ],2,2,wf8(:,36),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,36),G0H4(7),ngZd,m3h8x4(:,194),heltab2x32(:,:,409))
  call Hloop_A_Q(ntryL,G0H4(7),26,0,G1H4(138),n2h4(190))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[26,5],[0,nMW],2,2,wf8(:,36),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,36),G0H4(8),m3h8x4(:,195),heltab2x32(:,:,410))
  call Hloop_A_Q(ntryL,G0H4(8),26,0,G1H4(122),n2h4(191))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[26,5],[0,0],2,2,wf8(:,36),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,36),G0H4(37),m3h8x4(:,196),heltab2x32(:,:,411))
  call Hloop_A_Q(ntryL,G0H4(37),26,0,G1H4(83),n2h4(192))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[25,6],[0,0],2,2,wf8(:,40),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,40),G0H4(10),m3h8x4(:,197),heltab2x32(:,:,412))
  call Hloop_Q_A(ntryL,G0H4(10),25,0,G1H4(142),n2h4(193))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[25,6],[0,nMZ],2,2,wf8(:,40),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,40),G0H4(11),ngZd,m3h8x4(:,198),heltab2x32(:,:,413))
  call Hloop_Q_A(ntryL,G0H4(11),25,0,G1H4(125),n2h4(194))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[25,6],[0,nMW],2,2,wf8(:,40),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,40),G0H4(12),m3h8x4(:,199),heltab2x32(:,:,414))
  call Hloop_Q_A(ntryL,G0H4(12),25,0,G1H4(118),n2h4(195))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[25,6],[0,0],2,2,wf8(:,40),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,40),G0H4(5),m3h8x4(:,200),heltab2x32(:,:,415))
  call Hloop_Q_A(ntryL,G0H4(5),25,0,G1H4(36),n2h4(196))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[22,9],[0,0],2,2,wf8(:,39),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(61),m3h8x4(:,201),heltab2x32(:,:,416))
  call Hloop_A_Q(ntryL,G0H4(61),22,0,G1H4(171),n2h4(197))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[22,9],[0,nMZ],2,2,wf8(:,39),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(16),ngZd,m3h8x4(:,202),heltab2x32(:,:,417))
  call Hloop_A_Q(ntryL,G0H4(16),22,0,G1H4(132),n2h4(198))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[22,9],[0,nMW],2,2,wf8(:,39),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(13),m3h8x4(:,203),heltab2x32(:,:,418))
  call Hloop_A_Q(ntryL,G0H4(13),22,0,G1H4(48),n2h4(199))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[22,9],[0,0],2,2,wf8(:,39),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(14),m3h8x4(:,204),heltab2x32(:,:,419))
  call Hloop_A_Q(ntryL,G0H4(14),22,0,G1H4(99),n2h4(200))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[25,6],[0,0],2,2,wf8(:,43),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(15),m3h8x4(:,205),heltab2x32(:,:,420))
  call Hloop_Q_A(ntryL,G0H4(15),25,0,G1H4(119),n2h4(201))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[25,6],[0,nMZ],2,2,wf8(:,43),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(41),ngZd,m3h8x4(:,206),heltab2x32(:,:,421))
  call Hloop_Q_A(ntryL,G0H4(41),25,0,G1H4(172),n2h4(202))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[25,6],[0,nMW],2,2,wf8(:,43),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(19),m3h8x4(:,207),heltab2x32(:,:,422))
  call Hloop_Q_A(ntryL,G0H4(19),25,0,G1H4(121),n2h4(203))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[25,6],[0,0],2,2,wf8(:,43),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(17),m3h8x4(:,208),heltab2x32(:,:,423))
  call Hloop_Q_A(ntryL,G0H4(17),25,0,G1H4(159),n2h4(204))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[17,14],[0,0],2,2,wf4(:,12),wf8(:,42))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(6),m3h4x8(:,55),heltab2x32(:,:,424))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[17,14],[nMZ,0],2,2,wf4(:,12),wf8(:,42))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(15),ngZd,m3h4x8(:,56),heltab2x32(:,:,425))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[17,14],[nMW,0],2,2,wf4(:,12),wf8(:,42))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,57),heltab2x32(:,:,426))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[17,14],[0,0],2,2,wf4(:,12),wf8(:,42))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(5),m3h4x8(:,58),heltab2x32(:,:,427))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[18,13],[0,0],2,2,wf4(:,6),wf8(:,46))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(3),m3h4x8(:,59),heltab2x32(:,:,428))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[18,13],[nMZ,0],2,2,wf4(:,6),wf8(:,46))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(4),ngZd,m3h4x8(:,60),heltab2x32(:,:,429))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[18,13],[nMW,0],2,2,wf4(:,6),wf8(:,46))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(14),m3h4x8(:,61),heltab2x32(:,:,430))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[18,13],[0,0],2,2,wf4(:,6),wf8(:,46))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(8),m3h4x8(:,62),heltab2x32(:,:,431))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[22,9],[0,0],2,2,wf8(:,45),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,45),G0H4(42),m3h8x4(:,209),heltab2x32(:,:,432))
  call Hloop_A_Q(ntryL,G0H4(42),22,0,G1H4(124),n2h4(205))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[22,9],[0,nMZ],2,2,wf8(:,45),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,45),G0H4(20),ngZd,m3h8x4(:,210),heltab2x32(:,:,433))
  call Hloop_A_Q(ntryL,G0H4(20),22,0,G1H4(177),n2h4(206))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[22,9],[0,nMW],2,2,wf8(:,45),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,45),G0H4(18),m3h8x4(:,211),heltab2x32(:,:,434))
  call Hloop_A_Q(ntryL,G0H4(18),22,0,G1H4(30),n2h4(207))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[22,9],[0,0],2,2,wf8(:,45),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,45),G0H4(45),m3h8x4(:,212),heltab2x32(:,:,435))
  call Hloop_A_Q(ntryL,G0H4(45),22,0,G1H4(174),n2h4(208))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[21,10],[0,0],2,2,wf8(:,49),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,49),G0H4(23),m3h8x4(:,213),heltab2x32(:,:,436))
  call Hloop_Q_A(ntryL,G0H4(23),21,0,G1H4(126),n2h4(209))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[21,10],[0,nMZ],2,2,wf8(:,49),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,49),G0H4(21),ngZd,m3h8x4(:,214),heltab2x32(:,:,437))
  call Hloop_Q_A(ntryL,G0H4(21),21,0,G1H4(39),n2h4(210))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[21,10],[0,nMW],2,2,wf8(:,49),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,49),G0H4(46),m3h8x4(:,215),heltab2x32(:,:,438))
  call Hloop_Q_A(ntryL,G0H4(46),21,0,G1H4(133),n2h4(211))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[21,10],[0,0],2,2,wf8(:,49),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,49),G0H4(24),m3h8x4(:,216),heltab2x32(:,:,439))
  call Hloop_Q_A(ntryL,G0H4(24),21,0,G1H4(151),n2h4(212))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[17,14],[0,0],2,2,wf4(:,12),wf8(:,48))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,63),heltab2x32(:,:,440))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[17,14],[nMZ,0],2,2,wf4(:,12),wf8(:,48))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(7),ngZd,m3h4x8(:,64),heltab2x32(:,:,441))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[17,14],[nMW,0],2,2,wf4(:,12),wf8(:,48))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(18),m3h4x8(:,65),heltab2x32(:,:,442))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[17,14],[0,0],2,2,wf4(:,12),wf8(:,48))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(12),m3h4x8(:,66),heltab2x32(:,:,443))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(6),[G0H2(5),G0H2(3),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(8),[G0H2(7),G0H2(2),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(14),[G0H2(13),G0H2(10),G0H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(16),[G0H2(15),G0H2(12),G0H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(13),G1H4(165),G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(52),G1H4(21),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(151),[G1H4(126),G1H4(76),G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(83),[G1H4(176),G1H4(45),G1H4(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G1H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(2),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(159),[G1H4(119),G1H4(36),G1H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(172),[G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(174),[G1H4(124),G1H4(99),G1H4(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(177),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(5),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(8),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(12),[G0H8(9)])
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(6),27,ex3(:),4,G1tensor(145),m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(8),27,ex3(:),4,G1tensor(14),m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(14),23,ex4(:),8,G1tensor(156),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(16),23,ex4(:),8,G1tensor(36),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H4(22),ex4(:),ex3(:),G1tensor(48),m4h2x2x1(:,3),heltab3x4(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(53),ex4(:),ex3(:),G1tensor(96),m4h2x2x1(:,4),heltab3x4(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(151),wf4(:,4),G1tensor(72),m3h4x1(:,75),heltab2x4(:,:,369))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(39),wf4(:,4),G1tensor(86),ngZd,m3h4x1(:,76),heltab2x4(:,:,370))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(133),wf4(:,4),G1tensor(120),m3h4x1(:,77),heltab2x4(:,:,371))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(83),wf4(:,3),G1tensor(110),m3h4x1(:,78),heltab2x4(:,:,372))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(138),wf4(:,3),G1tensor(122),ngZd,m3h4x1(:,79),heltab2x4(:,:,373))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(122),wf4(:,3),G1tensor(138),m3h4x1(:,80),heltab2x4(:,:,374))
  call Hloop_VQ_A(ntryL,G0H8(2),wf8(:,37),G0H1(1),m3h8x1(:,29),heltab2x8(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(45),n2h1(595))
  call Hloop_ZQ_A(ntryL,G0H8(17),wf8(:,37),G0H1(1),ngZd,m3h8x1(:,30),heltab2x8(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(5),n2h1(596))
  call Hloop_WQ_A(ntryL,G0H8(19),wf8(:,37),G0H1(1),m3h8x1(:,31),heltab2x8(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(15),n2h1(597))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(159),wf4(:,10),G1tensor(22),m3h4x1(:,81),heltab2x4(:,:,375))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(172),wf4(:,10),G1tensor(41),ngZd,m3h4x1(:,82),heltab2x4(:,:,376))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(121),wf4(:,10),G1tensor(40),m3h4x1(:,83),heltab2x4(:,:,377))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(174),wf4(:,9),G1tensor(52),m3h4x1(:,84),heltab2x4(:,:,378))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(177),wf4(:,9),G1tensor(57),ngZd,m3h4x1(:,85),heltab2x4(:,:,379))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(30),wf4(:,9),G1tensor(136),m3h4x1(:,86),heltab2x4(:,:,380))
  call Hloop_VA_Q(ntryL,G0H8(5),wf8(:,42),G0H1(1),m3h8x1(:,32),heltab2x8(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(94),n2h1(598))
  call Hloop_ZA_Q(ntryL,G0H8(15),wf8(:,42),G0H1(1),ngZd,m3h8x1(:,33),heltab2x8(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(89),n2h1(599))
  call Hloop_WA_Q(ntryL,G0H8(1),wf8(:,42),G0H1(1),m3h8x1(:,34),heltab2x8(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(101),n2h1(600))
  call Hloop_VQ_A(ntryL,G0H8(8),wf8(:,46),G0H1(1),m3h8x1(:,35),heltab2x8(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(113),n2h1(601))
  call Hloop_ZQ_A(ntryL,G0H8(4),wf8(:,46),G0H1(1),ngZd,m3h8x1(:,36),heltab2x8(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(129),n2h1(602))
  call Hloop_WQ_A(ntryL,G0H8(14),wf8(:,46),G0H1(1),m3h8x1(:,37),heltab2x8(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(142),n2h1(603))
  call Hloop_VA_Q(ntryL,G0H8(12),wf8(:,48),G0H1(1),m3h8x1(:,38),heltab2x8(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(7),n2h1(604))
  call Hloop_ZA_Q(ntryL,G0H8(7),wf8(:,48),G0H1(1),ngZd,m3h8x1(:,39),heltab2x8(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(161),n2h1(605))
  call Hloop_WA_Q(ntryL,G0H8(18),wf8(:,48),G0H1(1),m3h8x1(:,40),heltab2x8(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(166),n2h1(606))
  call ol_merge_tensors(G0tensor(645),[G0tensor(640),G0tensor(596),G0tensor(574),G0tensor(569),G0tensor(565),G0tensor(546) &
    ,G0tensor(541),G0tensor(537),G0tensor(488),G0tensor(418),G0tensor(423),G0tensor(357),G0tensor(248),G0tensor(416),G0tensor(167) &
    ,G0tensor(157),G0tensor(73),G0tensor(168),G0tensor(296),G0tensor(434),G0tensor(199),G0tensor(9),G0tensor(440),G0tensor(200) &
    ,G0tensor(175),G0tensor(155),G0tensor(60),G0tensor(35),G0tensor(15)])
  call ol_merge_tensors(G0tensor(321),[G0tensor(464),G0tensor(1),G0tensor(455),G0tensor(435),G0tensor(415),G0tensor(395) &
    ,G0tensor(225),G0tensor(90),G0tensor(20)])
  call ol_merge_tensors(G1tensor(110),[G0tensor(593),G0tensor(589),G0tensor(353),G0tensor(467),G0tensor(29),G0tensor(5) &
    ,G0tensor(445),G0tensor(25)])
  call ol_merge_tensors(G0tensor(12),[G0tensor(289),G0tensor(490),G0tensor(245),G0tensor(40)])
  call ol_merge_tensors(G1tensor(122),[G0tensor(261),G0tensor(515),G0tensor(45)])
  call ol_merge_tensors(G0tensor(648),[G0tensor(643),G0tensor(571),G0tensor(557),G0tensor(543),G0tensor(529),G0tensor(446) &
    ,G0tensor(406),G0tensor(437),G0tensor(341),G0tensor(148),G0tensor(271),G0tensor(254),G0tensor(208),G0tensor(109),G0tensor(48) &
    ,G0tensor(77),G0tensor(36),G0tensor(151),G0tensor(111),G0tensor(41),G0tensor(505),G0tensor(260),G0tensor(190),G0tensor(120) &
    ,G0tensor(50)])
  call ol_merge_tensors(G0tensor(524),[G0tensor(509),G0tensor(294),G0tensor(51),G0tensor(370),G0tensor(345),G0tensor(270) &
    ,G0tensor(65)])
  call ol_merge_tensors(G1tensor(138),[G0tensor(276),G0tensor(316),G0tensor(102),G0tensor(355),G0tensor(70)])
  call ol_merge_tensors(G0tensor(586),[G0tensor(581),G0tensor(576),G0tensor(562),G0tensor(548),G0tensor(534),G0tensor(518) &
    ,G0tensor(497),G0tensor(242),G0tensor(407),G0tensor(253),G0tensor(232),G0tensor(226),G0tensor(387),G0tensor(506),G0tensor(494) &
    ,G0tensor(461),G0tensor(212),G0tensor(182),G0tensor(376),G0tensor(188),G0tensor(82),G0tensor(43),G0tensor(34),G0tensor(159) &
    ,G0tensor(194),G0tensor(306),G0tensor(114),G0tensor(504),G0tensor(274),G0tensor(329),G0tensor(89),G0tensor(359),G0tensor(484) &
    ,G0tensor(163),G0tensor(68),G0tensor(219),G0tensor(184),G0tensor(332),G0tensor(19),G0tensor(62),G0tensor(156),G0tensor(136) &
    ,G0tensor(61),G0tensor(385),G0tensor(360),G0tensor(335),G0tensor(310),G0tensor(285),G0tensor(215),G0tensor(145) &
    ,G0tensor(75)])
  call ol_merge_tensors(G0tensor(398),[G0tensor(392),G0tensor(372),G0tensor(426),G0tensor(386),G0tensor(256),G0tensor(39) &
    ,G0tensor(132),G0tensor(196),G0tensor(96),G0tensor(230),G0tensor(160),G0tensor(85)])
  call ol_merge_tensors(G0tensor(178),[G0tensor(53),G0tensor(404),G0tensor(86),G0tensor(280),G0tensor(255),G0tensor(235) &
    ,G0tensor(140),G0tensor(115),G0tensor(95)])
  call ol_merge_tensors(G0tensor(444),[G0tensor(21),G0tensor(126),G0tensor(180),G0tensor(105)])
  call ol_merge_tensors(G0tensor(356),[G0tensor(336),G0tensor(301),G0tensor(106),G0tensor(110)])
  call ol_merge_tensors(G0tensor(233),[G0tensor(259),G0tensor(384),G0tensor(186),G0tensor(320),G0tensor(295),G0tensor(205) &
    ,G0tensor(130)])
  call ol_merge_tensors(G0tensor(522),[G0tensor(474),G0tensor(257),G0tensor(342),G0tensor(346),G0tensor(83),G0tensor(42) &
    ,G0tensor(135)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(550),G0tensor(462),G0tensor(442),G0tensor(279),G0tensor(139),G0tensor(483) &
    ,G0tensor(206),G0tensor(165)])
  call ol_merge_tensors(G1tensor(41),[G0tensor(103),G0tensor(244),G0tensor(185)])
  call ol_merge_tensors(G1tensor(40),[G0tensor(578),G0tensor(123),G0tensor(221),G0tensor(305),G0tensor(210)])
  call ol_merge_tensors(G0tensor(192),[G0tensor(396),G0tensor(23),G0tensor(47),G0tensor(250)])
  call ol_merge_tensors(G0tensor(503),[G0tensor(478),G0tensor(231),G0tensor(312),G0tensor(521),G0tensor(451),G0tensor(177) &
    ,G0tensor(33),G0tensor(59),G0tensor(275)])
  call ol_merge_tensors(G1tensor(14),[G1tensor(145),G0tensor(584),G0tensor(516),G0tensor(262),G0tensor(169),G0tensor(149) &
    ,G0tensor(64),G0tensor(354),G0tensor(67),G0tensor(350),G0tensor(300)])
  call ol_merge_tensors(G1tensor(36),[G1tensor(156),G0tensor(579),G0tensor(322),G0tensor(489),G0tensor(381),G0tensor(84) &
    ,G0tensor(54),G0tensor(87),G0tensor(349),G0tensor(375),G0tensor(325)])
  call ol_merge_tensors(G1tensor(120),[G0tensor(583),G0tensor(237),G0tensor(496),G0tensor(98),G0tensor(330)])
  call ol_merge_tensors(G1tensor(136),[G0tensor(347),G0tensor(307),G0tensor(214),G0tensor(324),G0tensor(380)])
  call ol_merge_tensors(G0tensor(458),[G0tensor(378),G0tensor(373),G0tensor(49),G0tensor(284),G0tensor(16),G0tensor(181) &
    ,G0tensor(101),G0tensor(81),G0tensor(400)])
  call ol_merge_tensors(G1tensor(113),[G1tensor(45),G0tensor(598),G0tensor(590),G0tensor(468),G0tensor(402),G0tensor(362) &
    ,G0tensor(91),G0tensor(405)])
  call ol_merge_tensors(G1tensor(7),[G1tensor(94),G0tensor(566),G0tensor(552),G0tensor(388),G0tensor(334),G0tensor(351) &
    ,G0tensor(411),G0tensor(420)])
  call ol_merge_tensors(G0tensor(594),[G0tensor(538),G0tensor(513),G0tensor(507),G0tensor(412),G0tensor(117),G0tensor(374) &
    ,G0tensor(78),G0tensor(431),G0tensor(119),G0tensor(11),G0tensor(224),G0tensor(211),G0tensor(166),G0tensor(176),G0tensor(252) &
    ,G0tensor(141),G0tensor(71),G0tensor(46),G0tensor(480),G0tensor(7),G0tensor(425)])
  call ol_merge_tensors(G0tensor(588),[G0tensor(560),G0tensor(555),G0tensor(551),G0tensor(532),G0tensor(527),G0tensor(523) &
    ,G0tensor(422),G0tensor(443),G0tensor(348),G0tensor(413),G0tensor(277),G0tensor(441),G0tensor(297),G0tensor(142),G0tensor(337) &
    ,G0tensor(143),G0tensor(107),G0tensor(460)])
  call ol_merge_tensors(G1tensor(52),[G0tensor(597),G0tensor(428),G0tensor(361),G0tensor(201),G0tensor(191),G0tensor(465)])
  call ol_merge_tensors(G1tensor(72),[G0tensor(592),G0tensor(564),G0tensor(368),G0tensor(187),G0tensor(99),G0tensor(6) &
    ,G0tensor(2)])
  call ol_merge_tensors(G0tensor(536),[G0tensor(223),G0tensor(501),G0tensor(138),G0tensor(154),G0tensor(216),G0tensor(487) &
    ,G0tensor(66),G0tensor(500),G0tensor(475),G0tensor(3)])
  call ol_merge_tensors(G0tensor(568),[G0tensor(202),G0tensor(520),G0tensor(495)])
  call ol_merge_tensors(G0tensor(573),[G0tensor(302),G0tensor(272),G0tensor(309),G0tensor(76),G0tensor(491)])
  call ol_merge_tensors(G1tensor(129),[G1tensor(5),G0tensor(542),G0tensor(528),G0tensor(121),G0tensor(116)])
  call ol_merge_tensors(G1tensor(142),[G1tensor(15),G0tensor(547),G0tensor(533),G0tensor(173),G0tensor(264),G0tensor(171) &
    ,G0tensor(161)])
  call ol_merge_tensors(G0tensor(540),[G0tensor(137),G0tensor(236),G0tensor(492)])
  call ol_merge_tensors(G0tensor(545),[G0tensor(469),G0tensor(481),G0tensor(299),G0tensor(72),G0tensor(239)])
  call ol_merge_tensors(G1tensor(161),[G1tensor(89),G0tensor(570),G0tensor(556),G0tensor(129),G0tensor(234)])
  call ol_merge_tensors(G1tensor(166),[G1tensor(101),G0tensor(575),G0tensor(561),G0tensor(482),G0tensor(319),G0tensor(79) &
    ,G0tensor(58),G0tensor(421)])
  call ol_merge_tensors(G0tensor(531),[G0tensor(217),G0tensor(311),G0tensor(27),G0tensor(88),G0tensor(304)])
  call ol_merge_tensors(G0tensor(559),[G0tensor(397),G0tensor(292),G0tensor(499),G0tensor(97),G0tensor(364)])
  call ol_merge_tensors(G0tensor(283),[G0tensor(383),G0tensor(251),G0tensor(118)])
  call ol_merge_tensors(G0tensor(622),[G0tensor(602),G0tensor(371)])
  call ol_merge_tensors(G0tensor(627),[G0tensor(607),G0tensor(389),G0tensor(204)])
  call ol_merge_tensors(G0tensor(628),[G0tensor(623),G0tensor(608),G0tensor(603),G0tensor(313),G0tensor(333),G0tensor(267) &
    ,G0tensor(162),G0tensor(144)])
  call ol_merge_tensors(G0tensor(323),[G0tensor(318),G0tensor(278),G0tensor(344)])
  call ol_merge_tensors(G0tensor(632),[G0tensor(612),G0tensor(198)])
  call ol_merge_tensors(G0tensor(637),[G0tensor(617),G0tensor(429),G0tensor(128)])
  call ol_merge_tensors(G0tensor(638),[G0tensor(633),G0tensor(618),G0tensor(613),G0tensor(448),G0tensor(298),G0tensor(403) &
    ,G0tensor(399),G0tensor(409)])
  call ol_merge_tensors(G0tensor(620),[G0tensor(606),G0tensor(601),G0tensor(288),G0tensor(343),G0tensor(152)])
  call ol_merge_tensors(G0tensor(605),[G0tensor(273),G0tensor(419)])
  call ol_merge_tensors(G0tensor(630),[G0tensor(616),G0tensor(611),G0tensor(327),G0tensor(308),G0tensor(394)])
  call ol_merge_tensors(G0tensor(615),[G0tensor(263),G0tensor(164)])
  call ol_merge_tensors(G0tensor(512),[G0tensor(287),G0tensor(113),G0tensor(92),G0tensor(213),G0tensor(281),G0tensor(472) &
    ,G0tensor(22),G0tensor(514),G0tensor(17),G0tensor(38),G0tensor(459),G0tensor(449),G0tensor(439),G0tensor(269)])
  call ol_merge_tensors(G0tensor(526),[G0tensor(158),G0tensor(207)])



end subroutine vamp_3

end module ol_vamp_3_ppvvj_ew_ddxaag_1_/**/REALKIND
