
module ol_vamp_4_ppvvj_ew_ddxazg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_4(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj_ew_ddxazg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj_ew_ddxazg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvj_ew_ddxazg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvj_ew_ddxazg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvj_ew_ddxazg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvj_ew_ddxazg_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(48)
  type(Hpolcont), intent(in) :: M(2,48)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(13),m3h4x12(:,61),heltab2x48(:,:,430))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(447),h0tab(:,447),[18,13],[0,0],2,2,wf4(:,4),wf12(:,31))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(14),m3h4x12(:,62),heltab2x48(:,:,431))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(448),h0tab(:,448),[22,9],[0,0],2,2,wf8(:,17),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf8(:,17),G0H6(6),m3h8x6(:,173),heltab2x48(:,:,432))
  call Hloop_A_Q(ntryL,G0H6(6),22,0,G1H6(72),n2h6(172))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(449),h0tab(:,449),[22,9],[0,nMZ],2,2,wf8(:,17),wf6(:,4))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf8(:,17),G0H6(7),ngZd,m3h8x6(:,174),heltab2x48(:,:,433))
  call Hloop_A_Q(ntryL,G0H6(7),22,0,G1H6(44),n2h6(173))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(450),h0tab(:,450),[22,9],[0,nMW],2,2,wf8(:,17),wf6(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf8(:,17),G0H6(8),m3h8x6(:,175),heltab2x48(:,:,434))
  call Hloop_A_Q(ntryL,G0H6(8),22,0,G1H6(45),n2h6(174))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(451),h0tab(:,451),[22,9],[0,0],2,2,wf8(:,17),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf8(:,17),G0H6(29),m3h8x6(:,176),heltab2x48(:,:,435))
  call Hloop_A_Q(ntryL,G0H6(29),22,0,G1H6(20),n2h6(175))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(452),h0tab(:,452),[21,10],[0,0],2,2,wf8(:,18),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf8(:,18),G0H6(5),m3h8x6(:,177),heltab2x48(:,:,436))
  call Hloop_Q_A(ntryL,G0H6(5),21,0,G1H6(87),n2h6(176))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(453),h0tab(:,453),[21,10],[0,nMZ],2,2,wf8(:,18),wf6(:,2))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf8(:,18),G0H6(15),ngZd,m3h8x6(:,178),heltab2x48(:,:,437))
  call Hloop_Q_A(ntryL,G0H6(15),21,0,G1H6(51),n2h6(177))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(454),h0tab(:,454),[21,10],[0,nMW],2,2,wf8(:,18),wf6(:,2))
  call Hloop_WQ_A(ntryL,G0H48(1),wf8(:,18),G0H6(30),m3h8x6(:,179),heltab2x48(:,:,438))
  call Hloop_Q_A(ntryL,G0H6(30),21,0,G1H6(21),n2h6(178))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(455),h0tab(:,455),[21,10],[0,0],2,2,wf8(:,18),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf8(:,18),G0H6(10),m3h8x6(:,180),heltab2x48(:,:,439))
  call Hloop_Q_A(ntryL,G0H6(10),21,0,G1H6(88),n2h6(179))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(456),h0tab(:,456),[17,14],[0,0],2,2,wf4(:,8),wf12(:,33))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(8),m3h4x12(:,63),heltab2x48(:,:,440))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(457),h0tab(:,457),[17,14],[nMZ,0],2,2,wf4(:,8),wf12(:,33))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,8),G0H12(10),ngZd,m3h4x12(:,64),heltab2x48(:,:,441))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(458),h0tab(:,458),[17,14],[nMW,0],2,2,wf4(:,8),wf12(:,33))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,8),G0H12(17),m3h4x12(:,65),heltab2x48(:,:,442))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(459),h0tab(:,459),[17,14],[0,0],2,2,wf4(:,8),wf12(:,33))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(18),m3h4x12(:,66),heltab2x48(:,:,443))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(6),[G0H2(5),G0H2(2),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(8),[G0H2(7),G0H2(4),G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(6),[G0H3(5),G0H3(3),G0H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(8),[G0H3(7),G0H3(2),G0H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(64),[G1H6(13),G1H6(132),G1H6(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(77),[G1H6(104),G1H6(74),G1H6(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(88),[G1H6(87),G1H6(81),G1H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(51),[G1H6(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(21),[G1H6(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(6),G1H4(2),G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(11),[G0H12(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(18),G1H4(17),G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(20),[G1H6(72),G1H6(86),G1H6(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(44),[G1H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(45),[G1H6(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(4),[G0H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(14),[G0H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(18),[G0H12(8)])
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(6),27,ex3(:),4,G1tensor(145),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(8),27,ex3(:),4,G1tensor(14),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H3(6),23,ex4(:),8,G1tensor(156),m3h3x1(:,310),heltab2x3(:,:,310))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H3(8),23,ex4(:),8,G1tensor(36),m3h3x1(:,311),heltab2x3(:,:,311))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H6(64),ex4(:),ex3(:),G1tensor(48),m4h3x2x1(:,3),heltab3x6(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H6(77),ex4(:),ex3(:),G1tensor(96),m4h3x2x1(:,4),heltab3x6(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(88),wf6(:,2),G1tensor(72),m3h6x1(:,51),heltab2x6(:,:,321))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H6(51),wf6(:,2),G1tensor(86),ngZd,m3h6x1(:,52),heltab2x6(:,:,322))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H6(21),wf6(:,2),G1tensor(120),m3h6x1(:,53),heltab2x6(:,:,323))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(9),wf4(:,2),G1tensor(110),m3h4x1(:,25),heltab2x4(:,:,73))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(7),wf4(:,2),G1tensor(122),ngZd,m3h4x1(:,26),heltab2x4(:,:,74))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(8),wf4(:,2),G1tensor(138),m3h4x1(:,27),heltab2x4(:,:,75))
  call Hloop_VQ_A(ntryL,G0H12(11),wf12(:,26),G0H1(1),m3h12x1(:,29),heltab2x12(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(45),n2h1(621))
  call Hloop_ZQ_A(ntryL,G0H12(2),wf12(:,26),G0H1(1),ngZd,m3h12x1(:,30),heltab2x12(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(5),n2h1(622))
  call Hloop_WQ_A(ntryL,G0H12(6),wf12(:,26),G0H1(1),m3h12x1(:,31),heltab2x12(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(15),n2h1(623))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(25),wf4(:,6),G1tensor(22),m3h4x1(:,28),heltab2x4(:,:,76))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(19),wf4(:,6),G1tensor(41),ngZd,m3h4x1(:,29),heltab2x4(:,:,77))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(20),wf4(:,6),G1tensor(40),m3h4x1(:,30),heltab2x4(:,:,78))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(20),wf6(:,4),G1tensor(52),m3h6x1(:,54),heltab2x6(:,:,324))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H6(44),wf6(:,4),G1tensor(57),ngZd,m3h6x1(:,55),heltab2x6(:,:,325))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H6(45),wf6(:,4),G1tensor(136),m3h6x1(:,56),heltab2x6(:,:,326))
  call Hloop_VA_Q(ntryL,G0H12(4),wf12(:,29),G0H1(1),m3h12x1(:,32),heltab2x12(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(94),n2h1(624))
  call Hloop_ZA_Q(ntryL,G0H12(5),wf12(:,29),G0H1(1),ngZd,m3h12x1(:,33),heltab2x12(:,:,201))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(89),n2h1(625))
  call Hloop_WA_Q(ntryL,G0H12(3),wf12(:,29),G0H1(1),m3h12x1(:,34),heltab2x12(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(101),n2h1(626))
  call Hloop_VQ_A(ntryL,G0H12(14),wf12(:,31),G0H1(1),m3h12x1(:,35),heltab2x12(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(113),n2h1(627))
  call Hloop_ZQ_A(ntryL,G0H12(7),wf12(:,31),G0H1(1),ngZd,m3h12x1(:,36),heltab2x12(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(129),n2h1(628))
  call Hloop_WQ_A(ntryL,G0H12(13),wf12(:,31),G0H1(1),m3h12x1(:,37),heltab2x12(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(142),n2h1(629))
  call Hloop_VA_Q(ntryL,G0H12(18),wf12(:,33),G0H1(1),m3h12x1(:,38),heltab2x12(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(7),n2h1(630))
  call Hloop_ZA_Q(ntryL,G0H12(10),wf12(:,33),G0H1(1),ngZd,m3h12x1(:,39),heltab2x12(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(161),n2h1(631))
  call Hloop_WA_Q(ntryL,G0H12(17),wf12(:,33),G0H1(1),m3h12x1(:,40),heltab2x12(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(166),n2h1(632))
  call ol_merge_tensors(G0tensor(645),[G0tensor(640),G0tensor(596),G0tensor(574),G0tensor(569),G0tensor(565),G0tensor(546) &
    ,G0tensor(541),G0tensor(537),G0tensor(488),G0tensor(418),G0tensor(423),G0tensor(357),G0tensor(248),G0tensor(416),G0tensor(167) &
    ,G0tensor(157),G0tensor(73),G0tensor(168),G0tensor(296),G0tensor(434),G0tensor(199),G0tensor(9),G0tensor(440),G0tensor(200) &
    ,G0tensor(175),G0tensor(155),G0tensor(60),G0tensor(35),G0tensor(15)])
  call ol_merge_tensors(G0tensor(321),[G0tensor(464),G0tensor(1),G0tensor(455),G0tensor(435),G0tensor(415),G0tensor(395) &
    ,G0tensor(225),G0tensor(90),G0tensor(20)])
  call ol_merge_tensors(G1tensor(110),[G0tensor(593),G0tensor(589),G0tensor(353),G0tensor(467),G0tensor(29),G0tensor(5) &
    ,G0tensor(445),G0tensor(25)])
  call ol_merge_tensors(G0tensor(12),[G0tensor(289),G0tensor(490),G0tensor(245),G0tensor(40)])
  call ol_merge_tensors(G1tensor(122),[G0tensor(261),G0tensor(515),G0tensor(45)])
  call ol_merge_tensors(G0tensor(648),[G0tensor(643),G0tensor(571),G0tensor(557),G0tensor(543),G0tensor(529),G0tensor(446) &
    ,G0tensor(406),G0tensor(437),G0tensor(341),G0tensor(148),G0tensor(271),G0tensor(254),G0tensor(208),G0tensor(109),G0tensor(48) &
    ,G0tensor(77),G0tensor(36),G0tensor(151),G0tensor(111),G0tensor(41),G0tensor(505),G0tensor(260),G0tensor(190),G0tensor(120) &
    ,G0tensor(50)])
  call ol_merge_tensors(G0tensor(524),[G0tensor(509),G0tensor(294),G0tensor(51),G0tensor(370),G0tensor(345),G0tensor(270) &
    ,G0tensor(65)])
  call ol_merge_tensors(G1tensor(138),[G0tensor(276),G0tensor(316),G0tensor(102),G0tensor(355),G0tensor(70)])
  call ol_merge_tensors(G0tensor(586),[G0tensor(581),G0tensor(576),G0tensor(562),G0tensor(548),G0tensor(534),G0tensor(518) &
    ,G0tensor(497),G0tensor(242),G0tensor(407),G0tensor(253),G0tensor(232),G0tensor(226),G0tensor(387),G0tensor(506),G0tensor(494) &
    ,G0tensor(461),G0tensor(212),G0tensor(182),G0tensor(376),G0tensor(188),G0tensor(82),G0tensor(43),G0tensor(34),G0tensor(159) &
    ,G0tensor(194),G0tensor(306),G0tensor(114),G0tensor(504),G0tensor(274),G0tensor(329),G0tensor(89),G0tensor(359),G0tensor(484) &
    ,G0tensor(163),G0tensor(68),G0tensor(219),G0tensor(184),G0tensor(332),G0tensor(19),G0tensor(62),G0tensor(156),G0tensor(136) &
    ,G0tensor(61),G0tensor(385),G0tensor(360),G0tensor(335),G0tensor(310),G0tensor(285),G0tensor(215),G0tensor(145) &
    ,G0tensor(75)])
  call ol_merge_tensors(G0tensor(398),[G0tensor(392),G0tensor(372),G0tensor(426),G0tensor(386),G0tensor(256),G0tensor(39) &
    ,G0tensor(132),G0tensor(196),G0tensor(96),G0tensor(230),G0tensor(160),G0tensor(85)])
  call ol_merge_tensors(G0tensor(178),[G0tensor(53),G0tensor(404),G0tensor(86),G0tensor(280),G0tensor(255),G0tensor(235) &
    ,G0tensor(140),G0tensor(115),G0tensor(95)])
  call ol_merge_tensors(G0tensor(444),[G0tensor(21),G0tensor(126),G0tensor(180),G0tensor(105)])
  call ol_merge_tensors(G0tensor(356),[G0tensor(336),G0tensor(301),G0tensor(106),G0tensor(110)])
  call ol_merge_tensors(G0tensor(233),[G0tensor(259),G0tensor(384),G0tensor(186),G0tensor(320),G0tensor(295),G0tensor(205) &
    ,G0tensor(130)])
  call ol_merge_tensors(G0tensor(522),[G0tensor(474),G0tensor(257),G0tensor(342),G0tensor(346),G0tensor(83),G0tensor(42) &
    ,G0tensor(135)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(550),G0tensor(462),G0tensor(442),G0tensor(279),G0tensor(139),G0tensor(483) &
    ,G0tensor(206),G0tensor(165)])
  call ol_merge_tensors(G1tensor(41),[G0tensor(103),G0tensor(244),G0tensor(185)])
  call ol_merge_tensors(G1tensor(40),[G0tensor(578),G0tensor(123),G0tensor(221),G0tensor(305),G0tensor(210)])
  call ol_merge_tensors(G0tensor(192),[G0tensor(396),G0tensor(23),G0tensor(47),G0tensor(250)])
  call ol_merge_tensors(G0tensor(503),[G0tensor(478),G0tensor(231),G0tensor(312),G0tensor(521),G0tensor(451),G0tensor(177) &
    ,G0tensor(33),G0tensor(59),G0tensor(275)])
  call ol_merge_tensors(G1tensor(14),[G1tensor(145),G0tensor(584),G0tensor(516),G0tensor(262),G0tensor(169),G0tensor(149) &
    ,G0tensor(64),G0tensor(354),G0tensor(67),G0tensor(350),G0tensor(300)])
  call ol_merge_tensors(G1tensor(36),[G1tensor(156),G0tensor(579),G0tensor(322),G0tensor(489),G0tensor(381),G0tensor(84) &
    ,G0tensor(54),G0tensor(87),G0tensor(349),G0tensor(375),G0tensor(325)])
  call ol_merge_tensors(G1tensor(120),[G0tensor(583),G0tensor(237),G0tensor(496),G0tensor(98),G0tensor(330)])
  call ol_merge_tensors(G1tensor(136),[G0tensor(347),G0tensor(307),G0tensor(214),G0tensor(324),G0tensor(380)])
  call ol_merge_tensors(G0tensor(458),[G0tensor(378),G0tensor(373),G0tensor(49),G0tensor(284),G0tensor(16),G0tensor(181) &
    ,G0tensor(101),G0tensor(81),G0tensor(400)])
  call ol_merge_tensors(G1tensor(113),[G1tensor(45),G0tensor(598),G0tensor(590),G0tensor(468),G0tensor(402),G0tensor(362) &
    ,G0tensor(91),G0tensor(405)])
  call ol_merge_tensors(G1tensor(7),[G1tensor(94),G0tensor(566),G0tensor(552),G0tensor(388),G0tensor(334),G0tensor(351) &
    ,G0tensor(411),G0tensor(420)])
  call ol_merge_tensors(G0tensor(594),[G0tensor(538),G0tensor(513),G0tensor(507),G0tensor(412),G0tensor(117),G0tensor(374) &
    ,G0tensor(78),G0tensor(431),G0tensor(119),G0tensor(11),G0tensor(224),G0tensor(211),G0tensor(166),G0tensor(176),G0tensor(252) &
    ,G0tensor(141),G0tensor(71),G0tensor(46),G0tensor(480),G0tensor(7),G0tensor(425)])
  call ol_merge_tensors(G0tensor(588),[G0tensor(560),G0tensor(555),G0tensor(551),G0tensor(532),G0tensor(527),G0tensor(523) &
    ,G0tensor(422),G0tensor(443),G0tensor(348),G0tensor(413),G0tensor(277),G0tensor(441),G0tensor(297),G0tensor(142),G0tensor(337) &
    ,G0tensor(143),G0tensor(107),G0tensor(460)])
  call ol_merge_tensors(G1tensor(52),[G0tensor(597),G0tensor(428),G0tensor(361),G0tensor(201),G0tensor(191),G0tensor(465)])
  call ol_merge_tensors(G1tensor(72),[G0tensor(592),G0tensor(564),G0tensor(368),G0tensor(187),G0tensor(99),G0tensor(6) &
    ,G0tensor(2)])
  call ol_merge_tensors(G0tensor(536),[G0tensor(223),G0tensor(501),G0tensor(138),G0tensor(154),G0tensor(216),G0tensor(487) &
    ,G0tensor(66),G0tensor(500),G0tensor(475),G0tensor(3)])
  call ol_merge_tensors(G0tensor(568),[G0tensor(202),G0tensor(520),G0tensor(495)])
  call ol_merge_tensors(G0tensor(573),[G0tensor(302),G0tensor(272),G0tensor(309),G0tensor(76),G0tensor(491)])
  call ol_merge_tensors(G1tensor(129),[G1tensor(5),G0tensor(542),G0tensor(528),G0tensor(121),G0tensor(116)])
  call ol_merge_tensors(G1tensor(142),[G1tensor(15),G0tensor(547),G0tensor(533),G0tensor(173),G0tensor(264),G0tensor(171) &
    ,G0tensor(161)])
  call ol_merge_tensors(G0tensor(540),[G0tensor(137),G0tensor(236),G0tensor(492)])
  call ol_merge_tensors(G0tensor(545),[G0tensor(469),G0tensor(481),G0tensor(299),G0tensor(72),G0tensor(239)])
  call ol_merge_tensors(G1tensor(161),[G1tensor(89),G0tensor(570),G0tensor(556),G0tensor(129),G0tensor(234)])
  call ol_merge_tensors(G1tensor(166),[G1tensor(101),G0tensor(575),G0tensor(561),G0tensor(482),G0tensor(319),G0tensor(79) &
    ,G0tensor(58),G0tensor(421)])
  call ol_merge_tensors(G0tensor(531),[G0tensor(217),G0tensor(311),G0tensor(27),G0tensor(88),G0tensor(304)])
  call ol_merge_tensors(G0tensor(559),[G0tensor(397),G0tensor(292),G0tensor(499),G0tensor(97),G0tensor(364)])
  call ol_merge_tensors(G0tensor(283),[G0tensor(383),G0tensor(251),G0tensor(118)])
  call ol_merge_tensors(G0tensor(622),[G0tensor(602),G0tensor(371)])
  call ol_merge_tensors(G0tensor(627),[G0tensor(607),G0tensor(389),G0tensor(204)])
  call ol_merge_tensors(G0tensor(628),[G0tensor(623),G0tensor(608),G0tensor(603),G0tensor(313),G0tensor(333),G0tensor(267) &
    ,G0tensor(162),G0tensor(144)])
  call ol_merge_tensors(G0tensor(323),[G0tensor(318),G0tensor(278),G0tensor(344)])
  call ol_merge_tensors(G0tensor(632),[G0tensor(612),G0tensor(198)])
  call ol_merge_tensors(G0tensor(637),[G0tensor(617),G0tensor(429),G0tensor(128)])
  call ol_merge_tensors(G0tensor(638),[G0tensor(633),G0tensor(618),G0tensor(613),G0tensor(448),G0tensor(298),G0tensor(403) &
    ,G0tensor(399),G0tensor(409)])
  call ol_merge_tensors(G0tensor(620),[G0tensor(606),G0tensor(601),G0tensor(288),G0tensor(343),G0tensor(152)])
  call ol_merge_tensors(G0tensor(605),[G0tensor(273),G0tensor(419)])
  call ol_merge_tensors(G0tensor(630),[G0tensor(616),G0tensor(611),G0tensor(327),G0tensor(308),G0tensor(394)])
  call ol_merge_tensors(G0tensor(615),[G0tensor(263),G0tensor(164)])
  call ol_merge_tensors(G0tensor(512),[G0tensor(287),G0tensor(113),G0tensor(92),G0tensor(213),G0tensor(281),G0tensor(472) &
    ,G0tensor(22),G0tensor(514),G0tensor(17),G0tensor(38),G0tensor(459),G0tensor(449),G0tensor(439),G0tensor(269)])
  call ol_merge_tensors(G0tensor(526),[G0tensor(158),G0tensor(207)])
  call ol_merge_tensors(G0tensor(554),[G0tensor(476),G0tensor(249)])
  call ol_merge_tensors(G1tensor(96),[G1tensor(48),G0tensor(477),G0tensor(427),G0tensor(391),G0tensor(44),G0tensor(286)])
  call ol_merge_tensors(G0tensor(502),[G0tensor(246),G0tensor(266),G0tensor(326),G0tensor(124)])
  call ol_merge_tensors(G0tensor(585),[G0tensor(580),G0tensor(417),G0tensor(228)])
  call ol_merge_tensors(G0tensor(626),[G0tensor(621),G0tensor(600),G0tensor(243)])
  call ol_merge_tensors(G0tensor(636),[G0tensor(631),G0tensor(610),G0tensor(268)])
  call ol_merge_tensors(G0tensor(625),[G0tensor(317),G0tensor(338)])
  call ol_merge_tensors(G0tensor(635),[G0tensor(463),G0tensor(303)])
  call ol_merge_tensors(G1tensor(57),[G0tensor(641)])
  call ol_merge_tensors(G1tensor(86),[G0tensor(646)])
call TI_bubble_red(G1tensor(110),26,mass2set(:,1),G0tensor(10),M2L1R1)
call TI_bubble_red(G1tensor(122),26,mass2set(:,2),G0tensor(30),M2L1R1,G0tensor(55))
call TI_bubble_red(G1tensor(138),26,mass2set(:,3),G0tensor(80),M2L1R1,G0tensor(100))
call TI_bubble_red(G1tensor(22),25,mass2set(:,1),G0tensor(125),M2L1R1)
call TI_bubble_red(G1tensor(41),25,mass2set(:,2),G0tensor(150),M2L1R1,G0tensor(170))
call TI_bubble_red(G1tensor(40),25,mass2set(:,3),G0tensor(195),M2L1R1,G0tensor(220))
call TI_bubble_red(G1tensor(14),27,mass2set(:,4),G0tensor(240),M2L1R1,G0tensor(265))
call TI_bubble_red(G1tensor(36),23,mass2set(:,4),G0tensor(290),M2L1R1,G0tensor(315))
call TI_bubble_red(G1tensor(120),21,mass2set(:,3),G0tensor(340),M2L1R1,G0tensor(365))
call TI_bubble_red(G1tensor(136),22,mass2set(:,3),G0tensor(390),M2L1R1,G0tensor(410))
call TI_bubble_red(G1tensor(113),18,mass2set(:,1),G0tensor(430),M2L1R1)
call TI_bubble_red(G1tensor(7),17,mass2set(:,1),G0tensor(450),M2L1R1)
call TI_bubble_red(G1tensor(52),22,mass2set(:,1),G0tensor(470),M2L1R1)
call TI_bubble_red(G1tensor(72),21,mass2set(:,1),G0tensor(4),M2L1R1)
call TI_bubble_red(G1tensor(129),18,mass2set(:,5),G0tensor(8),M2L1R1,G0tensor(485))
call TI_bubble_red(G1tensor(142),18,mass2set(:,6),G0tensor(510),M2L1R1,G0tensor(56))
call TI_bubble_red(G1tensor(161),17,mass2set(:,5),G0tensor(131),M2L1R1,G0tensor(112))
call TI_bubble_red(G1tensor(166),17,mass2set(:,6),G0tensor(122),M2L1R1,G0tensor(247))
call TI_bubble_red(G1tensor(96),19,mass2set(:,4),G0tensor(486),M2L1R1,G0tensor(146))
call TI_bubble_red(G1tensor(57),22,mass2set(:,2),G0tensor(52),M2L1R1,G0tensor(466))
call TI_bubble_red(G1tensor(86),21,mass2set(:,2),G0tensor(471),M2L1R1,G0tensor(26))
  call ol_merge_tensors(G0tensor(26),[G0tensor(466),G0tensor(112),G0tensor(485),G0tensor(170),G0tensor(648),G0tensor(55)])
  call ol_merge_tensors(G0tensor(146),[G0tensor(247),G0tensor(56),G0tensor(410),G0tensor(365),G0tensor(315),G0tensor(265) &
    ,G0tensor(220),G0tensor(586),G0tensor(100)])
  call ol_merge_tensors(T0sum(254),[G0tensor(645)])
  call ol_merge_tensors(T0sum(255),[G0tensor(321)])
  call ol_merge_tensors(T0sum(256),[G0tensor(10)])
  call ol_merge_tensors(T0sum(257),[G0tensor(12)])
  call ol_merge_tensors(T0sum(258),[G0tensor(30)])
  call ol_merge_tensors(T0sum(259),[G0tensor(26)])
  call ol_merge_tensors(T0sum(260),[G0tensor(524)])
  call ol_merge_tensors(T0sum(261),[G0tensor(80)])
  call ol_merge_tensors(T0sum(262),[G0tensor(146)])
  call ol_merge_tensors(T0sum(263),[G0tensor(398)])
  call ol_merge_tensors(T0sum(264),[G0tensor(178)])
  call ol_merge_tensors(T0sum(265),[G0tensor(444)])
  call ol_merge_tensors(T0sum(266),[G0tensor(356)])
  call ol_merge_tensors(T0sum(267),[G0tensor(233)])
  call ol_merge_tensors(T0sum(268),[G0tensor(522)])
  call ol_merge_tensors(T0sum(269),[G0tensor(125)])
  call ol_merge_tensors(T0sum(270),[G0tensor(150)])
  call ol_merge_tensors(T0sum(271),[G0tensor(195)])
  call ol_merge_tensors(T0sum(272),[G0tensor(192)])
  call ol_merge_tensors(T0sum(273),[G0tensor(503)])
  call ol_merge_tensors(T0sum(274),[G0tensor(240)])
  call ol_merge_tensors(T0sum(275),[G0tensor(290)])
  call ol_merge_tensors(T0sum(276),[G0tensor(340)])
  call ol_merge_tensors(T0sum(277),[G0tensor(390)])
  call ol_merge_tensors(T0sum(278),[G0tensor(458)])
  call ol_merge_tensors(T0sum(279),[G0tensor(430)])
  call ol_merge_tensors(T0sum(280),[G0tensor(450)])
  call ol_merge_tensors(T0sum(281),[G0tensor(594)])
  call ol_merge_tensors(T0sum(282),[G0tensor(588)])
  call ol_merge_tensors(T0sum(283),[G0tensor(470)])
  call ol_merge_tensors(T0sum(284),[G0tensor(4)])
  call ol_merge_tensors(T0sum(285),[G0tensor(536)])
  call ol_merge_tensors(T0sum(286),[G0tensor(568)])
  call ol_merge_tensors(T0sum(287),[G0tensor(573)])
  call ol_merge_tensors(T0sum(288),[G0tensor(8)])
  call ol_merge_tensors(T0sum(289),[G0tensor(510)])
  call ol_merge_tensors(T0sum(290),[G0tensor(540)])
  call ol_merge_tensors(T0sum(291),[G0tensor(545)])
  call ol_merge_tensors(T0sum(292),[G0tensor(131)])
  call ol_merge_tensors(T0sum(293),[G0tensor(122)])
  call ol_merge_tensors(T0sum(294),[G0tensor(531)])
  call ol_merge_tensors(T0sum(295),[G0tensor(559)])
  call ol_merge_tensors(T0sum(296),[G0tensor(283)])
  call ol_merge_tensors(T0sum(297),[G0tensor(622)])
  call ol_merge_tensors(T0sum(298),[G0tensor(627)])
  call ol_merge_tensors(T0sum(299),[G0tensor(628)])
  call ol_merge_tensors(T0sum(300),[G0tensor(323)])
  call ol_merge_tensors(T0sum(301),[G0tensor(632)])
  call ol_merge_tensors(T0sum(302),[G0tensor(637)])
  call ol_merge_tensors(T0sum(303),[G0tensor(638)])
  call ol_merge_tensors(T0sum(304),[G0tensor(620)])
  call ol_merge_tensors(T0sum(305),[G0tensor(605)])
  call ol_merge_tensors(T0sum(306),[G0tensor(630)])
  call ol_merge_tensors(T0sum(307),[G0tensor(615)])
  call ol_merge_tensors(T0sum(308),[G0tensor(512)])
  call ol_merge_tensors(T0sum(309),[G0tensor(526)])
  call ol_merge_tensors(T0sum(310),[G0tensor(554)])
  call ol_merge_tensors(T0sum(311),[G0tensor(486)])
  call ol_merge_tensors(T0sum(312),[G0tensor(502)])
  call ol_merge_tensors(T0sum(313),[G0tensor(585)])
  call ol_merge_tensors(T0sum(314),[G0tensor(626)])
  call ol_merge_tensors(T0sum(315),[G0tensor(636)])
  call ol_merge_tensors(T0sum(316),[G0tensor(625)])
  call ol_merge_tensors(T0sum(317),[G0tensor(635)])
  call ol_merge_tensors(T0sum(318),[G0tensor(52)])
  call ol_merge_tensors(T0sum(319),[G0tensor(642)])
  call ol_merge_tensors(T0sum(320),[G0tensor(471)])
  call ol_merge_tensors(T0sum(321),[G0tensor(647)])
  call ol_merge_tensors(T0sum(322),[G0tensor(650)])
  call ol_merge_tensors(T0sum(323),[G0tensor(651)])
  call ol_merge_tensors(T0sum(324),[G0tensor(652)])
  call ol_merge_tensors(T0sum(325),[G0tensor(653)])
  call ol_merge_tensors(T0sum(326),[G0tensor(655)])
  call ol_merge_tensors(T0sum(327),[G0tensor(656)])
  call ol_merge_tensors(T0sum(328),[G0tensor(657)])
  call ol_merge_tensors(T0sum(329),[G0tensor(658)])
  call ol_merge_tensors(T0sum(330),[G0tensor(660)])
  call ol_merge_tensors(T0sum(331),[G0tensor(661)])
  call ol_merge_tensors(T0sum(332),[G0tensor(662)])
  call ol_merge_tensors(T0sum(333),[G0tensor(663)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 17, 21, 29 ],masses2_32,RedSet_4(10),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 29 ],masses2_32,RedSet_4(11),ScalarBoxes(2))
  call compute_scalar_box([ 16, 17, 29 ],masses2_32,RedSet_4(1),ScalarBoxes(3))
  call compute_scalar_box([ 16, 17, 21 ],masses2_32,RedSet_4(2),ScalarBoxes(4))
  call compute_scalar_box([ 1, 5, 13 ],masses2_32,RedSet_4(12),ScalarBoxes(5))
  call compute_scalar_box([ 17, 25, 29 ],masses2_32,RedSet_4(13),ScalarBoxes(6))
  call compute_scalar_box([ 16, 25, 29 ],masses2_32,RedSet_4(14),ScalarBoxes(7))
  call compute_scalar_box([ 16, 17, 25 ],masses2_32,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 1, 9, 13 ],masses2_32,RedSet_4(15),ScalarBoxes(9))
  call compute_scalar_box([ 17, 21, 29 ],masses2_44,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 16, 21, 29 ],masses2_37,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 16, 17, 29 ],masses2_37,RedSet_4(1),ScalarBoxes(12))
  call compute_scalar_box([ 16, 17, 21 ],masses2_37,RedSet_4(2),ScalarBoxes(13))
  call compute_scalar_box([ 1, 5, 13 ],masses2_44,RedSet_4(12),ScalarBoxes(14))
  call compute_scalar_box([ 17, 25, 29 ],masses2_44,RedSet_4(13),ScalarBoxes(15))
  call compute_scalar_box([ 16, 25, 29 ],masses2_37,RedSet_4(14),ScalarBoxes(16))
  call compute_scalar_box([ 16, 17, 25 ],masses2_37,RedSet_4(3),ScalarBoxes(17))
  call compute_scalar_box([ 1, 9, 13 ],masses2_44,RedSet_4(15),ScalarBoxes(18))
  call compute_scalar_box([ 20, 21, 23 ],masses2_32,RedSet_4(16),ScalarBoxes(19))
  call compute_scalar_box([ 16, 21, 23 ],masses2_32,RedSet_4(17),ScalarBoxes(20))
  call compute_scalar_box([ 16, 20, 23 ],masses2_32,RedSet_4(18),ScalarBoxes(21))
  call compute_scalar_box([ 16, 20, 21 ],masses2_32,RedSet_4(4),ScalarBoxes(22))
  call compute_scalar_box([ 4, 5, 7 ],masses2_32,RedSet_4(19),ScalarBoxes(23))
  call compute_scalar_box([ 20, 21, 23 ],masses2_39,RedSet_4(16),ScalarBoxes(24))
  call compute_scalar_box([ 16, 21, 23 ],masses2_39,RedSet_4(17),ScalarBoxes(25))
  call compute_scalar_box([ 16, 20, 21 ],masses2_35,RedSet_4(4),ScalarBoxes(26))
  call compute_scalar_box([ 4, 5, 7 ],masses2_39,RedSet_4(19),ScalarBoxes(27))
  call compute_scalar_box([ 20, 21, 23 ],masses2_36,RedSet_4(16),ScalarBoxes(28))
  call compute_scalar_box([ 16, 21, 23 ],masses2_36,RedSet_4(17),ScalarBoxes(29))
  call compute_scalar_box([ 16, 20, 21 ],masses2_33,RedSet_4(4),ScalarBoxes(30))
  call compute_scalar_box([ 4, 5, 7 ],masses2_36,RedSet_4(19),ScalarBoxes(31))
  call compute_scalar_box([ 18, 19, 23 ],masses2_32,RedSet_4(20),ScalarBoxes(32))
  call compute_scalar_box([ 16, 19, 23 ],masses2_32,RedSet_4(21),ScalarBoxes(33))
  call compute_scalar_box([ 16, 18, 23 ],masses2_32,RedSet_4(22),ScalarBoxes(34))
  call compute_scalar_box([ 16, 18, 19 ],masses2_32,RedSet_4(5),ScalarBoxes(35))
  call compute_scalar_box([ 2, 3, 7 ],masses2_32,RedSet_4(23),ScalarBoxes(36))
  call compute_scalar_box([ 18, 19, 23 ],masses2_45,RedSet_4(20),ScalarBoxes(37))
  call compute_scalar_box([ 16, 18, 23 ],masses2_39,RedSet_4(22),ScalarBoxes(38))
  call compute_scalar_box([ 16, 18, 19 ],masses2_39,RedSet_4(5),ScalarBoxes(39))
  call compute_scalar_box([ 2, 3, 7 ],masses2_45,RedSet_4(23),ScalarBoxes(40))
  call compute_scalar_box([ 18, 19, 23 ],masses2_42,RedSet_4(20),ScalarBoxes(41))
  call compute_scalar_box([ 16, 18, 23 ],masses2_36,RedSet_4(22),ScalarBoxes(42))
  call compute_scalar_box([ 16, 18, 19 ],masses2_36,RedSet_4(5),ScalarBoxes(43))
  call compute_scalar_box([ 2, 3, 7 ],masses2_42,RedSet_4(23),ScalarBoxes(44))
  call compute_scalar_box([ 20, 22, 23 ],masses2_32,RedSet_4(24),ScalarBoxes(45))
  call compute_scalar_box([ 16, 22, 23 ],masses2_32,RedSet_4(25),ScalarBoxes(46))
  call compute_scalar_box([ 16, 20, 22 ],masses2_32,RedSet_4(6),ScalarBoxes(47))
  call compute_scalar_box([ 4, 6, 7 ],masses2_32,RedSet_4(26),ScalarBoxes(48))
  call compute_scalar_box([ 20, 22, 23 ],masses2_39,RedSet_4(24),ScalarBoxes(49))
  call compute_scalar_box([ 16, 22, 23 ],masses2_39,RedSet_4(25),ScalarBoxes(50))
  call compute_scalar_box([ 16, 20, 22 ],masses2_35,RedSet_4(6),ScalarBoxes(51))
  call compute_scalar_box([ 4, 6, 7 ],masses2_39,RedSet_4(26),ScalarBoxes(52))
  call compute_scalar_box([ 20, 22, 23 ],masses2_36,RedSet_4(24),ScalarBoxes(53))
  call compute_scalar_box([ 16, 22, 23 ],masses2_36,RedSet_4(25),ScalarBoxes(54))
  call compute_scalar_box([ 16, 20, 22 ],masses2_33,RedSet_4(6),ScalarBoxes(55))
  call compute_scalar_box([ 4, 6, 7 ],masses2_36,RedSet_4(26),ScalarBoxes(56))
  call compute_scalar_box([ 18, 19, 27 ],masses2_32,RedSet_4(27),ScalarBoxes(57))
  call compute_scalar_box([ 16, 19, 27 ],masses2_32,RedSet_4(28),ScalarBoxes(58))
  call compute_scalar_box([ 16, 18, 27 ],masses2_32,RedSet_4(29),ScalarBoxes(59))
  call compute_scalar_box([ 2, 3, 11 ],masses2_32,RedSet_4(30),ScalarBoxes(60))
  call compute_scalar_box([ 18, 19, 27 ],masses2_45,RedSet_4(27),ScalarBoxes(61))
  call compute_scalar_box([ 16, 18, 27 ],masses2_39,RedSet_4(29),ScalarBoxes(62))
  call compute_scalar_box([ 2, 3, 11 ],masses2_45,RedSet_4(30),ScalarBoxes(63))
  call compute_scalar_box([ 18, 19, 27 ],masses2_42,RedSet_4(27),ScalarBoxes(64))
  call compute_scalar_box([ 16, 18, 27 ],masses2_36,RedSet_4(29),ScalarBoxes(65))
  call compute_scalar_box([ 2, 3, 11 ],masses2_42,RedSet_4(30),ScalarBoxes(66))
  call compute_scalar_box([ 17, 19, 23 ],masses2_32,RedSet_4(31),ScalarBoxes(67))
  call compute_scalar_box([ 16, 17, 23 ],masses2_32,RedSet_4(32),ScalarBoxes(68))
  call compute_scalar_box([ 16, 17, 19 ],masses2_32,RedSet_4(7),ScalarBoxes(69))
  call compute_scalar_box([ 1, 3, 7 ],masses2_32,RedSet_4(33),ScalarBoxes(70))
  call compute_scalar_box([ 17, 19, 23 ],masses2_45,RedSet_4(31),ScalarBoxes(71))
  call compute_scalar_box([ 16, 17, 23 ],masses2_39,RedSet_4(32),ScalarBoxes(72))
  call compute_scalar_box([ 16, 17, 19 ],masses2_39,RedSet_4(7),ScalarBoxes(73))
  call compute_scalar_box([ 1, 3, 7 ],masses2_45,RedSet_4(33),ScalarBoxes(74))
  call compute_scalar_box([ 17, 19, 23 ],masses2_42,RedSet_4(31),ScalarBoxes(75))
  call compute_scalar_box([ 16, 17, 23 ],masses2_36,RedSet_4(32),ScalarBoxes(76))
  call compute_scalar_box([ 16, 17, 19 ],masses2_36,RedSet_4(7),ScalarBoxes(77))
  call compute_scalar_box([ 1, 3, 7 ],masses2_42,RedSet_4(33),ScalarBoxes(78))
  call compute_scalar_box([ 17, 19, 27 ],masses2_32,RedSet_4(34),ScalarBoxes(79))
  call compute_scalar_box([ 16, 17, 27 ],masses2_32,RedSet_4(35),ScalarBoxes(80))
  call compute_scalar_box([ 1, 3, 11 ],masses2_32,RedSet_4(36),ScalarBoxes(81))
  call compute_scalar_box([ 17, 19, 27 ],masses2_45,RedSet_4(34),ScalarBoxes(82))
  call compute_scalar_box([ 16, 17, 27 ],masses2_39,RedSet_4(35),ScalarBoxes(83))
  call compute_scalar_box([ 1, 3, 11 ],masses2_45,RedSet_4(36),ScalarBoxes(84))
  call compute_scalar_box([ 17, 19, 27 ],masses2_42,RedSet_4(34),ScalarBoxes(85))
  call compute_scalar_box([ 16, 17, 27 ],masses2_36,RedSet_4(35),ScalarBoxes(86))
  call compute_scalar_box([ 1, 3, 11 ],masses2_42,RedSet_4(36),ScalarBoxes(87))
  call compute_scalar_box([ 18, 22, 23 ],masses2_43,RedSet_4(37),ScalarBoxes(88))
  call compute_scalar_box([ 16, 18, 22 ],masses2_37,RedSet_4(8),ScalarBoxes(89))
  call compute_scalar_box([ 2, 6, 7 ],masses2_43,RedSet_4(38),ScalarBoxes(90))
  call compute_scalar_box([ 18, 26, 27 ],masses2_43,RedSet_4(39),ScalarBoxes(91))
  call compute_scalar_box([ 16, 26, 27 ],masses2_36,RedSet_4(40),ScalarBoxes(92))
  call compute_scalar_box([ 16, 18, 26 ],masses2_37,RedSet_4(9),ScalarBoxes(93))
  call compute_scalar_box([ 2, 10, 11 ],masses2_43,RedSet_4(41),ScalarBoxes(94))
  call compute_scalar_box([ 17, 21, 23 ],masses2_43,RedSet_4(42),ScalarBoxes(95))
  call compute_scalar_box([ 1, 5, 7 ],masses2_43,RedSet_4(43),ScalarBoxes(96))
  call compute_scalar_box([ 17, 25, 27 ],masses2_43,RedSet_4(44),ScalarBoxes(97))
  call compute_scalar_box([ 16, 25, 27 ],masses2_36,RedSet_4(45),ScalarBoxes(98))
  call compute_scalar_box([ 1, 9, 11 ],masses2_43,RedSet_4(46),ScalarBoxes(99))
! end of process


end subroutine vamp_4

end module ol_vamp_4_ppvvj_ew_ddxazg_1_/**/REALKIND
