
module ol_vamp_3_ppvvj_ew_uuxazg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj_ew_uuxazg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj_ew_uuxazg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvj_ew_uuxazg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvj_ew_uuxazg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvj_ew_uuxazg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvj_ew_uuxazg_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(48)
  type(Hpolcont), intent(in) :: M(2,48)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(252),h0tab(:,252),[19,4,8],[0,0,0],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf8(:,20),G0H6(15),ngZu,m3h8x6(:,31),heltab2x48(:,:,252))
  call Hloop_A_Q(ntryL,G0H6(15),19,0,G1H6(99),n2h6(118))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(253),h0tab(:,253),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf8(:,20),G0H6(16),ngZu,m3h8x6(:,32),heltab2x48(:,:,253))
  call Hloop_A_Q(ntryL,G0H6(16),19,nMT,G1H6(100),n2h6(119))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(254),h0tab(:,254),[19,4,8],[0,0,0],3,1,wf8(:,20))
  call Hloop_QZ_A(ntryL,G0H48(1),wf8(:,20),G0H6(5),ngZu,m3h8x6(:,33),heltab2x48(:,:,254))
  call Hloop_Q_A(ntryL,G0H6(5),19,0,G1H6(101),n2h6(120))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(255),h0tab(:,255),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,20))
  call Hloop_QZ_A(ntryL,G0H48(1),wf8(:,20),G0H6(10),ngZu,m3h8x6(:,34),heltab2x48(:,:,255))
  call Hloop_Q_A(ntryL,G0H6(10),19,nMT,G1H6(104),n2h6(121))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(256),h0tab(:,256),[19,4,8],[0,0,0],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf8(:,20),G0H6(11),ngZd,m3h8x6(:,35),heltab2x48(:,:,256))
  call Hloop_A_Q(ntryL,G0H6(11),19,0,G1H6(106),n2h6(122))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(257),h0tab(:,257),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf8(:,20),G0H6(12),ngZd,m3h8x6(:,36),heltab2x48(:,:,257))
  call Hloop_A_Q(ntryL,G0H6(12),19,nMB,G1H6(107),n2h6(123))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(258),h0tab(:,258),[19,4,8],[0,0,0],3,1,wf8(:,20))
  call Hloop_QZ_A(ntryL,G0H48(1),wf8(:,20),G0H6(13),ngZd,m3h8x6(:,37),heltab2x48(:,:,258))
  call Hloop_Q_A(ntryL,G0H6(13),19,0,G1H6(110),n2h6(124))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(259),h0tab(:,259),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,20))
  call Hloop_QZ_A(ntryL,G0H48(1),wf8(:,20),G0H6(14),ngZd,m3h8x6(:,38),heltab2x48(:,:,259))
  call Hloop_Q_A(ntryL,G0H6(14),19,nMB,G1H6(111),n2h6(125))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(260),h0tab(:,260),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SV_T(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(113),m3h8x6(:,39),heltab2x48(:,:,260))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(261),h0tab(:,261),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(116),m3h8x6(:,40),heltab2x48(:,:,261))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(262),h0tab(:,262),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_SV_T(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(117),m3h8x6(:,41),heltab2x48(:,:,262))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(263),h0tab(:,263),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(118),m3h8x6(:,42),heltab2x48(:,:,263))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(264),h0tab(:,264),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_DV_C(ntryL,G0H48(1),0,wf8(:,19),G1H6(122),m3h8x6(:,43),heltab2x48(:,:,264))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(265),h0tab(:,265),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(123),m3h8x6(:,44),heltab2x48(:,:,265))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(266),h0tab(:,266),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_DV_C(ntryL,G0H48(1),0,wf8(:,19),G1H6(1),m3h8x6(:,45),heltab2x48(:,:,266))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(267),h0tab(:,267),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(124),m3h8x6(:,46),heltab2x48(:,:,267))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(268),h0tab(:,268),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_DV_C(ntryL,G0H48(1),0,wf8(:,20),G1H6(128),m3h8x6(:,47),heltab2x48(:,:,268))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(269),h0tab(:,269),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(129),m3h8x6(:,48),heltab2x48(:,:,269))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(270),h0tab(:,270),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_DV_C(ntryL,G0H48(1),0,wf8(:,20),G1H6(130),m3h8x6(:,49),heltab2x48(:,:,270))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(271),h0tab(:,271),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(135),m3h8x6(:,50),heltab2x48(:,:,271))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(272),h0tab(:,272),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_UW_V(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(136),m3h8x6(:,51),heltab2x48(:,:,272))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(273),h0tab(:,273),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(139),m3h8x6(:,52),heltab2x48(:,:,273))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(274),h0tab(:,274),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_UW_V(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(141),m3h8x6(:,53),heltab2x48(:,:,274))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(275),h0tab(:,275),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(144),m3h8x6(:,54),heltab2x48(:,:,275))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(276),h0tab(:,276),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,19),G0H6(15),m3h8x6(:,55),heltab2x48(:,:,276))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(277),h0tab(:,277),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,19),G0H6(16),m3h8x6(:,56),heltab2x48(:,:,277))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(278),h0tab(:,278),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,20),G0H6(5),m3h8x6(:,57),heltab2x48(:,:,278))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(279),h0tab(:,279),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,20),G0H6(10),m3h8x6(:,58),heltab2x48(:,:,279))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(280),h0tab(:,280),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,19),G0H6(11),m3h8x6(:,59),heltab2x48(:,:,280))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(281),h0tab(:,281),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,19),G0H6(12),m3h8x6(:,60),heltab2x48(:,:,281))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(282),h0tab(:,282),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,20),G0H6(13),m3h8x6(:,61),heltab2x48(:,:,282))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(283),h0tab(:,283),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,20),G0H6(14),m3h8x6(:,62),heltab2x48(:,:,283))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(284),h0tab(:,284),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SV_T(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(134),m3h8x6(:,63),heltab2x48(:,:,284))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(285),h0tab(:,285),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(4),m3h8x6(:,64),heltab2x48(:,:,285))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(286),h0tab(:,286),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_SV_T(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(5),m3h8x6(:,65),heltab2x48(:,:,286))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(287),h0tab(:,287),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(8),m3h8x6(:,66),heltab2x48(:,:,287))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(288),h0tab(:,288),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_UW_V(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(10),m3h8x6(:,67),heltab2x48(:,:,288))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(289),h0tab(:,289),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(11),m3h8x6(:,68),heltab2x48(:,:,289))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(290),h0tab(:,290),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_UW_V(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(14),m3h8x6(:,69),heltab2x48(:,:,290))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(291),h0tab(:,291),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(15),m3h8x6(:,70),heltab2x48(:,:,291))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(292),h0tab(:,292),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,19),G0H6(17),m3h8x6(:,71),heltab2x48(:,:,292))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(293),h0tab(:,293),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,19),G0H6(18),m3h8x6(:,72),heltab2x48(:,:,293))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(294),h0tab(:,294),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,20),G0H6(19),m3h8x6(:,73),heltab2x48(:,:,294))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(295),h0tab(:,295),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,20),G0H6(20),m3h8x6(:,74),heltab2x48(:,:,295))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(296),h0tab(:,296),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,19),G0H6(21),m3h8x6(:,75),heltab2x48(:,:,296))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(297),h0tab(:,297),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,19),G0H6(22),m3h8x6(:,76),heltab2x48(:,:,297))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(298),h0tab(:,298),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,20),G0H6(23),m3h8x6(:,77),heltab2x48(:,:,298))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(299),h0tab(:,299),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,20))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,20),G0H6(24),m3h8x6(:,78),heltab2x48(:,:,299))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(300),h0tab(:,300),[21,2,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_AQ_V(ntryL,G0H48(1),wf8(:,18),G0H6(25),m3h8x6(:,79),heltab2x48(:,:,300))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(301),h0tab(:,301),[21,2,8],[nMZ,0,0],3,1,wf8(:,18))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf8(:,18),G0H6(26),ngZu,m3h8x6(:,80),heltab2x48(:,:,301))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(302),h0tab(:,302),[21,2,8],[nMW,0,0],3,1,wf8(:,18))
  call Hloop_AQ_W(ntryL,G0H48(1),wf8(:,18),G0H6(27),m3h8x6(:,81),heltab2x48(:,:,302))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(303),h0tab(:,303),[21,2,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_AQ_V(ntryL,G0H48(1),wf8(:,18),G0H6(28),m3h8x6(:,82),heltab2x48(:,:,303))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(304),h0tab(:,304),[21,2,8],[0,nMW,nMW],3,1,wf8(:,18))
  call Hloop_WQ_A(ntryL,G0H48(1),wf8(:,18),G0H6(29),m3h8x6(:,83),heltab2x48(:,:,304))
  call Hloop_Q_A(ntryL,G0H6(29),21,0,G1H6(17),n2h6(126))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(305),h0tab(:,305),[25,2,4],[0,0,0],3,1,wf12(:,30))
  call Hloop_AQ_V(ntryL,G0H48(1),wf12(:,30),G0H4(9),m3h12x4(:,11),heltab2x48(:,:,305))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(306),h0tab(:,306),[25,2,4],[nMZ,0,0],3,1,wf12(:,30))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf12(:,30),G0H4(10),ngZu,m3h12x4(:,12),heltab2x48(:,:,306))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(307),h0tab(:,307),[25,2,4],[nMW,0,0],3,1,wf12(:,30))
  call Hloop_AQ_W(ntryL,G0H48(1),wf12(:,30),G0H4(11),m3h12x4(:,13),heltab2x48(:,:,307))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(308),h0tab(:,308),[25,2,4],[0,0,0],3,1,wf12(:,30))
  call Hloop_AQ_V(ntryL,G0H48(1),wf12(:,30),G0H4(12),m3h12x4(:,14),heltab2x48(:,:,308))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(309),h0tab(:,309),[25,2,4],[0,nMW,nMW],3,1,wf12(:,30))
  call Hloop_WQ_A(ntryL,G0H48(1),wf12(:,30),G0H4(13),m3h12x4(:,15),heltab2x48(:,:,309))
  call Hloop_Q_A(ntryL,G0H4(13),25,0,G1H4(15),n2h4(22))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(310),h0tab(:,310),[19,4,8],[nME,nME,nME],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,84),heltab2x48(:,:,310))
  call Hloop_A_Q(ntryL,G0H6(29),19,nME,G1H6(20),n2h6(127))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(311),h0tab(:,311),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,85),heltab2x48(:,:,311))
  call Hloop_A_Q(ntryL,G0H6(29),19,nMM,G1H6(21),n2h6(128))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(312),h0tab(:,312),[19,4,8],[nML,nML,nML],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,86),heltab2x48(:,:,312))
  call Hloop_A_Q(ntryL,G0H6(29),19,nML,G1H6(22),n2h6(129))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(313),h0tab(:,313),[19,4,8],[nME,nME,nME],3,1,wf8(:,21))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,87),heltab2x48(:,:,313))
  call Hloop_Q_A(ntryL,G0H6(29),19,nME,G1H6(26),n2h6(130))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(314),h0tab(:,314),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,21))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,88),heltab2x48(:,:,314))
  call Hloop_Q_A(ntryL,G0H6(29),19,nMM,G1H6(35),n2h6(131))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(315),h0tab(:,315),[19,4,8],[nML,nML,nML],3,1,wf8(:,21))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,89),heltab2x48(:,:,315))
  call Hloop_Q_A(ntryL,G0H6(29),19,nML,G1H6(53),n2h6(132))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(316),h0tab(:,316),[19,4,8],[0,0,0],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,90),heltab2x48(:,:,316))
  call Hloop_A_Q(ntryL,G0H6(29),19,0,G1H6(24),n2h6(133))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(317),h0tab(:,317),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,91),heltab2x48(:,:,317))
  call Hloop_A_Q(ntryL,G0H6(29),19,nMT,G1H6(132),n2h6(134))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(318),h0tab(:,318),[19,4,8],[0,0,0],3,1,wf8(:,21))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,92),heltab2x48(:,:,318))
  call Hloop_Q_A(ntryL,G0H6(29),19,0,G1H6(60),n2h6(135))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(319),h0tab(:,319),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,21))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,93),heltab2x48(:,:,319))
  call Hloop_Q_A(ntryL,G0H6(29),19,nMT,G1H6(64),n2h6(136))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(320),h0tab(:,320),[19,4,8],[0,0,0],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,94),heltab2x48(:,:,320))
  call Hloop_A_Q(ntryL,G0H6(29),19,0,G1H6(7),n2h6(137))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(321),h0tab(:,321),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,95),heltab2x48(:,:,321))
  call Hloop_A_Q(ntryL,G0H6(29),19,nMB,G1H6(121),n2h6(138))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(322),h0tab(:,322),[19,4,8],[0,0,0],3,1,wf8(:,21))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,96),heltab2x48(:,:,322))
  call Hloop_Q_A(ntryL,G0H6(29),19,0,G1H6(19),n2h6(139))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(323),h0tab(:,323),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,21))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,97),heltab2x48(:,:,323))
  call Hloop_Q_A(ntryL,G0H6(29),19,nMB,G1H6(31),n2h6(140))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(324),h0tab(:,324),[19,4,8],[nME,nME,nME],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZl,m3h8x6(:,98),heltab2x48(:,:,324))
  call Hloop_A_Q(ntryL,G0H6(29),19,nME,G1H6(25),n2h6(141))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(325),h0tab(:,325),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZl,m3h8x6(:,99),heltab2x48(:,:,325))
  call Hloop_A_Q(ntryL,G0H6(29),19,nMM,G1H6(36),n2h6(142))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(326),h0tab(:,326),[19,4,8],[nML,nML,nML],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZl,m3h8x6(:,100),heltab2x48(:,:,326))
  call Hloop_A_Q(ntryL,G0H6(29),19,nML,G1H6(37),n2h6(143))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(327),h0tab(:,327),[19,4,8],[nME,nME,nME],3,1,wf8(:,22))
  call Hloop_QZ_A(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZl,m3h8x6(:,101),heltab2x48(:,:,327))
  call Hloop_Q_A(ntryL,G0H6(29),19,nME,G1H6(43),n2h6(144))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(328),h0tab(:,328),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,22))
  call Hloop_QZ_A(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZl,m3h8x6(:,102),heltab2x48(:,:,328))
  call Hloop_Q_A(ntryL,G0H6(29),19,nMM,G1H6(49),n2h6(145))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(329),h0tab(:,329),[19,4,8],[nML,nML,nML],3,1,wf8(:,22))
  call Hloop_QZ_A(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZl,m3h8x6(:,103),heltab2x48(:,:,329))
  call Hloop_Q_A(ntryL,G0H6(29),19,nML,G1H6(55),n2h6(146))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(330),h0tab(:,330),[19,4,8],[0,0,0],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZu,m3h8x6(:,104),heltab2x48(:,:,330))
  call Hloop_A_Q(ntryL,G0H6(29),19,0,G1H6(67),n2h6(147))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(331),h0tab(:,331),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZu,m3h8x6(:,105),heltab2x48(:,:,331))
  call Hloop_A_Q(ntryL,G0H6(29),19,nMT,G1H6(61),n2h6(148))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(332),h0tab(:,332),[19,4,8],[0,0,0],3,1,wf8(:,22))
  call Hloop_QZ_A(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZu,m3h8x6(:,106),heltab2x48(:,:,332))
  call Hloop_Q_A(ntryL,G0H6(29),19,0,G1H6(66),n2h6(149))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(333),h0tab(:,333),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,22))
  call Hloop_QZ_A(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZu,m3h8x6(:,107),heltab2x48(:,:,333))
  call Hloop_Q_A(ntryL,G0H6(29),19,nMT,G1H6(73),n2h6(150))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(334),h0tab(:,334),[19,4,8],[0,0,0],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZd,m3h8x6(:,108),heltab2x48(:,:,334))
  call Hloop_A_Q(ntryL,G0H6(29),19,0,G1H6(78),n2h6(151))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(335),h0tab(:,335),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZd,m3h8x6(:,109),heltab2x48(:,:,335))
  call Hloop_A_Q(ntryL,G0H6(29),19,nMB,G1H6(85),n2h6(152))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(336),h0tab(:,336),[19,4,8],[0,0,0],3,1,wf8(:,22))
  call Hloop_QZ_A(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZd,m3h8x6(:,110),heltab2x48(:,:,336))
  call Hloop_Q_A(ntryL,G0H6(29),19,0,G1H6(79),n2h6(153))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(337),h0tab(:,337),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,22))
  call Hloop_QZ_A(ntryL,G0H48(1),wf8(:,22),G0H6(29),ngZd,m3h8x6(:,111),heltab2x48(:,:,337))
  call Hloop_Q_A(ntryL,G0H6(29),19,nMB,G1H6(84),n2h6(154))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(338),h0tab(:,338),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_SV_T(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(90),m3h8x6(:,112),heltab2x48(:,:,338))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(339),h0tab(:,339),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(91),m3h8x6(:,113),heltab2x48(:,:,339))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(340),h0tab(:,340),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_SV_T(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(96),m3h8x6(:,114),heltab2x48(:,:,340))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(341),h0tab(:,341),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(103),m3h8x6(:,115),heltab2x48(:,:,341))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(342),h0tab(:,342),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_DV_C(ntryL,G0H48(1),0,wf8(:,21),G1H6(97),m3h8x6(:,116),heltab2x48(:,:,342))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(343),h0tab(:,343),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(109),m3h8x6(:,117),heltab2x48(:,:,343))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(344),h0tab(:,344),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_DV_C(ntryL,G0H48(1),0,wf8(:,21),G1H6(114),m3h8x6(:,118),heltab2x48(:,:,344))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(345),h0tab(:,345),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(120),m3h8x6(:,119),heltab2x48(:,:,345))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(346),h0tab(:,346),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_DV_C(ntryL,G0H48(1),0,wf8(:,22),G1H6(3),m3h8x6(:,120),heltab2x48(:,:,346))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(347),h0tab(:,347),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(6),m3h8x6(:,121),heltab2x48(:,:,347))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(348),h0tab(:,348),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_DV_C(ntryL,G0H48(1),0,wf8(:,22),G1H6(27),m3h8x6(:,122),heltab2x48(:,:,348))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(349),h0tab(:,349),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(18),m3h8x6(:,123),heltab2x48(:,:,349))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(350),h0tab(:,350),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_UW_V(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(29),m3h8x6(:,124),heltab2x48(:,:,350))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(351),h0tab(:,351),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(58),m3h8x6(:,125),heltab2x48(:,:,351))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(352),h0tab(:,352),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_UW_V(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(32),m3h8x6(:,126),heltab2x48(:,:,352))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(353),h0tab(:,353),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(48),m3h8x6(:,127),heltab2x48(:,:,353))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(354),h0tab(:,354),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,21),G0H6(29),m3h8x6(:,128),heltab2x48(:,:,354))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(355),h0tab(:,355),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,21),G0H6(30),m3h8x6(:,129),heltab2x48(:,:,355))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(356),h0tab(:,356),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,22),G0H6(31),m3h8x6(:,130),heltab2x48(:,:,356))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(357),h0tab(:,357),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,22),G0H6(32),m3h8x6(:,131),heltab2x48(:,:,357))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(358),h0tab(:,358),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,21),G0H6(33),m3h8x6(:,132),heltab2x48(:,:,358))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(359),h0tab(:,359),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,21),G0H6(34),m3h8x6(:,133),heltab2x48(:,:,359))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(360),h0tab(:,360),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,22),G0H6(35),m3h8x6(:,134),heltab2x48(:,:,360))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(361),h0tab(:,361),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,22),G0H6(36),m3h8x6(:,135),heltab2x48(:,:,361))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(362),h0tab(:,362),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_SV_T(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(33),m3h8x6(:,136),heltab2x48(:,:,362))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(363),h0tab(:,363),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(65),m3h8x6(:,137),heltab2x48(:,:,363))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(364),h0tab(:,364),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_SV_T(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(68),m3h8x6(:,138),heltab2x48(:,:,364))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(365),h0tab(:,365),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(39),m3h8x6(:,139),heltab2x48(:,:,365))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(366),h0tab(:,366),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_UW_V(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(46),m3h8x6(:,140),heltab2x48(:,:,366))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(367),h0tab(:,367),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(47),m3h8x6(:,141),heltab2x48(:,:,367))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(368),h0tab(:,368),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_UW_V(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(50),m3h8x6(:,142),heltab2x48(:,:,368))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(369),h0tab(:,369),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(125),m3h8x6(:,143),heltab2x48(:,:,369))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(370),h0tab(:,370),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,21),G0H6(37),m3h8x6(:,144),heltab2x48(:,:,370))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(371),h0tab(:,371),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,21),G0H6(38),m3h8x6(:,145),heltab2x48(:,:,371))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(372),h0tab(:,372),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,22),G0H6(39),m3h8x6(:,146),heltab2x48(:,:,372))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(373),h0tab(:,373),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_VV_S(ntryL,G0H48(1),wf8(:,22),G0H6(40),m3h8x6(:,147),heltab2x48(:,:,373))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(374),h0tab(:,374),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,21),G0H6(41),m3h8x6(:,148),heltab2x48(:,:,374))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(375),h0tab(:,375),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,21))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,21),G0H6(42),m3h8x6(:,149),heltab2x48(:,:,375))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(376),h0tab(:,376),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,22),G0H6(43),m3h8x6(:,150),heltab2x48(:,:,376))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(377),h0tab(:,377),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,22))
  call Hloop_SV_V(ntryL,G0H48(1),wf8(:,22),G0H6(44),m3h8x6(:,151),heltab2x48(:,:,377))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(378),h0tab(:,378),[22,1,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_QA_V(ntryL,G0H48(1),wf8(:,17),G0H6(45),m3h8x6(:,152),heltab2x48(:,:,378))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(379),h0tab(:,379),[22,1,8],[nMZ,0,0],3,1,wf8(:,17))
  call Hloop_QA_Z(ntryL,G0H48(1),wf8(:,17),G0H6(46),ngZu,m3h8x6(:,153),heltab2x48(:,:,379))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(380),h0tab(:,380),[22,1,8],[nMW,0,0],3,1,wf8(:,17))
  call Hloop_QA_W(ntryL,G0H48(1),wf8(:,17),G0H6(47),m3h8x6(:,154),heltab2x48(:,:,380))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(381),h0tab(:,381),[22,1,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_QA_V(ntryL,G0H48(1),wf8(:,17),G0H6(48),m3h8x6(:,155),heltab2x48(:,:,381))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(382),h0tab(:,382),[22,1,8],[0,nMW,nMW],3,1,wf8(:,17))
  call Hloop_WA_Q(ntryL,G0H48(1),wf8(:,17),G0H6(49),m3h8x6(:,156),heltab2x48(:,:,382))
  call Hloop_A_Q(ntryL,G0H6(49),22,0,G1H6(126),n2h6(155))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(383),h0tab(:,383),[26,1,4],[0,0,0],3,1,wf12(:,25))
  call Hloop_QA_V(ntryL,G0H48(1),wf12(:,25),G0H4(13),m3h12x4(:,16),heltab2x48(:,:,383))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(384),h0tab(:,384),[26,1,4],[nMZ,0,0],3,1,wf12(:,25))
  call Hloop_QA_Z(ntryL,G0H48(1),wf12(:,25),G0H4(14),ngZu,m3h12x4(:,17),heltab2x48(:,:,384))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(385),h0tab(:,385),[26,1,4],[nMW,0,0],3,1,wf12(:,25))
  call Hloop_QA_W(ntryL,G0H48(1),wf12(:,25),G0H4(15),m3h12x4(:,18),heltab2x48(:,:,385))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(386),h0tab(:,386),[26,1,4],[0,0,0],3,1,wf12(:,25))
  call Hloop_QA_V(ntryL,G0H48(1),wf12(:,25),G0H4(16),m3h12x4(:,19),heltab2x48(:,:,386))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(387),h0tab(:,387),[26,1,4],[0,nMW,nMW],3,1,wf12(:,25))
  call Hloop_WA_Q(ntryL,G0H48(1),wf12(:,25),G0H4(17),m3h12x4(:,20),heltab2x48(:,:,387))
  call Hloop_A_Q(ntryL,G0H4(17),26,0,G1H4(16),n2h4(23))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(133),[G1H6(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(66),[G1H6(60),G1H6(101),G1H6(76),G1H6(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(79),[G1H6(19),G1H6(110),G1H6(83),G1H6(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(67),[G1H6(24),G1H6(99),G1H6(71),G1H6(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(78),[G1H6(7),G1H6(106),G1H6(80),G1H6(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(61),[G1H6(132),G1H6(100),G1H6(74),G1H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(73),[G1H6(64),G1H6(104),G1H6(77),G1H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(85),[G1H6(121),G1H6(107),G1H6(81),G1H6(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(84),[G1H6(31),G1H6(111),G1H6(86),G1H6(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(17),[G1H12(13),G1H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(18),G1H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(42),[G1H24(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(14),[G0H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(3),[G1H24(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(28),[G0H6(25),G0H6(4),G0H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(26),[G0H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(27),[G0H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(17),[G1H6(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(10),[G1H24(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(17),[G0H12(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(27),[G1H24(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(48),[G0H6(45),G0H6(9),G0H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(46),[G0H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(47),[G0H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(126),[G1H6(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(34),[G1H24(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(37),[G1H24(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(43),[G1H24(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(12),[G0H4(9),G0H4(4),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(10),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(11),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(50),[G1H24(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(53),[G1H24(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(59),[G1H24(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(16),[G0H4(13),G0H4(8),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(14),[G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(15),[G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(25),[G1H6(20),G1H6(87),G1H6(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(36),[G1H6(21),G1H6(88),G1H6(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(37),[G1H6(22),G1H6(92),G1H6(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(43),[G1H6(26),G1H6(93),G1H6(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(49),[G1H6(35),G1H6(94),G1H6(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(55),[G1H6(53),G1H6(95),G1H6(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(96),[G1H6(90),G1H6(117),G1H6(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(103),[G1H6(91),G1H6(118),G1H6(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(27),[G1H6(3),G1H6(114),G1H6(97),G1H6(130),G1H6(128) &
    ,G1H6(1),G1H6(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(18),[G1H6(6),G1H6(120),G1H6(109),G1H6(135),G1H6(129) &
    ,G1H6(124),G1H6(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(32),[G1H6(29),G1H6(141),G1H6(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(48),[G1H6(58),G1H6(144),G1H6(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(31),[G0H6(29),G0H6(5),G0H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(32),[G0H6(30),G0H6(10),G0H6(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(35),[G0H6(33),G0H6(13),G0H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(36),[G0H6(34),G0H6(14),G0H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(39),[G1H6(68),G1H6(65),G1H6(33),G1H6(8),G1H6(5),G1H6(4) &
    ,G1H6(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(125),[G1H6(50),G1H6(47),G1H6(46),G1H6(15),G1H6(14) &
    ,G1H6(11),G1H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(39),[G0H6(37),G0H6(19),G0H6(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(40),[G0H6(38),G0H6(20),G0H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(43),[G0H6(41),G0H6(23),G0H6(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(44),[G0H6(42),G0H6(24),G0H6(22)])
  call Hloop_QZ_A(ntryL,G1H6(133),ex4(:),G1H2(34),ngZu,m3h3x2(:,104),heltab2x6(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(34),29,0,G2H2(11),n2h2(103))
  call Hloop_QV_A(ntryL,G1H4(12),ex3(:),G1H2(49),m3h2x2(:,40),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(49),29,0,G2H2(14),n2h2(104))
  call Hloop_QV_A(ntryL,G1H6(66),ex3(:),G1H3(27),m3h2x3(:,121),heltab2x6(:,:,253))
  call Hloop_Q_A(ntryL,G1H3(27),23,0,G2H3(5),n2h3(133))
  call Hloop_QV_A(ntryL,G1H6(79),ex3(:),G1H3(44),m3h2x3(:,122),heltab2x6(:,:,254))
  call Hloop_Q_A(ntryL,G1H3(44),23,0,G2H3(2),n2h3(134))
  call Hloop_QZ_A(ntryL,G1H6(98),ex4(:),G1H2(50),ngZu,m3h3x2(:,105),heltab2x6(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(50),27,0,G2H2(34),n2h2(105))
  call Hloop_QZ_A(ntryL,G1H6(105),ex4(:),G1H2(61),ngZd,m3h3x2(:,106),heltab2x6(:,:,256))
  call Hloop_Q_A(ntryL,G1H2(61),27,0,G2H2(17),n2h2(106))
  call Hloop_AV_Q(ntryL,G1H6(67),ex3(:),G1H3(48),m3h2x3(:,123),heltab2x6(:,:,257))
  call Hloop_A_Q(ntryL,G1H3(48),23,0,G2H3(8),n2h3(135))
  call Hloop_AV_Q(ntryL,G1H6(78),ex3(:),G1H3(59),m3h2x3(:,124),heltab2x6(:,:,258))
  call Hloop_A_Q(ntryL,G1H3(59),23,0,G2H3(11),n2h3(136))
  call Hloop_AZ_Q(ntryL,G1H6(127),ex4(:),G1H2(66),ngZu,m3h3x2(:,107),heltab2x6(:,:,259))
  call Hloop_A_Q(ntryL,G1H2(66),27,0,G2H2(23),n2h2(107))
  call Hloop_AZ_Q(ntryL,G1H6(140),ex4(:),G1H2(67),ngZd,m3h3x2(:,108),heltab2x6(:,:,260))
  call Hloop_A_Q(ntryL,G1H2(67),27,0,G2H2(26),n2h2(108))
  call Hloop_QZ_A(ntryL,G1H6(9),ex4(:),G1H2(78),ngZu,m3h3x2(:,109),heltab2x6(:,:,261))
  call Hloop_Q_A(ntryL,G1H2(78),27,nMT,G2H2(42),n2h2(109))
  call Hloop_AZ_Q(ntryL,G1H6(16),ex4(:),G1H2(82),ngZu,m3h3x2(:,110),heltab2x6(:,:,262))
  call Hloop_A_Q(ntryL,G1H2(82),27,nMT,G2H2(29),n2h2(110))
  call Hloop_QZ_A(ntryL,G1H6(23),ex4(:),G1H2(88),ngZd,m3h3x2(:,111),heltab2x6(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(88),27,nMB,G2H2(38),n2h2(111))
  call Hloop_AZ_Q(ntryL,G1H6(57),ex4(:),G1H2(99),ngZd,m3h3x2(:,112),heltab2x6(:,:,264))
  call Hloop_A_Q(ntryL,G1H2(99),27,nMB,G2H2(63),n2h2(112))
  call Hloop_AV_Q(ntryL,G1H6(61),ex3(:),G1H3(60),m3h2x3(:,125),heltab2x6(:,:,265))
  call Hloop_A_Q(ntryL,G1H3(60),23,nMT,G2H3(14),n2h3(137))
  call Hloop_QV_A(ntryL,G1H6(73),ex3(:),G1H3(66),m3h2x3(:,126),heltab2x6(:,:,266))
  call Hloop_Q_A(ntryL,G1H3(66),23,nMT,G2H3(44),n2h3(138))
  call Hloop_AV_Q(ntryL,G1H6(85),ex3(:),G1H3(77),m3h2x3(:,127),heltab2x6(:,:,267))
  call Hloop_A_Q(ntryL,G1H3(77),23,nMB,G2H3(17),n2h3(139))
  call Hloop_QV_A(ntryL,G1H6(84),ex3(:),G1H3(81),m3h2x3(:,128),heltab2x6(:,:,268))
  call Hloop_Q_A(ntryL,G1H3(81),23,nMB,G2H3(23),n2h3(140))
  call Hloop_QV_A(ntryL,G1H12(15),wf4(:,9),G1H3(82),m3h4x3(:,41),heltab2x12(:,:,141))
  call Hloop_Q_A(ntryL,G1H3(82),23,0,G2H3(20),n2h3(141))
  call Hloop_QV_A(ntryL,G1H12(20),wf4(:,9),G1H3(98),m3h4x3(:,42),heltab2x12(:,:,142))
  call Hloop_Q_A(ntryL,G1H3(98),23,nMT,G2H3(26),n2h3(142))
  call Hloop_AV_Q(ntryL,G1H12(29),wf4(:,9),G1H3(103),m3h4x3(:,43),heltab2x12(:,:,143))
  call Hloop_A_Q(ntryL,G1H3(103),23,0,G2H3(15),n2h3(143))
  call Hloop_AV_Q(ntryL,G1H12(34),wf4(:,9),G1H3(104),m3h4x3(:,44),heltab2x12(:,:,144))
  call Hloop_A_Q(ntryL,G1H3(104),23,nMT,G2H3(18),n2h3(144))
  call Hloop_QV_A(ntryL,G1H12(39),wf4(:,9),G1H3(115),m3h4x3(:,45),heltab2x12(:,:,145))
  call Hloop_Q_A(ntryL,G1H3(115),23,0,G2H3(21),n2h3(145))
  call Hloop_QV_A(ntryL,G1H12(44),wf4(:,9),G1H3(120),m3h4x3(:,46),heltab2x12(:,:,146))
  call Hloop_Q_A(ntryL,G1H3(120),23,nMB,G2H3(32),n2h3(146))
  call Hloop_AV_Q(ntryL,G1H12(49),wf4(:,9),G1H3(125),m3h4x3(:,47),heltab2x12(:,:,147))
  call Hloop_A_Q(ntryL,G1H3(125),23,0,G2H3(35),n2h3(147))
  call Hloop_AV_Q(ntryL,G1H12(54),wf4(:,9),G1H3(136),m3h4x3(:,48),heltab2x12(:,:,148))
  call Hloop_A_Q(ntryL,G1H3(136),23,nMB,G2H3(47),n2h3(148))
  call Hloop_AZ_Q(ntryL,G1H12(59),ex4(:),G1H4(27),ngZu,m3h3x4(:,26),heltab2x12(:,:,149))
  call Hloop_A_Q(ntryL,G1H4(27),26,0,G2H4(6),n2h4(24))
  call Hloop_QZ_A(ntryL,G1H12(7),ex4(:),G1H4(28),ngZu,m3h3x4(:,27),heltab2x12(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(28),25,0,G2H4(7),n2h4(25))
  call Hloop_AV_Q(ntryL,G1H12(17),ex3(:),G1H6(137),m3h2x6(:,68),heltab2x12(:,:,151))
  call Hloop_A_Q(ntryL,G1H6(137),22,0,G2H6(5),n2h6(156))
  call Hloop_QV_A(ntryL,G1H12(2),ex3(:),G1H6(143),m3h2x6(:,69),heltab2x12(:,:,152))
  call Hloop_Q_A(ntryL,G1H6(143),21,0,G2H6(22),n2h6(157))
  call Hloop_QA_W(ntryL,G1H12(24),ex2(:),G1H6(75),m3h2x6(:,70),heltab2x12(:,:,153))
  call Hloop_AQ_W(ntryL,G1H12(25),ex1(:),G1H6(60),m3h2x6(:,71),heltab2x12(:,:,154))
  call Hloop_AQ_V(ntryL,G1H24(42),wf4(:,2),G1H6(101),m3h4x6(:,23),heltab2x24(:,:,86))
  call Hloop_AQ_Z(ntryL,G1H24(32),wf4(:,2),G1H6(76),ngZu,m3h4x6(:,24),heltab2x24(:,:,87))
  call Hloop_AQ_W(ntryL,G1H24(38),wf4(:,2),G1H6(82),m3h4x6(:,25),heltab2x24(:,:,88))
  call Hloop_VQ_A(ntryL,G1H24(48),wf4(:,2),G1H6(19),m3h4x6(:,26),heltab2x24(:,:,89))
  call Hloop_Q_A(ntryL,G1H6(19),21,0,G2H6(25),n2h6(158))
  call Hloop_VQ_A(ntryL,G0H12(14),wf4(:,2),G0H3(1),m3h4x3(:,49),heltab2x12(:,:,155))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(137),n2h3(149))
  call Hloop_ZQ_A(ntryL,G0H12(8),wf4(:,2),G0H3(1),ngZu,m3h4x3(:,50),heltab2x12(:,:,156))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(142),n2h3(150))
  call Hloop_WQ_A(ntryL,G0H12(10),wf4(:,2),G0H3(1),m3h4x3(:,51),heltab2x12(:,:,157))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(153),n2h3(151))
  call Hloop_AQ_W(ntryL,G1H12(26),wf4(:,2),G1H3(9),m3h4x3(:,52),heltab2x12(:,:,158))
  call Hloop_AV_Q(ntryL,G1H24(52),wf8(:,5),G1H3(20),m3h8x3(:,1),heltab2x24(:,:,90))
  call Hloop_A_Q(ntryL,G1H3(20),23,0,G2H3(38),n2h3(152))
  call Hloop_AV_Q(ntryL,G1H24(58),wf8(:,5),G1H3(64),m3h8x3(:,2),heltab2x24(:,:,91))
  call Hloop_A_Q(ntryL,G1H3(64),23,nMT,G2H3(3),n2h3(153))
  call Hloop_QV_A(ntryL,G1H24(62),wf8(:,5),G1H3(75),m3h8x3(:,3),heltab2x24(:,:,92))
  call Hloop_Q_A(ntryL,G1H3(75),23,0,G2H3(6),n2h3(154))
  call Hloop_QV_A(ntryL,G1H24(1),wf8(:,5),G1H3(97),m3h8x3(:,4),heltab2x24(:,:,93))
  call Hloop_Q_A(ntryL,G1H3(97),23,nMT,G2H3(9),n2h3(155))
  call Hloop_AV_Q(ntryL,G1H24(5),wf8(:,5),G1H3(141),m3h8x3(:,5),heltab2x24(:,:,94))
  call Hloop_A_Q(ntryL,G1H3(141),23,0,G2H3(51),n2h3(156))
  call Hloop_AV_Q(ntryL,G1H24(9),wf8(:,5),G1H3(152),m3h8x3(:,6),heltab2x24(:,:,95))
  call Hloop_A_Q(ntryL,G1H3(152),23,nMB,G2H3(90),n2h3(157))
  call Hloop_QV_A(ntryL,G1H24(13),wf8(:,5),G1H3(4),m3h8x3(:,7),heltab2x24(:,:,96))
  call Hloop_Q_A(ntryL,G1H3(4),23,0,G2H3(102),n2h3(158))
  call Hloop_QV_A(ntryL,G1H24(17),wf8(:,5),G1H3(15),m3h8x3(:,8),heltab2x24(:,:,97))
  call Hloop_Q_A(ntryL,G1H3(15),23,nMB,G2H3(34),n2h3(159))
  call Hloop_QA_V(ntryL,G1H24(3),ex2(:),G1H12(4),m3h2x12(:,64),heltab2x24(:,:,98))
  call Hloop_QA_Z(ntryL,G1H24(4),ex2(:),G1H12(28),ngZu,m3h2x12(:,65),heltab2x24(:,:,99))
  call Hloop_QA_W(ntryL,G1H24(2),ex2(:),G1H12(30),m3h2x12(:,66),heltab2x24(:,:,100))
  call Hloop_VA_Q(ntryL,G1H24(8),ex2(:),G1H12(31),m3h2x12(:,67),heltab2x24(:,:,101))
  call Hloop_A_Q(ntryL,G1H12(31),18,0,G2H12(9),n2h12(63))
  call Hloop_VA_Q(ntryL,G0H6(28),ex2(:),G0H3(1),m3h2x3(:,129),heltab2x6(:,:,269))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(21),n2h3(160))
  call Hloop_ZA_Q(ntryL,G0H6(26),ex2(:),G0H3(1),ngZu,m3h2x3(:,130),heltab2x6(:,:,270))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(22),n2h3(161))
  call Hloop_WA_Q(ntryL,G0H6(27),ex2(:),G0H3(1),m3h2x3(:,131),heltab2x6(:,:,271))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(8),n2h3(162))
  call Hloop_QA_W(ntryL,G1H6(17),ex2(:),G1H3(30),m3h2x3(:,132),heltab2x6(:,:,272))
  call Hloop_QA_V(ntryL,G1H24(10),wf4(:,6),G1H6(110),m3h4x6(:,27),heltab2x24(:,:,102))
  call Hloop_QA_Z(ntryL,G1H24(7),wf4(:,6),G1H6(83),ngZu,m3h4x6(:,28),heltab2x24(:,:,103))
  call Hloop_QA_W(ntryL,G1H24(12),wf4(:,6),G1H6(89),m3h4x6(:,29),heltab2x24(:,:,104))
  call Hloop_VA_Q(ntryL,G1H24(11),wf4(:,6),G1H6(24),m3h4x6(:,30),heltab2x24(:,:,105))
  call Hloop_A_Q(ntryL,G1H6(24),22,0,G2H6(2),n2h6(159))
  call Hloop_VA_Q(ntryL,G0H12(17),wf4(:,6),G0H3(1),m3h4x3(:,53),heltab2x12(:,:,159))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(41),n2h3(163))
  call Hloop_ZA_Q(ntryL,G0H12(18),wf4(:,6),G0H3(1),ngZu,m3h4x3(:,54),heltab2x12(:,:,160))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(63),n2h3(164))
  call Hloop_WA_Q(ntryL,G0H12(16),wf4(:,6),G0H3(1),m3h4x3(:,55),heltab2x12(:,:,161))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(85),n2h3(165))
  call Hloop_QA_W(ntryL,G1H12(27),wf4(:,6),G1H3(74),m3h4x3(:,56),heltab2x12(:,:,162))
  call Hloop_AV_Q(ntryL,G1H24(16),wf8(:,6),G1H3(83),m3h8x3(:,9),heltab2x24(:,:,106))
  call Hloop_A_Q(ntryL,G1H3(83),23,0,G2H3(36),n2h3(166))
  call Hloop_AV_Q(ntryL,G1H24(14),wf8(:,6),G1H3(94),m3h8x3(:,10),heltab2x24(:,:,107))
  call Hloop_A_Q(ntryL,G1H3(94),23,nMT,G2H3(37),n2h3(167))
  call Hloop_QV_A(ntryL,G1H24(15),wf8(:,6),G1H3(107),m3h8x3(:,11),heltab2x24(:,:,108))
  call Hloop_Q_A(ntryL,G1H3(107),23,0,G2H3(84),n2h3(168))
  call Hloop_QV_A(ntryL,G1H24(20),wf8(:,6),G1H3(129),m3h8x3(:,12),heltab2x24(:,:,109))
  call Hloop_Q_A(ntryL,G1H3(129),23,nMT,G2H3(96),n2h3(169))
  call Hloop_AV_Q(ntryL,G1H24(18),wf8(:,6),G1H3(6),m3h8x3(:,13),heltab2x24(:,:,110))
  call Hloop_A_Q(ntryL,G1H3(6),23,0,G2H3(28),n2h3(170))
  call Hloop_AV_Q(ntryL,G1H24(19),wf8(:,6),G1H3(17),m3h8x3(:,14),heltab2x24(:,:,111))
  call Hloop_A_Q(ntryL,G1H3(17),23,nMB,G2H3(29),n2h3(171))
  call Hloop_QV_A(ntryL,G1H24(24),wf8(:,6),G1H3(1),m3h8x3(:,15),heltab2x24(:,:,112))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(30),n2h3(172))
  call Hloop_QV_A(ntryL,G1H24(22),wf8(:,6),G1H3(45),m3h8x3(:,16),heltab2x24(:,:,113))
  call Hloop_Q_A(ntryL,G1H3(45),23,nMB,G2H3(39),n2h3(173))
  call Hloop_AQ_V(ntryL,G1H24(27),ex1(:),G1H12(32),m3h2x12(:,68),heltab2x24(:,:,114))
  call Hloop_AQ_Z(ntryL,G1H24(25),ex1(:),G1H12(33),ngZu,m3h2x12(:,69),heltab2x24(:,:,115))
  call Hloop_AQ_W(ntryL,G1H24(26),ex1(:),G1H12(35),m3h2x12(:,70),heltab2x24(:,:,116))
  call Hloop_VQ_A(ntryL,G1H24(31),ex1(:),G1H12(36),m3h2x12(:,71),heltab2x24(:,:,117))
  call Hloop_Q_A(ntryL,G1H12(36),17,0,G2H12(10),n2h12(64))
  call Hloop_VQ_A(ntryL,G0H6(48),ex1(:),G0H3(1),m3h2x3(:,133),heltab2x6(:,:,273))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(7),n2h3(174))
  call Hloop_ZQ_A(ntryL,G0H6(46),ex1(:),G0H3(1),ngZu,m3h2x3(:,134),heltab2x6(:,:,274))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(18),n2h3(175))
  call Hloop_WQ_A(ntryL,G0H6(47),ex1(:),G0H3(1),m3h2x3(:,135),heltab2x6(:,:,275))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(150),n2h3(176))
  call Hloop_AQ_W(ntryL,G1H6(126),ex1(:),G1H3(29),m3h2x3(:,136),heltab2x6(:,:,276))
  call Hloop_AV_Q(ntryL,G1H12(14),ex3(:),G1H6(99),m3h2x6(:,72),heltab2x12(:,:,163))
  call Hloop_A_Q(ntryL,G1H6(99),22,0,G2H6(4),n2h6(160))
  call Hloop_AV_Q(ntryL,G1H12(16),ex3(:),G1H6(71),m3h2x6(:,73),heltab2x12(:,:,164))
  call Hloop_A_Q(ntryL,G1H6(71),22,0,G2H6(6),n2h6(161))
  call Hloop_UV_W(ntryL,G0H12(1),18,ex3(:),4,G1H6(112),m3h2x6(:,74),heltab2x12(:,:,165))
  call Hloop_QV_A(ntryL,G1H24(34),ex3(:),G1H12(37),m3h2x12(:,72),heltab2x24(:,:,118))
  call Hloop_Q_A(ntryL,G1H12(37),20,0,G2H12(11),n2h12(65))
  call Hloop_QV_A(ntryL,G1H24(30),ex3(:),G1H12(38),m3h2x12(:,73),heltab2x24(:,:,119))
  call Hloop_Q_A(ntryL,G1H12(38),20,nMT,G2H12(12),n2h12(66))
  call Hloop_AV_Q(ntryL,G1H24(37),ex3(:),G1H12(40),m3h2x12(:,74),heltab2x24(:,:,120))
  call Hloop_A_Q(ntryL,G1H12(40),20,0,G2H12(13),n2h12(67))
  call Hloop_AV_Q(ntryL,G1H24(33),ex3(:),G1H12(41),m3h2x12(:,75),heltab2x24(:,:,121))
  call Hloop_A_Q(ntryL,G1H12(41),20,nMT,G2H12(14),n2h12(68))
  call Hloop_QV_A(ntryL,G1H24(36),ex3(:),G1H12(42),m3h2x12(:,76),heltab2x24(:,:,122))
  call Hloop_Q_A(ntryL,G1H12(42),20,nMB,G2H12(15),n2h12(69))
  call Hloop_AV_Q(ntryL,G1H24(41),ex3(:),G1H12(43),m3h2x12(:,77),heltab2x24(:,:,123))
  call Hloop_A_Q(ntryL,G1H12(43),20,nMB,G2H12(16),n2h12(70))
  call Hloop_QA_V(ntryL,G1H24(43),ex2(:),G1H12(45),m3h2x12(:,78),heltab2x24(:,:,124))
  call Hloop_QA_Z(ntryL,G1H24(40),ex2(:),G1H12(46),ngZu,m3h2x12(:,79),heltab2x24(:,:,125))
  call Hloop_QA_W(ntryL,G1H24(45),ex2(:),G1H12(47),m3h2x12(:,80),heltab2x24(:,:,126))
  call Hloop_VA_Q(ntryL,G1H24(44),ex2(:),G1H12(48),m3h2x12(:,81),heltab2x24(:,:,127))
  call Hloop_A_Q(ntryL,G1H12(48),18,0,G2H12(17),n2h12(71))
  call Hloop_VA_Q(ntryL,G0H4(12),ex2(:),G0H2(1),m3h2x2(:,41),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(104),n2h2(113))
  call Hloop_ZA_Q(ntryL,G0H4(10),ex2(:),G0H2(1),ngZu,m3h2x2(:,42),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(105),n2h2(114))
  call Hloop_WA_Q(ntryL,G0H4(11),ex2(:),G0H2(1),m3h2x2(:,43),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(21),n2h2(115))
  call Hloop_QA_W(ntryL,G1H4(15),ex2(:),G1H2(32),m3h2x2(:,44),heltab2x4(:,:,54))
  call Hloop_QV_A(ntryL,G1H12(19),ex3(:),G1H6(7),m3h2x6(:,75),heltab2x12(:,:,166))
  call Hloop_Q_A(ntryL,G1H6(7),21,0,G2H6(8),n2h6(162))
  call Hloop_QV_A(ntryL,G1H12(1),ex3(:),G1H6(106),m3h2x6(:,76),heltab2x12(:,:,167))
  call Hloop_Q_A(ntryL,G1H6(106),21,0,G2H6(10),n2h6(163))
  call Hloop_UW_V(ntryL,G0H12(12),17,ex3(:),4,G1H6(80),m3h2x6(:,77),heltab2x12(:,:,168))
  call Hloop_QV_A(ntryL,G1H24(50),ex3(:),G1H12(50),m3h2x12(:,82),heltab2x24(:,:,128))
  call Hloop_Q_A(ntryL,G1H12(50),20,0,G2H12(18),n2h12(72))
  call Hloop_QV_A(ntryL,G1H24(47),ex3(:),G1H12(51),m3h2x12(:,83),heltab2x24(:,:,129))
  call Hloop_Q_A(ntryL,G1H12(51),20,nMT,G2H12(1),n2h12(73))
  call Hloop_AV_Q(ntryL,G1H24(53),ex3(:),G1H12(52),m3h2x12(:,84),heltab2x24(:,:,130))
  call Hloop_A_Q(ntryL,G1H12(52),20,0,G2H12(2),n2h12(74))
  call Hloop_AV_Q(ntryL,G1H24(49),ex3(:),G1H12(53),m3h2x12(:,85),heltab2x24(:,:,131))
  call Hloop_A_Q(ntryL,G1H12(53),20,nMT,G2H12(3),n2h12(75))
  call Hloop_QV_A(ntryL,G1H24(55),ex3(:),G1H12(55),m3h2x12(:,86),heltab2x24(:,:,132))
  call Hloop_Q_A(ntryL,G1H12(55),20,nMB,G2H12(4),n2h12(76))
  call Hloop_AV_Q(ntryL,G1H24(54),ex3(:),G1H12(56),m3h2x12(:,87),heltab2x24(:,:,133))
  call Hloop_A_Q(ntryL,G1H12(56),20,nMB,G2H12(5),n2h12(77))
  call Hloop_AQ_V(ntryL,G1H24(59),ex1(:),G1H12(57),m3h2x12(:,88),heltab2x24(:,:,134))
  call Hloop_AQ_Z(ntryL,G1H24(57),ex1(:),G1H12(58),ngZu,m3h2x12(:,89),heltab2x24(:,:,135))
  call Hloop_AQ_W(ntryL,G1H24(61),ex1(:),G1H12(60),m3h2x12(:,90),heltab2x24(:,:,136))
  call Hloop_VQ_A(ntryL,G1H24(60),ex1(:),G1H12(61),m3h2x12(:,91),heltab2x24(:,:,137))
  call Hloop_Q_A(ntryL,G1H12(61),17,0,G2H12(6),n2h12(78))
  call Hloop_VQ_A(ntryL,G0H4(16),ex1(:),G0H2(1),m3h2x2(:,45),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(54),n2h2(116))
  call Hloop_ZQ_A(ntryL,G0H4(14),ex1(:),G0H2(1),ngZu,m3h2x2(:,46),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(87),n2h2(117))
  call Hloop_WQ_A(ntryL,G0H4(15),ex1(:),G0H2(1),m3h2x2(:,47),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(103),n2h2(118))
  call Hloop_AQ_W(ntryL,G1H4(16),ex1(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,58))
  call Hloop_AV_Q(ntryL,G1H6(25),ex3(:),G1H3(51),m3h2x3(:,137),heltab2x6(:,:,277))
  call Hloop_A_Q(ntryL,G1H3(51),23,nME,G2H3(43),n2h3(177))
  call Hloop_AV_Q(ntryL,G1H6(36),ex3(:),G1H3(40),m3h2x3(:,138),heltab2x6(:,:,278))
  call Hloop_A_Q(ntryL,G1H3(40),23,nMM,G2H3(45),n2h3(178))
  call Hloop_AV_Q(ntryL,G1H6(37),ex3(:),G1H3(57),m3h2x3(:,139),heltab2x6(:,:,279))
  call Hloop_A_Q(ntryL,G1H3(57),23,nML,G2H3(40),n2h3(179))
  call Hloop_QV_A(ntryL,G1H6(43),ex3(:),G1H3(61),m3h2x3(:,140),heltab2x6(:,:,280))
  call Hloop_Q_A(ntryL,G1H3(61),23,nME,G2H3(41),n2h3(180))
  call Hloop_QV_A(ntryL,G1H6(49),ex3(:),G1H3(62),m3h2x3(:,141),heltab2x6(:,:,281))
  call Hloop_Q_A(ntryL,G1H3(62),23,nMM,G2H3(42),n2h3(181))
  call Hloop_QV_A(ntryL,G1H6(55),ex3(:),G1H3(68),m3h2x3(:,142),heltab2x6(:,:,282))
  call Hloop_Q_A(ntryL,G1H3(68),23,nML,G2H3(49),n2h3(182))
  call Hloop_SV_T(ntryL,G1H6(96),19,ex3(:),4,G2H3(1),m3h2x3(:,143),heltab2x6(:,:,283))
  call Hloop_TV_S(ntryL,G1H6(103),19,ex3(:),4,G2H3(4),m3h2x3(:,144),heltab2x6(:,:,284))
  call Hloop_DV_C(ntryL,G1H6(27),19,ex3(:),G2H3(92),m3h2x3(:,145),heltab2x6(:,:,285))
  call Hloop_CV_D(ntryL,G1H6(18),19,ex3(:),4,G2H3(7),m3h2x3(:,146),heltab2x6(:,:,286))
  call Hloop_UW_V(ntryL,G1H6(32),19,ex3(:),4,G2H3(10),m3h2x3(:,147),heltab2x6(:,:,287))
  call Hloop_UV_W(ntryL,G1H6(48),19,ex3(:),4,G2H3(104),m3h2x3(:,148),heltab2x6(:,:,288))
  call Hloop_SV_T(ntryL,G0H6(31),19,ex3(:),4,G1H3(91),m3h2x3(:,149),heltab2x6(:,:,289))
  call Hloop_TV_S(ntryL,G0H6(32),19,ex3(:),4,G1H3(80),m3h2x3(:,150),heltab2x6(:,:,290))
  call Hloop_VV_S(ntryL,G0H6(35),ex3(:),G0H3(1),m3h2x3(:,151),heltab2x6(:,:,291))
  call Hloop_VV_S(ntryL,G0H6(36),ex3(:),G0H3(2),m3h2x3(:,152),heltab2x6(:,:,292))
  call Hloop_SV_V(ntryL,G1H6(39),ex3(:),G1H3(84),m3h2x3(:,153),heltab2x6(:,:,293))
  call Hloop_VV_S(ntryL,G1H6(125),ex3(:),G1H3(101),m3h2x3(:,154),heltab2x6(:,:,294))
  call Hloop_SV_V(ntryL,G0H6(39),ex3(:),G0H3(3),m3h2x3(:,155),heltab2x6(:,:,295))
  call Hloop_SV_V(ntryL,G0H6(40),ex3(:),G0H3(4),m3h2x3(:,156),heltab2x6(:,:,296))
  call Hloop_UW_V(ntryL,G0H6(43),19,ex3(:),4,G1H3(102),m3h2x3(:,157),heltab2x6(:,:,297))
  call Hloop_UV_W(ntryL,G0H6(44),19,ex3(:),4,G1H3(105),m3h2x3(:,158),heltab2x6(:,:,298))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(87),G2H2(43),G2H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(65),G2H2(47),G2H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(137),[G1H3(73),G1H3(92)])
call HGT_w2_OLR(G1H3(43),1,1,3)
call HGT_w2_invQ_OLR(G1H3(43),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(43),[G1H3(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(158),[G1H2(3)])
call HGT_w2_OLR(G1H2(56),1,1,2)
call HGT_w2_invQ_OLR(G1H2(56),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(56),[G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G2H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(76),G1H2(15)])
call HGT_OLR(G2H2(71),1,1,2)
call HGT_invQ_OLR(G2H2(71),2,5,2)
call HGT_OLR(G2H2(71),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(84),[G2H3(6),G2H3(85),G2H3(53),G1H3(168),G1H3(165) &
    ,G1H3(2),G1H3(148),G1H3(114),G1H3(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(30),[G2H3(102),G2H3(97),G2H3(56),G1H3(171),G1H3(162) &
    ,G1H3(53),G1H3(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(20),[G1H3(11),G1H3(119),G1H3(147)])
call HGT_OLR(G2H3(58),1,1,3)
call HGT_invQ_OLR(G2H3(58),2,5,3)
call HGT_OLR(G2H3(58),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(58),[G2H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G2H2(73),G1H2(210),G1H2(181),G1H2(25),G1H2(41) &
    ,G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(21),[G1H3(19),G1H3(31)])
call HGT_OLR(G2H3(59),1,1,3)
call HGT_invQ_OLR(G2H3(59),2,5,3)
call HGT_OLR(G2H3(59),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(59),[G2H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(85),[G1H2(58),G1H2(74)])
call HGT_OLR(G2H2(79),1,1,2)
call HGT_invQ_OLR(G2H2(79),2,5,2)
call HGT_OLR(G2H2(79),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(36),[G2H3(38),G2H3(91),G2H3(61),G1H3(179),G1H3(106) &
    ,G1H3(95),G1H3(72),G1H3(140),G1H3(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(28),[G2H3(51),G2H3(103),G2H3(64),G1H3(190),G1H3(128) &
    ,G1H3(151),G1H3(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G1H3(14),G1H3(39),G1H3(49)])
call HGT_OLR(G2H3(66),1,1,3)
call HGT_invQ_OLR(G2H3(66),2,5,3)
call HGT_OLR(G2H3(66),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(66),[G2H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(81),G1H2(215),G1H2(196),G1H2(123),G1H2(118) &
    ,G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(35),[G1H3(36),G1H3(70)])
call HGT_OLR(G2H3(67),1,1,3)
call HGT_invQ_OLR(G2H3(67),2,5,3)
call HGT_OLR(G2H3(67),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(67),[G2H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G1H3(23),G1H3(149),G1H3(69)])
call HGT_w2_OLR(G1H3(88),1,1,3)
call HGT_w2_invQ_OLR(G1H3(88),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G1H3(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(34),G1H2(187),G1H2(184),G1H2(180),G1H2(157)])
call HGT_w2_OLR(G1H2(43),1,1,2)
call HGT_w2_invQ_OLR(G1H2(43),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(26),[G1H3(224)])
call HGT_OLR(G2H3(68),1,1,3)
call HGT_invQ_OLR(G2H3(68),2,5,3)
call HGT_OLR(G2H3(68),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(68),[G2H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(18),[G1H3(227)])
call HGT_OLR(G2H3(69),1,1,3)
call HGT_invQ_OLR(G2H3(69),2,5,3)
call HGT_OLR(G2H3(69),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(69),[G2H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G1H2(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(32),[G1H3(230)])
call HGT_OLR(G2H3(70),1,1,3)
call HGT_invQ_OLR(G2H3(70),2,5,3)
call HGT_OLR(G2H3(70),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(70),[G2H3(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G1H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(47),[G1H3(233)])
call HGT_OLR(G2H3(71),1,1,3)
call HGT_invQ_OLR(G2H3(71),2,5,3)
call HGT_OLR(G2H3(71),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(71),[G2H3(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G1H2(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(37),[G2H3(3),G2H3(94),G2H3(73),G1H3(228),G1H3(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(96),[G2H3(9),G2H3(88),G2H3(76),G1H3(225),G1H3(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(29),[G2H3(90),G2H3(106),G2H3(79),G1H3(234),G1H3(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(39),[G2H3(34),G2H3(100),G2H3(82),G1H3(231),G1H3(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(21),[G1H3(139),G1H3(28)])
call HGT_w2_OLR(G1H3(32),1,1,3)
call HGT_w2_invQ_OLR(G1H3(32),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(32),[G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(7),[G1H3(164),G1H3(108)])
call HGT_w2_OLR(G1H3(33),1,1,3)
call HGT_w2_invQ_OLR(G1H3(33),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(33),[G1H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(104),[G1H2(51)])
call HGT_w2_OLR(G1H2(38),1,1,2)
call HGT_w2_invQ_OLR(G1H2(38),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(2),[G2H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(54),[G1H2(9)])
call HGT_w2_OLR(G1H2(45),1,1,2)
call HGT_w2_invQ_OLR(G1H2(45),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(25),[G2H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(138),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(142),[G1H3(24),G1H3(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(103),[G1H2(209),G1H2(204),G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(153),[G1H3(193),G1H3(58),G1H3(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(128),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(18),[G1H3(167),G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(185),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(150),[G1H3(192),G1H3(170),G1H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(205),[G1H2(188),G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(41),[G1H3(174),G1H3(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(63),[G1H3(182),G1H3(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(214),G1H2(95),G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(85),[G1H3(197),G1H3(185),G1H3(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(191),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(22),[G1H3(117),G1H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(199),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(8),[G1H3(196),G1H3(127),G1H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(96),[G1H2(202),G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(175),[G1H2(170),G1H2(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(46),G0H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(9),[G1H3(210),G1H3(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(171),[G1H2(161),G1H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(176),[G1H2(166),G1H2(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(165),[G1H2(160),G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G1H3(161),G1H3(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G1H3(181),G1H3(178),G1H3(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G1H3(189),G1H3(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(23),G1H2(201),G1H2(198),G1H2(195),G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(112),[G1H6(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(89),[G1H6(42),G1H6(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(110),[G1H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(83),[G1H6(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(80),[G1H6(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(82),[G1H6(142),G1H6(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(101),[G1H6(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(76),[G1H6(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(30),[G1H3(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(74),[G1H3(205),G1H3(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(104),[G1H3(204),G0H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(29),[G1H3(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G1H2(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(14),[G1H3(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(44),[G1H3(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(17),[G1H3(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(23),[G1H3(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G0H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G0H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(101),[G1H3(80),G1H3(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(105),[G1H3(102),G1H3(84)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(90),ex2(:),G2tensor(2),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(68),ex2(:),G2tensor(4),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hloop_QZ_A(ntryL,G1H3(43),ex4(:),G1H1(1),ngZu,m3h3x1(:,256),heltab2x3(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(481))
  call Hloop_QV_A(ntryL,G1H2(56),ex3(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(482))
  call Hloop_QV_A(ntryL,G2H2(71),ex3(:),G2H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(23),n2h1(483))
  call Hloop_QZ_A(ntryL,G2H3(84),ex4(:),G2H1(1),ngZu,m3h3x1(:,257),heltab2x3(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(24),n2h1(484))
  call Hloop_QZ_A(ntryL,G2H3(30),ex4(:),G2H1(1),ngZd,m3h3x1(:,258),heltab2x3(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(25),n2h1(485))
  call Hloop_QZ_A(ntryL,G2H3(58),ex4(:),G2H1(1),ngZu,m3h3x1(:,259),heltab2x3(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(26),n2h1(486))
  call Hloop_QV_A(ntryL,G2H2(76),ex3(:),G2H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(27),n2h1(487))
  call Hloop_QZ_A(ntryL,G2H3(59),ex4(:),G2H1(1),ngZd,m3h3x1(:,260),heltab2x3(:,:,260))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(28),n2h1(488))
  call Hloop_AV_Q(ntryL,G2H2(79),ex3(:),G2H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(29),n2h1(489))
  call Hloop_AZ_Q(ntryL,G2H3(36),ex4(:),G2H1(1),ngZu,m3h3x1(:,261),heltab2x3(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(30),n2h1(490))
  call Hloop_AZ_Q(ntryL,G2H3(28),ex4(:),G2H1(1),ngZd,m3h3x1(:,262),heltab2x3(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(31),n2h1(491))
  call Hloop_AZ_Q(ntryL,G2H3(66),ex4(:),G2H1(1),ngZu,m3h3x1(:,263),heltab2x3(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(32),n2h1(492))
  call Hloop_AV_Q(ntryL,G2H2(84),ex3(:),G2H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(33),n2h1(493))
  call Hloop_AZ_Q(ntryL,G2H3(67),ex4(:),G2H1(1),ngZd,m3h3x1(:,264),heltab2x3(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(34),n2h1(494))
  call Hloop_QZ_A(ntryL,G2H3(5),ex4(:),G2H1(1),ngZu,m3h3x1(:,265),heltab2x3(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(35),n2h1(495))
  call Hloop_QV_A(ntryL,G2H2(17),ex3(:),G2H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(36),n2h1(496))
  call Hloop_QZ_A(ntryL,G2H3(68),ex4(:),G2H1(1),ngZu,m3h3x1(:,266),heltab2x3(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(37),n2h1(497))
  call Hloop_QV_A(ntryL,G2H2(93),ex3(:),G2H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(38),n2h1(498))
  call Hloop_AZ_Q(ntryL,G2H3(69),ex4(:),G2H1(1),ngZu,m3h3x1(:,267),heltab2x3(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(39),n2h1(499))
  call Hloop_AV_Q(ntryL,G2H2(96),ex3(:),G2H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(40),n2h1(500))
  call Hloop_QZ_A(ntryL,G2H3(70),ex4(:),G2H1(1),ngZd,m3h3x1(:,268),heltab2x3(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(41),n2h1(501))
  call Hloop_QV_A(ntryL,G2H2(99),ex3(:),G2H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(42),n2h1(502))
  call Hloop_AZ_Q(ntryL,G2H3(71),ex4(:),G2H1(1),ngZd,m3h3x1(:,269),heltab2x3(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(43),n2h1(503))
  call Hloop_AV_Q(ntryL,G2H2(102),ex3(:),G2H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(44),n2h1(504))
call HGT_OLR(G2H2(104),1,1,2)
call HGT_invQ_OLR(G2H2(104),2,5,2)
call HGT_OLR(G2H2(104),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(104),ex3(:),G2H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(45),n2h1(505))
  call Hloop_AZ_Q(ntryL,G2H3(37),ex4(:),G2H1(1),ngZu,m3h3x1(:,270),heltab2x3(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(46),n2h1(506))
call HGT_OLR(G2H2(105),1,1,2)
call HGT_invQ_OLR(G2H2(105),2,5,2)
call HGT_OLR(G2H2(105),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(105),ex3(:),G2H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(47),n2h1(507))
  call Hloop_QZ_A(ntryL,G2H3(96),ex4(:),G2H1(1),ngZu,m3h3x1(:,271),heltab2x3(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(48),n2h1(508))
call HGT_OLR(G2H2(106),1,1,2)
call HGT_invQ_OLR(G2H2(106),2,5,2)
call HGT_OLR(G2H2(106),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(106),ex3(:),G2H1(1),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(49),n2h1(509))
  call Hloop_AZ_Q(ntryL,G2H3(29),ex4(:),G2H1(1),ngZd,m3h3x1(:,272),heltab2x3(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(50),n2h1(510))
call HGT_OLR(G2H2(107),1,1,2)
call HGT_invQ_OLR(G2H2(107),2,5,2)
call HGT_OLR(G2H2(107),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(107),ex3(:),G2H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(51),n2h1(511))
  call Hloop_QZ_A(ntryL,G2H3(39),ex4(:),G2H1(1),ngZd,m3h3x1(:,273),heltab2x3(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(52),n2h1(512))
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(4),wf4(:,9),G2H1(1),m3h4x1(:,11),heltab2x4(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(53),n2h1(513))
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(2),wf4(:,9),G2H1(1),m3h4x1(:,12),heltab2x4(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(54),n2h1(514))
call HGT_OLR(G2H4(9),1,1,4)
call HGT_invQ_OLR(G2H4(9),2,5,4)
call HGT_OLR(G2H4(9),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(9),wf4(:,9),G2H1(1),m3h4x1(:,13),heltab2x4(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(55),n2h1(515))
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(5),wf4(:,9),G2H1(1),m3h4x1(:,14),heltab2x4(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(56),n2h1(516))
call HGT_OLR(G2H4(8),1,1,4)
call HGT_invQ_OLR(G2H4(8),2,5,4)
call HGT_OLR(G2H4(8),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(8),wf4(:,9),G2H1(1),m3h4x1(:,15),heltab2x4(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(57),n2h1(517))
call HGT_OLR(G2H4(10),1,1,4)
call HGT_invQ_OLR(G2H4(10),2,5,4)
call HGT_OLR(G2H4(10),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(10),wf4(:,9),G2H1(1),m3h4x1(:,16),heltab2x4(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(58),n2h1(518))
  call Hloop_AZ_Q(ntryL,G1H3(32),ex4(:),G1H1(1),ngZu,m3h3x1(:,274),heltab2x3(:,:,274))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(519))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(12),wf4(:,2),G2tensor(9),m3h4x1(:,17),heltab2x4(:,:,65))
  call Hloop_QZ_A(ntryL,G1H3(33),ex4(:),G1H1(1),ngZu,m3h3x1(:,275),heltab2x3(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(520))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(15),wf4(:,6),G2tensor(10),m3h4x1(:,18),heltab2x4(:,:,66))
  call Hloop_AV_Q(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(521))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(2),wf6(:,4),G2tensor(13),m3h6x1(:,29),heltab2x6(:,:,299))
  call Hloop_QV_A(ntryL,G1H2(45),ex3(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(522))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(25),wf6(:,2),G2tensor(17),m3h6x1(:,30),heltab2x6(:,:,300))
  call Hloop_VA_Q(ntryL,G1H2(55),ex2(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(523))
  call Hloop_VA_Q(ntryL,G1H2(60),ex2(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(524))
  call Hloop_ZA_Q(ntryL,G1H2(71),ex2(:),G1H1(1),ngZu,m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(525))
  call Hloop_ZA_Q(ntryL,G1H2(77),ex2(:),G1H1(1),ngZu,m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(526))
  call Hloop_WA_Q(ntryL,G1H2(89),ex2(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(527))
  call Hloop_WA_Q(ntryL,G1H2(138),ex2(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(528))
  call Hloop_QV_A(ntryL,G1H2(87),ex3(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(529))
  call Hloop_QZ_A(ntryL,G1H3(142),ex4(:),G1H1(1),ngZu,m3h3x1(:,276),heltab2x3(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(530))
  call Hloop_QV_A(ntryL,G1H2(103),ex3(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(531))
  call Hloop_QZ_A(ntryL,G1H3(153),ex4(:),G1H1(1),ngZd,m3h3x1(:,277),heltab2x3(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(532))
  call Hloop_VQ_A(ntryL,G1H2(27),ex1(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(533))
  call Hloop_VQ_A(ntryL,G1H2(28),ex1(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(534))
  call Hloop_ZQ_A(ntryL,G1H2(86),ex1(:),G1H1(1),ngZu,m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(535))
  call Hloop_ZQ_A(ntryL,G1H2(42),ex1(:),G1H1(1),ngZu,m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(536))
  call Hloop_WQ_A(ntryL,G1H2(75),ex1(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(537))
  call Hloop_WQ_A(ntryL,G1H2(128),ex1(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(538))
  call Hloop_QZ_A(ntryL,G1H3(18),ex4(:),G1H1(1),ngZu,m3h3x1(:,278),heltab2x3(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(56),n2h1(539))
  call Hloop_QV_A(ntryL,G1H2(185),ex3(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(60),n2h1(540))
  call Hloop_QZ_A(ntryL,G1H3(150),ex4(:),G1H1(1),ngZd,m3h3x1(:,279),heltab2x3(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(541))
  call Hloop_QV_A(ntryL,G1H2(205),ex3(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(542))
  call Hloop_AZ_Q(ntryL,G1H3(41),ex4(:),G1H1(1),ngZu,m3h3x1(:,280),heltab2x3(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(543))
  call Hloop_AV_Q(ntryL,G1H2(105),ex3(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(544))
  call Hloop_AZ_Q(ntryL,G1H3(63),ex4(:),G1H1(1),ngZu,m3h3x1(:,281),heltab2x3(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(545))
  call Hloop_AV_Q(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(72),n2h1(546))
  call Hloop_AZ_Q(ntryL,G1H3(85),ex4(:),G1H1(1),ngZd,m3h3x1(:,282),heltab2x3(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(76),n2h1(547))
  call Hloop_AV_Q(ntryL,G1H2(191),ex3(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(80),n2h1(548))
  call Hloop_AZ_Q(ntryL,G1H3(22),ex4(:),G1H1(1),ngZu,m3h3x1(:,283),heltab2x3(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(84),n2h1(549))
  call Hloop_AV_Q(ntryL,G1H2(199),ex3(:),G1H1(1),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(550))
  call Hloop_AZ_Q(ntryL,G1H3(8),ex4(:),G1H1(1),ngZd,m3h3x1(:,284),heltab2x3(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(88),n2h1(551))
  call Hloop_AV_Q(ntryL,G1H2(96),ex3(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(552))
  call Hloop_WQ_A(ntryL,G1H2(127),ex1(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(553))
  call Hloop_WQ_A(ntryL,G1H2(132),ex1(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(554))
  call Hloop_WQ_A(ntryL,G1H2(133),ex1(:),G1H1(1),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(200),n2h1(555))
  call Hloop_WA_Q(ntryL,G1H2(175),ex2(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(176),n2h1(556))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H3(10),23,ex4(:),8,G3tensor(59),m3h3x1(:,285),heltab2x3(:,:,285))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(9),23,ex4(:),8,G2tensor(167),m3h3x1(:,286),heltab2x3(:,:,286))
  call Hloop_WA_Q(ntryL,G1H2(171),ex2(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(347),n2h1(557))
  call Hloop_WA_Q(ntryL,G1H2(176),ex2(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(323),n2h1(558))
  call Hloop_WA_Q(ntryL,G1H2(165),ex2(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(314),n2h1(559))
  call Hloop_WA_Q(ntryL,G1H2(148),ex2(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(335),n2h1(560))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(152),27,ex3(:),4,G2tensor(135),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(153),27,ex3(:),4,G2tensor(133),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hloop_QZ_A(ntryL,G2H3(2),ex4(:),G2H1(1),ngZd,m3h3x1(:,287),heltab2x3(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(60),n2h1(561))
  call Hloop_AZ_Q(ntryL,G2H3(8),ex4(:),G2H1(1),ngZu,m3h3x1(:,288),heltab2x3(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(61),n2h1(562))
  call Hloop_AZ_Q(ntryL,G2H3(11),ex4(:),G2H1(1),ngZd,m3h3x1(:,289),heltab2x3(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(62),n2h1(563))
  call Hloop_AV_Q(ntryL,G2H2(26),ex3(:),G2H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(63),n2h1(564))
  call Hloop_WQ_A(ntryL,G1H4(29),wf4(:,2),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(132),n2h1(565))
  call Hloop_WQ_A(ntryL,G1H4(31),wf4(:,2),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(134),n2h1(566))
  call Hloop_WA_Q(ntryL,G1H4(21),wf4(:,6),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(140),n2h1(567))
  call Hloop_WA_Q(ntryL,G1H4(4),wf4(:,6),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(142),n2h1(568))
  call Hloop_WQ_A(ntryL,G1H6(112),wf6(:,4),G1H1(1),m3h6x1(:,31),heltab2x6(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(144),n2h1(569))
  call Hloop_WQ_A(ntryL,G1H6(89),wf6(:,4),G1H1(1),m3h6x1(:,32),heltab2x6(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(146),n2h1(570))
  call Hloop_VQ_A(ntryL,G1H6(131),wf6(:,4),G1H1(1),m3h6x1(:,33),heltab2x6(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(152),n2h1(571))
  call Hloop_VQ_A(ntryL,G1H6(110),wf6(:,4),G1H1(1),m3h6x1(:,34),heltab2x6(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(150),n2h1(572))
  call Hloop_ZQ_A(ntryL,G1H6(12),wf6(:,4),G1H1(1),ngZu,m3h6x1(:,35),heltab2x6(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(148),n2h1(573))
  call Hloop_ZQ_A(ntryL,G1H6(83),wf6(:,4),G1H1(1),ngZu,m3h6x1(:,36),heltab2x6(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(149),n2h1(574))
  call Hloop_WQ_A(ntryL,G1H6(59),wf6(:,4),G1H1(1),m3h6x1(:,37),heltab2x6(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(153),n2h1(575))
  call Hloop_WA_Q(ntryL,G1H6(80),wf6(:,2),G1H1(1),m3h6x1(:,38),heltab2x6(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(431),n2h1(576))
  call Hloop_WA_Q(ntryL,G1H6(82),wf6(:,2),G1H1(1),m3h6x1(:,39),heltab2x6(:,:,309))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(437),n2h1(577))
  call Hloop_VA_Q(ntryL,G1H6(40),wf6(:,2),G1H1(1),m3h6x1(:,40),heltab2x6(:,:,310))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(443),n2h1(578))
  call Hloop_VA_Q(ntryL,G1H6(101),wf6(:,2),G1H1(1),m3h6x1(:,41),heltab2x6(:,:,311))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(449),n2h1(579))
  call Hloop_ZA_Q(ntryL,G1H6(56),wf6(:,2),G1H1(1),ngZu,m3h6x1(:,42),heltab2x6(:,:,312))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(455),n2h1(580))
  call Hloop_ZA_Q(ntryL,G1H6(76),wf6(:,2),G1H1(1),ngZu,m3h6x1(:,43),heltab2x6(:,:,313))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(461),n2h1(581))
  call Hloop_WA_Q(ntryL,G1H6(138),wf6(:,2),G1H1(1),m3h6x1(:,44),heltab2x6(:,:,314))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(162),n2h1(582))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(30),23,ex4(:),8,G2tensor(158),m3h3x1(:,290),heltab2x3(:,:,290))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(74),23,ex4(:),8,G2tensor(275),m3h3x1(:,291),heltab2x3(:,:,291))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(104),23,ex4(:),8,G3tensor(64),m3h3x1(:,292),heltab2x3(:,:,292))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(111),27,ex3(:),4,G2tensor(407),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(112),27,ex3(:),4,G2tensor(284),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(29),23,ex4(:),8,G2tensor(392),m3h3x1(:,293),heltab2x3(:,:,293))
  call Hloop_QV_A(ntryL,G2H2(42),ex3(:),G2H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(65),n2h1(583))
  call Hloop_AV_Q(ntryL,G2H2(29),ex3(:),G2H1(1),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(66),n2h1(584))
  call Hloop_QV_A(ntryL,G2H2(38),ex3(:),G2H1(1),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(67),n2h1(585))
  call Hloop_AV_Q(ntryL,G2H2(63),ex3(:),G2H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(68),n2h1(586))
  call Hloop_AZ_Q(ntryL,G2H3(14),ex4(:),G2H1(1),ngZu,m3h3x1(:,294),heltab2x3(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(69),n2h1(587))
  call Hloop_QZ_A(ntryL,G2H3(44),ex4(:),G2H1(1),ngZu,m3h3x1(:,295),heltab2x3(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(70),n2h1(588))
  call Hloop_AZ_Q(ntryL,G2H3(17),ex4(:),G2H1(1),ngZd,m3h3x1(:,296),heltab2x3(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(71),n2h1(589))
  call Hloop_QZ_A(ntryL,G2H3(23),ex4(:),G2H1(1),ngZd,m3h3x1(:,297),heltab2x3(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(72),n2h1(590))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(164),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex2(:),G2tensor(410),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(6),wf4(:,2),G2tensor(170),m3h4x1(:,23),heltab2x4(:,:,71))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(7),wf4(:,6),G2tensor(413),m3h4x1(:,24),heltab2x4(:,:,72))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(5),wf6(:,4),G2tensor(173),m3h6x1(:,45),heltab2x6(:,:,315))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(22),wf6(:,2),G2tensor(416),m3h6x1(:,46),heltab2x6(:,:,316))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H6(75),ex4(:),ex3(:),G1tensor(25),m4h3x2x1(:,1),heltab3x6(:,:,1))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H6(60),ex4(:),ex3(:),G1tensor(55),m4h3x2x1(:,2),heltab3x6(:,:,2))
  call Hloop_VQ_A(ntryL,G1H12(4),wf12(:,26),G1H1(1),m3h12x1(:,1),heltab2x12(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(179),n2h1(591))
  call Hloop_ZQ_A(ntryL,G1H12(28),wf12(:,26),G1H1(1),ngZu,m3h12x1(:,2),heltab2x12(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(592))
  call Hloop_WQ_A(ntryL,G1H12(30),wf12(:,26),G1H1(1),m3h12x1(:,3),heltab2x12(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(185),n2h1(593))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(9),wf12(:,26),G2tensor(53),m3h12x1(:,4),heltab2x12(:,:,172))
  call Hloop_VA_Q(ntryL,G1H12(32),wf12(:,29),G1H1(1),m3h12x1(:,5),heltab2x12(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(191),n2h1(594))
  call Hloop_ZA_Q(ntryL,G1H12(33),wf12(:,29),G1H1(1),ngZu,m3h12x1(:,6),heltab2x12(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(595))
  call Hloop_WA_Q(ntryL,G1H12(35),wf12(:,29),G1H1(1),m3h12x1(:,7),heltab2x12(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(197),n2h1(596))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(10),wf12(:,29),G2tensor(398),m3h12x1(:,8),heltab2x12(:,:,176))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H6(4),wf6(:,4),G2tensor(203),ngZu,m3h6x1(:,47),heltab2x6(:,:,317))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(6),wf6(:,4),G2tensor(401),m3h6x1(:,48),heltab2x6(:,:,318))
  call Hloop_QV_A(ntryL,G2H12(11),wf12(:,34),G2H1(1),m3h12x1(:,9),heltab2x12(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(73),n2h1(597))
  call Hloop_QV_A(ntryL,G2H12(12),wf12(:,34),G2H1(1),m3h12x1(:,10),heltab2x12(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(74),n2h1(598))
  call Hloop_AV_Q(ntryL,G2H12(13),wf12(:,34),G2H1(1),m3h12x1(:,11),heltab2x12(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(75),n2h1(599))
  call Hloop_AV_Q(ntryL,G2H12(14),wf12(:,34),G2H1(1),m3h12x1(:,12),heltab2x12(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(76),n2h1(600))
  call Hloop_QV_A(ntryL,G2H12(15),wf12(:,34),G2H1(1),m3h12x1(:,13),heltab2x12(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(77),n2h1(601))
  call Hloop_AV_Q(ntryL,G2H12(16),wf12(:,34),G2H1(1),m3h12x1(:,14),heltab2x12(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(78),n2h1(602))
  call Hloop_VQ_A(ntryL,G1H12(45),wf12(:,31),G1H1(1),m3h12x1(:,15),heltab2x12(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(206),n2h1(603))
  call Hloop_ZQ_A(ntryL,G1H12(46),wf12(:,31),G1H1(1),ngZu,m3h12x1(:,16),heltab2x12(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(404),n2h1(604))
  call Hloop_WQ_A(ntryL,G1H12(47),wf12(:,31),G1H1(1),m3h12x1(:,17),heltab2x12(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(212),n2h1(605))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(17),wf12(:,31),G2tensor(218),m3h12x1(:,18),heltab2x12(:,:,186))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(32),27,ex3(:),4,G2tensor(224),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H6(8),wf6(:,2),G2tensor(230),ngZu,m3h6x1(:,49),heltab2x6(:,:,319))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(10),wf6(:,2),G2tensor(73),m3h6x1(:,50),heltab2x6(:,:,320))
  call Hloop_QV_A(ntryL,G2H12(18),wf12(:,35),G2H1(1),m3h12x1(:,19),heltab2x12(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(79),n2h1(606))
  call Hloop_QV_A(ntryL,G2H12(1),wf12(:,35),G2H1(1),m3h12x1(:,20),heltab2x12(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(80),n2h1(607))
  call Hloop_AV_Q(ntryL,G2H12(2),wf12(:,35),G2H1(1),m3h12x1(:,21),heltab2x12(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(81),n2h1(608))
  call Hloop_AV_Q(ntryL,G2H12(3),wf12(:,35),G2H1(1),m3h12x1(:,22),heltab2x12(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(82),n2h1(609))
  call Hloop_QV_A(ntryL,G2H12(4),wf12(:,35),G2H1(1),m3h12x1(:,23),heltab2x12(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(83),n2h1(610))
  call Hloop_AV_Q(ntryL,G2H12(5),wf12(:,35),G2H1(1),m3h12x1(:,24),heltab2x12(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(84),n2h1(611))
  call Hloop_VA_Q(ntryL,G1H12(57),wf12(:,33),G1H1(1),m3h12x1(:,25),heltab2x12(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(236),n2h1(612))
  call Hloop_ZA_Q(ntryL,G1H12(58),wf12(:,33),G1H1(1),ngZu,m3h12x1(:,26),heltab2x12(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(613))
  call Hloop_WA_Q(ntryL,G1H12(60),wf12(:,33),G1H1(1),m3h12x1(:,27),heltab2x12(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(242),n2h1(614))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(6),wf12(:,33),G2tensor(81),m3h12x1(:,28),heltab2x12(:,:,196))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1),27,ex3(:),4,G2tensor(248),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hloop_AZ_Q(ntryL,G2H3(43),ex4(:),G2H1(1),ngZl,m3h3x1(:,298),heltab2x3(:,:,298))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(85),n2h1(615))
  call Hloop_AZ_Q(ntryL,G2H3(45),ex4(:),G2H1(1),ngZl,m3h3x1(:,299),heltab2x3(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(86),n2h1(616))
  call Hloop_AZ_Q(ntryL,G2H3(40),ex4(:),G2H1(1),ngZl,m3h3x1(:,300),heltab2x3(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(87),n2h1(617))
  call Hloop_QZ_A(ntryL,G2H3(41),ex4(:),G2H1(1),ngZl,m3h3x1(:,301),heltab2x3(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(88),n2h1(618))
  call Hloop_QZ_A(ntryL,G2H3(42),ex4(:),G2H1(1),ngZl,m3h3x1(:,302),heltab2x3(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(89),n2h1(619))
  call Hloop_QZ_A(ntryL,G2H3(49),ex4(:),G2H1(1),ngZl,m3h3x1(:,303),heltab2x3(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(90),n2h1(620))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(1),23,ex4(:),8,G3tensor(91),m3h3x1(:,304),heltab2x3(:,:,304))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(4),23,ex4(:),8,G3tensor(92),m3h3x1(:,305),heltab2x3(:,:,305))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(92),23,ex4(:),G3tensor(93),m3h3x1(:,306),heltab2x3(:,:,306))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(7),23,ex4(:),8,G3tensor(94),m3h3x1(:,307),heltab2x3(:,:,307))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(101),ex4(:),G1tensor(85),m3h3x1(:,308),heltab2x3(:,:,308))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(105),ex4(:),G1tensor(115),m3h3x1(:,309),heltab2x3(:,:,309))
  call ol_merge_tensors(G2tensor(411),[G2tensor(165),G2tensor(14),G1tensor(38),G1tensor(24),G0tensor(46),G0tensor(41)])
  call ol_merge_tensors(G2tensor(414),[G2tensor(171),G2tensor(18),G1tensor(60),G1tensor(50),G0tensor(56),G0tensor(51)])
  call ol_merge_tensors(G2tensor(429),[G2tensor(417),G2tensor(174),G2tensor(22),G1tensor(518),G1tensor(69),G1tensor(74) &
    ,G0tensor(491),G0tensor(66),G0tensor(61)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(213),G2tensor(180),G2tensor(50),G2tensor(26),G1tensor(76),G1tensor(23) &
    ,G1tensor(132),G1tensor(102),G0tensor(131),G0tensor(102),G0tensor(76),G0tensor(71)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(219),G2tensor(186),G2tensor(54),G2tensor(30),G1tensor(88),G1tensor(29) &
    ,G1tensor(140),G1tensor(33),G0tensor(136),G0tensor(112),G0tensor(86),G0tensor(81)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(225),G2tensor(192),G2tensor(58),G2tensor(34),G1tensor(93),G1tensor(47),G1tensor(81) &
    ,G1tensor(2),G0tensor(141),G0tensor(122),G0tensor(96),G0tensor(91)])
  call ol_merge_tensors(G2tensor(410),[G2tensor(399),G2tensor(198),G2tensor(38),G1tensor(243),G1tensor(238),G1tensor(28) &
    ,G1tensor(16),G0tensor(252),G0tensor(247),G0tensor(106),G0tensor(101)])
  call ol_merge_tensors(G2tensor(402),[G2tensor(204),G2tensor(42),G1tensor(112),G1tensor(35),G0tensor(116),G0tensor(111)])
  call ol_merge_tensors(G2tensor(420),[G2tensor(405),G2tensor(207),G2tensor(46),G1tensor(513),G1tensor(137),G1tensor(46) &
    ,G0tensor(486),G0tensor(126),G0tensor(121)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(249),G2tensor(231),G2tensor(74),G2tensor(62),G1tensor(167),G1tensor(117) &
    ,G1tensor(105),G1tensor(26),G0tensor(176),G0tensor(151),G0tensor(146),G0tensor(42)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(255),G2tensor(237),G2tensor(78),G2tensor(66),G1tensor(172),G1tensor(147) &
    ,G1tensor(155),G1tensor(90),G0tensor(181),G0tensor(161),G0tensor(156),G0tensor(52)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(261),G2tensor(243),G2tensor(82),G2tensor(70),G1tensor(177),G1tensor(162) &
    ,G1tensor(157),G1tensor(78),G0tensor(186),G0tensor(171),G0tensor(166),G0tensor(62)])
  call ol_merge_tensors(G2tensor(224),[G2tensor(423),G2tensor(396),G2tensor(267),G2tensor(86),G1tensor(457),G1tensor(187) &
    ,G1tensor(182),G0tensor(466),G0tensor(196),G0tensor(191)])
  call ol_merge_tensors(G2tensor(158),[G2tensor(426),G2tensor(390),G2tensor(270),G2tensor(90),G1tensor(514),G1tensor(462) &
    ,G1tensor(197),G1tensor(192),G0tensor(487),G0tensor(471),G0tensor(206),G0tensor(201)])
  call ol_merge_tensors(G2tensor(248),[G2tensor(408),G2tensor(276),G2tensor(273),G2tensor(95),G2tensor(94),G1tensor(202) &
    ,G1tensor(121),G1tensor(91),G0tensor(211),G0tensor(26),G0tensor(21)])
  call ol_merge_tensors(G2tensor(392),[G2tensor(393),G2tensor(285),G2tensor(282),G2tensor(100),G2tensor(99),G1tensor(519) &
    ,G1tensor(207),G1tensor(150),G1tensor(151),G0tensor(492),G0tensor(216),G0tensor(36),G0tensor(31)])
  call ol_merge_tensors(G2tensor(292),[G2tensor(289),G2tensor(11),G2tensor(3),G1tensor(235),G1tensor(227),G1tensor(215) &
    ,G1tensor(114),G0tensor(244),G0tensor(236),G0tensor(224),G0tensor(77)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(236),G2tensor(398),G2tensor(191),G2tensor(253),G2tensor(235),G2tensor(163) &
    ,G2tensor(159),G2tensor(110),G2tensor(104),G2tensor(5),G1tensor(405),G1tensor(375),G1tensor(230),G1tensor(125),G1tensor(79) &
    ,G1tensor(49),G0tensor(414),G0tensor(384),G0tensor(239),G0tensor(154),G0tensor(19),G0tensor(14)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(288),G2tensor(8),G1tensor(212),G1tensor(104),G1tensor(31),G0tensor(221) &
    ,G0tensor(72),G0tensor(11)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(291),G2tensor(15),G1tensor(323),G1tensor(232),G1tensor(130),G1tensor(61) &
    ,G0tensor(332),G0tensor(241),G0tensor(132),G0tensor(16)])
  call ol_merge_tensors(G2tensor(443),[G2tensor(252),G2tensor(250),G2tensor(19),G1tensor(402),G1tensor(170),G1tensor(42) &
    ,G0tensor(411),G0tensor(179),G0tensor(47)])
  call ol_merge_tensors(G2tensor(449),[G2tensor(17),G2tensor(307),G2tensor(127),G2tensor(23),G1tensor(275),G1tensor(225) &
    ,G1tensor(44),G1tensor(43),G0tensor(284),G0tensor(234),G0tensor(48),G0tensor(13)])
  call ol_merge_tensors(G3tensor(81),[G3tensor(79),G3tensor(75),G3tensor(73),G3tensor(6),G3tensor(5),G3tensor(2),G3tensor(1) &
    ,G2tensor(418),G2tensor(415),G2tensor(412),G2tensor(406),G2tensor(403),G2tensor(400),G2tensor(211),G2tensor(202),G2tensor(178) &
    ,G2tensor(169),G1tensor(280),G1tensor(70),G1tensor(58),G1tensor(65),G1tensor(98),G1tensor(68),G1tensor(84),G0tensor(289) &
    ,G0tensor(129),G0tensor(119),G0tensor(109),G0tensor(69),G0tensor(59),G0tensor(49)])
  call ol_merge_tensors(G2tensor(455),[G2tensor(258),G2tensor(256),G2tensor(27),G1tensor(412),G1tensor(175),G1tensor(62) &
    ,G0tensor(421),G0tensor(184),G0tensor(57)])
  call ol_merge_tensors(G2tensor(461),[G2tensor(310),G2tensor(31),G1tensor(285),G1tensor(66),G0tensor(294),G0tensor(58)])
  call ol_merge_tensors(G2tensor(162),[G2tensor(283),G2tensor(264),G2tensor(262),G2tensor(35),G1tensor(422),G1tensor(210) &
    ,G1tensor(180),G1tensor(92),G0tensor(431),G0tensor(219),G0tensor(189),G0tensor(67)])
  call ol_merge_tensors(G2tensor(437),[G2tensor(313),G2tensor(298),G2tensor(120),G2tensor(39),G1tensor(290),G1tensor(255) &
    ,G1tensor(75),G1tensor(133),G0tensor(299),G0tensor(264),G0tensor(68),G0tensor(28)])
  call ol_merge_tensors(G3tensor(10),[G3tensor(9),G3tensor(8),G3tensor(7),G3tensor(4),G3tensor(3),G2tensor(364),G2tensor(358) &
    ,G2tensor(349),G2tensor(337),G2tensor(325),G2tensor(316),G1tensor(340),G1tensor(295),G1tensor(164),G1tensor(154),G1tensor(123) &
    ,G1tensor(9),G1tensor(146),G1tensor(116),G0tensor(349),G0tensor(304),G0tensor(173),G0tensor(163),G0tensor(153),G0tensor(98) &
    ,G0tensor(88),G0tensor(78)])
  call ol_merge_tensors(G2tensor(218),[G2tensor(206),G2tensor(53),G2tensor(179),G2tensor(217),G2tensor(184),G2tensor(161) &
    ,G2tensor(157),G2tensor(87),G2tensor(43),G1tensor(511),G1tensor(506),G1tensor(345),G1tensor(300),G1tensor(27),G0tensor(484) &
    ,G0tensor(479),G0tensor(354),G0tensor(309),G0tensor(79)])
  call ol_merge_tensors(G2tensor(340),[G2tensor(319),G2tensor(91),G2tensor(47),G1tensor(350),G1tensor(305),G1tensor(144) &
    ,G0tensor(359),G0tensor(314),G0tensor(87)])
  call ol_merge_tensors(G2tensor(404),[G2tensor(49),G2tensor(223),G2tensor(190),G2tensor(96),G2tensor(51),G1tensor(355) &
    ,G1tensor(310),G1tensor(152),G0tensor(364),G0tensor(319),G0tensor(89)])
  call ol_merge_tensors(G2tensor(343),[G2tensor(322),G2tensor(101),G2tensor(55),G1tensor(360),G1tensor(315),G1tensor(8) &
    ,G0tensor(369),G0tensor(324),G0tensor(97)])
  call ol_merge_tensors(G2tensor(212),[G2tensor(185),G2tensor(397),G2tensor(391),G2tensor(229),G2tensor(196),G2tensor(102) &
    ,G2tensor(59),G1tensor(365),G1tensor(320),G1tensor(200),G1tensor(190),G1tensor(10),G0tensor(374),G0tensor(329),G0tensor(209) &
    ,G0tensor(199),G0tensor(99)])
  call ol_merge_tensors(G2tensor(152),[G2tensor(216),G2tensor(214),G2tensor(63),G1tensor(342),G1tensor(118),G1tensor(77) &
    ,G0tensor(351),G0tensor(134),G0tensor(107)])
  call ol_merge_tensors(G2tensor(150),[G2tensor(13),G2tensor(328),G2tensor(67),G1tensor(510),G1tensor(325),G1tensor(71) &
    ,G0tensor(483),G0tensor(334),G0tensor(108)])
  call ol_merge_tensors(G2tensor(148),[G2tensor(222),G2tensor(220),G2tensor(71),G1tensor(352),G1tensor(87),G1tensor(106) &
    ,G0tensor(361),G0tensor(139),G0tensor(117)])
  call ol_merge_tensors(G2tensor(149),[G2tensor(331),G2tensor(75),G1tensor(330),G1tensor(100),G0tensor(339),G0tensor(118)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(271),G2tensor(228),G2tensor(226),G2tensor(79),G1tensor(362),G1tensor(195) &
    ,G1tensor(99),G1tensor(59),G0tensor(371),G0tensor(204),G0tensor(144),G0tensor(127)])
  call ol_merge_tensors(G2tensor(146),[G2tensor(334),G2tensor(83),G1tensor(335),G1tensor(189),G1tensor(64),G0tensor(344) &
    ,G0tensor(198),G0tensor(128)])
  call ol_merge_tensors(G2tensor(361),[G2tensor(346),G2tensor(109),G2tensor(103),G1tensor(400),G1tensor(370),G1tensor(119) &
    ,G0tensor(409),G0tensor(379),G0tensor(152)])
  call ol_merge_tensors(G2tensor(367),[G2tensor(352),G2tensor(111),G2tensor(105),G1tensor(410),G1tensor(380),G1tensor(153) &
    ,G0tensor(419),G0tensor(389),G0tensor(162)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(57),G2tensor(259),G2tensor(241),G2tensor(112),G2tensor(106),G1tensor(415) &
    ,G1tensor(385),G1tensor(1),G0tensor(424),G0tensor(394),G0tensor(164)])
  call ol_merge_tensors(G2tensor(370),[G2tensor(355),G2tensor(113),G2tensor(107),G1tensor(420),G1tensor(390),G1tensor(163) &
    ,G0tensor(429),G0tensor(399),G0tensor(172)])
  call ol_merge_tensors(G2tensor(242),[G2tensor(197),G2tensor(409),G2tensor(394),G2tensor(280),G2tensor(265),G2tensor(247) &
    ,G2tensor(121),G2tensor(114),G2tensor(108),G1tensor(425),G1tensor(395),G1tensor(260),G1tensor(165),G1tensor(20),G1tensor(139) &
    ,G0tensor(434),G0tensor(404),G0tensor(269),G0tensor(174),G0tensor(39),G0tensor(29)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(373),G2tensor(115),G1tensor(430),G1tensor(188),G0tensor(439),G0tensor(197)])
  call ol_merge_tensors(G2tensor(132),[G2tensor(376),G2tensor(116),G1tensor(435),G1tensor(198),G0tensor(444),G0tensor(207)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(379),G2tensor(117),G1tensor(440),G1tensor(199),G0tensor(449),G0tensor(208)])
  call ol_merge_tensors(G2tensor(431),[G2tensor(382),G2tensor(295),G2tensor(119),G2tensor(118),G1tensor(445),G1tensor(250) &
    ,G1tensor(127),G0tensor(454),G0tensor(259),G0tensor(27)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(385),G2tensor(301),G2tensor(124),G2tensor(122),G1tensor(450),G1tensor(265) &
    ,G1tensor(18),G0tensor(459),G0tensor(274),G0tensor(37)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(388),G2tensor(304),G2tensor(125),G2tensor(123),G1tensor(455),G1tensor(270) &
    ,G1tensor(19),G0tensor(464),G0tensor(279),G0tensor(38)])
  call ol_merge_tensors(G2tensor(416),[G2tensor(126),G1tensor(220),G1tensor(37),G0tensor(229),G0tensor(12)])
  call ol_merge_tensors(G2tensor(413),[G2tensor(128),G1tensor(240),G1tensor(67),G0tensor(249),G0tensor(17)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(129),G1tensor(245),G1tensor(73),G0tensor(254),G0tensor(18)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(15),G3tensor(12),G3tensor(11),G2tensor(448),G2tensor(445),G2tensor(436) &
    ,G2tensor(433),G1tensor(536),G1tensor(526),G0tensor(509),G0tensor(499)])
  call ol_merge_tensors(G3tensor(18),[G3tensor(17),G3tensor(14),G3tensor(13),G2tensor(454),G2tensor(451),G2tensor(442) &
    ,G2tensor(439),G1tensor(541),G1tensor(531),G0tensor(514),G0tensor(504)])
  call ol_merge_tensors(G3tensor(82),[G3tensor(80),G3tensor(76),G3tensor(74),G3tensor(20),G3tensor(19),G2tensor(460),G2tensor(457) &
    ,G1tensor(546),G0tensor(519)])
  call ol_merge_tensors(G3tensor(84),[G3tensor(83),G3tensor(78),G3tensor(77),G3tensor(22),G3tensor(21),G2tensor(466),G2tensor(463) &
    ,G1tensor(551),G0tensor(524)])
  call ol_merge_tensors(G3tensor(55),[G3tensor(53),G2tensor(210),G2tensor(208),G2tensor(205),G2tensor(201),G2tensor(199) &
    ,G2tensor(177),G2tensor(175),G2tensor(172),G2tensor(168),G2tensor(166),G1tensor(277),G1tensor(53),G1tensor(148),G1tensor(21) &
    ,G1tensor(63),G1tensor(56),G1tensor(32),G0tensor(286),G0tensor(124),G0tensor(114),G0tensor(104),G0tensor(64),G0tensor(54) &
    ,G0tensor(44)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(181),G1tensor(297),G1tensor(108),G0tensor(306),G0tensor(74)])
  call ol_merge_tensors(G2tensor(189),[G2tensor(187),G1tensor(307),G1tensor(134),G0tensor(316),G0tensor(84)])
  call ol_merge_tensors(G2tensor(268),[G2tensor(195),G2tensor(193),G1tensor(317),G1tensor(185),G1tensor(11),G0tensor(326) &
    ,G0tensor(194),G0tensor(94)])
  call ol_merge_tensors(G2tensor(234),[G2tensor(232),G1tensor(372),G1tensor(149),G0tensor(381),G0tensor(149)])
  call ol_merge_tensors(G2tensor(240),[G2tensor(238),G1tensor(382),G1tensor(141),G0tensor(391),G0tensor(159)])
  call ol_merge_tensors(G2tensor(274),[G2tensor(246),G2tensor(244),G1tensor(392),G1tensor(205),G1tensor(160),G0tensor(401) &
    ,G0tensor(214),G0tensor(169)])
  call ol_merge_tensors(G2tensor(286),[G2tensor(279),G2tensor(277),G1tensor(55),G1tensor(257),G1tensor(13),G1tensor(109) &
    ,G0tensor(266),G0tensor(34),G0tensor(24)])
  call ol_merge_tensors(G3tensor(94),[G3tensor(93),G3tensor(92),G3tensor(91),G3tensor(64),G3tensor(59),G2tensor(294),G1tensor(115) &
    ,G1tensor(85),G1tensor(458),G1tensor(247),G1tensor(97),G0tensor(467),G0tensor(256),G0tensor(22)])
  call ol_merge_tensors(G2tensor(167),[G2tensor(297),G1tensor(520),G1tensor(252),G1tensor(103),G0tensor(493),G0tensor(261) &
    ,G0tensor(23)])
  call ol_merge_tensors(G2tensor(407),[G2tensor(135),G2tensor(300),G1tensor(463),G1tensor(262),G1tensor(6),G0tensor(472) &
    ,G0tensor(271),G0tensor(32)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(303),G1tensor(267),G1tensor(12),G0tensor(276),G0tensor(33)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(306),G1tensor(272),G1tensor(30),G0tensor(281),G0tensor(43)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(309),G1tensor(282),G1tensor(54),G0tensor(291),G0tensor(53)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(312),G1tensor(287),G1tensor(204),G1tensor(80),G0tensor(296),G0tensor(213) &
    ,G0tensor(63)])
  call ol_merge_tensors(G3tensor(29),[G3tensor(23),G2tensor(357),G2tensor(348),G2tensor(324),G2tensor(315),G1tensor(292) &
    ,G1tensor(159),G1tensor(135),G1tensor(111),G1tensor(4),G1tensor(39),G1tensor(126),G0tensor(301),G0tensor(168),G0tensor(158) &
    ,G0tensor(148),G0tensor(93),G0tensor(83),G0tensor(73)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(318),G1tensor(302),G1tensor(128),G0tensor(311),G0tensor(82)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(321),G1tensor(438),G1tensor(433),G1tensor(312),G1tensor(3),G0tensor(447) &
    ,G0tensor(442),G0tensor(321),G0tensor(92)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(327),G1tensor(322),G1tensor(17),G0tensor(331),G0tensor(103)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(330),G1tensor(327),G1tensor(34),G0tensor(336),G0tensor(113)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(333),G1tensor(332),G1tensor(184),G1tensor(51),G0tensor(341),G0tensor(193) &
    ,G0tensor(123)])
  call ol_merge_tensors(G3tensor(34),[G3tensor(32),G3tensor(28),G3tensor(26),G2tensor(363),G2tensor(336),G1tensor(337) &
    ,G1tensor(278),G1tensor(179),G1tensor(174),G1tensor(169),G1tensor(95),G1tensor(83),G1tensor(124),G0tensor(346),G0tensor(287) &
    ,G0tensor(188),G0tensor(183),G0tensor(178),G0tensor(143),G0tensor(138),G0tensor(133)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(339),G1tensor(347),G1tensor(328),G1tensor(82),G0tensor(356),G0tensor(337) &
    ,G0tensor(137)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(342),G1tensor(428),G1tensor(357),G1tensor(333),G1tensor(143),G0tensor(437) &
    ,G0tensor(366),G0tensor(342),G0tensor(142)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(345),G1tensor(508),G1tensor(367),G1tensor(107),G0tensor(481),G0tensor(376) &
    ,G0tensor(147)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(351),G1tensor(377),G1tensor(131),G0tensor(386),G0tensor(157)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(354),G1tensor(453),G1tensor(448),G1tensor(387),G1tensor(158),G0tensor(462) &
    ,G0tensor(457),G0tensor(396),G0tensor(167)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(360),G1tensor(503),G1tensor(397),G1tensor(273),G1tensor(168),G0tensor(476) &
    ,G0tensor(406),G0tensor(282),G0tensor(177)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(366),G1tensor(407),G1tensor(283),G1tensor(173),G0tensor(416),G0tensor(292) &
    ,G0tensor(182)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(369),G1tensor(443),G1tensor(417),G1tensor(288),G1tensor(178),G0tensor(452) &
    ,G0tensor(426),G0tensor(297),G0tensor(187)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(372),G1tensor(427),G1tensor(183),G0tensor(436),G0tensor(192)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(375),G1tensor(432),G1tensor(193),G0tensor(441),G0tensor(202)])
  call ol_merge_tensors(G2tensor(200),[G2tensor(378),G1tensor(437),G1tensor(194),G0tensor(446),G0tensor(203)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(381),G1tensor(442),G1tensor(268),G1tensor(263),G1tensor(203),G0tensor(451) &
    ,G0tensor(277),G0tensor(272),G0tensor(212)])
  call ol_merge_tensors(G2tensor(314),[G2tensor(384),G1tensor(447),G1tensor(253),G1tensor(248),G1tensor(208),G0tensor(456) &
    ,G0tensor(262),G0tensor(257),G0tensor(217)])
  call ol_merge_tensors(G2tensor(335),[G2tensor(387),G1tensor(452),G1tensor(209),G0tensor(461),G0tensor(218)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(421),G1tensor(516),G0tensor(489)])
  call ol_merge_tensors(G2tensor(427),[G2tensor(424),G1tensor(25),G1tensor(465),G1tensor(460),G0tensor(474),G0tensor(469)])
  call ol_merge_tensors(G2tensor(401),[G2tensor(430),G1tensor(521),G0tensor(494)])
  call ol_merge_tensors(G3tensor(39),[G3tensor(37),G2tensor(435),G2tensor(432),G1tensor(544),G1tensor(523),G0tensor(517) &
    ,G0tensor(496)])
  call ol_merge_tensors(G3tensor(43),[G3tensor(41),G2tensor(441),G2tensor(438),G1tensor(549),G1tensor(528),G0tensor(522) &
    ,G0tensor(501)])
  call ol_merge_tensors(G3tensor(47),[G3tensor(45),G2tensor(447),G2tensor(444),G1tensor(533),G0tensor(506)])
  call ol_merge_tensors(G3tensor(51),[G3tensor(49),G2tensor(453),G2tensor(450),G1tensor(538),G0tensor(511)])
  call ol_merge_tensors(G3tensor(56),[G3tensor(54),G2tensor(459),G2tensor(456),G1tensor(543),G0tensor(516)])
  call ol_merge_tensors(G3tensor(58),[G3tensor(57),G2tensor(465),G2tensor(462),G1tensor(548),G0tensor(521)])
  call ol_merge_tensors(G3tensor(62),[G3tensor(61),G3tensor(60),G3tensor(35),G1tensor(388),G1tensor(378),G1tensor(368) &
    ,G1tensor(313),G1tensor(303),G1tensor(293),G1tensor(217),G1tensor(213),G0tensor(397),G0tensor(387),G0tensor(377),G0tensor(322) &
    ,G0tensor(312),G0tensor(302),G0tensor(226),G0tensor(222)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(298),G1tensor(222),G1tensor(214),G0tensor(307),G0tensor(231),G0tensor(223)])
  call ol_merge_tensors(G2tensor(164),[G1tensor(223),G1tensor(218),G0tensor(232),G0tensor(227)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(239),G1tensor(228),G1tensor(219),G0tensor(248),G0tensor(237),G0tensor(228)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(244),G1tensor(229),G1tensor(224),G0tensor(253),G0tensor(238),G0tensor(233)])
  call ol_merge_tensors(G3tensor(63),[G3tensor(36),G1tensor(418),G1tensor(408),G1tensor(398),G1tensor(358),G1tensor(348) &
    ,G1tensor(338),G1tensor(237),G1tensor(233),G0tensor(427),G0tensor(417),G0tensor(407),G0tensor(367),G0tensor(357),G0tensor(347) &
    ,G0tensor(246),G0tensor(242)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(343),G1tensor(242),G1tensor(234),G0tensor(352),G0tensor(251),G0tensor(243)])
  call ol_merge_tensors(G2tensor(347),[G1tensor(264),G1tensor(258),G1tensor(249),G0tensor(273),G0tensor(267),G0tensor(258)])
  call ol_merge_tensors(G2tensor(323),[G1tensor(269),G1tensor(259),G1tensor(254),G0tensor(278),G0tensor(268),G0tensor(263)])
  call ol_merge_tensors(G3tensor(31),[G3tensor(30),G3tensor(25),G3tensor(24),G1tensor(394),G1tensor(384),G1tensor(374) &
    ,G1tensor(334),G1tensor(329),G1tensor(324),G1tensor(319),G1tensor(309),G1tensor(299),G1tensor(294),G1tensor(289),G1tensor(284) &
    ,G1tensor(279),G1tensor(274),G0tensor(403),G0tensor(393),G0tensor(383),G0tensor(343),G0tensor(338),G0tensor(333),G0tensor(328) &
    ,G0tensor(318),G0tensor(308),G0tensor(303),G0tensor(298),G0tensor(293),G0tensor(288),G0tensor(283)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(308),G1tensor(304),G0tensor(317),G0tensor(313)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(429),G1tensor(318),G1tensor(314),G0tensor(438),G0tensor(327),G0tensor(323)])
  call ol_merge_tensors(G3tensor(33),[G3tensor(27),G1tensor(454),G1tensor(439),G1tensor(424),G1tensor(414),G1tensor(404) &
    ,G1tensor(364),G1tensor(354),G1tensor(344),G1tensor(339),G0tensor(463),G0tensor(448),G0tensor(433),G0tensor(423),G0tensor(413) &
    ,G0tensor(373),G0tensor(363),G0tensor(353),G0tensor(348)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(353),G1tensor(349),G0tensor(362),G0tensor(358)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(434),G1tensor(363),G1tensor(359),G0tensor(443),G0tensor(372),G0tensor(368)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(373),G1tensor(369),G0tensor(382),G0tensor(378)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(383),G1tensor(379),G0tensor(392),G0tensor(388)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(444),G1tensor(393),G1tensor(389),G0tensor(453),G0tensor(402),G0tensor(398)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(403),G1tensor(399),G0tensor(412),G0tensor(408)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(413),G1tensor(409),G0tensor(422),G0tensor(418)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(449),G1tensor(423),G1tensor(419),G0tensor(458),G0tensor(432),G0tensor(428)])
  call ol_merge_tensors(G2tensor(275),[G1tensor(515),G1tensor(459),G0tensor(488),G0tensor(468)])
  call ol_merge_tensors(G2tensor(284),[G1tensor(464),G0tensor(473)])
  call ol_merge_tensors(G1tensor(493),[G1tensor(469)])
  call ol_merge_tensors(G1tensor(474),[G1tensor(470)])
  call ol_merge_tensors(G1tensor(492),[G1tensor(471)])
  call ol_merge_tensors(G1tensor(496),[G1tensor(475)])
  call ol_merge_tensors(G1tensor(486),[G1tensor(478)])
  call ol_merge_tensors(G1tensor(500),[G1tensor(479)])
  call ol_merge_tensors(G1tensor(490),[G1tensor(482)])
  call ol_merge_tensors(G1tensor(497),[G1tensor(485)])
  call ol_merge_tensors(G1tensor(501),[G1tensor(489)])
  call ol_merge_tensors(G2tensor(170),[G1tensor(504),G0tensor(477)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(505),G0tensor(478)])
  call ol_merge_tensors(G2tensor(173),[G1tensor(509),G0tensor(482)])
  call ol_merge_tensors(G3tensor(66),[G3tensor(65),G1tensor(524),G0tensor(497)])
  call ol_merge_tensors(G3tensor(40),[G3tensor(38),G1tensor(525),G0tensor(498)])
  call ol_merge_tensors(G3tensor(68),[G3tensor(67),G1tensor(529),G0tensor(502)])
  call ol_merge_tensors(G3tensor(44),[G3tensor(42),G1tensor(530),G0tensor(503)])
  call ol_merge_tensors(G3tensor(70),[G3tensor(69),G1tensor(534),G0tensor(507)])
  call ol_merge_tensors(G3tensor(48),[G3tensor(46),G1tensor(545),G1tensor(535),G0tensor(518),G0tensor(508)])
  call ol_merge_tensors(G3tensor(72),[G3tensor(71),G1tensor(539),G0tensor(512)])
  call ol_merge_tensors(G3tensor(52),[G3tensor(50),G1tensor(550),G1tensor(540),G0tensor(523),G0tensor(513)])
  call ol_merge_tensors(G3tensor(88),[G3tensor(85)])
  call ol_merge_tensors(G3tensor(89),[G3tensor(86)])
  call ol_merge_tensors(G3tensor(90),[G3tensor(87)])
  call TI_triangle_red(G2tensor(411),RedBasis(64),mass3set(:,1),G0tensor(10),G0tensor(15),G0tensor(20),G0tensor(25),M2L1R1)
  call TI_triangle_red(G2tensor(414),RedBasis(64),mass3set(:,2),G0tensor(30),G0tensor(35),G0tensor(40),G0tensor(45),M2L1R1,[nMZ], &
    G0tensor(50))
  call TI_triangle_red(G2tensor(429),RedBasis(64),mass3set(:,3),G0tensor(55),G0tensor(60),G0tensor(65),G0tensor(70),M2L1R1,[nMW], &
    G0tensor(75))
  call TI_triangle_red(G2tensor(40),RedBasis(62),mass3set(:,1),G0tensor(80),G0tensor(85),G0tensor(90),G0tensor(95),M2L1R1)
  call TI_triangle_red(G2tensor(44),RedBasis(62),mass3set(:,4),G0tensor(100),G0tensor(105),G0tensor(110), &
    G0tensor(115),M2L1R1,[nMZ],G0tensor(120))
  call TI_triangle_red(G2tensor(48),RedBasis(62),mass3set(:,5),G0tensor(125),G0tensor(130),G0tensor(135), &
    G0tensor(140),M2L1R1,[nMW],G0tensor(145))
  call TI_triangle_red(G2tensor(410),RedBasis(9),mass3set(:,1),G0tensor(150),G0tensor(155),G0tensor(160),G0tensor(165),M2L1R1)
  call TI_triangle_red(G2tensor(402),RedBasis(9),mass3set(:,2),G0tensor(170),G0tensor(175),G0tensor(180), &
    G0tensor(185),M2L1R1,[nMZ],G0tensor(190))
  call TI_triangle_red(G2tensor(420),RedBasis(9),mass3set(:,3),G0tensor(195),G0tensor(200),G0tensor(205), &
    G0tensor(210),M2L1R1,[nMW],G0tensor(215))
  call TI_triangle_red(G2tensor(20),RedBasis(58),mass3set(:,1),G0tensor(220),G0tensor(225),G0tensor(230),G0tensor(235),M2L1R1)
  call TI_triangle_red(G2tensor(24),RedBasis(58),mass3set(:,4),G0tensor(240),G0tensor(245),G0tensor(250), &
    G0tensor(255),M2L1R1,[nMZ],G0tensor(260))
  call TI_triangle_red(G2tensor(28),RedBasis(58),mass3set(:,5),G0tensor(265),G0tensor(270),G0tensor(275), &
    G0tensor(280),M2L1R1,[nMW],G0tensor(285))
  call TI_triangle_red(G2tensor(224),RedBasis(33),mass3set(:,6),G0tensor(290),G0tensor(295),G0tensor(300), &
    G0tensor(305),M2L1R1,[nMW],G0tensor(310))
  call TI_triangle_red(G2tensor(158),RedBasis(14),mass3set(:,6),G0tensor(315),G0tensor(320),G0tensor(325), &
    G0tensor(330),M2L1R1,[nMW],G0tensor(335))
  call TI_triangle_red(G2tensor(248),RedBasis(32),mass3set(:,6),G0tensor(340),G0tensor(345),G0tensor(350), &
    G0tensor(355),M2L1R1,[nMW],G0tensor(360))
  call TI_triangle_red(G2tensor(392),RedBasis(22),mass3set(:,6),G0tensor(365),G0tensor(370),G0tensor(375), &
    G0tensor(380),M2L1R1,[nMW],G0tensor(385))
  call TI_triangle_red(G2tensor(292),RedBasis(17),mass3set(:,1),G0tensor(390),G0tensor(395),G0tensor(400),G0tensor(405),M2L1R1)
  call TI_triangle_red(G2tensor(81),RedBasis(1),mass3set(:,1),G0tensor(410),G0tensor(415),G0tensor(420),G0tensor(425),M2L1R1)
  call TI_triangle_red(G2tensor(16),RedBasis(32),mass3set(:,1),G0tensor(430),G0tensor(435),G0tensor(440),G0tensor(445),M2L1R1)
  call TI_triangle_red(G2tensor(98),RedBasis(22),mass3set(:,1),G0tensor(450),G0tensor(455),G0tensor(460),G0tensor(465),M2L1R1)
  call TI_triangle_red(G2tensor(443),RedBasis(12),mass3set(:,1),G0tensor(470),G0tensor(1),G0tensor(2),G0tensor(3),M2L1R1)
  call TI_triangle_red(G2tensor(449),RedBasis(2),mass3set(:,1),G0tensor(4),G0tensor(5),G0tensor(6),G0tensor(7),M2L1R1)
  call TI_triangle_red(G3tensor(81),RedBasis(10),mass3set(:,1),G0tensor(8),G0tensor(9),G0tensor(475),G0tensor(480),M2L1R1)
  call TI_triangle_red(G2tensor(455),RedBasis(12),mass3set(:,4),G0tensor(485),G0tensor(490),G0tensor(495), &
    G0tensor(500),M2L1R1,[nMZ],G0tensor(505))
  call TI_triangle_red(G2tensor(461),RedBasis(2),mass3set(:,4),G0tensor(510),G0tensor(515),G0tensor(520), &
    G0tensor(46),M2L1R1,[nMZ],G0tensor(41))
  call TI_triangle_red(G2tensor(162),RedBasis(12),mass3set(:,5),G0tensor(56),G0tensor(51),G0tensor(491),G0tensor(66),M2L1R1,[nMW], &
    G0tensor(61))
  call TI_triangle_red(G2tensor(437),RedBasis(2),mass3set(:,5),G0tensor(131),G0tensor(102),G0tensor(76),G0tensor(71),M2L1R1,[nMW], &
    G0tensor(136))
  call TI_triangle_red(G3tensor(10),RedBasis(16),mass3set(:,1),G0tensor(112),G0tensor(86),G0tensor(81),G0tensor(141),M2L1R1)
  call TI_triangle_red(G2tensor(218),RedBasis(15),mass3set(:,1),G0tensor(122),G0tensor(96),G0tensor(91),G0tensor(252),M2L1R1)
  call TI_triangle_red(G2tensor(340),RedBasis(17),mass3set(:,7),G0tensor(247),G0tensor(106),G0tensor(101), &
    G0tensor(116),M2L1R1,[nMZ],G0tensor(111))
  call TI_triangle_red(G2tensor(404),RedBasis(15),mass3set(:,4),G0tensor(486),G0tensor(126),G0tensor(121), &
    G0tensor(176),M2L1R1,[nMZ],G0tensor(151))
  call TI_triangle_red(G2tensor(343),RedBasis(17),mass3set(:,8),G0tensor(146),G0tensor(42),G0tensor(181), &
    G0tensor(161),M2L1R1,[nMW],G0tensor(156))
  call TI_triangle_red(G2tensor(212),RedBasis(15),mass3set(:,5),G0tensor(52),G0tensor(186),G0tensor(171), &
    G0tensor(166),M2L1R1,[nMW],G0tensor(62))
  call TI_triangle_red(G2tensor(152),RedBasis(21),mass3set(:,1),G0tensor(466),G0tensor(196),G0tensor(191),G0tensor(487),M2L1R1)
  call TI_triangle_red(G2tensor(150),RedBasis(20),mass3set(:,1),G0tensor(471),G0tensor(206),G0tensor(201),G0tensor(211),M2L1R1)
  call TI_triangle_red(G2tensor(148),RedBasis(21),mass3set(:,4),G0tensor(26),G0tensor(21),G0tensor(492), &
    G0tensor(216),M2L1R1,[nMZ],G0tensor(36))
  call TI_triangle_red(G2tensor(149),RedBasis(20),mass3set(:,4),G0tensor(31),G0tensor(244),G0tensor(236), &
    G0tensor(224),M2L1R1,[nMZ],G0tensor(77))
  call TI_triangle_red(G2tensor(153),RedBasis(21),mass3set(:,5),G0tensor(414),G0tensor(384),G0tensor(239), &
    G0tensor(154),M2L1R1,[nMW],G0tensor(19))
  call TI_triangle_red(G2tensor(146),RedBasis(20),mass3set(:,5),G0tensor(14),G0tensor(221),G0tensor(72),G0tensor(11),M2L1R1,[nMW], &
    G0tensor(332))
  call TI_triangle_red(G2tensor(361),RedBasis(26),mass3set(:,1),G0tensor(241),G0tensor(132),G0tensor(16),G0tensor(411),M2L1R1)
  call TI_triangle_red(G2tensor(367),RedBasis(26),mass3set(:,7),G0tensor(179),G0tensor(47),G0tensor(284), &
    G0tensor(234),M2L1R1,[nMZ],G0tensor(48))
  call TI_triangle_red(G2tensor(77),RedBasis(1),mass3set(:,4),G0tensor(13),G0tensor(289),G0tensor(129),G0tensor(119),M2L1R1,[nMZ], &
    G0tensor(109))
  call TI_triangle_red(G2tensor(370),RedBasis(26),mass3set(:,8),G0tensor(69),G0tensor(59),G0tensor(49),G0tensor(421),M2L1R1,[nMW], &
    G0tensor(184))
  call TI_triangle_red(G2tensor(242),RedBasis(1),mass3set(:,5),G0tensor(57),G0tensor(294),G0tensor(58),G0tensor(431),M2L1R1,[nMW], &
    G0tensor(219))
  call TI_triangle_red(G2tensor(144),RedBasis(29),mass3set(:,9),G0tensor(189),G0tensor(67),G0tensor(299), &
    G0tensor(264),M2L1R1,[nMW],G0tensor(68))
  call TI_triangle_red(G2tensor(132),RedBasis(31),mass3set(:,9),G0tensor(28),G0tensor(349),G0tensor(304), &
    G0tensor(173),M2L1R1,[nMW],G0tensor(163))
  call TI_triangle_red(G2tensor(134),RedBasis(30),mass3set(:,5),G0tensor(153),G0tensor(98),G0tensor(88),G0tensor(78),M2L1R1,[nMW], &
    G0tensor(484))
  call TI_triangle_red(G2tensor(431),RedBasis(4),mass3set(:,9),G0tensor(479),G0tensor(354),G0tensor(309), &
    G0tensor(79),M2L1R1,[nMW],G0tensor(359))
  call TI_triangle_red(G2tensor(140),RedBasis(8),mass3set(:,9),G0tensor(314),G0tensor(87),G0tensor(364), &
    G0tensor(319),M2L1R1,[nMW],G0tensor(89))
  call TI_triangle_red(G2tensor(142),RedBasis(7),mass3set(:,5),G0tensor(369),G0tensor(324),G0tensor(97), &
    G0tensor(374),M2L1R1,[nMW],G0tensor(329))
  call TI_triangle_red(G2tensor(416),RedBasis(4),mass3set(:,1),G0tensor(209),G0tensor(199),G0tensor(99),G0tensor(351),M2L1R1)
  call TI_triangle_red(G2tensor(413),RedBasis(8),mass3set(:,1),G0tensor(134),G0tensor(107),G0tensor(483),G0tensor(334),M2L1R1)
  call TI_triangle_red(G2tensor(10),RedBasis(7),mass3set(:,1),G0tensor(108),G0tensor(361),G0tensor(139),G0tensor(117),M2L1R1)
  call TI_triangle_red(G3tensor(16),RedBasis(16),mass3set(:,10),G0tensor(339),G0tensor(118),G0tensor(371), &
    G0tensor(204),M2L1R1,[nMT],G0tensor(144))
  call TI_triangle_red(G3tensor(18),RedBasis(16),mass3set(:,11),G0tensor(127),G0tensor(344),G0tensor(198), &
    G0tensor(128),M2L1R1,[nMB],G0tensor(409))
  call TI_triangle_red(G3tensor(82),RedBasis(10),mass3set(:,10),G0tensor(379),G0tensor(152),G0tensor(419), &
    G0tensor(389),M2L1R1,[nMT],G0tensor(162))
  call TI_triangle_red(G3tensor(84),RedBasis(10),mass3set(:,11),G0tensor(424),G0tensor(394),G0tensor(164), &
    G0tensor(429),M2L1R1,[nMB],G0tensor(399))
  call TI_triangle_red(G3tensor(55),RedBasis(56),mass3set(:,1),G0tensor(172),G0tensor(434),G0tensor(404),G0tensor(269),M2L1R1)
  call TI_triangle_red(G2tensor(183),RedBasis(59),mass3set(:,1),G0tensor(174),G0tensor(39),G0tensor(29),G0tensor(439),M2L1R1)
  call TI_triangle_red(G2tensor(189),RedBasis(59),mass3set(:,4),G0tensor(197),G0tensor(444),G0tensor(207), &
    G0tensor(449),M2L1R1,[nMZ],G0tensor(208))
  call TI_triangle_red(G2tensor(268),RedBasis(59),mass3set(:,5),G0tensor(454),G0tensor(259),G0tensor(27), &
    G0tensor(459),M2L1R1,[nMW],G0tensor(274))
  call TI_triangle_red(G2tensor(234),RedBasis(63),mass3set(:,1),G0tensor(37),G0tensor(464),G0tensor(279),G0tensor(38),M2L1R1)
  call TI_triangle_red(G2tensor(240),RedBasis(63),mass3set(:,4),G0tensor(229),G0tensor(12),G0tensor(249), &
    G0tensor(17),M2L1R1,[nMZ],G0tensor(254))
  call TI_triangle_red(G2tensor(274),RedBasis(63),mass3set(:,5),G0tensor(18),G0tensor(509),G0tensor(499), &
    G0tensor(514),M2L1R1,[nMW],G0tensor(504))
  call TI_triangle_red(G2tensor(286),RedBasis(17),mass3set(:,6),G0tensor(519),G0tensor(524),G0tensor(286), &
    G0tensor(124),M2L1R1,[nMW],G0tensor(114))
  call TI_triangle_red(G3tensor(94),RedBasis(19),mass3set(:,12),G0tensor(104),G0tensor(64),G0tensor(54),G0tensor(44),M2L1R1,[nMW], &
    G0tensor(306))
  call TI_triangle_red(G2tensor(167),RedBasis(18),mass3set(:,6),G0tensor(74),G0tensor(316),G0tensor(84), &
    G0tensor(326),M2L1R1,[nMW],G0tensor(194))
  call TI_triangle_red(G2tensor(407),RedBasis(25),mass3set(:,12),G0tensor(94),G0tensor(381),G0tensor(149), &
    G0tensor(391),M2L1R1,[nMW],G0tensor(159))
  call TI_triangle_red(G2tensor(133),RedBasis(24),mass3set(:,6),G0tensor(401),G0tensor(214),G0tensor(169), &
    G0tensor(266),M2L1R1,[nMW],G0tensor(34))
  call TI_triangle_red(G2tensor(21),RedBasis(57),mass3set(:,1),G0tensor(24),G0tensor(467),G0tensor(256),G0tensor(22),M2L1R1)
  call TI_triangle_red(G2tensor(25),RedBasis(57),mass3set(:,4),G0tensor(493),G0tensor(261),G0tensor(23), &
    G0tensor(472),M2L1R1,[nMZ],G0tensor(271))
  call TI_triangle_red(G2tensor(29),RedBasis(57),mass3set(:,5),G0tensor(32),G0tensor(276),G0tensor(33),G0tensor(281),M2L1R1,[nMW], &
    G0tensor(43))
  call TI_triangle_red(G3tensor(29),RedBasis(60),mass3set(:,1),G0tensor(291),G0tensor(53),G0tensor(296),G0tensor(213),M2L1R1)
  call TI_triangle_red(G2tensor(32),RedBasis(32),mass3set(:,7),G0tensor(63),G0tensor(301),G0tensor(168), &
    G0tensor(158),M2L1R1,[nMZ],G0tensor(148))
  call TI_triangle_red(G2tensor(36),RedBasis(32),mass3set(:,8),G0tensor(93),G0tensor(83),G0tensor(73),G0tensor(311),M2L1R1,[nMW], &
    G0tensor(82))
  call TI_triangle_red(G2tensor(41),RedBasis(61),mass3set(:,1),G0tensor(447),G0tensor(442),G0tensor(321),G0tensor(92),M2L1R1)
  call TI_triangle_red(G2tensor(45),RedBasis(61),mass3set(:,4),G0tensor(331),G0tensor(103),G0tensor(336), &
    G0tensor(113),M2L1R1,[nMZ],G0tensor(341))
  call TI_triangle_red(G2tensor(52),RedBasis(61),mass3set(:,5),G0tensor(193),G0tensor(123),G0tensor(346), &
    G0tensor(287),M2L1R1,[nMW],G0tensor(188))
  call TI_triangle_red(G3tensor(34),RedBasis(13),mass3set(:,1),G0tensor(183),G0tensor(178),G0tensor(143),G0tensor(138),M2L1R1)
  call TI_triangle_red(G2tensor(56),RedBasis(22),mass3set(:,7),G0tensor(133),G0tensor(356),G0tensor(337), &
    G0tensor(137),M2L1R1,[nMZ],G0tensor(437))
  call TI_triangle_red(G2tensor(61),RedBasis(22),mass3set(:,8),G0tensor(366),G0tensor(342),G0tensor(142), &
    G0tensor(481),M2L1R1,[nMW],G0tensor(376))
  call TI_triangle_red(G2tensor(12),RedBasis(33),mass3set(:,1),G0tensor(147),G0tensor(386),G0tensor(157),G0tensor(462),M2L1R1)
  call TI_triangle_red(G2tensor(68),RedBasis(33),mass3set(:,7),G0tensor(457),G0tensor(396),G0tensor(167), &
    G0tensor(476),M2L1R1,[nMZ],G0tensor(406))
  call TI_triangle_red(G2tensor(72),RedBasis(33),mass3set(:,8),G0tensor(282),G0tensor(177),G0tensor(416), &
    G0tensor(292),M2L1R1,[nMW],G0tensor(182))
  call TI_triangle_red(G2tensor(7),RedBasis(14),mass3set(:,1),G0tensor(452),G0tensor(426),G0tensor(297),G0tensor(187),M2L1R1)
  call TI_triangle_red(G2tensor(84),RedBasis(14),mass3set(:,7),G0tensor(436),G0tensor(192),G0tensor(441), &
    G0tensor(202),M2L1R1,[nMZ],G0tensor(446))
  call TI_triangle_red(G2tensor(88),RedBasis(14),mass3set(:,8),G0tensor(203),G0tensor(451),G0tensor(277), &
    G0tensor(272),M2L1R1,[nMW],G0tensor(212))
  call TI_triangle_red(G2tensor(92),RedBasis(64),mass3set(:,9),G0tensor(456),G0tensor(262),G0tensor(257), &
    G0tensor(217),M2L1R1,[nMW],G0tensor(461))
  call TI_triangle_red(G2tensor(97),RedBasis(66),mass3set(:,9),G0tensor(218),G0tensor(489),G0tensor(474), &
    G0tensor(469),M2L1R1,[nMW],G0tensor(494))
  call TI_triangle_red(G2tensor(200),RedBasis(65),mass3set(:,5),G0tensor(517),G0tensor(496),G0tensor(522), &
    G0tensor(501),M2L1R1,[nMW],G0tensor(506))
  call TI_triangle_red(G2tensor(176),RedBasis(9),mass3set(:,9),G0tensor(511),G0tensor(516),G0tensor(521), &
    G0tensor(397),M2L1R1,[nMW],G0tensor(387))
  call TI_triangle_red(G2tensor(314),RedBasis(6),mass3set(:,9),G0tensor(377),G0tensor(322),G0tensor(312), &
    G0tensor(302),M2L1R1,[nMW],G0tensor(226))
  call TI_triangle_red(G2tensor(335),RedBasis(67),mass3set(:,5),G0tensor(222),G0tensor(307),G0tensor(231), &
    G0tensor(223),M2L1R1,[nMW],G0tensor(232))
  call TI_triangle_red(G2tensor(73),RedBasis(4),mass3set(:,3),G0tensor(227),G0tensor(248),G0tensor(237), &
    G0tensor(228),M2L1R1,[nMW],G0tensor(253))
  call TI_triangle_red(G2tensor(427),RedBasis(26),mass3set(:,6),G0tensor(238),G0tensor(233),G0tensor(427), &
    G0tensor(417),M2L1R1,[nMW],G0tensor(407))
  call TI_triangle_red(G2tensor(401),RedBasis(29),mass3set(:,3),G0tensor(367),G0tensor(357),G0tensor(347), &
    G0tensor(246),M2L1R1,[nMW],G0tensor(242))
  call TI_triangle_red(G3tensor(39),RedBasis(13),mass3set(:,10),G0tensor(352),G0tensor(251),G0tensor(243), &
    G0tensor(273),M2L1R1,[nMT],G0tensor(267))
  call TI_triangle_red(G3tensor(43),RedBasis(13),mass3set(:,11),G0tensor(258),G0tensor(278),G0tensor(268), &
    G0tensor(263),M2L1R1,[nMB],G0tensor(403))
  call TI_triangle_red(G3tensor(47),RedBasis(60),mass3set(:,10),G0tensor(393),G0tensor(383),G0tensor(343), &
    G0tensor(338),M2L1R1,[nMT],G0tensor(333))
  call TI_triangle_red(G3tensor(51),RedBasis(60),mass3set(:,11),G0tensor(328),G0tensor(318),G0tensor(308), &
    G0tensor(303),M2L1R1,[nMB],G0tensor(298))
  call TI_triangle_red(G3tensor(56),RedBasis(56),mass3set(:,10),G0tensor(293),G0tensor(288),G0tensor(283), &
    G0tensor(317),M2L1R1,[nMT],G0tensor(313))
  call TI_triangle_red(G3tensor(58),RedBasis(56),mass3set(:,11),G0tensor(438),G0tensor(327),G0tensor(323), &
    G0tensor(463),M2L1R1,[nMB],G0tensor(448))
  call TI_triangle_red(G3tensor(62),RedBasis(19),mass3set(:,1),G0tensor(433),G0tensor(423),G0tensor(413),G0tensor(373),M2L1R1)
  call TI_triangle_red(G2tensor(6),RedBasis(18),mass3set(:,1),G0tensor(363),G0tensor(353),G0tensor(348),G0tensor(362),M2L1R1)
  call TI_triangle_red(G2tensor(164),RedBasis(6),mass3set(:,1),G0tensor(358),G0tensor(443),G0tensor(372),G0tensor(368),M2L1R1)
  call TI_triangle_red(G2tensor(2),RedBasis(5),mass3set(:,1),G0tensor(382),G0tensor(378),G0tensor(392),G0tensor(388),M2L1R1)
  call TI_triangle_red(G2tensor(4),RedBasis(3),mass3set(:,1),G0tensor(453),G0tensor(402),G0tensor(398),G0tensor(412),M2L1R1)
  call TI_triangle_red(G3tensor(63),RedBasis(25),mass3set(:,1),G0tensor(408),G0tensor(422),G0tensor(418),G0tensor(458),M2L1R1)
  call TI_triangle_red(G2tensor(93),RedBasis(24),mass3set(:,1),G0tensor(432),G0tensor(428),G0tensor(488),G0tensor(468),M2L1R1)
  call TI_triangle_red(G2tensor(347),RedBasis(5),mass3set(:,9),G0tensor(473),G0tensor(477),G0tensor(478), &
    G0tensor(482),M2L1R1,[nMW],G0tensor(497))
  call TI_triangle_red(G2tensor(323),RedBasis(3),mass3set(:,5),G0tensor(498),G0tensor(502),G0tensor(503), &
    G0tensor(507),M2L1R1,[nMW],G0tensor(518))
  call TI_triangle_red(G3tensor(31),RedBasis(11),mass3set(:,1),G0tensor(508),G0tensor(512),G0tensor(523),G0tensor(513),M2L1R1)
  call TI_triangle_red(G2tensor(33),RedBasis(18),mass3set(:,7),G0tensor(525),G0tensor(526),G0tensor(527), &
    G0tensor(528),M2L1R1,[nMZ],G0tensor(529))
  call TI_triangle_red(G2tensor(37),RedBasis(18),mass3set(:,8),G0tensor(530),G0tensor(531),G0tensor(532), &
    G0tensor(533),M2L1R1,[nMW],G0tensor(534))
  call TI_triangle_red(G3tensor(33),RedBasis(23),mass3set(:,1),G0tensor(535),G0tensor(536),G0tensor(537),G0tensor(538),M2L1R1)
  call TI_triangle_red(G2tensor(60),RedBasis(24),mass3set(:,7),G0tensor(539),G0tensor(540),G0tensor(541), &
    G0tensor(542),M2L1R1,[nMZ],G0tensor(543))
  call TI_triangle_red(G2tensor(64),RedBasis(24),mass3set(:,8),G0tensor(544),G0tensor(545),G0tensor(546), &
    G0tensor(547),M2L1R1,[nMW],G0tensor(548))
  call TI_triangle_red(G2tensor(65),RedBasis(27),mass3set(:,1),G0tensor(549),G0tensor(550),G0tensor(551),G0tensor(552),M2L1R1)
  call TI_triangle_red(G2tensor(69),RedBasis(27),mass3set(:,7),G0tensor(553),G0tensor(554),G0tensor(555), &
    G0tensor(556),M2L1R1,[nMZ],G0tensor(557))
  call TI_triangle_red(G2tensor(76),RedBasis(27),mass3set(:,8),G0tensor(558),G0tensor(559),G0tensor(560), &
    G0tensor(561),M2L1R1,[nMW],G0tensor(562))
  call TI_triangle_red(G2tensor(80),RedBasis(28),mass3set(:,1),G0tensor(563),G0tensor(564),G0tensor(565),G0tensor(566),M2L1R1)
  call TI_triangle_red(G2tensor(85),RedBasis(28),mass3set(:,7),G0tensor(567),G0tensor(568),G0tensor(569), &
    G0tensor(570),M2L1R1,[nMZ],G0tensor(571))
  call TI_triangle_red(G2tensor(89),RedBasis(28),mass3set(:,8),G0tensor(572),G0tensor(573),G0tensor(574), &
    G0tensor(575),M2L1R1,[nMW],G0tensor(576))
  call TI_triangle_red(G2tensor(275),RedBasis(27),mass3set(:,6),G0tensor(577),G0tensor(578),G0tensor(579), &
    G0tensor(580),M2L1R1,[nMW],G0tensor(581))
  call TI_triangle_red(G2tensor(284),RedBasis(28),mass3set(:,6),G0tensor(582),G0tensor(583),G0tensor(584), &
    G0tensor(585),M2L1R1,[nMW],G0tensor(586))
  call TI_triangle_red(G2tensor(170),RedBasis(31),mass3set(:,1),G0tensor(587),G0tensor(588),G0tensor(589),G0tensor(590),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(30),mass3set(:,1),G0tensor(591),G0tensor(592),G0tensor(593),G0tensor(594),M2L1R1)
  call TI_triangle_red(G2tensor(173),RedBasis(29),mass3set(:,1),G0tensor(595),G0tensor(596),G0tensor(597),G0tensor(598),M2L1R1)
  call TI_triangle_red(G3tensor(66),RedBasis(25),mass3set(:,10),G0tensor(599),G0tensor(600),G0tensor(601), &
    G0tensor(602),M2L1R1,[nMT],G0tensor(603))
  call TI_triangle_red(G3tensor(40),RedBasis(23),mass3set(:,10),G0tensor(604),G0tensor(605),G0tensor(606), &
    G0tensor(607),M2L1R1,[nMT],G0tensor(608))
  call TI_triangle_red(G3tensor(68),RedBasis(25),mass3set(:,11),G0tensor(609),G0tensor(610),G0tensor(611), &
    G0tensor(612),M2L1R1,[nMB],G0tensor(613))
  call TI_triangle_red(G3tensor(44),RedBasis(23),mass3set(:,11),G0tensor(614),G0tensor(615),G0tensor(616), &
    G0tensor(617),M2L1R1,[nMB],G0tensor(618))
  call TI_triangle_red(G3tensor(70),RedBasis(19),mass3set(:,10),G0tensor(619),G0tensor(620),G0tensor(621), &
    G0tensor(622),M2L1R1,[nMT],G0tensor(623))
  call TI_triangle_red(G3tensor(48),RedBasis(11),mass3set(:,10),G0tensor(624),G0tensor(625),G0tensor(626), &
    G0tensor(627),M2L1R1,[nMT],G0tensor(628))
  call TI_triangle_red(G3tensor(72),RedBasis(19),mass3set(:,11),G0tensor(629),G0tensor(630),G0tensor(631), &
    G0tensor(632),M2L1R1,[nMB],G0tensor(633))
  call TI_triangle_red(G3tensor(52),RedBasis(11),mass3set(:,11),G0tensor(634),G0tensor(635),G0tensor(636), &
    G0tensor(637),M2L1R1,[nMB],G0tensor(638))
  call TI_triangle_red(G2tensor(203),RedBasis(29),mass3set(:,2),G0tensor(639),G0tensor(640),G0tensor(641), &
    G0tensor(642),M2L1R1,[nMZ],G0tensor(643))
  call TI_triangle_red(G2tensor(230),RedBasis(4),mass3set(:,2),G0tensor(644),G0tensor(645),G0tensor(646), &
    G0tensor(647),M2L1R1,[nMZ],G0tensor(648))
  call TI_triangle_red(G3tensor(88),RedBasis(19),mass3set(:,13),G0tensor(649),G0tensor(650),G0tensor(651), &
    G0tensor(652),M2L1R1,[nME],G0tensor(653))
  call TI_triangle_red(G3tensor(89),RedBasis(19),mass3set(:,14),G0tensor(654),G0tensor(655),G0tensor(656), &
    G0tensor(657),M2L1R1,[nMM],G0tensor(658))
  call TI_triangle_red(G3tensor(90),RedBasis(19),mass3set(:,15),G0tensor(659),G0tensor(660),G0tensor(661), &
    G0tensor(662),M2L1R1,[nML],G0tensor(663))
  call ol_merge_tensors(T0sum(113),[G0tensor(10)])
  call ol_merge_tensors(T0sum(114),[G0tensor(30)])
  call ol_merge_tensors(T0sum(115),[G0tensor(55)])
  call ol_merge_tensors(T0sum(116),[G0tensor(80)])
  call ol_merge_tensors(T0sum(117),[G0tensor(100)])
  call ol_merge_tensors(T0sum(118),[G0tensor(125)])
  call ol_merge_tensors(T0sum(119),[G0tensor(150)])
  call ol_merge_tensors(T0sum(120),[G0tensor(170)])
  call ol_merge_tensors(T0sum(121),[G0tensor(195)])
  call ol_merge_tensors(T0sum(122),[G0tensor(220)])
  call ol_merge_tensors(T0sum(123),[G0tensor(240)])
  call ol_merge_tensors(T0sum(124),[G0tensor(265)])
  call ol_merge_tensors(T0sum(125),[G0tensor(290)])
  call ol_merge_tensors(T0sum(126),[G0tensor(315)])
  call ol_merge_tensors(T0sum(127),[G0tensor(340)])
  call ol_merge_tensors(T0sum(128),[G0tensor(365)])
  call ol_merge_tensors(T0sum(129),[G0tensor(390)])
  call ol_merge_tensors(T0sum(130),[G0tensor(410)])
  call ol_merge_tensors(T0sum(131),[G0tensor(430)])
  call ol_merge_tensors(T0sum(132),[G0tensor(450)])
  call ol_merge_tensors(T0sum(133),[G0tensor(470)])
  call ol_merge_tensors(T0sum(134),[G0tensor(4)])
  call ol_merge_tensors(T0sum(135),[G0tensor(8)])
  call ol_merge_tensors(T0sum(136),[G0tensor(485)])
  call ol_merge_tensors(T0sum(137),[G0tensor(510)])
  call ol_merge_tensors(T0sum(138),[G0tensor(56)])
  call ol_merge_tensors(T0sum(139),[G0tensor(131)])
  call ol_merge_tensors(T0sum(140),[G0tensor(112)])
  call ol_merge_tensors(T0sum(141),[G0tensor(122)])
  call ol_merge_tensors(T0sum(142),[G0tensor(247)])
  call ol_merge_tensors(T0sum(143),[G0tensor(486)])
  call ol_merge_tensors(T0sum(144),[G0tensor(146)])
  call ol_merge_tensors(T0sum(145),[G0tensor(52)])
  call ol_merge_tensors(T0sum(146),[G0tensor(466)])
  call ol_merge_tensors(T0sum(147),[G0tensor(471)])
  call ol_merge_tensors(T0sum(148),[G0tensor(26)])
  call ol_merge_tensors(T0sum(149),[G0tensor(31)])
  call ol_merge_tensors(T0sum(150),[G0tensor(414)])
  call ol_merge_tensors(T0sum(151),[G0tensor(14)])
  call ol_merge_tensors(T0sum(152),[G0tensor(241)])
  call ol_merge_tensors(T0sum(153),[G0tensor(179)])
  call ol_merge_tensors(T0sum(154),[G0tensor(13)])
  call ol_merge_tensors(T0sum(155),[G0tensor(69)])
  call ol_merge_tensors(T0sum(156),[G0tensor(57)])
  call ol_merge_tensors(T0sum(157),[G0tensor(189)])
  call ol_merge_tensors(T0sum(158),[G0tensor(28)])
  call ol_merge_tensors(T0sum(159),[G0tensor(153)])
  call ol_merge_tensors(T0sum(160),[G0tensor(479)])
  call ol_merge_tensors(T0sum(161),[G0tensor(314)])
  call ol_merge_tensors(T0sum(162),[G0tensor(369)])
  call ol_merge_tensors(T0sum(163),[G0tensor(209)])
  call ol_merge_tensors(T0sum(164),[G0tensor(134)])
  call ol_merge_tensors(T0sum(165),[G0tensor(108)])
  call ol_merge_tensors(T0sum(166),[G0tensor(339)])
  call ol_merge_tensors(T0sum(167),[G0tensor(127)])
  call ol_merge_tensors(T0sum(168),[G0tensor(379)])
  call ol_merge_tensors(T0sum(169),[G0tensor(424)])
  call ol_merge_tensors(T0sum(170),[G0tensor(172)])
  call ol_merge_tensors(T0sum(171),[G0tensor(174)])
  call ol_merge_tensors(T0sum(172),[G0tensor(197)])
  call ol_merge_tensors(T0sum(173),[G0tensor(454)])
  call ol_merge_tensors(T0sum(174),[G0tensor(37)])
  call ol_merge_tensors(T0sum(175),[G0tensor(229)])
  call ol_merge_tensors(T0sum(176),[G0tensor(18)])
  call ol_merge_tensors(T0sum(177),[G0tensor(519)])
  call ol_merge_tensors(T0sum(178),[G0tensor(104)])
  call ol_merge_tensors(T0sum(179),[G0tensor(74)])
  call ol_merge_tensors(T0sum(180),[G0tensor(94)])
  call ol_merge_tensors(T0sum(181),[G0tensor(401)])
  call ol_merge_tensors(T0sum(182),[G0tensor(24)])
  call ol_merge_tensors(T0sum(183),[G0tensor(493)])
  call ol_merge_tensors(T0sum(184),[G0tensor(32)])
  call ol_merge_tensors(T0sum(185),[G0tensor(291)])
  call ol_merge_tensors(T0sum(186),[G0tensor(63)])
  call ol_merge_tensors(T0sum(187),[G0tensor(93)])
  call ol_merge_tensors(T0sum(188),[G0tensor(447)])
  call ol_merge_tensors(T0sum(189),[G0tensor(331)])
  call ol_merge_tensors(T0sum(190),[G0tensor(193)])
  call ol_merge_tensors(T0sum(191),[G0tensor(183)])
  call ol_merge_tensors(T0sum(192),[G0tensor(133)])
  call ol_merge_tensors(T0sum(193),[G0tensor(366)])
  call ol_merge_tensors(T0sum(194),[G0tensor(147)])
  call ol_merge_tensors(T0sum(195),[G0tensor(457)])
  call ol_merge_tensors(T0sum(196),[G0tensor(282)])
  call ol_merge_tensors(T0sum(197),[G0tensor(452)])
  call ol_merge_tensors(T0sum(198),[G0tensor(436)])
  call ol_merge_tensors(T0sum(199),[G0tensor(203)])
  call ol_merge_tensors(T0sum(200),[G0tensor(456)])
  call ol_merge_tensors(T0sum(201),[G0tensor(218)])
  call ol_merge_tensors(T0sum(202),[G0tensor(517)])
  call ol_merge_tensors(T0sum(203),[G0tensor(511)])
  call ol_merge_tensors(T0sum(204),[G0tensor(377)])
  call ol_merge_tensors(T0sum(205),[G0tensor(222)])
  call ol_merge_tensors(T0sum(206),[G0tensor(227)])
  call ol_merge_tensors(T0sum(207),[G0tensor(238)])
  call ol_merge_tensors(T0sum(208),[G0tensor(367)])
  call ol_merge_tensors(T0sum(209),[G0tensor(352)])
  call ol_merge_tensors(T0sum(210),[G0tensor(258)])
  call ol_merge_tensors(T0sum(211),[G0tensor(393)])
  call ol_merge_tensors(T0sum(212),[G0tensor(328)])
  call ol_merge_tensors(T0sum(213),[G0tensor(293)])
  call ol_merge_tensors(T0sum(214),[G0tensor(438)])
  call ol_merge_tensors(T0sum(215),[G0tensor(433)])
  call ol_merge_tensors(T0sum(216),[G0tensor(363)])
  call ol_merge_tensors(T0sum(217),[G0tensor(358)])
  call ol_merge_tensors(T0sum(218),[G0tensor(382)])
  call ol_merge_tensors(T0sum(219),[G0tensor(453)])
  call ol_merge_tensors(T0sum(220),[G0tensor(408)])
  call ol_merge_tensors(T0sum(221),[G0tensor(432)])
  call ol_merge_tensors(T0sum(222),[G0tensor(473)])
  call ol_merge_tensors(T0sum(223),[G0tensor(498)])
  call ol_merge_tensors(T0sum(224),[G0tensor(508)])
  call ol_merge_tensors(T0sum(225),[G0tensor(525)])
  call ol_merge_tensors(T0sum(226),[G0tensor(530)])
  call ol_merge_tensors(T0sum(227),[G0tensor(535)])
  call ol_merge_tensors(T0sum(228),[G0tensor(539)])
  call ol_merge_tensors(T0sum(229),[G0tensor(544)])
  call ol_merge_tensors(T0sum(230),[G0tensor(549)])
  call ol_merge_tensors(T0sum(231),[G0tensor(553)])
  call ol_merge_tensors(T0sum(232),[G0tensor(558)])
  call ol_merge_tensors(T0sum(233),[G0tensor(563)])
  call ol_merge_tensors(T0sum(234),[G0tensor(567)])
  call ol_merge_tensors(T0sum(235),[G0tensor(572)])
  call ol_merge_tensors(T0sum(236),[G0tensor(577)])
  call ol_merge_tensors(T0sum(237),[G0tensor(582)])
  call ol_merge_tensors(T1sum(27),[G1tensor(467)])
  call ol_merge_tensors(T1sum(28),[G1tensor(468)])
  call ol_merge_tensors(T1sum(29),[G1tensor(493)])
  call ol_merge_tensors(T1sum(30),[G1tensor(474)])
  call ol_merge_tensors(T1sum(31),[G1tensor(492)])
  call ol_merge_tensors(T1sum(32),[G1tensor(472)])
  call ol_merge_tensors(T1sum(33),[G1tensor(473)])
  call ol_merge_tensors(T1sum(34),[G1tensor(496)])
  call ol_merge_tensors(T1sum(35),[G1tensor(476)])
  call ol_merge_tensors(T1sum(36),[G1tensor(477)])
  call ol_merge_tensors(T1sum(37),[G1tensor(486)])
  call ol_merge_tensors(T1sum(38),[G1tensor(500)])
  call ol_merge_tensors(T1sum(39),[G1tensor(480)])
  call ol_merge_tensors(T1sum(40),[G1tensor(481)])
  call ol_merge_tensors(T1sum(41),[G1tensor(490)])
  call ol_merge_tensors(T1sum(42),[G1tensor(483)])
  call ol_merge_tensors(T1sum(43),[G1tensor(484)])
  call ol_merge_tensors(T1sum(44),[G1tensor(497)])
  call ol_merge_tensors(T1sum(45),[G1tensor(487)])
  call ol_merge_tensors(T1sum(46),[G1tensor(488)])
  call ol_merge_tensors(T1sum(47),[G1tensor(501)])
  call ol_merge_tensors(T1sum(48),[G1tensor(491)])
  call ol_merge_tensors(T1sum(49),[G1tensor(494)])
  call ol_merge_tensors(T1sum(50),[G1tensor(495)])
  call ol_merge_tensors(T1sum(51),[G1tensor(498)])
  call ol_merge_tensors(T1sum(52),[G1tensor(499)])
  call ol_merge_tensors(T1sum(53),[G1tensor(502)])
  call ol_merge_tensors(T0sum(238),[G0tensor(587)])
  call ol_merge_tensors(T0sum(239),[G0tensor(591)])
  call ol_merge_tensors(T0sum(240),[G0tensor(595)])
  call ol_merge_tensors(T0sum(241),[G0tensor(599)])
  call ol_merge_tensors(T0sum(242),[G0tensor(604)])
  call ol_merge_tensors(T0sum(243),[G0tensor(609)])
  call ol_merge_tensors(T0sum(244),[G0tensor(614)])
  call ol_merge_tensors(T0sum(245),[G0tensor(619)])
  call ol_merge_tensors(T0sum(246),[G0tensor(624)])
  call ol_merge_tensors(T0sum(247),[G0tensor(629)])
  call ol_merge_tensors(T0sum(248),[G0tensor(634)])
  call ol_merge_tensors(T0sum(249),[G0tensor(639)])
  call ol_merge_tensors(T0sum(250),[G0tensor(644)])
  call ol_merge_tensors(T0sum(251),[G0tensor(649)])
  call ol_merge_tensors(T0sum(252),[G0tensor(654)])
  call ol_merge_tensors(T0sum(253),[G0tensor(659)])
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(388),h0tab(:,388),[27,4],[nMW,nMW],3,1,wf8(:,19))
  call Hloop_SVV_S(ntryL,G0H48(1),ex4(:),wf8(:,19),G0H2(1),m4h3x8x2(:,1),heltab3x48(:,:,1))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(389),h0tab(:,389),[27,4],[nMW,nMW],3,1,wf8(:,20))
  call Hloop_SVV_S(ntryL,G0H48(1),ex4(:),wf8(:,20),G0H2(2),m4h3x8x2(:,2),heltab3x48(:,:,2))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(390),h0tab(:,390),[27,4],[nMW,nMW],3,1,wf8(:,19))
  call Hloop_VWW_V(ntryL,G0H48(1),ex4(:),wf8(:,19),G0H2(3),m4h3x8x2(:,3),heltab3x48(:,:,3))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(391),h0tab(:,391),[27,4],[nMW,nMW],3,1,wf8(:,20))
  call Hloop_VWW_V(ntryL,G0H48(1),ex4(:),wf8(:,20),G0H2(4),m4h3x8x2(:,4),heltab3x48(:,:,4))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(392),h0tab(:,392),[27,4],[nMW,nMW],3,1,wf8(:,21))
  call Hloop_SVV_S(ntryL,G0H48(1),ex4(:),wf8(:,21),G0H2(5),m4h3x8x2(:,5),heltab3x48(:,:,5))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(393),h0tab(:,393),[27,4],[nMW,nMW],3,1,wf8(:,22))
  call Hloop_SVV_S(ntryL,G0H48(1),ex4(:),wf8(:,22),G0H2(6),m4h3x8x2(:,6),heltab3x48(:,:,6))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(394),h0tab(:,394),[27,4],[nMW,nMW],3,1,wf8(:,21))
  call Hloop_VWW_V(ntryL,G0H48(1),ex4(:),wf8(:,21),G0H2(7),m4h3x8x2(:,7),heltab3x48(:,:,7))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(395),h0tab(:,395),[27,4],[nMW,nMW],3,1,wf8(:,22))
  call Hloop_VWW_V(ntryL,G0H48(1),ex4(:),wf8(:,22),G0H2(8),m4h3x8x2(:,8),heltab3x48(:,:,8))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(396),h0tab(:,396),[23,8],[nMW,nMW],3,1,wf8(:,19))
  call Hloop_SVV_S(ntryL,G0H48(1),ex3(:),wf8(:,19),G0H3(3),m4h2x8x3(:,1),heltab3x48(:,:,9))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(397),h0tab(:,397),[23,8],[nMW,nMW],3,1,wf8(:,20))
  call Hloop_SVV_S(ntryL,G0H48(1),ex3(:),wf8(:,20),G0H3(4),m4h2x8x3(:,2),heltab3x48(:,:,10))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(398),h0tab(:,398),[23,8],[nMW,nMW],3,1,wf8(:,19))
  call Hloop_VWW_V(ntryL,G0H48(1),ex3(:),wf8(:,19),G0H3(1),m4h2x8x3(:,3),heltab3x48(:,:,11))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(399),h0tab(:,399),[23,8],[nMW,nMW],3,1,wf8(:,20))
  call Hloop_VWW_V(ntryL,G0H48(1),ex3(:),wf8(:,20),G0H3(2),m4h2x8x3(:,4),heltab3x48(:,:,12))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(400),h0tab(:,400),[23,8],[nMW,nMW],3,1,wf8(:,21))
  call Hloop_SVV_S(ntryL,G0H48(1),ex3(:),wf8(:,21),G0H3(5),m4h2x8x3(:,5),heltab3x48(:,:,13))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(401),h0tab(:,401),[23,8],[nMW,nMW],3,1,wf8(:,22))
  call Hloop_SVV_S(ntryL,G0H48(1),ex3(:),wf8(:,22),G0H3(6),m4h2x8x3(:,6),heltab3x48(:,:,14))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(402),h0tab(:,402),[23,8],[nMW,nMW],3,1,wf8(:,21))
  call Hloop_VWW_V(ntryL,G0H48(1),ex3(:),wf8(:,21),G0H3(7),m4h2x8x3(:,7),heltab3x48(:,:,15))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(403),h0tab(:,403),[23,8],[nMW,nMW],3,1,wf8(:,22))
  call Hloop_VWW_V(ntryL,G0H48(1),ex3(:),wf8(:,22),G0H3(8),m4h2x8x3(:,8),heltab3x48(:,:,16))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(404),h0tab(:,404),[19,12],[nMW,nMW],3,1,wf8(:,19))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(119),m3h8x6(:,157),heltab2x48(:,:,388))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(405),h0tab(:,405),[19,12],[nMW,nMW],3,1,wf8(:,20))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(132),m3h8x6(:,158),heltab2x48(:,:,389))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(406),h0tab(:,406),[19,12],[nMW,nMW],3,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,19),19,G1H6(100),m3h8x6(:,159),heltab2x48(:,:,390))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(407),h0tab(:,407),[19,12],[nMW,nMW],3,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,20),19,G1H6(74),m3h8x6(:,160),heltab2x48(:,:,391))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(408),h0tab(:,408),[19,12],[nMW,nMW],3,1,wf8(:,21))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(13),m3h8x6(:,161),heltab2x48(:,:,392))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(409),h0tab(:,409),[19,12],[nMW,nMW],3,1,wf8(:,22))
  call Hloop_TV_S(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(64),m3h8x6(:,162),heltab2x48(:,:,393))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(410),h0tab(:,410),[19,12],[nMW,nMW],3,1,wf8(:,21))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,21),19,G1H6(104),m3h8x6(:,163),heltab2x48(:,:,394))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(411),h0tab(:,411),[19,12],[nMW,nMW],3,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf8(:,22),19,G1H6(77),m3h8x6(:,164),heltab2x48(:,:,395))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(412),h0tab(:,412),[21,10],[0,0],2,2,wf8(:,13),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf8(:,13),G0H6(49),m3h8x6(:,165),heltab2x48(:,:,396))
  call Hloop_Q_A(ntryL,G0H6(49),21,0,G1H6(30),n2h6(164))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(413),h0tab(:,413),[21,10],[0,nMZ],2,2,wf8(:,13),wf6(:,2))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf8(:,13),G0H6(25),ngZu,m3h8x6(:,166),heltab2x48(:,:,397))
  call Hloop_Q_A(ntryL,G0H6(25),21,0,G1H6(121),n2h6(165))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(414),h0tab(:,414),[21,10],[0,nMW],2,2,wf8(:,13),wf6(:,2))
  call Hloop_WQ_A(ntryL,G0H48(1),wf8(:,13),G0H6(4),m3h8x6(:,167),heltab2x48(:,:,398))
  call Hloop_Q_A(ntryL,G0H6(4),21,0,G1H6(107),n2h6(166))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(415),h0tab(:,415),[21,10],[0,0],2,2,wf8(:,13),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf8(:,13),G0H6(1),m3h8x6(:,168),heltab2x48(:,:,399))
  call Hloop_Q_A(ntryL,G0H6(1),21,0,G1H6(81),n2h6(167))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(416),h0tab(:,416),[26,5],[0,0],2,2,wf12(:,23),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,23),G0H4(17),m3h12x4(:,21),heltab2x48(:,:,400))
  call Hloop_A_Q(ntryL,G0H4(17),26,0,G1H4(32),n2h4(26))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(417),h0tab(:,417),[26,5],[0,nMZ],2,2,wf12(:,23),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf12(:,23),G0H4(9),ngZu,m3h12x4(:,22),heltab2x48(:,:,401))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(33),n2h4(27))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(418),h0tab(:,418),[26,5],[0,nMW],2,2,wf12(:,23),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H48(1),wf12(:,23),G0H4(4),m3h12x4(:,23),heltab2x48(:,:,402))
  call Hloop_A_Q(ntryL,G0H4(4),26,0,G1H4(24),n2h4(28))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(419),h0tab(:,419),[26,5],[0,0],2,2,wf12(:,23),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,23),G0H4(1),m3h12x4(:,24),heltab2x48(:,:,403))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(2),n2h4(29))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(420),h0tab(:,420),[18,13],[0,0],2,2,wf4(:,4),wf12(:,26))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(19),m3h4x12(:,51),heltab2x48(:,:,404))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(421),h0tab(:,421),[18,13],[nMZ,0],2,2,wf4(:,4),wf12(:,26))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,4),G0H12(2),ngZu,m3h4x12(:,52),heltab2x48(:,:,405))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(422),h0tab(:,422),[18,13],[nMW,0],2,2,wf4(:,4),wf12(:,26))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(6),m3h4x12(:,53),heltab2x48(:,:,406))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(423),h0tab(:,423),[18,13],[0,0],2,2,wf4(:,4),wf12(:,26))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(11),m3h4x12(:,54),heltab2x48(:,:,407))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(424),h0tab(:,424),[26,5],[0,0],2,2,wf12(:,25),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,25),G0H4(2),m3h12x4(:,25),heltab2x48(:,:,408))
  call Hloop_A_Q(ntryL,G0H4(2),26,0,G1H4(6),n2h4(30))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(425),h0tab(:,425),[26,5],[0,nMZ],2,2,wf12(:,25),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf12(:,25),G0H4(3),ngZu,m3h12x4(:,26),heltab2x48(:,:,409))
  call Hloop_A_Q(ntryL,G0H4(3),26,0,G1H4(7),n2h4(31))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(426),h0tab(:,426),[26,5],[0,nMW],2,2,wf12(:,25),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H48(1),wf12(:,25),G0H4(13),m3h12x4(:,27),heltab2x48(:,:,410))
  call Hloop_A_Q(ntryL,G0H4(13),26,0,G1H4(8),n2h4(32))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(427),h0tab(:,427),[26,5],[0,0],2,2,wf12(:,25),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,25),G0H4(8),m3h12x4(:,28),heltab2x48(:,:,411))
  call Hloop_A_Q(ntryL,G0H4(8),26,0,G1H4(9),n2h4(33))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(428),h0tab(:,428),[25,6],[0,0],2,2,wf12(:,27),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,27),G0H4(5),m3h12x4(:,29),heltab2x48(:,:,412))
  call Hloop_Q_A(ntryL,G0H4(5),25,0,G1H4(13),n2h4(34))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(429),h0tab(:,429),[25,6],[0,nMZ],2,2,wf12(:,27),wf4(:,6))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf12(:,27),G0H4(6),ngZu,m3h12x4(:,30),heltab2x48(:,:,413))
  call Hloop_Q_A(ntryL,G0H4(6),25,0,G1H4(1),n2h4(35))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(430),h0tab(:,430),[25,6],[0,nMW],2,2,wf12(:,27),wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H48(1),wf12(:,27),G0H4(7),m3h12x4(:,31),heltab2x48(:,:,414))
  call Hloop_Q_A(ntryL,G0H4(7),25,0,G1H4(14),n2h4(36))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(431),h0tab(:,431),[25,6],[0,0],2,2,wf12(:,27),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,27),G0H4(12),m3h12x4(:,32),heltab2x48(:,:,415))
  call Hloop_Q_A(ntryL,G0H4(12),25,0,G1H4(17),n2h4(37))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(432),h0tab(:,432),[22,9],[0,0],2,2,wf8(:,15),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf8(:,15),G0H6(2),m3h8x6(:,169),heltab2x48(:,:,416))
  call Hloop_A_Q(ntryL,G0H6(2),22,0,G1H6(115),n2h6(168))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(433),h0tab(:,433),[22,9],[0,nMZ],2,2,wf8(:,15),wf6(:,4))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf8(:,15),G0H6(3),ngZu,m3h8x6(:,170),heltab2x48(:,:,417))
  call Hloop_A_Q(ntryL,G0H6(3),22,0,G1H6(31),n2h6(169))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(434),h0tab(:,434),[22,9],[0,nMW],2,2,wf8(:,15),wf6(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf8(:,15),G0H6(45),m3h8x6(:,171),heltab2x48(:,:,418))
  call Hloop_A_Q(ntryL,G0H6(45),22,0,G1H6(111),n2h6(170))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(435),h0tab(:,435),[22,9],[0,0],2,2,wf8(:,15),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf8(:,15),G0H6(9),m3h8x6(:,172),heltab2x48(:,:,419))
  call Hloop_A_Q(ntryL,G0H6(9),22,0,G1H6(86),n2h6(171))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(436),h0tab(:,436),[25,6],[0,0],2,2,wf12(:,30),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,30),G0H4(10),m3h12x4(:,33),heltab2x48(:,:,420))
  call Hloop_Q_A(ntryL,G0H4(10),25,0,G1H4(18),n2h4(38))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(437),h0tab(:,437),[25,6],[0,nMZ],2,2,wf12(:,30),wf4(:,6))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf12(:,30),G0H4(11),ngZu,m3h12x4(:,34),heltab2x48(:,:,421))
  call Hloop_Q_A(ntryL,G0H4(11),25,0,G1H4(19),n2h4(39))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(438),h0tab(:,438),[25,6],[0,nMW],2,2,wf12(:,30),wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H48(1),wf12(:,30),G0H4(16),m3h12x4(:,35),heltab2x48(:,:,422))
  call Hloop_Q_A(ntryL,G0H4(16),25,0,G1H4(20),n2h4(40))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(439),h0tab(:,439),[25,6],[0,0],2,2,wf12(:,30),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,30),G0H4(14),m3h12x4(:,36),heltab2x48(:,:,423))
  call Hloop_Q_A(ntryL,G0H4(14),25,0,G1H4(25),n2h4(41))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(440),h0tab(:,440),[17,14],[0,0],2,2,wf4(:,8),wf12(:,29))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(15),m3h4x12(:,55),heltab2x48(:,:,424))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(441),h0tab(:,441),[17,14],[nMZ,0],2,2,wf4(:,8),wf12(:,29))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,8),G0H12(5),ngZu,m3h4x12(:,56),heltab2x48(:,:,425))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(442),h0tab(:,442),[17,14],[nMW,0],2,2,wf4(:,8),wf12(:,29))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,8),G0H12(3),m3h4x12(:,57),heltab2x48(:,:,426))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(443),h0tab(:,443),[17,14],[0,0],2,2,wf4(:,8),wf12(:,29))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(4),m3h4x12(:,58),heltab2x48(:,:,427))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(444),h0tab(:,444),[18,13],[0,0],2,2,wf4(:,4),wf12(:,31))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(9),m3h4x12(:,59),heltab2x48(:,:,428))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(445),h0tab(:,445),[18,13],[nMZ,0],2,2,wf4(:,4),wf12(:,31))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,4),G0H12(7),ngZu,m3h4x12(:,60),heltab2x48(:,:,429))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(446),h0tab(:,446),[18,13],[nMW,0],2,2,wf4(:,4),wf12(:,31))



end subroutine vamp_3

end module ol_vamp_3_ppvvj_ew_uuxazg_1_/**/REALKIND
