
module ol_vamp_2_ppvvj_ew_bbxazg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj_ew_bbxazg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj_ew_bbxazg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvvj_ew_bbxazg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvvj_ew_bbxazg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppvvj_ew_bbxazg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvvj_ew_bbxazg_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(48)
  type(Hpolcont), intent(in) :: M(2,48)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(209),h0tab(:,209),[17,2,4,8],[nMW,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(7),ngPtb,m3h4x12(:,15),heltab2x48(:,:,209))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(210),h0tab(:,210),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(8),ngPtb,m3h4x12(:,16),heltab2x48(:,:,210))
  call Hloop_Q_A(ntryL,G0H12(8),17,nMT,G1H12(21),n2h12(25))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(211),h0tab(:,211),[17,2,4,8],[0,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(8),m3h4x12(:,17),heltab2x48(:,:,211))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(212),h0tab(:,212),[17,2,4,8],[nMZ,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,8),G0H12(9),ngZd,m3h4x12(:,18),heltab2x48(:,:,212))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(213),h0tab(:,213),[17,2,4,8],[nMW,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,8),G0H12(10),m3h4x12(:,19),heltab2x48(:,:,213))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(214),h0tab(:,214),[17,2,4,8],[0,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(11),m3h4x12(:,20),heltab2x48(:,:,214))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(215),h0tab(:,215),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(12),m3h4x12(:,21),heltab2x48(:,:,215))
  call Hloop_Q_A(ntryL,G0H12(12),17,nMT,G1H12(22),n2h12(26))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(216),h0tab(:,216),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(12),ngPtb,m3h4x12(:,22),heltab2x48(:,:,216))
  call Hloop_Q_A(ntryL,G0H12(12),17,nMT,G1H12(23),n2h12(27))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(217),h0tab(:,217),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(12),ngPtb,m3h4x12(:,23),heltab2x48(:,:,217))
  call Hloop_Q_A(ntryL,G0H12(12),17,nMT,G1H12(24),n2h12(28))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(218),h0tab(:,218),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(12),m3h4x12(:,24),heltab2x48(:,:,218))
  call Hloop_Q_A(ntryL,G0H12(12),17,nMT,G1H12(25),n2h12(29))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(219),h0tab(:,219),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(12),m3h4x12(:,25),heltab2x48(:,:,219))
  call Hloop_Q_A(ntryL,G0H12(12),17,nMT,G1H12(26),n2h12(30))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(220),h0tab(:,220),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(12),ngPtb,m3h4x12(:,26),heltab2x48(:,:,220))
  call Hloop_Q_A(ntryL,G0H12(12),17,nMT,G1H12(27),n2h12(31))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(221),h0tab(:,221),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(12),m3h4x12(:,27),heltab2x48(:,:,221))
  call Hloop_Q_A(ntryL,G0H12(12),17,nMT,G1H12(28),n2h12(32))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(222),h0tab(:,222),[17,2,8,4],[nMH,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(12),ngH,m3h4x12(:,28),heltab2x48(:,:,222))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(223),h0tab(:,223),[17,2,8,4],[nMZ,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(13),ngX,m3h4x12(:,29),heltab2x48(:,:,223))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(224),h0tab(:,224),[17,2,8,4],[nMW,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(14),ngPtb,m3h4x12(:,30),heltab2x48(:,:,224))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(225),h0tab(:,225),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(15),ngPtb,m3h4x12(:,31),heltab2x48(:,:,225))
  call Hloop_Q_A(ntryL,G0H12(15),17,nMT,G1H12(29),n2h12(33))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(226),h0tab(:,226),[17,2,8,4],[0,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(15),m3h4x12(:,32),heltab2x48(:,:,226))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(227),h0tab(:,227),[17,2,8,4],[nMZ,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,8),G0H12(16),ngZd,m3h4x12(:,33),heltab2x48(:,:,227))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(228),h0tab(:,228),[17,2,8,4],[nMW,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,8),G0H12(17),m3h4x12(:,34),heltab2x48(:,:,228))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(229),h0tab(:,229),[17,2,8,4],[0,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(18),m3h4x12(:,35),heltab2x48(:,:,229))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(230),h0tab(:,230),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(19),m3h4x12(:,36),heltab2x48(:,:,230))
  call Hloop_Q_A(ntryL,G0H12(19),17,nMT,G1H12(30),n2h12(34))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(231),h0tab(:,231),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(19),ngPtb,m3h4x12(:,37),heltab2x48(:,:,231))
  call Hloop_Q_A(ntryL,G0H12(19),17,nMT,G1H12(31),n2h12(35))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(232),h0tab(:,232),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(19),ngPtb,m3h4x12(:,38),heltab2x48(:,:,232))
  call Hloop_Q_A(ntryL,G0H12(19),17,nMT,G1H12(32),n2h12(36))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(233),h0tab(:,233),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(19),m3h4x12(:,39),heltab2x48(:,:,233))
  call Hloop_Q_A(ntryL,G0H12(19),17,nMT,G1H12(33),n2h12(37))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(234),h0tab(:,234),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(19),m3h4x12(:,40),heltab2x48(:,:,234))
  call Hloop_Q_A(ntryL,G0H12(19),17,nMT,G1H12(34),n2h12(38))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(235),h0tab(:,235),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(19),ngPtb,m3h4x12(:,41),heltab2x48(:,:,235))
  call Hloop_Q_A(ntryL,G0H12(19),17,nMT,G1H12(35),n2h12(39))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(236),h0tab(:,236),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(19),m3h4x12(:,42),heltab2x48(:,:,236))
  call Hloop_Q_A(ntryL,G0H12(19),17,nMT,G1H12(36),n2h12(40))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(237),h0tab(:,237),[18,4,1,8],[nMB,nMB,nMH,nMZ],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(19),ngX,m3h4x12(:,43),heltab2x48(:,:,237))
  call Hloop_A_Q(ntryL,G0H12(19),18,nMB,G1H12(37),n2h12(41))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(238),h0tab(:,238),[18,4,1,8],[nMB,nMB,nMZ,nMH],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(19),ngH,m3h4x12(:,44),heltab2x48(:,:,238))
  call Hloop_A_Q(ntryL,G0H12(19),18,nMB,G1H12(38),n2h12(42))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(239),h0tab(:,239),[18,4,1,8],[nMT,nMT,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(19),ngPbt,m3h4x12(:,45),heltab2x48(:,:,239))
  call Hloop_A_Q(ntryL,G0H12(19),18,nMT,G1H12(39),n2h12(43))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(240),h0tab(:,240),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(19),ngPbt,m3h4x12(:,46),heltab2x48(:,:,240))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(241),h0tab(:,241),[18,4,1,8],[nMB,nMB,nMH,nMZ],4,1,wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(20),ngZd,m3h4x12(:,47),heltab2x48(:,:,241))
  call Hloop_A_Q(ntryL,G0H12(20),18,nMB,G1H12(40),n2h12(44))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(242),h0tab(:,242),[18,4,1,8],[nMT,nMT,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(20),m3h4x12(:,48),heltab2x48(:,:,242))
  call Hloop_A_Q(ntryL,G0H12(20),18,nMT,G1H12(41),n2h12(45))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(243),h0tab(:,243),[18,4,1,8],[nMB,nMB,nMZ,nMH],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(20),ngH,m3h4x12(:,49),heltab2x48(:,:,243))
  call Hloop_A_Q(ntryL,G0H12(20),18,nMB,G1H12(42),n2h12(46))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(244),h0tab(:,244),[18,4,1,8],[nMT,nMT,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(20),ngPbt,m3h4x12(:,50),heltab2x48(:,:,244))
  call Hloop_A_Q(ntryL,G0H12(20),18,nMT,G1H12(43),n2h12(47))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(245),h0tab(:,245),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(20),m3h4x12(:,51),heltab2x48(:,:,245))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(246),h0tab(:,246),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(21),ngPbt,m3h4x12(:,52),heltab2x48(:,:,246))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(247),h0tab(:,247),[18,4,1,8],[nMT,nMT,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(22),m3h4x12(:,53),heltab2x48(:,:,247))
  call Hloop_A_Q(ntryL,G0H12(22),18,nMT,G1H12(44),n2h12(48))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(248),h0tab(:,248),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(22),m3h4x12(:,54),heltab2x48(:,:,248))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(249),h0tab(:,249),[18,1,4,8],[nMH,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(23),ngH,m3h4x12(:,55),heltab2x48(:,:,249))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(250),h0tab(:,250),[18,1,4,8],[nMZ,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(24),ngX,m3h4x12(:,56),heltab2x48(:,:,250))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(251),h0tab(:,251),[18,1,4,8],[nMW,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(25),ngPbt,m3h4x12(:,57),heltab2x48(:,:,251))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(252),h0tab(:,252),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(26),ngPbt,m3h4x12(:,58),heltab2x48(:,:,252))
  call Hloop_A_Q(ntryL,G0H12(26),18,nMT,G1H12(45),n2h12(49))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(253),h0tab(:,253),[18,1,4,8],[0,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(26),m3h4x12(:,59),heltab2x48(:,:,253))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(254),h0tab(:,254),[18,1,4,8],[nMZ,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,4),G0H12(27),ngZd,m3h4x12(:,60),heltab2x48(:,:,254))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(255),h0tab(:,255),[18,1,4,8],[nMW,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(28),m3h4x12(:,61),heltab2x48(:,:,255))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(256),h0tab(:,256),[18,1,4,8],[0,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(29),m3h4x12(:,62),heltab2x48(:,:,256))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(257),h0tab(:,257),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(30),m3h4x12(:,63),heltab2x48(:,:,257))
  call Hloop_A_Q(ntryL,G0H12(30),18,nMT,G1H12(46),n2h12(50))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(258),h0tab(:,258),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(30),ngPbt,m3h4x12(:,64),heltab2x48(:,:,258))
  call Hloop_A_Q(ntryL,G0H12(30),18,nMT,G1H12(47),n2h12(51))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(259),h0tab(:,259),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(30),ngPbt,m3h4x12(:,65),heltab2x48(:,:,259))
  call Hloop_A_Q(ntryL,G0H12(30),18,nMT,G1H12(48),n2h12(52))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(260),h0tab(:,260),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(30),m3h4x12(:,66),heltab2x48(:,:,260))
  call Hloop_A_Q(ntryL,G0H12(30),18,nMT,G1H12(49),n2h12(53))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(261),h0tab(:,261),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(30),m3h4x12(:,67),heltab2x48(:,:,261))
  call Hloop_A_Q(ntryL,G0H12(30),18,nMT,G1H12(50),n2h12(54))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(262),h0tab(:,262),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(30),ngPbt,m3h4x12(:,68),heltab2x48(:,:,262))
  call Hloop_A_Q(ntryL,G0H12(30),18,nMT,G1H12(51),n2h12(55))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(263),h0tab(:,263),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(30),m3h4x12(:,69),heltab2x48(:,:,263))
  call Hloop_A_Q(ntryL,G0H12(30),18,nMT,G1H12(52),n2h12(56))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(264),h0tab(:,264),[18,1,8,4],[nMH,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(30),ngH,m3h4x12(:,70),heltab2x48(:,:,264))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(265),h0tab(:,265),[18,1,8,4],[nMZ,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(31),ngX,m3h4x12(:,71),heltab2x48(:,:,265))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(266),h0tab(:,266),[18,1,8,4],[nMW,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(32),ngPbt,m3h4x12(:,72),heltab2x48(:,:,266))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(267),h0tab(:,267),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(33),ngPbt,m3h4x12(:,73),heltab2x48(:,:,267))
  call Hloop_A_Q(ntryL,G0H12(33),18,nMT,G1H12(53),n2h12(57))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(268),h0tab(:,268),[18,1,8,4],[0,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(33),m3h4x12(:,74),heltab2x48(:,:,268))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(269),h0tab(:,269),[18,1,8,4],[nMZ,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,4),G0H12(34),ngZd,m3h4x12(:,75),heltab2x48(:,:,269))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(270),h0tab(:,270),[18,1,8,4],[nMW,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(35),m3h4x12(:,76),heltab2x48(:,:,270))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(271),h0tab(:,271),[18,1,8,4],[0,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(36),m3h4x12(:,77),heltab2x48(:,:,271))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(272),h0tab(:,272),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(37),m3h4x12(:,78),heltab2x48(:,:,272))
  call Hloop_A_Q(ntryL,G0H12(37),18,nMT,G1H12(54),n2h12(58))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(273),h0tab(:,273),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(37),ngPbt,m3h4x12(:,79),heltab2x48(:,:,273))
  call Hloop_A_Q(ntryL,G0H12(37),18,nMT,G1H12(55),n2h12(59))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(274),h0tab(:,274),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(37),ngPbt,m3h4x12(:,80),heltab2x48(:,:,274))
  call Hloop_A_Q(ntryL,G0H12(37),18,nMT,G1H12(56),n2h12(60))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(275),h0tab(:,275),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(37),m3h4x12(:,81),heltab2x48(:,:,275))
  call Hloop_A_Q(ntryL,G0H12(37),18,nMT,G1H12(57),n2h12(61))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(276),h0tab(:,276),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(37),m3h4x12(:,82),heltab2x48(:,:,276))
  call Hloop_A_Q(ntryL,G0H12(37),18,nMT,G1H12(58),n2h12(62))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(277),h0tab(:,277),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(37),ngPbt,m3h4x12(:,83),heltab2x48(:,:,277))
  call Hloop_A_Q(ntryL,G0H12(37),18,nMT,G1H12(59),n2h12(63))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(278),h0tab(:,278),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(37),m3h4x12(:,84),heltab2x48(:,:,278))
  call Hloop_A_Q(ntryL,G0H12(37),18,nMT,G1H12(60),n2h12(64))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(41),[G1H24(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(49),[G1H24(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(65),[G1H24(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(72),[G1H24(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(84),[G1H24(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(91),[G1H24(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(103),[G1H24(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(110),[G1H24(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(11),[G0H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(18),[G0H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(29),[G0H12(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(36),[G0H12(33)])
  call Hloop_QV_A(ntryL,G1H12(3),ex3(:),G1H6(211),m3h2x6(:,59),heltab2x12(:,:,87))
  call Hloop_Q_A(ntryL,G1H6(211),21,nMB,G2H6(36),n2h6(66))
  call Hloop_QZ_A(ntryL,G1H12(9),ex4(:),G1H4(65),ngZd,m3h3x4(:,29),heltab2x12(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(65),25,nMB,G2H4(10),n2h4(18))
  call Hloop_AQ_S(ntryL,G1H24(4),ex1(:),G1H12(61),ngPtb,m3h2x12(:,79),heltab2x24(:,:,79))
  call Hloop_AQ_W(ntryL,G1H24(11),ex1(:),G1H12(62),m3h2x12(:,80),heltab2x24(:,:,80))
  call Hloop_QV_A(ntryL,G1H24(18),wf4(:,9),G1H6(212),m3h4x6(:,1),heltab2x24(:,:,81))
  call Hloop_Q_A(ntryL,G1H6(212),19,0,G2H6(34),n2h6(67))
  call Hloop_QV_A(ntryL,G1H24(25),wf4(:,9),G1H6(1),m3h4x6(:,2),heltab2x24(:,:,82))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(37),n2h6(68))
  call Hloop_AV_Q(ntryL,G1H24(32),wf4(:,9),G1H6(2),m3h4x6(:,3),heltab2x24(:,:,83))
  call Hloop_A_Q(ntryL,G1H6(2),19,0,G2H6(38),n2h6(69))
  call Hloop_AV_Q(ntryL,G1H24(39),wf4(:,9),G1H6(6),m3h4x6(:,4),heltab2x24(:,:,84))
  call Hloop_A_Q(ntryL,G1H6(6),19,nMT,G2H6(39),n2h6(70))
  call Hloop_QV_A(ntryL,G1H24(1),wf4(:,9),G1H6(5),m3h4x6(:,5),heltab2x24(:,:,85))
  call Hloop_Q_A(ntryL,G1H6(5),19,0,G2H6(40),n2h6(71))
  call Hloop_QV_A(ntryL,G1H24(2),wf4(:,9),G1H6(8),m3h4x6(:,6),heltab2x24(:,:,86))
  call Hloop_Q_A(ntryL,G1H6(8),19,nMB,G2H6(41),n2h6(72))
  call Hloop_AV_Q(ntryL,G1H24(3),wf4(:,9),G1H6(7),m3h4x6(:,7),heltab2x24(:,:,87))
  call Hloop_A_Q(ntryL,G1H6(7),19,0,G2H6(43),n2h6(73))
  call Hloop_AV_Q(ntryL,G1H24(7),wf4(:,9),G1H6(13),m3h4x6(:,8),heltab2x24(:,:,88))
  call Hloop_A_Q(ntryL,G1H6(13),19,nMB,G2H6(42),n2h6(74))
  call Hloop_AV_Q(ntryL,G1H24(5),wf4(:,9),G1H6(14),m3h4x6(:,9),heltab2x24(:,:,89))
  call Hloop_A_Q(ntryL,G1H6(14),19,0,G2H6(44),n2h6(75))
  call Hloop_AV_Q(ntryL,G1H24(6),wf4(:,9),G1H6(15),m3h4x6(:,10),heltab2x24(:,:,90))
  call Hloop_A_Q(ntryL,G1H6(15),19,nMT,G2H6(45),n2h6(76))
  call Hloop_QV_A(ntryL,G1H24(8),wf4(:,9),G1H6(16),m3h4x6(:,11),heltab2x24(:,:,91))
  call Hloop_Q_A(ntryL,G1H6(16),19,0,G2H6(47),n2h6(77))
  call Hloop_QV_A(ntryL,G1H24(9),wf4(:,9),G1H6(19),m3h4x6(:,12),heltab2x24(:,:,92))
  call Hloop_Q_A(ntryL,G1H6(19),19,nMT,G2H6(48),n2h6(78))
  call Hloop_AV_Q(ntryL,G1H24(10),wf4(:,9),G1H6(20),m3h4x6(:,13),heltab2x24(:,:,93))
  call Hloop_A_Q(ntryL,G1H6(20),19,0,G2H6(8),n2h6(79))
  call Hloop_AV_Q(ntryL,G1H24(14),wf4(:,9),G1H6(21),m3h4x6(:,14),heltab2x24(:,:,94))
  call Hloop_A_Q(ntryL,G1H6(21),19,nMB,G2H6(9),n2h6(80))
  call Hloop_QV_A(ntryL,G1H24(12),wf4(:,9),G1H6(22),m3h4x6(:,15),heltab2x24(:,:,95))
  call Hloop_Q_A(ntryL,G1H6(22),19,0,G2H6(20),n2h6(81))
  call Hloop_QV_A(ntryL,G1H24(13),wf4(:,9),G1H6(25),m3h4x6(:,16),heltab2x24(:,:,96))
  call Hloop_Q_A(ntryL,G1H6(25),19,nMB,G2H6(21),n2h6(82))
  call Hloop_QV_A(ntryL,G1H24(15),ex3(:),G1H12(63),m3h2x12(:,81),heltab2x24(:,:,97))
  call Hloop_Q_A(ntryL,G1H12(63),20,0,G2H12(1),n2h12(65))
  call Hloop_QV_A(ntryL,G1H24(16),ex3(:),G1H12(64),m3h2x12(:,82),heltab2x24(:,:,98))
  call Hloop_Q_A(ntryL,G1H12(64),20,nMT,G2H12(2),n2h12(66))
  call Hloop_AV_Q(ntryL,G1H24(17),ex3(:),G1H12(1),m3h2x12(:,83),heltab2x24(:,:,99))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(3),n2h12(67))
  call Hloop_AV_Q(ntryL,G1H24(21),ex3(:),G1H12(2),m3h2x12(:,84),heltab2x24(:,:,100))
  call Hloop_A_Q(ntryL,G1H12(2),20,nMT,G2H12(4),n2h12(68))
  call Hloop_QV_A(ntryL,G1H24(19),ex3(:),G1H12(4),m3h2x12(:,85),heltab2x24(:,:,101))
  call Hloop_Q_A(ntryL,G1H12(4),20,0,G2H12(5),n2h12(69))
  call Hloop_QV_A(ntryL,G1H24(20),ex3(:),G1H12(5),m3h2x12(:,86),heltab2x24(:,:,102))
  call Hloop_Q_A(ntryL,G1H12(5),20,nMB,G2H12(6),n2h12(70))
  call Hloop_AV_Q(ntryL,G1H24(22),ex3(:),G1H12(6),m3h2x12(:,87),heltab2x24(:,:,103))
  call Hloop_A_Q(ntryL,G1H12(6),20,0,G2H12(7),n2h12(71))
  call Hloop_AV_Q(ntryL,G1H24(23),ex3(:),G1H12(7),m3h2x12(:,88),heltab2x24(:,:,104))
  call Hloop_A_Q(ntryL,G1H12(7),20,nMB,G2H12(8),n2h12(72))
  call Hloop_QA_S(ntryL,G1H24(24),ex2(:),G1H12(8),ngH,m3h2x12(:,89),heltab2x24(:,:,105))
  call Hloop_QA_S(ntryL,G1H24(28),ex2(:),G1H12(10),ngX,m3h2x12(:,90),heltab2x24(:,:,106))
  call Hloop_QA_S(ntryL,G1H24(26),ex2(:),G1H12(11),ngPbt,m3h2x12(:,91),heltab2x24(:,:,107))
  call Hloop_QA_S(ntryL,G1H24(27),ex2(:),G1H12(12),ngH,m3h2x12(:,92),heltab2x24(:,:,108))
  call Hloop_QA_S(ntryL,G1H24(29),ex2(:),G1H12(3),ngPbt,m3h2x12(:,93),heltab2x24(:,:,109))
  call Hloop_QA_Z(ntryL,G1H24(30),ex2(:),G1H12(9),ngZd,m3h2x12(:,94),heltab2x24(:,:,110))
  call Hloop_QA_W(ntryL,G1H24(31),ex2(:),G1H12(63),m3h2x12(:,95),heltab2x24(:,:,111))
  call Hloop_VA_Q(ntryL,G1H24(35),ex2(:),G1H12(64),m3h2x12(:,96),heltab2x24(:,:,112))
  call Hloop_A_Q(ntryL,G1H12(64),18,nMB,G2H12(9),n2h12(73))
  call Hloop_QA_W(ntryL,G1H24(33),ex2(:),G1H12(1),m3h2x12(:,97),heltab2x24(:,:,113))
  call Hloop_AQ_S(ntryL,G1H24(34),wf4(:,2),G1H6(26),ngH,m3h4x6(:,17),heltab2x24(:,:,114))
  call Hloop_AQ_S(ntryL,G1H24(36),wf4(:,2),G1H6(27),ngX,m3h4x6(:,18),heltab2x24(:,:,115))
  call Hloop_AQ_S(ntryL,G1H24(37),wf4(:,2),G1H6(28),ngPtb,m3h4x6(:,19),heltab2x24(:,:,116))
  call Hloop_AQ_V(ntryL,G1H24(41),wf4(:,2),G1H6(31),m3h4x6(:,20),heltab2x24(:,:,117))
  call Hloop_AQ_Z(ntryL,G1H24(42),wf4(:,2),G1H6(32),ngZd,m3h4x6(:,21),heltab2x24(:,:,118))
  call Hloop_AQ_W(ntryL,G1H24(40),wf4(:,2),G1H6(33),m3h4x6(:,22),heltab2x24(:,:,119))
  call Hloop_QA_S(ntryL,G1H24(43),ex2(:),G1H12(2),ngH,m3h2x12(:,98),heltab2x24(:,:,120))
  call Hloop_QA_S(ntryL,G1H24(44),ex2(:),G1H12(4),ngX,m3h2x12(:,99),heltab2x24(:,:,121))
  call Hloop_QA_S(ntryL,G1H24(45),ex2(:),G1H12(5),ngPbt,m3h2x12(:,100),heltab2x24(:,:,122))
  call Hloop_QA_V(ntryL,G1H24(49),ex2(:),G1H12(6),m3h2x12(:,101),heltab2x24(:,:,123))
  call Hloop_QA_Z(ntryL,G1H24(47),ex2(:),G1H12(7),ngZd,m3h2x12(:,102),heltab2x24(:,:,124))
  call Hloop_QA_W(ntryL,G1H24(48),ex2(:),G1H12(64),m3h2x12(:,103),heltab2x24(:,:,125))
  call Hloop_AQ_S(ntryL,G1H24(50),ex1(:),G1H12(65),ngH,m3h2x12(:,104),heltab2x24(:,:,126))
  call Hloop_AQ_S(ntryL,G1H24(51),ex1(:),G1H12(66),ngX,m3h2x12(:,105),heltab2x24(:,:,127))
  call Hloop_AQ_S(ntryL,G1H24(52),ex1(:),G1H12(67),ngPtb,m3h2x12(:,106),heltab2x24(:,:,128))
  call Hloop_AQ_S(ntryL,G1H24(53),ex1(:),G1H12(68),ngH,m3h2x12(:,107),heltab2x24(:,:,129))
  call Hloop_AQ_S(ntryL,G1H24(54),ex1(:),G1H12(69),ngPtb,m3h2x12(:,108),heltab2x24(:,:,130))
  call Hloop_AQ_Z(ntryL,G1H24(55),ex1(:),G1H12(70),ngZd,m3h2x12(:,109),heltab2x24(:,:,131))
  call Hloop_AQ_W(ntryL,G1H24(56),ex1(:),G1H12(71),m3h2x12(:,110),heltab2x24(:,:,132))
  call Hloop_VQ_A(ntryL,G1H24(57),ex1(:),G1H12(72),m3h2x12(:,111),heltab2x24(:,:,133))
  call Hloop_Q_A(ntryL,G1H12(72),17,nMB,G2H12(10),n2h12(74))
  call Hloop_AQ_W(ntryL,G1H24(58),ex1(:),G1H12(72),m3h2x12(:,112),heltab2x24(:,:,134))
  call Hloop_QA_S(ntryL,G1H24(59),wf4(:,6),G1H6(34),ngH,m3h4x6(:,23),heltab2x24(:,:,135))
  call Hloop_QA_S(ntryL,G1H24(60),wf4(:,6),G1H6(37),ngX,m3h4x6(:,24),heltab2x24(:,:,136))
  call Hloop_QA_S(ntryL,G1H24(61),wf4(:,6),G1H6(38),ngPbt,m3h4x6(:,25),heltab2x24(:,:,137))
  call Hloop_QA_V(ntryL,G1H24(65),wf4(:,6),G1H6(39),m3h4x6(:,26),heltab2x24(:,:,138))
  call Hloop_QA_Z(ntryL,G1H24(63),wf4(:,6),G1H6(40),ngZd,m3h4x6(:,27),heltab2x24(:,:,139))
  call Hloop_QA_W(ntryL,G1H24(64),wf4(:,6),G1H6(43),m3h4x6(:,28),heltab2x24(:,:,140))
  call Hloop_AQ_S(ntryL,G1H24(66),ex1(:),G1H12(73),ngH,m3h2x12(:,113),heltab2x24(:,:,141))
  call Hloop_AQ_S(ntryL,G1H24(67),ex1(:),G1H12(74),ngX,m3h2x12(:,114),heltab2x24(:,:,142))
  call Hloop_AQ_S(ntryL,G1H24(68),ex1(:),G1H12(75),ngPtb,m3h2x12(:,115),heltab2x24(:,:,143))
  call Hloop_AQ_V(ntryL,G1H24(72),ex1(:),G1H12(76),m3h2x12(:,116),heltab2x24(:,:,144))
  call Hloop_AQ_Z(ntryL,G1H24(70),ex1(:),G1H12(77),ngZd,m3h2x12(:,117),heltab2x24(:,:,145))
  call Hloop_AQ_W(ntryL,G1H24(71),ex1(:),G1H12(78),m3h2x12(:,118),heltab2x24(:,:,146))
  call Hloop_QA_S(ntryL,G1H24(73),ex2(:),G1H12(79),ngPbt,m3h2x12(:,119),heltab2x24(:,:,147))
  call Hloop_QA_S(ntryL,G1H24(74),ex2(:),G1H12(80),ngPbt,m3h2x12(:,120),heltab2x24(:,:,148))
  call Hloop_QA_W(ntryL,G1H24(75),ex2(:),G1H12(81),m3h2x12(:,121),heltab2x24(:,:,149))
  call Hloop_VA_Q(ntryL,G1H24(76),ex2(:),G1H12(82),m3h2x12(:,122),heltab2x24(:,:,150))
  call Hloop_A_Q(ntryL,G1H12(82),18,nMB,G2H12(11),n2h12(75))
  call Hloop_QA_W(ntryL,G1H24(77),ex2(:),G1H12(82),m3h2x12(:,123),heltab2x24(:,:,151))
  call Hloop_QV_A(ntryL,G1H24(78),ex3(:),G1H12(83),m3h2x12(:,124),heltab2x24(:,:,152))
  call Hloop_Q_A(ntryL,G1H12(83),20,nMB,G2H12(12),n2h12(76))
  call Hloop_QV_A(ntryL,G1H24(79),ex3(:),G1H12(83),m3h2x12(:,125),heltab2x24(:,:,153))
  call Hloop_Q_A(ntryL,G1H12(83),20,nMB,G2H12(13),n2h12(77))
  call Hloop_QV_A(ntryL,G1H24(80),ex3(:),G1H12(83),m3h2x12(:,126),heltab2x24(:,:,154))
  call Hloop_Q_A(ntryL,G1H12(83),20,nMT,G2H12(14),n2h12(78))
  call Hloop_QV_A(ntryL,G1H24(84),ex3(:),G1H12(83),m3h2x12(:,127),heltab2x24(:,:,155))
  call Hloop_Q_A(ntryL,G1H12(83),20,nMB,G2H12(15),n2h12(79))
  call Hloop_QV_A(ntryL,G1H24(82),ex3(:),G1H12(83),m3h2x12(:,128),heltab2x24(:,:,156))
  call Hloop_Q_A(ntryL,G1H12(83),20,nMB,G2H12(16),n2h12(80))
  call Hloop_QV_A(ntryL,G1H24(83),ex3(:),G1H12(83),m3h2x12(:,129),heltab2x24(:,:,157))
  call Hloop_Q_A(ntryL,G1H12(83),20,nMT,G2H12(17),n2h12(81))
  call Hloop_QA_S(ntryL,G1H24(85),ex2(:),G1H12(83),ngH,m3h2x12(:,130),heltab2x24(:,:,158))
  call Hloop_QA_S(ntryL,G1H24(86),ex2(:),G1H12(84),ngX,m3h2x12(:,131),heltab2x24(:,:,159))
  call Hloop_QA_S(ntryL,G1H24(87),ex2(:),G1H12(85),ngPbt,m3h2x12(:,132),heltab2x24(:,:,160))
  call Hloop_QA_V(ntryL,G1H24(91),ex2(:),G1H12(86),m3h2x12(:,133),heltab2x24(:,:,161))
  call Hloop_QA_Z(ntryL,G1H24(89),ex2(:),G1H12(87),ngZd,m3h2x12(:,134),heltab2x24(:,:,162))
  call Hloop_QA_W(ntryL,G1H24(90),ex2(:),G1H12(88),m3h2x12(:,135),heltab2x24(:,:,163))
  call Hloop_AQ_S(ntryL,G1H24(92),ex1(:),G1H12(89),ngPtb,m3h2x12(:,136),heltab2x24(:,:,164))
  call Hloop_AQ_S(ntryL,G1H24(93),ex1(:),G1H12(90),ngPtb,m3h2x12(:,137),heltab2x24(:,:,165))
  call Hloop_AQ_W(ntryL,G1H24(94),ex1(:),G1H12(91),m3h2x12(:,138),heltab2x24(:,:,166))
  call Hloop_VQ_A(ntryL,G1H24(95),ex1(:),G1H12(92),m3h2x12(:,139),heltab2x24(:,:,167))
  call Hloop_Q_A(ntryL,G1H12(92),17,nMB,G2H12(18),n2h12(82))
  call Hloop_AQ_W(ntryL,G1H24(96),ex1(:),G1H12(92),m3h2x12(:,140),heltab2x24(:,:,168))
  call Hloop_AV_Q(ntryL,G1H24(97),ex3(:),G1H12(93),m3h2x12(:,141),heltab2x24(:,:,169))
  call Hloop_A_Q(ntryL,G1H12(93),20,nMB,G2H12(19),n2h12(83))
  call Hloop_AV_Q(ntryL,G1H24(98),ex3(:),G1H12(93),m3h2x12(:,142),heltab2x24(:,:,170))
  call Hloop_A_Q(ntryL,G1H12(93),20,nMB,G2H12(20),n2h12(84))
  call Hloop_AV_Q(ntryL,G1H24(99),ex3(:),G1H12(93),m3h2x12(:,143),heltab2x24(:,:,171))
  call Hloop_A_Q(ntryL,G1H12(93),20,nMT,G2H12(21),n2h12(85))
  call Hloop_AV_Q(ntryL,G1H24(103),ex3(:),G1H12(93),m3h2x12(:,144),heltab2x24(:,:,172))
  call Hloop_A_Q(ntryL,G1H12(93),20,nMB,G2H12(22),n2h12(86))
  call Hloop_AV_Q(ntryL,G1H24(101),ex3(:),G1H12(93),m3h2x12(:,145),heltab2x24(:,:,173))
  call Hloop_A_Q(ntryL,G1H12(93),20,nMB,G2H12(23),n2h12(87))
  call Hloop_AV_Q(ntryL,G1H24(102),ex3(:),G1H12(93),m3h2x12(:,146),heltab2x24(:,:,174))
  call Hloop_A_Q(ntryL,G1H12(93),20,nMT,G2H12(24),n2h12(88))
  call Hloop_AQ_S(ntryL,G1H24(104),ex1(:),G1H12(93),ngH,m3h2x12(:,147),heltab2x24(:,:,175))
  call Hloop_AQ_S(ntryL,G1H24(105),ex1(:),G1H12(94),ngX,m3h2x12(:,148),heltab2x24(:,:,176))
  call Hloop_AQ_S(ntryL,G1H24(106),ex1(:),G1H12(95),ngPtb,m3h2x12(:,149),heltab2x24(:,:,177))
  call Hloop_AQ_V(ntryL,G1H24(110),ex1(:),G1H12(96),m3h2x12(:,150),heltab2x24(:,:,178))
  call Hloop_AQ_Z(ntryL,G1H24(108),ex1(:),G1H12(97),ngZd,m3h2x12(:,151),heltab2x24(:,:,179))
  call Hloop_AQ_W(ntryL,G1H24(109),ex1(:),G1H12(98),m3h2x12(:,152),heltab2x24(:,:,180))
  call Hloop_QV_A(ntryL,G1H12(13),ex3(:),G1H6(44),m3h2x6(:,60),heltab2x12(:,:,89))
  call Hloop_Q_A(ntryL,G1H6(44),21,nMB,G2H6(26),n2h6(83))
  call Hloop_QV_A(ntryL,G1H12(14),ex3(:),G1H6(45),m3h2x6(:,61),heltab2x12(:,:,90))
  call Hloop_Q_A(ntryL,G1H6(45),21,nMB,G2H6(27),n2h6(84))
  call Hloop_QV_A(ntryL,G1H12(15),ex3(:),G1H6(46),m3h2x6(:,62),heltab2x12(:,:,91))
  call Hloop_Q_A(ntryL,G1H6(46),21,nMT,G2H6(32),n2h6(85))
  call Hloop_TV_S(ntryL,G0H12(1),17,ex3(:),4,G1H6(49),m3h2x6(:,63),heltab2x12(:,:,92))
  call Hloop_QV_A(ntryL,G1H12(16),ex3(:),G1H6(50),m3h2x6(:,64),heltab2x12(:,:,93))
  call Hloop_Q_A(ntryL,G1H6(50),21,nMB,G2H6(33),n2h6(86))
  call Hloop_QV_A(ntryL,G1H12(17),ex3(:),G1H6(51),m3h2x6(:,65),heltab2x12(:,:,94))
  call Hloop_Q_A(ntryL,G1H6(51),21,nMT,G2H6(1),n2h6(87))
  call Hloop_QV_A(ntryL,G1H12(18),ex3(:),G1H6(52),m3h2x6(:,66),heltab2x12(:,:,95))
  call Hloop_Q_A(ntryL,G1H6(52),21,nMB,G2H6(2),n2h6(88))
  call Hloop_QV_A(ntryL,G1H12(19),ex3(:),G1H6(55),m3h2x6(:,67),heltab2x12(:,:,96))
  call Hloop_Q_A(ntryL,G1H6(55),21,nMT,G2H6(3),n2h6(89))
  call Hloop_VV_S(ntryL,G0H12(2),ex3(:),G0H6(1),m3h2x6(:,68),heltab2x12(:,:,97))
  call Hloop_SV_V(ntryL,G0H12(3),ex3(:),G0H6(2),m3h2x6(:,69),heltab2x12(:,:,98))
  call Hloop_QV_A(ntryL,G1H12(20),ex3(:),G1H6(56),m3h2x6(:,70),heltab2x12(:,:,99))
  call Hloop_Q_A(ntryL,G1H6(56),21,nMT,G2H6(4),n2h6(90))
  call Hloop_UV_W(ntryL,G0H12(4),17,ex3(:),4,G1H6(57),m3h2x6(:,71),heltab2x12(:,:,100))
  call Hloop_SA_Q(ntryL,G0H12(5),ex2(:),G0H6(3),ngH,m3h2x6(:,72),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMB,G1H6(58),n2h6(91))
  call Hloop_SA_Q(ntryL,G0H12(6),ex2(:),G0H6(3),ngX,m3h2x6(:,73),heltab2x12(:,:,102))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMB,G1H6(61),n2h6(92))
  call Hloop_SA_Q(ntryL,G0H12(7),ex2(:),G0H6(3),ngPbt,m3h2x6(:,74),heltab2x12(:,:,103))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMT,G1H6(62),n2h6(93))
  call Hloop_QA_S(ntryL,G1H12(21),ex2(:),G1H6(63),ngPbt,m3h2x6(:,75),heltab2x12(:,:,104))
  call Hloop_VA_Q(ntryL,G0H12(11),ex2(:),G0H6(3),m3h2x6(:,76),heltab2x12(:,:,105))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMB,G1H6(64),n2h6(94))
  call Hloop_ZA_Q(ntryL,G0H12(9),ex2(:),G0H6(3),ngZd,m3h2x6(:,77),heltab2x12(:,:,106))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMB,G1H6(67),n2h6(95))
  call Hloop_WA_Q(ntryL,G0H12(10),ex2(:),G0H6(3),m3h2x6(:,78),heltab2x12(:,:,107))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMT,G1H6(68),n2h6(96))
  call Hloop_QA_S(ntryL,G1H12(22),ex2(:),G1H6(69),ngPbt,m3h2x6(:,79),heltab2x12(:,:,108))
  call Hloop_QA_S(ntryL,G1H12(23),ex2(:),G1H6(70),ngPbt,m3h2x6(:,80),heltab2x12(:,:,109))
  call Hloop_QA_W(ntryL,G1H12(24),ex2(:),G1H6(73),m3h2x6(:,81),heltab2x12(:,:,110))
  call Hloop_QA_S(ntryL,G1H12(25),ex2(:),G1H6(74),ngPbt,m3h2x6(:,82),heltab2x12(:,:,111))
  call Hloop_QA_W(ntryL,G1H12(26),ex2(:),G1H6(75),m3h2x6(:,83),heltab2x12(:,:,112))
  call Hloop_QA_W(ntryL,G1H12(27),ex2(:),G1H6(76),m3h2x6(:,84),heltab2x12(:,:,113))
  call Hloop_QA_W(ntryL,G1H12(28),ex2(:),G1H6(79),m3h2x6(:,85),heltab2x12(:,:,114))
  call Hloop_SA_Q(ntryL,G0H12(12),ex2(:),G0H6(3),ngH,m3h2x6(:,86),heltab2x12(:,:,115))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMB,G1H6(80),n2h6(97))
  call Hloop_SA_Q(ntryL,G0H12(13),ex2(:),G0H6(3),ngX,m3h2x6(:,87),heltab2x12(:,:,116))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMB,G1H6(81),n2h6(98))
  call Hloop_SA_Q(ntryL,G0H12(14),ex2(:),G0H6(3),ngPbt,m3h2x6(:,88),heltab2x12(:,:,117))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMT,G1H6(82),n2h6(99))
  call Hloop_QA_S(ntryL,G1H12(29),ex2(:),G1H6(85),ngPbt,m3h2x6(:,89),heltab2x12(:,:,118))
  call Hloop_VA_Q(ntryL,G0H12(18),ex2(:),G0H6(3),m3h2x6(:,90),heltab2x12(:,:,119))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMB,G1H6(86),n2h6(100))
  call Hloop_ZA_Q(ntryL,G0H12(16),ex2(:),G0H6(3),ngZd,m3h2x6(:,91),heltab2x12(:,:,120))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMB,G1H6(87),n2h6(101))
  call Hloop_WA_Q(ntryL,G0H12(17),ex2(:),G0H6(3),m3h2x6(:,92),heltab2x12(:,:,121))
  call Hloop_A_Q(ntryL,G0H6(3),19,nMT,G1H6(88),n2h6(102))
  call Hloop_QA_S(ntryL,G1H12(30),ex2(:),G1H6(91),ngPbt,m3h2x6(:,93),heltab2x12(:,:,122))
  call Hloop_QA_S(ntryL,G1H12(31),ex2(:),G1H6(92),ngPbt,m3h2x6(:,94),heltab2x12(:,:,123))
  call Hloop_QA_W(ntryL,G1H12(32),ex2(:),G1H6(93),m3h2x6(:,95),heltab2x12(:,:,124))
  call Hloop_QA_S(ntryL,G1H12(33),ex2(:),G1H6(94),ngPbt,m3h2x6(:,96),heltab2x12(:,:,125))
  call Hloop_QA_W(ntryL,G1H12(34),ex2(:),G1H6(97),m3h2x6(:,97),heltab2x12(:,:,126))
  call Hloop_QA_W(ntryL,G1H12(35),ex2(:),G1H6(98),m3h2x6(:,98),heltab2x12(:,:,127))
  call Hloop_QA_W(ntryL,G1H12(36),ex2(:),G1H6(99),m3h2x6(:,99),heltab2x12(:,:,128))
  call Hloop_AV_Q(ntryL,G1H12(37),ex3(:),G1H6(100),m3h2x6(:,100),heltab2x12(:,:,129))
  call Hloop_A_Q(ntryL,G1H6(100),22,nMB,G2H6(5),n2h6(103))
  call Hloop_AV_Q(ntryL,G1H12(38),ex3(:),G1H6(103),m3h2x6(:,101),heltab2x12(:,:,130))
  call Hloop_A_Q(ntryL,G1H6(103),22,nMB,G2H6(6),n2h6(104))
  call Hloop_AV_Q(ntryL,G1H12(39),ex3(:),G1H6(104),m3h2x6(:,102),heltab2x12(:,:,131))
  call Hloop_A_Q(ntryL,G1H6(104),22,nMT,G2H6(7),n2h6(105))
  call Hloop_SV_T(ntryL,G0H12(19),18,ex3(:),4,G1H6(105),m3h2x6(:,103),heltab2x12(:,:,132))
  call Hloop_AV_Q(ntryL,G1H12(40),ex3(:),G1H6(106),m3h2x6(:,104),heltab2x12(:,:,133))
  call Hloop_A_Q(ntryL,G1H6(106),22,nMB,G2H6(11),n2h6(106))
  call Hloop_AV_Q(ntryL,G1H12(41),ex3(:),G1H6(109),m3h2x6(:,105),heltab2x12(:,:,134))
  call Hloop_A_Q(ntryL,G1H6(109),22,nMT,G2H6(12),n2h6(107))
  call Hloop_AV_Q(ntryL,G1H12(42),ex3(:),G1H6(110),m3h2x6(:,106),heltab2x12(:,:,135))
  call Hloop_A_Q(ntryL,G1H6(110),22,nMB,G2H6(10),n2h6(108))
  call Hloop_AV_Q(ntryL,G1H12(43),ex3(:),G1H6(111),m3h2x6(:,107),heltab2x12(:,:,136))
  call Hloop_A_Q(ntryL,G1H6(111),22,nMT,G2H6(13),n2h6(109))
  call Hloop_VV_S(ntryL,G0H12(20),ex3(:),G0H6(3),m3h2x6(:,108),heltab2x12(:,:,137))
  call Hloop_SV_V(ntryL,G0H12(21),ex3(:),G0H6(4),m3h2x6(:,109),heltab2x12(:,:,138))
  call Hloop_AV_Q(ntryL,G1H12(44),ex3(:),G1H6(112),m3h2x6(:,110),heltab2x12(:,:,139))
  call Hloop_A_Q(ntryL,G1H6(112),22,nMT,G2H6(14),n2h6(110))
  call Hloop_UW_V(ntryL,G0H12(22),18,ex3(:),4,G1H6(115),m3h2x6(:,111),heltab2x12(:,:,140))
  call Hloop_SQ_A(ntryL,G0H12(23),ex1(:),G0H6(5),ngH,m3h2x6(:,112),heltab2x12(:,:,141))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMB,G1H6(116),n2h6(111))
  call Hloop_SQ_A(ntryL,G0H12(24),ex1(:),G0H6(5),ngX,m3h2x6(:,113),heltab2x12(:,:,142))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMB,G1H6(117),n2h6(112))
  call Hloop_SQ_A(ntryL,G0H12(25),ex1(:),G0H6(5),ngPtb,m3h2x6(:,114),heltab2x12(:,:,143))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMT,G1H6(118),n2h6(113))
  call Hloop_AQ_S(ntryL,G1H12(45),ex1(:),G1H6(121),ngPtb,m3h2x6(:,115),heltab2x12(:,:,144))
  call Hloop_VQ_A(ntryL,G0H12(29),ex1(:),G0H6(5),m3h2x6(:,116),heltab2x12(:,:,145))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMB,G1H6(122),n2h6(114))
  call Hloop_ZQ_A(ntryL,G0H12(27),ex1(:),G0H6(5),ngZd,m3h2x6(:,117),heltab2x12(:,:,146))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMB,G1H6(123),n2h6(115))
  call Hloop_WQ_A(ntryL,G0H12(28),ex1(:),G0H6(5),m3h2x6(:,118),heltab2x12(:,:,147))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMT,G1H6(124),n2h6(116))
  call Hloop_AQ_S(ntryL,G1H12(46),ex1(:),G1H6(127),ngPtb,m3h2x6(:,119),heltab2x12(:,:,148))
  call Hloop_AQ_S(ntryL,G1H12(47),ex1(:),G1H6(128),ngPtb,m3h2x6(:,120),heltab2x12(:,:,149))
  call Hloop_AQ_W(ntryL,G1H12(48),ex1(:),G1H6(129),m3h2x6(:,121),heltab2x12(:,:,150))
  call Hloop_AQ_S(ntryL,G1H12(49),ex1(:),G1H6(130),ngPtb,m3h2x6(:,122),heltab2x12(:,:,151))
  call Hloop_AQ_W(ntryL,G1H12(50),ex1(:),G1H6(133),m3h2x6(:,123),heltab2x12(:,:,152))
  call Hloop_AQ_W(ntryL,G1H12(51),ex1(:),G1H6(134),m3h2x6(:,124),heltab2x12(:,:,153))
  call Hloop_AQ_W(ntryL,G1H12(52),ex1(:),G1H6(135),m3h2x6(:,125),heltab2x12(:,:,154))
  call Hloop_SQ_A(ntryL,G0H12(30),ex1(:),G0H6(5),ngH,m3h2x6(:,126),heltab2x12(:,:,155))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMB,G1H6(136),n2h6(117))
  call Hloop_SQ_A(ntryL,G0H12(31),ex1(:),G0H6(5),ngX,m3h2x6(:,127),heltab2x12(:,:,156))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMB,G1H6(139),n2h6(118))
  call Hloop_SQ_A(ntryL,G0H12(32),ex1(:),G0H6(5),ngPtb,m3h2x6(:,128),heltab2x12(:,:,157))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMT,G1H6(140),n2h6(119))
  call Hloop_AQ_S(ntryL,G1H12(53),ex1(:),G1H6(141),ngPtb,m3h2x6(:,129),heltab2x12(:,:,158))
  call Hloop_VQ_A(ntryL,G0H12(36),ex1(:),G0H6(5),m3h2x6(:,130),heltab2x12(:,:,159))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMB,G1H6(142),n2h6(120))
  call Hloop_ZQ_A(ntryL,G0H12(34),ex1(:),G0H6(5),ngZd,m3h2x6(:,131),heltab2x12(:,:,160))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMB,G1H6(145),n2h6(121))
  call Hloop_WQ_A(ntryL,G0H12(35),ex1(:),G0H6(5),m3h2x6(:,132),heltab2x12(:,:,161))
  call Hloop_Q_A(ntryL,G0H6(5),19,nMT,G1H6(146),n2h6(122))
  call Hloop_AQ_S(ntryL,G1H12(54),ex1(:),G1H6(147),ngPtb,m3h2x6(:,133),heltab2x12(:,:,162))
  call Hloop_AQ_S(ntryL,G1H12(55),ex1(:),G1H6(148),ngPtb,m3h2x6(:,134),heltab2x12(:,:,163))
  call Hloop_AQ_W(ntryL,G1H12(56),ex1(:),G1H6(151),m3h2x6(:,135),heltab2x12(:,:,164))
  call Hloop_AQ_S(ntryL,G1H12(57),ex1(:),G1H6(152),ngPtb,m3h2x6(:,136),heltab2x12(:,:,165))
  call Hloop_AQ_W(ntryL,G1H12(58),ex1(:),G1H6(153),m3h2x6(:,137),heltab2x12(:,:,166))
  call Hloop_AQ_W(ntryL,G1H12(59),ex1(:),G1H6(154),m3h2x6(:,138),heltab2x12(:,:,167))
  call Hloop_AQ_W(ntryL,G1H12(60),ex1(:),G1H6(157),m3h2x6(:,139),heltab2x12(:,:,168))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(122),[G1H6(59)])
call HGT_w2_OLR(G1H6(9),1,1,6)
call HGT_w2_invQ_OLR(G1H6(9),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(9),[G1H6(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(46),[G1H6(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(142),[G1H6(119)])
call HGT_w2_OLR(G1H6(10),1,1,6)
call HGT_w2_invQ_OLR(G1H6(10),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(10),[G1H6(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(26),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(27),[G1H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(28),[G1H6(186),G1H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(31),[G1H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(32),[G1H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(33),[G1H6(192),G1H6(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(116),[G1H6(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(21),[G1H6(60),G1H6(48),G1H6(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(123),[G1H6(117),G1H6(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(124),[G1H6(118),G1H6(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(48),[G1H6(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(34),[G1H6(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(37),[G1H6(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(38),[G1H6(174),G1H6(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(39),[G1H6(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(40),[G1H6(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(43),[G1H6(180),G1H6(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(136),[G1H6(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(41),[G1H6(120),G1H6(108),G1H6(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(145),[G1H6(139),G1H6(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(146),[G1H6(140),G1H6(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(37),[G1H6(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(58),[G1H6(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(9),[G1H6(144),G1H6(132),G1H6(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(67),[G1H6(61),G1H6(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(68),[G1H6(62),G1H6(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(45),[G1H6(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(64),[G1H6(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(80),[G1H6(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(42),[G1H6(168),G1H6(156),G1H6(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(87),[G1H6(81),G1H6(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(88),[G1H6(82),G1H6(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(39),[G1H6(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(86),[G1H6(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(105),[G1H6(173),G0H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(115),[G1H6(179),G0H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(49),[G1H6(185),G0H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(57),[G1H6(191),G0H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(36),[G1H6(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(63)])
  call Hloop_QV_A(ntryL,G1H6(9),ex3(:),G1H3(9),m3h2x3(:,86),heltab2x6(:,:,147))
  call Hloop_Q_A(ntryL,G1H3(9),23,nMB,G2H3(4),n2h3(73))
  call Hotf_4pt_reduction(G2H6(46),RedSet_4(11),mass4set(:,1),  & 
G1H6(158),G1H6(159),G1H6(160),G1H6(163),G1H6(164),6)
  call HG1shiftOLR(G1H6(159),2,6)
  call Hloop_QZ_A(ntryL,G1H6(10),ex4(:),G1H2(9),ngZd,m3h3x2(:,62),heltab2x6(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(9),27,nMB,G2H2(1),n2h2(61))
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(14),mass4set(:,1),  & 
G1H4(66),G1H4(13),G1H4(1),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(13),2,4)
  call Hloop_SA_Q(ntryL,G1H6(4),ex2(:),G1H3(20),ngH,m3h2x3(:,87),heltab2x6(:,:,149))
  call Hloop_A_Q(ntryL,G1H3(20),23,nMB,G2H3(6),n2h3(74))
  call Hloop_SA_Q(ntryL,G1H6(26),ex2(:),G1H3(31),ngH,m3h2x3(:,88),heltab2x6(:,:,150))
  call Hloop_A_Q(ntryL,G1H3(31),23,nMB,G2H3(7),n2h3(75))
  call Hloop_SA_Q(ntryL,G1H6(11),ex2(:),G1H3(42),ngX,m3h2x3(:,89),heltab2x6(:,:,151))
  call Hloop_A_Q(ntryL,G1H3(42),23,nMB,G2H3(9),n2h3(76))
  call Hloop_SA_Q(ntryL,G1H6(27),ex2(:),G1H3(53),ngX,m3h2x3(:,90),heltab2x6(:,:,152))
  call Hloop_A_Q(ntryL,G1H3(53),23,nMB,G2H3(34),n2h3(77))
  call Hloop_SA_Q(ntryL,G1H6(17),ex2(:),G1H3(64),ngPbt,m3h2x3(:,91),heltab2x6(:,:,153))
  call Hloop_A_Q(ntryL,G1H3(64),23,nMT,G2H3(36),n2h3(78))
  call Hloop_SA_Q(ntryL,G1H6(28),ex2(:),G1H3(75),ngPbt,m3h2x3(:,92),heltab2x6(:,:,154))
  call Hloop_A_Q(ntryL,G1H3(75),23,nMT,G2H3(37),n2h3(79))
  call Hloop_VA_Q(ntryL,G1H6(23),ex2(:),G1H3(86),m3h2x3(:,93),heltab2x6(:,:,155))
  call Hloop_A_Q(ntryL,G1H3(86),23,nMB,G2H3(39),n2h3(80))
  call Hloop_VA_Q(ntryL,G1H6(31),ex2(:),G1H3(97),m3h2x3(:,94),heltab2x6(:,:,156))
  call Hloop_A_Q(ntryL,G1H3(97),23,nMB,G2H3(69),n2h3(81))
  call Hloop_ZA_Q(ntryL,G1H6(29),ex2(:),G1H3(108),ngZd,m3h2x3(:,95),heltab2x6(:,:,157))
  call Hloop_A_Q(ntryL,G1H3(108),23,nMB,G2H3(71),n2h3(82))
  call Hloop_ZA_Q(ntryL,G1H6(32),ex2(:),G1H3(119),ngZd,m3h2x3(:,96),heltab2x6(:,:,158))
  call Hloop_A_Q(ntryL,G1H3(119),23,nMB,G2H3(75),n2h3(83))
  call Hloop_WA_Q(ntryL,G1H6(35),ex2(:),G1H3(130),m3h2x3(:,97),heltab2x6(:,:,159))
  call Hloop_A_Q(ntryL,G1H3(130),23,nMT,G2H3(77),n2h3(84))
  call Hloop_WA_Q(ntryL,G1H6(33),ex2(:),G1H3(141),m3h2x3(:,98),heltab2x6(:,:,160))
  call Hloop_A_Q(ntryL,G1H3(141),23,nMT,G2H3(1),n2h3(85))
  call Hloop_QV_A(ntryL,G1H6(116),ex3(:),G1H3(152),m3h2x3(:,99),heltab2x6(:,:,161))
  call Hloop_Q_A(ntryL,G1H3(152),23,nMB,G2H3(3),n2h3(86))
  call Hotf_4pt_reduction(G2H6(21),RedSet_4(29),mass4set(:,13),  & 
G1H6(165),G1H6(166),G1H6(169),G1H6(170),G1H6(171),G0H6(5),6)
  call HG1shiftOLR(G1H6(166),8,6)
  call Hloop_QV_A(ntryL,G1H6(123),ex3(:),G1H3(163),m3h2x3(:,100),heltab2x6(:,:,162))
  call Hloop_Q_A(ntryL,G1H3(163),23,nMB,G2H3(13),n2h3(87))
  call Hloop_QV_A(ntryL,G1H6(124),ex3(:),G1H3(174),m3h2x3(:,101),heltab2x6(:,:,163))
  call Hloop_Q_A(ntryL,G1H3(174),23,nMT,G2H3(15),n2h3(88))
  call Hotf_4pt_reduction(G2H6(48),RedSet_4(29),mass4set(:,14),  & 
G1H6(172),G1H6(175),G1H6(176),G1H6(177),G1H6(178),G0H6(3),6)
  call HG1shiftOLR(G1H6(175),8,6)
  call Hloop_SQ_A(ntryL,G1H6(65),ex1(:),G1H3(185),ngH,m3h2x3(:,102),heltab2x6(:,:,164))
  call Hloop_Q_A(ntryL,G1H3(185),23,nMB,G2H3(16),n2h3(89))
  call Hloop_SQ_A(ntryL,G1H6(34),ex1(:),G1H3(196),ngH,m3h2x3(:,103),heltab2x6(:,:,165))
  call Hloop_Q_A(ntryL,G1H3(196),23,nMB,G2H3(18),n2h3(90))
  call Hloop_SQ_A(ntryL,G1H6(71),ex1(:),G1H3(4),ngX,m3h2x3(:,104),heltab2x6(:,:,166))
  call Hloop_Q_A(ntryL,G1H3(4),23,nMB,G2H3(10),n2h3(91))
  call Hloop_SQ_A(ntryL,G1H6(37),ex1(:),G1H3(5),ngX,m3h2x3(:,105),heltab2x6(:,:,167))
  call Hloop_Q_A(ntryL,G1H3(5),23,nMB,G2H3(12),n2h3(92))
  call Hloop_SQ_A(ntryL,G1H6(77),ex1(:),G1H3(10),ngPtb,m3h2x3(:,106),heltab2x6(:,:,168))
  call Hloop_Q_A(ntryL,G1H3(10),23,nMT,G2H3(19),n2h3(93))
  call Hloop_SQ_A(ntryL,G1H6(38),ex1(:),G1H3(11),ngPtb,m3h2x3(:,107),heltab2x6(:,:,169))
  call Hloop_Q_A(ntryL,G1H3(11),23,nMT,G2H3(21),n2h3(94))
  call Hloop_VQ_A(ntryL,G1H6(83),ex1(:),G1H3(15),m3h2x3(:,108),heltab2x6(:,:,170))
  call Hloop_Q_A(ntryL,G1H3(15),23,nMB,G2H3(22),n2h3(95))
  call Hloop_VQ_A(ntryL,G1H6(39),ex1(:),G1H3(16),m3h2x3(:,109),heltab2x6(:,:,171))
  call Hloop_Q_A(ntryL,G1H3(16),23,nMB,G2H3(24),n2h3(96))
  call Hloop_ZQ_A(ntryL,G1H6(89),ex1(:),G1H3(21),ngZd,m3h2x3(:,110),heltab2x6(:,:,172))
  call Hloop_Q_A(ntryL,G1H3(21),23,nMB,G2H3(25),n2h3(97))
  call Hloop_ZQ_A(ntryL,G1H6(40),ex1(:),G1H3(22),ngZd,m3h2x3(:,111),heltab2x6(:,:,173))
  call Hloop_Q_A(ntryL,G1H3(22),23,nMB,G2H3(27),n2h3(98))
  call Hloop_WQ_A(ntryL,G1H6(95),ex1(:),G1H3(26),m3h2x3(:,112),heltab2x6(:,:,174))
  call Hloop_Q_A(ntryL,G1H3(26),23,nMT,G2H3(28),n2h3(99))
  call Hloop_WQ_A(ntryL,G1H6(43),ex1(:),G1H3(27),m3h2x3(:,113),heltab2x6(:,:,175))
  call Hloop_Q_A(ntryL,G1H3(27),23,nMT,G2H3(30),n2h3(100))
  call Hloop_QZ_A(ntryL,G1H6(136),ex4(:),G1H2(15),ngZd,m3h3x2(:,63),heltab2x6(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(15),27,nMB,G2H2(2),n2h2(62))
  call Hotf_4pt_reduction(G2H6(41),RedSet_4(36),mass4set(:,13),  & 
G1H6(181),G1H6(182),G1H6(183),G1H6(184),G1H6(187),G0H6(4),6)
  call HG1shiftOLR(G1H6(182),4,6)
  call Hloop_QZ_A(ntryL,G1H6(145),ex4(:),G1H2(21),ngZd,m3h3x2(:,64),heltab2x6(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(21),27,nMB,G2H2(3),n2h2(63))
  call Hloop_QZ_A(ntryL,G1H6(146),ex4(:),G1H2(27),ngZu,m3h3x2(:,65),heltab2x6(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(27),27,nMT,G2H2(4),n2h2(64))
  call Hotf_4pt_reduction(G2H6(37),RedSet_4(36),mass4set(:,14),  & 
G1H6(188),G1H6(189),G1H6(190),G1H6(193),G1H6(194),G0H6(1),6)
  call HG1shiftOLR(G1H6(189),4,6)
  call Hloop_AV_Q(ntryL,G1H6(58),ex3(:),G1H3(32),m3h2x3(:,114),heltab2x6(:,:,179))
  call Hloop_A_Q(ntryL,G1H3(32),23,nMB,G2H3(31),n2h3(101))
  call Hotf_4pt_reduction(G2H6(9),RedSet_4(29),mass4set(:,13),  & 
G1H6(195),G1H6(196),G1H6(199),G1H6(200),G1H6(201),G0H6(2),6)
  call HG1shiftOLR(G1H6(196),8,6)
  call Hloop_AV_Q(ntryL,G1H6(67),ex3(:),G1H3(33),m3h2x3(:,115),heltab2x6(:,:,180))
  call Hloop_A_Q(ntryL,G1H3(33),23,nMB,G2H3(33),n2h3(102))
  call Hloop_AV_Q(ntryL,G1H6(68),ex3(:),G1H3(37),m3h2x3(:,116),heltab2x6(:,:,181))
  call Hloop_A_Q(ntryL,G1H3(37),23,nMT,G2H3(43),n2h3(103))
  call Hotf_4pt_reduction(G2H6(45),RedSet_4(29),mass4set(:,14),  & 
G1H6(202),G1H6(205),G1H6(206),G1H6(207),G1H6(208),G0H6(6),6)
  call HG1shiftOLR(G1H6(205),8,6)
  call Hloop_AV_Q(ntryL,G1H6(64),ex3(:),G1H3(38),m3h2x3(:,117),heltab2x6(:,:,182))
  call Hloop_A_Q(ntryL,G1H3(38),23,nMB,G2H3(45),n2h3(104))
  call Hloop_AZ_Q(ntryL,G1H6(80),ex4(:),G1H2(33),ngZd,m3h3x2(:,66),heltab2x6(:,:,183))
  call Hloop_A_Q(ntryL,G1H2(33),27,nMB,G2H2(5),n2h2(65))
  call Hotf_4pt_reduction(G2H6(42),RedSet_4(36),mass4set(:,13),  & 
G1H6(213),G1H6(218),G1H6(214),G1H6(217),G1H6(219),G0H6(7),6)
  call HG1shiftOLR(G1H6(218),4,6)
  call Hloop_AZ_Q(ntryL,G1H6(87),ex4(:),G1H2(39),ngZd,m3h3x2(:,67),heltab2x6(:,:,184))
  call Hloop_A_Q(ntryL,G1H2(39),27,nMB,G2H2(6),n2h2(66))
  call Hloop_AZ_Q(ntryL,G1H6(88),ex4(:),G1H2(45),ngZu,m3h3x2(:,68),heltab2x6(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(45),27,nMT,G2H2(61),n2h2(67))
  call Hotf_4pt_reduction(G2H6(39),RedSet_4(36),mass4set(:,14),  & 
G1H6(222),G1H6(211),G1H6(212),G1H6(1),G1H6(2),G0H6(8),6)
  call HG1shiftOLR(G1H6(211),4,6)
  call Hloop_AZ_Q(ntryL,G1H6(86),ex4(:),G1H2(56),ngZd,m3h3x2(:,69),heltab2x6(:,:,186))
  call Hloop_A_Q(ntryL,G1H2(56),27,nMB,G2H2(64),n2h2(68))
  call Hloop_SQ_A(ntryL,G1H6(105),ex1(:),G1H3(43),ngPtb,m3h2x3(:,118),heltab2x6(:,:,187))
  call Hloop_Q_A(ntryL,G1H3(43),23,nMT,G2H3(46),n2h3(105))
  call Hloop_WQ_A(ntryL,G1H6(115),ex1(:),G1H3(44),m3h2x3(:,119),heltab2x6(:,:,188))
  call Hloop_Q_A(ntryL,G1H3(44),23,nMT,G2H3(48),n2h3(106))
  call Hloop_SQ_A(ntryL,G1H4(2),ex1(:),G1H2(67),ngH,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(67),27,nMB,G2H2(85),n2h2(69))
  call Hloop_SQ_A(ntryL,G1H4(4),ex1(:),G1H2(78),ngH,m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(78),27,nMB,G2H2(88),n2h2(70))
  call Hloop_SQ_A(ntryL,G1H4(9),ex1(:),G1H2(89),ngX,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(89),27,nMB,G2H2(57),n2h2(71))
  call Hloop_SQ_A(ntryL,G1H4(12),ex1(:),G1H2(100),ngX,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(100),27,nMB,G2H2(71),n2h2(72))
  call Hloop_SQ_A(ntryL,G1H4(17),ex1(:),G1H2(111),ngPtb,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(111),27,nMT,G2H2(74),n2h2(73))
  call Hloop_SQ_A(ntryL,G1H4(18),ex1(:),G1H2(122),ngPtb,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(122),27,nMT,G2H2(77),n2h2(74))
  call Hloop_WQ_A(ntryL,G1H4(22),ex1(:),G1H2(133),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(133),27,nMT,G2H2(93),n2h2(75))
  call Hloop_WQ_A(ntryL,G1H4(23),ex1(:),G1H2(149),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(149),27,nMT,G2H2(97),n2h2(76))
  call Hloop_SA_Q(ntryL,G1H6(49),ex2(:),G1H3(48),ngPbt,m3h2x3(:,120),heltab2x6(:,:,189))
  call Hloop_A_Q(ntryL,G1H3(48),23,nMT,G2H3(40),n2h3(107))
  call Hloop_WA_Q(ntryL,G1H6(57),ex2(:),G1H3(49),m3h2x3(:,121),heltab2x6(:,:,190))
  call Hloop_A_Q(ntryL,G1H3(49),23,nMT,G2H3(42),n2h3(108))
  call Hloop_TV_S(ntryL,G1H6(197),21,ex4(:),8,G2H2(23),m3h3x2(:,70),heltab2x6(:,:,191))
  call Hloop_TV_S(ntryL,G1H6(198),21,ex4(:),8,G2H2(25),m3h3x2(:,71),heltab2x6(:,:,192))
  call Hloop_UV_W(ntryL,G1H6(203),21,ex4(:),8,G2H2(26),m3h3x2(:,72),heltab2x6(:,:,193))
  call Hloop_UV_W(ntryL,G1H6(204),21,ex4(:),8,G2H2(28),m3h3x2(:,73),heltab2x6(:,:,194))
  call Hloop_SA_Q(ntryL,G1H4(28),ex2(:),G1H2(175),ngX,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(175),27,nMB,G2H2(29),n2h2(77))
  call Hloop_SA_Q(ntryL,G1H4(29),ex2(:),G1H2(186),ngX,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(186),27,nMB,G2H2(31),n2h2(78))
  call Hloop_SA_Q(ntryL,G1H4(34),ex2(:),G1H2(4),ngH,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(4),27,nMB,G2H2(32),n2h2(79))
  call Hloop_SA_Q(ntryL,G1H4(35),ex2(:),G1H2(5),ngH,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(5),27,nMB,G2H2(34),n2h2(80))
  call Hloop_SA_Q(ntryL,G1H4(40),ex2(:),G1H2(139),ngPbt,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(139),27,nMT,G2H2(39),n2h2(81))
  call Hloop_SA_Q(ntryL,G1H4(41),ex2(:),G1H2(10),ngPbt,m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(10),27,nMT,G2H2(41),n2h2(82))
  call Hloop_WA_Q(ntryL,G1H4(45),ex2(:),G1H2(11),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(11),27,nMT,G2H2(42),n2h2(83))
  call Hloop_WA_Q(ntryL,G1H4(46),ex2(:),G1H2(155),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(155),27,nMT,G2H2(44),n2h2(84))
  call Hloop_TV_S(ntryL,G1H4(51),25,ex3(:),4,G2H2(45),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_TV_S(ntryL,G1H4(52),25,ex3(:),4,G2H2(47),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_UV_W(ntryL,G1H4(57),25,ex3(:),4,G2H2(48),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_UV_W(ntryL,G1H4(58),25,ex3(:),4,G2H2(50),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hotf_4pt_reduction(G2H6(36),RedSet_4(10),mass4set(:,15),  & 
G1H6(6),G1H6(5),G1H6(8),G1H6(7),G1H6(13),6)
  call HG1shiftOLR(G1H6(5),2,6)
  call Hloop_QZ_A(ntryL,G1H6(215),ex4(:),G1H2(16),ngZd,m3h3x2(:,74),heltab2x6(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMB,G2H2(53),n2h2(85))
  call Hloop_QZ_A(ntryL,G1H6(216),ex4(:),G1H2(17),ngZd,m3h3x2(:,75),heltab2x6(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(17),29,nMB,G2H2(56),n2h2(86))
  call Hloop_QZ_A(ntryL,G1H6(220),ex4(:),G1H2(160),ngZd,m3h3x2(:,76),heltab2x6(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(160),29,nMB,G2H2(60),n2h2(87))
  call Hloop_QZ_A(ntryL,G1H6(221),ex4(:),G1H2(22),ngZd,m3h3x2(:,77),heltab2x6(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(22),29,nMB,G2H2(65),n2h2(88))
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(13),mass4set(:,15),  & 
G1H4(6),G1H4(10),G1H4(11),G1H4(14),G1H4(15),4)
  call HG1shiftOLR(G1H4(10),2,4)
  call Hloop_QV_A(ntryL,G1H4(69),ex3(:),G1H2(23),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(23),29,nMB,G2H2(68),n2h2(89))
  call Hloop_QV_A(ntryL,G1H4(70),ex3(:),G1H2(165),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(165),29,nMB,G2H2(73),n2h2(90))
  call Hloop_QV_A(ntryL,G1H4(74),ex3(:),G1H2(28),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(28),29,nMB,G2H2(76),n2h2(91))
  call Hloop_QV_A(ntryL,G1H4(75),ex3(:),G1H2(29),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(29),29,nMB,G2H2(80),n2h2(92))
  call Hloop_SVV_S(ntryL,G1H12(61),ex4(:),ex3(:),G1H2(192),m4h3x2x2(:,1),heltab3x12(:,:,1))
  call Hloop_VWW_V(ntryL,G1H12(62),ex4(:),ex3(:),G1H2(34),m4h3x2x2(:,2),heltab3x12(:,:,2))
  call Hotf_4pt_reduction(G2H6(34),RedSet_4(36),mass4set(:,16),  & 
G1H6(14),G1H6(15),G1H6(16),G1H6(19),G1H6(20),G0H6(9),6)
  call HG1shiftOLR(G1H6(15),4,6)
  call Hotf_4pt_reduction(G2H6(38),RedSet_4(36),mass4set(:,16),  & 
G1H6(21),G1H6(22),G1H6(25),G1H6(44),G1H6(45),G0H6(10),6)
  call HG1shiftOLR(G1H6(22),4,6)
  call Hotf_4pt_reduction(G2H6(40),RedSet_4(36),mass4set(:,16),  & 
G1H6(46),G1H6(50),G1H6(51),G1H6(52),G1H6(55),G0H6(11),6)
  call HG1shiftOLR(G1H6(50),4,6)
  call Hotf_4pt_reduction(G2H6(43),RedSet_4(36),mass4set(:,16),  & 
G1H6(56),G1H6(100),G1H6(103),G1H6(104),G1H6(106),G0H6(12),6)
  call HG1shiftOLR(G1H6(100),4,6)
  call Hotf_4pt_reduction(G2H6(44),RedSet_4(29),mass4set(:,16),  & 
G1H6(109),G1H6(110),G1H6(111),G1H6(112),G1H6(59),G0H6(13),6)
  call HG1shiftOLR(G1H6(110),8,6)
  call Hotf_4pt_reduction(G2H6(47),RedSet_4(29),mass4set(:,16),  & 
G1H6(122),G1H6(210),G1H6(119),G1H6(142),G1H6(3),G0H6(14),6)
  call HG1shiftOLR(G1H6(210),8,6)
  call Hotf_4pt_reduction(G2H6(8),RedSet_4(29),mass4set(:,16),  & 
G1H6(12),G1H6(186),G1H6(18),G1H6(24),G1H6(30),G0H6(15),6)
  call HG1shiftOLR(G1H6(186),8,6)
  call Hotf_4pt_reduction(G2H6(20),RedSet_4(29),mass4set(:,16),  & 
G1H6(192),G1H6(36),G1H6(41),G1H6(60),G1H6(48),G0H6(16),6)
  call HG1shiftOLR(G1H6(36),8,6)
  call Hotf_4pt_reduction(G2H12(1),RedSet_4(26),mass4set(:,16),  & 
G1H12(13),G1H12(14),G1H12(15),G1H12(16),G1H12(17),G0H12(37),12)
  call HG1shiftOLR(G1H12(14),8,12)
  call Hotf_4pt_reduction(G2H12(2),RedSet_4(26),mass4set(:,14),  & 
G1H12(18),G1H12(19),G1H12(20),G1H12(21),G1H12(22),G0H12(8),12)
  call HG1shiftOLR(G1H12(19),8,12)
  call Hotf_4pt_reduction(G2H12(3),RedSet_4(26),mass4set(:,16),  & 
G1H12(23),G1H12(24),G1H12(25),G1H12(26),G1H12(27),G0H12(15),12)
  call HG1shiftOLR(G1H12(24),8,12)
  call Hotf_4pt_reduction(G2H12(4),RedSet_4(26),mass4set(:,14),  & 
G1H12(28),G1H12(29),G1H12(30),G1H12(31),G1H12(32),G0H12(26),12)
  call HG1shiftOLR(G1H12(29),8,12)
  call Hotf_4pt_reduction(G2H12(5),RedSet_4(26),mass4set(:,16),  & 
G1H12(33),G1H12(34),G1H12(35),G1H12(36),G1H12(37),G0H12(33),12)
  call HG1shiftOLR(G1H12(34),8,12)
  call Hotf_4pt_reduction(G2H12(6),RedSet_4(26),mass4set(:,13),  & 
G1H12(38),G1H12(39),G1H12(40),G1H12(41),G1H12(42),G0H12(1),12)
  call HG1shiftOLR(G1H12(39),8,12)
  call Hotf_4pt_reduction(G2H12(7),RedSet_4(26),mass4set(:,16),  & 
G1H12(43),G1H12(44),G1H12(45),G1H12(46),G1H12(47),G0H12(2),12)
  call HG1shiftOLR(G1H12(44),8,12)
  call Hotf_4pt_reduction(G2H12(8),RedSet_4(26),mass4set(:,13),  & 
G1H12(48),G1H12(49),G1H12(50),G1H12(51),G1H12(52),G0H12(3),12)
  call HG1shiftOLR(G1H12(49),8,12)
  call Hloop_TV_S(ntryL,G1H12(8),18,ex4(:),8,G2H4(12),m3h3x4(:,30),heltab2x12(:,:,169))
  call Hloop_SV_T(ntryL,G1H12(10),18,ex4(:),8,G2H4(13),m3h3x4(:,31),heltab2x12(:,:,170))
  call Hloop_SV_T(ntryL,G1H12(11),18,ex4(:),8,G2H4(15),m3h3x4(:,32),heltab2x12(:,:,171))
  call Hloop_SV_V(ntryL,G1H12(12),ex4(:),G1H4(16),m3h3x4(:,33),heltab2x12(:,:,172))
  call Hloop_SV_V(ntryL,G1H12(3),ex4(:),G1H4(19),m3h3x4(:,34),heltab2x12(:,:,173))
  call Hloop_VV_S(ntryL,G1H12(9),ex4(:),G1H4(20),m3h3x4(:,35),heltab2x12(:,:,174))
  call Hloop_VV_S(ntryL,G1H12(63),ex4(:),G1H4(3),m3h3x4(:,36),heltab2x12(:,:,175))
  call Hotf_4pt_reduction(G2H12(9),RedSet_4(9),mass4set(:,1),  & 
G1H12(53),G1H12(54),G1H12(55),G1H12(56),G1H12(57),12)
  call HG1shiftOLR(G1H12(54),5,12)
  call Hloop_UW_V(ntryL,G1H12(1),18,ex4(:),8,G2H4(16),m3h3x4(:,37),heltab2x12(:,:,176))
  call Hloop_SQ_A(ntryL,G1H12(2),wf4(:,2),G1H3(54),ngH,m3h4x3(:,1),heltab2x12(:,:,177))
  call Hloop_Q_A(ntryL,G1H3(54),23,nMB,G2H3(53),n2h3(109))
  call Hloop_SQ_A(ntryL,G1H12(4),wf4(:,2),G1H3(55),ngX,m3h4x3(:,2),heltab2x12(:,:,178))
  call Hloop_Q_A(ntryL,G1H3(55),23,nMB,G2H3(55),n2h3(110))
  call Hloop_SQ_A(ntryL,G1H12(5),wf4(:,2),G1H3(59),ngPtb,m3h4x3(:,3),heltab2x12(:,:,179))
  call Hloop_Q_A(ntryL,G1H3(59),23,nMT,G2H3(56),n2h3(111))
  call Hloop_VQ_A(ntryL,G1H12(6),wf4(:,2),G1H3(60),m3h4x3(:,4),heltab2x12(:,:,180))
  call Hloop_Q_A(ntryL,G1H3(60),23,nMB,G2H3(58),n2h3(112))
  call Hloop_ZQ_A(ntryL,G1H12(7),wf4(:,2),G1H3(65),ngZd,m3h4x3(:,5),heltab2x12(:,:,181))
  call Hloop_Q_A(ntryL,G1H3(65),23,nMB,G2H3(59),n2h3(113))
  call Hloop_WQ_A(ntryL,G1H12(64),wf4(:,2),G1H3(66),m3h4x3(:,6),heltab2x12(:,:,182))
  call Hloop_Q_A(ntryL,G1H3(66),23,nMT,G2H3(61),n2h3(114))
  call Hloop_TV_S(ntryL,G1H12(65),17,ex4(:),8,G2H4(1),m3h3x4(:,38),heltab2x12(:,:,183))
  call Hloop_SV_T(ntryL,G1H12(66),17,ex4(:),8,G2H4(2),m3h3x4(:,39),heltab2x12(:,:,184))
  call Hloop_TV_S(ntryL,G1H12(67),17,ex4(:),8,G2H4(3),m3h3x4(:,40),heltab2x12(:,:,185))
  call Hloop_SV_V(ntryL,G1H12(68),ex4(:),G1H4(21),m3h3x4(:,41),heltab2x12(:,:,186))
  call Hloop_SV_V(ntryL,G1H12(69),ex4(:),G1H4(24),m3h3x4(:,42),heltab2x12(:,:,187))
  call Hloop_VV_S(ntryL,G1H12(70),ex4(:),G1H4(25),m3h3x4(:,43),heltab2x12(:,:,188))
  call Hloop_VV_S(ntryL,G1H12(71),ex4(:),G1H4(26),m3h3x4(:,44),heltab2x12(:,:,189))
  call Hotf_4pt_reduction(G2H12(10),RedSet_4(3),mass4set(:,1),  & 
G1H12(58),G1H12(59),G1H12(60),G1H12(61),G1H12(62),12)
  call HG1shiftOLR(G1H12(59),6,12)
  call Hloop_UV_W(ntryL,G1H12(72),17,ex4(:),8,G2H4(4),m3h3x4(:,45),heltab2x12(:,:,190))
  call Hloop_SA_Q(ntryL,G1H12(73),wf4(:,6),G1H3(70),ngH,m3h4x3(:,7),heltab2x12(:,:,191))
  call Hloop_A_Q(ntryL,G1H3(70),23,nMB,G2H3(62),n2h3(115))
  call Hloop_SA_Q(ntryL,G1H12(74),wf4(:,6),G1H3(71),ngX,m3h4x3(:,8),heltab2x12(:,:,192))
  call Hloop_A_Q(ntryL,G1H3(71),23,nMB,G2H3(64),n2h3(116))
  call Hloop_SA_Q(ntryL,G1H12(75),wf4(:,6),G1H3(76),ngPbt,m3h4x3(:,9),heltab2x12(:,:,193))
  call Hloop_A_Q(ntryL,G1H3(76),23,nMT,G2H3(72),n2h3(117))
  call Hloop_VA_Q(ntryL,G1H12(76),wf4(:,6),G1H3(77),m3h4x3(:,10),heltab2x12(:,:,194))
  call Hloop_A_Q(ntryL,G1H3(77),23,nMB,G2H3(74),n2h3(118))
  call Hloop_ZA_Q(ntryL,G1H12(77),wf4(:,6),G1H3(81),ngZd,m3h4x3(:,11),heltab2x12(:,:,195))
  call Hloop_A_Q(ntryL,G1H3(81),23,nMB,G2H3(78),n2h3(119))
  call Hloop_WA_Q(ntryL,G1H12(78),wf4(:,6),G1H3(82),m3h4x3(:,12),heltab2x12(:,:,196))
  call Hloop_A_Q(ntryL,G1H3(82),23,nMT,G2H3(80),n2h3(120))
  call Hloop_SV_T(ntryL,G1H12(79),18,ex3(:),4,G2H6(15),m3h2x6(:,140),heltab2x12(:,:,197))
  call Hloop_SV_V(ntryL,G1H12(80),ex3(:),G1H6(42),m3h2x6(:,141),heltab2x12(:,:,198))
  call Hloop_VV_S(ntryL,G1H12(81),ex3(:),G1H6(117),m3h2x6(:,142),heltab2x12(:,:,199))
  call Hotf_4pt_reduction(G2H12(11),RedSet_4(8),mass4set(:,1),  & 
G1H12(8),G1H12(10),G1H12(11),G1H12(12),G1H12(3),12)
  call HG1shiftOLR(G1H12(10),9,12)
  call Hloop_UW_V(ntryL,G1H12(82),18,ex3(:),4,G2H6(16),m3h2x6(:,143),heltab2x12(:,:,200))
  call Hloop_QA_S(ntryL,G2H12(12),ex2(:),G2H6(17),ngH,m3h2x6(:,144),heltab2x12(:,:,201))
  call Hloop_QA_S(ntryL,G2H12(13),ex2(:),G2H6(18),ngX,m3h2x6(:,145),heltab2x12(:,:,202))
  call Hloop_QA_S(ntryL,G2H12(14),ex2(:),G2H6(19),ngPbt,m3h2x6(:,146),heltab2x12(:,:,203))
  call Hloop_QA_V(ntryL,G2H12(15),ex2(:),G2H6(23),m3h2x6(:,147),heltab2x12(:,:,204))
  call Hloop_QA_Z(ntryL,G2H12(16),ex2(:),G2H6(24),ngZd,m3h2x6(:,148),heltab2x12(:,:,205))
  call Hloop_QA_W(ntryL,G2H12(17),ex2(:),G2H6(22),m3h2x6(:,149),heltab2x12(:,:,206))
  call Hloop_SQ_A(ntryL,G1H12(83),wf6(:,4),G1H2(35),ngH,m3h6x2(:,1),heltab2x12(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(35),27,nMB,G2H2(81),n2h2(93))
  call Hloop_SQ_A(ntryL,G1H12(84),wf6(:,4),G1H2(197),ngX,m3h6x2(:,2),heltab2x12(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(197),27,nMB,G2H2(84),n2h2(94))
  call Hloop_SQ_A(ntryL,G1H12(85),wf6(:,4),G1H2(40),ngPtb,m3h6x2(:,3),heltab2x12(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(40),27,nMT,G2H2(89),n2h2(95))
  call Hloop_VQ_A(ntryL,G1H12(86),wf6(:,4),G1H2(41),m3h6x2(:,4),heltab2x12(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(41),27,nMB,G2H2(92),n2h2(96))
  call Hloop_ZQ_A(ntryL,G1H12(87),wf6(:,4),G1H2(46),ngZd,m3h6x2(:,5),heltab2x12(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(46),27,nMB,G2H2(96),n2h2(97))
  call Hloop_WQ_A(ntryL,G1H12(88),wf6(:,4),G1H2(47),m3h6x2(:,6),heltab2x12(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(47),27,nMT,G2H2(100),n2h2(98))
  call Hloop_TV_S(ntryL,G1H12(89),17,ex3(:),4,G2H6(25),m3h2x6(:,150),heltab2x12(:,:,213))
  call Hloop_SV_V(ntryL,G1H12(90),ex3(:),G1H6(47),m3h2x6(:,151),heltab2x12(:,:,214))
  call Hloop_VV_S(ntryL,G1H12(91),ex3(:),G1H6(118),m3h2x6(:,152),heltab2x12(:,:,215))
  call Hotf_4pt_reduction(G2H12(18),RedSet_4(2),mass4set(:,1),  & 
G1H12(9),G1H12(63),G1H12(1),G1H12(2),G1H12(4),12)
  call HG1shiftOLR(G1H12(63),10,12)
  call Hloop_UV_W(ntryL,G1H12(92),17,ex3(:),4,G2H6(29),m3h2x6(:,153),heltab2x12(:,:,216))
  call Hloop_AQ_S(ntryL,G2H12(19),ex1(:),G2H6(30),ngH,m3h2x6(:,154),heltab2x12(:,:,217))
  call Hloop_AQ_S(ntryL,G2H12(20),ex1(:),G2H6(28),ngX,m3h2x6(:,155),heltab2x12(:,:,218))
  call Hloop_AQ_S(ntryL,G2H12(21),ex1(:),G2H6(31),ngPtb,m3h2x6(:,156),heltab2x12(:,:,219))
  call Hloop_AQ_V(ntryL,G2H12(22),ex1(:),G2H6(35),m3h2x6(:,157),heltab2x12(:,:,220))
  call Hloop_AQ_Z(ntryL,G2H12(23),ex1(:),G2H6(46),ngZd,m3h2x6(:,158),heltab2x12(:,:,221))
  call Hloop_AQ_W(ntryL,G2H12(24),ex1(:),G2H6(21),m3h2x6(:,159),heltab2x12(:,:,222))
  call Hloop_SA_Q(ntryL,G1H12(93),wf6(:,2),G1H2(51),ngH,m3h6x2(:,7),heltab2x12(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(51),27,nMB,G2H2(101),n2h2(99))
  call Hloop_SA_Q(ntryL,G1H12(94),wf6(:,2),G1H2(52),ngX,m3h6x2(:,8),heltab2x12(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(52),27,nMB,G2H2(103),n2h2(100))
  call Hloop_SA_Q(ntryL,G1H12(95),wf6(:,2),G1H2(57),ngPbt,m3h6x2(:,9),heltab2x12(:,:,225))
  call Hloop_A_Q(ntryL,G1H2(57),27,nMT,G2H2(106),n2h2(101))
  call Hloop_VA_Q(ntryL,G1H12(96),wf6(:,2),G1H2(58),m3h6x2(:,10),heltab2x12(:,:,226))
  call Hloop_A_Q(ntryL,G1H2(58),27,nMB,G2H2(108),n2h2(102))
  call Hloop_ZA_Q(ntryL,G1H12(97),wf6(:,2),G1H2(62),ngZd,m3h6x2(:,11),heltab2x12(:,:,227))
  call Hloop_A_Q(ntryL,G1H2(62),27,nMB,G2H2(111),n2h2(103))
  call Hloop_WA_Q(ntryL,G1H12(98),wf6(:,2),G1H2(63),m3h6x2(:,12),heltab2x12(:,:,228))
  call Hloop_A_Q(ntryL,G1H2(63),27,nMT,G2H2(112),n2h2(104))
  call Hloop_QA_S(ntryL,G2H6(26),ex2(:),G2H3(83),ngH,m3h2x3(:,122),heltab2x6(:,:,199))
  call Hloop_QA_S(ntryL,G2H6(27),ex2(:),G2H3(84),ngX,m3h2x3(:,123),heltab2x6(:,:,200))
  call Hloop_QA_S(ntryL,G2H6(32),ex2(:),G2H3(85),ngPbt,m3h2x3(:,124),heltab2x6(:,:,201))
  call Hloop_QA_S(ntryL,G2H6(33),ex2(:),G2H3(86),ngH,m3h2x3(:,125),heltab2x6(:,:,202))
  call Hloop_QA_S(ntryL,G2H6(1),ex2(:),G2H3(87),ngPbt,m3h2x3(:,126),heltab2x6(:,:,203))
  call Hloop_QA_Z(ntryL,G2H6(2),ex2(:),G2H3(88),ngZd,m3h2x3(:,127),heltab2x6(:,:,204))
  call Hloop_QA_W(ntryL,G2H6(3),ex2(:),G2H3(89),m3h2x3(:,128),heltab2x6(:,:,205))
  call Hloop_QA_W(ntryL,G2H6(4),ex2(:),G2H3(90),m3h2x3(:,129),heltab2x6(:,:,206))
  call Hloop_SV_T(ntryL,G1H6(63),19,ex3(:),4,G2H3(91),m3h2x3(:,130),heltab2x6(:,:,207))
  call Hloop_SV_T(ntryL,G1H6(69),19,ex3(:),4,G2H3(92),m3h2x3(:,131),heltab2x6(:,:,208))
  call Hloop_SV_V(ntryL,G1H6(70),ex3(:),G1H3(87),m3h2x3(:,132),heltab2x6(:,:,209))
  call Hloop_VV_S(ntryL,G1H6(73),ex3(:),G1H3(88),m3h2x3(:,133),heltab2x6(:,:,210))
  call Hloop_SV_V(ntryL,G1H6(74),ex3(:),G1H3(92),m3h2x3(:,134),heltab2x6(:,:,211))
  call Hloop_VV_S(ntryL,G1H6(75),ex3(:),G1H3(93),m3h2x3(:,135),heltab2x6(:,:,212))
  call Hloop_UW_V(ntryL,G1H6(76),19,ex3(:),4,G2H3(93),m3h2x3(:,136),heltab2x6(:,:,213))
  call Hloop_UW_V(ntryL,G1H6(79),19,ex3(:),4,G2H3(94),m3h2x3(:,137),heltab2x6(:,:,214))
  call Hloop_SV_T(ntryL,G1H6(85),19,ex4(:),8,G2H2(113),m3h3x2(:,78),heltab2x6(:,:,215))
  call Hloop_SV_T(ntryL,G1H6(91),19,ex4(:),8,G2H2(114),m3h3x2(:,79),heltab2x6(:,:,216))
  call Hloop_SV_V(ntryL,G1H6(92),ex4(:),G1H2(68),m3h3x2(:,80),heltab2x6(:,:,217))
  call Hloop_VV_S(ntryL,G1H6(93),ex4(:),G1H2(69),m3h3x2(:,81),heltab2x6(:,:,218))
  call Hloop_SV_V(ntryL,G1H6(94),ex4(:),G1H2(73),m3h3x2(:,82),heltab2x6(:,:,219))
  call Hloop_VV_S(ntryL,G1H6(97),ex4(:),G1H2(74),m3h3x2(:,83),heltab2x6(:,:,220))
  call Hloop_UW_V(ntryL,G1H6(98),19,ex4(:),8,G2H2(115),m3h3x2(:,84),heltab2x6(:,:,221))
  call Hloop_UW_V(ntryL,G1H6(99),19,ex4(:),8,G2H2(116),m3h3x2(:,85),heltab2x6(:,:,222))
  call Hloop_AQ_S(ntryL,G2H6(5),ex1(:),G2H3(95),ngH,m3h2x3(:,138),heltab2x6(:,:,223))
  call Hloop_AQ_S(ntryL,G2H6(6),ex1(:),G2H3(96),ngX,m3h2x3(:,139),heltab2x6(:,:,224))
  call Hloop_AQ_S(ntryL,G2H6(7),ex1(:),G2H3(97),ngPtb,m3h2x3(:,140),heltab2x6(:,:,225))
  call Hloop_AQ_S(ntryL,G2H6(11),ex1(:),G2H3(98),ngH,m3h2x3(:,141),heltab2x6(:,:,226))
  call Hloop_AQ_S(ntryL,G2H6(12),ex1(:),G2H3(99),ngPtb,m3h2x3(:,142),heltab2x6(:,:,227))
  call Hloop_AQ_Z(ntryL,G2H6(10),ex1(:),G2H3(100),ngZd,m3h2x3(:,143),heltab2x6(:,:,228))
  call Hloop_AQ_W(ntryL,G2H6(13),ex1(:),G2H3(101),m3h2x3(:,144),heltab2x6(:,:,229))
  call Hloop_AQ_W(ntryL,G2H6(14),ex1(:),G2H3(102),m3h2x3(:,145),heltab2x6(:,:,230))
  call Hloop_TV_S(ntryL,G1H6(121),19,ex3(:),4,G2H3(103),m3h2x3(:,146),heltab2x6(:,:,231))
  call Hloop_TV_S(ntryL,G1H6(127),19,ex3(:),4,G2H3(104),m3h2x3(:,147),heltab2x6(:,:,232))
  call Hloop_SV_V(ntryL,G1H6(128),ex3(:),G1H3(98),m3h2x3(:,148),heltab2x6(:,:,233))
  call Hloop_VV_S(ntryL,G1H6(129),ex3(:),G1H3(99),m3h2x3(:,149),heltab2x6(:,:,234))
  call Hloop_SV_V(ntryL,G1H6(130),ex3(:),G1H3(103),m3h2x3(:,150),heltab2x6(:,:,235))
  call Hloop_VV_S(ntryL,G1H6(133),ex3(:),G1H3(104),m3h2x3(:,151),heltab2x6(:,:,236))
  call Hloop_UV_W(ntryL,G1H6(134),19,ex3(:),4,G2H3(105),m3h2x3(:,152),heltab2x6(:,:,237))
  call Hloop_UV_W(ntryL,G1H6(135),19,ex3(:),4,G2H3(106),m3h2x3(:,153),heltab2x6(:,:,238))
  call Hloop_TV_S(ntryL,G1H6(141),19,ex4(:),8,G2H2(117),m3h3x2(:,86),heltab2x6(:,:,239))
  call Hloop_TV_S(ntryL,G1H6(147),19,ex4(:),8,G2H2(118),m3h3x2(:,87),heltab2x6(:,:,240))
  call Hloop_SV_V(ntryL,G1H6(148),ex4(:),G1H2(79),m3h3x2(:,88),heltab2x6(:,:,241))
  call Hloop_VV_S(ntryL,G1H6(151),ex4(:),G1H2(80),m3h3x2(:,89),heltab2x6(:,:,242))
  call Hloop_SV_V(ntryL,G1H6(152),ex4(:),G1H2(84),m3h3x2(:,90),heltab2x6(:,:,243))
  call Hloop_VV_S(ntryL,G1H6(153),ex4(:),G1H2(85),m3h3x2(:,91),heltab2x6(:,:,244))
  call Hloop_UV_W(ntryL,G1H6(154),19,ex4(:),8,G2H2(119),m3h3x2(:,92),heltab2x6(:,:,245))
  call Hloop_UV_W(ntryL,G1H6(157),19,ex4(:),8,G2H2(120),m3h3x2(:,93),heltab2x6(:,:,246))
  call Hloop_QZ_A(ntryL,G1H6(158),ex4(:),G1H2(90),ngZd,m3h3x2(:,94),heltab2x6(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(90),29,nMB,G2H2(121),n2h2(105))
call HGT_raise_alpha_OLR(G1H6(159),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(159),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(159),ex2(:),G1H3(109),m3h2x3(:,154),heltab2x6(:,:,248))
  call Hloop_QZ_A(ntryL,G1H6(163),ex4(:),G1H2(91),ngZd,m3h3x2(:,95),heltab2x6(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(91),29,nMB,G2H2(122),n2h2(106))
  call Hloop_QZ_A(ntryL,G1H6(164),ex4(:),G1H2(95),ngZd,m3h3x2(:,96),heltab2x6(:,:,250))
  call Hloop_Q_A(ntryL,G1H2(95),29,nMB,G2H2(123),n2h2(107))
  call Hloop_QV_A(ntryL,G1H4(66),ex3(:),G1H2(96),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(96),29,nMB,G2H2(124),n2h2(108))
call HGT_raise_alpha_OLR(G1H4(13),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(101),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_QV_A(ntryL,G1H4(7),ex3(:),G1H2(102),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(102),29,nMB,G2H2(125),n2h2(109))
  call Hloop_QV_A(ntryL,G1H4(8),ex3(:),G1H2(106),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(106),29,nMB,G2H2(126),n2h2(110))
  call Hloop_QV_A(ntryL,G1H6(165),ex3(:),G1H3(110),m3h2x3(:,155),heltab2x6(:,:,251))
  call Hloop_Q_A(ntryL,G1H3(110),23,nMB,G2H3(107),n2h3(121))
call HGT_OLR(G1H6(166),1,1,6)
call HGT_invQ_OLR(G1H6(166),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(166),-8,nMB,G2H6(48),n2h6(124))
  call Hloop_AZ_Q(ntryL,G2H6(48),ex4(:),G2H2(127),ngZd,m3h3x2(:,97),heltab2x6(:,:,252))
  call Hloop_QV_A(ntryL,G1H6(170),ex3(:),G1H3(114),m3h2x3(:,156),heltab2x6(:,:,253))
  call Hloop_Q_A(ntryL,G1H3(114),23,nMB,G2H3(108),n2h3(122))
  call Hloop_QV_A(ntryL,G1H6(171),ex3(:),G1H3(115),m3h2x3(:,157),heltab2x6(:,:,254))
  call Hloop_Q_A(ntryL,G1H3(115),23,nMB,G2H3(109),n2h3(123))
  call Hloop_QV_A(ntryL,G0H6(5),ex3(:),G0H3(1),m3h2x3(:,158),heltab2x6(:,:,255))
  call Hloop_Q_A(ntryL,G0H3(1),23,nMB,G1H3(120),n2h3(124))
  call Hloop_QV_A(ntryL,G1H6(172),ex3(:),G1H3(121),m3h2x3(:,159),heltab2x6(:,:,256))
  call Hloop_Q_A(ntryL,G1H3(121),23,nMT,G2H3(110),n2h3(125))
call HGT_OLR(G1H6(175),1,1,6)
call HGT_invQ_OLR(G1H6(175),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(175),-8,nMT,G2H6(41),n2h6(125))
  call Hloop_AZ_Q(ntryL,G2H6(41),ex4(:),G2H2(128),ngZu,m3h3x2(:,98),heltab2x6(:,:,257))
  call Hloop_QV_A(ntryL,G1H6(177),ex3(:),G1H3(125),m3h2x3(:,160),heltab2x6(:,:,258))
  call Hloop_Q_A(ntryL,G1H3(125),23,nMT,G2H3(111),n2h3(126))
  call Hloop_QV_A(ntryL,G1H6(178),ex3(:),G1H3(126),m3h2x3(:,161),heltab2x6(:,:,259))
  call Hloop_Q_A(ntryL,G1H3(126),23,nMT,G2H3(112),n2h3(127))
  call Hloop_QV_A(ntryL,G0H6(3),ex3(:),G0H3(1),m3h2x3(:,162),heltab2x6(:,:,260))
  call Hloop_Q_A(ntryL,G0H3(1),23,nMT,G1H3(131),n2h3(128))
  call Hloop_QZ_A(ntryL,G1H6(181),ex4(:),G1H2(107),ngZd,m3h3x2(:,99),heltab2x6(:,:,261))
  call Hloop_Q_A(ntryL,G1H2(107),27,nMB,G2H2(129),n2h2(111))
call HGT_OLR(G1H6(182),1,1,6)
call HGT_invQ_OLR(G1H6(182),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(182),-4,nMB,G2H6(37),n2h6(126))
  call Hloop_AV_Q(ntryL,G2H6(37),ex3(:),G2H3(113),m3h2x3(:,163),heltab2x6(:,:,262))
  call Hloop_QZ_A(ntryL,G1H6(184),ex4(:),G1H2(112),ngZd,m3h3x2(:,100),heltab2x6(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(112),27,nMB,G2H2(130),n2h2(112))
  call Hloop_QZ_A(ntryL,G1H6(187),ex4(:),G1H2(113),ngZd,m3h3x2(:,101),heltab2x6(:,:,264))
  call Hloop_Q_A(ntryL,G1H2(113),27,nMB,G2H2(131),n2h2(113))
  call Hloop_QZ_A(ntryL,G0H6(4),ex4(:),G0H2(1),ngZd,m3h3x2(:,102),heltab2x6(:,:,265))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(117),n2h2(114))
  call Hloop_QZ_A(ntryL,G1H6(188),ex4(:),G1H2(118),ngZu,m3h3x2(:,103),heltab2x6(:,:,266))
  call Hloop_Q_A(ntryL,G1H2(118),27,nMT,G2H2(132),n2h2(115))
call HGT_OLR(G1H6(189),1,1,6)
call HGT_invQ_OLR(G1H6(189),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(189),-4,nMT,G2H6(9),n2h6(127))
  call Hloop_AV_Q(ntryL,G2H6(9),ex3(:),G2H3(114),m3h2x3(:,164),heltab2x6(:,:,267))
  call Hloop_QZ_A(ntryL,G1H6(193),ex4(:),G1H2(123),ngZu,m3h3x2(:,104),heltab2x6(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(123),27,nMT,G2H2(133),n2h2(116))
  call Hloop_QZ_A(ntryL,G1H6(194),ex4(:),G1H2(124),ngZu,m3h3x2(:,105),heltab2x6(:,:,269))
  call Hloop_Q_A(ntryL,G1H2(124),27,nMT,G2H2(134),n2h2(117))
  call Hloop_QZ_A(ntryL,G0H6(1),ex4(:),G0H2(1),ngZu,m3h3x2(:,106),heltab2x6(:,:,270))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(128),n2h2(118))
  call Hloop_AV_Q(ntryL,G1H6(195),ex3(:),G1H3(132),m3h2x3(:,165),heltab2x6(:,:,271))
  call Hloop_A_Q(ntryL,G1H3(132),23,nMB,G2H3(115),n2h3(129))
call HGT_OLR(G1H6(196),1,1,6)
call HGT_invQ_OLR(G1H6(196),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(196),-8,nMB,G2H6(45),n2h6(128))
  call Hloop_QZ_A(ntryL,G2H6(45),ex4(:),G2H2(135),ngZd,m3h3x2(:,107),heltab2x6(:,:,272))
  call Hloop_AV_Q(ntryL,G1H6(200),ex3(:),G1H3(136),m3h2x3(:,166),heltab2x6(:,:,273))
  call Hloop_A_Q(ntryL,G1H3(136),23,nMB,G2H3(116),n2h3(130))
  call Hloop_AV_Q(ntryL,G1H6(201),ex3(:),G1H3(137),m3h2x3(:,167),heltab2x6(:,:,274))
  call Hloop_A_Q(ntryL,G1H3(137),23,nMB,G2H3(117),n2h3(131))
  call Hloop_AV_Q(ntryL,G0H6(2),ex3(:),G0H3(1),m3h2x3(:,168),heltab2x6(:,:,275))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMB,G1H3(142),n2h3(132))
  call Hloop_AV_Q(ntryL,G1H6(202),ex3(:),G1H3(143),m3h2x3(:,169),heltab2x6(:,:,276))
  call Hloop_A_Q(ntryL,G1H3(143),23,nMT,G2H3(118),n2h3(133))
call HGT_OLR(G1H6(205),1,1,6)
call HGT_invQ_OLR(G1H6(205),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(205),-8,nMT,G2H6(42),n2h6(129))
  call Hloop_QZ_A(ntryL,G2H6(42),ex4(:),G2H2(136),ngZu,m3h3x2(:,108),heltab2x6(:,:,277))
  call Hloop_AV_Q(ntryL,G1H6(207),ex3(:),G1H3(147),m3h2x3(:,170),heltab2x6(:,:,278))
  call Hloop_A_Q(ntryL,G1H3(147),23,nMT,G2H3(119),n2h3(134))
  call Hloop_AV_Q(ntryL,G1H6(208),ex3(:),G1H3(148),m3h2x3(:,171),heltab2x6(:,:,279))
  call Hloop_A_Q(ntryL,G1H3(148),23,nMT,G2H3(120),n2h3(135))
  call Hloop_AV_Q(ntryL,G0H6(6),ex3(:),G0H3(1),m3h2x3(:,172),heltab2x6(:,:,280))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMT,G1H3(153),n2h3(136))
  call Hloop_AZ_Q(ntryL,G1H6(213),ex4(:),G1H2(129),ngZd,m3h3x2(:,109),heltab2x6(:,:,281))
  call Hloop_A_Q(ntryL,G1H2(129),27,nMB,G2H2(137),n2h2(119))
call HGT_OLR(G1H6(218),1,1,6)
call HGT_invQ_OLR(G1H6(218),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(218),-4,nMB,G2H6(39),n2h6(130))
  call Hloop_QV_A(ntryL,G2H6(39),ex3(:),G2H3(121),m3h2x3(:,173),heltab2x6(:,:,282))
  call Hloop_AZ_Q(ntryL,G1H6(217),ex4(:),G1H2(134),ngZd,m3h3x2(:,110),heltab2x6(:,:,283))
  call Hloop_A_Q(ntryL,G1H2(134),27,nMB,G2H2(138),n2h2(120))
  call Hloop_AZ_Q(ntryL,G1H6(219),ex4(:),G1H2(135),ngZd,m3h3x2(:,111),heltab2x6(:,:,284))
  call Hloop_A_Q(ntryL,G1H2(135),27,nMB,G2H2(139),n2h2(121))
  call Hloop_AZ_Q(ntryL,G0H6(7),ex4(:),G0H2(1),ngZd,m3h3x2(:,112),heltab2x6(:,:,285))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(140),n2h2(122))
  call Hloop_AZ_Q(ntryL,G1H6(222),ex4(:),G1H2(144),ngZu,m3h3x2(:,113),heltab2x6(:,:,286))
  call Hloop_A_Q(ntryL,G1H2(144),27,nMT,G2H2(140),n2h2(123))
call HGT_OLR(G1H6(211),1,1,6)
call HGT_invQ_OLR(G1H6(211),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(211),-4,nMT,G2H6(36),n2h6(131))
  call Hloop_QV_A(ntryL,G2H6(36),ex3(:),G2H3(122),m3h2x3(:,174),heltab2x6(:,:,287))
  call Hloop_AZ_Q(ntryL,G1H6(1),ex4(:),G1H2(145),ngZu,m3h3x2(:,114),heltab2x6(:,:,288))
  call Hloop_A_Q(ntryL,G1H2(145),27,nMT,G2H2(141),n2h2(124))
  call Hloop_AZ_Q(ntryL,G1H6(2),ex4(:),G1H2(150),ngZu,m3h3x2(:,115),heltab2x6(:,:,289))
  call Hloop_A_Q(ntryL,G1H2(150),27,nMT,G2H2(142),n2h2(125))
  call Hloop_AZ_Q(ntryL,G0H6(8),ex4(:),G0H2(1),ngZu,m3h3x2(:,116),heltab2x6(:,:,290))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(151),n2h2(126))
  call Hloop_QZ_A(ntryL,G1H6(6),ex4(:),G1H2(156),ngZd,m3h3x2(:,117),heltab2x6(:,:,291))
  call Hloop_Q_A(ntryL,G1H2(156),29,nMB,G2H2(143),n2h2(127))
call HGT_raise_alpha_OLR(G1H6(5),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(5),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(5),ex2(:),G1H3(154),m3h2x3(:,175),heltab2x6(:,:,292))
  call Hloop_QZ_A(ntryL,G1H6(7),ex4(:),G1H2(161),ngZd,m3h3x2(:,118),heltab2x6(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(161),29,nMB,G2H2(144),n2h2(128))
  call Hloop_QZ_A(ntryL,G1H6(13),ex4(:),G1H2(166),ngZd,m3h3x2(:,119),heltab2x6(:,:,294))
  call Hloop_Q_A(ntryL,G1H2(166),29,nMB,G2H2(145),n2h2(129))
  call Hloop_QV_A(ntryL,G1H4(6),ex3(:),G1H2(170),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(170),29,nMB,G2H2(146),n2h2(130))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(10),ex2(:),G1H2(171),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_QV_A(ntryL,G1H4(14),ex3(:),G1H2(176),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(176),29,nMB,G2H2(147),n2h2(131))
  call Hloop_QV_A(ntryL,G1H4(15),ex3(:),G1H2(177),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(177),29,nMB,G2H2(148),n2h2(132))
  call Hloop_QZ_A(ntryL,G1H6(14),ex4(:),G1H2(181),ngZu,m3h3x2(:,120),heltab2x6(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(181),27,0,G2H2(149),n2h2(133))
call HGT_OLR(G1H6(15),1,1,6)
call HGT_invQ_OLR(G1H6(15),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(15),-4,0,G2H6(34),n2h6(133))
  call Hloop_AV_Q(ntryL,G2H6(34),ex3(:),G2H3(123),m3h2x3(:,176),heltab2x6(:,:,296))
  call Hloop_QZ_A(ntryL,G1H6(19),ex4(:),G1H2(182),ngZu,m3h3x2(:,121),heltab2x6(:,:,297))
  call Hloop_Q_A(ntryL,G1H2(182),27,0,G2H2(150),n2h2(134))
  call Hloop_QZ_A(ntryL,G1H6(20),ex4(:),G1H2(187),ngZu,m3h3x2(:,122),heltab2x6(:,:,298))
  call Hloop_Q_A(ntryL,G1H2(187),27,0,G2H2(151),n2h2(135))
  call Hloop_QZ_A(ntryL,G0H6(9),ex4(:),G0H2(1),ngZu,m3h3x2(:,123),heltab2x6(:,:,299))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(188),n2h2(136))
  call Hloop_AZ_Q(ntryL,G1H6(21),ex4(:),G1H2(193),ngZu,m3h3x2(:,124),heltab2x6(:,:,300))
  call Hloop_A_Q(ntryL,G1H2(193),27,0,G2H2(152),n2h2(137))
call HGT_OLR(G1H6(22),1,1,6)
call HGT_invQ_OLR(G1H6(22),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(22),-4,0,G2H6(38),n2h6(134))
  call Hloop_QV_A(ntryL,G2H6(38),ex3(:),G2H3(124),m3h2x3(:,177),heltab2x6(:,:,301))
  call Hloop_AZ_Q(ntryL,G1H6(44),ex4(:),G1H2(198),ngZu,m3h3x2(:,125),heltab2x6(:,:,302))
  call Hloop_A_Q(ntryL,G1H2(198),27,0,G2H2(153),n2h2(138))
  call Hloop_AZ_Q(ntryL,G1H6(45),ex4(:),G1H2(9),ngZu,m3h3x2(:,126),heltab2x6(:,:,303))
  call Hloop_A_Q(ntryL,G1H2(9),27,0,G2H2(154),n2h2(139))
  call Hloop_AZ_Q(ntryL,G0H6(10),ex4(:),G0H2(1),ngZu,m3h3x2(:,127),heltab2x6(:,:,304))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(15),n2h2(140))
  call Hloop_QZ_A(ntryL,G1H6(46),ex4(:),G1H2(21),ngZd,m3h3x2(:,128),heltab2x6(:,:,305))
  call Hloop_Q_A(ntryL,G1H2(21),27,0,G2H2(155),n2h2(141))
call HGT_OLR(G1H6(50),1,1,6)
call HGT_invQ_OLR(G1H6(50),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(50),-4,0,G2H6(40),n2h6(135))
  call Hloop_AV_Q(ntryL,G2H6(40),ex3(:),G2H3(125),m3h2x3(:,178),heltab2x6(:,:,306))
  call Hloop_QZ_A(ntryL,G1H6(52),ex4(:),G1H2(27),ngZd,m3h3x2(:,129),heltab2x6(:,:,307))
  call Hloop_Q_A(ntryL,G1H2(27),27,0,G2H2(156),n2h2(142))
  call Hloop_QZ_A(ntryL,G1H6(55),ex4(:),G1H2(33),ngZd,m3h3x2(:,130),heltab2x6(:,:,308))
  call Hloop_Q_A(ntryL,G1H2(33),27,0,G2H2(157),n2h2(143))
  call Hloop_QZ_A(ntryL,G0H6(11),ex4(:),G0H2(1),ngZd,m3h3x2(:,131),heltab2x6(:,:,309))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(39),n2h2(144))
  call Hloop_AZ_Q(ntryL,G1H6(56),ex4(:),G1H2(45),ngZd,m3h3x2(:,132),heltab2x6(:,:,310))
  call Hloop_A_Q(ntryL,G1H2(45),27,0,G2H2(158),n2h2(145))
call HGT_OLR(G1H6(100),1,1,6)
call HGT_invQ_OLR(G1H6(100),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(100),-4,0,G2H6(43),n2h6(136))
  call Hloop_QV_A(ntryL,G2H6(43),ex3(:),G2H3(126),m3h2x3(:,179),heltab2x6(:,:,311))
  call Hloop_AZ_Q(ntryL,G1H6(104),ex4(:),G1H2(56),ngZd,m3h3x2(:,133),heltab2x6(:,:,312))
  call Hloop_A_Q(ntryL,G1H2(56),27,0,G2H2(159),n2h2(146))
  call Hloop_AZ_Q(ntryL,G1H6(106),ex4(:),G1H2(67),ngZd,m3h3x2(:,134),heltab2x6(:,:,313))
  call Hloop_A_Q(ntryL,G1H2(67),27,0,G2H2(160),n2h2(147))
  call Hloop_AZ_Q(ntryL,G0H6(12),ex4(:),G0H2(1),ngZd,m3h3x2(:,135),heltab2x6(:,:,314))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(78),n2h2(148))
  call Hloop_AV_Q(ntryL,G1H6(109),ex3(:),G1H3(158),m3h2x3(:,180),heltab2x6(:,:,315))
  call Hloop_A_Q(ntryL,G1H3(158),23,0,G2H3(127),n2h3(137))
call HGT_OLR(G1H6(110),1,1,6)
call HGT_invQ_OLR(G1H6(110),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(110),-8,0,G2H6(44),n2h6(137))
  call Hloop_QZ_A(ntryL,G2H6(44),ex4(:),G2H2(161),ngZu,m3h3x2(:,136),heltab2x6(:,:,316))
  call Hloop_AV_Q(ntryL,G1H6(112),ex3(:),G1H3(159),m3h2x3(:,181),heltab2x6(:,:,317))
  call Hloop_A_Q(ntryL,G1H3(159),23,0,G2H3(128),n2h3(138))
  call Hloop_AV_Q(ntryL,G1H6(59),ex3(:),G1H3(164),m3h2x3(:,182),heltab2x6(:,:,318))
  call Hloop_A_Q(ntryL,G1H3(164),23,0,G2H3(129),n2h3(139))
  call Hloop_AV_Q(ntryL,G0H6(13),ex3(:),G0H3(1),m3h2x3(:,183),heltab2x6(:,:,319))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(165),n2h3(140))
  call Hloop_QV_A(ntryL,G1H6(122),ex3(:),G1H3(169),m3h2x3(:,184),heltab2x6(:,:,320))
  call Hloop_Q_A(ntryL,G1H3(169),23,0,G2H3(130),n2h3(141))
call HGT_OLR(G1H6(210),1,1,6)
call HGT_invQ_OLR(G1H6(210),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(210),-8,0,G2H6(47),n2h6(138))
  call Hloop_AZ_Q(ntryL,G2H6(47),ex4(:),G2H2(162),ngZu,m3h3x2(:,137),heltab2x6(:,:,321))
  call Hloop_QV_A(ntryL,G1H6(142),ex3(:),G1H3(170),m3h2x3(:,185),heltab2x6(:,:,322))
  call Hloop_Q_A(ntryL,G1H3(170),23,0,G2H3(131),n2h3(142))
  call Hloop_QV_A(ntryL,G1H6(3),ex3(:),G1H3(175),m3h2x3(:,186),heltab2x6(:,:,323))
  call Hloop_Q_A(ntryL,G1H3(175),23,0,G2H3(132),n2h3(143))
  call Hloop_QV_A(ntryL,G0H6(14),ex3(:),G0H3(1),m3h2x3(:,187),heltab2x6(:,:,324))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(176),n2h3(144))
  call Hloop_AV_Q(ntryL,G1H6(12),ex3(:),G1H3(180),m3h2x3(:,188),heltab2x6(:,:,325))
  call Hloop_A_Q(ntryL,G1H3(180),23,0,G2H3(133),n2h3(145))
call HGT_OLR(G1H6(186),1,1,6)
call HGT_invQ_OLR(G1H6(186),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(186),-8,0,G2H6(8),n2h6(139))
  call Hloop_QZ_A(ntryL,G2H6(8),ex4(:),G2H2(163),ngZd,m3h3x2(:,138),heltab2x6(:,:,326))
  call Hloop_AV_Q(ntryL,G1H6(24),ex3(:),G1H3(181),m3h2x3(:,189),heltab2x6(:,:,327))
  call Hloop_A_Q(ntryL,G1H3(181),23,0,G2H3(134),n2h3(146))
  call Hloop_AV_Q(ntryL,G1H6(30),ex3(:),G1H3(186),m3h2x3(:,190),heltab2x6(:,:,328))
  call Hloop_A_Q(ntryL,G1H3(186),23,0,G2H3(135),n2h3(147))
  call Hloop_AV_Q(ntryL,G0H6(15),ex3(:),G0H3(1),m3h2x3(:,191),heltab2x6(:,:,329))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(187),n2h3(148))
  call Hloop_QV_A(ntryL,G1H6(192),ex3(:),G1H3(191),m3h2x3(:,192),heltab2x6(:,:,330))
  call Hloop_Q_A(ntryL,G1H3(191),23,0,G2H3(136),n2h3(149))
call HGT_OLR(G1H6(36),1,1,6)
call HGT_invQ_OLR(G1H6(36),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(36),-8,0,G2H6(20),n2h6(140))
  call Hloop_AZ_Q(ntryL,G2H6(20),ex4(:),G2H2(164),ngZd,m3h3x2(:,139),heltab2x6(:,:,331))
  call Hloop_QV_A(ntryL,G1H6(60),ex3(:),G1H3(192),m3h2x3(:,193),heltab2x6(:,:,332))
  call Hloop_Q_A(ntryL,G1H3(192),23,0,G2H3(137),n2h3(150))
  call Hloop_QV_A(ntryL,G1H6(48),ex3(:),G1H3(197),m3h2x3(:,194),heltab2x6(:,:,333))
  call Hloop_Q_A(ntryL,G1H3(197),23,0,G2H3(138),n2h3(151))
  call Hloop_QV_A(ntryL,G0H6(16),ex3(:),G0H3(1),m3h2x3(:,195),heltab2x6(:,:,334))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(198),n2h3(152))
  call Hloop_QV_A(ntryL,G1H12(13),wf4(:,9),G1H3(9),m3h4x3(:,13),heltab2x12(:,:,229))
  call Hloop_Q_A(ntryL,G1H3(9),23,0,G2H3(139),n2h3(153))
call HGT_OLR(G1H12(14),1,1,12)
call HGT_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(14),-8,0,G2H12(1),n2h12(89))
  call Hloop_AZ_Q(ntryL,G2H12(1),ex4(:),G2H4(5),ngZu,m3h3x4(:,46),heltab2x12(:,:,230))
  call Hloop_QV_A(ntryL,G1H12(16),wf4(:,9),G1H3(20),m3h4x3(:,14),heltab2x12(:,:,231))
  call Hloop_Q_A(ntryL,G1H3(20),23,0,G2H3(140),n2h3(154))
  call Hloop_QV_A(ntryL,G1H12(17),wf4(:,9),G1H3(31),m3h4x3(:,15),heltab2x12(:,:,232))
  call Hloop_Q_A(ntryL,G1H3(31),23,0,G2H3(141),n2h3(155))
  call Hloop_QV_A(ntryL,G0H12(37),wf4(:,9),G0H3(1),m3h4x3(:,16),heltab2x12(:,:,233))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(42),n2h3(156))
  call Hloop_QV_A(ntryL,G1H12(18),wf4(:,9),G1H3(53),m3h4x3(:,17),heltab2x12(:,:,234))
  call Hloop_Q_A(ntryL,G1H3(53),23,nMT,G2H3(142),n2h3(157))
call HGT_OLR(G1H12(19),1,1,12)
call HGT_invQ_OLR(G1H12(19),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(19),-8,nMT,G2H12(2),n2h12(90))
  call Hloop_AZ_Q(ntryL,G2H12(2),ex4(:),G2H4(6),ngZu,m3h3x4(:,47),heltab2x12(:,:,235))
  call Hloop_QV_A(ntryL,G1H12(21),wf4(:,9),G1H3(64),m3h4x3(:,18),heltab2x12(:,:,236))
  call Hloop_Q_A(ntryL,G1H3(64),23,nMT,G2H3(143),n2h3(158))
  call Hloop_QV_A(ntryL,G1H12(22),wf4(:,9),G1H3(75),m3h4x3(:,19),heltab2x12(:,:,237))
  call Hloop_Q_A(ntryL,G1H3(75),23,nMT,G2H3(144),n2h3(159))
  call Hloop_QV_A(ntryL,G0H12(8),wf4(:,9),G0H3(1),m3h4x3(:,20),heltab2x12(:,:,238))
  call Hloop_Q_A(ntryL,G0H3(1),23,nMT,G1H3(86),n2h3(160))
  call Hloop_AV_Q(ntryL,G1H12(23),wf4(:,9),G1H3(97),m3h4x3(:,21),heltab2x12(:,:,239))
  call Hloop_A_Q(ntryL,G1H3(97),23,0,G2H3(145),n2h3(161))
call HGT_OLR(G1H12(24),1,1,12)
call HGT_invQ_OLR(G1H12(24),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(24),-8,0,G2H12(3),n2h12(91))
  call Hloop_QZ_A(ntryL,G2H12(3),ex4(:),G2H4(7),ngZu,m3h3x4(:,48),heltab2x12(:,:,240))
  call Hloop_AV_Q(ntryL,G1H12(26),wf4(:,9),G1H3(108),m3h4x3(:,22),heltab2x12(:,:,241))
  call Hloop_A_Q(ntryL,G1H3(108),23,0,G2H3(146),n2h3(162))
  call Hloop_AV_Q(ntryL,G1H12(27),wf4(:,9),G1H3(119),m3h4x3(:,23),heltab2x12(:,:,242))
  call Hloop_A_Q(ntryL,G1H3(119),23,0,G2H3(147),n2h3(163))
  call Hloop_AV_Q(ntryL,G0H12(15),wf4(:,9),G0H3(1),m3h4x3(:,24),heltab2x12(:,:,243))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(130),n2h3(164))
  call Hloop_AV_Q(ntryL,G1H12(28),wf4(:,9),G1H3(141),m3h4x3(:,25),heltab2x12(:,:,244))
  call Hloop_A_Q(ntryL,G1H3(141),23,nMT,G2H3(148),n2h3(165))
call HGT_OLR(G1H12(29),1,1,12)
call HGT_invQ_OLR(G1H12(29),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(29),-8,nMT,G2H12(4),n2h12(92))
  call Hloop_QZ_A(ntryL,G2H12(4),ex4(:),G2H4(8),ngZu,m3h3x4(:,49),heltab2x12(:,:,245))
  call Hloop_AV_Q(ntryL,G1H12(31),wf4(:,9),G1H3(152),m3h4x3(:,26),heltab2x12(:,:,246))
  call Hloop_A_Q(ntryL,G1H3(152),23,nMT,G2H3(149),n2h3(166))
  call Hloop_AV_Q(ntryL,G1H12(32),wf4(:,9),G1H3(163),m3h4x3(:,27),heltab2x12(:,:,247))
  call Hloop_A_Q(ntryL,G1H3(163),23,nMT,G2H3(150),n2h3(167))
  call Hloop_AV_Q(ntryL,G0H12(26),wf4(:,9),G0H3(1),m3h4x3(:,28),heltab2x12(:,:,248))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMT,G1H3(174),n2h3(168))
  call Hloop_QV_A(ntryL,G1H12(33),wf4(:,9),G1H3(185),m3h4x3(:,29),heltab2x12(:,:,249))
  call Hloop_Q_A(ntryL,G1H3(185),23,0,G2H3(151),n2h3(169))
call HGT_OLR(G1H12(34),1,1,12)
call HGT_invQ_OLR(G1H12(34),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(34),-8,0,G2H12(5),n2h12(93))
  call Hloop_AZ_Q(ntryL,G2H12(5),ex4(:),G2H4(9),ngZd,m3h3x4(:,50),heltab2x12(:,:,250))
  call Hloop_QV_A(ntryL,G1H12(36),wf4(:,9),G1H3(196),m3h4x3(:,30),heltab2x12(:,:,251))
  call Hloop_Q_A(ntryL,G1H3(196),23,0,G2H3(152),n2h3(170))
  call Hloop_QV_A(ntryL,G1H12(37),wf4(:,9),G1H3(4),m3h4x3(:,31),heltab2x12(:,:,252))
  call Hloop_Q_A(ntryL,G1H3(4),23,0,G2H3(153),n2h3(171))
  call Hloop_QV_A(ntryL,G0H12(33),wf4(:,9),G0H3(1),m3h4x3(:,32),heltab2x12(:,:,253))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(5),n2h3(172))
  call Hloop_QV_A(ntryL,G1H12(38),wf4(:,9),G1H3(10),m3h4x3(:,33),heltab2x12(:,:,254))
  call Hloop_Q_A(ntryL,G1H3(10),23,nMB,G2H3(154),n2h3(173))
call HGT_OLR(G1H12(39),1,1,12)
call HGT_invQ_OLR(G1H12(39),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(39),-8,nMB,G2H12(6),n2h12(94))
  call Hloop_AZ_Q(ntryL,G2H12(6),ex4(:),G2H4(11),ngZd,m3h3x4(:,51),heltab2x12(:,:,255))
  call Hloop_QV_A(ntryL,G1H12(41),wf4(:,9),G1H3(11),m3h4x3(:,34),heltab2x12(:,:,256))
  call Hloop_Q_A(ntryL,G1H3(11),23,nMB,G2H3(155),n2h3(174))
  call Hloop_QV_A(ntryL,G1H12(42),wf4(:,9),G1H3(15),m3h4x3(:,35),heltab2x12(:,:,257))
  call Hloop_Q_A(ntryL,G1H3(15),23,nMB,G2H3(156),n2h3(175))
  call Hloop_QV_A(ntryL,G0H12(1),wf4(:,9),G0H3(1),m3h4x3(:,36),heltab2x12(:,:,258))
  call Hloop_Q_A(ntryL,G0H3(1),23,nMB,G1H3(16),n2h3(176))
  call Hloop_AV_Q(ntryL,G1H12(43),wf4(:,9),G1H3(21),m3h4x3(:,37),heltab2x12(:,:,259))
  call Hloop_A_Q(ntryL,G1H3(21),23,0,G2H3(157),n2h3(177))
call HGT_OLR(G1H12(44),1,1,12)
call HGT_invQ_OLR(G1H12(44),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(44),-8,0,G2H12(7),n2h12(95))
  call Hloop_QZ_A(ntryL,G2H12(7),ex4(:),G2H4(14),ngZd,m3h3x4(:,52),heltab2x12(:,:,260))
  call Hloop_AV_Q(ntryL,G1H12(46),wf4(:,9),G1H3(22),m3h4x3(:,38),heltab2x12(:,:,261))
  call Hloop_A_Q(ntryL,G1H3(22),23,0,G2H3(158),n2h3(178))
  call Hloop_AV_Q(ntryL,G1H12(47),wf4(:,9),G1H3(26),m3h4x3(:,39),heltab2x12(:,:,262))
  call Hloop_A_Q(ntryL,G1H3(26),23,0,G2H3(159),n2h3(179))
  call Hloop_AV_Q(ntryL,G0H12(2),wf4(:,9),G0H3(1),m3h4x3(:,40),heltab2x12(:,:,263))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(27),n2h3(180))
  call Hloop_AV_Q(ntryL,G1H12(48),wf4(:,9),G1H3(32),m3h4x3(:,41),heltab2x12(:,:,264))
  call Hloop_A_Q(ntryL,G1H3(32),23,nMB,G2H3(160),n2h3(181))
call HGT_OLR(G1H12(49),1,1,12)
call HGT_invQ_OLR(G1H12(49),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(49),-8,nMB,G2H12(8),n2h12(96))
  call Hloop_QZ_A(ntryL,G2H12(8),ex4(:),G2H4(10),ngZd,m3h3x4(:,53),heltab2x12(:,:,265))
  call Hloop_AV_Q(ntryL,G1H12(51),wf4(:,9),G1H3(33),m3h4x3(:,42),heltab2x12(:,:,266))
  call Hloop_A_Q(ntryL,G1H3(33),23,nMB,G2H3(161),n2h3(182))
  call Hloop_AV_Q(ntryL,G1H12(52),wf4(:,9),G1H3(37),m3h4x3(:,43),heltab2x12(:,:,267))
  call Hloop_A_Q(ntryL,G1H3(37),23,nMB,G2H3(162),n2h3(183))
  call Hloop_AV_Q(ntryL,G0H12(3),wf4(:,9),G0H3(1),m3h4x3(:,44),heltab2x12(:,:,268))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMB,G1H3(38),n2h3(184))
  call Hloop_AZ_Q(ntryL,G1H12(53),ex4(:),G1H4(27),ngZd,m3h3x4(:,54),heltab2x12(:,:,269))
  call Hloop_A_Q(ntryL,G1H4(27),26,nMB,G2H4(17),n2h4(21))
call HGT_raise_alpha_OLR(G1H12(54),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(54),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(54),wf4(:,2),G1H3(43),m3h4x3(:,45),heltab2x12(:,:,270))
  call Hloop_AZ_Q(ntryL,G1H12(56),ex4(:),G1H4(30),ngZd,m3h3x4(:,55),heltab2x12(:,:,271))
  call Hloop_A_Q(ntryL,G1H4(30),26,nMB,G2H4(18),n2h4(22))
  call Hloop_AZ_Q(ntryL,G1H12(57),ex4(:),G1H4(31),ngZd,m3h3x4(:,56),heltab2x12(:,:,272))
  call Hloop_A_Q(ntryL,G1H4(31),26,nMB,G2H4(19),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H12(58),ex4(:),G1H4(32),ngZd,m3h3x4(:,57),heltab2x12(:,:,273))
  call Hloop_Q_A(ntryL,G1H4(32),25,nMB,G2H4(20),n2h4(24))
call HGT_raise_alpha_OLR(G1H12(59),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(59),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(59),wf4(:,6),G1H3(44),m3h4x3(:,46),heltab2x12(:,:,274))
  call Hloop_QZ_A(ntryL,G1H12(61),ex4(:),G1H4(33),ngZd,m3h3x4(:,58),heltab2x12(:,:,275))
  call Hloop_Q_A(ntryL,G1H4(33),25,nMB,G2H4(21),n2h4(25))
  call Hloop_QZ_A(ntryL,G1H12(62),ex4(:),G1H4(36),ngZd,m3h3x4(:,59),heltab2x12(:,:,276))
  call Hloop_Q_A(ntryL,G1H4(36),25,nMB,G2H4(22),n2h4(26))
  call Hloop_AV_Q(ntryL,G1H12(8),ex3(:),G1H6(53),m3h2x6(:,160),heltab2x12(:,:,277))
  call Hloop_A_Q(ntryL,G1H6(53),22,nMB,G2H6(26),n2h6(141))
call HGT_raise_alpha_OLR(G1H12(10),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(10),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(10),wf6(:,4),G1H2(89),m3h6x2(:,13),heltab2x12(:,:,278))
  call Hloop_AV_Q(ntryL,G1H12(12),ex3(:),G1H6(54),m3h2x6(:,161),heltab2x12(:,:,279))
  call Hloop_A_Q(ntryL,G1H6(54),22,nMB,G2H6(27),n2h6(142))
  call Hloop_AV_Q(ntryL,G1H12(3),ex3(:),G1H6(66),m3h2x6(:,162),heltab2x12(:,:,280))
  call Hloop_A_Q(ntryL,G1H6(66),22,nMB,G2H6(32),n2h6(143))
  call Hloop_QV_A(ntryL,G1H12(9),ex3(:),G1H6(72),m3h2x6(:,163),heltab2x12(:,:,281))
  call Hloop_Q_A(ntryL,G1H6(72),21,nMB,G2H6(33),n2h6(144))
call HGT_raise_alpha_OLR(G1H12(63),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(63),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(63),wf6(:,2),G1H2(100),m3h6x2(:,14),heltab2x12(:,:,282))
  call Hloop_QV_A(ntryL,G1H12(2),ex3(:),G1H6(174),m3h2x6(:,164),heltab2x12(:,:,283))
  call Hloop_Q_A(ntryL,G1H6(174),21,nMB,G2H6(1),n2h6(145))
  call Hloop_QV_A(ntryL,G1H12(4),ex3(:),G1H6(78),m3h2x6(:,165),heltab2x12(:,:,284))
  call Hloop_Q_A(ntryL,G1H6(78),21,nMB,G2H6(2),n2h6(146))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(160),[G2H3(14),G2H3(11),G2H3(5),G2H3(2),G1H3(41),G1H3(19) &
    ,G1H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(148),[G2H3(17),G2H3(8),G1H3(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(53),[G2H3(20),G1H3(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(59),[G2H3(55),G2H3(23),G1H3(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(61),[G2H3(56),G2H3(73),G2H3(70),G2H3(26),G1H3(184) &
    ,G1H3(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(58),[G2H3(29),G1H3(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(154),[G2H3(44),G2H3(41),G2H3(35),G2H3(32),G1H3(129) &
    ,G1H3(107),G1H3(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(142),[G2H3(47),G2H3(38),G1H3(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G1H3(94)])
call HGT_OLR(G2H3(49),1,1,3)
call HGT_invQ_OLR(G2H3(49),2,5,3)
call HGT_OLR(G2H3(49),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(49),[G2H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G2H2(59),G2H2(24),G1H2(44),G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(25),[G2H3(10),G1H3(105)])
call HGT_OLR(G2H3(50),1,1,3)
call HGT_invQ_OLR(G2H3(50),2,5,3)
call HGT_OLR(G2H3(50),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(50),[G2H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G2H2(84),G2H2(55),G2H2(27),G1H2(132),G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(28),[G2H3(19),G1H3(116)])
call HGT_OLR(G2H3(51),1,1,3)
call HGT_invQ_OLR(G2H3(51),2,5,3)
call HGT_OLR(G2H3(51),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(51),[G2H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G2H2(89),G2H2(67),G2H2(63),G2H2(30),G1H2(148) &
    ,G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(22),[G1H3(127)])
call HGT_OLR(G2H3(52),1,1,3)
call HGT_invQ_OLR(G2H3(52),2,5,3)
call HGT_OLR(G2H3(52),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(52),[G2H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(33),G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(62),[G2H3(54),G1H3(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(78),[G2H3(64),G2H3(57),G1H3(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(80),[G2H3(72),G2H3(79),G2H3(76),G2H3(60),G1H3(195) &
    ,G1H3(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(74),[G2H3(63),G1H3(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(6)])
call HGT_OLR(G2H3(65),1,1,3)
call HGT_invQ_OLR(G2H3(65),2,5,3)
call HGT_OLR(G2H3(65),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(65),[G2H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G2H2(79),G2H2(40),G1H2(88),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(71),[G2H3(9),G1H3(17)])
call HGT_OLR(G2H3(66),1,1,3)
call HGT_invQ_OLR(G2H3(66),2,5,3)
call HGT_OLR(G2H3(66),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(66),[G2H3(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(111),[G2H2(103),G2H2(83),G2H2(43),G1H2(174),G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(77),[G2H3(36),G1H3(28)])
call HGT_OLR(G2H3(67),1,1,3)
call HGT_invQ_OLR(G2H3(67),2,5,3)
call HGT_OLR(G2H3(67),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(67),[G2H3(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(106),G2H2(91),G2H2(87),G2H2(46),G1H2(185) &
    ,G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(39),[G1H3(39)])
call HGT_OLR(G2H3(68),1,1,3)
call HGT_invQ_OLR(G2H3(68),2,5,3)
call HGT_OLR(G2H3(68),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(68),[G2H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G2H2(49),G1H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(103),[G1H3(99)])
call HGT_OLR(G2H3(81),1,1,3)
call HGT_invQ_OLR(G2H3(81),2,5,3)
call HGT_OLR(G2H3(81),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(81),[G2H3(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(72),G1H2(192),G1H2(32),G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(106),[G1H3(103)])
call HGT_lower_alpha_w2_OLR(G2H3(82),1,1,3)
call HGT_lower_alpha_w2_invQ_OLR(G2H3(82),2,5,3)
call HGT_lower_alpha_w2_OLR(G2H3(82),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(82),[G2H3(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G2H2(75),G1H2(34),G1H2(38),G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G1H2(80)])
call HGT_OLR(G2H2(94),1,1,2)
call HGT_invQ_OLR(G2H2(94),2,5,2)
call HGT_OLR(G2H2(94),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G1H2(84)])
call HGT_lower_alpha_w2_OLR(G2H2(98),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(98),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(98),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(83)])
call HGT_w2_OLR(G1H3(1),1,1,3)
call HGT_w2_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(102)])
call HGT_w2_OLR(G1H3(2),1,1,3)
call HGT_w2_invQ_OLR(G1H3(2),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(110),[G2H2(109),G2H2(105),G2H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(75)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(1)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G1H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(162),[G1H3(47),G1H3(25),G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(75),[G2H3(34),G1H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G2H3(37),G1H3(194),G1H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(200),[G1H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(150),[G1H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(69),[G1H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(107),[G1H3(84),G1H3(62),G1H3(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(109),[G1H3(90),G1H3(68),G1H3(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G1H3(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G1H3(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(110),[G1H3(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(112),[G1H3(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(190),[G1H3(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(18),[G1H3(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(156),[G1H3(135),G1H3(113),G1H3(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(27),[G2H3(12),G1H3(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(30),[G2H3(21),G1H3(183),G1H3(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(189),[G1H3(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(144),[G1H3(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G1H3(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G1H2(76),G1H2(54),G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(131),[G1H2(82),G1H2(60),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(143),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(138),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(132),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(31),[G1H3(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(115),[G1H3(172),G1H3(150),G1H3(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(117),[G1H3(178),G1H3(156),G1H3(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(33),[G1H3(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(43),[G1H3(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(118),[G1H3(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(120),[G1H3(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(201),[G1H3(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(45),[G1H3(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(137),[G1H2(120),G1H2(98),G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(139),[G1H2(126),G1H2(104),G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(169),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(180),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(142),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(191),[G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G1H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(48),[G2H3(46),G1H3(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G2H2(74),G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(77),G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(42),[G2H3(40),G1H3(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(196),[G1H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(201),[G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(39),G1H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(41),G1H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(145),[G2H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(123),[G2H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G2H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G2H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(15),[G1H6(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(16),[G1H6(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(25),[G1H6(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(29),[G1H6(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(91),[G1H3(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(92),[G1H3(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(93),[G1H3(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(94),[G1H3(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(116),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(104),[G1H3(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(105),[G1H3(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(118),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(119),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(155),[G2H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(157),[G2H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(39),[G1H2(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(158),[G2H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(160),[G2H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(78),[G1H2(15)])
call HGT_OLR(G2H2(7),1,1,2)
call HGT_invQ_OLR(G2H2(7),2,5,2)
call HGT_OLR(G2H2(7),6,15,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(47),mass4set(:,2),  & 
G1H2(111),G1H2(122),G1H2(133),G1H2(149),G1H2(175),2)
  call HG1shiftOLR(G1H2(122),2,2)
  call Hotf_4pt_reduction(G2H3(160),RedSet_4(26),mass4set(:,13),  & 
G1H3(48),G1H3(49),G1H3(54),G1H3(55),G1H3(59),3)
  call HG1shiftOLR(G1H3(49),8,3)
call HGT_OLR(G2H2(8),1,1,2)
call HGT_invQ_OLR(G2H2(8),2,5,2)
call HGT_OLR(G2H2(8),6,15,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(47),mass4set(:,3),  & 
G1H2(186),G1H2(4),G1H2(5),G1H2(139),G1H2(10),2)
  call HG1shiftOLR(G1H2(4),2,2)
call HGT_OLR(G2H2(9),1,1,2)
call HGT_invQ_OLR(G2H2(9),2,5,2)
call HGT_OLR(G2H2(9),6,15,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(47),mass4set(:,4),  & 
G1H2(11),G1H2(155),G1H2(16),G1H2(17),G1H2(160),2)
  call HG1shiftOLR(G1H2(155),2,2)
  call Hotf_4pt_reduction(G2H3(148),RedSet_4(26),mass4set(:,14),  & 
G1H3(60),G1H3(65),G1H3(66),G1H3(70),G1H3(71),3)
  call HG1shiftOLR(G1H3(65),8,3)
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(47),mass4set(:,5),  & 
G1H2(22),G1H2(23),G1H2(165),G1H2(28),G1H2(29),2)
  call HG1shiftOLR(G1H2(23),2,2)
call HGT_OLR(G2H2(11),1,1,2)
call HGT_invQ_OLR(G2H2(11),2,5,2)
call HGT_OLR(G2H2(11),6,15,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(47),mass4set(:,3),  & 
G1H2(35),G1H2(197),G1H2(40),G1H2(41),G1H2(46),2)
  call HG1shiftOLR(G1H2(197),2,2)
call HGT_OLR(G2H2(12),1,1,2)
call HGT_invQ_OLR(G2H2(12),2,5,2)
call HGT_OLR(G2H2(12),6,15,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(47),mass4set(:,4),  & 
G1H2(47),G1H2(51),G1H2(52),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(51),2,2)
call HGT_OLR(G2H2(13),1,1,2)
call HGT_invQ_OLR(G2H2(13),2,5,2)
call HGT_OLR(G2H2(13),6,15,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(48),mass4set(:,6),  & 
G1H2(62),G1H2(63),G1H2(90),G1H2(91),G1H2(95),2)
  call HG1shiftOLR(G1H2(63),4,2)
  call Hotf_4pt_reduction(G2H3(53),RedSet_4(30),mass4set(:,6),  & 
G1H3(76),G1H3(77),G1H3(81),G1H3(82),G1H3(110),3)
  call HG1shiftOLR(G1H3(77),8,3)
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(48),mass4set(:,7),  & 
G1H2(96),G1H2(102),G1H2(106),G1H2(107),G1H2(112),2)
  call HG1shiftOLR(G1H2(102),4,2)
  call Hotf_4pt_reduction(G2H3(59),RedSet_4(30),mass4set(:,7),  & 
G1H3(114),G1H3(115),G1H3(121),G1H3(125),G1H3(126),3)
  call HG1shiftOLR(G1H3(115),8,3)
call HGT_OLR(G2H2(15),1,1,2)
call HGT_invQ_OLR(G2H2(15),2,5,2)
call HGT_OLR(G2H2(15),6,15,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(48),mass4set(:,8),  & 
G1H2(113),G1H2(118),G1H2(123),G1H2(124),G1H2(129),2)
  call HG1shiftOLR(G1H2(118),4,2)
  call Hotf_4pt_reduction(G2H3(61),RedSet_4(30),mass4set(:,8),  & 
G1H3(132),G1H3(136),G1H3(137),G1H3(143),G1H3(147),3)
  call HG1shiftOLR(G1H3(136),8,3)
call HGT_OLR(G2H2(16),1,1,2)
call HGT_invQ_OLR(G2H2(16),2,5,2)
call HGT_OLR(G2H2(16),6,15,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(48),mass4set(:,9),  & 
G1H2(134),G1H2(135),G1H2(144),G1H2(145),G1H2(150),2)
  call HG1shiftOLR(G1H2(135),4,2)
  call Hotf_4pt_reduction(G2H3(58),RedSet_4(30),mass4set(:,9),  & 
G1H3(148),G1H3(158),G1H3(159),G1H3(164),G1H3(169),3)
  call HG1shiftOLR(G1H3(158),8,3)
call HGT_OLR(G2H2(17),1,1,2)
call HGT_invQ_OLR(G2H2(17),2,5,2)
call HGT_OLR(G2H2(17),6,15,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(49),mass4set(:,2),  & 
G1H2(156),G1H2(161),G1H2(166),G1H2(170),G1H2(176),2)
  call HG1shiftOLR(G1H2(161),1,2)
  call Hotf_4pt_reduction(G2H3(154),RedSet_4(26),mass4set(:,13),  & 
G1H3(170),G1H3(175),G1H3(180),G1H3(181),G1H3(186),3)
  call HG1shiftOLR(G1H3(175),8,3)
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(49),mass4set(:,3),  & 
G1H2(177),G1H2(181),G1H2(182),G1H2(187),G1H2(193),2)
  call HG1shiftOLR(G1H2(181),1,2)
call HGT_OLR(G2H2(19),1,1,2)
call HGT_invQ_OLR(G2H2(19),2,5,2)
call HGT_OLR(G2H2(19),6,15,2)
  call Hotf_4pt_reduction(G2H2(19),RedSet_4(49),mass4set(:,4),  & 
G1H2(198),G1H2(9),G1H2(21),G1H2(27),G1H2(33),2)
  call HG1shiftOLR(G1H2(9),1,2)
  call Hotf_4pt_reduction(G2H3(142),RedSet_4(26),mass4set(:,14),  & 
G1H3(191),G1H3(192),G1H3(197),G1H3(9),G1H3(20),3)
  call HG1shiftOLR(G1H3(192),8,3)
call HGT_OLR(G2H2(20),1,1,2)
call HGT_invQ_OLR(G2H2(20),2,5,2)
call HGT_OLR(G2H2(20),6,15,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(49),mass4set(:,5),  & 
G1H2(45),G1H2(56),G1H2(67),G1H2(44),G1H2(8),2)
  call HG1shiftOLR(G1H2(56),1,2)
call HGT_OLR(G2H2(21),1,1,2)
call HGT_invQ_OLR(G2H2(21),2,5,2)
call HGT_OLR(G2H2(21),6,15,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(49),mass4set(:,3),  & 
G1H2(132),G1H2(55),G1H2(148),G1H2(66),G1H2(77),2)
  call HG1shiftOLR(G1H2(55),1,2)
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(49),mass4set(:,4),  & 
G1H2(88),G1H2(26),G1H2(174),G1H2(99),G1H2(185),2)
  call HG1shiftOLR(G1H2(26),1,2)
  call Hotf_4pt_reduction(G2H3(49),RedSet_4(32),mass4set(:,6),  & 
G1H3(31),G1H3(53),G1H3(64),G1H3(75),G1H3(97),3)
  call HG1shiftOLR(G1H3(53),8,3)
  call Hotf_4pt_reduction(G2H2(81),RedSet_4(18),mass4set(:,6),  & 
G1H2(110),G1H2(121),G1H2(192),G1H2(32),G1H2(14),2)
  call HG1shiftOLR(G1H2(121),4,2)
  call Hotf_4pt_reduction(G2H3(50),RedSet_4(32),mass4set(:,7),  & 
G1H3(108),G1H3(119),G1H3(141),G1H3(152),G1H3(163),3)
  call HG1shiftOLR(G1H3(119),8,3)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(18),mass4set(:,7),  & 
G1H2(34),G1H2(38),G1H2(20),G1H2(80),G1H2(84),2)
  call HG1shiftOLR(G1H2(38),4,2)
  call Hotf_4pt_reduction(G2H3(51),RedSet_4(32),mass4set(:,8),  & 
G1H3(185),G1H3(196),G1H3(4),G1H3(10),G1H3(11),3)
  call HG1shiftOLR(G1H3(196),8,3)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(18),mass4set(:,8),  & 
G1H2(75),G1H2(1),G1H2(81),G1H2(6),G1H2(7),2)
  call HG1shiftOLR(G1H2(1),4,2)
  call Hotf_4pt_reduction(G2H3(52),RedSet_4(32),mass4set(:,9),  & 
G1H3(15),G1H3(21),G1H3(22),G1H3(26),G1H3(32),3)
  call HG1shiftOLR(G1H3(21),8,3)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(18),mass4set(:,9),  & 
G1H2(12),G1H2(13),G1H2(18),G1H2(19),G1H2(24),2)
  call HG1shiftOLR(G1H2(13),4,2)
call HGT_OLR(G2H2(35),1,1,2)
call HGT_invQ_OLR(G2H2(35),2,5,2)
call HGT_OLR(G2H2(35),6,15,2)
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(50),mass4set(:,6),  & 
G1H2(25),G1H2(30),G1H2(31),G1H2(36),G1H2(37),2)
  call HG1shiftOLR(G1H2(30),4,2)
  call Hotf_4pt_reduction(G2H3(62),RedSet_4(39),mass4set(:,6),  & 
G1H3(33),G1H3(37),G1H3(41),G1H3(19),G1H3(8),3)
  call HG1shiftOLR(G1H3(37),8,3)
call HGT_OLR(G2H2(36),1,1,2)
call HGT_invQ_OLR(G2H2(36),2,5,2)
call HGT_OLR(G2H2(36),6,15,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(50),mass4set(:,7),  & 
G1H2(42),G1H2(76),G1H2(54),G1H2(43),G1H2(82),2)
  call HG1shiftOLR(G1H2(76),4,2)
  call Hotf_4pt_reduction(G2H3(78),RedSet_4(39),mass4set(:,7),  & 
G1H3(30),G1H3(52),G1H3(63),G1H3(184),G1H3(74),3)
  call HG1shiftOLR(G1H3(52),8,3)
call HGT_OLR(G2H2(37),1,1,2)
call HGT_invQ_OLR(G2H2(37),2,5,2)
call HGT_OLR(G2H2(37),6,15,2)
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(50),mass4set(:,8),  & 
G1H2(60),G1H2(49),G1H2(50),G1H2(53),G1H2(61),2)
  call HG1shiftOLR(G1H2(49),4,2)
  call Hotf_4pt_reduction(G2H3(80),RedSet_4(39),mass4set(:,8),  & 
G1H3(85),G1H3(129),G1H3(107),G1H3(96),G1H3(118),3)
  call HG1shiftOLR(G1H3(129),8,3)
call HGT_OLR(G2H2(38),1,1,2)
call HGT_invQ_OLR(G2H2(38),2,5,2)
call HGT_OLR(G2H2(38),6,15,2)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(50),mass4set(:,9),  & 
G1H2(64),G1H2(65),G1H2(71),G1H2(72),G1H2(86),2)
  call HG1shiftOLR(G1H2(65),4,2)
  call Hotf_4pt_reduction(G2H3(74),RedSet_4(39),mass4set(:,9),  & 
G1H3(94),G1H3(105),G1H3(116),G1H3(127),G1H3(140),3)
  call HG1shiftOLR(G1H3(105),8,3)
  call Hotf_4pt_reduction(G2H3(65),RedSet_4(24),mass4set(:,6),  & 
G1H3(151),G1H3(195),G1H3(162),G1H3(173),G1H3(6),3)
  call HG1shiftOLR(G1H3(195),8,3)
  call Hotf_4pt_reduction(G2H2(101),RedSet_4(22),mass4set(:,6),  & 
G1H2(120),G1H2(98),G1H2(87),G1H2(126),G1H2(104),2)
  call HG1shiftOLR(G1H2(98),4,2)
  call Hotf_4pt_reduction(G2H3(66),RedSet_4(24),mass4set(:,7),  & 
G1H3(17),G1H3(28),G1H3(39),G1H3(99),G1H3(103),3)
  call HG1shiftOLR(G1H3(28),8,3)
  call Hotf_4pt_reduction(G2H2(111),RedSet_4(22),mass4set(:,7),  & 
G1H2(93),G1H2(94),G1H2(97),G1H2(105),G1H2(108),2)
  call HG1shiftOLR(G1H2(94),4,2)
  call Hotf_4pt_reduction(G2H3(67),RedSet_4(24),mass4set(:,8),  & 
G1H3(83),G1H3(1),G1H3(89),G1H3(7),G1H3(47),3)
  call HG1shiftOLR(G1H3(1),8,3)
  call Hotf_4pt_reduction(G2H2(112),RedSet_4(22),mass4set(:,8),  & 
G1H2(109),G1H2(115),G1H2(116),G1H2(119),G1H2(130),2)
  call HG1shiftOLR(G1H2(115),4,2)
  call Hotf_4pt_reduction(G2H3(68),RedSet_4(24),mass4set(:,9),  & 
G1H3(25),G1H3(14),G1H3(18),G1H3(194),G1H3(29),3)
  call HG1shiftOLR(G1H3(14),8,3)
  call Hotf_4pt_reduction(G2H2(108),RedSet_4(22),mass4set(:,9),  & 
G1H2(131),G1H2(146),G1H2(147),G1H2(159),G1H2(164),2)
  call HG1shiftOLR(G1H2(146),4,2)
call HGT_OLR(G2H2(51),1,1,2)
call HGT_invQ_OLR(G2H2(51),2,5,2)
call HGT_OLR(G2H2(51),6,15,2)
  call Hotf_4pt_reduction(G2H2(51),RedSet_4(51),mass4set(:,10),  & 
G1H2(172),G1H2(173),G1H2(183),G1H2(184),G1H2(69),2)
  call HG1shiftOLR(G1H2(173),1,2)
call HGT_OLR(G2H2(52),1,1,2)
call HGT_invQ_OLR(G2H2(52),2,5,2)
call HGT_OLR(G2H2(52),6,15,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(51),mass4set(:,10),  & 
G1H2(74),G1H2(68),G1H2(73),G1H2(85),G1H2(79),2)
  call HG1shiftOLR(G1H2(68),1,2)
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(52),mass4set(:,11),  & 
G1H2(188),G1H2(15),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(15),1,2)
call HGT_OLR(G2H2(58),1,1,2)
call HGT_invQ_OLR(G2H2(58),2,5,2)
call HGT_OLR(G2H2(58),6,15,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(52),mass4set(:,12),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),2)
  call HG1shiftOLR(G1H2(206),1,2)
call HGT_OLR(G2H2(62),1,1,2)
call HGT_invQ_OLR(G2H2(62),2,5,2)
call HGT_OLR(G2H2(62),6,15,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(52),mass4set(:,10),  & 
G1H2(210),G1H2(211),G1H2(212),G1H2(213),G1H2(214),2)
  call HG1shiftOLR(G1H2(211),1,2)
call HGT_OLR(G2H2(66),1,1,2)
call HGT_invQ_OLR(G2H2(66),2,5,2)
call HGT_OLR(G2H2(66),6,15,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(52),mass4set(:,10),  & 
G1H2(215),G1H2(216),G1H2(217),G1H2(218),G1H2(219),2)
  call HG1shiftOLR(G1H2(216),1,2)
call HGT_OLR(G2H2(69),1,1,2)
call HGT_invQ_OLR(G2H2(69),2,5,2)
call HGT_OLR(G2H2(69),6,15,2)
  call Hotf_4pt_reduction(G2H2(69),RedSet_4(53),mass4set(:,10),  & 
G1H2(220),G1H2(221),G1H2(222),G1H2(223),G1H2(224),2)
  call HG1shiftOLR(G1H2(221),2,2)
call HGT_OLR(G2H2(70),1,1,2)
call HGT_invQ_OLR(G2H2(70),2,5,2)
call HGT_OLR(G2H2(70),6,15,2)
  call Hotf_4pt_reduction(G2H2(70),RedSet_4(53),mass4set(:,10),  & 
G1H2(225),G1H2(226),G1H2(227),G1H2(228),G1H2(229),2)
  call HG1shiftOLR(G1H2(226),2,2)
  call Hotf_4pt_reduction(G2H3(81),RedSet_4(28),mass4set(:,17),  & 
G1H3(35),G1H3(36),G1H3(40),G1H3(50),G1H3(84),3)
  call HG1shiftOLR(G1H3(36),8,3)
  call Hotf_4pt_reduction(G2H2(95),RedSet_4(1),mass4set(:,10),  & 
G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(231),2,2)
  call Hotf_4pt_reduction(G2H3(82),RedSet_4(28),mass4set(:,17),  & 
G1H3(62),G1H3(51),G1H3(90),G1H3(68),G1H3(57),3)
  call HG1shiftOLR(G1H3(51),8,3)
  call Hotf_4pt_reduction(G2H2(99),RedSet_4(1),mass4set(:,10),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),2)
  call HG1shiftOLR(G1H2(236),2,2)
call HGT_OLR(G2H2(78),1,1,2)
call HGT_invQ_OLR(G2H2(78),2,5,2)
call HGT_OLR(G2H2(78),6,15,2)
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(54),mass4set(:,12),  & 
G1H2(240),G1H2(241),G1H2(242),G1H2(243),G1H2(244),2)
  call HG1shiftOLR(G1H2(241),2,2)
call HGT_OLR(G2H2(82),1,1,2)
call HGT_invQ_OLR(G2H2(82),2,5,2)
call HGT_OLR(G2H2(82),6,15,2)
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(54),mass4set(:,11),  & 
G1H2(245),G1H2(246),G1H2(247),G1H2(248),G1H2(249),2)
  call HG1shiftOLR(G1H2(246),2,2)
call HGT_OLR(G2H2(86),1,1,2)
call HGT_invQ_OLR(G2H2(86),2,5,2)
call HGT_OLR(G2H2(86),6,15,2)
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(54),mass4set(:,10),  & 
G1H2(250),G1H2(251),G1H2(252),G1H2(253),G1H2(254),2)
  call HG1shiftOLR(G1H2(251),2,2)
call HGT_OLR(G2H2(90),1,1,2)
call HGT_invQ_OLR(G2H2(90),2,5,2)
call HGT_OLR(G2H2(90),6,15,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(54),mass4set(:,10),  & 
G1H2(255),G1H2(256),G1H2(257),G1H2(258),G1H2(259),2)
  call HG1shiftOLR(G1H2(256),2,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(35),mass4set(:,17),  & 
G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),2)
  call HG1shiftOLR(G1H2(261),4,2)
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(35),mass4set(:,17),  & 
G1H2(265),G1H2(266),G1H2(267),G1H2(268),G1H2(269),2)
  call HG1shiftOLR(G1H2(266),4,2)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(28),mass4set(:,18),  & 
G1H3(61),G1H3(72),G1H3(73),G1H3(79),G1H3(80),3)
  call HG1shiftOLR(G1H3(72),8,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(107),ex2(:),G2tensor(8),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hloop_QZ_A(ntryL,G1H3(2),ex4(:),G1H1(1),ngZd,m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(17),n2h1(145))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(110),ex2(:),G2tensor(1),m3h2x1(:,78),heltab2x2(:,:,78))
call HGT_w2_OLR(G1H3(3),1,1,3)
call HGT_w2_invQ_OLR(G1H3(3),2,5,3)
  call Hloop_QZ_A(ntryL,G1H3(3),ex4(:),G1H1(1),ngZd,m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(3),n2h1(146))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(35),mass4set(:,18),  & 
G1H2(270),G1H2(271),G1H2(272),G1H2(273),G1H2(274),2)
  call HG1shiftOLR(G1H2(271),4,2)
  call Hloop_QV_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(5),n2h1(147))
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(11),n2h1(148))
  call Hotf_4pt_reduction(G2H2(57),RedSet_4(16),mass4set(:,19),  & 
G1H2(2),G1H2(3),G1H2(275),G1H2(276),G1H2(277),2)
  call HG1shiftOLR(G1H2(3),4,2)
  call Hotf_4pt_reduction(G2H2(71),RedSet_4(17),mass4set(:,7),  & 
G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(279),4,2)
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(10),mass4set(:,20),  & 
G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),2)
  call HG1shiftOLR(G1H2(284),2,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(11),mass4set(:,10),  & 
G1H2(288),G1H2(289),G1H2(290),G1H2(291),G1H2(292),2)
  call HG1shiftOLR(G1H2(289),2,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(10),mass4set(:,20),  & 
G1H2(293),G1H2(294),G1H2(295),G1H2(296),G1H2(297),2)
  call HG1shiftOLR(G1H2(294),2,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(11),mass4set(:,10),  & 
G1H2(298),G1H2(299),G1H2(300),G1H2(301),G1H2(302),2)
  call HG1shiftOLR(G1H2(299),2,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(20),mass4set(:,19),  & 
G1H2(303),G1H2(304),G1H2(305),G1H2(306),G1H2(307),2)
  call HG1shiftOLR(G1H2(304),4,2)
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(21),mass4set(:,7),  & 
G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(309),4,2)
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(13),mass4set(:,20),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),2)
  call HG1shiftOLR(G1H2(314),2,2)
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(14),mass4set(:,10),  & 
G1H2(318),G1H2(319),G1H2(320),G1H2(321),G1H2(322),2)
  call HG1shiftOLR(G1H2(319),2,2)
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(13),mass4set(:,20),  & 
G1H2(323),G1H2(324),G1H2(325),G1H2(326),G1H2(327),2)
  call HG1shiftOLR(G1H2(324),2,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(14),mass4set(:,10),  & 
G1H2(328),G1H2(329),G1H2(330),G1H2(331),G1H2(332),2)
  call HG1shiftOLR(G1H2(329),2,2)
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(25),mass4set(:,6),  & 
G1H3(95),G1H3(135),G1H3(113),G1H3(102),G1H3(106),3)
  call HG1shiftOLR(G1H3(135),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(12),ex4(:),G1H1(1),ngZd,m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(14),n2h1(149))
  call Hloop_AZ_Q(ntryL,G1H3(13),ex4(:),G1H1(1),ngZd,m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(20),n2h1(150))
  call Hloop_AZ_Q(ntryL,G2H3(162),ex4(:),G2H1(1),ngZd,m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(1),n2h1(151))
  call Hotf_4pt_reduction(G2H3(75),RedSet_4(25),mass4set(:,7),  & 
G1H3(183),G1H3(117),G1H3(123),G1H3(124),G1H3(128),3)
  call HG1shiftOLR(G1H3(117),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(23),ex4(:),G1H1(1),ngZd,m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(23),n2h1(152))
  call Hloop_AZ_Q(ntryL,G1H3(24),ex4(:),G1H1(1),ngZd,m3h3x1(:,79),heltab2x3(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(27),n2h1(153))
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(25),mass4set(:,8),  & 
G1H3(138),G1H3(172),G1H3(150),G1H3(139),G1H3(178),3)
  call HG1shiftOLR(G1H3(172),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(34),ex4(:),G1H1(1),ngZu,m3h3x1(:,80),heltab2x3(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(31),n2h1(154))
  call Hloop_AZ_Q(ntryL,G1H3(200),ex4(:),G1H1(1),ngZu,m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(35),n2h1(155))
  call Hloop_AZ_Q(ntryL,G2H3(150),ex4(:),G2H1(1),ngZu,m3h3x1(:,82),heltab2x3(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(2),n2h1(156))
  call Hotf_4pt_reduction(G2H3(69),RedSet_4(25),mass4set(:,9),  & 
G1H3(156),G1H3(145),G1H3(149),G1H3(160),G1H3(161),3)
  call HG1shiftOLR(G1H3(145),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(45),ex4(:),G1H1(1),ngZd,m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(157))
  call Hloop_AZ_Q(ntryL,G1H3(46),ex4(:),G1H1(1),ngZd,m3h3x1(:,84),heltab2x3(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(43),n2h1(158))
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(28),mass4set(:,21),  & 
G1H3(167),G1H3(168),G1H3(171),G1H3(182),G1H3(193),3)
  call HG1shiftOLR(G1H3(168),8,3)
  call Hotf_4pt_reduction(G2H3(107),RedSet_4(29),mass4set(:,13),  & 
G1H3(88),G1H3(93),G1H3(87),G1H3(92),G1H3(104),3)
  call HG1shiftOLR(G1H3(93),8,3)
  call Hloop_QZ_A(ntryL,G1H3(56),ex4(:),G1H1(1),ngZd,m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(47),n2h1(159))
  call Hloop_QZ_A(ntryL,G2H3(109),ex4(:),G2H1(1),ngZd,m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(3),n2h1(160))
  call Hloop_QZ_A(ntryL,G1H3(58),ex4(:),G1H1(1),ngZd,m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(51),n2h1(161))
  call Hotf_4pt_reduction(G2H3(13),RedSet_4(28),mass4set(:,22),  & 
G1H3(98),G1H3(2),G1H3(3),G1H3(12),G1H3(13),3)
  call HG1shiftOLR(G1H3(2),8,3)
  call Hloop_QZ_A(ntryL,G1H3(67),ex4(:),G1H1(1),ngZd,m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(162))
  call Hloop_QZ_A(ntryL,G1H3(69),ex4(:),G1H1(1),ngZd,m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(163))
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(28),mass4set(:,23),  & 
G1H3(23),G1H3(24),G1H3(34),G1H3(200),G1H3(45),3)
  call HG1shiftOLR(G1H3(24),8,3)
  call Hotf_4pt_reduction(G2H3(110),RedSet_4(29),mass4set(:,14),  & 
G1H3(46),G1H3(56),G1H3(58),G1H3(67),G1H3(69),3)
  call HG1shiftOLR(G1H3(56),8,3)
  call Hloop_QZ_A(ntryL,G1H3(78),ex4(:),G1H1(1),ngZu,m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(63),n2h1(164))
  call Hloop_QZ_A(ntryL,G2H3(112),ex4(:),G2H1(1),ngZu,m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(4),n2h1(165))
  call Hloop_QZ_A(ntryL,G1H3(190),ex4(:),G1H1(1),ngZu,m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(67),n2h1(166))
  call Hloop_QZ_A(ntryL,G1H3(91),ex4(:),G1H1(1),ngZd,m3h3x1(:,93),heltab2x3(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(167))
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(33),mass4set(:,6),  & 
G1H3(78),G1H3(190),G1H3(91),G1H3(202),G1H3(203),3)
  call HG1shiftOLR(G1H3(190),8,3)
  call Hloop_QZ_A(ntryL,G1H3(100),ex4(:),G1H1(1),ngZd,m3h3x1(:,94),heltab2x3(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(75),n2h1(168))
  call Hloop_QZ_A(ntryL,G1H3(101),ex4(:),G1H1(1),ngZd,m3h3x1(:,95),heltab2x3(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(79),n2h1(169))
  call Hloop_QZ_A(ntryL,G2H3(156),ex4(:),G2H1(1),ngZd,m3h3x1(:,96),heltab2x3(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(5),n2h1(170))
  call Hotf_4pt_reduction(G2H3(27),RedSet_4(33),mass4set(:,7),  & 
G1H3(100),G1H3(101),G1H3(204),G1H3(205),G1H3(206),3)
  call HG1shiftOLR(G1H3(101),8,3)
  call Hloop_QZ_A(ntryL,G1H3(111),ex4(:),G1H1(1),ngZd,m3h3x1(:,97),heltab2x3(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(83),n2h1(171))
  call Hloop_QZ_A(ntryL,G1H3(112),ex4(:),G1H1(1),ngZd,m3h3x1(:,98),heltab2x3(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(87),n2h1(172))
  call Hotf_4pt_reduction(G2H3(30),RedSet_4(33),mass4set(:,8),  & 
G1H3(111),G1H3(112),G1H3(207),G1H3(208),G1H3(209),3)
  call HG1shiftOLR(G1H3(112),8,3)
  call Hloop_QZ_A(ntryL,G1H3(122),ex4(:),G1H1(1),ngZu,m3h3x1(:,99),heltab2x3(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(91),n2h1(173))
  call Hloop_QZ_A(ntryL,G1H3(189),ex4(:),G1H1(1),ngZu,m3h3x1(:,100),heltab2x3(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(95),n2h1(174))
  call Hloop_QZ_A(ntryL,G2H3(144),ex4(:),G2H1(1),ngZu,m3h3x1(:,101),heltab2x3(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(6),n2h1(175))
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(33),mass4set(:,9),  & 
G1H3(122),G1H3(189),G1H3(210),G1H3(211),G1H3(212),3)
  call HG1shiftOLR(G1H3(189),8,3)
  call Hloop_QZ_A(ntryL,G1H3(133),ex4(:),G1H1(1),ngZd,m3h3x1(:,102),heltab2x3(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(99),n2h1(176))
  call Hloop_QZ_A(ntryL,G1H3(134),ex4(:),G1H1(1),ngZd,m3h3x1(:,103),heltab2x3(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(103),n2h1(177))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(35),mass4set(:,21),  & 
G1H2(333),G1H2(334),G1H2(335),G1H2(336),G1H2(337),2)
  call HG1shiftOLR(G1H2(334),4,2)
  call Hotf_4pt_reduction(G2H2(129),RedSet_4(36),mass4set(:,13),  & 
G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(339),4,2)
  call Hloop_QV_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(107),n2h1(178))
  call Hloop_QV_A(ntryL,G2H2(131),ex3(:),G2H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(7),n2h1(179))
  call Hloop_QV_A(ntryL,G1H2(143),ex3(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(111),n2h1(180))
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(35),mass4set(:,22),  & 
G1H2(48),G1H2(143),G1H2(343),G1H2(344),G1H2(345),2)
  call HG1shiftOLR(G1H2(143),4,2)
  call Hloop_QV_A(ntryL,G1H2(59),ex3(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(115),n2h1(181))
  call Hloop_QV_A(ntryL,G1H2(138),ex3(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(119),n2h1(182))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(35),mass4set(:,23),  & 
G1H2(59),G1H2(138),G1H2(346),G1H2(347),G1H2(348),2)
  call HG1shiftOLR(G1H2(138),4,2)
  call Hotf_4pt_reduction(G2H2(132),RedSet_4(36),mass4set(:,14),  & 
G1H2(349),G1H2(350),G1H2(351),G1H2(352),G1H2(353),2)
  call HG1shiftOLR(G1H2(350),4,2)
  call Hloop_QV_A(ntryL,G1H2(70),ex3(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(123),n2h1(183))
  call Hloop_QV_A(ntryL,G2H2(134),ex3(:),G2H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(8),n2h1(184))
  call Hloop_QV_A(ntryL,G1H2(154),ex3(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(128),n2h1(185))
  call Hloop_QV_A(ntryL,G1H2(83),ex3(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(132),n2h1(186))
  call Hotf_4pt_reduction(G2H3(31),RedSet_4(38),mass4set(:,21),  & 
G1H3(133),G1H3(134),G1H3(213),G1H3(214),G1H3(215),3)
  call HG1shiftOLR(G1H3(134),8,3)
  call Hotf_4pt_reduction(G2H3(115),RedSet_4(29),mass4set(:,13),  & 
G1H3(216),G1H3(217),G1H3(218),G1H3(219),G1H3(220),3)
  call HG1shiftOLR(G1H3(217),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(144),ex4(:),G1H1(1),ngZd,m3h3x1(:,104),heltab2x3(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(139),n2h1(187))
  call Hloop_AZ_Q(ntryL,G2H3(117),ex4(:),G2H1(1),ngZd,m3h3x1(:,105),heltab2x3(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(9),n2h1(188))
  call Hloop_AZ_Q(ntryL,G1H3(146),ex4(:),G1H1(1),ngZd,m3h3x1(:,106),heltab2x3(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(143),n2h1(189))
  call Hotf_4pt_reduction(G2H3(33),RedSet_4(38),mass4set(:,22),  & 
G1H3(144),G1H3(146),G1H3(221),G1H3(222),G1H3(223),3)
  call HG1shiftOLR(G1H3(146),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(155),ex4(:),G1H1(1),ngZd,m3h3x1(:,107),heltab2x3(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(149),n2h1(190))
  call Hloop_AZ_Q(ntryL,G1H3(157),ex4(:),G1H1(1),ngZd,m3h3x1(:,108),heltab2x3(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(150),n2h1(191))
  call Hotf_4pt_reduction(G2H3(43),RedSet_4(38),mass4set(:,23),  & 
G1H3(155),G1H3(157),G1H3(224),G1H3(225),G1H3(226),3)
  call HG1shiftOLR(G1H3(157),8,3)
  call Hotf_4pt_reduction(G2H3(118),RedSet_4(29),mass4set(:,14),  & 
G1H3(227),G1H3(228),G1H3(229),G1H3(230),G1H3(231),3)
  call HG1shiftOLR(G1H3(228),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(166),ex4(:),G1H1(1),ngZu,m3h3x1(:,109),heltab2x3(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(151),n2h1(192))
  call Hloop_AZ_Q(ntryL,G2H3(120),ex4(:),G2H1(1),ngZu,m3h3x1(:,110),heltab2x3(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(10),n2h1(193))
  call Hloop_AZ_Q(ntryL,G1H3(201),ex4(:),G1H1(1),ngZu,m3h3x1(:,111),heltab2x3(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(152),n2h1(194))
  call Hotf_4pt_reduction(G2H3(45),RedSet_4(38),mass4set(:,18),  & 
G1H3(166),G1H3(201),G1H3(232),G1H3(233),G1H3(234),3)
  call HG1shiftOLR(G1H3(201),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(177),ex4(:),G1H1(1),ngZd,m3h3x1(:,112),heltab2x3(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(153),n2h1(195))
  call Hloop_AZ_Q(ntryL,G1H3(179),ex4(:),G1H1(1),ngZd,m3h3x1(:,113),heltab2x3(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(154),n2h1(196))
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(41),mass4set(:,21),  & 
G1H2(70),G1H2(154),G1H2(83),G1H2(354),G1H2(355),2)
  call HG1shiftOLR(G1H2(154),4,2)
  call Hotf_4pt_reduction(G2H2(137),RedSet_4(36),mass4set(:,13),  & 
G1H2(356),G1H2(357),G1H2(358),G1H2(359),G1H2(360),2)
  call HG1shiftOLR(G1H2(357),4,2)
  call Hloop_AV_Q(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(155),n2h1(197))
  call Hloop_AV_Q(ntryL,G2H2(139),ex3(:),G2H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(11),n2h1(198))
  call Hloop_AV_Q(ntryL,G1H2(169),ex3(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(156),n2h1(199))
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(41),mass4set(:,22),  & 
G1H2(92),G1H2(169),G1H2(361),G1H2(362),G1H2(363),2)
  call HG1shiftOLR(G1H2(169),4,2)
  call Hloop_AV_Q(ntryL,G1H2(103),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(157),n2h1(200))
  call Hloop_AV_Q(ntryL,G1H2(180),ex3(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(158),n2h1(201))
  call Hotf_4pt_reduction(G2H2(61),RedSet_4(41),mass4set(:,23),  & 
G1H2(103),G1H2(180),G1H2(364),G1H2(365),G1H2(366),2)
  call HG1shiftOLR(G1H2(180),4,2)
  call Hotf_4pt_reduction(G2H2(140),RedSet_4(36),mass4set(:,14),  & 
G1H2(367),G1H2(368),G1H2(369),G1H2(370),G1H2(371),2)
  call HG1shiftOLR(G1H2(368),4,2)
  call Hloop_AV_Q(ntryL,G1H2(114),ex3(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(159),n2h1(202))
  call Hloop_AV_Q(ntryL,G2H2(142),ex3(:),G2H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(12),n2h1(203))
  call Hloop_AV_Q(ntryL,G1H2(191),ex3(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(160),n2h1(204))
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(41),mass4set(:,18),  & 
G1H2(114),G1H2(191),G1H2(372),G1H2(373),G1H2(374),2)
  call HG1shiftOLR(G1H2(191),4,2)
  call Hloop_AV_Q(ntryL,G1H2(125),ex3(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(161),n2h1(205))
  call Hloop_AV_Q(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(162),n2h1(206))
  call Hotf_4pt_reduction(G2H3(48),RedSet_4(43),mass4set(:,24),  & 
G1H3(177),G1H3(179),G1H3(235),G1H3(236),G1H3(237),3)
  call HG1shiftOLR(G1H3(179),8,3)
  call Hloop_QZ_A(ntryL,G1H3(188),ex4(:),G1H1(1),ngZu,m3h3x1(:,114),heltab2x3(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(163),n2h1(207))
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(16),mass4set(:,25),  & 
G1H2(125),G1H2(127),G1H2(375),G1H2(376),G1H2(377),2)
  call HG1shiftOLR(G1H2(127),4,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(17),mass4set(:,6),  & 
G1H2(378),G1H2(379),G1H2(380),G1H2(381),G1H2(382),2)
  call HG1shiftOLR(G1H2(379),4,2)
  call Hloop_QV_A(ntryL,G1H2(136),ex3(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(164),n2h1(208))
  call Hloop_QV_A(ntryL,G1H2(137),ex3(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(165),n2h1(209))
  call Hloop_QV_A(ntryL,G1H2(141),ex3(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(166),n2h1(210))
  call Hloop_QV_A(ntryL,G1H2(142),ex3(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(167),n2h1(211))
  call Hotf_4pt_reduction(G2H2(93),RedSet_4(16),mass4set(:,24),  & 
G1H2(136),G1H2(137),G1H2(141),G1H2(142),G1H2(383),2)
  call HG1shiftOLR(G1H2(137),4,2)
  call Hotf_4pt_reduction(G2H2(97),RedSet_4(17),mass4set(:,8),  & 
G1H2(384),G1H2(385),G1H2(386),G1H2(387),G1H2(388),2)
  call HG1shiftOLR(G1H2(385),4,2)
  call Hloop_QV_A(ntryL,G1H2(152),ex3(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(168),n2h1(212))
  call Hloop_QV_A(ntryL,G1H2(153),ex3(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(169),n2h1(213))
  call Hotf_4pt_reduction(G2H3(42),RedSet_4(45),mass4set(:,24),  & 
G1H3(188),G1H3(238),G1H3(239),G1H3(240),G1H3(241),3)
  call HG1shiftOLR(G1H3(238),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(199),ex4(:),G1H1(1),ngZu,m3h3x1(:,115),heltab2x3(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(170),n2h1(214))
  call Hloop_SA_Q(ntryL,G1H2(157),ex2(:),G1H1(1),ngPbt,m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(171),n2h1(215))
  call Hloop_SA_Q(ntryL,G1H2(158),ex2(:),G1H1(1),ngPbt,m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(172),n2h1(216))
  call Hloop_SA_Q(ntryL,G1H2(196),ex2(:),G1H1(1),ngPbt,m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(173),n2h1(217))
  call Hloop_WA_Q(ntryL,G1H2(162),ex2(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(174),n2h1(218))
  call Hloop_WA_Q(ntryL,G1H2(163),ex2(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(175),n2h1(219))
  call Hloop_WA_Q(ntryL,G1H2(201),ex2(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(176),n2h1(220))
  call Hloop_AV_Q(ntryL,G1H2(167),ex3(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(177),n2h1(221))
  call Hloop_AV_Q(ntryL,G1H2(168),ex3(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(178),n2h1(222))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(20),mass4set(:,25),  & 
G1H2(152),G1H2(153),G1H2(157),G1H2(158),G1H2(196),2)
  call HG1shiftOLR(G1H2(153),4,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(21),mass4set(:,6),  & 
G1H2(162),G1H2(163),G1H2(201),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(163),4,2)
  call Hloop_AV_Q(ntryL,G1H2(178),ex3(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(179),n2h1(223))
  call Hloop_AV_Q(ntryL,G1H2(179),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(180),n2h1(224))
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(20),mass4set(:,24),  & 
G1H2(178),G1H2(179),G1H2(389),G1H2(390),G1H2(391),2)
  call HG1shiftOLR(G1H2(179),4,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(21),mass4set(:,8),  & 
G1H2(392),G1H2(393),G1H2(394),G1H2(395),G1H2(396),2)
  call HG1shiftOLR(G1H2(393),4,2)
  call Hloop_AV_Q(ntryL,G1H2(189),ex3(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(181),n2h1(225))
  call Hloop_AV_Q(ntryL,G1H2(190),ex3(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(182),n2h1(226))
  call Hloop_SA_Q(ntryL,G1H2(194),ex2(:),G1H1(1),ngPbt,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(183),n2h1(227))
  call Hloop_SA_Q(ntryL,G1H2(195),ex2(:),G1H1(1),ngPbt,m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(184),n2h1(228))
  call Hloop_WA_Q(ntryL,G1H2(199),ex2(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(185),n2h1(229))
  call Hloop_WA_Q(ntryL,G1H2(200),ex2(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(186),n2h1(230))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(145),ex2(:),G2tensor(187),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(123),ex2(:),G2tensor(188),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(148),ex2(:),G2tensor(189),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(126),ex2(:),G2tensor(190),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(9),mass4set(:,12),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(42),G1H4(43),4)
  call HG1shiftOLR(G1H4(38),5,4)
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(9),mass4set(:,11),  & 
G1H4(5),G1H4(44),G1H4(47),G1H4(48),G1H4(49),4)
  call HG1shiftOLR(G1H4(44),5,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(9),mass4set(:,10),  & 
G1H4(50),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(53),5,4)
  call Hloop_ZQ_A(ntryL,G1H4(16),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,1),heltab2x4(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(191),n2h1(231))
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(9),mass4set(:,10),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(67),4)
  call HG1shiftOLR(G1H4(60),5,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(3),mass4set(:,12),  & 
G1H4(72),G1H4(68),G1H4(71),G1H4(73),G1H4(76),4)
  call HG1shiftOLR(G1H4(68),6,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(3),mass4set(:,11),  & 
G1H4(65),G1H4(64),G1H4(63),G1H4(2),G1H4(4),4)
  call HG1shiftOLR(G1H4(64),6,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(3),mass4set(:,10),  & 
G1H4(9),G1H4(12),G1H4(17),G1H4(18),G1H4(22),4)
  call HG1shiftOLR(G1H4(12),6,4)
  call Hloop_ZA_Q(ntryL,G1H4(21),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,2),heltab2x4(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(192),n2h1(232))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(3),mass4set(:,10),  & 
G1H4(23),G1H4(28),G1H4(29),G1H4(34),G1H4(35),4)
  call HG1shiftOLR(G1H4(28),6,4)
  call Hotf_4pt_reduction(G2H6(15),RedSet_4(8),mass4set(:,10),  & 
G1H6(84),G1H6(90),G1H6(180),G1H6(96),G1H6(101),6)
  call HG1shiftOLR(G1H6(90),9,6)
  call Hotf_4pt_reduction(G2H6(16),RedSet_4(8),mass4set(:,10),  & 
G1H6(120),G1H6(108),G1H6(102),G1H6(139),G1H6(107),6)
  call HG1shiftOLR(G1H6(108),9,6)
  call Hotf_4pt_reduction(G2H6(17),RedSet_4(6),mass4set(:,2),  & 
G1H6(140),G1H6(113),G1H6(114),G1H6(125),G1H6(144),6)
  call HG1shiftOLR(G1H6(113),9,6)
  call Hotf_4pt_reduction(G2H6(18),RedSet_4(6),mass4set(:,3),  & 
G1H6(132),G1H6(126),G1H6(61),G1H6(131),G1H6(62),6)
  call HG1shiftOLR(G1H6(126),9,6)
  call Hotf_4pt_reduction(G2H6(19),RedSet_4(6),mass4set(:,4),  & 
G1H6(137),G1H6(138),G1H6(143),G1H6(149),G1H6(168),6)
  call HG1shiftOLR(G1H6(138),9,6)
  call Hotf_4pt_reduction(G2H6(23),RedSet_4(6),mass4set(:,5),  & 
G1H6(156),G1H6(150),G1H6(81),G1H6(155),G1H6(82),6)
  call HG1shiftOLR(G1H6(150),9,6)
  call Hotf_4pt_reduction(G2H6(24),RedSet_4(6),mass4set(:,3),  & 
G1H6(161),G1H6(162),G1H6(167),G1H6(173),G1H6(179),6)
  call HG1shiftOLR(G1H6(162),9,6)
  call Hotf_4pt_reduction(G2H6(22),RedSet_4(6),mass4set(:,4),  & 
G1H6(185),G1H6(191),G1H6(209),G1H6(9),G1H6(10),6)
  call HG1shiftOLR(G1H6(191),9,6)
  call Hotf_4pt_reduction(G2H6(25),RedSet_4(2),mass4set(:,10),  & 
G1H6(4),G1H6(26),G1H6(11),G1H6(27),G1H6(17),6)
  call HG1shiftOLR(G1H6(26),10,6)
  call Hotf_4pt_reduction(G2H6(29),RedSet_4(2),mass4set(:,10),  & 
G1H6(28),G1H6(23),G1H6(31),G1H6(29),G1H6(32),6)
  call HG1shiftOLR(G1H6(23),10,6)
  call Hotf_4pt_reduction(G2H6(30),RedSet_4(4),mass4set(:,2),  & 
G1H6(35),G1H6(33),G1H6(116),G1H6(123),G1H6(124),6)
  call HG1shiftOLR(G1H6(33),10,6)
  call Hotf_4pt_reduction(G2H6(28),RedSet_4(4),mass4set(:,3),  & 
G1H6(65),G1H6(34),G1H6(71),G1H6(37),G1H6(77),6)
  call HG1shiftOLR(G1H6(34),10,6)
  call Hotf_4pt_reduction(G2H6(31),RedSet_4(4),mass4set(:,4),  & 
G1H6(38),G1H6(83),G1H6(39),G1H6(89),G1H6(40),6)
  call HG1shiftOLR(G1H6(83),10,6)
  call Hotf_4pt_reduction(G2H6(35),RedSet_4(4),mass4set(:,5),  & 
G1H6(95),G1H6(43),G1H6(136),G1H6(145),G1H6(146),6)
  call HG1shiftOLR(G1H6(43),10,6)
  call Hotf_4pt_reduction(G2H6(46),RedSet_4(4),mass4set(:,3),  & 
G1H6(58),G1H6(67),G1H6(68),G1H6(64),G1H6(80),6)
  call HG1shiftOLR(G1H6(67),10,6)
  call Hotf_4pt_reduction(G2H6(21),RedSet_4(4),mass4set(:,4),  & 
G1H6(87),G1H6(88),G1H6(86),G1H6(105),G1H6(115),6)
  call HG1shiftOLR(G1H6(88),10,6)
  call Hotf_4pt_reduction(G2H3(83),RedSet_4(45),mass4set(:,26),  & 
G1H3(199),G1H3(242),G1H3(243),G1H3(244),G1H3(245),3)
  call HG1shiftOLR(G1H3(242),8,3)
  call Hotf_4pt_reduction(G2H3(84),RedSet_4(45),mass4set(:,27),  & 
G1H3(246),G1H3(247),G1H3(248),G1H3(249),G1H3(250),3)
  call HG1shiftOLR(G1H3(247),8,3)
  call Hotf_4pt_reduction(G2H3(85),RedSet_4(45),mass4set(:,28),  & 
G1H3(251),G1H3(252),G1H3(253),G1H3(254),G1H3(255),3)
  call HG1shiftOLR(G1H3(252),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(86),ex4(:),G2tensor(193),m3h3x1(:,116),heltab2x3(:,:,116))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(87),ex4(:),G2tensor(194),m3h3x1(:,117),heltab2x3(:,:,117))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(88),ex4(:),G2tensor(195),m3h3x1(:,118),heltab2x3(:,:,118))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(89),ex4(:),G2tensor(196),m3h3x1(:,119),heltab2x3(:,:,119))
  call Hotf_4pt_reduction(G2H3(90),RedSet_4(45),mass4set(:,28),  & 
G1H3(256),G1H3(257),G1H3(258),G1H3(259),G1H3(260),3)
  call HG1shiftOLR(G1H3(257),8,3)
  call Hotf_4pt_reduction(G2H3(91),RedSet_4(38),mass4set(:,17),  & 
G1H3(261),G1H3(262),G1H3(263),G1H3(264),G1H3(265),3)
  call HG1shiftOLR(G1H3(262),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(92),ex4(:),G2tensor(197),m3h3x1(:,120),heltab2x3(:,:,120))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(93),ex4(:),G2tensor(198),m3h3x1(:,121),heltab2x3(:,:,121))
  call Hotf_4pt_reduction(G2H3(94),RedSet_4(38),mass4set(:,17),  & 
G1H3(266),G1H3(267),G1H3(268),G1H3(269),G1H3(270),3)
  call HG1shiftOLR(G1H3(267),8,3)
  call Hotf_4pt_reduction(G2H2(113),RedSet_4(41),mass4set(:,17),  & 
G1H2(189),G1H2(190),G1H2(194),G1H2(195),G1H2(199),2)
  call HG1shiftOLR(G1H2(190),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(114),ex3(:),G2tensor(199),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(115),ex3(:),G2tensor(200),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hotf_4pt_reduction(G2H2(116),RedSet_4(41),mass4set(:,17),  & 
G1H2(200),G1H2(397),G1H2(398),G1H2(399),G1H2(400),2)
  call HG1shiftOLR(G1H2(397),4,2)
  call Hotf_4pt_reduction(G2H3(95),RedSet_4(43),mass4set(:,26),  & 
G1H3(271),G1H3(272),G1H3(273),G1H3(274),G1H3(275),3)
  call HG1shiftOLR(G1H3(272),8,3)
  call Hotf_4pt_reduction(G2H3(96),RedSet_4(43),mass4set(:,27),  & 
G1H3(276),G1H3(277),G1H3(278),G1H3(279),G1H3(280),3)
  call HG1shiftOLR(G1H3(277),8,3)
  call Hotf_4pt_reduction(G2H3(97),RedSet_4(43),mass4set(:,28),  & 
G1H3(281),G1H3(282),G1H3(283),G1H3(284),G1H3(285),3)
  call HG1shiftOLR(G1H3(282),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(98),ex4(:),G2tensor(201),m3h3x1(:,122),heltab2x3(:,:,122))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(99),ex4(:),G2tensor(202),m3h3x1(:,123),heltab2x3(:,:,123))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(100),ex4(:),G2tensor(203),m3h3x1(:,124),heltab2x3(:,:,124))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(101),ex4(:),G2tensor(204),m3h3x1(:,125),heltab2x3(:,:,125))
  call Hotf_4pt_reduction(G2H3(102),RedSet_4(43),mass4set(:,28),  & 
G1H3(286),G1H3(287),G1H3(288),G1H3(289),G1H3(290),3)
  call HG1shiftOLR(G1H3(287),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(104),ex4(:),G2tensor(205),m3h3x1(:,126),heltab2x3(:,:,126))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(105),ex4(:),G2tensor(206),m3h3x1(:,127),heltab2x3(:,:,127))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(118),ex3(:),G2tensor(207),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(119),ex3(:),G2tensor(208),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(121),ex2(:),G2tensor(209),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(124),ex2(:),G2tensor(210),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hloop_QZ_A(ntryL,G1H3(120),ex4(:),G1H1(1),ngZd,m3h3x1(:,128),heltab2x3(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(211),n2h1(233))
  call Hloop_QZ_A(ntryL,G1H3(131),ex4(:),G1H1(1),ngZu,m3h3x1(:,129),heltab2x3(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(212),n2h1(234))
  call Hloop_QV_A(ntryL,G1H2(117),ex3(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(213),n2h1(235))
  call Hloop_QV_A(ntryL,G1H2(128),ex3(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(214),n2h1(236))
  call Hloop_AZ_Q(ntryL,G1H3(142),ex4(:),G1H1(1),ngZd,m3h3x1(:,130),heltab2x3(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(215),n2h1(237))
  call Hloop_AZ_Q(ntryL,G1H3(153),ex4(:),G1H1(1),ngZu,m3h3x1(:,131),heltab2x3(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(216),n2h1(238))
  call Hloop_AV_Q(ntryL,G1H2(140),ex3(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(217),n2h1(239))
  call Hloop_AV_Q(ntryL,G1H2(151),ex3(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(218),n2h1(240))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(143),ex2(:),G2tensor(219),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(146),ex2(:),G2tensor(220),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hotf_4pt_reduction(G2H2(155),RedSet_4(36),mass4set(:,16),  & 
G1H2(117),G1H2(128),G1H2(140),G1H2(151),G1H2(401),2)
  call HG1shiftOLR(G1H2(128),4,2)
  call Hloop_QV_A(ntryL,G2H2(157),ex3(:),G2H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(13),n2h1(241))
  call Hloop_QV_A(ntryL,G1H2(39),ex3(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(221),n2h1(242))
  call Hotf_4pt_reduction(G2H2(158),RedSet_4(36),mass4set(:,16),  & 
G1H2(39),G1H2(402),G1H2(403),G1H2(404),G1H2(405),2)
  call HG1shiftOLR(G1H2(402),4,2)
  call Hloop_AV_Q(ntryL,G2H2(160),ex3(:),G2H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(14),n2h1(243))
  call Hloop_AV_Q(ntryL,G1H2(78),ex3(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(222),n2h1(244))
  call Hotf_4pt_reduction(G2H3(127),RedSet_4(29),mass4set(:,16),  & 
G1H3(120),G1H3(131),G1H3(142),G1H3(153),G1H3(291),3)
  call HG1shiftOLR(G1H3(131),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(129),ex4(:),G2H1(1),ngZu,m3h3x1(:,132),heltab2x3(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(15),n2h1(245))
  call Hloop_AZ_Q(ntryL,G1H3(165),ex4(:),G1H1(1),ngZu,m3h3x1(:,133),heltab2x3(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(223),n2h1(246))
  call Hotf_4pt_reduction(G2H3(130),RedSet_4(29),mass4set(:,16),  & 
G1H3(165),G1H3(292),G1H3(293),G1H3(294),G1H3(295),3)
  call HG1shiftOLR(G1H3(292),8,3)
  call Hloop_QZ_A(ntryL,G2H3(132),ex4(:),G2H1(1),ngZu,m3h3x1(:,134),heltab2x3(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(16),n2h1(247))
  call Hloop_QZ_A(ntryL,G1H3(176),ex4(:),G1H1(1),ngZu,m3h3x1(:,135),heltab2x3(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(224),n2h1(248))
  call Hotf_4pt_reduction(G2H3(133),RedSet_4(29),mass4set(:,16),  & 
G1H3(176),G1H3(296),G1H3(297),G1H3(298),G1H3(299),3)
  call HG1shiftOLR(G1H3(296),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(135),ex4(:),G2H1(1),ngZd,m3h3x1(:,136),heltab2x3(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(17),n2h1(249))
  call Hloop_AZ_Q(ntryL,G1H3(187),ex4(:),G1H1(1),ngZd,m3h3x1(:,137),heltab2x3(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(225),n2h1(250))
  call Hotf_4pt_reduction(G2H3(136),RedSet_4(29),mass4set(:,16),  & 
G1H3(187),G1H3(300),G1H3(301),G1H3(302),G1H3(303),3)
  call HG1shiftOLR(G1H3(300),8,3)
  call Hloop_QZ_A(ntryL,G2H3(138),ex4(:),G2H1(1),ngZd,m3h3x1(:,138),heltab2x3(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(18),n2h1(251))
  call Hloop_QZ_A(ntryL,G1H3(198),ex4(:),G1H1(1),ngZd,m3h3x1(:,139),heltab2x3(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(226),n2h1(252))
  call Hotf_4pt_reduction(G2H3(139),RedSet_4(26),mass4set(:,16),  & 
G1H3(198),G1H3(304),G1H3(305),G1H3(306),G1H3(307),3)
  call HG1shiftOLR(G1H3(304),8,3)
  call Hloop_QZ_A(ntryL,G2H3(141),ex4(:),G2H1(1),ngZu,m3h3x1(:,140),heltab2x3(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(19),n2h1(253))
  call Hloop_QZ_A(ntryL,G1H3(42),ex4(:),G1H1(1),ngZu,m3h3x1(:,141),heltab2x3(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(227),n2h1(254))
  call Hloop_QZ_A(ntryL,G1H3(86),ex4(:),G1H1(1),ngZu,m3h3x1(:,142),heltab2x3(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(228),n2h1(255))
  call Hotf_4pt_reduction(G2H3(145),RedSet_4(26),mass4set(:,16),  & 
G1H3(42),G1H3(86),G1H3(308),G1H3(309),G1H3(310),3)
  call HG1shiftOLR(G1H3(86),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(147),ex4(:),G2H1(1),ngZu,m3h3x1(:,143),heltab2x3(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(20),n2h1(256))
  call Hloop_AZ_Q(ntryL,G1H3(130),ex4(:),G1H1(1),ngZu,m3h3x1(:,144),heltab2x3(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(229),n2h1(257))
  call Hloop_AZ_Q(ntryL,G1H3(174),ex4(:),G1H1(1),ngZu,m3h3x1(:,145),heltab2x3(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(230),n2h1(258))
  call Hotf_4pt_reduction(G2H3(151),RedSet_4(26),mass4set(:,16),  & 
G1H3(130),G1H3(174),G1H3(311),G1H3(312),G1H3(313),3)
  call HG1shiftOLR(G1H3(174),8,3)
  call Hloop_QZ_A(ntryL,G2H3(153),ex4(:),G2H1(1),ngZd,m3h3x1(:,146),heltab2x3(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(21),n2h1(259))
  call Hloop_QZ_A(ntryL,G1H3(5),ex4(:),G1H1(1),ngZd,m3h3x1(:,147),heltab2x3(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(231),n2h1(260))
  call Hloop_QZ_A(ntryL,G1H3(16),ex4(:),G1H1(1),ngZd,m3h3x1(:,148),heltab2x3(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(232),n2h1(261))
  call Hotf_4pt_reduction(G2H3(157),RedSet_4(26),mass4set(:,16),  & 
G1H3(5),G1H3(16),G1H3(314),G1H3(315),G1H3(316),3)
  call HG1shiftOLR(G1H3(16),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(159),ex4(:),G2H1(1),ngZd,m3h3x1(:,149),heltab2x3(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(22),n2h1(262))
  call Hloop_AZ_Q(ntryL,G1H3(27),ex4(:),G1H1(1),ngZd,m3h3x1(:,150),heltab2x3(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(233),n2h1(263))
  call Hloop_AZ_Q(ntryL,G1H3(38),ex4(:),G1H1(1),ngZd,m3h3x1(:,151),heltab2x3(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(234),n2h1(264))



end subroutine vamp_2

end module ol_vamp_2_ppvvj_ew_bbxazg_1_/**/REALKIND
